      
      SUBROUTINE AERCON(H2O)
      INCLUDE '../INCLUDECHEM/parNZ.inc'
      INCLUDE '../INCLUDECHEM/parNF.inc'      
 
      DIMENSION H2O(NZ),PH2OL(NZ)
      INCLUDE '../INCLUDECHEM/comSATBLK.inc'
      INCLUDE '../INCLUDECHEM/comSULBLK.inc' 

C
C   THIS SUBROUTINE FINDS THE WEIGHT PERCENT OF H2SO4 IN THE
C   PARTICLES AND THE H2SO4 VAPOR PRESSURE, GIVEN THE TEMPERATURE
C   AND H2O CONCENTRATION AT EACH ALTITUDE.
C
      DO 1 J=1,NZ
   1  PH2OL(J) = ALOG(H2O(J)*P(J))
C
      DO 2 J=1,NZ
      DO 3 K=1,NF
      KS = K
      IF(VH2O(K,J) .LT. PH2OL(J)) GO TO 4
   3  CONTINUE
   4  KS1 = MAX0(KS-1,1)
C
C   PH2OL(J) LIES BETWEEN VH2O(KS,J) AND VH2O(KS1,J)
      FR = 1.
      IF(KS .GT. KS1) FR = (PH2OL(J) - VH2O(KS1,J))/(VH2O(KS,J) -
     2  VH2O(KS1,J))
      FR = AMAX1(FR, 0.)
      FR = AMIN1(FR, 1.)
      FSULF(J) = (FR*FTAB(KS) + (1.-FR)*FTAB(KS1)) * 0.01
      H2SO4L = FR*VH2SO4(KS,J) + (1.-FR)*VH2SO4(KS1,J)
      H2SO4S(J) = EXP(H2SO4L)/P(J)
C-AP
   2  CONTINUE
C
      RETURN
      END
