C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/cldprop.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.1 $
C     created:   $Date: 2002/08/15 18:33:26 $
      SUBROUTINE CLDPROP(ICLDATM)

C     Purpose:  Compute the cloud optical depth(s) for each cloudy
C               layer.

      PARAMETER (MXLAY=203)
      PARAMETER (NBANDS = 16)

      COMMON /CONTROL/   NUMANGS, IOUT, ISTART, IEND, ICLD
      COMMON /PROFILE/   NLAYERS,PAVEL(MXLAY),TAVEL(MXLAY),
     &                   PZ(0:MXLAY),TZ(0:MXLAY)
      COMMON /CLOUDIN/   INFLAG,CLDDAT1(MXLAY),CLDDAT2(MXLAY),
     &                   ICEFLAG,LIQFLAG,CLDDAT3(MXLAY),CLDDAT4(MXLAY)
      COMMON /CLOUDDAT/  NCBANDS,CLDFRAC(MXLAY),TAUCLOUD(MXLAY,NBANDS)

      COMMON /CVRCLD/    HVRCLD

      CHARACTER*15       HVRCLD

      DIMENSION ABSICE0(2), ABSICE1(2,5), ABSICE2(40,16), ABSICE3(27,16)
      DIMENSION ABSLIQ1(58,16)
      DIMENSION ABSCOICE(NBANDS), ABSCOLIQ(NBANDS)
      DIMENSION IPAT(16,0:2)

      DATA EPS /1.E-6/

      DATA IPAT /1,1,1,1,1,1,1,1,1, 1, 1, 1, 1, 1, 1, 1,
     &           1,2,3,3,3,4,4,4,5, 5, 5, 5, 5, 5, 5, 5,
     &           1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16/

C     Explanation of the method for each value of INFLAG.  Values of
C     0 or 1 for INFLAG do not distingish being liquid and ice clouds.
C     INFLAG = 2 does distinguish between liquid and ice clouds, and
C     requires further user input to specify the method to be used to 
C     compute the aborption due to each.
C     INFLAG = 0:  For each cloudy layer, the cloud fraction and (gray)
C                  optical depth are input.  
C     INFLAG = 1:  For each cloudy layer, the cloud fraction and cloud
C                  water path (g/m2) are input.  The (gray) cloud optical 
C                  depth is computed as in CCM2.
C     INFLAG = 2:  For each cloudy layer, the cloud fraction, cloud 
C                  water path (g/m2), and cloud ice fraction are input.
C       ICEFLAG = 0:  The ice effective radius (microns) is input and the
C                     optical depths due to ice clouds are computed as in CCM3.
C       ICEFLAG = 1:  The ice effective radius (microns) is input and the
C                     optical depths due to ice clouds are computed as in 
C                     Ebert and Curry, JGR, 97, 3831-3836 (1992).  The 
C                     spectral regions in this work have been matched with
C                     the spectral bands in RRTM to as great an extent 
C                     as possible:  
C                     E&C 1      IB = 5      RRTM bands 9-16
C                     E&C 2      IB = 4      RRTM bands 6-8
C                     E&C 3      IB = 3      RRTM bands 3-5
C                     E&C 4      IB = 2      RRTM band 2
C                     E&C 5      IB = 1      RRTM band 1
C       ICEFLAG = 2:  The ice effective radius (microns) is input and the
C                     optical depths due to ice clouds are computed as in 
C                     Streamer (reference:  J. Key, Streamer User's Guide, 
C                     Technical Report 96-01, Department of Geography,
C                     Boston University, 85 pp. (1996)).  The values of 
C                     absorption coefficients appropriate for the spectral 
C                     bands of RRTM were obtained by an averaging procedure 
C                     based on the work of J. Pinto (private communication).
C       ICEFLAG = 3: The ice generalized effective size (dge) is input
C                    and the optical depths, are calculated as in
C                    Q. Fu, J. Climate, (1998). Q. Fu provided high resolution
C                    tables which were appropriately averaged for the
C                    bands in RRTM_LW.  Linear interpolation is used to
C                    get the coefficients from the stored tables.
C       LIQFLAG = 0:  The optical depths due to water clouds are computed as
C                     in CCM3.
C       LIQFLAG = 1:  The water droplet effective radius (microns) is input 
C                     and the optical depths due to water clouds are computed 
C                     as in Hu and Stamnes, J., Clim., 6, 728-742, (1993).
C                     The values for absorption coefficients appropriate for
C                     the spectral bands in RRTM have been obtained for a 
C                     range of effective radii by an averaging procedure 
C                     based on the work of J. Pinto (private communication).
C                     Linear interpolation is used to get the absorption 
C                     coefficients for the input effective radius.

C     ABSCLDn is the liquid water absorption coefficient (m2/g). 
C     For INFLAG = 1.
      DATA ABSCLD1 /0.0602410/
C  
C     Everything below is for INFLAG = 2.

C     ABSICEn(J,IB) are the parameters needed to compute the liquid water 
C     absorption coefficient in spectral region IB for ICEFLAG=n.  The 
C     units of ABSICEn(1,IB) are m2/g and ABSICEn(2,IB) has units 
C     (microns (m2/g)).
C     For ICEFLAG = 0.
      DATA ABSICE0 /0.005,  1.0/
C     For ICEFLAG = 1.
      DATA ABSICE1 /0.0036, 1.136,
     &              0.0068, 0.600,
     &              0.0003, 1.338,
     &              0.0016, 1.166,
     &              0.0020, 1.118/

C     For ICEFLAG = 2.  In each band, the absorption
C     coefficients are listed for a range of effective radii from 13.0
C     to 130.0 microns in increments of 3.0 micronS.
      DATA (ABSICE2(I, 1),I=1,40) /
c     BAND  1
     & 5.14983E-02, 4.48625E-02, 4.02686E-02, 3.68149E-02, 3.40738E-02,
     & 3.18135E-02, 2.98958E-02, 2.82323E-02, 2.67636E-02, 2.54480E-02,
     & 2.42551E-02, 2.31626E-02, 2.21531E-02, 2.12133E-02, 2.03326E-02,
     & 1.95024E-02, 1.87159E-02, 1.79673E-02, 1.72518E-02, 1.65654E-02,
     & 1.59048E-02, 1.52671E-02, 1.46496E-02, 1.40504E-02, 1.34674E-02,
     & 1.28990E-02, 1.23437E-02, 1.18003E-02, 1.12677E-02, 1.07447E-02,
     & 1.02304E-02, 9.72402E-02, 9.22482E-02, 8.73208E-02, 8.24520E-02,
     & 7.76359E-02, 7.28675E-02, 6.81419E-02, 6.34547E-02, 5.88019E-02/
      DATA (ABSICE2(I, 2),I=1,40) /
c     BAND  2
     & 3.22897E-02, 3.09157E-02, 2.90110E-02, 2.71254E-02, 2.53953E-02,
     & 2.38417E-02, 2.24523E-02, 2.12069E-02, 2.00852E-02, 1.90693E-02,
     & 1.81438E-02, 1.72961E-02, 1.65155E-02, 1.57933E-02, 1.51221E-02,
     & 1.44956E-02, 1.39088E-02, 1.33571E-02, 1.28369E-02, 1.23447E-02,
     & 1.18780E-02, 1.14342E-02, 1.10112E-02, 1.06072E-02, 1.02205E-02,
     & 9.84965E-02, 9.49343E-02, 9.15068E-02, 8.82038E-02, 8.50161E-02,
     & 8.19355E-02, 7.89546E-02, 7.60667E-02, 7.32657E-02, 7.05461E-02,
     & 6.79028E-02, 6.53312E-02, 6.28270E-02, 6.03865E-02, 5.80060E-02/
      DATA (ABSICE2(I, 3),I=1,40) /
c     BAND  3
     & 7.40267E-02, 6.20910E-02, 5.21679E-02, 4.45314E-02, 3.86442E-02,
     & 3.40273E-02, 3.03365E-02, 2.73324E-02, 2.48477E-02, 2.27633E-02,
     & 2.09930E-02, 1.94731E-02, 1.81556E-02, 1.70038E-02, 1.59891E-02,
     & 1.50893E-02, 1.42863E-02, 1.35658E-02, 1.29161E-02, 1.23275E-02,
     & 1.17920E-02, 1.13030E-02, 1.08548E-02, 1.04426E-02, 1.00625E-02,
     & 9.71086E-02, 9.38475E-02, 9.08155E-02, 8.79900E-02, 8.53511E-02,
     & 8.28816E-02, 8.05661E-02, 7.83910E-02, 7.63443E-02, 7.44153E-02,
     & 7.25944E-02, 7.08730E-02, 6.92435E-02, 6.76988E-02, 6.62327E-02/
      DATA (ABSICE2(I, 4),I=1,40) /
c     BAND  4
     & 8.09482E-02, 6.40329E-02, 5.25076E-02, 4.42894E-02, 3.81839E-02,
     & 3.34926E-02, 2.97879E-02, 2.67959E-02, 2.43340E-02, 2.22761E-02,
     & 2.05328E-02, 1.90387E-02, 1.77453E-02, 1.66157E-02, 1.56213E-02,
     & 1.47399E-02, 1.39537E-02, 1.32484E-02, 1.26124E-02, 1.20363E-02,
     & 1.15122E-02, 1.10335E-02, 1.05947E-02, 1.01911E-02, 9.81870E-02,
     & 9.47417E-02, 9.15453E-02, 8.85722E-02, 8.58005E-02, 8.32106E-02,
     & 8.07857E-02, 7.85106E-02, 7.63723E-02, 7.43588E-02, 7.24599E-02,
     & 7.06660E-02, 6.89689E-02, 6.73609E-02, 6.58354E-02, 6.43862E-02/
      DATA (ABSICE2(I, 5),I=1,40) /
c     BAND  5
     & 8.10777E-02, 6.35697E-02, 5.20266E-02, 4.38836E-02, 3.78526E-02,
     & 3.32186E-02, 2.95544E-02, 2.65895E-02, 2.41444E-02, 2.20959E-02,
     & 2.03564E-02, 1.88623E-02, 1.75659E-02, 1.64311E-02, 1.54302E-02,
     & 1.45411E-02, 1.37465E-02, 1.30323E-02, 1.23873E-02, 1.18019E-02,
     & 1.12685E-02, 1.07805E-02, 1.03325E-02, 9.91992E-02, 9.53875E-02,
     & 9.18561E-02, 8.85758E-02, 8.55213E-02, 8.26706E-02, 8.00042E-02,
     & 7.75053E-02, 7.51588E-02, 7.29515E-02, 7.08716E-02, 6.89086E-02,
     & 6.70531E-02, 6.52966E-02, 6.36317E-02, 6.20515E-02, 6.05498E-02/
      DATA (ABSICE2(I, 6),I=1,40) /
c     BAND  6
     & 6.61740E-02, 5.38236E-02, 4.54802E-02, 3.94365E-02, 3.48396E-02,
     & 3.12148E-02, 2.82761E-02, 2.58407E-02, 2.37859E-02, 2.20264E-02,
     & 2.05009E-02, 1.91641E-02, 1.79820E-02, 1.69281E-02, 1.59821E-02,
     & 1.51275E-02, 1.43513E-02, 1.36427E-02, 1.29928E-02, 1.23945E-02,
     & 1.18416E-02, 1.13288E-02, 1.08519E-02, 1.04069E-02, 9.99070E-02,
     & 9.60044E-02, 9.23366E-02, 8.88822E-02, 8.56223E-02, 8.25401E-02,
     & 7.96209E-02, 7.68516E-02, 7.42203E-02, 7.17165E-02, 6.93308E-02,
     & 6.70546E-02, 6.48801E-02, 6.28005E-02, 6.08094E-02, 5.89009E-02/
      DATA (ABSICE2(I, 7),I=1,40) /
c     BAND  7
     & 5.52562E-02, 4.88283E-02, 4.30724E-02, 3.82802E-02, 3.43292E-02,
     & 3.10514E-02, 2.83027E-02, 2.59715E-02, 2.39725E-02, 2.22413E-02,
     & 2.07282E-02, 1.93950E-02, 1.82116E-02, 1.71543E-02, 1.62039E-02,
     & 1.53450E-02, 1.45650E-02, 1.38534E-02, 1.32017E-02, 1.26024E-02,
     & 1.20496E-02, 1.15379E-02, 1.10629E-02, 1.06207E-02, 1.02081E-02,
     & 9.82207E-02, 9.46019E-02, 9.12020E-02, 8.80017E-02, 8.49836E-02,
     & 8.21324E-02, 7.94344E-02, 7.68776E-02, 7.44509E-02, 7.21446E-02,
     & 6.99498E-02, 6.78585E-02, 6.58634E-02, 6.39580E-02, 6.21362E-02/
      DATA (ABSICE2(I, 8),I=1,40) /
c     BAND  8
     & 6.20471E-02, 5.44758E-02, 4.69365E-02, 4.06841E-02, 3.56613E-02,
     & 3.16211E-02, 2.83372E-02, 2.56338E-02, 2.33801E-02, 2.14788E-02,
     & 1.98576E-02, 1.84615E-02, 1.72488E-02, 1.61871E-02, 1.52509E-02,
     & 1.44201E-02, 1.36784E-02, 1.30128E-02, 1.24125E-02, 1.18688E-02,
     & 1.13742E-02, 1.09227E-02, 1.05089E-02, 1.01287E-02, 9.77805E-02,
     & 9.45389E-02, 9.15339E-02, 8.87415E-02, 8.61405E-02, 8.37126E-02,
     & 8.14417E-02, 7.93136E-02, 7.73155E-02, 7.54364E-02, 7.36663E-02,
     & 7.19963E-02, 7.04183E-02, 6.89253E-02, 6.75109E-02, 6.61690E-02/
      DATA (ABSICE2(I, 9),I=1,40) /
c     BAND  9
     & 6.88653E-02, 5.79604E-02, 4.87166E-02, 4.15742E-02, 3.60675E-02,
     & 3.17549E-02, 2.83140E-02, 2.55193E-02, 2.32129E-02, 2.12825E-02,
     & 1.96465E-02, 1.82448E-02, 1.70322E-02, 1.59741E-02, 1.50438E-02,
     & 1.42203E-02, 1.34867E-02, 1.28295E-02, 1.22379E-02, 1.17027E-02,
     & 1.12165E-02, 1.07732E-02, 1.03674E-02, 9.99477E-02, 9.65152E-02,
     & 9.33441E-02, 9.04067E-02, 8.76790E-02, 8.51399E-02, 8.27712E-02,
     & 8.05569E-02, 7.84829E-02, 7.65367E-02, 7.47071E-02, 7.29845E-02,
     & 7.13599E-02, 6.98256E-02, 6.83744E-02, 6.70000E-02, 6.56967E-02/
      DATA (ABSICE2(I,10),I=1,40) /
c     BAND 10
     & 7.12449E-02, 5.84673E-02, 4.86930E-02, 4.14097E-02, 3.58853E-02,
     & 3.15935E-02, 2.81825E-02, 2.54168E-02, 2.31352E-02, 2.12248E-02,
     & 1.96044E-02, 1.82146E-02, 1.70106E-02, 1.59587E-02, 1.50324E-02,
     & 1.42112E-02, 1.34786E-02, 1.28214E-02, 1.22289E-02, 1.16921E-02,
     & 1.12038E-02, 1.07579E-02, 1.03493E-02, 9.97349E-02, 9.62691E-02,
     & 9.30633E-02, 9.00902E-02, 8.73260E-02, 8.47501E-02, 8.23443E-02,
     & 8.00929E-02, 7.79819E-02, 7.59988E-02, 7.41328E-02, 7.23741E-02,
     & 7.07138E-02, 6.91443E-02, 6.76585E-02, 6.62501E-02, 6.49133E-02/
      DATA (ABSICE2(I,11),I=1,40) /
c     BAND 11
     & 6.94616E-02, 5.69411E-02, 4.75475E-02, 4.05620E-02, 3.52524E-02,
     & 3.11142E-02, 2.78142E-02, 2.51299E-02, 2.29086E-02, 2.10435E-02,
     & 1.94575E-02, 1.80939E-02, 1.69100E-02, 1.58735E-02, 1.49591E-02,
     & 1.41469E-02, 1.34212E-02, 1.27690E-02, 1.21802E-02, 1.16460E-02,
     & 1.11594E-02, 1.07145E-02, 1.03062E-02, 9.93033E-02, 9.58326E-02,
     & 9.26189E-02, 8.96352E-02, 8.68584E-02, 8.42682E-02, 8.18468E-02,
     & 7.95787E-02, 7.74501E-02, 7.54489E-02, 7.35642E-02, 7.17864E-02,
     & 7.01069E-02, 6.85180E-02, 6.70127E-02, 6.55847E-02, 6.42284E-02/
      DATA (ABSICE2(I,12),I=1,40) /
c     BAND 12
     & 4.16254E-02, 3.77421E-02, 3.38756E-02, 3.04822E-02, 2.75940E-02,
     & 2.51477E-02, 2.30677E-02, 2.12868E-02, 1.97502E-02, 1.84139E-02,
     & 1.72433E-02, 1.62106E-02, 1.52939E-02, 1.44753E-02, 1.37403E-02,
     & 1.30772E-02, 1.24762E-02, 1.19292E-02, 1.14294E-02, 1.09711E-02,
     & 1.05495E-02, 1.01605E-02, 9.80044E-02, 9.46635E-02, 9.15557E-02,
     & 8.86578E-02, 8.59499E-02, 8.34141E-02, 8.10351E-02, 7.87988E-02,
     & 7.66933E-02, 7.47074E-02, 7.28317E-02, 7.10572E-02, 6.93762E-02,
     & 6.77817E-02, 6.62673E-02, 6.48272E-02, 6.34561E-02, 6.21494E-02/
      DATA (ABSICE2(I,13),I=1,40) /
c     BAND 13
     & 5.98981E-02, 5.05682E-02, 4.31111E-02, 3.73510E-02, 3.28529E-02,
     & 2.92734E-02, 2.63704E-02, 2.39754E-02, 2.19694E-02, 2.02671E-02,
     & 1.88058E-02, 1.75388E-02, 1.64304E-02, 1.54532E-02, 1.45855E-02,
     & 1.38102E-02, 1.31135E-02, 1.24843E-02, 1.19133E-02, 1.13930E-02,
     & 1.09170E-02, 1.04799E-02, 1.00772E-02, 9.70518E-02, 9.36040E-02,
     & 9.04004E-02, 8.74164E-02, 8.46305E-02, 8.20240E-02, 7.95802E-02,
     & 7.72847E-02, 7.51245E-02, 7.30882E-02, 7.11656E-02, 6.93476E-02,
     & 6.76260E-02, 6.59934E-02, 6.44432E-02, 6.29695E-02, 6.15667E-02/
      DATA (ABSICE2(I,14),I=1,40) /
c     BAND 14
     & 5.42744E-02, 4.68241E-02, 4.05641E-02, 3.55510E-02, 3.15341E-02,
     & 2.82765E-02, 2.55967E-02, 2.33613E-02, 2.14726E-02, 1.98586E-02,
     & 1.84650E-02, 1.72509E-02, 1.61845E-02, 1.52409E-02, 1.44006E-02,
     & 1.36479E-02, 1.29699E-02, 1.23563E-02, 1.17985E-02, 1.12893E-02,
     & 1.08229E-02, 1.03940E-02, 9.99839E-02, 9.63245E-02, 9.29300E-02,
     & 8.97730E-02, 8.68299E-02, 8.40799E-02, 8.15050E-02, 7.90893E-02,
     & 7.68186E-02, 7.46804E-02, 7.26638E-02, 7.07586E-02, 6.89562E-02,
     & 6.72485E-02, 6.56284E-02, 6.40894E-02, 6.26257E-02, 6.12319E-02/
      DATA (ABSICE2(I,15),I=1,40) /
c     BAND 15
     & 3.73465E-02, 3.41219E-02, 3.07977E-02, 2.78321E-02, 2.52812E-02,
     & 2.31034E-02, 2.12397E-02, 1.96355E-02, 1.82448E-02, 1.70304E-02,
     & 1.59626E-02, 1.50174E-02, 1.41756E-02, 1.34217E-02, 1.27430E-02,
     & 1.21291E-02, 1.15713E-02, 1.10625E-02, 1.05966E-02, 1.01685E-02,
     & 9.77387E-02, 9.40902E-02, 9.07076E-02, 8.75632E-02, 8.46332E-02,
     & 8.18968E-02, 7.93356E-02, 7.69337E-02, 7.46768E-02, 7.25524E-02,
     & 7.05493E-02, 6.86576E-02, 6.68684E-02, 6.51737E-02, 6.35662E-02,
     & 6.20396E-02, 6.05879E-02, 5.92059E-02, 5.78887E-02, 5.66319E-02/
      DATA (ABSICE2(I,16),I=1,40) /
c     BAND 16
     & 4.88452E-02, 4.13702E-02, 3.56455E-02, 3.12121E-02, 2.77086E-02,
     & 2.48838E-02, 2.25647E-02, 2.06304E-02, 1.89947E-02, 1.75949E-02,
     & 1.63844E-02, 1.53279E-02, 1.43983E-02, 1.35744E-02, 1.28394E-02,
     & 1.21799E-02, 1.15850E-02, 1.10457E-02, 1.05548E-02, 1.01061E-02,
     & 9.69443E-02, 9.31548E-02, 8.96553E-02, 8.64144E-02, 8.34047E-02,
     & 8.06027E-02, 7.79879E-02, 7.55424E-02, 7.32504E-02, 7.10982E-02,
     & 6.90735E-02, 6.71654E-02, 6.53643E-02, 6.36615E-02, 6.20493E-02,
     & 6.05208E-02, 5.90697E-02, 5.76903E-02, 5.63775E-02, 5.51266E-02/

C ICEFLAG = 3; Fu parameterization. Particle size 10 - 140 micron in 
C increments of 5 microns.
C units = m2/g

      DATA (ABSICE3(I, 1),I=1,27) /
C     BAND  1
     &6.332974E-02,6.378244E-02,5.437510E-02,4.588837E-02,3.920302E-02,
     &3.403119E-02,3.000989E-02,2.685034E-02,2.433955E-02,2.232194E-02,
     &2.068269E-02,1.933577E-02,1.821553E-02,1.727105E-02,1.646212E-02,
     &1.575652E-02,1.512800E-02,1.455493E-02,1.401917E-02,1.350537E-02,
     &1.300036E-02,1.249274E-02,1.197248E-02,1.143072E-02,1.085953E-02,
     &1.025177E-02,9.600909E-03/
      DATA (ABSICE3(I, 2),I=1,27) /
C     BAND  2
     &2.462323E-02,2.756890E-02,2.579222E-02,2.364530E-02,2.173258E-02,
     &2.010595E-02,1.872336E-02,1.753466E-02,1.649768E-02,1.557968E-02,
     &1.475561E-02,1.400638E-02,1.331727E-02,1.267686E-02,1.207616E-02,
     &1.150804E-02,1.096677E-02,1.044774E-02,9.947148E-03,9.461891E-03,
     &8.989386E-03,8.527484E-03,8.074379E-03,7.628550E-03,7.188710E-03,
     &6.753762E-03,6.322773E-03/
      DATA (ABSICE3(I, 3),I=1,27) /
C     BAND  3
     &8.022788E-02,6.492209E-02,5.348182E-02,4.526948E-02,3.914837E-02,
     &3.440466E-02,3.060680E-02,2.748538E-02,2.486523E-02,2.262805E-02,
     &2.069119E-02,1.899521E-02,1.749624E-02,1.616115E-02,1.496441E-02,
     &1.388601E-02,1.290997E-02,1.202338E-02,1.121562E-02,1.047788E-02,
     &9.802740E-03,9.183888E-03,8.615902E-03,8.094069E-03,7.614260E-03,
     &7.172826E-03,6.766512E-03/
      DATA (ABSICE3(I, 4),I=1,27) /
C     BAND  4
     &1.178776E-01,8.471732E-02,6.554247E-02,5.318197E-02,4.457013E-02,
     &3.822756E-02,3.336026E-02,2.950559E-02,2.637624E-02,2.378452E-02,
     &2.160271E-02,1.974083E-02,1.813374E-02,1.673306E-02,1.550210E-02,
     &1.441254E-02,1.344216E-02,1.257326E-02,1.179156E-02,1.108542E-02,
     &1.044524E-02,9.863014E-03,9.332026E-03,8.846582E-03,8.401823E-03,
     &7.993570E-03,7.618208E-03/
      DATA (ABSICE3(I, 5),I=1,27) /
C     BAND  5
     &1.404794E-01,9.677062E-02,7.273440E-02,5.771327E-02,4.751066E-02,
     &4.017043E-02,3.466289E-02,3.039568E-02,2.700430E-02,2.425234E-02,
     &2.197986E-02,2.007482E-02,1.845647E-02,1.706516E-02,1.585589E-02,
     &1.479410E-02,1.385282E-02,1.301073E-02,1.225075E-02,1.155906E-02,
     &1.092438E-02,1.033739E-02,9.790377E-03,9.276870E-03,8.791444E-03,
     &8.329505E-03,7.887150E-03/
      DATA (ABSICE3(I, 6),I=1,27) /
C     BAND  6
     &1.052387E-01,7.887209E-02,6.153397E-02,4.992122E-02,4.174924E-02,
     &3.574907E-02,3.119119E-02,2.763280E-02,2.479138E-02,2.247881E-02,
     &2.056524E-02,1.895828E-02,1.759044E-02,1.641136E-02,1.538265E-02,
     &1.447463E-02,1.366394E-02,1.293199E-02,1.226380E-02,1.164717E-02,
     &1.107208E-02,1.053022E-02,1.001463E-02,9.519491E-03,9.039848E-03,
     &8.571499E-03,8.110838E-03/
      DATA (ABSICE3(I, 7),I=1,27) /
C     BAND  7
     &5.583857E-02,4.976788E-02,4.266408E-02,3.702250E-02,3.263535E-02,
     &2.915895E-02,2.633793E-02,2.399732E-02,2.201732E-02,2.031427E-02,
     &1.882844E-02,1.751623E-02,1.634514E-02,1.529046E-02,1.433314E-02,
     &1.345821E-02,1.265380E-02,1.191031E-02,1.121997E-02,1.057635E-02,
     &9.974143E-03,9.408881E-03,8.876803E-03,8.374704E-03,7.899845E-03,
     &7.449862E-03,7.022701E-03/
      DATA (ABSICE3(I, 8),I=1,27) /
C     BAND  8
     &6.394737E-02,5.205951E-02,4.375506E-02,3.782661E-02,3.336165E-02,
     &2.984377E-02,2.697337E-02,2.456737E-02,2.250822E-02,2.071716E-02,
     &1.913940E-02,1.773561E-02,1.647675E-02,1.534083E-02,1.431087E-02,
     &1.337345E-02,1.251778E-02,1.173507E-02,1.101801E-02,1.036044E-02,
     &9.757123E-03,9.203511E-03,8.695636E-03,8.229988E-03,7.803429E-03,
     &7.413123E-03,7.056498E-03/
      DATA (ABSICE3(I, 9),I=1,27) /
C     BAND  9
     &7.900980E-02,5.899186E-02,4.770637E-02,4.034577E-02,3.508148E-02,
     &3.107412E-02,2.788547E-02,2.526455E-02,2.305725E-02,2.116359E-02,
     &1.951579E-02,1.806620E-02,1.678026E-02,1.563223E-02,1.460249E-02,
     &1.367576E-02,1.283994E-02,1.208526E-02,1.140370E-02,1.078863E-02,
     &1.023443E-02,9.736335E-03,9.290210E-03,8.892454E-03,8.539891E-03,
     &8.229693E-03,7.959315E-03/
      DATA (ABSICE3(I,10),I=1,27) /
C     BAND 10
     &9.432157E-02,6.730786E-02,5.294093E-02,4.390232E-02,3.761405E-02,
     &3.293714E-02,2.929076E-02,2.634763E-02,2.390922E-02,2.184805E-02,
     &2.007844E-02,1.854063E-02,1.719163E-02,1.599968E-02,1.494076E-02,
     &1.399634E-02,1.315189E-02,1.239580E-02,1.171868E-02,1.111281E-02,
     &1.057181E-02,1.009030E-02,9.663715E-03,9.288139E-03,8.960187E-03,
     &8.676907E-03,8.435692E-03/
      DATA (ABSICE3(I,11),I=1,27) /
C     BAND 11
     &9.757094E-02,6.835906E-02,5.316656E-02,4.375198E-02,3.728208E-02,
     &3.252141E-02,2.884520E-02,2.590351E-02,2.348505E-02,2.145467E-02,
     &1.972184E-02,1.822361E-02,1.691486E-02,1.576235E-02,1.474104E-02,
     &1.383168E-02,1.301923E-02,1.229172E-02,1.163954E-02,1.105482E-02,
     &1.053106E-02,1.006285E-02,9.645629E-03,9.275496E-03,8.949117E-03,
     &8.663597E-03,8.416413E-03/
      DATA (ABSICE3(I,12),I=1,27) /
C     BAND 12
     &5.512950E-02,4.111619E-02,3.385117E-02,2.926473E-02,2.602050E-02,
     &2.355060E-02,2.157261E-02,1.993018E-02,1.852967E-02,1.731159E-02,
     &1.623625E-02,1.527615E-02,1.441165E-02,1.362825E-02,1.291505E-02,
     &1.226367E-02,1.166753E-02,1.112139E-02,1.062100E-02,1.016288E-02,
     &9.744123E-03,9.362278E-03,9.015258E-03,8.701263E-03,8.418726E-03,
     &8.166264E-03,7.942646E-03/
      DATA (ABSICE3(I,13),I=1,27) /
C     BAND 13
     &8.103164E-02,5.757455E-02,4.572629E-02,3.840358E-02,3.332393E-02,
     &2.952820E-02,2.654297E-02,2.410754E-02,2.206646E-02,2.032122E-02,
     &1.880627E-02,1.747634E-02,1.629902E-02,1.525056E-02,1.431307E-02,
     &1.347284E-02,1.271913E-02,1.204344E-02,1.143889E-02,1.089988E-02,
     &1.042177E-02,1.000070E-02,9.633403E-03,9.317083E-03,9.049335E-03,
     &8.828068E-03,8.651444E-03/
      DATA (ABSICE3(I,14),I=1,27) /
C     BAND 14
     &8.266644E-02,5.818369E-02,4.595241E-02,3.845456E-02,3.328865E-02,
     &2.945096E-02,2.644799E-02,2.400876E-02,2.197213E-02,2.023622E-02,
     &1.873346E-02,1.741722E-02,1.625431E-02,1.522043E-02,1.429736E-02,
     &1.347121E-02,1.273115E-02,1.206862E-02,1.147677E-02,1.095005E-02,
     &1.048389E-02,1.007450E-02,9.718709E-03,9.413822E-03,9.157542E-03,
     &8.947885E-03,8.783122E-03/
      DATA (ABSICE3(I,15),I=1,27) /
C     BAND 15
     &5.982807E-02,4.388985E-02,3.584859E-02,3.084030E-02,2.732371E-02,
     &2.465782E-02,2.252862E-02,2.076412E-02,1.926229E-02,1.795876E-02,
     &1.681087E-02,1.578928E-02,1.487311E-02,1.404712E-02,1.329989E-02,
     &1.262273E-02,1.200888E-02,1.145302E-02,1.095089E-02,1.049907E-02,
     &1.009471E-02,9.735520E-03,9.419546E-03,9.145155E-03,8.910969E-03,
     &8.715809E-03,8.558662E-03/
      DATA (ABSICE3(I,16),I=1,27) /
C     BAND 16
     &8.678901E-02,5.983594E-02,4.622850E-02,3.795581E-02,3.235360E-02,
     &2.828152E-02,2.516989E-02,2.270240E-02,2.068935E-02,1.901006E-02,
     &1.758409E-02,1.635576E-02,1.528532E-02,1.434360E-02,1.350873E-02,
     &1.276399E-02,1.209636E-02,1.149557E-02,1.095340E-02,1.046320E-02,
     &1.001950E-02,9.617819E-03,9.254389E-03,8.926053E-03,8.630143E-03,
     &8.364376E-03,8.126800E-03/

C     For LIQFLAG = 0.
      DATA ABSLIQ0 /0.0903614/

C     For LIQFLAG = 1.  In each band, the absorption
C     coefficients are listed for a range of effective radii from 2.5
C     to 59.5 microns in increments of 1.0 micron.
      DATA (ABSLIQ1(I, 1),I=1,58) /
c     BAND  1
     & 1.64047E-03, 6.90533E-02, 7.72017E-02, 7.78054E-02, 7.69523E-02,
     & 7.58058E-02, 7.46400E-02, 7.35123E-02, 7.24162E-02, 7.13225E-02,
     & 6.99145E-02, 6.66409E-02, 6.36582E-02, 6.09425E-02, 5.84593E-02,
     & 5.61743E-02, 5.40571E-02, 5.20812E-02, 5.02245E-02, 4.84680E-02,
     & 4.67959E-02, 4.51944E-02, 4.36516E-02, 4.21570E-02, 4.07015E-02,
     & 3.92766E-02, 3.78747E-02, 3.64886E-02, 3.53632E-02, 3.41992E-02,
     & 3.31016E-02, 3.20643E-02, 3.10817E-02, 3.01490E-02, 2.92620E-02,
     & 2.84171E-02, 2.76108E-02, 2.68404E-02, 2.61031E-02, 2.53966E-02,
     & 2.47189E-02, 2.40678E-02, 2.34418E-02, 2.28392E-02, 2.22586E-02,
     & 2.16986E-02, 2.11580E-02, 2.06356E-02, 2.01305E-02, 1.96417E-02,
     & 1.91682E-02, 1.87094E-02, 1.82643E-02, 1.78324E-02, 1.74129E-02,
     & 1.70052E-02, 1.66088E-02, 1.62231E-02/
      DATA (ABSLIQ1(I, 2),I=1,58) /
c     BAND  2
     & 2.19486E-01, 1.80687E-01, 1.59150E-01, 1.44731E-01, 1.33703E-01,
     & 1.24355E-01, 1.15756E-01, 1.07318E-01, 9.86119E-02, 8.92739E-02,
     & 8.34911E-02, 7.70773E-02, 7.15240E-02, 6.66615E-02, 6.23641E-02,
     & 5.85359E-02, 5.51020E-02, 5.20032E-02, 4.91916E-02, 4.66283E-02,
     & 4.42813E-02, 4.21236E-02, 4.01330E-02, 3.82905E-02, 3.65797E-02,
     & 3.49869E-02, 3.35002E-02, 3.21090E-02, 3.08957E-02, 2.97601E-02,
     & 2.86966E-02, 2.76984E-02, 2.67599E-02, 2.58758E-02, 2.50416E-02,
     & 2.42532E-02, 2.35070E-02, 2.27997E-02, 2.21284E-02, 2.14904E-02,
     & 2.08834E-02, 2.03051E-02, 1.97536E-02, 1.92271E-02, 1.87239E-02,
     & 1.82425E-02, 1.77816E-02, 1.73399E-02, 1.69162E-02, 1.65094E-02,
     & 1.61187E-02, 1.57430E-02, 1.53815E-02, 1.50334E-02, 1.46981E-02,
     & 1.43748E-02, 1.40628E-02, 1.37617E-02/
      DATA (ABSLIQ1(I, 3),I=1,58) /
c     BAND  3
     & 2.95174E-01, 2.34765E-01, 1.98038E-01, 1.72114E-01, 1.52083E-01,
     & 1.35654E-01, 1.21613E-01, 1.09252E-01, 9.81263E-02, 8.79448E-02,
     & 8.12566E-02, 7.44563E-02, 6.86374E-02, 6.36042E-02, 5.92094E-02,
     & 5.53402E-02, 5.19087E-02, 4.88455E-02, 4.60951E-02, 4.36124E-02,
     & 4.13607E-02, 3.93096E-02, 3.74338E-02, 3.57119E-02, 3.41261E-02,
     & 3.26610E-02, 3.13036E-02, 3.00425E-02, 2.88497E-02, 2.78077E-02,
     & 2.68317E-02, 2.59158E-02, 2.50545E-02, 2.42430E-02, 2.34772E-02,
     & 2.27533E-02, 2.20679E-02, 2.14181E-02, 2.08011E-02, 2.02145E-02,
     & 1.96561E-02, 1.91239E-02, 1.86161E-02, 1.81311E-02, 1.76673E-02,
     & 1.72234E-02, 1.67981E-02, 1.63903E-02, 1.59989E-02, 1.56230E-02,
     & 1.52615E-02, 1.49138E-02, 1.45791E-02, 1.42565E-02, 1.39455E-02,
     & 1.36455E-02, 1.33559E-02, 1.30761E-02/
      DATA (ABSLIQ1(I, 4),I=1,58) /
c     BAND  4
     & 3.00925E-01, 2.36949E-01, 1.96947E-01, 1.68692E-01, 1.47190E-01,
     & 1.29986E-01, 1.15719E-01, 1.03568E-01, 9.30028E-02, 8.36658E-02,
     & 7.71075E-02, 7.07002E-02, 6.52284E-02, 6.05024E-02, 5.63801E-02,
     & 5.27534E-02, 4.95384E-02, 4.66690E-02, 4.40925E-02, 4.17664E-02,
     & 3.96559E-02, 3.77326E-02, 3.59727E-02, 3.43561E-02, 3.28662E-02,
     & 3.14885E-02, 3.02110E-02, 2.90231E-02, 2.78948E-02, 2.69109E-02,
     & 2.59884E-02, 2.51217E-02, 2.43058E-02, 2.35364E-02, 2.28096E-02,
     & 2.21218E-02, 2.14700E-02, 2.08515E-02, 2.02636E-02, 1.97041E-02,
     & 1.91711E-02, 1.86625E-02, 1.81769E-02, 1.77126E-02, 1.72683E-02,
     & 1.68426E-02, 1.64344E-02, 1.60427E-02, 1.56664E-02, 1.53046E-02,
     & 1.49565E-02, 1.46214E-02, 1.42985E-02, 1.39871E-02, 1.36866E-02,
     & 1.33965E-02, 1.31162E-02, 1.28453E-02/
      DATA (ABSLIQ1(I, 5),I=1,58) /
c     BAND  5
     & 2.64691E-01, 2.12018E-01, 1.78009E-01, 1.53539E-01, 1.34721E-01,
     & 1.19580E-01, 1.06996E-01, 9.62772E-02, 8.69710E-02, 7.87670E-02,
     & 7.29272E-02, 6.70920E-02, 6.20977E-02, 5.77732E-02, 5.39910E-02,
     & 5.06538E-02, 4.76866E-02, 4.50301E-02, 4.26374E-02, 4.04704E-02,
     & 3.84981E-02, 3.66948E-02, 3.50394E-02, 3.35141E-02, 3.21038E-02,
     & 3.07957E-02, 2.95788E-02, 2.84438E-02, 2.73790E-02, 2.64390E-02,
     & 2.55565E-02, 2.47263E-02, 2.39437E-02, 2.32047E-02, 2.25056E-02,
     & 2.18433E-02, 2.12149E-02, 2.06177E-02, 2.00495E-02, 1.95081E-02,
     & 1.89917E-02, 1.84984E-02, 1.80269E-02, 1.75755E-02, 1.71431E-02,
     & 1.67283E-02, 1.63303E-02, 1.59478E-02, 1.55801E-02, 1.52262E-02,
     & 1.48853E-02, 1.45568E-02, 1.42400E-02, 1.39342E-02, 1.36388E-02,
     & 1.33533E-02, 1.30773E-02, 1.28102E-02/
      DATA (ABSLIQ1(I, 6),I=1,58) /
c     BAND  6
     & 8.81182E-02, 1.06745E-01, 9.79753E-02, 8.99625E-02, 8.35200E-02,
     & 7.81899E-02, 7.35939E-02, 6.94696E-02, 6.56266E-02, 6.19148E-02,
     & 5.83355E-02, 5.49306E-02, 5.19642E-02, 4.93325E-02, 4.69659E-02,
     & 4.48148E-02, 4.28431E-02, 4.10231E-02, 3.93332E-02, 3.77563E-02,
     & 3.62785E-02, 3.48882E-02, 3.35758E-02, 3.23333E-02, 3.11536E-02,
     & 3.00310E-02, 2.89601E-02, 2.79365E-02, 2.70502E-02, 2.62618E-02,
     & 2.55025E-02, 2.47728E-02, 2.40726E-02, 2.34013E-02, 2.27583E-02,
     & 2.21422E-02, 2.15522E-02, 2.09869E-02, 2.04453E-02, 1.99260E-02,
     & 1.94280E-02, 1.89501E-02, 1.84913E-02, 1.80506E-02, 1.76270E-02,
     & 1.72196E-02, 1.68276E-02, 1.64500E-02, 1.60863E-02, 1.57357E-02,
     & 1.53975E-02, 1.50710E-02, 1.47558E-02, 1.44511E-02, 1.41566E-02,
     & 1.38717E-02, 1.35960E-02, 1.33290E-02/
      DATA (ABSLIQ1(I, 7),I=1,58) /
c     BAND  7
     & 4.32174E-02, 7.36078E-02, 6.98340E-02, 6.65231E-02, 6.41948E-02,
     & 6.23551E-02, 6.06638E-02, 5.88680E-02, 5.67124E-02, 5.38629E-02,
     & 4.99579E-02, 4.86289E-02, 4.70120E-02, 4.52854E-02, 4.35466E-02,
     & 4.18480E-02, 4.02169E-02, 3.86658E-02, 3.71992E-02, 3.58168E-02,
     & 3.45155E-02, 3.32912E-02, 3.21390E-02, 3.10538E-02, 3.00307E-02,
     & 2.90651E-02, 2.81524E-02, 2.72885E-02, 2.62821E-02, 2.55744E-02,
     & 2.48799E-02, 2.42029E-02, 2.35460E-02, 2.29108E-02, 2.22981E-02,
     & 2.17079E-02, 2.11402E-02, 2.05945E-02, 2.00701E-02, 1.95663E-02,
     & 1.90824E-02, 1.86174E-02, 1.81706E-02, 1.77411E-02, 1.73281E-02,
     & 1.69307E-02, 1.65483E-02, 1.61801E-02, 1.58254E-02, 1.54835E-02,
     & 1.51538E-02, 1.48358E-02, 1.45288E-02, 1.42322E-02, 1.39457E-02,
     & 1.36687E-02, 1.34008E-02, 1.31416E-02/
      DATA (ABSLIQ1(I, 8),I=1,58) /
c     BAND  8
     & 1.41881E-01, 7.15419E-02, 6.30335E-02, 6.11132E-02, 6.01931E-02,
     & 5.92420E-02, 5.78968E-02, 5.58876E-02, 5.28923E-02, 4.84462E-02,
     & 4.60839E-02, 4.56013E-02, 4.45410E-02, 4.31866E-02, 4.17026E-02,
     & 4.01850E-02, 3.86892E-02, 3.72461E-02, 3.58722E-02, 3.45749E-02,
     & 3.33564E-02, 3.22155E-02, 3.11494E-02, 3.01541E-02, 2.92253E-02,
     & 2.83584E-02, 2.75488E-02, 2.67925E-02, 2.57692E-02, 2.50704E-02,
     & 2.43918E-02, 2.37350E-02, 2.31005E-02, 2.24888E-02, 2.18996E-02,
     & 2.13325E-02, 2.07870E-02, 2.02623E-02, 1.97577E-02, 1.92724E-02,
     & 1.88056E-02, 1.83564E-02, 1.79241E-02, 1.75079E-02, 1.71070E-02,
     & 1.67207E-02, 1.63482E-02, 1.59890E-02, 1.56424E-02, 1.53077E-02,
     & 1.49845E-02, 1.46722E-02, 1.43702E-02, 1.40782E-02, 1.37955E-02,
     & 1.35219E-02, 1.32569E-02, 1.30000E-02/
      DATA (ABSLIQ1(I, 9),I=1,58) /
c     BAND  9
     & 6.72726E-02, 6.61013E-02, 6.47866E-02, 6.33780E-02, 6.18985E-02,
     & 6.03335E-02, 5.86136E-02, 5.65876E-02, 5.39839E-02, 5.03536E-02,
     & 4.71608E-02, 4.63630E-02, 4.50313E-02, 4.34526E-02, 4.17876E-02,
     & 4.01261E-02, 3.85171E-02, 3.69860E-02, 3.55442E-02, 3.41954E-02,
     & 3.29384E-02, 3.17693E-02, 3.06832E-02, 2.96745E-02, 2.87374E-02,
     & 2.78662E-02, 2.70557E-02, 2.63008E-02, 2.52450E-02, 2.45424E-02,
     & 2.38656E-02, 2.32144E-02, 2.25885E-02, 2.19873E-02, 2.14099E-02,
     & 2.08554E-02, 2.03230E-02, 1.98116E-02, 1.93203E-02, 1.88482E-02,
     & 1.83944E-02, 1.79578E-02, 1.75378E-02, 1.71335E-02, 1.67440E-02,
     & 1.63687E-02, 1.60069E-02, 1.56579E-02, 1.53210E-02, 1.49958E-02,
     & 1.46815E-02, 1.43778E-02, 1.40841E-02, 1.37999E-02, 1.35249E-02,
     & 1.32585E-02, 1.30004E-02, 1.27502E-02/
      DATA (ABSLIQ1(I,10),I=1,58) /
c     BAND 10
     & 7.97040E-02, 7.63844E-02, 7.36499E-02, 7.13525E-02, 6.93043E-02,
     & 6.72807E-02, 6.50227E-02, 6.22395E-02, 5.86093E-02, 5.37815E-02,
     & 5.14682E-02, 4.97214E-02, 4.77392E-02, 4.56961E-02, 4.36858E-02,
     & 4.17569E-02, 3.99328E-02, 3.82224E-02, 3.66265E-02, 3.51416E-02,
     & 3.37617E-02, 3.24798E-02, 3.12887E-02, 3.01812E-02, 2.91505E-02,
     & 2.81900E-02, 2.72939E-02, 2.64568E-02, 2.54165E-02, 2.46832E-02,
     & 2.39783E-02, 2.33017E-02, 2.26531E-02, 2.20314E-02, 2.14359E-02,
     & 2.08653E-02, 2.03187E-02, 1.97947E-02, 1.92924E-02, 1.88106E-02,
     & 1.83483E-02, 1.79043E-02, 1.74778E-02, 1.70678E-02, 1.66735E-02,
     & 1.62941E-02, 1.59286E-02, 1.55766E-02, 1.52371E-02, 1.49097E-02,
     & 1.45937E-02, 1.42885E-02, 1.39936E-02, 1.37085E-02, 1.34327E-02,
     & 1.31659E-02, 1.29075E-02, 1.26571E-02/
      DATA (ABSLIQ1(I,11),I=1,58) /
c     BAND 11
     & 1.49438E-01, 1.33535E-01, 1.21542E-01, 1.11743E-01, 1.03263E-01,
     & 9.55774E-02, 8.83382E-02, 8.12943E-02, 7.42533E-02, 6.70609E-02,
     & 6.38761E-02, 5.97788E-02, 5.59841E-02, 5.25318E-02, 4.94132E-02,
     & 4.66014E-02, 4.40644E-02, 4.17706E-02, 3.96910E-02, 3.77998E-02,
     & 3.60742E-02, 3.44947E-02, 3.30442E-02, 3.17079E-02, 3.04730E-02,
     & 2.93283E-02, 2.82642E-02, 2.72720E-02, 2.61789E-02, 2.53277E-02,
     & 2.45237E-02, 2.37635E-02, 2.30438E-02, 2.23615E-02, 2.17140E-02,
     & 2.10987E-02, 2.05133E-02, 1.99557E-02, 1.94241E-02, 1.89166E-02,
     & 1.84317E-02, 1.79679E-02, 1.75238E-02, 1.70983E-02, 1.66901E-02,
     & 1.62983E-02, 1.59219E-02, 1.55599E-02, 1.52115E-02, 1.48761E-02,
     & 1.45528E-02, 1.42411E-02, 1.39402E-02, 1.36497E-02, 1.33690E-02,
     & 1.30976E-02, 1.28351E-02, 1.25810E-02/
      DATA (ABSLIQ1(I,12),I=1,58) /
c     BAND 12
     & 3.71985E-02, 3.88586E-02, 3.99070E-02, 4.04351E-02, 4.04610E-02,
     & 3.99834E-02, 3.89953E-02, 3.74886E-02, 3.54551E-02, 3.28870E-02,
     & 3.32576E-02, 3.22444E-02, 3.12384E-02, 3.02584E-02, 2.93146E-02,
     & 2.84120E-02, 2.75525E-02, 2.67361E-02, 2.59618E-02, 2.52280E-02,
     & 2.45327E-02, 2.38736E-02, 2.32487E-02, 2.26558E-02, 2.20929E-02,
     & 2.15579E-02, 2.10491E-02, 2.05648E-02, 1.99749E-02, 1.95704E-02,
     & 1.91731E-02, 1.87839E-02, 1.84032E-02, 1.80315E-02, 1.76689E-02,
     & 1.73155E-02, 1.69712E-02, 1.66362E-02, 1.63101E-02, 1.59928E-02,
     & 1.56842E-02, 1.53840E-02, 1.50920E-02, 1.48080E-02, 1.45318E-02,
     & 1.42631E-02, 1.40016E-02, 1.37472E-02, 1.34996E-02, 1.32586E-02,
     & 1.30239E-02, 1.27954E-02, 1.25728E-02, 1.23559E-02, 1.21445E-02,
     & 1.19385E-02, 1.17376E-02, 1.15417E-02/
      DATA (ABSLIQ1(I,13),I=1,58) /
c     BAND 13
     & 3.11868E-02, 4.48357E-02, 4.90224E-02, 4.96406E-02, 4.86806E-02,
     & 4.69610E-02, 4.48630E-02, 4.25795E-02, 4.02138E-02, 3.78236E-02,
     & 3.74266E-02, 3.60384E-02, 3.47074E-02, 3.34434E-02, 3.22499E-02,
     & 3.11264E-02, 3.00704E-02, 2.90784E-02, 2.81463E-02, 2.72702E-02,
     & 2.64460E-02, 2.56698E-02, 2.49381E-02, 2.42475E-02, 2.35948E-02,
     & 2.29774E-02, 2.23925E-02, 2.18379E-02, 2.11793E-02, 2.07076E-02,
     & 2.02470E-02, 1.97981E-02, 1.93613E-02, 1.89367E-02, 1.85243E-02,
     & 1.81240E-02, 1.77356E-02, 1.73588E-02, 1.69935E-02, 1.66392E-02,
     & 1.62956E-02, 1.59624E-02, 1.56393E-02, 1.53259E-02, 1.50219E-02,
     & 1.47268E-02, 1.44404E-02, 1.41624E-02, 1.38925E-02, 1.36302E-02,
     & 1.33755E-02, 1.31278E-02, 1.28871E-02, 1.26530E-02, 1.24253E-02,
     & 1.22038E-02, 1.19881E-02, 1.17782E-02/
      DATA (ABSLIQ1(I,14),I=1,58) /
c     BAND 14
     & 1.58988E-02, 3.50652E-02, 4.00851E-02, 4.07270E-02, 3.98101E-02,
     & 3.83306E-02, 3.66829E-02, 3.50327E-02, 3.34497E-02, 3.19609E-02,
     & 3.13712E-02, 3.03348E-02, 2.93415E-02, 2.83973E-02, 2.75037E-02,
     & 2.66604E-02, 2.58654E-02, 2.51161E-02, 2.44100E-02, 2.37440E-02,
     & 2.31154E-02, 2.25215E-02, 2.19599E-02, 2.14282E-02, 2.09242E-02,
     & 2.04459E-02, 1.99915E-02, 1.95594E-02, 1.90254E-02, 1.86598E-02,
     & 1.82996E-02, 1.79455E-02, 1.75983E-02, 1.72584E-02, 1.69260E-02,
     & 1.66013E-02, 1.62843E-02, 1.59752E-02, 1.56737E-02, 1.53799E-02,
     & 1.50936E-02, 1.48146E-02, 1.45429E-02, 1.42782E-02, 1.40203E-02,
     & 1.37691E-02, 1.35243E-02, 1.32858E-02, 1.30534E-02, 1.28270E-02,
     & 1.26062E-02, 1.23909E-02, 1.21810E-02, 1.19763E-02, 1.17766E-02,
     & 1.15817E-02, 1.13915E-02, 1.12058E-02/
      DATA (ABSLIQ1(I,15),I=1,58) /
c     BAND 15
     & 5.02079E-03, 2.17615E-02, 2.55449E-02, 2.59484E-02, 2.53650E-02,
     & 2.45281E-02, 2.36843E-02, 2.29159E-02, 2.22451E-02, 2.16716E-02,
     & 2.11451E-02, 2.05817E-02, 2.00454E-02, 1.95372E-02, 1.90567E-02,
     & 1.86028E-02, 1.81742E-02, 1.77693E-02, 1.73866E-02, 1.70244E-02,
     & 1.66815E-02, 1.63563E-02, 1.60477E-02, 1.57544E-02, 1.54755E-02,
     & 1.52097E-02, 1.49564E-02, 1.47146E-02, 1.43684E-02, 1.41728E-02,
     & 1.39762E-02, 1.37797E-02, 1.35838E-02, 1.33891E-02, 1.31961E-02,
     & 1.30051E-02, 1.28164E-02, 1.26302E-02, 1.24466E-02, 1.22659E-02,
     & 1.20881E-02, 1.19131E-02, 1.17412E-02, 1.15723E-02, 1.14063E-02,
     & 1.12434E-02, 1.10834E-02, 1.09264E-02, 1.07722E-02, 1.06210E-02,
     & 1.04725E-02, 1.03269E-02, 1.01839E-02, 1.00436E-02, 9.90593E-03,
     & 9.77080E-03, 9.63818E-03, 9.50800E-03/
      DATA (ABSLIQ1(I,16),I=1,58) /
c     BAND 16
     & 5.64971E-02, 9.04736E-02, 8.11726E-02, 7.05450E-02, 6.20052E-02,
     & 5.54286E-02, 5.03503E-02, 4.63791E-02, 4.32290E-02, 4.06959E-02,
     & 3.74690E-02, 3.52964E-02, 3.33799E-02, 3.16774E-02, 3.01550E-02,
     & 2.87856E-02, 2.75474E-02, 2.64223E-02, 2.53953E-02, 2.44542E-02,
     & 2.35885E-02, 2.27894E-02, 2.20494E-02, 2.13622E-02, 2.07222E-02,
     & 2.01246E-02, 1.95654E-02, 1.90408E-02, 1.84398E-02, 1.80021E-02,
     & 1.75816E-02, 1.71775E-02, 1.67889E-02, 1.64152E-02, 1.60554E-02,
     & 1.57089E-02, 1.53751E-02, 1.50531E-02, 1.47426E-02, 1.44428E-02,
     & 1.41532E-02, 1.38734E-02, 1.36028E-02, 1.33410E-02, 1.30875E-02,
     & 1.28420E-02, 1.26041E-02, 1.23735E-02, 1.21497E-02, 1.19325E-02,
     & 1.17216E-02, 1.15168E-02, 1.13177E-02, 1.11241E-02, 1.09358E-02,
     & 1.07525E-02, 1.05741E-02, 1.04003E-02/
      
      HVRCLD = '$Revision: 3.1 $'

      ICLDATM = 0
      NCBANDS = 1
      DO 3000 LAY = 1, NLAYERS
         IF (CLDFRAC(LAY) .GE. EPS) THEN
            ICLDATM = 1

C           Ice clouds and water clouds combined.
            IF (INFLAG .EQ. 0) THEN
               TAUCLOUD(LAY,1) = CLDDAT1(LAY)
            ELSEIF(INFLAG .EQ. 1) THEN
               CWP = CLDDAT1(LAY)
               TAUCLOUD(LAY,1) = ABSCLD1 * CWP

C           Separate treatement of ice clouds and water clouds.
            ELSEIF(INFLAG .EQ. 2) THEN
               CWP = CLDDAT1(LAY)
               FICE = CLDDAT2(LAY)
               RADICE = CLDDAT3(LAY)

C              Calculation of absorption coefficients due to ice clouds.
               IF (FICE .EQ. 0.0) THEN
                  ABSCOICE(1) = 0.0
                  ICEPAT = 0
               ELSEIF (ICEFLAG .EQ. 0) THEN
                  IF (RADICE .LT. 10.0) STOP 'ICE RADIUS TOO SMALL'
                  ABSCOICE(1) = FICE * (ABSICE0(1) + 
     &                 ABSICE0(2)/RADICE)
                  ICEPAT = 0
               ELSEIF (ICEFLAG .EQ. 1) THEN
                  IF (RADICE .LT. 13.0 .OR. RADICE .GT. 130.) STOP
     &                 'ICE RADIUS OUT OF BOUNDS'
                  NCBANDS = 5
                  DO 2000 IB = 1, NCBANDS
                     ABSCOICE(IB) = FICE * (ABSICE1(1,IB) + 
     &                    ABSICE1(2,IB)/RADICE)
 2000             CONTINUE
                  ICEPAT = 1
               ELSEIF (ICEFLAG .EQ. 2) THEN
                  IF (RADICE .LT. 13.0 .OR. RADICE .GT. 130.) STOP
     &                 'ICE RADIUS OUT OF BOUNDS'
                  NCBANDS = 16
                  FACTOR = (RADICE - 10.)/3.
                  INDEX = INT(FACTOR)
                  IF (INDEX .EQ. 40) INDEX = 39
                  FINT = FACTOR - FLOAT(INDEX)
                  DO 2200 IB = 1, NCBANDS
                     ABSCOICE(IB) = FICE * (ABSICE2(INDEX,IB) + FINT *
     &                    (ABSICE2(INDEX+1,IB) - (ABSICE2(INDEX,IB))))
 2200             CONTINUE
                  ICEPAT = 2
               ELSEIF (ICEFLAG .EQ. 3) THEN
                  IF (RADICE .LT. 10.0 .OR. RADICE .GT. 140.) STOP
     &                 'ICE GENERALIZED EFFECTIVE SIZE OUT OF BOUNDS'
                  NCBANDS = 16
                  FACTOR = (RADICE - 5.)/5.
                  INDEX = INT(FACTOR)
                  IF (INDEX .EQ. 27) INDEX = 26
                  FINT = FACTOR - FLOAT(INDEX)
                  DO 2300 IB = 1, NCBANDS
                     ABSCOICE(IB) = FICE * (ABSICE3(INDEX,IB) + FINT *
     &                    (ABSICE3(INDEX+1,IB) - (ABSICE3(INDEX,IB))))
 2300             CONTINUE
                  ICEPAT = 2
               ENDIF
                  
C              Calculation of absorption coefficients due to water clouds.
               FLIQ = 1. - FICE
               IF (FLIQ .EQ. 0.0) THEN
                  ABSCOLIQ(1) = 0.0
                  LIQPAT = 0
                  IF (ICEPAT .EQ. 1) ICEPAT = 2
               ELSEIF (LIQFLAG .EQ. 0) THEN
                  ABSCOLIQ(1) = FLIQ * ABSLIQ0
                  LIQPAT = 0
                  IF (ICEPAT .EQ. 1) ICEPAT = 2
               ELSEIF (LIQFLAG .EQ. 1) THEN
                  RADLIQ = CLDDAT4(LAY)
                  IF (RADLIQ .LT. 1.5 .OR. RADLIQ .GT. 60.) STOP
     &                 'LIQUID EFFECTIVE RADIUS OUT OF BOUNDS'
                  INDEX = RADLIQ - 1.5
                  IF (INDEX .EQ. 58) INDEX = 57
                  IF (INDEX .EQ. 0) INDEX = 1
                  FINT = RADLIQ - 1.5 - INDEX
                  NCBANDS = 16
                  DO 2400 IB = 1, NCBANDS
                     ABSCOLIQ(IB) = FLIQ * (ABSLIQ1(INDEX,IB) + FINT *
     &                    (ABSLIQ1(INDEX+1,IB) - (ABSLIQ1(INDEX,IB))))
 2400             CONTINUE
                  LIQPAT = 2
               ENDIF

               DO 2800 IB = 1, NCBANDS
                  TAUCLOUD(LAY,IB) = CWP * (ABSCOICE(IPAT(IB,ICEPAT)) +
     &                 ABSCOLIQ(IPAT(IB,LIQPAT)))
 2800          CONTINUE
            ENDIF
         ENDIF
 3000 CONTINUE

      RETURN
      END
