C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB01.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.0 $
C     created:   $Date: 2002/06/03 20:32:58 $

       PARAMETER (MG=16)
       REAL KA(5,13,MG), KB(5,13:59,MG)
       DIMENSION SELFREF(10,MG), FORREF(4,MG)
       REAL KA_MN2(19,MG),KB_MN2(19,MG)

       COMMON /HVRSN1/ HVRKG1

       COMMON /K1/ KA ,KB, FORREF, SELFREF, KA_MN2, KB_MN2

       CHARACTER*15 HVRKG1

       DATA HVRKG1 /'$Revision: 3.0 $'/

C     The array KA contains absorption coefs at the 16 chosen g-values 
C     for a range of pressure levels > ~100mb and temperatures.  The first
C     index in the array, JT, which runs from 1 to 5, corresponds to 
C     different temperatures.  More specifically, JT = 3 means that the 
C     data are for the corresponding TREF for this  pressure level, 
C     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
C     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
C     index, JP, runs from 1 to 13 and refers to the corresponding 
C     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
C     The third index, IG, goes from 1 to 16, and tells us which 
C     g-interval the absorption coefficients are for.

      DATA (KA(JT, 1, 1),JT=1,5) /
     &1.1936E-01,1.2127E-01,1.2290E-01,1.2324E-01,1.2302E-01/
      DATA (KA(JT, 2, 1),JT=1,5) /
     &9.3666E-02,9.6336E-02,9.8457E-02,9.9155E-02,9.9330E-02/
      DATA (KA(JT, 3, 1),JT=1,5) /
     &7.3480E-02,7.5571E-02,7.7998E-02,7.9619E-02,8.0000E-02/
      DATA (KA(JT, 4, 1),JT=1,5) /
     &5.8417E-02,6.0062E-02,6.2150E-02,6.4024E-02,6.4943E-02/
      DATA (KA(JT, 5, 1),JT=1,5) /
     &4.6742E-02,4.8171E-02,4.9840E-02,5.1580E-02,5.2974E-02/
      DATA (KA(JT, 6, 1),JT=1,5) /
     &3.7093E-02,3.8712E-02,4.0031E-02,4.1473E-02,4.2868E-02/
      DATA (KA(JT, 7, 1),JT=1,5) /
     &2.9515E-02,3.1114E-02,3.2344E-02,3.3496E-02,3.4715E-02/
      DATA (KA(JT, 8, 1),JT=1,5) /
     &2.3548E-02,2.5012E-02,2.6176E-02,2.7253E-02,2.8263E-02/
      DATA (KA(JT, 9, 1),JT=1,5) /
     &1.9136E-02,2.0420E-02,2.1607E-02,2.2607E-02,2.3502E-02/
      DATA (KA(JT,10, 1),JT=1,5) /
     &1.6947E-02,1.8986E-02,2.0617E-02,2.1896E-02,2.2928E-02/
      DATA (KA(JT,11, 1),JT=1,5) /
     &1.4724E-02,1.6490E-02,1.8468E-02,1.9875E-02,2.1095E-02/
      DATA (KA(JT,12, 1),JT=1,5) /
     &1.2332E-02,1.3992E-02,1.5549E-02,1.7137E-02,1.8190E-02/
      DATA (KA(JT,13, 1),JT=1,5) /
     &1.0144E-02,1.1539E-02,1.2861E-02,1.4225E-02,1.5224E-02/
      DATA (KA(JT, 1, 2),JT=1,5) /
     &3.5138E-01,3.5502E-01,3.5774E-01,3.5894E-01,3.5740E-01/
      DATA (KA(JT, 2, 2),JT=1,5) /
     &2.8740E-01,2.8961E-01,2.9119E-01,2.9268E-01,2.9128E-01/
      DATA (KA(JT, 3, 2),JT=1,5) /
     &2.3142E-01,2.3495E-01,2.3595E-01,2.3731E-01,2.3828E-01/
      DATA (KA(JT, 4, 2),JT=1,5) /
     &1.8684E-01,1.9090E-01,1.9387E-01,1.9355E-01,1.9518E-01/
      DATA (KA(JT, 5, 2),JT=1,5) /
     &1.5108E-01,1.5525E-01,1.5832E-01,1.5904E-01,1.5962E-01/
      DATA (KA(JT, 6, 2),JT=1,5) /
     &1.2219E-01,1.2585E-01,1.2901E-01,1.3090E-01,1.3158E-01/
      DATA (KA(JT, 7, 2),JT=1,5) /
     &9.8743E-02,1.0185E-01,1.0506E-01,1.0763E-01,1.0820E-01/
      DATA (KA(JT, 8, 2),JT=1,5) /
     &7.9966E-02,8.2922E-02,8.5859E-02,8.8462E-02,8.9282E-02/
      DATA (KA(JT, 9, 2),JT=1,5) /
     &6.5726E-02,6.8954E-02,7.1786E-02,7.3678E-02,7.5233E-02/
      DATA (KA(JT,10, 2),JT=1,5) /
     &6.0011E-02,6.2230E-02,6.5254E-02,6.7031E-02,6.9052E-02/
      DATA (KA(JT,11, 2),JT=1,5) /
     &5.5743E-02,5.7099E-02,5.8802E-02,6.0875E-02,6.2690E-02/
      DATA (KA(JT,12, 2),JT=1,5) /
     &4.9598E-02,5.1234E-02,5.2659E-02,5.3951E-02,5.5431E-02/
      DATA (KA(JT,13, 2),JT=1,5) /
     &4.1938E-02,4.3540E-02,4.4990E-02,4.6074E-02,4.6999E-02/
      DATA (KA(JT, 1, 3),JT=1,5) /
     &8.4590E-01,8.4151E-01,8.3682E-01,8.3729E-01,8.3944E-01/
      DATA (KA(JT, 2, 3),JT=1,5) /
     &6.8809E-01,6.8696E-01,6.8512E-01,6.8470E-01,6.8864E-01/
      DATA (KA(JT, 3, 3),JT=1,5) /
     &5.6065E-01,5.5891E-01,5.5871E-01,5.5784E-01,5.6029E-01/
      DATA (KA(JT, 4, 3),JT=1,5) /
     &4.6097E-01,4.6021E-01,4.5874E-01,4.6110E-01,4.6088E-01/
      DATA (KA(JT, 5, 3),JT=1,5) /
     &3.8076E-01,3.8128E-01,3.8007E-01,3.8126E-01,3.8214E-01/
      DATA (KA(JT, 6, 3),JT=1,5) /
     &3.1396E-01,3.1576E-01,3.1554E-01,3.1478E-01,3.1602E-01/
      DATA (KA(JT, 7, 3),JT=1,5) /
     &2.5841E-01,2.6039E-01,2.6160E-01,2.6034E-01,2.6147E-01/
      DATA (KA(JT, 8, 3),JT=1,5) /
     &2.1354E-01,2.1540E-01,2.1664E-01,2.1675E-01,2.1689E-01/
      DATA (KA(JT, 9, 3),JT=1,5) /
     &1.8409E-01,1.8340E-01,1.8423E-01,1.8535E-01,1.8550E-01/
      DATA (KA(JT,10, 3),JT=1,5) /
     &1.7687E-01,1.8149E-01,1.8138E-01,1.8043E-01,1.8050E-01/
      DATA (KA(JT,11, 3),JT=1,5) /
     &1.6660E-01,1.6980E-01,1.7005E-01,1.7156E-01,1.6983E-01/
      DATA (KA(JT,12, 3),JT=1,5) /
     &1.4699E-01,1.5037E-01,1.5032E-01,1.5012E-01,1.5041E-01/
      DATA (KA(JT,13, 3),JT=1,5) /
     &1.2497E-01,1.2733E-01,1.2732E-01,1.2710E-01,1.2722E-01/
      DATA (KA(JT, 1, 4),JT=1,5) /
     &1.8528E+00,1.8358E+00,1.8100E+00,1.7728E+00,1.7348E+00/
      DATA (KA(JT, 2, 4),JT=1,5) /
     &1.5191E+00,1.5067E+00,1.4864E+00,1.4586E+00,1.4273E+00/
      DATA (KA(JT, 3, 4),JT=1,5) /
     &1.2421E+00,1.2332E+00,1.2184E+00,1.1999E+00,1.1763E+00/
      DATA (KA(JT, 4, 4),JT=1,5) /
     &1.0235E+00,1.0199E+00,1.0105E+00,9.9649E-01,9.8141E-01/
      DATA (KA(JT, 5, 4),JT=1,5) /
     &8.4444E-01,8.4579E-01,8.4104E-01,8.3201E-01,8.2148E-01/
      DATA (KA(JT, 6, 4),JT=1,5) /
     &6.9623E-01,7.0066E-01,6.9879E-01,6.9507E-01,6.8745E-01/
      DATA (KA(JT, 7, 4),JT=1,5) /
     &5.7271E-01,5.7848E-01,5.7971E-01,5.7773E-01,5.7376E-01/
      DATA (KA(JT, 8, 4),JT=1,5) /
     &4.7082E-01,4.7730E-01,4.8061E-01,4.7996E-01,4.7783E-01/
      DATA (KA(JT, 9, 4),JT=1,5) /
     &3.8997E-01,3.9821E-01,4.0249E-01,4.0315E-01,4.0145E-01/
      DATA (KA(JT,10, 4),JT=1,5) /
     &3.5012E-01,3.4335E-01,3.3833E-01,3.3654E-01,3.3448E-01/
      DATA (KA(JT,11, 4),JT=1,5) /
     &3.1060E-01,3.1084E-01,3.0440E-01,2.9201E-01,2.8482E-01/
      DATA (KA(JT,12, 4),JT=1,5) /
     &2.7883E-01,2.7190E-01,2.6805E-01,2.5917E-01,2.4860E-01/
      DATA (KA(JT,13, 4),JT=1,5) /
     &2.3244E-01,2.2666E-01,2.2365E-01,2.1647E-01,2.0828E-01/
      DATA (KA(JT, 1, 5),JT=1,5) /
     &3.3225E+00,3.2784E+00,3.2423E+00,3.2074E+00,3.1704E+00/
      DATA (KA(JT, 2, 5),JT=1,5) /
     &2.7581E+00,2.7256E+00,2.6962E+00,2.6686E+00,2.6375E+00/
      DATA (KA(JT, 3, 5),JT=1,5) /
     &2.2798E+00,2.2570E+00,2.2330E+00,2.2089E+00,2.1829E+00/
      DATA (KA(JT, 4, 5),JT=1,5) /
     &1.8979E+00,1.8796E+00,1.8601E+00,1.8393E+00,1.8181E+00/
      DATA (KA(JT, 5, 5),JT=1,5) /
     &1.5861E+00,1.5695E+00,1.5550E+00,1.5372E+00,1.5203E+00/
      DATA (KA(JT, 6, 5),JT=1,5) /
     &1.3252E+00,1.3124E+00,1.3013E+00,1.2872E+00,1.2740E+00/
      DATA (KA(JT, 7, 5),JT=1,5) /
     &1.1027E+00,1.0966E+00,1.0870E+00,1.0776E+00,1.0667E+00/
      DATA (KA(JT, 8, 5),JT=1,5) /
     &9.1563E-01,9.1410E-01,9.0764E-01,8.9982E-01,8.9251E-01/
      DATA (KA(JT, 9, 5),JT=1,5) /
     &7.6595E-01,7.6784E-01,7.6494E-01,7.5888E-01,7.5288E-01/
      DATA (KA(JT,10, 5),JT=1,5) /
     &6.3388E-01,6.4169E-01,6.4724E-01,6.4562E-01,6.3971E-01/
      DATA (KA(JT,11, 5),JT=1,5) /
     &5.2794E-01,5.2411E-01,5.2455E-01,5.2936E-01,5.2927E-01/
      DATA (KA(JT,12, 5),JT=1,5) /
     &4.3721E-01,4.3826E-01,4.3490E-01,4.3598E-01,4.3794E-01/
      DATA (KA(JT,13, 5),JT=1,5) /
     &3.6693E-01,3.6670E-01,3.6374E-01,3.6513E-01,3.6694E-01/
      DATA (KA(JT, 1, 6),JT=1,5) /
     &6.6283E+00,6.5357E+00,6.4205E+00,6.3046E+00,6.1937E+00/
      DATA (KA(JT, 2, 6),JT=1,5) /
     &5.5921E+00,5.5122E+00,5.4227E+00,5.3355E+00,5.2548E+00/
      DATA (KA(JT, 3, 6),JT=1,5) /
     &4.6918E+00,4.6295E+00,4.5667E+00,4.5016E+00,4.4390E+00/
      DATA (KA(JT, 4, 6),JT=1,5) /
     &3.9477E+00,3.9046E+00,3.8607E+00,3.8148E+00,3.7628E+00/
      DATA (KA(JT, 5, 6),JT=1,5) /
     &3.3255E+00,3.2963E+00,3.2647E+00,3.2299E+00,3.1875E+00/
      DATA (KA(JT, 6, 6),JT=1,5) /
     &2.7972E+00,2.7784E+00,2.7561E+00,2.7282E+00,2.6941E+00/
      DATA (KA(JT, 7, 6),JT=1,5) /
     &2.3458E+00,2.3342E+00,2.3185E+00,2.2969E+00,2.2704E+00/
      DATA (KA(JT, 8, 6),JT=1,5) /
     &1.9572E+00,1.9527E+00,1.9423E+00,1.9266E+00,1.9056E+00/
      DATA (KA(JT, 9, 6),JT=1,5) /
     &1.6385E+00,1.6357E+00,1.6281E+00,1.6171E+00,1.6000E+00/
      DATA (KA(JT,10, 6),JT=1,5) /
     &1.4144E+00,1.4143E+00,1.4078E+00,1.4009E+00,1.3895E+00/
      DATA (KA(JT,11, 6),JT=1,5) /
     &1.1820E+00,1.1847E+00,1.1842E+00,1.1773E+00,1.1681E+00/
      DATA (KA(JT,12, 6),JT=1,5) /
     &9.7725E-01,9.8091E-01,9.8204E-01,9.7703E-01,9.7159E-01/
      DATA (KA(JT,13, 6),JT=1,5) /
     &8.1815E-01,8.2185E-01,8.2056E-01,8.1693E-01,8.1119E-01/
      DATA (KA(JT, 1, 7),JT=1,5) /
     &1.4313E+01,1.4082E+01,1.3850E+01,1.3623E+01,1.3382E+01/
      DATA (KA(JT, 2, 7),JT=1,5) /
     &1.2515E+01,1.2314E+01,1.2108E+01,1.1882E+01,1.1633E+01/
      DATA (KA(JT, 3, 7),JT=1,5) /
     &1.0802E+01,1.0631E+01,1.0439E+01,1.0228E+01,1.0005E+01/
      DATA (KA(JT, 4, 7),JT=1,5) /
     &9.2958E+00,9.1469E+00,8.9753E+00,8.7884E+00,8.6020E+00/
      DATA (KA(JT, 5, 7),JT=1,5) /
     &7.9646E+00,7.8400E+00,7.6929E+00,7.5385E+00,7.3901E+00/
      DATA (KA(JT, 6, 7),JT=1,5) /
     &6.7986E+00,6.6983E+00,6.5761E+00,6.4518E+00,6.3346E+00/
      DATA (KA(JT, 7, 7),JT=1,5) /
     &5.7703E+00,5.6909E+00,5.5962E+00,5.4989E+00,5.4062E+00/
      DATA (KA(JT, 8, 7),JT=1,5) /
     &4.8763E+00,4.8159E+00,4.7441E+00,4.6692E+00,4.5978E+00/
      DATA (KA(JT, 9, 7),JT=1,5) /
     &4.0868E+00,4.0475E+00,3.9918E+00,3.9346E+00,3.8784E+00/
      DATA (KA(JT,10, 7),JT=1,5) /
     &3.5589E+00,3.5215E+00,3.4698E+00,3.4096E+00,3.3531E+00/
      DATA (KA(JT,11, 7),JT=1,5) /
     &3.0702E+00,3.0357E+00,2.9927E+00,2.9456E+00,2.8950E+00/
      DATA (KA(JT,12, 7),JT=1,5) /
     &2.6022E+00,2.5722E+00,2.5392E+00,2.5002E+00,2.4548E+00/
      DATA (KA(JT,13, 7),JT=1,5) /
     &2.1727E+00,2.1507E+00,2.1220E+00,2.0892E+00,2.0541E+00/
      DATA (KA(JT, 1, 8),JT=1,5) /
     &3.4174E+01,3.3741E+01,3.3273E+01,3.2762E+01,3.2231E+01/
      DATA (KA(JT, 2, 8),JT=1,5) /
     &3.1501E+01,3.1077E+01,3.0621E+01,3.0167E+01,2.9717E+01/
      DATA (KA(JT, 3, 8),JT=1,5) /
     &2.8624E+01,2.8247E+01,2.7846E+01,2.7455E+01,2.7037E+01/
      DATA (KA(JT, 4, 8),JT=1,5) /
     &2.5860E+01,2.5530E+01,2.5179E+01,2.4813E+01,2.4424E+01/
      DATA (KA(JT, 5, 8),JT=1,5) /
     &2.3133E+01,2.2868E+01,2.2552E+01,2.2222E+01,2.1874E+01/
      DATA (KA(JT, 6, 8),JT=1,5) /
     &2.0417E+01,2.0203E+01,1.9954E+01,1.9685E+01,1.9370E+01/
      DATA (KA(JT, 7, 8),JT=1,5) /
     &1.7808E+01,1.7656E+01,1.7468E+01,1.7234E+01,1.6957E+01/
      DATA (KA(JT, 8, 8),JT=1,5) /
     &1.5349E+01,1.5257E+01,1.5109E+01,1.4918E+01,1.4683E+01/
      DATA (KA(JT, 9, 8),JT=1,5) /
     &1.3085E+01,1.3031E+01,1.2930E+01,1.2779E+01,1.2590E+01/
      DATA (KA(JT,10, 8),JT=1,5) /
     &1.0971E+01,1.0917E+01,1.0852E+01,1.0748E+01,1.0603E+01/
      DATA (KA(JT,11, 8),JT=1,5) /
     &9.5673E+00,9.4985E+00,9.4337E+00,9.3153E+00,9.1800E+00/
      DATA (KA(JT,12, 8),JT=1,5) /
     &8.2885E+00,8.2471E+00,8.1591E+00,8.0541E+00,7.9348E+00/
      DATA (KA(JT,13, 8),JT=1,5) /
     &7.1017E+00,7.0462E+00,6.9629E+00,6.8569E+00,6.7518E+00/
      DATA (KA(JT, 1, 9),JT=1,5) /
     &9.9761E+01,9.8762E+01,9.7605E+01,9.6340E+01,9.4995E+01/
      DATA (KA(JT, 2, 9),JT=1,5) /
     &9.9948E+01,9.8866E+01,9.7644E+01,9.6363E+01,9.4985E+01/
      DATA (KA(JT, 3, 9),JT=1,5) /
     &9.9007E+01,9.8007E+01,9.6838E+01,9.5570E+01,9.4251E+01/
      DATA (KA(JT, 4, 9),JT=1,5) /
     &9.6662E+01,9.5791E+01,9.4804E+01,9.3746E+01,9.2558E+01/
      DATA (KA(JT, 5, 9),JT=1,5) /
     &9.3093E+01,9.2470E+01,9.1704E+01,9.0779E+01,8.9739E+01/
      DATA (KA(JT, 6, 9),JT=1,5) /
     &8.8508E+01,8.8114E+01,8.7530E+01,8.6816E+01,8.5948E+01/
      DATA (KA(JT, 7, 9),JT=1,5) /
     &8.2974E+01,8.2771E+01,8.2394E+01,8.1879E+01,8.1118E+01/
      DATA (KA(JT, 8, 9),JT=1,5) /
     &7.6684E+01,7.6645E+01,7.6457E+01,7.6020E+01,7.5326E+01/
      DATA (KA(JT, 9, 9),JT=1,5) /
     &6.9973E+01,7.0055E+01,6.9978E+01,6.9596E+01,6.8941E+01/
      DATA (KA(JT,10, 9),JT=1,5) /
     &6.2676E+01,6.2928E+01,6.2907E+01,6.2549E+01,6.1993E+01/
      DATA (KA(JT,11, 9),JT=1,5) /
     &5.5263E+01,5.5480E+01,5.5306E+01,5.4944E+01,5.4442E+01/
      DATA (KA(JT,12, 9),JT=1,5) /
     &4.8636E+01,4.8624E+01,4.8458E+01,4.8148E+01,4.7712E+01/
      DATA (KA(JT,13, 9),JT=1,5) /
     &4.2167E+01,4.2169E+01,4.2037E+01,4.1794E+01,4.1453E+01/
      DATA (KA(JT, 1,10),JT=1,5) /
     &2.2059E+02,2.1997E+02,2.1921E+02,2.1843E+02,2.1743E+02/
      DATA (KA(JT, 2,10),JT=1,5) /
     &2.3102E+02,2.3132E+02,2.3151E+02,2.3081E+02,2.3008E+02/
      DATA (KA(JT, 3,10),JT=1,5) /
     &2.4111E+02,2.4197E+02,2.4166E+02,2.4016E+02,2.3836E+02/
      DATA (KA(JT, 4,10),JT=1,5) /
     &2.5158E+02,2.5229E+02,2.5082E+02,2.4795E+02,2.4522E+02/
      DATA (KA(JT, 5,10),JT=1,5) /
     &2.5765E+02,2.5772E+02,2.5582E+02,2.5268E+02,2.4923E+02/
      DATA (KA(JT, 6,10),JT=1,5) /
     &2.5856E+02,2.5749E+02,2.5502E+02,2.5166E+02,2.4826E+02/
      DATA (KA(JT, 7,10),JT=1,5) /
     &2.5368E+02,2.5237E+02,2.4999E+02,2.4711E+02,2.4470E+02/
      DATA (KA(JT, 8,10),JT=1,5) /
     &2.4476E+02,2.4415E+02,2.4213E+02,2.4060E+02,2.3968E+02/
      DATA (KA(JT, 9,10),JT=1,5) /
     &2.3178E+02,2.3169E+02,2.3048E+02,2.3066E+02,2.3132E+02/
      DATA (KA(JT,10,10),JT=1,5) /
     &2.1736E+02,2.1726E+02,2.1730E+02,2.1880E+02,2.1934E+02/
      DATA (KA(JT,11,10),JT=1,5) /
     &2.0114E+02,2.0172E+02,2.0351E+02,2.0457E+02,2.0387E+02/
      DATA (KA(JT,12,10),JT=1,5) /
     &1.8488E+02,1.8650E+02,1.8715E+02,1.8619E+02,1.8458E+02/
      DATA (KA(JT,13,10),JT=1,5) /
     &1.7142E+02,1.7281E+02,1.7236E+02,1.7114E+02,1.6934E+02/
      DATA (KA(JT, 1,11),JT=1,5) /
     &2.9459E+02,2.9267E+02,2.9151E+02,2.8931E+02,2.8695E+02/
      DATA (KA(JT, 2,11),JT=1,5) /
     &3.1654E+02,3.1722E+02,3.1773E+02,3.1519E+02,3.1185E+02/
      DATA (KA(JT, 3,11),JT=1,5) /
     &3.3345E+02,3.3361E+02,3.3487E+02,3.3474E+02,3.3330E+02/
      DATA (KA(JT, 4,11),JT=1,5) /
     &3.4222E+02,3.4143E+02,3.4230E+02,3.4254E+02,3.4132E+02/
      DATA (KA(JT, 5,11),JT=1,5) /
     &3.5206E+02,3.5057E+02,3.4997E+02,3.4857E+02,3.4588E+02/
      DATA (KA(JT, 6,11),JT=1,5) /
     &3.6028E+02,3.6070E+02,3.6119E+02,3.5790E+02,3.5262E+02/
      DATA (KA(JT, 7,11),JT=1,5) /
     &3.6620E+02,3.6652E+02,3.6631E+02,3.6276E+02,3.5799E+02/
      DATA (KA(JT, 8,11),JT=1,5) /
     &3.6855E+02,3.6845E+02,3.6741E+02,3.6316E+02,3.5815E+02/
      DATA (KA(JT, 9,11),JT=1,5) /
     &3.6490E+02,3.6506E+02,3.6353E+02,3.5922E+02,3.5455E+02/
      DATA (KA(JT,10,11),JT=1,5) /
     &3.5317E+02,3.5433E+02,3.5339E+02,3.5013E+02,3.4719E+02/
      DATA (KA(JT,11,11),JT=1,5) /
     &3.3639E+02,3.3748E+02,3.3591E+02,3.3444E+02,3.3466E+02/
      DATA (KA(JT,12,11),JT=1,5) /
     &3.1388E+02,3.1454E+02,3.1501E+02,3.1656E+02,3.1666E+02/
      DATA (KA(JT,13,11),JT=1,5) /
     &2.9044E+02,2.9107E+02,2.9274E+02,2.9324E+02,2.9124E+02/
      DATA (KA(JT, 1,12),JT=1,5) /
     &3.8243E+02,3.8335E+02,3.8560E+02,3.8967E+02,3.9390E+02/
      DATA (KA(JT, 2,12),JT=1,5) /
     &4.2476E+02,4.2018E+02,4.1643E+02,4.1764E+02,4.1841E+02/
      DATA (KA(JT, 3,12),JT=1,5) /
     &4.5902E+02,4.5366E+02,4.4789E+02,4.4616E+02,4.4366E+02/
      DATA (KA(JT, 4,12),JT=1,5) /
     &4.8576E+02,4.8192E+02,4.7838E+02,4.7712E+02,4.7436E+02/
      DATA (KA(JT, 5,12),JT=1,5) /
     &5.0548E+02,5.0130E+02,4.9886E+02,4.9965E+02,4.9992E+02/
      DATA (KA(JT, 6,12),JT=1,5) /
     &5.2714E+02,5.1902E+02,5.1379E+02,5.1543E+02,5.1780E+02/
      DATA (KA(JT, 7,12),JT=1,5) /
     &5.5149E+02,5.4136E+02,5.3395E+02,5.3343E+02,5.3337E+02/
      DATA (KA(JT, 8,12),JT=1,5) /
     &5.7260E+02,5.6332E+02,5.5702E+02,5.5596E+02,5.5242E+02/
      DATA (KA(JT, 9,12),JT=1,5) /
     &5.8640E+02,5.7843E+02,5.7443E+02,5.7374E+02,5.6970E+02/
      DATA (KA(JT,10,12),JT=1,5) /
     &5.9437E+02,5.8760E+02,5.8375E+02,5.8166E+02,5.7639E+02/
      DATA (KA(JT,11,12),JT=1,5) /
     &5.8998E+02,5.8468E+02,5.8336E+02,5.7943E+02,5.7161E+02/
      DATA (KA(JT,12,12),JT=1,5) /
     &5.7429E+02,5.7360E+02,5.7128E+02,5.6564E+02,5.6011E+02/
      DATA (KA(JT,13,12),JT=1,5) /
     &5.5035E+02,5.5083E+02,5.4893E+02,5.4549E+02,5.4357E+02/
      DATA (KA(JT, 1,13),JT=1,5) /
     &4.9343E+02,4.9586E+02,4.9750E+02,4.9873E+02,4.9898E+02/
      DATA (KA(JT, 2,13),JT=1,5) /
     &5.4485E+02,5.4781E+02,5.5082E+02,5.5168E+02,5.5417E+02/
      DATA (KA(JT, 3,13),JT=1,5) /
     &6.1399E+02,6.1257E+02,6.1216E+02,6.1051E+02,6.1193E+02/
      DATA (KA(JT, 4,13),JT=1,5) /
     &6.9330E+02,6.8682E+02,6.8040E+02,6.7417E+02,6.7247E+02/
      DATA (KA(JT, 5,13),JT=1,5) /
     &7.6881E+02,7.6265E+02,7.5375E+02,7.4386E+02,7.3721E+02/
      DATA (KA(JT, 6,13),JT=1,5) /
     &8.3052E+02,8.2987E+02,8.2363E+02,8.1336E+02,8.0445E+02/
      DATA (KA(JT, 7,13),JT=1,5) /
     &8.8082E+02,8.8344E+02,8.8117E+02,8.7395E+02,8.6653E+02/
      DATA (KA(JT, 8,13),JT=1,5) /
     &9.2485E+02,9.2603E+02,9.2355E+02,9.1727E+02,9.1414E+02/
      DATA (KA(JT, 9,13),JT=1,5) /
     &9.7276E+02,9.7146E+02,9.6566E+02,9.5635E+02,9.5212E+02/
      DATA (KA(JT,10,13),JT=1,5) /
     &1.0175E+03,1.0163E+03,1.0069E+03,9.9610E+02,9.9075E+02/
      DATA (KA(JT,11,13),JT=1,5) /
     &1.0564E+03,1.0547E+03,1.0423E+03,1.0316E+03,1.0272E+03/
      DATA (KA(JT,12,13),JT=1,5) /
     &1.0856E+03,1.0807E+03,1.0716E+03,1.0657E+03,1.0617E+03/
      DATA (KA(JT,13,13),JT=1,5) /
     &1.1006E+03,1.0930E+03,1.0868E+03,1.0845E+03,1.0783E+03/
      DATA (KA(JT, 1,14),JT=1,5) /
     &7.0211E+02,7.0175E+02,7.0131E+02,6.9909E+02,6.9776E+02/
      DATA (KA(JT, 2,14),JT=1,5) /
     &7.9113E+02,7.9461E+02,7.9834E+02,7.9969E+02,7.9813E+02/
      DATA (KA(JT, 3,14),JT=1,5) /
     &8.8896E+02,8.9686E+02,9.0679E+02,9.1320E+02,9.1562E+02/
      DATA (KA(JT, 4,14),JT=1,5) /
     &9.9457E+02,1.0048E+03,1.0163E+03,1.0256E+03,1.0309E+03/
      DATA (KA(JT, 5,14),JT=1,5) /
     &1.1171E+03,1.1226E+03,1.1342E+03,1.1464E+03,1.1541E+03/
      DATA (KA(JT, 6,14),JT=1,5) /
     &1.2650E+03,1.2607E+03,1.2659E+03,1.2764E+03,1.2854E+03/
      DATA (KA(JT, 7,14),JT=1,5) /
     &1.4362E+03,1.4239E+03,1.4228E+03,1.4266E+03,1.4315E+03/
      DATA (KA(JT, 8,14),JT=1,5) /
     &1.6263E+03,1.6088E+03,1.5994E+03,1.5975E+03,1.5958E+03/
      DATA (KA(JT, 9,14),JT=1,5) /
     &1.8039E+03,1.7901E+03,1.7817E+03,1.7757E+03,1.7698E+03/
      DATA (KA(JT,10,14),JT=1,5) /
     &1.9623E+03,1.9495E+03,1.9467E+03,1.9462E+03,1.9411E+03/
      DATA (KA(JT,11,14),JT=1,5) /
     &2.1010E+03,2.0894E+03,2.0912E+03,2.0963E+03,2.0914E+03/
      DATA (KA(JT,12,14),JT=1,5) /
     &2.2319E+03,2.2209E+03,2.2201E+03,2.2217E+03,2.2137E+03/
      DATA (KA(JT,13,14),JT=1,5) /
     &2.3516E+03,2.3425E+03,2.3393E+03,2.3344E+03,2.3274E+03/
      DATA (KA(JT, 1,15),JT=1,5) /
     &1.0409E+03,1.0602E+03,1.0710E+03,1.0853E+03,1.1018E+03/
      DATA (KA(JT, 2,15),JT=1,5) /
     &1.2151E+03,1.2303E+03,1.2347E+03,1.2478E+03,1.2680E+03/
      DATA (KA(JT, 3,15),JT=1,5) /
     &1.4193E+03,1.4320E+03,1.4382E+03,1.4463E+03,1.4605E+03/
      DATA (KA(JT, 4,15),JT=1,5) /
     &1.6341E+03,1.6472E+03,1.6601E+03,1.6700E+03,1.6846E+03/
      DATA (KA(JT, 5,15),JT=1,5) /
     &1.8786E+03,1.8904E+03,1.9028E+03,1.9104E+03,1.9250E+03/
      DATA (KA(JT, 6,15),JT=1,5) /
     &2.1492E+03,2.1663E+03,2.1776E+03,2.1833E+03,2.1940E+03/
      DATA (KA(JT, 7,15),JT=1,5) /
     &2.4310E+03,2.4567E+03,2.4727E+03,2.4804E+03,2.4891E+03/
      DATA (KA(JT, 8,15),JT=1,5) /
     &2.7261E+03,2.7552E+03,2.7803E+03,2.7970E+03,2.8141E+03/
      DATA (KA(JT, 9,15),JT=1,5) /
     &3.0867E+03,3.0994E+03,3.1170E+03,3.1402E+03,3.1679E+03/
      DATA (KA(JT,10,15),JT=1,5) /
     &3.5269E+03,3.5204E+03,3.5225E+03,3.5345E+03,3.5601E+03/
      DATA (KA(JT,11,15),JT=1,5) /
     &4.0271E+03,4.0096E+03,4.0024E+03,4.0052E+03,4.0246E+03/
      DATA (KA(JT,12,15),JT=1,5) /
     &4.5798E+03,4.5585E+03,4.5503E+03,4.5442E+03,4.5532E+03/
      DATA (KA(JT,13,15),JT=1,5) /
     &5.1911E+03,5.1717E+03,5.1553E+03,5.1395E+03,5.1397E+03/
      DATA (KA(JT, 1,16),JT=1,5) /
     &1.2071E+03,1.2414E+03,1.3062E+03,1.3645E+03,1.4123E+03/
      DATA (KA(JT, 2,16),JT=1,5) /
     &1.4670E+03,1.4886E+03,1.5547E+03,1.6269E+03,1.6875E+03/
      DATA (KA(JT, 3,16),JT=1,5) /
     &1.7847E+03,1.7994E+03,1.8394E+03,1.9097E+03,1.9863E+03/
      DATA (KA(JT, 4,16),JT=1,5) /
     &2.1409E+03,2.1717E+03,2.1953E+03,2.2438E+03,2.3059E+03/
      DATA (KA(JT, 5,16),JT=1,5) /
     &2.5417E+03,2.5918E+03,2.6196E+03,2.6591E+03,2.7124E+03/
      DATA (KA(JT, 6,16),JT=1,5) /
     &3.0242E+03,3.0688E+03,3.1113E+03,3.1534E+03,3.2074E+03/
      DATA (KA(JT, 7,16),JT=1,5) /
     &3.6491E+03,3.6695E+03,3.6939E+03,3.7229E+03,3.7906E+03/
      DATA (KA(JT, 8,16),JT=1,5) /
     &4.4223E+03,4.4232E+03,4.4297E+03,4.4268E+03,4.4608E+03/
      DATA (KA(JT, 9,16),JT=1,5) /
     &5.3502E+03,5.3400E+03,5.3338E+03,5.3140E+03,5.2816E+03/
      DATA (KA(JT,10,16),JT=1,5) /
     &6.4333E+03,6.4257E+03,6.4093E+03,6.3744E+03,6.3162E+03/
      DATA (KA(JT,11,16),JT=1,5) /
     &7.6805E+03,7.6778E+03,7.6466E+03,7.5865E+03,7.5106E+03/
      DATA (KA(JT,12,16),JT=1,5) /
     &9.1073E+03,9.0972E+03,9.0428E+03,8.9445E+03,8.8997E+03/
      DATA (KA(JT,13,16),JT=1,5) /
     &1.0699E+04,1.0668E+04,1.0580E+04,1.0493E+04,1.0473E+04/

C     The array KB contains absorption coefs at the 16 chosen g-values 
C     for a range of pressure levels < ~100mb and temperatures. The first 
C     index in the array, JT, which runs from 1 to 5, corresponds to 
C     different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this pressure 
C     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
C     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
C     The second index, JP, runs from 13 to 59 and refers to the JPth
C     reference pressure level (see taumol.f for the value of these
C     pressure levels in mb).  The third index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA (KB(JT,13, 1),JT=1,5) /
     &1.0144E-02,1.1539E-02,1.2861E-02,1.4225E-02,1.5224E-02/
      DATA (KB(JT,14, 1),JT=1,5) /
     &8.4327E-03,9.5989E-03,1.0734E-02,1.1890E-02,1.2872E-02/
      DATA (KB(JT,15, 1),JT=1,5) /
     &6.9967E-03,7.9676E-03,8.9559E-03,9.9119E-03,1.0533E-02/
      DATA (KB(JT,16, 1),JT=1,5) /
     &5.7988E-03,6.6068E-03,7.4553E-03,8.2402E-03,8.5310E-03/
      DATA (KB(JT,17, 1),JT=1,5) /
     &4.8055E-03,5.4781E-03,6.1884E-03,6.8148E-03,6.9563E-03/
      DATA (KB(JT,18, 1),JT=1,5) /
     &3.9877E-03,4.5423E-03,5.1325E-03,5.5098E-03,5.6946E-03/
      DATA (KB(JT,19, 1),JT=1,5) /
     &3.3110E-03,3.7880E-03,4.2806E-03,4.4996E-03,4.6784E-03/
      DATA (KB(JT,20, 1),JT=1,5) /
     &2.7631E-03,3.1756E-03,3.5803E-03,3.7100E-03,3.8598E-03/
      DATA (KB(JT,21, 1),JT=1,5) /
     &2.3113E-03,2.6584E-03,2.9347E-03,3.0481E-03,3.1824E-03/
      DATA (KB(JT,22, 1),JT=1,5) /
     &1.9510E-03,2.2389E-03,2.4076E-03,2.5106E-03,2.6293E-03/
      DATA (KB(JT,23, 1),JT=1,5) /
     &1.6490E-03,1.8833E-03,1.9839E-03,2.0707E-03,2.1757E-03/
      DATA (KB(JT,24, 1),JT=1,5) /
     &1.3921E-03,1.5822E-03,1.6416E-03,1.7136E-03,1.8019E-03/
      DATA (KB(JT,25, 1),JT=1,5) /
     &1.1754E-03,1.2986E-03,1.3546E-03,1.4184E-03,1.4951E-03/
      DATA (KB(JT,26, 1),JT=1,5) /
     &9.9384E-04,1.0692E-03,1.1181E-03,1.1767E-03,1.2423E-03/
      DATA (KB(JT,27, 1),JT=1,5) /
     &8.3932E-04,8.8446E-04,9.2496E-04,9.7555E-04,1.0286E-03/
      DATA (KB(JT,28, 1),JT=1,5) /
     &7.0655E-04,7.3418E-04,7.6647E-04,8.0853E-04,8.5091E-04/
      DATA (KB(JT,29, 1),JT=1,5) /
     &5.8016E-04,6.0558E-04,6.3439E-04,6.6940E-04,7.0187E-04/
      DATA (KB(JT,30, 1),JT=1,5) /
     &4.7757E-04,4.9924E-04,5.2442E-04,5.5397E-04,5.7829E-04/
      DATA (KB(JT,31, 1),JT=1,5) /
     &3.9420E-04,4.1123E-04,4.3298E-04,4.5563E-04,4.7437E-04/
      DATA (KB(JT,32, 1),JT=1,5) /
     &3.2571E-04,3.3960E-04,3.5704E-04,3.7387E-04,3.8849E-04/
      DATA (KB(JT,33, 1),JT=1,5) /
     &2.6741E-04,2.8027E-04,2.9349E-04,3.0636E-04,3.1790E-04/
      DATA (KB(JT,34, 1),JT=1,5) /
     &2.2029E-04,2.3073E-04,2.4120E-04,2.5116E-04,2.5977E-04/
      DATA (KB(JT,35, 1),JT=1,5) /
     &1.8092E-04,1.8913E-04,1.9723E-04,2.0490E-04,2.1120E-04/
      DATA (KB(JT,36, 1),JT=1,5) /
     &1.4775E-04,1.5426E-04,1.6038E-04,1.6643E-04,1.7137E-04/
      DATA (KB(JT,37, 1),JT=1,5) /
     &1.2005E-04,1.2534E-04,1.3001E-04,1.3495E-04,1.3888E-04/
      DATA (KB(JT,38, 1),JT=1,5) /
     &9.7560E-05,1.0177E-04,1.0540E-04,1.0924E-04,1.1256E-04/
      DATA (KB(JT,39, 1),JT=1,5) /
     &7.9344E-05,8.2615E-05,8.5368E-05,8.8405E-05,9.1186E-05/
      DATA (KB(JT,40, 1),JT=1,5) /
     &6.4575E-05,6.7008E-05,6.9369E-05,7.1740E-05,7.4003E-05/
      DATA (KB(JT,41, 1),JT=1,5) /
     &5.2697E-05,5.4334E-05,5.6409E-05,5.8228E-05,6.0014E-05/
      DATA (KB(JT,42, 1),JT=1,5) /
     &4.3089E-05,4.4120E-05,4.5815E-05,4.7218E-05,4.8658E-05/
      DATA (KB(JT,43, 1),JT=1,5) /
     &3.4429E-05,3.5847E-05,3.7149E-05,3.8380E-05,3.9479E-05/
      DATA (KB(JT,44, 1),JT=1,5) /
     &2.7169E-05,2.9300E-05,3.0128E-05,3.1175E-05,3.2021E-05/
      DATA (KB(JT,45, 1),JT=1,5) /
     &2.1411E-05,2.3782E-05,2.4360E-05,2.5287E-05,2.6025E-05/
      DATA (KB(JT,46, 1),JT=1,5) /
     &1.6754E-05,1.8795E-05,1.9931E-05,2.0532E-05,2.1145E-05/
      DATA (KB(JT,47, 1),JT=1,5) /
     &1.3067E-05,1.4757E-05,1.6247E-05,1.6575E-05,1.7184E-05/
      DATA (KB(JT,48, 1),JT=1,5) /
     &1.0193E-05,1.1527E-05,1.2841E-05,1.3599E-05,1.3946E-05/
      DATA (KB(JT,49, 1),JT=1,5) /
     &7.9417E-06,8.9971E-06,1.0112E-05,1.1045E-05,1.1285E-05/
      DATA (KB(JT,50, 1),JT=1,5) /
     &6.1950E-06,7.0678E-06,7.9571E-06,8.7859E-06,9.3116E-06/
      DATA (KB(JT,51, 1),JT=1,5) /
     &4.8121E-06,5.5540E-06,6.2634E-06,6.9968E-06,7.5750E-06/
      DATA (KB(JT,52, 1),JT=1,5) /
     &3.7732E-06,4.3400E-06,4.9368E-06,5.5255E-06,6.0507E-06/
      DATA (KB(JT,53, 1),JT=1,5) /
     &2.9588E-06,3.3855E-06,3.8934E-06,4.3558E-06,4.8377E-06/
      DATA (KB(JT,54, 1),JT=1,5) /
     &2.2637E-06,2.6550E-06,3.0640E-06,3.4670E-06,3.8645E-06/
      DATA (KB(JT,55, 1),JT=1,5) /
     &1.7394E-06,2.1318E-06,2.4092E-06,2.7718E-06,3.0969E-06/
      DATA (KB(JT,56, 1),JT=1,5) /
     &1.3379E-06,1.6962E-06,1.9182E-06,2.2019E-06,2.5057E-06/
      DATA (KB(JT,57, 1),JT=1,5) /
     &1.0894E-06,1.3086E-06,1.5250E-06,1.7825E-06,2.0078E-06/
      DATA (KB(JT,58, 1),JT=1,5) /
     &8.2505E-07,1.0180E-06,1.2548E-06,1.4584E-06,1.7398E-06/
      DATA (KB(JT,59, 1),JT=1,5) /
     &7.1802E-07,8.6784E-07,1.0974E-06,1.3504E-06,1.4314E-06/
      DATA (KB(JT,13, 2),JT=1,5) /
     &4.1938E-02,4.3540E-02,4.4990E-02,4.6074E-02,4.6999E-02/
      DATA (KB(JT,14, 2),JT=1,5) /
     &3.5928E-02,3.7447E-02,3.8935E-02,3.9816E-02,4.0666E-02/
      DATA (KB(JT,15, 2),JT=1,5) /
     &3.0539E-02,3.1836E-02,3.3086E-02,3.4096E-02,3.5203E-02/
      DATA (KB(JT,16, 2),JT=1,5) /
     &2.5542E-02,2.6607E-02,2.7654E-02,2.8622E-02,2.9849E-02/
      DATA (KB(JT,17, 2),JT=1,5) /
     &2.1059E-02,2.2159E-02,2.3097E-02,2.3970E-02,2.5021E-02/
      DATA (KB(JT,18, 2),JT=1,5) /
     &1.7420E-02,1.8344E-02,1.9223E-02,2.0092E-02,2.0887E-02/
      DATA (KB(JT,19, 2),JT=1,5) /
     &1.4527E-02,1.5294E-02,1.6071E-02,1.6950E-02,1.7660E-02/
      DATA (KB(JT,20, 2),JT=1,5) /
     &1.2057E-02,1.2740E-02,1.3375E-02,1.4212E-02,1.4836E-02/
      DATA (KB(JT,21, 2),JT=1,5) /
     &1.0024E-02,1.0630E-02,1.1202E-02,1.1918E-02,1.2460E-02/
      DATA (KB(JT,22, 2),JT=1,5) /
     &8.3586E-03,8.8721E-03,9.4319E-03,1.0016E-02,1.0451E-02/
      DATA (KB(JT,23, 2),JT=1,5) /
     &7.0023E-03,7.4292E-03,7.9425E-03,8.4001E-03,8.6668E-03/
      DATA (KB(JT,24, 2),JT=1,5) /
     &5.8805E-03,6.2414E-03,6.6855E-03,7.0380E-03,7.1881E-03/
      DATA (KB(JT,25, 2),JT=1,5) /
     &4.9300E-03,5.2659E-03,5.6130E-03,5.8139E-03,5.9744E-03/
      DATA (KB(JT,26, 2),JT=1,5) /
     &4.1346E-03,4.4268E-03,4.6994E-03,4.8189E-03,4.9700E-03/
      DATA (KB(JT,27, 2),JT=1,5) /
     &3.4478E-03,3.6949E-03,3.8760E-03,3.9800E-03,4.1083E-03/
      DATA (KB(JT,28, 2),JT=1,5) /
     &2.8662E-03,3.0720E-03,3.1855E-03,3.2844E-03,3.3841E-03/
      DATA (KB(JT,29, 2),JT=1,5) /
     &2.3700E-03,2.5289E-03,2.6049E-03,2.6846E-03,2.7555E-03/
      DATA (KB(JT,30, 2),JT=1,5) /
     &1.9529E-03,2.0734E-03,2.1236E-03,2.1766E-03,2.2279E-03/
      DATA (KB(JT,31, 2),JT=1,5) /
     &1.5951E-03,1.6761E-03,1.7103E-03,1.7458E-03,1.7856E-03/
      DATA (KB(JT,32, 2),JT=1,5) /
     &1.2965E-03,1.3546E-03,1.3767E-03,1.4016E-03,1.4345E-03/
      DATA (KB(JT,33, 2),JT=1,5) /
     &1.0497E-03,1.0916E-03,1.1061E-03,1.1259E-03,1.1490E-03/
      DATA (KB(JT,34, 2),JT=1,5) /
     &8.5263E-04,8.8439E-04,8.9299E-04,9.0901E-04,9.2683E-04/
      DATA (KB(JT,35, 2),JT=1,5) /
     &6.8961E-04,7.1452E-04,7.2125E-04,7.3408E-04,7.4718E-04/
      DATA (KB(JT,36, 2),JT=1,5) /
     &5.5538E-04,5.7454E-04,5.8468E-04,5.9295E-04,6.0312E-04/
      DATA (KB(JT,37, 2),JT=1,5) /
     &4.4687E-04,4.6228E-04,4.7485E-04,4.8052E-04,4.8826E-04/
      DATA (KB(JT,38, 2),JT=1,5) /
     &3.5911E-04,3.7176E-04,3.8278E-04,3.8998E-04,3.9487E-04/
      DATA (KB(JT,39, 2),JT=1,5) /
     &2.8825E-04,2.9868E-04,3.0761E-04,3.1500E-04,3.2065E-04/
      DATA (KB(JT,40, 2),JT=1,5) /
     &2.3221E-04,2.4117E-04,2.4916E-04,2.5539E-04,2.6149E-04/
      DATA (KB(JT,41, 2),JT=1,5) /
     &1.8711E-04,1.9520E-04,2.0184E-04,2.0732E-04,2.1208E-04/
      DATA (KB(JT,42, 2),JT=1,5) /
     &1.5044E-04,1.5806E-04,1.6349E-04,1.6813E-04,1.7186E-04/
      DATA (KB(JT,43, 2),JT=1,5) /
     &1.2147E-04,1.2754E-04,1.3202E-04,1.3603E-04,1.3922E-04/
      DATA (KB(JT,44, 2),JT=1,5) /
     &9.7631E-05,1.0254E-04,1.0664E-04,1.1000E-04,1.1278E-04/
      DATA (KB(JT,45, 2),JT=1,5) /
     &7.8551E-05,8.2386E-05,8.6252E-05,8.8821E-05,9.1113E-05/
      DATA (KB(JT,46, 2),JT=1,5) /
     &6.3082E-05,6.6217E-05,6.9264E-05,7.1597E-05,7.3596E-05/
      DATA (KB(JT,47, 2),JT=1,5) /
     &5.0668E-05,5.3148E-05,5.5648E-05,5.8023E-05,5.9460E-05/
      DATA (KB(JT,48, 2),JT=1,5) /
     &4.0723E-05,4.2652E-05,4.4714E-05,4.6562E-05,4.8110E-05/
      DATA (KB(JT,49, 2),JT=1,5) /
     &3.2577E-05,3.4241E-05,3.5845E-05,3.7418E-05,3.8704E-05/
      DATA (KB(JT,50, 2),JT=1,5) /
     &2.6548E-05,2.7645E-05,2.8887E-05,3.0243E-05,3.1285E-05/
      DATA (KB(JT,51, 2),JT=1,5) /
     &2.1632E-05,2.2305E-05,2.3402E-05,2.4420E-05,2.5424E-05/
      DATA (KB(JT,52, 2),JT=1,5) /
     &1.7494E-05,1.8158E-05,1.8946E-05,1.9746E-05,2.0626E-05/
      DATA (KB(JT,53, 2),JT=1,5) /
     &1.4060E-05,1.4924E-05,1.5296E-05,1.6047E-05,1.6661E-05/
      DATA (KB(JT,54, 2),JT=1,5) /
     &1.1502E-05,1.2189E-05,1.2591E-05,1.3072E-05,1.3585E-05/
      DATA (KB(JT,55, 2),JT=1,5) /
     &9.4731E-06,9.9000E-06,1.0499E-05,1.0730E-05,1.1201E-05/
      DATA (KB(JT,56, 2),JT=1,5) /
     &7.7842E-06,8.0609E-06,8.6328E-06,8.9073E-06,9.2258E-06/
      DATA (KB(JT,57, 2),JT=1,5) /
     &6.1271E-06,6.6999E-06,7.0368E-06,7.4466E-06,7.6395E-06/
      DATA (KB(JT,58, 2),JT=1,5) /
     &4.7873E-06,5.5615E-06,5.7470E-06,6.1637E-06,6.3705E-06/
      DATA (KB(JT,59, 2),JT=1,5) /
     &3.8649E-06,4.5966E-06,4.7965E-06,5.1490E-06,5.3880E-06/
      DATA (KB(JT,13, 3),JT=1,5) /
     &1.2497E-01,1.2733E-01,1.2732E-01,1.2710E-01,1.2722E-01/
      DATA (KB(JT,14, 3),JT=1,5) /
     &1.0770E-01,1.1044E-01,1.0994E-01,1.0972E-01,1.0842E-01/
      DATA (KB(JT,15, 3),JT=1,5) /
     &9.2313E-02,9.4782E-02,9.3928E-02,9.2439E-02,9.0946E-02/
      DATA (KB(JT,16, 3),JT=1,5) /
     &7.7737E-02,7.9134E-02,7.7340E-02,7.6811E-02,7.6114E-02/
      DATA (KB(JT,17, 3),JT=1,5) /
     &6.5446E-02,6.4598E-02,6.3955E-02,6.3795E-02,6.3695E-02/
      DATA (KB(JT,18, 3),JT=1,5) /
     &5.3197E-02,5.2989E-02,5.2755E-02,5.2824E-02,5.2780E-02/
      DATA (KB(JT,19, 3),JT=1,5) /
     &4.3741E-02,4.3850E-02,4.3971E-02,4.3934E-02,4.3215E-02/
      DATA (KB(JT,20, 3),JT=1,5) /
     &3.6203E-02,3.6356E-02,3.6481E-02,3.6039E-02,3.5482E-02/
      DATA (KB(JT,21, 3),JT=1,5) /
     &2.9983E-02,3.0109E-02,3.0136E-02,2.9600E-02,2.9205E-02/
      DATA (KB(JT,22, 3),JT=1,5) /
     &2.4798E-02,2.4802E-02,2.4628E-02,2.4239E-02,2.4061E-02/
      DATA (KB(JT,23, 3),JT=1,5) /
     &2.0477E-02,2.0405E-02,2.0149E-02,1.9990E-02,1.9997E-02/
      DATA (KB(JT,24, 3),JT=1,5) /
     &1.6953E-02,1.6782E-02,1.6632E-02,1.6618E-02,1.6673E-02/
      DATA (KB(JT,25, 3),JT=1,5) /
     &1.3995E-02,1.3802E-02,1.3748E-02,1.3853E-02,1.3849E-02/
      DATA (KB(JT,26, 3),JT=1,5) /
     &1.1507E-02,1.1388E-02,1.1372E-02,1.1472E-02,1.1479E-02/
      DATA (KB(JT,27, 3),JT=1,5) /
     &9.4100E-03,9.3552E-03,9.3927E-03,9.4480E-03,9.4683E-03/
      DATA (KB(JT,28, 3),JT=1,5) /
     &7.6709E-03,7.6555E-03,7.7364E-03,7.7513E-03,7.7691E-03/
      DATA (KB(JT,29, 3),JT=1,5) /
     &6.2318E-03,6.2179E-03,6.2783E-03,6.2823E-03,6.2984E-03/
      DATA (KB(JT,30, 3),JT=1,5) /
     &5.0369E-03,5.0223E-03,5.0690E-03,5.0675E-03,5.0877E-03/
      DATA (KB(JT,31, 3),JT=1,5) /
     &4.0270E-03,4.0248E-03,4.0530E-03,4.0550E-03,4.0668E-03/
      DATA (KB(JT,32, 3),JT=1,5) /
     &3.2266E-03,3.2233E-03,3.2444E-03,3.2484E-03,3.2485E-03/
      DATA (KB(JT,33, 3),JT=1,5) /
     &2.5826E-03,2.5793E-03,2.5980E-03,2.5954E-03,2.5860E-03/
      DATA (KB(JT,34, 3),JT=1,5) /
     &2.0751E-03,2.0785E-03,2.0913E-03,2.0819E-03,2.0719E-03/
      DATA (KB(JT,35, 3),JT=1,5) /
     &1.6732E-03,1.6746E-03,1.6840E-03,1.6712E-03,1.6630E-03/
      DATA (KB(JT,36, 3),JT=1,5) /
     &1.3540E-03,1.3534E-03,1.3539E-03,1.3458E-03,1.3380E-03/
      DATA (KB(JT,37, 3),JT=1,5) /
     &1.1025E-03,1.0986E-03,1.0965E-03,1.0906E-03,1.0838E-03/
      DATA (KB(JT,38, 3),JT=1,5) /
     &8.9827E-04,8.9144E-04,8.8894E-04,8.8260E-04,8.7601E-04/
      DATA (KB(JT,39, 3),JT=1,5) /
     &7.3039E-04,7.2351E-04,7.1956E-04,7.1446E-04,7.0735E-04/
      DATA (KB(JT,40, 3),JT=1,5) /
     &6.0257E-04,5.9335E-04,5.8899E-04,5.8497E-04,5.7809E-04/
      DATA (KB(JT,41, 3),JT=1,5) /
     &4.9748E-04,4.8829E-04,4.8330E-04,4.7897E-04,4.7418E-04/
      DATA (KB(JT,42, 3),JT=1,5) /
     &4.0962E-04,4.0192E-04,3.9631E-04,3.9272E-04,3.8922E-04/
      DATA (KB(JT,43, 3),JT=1,5) /
     &3.3511E-04,3.3335E-04,3.2739E-04,3.2309E-04,3.2009E-04/
      DATA (KB(JT,44, 3),JT=1,5) /
     &2.7494E-04,2.7440E-04,2.7166E-04,2.6681E-04,2.6291E-04/
      DATA (KB(JT,45, 3),JT=1,5) /
     &2.2409E-04,2.2465E-04,2.2546E-04,2.2120E-04,2.1688E-04/
      DATA (KB(JT,46, 3),JT=1,5) /
     &1.8344E-04,1.8445E-04,1.8370E-04,1.8435E-04,1.8060E-04/
      DATA (KB(JT,47, 3),JT=1,5) /
     &1.5220E-04,1.5094E-04,1.5093E-04,1.5107E-04,1.5073E-04/
      DATA (KB(JT,48, 3),JT=1,5) /
     &1.2685E-04,1.2406E-04,1.2418E-04,1.2347E-04,1.2407E-04/
      DATA (KB(JT,49, 3),JT=1,5) /
     &1.0283E-04,1.0360E-04,1.0186E-04,1.0181E-04,1.0123E-04/
      DATA (KB(JT,50, 3),JT=1,5) /
     &8.3231E-05,8.5593E-05,8.4616E-05,8.3839E-05,8.3224E-05/
      DATA (KB(JT,51, 3),JT=1,5) /
     &6.6892E-05,7.0153E-05,7.0699E-05,6.9691E-05,6.9167E-05/
      DATA (KB(JT,52, 3),JT=1,5) /
     &5.4090E-05,5.6975E-05,5.8223E-05,5.8345E-05,5.7364E-05/
      DATA (KB(JT,53, 3),JT=1,5) /
     &4.3363E-05,4.5702E-05,4.7865E-05,4.7887E-05,4.7945E-05/
      DATA (KB(JT,54, 3),JT=1,5) /
     &3.4722E-05,3.7579E-05,3.9122E-05,3.9883E-05,3.9754E-05/
      DATA (KB(JT,55, 3),JT=1,5) /
     &2.7984E-05,3.0530E-05,3.1930E-05,3.3227E-05,3.3134E-05/
      DATA (KB(JT,56, 3),JT=1,5) /
     &2.2565E-05,2.4737E-05,2.6495E-05,2.7386E-05,2.7845E-05/
      DATA (KB(JT,57, 3),JT=1,5) /
     &1.8624E-05,1.9996E-05,2.1604E-05,2.2454E-05,2.3200E-05/
      DATA (KB(JT,58, 3),JT=1,5) /
     &1.5567E-05,1.6215E-05,1.7630E-05,1.8795E-05,1.9192E-05/
      DATA (KB(JT,59, 3),JT=1,5) /
     &1.3180E-05,1.3591E-05,1.4748E-05,1.5698E-05,1.6153E-05/
      DATA (KB(JT,13, 4),JT=1,5) /
     &2.3244E-01,2.2666E-01,2.2365E-01,2.1647E-01,2.0828E-01/
      DATA (KB(JT,14, 4),JT=1,5) /
     &1.9358E-01,1.8830E-01,1.8743E-01,1.8019E-01,1.7506E-01/
      DATA (KB(JT,15, 4),JT=1,5) /
     &1.6047E-01,1.5782E-01,1.5488E-01,1.5178E-01,1.4896E-01/
      DATA (KB(JT,16, 4),JT=1,5) /
     &1.3221E-01,1.3030E-01,1.2930E-01,1.2731E-01,1.2502E-01/
      DATA (KB(JT,17, 4),JT=1,5) /
     &1.0863E-01,1.0862E-01,1.0815E-01,1.0706E-01,1.0464E-01/
      DATA (KB(JT,18, 4),JT=1,5) /
     &9.0031E-02,9.0210E-02,9.0179E-02,8.8891E-02,8.7072E-02/
      DATA (KB(JT,19, 4),JT=1,5) /
     &7.4933E-02,7.5517E-02,7.5432E-02,7.4716E-02,7.4259E-02/
      DATA (KB(JT,20, 4),JT=1,5) /
     &6.2292E-02,6.2900E-02,6.2796E-02,6.2799E-02,6.2655E-02/
      DATA (KB(JT,21, 4),JT=1,5) /
     &5.1753E-02,5.2259E-02,5.2338E-02,5.2648E-02,5.2692E-02/
      DATA (KB(JT,22, 4),JT=1,5) /
     &4.2879E-02,4.3337E-02,4.3671E-02,4.3911E-02,4.3964E-02/
      DATA (KB(JT,23, 4),JT=1,5) /
     &3.5511E-02,3.5957E-02,3.6400E-02,3.6560E-02,3.6588E-02/
      DATA (KB(JT,24, 4),JT=1,5) /
     &2.9490E-02,3.0002E-02,3.0363E-02,3.0503E-02,3.0607E-02/
      DATA (KB(JT,25, 4),JT=1,5) /
     &2.4491E-02,2.5028E-02,2.5370E-02,2.5485E-02,2.5616E-02/
      DATA (KB(JT,26, 4),JT=1,5) /
     &2.0405E-02,2.0858E-02,2.1166E-02,2.1267E-02,2.1358E-02/
      DATA (KB(JT,27, 4),JT=1,5) /
     &1.6966E-02,1.7305E-02,1.7522E-02,1.7603E-02,1.7664E-02/
      DATA (KB(JT,28, 4),JT=1,5) /
     &1.4041E-02,1.4283E-02,1.4398E-02,1.4482E-02,1.4540E-02/
      DATA (KB(JT,29, 4),JT=1,5) /
     &1.1473E-02,1.1643E-02,1.1712E-02,1.1784E-02,1.1808E-02/
      DATA (KB(JT,30, 4),JT=1,5) /
     &9.3128E-03,9.4393E-03,9.4816E-03,9.5274E-03,9.5277E-03/
      DATA (KB(JT,31, 4),JT=1,5) /
     &7.5018E-03,7.5697E-03,7.5938E-03,7.6234E-03,7.6068E-03/
      DATA (KB(JT,32, 4),JT=1,5) /
     &6.0276E-03,6.0587E-03,6.0760E-03,6.0793E-03,6.0890E-03/
      DATA (KB(JT,33, 4),JT=1,5) /
     &4.8317E-03,4.8465E-03,4.8480E-03,4.8590E-03,4.8679E-03/
      DATA (KB(JT,34, 4),JT=1,5) /
     &3.8930E-03,3.8936E-03,3.8908E-03,3.9081E-03,3.9148E-03/
      DATA (KB(JT,35, 4),JT=1,5) /
     &3.1327E-03,3.1329E-03,3.1313E-03,3.1437E-03,3.1485E-03/
      DATA (KB(JT,36, 4),JT=1,5) /
     &2.5288E-03,2.5255E-03,2.5228E-03,2.5303E-03,2.5349E-03/
      DATA (KB(JT,37, 4),JT=1,5) /
     &2.0481E-03,2.0483E-03,2.0398E-03,2.0467E-03,2.0499E-03/
      DATA (KB(JT,38, 4),JT=1,5) /
     &1.6558E-03,1.6596E-03,1.6492E-03,1.6534E-03,1.6569E-03/
      DATA (KB(JT,39, 4),JT=1,5) /
     &1.3374E-03,1.3400E-03,1.3351E-03,1.3347E-03,1.3383E-03/
      DATA (KB(JT,40, 4),JT=1,5) /
     &1.0845E-03,1.0921E-03,1.0887E-03,1.0875E-03,1.0897E-03/
      DATA (KB(JT,41, 4),JT=1,5) /
     &8.8154E-04,8.8864E-04,8.8779E-04,8.8674E-04,8.8749E-04/
      DATA (KB(JT,42, 4),JT=1,5) /
     &7.1843E-04,7.2263E-04,7.2341E-04,7.2250E-04,7.2207E-04/
      DATA (KB(JT,43, 4),JT=1,5) /
     &5.8799E-04,5.8635E-04,5.8966E-04,5.8857E-04,5.8778E-04/
      DATA (KB(JT,44, 4),JT=1,5) /
     &4.7968E-04,4.7905E-04,4.7843E-04,4.7895E-04,4.7900E-04/
      DATA (KB(JT,45, 4),JT=1,5) /
     &3.9220E-04,3.9274E-04,3.8844E-04,3.8841E-04,3.8937E-04/
      DATA (KB(JT,46, 4),JT=1,5) /
     &3.2002E-04,3.2007E-04,3.1928E-04,3.1499E-04,3.1489E-04/
      DATA (KB(JT,47, 4),JT=1,5) /
     &2.6159E-04,2.6272E-04,2.6214E-04,2.5941E-04,2.5552E-04/
      DATA (KB(JT,48, 4),JT=1,5) /
     &2.1397E-04,2.1500E-04,2.1426E-04,2.1370E-04,2.0956E-04/
      DATA (KB(JT,49, 4),JT=1,5) /
     &1.7795E-04,1.7554E-04,1.7551E-04,1.7452E-04,1.7328E-04/
      DATA (KB(JT,50, 4),JT=1,5) /
     &1.4762E-04,1.4610E-04,1.4428E-04,1.4351E-04,1.4273E-04/
      DATA (KB(JT,51, 4),JT=1,5) /
     &1.2354E-04,1.2144E-04,1.1938E-04,1.1805E-04,1.1688E-04/
      DATA (KB(JT,52, 4),JT=1,5) /
     &1.0353E-04,1.0111E-04,9.9958E-05,9.7469E-05,9.6574E-05/
      DATA (KB(JT,53, 4),JT=1,5) /
     &8.8311E-05,8.4522E-05,8.3164E-05,8.1847E-05,7.9623E-05/
      DATA (KB(JT,54, 4),JT=1,5) /
     &7.5002E-05,7.1277E-05,6.9429E-05,6.8546E-05,6.7044E-05/
      DATA (KB(JT,55, 4),JT=1,5) /
     &6.4688E-05,6.1558E-05,5.8597E-05,5.7310E-05,5.6741E-05/
      DATA (KB(JT,56, 4),JT=1,5) /
     &5.4545E-05,5.2835E-05,4.9722E-05,4.8222E-05,4.7437E-05/
      DATA (KB(JT,57, 4),JT=1,5) /
     &4.5567E-05,4.5770E-05,4.3541E-05,4.1141E-05,3.9867E-05/
      DATA (KB(JT,58, 4),JT=1,5) /
     &3.8423E-05,3.8314E-05,3.7767E-05,3.5438E-05,3.3984E-05/
      DATA (KB(JT,59, 4),JT=1,5) /
     &3.2695E-05,3.2545E-05,3.2199E-05,3.0741E-05,2.9151E-05/
      DATA (KB(JT,13, 5),JT=1,5) /
     &3.6693E-01,3.6670E-01,3.6374E-01,3.6513E-01,3.6694E-01/
      DATA (KB(JT,14, 5),JT=1,5) /
     &3.1193E-01,3.1009E-01,3.0785E-01,3.1108E-01,3.1338E-01/
      DATA (KB(JT,15, 5),JT=1,5) /
     &2.6635E-01,2.6398E-01,2.6603E-01,2.6792E-01,2.6974E-01/
      DATA (KB(JT,16, 5),JT=1,5) /
     &2.2560E-01,2.2536E-01,2.2722E-01,2.2790E-01,2.2934E-01/
      DATA (KB(JT,17, 5),JT=1,5) /
     &1.9102E-01,1.9205E-01,1.9235E-01,1.9256E-01,1.9454E-01/
      DATA (KB(JT,18, 5),JT=1,5) /
     &1.6220E-01,1.6268E-01,1.6247E-01,1.6354E-01,1.6555E-01/
      DATA (KB(JT,19, 5),JT=1,5) /
     &1.3796E-01,1.3803E-01,1.3823E-01,1.3977E-01,1.4117E-01/
      DATA (KB(JT,20, 5),JT=1,5) /
     &1.1636E-01,1.1631E-01,1.1719E-01,1.1821E-01,1.1915E-01/
      DATA (KB(JT,21, 5),JT=1,5) /
     &9.7502E-02,9.7703E-02,9.8615E-02,9.9561E-02,1.0025E-01/
      DATA (KB(JT,22, 5),JT=1,5) /
     &8.1562E-02,8.1981E-02,8.2659E-02,8.3450E-02,8.3918E-02/
      DATA (KB(JT,23, 5),JT=1,5) /
     &6.8080E-02,6.8683E-02,6.9366E-02,6.9894E-02,7.0282E-02/
      DATA (KB(JT,24, 5),JT=1,5) /
     &5.7119E-02,5.7682E-02,5.8192E-02,5.8547E-02,5.9029E-02/
      DATA (KB(JT,25, 5),JT=1,5) /
     &4.7811E-02,4.8293E-02,4.8606E-02,4.8996E-02,4.9473E-02/
      DATA (KB(JT,26, 5),JT=1,5) /
     &3.9890E-02,4.0316E-02,4.0576E-02,4.1016E-02,4.1455E-02/
      DATA (KB(JT,27, 5),JT=1,5) /
     &3.3117E-02,3.3470E-02,3.3770E-02,3.4189E-02,3.4527E-02/
      DATA (KB(JT,28, 5),JT=1,5) /
     &2.7406E-02,2.7694E-02,2.7971E-02,2.8332E-02,2.8599E-02/
      DATA (KB(JT,29, 5),JT=1,5) /
     &2.2401E-02,2.2630E-02,2.2890E-02,2.3150E-02,2.3396E-02/
      DATA (KB(JT,30, 5),JT=1,5) /
     &1.8227E-02,1.8399E-02,1.8623E-02,1.8850E-02,1.9028E-02/
      DATA (KB(JT,31, 5),JT=1,5) /
     &1.4683E-02,1.4830E-02,1.5011E-02,1.5187E-02,1.5326E-02/
      DATA (KB(JT,32, 5),JT=1,5) /
     &1.1826E-02,1.1971E-02,1.2101E-02,1.2245E-02,1.2313E-02/
      DATA (KB(JT,33, 5),JT=1,5) /
     &9.5307E-03,9.6419E-03,9.7421E-03,9.8284E-03,9.8826E-03/
      DATA (KB(JT,34, 5),JT=1,5) /
     &7.7176E-03,7.8031E-03,7.8838E-03,7.9405E-03,7.9679E-03/
      DATA (KB(JT,35, 5),JT=1,5) /
     &6.2512E-03,6.3124E-03,6.3712E-03,6.4126E-03,6.4324E-03/
      DATA (KB(JT,36, 5),JT=1,5) /
     &5.0560E-03,5.1076E-03,5.1576E-03,5.1918E-03,5.2018E-03/
      DATA (KB(JT,37, 5),JT=1,5) /
     &4.0965E-03,4.1427E-03,4.1869E-03,4.2164E-03,4.2222E-03/
      DATA (KB(JT,38, 5),JT=1,5) /
     &3.3169E-03,3.3541E-03,3.3940E-03,3.4174E-03,3.4236E-03/
      DATA (KB(JT,39, 5),JT=1,5) /
     &2.6806E-03,2.7157E-03,2.7440E-03,2.7658E-03,2.7739E-03/
      DATA (KB(JT,40, 5),JT=1,5) /
     &2.1766E-03,2.2105E-03,2.2356E-03,2.2533E-03,2.2654E-03/
      DATA (KB(JT,41, 5),JT=1,5) /
     &1.7690E-03,1.7997E-03,1.8217E-03,1.8373E-03,1.8492E-03/
      DATA (KB(JT,42, 5),JT=1,5) /
     &1.4370E-03,1.4625E-03,1.4833E-03,1.4970E-03,1.5072E-03/
      DATA (KB(JT,43, 5),JT=1,5) /
     &1.1671E-03,1.1863E-03,1.2051E-03,1.2193E-03,1.2276E-03/
      DATA (KB(JT,44, 5),JT=1,5) /
     &9.4820E-04,9.6187E-04,9.7830E-04,9.9143E-04,9.9963E-04/
      DATA (KB(JT,45, 5),JT=1,5) /
     &7.6916E-04,7.7831E-04,7.9153E-04,8.0495E-04,8.1281E-04/
      DATA (KB(JT,46, 5),JT=1,5) /
     &6.2348E-04,6.3114E-04,6.4009E-04,6.5199E-04,6.6002E-04/
      DATA (KB(JT,47, 5),JT=1,5) /
     &5.0390E-04,5.1138E-04,5.1807E-04,5.2655E-04,5.3606E-04/
      DATA (KB(JT,48, 5),JT=1,5) /
     &4.0606E-04,4.1379E-04,4.1952E-04,4.2537E-04,4.3314E-04/
      DATA (KB(JT,49, 5),JT=1,5) /
     &3.2659E-04,3.3285E-04,3.3902E-04,3.4315E-04,3.4880E-04/
      DATA (KB(JT,50, 5),JT=1,5) /
     &2.6466E-04,2.6781E-04,2.7393E-04,2.7826E-04,2.8216E-04/
      DATA (KB(JT,51, 5),JT=1,5) /
     &2.1507E-04,2.1721E-04,2.2109E-04,2.2570E-04,2.2911E-04/
      DATA (KB(JT,52, 5),JT=1,5) /
     &1.7470E-04,1.7639E-04,1.7813E-04,1.8197E-04,1.8512E-04/
      DATA (KB(JT,53, 5),JT=1,5) /
     &1.4115E-04,1.4348E-04,1.4425E-04,1.4633E-04,1.4939E-04/
      DATA (KB(JT,54, 5),JT=1,5) /
     &1.1575E-04,1.1704E-04,1.1812E-04,1.1890E-04,1.2106E-04/
      DATA (KB(JT,55, 5),JT=1,5) /
     &9.4726E-05,9.5455E-05,9.6825E-05,9.7465E-05,9.8412E-05/
      DATA (KB(JT,56, 5),JT=1,5) /
     &7.9719E-05,7.8475E-05,7.9571E-05,8.0057E-05,8.0565E-05/
      DATA (KB(JT,57, 5),JT=1,5) /
     &6.7373E-05,6.4174E-05,6.4600E-05,6.5492E-05,6.6130E-05/
      DATA (KB(JT,58, 5),JT=1,5) /
     &5.8248E-05,5.4990E-05,5.3012E-05,5.3610E-05,5.4283E-05/
      DATA (KB(JT,59, 5),JT=1,5) /
     &5.0210E-05,4.6885E-05,4.4678E-05,4.4690E-05,4.5330E-05/
      DATA (KB(JT,13, 6),JT=1,5) /
     &8.1815E-01,8.2185E-01,8.2056E-01,8.1693E-01,8.1119E-01/
      DATA (KB(JT,14, 6),JT=1,5) /
     &6.9938E-01,7.0403E-01,7.0310E-01,6.9893E-01,6.9382E-01/
      DATA (KB(JT,15, 6),JT=1,5) /
     &6.0306E-01,6.0562E-01,6.0433E-01,6.0124E-01,5.9539E-01/
      DATA (KB(JT,16, 6),JT=1,5) /
     &5.1717E-01,5.1741E-01,5.1602E-01,5.1303E-01,5.0799E-01/
      DATA (KB(JT,17, 6),JT=1,5) /
     &4.3954E-01,4.3996E-01,4.3917E-01,4.3585E-01,4.3144E-01/
      DATA (KB(JT,18, 6),JT=1,5) /
     &3.7098E-01,3.7164E-01,3.7046E-01,3.6778E-01,3.6412E-01/
      DATA (KB(JT,19, 6),JT=1,5) /
     &3.1410E-01,3.1452E-01,3.1318E-01,3.1054E-01,3.0829E-01/
      DATA (KB(JT,20, 6),JT=1,5) /
     &2.6425E-01,2.6434E-01,2.6287E-01,2.6129E-01,2.6054E-01/
      DATA (KB(JT,21, 6),JT=1,5) /
     &2.2166E-01,2.2161E-01,2.2078E-01,2.2017E-01,2.1929E-01/
      DATA (KB(JT,22, 6),JT=1,5) /
     &1.8499E-01,1.8512E-01,1.8480E-01,1.8474E-01,1.8395E-01/
      DATA (KB(JT,23, 6),JT=1,5) /
     &1.5462E-01,1.5460E-01,1.5448E-01,1.5440E-01,1.5366E-01/
      DATA (KB(JT,24, 6),JT=1,5) /
     &1.2929E-01,1.2940E-01,1.2953E-01,1.2932E-01,1.2872E-01/
      DATA (KB(JT,25, 6),JT=1,5) /
     &1.0802E-01,1.0819E-01,1.0834E-01,1.0817E-01,1.0761E-01/
      DATA (KB(JT,26, 6),JT=1,5) /
     &9.0060E-02,9.0350E-02,9.0334E-02,9.0150E-02,8.9781E-02/
      DATA (KB(JT,27, 6),JT=1,5) /
     &7.4680E-02,7.4863E-02,7.4908E-02,7.4831E-02,7.4608E-02/
      DATA (KB(JT,28, 6),JT=1,5) /
     &6.1687E-02,6.1865E-02,6.1970E-02,6.1917E-02,6.1874E-02/
      DATA (KB(JT,29, 6),JT=1,5) /
     &5.0513E-02,5.0701E-02,5.0801E-02,5.0773E-02,5.0734E-02/
      DATA (KB(JT,30, 6),JT=1,5) /
     &4.1201E-02,4.1379E-02,4.1449E-02,4.1422E-02,4.1408E-02/
      DATA (KB(JT,31, 6),JT=1,5) /
     &3.3339E-02,3.3480E-02,3.3517E-02,3.3503E-02,3.3496E-02/
      DATA (KB(JT,32, 6),JT=1,5) /
     &2.6941E-02,2.7025E-02,2.7045E-02,2.7032E-02,2.7041E-02/
      DATA (KB(JT,33, 6),JT=1,5) /
     &2.1746E-02,2.1784E-02,2.1791E-02,2.1788E-02,2.1780E-02/
      DATA (KB(JT,34, 6),JT=1,5) /
     &1.7618E-02,1.7652E-02,1.7653E-02,1.7651E-02,1.7645E-02/
      DATA (KB(JT,35, 6),JT=1,5) /
     &1.4278E-02,1.4314E-02,1.4305E-02,1.4306E-02,1.4294E-02/
      DATA (KB(JT,36, 6),JT=1,5) /
     &1.1580E-02,1.1612E-02,1.1606E-02,1.1608E-02,1.1605E-02/
      DATA (KB(JT,37, 6),JT=1,5) /
     &9.4219E-03,9.4537E-03,9.4624E-03,9.4565E-03,9.4577E-03/
      DATA (KB(JT,38, 6),JT=1,5) /
     &7.6536E-03,7.6870E-03,7.7033E-03,7.6954E-03,7.6994E-03/
      DATA (KB(JT,39, 6),JT=1,5) /
     &6.2054E-03,6.2357E-03,6.2573E-03,6.2573E-03,6.2600E-03/
      DATA (KB(JT,40, 6),JT=1,5) /
     &5.0787E-03,5.1000E-03,5.1231E-03,5.1304E-03,5.1270E-03/
      DATA (KB(JT,41, 6),JT=1,5) /
     &4.1553E-03,4.1734E-03,4.1950E-03,4.2100E-03,4.2073E-03/
      DATA (KB(JT,42, 6),JT=1,5) /
     &3.3951E-03,3.4115E-03,3.4321E-03,3.4456E-03,3.4459E-03/
      DATA (KB(JT,43, 6),JT=1,5) /
     &2.7739E-03,2.7892E-03,2.8063E-03,2.8198E-03,2.8248E-03/
      DATA (KB(JT,44, 6),JT=1,5) /
     &2.2638E-03,2.2784E-03,2.2918E-03,2.3046E-03,2.3113E-03/
      DATA (KB(JT,45, 6),JT=1,5) /
     &1.8451E-03,1.8580E-03,1.8678E-03,1.8806E-03,1.8860E-03/
      DATA (KB(JT,46, 6),JT=1,5) /
     &1.5013E-03,1.5134E-03,1.5237E-03,1.5316E-03,1.5391E-03/
      DATA (KB(JT,47, 6),JT=1,5) /
     &1.2205E-03,1.2340E-03,1.2429E-03,1.2503E-03,1.2568E-03/
      DATA (KB(JT,48, 6),JT=1,5) /
     &9.8959E-04,1.0036E-03,1.0115E-03,1.0182E-03,1.0235E-03/
      DATA (KB(JT,49, 6),JT=1,5) /
     &8.0128E-04,8.1327E-04,8.2211E-04,8.2807E-04,8.3181E-04/
      DATA (KB(JT,50, 6),JT=1,5) /
     &6.5077E-04,6.6049E-04,6.6942E-04,6.7493E-04,6.7909E-04/
      DATA (KB(JT,51, 6),JT=1,5) /
     &5.2860E-04,5.3765E-04,5.4562E-04,5.5099E-04,5.5519E-04/
      DATA (KB(JT,52, 6),JT=1,5) /
     &4.2741E-04,4.3678E-04,4.4379E-04,4.4944E-04,4.5321E-04/
      DATA (KB(JT,53, 6),JT=1,5) /
     &3.4420E-04,3.5368E-04,3.5979E-04,3.6513E-04,3.6858E-04/
      DATA (KB(JT,54, 6),JT=1,5) /
     &2.7911E-04,2.8752E-04,2.9393E-04,2.9865E-04,3.0238E-04/
      DATA (KB(JT,55, 6),JT=1,5) /
     &2.2659E-04,2.3415E-04,2.4084E-04,2.4534E-04,2.4896E-04/
      DATA (KB(JT,56, 6),JT=1,5) /
     &1.8317E-04,1.9078E-04,1.9656E-04,2.0135E-04,2.0466E-04/
      DATA (KB(JT,57, 6),JT=1,5) /
     &1.4828E-04,1.5527E-04,1.6035E-04,1.6503E-04,1.6825E-04/
      DATA (KB(JT,58, 6),JT=1,5) /
     &1.1818E-04,1.2542E-04,1.3082E-04,1.3476E-04,1.3831E-04/
      DATA (KB(JT,59, 6),JT=1,5) /
     &9.6673E-05,1.0368E-04,1.0861E-04,1.1211E-04,1.1553E-04/
      DATA (KB(JT,13, 7),JT=1,5) /
     &2.1727E+00,2.1507E+00,2.1220E+00,2.0892E+00,2.0541E+00/
      DATA (KB(JT,14, 7),JT=1,5) /
     &1.7980E+00,1.7753E+00,1.7493E+00,1.7241E+00,1.6941E+00/
      DATA (KB(JT,15, 7),JT=1,5) /
     &1.5327E+00,1.5148E+00,1.4951E+00,1.4705E+00,1.4480E+00/
      DATA (KB(JT,16, 7),JT=1,5) /
     &1.3007E+00,1.2909E+00,1.2720E+00,1.2527E+00,1.2359E+00/
      DATA (KB(JT,17, 7),JT=1,5) /
     &1.1117E+00,1.1002E+00,1.0859E+00,1.0728E+00,1.0608E+00/
      DATA (KB(JT,18, 7),JT=1,5) /
     &9.4895E-01,9.3669E-01,9.2658E-01,9.1630E-01,9.0461E-01/
      DATA (KB(JT,19, 7),JT=1,5) /
     &8.0771E-01,7.9960E-01,7.9052E-01,7.8134E-01,7.7103E-01/
      DATA (KB(JT,20, 7),JT=1,5) /
     &6.8397E-01,6.7733E-01,6.6931E-01,6.6104E-01,6.5276E-01/
      DATA (KB(JT,21, 7),JT=1,5) /
     &5.7680E-01,5.7078E-01,5.6416E-01,5.5706E-01,5.4996E-01/
      DATA (KB(JT,22, 7),JT=1,5) /
     &4.8402E-01,4.7901E-01,4.7292E-01,4.6701E-01,4.6224E-01/
      DATA (KB(JT,23, 7),JT=1,5) /
     &4.0435E-01,4.0004E-01,3.9588E-01,3.9219E-01,3.8835E-01/
      DATA (KB(JT,24, 7),JT=1,5) /
     &3.3766E-01,3.3478E-01,3.3178E-01,3.2887E-01,3.2604E-01/
      DATA (KB(JT,25, 7),JT=1,5) /
     &2.8141E-01,2.7941E-01,2.7716E-01,2.7469E-01,2.7266E-01/
      DATA (KB(JT,26, 7),JT=1,5) /
     &2.3429E-01,2.3260E-01,2.3087E-01,2.2897E-01,2.2751E-01/
      DATA (KB(JT,27, 7),JT=1,5) /
     &1.9420E-01,1.9275E-01,1.9122E-01,1.8991E-01,1.8923E-01/
      DATA (KB(JT,28, 7),JT=1,5) /
     &1.6015E-01,1.5905E-01,1.5800E-01,1.5718E-01,1.5696E-01/
      DATA (KB(JT,29, 7),JT=1,5) /
     &1.3094E-01,1.3014E-01,1.2944E-01,1.2906E-01,1.2899E-01/
      DATA (KB(JT,30, 7),JT=1,5) /
     &1.0666E-01,1.0604E-01,1.0563E-01,1.0549E-01,1.0548E-01/
      DATA (KB(JT,31, 7),JT=1,5) /
     &8.6275E-02,8.5845E-02,8.5617E-02,8.5505E-02,8.5535E-02/
      DATA (KB(JT,32, 7),JT=1,5) /
     &6.9798E-02,6.9528E-02,6.9393E-02,6.9336E-02,6.9374E-02/
      DATA (KB(JT,33, 7),JT=1,5) /
     &5.6418E-02,5.6253E-02,5.6185E-02,5.6126E-02,5.6165E-02/
      DATA (KB(JT,34, 7),JT=1,5) /
     &4.5866E-02,4.5727E-02,4.5682E-02,4.5616E-02,4.5707E-02/
      DATA (KB(JT,35, 7),JT=1,5) /
     &3.7274E-02,3.7180E-02,3.7143E-02,3.7120E-02,3.7200E-02/
      DATA (KB(JT,36, 7),JT=1,5) /
     &3.0350E-02,3.0274E-02,3.0257E-02,3.0235E-02,3.0299E-02/
      DATA (KB(JT,37, 7),JT=1,5) /
     &2.4821E-02,2.4753E-02,2.4742E-02,2.4741E-02,2.4790E-02/
      DATA (KB(JT,38, 7),JT=1,5) /
     &2.0268E-02,2.0223E-02,2.0196E-02,2.0200E-02,2.0236E-02/
      DATA (KB(JT,39, 7),JT=1,5) /
     &1.6521E-02,1.6487E-02,1.6459E-02,1.6462E-02,1.6499E-02/
      DATA (KB(JT,40, 7),JT=1,5) /
     &1.3551E-02,1.3542E-02,1.3531E-02,1.3538E-02,1.3571E-02/
      DATA (KB(JT,41, 7),JT=1,5) /
     &1.1139E-02,1.1135E-02,1.1130E-02,1.1141E-02,1.1171E-02/
      DATA (KB(JT,42, 7),JT=1,5) /
     &9.1492E-03,9.1515E-03,9.1518E-03,9.1649E-03,9.1900E-03/
      DATA (KB(JT,43, 7),JT=1,5) /
     &7.5083E-03,7.5191E-03,7.5258E-03,7.5334E-03,7.5552E-03/
      DATA (KB(JT,44, 7),JT=1,5) /
     &6.1594E-03,6.1707E-03,6.1785E-03,6.1865E-03,6.2090E-03/
      DATA (KB(JT,45, 7),JT=1,5) /
     &5.0436E-03,5.0526E-03,5.0656E-03,5.0711E-03,5.0867E-03/
      DATA (KB(JT,46, 7),JT=1,5) /
     &4.1291E-03,4.1408E-03,4.1483E-03,4.1539E-03,4.1670E-03/
      DATA (KB(JT,47, 7),JT=1,5) /
     &3.3808E-03,3.3903E-03,3.4014E-03,3.4059E-03,3.4179E-03/
      DATA (KB(JT,48, 7),JT=1,5) /
     &2.7630E-03,2.7730E-03,2.7794E-03,2.7876E-03,2.7961E-03/
      DATA (KB(JT,49, 7),JT=1,5) /
     &2.2529E-03,2.2614E-03,2.2681E-03,2.2743E-03,2.2825E-03/
      DATA (KB(JT,50, 7),JT=1,5) /
     &1.8409E-03,1.8507E-03,1.8571E-03,1.8629E-03,1.8694E-03/
      DATA (KB(JT,51, 7),JT=1,5) /
     &1.5059E-03,1.5160E-03,1.5224E-03,1.5287E-03,1.5343E-03/
      DATA (KB(JT,52, 7),JT=1,5) /
     &1.2303E-03,1.2392E-03,1.2461E-03,1.2522E-03,1.2570E-03/
      DATA (KB(JT,53, 7),JT=1,5) /
     &1.0020E-03,1.0115E-03,1.0178E-03,1.0227E-03,1.0281E-03/
      DATA (KB(JT,54, 7),JT=1,5) /
     &8.2130E-04,8.3060E-04,8.3778E-04,8.4304E-04,8.4741E-04/
      DATA (KB(JT,55, 7),JT=1,5) /
     &6.7498E-04,6.8670E-04,6.9292E-04,6.9895E-04,7.0313E-04/
      DATA (KB(JT,56, 7),JT=1,5) /
     &5.5427E-04,5.6524E-04,5.7318E-04,5.7892E-04,5.8355E-04/
      DATA (KB(JT,57, 7),JT=1,5) /
     &4.5437E-04,4.6585E-04,4.7333E-04,4.7899E-04,4.8346E-04/
      DATA (KB(JT,58, 7),JT=1,5) /
     &3.7314E-04,3.8385E-04,3.9164E-04,3.9732E-04,4.0183E-04/
      DATA (KB(JT,59, 7),JT=1,5) /
     &3.1164E-04,3.2163E-04,3.2929E-04,3.3498E-04,3.3967E-04/
      DATA (KB(JT,13, 8),JT=1,5) /
     &7.1017E+00,7.0462E+00,6.9629E+00,6.8569E+00,6.7518E+00/
      DATA (KB(JT,14, 8),JT=1,5) /
     &5.9884E+00,5.9470E+00,5.8924E+00,5.8216E+00,5.7342E+00/
      DATA (KB(JT,15, 8),JT=1,5) /
     &4.9849E+00,4.9563E+00,4.9071E+00,4.8502E+00,4.7771E+00/
      DATA (KB(JT,16, 8),JT=1,5) /
     &4.1453E+00,4.1136E+00,4.0790E+00,4.0345E+00,3.9753E+00/
      DATA (KB(JT,17, 8),JT=1,5) /
     &3.5269E+00,3.5022E+00,3.4717E+00,3.4323E+00,3.3830E+00/
      DATA (KB(JT,18, 8),JT=1,5) /
     &3.0258E+00,3.0139E+00,2.9887E+00,2.9518E+00,2.9096E+00/
      DATA (KB(JT,19, 8),JT=1,5) /
     &2.6100E+00,2.6057E+00,2.5839E+00,2.5531E+00,2.5181E+00/
      DATA (KB(JT,20, 8),JT=1,5) /
     &2.2532E+00,2.2444E+00,2.2242E+00,2.2015E+00,2.1737E+00/
      DATA (KB(JT,21, 8),JT=1,5) /
     &1.9361E+00,1.9257E+00,1.9080E+00,1.8885E+00,1.8663E+00/
      DATA (KB(JT,22, 8),JT=1,5) /
     &1.6493E+00,1.6394E+00,1.6256E+00,1.6084E+00,1.5911E+00/
      DATA (KB(JT,23, 8),JT=1,5) /
     &1.3971E+00,1.3901E+00,1.3774E+00,1.3628E+00,1.3482E+00/
      DATA (KB(JT,24, 8),JT=1,5) /
     &1.1828E+00,1.1757E+00,1.1653E+00,1.1541E+00,1.1420E+00/
      DATA (KB(JT,25, 8),JT=1,5) /
     &9.9841E-01,9.9173E-01,9.8314E-01,9.7419E-01,9.6526E-01/
      DATA (KB(JT,26, 8),JT=1,5) /
     &8.3815E-01,8.3237E-01,8.2631E-01,8.2072E-01,8.1439E-01/
      DATA (KB(JT,27, 8),JT=1,5) /
     &6.9885E-01,6.9534E-01,6.9172E-01,6.8787E-01,6.8202E-01/
      DATA (KB(JT,28, 8),JT=1,5) /
     &5.8056E-01,5.7858E-01,5.7609E-01,5.7252E-01,5.6730E-01/
      DATA (KB(JT,29, 8),JT=1,5) /
     &4.7795E-01,4.7646E-01,4.7447E-01,4.7127E-01,4.6716E-01/
      DATA (KB(JT,30, 8),JT=1,5) /
     &3.9180E-01,3.9040E-01,3.8874E-01,3.8567E-01,3.8256E-01/
      DATA (KB(JT,31, 8),JT=1,5) /
     &3.1850E-01,3.1735E-01,3.1544E-01,3.1324E-01,3.1109E-01/
      DATA (KB(JT,32, 8),JT=1,5) /
     &2.5851E-01,2.5736E-01,2.5590E-01,2.5439E-01,2.5264E-01/
      DATA (KB(JT,33, 8),JT=1,5) /
     &2.0938E-01,2.0841E-01,2.0741E-01,2.0615E-01,2.0501E-01/
      DATA (KB(JT,34, 8),JT=1,5) /
     &1.7037E-01,1.6964E-01,1.6891E-01,1.6812E-01,1.6728E-01/
      DATA (KB(JT,35, 8),JT=1,5) /
     &1.3875E-01,1.3827E-01,1.3776E-01,1.3724E-01,1.3661E-01/
      DATA (KB(JT,36, 8),JT=1,5) /
     &1.1324E-01,1.1288E-01,1.1260E-01,1.1226E-01,1.1182E-01/
      DATA (KB(JT,37, 8),JT=1,5) /
     &9.2766E-02,9.2595E-02,9.2422E-02,9.2186E-02,9.1910E-02/
      DATA (KB(JT,38, 8),JT=1,5) /
     &7.5939E-02,7.5826E-02,7.5761E-02,7.5637E-02,7.5518E-02/
      DATA (KB(JT,39, 8),JT=1,5) /
     &6.2076E-02,6.2014E-02,6.2019E-02,6.2000E-02,6.1957E-02/
      DATA (KB(JT,40, 8),JT=1,5) /
     &5.1067E-02,5.1119E-02,5.1147E-02,5.1217E-02,5.1232E-02/
      DATA (KB(JT,41, 8),JT=1,5) /
     &4.2004E-02,4.2110E-02,4.2194E-02,4.2288E-02,4.2348E-02/
      DATA (KB(JT,42, 8),JT=1,5) /
     &3.4565E-02,3.4686E-02,3.4772E-02,3.4891E-02,3.5001E-02/
      DATA (KB(JT,43, 8),JT=1,5) /
     &2.8439E-02,2.8558E-02,2.8651E-02,2.8781E-02,2.8908E-02/
      DATA (KB(JT,44, 8),JT=1,5) /
     &2.3381E-02,2.3495E-02,2.3607E-02,2.3736E-02,2.3863E-02/
      DATA (KB(JT,45, 8),JT=1,5) /
     &1.9178E-02,1.9302E-02,1.9411E-02,1.9527E-02,1.9645E-02/
      DATA (KB(JT,46, 8),JT=1,5) /
     &1.5718E-02,1.5824E-02,1.5935E-02,1.6052E-02,1.6161E-02/
      DATA (KB(JT,47, 8),JT=1,5) /
     &1.2888E-02,1.2994E-02,1.3091E-02,1.3201E-02,1.3310E-02/
      DATA (KB(JT,48, 8),JT=1,5) /
     &1.0534E-02,1.0644E-02,1.0741E-02,1.0828E-02,1.0922E-02/
      DATA (KB(JT,49, 8),JT=1,5) /
     &8.5773E-03,8.6840E-03,8.7716E-03,8.8561E-03,8.9344E-03/
      DATA (KB(JT,50, 8),JT=1,5) /
     &7.0118E-03,7.1121E-03,7.1954E-03,7.2655E-03,7.3372E-03/
      DATA (KB(JT,51, 8),JT=1,5) /
     &5.7344E-03,5.8326E-03,5.9098E-03,5.9770E-03,6.0423E-03/
      DATA (KB(JT,52, 8),JT=1,5) /
     &4.6784E-03,4.7703E-03,4.8415E-03,4.9016E-03,4.9646E-03/
      DATA (KB(JT,53, 8),JT=1,5) /
     &3.8084E-03,3.8892E-03,3.9565E-03,4.0107E-03,4.0624E-03/
      DATA (KB(JT,54, 8),JT=1,5) /
     &3.1302E-03,3.1988E-03,3.2604E-03,3.3140E-03,3.3627E-03/
      DATA (KB(JT,55, 8),JT=1,5) /
     &2.5815E-03,2.6417E-03,2.7045E-03,2.7548E-03,2.8045E-03/
      DATA (KB(JT,56, 8),JT=1,5) /
     &2.1299E-03,2.1858E-03,2.2412E-03,2.2906E-03,2.3394E-03/
      DATA (KB(JT,57, 8),JT=1,5) /
     &1.7549E-03,1.8058E-03,1.8577E-03,1.9050E-03,1.9496E-03/
      DATA (KB(JT,58, 8),JT=1,5) /
     &1.4508E-03,1.4946E-03,1.5437E-03,1.5867E-03,1.6288E-03/
      DATA (KB(JT,59, 8),JT=1,5) /
     &1.2226E-03,1.2669E-03,1.3143E-03,1.3547E-03,1.3969E-03/
      DATA (KB(JT,13, 9),JT=1,5) /
     &4.2167E+01,4.2169E+01,4.2037E+01,4.1794E+01,4.1453E+01/
      DATA (KB(JT,14, 9),JT=1,5) /
     &3.6302E+01,3.6287E+01,3.6134E+01,3.5895E+01,3.5553E+01/
      DATA (KB(JT,15, 9),JT=1,5) /
     &3.1018E+01,3.0974E+01,3.0831E+01,3.0595E+01,3.0284E+01/
      DATA (KB(JT,16, 9),JT=1,5) /
     &2.6381E+01,2.6327E+01,2.6171E+01,2.5940E+01,2.5630E+01/
      DATA (KB(JT,17, 9),JT=1,5) /
     &2.2159E+01,2.2069E+01,2.1921E+01,2.1709E+01,2.1443E+01/
      DATA (KB(JT,18, 9),JT=1,5) /
     &1.8546E+01,1.8422E+01,1.8249E+01,1.8049E+01,1.7832E+01/
      DATA (KB(JT,19, 9),JT=1,5) /
     &1.5581E+01,1.5418E+01,1.5257E+01,1.5071E+01,1.4880E+01/
      DATA (KB(JT,20, 9),JT=1,5) /
     &1.3153E+01,1.2997E+01,1.2837E+01,1.2663E+01,1.2482E+01/
      DATA (KB(JT,21, 9),JT=1,5) /
     &1.1154E+01,1.1003E+01,1.0876E+01,1.0723E+01,1.0559E+01/
      DATA (KB(JT,22, 9),JT=1,5) /
     &9.6248E+00,9.4985E+00,9.3603E+00,9.2175E+00,9.0746E+00/
      DATA (KB(JT,23, 9),JT=1,5) /
     &8.3452E+00,8.2318E+00,8.1134E+00,7.9935E+00,7.8653E+00/
      DATA (KB(JT,24, 9),JT=1,5) /
     &7.2560E+00,7.1534E+00,7.0580E+00,6.9498E+00,6.8440E+00/
      DATA (KB(JT,25, 9),JT=1,5) /
     &6.3013E+00,6.2279E+00,6.1411E+00,6.0460E+00,5.9566E+00/
      DATA (KB(JT,26, 9),JT=1,5) /
     &5.4473E+00,5.3837E+00,5.3066E+00,5.2353E+00,5.1609E+00/
      DATA (KB(JT,27, 9),JT=1,5) /
     &4.6665E+00,4.6055E+00,4.5477E+00,4.4876E+00,4.4277E+00/
      DATA (KB(JT,28, 9),JT=1,5) /
     &3.9616E+00,3.9145E+00,3.8668E+00,3.8180E+00,3.7694E+00/
      DATA (KB(JT,29, 9),JT=1,5) /
     &3.3226E+00,3.2862E+00,3.2469E+00,3.2091E+00,3.1718E+00/
      DATA (KB(JT,30, 9),JT=1,5) /
     &2.7659E+00,2.7390E+00,2.7094E+00,2.6815E+00,2.6543E+00/
      DATA (KB(JT,31, 9),JT=1,5) /
     &2.2826E+00,2.2617E+00,2.2409E+00,2.2203E+00,2.1979E+00/
      DATA (KB(JT,32, 9),JT=1,5) /
     &1.8802E+00,1.8648E+00,1.8493E+00,1.8340E+00,1.8168E+00/
      DATA (KB(JT,33, 9),JT=1,5) /
     &1.5466E+00,1.5353E+00,1.5232E+00,1.5114E+00,1.4999E+00/
      DATA (KB(JT,34, 9),JT=1,5) /
     &1.2752E+00,1.2674E+00,1.2588E+00,1.2512E+00,1.2426E+00/
      DATA (KB(JT,35, 9),JT=1,5) /
     &1.0520E+00,1.0466E+00,1.0412E+00,1.0356E+00,1.0296E+00/
      DATA (KB(JT,36, 9),JT=1,5) /
     &8.6897E-01,8.6546E-01,8.6220E-01,8.5818E-01,8.5421E-01/
      DATA (KB(JT,37, 9),JT=1,5) /
     &7.1978E-01,7.1767E-01,7.1572E-01,7.1373E-01,7.1176E-01/
      DATA (KB(JT,38, 9),JT=1,5) /
     &5.9482E-01,5.9396E-01,5.9353E-01,5.9295E-01,5.9232E-01/
      DATA (KB(JT,39, 9),JT=1,5) /
     &4.9071E-01,4.9116E-01,4.9162E-01,4.9173E-01,4.9201E-01/
      DATA (KB(JT,40, 9),JT=1,5) /
     &4.0707E-01,4.0846E-01,4.0948E-01,4.1018E-01,4.1089E-01/
      DATA (KB(JT,41, 9),JT=1,5) /
     &3.3813E-01,3.3959E-01,3.4089E-01,3.4218E-01,3.4329E-01/
      DATA (KB(JT,42, 9),JT=1,5) /
     &2.8061E-01,2.8231E-01,2.8363E-01,2.8501E-01,2.8630E-01/
      DATA (KB(JT,43, 9),JT=1,5) /
     &2.3284E-01,2.3448E-01,2.3606E-01,2.3737E-01,2.3893E-01/
      DATA (KB(JT,44, 9),JT=1,5) /
     &1.9306E-01,1.9456E-01,1.9627E-01,1.9759E-01,1.9913E-01/
      DATA (KB(JT,45, 9),JT=1,5) /
     &1.5984E-01,1.6139E-01,1.6282E-01,1.6435E-01,1.6569E-01/
      DATA (KB(JT,46, 9),JT=1,5) /
     &1.3218E-01,1.3367E-01,1.3504E-01,1.3656E-01,1.3780E-01/
      DATA (KB(JT,47, 9),JT=1,5) /
     &1.0925E-01,1.1079E-01,1.1209E-01,1.1337E-01,1.1463E-01/
      DATA (KB(JT,48, 9),JT=1,5) /
     &9.0249E-02,9.1522E-02,9.2774E-02,9.3960E-02,9.5177E-02/
      DATA (KB(JT,49, 9),JT=1,5) /
     &7.4377E-02,7.5400E-02,7.6569E-02,7.7633E-02,7.8742E-02/
      DATA (KB(JT,50, 9),JT=1,5) /
     &6.1418E-02,6.2415E-02,6.3422E-02,6.4413E-02,6.5389E-02/
      DATA (KB(JT,51, 9),JT=1,5) /
     &5.0729E-02,5.1644E-02,5.2564E-02,5.3444E-02,5.4353E-02/
      DATA (KB(JT,52, 9),JT=1,5) /
     &4.1908E-02,4.2660E-02,4.3502E-02,4.4323E-02,4.5095E-02/
      DATA (KB(JT,53, 9),JT=1,5) /
     &3.4462E-02,3.5223E-02,3.5939E-02,3.6640E-02,3.7360E-02/
      DATA (KB(JT,54, 9),JT=1,5) /
     &2.8588E-02,2.9269E-02,2.9929E-02,3.0560E-02,3.1160E-02/
      DATA (KB(JT,55, 9),JT=1,5) /
     &2.3807E-02,2.4406E-02,2.4997E-02,2.5573E-02,2.6196E-02/
      DATA (KB(JT,56, 9),JT=1,5) /
     &1.9841E-02,2.0395E-02,2.0945E-02,2.1491E-02,2.2006E-02/
      DATA (KB(JT,57, 9),JT=1,5) /
     &1.6519E-02,1.7032E-02,1.7546E-02,1.8054E-02,1.8550E-02/
      DATA (KB(JT,58, 9),JT=1,5) /
     &1.3793E-02,1.4292E-02,1.4753E-02,1.5213E-02,1.5695E-02/
      DATA (KB(JT,59, 9),JT=1,5) /
     &1.1809E-02,1.2269E-02,1.2713E-02,1.3163E-02,1.3635E-02/
      DATA (KB(JT,13,10),JT=1,5) /
     &1.7142E+02,1.7281E+02,1.7236E+02,1.7114E+02,1.6934E+02/
      DATA (KB(JT,14,10),JT=1,5) /
     &1.5574E+02,1.5556E+02,1.5469E+02,1.5334E+02,1.5193E+02/
      DATA (KB(JT,15,10),JT=1,5) /
     &1.3728E+02,1.3704E+02,1.3637E+02,1.3560E+02,1.3459E+02/
      DATA (KB(JT,16,10),JT=1,5) /
     &1.1953E+02,1.1932E+02,1.1895E+02,1.1818E+02,1.1715E+02/
      DATA (KB(JT,17,10),JT=1,5) /
     &1.0359E+02,1.0375E+02,1.0320E+02,1.0240E+02,1.0131E+02/
      DATA (KB(JT,18,10),JT=1,5) /
     &8.8878E+01,8.9020E+01,8.8706E+01,8.7973E+01,8.6746E+01/
      DATA (KB(JT,19,10),JT=1,5) /
     &7.4020E+01,7.4305E+01,7.4019E+01,7.3466E+01,7.2562E+01/
      DATA (KB(JT,20,10),JT=1,5) /
     &6.0721E+01,6.1015E+01,6.0921E+01,6.0532E+01,5.9983E+01/
      DATA (KB(JT,21,10),JT=1,5) /
     &5.0465E+01,5.0665E+01,5.0241E+01,4.9849E+01,4.9385E+01/
      DATA (KB(JT,22,10),JT=1,5) /
     &4.0819E+01,4.0731E+01,4.0529E+01,4.0271E+01,3.9749E+01/
      DATA (KB(JT,23,10),JT=1,5) /
     &3.4205E+01,3.4202E+01,3.4020E+01,3.3582E+01,3.3186E+01/
      DATA (KB(JT,24,10),JT=1,5) /
     &2.9307E+01,2.9168E+01,2.8849E+01,2.8552E+01,2.8160E+01/
      DATA (KB(JT,25,10),JT=1,5) /
     &2.5427E+01,2.5125E+01,2.4814E+01,2.4511E+01,2.4195E+01/
      DATA (KB(JT,26,10),JT=1,5) /
     &2.2227E+01,2.1953E+01,2.1723E+01,2.1344E+01,2.1061E+01/
      DATA (KB(JT,27,10),JT=1,5) /
     &1.9562E+01,1.9387E+01,1.9087E+01,1.8779E+01,1.8567E+01/
      DATA (KB(JT,28,10),JT=1,5) /
     &1.7147E+01,1.6935E+01,1.6668E+01,1.6479E+01,1.6263E+01/
      DATA (KB(JT,29,10),JT=1,5) /
     &1.4781E+01,1.4573E+01,1.4404E+01,1.4242E+01,1.4093E+01/
      DATA (KB(JT,30,10),JT=1,5) /
     &1.2615E+01,1.2471E+01,1.2325E+01,1.2193E+01,1.2047E+01/
      DATA (KB(JT,31,10),JT=1,5) /
     &1.0637E+01,1.0540E+01,1.0405E+01,1.0303E+01,1.0219E+01/
      DATA (KB(JT,32,10),JT=1,5) /
     &8.9113E+00,8.8364E+00,8.7502E+00,8.6801E+00,8.6141E+00/
      DATA (KB(JT,33,10),JT=1,5) /
     &7.4220E+00,7.3714E+00,7.3296E+00,7.2916E+00,7.2335E+00/
      DATA (KB(JT,34,10),JT=1,5) /
     &6.2166E+00,6.1844E+00,6.1565E+00,6.1097E+00,6.0839E+00/
      DATA (KB(JT,35,10),JT=1,5) /
     &5.1978E+00,5.1804E+00,5.1597E+00,5.1357E+00,5.1182E+00/
      DATA (KB(JT,36,10),JT=1,5) /
     &4.3470E+00,4.3385E+00,4.3233E+00,4.3177E+00,4.3104E+00/
      DATA (KB(JT,37,10),JT=1,5) /
     &3.6398E+00,3.6424E+00,3.6345E+00,3.6386E+00,3.6334E+00/
      DATA (KB(JT,38,10),JT=1,5) /
     &3.0434E+00,3.0512E+00,3.0559E+00,3.0639E+00,3.0639E+00/
      DATA (KB(JT,39,10),JT=1,5) /
     &2.5458E+00,2.5538E+00,2.5569E+00,2.5728E+00,2.5769E+00/
      DATA (KB(JT,40,10),JT=1,5) /
     &2.1317E+00,2.1438E+00,2.1539E+00,2.1706E+00,2.1835E+00/
      DATA (KB(JT,41,10),JT=1,5) /
     &1.7848E+00,1.8052E+00,1.8158E+00,1.8336E+00,1.8470E+00/
      DATA (KB(JT,42,10),JT=1,5) /
     &1.4932E+00,1.5091E+00,1.5289E+00,1.5466E+00,1.5621E+00/
      DATA (KB(JT,43,10),JT=1,5) /
     &1.2466E+00,1.2672E+00,1.2843E+00,1.3063E+00,1.3216E+00/
      DATA (KB(JT,44,10),JT=1,5) /
     &1.0395E+00,1.0592E+00,1.0758E+00,1.0990E+00,1.1149E+00/
      DATA (KB(JT,45,10),JT=1,5) /
     &8.6570E-01,8.8331E-01,9.0051E-01,9.1956E-01,9.3855E-01/
      DATA (KB(JT,46,10),JT=1,5) /
     &7.2006E-01,7.3467E-01,7.5104E-01,7.6845E-01,7.8787E-01/
      DATA (KB(JT,47,10),JT=1,5) /
     &5.9818E-01,6.0970E-01,6.2444E-01,6.4248E-01,6.5898E-01/
      DATA (KB(JT,48,10),JT=1,5) /
     &4.9441E-01,5.0661E-01,5.1925E-01,5.3379E-01,5.5029E-01/
      DATA (KB(JT,49,10),JT=1,5) /
     &4.0883E-01,4.1946E-01,4.3019E-01,4.4310E-01,4.5870E-01/
      DATA (KB(JT,50,10),JT=1,5) /
     &3.3724E-01,3.4698E-01,3.5791E-01,3.6811E-01,3.8262E-01/
      DATA (KB(JT,51,10),JT=1,5) /
     &2.7937E-01,2.8820E-01,2.9748E-01,3.0671E-01,3.1956E-01/
      DATA (KB(JT,52,10),JT=1,5) /
     &2.3100E-01,2.3806E-01,2.4610E-01,2.5504E-01,2.6621E-01/
      DATA (KB(JT,53,10),JT=1,5) /
     &1.9108E-01,1.9654E-01,2.0325E-01,2.1194E-01,2.2154E-01/
      DATA (KB(JT,54,10),JT=1,5) /
     &1.5899E-01,1.6347E-01,1.6947E-01,1.7655E-01,1.8610E-01/
      DATA (KB(JT,55,10),JT=1,5) /
     &1.3326E-01,1.3696E-01,1.4221E-01,1.4834E-01,1.5647E-01/
      DATA (KB(JT,56,10),JT=1,5) /
     &1.1049E-01,1.1469E-01,1.1935E-01,1.2428E-01,1.3176E-01/
      DATA (KB(JT,57,10),JT=1,5) /
     &9.2761E-02,9.6003E-02,9.9705E-02,1.0515E-01,1.1098E-01/
      DATA (KB(JT,58,10),JT=1,5) /
     &7.7951E-02,8.0603E-02,8.4255E-02,8.8708E-02,9.3824E-02/
      DATA (KB(JT,59,10),JT=1,5) /
     &6.6831E-02,6.9853E-02,7.3196E-02,7.7714E-02,8.2447E-02/
      DATA (KB(JT,13,11),JT=1,5) /
     &2.9044E+02,2.9107E+02,2.9274E+02,2.9324E+02,2.9124E+02/
      DATA (KB(JT,14,11),JT=1,5) /
     &2.7118E+02,2.7257E+02,2.7251E+02,2.7007E+02,2.6710E+02/
      DATA (KB(JT,15,11),JT=1,5) /
     &2.5062E+02,2.5131E+02,2.4974E+02,2.4698E+02,2.4378E+02/
      DATA (KB(JT,16,11),JT=1,5) /
     &2.2673E+02,2.2541E+02,2.2341E+02,2.2106E+02,2.1873E+02/
      DATA (KB(JT,17,11),JT=1,5) /
     &1.9976E+02,1.9861E+02,1.9716E+02,1.9539E+02,1.9362E+02/
      DATA (KB(JT,18,11),JT=1,5) /
     &1.7313E+02,1.7242E+02,1.7179E+02,1.7065E+02,1.6917E+02/
      DATA (KB(JT,19,11),JT=1,5) /
     &1.5014E+02,1.4982E+02,1.4894E+02,1.4750E+02,1.4584E+02/
      DATA (KB(JT,20,11),JT=1,5) /
     &1.2916E+02,1.2859E+02,1.2771E+02,1.2637E+02,1.2459E+02/
      DATA (KB(JT,21,11),JT=1,5) /
     &1.0806E+02,1.0775E+02,1.0718E+02,1.0610E+02,1.0475E+02/
      DATA (KB(JT,22,11),JT=1,5) /
     &8.9165E+01,8.9073E+01,8.8652E+01,8.7815E+01,8.6979E+01/
      DATA (KB(JT,23,11),JT=1,5) /
     &7.2556E+01,7.2172E+01,7.1575E+01,7.1058E+01,7.0305E+01/
      DATA (KB(JT,24,11),JT=1,5) /
     &5.8830E+01,5.8306E+01,5.7758E+01,5.7080E+01,5.6291E+01/
      DATA (KB(JT,25,11),JT=1,5) /
     &4.9821E+01,4.9499E+01,4.8965E+01,4.8414E+01,4.7810E+01/
      DATA (KB(JT,26,11),JT=1,5) /
     &4.2622E+01,4.2267E+01,4.1876E+01,4.1470E+01,4.0806E+01/
      DATA (KB(JT,27,11),JT=1,5) /
     &3.6706E+01,3.6324E+01,3.5968E+01,3.5540E+01,3.5058E+01/
      DATA (KB(JT,28,11),JT=1,5) /
     &3.1978E+01,3.1566E+01,3.1237E+01,3.0772E+01,3.0454E+01/
      DATA (KB(JT,29,11),JT=1,5) /
     &2.7828E+01,2.7575E+01,2.7171E+01,2.6860E+01,2.6508E+01/
      DATA (KB(JT,30,11),JT=1,5) /
     &2.4147E+01,2.3835E+01,2.3571E+01,2.3332E+01,2.3114E+01/
      DATA (KB(JT,31,11),JT=1,5) /
     &2.0703E+01,2.0408E+01,2.0254E+01,2.0067E+01,1.9883E+01/
      DATA (KB(JT,32,11),JT=1,5) /
     &1.7639E+01,1.7476E+01,1.7324E+01,1.7159E+01,1.7076E+01/
      DATA (KB(JT,33,11),JT=1,5) /
     &1.4975E+01,1.4865E+01,1.4744E+01,1.4668E+01,1.4624E+01/
      DATA (KB(JT,34,11),JT=1,5) /
     &1.2711E+01,1.2631E+01,1.2589E+01,1.2550E+01,1.2508E+01/
      DATA (KB(JT,35,11),JT=1,5) /
     &1.0751E+01,1.0723E+01,1.0704E+01,1.0702E+01,1.0681E+01/
      DATA (KB(JT,36,11),JT=1,5) /
     &9.0814E+00,9.0752E+00,9.0908E+00,9.1081E+00,9.1217E+00/
      DATA (KB(JT,37,11),JT=1,5) /
     &7.6820E+00,7.7040E+00,7.7379E+00,7.7515E+00,7.7864E+00/
      DATA (KB(JT,38,11),JT=1,5) /
     &6.4923E+00,6.5176E+00,6.5490E+00,6.5779E+00,6.6281E+00/
      DATA (KB(JT,39,11),JT=1,5) /
     &5.4567E+00,5.4975E+00,5.5468E+00,5.5843E+00,5.6396E+00/
      DATA (KB(JT,40,11),JT=1,5) /
     &4.6201E+00,4.6597E+00,4.7074E+00,4.7531E+00,4.8054E+00/
      DATA (KB(JT,41,11),JT=1,5) /
     &3.8974E+00,3.9399E+00,3.9967E+00,4.0418E+00,4.1011E+00/
      DATA (KB(JT,42,11),JT=1,5) /
     &3.2907E+00,3.3361E+00,3.3839E+00,3.4382E+00,3.4997E+00/
      DATA (KB(JT,43,11),JT=1,5) /
     &2.7732E+00,2.8146E+00,2.8677E+00,2.9201E+00,2.9866E+00/
      DATA (KB(JT,44,11),JT=1,5) /
     &2.3284E+00,2.3728E+00,2.4251E+00,2.4785E+00,2.5440E+00/
      DATA (KB(JT,45,11),JT=1,5) /
     &1.9528E+00,1.9951E+00,2.0498E+00,2.1003E+00,2.1644E+00/
      DATA (KB(JT,46,11),JT=1,5) /
     &1.6318E+00,1.6755E+00,1.7227E+00,1.7737E+00,1.8354E+00/
      DATA (KB(JT,47,11),JT=1,5) /
     &1.3599E+00,1.4032E+00,1.4486E+00,1.4978E+00,1.5556E+00/
      DATA (KB(JT,48,11),JT=1,5) /
     &1.1311E+00,1.1685E+00,1.2136E+00,1.2615E+00,1.3144E+00/
      DATA (KB(JT,49,11),JT=1,5) /
     &9.3555E-01,9.7341E-01,1.0126E+00,1.0587E+00,1.1063E+00/
      DATA (KB(JT,50,11),JT=1,5) /
     &7.7693E-01,8.0966E-01,8.4684E-01,8.9020E-01,9.3317E-01/
      DATA (KB(JT,51,11),JT=1,5) /
     &6.4536E-01,6.7488E-01,7.0604E-01,7.4875E-01,7.8723E-01/
      DATA (KB(JT,52,11),JT=1,5) /
     &5.3457E-01,5.5971E-01,5.9092E-01,6.2609E-01,6.6312E-01/
      DATA (KB(JT,53,11),JT=1,5) /
     &4.4222E-01,4.6435E-01,4.9056E-01,5.2208E-01,5.5614E-01/
      DATA (KB(JT,54,11),JT=1,5) /
     &3.6743E-01,3.8638E-01,4.1127E-01,4.3844E-01,4.6892E-01/
      DATA (KB(JT,55,11),JT=1,5) /
     &3.0658E-01,3.2360E-01,3.4391E-01,3.6924E-01,3.9670E-01/
      DATA (KB(JT,56,11),JT=1,5) /
     &2.5551E-01,2.6954E-01,2.8819E-01,3.1080E-01,3.3508E-01/
      DATA (KB(JT,57,11),JT=1,5) /
     &2.1322E-01,2.2632E-01,2.4139E-01,2.5957E-01,2.8310E-01/
      DATA (KB(JT,58,11),JT=1,5) /
     &1.7898E-01,1.8948E-01,2.0228E-01,2.1870E-01,2.4000E-01/
      DATA (KB(JT,59,11),JT=1,5) /
     &1.5351E-01,1.6320E-01,1.7439E-01,1.8953E-01,2.0982E-01/
      DATA (KB(JT,13,12),JT=1,5) /
     &5.5035E+02,5.5083E+02,5.4893E+02,5.4549E+02,5.4357E+02/
      DATA (KB(JT,14,12),JT=1,5) /
     &5.1666E+02,5.1747E+02,5.1731E+02,5.1865E+02,5.1926E+02/
      DATA (KB(JT,15,12),JT=1,5) /
     &4.8259E+02,4.8322E+02,4.8500E+02,4.8625E+02,4.8440E+02/
      DATA (KB(JT,16,12),JT=1,5) /
     &4.4814E+02,4.5080E+02,4.5253E+02,4.5080E+02,4.4664E+02/
      DATA (KB(JT,17,12),JT=1,5) /
     &4.1611E+02,4.1780E+02,4.1594E+02,4.1174E+02,4.0672E+02/
      DATA (KB(JT,18,12),JT=1,5) /
     &3.8097E+02,3.8017E+02,3.7694E+02,3.7269E+02,3.6847E+02/
      DATA (KB(JT,19,12),JT=1,5) /
     &3.3900E+02,3.3735E+02,3.3499E+02,3.3205E+02,3.2864E+02/
      DATA (KB(JT,20,12),JT=1,5) /
     &2.9644E+02,2.9567E+02,2.9387E+02,2.9171E+02,2.8914E+02/
      DATA (KB(JT,21,12),JT=1,5) /
     &2.5711E+02,2.5659E+02,2.5545E+02,2.5349E+02,2.5090E+02/
      DATA (KB(JT,22,12),JT=1,5) /
     &2.2227E+02,2.2144E+02,2.1973E+02,2.1742E+02,2.1472E+02/
      DATA (KB(JT,23,12),JT=1,5) /
     &1.8874E+02,1.8786E+02,1.8655E+02,1.8434E+02,1.8190E+02/
      DATA (KB(JT,24,12),JT=1,5) /
     &1.5708E+02,1.5682E+02,1.5564E+02,1.5414E+02,1.5250E+02/
      DATA (KB(JT,25,12),JT=1,5) /
     &1.2691E+02,1.2649E+02,1.2582E+02,1.2476E+02,1.2335E+02/
      DATA (KB(JT,26,12),JT=1,5) /
     &1.0261E+02,1.0208E+02,1.0124E+02,1.0027E+02,9.9263E+01/
      DATA (KB(JT,27,12),JT=1,5) /
     &8.5769E+01,8.4989E+01,8.4207E+01,8.3351E+01,8.2249E+01/
      DATA (KB(JT,28,12),JT=1,5) /
     &7.3314E+01,7.2801E+01,7.2005E+01,7.1293E+01,7.0277E+01/
      DATA (KB(JT,29,12),JT=1,5) /
     &6.2526E+01,6.2052E+01,6.1497E+01,6.0774E+01,6.0060E+01/
      DATA (KB(JT,30,12),JT=1,5) /
     &5.3636E+01,5.3199E+01,5.2692E+01,5.1970E+01,5.1392E+01/
      DATA (KB(JT,31,12),JT=1,5) /
     &4.6032E+01,4.5690E+01,4.5122E+01,4.4615E+01,4.4345E+01/
      DATA (KB(JT,32,12),JT=1,5) /
     &3.9736E+01,3.9262E+01,3.8850E+01,3.8552E+01,3.8247E+01/
      DATA (KB(JT,33,12),JT=1,5) /
     &3.4154E+01,3.3807E+01,3.3534E+01,3.3264E+01,3.3008E+01/
      DATA (KB(JT,34,12),JT=1,5) /
     &2.9451E+01,2.9219E+01,2.9024E+01,2.8833E+01,2.8685E+01/
      DATA (KB(JT,35,12),JT=1,5) /
     &2.5346E+01,2.5246E+01,2.5119E+01,2.4977E+01,2.4976E+01/
      DATA (KB(JT,36,12),JT=1,5) /
     &2.1817E+01,2.1779E+01,2.1703E+01,2.1681E+01,2.1750E+01/
      DATA (KB(JT,37,12),JT=1,5) /
     &1.8813E+01,1.8767E+01,1.8799E+01,1.8847E+01,1.8941E+01/
      DATA (KB(JT,38,12),JT=1,5) /
     &1.6125E+01,1.6141E+01,1.6208E+01,1.6337E+01,1.6455E+01/
      DATA (KB(JT,39,12),JT=1,5) /
     &1.3770E+01,1.3861E+01,1.3953E+01,1.4099E+01,1.4238E+01/
      DATA (KB(JT,40,12),JT=1,5) /
     &1.1787E+01,1.1887E+01,1.2028E+01,1.2178E+01,1.2352E+01/
      DATA (KB(JT,41,12),JT=1,5) /
     &1.0073E+01,1.0213E+01,1.0351E+01,1.0547E+01,1.0724E+01/
      DATA (KB(JT,42,12),JT=1,5) /
     &8.5925E+00,8.7331E+00,8.9300E+00,9.0948E+00,9.2833E+00/
      DATA (KB(JT,43,12),JT=1,5) /
     &7.3118E+00,7.4895E+00,7.6577E+00,7.8465E+00,8.0457E+00/
      DATA (KB(JT,44,12),JT=1,5) /
     &6.2222E+00,6.3886E+00,6.5774E+00,6.7646E+00,6.9710E+00/
      DATA (KB(JT,45,12),JT=1,5) /
     &5.2923E+00,5.4528E+00,5.6365E+00,5.8147E+00,6.0122E+00/
      DATA (KB(JT,46,12),JT=1,5) /
     &4.4844E+00,4.6394E+00,4.8198E+00,4.9986E+00,5.1861E+00/
      DATA (KB(JT,47,12),JT=1,5) /
     &3.7915E+00,3.9458E+00,4.1119E+00,4.2905E+00,4.4702E+00/
      DATA (KB(JT,48,12),JT=1,5) /
     &3.2031E+00,3.3449E+00,3.4984E+00,3.6554E+00,3.8276E+00/
      DATA (KB(JT,49,12),JT=1,5) /
     &2.6829E+00,2.8156E+00,2.9666E+00,3.1113E+00,3.2647E+00/
      DATA (KB(JT,50,12),JT=1,5) /
     &2.2570E+00,2.3778E+00,2.5052E+00,2.6542E+00,2.7988E+00/
      DATA (KB(JT,51,12),JT=1,5) /
     &1.8957E+00,2.0048E+00,2.1275E+00,2.2538E+00,2.3944E+00/
      DATA (KB(JT,52,12),JT=1,5) /
     &1.5859E+00,1.6936E+00,1.7982E+00,1.9164E+00,2.0433E+00/
      DATA (KB(JT,53,12),JT=1,5) /
     &1.3268E+00,1.4138E+00,1.5132E+00,1.6183E+00,1.7346E+00/
      DATA (KB(JT,54,12),JT=1,5) /
     &1.1132E+00,1.1981E+00,1.2847E+00,1.3880E+00,1.4926E+00/
      DATA (KB(JT,55,12),JT=1,5) /
     &9.3399E-01,1.0137E+00,1.0949E+00,1.1891E+00,1.2944E+00/
      DATA (KB(JT,56,12),JT=1,5) /
     &7.8822E-01,8.5806E-01,9.3275E-01,1.0165E+00,1.1194E+00/
      DATA (KB(JT,57,12),JT=1,5) /
     &6.5846E-01,7.2237E-01,7.9487E-01,8.7625E-01,9.6708E-01/
      DATA (KB(JT,58,12),JT=1,5) /
     &5.5082E-01,6.0932E-01,6.7677E-01,7.5228E-01,8.3907E-01/
      DATA (KB(JT,59,12),JT=1,5) /
     &4.7097E-01,5.2693E-01,5.8955E-01,6.6574E-01,7.5245E-01/
      DATA (KB(JT,13,13),JT=1,5) /
     &1.1006E+03,1.0930E+03,1.0868E+03,1.0845E+03,1.0783E+03/
      DATA (KB(JT,14,13),JT=1,5) /
     &1.0959E+03,1.0919E+03,1.0910E+03,1.0859E+03,1.0743E+03/
      DATA (KB(JT,15,13),JT=1,5) /
     &1.0739E+03,1.0736E+03,1.0715E+03,1.0637E+03,1.0554E+03/
      DATA (KB(JT,16,13),JT=1,5) /
     &1.0348E+03,1.0368E+03,1.0336E+03,1.0297E+03,1.0251E+03/
      DATA (KB(JT,17,13),JT=1,5) /
     &9.8104E+02,9.8318E+02,9.8416E+02,9.8388E+02,9.8177E+02/
      DATA (KB(JT,18,13),JT=1,5) /
     &9.1939E+02,9.2259E+02,9.2492E+02,9.2597E+02,9.2235E+02/
      DATA (KB(JT,19,13),JT=1,5) /
     &8.5744E+02,8.6138E+02,8.6320E+02,8.6092E+02,8.5380E+02/
      DATA (KB(JT,20,13),JT=1,5) /
     &7.9222E+02,7.9480E+02,7.9309E+02,7.8688E+02,7.7879E+02/
      DATA (KB(JT,21,13),JT=1,5) /
     &7.2352E+02,7.2196E+02,7.1706E+02,7.1061E+02,7.0329E+02/
      DATA (KB(JT,22,13),JT=1,5) /
     &6.4947E+02,6.4590E+02,6.4130E+02,6.3579E+02,6.2875E+02/
      DATA (KB(JT,23,13),JT=1,5) /
     &5.7230E+02,5.6958E+02,5.6554E+02,5.6079E+02,5.5572E+02/
      DATA (KB(JT,24,13),JT=1,5) /
     &4.9907E+02,4.9687E+02,4.9379E+02,4.8982E+02,4.8472E+02/
      DATA (KB(JT,25,13),JT=1,5) /
     &4.3090E+02,4.2914E+02,4.2610E+02,4.2208E+02,4.1721E+02/
      DATA (KB(JT,26,13),JT=1,5) /
     &3.6834E+02,3.6617E+02,3.6313E+02,3.5932E+02,3.5509E+02/
      DATA (KB(JT,27,13),JT=1,5) /
     &3.0815E+02,3.0692E+02,3.0435E+02,3.0103E+02,2.9773E+02/
      DATA (KB(JT,28,13),JT=1,5) /
     &2.5402E+02,2.5274E+02,2.5083E+02,2.4862E+02,2.4624E+02/
      DATA (KB(JT,29,13),JT=1,5) /
     &2.0985E+02,2.0878E+02,2.0729E+02,2.0573E+02,2.0375E+02/
      DATA (KB(JT,30,13),JT=1,5) /
     &1.7400E+02,1.7284E+02,1.7160E+02,1.7041E+02,1.6891E+02/
      DATA (KB(JT,31,13),JT=1,5) /
     &1.4590E+02,1.4515E+02,1.4409E+02,1.4281E+02,1.4174E+02/
      DATA (KB(JT,32,13),JT=1,5) /
     &1.2352E+02,1.2281E+02,1.2185E+02,1.2095E+02,1.2000E+02/
      DATA (KB(JT,33,13),JT=1,5) /
     &1.0504E+02,1.0445E+02,1.0374E+02,1.0318E+02,1.0254E+02/
      DATA (KB(JT,34,13),JT=1,5) /
     &8.9914E+01,8.9264E+01,8.8774E+01,8.8232E+01,8.7968E+01/
      DATA (KB(JT,35,13),JT=1,5) /
     &7.7137E+01,7.6673E+01,7.6351E+01,7.5989E+01,7.5812E+01/
      DATA (KB(JT,36,13),JT=1,5) /
     &6.6630E+01,6.6370E+01,6.6000E+01,6.5870E+01,6.5834E+01/
      DATA (KB(JT,37,13),JT=1,5) /
     &5.7835E+01,5.7711E+01,5.7500E+01,5.7478E+01,5.7625E+01/
      DATA (KB(JT,38,13),JT=1,5) /
     &5.0326E+01,5.0239E+01,5.0196E+01,5.0287E+01,5.0433E+01/
      DATA (KB(JT,39,13),JT=1,5) /
     &4.3783E+01,4.3749E+01,4.3859E+01,4.3984E+01,4.4262E+01/
      DATA (KB(JT,40,13),JT=1,5) /
     &3.8311E+01,3.8366E+01,3.8494E+01,3.8770E+01,3.9082E+01/
      DATA (KB(JT,41,13),JT=1,5) /
     &3.3505E+01,3.3696E+01,3.3809E+01,3.4139E+01,3.4534E+01/
      DATA (KB(JT,42,13),JT=1,5) /
     &2.9251E+01,2.9507E+01,2.9744E+01,3.0106E+01,3.0543E+01/
      DATA (KB(JT,43,13),JT=1,5) /
     &2.5517E+01,2.5852E+01,2.6152E+01,2.6566E+01,2.7067E+01/
      DATA (KB(JT,44,13),JT=1,5) /
     &2.2216E+01,2.2648E+01,2.3006E+01,2.3424E+01,2.3903E+01/
      DATA (KB(JT,45,13),JT=1,5) /
     &1.9313E+01,1.9753E+01,2.0163E+01,2.0601E+01,2.1122E+01/
      DATA (KB(JT,46,13),JT=1,5) /
     &1.6765E+01,1.7207E+01,1.7660E+01,1.8173E+01,1.8710E+01/
      DATA (KB(JT,47,13),JT=1,5) /
     &1.4512E+01,1.4984E+01,1.5402E+01,1.5957E+01,1.6479E+01/
      DATA (KB(JT,48,13),JT=1,5) /
     &1.2486E+01,1.2967E+01,1.3459E+01,1.3983E+01,1.4524E+01/
      DATA (KB(JT,49,13),JT=1,5) /
     &1.0733E+01,1.1206E+01,1.1665E+01,1.2207E+01,1.2773E+01/
      DATA (KB(JT,50,13),JT=1,5) /
     &9.2157E+00,9.6749E+00,1.0151E+01,1.0704E+01,1.1247E+01/
      DATA (KB(JT,51,13),JT=1,5) /
     &7.9591E+00,8.3907E+00,8.8535E+00,9.3811E+00,9.9247E+00/
      DATA (KB(JT,52,13),JT=1,5) /
     &6.8068E+00,7.2371E+00,7.6934E+00,8.2063E+00,8.7553E+00/
      DATA (KB(JT,53,13),JT=1,5) /
     &5.7967E+00,6.2085E+00,6.6421E+00,7.1263E+00,7.6815E+00/
      DATA (KB(JT,54,13),JT=1,5) /
     &4.9653E+00,5.3639E+00,5.8069E+00,6.2889E+00,6.8002E+00/
      DATA (KB(JT,55,13),JT=1,5) /
     &4.2889E+00,4.6915E+00,5.1242E+00,5.6024E+00,6.0981E+00/
      DATA (KB(JT,56,13),JT=1,5) /
     &3.6900E+00,4.0833E+00,4.5086E+00,4.9809E+00,5.4831E+00/
      DATA (KB(JT,57,13),JT=1,5) /
     &3.1898E+00,3.5703E+00,3.9801E+00,4.4470E+00,4.9431E+00/
      DATA (KB(JT,58,13),JT=1,5) /
     &2.7316E+00,3.0989E+00,3.5187E+00,3.9710E+00,4.4675E+00/
      DATA (KB(JT,59,13),JT=1,5) /
     &2.4661E+00,2.8142E+00,3.2518E+00,3.7206E+00,4.2604E+00/
      DATA (KB(JT,13,14),JT=1,5) /
     &2.3516E+03,2.3425E+03,2.3393E+03,2.3344E+03,2.3274E+03/
      DATA (KB(JT,14,14),JT=1,5) /
     &2.4560E+03,2.4460E+03,2.4416E+03,2.4361E+03,2.4328E+03/
      DATA (KB(JT,15,14),JT=1,5) /
     &2.5504E+03,2.5434E+03,2.5388E+03,2.5327E+03,2.5248E+03/
      DATA (KB(JT,16,14),JT=1,5) /
     &2.6346E+03,2.6312E+03,2.6203E+03,2.6088E+03,2.5971E+03/
      DATA (KB(JT,17,14),JT=1,5) /
     &2.7008E+03,2.6935E+03,2.6794E+03,2.6636E+03,2.6477E+03/
      DATA (KB(JT,18,14),JT=1,5) /
     &2.7305E+03,2.7239E+03,2.7111E+03,2.6981E+03,2.6813E+03/
      DATA (KB(JT,19,14),JT=1,5) /
     &2.7180E+03,2.7110E+03,2.7049E+03,2.6968E+03,2.6814E+03/
      DATA (KB(JT,20,14),JT=1,5) /
     &2.6672E+03,2.6665E+03,2.6675E+03,2.6606E+03,2.6429E+03/
      DATA (KB(JT,21,14),JT=1,5) /
     &2.5815E+03,2.5893E+03,2.5905E+03,2.5819E+03,2.5661E+03/
      DATA (KB(JT,22,14),JT=1,5) /
     &2.4673E+03,2.4773E+03,2.4773E+03,2.4699E+03,2.4562E+03/
      DATA (KB(JT,23,14),JT=1,5) /
     &2.3326E+03,2.3404E+03,2.3409E+03,2.3341E+03,2.3220E+03/
      DATA (KB(JT,24,14),JT=1,5) /
     &2.1770E+03,2.1831E+03,2.1839E+03,2.1779E+03,2.1650E+03/
      DATA (KB(JT,25,14),JT=1,5) /
     &2.0113E+03,2.0166E+03,2.0154E+03,2.0063E+03,1.9910E+03/
      DATA (KB(JT,26,14),JT=1,5) /
     &1.8365E+03,1.8415E+03,1.8363E+03,1.8253E+03,1.8117E+03/
      DATA (KB(JT,27,14),JT=1,5) /
     &1.6595E+03,1.6581E+03,1.6515E+03,1.6428E+03,1.6322E+03/
      DATA (KB(JT,28,14),JT=1,5) /
     &1.4809E+03,1.4771E+03,1.4724E+03,1.4658E+03,1.4569E+03/
      DATA (KB(JT,29,14),JT=1,5) /
     &1.3089E+03,1.3068E+03,1.3044E+03,1.2991E+03,1.2930E+03/
      DATA (KB(JT,30,14),JT=1,5) /
     &1.1460E+03,1.1478E+03,1.1472E+03,1.1450E+03,1.1415E+03/
      DATA (KB(JT,31,14),JT=1,5) /
     &9.9693E+02,1.0002E+03,1.0008E+03,1.0017E+03,1.0008E+03/
      DATA (KB(JT,32,14),JT=1,5) /
     &8.6070E+02,8.6544E+02,8.6833E+02,8.7044E+02,8.7331E+02/
      DATA (KB(JT,33,14),JT=1,5) /
     &7.4260E+02,7.4642E+02,7.5058E+02,7.5528E+02,7.5991E+02/
      DATA (KB(JT,34,14),JT=1,5) /
     &6.3829E+02,6.4348E+02,6.4940E+02,6.5551E+02,6.6078E+02/
      DATA (KB(JT,35,14),JT=1,5) /
     &5.4846E+02,5.5540E+02,5.6285E+02,5.6932E+02,5.7603E+02/
      DATA (KB(JT,36,14),JT=1,5) /
     &4.7198E+02,4.7993E+02,4.8784E+02,4.9478E+02,5.0307E+02/
      DATA (KB(JT,37,14),JT=1,5) /
     &4.0498E+02,4.1318E+02,4.2147E+02,4.2948E+02,4.3820E+02/
      DATA (KB(JT,38,14),JT=1,5) /
     &3.4831E+02,3.5680E+02,3.6471E+02,3.7305E+02,3.8282E+02/
      DATA (KB(JT,39,14),JT=1,5) /
     &3.0154E+02,3.0929E+02,3.1734E+02,3.2632E+02,3.3596E+02/
      DATA (KB(JT,40,14),JT=1,5) /
     &2.6084E+02,2.6836E+02,2.7578E+02,2.8455E+02,2.9457E+02/
      DATA (KB(JT,41,14),JT=1,5) /
     &2.2737E+02,2.3379E+02,2.4131E+02,2.4917E+02,2.5928E+02/
      DATA (KB(JT,42,14),JT=1,5) /
     &1.9807E+02,2.0493E+02,2.1238E+02,2.2005E+02,2.2904E+02/
      DATA (KB(JT,43,14),JT=1,5) /
     &1.7261E+02,1.7936E+02,1.8667E+02,1.9473E+02,2.0355E+02/
      DATA (KB(JT,44,14),JT=1,5) /
     &1.5104E+02,1.5759E+02,1.6444E+02,1.7229E+02,1.8143E+02/
      DATA (KB(JT,45,14),JT=1,5) /
     &1.3320E+02,1.3908E+02,1.4536E+02,1.5288E+02,1.6210E+02/
      DATA (KB(JT,46,14),JT=1,5) /
     &1.1788E+02,1.2339E+02,1.2957E+02,1.3630E+02,1.4477E+02/
      DATA (KB(JT,47,14),JT=1,5) /
     &1.0441E+02,1.0994E+02,1.1542E+02,1.2186E+02,1.2998E+02/
      DATA (KB(JT,48,14),JT=1,5) /
     &9.2989E+01,9.8393E+01,1.0367E+02,1.0970E+02,1.1684E+02/
      DATA (KB(JT,49,14),JT=1,5) /
     &8.3245E+01,8.8109E+01,9.3736E+01,9.8882E+01,1.0570E+02/
      DATA (KB(JT,50,14),JT=1,5) /
     &7.4420E+01,7.9603E+01,8.4592E+01,9.0187E+01,9.6226E+01/
      DATA (KB(JT,51,14),JT=1,5) /
     &6.6553E+01,7.2000E+01,7.7144E+01,8.2193E+01,8.8503E+01/
      DATA (KB(JT,52,14),JT=1,5) /
     &5.9519E+01,6.4793E+01,7.0321E+01,7.5806E+01,8.1580E+01/
      DATA (KB(JT,53,14),JT=1,5) /
     &5.3233E+01,5.8402E+01,6.4217E+01,6.9900E+01,7.5580E+01/
      DATA (KB(JT,54,14),JT=1,5) /
     &4.7589E+01,5.2923E+01,5.8451E+01,6.4196E+01,7.0322E+01/
      DATA (KB(JT,55,14),JT=1,5) /
     &4.2742E+01,4.7820E+01,5.3445E+01,5.9447E+01,6.5405E+01/
      DATA (KB(JT,56,14),JT=1,5) /
     &3.8175E+01,4.3483E+01,4.9069E+01,5.5046E+01,6.1266E+01/
      DATA (KB(JT,57,14),JT=1,5) /
     &3.4510E+01,3.9326E+01,4.4806E+01,5.1166E+01,5.7169E+01/
      DATA (KB(JT,58,14),JT=1,5) /
     &3.1419E+01,3.6120E+01,4.1281E+01,4.7436E+01,5.4030E+01/
      DATA (KB(JT,59,14),JT=1,5) /
     &3.0087E+01,3.4624E+01,3.9514E+01,4.5129E+01,5.1873E+01/
      DATA (KB(JT,13,15),JT=1,5) /
     &5.1911E+03,5.1717E+03,5.1553E+03,5.1395E+03,5.1397E+03/
      DATA (KB(JT,14,15),JT=1,5) /
     &5.8547E+03,5.8285E+03,5.7963E+03,5.7766E+03,5.7715E+03/
      DATA (KB(JT,15,15),JT=1,5) /
     &6.5298E+03,6.4858E+03,6.4506E+03,6.4312E+03,6.4243E+03/
      DATA (KB(JT,16,15),JT=1,5) /
     &7.2117E+03,7.1510E+03,7.1189E+03,7.1000E+03,7.0870E+03/
      DATA (KB(JT,17,15),JT=1,5) /
     &7.8953E+03,7.8291E+03,7.7890E+03,7.7670E+03,7.7489E+03/
      DATA (KB(JT,18,15),JT=1,5) /
     &8.5855E+03,8.5208E+03,8.4668E+03,8.4206E+03,8.3980E+03/
      DATA (KB(JT,19,15),JT=1,5) /
     &9.2674E+03,9.2049E+03,9.1326E+03,9.0736E+03,9.0525E+03/
      DATA (KB(JT,20,15),JT=1,5) /
     &9.9108E+03,9.8356E+03,9.7636E+03,9.7141E+03,9.6905E+03/
      DATA (KB(JT,21,15),JT=1,5) /
     &1.0486E+04,1.0415E+04,1.0355E+04,1.0317E+04,1.0287E+04/
      DATA (KB(JT,22,15),JT=1,5) /
     &1.0985E+04,1.0920E+04,1.0875E+04,1.0845E+04,1.0804E+04/
      DATA (KB(JT,23,15),JT=1,5) /
     &1.1398E+04,1.1342E+04,1.1308E+04,1.1276E+04,1.1234E+04/
      DATA (KB(JT,24,15),JT=1,5) /
     &1.1709E+04,1.1672E+04,1.1645E+04,1.1614E+04,1.1576E+04/
      DATA (KB(JT,25,15),JT=1,5) /
     &1.1914E+04,1.1896E+04,1.1878E+04,1.1862E+04,1.1837E+04/
      DATA (KB(JT,26,15),JT=1,5) /
     &1.2040E+04,1.2031E+04,1.2029E+04,1.2020E+04,1.1998E+04/
      DATA (KB(JT,27,15),JT=1,5) /
     &1.2071E+04,1.2081E+04,1.2089E+04,1.2085E+04,1.2069E+04/
      DATA (KB(JT,28,15),JT=1,5) /
     &1.2021E+04,1.2058E+04,1.2068E+04,1.2068E+04,1.2073E+04/
      DATA (KB(JT,29,15),JT=1,5) /
     &1.1886E+04,1.1940E+04,1.1970E+04,1.1995E+04,1.2017E+04/
      DATA (KB(JT,30,15),JT=1,5) /
     &1.1676E+04,1.1749E+04,1.1808E+04,1.1861E+04,1.1908E+04/
      DATA (KB(JT,31,15),JT=1,5) /
     &1.1416E+04,1.1515E+04,1.1609E+04,1.1694E+04,1.1764E+04/
      DATA (KB(JT,32,15),JT=1,5) /
     &1.1108E+04,1.1250E+04,1.1385E+04,1.1503E+04,1.1598E+04/
      DATA (KB(JT,33,15),JT=1,5) /
     &1.0773E+04,1.0963E+04,1.1141E+04,1.1294E+04,1.1425E+04/
      DATA (KB(JT,34,15),JT=1,5) /
     &1.0438E+04,1.0673E+04,1.0885E+04,1.1077E+04,1.1249E+04/
      DATA (KB(JT,35,15),JT=1,5) /
     &1.0089E+04,1.0368E+04,1.0621E+04,1.0852E+04,1.1064E+04/
      DATA (KB(JT,36,15),JT=1,5) /
     &9.7201E+03,1.0041E+04,1.0341E+04,1.0614E+04,1.0861E+04/
      DATA (KB(JT,37,15),JT=1,5) /
     &9.3163E+03,9.6805E+03,1.0024E+04,1.0342E+04,1.0632E+04/
      DATA (KB(JT,38,15),JT=1,5) /
     &8.9272E+03,9.3307E+03,9.7169E+03,1.0074E+04,1.0402E+04/
      DATA (KB(JT,39,15),JT=1,5) /
     &8.5526E+03,8.9993E+03,9.4206E+03,9.8154E+03,1.0180E+04/
      DATA (KB(JT,40,15),JT=1,5) /
     &8.1494E+03,8.6355E+03,9.0962E+03,9.5285E+03,9.9305E+03/
      DATA (KB(JT,41,15),JT=1,5) /
     &7.7529E+03,8.2788E+03,8.7766E+03,9.2446E+03,9.6773E+03/
      DATA (KB(JT,42,15),JT=1,5) /
     &7.3760E+03,7.9339E+03,8.4681E+03,8.9681E+03,9.4340E+03/
      DATA (KB(JT,43,15),JT=1,5) /
     &6.9819E+03,7.5721E+03,8.1409E+03,8.6746E+03,9.1691E+03/
      DATA (KB(JT,44,15),JT=1,5) /
     &6.5827E+03,7.2081E+03,7.8084E+03,8.3740E+03,8.8982E+03/
      DATA (KB(JT,45,15),JT=1,5) /
     &6.1901E+03,6.8485E+03,7.4795E+03,8.0786E+03,8.6303E+03/
      DATA (KB(JT,46,15),JT=1,5) /
     &5.8024E+03,6.4801E+03,7.1413E+03,7.7702E+03,8.3548E+03/
      DATA (KB(JT,47,15),JT=1,5) /
     &5.3938E+03,6.0870E+03,6.7778E+03,7.4341E+03,8.0495E+03/
      DATA (KB(JT,48,15),JT=1,5) /
     &5.0092E+03,5.7052E+03,6.4111E+03,7.0962E+03,7.7409E+03/
      DATA (KB(JT,49,15),JT=1,5) /
     &4.6045E+03,5.3446E+03,6.0469E+03,6.7562E+03,7.4302E+03/
      DATA (KB(JT,50,15),JT=1,5) /
     &4.2414E+03,4.9940E+03,5.7177E+03,6.4318E+03,7.1308E+03/
      DATA (KB(JT,51,15),JT=1,5) /
     &3.9058E+03,4.6435E+03,5.4144E+03,6.1320E+03,6.8340E+03/
      DATA (KB(JT,52,15),JT=1,5) /
     &3.5828E+03,4.3242E+03,5.0835E+03,5.8308E+03,6.5455E+03/
      DATA (KB(JT,53,15),JT=1,5) /
     &3.2733E+03,3.9950E+03,4.7590E+03,5.5300E+03,6.2613E+03/
      DATA (KB(JT,54,15),JT=1,5) /
     &2.9973E+03,3.7033E+03,4.4798E+03,5.2468E+03,6.0054E+03/
      DATA (KB(JT,55,15),JT=1,5) /
     &2.7347E+03,3.4529E+03,4.2020E+03,4.9932E+03,5.7360E+03/
      DATA (KB(JT,56,15),JT=1,5) /
     &2.4953E+03,3.1956E+03,3.9366E+03,4.7176E+03,5.4818E+03/
      DATA (KB(JT,57,15),JT=1,5) /
     &2.2617E+03,2.9413E+03,3.6881E+03,4.4499E+03,5.2349E+03/
      DATA (KB(JT,58,15),JT=1,5) /
     &2.0370E+03,2.7148E+03,3.4460E+03,4.2224E+03,4.9906E+03/
      DATA (KB(JT,59,15),JT=1,5) /
     &1.9478E+03,2.6130E+03,3.3529E+03,4.1205E+03,4.8990E+03/
      DATA (KB(JT,13,16),JT=1,5) /
     &1.0699E+04,1.0668E+04,1.0580E+04,1.0493E+04,1.0473E+04/
      DATA (KB(JT,14,16),JT=1,5) /
     &1.2469E+04,1.2443E+04,1.2338E+04,1.2279E+04,1.2260E+04/
      DATA (KB(JT,15,16),JT=1,5) /
     &1.4513E+04,1.4466E+04,1.4361E+04,1.4360E+04,1.4376E+04/
      DATA (KB(JT,16,16),JT=1,5) /
     &1.6769E+04,1.6706E+04,1.6727E+04,1.6775E+04,1.6795E+04/
      DATA (KB(JT,17,16),JT=1,5) /
     &1.9233E+04,1.9285E+04,1.9387E+04,1.9445E+04,1.9443E+04/
      DATA (KB(JT,18,16),JT=1,5) /
     &2.2082E+04,2.2141E+04,2.2296E+04,2.2362E+04,2.2373E+04/
      DATA (KB(JT,19,16),JT=1,5) /
     &2.5392E+04,2.5419E+04,2.5533E+04,2.5623E+04,2.5622E+04/
      DATA (KB(JT,20,16),JT=1,5) /
     &2.9227E+04,2.9228E+04,2.9232E+04,2.9272E+04,2.9286E+04/
      DATA (KB(JT,21,16),JT=1,5) /
     &3.3689E+04,3.3556E+04,3.3511E+04,3.3436E+04,3.3399E+04/
      DATA (KB(JT,22,16),JT=1,5) /
     &3.8640E+04,3.8494E+04,3.8304E+04,3.8118E+04,3.8006E+04/
      DATA (KB(JT,23,16),JT=1,5) /
     &4.4135E+04,4.3894E+04,4.3600E+04,4.3191E+04,4.3063E+04/
      DATA (KB(JT,24,16),JT=1,5) /
     &5.0120E+04,4.9723E+04,4.9276E+04,4.8847E+04,4.8550E+04/
      DATA (KB(JT,25,16),JT=1,5) /
     &5.6400E+04,5.5824E+04,5.5260E+04,5.4753E+04,5.4318E+04/
      DATA (KB(JT,26,16),JT=1,5) /
     &6.2742E+04,6.2101E+04,6.1449E+04,6.0838E+04,6.0246E+04/
      DATA (KB(JT,27,16),JT=1,5) /
     &6.9256E+04,6.8498E+04,6.7755E+04,6.7035E+04,6.6255E+04/
      DATA (KB(JT,28,16),JT=1,5) /
     &7.5845E+04,7.4890E+04,7.4038E+04,7.3125E+04,7.2119E+04/
      DATA (KB(JT,29,16),JT=1,5) /
     &8.2416E+04,8.1292E+04,8.0172E+04,7.8988E+04,7.7733E+04/
      DATA (KB(JT,30,16),JT=1,5) /
     &8.8923E+04,8.7524E+04,8.6114E+04,8.4633E+04,8.3083E+04/
      DATA (KB(JT,31,16),JT=1,5) /
     &9.5128E+04,9.3474E+04,9.1409E+04,8.9609E+04,8.8121E+04/
      DATA (KB(JT,32,16),JT=1,5) /
     &1.0109E+05,9.9056E+04,9.6959E+04,9.4838E+04,9.2728E+04/
      DATA (KB(JT,33,16),JT=1,5) /
     &1.0668E+05,1.0426E+05,1.0177E+05,9.9309E+04,9.6864E+04/
      DATA (KB(JT,34,16),JT=1,5) /
     &1.1181E+05,1.0901E+05,1.0619E+05,1.0339E+05,1.0062E+05/
      DATA (KB(JT,35,16),JT=1,5) /
     &1.1669E+05,1.1352E+05,1.1036E+05,1.0724E+05,1.0414E+05/
      DATA (KB(JT,36,16),JT=1,5) /
     &1.2143E+05,1.1741E+05,1.1444E+05,1.1099E+05,1.0759E+05/
      DATA (KB(JT,37,16),JT=1,5) /
     &1.2629E+05,1.2248E+05,1.1868E+05,1.1492E+05,1.1120E+05/
      DATA (KB(JT,38,16),JT=1,5) /
     &1.3077E+05,1.2669E+05,1.2260E+05,1.1857E+05,1.1458E+05/
      DATA (KB(JT,39,16),JT=1,5) /
     &1.3413E+05,1.3013E+05,1.2620E+05,1.2191E+05,1.1768E+05/
      DATA (KB(JT,40,16),JT=1,5) /
     &1.3905E+05,1.3448E+05,1.2993E+05,1.2540E+05,1.2095E+05/
      DATA (KB(JT,41,16),JT=1,5) /
     &1.4302E+05,1.3822E+05,1.3346E+05,1.2873E+05,1.2407E+05/
      DATA (KB(JT,42,16),JT=1,5) /
     &1.4675E+05,1.4173E+05,1.3673E+05,1.3182E+05,1.2698E+05/
      DATA (KB(JT,43,16),JT=1,5) /
     &1.5047E+05,1.4528E+05,1.4010E+05,1.3500E+05,1.2941E+05/
      DATA (KB(JT,44,16),JT=1,5) /
     &1.5413E+05,1.4878E+05,1.4344E+05,1.3816E+05,1.3300E+05/
      DATA (KB(JT,45,16),JT=1,5) /
     &1.5764E+05,1.5214E+05,1.4665E+05,1.4055E+05,1.3586E+05/
      DATA (KB(JT,46,16),JT=1,5) /
     &1.6104E+05,1.5546E+05,1.4981E+05,1.4422E+05,1.3874E+05/
      DATA (KB(JT,47,16),JT=1,5) /
     &1.6453E+05,1.5891E+05,1.5314E+05,1.4742E+05,1.4180E+05/
      DATA (KB(JT,48,16),JT=1,5) /
     &1.6775E+05,1.6219E+05,1.5640E+05,1.5054E+05,1.4481E+05/
      DATA (KB(JT,49,16),JT=1,5) /
     &1.7104E+05,1.6528E+05,1.5957E+05,1.5363E+05,1.4773E+05/
      DATA (KB(JT,50,16),JT=1,5) /
     &1.7401E+05,1.6818E+05,1.6240E+05,1.5648E+05,1.5051E+05/
      DATA (KB(JT,51,16),JT=1,5) /
     &1.7667E+05,1.7104E+05,1.6499E+05,1.5912E+05,1.5318E+05/
      DATA (KB(JT,52,16),JT=1,5) /
     &1.7922E+05,1.7356E+05,1.6772E+05,1.6169E+05,1.5572E+05/
      DATA (KB(JT,53,16),JT=1,5) /
     &1.8153E+05,1.7622E+05,1.7035E+05,1.6422E+05,1.5819E+05/
      DATA (KB(JT,54,16),JT=1,5) /
     &1.8363E+05,1.7848E+05,1.7259E+05,1.6657E+05,1.6042E+05/
      DATA (KB(JT,55,16),JT=1,5) /
     &1.8551E+05,1.8043E+05,1.7479E+05,1.6867E+05,1.6267E+05/
      DATA (KB(JT,56,16),JT=1,5) /
     &1.8723E+05,1.8233E+05,1.7687E+05,1.7089E+05,1.6480E+05/
      DATA (KB(JT,57,16),JT=1,5) /
     &1.8886E+05,1.8420E+05,1.7883E+05,1.7299E+05,1.6681E+05/
      DATA (KB(JT,58,16),JT=1,5) /
     &1.9037E+05,1.8581E+05,1.8067E+05,1.7477E+05,1.6881E+05/
      DATA (KB(JT,59,16),JT=1,5) /
     &1.9100E+05,1.8659E+05,1.8132E+05,1.7562E+05,1.6956E+05/

       DATA (KA_MN2(JT, 1),JT=1,19)  /
     & 5.12042e-08, 5.51239e-08, 5.93436e-08, 6.38863e-08, 6.87767e-08,
     & 7.40415e-08, 7.97093e-08, 8.58110e-08, 9.23797e-08, 9.94513e-08,
     & 1.07064e-07, 1.15260e-07, 1.24083e-07, 1.33581e-07, 1.43807e-07,
     & 1.54815e-07, 1.66666e-07, 1.79424e-07, 1.93159e-07/
       DATA (KA_MN2(JT, 2),JT=1,19)  /
     & 2.30938e-07, 2.41696e-07, 2.52955e-07, 2.64738e-07, 2.77071e-07,
     & 2.89978e-07, 3.03486e-07, 3.17623e-07, 3.32419e-07, 3.47904e-07,
     & 3.64111e-07, 3.81072e-07, 3.98824e-07, 4.17402e-07, 4.36846e-07,
     & 4.57196e-07, 4.78494e-07, 5.00784e-07, 5.24112e-07/
       DATA (KA_MN2(JT, 3),JT=1,19)  /
     & 6.70458e-07, 7.04274e-07, 7.39795e-07, 7.77109e-07, 8.16304e-07,
     & 8.57476e-07, 9.00724e-07, 9.46154e-07, 9.93876e-07, 1.04400e-06,
     & 1.09666e-06, 1.15197e-06, 1.21008e-06, 1.27111e-06, 1.33522e-06,
     & 1.40256e-06, 1.47331e-06, 1.54761e-06, 1.62567e-06/
       DATA (KA_MN2(JT, 4),JT=1,19)  /
     & 1.84182e-06, 1.89203e-06, 1.94360e-06, 1.99658e-06, 2.05101e-06,
     & 2.10692e-06, 2.16435e-06, 2.22335e-06, 2.28396e-06, 2.34622e-06,
     & 2.41017e-06, 2.47587e-06, 2.54337e-06, 2.61270e-06, 2.68392e-06,
     & 2.75708e-06, 2.83224e-06, 2.90944e-06, 2.98875e-06/
       DATA (KA_MN2(JT, 5),JT=1,19)  /
     & 3.41996e-06, 3.32758e-06, 3.23770e-06, 3.15024e-06, 3.06515e-06,
     & 2.98235e-06, 2.90180e-06, 2.82341e-06, 2.74715e-06, 2.67294e-06,
     & 2.60074e-06, 2.53049e-06, 2.46214e-06, 2.39563e-06, 2.33092e-06,
     & 2.26796e-06, 2.20670e-06, 2.14709e-06, 2.08910e-06/
       DATA (KA_MN2(JT, 6),JT=1,19)  /
     & 3.38746e-06, 3.25966e-06, 3.13669e-06, 3.01836e-06, 2.90449e-06,
     & 2.79491e-06, 2.68947e-06, 2.58801e-06, 2.49037e-06, 2.39642e-06,
     & 2.30601e-06, 2.21902e-06, 2.13530e-06, 2.05475e-06, 1.97723e-06,
     & 1.90264e-06, 1.83086e-06, 1.76179e-06, 1.69532e-06/
       DATA (KA_MN2(JT, 7),JT=1,19)  /
     & 3.17530e-06, 3.07196e-06, 2.97199e-06, 2.87527e-06, 2.78170e-06,
     & 2.69118e-06, 2.60360e-06, 2.51887e-06, 2.43690e-06, 2.35759e-06,
     & 2.28087e-06, 2.20664e-06, 2.13483e-06, 2.06536e-06, 1.99814e-06,
     & 1.93312e-06, 1.87021e-06, 1.80934e-06, 1.75046e-06/
       DATA (KA_MN2(JT, 8),JT=1,19)  /
     & 2.84701e-06, 2.77007e-06, 2.69521e-06, 2.62237e-06, 2.55150e-06,
     & 2.48254e-06, 2.41545e-06, 2.35017e-06, 2.28666e-06, 2.22486e-06,
     & 2.16473e-06, 2.10623e-06, 2.04930e-06, 1.99392e-06, 1.94003e-06,
     & 1.88760e-06, 1.83659e-06, 1.78695e-06, 1.73866e-06/
       DATA (KA_MN2(JT, 9),JT=1,19)  /
     & 2.79917e-06, 2.73207e-06, 2.66658e-06, 2.60266e-06, 2.54027e-06,
     & 2.47937e-06, 2.41994e-06, 2.36192e-06, 2.30530e-06, 2.25004e-06,
     & 2.19610e-06, 2.14346e-06, 2.09208e-06, 2.04193e-06, 1.99298e-06,
     & 1.94520e-06, 1.89857e-06, 1.85306e-06, 1.80864e-06/
       DATA (KA_MN2(JT,10),JT=1,19)  /
     & 2.74910e-06, 2.64462e-06, 2.54412e-06, 2.44743e-06, 2.35442e-06,
     & 2.26495e-06, 2.17887e-06, 2.09606e-06, 2.01641e-06, 1.93978e-06,
     & 1.86606e-06, 1.79514e-06, 1.72692e-06, 1.66129e-06, 1.59815e-06,
     & 1.53742e-06, 1.47899e-06, 1.42278e-06, 1.36871e-06/
       DATA (KA_MN2(JT,11),JT=1,19)  /
     & 2.63952e-06, 2.60263e-06, 2.56626e-06, 2.53039e-06, 2.49503e-06,
     & 2.46016e-06, 2.42578e-06, 2.39188e-06, 2.35845e-06, 2.32549e-06,
     & 2.29299e-06, 2.26094e-06, 2.22934e-06, 2.19819e-06, 2.16747e-06,
     & 2.13717e-06, 2.10731e-06, 2.07786e-06, 2.04882e-06/
       DATA (KA_MN2(JT,12),JT=1,19)  /
     & 2.94106e-06, 2.82819e-06, 2.71966e-06, 2.61528e-06, 2.51492e-06,
     & 2.41841e-06, 2.32560e-06, 2.23635e-06, 2.15053e-06, 2.06800e-06,
     & 1.98863e-06, 1.91232e-06, 1.83893e-06, 1.76836e-06, 1.70049e-06,
     & 1.63524e-06, 1.57248e-06, 1.51214e-06, 1.45411e-06/
       DATA (KA_MN2(JT,13),JT=1,19)  /
     & 2.94607e-06, 2.87369e-06, 2.80309e-06, 2.73422e-06, 2.66705e-06,
     & 2.60152e-06, 2.53760e-06, 2.47526e-06, 2.41445e-06, 2.35513e-06,
     & 2.29726e-06, 2.24082e-06, 2.18577e-06, 2.13207e-06, 2.07969e-06,
     & 2.02859e-06, 1.97875e-06, 1.93014e-06, 1.88272e-06/
       DATA (KA_MN2(JT,14),JT=1,19)  /
     & 2.58051e-06, 2.48749e-06, 2.39782e-06, 2.31139e-06, 2.22807e-06,
     & 2.14775e-06, 2.07033e-06, 1.99570e-06, 1.92376e-06, 1.85441e-06,
     & 1.78756e-06, 1.72313e-06, 1.66101e-06, 1.60114e-06, 1.54342e-06,
     & 1.48778e-06, 1.43415e-06, 1.38245e-06, 1.33262e-06/
       DATA (KA_MN2(JT,15),JT=1,19)  /
     & 3.03447e-06, 2.88559e-06, 2.74401e-06, 2.60938e-06, 2.48135e-06,
     & 2.35961e-06, 2.24384e-06, 2.13375e-06, 2.02906e-06, 1.92951e-06,
     & 1.83484e-06, 1.74481e-06, 1.65921e-06, 1.57780e-06, 1.50039e-06,
     & 1.42677e-06, 1.35677e-06, 1.29020e-06, 1.22690e-06/
       DATA (KA_MN2(JT,16),JT=1,19)  /
     & 1.48655e-06, 1.48283e-06, 1.47913e-06, 1.47543e-06, 1.47174e-06,
     & 1.46806e-06, 1.46439e-06, 1.46072e-06, 1.45707e-06, 1.45343e-06,
     & 1.44979e-06, 1.44617e-06, 1.44255e-06, 1.43894e-06, 1.43534e-06,
     & 1.43176e-06, 1.42817e-06, 1.42460e-06, 1.42104e-06/
       DATA (KB_MN2(JT, 1),JT=1,19)  /
     & 5.12042e-08, 5.51239e-08, 5.93436e-08, 6.38863e-08, 6.87767e-08,
     & 7.40415e-08, 7.97093e-08, 8.58110e-08, 9.23797e-08, 9.94513e-08,
     & 1.07064e-07, 1.15260e-07, 1.24083e-07, 1.33581e-07, 1.43807e-07,
     & 1.54815e-07, 1.66666e-07, 1.79424e-07, 1.93159e-07/
       DATA (KB_MN2(JT, 2),JT=1,19)  /
     & 2.30938e-07, 2.41696e-07, 2.52955e-07, 2.64738e-07, 2.77071e-07,
     & 2.89978e-07, 3.03486e-07, 3.17623e-07, 3.32419e-07, 3.47904e-07,
     & 3.64111e-07, 3.81072e-07, 3.98824e-07, 4.17402e-07, 4.36846e-07,
     & 4.57196e-07, 4.78494e-07, 5.00784e-07, 5.24112e-07/
       DATA (KB_MN2(JT, 3),JT=1,19)  /
     & 6.70458e-07, 7.04274e-07, 7.39795e-07, 7.77109e-07, 8.16304e-07,
     & 8.57476e-07, 9.00724e-07, 9.46154e-07, 9.93876e-07, 1.04400e-06,
     & 1.09666e-06, 1.15197e-06, 1.21008e-06, 1.27111e-06, 1.33522e-06,
     & 1.40256e-06, 1.47331e-06, 1.54761e-06, 1.62567e-06/
       DATA (KB_MN2(JT, 4),JT=1,19)  /
     & 1.84182e-06, 1.89203e-06, 1.94360e-06, 1.99658e-06, 2.05101e-06,
     & 2.10692e-06, 2.16435e-06, 2.22335e-06, 2.28396e-06, 2.34622e-06,
     & 2.41017e-06, 2.47587e-06, 2.54337e-06, 2.61270e-06, 2.68392e-06,
     & 2.75708e-06, 2.83224e-06, 2.90944e-06, 2.98875e-06/
       DATA (KB_MN2(JT, 5),JT=1,19)  /
     & 3.41996e-06, 3.32758e-06, 3.23770e-06, 3.15024e-06, 3.06515e-06,
     & 2.98235e-06, 2.90180e-06, 2.82341e-06, 2.74715e-06, 2.67294e-06,
     & 2.60074e-06, 2.53049e-06, 2.46214e-06, 2.39563e-06, 2.33092e-06,
     & 2.26796e-06, 2.20670e-06, 2.14709e-06, 2.08910e-06/
       DATA (KB_MN2(JT, 6),JT=1,19)  /
     & 3.38746e-06, 3.25966e-06, 3.13669e-06, 3.01836e-06, 2.90449e-06,
     & 2.79491e-06, 2.68947e-06, 2.58801e-06, 2.49037e-06, 2.39642e-06,
     & 2.30601e-06, 2.21902e-06, 2.13530e-06, 2.05475e-06, 1.97723e-06,
     & 1.90264e-06, 1.83086e-06, 1.76179e-06, 1.69532e-06/
       DATA (KB_MN2(JT, 7),JT=1,19)  /
     & 3.17530e-06, 3.07196e-06, 2.97199e-06, 2.87527e-06, 2.78170e-06,
     & 2.69118e-06, 2.60360e-06, 2.51887e-06, 2.43690e-06, 2.35759e-06,
     & 2.28087e-06, 2.20664e-06, 2.13483e-06, 2.06536e-06, 1.99814e-06,
     & 1.93312e-06, 1.87021e-06, 1.80934e-06, 1.75046e-06/
       DATA (KB_MN2(JT, 8),JT=1,19)  /
     & 2.84701e-06, 2.77007e-06, 2.69521e-06, 2.62237e-06, 2.55150e-06,
     & 2.48254e-06, 2.41545e-06, 2.35017e-06, 2.28666e-06, 2.22486e-06,
     & 2.16473e-06, 2.10623e-06, 2.04930e-06, 1.99392e-06, 1.94003e-06,
     & 1.88760e-06, 1.83659e-06, 1.78695e-06, 1.73866e-06/
       DATA (KB_MN2(JT, 9),JT=1,19)  /
     & 2.79917e-06, 2.73207e-06, 2.66658e-06, 2.60266e-06, 2.54027e-06,
     & 2.47937e-06, 2.41994e-06, 2.36192e-06, 2.30530e-06, 2.25004e-06,
     & 2.19610e-06, 2.14346e-06, 2.09208e-06, 2.04193e-06, 1.99298e-06,
     & 1.94520e-06, 1.89857e-06, 1.85306e-06, 1.80864e-06/
       DATA (KB_MN2(JT,10),JT=1,19)  /
     & 2.74910e-06, 2.64462e-06, 2.54412e-06, 2.44743e-06, 2.35442e-06,
     & 2.26495e-06, 2.17887e-06, 2.09606e-06, 2.01641e-06, 1.93978e-06,
     & 1.86606e-06, 1.79514e-06, 1.72692e-06, 1.66129e-06, 1.59815e-06,
     & 1.53742e-06, 1.47899e-06, 1.42278e-06, 1.36871e-06/
       DATA (KB_MN2(JT,11),JT=1,19)  /
     & 2.63952e-06, 2.60263e-06, 2.56626e-06, 2.53039e-06, 2.49503e-06,
     & 2.46016e-06, 2.42578e-06, 2.39188e-06, 2.35845e-06, 2.32549e-06,
     & 2.29299e-06, 2.26094e-06, 2.22934e-06, 2.19819e-06, 2.16747e-06,
     & 2.13717e-06, 2.10731e-06, 2.07786e-06, 2.04882e-06/
       DATA (KB_MN2(JT,12),JT=1,19)  /
     & 2.94106e-06, 2.82819e-06, 2.71966e-06, 2.61528e-06, 2.51492e-06,
     & 2.41841e-06, 2.32560e-06, 2.23635e-06, 2.15053e-06, 2.06800e-06,
     & 1.98863e-06, 1.91232e-06, 1.83893e-06, 1.76836e-06, 1.70049e-06,
     & 1.63524e-06, 1.57248e-06, 1.51214e-06, 1.45411e-06/
       DATA (KB_MN2(JT,13),JT=1,19)  /
     & 2.94607e-06, 2.87369e-06, 2.80309e-06, 2.73422e-06, 2.66705e-06,
     & 2.60152e-06, 2.53760e-06, 2.47526e-06, 2.41445e-06, 2.35513e-06,
     & 2.29726e-06, 2.24082e-06, 2.18577e-06, 2.13207e-06, 2.07969e-06,
     & 2.02859e-06, 1.97875e-06, 1.93014e-06, 1.88272e-06/
       DATA (KB_MN2(JT,14),JT=1,19)  /
     & 2.58051e-06, 2.48749e-06, 2.39782e-06, 2.31139e-06, 2.22807e-06,
     & 2.14775e-06, 2.07033e-06, 1.99570e-06, 1.92376e-06, 1.85441e-06,
     & 1.78756e-06, 1.72313e-06, 1.66101e-06, 1.60114e-06, 1.54342e-06,
     & 1.48778e-06, 1.43415e-06, 1.38245e-06, 1.33262e-06/
       DATA (KB_MN2(JT,15),JT=1,19)  /
     & 3.03447e-06, 2.88559e-06, 2.74401e-06, 2.60938e-06, 2.48135e-06,
     & 2.35961e-06, 2.24384e-06, 2.13375e-06, 2.02906e-06, 1.92951e-06,
     & 1.83484e-06, 1.74481e-06, 1.65921e-06, 1.57780e-06, 1.50039e-06,
     & 1.42677e-06, 1.35677e-06, 1.29020e-06, 1.22690e-06/
       DATA (KB_MN2(JT,16),JT=1,19)  /
     & 1.48655e-06, 1.48283e-06, 1.47913e-06, 1.47543e-06, 1.47174e-06,
     & 1.46806e-06, 1.46439e-06, 1.46072e-06, 1.45707e-06, 1.45343e-06,
     & 1.44979e-06, 1.44617e-06, 1.44255e-06, 1.43894e-06, 1.43534e-06,
     & 1.43176e-06, 1.42817e-06, 1.42460e-06, 1.42104e-06/

C     The array FORREF contains the coefficient of the water vapor
C     foreign-continuum (including the energy term).  The first 
C     index refers to reference temperature (296,260,224,260) and 
C     pressure (970,475,219,3 mbar) levels.  The second index 
C     runs over the g-channel (1 to 16).

      DATA (FORREF(1,IG),IG=1,16) /
     &3.6742e-02,1.0664e-01,2.6132e-01,2.7906e-01,2.8151e-01,2.7465e-01,
     &2.8530e-01,2.9123e-01,3.0697e-01,3.1801e-01,3.2444e-01,2.7746e-01,
     &3.1994e-01,2.9750e-01,2.1226e-01,1.2847e-01/
      DATA (FORREF(2,IG),IG=1,16) /
     &4.0450e-02,1.1085e-01,2.9205e-01,3.1934e-01,3.1739e-01,3.1450e-01,
     &3.2797e-01,3.2223e-01,3.3099e-01,3.4800e-01,3.4046e-01,3.5700e-01,
     &3.8264e-01,3.6679e-01,3.3481e-01,3.2113e-01/
      DATA (FORREF(3,IG),IG=1,16) /
     &4.6952e-02,1.1999e-01,3.1473e-01,3.7015e-01,3.6913e-01,3.6352e-01,
     &3.7754e-01,3.7402e-01,3.7113e-01,3.7720e-01,3.8365e-01,4.0876e-01,
     &4.2968e-01,4.4186e-01,4.3468e-01,4.7083e-01/
      DATA (FORREF(4,IG),IG=1,16) /
     &7.0645e-02,1.6618e-01,2.8516e-01,3.1819e-01,3.0131e-01,2.9552e-01,
     &2.8972e-01,2.9348e-01,2.8668e-01,2.8483e-01,2.8130e-01,2.7757e-01,
     &2.9735e-01,3.1684e-01,3.0681e-01,3.6778e-01/

C     The array SELFREF contains the coefficient of the water vapor
C     self-continuum (including the energy term).  The first index
C     refers to temperature in 7.2 degree increments.  For instance,
C     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
C     etc.  The second index runs over the g-channel (1 to 16).

      DATA (SELFREF(JT, 1),JT=1,10)  /
     & 2.16803e+00, 1.98236e+00, 1.81260e+00, 1.65737e+00, 1.51544e+00,
     & 1.38567e+00, 1.26700e+00, 1.15850e+00, 1.05929e+00, 9.68576e-01/
      DATA (SELFREF(JT, 2),JT=1,10)  /
     & 3.70149e+00, 3.43145e+00, 3.18110e+00, 2.94902e+00, 2.73387e+00,
     & 2.53441e+00, 2.34951e+00, 2.17810e+00, 2.01919e+00, 1.87188e+00/
      DATA (SELFREF(JT, 3),JT=1,10)  /
     & 6.17433e+00, 5.62207e+00, 5.11920e+00, 4.66131e+00, 4.24438e+00,
     & 3.86474e+00, 3.51906e+00, 3.20430e+00, 2.91769e+00, 2.65672e+00/
      DATA (SELFREF(JT, 4),JT=1,10)  /
     & 6.56459e+00, 5.94787e+00, 5.38910e+00, 4.88282e+00, 4.42410e+00,
     & 4.00848e+00, 3.63190e+00, 3.29070e+00, 2.98155e+00, 2.70145e+00/
      DATA (SELFREF(JT, 5),JT=1,10)  /
     & 6.49581e+00, 5.91114e+00, 5.37910e+00, 4.89494e+00, 4.45436e+00,
     & 4.05344e+00, 3.68860e+00, 3.35660e+00, 3.05448e+00, 2.77956e+00/
      DATA (SELFREF(JT, 6),JT=1,10)  /
     & 6.50189e+00, 5.89381e+00, 5.34260e+00, 4.84294e+00, 4.39001e+00,
     & 3.97944e+00, 3.60727e+00, 3.26990e+00, 2.96409e+00, 2.68687e+00/
      DATA (SELFREF(JT, 7),JT=1,10)  /
     & 6.64768e+00, 6.01719e+00, 5.44650e+00, 4.92993e+00, 4.46236e+00,
     & 4.03914e+00, 3.65605e+00, 3.30930e+00, 2.99543e+00, 2.71134e+00/
      DATA (SELFREF(JT, 8),JT=1,10)  /
     & 6.43744e+00, 5.87166e+00, 5.35560e+00, 4.88490e+00, 4.45557e+00,
     & 4.06397e+00, 3.70679e+00, 3.38100e+00, 3.08384e+00, 2.81281e+00/
      DATA (SELFREF(JT, 9),JT=1,10)  /
     & 6.55466e+00, 5.99777e+00, 5.48820e+00, 5.02192e+00, 4.59525e+00,
     & 4.20484e+00, 3.84759e+00, 3.52070e+00, 3.22158e+00, 2.94787e+00/
      DATA (SELFREF(JT,10),JT=1,10)  /
     & 6.84510e+00, 6.26933e+00, 5.74200e+00, 5.25902e+00, 4.81667e+00,
     & 4.41152e+00, 4.04046e+00, 3.70060e+00, 3.38933e+00, 3.10424e+00/
      DATA (SELFREF(JT,11),JT=1,10)  /
     & 6.83128e+00, 6.25536e+00, 5.72800e+00, 5.24510e+00, 4.80291e+00,
     & 4.39799e+00, 4.02722e+00, 3.68770e+00, 3.37681e+00, 3.09212e+00/
      DATA (SELFREF(JT,12),JT=1,10)  /
     & 7.35969e+00, 6.61719e+00, 5.94960e+00, 5.34936e+00, 4.80968e+00,
     & 4.32445e+00, 3.88817e+00, 3.49590e+00, 3.14321e+00, 2.82610e+00/
      DATA (SELFREF(JT,13),JT=1,10)  /
     & 7.50064e+00, 6.80749e+00, 6.17840e+00, 5.60744e+00, 5.08925e+00,
     & 4.61894e+00, 4.19210e+00, 3.80470e+00, 3.45310e+00, 3.13399e+00/
      DATA (SELFREF(JT,14),JT=1,10)  /
     & 7.40801e+00, 6.71328e+00, 6.08370e+00, 5.51316e+00, 4.99613e+00,
     & 4.52759e+00, 4.10298e+00, 3.71820e+00, 3.36950e+00, 3.05351e+00/
      DATA (SELFREF(JT,15),JT=1,10)  /
     & 7.51895e+00, 6.68846e+00, 5.94970e+00, 5.29254e+00, 4.70796e+00,
     & 4.18795e+00, 3.72538e+00, 3.31390e+00, 2.94787e+00, 2.62227e+00/
      DATA (SELFREF(JT,16),JT=1,10)  /
     & 7.84774e+00, 6.80673e+00, 5.90380e+00, 5.12065e+00, 4.44138e+00,
     & 3.85223e+00, 3.34122e+00, 2.89800e+00, 2.51357e+00, 2.18014e+00/
