C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB02.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.0 $
C     created:   $Date: 2002/06/03 20:33:28 $
       PARAMETER (MG=16)
       REAL KA(5,13,MG), KB(5,13:59,MG)
       DIMENSION SELFREF(10,MG), FORREF(4,MG)

       COMMON /HVRSN2/ HVRKG2

       COMMON /K2/ KA ,KB, FORREF, SELFREF

       CHARACTER*15 HVRKG2

       DATA HVRKG2  / '$Revision: 3.0 $' /

C     The array KA contains absorption coefs at the 16 chosen g-values 
C     for a range of pressure levels > ~100mb and temperatures.  The first
C     index in the array, JT, which runs from 1 to 5, corresponds to 
C     different temperatures.  More specifically, JT = 3 means that the 
C     data are for the corresponding TREF for this  pressure level, 
C     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
C     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
C     index, JP, runs from 1 to 13 and refers to the corresponding 
C     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
C     The third index, IG, goes from 1 to 16, and tells us which 
C     g-interval the absorption coefficients are for.

      DATA (KA(JT, 1, 1),JT=1,5) /
     &4.9444E-03,5.9459E-03,7.0909E-03,8.2082E-03,9.2071E-03/
      DATA (KA(JT, 2, 1),JT=1,5) /
     &3.6253E-03,4.3860E-03,5.2541E-03,6.0419E-03,6.8835E-03/
      DATA (KA(JT, 3, 1),JT=1,5) /
     &2.5338E-03,3.0985E-03,3.7400E-03,4.2996E-03,4.9675E-03/
      DATA (KA(JT, 4, 1),JT=1,5) /
     &1.7755E-03,2.1973E-03,2.6664E-03,3.1111E-03,3.6091E-03/
      DATA (KA(JT, 5, 1),JT=1,5) /
     &1.2565E-03,1.5789E-03,1.9196E-03,2.3096E-03,2.6519E-03/
      DATA (KA(JT, 6, 1),JT=1,5) /
     &8.8624E-04,1.1175E-03,1.3818E-03,1.6934E-03,1.9635E-03/
      DATA (KA(JT, 7, 1),JT=1,5) /
     &6.2843E-04,7.9253E-04,1.0012E-03,1.2222E-03,1.4734E-03/
      DATA (KA(JT, 8, 1),JT=1,5) /
     &4.5023E-04,5.6483E-04,7.1568E-04,8.9026E-04,1.0929E-03/
      DATA (KA(JT, 9, 1),JT=1,5) /
     &3.2520E-04,4.0407E-04,5.1209E-04,6.4949E-04,7.9581E-04/
      DATA (KA(JT,10, 1),JT=1,5) /
     &2.4126E-04,2.9581E-04,3.7404E-04,4.7585E-04,5.9085E-04/
      DATA (KA(JT,11, 1),JT=1,5) /
     &1.9501E-04,2.4152E-04,3.0649E-04,3.9104E-04,4.8881E-04/
      DATA (KA(JT,12, 1),JT=1,5) /
     &1.5881E-04,1.9763E-04,2.5177E-04,3.2441E-04,4.0632E-04/
      DATA (KA(JT,13, 1),JT=1,5) /
     &1.3003E-04,1.6216E-04,2.0768E-04,2.6864E-04,3.3497E-04/
      DATA (KA(JT, 1, 2),JT=1,5) /
     &1.0027E-02,1.1791E-02,1.3932E-02,1.6666E-02,2.0126E-02/
      DATA (KA(JT, 2, 2),JT=1,5) /
     &7.4056E-03,8.8285E-03,1.0460E-02,1.2669E-02,1.5282E-02/
      DATA (KA(JT, 3, 2),JT=1,5) /
     &5.2661E-03,6.2928E-03,7.5540E-03,9.2387E-03,1.1182E-02/
      DATA (KA(JT, 4, 2),JT=1,5) /
     &3.7830E-03,4.5144E-03,5.4622E-03,6.6869E-03,8.1435E-03/
      DATA (KA(JT, 5, 2),JT=1,5) /
     &2.7480E-03,3.3042E-03,3.9726E-03,4.8258E-03,5.9510E-03/
      DATA (KA(JT, 6, 2),JT=1,5) /
     &2.0063E-03,2.3984E-03,2.8713E-03,3.4864E-03,4.3135E-03/
      DATA (KA(JT, 7, 2),JT=1,5) /
     &1.4846E-03,1.7453E-03,2.0981E-03,2.5444E-03,3.1056E-03/
      DATA (KA(JT, 8, 2),JT=1,5) /
     &1.1210E-03,1.2879E-03,1.5449E-03,1.8524E-03,2.2562E-03/
      DATA (KA(JT, 9, 2),JT=1,5) /
     &8.5574E-04,9.6423E-04,1.1336E-03,1.3659E-03,1.6594E-03/
      DATA (KA(JT,10, 2),JT=1,5) /
     &6.6848E-04,7.4016E-04,8.5479E-04,1.0274E-03,1.2343E-03/
      DATA (KA(JT,11, 2),JT=1,5) /
     &5.5022E-04,6.0473E-04,6.9963E-04,8.4106E-04,1.0097E-03/
      DATA (KA(JT,12, 2),JT=1,5) /
     &4.4972E-04,4.9436E-04,5.7239E-04,6.8738E-04,8.3038E-04/
      DATA (KA(JT,13, 2),JT=1,5) /
     &3.6745E-04,4.0460E-04,4.6828E-04,5.6427E-04,6.8387E-04/
      DATA (KA(JT, 1, 3),JT=1,5) /
     &2.0475E-02,2.4886E-02,2.8056E-02,3.1687E-02,3.6011E-02/
      DATA (KA(JT, 2, 3),JT=1,5) /
     &1.5293E-02,1.8649E-02,2.1197E-02,2.4106E-02,2.7485E-02/
      DATA (KA(JT, 3, 3),JT=1,5) /
     &1.0918E-02,1.3480E-02,1.5496E-02,1.7769E-02,2.0398E-02/
      DATA (KA(JT, 4, 3),JT=1,5) /
     &7.7395E-03,9.6625E-03,1.1379E-02,1.3130E-02,1.5170E-02/
      DATA (KA(JT, 5, 3),JT=1,5) /
     &5.4995E-03,6.9063E-03,8.5233E-03,9.8125E-03,1.1368E-02/
      DATA (KA(JT, 6, 3),JT=1,5) /
     &3.9002E-03,4.9307E-03,6.2037E-03,7.3100E-03,8.4689E-03/
      DATA (KA(JT, 7, 3),JT=1,5) /
     &2.7369E-03,3.5078E-03,4.4352E-03,5.5098E-03,6.3463E-03/
      DATA (KA(JT, 8, 3),JT=1,5) /
     &1.9294E-03,2.5028E-03,3.1751E-03,4.0255E-03,4.7593E-03/
      DATA (KA(JT, 9, 3),JT=1,5) /
     &1.2806E-03,1.7659E-03,2.2786E-03,2.8933E-03,3.6112E-03/
      DATA (KA(JT,10, 3),JT=1,5) /
     &8.6429E-04,1.2871E-03,1.6661E-03,2.1207E-03,2.6956E-03/
      DATA (KA(JT,11, 3),JT=1,5) /
     &7.0989E-04,1.0555E-03,1.3691E-03,1.7450E-03,2.2184E-03/
      DATA (KA(JT,12, 3),JT=1,5) /
     &5.8630E-04,8.6615E-04,1.1265E-03,1.4357E-03,1.8221E-03/
      DATA (KA(JT,13, 3),JT=1,5) /
     &4.8372E-04,7.1031E-04,9.2618E-04,1.1787E-03,1.4998E-03/
      DATA (KA(JT, 1, 4),JT=1,5) /
     &3.4150E-02,4.0367E-02,4.9280E-02,5.9100E-02,6.9499E-02/
      DATA (KA(JT, 2, 4),JT=1,5) /
     &2.5504E-02,3.0447E-02,3.7321E-02,4.4944E-02,5.3298E-02/
      DATA (KA(JT, 3, 4),JT=1,5) /
     &1.8371E-02,2.2085E-02,2.7226E-02,3.2994E-02,3.9403E-02/
      DATA (KA(JT, 4, 4),JT=1,5) /
     &1.3235E-02,1.6046E-02,1.9813E-02,2.4156E-02,2.9082E-02/
      DATA (KA(JT, 5, 4),JT=1,5) /
     &9.5998E-03,1.1709E-02,1.4338E-02,1.7707E-02,2.1505E-02/
      DATA (KA(JT, 6, 4),JT=1,5) /
     &6.9022E-03,8.5630E-03,1.0395E-02,1.2869E-02,1.5787E-02/
      DATA (KA(JT, 7, 4),JT=1,5) /
     &5.0622E-03,6.1861E-03,7.5642E-03,9.2835E-03,1.1530E-02/
      DATA (KA(JT, 8, 4),JT=1,5) /
     &3.7734E-03,4.4956E-03,5.5749E-03,6.7721E-03,8.4253E-03/
      DATA (KA(JT, 9, 4),JT=1,5) /
     &2.9619E-03,3.3315E-03,4.0621E-03,4.9694E-03,6.1117E-03/
      DATA (KA(JT,10, 4),JT=1,5) /
     &2.2204E-03,2.5123E-03,3.0176E-03,3.7321E-03,4.5545E-03/
      DATA (KA(JT,11, 4),JT=1,5) /
     &1.8288E-03,2.0602E-03,2.4838E-03,3.0685E-03,3.7508E-03/
      DATA (KA(JT,12, 4),JT=1,5) /
     &1.5051E-03,1.6916E-03,2.0466E-03,2.5239E-03,3.0905E-03/
      DATA (KA(JT,13, 4),JT=1,5) /
     &1.2373E-03,1.3907E-03,1.6848E-03,2.0764E-03,2.5455E-03/
      DATA (KA(JT, 1, 5),JT=1,5) /
     &7.4128E-02,9.0328E-02,1.0845E-01,1.2842E-01,1.4993E-01/
      DATA (KA(JT, 2, 5),JT=1,5) /
     &5.6421E-02,6.8932E-02,8.3294E-02,9.9111E-02,1.1617E-01/
      DATA (KA(JT, 3, 5),JT=1,5) /
     &4.0916E-02,5.0385E-02,6.1257E-02,7.3474E-02,8.6732E-02/
      DATA (KA(JT, 4, 5),JT=1,5) /
     &2.9430E-02,3.6556E-02,4.4742E-02,5.4199E-02,6.4580E-02/
      DATA (KA(JT, 5, 5),JT=1,5) /
     &2.1212E-02,2.6602E-02,3.2780E-02,4.0084E-02,4.8236E-02/
      DATA (KA(JT, 6, 5),JT=1,5) /
     &1.5151E-02,1.9129E-02,2.3897E-02,2.9436E-02,3.5798E-02/
      DATA (KA(JT, 7, 5),JT=1,5) /
     &1.0718E-02,1.3802E-02,1.7389E-02,2.1505E-02,2.6440E-02/
      DATA (KA(JT, 8, 5),JT=1,5) /
     &7.4917E-03,9.9125E-03,1.2578E-02,1.5770E-02,1.9483E-02/
      DATA (KA(JT, 9, 5),JT=1,5) /
     &5.1168E-03,7.0368E-03,9.1089E-03,1.1527E-02,1.4293E-02/
      DATA (KA(JT,10, 5),JT=1,5) /
     &3.6983E-03,5.0627E-03,6.6991E-03,8.5275E-03,1.0696E-02/
      DATA (KA(JT,11, 5),JT=1,5) /
     &3.0484E-03,4.1916E-03,5.5346E-03,7.0513E-03,8.8498E-03/
      DATA (KA(JT,12, 5),JT=1,5) /
     &2.5174E-03,3.4714E-03,4.5718E-03,5.8341E-03,7.3195E-03/
      DATA (KA(JT,13, 5),JT=1,5) /
     &2.0770E-03,2.8684E-03,3.7718E-03,4.8192E-03,6.0412E-03/
      DATA (KA(JT, 1, 6),JT=1,5) /
     &2.0613E-01,2.5157E-01,3.0178E-01,3.5683E-01,4.1542E-01/
      DATA (KA(JT, 2, 6),JT=1,5) /
     &1.5819E-01,1.9432E-01,2.3452E-01,2.7858E-01,3.2587E-01/
      DATA (KA(JT, 3, 6),JT=1,5) /
     &1.1531E-01,1.4306E-01,1.7435E-01,2.0876E-01,2.4632E-01/
      DATA (KA(JT, 4, 6),JT=1,5) /
     &8.3284E-02,1.0444E-01,1.2864E-01,1.5560E-01,1.8535E-01/
      DATA (KA(JT, 5, 6),JT=1,5) /
     &6.0166E-02,7.6315E-02,9.4937E-02,1.1604E-01,1.3958E-01/
      DATA (KA(JT, 6, 6),JT=1,5) /
     &4.3003E-02,5.5230E-02,6.9447E-02,8.5781E-02,1.0424E-01/
      DATA (KA(JT, 7, 6),JT=1,5) /
     &3.0490E-02,3.9769E-02,5.0618E-02,6.3200E-02,7.7597E-02/
      DATA (KA(JT, 8, 6),JT=1,5) /
     &2.1570E-02,2.8573E-02,3.6803E-02,4.6437E-02,5.7626E-02/
      DATA (KA(JT, 9, 6),JT=1,5) /
     &1.5155E-02,2.0450E-02,2.6673E-02,3.4004E-02,4.2620E-02/
      DATA (KA(JT,10, 6),JT=1,5) /
     &1.0852E-02,1.4893E-02,1.9668E-02,2.5324E-02,3.1992E-02/
      DATA (KA(JT,11, 6),JT=1,5) /
     &9.0511E-03,1.2422E-02,1.6374E-02,2.1084E-02,2.6643E-02/
      DATA (KA(JT,12, 6),JT=1,5) /
     &7.5332E-03,1.0338E-02,1.3623E-02,1.7531E-02,2.2174E-02/
      DATA (KA(JT,13, 6),JT=1,5) /
     &6.2568E-03,8.5754E-03,1.1313E-02,1.4562E-02,1.8439E-02/
      DATA (KA(JT, 1, 7),JT=1,5) /
     &6.4924E-01,7.7307E-01,9.0386E-01,1.0388E+00,1.1773E+00/
      DATA (KA(JT, 2, 7),JT=1,5) /
     &5.0577E-01,6.0786E-01,7.1639E-01,8.2855E-01,9.4493E-01/
      DATA (KA(JT, 3, 7),JT=1,5) /
     &3.7384E-01,4.5638E-01,5.4361E-01,6.3563E-01,7.3108E-01/
      DATA (KA(JT, 4, 7),JT=1,5) /
     &2.7157E-01,3.3769E-01,4.0798E-01,4.8298E-01,5.6158E-01/
      DATA (KA(JT, 5, 7),JT=1,5) /
     &1.9648E-01,2.4838E-01,3.0521E-01,3.6590E-01,4.3005E-01/
      DATA (KA(JT, 6, 7),JT=1,5) /
     &1.3966E-01,1.7987E-01,2.2524E-01,2.7405E-01,3.2593E-01/
      DATA (KA(JT, 7, 7),JT=1,5) /
     &9.8353E-02,1.2917E-01,1.6445E-01,2.0365E-01,2.4531E-01/
      DATA (KA(JT, 8, 7),JT=1,5) /
     &6.8795E-02,9.2244E-02,1.1951E-01,1.5053E-01,1.8392E-01/
      DATA (KA(JT, 9, 7),JT=1,5) /
     &4.7720E-02,6.5374E-02,8.6294E-02,1.1044E-01,1.3721E-01/
      DATA (KA(JT,10, 7),JT=1,5) /
     &3.3881E-02,4.7211E-02,6.3377E-02,8.2294E-02,1.0374E-01/
      DATA (KA(JT,11, 7),JT=1,5) /
     &2.8304E-02,3.9386E-02,5.2911E-02,6.8671E-02,8.6477E-02/
      DATA (KA(JT,12, 7),JT=1,5) /
     &2.3643E-02,3.2849E-02,4.4121E-02,5.7246E-02,7.2052E-02/
      DATA (KA(JT,13, 7),JT=1,5) /
     &1.9678E-02,2.7339E-02,3.6693E-02,4.7583E-02,5.9838E-02/
      DATA (KA(JT, 1, 8),JT=1,5) /
     &1.5852E+00,1.8937E+00,2.2233E+00,2.5759E+00,2.9447E+00/
      DATA (KA(JT, 2, 8),JT=1,5) /
     &1.3020E+00,1.5608E+00,1.8408E+00,2.1415E+00,2.4614E+00/
      DATA (KA(JT, 3, 8),JT=1,5) /
     &1.0126E+00,1.2239E+00,1.4553E+00,1.7040E+00,1.9702E+00/
      DATA (KA(JT, 4, 8),JT=1,5) /
     &7.6856E-01,9.4025E-01,1.1316E+00,1.3386E+00,1.5605E+00/
      DATA (KA(JT, 5, 8),JT=1,5) /
     &5.7616E-01,7.1359E-01,8.6832E-01,1.0388E+00,1.2228E+00/
      DATA (KA(JT, 6, 8),JT=1,5) /
     &4.2350E-01,5.3268E-01,6.5605E-01,7.9334E-01,9.4223E-01/
      DATA (KA(JT, 7, 8),JT=1,5) /
     &3.0686E-01,3.9225E-01,4.9010E-01,5.9944E-01,7.1967E-01/
      DATA (KA(JT, 8, 8),JT=1,5) /
     &2.2070E-01,2.8688E-01,3.6348E-01,4.5007E-01,5.4597E-01/
      DATA (KA(JT, 9, 8),JT=1,5) /
     &1.5750E-01,2.0832E-01,2.6774E-01,3.3584E-01,4.1169E-01/
      DATA (KA(JT,10, 8),JT=1,5) /
     &1.1458E-01,1.5398E-01,2.0047E-01,2.5420E-01,3.1452E-01/
      DATA (KA(JT,11, 8),JT=1,5) /
     &9.6352E-02,1.2945E-01,1.6850E-01,2.1343E-01,2.6418E-01/
      DATA (KA(JT,12, 8),JT=1,5) /
     &8.0859E-02,1.0869E-01,1.4142E-01,1.7905E-01,2.2159E-01/
      DATA (KA(JT,13, 8),JT=1,5) /
     &6.7685E-02,9.1028E-02,1.1838E-01,1.4990E-01,1.8559E-01/
      DATA (KA(JT, 1, 9),JT=1,5) /
     &5.2550E+00,6.3269E+00,7.5188E+00,8.8046E+00,1.0194E+01/
      DATA (KA(JT, 2, 9),JT=1,5) /
     &4.6603E+00,5.6500E+00,6.7441E+00,7.9369E+00,9.2112E+00/
      DATA (KA(JT, 3, 9),JT=1,5) /
     &3.9124E+00,4.7902E+00,5.7591E+00,6.8243E+00,7.9677E+00/
      DATA (KA(JT, 4, 9),JT=1,5) /
     &3.2096E+00,3.9597E+00,4.8029E+00,5.7377E+00,6.7626E+00/
      DATA (KA(JT, 5, 9),JT=1,5) /
     &2.5970E+00,3.2435E+00,3.9726E+00,4.7826E+00,5.6814E+00/
      DATA (KA(JT, 6, 9),JT=1,5) /
     &2.0409E+00,2.5854E+00,3.2065E+00,3.9078E+00,4.6887E+00/
      DATA (KA(JT, 7, 9),JT=1,5) /
     &1.5708E+00,2.0187E+00,2.5381E+00,3.1327E+00,3.8016E+00/
      DATA (KA(JT, 8, 9),JT=1,5) /
     &1.1892E+00,1.5546E+00,1.9836E+00,2.4782E+00,3.0361E+00/
      DATA (KA(JT, 9, 9),JT=1,5) /
     &8.8412E-01,1.1765E+00,1.5263E+00,1.9325E+00,2.3921E+00/
      DATA (KA(JT,10, 9),JT=1,5) /
     &6.6160E-01,8.9598E-01,1.1789E+00,1.5110E+00,1.8897E+00/
      DATA (KA(JT,11, 9),JT=1,5) /
     &5.6952E-01,7.7339E-01,1.0185E+00,1.3041E+00,1.6292E+00/
      DATA (KA(JT,12, 9),JT=1,5) /
     &4.8820E-01,6.6319E-01,8.7290E-01,1.1167E+00,1.3956E+00/
      DATA (KA(JT,13, 9),JT=1,5) /
     &4.1555E-01,5.6459E-01,7.4208E-01,9.4959E-01,1.1894E+00/
      DATA (KA(JT, 1,10),JT=1,5) /
     &1.2977E+01,1.5399E+01,1.8084E+01,2.1107E+01,2.4279E+01/
      DATA (KA(JT, 2,10),JT=1,5) /
     &1.2242E+01,1.4713E+01,1.7530E+01,2.0660E+01,2.4161E+01/
      DATA (KA(JT, 3,10),JT=1,5) /
     &1.0793E+01,1.3120E+01,1.5954E+01,1.9118E+01,2.2561E+01/
      DATA (KA(JT, 4,10),JT=1,5) /
     &9.2115E+00,1.1467E+01,1.4090E+01,1.6870E+01,1.9865E+01/
      DATA (KA(JT, 5,10),JT=1,5) /
     &7.7076E+00,9.6964E+00,1.2018E+01,1.4581E+01,1.7283E+01/
      DATA (KA(JT, 6,10),JT=1,5) /
     &6.3938E+00,8.1632E+00,1.0170E+01,1.2328E+01,1.4702E+01/
      DATA (KA(JT, 7,10),JT=1,5) /
     &5.2643E+00,6.8431E+00,8.5879E+00,1.0497E+01,1.2599E+01/
      DATA (KA(JT, 8,10),JT=1,5) /
     &4.2306E+00,5.5592E+00,7.0542E+00,8.7515E+00,1.0687E+01/
      DATA (KA(JT, 9,10),JT=1,5) /
     &3.3029E+00,4.4196E+00,5.6740E+00,7.1182E+00,8.8343E+00/
      DATA (KA(JT,10,10),JT=1,5) /
     &2.6002E+00,3.5171E+00,4.6049E+00,5.8654E+00,7.3550E+00/
      DATA (KA(JT,11,10),JT=1,5) /
     &2.3411E+00,3.1582E+00,4.1576E+00,5.3440E+00,6.7154E+00/
      DATA (KA(JT,12,10),JT=1,5) /
     &2.0671E+00,2.8097E+00,3.7158E+00,4.7938E+00,5.9967E+00/
      DATA (KA(JT,13,10),JT=1,5) /
     &1.8130E+00,2.4724E+00,3.2908E+00,4.2191E+00,5.2351E+00/
      DATA (KA(JT, 1,11),JT=1,5) /
     &1.7369E+01,2.0982E+01,2.4652E+01,2.8692E+01,3.3179E+01/
      DATA (KA(JT, 2,11),JT=1,5) /
     &1.6823E+01,2.0457E+01,2.4236E+01,2.8171E+01,3.2333E+01/
      DATA (KA(JT, 3,11),JT=1,5) /
     &1.5375E+01,1.8905E+01,2.2457E+01,2.6420E+01,3.0766E+01/
      DATA (KA(JT, 4,11),JT=1,5) /
     &1.3375E+01,1.6618E+01,2.0128E+01,2.4207E+01,2.8664E+01/
      DATA (KA(JT, 5,11),JT=1,5) /
     &1.1552E+01,1.4477E+01,1.7747E+01,2.1616E+01,2.5966E+01/
      DATA (KA(JT, 6,11),JT=1,5) /
     &9.7662E+00,1.2339E+01,1.5425E+01,1.9082E+01,2.3024E+01/
      DATA (KA(JT, 7,11),JT=1,5) /
     &8.0435E+00,1.0356E+01,1.3162E+01,1.6422E+01,1.9976E+01/
      DATA (KA(JT, 8,11),JT=1,5) /
     &6.6475E+00,8.6800E+00,1.1208E+01,1.4127E+01,1.7194E+01/
      DATA (KA(JT, 9,11),JT=1,5) /
     &5.4286E+00,7.1938E+00,9.4274E+00,1.1995E+01,1.4788E+01/
      DATA (KA(JT,10,11),JT=1,5) /
     &4.4519E+00,5.9777E+00,7.8591E+00,1.0067E+01,1.2572E+01/
      DATA (KA(JT,11,11),JT=1,5) /
     &4.1097E+00,5.5519E+00,7.2615E+00,9.2610E+00,1.1615E+01/
      DATA (KA(JT,12,11),JT=1,5) /
     &3.7565E+00,5.0648E+00,6.6341E+00,8.4916E+00,1.0710E+01/
      DATA (KA(JT,13,11),JT=1,5) /
     &3.3842E+00,4.5598E+00,5.9909E+00,7.7387E+00,9.7720E+00/
      DATA (KA(JT, 1,12),JT=1,5) /
     &2.2275E+01,2.7471E+01,3.3492E+01,4.0225E+01,4.7465E+01/
      DATA (KA(JT, 2,12),JT=1,5) /
     &2.2476E+01,2.7446E+01,3.3072E+01,3.9336E+01,4.6205E+01/
      DATA (KA(JT, 3,12),JT=1,5) /
     &2.1150E+01,2.6276E+01,3.1885E+01,3.7595E+01,4.3863E+01/
      DATA (KA(JT, 4,12),JT=1,5) /
     &1.9455E+01,2.4367E+01,2.9875E+01,3.5713E+01,4.1802E+01/
      DATA (KA(JT, 5,12),JT=1,5) /
     &1.7406E+01,2.2244E+01,2.7648E+01,3.3299E+01,3.9489E+01/
      DATA (KA(JT, 6,12),JT=1,5) /
     &1.5271E+01,1.9641E+01,2.4614E+01,3.0133E+01,3.6348E+01/
      DATA (KA(JT, 7,12),JT=1,5) /
     &1.3343E+01,1.7102E+01,2.1495E+01,2.6582E+01,3.2562E+01/
      DATA (KA(JT, 8,12),JT=1,5) /
     &1.1399E+01,1.4767E+01,1.8657E+01,2.3239E+01,2.8870E+01/
      DATA (KA(JT, 9,12),JT=1,5) /
     &9.4462E+00,1.2437E+01,1.5942E+01,2.0083E+01,2.5175E+01/
      DATA (KA(JT,10,12),JT=1,5) /
     &7.9561E+00,1.0576E+01,1.3751E+01,1.7625E+01,2.2224E+01/
      DATA (KA(JT,11,12),JT=1,5) /
     &7.6703E+00,1.0214E+01,1.3362E+01,1.7172E+01,2.1565E+01/
      DATA (KA(JT,12,12),JT=1,5) /
     &7.3002E+00,9.7613E+00,1.2808E+01,1.6448E+01,2.0508E+01/
      DATA (KA(JT,13,12),JT=1,5) /
     &6.8227E+00,9.1662E+00,1.2005E+01,1.5291E+01,1.9104E+01/
      DATA (KA(JT, 1,13),JT=1,5) /
     &2.8154E+01,3.5750E+01,4.4791E+01,5.4873E+01,6.6140E+01/
      DATA (KA(JT, 2,13),JT=1,5) /
     &2.8745E+01,3.6229E+01,4.5340E+01,5.5950E+01,6.7860E+01/
      DATA (KA(JT, 3,13),JT=1,5) /
     &2.8731E+01,3.5740E+01,4.4190E+01,5.4581E+01,6.6390E+01/
      DATA (KA(JT, 4,13),JT=1,5) /
     &2.7586E+01,3.5028E+01,4.3053E+01,5.2513E+01,6.3590E+01/
      DATA (KA(JT, 5,13),JT=1,5) /
     &2.6083E+01,3.3437E+01,4.1632E+01,5.0781E+01,6.1113E+01/
      DATA (KA(JT, 6,13),JT=1,5) /
     &2.3829E+01,3.1109E+01,3.9228E+01,4.8371E+01,5.8278E+01/
      DATA (KA(JT, 7,13),JT=1,5) /
     &2.1209E+01,2.8372E+01,3.6376E+01,4.5363E+01,5.5372E+01/
      DATA (KA(JT, 8,13),JT=1,5) /
     &1.8790E+01,2.5354E+01,3.3043E+01,4.1793E+01,5.1443E+01/
      DATA (KA(JT, 9,13),JT=1,5) /
     &1.6798E+01,2.2642E+01,2.9578E+01,3.7822E+01,4.7058E+01/
      DATA (KA(JT,10,13),JT=1,5) /
     &1.4972E+01,2.0558E+01,2.6854E+01,3.4253E+01,4.2864E+01/
      DATA (KA(JT,11,13),JT=1,5) /
     &1.5310E+01,2.0781E+01,2.6920E+01,3.4183E+01,4.2625E+01/
      DATA (KA(JT,12,13),JT=1,5) /
     &1.5266E+01,2.0520E+01,2.6628E+01,3.3712E+01,4.2182E+01/
      DATA (KA(JT,13,13),JT=1,5) /
     &1.4957E+01,1.9939E+01,2.5957E+01,3.3111E+01,4.1486E+01/
      DATA (KA(JT, 1,14),JT=1,5) /
     &4.6330E+01,6.0030E+01,7.5480E+01,9.2536E+01,1.1059E+02/
      DATA (KA(JT, 2,14),JT=1,5) /
     &4.4855E+01,5.8960E+01,7.5059E+01,9.2958E+01,1.1209E+02/
      DATA (KA(JT, 3,14),JT=1,5) /
     &4.1447E+01,5.4787E+01,7.1113E+01,8.9291E+01,1.0911E+02/
      DATA (KA(JT, 4,14),JT=1,5) /
     &3.9104E+01,5.0668E+01,6.5934E+01,8.3732E+01,1.0396E+02/
      DATA (KA(JT, 5,14),JT=1,5) /
     &3.8023E+01,4.8275E+01,6.1835E+01,7.8920E+01,9.8684E+01/
      DATA (KA(JT, 6,14),JT=1,5) /
     &3.6671E+01,4.6928E+01,5.9373E+01,7.4910E+01,9.4120E+01/
      DATA (KA(JT, 7,14),JT=1,5) /
     &3.4713E+01,4.5254E+01,5.8164E+01,7.3270E+01,9.1067E+01/
      DATA (KA(JT, 8,14),JT=1,5) /
     &3.2317E+01,4.2931E+01,5.6350E+01,7.1845E+01,8.9533E+01/
      DATA (KA(JT, 9,14),JT=1,5) /
     &2.9466E+01,3.9947E+01,5.3450E+01,6.9454E+01,8.7436E+01/
      DATA (KA(JT,10,14),JT=1,5) /
     &2.7304E+01,3.7491E+01,5.1151E+01,6.7458E+01,8.6217E+01/
      DATA (KA(JT,11,14),JT=1,5) /
     &2.9371E+01,4.0579E+01,5.5614E+01,7.3135E+01,9.3406E+01/
      DATA (KA(JT,12,14),JT=1,5) /
     &3.1557E+01,4.3832E+01,5.9668E+01,7.8288E+01,9.9282E+01/
      DATA (KA(JT,13,14),JT=1,5) /
     &3.3702E+01,4.7002E+01,6.3302E+01,8.2327E+01,1.0363E+02/
      DATA (KA(JT, 1,15),JT=1,5) /
     &7.1097E+01,9.1809E+01,1.1513E+02,1.4077E+02,1.6931E+02/
      DATA (KA(JT, 2,15),JT=1,5) /
     &7.6481E+01,9.9988E+01,1.2655E+02,1.5641E+02,1.9001E+02/
      DATA (KA(JT, 3,15),JT=1,5) /
     &7.6089E+01,1.0186E+02,1.3121E+02,1.6509E+02,2.0316E+02/
      DATA (KA(JT, 4,15),JT=1,5) /
     &7.1689E+01,9.8693E+01,1.3061E+02,1.6745E+02,2.0924E+02/
      DATA (KA(JT, 5,15),JT=1,5) /
     &6.5396E+01,9.2850E+01,1.2644E+02,1.6569E+02,2.1030E+02/
      DATA (KA(JT, 6,15),JT=1,5) /
     &5.9839E+01,8.4120E+01,1.1791E+02,1.5835E+02,2.0497E+02/
      DATA (KA(JT, 7,15),JT=1,5) /
     &5.7504E+01,7.7966E+01,1.0776E+02,1.4729E+02,1.9476E+02/
      DATA (KA(JT, 8,15),JT=1,5) /
     &5.7004E+01,7.5268E+01,1.0086E+02,1.3678E+02,1.8339E+02/
      DATA (KA(JT, 9,15),JT=1,5) /
     &5.5577E+01,7.3906E+01,9.7044E+01,1.2904E+02,1.7226E+02/
      DATA (KA(JT,10,15),JT=1,5) /
     &5.5416E+01,7.4211E+01,9.6440E+01,1.2687E+02,1.6750E+02/
      DATA (KA(JT,11,15),JT=1,5) /
     &6.2860E+01,8.4332E+01,1.0913E+02,1.4265E+02,1.8694E+02/
      DATA (KA(JT,12,15),JT=1,5) /
     &7.1048E+01,9.5286E+01,1.2362E+02,1.6046E+02,2.0975E+02/
      DATA (KA(JT,13,15),JT=1,5) /
     &7.9451E+01,1.0631E+02,1.3951E+02,1.8076E+02,2.3534E+02/
      DATA (KA(JT, 1,16),JT=1,5) /
     &7.6064E+01,1.0164E+02,1.3126E+02,1.6469E+02,2.0152E+02/
      DATA (KA(JT, 2,16),JT=1,5) /
     &8.3803E+01,1.1323E+02,1.4816E+02,1.8796E+02,2.3219E+02/
      DATA (KA(JT, 3,16),JT=1,5) /
     &8.7402E+01,1.1813E+02,1.5778E+02,2.0377E+02,2.5553E+02/
      DATA (KA(JT, 4,16),JT=1,5) /
     &8.7865E+01,1.1968E+02,1.6142E+02,2.1263E+02,2.7144E+02/
      DATA (KA(JT, 5,16),JT=1,5) /
     &8.6499E+01,1.2062E+02,1.6367E+02,2.1790E+02,2.8301E+02/
      DATA (KA(JT, 6,16),JT=1,5) /
     &8.2494E+01,1.1893E+02,1.6400E+02,2.2086E+02,2.8964E+02/
      DATA (KA(JT, 7,16),JT=1,5) /
     &7.7078E+01,1.1526E+02,1.6302E+02,2.2306E+02,2.9645E+02/
      DATA (KA(JT, 8,16),JT=1,5) /
     &7.0841E+01,1.1011E+02,1.6059E+02,2.2458E+02,3.0342E+02/
      DATA (KA(JT, 9,16),JT=1,5) /
     &7.4013E+01,1.0313E+02,1.5566E+02,2.2324E+02,3.0785E+02/
      DATA (KA(JT,10,16),JT=1,5) /
     &8.3043E+01,1.0119E+02,1.5304E+02,2.2535E+02,3.1705E+02/
      DATA (KA(JT,11,16),JT=1,5) /
     &1.0007E+02,1.2237E+02,1.8107E+02,2.6762E+02,3.7672E+02/
      DATA (KA(JT,12,16),JT=1,5) /
     &1.1998E+02,1.4801E+02,2.1370E+02,3.1623E+02,4.4496E+02/
      DATA (KA(JT,13,16),JT=1,5) /
     &1.4282E+02,1.7830E+02,2.5018E+02,3.7037E+02,5.2070E+02/

C     The array KB contains absorption coefs at the 16 chosen g-values 
C     for a range of pressure levels < ~100mb and temperatures. The first 
C     index in the array, JT, which runs from 1 to 5, corresponds to 
C     different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this pressure 
C     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
C     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
C     The second index, JP, runs from 13 to 59 and refers to the JPth
C     reference pressure level (see taumol.f for the value of these
C     pressure levels in mb).  The third index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA (KB(JT,13, 1),JT=1,5) /
     &1.3000E-04,1.6216E-04,2.0768E-04,2.6864E-04,3.3497E-04/
      DATA (KB(JT,14, 1),JT=1,5) /
     &1.0850E-04,1.3602E-04,1.7553E-04,2.2686E-04,2.8162E-04/
      DATA (KB(JT,15, 1),JT=1,5) /
     &9.0864E-05,1.1476E-04,1.4832E-04,1.9081E-04,2.3698E-04/
      DATA (KB(JT,16, 1),JT=1,5) /
     &7.6202E-05,9.6897E-05,1.2521E-04,1.6032E-04,1.9925E-04/
      DATA (KB(JT,17, 1),JT=1,5) /
     &6.3984E-05,8.1671E-05,1.0565E-04,1.3448E-04,1.6696E-04/
      DATA (KB(JT,18, 1),JT=1,5) /
     &5.3749E-05,6.8759E-05,8.9036E-05,1.1274E-04,1.3824E-04/
      DATA (KB(JT,19, 1),JT=1,5) /
     &4.5160E-05,5.7874E-05,7.4954E-05,9.4487E-05,1.1485E-04/
      DATA (KB(JT,20, 1),JT=1,5) /
     &3.8050E-05,4.8934E-05,6.3376E-05,7.9393E-05,9.5565E-05/
      DATA (KB(JT,21, 1),JT=1,5) /
     &3.2121E-05,4.1368E-05,5.3585E-05,6.6749E-05,7.9704E-05/
      DATA (KB(JT,22, 1),JT=1,5) /
     &2.7597E-05,3.5606E-05,4.6066E-05,5.6919E-05,6.7252E-05/
      DATA (KB(JT,23, 1),JT=1,5) /
     &2.3703E-05,3.0672E-05,3.9251E-05,4.8622E-05,5.6783E-05/
      DATA (KB(JT,24, 1),JT=1,5) /
     &2.0444E-05,2.6471E-05,3.3535E-05,4.1441E-05,4.8070E-05/
      DATA (KB(JT,25, 1),JT=1,5) /
     &1.7691E-05,2.2899E-05,2.8737E-05,3.4776E-05,4.0820E-05/
      DATA (KB(JT,26, 1),JT=1,5) /
     &1.5391E-05,1.9900E-05,2.4708E-05,2.9438E-05,3.4884E-05/
      DATA (KB(JT,27, 1),JT=1,5) /
     &1.3401E-05,1.7231E-05,2.1300E-05,2.5041E-05,2.9843E-05/
      DATA (KB(JT,28, 1),JT=1,5) /
     &1.1671E-05,1.4827E-05,1.8383E-05,2.1307E-05,2.5549E-05/
      DATA (KB(JT,29, 1),JT=1,5) /
     &1.0183E-05,1.2798E-05,1.5535E-05,1.8197E-05,2.1838E-05/
      DATA (KB(JT,30, 1),JT=1,5) /
     &8.8844E-06,1.1043E-05,1.3172E-05,1.5593E-05,1.8678E-05/
      DATA (KB(JT,31, 1),JT=1,5) /
     &7.7313E-06,9.5518E-06,1.1237E-05,1.3382E-05,1.5999E-05/
      DATA (KB(JT,32, 1),JT=1,5) /
     &6.6794E-06,8.2781E-06,9.5924E-06,1.1496E-05,1.3717E-05/
      DATA (KB(JT,33, 1),JT=1,5) /
     &5.7815E-06,7.0042E-06,8.2098E-06,9.8489E-06,1.1766E-05/
      DATA (KB(JT,34, 1),JT=1,5) /
     &4.9641E-06,5.9235E-06,7.0090E-06,8.3895E-06,1.0037E-05/
      DATA (KB(JT,35, 1),JT=1,5) /
     &4.1780E-06,4.9520E-06,5.8797E-06,7.0288E-06,8.4123E-06/
      DATA (KB(JT,36, 1),JT=1,5) /
     &3.4370E-06,4.0690E-06,4.8335E-06,5.7766E-06,6.9140E-06/
      DATA (KB(JT,37, 1),JT=1,5) /
     &2.7366E-06,3.2617E-06,3.8617E-06,4.6224E-06,5.5308E-06/
      DATA (KB(JT,38, 1),JT=1,5) /
     &2.1763E-06,2.6155E-06,3.0811E-06,3.6939E-06,4.4152E-06/
      DATA (KB(JT,39, 1),JT=1,5) /
     &1.7313E-06,2.1017E-06,2.4606E-06,2.9519E-06,3.5266E-06/
      DATA (KB(JT,40, 1),JT=1,5) /
     &1.3469E-06,1.6693E-06,1.9344E-06,2.3182E-06,2.7667E-06/
      DATA (KB(JT,41, 1),JT=1,5) /
     &1.0461E-06,1.2927E-06,1.5201E-06,1.8107E-06,2.1653E-06/
      DATA (KB(JT,42, 1),JT=1,5) /
     &8.0658E-07,1.0022E-06,1.1943E-06,1.4143E-06,1.6945E-06/
      DATA (KB(JT,43, 1),JT=1,5) /
     &6.1022E-07,7.6847E-07,9.3637E-07,1.0945E-06,1.3137E-06/
      DATA (KB(JT,44, 1),JT=1,5) /
     &4.5840E-07,5.8613E-07,7.2558E-07,8.4731E-07,1.0130E-06/
      DATA (KB(JT,45, 1),JT=1,5) /
     &3.4424E-07,4.4504E-07,5.5242E-07,6.5691E-07,7.7925E-07/
      DATA (KB(JT,46, 1),JT=1,5) /
     &2.5697E-07,3.3261E-07,4.1921E-07,5.1218E-07,5.9773E-07/
      DATA (KB(JT,47, 1),JT=1,5) /
     &1.8987E-07,2.4567E-07,3.1544E-07,3.9053E-07,4.5787E-07/
      DATA (KB(JT,48, 1),JT=1,5) /
     &1.4058E-07,1.8138E-07,2.3483E-07,2.9330E-07,3.5197E-07/
      DATA (KB(JT,49, 1),JT=1,5) /
     &1.0462E-07,1.3385E-07,1.7347E-07,2.2053E-07,2.7396E-07/
      DATA (KB(JT,50, 1),JT=1,5) /
     &7.9205E-08,9.9611E-08,1.2890E-07,1.6695E-07,2.0670E-07/
      DATA (KB(JT,51, 1),JT=1,5) /
     &6.0628E-08,7.4396E-08,9.6049E-08,1.2454E-07,1.5638E-07/
      DATA (KB(JT,52, 1),JT=1,5) /
     &4.5002E-08,5.5943E-08,7.1532E-08,9.2844E-08,1.1852E-07/
      DATA (KB(JT,53, 1),JT=1,5) /
     &3.2555E-08,4.2490E-08,5.3383E-08,6.9149E-08,8.9727E-08/
      DATA (KB(JT,54, 1),JT=1,5) /
     &2.3696E-08,3.2653E-08,4.0140E-08,5.1914E-08,6.7441E-08/
      DATA (KB(JT,55, 1),JT=1,5) /
     &1.7247E-08,2.4546E-08,3.0469E-08,3.9087E-08,5.0840E-08/
      DATA (KB(JT,56, 1),JT=1,5) /
     &1.2515E-08,1.8025E-08,2.3296E-08,2.9456E-08,3.8300E-08/
      DATA (KB(JT,57, 1),JT=1,5) /
     &9.0211E-09,1.3183E-08,1.7891E-08,2.2220E-08,2.8857E-08/
      DATA (KB(JT,58, 1),JT=1,5) /
     &6.4935E-09,9.6472E-09,1.3706E-08,1.6858E-08,2.1803E-08/
      DATA (KB(JT,59, 1),JT=1,5) /
     &5.0413E-09,7.5477E-09,1.0800E-08,1.3392E-08,1.7290E-08/
      DATA (KB(JT,13, 2),JT=1,5) /
     &3.6782E-04,4.0460E-04,4.6828E-04,5.6427E-04,6.8387E-04/
      DATA (KB(JT,14, 2),JT=1,5) /
     &3.0206E-04,3.3534E-04,3.8904E-04,4.6908E-04,5.7354E-04/
      DATA (KB(JT,15, 2),JT=1,5) /
     &2.4903E-04,2.7718E-04,3.2574E-04,3.9271E-04,4.8202E-04/
      DATA (KB(JT,16, 2),JT=1,5) /
     &2.0570E-04,2.3043E-04,2.7323E-04,3.2940E-04,4.0539E-04/
      DATA (KB(JT,17, 2),JT=1,5) /
     &1.6973E-04,1.9226E-04,2.2908E-04,2.7627E-04,3.4057E-04/
      DATA (KB(JT,18, 2),JT=1,5) /
     &1.4059E-04,1.6018E-04,1.9182E-04,2.3171E-04,2.8730E-04/
      DATA (KB(JT,19, 2),JT=1,5) /
     &1.1617E-04,1.3358E-04,1.6042E-04,1.9424E-04,2.4177E-04/
      DATA (KB(JT,20, 2),JT=1,5) /
     &9.6546E-05,1.1187E-04,1.3461E-04,1.6319E-04,2.0430E-04/
      DATA (KB(JT,21, 2),JT=1,5) /
     &8.0465E-05,9.3512E-05,1.1260E-04,1.3712E-04,1.7240E-04/
      DATA (KB(JT,22, 2),JT=1,5) /
     &6.7521E-05,7.9100E-05,9.4853E-05,1.1694E-04,1.4756E-04/
      DATA (KB(JT,23, 2),JT=1,5) /
     &5.6632E-05,6.7211E-05,8.0875E-05,9.9624E-05,1.2638E-04/
      DATA (KB(JT,24, 2),JT=1,5) /
     &4.7866E-05,5.7310E-05,6.9154E-05,8.5301E-05,1.0831E-04/
      DATA (KB(JT,25, 2),JT=1,5) /
     &4.0652E-05,4.8933E-05,5.9257E-05,7.3835E-05,9.2951E-05/
      DATA (KB(JT,26, 2),JT=1,5) /
     &3.4655E-05,4.1694E-05,5.0935E-05,6.3979E-05,8.0042E-05/
      DATA (KB(JT,27, 2),JT=1,5) /
     &2.9633E-05,3.5562E-05,4.3853E-05,5.5348E-05,6.8920E-05/
      DATA (KB(JT,28, 2),JT=1,5) /
     &2.5432E-05,3.0614E-05,3.7665E-05,4.7871E-05,5.9328E-05/
      DATA (KB(JT,29, 2),JT=1,5) /
     &2.1848E-05,2.6432E-05,3.2844E-05,4.1383E-05,5.1047E-05/
      DATA (KB(JT,30, 2),JT=1,5) /
     &1.8680E-05,2.2782E-05,2.8578E-05,3.5766E-05,4.3772E-05/
      DATA (KB(JT,31, 2),JT=1,5) /
     &1.5971E-05,1.9690E-05,2.4825E-05,3.0907E-05,3.7564E-05/
      DATA (KB(JT,32, 2),JT=1,5) /
     &1.3804E-05,1.6977E-05,2.1562E-05,2.6712E-05,3.2275E-05/
      DATA (KB(JT,33, 2),JT=1,5) /
     &1.1945E-05,1.4856E-05,1.8696E-05,2.3037E-05,2.7659E-05/
      DATA (KB(JT,34, 2),JT=1,5) /
     &1.0252E-05,1.2851E-05,1.6075E-05,1.9670E-05,2.3561E-05/
      DATA (KB(JT,35, 2),JT=1,5) /
     &8.6288E-06,1.0847E-05,1.3532E-05,1.6502E-05,1.9733E-05/
      DATA (KB(JT,36, 2),JT=1,5) /
     &7.0970E-06,8.9246E-06,1.1130E-05,1.3564E-05,1.6217E-05/
      DATA (KB(JT,37, 2),JT=1,5) /
     &5.6546E-06,7.0912E-06,8.8667E-06,1.0842E-05,1.2980E-05/
      DATA (KB(JT,38, 2),JT=1,5) /
     &4.4964E-06,5.6180E-06,7.0484E-06,8.6481E-06,1.0377E-05/
      DATA (KB(JT,39, 2),JT=1,5) /
     &3.5794E-06,4.4460E-06,5.6006E-06,6.9055E-06,8.2935E-06/
      DATA (KB(JT,40, 2),JT=1,5) /
     &2.7849E-06,3.4244E-06,4.3497E-06,5.3888E-06,6.5103E-06/
      DATA (KB(JT,41, 2),JT=1,5) /
     &2.1634E-06,2.6661E-06,3.3623E-06,4.1856E-06,5.0849E-06/
      DATA (KB(JT,42, 2),JT=1,5) /
     &1.6951E-06,2.0688E-06,2.5958E-06,3.2479E-06,3.9733E-06/
      DATA (KB(JT,43, 2),JT=1,5) /
     &1.3156E-06,1.5889E-06,1.9703E-06,2.4872E-06,3.0727E-06/
      DATA (KB(JT,44, 2),JT=1,5) /
     &1.0083E-06,1.2108E-06,1.4918E-06,1.8898E-06,2.3484E-06/
      DATA (KB(JT,45, 2),JT=1,5) /
     &7.7597E-07,9.3178E-07,1.1396E-06,1.4323E-06,1.7919E-06/
      DATA (KB(JT,46, 2),JT=1,5) /
     &5.9640E-07,7.1743E-07,8.6664E-07,1.0739E-06,1.3585E-06/
      DATA (KB(JT,47, 2),JT=1,5) /
     &4.5875E-07,5.4303E-07,6.5202E-07,8.0415E-07,1.0165E-06/
      DATA (KB(JT,48, 2),JT=1,5) /
     &3.5634E-07,4.1385E-07,4.9968E-07,6.0505E-07,7.5779E-07/
      DATA (KB(JT,49, 2),JT=1,5) /
     &2.7966E-07,3.1607E-07,3.7849E-07,4.5539E-07,5.6073E-07/
      DATA (KB(JT,50, 2),JT=1,5) /
     &2.2335E-07,2.4619E-07,2.8832E-07,3.4563E-07,4.2520E-07/
      DATA (KB(JT,51, 2),JT=1,5) /
     &1.6810E-07,1.9184E-07,2.2126E-07,2.6681E-07,3.2272E-07/
      DATA (KB(JT,52, 2),JT=1,5) /
     &1.2477E-07,1.5183E-07,1.7051E-07,2.0325E-07,2.4465E-07/
      DATA (KB(JT,53, 2),JT=1,5) /
     &9.1697E-08,1.2163E-07,1.3293E-07,1.5546E-07,1.8654E-07/
      DATA (KB(JT,54, 2),JT=1,5) /
     &6.8066E-08,9.0724E-08,1.0426E-07,1.1988E-07,1.4459E-07/
      DATA (KB(JT,55, 2),JT=1,5) /
     &5.0853E-08,6.8116E-08,8.2949E-08,9.3086E-08,1.1106E-07/
      DATA (KB(JT,56, 2),JT=1,5) /
     &3.8097E-08,5.0708E-08,6.6601E-08,7.3097E-08,8.5626E-08/
      DATA (KB(JT,57, 2),JT=1,5) /
     &2.8575E-08,3.7778E-08,5.0543E-08,5.7226E-08,6.6193E-08/
      DATA (KB(JT,58, 2),JT=1,5) /
     &2.1274E-08,2.8319E-08,3.8061E-08,4.5485E-08,5.1336E-08/
      DATA (KB(JT,59, 2),JT=1,5) /
     &1.6785E-08,2.2389E-08,3.0047E-08,3.6850E-08,4.1308E-08/
      DATA (KB(JT,13, 3),JT=1,5) /
     &4.8329E-04,7.1031E-04,9.2618E-04,1.1787E-03,1.4998E-03/
      DATA (KB(JT,14, 3),JT=1,5) /
     &4.1573E-04,5.9621E-04,7.7781E-04,9.9253E-04,1.2561E-03/
      DATA (KB(JT,15, 3),JT=1,5) /
     &3.5745E-04,5.0356E-04,6.5391E-04,8.3999E-04,1.0559E-03/
      DATA (KB(JT,16, 3),JT=1,5) /
     &3.0758E-04,4.2512E-04,5.5063E-04,7.1032E-04,8.8405E-04/
      DATA (KB(JT,17, 3),JT=1,5) /
     &2.6428E-04,3.5939E-04,4.6476E-04,5.9990E-04,7.3444E-04/
      DATA (KB(JT,18, 3),JT=1,5) /
     &2.2620E-04,3.0371E-04,3.9242E-04,5.0569E-04,6.1057E-04/
      DATA (KB(JT,19, 3),JT=1,5) /
     &1.9349E-04,2.5703E-04,3.3045E-04,4.2572E-04,5.0885E-04/
      DATA (KB(JT,20, 3),JT=1,5) /
     &1.6601E-04,2.1679E-04,2.7938E-04,3.5877E-04,4.2456E-04/
      DATA (KB(JT,21, 3),JT=1,5) /
     &1.3973E-04,1.8356E-04,2.3660E-04,3.0163E-04,3.5438E-04/
      DATA (KB(JT,22, 3),JT=1,5) /
     &1.2024E-04,1.5775E-04,2.0424E-04,2.5718E-04,2.9870E-04/
      DATA (KB(JT,23, 3),JT=1,5) /
     &1.0421E-04,1.3581E-04,1.7576E-04,2.1785E-04,2.5256E-04/
      DATA (KB(JT,24, 3),JT=1,5) /
     &9.0642E-05,1.1736E-04,1.5142E-04,1.8334E-04,2.1432E-04/
      DATA (KB(JT,25, 3),JT=1,5) /
     &7.8653E-05,1.0139E-04,1.3046E-04,1.5520E-04,1.8200E-04/
      DATA (KB(JT,26, 3),JT=1,5) /
     &6.8347E-05,8.8330E-05,1.1221E-04,1.3139E-04,1.5501E-04/
      DATA (KB(JT,27, 3),JT=1,5) /
     &5.9438E-05,7.7110E-05,9.6484E-05,1.1163E-04,1.3198E-04/
      DATA (KB(JT,28, 3),JT=1,5) /
     &5.1865E-05,6.7062E-05,8.1622E-05,9.5189E-05,1.1250E-04/
      DATA (KB(JT,29, 3),JT=1,5) /
     &4.5229E-05,5.8248E-05,6.9371E-05,8.1305E-05,9.5987E-05/
      DATA (KB(JT,30, 3),JT=1,5) /
     &3.9548E-05,5.0236E-05,5.8927E-05,6.9361E-05,8.1985E-05/
      DATA (KB(JT,31, 3),JT=1,5) /
     &3.4672E-05,4.3357E-05,5.0119E-05,5.9230E-05,7.0087E-05/
      DATA (KB(JT,32, 3),JT=1,5) /
     &3.0291E-05,3.6761E-05,4.2859E-05,5.0621E-05,5.9826E-05/
      DATA (KB(JT,33, 3),JT=1,5) /
     &2.6343E-05,3.1291E-05,3.6685E-05,4.3251E-05,5.1136E-05/
      DATA (KB(JT,34, 3),JT=1,5) /
     &2.2619E-05,2.6479E-05,3.1160E-05,3.6817E-05,4.3454E-05/
      DATA (KB(JT,35, 3),JT=1,5) /
     &1.9044E-05,2.2094E-05,2.6069E-05,3.0814E-05,3.6332E-05/
      DATA (KB(JT,36, 3),JT=1,5) /
     &1.5660E-05,1.8150E-05,2.1420E-05,2.5318E-05,2.9845E-05/
      DATA (KB(JT,37, 3),JT=1,5) /
     &1.2481E-05,1.4567E-05,1.7160E-05,2.0273E-05,2.3924E-05/
      DATA (KB(JT,38, 3),JT=1,5) /
     &9.9229E-06,1.1707E-05,1.3728E-05,1.6208E-05,1.9147E-05/
      DATA (KB(JT,39, 3),JT=1,5) /
     &7.8980E-06,9.3824E-06,1.0994E-05,1.2956E-05,1.5319E-05/
      DATA (KB(JT,40, 3),JT=1,5) /
     &6.1214E-06,7.4148E-06,8.6411E-06,1.0203E-05,1.2052E-05/
      DATA (KB(JT,41, 3),JT=1,5) /
     &4.7079E-06,5.8792E-06,6.7814E-06,8.0075E-06,9.4649E-06/
      DATA (KB(JT,42, 3),JT=1,5) /
     &3.6048E-06,4.5698E-06,5.3449E-06,6.2854E-06,7.4263E-06/
      DATA (KB(JT,43, 3),JT=1,5) /
     &2.7216E-06,3.5076E-06,4.1783E-06,4.8932E-06,5.7661E-06/
      DATA (KB(JT,44, 3),JT=1,5) /
     &2.0468E-06,2.6504E-06,3.2648E-06,3.7820E-06,4.4701E-06/
      DATA (KB(JT,45, 3),JT=1,5) /
     &1.5361E-06,1.9893E-06,2.5184E-06,2.9393E-06,3.4602E-06/
      DATA (KB(JT,46, 3),JT=1,5) /
     &1.1503E-06,1.4832E-06,1.9137E-06,2.2823E-06,2.6719E-06/
      DATA (KB(JT,47, 3),JT=1,5) /
     &8.3777E-07,1.0971E-06,1.4217E-06,1.7739E-06,2.0443E-06/
      DATA (KB(JT,48, 3),JT=1,5) /
     &6.1407E-07,8.0972E-07,1.0453E-06,1.3363E-06,1.5776E-06/
      DATA (KB(JT,49, 3),JT=1,5) /
     &4.3890E-07,5.9676E-07,7.7449E-07,1.0018E-06,1.2151E-06/
      DATA (KB(JT,50, 3),JT=1,5) /
     &3.0232E-07,4.3632E-07,5.7501E-07,7.4600E-07,9.3964E-07/
      DATA (KB(JT,51, 3),JT=1,5) /
     &2.1820E-07,3.2558E-07,4.2933E-07,5.5411E-07,7.1236E-07/
      DATA (KB(JT,52, 3),JT=1,5) /
     &1.6142E-07,2.3096E-07,3.1815E-07,4.1428E-07,5.3670E-07/
      DATA (KB(JT,53, 3),JT=1,5) /
     &1.2239E-07,1.5927E-07,2.3415E-07,3.0848E-07,4.0010E-07/
      DATA (KB(JT,54, 3),JT=1,5) /
     &9.4287E-08,1.1772E-07,1.7609E-07,2.3226E-07,2.9972E-07/
      DATA (KB(JT,55, 3),JT=1,5) /
     &7.3559E-08,8.8158E-08,1.2627E-07,1.7401E-07,2.2659E-07/
      DATA (KB(JT,56, 3),JT=1,5) /
     &5.7474E-08,6.7419E-08,8.9064E-08,1.2949E-07,1.7067E-07/
      DATA (KB(JT,57, 3),JT=1,5) /
     &4.5317E-08,5.2043E-08,6.5424E-08,9.7761E-08,1.2882E-07/
      DATA (KB(JT,58, 3),JT=1,5) /
     &3.4988E-08,4.0617E-08,4.8970E-08,7.1601E-08,9.7431E-08/
      DATA (KB(JT,59, 3),JT=1,5) /
     &2.8131E-08,3.2653E-08,3.8986E-08,5.5678E-08,7.6933E-08/
      DATA (KB(JT,13, 4),JT=1,5) /
     &1.2375E-03,1.3907E-03,1.6848E-03,2.0764E-03,2.5455E-03/
      DATA (KB(JT,14, 4),JT=1,5) /
     &1.0352E-03,1.1626E-03,1.4153E-03,1.7410E-03,2.1410E-03/
      DATA (KB(JT,15, 4),JT=1,5) /
     &8.6916E-04,9.7450E-04,1.1918E-03,1.4617E-03,1.8090E-03/
      DATA (KB(JT,16, 4),JT=1,5) /
     &7.1556E-04,8.1812E-04,1.0040E-03,1.2311E-03,1.5286E-03/
      DATA (KB(JT,17, 4),JT=1,5) /
     &5.8965E-04,6.8521E-04,8.4372E-04,1.0375E-03,1.2976E-03/
      DATA (KB(JT,18, 4),JT=1,5) /
     &4.8726E-04,5.7342E-04,7.0979E-04,8.7350E-04,1.0996E-03/
      DATA (KB(JT,19, 4),JT=1,5) /
     &4.0346E-04,4.7923E-04,5.9512E-04,7.3474E-04,9.2909E-04/
      DATA (KB(JT,20, 4),JT=1,5) /
     &3.3252E-04,4.0340E-04,5.0129E-04,6.2120E-04,7.8738E-04/
      DATA (KB(JT,21, 4),JT=1,5) /
     &2.7824E-04,3.3959E-04,4.2206E-04,5.2456E-04,6.6651E-04/
      DATA (KB(JT,22, 4),JT=1,5) /
     &2.3686E-04,2.9111E-04,3.6067E-04,4.4836E-04,5.7225E-04/
      DATA (KB(JT,23, 4),JT=1,5) /
     &2.0203E-04,2.4985E-04,3.0880E-04,3.8545E-04,4.9113E-04/
      DATA (KB(JT,24, 4),JT=1,5) /
     &1.7215E-04,2.1409E-04,2.6491E-04,3.3340E-04,4.2129E-04/
      DATA (KB(JT,25, 4),JT=1,5) /
     &1.4744E-04,1.8341E-04,2.2761E-04,2.8826E-04,3.6138E-04/
      DATA (KB(JT,26, 4),JT=1,5) /
     &1.2712E-04,1.5795E-04,1.9671E-04,2.5046E-04,3.1109E-04/
      DATA (KB(JT,27, 4),JT=1,5) /
     &1.1012E-04,1.3626E-04,1.6969E-04,2.1697E-04,2.6764E-04/
      DATA (KB(JT,28, 4),JT=1,5) /
     &9.5268E-05,1.1775E-04,1.4811E-04,1.8739E-04,2.3002E-04/
      DATA (KB(JT,29, 4),JT=1,5) /
     &8.1990E-05,1.0183E-04,1.2887E-04,1.6155E-04,1.9779E-04/
      DATA (KB(JT,30, 4),JT=1,5) /
     &7.0812E-05,8.8197E-05,1.1209E-04,1.3932E-04,1.6990E-04/
      DATA (KB(JT,31, 4),JT=1,5) /
     &6.1297E-05,7.6242E-05,9.7371E-05,1.2004E-04,1.4578E-04/
      DATA (KB(JT,32, 4),JT=1,5) /
     &5.3068E-05,6.6743E-05,8.4358E-05,1.0341E-04,1.2514E-04/
      DATA (KB(JT,33, 4),JT=1,5) /
     &4.6021E-05,5.8210E-05,7.2823E-05,8.9095E-05,1.0732E-04/
      DATA (KB(JT,34, 4),JT=1,5) /
     &3.9611E-05,5.0325E-05,6.2484E-05,7.6131E-05,9.1418E-05/
      DATA (KB(JT,35, 4),JT=1,5) /
     &3.3314E-05,4.2493E-05,5.2519E-05,6.3851E-05,7.6543E-05/
      DATA (KB(JT,36, 4),JT=1,5) /
     &2.7397E-05,3.4956E-05,4.3170E-05,5.2466E-05,6.2879E-05/
      DATA (KB(JT,37, 4),JT=1,5) /
     &2.1842E-05,2.7769E-05,3.4424E-05,4.1912E-05,5.0314E-05/
      DATA (KB(JT,38, 4),JT=1,5) /
     &1.7352E-05,2.1971E-05,2.7389E-05,3.3429E-05,4.0195E-05/
      DATA (KB(JT,39, 4),JT=1,5) /
     &1.3770E-05,1.7414E-05,2.1778E-05,2.6648E-05,3.2100E-05/
      DATA (KB(JT,40, 4),JT=1,5) /
     &1.0696E-05,1.3450E-05,1.6968E-05,2.0795E-05,2.5164E-05/
      DATA (KB(JT,41, 4),JT=1,5) /
     &8.2926E-06,1.0301E-05,1.3150E-05,1.6196E-05,1.9663E-05/
      DATA (KB(JT,42, 4),JT=1,5) /
     &6.4321E-06,7.9930E-06,1.0153E-05,1.2599E-05,1.5345E-05/
      DATA (KB(JT,43, 4),JT=1,5) /
     &4.9294E-06,6.1147E-06,7.7222E-06,9.6711E-06,1.1840E-05/
      DATA (KB(JT,44, 4),JT=1,5) /
     &3.7796E-06,4.6518E-06,5.8136E-06,7.3808E-06,9.0677E-06/
      DATA (KB(JT,45, 4),JT=1,5) /
     &2.8649E-06,3.5446E-06,4.4045E-06,5.6003E-06,6.9419E-06/
      DATA (KB(JT,46, 4),JT=1,5) /
     &2.1636E-06,2.6897E-06,3.3348E-06,4.2109E-06,5.2785E-06/
      DATA (KB(JT,47, 4),JT=1,5) /
     &1.6423E-06,2.0325E-06,2.5019E-06,3.1092E-06,3.9697E-06/
      DATA (KB(JT,48, 4),JT=1,5) /
     &1.2438E-06,1.5176E-06,1.8805E-06,2.3386E-06,2.9598E-06/
      DATA (KB(JT,49, 4),JT=1,5) /
     &9.6637E-07,1.1421E-06,1.4184E-06,1.7520E-06,2.2027E-06/
      DATA (KB(JT,50, 4),JT=1,5) /
     &7.6681E-07,8.7015E-07,1.0718E-06,1.3233E-06,1.6436E-06/
      DATA (KB(JT,51, 4),JT=1,5) /
     &5.7638E-07,6.6674E-07,8.0765E-07,1.0019E-06,1.2448E-06/
      DATA (KB(JT,52, 4),JT=1,5) /
     &4.3579E-07,5.2641E-07,6.1480E-07,7.6360E-07,9.4101E-07/
      DATA (KB(JT,53, 4),JT=1,5) /
     &3.2630E-07,4.1175E-07,4.6866E-07,5.7670E-07,7.1273E-07/
      DATA (KB(JT,54, 4),JT=1,5) /
     &2.4508E-07,3.1226E-07,3.6234E-07,4.3785E-07,5.4334E-07/
      DATA (KB(JT,55, 4),JT=1,5) /
     &1.8867E-07,2.3849E-07,2.8812E-07,3.3656E-07,4.1795E-07/
      DATA (KB(JT,56, 4),JT=1,5) /
     &1.3888E-07,1.8052E-07,2.2770E-07,2.5896E-07,3.1922E-07/
      DATA (KB(JT,57, 4),JT=1,5) /
     &9.9211E-08,1.3628E-07,1.7309E-07,2.0040E-07,2.4315E-07/
      DATA (KB(JT,58, 4),JT=1,5) /
     &7.2311E-08,1.0440E-07,1.3249E-07,1.5839E-07,1.8707E-07/
      DATA (KB(JT,59, 4),JT=1,5) /
     &5.6449E-08,8.3969E-08,1.0579E-07,1.2870E-07,1.4987E-07/
      DATA (KB(JT,13, 5),JT=1,5) /
     &2.0768E-03,2.8684E-03,3.7718E-03,4.8192E-03,6.0412E-03/
      DATA (KB(JT,14, 5),JT=1,5) /
     &1.7564E-03,2.4332E-03,3.1824E-03,4.0625E-03,5.0889E-03/
      DATA (KB(JT,15, 5),JT=1,5) /
     &1.4908E-03,2.0712E-03,2.6934E-03,3.4353E-03,4.2909E-03/
      DATA (KB(JT,16, 5),JT=1,5) /
     &1.2837E-03,1.7624E-03,2.2850E-03,2.9120E-03,3.6366E-03/
      DATA (KB(JT,17, 5),JT=1,5) /
     &1.1007E-03,1.4970E-03,1.9372E-03,2.4633E-03,3.0868E-03/
      DATA (KB(JT,18, 5),JT=1,5) /
     &9.3998E-04,1.2697E-03,1.6378E-03,2.0802E-03,2.6082E-03/
      DATA (KB(JT,19, 5),JT=1,5) /
     &8.0100E-04,1.0742E-03,1.3849E-03,1.7569E-03,2.2030E-03/
      DATA (KB(JT,20, 5),JT=1,5) /
     &6.8663E-04,9.1195E-04,1.1757E-03,1.4883E-03,1.8647E-03/
      DATA (KB(JT,21, 5),JT=1,5) /
     &5.8705E-04,7.7399E-04,9.9752E-04,1.2607E-03,1.5771E-03/
      DATA (KB(JT,22, 5),JT=1,5) /
     &5.1050E-04,6.6826E-04,8.5880E-04,1.0835E-03,1.3514E-03/
      DATA (KB(JT,23, 5),JT=1,5) /
     &4.4216E-04,5.7700E-04,7.3906E-04,9.3102E-04,1.1572E-03/
      DATA (KB(JT,24, 5),JT=1,5) /
     &3.8397E-04,4.9926E-04,6.3682E-04,8.0099E-04,9.9155E-04/
      DATA (KB(JT,25, 5),JT=1,5) /
     &3.3452E-04,4.3352E-04,5.4972E-04,6.8946E-04,8.5204E-04/
      DATA (KB(JT,26, 5),JT=1,5) /
     &2.9253E-04,3.7705E-04,4.7637E-04,5.9546E-04,7.3410E-04/
      DATA (KB(JT,27, 5),JT=1,5) /
     &2.5516E-04,3.2740E-04,4.1271E-04,5.1423E-04,6.3183E-04/
      DATA (KB(JT,28, 5),JT=1,5) /
     &2.2216E-04,2.8389E-04,3.5748E-04,4.4367E-04,5.4344E-04/
      DATA (KB(JT,29, 5),JT=1,5) /
     &1.9425E-04,2.4642E-04,3.0966E-04,3.8285E-04,4.6743E-04/
      DATA (KB(JT,30, 5),JT=1,5) /
     &1.6916E-04,2.1405E-04,2.6782E-04,3.3008E-04,4.0176E-04/
      DATA (KB(JT,31, 5),JT=1,5) /
     &1.4722E-04,1.8596E-04,2.3162E-04,2.8455E-04,3.4535E-04/
      DATA (KB(JT,32, 5),JT=1,5) /
     &1.2822E-04,1.6146E-04,2.0021E-04,2.4528E-04,2.9677E-04/
      DATA (KB(JT,33, 5),JT=1,5) /
     &1.1158E-04,1.4011E-04,1.7313E-04,2.1133E-04,2.5496E-04/
      DATA (KB(JT,34, 5),JT=1,5) /
     &9.6356E-05,1.2055E-04,1.4854E-04,1.8079E-04,2.1758E-04/
      DATA (KB(JT,35, 5),JT=1,5) /
     &8.1343E-05,1.0151E-04,1.2490E-04,1.5178E-04,1.8239E-04/
      DATA (KB(JT,36, 5),JT=1,5) /
     &6.6965E-05,8.3520E-05,1.0275E-04,1.2482E-04,1.4993E-04/
      DATA (KB(JT,37, 5),JT=1,5) /
     &5.3206E-05,6.6545E-05,8.1990E-05,9.9764E-05,1.2001E-04/
      DATA (KB(JT,38, 5),JT=1,5) /
     &4.2208E-05,5.2902E-05,6.5299E-05,7.9577E-05,9.5895E-05/
      DATA (KB(JT,39, 5),JT=1,5) /
     &3.3472E-05,4.2041E-05,5.1984E-05,6.3462E-05,7.6593E-05/
      DATA (KB(JT,40, 5),JT=1,5) /
     &2.5925E-05,3.2660E-05,4.0509E-05,4.9627E-05,6.0037E-05/
      DATA (KB(JT,41, 5),JT=1,5) /
     &2.0003E-05,2.5267E-05,3.1469E-05,3.8672E-05,4.6923E-05/
      DATA (KB(JT,42, 5),JT=1,5) /
     &1.5411E-05,1.9519E-05,2.4420E-05,3.0101E-05,3.6637E-05/
      DATA (KB(JT,43, 5),JT=1,5) /
     &1.1687E-05,1.4867E-05,1.8698E-05,2.3140E-05,2.8269E-05/
      DATA (KB(JT,44, 5),JT=1,5) /
     &8.7679E-06,1.1261E-05,1.4209E-05,1.7673E-05,2.1693E-05/
      DATA (KB(JT,45, 5),JT=1,5) /
     &6.5931E-06,8.5087E-06,1.0776E-05,1.3478E-05,1.6614E-05/
      DATA (KB(JT,46, 5),JT=1,5) /
     &4.9080E-06,6.3755E-06,8.1160E-06,1.0213E-05,1.2647E-05/
      DATA (KB(JT,47, 5),JT=1,5) /
     &3.5919E-06,4.7038E-06,6.0534E-06,7.6485E-06,9.5281E-06/
      DATA (KB(JT,48, 5),JT=1,5) /
     &2.6062E-06,3.4739E-06,4.4987E-06,5.7085E-06,7.1618E-06/
      DATA (KB(JT,49, 5),JT=1,5) /
     &1.8621E-06,2.5496E-06,3.3246E-06,4.2578E-06,5.3684E-06/
      DATA (KB(JT,50, 5),JT=1,5) /
     &1.3311E-06,1.8748E-06,2.4717E-06,3.1893E-06,4.0386E-06/
      DATA (KB(JT,51, 5),JT=1,5) /
     &9.8374E-07,1.3665E-06,1.8393E-06,2.3887E-06,3.0388E-06/
      DATA (KB(JT,52, 5),JT=1,5) /
     &7.2293E-07,9.8525E-07,1.3616E-06,1.7795E-06,2.2858E-06/
      DATA (KB(JT,53, 5),JT=1,5) /
     &5.3539E-07,7.1322E-07,1.0025E-06,1.3275E-06,1.7157E-06/
      DATA (KB(JT,54, 5),JT=1,5) /
     &3.9532E-07,5.3074E-07,7.3585E-07,9.9485E-07,1.2941E-06/
      DATA (KB(JT,55, 5),JT=1,5) /
     &2.9574E-07,3.9534E-07,5.3898E-07,7.4534E-07,9.7510E-07/
      DATA (KB(JT,56, 5),JT=1,5) /
     &2.2158E-07,2.9575E-07,3.9553E-07,5.5662E-07,7.3612E-07/
      DATA (KB(JT,57, 5),JT=1,5) /
     &1.7387E-07,2.1999E-07,2.9597E-07,4.1152E-07,5.5434E-07/
      DATA (KB(JT,58, 5),JT=1,5) /
     &1.3813E-07,1.6569E-07,2.2197E-07,3.0386E-07,4.1774E-07/
      DATA (KB(JT,59, 5),JT=1,5) /
     &1.1153E-07,1.3014E-07,1.7513E-07,2.3832E-07,3.3096E-07/
      DATA (KB(JT,13, 6),JT=1,5) /
     &6.2563E-03,8.5754E-03,1.1313E-02,1.4562E-02,1.8439E-02/
      DATA (KB(JT,14, 6),JT=1,5) /
     &5.3407E-03,7.2874E-03,9.6031E-03,1.2344E-02,1.5616E-02/
      DATA (KB(JT,15, 6),JT=1,5) /
     &4.5624E-03,6.2026E-03,8.1616E-03,1.0480E-02,1.3236E-02/
      DATA (KB(JT,16, 6),JT=1,5) /
     &3.8957E-03,5.2793E-03,6.9259E-03,8.8846E-03,1.1202E-02/
      DATA (KB(JT,17, 6),JT=1,5) /
     &3.3209E-03,4.4815E-03,5.8698E-03,7.5204E-03,9.4486E-03/
      DATA (KB(JT,18, 6),JT=1,5) /
     &2.8290E-03,3.8089E-03,4.9773E-03,6.3684E-03,7.9890E-03/
      DATA (KB(JT,19, 6),JT=1,5) /
     &2.4112E-03,3.2462E-03,4.2316E-03,5.4060E-03,6.7720E-03/
      DATA (KB(JT,20, 6),JT=1,5) /
     &2.0691E-03,2.7791E-03,3.6122E-03,4.6028E-03,5.7715E-03/
      DATA (KB(JT,21, 6),JT=1,5) /
     &1.7739E-03,2.3724E-03,3.0729E-03,3.9123E-03,4.9081E-03/
      DATA (KB(JT,22, 6),JT=1,5) /
     &1.5468E-03,2.0535E-03,2.6512E-03,3.3770E-03,4.2260E-03/
      DATA (KB(JT,23, 6),JT=1,5) /
     &1.3475E-03,1.7768E-03,2.2959E-03,2.9141E-03,3.6373E-03/
      DATA (KB(JT,24, 6),JT=1,5) /
     &1.1752E-03,1.5439E-03,1.9895E-03,2.5170E-03,3.1328E-03/
      DATA (KB(JT,25, 6),JT=1,5) /
     &1.0263E-03,1.3444E-03,1.7264E-03,2.1761E-03,2.6990E-03/
      DATA (KB(JT,26, 6),JT=1,5) /
     &9.0166E-04,1.1758E-03,1.5031E-03,1.8871E-03,2.3306E-03/
      DATA (KB(JT,27, 6),JT=1,5) /
     &7.9141E-04,1.0269E-03,1.3074E-03,1.6348E-03,2.0092E-03/
      DATA (KB(JT,28, 6),JT=1,5) /
     &6.9371E-04,8.9592E-04,1.1355E-03,1.4137E-03,1.7327E-03/
      DATA (KB(JT,29, 6),JT=1,5) /
     &6.0795E-04,7.8166E-04,9.8572E-04,1.2233E-03,1.4938E-03/
      DATA (KB(JT,30, 6),JT=1,5) /
     &5.3230E-04,6.8106E-04,8.5522E-04,1.0576E-03,1.2859E-03/
      DATA (KB(JT,31, 6),JT=1,5) /
     &4.6592E-04,5.9303E-04,7.4221E-04,9.1346E-04,1.1061E-03/
      DATA (KB(JT,32, 6),JT=1,5) /
     &4.0751E-04,5.1643E-04,6.4366E-04,7.8848E-04,9.5095E-04/
      DATA (KB(JT,33, 6),JT=1,5) /
     &3.5610E-04,4.4934E-04,5.5753E-04,6.8015E-04,8.1668E-04/
      DATA (KB(JT,34, 6),JT=1,5) /
     &3.0849E-04,3.8773E-04,4.7909E-04,5.8242E-04,6.9697E-04/
      DATA (KB(JT,35, 6),JT=1,5) /
     &2.6100E-04,3.2729E-04,4.0344E-04,4.8961E-04,5.8449E-04/
      DATA (KB(JT,36, 6),JT=1,5) /
     &2.1525E-04,2.6972E-04,3.3236E-04,4.0320E-04,4.8106E-04/
      DATA (KB(JT,37, 6),JT=1,5) /
     &1.7127E-04,2.1505E-04,2.6562E-04,3.2288E-04,3.8605E-04/
      DATA (KB(JT,38, 6),JT=1,5) /
     &1.3592E-04,1.7107E-04,2.1184E-04,2.5803E-04,3.0917E-04/
      DATA (KB(JT,39, 6),JT=1,5) /
     &1.0785E-04,1.3607E-04,1.6885E-04,2.0614E-04,2.4755E-04/
      DATA (KB(JT,40, 6),JT=1,5) /
     &8.3445E-05,1.0573E-04,1.3174E-04,1.6145E-04,1.9465E-04/
      DATA (KB(JT,41, 6),JT=1,5) /
     &6.4274E-05,8.1836E-05,1.0238E-04,1.2600E-04,1.5256E-04/
      DATA (KB(JT,42, 6),JT=1,5) /
     &4.9425E-05,6.3242E-05,7.9461E-05,9.8197E-05,1.1940E-04/
      DATA (KB(JT,43, 6),JT=1,5) /
     &3.7393E-05,4.8142E-05,6.0818E-05,7.5575E-05,9.2337E-05/
      DATA (KB(JT,44, 6),JT=1,5) /
     &2.8031E-05,3.6364E-05,4.6223E-05,5.7754E-05,7.0960E-05/
      DATA (KB(JT,45, 6),JT=1,5) /
     &2.0952E-05,2.7396E-05,3.5050E-05,4.4048E-05,5.4413E-05/
      DATA (KB(JT,46, 6),JT=1,5) /
     &1.5504E-05,2.0469E-05,2.6380E-05,3.3353E-05,4.1465E-05/
      DATA (KB(JT,47, 6),JT=1,5) /
     &1.1285E-05,1.5071E-05,1.9596E-05,2.4961E-05,3.1243E-05/
      DATA (KB(JT,48, 6),JT=1,5) /
     &8.1713E-06,1.1048E-05,1.4507E-05,1.8626E-05,2.3478E-05/
      DATA (KB(JT,49, 6),JT=1,5) /
     &5.8892E-06,8.0594E-06,1.0700E-05,1.3854E-05,1.7591E-05/
      DATA (KB(JT,50, 6),JT=1,5) /
     &4.2527E-06,5.8989E-06,7.9160E-06,1.0341E-05,1.3223E-05/
      DATA (KB(JT,51, 6),JT=1,5) /
     &3.0672E-06,4.3146E-06,5.8537E-06,7.7179E-06,9.9420E-06/
      DATA (KB(JT,52, 6),JT=1,5) /
     &2.1919E-06,3.1415E-06,4.3130E-06,5.7435E-06,7.4576E-06/
      DATA (KB(JT,53, 6),JT=1,5) /
     &1.5489E-06,2.2740E-06,3.1638E-06,4.2575E-06,5.5767E-06/
      DATA (KB(JT,54, 6),JT=1,5) /
     &1.1055E-06,1.6569E-06,2.3353E-06,3.1738E-06,4.1929E-06/
      DATA (KB(JT,55, 6),JT=1,5) /
     &7.7959E-07,1.2025E-06,1.7241E-06,2.3677E-06,3.1567E-06/
      DATA (KB(JT,56, 6),JT=1,5) /
     &5.5393E-07,8.6666E-07,1.2673E-06,1.7619E-06,2.3695E-06/
      DATA (KB(JT,57, 6),JT=1,5) /
     &3.8362E-07,6.2174E-07,9.3002E-07,1.3068E-06,1.7740E-06/
      DATA (KB(JT,58, 6),JT=1,5) /
     &2.6381E-07,4.4330E-07,6.7991E-07,9.7066E-07,1.3310E-06/
      DATA (KB(JT,59, 6),JT=1,5) /
     &2.0120E-07,3.4415E-07,5.3237E-07,7.6501E-07,1.0533E-06/
      DATA (KB(JT,13, 7),JT=1,5) /
     &1.9678E-02,2.7339E-02,3.6693E-02,4.7583E-02,5.9838E-02/
      DATA (KB(JT,14, 7),JT=1,5) /
     &1.6855E-02,2.3332E-02,3.1200E-02,4.0354E-02,5.0549E-02/
      DATA (KB(JT,15, 7),JT=1,5) /
     &1.4447E-02,1.9926E-02,2.6539E-02,3.4203E-02,4.2741E-02/
      DATA (KB(JT,16, 7),JT=1,5) /
     &1.2375E-02,1.7007E-02,2.2570E-02,2.9011E-02,3.6155E-02/
      DATA (KB(JT,17, 7),JT=1,5) /
     &1.0572E-02,1.4480E-02,1.9148E-02,2.4557E-02,3.0543E-02/
      DATA (KB(JT,18, 7),JT=1,5) /
     &9.0187E-03,1.2308E-02,1.6230E-02,2.0762E-02,2.5754E-02/
      DATA (KB(JT,19, 7),JT=1,5) /
     &7.6960E-03,1.0462E-02,1.3757E-02,1.7553E-02,2.1712E-02/
      DATA (KB(JT,20, 7),JT=1,5) /
     &6.5947E-03,8.9295E-03,1.1707E-02,1.4880E-02,1.8332E-02/
      DATA (KB(JT,21, 7),JT=1,5) /
     &5.6518E-03,7.6362E-03,9.9897E-03,1.2646E-02,1.5515E-02/
      DATA (KB(JT,22, 7),JT=1,5) /
     &4.9551E-03,6.6562E-03,8.6611E-03,1.0883E-02,1.3285E-02/
      DATA (KB(JT,23, 7),JT=1,5) /
     &4.3463E-03,5.8019E-03,7.4874E-03,9.3424E-03,1.1393E-02/
      DATA (KB(JT,24, 7),JT=1,5) /
     &3.8088E-03,5.0439E-03,6.4617E-03,8.0406E-03,9.7631E-03/
      DATA (KB(JT,25, 7),JT=1,5) /
     &3.3364E-03,4.3855E-03,5.5891E-03,6.9199E-03,8.3730E-03/
      DATA (KB(JT,26, 7),JT=1,5) /
     &2.9302E-03,3.8269E-03,4.8484E-03,5.9724E-03,7.1930E-03/
      DATA (KB(JT,27, 7),JT=1,5) /
     &2.5694E-03,3.3414E-03,4.2035E-03,5.1445E-03,6.1710E-03/
      DATA (KB(JT,28, 7),JT=1,5) /
     &2.2557E-03,2.9117E-03,3.6362E-03,4.4284E-03,5.2859E-03/
      DATA (KB(JT,29, 7),JT=1,5) /
     &1.9791E-03,2.5337E-03,3.1431E-03,3.8083E-03,4.5227E-03/
      DATA (KB(JT,30, 7),JT=1,5) /
     &1.7348E-03,2.2004E-03,2.7128E-03,3.2695E-03,3.8671E-03/
      DATA (KB(JT,31, 7),JT=1,5) /
     &1.5168E-03,1.9090E-03,2.3389E-03,2.8042E-03,3.3063E-03/
      DATA (KB(JT,32, 7),JT=1,5) /
     &1.3245E-03,1.6546E-03,2.0148E-03,2.4067E-03,2.8256E-03/
      DATA (KB(JT,33, 7),JT=1,5) /
     &1.1547E-03,1.4322E-03,1.7355E-03,2.0639E-03,2.4127E-03/
      DATA (KB(JT,34, 7),JT=1,5) /
     &9.9732E-04,1.2299E-03,1.4851E-03,1.7585E-03,2.0486E-03/
      DATA (KB(JT,35, 7),JT=1,5) /
     &8.4240E-04,1.0365E-03,1.2482E-03,1.4745E-03,1.7149E-03/
      DATA (KB(JT,36, 7),JT=1,5) /
     &6.9459E-04,8.5479E-04,1.0290E-03,1.2151E-03,1.4131E-03/
      DATA (KB(JT,37, 7),JT=1,5) /
     &5.5418E-04,6.8431E-04,8.2605E-04,9.7772E-04,1.1393E-03/
      DATA (KB(JT,38, 7),JT=1,5) /
     &4.4103E-04,5.4666E-04,6.6164E-04,7.8531E-04,9.1717E-04/
      DATA (KB(JT,39, 7),JT=1,5) /
     &3.5078E-04,4.3647E-04,5.2986E-04,6.3056E-04,7.3809E-04/
      DATA (KB(JT,40, 7),JT=1,5) /
     &2.7223E-04,3.4099E-04,4.1623E-04,4.9763E-04,5.8479E-04/
      DATA (KB(JT,41, 7),JT=1,5) /
     &2.1016E-04,2.6529E-04,3.2578E-04,3.9146E-04,4.6190E-04/
      DATA (KB(JT,42, 7),JT=1,5) /
     &1.6186E-04,2.0599E-04,2.5454E-04,3.0749E-04,3.6441E-04/
      DATA (KB(JT,43, 7),JT=1,5) /
     &1.2244E-04,1.5755E-04,1.9631E-04,2.3871E-04,2.8458E-04/
      DATA (KB(JT,44, 7),JT=1,5) /
     &9.1656E-05,1.1940E-04,1.5021E-04,1.8408E-04,2.2084E-04/
      DATA (KB(JT,45, 7),JT=1,5) /
     &6.8343E-05,9.0130E-05,1.1460E-04,1.4155E-04,1.7102E-04/
      DATA (KB(JT,46, 7),JT=1,5) /
     &5.0438E-05,6.7336E-05,8.6692E-05,1.0813E-04,1.3160E-04/
      DATA (KB(JT,47, 7),JT=1,5) /
     &3.6553E-05,4.9462E-05,6.4648E-05,8.1563E-05,1.0018E-04/
      DATA (KB(JT,48, 7),JT=1,5) /
     &2.6343E-05,3.6142E-05,4.7933E-05,6.1264E-05,7.5986E-05/
      DATA (KB(JT,49, 7),JT=1,5) /
     &1.8866E-05,2.6263E-05,3.5311E-05,4.5778E-05,5.7425E-05/
      DATA (KB(JT,50, 7),JT=1,5) /
     &1.3557E-05,1.9139E-05,2.6064E-05,3.4268E-05,4.3473E-05/
      DATA (KB(JT,51, 7),JT=1,5) /
     &9.7297E-06,1.3926E-05,1.9216E-05,2.5597E-05,3.2867E-05/
      DATA (KB(JT,52, 7),JT=1,5) /
     &6.9563E-06,1.0085E-05,1.4103E-05,1.9022E-05,2.4754E-05/
      DATA (KB(JT,53, 7),JT=1,5) /
     &4.9502E-06,7.2644E-06,1.0302E-05,1.4070E-05,1.8558E-05/
      DATA (KB(JT,54, 7),JT=1,5) /
     &3.5499E-06,5.2696E-06,7.5685E-06,1.0462E-05,1.3965E-05/
      DATA (KB(JT,55, 7),JT=1,5) /
     &2.5517E-06,3.8332E-06,5.5671E-06,7.7870E-06,1.0502E-05/
      DATA (KB(JT,56, 7),JT=1,5) /
     &1.8250E-06,2.7802E-06,4.0807E-06,5.7760E-06,7.8765E-06/
      DATA (KB(JT,57, 7),JT=1,5) /
     &1.3020E-06,2.0096E-06,2.9783E-06,4.2688E-06,5.8872E-06/
      DATA (KB(JT,58, 7),JT=1,5) /
     &9.3216E-07,1.4580E-06,2.1842E-06,3.1634E-06,4.4097E-06/
      DATA (KB(JT,59, 7),JT=1,5) /
     &7.2634E-07,1.1405E-06,1.7167E-06,2.4950E-06,3.4919E-06/
      DATA (KB(JT,13, 8),JT=1,5) /
     &6.7703E-02,9.1028E-02,1.1838E-01,1.4990E-01,1.8559E-01/
      DATA (KB(JT,14, 8),JT=1,5) /
     &5.8222E-02,7.8007E-02,1.0118E-01,1.2784E-01,1.5811E-01/
      DATA (KB(JT,15, 8),JT=1,5) /
     &5.0069E-02,6.6838E-02,8.6469E-02,1.0901E-01,1.3468E-01/
      DATA (KB(JT,16, 8),JT=1,5) /
     &4.3038E-02,5.7247E-02,7.3838E-02,9.2876E-02,1.1462E-01/
      DATA (KB(JT,17, 8),JT=1,5) /
     &3.6905E-02,4.8922E-02,6.2921E-02,7.8980E-02,9.7249E-02/
      DATA (KB(JT,18, 8),JT=1,5) /
     &3.1539E-02,4.1670E-02,5.3450E-02,6.6951E-02,8.2335E-02/
      DATA (KB(JT,19, 8),JT=1,5) /
     &2.6840E-02,3.5366E-02,4.5264E-02,5.6569E-02,6.9496E-02/
      DATA (KB(JT,20, 8),JT=1,5) /
     &2.2918E-02,3.0090E-02,3.8404E-02,4.7928E-02,5.8831E-02/
      DATA (KB(JT,21, 8),JT=1,5) /
     &1.9556E-02,2.5586E-02,3.2570E-02,4.0587E-02,4.9753E-02/
      DATA (KB(JT,22, 8),JT=1,5) /
     &1.6988E-02,2.2111E-02,2.8028E-02,3.4852E-02,4.2609E-02/
      DATA (KB(JT,23, 8),JT=1,5) /
     &1.4811E-02,1.9201E-02,2.4269E-02,3.0112E-02,3.6663E-02/
      DATA (KB(JT,24, 8),JT=1,5) /
     &1.2965E-02,1.6745E-02,2.1118E-02,2.6093E-02,3.1689E-02/
      DATA (KB(JT,25, 8),JT=1,5) /
     &1.1393E-02,1.4643E-02,1.8383E-02,2.2644E-02,2.7400E-02/
      DATA (KB(JT,26, 8),JT=1,5) /
     &1.0038E-02,1.2830E-02,1.6015E-02,1.9632E-02,2.3704E-02/
      DATA (KB(JT,27, 8),JT=1,5) /
     &8.8123E-03,1.1178E-02,1.3890E-02,1.6992E-02,2.0492E-02/
      DATA (KB(JT,28, 8),JT=1,5) /
     &7.6974E-03,9.7127E-03,1.2040E-02,1.4716E-02,1.7696E-02/
      DATA (KB(JT,29, 8),JT=1,5) /
     &6.7206E-03,8.4382E-03,1.0458E-02,1.2740E-02,1.5282E-02/
      DATA (KB(JT,30, 8),JT=1,5) /
     &5.8552E-03,7.3524E-03,9.0759E-03,1.1022E-02,1.3175E-02/
      DATA (KB(JT,31, 8),JT=1,5) /
     &5.1145E-03,6.3996E-03,7.8758E-03,9.5283E-03,1.1351E-02/
      DATA (KB(JT,32, 8),JT=1,5) /
     &4.4686E-03,5.5753E-03,6.8326E-03,8.2331E-03,9.7798E-03/
      DATA (KB(JT,33, 8),JT=1,5) /
     &3.9075E-03,4.8544E-03,5.9240E-03,7.1154E-03,8.4216E-03/
      DATA (KB(JT,34, 8),JT=1,5) /
     &3.3885E-03,4.1943E-03,5.1017E-03,6.1096E-03,7.2102E-03/
      DATA (KB(JT,35, 8),JT=1,5) /
     &2.8755E-03,3.5515E-03,4.3142E-03,5.1540E-03,6.0867E-03/
      DATA (KB(JT,36, 8),JT=1,5) /
     &2.3819E-03,2.9429E-03,3.5744E-03,4.2743E-03,5.0503E-03/
      DATA (KB(JT,37, 8),JT=1,5) /
     &1.9080E-03,2.3651E-03,2.8794E-03,3.4539E-03,4.0906E-03/
      DATA (KB(JT,38, 8),JT=1,5) /
     &1.5252E-03,1.8961E-03,2.3154E-03,2.7875E-03,3.3076E-03/
      DATA (KB(JT,39, 8),JT=1,5) /
     &1.2186E-03,1.5204E-03,1.8625E-03,2.2483E-03,2.6746E-03/
      DATA (KB(JT,40, 8),JT=1,5) /
     &9.5047E-04,1.1919E-03,1.4679E-03,1.7800E-03,2.1255E-03/
      DATA (KB(JT,41, 8),JT=1,5) /
     &7.3797E-04,9.3055E-04,1.1523E-03,1.4042E-03,1.6837E-03/
      DATA (KB(JT,42, 8),JT=1,5) /
     &5.7195E-04,7.2531E-04,9.0341E-04,1.1062E-03,1.3320E-03/
      DATA (KB(JT,43, 8),JT=1,5) /
     &4.3632E-04,5.5716E-04,6.9866E-04,8.6074E-04,1.0421E-03/
      DATA (KB(JT,44, 8),JT=1,5) /
     &3.2967E-04,4.2439E-04,5.3607E-04,6.6494E-04,8.0995E-04/
      DATA (KB(JT,45, 8),JT=1,5) /
     &2.4830E-04,3.2230E-04,4.1025E-04,5.1229E-04,6.2794E-04/
      DATA (KB(JT,46, 8),JT=1,5) /
     &1.8517E-04,2.4270E-04,3.1143E-04,3.9189E-04,4.8363E-04/
      DATA (KB(JT,47, 8),JT=1,5) /
     &1.3585E-04,1.8008E-04,2.3317E-04,2.9603E-04,3.6826E-04/
      DATA (KB(JT,48, 8),JT=1,5) /
     &9.9135E-05,1.3301E-04,1.7388E-04,2.2278E-04,2.7947E-04/
      DATA (KB(JT,49, 8),JT=1,5) /
     &7.1904E-05,9.7733E-05,1.2918E-04,1.6699E-04,2.1129E-04/
      DATA (KB(JT,50, 8),JT=1,5) /
     &5.2307E-05,7.2019E-05,9.6216E-05,1.2554E-04,1.6020E-04/
      DATA (KB(JT,51, 8),JT=1,5) /
     &3.7969E-05,5.2997E-05,7.1620E-05,9.4315E-05,1.2143E-04/
      DATA (KB(JT,52, 8),JT=1,5) /
     &2.7413E-05,3.8825E-05,5.3093E-05,7.0665E-05,9.1720E-05/
      DATA (KB(JT,53, 8),JT=1,5) /
     &1.9654E-05,2.8289E-05,3.9179E-05,5.2708E-05,6.9024E-05/
      DATA (KB(JT,54, 8),JT=1,5) /
     &1.4176E-05,2.0734E-05,2.9077E-05,3.9534E-05,5.2234E-05/
      DATA (KB(JT,55, 8),JT=1,5) /
     &1.0223E-05,1.5194E-05,2.1592E-05,2.9664E-05,3.9585E-05/
      DATA (KB(JT,56, 8),JT=1,5) /
     &7.3305E-06,1.1089E-05,1.5976E-05,2.2196E-05,2.9906E-05/
      DATA (KB(JT,57, 8),JT=1,5) /
     &5.2231E-06,8.0475E-06,1.1769E-05,1.6548E-05,2.2524E-05/
      DATA (KB(JT,58, 8),JT=1,5) /
     &3.7230E-06,5.8489E-06,8.6848E-06,1.2363E-05,1.6999E-05/
      DATA (KB(JT,59, 8),JT=1,5) /
     &2.8893E-06,4.5778E-06,6.8447E-06,9.7955E-06,1.3534E-05/
      DATA (KB(JT,13, 9),JT=1,5) /
     &4.1576E-01,5.6459E-01,7.4208E-01,9.4959E-01,1.1894E+00/
      DATA (KB(JT,14, 9),JT=1,5) /
     &3.6259E-01,4.8996E-01,6.4236E-01,8.2178E-01,1.0273E+00/
      DATA (KB(JT,15, 9),JT=1,5) /
     &3.1572E-01,4.2505E-01,5.5650E-01,7.1044E-01,8.8534E-01/
      DATA (KB(JT,16, 9),JT=1,5) /
     &2.7461E-01,3.6869E-01,4.8148E-01,6.1276E-01,7.6136E-01/
      DATA (KB(JT,17, 9),JT=1,5) /
     &2.3842E-01,3.1920E-01,4.1566E-01,5.2724E-01,6.5339E-01/
      DATA (KB(JT,18, 9),JT=1,5) /
     &2.0643E-01,2.7580E-01,3.5808E-01,4.5284E-01,5.5957E-01/
      DATA (KB(JT,19, 9),JT=1,5) /
     &1.7844E-01,2.3768E-01,3.0746E-01,3.8778E-01,4.7826E-01/
      DATA (KB(JT,20, 9),JT=1,5) /
     &1.5457E-01,2.0515E-01,2.6455E-01,3.3275E-01,4.0945E-01/
      DATA (KB(JT,21, 9),JT=1,5) /
     &1.3372E-01,1.7673E-01,2.2718E-01,2.8500E-01,3.5014E-01/
      DATA (KB(JT,22, 9),JT=1,5) /
     &1.1755E-01,1.5455E-01,1.9772E-01,2.4719E-01,3.0287E-01/
      DATA (KB(JT,23, 9),JT=1,5) /
     &1.0319E-01,1.3488E-01,1.7188E-01,2.1417E-01,2.6161E-01/
      DATA (KB(JT,24, 9),JT=1,5) /
     &9.0543E-02,1.1778E-01,1.4943E-01,1.8553E-01,2.2596E-01/
      DATA (KB(JT,25, 9),JT=1,5) /
     &7.9491E-02,1.0285E-01,1.2998E-01,1.6082E-01,1.9540E-01/
      DATA (KB(JT,26, 9),JT=1,5) /
     &7.0023E-02,9.0152E-02,1.1342E-01,1.3988E-01,1.6957E-01/
      DATA (KB(JT,27, 9),JT=1,5) /
     &6.1675E-02,7.9028E-02,9.9049E-02,1.2176E-01,1.4715E-01/
      DATA (KB(JT,28, 9),JT=1,5) /
     &5.4332E-02,6.9290E-02,8.6538E-02,1.0602E-01,1.2768E-01/
      DATA (KB(JT,29, 9),JT=1,5) /
     &4.8016E-02,6.0968E-02,7.5734E-02,9.2386E-02,1.1090E-01/
      DATA (KB(JT,30, 9),JT=1,5) /
     &4.2494E-02,5.3680E-02,6.6413E-02,8.0729E-02,9.6539E-02/
      DATA (KB(JT,31, 9),JT=1,5) /
     &3.7548E-02,4.7237E-02,5.8255E-02,7.0556E-02,8.4102E-02/
      DATA (KB(JT,32, 9),JT=1,5) /
     &3.3189E-02,4.1551E-02,5.1044E-02,6.1646E-02,7.3306E-02/
      DATA (KB(JT,33, 9),JT=1,5) /
     &2.9274E-02,3.6514E-02,4.4704E-02,5.3824E-02,6.3833E-02/
      DATA (KB(JT,34, 9),JT=1,5) /
     &2.5627E-02,3.1864E-02,3.8903E-02,4.6747E-02,5.5596E-02/
      DATA (KB(JT,35, 9),JT=1,5) /
     &2.1952E-02,2.7259E-02,3.3247E-02,4.0073E-02,4.7679E-02/
      DATA (KB(JT,36, 9),JT=1,5) /
     &1.8347E-02,2.2808E-02,2.7904E-02,3.3738E-02,4.0178E-02/
      DATA (KB(JT,37, 9),JT=1,5) /
     &1.4833E-02,1.8504E-02,2.2807E-02,2.7664E-02,3.3111E-02/
      DATA (KB(JT,38, 9),JT=1,5) /
     &1.1957E-02,1.5000E-02,1.8592E-02,2.2638E-02,2.7241E-02/
      DATA (KB(JT,39, 9),JT=1,5) /
     &9.6263E-03,1.2169E-02,1.5133E-02,1.8540E-02,2.2409E-02/
      DATA (KB(JT,40, 9),JT=1,5) /
     &7.5755E-03,9.6595E-03,1.2095E-02,1.4919E-02,1.8126E-02/
      DATA (KB(JT,41, 9),JT=1,5) /
     &5.9308E-03,7.6313E-03,9.6291E-03,1.1965E-02,1.4606E-02/
      DATA (KB(JT,42, 9),JT=1,5) /
     &4.6365E-03,6.0158E-03,7.6539E-03,9.5769E-03,1.1776E-02/
      DATA (KB(JT,43, 9),JT=1,5) /
     &3.5646E-03,4.6692E-03,5.9951E-03,7.5584E-03,9.3611E-03/
      DATA (KB(JT,44, 9),JT=1,5) /
     &2.7083E-03,3.5831E-03,4.6545E-03,5.9178E-03,7.3883E-03/
      DATA (KB(JT,45, 9),JT=1,5) /
     &2.0498E-03,2.7405E-03,3.5962E-03,4.6175E-03,5.8123E-03/
      DATA (KB(JT,46, 9),JT=1,5) /
     &1.5335E-03,2.0746E-03,2.7520E-03,3.5687E-03,4.5390E-03/
      DATA (KB(JT,47, 9),JT=1,5) /
     &1.1263E-03,1.5445E-03,2.0740E-03,2.7200E-03,3.4958E-03/
      DATA (KB(JT,48, 9),JT=1,5) /
     &8.2184E-04,1.1429E-03,1.5538E-03,2.0625E-03,2.6781E-03/
      DATA (KB(JT,49, 9),JT=1,5) /
     &5.9594E-04,8.3975E-04,1.1570E-03,1.5542E-03,2.0406E-03/
      DATA (KB(JT,50, 9),JT=1,5) /
     &4.3385E-04,6.1951E-04,8.6528E-04,1.1761E-03,1.5615E-03/
      DATA (KB(JT,51, 9),JT=1,5) /
     &3.1545E-04,4.5652E-04,6.4640E-04,8.8983E-04,1.1948E-03/
      DATA (KB(JT,52, 9),JT=1,5) /
     &2.2788E-04,3.3444E-04,4.7984E-04,6.6976E-04,9.1050E-04/
      DATA (KB(JT,53, 9),JT=1,5) /
     &1.6338E-04,2.4338E-04,3.5401E-04,5.0057E-04,6.8907E-04/
      DATA (KB(JT,54, 9),JT=1,5) /
     &1.1823E-04,1.7879E-04,2.6356E-04,3.7767E-04,5.2615E-04/
      DATA (KB(JT,55, 9),JT=1,5) /
     &8.5773E-05,1.3160E-04,1.9666E-04,2.8549E-04,4.0286E-04/
      DATA (KB(JT,56, 9),JT=1,5) /
     &6.1815E-05,9.6294E-05,1.4602E-04,2.1495E-04,3.0724E-04/
      DATA (KB(JT,57, 9),JT=1,5) /
     &4.4282E-05,7.0071E-05,1.0785E-04,1.6097E-04,2.3304E-04/
      DATA (KB(JT,58, 9),JT=1,5) /
     &3.1779E-05,5.1099E-05,7.9795E-05,1.2084E-04,1.7730E-04/
      DATA (KB(JT,59, 9),JT=1,5) /
     &2.4962E-05,4.0511E-05,6.3843E-05,9.7519E-05,1.4426E-04/
      DATA (KB(JT,13,10),JT=1,5) /
     &1.8139E+00,2.4724E+00,3.2908E+00,4.2191E+00,5.2351E+00/
      DATA (KB(JT,14,10),JT=1,5) /
     &1.6219E+00,2.2181E+00,2.9298E+00,3.7301E+00,4.6329E+00/
      DATA (KB(JT,15,10),JT=1,5) /
     &1.4445E+00,1.9645E+00,2.5717E+00,3.2739E+00,4.0834E+00/
      DATA (KB(JT,16,10),JT=1,5) /
     &1.2756E+00,1.7196E+00,2.2454E+00,2.8649E+00,3.5710E+00/
      DATA (KB(JT,17,10),JT=1,5) /
     &1.1121E+00,1.4934E+00,1.9517E+00,2.4879E+00,3.0883E+00/
      DATA (KB(JT,18,10),JT=1,5) /
     &9.6871E-01,1.2953E+00,1.6900E+00,2.1475E+00,2.6630E+00/
      DATA (KB(JT,19,10),JT=1,5) /
     &8.4238E-01,1.1243E+00,1.4633E+00,1.8537E+00,2.2906E+00/
      DATA (KB(JT,20,10),JT=1,5) /
     &7.3459E-01,9.7958E-01,1.2711E+00,1.6026E+00,1.9721E+00/
      DATA (KB(JT,21,10),JT=1,5) /
     &6.4101E-01,8.5278E-01,1.0998E+00,1.3825E+00,1.6970E+00/
      DATA (KB(JT,22,10),JT=1,5) /
     &5.6942E-01,7.5220E-01,9.6596E-01,1.2079E+00,1.4762E+00/
      DATA (KB(JT,23,10),JT=1,5) /
     &5.0503E-01,6.6296E-01,8.4599E-01,1.0531E+00,1.2851E+00/
      DATA (KB(JT,24,10),JT=1,5) /
     &4.4682E-01,5.8292E-01,7.4005E-01,9.1863E-01,1.1187E+00/
      DATA (KB(JT,25,10),JT=1,5) /
     &3.9593E-01,5.1361E-01,6.4951E-01,8.0398E-01,9.7427E-01/
      DATA (KB(JT,26,10),JT=1,5) /
     &3.5212E-01,4.5450E-01,5.7266E-01,7.0571E-01,8.5181E-01/
      DATA (KB(JT,27,10),JT=1,5) /
     &3.1284E-01,4.0173E-01,5.0408E-01,6.1838E-01,7.4572E-01/
      DATA (KB(JT,28,10),JT=1,5) /
     &2.7721E-01,3.5447E-01,4.4231E-01,5.4145E-01,6.5404E-01/
      DATA (KB(JT,29,10),JT=1,5) /
     &2.4517E-01,3.1175E-01,3.8832E-01,4.7588E-01,5.7437E-01/
      DATA (KB(JT,30,10),JT=1,5) /
     &2.1578E-01,2.7344E-01,3.4039E-01,4.1657E-01,5.0271E-01/
      DATA (KB(JT,31,10),JT=1,5) /
     &1.9067E-01,2.4099E-01,2.9914E-01,3.6552E-01,4.4046E-01/
      DATA (KB(JT,32,10),JT=1,5) /
     &1.6874E-01,2.1279E-01,2.6352E-01,3.2154E-01,3.8678E-01/
      DATA (KB(JT,33,10),JT=1,5) /
     &1.4979E-01,1.8828E-01,2.3277E-01,2.8345E-01,3.4103E-01/
      DATA (KB(JT,34,10),JT=1,5) /
     &1.3170E-01,1.6528E-01,2.0425E-01,2.4841E-01,2.9642E-01/
      DATA (KB(JT,35,10),JT=1,5) /
     &1.1324E-01,1.4235E-01,1.7590E-01,2.1287E-01,2.5375E-01/
      DATA (KB(JT,36,10),JT=1,5) /
     &9.5231E-02,1.1973E-01,1.4778E-01,1.7871E-01,2.1338E-01/
      DATA (KB(JT,37,10),JT=1,5) /
     &7.7445E-02,9.7552E-02,1.1991E-01,1.4578E-01,1.7559E-01/
      DATA (KB(JT,38,10),JT=1,5) /
     &6.2913E-02,7.9354E-02,9.7396E-02,1.1872E-01,1.4502E-01/
      DATA (KB(JT,39,10),JT=1,5) /
     &5.1069E-02,6.4406E-02,7.9431E-02,9.7751E-02,1.1994E-01/
      DATA (KB(JT,40,10),JT=1,5) /
     &4.0487E-02,5.1192E-02,6.3494E-02,7.8782E-02,9.6672E-02/
      DATA (KB(JT,41,10),JT=1,5) /
     &3.1933E-02,4.0574E-02,5.0815E-02,6.3454E-02,7.7908E-02/
      DATA (KB(JT,42,10),JT=1,5) /
     &2.5104E-02,3.2117E-02,4.0690E-02,5.1132E-02,6.3360E-02/
      DATA (KB(JT,43,10),JT=1,5) /
     &1.9359E-02,2.4985E-02,3.2134E-02,4.0672E-02,5.0944E-02/
      DATA (KB(JT,44,10),JT=1,5) /
     &1.4822E-02,1.9377E-02,2.5087E-02,3.2083E-02,4.0842E-02/
      DATA (KB(JT,45,10),JT=1,5) /
     &1.1292E-02,1.4912E-02,1.9592E-02,2.5310E-02,3.2495E-02/
      DATA (KB(JT,46,10),JT=1,5) /
     &8.5215E-03,1.1374E-02,1.5134E-02,1.9829E-02,2.5701E-02/
      DATA (KB(JT,47,10),JT=1,5) /
     &6.3304E-03,8.5539E-03,1.1519E-02,1.5304E-02,2.0043E-02/
      DATA (KB(JT,48,10),JT=1,5) /
     &4.6596E-03,6.3842E-03,8.7184E-03,1.1727E-02,1.5575E-02/
      DATA (KB(JT,49,10),JT=1,5) /
     &3.3978E-03,4.7268E-03,6.5354E-03,8.9194E-03,1.1986E-02/
      DATA (KB(JT,50,10),JT=1,5) /
     &2.4889E-03,3.5204E-03,4.9247E-03,6.8240E-03,9.2921E-03/
      DATA (KB(JT,51,10),JT=1,5) /
     &1.8182E-03,2.6209E-03,3.7132E-03,5.2128E-03,7.2010E-03/
      DATA (KB(JT,52,10),JT=1,5) /
     &1.3186E-03,1.9376E-03,2.7823E-03,3.9639E-03,5.5462E-03/
      DATA (KB(JT,53,10),JT=1,5) /
     &9.4728E-04,1.4218E-03,2.0704E-03,2.9919E-03,4.2442E-03/
      DATA (KB(JT,54,10),JT=1,5) /
     &6.9069E-04,1.0561E-03,1.5627E-03,2.2955E-03,3.3049E-03/
      DATA (KB(JT,55,10),JT=1,5) /
     &5.0377E-04,7.8848E-04,1.1876E-03,1.7754E-03,2.5917E-03/
      DATA (KB(JT,56,10),JT=1,5) /
     &3.6627E-04,5.8682E-04,8.9763E-04,1.3649E-03,2.0311E-03/
      DATA (KB(JT,57,10),JT=1,5) /
     &2.6429E-04,4.3296E-04,6.7428E-04,1.0407E-03,1.5759E-03/
      DATA (KB(JT,58,10),JT=1,5) /
     &1.9120E-04,3.1987E-04,5.0621E-04,7.9436E-04,1.2215E-03/
      DATA (KB(JT,59,10),JT=1,5) /
     &1.5379E-04,2.5891E-04,4.1558E-04,6.6123E-04,1.0327E-03/
      DATA (KB(JT,13,11),JT=1,5) /
     &3.3861E+00,4.5598E+00,5.9909E+00,7.7387E+00,9.7720E+00/
      DATA (KB(JT,14,11),JT=1,5) /
     &3.0835E+00,4.1638E+00,5.4907E+00,7.0868E+00,8.8764E+00/
      DATA (KB(JT,15,11),JT=1,5) /
     &2.7946E+00,3.7805E+00,4.9918E+00,6.3780E+00,7.9256E+00/
      DATA (KB(JT,16,11),JT=1,5) /
     &2.5106E+00,3.4021E+00,4.4602E+00,5.6582E+00,7.0321E+00/
      DATA (KB(JT,17,11),JT=1,5) /
     &2.2366E+00,3.0111E+00,3.9217E+00,4.9755E+00,6.2040E+00/
      DATA (KB(JT,18,11),JT=1,5) /
     &1.9672E+00,2.6349E+00,3.4220E+00,4.3497E+00,5.4155E+00/
      DATA (KB(JT,19,11),JT=1,5) /
     &1.7131E+00,2.2896E+00,2.9754E+00,3.7775E+00,4.6830E+00/
      DATA (KB(JT,20,11),JT=1,5) /
     &1.4996E+00,1.9951E+00,2.5864E+00,3.2729E+00,4.0503E+00/
      DATA (KB(JT,21,11),JT=1,5) /
     &1.3113E+00,1.7407E+00,2.2502E+00,2.8371E+00,3.4967E+00/
      DATA (KB(JT,22,11),JT=1,5) /
     &1.1682E+00,1.5452E+00,1.9872E+00,2.4911E+00,3.0547E+00/
      DATA (KB(JT,23,11),JT=1,5) /
     &1.0421E+00,1.3707E+00,1.7516E+00,2.1846E+00,2.6659E+00/
      DATA (KB(JT,24,11),JT=1,5) /
     &9.2979E-01,1.2143E+00,1.5435E+00,1.9148E+00,2.3275E+00/
      DATA (KB(JT,25,11),JT=1,5) /
     &8.2875E-01,1.0753E+00,1.3588E+00,1.6784E+00,2.0353E+00/
      DATA (KB(JT,26,11),JT=1,5) /
     &7.3934E-01,9.5318E-01,1.1984E+00,1.4754E+00,1.7853E+00/
      DATA (KB(JT,27,11),JT=1,5) /
     &6.5883E-01,8.4429E-01,1.0568E+00,1.2987E+00,1.5650E+00/
      DATA (KB(JT,28,11),JT=1,5) /
     &5.8647E-01,7.4845E-01,9.3430E-01,1.1424E+00,1.3714E+00/
      DATA (KB(JT,29,11),JT=1,5) /
     &5.2333E-01,6.6481E-01,8.2647E-01,1.0068E+00,1.2071E+00/
      DATA (KB(JT,30,11),JT=1,5) /
     &4.6646E-01,5.9039E-01,7.3092E-01,8.8855E-01,1.0662E+00/
      DATA (KB(JT,31,11),JT=1,5) /
     &4.1617E-01,5.2426E-01,6.4699E-01,7.8730E-01,9.4645E-01/
      DATA (KB(JT,32,11),JT=1,5) /
     &3.7143E-01,4.6600E-01,5.7506E-01,6.9984E-01,8.4024E-01/
      DATA (KB(JT,33,11),JT=1,5) /
     &3.3164E-01,4.1539E-01,5.1227E-01,6.2282E-01,7.4734E-01/
      DATA (KB(JT,34,11),JT=1,5) /
     &2.9391E-01,3.6839E-01,4.5381E-01,5.5129E-01,6.6077E-01/
      DATA (KB(JT,35,11),JT=1,5) /
     &2.5539E-01,3.2000E-01,3.9467E-01,4.7981E-01,5.7557E-01/
      DATA (KB(JT,36,11),JT=1,5) /
     &2.1634E-01,2.7190E-01,3.3604E-01,4.0953E-01,4.9314E-01/
      DATA (KB(JT,37,11),JT=1,5) /
     &1.7643E-01,2.2324E-01,2.7784E-01,3.4019E-01,4.0996E-01/
      DATA (KB(JT,38,11),JT=1,5) /
     &1.4359E-01,1.8284E-01,2.2947E-01,2.8247E-01,3.3992E-01/
      DATA (KB(JT,39,11),JT=1,5) /
     &1.1703E-01,1.4999E-01,1.8946E-01,2.3346E-01,2.8235E-01/
      DATA (KB(JT,40,11),JT=1,5) /
     &9.2508E-02,1.1962E-01,1.5225E-01,1.8852E-01,2.3037E-01/
      DATA (KB(JT,41,11),JT=1,5) /
     &7.2812E-02,9.4920E-02,1.2149E-01,1.5155E-01,1.8718E-01/
      DATA (KB(JT,42,11),JT=1,5) /
     &5.7212E-02,7.5261E-02,9.6717E-02,1.2163E-01,1.5109E-01/
      DATA (KB(JT,43,11),JT=1,5) /
     &4.4118E-02,5.8641E-02,7.5812E-02,9.6186E-02,1.2035E-01/
      DATA (KB(JT,44,11),JT=1,5) /
     &3.3705E-02,4.5203E-02,5.8991E-02,7.5535E-02,9.5312E-02/
      DATA (KB(JT,45,11),JT=1,5) /
     &2.5795E-02,3.4826E-02,4.5764E-02,5.9102E-02,7.5973E-02/
      DATA (KB(JT,46,11),JT=1,5) /
     &1.9500E-02,2.6666E-02,3.5264E-02,4.5887E-02,6.0050E-02/
      DATA (KB(JT,47,11),JT=1,5) /
     &1.4478E-02,2.0069E-02,2.6758E-02,3.5119E-02,4.6750E-02/
      DATA (KB(JT,48,11),JT=1,5) /
     &1.0673E-02,1.5022E-02,2.0274E-02,2.6837E-02,3.6213E-02/
      DATA (KB(JT,49,11),JT=1,5) /
     &7.8044E-03,1.1183E-02,1.5301E-02,2.0457E-02,2.8037E-02/
      DATA (KB(JT,50,11),JT=1,5) /
     &5.7286E-03,8.3541E-03,1.1590E-02,1.5692E-02,2.1700E-02/
      DATA (KB(JT,51,11),JT=1,5) /
     &4.2038E-03,6.2320E-03,8.7867E-03,1.2044E-02,1.6737E-02/
      DATA (KB(JT,52,11),JT=1,5) /
     &3.0623E-03,4.6247E-03,6.6271E-03,9.2102E-03,1.2933E-02/
      DATA (KB(JT,53,11),JT=1,5) /
     &2.2163E-03,3.3976E-03,4.9642E-03,7.0028E-03,9.9664E-03/
      DATA (KB(JT,54,11),JT=1,5) /
     &1.6196E-03,2.5242E-03,3.7641E-03,5.3709E-03,7.7537E-03/
      DATA (KB(JT,55,11),JT=1,5) /
     &1.1913E-03,1.8900E-03,2.8670E-03,4.1465E-03,6.0719E-03/
      DATA (KB(JT,56,11),JT=1,5) /
     &8.6854E-04,1.4072E-03,2.1797E-03,3.2039E-03,4.7482E-03/
      DATA (KB(JT,57,11),JT=1,5) /
     &6.2940E-04,1.0423E-03,1.6521E-03,2.4738E-03,3.7243E-03/
      DATA (KB(JT,58,11),JT=1,5) /
     &4.5766E-04,7.7541E-04,1.2578E-03,1.9222E-03,2.9509E-03/
      DATA (KB(JT,59,11),JT=1,5) /
     &3.7158E-04,6.4512E-04,1.0666E-03,1.6673E-03,2.6085E-03/
      DATA (KB(JT,13,12),JT=1,5) /
     &6.8265E+00,9.1662E+00,1.2005E+01,1.5291E+01,1.9104E+01/
      DATA (KB(JT,14,12),JT=1,5) /
     &6.4505E+00,8.6663E+00,1.1302E+01,1.4372E+01,1.8022E+01/
      DATA (KB(JT,15,12),JT=1,5) /
     &6.0333E+00,8.0721E+00,1.0531E+01,1.3476E+01,1.6920E+01/
      DATA (KB(JT,16,12),JT=1,5) /
     &5.5683E+00,7.4562E+00,9.7508E+00,1.2490E+01,1.5606E+01/
      DATA (KB(JT,17,12),JT=1,5) /
     &5.0713E+00,6.8025E+00,8.9065E+00,1.1361E+01,1.4093E+01/
      DATA (KB(JT,18,12),JT=1,5) /
     &4.5774E+00,6.1450E+00,8.0133E+00,1.0144E+01,1.2548E+01/
      DATA (KB(JT,19,12),JT=1,5) /
     &4.0864E+00,5.4694E+00,7.0931E+00,8.9659E+00,1.1117E+01/
      DATA (KB(JT,20,12),JT=1,5) /
     &3.6294E+00,4.8248E+00,6.2421E+00,7.9048E+00,9.7882E+00/
      DATA (KB(JT,21,12),JT=1,5) /
     &3.1876E+00,4.2266E+00,5.4689E+00,6.9148E+00,8.5415E+00/
      DATA (KB(JT,22,12),JT=1,5) /
     &2.8446E+00,3.7580E+00,4.8472E+00,6.1036E+00,7.5044E+00/
      DATA (KB(JT,23,12),JT=1,5) /
     &2.5375E+00,3.3389E+00,4.2884E+00,5.3709E+00,6.5794E+00/
      DATA (KB(JT,24,12),JT=1,5) /
     &2.2687E+00,2.9742E+00,3.7979E+00,4.7327E+00,5.7691E+00/
      DATA (KB(JT,25,12),JT=1,5) /
     &2.0354E+00,2.6539E+00,3.3704E+00,4.1780E+00,5.0680E+00/
      DATA (KB(JT,26,12),JT=1,5) /
     &1.8347E+00,2.3795E+00,3.0035E+00,3.7009E+00,4.4678E+00/
      DATA (KB(JT,27,12),JT=1,5) /
     &1.6539E+00,2.1288E+00,2.6709E+00,3.2754E+00,3.9447E+00/
      DATA (KB(JT,28,12),JT=1,5) /
     &1.4848E+00,1.8995E+00,2.3700E+00,2.8962E+00,3.4805E+00/
      DATA (KB(JT,29,12),JT=1,5) /
     &1.3323E+00,1.6945E+00,2.1064E+00,2.5664E+00,3.0755E+00/
      DATA (KB(JT,30,12),JT=1,5) /
     &1.1951E+00,1.5124E+00,1.8729E+00,2.2771E+00,2.7207E+00/
      DATA (KB(JT,31,12),JT=1,5) /
     &1.0723E+00,1.3520E+00,1.6707E+00,2.0245E+00,2.4134E+00/
      DATA (KB(JT,32,12),JT=1,5) /
     &9.6436E-01,1.2123E+00,1.4924E+00,1.8027E+00,2.1488E+00/
      DATA (KB(JT,33,12),JT=1,5) /
     &8.6875E-01,1.0883E+00,1.3350E+00,1.6111E+00,1.9241E+00/
      DATA (KB(JT,34,12),JT=1,5) /
     &7.7744E-01,9.7074E-01,1.1897E+00,1.4382E+00,1.7216E+00/
      DATA (KB(JT,35,12),JT=1,5) /
     &6.8108E-01,8.5081E-01,1.0447E+00,1.2673E+00,1.5231E+00/
      DATA (KB(JT,36,12),JT=1,5) /
     &5.8251E-01,7.3036E-01,9.0117E-01,1.0985E+00,1.3262E+00/
      DATA (KB(JT,37,12),JT=1,5) /
     &4.8147E-01,6.0751E-01,7.5487E-01,9.2714E-01,1.1257E+00/
      DATA (KB(JT,38,12),JT=1,5) /
     &3.9749E-01,5.0467E-01,6.3154E-01,7.8124E-01,9.5438E-01/
      DATA (KB(JT,39,12),JT=1,5) /
     &3.2829E-01,4.1995E-01,5.2901E-01,6.5861E-01,8.0986E-01/
      DATA (KB(JT,40,12),JT=1,5) /
     &2.6399E-01,3.4098E-01,4.3333E-01,5.4338E-01,6.7333E-01/
      DATA (KB(JT,41,12),JT=1,5) /
     &2.1121E-01,2.7554E-01,3.5340E-01,4.4699E-01,5.5819E-01/
      DATA (KB(JT,42,12),JT=1,5) /
     &1.6875E-01,2.2242E-01,2.8790E-01,3.6718E-01,4.6248E-01/
      DATA (KB(JT,43,12),JT=1,5) /
     &1.3242E-01,1.7649E-01,2.3091E-01,2.9729E-01,3.7802E-01/
      DATA (KB(JT,44,12),JT=1,5) /
     &1.0268E-01,1.3874E-01,1.8350E-01,2.3873E-01,3.0615E-01/
      DATA (KB(JT,45,12),JT=1,5) /
     &7.9157E-02,1.0857E-01,1.4543E-01,1.9132E-01,2.4703E-01/
      DATA (KB(JT,46,12),JT=1,5) /
     &6.0349E-02,8.3945E-02,1.1412E-01,1.5200E-01,1.9783E-01/
      DATA (KB(JT,47,12),JT=1,5) /
     &4.5026E-02,6.3638E-02,8.7982E-02,1.1888E-01,1.5630E-01/
      DATA (KB(JT,48,12),JT=1,5) /
     &3.3400E-02,4.7982E-02,6.7403E-02,9.2494E-02,1.2316E-01/
      DATA (KB(JT,49,12),JT=1,5) /
     &2.4633E-02,3.5960E-02,5.1349E-02,7.1624E-02,9.6517E-02/
      DATA (KB(JT,50,12),JT=1,5) /
     &1.8199E-02,2.7006E-02,3.9181E-02,5.5479E-02,7.5913E-02/
      DATA (KB(JT,51,12),JT=1,5) /
     &1.3397E-02,2.0251E-02,2.9827E-02,4.2894E-02,5.9697E-02/
      DATA (KB(JT,52,12),JT=1,5) /
     &9.8047E-03,1.5092E-02,2.2613E-02,3.3016E-02,4.6660E-02/
      DATA (KB(JT,53,12),JT=1,5) /
     &7.1233E-03,1.1184E-02,1.7048E-02,2.5317E-02,3.6316E-02/
      DATA (KB(JT,54,12),JT=1,5) /
     &5.1904E-03,8.3108E-03,1.2872E-02,1.9462E-02,2.8342E-02/
      DATA (KB(JT,55,12),JT=1,5) /
     &3.7706E-03,6.1523E-03,9.6915E-03,1.4909E-02,2.2083E-02/
      DATA (KB(JT,56,12),JT=1,5) /
     &2.7214E-03,4.5313E-03,7.2581E-03,1.1344E-02,1.7112E-02/
      DATA (KB(JT,57,12),JT=1,5) /
     &1.9679E-03,3.3305E-03,5.4024E-03,8.5896E-03,1.3181E-02/
      DATA (KB(JT,58,12),JT=1,5) /
     &1.4312E-03,2.4830E-03,4.0992E-03,6.5707E-03,1.0148E-02/
      DATA (KB(JT,59,12),JT=1,5) /
     &1.1735E-03,2.0715E-03,3.4672E-03,5.6187E-03,8.6747E-03/
      DATA (KB(JT,13,13),JT=1,5) /
     &1.4965E+01,1.9939E+01,2.5957E+01,3.3111E+01,4.1486E+01/
      DATA (KB(JT,14,13),JT=1,5) /
     &1.4891E+01,1.9752E+01,2.5714E+01,3.2877E+01,4.1201E+01/
      DATA (KB(JT,15,13),JT=1,5) /
     &1.4632E+01,1.9464E+01,2.5349E+01,3.2327E+01,4.0239E+01/
      DATA (KB(JT,16,13),JT=1,5) /
     &1.4224E+01,1.8920E+01,2.4612E+01,3.1240E+01,3.8764E+01/
      DATA (KB(JT,17,13),JT=1,5) /
     &1.3596E+01,1.8071E+01,2.3399E+01,2.9603E+01,3.6827E+01/
      DATA (KB(JT,18,13),JT=1,5) /
     &1.2765E+01,1.6956E+01,2.1940E+01,2.7801E+01,3.4621E+01/
      DATA (KB(JT,19,13),JT=1,5) /
     &1.1845E+01,1.5708E+01,2.0355E+01,2.5828E+01,3.2043E+01/
      DATA (KB(JT,20,13),JT=1,5) /
     &1.0881E+01,1.4480E+01,1.8761E+01,2.3735E+01,2.9355E+01/
      DATA (KB(JT,21,13),JT=1,5) /
     &9.9388E+00,1.3181E+01,1.7060E+01,2.1504E+01,2.6520E+01/
      DATA (KB(JT,22,13),JT=1,5) /
     &9.1395E+00,1.2102E+01,1.5540E+01,1.9513E+01,2.4061E+01/
      DATA (KB(JT,23,13),JT=1,5) /
     &8.3446E+00,1.0972E+01,1.4055E+01,1.7623E+01,2.1727E+01/
      DATA (KB(JT,24,13),JT=1,5) /
     &7.5591E+00,9.8924E+00,1.2651E+01,1.5869E+01,1.9520E+01/
      DATA (KB(JT,25,13),JT=1,5) /
     &6.8143E+00,8.8970E+00,1.1359E+01,1.4218E+01,1.7424E+01/
      DATA (KB(JT,26,13),JT=1,5) /
     &6.1698E+00,8.0210E+00,1.0220E+01,1.2729E+01,1.5532E+01/
      DATA (KB(JT,27,13),JT=1,5) /
     &5.5728E+00,7.2306E+00,9.1639E+00,1.1369E+01,1.3833E+01/
      DATA (KB(JT,28,13),JT=1,5) /
     &5.0450E+00,6.5146E+00,8.2221E+00,1.0165E+01,1.2320E+01/
      DATA (KB(JT,29,13),JT=1,5) /
     &4.5820E+00,5.8856E+00,7.3962E+00,9.1032E+00,1.0999E+01/
      DATA (KB(JT,30,13),JT=1,5) /
     &4.1619E+00,5.3258E+00,6.6581E+00,8.1640E+00,9.8348E+00/
      DATA (KB(JT,31,13),JT=1,5) /
     &3.7986E+00,4.8336E+00,6.0169E+00,7.3498E+00,8.8372E+00/
      DATA (KB(JT,32,13),JT=1,5) /
     &3.4747E+00,4.3988E+00,5.4556E+00,6.6497E+00,7.9860E+00/
      DATA (KB(JT,33,13),JT=1,5) /
     &3.1806E+00,4.0134E+00,4.9644E+00,6.0424E+00,7.2445E+00/
      DATA (KB(JT,34,13),JT=1,5) /
     &2.8901E+00,3.6383E+00,4.4979E+00,5.4687E+00,6.5591E+00/
      DATA (KB(JT,35,13),JT=1,5) /
     &2.5701E+00,3.2361E+00,4.0067E+00,4.8794E+00,5.8576E+00/
      DATA (KB(JT,36,13),JT=1,5) /
     &2.2323E+00,2.8199E+00,3.4998E+00,4.2791E+00,5.1575E+00/
      DATA (KB(JT,37,13),JT=1,5) /
     &1.8736E+00,2.3827E+00,2.9738E+00,3.6564E+00,4.4360E+00/
      DATA (KB(JT,38,13),JT=1,5) /
     &1.5728E+00,2.0148E+00,2.5311E+00,3.1303E+00,3.8226E+00/
      DATA (KB(JT,39,13),JT=1,5) /
     &1.3237E+00,1.7072E+00,2.1603E+00,2.6914E+00,3.3072E+00/
      DATA (KB(JT,40,13),JT=1,5) /
     &1.0847E+00,1.4132E+00,1.8059E+00,2.2702E+00,2.8143E+00/
      DATA (KB(JT,41,13),JT=1,5) /
     &8.8581E-01,1.1668E+00,1.5064E+00,1.9133E+00,2.3935E+00/
      DATA (KB(JT,42,13),JT=1,5) /
     &7.2374E-01,9.6367E-01,1.2577E+00,1.6144E+00,2.0403E+00/
      DATA (KB(JT,43,13),JT=1,5) /
     &5.8123E-01,7.8367E-01,1.0353E+00,1.3440E+00,1.7177E+00/
      DATA (KB(JT,44,13),JT=1,5) /
     &4.6198E-01,6.3195E-01,8.4539E-01,1.1117E+00,1.4376E+00/
      DATA (KB(JT,45,13),JT=1,5) /
     &3.6584E-01,5.0822E-01,6.8932E-01,9.1864E-01,1.2028E+00/
      DATA (KB(JT,46,13),JT=1,5) /
     &2.8644E-01,4.0442E-01,5.5738E-01,7.5306E-01,9.9957E-01/
      DATA (KB(JT,47,13),JT=1,5) /
     &2.1956E-01,3.1585E-01,4.4303E-01,6.0814E-01,8.1897E-01/
      DATA (KB(JT,48,13),JT=1,5) /
     &1.6674E-01,2.4495E-01,3.5019E-01,4.8911E-01,6.6858E-01/
      DATA (KB(JT,49,13),JT=1,5) /
     &1.2553E-01,1.8856E-01,2.7515E-01,3.9103E-01,5.4421E-01/
      DATA (KB(JT,50,13),JT=1,5) /
     &9.4665E-02,1.4544E-01,2.1677E-01,3.1374E-01,4.4454E-01/
      DATA (KB(JT,51,13),JT=1,5) /
     &7.1191E-02,1.1194E-01,1.7036E-01,2.5168E-01,3.6277E-01/
      DATA (KB(JT,52,13),JT=1,5) /
     &5.3052E-02,8.5501E-02,1.3304E-01,2.0087E-01,2.9517E-01/
      DATA (KB(JT,53,13),JT=1,5) /
     &3.9132E-02,6.4715E-02,1.0314E-01,1.5924E-01,2.3881E-01/
      DATA (KB(JT,54,13),JT=1,5) /
     &2.9043E-02,4.9273E-02,8.0552E-02,1.2707E-01,1.9473E-01/
      DATA (KB(JT,55,13),JT=1,5) /
     &2.1525E-02,3.7498E-02,6.2875E-02,1.0150E-01,1.5889E-01/
      DATA (KB(JT,56,13),JT=1,5) /
     &1.5833E-02,2.8322E-02,4.8765E-02,8.0651E-02,1.2905E-01/
      DATA (KB(JT,57,13),JT=1,5) /
     &1.1526E-02,2.1205E-02,3.7510E-02,6.3651E-02,1.0431E-01/
      DATA (KB(JT,58,13),JT=1,5) /
     &8.3779E-03,1.5855E-02,2.8776E-02,5.0260E-02,8.4604E-02/
      DATA (KB(JT,59,13),JT=1,5) /
     &6.7851E-03,1.3119E-02,2.4293E-02,4.3321E-02,7.4531E-02/
      DATA (KB(JT,13,14),JT=1,5) /
     &3.3721E+01,4.7002E+01,6.3302E+01,8.2327E+01,1.0363E+02/
      DATA (KB(JT,14,14),JT=1,5) /
     &3.6911E+01,5.0874E+01,6.7511E+01,8.6774E+01,1.0872E+02/
      DATA (KB(JT,15,14),JT=1,5) /
     &3.9962E+01,5.4067E+01,7.0780E+01,9.0289E+01,1.1312E+02/
      DATA (KB(JT,16,14),JT=1,5) /
     &4.2338E+01,5.6683E+01,7.3332E+01,9.3095E+01,1.1626E+02/
      DATA (KB(JT,17,14),JT=1,5) /
     &4.3916E+01,5.8217E+01,7.5023E+01,9.4925E+01,1.1793E+02/
      DATA (KB(JT,18,14),JT=1,5) /
     &4.4576E+01,5.8845E+01,7.5702E+01,9.5514E+01,1.1830E+02/
      DATA (KB(JT,19,14),JT=1,5) /
     &4.4328E+01,5.8466E+01,7.5196E+01,9.4726E+01,1.1748E+02/
      DATA (KB(JT,20,14),JT=1,5) /
     &4.3798E+01,5.7631E+01,7.4169E+01,9.3518E+01,1.1584E+02/
      DATA (KB(JT,21,14),JT=1,5) /
     &4.2847E+01,5.6429E+01,7.2627E+01,9.1567E+01,1.1316E+02/
      DATA (KB(JT,22,14),JT=1,5) /
     &4.2232E+01,5.5705E+01,7.1694E+01,9.0118E+01,1.1101E+02/
      DATA (KB(JT,23,14),JT=1,5) /
     &4.1301E+01,5.4371E+01,6.9797E+01,8.7676E+01,1.0772E+02/
      DATA (KB(JT,24,14),JT=1,5) /
     &4.0036E+01,5.2522E+01,6.7301E+01,8.4384E+01,1.0387E+02/
      DATA (KB(JT,25,14),JT=1,5) /
     &3.8535E+01,5.0451E+01,6.4572E+01,8.0891E+01,9.9814E+01/
      DATA (KB(JT,26,14),JT=1,5) /
     &3.6990E+01,4.8476E+01,6.1896E+01,7.7604E+01,9.5632E+01/
      DATA (KB(JT,27,14),JT=1,5) /
     &3.5439E+01,4.6349E+01,5.9201E+01,7.4166E+01,9.1237E+01/
      DATA (KB(JT,28,14),JT=1,5) /
     &3.3799E+01,4.4185E+01,5.6512E+01,7.0702E+01,8.6988E+01/
      DATA (KB(JT,29,14),JT=1,5) /
     &3.2225E+01,4.2139E+01,5.3908E+01,6.7503E+01,8.3109E+01/
      DATA (KB(JT,30,14),JT=1,5) /
     &3.0748E+01,4.0218E+01,5.1459E+01,6.4621E+01,7.9612E+01/
      DATA (KB(JT,31,14),JT=1,5) /
     &2.9425E+01,3.8499E+01,4.9352E+01,6.2118E+01,7.6745E+01/
      DATA (KB(JT,32,14),JT=1,5) /
     &2.8242E+01,3.7039E+01,4.7648E+01,6.0092E+01,7.4536E+01/
      DATA (KB(JT,33,14),JT=1,5) /
     &2.7263E+01,3.5883E+01,4.6290E+01,5.8616E+01,7.3025E+01/
      DATA (KB(JT,34,14),JT=1,5) /
     &2.6245E+01,3.4728E+01,4.4963E+01,5.7211E+01,7.1614E+01/
      DATA (KB(JT,35,14),JT=1,5) /
     &2.4792E+01,3.3010E+01,4.3016E+01,5.5082E+01,6.9332E+01/
      DATA (KB(JT,36,14),JT=1,5) /
     &2.2854E+01,3.0681E+01,4.0335E+01,5.2076E+01,6.5971E+01/
      DATA (KB(JT,37,14),JT=1,5) /
     &2.0215E+01,2.7477E+01,3.6561E+01,4.7698E+01,6.0990E+01/
      DATA (KB(JT,38,14),JT=1,5) /
     &1.7901E+01,2.4657E+01,3.3200E+01,4.3777E+01,5.6518E+01/
      DATA (KB(JT,39,14),JT=1,5) /
     &1.5916E+01,2.2229E+01,3.0285E+01,4.0352E+01,5.2594E+01/
      DATA (KB(JT,40,14),JT=1,5) /
     &1.3687E+01,1.9453E+01,2.6865E+01,3.6273E+01,4.7801E+01/
      DATA (KB(JT,41,14),JT=1,5) /
     &1.1706E+01,1.6957E+01,2.3775E+01,3.2529E+01,4.3345E+01/
      DATA (KB(JT,42,14),JT=1,5) /
     &1.0015E+01,1.4777E+01,2.1056E+01,2.9181E+01,3.9336E+01/
      DATA (KB(JT,43,14),JT=1,5) /
     &8.3602E+00,1.2595E+01,1.8289E+01,2.5700E+01,3.5139E+01/
      DATA (KB(JT,44,14),JT=1,5) /
     &6.8842E+00,1.0588E+01,1.5702E+01,2.2421E+01,3.1090E+01/
      DATA (KB(JT,45,14),JT=1,5) /
     &5.6505E+00,8.8697E+00,1.3428E+01,1.9525E+01,2.7445E+01/
      DATA (KB(JT,46,14),JT=1,5) /
     &4.5669E+00,7.3282E+00,1.1331E+01,1.6810E+01,2.3987E+01/
      DATA (KB(JT,47,14),JT=1,5) /
     &3.5910E+00,5.9011E+00,9.3338E+00,1.4162E+01,2.0590E+01/
      DATA (KB(JT,48,14),JT=1,5) /
     &2.8046E+00,4.7156E+00,7.6334E+00,1.1848E+01,1.7577E+01/
      DATA (KB(JT,49,14),JT=1,5) /
     &2.1748E+00,3.7383E+00,6.1955E+00,9.8356E+00,1.4909E+01/
      DATA (KB(JT,50,14),JT=1,5) /
     &1.6968E+00,2.9824E+00,5.0552E+00,8.1970E+00,1.2692E+01/
      DATA (KB(JT,51,14),JT=1,5) /
     &1.3228E+00,2.3793E+00,4.1196E+00,6.8244E+00,1.0784E+01/
      DATA (KB(JT,52,14),JT=1,5) /
     &1.0245E+00,1.8865E+00,3.3355E+00,5.6478E+00,9.1028E+00/
      DATA (KB(JT,53,14),JT=1,5) /
     &7.8728E-01,1.4840E+00,2.6816E+00,4.6391E+00,7.6341E+00/
      DATA (KB(JT,54,14),JT=1,5) /
     &6.1018E-01,1.1815E+00,2.1812E+00,3.8474E+00,6.4584E+00/
      DATA (KB(JT,55,14),JT=1,5) /
     &4.7246E-01,9.4354E-01,1.7799E+00,3.1974E+00,5.4714E+00/
      DATA (KB(JT,56,14),JT=1,5) /
     &3.6268E-01,7.4897E-01,1.4435E+00,2.6438E+00,4.6110E+00/
      DATA (KB(JT,57,14),JT=1,5) /
     &2.7617E-01,5.8818E-01,1.1638E+00,2.1763E+00,3.8632E+00/
      DATA (KB(JT,58,14),JT=1,5) /
     &2.1026E-01,4.6281E-01,9.4334E-01,1.8002E+00,3.2506E+00/
      DATA (KB(JT,59,14),JT=1,5) /
     &1.8510E-01,4.1578E-01,8.6198E-01,1.6609E+00,3.0231E+00/
      DATA (KB(JT,13,15),JT=1,5) /
     &7.9497E+01,1.0631E+02,1.3951E+02,1.8076E+02,2.3534E+02/
      DATA (KB(JT,14,15),JT=1,5) /
     &9.0008E+01,1.2102E+02,1.6070E+02,2.0844E+02,2.6891E+02/
      DATA (KB(JT,15,15),JT=1,5) /
     &1.0142E+02,1.3773E+02,1.8424E+02,2.3942E+02,3.0596E+02/
      DATA (KB(JT,16,15),JT=1,5) /
     &1.1444E+02,1.5595E+02,2.0951E+02,2.7261E+02,3.4599E+02/
      DATA (KB(JT,17,15),JT=1,5) /
     &1.2871E+02,1.7599E+02,2.3611E+02,3.0737E+02,3.8849E+02/
      DATA (KB(JT,18,15),JT=1,5) /
     &1.4444E+02,1.9729E+02,2.6334E+02,3.4204E+02,4.3103E+02/
      DATA (KB(JT,19,15),JT=1,5) /
     &1.6121E+02,2.1913E+02,2.9095E+02,3.7632E+02,4.7170E+02/
      DATA (KB(JT,20,15),JT=1,5) /
     &1.7880E+02,2.4196E+02,3.1956E+02,4.1027E+02,5.1312E+02/
      DATA (KB(JT,21,15),JT=1,5) /
     &1.9582E+02,2.6409E+02,3.4675E+02,4.4276E+02,5.5264E+02/
      DATA (KB(JT,22,15),JT=1,5) /
     &2.1631E+02,2.9018E+02,3.7825E+02,4.8067E+02,5.9651E+02/
      DATA (KB(JT,23,15),JT=1,5) /
     &2.3693E+02,3.1638E+02,4.0986E+02,5.1726E+02,6.3877E+02/
      DATA (KB(JT,24,15),JT=1,5) /
     &2.5815E+02,3.4252E+02,4.4099E+02,5.5343E+02,6.7985E+02/
      DATA (KB(JT,25,15),JT=1,5) /
     &2.7940E+02,3.6830E+02,4.7141E+02,5.8880E+02,7.2036E+02/
      DATA (KB(JT,26,15),JT=1,5) /
     &3.0147E+02,3.9459E+02,5.0246E+02,6.2482E+02,7.6276E+02/
      DATA (KB(JT,27,15),JT=1,5) /
     &3.2318E+02,4.2065E+02,5.3313E+02,6.6087E+02,8.0529E+02/
      DATA (KB(JT,28,15),JT=1,5) /
     &3.4508E+02,4.4657E+02,5.6379E+02,6.9725E+02,8.4792E+02/
      DATA (KB(JT,29,15),JT=1,5) /
     &3.6777E+02,4.7381E+02,5.9626E+02,7.3554E+02,8.9251E+02/
      DATA (KB(JT,30,15),JT=1,5) /
     &3.9103E+02,5.0185E+02,6.2997E+02,7.7485E+02,9.3819E+02/
      DATA (KB(JT,31,15),JT=1,5) /
     &4.1560E+02,5.3166E+02,6.6523E+02,8.1615E+02,9.8559E+02/
      DATA (KB(JT,32,15),JT=1,5) /
     &4.4194E+02,5.6341E+02,7.0244E+02,8.5957E+02,1.0345E+03/
      DATA (KB(JT,33,15),JT=1,5) /
     &4.7004E+02,5.9690E+02,7.4161E+02,9.0465E+02,1.0849E+03/
      DATA (KB(JT,34,15),JT=1,5) /
     &4.9560E+02,6.2720E+02,7.7702E+02,9.4526E+02,1.1301E+03/
      DATA (KB(JT,35,15),JT=1,5) /
     &5.1020E+02,6.4498E+02,7.9798E+02,9.6921E+02,1.1571E+03/
      DATA (KB(JT,36,15),JT=1,5) /
     &5.1153E+02,6.4732E+02,8.0146E+02,9.7374E+02,1.1629E+03/
      DATA (KB(JT,37,15),JT=1,5) /
     &4.9411E+02,6.2784E+02,7.8019E+02,9.5084E+02,1.1384E+03/
      DATA (KB(JT,38,15),JT=1,5) /
     &4.7607E+02,6.0738E+02,7.5785E+02,9.2634E+02,1.1122E+03/
      DATA (KB(JT,39,15),JT=1,5) /
     &4.5860E+02,5.8729E+02,7.3571E+02,9.0212E+02,1.0835E+03/
      DATA (KB(JT,40,15),JT=1,5) /
     &4.2990E+02,5.5385E+02,6.9803E+02,8.6039E+02,1.0406E+03/
      DATA (KB(JT,41,15),JT=1,5) /
     &4.0087E+02,5.1992E+02,6.5921E+02,8.1732E+02,9.9347E+02/
      DATA (KB(JT,42,15),JT=1,5) /
     &3.7298E+02,4.8724E+02,6.2146E+02,7.7537E+02,9.4699E+02/
      DATA (KB(JT,43,15),JT=1,5) /
     &3.4053E+02,4.4909E+02,5.7712E+02,7.2520E+02,8.9154E+02/
      DATA (KB(JT,44,15),JT=1,5) /
     &3.0753E+02,4.1020E+02,5.3144E+02,6.7302E+02,8.3358E+02/
      DATA (KB(JT,45,15),JT=1,5) /
     &2.7654E+02,3.7323E+02,4.8808E+02,6.2285E+02,7.7741E+02/
      DATA (KB(JT,46,15),JT=1,5) /
     &2.4531E+02,3.3622E+02,4.4437E+02,5.7189E+02,7.1969E+02/
      DATA (KB(JT,47,15),JT=1,5) /
     &2.1302E+02,2.9761E+02,3.9853E+02,5.1809E+02,6.5783E+02/
      DATA (KB(JT,48,15),JT=1,5) /
     &1.8355E+02,2.6147E+02,3.5562E+02,4.6754E+02,5.9909E+02/
      DATA (KB(JT,49,15),JT=1,5) /
     &1.5701E+02,2.2791E+02,3.1569E+02,4.2021E+02,5.4365E+02/
      DATA (KB(JT,50,15),JT=1,5) /
     &1.3468E+02,1.9893E+02,2.8071E+02,3.7858E+02,4.9472E+02/
      DATA (KB(JT,51,15),JT=1,5) /
     &1.1526E+02,1.7331E+02,2.4880E+02,3.4068E+02,4.5000E+02/
      DATA (KB(JT,52,15),JT=1,5) /
     &9.7991E+01,1.5012E+02,2.1915E+02,3.0532E+02,4.0798E+02/
      DATA (KB(JT,53,15),JT=1,5) /
     &8.2622E+01,1.2914E+02,1.9179E+02,2.7194E+02,3.6825E+02/
      DATA (KB(JT,54,15),JT=1,5) /
     &7.0111E+01,1.1182E+02,1.6882E+02,2.4316E+02,3.3408E+02/
      DATA (KB(JT,55,15),JT=1,5) /
     &5.9451E+01,9.6898E+01,1.4869E+02,2.1737E+02,3.0323E+02/
      DATA (KB(JT,56,15),JT=1,5) /
     &4.9982E+01,8.3446E+01,1.3033E+02,1.9338E+02,2.7397E+02/
      DATA (KB(JT,57,15),JT=1,5) /
     &4.1621E+01,7.1384E+01,1.1363E+02,1.7127E+02,2.4633E+02/
      DATA (KB(JT,58,15),JT=1,5) /
     &3.4650E+01,6.1162E+01,9.9313E+01,1.5200E+02,2.2168E+02/
      DATA (KB(JT,59,15),JT=1,5) /
     &3.2067E+01,5.7347E+01,9.3961E+01,1.4472E+02,2.1224E+02/
      DATA (KB(JT,13,16),JT=1,5) /
     &1.4292E+02,1.7830E+02,2.5018E+02,3.7037E+02,5.2070E+02/
      DATA (KB(JT,14,16),JT=1,5) /
     &1.7229E+02,2.1935E+02,3.0306E+02,4.4388E+02,6.2020E+02/
      DATA (KB(JT,15,16),JT=1,5) /
     &2.0873E+02,2.6972E+02,3.6756E+02,5.2712E+02,7.3393E+02/
      DATA (KB(JT,16,16),JT=1,5) /
     &2.5439E+02,3.3072E+02,4.4570E+02,6.2226E+02,8.6517E+02/
      DATA (KB(JT,17,16),JT=1,5) /
     &3.0902E+02,4.0145E+02,5.3763E+02,7.3415E+02,1.0082E+03/
      DATA (KB(JT,18,16),JT=1,5) /
     &3.7239E+02,4.8343E+02,6.4354E+02,8.6401E+02,1.1697E+03/
      DATA (KB(JT,19,16),JT=1,5) /
     &4.4344E+02,5.7744E+02,7.6245E+02,1.0126E+03,1.3544E+03/
      DATA (KB(JT,20,16),JT=1,5) /
     &5.2591E+02,6.8473E+02,8.9843E+02,1.1879E+03,1.5662E+03/
      DATA (KB(JT,21,16),JT=1,5) /
     &6.1975E+02,8.0389E+02,1.0527E+03,1.3850E+03,1.8066E+03/
      DATA (KB(JT,22,16),JT=1,5) /
     &7.3890E+02,9.5515E+02,1.2474E+03,1.6302E+03,2.1130E+03/
      DATA (KB(JT,23,16),JT=1,5) /
     &8.7503E+02,1.1289E+03,1.4705E+03,1.9102E+03,2.4554E+03/
      DATA (KB(JT,24,16),JT=1,5) /
     &1.0277E+03,1.3283E+03,1.7241E+03,2.2247E+03,2.8319E+03/
      DATA (KB(JT,25,16),JT=1,5) /
     &1.2034E+03,1.5543E+03,2.0073E+03,2.5693E+03,3.2356E+03/
      DATA (KB(JT,26,16),JT=1,5) /
     &1.4042E+03,1.8088E+03,2.3218E+03,2.9229E+03,3.6714E+03/
      DATA (KB(JT,27,16),JT=1,5) /
     &1.6234E+03,2.0833E+03,2.6544E+03,3.3382E+03,4.1196E+03/
      DATA (KB(JT,28,16),JT=1,5) /
     &1.8563E+03,2.3730E+03,3.0002E+03,3.7388E+03,4.5730E+03/
      DATA (KB(JT,29,16),JT=1,5) /
     &2.1060E+03,2.6609E+03,3.3576E+03,4.1487E+03,5.0295E+03/
      DATA (KB(JT,30,16),JT=1,5) /
     &2.3669E+03,2.9882E+03,3.7190E+03,4.5573E+03,5.4823E+03/
      DATA (KB(JT,31,16),JT=1,5) /
     &2.6382E+03,3.3079E+03,4.0851E+03,4.9669E+03,5.9326E+03/
      DATA (KB(JT,32,16),JT=1,5) /
     &2.9162E+03,3.6311E+03,4.4535E+03,5.3188E+03,6.3774E+03/
      DATA (KB(JT,33,16),JT=1,5) /
     &3.1977E+03,3.9546E+03,4.8182E+03,5.7741E+03,6.8136E+03/
      DATA (KB(JT,34,16),JT=1,5) /
     &3.4540E+03,4.2467E+03,5.1445E+03,6.1305E+03,7.1986E+03/
      DATA (KB(JT,35,16),JT=1,5) /
     &3.6329E+03,4.4502E+03,5.3698E+03,6.3759E+03,7.4635E+03/
      DATA (KB(JT,36,16),JT=1,5) /
     &3.7190E+03,4.5470E+03,5.4751E+03,6.4918E+03,7.5883E+03/
      DATA (KB(JT,37,16),JT=1,5) /
     &3.6766E+03,4.4979E+03,5.4194E+03,6.4326E+03,7.5253E+03/
      DATA (KB(JT,38,16),JT=1,5) /
     &3.6175E+03,4.4311E+03,5.3444E+03,6.3514E+03,7.4384E+03/
      DATA (KB(JT,39,16),JT=1,5) /
     &3.5511E+03,4.3577E+03,5.2603E+03,6.2593E+03,7.3011E+03/
      DATA (KB(JT,40,16),JT=1,5) /
     &3.4038E+03,4.1899E+03,5.0730E+03,6.0546E+03,7.1202E+03/
      DATA (KB(JT,41,16),JT=1,5) /
     &3.2449E+03,4.0090E+03,4.8718E+03,5.8306E+03,6.8794E+03/
      DATA (KB(JT,42,16),JT=1,5) /
     &3.0878E+03,3.8270E+03,4.6679E+03,5.6043E+03,6.6342E+03/
      DATA (KB(JT,43,16),JT=1,5) /
     &2.8974E+03,3.6038E+03,4.4171E+03,5.3250E+03,6.3295E+03/
      DATA (KB(JT,44,16),JT=1,5) /
     &2.6963E+03,3.3670E+03,4.1477E+03,5.0263E+03,5.9993E+03/
      DATA (KB(JT,45,16),JT=1,5) /
     &2.5060E+03,3.1396E+03,3.8862E+03,4.7337E+03,5.6766E+03/
      DATA (KB(JT,46,16),JT=1,5) /
     &2.3164E+03,2.9079E+03,3.6158E+03,4.4299E+03,5.3398E+03/
      DATA (KB(JT,47,16),JT=1,5) /
     &2.1174E+03,2.6621E+03,3.3261E+03,4.0998E+03,4.9727E+03/
      DATA (KB(JT,48,16),JT=1,5) /
     &1.9329E+03,2.4347E+03,3.0518E+03,3.7834E+03,4.6186E+03/
      DATA (KB(JT,49,16),JT=1,5) /
     &1.7595E+03,2.2251E+03,2.7943E+03,3.4811E+03,4.2776E+03/
      DATA (KB(JT,50,16),JT=1,5) /
     &1.6082E+03,2.0431E+03,2.5690E+03,3.2137E+03,3.9707E+03/
      DATA (KB(JT,51,16),JT=1,5) /
     &1.4710E+03,1.8773E+03,2.3673E+03,2.9684E+03,3.6854E+03/
      DATA (KB(JT,52,16),JT=1,5) /
     &1.3426E+03,1.7222E+03,2.1800E+03,2.7371E+03,3.4141E+03/
      DATA (KB(JT,53,16),JT=1,5) /
     &1.2224E+03,1.5765E+03,2.0045E+03,2.5219E+03,3.1562E+03/
      DATA (KB(JT,54,16),JT=1,5) /
     &1.1196E+03,1.4516E+03,1.8541E+03,2.3387E+03,2.9325E+03/
      DATA (KB(JT,55,16),JT=1,5) /
     &1.0267E+03,1.3387E+03,1.7175E+03,2.1745E+03,2.7302E+03/
      DATA (KB(JT,56,16),JT=1,5) /
     &9.3987E+02,1.2326E+03,1.5894E+03,2.0202E+03,2.5405E+03/
      DATA (KB(JT,57,16),JT=1,5) /
     &8.5792E+02,1.1333E+03,1.4474E+03,1.8742E+03,2.3631E+03/
      DATA (KB(JT,58,16),JT=1,5) /
     &7.8443E+02,1.0443E+03,1.3605E+03,1.7435E+03,2.2055E+03/
      DATA (KB(JT,59,16),JT=1,5) /
     &7.5656E+02,1.0103E+03,1.3189E+03,1.6936E+03,2.1455E+03/

C     The array FORREF contains the coefficient of the water vapor
C     foreign-continuum (including the energy term).  The first 
C     index refers to reference temperature (296,260,224,260) and 
C     pressure (970,475,219,3 mbar) levels.  The second index 
C     runs over the g-channel (1 to 16).

      DATA (FORREF(1,IG),IG=1,16) /
     &2.8549e-03,4.8281e-03,6.2570e-03,8.2731e-03,7.9056e-03,7.7840e-03,
     &1.0115e-02,9.6599e-03,1.0153e-02,1.0921e-02,1.2408e-02,1.3496e-02,
     &1.5059e-02,1.4636e-02,1.6483e-02,1.2394e-02/
      DATA (FORREF(2,IG),IG=1,16) /
     &3.0036e-03,5.1093e-03,5.7317e-03,9.2246e-03,8.9829e-03,8.6477e-03,
     &1.1448e-02,1.0391e-02,1.0211e-02,1.2921e-02,1.2726e-02,1.2426e-02,
     &1.4609e-02,1.5783e-02,1.6617e-02,1.6858e-02/
      DATA (FORREF(3,IG),IG=1,16) /
     &3.0771e-03,5.1206e-03,5.8426e-03,9.5727e-03,1.0338e-02,9.3737e-03,
     &1.2805e-02,1.1272e-02,1.1353e-02,1.1837e-02,1.1550e-02,1.3020e-02,
     &1.3536e-02,1.6226e-02,1.6039e-02,2.2578e-02/
      DATA (FORREF(4,IG),IG=1,16) /
     &3.3072e-03,5.0240e-03,6.8474e-03,8.2736e-03,8.6151e-03,8.6762e-03,
     &1.1476e-02,1.0246e-02,1.0819e-02,1.0640e-02,1.0545e-02,1.0533e-02,
     &1.0496e-02,1.0142e-02,9.7979e-03,1.5255e-02/

C     The array SELFREF contains the coefficient of the water vapor
C     self-continuum (including the energy term).  The first index
C     refers to temperature in 7.2 degree increments.  For instance,
C     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
C     etc.  The second index runs over the g-channel (1 to 16).

      DATA (SELFREF(JT, 1),JT=1,10)  /
     & 7.25695e-01, 6.53591e-01, 5.88650e-01, 5.30162e-01, 4.77485e-01,
     & 4.30042e-01, 3.87313e-01, 3.48830e-01, 3.14170e-01, 2.82954e-01/
      DATA (SELFREF(JT, 2),JT=1,10)  /
     & 9.61996e-01, 8.77853e-01, 8.01070e-01, 7.31003e-01, 6.67064e-01,
     & 6.08718e-01, 5.55476e-01, 5.06890e-01, 4.62554e-01, 4.22096e-01/
      DATA (SELFREF(JT, 3),JT=1,10)  /
     & 9.72584e-01, 9.02658e-01, 8.37760e-01, 7.77527e-01, 7.21626e-01,
     & 6.69743e-01, 6.21591e-01, 5.76900e-01, 5.35423e-01, 4.96927e-01/
      DATA (SELFREF(JT, 4),JT=1,10)  /
     & 1.24790e+00, 1.14353e+00, 1.04790e+00, 9.60263e-01, 8.79956e-01,
     & 8.06364e-01, 7.38927e-01, 6.77130e-01, 6.20501e-01, 5.68608e-01/
      DATA (SELFREF(JT, 5),JT=1,10)  /
     & 1.23574e+00, 1.12928e+00, 1.03200e+00, 9.43096e-01, 8.61851e-01,
     & 7.87605e-01, 7.19755e-01, 6.57750e-01, 6.01087e-01, 5.49305e-01/
      DATA (SELFREF(JT, 6),JT=1,10)  /
     & 1.20921e+00, 1.10660e+00, 1.01270e+00, 9.26766e-01, 8.48124e-01,
     & 7.76155e-01, 7.10293e-01, 6.50020e-01, 5.94861e-01, 5.44384e-01/
      DATA (SELFREF(JT, 7),JT=1,10)  /
     & 1.38112e+00, 1.26727e+00, 1.16280e+00, 1.06694e+00, 9.78990e-01,
     & 8.98287e-01, 8.24236e-01, 7.56290e-01, 6.93945e-01, 6.36739e-01/
      DATA (SELFREF(JT, 8),JT=1,10)  /
     & 1.30321e+00, 1.20127e+00, 1.10730e+00, 1.02068e+00, 9.40840e-01,
     & 8.67243e-01, 7.99403e-01, 7.36870e-01, 6.79229e-01, 6.26096e-01/
      DATA (SELFREF(JT, 9),JT=1,10)  /
     & 1.26713e+00, 1.17927e+00, 1.09750e+00, 1.02140e+00, 9.50575e-01,
     & 8.84662e-01, 8.23319e-01, 7.66230e-01, 7.13099e-01, 6.63653e-01/
      DATA (SELFREF(JT,10),JT=1,10)  /
     & 1.49824e+00, 1.37053e+00, 1.25370e+00, 1.14683e+00, 1.04908e+00,
     & 9.59651e-01, 8.77849e-01, 8.03020e-01, 7.34569e-01, 6.71954e-01/
      DATA (SELFREF(JT,11),JT=1,10)  /
     & 1.44786e+00, 1.34594e+00, 1.25120e+00, 1.16313e+00, 1.08125e+00,
     & 1.00514e+00, 9.34392e-01, 8.68620e-01, 8.07477e-01, 7.50639e-01/
      DATA (SELFREF(JT,12),JT=1,10)  /
     & 1.38460e+00, 1.30437e+00, 1.22880e+00, 1.15760e+00, 1.09053e+00,
     & 1.02735e+00, 9.67825e-01, 9.11750e-01, 8.58924e-01, 8.09159e-01/
      DATA (SELFREF(JT,13),JT=1,10)  /
     & 1.51953e+00, 1.42822e+00, 1.34240e+00, 1.26173e+00, 1.18592e+00,
     & 1.11465e+00, 1.04768e+00, 9.84720e-01, 9.25548e-01, 8.69932e-01/
      DATA (SELFREF(JT,14),JT=1,10)  /
     & 1.62608e+00, 1.51021e+00, 1.40260e+00, 1.30266e+00, 1.20983e+00,
     & 1.12363e+00, 1.04356e+00, 9.69200e-01, 9.00138e-01, 8.35998e-01/
      DATA (SELFREF(JT,15),JT=1,10)  /
     & 1.65383e+00, 1.54808e+00, 1.44910e+00, 1.35644e+00, 1.26971e+00,
     & 1.18853e+00, 1.11254e+00, 1.04140e+00, 9.74813e-01, 9.12484e-01/
      DATA (SELFREF(JT,16),JT=1,10)  /
     & 1.78105e+00, 1.61421e+00, 1.46300e+00, 1.32595e+00, 1.20174e+00,
     & 1.08917e+00, 9.87141e-01, 8.94670e-01, 8.10861e-01, 7.34904e-01/
