C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB03.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.0 $
C     created:   $Date: 2002/06/03 20:34:31 $
       PARAMETER (MG=16)
       DIMENSION SELFREF(10,MG), FORREF(4,MG)
       REAL KA(9,5,13,MG), KB(5,5,13:59,MG)
       REAL KA_MN2O(9,19,MG),KB_MN2O(5,19,MG)

       COMMON /HVRSN3/ HVRKG3

       COMMON /K3/ KA, KB, FORREF, SELFREF, KA_MN2O, KB_MN2O
       
       CHARACTER*15 HVRKG3

       DATA HVRKG3 /'$Revision: 3.0 $'/

C     The array KA contains absorption coefs for each of the 16 g-intervals
C     for a range of pressure levels > ~100mb, temperatures, and ratios
C     of water vapor to CO2.  The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.
C     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
C     to different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this  pressure 
C     level, JT = 2 refers to the temperature
C     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
C     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
C     to the reference pressure level (e.g. JP = 1 is for a
C     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA ((KA(JS,JT, 1, 1),JS=1,9),JT=1,5) /
     &3.1886E-07,1.8969E-04,4.1239E-04,6.4667E-04,8.5292E-04,1.1836E-03,
     &1.4006E-03,1.5411E-03,8.3293E-04,4.3208E-07,2.2286E-04,4.4627E-04,
     &7.2330E-04,9.3694E-04,1.2337E-03,1.5482E-03,1.7773E-03,1.0038E-03,
     &5.8834E-07,2.6143E-04,5.0441E-04,7.7424E-04,1.0403E-03,1.3331E-03,
     &1.7908E-03,2.0845E-03,1.1619E-03,7.9926E-07,3.0532E-04,5.7655E-04,
     &8.4667E-04,1.1189E-03,1.4849E-03,1.7793E-03,2.3392E-03,1.2758E-03,
     &1.0726E-06,3.5559E-04,6.6472E-04,9.5586E-04,1.2287E-03,1.5629E-03,
     &1.9684E-03,2.6521E-03,1.4781E-03/
      DATA ((KA(JS,JT, 2, 1),JS=1,9),JT=1,5) /
     &3.7301E-07,1.5101E-04,3.0613E-04,5.2444E-04,6.6785E-04,9.0347E-04,
     &1.1047E-03,1.2717E-03,6.0920E-04,5.0464E-07,1.7900E-04,3.4606E-04,
     &5.4112E-04,7.7706E-04,9.3108E-04,1.2909E-03,1.4671E-03,7.3637E-04,
     &6.9109E-07,2.1210E-04,4.0308E-04,5.9670E-04,8.3572E-04,1.0539E-03,
     &1.2895E-03,1.6281E-03,8.3917E-04,9.4449E-07,2.4973E-04,4.6862E-04,
     &6.7662E-04,9.0294E-04,1.1388E-03,1.4230E-03,1.8780E-03,9.5236E-04,
     &1.2785E-06,2.9283E-04,5.4407E-04,7.7522E-04,1.0053E-03,1.2254E-03,
     &1.5592E-03,1.9031E-03,1.1164E-03/
      DATA ((KA(JS,JT, 3, 1),JS=1,9),JT=1,5) /
     &5.5921E-07,1.1924E-04,2.2509E-04,3.4318E-04,5.2308E-04,6.5616E-04,
     &8.5230E-04,1.0069E-03,4.1268E-04,7.5055E-07,1.4483E-04,2.6805E-04,
     &3.9345E-04,5.4245E-04,7.6863E-04,8.6931E-04,1.1266E-03,5.0829E-04,
     &1.0282E-06,1.7418E-04,3.1823E-04,4.6052E-04,6.0646E-04,8.0699E-04,
     &9.9010E-04,1.2822E-03,5.8353E-04,1.4165E-06,2.0776E-04,3.7640E-04,
     &5.3896E-04,6.9736E-04,8.7108E-04,1.0948E-03,1.3035E-03,6.8429E-04,
     &1.9344E-06,2.4744E-04,4.4263E-04,6.2983E-04,8.0258E-04,9.7503E-04,
     &1.1651E-03,1.4497E-03,8.1461E-04/
      DATA ((KA(JS,JT, 4, 1),JS=1,9),JT=1,5) /
     &8.5732E-07,9.6467E-05,1.7424E-04,2.5100E-04,3.3065E-04,4.8724E-04,
     &6.0299E-04,7.8582E-04,2.9808E-04,1.1308E-06,1.1826E-04,2.1303E-04,
     &3.0261E-04,3.9186E-04,5.0849E-04,7.0322E-04,8.2275E-04,3.5462E-04,
     &1.5409E-06,1.4413E-04,2.5818E-04,3.6263E-04,4.6469E-04,5.7592E-04,
     &7.3867E-04,8.7496E-04,4.2760E-04,2.1300E-06,1.7563E-04,3.1026E-04,
     &4.3228E-04,5.4859E-04,6.6681E-04,7.9581E-04,9.9932E-04,5.0892E-04,
     &2.9291E-06,2.1272E-04,3.6864E-04,5.1165E-04,6.4677E-04,7.7619E-04,
     &8.9814E-04,1.0897E-03,6.0064E-04/
      DATA ((KA(JS,JT, 5, 1),JS=1,9),JT=1,5) /
     &1.2415E-06,7.8277E-05,1.3778E-04,1.9284E-04,2.4740E-04,3.0422E-04,
     &4.5046E-04,5.5097E-04,2.1557E-04,1.5909E-06,9.7521E-05,1.7125E-04,
     &2.3852E-04,3.0221E-04,3.6563E-04,4.6525E-04,6.1320E-04,2.5987E-04,
     &2.1423E-06,1.2163E-04,2.0881E-04,2.9129E-04,3.6625E-04,4.3908E-04,
     &5.2524E-04,7.1422E-04,3.1853E-04,2.9538E-06,1.5072E-04,2.5416E-04,
     &3.5255E-04,4.4063E-04,5.2156E-04,6.0639E-04,7.4820E-04,3.8686E-04,
     &4.0808E-06,1.8492E-04,3.0793E-04,4.2155E-04,5.2630E-04,6.1892E-04,
     &7.0820E-04,8.0049E-04,4.6257E-04/
      DATA ((KA(JS,JT, 6, 1),JS=1,9),JT=1,5) /
     &1.7276E-06,6.3066E-05,1.0985E-04,1.5043E-04,1.8792E-04,2.2547E-04,
     &2.7278E-04,4.0029E-04,1.5625E-04,2.1189E-06,8.0476E-05,1.3664E-04,
     &1.8841E-04,2.3492E-04,2.7888E-04,3.2236E-04,4.6057E-04,1.9653E-04,
     &2.7917E-06,1.0200E-04,1.6954E-04,2.3141E-04,2.8961E-04,3.4143E-04,
     &3.9023E-04,4.8352E-04,2.3947E-04,3.8168E-06,1.2811E-04,2.1054E-04,
     &2.8370E-04,3.5217E-04,4.1385E-04,4.6780E-04,5.3253E-04,2.9421E-04,
     &5.2799E-06,1.5893E-04,2.5910E-04,3.4517E-04,4.2434E-04,4.9842E-04,
     &5.5728E-04,6.1195E-04,3.4978E-04/
      DATA ((KA(JS,JT, 7, 1),JS=1,9),JT=1,5) /
     &2.6141E-06,5.1662E-05,8.7249E-05,1.2099E-04,1.4820E-04,1.7386E-04,
     &1.9973E-04,2.8823E-04,1.2462E-04,3.0451E-06,6.6903E-05,1.1099E-04,
     &1.5079E-04,1.8779E-04,2.1746E-04,2.4532E-04,2.8791E-04,1.5686E-04,
     &3.8821E-06,8.6234E-05,1.4155E-04,1.8817E-04,2.3079E-04,2.7142E-04,
     &3.0362E-04,3.3424E-04,1.9309E-04,5.2168E-06,1.0990E-04,1.7879E-04,
     &2.3488E-04,2.8585E-04,3.3138E-04,3.7038E-04,4.0029E-04,2.2841E-04,
     &7.1879E-06,1.3891E-04,2.2275E-04,2.9114E-04,3.5068E-04,4.0298E-04,
     &4.4929E-04,4.7758E-04,2.7333E-04/
      DATA ((KA(JS,JT, 8, 1),JS=1,9),JT=1,5) /
     &4.8895E-06,4.6642E-05,7.3353E-05,9.8230E-05,1.2186E-04,1.4040E-04,
     &1.5472E-04,1.7158E-04,1.2116E-04,5.4032E-06,6.0479E-05,9.5191E-05,
     &1.2606E-04,1.5260E-04,1.7774E-04,1.9641E-04,2.0965E-04,1.4264E-04,
     &6.5997E-06,7.8772E-05,1.2353E-04,1.6212E-04,1.9427E-04,2.2313E-04,
     &2.4636E-04,2.5986E-04,1.7188E-04,8.6548E-06,1.0205E-04,1.5903E-04,
     &2.0720E-04,2.4581E-04,2.7759E-04,3.0314E-04,3.2037E-04,2.0203E-04,
     &1.1792E-05,1.3168E-04,2.0236E-04,2.6066E-04,3.0759E-04,3.4497E-04,
     &3.7389E-04,3.8968E-04,2.4008E-04/
      DATA ((KA(JS,JT, 9, 1),JS=1,9),JT=1,5) /
     &1.7686E-05,6.2925E-05,8.5198E-05,1.0213E-04,1.1543E-04,1.2780E-04,
     &1.3994E-04,1.4164E-04,1.0306E-04,1.8629E-05,7.9145E-05,1.0839E-04,
     &1.3177E-04,1.5002E-04,1.6481E-04,1.7578E-04,1.8331E-04,1.3692E-04,
     &2.1655E-05,1.0259E-04,1.4047E-04,1.7139E-04,1.9624E-04,2.1451E-04,
     &2.2698E-04,2.2863E-04,1.7350E-04,2.7461E-05,1.3575E-04,1.8409E-04,
     &2.2366E-04,2.5484E-04,2.7815E-04,2.9152E-04,2.8719E-04,2.1425E-04,
     &3.6727E-05,1.8189E-04,2.4258E-04,2.9022E-04,3.2921E-04,3.5617E-04,
     &3.6983E-04,3.5850E-04,2.5866E-04/
      DATA ((KA(JS,JT,10, 1),JS=1,9),JT=1,5) /
     &7.2663E-05,1.2805E-04,1.4610E-04,1.5523E-04,1.5931E-04,1.5768E-04,
     &1.4950E-04,1.3593E-04,1.1207E-04,7.4019E-05,1.5108E-04,1.7625E-04,
     &1.9103E-04,1.9729E-04,1.9817E-04,1.9144E-04,1.7408E-04,1.5499E-04,
     &8.2403E-05,1.8863E-04,2.2414E-04,2.4536E-04,2.5373E-04,2.5549E-04,
     &2.4939E-04,2.2811E-04,2.0551E-04,1.0093E-04,2.4723E-04,2.9626E-04,
     &3.2296E-04,3.3348E-04,3.3522E-04,3.2677E-04,2.9826E-04,2.6379E-04,
     &1.3200E-04,3.3367E-04,4.0011E-04,4.3332E-04,4.4493E-04,4.4261E-04,
     &4.2611E-04,3.8581E-04,3.2912E-04/
      DATA ((KA(JS,JT,11, 1),JS=1,9),JT=1,5) /
     &1.0393E-04,1.5840E-04,1.7203E-04,1.7648E-04,1.7454E-04,1.6667E-04,
     &1.5308E-04,1.2939E-04,1.0993E-04,1.0623E-04,1.8473E-04,2.0510E-04,
     &2.1424E-04,2.1529E-04,2.0732E-04,1.9332E-04,1.6735E-04,1.5034E-04,
     &1.1880E-04,2.2821E-04,2.5935E-04,2.7369E-04,2.7717E-04,2.6782E-04,
     &2.5002E-04,2.1993E-04,1.9822E-04,1.4561E-04,2.9665E-04,3.4318E-04,
     &3.6287E-04,3.6642E-04,3.5386E-04,3.2944E-04,2.8811E-04,2.5319E-04,
     &1.9054E-04,3.9809E-04,4.6486E-04,4.9198E-04,4.9373E-04,4.7462E-04,
     &4.3676E-04,3.7664E-04,3.1222E-04/
      DATA ((KA(JS,JT,12, 1),JS=1,9),JT=1,5) /
     &1.1070E-04,1.5948E-04,1.6935E-04,1.7123E-04,1.6742E-04,1.5636E-04,
     &1.4108E-04,1.1641E-04,9.3609E-05,1.1350E-04,1.8499E-04,2.0156E-04,
     &2.0690E-04,2.0458E-04,1.9450E-04,1.7678E-04,1.4985E-04,1.2839E-04,
     &1.2733E-04,2.2735E-04,2.5402E-04,2.6442E-04,2.6348E-04,2.5189E-04,
     &2.2992E-04,1.9655E-04,1.6928E-04,1.5627E-04,2.9456E-04,3.3549E-04,
     &3.5142E-04,3.5055E-04,3.3475E-04,3.0473E-04,2.5892E-04,2.1653E-04,
     &2.0441E-04,3.9462E-04,4.5461E-04,4.7637E-04,4.7456E-04,4.5071E-04,
     &4.0805E-04,3.4047E-04,2.6779E-04/
      DATA ((KA(JS,JT,13, 1),JS=1,9),JT=1,5) /
     &9.4796E-05,1.3566E-04,1.4361E-04,1.4479E-04,1.4118E-04,1.3147E-04,
     &1.1819E-04,9.7170E-05,7.6303E-05,9.7387E-05,1.5742E-04,1.7115E-04,
     &1.7535E-04,1.7300E-04,1.6383E-04,1.4824E-04,1.2513E-04,1.0469E-04,
     &1.0948E-04,1.9354E-04,2.1601E-04,2.2450E-04,2.2321E-04,2.1287E-04,
     &1.9350E-04,1.6433E-04,1.3819E-04,1.3445E-04,2.5083E-04,2.8549E-04,
     &2.9847E-04,2.9725E-04,2.8343E-04,2.5763E-04,2.1720E-04,1.7601E-04,
     &1.7573E-04,3.3657E-04,3.8710E-04,4.0560E-04,4.0357E-04,3.8257E-04,
     &3.4653E-04,2.8685E-04,2.1855E-04/
      DATA ((KA(JS,JT, 1, 2),JS=1,9),JT=1,5) /
     &1.3073E-06,4.2059E-04,6.7561E-04,8.6609E-04,1.3520E-03,1.6085E-03,
     &2.0908E-03,3.5262E-03,1.7846E-03,1.8197E-06,5.0768E-04,8.4110E-04,
     &1.0238E-03,1.3765E-03,1.9239E-03,2.2997E-03,3.5756E-03,2.0767E-03,
     &2.5084E-06,6.1290E-04,1.0202E-03,1.2693E-03,1.5516E-03,2.0078E-03,
     &2.5461E-03,3.4922E-03,2.2668E-03,3.4224E-06,7.3392E-04,1.2104E-03,
     &1.5455E-03,1.8866E-03,2.1966E-03,2.9624E-03,3.8708E-03,2.5909E-03,
     &4.5990E-06,8.7030E-04,1.4253E-03,1.8395E-03,2.2537E-03,2.6314E-03,
     &3.0779E-03,4.2442E-03,2.9663E-03/
      DATA ((KA(JS,JT, 2, 2),JS=1,9),JT=1,5) /
     &1.5178E-06,3.4269E-04,6.0748E-04,7.1986E-04,9.3674E-04,1.3121E-03,
     &1.6102E-03,2.4069E-03,1.3247E-03,2.1299E-06,4.2524E-04,7.3703E-04,
     &9.3776E-04,1.0398E-03,1.4367E-03,1.7353E-03,2.4061E-03,1.5243E-03,
     &2.9612E-06,5.1753E-04,8.8626E-04,1.1500E-03,1.2896E-03,1.5263E-03,
     &2.0876E-03,2.6389E-03,1.6966E-03,4.0897E-06,6.2596E-04,1.0597E-03,
     &1.3843E-03,1.5850E-03,1.8098E-03,2.1268E-03,2.8656E-03,1.9584E-03,
     &5.5687E-06,7.4555E-04,1.2600E-03,1.6347E-03,1.9070E-03,2.1914E-03,
     &2.4166E-03,3.3007E-03,2.2669E-03/
      DATA ((KA(JS,JT, 3, 2),JS=1,9),JT=1,5) /
     &2.2234E-06,2.7444E-04,5.0085E-04,6.9534E-04,7.7629E-04,8.8854E-04,
     &1.1917E-03,1.5373E-03,9.1595E-04,3.1317E-06,3.4263E-04,6.2257E-04,
     &8.4941E-04,1.0127E-03,1.0143E-03,1.3362E-03,1.6583E-03,1.0393E-03,
     &4.4080E-06,4.2422E-04,7.6347E-04,1.0279E-03,1.2387E-03,1.2967E-03,
     &1.3932E-03,1.8408E-03,1.2152E-03,6.1670E-06,5.2130E-04,9.2425E-04,
     &1.2412E-03,1.4849E-03,1.6022E-03,1.6415E-03,2.0935E-03,1.4201E-03,
     &8.5264E-06,6.3507E-04,1.1072E-03,1.4843E-03,1.7747E-03,1.9362E-03,
     &2.0233E-03,2.1572E-03,1.6619E-03/
      DATA ((KA(JS,JT, 4, 2),JS=1,9),JT=1,5) /
     &3.2835E-06,2.2111E-04,3.9199E-04,5.4782E-04,7.1479E-04,7.6154E-04,
     &8.2345E-04,1.0888E-03,6.1749E-04,4.6177E-06,2.8239E-04,4.9392E-04,
     &6.9299E-04,8.7089E-04,1.0035E-03,9.4113E-04,1.2776E-03,7.2212E-04,
     &6.5470E-06,3.5777E-04,6.1550E-04,8.6066E-04,1.0686E-03,1.2181E-03,
     &1.2204E-03,1.3196E-03,8.5856E-04,9.2896E-06,4.4826E-04,7.6106E-04,
     &1.0547E-03,1.2989E-03,1.4671E-03,1.5260E-03,1.4238E-03,1.0237E-03,
     &1.3071E-05,5.5733E-04,9.3625E-04,1.2821E-03,1.5559E-03,1.7516E-03,
     &1.8364E-03,1.7115E-03,1.2165E-03/
      DATA ((KA(JS,JT, 5, 2),JS=1,9),JT=1,5) /
     &4.5002E-06,1.7869E-04,3.1112E-04,4.2906E-04,5.3570E-04,6.6321E-04,
     &6.6606E-04,8.0088E-04,4.3845E-04,6.2709E-06,2.3526E-04,3.9946E-04,
     &5.4822E-04,6.8446E-04,8.1650E-04,8.9841E-04,8.3661E-04,5.3250E-04,
     &8.9215E-06,3.0515E-04,5.1007E-04,6.9053E-04,8.5739E-04,1.0092E-03,
     &1.0997E-03,9.5118E-04,6.4123E-04,1.2814E-05,3.9188E-04,6.4418E-04,
     &8.6120E-04,1.0618E-03,1.2430E-03,1.3327E-03,1.2360E-03,7.6830E-04,
     &1.8376E-05,4.9865E-04,8.0644E-04,1.0670E-03,1.3038E-03,1.5043E-03,
     &1.6049E-03,1.5432E-03,9.1314E-04/
      DATA ((KA(JS,JT, 6, 2),JS=1,9),JT=1,5) /
     &5.7892E-06,1.4663E-04,2.4065E-04,3.3064E-04,4.1135E-04,4.8169E-04,
     &5.8379E-04,5.7710E-04,3.1814E-04,7.9690E-06,1.9590E-04,3.2041E-04,
     &4.3222E-04,5.3334E-04,6.2056E-04,7.1751E-04,6.6758E-04,3.9067E-04,
     &1.1323E-05,2.6004E-04,4.1914E-04,5.5855E-04,6.8140E-04,7.8989E-04,
     &8.8852E-04,8.8775E-04,4.8310E-04,1.6358E-05,3.4053E-04,5.4044E-04,
     &7.1305E-04,8.6088E-04,9.8765E-04,1.0974E-03,1.1000E-03,5.7948E-04,
     &2.3775E-05,4.4089E-04,6.9082E-04,9.0148E-04,1.0783E-03,1.2236E-03,
     &1.3409E-03,1.3317E-03,6.9627E-04/
      DATA ((KA(JS,JT, 7, 2),JS=1,9),JT=1,5) /
     &8.0091E-06,1.2605E-04,1.9716E-04,2.5635E-04,3.1697E-04,3.6727E-04,
     &4.1064E-04,4.3234E-04,2.4150E-04,1.0776E-05,1.7034E-04,2.6589E-04,
     &3.4715E-04,4.2062E-04,4.8583E-04,5.3757E-04,5.9551E-04,2.9725E-04,
     &1.5189E-05,2.2959E-04,3.5476E-04,4.5964E-04,5.5426E-04,6.3049E-04,
     &6.9328E-04,7.3902E-04,3.6802E-04,2.2007E-05,3.0657E-04,4.6692E-04,
     &5.9983E-04,7.1322E-04,8.0913E-04,8.7898E-04,9.1398E-04,4.5358E-04,
     &3.2377E-05,4.0363E-04,6.0728E-04,7.7481E-04,9.1139E-04,1.0238E-03,
     &1.0988E-03,1.1244E-03,5.4283E-04/
      DATA ((KA(JS,JT, 8, 2),JS=1,9),JT=1,5) /
     &1.3646E-05,1.1718E-04,1.7739E-04,2.2327E-04,2.5768E-04,2.9227E-04,
     &3.2168E-04,3.3945E-04,2.0435E-04,1.7797E-05,1.5982E-04,2.4160E-04,
     &3.0351E-04,3.5441E-04,3.9644E-04,4.3035E-04,4.4547E-04,2.6027E-04,
     &2.4726E-05,2.1816E-04,3.2650E-04,4.0893E-04,4.7479E-04,5.2784E-04,
     &5.6990E-04,5.8414E-04,3.2342E-04,3.5739E-05,2.9719E-04,4.3967E-04,
     &5.4459E-04,6.2961E-04,6.9435E-04,7.4016E-04,7.4703E-04,3.9508E-04,
     &5.2993E-05,4.0333E-04,5.8500E-04,7.1845E-04,8.2505E-04,9.0108E-04,
     &9.4665E-04,9.4587E-04,4.7280E-04/
      DATA ((KA(JS,JT, 9, 2),JS=1,9),JT=1,5) /
     &4.5250E-05,1.4686E-04,2.0230E-04,2.4828E-04,2.8036E-04,2.9801E-04,
     &2.9921E-04,2.8815E-04,2.4577E-04,5.6592E-05,2.0110E-04,2.8181E-04,
     &3.4405E-04,3.8167E-04,4.0863E-04,4.1514E-04,3.9115E-04,3.2441E-04,
     &7.7017E-05,2.8027E-04,3.9316E-04,4.7187E-04,5.1925E-04,5.5669E-04,
     &5.6308E-04,5.3177E-04,4.1003E-04,1.1025E-04,3.9471E-04,5.4612E-04,
     &6.4824E-04,7.1055E-04,7.5245E-04,7.5557E-04,7.0714E-04,5.0547E-04,
     &1.6377E-04,5.5266E-04,7.5260E-04,8.8463E-04,9.6217E-04,1.0084E-03,
     &1.0010E-03,9.2831E-04,5.9992E-04/
      DATA ((KA(JS,JT,10, 2),JS=1,9),JT=1,5) /
     &1.7408E-04,2.8709E-04,3.2527E-04,3.4835E-04,3.5894E-04,3.5919E-04,
     &3.5263E-04,3.1484E-04,2.7571E-04,2.0961E-04,3.6816E-04,4.3143E-04,
     &4.6881E-04,4.9659E-04,5.0147E-04,4.9272E-04,4.3339E-04,3.8859E-04,
     &2.7776E-04,5.0192E-04,5.9603E-04,6.5181E-04,6.9357E-04,7.0312E-04,
     &6.7864E-04,5.9253E-04,5.1467E-04,3.9424E-04,7.1243E-04,8.4498E-04,
     &9.2473E-04,9.7484E-04,9.8216E-04,9.3644E-04,8.0724E-04,6.5632E-04,
     &5.8403E-04,1.0226E-03,1.2011E-03,1.3089E-03,1.3689E-03,1.3686E-03,
     &1.2847E-03,1.0916E-03,8.0745E-04/
      DATA ((KA(JS,JT,11, 2),JS=1,9),JT=1,5) /
     &2.5093E-04,3.5665E-04,3.8701E-04,3.9631E-04,3.9372E-04,3.8144E-04,
     &3.5373E-04,3.1423E-04,3.0104E-04,3.0561E-04,4.5397E-04,5.0521E-04,
     &5.3017E-04,5.3366E-04,5.2816E-04,4.9620E-04,4.3115E-04,4.1409E-04,
     &4.0935E-04,6.2197E-04,6.9995E-04,7.3845E-04,7.4646E-04,7.4054E-04,
     &7.0035E-04,5.8985E-04,5.4448E-04,5.8584E-04,8.9030E-04,1.0016E-03,
     &1.0495E-03,1.0645E-03,1.0487E-03,9.8184E-04,8.1405E-04,6.7706E-04,
     &8.7589E-04,1.3050E-03,1.4464E-03,1.5053E-03,1.5175E-03,1.4779E-03,
     &1.3691E-03,1.1154E-03,8.3668E-04/
      DATA ((KA(JS,JT,12, 2),JS=1,9),JT=1,5) /
     &2.6981E-04,3.6165E-04,3.8393E-04,3.8621E-04,3.7773E-04,3.5863E-04,
     &3.2723E-04,2.8136E-04,2.7937E-04,3.3189E-04,4.6172E-04,5.0224E-04,
     &5.1546E-04,5.1134E-04,4.9419E-04,4.6078E-04,3.9503E-04,3.8165E-04,
     &4.4945E-04,6.3614E-04,7.0015E-04,7.2309E-04,7.1840E-04,6.9882E-04,
     &6.5062E-04,5.4697E-04,5.0283E-04,6.4949E-04,9.2459E-04,1.0096E-03,
     &1.0404E-03,1.0301E-03,9.9704E-04,9.2064E-04,7.5726E-04,6.3715E-04,
     &9.7948E-04,1.3695E-03,1.4755E-03,1.5098E-03,1.4823E-03,1.4173E-03,
     &1.2918E-03,1.0472E-03,7.8120E-04/
      DATA ((KA(JS,JT,13, 2),JS=1,9),JT=1,5) /
     &2.3347E-04,3.0984E-04,3.2740E-04,3.2836E-04,3.1964E-04,3.0307E-04,
     &2.7562E-04,2.3564E-04,2.3674E-04,2.9027E-04,3.9857E-04,4.3170E-04,
     &4.4144E-04,4.3482E-04,4.1943E-04,3.8943E-04,3.3194E-04,3.2365E-04,
     &3.9524E-04,5.5472E-04,6.0676E-04,6.2319E-04,6.1597E-04,5.9710E-04,
     &5.5278E-04,4.6213E-04,4.2552E-04,5.7486E-04,8.1393E-04,8.8216E-04,
     &9.0454E-04,8.9206E-04,8.5566E-04,7.8499E-04,6.4422E-04,5.3476E-04,
     &8.7246E-04,1.2122E-03,1.2989E-03,1.3221E-03,1.2955E-03,1.2260E-03,
     &1.1071E-03,8.9174E-04,6.5849E-04/
      DATA ((KA(JS,JT, 1, 3),JS=1,9),JT=1,5) /
     &5.2546E-06,7.1189E-04,1.0882E-03,1.5407E-03,1.6694E-03,2.0484E-03,
     &2.8523E-03,4.1696E-03,2.5067E-03,7.7092E-06,8.7649E-04,1.3426E-03,
     &1.8360E-03,2.2345E-03,2.3018E-03,2.9500E-03,4.8247E-03,2.8678E-03,
     &1.1096E-05,1.0569E-03,1.6133E-03,2.2145E-03,2.7396E-03,3.0159E-03,
     &3.2179E-03,5.1113E-03,3.6024E-03,1.5736E-05,1.2601E-03,1.9380E-03,
     &2.6510E-03,3.2424E-03,3.7893E-03,3.9992E-03,5.0794E-03,4.4455E-03,
     &2.1768E-05,1.4881E-03,2.3013E-03,3.1272E-03,3.8505E-03,4.4934E-03,
     &5.1336E-03,5.8796E-03,5.3642E-03/
      DATA ((KA(JS,JT, 2, 3),JS=1,9),JT=1,5) /
     &6.4189E-06,6.4436E-04,9.4389E-04,1.2239E-03,1.5862E-03,1.5943E-03,
     &2.1761E-03,2.9768E-03,1.8319E-03,9.5139E-06,7.9863E-04,1.1748E-03,
     &1.5104E-03,1.9094E-03,2.0876E-03,2.2172E-03,3.3690E-03,2.2079E-03,
     &1.3920E-05,9.7738E-04,1.4337E-03,1.8422E-03,2.2904E-03,2.6664E-03,
     &2.6655E-03,3.3322E-03,2.7973E-03,1.9815E-05,1.1745E-03,1.7255E-03,
     &2.2150E-03,2.7638E-03,3.1950E-03,3.5144E-03,3.6601E-03,3.4291E-03,
     &2.7567E-05,1.3937E-03,2.0553E-03,2.6513E-03,3.2736E-03,3.7952E-03,
     &4.2837E-03,4.4922E-03,4.1160E-03/
      DATA ((KA(JS,JT, 3, 3),JS=1,9),JT=1,5) /
     &9.6319E-06,5.9789E-04,9.0789E-04,1.1077E-03,1.2525E-03,1.5120E-03,
     &1.4959E-03,2.1276E-03,1.3456E-03,1.4531E-05,7.5640E-04,1.1412E-03,
     &1.3989E-03,1.5703E-03,1.7944E-03,1.9386E-03,2.1696E-03,1.7109E-03,
     &2.1457E-05,9.3610E-04,1.4115E-03,1.7272E-03,1.9369E-03,2.2003E-03,
     &2.5012E-03,2.3167E-03,2.1265E-03,3.1112E-05,1.1388E-03,1.7200E-03,
     &2.0901E-03,2.3590E-03,2.6864E-03,2.9768E-03,2.9114E-03,2.5844E-03,
     &4.3735E-05,1.3632E-03,2.0663E-03,2.5031E-03,2.8359E-03,3.2124E-03,
     &3.5643E-03,3.8138E-03,3.0766E-03/
      DATA ((KA(JS,JT, 4, 3),JS=1,9),JT=1,5) /
     &1.4332E-05,5.0481E-04,8.3885E-04,1.0386E-03,1.1528E-03,1.2153E-03,
     &1.3236E-03,1.3236E-03,9.9177E-04,2.1745E-05,6.5797E-04,1.0771E-03,
     &1.3282E-03,1.4860E-03,1.5492E-03,1.6188E-03,1.5468E-03,1.2757E-03,
     &3.2667E-05,8.3614E-04,1.3479E-03,1.6673E-03,1.8582E-03,1.9416E-03,
     &2.0036E-03,2.1024E-03,1.5754E-03,4.8093E-05,1.0472E-03,1.6541E-03,
     &2.0462E-03,2.2910E-03,2.3927E-03,2.4569E-03,2.6010E-03,1.9210E-03,
     &6.8610E-05,1.2933E-03,1.9995E-03,2.4752E-03,2.7858E-03,2.9107E-03,
     &2.9847E-03,3.0912E-03,2.3242E-03/
      DATA ((KA(JS,JT, 5, 3),JS=1,9),JT=1,5) /
     &1.9357E-05,4.3188E-04,6.9760E-04,9.1881E-04,1.0444E-03,1.0861E-03,
     &1.0808E-03,1.0528E-03,7.6202E-04,2.9833E-05,5.6548E-04,9.1440E-04,
     &1.2005E-03,1.3604E-03,1.4256E-03,1.3945E-03,1.3872E-03,9.4421E-04,
     &4.5578E-05,7.2730E-04,1.1762E-03,1.5269E-03,1.7329E-03,1.8168E-03,
     &1.7751E-03,1.6935E-03,1.1652E-03,6.7915E-05,9.2227E-04,1.4839E-03,
     &1.8964E-03,2.1540E-03,2.2580E-03,2.2284E-03,2.0768E-03,1.4187E-03,
     &9.8232E-05,1.1614E-03,1.8417E-03,2.3162E-03,2.6333E-03,2.7678E-03,
     &2.7278E-03,2.5343E-03,1.7135E-03/
      DATA ((KA(JS,JT, 6, 3),JS=1,9),JT=1,5) /
     &2.4087E-05,3.6023E-04,5.7620E-04,7.4775E-04,8.9007E-04,9.5429E-04,
     &9.1764E-04,8.4636E-04,5.7959E-04,3.7139E-05,4.8232E-04,7.6564E-04,
     &9.9341E-04,1.1781E-03,1.2665E-03,1.2330E-03,1.0918E-03,7.2688E-04,
     &5.7836E-05,6.3457E-04,9.9482E-04,1.2902E-03,1.5235E-03,1.6284E-03,
     &1.5983E-03,1.4005E-03,8.9110E-04,8.7827E-05,8.3029E-04,1.2776E-03,
     &1.6365E-03,1.9214E-03,2.0538E-03,2.0181E-03,1.7675E-03,1.0912E-03,
     &1.2951E-04,1.0725E-03,1.6206E-03,2.0554E-03,2.3768E-03,2.5369E-03,
     &2.5004E-03,2.2047E-03,1.3222E-03/
      DATA ((KA(JS,JT, 7, 3),JS=1,9),JT=1,5) /
     &3.1610E-05,3.0736E-04,4.8099E-04,6.1875E-04,7.2425E-04,8.0714E-04,
     &8.2765E-04,7.1397E-04,4.2627E-04,4.8734E-05,4.2352E-04,6.5473E-04,
     &8.3909E-04,9.8036E-04,1.0919E-03,1.1195E-03,9.5621E-04,5.5009E-04,
     &7.5777E-05,5.7189E-04,8.6982E-04,1.1085E-03,1.2941E-03,1.4332E-03,
     &1.4595E-03,1.2666E-03,6.8930E-04,1.1758E-04,7.6635E-04,1.1428E-03,
     &1.4431E-03,1.6723E-03,1.8359E-03,1.8555E-03,1.6214E-03,8.4503E-04,
     &1.7719E-04,1.0176E-03,1.4892E-03,1.8529E-03,2.1284E-03,2.3074E-03,
     &2.3192E-03,2.0277E-03,1.0269E-03/
      DATA ((KA(JS,JT, 8, 3),JS=1,9),JT=1,5) /
     &5.0016E-05,3.0350E-04,4.3130E-04,5.4117E-04,6.2740E-04,6.8603E-04,
     &7.1531E-04,6.7206E-04,3.4534E-04,7.6305E-05,4.2110E-04,6.0202E-04,
     &7.5262E-04,8.6967E-04,9.4998E-04,9.8539E-04,9.2682E-04,4.4615E-04,
     &1.1911E-04,5.8304E-04,8.2209E-04,1.0213E-03,1.1738E-03,1.2774E-03,
     &1.3191E-03,1.2307E-03,5.5948E-04,1.8649E-04,7.9923E-04,1.1102E-03,
     &1.3602E-03,1.5530E-03,1.6805E-03,1.7288E-03,1.5932E-03,6.8951E-04,
     &2.8664E-04,1.0891E-03,1.4894E-03,1.7956E-03,2.0238E-03,2.1795E-03,
     &2.2144E-03,2.0105E-03,8.3262E-04/
      DATA ((KA(JS,JT, 9, 3),JS=1,9),JT=1,5) /
     &1.5293E-04,4.6711E-04,5.9429E-04,6.7143E-04,7.0270E-04,7.2578E-04,
     &7.2031E-04,6.7023E-04,4.6857E-04,2.2743E-04,6.5435E-04,8.3260E-04,
     &9.2221E-04,9.8476E-04,1.0204E-03,1.0235E-03,9.4955E-04,5.6708E-04,
     &3.5601E-04,9.4855E-04,1.1602E-03,1.2875E-03,1.3640E-03,1.4067E-03,
     &1.4070E-03,1.3032E-03,6.4714E-04,5.5911E-04,1.3606E-03,1.6272E-03,
     &1.7782E-03,1.8671E-03,1.9159E-03,1.8899E-03,1.7374E-03,7.3858E-04,
     &8.7081E-04,1.9356E-03,2.2669E-03,2.4429E-03,2.5498E-03,2.5834E-03,
     &2.5150E-03,2.2763E-03,8.7139E-04/
      DATA ((KA(JS,JT,10, 3),JS=1,9),JT=1,5) /
     &5.5025E-04,9.1638E-04,1.0524E-03,1.1151E-03,1.1173E-03,1.0672E-03,
     &9.7649E-04,7.7345E-04,6.5002E-04,7.9126E-04,1.3002E-03,1.4860E-03,
     &1.5598E-03,1.5441E-03,1.5015E-03,1.3399E-03,1.0909E-03,8.3499E-04,
     &1.2237E-03,1.9321E-03,2.1587E-03,2.2526E-03,2.2235E-03,2.1040E-03,
     &1.8744E-03,1.5238E-03,1.0298E-03,1.9295E-03,2.9068E-03,3.1939E-03,
     &3.2884E-03,3.1828E-03,2.9739E-03,2.6100E-03,2.0967E-03,1.2389E-03,
     &3.0420E-03,4.3560E-03,4.6911E-03,4.7252E-03,4.5246E-03,4.1666E-03,
     &3.6292E-03,2.8608E-03,1.4677E-03/
      DATA ((KA(JS,JT,11, 3),JS=1,9),JT=1,5) /
     &8.0124E-04,1.1600E-03,1.2577E-03,1.2913E-03,1.2758E-03,1.1948E-03,
     &1.0607E-03,8.2464E-04,6.8579E-04,1.1673E-03,1.6642E-03,1.8003E-03,
     &1.8395E-03,1.7987E-03,1.6759E-03,1.4977E-03,1.1597E-03,8.7714E-04,
     &1.8208E-03,2.5072E-03,2.6736E-03,2.6935E-03,2.6255E-03,2.4196E-03,
     &2.1072E-03,1.6350E-03,1.1070E-03,2.8872E-03,3.8298E-03,4.0028E-03,
     &4.0090E-03,3.8400E-03,3.4828E-03,2.9827E-03,2.2825E-03,1.3306E-03,
     &4.5758E-03,5.8214E-03,5.9954E-03,5.8806E-03,5.5457E-03,4.9671E-03,
     &4.1979E-03,3.1537E-03,1.5896E-03/
      DATA ((KA(JS,JT,12, 3),JS=1,9),JT=1,5) /
     &8.6957E-04,1.1918E-03,1.2597E-03,1.2688E-03,1.2375E-03,1.1513E-03,
     &1.0110E-03,7.8620E-04,6.6607E-04,1.2841E-03,1.7262E-03,1.8227E-03,
     &1.8310E-03,1.7702E-03,1.6364E-03,1.4379E-03,1.0990E-03,8.6314E-04,
     &2.0183E-03,2.6229E-03,2.7286E-03,2.7135E-03,2.6112E-03,2.3987E-03,
     &2.0472E-03,1.5496E-03,1.0681E-03,3.2212E-03,4.0504E-03,4.1472E-03,
     &4.0702E-03,3.8583E-03,3.4748E-03,2.9262E-03,2.1914E-03,1.2601E-03,
     &5.1511E-03,6.2196E-03,6.2591E-03,6.0402E-03,5.6302E-03,4.9946E-03,
     &4.1641E-03,3.0581E-03,1.4932E-03/
      DATA ((KA(JS,JT,13, 3),JS=1,9),JT=1,5) /
     &7.5570E-04,1.0245E-03,1.0772E-03,1.0860E-03,1.0524E-03,9.7557E-04,
     &8.5610E-04,6.6220E-04,5.7960E-04,1.1289E-03,1.4995E-03,1.5736E-03,
     &1.5761E-03,1.5191E-03,1.4055E-03,1.2213E-03,9.3390E-04,7.5295E-04,
     &1.7891E-03,2.2942E-03,2.3709E-03,2.3513E-03,2.2646E-03,2.0616E-03,
     &1.7545E-03,1.3283E-03,9.2119E-04,2.8872E-03,3.5675E-03,3.6372E-03,
     &3.5628E-03,3.3407E-03,3.0031E-03,2.5207E-03,1.8863E-03,1.0888E-03,
     &4.6509E-03,5.5327E-03,5.4994E-03,5.2862E-03,4.8993E-03,4.3534E-03,
     &3.6092E-03,2.6447E-03,1.2715E-03/
      DATA ((KA(JS,JT, 1, 4),JS=1,9),JT=1,5) /
     &2.0197E-05,1.1667E-03,1.8703E-03,2.3597E-03,2.8442E-03,3.3004E-03,
     &3.9209E-03,5.1050E-03,4.4032E-03,2.9878E-05,1.4283E-03,2.2934E-03,
     &2.9621E-03,3.4763E-03,4.1665E-03,4.8948E-03,5.8620E-03,5.4661E-03,
     &4.2867E-05,1.7152E-03,2.7742E-03,3.5744E-03,4.2361E-03,5.0272E-03,
     &5.9642E-03,7.9378E-03,6.6044E-03,5.9869E-05,2.0335E-03,3.2827E-03,
     &4.2442E-03,5.1046E-03,5.9179E-03,7.1401E-03,9.6601E-03,7.8490E-03,
     &8.1517E-05,2.3834E-03,3.8440E-03,4.9959E-03,6.0214E-03,7.0692E-03,
     &8.4265E-03,1.1443E-02,9.2888E-03/
      DATA ((KA(JS,JT, 2, 4),JS=1,9),JT=1,5) /
     &2.5366E-05,1.0671E-03,1.6131E-03,2.1123E-03,2.3685E-03,2.7185E-03,
     &3.0418E-03,3.4879E-03,3.3143E-03,3.7671E-05,1.3088E-03,2.0014E-03,
     &2.6106E-03,3.0312E-03,3.3873E-03,3.9017E-03,4.5215E-03,4.1143E-03,
     &5.4541E-05,1.5795E-03,2.4306E-03,3.1726E-03,3.7137E-03,4.1208E-03,
     &4.7737E-03,5.7376E-03,4.9901E-03,7.7056E-05,1.8857E-03,2.9009E-03,
     &3.7836E-03,4.4364E-03,5.0235E-03,5.6427E-03,6.9365E-03,5.9848E-03,
     &1.0566E-04,2.2344E-03,3.4137E-03,4.4552E-03,5.2671E-03,5.9853E-03,
     &6.7249E-03,8.2397E-03,7.1296E-03/
      DATA ((KA(JS,JT, 3, 4),JS=1,9),JT=1,5) /
     &3.9558E-05,1.0742E-03,1.5248E-03,1.8501E-03,2.1830E-03,2.3261E-03,
     &2.4391E-03,2.5890E-03,2.3829E-03,5.9594E-05,1.3476E-03,1.8940E-03,
     &2.3182E-03,2.7486E-03,3.0410E-03,3.0839E-03,3.3287E-03,2.9662E-03,
     &8.7495E-05,1.6651E-03,2.3108E-03,2.8515E-03,3.3798E-03,3.7359E-03,
     &3.8327E-03,4.1905E-03,3.5949E-03,1.2450E-04,2.0293E-03,2.7849E-03,
     &3.4502E-03,4.0760E-03,4.5002E-03,4.7432E-03,5.0708E-03,4.3551E-03,
     &1.7405E-04,2.4316E-03,3.3182E-03,4.1142E-03,4.8387E-03,5.3673E-03,
     &5.6716E-03,6.0036E-03,5.2554E-03/
      DATA ((KA(JS,JT, 4, 4),JS=1,9),JT=1,5) /
     &6.0993E-05,1.0865E-03,1.5064E-03,1.7956E-03,1.9492E-03,2.0758E-03,
     &2.1376E-03,1.9974E-03,1.7194E-03,9.3739E-05,1.3938E-03,1.9090E-03,
     &2.2655E-03,2.4714E-03,2.6468E-03,2.7998E-03,2.5993E-03,2.1766E-03,
     &1.3999E-04,1.7512E-03,2.3888E-03,2.8018E-03,3.0687E-03,3.3097E-03,
     &3.4825E-03,3.2297E-03,2.6912E-03,2.0284E-04,2.1576E-03,2.9507E-03,
     &3.4179E-03,3.7408E-03,4.0628E-03,4.2589E-03,4.0554E-03,3.2822E-03,
     &2.8653E-04,2.6101E-03,3.5917E-03,4.1189E-03,4.5031E-03,4.8876E-03,
     &5.1085E-03,4.9728E-03,3.9394E-03/
      DATA ((KA(JS,JT, 5, 4),JS=1,9),JT=1,5) /
     &8.6213E-05,1.0235E-03,1.4463E-03,1.6932E-03,1.8586E-03,1.8899E-03,
     &1.8325E-03,1.6931E-03,1.2167E-03,1.3497E-04,1.3639E-03,1.8867E-03,
     &2.1813E-03,2.3731E-03,2.4352E-03,2.3757E-03,2.2169E-03,1.5707E-03,
     &2.0469E-04,1.7684E-03,2.3970E-03,2.7679E-03,2.9816E-03,3.0549E-03,
     &3.0098E-03,2.8798E-03,1.9802E-03,3.0118E-04,2.2412E-03,2.9952E-03,
     &3.4514E-03,3.7055E-03,3.7675E-03,3.7358E-03,3.5681E-03,2.4524E-03,
     &4.3178E-04,2.7692E-03,3.6699E-03,4.2507E-03,4.5341E-03,4.5904E-03,
     &4.5606E-03,4.3497E-03,2.9904E-03/
      DATA ((KA(JS,JT, 6, 4),JS=1,9),JT=1,5) /
     &1.1224E-04,9.6248E-04,1.3486E-03,1.5651E-03,1.6739E-03,1.7217E-03,
     &1.6200E-03,1.3812E-03,9.3024E-04,1.7788E-04,1.2979E-03,1.7963E-03,
     &2.0621E-03,2.2013E-03,2.2377E-03,2.1278E-03,1.8809E-03,1.2042E-03,
     &2.7340E-04,1.7148E-03,2.3323E-03,2.6619E-03,2.8238E-03,2.8631E-03,
     &2.7284E-03,2.4183E-03,1.5217E-03,4.0959E-04,2.2331E-03,2.9678E-03,
     &3.3799E-03,3.5736E-03,3.5928E-03,3.4271E-03,3.0552E-03,1.8843E-03,
     &5.9620E-04,2.8328E-03,3.7008E-03,4.1972E-03,4.4330E-03,4.4525E-03,
     &4.2185E-03,3.7711E-03,2.2988E-03/
      DATA ((KA(JS,JT, 7, 4),JS=1,9),JT=1,5) /
     &1.5344E-04,9.2316E-04,1.2773E-03,1.5000E-03,1.6102E-03,1.6127E-03,
     &1.5115E-03,1.2377E-03,7.0764E-04,2.4398E-04,1.2809E-03,1.7477E-03,
     &2.0347E-03,2.1522E-03,2.1311E-03,1.9950E-03,1.6669E-03,9.1774E-04,
     &3.8058E-04,1.7477E-03,2.3440E-03,2.6829E-03,2.8039E-03,2.7555E-03,
     &2.5876E-03,2.1763E-03,1.1586E-03,5.7739E-04,2.3349E-03,3.0698E-03,
     &3.4470E-03,3.5790E-03,3.5331E-03,3.3054E-03,2.7805E-03,1.4458E-03,
     &8.5208E-04,3.0383E-03,3.9002E-03,4.3347E-03,4.5004E-03,4.4415E-03,
     &4.1236E-03,3.4788E-03,1.7825E-03/
      DATA ((KA(JS,JT, 8, 4),JS=1,9),JT=1,5) /
     &2.5035E-04,9.8089E-04,1.3026E-03,1.5173E-03,1.6357E-03,1.6535E-03,
     &1.5386E-03,1.2613E-03,5.4812E-04,3.9983E-04,1.4074E-03,1.8431E-03,
     &2.1183E-03,2.2695E-03,2.2610E-03,2.0892E-03,1.6966E-03,7.0487E-04,
     &6.2524E-04,1.9883E-03,2.5535E-03,2.8971E-03,3.0599E-03,3.0259E-03,
     &2.7534E-03,2.2128E-03,8.9347E-04,9.6475E-04,2.7489E-03,3.4725E-03,
     &3.8856E-03,4.0355E-03,3.9357E-03,3.5484E-03,2.8450E-03,1.1141E-03,
     &1.4492E-03,3.7234E-03,4.6023E-03,5.0761E-03,5.1898E-03,5.0041E-03,
     &4.4962E-03,3.6082E-03,1.3876E-03/
      DATA ((KA(JS,JT, 9, 4),JS=1,9),JT=1,5) /
     &7.7717E-04,1.6076E-03,1.9327E-03,2.0950E-03,2.1727E-03,2.1507E-03,
     &2.0239E-03,1.6619E-03,6.5283E-04,1.2257E-03,2.4216E-03,2.8205E-03,
     &3.0706E-03,3.1558E-03,3.0893E-03,2.8639E-03,2.3215E-03,8.1326E-04,
     &1.9258E-03,3.5788E-03,4.1331E-03,4.4121E-03,4.4825E-03,4.3456E-03,
     &3.9751E-03,3.1546E-03,1.0072E-03,3.0058E-03,5.1816E-03,5.8926E-03,
     &6.2133E-03,6.2513E-03,5.9943E-03,5.4160E-03,4.1735E-03,1.2133E-03,
     &4.5860E-03,7.3561E-03,8.1694E-03,8.5315E-03,8.5009E-03,8.0696E-03,
     &7.1597E-03,5.3914E-03,1.4524E-03/
      DATA ((KA(JS,JT,10, 4),JS=1,9),JT=1,5) /
     &2.7632E-03,3.7578E-03,3.8929E-03,3.8648E-03,3.7150E-03,3.4386E-03,
     &2.9824E-03,2.3042E-03,1.1595E-03,4.3618E-03,5.8439E-03,6.0237E-03,
     &5.9173E-03,5.6198E-03,5.0739E-03,4.3966E-03,3.3846E-03,1.3310E-03,
     &6.8076E-03,8.8616E-03,9.0867E-03,8.8297E-03,8.2980E-03,7.5120E-03,
     &6.4366E-03,4.8357E-03,1.4427E-03,1.0727E-02,1.3247E-02,1.3386E-02,
     &1.2895E-02,1.2079E-02,1.0841E-02,9.1826E-03,6.8074E-03,1.5623E-03,
     &1.6578E-02,1.9641E-02,1.9517E-02,1.8627E-02,1.7184E-02,1.5227E-02,
     &1.2710E-02,9.3140E-03,1.8266E-03/
      DATA ((KA(JS,JT,11, 4),JS=1,9),JT=1,5) /
     &4.3397E-03,5.2633E-03,5.2314E-03,5.0017E-03,4.6314E-03,4.1308E-03,
     &3.4621E-03,2.5597E-03,1.2582E-03,6.6934E-03,8.1477E-03,8.0949E-03,
     &7.7188E-03,7.1188E-03,6.2977E-03,5.1713E-03,3.7779E-03,1.4574E-03,
     &1.0432E-02,1.2428E-02,1.2196E-02,1.1560E-02,1.0566E-02,9.2464E-03,
     &7.6156E-03,5.5141E-03,1.6582E-03,1.6491E-02,1.8759E-02,1.8258E-02,
     &1.7109E-02,1.5472E-02,1.3463E-02,1.0963E-02,7.7973E-03,1.8335E-03,
     &2.5430E-02,2.8078E-02,2.7002E-02,2.5032E-02,2.2392E-02,1.9261E-02,
     &1.5474E-02,1.0784E-02,2.0075E-03/
      DATA ((KA(JS,JT,12, 4),JS=1,9),JT=1,5) /
     &4.9273E-03,5.7931E-03,5.6746E-03,5.3611E-03,4.8847E-03,4.2709E-03,
     &3.4855E-03,2.4889E-03,1.1526E-03,7.6884E-03,8.9132E-03,8.6777E-03,
     &8.1782E-03,7.4327E-03,6.4648E-03,5.2372E-03,3.6981E-03,1.3373E-03,
     &1.2107E-02,1.3711E-02,1.3177E-02,1.2250E-02,1.1036E-02,9.5160E-03,
     &7.6801E-03,5.4155E-03,1.5194E-03,1.8869E-02,2.0811E-02,1.9833E-02,
     &1.8325E-02,1.6361E-02,1.3983E-02,1.1160E-02,7.6837E-03,1.7468E-03,
     &2.9063E-02,3.1131E-02,2.9461E-02,2.6993E-02,2.3838E-02,2.0192E-02,
     &1.5924E-02,1.0737E-02,1.9884E-03/
      DATA ((KA(JS,JT,13, 4),JS=1,9),JT=1,5) /
     &4.3869E-03,5.1798E-03,5.0989E-03,4.8169E-03,4.3794E-03,3.7839E-03,
     &3.0521E-03,2.1587E-03,9.4784E-04,6.9481E-03,8.0525E-03,7.8458E-03,
     &7.3314E-03,6.6078E-03,5.7100E-03,4.5663E-03,3.2136E-03,1.0961E-03,
     &1.1021E-02,1.2458E-02,1.1977E-02,1.1021E-02,9.8258E-03,8.4083E-03,
     &6.7419E-03,4.6947E-03,1.2238E-03,1.7310E-02,1.8923E-02,1.8001E-02,
     &1.6509E-02,1.4657E-02,1.2419E-02,9.8548E-03,6.6916E-03,1.4326E-03,
     &2.6619E-02,2.8296E-02,2.6623E-02,2.4187E-02,2.1294E-02,1.7939E-02,
     &1.4103E-02,9.4141E-03,1.6712E-03/
      DATA ((KA(JS,JT, 1, 5),JS=1,9),JT=1,5) /
     &1.5033E-04,2.0446E-03,3.1681E-03,4.0928E-03,4.9645E-03,5.8752E-03,
     &6.8891E-03,9.7460E-03,8.2375E-03,2.0389E-04,2.4966E-03,3.8465E-03,
     &4.9929E-03,6.1245E-03,7.2940E-03,8.7776E-03,1.1499E-02,1.0182E-02,
     &2.6769E-04,3.0079E-03,4.6076E-03,5.9938E-03,7.3703E-03,8.8250E-03,
     &1.0916E-02,1.3468E-02,1.2268E-02,3.4024E-04,3.5831E-03,5.4751E-03,
     &7.1124E-03,8.7423E-03,1.0600E-02,1.2985E-02,1.6757E-02,1.4652E-02,
     &4.2020E-04,4.2180E-03,6.4294E-03,8.3453E-03,1.0248E-02,1.2449E-02,
     &1.5350E-02,1.9955E-02,1.7214E-02/
      DATA ((KA(JS,JT, 2, 5),JS=1,9),JT=1,5) /
     &1.8399E-04,1.8419E-03,2.8498E-03,3.5822E-03,4.2442E-03,4.8814E-03,
     &5.3141E-03,6.9582E-03,6.1890E-03,2.5292E-04,2.2771E-03,3.4958E-03,
     &4.3938E-03,5.2283E-03,6.0330E-03,6.8353E-03,8.0230E-03,7.6976E-03,
     &3.3540E-04,2.7711E-03,4.2257E-03,5.3109E-03,6.3352E-03,7.3450E-03,
     &8.3567E-03,1.0142E-02,9.3716E-03,4.2928E-04,3.3267E-03,5.0595E-03,
     &6.3597E-03,7.5719E-03,8.7753E-03,1.0137E-02,1.2487E-02,1.1226E-02,
     &5.3326E-04,3.9397E-03,5.9807E-03,7.5174E-03,8.9383E-03,1.0365E-02,
     &1.1992E-02,1.4789E-02,1.3251E-02/
      DATA ((KA(JS,JT, 3, 5),JS=1,9),JT=1,5) /
     &2.8126E-04,1.8765E-03,2.6588E-03,3.3485E-03,3.8221E-03,4.1636E-03,
     &4.4682E-03,4.4846E-03,4.3919E-03,3.9449E-04,2.3306E-03,3.3231E-03,
     &4.1650E-03,4.7241E-03,5.1684E-03,5.5884E-03,5.9167E-03,5.5074E-03,
     &5.3269E-04,2.8500E-03,4.0835E-03,5.0834E-03,5.7677E-03,6.3235E-03,
     &6.8829E-03,7.4745E-03,6.8347E-03,6.9304E-04,3.4418E-03,4.9465E-03,
     &6.1263E-03,6.9668E-03,7.6366E-03,8.3133E-03,9.1010E-03,8.2831E-03,
     &8.7133E-04,4.1178E-03,5.9088E-03,7.3026E-03,8.3125E-03,9.0996E-03,
     &9.9113E-03,1.0888E-02,9.8539E-03/
      DATA ((KA(JS,JT, 4, 5),JS=1,9),JT=1,5) /
     &4.2942E-04,2.1209E-03,2.6611E-03,3.0954E-03,3.5092E-03,3.7795E-03,
     &3.7536E-03,3.6803E-03,3.1833E-03,6.1278E-04,2.6801E-03,3.3648E-03,
     &3.9108E-03,4.4289E-03,4.7305E-03,4.7677E-03,4.7187E-03,4.0112E-03,
     &8.4431E-04,3.3316E-03,4.1648E-03,4.8597E-03,5.4829E-03,5.8484E-03,
     &5.9135E-03,5.9451E-03,4.9891E-03,1.1175E-03,4.0506E-03,5.0747E-03,
     &5.9647E-03,6.6966E-03,7.1102E-03,7.2127E-03,7.2668E-03,6.0794E-03,
     &1.4334E-03,4.8948E-03,6.1056E-03,7.2069E-03,8.0737E-03,8.5555E-03,
     &8.6934E-03,8.7560E-03,7.1896E-03/
      DATA ((KA(JS,JT, 5, 5),JS=1,9),JT=1,5) /
     &6.0926E-04,2.3529E-03,2.8355E-03,3.0797E-03,3.2149E-03,3.3400E-03,
     &3.3910E-03,2.9801E-03,2.2681E-03,8.8131E-04,3.0196E-03,3.6353E-03,
     &3.9718E-03,4.1316E-03,4.2694E-03,4.3037E-03,3.9012E-03,2.9392E-03,
     &1.2303E-03,3.8066E-03,4.5787E-03,4.9631E-03,5.1972E-03,5.3645E-03,
     &5.3804E-03,4.9263E-03,3.6983E-03,1.6619E-03,4.7363E-03,5.6662E-03,
     &6.1253E-03,6.4225E-03,6.6560E-03,6.6051E-03,6.0844E-03,4.5482E-03,
     &2.1681E-03,5.8273E-03,6.8808E-03,7.4389E-03,7.8269E-03,8.1204E-03,
     &8.0166E-03,7.4003E-03,5.4950E-03/
      DATA ((KA(JS,JT, 6, 5),JS=1,9),JT=1,5) /
     &8.3319E-04,2.4541E-03,2.9309E-03,3.1239E-03,3.1232E-03,3.0304E-03,
     &2.8953E-03,2.6232E-03,1.6854E-03,1.2038E-03,3.2544E-03,3.8397E-03,
     &4.0740E-03,4.0835E-03,3.9879E-03,3.7753E-03,3.4082E-03,2.1468E-03,
     &1.6852E-03,4.1990E-03,4.9217E-03,5.1945E-03,5.2325E-03,5.0738E-03,
     &4.7918E-03,4.2939E-03,2.6825E-03,2.3055E-03,5.2874E-03,6.1886E-03,
     &6.5148E-03,6.5533E-03,6.3614E-03,5.9949E-03,5.3440E-03,3.2990E-03,
     &3.0550E-03,6.5592E-03,7.6795E-03,8.0591E-03,8.0426E-03,7.8256E-03,
     &7.4185E-03,6.5412E-03,4.0170E-03/
      DATA ((KA(JS,JT, 7, 5),JS=1,9),JT=1,5) /
     &1.2030E-03,2.7895E-03,3.1932E-03,3.3085E-03,3.2497E-03,3.0373E-03,
     &2.6860E-03,2.2491E-03,1.3507E-03,1.7561E-03,3.7366E-03,4.1989E-03,
     &4.3780E-03,4.3275E-03,4.0454E-03,3.5823E-03,2.9962E-03,1.7424E-03,
     &2.4695E-03,4.8641E-03,5.4890E-03,5.7046E-03,5.6266E-03,5.2456E-03,
     &4.6755E-03,3.8694E-03,2.1970E-03,3.4036E-03,6.2572E-03,7.0247E-03,
     &7.3182E-03,7.1220E-03,6.6595E-03,5.9470E-03,4.8905E-03,2.7089E-03,
     &4.5461E-03,7.9331E-03,8.8637E-03,9.1326E-03,8.9102E-03,8.3275E-03,
     &7.4120E-03,6.0989E-03,3.2778E-03/
      DATA ((KA(JS,JT, 8, 5),JS=1,9),JT=1,5) /
     &2.0449E-03,3.7053E-03,4.0860E-03,4.1499E-03,3.9922E-03,3.6227E-03,
     &3.0421E-03,2.2282E-03,1.0954E-03,3.0260E-03,5.1232E-03,5.5625E-03,
     &5.5873E-03,5.3321E-03,4.8458E-03,4.0703E-03,3.0319E-03,1.4218E-03,
     &4.3499E-03,6.8685E-03,7.3484E-03,7.3183E-03,6.9565E-03,6.3086E-03,
     &5.3805E-03,3.9991E-03,1.7827E-03,6.0988E-03,9.0048E-03,9.4728E-03,
     &9.3798E-03,8.9487E-03,8.1669E-03,6.9162E-03,5.1727E-03,2.2090E-03,
     &8.2301E-03,1.1592E-02,1.2058E-02,1.1936E-02,1.1386E-02,1.0345E-02,
     &8.7069E-03,6.5415E-03,2.6879E-03/
      DATA ((KA(JS,JT, 9, 5),JS=1,9),JT=1,5) /
     &6.4341E-03,8.4932E-03,8.6319E-03,8.3108E-03,7.7018E-03,6.7763E-03,
     &5.5115E-03,3.7767E-03,9.5475E-04,9.6759E-03,1.2213E-02,1.2266E-02,
     &1.1725E-02,1.0741E-02,9.3855E-03,7.5654E-03,5.1517E-03,1.1933E-03,
     &1.4274E-02,1.7116E-02,1.6970E-02,1.6030E-02,1.4545E-02,1.2624E-02,
     &1.0092E-02,6.8273E-03,1.4956E-03,2.0348E-02,2.3456E-02,2.2925E-02,
     &2.1415E-02,1.9260E-02,1.6502E-02,1.3098E-02,8.8597E-03,1.8913E-03,
     &2.7947E-02,3.1392E-02,3.0350E-02,2.8042E-02,2.4920E-02,2.1171E-02,
     &1.6720E-02,1.1275E-02,2.3159E-03/
      DATA ((KA(JS,JT,10, 5),JS=1,9),JT=1,5) /
     &2.3218E-02,2.4547E-02,2.3456E-02,2.1452E-02,1.8855E-02,1.5703E-02,
     &1.2047E-02,7.7884E-03,1.4115E-03,3.5352E-02,3.6479E-02,3.4471E-02,
     &3.1299E-02,2.7239E-02,2.2668E-02,1.7318E-02,1.0990E-02,1.7428E-03,
     &5.3041E-02,5.3290E-02,4.9753E-02,4.4634E-02,3.8593E-02,3.1830E-02,
     &2.4004E-02,1.5032E-02,2.1711E-03,7.6819E-02,7.5905E-02,7.0118E-02,
     &6.2386E-02,5.3448E-02,4.3595E-02,3.2572E-02,2.0010E-02,2.6405E-03,
     &1.0741E-01,1.0446E-01,9.5780E-02,8.4676E-02,7.2117E-02,5.8406E-02,
     &4.3338E-02,2.6148E-02,3.0152E-03/
      DATA ((KA(JS,JT,11, 5),JS=1,9),JT=1,5) /
     &3.5267E-02,3.5419E-02,3.3018E-02,2.9652E-02,2.5661E-02,2.1081E-02,
     &1.5812E-02,9.8203E-03,1.5039E-03,5.4088E-02,5.3137E-02,4.9102E-02,
     &4.3719E-02,3.7498E-02,3.0622E-02,2.2914E-02,1.4036E-02,1.8588E-03,
     &8.1309E-02,7.8515E-02,7.1873E-02,6.3455E-02,5.4008E-02,4.3709E-02,
     &3.2277E-02,1.9424E-02,2.2498E-03,1.1800E-01,1.1244E-01,1.0217E-01,
     &8.9567E-02,7.5664E-02,6.0559E-02,4.4387E-02,2.6353E-02,2.7248E-03,
     &1.6472E-01,1.5538E-01,1.4035E-01,1.2265E-01,1.0315E-01,8.2131E-02,
     &5.9771E-02,3.4979E-02,3.2176E-03/
      DATA ((KA(JS,JT,12, 5),JS=1,9),JT=1,5) /
     &3.9647E-02,3.8955E-02,3.5866E-02,3.1882E-02,2.7372E-02,2.2283E-02,
     &1.6581E-02,1.0137E-02,1.4428E-03,6.1147E-02,5.9154E-02,5.3991E-02,
     &4.7633E-02,4.0515E-02,3.2821E-02,2.4231E-02,1.4611E-02,1.7795E-03,
     &9.1962E-02,8.7537E-02,7.9486E-02,6.9739E-02,5.8957E-02,4.7222E-02,
     &3.4488E-02,2.0425E-02,2.1548E-03,1.3375E-01,1.2593E-01,1.1362E-01,
     &9.8983E-02,8.2938E-02,6.5961E-02,4.7849E-02,2.7977E-02,2.5823E-03,
     &1.8619E-01,1.7389E-01,1.5614E-01,1.3563E-01,1.1356E-01,8.9900E-02,
     &6.4743E-02,3.7437E-02,3.0416E-03/
      DATA ((KA(JS,JT,13, 5),JS=1,9),JT=1,5) /
     &3.5348E-02,3.4594E-02,3.1651E-02,2.8032E-02,2.3972E-02,1.9476E-02,
     &1.4520E-02,8.8483E-03,1.2073E-03,5.4657E-02,5.2717E-02,4.7880E-02,
     &4.2169E-02,3.5919E-02,2.9028E-02,2.1424E-02,1.2832E-02,1.4997E-03,
     &8.2593E-02,7.8668E-02,7.1038E-02,6.2226E-02,5.2555E-02,4.1980E-02,
     &3.0595E-02,1.8057E-02,1.8484E-03,1.1968E-01,1.1269E-01,1.0134E-01,
     &8.8277E-02,7.4125E-02,5.9019E-02,4.2726E-02,2.4879E-02,2.2113E-03,
     &1.6694E-01,1.5606E-01,1.3993E-01,1.2146E-01,1.0158E-01,8.0368E-02,
     &5.7742E-02,3.3361E-02,2.6209E-03/
      DATA ((KA(JS,JT, 1, 6),JS=1,9),JT=1,5) /
     &5.8710E-04,3.7447E-03,5.6598E-03,7.4215E-03,9.2308E-03,1.1302E-02,
     &1.3745E-02,1.7130E-02,1.6376E-02,7.1095E-04,4.5295E-03,6.8956E-03,
     &9.1329E-03,1.1441E-02,1.4069E-02,1.7260E-02,2.1984E-02,2.0159E-02,
     &8.4824E-04,5.3994E-03,8.2567E-03,1.1010E-02,1.3909E-02,1.7204E-02,
     &2.1091E-02,2.7132E-02,2.4524E-02,9.9962E-04,6.3675E-03,9.7929E-03,
     &1.3116E-02,1.6664E-02,2.0670E-02,2.5520E-02,3.3009E-02,2.9504E-02,
     &1.1677E-03,7.4449E-03,1.1517E-02,1.5476E-02,1.9740E-02,2.4530E-02,
     &3.0349E-02,3.9385E-02,3.5028E-02/
      DATA ((KA(JS,JT, 2, 6),JS=1,9),JT=1,5) /
     &7.3151E-04,3.6448E-03,5.2016E-03,6.6421E-03,7.9400E-03,9.1018E-03,
     &1.0516E-02,1.2549E-02,1.2514E-02,8.8990E-04,4.4216E-03,6.3659E-03,
     &8.1663E-03,9.8302E-03,1.1392E-02,1.3321E-02,1.6283E-02,1.5469E-02,
     &1.0714E-03,5.2883E-03,7.6564E-03,9.8457E-03,1.1909E-02,1.3940E-02,
     &1.6405E-02,2.0166E-02,1.8847E-02,1.2782E-03,6.2637E-03,9.0995E-03,
     &1.1738E-02,1.4242E-02,1.6761E-02,1.9871E-02,2.4604E-02,2.2753E-02,
     &1.5101E-03,7.3491E-03,1.0728E-02,1.3865E-02,1.6850E-02,1.9892E-02,
     &2.3687E-02,2.9581E-02,2.7171E-02/
      DATA ((KA(JS,JT, 3, 6),JS=1,9),JT=1,5) /
     &1.1614E-03,3.9286E-03,5.2992E-03,6.2920E-03,7.1803E-03,7.9571E-03,
     &8.5455E-03,9.0349E-03,9.0567E-03,1.4526E-03,4.8338E-03,6.5076E-03,
     &7.7704E-03,8.9197E-03,9.9629E-03,1.0799E-02,1.1625E-02,1.1298E-02,
     &1.7725E-03,5.8343E-03,7.8680E-03,9.4298E-03,1.0866E-02,1.2179E-02,
     &1.3264E-02,1.4525E-02,1.3847E-02,2.1368E-03,6.9576E-03,9.3967E-03,
     &1.1298E-02,1.3038E-02,1.4633E-02,1.6013E-02,1.7774E-02,1.6807E-02,
     &2.5530E-03,8.2213E-03,1.1119E-02,1.3386E-02,1.5467E-02,1.7396E-02,
     &1.9105E-02,2.1405E-02,2.0198E-02/
      DATA ((KA(JS,JT, 4, 6),JS=1,9),JT=1,5) /
     &1.8393E-03,4.2719E-03,5.6108E-03,6.4238E-03,6.8867E-03,7.1924E-03,
     &7.4060E-03,7.2862E-03,6.3156E-03,2.3510E-03,5.3330E-03,6.9923E-03,
     &7.9801E-03,8.5829E-03,9.0352E-03,9.3670E-03,9.3790E-03,7.9787E-03,
     &2.9328E-03,6.5477E-03,8.5524E-03,9.7522E-03,1.0523E-02,1.1105E-02,
     &1.1571E-02,1.1684E-02,9.9124E-03,3.6136E-03,7.9708E-03,1.0306E-02,
     &1.1748E-02,1.2708E-02,1.3440E-02,1.4032E-02,1.4271E-02,1.2172E-02,
     &4.3442E-03,9.5761E-03,1.2277E-02,1.3997E-02,1.5163E-02,1.6053E-02,
     &1.6795E-02,1.7163E-02,1.4922E-02/
      DATA ((KA(JS,JT, 5, 6),JS=1,9),JT=1,5) /
     &2.6688E-03,4.8052E-03,5.7832E-03,6.4797E-03,6.8502E-03,6.8218E-03,
     &6.5242E-03,6.0722E-03,4.6753E-03,3.4688E-03,6.1297E-03,7.3230E-03,
     &8.1782E-03,8.6322E-03,8.6195E-03,8.3126E-03,7.8540E-03,5.9385E-03,
     &4.4058E-03,7.6630E-03,9.1013E-03,1.0147E-02,1.0667E-02,1.0680E-02,
     &1.0355E-02,9.8543E-03,7.3828E-03,5.5115E-03,9.4361E-03,1.1163E-02,
     &1.2385E-02,1.2986E-02,1.3010E-02,1.2662E-02,1.2099E-02,9.0803E-03,
     &6.7862E-03,1.1482E-02,1.3563E-02,1.4942E-02,1.5588E-02,1.5643E-02,
     &1.5261E-02,1.4627E-02,1.1026E-02/
      DATA ((KA(JS,JT, 6, 6),JS=1,9),JT=1,5) /
     &3.5724E-03,5.4370E-03,6.0294E-03,6.3914E-03,6.6047E-03,6.5232E-03,
     &6.0277E-03,5.0661E-03,3.1530E-03,4.7182E-03,7.1382E-03,7.8365E-03,
     &8.2706E-03,8.5053E-03,8.3495E-03,7.7282E-03,6.6198E-03,4.1407E-03,
     &6.1150E-03,9.1981E-03,9.9430E-03,1.0464E-02,1.0671E-02,1.0482E-02,
     &9.6931E-03,8.3868E-03,5.3331E-03,7.7447E-03,1.1494E-02,1.2445E-02,
     &1.3024E-02,1.3207E-02,1.2894E-02,1.1946E-02,1.0395E-02,6.6921E-03,
     &9.6796E-03,1.4190E-02,1.5330E-02,1.5967E-02,1.6158E-02,1.5661E-02,
     &1.4492E-02,1.2674E-02,8.2498E-03/
      DATA ((KA(JS,JT, 7, 6),JS=1,9),JT=1,5) /
     &4.9616E-03,6.6121E-03,6.8416E-03,6.8101E-03,6.6768E-03,6.3696E-03,
     &5.8141E-03,4.6733E-03,2.5227E-03,6.6954E-03,8.8189E-03,9.1778E-03,
     &9.1281E-03,8.8939E-03,8.4196E-03,7.6478E-03,6.1227E-03,3.2129E-03,
     &8.9023E-03,1.1584E-02,1.1984E-02,1.1899E-02,1.1446E-02,1.0830E-02,
     &9.7223E-03,7.7935E-03,4.0071E-03,1.1382E-02,1.4883E-02,1.5340E-02,
     &1.5077E-02,1.4572E-02,1.3613E-02,1.2124E-02,9.7242E-03,4.9238E-03,
     &1.4371E-02,1.8723E-02,1.9154E-02,1.8910E-02,1.8193E-02,1.6854E-02,
     &1.4917E-02,1.1939E-02,6.0317E-03/
      DATA ((KA(JS,JT, 8, 6),JS=1,9),JT=1,5) /
     &8.7001E-03,9.7747E-03,9.5071E-03,8.9379E-03,8.2227E-03,7.2962E-03,
     &6.1868E-03,4.7953E-03,2.0794E-03,1.1618E-02,1.3178E-02,1.2958E-02,
     &1.2245E-02,1.1180E-02,9.8759E-03,8.4959E-03,6.4689E-03,2.6798E-03,
     &1.5351E-02,1.7665E-02,1.7319E-02,1.6267E-02,1.4838E-02,1.3188E-02,
     &1.1167E-02,8.4425E-03,3.4113E-03,2.0092E-02,2.2911E-02,2.2431E-02,
     &2.1181E-02,1.9393E-02,1.7119E-02,1.4369E-02,1.0695E-02,4.2567E-03,
     &2.5625E-02,2.9136E-02,2.8640E-02,2.6980E-02,2.4612E-02,2.1703E-02,
     &1.8202E-02,1.3310E-02,5.2101E-03/
      DATA ((KA(JS,JT, 9, 6),JS=1,9),JT=1,5) /
     &2.8411E-02,2.7805E-02,2.5436E-02,2.2677E-02,1.9516E-02,1.5867E-02,
     &1.1958E-02,7.5969E-03,2.0612E-03,3.8814E-02,3.7908E-02,3.4867E-02,
     &3.0948E-02,2.6641E-02,2.1668E-02,1.6345E-02,1.0429E-02,2.5903E-03,
     &5.1537E-02,5.0347E-02,4.6262E-02,4.1144E-02,3.5324E-02,2.8924E-02,
     &2.1923E-02,1.4064E-02,3.2116E-03,6.6909E-02,6.5234E-02,6.0364E-02,
     &5.3943E-02,4.6443E-02,3.8124E-02,2.8947E-02,1.8549E-02,3.8623E-03,
     &8.6078E-02,8.4018E-02,7.7843E-02,6.9506E-02,5.9853E-02,4.9159E-02,
     &3.7146E-02,2.3977E-02,4.6095E-03/
      DATA ((KA(JS,JT,10, 6),JS=1,9),JT=1,5) /
     &1.0479E-01,9.4804E-02,8.4158E-02,7.2419E-02,5.9897E-02,4.7014E-02,
     &3.3513E-02,1.8915E-02,2.3959E-03,1.4593E-01,1.3214E-01,1.1705E-01,
     &1.0074E-01,8.3547E-02,6.5542E-02,4.6772E-02,2.6375E-02,2.8756E-03,
     &1.9678E-01,1.7825E-01,1.5773E-01,1.3590E-01,1.1277E-01,8.8462E-02,
     &6.3144E-02,3.5733E-02,3.4719E-03,2.5901E-01,2.3451E-01,2.0787E-01,
     &1.7931E-01,1.4891E-01,1.1693E-01,8.3230E-02,4.7067E-02,4.3129E-03,
     &3.3485E-01,3.0286E-01,2.6808E-01,2.3135E-01,1.9236E-01,1.5087E-01,
     &1.0672E-01,6.0498E-02,5.2412E-03/
      DATA ((KA(JS,JT,11, 6),JS=1,9),JT=1,5) /
     &1.5729E-01,1.4058E-01,1.2399E-01,1.0596E-01,8.6953E-02,6.7449E-02,
     &4.7388E-02,2.6098E-02,2.4928E-03,2.1957E-01,1.9641E-01,1.7272E-01,
     &1.4763E-01,1.2135E-01,9.4358E-02,6.6246E-02,3.6579E-02,3.1141E-03,
     &2.9796E-01,2.6647E-01,2.3432E-01,2.0028E-01,1.6476E-01,1.2810E-01,
     &8.9989E-02,4.9741E-02,3.7347E-03,3.9483E-01,3.5349E-01,3.1058E-01,
     &2.6565E-01,2.1911E-01,1.7032E-01,1.1939E-01,6.5674E-02,4.4794E-03,
     &5.1293E-01,4.5889E-01,4.0288E-01,3.4402E-01,2.8339E-01,2.1998E-01,
     &1.5383E-01,8.4493E-02,5.3916E-03/
      DATA ((KA(JS,JT,12, 6),JS=1,9),JT=1,5) /
     &1.7496E-01,1.5620E-01,1.3720E-01,1.1692E-01,9.5664E-02,7.3896E-02,
     &5.1517E-02,2.8131E-02,2.4011E-03,2.4535E-01,2.1911E-01,1.9222E-01,
     &1.6394E-01,1.3439E-01,1.0379E-01,7.2409E-02,3.9528E-02,2.9367E-03,
     &3.3489E-01,2.9916E-01,2.6204E-01,2.2337E-01,1.8311E-01,1.4171E-01,
     &9.8967E-02,5.4062E-02,3.5110E-03,4.4645E-01,3.9881E-01,3.4940E-01,
     &2.9764E-01,2.4438E-01,1.8899E-01,1.3169E-01,7.1745E-02,4.2744E-03,
     &5.8440E-01,5.2135E-01,4.5608E-01,3.8804E-01,3.1784E-01,2.4555E-01,
     &1.7082E-01,9.2836E-02,5.0546E-03/
      DATA ((KA(JS,JT,13, 6),JS=1,9),JT=1,5) /
     &1.5548E-01,1.3934E-01,1.2226E-01,1.0396E-01,8.5068E-02,6.5711E-02,
     &4.5702E-02,2.4873E-02,2.0740E-03,2.1897E-01,1.9631E-01,1.7240E-01,
     &1.4676E-01,1.2003E-01,9.2645E-02,6.4538E-02,3.5191E-02,2.5124E-03,
     &3.0093E-01,2.6954E-01,2.3618E-01,2.0119E-01,1.6478E-01,1.2740E-01,
     &8.8848E-02,4.8366E-02,3.0385E-03,4.0480E-01,3.6240E-01,3.1715E-01,
     &2.6983E-01,2.2076E-01,1.7039E-01,1.1847E-01,6.4388E-02,3.6949E-03,
     &5.3109E-01,4.7451E-01,4.1461E-01,3.5239E-01,2.8790E-01,2.2202E-01,
     &1.5435E-01,8.3628E-02,4.3087E-03/
      DATA ((KA(JS,JT, 1, 7),JS=1,9),JT=1,5) /
     &1.3848E-03,7.4265E-03,1.1328E-02,1.5765E-02,2.0617E-02,2.5760E-02,
     &3.1394E-02,3.9174E-02,3.7962E-02,1.6671E-03,8.9945E-03,1.3803E-02,
     &1.9211E-02,2.5130E-02,3.1434E-02,3.8541E-02,4.9244E-02,4.6325E-02,
     &1.9714E-03,1.0738E-02,1.6621E-02,2.3153E-02,3.0242E-02,3.7827E-02,
     &4.6470E-02,6.0286E-02,5.5806E-02,2.3028E-03,1.2683E-02,1.9788E-02,
     &2.7634E-02,3.6042E-02,4.5063E-02,5.5400E-02,7.2329E-02,6.6551E-02,
     &2.6597E-03,1.4839E-02,2.3341E-02,3.2680E-02,4.2600E-02,5.3211E-02,
     &6.5429E-02,8.5816E-02,7.8751E-02/
      DATA ((KA(JS,JT, 2, 7),JS=1,9),JT=1,5) /
     &1.7365E-03,7.5104E-03,1.0855E-02,1.3649E-02,1.6794E-02,2.0487E-02,
     &2.4622E-02,2.9785E-02,2.9296E-02,2.1191E-03,9.1841E-03,1.3246E-02,
     &1.6722E-02,2.0613E-02,2.5164E-02,3.0319E-02,3.7310E-02,3.6002E-02,
     &2.5333E-03,1.1030E-02,1.5921E-02,2.0206E-02,2.4966E-02,3.0432E-02,
     &3.6701E-02,4.5559E-02,4.3603E-02,2.9828E-03,1.3051E-02,1.8932E-02,
     &2.4145E-02,2.9915E-02,3.6454E-02,4.3919E-02,5.4674E-02,5.2233E-02,
     &3.4709E-03,1.5291E-02,2.2279E-02,2.8573E-02,3.5520E-02,4.3284E-02,
     &5.2127E-02,6.5008E-02,6.1979E-02/
      DATA ((KA(JS,JT, 3, 7),JS=1,9),JT=1,5) /
     &2.8092E-03,8.4318E-03,1.1352E-02,1.3672E-02,1.5434E-02,1.6834E-02,
     &1.8680E-02,2.1551E-02,2.1437E-02,3.4524E-03,1.0436E-02,1.4060E-02,
     &1.6891E-02,1.9071E-02,2.0847E-02,2.3206E-02,2.6955E-02,2.6565E-02,
     &4.1827E-03,1.2653E-02,1.7072E-02,2.0477E-02,2.3160E-02,2.5389E-02,
     &2.8361E-02,3.3016E-02,3.2451E-02,4.9958E-03,1.5103E-02,2.0380E-02,
     &2.4512E-02,2.7790E-02,3.0621E-02,3.4270E-02,3.9878E-02,3.9158E-02,
     &5.8802E-03,1.7776E-02,2.4055E-02,2.9030E-02,3.2999E-02,3.6516E-02,
     &4.0970E-02,4.7651E-02,4.6784E-02/
      DATA ((KA(JS,JT, 4, 7),JS=1,9),JT=1,5) /
     &4.5589E-03,1.0079E-02,1.2337E-02,1.3994E-02,1.5249E-02,1.6070E-02,
     &1.6321E-02,1.6191E-02,1.5492E-02,5.6834E-03,1.2638E-02,1.5464E-02,
     &1.7583E-02,1.9154E-02,2.0166E-02,2.0456E-02,2.0438E-02,1.9456E-02,
     &6.9619E-03,1.5492E-02,1.8969E-02,2.1612E-02,2.3568E-02,2.4770E-02,
     &2.5120E-02,2.5223E-02,2.3997E-02,8.4006E-03,1.8644E-02,2.2892E-02,
     &2.6108E-02,2.8487E-02,2.9981E-02,3.0457E-02,3.0724E-02,2.9183E-02,
     &1.0053E-02,2.2099E-02,2.7239E-02,3.1080E-02,3.3975E-02,3.5831E-02,
     &3.6496E-02,3.6989E-02,3.5086E-02/
      DATA ((KA(JS,JT, 5, 7),JS=1,9),JT=1,5) /
     &6.7689E-03,1.1903E-02,1.3648E-02,1.4571E-02,1.5091E-02,1.5249E-02,
     &1.4963E-02,1.3941E-02,1.1072E-02,8.5889E-03,1.5080E-02,1.7390E-02,
     &1.8530E-02,1.9222E-02,1.9473E-02,1.9084E-02,1.7764E-02,1.3833E-02,
     &1.0679E-02,1.8745E-02,2.1599E-02,2.3039E-02,2.3924E-02,2.4268E-02,
     &2.3807E-02,2.2090E-02,1.7335E-02,1.3055E-02,2.2828E-02,2.6303E-02,
     &2.8136E-02,2.9230E-02,2.9685E-02,2.9170E-02,2.7046E-02,2.1372E-02,
     &1.5751E-02,2.7271E-02,3.1547E-02,3.3833E-02,3.5204E-02,3.5707E-02,
     &3.5181E-02,3.2654E-02,2.6029E-02/
      DATA ((KA(JS,JT, 6, 7),JS=1,9),JT=1,5) /
     &9.2094E-03,1.3724E-02,1.5036E-02,1.5371E-02,1.5106E-02,1.4473E-02,
     &1.3532E-02,1.2020E-02,8.1670E-03,1.1986E-02,1.7634E-02,1.9365E-02,
     &1.9834E-02,1.9516E-02,1.8750E-02,1.7602E-02,1.5593E-02,1.0511E-02,
     &1.5180E-02,2.2067E-02,2.4393E-02,2.4963E-02,2.4596E-02,2.3680E-02,
     &2.2274E-02,1.9750E-02,1.3124E-02,1.8879E-02,2.7272E-02,3.0068E-02,
     &3.0821E-02,3.0411E-02,2.9355E-02,2.7616E-02,2.4539E-02,1.6137E-02,
     &2.3118E-02,3.3049E-02,3.6382E-02,3.7419E-02,3.7019E-02,3.5790E-02,
     &3.3628E-02,2.9915E-02,1.9032E-02/
      DATA ((KA(JS,JT, 7, 7),JS=1,9),JT=1,5) /
     &1.3180E-02,1.6672E-02,1.7592E-02,1.7458E-02,1.6513E-02,1.5058E-02,
     &1.3095E-02,1.0650E-02,5.4642E-03,1.7434E-02,2.2125E-02,2.3174E-02,
     &2.2835E-02,2.1611E-02,1.9729E-02,1.7181E-02,1.4117E-02,7.1375E-03,
     &2.2566E-02,2.8274E-02,2.9519E-02,2.9093E-02,2.7592E-02,2.5177E-02,
     &2.2032E-02,1.8185E-02,9.3084E-03,2.8653E-02,3.5321E-02,3.6780E-02,
     &3.6287E-02,3.4434E-02,3.1535E-02,2.7705E-02,2.2900E-02,1.1848E-02,
     &3.5765E-02,4.3430E-02,4.5100E-02,4.4435E-02,4.2245E-02,3.8834E-02,
     &3.4253E-02,2.8260E-02,1.4688E-02/
      DATA ((KA(JS,JT, 8, 7),JS=1,9),JT=1,5) /
     &2.1747E-02,2.4454E-02,2.4292E-02,2.3080E-02,2.1111E-02,1.8543E-02,
     &1.5300E-02,1.1054E-02,4.8558E-03,3.0389E-02,3.3327E-02,3.2926E-02,
     &3.1134E-02,2.8533E-02,2.5003E-02,2.0402E-02,1.4724E-02,6.1788E-03,
     &4.0290E-02,4.3505E-02,4.2950E-02,4.0676E-02,3.7191E-02,3.2422E-02,
     &2.6427E-02,1.9111E-02,7.6799E-03,5.2072E-02,5.5809E-02,5.4895E-02,
     &5.1714E-02,4.6978E-02,4.0907E-02,3.3411E-02,2.4362E-02,9.3208E-03,
     &6.6160E-02,7.0258E-02,6.8654E-02,6.4320E-02,5.8240E-02,5.0667E-02,
     &4.1561E-02,3.0531E-02,1.1097E-02/
      DATA ((KA(JS,JT, 9, 7),JS=1,9),JT=1,5) /
     &6.9879E-02,6.6386E-02,6.1416E-02,5.4862E-02,4.7283E-02,3.9112E-02,
     &2.9846E-02,1.9026E-02,5.0281E-03,9.7072E-02,9.2199E-02,8.5540E-02,
     &7.6855E-02,6.6492E-02,5.4707E-02,4.1549E-02,2.6366E-02,6.3749E-03,
     &1.3274E-01,1.2639E-01,1.1670E-01,1.0412E-01,8.9576E-02,7.3400E-02,
     &5.5548E-02,3.5017E-02,7.9283E-03,1.7725E-01,1.6726E-01,1.5276E-01,
     &1.3606E-01,1.1668E-01,9.5385E-02,7.1895E-02,4.5017E-02,9.7700E-03,
     &2.2900E-01,2.1469E-01,1.9562E-01,1.7346E-01,1.4892E-01,1.2126E-01,
     &9.1015E-02,5.6621E-02,1.1851E-02/
      DATA ((KA(JS,JT,10, 7),JS=1,9),JT=1,5) /
     &2.6110E-01,2.3191E-01,2.0431E-01,1.7643E-01,1.4693E-01,1.1545E-01,
     &8.1908E-02,4.6480E-02,5.5448E-03,3.6304E-01,3.2305E-01,2.8523E-01,
     &2.4612E-01,2.0468E-01,1.6117E-01,1.1489E-01,6.5350E-02,7.0032E-03,
     &5.0185E-01,4.4688E-01,3.9417E-01,3.3909E-01,2.8117E-01,2.2056E-01,
     &1.5648E-01,8.9037E-02,8.6105E-03,6.7448E-01,6.0038E-01,5.2817E-01,
     &4.5305E-01,3.7479E-01,2.9367E-01,2.0933E-01,1.1852E-01,1.0215E-02,
     &8.8770E-01,7.8961E-01,6.9429E-01,5.9500E-01,4.9158E-01,3.8401E-01,
     &2.7292E-01,1.5364E-01,1.2140E-02/
      DATA ((KA(JS,JT,11, 7),JS=1,9),JT=1,5) /
     &4.0532E-01,3.5824E-01,3.1239E-01,2.6732E-01,2.2024E-01,1.7123E-01,
     &1.1969E-01,6.6094E-02,5.4214E-03,5.6606E-01,5.0050E-01,4.3693E-01,
     &3.7301E-01,3.0650E-01,2.3759E-01,1.6618E-01,9.1406E-02,6.5476E-03,
     &7.7109E-01,6.8230E-01,5.9547E-01,5.0803E-01,4.1719E-01,3.2299E-01,
     &2.2593E-01,1.2450E-01,7.8892E-03,1.0345E+00,9.1439E-01,7.9746E-01,
     &6.7877E-01,5.5627E-01,4.3053E-01,3.0103E-01,1.6533E-01,9.6823E-03,
     &1.3462E+00,1.1891E+00,1.0362E+00,8.8065E-01,7.2071E-01,5.5791E-01,
     &3.9044E-01,2.1464E-01,1.1736E-02/
      DATA ((KA(JS,JT,12, 7),JS=1,9),JT=1,5) /
     &4.6420E-01,4.0988E-01,3.5698E-01,3.0422E-01,2.4918E-01,1.9252E-01,
     &1.3423E-01,7.3160E-02,4.7396E-03,6.5450E-01,5.7811E-01,5.0333E-01,
     &4.2804E-01,3.4996E-01,2.7019E-01,1.8778E-01,1.0212E-01,5.9506E-03,
     &8.9348E-01,7.8900E-01,6.8666E-01,5.8272E-01,4.7603E-01,3.6677E-01,
     &2.5473E-01,1.3789E-01,7.3179E-03,1.1756E+00,1.0374E+00,9.0174E-01,
     &7.6533E-01,6.2509E-01,4.8180E-01,3.3511E-01,1.8185E-01,8.9523E-03,
     &1.5297E+00,1.3494E+00,1.1729E+00,9.9401E-01,8.1052E-01,6.2387E-01,
     &4.3290E-01,2.3433E-01,1.0845E-02/
      DATA ((KA(JS,JT,13, 7),JS=1,9),JT=1,5) /
     &4.2167E-01,3.7276E-01,3.2553E-01,2.7726E-01,2.2695E-01,1.7522E-01,
     &1.2184E-01,6.6143E-02,4.0030E-03,6.0140E-01,5.3188E-01,4.6380E-01,
     &3.9365E-01,3.2184E-01,2.4778E-01,1.7190E-01,9.3023E-02,5.1104E-03,
     &8.1807E-01,7.2295E-01,6.3004E-01,5.3457E-01,4.3643E-01,3.3605E-01,
     &2.3292E-01,1.2549E-01,6.4347E-03,1.0778E+00,9.5216E-01,8.2890E-01,
     &7.0211E-01,5.7259E-01,4.4078E-01,3.0511E-01,1.6456E-01,7.8490E-03,
     &1.3868E+00,1.2246E+00,1.0647E+00,9.0150E-01,7.3547E-01,5.6615E-01,
     &3.9191E-01,2.1135E-01,9.6903E-03/
      DATA ((KA(JS,JT, 1, 8),JS=1,9),JT=1,5) /
     &3.5696E-03,1.6007E-02,2.9119E-02,4.2110E-02,5.4860E-02,6.8076E-02,
     &8.3917E-02,1.0558E-01,1.0534E-01,4.2863E-03,1.9722E-02,3.5791E-02,
     &5.1660E-02,6.7170E-02,8.3493E-02,1.0314E-01,1.2980E-01,1.2936E-01,
     &5.0567E-03,2.3939E-02,4.3341E-02,6.2437E-02,8.1028E-02,1.0094E-01,
     &1.2485E-01,1.5697E-01,1.5657E-01,5.8865E-03,2.8699E-02,5.1840E-02,
     &7.4548E-02,9.6669E-02,1.2066E-01,1.4947E-01,1.8794E-01,1.8748E-01,
     &6.7695E-03,3.4031E-02,6.1358E-02,8.8096E-02,1.1420E-01,1.4289E-01,
     &1.7720E-01,2.2237E-01,2.2240E-01/
      DATA ((KA(JS,JT, 2, 8),JS=1,9),JT=1,5) /
     &4.7118E-03,1.5877E-02,2.5399E-02,3.5918E-02,4.6457E-02,5.6939E-02,
     &6.8068E-02,8.4536E-02,8.5555E-02,5.7108E-03,1.9571E-02,3.1487E-02,
     &4.4433E-02,5.7366E-02,7.0154E-02,8.4052E-02,1.0472E-01,1.0570E-01,
     &6.7866E-03,2.3743E-02,3.8403E-02,5.4069E-02,6.9657E-02,8.4997E-02,
     &1.0211E-01,1.2762E-01,1.2838E-01,7.9436E-03,2.8460E-02,4.6231E-02,
     &6.4990E-02,8.3598E-02,1.0182E-01,1.2260E-01,1.5356E-01,1.5440E-01,
     &9.1873E-03,3.3722E-02,5.4999E-02,7.7194E-02,9.9137E-02,1.2068E-01,
     &1.4584E-01,1.8285E-01,1.8375E-01/
      DATA ((KA(JS,JT, 3, 8),JS=1,9),JT=1,5) /
     &7.9289E-03,1.8898E-02,2.5653E-02,3.1610E-02,3.8347E-02,4.5822E-02,
     &5.3494E-02,6.2174E-02,6.4789E-02,9.7250E-03,2.3378E-02,3.1960E-02,
     &3.9650E-02,4.8157E-02,5.7463E-02,6.6987E-02,7.7905E-02,8.1125E-02,
     &1.1690E-02,2.8477E-02,3.9050E-02,4.8735E-02,5.9251E-02,7.0590E-02,
     &8.2118E-02,9.5596E-02,9.9562E-02,1.3819E-02,3.4230E-02,4.7053E-02,
     &5.8936E-02,7.1761E-02,8.5391E-02,9.9148E-02,1.1547E-01,1.2059E-01,
     &1.6126E-02,4.0610E-02,5.5935E-02,7.0350E-02,8.5758E-02,1.0193E-01,
     &1.1815E-01,1.3794E-01,1.4428E-01/
      DATA ((KA(JS,JT, 4, 8),JS=1,9),JT=1,5) /
     &1.3217E-02,2.3479E-02,2.9539E-02,3.3751E-02,3.6721E-02,3.9161E-02,
     &4.2339E-02,4.7025E-02,4.7847E-02,1.6447E-02,2.9417E-02,3.7093E-02,
     &4.2546E-02,4.6456E-02,4.9765E-02,5.3922E-02,5.9724E-02,6.0703E-02,
     &2.0055E-02,3.6163E-02,4.5727E-02,5.2541E-02,5.7472E-02,6.1844E-02,
     &6.7058E-02,7.4090E-02,7.5241E-02,2.4006E-02,4.3785E-02,5.5469E-02,
     &6.3755E-02,6.9920E-02,7.5527E-02,8.2000E-02,9.0387E-02,9.1968E-02,
     &2.8301E-02,5.2295E-02,6.6272E-02,7.6263E-02,8.3883E-02,9.0941E-02,
     &9.8884E-02,1.0876E-01,1.1102E-01/
      DATA ((KA(JS,JT, 5, 8),JS=1,9),JT=1,5) /
     &1.9932E-02,2.8909E-02,3.3929E-02,3.6963E-02,3.8599E-02,3.9090E-02,
     &3.8100E-02,3.6647E-02,3.4570E-02,2.5221E-02,3.6867E-02,4.3184E-02,
     &4.7147E-02,4.9394E-02,5.0060E-02,4.9016E-02,4.7379E-02,4.4959E-02,
     &3.1232E-02,4.5824E-02,5.3773E-02,5.8918E-02,6.1826E-02,6.2626E-02,
     &6.1399E-02,5.9643E-02,5.6358E-02,3.7911E-02,5.5890E-02,6.5835E-02,
     &7.2317E-02,7.5820E-02,7.6769E-02,7.5408E-02,7.3611E-02,6.9498E-02,
     &4.5225E-02,6.7203E-02,7.9322E-02,8.7058E-02,9.1394E-02,9.2728E-02,
     &9.1290E-02,8.9467E-02,8.4545E-02/
      DATA ((KA(JS,JT, 6, 8),JS=1,9),JT=1,5) /
     &2.7668E-02,3.4842E-02,3.8147E-02,3.9719E-02,4.0056E-02,3.9073E-02,
     &3.6625E-02,3.2055E-02,2.4026E-02,3.5525E-02,4.5073E-02,4.9553E-02,
     &5.1630E-02,5.2026E-02,5.0818E-02,4.7728E-02,4.1935E-02,3.1627E-02,
     &4.4689E-02,5.6776E-02,6.2560E-02,6.5413E-02,6.6041E-02,6.4568E-02,
     &6.0721E-02,5.3252E-02,4.0421E-02,5.5122E-02,7.0187E-02,7.7371E-02,
     &8.1166E-02,8.2060E-02,8.0200E-02,7.5289E-02,6.6107E-02,5.0711E-02,
     &6.6674E-02,8.5247E-02,9.4184E-02,9.8741E-02,9.9891E-02,9.7702E-02,
     &9.1660E-02,8.0784E-02,6.3321E-02/
      DATA ((KA(JS,JT, 7, 8),JS=1,9),JT=1,5) /
     &4.0056E-02,4.4898E-02,4.5971E-02,4.5352E-02,4.3659E-02,4.0747E-02,
     &3.6554E-02,3.0205E-02,1.8196E-02,5.2185E-02,5.8633E-02,6.0480E-02,
     &6.0085E-02,5.7874E-02,5.4080E-02,4.8546E-02,4.0072E-02,2.4060E-02,
     &6.6434E-02,7.5122E-02,7.7544E-02,7.7216E-02,7.4584E-02,6.9858E-02,
     &6.2703E-02,5.1788E-02,3.0507E-02,8.3239E-02,9.4089E-02,9.7312E-02,
     &9.7000E-02,9.3885E-02,8.8076E-02,7.9042E-02,6.5047E-02,3.6382E-02,
     &1.0221E-01,1.1561E-01,1.1992E-01,1.1954E-01,1.1572E-01,1.0845E-01,
     &9.7278E-02,8.0126E-02,4.5426E-02/
      DATA ((KA(JS,JT, 8, 8),JS=1,9),JT=1,5) /
     &6.9306E-02,6.9494E-02,6.7600E-02,6.3267E-02,5.7322E-02,5.0091E-02,
     &4.1741E-02,3.1433E-02,1.2053E-02,9.1357E-02,9.2237E-02,8.9335E-02,
     &8.3857E-02,7.6444E-02,6.7451E-02,5.6474E-02,4.2659E-02,1.6127E-02,
     &1.1801E-01,1.1955E-01,1.1588E-01,1.0908E-01,9.9881E-02,8.8243E-02,
     &7.4146E-02,5.6165E-02,2.1600E-02,1.4950E-01,1.5197E-01,1.4749E-01,
     &1.3894E-01,1.2736E-01,1.1271E-01,9.4953E-02,7.1880E-02,2.7972E-02,
     &1.8646E-01,1.8942E-01,1.8392E-01,1.7346E-01,1.5924E-01,1.4113E-01,
     &1.1856E-01,8.9580E-02,3.5566E-02/
      DATA ((KA(JS,JT, 9, 8),JS=1,9),JT=1,5) /
     &2.2096E-01,1.9931E-01,1.8126E-01,1.6106E-01,1.3834E-01,1.1283E-01,
     &8.4790E-02,5.3465E-02,1.3124E-02,3.0111E-01,2.7269E-01,2.4731E-01,
     &2.1828E-01,1.8616E-01,1.5202E-01,1.1457E-01,7.2434E-02,1.6890E-02,
     &3.9547E-01,3.5811E-01,3.2380E-01,2.8636E-01,2.4465E-01,1.9968E-01,
     &1.5075E-01,9.6319E-02,2.1030E-02,5.0622E-01,4.6008E-01,4.1701E-01,
     &3.6806E-01,3.1477E-01,2.5740E-01,1.9504E-01,1.2517E-01,2.5567E-02,
     &6.3970E-01,5.8282E-01,5.2753E-01,4.6589E-01,3.9821E-01,3.2594E-01,
     &2.4744E-01,1.5892E-01,3.0707E-02/
      DATA ((KA(JS,JT,10, 8),JS=1,9),JT=1,5) /
     &7.9609E-01,6.9877E-01,6.0631E-01,5.1323E-01,4.2176E-01,3.3040E-01,
     &2.3557E-01,1.3340E-01,1.8364E-02,1.1185E+00,9.8179E-01,8.5163E-01,
     &7.2111E-01,5.9292E-01,4.6368E-01,3.2777E-01,1.8494E-01,2.2731E-02,
     &1.4977E+00,1.3152E+00,1.1422E+00,9.6927E-01,7.9815E-01,6.2269E-01,
     &4.4054E-01,2.4719E-01,2.7714E-02,1.9588E+00,1.7209E+00,1.4963E+00,
     &1.2699E+00,1.0440E+00,8.1231E-01,5.7215E-01,3.2165E-01,3.3541E-02,
     &2.4948E+00,2.1931E+00,1.9066E+00,1.6194E+00,1.3305E+00,1.0363E+00,
     &7.3187E-01,4.1258E-01,3.9461E-02/
      DATA ((KA(JS,JT,11, 8),JS=1,9),JT=1,5) /
     &1.1786E+00,1.0326E+00,8.9194E-01,7.5040E-01,6.1100E-01,4.7311E-01,
     &3.3100E-01,1.8184E-01,1.9912E-02,1.6577E+00,1.4527E+00,1.2557E+00,
     &1.0583E+00,8.6330E-01,6.6758E-01,4.6659E-01,2.5585E-01,2.4574E-02,
     &2.2529E+00,1.9745E+00,1.7078E+00,1.4395E+00,1.1743E+00,9.0668E-01,
     &6.3142E-01,3.4477E-01,2.9771E-02,2.9660E+00,2.6012E+00,2.2499E+00,
     &1.8975E+00,1.5469E+00,1.1941E+00,8.2956E-01,4.5247E-01,3.5340E-02,
     &3.8252E+00,3.3560E+00,2.9025E+00,2.4493E+00,1.9962E+00,1.5364E+00,
     &1.0662E+00,5.8207E-01,4.0740E-02/
      DATA ((KA(JS,JT,12, 8),JS=1,9),JT=1,5) /
     &1.3334E+00,1.1683E+00,1.0080E+00,8.4695E-01,6.8881E-01,5.3043E-01,
     &3.6715E-01,1.9749E-01,1.8810E-02,1.8510E+00,1.6221E+00,1.4015E+00,
     &1.1795E+00,9.6045E-01,7.4002E-01,5.1281E-01,2.7717E-01,2.2865E-02,
     &2.5252E+00,2.2140E+00,1.9140E+00,1.6128E+00,1.3137E+00,1.0115E+00,
     &6.9957E-01,3.7776E-01,2.7421E-02,3.3724E+00,2.9581E+00,2.5564E+00,
     &2.1530E+00,1.7520E+00,1.3471E+00,9.2947E-01,5.0112E-01,3.2393E-02,
     &4.3792E+00,3.8422E+00,3.3210E+00,2.7983E+00,2.2755E+00,1.7461E+00,
     &1.2059E+00,6.4752E-01,3.7070E-02/
      DATA ((KA(JS,JT,13, 8),JS=1,9),JT=1,5) /
     &1.2116E+00,1.0627E+00,9.1758E-01,7.7277E-01,6.2996E-01,4.8487E-01,
     &3.3536E-01,1.7964E-01,1.5468E-02,1.6818E+00,1.4755E+00,1.2746E+00,
     &1.0748E+00,8.7634E-01,6.7377E-01,4.6518E-01,2.4901E-01,1.8709E-02,
     &2.2861E+00,2.0071E+00,1.7358E+00,1.4644E+00,1.1940E+00,9.1837E-01,
     &6.3513E-01,3.4226E-01,2.2464E-02,3.0747E+00,2.7003E+00,2.3365E+00,
     &1.9712E+00,1.6050E+00,1.2324E+00,8.5082E-01,4.5761E-01,2.6279E-02,
     &4.0462E+00,3.5547E+00,3.0752E+00,2.5948E+00,2.1107E+00,1.6188E+00,
     &1.1159E+00,5.9825E-01,3.0261E-02/
      DATA ((KA(JS,JT, 1, 9),JS=1,9),JT=1,5) /
     &7.9433E-03,4.9696E-02,8.9399E-02,1.2891E-01,1.7031E-01,2.1327E-01,
     &2.5635E-01,2.9834E-01,3.4005E-01,9.5773E-03,6.0610E-02,1.0882E-01,
     &1.5730E-01,2.0827E-01,2.6089E-01,3.1374E-01,3.6559E-01,4.1584E-01,
     &1.1355E-02,7.2723E-02,1.3048E-01,1.8917E-01,2.5096E-01,3.1435E-01,
     &3.7828E-01,4.4211E-01,5.0107E-01,1.3277E-02,8.6204E-02,1.5483E-01,
     &2.2520E-01,2.9933E-01,3.7480E-01,4.5117E-01,5.2865E-01,5.9762E-01,
     &1.5326E-02,1.0116E-01,1.8188E-01,2.6559E-01,3.5380E-01,4.4327E-01,
     &5.3402E-01,6.2664E-01,7.0640E-01/
      DATA ((KA(JS,JT, 2, 9),JS=1,9),JT=1,5) /
     &1.1776E-02,4.7878E-02,8.4972E-02,1.1878E-01,1.5366E-01,1.9061E-01,
     &2.3033E-01,2.7211E-01,3.0314E-01,1.4294E-02,5.8956E-02,1.0416E-01,
     &1.4559E-01,1.8871E-01,2.3457E-01,2.8358E-01,3.3549E-01,3.7290E-01,
     &1.7066E-02,7.1345E-02,1.2565E-01,1.7589E-01,2.2857E-01,2.8471E-01,
     &3.4402E-01,4.0658E-01,4.5272E-01,2.0089E-02,8.5201E-02,1.4972E-01,
     &2.1022E-01,2.7384E-01,3.4170E-01,4.1272E-01,4.8704E-01,5.4350E-01,
     &2.3307E-02,1.0059E-01,1.7602E-01,2.4834E-01,3.2442E-01,4.0570E-01,
     &4.8998E-01,5.7844E-01,6.4523E-01/
      DATA ((KA(JS,JT, 3, 9),JS=1,9),JT=1,5) /
     &2.2348E-02,5.0240E-02,8.0496E-02,1.1072E-01,1.3814E-01,1.6488E-01,
     &1.9401E-01,2.2881E-01,2.5470E-01,2.7442E-02,6.2748E-02,1.0008E-01,
     &1.3702E-01,1.7047E-01,2.0379E-01,2.4015E-01,2.8371E-01,3.1563E-01,
     &3.3066E-02,7.6711E-02,1.2229E-01,1.6700E-01,2.0740E-01,2.4849E-01,
     &2.9339E-01,3.4685E-01,3.8604E-01,3.9269E-02,9.2366E-02,1.4749E-01,
     &2.0103E-01,2.4924E-01,2.9944E-01,3.5443E-01,4.1958E-01,4.6663E-01,
     &4.5933E-02,1.0972E-01,1.7562E-01,2.3869E-01,2.9592E-01,3.5671E-01,
     &4.2354E-01,5.0205E-01,5.5762E-01/
      DATA ((KA(JS,JT, 4, 9),JS=1,9),JT=1,5) /
     &4.2106E-02,6.4369E-02,8.4555E-02,1.0542E-01,1.2690E-01,1.4750E-01,
     &1.6487E-01,1.8576E-01,2.0651E-01,5.2576E-02,8.1026E-02,1.0683E-01,
     &1.3280E-01,1.5950E-01,1.8491E-01,2.0655E-01,2.3307E-01,2.5966E-01,
     &6.4079E-02,9.9622E-02,1.3194E-01,1.6392E-01,1.9672E-01,2.2769E-01,
     &2.5451E-01,2.8781E-01,3.2142E-01,7.6781E-02,1.2036E-01,1.6040E-01,
     &1.9955E-01,2.3909E-01,2.7584E-01,3.0872E-01,3.5017E-01,3.9149E-01,
     &9.0605E-02,1.4314E-01,1.9223E-01,2.3943E-01,2.8645E-01,3.2911E-01,
     &3.6945E-01,4.2071E-01,4.7061E-01/
      DATA ((KA(JS,JT, 5, 9),JS=1,9),JT=1,5) /
     &7.1850E-02,8.9617E-02,1.0358E-01,1.1417E-01,1.2410E-01,1.3445E-01,
     &1.4500E-01,1.5289E-01,1.6393E-01,9.1160E-02,1.1411E-01,1.3218E-01,
     &1.4610E-01,1.5890E-01,1.7194E-01,1.8487E-01,1.9440E-01,2.0899E-01,
     &1.1266E-01,1.4163E-01,1.6452E-01,1.8216E-01,1.9856E-01,2.1504E-01,
     &2.3093E-01,2.4255E-01,2.6179E-01,1.3642E-01,1.7249E-01,2.0078E-01,
     &2.2297E-01,2.4396E-01,2.6433E-01,2.8347E-01,2.9753E-01,3.2213E-01,
     &1.6239E-01,2.0660E-01,2.4114E-01,2.6894E-01,2.9484E-01,3.1958E-01,
     &3.4207E-01,3.5958E-01,3.9095E-01/
      DATA ((KA(JS,JT, 6, 9),JS=1,9),JT=1,5) /
     &1.1140E-01,1.2144E-01,1.3218E-01,1.3718E-01,1.3653E-01,1.3402E-01,
     &1.3174E-01,1.2946E-01,1.2677E-01,1.4420E-01,1.5827E-01,1.7119E-01,
     &1.7776E-01,1.7742E-01,1.7454E-01,1.7134E-01,1.6760E-01,1.6399E-01,
     &1.8124E-01,2.0002E-01,2.1589E-01,2.2389E-01,2.2423E-01,2.2127E-01,
     &2.1711E-01,2.1204E-01,2.0793E-01,2.2248E-01,2.4636E-01,2.6609E-01,
     &2.7594E-01,2.7715E-01,2.7479E-01,2.7017E-01,2.6283E-01,2.5856E-01,
     &2.6774E-01,2.9748E-01,3.2183E-01,3.3450E-01,3.3675E-01,3.3499E-01,
     &3.3006E-01,3.2020E-01,3.1680E-01/
      DATA ((KA(JS,JT, 7, 9),JS=1,9),JT=1,5) /
     &1.7732E-01,1.7534E-01,1.7803E-01,1.7714E-01,1.7022E-01,1.5702E-01,
     &1.3821E-01,1.1726E-01,9.2624E-02,2.3477E-01,2.3316E-01,2.3664E-01,
     &2.3403E-01,2.2497E-01,2.0771E-01,1.8285E-01,1.5521E-01,1.2312E-01,
     &3.0054E-01,2.9947E-01,3.0371E-01,2.9989E-01,2.8797E-01,2.6596E-01,
     &2.3476E-01,1.9945E-01,1.5929E-01,3.7459E-01,3.7495E-01,3.7937E-01,
     &3.7465E-01,3.5915E-01,3.3235E-01,2.9471E-01,2.5108E-01,2.0370E-01,
     &4.5653E-01,4.5857E-01,4.6346E-01,4.5781E-01,4.3887E-01,4.0748E-01,
     &3.6268E-01,3.0976E-01,2.5195E-01/
      DATA ((KA(JS,JT, 8, 9),JS=1,9),JT=1,5) /
     &3.3219E-01,3.0467E-01,2.8618E-01,2.6721E-01,2.4601E-01,2.1811E-01,
     &1.8145E-01,1.3269E-01,6.6401E-02,4.4950E-01,4.1374E-01,3.8999E-01,
     &3.6461E-01,3.3388E-01,2.9490E-01,2.4508E-01,1.7935E-01,9.0026E-02,
     &5.8717E-01,5.4166E-01,5.1100E-01,4.7736E-01,4.3579E-01,3.8461E-01,
     &3.1925E-01,2.3358E-01,1.1833E-01,7.4406E-01,6.8778E-01,6.4996E-01,
     &6.0622E-01,5.5241E-01,4.8728E-01,4.0419E-01,2.9657E-01,1.5189E-01,
     &9.1907E-01,8.5125E-01,8.0569E-01,7.5012E-01,6.8369E-01,6.0185E-01,
     &4.9995E-01,3.6832E-01,1.9101E-01/
      DATA ((KA(JS,JT, 9, 9),JS=1,9),JT=1,5) /
     &1.1485E+00,1.0089E+00,8.7880E-01,7.5762E-01,6.3622E-01,5.1377E-01,
     &3.9068E-01,2.5323E-01,5.4057E-02,1.5919E+00,1.3983E+00,1.2193E+00,
     &1.0539E+00,8.8759E-01,7.1827E-01,5.4603E-01,3.5236E-01,7.3567E-02,
     &2.1202E+00,1.8629E+00,1.6282E+00,1.4084E+00,1.1875E+00,9.6283E-01,
     &7.2992E-01,4.6911E-01,9.7269E-02,2.7354E+00,2.4050E+00,2.1038E+00,
     &1.8214E+00,1.5366E+00,1.2471E+00,9.4177E-01,6.0391E-01,1.2338E-01,
     &3.4317E+00,3.0176E+00,2.6421E+00,2.2877E+00,1.9310E+00,1.5677E+00,
     &1.1814E+00,7.5635E-01,1.5353E-01/
      DATA ((KA(JS,JT,10, 9),JS=1,9),JT=1,5) /
     &4.4436E+00,3.8882E+00,3.3348E+00,2.7888E+00,2.2477E+00,1.7134E+00,
     &1.1871E+00,6.5782E-01,7.0663E-02,6.2997E+00,5.5124E+00,4.7288E+00,
     &3.9559E+00,3.1897E+00,2.4334E+00,1.6915E+00,9.3954E-01,8.7418E-02,
     &8.5619E+00,7.4925E+00,6.4279E+00,5.3771E+00,4.3365E+00,3.3136E+00,
     &2.3060E+00,1.2843E+00,1.0436E-01,1.1219E+01,9.8180E+00,8.4228E+00,
     &7.0486E+00,5.6898E+00,4.3532E+00,3.0319E+00,1.6916E+00,1.2593E-01,
     &1.4295E+01,1.2510E+01,1.0734E+01,8.9819E+00,7.2530E+00,5.5514E+00,
     &3.8643E+00,2.1564E+00,1.5004E-01/
      DATA ((KA(JS,JT,11, 9),JS=1,9),JT=1,5) /
     &7.0050E+00,6.1296E+00,5.2549E+00,4.3868E+00,3.5242E+00,2.6669E+00,
     &1.8245E+00,9.8168E-01,8.5745E-02,9.9554E+00,8.7114E+00,7.4687E+00,
     &6.2351E+00,5.0098E+00,3.7942E+00,2.5980E+00,1.4001E+00,1.0478E-01,
     &1.3533E+01,1.1842E+01,1.0152E+01,8.4771E+00,6.8123E+00,5.1640E+00,
     &3.5405E+00,1.9111E+00,1.2573E-01,1.7771E+01,1.5551E+01,1.3333E+01,
     &1.1134E+01,8.9512E+00,6.7876E+00,4.6577E+00,2.5172E+00,1.4855E-01,
     &2.2680E+01,1.9846E+01,1.7019E+01,1.4214E+01,1.1430E+01,8.6745E+00,
     &5.9538E+00,3.2175E+00,1.7203E-01/
      DATA ((KA(JS,JT,12, 9),JS=1,9),JT=1,5) /
     &8.1047E+00,7.0920E+00,6.0802E+00,5.0761E+00,4.0767E+00,3.0841E+00,
     &2.1058E+00,1.1266E+00,9.0852E-02,1.1567E+01,1.0121E+01,8.6775E+00,
     &7.2441E+00,5.8181E+00,4.4027E+00,3.0080E+00,1.6091E+00,1.1081E-01,
     &1.5756E+01,1.3787E+01,1.1820E+01,9.8684E+00,7.9263E+00,6.0014E+00,
     &4.1030E+00,2.1969E+00,1.3256E-01,2.0731E+01,1.8141E+01,1.5554E+01,
     &1.2989E+01,1.0436E+01,7.9047E+00,5.4071E+00,2.8962E+00,1.5690E-01,
     &2.6483E+01,2.3176E+01,1.9872E+01,1.6594E+01,1.3339E+01,1.0111E+01,
     &6.9150E+00,3.7095E+00,1.8186E-01/
      DATA ((KA(JS,JT,13, 9),JS=1,9),JT=1,5) /
     &7.4699E+00,6.5364E+00,5.6062E+00,4.6835E+00,3.7650E+00,2.8555E+00,
     &1.9560E+00,1.0515E+00,8.5273E-02,1.0680E+01,9.3454E+00,8.0165E+00,
     &6.6976E+00,5.3854E+00,4.0877E+00,2.8036E+00,1.5078E+00,1.0411E-01,
     &1.4620E+01,1.2793E+01,1.0973E+01,9.1678E+00,7.3735E+00,5.5972E+00,
     &3.8382E+00,2.0618E+00,1.2386E-01,1.9258E+01,1.6852E+01,1.4455E+01,
     &1.2079E+01,9.7197E+00,7.3817E+00,5.0639E+00,2.7225E+00,1.4610E-01,
     &2.4621E+01,2.1546E+01,1.8485E+01,1.5448E+01,1.2432E+01,9.4454E+00,
     &6.4771E+00,3.4853E+00,1.7007E-01/
      DATA ((KA(JS,JT, 1,10),JS=1,9),JT=1,5) /
     &1.3879E-02,1.0986E-01,1.9192E-01,2.8700E-01,3.8129E-01,4.7527E-01,
     &5.7067E-01,6.6779E-01,7.6243E-01,1.6954E-02,1.3303E-01,2.3564E-01,
     &3.5200E-01,4.6702E-01,5.8054E-01,6.9523E-01,8.1372E-01,9.3367E-01,
     &2.0369E-02,1.5906E-01,2.8523E-01,4.2640E-01,5.6627E-01,7.0405E-01,
     &8.3748E-01,9.6604E-01,1.1321E+00,2.4061E-02,1.8742E-01,3.4065E-01,
     &5.0987E-01,6.7810E-01,8.4492E-01,1.0078E+00,1.1403E+00,1.3558E+00,
     &2.7911E-02,2.1680E-01,4.0347E-01,6.0365E-01,8.0163E-01,9.9663E-01,
     &1.1842E+00,1.3430E+00,1.6028E+00/
      DATA ((KA(JS,JT, 2,10),JS=1,9),JT=1,5) /
     &2.2158E-02,1.1276E-01,1.8891E-01,2.7518E-01,3.6524E-01,4.5317E-01,
     &5.3652E-01,6.1296E-01,7.3020E-01,2.7256E-02,1.3808E-01,2.3100E-01,
     &3.4051E-01,4.5180E-01,5.6015E-01,6.6160E-01,7.4973E-01,9.0314E-01,
     &3.2742E-02,1.6645E-01,2.7575E-01,4.1007E-01,5.4427E-01,6.7555E-01,
     &8.0050E-01,9.1019E-01,1.0879E+00,3.8593E-02,1.9807E-01,3.2475E-01,
     &4.8552E-01,6.4531E-01,8.0341E-01,9.5786E-01,1.0994E+00,1.2898E+00,
     &4.4713E-02,2.3139E-01,3.8401E-01,5.7431E-01,7.6329E-01,9.5026E-01,
     &1.1317E+00,1.3007E+00,1.5256E+00/
      DATA ((KA(JS,JT, 3,10),JS=1,9),JT=1,5) /
     &4.4889E-02,1.1945E-01,1.9910E-01,2.6592E-01,3.2716E-01,4.0820E-01,
     &4.8832E-01,5.6450E-01,6.5333E-01,5.6096E-02,1.4847E-01,2.4845E-01,
     &3.3071E-01,4.1171E-01,5.1418E-01,6.1578E-01,7.1081E-01,8.2224E-01,
     &6.8702E-02,1.8161E-01,3.0124E-01,3.9617E-01,5.0089E-01,6.2554E-01,
     &7.4933E-01,8.6662E-01,1.0003E+00,8.1949E-02,2.1813E-01,3.5788E-01,
     &4.6675E-01,6.0112E-01,7.4982E-01,8.9722E-01,1.0369E+00,1.1996E+00,
     &9.5752E-02,2.5792E-01,4.1860E-01,5.4742E-01,7.1669E-01,8.9255E-01,
     &1.0648E+00,1.2234E+00,1.4293E+00/
      DATA ((KA(JS,JT, 4,10),JS=1,9),JT=1,5) /
     &9.2779E-02,1.3647E-01,2.0374E-01,2.6880E-01,3.2474E-01,3.6630E-01,
     &4.2915E-01,4.9644E-01,5.7357E-01,1.1604E-01,1.7477E-01,2.5924E-01,
     &3.4288E-01,4.1143E-01,4.5661E-01,5.3933E-01,6.2792E-01,7.1853E-01,
     &1.4325E-01,2.1810E-01,3.2204E-01,4.2345E-01,5.0270E-01,5.5390E-01,
     &6.5839E-01,7.6862E-01,8.7526E-01,1.7320E-01,2.6694E-01,3.8938E-01,
     &5.0945E-01,6.0406E-01,6.6936E-01,8.0058E-01,9.3405E-01,1.0639E+00,
     &2.0528E-01,3.2153E-01,4.6268E-01,6.0392E-01,7.1636E-01,8.0678E-01,
     &9.6596E-01,1.1248E+00,1.2848E+00/
      DATA ((KA(JS,JT, 5,10),JS=1,9),JT=1,5) /
     &1.7241E-01,1.8815E-01,2.2088E-01,2.6810E-01,3.2220E-01,3.6810E-01,
     &3.9585E-01,4.3476E-01,4.9559E-01,2.1928E-01,2.4297E-01,2.8762E-01,
     &3.4907E-01,4.1506E-01,4.6919E-01,4.9756E-01,5.5222E-01,6.2884E-01,
     &2.7265E-01,3.0607E-01,3.6483E-01,4.4370E-01,5.1761E-01,5.7690E-01,
     &6.0530E-01,6.7866E-01,7.7290E-01,3.3288E-01,3.7610E-01,4.5166E-01,
     &5.4662E-01,6.2951E-01,6.9865E-01,7.2973E-01,8.2842E-01,9.4575E-01,
     &3.9915E-01,4.5195E-01,5.4707E-01,6.6103E-01,7.5773E-01,8.3891E-01,
     &8.7097E-01,1.0005E+00,1.1404E+00/
      DATA ((KA(JS,JT, 6,10),JS=1,9),JT=1,5) /
     &2.9778E-01,2.8967E-01,2.9242E-01,2.9076E-01,3.1606E-01,3.5216E-01,
     &3.7514E-01,3.6360E-01,4.0286E-01,3.8364E-01,3.7347E-01,3.8384E-01,
     &3.8402E-01,4.1811E-01,4.6141E-01,4.8908E-01,4.6937E-01,5.2349E-01,
     &4.8196E-01,4.7366E-01,4.8805E-01,4.9747E-01,5.3761E-01,5.8138E-01,
     &6.1239E-01,5.8662E-01,6.5890E-01,5.9004E-01,5.9246E-01,6.0698E-01,
     &6.2535E-01,6.7125E-01,7.1432E-01,7.4926E-01,7.2627E-01,8.2202E-01,
     &7.1225E-01,7.2336E-01,7.3969E-01,7.6299E-01,8.2248E-01,8.6951E-01,
     &9.0679E-01,8.7991E-01,1.0003E+00/
      DATA ((KA(JS,JT, 7,10),JS=1,9),JT=1,5) /
     &5.2983E-01,4.8709E-01,4.4813E-01,4.1883E-01,3.8710E-01,3.5910E-01,
     &3.5198E-01,3.4364E-01,3.2708E-01,6.9820E-01,6.4182E-01,5.9773E-01,
     &5.6199E-01,5.1585E-01,4.8198E-01,4.7538E-01,4.5593E-01,4.2838E-01,
     &8.9166E-01,8.2011E-01,7.7520E-01,7.2195E-01,6.6977E-01,6.2908E-01,
     &6.1720E-01,5.8358E-01,5.4876E-01,1.1048E+00,1.0150E+00,9.7493E-01,
     &9.0555E-01,8.5261E-01,7.9496E-01,7.7495E-01,7.2954E-01,6.9328E-01,
     &1.3386E+00,1.2295E+00,1.1950E+00,1.1151E+00,1.0543E+00,9.8064E-01,
     &9.5591E-01,8.9484E-01,8.5404E-01/
      DATA ((KA(JS,JT, 8,10),JS=1,9),JT=1,5) /
     &1.0881E+00,9.5225E-01,8.5699E-01,7.4043E-01,6.3719E-01,5.4699E-01,
     &4.4366E-01,3.3722E-01,2.5365E-01,1.4729E+00,1.2892E+00,1.1603E+00,
     &1.0057E+00,8.7735E-01,7.4624E-01,6.0685E-01,4.5839E-01,3.4968E-01,
     &1.9193E+00,1.6816E+00,1.5156E+00,1.3265E+00,1.1534E+00,9.7741E-01,
     &7.9951E-01,6.0809E-01,4.5275E-01,2.4196E+00,2.1220E+00,1.9097E+00,
     &1.6942E+00,1.4693E+00,1.2439E+00,1.0194E+00,7.8139E-01,5.7536E-01,
     &2.9662E+00,2.6064E+00,2.3390E+00,2.0966E+00,1.8122E+00,1.5517E+00,
     &1.2698E+00,9.8175E-01,7.1420E-01/
      DATA ((KA(JS,JT, 9,10),JS=1,9),JT=1,5) /
     &4.0693E+00,3.5609E+00,3.0521E+00,2.5470E+00,2.0946E+00,1.6231E+00,
     &1.1342E+00,6.9341E-01,2.3254E-01,5.6525E+00,4.9459E+00,4.2396E+00,
     &3.5367E+00,2.9143E+00,2.2533E+00,1.5867E+00,9.6567E-01,2.9706E-01,
     &7.5336E+00,6.5921E+00,5.6502E+00,4.7197E+00,3.8915E+00,3.0030E+00,
     &2.1420E+00,1.2862E+00,3.6402E-01,9.6696E+00,8.4608E+00,7.2526E+00,
     &6.0675E+00,4.9886E+00,3.8558E+00,2.7779E+00,1.6618E+00,4.0961E-01,
     &1.2059E+01,1.0552E+01,9.0447E+00,7.5858E+00,6.2136E+00,4.8233E+00,
     &3.4799E+00,2.0915E+00,3.7531E-01/
      DATA ((KA(JS,JT,10,10),JS=1,9),JT=1,5) /
     &1.7088E+01,1.4952E+01,1.2816E+01,1.0681E+01,8.5444E+00,6.4081E+00,
     &4.3169E+00,2.2612E+00,1.5325E-01,2.4265E+01,2.1232E+01,1.8199E+01,
     &1.5167E+01,1.2132E+01,9.0996E+00,6.1194E+00,3.2115E+00,2.0907E-01,
     &3.2859E+01,2.8752E+01,2.4646E+01,2.0537E+01,1.6430E+01,1.2323E+01,
     &8.2885E+00,4.3528E+00,2.8093E-01,4.2869E+01,3.7512E+01,3.2153E+01,
     &2.6795E+01,2.1435E+01,1.6077E+01,1.0833E+01,5.6764E+00,3.4638E-01,
     &5.4098E+01,4.7336E+01,4.0575E+01,3.3816E+01,2.7052E+01,2.0291E+01,
     &1.3707E+01,7.1952E+00,4.8935E-01/
      DATA ((KA(JS,JT,11,10),JS=1,9),JT=1,5) /
     &2.9317E+01,2.5652E+01,2.1987E+01,1.8324E+01,1.4658E+01,1.0994E+01,
     &7.3313E+00,3.7877E+00,2.2554E-01,4.1549E+01,3.6355E+01,3.1162E+01,
     &2.5968E+01,2.0775E+01,1.5581E+01,1.0388E+01,5.3868E+00,2.3983E-01,
     &5.6191E+01,4.9168E+01,4.2143E+01,3.5117E+01,2.8096E+01,2.1071E+01,
     &1.4052E+01,7.2903E+00,2.8347E-01,7.3162E+01,6.4016E+01,5.4871E+01,
     &4.5729E+01,3.6583E+01,2.7439E+01,1.8309E+01,9.4965E+00,3.4363E-01,
     &9.2126E+01,8.0611E+01,6.9095E+01,5.7582E+01,4.6068E+01,3.4554E+01,
     &2.3073E+01,1.1954E+01,4.6470E-01/
      DATA ((KA(JS,JT,12,10),JS=1,9),JT=1,5) /
     &3.6684E+01,3.2099E+01,2.7514E+01,2.2927E+01,1.8342E+01,1.3757E+01,
     &9.1743E+00,4.7217E+00,2.6068E-01,5.1868E+01,4.5387E+01,3.8901E+01,
     &3.2419E+01,2.5934E+01,1.9452E+01,1.2967E+01,6.6916E+00,2.7916E-01,
     &7.0081E+01,6.1322E+01,5.2561E+01,4.3801E+01,3.5043E+01,2.6282E+01,
     &1.7526E+01,9.0530E+00,3.3145E-01,9.0957E+01,7.9591E+01,6.8227E+01,
     &5.6859E+01,4.5488E+01,3.4114E+01,2.2760E+01,1.1751E+01,3.6053E-01,
     &1.1478E+02,1.0044E+02,8.6086E+01,7.1743E+01,5.7394E+01,4.3046E+01,
     &2.8737E+01,1.4814E+01,4.5144E-01/
      DATA ((KA(JS,JT,13,10),JS=1,9),JT=1,5) /
     &3.5965E+01,3.1472E+01,2.6975E+01,2.2479E+01,1.7984E+01,1.3488E+01,
     &9.0232E+00,4.6648E+00,2.4705E-01,5.0800E+01,4.4451E+01,3.8101E+01,
     &3.1752E+01,2.5403E+01,1.9053E+01,1.2739E+01,6.5982E+00,2.8941E-01,
     &6.8393E+01,5.9846E+01,5.1296E+01,4.2746E+01,3.4199E+01,2.5650E+01,
     &1.7151E+01,8.8890E+00,3.3776E-01,8.8957E+01,7.7837E+01,6.6721E+01,
     &5.5604E+01,4.4485E+01,3.3364E+01,2.2331E+01,1.1554E+01,3.9400E-01,
     &1.1248E+02,9.8422E+01,8.4359E+01,7.0296E+01,5.6240E+01,4.2182E+01,
     &2.8274E+01,1.4614E+01,4.6294E-01/
      DATA ((KA(JS,JT, 1,11),JS=1,9),JT=1,5) /
     &2.0991E-02,1.4510E-01,2.7530E-01,4.1253E-01,5.4888E-01,6.8317E-01,
     &8.1040E-01,9.0204E-01,1.0977E+00,2.6377E-02,1.7420E-01,3.3534E-01,
     &5.0284E-01,6.6978E-01,8.3508E-01,9.9362E-01,1.1152E+00,1.3395E+00,
     &3.2301E-02,2.0470E-01,4.0014E-01,5.9936E-01,7.9730E-01,9.9294E-01,
     &1.1840E+00,1.3371E+00,1.5943E+00,3.8610E-02,2.3990E-01,4.7445E-01,
     &7.0939E-01,9.4186E-01,1.1687E+00,1.3842E+00,1.5657E+00,1.8832E+00,
     &4.5285E-02,2.8044E-01,5.5866E-01,8.3454E-01,1.1074E+00,1.3742E+00,
     &1.6243E+00,1.8087E+00,2.2141E+00/
      DATA ((KA(JS,JT, 2,11),JS=1,9),JT=1,5) /
     &3.0334E-02,1.5806E-01,2.5391E-01,3.8056E-01,5.0695E-01,6.3318E-01,
     &7.5908E-01,8.7813E-01,1.0138E+00,3.8224E-02,1.9234E-01,3.1173E-01,
     &4.6706E-01,6.2209E-01,7.7707E-01,9.3334E-01,1.0857E+00,1.2438E+00,
     &4.7042E-02,2.2793E-01,3.7775E-01,5.6573E-01,7.5275E-01,9.3856E-01,
     &1.1227E+00,1.3034E+00,1.5049E+00,5.6790E-02,2.6663E-01,4.5515E-01,
     &6.8101E-01,9.0489E-01,1.1244E+00,1.3363E+00,1.5352E+00,1.8090E+00,
     &6.7198E-02,3.0909E-01,5.3855E-01,8.0620E-01,1.0720E+00,1.3339E+00,
     &1.5872E+00,1.8075E+00,2.1432E+00/
      DATA ((KA(JS,JT, 3,11),JS=1,9),JT=1,5) /
     &5.8386E-02,1.7533E-01,2.7134E-01,3.4280E-01,4.5327E-01,5.6550E-01,
     &6.7606E-01,7.8244E-01,9.0646E-01,7.4136E-02,2.1912E-01,3.3311E-01,
     &4.2266E-01,5.6203E-01,7.0075E-01,8.3707E-01,9.6959E-01,1.1236E+00,
     &9.1573E-02,2.6509E-01,4.0096E-01,5.1730E-01,6.8812E-01,8.5747E-01,
     &1.0237E+00,1.1823E+00,1.3753E+00,1.1115E-01,3.1410E-01,4.7626E-01,
     &6.2447E-01,8.3118E-01,1.0365E+00,1.2383E+00,1.4280E+00,1.6615E+00,
     &1.3245E-01,3.6725E-01,5.5683E-01,7.4336E-01,9.8988E-01,1.2355E+00,
     &1.4780E+00,1.7132E+00,1.9788E+00/
      DATA ((KA(JS,JT, 4,11),JS=1,9),JT=1,5) /
     &1.1641E-01,1.9770E-01,2.9439E-01,3.7525E-01,4.3722E-01,5.0094E-01,
     &6.0009E-01,6.9731E-01,8.0196E-01,1.4966E-01,2.5765E-01,3.7252E-01,
     &4.6834E-01,5.4216E-01,6.3606E-01,7.6075E-01,8.7975E-01,1.0184E+00,
     &1.8710E-01,3.2245E-01,4.5679E-01,5.7205E-01,6.6194E-01,7.9151E-01,
     &9.4643E-01,1.0919E+00,1.2671E+00,2.2853E-01,3.9201E-01,5.5041E-01,
     &6.8810E-01,7.8876E-01,9.5787E-01,1.1458E+00,1.3241E+00,1.5335E+00,
     &2.7304E-01,4.6530E-01,6.5411E-01,8.1513E-01,9.2682E-01,1.1406E+00,
     &1.3653E+00,1.5825E+00,1.8252E+00/
      DATA ((KA(JS,JT, 5,11),JS=1,9),JT=1,5) /
     &2.2361E-01,2.4318E-01,3.1539E-01,3.9443E-01,4.5716E-01,5.0109E-01,
     &5.2154E-01,6.0679E-01,6.9571E-01,2.8781E-01,3.2451E-01,4.1536E-01,
     &5.0630E-01,5.8344E-01,6.3855E-01,6.7297E-01,7.8266E-01,8.9726E-01,
     &3.6159E-01,4.1915E-01,5.2707E-01,6.2976E-01,7.2674E-01,7.9740E-01,
     &8.4985E-01,9.8938E-01,1.1325E+00,4.4416E-01,5.2452E-01,6.5017E-01,
     &7.6880E-01,8.8658E-01,9.6270E-01,1.0399E+00,1.2125E+00,1.3846E+00,
     &5.3394E-01,6.3638E-01,7.8407E-01,9.2197E-01,1.0572E+00,1.1328E+00,
     &1.2555E+00,1.4611E+00,1.6711E+00/
      DATA ((KA(JS,JT, 6,11),JS=1,9),JT=1,5) /
     &3.9154E-01,3.6960E-01,3.6660E-01,4.0826E-01,4.6123E-01,5.0084E-01,
     &5.2154E-01,5.2728E-01,6.0320E-01,5.1275E-01,4.8556E-01,4.9732E-01,
     &5.4788E-01,6.0699E-01,6.5333E-01,6.7418E-01,6.8648E-01,7.8580E-01,
     &6.5141E-01,6.2128E-01,6.5130E-01,7.0712E-01,7.7202E-01,8.3303E-01,
     &8.5314E-01,8.6953E-01,9.9315E-01,8.1112E-01,7.6989E-01,8.2193E-01,
     &8.8492E-01,9.6073E-01,1.0362E+00,1.0443E+00,1.0666E+00,1.2159E+00,
     &9.8628E-01,9.3596E-01,1.0065E+00,1.0840E+00,1.1687E+00,1.2489E+00,
     &1.2474E+00,1.2983E+00,1.4796E+00/
      DATA ((KA(JS,JT, 7,11),JS=1,9),JT=1,5) /
     &6.9811E-01,6.2404E-01,5.7431E-01,5.2596E-01,5.0219E-01,5.1011E-01,
     &5.2289E-01,4.9946E-01,5.0228E-01,9.3257E-01,8.3430E-01,7.6751E-01,
     &7.1360E-01,6.8353E-01,6.8813E-01,6.9358E-01,6.6018E-01,6.7200E-01,
     &1.1984E+00,1.0755E+00,9.9660E-01,9.4008E-01,8.9760E-01,8.9906E-01,
     &8.9631E-01,8.4016E-01,8.6247E-01,1.5061E+00,1.3555E+00,1.2704E+00,
     &1.2009E+00,1.1418E+00,1.1469E+00,1.1302E+00,1.0283E+00,1.0687E+00,
     &1.8551E+00,1.6736E+00,1.5791E+00,1.4850E+00,1.4175E+00,1.4225E+00,
     &1.3804E+00,1.2333E+00,1.3098E+00/
      DATA ((KA(JS,JT, 8,11),JS=1,9),JT=1,5) /
     &1.4751E+00,1.2907E+00,1.1413E+00,9.9788E-01,8.3765E-01,7.0312E-01,
     &5.8437E-01,5.1212E-01,4.0848E-01,2.0110E+00,1.7597E+00,1.5595E+00,
     &1.3603E+00,1.1539E+00,9.7291E-01,7.9698E-01,7.0110E-01,5.5259E-01,
     &2.6286E+00,2.3001E+00,2.0385E+00,1.7785E+00,1.5362E+00,1.2889E+00,
     &1.0590E+00,9.2250E-01,7.2275E-01,3.3350E+00,2.9182E+00,2.5850E+00,
     &2.2617E+00,1.9780E+00,1.6580E+00,1.3758E+00,1.1729E+00,9.1532E-01,
     &4.1346E+00,3.6181E+00,3.2106E+00,2.8264E+00,2.4835E+00,2.0714E+00,
     &1.7385E+00,1.4468E+00,1.1430E+00/
      DATA ((KA(JS,JT, 9,11),JS=1,9),JT=1,5) /
     &5.7681E+00,5.0468E+00,4.3260E+00,3.6050E+00,2.9109E+00,2.2673E+00,
     &1.5776E+00,9.1302E-01,3.3856E-01,8.0519E+00,7.0463E+00,6.0395E+00,
     &5.0331E+00,4.0586E+00,3.1762E+00,2.2073E+00,1.2968E+00,3.9705E-01,
     &1.0740E+01,9.3971E+00,8.0549E+00,6.7129E+00,5.4190E+00,4.2355E+00,
     &2.9531E+00,1.7521E+00,4.0437E-01,1.3840E+01,1.2110E+01,1.0380E+01,
     &8.6502E+00,7.0077E+00,5.4549E+00,3.8354E+00,2.2704E+00,5.4385E-01,
     &1.7291E+01,1.5129E+01,1.2969E+01,1.0808E+01,8.7913E+00,6.8118E+00,
     &4.8594E+00,2.8643E+00,9.3844E-01/
      DATA ((KA(JS,JT,10,11),JS=1,9),JT=1,5) /
     &2.5281E+01,2.2121E+01,1.8961E+01,1.5801E+01,1.2641E+01,9.4806E+00,
     &6.3207E+00,3.2921E+00,2.8225E-01,3.6089E+01,3.1577E+01,2.7066E+01,
     &2.2555E+01,1.8044E+01,1.3532E+01,9.0226E+00,4.7197E+00,3.9375E-01,
     &4.8997E+01,4.2873E+01,3.6749E+01,3.0623E+01,2.4498E+01,1.8373E+01,
     &1.2249E+01,6.4130E+00,6.0950E-01,6.4090E+01,5.6079E+01,4.8068E+01,
     &4.0059E+01,3.2048E+01,2.4036E+01,1.6029E+01,8.3902E+00,8.3229E-01,
     &8.0977E+01,7.0856E+01,6.0735E+01,5.0611E+01,4.0489E+01,3.0368E+01,
     &2.0260E+01,1.0591E+01,9.6456E-01/
      DATA ((KA(JS,JT,11,11),JS=1,9),JT=1,5) /
     &4.5405E+01,3.9730E+01,3.4055E+01,2.8379E+01,2.2704E+01,1.7027E+01,
     &1.1352E+01,5.7629E+00,2.2978E-01,6.4516E+01,5.6450E+01,4.8385E+01,
     &4.0321E+01,3.2258E+01,2.4193E+01,1.6129E+01,8.1743E+00,3.8450E-01,
     &8.7570E+01,7.6629E+01,6.5678E+01,5.4738E+01,4.3785E+01,3.2840E+01,
     &2.1894E+01,1.1105E+01,5.0528E-01,1.1421E+02,9.9924E+01,8.5650E+01,
     &7.1372E+01,5.7099E+01,4.2826E+01,2.8549E+01,1.4506E+01,6.3580E-01,
     &1.4404E+02,1.2604E+02,1.0803E+02,9.0033E+01,7.2026E+01,5.4020E+01,
     &3.6011E+01,1.8334E+01,7.9612E-01/
      DATA ((KA(JS,JT,12,11),JS=1,9),JT=1,5) /
     &5.9271E+01,5.1859E+01,4.4453E+01,3.7044E+01,2.9635E+01,2.2226E+01,
     &1.4818E+01,7.4861E+00,2.2024E-01,8.4185E+01,7.3665E+01,6.3138E+01,
     &5.2615E+01,4.2094E+01,3.1570E+01,2.1046E+01,1.0615E+01,3.8802E-01,
     &1.1399E+02,9.9749E+01,8.5496E+01,7.1245E+01,5.6997E+01,4.2749E+01,
     &2.8499E+01,1.4383E+01,4.9342E-01,1.4842E+02,1.2987E+02,1.1132E+02,
     &9.2770E+01,7.4216E+01,5.5662E+01,3.7107E+01,1.8761E+01,6.8194E-01,
     &1.8694E+02,1.6356E+02,1.4020E+02,1.1683E+02,9.3474E+01,7.0107E+01,
     &4.6738E+01,2.3682E+01,7.5051E-01/
      DATA ((KA(JS,JT,13,11),JS=1,9),JT=1,5) /
     &6.1162E+01,5.3516E+01,4.5871E+01,3.8225E+01,3.0581E+01,2.2936E+01,
     &1.5291E+01,7.7722E+00,3.0501E-01,8.6643E+01,7.5815E+01,6.4984E+01,
     &5.4153E+01,4.3324E+01,3.2493E+01,2.1662E+01,1.1016E+01,3.8069E-01,
     &1.1697E+02,1.0235E+02,8.7727E+01,7.3107E+01,5.8486E+01,4.3863E+01,
     &2.9242E+01,1.4879E+01,4.9510E-01,1.5186E+02,1.3288E+02,1.1389E+02,
     &9.4916E+01,7.5936E+01,5.6949E+01,3.7967E+01,1.9342E+01,5.7912E-01,
     &1.9078E+02,1.6694E+02,1.4309E+02,1.1924E+02,9.5394E+01,7.1546E+01,
     &4.7697E+01,2.4327E+01,6.7000E-01/
      DATA ((KA(JS,JT, 1,12),JS=1,9),JT=1,5) /
     &4.4327E-02,1.9901E-01,3.9567E-01,5.8848E-01,7.7476E-01,9.4853E-01,
     &1.0934E+00,1.1527E+00,1.5495E+00,5.3905E-02,2.4740E-01,4.9242E-01,
     &7.3367E-01,9.6823E-01,1.1892E+00,1.3767E+00,1.4534E+00,1.9364E+00,
     &6.4069E-02,2.9762E-01,5.9267E-01,8.8396E-01,1.1680E+00,1.4379E+00,
     &1.6734E+00,1.7853E+00,2.3359E+00,7.4599E-02,3.4908E-01,6.9548E-01,
     &1.0378E+00,1.3725E+00,1.6921E+00,1.9734E+00,2.1192E+00,2.7449E+00,
     &8.5274E-02,4.0394E-01,8.0404E-01,1.1983E+00,1.5830E+00,1.9477E+00,
     &2.2662E+00,2.4521E+00,3.1659E+00/
      DATA ((KA(JS,JT, 2,12),JS=1,9),JT=1,5) /
     &6.1665E-02,2.1077E-01,3.8355E-01,5.7339E-01,7.6055E-01,9.4236E-01,
     &1.1091E+00,1.2168E+00,1.5210E+00,7.6234E-02,2.5639E-01,4.7826E-01,
     &7.1532E-01,9.5007E-01,1.1793E+00,1.3941E+00,1.5452E+00,1.9001E+00,
     &9.1892E-02,3.0376E-01,5.7761E-01,8.6445E-01,1.1488E+00,1.4281E+00,
     &1.6923E+00,1.8917E+00,2.2975E+00,1.0837E-01,3.5273E-01,6.8106E-01,
     &1.0192E+00,1.3548E+00,1.6858E+00,2.0012E+00,2.2488E+00,2.7094E+00,
     &1.2523E-01,4.0526E-01,7.9735E-01,1.1921E+00,1.5816E+00,1.9625E+00,
     &2.3213E+00,2.6087E+00,3.1625E+00/
      DATA ((KA(JS,JT, 3,12),JS=1,9),JT=1,5) /
     &1.1120E-01,2.4868E-01,3.6808E-01,5.1840E-01,6.9017E-01,8.6056E-01,
     &1.0271E+00,1.1758E+00,1.3802E+00,1.4053E-01,3.1536E-01,4.5583E-01,
     &6.5442E-01,8.7173E-01,1.0879E+00,1.3003E+00,1.4947E+00,1.7433E+00,
     &1.7249E-01,3.8643E-01,5.4830E-01,7.9885E-01,1.0645E+00,1.3292E+00,
     &1.5905E+00,1.8338E+00,2.1288E+00,2.0676E-01,4.5780E-01,6.4549E-01,
     &9.5437E-01,1.2710E+00,1.5864E+00,1.8970E+00,2.1896E+00,2.5411E+00,
     &2.4212E-01,5.2871E-01,7.5484E-01,1.1269E+00,1.5000E+00,1.8700E+00,
     &2.2336E+00,2.5647E+00,2.9987E+00/
      DATA ((KA(JS,JT, 4,12),JS=1,9),JT=1,5) /
     &2.0092E-01,3.0566E-01,4.3321E-01,5.2770E-01,6.0160E-01,7.5023E-01,
     &8.9870E-01,1.0432E+00,1.2013E+00,2.6071E-01,3.8703E-01,5.5757E-01,
     &6.5930E-01,7.6619E-01,9.5732E-01,1.1477E+00,1.3364E+00,1.5321E+00,
     &3.2640E-01,4.7994E-01,6.8737E-01,7.9575E-01,9.4617E-01,1.1821E+00,
     &1.4178E+00,1.6541E+00,1.8914E+00,3.9855E-01,5.8348E-01,8.2078E-01,
     &9.3830E-01,1.1490E+00,1.4352E+00,1.7207E+00,2.0041E+00,2.2963E+00,
     &4.7570E-01,6.9415E-01,9.5472E-01,1.0922E+00,1.3776E+00,1.7196E+00,
     &2.0594E+00,2.3902E+00,2.7528E+00/
      DATA ((KA(JS,JT, 5,12),JS=1,9),JT=1,5) /
     &3.3247E-01,3.9594E-01,4.9056E-01,5.8813E-01,6.5607E-01,6.8035E-01,
     &7.9032E-01,9.1840E-01,1.0557E+00,4.4282E-01,5.1203E-01,6.4486E-01,
     &7.7152E-01,8.4090E-01,8.6628E-01,1.0179E+00,1.1841E+00,1.3589E+00,
     &5.6912E-01,6.3900E-01,8.2247E-01,9.6727E-01,1.0369E+00,1.0698E+00,
     &1.2706E+00,1.4785E+00,1.6959E+00,7.0931E-01,7.8069E-01,1.0153E+00,
     &1.1726E+00,1.2423E+00,1.3043E+00,1.5604E+00,1.8146E+00,2.0829E+00,
     &8.5949E-01,9.3825E-01,1.2105E+00,1.3829E+00,1.4592E+00,1.5748E+00,
     &1.8870E+00,2.1938E+00,2.5189E+00/
      DATA ((KA(JS,JT, 6,12),JS=1,9),JT=1,5) /
     &5.2509E-01,5.1721E-01,5.7378E-01,6.3384E-01,6.9692E-01,7.3419E-01,
     &7.1864E-01,7.9317E-01,9.0866E-01,7.0957E-01,6.9625E-01,7.6638E-01,
     &8.5821E-01,9.3314E-01,9.6244E-01,9.2911E-01,1.0410E+00,1.1915E+00,
     &9.2892E-01,9.0647E-01,9.9421E-01,1.1180E+00,1.1912E+00,1.2074E+00,
     &1.1606E+00,1.3214E+00,1.5144E+00,1.1749E+00,1.1432E+00,1.2560E+00,
     &1.3977E+00,1.4686E+00,1.4691E+00,1.4281E+00,1.6462E+00,1.8876E+00,
     &1.4442E+00,1.4016E+00,1.5480E+00,1.6922E+00,1.7621E+00,1.7564E+00,
     &1.7321E+00,2.0105E+00,2.3048E+00/
      DATA ((KA(JS,JT, 7,12),JS=1,9),JT=1,5) /
     &9.1849E-01,8.0624E-01,7.9050E-01,7.5675E-01,7.6178E-01,7.8133E-01,
     &7.7608E-01,6.9116E-01,7.7991E-01,1.2413E+00,1.0918E+00,1.0769E+00,
     &1.0420E+00,1.0608E+00,1.0726E+00,1.0404E+00,9.1318E-01,1.0358E+00,
     &1.6444E+00,1.4500E+00,1.4209E+00,1.3929E+00,1.4200E+00,1.3992E+00,
     &1.3321E+00,1.1740E+00,1.3388E+00,2.1122E+00,1.8669E+00,1.8040E+00,
     &1.8049E+00,1.8188E+00,1.7570E+00,1.6501E+00,1.4861E+00,1.6989E+00,
     &2.6250E+00,2.3265E+00,2.2289E+00,2.2673E+00,2.2456E+00,2.1426E+00,
     &2.0040E+00,1.8373E+00,2.0997E+00/
      DATA ((KA(JS,JT, 8,12),JS=1,9),JT=1,5) /
     &1.9827E+00,1.7349E+00,1.4981E+00,1.3371E+00,1.1453E+00,9.6602E-01,
     &8.7309E-01,7.7254E-01,6.6571E-01,2.7151E+00,2.3758E+00,2.0507E+00,
     &1.8313E+00,1.5691E+00,1.3551E+00,1.2325E+00,1.0537E+00,8.9966E-01,
     &3.5997E+00,3.1499E+00,2.7291E+00,2.4373E+00,2.1034E+00,1.8593E+00,
     &1.6579E+00,1.3773E+00,1.1789E+00,4.6665E+00,4.0832E+00,3.5519E+00,
     &3.1544E+00,2.7468E+00,2.4617E+00,2.1388E+00,1.7464E+00,1.5079E+00,
     &5.8669E+00,5.1335E+00,4.4792E+00,3.9559E+00,3.4817E+00,3.1241E+00,
     &2.6649E+00,2.1629E+00,1.8732E+00/
      DATA ((KA(JS,JT, 9,12),JS=1,9),JT=1,5) /
     &8.0387E+00,7.0340E+00,6.0293E+00,5.0245E+00,4.0196E+00,3.0957E+00,
     &2.1773E+00,1.2357E+00,4.2050E-01,1.1280E+01,9.8705E+00,8.4601E+00,
     &7.0501E+00,5.6402E+00,4.3334E+00,3.0492E+00,1.7467E+00,4.6837E-01,
     &1.5202E+01,1.3302E+01,1.1401E+01,9.5008E+00,7.6009E+00,5.8446E+00,
     &4.1033E+00,2.4072E+00,9.0067E-01,1.9804E+01,1.7328E+01,1.4853E+01,
     &1.2377E+01,9.9040E+00,7.6319E+00,5.3589E+00,3.2206E+00,1.3277E+00,
     &2.5091E+01,2.1955E+01,1.8819E+01,1.5683E+01,1.2554E+01,9.6970E+00,
     &6.8190E+00,4.1412E+00,1.6570E+00/
      DATA ((KA(JS,JT,10,12),JS=1,9),JT=1,5) /
     &3.6853E+01,3.2247E+01,2.7641E+01,2.3035E+01,1.8427E+01,1.3820E+01,
     &9.2142E+00,4.7017E+00,5.2096E-01,5.2866E+01,4.6255E+01,3.9648E+01,
     &3.3040E+01,2.6431E+01,1.9825E+01,1.3217E+01,6.7223E+00,8.5705E-01,
     &7.2440E+01,6.3382E+01,5.4326E+01,4.5272E+01,3.6218E+01,2.7164E+01,
     &1.8108E+01,9.2103E+00,9.7984E-01,9.5327E+01,8.3414E+01,7.1501E+01,
     &5.9582E+01,4.7667E+01,3.5750E+01,2.3834E+01,1.2146E+01,1.1774E+00,
     &1.2143E+02,1.0625E+02,9.1069E+01,7.5889E+01,6.0713E+01,4.5537E+01,
     &3.0358E+01,1.5516E+01,1.3416E+00/
      DATA ((KA(JS,JT,11,12),JS=1,9),JT=1,5) /
     &6.9348E+01,6.0680E+01,5.2012E+01,4.3342E+01,3.4673E+01,2.6006E+01,
     &1.7338E+01,8.6702E+00,3.0466E-01,9.9352E+01,8.6930E+01,7.4511E+01,
     &6.2093E+01,4.9676E+01,3.7257E+01,2.4839E+01,1.2419E+01,6.8510E-01,
     &1.3563E+02,1.1868E+02,1.0173E+02,8.4769E+01,6.7818E+01,5.0866E+01,
     &3.3908E+01,1.6957E+01,1.0467E+00,1.7753E+02,1.5535E+02,1.3315E+02,
     &1.1096E+02,8.8765E+01,6.6576E+01,4.4384E+01,2.2206E+01,1.3289E+00,
     &2.2508E+02,1.9694E+02,1.6881E+02,1.4068E+02,1.1255E+02,8.4405E+01,
     &5.6267E+01,2.8168E+01,1.6371E+00/
      DATA ((KA(JS,JT,12,12),JS=1,9),JT=1,5) /
     &9.5815E+01,8.3836E+01,7.1860E+01,5.9885E+01,4.7907E+01,3.5931E+01,
     &2.3953E+01,1.1977E+01,2.4035E-01,1.3694E+02,1.1982E+02,1.0270E+02,
     &8.5588E+01,6.8468E+01,5.1352E+01,3.4234E+01,1.7118E+01,5.7126E-01,
     &1.8607E+02,1.6282E+02,1.3956E+02,1.1630E+02,9.3038E+01,6.9781E+01,
     &4.6518E+01,2.3259E+01,8.8813E-01,2.4268E+02,2.1235E+02,1.8201E+02,
     &1.5168E+02,1.2134E+02,9.1010E+01,6.0670E+01,3.0335E+01,1.1237E+00,
     &3.0642E+02,2.6813E+02,2.2982E+02,1.9152E+02,1.5322E+02,1.1491E+02,
     &7.6606E+01,3.8310E+01,1.5308E+00/
      DATA ((KA(JS,JT,13,12),JS=1,9),JT=1,5) /
     &1.0396E+02,9.0973E+01,7.7973E+01,6.4982E+01,5.1984E+01,3.8991E+01,
     &2.5992E+01,1.3003E+01,2.8896E-01,1.4817E+02,1.2965E+02,1.1113E+02,
     &9.2604E+01,7.4089E+01,5.5562E+01,3.7043E+01,1.8523E+01,6.4071E-01,
     &2.0056E+02,1.7549E+02,1.5042E+02,1.2535E+02,1.0028E+02,7.5210E+01,
     &5.0138E+01,2.5080E+01,7.6073E-01,2.6107E+02,2.2842E+02,1.9581E+02,
     &1.6317E+02,1.3054E+02,9.7901E+01,6.5267E+01,3.2665E+01,1.0550E+00,
     &3.2818E+02,2.8717E+02,2.4613E+02,2.0512E+02,1.6409E+02,1.2307E+02,
     &8.2040E+01,4.1093E+01,1.4069E+00/
      DATA ((KA(JS,JT, 1,13),JS=1,9),JT=1,5) /
     &8.9189E-02,2.7547E-01,5.4755E-01,8.1466E-01,1.0734E+00,1.3167E+00,
     &1.5262E+00,1.6545E+00,2.1467E+00,1.0564E-01,3.3448E-01,6.6333E-01,
     &9.8354E-01,1.2897E+00,1.5719E+00,1.8097E+00,1.9474E+00,2.5794E+00,
     &1.2232E-01,4.0251E-01,7.9745E-01,1.1809E+00,1.5463E+00,1.8798E+00,
     &2.1512E+00,2.2853E+00,3.0925E+00,1.3906E-01,4.8151E-01,9.5370E-01,
     &1.4117E+00,1.8477E+00,2.2440E+00,2.5627E+00,2.7054E+00,3.6953E+00,
     &1.5537E-01,5.6891E-01,1.1282E+00,1.6723E+00,2.1918E+00,2.6654E+00,
     &3.0480E+00,3.1989E+00,4.3834E+00/
      DATA ((KA(JS,JT, 2,13),JS=1,9),JT=1,5) /
     &1.2651E-01,2.7511E-01,5.4811E-01,8.1792E-01,1.0822E+00,1.3369E+00,
     &1.5702E+00,1.7388E+00,2.1643E+00,1.5153E-01,3.4384E-01,6.8417E-01,
     &1.0197E+00,1.3466E+00,1.6574E+00,1.9318E+00,2.0933E+00,2.6930E+00,
     &1.7716E-01,4.2323E-01,8.4160E-01,1.2530E+00,1.6525E+00,2.0285E+00,
     &2.3523E+00,2.5052E+00,3.3049E+00,2.0304E-01,5.0914E-01,1.0128E+00,
     &1.5083E+00,1.9894E+00,2.4425E+00,2.8273E+00,2.9947E+00,3.9785E+00,
     &2.2856E-01,5.9708E-01,1.1882E+00,1.7705E+00,2.3375E+00,2.8753E+00,
     &3.3417E+00,3.5598E+00,4.6746E+00/
      DATA ((KA(JS,JT, 3,13),JS=1,9),JT=1,5) /
     &2.3155E-01,3.6106E-01,5.1524E-01,7.7074E-01,1.0237E+00,1.2717E+00,
     &1.5079E+00,1.7067E+00,2.0474E+00,2.8222E-01,4.3122E-01,6.6114E-01,
     &9.8854E-01,1.3120E+00,1.6278E+00,1.9248E+00,2.1616E+00,2.6238E+00,
     &3.3490E-01,5.0925E-01,8.3049E-01,1.2417E+00,1.6476E+00,2.0430E+00,
     &2.4133E+00,2.6954E+00,3.2949E+00,3.8898E-01,5.9951E-01,1.0132E+00,
     &1.5151E+00,2.0114E+00,2.4964E+00,2.9531E+00,3.3043E+00,4.0224E+00,
     &4.4295E-01,6.9228E-01,1.1941E+00,1.7863E+00,2.3719E+00,2.9449E+00,
     &3.4879E+00,3.9170E+00,4.7434E+00/
      DATA ((KA(JS,JT, 4,13),JS=1,9),JT=1,5) /
     &4.2438E-01,5.0777E-01,6.1519E-01,7.0596E-01,9.3438E-01,1.1645E+00,
     &1.3892E+00,1.5946E+00,1.8686E+00,5.2911E-01,6.2653E-01,7.5903E-01,
     &9.2591E-01,1.2320E+00,1.5352E+00,1.8307E+00,2.0955E+00,2.4637E+00,
     &6.3945E-01,7.5086E-01,9.2902E-01,1.1816E+00,1.5728E+00,1.9600E+00,
     &2.3380E+00,2.6793E+00,3.1453E+00,7.5432E-01,8.7946E-01,1.1073E+00,
     &1.4569E+00,1.9394E+00,2.4183E+00,2.8875E+00,3.3173E+00,3.8782E+00,
     &8.7134E-01,1.0123E+00,1.2829E+00,1.7403E+00,2.3172E+00,2.8902E+00,
     &3.4528E+00,3.9744E+00,4.6335E+00/
      DATA ((KA(JS,JT, 5,13),JS=1,9),JT=1,5) /
     &7.1207E-01,6.8711E-01,8.3241E-01,8.6529E-01,8.8550E-01,1.0406E+00,
     &1.2451E+00,1.4407E+00,1.6670E+00,9.0944E-01,8.8418E-01,1.0384E+00,
     &1.0957E+00,1.1610E+00,1.4029E+00,1.6788E+00,1.9429E+00,2.2472E+00,
     &1.1217E+00,1.1051E+00,1.2550E+00,1.3677E+00,1.4770E+00,1.8154E+00,
     &2.1738E+00,2.5182E+00,2.9077E+00,1.3460E+00,1.3429E+00,1.4887E+00,
     &1.6567E+00,1.8206E+00,2.2609E+00,2.7082E+00,3.1425E+00,3.6199E+00,
     &1.5795E+00,1.5881E+00,1.7517E+00,1.9324E+00,2.1859E+00,2.7284E+00,
     &3.2694E+00,3.7971E+00,4.3676E+00/
      DATA ((KA(JS,JT, 6,13),JS=1,9),JT=1,5) /
     &1.1023E+00,9.7526E-01,1.0617E+00,1.1008E+00,1.0651E+00,1.0178E+00,
     &1.0836E+00,1.2590E+00,1.4474E+00,1.4464E+00,1.2819E+00,1.3748E+00,
     &1.4078E+00,1.3857E+00,1.3476E+00,1.4882E+00,1.7304E+00,1.9875E+00,
     &1.8308E+00,1.6242E+00,1.7155E+00,1.7456E+00,1.7675E+00,1.7237E+00,
     &1.9554E+00,2.2760E+00,2.6094E+00,2.2453E+00,1.9975E+00,2.0781E+00,
     &2.1295E+00,2.1828E+00,2.1327E+00,2.4652E+00,2.8713E+00,3.2893E+00,
     &2.6836E+00,2.3986E+00,2.4577E+00,2.5567E+00,2.5877E+00,2.5663E+00,
     &3.0104E+00,3.5064E+00,4.0161E+00/
      DATA ((KA(JS,JT, 7,13),JS=1,9),JT=1,5) /
     &1.7788E+00,1.5565E+00,1.4296E+00,1.4541E+00,1.3809E+00,1.2482E+00,
     &1.1009E+00,1.0852E+00,1.2442E+00,2.4100E+00,2.1089E+00,1.9246E+00,
     &1.9363E+00,1.8185E+00,1.6636E+00,1.4819E+00,1.5124E+00,1.7324E+00,
     &3.1319E+00,2.7405E+00,2.5003E+00,2.4636E+00,2.3111E+00,2.1652E+00,
     &1.9114E+00,2.0080E+00,2.2982E+00,3.9360E+00,3.4440E+00,3.1598E+00,
     &3.0372E+00,2.8747E+00,2.7334E+00,2.3814E+00,2.5579E+00,2.9254E+00,
     &4.8010E+00,4.2009E+00,3.8764E+00,3.6526E+00,3.5065E+00,3.3078E+00,
     &2.8824E+00,3.1625E+00,3.6156E+00/
      DATA ((KA(JS,JT, 8,13),JS=1,9),JT=1,5) /
     &3.4656E+00,3.0324E+00,2.5993E+00,2.2536E+00,2.0768E+00,1.8323E+00,
     &1.4794E+00,1.1100E+00,1.0719E+00,4.7953E+00,4.1960E+00,3.5964E+00,
     &3.1195E+00,2.8558E+00,2.4960E+00,2.0234E+00,1.5264E+00,1.5151E+00,
     &6.4119E+00,5.6106E+00,4.8091E+00,4.1637E+00,3.7658E+00,3.2529E+00,
     &2.6777E+00,1.9921E+00,2.0306E+00,8.2532E+00,7.2211E+00,6.1898E+00,
     &5.3688E+00,4.7948E+00,4.1025E+00,3.4458E+00,2.5062E+00,2.6143E+00,
     &1.0283E+01,8.9971E+00,7.7118E+00,6.7087E+00,5.9163E+00,5.0630E+00,
     &4.2877E+00,3.0597E+00,3.2702E+00/
      DATA ((KA(JS,JT, 9,13),JS=1,9),JT=1,5) /
     &1.3039E+01,1.1409E+01,9.7786E+00,8.1486E+00,6.5192E+00,4.9000E+00,
     &3.5526E+00,2.2083E+00,6.1249E-01,1.8190E+01,1.5916E+01,1.3643E+01,
     &1.1369E+01,9.0953E+00,6.8331E+00,4.9544E+00,3.0917E+00,1.3174E+00,
     &2.4717E+01,2.1628E+01,1.8538E+01,1.5449E+01,1.2359E+01,9.2996E+00,
     &6.7414E+00,4.1578E+00,1.7841E+00,3.2573E+01,2.8503E+01,2.4432E+01,
     &2.0359E+01,1.6288E+01,1.2267E+01,8.8606E+00,5.4011E+00,2.3241E+00,
     &4.1562E+01,3.6368E+01,3.1173E+01,2.5977E+01,2.0781E+01,1.5678E+01,
     &1.1261E+01,6.8301E+00,2.9541E+00/
      DATA ((KA(JS,JT,10,13),JS=1,9),JT=1,5) /
     &5.7951E+01,5.0708E+01,4.3464E+01,3.6220E+01,2.8976E+01,2.1732E+01,
     &1.4488E+01,7.2520E+00,5.6538E-01,8.1306E+01,7.1141E+01,6.0979E+01,
     &5.0813E+01,4.0652E+01,3.0489E+01,2.0326E+01,1.0163E+01,6.5761E-01,
     &1.1158E+02,9.7625E+01,8.3679E+01,6.9730E+01,5.5786E+01,4.1839E+01,
     &2.7893E+01,1.3953E+01,1.0530E+00,1.4877E+02,1.3018E+02,1.1158E+02,
     &9.2984E+01,7.4388E+01,5.5791E+01,3.7194E+01,1.8619E+01,1.0469E+00,
     &1.9259E+02,1.6851E+02,1.4444E+02,1.2037E+02,9.6298E+01,7.2222E+01,
     &4.8145E+01,2.4115E+01,9.0336E-01/
      DATA ((KA(JS,JT,11,13),JS=1,9),JT=1,5) /
     &1.0724E+02,9.3834E+01,8.0425E+01,6.7028E+01,5.3621E+01,4.0215E+01,
     &2.6808E+01,1.3405E+01,7.5947E-01,1.5135E+02,1.3244E+02,1.1352E+02,
     &9.4596E+01,7.5677E+01,5.6758E+01,3.7839E+01,1.8919E+01,7.7568E-01,
     &2.0634E+02,1.8056E+02,1.5476E+02,1.2896E+02,1.0317E+02,7.7384E+01,
     &5.1587E+01,2.5792E+01,1.1446E+00,2.7388E+02,2.3963E+02,2.0540E+02,
     &1.7116E+02,1.3692E+02,1.0270E+02,6.8464E+01,3.4233E+01,1.4967E+00,
     &3.5254E+02,3.0844E+02,2.6442E+02,2.2035E+02,1.7628E+02,1.3220E+02,
     &8.8134E+01,4.4067E+01,1.3951E+00/
      DATA ((KA(JS,JT,12,13),JS=1,9),JT=1,5) /
     &1.4929E+02,1.3063E+02,1.1197E+02,9.3306E+01,7.4648E+01,5.5984E+01,
     &3.7322E+01,1.8661E+01,7.7179E-01,2.1213E+02,1.8562E+02,1.5909E+02,
     &1.3258E+02,1.0606E+02,7.9546E+01,5.3033E+01,2.6517E+01,8.3102E-01,
     &2.8848E+02,2.5242E+02,2.1635E+02,1.8030E+02,1.4425E+02,1.0818E+02,
     &7.2116E+01,3.6059E+01,1.2769E+00,3.7976E+02,3.3226E+02,2.8481E+02,
     &2.3733E+02,1.8986E+02,1.4240E+02,9.4932E+01,4.7464E+01,1.6812E+00,
     &4.8508E+02,4.2444E+02,3.6380E+02,3.0318E+02,2.4253E+02,1.8190E+02,
     &1.2127E+02,6.0633E+01,1.6837E+00/
      DATA ((KA(JS,JT,13,13),JS=1,9),JT=1,5) /
     &1.6844E+02,1.4739E+02,1.2633E+02,1.0528E+02,8.4219E+01,6.3167E+01,
     &4.2110E+01,2.1055E+01,6.4746E-01,2.3974E+02,2.0978E+02,1.7981E+02,
     &1.4983E+02,1.1987E+02,8.9901E+01,5.9937E+01,2.9967E+01,7.7977E-01,
     &3.2617E+02,2.8540E+02,2.4462E+02,2.0386E+02,1.6309E+02,1.2231E+02,
     &8.1544E+01,4.0770E+01,1.5118E+00,4.2665E+02,3.7332E+02,3.1999E+02,
     &2.6667E+02,2.1333E+02,1.5999E+02,1.0667E+02,5.3332E+01,1.6652E+00,
     &5.4098E+02,4.7336E+02,4.0573E+02,3.3811E+02,2.7048E+02,2.0286E+02,
     &1.3525E+02,6.7619E+01,1.7274E+00/
      DATA ((KA(JS,JT, 1,14),JS=1,9),JT=1,5) /
     &1.4473E-01,4.5196E-01,8.9698E-01,1.3316E+00,1.7483E+00,2.1329E+00,
     &2.4492E+00,2.5366E+00,3.4967E+00,1.6846E-01,5.5554E-01,1.1039E+00,
     &1.6417E+00,2.1611E+00,2.6456E+00,3.0463E+00,3.1695E+00,4.3222E+00,
     &1.9174E-01,6.6749E-01,1.3276E+00,1.9756E+00,2.6027E+00,3.1886E+00,
     &3.6789E+00,3.8433E+00,5.2055E+00,2.1490E-01,7.8476E-01,1.5609E+00,
     &2.3233E+00,3.0639E+00,3.7563E+00,4.3396E+00,4.5493E+00,6.1279E+00,
     &2.3691E-01,9.0765E-01,1.8042E+00,2.6834E+00,3.5348E+00,4.3362E+00,
     &5.0160E+00,5.2774E+00,7.0696E+00/
      DATA ((KA(JS,JT, 2,14),JS=1,9),JT=1,5) /
     &2.1296E-01,4.6215E-01,9.1984E-01,1.3706E+00,1.8091E+00,2.2245E+00,
     &2.5860E+00,2.7730E+00,3.6182E+00,2.5016E-01,5.6432E-01,1.1237E+00,
     &1.6756E+00,2.2151E+00,2.7294E+00,3.1864E+00,3.4606E+00,4.4301E+00,
     &2.8692E-01,6.7375E-01,1.3425E+00,2.0033E+00,2.6512E+00,3.2743E+00,
     &3.8384E+00,4.2145E+00,5.3023E+00,3.2327E-01,7.9645E-01,1.5866E+00,
     &2.3669E+00,3.1323E+00,3.8679E+00,4.5425E+00,5.0100E+00,6.2645E+00,
     &3.5851E-01,9.3518E-01,1.8621E+00,2.7777E+00,3.6730E+00,4.5297E+00,
     &5.3029E+00,5.8281E+00,7.3458E+00/
      DATA ((KA(JS,JT, 3,14),JS=1,9),JT=1,5) /
     &4.0569E-01,4.7346E-01,9.0139E-01,1.3483E+00,1.7892E+00,2.2204E+00,
     &2.6252E+00,2.9358E+00,3.5784E+00,4.8357E-01,5.7585E-01,1.1016E+00,
     &1.6482E+00,2.1888E+00,2.7185E+00,3.2205E+00,3.6184E+00,4.3777E+00,
     &5.6184E-01,6.8539E-01,1.3182E+00,1.9726E+00,2.6206E+00,3.2555E+00,
     &3.8616E+00,4.3597E+00,5.2411E+00,6.3937E-01,8.0074E-01,1.5659E+00,
     &2.3420E+00,3.1101E+00,3.8617E+00,4.5735E+00,5.1595E+00,6.2201E+00,
     &7.1542E-01,9.3290E-01,1.8594E+00,2.7803E+00,3.6907E+00,4.5815E+00,
     &5.4228E+00,6.0997E+00,7.3811E+00/
      DATA ((KA(JS,JT, 4,14),JS=1,9),JT=1,5) /
     &7.7613E-01,7.2482E-01,8.8213E-01,1.2906E+00,1.7174E+00,2.1406E+00,
     &2.5536E+00,2.9272E+00,3.4348E+00,9.4054E-01,9.0136E-01,1.0781E+00,
     &1.5850E+00,2.1098E+00,2.6295E+00,3.1372E+00,3.6020E+00,4.2194E+00,
     &1.1095E+00,1.0843E+00,1.2887E+00,1.9170E+00,2.5512E+00,3.1791E+00,
     &3.7919E+00,4.3511E+00,5.1021E+00,1.2791E+00,1.2603E+00,1.5382E+00,
     &2.3038E+00,3.0649E+00,3.8173E+00,4.5513E+00,5.2083E+00,6.1294E+00,
     &1.4465E+00,1.4292E+00,1.8362E+00,2.7499E+00,3.6579E+00,4.5561E+00,
     &5.4280E+00,6.2050E+00,7.3150E+00/
      DATA ((KA(JS,JT, 5,14),JS=1,9),JT=1,5) /
     &1.3553E+00,1.1859E+00,1.1889E+00,1.2820E+00,1.6126E+00,2.0133E+00,
     &2.4100E+00,2.7917E+00,3.2251E+00,1.6746E+00,1.4653E+00,1.4722E+00,
     &1.5790E+00,2.0132E+00,2.5133E+00,3.0071E+00,3.4795E+00,4.0262E+00,
     &2.0071E+00,1.7563E+00,1.7644E+00,1.8926E+00,2.4705E+00,3.0826E+00,
     &3.6880E+00,4.2630E+00,4.9404E+00,2.3461E+00,2.0539E+00,2.0623E+00,
     &2.2628E+00,3.0107E+00,3.7562E+00,4.4918E+00,5.1850E+00,6.0203E+00,
     &2.6832E+00,2.3569E+00,2.3578E+00,2.7266E+00,3.6306E+00,4.5292E+00,
     &5.4146E+00,6.2480E+00,7.2595E+00/
      DATA ((KA(JS,JT, 6,14),JS=1,9),JT=1,5) /
     &2.1798E+00,1.9076E+00,1.6634E+00,1.6610E+00,1.6126E+00,1.8086E+00,
     &2.1681E+00,2.5212E+00,2.8955E+00,2.7568E+00,2.4124E+00,2.1319E+00,
     &2.0890E+00,2.0379E+00,2.3402E+00,2.8045E+00,3.2592E+00,3.7464E+00,
     &3.3653E+00,2.9447E+00,2.6494E+00,2.5260E+00,2.4774E+00,2.9464E+00,
     &3.5300E+00,4.0980E+00,4.7178E+00,3.9980E+00,3.4981E+00,3.2081E+00,
     &2.9759E+00,2.9694E+00,3.6441E+00,4.3643E+00,5.0633E+00,5.8364E+00,
     &4.6371E+00,4.0569E+00,3.7676E+00,3.4231E+00,3.5724E+00,4.4465E+00,
     &5.3245E+00,6.1747E+00,7.1186E+00/
      DATA ((KA(JS,JT, 7,14),JS=1,9),JT=1,5) /
     &3.6500E+00,3.1940E+00,2.7377E+00,2.3521E+00,2.2005E+00,1.9226E+00,
     &1.8951E+00,2.2032E+00,2.5224E+00,4.7380E+00,4.1460E+00,3.5535E+00,
     &3.0746E+00,2.8560E+00,2.4862E+00,2.5325E+00,2.9498E+00,3.3790E+00,
     &5.9099E+00,5.1713E+00,4.4326E+00,3.9038E+00,3.5341E+00,3.0823E+00,
     &3.2930E+00,3.8333E+00,4.3949E+00,7.1406E+00,6.2480E+00,5.3561E+00,
     &4.7936E+00,4.2290E+00,3.7296E+00,4.1867E+00,4.8720E+00,5.5890E+00,
     &8.4067E+00,7.3559E+00,6.3050E+00,5.6953E+00,4.9319E+00,4.4981E+00,
     &5.2053E+00,6.0551E+00,6.9478E+00/
      DATA ((KA(JS,JT, 8,14),JS=1,9),JT=1,5) /
     &7.2793E+00,6.3695E+00,5.4593E+00,4.5496E+00,3.6668E+00,3.0739E+00,
     &2.3812E+00,1.8850E+00,2.1414E+00,9.7148E+00,8.5004E+00,7.2858E+00,
     &6.0719E+00,4.9067E+00,4.1050E+00,3.1504E+00,2.5960E+00,2.9698E+00,
     &1.2408E+01,1.0858E+01,9.3058E+00,7.7549E+00,6.3008E+00,5.2586E+00,
     &3.9820E+00,3.4865E+00,3.9886E+00,1.5301E+01,1.3388E+01,1.1476E+01,
     &9.5632E+00,7.8364E+00,6.4696E+00,4.8601E+00,4.5513E+00,5.2081E+00,
     &1.8319E+01,1.6029E+01,1.3740E+01,1.1449E+01,9.4798E+00,7.7150E+00,
     &5.8215E+00,5.7877E+00,6.6226E+00/
      DATA ((KA(JS,JT, 9,14),JS=1,9),JT=1,5) /
     &2.7093E+01,2.3706E+01,2.0321E+01,1.6934E+01,1.3547E+01,1.0161E+01,
     &6.7735E+00,3.8947E+00,1.7904E+00,3.7356E+01,3.2687E+01,2.8017E+01,
     &2.3347E+01,1.8679E+01,1.4008E+01,9.3393E+00,5.3672E+00,2.5563E+00,
     &4.9010E+01,4.2883E+01,3.6757E+01,3.0630E+01,2.4505E+01,1.8379E+01,
     &1.2257E+01,7.0400E+00,3.5347E+00,6.1735E+01,5.4018E+01,4.6300E+01,
     &3.8583E+01,3.0868E+01,2.3150E+01,1.5458E+01,8.8071E+00,4.7393E+00,
     &7.5284E+01,6.5873E+01,5.6463E+01,4.7052E+01,3.7640E+01,2.8233E+01,
     &1.8889E+01,1.0654E+01,6.1635E+00/
      DATA ((KA(JS,JT,10,14),JS=1,9),JT=1,5) /
     &1.1501E+02,1.0064E+02,8.6262E+01,7.1883E+01,5.7506E+01,4.3130E+01,
     &2.8755E+01,1.4378E+01,5.7116E-01,1.6323E+02,1.4283E+02,1.2242E+02,
     &1.0202E+02,8.1614E+01,6.1213E+01,4.0807E+01,2.0405E+01,4.6944E-01,
     &2.1950E+02,1.9206E+02,1.6462E+02,1.3718E+02,1.0975E+02,8.2311E+01,
     &5.4875E+01,2.7438E+01,1.0245E+00,2.8264E+02,2.4730E+02,2.1197E+02,
     &1.7666E+02,1.4132E+02,1.0599E+02,7.0664E+01,3.5330E+01,2.8560E+00,
     &3.5102E+02,3.0716E+02,2.6326E+02,2.1939E+02,1.7551E+02,1.3164E+02,
     &8.7759E+01,4.3879E+01,5.5928E+00/
      DATA ((KA(JS,JT,11,14),JS=1,9),JT=1,5) /
     &2.0513E+02,1.7948E+02,1.5384E+02,1.2821E+02,1.0256E+02,7.6924E+01,
     &5.1281E+01,2.5640E+01,9.4489E-01,2.8915E+02,2.5300E+02,2.1687E+02,
     &1.8072E+02,1.4458E+02,1.0844E+02,7.2287E+01,3.6146E+01,1.0101E+00,
     &3.8981E+02,3.4108E+02,2.9236E+02,2.4364E+02,1.9490E+02,1.4617E+02,
     &9.7460E+01,4.8730E+01,5.8913E-01,5.0429E+02,4.4124E+02,3.7819E+02,
     &3.1515E+02,2.5212E+02,1.8910E+02,1.2606E+02,6.3034E+01,1.0227E+00,
     &6.2985E+02,5.5113E+02,4.7241E+02,3.9368E+02,3.1495E+02,2.3621E+02,
     &1.5747E+02,7.8734E+01,3.1704E+00/
      DATA ((KA(JS,JT,12,14),JS=1,9),JT=1,5) /
     &2.7480E+02,2.4043E+02,2.0609E+02,1.7173E+02,1.3740E+02,1.0305E+02,
     &6.8696E+01,3.4350E+01,1.0331E+00,3.8434E+02,3.3629E+02,2.8824E+02,
     &2.4020E+02,1.9217E+02,1.4412E+02,9.6082E+01,4.8041E+01,1.0697E+00,
     &5.1835E+02,4.5357E+02,3.8876E+02,3.2398E+02,2.5917E+02,1.9438E+02,
     &1.2959E+02,6.4795E+01,6.6152E-01,6.7292E+02,5.8878E+02,5.0467E+02,
     &4.2055E+02,3.3645E+02,2.5234E+02,1.6823E+02,8.4112E+01,1.1390E+00,
     &8.4273E+02,7.3739E+02,6.3205E+02,5.2668E+02,4.2135E+02,3.1602E+02,
     &2.1069E+02,1.0534E+02,2.2409E+00/
      DATA ((KA(JS,JT,13,14),JS=1,9),JT=1,5) /
     &2.9725E+02,2.6009E+02,2.2295E+02,1.8578E+02,1.4862E+02,1.1147E+02,
     &7.4314E+01,3.7158E+01,8.5883E-01,4.1294E+02,3.6134E+02,3.0971E+02,
     &2.5809E+02,2.0649E+02,1.5487E+02,1.0324E+02,5.1621E+01,7.4403E-01,
     &5.5484E+02,4.8548E+02,4.1611E+02,3.4677E+02,2.7741E+02,2.0806E+02,
     &1.3871E+02,6.9351E+01,6.5779E-01,7.2016E+02,6.3017E+02,5.4015E+02,
     &4.5013E+02,3.6010E+02,2.7007E+02,1.8004E+02,9.0025E+01,1.1133E+00,
     &9.0551E+02,7.9235E+02,6.7916E+02,5.6596E+02,4.5276E+02,3.3958E+02,
     &2.2638E+02,1.1319E+02,2.5474E+00/
      DATA ((KA(JS,JT, 1,15),JS=1,9),JT=1,5) /
     &1.6993E-01,6.2319E-01,1.2302E+00,1.8117E+00,2.3534E+00,2.8224E+00,
     &3.1427E+00,3.0683E+00,4.7067E+00,1.9652E-01,7.8355E-01,1.5463E+00,
     &2.2775E+00,2.9572E+00,3.5450E+00,3.9419E+00,3.8320E+00,5.9144E+00,
     &2.2200E-01,9.5617E-01,1.8872E+00,2.7806E+00,3.6114E+00,4.3315E+00,
     &4.8212E+00,4.6828E+00,7.2228E+00,2.4720E-01,1.1411E+00,2.2528E+00,
     &3.3193E+00,4.3116E+00,5.1713E+00,5.7552E+00,5.5959E+00,8.6231E+00,
     &2.7067E-01,1.3368E+00,2.6392E+00,3.8885E+00,5.0531E+00,6.0617E+00,
     &6.7490E+00,6.5681E+00,1.0106E+01/
      DATA ((KA(JS,JT, 2,15),JS=1,9),JT=1,5) /
     &2.5495E-01,6.7714E-01,1.3429E+00,1.9911E+00,2.6102E+00,3.1741E+00,
     &3.6176E+00,3.6989E+00,5.2204E+00,2.9713E-01,8.6139E-01,1.7085E+00,
     &2.5326E+00,3.3191E+00,4.0358E+00,4.5977E+00,4.6904E+00,6.6382E+00,
     &3.3791E-01,1.0632E+00,2.1089E+00,3.1273E+00,4.0996E+00,4.9862E+00,
     &5.6823E+00,5.7948E+00,8.1990E+00,3.7751E-01,1.2778E+00,2.5347E+00,
     &3.7591E+00,4.9277E+00,5.9944E+00,6.8345E+00,6.9830E+00,9.8554E+00,
     &4.1544E-01,1.5054E+00,2.9855E+00,4.4278E+00,5.8067E+00,7.0647E+00,
     &8.0557E+00,8.2364E+00,1.1613E+01/
      DATA ((KA(JS,JT, 3,15),JS=1,9),JT=1,5) /
     &4.9608E-01,6.8984E-01,1.3746E+00,2.0502E+00,2.7121E+00,3.3455E+00,
     &3.9122E+00,4.2490E+00,5.4242E+00,5.8591E-01,8.9422E-01,1.7812E+00,
     &2.6579E+00,3.5151E+00,4.3360E+00,5.0694E+00,5.5020E+00,7.0303E+00,
     &6.7409E-01,1.1231E+00,2.2377E+00,3.3379E+00,4.4153E+00,5.4452E+00,
     &6.3666E+00,6.9097E+00,8.8307E+00,7.5926E-01,1.3688E+00,2.7271E+00,
     &4.0692E+00,5.3814E+00,6.6410E+00,7.7706E+00,8.4452E+00,1.0763E+01,
     &8.4200E-01,1.6284E+00,3.2443E+00,4.8405E+00,6.4040E+00,7.9036E+00,
     &9.2460E+00,1.0057E+01,1.2808E+01/
      DATA ((KA(JS,JT, 4,15),JS=1,9),JT=1,5) /
     &9.7215E-01,8.5067E-01,1.3532E+00,2.0247E+00,2.6895E+00,3.3419E+00,
     &3.9624E+00,4.4662E+00,5.3791E+00,1.1632E+00,1.0264E+00,1.7937E+00,
     &2.6847E+00,3.5667E+00,4.4317E+00,5.2538E+00,5.9212E+00,7.1333E+00,
     &1.3574E+00,1.2217E+00,2.2951E+00,3.4352E+00,4.5625E+00,5.6686E+00,
     &6.7222E+00,7.5788E+00,9.1250E+00,1.5473E+00,1.4621E+00,2.8487E+00,
     &4.2635E+00,5.6651E+00,7.0387E+00,8.3491E+00,9.4177E+00,1.1330E+01,
     &1.7305E+00,1.7312E+00,3.4330E+00,5.1366E+00,6.8257E+00,8.4825E+00,
     &1.0065E+01,1.1356E+01,1.3651E+01/
      DATA ((KA(JS,JT, 5,15),JS=1,9),JT=1,5) /
     &1.7388E+00,1.5215E+00,1.3772E+00,1.9641E+00,2.6140E+00,3.2573E+00,
     &3.8853E+00,4.4515E+00,5.2280E+00,2.1169E+00,1.8521E+00,1.7962E+00,
     &2.6470E+00,3.5230E+00,4.3915E+00,5.2396E+00,6.0117E+00,7.0460E+00,
     &2.5041E+00,2.1909E+00,2.3110E+00,3.4553E+00,4.5986E+00,5.7308E+00,
     &6.8405E+00,7.8473E+00,9.1972E+00,2.8915E+00,2.5301E+00,2.9136E+00,
     &4.3640E+00,5.8101E+00,7.2418E+00,8.6447E+00,9.9184E+00,1.1620E+01,
     &3.2655E+00,2.8574E+00,3.5660E+00,5.3438E+00,7.1123E+00,8.8675E+00,
     &1.0583E+01,1.2152E+01,1.4224E+01/
      DATA ((KA(JS,JT, 6,15),JS=1,9),JT=1,5) /
     &2.8657E+00,2.5077E+00,2.1495E+00,1.9426E+00,2.5509E+00,3.1827E+00,
     &3.8069E+00,4.3973E+00,5.1017E+00,3.5656E+00,3.1200E+00,2.6742E+00,
     &2.5857E+00,3.4175E+00,4.2650E+00,5.1021E+00,5.8962E+00,6.8350E+00,
     &4.2807E+00,3.7458E+00,3.2105E+00,3.3891E+00,4.4929E+00,5.6082E+00,
     &6.7100E+00,7.7616E+00,8.9857E+00,5.0170E+00,4.3893E+00,3.7667E+00,
     &4.3378E+00,5.7738E+00,7.2087E+00,8.6270E+00,9.9837E+00,1.1548E+01,
     &5.7403E+00,5.0226E+00,4.3725E+00,5.3984E+00,7.1936E+00,8.9774E+00,
     &1.0747E+01,1.2440E+01,1.4387E+01/
      DATA ((KA(JS,JT, 7,15),JS=1,9),JT=1,5) /
     &4.9113E+00,4.2974E+00,3.6835E+00,3.0697E+00,2.6153E+00,3.1091E+00,
     &3.7251E+00,4.3239E+00,4.9783E+00,6.2562E+00,5.4743E+00,4.6920E+00,
     &3.9102E+00,3.4334E+00,4.1812E+00,5.0095E+00,5.8168E+00,6.6958E+00,
     &7.6604E+00,6.7031E+00,5.7453E+00,4.7880E+00,4.4844E+00,5.5063E+00,
     &6.5975E+00,7.6628E+00,8.8178E+00,9.1018E+00,7.9643E+00,6.8268E+00,
     &5.7331E+00,5.7498E+00,7.0854E+00,8.4900E+00,9.8659E+00,1.1347E+01,
     &1.0558E+01,9.2378E+00,7.9183E+00,6.7553E+00,7.1878E+00,8.8933E+00,
     &1.0658E+01,1.2385E+01,1.4238E+01/
      DATA ((KA(JS,JT, 8,15),JS=1,9),JT=1,5) /
     &1.0009E+01,8.7571E+00,7.5061E+00,6.2547E+00,5.0042E+00,3.7993E+00,
     &3.6112E+00,4.2052E+00,4.8194E+00,1.3089E+01,1.1454E+01,9.8171E+00,
     &8.1811E+00,6.5451E+00,5.0064E+00,4.9059E+00,5.7129E+00,6.5481E+00,
     &1.6387E+01,1.4339E+01,1.2290E+01,1.0242E+01,8.1941E+00,6.3517E+00,
     &6.5066E+00,7.5778E+00,8.6840E+00,1.9809E+01,1.7333E+01,1.4856E+01,
     &1.2381E+01,9.9047E+00,7.9569E+00,8.4189E+00,9.8052E+00,1.1235E+01,
     &2.3310E+01,2.0396E+01,1.7482E+01,1.4569E+01,1.1654E+01,9.7998E+00,
     &1.0613E+01,1.2362E+01,1.4162E+01/
      DATA ((KA(JS,JT, 9,15),JS=1,9),JT=1,5) /
     &3.8130E+01,3.3362E+01,2.8596E+01,2.3830E+01,1.9065E+01,1.4298E+01,
     &9.5322E+00,4.9254E+00,4.5210E+00,5.1350E+01,4.4933E+01,3.8514E+01,
     &3.2094E+01,2.5677E+01,1.9258E+01,1.2838E+01,6.6242E+00,6.3225E+00,
     &6.5865E+01,5.7633E+01,4.9398E+01,4.1167E+01,3.2931E+01,2.4701E+01,
     &1.6465E+01,8.5406E+00,8.4711E+00,8.1194E+01,7.1041E+01,6.0891E+01,
     &5.0738E+01,4.0591E+01,3.0449E+01,2.0297E+01,1.0902E+01,1.1050E+01,
     &9.6976E+01,8.4851E+01,7.2734E+01,6.0609E+01,4.8485E+01,3.6366E+01,
     &2.4244E+01,1.3609E+01,1.4022E+01/
      DATA ((KA(JS,JT,10,15),JS=1,9),JT=1,5) /
     &1.6495E+02,1.4434E+02,1.2371E+02,1.0308E+02,8.2478E+01,6.1862E+01,
     &4.1240E+01,2.0620E+01,1.6305E+00,2.2828E+02,1.9973E+02,1.7121E+02,
     &1.4267E+02,1.1414E+02,8.5604E+01,5.7062E+01,2.8536E+01,5.3393E+00,
     &2.9925E+02,2.6184E+02,2.2444E+02,1.8703E+02,1.4963E+02,1.1222E+02,
     &7.4815E+01,3.7408E+01,8.3308E+00,3.7719E+02,3.3003E+02,2.8287E+02,
     &2.3573E+02,1.8859E+02,1.4144E+02,9.4294E+01,4.7146E+01,1.0953E+01,
     &4.5955E+02,4.0214E+02,3.4467E+02,2.8724E+02,2.2979E+02,1.7235E+02,
     &1.1490E+02,5.7448E+01,1.3975E+01/
      DATA ((KA(JS,JT,11,15),JS=1,9),JT=1,5) /
     &2.9347E+02,2.5677E+02,2.2010E+02,1.8342E+02,1.4673E+02,1.1005E+02,
     &7.3365E+01,3.6685E+01,2.5030E-01,4.0846E+02,3.5738E+02,3.0635E+02,
     &2.5530E+02,2.0423E+02,1.5319E+02,1.0212E+02,5.1058E+01,2.2261E+00,
     &5.3934E+02,4.7191E+02,4.0450E+02,3.3708E+02,2.6969E+02,2.0225E+02,
     &1.3483E+02,6.7419E+01,7.0745E+00,6.8280E+02,5.9745E+02,5.1209E+02,
     &4.2676E+02,3.4141E+02,2.5605E+02,1.7070E+02,8.5353E+01,1.1909E+01,
     &8.3619E+02,7.3167E+02,6.2713E+02,5.2262E+02,4.1810E+02,3.1359E+02,
     &2.0904E+02,1.0453E+02,1.5372E+01/
      DATA ((KA(JS,JT,12,15),JS=1,9),JT=1,5) /
     &3.9587E+02,3.4637E+02,2.9690E+02,2.4742E+02,1.9794E+02,1.4844E+02,
     &9.8964E+01,4.9484E+01,3.4642E-05,5.5272E+02,4.8359E+02,4.1455E+02,
     &3.4543E+02,2.7636E+02,2.0725E+02,1.3818E+02,6.9086E+01,1.7207E+00,
     &7.3408E+02,6.4226E+02,5.5052E+02,4.5884E+02,3.6704E+02,2.7529E+02,
     &1.8352E+02,9.1757E+01,6.4555E+00,9.3778E+02,8.2044E+02,7.0331E+02,
     &5.8607E+02,4.6883E+02,3.5166E+02,2.3443E+02,1.1722E+02,1.0884E+01,
     &1.1629E+03,1.0175E+03,8.7216E+02,7.2684E+02,5.8142E+02,4.3609E+02,
     &2.9073E+02,1.4537E+02,1.6871E+01/
      DATA ((KA(JS,JT,13,15),JS=1,9),JT=1,5) /
     &4.3408E+02,3.7980E+02,3.2553E+02,2.7129E+02,2.1704E+02,1.6278E+02,
     &1.0851E+02,5.4254E+01,3.3387E-01,6.1113E+02,5.3482E+02,4.5841E+02,
     &3.8201E+02,3.0560E+02,2.2920E+02,1.5279E+02,7.6397E+01,3.4060E+00,
     &8.2033E+02,7.1780E+02,6.1525E+02,5.1272E+02,4.1017E+02,3.0764E+02,
     &2.0509E+02,1.0254E+02,7.3848E+00,1.0623E+03,9.2952E+02,7.9671E+02,
     &6.6390E+02,5.3111E+02,3.9834E+02,2.6556E+02,1.3278E+02,1.3310E+01,
     &1.3308E+03,1.1645E+03,9.9813E+02,8.3174E+02,6.6542E+02,4.9907E+02,
     &3.3271E+02,1.6635E+02,1.8499E+01/
      DATA ((KA(JS,JT, 1,16),JS=1,9),JT=1,5) /
     &1.7254E-01,6.6462E-01,1.3115E+00,1.9318E+00,2.5084E+00,3.0076E+00,
     &3.3449E+00,3.2523E+00,5.0169E+00,1.9945E-01,8.1688E-01,1.6118E+00,
     &2.3741E+00,3.0836E+00,3.6966E+00,4.1116E+00,3.9980E+00,6.1673E+00,
     &2.2510E-01,1.0070E+00,1.9841E+00,2.9159E+00,3.7748E+00,4.5037E+00,
     &4.9689E+00,4.7883E+00,7.5495E+00,2.5048E-01,1.2252E+00,2.4140E+00,
     &3.5479E+00,4.5928E+00,5.4806E+00,6.0471E+00,5.7831E+00,9.1856E+00,
     &2.7413E-01,1.4585E+00,2.8735E+00,4.2233E+00,5.4678E+00,6.4913E+00,
     &7.1996E+00,6.8835E+00,1.0936E+01/
      DATA ((KA(JS,JT, 2,16),JS=1,9),JT=1,5) /
     &2.5949E-01,7.4073E-01,1.4685E+00,2.1764E+00,2.8509E+00,3.4639E+00,
     &3.9405E+00,4.0097E+00,5.7017E+00,3.0220E-01,9.2128E-01,1.8172E+00,
     &2.6931E+00,3.5460E+00,4.3080E+00,4.9007E+00,4.9876E+00,7.0918E+00,
     &3.4341E-01,1.1291E+00,2.2360E+00,3.3088E+00,4.3252E+00,5.2383E+00,
     &5.9360E+00,6.0318E+00,8.6502E+00,3.8325E-01,1.3874E+00,2.7481E+00,
     &4.0666E+00,5.3159E+00,6.4367E+00,7.2790E+00,7.3059E+00,1.0632E+01,
     &4.2153E-01,1.6660E+00,3.2992E+00,4.8823E+00,6.3819E+00,7.7290E+00,
     &8.7410E+00,8.7737E+00,1.2764E+01/
      DATA ((KA(JS,JT, 3,16),JS=1,9),JT=1,5) /
     &5.0644E-01,7.8255E-01,1.5587E+00,2.3239E+00,3.0716E+00,3.7848E+00,
     &4.4177E+00,4.7740E+00,6.1431E+00,5.9759E-01,9.9169E-01,1.9751E+00,
     &2.9450E+00,3.8926E+00,4.7966E+00,5.5986E+00,6.0493E+00,7.7852E+00,
     &6.8696E-01,1.2186E+00,2.4265E+00,3.6186E+00,4.7825E+00,5.8630E+00,
     &6.8786E+00,7.4328E+00,9.5649E+00,7.7291E-01,1.5044E+00,2.9942E+00,
     &4.4622E+00,5.8918E+00,7.2471E+00,8.4308E+00,9.0321E+00,1.1784E+01,
     &8.5655E-01,1.8308E+00,3.6443E+00,5.4303E+00,7.1696E+00,8.8191E+00,
     &1.0261E+01,1.0994E+01,1.4339E+01/
      DATA ((KA(JS,JT, 4,16),JS=1,9),JT=1,5) /
     &9.9660E-01,8.7187E-01,1.6058E+00,2.4020E+00,3.1900E+00,3.9596E+00,
     &4.6884E+00,5.2602E+00,6.3800E+00,1.1909E+00,1.0454E+00,2.0813E+00,
     &3.1135E+00,4.1338E+00,5.1320E+00,6.0754E+00,6.8176E+00,8.2675E+00,
     &1.3883E+00,1.3053E+00,2.6054E+00,3.8972E+00,5.1746E+00,6.4245E+00,
     &7.6056E+00,8.5415E+00,1.0349E+01,1.5813E+00,1.6017E+00,3.1965E+00,
     &4.7803E+00,6.3446E+00,7.8728E+00,9.3118E+00,1.0423E+01,1.2689E+01,
     &1.7666E+00,1.9742E+00,3.9398E+00,5.8918E+00,7.8191E+00,9.6976E+00,
     &1.1463E+01,1.2804E+01,1.5638E+01/
      DATA ((KA(JS,JT, 5,16),JS=1,9),JT=1,5) /
     &1.7905E+00,1.5668E+00,1.6306E+00,2.4424E+00,3.2499E+00,4.0478E+00,
     &4.8237E+00,5.5141E+00,6.4998E+00,2.1763E+00,1.9041E+00,2.1658E+00,
     &3.2440E+00,4.3166E+00,5.3771E+00,6.4071E+00,7.3247E+00,8.6332E+00,
     &2.5702E+00,2.2488E+00,2.7671E+00,4.1446E+00,5.5145E+00,6.8692E+00,
     &8.1862E+00,9.3584E+00,1.1029E+01,2.9652E+00,2.5941E+00,3.4291E+00,
     &5.1370E+00,6.8346E+00,8.5115E+00,1.0142E+01,1.1590E+01,1.3669E+01,
     &3.3442E+00,2.9260E+00,4.2225E+00,6.3231E+00,8.4117E+00,1.0473E+01,
     &1.2473E+01,1.4226E+01,1.6823E+01/
      DATA ((KA(JS,JT, 6,16),JS=1,9),JT=1,5) /
     &2.9659E+00,2.5957E+00,2.2251E+00,2.4192E+00,3.2212E+00,4.0191E+00,
     &4.8055E+00,5.5432E+00,6.4424E+00,3.6832E+00,3.2223E+00,2.7616E+00,
     &3.3057E+00,4.4026E+00,5.4931E+00,6.5666E+00,7.5768E+00,8.8051E+00,
     &4.4116E+00,3.8604E+00,3.3096E+00,4.3238E+00,5.7589E+00,7.1852E+00,
     &8.5905E+00,9.9138E+00,1.1518E+01,5.1628E+00,4.5167E+00,3.8530E+00,
     &5.4598E+00,7.2711E+00,9.0722E+00,1.0846E+01,1.2515E+01,1.4542E+01,
     &5.8968E+00,5.1602E+00,4.5054E+00,6.7527E+00,8.9935E+00,1.1218E+01,
     &1.3409E+01,1.5457E+01,1.7987E+01/
      DATA ((KA(JS,JT, 7,16),JS=1,9),JT=1,5) /
     &5.1220E+00,4.4578E+00,3.8412E+00,3.1847E+00,3.1367E+00,3.9170E+00,
     &4.6915E+00,5.4417E+00,6.2734E+00,6.5146E+00,5.7005E+00,4.8852E+00,
     &4.0720E+00,4.4224E+00,5.5237E+00,6.6151E+00,7.6744E+00,8.8447E+00,
     &7.9642E+00,6.9679E+00,5.9715E+00,4.9772E+00,5.9352E+00,7.4116E+00,
     &8.8775E+00,1.0298E+01,1.1870E+01,9.4454E+00,8.2650E+00,7.0847E+00,
     &5.9047E+00,7.6537E+00,9.5584E+00,1.1448E+01,1.3281E+01,1.5307E+01,
     &1.0942E+01,9.5731E+00,8.2052E+00,7.1985E+00,9.5915E+00,1.1978E+01,
     &1.4344E+01,1.6634E+01,1.9183E+01/
      DATA ((KA(JS,JT, 8,16),JS=1,9),JT=1,5) /
     &1.0533E+01,9.2146E+00,7.8983E+00,6.5814E+00,5.2661E+00,3.9493E+00,
     &4.5315E+00,5.2737E+00,6.0497E+00,1.3750E+01,1.2032E+01,1.0313E+01,
     &8.5934E+00,6.8745E+00,5.4846E+00,6.5763E+00,7.6139E+00,8.7787E+00,
     &1.7175E+01,1.5029E+01,1.2881E+01,1.0735E+01,8.5883E+00,7.5634E+00,
     &9.0692E+00,1.0555E+01,1.2107E+01,2.0707E+01,1.8120E+01,1.5532E+01,
     &1.2944E+01,1.0356E+01,9.9766E+00,1.1963E+01,1.3921E+01,1.5970E+01,
     &2.4320E+01,2.1282E+01,1.8238E+01,1.5200E+01,1.2161E+01,1.2723E+01,
     &1.5254E+01,1.7752E+01,2.0364E+01/
      DATA ((KA(JS,JT, 9,16),JS=1,9),JT=1,5) /
     &4.0363E+01,3.5318E+01,3.0273E+01,2.5227E+01,2.0181E+01,1.5134E+01,
     &1.0090E+01,5.4212E+00,6.1996E+00,5.4231E+01,4.7444E+01,4.0667E+01,
     &3.3896E+01,2.7114E+01,2.0336E+01,1.3557E+01,7.4876E+00,8.5638E+00,
     &6.9375E+01,6.0706E+01,5.2030E+01,4.3363E+01,3.4693E+01,2.6019E+01,
     &1.7346E+01,1.0642E+01,1.2169E+01,8.5364E+01,7.4694E+01,6.4003E+01,
     &5.3349E+01,4.2675E+01,3.2007E+01,2.1338E+01,1.4379E+01,1.6444E+01,
     &1.0173E+02,8.9011E+01,7.6294E+01,6.3578E+01,5.0858E+01,3.8147E+01,
     &2.5431E+01,1.8715E+01,2.1406E+01/
      DATA ((KA(JS,JT,10,16),JS=1,9),JT=1,5) /
     &1.7518E+02,1.5326E+02,1.3138E+02,1.0946E+02,8.7589E+01,6.5684E+01,
     &4.3795E+01,2.1898E+01,6.6096E+00,2.4209E+02,2.1181E+02,1.8152E+02,
     &1.5127E+02,1.2102E+02,9.0779E+01,6.0510E+01,3.0258E+01,8.7477E+00,
     &3.1702E+02,2.7739E+02,2.3777E+02,1.9810E+02,1.5849E+02,1.1888E+02,
     &7.9249E+01,3.9623E+01,1.2377E+01,3.9791E+02,3.4817E+02,2.9841E+02,
     &2.4869E+02,1.9896E+02,1.4923E+02,9.9472E+01,4.9736E+01,1.7102E+01,
     &4.8342E+02,4.2295E+02,3.6251E+02,3.0211E+02,2.4169E+02,1.8128E+02,
     &1.2083E+02,6.0427E+01,2.2752E+01/
      DATA ((KA(JS,JT,11,16),JS=1,9),JT=1,5) /
     &3.1380E+02,2.7453E+02,2.3526E+02,1.9609E+02,1.5686E+02,1.1764E+02,
     &7.8455E+01,3.9219E+01,4.1702E-05,4.3458E+02,3.8032E+02,3.2596E+02,
     &2.7165E+02,2.1736E+02,1.6300E+02,1.0866E+02,5.4331E+01,1.0603E+01,
     &5.7279E+02,5.0121E+02,4.2963E+02,3.5802E+02,2.8639E+02,2.1479E+02,
     &1.4321E+02,7.1606E+01,1.4737E+01,7.2603E+02,6.3199E+02,5.4450E+02,
     &4.5379E+02,3.6299E+02,2.7226E+02,1.8150E+02,9.0755E+01,2.0418E+01,
     &8.9810E+02,7.8584E+02,6.7355E+02,5.6126E+02,4.4901E+02,3.3674E+02,
     &2.2451E+02,1.1225E+02,2.7345E+01/
      DATA ((KA(JS,JT,12,16),JS=1,9),JT=1,5) /
     &4.2564E+02,3.7252E+02,3.1927E+02,2.6605E+02,2.1287E+02,1.5962E+02,
     &1.0643E+02,5.3212E+01,3.3974E-05,5.9696E+02,5.2232E+02,4.4774E+02,
     &3.7307E+02,2.9847E+02,2.2385E+02,1.4924E+02,7.4619E+01,1.2841E+01,
     &8.0130E+02,7.0109E+02,6.0095E+02,5.0082E+02,4.0064E+02,3.0049E+02,
     &2.0030E+02,1.0016E+02,1.7604E+01,1.0424E+03,9.1209E+02,7.8186E+02,
     &6.5151E+02,5.2121E+02,3.9092E+02,2.6059E+02,1.3030E+02,2.4408E+01,
     &1.3107E+03,1.1467E+03,9.8296E+02,8.1915E+02,6.5538E+02,4.9148E+02,
     &3.2766E+02,1.6385E+02,3.2853E+01/
      DATA ((KA(JS,JT,13,16),JS=1,9),JT=1,5) /
     &4.8122E+02,4.2105E+02,3.6087E+02,3.0076E+02,2.4060E+02,1.8046E+02,
     &1.2030E+02,6.0148E+01,7.3993E+00,6.9206E+02,6.0557E+02,5.1907E+02,
     &4.3255E+02,3.4603E+02,2.5955E+02,1.7302E+02,8.6508E+01,1.5501E+01,
     &9.4703E+02,8.2867E+02,7.1030E+02,5.9189E+02,4.7354E+02,3.5512E+02,
     &2.3675E+02,1.1838E+02,2.1029E+01,1.2338E+03,1.0854E+03,9.3026E+02,
     &7.7526E+02,6.2018E+02,4.6513E+02,3.1009E+02,1.5423E+02,2.9122E+01,
     &1.5695E+03,1.3734E+03,1.1772E+03,9.8104E+02,7.8484E+02,5.8860E+02,
     &3.9240E+02,1.9620E+02,3.9289E+01/

C     The array KA contains absorption coefs for each of the 16 g-intervals
C     for a range of pressure levels > ~100mb, temperatures, and ratios
C     of water vapor to CO2.  The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.
C     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
C     to different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this  pressure 
C     level, JT = 2 refers to the temperature
C     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
C     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
C     to the reference pressure level (e.g. JP = 1 is for a
C     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA ((KB(JS,JT,13, 1),JS=1,5),JT=1,5) /
     &9.4796E-05,1.4361E-04,1.4118E-04,1.1819E-04,7.6303E-05,
     &9.7387E-05,1.7115E-04,1.7300E-04,1.4824E-04,1.0469E-04,
     &1.0951E-04,2.1604E-04,2.2323E-04,1.9350E-04,1.3818E-04,
     &1.3449E-04,2.8552E-04,2.9728E-04,2.5764E-04,1.7597E-04,
     &1.7577E-04,3.8714E-04,4.0359E-04,3.4654E-04,2.1851E-04/
      DATA ((KB(JS,JT,14, 1),JS=1,5),JT=1,5) /
     &7.9000E-05,1.2113E-04,1.1920E-04,9.9664E-05,6.3646E-05,
     &8.1870E-05,1.4526E-04,1.4705E-04,1.2557E-04,8.6376E-05,
     &9.2975E-05,1.8451E-04,1.9063E-04,1.6489E-04,1.1348E-04,
     &1.1499E-04,2.4478E-04,2.5460E-04,2.2031E-04,1.4451E-04,
     &1.5077E-04,3.3228E-04,3.4580E-04,2.9716E-04,1.7798E-04/
      DATA ((KB(JS,JT,15, 1),JS=1,5),JT=1,5) /
     &6.3146E-05,9.9373E-05,9.8373E-05,8.2691E-05,5.2397E-05,
     &6.6078E-05,1.2006E-04,1.2228E-04,1.0469E-04,7.0411E-05,
     &7.5821E-05,1.5360E-04,1.5869E-04,1.3814E-04,9.1603E-05,
     &9.4372E-05,2.0448E-04,2.1279E-04,1.8521E-04,1.1587E-04,
     &1.2416E-04,2.7753E-04,2.8967E-04,2.5010E-04,1.4409E-04/
      DATA ((KB(JS,JT,16, 1),JS=1,5),JT=1,5) /
     &4.9335E-05,8.0237E-05,8.0247E-05,6.8036E-05,4.2623E-05,
     &5.2173E-05,9.7834E-05,1.0022E-04,8.6725E-05,5.7211E-05,
     &6.0461E-05,1.2605E-04,1.3061E-04,1.1470E-04,7.4324E-05,
     &7.5694E-05,1.6827E-04,1.7572E-04,1.5404E-04,9.3686E-05,
     &9.9955E-05,2.2866E-04,2.3956E-04,2.0826E-04,1.1548E-04/
      DATA ((KB(JS,JT,17, 1),JS=1,5),JT=1,5) /
     &3.8266E-05,6.4449E-05,6.5172E-05,5.5789E-05,3.5130E-05,
     &4.0895E-05,7.9297E-05,8.1758E-05,7.1548E-05,4.6781E-05,
     &4.7807E-05,1.0278E-04,1.0697E-04,9.4840E-05,6.0133E-05,
     &6.0159E-05,1.3765E-04,1.4446E-04,1.2759E-04,7.5139E-05,
     &7.9747E-05,1.8704E-04,1.9692E-04,1.7259E-04,9.1648E-05/
      DATA ((KB(JS,JT,18, 1),JS=1,5),JT=1,5) /
     &2.9184E-05,5.1211E-05,5.2362E-05,4.5451E-05,2.8937E-05,
     &3.1502E-05,6.3605E-05,6.6096E-05,5.8591E-05,3.8202E-05,
     &3.7129E-05,8.2865E-05,8.6932E-05,7.7931E-05,4.8777E-05,
     &4.6953E-05,1.1128E-04,1.1763E-04,1.0496E-04,6.0806E-05,
     &6.2502E-05,1.5129E-04,1.6025E-04,1.4184E-04,7.4536E-05/
      DATA ((KB(JS,JT,19, 1),JS=1,5),JT=1,5) /
     &2.2672E-05,4.1242E-05,4.2527E-05,3.7342E-05,2.3934E-05,
     &2.4699E-05,5.1600E-05,5.3953E-05,4.8350E-05,3.1473E-05,
     &2.9334E-05,6.7547E-05,7.1294E-05,6.4461E-05,4.0025E-05,
     &3.7286E-05,9.0838E-05,9.6625E-05,8.6862E-05,4.9869E-05,
     &4.9822E-05,1.2352E-04,1.3152E-04,1.1713E-04,6.1219E-05/
      DATA ((KB(JS,JT,20, 1),JS=1,5),JT=1,5) /
     &1.8003E-05,3.3802E-05,3.5042E-05,3.1068E-05,2.0074E-05,
     &1.9811E-05,4.2600E-05,4.4765E-05,4.0426E-05,2.6188E-05,
     &2.3740E-05,5.5990E-05,5.9400E-05,5.4019E-05,3.3275E-05,
     &3.0362E-05,7.5435E-05,8.0630E-05,7.2808E-05,4.1380E-05,
     &4.0743E-05,1.0263E-04,1.0963E-04,9.7998E-05,5.0442E-05/
      DATA ((KB(JS,JT,21, 1),JS=1,5),JT=1,5) /
     &1.4410E-05,2.7872E-05,2.9027E-05,2.5943E-05,1.6820E-05,
     &1.6018E-05,3.5348E-05,3.7320E-05,3.3900E-05,2.1893E-05,
     &1.9364E-05,4.6630E-05,4.9701E-05,4.5376E-05,2.7723E-05,
     &2.4923E-05,6.2936E-05,6.7505E-05,6.1129E-05,3.4253E-05,
     &3.3581E-05,8.5657E-05,9.1740E-05,8.2183E-05,4.1502E-05/
      DATA ((KB(JS,JT,22, 1),JS=1,5),JT=1,5) /
     &1.1606E-05,2.3345E-05,2.4458E-05,2.2044E-05,1.4341E-05,
     &1.3108E-05,2.9860E-05,3.1703E-05,2.8973E-05,1.8544E-05,
     &1.6058E-05,3.9598E-05,4.2399E-05,3.8843E-05,2.3272E-05,
     &2.0871E-05,5.3592E-05,5.7668E-05,5.2303E-05,2.8594E-05,
     &2.8287E-05,7.2910E-05,7.8274E-05,7.0191E-05,3.4495E-05/
      DATA ((KB(JS,JT,23, 1),JS=1,5),JT=1,5) /
     &9.3973E-06,1.9636E-05,2.0704E-05,1.8793E-05,1.2204E-05,
     &1.0787E-05,2.5322E-05,2.7025E-05,2.4831E-05,1.5654E-05,
     &1.3385E-05,3.3729E-05,3.6290E-05,3.3307E-05,1.9609E-05,
     &1.7566E-05,4.5745E-05,4.9368E-05,4.4833E-05,2.3893E-05,
     &2.3931E-05,6.2215E-05,6.6919E-05,6.0045E-05,2.8668E-05/
      DATA ((KB(JS,JT,24, 1),JS=1,5),JT=1,5) /
     &7.7170E-06,1.6679E-05,1.7685E-05,1.6128E-05,1.0358E-05,
     &9.0120E-06,2.1659E-05,2.3221E-05,2.1395E-05,1.3206E-05,
     &1.1319E-05,2.8989E-05,3.1289E-05,2.8717E-05,1.6361E-05,
     &1.4992E-05,3.9385E-05,4.2555E-05,3.8633E-05,1.9891E-05,
     &2.0520E-05,5.3479E-05,5.7600E-05,5.1654E-05,2.3746E-05/
      DATA ((KB(JS,JT,25, 1),JS=1,5),JT=1,5) /
     &6.3838E-06,1.4248E-05,1.5168E-05,1.3906E-05,8.8251E-06,
     &7.5878E-06,1.8635E-05,2.0050E-05,1.8513E-05,1.1119E-05,
     &9.6475E-06,2.5052E-05,2.7110E-05,2.4846E-05,1.3734E-05,
     &1.2889E-05,3.4075E-05,3.6834E-05,3.3385E-05,1.6609E-05,
     &1.7706E-05,4.6181E-05,4.9751E-05,4.4544E-05,1.9735E-05/
      DATA ((KB(JS,JT,26, 1),JS=1,5),JT=1,5) /
     &5.3393E-06,1.2288E-05,1.3132E-05,1.2096E-05,7.5264E-06,
     &6.4609E-06,1.6189E-05,1.7467E-05,1.6131E-05,9.4332E-06,
     &8.3200E-06,2.1853E-05,2.3681E-05,2.1653E-05,1.1593E-05,
     &1.1209E-05,2.9737E-05,3.2133E-05,2.9046E-05,1.3941E-05,
     &1.5443E-05,4.0196E-05,4.3302E-05,3.8639E-05,1.6481E-05/
      DATA ((KB(JS,JT,27, 1),JS=1,5),JT=1,5) /
     &4.5029E-06,1.0646E-05,1.1429E-05,1.0549E-05,6.4263E-06,
     &5.5408E-06,1.4124E-05,1.5272E-05,1.4080E-05,8.0128E-06,
     &7.2235E-06,1.9128E-05,2.0734E-05,1.8902E-05,9.7874E-06,
     &9.8044E-06,2.6022E-05,2.8102E-05,2.5321E-05,1.1642E-05,
     &1.3531E-05,3.5058E-05,3.7762E-05,3.3580E-05,1.3712E-05/
      DATA ((KB(JS,JT,28, 1),JS=1,5),JT=1,5) /
     &3.8267E-06,9.2605E-06,9.9753E-06,9.2087E-06,5.4910E-06,
     &4.7813E-06,1.2361E-05,1.3381E-05,1.2301E-05,6.7809E-06,
     &6.3052E-06,1.6784E-05,1.8184E-05,1.6520E-05,8.1872E-06,
     &8.6092E-06,2.2800E-05,2.4603E-05,2.2078E-05,9.6541E-06,
     &1.1891E-05,3.0613E-05,3.2964E-05,2.9199E-05,1.1371E-05/
      DATA ((KB(JS,JT,29, 1),JS=1,5),JT=1,5) /
     &3.2554E-06,8.0646E-06,8.7115E-06,8.0443E-06,4.6597E-06,
     &4.1267E-06,1.0826E-05,1.1737E-05,1.0754E-05,5.7169E-06,
     &5.4998E-06,1.4722E-05,1.5944E-05,1.4441E-05,6.8326E-06,
     &7.5454E-06,1.9957E-05,2.1533E-05,1.9256E-05,8.0674E-06,
     &1.0421E-05,2.6692E-05,2.8752E-05,2.5378E-05,9.4635E-06/
      DATA ((KB(JS,JT,30, 1),JS=1,5),JT=1,5) /
     &2.7722E-06,7.0257E-06,7.6070E-06,7.0209E-06,3.9148E-06,
     &3.5629E-06,9.4753E-06,1.0287E-05,9.3951E-06,4.7641E-06,
     &4.7932E-06,1.2893E-05,1.3959E-05,1.2600E-05,5.6708E-06,
     &6.5982E-06,1.7431E-05,1.8810E-05,1.6759E-05,6.6902E-06,
     &9.1066E-06,2.3231E-05,2.5041E-05,2.2031E-05,7.8394E-06/
      DATA ((KB(JS,JT,31, 1),JS=1,5),JT=1,5) /
     &2.3506E-06,6.1052E-06,6.6305E-06,6.1196E-06,3.2861E-06,
     &3.0616E-06,8.2670E-06,8.9874E-06,8.1933E-06,3.9690E-06,
     &4.1518E-06,1.1245E-05,1.2180E-05,1.0973E-05,4.7077E-06,
     &5.7278E-06,1.5154E-05,1.6366E-05,1.4549E-05,5.5398E-06,
     &7.8906E-06,2.0109E-05,2.1708E-05,1.9053E-05,6.4566E-06/
      DATA ((KB(JS,JT,32, 1),JS=1,5),JT=1,5) /
     &2.0097E-06,5.3323E-06,5.8021E-06,5.3502E-06,2.7241E-06,
     &2.6508E-06,7.2383E-06,7.8773E-06,7.1648E-06,3.2755E-06,
     &3.6184E-06,9.8348E-06,1.0656E-05,9.5737E-06,3.8774E-06,
     &4.9951E-06,1.3205E-05,1.4271E-05,1.2656E-05,4.5194E-06,
     &6.8654E-06,1.7445E-05,1.8860E-05,1.6511E-05,5.2597E-06/
      DATA ((KB(JS,JT,33, 1),JS=1,5),JT=1,5) /
     &1.7307E-06,4.6719E-06,5.0926E-06,4.6864E-06,2.2504E-06,
     &2.3079E-06,6.3540E-06,6.9152E-06,6.2764E-06,2.6926E-06,
     &3.1665E-06,8.6147E-06,9.3343E-06,8.3614E-06,3.1814E-06,
     &4.3731E-06,1.1528E-05,1.2464E-05,1.1023E-05,3.7164E-06,
     &5.9878E-06,1.5151E-05,1.6400E-05,1.4316E-05,4.2974E-06/
      DATA ((KB(JS,JT,34, 1),JS=1,5),JT=1,5) /
     &1.4981E-06,4.0834E-06,4.4531E-06,4.0843E-06,1.8539E-06,
     &2.0150E-06,5.5569E-06,6.0419E-06,5.4716E-06,2.2285E-06,
     &2.7725E-06,7.5151E-06,8.1387E-06,7.2690E-06,2.6334E-06,
     &3.8256E-06,1.0019E-05,1.0836E-05,9.5549E-06,3.0709E-06,
     &5.2217E-06,1.3116E-05,1.4207E-05,1.2368E-05,3.5492E-06/
      DATA ((KB(JS,JT,35, 1),JS=1,5),JT=1,5) /
     &1.2683E-06,3.4717E-06,3.7843E-06,3.4639E-06,1.5033E-06,
     &1.7130E-06,4.7242E-06,5.1321E-06,4.6386E-06,1.8045E-06,
     &2.3598E-06,6.3794E-06,6.9043E-06,6.1552E-06,2.1312E-06,
     &3.2533E-06,8.4861E-06,9.1773E-06,8.0771E-06,2.4797E-06,
     &4.4317E-06,1.1084E-05,1.2009E-05,1.0436E-05,2.8460E-06/
      DATA ((KB(JS,JT,36, 1),JS=1,5),JT=1,5) /
     &1.0446E-06,2.8596E-06,3.1142E-06,2.8488E-06,1.1841E-06,
     &1.4115E-06,3.8911E-06,4.2236E-06,3.8148E-06,1.4188E-06,
     &1.9447E-06,5.2529E-06,5.6822E-06,5.0612E-06,1.6763E-06,
     &2.6806E-06,6.9854E-06,7.5506E-06,6.6402E-06,1.9492E-06,
     &3.6503E-06,9.1210E-06,9.8800E-06,8.5784E-06,2.2478E-06/
      DATA ((KB(JS,JT,37, 1),JS=1,5),JT=1,5) /
     &8.3141E-07,2.2606E-06,2.4589E-06,2.2521E-06,9.1953E-07,
     &1.1186E-06,3.0759E-06,3.3374E-06,3.0170E-06,1.1075E-06,
     &1.5392E-06,4.1590E-06,4.4972E-06,4.0085E-06,1.3109E-06,
     &2.1232E-06,5.5433E-06,5.9872E-06,5.2697E-06,1.5318E-06,
     &2.8971E-06,7.2549E-06,7.8520E-06,6.8216E-06,1.7720E-06/
      DATA ((KB(JS,JT,38, 1),JS=1,5),JT=1,5) /
     &6.6100E-07,1.7834E-06,1.9371E-06,1.7763E-06,7.1225E-07,
     &8.8499E-07,2.4255E-06,2.6307E-06,2.3793E-06,8.6302E-07,
     &1.2155E-06,3.2848E-06,3.5503E-06,3.1675E-06,1.0267E-06,
     &1.6779E-06,4.3885E-06,4.7364E-06,4.1721E-06,1.2041E-06,
     &2.2938E-06,5.7578E-06,6.2256E-06,5.4129E-06,1.3941E-06/
      DATA ((KB(JS,JT,39, 1),JS=1,5),JT=1,5) /
     &5.2622E-07,1.4074E-06,1.5268E-06,1.4013E-06,5.4821E-07,
     &7.0069E-07,1.9130E-06,2.0737E-06,1.8765E-06,6.6832E-07,
     &9.6029E-07,2.5942E-06,2.8023E-06,2.5024E-06,8.0073E-07,
     &1.3259E-06,3.4737E-06,3.7464E-06,3.3022E-06,9.3841E-07,
     &1.8162E-06,4.5691E-06,4.9354E-06,4.2944E-06,1.0896E-06/
      DATA ((KB(JS,JT,40, 1),JS=1,5),JT=1,5) /
     &4.1271E-07,1.0842E-06,1.1736E-06,1.0777E-06,4.1787E-07,
     &5.4389E-07,1.4709E-06,1.5926E-06,1.4421E-06,5.1017E-07,
     &7.4188E-07,1.9982E-06,2.1561E-06,1.9284E-06,6.1575E-07,
     &1.0242E-06,2.6854E-06,2.8924E-06,2.5529E-06,7.2613E-07,
     &1.4067E-06,3.5476E-06,3.8249E-06,3.3331E-06,8.4610E-07/
      DATA ((KB(JS,JT,41, 1),JS=1,5),JT=1,5) /
     &3.2432E-07,8.3392E-07,9.0025E-07,8.2659E-07,3.1699E-07,
     &4.2215E-07,1.1277E-06,1.2186E-06,1.1049E-06,3.8959E-07,
     &5.7203E-07,1.5335E-06,1.6530E-06,1.4808E-06,4.7229E-07,
     &7.8892E-07,2.0682E-06,2.2251E-06,1.9663E-06,5.6019E-07,
     &1.0862E-06,2.7447E-06,2.9535E-06,2.5776E-06,6.5591E-07/
      DATA ((KB(JS,JT,42, 1),JS=1,5),JT=1,5) /
     &2.5587E-07,6.4253E-07,6.9167E-07,6.3420E-07,2.3952E-07,
     &3.2863E-07,8.6497E-07,9.3264E-07,8.4649E-07,2.9775E-07,
     &4.4164E-07,1.1761E-06,1.2667E-06,1.1361E-06,3.6120E-07,
     &6.0774E-07,1.5914E-06,1.7100E-06,1.5131E-06,4.3157E-07,
     &8.3802E-07,2.1211E-06,2.2785E-06,1.9912E-06,5.0721E-07/
      DATA ((KB(JS,JT,43, 1),JS=1,5),JT=1,5) /
     &2.0233E-07,4.9120E-07,5.2639E-07,4.8089E-07,1.7965E-07,
     &2.5538E-07,6.5692E-07,7.0547E-07,6.4075E-07,2.2496E-07,
     &3.3917E-07,8.9179E-07,9.5869E-07,8.5986E-07,2.7469E-07,
     &4.6446E-07,1.2101E-06,1.2978E-06,1.1498E-06,3.3044E-07,
     &6.4112E-07,1.6212E-06,1.7373E-06,1.5201E-06,3.9028E-07/
      DATA ((KB(JS,JT,44, 1),JS=1,5),JT=1,5) /
     &1.6122E-07,3.7551E-07,3.9960E-07,3.6377E-07,1.3351E-07,
     &1.9938E-07,4.9773E-07,5.3195E-07,4.8258E-07,1.6857E-07,
     &2.6075E-07,6.7334E-07,7.2162E-07,6.4719E-07,2.0768E-07,
     &3.5440E-07,9.1528E-07,9.7926E-07,8.6831E-07,2.5128E-07,
     &4.8882E-07,1.2321E-06,1.3171E-06,1.1536E-06,2.9843E-07/
      DATA ((KB(JS,JT,45, 1),JS=1,5),JT=1,5) /
     &1.2988E-07,2.8870E-07,3.0532E-07,2.7582E-07,9.8684E-08,
     &1.5689E-07,3.7846E-07,4.0235E-07,3.6402E-07,1.2561E-07,
     &2.0165E-07,5.0920E-07,5.4343E-07,4.8733E-07,1.5620E-07,
     &2.7120E-07,6.9216E-07,7.3881E-07,6.5533E-07,1.9009E-07,
     &3.7310E-07,9.3568E-07,9.9762E-07,8.7425E-07,2.2785E-07/
      DATA ((KB(JS,JT,46, 1),JS=1,5),JT=1,5) /
     &1.0564E-07,2.2197E-07,2.3290E-07,2.0875E-07,7.2454E-08,
     &1.2404E-07,2.8745E-07,3.0379E-07,2.7335E-07,9.2971E-08,
     &1.5624E-07,3.8369E-07,4.0737E-07,3.6500E-07,1.1671E-07,
     &2.0727E-07,5.2051E-07,5.5407E-07,4.9156E-07,1.4314E-07,
     &2.8357E-07,7.0586E-07,7.5047E-07,6.5798E-07,1.7235E-07/
      DATA ((KB(JS,JT,47, 1),JS=1,5),JT=1,5) /
     &8.6916E-08,1.7066E-07,1.7731E-07,1.5740E-07,5.2956E-08,
     &9.8603E-08,2.1737E-07,2.2800E-07,2.0365E-07,6.8355E-08,
     &1.2114E-07,2.8693E-07,3.0257E-07,2.7060E-07,8.6098E-08,
     &1.5770E-07,3.8735E-07,4.1075E-07,3.6401E-07,1.0681E-07,
     &2.1366E-07,5.2607E-07,5.5766E-07,4.8899E-07,1.2936E-07/
      DATA ((KB(JS,JT,48, 1),JS=1,5),JT=1,5) /
     &7.2690E-08,1.3243E-07,1.3635E-07,1.1959E-07,3.9422E-08,
     &7.9634E-08,1.6556E-07,1.7235E-07,1.5270E-07,4.9882E-08,
     &9.5002E-08,2.1570E-07,2.2592E-07,2.0102E-07,6.3148E-08,
     &1.2105E-07,2.8907E-07,3.0482E-07,2.6976E-07,7.9242E-08,
     &1.6180E-07,3.9224E-07,4.1437E-07,3.6322E-07,9.6936E-08/
      DATA ((KB(JS,JT,49, 1),JS=1,5),JT=1,5) /
     &6.1774E-08,1.0401E-07,1.0607E-07,9.1394E-08,2.9238E-08,
     &6.5366E-08,1.2732E-07,1.3151E-07,1.1526E-07,3.6075E-08,
     &7.5416E-08,1.6321E-07,1.6967E-07,1.4985E-07,4.6286E-08,
     &9.3863E-08,2.1656E-07,2.2682E-07,2.0018E-07,5.8261E-08,
     &1.2334E-07,2.9285E-07,3.0807E-07,2.6986E-07,7.1843E-08/
      DATA ((KB(JS,JT,50, 1),JS=1,5),JT=1,5) /
     &5.3206E-08,8.3103E-08,8.3626E-08,7.1042E-08,2.0418E-08,
     &5.4599E-08,9.9314E-08,1.0171E-07,8.8074E-08,2.6669E-08,
     &6.0981E-08,1.2515E-07,1.2917E-07,1.1305E-07,3.4171E-08,
     &7.3992E-08,1.6416E-07,1.7066E-07,1.4995E-07,4.3100E-08,
     &9.5401E-08,2.2074E-07,2.3106E-07,2.0200E-07,5.3679E-08/
      DATA ((KB(JS,JT,51, 1),JS=1,5),JT=1,5) /
     &4.6282E-08,6.7151E-08,6.6436E-08,5.6117E-08,1.4310E-08,
     &4.6293E-08,7.8464E-08,7.9611E-08,6.7952E-08,2.0313E-08,
     &5.0084E-08,9.7036E-08,9.9288E-08,8.6023E-08,2.5137E-08,
     &5.9071E-08,1.2553E-07,1.2948E-07,1.1300E-07,3.2036E-08,
     &7.4640E-08,1.6747E-07,1.7423E-07,1.5170E-07,4.0217E-08/
      DATA ((KB(JS,JT,52, 1),JS=1,5),JT=1,5) /
     &4.0629E-08,5.4875E-08,5.3346E-08,4.4940E-08,9.9095E-09,
     &3.9810E-08,6.2753E-08,6.2779E-08,5.3045E-08,1.4355E-08,
     &4.1749E-08,7.5935E-08,7.6945E-08,6.5932E-08,1.8547E-08,
     &4.7734E-08,9.6672E-08,9.8927E-08,8.5559E-08,2.3788E-08,
     &5.9002E-08,1.2763E-07,1.3186E-07,1.1423E-07,2.9932E-08/
      DATA ((KB(JS,JT,53, 1),JS=1,5),JT=1,5) /
     &3.5975E-08,4.5399E-08,4.2771E-08,3.6200E-08,6.7635E-09,
     &3.4672E-08,5.0776E-08,4.9763E-08,4.1778E-08,1.0001E-08,
     &3.5325E-08,6.0020E-08,6.0156E-08,5.0998E-08,1.3726E-08,
     &3.9133E-08,7.5038E-08,7.6143E-08,6.5063E-08,1.7480E-08,
     &4.7140E-08,9.7792E-08,1.0026E-07,8.6276E-08,2.2211E-08/
      DATA ((KB(JS,JT,54, 1),JS=1,5),JT=1,5) /
     &3.2026E-08,3.8173E-08,3.4913E-08,2.9554E-08,4.7895E-09,
     &3.0459E-08,4.1712E-08,4.0172E-08,3.3417E-08,7.2202E-09,
     &3.0344E-08,4.8248E-08,4.7728E-08,3.9999E-08,1.0387E-08,
     &3.2650E-08,5.9169E-08,5.9453E-08,5.0241E-08,1.3202E-08,
     &3.8298E-08,7.6040E-08,7.7304E-08,6.5975E-08,1.6815E-08/
      DATA ((KB(JS,JT,55, 1),JS=1,5),JT=1,5) /
     &2.8677E-08,3.2441E-08,2.8748E-08,2.4151E-08,3.5459E-09,
     &2.6981E-08,3.4720E-08,3.2391E-08,2.6974E-08,5.3560E-09,
     &2.6409E-08,3.9355E-08,3.8167E-08,3.1739E-08,7.7448E-09,
     &2.7649E-08,4.7215E-08,4.6970E-08,3.9144E-08,1.0056E-08,
     &3.1553E-08,5.9776E-08,6.0219E-08,5.0851E-08,1.2897E-08/
      DATA ((KB(JS,JT,56, 1),JS=1,5),JT=1,5) /
     &2.5871E-08,2.7896E-08,2.4025E-08,1.9941E-08,2.5789E-09,
     &2.4111E-08,2.9230E-08,2.6562E-08,2.2012E-08,3.9211E-09,
     &2.3260E-08,3.2443E-08,3.0891E-08,2.5392E-08,5.7991E-09,
     &2.3744E-08,3.8105E-08,3.7441E-08,3.0750E-08,7.7370E-09,
     &2.6357E-08,4.7419E-08,4.7264E-08,3.9435E-08,9.8948E-09/
      DATA ((KB(JS,JT,57, 1),JS=1,5),JT=1,5) /
     &2.3535E-08,2.4259E-08,2.0309E-08,1.6435E-08,1.8424E-09,
     &2.1750E-08,2.4981E-08,2.1975E-08,1.7965E-08,2.8485E-09,
     &2.0716E-08,2.7095E-08,2.5073E-08,2.0518E-08,4.3296E-09,
     &2.0688E-08,3.1150E-08,2.9998E-08,2.4389E-08,6.0949E-09,
     &2.2336E-08,3.7957E-08,3.7415E-08,3.0783E-08,7.5649E-09/
      DATA ((KB(JS,JT,58, 1),JS=1,5),JT=1,5) /
     &1.0425E-08,1.1830E-08,1.1340E-08,1.0982E-08,1.3443E-09,
     &9.5648E-09,1.2002E-08,1.2045E-08,1.1710E-08,2.0849E-09,
     &9.0146E-09,1.2747E-08,1.3512E-08,1.3201E-08,3.2654E-09,
     &8.8493E-09,1.4369E-08,1.5929E-08,1.5466E-08,4.7356E-09,
     &9.3086E-09,1.7138E-08,1.9573E-08,1.9214E-08,5.8278E-09/
      DATA ((KB(JS,JT,59, 1),JS=1,5),JT=1,5) /
     &9.0380E-09,1.0080E-08,9.6059E-09,9.1584E-09,1.1081E-09,
     &8.2691E-09,1.0165E-08,1.0115E-08,9.7014E-09,1.7533E-09,
     &7.7641E-09,1.0688E-08,1.1200E-08,1.0889E-08,2.7394E-09,
     &7.5756E-09,1.1927E-08,1.3083E-08,1.2667E-08,3.9313E-09,
     &7.8886E-09,1.4088E-08,1.5992E-08,1.5688E-08,4.8202E-09/
      DATA ((KB(JS,JT,13, 2),JS=1,5),JT=1,5) /
     &2.3347E-04,3.2740E-04,3.1964E-04,2.7562E-04,2.3674E-04,
     &2.9027E-04,4.3170E-04,4.3482E-04,3.8943E-04,3.2365E-04,
     &3.9534E-04,6.0684E-04,6.1602E-04,5.5281E-04,4.2550E-04,
     &5.7501E-04,8.8229E-04,8.9214E-04,7.8504E-04,5.3481E-04,
     &8.7274E-04,1.2992E-03,1.2957E-03,1.1072E-03,6.5845E-04/
      DATA ((KB(JS,JT,14, 2),JS=1,5),JT=1,5) /
     &2.0019E-04,2.7999E-04,2.7248E-04,2.3561E-04,2.0892E-04,
     &2.5252E-04,3.7448E-04,3.7546E-04,3.3478E-04,2.8574E-04,
     &3.4599E-04,5.3246E-04,5.3788E-04,4.7751E-04,3.6978E-04,
     &5.0873E-04,7.7992E-04,7.8607E-04,6.8145E-04,4.6369E-04,
     &7.7937E-04,1.1544E-03,1.1464E-03,9.6300E-04,5.7084E-04/
      DATA ((KB(JS,JT,15, 2),JS=1,5),JT=1,5) /
     &1.6496E-04,2.3313E-04,2.2745E-04,1.9815E-04,1.7191E-04,
     &2.0995E-04,3.1642E-04,3.1725E-04,2.8352E-04,2.3300E-04,
     &2.9058E-04,4.5406E-04,4.6090E-04,4.0582E-04,3.0079E-04,
     &4.3180E-04,6.6786E-04,6.7439E-04,5.7938E-04,3.7802E-04,
     &6.6674E-04,9.9697E-04,9.8451E-04,8.2076E-04,4.7099E-04/
      DATA ((KB(JS,JT,16, 2),JS=1,5),JT=1,5) /
     &1.3273E-04,1.9160E-04,1.8863E-04,1.6534E-04,1.4034E-04,
     &1.7022E-04,2.6274E-04,2.6590E-04,2.3774E-04,1.8655E-04,
     &2.3798E-04,3.7894E-04,3.8748E-04,3.4032E-04,2.3998E-04,
     &3.5812E-04,5.6381E-04,5.6807E-04,4.8599E-04,3.0617E-04,
     &5.5540E-04,8.4478E-04,8.3109E-04,6.8770E-04,3.7973E-04/
      DATA ((KB(JS,JT,17, 2),JS=1,5),JT=1,5) /
     &1.0577E-04,1.5680E-04,1.5536E-04,1.3786E-04,1.1416E-04,
     &1.3659E-04,2.1658E-04,2.2147E-04,1.9766E-04,1.5136E-04,
     &1.9353E-04,3.1591E-04,3.2447E-04,2.8337E-04,1.9661E-04,
     &2.9393E-04,4.7241E-04,4.7609E-04,4.0460E-04,2.4887E-04,
     &4.5598E-04,7.0740E-04,6.9589E-04,5.7452E-04,3.0304E-04/
      DATA ((KB(JS,JT,18, 2),JS=1,5),JT=1,5) /
     &8.2750E-05,1.2686E-04,1.2742E-04,1.1403E-04,9.3961E-05,
     &1.0793E-04,1.7707E-04,1.8353E-04,1.6336E-04,1.2524E-04,
     &1.5481E-04,2.6078E-04,2.6950E-04,2.3444E-04,1.6211E-04,
     &2.3641E-04,3.9024E-04,3.9536E-04,3.3586E-04,2.0255E-04,
     &3.6699E-04,5.8299E-04,5.7531E-04,4.7694E-04,2.4459E-04/
      DATA ((KB(JS,JT,19, 2),JS=1,5),JT=1,5) /
     &6.5789E-05,1.0377E-04,1.0573E-04,9.4747E-05,7.8309E-05,
     &8.6739E-05,1.4667E-04,1.5321E-04,1.3630E-04,1.0400E-04,
     &1.2570E-04,2.1696E-04,2.2493E-04,1.9585E-04,1.3355E-04,
     &1.9254E-04,3.2492E-04,3.2972E-04,2.8110E-04,1.6478E-04,
     &2.9952E-04,4.8402E-04,4.8010E-04,3.9892E-04,1.9831E-04/
      DATA ((KB(JS,JT,20, 2),JS=1,5),JT=1,5) /
     &5.3588E-05,8.6632E-05,8.9247E-05,8.0067E-05,6.5775E-05,
     &7.1606E-05,1.2377E-04,1.3011E-04,1.1561E-04,8.7374E-05,
     &1.0490E-04,1.8400E-04,1.9125E-04,1.6630E-04,1.1025E-04,
     &1.6107E-04,2.7570E-04,2.7972E-04,2.3864E-04,1.3590E-04,
     &2.5044E-04,4.0870E-04,4.0643E-04,3.3832E-04,1.6243E-04/
      DATA ((KB(JS,JT,21, 2),JS=1,5),JT=1,5) /
     &4.3995E-05,7.2776E-05,7.5695E-05,6.8050E-05,5.5495E-05,
     &5.9611E-05,1.0482E-04,1.1056E-04,9.8202E-05,7.3158E-05,
     &8.7989E-05,1.5634E-04,1.6268E-04,1.4172E-04,9.0987E-05,
     &1.3548E-04,2.3394E-04,2.3798E-04,2.0295E-04,1.1189E-04,
     &2.1032E-04,3.4525E-04,3.4399E-04,2.8683E-04,1.3326E-04/
      DATA ((KB(JS,JT,22, 2),JS=1,5),JT=1,5) /
     &3.6803E-05,6.2518E-05,6.5746E-05,5.8989E-05,4.7547E-05,
     &5.0761E-05,9.1003E-05,9.6193E-05,8.5393E-05,6.0785E-05,
     &7.5680E-05,1.3601E-04,1.4124E-04,1.2316E-04,7.5929E-05,
     &1.1711E-04,2.0303E-04,2.0625E-04,1.7599E-04,9.2008E-05,
     &1.8108E-04,2.9768E-04,2.9683E-04,2.4768E-04,1.0998E-04/
      DATA ((KB(JS,JT,23, 2),JS=1,5),JT=1,5) /
     &3.1003E-05,5.3823E-05,5.7061E-05,5.1271E-05,4.0280E-05,
     &4.3496E-05,7.9103E-05,8.3635E-05,7.4369E-05,5.0624E-05,
     &6.5401E-05,1.1830E-04,1.2269E-04,1.0707E-04,6.2127E-05,
     &1.0147E-04,1.7576E-04,1.7852E-04,1.5248E-04,7.5578E-05,
     &1.5625E-04,2.5690E-04,2.5634E-04,2.1357E-04,9.0733E-05/
      DATA ((KB(JS,JT,24, 2),JS=1,5),JT=1,5) /
     &2.6471E-05,4.6863E-05,4.9818E-05,4.4807E-05,3.2886E-05,
     &3.7731E-05,6.9280E-05,7.2915E-05,6.4892E-05,4.1198E-05,
     &5.7248E-05,1.0347E-04,1.0698E-04,9.3403E-05,5.0808E-05,
     &8.8791E-05,1.5319E-04,1.5530E-04,1.3247E-04,6.1812E-05,
     &1.3624E-04,2.2303E-04,2.2220E-04,1.8474E-04,7.4324E-05/
      DATA ((KB(JS,JT,25, 2),JS=1,5),JT=1,5) /
     &2.2808E-05,4.1048E-05,4.3589E-05,3.9316E-05,2.6891E-05,
     &3.2985E-05,6.0936E-05,6.3907E-05,5.6898E-05,3.3888E-05,
     &5.0481E-05,9.0713E-05,9.3687E-05,8.1693E-05,4.1615E-05,
     &7.8151E-05,1.3406E-04,1.3563E-04,1.1547E-04,5.0834E-05,
     &1.1946E-04,1.9452E-04,1.9337E-04,1.6037E-04,6.0346E-05/
      DATA ((KB(JS,JT,26, 2),JS=1,5),JT=1,5) /
     &1.9934E-05,3.6349E-05,3.8562E-05,3.4809E-05,2.2369E-05,
     &2.9291E-05,5.4051E-05,5.6667E-05,5.0301E-05,2.7895E-05,
     &4.5044E-05,8.0419E-05,8.2812E-05,7.2007E-05,3.4611E-05,
     &6.9643E-05,1.1855E-04,1.1958E-04,1.0144E-04,4.1836E-05,
     &1.0589E-04,1.7128E-04,1.6969E-04,1.4033E-04,4.9219E-05/
      DATA ((KB(JS,JT,27, 2),JS=1,5),JT=1,5) /
     &1.7559E-05,3.2313E-05,3.4216E-05,3.0835E-05,1.8255E-05,
     &2.6182E-05,4.8079E-05,5.0267E-05,4.4498E-05,2.3042E-05,
     &4.0350E-05,7.1540E-05,7.3359E-05,6.3538E-05,2.8359E-05,
     &6.2227E-05,1.0500E-04,1.0550E-04,8.9231E-05,3.3804E-05,
     &9.4129E-05,1.5114E-04,1.4903E-04,1.2285E-04,4.0082E-05/
      DATA ((KB(JS,JT,28, 2),JS=1,5),JT=1,5) /
     &1.5570E-05,2.8729E-05,3.0391E-05,2.7331E-05,1.4928E-05,
     &2.3454E-05,4.2868E-05,4.4647E-05,3.9416E-05,1.8685E-05,
     &3.6218E-05,6.3627E-05,6.4995E-05,5.6106E-05,2.2770E-05,
     &5.5686E-05,9.3113E-05,9.3100E-05,7.8497E-05,2.7363E-05,
     &8.3686E-05,1.3339E-04,1.3104E-04,1.0755E-04,3.2541E-05/
      DATA ((KB(JS,JT,29, 2),JS=1,5),JT=1,5) /
     &1.3843E-05,2.5623E-05,2.7065E-05,2.4295E-05,1.2134E-05,
     &2.1009E-05,3.8248E-05,3.9732E-05,3.4977E-05,1.5044E-05,
     &3.2483E-05,5.6676E-05,5.7569E-05,4.9592E-05,1.8408E-05,
     &4.9712E-05,8.2574E-05,8.2234E-05,6.9025E-05,2.2259E-05,
     &7.4303E-05,1.1753E-04,1.1526E-04,9.4159E-05,2.6343E-05/
      DATA ((KB(JS,JT,30, 2),JS=1,5),JT=1,5) /
     &1.2283E-05,2.2826E-05,2.4077E-05,2.1586E-05,9.7017E-06,
     &1.8796E-05,3.4070E-05,3.5216E-05,3.0990E-05,1.2060E-05,
     &2.9052E-05,5.0361E-05,5.0950E-05,4.3716E-05,1.4847E-05,
     &4.4245E-05,7.2929E-05,7.2487E-05,6.0571E-05,1.7868E-05,
     &6.5686E-05,1.0336E-04,1.0108E-04,8.2235E-05,2.0877E-05/
      DATA ((KB(JS,JT,31, 2),JS=1,5),JT=1,5) /
     &1.0864E-05,2.0303E-05,2.1341E-05,1.9138E-05,7.8312E-06,
     &1.6718E-05,3.0263E-05,3.1180E-05,2.7363E-05,9.6909E-06,
     &2.5784E-05,4.4485E-05,4.4959E-05,3.8436E-05,1.1703E-05,
     &3.9035E-05,6.4113E-05,6.3593E-05,5.2930E-05,1.4083E-05,
     &5.7600E-05,9.0427E-05,8.8190E-05,7.1491E-05,1.6696E-05/
      DATA ((KB(JS,JT,32, 2),JS=1,5),JT=1,5) /
     &9.6861E-06,1.8129E-05,1.9009E-05,1.7005E-05,6.3389E-06,
     &1.4957E-05,2.6929E-05,2.7692E-05,2.4209E-05,7.7689E-06,
     &2.2989E-05,3.9434E-05,3.9744E-05,3.3837E-05,9.3738E-06,
     &3.4606E-05,5.6545E-05,5.5926E-05,4.6356E-05,1.1253E-05,
     &5.0712E-05,7.9301E-05,7.7059E-05,6.2285E-05,1.3276E-05/
      DATA ((KB(JS,JT,33, 2),JS=1,5),JT=1,5) /
     &8.6881E-06,1.6215E-05,1.6965E-05,1.5122E-05,5.0839E-06,
     &1.3426E-05,2.4037E-05,2.4628E-05,2.1434E-05,6.2318E-06,
     &2.0550E-05,3.5027E-05,3.5160E-05,2.9820E-05,7.5123E-06,
     &3.0762E-05,4.9971E-05,4.9236E-05,4.0640E-05,8.9286E-06,
     &4.4719E-05,6.9592E-05,6.7432E-05,5.4322E-05,1.0569E-05/
      DATA ((KB(JS,JT,34, 2),JS=1,5),JT=1,5) /
     &7.7791E-06,1.4442E-05,1.5046E-05,1.3360E-05,4.1600E-06,
     &1.2019E-05,2.1346E-05,2.1771E-05,1.8857E-05,5.0353E-06,
     &1.8324E-05,3.0972E-05,3.0949E-05,2.6117E-05,6.0447E-06,
     &2.7261E-05,4.3932E-05,4.3157E-05,3.5442E-05,7.1905E-06,
     &3.9385E-05,6.0888E-05,5.8795E-05,4.7179E-05,8.5133E-06/
      DATA ((KB(JS,JT,35, 2),JS=1,5),JT=1,5) /
     &6.6949E-06,1.2390E-05,1.2873E-05,1.1410E-05,3.2837E-06,
     &1.0342E-05,1.8289E-05,1.8599E-05,1.6068E-05,4.0072E-06,
     &1.5729E-05,2.6447E-05,2.6382E-05,2.2198E-05,4.8111E-06,
     &2.3326E-05,3.7424E-05,3.6694E-05,3.0052E-05,5.7503E-06,
     &3.3582E-05,5.1735E-05,4.9852E-05,3.9921E-05,6.8317E-06/
      DATA ((KB(JS,JT,36, 2),JS=1,5),JT=1,5) /
     &5.5116E-06,1.0195E-05,1.0585E-05,9.3814E-06,2.5556E-06,
     &8.5137E-06,1.5037E-05,1.5296E-05,1.3209E-05,3.1325E-06,
     &1.2948E-05,2.1753E-05,2.1694E-05,1.8250E-05,3.7680E-06,
     &1.9198E-05,3.0787E-05,3.0171E-05,2.4706E-05,4.5193E-06,
     &2.7624E-05,4.2550E-05,4.0975E-05,3.2811E-05,5.3463E-06/
      DATA ((KB(JS,JT,37, 2),JS=1,5),JT=1,5) /
     &4.2943E-06,7.9625E-06,8.2825E-06,7.3555E-06,1.9862E-06,
     &6.6379E-06,1.1772E-05,1.1998E-05,1.0386E-05,2.4388E-06,
     &1.0124E-05,1.7087E-05,1.7068E-05,1.4395E-05,2.9448E-06,
     &1.5070E-05,2.4266E-05,2.3812E-05,1.9543E-05,3.5287E-06,
     &2.1767E-05,3.3653E-05,3.2450E-05,2.6024E-05,4.1879E-06/
      DATA ((KB(JS,JT,38, 2),JS=1,5),JT=1,5) /
     &3.3357E-06,6.1963E-06,6.4603E-06,5.7499E-06,1.5402E-06,
     &5.1578E-06,9.1863E-06,9.3819E-06,8.1434E-06,1.8945E-06,
     &7.8901E-06,1.3380E-05,1.3389E-05,1.1321E-05,2.2920E-06,
     &1.1791E-05,1.9066E-05,1.8739E-05,1.5418E-05,2.7521E-06,
     &1.7101E-05,2.6537E-05,2.5629E-05,2.0591E-05,3.2788E-06/
      DATA ((KB(JS,JT,39, 2),JS=1,5),JT=1,5) /
     &2.5925E-06,4.8221E-06,5.0377E-06,4.4928E-06,1.1896E-06,
     &4.0080E-06,7.1657E-06,7.3339E-06,6.3822E-06,1.4636E-06,
     &6.1480E-06,1.0471E-05,1.0498E-05,8.8998E-06,1.7757E-06,
     &9.2224E-06,1.4975E-05,1.4740E-05,1.2159E-05,2.1407E-06,
     &1.3430E-05,2.0919E-05,2.0232E-05,1.6286E-05,2.5517E-06/
      DATA ((KB(JS,JT,40, 2),JS=1,5),JT=1,5) /
     &1.9503E-06,3.6256E-06,3.7983E-06,3.3983E-06,9.0970E-07,
     &3.0096E-06,5.4072E-06,5.5509E-06,4.8509E-06,1.1295E-06,
     &4.6341E-06,7.9436E-06,7.9881E-06,6.7974E-06,1.3749E-06,
     &6.9959E-06,1.1429E-05,1.1278E-05,9.3390E-06,1.6560E-06,
     &1.0262E-05,1.6061E-05,1.5575E-05,1.2573E-05,1.9765E-06/
      DATA ((KB(JS,JT,41, 2),JS=1,5),JT=1,5) /
     &1.4645E-06,2.7131E-06,2.8491E-06,2.5571E-06,6.9451E-07,
     &2.2502E-06,4.0586E-06,4.1799E-06,3.6674E-06,8.6660E-07,
     &3.4750E-06,5.9931E-06,6.0465E-06,5.1654E-06,1.0602E-06,
     &5.2792E-06,8.6774E-06,8.5850E-06,7.1396E-06,1.2820E-06,
     &7.8024E-06,1.2273E-05,1.1934E-05,9.6653E-06,1.5281E-06/
      DATA ((KB(JS,JT,42, 2),JS=1,5),JT=1,5) /
     &1.1030E-06,2.0298E-06,2.1354E-06,1.9220E-06,5.2769E-07,
     &1.6830E-06,3.0429E-06,3.1437E-06,2.7680E-06,6.5992E-07,
     &2.6031E-06,4.5149E-06,4.5688E-06,3.9192E-06,8.1465E-07,
     &3.9772E-06,6.5768E-06,6.5252E-06,5.4495E-06,9.8750E-07,
     &5.9212E-06,9.3604E-06,9.1253E-06,7.4182E-06,1.1776E-06/
      DATA ((KB(JS,JT,43, 2),JS=1,5),JT=1,5) /
     &8.2428E-07,1.4953E-06,1.5737E-06,1.4196E-06,3.9479E-07,
     &1.2422E-06,2.2430E-06,2.3243E-06,2.0532E-06,4.9846E-07,
     &1.9204E-06,3.3444E-06,3.3959E-06,2.9263E-06,6.1792E-07,
     &2.9515E-06,4.9083E-06,4.8847E-06,4.0977E-06,7.5196E-07,
     &4.4328E-06,7.0409E-06,6.8831E-06,5.6178E-06,9.0060E-07/
      DATA ((KB(JS,JT,44, 2),JS=1,5),JT=1,5) /
     &6.1791E-07,1.0964E-06,1.1526E-06,1.0396E-06,2.9276E-07,
     &9.1458E-07,1.6410E-06,1.7044E-06,1.5103E-06,3.7305E-07,
     &1.4081E-06,2.4567E-06,2.5035E-06,2.1667E-06,4.6414E-07,
     &2.1742E-06,3.6323E-06,3.6267E-06,3.0560E-06,5.6825E-07,
     &3.2939E-06,5.2553E-06,5.1516E-06,4.2228E-06,6.8470E-07/
      DATA ((KB(JS,JT,45, 2),JS=1,5),JT=1,5) /
     &4.6818E-07,8.0720E-07,8.4515E-07,7.6099E-07,2.1643E-07,
     &6.7728E-07,1.2013E-06,1.2493E-06,1.1096E-06,2.7840E-07,
     &1.0340E-06,1.8032E-06,1.8431E-06,1.6011E-06,3.4809E-07,
     &1.6004E-06,2.6834E-06,2.6875E-06,2.2740E-06,4.2767E-07,
     &2.4431E-06,3.9144E-06,3.8469E-06,3.1675E-06,5.1847E-07/
      DATA ((KB(JS,JT,46, 2),JS=1,5),JT=1,5) /
     &3.5715E-07,5.9421E-07,6.1734E-07,5.5305E-07,1.5800E-07,
     &5.0187E-07,8.7381E-07,9.0848E-07,8.0843E-07,2.0563E-07,
     &7.5515E-07,1.3118E-06,1.3445E-06,1.1721E-06,2.5967E-07,
     &1.1677E-06,1.9633E-06,1.9726E-06,1.6766E-06,3.2108E-07,
     &1.7950E-06,2.8885E-06,2.8468E-06,2.3553E-06,3.9011E-07/
      DATA ((KB(JS,JT,47, 2),JS=1,5),JT=1,5) /
     &2.7398E-07,4.3581E-07,4.4704E-07,3.9668E-07,1.1323E-07,
     &3.7103E-07,6.2850E-07,6.5163E-07,5.8000E-07,1.4990E-07,
     &5.4577E-07,9.3956E-07,9.6531E-07,8.4415E-07,1.9262E-07,
     &8.3895E-07,1.4116E-06,1.4241E-06,1.2169E-06,2.3951E-07,
     &1.2964E-06,2.0956E-06,2.0729E-06,1.7247E-06,2.9208E-07/
      DATA ((KB(JS,JT,48, 2),JS=1,5),JT=1,5) /
     &2.1387E-07,3.2471E-07,3.2631E-07,2.8559E-07,7.9995E-08,
     &2.7873E-07,4.5569E-07,4.6902E-07,4.1584E-07,1.0856E-07,
     &3.9810E-07,6.7425E-07,6.9287E-07,6.0740E-07,1.4073E-07,
     &6.0448E-07,1.0143E-06,1.0265E-06,8.8097E-07,1.7712E-07,
     &9.3542E-07,1.5166E-06,1.5052E-06,1.2587E-06,2.1758E-07/
      DATA ((KB(JS,JT,49, 2),JS=1,5),JT=1,5) /
     &1.6983E-07,2.4624E-07,2.4047E-07,2.0742E-07,5.5874E-08,
     &2.1316E-07,3.3392E-07,3.3939E-07,2.9852E-07,7.7373E-08,
     &2.9400E-07,4.8579E-07,4.9802E-07,4.3681E-07,1.0173E-07,
     &4.3777E-07,7.2867E-07,7.3912E-07,6.3632E-07,1.2966E-07,
     &6.7522E-07,1.0953E-06,1.0905E-06,9.1600E-07,1.6042E-07/
      DATA ((KB(JS,JT,50, 2),JS=1,5),JT=1,5) /
     &1.3748E-07,1.9105E-07,1.8074E-07,1.5294E-07,4.0734E-08,
     &1.6685E-07,2.5027E-07,2.4971E-07,2.1712E-07,5.5541E-08,
     &2.2205E-07,3.5580E-07,3.6241E-07,3.1709E-07,7.4088E-08,
     &3.2265E-07,5.2953E-07,5.3723E-07,4.6323E-07,9.5830E-08,
     &4.9355E-07,7.9777E-07,7.9617E-07,6.7111E-07,1.2000E-07/
      DATA ((KB(JS,JT,51, 2),JS=1,5),JT=1,5) /
     &1.1310E-07,1.5095E-07,1.3873E-07,1.1416E-07,2.8930E-08,
     &1.3297E-07,1.9104E-07,1.8603E-07,1.5944E-07,3.9649E-08,
     &1.7089E-07,2.6387E-07,2.6609E-07,2.3142E-07,5.4118E-08,
     &2.4121E-07,3.8782E-07,3.9262E-07,3.3860E-07,7.0920E-08,
     &3.6391E-07,5.8370E-07,5.8331E-07,4.9304E-07,8.9643E-08/
      DATA ((KB(JS,JT,52, 2),JS=1,5),JT=1,5) /
     &9.4432E-08,1.2100E-07,1.0830E-07,8.6173E-08,2.0454E-08,
     &1.0754E-07,1.4816E-07,1.4031E-07,1.1784E-07,2.8884E-08,
     &1.3365E-07,1.9803E-07,1.9664E-07,1.6925E-07,3.9314E-08,
     &1.8256E-07,2.8565E-07,2.8767E-07,2.4757E-07,5.1552E-08,
     &2.7006E-07,4.2782E-07,4.2750E-07,3.6187E-07,6.6239E-08/
      DATA ((KB(JS,JT,53, 2),JS=1,5),JT=1,5) /
     &7.9939E-08,9.8272E-08,8.6307E-08,6.6012E-08,1.4604E-08,
     &8.8279E-08,1.1673E-07,1.0758E-07,8.7937E-08,2.0451E-08,
     &1.0623E-07,1.5078E-07,1.4654E-07,1.2425E-07,2.8208E-08,
     &1.4011E-07,2.1203E-07,2.1153E-07,1.8129E-07,3.7255E-08,
     &2.0211E-07,3.1443E-07,3.1357E-07,2.6539E-07,4.8314E-08/
      DATA ((KB(JS,JT,54, 2),JS=1,5),JT=1,5) /
     &6.8612E-08,8.0858E-08,7.0080E-08,5.1088E-08,1.0952E-08,
     &7.3786E-08,9.3902E-08,8.4431E-08,6.7059E-08,1.4950E-08,
     &8.6236E-08,1.1751E-07,1.1148E-07,9.2909E-08,2.0689E-08,
     &1.1017E-07,1.6065E-07,1.5823E-07,1.3458E-07,2.7837E-08,
     &1.5462E-07,2.3495E-07,2.3325E-07,1.9698E-07,3.6383E-08/
      DATA ((KB(JS,JT,55, 2),JS=1,5),JT=1,5) /
     &5.9732E-08,6.7403E-08,5.7777E-08,3.9915E-08,8.5037E-09,
     &6.2576E-08,7.6690E-08,6.7863E-08,5.1930E-08,1.1059E-08,
     &7.1126E-08,9.3200E-08,8.6382E-08,7.0395E-08,1.5573E-08,
     &8.8230E-08,1.2378E-07,1.1984E-07,1.0085E-07,2.1225E-08,
     &1.2026E-07,1.7765E-07,1.7500E-07,1.4721E-07,2.7783E-08/
      DATA ((KB(JS,JT,56, 2),JS=1,5),JT=1,5) /
     &5.2687E-08,5.6857E-08,4.7895E-08,3.2001E-08,6.6275E-09,
     &5.3766E-08,6.3415E-08,5.5171E-08,4.0341E-08,8.2176E-09,
     &5.9487E-08,7.5070E-08,6.7900E-08,5.3874E-08,1.1605E-08,
     &7.1736E-08,9.6663E-08,9.1606E-08,7.5983E-08,1.6105E-08,
     &9.4811E-08,1.3547E-07,1.3204E-07,1.1036E-07,2.1203E-08/
      DATA ((KB(JS,JT,57, 2),JS=1,5),JT=1,5) /
     &4.7030E-08,4.8568E-08,3.9988E-08,2.6219E-08,4.9408E-09,
     &4.6811E-08,5.3015E-08,4.5546E-08,3.1769E-08,6.1353E-09,
     &5.0494E-08,6.1370E-08,5.4487E-08,4.1710E-08,8.6536E-09,
     &5.9216E-08,7.6592E-08,7.0994E-08,5.7693E-08,1.1916E-08,
     &7.5908E-08,1.0451E-07,1.0035E-07,8.3097E-08,1.6230E-08/
      DATA ((KB(JS,JT,58, 2),JS=1,5),JT=1,5) /
     &2.0524E-08,2.3377E-08,2.2103E-08,1.7291E-08,3.6303E-09,
     &2.0023E-08,2.5008E-08,2.4831E-08,2.0273E-08,4.7070E-09,
     &2.1076E-08,2.8356E-08,2.8987E-08,2.5840E-08,6.5048E-09,
     &2.4072E-08,3.4377E-08,3.6577E-08,3.5144E-08,8.9689E-09,
     &3.0004E-08,4.5626E-08,5.0474E-08,4.9976E-08,1.2428E-08/
      DATA ((KB(JS,JT,59, 2),JS=1,5),JT=1,5) /
     &1.7700E-08,1.9843E-08,1.8643E-08,1.4520E-08,2.9679E-09,
     &1.7149E-08,2.1008E-08,2.0747E-08,1.6830E-08,3.9081E-09,
     &1.7873E-08,2.3612E-08,2.4046E-08,2.1098E-08,5.4593E-09,
     &2.0201E-08,2.8287E-08,2.9905E-08,2.8473E-08,7.4791E-09,
     &2.4905E-08,3.7065E-08,4.0703E-08,4.0125E-08,1.0391E-08/
      DATA ((KB(JS,JT,13, 3),JS=1,5),JT=1,5) /
     &7.5570E-04,1.0772E-03,1.0524E-03,8.5610E-04,5.7960E-04,
     &1.1289E-03,1.5736E-03,1.5191E-03,1.2213E-03,7.5295E-04,
     &1.7896E-03,2.3714E-03,2.2650E-03,1.7547E-03,9.2113E-04,
     &2.8881E-03,3.6381E-03,3.3414E-03,2.5211E-03,1.0886E-03,
     &4.6526E-03,5.5012E-03,4.9005E-03,3.6099E-03,1.2715E-03/
      DATA ((KB(JS,JT,14, 3),JS=1,5),JT=1,5) /
     &6.5628E-04,9.2369E-04,9.0249E-04,7.3144E-04,5.2166E-04,
     &1.0001E-03,1.3681E-03,1.3197E-03,1.0469E-03,6.6148E-04,
     &1.6037E-03,2.0859E-03,1.9738E-03,1.5151E-03,7.9350E-04,
     &2.6225E-03,3.2284E-03,2.9281E-03,2.1941E-03,9.2716E-04,
     &4.2437E-03,4.9002E-03,4.3187E-03,3.1691E-03,1.0609E-03/
      DATA ((KB(JS,JT,15, 3),JS=1,5),JT=1,5) /
     &5.5021E-04,7.7058E-04,7.4997E-04,6.0721E-04,4.5513E-04,
     &8.5046E-04,1.1533E-03,1.1173E-03,8.7626E-04,5.6093E-04,
     &1.3828E-03,1.7898E-03,1.6630E-03,1.2772E-03,6.6129E-04,
     &2.2885E-03,2.7671E-03,2.4977E-03,1.8674E-03,7.6057E-04,
     &3.7000E-03,4.2354E-03,3.7118E-03,2.7146E-03,8.7024E-04/
      DATA ((KB(JS,JT,16, 3),JS=1,5),JT=1,5) /
     &4.5181E-04,6.3192E-04,6.1748E-04,4.9522E-04,3.6566E-04,
     &7.0837E-04,9.6443E-04,9.2028E-04,7.2449E-04,4.4224E-04,
     &1.1719E-03,1.5071E-03,1.3916E-03,1.0704E-03,5.1878E-04,
     &1.9347E-03,2.3410E-03,2.1054E-03,1.5750E-03,5.9381E-04,
     &3.1267E-03,3.5933E-03,3.1446E-03,2.3012E-03,6.8790E-04/
      DATA ((KB(JS,JT,17, 3),JS=1,5),JT=1,5) /
     &3.7149E-04,5.2008E-04,5.0762E-04,4.0757E-04,2.8847E-04,
     &5.8832E-04,8.0612E-04,7.6169E-04,6.0348E-04,3.4723E-04,
     &9.7995E-04,1.2582E-03,1.1654E-03,8.9803E-04,4.0483E-04,
     &1.6147E-03,1.9685E-03,1.7733E-03,1.3298E-03,4.7136E-04,
     &2.6071E-03,3.0247E-03,2.6450E-03,1.9458E-03,5.5921E-04/
      DATA ((KB(JS,JT,18, 3),JS=1,5),JT=1,5) /
     &3.0061E-04,4.2884E-04,4.1648E-04,3.3754E-04,2.3127E-04,
     &4.8246E-04,6.6793E-04,6.3270E-04,5.0432E-04,2.7279E-04,
     &8.0392E-04,1.0486E-03,9.7147E-04,7.5301E-04,3.2007E-04,
     &1.3260E-03,1.6386E-03,1.4792E-03,1.1164E-03,3.8144E-04,
     &2.1473E-03,2.5126E-03,2.2067E-03,1.6276E-03,4.4653E-04/
      DATA ((KB(JS,JT,19, 3),JS=1,5),JT=1,5) /
     &2.4724E-04,3.5910E-04,3.4734E-04,2.8349E-04,1.8511E-04,
     &4.0125E-04,5.6017E-04,5.3189E-04,4.2493E-04,2.2055E-04,
     &6.6924E-04,8.8342E-04,8.2067E-04,6.3860E-04,2.6260E-04,
     &1.1061E-03,1.3792E-03,1.2462E-03,9.4376E-04,3.1226E-04,
     &1.7964E-03,2.1126E-03,1.8583E-03,1.3721E-03,3.6746E-04/
      DATA ((KB(JS,JT,20, 3),JS=1,5),JT=1,5) /
     &2.0934E-04,3.0700E-04,2.9722E-04,2.4267E-04,1.4926E-04,
     &3.4260E-04,4.8187E-04,4.5763E-04,3.6566E-04,1.7991E-04,
     &5.7163E-04,7.5991E-04,7.0644E-04,5.4990E-04,2.1557E-04,
     &9.4873E-04,1.1845E-03,1.0719E-03,8.1150E-04,2.5564E-04,
     &1.5383E-03,1.8175E-03,1.5965E-03,1.1755E-03,3.0407E-04/
      DATA ((KB(JS,JT,21, 3),JS=1,5),JT=1,5) /
     &1.7843E-04,2.6350E-04,2.5564E-04,2.0870E-04,1.2133E-04,
     &2.9332E-04,4.1557E-04,3.9544E-04,3.1597E-04,1.4677E-04,
     &4.9132E-04,6.5537E-04,6.0874E-04,4.7437E-04,1.7728E-04,
     &8.1854E-04,1.0220E-03,9.2374E-04,6.9881E-04,2.1085E-04,
     &1.3233E-03,1.5674E-03,1.3737E-03,1.0105E-03,2.5000E-04/
      DATA ((KB(JS,JT,22, 3),JS=1,5),JT=1,5) /
     &1.5600E-04,2.3165E-04,2.2455E-04,1.8380E-04,9.8965E-05,
     &2.5879E-04,3.6647E-04,3.4891E-04,2.7934E-04,1.2038E-04,
     &4.3583E-04,5.7888E-04,5.3753E-04,4.1782E-04,1.4492E-04,
     &7.2393E-04,9.0328E-04,8.1451E-04,6.1366E-04,1.7404E-04,
     &1.1641E-03,1.3807E-03,1.2062E-03,8.8532E-04,2.0548E-04/
      DATA ((KB(JS,JT,23, 3),JS=1,5),JT=1,5) /
     &1.3677E-04,2.0433E-04,1.9788E-04,1.6232E-04,8.0071E-05,
     &2.2851E-04,3.2392E-04,3.0774E-04,2.4623E-04,9.8059E-05,
     &3.8639E-04,5.1167E-04,4.7457E-04,3.6749E-04,1.1880E-04,
     &6.3801E-04,7.9694E-04,7.1675E-04,5.3954E-04,1.4295E-04,
     &1.0211E-03,1.2096E-03,1.0561E-03,7.7552E-04,1.6841E-04/
      DATA ((KB(JS,JT,24, 3),JS=1,5),JT=1,5) /
     &1.2065E-04,1.8059E-04,1.7513E-04,1.4381E-04,6.4790E-05,
     &2.0387E-04,2.8742E-04,2.7331E-04,2.1771E-04,7.9169E-05,
     &3.4413E-04,4.5518E-04,4.2044E-04,3.2458E-04,9.5995E-05,
     &5.6569E-04,7.0542E-04,6.3169E-04,4.7542E-04,1.1593E-04,
     &8.9817E-04,1.0616E-03,9.2695E-04,6.8043E-04,1.3621E-04/
      DATA ((KB(JS,JT,25, 3),JS=1,5),JT=1,5) /
     &1.0740E-04,1.6092E-04,1.5588E-04,1.2763E-04,5.2835E-05,
     &1.8277E-04,2.5653E-04,2.4346E-04,1.9325E-04,6.4708E-05,
     &3.0775E-04,4.0577E-04,3.7301E-04,2.8766E-04,7.8479E-05,
     &5.0348E-04,6.2434E-04,5.5838E-04,4.1972E-04,9.2999E-05,
     &7.9236E-04,9.3393E-04,8.1486E-04,5.9712E-04,1.1091E-04/
      DATA ((KB(JS,JT,26, 3),JS=1,5),JT=1,5) /
     &9.7543E-05,1.4515E-04,1.4079E-04,1.1469E-04,4.3203E-05,
     &1.6637E-04,2.3211E-04,2.1906E-04,1.7338E-04,5.3501E-05,
     &2.7898E-04,3.6497E-04,3.3420E-04,2.5717E-04,6.4391E-05,
     &4.5278E-04,5.5785E-04,4.9753E-04,3.7293E-04,7.6357E-05,
     &7.0495E-04,8.2859E-04,7.2055E-04,5.2702E-04,9.1483E-05/
      DATA ((KB(JS,JT,27, 3),JS=1,5),JT=1,5) /
     &8.8905E-05,1.3136E-04,1.2690E-04,1.0312E-04,3.5556E-05,
     &1.5157E-04,2.0993E-04,1.9708E-04,1.5550E-04,4.3708E-05,
     &2.5313E-04,3.2779E-04,2.9943E-04,2.2974E-04,5.2449E-05,
     &4.0707E-04,4.9850E-04,4.4267E-04,3.3107E-04,6.3153E-05,
     &6.2804E-04,7.3434E-04,6.3748E-04,4.6470E-04,7.4410E-05/
      DATA ((KB(JS,JT,28, 3),JS=1,5),JT=1,5) /
     &8.1071E-05,1.1893E-04,1.1441E-04,9.2670E-05,2.9048E-05,
     &1.3818E-04,1.8937E-04,1.7730E-04,1.3932E-04,3.5467E-05,
     &2.2925E-04,2.9449E-04,2.6762E-04,2.0484E-04,4.2994E-05,
     &3.6544E-04,4.4427E-04,3.9356E-04,2.9338E-04,5.1335E-05,
     &5.5873E-04,6.5113E-04,5.6346E-04,4.0933E-04,6.0144E-05/
      DATA ((KB(JS,JT,29, 3),JS=1,5),JT=1,5) /
     &7.4203E-05,1.0781E-04,1.0341E-04,8.3458E-05,2.3671E-05,
     &1.2605E-04,1.7113E-04,1.5936E-04,1.2487E-04,2.9121E-05,
     &2.0703E-04,2.6395E-04,2.3919E-04,1.8248E-04,3.5057E-05,
     &3.2741E-04,3.9598E-04,3.4952E-04,2.5961E-04,4.1444E-05,
     &4.9624E-04,5.7661E-04,4.9724E-04,3.6006E-04,4.8751E-05/
      DATA ((KB(JS,JT,30, 3),JS=1,5),JT=1,5) /
     &6.7677E-05,9.7468E-05,9.3138E-05,7.4923E-05,1.9287E-05,
     &1.1431E-04,1.5374E-04,1.4284E-04,1.1153E-04,2.3591E-05,
     &1.8623E-04,2.3583E-04,2.1291E-04,1.6193E-04,2.8158E-05,
     &2.9180E-04,3.5163E-04,3.0921E-04,2.2892E-04,3.3328E-05,
     &4.3918E-04,5.0854E-04,4.3751E-04,3.1569E-04,3.9501E-05/
      DATA ((KB(JS,JT,31, 3),JS=1,5),JT=1,5) /
     &6.1393E-05,8.7694E-05,8.3630E-05,6.7048E-05,1.5382E-05,
     &1.0290E-04,1.3743E-04,1.2731E-04,9.9241E-05,1.8651E-05,
     &1.6626E-04,2.0956E-04,1.8851E-04,1.4301E-04,2.2748E-05,
     &2.5819E-04,3.1016E-04,2.7211E-04,2.0081E-04,2.7039E-05,
     &3.8535E-04,4.4535E-04,3.8254E-04,2.7522E-04,3.1790E-05/
      DATA ((KB(JS,JT,32, 3),JS=1,5),JT=1,5) /
     &5.5908E-05,7.9178E-05,7.5227E-05,6.0166E-05,1.2301E-05,
     &9.3029E-05,1.2336E-04,1.1373E-04,8.8415E-05,1.5236E-05,
     &1.4900E-04,1.8677E-04,1.6744E-04,1.2652E-04,1.8544E-05,
     &2.2938E-04,2.7443E-04,2.4002E-04,1.7648E-04,2.2012E-05,
     &3.3936E-04,3.9112E-04,3.3532E-04,2.4040E-04,2.5885E-05/
      DATA ((KB(JS,JT,33, 3),JS=1,5),JT=1,5) /
     &5.1027E-05,7.1592E-05,6.7752E-05,5.3984E-05,1.0069E-05,
     &8.4306E-05,1.1082E-04,1.0178E-04,7.8786E-05,1.2424E-05,
     &1.3378E-04,1.6666E-04,1.4886E-04,1.1198E-04,1.5017E-05,
     &2.0407E-04,2.4310E-04,2.1204E-04,1.5519E-04,1.7833E-05,
     &2.9932E-04,3.4399E-04,2.9425E-04,2.1002E-04,2.0751E-05/
      DATA ((KB(JS,JT,34, 3),JS=1,5),JT=1,5) /
     &4.6423E-05,6.4385E-05,6.0651E-05,4.8084E-05,8.2313E-06,
     &7.6075E-05,9.9124E-05,9.0586E-05,6.9780E-05,1.0168E-05,
     &1.1981E-04,1.4811E-04,1.3176E-04,9.8597E-05,1.2205E-05,
     &1.8123E-04,2.1472E-04,1.8662E-04,1.3590E-04,1.4492E-05,
     &2.6376E-04,3.0190E-04,2.5753E-04,1.8301E-04,1.6946E-05/
      DATA ((KB(JS,JT,35, 3),JS=1,5),JT=1,5) /
     &4.0215E-05,5.5516E-05,5.2178E-05,4.1265E-05,6.6300E-06,
     &6.5646E-05,8.5207E-05,7.7691E-05,5.9694E-05,8.1351E-06,
     &1.0298E-04,1.2694E-04,1.1266E-04,8.4059E-05,9.8103E-06,
     &1.5503E-04,1.8334E-04,1.5905E-04,1.1551E-04,1.1630E-05,
     &2.2476E-04,2.5697E-04,2.1886E-04,1.5514E-04,1.3591E-05/
      DATA ((KB(JS,JT,36, 3),JS=1,5),JT=1,5) /
     &3.2994E-05,4.5660E-05,4.2930E-05,3.3969E-05,5.1542E-06,
     &5.3916E-05,7.0104E-05,6.3946E-05,4.9132E-05,6.3498E-06,
     &8.4552E-05,1.0443E-04,9.2717E-05,6.9170E-05,7.6665E-06,
     &1.2731E-04,1.5086E-04,1.3088E-04,9.4999E-05,9.0883E-06,
     &1.8455E-04,2.1131E-04,1.8000E-04,1.2756E-04,1.0606E-05/
      DATA ((KB(JS,JT,37, 3),JS=1,5),JT=1,5) /
     &2.5429E-05,3.5502E-05,3.3507E-05,2.6612E-05,3.9872E-06,
     &4.1789E-05,5.4774E-05,5.0118E-05,3.8644E-05,4.9244E-06,
     &6.5920E-05,8.1963E-05,7.2974E-05,5.4610E-05,5.9794E-06,
     &9.9825E-05,1.1892E-04,1.0339E-04,7.5254E-05,7.1021E-06,
     &1.4543E-04,1.6731E-04,1.4273E-04,1.0135E-04,8.2993E-06/
      DATA ((KB(JS,JT,38, 3),JS=1,5),JT=1,5) /
     &1.9510E-05,2.7499E-05,2.6048E-05,2.0774E-05,3.0726E-06,
     &3.2252E-05,4.2623E-05,3.9146E-05,3.0291E-05,3.8102E-06,
     &5.1187E-05,6.4097E-05,5.7223E-05,4.2970E-05,4.6390E-06,
     &7.8004E-05,9.3430E-05,8.1421E-05,5.9437E-05,5.5099E-06,
     &1.1424E-04,1.3207E-04,1.1286E-04,8.0305E-05,6.4580E-06/
      DATA ((KB(JS,JT,39, 3),JS=1,5),JT=1,5) /
     &1.4955E-05,2.1282E-05,2.0237E-05,1.6208E-05,2.3414E-06,
     &2.4867E-05,3.3144E-05,3.0547E-05,2.3724E-05,2.9298E-06,
     &3.9718E-05,5.0092E-05,4.4848E-05,3.3792E-05,3.5597E-06,
     &6.0902E-05,7.3365E-05,6.4080E-05,4.6913E-05,4.2665E-06,
     &8.9673E-05,1.0416E-04,8.9163E-05,6.3592E-05,5.0003E-06/
      DATA ((KB(JS,JT,40, 3),JS=1,5),JT=1,5) /
     &1.0973E-05,1.5834E-05,1.5141E-05,1.2207E-05,1.7695E-06,
     &1.8417E-05,2.4851E-05,2.3037E-05,1.7992E-05,2.2304E-06,
     &2.9718E-05,3.7867E-05,3.4065E-05,2.5810E-05,2.7325E-06,
     &4.6050E-05,5.5927E-05,4.9024E-05,3.6065E-05,3.2836E-06,
     &6.8462E-05,8.0022E-05,6.8684E-05,4.9179E-05,3.8780E-06/
      DATA ((KB(JS,JT,41, 3),JS=1,5),JT=1,5) /
     &7.9936E-06,1.1702E-05,1.1250E-05,9.1326E-06,1.3289E-06,
     &1.3541E-05,1.8510E-05,1.7261E-05,1.3563E-05,1.6876E-06,
     &2.2085E-05,2.8450E-05,2.5728E-05,1.9606E-05,2.0896E-06,
     &3.4599E-05,4.2393E-05,3.7310E-05,2.7591E-05,2.5142E-06,
     &5.1973E-05,6.1166E-05,5.2649E-05,3.7859E-05,2.9985E-06/
      DATA ((KB(JS,JT,42, 3),JS=1,5),JT=1,5) /
     &5.8131E-06,8.6287E-06,8.3395E-06,6.8180E-06,9.9321E-07,
     &9.9286E-06,1.3753E-05,1.2903E-05,1.0201E-05,1.2739E-06,
     &1.6369E-05,2.1324E-05,1.9387E-05,1.4861E-05,1.5862E-06,
     &2.5917E-05,3.2058E-05,2.8333E-05,2.1064E-05,1.9289E-06,
     &3.9355E-05,4.6652E-05,4.0275E-05,2.9099E-05,2.3091E-06/
      DATA ((KB(JS,JT,43, 3),JS=1,5),JT=1,5) /
     &4.1379E-06,6.2276E-06,6.0505E-06,4.9862E-06,7.3153E-07,
     &7.1228E-06,1.0012E-05,9.4538E-06,7.5288E-06,9.4466E-07,
     &1.1889E-05,1.5688E-05,1.4350E-05,1.1075E-05,1.1892E-06,
     &1.9074E-05,2.3844E-05,2.1179E-05,1.5845E-05,1.4637E-06,
     &2.9351E-05,3.5073E-05,3.0382E-05,2.2068E-05,1.7581E-06/
      DATA ((KB(JS,JT,44, 3),JS=1,5),JT=1,5) /
     &2.9204E-06,4.4462E-06,4.3423E-06,3.6069E-06,5.3481E-07,
     &5.0527E-06,7.2110E-06,6.8508E-06,5.4982E-06,6.9481E-07,
     &8.5402E-06,1.1419E-05,1.0515E-05,8.1724E-06,8.8543E-07,
     &1.3894E-05,1.7562E-05,1.5682E-05,1.1814E-05,1.0984E-06,
     &2.1692E-05,2.6150E-05,2.2738E-05,1.6619E-05,1.3258E-06/
      DATA ((KB(JS,JT,45, 3),JS=1,5),JT=1,5) /
     &2.0654E-06,3.1706E-06,3.1106E-06,2.6027E-06,3.8843E-07,
     &3.5785E-06,5.1800E-06,4.9498E-06,4.0029E-06,5.0552E-07,
     &6.1156E-06,8.2899E-06,7.6825E-06,6.0114E-06,6.4899E-07,
     &1.0090E-05,1.2899E-05,1.1584E-05,8.7849E-06,8.1182E-07,
     &1.5974E-05,1.9436E-05,1.6972E-05,1.2481E-05,9.9260E-07/
      DATA ((KB(JS,JT,46, 3),JS=1,5),JT=1,5) /
     &1.4538E-06,2.2381E-06,2.2044E-06,1.8570E-06,2.7780E-07,
     &2.5054E-06,3.6761E-06,3.5333E-06,2.8803E-06,3.6666E-07,
     &4.3205E-06,5.9430E-06,5.5451E-06,4.3709E-06,4.7052E-07,
     &7.2299E-06,9.3616E-06,8.4601E-06,6.4628E-06,5.9539E-07,
     &1.1621E-05,1.4285E-05,1.2535E-05,9.2836E-06,7.3565E-07/
      DATA ((KB(JS,JT,47, 3),JS=1,5),JT=1,5) /
     &1.0143E-06,1.5538E-06,1.5325E-06,1.2979E-06,1.9733E-07,
     &1.7208E-06,2.5538E-06,2.4694E-06,2.0305E-06,2.6304E-07,
     &2.9828E-06,4.1702E-06,3.9202E-06,3.1167E-06,3.4065E-07,
     &5.0644E-06,6.6541E-06,6.0593E-06,4.6660E-06,4.3326E-07,
     &8.2782E-06,1.0300E-05,9.0956E-06,6.7879E-06,5.4017E-07/
      DATA ((KB(JS,JT,48, 3),JS=1,5),JT=1,5) /
     &7.2030E-07,1.0845E-06,1.0676E-06,9.0611E-07,1.3761E-07,
     &1.1872E-06,1.7730E-06,1.7228E-06,1.4271E-06,1.8706E-07,
     &2.0561E-06,2.9161E-06,2.7609E-06,2.2135E-06,2.4544E-07,
     &3.5327E-06,4.7102E-06,4.3223E-06,3.3540E-06,3.1231E-07,
     &5.8701E-06,7.3943E-06,6.5729E-06,4.9432E-06,3.9364E-07/
      DATA ((KB(JS,JT,49, 3),JS=1,5),JT=1,5) /
     &5.2463E-07,7.6406E-07,7.4789E-07,6.3224E-07,9.4269E-08,
     &8.2733E-07,1.2326E-06,1.2007E-06,1.0005E-06,1.3092E-07,
     &1.4174E-06,2.0342E-06,1.9376E-06,1.5657E-06,1.7460E-07,
     &2.4552E-06,3.3221E-06,3.0702E-06,2.4004E-06,2.2553E-07,
     &4.1423E-06,5.2851E-06,4.7305E-06,3.5840E-06,2.8424E-07/
      DATA ((KB(JS,JT,50, 3),JS=1,5),JT=1,5) /
     &3.9659E-07,5.5178E-07,5.3440E-07,4.4722E-07,6.5930E-08,
     &5.9210E-07,8.7140E-07,8.4803E-07,7.0817E-07,9.3562E-08,
     &9.9396E-07,1.4345E-06,1.3722E-06,1.1160E-06,1.2619E-07,
     &1.7258E-06,2.3624E-06,2.1973E-06,1.7292E-06,1.6444E-07,
     &2.9480E-06,3.8052E-06,3.4270E-06,2.6131E-06,2.0855E-07/
      DATA ((KB(JS,JT,51, 3),JS=1,5),JT=1,5) /
     &3.0780E-07,4.0724E-07,3.8772E-07,3.1909E-07,4.7152E-08,
     &4.3389E-07,6.2376E-07,6.0442E-07,5.0387E-07,6.6848E-08,
     &7.0578E-07,1.0183E-06,9.7661E-07,7.9773E-07,9.1673E-08,
     &1.2202E-06,1.6857E-06,1.5762E-06,1.2481E-06,1.2080E-07,
     &2.1050E-06,2.7463E-06,2.4878E-06,1.9078E-06,1.5488E-07/
      DATA ((KB(JS,JT,52, 3),JS=1,5),JT=1,5) /
     &2.4467E-07,3.0672E-07,2.8540E-07,2.2927E-07,3.3766E-08,
     &3.2577E-07,4.5139E-07,4.3382E-07,3.5906E-07,4.7409E-08,
     &5.0672E-07,7.2555E-07,6.9595E-07,5.7001E-07,6.5991E-08,
     &8.6516E-07,1.2018E-06,1.1289E-06,8.9884E-07,8.8646E-08,
     &1.5011E-06,1.9777E-06,1.8012E-06,1.3890E-06,1.1411E-07/
      DATA ((KB(JS,JT,53, 3),JS=1,5),JT=1,5) /
     &1.9893E-07,2.3655E-07,2.1398E-07,1.6650E-07,2.3697E-08,
     &2.5083E-07,3.3159E-07,3.1422E-07,2.5680E-07,3.3792E-08,
     &3.6925E-07,5.1963E-07,4.9710E-07,4.0705E-07,4.7057E-08,
     &6.1624E-07,8.5716E-07,8.0760E-07,6.4558E-07,6.4327E-08,
     &1.0701E-06,1.4207E-06,1.3006E-06,1.0081E-06,8.3703E-08/
      DATA ((KB(JS,JT,54, 3),JS=1,5),JT=1,5) /
     &1.6569E-07,1.8826E-07,1.6516E-07,1.2463E-07,1.7341E-08,
     &1.9916E-07,2.5095E-07,2.3323E-07,1.8716E-07,2.4743E-08,
     &2.7800E-07,3.8083E-07,3.6198E-07,2.9489E-07,3.4593E-08,
     &4.4953E-07,6.2218E-07,5.8637E-07,4.6947E-07,4.7657E-08,
     &7.7653E-07,1.0348E-06,9.5106E-07,7.3964E-07,6.2914E-08/
      DATA ((KB(JS,JT,55, 3),JS=1,5),JT=1,5) /
     &1.4043E-07,1.5348E-07,1.3050E-07,9.5790E-08,1.3021E-08,
     &1.6195E-07,1.9454E-07,1.7661E-07,1.3842E-07,1.8310E-08,
     &2.1498E-07,2.8400E-07,2.6714E-07,2.1561E-07,2.5769E-08,
     &3.3384E-07,4.5663E-07,4.2946E-07,3.4367E-07,3.5731E-08,
     &5.6980E-07,7.5956E-07,6.9954E-07,5.4544E-07,4.7978E-08/
      DATA ((KB(JS,JT,56, 3),JS=1,5),JT=1,5) /
     &1.2086E-07,1.2723E-07,1.0539E-07,7.4446E-08,9.2261E-09,
     &1.3434E-07,1.5407E-07,1.3616E-07,1.0396E-07,1.3447E-08,
     &1.7000E-07,2.1506E-07,1.9916E-07,1.5861E-07,1.9233E-08,
     &2.5155E-07,3.3746E-07,3.1592E-07,2.5204E-07,2.6859E-08,
     &4.2088E-07,5.5907E-07,5.1525E-07,4.0220E-07,3.6549E-08/
      DATA ((KB(JS,JT,57, 3),JS=1,5),JT=1,5) /
     &1.0553E-07,1.0707E-07,8.7153E-08,5.8944E-08,6.8033E-09,
     &1.1362E-07,1.2487E-07,1.0708E-07,7.9506E-08,9.8943E-09,
     &1.3729E-07,1.6577E-07,1.5039E-07,1.1755E-07,1.4310E-08,
     &1.9303E-07,2.5185E-07,2.3386E-07,1.8533E-07,2.0155E-08,
     &3.1378E-07,4.1313E-07,3.8025E-07,2.9656E-07,2.7619E-08/
      DATA ((KB(JS,JT,58, 3),JS=1,5),JT=1,5) /
     &4.5186E-08,5.0890E-08,4.7832E-08,3.7472E-08,5.1696E-09,
     &4.7401E-08,5.7618E-08,5.6357E-08,4.8955E-08,7.4243E-09,
     &5.5010E-08,7.2882E-08,7.5797E-08,7.0136E-08,1.0687E-08,
     &7.3718E-08,1.0653E-07,1.1470E-07,1.0884E-07,1.5198E-08,
     &1.1547E-07,1.7203E-07,1.8517E-07,1.7422E-07,2.1153E-08/
      DATA ((KB(JS,JT,59, 3),JS=1,5),JT=1,5) /
     &3.8720E-08,4.3027E-08,4.0190E-08,3.1252E-08,4.1397E-09,
     &4.0213E-08,4.8103E-08,4.6638E-08,4.0062E-08,6.0380E-09,
     &4.5994E-08,5.9694E-08,6.1452E-08,5.6505E-08,8.8443E-09,
     &6.0487E-08,8.5685E-08,9.1743E-08,8.6818E-08,1.2879E-08,
     &9.3188E-08,1.3722E-07,1.4752E-07,1.3892E-07,1.7999E-08/
      DATA ((KB(JS,JT,13, 4),JS=1,5),JT=1,5) /
     &4.3869E-03,5.0989E-03,4.3794E-03,3.0521E-03,9.4784E-04,
     &6.9481E-03,7.8458E-03,6.6078E-03,4.5663E-03,1.0961E-03,
     &1.1023E-02,1.1980E-02,9.8280E-03,6.7431E-03,1.2240E-03,
     &1.7316E-02,1.8007E-02,1.4661E-02,9.8568E-03,1.4326E-03,
     &2.6628E-02,2.6632E-02,2.1301E-02,1.4107E-02,1.6715E-03/
      DATA ((KB(JS,JT,14, 4),JS=1,5),JT=1,5) /
     &3.8856E-03,4.5615E-03,3.8907E-03,2.6924E-03,7.6763E-04,
     &6.2253E-03,7.0528E-03,5.8968E-03,4.0418E-03,8.6051E-04,
     &1.0002E-02,1.0752E-02,8.8582E-03,6.0065E-03,1.0065E-03,
     &1.5699E-02,1.6229E-02,1.3163E-02,8.7970E-03,1.2227E-03,
     &2.4269E-02,2.4030E-02,1.9137E-02,1.2536E-02,1.4474E-03/
      DATA ((KB(JS,JT,15, 4),JS=1,5),JT=1,5) /
     &3.2659E-03,3.8770E-03,3.3101E-03,2.3048E-03,5.7573E-04,
     &5.3241E-03,6.0372E-03,5.0494E-03,3.4916E-03,6.8321E-04,
     &8.6002E-03,9.2086E-03,7.6334E-03,5.1974E-03,8.4736E-04,
     &1.3547E-02,1.3992E-02,1.1347E-02,7.5834E-03,1.0287E-03,
     &2.1009E-02,2.0762E-02,1.6574E-02,1.0811E-02,1.2066E-03/
      DATA ((KB(JS,JT,16, 4),JS=1,5),JT=1,5) /
     &2.6697E-03,3.2234E-03,2.7529E-03,1.9451E-03,4.4184E-04,
     &4.4186E-03,5.0347E-03,4.2523E-03,2.9486E-03,5.5826E-04,
     &7.1546E-03,7.7280E-03,6.4040E-03,4.4001E-03,6.8881E-04,
     &1.1406E-02,1.1811E-02,9.5855E-03,6.4241E-03,8.3295E-04,
     &1.7781E-02,1.7577E-02,1.4001E-02,9.1645E-03,9.7098E-04/
      DATA ((KB(JS,JT,17, 4),JS=1,5),JT=1,5) /
     &2.1896E-03,2.6538E-03,2.2904E-03,1.6414E-03,3.5480E-04,
     &3.6444E-03,4.1897E-03,3.5440E-03,2.4805E-03,4.4971E-04,
     &5.9916E-03,6.4686E-03,5.3743E-03,3.6974E-03,5.5799E-04,
     &9.5963E-03,9.9128E-03,8.0553E-03,5.4068E-03,6.7241E-04,
     &1.5025E-02,1.4809E-02,1.1810E-02,7.7160E-03,7.7063E-04/
      DATA ((KB(JS,JT,18, 4),JS=1,5),JT=1,5) /
     &1.7997E-03,2.1886E-03,1.9082E-03,1.3670E-03,2.9021E-04,
     &3.0120E-03,3.4746E-03,2.9450E-03,2.0706E-03,3.7282E-04,
     &4.9798E-03,5.3990E-03,4.4938E-03,3.0816E-03,4.5930E-04,
     &8.0081E-03,8.2644E-03,6.7223E-03,4.5032E-03,5.4734E-04,
     &1.2492E-02,1.2373E-02,9.8644E-03,6.4255E-03,6.3020E-04/
      DATA ((KB(JS,JT,19, 4),JS=1,5),JT=1,5) /
     &1.5064E-03,1.8451E-03,1.6056E-03,1.1522E-03,2.4682E-04,
     &2.5474E-03,2.9294E-03,2.4915E-03,1.7507E-03,3.1538E-04,
     &4.2186E-03,4.5798E-03,3.8063E-03,2.5988E-03,3.8674E-04,
     &6.8019E-03,7.0063E-03,5.6982E-03,3.8032E-03,4.6124E-04,
     &1.0595E-02,1.0486E-02,8.3528E-03,5.4249E-03,5.3320E-04/
      DATA ((KB(JS,JT,20, 4),JS=1,5),JT=1,5) /
     &1.3102E-03,1.5983E-03,1.3859E-03,9.9291E-04,2.1228E-04,
     &2.2269E-03,2.5410E-03,2.1563E-03,1.5072E-03,2.6816E-04,
     &3.6896E-03,3.9778E-03,3.2977E-03,2.2454E-03,3.2819E-04,
     &5.9414E-03,6.0960E-03,4.9353E-03,3.2744E-03,3.9225E-04,
     &9.2578E-03,9.1102E-03,7.2255E-03,4.6712E-03,4.5336E-04/
      DATA ((KB(JS,JT,21, 4),JS=1,5),JT=1,5) /
     &1.1473E-03,1.3888E-03,1.2016E-03,8.6011E-04,1.8127E-04,
     &1.9565E-03,2.2181E-03,1.8746E-03,1.3038E-03,2.2830E-04,
     &3.2520E-03,3.4808E-03,2.8694E-03,1.9461E-03,2.7800E-04,
     &5.2204E-03,5.3317E-03,4.2972E-03,2.8342E-03,3.3105E-04,
     &8.1069E-03,7.9508E-03,6.2747E-03,4.0360E-03,3.8585E-04/
      DATA ((KB(JS,JT,22, 4),JS=1,5),JT=1,5) /
     &1.0382E-03,1.2396E-03,1.0678E-03,7.6273E-04,1.5466E-04,
     &1.7720E-03,1.9893E-03,1.6695E-03,1.1556E-03,1.9356E-04,
     &2.9369E-03,3.1200E-03,2.5557E-03,1.7237E-03,2.3624E-04,
     &4.6992E-03,4.7636E-03,3.8178E-03,2.5063E-03,2.7855E-04,
     &7.2282E-03,7.0542E-03,5.5487E-03,3.5490E-03,3.2630E-04/
      DATA ((KB(JS,JT,23, 4),JS=1,5),JT=1,5) /
     &9.4131E-04,1.1095E-03,9.5148E-04,6.7660E-04,1.3244E-04,
     &1.6035E-03,1.7844E-03,1.4894E-03,1.0262E-03,1.6442E-04,
     &2.6522E-03,2.7950E-03,2.2775E-03,1.5271E-03,2.0008E-04,
     &4.2106E-03,4.2402E-03,3.3871E-03,2.2131E-03,2.3445E-04,
     &6.4196E-03,6.2427E-03,4.8940E-03,3.1130E-03,2.7496E-04/
      DATA ((KB(JS,JT,24, 4),JS=1,5),JT=1,5) /
     &8.5493E-04,1.0008E-03,8.5274E-04,6.0213E-04,1.1224E-04,
     &1.4576E-03,1.6070E-03,1.3354E-03,9.1642E-04,1.3965E-04,
     &2.4005E-03,2.5083E-03,2.0375E-03,1.3606E-03,1.6869E-04,
     &3.7805E-03,3.7882E-03,3.0168E-03,1.9590E-03,1.9824E-04,
     &5.7340E-03,5.5429E-03,4.3252E-03,2.7397E-03,2.2899E-04/
      DATA ((KB(JS,JT,25, 4),JS=1,5),JT=1,5) /
     &7.8083E-04,9.0613E-04,7.6855E-04,5.3955E-04,9.3397E-05,
     &1.3293E-03,1.4516E-03,1.2021E-03,8.2125E-04,1.1644E-04,
     &2.1730E-03,2.2546E-03,1.8276E-03,1.2136E-03,1.4039E-04,
     &3.3994E-03,3.3901E-03,2.6854E-03,1.7374E-03,1.6529E-04,
     &5.1177E-03,4.9296E-03,3.8308E-03,2.4138E-03,1.9292E-04/
      DATA ((KB(JS,JT,26, 4),JS=1,5),JT=1,5) /
     &7.2414E-04,8.2998E-04,6.9991E-04,4.8962E-04,7.9259E-05,
     &1.2259E-03,1.3255E-03,1.0917E-03,7.4177E-04,9.7580E-05,
     &1.9848E-03,2.0462E-03,1.6503E-03,1.0895E-03,1.1629E-04,
     &3.0863E-03,3.0554E-03,2.4123E-03,1.5502E-03,1.3732E-04,
     &4.5999E-03,4.4081E-03,3.4159E-03,2.1402E-03,1.6386E-04/
      DATA ((KB(JS,JT,27, 4),JS=1,5),JT=1,5) /
     &6.7040E-04,7.6049E-04,6.3931E-04,4.4424E-04,6.5890E-05,
     &1.1282E-03,1.2096E-03,9.9105E-04,6.6941E-04,8.0876E-05,
     &1.8147E-03,1.8556E-03,1.4889E-03,9.7714E-04,9.6344E-05,
     &2.7940E-03,2.7516E-03,2.1627E-03,1.3811E-03,1.1546E-04,
     &4.1206E-03,3.9340E-03,3.0363E-03,1.8956E-03,1.3791E-04/
      DATA ((KB(JS,JT,28, 4),JS=1,5),JT=1,5) /
     &6.1963E-04,6.9617E-04,5.8205E-04,4.0239E-04,5.3842E-05,
     &1.0354E-03,1.1013E-03,8.9815E-04,6.0298E-04,6.6022E-05,
     &1.6516E-03,1.6797E-03,1.3412E-03,8.7507E-04,8.0123E-05,
     &2.5197E-03,2.4709E-03,1.9338E-03,1.2274E-03,9.7074E-05,
     &3.6744E-03,3.4958E-03,2.6900E-03,1.6731E-03,1.1603E-04/
      DATA ((KB(JS,JT,29, 4),JS=1,5),JT=1,5) /
     &5.7255E-04,6.3719E-04,5.3001E-04,3.6415E-04,4.3783E-05,
     &9.4899E-04,1.0006E-03,8.1341E-04,5.4243E-04,5.3930E-05,
     &1.4973E-03,1.5143E-03,1.2048E-03,7.8083E-04,6.6803E-05,
     &2.2572E-03,2.2044E-03,1.7199E-03,1.0861E-03,8.0985E-05,
     &3.2527E-03,3.0849E-03,2.3685E-03,1.4686E-03,9.6201E-05/
      DATA ((KB(JS,JT,30, 4),JS=1,5),JT=1,5) /
     &5.2637E-04,5.8081E-04,4.8010E-04,3.2816E-04,3.5536E-05,
     &8.6289E-04,9.0357E-04,7.3215E-04,4.8521E-04,4.4824E-05,
     &1.3456E-03,1.3553E-03,1.0747E-03,6.9223E-04,5.5319E-05,
     &2.0065E-03,1.9507E-03,1.5172E-03,9.5518E-04,6.6828E-05,
     &2.8573E-03,2.7008E-03,2.0712E-03,1.2802E-03,7.9313E-05/
      DATA ((KB(JS,JT,31, 4),JS=1,5),JT=1,5) /
     &4.7945E-04,5.2447E-04,4.3249E-04,2.9383E-04,2.9390E-05,
     &7.7587E-04,8.0972E-04,6.5328E-04,4.3065E-04,3.6906E-05,
     &1.1974E-03,1.2004E-03,9.4868E-04,6.0827E-04,4.5016E-05,
     &1.7617E-03,1.7074E-03,1.3255E-03,8.3172E-04,5.4252E-05,
     &2.4825E-03,2.3423E-03,1.7933E-03,1.1061E-03,6.4138E-05/
      DATA ((KB(JS,JT,32, 4),JS=1,5),JT=1,5) /
     &4.3738E-04,4.7509E-04,3.9041E-04,2.6369E-04,2.4019E-05,
     &6.9937E-04,7.2599E-04,5.8354E-04,3.8245E-04,2.9892E-05,
     &1.0660E-03,1.0639E-03,8.3776E-04,5.3497E-04,3.6437E-05,
     &1.5490E-03,1.4965E-03,1.1588E-03,7.2497E-04,4.3698E-05,
     &2.1609E-03,2.0352E-03,1.5553E-03,9.5666E-04,5.1532E-05/
      DATA ((KB(JS,JT,33, 4),JS=1,5),JT=1,5) /
     &3.9889E-04,4.2999E-04,3.5197E-04,2.3634E-04,1.9311E-05,
     &6.2991E-04,6.5021E-04,5.2059E-04,3.3932E-04,2.4117E-05,
     &9.4755E-04,9.4129E-04,7.3904E-04,4.6991E-04,2.9354E-05,
     &1.3617E-03,1.3113E-03,1.0129E-03,6.3180E-04,3.5029E-05,
     &1.8805E-03,1.7688E-03,1.3485E-03,8.2760E-04,4.1309E-05/
      DATA ((KB(JS,JT,34, 4),JS=1,5),JT=1,5) /
     &3.6214E-04,3.8716E-04,3.1549E-04,2.1059E-04,1.5692E-05,
     &5.6474E-04,5.7963E-04,4.6204E-04,2.9966E-04,1.9450E-05,
     &8.4034E-04,8.3067E-04,6.4971E-04,4.1144E-04,2.3693E-05,
     &1.1957E-03,1.1475E-03,8.8389E-04,5.4962E-04,2.8253E-05,
     &1.6380E-03,1.5373E-03,1.1695E-03,7.1576E-04,3.2957E-05/
      DATA ((KB(JS,JT,35, 4),JS=1,5),JT=1,5) /
     &3.1359E-04,3.3446E-04,2.7193E-04,1.8091E-04,1.2437E-05,
     &4.8583E-04,4.9752E-04,3.9566E-04,2.5593E-04,1.5305E-05,
     &7.1875E-04,7.0909E-04,5.5358E-04,3.4993E-04,1.8635E-05,
     &1.0171E-03,9.7513E-04,7.5023E-04,4.6569E-04,2.2205E-05,
     &1.3872E-03,1.3015E-03,9.8912E-04,6.0449E-04,2.6045E-05/
      DATA ((KB(JS,JT,36, 4),JS=1,5),JT=1,5) /
     &2.5808E-04,2.7599E-04,2.2440E-04,1.4937E-04,9.6631E-06,
     &3.9964E-04,4.1003E-04,3.2602E-04,2.1097E-04,1.1834E-05,
     &5.9092E-04,5.8383E-04,4.5590E-04,2.8824E-04,1.4353E-05,
     &8.3595E-04,8.0277E-04,6.1763E-04,3.8334E-04,1.7189E-05,
     &1.1396E-03,1.0707E-03,8.1375E-04,4.9743E-04,2.0326E-05/
      DATA ((KB(JS,JT,37, 4),JS=1,5),JT=1,5) /
     &2.0121E-04,2.1647E-04,1.7647E-04,1.1785E-04,7.4310E-06,
     &3.1330E-04,3.2327E-04,2.5768E-04,1.6717E-04,9.1199E-06,
     &4.6580E-04,4.6262E-04,3.6181E-04,2.2919E-04,1.1050E-05,
     &6.6212E-04,6.3859E-04,4.9190E-04,3.0576E-04,1.3280E-05,
     &9.0672E-04,8.5472E-04,6.5027E-04,3.9796E-04,1.5719E-05/
      DATA ((KB(JS,JT,38, 4),JS=1,5),JT=1,5) /
     &1.5610E-04,1.6913E-04,1.3823E-04,9.2645E-05,5.6716E-06,
     &2.4467E-04,2.5398E-04,2.0295E-04,1.3206E-04,6.9811E-06,
     &3.6591E-04,3.6541E-04,2.8633E-04,1.8175E-04,8.4645E-06,
     &5.2302E-04,5.0671E-04,3.9077E-04,2.4331E-04,1.0160E-05,
     &7.1953E-04,6.8071E-04,5.1841E-04,3.1771E-04,1.2087E-05/
      DATA ((KB(JS,JT,39, 4),JS=1,5),JT=1,5) /
     &1.2096E-04,1.3199E-04,1.0815E-04,7.2736E-05,4.3132E-06,
     &1.9086E-04,1.9937E-04,1.5970E-04,1.0426E-04,5.3181E-06,
     &2.8720E-04,2.8844E-04,2.2641E-04,1.4405E-04,6.4566E-06,
     &4.1286E-04,4.0180E-04,3.1020E-04,1.9350E-04,7.7296E-06,
     &5.7063E-04,5.4191E-04,4.1317E-04,2.5355E-04,9.2083E-06/
      DATA ((KB(JS,JT,40, 4),JS=1,5),JT=1,5) /
     &9.0120E-05,9.9405E-05,8.1774E-05,5.5348E-05,3.2802E-06,
     &1.4396E-04,1.5172E-04,1.2199E-04,8.0081E-05,4.0450E-06,
     &2.1897E-04,2.2172E-04,1.7453E-04,1.1150E-04,4.9391E-06,
     &3.1818E-04,3.1148E-04,2.4096E-04,1.5075E-04,5.9260E-06,
     &4.4338E-04,4.2299E-04,3.2304E-04,1.9869E-04,7.0429E-06/
      DATA ((KB(JS,JT,41, 4),JS=1,5),JT=1,5) /
     &6.6586E-05,7.4344E-05,6.1391E-05,4.1826E-05,2.4789E-06,
     &1.0786E-04,1.1471E-04,9.2627E-05,6.1134E-05,3.0831E-06,
     &1.6588E-04,1.6943E-04,1.3383E-04,8.5899E-05,3.7712E-06,
     &2.4383E-04,2.4037E-04,1.8645E-04,1.1700E-04,4.5478E-06,
     &3.4300E-04,3.2889E-04,2.5168E-04,1.5514E-04,5.3910E-06/
      DATA ((KB(JS,JT,42, 4),JS=1,5),JT=1,5) /
     &4.8998E-05,5.5419E-05,4.5947E-05,3.1516E-05,1.8667E-06,
     &8.0484E-05,8.6481E-05,7.0103E-05,4.6544E-05,2.3354E-06,
     &1.2531E-04,1.2923E-04,1.0238E-04,6.6044E-05,2.8708E-06,
     &1.8633E-04,1.8503E-04,1.4397E-04,9.0645E-05,3.4606E-06,
     &2.6476E-04,2.5534E-04,1.9578E-04,1.2098E-04,4.1084E-06/
      DATA ((KB(JS,JT,43, 4),JS=1,5),JT=1,5) /
     &3.5242E-05,4.0436E-05,3.3714E-05,2.3281E-05,1.3919E-06,
     &5.8897E-05,6.4054E-05,5.2168E-05,3.4865E-05,1.7548E-06,
     &9.3170E-05,9.7046E-05,7.7251E-05,5.0106E-05,2.1668E-06,
     &1.4048E-04,1.4075E-04,1.0986E-04,6.9448E-05,2.6074E-06,
     &2.0220E-04,1.9644E-04,1.5089E-04,9.3492E-05,3.1278E-06/
      DATA ((KB(JS,JT,44, 4),JS=1,5),JT=1,5) /
     &2.5004E-05,2.9138E-05,2.4437E-05,1.6989E-05,1.0250E-06,
     &4.2585E-05,4.6938E-05,3.8422E-05,2.5865E-05,1.3112E-06,
     &6.8563E-05,7.2232E-05,5.7761E-05,3.7700E-05,1.6186E-06,
     &1.0501E-04,1.0630E-04,8.3253E-05,5.2860E-05,1.9651E-06,
     &1.5343E-04,1.5019E-04,1.1567E-04,7.1872E-05,2.3710E-06/
      DATA ((KB(JS,JT,45, 4),JS=1,5),JT=1,5) /
     &1.7648E-05,2.0899E-05,1.7624E-05,1.2332E-05,7.4778E-07,
     &3.0648E-05,3.4228E-05,2.8145E-05,1.9101E-05,9.7150E-07,
     &5.0244E-05,5.3520E-05,4.3001E-05,2.8243E-05,1.2073E-06,
     &7.8191E-05,7.9995E-05,6.2888E-05,4.0157E-05,1.4831E-06,
     &1.1605E-04,1.1449E-04,8.8448E-05,5.5140E-05,1.7858E-06/
      DATA ((KB(JS,JT,46, 4),JS=1,5),JT=1,5) /
     &1.2241E-05,1.4754E-05,1.2528E-05,8.8151E-06,5.3848E-07,
     &2.1731E-05,2.4625E-05,2.0352E-05,1.3921E-05,7.0792E-07,
     &3.6328E-05,3.9139E-05,3.1626E-05,2.0940E-05,8.9555E-07,
     &5.7531E-05,5.9510E-05,4.7024E-05,3.0210E-05,1.1090E-06,
     &8.6821E-05,8.6443E-05,6.7046E-05,4.1968E-05,1.3451E-06/
      DATA ((KB(JS,JT,47, 4),JS=1,5),JT=1,5) /
     &8.2449E-06,1.0146E-05,8.6807E-06,6.1518E-06,3.8332E-07,
     &1.4999E-05,1.7293E-05,1.4384E-05,9.9184E-06,5.1069E-07,
     &2.5663E-05,2.8031E-05,2.2776E-05,1.5214E-05,6.5507E-07,
     &4.1483E-05,4.3442E-05,3.4514E-05,2.2339E-05,8.2140E-07,
     &6.3807E-05,6.4263E-05,5.0034E-05,3.1504E-05,1.0057E-06/
      DATA ((KB(JS,JT,48, 4),JS=1,5),JT=1,5) /
     &5.5161E-06,6.9345E-06,5.9711E-06,4.2630E-06,2.7090E-07,
     &1.0274E-05,1.2067E-05,1.0101E-05,7.0075E-06,3.6468E-07,
     &1.7999E-05,1.9964E-05,1.6291E-05,1.0982E-05,4.7593E-07,
     &2.9748E-05,3.1502E-05,2.5173E-05,1.6424E-05,6.0510E-07,
     &4.6627E-05,4.7519E-05,3.7159E-05,2.3556E-05,7.4697E-07/
      DATA ((KB(JS,JT,49, 4),JS=1,5),JT=1,5) /
     &3.6712E-06,4.7085E-06,4.0821E-06,2.9344E-06,1.8902E-07,
     &6.9808E-06,8.3574E-06,7.0495E-06,4.9158E-06,2.5862E-07,
     &1.2533E-05,1.4129E-05,1.1598E-05,7.8741E-06,3.4164E-07,
     &2.1199E-05,2.2725E-05,1.8253E-05,1.2008E-05,4.3895E-07,
     &3.3893E-05,3.4945E-05,2.7461E-05,1.7529E-05,5.4985E-07/
      DATA ((KB(JS,JT,50, 4),JS=1,5),JT=1,5) /
     &2.4835E-06,3.2299E-06,2.8168E-06,2.0358E-06,1.3342E-07,
     &4.7895E-06,5.8338E-06,4.9516E-06,3.4721E-06,1.8475E-07,
     &8.7933E-06,1.0062E-05,8.3077E-06,5.6722E-06,2.4761E-07,
     &1.5202E-05,1.6503E-05,1.3305E-05,8.8168E-06,3.2240E-07,
     &2.4800E-05,2.5828E-05,2.0397E-05,1.3093E-05,4.0814E-07/
      DATA ((KB(JS,JT,51, 4),JS=1,5),JT=1,5) /
     &1.7011E-06,2.2256E-06,1.9504E-06,1.4154E-06,9.4900E-08,
     &3.2953E-06,4.0790E-06,3.4794E-06,2.4537E-06,1.3273E-07,
     &6.1746E-06,7.1689E-06,5.9544E-06,4.0832E-06,1.8014E-07,
     &1.0912E-05,1.1993E-05,9.7046E-06,6.4754E-06,2.3777E-07,
     &1.8173E-05,1.9097E-05,1.5144E-05,9.7867E-06,3.0334E-07/
      DATA ((KB(JS,JT,52, 4),JS=1,5),JT=1,5) /
     &1.1779E-06,1.5381E-06,1.3497E-06,9.8158E-07,6.6305E-08,
     &2.2623E-06,2.8412E-06,2.4342E-06,1.7266E-06,9.4865E-08,
     &4.3170E-06,5.0854E-06,4.2468E-06,2.9260E-06,1.3026E-07,
     &7.7969E-06,8.6772E-06,7.0531E-06,4.7333E-06,1.7384E-07,
     &1.3261E-05,1.4075E-05,1.1203E-05,7.2837E-06,2.2485E-07/
      DATA ((KB(JS,JT,53, 4),JS=1,5),JT=1,5) /
     &8.3089E-07,1.0687E-06,9.3518E-07,6.7997E-07,4.5831E-08,
     &1.5556E-06,1.9711E-06,1.6966E-06,1.2083E-06,6.7497E-08,
     &3.0048E-06,3.5908E-06,3.0131E-06,2.0844E-06,9.3485E-08,
     &5.5438E-06,6.2468E-06,5.1016E-06,3.4387E-06,1.2594E-07,
     &9.6328E-06,1.0329E-05,8.2446E-06,5.3978E-06,1.6450E-07/
      DATA ((KB(JS,JT,54, 4),JS=1,5),JT=1,5) /
     &6.1034E-07,7.6407E-07,6.6371E-07,4.8016E-07,3.1960E-08,
     &1.0977E-06,1.3930E-06,1.2021E-06,8.5784E-07,4.9012E-08,
     &2.1270E-06,2.5705E-06,2.1637E-06,1.5024E-06,6.8673E-08,
     &3.9965E-06,4.5514E-06,3.7320E-06,2.5226E-06,9.3587E-08,
     &7.0830E-06,7.6654E-06,6.1329E-06,4.0351E-06,1.2382E-07/
      DATA ((KB(JS,JT,55, 4),JS=1,5),JT=1,5) /
     &4.6385E-07,5.5921E-07,4.8019E-07,3.4337E-07,2.2394E-08,
     &7.8989E-07,9.9640E-07,8.5986E-07,6.1313E-07,3.5977E-08,
     &1.5192E-06,1.8516E-06,1.5624E-06,1.0878E-06,5.1500E-08,
     &2.8980E-06,3.3321E-06,2.7426E-06,1.8581E-06,7.0762E-08,
     &5.2356E-06,5.7136E-06,4.5826E-06,3.0253E-06,9.4338E-08/
      DATA ((KB(JS,JT,56, 4),JS=1,5),JT=1,5) /
     &3.6371E-07,4.1822E-07,3.5281E-07,2.4786E-07,1.6072E-08,
     &5.7786E-07,7.1776E-07,6.1684E-07,4.3889E-07,2.6450E-08,
     &1.0893E-06,1.3335E-06,1.1271E-06,7.8636E-07,3.8603E-08,
     &2.1010E-06,2.4368E-06,2.0114E-06,1.3652E-06,5.3303E-08,
     &3.8675E-06,4.2536E-06,3.4205E-06,2.2622E-06,7.1626E-08/
      DATA ((KB(JS,JT,57, 4),JS=1,5),JT=1,5) /
     &2.9431E-07,3.2133E-07,2.6457E-07,1.8146E-07,1.1259E-08,
     &4.3212E-07,5.2280E-07,4.4601E-07,3.1527E-07,1.9122E-08,
     &7.8679E-07,9.6129E-07,8.1340E-07,5.6766E-07,2.8681E-08,
     &1.5240E-06,1.7810E-06,1.4725E-06,1.0013E-06,4.0212E-08,
     &2.8546E-06,3.1617E-06,2.5494E-06,1.6875E-06,5.4480E-08/
      DATA ((KB(JS,JT,58, 4),JS=1,5),JT=1,5) /
     &1.1920E-07,1.4193E-07,1.3380E-07,1.0782E-07,7.9525E-09,
     &1.6186E-07,2.1696E-07,2.1477E-07,1.8165E-07,1.3814E-08,
     &2.8087E-07,3.9076E-07,3.8760E-07,3.2679E-07,2.1394E-08,
     &5.4191E-07,7.3009E-07,7.0916E-07,5.8413E-07,3.0724E-08,
     &1.0299E-06,1.3167E-06,1.2488E-06,1.0008E-06,4.1885E-08/
      DATA ((KB(JS,JT,59, 4),JS=1,5),JT=1,5) /
     &1.0039E-07,1.1714E-07,1.0974E-07,8.7504E-08,6.4674E-09,
     &1.3241E-07,1.7435E-07,1.7189E-07,1.4496E-07,1.1458E-08,
     &2.2493E-07,3.1060E-07,3.0841E-07,2.6052E-07,1.7735E-08,
     &4.3202E-07,5.8172E-07,5.6654E-07,4.6829E-07,2.5818E-08,
     &8.2523E-07,1.0563E-06,1.0053E-06,8.0852E-07,3.5572E-08/
      DATA ((KB(JS,JT,13, 5),JS=1,5),JT=1,5) /
     &3.5348E-02,3.1651E-02,2.3972E-02,1.4520E-02,1.2073E-03,
     &5.4657E-02,4.7880E-02,3.5919E-02,2.1424E-02,1.4997E-03,
     &8.2602E-02,7.1045E-02,5.2562E-02,3.0599E-02,1.8487E-03,
     &1.1970E-01,1.0136E-01,7.4139E-02,4.2733E-02,2.2117E-03,
     &1.6697E-01,1.3996E-01,1.0160E-01,5.7755E-02,2.6210E-03/
      DATA ((KB(JS,JT,14, 5),JS=1,5),JT=1,5) /
     &3.1413E-02,2.7971E-02,2.1089E-02,1.2782E-02,9.9834E-04,
     &4.9001E-02,4.2669E-02,3.1890E-02,1.8901E-02,1.2749E-03,
     &7.3648E-02,6.3169E-02,4.6557E-02,2.7140E-02,1.5545E-03,
     &1.0633E-01,9.0035E-02,6.5788E-02,3.7842E-02,1.8680E-03,
     &1.4847E-01,1.2452E-01,9.0180E-02,5.1123E-02,2.2124E-03/
      DATA ((KB(JS,JT,15, 5),JS=1,5),JT=1,5) /
     &2.6691E-02,2.3767E-02,1.7918E-02,1.0846E-02,8.4376E-04,
     &4.1563E-02,3.6328E-02,2.7130E-02,1.6082E-02,1.0611E-03,
     &6.2559E-02,5.3858E-02,3.9632E-02,2.3133E-02,1.2845E-03,
     &9.0477E-02,7.6844E-02,5.6216E-02,3.2223E-02,1.5617E-03,
     &1.2655E-01,1.0613E-01,7.6652E-02,4.3561E-02,1.9061E-03/
      DATA ((KB(JS,JT,16, 5),JS=1,5),JT=1,5) /
     &2.1986E-02,1.9716E-02,1.4938E-02,9.0172E-03,6.9426E-04,
     &3.4448E-02,3.0201E-02,2.2563E-02,1.3402E-02,8.6528E-04,
     &5.1943E-02,4.4837E-02,3.3116E-02,1.9274E-02,1.0580E-03,
     &7.5192E-02,6.4048E-02,4.6767E-02,2.6829E-02,1.3132E-03,
     &1.0492E-01,8.8109E-02,6.3827E-02,3.6312E-02,1.6006E-03/
      DATA ((KB(JS,JT,17, 5),JS=1,5),JT=1,5) /
     &1.8067E-02,1.6242E-02,1.2317E-02,7.4587E-03,5.8084E-04,
     &2.8443E-02,2.5054E-02,1.8720E-02,1.1098E-02,7.2334E-04,
     &4.2795E-02,3.7062E-02,2.7408E-02,1.5965E-02,9.0099E-04,
     &6.1919E-02,5.2891E-02,3.8653E-02,2.2221E-02,1.1193E-03,
     &8.6219E-02,7.2608E-02,5.2687E-02,2.9957E-02,1.3671E-03/
      DATA ((KB(JS,JT,18, 5),JS=1,5),JT=1,5) /
     &1.4708E-02,1.3327E-02,1.0113E-02,6.1290E-03,4.8316E-04,
     &2.3136E-02,2.0491E-02,1.5341E-02,9.1147E-03,6.0374E-04,
     &3.4747E-02,3.0283E-02,2.2393E-02,1.3077E-02,7.6598E-04,
     &5.0288E-02,4.3057E-02,3.1490E-02,1.8130E-02,9.5069E-04,
     &6.9756E-02,5.9005E-02,4.2850E-02,2.4412E-02,1.1633E-03/
      DATA ((KB(JS,JT,19, 5),JS=1,5),JT=1,5) /
     &1.2271E-02,1.1130E-02,8.4511E-03,5.1168E-03,4.1293E-04,
     &1.9205E-02,1.7036E-02,1.2763E-02,7.5902E-03,5.1993E-04,
     &2.8789E-02,2.5103E-02,1.8579E-02,1.0864E-02,6.5561E-04,
     &4.1470E-02,3.5549E-02,2.6049E-02,1.5006E-02,8.1395E-04,
     &5.7470E-02,4.8743E-02,3.5383E-02,2.0175E-02,9.9598E-04/
      DATA ((KB(JS,JT,20, 5),JS=1,5),JT=1,5) /
     &1.0604E-02,9.5861E-03,7.2655E-03,4.3823E-03,3.5617E-04,
     &1.6495E-02,1.4613E-02,1.0934E-02,6.4798E-03,4.4865E-04,
     &2.4651E-02,2.1430E-02,1.5803E-02,9.2155E-03,5.6360E-04,
     &3.5214E-02,3.0218E-02,2.2119E-02,1.2722E-02,7.0046E-04,
     &4.8685E-02,4.1243E-02,2.9948E-02,1.7048E-02,8.5450E-04/
      DATA ((KB(JS,JT,21, 5),JS=1,5),JT=1,5) /
     &9.2365E-03,8.3349E-03,6.3064E-03,3.7870E-03,3.0556E-04,
     &1.4270E-02,1.2642E-02,9.4383E-03,5.5694E-03,3.8499E-04,
     &2.1188E-02,1.8415E-02,1.3582E-02,7.8888E-03,4.8632E-04,
     &3.0204E-02,2.5895E-02,1.8922E-02,1.0859E-02,6.0144E-04,
     &4.1738E-02,3.5266E-02,2.5553E-02,1.4491E-02,7.3167E-04/
      DATA ((KB(JS,JT,22, 5),JS=1,5),JT=1,5) /
     &8.2084E-03,7.4154E-03,5.5986E-03,3.3447E-03,2.6030E-04,
     &1.2593E-02,1.1132E-02,8.2855E-03,4.8830E-03,3.3150E-04,
     &1.8558E-02,1.6118E-02,1.1879E-02,6.8818E-03,4.1718E-04,
     &2.6423E-02,2.2608E-02,1.6490E-02,9.4242E-03,5.1837E-04,
     &3.6423E-02,3.0712E-02,2.2210E-02,1.2556E-02,6.2757E-04/
      DATA ((KB(JS,JT,23, 5),JS=1,5),JT=1,5) /
     &7.2962E-03,6.5767E-03,4.9576E-03,2.9518E-03,2.2147E-04,
     &1.1116E-02,9.7878E-03,7.2822E-03,4.2736E-03,2.8452E-04,
     &1.6294E-02,1.4142E-02,1.0397E-02,6.0039E-03,3.5768E-04,
     &2.3164E-02,1.9768E-02,1.4383E-02,8.1899E-03,4.4507E-04,
     &3.1815E-02,2.6782E-02,1.9341E-02,1.0913E-02,5.3593E-04/
      DATA ((KB(JS,JT,24, 5),JS=1,5),JT=1,5) /
     &6.5132E-03,5.8530E-03,4.4011E-03,2.6156E-03,1.8866E-04,
     &9.8979E-03,8.6925E-03,6.4521E-03,3.7670E-03,2.4398E-04,
     &1.4458E-02,1.2498E-02,9.1615E-03,5.2667E-03,3.0838E-04,
     &2.0434E-02,1.7400E-02,1.2635E-02,7.1775E-03,3.8038E-04,
     &2.8011E-02,2.3552E-02,1.6988E-02,9.5542E-03,4.5842E-04/
      DATA ((KB(JS,JT,25, 5),JS=1,5),JT=1,5) /
     &5.8496E-03,5.2463E-03,3.9347E-03,2.3271E-03,1.6445E-04,
     &8.8417E-03,7.7604E-03,5.7347E-03,3.3321E-03,2.1081E-04,
     &1.2868E-02,1.1077E-02,8.0978E-03,4.6433E-03,2.6559E-04,
     &1.8100E-02,1.5382E-02,1.1156E-02,6.3115E-03,3.2583E-04,
     &2.4695E-02,2.0722E-02,1.4925E-02,8.3824E-03,3.9105E-04/
      DATA ((KB(JS,JT,26, 5),JS=1,5),JT=1,5) /
     &5.3224E-03,4.7440E-03,3.5455E-03,2.0856E-03,1.4273E-04,
     &7.9880E-03,6.9773E-03,5.1401E-03,2.9750E-03,1.8261E-04,
     &1.1564E-02,9.9215E-03,7.2343E-03,4.1334E-03,2.2903E-04,
     &1.6157E-02,1.3698E-02,9.9057E-03,5.5934E-03,2.7897E-04,
     &2.1895E-02,1.8349E-02,1.3199E-02,7.3992E-03,3.3238E-04/
      DATA ((KB(JS,JT,27, 5),JS=1,5),JT=1,5) /
     &4.8372E-03,4.2909E-03,3.1935E-03,1.8703E-03,1.2222E-04,
     &7.2219E-03,6.2785E-03,4.6150E-03,2.6594E-03,1.5564E-04,
     &1.0384E-02,8.8912E-03,6.4664E-03,3.6778E-03,1.9361E-04,
     &1.4401E-02,1.2183E-02,8.7984E-03,4.9566E-03,2.3445E-04,
     &1.9400E-02,1.6243E-02,1.1670E-02,6.5316E-03,2.7869E-04/
      DATA ((KB(JS,JT,28, 5),JS=1,5),JT=1,5) /
     &4.3907E-03,3.8800E-03,2.8785E-03,1.6793E-03,1.0352E-04,
     &6.5180E-03,5.6500E-03,4.1431E-03,2.3781E-03,1.3090E-04,
     &9.2995E-03,7.9428E-03,5.7641E-03,3.2684E-03,1.6163E-04,
     &1.2806E-02,1.0816E-02,7.7992E-03,4.3863E-03,1.9422E-04,
     &1.7155E-02,1.4361E-02,1.0305E-02,5.7599E-03,2.3020E-04/
      DATA ((KB(JS,JT,29, 5),JS=1,5),JT=1,5) /
     &3.9730E-03,3.5033E-03,2.5903E-03,1.5043E-03,8.6138E-05,
     &5.8501E-03,5.0589E-03,3.6981E-03,2.1165E-03,1.0866E-04,
     &8.2752E-03,7.0540E-03,5.1122E-03,2.8938E-03,1.3206E-04,
     &1.1323E-02,9.5548E-03,6.8809E-03,3.8639E-03,1.5770E-04,
     &1.5087E-02,1.2624E-02,9.0498E-03,5.0491E-03,1.8805E-04/
      DATA ((KB(JS,JT,30, 5),JS=1,5),JT=1,5) /
     &3.5719E-03,3.1399E-03,2.3162E-03,1.3392E-03,7.1373E-05,
     &5.2107E-03,4.4986E-03,3.2816E-03,1.8730E-03,8.8119E-05,
     &7.3165E-03,6.2315E-03,4.5078E-03,2.5469E-03,1.0662E-04,
     &9.9520E-03,8.3892E-03,6.0327E-03,3.3847E-03,1.2803E-04,
     &1.3166E-02,1.1029E-02,7.9003E-03,4.4030E-03,1.5121E-04/
      DATA ((KB(JS,JT,31, 5),JS=1,5),JT=1,5) /
     &3.1788E-03,2.7864E-03,2.0507E-03,1.1825E-03,5.7200E-05,
     &4.5964E-03,3.9617E-03,2.8849E-03,1.6429E-03,7.0401E-05,
     &6.4014E-03,5.4495E-03,3.9350E-03,2.2208E-03,8.5247E-05,
     &8.6375E-03,7.2878E-03,5.2393E-03,2.9385E-03,1.0146E-04,
     &1.1347E-02,9.5229E-03,6.8169E-03,3.7997E-03,1.1891E-04/
      DATA ((KB(JS,JT,32, 5),JS=1,5),JT=1,5) /
     &2.8359E-03,2.4792E-03,1.8198E-03,1.0462E-03,4.5712E-05,
     &4.0627E-03,3.4962E-03,2.5410E-03,1.4431E-03,5.6022E-05,
     &5.6078E-03,4.7711E-03,3.4442E-03,1.9418E-03,6.7267E-05,
     &7.5047E-03,6.3406E-03,4.5581E-03,2.5548E-03,7.9547E-05,
     &9.7792E-03,8.2213E-03,5.8868E-03,3.2848E-03,9.2763E-05/
      DATA ((KB(JS,JT,33, 5),JS=1,5),JT=1,5) /
     &2.5284E-03,2.2057E-03,1.6155E-03,9.2588E-04,3.6267E-05,
     &3.5886E-03,3.0844E-03,2.2382E-03,1.2695E-03,4.4003E-05,
     &4.9097E-03,4.1805E-03,3.0157E-03,1.6993E-03,5.2825E-05,
     &6.5165E-03,5.5167E-03,3.9645E-03,2.2215E-03,6.1889E-05,
     &8.4209E-03,7.0899E-03,5.0775E-03,2.8354E-03,7.2610E-05/
      DATA ((KB(JS,JT,34, 5),JS=1,5),JT=1,5) /
     &2.2520E-03,1.9602E-03,1.4328E-03,8.1868E-04,2.9417E-05,
     &3.1681E-03,2.7215E-03,1.9717E-03,1.1166E-03,3.5490E-05,
     &4.2977E-03,3.6615E-03,2.6403E-03,1.4869E-03,4.1854E-05,
     &5.6597E-03,4.7967E-03,3.4462E-03,1.9298E-03,4.9348E-05,
     &7.2681E-03,6.1253E-03,4.3873E-03,2.4514E-03,5.8186E-05/
      DATA ((KB(JS,JT,35, 5),JS=1,5),JT=1,5) /
     &1.9366E-03,1.6854E-03,1.2304E-03,7.0199E-04,2.3008E-05,
     &2.7102E-03,2.3296E-03,1.6872E-03,9.5490E-04,2.7664E-05,
     &3.6574E-03,3.1206E-03,2.2499E-03,1.2662E-03,3.3089E-05,
     &4.7963E-03,4.0694E-03,2.9228E-03,1.6371E-03,3.9372E-05,
     &6.1352E-03,5.1795E-03,3.7111E-03,2.0740E-03,4.6276E-05/
      DATA ((KB(JS,JT,36, 5),JS=1,5),JT=1,5) /
     &1.6034E-03,1.3976E-03,1.0202E-03,5.8186E-04,1.7663E-05,
     &2.2421E-03,1.9307E-03,1.3983E-03,7.9118E-04,2.1547E-05,
     &3.0206E-03,2.5824E-03,1.8623E-03,1.0484E-03,2.5886E-05,
     &3.9570E-03,3.3630E-03,2.4161E-03,1.3541E-03,3.0872E-05,
     &5.0582E-03,4.2785E-03,3.0668E-03,1.7150E-03,3.6301E-05/
      DATA ((KB(JS,JT,37, 5),JS=1,5),JT=1,5) /
     &1.2748E-03,1.1146E-03,8.1407E-04,4.6450E-04,1.3581E-05,
     &1.7898E-03,1.5447E-03,1.1192E-03,6.3354E-04,1.6729E-05,
     &2.4187E-03,2.0714E-03,1.4947E-03,8.4187E-04,2.0205E-05,
     &3.1762E-03,2.7057E-03,1.9449E-03,1.0902E-03,2.4038E-05,
     &4.0701E-03,3.4504E-03,2.4741E-03,1.3836E-03,2.8365E-05/
      DATA ((KB(JS,JT,38, 5),JS=1,5),JT=1,5) /
     &1.0102E-03,8.8559E-04,6.4741E-04,3.6947E-04,1.0412E-05,
     &1.4249E-03,1.2327E-03,8.9319E-04,5.0584E-04,1.2901E-05,
     &1.9318E-03,1.6579E-03,1.1967E-03,6.7434E-04,1.5672E-05,
     &2.5434E-03,2.1714E-03,1.5616E-03,8.7562E-04,1.8795E-05,
     &3.2683E-03,2.7765E-03,1.9923E-03,1.1142E-03,2.2145E-05/
      DATA ((KB(JS,JT,39, 5),JS=1,5),JT=1,5) /
     &7.9946E-04,7.0298E-04,5.1416E-04,2.9368E-04,7.9720E-06,
     &1.1333E-03,9.8290E-04,7.1255E-04,4.0353E-04,9.9223E-06,
     &1.5418E-03,1.3259E-03,9.5739E-04,5.3970E-04,1.2141E-05,
     &2.0355E-03,1.7418E-03,1.2533E-03,7.0303E-04,1.4591E-05,
     &2.6233E-03,2.2332E-03,1.6027E-03,8.9673E-04,1.7278E-05/
      DATA ((KB(JS,JT,40, 5),JS=1,5),JT=1,5) /
     &6.1558E-04,5.4339E-04,3.9799E-04,2.2761E-04,6.0679E-06,
     &8.8100E-04,7.6638E-04,5.5623E-04,3.1507E-04,7.6104E-06,
     &1.2072E-03,1.0404E-03,7.5136E-04,4.2373E-04,9.3444E-06,
     &1.6029E-03,1.3742E-03,9.8944E-04,5.5501E-04,1.1318E-05,
     &2.0762E-03,1.7710E-03,1.2711E-03,7.1134E-04,1.3497E-05/
      DATA ((KB(JS,JT,41, 5),JS=1,5),JT=1,5) /
     &4.7150E-04,4.1786E-04,3.0641E-04,1.7559E-04,4.6077E-06,
     &6.8147E-04,5.9486E-04,4.3209E-04,2.4498E-04,5.8135E-06,
     &9.4213E-04,8.1372E-04,5.8780E-04,3.3145E-04,7.1715E-06,
     &1.2582E-03,1.0809E-03,7.7844E-04,4.3685E-04,8.7285E-06,
     &1.6388E-03,1.4010E-03,1.0055E-03,5.6266E-04,1.0465E-05/
      DATA ((KB(JS,JT,42, 5),JS=1,5),JT=1,5) /
     &3.6009E-04,3.2039E-04,2.3540E-04,1.3511E-04,3.4818E-06,
     &5.2591E-04,4.6075E-04,3.3505E-04,1.9005E-04,4.4174E-06,
     &7.3377E-04,6.3539E-04,4.5927E-04,2.5904E-04,5.4797E-06,
     &9.8665E-04,8.4900E-04,6.1152E-04,3.4335E-04,6.7219E-06,
     &1.2919E-03,1.1071E-03,7.9454E-04,4.4455E-04,8.0996E-06/
      DATA ((KB(JS,JT,43, 5),JS=1,5),JT=1,5) /
     &2.7068E-04,2.4195E-04,1.7816E-04,1.0249E-04,2.5837E-06,
     &4.0104E-04,3.5254E-04,2.5672E-04,1.4582E-04,3.3146E-06,
     &5.6618E-04,4.9150E-04,3.5538E-04,2.0045E-04,4.1432E-06,
     &7.6835E-04,6.6216E-04,4.7675E-04,2.6781E-04,5.1315E-06,
     &1.0127E-03,8.6923E-04,6.2405E-04,3.4899E-04,6.1983E-06/
      DATA ((KB(JS,JT,44, 5),JS=1,5),JT=1,5) /
     &2.0139E-04,1.8106E-04,1.3358E-04,7.7094E-05,1.8960E-06,
     &3.0345E-04,2.6774E-04,1.9525E-04,1.1112E-04,2.4595E-06,
     &4.3439E-04,3.7822E-04,2.7355E-04,1.5433E-04,3.1158E-06,
     &5.9600E-04,5.1425E-04,3.7025E-04,2.0795E-04,3.8746E-06,
     &7.9184E-04,6.8038E-04,4.8839E-04,2.7303E-04,4.7113E-06/
      DATA ((KB(JS,JT,45, 5),JS=1,5),JT=1,5) /
     &1.4924E-04,1.3479E-04,9.9739E-05,5.7756E-05,1.3827E-06,
     &2.2880E-04,2.0270E-04,1.4808E-04,8.4395E-05,1.8081E-06,
     &3.3229E-04,2.9032E-04,2.1015E-04,1.1857E-04,2.3261E-06,
     &4.6152E-04,3.9893E-04,2.8721E-04,1.6120E-04,2.9080E-06,
     &6.1857E-04,5.3204E-04,3.8190E-04,2.1341E-04,3.5612E-06/
      DATA ((KB(JS,JT,46, 5),JS=1,5),JT=1,5) /
     &1.0906E-04,9.9059E-05,7.3477E-05,4.2734E-05,1.0024E-06,
     &1.7043E-04,1.5165E-04,1.1108E-04,6.3473E-05,1.3227E-06,
     &2.5193E-04,2.2079E-04,1.6005E-04,9.0376E-05,1.7191E-06,
     &3.5457E-04,3.0711E-04,2.2121E-04,1.2412E-04,2.1640E-06,
     &4.8016E-04,4.1350E-04,2.9669E-04,1.6585E-04,2.6681E-06/
      DATA ((KB(JS,JT,47, 5),JS=1,5),JT=1,5) /
     &7.7791E-05,7.1164E-05,5.2966E-05,3.0950E-05,7.1979E-07,
     &1.2436E-04,1.1134E-04,8.1758E-05,4.6856E-05,9.5466E-07,
     &1.8767E-04,1.6518E-04,1.1995E-04,6.7855E-05,1.2553E-06,
     &2.6877E-04,2.3350E-04,1.6823E-04,9.4438E-05,1.6001E-06,
     &3.6855E-04,3.1774E-04,2.2797E-04,1.2742E-04,1.9855E-06/
      DATA ((KB(JS,JT,48, 5),JS=1,5),JT=1,5) /
     &5.5044E-05,5.0693E-05,3.7891E-05,2.2267E-05,5.1420E-07,
     &9.0215E-05,8.1170E-05,5.9770E-05,3.4413E-05,6.9075E-07,
     &1.3907E-04,1.2292E-04,8.9447E-05,5.0716E-05,9.0307E-07,
     &2.0282E-04,1.7688E-04,1.2753E-04,7.1593E-05,1.1665E-06,
     &2.8252E-04,2.4382E-04,1.7492E-04,9.7702E-05,1.4649E-06/
      DATA ((KB(JS,JT,49, 5),JS=1,5),JT=1,5) /
     &3.8587E-05,3.5798E-05,2.6873E-05,1.5895E-05,3.6284E-07,
     &6.4973E-05,5.8784E-05,4.3404E-05,2.5118E-05,4.9340E-07,
     &1.0247E-04,9.0960E-05,6.6355E-05,3.7720E-05,6.5251E-07,
     &1.5241E-04,1.3334E-04,9.6283E-05,5.4131E-05,8.4176E-07,
     &2.1585E-04,1.8661E-04,1.3387E-04,7.4762E-05,1.0688E-06/
      DATA ((KB(JS,JT,50, 5),JS=1,5),JT=1,5) /
     &2.7204E-05,2.5412E-05,1.9146E-05,1.1397E-05,2.5753E-07,
     &4.7009E-05,4.2778E-05,3.1689E-05,1.8416E-05,3.5668E-07,
     &7.5923E-05,6.7680E-05,4.9459E-05,2.8188E-05,4.7630E-07,
     &1.1516E-04,1.0107E-04,7.3089E-05,4.1129E-05,6.1736E-07,
     &1.6568E-04,1.4364E-04,1.0307E-04,5.7556E-05,7.8811E-07/
      DATA ((KB(JS,JT,51, 5),JS=1,5),JT=1,5) /
     &1.9132E-05,1.8022E-05,1.3620E-05,8.1585E-06,1.8251E-07,
     &3.4015E-05,3.1104E-05,2.3112E-05,1.3493E-05,2.5742E-07,
     &5.6251E-05,5.0351E-05,3.6864E-05,2.1082E-05,3.4853E-07,
     &8.7117E-05,7.6686E-05,5.5526E-05,3.1296E-05,4.5614E-07,
     &1.2742E-04,1.1075E-04,7.9490E-05,4.4386E-05,5.8324E-07/
      DATA ((KB(JS,JT,52, 5),JS=1,5),JT=1,5) /
     &1.3343E-05,1.2680E-05,9.6205E-06,5.7937E-06,1.2757E-07,
     &2.4457E-05,2.2489E-05,1.6762E-05,9.8342E-06,1.8427E-07,
     &4.1490E-05,3.7272E-05,2.7347E-05,1.5697E-05,2.5311E-07,
     &6.5698E-05,5.8019E-05,4.2067E-05,2.3741E-05,3.3454E-07,
     &9.7769E-05,8.5199E-05,6.1200E-05,3.4184E-05,4.3074E-07/
      DATA ((KB(JS,JT,53, 5),JS=1,5),JT=1,5) /
     &9.2286E-06,8.8438E-06,6.7394E-06,4.0796E-06,8.7990E-08,
     &1.7462E-05,1.6145E-05,1.2071E-05,7.1204E-06,1.3004E-07,
     &3.0397E-05,2.7436E-05,2.0177E-05,1.1626E-05,1.8173E-07,
     &4.9319E-05,4.3681E-05,3.1722E-05,1.7943E-05,2.4392E-07,
     &7.4848E-05,6.5369E-05,4.7021E-05,2.6269E-05,3.1719E-07/
      DATA ((KB(JS,JT,54, 5),JS=1,5),JT=1,5) /
     &6.4770E-06,6.2515E-06,4.7770E-06,2.9074E-06,6.2611E-08,
     &1.2608E-05,1.1724E-05,8.7837E-06,5.2044E-06,9.4222E-08,
     &2.2532E-05,2.0405E-05,1.5043E-05,8.6950E-06,1.3411E-07,
     &3.7397E-05,3.3212E-05,2.4145E-05,1.3685E-05,1.8245E-07,
     &5.7878E-05,5.0645E-05,3.6444E-05,2.0382E-05,2.3871E-07/
      DATA ((KB(JS,JT,55, 5),JS=1,5),JT=1,5) /
     &4.5852E-06,4.4390E-06,3.4016E-06,2.0767E-06,4.4961E-08,
     &9.1363E-06,8.5468E-06,6.4138E-06,3.8136E-06,6.9204E-08,
     &1.6770E-05,1.5238E-05,1.1251E-05,6.5245E-06,1.0020E-07,
     &2.8475E-05,2.5343E-05,1.8439E-05,1.0474E-05,1.3796E-07,
     &4.4988E-05,3.9423E-05,2.8373E-05,1.5872E-05,1.8258E-07/
      DATA ((KB(JS,JT,56, 5),JS=1,5),JT=1,5) /
     &3.2543E-06,3.1469E-06,2.4158E-06,1.4787E-06,3.1932E-08,
     &6.5989E-06,6.2038E-06,4.6696E-06,2.7831E-06,5.0531E-08,
     &1.2453E-05,1.1352E-05,8.3945E-06,4.8820E-06,7.4538E-08,
     &2.1655E-05,1.9314E-05,1.4065E-05,8.0028E-06,1.0397E-07,
     &3.4950E-05,3.0673E-05,2.2085E-05,1.2363E-05,1.3925E-07/
      DATA ((KB(JS,JT,57, 5),JS=1,5),JT=1,5) /
     &2.3166E-06,2.2390E-06,1.7142E-06,1.0504E-06,2.2682E-08,
     &4.7540E-06,4.4892E-06,3.3846E-06,2.0245E-06,3.6988E-08,
     &9.2246E-06,8.4320E-06,6.2438E-06,3.6425E-06,5.5328E-08,
     &1.6448E-05,1.4704E-05,1.0717E-05,6.1069E-06,7.8210E-08,
     &2.7140E-05,2.3849E-05,1.7182E-05,9.6233E-06,1.0611E-07/
      DATA ((KB(JS,JT,58, 5),JS=1,5),JT=1,5) /
     &8.1594E-07,9.0016E-07,8.0661E-07,5.9543E-07,1.6269E-08,
     &1.6728E-06,1.8193E-06,1.6122E-06,1.1689E-06,2.7161E-08,
     &3.3325E-06,3.5076E-06,3.0497E-06,2.1581E-06,4.1468E-08,
     &6.0908E-06,6.2615E-06,5.3621E-06,3.7018E-06,5.9556E-08,
     &1.0274E-05,1.0375E-05,8.7754E-06,5.9519E-06,8.1351E-08/
      DATA ((KB(JS,JT,59, 5),JS=1,5),JT=1,5) /
     &6.5199E-07,7.1682E-07,6.4285E-07,4.7533E-07,1.3398E-08,
     &1.3361E-06,1.4531E-06,1.2913E-06,9.4099E-07,2.2445E-08,
     &2.6852E-06,2.8341E-06,2.4717E-06,1.7572E-06,3.4660E-08,
     &4.9575E-06,5.1104E-06,4.3915E-06,3.0485E-06,4.9566E-08,
     &8.4320E-06,8.5398E-06,7.2464E-06,4.9418E-06,6.8105E-08/
      DATA ((KB(JS,JT,13, 6),JS=1,5),JT=1,5) /
     &1.5548E-01,1.2226E-01,8.5068E-02,4.5702E-02,2.0740E-03,
     &2.1897E-01,1.7240E-01,1.2003E-01,6.4538E-02,2.5124E-03,
     &3.0095E-01,2.3621E-01,1.6479E-01,8.8859E-02,3.0382E-03,
     &4.0485E-01,3.1719E-01,2.2079E-01,1.1848E-01,3.6959E-03,
     &5.3118E-01,4.1467E-01,2.8796E-01,1.5438E-01,4.3103E-03/
      DATA ((KB(JS,JT,14, 6),JS=1,5),JT=1,5) /
     &1.3732E-01,1.0825E-01,7.5397E-02,4.0495E-02,1.7538E-03,
     &1.9463E-01,1.5344E-01,1.0670E-01,5.7417E-02,2.1725E-03,
     &2.6896E-01,2.1173E-01,1.4739E-01,7.9254E-02,2.6810E-03,
     &3.6294E-01,2.8446E-01,1.9761E-01,1.0591E-01,3.1748E-03,
     &4.7752E-01,3.7323E-01,2.5905E-01,1.3864E-01,3.7684E-03/
      DATA ((KB(JS,JT,15, 6),JS=1,5),JT=1,5) /
     &1.1609E-01,9.1864E-02,6.4056E-02,3.4496E-02,1.4724E-03,
     &1.6575E-01,1.3099E-01,9.1234E-02,4.9161E-02,1.8695E-03,
     &2.2962E-01,1.8109E-01,1.2603E-01,6.7814E-02,2.2935E-03,
     &3.1077E-01,2.4430E-01,1.6934E-01,9.0957E-02,2.7633E-03,
     &4.0968E-01,3.2160E-01,2.2302E-01,1.1925E-01,3.2819E-03/
      DATA ((KB(JS,JT,16, 6),JS=1,5),JT=1,5) /
     &9.6387E-02,7.6493E-02,5.3335E-02,2.8835E-02,1.2273E-03,
     &1.3769E-01,1.0917E-01,7.6074E-02,4.1117E-02,1.5607E-03,
     &1.9131E-01,1.5123E-01,1.0523E-01,5.6738E-02,1.9638E-03,
     &2.5899E-01,2.0399E-01,1.4165E-01,7.6203E-02,2.3618E-03,
     &3.4214E-01,2.6934E-01,1.8675E-01,1.0014E-01,2.8281E-03/
      DATA ((KB(JS,JT,17, 6),JS=1,5),JT=1,5) /
     &7.9271E-02,6.3126E-02,4.4100E-02,2.3917E-02,1.0217E-03,
     &1.1345E-01,9.0182E-02,6.2977E-02,3.4156E-02,1.3299E-03,
     &1.5797E-01,1.2511E-01,8.7087E-02,4.7059E-02,1.6628E-03,
     &2.1402E-01,1.6897E-01,1.1752E-01,6.3332E-02,2.0151E-03,
     &2.8305E-01,2.2332E-01,1.5502E-01,8.3415E-02,2.4638E-03/
      DATA ((KB(JS,JT,18, 6),JS=1,5),JT=1,5) /
     &6.4211E-02,5.1302E-02,3.5902E-02,1.9554E-02,8.7983E-04,
     &9.2120E-02,7.3433E-02,5.1355E-02,2.7890E-02,1.1536E-03,
     &1.2833E-01,1.0186E-01,7.1081E-02,3.8483E-02,1.4378E-03,
     &1.7390E-01,1.3787E-01,9.6012E-02,5.1930E-02,1.7641E-03,
     &2.3011E-01,1.8206E-01,1.2668E-01,6.8404E-02,2.1654E-03/
      DATA ((KB(JS,JT,19, 6),JS=1,5),JT=1,5) /
     &5.2788E-02,4.2299E-02,2.9673E-02,1.6227E-02,7.6310E-04,
     &7.5889E-02,6.0648E-02,4.2457E-02,2.3108E-02,1.0035E-03,
     &1.0575E-01,8.4190E-02,5.8852E-02,3.1993E-02,1.2648E-03,
     &1.4328E-01,1.1394E-01,7.9533E-02,4.3155E-02,1.5714E-03,
     &1.8940E-01,1.5028E-01,1.0488E-01,5.6817E-02,1.9149E-03/
      DATA ((KB(JS,JT,20, 6),JS=1,5),JT=1,5) /
     &4.4520E-02,3.5758E-02,2.5128E-02,1.3753E-02,6.6571E-04,
     &6.4045E-02,5.1271E-02,3.5901E-02,1.9582E-02,8.7391E-04,
     &8.9082E-02,7.1164E-02,4.9821E-02,2.7122E-02,1.1092E-03,
     &1.2061E-01,9.6051E-02,6.7127E-02,3.6518E-02,1.3635E-03,
     &1.5922E-01,1.2658E-01,8.8405E-02,4.7977E-02,1.6664E-03/
      DATA ((KB(JS,JT,21, 6),JS=1,5),JT=1,5) /
     &3.7777E-02,3.0383E-02,2.1331E-02,1.1694E-02,5.7845E-04,
     &5.4331E-02,4.3484E-02,3.0481E-02,1.6684E-02,7.5762E-04,
     &7.5428E-02,6.0294E-02,4.2245E-02,2.3058E-02,9.5396E-04,
     &1.0181E-01,8.1193E-02,5.6844E-02,3.0978E-02,1.1796E-03,
     &1.3419E-01,1.0693E-01,7.4825E-02,4.0693E-02,1.4376E-03/
      DATA ((KB(JS,JT,22, 6),JS=1,5),JT=1,5) /
     &3.2832E-02,2.6387E-02,1.8543E-02,1.0190E-02,5.0764E-04,
     &4.6987E-02,3.7684E-02,2.6458E-02,1.4480E-02,6.6076E-04,
     &6.5046E-02,5.2018E-02,3.6448E-02,1.9932E-02,8.2689E-04,
     &8.7447E-02,6.9814E-02,4.8898E-02,2.6679E-02,1.0180E-03,
     &1.1504E-01,9.1878E-02,6.4286E-02,3.4972E-02,1.2412E-03/
      DATA ((KB(JS,JT,23, 6),JS=1,5),JT=1,5) /
     &2.8625E-02,2.3013E-02,1.6180E-02,8.8954E-03,4.4551E-04,
     &4.0740E-02,3.2715E-02,2.2979E-02,1.2589E-02,5.7081E-04,
     &5.6140E-02,4.4931E-02,3.1539E-02,1.7244E-02,7.1483E-04,
     &7.5282E-02,6.0221E-02,4.2218E-02,2.3054E-02,8.7570E-04,
     &9.9200E-02,7.9197E-02,5.5422E-02,3.0138E-02,1.0690E-03/
      DATA ((KB(JS,JT,24, 6),JS=1,5),JT=1,5) /
     &2.5225E-02,2.0294E-02,1.4276E-02,7.8427E-03,3.8602E-04,
     &3.5712E-02,2.8695E-02,2.0149E-02,1.1049E-02,4.9372E-04,
     &4.9060E-02,3.9310E-02,2.7586E-02,1.5091E-02,6.1539E-04,
     &6.5785E-02,5.2643E-02,3.6889E-02,2.0124E-02,7.5365E-04,
     &8.6520E-02,6.9119E-02,4.8335E-02,2.6295E-02,9.2000E-04/
      DATA ((KB(JS,JT,25, 6),JS=1,5),JT=1,5) /
     &2.2344E-02,1.7976E-02,1.2645E-02,6.9412E-03,3.3195E-04,
     &3.1531E-02,2.5281E-02,1.7784E-02,9.7415E-03,4.2393E-04,
     &4.3153E-02,3.4621E-02,2.4312E-02,1.3288E-02,5.2565E-04,
     &5.7875E-02,4.6285E-02,3.2426E-02,1.7676E-02,6.4832E-04,
     &7.6134E-02,6.0793E-02,4.2524E-02,2.3109E-02,7.8380E-04/
      DATA ((KB(JS,JT,26, 6),JS=1,5),JT=1,5) /
     &1.9994E-02,1.6102E-02,1.1323E-02,6.2216E-03,2.8629E-04,
     &2.8079E-02,2.2581E-02,1.5869E-02,8.6875E-03,3.6314E-04,
     &3.8417E-02,3.0834E-02,2.1637E-02,1.1805E-02,4.5229E-04,
     &5.1448E-02,4.1174E-02,2.8844E-02,1.5712E-02,5.5890E-04,
     &6.7708E-02,5.4151E-02,3.7876E-02,2.0559E-02,6.6983E-04/
      DATA ((KB(JS,JT,27, 6),JS=1,5),JT=1,5) /
     &1.7896E-02,1.4429E-02,1.0152E-02,5.5772E-03,2.4427E-04,
     &2.5042E-02,2.0157E-02,1.4173E-02,7.7571E-03,3.0979E-04,
     &3.4208E-02,2.7475E-02,1.9284E-02,1.0527E-02,3.8671E-04,
     &4.5837E-02,3.6717E-02,2.5729E-02,1.4005E-02,4.7399E-04,
     &6.0284E-02,4.8205E-02,3.3722E-02,1.8275E-02,5.6657E-04/
      DATA ((KB(JS,JT,28, 6),JS=1,5),JT=1,5) /
     &1.6009E-02,1.2912E-02,9.0950E-03,4.9907E-03,2.0749E-04,
     &2.2344E-02,1.7993E-02,1.2646E-02,6.9273E-03,2.6196E-04,
     &3.0516E-02,2.4521E-02,1.7216E-02,9.3897E-03,3.2594E-04,
     &4.0856E-02,3.2755E-02,2.2958E-02,1.2475E-02,3.9748E-04,
     &5.3627E-02,4.2900E-02,3.0014E-02,1.6247E-02,4.7387E-04/
      DATA ((KB(JS,JT,29, 6),JS=1,5),JT=1,5) /
     &1.4262E-02,1.1522E-02,8.1115E-03,4.4530E-03,1.7407E-04,
     &1.9887E-02,1.6027E-02,1.1276E-02,6.1687E-03,2.1854E-04,
     &2.7141E-02,2.1827E-02,1.5323E-02,8.3518E-03,2.7116E-04,
     &3.6246E-02,2.9092E-02,2.0386E-02,1.1064E-02,3.2874E-04,
     &4.7427E-02,3.8019E-02,2.6585E-02,1.4385E-02,3.8972E-04/
      DATA ((KB(JS,JT,30, 6),JS=1,5),JT=1,5) /
     &1.2676E-02,1.0246E-02,7.2173E-03,3.9637E-03,1.4416E-04,
     &1.7653E-02,1.4244E-02,1.0017E-02,5.4770E-03,1.8113E-04,
     &2.4022E-02,1.9341E-02,1.3583E-02,7.3998E-03,2.2282E-04,
     &3.1996E-02,2.5721E-02,1.8027E-02,9.7785E-03,2.6784E-04,
     &4.1773E-02,3.3512E-02,2.3450E-02,1.2688E-02,3.1737E-04/
      DATA ((KB(JS,JT,31, 6),JS=1,5),JT=1,5) /
     &1.1178E-02,9.0514E-03,6.3801E-03,3.5048E-03,1.1770E-04,
     &1.5523E-02,1.2547E-02,8.8303E-03,4.8276E-03,1.4724E-04,
     &2.1060E-02,1.6992E-02,1.1943E-02,6.5025E-03,1.7875E-04,
     &2.7976E-02,2.2531E-02,1.5799E-02,8.5667E-03,2.1450E-04,
     &3.6405E-02,2.9271E-02,2.0490E-02,1.1088E-02,2.5503E-04/
      DATA ((KB(JS,JT,32, 6),JS=1,5),JT=1,5) /
     &9.9013E-03,8.0343E-03,5.6674E-03,3.1129E-03,9.6361E-05,
     &1.3706E-02,1.1101E-02,7.8125E-03,4.2746E-03,1.1902E-04,
     &1.8546E-02,1.4995E-02,1.0536E-02,5.7328E-03,1.4373E-04,
     &2.4550E-02,1.9811E-02,1.3886E-02,7.5313E-03,1.7332E-04,
     &3.1853E-02,2.5667E-02,1.7969E-02,9.7246E-03,2.0625E-04/
      DATA ((KB(JS,JT,33, 6),JS=1,5),JT=1,5) /
     &8.7980E-03,7.1519E-03,5.0451E-03,2.7712E-03,7.8202E-05,
     &1.2135E-02,9.8435E-03,6.9325E-03,3.7902E-03,9.6250E-05,
     &1.6367E-02,1.3251E-02,9.3075E-03,5.0637E-03,1.1723E-04,
     &2.1594E-02,1.7451E-02,1.2238E-02,6.6390E-03,1.4129E-04,
     &2.7922E-02,2.2553E-02,1.5798E-02,8.5480E-03,1.6598E-04/
      DATA ((KB(JS,JT,34, 6),JS=1,5),JT=1,5) /
     &7.8297E-03,6.3727E-03,4.4952E-03,2.4671E-03,6.3879E-05,
     &1.0770E-02,8.7510E-03,6.1616E-03,3.3644E-03,7.9137E-05,
     &1.4484E-02,1.1741E-02,8.2482E-03,4.4844E-03,9.6600E-05,
     &1.9050E-02,1.5427E-02,1.0820E-02,5.8678E-03,1.1495E-04,
     &2.4524E-02,1.9867E-02,1.3919E-02,7.5292E-03,1.3453E-04/
      DATA ((KB(JS,JT,35, 6),JS=1,5),JT=1,5) /
     &6.7630E-03,5.5126E-03,3.8884E-03,2.1340E-03,5.1721E-05,
     &9.2985E-03,7.5662E-03,5.3252E-03,2.9070E-03,6.4032E-05,
     &1.2489E-02,1.0141E-02,7.1246E-03,3.8749E-03,7.6974E-05,
     &1.6400E-02,1.3312E-02,9.3389E-03,5.0659E-03,9.1148E-05,
     &2.1049E-02,1.7098E-02,1.1985E-02,6.4857E-03,1.0683E-04/
      DATA ((KB(JS,JT,36, 6),JS=1,5),JT=1,5) /
     &5.6496E-03,4.6119E-03,3.2530E-03,1.7852E-03,4.0312E-05,
     &7.7767E-03,6.3372E-03,4.4630E-03,2.4380E-03,4.9929E-05,
     &1.0461E-02,8.5144E-03,5.9836E-03,3.2549E-03,6.0118E-05,
     &1.3740E-02,1.1182E-02,7.8492E-03,4.2598E-03,7.1064E-05,
     &1.7612E-02,1.4350E-02,1.0064E-02,5.4485E-03,8.3577E-05/
      DATA ((KB(JS,JT,37, 6),JS=1,5),JT=1,5) /
     &4.5423E-03,3.7134E-03,2.6216E-03,1.4392E-03,3.1256E-05,
     &6.2879E-03,5.1321E-03,3.6149E-03,1.9739E-03,3.8734E-05,
     &8.4900E-03,6.9227E-03,4.8667E-03,2.6482E-03,4.6682E-05,
     &1.1183E-02,9.1172E-03,6.4017E-03,3.4761E-03,5.5592E-05,
     &1.4352E-02,1.1719E-02,8.2209E-03,4.4549E-03,6.5503E-05/
      DATA ((KB(JS,JT,38, 6),JS=1,5),JT=1,5) /
     &3.6392E-03,2.9801E-03,2.1050E-03,1.1562E-03,2.4090E-05,
     &5.0658E-03,4.1416E-03,2.9194E-03,1.5946E-03,2.9868E-05,
     &6.8711E-03,5.6107E-03,3.9454E-03,2.1481E-03,3.6072E-05,
     &9.0731E-03,7.4127E-03,5.2066E-03,2.8281E-03,4.3140E-05,
     &1.1663E-02,9.5418E-03,6.6954E-03,3.6310E-03,5.1139E-05/
      DATA ((KB(JS,JT,39, 6),JS=1,5),JT=1,5) /
     &2.9118E-03,2.3886E-03,1.6882E-03,9.2755E-04,1.8391E-05,
     &4.0750E-03,3.3381E-03,2.3540E-03,1.2863E-03,2.2806E-05,
     &5.5513E-03,4.5420E-03,3.1948E-03,1.7397E-03,2.7682E-05,
     &7.3492E-03,6.0179E-03,4.2285E-03,2.2979E-03,3.3352E-05,
     &9.4667E-03,7.7616E-03,5.4485E-03,2.9560E-03,3.9651E-05/
      DATA ((KB(JS,JT,40, 6),JS=1,5),JT=1,5) /
     &2.2712E-03,1.8658E-03,1.3192E-03,7.2479E-04,1.3995E-05,
     &3.2040E-03,2.6288E-03,1.8549E-03,1.0140E-03,1.7455E-05,
     &4.3985E-03,3.6050E-03,2.5372E-03,1.3813E-03,2.1295E-05,
     &5.8565E-03,4.8013E-03,3.3753E-03,1.8342E-03,2.5756E-05,
     &7.5776E-03,6.2219E-03,4.3685E-03,2.3699E-03,3.0715E-05/
      DATA ((KB(JS,JT,41, 6),JS=1,5),JT=1,5) /
     &1.7612E-03,1.4492E-03,1.0250E-03,5.6325E-04,1.0604E-05,
     &2.5080E-03,2.0608E-03,1.4546E-03,7.9552E-04,1.3310E-05,
     &3.4681E-03,2.8477E-03,2.0051E-03,1.0923E-03,1.6349E-05,
     &4.6501E-03,3.8188E-03,2.6845E-03,1.4588E-03,1.9855E-05,
     &6.0491E-03,4.9741E-03,3.4944E-03,1.8953E-03,2.3793E-05/
      DATA ((KB(JS,JT,42, 6),JS=1,5),JT=1,5) /
     &1.3619E-03,1.1225E-03,7.9390E-04,4.3654E-04,7.9892E-06,
     &1.9585E-03,1.6109E-03,1.1375E-03,6.2244E-04,1.0111E-05,
     &2.7289E-03,2.2437E-03,1.5805E-03,8.6127E-04,1.2500E-05,
     &3.6852E-03,3.0311E-03,2.1316E-03,1.1583E-03,1.5248E-05,
     &4.8235E-03,3.9702E-03,2.7892E-03,1.5134E-03,1.8350E-05/
      DATA ((KB(JS,JT,43, 6),JS=1,5),JT=1,5) /
     &1.0392E-03,8.5695E-04,6.0598E-04,3.3332E-04,5.9552E-06,
     &1.5101E-03,1.2436E-03,8.7832E-04,4.8071E-04,7.5961E-06,
     &2.1254E-03,1.7498E-03,1.2325E-03,6.7181E-04,9.4477E-06,
     &2.8974E-03,2.3860E-03,1.6788E-03,9.1195E-04,1.1585E-05,
     &3.8244E-03,3.1517E-03,2.2140E-03,1.2005E-03,1.4013E-05/
      DATA ((KB(JS,JT,44, 6),JS=1,5),JT=1,5) /
     &7.8683E-04,6.4875E-04,4.5878E-04,2.5223E-04,4.3968E-06,
     &1.1559E-03,9.5305E-04,6.7277E-04,3.6830E-04,5.6394E-06,
     &1.6454E-03,1.3558E-03,9.5534E-04,5.2055E-04,7.0859E-06,
     &2.2669E-03,1.8686E-03,1.3148E-03,7.1399E-04,8.7462E-06,
     &3.0201E-03,2.4917E-03,1.7509E-03,9.4904E-04,1.0639E-05/
      DATA ((KB(JS,JT,45, 6),JS=1,5),JT=1,5) /
     &5.9365E-04,4.8959E-04,3.4607E-04,1.9020E-04,3.2229E-06,
     &8.8218E-04,7.2803E-04,5.1390E-04,2.8115E-04,4.1709E-06,
     &1.2705E-03,1.0482E-03,7.3838E-04,4.0225E-04,5.2818E-06,
     &1.7692E-03,1.4597E-03,1.0269E-03,5.5768E-04,6.5567E-06,
     &2.3806E-03,1.9657E-03,1.3812E-03,7.4841E-04,8.0347E-06/
      DATA ((KB(JS,JT,46, 6),JS=1,5),JT=1,5) /
     &4.4335E-04,3.6560E-04,2.5820E-04,1.4186E-04,2.3394E-06,
     &6.6652E-04,5.5048E-04,3.8857E-04,2.1254E-04,3.0543E-06,
     &9.7139E-04,8.0233E-04,5.6521E-04,3.0796E-04,3.9016E-06,
     &1.3697E-03,1.1313E-03,7.9539E-04,4.3177E-04,4.8930E-06,
     &1.8630E-03,1.5401E-03,1.0822E-03,5.8603E-04,6.0211E-06/
      DATA ((KB(JS,JT,47, 6),JS=1,5),JT=1,5) /
     &3.2494E-04,2.6781E-04,1.8906E-04,1.0379E-04,1.6703E-06,
     &4.9477E-04,4.0876E-04,2.8822E-04,1.5780E-04,2.2235E-06,
     &7.3190E-04,6.0441E-04,4.2581E-04,2.3196E-04,2.8600E-06,
     &1.0450E-03,8.6362E-04,6.0711E-04,3.2954E-04,3.6203E-06,
     &1.4403E-03,1.1920E-03,8.3715E-04,4.5311E-04,4.4864E-06/
      DATA ((KB(JS,JT,48, 6),JS=1,5),JT=1,5) /
     &2.3680E-04,1.9527E-04,1.3764E-04,7.5497E-05,1.1789E-06,
     &3.6634E-04,3.0233E-04,2.1313E-04,1.1661E-04,1.5963E-06,
     &5.4895E-04,4.5372E-04,3.1944E-04,1.7402E-04,2.0888E-06,
     &7.9543E-04,6.5717E-04,4.6181E-04,2.5062E-04,2.6621E-06,
     &1.1099E-03,9.1890E-04,6.4520E-04,3.4917E-04,3.3226E-06/
      DATA ((KB(JS,JT,49, 6),JS=1,5),JT=1,5) /
     &1.7167E-04,1.4156E-04,9.9697E-05,5.4621E-05,8.2177E-07,
     &2.6978E-04,2.2270E-04,1.5688E-04,8.5772E-05,1.1335E-06,
     &4.1033E-04,3.3911E-04,2.3859E-04,1.2993E-04,1.5022E-06,
     &6.0289E-04,4.9870E-04,3.5040E-04,1.9001E-04,1.9421E-06,
     &8.5268E-04,7.0612E-04,4.9559E-04,2.6808E-04,2.4464E-06/
      DATA ((KB(JS,JT,50, 6),JS=1,5),JT=1,5) /
     &1.2531E-04,1.0333E-04,7.2754E-05,3.9781E-05,5.8260E-07,
     &2.0028E-04,1.6520E-04,1.1625E-04,6.3517E-05,8.1312E-07,
     &3.0881E-04,2.5524E-04,1.7955E-04,9.7765E-05,1.0963E-06,
     &4.6015E-04,3.8061E-04,2.6731E-04,1.4488E-04,1.4340E-06,
     &6.5988E-04,5.4636E-04,3.8320E-04,2.0709E-04,1.8202E-06/
      DATA ((KB(JS,JT,51, 6),JS=1,5),JT=1,5) /
     &9.1633E-05,7.5509E-05,5.3128E-05,2.9020E-05,4.1464E-07,
     &1.4891E-04,1.2270E-04,8.6279E-05,4.7099E-05,5.8807E-07,
     &2.3292E-04,1.9249E-04,1.3529E-04,7.3646E-05,8.0371E-07,
     &3.5233E-04,2.9123E-04,2.0433E-04,1.1072E-04,1.0615E-06,
     &5.1166E-04,4.2368E-04,2.9697E-04,1.6038E-04,1.3623E-06/
      DATA ((KB(JS,JT,52, 6),JS=1,5),JT=1,5) /
     &6.6748E-05,5.4951E-05,3.8637E-05,2.1072E-05,2.9423E-07,
     &1.1034E-04,9.0898E-05,6.3804E-05,3.4773E-05,4.2185E-07,
     &1.7525E-04,1.4472E-04,1.0161E-04,5.5277E-05,5.8386E-07,
     &2.6896E-04,2.2246E-04,1.5598E-04,8.4497E-05,7.8029E-07,
     &3.9638E-04,3.2814E-04,2.2978E-04,1.2397E-04,1.0114E-06/
      DATA ((KB(JS,JT,53, 6),JS=1,5),JT=1,5) /
     &4.8387E-05,3.9789E-05,2.7956E-05,1.5224E-05,2.0710E-07,
     &8.1422E-05,6.7055E-05,4.7034E-05,2.5569E-05,3.0032E-07,
     &1.3143E-04,1.0846E-04,7.6092E-05,4.1325E-05,4.2132E-07,
     &2.0478E-04,1.6937E-04,1.1872E-04,6.4236E-05,5.6954E-07,
     &3.0662E-04,2.5374E-04,1.7755E-04,9.5705E-05,7.4673E-07/
      DATA ((KB(JS,JT,54, 6),JS=1,5),JT=1,5) /
     &3.5548E-05,2.9201E-05,2.0499E-05,1.1142E-05,1.4888E-07,
     &6.0867E-05,5.0080E-05,3.5102E-05,1.9053E-05,2.1957E-07,
     &9.9905E-05,8.2294E-05,5.7679E-05,3.1278E-05,3.1167E-07,
     &1.5784E-04,1.3048E-04,9.1376E-05,4.9396E-05,4.2569E-07,
     &2.3990E-04,1.9844E-04,1.3879E-04,7.4726E-05,5.6432E-07/
      DATA ((KB(JS,JT,55, 6),JS=1,5),JT=1,5) /
     &2.6254E-05,2.1551E-05,1.5109E-05,8.2013E-06,1.0776E-07,
     &4.5756E-05,3.7594E-05,2.6330E-05,1.4266E-05,1.6227E-07,
     &7.6387E-05,6.2840E-05,4.3983E-05,2.3813E-05,2.3322E-07,
     &1.2233E-04,1.0105E-04,7.0729E-05,3.8184E-05,3.2242E-07,
     &1.8866E-04,1.5604E-04,1.0907E-04,5.8660E-05,4.3190E-07/
      DATA ((KB(JS,JT,56, 6),JS=1,5),JT=1,5) /
     &1.9352E-05,1.5886E-05,1.1124E-05,6.0284E-06,7.7832E-08,
     &3.4378E-05,2.8197E-05,1.9721E-05,1.0667E-05,1.1948E-07,
     &5.8349E-05,4.7950E-05,3.3520E-05,1.8111E-05,1.7363E-07,
     &9.4866E-05,7.8290E-05,5.4723E-05,2.9510E-05,2.4385E-07,
     &1.4839E-04,1.2273E-04,8.5680E-05,4.6045E-05,3.3022E-07/
      DATA ((KB(JS,JT,57, 6),JS=1,5),JT=1,5) /
     &1.4255E-05,1.1680E-05,8.1776E-06,4.4235E-06,5.5927E-08,
     &2.5815E-05,2.1132E-05,1.4763E-05,7.9663E-06,8.7522E-08,
     &4.4552E-05,3.6579E-05,2.5531E-05,1.3761E-05,1.2925E-07,
     &7.3589E-05,6.0640E-05,4.2341E-05,2.2797E-05,1.8364E-07,
     &1.1687E-04,9.6565E-05,6.7349E-05,3.6145E-05,2.5190E-07/
      DATA ((KB(JS,JT,58, 6),JS=1,5),JT=1,5) /
     &5.1283E-06,4.8164E-06,3.9533E-06,2.5844E-06,4.0411E-08,
     &9.4663E-06,8.8829E-06,7.2756E-06,4.7397E-06,6.4616E-08,
     &1.6608E-05,1.5628E-05,1.2791E-05,8.3232E-06,9.6916E-08,
     &2.7869E-05,2.6331E-05,2.1549E-05,1.4010E-05,1.3884E-07,
     &4.4916E-05,4.2582E-05,3.4830E-05,2.2586E-05,1.9305E-07/
      DATA ((KB(JS,JT,59, 6),JS=1,5),JT=1,5) /
     &4.1166E-06,3.8763E-06,3.1932E-06,2.0984E-06,3.3138E-08,
     &7.6679E-06,7.2183E-06,5.9356E-06,3.8849E-06,5.3542E-08,
     &1.3578E-05,1.2809E-05,1.0527E-05,6.8844E-06,8.1037E-08,
     &2.2972E-05,2.1775E-05,1.7891E-05,1.1690E-05,1.1735E-07,
     &3.7296E-05,3.5490E-05,2.9150E-05,1.9007E-05,1.6270E-07/
      DATA ((KB(JS,JT,13, 7),JS=1,5),JT=1,5) /
     &4.2167E-01,3.2553E-01,2.2695E-01,1.2184E-01,4.0030E-03,
     &6.0140E-01,4.6380E-01,3.2184E-01,1.7190E-01,5.1104E-03,
     &8.1816E-01,6.3015E-01,4.3650E-01,2.3296E-01,6.4365E-03,
     &1.0780E+00,8.2908E-01,5.7271E-01,3.0519E-01,7.8514E-03,
     &1.3871E+00,1.0650E+00,7.3566E-01,3.9202E-01,9.6931E-03/
      DATA ((KB(JS,JT,14, 7),JS=1,5),JT=1,5) /
     &3.8425E-01,2.9801E-01,2.0688E-01,1.1055E-01,3.4668E-03,
     &5.4386E-01,4.2093E-01,2.9177E-01,1.5544E-01,4.5429E-03,
     &7.3998E-01,5.7137E-01,3.9497E-01,2.0995E-01,5.6171E-03,
     &9.7642E-01,7.5246E-01,5.1952E-01,2.7577E-01,6.9867E-03,
     &1.2610E+00,9.7017E-01,6.6888E-01,3.5427E-01,8.6535E-03/
      DATA ((KB(JS,JT,15, 7),JS=1,5),JT=1,5) /
     &3.3299E-01,2.5933E-01,1.7991E-01,9.5905E-02,2.9886E-03,
     &4.6962E-01,3.6448E-01,2.5234E-01,1.3421E-01,3.8718E-03,
     &6.3987E-01,4.9512E-01,3.4211E-01,1.8150E-01,4.8805E-03,
     &8.4586E-01,6.5388E-01,4.5155E-01,2.3908E-01,6.1279E-03,
     &1.0948E+00,8.4428E-01,5.8246E-01,3.0839E-01,7.4849E-03/
      DATA ((KB(JS,JT,16, 7),JS=1,5),JT=1,5) /
     &2.8051E-01,2.1899E-01,1.5183E-01,8.0896E-02,2.5509E-03,
     &3.9506E-01,3.0781E-01,2.1302E-01,1.1324E-01,3.3108E-03,
     &5.3870E-01,4.1855E-01,2.8938E-01,1.5357E-01,4.2013E-03,
     &7.1526E-01,5.5449E-01,3.8283E-01,2.0269E-01,5.1902E-03,
     &9.2727E-01,7.1785E-01,4.9548E-01,2.6200E-01,6.4068E-03/
      DATA ((KB(JS,JT,17, 7),JS=1,5),JT=1,5) /
     &2.3378E-01,1.8318E-01,1.2698E-01,6.7717E-02,2.1927E-03,
     &3.2948E-01,2.5742E-01,1.7822E-01,9.4896E-02,2.8584E-03,
     &4.5000E-01,3.5080E-01,2.4241E-01,1.2872E-01,3.6126E-03,
     &5.9887E-01,4.6579E-01,3.2151E-01,1.7042E-01,4.5208E-03,
     &7.7711E-01,6.0357E-01,4.1660E-01,2.2035E-01,5.5539E-03/
      DATA ((KB(JS,JT,18, 7),JS=1,5),JT=1,5) /
     &1.9227E-01,1.5110E-01,1.0483E-01,5.6032E-02,1.9220E-03,
     &2.7135E-01,2.1238E-01,1.4707E-01,7.8382E-02,2.4923E-03,
     &3.7049E-01,2.8960E-01,2.0022E-01,1.0642E-01,3.1976E-03,
     &4.9231E-01,3.8398E-01,2.6515E-01,1.4069E-01,3.9529E-03,
     &6.4035E-01,4.9892E-01,3.4418E-01,1.8220E-01,4.8074E-03/
      DATA ((KB(JS,JT,19, 7),JS=1,5),JT=1,5) /
     &1.6097E-01,1.2681E-01,8.7983E-02,4.7067E-02,1.6998E-03,
     &2.2674E-01,1.7812E-01,1.2337E-01,6.5758E-02,2.2148E-03,
     &3.0942E-01,2.4239E-01,1.6768E-01,8.9247E-02,2.8171E-03,
     &4.1121E-01,3.2156E-01,2.2226E-01,1.1805E-01,3.4852E-03,
     &5.3661E-01,4.1891E-01,2.8897E-01,1.5308E-01,4.2703E-03/
      DATA ((KB(JS,JT,20, 7),JS=1,5),JT=1,5) /
     &1.3816E-01,1.0899E-01,7.5568E-02,4.0384E-02,1.5084E-03,
     &1.9390E-01,1.5237E-01,1.0558E-01,5.6347E-02,1.9533E-03,
     &2.6431E-01,2.0734E-01,1.4349E-01,7.6381E-02,2.4829E-03,
     &3.5230E-01,2.7579E-01,1.9049E-01,1.0107E-01,3.1175E-03,
     &4.5959E-01,3.5917E-01,2.4774E-01,1.3132E-01,3.8257E-03/
      DATA ((KB(JS,JT,21, 7),JS=1,5),JT=1,5) /
     &1.1885E-01,9.3725E-02,6.5041E-02,3.4803E-02,1.3411E-03,
     &1.6635E-01,1.3102E-01,9.0813E-02,4.8481E-02,1.7301E-03,
     &2.2707E-01,1.7845E-01,1.2348E-01,6.5731E-02,2.2027E-03,
     &3.0299E-01,2.3748E-01,1.6403E-01,8.7154E-02,2.7646E-03,
     &3.9491E-01,3.0909E-01,2.1323E-01,1.1320E-01,3.3663E-03/
      DATA ((KB(JS,JT,22, 7),JS=1,5),JT=1,5) /
     &1.0371E-01,8.1936E-02,5.6886E-02,3.0452E-02,1.1973E-03,
     &1.4515E-01,1.1443E-01,7.9345E-02,4.2377E-02,1.5408E-03,
     &1.9815E-01,1.5584E-01,1.0788E-01,5.7461E-02,1.9609E-03,
     &2.6352E-01,2.0697E-01,1.4313E-01,7.6128E-02,2.4333E-03,
     &3.4221E-01,2.6821E-01,1.8537E-01,9.8647E-02,2.9393E-03/
      DATA ((KB(JS,JT,23, 7),JS=1,5),JT=1,5) /
     &9.0639E-02,7.1734E-02,4.9824E-02,2.6695E-02,1.0611E-03,
     &1.2684E-01,1.0014E-01,6.9426E-02,3.7107E-02,1.3714E-03,
     &1.7268E-01,1.3597E-01,9.4123E-02,5.0237E-02,1.7212E-03,
     &2.2866E-01,1.7972E-01,1.2432E-01,6.6277E-02,2.1161E-03,
     &2.9584E-01,2.3227E-01,1.6067E-01,8.5547E-02,2.5346E-03/
      DATA ((KB(JS,JT,24, 7),JS=1,5),JT=1,5) /
     &8.0071E-02,6.3444E-02,4.4064E-02,2.3644E-02,9.3348E-04,
     &1.1181E-01,8.8354E-02,6.1271E-02,3.2794E-02,1.1882E-03,
     &1.5149E-01,1.1939E-01,8.2725E-02,4.4223E-02,1.4832E-03,
     &1.9978E-01,1.5722E-01,1.0888E-01,5.8128E-02,1.8190E-03,
     &2.5770E-01,2.0260E-01,1.4030E-01,7.4844E-02,2.1747E-03/
      DATA ((KB(JS,JT,25, 7),JS=1,5),JT=1,5) /
     &7.0951E-02,5.6269E-02,3.9108E-02,2.1016E-02,8.0964E-04,
     &9.8623E-02,7.8013E-02,5.4088E-02,2.9015E-02,1.0247E-03,
     &1.3295E-01,1.0488E-01,7.2709E-02,3.8919E-02,1.2776E-03,
     &1.7470E-01,1.3764E-01,9.5373E-02,5.0958E-02,1.5592E-03,
     &2.2493E-01,1.7708E-01,1.2270E-01,6.5502E-02,1.8657E-03/
      DATA ((KB(JS,JT,26, 7),JS=1,5),JT=1,5) /
     &6.3451E-02,5.0352E-02,3.4999E-02,1.8811E-02,7.0696E-04,
     &8.7646E-02,6.9321E-02,4.8128E-02,2.5820E-02,8.9108E-04,
     &1.1756E-01,9.2804E-02,6.4336E-02,3.4465E-02,1.1063E-03,
     &1.5401E-01,1.2150E-01,8.4218E-02,4.5022E-02,1.3420E-03,
     &1.9847E-01,1.5626E-01,1.0822E-01,5.7833E-02,1.6057E-03/
      DATA ((KB(JS,JT,27, 7),JS=1,5),JT=1,5) /
     &5.6793E-02,4.5057E-02,3.1339E-02,1.6842E-02,6.0571E-04,
     &7.8027E-02,6.1732E-02,4.2853E-02,2.2968E-02,7.6180E-04,
     &1.0421E-01,8.2314E-02,5.7109E-02,3.0579E-02,9.4573E-04,
     &1.3651E-01,1.0769E-01,7.4645E-02,3.9915E-02,1.1425E-03,
     &1.7591E-01,1.3862E-01,9.6018E-02,5.1325E-02,1.3608E-03/
      DATA ((KB(JS,JT,28, 7),JS=1,5),JT=1,5) /
     &5.0832E-02,4.0335E-02,2.8062E-02,1.5080E-02,5.0959E-04,
     &6.9491E-02,5.4973E-02,3.8187E-02,2.0466E-02,6.4488E-04,
     &9.2684E-02,7.3230E-02,5.0823E-02,2.7216E-02,7.9606E-04,
     &1.2155E-01,9.5886E-02,6.6455E-02,3.5548E-02,9.5678E-04,
     &1.5688E-01,1.2363E-01,8.5583E-02,4.5732E-02,1.1415E-03/
      DATA ((KB(JS,JT,29, 7),JS=1,5),JT=1,5) /
     &4.5296E-02,3.5922E-02,2.4992E-02,1.3423E-02,4.2743E-04,
     &6.1694E-02,4.8833E-02,3.3922E-02,1.8191E-02,5.3907E-04,
     &8.2276E-02,6.5053E-02,4.5148E-02,2.4171E-02,6.5935E-04,
     &1.0791E-01,8.5197E-02,5.9066E-02,3.1598E-02,7.9358E-04,
     &1.3964E-01,1.1005E-01,7.6235E-02,4.0713E-02,9.4519E-04/
      DATA ((KB(JS,JT,30, 7),JS=1,5),JT=1,5) /
     &4.0185E-02,3.1886E-02,2.2195E-02,1.1919E-02,3.5485E-04,
     &5.4626E-02,4.3278E-02,3.0084E-02,1.6135E-02,4.4303E-04,
     &7.2953E-02,5.7701E-02,4.0048E-02,2.1442E-02,5.4169E-04,
     &9.5812E-02,7.5701E-02,5.2497E-02,2.8075E-02,6.5509E-04,
     &1.2402E-01,9.7862E-02,6.7806E-02,3.6235E-02,7.7850E-04/
      DATA ((KB(JS,JT,31, 7),JS=1,5),JT=1,5) /
     &3.5348E-02,2.8090E-02,1.9559E-02,1.0513E-02,2.9039E-04,
     &4.8053E-02,3.8118E-02,2.6496E-02,1.4221E-02,3.5964E-04,
     &6.4212E-02,5.0845E-02,3.5309E-02,1.8919E-02,4.4117E-04,
     &8.4429E-02,6.6772E-02,4.6322E-02,2.4787E-02,5.3116E-04,
     &1.0928E-01,8.6339E-02,5.9901E-02,3.2032E-02,6.3348E-04/
      DATA ((KB(JS,JT,32, 7),JS=1,5),JT=1,5) /
     &3.1311E-02,2.4896E-02,1.7336E-02,9.3247E-03,2.3608E-04,
     &4.2575E-02,3.3801E-02,2.3511E-02,1.2616E-02,2.9452E-04,
     &5.6935E-02,4.5129E-02,3.1359E-02,1.6809E-02,3.6093E-04,
     &7.4842E-02,5.9256E-02,4.1156E-02,2.2039E-02,4.3435E-04,
     &9.6933E-02,7.6740E-02,5.3274E-02,2.8476E-02,5.1533E-04/
      DATA ((KB(JS,JT,33, 7),JS=1,5),JT=1,5) /
     &2.7886E-02,2.2206E-02,1.5465E-02,8.3176E-03,1.9330E-04,
     &3.7954E-02,3.0161E-02,2.0981E-02,1.1260E-02,2.4048E-04,
     &5.0729E-02,4.0269E-02,2.7996E-02,1.5008E-02,2.9283E-04,
     &6.6680E-02,5.2910E-02,3.6768E-02,1.9685E-02,3.5174E-04,
     &8.6325E-02,6.8491E-02,4.7579E-02,2.5448E-02,4.1781E-04/
      DATA ((KB(JS,JT,34, 7),JS=1,5),JT=1,5) /
     &2.4971E-02,1.9901E-02,1.3860E-02,7.4508E-03,1.5943E-04,
     &3.3993E-02,2.7044E-02,1.8817E-02,1.0102E-02,1.9737E-04,
     &4.5431E-02,3.6116E-02,2.5118E-02,1.3468E-02,2.4097E-04,
     &5.9751E-02,4.7485E-02,3.3007E-02,1.7673E-02,2.8983E-04,
     &7.7416E-02,6.1530E-02,4.2751E-02,2.2863E-02,3.4328E-04/
      DATA ((KB(JS,JT,35, 7),JS=1,5),JT=1,5) /
     &2.1796E-02,1.7387E-02,1.2111E-02,6.5084E-03,1.2835E-04,
     &2.9698E-02,2.3666E-02,1.6479E-02,8.8433E-03,1.5863E-04,
     &3.9760E-02,3.1675E-02,2.2035E-02,1.1812E-02,1.9396E-04,
     &5.2402E-02,4.1735E-02,2.9029E-02,1.5538E-02,2.3292E-04,
     &6.8053E-02,5.4173E-02,3.7664E-02,2.0141E-02,2.7598E-04/
      DATA ((KB(JS,JT,36, 7),JS=1,5),JT=1,5) /
     &1.8439E-02,1.4736E-02,1.0269E-02,5.5181E-03,1.0059E-04,
     &2.5228E-02,2.0135E-02,1.4024E-02,7.5257E-03,1.2421E-04,
     &3.3891E-02,2.7058E-02,1.8832E-02,1.0097E-02,1.5179E-04,
     &4.4855E-02,3.5783E-02,2.4899E-02,1.3331E-02,1.8254E-04,
     &5.8411E-02,4.6611E-02,3.2419E-02,1.7335E-02,2.1654E-04/
      DATA ((KB(JS,JT,37, 7),JS=1,5),JT=1,5) /
     &1.5025E-02,1.2025E-02,8.3808E-03,4.5043E-03,7.8293E-05,
     &2.0678E-02,1.6540E-02,1.1522E-02,6.1849E-03,9.7252E-05,
     &2.7964E-02,2.2364E-02,1.5572E-02,8.3486E-03,1.1926E-04,
     &3.7225E-02,2.9764E-02,2.0719E-02,1.1092E-02,1.4386E-04,
     &4.8779E-02,3.9013E-02,2.7143E-02,1.4513E-02,1.7127E-04/
      DATA ((KB(JS,JT,38, 7),JS=1,5),JT=1,5) /
     &1.2194E-02,9.7772E-03,6.8154E-03,3.6630E-03,6.0721E-05,
     &1.6892E-02,1.3540E-02,9.4349E-03,5.0655E-03,7.5931E-05,
     &2.2993E-02,1.8427E-02,1.2834E-02,6.8825E-03,9.3480E-05,
     &3.0804E-02,2.4686E-02,1.7192E-02,9.2065E-03,1.1312E-04,
     &4.0626E-02,3.2569E-02,2.2673E-02,1.2127E-02,1.3481E-04/
      DATA ((KB(JS,JT,39, 7),JS=1,5),JT=1,5) /
     &9.8863E-03,7.9385E-03,5.5336E-03,2.9753E-03,4.6829E-05,
     &1.3782E-02,1.1068E-02,7.7135E-03,4.1426E-03,5.8903E-05,
     &1.8884E-02,1.5163E-02,1.0568E-02,5.6692E-03,7.2758E-05,
     &2.5472E-02,2.0459E-02,1.4252E-02,7.6329E-03,8.8280E-05,
     &3.3793E-02,2.7159E-02,1.8912E-02,1.0123E-02,1.0549E-04/
      DATA ((KB(JS,JT,40, 7),JS=1,5),JT=1,5) /
     &7.8183E-03,6.2872E-03,4.3840E-03,2.3583E-03,3.5934E-05,
     &1.1002E-02,8.8456E-03,6.1665E-03,3.3129E-03,4.5505E-05,
     &1.5204E-02,1.2224E-02,8.5201E-03,4.5727E-03,5.6603E-05,
     &2.0667E-02,1.6639E-02,1.1596E-02,6.2148E-03,6.8922E-05,
     &2.7656E-02,2.2280E-02,1.5521E-02,8.3102E-03,8.2779E-05/
      DATA ((KB(JS,JT,41, 7),JS=1,5),JT=1,5) /
     &6.1500E-03,4.9524E-03,3.4538E-03,1.8579E-03,2.7494E-05,
     &8.7326E-03,7.0361E-03,4.9035E-03,2.6349E-03,3.5036E-05,
     &1.2182E-02,9.8121E-03,6.8364E-03,3.6704E-03,4.3900E-05,
     &1.6698E-02,1.3470E-02,9.3901E-03,5.0360E-03,5.3809E-05,
     &2.2541E-02,1.8202E-02,1.2686E-02,6.7978E-03,6.4784E-05/
      DATA ((KB(JS,JT,42, 7),JS=1,5),JT=1,5) /
     &4.8216E-03,3.8878E-03,2.7121E-03,1.4585E-03,2.0930E-05,
     &6.9151E-03,5.5793E-03,3.8882E-03,2.0902E-03,2.6862E-05,
     &9.7317E-03,7.8533E-03,5.4747E-03,2.9388E-03,3.3897E-05,
     &1.3459E-02,1.0876E-02,7.5844E-03,4.0697E-03,4.1759E-05,
     &1.8320E-02,1.4838E-02,1.0343E-02,5.5456E-03,5.0540E-05/
      DATA ((KB(JS,JT,43, 7),JS=1,5),JT=1,5) /
     &3.7271E-03,3.0076E-03,2.0983E-03,1.1283E-03,1.5715E-05,
     &5.4034E-03,4.3650E-03,3.0427E-03,1.6347E-03,2.0366E-05,
     &7.6865E-03,6.2120E-03,4.3312E-03,2.3251E-03,2.5938E-05,
     &1.0735E-02,8.6871E-03,6.0565E-03,3.2504E-03,3.2151E-05,
     &1.4744E-02,1.1965E-02,8.3459E-03,4.4756E-03,3.9126E-05/
      DATA ((KB(JS,JT,44, 7),JS=1,5),JT=1,5) /
     &2.8560E-03,2.3067E-03,1.6088E-03,8.6423E-04,1.1691E-05,
     &4.1914E-03,3.3878E-03,2.3617E-03,1.2680E-03,1.5336E-05,
     &6.0257E-03,4.8753E-03,3.3991E-03,1.8248E-03,1.9674E-05,
     &8.5074E-03,6.8953E-03,4.8067E-03,2.5783E-03,2.4601E-05,
     &1.1798E-02,9.5893E-03,6.6876E-03,3.5866E-03,3.0110E-05/
      DATA ((KB(JS,JT,45, 7),JS=1,5),JT=1,5) /
     &2.1795E-03,1.7620E-03,1.2288E-03,6.5976E-04,8.6355E-06,
     &3.2384E-03,2.6190E-03,1.8255E-03,9.8000E-04,1.1470E-05,
     &4.7095E-03,3.8135E-03,2.6589E-03,1.4269E-03,1.4819E-05,
     &6.7188E-03,5.4533E-03,3.8021E-03,2.0391E-03,1.8692E-05,
     &9.4160E-03,7.6627E-03,5.3428E-03,2.8648E-03,2.3071E-05/
      DATA ((KB(JS,JT,46, 7),JS=1,5),JT=1,5) /
     &1.6442E-03,1.3301E-03,9.2731E-04,4.9724E-04,6.3123E-06,
     &2.4756E-03,2.0038E-03,1.3961E-03,7.4858E-04,8.4887E-06,
     &3.6430E-03,2.9527E-03,2.0584E-03,1.1034E-03,1.1065E-05,
     &5.2551E-03,4.2702E-03,2.9775E-03,1.5960E-03,1.4093E-05,
     &7.4490E-03,6.0700E-03,4.2323E-03,2.2675E-03,1.7540E-05/
      DATA ((KB(JS,JT,47, 7),JS=1,5),JT=1,5) /
     &1.2145E-03,9.8337E-04,6.8536E-04,3.6730E-04,4.5517E-06,
     &1.8591E-03,1.5045E-03,1.0482E-03,5.6130E-04,6.1946E-06,
     &2.7714E-03,2.2470E-03,1.5654E-03,8.3875E-04,8.1842E-06,
     &4.0468E-03,3.2903E-03,2.2941E-03,1.2283E-03,1.0514E-05,
     &5.8053E-03,4.7349E-03,3.3018E-03,1.7685E-03,1.3244E-05/
      DATA ((KB(JS,JT,48, 7),JS=1,5),JT=1,5) /
     &8.9209E-04,7.2273E-04,5.0348E-04,2.6958E-04,3.2450E-06,
     &1.3877E-03,1.1243E-03,7.8261E-04,4.1863E-04,4.4867E-06,
     &2.0991E-03,1.7020E-03,1.1852E-03,6.3416E-04,6.0052E-06,
     &3.1030E-03,2.5246E-03,1.7595E-03,9.4166E-04,7.8064E-06,
     &4.5012E-03,3.6752E-03,2.5627E-03,1.3716E-03,9.9188E-06/
      DATA ((KB(JS,JT,49, 7),JS=1,5),JT=1,5) /
     &6.5052E-04,5.2741E-04,3.6738E-04,1.9665E-04,2.2928E-06,
     &1.0291E-03,8.3378E-04,5.8035E-04,3.1024E-04,3.2141E-06,
     &1.5816E-03,1.2832E-03,8.9291E-04,4.7687E-04,4.3608E-06,
     &2.3687E-03,1.9273E-03,1.3422E-03,7.1737E-04,5.7390E-06,
     &3.4765E-03,2.8403E-03,1.9797E-03,1.0580E-03,7.3616E-06/
      DATA ((KB(JS,JT,50, 7),JS=1,5),JT=1,5) /
     &4.7889E-04,3.8798E-04,2.7009E-04,1.4448E-04,1.6356E-06,
     &7.6956E-04,6.2385E-04,4.3396E-04,2.3170E-04,2.3299E-06,
     &1.1998E-03,9.7385E-04,6.7714E-04,3.6138E-04,3.2007E-06,
     &1.8222E-03,1.4833E-03,1.0320E-03,5.5070E-04,4.2632E-06,
     &2.7064E-03,2.2113E-03,1.5405E-03,8.2234E-04,5.5273E-06/
      DATA ((KB(JS,JT,51, 7),JS=1,5),JT=1,5) /
     &3.5344E-04,2.8635E-04,1.9912E-04,1.0636E-04,1.1680E-06,
     &5.7631E-04,4.6738E-04,3.2502E-04,1.7332E-04,1.6902E-06,
     &9.1142E-04,7.3982E-04,5.1424E-04,2.7410E-04,2.3543E-06,
     &1.4045E-03,1.1437E-03,7.9544E-04,4.2395E-04,3.1729E-06,
     &2.1131E-03,1.7268E-03,1.2023E-03,6.4090E-04,4.1620E-06/
      DATA ((KB(JS,JT,52, 7),JS=1,5),JT=1,5) /
     &2.5933E-04,2.1020E-04,1.4608E-04,7.7951E-05,8.2759E-07,
     &4.3070E-04,3.4917E-04,2.4257E-04,1.2919E-04,1.2165E-06,
     &6.9048E-04,5.6079E-04,3.8962E-04,2.0733E-04,1.7208E-06,
     &1.0785E-03,8.7815E-04,6.1039E-04,3.2491E-04,2.3474E-06,
     &1.6449E-03,1.3448E-03,9.3585E-04,4.9830E-04,3.1177E-06/
      DATA ((KB(JS,JT,53, 7),JS=1,5),JT=1,5) /
     &1.8893E-04,1.5324E-04,1.0643E-04,5.6765E-05,5.8012E-07,
     &3.2030E-04,2.5977E-04,1.8033E-04,9.5988E-05,8.6790E-07,
     &5.2133E-04,4.2303E-04,2.9359E-04,1.5604E-04,1.2459E-06,
     &8.2474E-04,6.7149E-04,4.6612E-04,2.4781E-04,1.7256E-06,
     &1.2742E-03,1.0424E-03,7.2493E-04,3.8558E-04,2.3164E-06/
      DATA ((KB(JS,JT,54, 7),JS=1,5),JT=1,5) /
     &1.3969E-04,1.1317E-04,7.8561E-05,4.1870E-05,4.1563E-07,
     &2.4197E-04,1.9607E-04,1.3602E-04,7.2325E-05,6.3273E-07,
     &4.0015E-04,3.2487E-04,2.2527E-04,1.1951E-04,9.2081E-07,
     &6.4075E-04,5.2162E-04,3.6218E-04,1.9219E-04,1.2926E-06,
     &1.0011E-03,8.1978E-04,5.6992E-04,3.0275E-04,1.7539E-06/
      DATA ((KB(JS,JT,55, 7),JS=1,5),JT=1,5) /
     &1.0370E-04,8.4064E-05,5.8320E-05,3.1035E-05,3.0125E-07,
     &1.8386E-04,1.4899E-04,1.0330E-04,5.4881E-05,4.6624E-07,
     &3.0954E-04,2.5123E-04,1.7413E-04,9.2312E-05,6.8850E-07,
     &5.0203E-04,4.0855E-04,2.8330E-04,1.5019E-04,9.7772E-07,
     &7.9354E-04,6.4976E-04,4.5113E-04,2.3954E-04,1.3409E-06/
      DATA ((KB(JS,JT,56, 7),JS=1,5),JT=1,5) /
     &7.6693E-05,6.2162E-05,4.3120E-05,2.2933E-05,2.1684E-07,
     &1.3934E-04,1.1294E-04,7.8219E-05,4.1520E-05,3.4179E-07,
     &2.3910E-04,1.9403E-04,1.3441E-04,7.1189E-05,5.1274E-07,
     &3.9378E-04,3.2054E-04,2.2198E-04,1.1748E-04,7.3840E-07,
     &6.2957E-04,5.1531E-04,3.5753E-04,1.8952E-04,1.0222E-06/
      DATA ((KB(JS,JT,57, 7),JS=1,5),JT=1,5) /
     &5.6535E-05,4.5829E-05,3.1754E-05,1.6880E-05,1.5535E-07,
     &1.0543E-04,8.5393E-05,5.9099E-05,3.1336E-05,2.4941E-07,
     &1.8447E-04,1.4976E-04,1.0364E-04,5.4850E-05,3.7980E-07,
     &3.0910E-04,2.5132E-04,1.7397E-04,9.1976E-05,5.5506E-07,
     &4.9998E-04,4.0888E-04,2.8341E-04,1.4999E-04,7.7934E-07/
      DATA ((KB(JS,JT,58, 7),JS=1,5),JT=1,5) /
     &2.0338E-05,1.8913E-05,1.5378E-05,9.8853E-06,1.1183E-07,
     &3.8917E-05,3.6144E-05,2.9335E-05,1.8800E-05,1.8309E-07,
     &6.9478E-05,6.4684E-05,5.2517E-05,3.3620E-05,2.8333E-07,
     &1.1843E-04,1.1052E-04,8.9713E-05,5.7328E-05,4.1951E-07,
     &1.9434E-04,1.8218E-04,1.4806E-04,9.4685E-05,5.9796E-07/
      DATA ((KB(JS,JT,59, 7),JS=1,5),JT=1,5) /
     &1.6486E-05,1.5394E-05,1.2565E-05,8.1204E-06,9.1178E-08,
     &3.1937E-05,2.9800E-05,2.4292E-05,1.5665E-05,1.5065E-07,
     &5.7683E-05,5.3905E-05,4.3942E-05,2.8299E-05,2.3496E-07,
     &9.9323E-05,9.3088E-05,7.5927E-05,4.8813E-05,3.4922E-07,
     &1.6451E-04,1.5507E-04,1.2661E-04,8.1439E-05,5.0093E-07/
      DATA ((KB(JS,JT,13, 8),JS=1,5),JT=1,5) /
     &1.2116E+00,9.1758E-01,6.2996E-01,3.3536E-01,1.5468E-02,
     &1.6818E+00,1.2746E+00,8.7634E-01,4.6518E-01,1.8709E-02,
     &2.2865E+00,1.7360E+00,1.1942E+00,6.3525E-01,2.2469E-02,
     &3.0754E+00,2.3371E+00,1.6054E+00,8.5102E-01,2.6288E-02,
     &4.0473E+00,3.0761E+00,2.1113E+00,1.1162E+00,3.0276E-02/
      DATA ((KB(JS,JT,14, 8),JS=1,5),JT=1,5) /
     &1.1078E+00,8.4059E-01,5.7946E-01,3.0612E-01,1.2063E-02,
     &1.5335E+00,1.1661E+00,8.0499E-01,4.2627E-01,1.4718E-02,
     &2.0884E+00,1.5886E+00,1.0949E+00,5.8050E-01,1.7857E-02,
     &2.8120E+00,2.1413E+00,1.4745E+00,7.8098E-01,2.1007E-02,
     &3.6989E+00,2.8189E+00,1.9396E+00,1.0257E+00,2.4295E-02/
      DATA ((KB(JS,JT,15, 8),JS=1,5),JT=1,5) /
     &9.7042E-01,7.3947E-01,5.1034E-01,2.6949E-01,9.7938E-03,
     &1.3436E+00,1.0262E+00,7.0874E-01,3.7517E-01,1.2203E-02,
     &1.8449E+00,1.4109E+00,9.7248E-01,5.1316E-01,1.4807E-02,
     &2.4626E+00,1.8840E+00,1.3006E+00,6.9030E-01,1.7518E-02,
     &3.2241E+00,2.4640E+00,1.6957E+00,8.9766E-01,2.0767E-02/
      DATA ((KB(JS,JT,16, 8),JS=1,5),JT=1,5) /
     &8.2995E-01,6.3671E-01,4.3954E-01,2.3206E-01,8.0720E-03,
     &1.1570E+00,8.8835E-01,6.1260E-01,3.2369E-01,1.0091E-02,
     &1.5781E+00,1.2128E+00,8.3725E-01,4.4354E-01,1.2349E-02,
     &2.1038E+00,1.6176E+00,1.1171E+00,5.9216E-01,1.4755E-02,
     &2.7385E+00,2.1023E+00,1.4490E+00,7.6892E-01,1.7667E-02/
      DATA ((KB(JS,JT,17, 8),JS=1,5),JT=1,5) /
     &7.0692E-01,5.4586E-01,3.7661E-01,1.9889E-01,6.7483E-03,
     &9.8295E-01,7.5893E-01,5.2307E-01,2.7659E-01,8.4850E-03,
     &1.3367E+00,1.0327E+00,7.1373E-01,3.7884E-01,1.0478E-02,
     &1.7756E+00,1.3697E+00,9.4344E-01,4.9980E-01,1.2797E-02,
     &2.3127E+00,1.7838E+00,1.2303E+00,6.5347E-01,1.5355E-02/
      DATA ((KB(JS,JT,18, 8),JS=1,5),JT=1,5) /
     &5.9108E-01,4.5836E-01,3.1625E-01,1.6744E-01,5.7287E-03,
     &8.2052E-01,6.3681E-01,4.3945E-01,2.3289E-01,7.3032E-03,
     &1.1131E+00,8.6338E-01,5.9577E-01,3.1578E-01,9.0895E-03,
     &1.4765E+00,1.1444E+00,7.8909E-01,4.1827E-01,1.1179E-02,
     &1.9250E+00,1.4898E+00,1.0284E+00,5.4576E-01,1.3498E-02/
      DATA ((KB(JS,JT,19, 8),JS=1,5),JT=1,5) /
     &5.0114E-01,3.9028E-01,2.6968E-01,1.4303E-01,5.0299E-03,
     &6.9768E-01,5.4308E-01,3.7493E-01,1.9896E-01,6.4752E-03,
     &9.4555E-01,7.3537E-01,5.0733E-01,2.6864E-01,8.1323E-03,
     &1.2515E+00,9.7204E-01,6.7090E-01,3.5577E-01,1.0007E-02,
     &1.6326E+00,1.2674E+00,8.7478E-01,4.6363E-01,1.2144E-02/
      DATA ((KB(JS,JT,20, 8),JS=1,5),JT=1,5) /
     &4.3618E-01,3.4070E-01,2.3544E-01,1.2514E-01,4.4918E-03,
     &6.0844E-01,4.7506E-01,3.2779E-01,1.7405E-01,5.8213E-03,
     &8.2504E-01,6.4315E-01,4.4377E-01,2.3521E-01,7.3449E-03,
     &1.0904E+00,8.4892E-01,5.8560E-01,3.1033E-01,9.1136E-03,
     &1.4182E+00,1.1040E+00,7.6212E-01,4.0404E-01,1.1084E-02/
      DATA ((KB(JS,JT,21, 8),JS=1,5),JT=1,5) /
     &3.8157E-01,2.9889E-01,2.0662E-01,1.0989E-01,4.0172E-03,
     &5.3249E-01,4.1652E-01,2.8764E-01,1.5288E-01,5.2442E-03,
     &7.2280E-01,5.6456E-01,3.8951E-01,2.0661E-01,6.6692E-03,
     &9.5675E-01,7.4634E-01,5.1474E-01,2.7285E-01,8.2754E-03,
     &1.2430E+00,9.6862E-01,6.6782E-01,3.5364E-01,1.0090E-02/
      DATA ((KB(JS,JT,22, 8),JS=1,5),JT=1,5) /
     &3.4101E-01,2.6749E-01,1.8491E-01,9.8339E-02,3.6398E-03,
     &4.7480E-01,3.7184E-01,2.5674E-01,1.3643E-01,4.7506E-03,
     &6.4273E-01,5.0295E-01,3.4722E-01,1.8435E-01,6.0333E-03,
     &8.5104E-01,6.6530E-01,4.5905E-01,2.4340E-01,7.4888E-03,
     &1.1079E+00,8.6526E-01,5.9621E-01,3.1544E-01,9.1269E-03/
      DATA ((KB(JS,JT,23, 8),JS=1,5),JT=1,5) /
     &3.0421E-01,2.3897E-01,1.6516E-01,8.7923E-02,3.2631E-03,
     &4.2200E-01,3.3116E-01,2.2888E-01,1.2169E-01,4.2529E-03,
     &5.7072E-01,4.4747E-01,3.0900E-01,1.6407E-01,5.3912E-03,
     &7.5672E-01,5.9253E-01,4.0891E-01,2.1688E-01,6.6960E-03,
     &9.8731E-01,7.7239E-01,5.3220E-01,2.8204E-01,8.2651E-03/
      DATA ((KB(JS,JT,24, 8),JS=1,5),JT=1,5) /
     &2.7335E-01,2.1493E-01,1.4863E-01,7.9120E-02,2.9206E-03,
     &3.7818E-01,2.9704E-01,2.0533E-01,1.0922E-01,3.7959E-03,
     &5.1197E-01,4.0167E-01,2.7730E-01,1.4723E-01,4.8218E-03,
     &6.8021E-01,5.3323E-01,3.6769E-01,1.9508E-01,6.0367E-03,
     &8.8740E-01,6.9520E-01,4.7892E-01,2.5373E-01,7.4083E-03/
      DATA ((KB(JS,JT,25, 8),JS=1,5),JT=1,5) /
     &2.4667E-01,1.9408E-01,1.3424E-01,7.1436E-02,2.6098E-03,
     &3.4107E-01,2.6809E-01,1.8527E-01,9.8480E-02,3.3820E-03,
     &4.6237E-01,3.6308E-01,2.5057E-01,1.3298E-01,4.3157E-03,
     &6.1385E-01,4.8168E-01,3.3224E-01,1.7632E-01,5.3399E-03,
     &7.9905E-01,6.2682E-01,4.3186E-01,2.2913E-01,6.4913E-03/
      DATA ((KB(JS,JT,26, 8),JS=1,5),JT=1,5) /
     &2.2404E-01,1.7649E-01,1.2214E-01,6.5022E-02,2.3384E-03,
     &3.1013E-01,2.4403E-01,1.6870E-01,8.9741E-02,3.0179E-03,
     &4.2049E-01,3.3066E-01,2.2838E-01,1.2138E-01,3.8039E-03,
     &5.5790E-01,4.3821E-01,3.0237E-01,1.6056E-01,4.6658E-03,
     &7.2377E-01,5.6837E-01,3.9196E-01,2.0795E-01,5.6275E-03/
      DATA ((KB(JS,JT,27, 8),JS=1,5),JT=1,5) /
     &2.0411E-01,1.6088E-01,1.1131E-01,5.9303E-02,2.0568E-03,
     &2.8256E-01,2.2260E-01,1.5392E-01,8.1961E-02,2.6349E-03,
     &3.8251E-01,3.0112E-01,2.0805E-01,1.1068E-01,3.2772E-03,
     &5.0562E-01,3.9785E-01,2.7464E-01,1.4598E-01,4.0077E-03,
     &6.5445E-01,5.1441E-01,3.5497E-01,1.8851E-01,4.8055E-03/
      DATA ((KB(JS,JT,28, 8),JS=1,5),JT=1,5) /
     &1.8628E-01,1.4699E-01,1.0171E-01,5.4235E-02,1.7799E-03,
     &2.5749E-01,2.0322E-01,1.4053E-01,7.4881E-02,2.2515E-03,
     &3.4728E-01,2.7380E-01,1.8920E-01,1.0075E-01,2.7863E-03,
     &4.5755E-01,3.6044E-01,2.4894E-01,1.3243E-01,3.3903E-03,
     &5.9045E-01,4.6494E-01,3.2101E-01,1.7052E-01,4.0404E-03/
      DATA ((KB(JS,JT,29, 8),JS=1,5),JT=1,5) /
     &1.6897E-01,1.3358E-01,9.2501E-02,4.9422E-02,1.5070E-03,
     &2.3294E-01,1.8406E-01,1.2733E-01,6.7942E-02,1.8975E-03,
     &3.1307E-01,2.4704E-01,1.7081E-01,9.1043E-02,2.3375E-03,
     &4.1126E-01,3.2432E-01,2.2417E-01,1.1931E-01,2.8199E-03,
     &5.2992E-01,4.1770E-01,2.8860E-01,1.5337E-01,3.3535E-03/
      DATA ((KB(JS,JT,30, 8),JS=1,5),JT=1,5) /
     &1.5242E-01,1.2071E-01,8.3664E-02,4.4778E-02,1.2669E-03,
     &2.0927E-01,1.6559E-01,1.1465E-01,6.1290E-02,1.5824E-03,
     &2.8036E-01,2.2167E-01,1.5340E-01,8.1865E-02,1.9342E-03,
     &3.6796E-01,2.9065E-01,2.0100E-01,1.0707E-01,2.3143E-03,
     &4.7407E-01,3.7431E-01,2.5849E-01,1.3745E-01,2.7612E-03/
      DATA ((KB(JS,JT,31, 8),JS=1,5),JT=1,5) /
     &1.3611E-01,1.0796E-01,7.4865E-02,4.0122E-02,1.0479E-03,
     &1.8611E-01,1.4751E-01,1.0224E-01,5.4734E-02,1.2997E-03,
     &2.4882E-01,1.9706E-01,1.3650E-01,7.2954E-02,1.5789E-03,
     &3.2631E-01,2.5819E-01,1.7872E-01,9.5286E-02,1.8990E-03,
     &4.2088E-01,3.3264E-01,2.2986E-01,1.2231E-01,2.2523E-03/
      DATA ((KB(JS,JT,32, 8),JS=1,5),JT=1,5) /
     &1.2210E-01,9.6994E-02,6.7326E-02,3.6123E-02,8.5904E-04,
     &1.6652E-01,1.3210E-01,9.1670E-02,4.9107E-02,1.0623E-03,
     &2.2222E-01,1.7626E-01,1.2220E-01,6.5357E-02,1.2931E-03,
     &2.9160E-01,2.3096E-01,1.5993E-01,8.5342E-02,1.5468E-03,
     &3.7617E-01,2.9768E-01,2.0589E-01,1.0971E-01,1.8394E-03/
      DATA ((KB(JS,JT,33, 8),JS=1,5),JT=1,5) /
     &1.0986E-01,8.7382E-02,6.0737E-02,3.2609E-02,7.0177E-04,
     &1.4961E-01,1.1887E-01,8.2542E-02,4.4260E-02,8.6489E-04,
     &1.9974E-01,1.5861E-01,1.0995E-01,5.8836E-02,1.0533E-03,
     &2.6219E-01,2.0793E-01,1.4396E-01,7.6884E-02,1.2624E-03,
     &3.3855E-01,2.6852E-01,1.8574E-01,9.9060E-02,1.4976E-03/
      DATA ((KB(JS,JT,34, 8),JS=1,5),JT=1,5) /
     &9.9355E-02,7.9091E-02,5.5001E-02,2.9534E-02,5.8155E-04,
     &1.3530E-01,1.0764E-01,7.4771E-02,4.0076E-02,7.1503E-04,
     &1.8087E-01,1.4373E-01,9.9666E-02,5.3339E-02,8.6827E-04,
     &2.3750E-01,1.8867E-01,1.3063E-01,6.9822E-02,1.0409E-03,
     &3.0762E-01,2.4432E-01,1.6897E-01,9.0140E-02,1.2357E-03/
      DATA ((KB(JS,JT,35, 8),JS=1,5),JT=1,5) /
     &8.7519E-02,6.9769E-02,4.8552E-02,2.6085E-02,4.6868E-04,
     &1.1953E-01,9.5204E-02,6.6129E-02,3.5470E-02,5.7740E-04,
     &1.6035E-01,1.2756E-01,8.8463E-02,4.7361E-02,7.0118E-04,
     &2.1123E-01,1.6801E-01,1.1639E-01,6.2235E-02,8.4220E-04,
     &2.7484E-01,2.1861E-01,1.5121E-01,8.0717E-02,1.0033E-03/
      DATA ((KB(JS,JT,36, 8),JS=1,5),JT=1,5) /
     &7.4849E-02,5.9737E-02,4.1593E-02,2.2353E-02,3.6660E-04,
     &1.0278E-01,8.1972E-02,5.6955E-02,3.0544E-02,4.5336E-04,
     &1.3843E-01,1.1029E-01,7.6519E-02,4.1000E-02,5.5390E-04,
     &1.8385E-01,1.4649E-01,1.0149E-01,5.4257E-02,6.6682E-04,
     &2.4059E-01,1.9160E-01,1.3256E-01,7.0808E-02,7.9593E-04/
      DATA ((KB(JS,JT,37, 8),JS=1,5),JT=1,5) /
     &6.1778E-02,4.9350E-02,3.4377E-02,1.8481E-02,2.8834E-04,
     &8.5595E-02,6.8343E-02,4.7513E-02,2.5474E-02,3.5693E-04,
     &1.1627E-01,9.2744E-02,6.4387E-02,3.4481E-02,4.3707E-04,
     &1.5562E-01,1.2411E-01,8.6025E-02,4.6007E-02,5.2965E-04,
     &2.0514E-01,1.6357E-01,1.1324E-01,6.0461E-02,6.3315E-04/
      DATA ((KB(JS,JT,38, 8),JS=1,5),JT=1,5) /
     &5.0881E-02,4.0678E-02,2.8356E-02,1.5247E-02,2.2603E-04,
     &7.1115E-02,5.6873E-02,3.9548E-02,2.1211E-02,2.8054E-04,
     &9.7490E-02,7.7896E-02,5.4103E-02,2.8959E-02,3.4399E-04,
     &1.3157E-01,1.0506E-01,7.2849E-02,3.8945E-02,4.1860E-04,
     &1.7483E-01,1.3966E-01,9.6758E-02,5.1645E-02,5.0365E-04/
      DATA ((KB(JS,JT,39, 8),JS=1,5),JT=1,5) /
     &4.1872E-02,3.3548E-02,2.3398E-02,1.2576E-02,1.7614E-04,
     &5.9094E-02,4.7316E-02,3.2924E-02,1.7662E-02,2.1952E-04,
     &8.1814E-02,6.5458E-02,4.5468E-02,2.4343E-02,2.7005E-04,
     &1.1129E-01,8.9026E-02,6.1776E-02,3.3031E-02,3.3030E-04,
     &1.4922E-01,1.1944E-01,8.2784E-02,4.4132E-02,4.0030E-04/
      DATA ((KB(JS,JT,40, 8),JS=1,5),JT=1,5) /
     &3.3647E-02,2.6996E-02,1.8830E-02,1.0123E-02,1.3664E-04,
     &4.8077E-02,3.8535E-02,2.6836E-02,1.4394E-02,1.7115E-04,
     &6.7356E-02,5.3948E-02,3.7498E-02,2.0063E-02,2.1194E-04,
     &9.2612E-02,7.4161E-02,5.1473E-02,2.7514E-02,2.6017E-04,
     &1.2534E-01,1.0040E-01,6.9623E-02,3.7148E-02,3.1694E-04/
      DATA ((KB(JS,JT,41, 8),JS=1,5),JT=1,5) /
     &2.6919E-02,2.1625E-02,1.5091E-02,8.1073E-03,1.0569E-04,
     &3.8959E-02,3.1258E-02,2.1769E-02,1.1674E-02,1.3335E-04,
     &5.5227E-02,4.4304E-02,3.0810E-02,1.6485E-02,1.6620E-04,
     &7.6819E-02,6.1609E-02,4.2770E-02,2.2843E-02,2.0484E-04,
     &1.0504E-01,8.4290E-02,5.8439E-02,3.1171E-02,2.5031E-04/
      DATA ((KB(JS,JT,42, 8),JS=1,5),JT=1,5) /
     &2.1470E-02,1.7281E-02,1.2058E-02,6.4788E-03,8.1238E-05,
     &3.1494E-02,2.5316E-02,1.7631E-02,9.4523E-03,1.0344E-04,
     &4.5222E-02,3.6333E-02,2.5262E-02,1.3522E-02,1.2977E-04,
     &6.3644E-02,5.1128E-02,3.5506E-02,1.8951E-02,1.6105E-04,
     &8.7974E-02,7.0671E-02,4.9043E-02,2.6143E-02,1.9719E-04/
      DATA ((KB(JS,JT,43, 8),JS=1,5),JT=1,5) /
     &1.6861E-02,1.3590E-02,9.4853E-03,5.0945E-03,6.1844E-05,
     &2.5102E-02,2.0210E-02,1.4080E-02,7.5450E-03,7.9573E-05,
     &3.6570E-02,2.9430E-02,2.0473E-02,1.0954E-02,1.0063E-04,
     &5.2231E-02,4.1980E-02,2.9163E-02,1.5562E-02,1.2552E-04,
     &7.3055E-02,5.8741E-02,4.0761E-02,2.1719E-02,1.5491E-04/
      DATA ((KB(JS,JT,44, 8),JS=1,5),JT=1,5) /
     &1.3112E-02,1.0583E-02,7.3867E-03,3.9656E-03,4.6708E-05,
     &1.9838E-02,1.5995E-02,1.1144E-02,5.9703E-03,6.0776E-05,
     &2.9345E-02,2.3649E-02,1.6458E-02,8.7984E-03,7.7487E-05,
     &4.2542E-02,3.4237E-02,2.3782E-02,1.2696E-02,9.7391E-05,
     &6.0327E-02,4.8544E-02,3.3677E-02,1.7934E-02,1.2115E-04/
      DATA ((KB(JS,JT,45, 8),JS=1,5),JT=1,5) /
     &1.0146E-02,8.1985E-03,5.7225E-03,3.0712E-03,3.5068E-05,
     &1.5607E-02,1.2601E-02,8.7806E-03,4.7019E-03,4.6144E-05,
     &2.3451E-02,1.8930E-02,1.3177E-02,7.0434E-03,5.9457E-05,
     &3.4514E-02,2.7825E-02,1.9327E-02,1.0311E-02,7.5434E-05,
     &4.9675E-02,4.0043E-02,2.7784E-02,1.4786E-02,9.4540E-05/
      DATA ((KB(JS,JT,46, 8),JS=1,5),JT=1,5) /
     &7.7351E-03,6.2590E-03,4.3712E-03,2.3470E-03,2.6024E-05,
     &1.2117E-02,9.8019E-03,6.8312E-03,3.6581E-03,3.4737E-05,
     &1.8521E-02,1.4972E-02,1.0423E-02,5.5707E-03,4.5227E-05,
     &2.7718E-02,2.2376E-02,1.5549E-02,8.2942E-03,5.8064E-05,
     &4.0521E-02,3.2720E-02,2.2708E-02,1.2084E-02,7.3480E-05/
      DATA ((KB(JS,JT,47, 8),JS=1,5),JT=1,5) /
     &5.7592E-03,4.6672E-03,3.2593E-03,1.7501E-03,1.9095E-05,
     &9.2060E-03,7.4576E-03,5.1997E-03,2.7848E-03,2.5839E-05,
     &1.4346E-02,1.1614E-02,8.0835E-03,4.3208E-03,3.4203E-05,
     &2.1845E-02,1.7678E-02,1.2284E-02,6.5493E-03,4.4407E-05,
     &3.2496E-02,2.6280E-02,1.8234E-02,9.7018E-03,5.6773E-05/
      DATA ((KB(JS,JT,48, 8),JS=1,5),JT=1,5) /
     &4.2511E-03,3.4498E-03,2.4093E-03,1.2936E-03,1.3859E-05,
     &6.9347E-03,5.6254E-03,3.9226E-03,2.1019E-03,1.9117E-05,
     &1.1018E-02,8.9390E-03,6.2242E-03,3.3284E-03,2.5648E-05,
     &1.7113E-02,1.3870E-02,9.6439E-03,5.1401E-03,3.3736E-05,
     &2.5919E-02,2.1005E-02,1.4575E-02,7.7539E-03,4.3617E-05/
      DATA ((KB(JS,JT,49, 8),JS=1,5),JT=1,5) /
     &3.1098E-03,2.5273E-03,1.7645E-03,9.4708E-04,9.9370E-06,
     &5.1784E-03,4.2068E-03,2.9339E-03,1.5725E-03,1.3987E-05,
     &8.3947E-03,6.8228E-03,4.7538E-03,2.5418E-03,1.9085E-05,
     &1.3293E-02,1.0799E-02,7.5113E-03,4.0058E-03,2.5451E-05,
     &2.0521E-02,1.6668E-02,1.1574E-02,6.1522E-03,3.3363E-05/
      DATA ((KB(JS,JT,50, 8),JS=1,5),JT=1,5) /
     &2.2918E-03,1.8636E-03,1.3008E-03,6.9789E-04,7.1979E-06,
     &3.8913E-03,3.1670E-03,2.2089E-03,1.1842E-03,1.0331E-05,
     &6.4390E-03,5.2441E-03,3.6531E-03,1.9538E-03,1.4344E-05,
     &1.0397E-02,8.4649E-03,5.8892E-03,3.1423E-03,1.9397E-05,
     &1.6371E-02,1.3317E-02,9.2504E-03,4.9185E-03,2.5741E-05/
      DATA ((KB(JS,JT,51, 8),JS=1,5),JT=1,5) /
     &1.6928E-03,1.3767E-03,9.6023E-04,5.1382E-04,5.2246E-06,
     &2.9272E-03,2.3839E-03,1.6628E-03,8.9103E-04,7.6388E-06,
     &4.9429E-03,4.0319E-03,2.8087E-03,1.5020E-03,1.0781E-05,
     &8.1364E-03,6.6389E-03,4.6188E-03,2.4654E-03,1.4827E-05,
     &1.3068E-02,1.0656E-02,7.4020E-03,3.9372E-03,1.9921E-05/
      DATA ((KB(JS,JT,52, 8),JS=1,5),JT=1,5) /
     &1.2399E-03,1.0091E-03,7.0357E-04,3.7650E-04,3.7522E-06,
     &2.1899E-03,1.7829E-03,1.2430E-03,6.6579E-04,5.6100E-06,
     &3.7665E-03,3.0795E-03,2.1447E-03,1.1464E-03,8.0632E-06,
     &6.3261E-03,5.1729E-03,3.5994E-03,1.9224E-03,1.1265E-05,
     &1.0363E-02,8.4710E-03,5.8842E-03,3.1302E-03,1.5370E-05/
      DATA ((KB(JS,JT,53, 8),JS=1,5),JT=1,5) /
     &9.0216E-04,7.3408E-04,5.1164E-04,2.7340E-04,2.6590E-06,
     &1.6262E-03,1.3270E-03,9.2425E-04,4.9425E-04,4.0810E-06,
     &2.8513E-03,2.3327E-03,1.6237E-03,8.6789E-04,5.9668E-06,
     &4.8843E-03,4.0007E-03,2.7846E-03,1.4866E-03,8.4879E-06,
     &8.1619E-03,6.6885E-03,4.6478E-03,2.4735E-03,1.1744E-05/
      DATA ((KB(JS,JT,54, 8),JS=1,5),JT=1,5) /
     &6.6939E-04,5.4497E-04,3.7910E-04,2.0225E-04,1.9239E-06,
     &1.2278E-03,1.0030E-03,6.9836E-04,3.7314E-04,3.0194E-06,
     &2.1984E-03,1.7996E-03,1.2511E-03,6.6777E-04,4.5056E-06,
     &3.8331E-03,3.1457E-03,2.1886E-03,1.1687E-03,6.4964E-06,
     &6.5432E-03,5.3709E-03,3.7307E-03,1.9859E-03,9.1107E-06/
      DATA ((KB(JS,JT,55, 8),JS=1,5),JT=1,5) /
     &5.0111E-04,4.0755E-04,2.8321E-04,1.5081E-04,1.4025E-06,
     &9.3502E-04,7.6365E-04,5.3113E-04,2.8338E-04,2.2498E-06,
     &1.7077E-03,1.3993E-03,9.7261E-04,5.1891E-04,3.4289E-06,
     &3.0342E-03,2.4941E-03,1.7338E-03,9.2454E-04,5.0131E-06,
     &5.2834E-03,4.3447E-03,3.0182E-03,1.6053E-03,7.1210E-06/
      DATA ((KB(JS,JT,56, 8),JS=1,5),JT=1,5) /
     &3.7616E-04,3.0519E-04,2.1170E-04,1.1247E-04,1.0140E-06,
     &7.1281E-04,5.8173E-04,4.0420E-04,2.1505E-04,1.6673E-06,
     &1.3229E-03,1.0846E-03,7.5367E-04,4.0126E-04,2.5921E-06,
     &2.4034E-03,1.9754E-03,1.3714E-03,7.3027E-04,3.8577E-06,
     &4.2589E-03,3.5089E-03,2.4364E-03,1.2956E-03,5.5656E-06/
      DATA ((KB(JS,JT,57, 8),JS=1,5),JT=1,5) /
     &2.8163E-04,2.2851E-04,1.5825E-04,8.3801E-05,7.2920E-07,
     &5.4316E-04,4.4288E-04,3.0736E-04,1.6324E-04,1.2275E-06,
     &1.0242E-03,8.3907E-04,5.8250E-04,3.0984E-04,1.9504E-06,
     &1.8977E-03,1.5630E-03,1.0848E-03,5.7691E-04,2.9526E-06,
     &3.4290E-03,2.8298E-03,1.9639E-03,1.0437E-03,4.3203E-06/
      DATA ((KB(JS,JT,58, 8),JS=1,5),JT=1,5) /
     &1.0299E-04,9.5896E-05,7.7844E-05,4.9788E-05,5.2623E-07,
     &2.0307E-04,1.9013E-04,1.5450E-04,9.9035E-05,9.0616E-07,
     &3.8839E-04,3.6515E-04,2.9695E-04,1.9078E-04,1.4737E-06,
     &7.3294E-04,6.9303E-04,5.6426E-04,3.6255E-04,2.2710E-06,
     &1.3532E-03,1.2806E-03,1.0426E-03,6.7017E-04,3.3698E-06/
      DATA ((KB(JS,JT,59, 8),JS=1,5),JT=1,5) /
     &8.5450E-05,7.9848E-05,6.5073E-05,4.1875E-05,4.3253E-07,
     &1.7170E-04,1.6133E-04,1.3170E-04,8.4866E-05,7.5223E-07,
     &3.3324E-04,3.1480E-04,2.5716E-04,1.6610E-04,1.2329E-06,
     &6.4000E-04,6.0786E-04,4.9691E-04,3.2112E-04,1.9165E-06,
     &1.2020E-03,1.1456E-03,9.3584E-04,6.0398E-04,2.8638E-06/
      DATA ((KB(JS,JT,13, 9),JS=1,5),JT=1,5) /
     &7.4699E+00,5.6062E+00,3.7650E+00,1.9560E+00,8.5273E-02,
     &1.0680E+01,8.0165E+00,5.3854E+00,2.8036E+00,1.0411E-01,
     &1.4623E+01,1.0976E+01,7.3752E+00,3.8391E+00,1.2390E-01,
     &1.9264E+01,1.4459E+01,9.7226E+00,5.0654E+00,1.4616E-01,
     &2.4629E+01,1.8491E+01,1.2437E+01,6.4792E+00,1.7014E-01/
      DATA ((KB(JS,JT,14, 9),JS=1,5),JT=1,5) /
     &6.8938E+00,5.1783E+00,3.4875E+00,1.8264E+00,7.6714E-02,
     &9.8527E+00,7.4006E+00,4.9851E+00,2.6106E+00,9.2077E-02,
     &1.3464E+01,1.0115E+01,6.8188E+00,3.5707E+00,1.0926E-01,
     &1.7717E+01,1.3311E+01,8.9749E+00,4.7000E+00,1.2815E-01,
     &2.2681E+01,1.7041E+01,1.1492E+01,6.0178E+00,1.4885E-01/
      DATA ((KB(JS,JT,15, 9),JS=1,5),JT=1,5) /
     &6.1047E+00,4.5908E+00,3.1074E+00,1.6392E+00,6.2768E-02,
     &8.7019E+00,6.5442E+00,4.4301E+00,2.3356E+00,7.5768E-02,
     &1.1847E+01,8.9091E+00,6.0354E+00,3.1840E+00,9.0152E-02,
     &1.5627E+01,1.1753E+01,7.9592E+00,4.1918E+00,1.0596E-01,
     &2.0065E+01,1.5096E+01,1.0229E+01,5.3867E+00,1.2348E-01/
      DATA ((KB(JS,JT,16, 9),JS=1,5),JT=1,5) /
     &5.2710E+00,3.9706E+00,2.7052E+00,1.4383E+00,5.0640E-02,
     &7.4843E+00,5.6386E+00,3.8435E+00,2.0428E+00,6.0690E-02,
     &1.0203E+01,7.6869E+00,5.2380E+00,2.7809E+00,7.2017E-02,
     &1.3478E+01,1.0155E+01,6.9170E+00,3.6687E+00,8.5243E-02,
     &1.7365E+01,1.3088E+01,8.9123E+00,4.7182E+00,9.9040E-02/
      DATA ((KB(JS,JT,17, 9),JS=1,5),JT=1,5) /
     &4.4902E+00,3.3911E+00,2.3244E+00,1.2481E+00,4.0283E-02,
     &6.3739E+00,4.8152E+00,3.3005E+00,1.7693E+00,4.9025E-02,
     &8.7028E+00,6.5740E+00,4.5022E+00,2.4070E+00,5.9283E-02,
     &1.1530E+01,8.7139E+00,5.9683E+00,3.1839E+00,7.0217E-02,
     &1.4910E+01,1.1266E+01,7.7058E+00,4.0973E+00,8.1092E-02/
      DATA ((KB(JS,JT,18, 9),JS=1,5),JT=1,5) /
     &3.7512E+00,2.8459E+00,1.9612E+00,1.0622E+00,3.4382E-02,
     &5.3265E+00,4.0412E+00,2.7835E+00,1.5026E+00,4.2209E-02,
     &7.2937E+00,5.5341E+00,3.8093E+00,2.0485E+00,5.1165E-02,
     &9.7044E+00,7.3625E+00,5.0637E+00,2.7136E+00,6.0247E-02,
     &1.2597E+01,9.5561E+00,6.5653E+00,3.5052E+00,7.0721E-02/
      DATA ((KB(JS,JT,19, 9),JS=1,5),JT=1,5) /
     &3.1949E+00,2.4358E+00,1.6862E+00,9.1523E-01,2.9755E-02,
     &4.5382E+00,3.4601E+00,2.3940E+00,1.2945E+00,3.7026E-02,
     &6.2344E+00,4.7532E+00,3.2851E+00,1.7697E+00,4.5045E-02,
     &8.3349E+00,6.3521E+00,4.3827E+00,2.3518E+00,5.3532E-02,
     &1.0858E+01,8.2689E+00,5.6978E+00,3.0490E+00,6.2338E-02/
      DATA ((KB(JS,JT,20, 9),JS=1,5),JT=1,5) /
     &2.7983E+00,2.1430E+00,1.4907E+00,8.0787E-01,2.6638E-02,
     &3.9801E+00,3.0473E+00,2.1167E+00,1.1423E+00,3.3344E-02,
     &5.4854E+00,4.1978E+00,2.9095E+00,1.5650E+00,4.0067E-02,
     &7.3522E+00,5.6240E+00,3.8910E+00,2.0868E+00,4.7603E-02,
     &9.6006E+00,7.3375E+00,5.0662E+00,2.7087E+00,5.5504E-02/
      DATA ((KB(JS,JT,21, 9),JS=1,5),JT=1,5) /
     &2.4723E+00,1.9017E+00,1.3269E+00,7.1717E-01,2.3842E-02,
     &3.5234E+00,2.7089E+00,1.8854E+00,1.0156E+00,2.9423E-02,
     &4.8624E+00,3.7359E+00,2.5948E+00,1.3934E+00,3.5538E-02,
     &6.5245E+00,5.0095E+00,3.4715E+00,1.8586E+00,4.1992E-02,
     &8.5269E+00,6.5419E+00,4.5264E+00,2.4180E+00,4.9380E-02/
      DATA ((KB(JS,JT,22, 9),JS=1,5),JT=1,5) /
     &2.2453E+00,1.7353E+00,1.2110E+00,6.5234E-01,2.1295E-02,
     &3.1933E+00,2.4664E+00,1.7176E+00,9.2252E-01,2.6174E-02,
     &4.4012E+00,3.3958E+00,2.3595E+00,1.2638E+00,3.1657E-02,
     &5.8834E+00,4.5350E+00,3.1467E+00,1.6824E+00,3.7644E-02,
     &7.6501E+00,5.8912E+00,4.0828E+00,2.1806E+00,4.4263E-02/
      DATA ((KB(JS,JT,23, 9),JS=1,5),JT=1,5) /
     &2.0571E+00,1.5967E+00,1.1115E+00,5.9605E-01,1.8827E-02,
     &2.9057E+00,2.2535E+00,1.5681E+00,8.3999E-01,2.3337E-02,
     &3.9800E+00,3.0833E+00,2.1434E+00,1.1464E+00,2.8190E-02,
     &5.2885E+00,4.0922E+00,2.8421E+00,1.5182E+00,3.3828E-02,
     &6.8471E+00,5.2918E+00,3.6724E+00,1.9594E+00,3.9956E-02/
      DATA ((KB(JS,JT,24, 9),JS=1,5),JT=1,5) /
     &1.9070E+00,1.4857E+00,1.0329E+00,5.5181E-01,1.6663E-02,
     &2.6677E+00,2.0773E+00,1.4448E+00,7.7214E-01,2.0662E-02,
     &3.6252E+00,2.8187E+00,1.9595E+00,1.0463E+00,2.5179E-02,
     &4.7921E+00,3.7213E+00,2.5847E+00,1.3784E+00,3.0300E-02,
     &6.1875E+00,4.7981E+00,3.3299E+00,1.7738E+00,3.5858E-02/
      DATA ((KB(JS,JT,25, 9),JS=1,5),JT=1,5) /
     &1.7679E+00,1.3823E+00,9.6005E-01,5.1215E-01,1.4756E-02,
     &2.4506E+00,1.9149E+00,1.3310E+00,7.1009E-01,1.8413E-02,
     &3.3092E+00,2.5821E+00,1.7930E+00,9.5566E-01,2.2613E-02,
     &4.3581E+00,3.3956E+00,2.3561E+00,1.2539E+00,2.7407E-02,
     &5.6148E+00,4.3684E+00,3.0296E+00,1.6108E+00,3.2730E-02/
      DATA ((KB(JS,JT,26, 9),JS=1,5),JT=1,5) /
     &1.6550E+00,1.2970E+00,8.9910E-01,4.7856E-01,1.3235E-02,
     &2.2724E+00,1.7804E+00,1.2348E+00,6.5702E-01,1.6632E-02,
     &3.0501E+00,2.3862E+00,1.6545E+00,8.7945E-01,2.0602E-02,
     &3.9998E+00,3.1253E+00,2.1658E+00,1.1505E+00,2.5120E-02,
     &5.1417E+00,4.0125E+00,2.7805E+00,1.4756E+00,3.0188E-02/
      DATA ((KB(JS,JT,27, 9),JS=1,5),JT=1,5) /
     &1.5517E+00,1.2181E+00,8.4303E-01,4.4762E-01,1.1922E-02,
     &2.1187E+00,1.6625E+00,1.1508E+00,6.1078E-01,1.5090E-02,
     &2.8285E+00,2.2174E+00,1.5344E+00,8.1390E-01,1.8733E-02,
     &3.6946E+00,2.8938E+00,2.0026E+00,1.0611E+00,2.2964E-02,
     &4.7297E+00,3.7026E+00,2.5639E+00,1.3585E+00,2.7799E-02/
      DATA ((KB(JS,JT,28, 9),JS=1,5),JT=1,5) /
     &1.4557E+00,1.1450E+00,7.9124E-01,4.1922E-01,1.0671E-02,
     &1.9807E+00,1.5572E+00,1.0762E+00,5.7024E-01,1.3585E-02,
     &2.6353E+00,2.0694E+00,1.4297E+00,7.5652E-01,1.7012E-02,
     &3.4268E+00,2.6900E+00,1.8600E+00,9.8357E-01,2.1005E-02,
     &4.3754E+00,3.4337E+00,2.3745E+00,1.2550E+00,2.5556E-02/
      DATA ((KB(JS,JT,29, 9),JS=1,5),JT=1,5) /
     &1.3575E+00,1.0707E+00,7.3899E-01,3.9163E-01,9.5187E-03,
     &1.8443E+00,1.4534E+00,1.0029E+00,5.3089E-01,1.2207E-02,
     &2.4443E+00,1.9245E+00,1.3293E+00,7.0249E-01,1.5292E-02,
     &3.1715E+00,2.4958E+00,1.7237E+00,9.1036E-01,1.8851E-02,
     &4.0410E+00,3.1790E+00,2.1964E+00,1.1590E+00,2.3121E-02/
      DATA ((KB(JS,JT,30, 9),JS=1,5),JT=1,5) /
     &1.2615E+00,9.9705E-01,6.8810E-01,3.6451E-01,8.4241E-03,
     &1.7102E+00,1.3510E+00,9.3203E-01,4.9262E-01,1.0769E-02,
     &2.2602E+00,1.7845E+00,1.2315E+00,6.5024E-01,1.3569E-02,
     &2.9275E+00,2.3103E+00,1.5947E+00,8.4085E-01,1.6868E-02,
     &3.7272E+00,2.9401E+00,2.0301E+00,1.0701E+00,2.0720E-02/
      DATA ((KB(JS,JT,31, 9),JS=1,5),JT=1,5) /
     &1.1628E+00,9.2130E-01,6.3548E-01,3.3629E-01,7.3212E-03,
     &1.5710E+00,1.2442E+00,8.5840E-01,4.5341E-01,9.4089E-03,
     &2.0741E+00,1.6418E+00,1.1326E+00,5.9743E-01,1.1908E-02,
     &2.6838E+00,2.1236E+00,1.4650E+00,7.7246E-01,1.4841E-02,
     &3.4158E+00,2.7036E+00,1.8662E+00,9.8360E-01,1.8280E-02/
      DATA ((KB(JS,JT,32, 9),JS=1,5),JT=1,5) /
     &1.0770E+00,8.5530E-01,5.8998E-01,3.1205E-01,6.3886E-03,
     &1.4521E+00,1.1529E+00,7.9467E-01,4.1942E-01,8.2479E-03,
     &1.9141E+00,1.5187E+00,1.0473E+00,5.5229E-01,1.0468E-02,
     &2.4773E+00,1.9665E+00,1.3565E+00,7.1494E-01,1.3077E-02,
     &3.1536E+00,2.5044E+00,1.7279E+00,9.1011E-01,1.6196E-02/
      DATA ((KB(JS,JT,33, 9),JS=1,5),JT=1,5) /
     &1.0004E+00,7.9686E-01,5.4943E-01,2.9036E-01,5.6169E-03,
     &1.3472E+00,1.0720E+00,7.3887E-01,3.9002E-01,7.2464E-03,
     &1.7767E+00,1.4145E+00,9.7493E-01,5.1400E-01,9.1682E-03,
     &2.3006E+00,1.8321E+00,1.2634E+00,6.6568E-01,1.1493E-02,
     &2.9306E+00,2.3339E+00,1.6102E+00,8.4827E-01,1.4147E-02/
      DATA ((KB(JS,JT,34, 9),JS=1,5),JT=1,5) /
     &9.3256E-01,7.4416E-01,5.1264E-01,2.7079E-01,4.9465E-03,
     &1.2561E+00,1.0020E+00,6.9034E-01,3.6434E-01,6.3960E-03,
     &1.6587E+00,1.3239E+00,9.1206E-01,4.8092E-01,8.1576E-03,
     &2.1501E+00,1.7167E+00,1.1837E+00,6.2351E-01,1.0194E-02,
     &2.7413E+00,2.1905E+00,1.5115E+00,7.9635E-01,1.2542E-02/
      DATA ((KB(JS,JT,35, 9),JS=1,5),JT=1,5) /
     &8.4840E-01,6.7846E-01,4.6725E-01,2.4678E-01,4.2581E-03,
     &1.1466E+00,9.1713E-01,6.3179E-01,3.3319E-01,5.5317E-03,
     &1.5185E+00,1.2151E+00,8.3727E-01,4.4133E-01,7.0625E-03,
     &1.9737E+00,1.5810E+00,1.0899E+00,5.7421E-01,8.8571E-03,
     &2.5262E+00,2.0251E+00,1.3975E+00,7.3625E-01,1.0897E-02/
      DATA ((KB(JS,JT,36, 9),JS=1,5),JT=1,5) /
     &7.5165E-01,6.0226E-01,4.1465E-01,2.1892E-01,3.5512E-03,
     &1.0210E+00,8.1866E-01,5.6371E-01,2.9729E-01,4.6496E-03,
     &1.3584E+00,1.0902E+00,7.5109E-01,3.9583E-01,5.9580E-03,
     &1.7752E+00,1.4261E+00,9.8305E-01,5.1817E-01,7.4947E-03,
     &2.2842E+00,1.8370E+00,1.2679E+00,6.6806E-01,9.2616E-03/
      DATA ((KB(JS,JT,37, 9),JS=1,5),JT=1,5) /
     &6.4071E-01,5.1457E-01,3.5423E-01,1.8691E-01,2.9273E-03,
     &8.7819E-01,7.0566E-01,4.8576E-01,2.5612E-01,3.8482E-03,
     &1.1781E+00,9.4755E-01,6.5255E-01,3.4395E-01,4.9507E-03,
     &1.5513E+00,1.2498E+00,8.6132E-01,4.5404E-01,6.2679E-03,
     &2.0117E+00,1.6227E+00,1.1201E+00,5.9042E-01,7.7688E-03/
      DATA ((KB(JS,JT,38, 9),JS=1,5),JT=1,5) /
     &5.4507E-01,4.3885E-01,3.0197E-01,1.5934E-01,2.3915E-03,
     &7.5435E-01,6.0772E-01,4.1826E-01,2.2053E-01,3.1638E-03,
     &1.0211E+00,8.2323E-01,5.6695E-01,2.9883E-01,4.0903E-03,
     &1.3557E+00,1.0950E+00,7.5476E-01,3.9799E-01,5.2077E-03,
     &1.7730E+00,1.4345E+00,9.9017E-01,5.2203E-01,6.5004E-03/
      DATA ((KB(JS,JT,39, 9),JS=1,5),JT=1,5) /
     &4.6353E-01,3.7406E-01,2.5754E-01,1.3588E-01,1.9343E-03,
     &6.4812E-01,5.2360E-01,3.6039E-01,1.9002E-01,2.5847E-03,
     &8.8607E-01,7.1665E-01,4.9365E-01,2.6013E-01,3.3630E-03,
     &1.1877E+00,9.6199E-01,6.6338E-01,3.4986E-01,4.2963E-03,
     &1.5671E+00,1.2712E+00,8.7761E-01,4.6286E-01,5.3839E-03/
      DATA ((KB(JS,JT,40, 9),JS=1,5),JT=1,5) /
     &3.8448E-01,3.1107E-01,2.1410E-01,1.1297E-01,1.5568E-03,
     &5.4501E-01,4.4126E-01,3.0380E-01,1.6009E-01,2.1042E-03,
     &7.5403E-01,6.1132E-01,4.2098E-01,2.2180E-01,2.7494E-03,
     &1.0220E+00,8.2995E-01,5.7215E-01,3.0165E-01,3.5443E-03,
     &1.3627E+00,1.1080E+00,7.6492E-01,4.0348E-01,4.4643E-03/
      DATA ((KB(JS,JT,41, 9),JS=1,5),JT=1,5) /
     &3.1745E-01,2.5733E-01,1.7713E-01,9.3436E-02,1.2472E-03,
     &4.5638E-01,3.7042E-01,2.5491E-01,1.3436E-01,1.6993E-03,
     &6.3982E-01,5.1972E-01,3.5784E-01,1.8851E-01,2.2393E-03,
     &8.7763E-01,7.1397E-01,4.9232E-01,2.5948E-01,2.9086E-03,
     &1.1829E+00,9.6420E-01,6.6569E-01,3.5114E-01,3.6948E-03/
      DATA ((KB(JS,JT,42, 9),JS=1,5),JT=1,5) /
     &2.6148E-01,2.1244E-01,1.4620E-01,7.7106E-02,9.9249E-04,
     &3.8152E-01,3.1036E-01,2.1367E-01,1.1258E-01,1.3669E-03,
     &5.4219E-01,4.4152E-01,3.0416E-01,1.6017E-01,1.8223E-03,
     &7.5310E-01,6.1412E-01,4.2345E-01,2.2321E-01,2.3766E-03,
     &1.0272E+00,8.3945E-01,5.7960E-01,3.0577E-01,3.0463E-03/
      DATA ((KB(JS,JT,43, 9),JS=1,5),JT=1,5) /
     &2.1184E-01,1.7233E-01,1.1866E-01,6.2577E-02,7.7589E-04,
     &3.1451E-01,2.5652E-01,1.7660E-01,9.2987E-02,1.0831E-03,
     &4.5438E-01,3.7074E-01,2.5543E-01,1.3448E-01,1.4611E-03,
     &6.4007E-01,5.2328E-01,3.6079E-01,1.9007E-01,1.9178E-03,
     &8.8479E-01,7.2477E-01,5.0046E-01,2.6398E-01,2.4774E-03/
      DATA ((KB(JS,JT,44, 9),JS=1,5),JT=1,5) /
     &1.6982E-01,1.3846E-01,9.5299E-02,5.0248E-02,5.9857E-04,
     &2.5706E-01,2.1005E-01,1.4462E-01,7.6126E-02,8.4785E-04,
     &3.7786E-01,3.0904E-01,2.1286E-01,1.1204E-01,1.1605E-03,
     &5.4071E-01,4.4303E-01,3.0555E-01,1.6090E-01,1.5453E-03,
     &7.5841E-01,6.2258E-01,4.2996E-01,2.2675E-01,1.9959E-03/
      DATA ((KB(JS,JT,45, 9),JS=1,5),JT=1,5) /
     &1.3545E-01,1.1062E-01,7.6155E-02,4.0151E-02,4.5711E-04,
     &2.0919E-01,1.7120E-01,1.1790E-01,6.2073E-02,6.5798E-04,
     &3.1316E-01,2.5663E-01,1.7679E-01,9.2995E-02,9.1164E-04,
     &4.5567E-01,3.7416E-01,2.5813E-01,1.3590E-01,1.2287E-03,
     &6.4919E-01,5.3401E-01,3.6882E-01,1.9448E-01,1.6029E-03/
      DATA ((KB(JS,JT,46, 9),JS=1,5),JT=1,5) /
     &1.0668E-01,8.7165E-02,6.0007E-02,3.1628E-02,3.4444E-04,
     &1.6793E-01,1.3770E-01,9.4805E-02,4.9929E-02,5.0372E-04,
     &2.5640E-01,2.1057E-01,1.4511E-01,7.6324E-02,7.0786E-04,
     &3.8014E-01,3.1276E-01,2.1587E-01,1.1362E-01,9.6784E-04,
     &5.5078E-01,4.5406E-01,3.1364E-01,1.6534E-01,1.2803E-03/
      DATA ((KB(JS,JT,47, 9),JS=1,5),JT=1,5) /
     &8.2159E-02,6.7194E-02,4.6255E-02,2.4369E-02,2.5696E-04,
     &1.3183E-01,1.0829E-01,7.4558E-02,3.9260E-02,3.8064E-04,
     &2.0579E-01,1.6932E-01,1.1664E-01,6.1365E-02,5.4299E-04,
     &3.1127E-01,2.5673E-01,1.7713E-01,9.3234E-02,7.5354E-04,
     &4.5944E-01,3.7947E-01,2.6220E-01,1.3818E-01,1.0123E-03/
      DATA ((KB(JS,JT,48, 9),JS=1,5),JT=1,5) /
     &6.2805E-02,5.1372E-02,3.5337E-02,1.8627E-02,1.8799E-04,
     &1.0282E-01,8.4440E-02,5.8150E-02,3.0624E-02,2.8497E-04,
     &1.6397E-01,1.3516E-01,9.3148E-02,4.8994E-02,4.1296E-04,
     &2.5353E-01,2.0948E-01,1.4454E-01,7.6030E-02,5.7970E-04,
     &3.8151E-01,3.1578E-01,2.1823E-01,1.1499E-01,7.9062E-04/
      DATA ((KB(JS,JT,49, 9),JS=1,5),JT=1,5) /
     &4.7675E-02,3.9033E-02,2.6875E-02,1.4167E-02,1.3591E-04,
     &7.9683E-02,6.5540E-02,4.5120E-02,2.3756E-02,2.0952E-04,
     &1.2966E-01,1.0708E-01,7.3804E-02,3.8837E-02,3.0991E-04,
     &2.0506E-01,1.6980E-01,1.1714E-01,6.1628E-02,4.4095E-04,
     &3.1515E-01,2.6147E-01,1.8074E-01,9.5226E-02,6.0820E-04/
      DATA ((KB(JS,JT,50, 9),JS=1,5),JT=1,5) /
     &3.6548E-02,2.9943E-02,2.0610E-02,1.0865E-02,9.9917E-05,
     &6.2279E-02,5.1209E-02,3.5254E-02,1.8566E-02,1.5653E-04,
     &1.0318E-01,8.5332E-02,5.8808E-02,3.0962E-02,2.3703E-04,
     &1.6688E-01,1.3839E-01,9.5487E-02,5.0236E-02,3.4171E-04,
     &2.6185E-01,2.1767E-01,1.5045E-01,7.9263E-02,4.7617E-04/
      DATA ((KB(JS,JT,51, 9),JS=1,5),JT=1,5) /
     &2.7952E-02,2.2969E-02,1.5811E-02,8.3417E-03,7.4671E-05,
     &4.8817E-02,4.0171E-02,2.7641E-02,1.4555E-02,1.1814E-04,
     &8.2508E-02,6.8219E-02,4.6983E-02,2.4707E-02,1.8096E-04,
     &1.3588E-01,1.1285E-01,7.7859E-02,4.0970E-02,2.6754E-04,
     &2.1776E-01,1.8131E-01,1.2532E-01,6.5999E-02,3.7856E-04/
      DATA ((KB(JS,JT,52, 9),JS=1,5),JT=1,5) /
     &2.1199E-02,1.7459E-02,1.2025E-02,6.3452E-03,5.5107E-05,
     &3.8088E-02,3.1354E-02,2.1571E-02,1.1353E-02,8.8069E-05,
     &6.5619E-02,5.4321E-02,3.7416E-02,1.9692E-02,1.3680E-04,
     &1.1018E-01,9.1593E-02,6.3191E-02,3.3254E-02,2.0641E-04,
     &1.8039E-01,1.5044E-01,1.0398E-01,5.4762E-02,2.9766E-04/
      DATA ((KB(JS,JT,53, 9),JS=1,5),JT=1,5) /
     &1.5917E-02,1.3124E-02,9.0469E-03,4.7728E-03,4.0227E-05,
     &2.9453E-02,2.4295E-02,1.6728E-02,8.8064E-03,6.5428E-05,
     &5.2020E-02,4.3058E-02,2.9653E-02,1.5599E-02,1.0270E-04,
     &8.9031E-02,7.3955E-02,5.0990E-02,2.6843E-02,1.5632E-04,
     &1.4878E-01,1.2427E-01,8.5889E-02,4.5242E-02,2.3095E-04/
      DATA ((KB(JS,JT,54, 9),JS=1,5),JT=1,5) /
     &1.2118E-02,1.0014E-02,6.9093E-03,3.6479E-03,3.0413E-05,
     &2.3157E-02,1.9122E-02,1.3172E-02,6.9364E-03,5.0720E-05,
     &4.1929E-02,3.4711E-02,2.3913E-02,1.2578E-02,8.0499E-05,
     &7.3182E-02,6.0821E-02,4.1911E-02,2.2054E-02,1.2452E-04,
     &1.2434E-01,1.0391E-01,7.1807E-02,3.7810E-02,1.8706E-04/
      DATA ((KB(JS,JT,55, 9),JS=1,5),JT=1,5) /
     &9.2663E-03,7.6785E-03,5.3030E-03,2.7962E-03,2.3331E-05,
     &1.8303E-02,1.5169E-02,1.0453E-02,5.5039E-03,4.0062E-05,
     &3.4131E-02,2.8258E-02,1.9454E-02,1.0230E-02,6.4887E-05,
     &6.0672E-02,5.0398E-02,3.4733E-02,1.8270E-02,1.0169E-04,
     &1.0468E-01,8.7488E-02,6.0450E-02,3.1810E-02,1.5537E-04/
      DATA ((KB(JS,JT,56, 9),JS=1,5),JT=1,5) /
     &7.0383E-03,5.8452E-03,4.0381E-03,2.1288E-03,1.7811E-05,
     &1.4408E-02,1.1966E-02,8.2523E-03,4.3448E-03,3.1488E-05,
     &2.7695E-02,2.2953E-02,1.5811E-02,8.3080E-03,5.2239E-05,
     &5.0327E-02,4.1815E-02,2.8827E-02,1.5149E-02,8.2952E-05,
     &8.8477E-02,7.3786E-02,5.0905E-02,2.6783E-02,1.2900E-04/
      DATA ((KB(JS,JT,57, 9),JS=1,5),JT=1,5) /
     &5.2984E-03,4.4048E-03,3.0442E-03,1.6062E-03,1.3485E-05,
     &1.1277E-02,9.3839E-03,6.4745E-03,3.4126E-03,2.4664E-05,
     &2.2383E-02,1.8598E-02,1.2810E-02,6.7278E-03,4.2073E-05,
     &4.1793E-02,3.4722E-02,2.3901E-02,1.2561E-02,6.8099E-05,
     &7.4879E-02,6.2449E-02,4.3075E-02,2.2643E-02,1.0701E-04/
      DATA ((KB(JS,JT,58, 9),JS=1,5),JT=1,5) /
     &1.9422E-03,1.8562E-03,1.5070E-03,9.6178E-04,1.0242E-05,
     &4.2963E-03,4.1126E-03,3.3378E-03,2.1278E-03,1.9475E-05,
     &8.8321E-03,8.4312E-03,6.8267E-03,4.3437E-03,3.4347E-05,
     &1.7006E-02,1.6220E-02,1.3112E-02,8.3245E-03,5.6453E-05,
     &3.1001E-02,2.9664E-02,2.4013E-02,1.5274E-02,9.0315E-05/
      DATA ((KB(JS,JT,59, 9),JS=1,5),JT=1,5) /
     &1.6680E-03,1.5995E-03,1.3049E-03,8.3836E-04,9.2179E-06,
     &3.7712E-03,3.6258E-03,2.9561E-03,1.8979E-03,1.8017E-05,
     &7.9144E-03,7.6082E-03,6.1886E-03,3.9647E-03,3.2435E-05,
     &1.5562E-02,1.4917E-02,1.2127E-02,7.7579E-03,5.4862E-05,
     &2.8789E-02,2.7607E-02,2.2446E-02,1.4356E-02,8.9155E-05/
      DATA ((KB(JS,JT,13,10),JS=1,5),JT=1,5) /
     &3.5965E+01,2.6975E+01,1.7984E+01,9.0232E+00,2.4705E-01,
     &5.0800E+01,3.8101E+01,2.5403E+01,1.2739E+01,2.8941E-01,
     &6.8409E+01,5.1309E+01,3.4208E+01,1.7156E+01,3.3771E-01,
     &8.8981E+01,6.6739E+01,4.4497E+01,2.2337E+01,3.9418E-01,
     &1.1252E+02,8.4389E+01,5.6260E+01,2.8284E+01,4.6348E-01/
      DATA ((KB(JS,JT,14,10),JS=1,5),JT=1,5) /
     &3.4773E+01,2.6079E+01,1.7386E+01,8.7850E+00,2.3514E-01,
     &4.8754E+01,3.6565E+01,2.4376E+01,1.2316E+01,2.9035E-01,
     &6.5535E+01,4.9151E+01,3.2769E+01,1.6566E+01,3.5401E-01,
     &8.5152E+01,6.3871E+01,4.2583E+01,2.1543E+01,4.0952E-01,
     &1.0714E+02,8.0354E+01,5.3570E+01,2.7127E+01,4.6861E-01/
      DATA ((KB(JS,JT,15,10),JS=1,5),JT=1,5) /
     &3.1708E+01,2.3780E+01,1.5854E+01,8.0780E+00,2.2725E-01,
     &4.4299E+01,3.3227E+01,2.2149E+01,1.1301E+01,2.7237E-01,
     &5.9451E+01,4.4587E+01,2.9727E+01,1.5175E+01,3.1480E-01,
     &7.6914E+01,5.7688E+01,3.8460E+01,1.9633E+01,3.5895E-01,
     &9.6187E+01,7.2137E+01,4.8097E+01,2.4537E+01,4.0136E-01/
      DATA ((KB(JS,JT,16,10),JS=1,5),JT=1,5) /
     &2.8000E+01,2.1001E+01,1.4008E+01,7.1879E+00,1.8684E-01,
     &3.8983E+01,2.9238E+01,1.9500E+01,1.0007E+01,2.3111E-01,
     &5.2090E+01,3.9071E+01,2.6063E+01,1.3380E+01,2.7168E-01,
     &6.6962E+01,5.0223E+01,3.3517E+01,1.7217E+01,3.1091E-01,
     &8.3570E+01,6.2687E+01,4.1858E+01,2.1531E+01,3.6276E-01/
      DATA ((KB(JS,JT,17,10),JS=1,5),JT=1,5) /
     &2.4264E+01,1.8198E+01,1.2195E+01,6.2664E+00,1.7021E-01,
     &3.3645E+01,2.5234E+01,1.6913E+01,8.7049E+00,1.9751E-01,
     &4.4643E+01,3.3486E+01,2.2452E+01,1.1586E+01,2.2201E-01,
     &5.7207E+01,4.2902E+01,2.8791E+01,1.4899E+01,2.5554E-01,
     &7.1193E+01,5.3402E+01,3.5856E+01,1.8608E+01,2.9547E-01/
      DATA ((KB(JS,JT,18,10),JS=1,5),JT=1,5) /
     &2.0477E+01,1.5356E+01,1.0367E+01,5.3622E+00,1.3534E-01,
     &2.8178E+01,2.1132E+01,1.4278E+01,7.4149E+00,1.5634E-01,
     &3.7210E+01,2.7911E+01,1.8862E+01,9.8384E+00,1.8020E-01,
     &4.7546E+01,3.5659E+01,2.4100E+01,1.2600E+01,2.1507E-01,
     &5.8973E+01,4.4229E+01,2.9880E+01,1.5650E+01,2.3467E-01/
      DATA ((KB(JS,JT,19,10),JS=1,5),JT=1,5) /
     &1.7373E+01,1.3040E+01,8.8390E+00,4.6588E+00,1.1972E-01,
     &2.3793E+01,1.7857E+01,1.2109E+01,6.3963E+00,1.3774E-01,
     &3.1336E+01,2.3520E+01,1.5961E+01,8.4390E+00,1.6091E-01,
     &3.9866E+01,2.9935E+01,2.0331E+01,1.0756E+01,1.7955E-01,
     &4.9495E+01,3.7175E+01,2.5257E+01,1.3339E+01,2.0663E-01/
      DATA ((KB(JS,JT,20,10),JS=1,5),JT=1,5) /
     &1.5037E+01,1.1322E+01,7.6844E+00,4.1127E+00,1.0485E-01,
     &2.0515E+01,1.5450E+01,1.0499E+01,5.6182E+00,1.2148E-01,
     &2.6886E+01,2.0252E+01,1.3792E+01,7.3741E+00,1.4561E-01,
     &3.4287E+01,2.5832E+01,1.7615E+01,9.3860E+00,1.6294E-01,
     &4.2841E+01,3.2278E+01,2.2023E+01,1.1711E+01,1.8624E-01/
      DATA ((KB(JS,JT,21,10),JS=1,5),JT=1,5) /
     &1.3152E+01,9.9438E+00,6.7780E+00,3.6471E+00,9.1853E-02,
     &1.7866E+01,1.3511E+01,9.2298E+00,4.9595E+00,1.1141E-01,
     &2.3469E+01,1.7747E+01,1.2135E+01,6.5086E+00,1.2785E-01,
     &3.0120E+01,2.2761E+01,1.5567E+01,8.3305E+00,1.5176E-01,
     &3.7884E+01,2.8609E+01,1.9560E+01,1.0448E+01,1.7309E-01/
      DATA ((KB(JS,JT,22,10),JS=1,5),JT=1,5) /
     &1.1757E+01,8.9118E+00,6.1382E+00,3.3115E+00,8.1057E-02,
     &1.5980E+01,1.2109E+01,8.3336E+00,4.4832E+00,9.8906E-02,
     &2.1108E+01,1.5991E+01,1.0992E+01,5.8971E+00,1.1586E-01,
     &2.7285E+01,2.0659E+01,1.4174E+01,7.5863E+00,1.3507E-01,
     &3.4676E+01,2.6248E+01,1.7966E+01,9.5810E+00,1.5851E-01/
      DATA ((KB(JS,JT,23,10),JS=1,5),JT=1,5) /
     &1.0481E+01,7.9685E+00,5.5490E+00,2.9996E+00,7.4309E-02,
     &1.4420E+01,1.0955E+01,7.5878E+00,4.0805E+00,8.6253E-02,
     &1.9219E+01,1.4600E+01,1.0073E+01,5.3977E+00,1.0580E-01,
     &2.5108E+01,1.9069E+01,1.3115E+01,7.0020E+00,1.2265E-01,
     &3.2043E+01,2.4337E+01,1.6704E+01,8.8942E+00,1.4381E-01/
      DATA ((KB(JS,JT,24,10),JS=1,5),JT=1,5) /
     &9.5276E+00,7.2768E+00,5.0826E+00,2.7465E+00,6.4655E-02,
     &1.3271E+01,1.0121E+01,7.0214E+00,3.7657E+00,7.9291E-02,
     &1.7863E+01,1.3622E+01,9.4201E+00,5.0307E+00,9.5461E-02,
     &2.3325E+01,1.7783E+01,1.2273E+01,6.5420E+00,1.1274E-01,
     &2.9564E+01,2.2536E+01,1.5537E+01,8.2816E+00,1.3418E-01/
      DATA ((KB(JS,JT,25,10),JS=1,5),JT=1,5) /
     &8.8160E+00,6.7673E+00,4.7220E+00,2.5379E+00,5.8489E-02,
     &1.2357E+01,9.4685E+00,6.5735E+00,3.5130E+00,7.2064E-02,
     &1.6557E+01,1.2678E+01,8.7976E+00,4.6917E+00,8.6281E-02,
     &2.1444E+01,1.6408E+01,1.1376E+01,6.0717E+00,1.0416E-01,
     &2.7072E+01,2.0703E+01,1.4347E+01,7.6551E+00,1.2572E-01/
      DATA ((KB(JS,JT,26,10),JS=1,5),JT=1,5) /
     &8.2437E+00,6.3645E+00,4.4442E+00,2.3799E+00,5.3046E-02,
     &1.1483E+01,8.8437E+00,6.1605E+00,3.2883E+00,6.5278E-02,
     &1.5261E+01,1.1739E+01,8.1695E+00,4.3593E+00,8.0191E-02,
     &1.9700E+01,1.5135E+01,1.0534E+01,5.6197E+00,9.7601E-02,
     &2.4857E+01,1.9072E+01,1.3248E+01,7.0653E+00,1.1704E-01/
      DATA ((KB(JS,JT,27,10),JS=1,5),JT=1,5) /
     &7.7081E+00,5.9885E+00,4.1814E+00,2.2306E+00,4.7409E-02,
     &1.0576E+01,8.1915E+00,5.7182E+00,3.0504E+00,5.8512E-02,
     &1.4014E+01,1.0837E+01,7.5629E+00,4.0315E+00,7.3955E-02,
     &1.8113E+01,1.3973E+01,9.7390E+00,5.1847E+00,9.0794E-02,
     &2.2862E+01,1.7593E+01,1.2246E+01,6.5228E+00,1.0871E-01/
      DATA ((KB(JS,JT,28,10),JS=1,5),JT=1,5) /
     &7.2063E+00,5.6196E+00,3.9203E+00,2.0882E+00,4.3129E-02,
     &9.7817E+00,7.6085E+00,5.3084E+00,2.8196E+00,5.4812E-02,
     &1.2904E+01,1.0029E+01,7.0025E+00,3.7236E+00,6.8395E-02,
     &1.6696E+01,1.2935E+01,9.0135E+00,4.7943E+00,8.2716E-02,
     &2.1096E+01,1.6309E+01,1.1368E+01,6.0506E+00,9.9935E-02/
      DATA ((KB(JS,JT,29,10),JS=1,5),JT=1,5) /
     &6.7278E+00,5.2636E+00,3.6717E+00,1.9437E+00,3.9266E-02,
     &9.0515E+00,7.0710E+00,4.9355E+00,2.6130E+00,4.9834E-02,
     &1.1919E+01,9.2978E+00,6.4770E+00,3.4412E+00,6.2077E-02,
     &1.5380E+01,1.1978E+01,8.3499E+00,4.4362E+00,7.6798E-02,
     &1.9420E+01,1.5097E+01,1.0536E+01,5.6045E+00,9.1669E-02/
      DATA ((KB(JS,JT,30,10),JS=1,5),JT=1,5) /
     &6.2882E+00,4.9355E+00,3.4323E+00,1.8115E+00,3.5713E-02,
     &8.4169E+00,6.5906E+00,4.5841E+00,2.4262E+00,4.5752E-02,
     &1.1024E+01,8.6363E+00,6.0145E+00,3.1864E+00,5.7473E-02,
     &1.4192E+01,1.1103E+01,7.7439E+00,4.1120E+00,7.0729E-02,
     &1.7890E+01,1.3978E+01,9.7651E+00,5.1860E+00,8.5534E-02/
      DATA ((KB(JS,JT,31,10),JS=1,5),JT=1,5) /
     &5.8439E+00,4.6051E+00,3.1957E+00,1.6863E+00,3.2654E-02,
     &7.8033E+00,6.1378E+00,4.2622E+00,2.2515E+00,4.2183E-02,
     &1.0196E+01,8.0235E+00,5.5836E+00,2.9533E+00,5.3011E-02,
     &1.3072E+01,1.0286E+01,7.1778E+00,3.8005E+00,6.4875E-02,
     &1.6463E+01,1.2924E+01,9.0292E+00,4.7849E+00,7.7772E-02/
      DATA ((KB(JS,JT,32,10),JS=1,5),JT=1,5) /
     &5.4664E+00,4.3291E+00,2.9999E+00,1.5808E+00,2.9923E-02,
     &7.2874E+00,5.7710E+00,4.0068E+00,2.1122E+00,3.8267E-02,
     &9.5041E+00,7.5231E+00,5.2374E+00,2.7661E+00,4.7331E-02,
     &1.2176E+01,9.6156E+00,6.7066E+00,3.5449E+00,5.8625E-02,
     &1.5322E+01,1.2084E+01,8.4483E+00,4.4709E+00,6.9340E-02/
      DATA ((KB(JS,JT,33,10),JS=1,5),JT=1,5) /
     &5.1512E+00,4.0967E+00,2.8362E+00,1.4933E+00,2.6393E-02,
     &6.8599E+00,5.4552E+00,3.7902E+00,1.9993E+00,3.4040E-02,
     &8.9395E+00,7.1038E+00,4.9489E+00,2.6104E+00,4.2820E-02,
     &1.1449E+01,9.0816E+00,6.3367E+00,3.3421E+00,5.1919E-02,
     &1.4423E+01,1.1426E+01,7.9850E+00,4.2179E+00,6.2402E-02/
      DATA ((KB(JS,JT,34,10),JS=1,5),JT=1,5) /
     &4.8646E+00,3.8880E+00,2.6932E+00,1.4194E+00,2.3781E-02,
     &6.4672E+00,5.1782E+00,3.6018E+00,1.8962E+00,3.0492E-02,
     &8.4535E+00,6.7497E+00,4.7054E+00,2.4770E+00,3.8339E-02,
     &1.0856E+01,8.6484E+00,6.0350E+00,3.1793E+00,4.6570E-02,
     &1.3723E+01,1.0909E+01,7.6246E+00,4.0214E+00,5.6226E-02/
      DATA ((KB(JS,JT,35,10),JS=1,5),JT=1,5) /
     &4.4902E+00,3.6079E+00,2.5027E+00,1.3156E+00,2.1238E-02,
     &5.9918E+00,4.8154E+00,3.3497E+00,1.7639E+00,2.7153E-02,
     &7.8693E+00,6.3098E+00,4.3964E+00,2.3124E+00,3.3573E-02,
     &1.0156E+01,8.1193E+00,5.6658E+00,2.9812E+00,4.1298E-02,
     &1.2867E+01,1.0277E+01,7.1860E+00,3.7872E+00,4.9619E-02/
      DATA ((KB(JS,JT,36,10),JS=1,5),JT=1,5) /
     &4.0317E+00,3.2575E+00,2.2591E+00,1.1864E+00,1.8322E-02,
     &5.4230E+00,4.3764E+00,3.0444E+00,1.6008E+00,2.3437E-02,
     &7.1807E+00,5.7770E+00,4.0236E+00,2.1147E+00,2.8934E-02,
     &9.3214E+00,7.4860E+00,5.2247E+00,2.7453E+00,3.5476E-02,
     &1.1871E+01,9.5152E+00,6.6538E+00,3.5057E+00,4.2476E-02/
      DATA ((KB(JS,JT,37,10),JS=1,5),JT=1,5) /
     &3.4945E+00,2.8322E+00,1.9642E+00,1.0316E+00,1.5292E-02,
     &4.7474E+00,3.8477E+00,2.6749E+00,1.4057E+00,1.9829E-02,
     &6.3563E+00,5.1351E+00,3.5754E+00,1.8774E+00,2.4925E-02,
     &8.3333E+00,6.7182E+00,4.6872E+00,2.4610E+00,3.0513E-02,
     &1.0705E+01,8.6094E+00,6.0143E+00,3.1664E+00,3.6834E-02/
      DATA ((KB(JS,JT,38,10),JS=1,5),JT=1,5) /
     &3.0288E+00,2.4619E+00,1.7084E+00,8.9674E-01,1.2715E-02,
     &4.1608E+00,3.3834E+00,2.3515E+00,1.2353E+00,1.6555E-02,
     &5.6346E+00,4.5721E+00,3.1807E+00,1.6688E+00,2.1253E-02,
     &7.4639E+00,6.0370E+00,4.2092E+00,2.2090E+00,2.6215E-02,
     &9.6723E+00,7.8054E+00,5.4498E+00,2.8669E+00,3.1673E-02/
      DATA ((KB(JS,JT,39,10),JS=1,5),JT=1,5) /
     &2.6346E+00,2.1501E+00,1.4897E+00,7.8179E-01,1.0494E-02,
     &3.6623E+00,2.9868E+00,2.0748E+00,1.0900E+00,1.3801E-02,
     &5.0149E+00,4.0819E+00,2.8376E+00,1.4889E+00,1.7948E-02,
     &6.7074E+00,5.4432E+00,3.7906E+00,1.9883E+00,2.2190E-02,
     &8.7675E+00,7.1019E+00,4.9572E+00,2.6054E+00,2.6961E-02/
      DATA ((KB(JS,JT,40,10),JS=1,5),JT=1,5) /
     &2.2414E+00,1.8312E+00,1.2669E+00,6.6464E-01,8.6033E-03,
     &3.1461E+00,2.5731E+00,1.7855E+00,9.3826E-01,1.1425E-02,
     &4.3645E+00,3.5639E+00,2.4772E+00,1.3001E+00,1.5150E-02,
     &5.9195E+00,4.8196E+00,3.3561E+00,1.7603E+00,1.8984E-02,
     &7.8344E+00,6.3662E+00,4.4409E+00,2.3324E+00,2.3286E-02/
      DATA ((KB(JS,JT,41,10),JS=1,5),JT=1,5) /
     &1.9009E+00,1.5581E+00,1.0772E+00,5.6390E-01,7.0145E-03,
     &2.6997E+00,2.2094E+00,1.5334E+00,8.0488E-01,9.5005E-03,
     &3.7885E+00,3.1035E+00,2.1567E+00,1.1320E+00,1.2665E-02,
     &5.2083E+00,4.2587E+00,2.9632E+00,1.5552E+00,1.6096E-02,
     &6.9899E+00,5.6957E+00,3.9715E+00,2.0851E+00,2.0007E-02/
      DATA ((KB(JS,JT,42,10),JS=1,5),JT=1,5) /
     &1.6073E+00,1.3214E+00,9.1410E-01,4.7869E-01,5.6658E-03,
     &2.3166E+00,1.9016E+00,1.3175E+00,6.9100E-01,7.8082E-03,
     &3.2935E+00,2.7045E+00,1.8773E+00,9.8575E-01,1.0484E-02,
     &4.5881E+00,3.7639E+00,2.6177E+00,1.3737E+00,1.3601E-02,
     &6.2370E+00,5.0967E+00,3.5534E+00,1.8654E+00,1.7039E-02/
      DATA ((KB(JS,JT,43,10),JS=1,5),JT=1,5) /
     &1.3404E+00,1.1058E+00,7.6461E-01,4.0031E-01,4.4847E-03,
     &1.9669E+00,1.6173E+00,1.1194E+00,5.8704E-01,6.2717E-03,
     &2.8361E+00,2.3337E+00,1.6185E+00,8.4949E-01,8.5308E-03,
     &4.0094E+00,3.2948E+00,2.2900E+00,1.2020E+00,1.1259E-02,
     &5.5262E+00,4.5280E+00,3.1542E+00,1.6556E+00,1.4384E-02/
      DATA ((KB(JS,JT,44,10),JS=1,5),JT=1,5) /
     &1.1066E+00,9.1547E-01,6.3275E-01,3.3150E-01,3.4897E-03,
     &1.6542E+00,1.3635E+00,9.4399E-01,4.9494E-01,4.9430E-03,
     &2.4266E+00,2.0020E+00,1.3887E+00,7.2847E-01,6.8682E-03,
     &3.4886E+00,2.8708E+00,1.9931E+00,1.0459E+00,9.1381E-03,
     &4.8773E+00,4.0046E+00,2.7873E+00,1.4630E+00,1.1960E-02/
      DATA ((KB(JS,JT,45,10),JS=1,5),JT=1,5) /
     &9.0739E-01,7.5424E-01,5.2128E-01,2.7273E-01,2.7098E-03,
     &1.3852E+00,1.1467E+00,7.9304E-01,4.1578E-01,3.8548E-03,
     &2.0713E+00,1.7151E+00,1.1892E+00,6.2426E-01,5.4604E-03,
     &3.0326E+00,2.5006E+00,1.7345E+00,9.0988E-01,7.3887E-03,
     &4.3008E+00,3.5387E+00,2.4612E+00,1.2914E+00,9.7321E-03/
      DATA ((KB(JS,JT,46,10),JS=1,5),JT=1,5) /
     &7.3199E-01,6.1145E-01,4.2240E-01,2.2117E-01,2.0785E-03,
     &1.1438E+00,9.5098E-01,6.5833E-01,3.4471E-01,2.9805E-03,
     &1.7481E+00,1.4525E+00,1.0068E+00,5.2845E-01,4.2717E-03,
     &2.6098E+00,2.1582E+00,1.4963E+00,7.8501E-01,5.8631E-03,
     &3.7663E+00,3.1031E+00,2.1564E+00,1.1312E+00,7.7831E-03/
      DATA ((KB(JS,JT,47,10),JS=1,5),JT=1,5) /
     &5.7232E-01,4.8032E-01,3.3210E-01,1.7403E-01,1.5461E-03,
     &9.2386E-01,7.7116E-01,5.3364E-01,2.7934E-01,2.3209E-03,
     &1.4429E+00,1.2024E+00,8.3406E-01,4.3757E-01,3.2763E-03,
     &2.2047E+00,1.8273E+00,1.2675E+00,6.6495E-01,4.5628E-03,
     &3.2456E+00,2.6812E+00,1.8614E+00,9.7623E-01,6.1070E-03/
      DATA ((KB(JS,JT,48,10),JS=1,5),JT=1,5) /
     &4.4270E-01,3.7313E-01,2.5809E-01,1.3535E-01,1.1374E-03,
     &7.3749E-01,6.1935E-01,4.2906E-01,2.2453E-01,1.7379E-03,
     &1.1839E+00,9.8928E-01,6.8613E-01,3.6002E-01,2.5032E-03,
     &1.8512E+00,1.5395E+00,1.0677E+00,5.6075E-01,3.5238E-03,
     &2.7862E+00,2.3065E+00,1.6009E+00,8.3981E-01,4.7398E-03/
      DATA ((KB(JS,JT,49,10),JS=1,5),JT=1,5) /
     &3.3829E-01,2.8482E-01,1.9699E-01,1.0339E-01,8.1861E-04,
     &5.8200E-01,4.9068E-01,3.4013E-01,1.7816E-01,1.2634E-03,
     &9.6365E-01,8.0857E-01,5.6081E-01,2.9418E-01,1.8795E-03,
     &1.5457E+00,1.2894E+00,8.9458E-01,4.6973E-01,2.7104E-03,
     &2.3812E+00,1.9755E+00,1.3708E+00,7.1925E-01,3.6105E-03/
      DATA ((KB(JS,JT,50,10),JS=1,5),JT=1,5) /
     &2.5998E-01,2.1962E-01,1.5188E-01,7.9506E-02,6.0363E-04,
     &4.5974E-01,3.8940E-01,2.6982E-01,1.4155E-01,9.5023E-04,
     &7.8578E-01,6.6189E-01,4.5931E-01,2.4091E-01,1.4366E-03,
     &1.2930E+00,1.0829E+00,7.5147E-01,3.9450E-01,2.1250E-03,
     &2.0418E+00,1.6990E+00,1.1790E+00,6.1880E-01,2.8716E-03/
      DATA ((KB(JS,JT,51,10),JS=1,5),JT=1,5) /
     &2.0132E-01,1.6910E-01,1.1674E-01,6.1107E-02,4.4485E-04,
     &3.6041E-01,3.0656E-01,2.1282E-01,1.1161E-01,7.3157E-04,
     &6.3582E-01,5.3869E-01,3.7423E-01,1.9656E-01,1.1225E-03,
     &1.0802E+00,9.0777E-01,6.3030E-01,3.3074E-01,1.6531E-03,
     &1.7498E+00,1.4602E+00,1.0135E+00,5.3219E-01,2.3172E-03/
      DATA ((KB(JS,JT,52,10),JS=1,5),JT=1,5) /
     &1.5547E-01,1.3052E-01,9.0061E-02,4.7075E-02,3.3160E-04,
     &2.8347E-01,2.4049E-01,1.6666E-01,8.7433E-02,5.5078E-04,
     &5.1184E-01,4.3501E-01,3.0211E-01,1.5868E-01,8.7008E-04,
     &8.9697E-01,7.5690E-01,5.2561E-01,2.7576E-01,1.2672E-03,
     &1.4927E+00,1.2493E+00,8.6741E-01,4.5551E-01,1.8458E-03/
      DATA ((KB(JS,JT,53,10),JS=1,5),JT=1,5) /
     &1.2003E-01,1.0051E-01,6.9268E-02,3.6248E-02,2.4457E-04,
     &2.2120E-01,1.8754E-01,1.2989E-01,6.8226E-02,4.0791E-04,
     &4.0694E-01,3.4775E-01,2.4176E-01,1.2712E-01,6.5057E-04,
     &7.3824E-01,6.2670E-01,4.3556E-01,2.2862E-01,9.8738E-04,
     &1.2666E+00,1.0632E+00,7.3852E-01,3.8765E-01,1.4077E-03/
      DATA ((KB(JS,JT,54,10),JS=1,5),JT=1,5) /
     &9.3960E-02,7.8771E-02,5.4240E-02,2.8401E-02,1.9316E-04,
     &1.7676E-01,1.4984E-01,1.0336E-01,5.4121E-02,3.1568E-04,
     &3.2867E-01,2.7969E-01,1.9447E-01,1.0231E-01,5.2512E-04,
     &6.0965E-01,5.1980E-01,3.6169E-01,1.9003E-01,8.0976E-04,
     &1.0822E+00,9.1223E-01,6.3374E-01,3.3269E-01,1.1750E-03/
      DATA ((KB(JS,JT,55,10),JS=1,5),JT=1,5) /
     &7.3906E-02,6.2107E-02,4.2864E-02,2.2445E-02,1.5599E-04,
     &1.4369E-01,1.2050E-01,8.3134E-02,4.3567E-02,2.5335E-04,
     &2.6760E-01,2.2827E-01,1.5835E-01,8.3096E-02,4.2909E-04,
     &5.0351E-01,4.3105E-01,3.0006E-01,1.5782E-01,6.9202E-04,
     &9.2458E-01,7.8288E-01,5.4396E-01,2.8582E-01,1.0207E-03/
      DATA ((KB(JS,JT,56,10),JS=1,5),JT=1,5) /
     &5.7777E-02,4.8496E-02,3.3489E-02,1.7579E-02,1.2442E-04,
     &1.1665E-01,9.7805E-02,6.7433E-02,3.5342E-02,2.0689E-04,
     &2.1880E-01,1.8636E-01,1.2905E-01,6.7804E-02,3.5149E-04,
     &4.1579E-01,3.5633E-01,2.4779E-01,1.3043E-01,5.7437E-04,
     &7.8392E-01,6.6810E-01,4.6498E-01,2.4434E-01,8.7392E-04/
      DATA ((KB(JS,JT,57,10),JS=1,5),JT=1,5) /
     &4.4962E-02,3.7745E-02,2.6020E-02,1.3669E-02,1.0074E-04,
     &9.3975E-02,7.9039E-02,5.4468E-02,2.8583E-02,1.6888E-04,
     &1.8083E-01,1.5305E-01,1.0598E-01,5.5519E-02,2.8180E-04,
     &3.4541E-01,2.9431E-01,2.0476E-01,1.0780E-01,4.7931E-04,
     &6.6212E-01,5.6589E-01,3.9390E-01,2.0726E-01,7.5979E-04/
      DATA ((KB(JS,JT,58,10),JS=1,5),JT=1,5) /
     &1.7062E-02,1.6422E-02,1.3301E-02,8.4676E-03,8.2142E-05,
     &3.7044E-02,3.5791E-02,2.8933E-02,1.8344E-02,1.3979E-04,
     &7.3627E-02,7.1176E-02,5.7648E-02,3.6534E-02,2.3072E-04,
     &1.4036E-01,1.3776E-01,1.1219E-01,7.1459E-02,4.0521E-04,
     &2.7375E-01,2.6857E-01,2.1925E-01,1.3965E-01,6.6868E-04/
      DATA ((KB(JS,JT,59,10),JS=1,5),JT=1,5) /
     &1.5026E-02,1.4620E-02,1.1891E-02,7.6139E-03,7.7772E-05,
     &3.3598E-02,3.2618E-02,2.6475E-02,1.6873E-02,1.3363E-04,
     &6.7778E-02,6.5724E-02,5.3548E-02,3.4085E-02,2.3127E-04,
     &1.2973E-01,1.2749E-01,1.0439E-01,6.6705E-02,3.9949E-04,
     &2.5383E-01,2.5006E-01,2.0520E-01,1.3156E-01,6.6551E-04/
      DATA ((KB(JS,JT,13,11),JS=1,5),JT=1,5) /
     &6.1162E+01,4.5871E+01,3.0581E+01,1.5291E+01,3.0501E-01,
     &8.6643E+01,6.4984E+01,4.3324E+01,2.1662E+01,3.8069E-01,
     &1.1700E+02,8.7751E+01,5.8502E+01,2.9250E+01,4.9491E-01,
     &1.5190E+02,1.1392E+02,7.5955E+01,3.7977E+01,5.7908E-01,
     &1.9085E+02,1.4314E+02,9.5429E+01,4.7715E+01,6.6979E-01/
      DATA ((KB(JS,JT,14,11),JS=1,5),JT=1,5) /
     &6.2014E+01,4.6511E+01,3.1007E+01,1.5504E+01,3.5592E-01,
     &8.7238E+01,6.5431E+01,4.3621E+01,2.1811E+01,3.9219E-01,
     &1.1714E+02,8.7851E+01,5.8570E+01,2.9287E+01,4.4292E-01,
     &1.5139E+02,1.1354E+02,7.5699E+01,3.7864E+01,5.2460E-01,
     &1.8982E+02,1.4235E+02,9.4908E+01,4.7484E+01,6.6257E-01/
      DATA ((KB(JS,JT,15,11),JS=1,5),JT=1,5) /
     &5.9186E+01,4.4388E+01,2.9592E+01,1.4841E+01,3.2021E-01,
     &8.2638E+01,6.1979E+01,4.1319E+01,2.0713E+01,3.7708E-01,
     &1.1028E+02,8.2716E+01,5.5144E+01,2.7652E+01,4.6488E-01,
     &1.4201E+02,1.0651E+02,7.1008E+01,3.5635E+01,5.3643E-01,
     &1.7780E+02,1.3336E+02,8.8908E+01,4.4680E+01,6.1809E-01/
      DATA ((KB(JS,JT,16,11),JS=1,5),JT=1,5) /
     &5.3877E+01,4.0407E+01,2.6940E+01,1.3617E+01,3.0459E-01,
     &7.4732E+01,5.6052E+01,3.7368E+01,1.8895E+01,3.6381E-01,
     &9.9303E+01,7.4473E+01,4.9649E+01,2.5124E+01,4.2325E-01,
     &1.2768E+02,9.5754E+01,6.3837E+01,3.2325E+01,4.7285E-01,
     &1.5927E+02,1.1945E+02,7.9632E+01,4.0351E+01,5.0976E-01/
      DATA ((KB(JS,JT,17,11),JS=1,5),JT=1,5) /
     &4.7648E+01,3.5735E+01,2.3823E+01,1.2164E+01,2.5744E-01,
     &6.5724E+01,4.9293E+01,3.2863E+01,1.6792E+01,3.1059E-01,
     &8.7138E+01,6.5349E+01,4.3569E+01,2.2270E+01,3.5847E-01,
     &1.1169E+02,8.3769E+01,5.5845E+01,2.8543E+01,4.0184E-01,
     &1.3846E+02,1.0385E+02,6.9237E+01,3.5386E+01,4.6254E-01/
      DATA ((KB(JS,JT,18,11),JS=1,5),JT=1,5) /
     &4.0731E+01,3.0550E+01,2.0398E+01,1.0482E+01,2.2929E-01,
     &5.6038E+01,4.2027E+01,2.8058E+01,1.4421E+01,2.6841E-01,
     &7.4130E+01,5.5602E+01,3.7127E+01,1.9095E+01,3.0083E-01,
     &9.4414E+01,7.0811E+01,4.7323E+01,2.4371E+01,3.4142E-01,
     &1.1687E+02,8.7655E+01,5.8604E+01,3.0228E+01,3.9932E-01/
      DATA ((KB(JS,JT,19,11),JS=1,5),JT=1,5) /
     &3.5043E+01,2.6281E+01,1.7645E+01,9.0880E+00,1.9041E-01,
     &4.8095E+01,3.6072E+01,2.4224E+01,1.2500E+01,2.2005E-01,
     &6.3280E+01,4.7465E+01,3.1884E+01,1.6505E+01,2.5190E-01,
     &8.0459E+01,6.0352E+01,4.0562E+01,2.1050E+01,3.0347E-01,
     &9.9405E+01,7.4555E+01,5.0141E+01,2.6072E+01,3.3814E-01/
      DATA ((KB(JS,JT,20,11),JS=1,5),JT=1,5) /
     &3.0698E+01,2.3028E+01,1.5559E+01,8.0744E+00,1.6851E-01,
     &4.1938E+01,3.1449E+01,2.1266E+01,1.1075E+01,1.9604E-01,
     &5.4971E+01,4.1226E+01,2.7873E+01,1.4553E+01,2.3334E-01,
     &6.9683E+01,5.2264E+01,3.5322E+01,1.8474E+01,2.8155E-01,
     &8.5796E+01,6.4350E+01,4.3496E+01,2.2781E+01,3.1819E-01/
      DATA ((KB(JS,JT,21,11),JS=1,5),JT=1,5) /
     &2.6961E+01,2.0239E+01,1.3721E+01,7.2357E+00,1.5633E-01,
     &3.6624E+01,2.7486E+01,1.8642E+01,9.8382E+00,1.8477E-01,
     &4.7842E+01,3.5913E+01,2.4362E+01,1.2852E+01,2.2793E-01,
     &6.0403E+01,4.5355E+01,3.0794E+01,1.6247E+01,2.5875E-01,
     &7.4328E+01,5.5827E+01,3.7921E+01,1.9978E+01,3.0003E-01/
      DATA ((KB(JS,JT,22,11),JS=1,5),JT=1,5) /
     &2.4106E+01,1.8145E+01,1.2318E+01,6.5788E+00,1.4346E-01,
     &3.2489E+01,2.4455E+01,1.6620E+01,8.8645E+00,1.7673E-01,
     &4.2111E+01,3.1704E+01,2.1585E+01,1.1502E+01,2.1135E-01,
     &5.3091E+01,3.9979E+01,2.7248E+01,1.4479E+01,2.4545E-01,
     &6.5531E+01,4.9344E+01,3.3661E+01,1.7840E+01,2.8184E-01/
      DATA ((KB(JS,JT,23,11),JS=1,5),JT=1,5) /
     &2.1586E+01,1.6314E+01,1.1115E+01,5.9696E+00,1.3118E-01,
     &2.8872E+01,2.1824E+01,1.4900E+01,7.9884E+00,1.6791E-01,
     &3.7392E+01,2.8256E+01,1.9318E+01,1.0333E+01,1.9239E-01,
     &4.7286E+01,3.5715E+01,2.4417E+01,1.3025E+01,2.2854E-01,
     &5.8587E+01,4.4225E+01,3.0228E+01,1.6103E+01,2.6383E-01/
      DATA ((KB(JS,JT,24,11),JS=1,5),JT=1,5) /
     &1.9610E+01,1.4859E+01,1.0204E+01,5.4843E+00,1.2305E-01,
     &2.6168E+01,1.9825E+01,1.3617E+01,7.3028E+00,1.4696E-01,
     &3.4009E+01,2.5754E+01,1.7666E+01,9.4475E+00,1.7619E-01,
     &4.3202E+01,3.2697E+01,2.2398E+01,1.1966E+01,2.0711E-01,
     &5.3950E+01,4.0810E+01,2.7914E+01,1.4881E+01,2.4491E-01/
      DATA ((KB(JS,JT,25,11),JS=1,5),JT=1,5) /
     &1.7913E+01,1.3599E+01,9.4137E+00,5.0616E+00,1.1244E-01,
     &2.4002E+01,1.8218E+01,1.2577E+01,6.7433E+00,1.3574E-01,
     &3.1373E+01,2.3808E+01,1.6390E+01,8.7732E+00,1.6587E-01,
     &4.0212E+01,3.0510E+01,2.0949E+01,1.1182E+01,1.9353E-01,
     &5.0507E+01,3.8314E+01,2.6252E+01,1.3993E+01,2.2689E-01/
      DATA ((KB(JS,JT,26,11),JS=1,5),JT=1,5) /
     &1.6610E+01,1.2648E+01,8.7899E+00,4.7180E+00,1.0410E-01,
     &2.2395E+01,1.7048E+01,1.1804E+01,6.3257E+00,1.2812E-01,
     &2.9495E+01,2.2453E+01,1.5498E+01,8.2851E+00,1.5321E-01,
     &3.7868E+01,2.8829E+01,1.9854E+01,1.0593E+01,1.8381E-01,
     &4.7321E+01,3.6030E+01,2.4795E+01,1.3247E+01,2.1577E-01/
      DATA ((KB(JS,JT,27,11),JS=1,5),JT=1,5) /
     &1.5552E+01,1.1893E+01,8.2787E+00,4.4401E+00,9.5478E-02,
     &2.1129E+01,1.6157E+01,1.1211E+01,5.9970E+00,1.1930E-01,
     &2.7798E+01,2.1248E+01,1.4714E+01,7.8588E+00,1.4147E-01,
     &3.5437E+01,2.7084E+01,1.8740E+01,1.0024E+01,1.6966E-01,
     &4.4196E+01,3.3778E+01,2.3350E+01,1.2494E+01,2.0142E-01/
      DATA ((KB(JS,JT,28,11),JS=1,5),JT=1,5) /
     &1.4683E+01,1.1292E+01,7.8718E+00,4.2106E+00,8.7356E-02,
     &1.9886E+01,1.5281E+01,1.0638E+01,5.6861E+00,1.0714E-01,
     &2.5973E+01,1.9937E+01,1.3871E+01,7.4210E+00,1.3061E-01,
     &3.3032E+01,2.5345E+01,1.7630E+01,9.4399E+00,1.5744E-01,
     &4.1210E+01,3.1582E+01,2.1933E+01,1.1759E+01,1.8456E-01/
      DATA ((KB(JS,JT,29,11),JS=1,5),JT=1,5) /
     &1.3790E+01,1.0662E+01,7.4451E+00,3.9766E+00,7.8021E-02,
     &1.8507E+01,1.4288E+01,9.9758E+00,5.3363E+00,9.5820E-02,
     &2.4091E+01,1.8575E+01,1.2977E+01,6.9398E+00,1.1898E-01,
     &3.0652E+01,2.3593E+01,1.6474E+01,8.8251E+00,1.4373E-01,
     &3.8268E+01,2.9419E+01,2.0534E+01,1.1026E+01,1.6837E-01/
      DATA ((KB(JS,JT,30,11),JS=1,5),JT=1,5) /
     &1.2835E+01,9.9842E+00,6.9893E+00,3.7286E+00,6.9765E-02,
     &1.7126E+01,1.3305E+01,9.3238E+00,4.9785E+00,8.7990E-02,
     &2.2319E+01,1.7278E+01,1.2100E+01,6.4728E+00,1.0830E-01,
     &2.8412E+01,2.1956E+01,1.5383E+01,8.2493E+00,1.2854E-01,
     &3.5540E+01,2.7422E+01,1.9221E+01,1.0332E+01,1.5041E-01/
      DATA ((KB(JS,JT,31,11),JS=1,5),JT=1,5) /
     &1.1866E+01,9.2840E+00,6.5153E+00,3.4693E+00,6.2880E-02,
     &1.5808E+01,1.2342E+01,8.6596E+00,4.6193E+00,7.8616E-02,
     &2.0587E+01,1.6022E+01,1.1250E+01,6.0171E+00,9.4908E-02,
     &2.6251E+01,2.0378E+01,1.4318E+01,7.6818E+00,1.1384E-01,
     &3.2893E+01,2.5487E+01,1.7928E+01,9.6467E+00,1.3241E-01/
      DATA ((KB(JS,JT,32,11),JS=1,5),JT=1,5) /
     &1.1095E+01,8.7224E+00,6.1226E+00,3.2519E+00,5.6839E-02,
     &1.4751E+01,1.1560E+01,8.1226E+00,4.3325E+00,7.0855E-02,
     &1.9205E+01,1.5015E+01,1.0554E+01,5.6424E+00,8.5721E-02,
     &2.4504E+01,1.9119E+01,1.3461E+01,7.2214E+00,1.0137E-01,
     &3.0723E+01,2.3918E+01,1.6887E+01,9.0922E+00,1.2101E-01/
      DATA ((KB(JS,JT,33,11),JS=1,5),JT=1,5) /
     &1.0469E+01,8.2653E+00,5.8027E+00,3.0803E+00,5.1389E-02,
     &1.3905E+01,1.0963E+01,7.7038E+00,4.0998E+00,6.3408E-02,
     &1.8080E+01,1.4209E+01,9.9969E+00,5.3421E+00,7.7128E-02,
     &2.3055E+01,1.8085E+01,1.2765E+01,6.8504E+00,9.2141E-02,
     &2.8901E+01,2.2629E+01,1.6031E+01,8.6400E+00,1.0949E-01/
      DATA ((KB(JS,JT,34,11),JS=1,5),JT=1,5) /
     &9.9524E+00,7.8988E+00,5.5437E+00,2.9382E+00,4.7321E-02,
     &1.3224E+01,1.0461E+01,7.3463E+00,3.9087E+00,5.8418E-02,
     &1.7166E+01,1.3560E+01,9.5537E+00,5.1034E+00,7.0181E-02,
     &2.1887E+01,1.7264E+01,1.2211E+01,6.5526E+00,8.4706E-02,
     &2.7487E+01,2.1622E+01,1.5350E+01,8.2698E+00,9.8588E-02/
      DATA ((KB(JS,JT,35,11),JS=1,5),JT=1,5) /
     &9.2896E+00,7.3988E+00,5.1836E+00,2.7478E+00,4.1417E-02,
     &1.2346E+01,9.8120E+00,6.8895E+00,3.6621E+00,5.1614E-02,
     &1.6038E+01,1.2737E+01,8.9856E+00,4.7992E+00,6.2173E-02,
     &2.0501E+01,1.6246E+01,1.1507E+01,6.1715E+00,7.4346E-02,
     &2.5865E+01,2.0429E+01,1.4515E+01,7.8139E+00,8.6989E-02/
      DATA ((KB(JS,JT,36,11),JS=1,5),JT=1,5) /
     &8.4641E+00,6.7680E+00,4.7384E+00,2.5089E+00,3.5370E-02,
     &1.1283E+01,9.0077E+00,6.3272E+00,3.3586E+00,4.3427E-02,
     &1.4709E+01,1.1740E+01,8.2852E+00,4.4192E+00,5.3699E-02,
     &1.8892E+01,1.5035E+01,1.0652E+01,5.7082E+00,6.4287E-02,
     &2.3976E+01,1.9028E+01,1.3526E+01,7.2706E+00,7.5870E-02/
      DATA ((KB(JS,JT,37,11),JS=1,5),JT=1,5) /
     &7.4506E+00,5.9897E+00,4.1905E+00,2.2153E+00,2.9963E-02,
     &1.0029E+01,8.0389E+00,5.6426E+00,2.9898E+00,3.7220E-02,
     &1.3144E+01,1.0534E+01,7.4309E+00,3.9559E+00,4.6416E-02,
     &1.6999E+01,1.3585E+01,9.6217E+00,5.1490E+00,5.5486E-02,
     &2.1741E+01,1.7327E+01,1.2322E+01,6.6152E+00,6.5816E-02/
      DATA ((KB(JS,JT,38,11),JS=1,5),JT=1,5) /
     &6.5566E+00,5.3014E+00,3.7057E+00,1.9579E+00,2.5356E-02,
     &8.9151E+00,7.1841E+00,5.0400E+00,2.6656E+00,3.1891E-02,
     &1.1778E+01,9.4689E+00,6.6768E+00,3.5488E+00,3.9709E-02,
     &1.5333E+01,1.2304E+01,8.7122E+00,4.6542E+00,4.7360E-02,
     &1.9762E+01,1.5812E+01,1.1244E+01,6.0319E+00,5.6650E-02/
      DATA ((KB(JS,JT,39,11),JS=1,5),JT=1,5) /
     &5.7815E+00,4.6987E+00,3.2839E+00,1.7336E+00,2.1361E-02,
     &7.9403E+00,6.4302E+00,4.5109E+00,2.3848E+00,2.6909E-02,
     &1.0589E+01,8.5486E+00,6.0232E+00,3.1966E+00,3.3274E-02,
     &1.3890E+01,1.1188E+01,7.9191E+00,4.2244E+00,4.0390E-02,
     &1.8032E+01,1.4487E+01,1.0297E+01,5.5201E+00,4.8824E-02/
      DATA ((KB(JS,JT,40,11),JS=1,5),JT=1,5) /
     &4.9663E+00,4.0580E+00,2.8368E+00,1.4961E+00,1.7977E-02,
     &6.9269E+00,5.6391E+00,3.9540E+00,2.0894E+00,2.2949E-02,
     &9.3578E+00,7.5891E+00,5.3452E+00,2.8327E+00,2.8350E-02,
     &1.2407E+01,1.0028E+01,7.0894E+00,3.7744E+00,3.4399E-02,
     &1.6240E+01,1.3091E+01,9.2991E+00,4.9787E+00,4.2027E-02/
      DATA ((KB(JS,JT,41,11),JS=1,5),JT=1,5) /
     &4.2485E+00,3.4862E+00,2.4352E+00,1.2849E+00,1.5088E-02,
     &6.0166E+00,4.9271E+00,3.4537E+00,1.8243E+00,1.9453E-02,
     &8.2485E+00,6.7221E+00,4.7321E+00,2.5060E+00,2.4198E-02,
     &1.1066E+01,8.9791E+00,6.3459E+00,3.3734E+00,2.9570E-02,
     &1.4636E+01,1.1834E+01,8.3996E+00,4.4886E+00,3.6128E-02/
      DATA ((KB(JS,JT,42,11),JS=1,5),JT=1,5) /
     &3.6346E+00,2.9948E+00,2.0896E+00,1.1018E+00,1.2599E-02,
     &5.2244E+00,4.2974E+00,3.0116E+00,1.5911E+00,1.6323E-02,
     &7.2643E+00,5.9499E+00,4.1877E+00,2.2172E+00,2.0619E-02,
     &9.8747E+00,8.0447E+00,5.6854E+00,3.0206E+00,2.5282E-02,
     &1.3206E+01,1.0716E+01,7.6001E+00,4.0544E+00,3.0876E-02/
      DATA ((KB(JS,JT,43,11),JS=1,5),JT=1,5) /
     &3.0660E+00,2.5370E+00,1.7687E+00,9.3216E-01,1.0308E-02,
     &4.4856E+00,3.7056E+00,2.5945E+00,1.3700E+00,1.3601E-02,
     &6.3372E+00,5.2140E+00,3.6676E+00,1.9419E+00,1.7306E-02,
     &8.7409E+00,7.1536E+00,5.0545E+00,2.6839E+00,2.1526E-02,
     &1.1846E+01,9.6432E+00,6.8374E+00,3.6437E+00,2.6238E-02/
      DATA ((KB(JS,JT,44,11),JS=1,5),JT=1,5) /
     &2.5664E+00,2.1306E+00,1.4853E+00,7.8185E-01,8.3390E-03,
     &3.8265E+00,3.1748E+00,2.2204E+00,1.1717E+00,1.1111E-02,
     &5.5006E+00,4.5418E+00,3.1915E+00,1.6892E+00,1.4312E-02,
     &7.6990E+00,6.3295E+00,4.4707E+00,2.3728E+00,1.8022E-02,
     &1.0590E+01,8.6508E+00,6.1308E+00,3.2656E+00,2.2284E-02/
      DATA ((KB(JS,JT,45,11),JS=1,5),JT=1,5) /
     &2.1449E+00,1.7852E+00,1.2434E+00,6.5459E-01,6.5374E-03,
     &3.2586E+00,2.7120E+00,1.8962E+00,1.0002E+00,8.9661E-03,
     &4.7677E+00,3.9512E+00,2.7729E+00,1.4668E+00,1.1723E-02,
     &6.7759E+00,5.5907E+00,3.9459E+00,2.0943E+00,1.4893E-02,
     &9.4617E+00,7.7574E+00,5.4954E+00,2.9257E+00,1.8879E-02/
      DATA ((KB(JS,JT,46,11),JS=1,5),JT=1,5) /
     &1.7693E+00,1.4778E+00,1.0286E+00,5.4110E-01,5.0474E-03,
     &2.7478E+00,2.2930E+00,1.6009E+00,8.4457E-01,7.0726E-03,
     &4.0941E+00,3.4053E+00,2.3875E+00,1.2626E+00,9.5023E-03,
     &5.9189E+00,4.8999E+00,3.4535E+00,1.8324E+00,1.2322E-02,
     &8.3887E+00,6.9026E+00,4.8893E+00,2.6020E+00,1.5617E-02/
      DATA ((KB(JS,JT,47,11),JS=1,5),JT=1,5) /
     &1.4241E+00,1.1941E+00,8.3002E-01,4.3643E-01,3.7828E-03,
     &2.2698E+00,1.8986E+00,1.3247E+00,6.9822E-01,5.4676E-03,
     &3.4547E+00,2.8836E+00,2.0196E+00,1.0678E+00,7.6213E-03,
     &5.0871E+00,4.2288E+00,2.9766E+00,1.5778E+00,9.9658E-03,
     &7.3321E+00,6.0542E+00,4.2837E+00,2.2790E+00,1.3055E-02/
      DATA ((KB(JS,JT,48,11),JS=1,5),JT=1,5) /
     &1.1337E+00,9.5606E-01,6.6479E-01,3.4941E-01,2.8319E-03,
     &1.8661E+00,1.5653E+00,1.0902E+00,5.7432E-01,4.1758E-03,
     &2.9045E+00,2.4321E+00,1.7012E+00,8.9870E-01,5.9617E-03,
     &4.3570E+00,3.6357E+00,2.5565E+00,1.3546E+00,7.9840E-03,
     &6.3922E+00,5.2980E+00,3.7432E+00,1.9904E+00,1.0519E-02/
      DATA ((KB(JS,JT,49,11),JS=1,5),JT=1,5) /
     &8.9211E-01,7.5781E-01,5.2674E-01,2.7699E-01,2.0587E-03,
     &1.5203E+00,1.2812E+00,8.9206E-01,4.6970E-01,3.1077E-03,
     &2.4343E+00,2.0415E+00,1.4265E+00,7.5292E-01,4.5062E-03,
     &3.7205E+00,3.1142E+00,2.1868E+00,1.1585E+00,6.1377E-03,
     &5.5564E+00,4.6243E+00,3.2638E+00,1.7346E+00,8.3879E-03/
      DATA ((KB(JS,JT,50,11),JS=1,5),JT=1,5) /
     &6.9944E-01,5.9730E-01,4.1544E-01,2.1892E-01,1.5159E-03,
     &1.2386E+00,1.0495E+00,7.3105E-01,3.8493E-01,2.3639E-03,
     &2.0475E+00,1.7233E+00,1.2030E+00,6.3443E-01,3.5129E-03,
     &3.1987E+00,2.6838E+00,1.8828E+00,9.9721E-01,4.9131E-03,
     &4.8613E+00,4.0604E+00,2.8638E+00,1.5216E+00,6.8102E-03/
      DATA ((KB(JS,JT,51,11),JS=1,5),JT=1,5) /
     &5.4324E-01,4.6725E-01,3.2546E-01,1.7172E-01,1.1297E-03,
     &1.0054E+00,8.5632E-01,5.9623E-01,3.1426E-01,1.7844E-03,
     &1.7180E+00,1.4523E+00,1.0136E+00,5.3456E-01,2.7288E-03,
     &2.7560E+00,2.3178E+00,1.6244E+00,8.6011E-01,3.9147E-03,
     &4.2636E+00,3.5725E+00,2.5176E+00,1.3376E+00,5.4601E-03/
      DATA ((KB(JS,JT,52,11),JS=1,5),JT=1,5) /
     &4.1659E-01,3.6012E-01,2.5102E-01,1.3270E-01,8.3775E-04,
     &8.0451E-01,6.9074E-01,4.8148E-01,2.5404E-01,1.3424E-03,
     &1.4303E+00,1.2146E+00,8.4783E-01,4.4730E-01,2.0961E-03,
     &2.3661E+00,1.9968E+00,1.3985E+00,7.3984E-01,3.0912E-03,
     &3.7364E+00,3.1393E+00,2.2101E+00,1.1738E+00,4.3230E-03/
      DATA ((KB(JS,JT,53,11),JS=1,5),JT=1,5) /
     &3.1784E-01,2.7470E-01,1.9112E-01,1.0099E-01,6.0100E-04,
     &6.3733E-01,5.5043E-01,3.8376E-01,2.0263E-01,1.0152E-03,
     &1.1810E+00,1.0077E+00,7.0333E-01,3.7118E-01,1.5799E-03,
     &2.0184E+00,1.7109E+00,1.1985E+00,6.3377E-01,2.3636E-03,
     &3.2693E+00,2.7525E+00,1.9355E+00,1.0278E+00,3.4086E-03/
      DATA ((KB(JS,JT,54,11),JS=1,5),JT=1,5) /
     &2.4587E-01,2.1298E-01,1.4829E-01,7.8206E-02,4.4874E-04,
     &5.0524E-01,4.3896E-01,3.0674E-01,1.6236E-01,7.8054E-04,
     &9.7870E-01,8.4204E-01,5.8784E-01,3.1052E-01,1.2701E-03,
     &1.7368E+00,1.4787E+00,1.0357E+00,5.4775E-01,1.9340E-03,
     &2.8933E+00,2.4419E+00,1.7163E+00,9.1082E-01,2.8443E-03/
      DATA ((KB(JS,JT,55,11),JS=1,5),JT=1,5) /
     &1.9418E-01,1.6698E-01,1.1582E-01,6.0924E-02,3.5209E-04,
     &3.9791E-01,3.4892E-01,2.4392E-01,1.2929E-01,6.3188E-04,
     &8.0845E-01,6.9946E-01,4.8912E-01,2.5894E-01,1.0591E-03,
     &1.4970E+00,1.2804E+00,8.9678E-01,4.7424E-01,1.6138E-03,
     &2.5700E+00,2.1774E+00,1.5304E+00,8.1150E-01,2.4277E-03/
      DATA ((KB(JS,JT,56,11),JS=1,5),JT=1,5) /
     &1.5370E-01,1.3145E-01,9.1321E-02,4.8124E-02,2.7531E-04,
     &3.1616E-01,2.7583E-01,1.9245E-01,1.0171E-01,5.0269E-04,
     &6.6199E-01,5.7649E-01,4.0352E-01,2.1386E-01,8.6775E-04,
     &1.2822E+00,1.1021E+00,7.7256E-01,4.0891E-01,1.3519E-03,
     &2.2783E+00,1.9368E+00,1.3622E+00,7.2221E-01,2.0801E-03/
      DATA ((KB(JS,JT,57,11),JS=1,5),JT=1,5) /
     &1.2165E-01,1.0433E-01,7.2303E-02,3.8009E-02,2.1938E-04,
     &2.5198E-01,2.1938E-01,1.5311E-01,8.0877E-02,3.9875E-04,
     &5.3606E-01,4.7039E-01,3.2945E-01,1.7508E-01,6.9954E-04,
     &1.0880E+00,9.4273E-01,6.6142E-01,3.5027E-01,1.1454E-03,
     &2.0139E+00,1.7191E+00,1.2097E+00,6.4100E-01,1.7901E-03/
      DATA ((KB(JS,JT,58,11),JS=1,5),JT=1,5) /
     &4.6919E-02,4.6268E-02,3.7584E-02,2.3911E-02,1.7988E-04,
     &9.9628E-02,9.8832E-02,8.0744E-02,5.1438E-02,3.2482E-04,
     &2.1097E-01,2.1358E-01,1.7570E-01,1.1318E-01,5.8194E-04,
     &4.4837E-01,4.4802E-01,3.6936E-01,2.3727E-01,9.7962E-04,
     &8.6568E-01,8.5230E-01,7.0456E-01,4.5178E-01,1.5789E-03/
      DATA ((KB(JS,JT,59,11),JS=1,5),JT=1,5) /
     &4.1955E-02,4.1496E-02,3.3924E-02,2.1748E-02,1.7054E-04,
     &9.0096E-02,8.9872E-02,7.3696E-02,4.7378E-02,3.1638E-04,
     &1.9169E-01,1.9390E-01,1.6037E-01,1.0394E-01,5.9374E-04,
     &4.1170E-01,4.1459E-01,3.4386E-01,2.2297E-01,1.0082E-03,
     &8.1839E-01,8.1107E-01,6.7470E-01,4.3624E-01,1.6869E-03/
      DATA ((KB(JS,JT,13,12),JS=1,5),JT=1,5) /
     &1.0396E+02,7.7973E+01,5.1984E+01,2.5992E+01,2.8896E-01,
     &1.4817E+02,1.1113E+02,7.4089E+01,3.7043E+01,6.4071E-01,
     &2.0061E+02,1.5046E+02,1.0030E+02,5.0152E+01,7.6116E-01,
     &2.6114E+02,1.9586E+02,1.3057E+02,6.5284E+01,1.0553E+00,
     &3.2831E+02,2.4622E+02,1.6415E+02,8.2071E+01,1.4067E+00/
      DATA ((KB(JS,JT,14,12),JS=1,5),JT=1,5) /
     &1.1135E+02,8.3512E+01,5.5676E+01,2.7839E+01,4.1053E-01,
     &1.5695E+02,1.1771E+02,7.8475E+01,3.9240E+01,6.2372E-01,
     &2.1121E+02,1.5841E+02,1.0560E+02,5.2802E+01,8.0301E-01,
     &2.7313E+02,2.0485E+02,1.3657E+02,6.8283E+01,1.0170E+00,
     &3.4124E+02,2.5592E+02,1.7062E+02,8.5308E+01,1.1064E+00/
      DATA ((KB(JS,JT,15,12),JS=1,5),JT=1,5) /
     &1.1186E+02,8.3897E+01,5.5935E+01,2.7966E+01,4.8952E-01,
     &1.5638E+02,1.1729E+02,7.8194E+01,3.9097E+01,5.8507E-01,
     &2.0878E+02,1.5659E+02,1.0439E+02,5.2197E+01,6.7687E-01,
     &2.6790E+02,2.0092E+02,1.3395E+02,6.6979E+01,7.8981E-01,
     &3.3305E+02,2.4981E+02,1.6654E+02,8.3272E+01,9.5540E-01/
      DATA ((KB(JS,JT,16,12),JS=1,5),JT=1,5) /
     &1.0741E+02,8.0552E+01,5.3706E+01,2.6852E+01,4.1874E-01,
     &1.4898E+02,1.1174E+02,7.4489E+01,3.7244E+01,5.0405E-01,
     &1.9721E+02,1.4789E+02,9.8599E+01,4.9301E+01,6.1901E-01,
     &2.5144E+02,1.8859E+02,1.2573E+02,6.2879E+01,7.4947E-01,
     &3.1058E+02,2.3295E+02,1.5529E+02,7.7686E+01,8.7491E-01/
      DATA ((KB(JS,JT,17,12),JS=1,5),JT=1,5) /
     &9.9838E+01,7.4879E+01,4.9919E+01,2.5012E+01,3.9338E-01,
     &1.3717E+02,1.0287E+02,6.8583E+01,3.4361E+01,4.7893E-01,
     &1.8052E+02,1.3539E+02,9.0259E+01,4.5242E+01,5.7262E-01,
     &2.2880E+02,1.7160E+02,1.1440E+02,5.7395E+01,6.8306E-01,
     &2.8220E+02,2.1165E+02,1.4109E+02,7.0870E+01,7.6022E-01/
      DATA ((KB(JS,JT,18,12),JS=1,5),JT=1,5) /
     &8.8836E+01,6.6627E+01,4.4421E+01,2.2423E+01,3.7355E-01,
     &1.2136E+02,9.1017E+01,6.0679E+01,3.0651E+01,4.3123E-01,
     &1.5857E+02,1.1893E+02,7.9284E+01,4.0088E+01,5.1039E-01,
     &2.0050E+02,1.5036E+02,1.0025E+02,5.0735E+01,5.8388E-01,
     &2.4631E+02,1.8473E+02,1.2316E+02,6.2388E+01,6.7078E-01/
      DATA ((KB(JS,JT,19,12),JS=1,5),JT=1,5) /
     &7.8886E+01,5.9167E+01,3.9445E+01,2.0119E+01,3.3866E-01,
     &1.0689E+02,8.0167E+01,5.3444E+01,2.7289E+01,4.0283E-01,
     &1.3921E+02,1.0440E+02,6.9601E+01,3.5553E+01,4.5001E-01,
     &1.7541E+02,1.3156E+02,8.7714E+01,4.4793E+01,5.0843E-01,
     &2.1523E+02,1.6142E+02,1.0764E+02,5.4993E+01,5.9607E-01/
      DATA ((KB(JS,JT,20,12),JS=1,5),JT=1,5) /
     &7.0328E+01,5.2750E+01,3.5209E+01,1.8081E+01,3.1237E-01,
     &9.4812E+01,7.1110E+01,4.7453E+01,2.4387E+01,3.6655E-01,
     &1.2307E+02,9.2305E+01,6.1607E+01,3.1685E+01,4.1127E-01,
     &1.5482E+02,1.1612E+02,7.7556E+01,3.9922E+01,4.7264E-01,
     &1.8921E+02,1.4190E+02,9.4818E+01,4.8866E+01,5.5288E-01/
      DATA ((KB(JS,JT,21,12),JS=1,5),JT=1,5) /
     &6.2329E+01,4.6745E+01,3.1314E+01,1.6132E+01,2.8533E-01,
     &8.3734E+01,6.2791E+01,4.2073E+01,2.1717E+01,3.3097E-01,
     &1.0843E+02,8.1321E+01,5.4516E+01,2.8198E+01,3.8205E-01,
     &1.3597E+02,1.0198E+02,6.8398E+01,3.5455E+01,4.6172E-01,
     &1.6566E+02,1.2424E+02,8.3370E+01,4.3320E+01,5.2289E-01/
      DATA ((KB(JS,JT,22,12),JS=1,5),JT=1,5) /
     &5.5853E+01,4.1896E+01,2.8239E+01,1.4630E+01,2.6479E-01,
     &7.4659E+01,5.5993E+01,3.7758E+01,1.9621E+01,3.0587E-01,
     &9.6287E+01,7.2215E+01,4.8710E+01,2.5388E+01,3.6961E-01,
     &1.2002E+02,9.0023E+01,6.0736E+01,3.1753E+01,4.4273E-01,
     &1.4596E+02,1.0947E+02,7.3878E+01,3.8690E+01,5.0560E-01/
      DATA ((KB(JS,JT,23,12),JS=1,5),JT=1,5) /
     &4.9987E+01,3.7501E+01,2.5418E+01,1.3325E+01,2.4880E-01,
     &6.6514E+01,4.9903E+01,3.3828E+01,1.7769E+01,2.9089E-01,
     &8.5155E+01,6.3887E+01,4.3325E+01,2.2796E+01,3.6730E-01,
     &1.0588E+02,7.9440E+01,5.3898E+01,2.8390E+01,4.2226E-01,
     &1.2867E+02,9.6554E+01,6.5521E+01,3.4526E+01,4.8786E-01/
      DATA ((KB(JS,JT,24,12),JS=1,5),JT=1,5) /
     &4.5237E+01,3.3990E+01,2.3082E+01,1.2266E+01,2.3374E-01,
     &5.9731E+01,4.4882E+01,3.0518E+01,1.6222E+01,2.9093E-01,
     &7.6147E+01,5.7227E+01,3.8961E+01,2.0700E+01,3.4607E-01,
     &9.4592E+01,7.1092E+01,4.8449E+01,2.5703E+01,4.0338E-01,
     &1.1508E+02,8.6507E+01,5.8986E+01,3.1241E+01,4.6347E-01/
      DATA ((KB(JS,JT,25,12),JS=1,5),JT=1,5) /
     &4.1207E+01,3.1054E+01,2.1145E+01,1.1344E+01,2.1959E-01,
     &5.4029E+01,4.0717E+01,2.7774E+01,1.4878E+01,2.7843E-01,
     &6.8735E+01,5.1802E+01,3.5391E+01,1.8919E+01,3.2302E-01,
     &8.5416E+01,6.4368E+01,4.4030E+01,2.3485E+01,3.8140E-01,
     &1.0430E+02,7.8570E+01,5.3767E+01,2.8613E+01,4.3338E-01/
      DATA ((KB(JS,JT,26,12),JS=1,5),JT=1,5) /
     &3.7870E+01,2.8646E+01,1.9592E+01,1.0560E+01,2.1067E-01,
     &4.9486E+01,3.7425E+01,2.5645E+01,1.3791E+01,2.5277E-01,
     &6.2993E+01,4.7626E+01,3.2666E+01,1.7516E+01,3.0077E-01,
     &7.8659E+01,5.9439E+01,4.0756E+01,2.1814E+01,3.5095E-01,
     &9.6658E+01,7.2997E+01,5.0039E+01,2.6742E+01,4.0727E-01/
      DATA ((KB(JS,JT,27,12),JS=1,5),JT=1,5) /
     &3.5089E+01,2.6619E+01,1.8325E+01,9.8881E+00,1.9876E-01,
     &4.5899E+01,3.4800E+01,2.3944E+01,1.2890E+01,2.3298E-01,
     &5.8737E+01,4.4506E+01,3.0596E+01,1.6445E+01,2.8191E-01,
     &7.3770E+01,5.5858E+01,3.8369E+01,2.0601E+01,3.2481E-01,
     &9.1107E+01,6.8940E+01,4.7296E+01,2.5356E+01,3.8171E-01/
      DATA ((KB(JS,JT,28,12),JS=1,5),JT=1,5) /
     &3.2818E+01,2.4943E+01,1.7280E+01,9.3226E+00,1.7817E-01,
     &4.3184E+01,3.2811E+01,2.2668E+01,1.2208E+01,2.1857E-01,
     &5.5616E+01,4.2235E+01,2.9105E+01,1.5656E+01,2.5762E-01,
     &7.0259E+01,5.3319E+01,3.6659E+01,1.9693E+01,3.0371E-01,
     &8.7123E+01,6.6079E+01,4.5396E+01,2.4379E+01,3.5478E-01/
      DATA ((KB(JS,JT,29,12),JS=1,5),JT=1,5) /
     &3.0859E+01,2.3511E+01,1.6360E+01,8.8280E+00,1.6679E-01,
     &4.0867E+01,3.1128E+01,2.1584E+01,1.1631E+01,2.0451E-01,
     &5.2915E+01,4.0294E+01,2.7845E+01,1.4987E+01,2.3670E-01,
     &6.7028E+01,5.1030E+01,3.5190E+01,1.8944E+01,2.7999E-01,
     &8.3169E+01,6.3273E+01,4.3571E+01,2.3474E+01,3.2963E-01/
      DATA ((KB(JS,JT,30,12),JS=1,5),JT=1,5) /
     &2.9181E+01,2.2308E+01,1.5570E+01,8.4046E+00,1.5217E-01,
     &3.8810E+01,2.9664E+01,2.0634E+01,1.1131E+01,1.8255E-01,
     &5.0316E+01,3.8456E+01,2.6686E+01,1.4393E+01,2.1489E-01,
     &6.3652E+01,4.8625E+01,3.3675E+01,1.8188E+01,2.5258E-01,
     &7.8956E+01,6.0282E+01,4.1671E+01,2.2569E+01,2.9642E-01/
      DATA ((KB(JS,JT,31,12),JS=1,5),JT=1,5) /
     &2.7538E+01,2.1159E+01,1.4815E+01,8.0002E+00,1.3523E-01,
     &3.6621E+01,2.8123E+01,1.9646E+01,1.0617E+01,1.6072E-01,
     &4.7347E+01,3.6341E+01,2.5341E+01,1.3718E+01,1.9204E-01,
     &5.9881E+01,4.5936E+01,3.1977E+01,1.7350E+01,2.2658E-01,
     &7.4375E+01,5.6987E+01,3.9602E+01,2.1563E+01,2.6205E-01/
      DATA ((KB(JS,JT,32,12),JS=1,5),JT=1,5) /
     &2.6147E+01,2.0200E+01,1.4192E+01,7.6720E+00,1.1829E-01,
     &3.4618E+01,2.6728E+01,1.8768E+01,1.0173E+01,1.4448E-01,
     &4.4733E+01,3.4488E+01,2.4181E+01,1.3140E+01,1.7290E-01,
     &5.6644E+01,4.3620E+01,3.0542E+01,1.6653E+01,2.0200E-01,
     &7.0667E+01,5.4331E+01,3.7949E+01,2.0755E+01,2.3023E-01/
      DATA ((KB(JS,JT,33,12),JS=1,5),JT=1,5) /
     &2.4867E+01,1.9325E+01,1.3642E+01,7.3884E+00,1.0477E-01,
     &3.2857E+01,2.5486E+01,1.7993E+01,9.7748E+00,1.2807E-01,
     &4.2482E+01,3.2899E+01,2.3208E+01,1.2658E+01,1.5122E-01,
     &5.4028E+01,4.1749E+01,2.9378E+01,1.6087E+01,1.7656E-01,
     &6.7699E+01,5.2220E+01,3.6682E+01,2.0157E+01,2.0029E-01/
      DATA ((KB(JS,JT,34,12),JS=1,5),JT=1,5) /
     &2.3698E+01,1.8505E+01,1.3121E+01,7.1187E+00,9.5888E-02,
     &3.1359E+01,2.4427E+01,1.7335E+01,9.4402E+00,1.1540E-01,
     &4.0701E+01,3.1624E+01,2.2413E+01,1.2266E+01,1.3371E-01,
     &5.2041E+01,4.0338E+01,2.8530E+01,1.5676E+01,1.5490E-01,
     &6.5491E+01,5.0663E+01,3.5768E+01,1.9755E+01,1.8157E-01/
      DATA ((KB(JS,JT,35,12),JS=1,5),JT=1,5) /
     &2.2108E+01,1.7359E+01,1.2354E+01,6.7085E+00,8.3925E-02,
     &2.9390E+01,2.2999E+01,1.6388E+01,8.9464E+00,9.9962E-02,
     &3.8435E+01,2.9966E+01,2.1324E+01,1.1694E+01,1.1806E-01,
     &4.9418E+01,3.8439E+01,2.7323E+01,1.5063E+01,1.3630E-01,
     &6.2546E+01,4.8535E+01,3.4447E+01,1.9092E+01,1.6585E-01/
      DATA ((KB(JS,JT,36,12),JS=1,5),JT=1,5) /
     &2.0129E+01,1.5891E+01,1.1346E+01,6.1643E+00,7.2166E-02,
     &2.6967E+01,2.1198E+01,1.5154E+01,8.2858E+00,8.5917E-02,
     &3.5568E+01,2.7847E+01,1.9901E+01,1.0934E+01,1.0193E-01,
     &4.6092E+01,3.5975E+01,2.5697E+01,1.4200E+01,1.2167E-01,
     &5.8785E+01,4.5750E+01,3.2634E+01,1.8141E+01,1.4958E-01/
      DATA ((KB(JS,JT,37,12),JS=1,5),JT=1,5) /
     &1.7737E+01,1.4074E+01,1.0069E+01,5.4659E+00,6.3045E-02,
     &2.3991E+01,1.8955E+01,1.3586E+01,7.4275E+00,7.4702E-02,
     &3.1985E+01,2.5160E+01,1.8048E+01,9.9281E+00,8.9095E-02,
     &4.1889E+01,3.2824E+01,2.3555E+01,1.3031E+01,1.0656E-01,
     &5.3988E+01,4.2162E+01,3.0205E+01,1.6815E+01,1.3149E-01/
      DATA ((KB(JS,JT,38,12),JS=1,5),JT=1,5) /
     &1.5671E+01,1.2491E+01,8.9462E+00,4.8489E+00,5.4067E-02,
     &2.1387E+01,1.6974E+01,1.2184E+01,6.6604E+00,6.5509E-02,
     &2.8785E+01,2.2756E+01,1.6373E+01,9.0146E+00,7.7568E-02,
     &3.8117E+01,2.9996E+01,2.1601E+01,1.1967E+01,9.4071E-02,
     &4.9667E+01,3.8921E+01,2.7995E+01,1.5610E+01,1.1469E-01/
      DATA ((KB(JS,JT,39,12),JS=1,5),JT=1,5) /
     &1.3901E+01,1.1137E+01,7.9846E+00,4.3195E+00,4.6183E-02,
     &1.9150E+01,1.5270E+01,1.0976E+01,5.9905E+00,5.6093E-02,
     &2.6010E+01,2.0653E+01,1.4897E+01,8.2086E+00,6.7656E-02,
     &3.4809E+01,2.7511E+01,1.9872E+01,1.1026E+01,8.1649E-02,
     &4.5848E+01,3.6052E+01,2.6039E+01,1.4537E+01,9.9747E-02/
      DATA ((KB(JS,JT,40,12),JS=1,5),JT=1,5) /
     &1.2081E+01,9.7243E+00,6.9733E+00,3.7653E+00,3.9581E-02,
     &1.6838E+01,1.3484E+01,9.6953E+00,5.2801E+00,4.8568E-02,
     &2.3104E+01,1.8425E+01,1.3302E+01,7.3218E+00,5.8955E-02,
     &3.1273E+01,2.4818E+01,1.7967E+01,9.9757E+00,7.0859E-02,
     &4.1711E+01,3.2920E+01,2.3848E+01,1.3319E+01,8.6539E-02/
      DATA ((KB(JS,JT,41,12),JS=1,5),JT=1,5) /
     &1.0485E+01,8.4800E+00,6.0787E+00,3.2769E+00,3.3606E-02,
     &1.4786E+01,1.1894E+01,8.5576E+00,4.6493E+00,4.1457E-02,
     &2.0530E+01,1.6437E+01,1.1871E+01,6.5218E+00,5.0842E-02,
     &2.8093E+01,2.2374E+01,1.6223E+01,9.0068E+00,6.1229E-02,
     &3.7921E+01,3.0039E+01,2.1812E+01,1.2190E+01,7.5282E-02/
      DATA ((KB(JS,JT,42,12),JS=1,5),JT=1,5) /
     &9.1079E+00,7.3993E+00,5.3023E+00,2.8534E+00,2.8075E-02,
     &1.3005E+01,1.0510E+01,7.5619E+00,4.1019E+00,3.5441E-02,
     &1.8277E+01,1.4697E+01,1.0617E+01,5.8190E+00,4.3089E-02,
     &2.5289E+01,2.0221E+01,1.4670E+01,8.1365E+00,5.2317E-02,
     &3.4535E+01,2.7452E+01,1.9969E+01,1.1164E+01,6.5436E-02/
      DATA ((KB(JS,JT,43,12),JS=1,5),JT=1,5) /
     &7.8247E+00,6.3834E+00,4.5697E+00,2.4551E+00,2.3117E-02,
     &1.1336E+01,9.1978E+00,6.6143E+00,3.5804E+00,2.9659E-02,
     &1.6137E+01,1.3030E+01,9.4153E+00,5.1449E+00,3.6857E-02,
     &2.2622E+01,1.8150E+01,1.3165E+01,7.2856E+00,4.4557E-02,
     &3.1253E+01,2.4925E+01,1.8144E+01,1.0136E+01,5.5864E-02/
      DATA ((KB(JS,JT,44,12),JS=1,5),JT=1,5) /
     &6.6782E+00,5.4729E+00,3.9116E+00,2.0984E+00,1.9194E-02,
     &9.8370E+00,8.0127E+00,5.7576E+00,3.1087E+00,2.4741E-02,
     &1.4194E+01,1.1506E+01,8.3119E+00,4.5308E+00,3.1291E-02,
     &2.0172E+01,1.6246E+01,1.1781E+01,6.4997E+00,3.7622E-02,
     &2.8219E+01,2.2570E+01,1.6428E+01,9.1628E+00,4.7831E-02/
      DATA ((KB(JS,JT,45,12),JS=1,5),JT=1,5) /
     &5.6770E+00,4.6794E+00,3.3425E+00,1.7902E+00,1.5806E-02,
     &8.5322E+00,6.9760E+00,5.0078E+00,2.6991E+00,2.0417E-02,
     &1.2498E+01,1.0162E+01,7.3367E+00,3.9899E+00,2.6093E-02,
     &1.7997E+01,1.4548E+01,1.0552E+01,5.8018E+00,3.2356E-02,
     &2.5510E+01,2.0455E+01,1.4885E+01,8.2823E+00,4.0610E-02/
      DATA ((KB(JS,JT,46,12),JS=1,5),JT=1,5) /
     &4.7638E+00,3.9496E+00,2.8218E+00,1.5105E+00,1.2604E-02,
     &7.3248E+00,6.0189E+00,4.3157E+00,2.3220E+00,1.6943E-02,
     &1.0931E+01,8.9155E+00,6.4285E+00,3.4858E+00,2.1734E-02,
     &1.5948E+01,1.2933E+01,9.3805E+00,5.1432E+00,2.7407E-02,
     &2.2923E+01,1.8438E+01,1.3407E+01,7.4358E+00,3.4309E-02/
      DATA ((KB(JS,JT,47,12),JS=1,5),JT=1,5) /
     &3.9080E+00,3.2569E+00,2.3263E+00,1.2446E+00,1.0169E-02,
     &6.1567E+00,5.0883E+00,3.6497E+00,1.9607E+00,1.3733E-02,
     &9.4053E+00,7.6982E+00,5.5432E+00,2.9978E+00,1.8162E-02,
     &1.3941E+01,1.1337E+01,8.2150E+00,4.4897E+00,2.3207E-02,
     &2.0314E+01,1.6396E+01,1.1915E+01,6.5825E+00,2.8974E-02/
      DATA ((KB(JS,JT,48,12),JS=1,5),JT=1,5) /
     &3.1887E+00,2.6690E+00,1.9049E+00,1.0177E+00,7.9795E-03,
     &5.1425E+00,4.2754E+00,3.0657E+00,1.6476E+00,1.1064E-02,
     &8.0497E+00,6.6225E+00,4.7642E+00,2.5722E+00,1.4743E-02,
     &1.2183E+01,9.9349E+00,7.1838E+00,3.9122E+00,1.9211E-02,
     &1.7984E+01,1.4555E+01,1.0573E+01,5.8220E+00,2.4214E-02/
      DATA ((KB(JS,JT,49,12),JS=1,5),JT=1,5) /
     &2.5869E+00,2.1741E+00,1.5486E+00,8.2603E-01,6.2330E-03,
     &4.2741E+00,3.5702E+00,2.5591E+00,1.3745E+00,8.6780E-03,
     &6.8485E+00,5.6671E+00,4.0787E+00,2.1997E+00,1.1935E-02,
     &1.0623E+01,8.6880E+00,6.2733E+00,3.4054E+00,1.5780E-02,
     &1.5914E+01,1.2906E+01,9.3651E+00,5.1392E+00,2.0415E-02/
      DATA ((KB(JS,JT,50,12),JS=1,5),JT=1,5) /
     &2.1098E+00,1.7804E+00,1.2663E+00,6.7426E-01,4.8509E-03,
     &3.5764E+00,2.9999E+00,2.1487E+00,1.1529E+00,6.9665E-03,
     &5.8619E+00,4.8746E+00,3.5094E+00,1.8934E+00,9.7336E-03,
     &9.3128E+00,7.6488E+00,5.5163E+00,2.9881E+00,1.3124E-02,
     &1.4210E+01,1.1543E+01,8.3635E+00,4.5727E+00,1.7352E-02/
      DATA ((KB(JS,JT,51,12),JS=1,5),JT=1,5) /
     &1.7153E+00,1.4551E+00,1.0341E+00,5.4981E-01,3.8011E-03,
     &2.9969E+00,2.5231E+00,1.8054E+00,9.6765E-01,5.5539E-03,
     &5.0265E+00,4.1972E+00,3.0205E+00,1.6294E+00,8.0318E-03,
     &8.1641E+00,6.7342E+00,4.8593E+00,2.6284E+00,1.0987E-02,
     &1.2731E+01,1.0364E+01,7.4966E+00,4.0842E+00,1.4784E-02/
      DATA ((KB(JS,JT,52,12),JS=1,5),JT=1,5) /
     &1.3829E+00,1.1793E+00,8.3692E-01,4.4489E-01,2.9111E-03,
     &2.5001E+00,2.1140E+00,1.5110E+00,8.0824E-01,4.4285E-03,
     &4.2993E+00,3.6038E+00,2.5920E+00,1.3972E+00,6.4988E-03,
     &7.1362E+00,5.9093E+00,4.2654E+00,2.3076E+00,9.0777E-03,
     &1.1388E+01,9.2949E+00,6.7113E+00,3.6475E+00,1.2584E-02/
      DATA ((KB(JS,JT,53,12),JS=1,5),JT=1,5) /
     &1.0996E+00,9.4448E-01,6.6999E-01,3.5618E-01,2.1752E-03,
     &2.0714E+00,1.7598E+00,1.2567E+00,6.7105E-01,3.4164E-03,
     &3.6653E+00,3.0827E+00,2.2148E+00,1.1926E+00,5.1289E-03,
     &6.2207E+00,5.1680E+00,3.7282E+00,2.0166E+00,7.4836E-03,
     &1.0144E+01,8.3054E+00,5.9967E+00,3.2508E+00,1.0390E-02/
      DATA ((KB(JS,JT,54,12),JS=1,5),JT=1,5) /
     &8.8096E-01,7.6003E-01,5.3828E-01,2.8652E-01,1.7028E-03,
     &1.7342E+00,1.4790E+00,1.0559E+00,5.6372E-01,2.7715E-03,
     &3.1660E+00,2.6700E+00,1.9162E+00,1.0305E+00,4.2409E-03,
     &5.4916E+00,4.5733E+00,3.2967E+00,1.7833E+00,6.3614E-03,
     &9.1316E+00,7.4962E+00,5.4128E+00,2.9325E+00,9.0996E-03/
      DATA ((KB(JS,JT,55,12),JS=1,5),JT=1,5) /
     &7.0080E-01,6.0941E-01,4.3132E-01,2.2991E-01,1.3497E-03,
     &1.4554E+00,1.2471E+00,8.8937E-01,4.7463E-01,2.3282E-03,
     &2.7458E+00,2.3243E+00,1.6671E+00,8.9493E-01,3.6585E-03,
     &4.8778E+00,4.0704E+00,2.9318E+00,1.5851E+00,5.5673E-03,
     &8.2670E+00,6.7971E+00,4.9063E+00,2.6581E+00,8.0481E-03/
      DATA ((KB(JS,JT,56,12),JS=1,5),JT=1,5) /
     &5.5050E-01,4.8277E-01,3.4128E-01,1.8181E-01,1.0666E-03,
     &1.2088E+00,1.0426E+00,7.4350E-01,3.9744E-01,1.9421E-03,
     &2.3753E+00,2.0178E+00,1.4463E+00,7.7559E-01,3.1486E-03,
     &4.3336E+00,3.6227E+00,2.6061E+00,1.4075E+00,4.8772E-03,
     &7.4871E+00,6.1648E+00,4.4455E+00,2.4084E+00,7.2633E-03/
      DATA ((KB(JS,JT,57,12),JS=1,5),JT=1,5) /
     &4.2691E-01,3.7593E-01,2.6606E-01,1.4195E-01,8.3793E-04,
     &9.9567E-01,8.6325E-01,6.1463E-01,3.2859E-01,1.6242E-03,
     &2.0486E+00,1.7449E+00,1.2502E+00,6.7018E-01,2.7399E-03,
     &3.8496E+00,3.2234E+00,2.3159E+00,1.2492E+00,4.2649E-03,
     &6.7867E+00,5.5927E+00,4.0285E+00,2.1823E+00,6.5093E-03/
      DATA ((KB(JS,JT,58,12),JS=1,5),JT=1,5) /
     &1.6356E-01,1.6482E-01,1.3630E-01,8.7916E-02,6.5877E-04,
     &3.9653E-01,3.9771E-01,3.3219E-01,2.1522E-01,1.3561E-03,
     &8.5978E-01,8.4388E-01,7.0959E-01,4.6009E-01,2.4231E-03,
     &1.6685E+00,1.6071E+00,1.3546E+00,8.8295E-01,3.8944E-03,
     &3.0057E+00,2.8445E+00,2.4022E+00,1.5741E+00,5.9596E-03/
      DATA ((KB(JS,JT,59,12),JS=1,5),JT=1,5) /
     &1.4551E-01,1.4725E-01,1.2251E-01,7.9561E-02,6.8074E-04,
     &3.6080E-01,3.6451E-01,3.0649E-01,2.0003E-01,1.4324E-03,
     &8.0811E-01,7.9823E-01,6.7489E-01,4.4138E-01,2.5709E-03,
     &1.6058E+00,1.5512E+00,1.3138E+00,8.6244E-01,4.2753E-03,
     &2.9249E+00,2.7730E+00,2.3517E+00,1.5520E+00,6.3367E-03/
      DATA ((KB(JS,JT,13,13),JS=1,5),JT=1,5) /
     &1.6844E+02,1.2633E+02,8.4219E+01,4.2110E+01,6.4746E-01,
     &2.3974E+02,1.7981E+02,1.1987E+02,5.9937E+01,7.7977E-01,
     &3.2626E+02,2.4469E+02,1.6313E+02,8.1566E+01,1.5118E+00,
     &4.2676E+02,3.2006E+02,2.1338E+02,1.0669E+02,1.6642E+00,
     &5.4119E+02,4.0589E+02,2.7059E+02,1.3530E+02,1.7313E+00/
      DATA ((KB(JS,JT,14,13),JS=1,5),JT=1,5) /
     &1.9041E+02,1.4281E+02,9.5205E+01,4.7604E+01,4.8593E-01,
     &2.6943E+02,2.0207E+02,1.3472E+02,6.7360E+01,1.0523E+00,
     &3.6326E+02,2.7244E+02,1.8162E+02,9.0813E+01,1.4658E+00,
     &4.7082E+02,3.5312E+02,2.3542E+02,1.1771E+02,1.6120E+00,
     &5.9086E+02,4.4312E+02,2.9542E+02,1.4771E+02,1.8462E+00/
      DATA ((KB(JS,JT,15,13),JS=1,5),JT=1,5) /
     &2.0331E+02,1.5249E+02,1.0165E+02,5.0828E+01,7.0211E-01,
     &2.8491E+02,2.1369E+02,1.4246E+02,7.1232E+01,1.1193E+00,
     &3.8104E+02,2.8579E+02,1.9054E+02,9.5263E+01,1.3482E+00,
     &4.8986E+02,3.6740E+02,2.4492E+02,1.2246E+02,1.6094E+00,
     &6.0932E+02,4.5699E+02,3.0468E+02,1.5233E+02,1.6798E+00/
      DATA ((KB(JS,JT,16,13),JS=1,5),JT=1,5) /
     &2.0774E+02,1.5583E+02,1.0388E+02,5.1937E+01,8.3999E-01,
     &2.8883E+02,2.1662E+02,1.4442E+02,7.2209E+01,1.0268E+00,
     &3.8302E+02,2.8729E+02,1.9153E+02,9.5770E+01,1.2054E+00,
     &4.8856E+02,3.6642E+02,2.4427E+02,1.2213E+02,1.2630E+00,
     &6.0471E+02,4.5354E+02,3.0235E+02,1.5118E+02,1.5611E+00/
      DATA ((KB(JS,JT,17,13),JS=1,5),JT=1,5) /
     &2.0589E+02,1.5442E+02,1.0294E+02,5.1473E+01,7.0898E-01,
     &2.8383E+02,2.1287E+02,1.4191E+02,7.0957E+01,8.7566E-01,
     &3.7354E+02,2.8016E+02,1.8678E+02,9.3389E+01,1.0083E+00,
     &4.7406E+02,3.5553E+02,2.3702E+02,1.1851E+02,1.2409E+00,
     &5.8252E+02,4.3688E+02,2.9126E+02,1.4563E+02,1.5701E+00/
      DATA ((KB(JS,JT,18,13),JS=1,5),JT=1,5) /
     &1.9631E+02,1.4723E+02,9.8151E+01,4.9076E+01,6.5277E-01,
     &2.6794E+02,2.0095E+02,1.3397E+02,6.6983E+01,7.9253E-01,
     &3.5060E+02,2.6297E+02,1.7531E+02,8.7658E+01,9.7984E-01,
     &4.4214E+02,3.3161E+02,2.2107E+02,1.1054E+02,1.2414E+00,
     &5.4117E+02,4.0586E+02,2.7058E+02,1.3530E+02,1.5487E+00/
      DATA ((KB(JS,JT,19,13),JS=1,5),JT=1,5) /
     &1.8546E+02,1.3909E+02,9.2728E+01,4.6396E+01,6.1789E-01,
     &2.5191E+02,1.8893E+02,1.2596E+02,6.3020E+01,7.3049E-01,
     &3.2752E+02,2.4563E+02,1.6376E+02,8.1963E+01,9.1418E-01,
     &4.1109E+02,3.0832E+02,2.0555E+02,1.0295E+02,1.1663E+00,
     &5.0069E+02,3.7554E+02,2.5035E+02,1.2551E+02,1.4682E+00/
      DATA ((KB(JS,JT,20,13),JS=1,5),JT=1,5) /
     &1.7660E+02,1.3245E+02,8.8301E+01,4.4344E+01,5.8624E-01,
     &2.3782E+02,1.7835E+02,1.1891E+02,5.9734E+01,7.0627E-01,
     &3.0729E+02,2.3046E+02,1.5365E+02,7.7248E+01,8.6369E-01,
     &3.8357E+02,2.8768E+02,1.9179E+02,9.6513E+01,1.0255E+00,
     &4.6652E+02,3.4991E+02,2.3327E+02,1.1751E+02,1.3105E+00/
      DATA ((KB(JS,JT,21,13),JS=1,5),JT=1,5) /
     &1.6552E+02,1.2414E+02,8.2761E+01,4.1834E+01,5.4233E-01,
     &2.2144E+02,1.6608E+02,1.1072E+02,5.6006E+01,6.6551E-01,
     &2.8447E+02,2.1334E+02,1.4223E+02,7.2029E+01,7.8267E-01,
     &3.5426E+02,2.6570E+02,1.7714E+02,8.9791E+01,9.3322E-01,
     &4.3028E+02,3.2271E+02,2.1513E+02,1.0915E+02,1.1469E+00/
      DATA ((KB(JS,JT,22,13),JS=1,5),JT=1,5) /
     &1.5536E+02,1.1652E+02,7.7681E+01,3.9611E+01,5.1617E-01,
     &2.0596E+02,1.5446E+02,1.0298E+02,5.2572E+01,6.2474E-01,
     &2.6312E+02,1.9733E+02,1.3157E+02,6.7220E+01,7.4033E-01,
     &3.2670E+02,2.4500E+02,1.6337E+02,8.3538E+01,8.8562E-01,
     &3.9539E+02,2.9656E+02,1.9778E+02,1.0126E+02,1.0777E+00/
      DATA ((KB(JS,JT,23,13),JS=1,5),JT=1,5) /
     &1.4370E+02,1.0779E+02,7.1941E+01,3.6979E+01,5.0881E-01,
     &1.8910E+02,1.4182E+02,9.4675E+01,4.8747E+01,5.9561E-01,
     &2.4065E+02,1.8048E+02,1.2051E+02,6.2134E+01,7.0317E-01,
     &2.9775E+02,2.2332E+02,1.4916E+02,7.6994E+01,8.5956E-01,
     &3.5987E+02,2.6990E+02,1.8034E+02,9.3182E+01,1.0114E+00/
      DATA ((KB(JS,JT,24,13),JS=1,5),JT=1,5) /
     &1.3242E+02,9.9313E+01,6.6507E+01,3.4403E+01,4.7778E-01,
     &1.7334E+02,1.3001E+02,8.7073E+01,4.5133E+01,5.5652E-01,
     &2.1981E+02,1.6486E+02,1.1045E+02,5.7389E+01,6.8303E-01,
     &2.7150E+02,2.0360E+02,1.3644E+02,7.1035E+01,8.3312E-01,
     &3.2837E+02,2.4630E+02,1.6509E+02,8.6103E+01,9.5638E-01/
      DATA ((KB(JS,JT,25,13),JS=1,5),JT=1,5) /
     &1.2137E+02,9.1042E+01,6.1224E+01,3.1886E+01,4.5611E-01,
     &1.5823E+02,1.1867E+02,7.9841E+01,4.1707E+01,5.3430E-01,
     &2.0017E+02,1.5012E+02,1.0102E+02,5.2903E+01,6.6826E-01,
     &2.4727E+02,1.8545E+02,1.2481E+02,6.5530E+01,7.9106E-01,
     &2.9868E+02,2.2401E+02,1.5081E+02,7.9363E+01,9.2773E-01/
      DATA ((KB(JS,JT,26,13),JS=1,5),JT=1,5) /
     &1.1166E+02,8.3750E+01,5.6641E+01,2.9761E+01,4.3741E-01,
     &1.4505E+02,1.0880E+02,7.3586E+01,3.8778E+01,5.3620E-01,
     &1.8336E+02,1.3753E+02,9.3041E+01,4.9168E+01,6.5727E-01,
     &2.2613E+02,1.6961E+02,1.1481E+02,6.0809E+01,7.5877E-01,
     &2.7339E+02,2.0507E+02,1.3883E+02,7.3616E+01,9.0221E-01/
      DATA ((KB(JS,JT,27,13),JS=1,5),JT=1,5) /
     &1.0286E+02,7.7197E+01,5.2520E+01,2.7881E+01,4.2067E-01,
     &1.3339E+02,1.0010E+02,6.8159E+01,3.6272E+01,5.2994E-01,
     &1.6841E+02,1.2640E+02,8.6087E+01,4.5886E+01,6.2144E-01,
     &2.0796E+02,1.5610E+02,1.0629E+02,5.6702E+01,7.2963E-01,
     &2.5159E+02,1.8888E+02,1.2865E+02,6.8691E+01,8.6563E-01/
      DATA ((KB(JS,JT,28,13),JS=1,5),JT=1,5) /
     &9.5256E+01,7.1619E+01,4.8936E+01,2.6277E+01,4.0676E-01,
     &1.2337E+02,9.2726E+01,6.3443E+01,3.4072E+01,4.9978E-01,
     &1.5583E+02,1.1712E+02,8.0174E+01,4.3046E+01,5.7218E-01,
     &1.9223E+02,1.4447E+02,9.8926E+01,5.3164E+01,6.9683E-01,
     &2.3315E+02,1.7521E+02,1.1992E+02,6.4418E+01,8.1878E-01/
      DATA ((KB(JS,JT,29,13),JS=1,5),JT=1,5) /
     &8.8532E+01,6.6695E+01,4.5757E+01,2.4810E+01,3.8492E-01,
     &1.1463E+02,8.6325E+01,5.9300E+01,3.2087E+01,4.4646E-01,
     &1.4438E+02,1.0869E+02,7.4772E+01,4.0468E+01,5.3953E-01,
     &1.7851E+02,1.3434E+02,9.2412E+01,4.9954E+01,6.4107E-01,
     &2.1752E+02,1.6365E+02,1.1246E+02,6.0724E+01,7.6365E-01/
      DATA ((KB(JS,JT,30,13),JS=1,5),JT=1,5) /
     &8.2710E+01,6.2476E+01,4.3045E+01,2.3511E+01,3.4189E-01,
     &1.0675E+02,8.0586E+01,5.5620E+01,3.0345E+01,4.0578E-01,
     &1.3482E+02,1.0169E+02,7.0226E+01,3.8224E+01,5.0418E-01,
     &1.6752E+02,1.2628E+02,8.7179E+01,4.7334E+01,5.9789E-01,
     &2.0548E+02,1.5477E+02,1.0678E+02,5.7811E+01,7.2304E-01/
      DATA ((KB(JS,JT,31,13),JS=1,5),JT=1,5) /
     &7.6989E+01,5.8322E+01,4.0414E+01,2.2252E+01,3.0592E-01,
     &9.9596E+01,7.5380E+01,5.2274E+01,2.8707E+01,3.7677E-01,
     &1.2653E+02,9.5656E+01,6.6313E+01,3.6293E+01,4.5864E-01,
     &1.5839E+02,1.1960E+02,8.2835E+01,4.5152E+01,5.5168E-01,
     &1.9525E+02,1.4733E+02,1.0199E+02,5.5418E+01,6.7878E-01/
      DATA ((KB(JS,JT,32,13),JS=1,5),JT=1,5) /
     &7.2617E+01,5.5198E+01,3.8454E+01,2.1285E+01,2.7831E-01,
     &9.4496E+01,7.1727E+01,4.9927E+01,2.7539E+01,3.4616E-01,
     &1.2095E+02,9.1662E+01,6.3739E+01,3.5032E+01,4.1226E-01,
     &1.5220E+02,1.1521E+02,8.0042E+01,4.3833E+01,5.1531E-01,
     &1.8837E+02,1.4240E+02,9.8836E+01,5.3991E+01,6.4895E-01/
      DATA ((KB(JS,JT,33,13),JS=1,5),JT=1,5) /
     &6.9586E+01,5.3075E+01,3.7119E+01,2.0620E+01,2.5421E-01,
     &9.1190E+01,6.9432E+01,4.8467E+01,2.6834E+01,3.0964E-01,
     &1.1725E+02,8.9117E+01,6.2134E+01,3.4318E+01,3.8320E-01,
     &1.4810E+02,1.1236E+02,7.8257E+01,4.3108E+01,4.8588E-01,
     &1.8404E+02,1.3940E+02,9.6928E+01,5.3246E+01,6.2021E-01/
      DATA ((KB(JS,JT,34,13),JS=1,5),JT=1,5) /
     &6.7703E+01,5.1785E+01,3.6334E+01,2.0214E+01,2.2826E-01,
     &8.9165E+01,6.8046E+01,4.7643E+01,2.6485E+01,2.7978E-01,
     &1.1511E+02,8.7692E+01,6.1290E+01,3.4007E+01,3.5723E-01,
     &1.4598E+02,1.1096E+02,7.7422E+01,4.2877E+01,4.6377E-01,
     &1.8238E+02,1.3836E+02,9.6327E+01,5.3168E+01,5.7690E-01/
      DATA ((KB(JS,JT,35,13),JS=1,5),JT=1,5) /
     &6.4861E+01,4.9746E+01,3.5026E+01,1.9551E+01,2.0156E-01,
     &8.5976E+01,6.5785E+01,4.6175E+01,2.5782E+01,2.5401E-01,
     &1.1165E+02,8.5245E+01,5.9716E+01,3.3273E+01,3.2846E-01,
     &1.4250E+02,1.0853E+02,7.5838E+01,4.2162E+01,4.2675E-01,
     &1.7910E+02,1.3608E+02,9.4891E+01,5.2581E+01,5.2256E-01/
      DATA ((KB(JS,JT,36,13),JS=1,5),JT=1,5) /
     &6.0764E+01,4.6732E+01,3.3052E+01,1.8514E+01,1.7227E-01,
     &8.1347E+01,6.2416E+01,4.3933E+01,2.4619E+01,2.3170E-01,
     &1.0653E+02,8.1514E+01,5.7203E+01,3.2018E+01,2.9859E-01,
     &1.3711E+02,1.0461E+02,7.3196E+01,4.0838E+01,3.8265E-01,
     &1.7349E+02,1.3202E+02,9.2179E+01,5.1271E+01,4.7154E-01/
      DATA ((KB(JS,JT,37,13),JS=1,5),JT=1,5) /
     &5.5040E+01,4.2456E+01,3.0166E+01,1.6967E+01,1.4686E-01,
     &7.4751E+01,5.7522E+01,4.0627E+01,2.2828E+01,1.9745E-01,
     &9.9126E+01,7.6001E+01,5.3446E+01,3.0003E+01,2.5830E-01,
     &1.2888E+02,9.8527E+01,6.9056E+01,3.8643E+01,3.3278E-01,
     &1.6453E+02,1.2541E+02,8.7685E+01,4.8918E+01,4.1260E-01/
      DATA ((KB(JS,JT,38,13),JS=1,5),JT=1,5) /
     &4.9859E+01,3.8586E+01,2.7550E+01,1.5547E+01,1.2396E-01,
     &6.8738E+01,5.3032E+01,3.7612E+01,2.1200E+01,1.6720E-01,
     &9.2373E+01,7.0999E+01,5.0053E+01,2.8170E+01,2.2370E-01,
     &1.2130E+02,9.2918E+01,6.5279E+01,3.6626E+01,2.8704E-01,
     &1.5627E+02,1.1930E+02,8.3547E+01,4.6739E+01,3.6180E-01/
      DATA ((KB(JS,JT,39,13),JS=1,5),JT=1,5) /
     &4.5302E+01,3.5171E+01,2.5236E+01,1.4286E+01,1.0568E-01,
     &6.3391E+01,4.9041E+01,3.4923E+01,1.9751E+01,1.4249E-01,
     &8.6323E+01,6.6507E+01,4.7040E+01,2.6533E+01,1.9303E-01,
     &1.1457E+02,8.7914E+01,6.1899E+01,3.4824E+01,2.4868E-01,
     &1.4887E+02,1.1383E+02,7.9847E+01,4.4779E+01,3.1416E-01/
      DATA ((KB(JS,JT,40,13),JS=1,5),JT=1,5) /
     &4.0177E+01,3.1298E+01,2.2565E+01,1.2805E+01,8.8138E-02,
     &5.7199E+01,4.4376E+01,3.1743E+01,1.8006E+01,1.1856E-01,
     &7.9150E+01,6.1135E+01,4.3398E+01,2.4540E+01,1.6359E-01,
     &1.0651E+02,8.1890E+01,5.7786E+01,3.2576E+01,2.1421E-01,
     &1.3985E+02,1.0710E+02,7.5255E+01,4.2282E+01,2.7560E-01/
      DATA ((KB(JS,JT,41,13),JS=1,5),JT=1,5) /
     &3.5483E+01,2.7745E+01,2.0104E+01,1.1435E+01,7.4578E-02,
     &5.1443E+01,4.0033E+01,2.8766E+01,1.6358E+01,1.0080E-01,
     &7.2353E+01,5.6024E+01,3.9928E+01,2.2644E+01,1.3798E-01,
     &9.8821E+01,7.6124E+01,5.3862E+01,3.0414E+01,1.8395E-01,
     &1.3121E+02,1.0062E+02,7.0817E+01,3.9858E+01,2.3971E-01/
      DATA ((KB(JS,JT,42,13),JS=1,5),JT=1,5) /
     &3.1312E+01,2.4582E+01,1.7898E+01,1.0203E+01,6.3311E-02,
     &4.6257E+01,3.6106E+01,2.6059E+01,1.4850E+01,8.5987E-02,
     &6.6134E+01,5.1324E+01,3.6711E+01,2.0879E+01,1.1696E-01,
     &9.1649E+01,7.0739E+01,5.0191E+01,2.8396E+01,1.5868E-01,
     &1.2315E+02,9.4550E+01,6.6649E+01,3.7570E+01,2.0886E-01/
      DATA ((KB(JS,JT,43,13),JS=1,5),JT=1,5) /
     &2.7228E+01,2.1458E+01,1.5694E+01,8.9614E+00,5.3608E-02,
     &4.1053E+01,3.2140E+01,2.3306E+01,1.3302E+01,7.1800E-02,
     &5.9801E+01,4.6516E+01,3.3390E+01,1.9030E+01,9.7105E-02,
     &8.4239E+01,6.5135E+01,4.6335E+01,2.6274E+01,1.3391E-01,
     &1.1479E+02,8.8247E+01,6.2314E+01,3.5145E+01,1.7840E-01/
      DATA ((KB(JS,JT,44,13),JS=1,5),JT=1,5) /
     &2.3465E+01,1.8562E+01,1.3638E+01,7.7925E+00,4.4874E-02,
     &3.6146E+01,2.8382E+01,2.0672E+01,1.1814E+01,5.9063E-02,
     &5.3714E+01,4.1873E+01,3.0165E+01,1.7212E+01,7.9828E-02,
     &7.6981E+01,5.9614E+01,4.2519E+01,2.4160E+01,1.1248E-01,
     &1.0651E+02,8.1983E+01,5.8013E+01,3.2734E+01,1.4901E-01/
      DATA ((KB(JS,JT,45,13),JS=1,5),JT=1,5) /
     &2.0186E+01,1.6021E+01,1.1808E+01,6.7511E+00,3.7575E-02,
     &3.1735E+01,2.4996E+01,1.8280E+01,1.0459E+01,4.9524E-02,
     &4.8111E+01,3.7595E+01,2.7182E+01,1.5526E+01,6.7700E-02,
     &7.0180E+01,5.4438E+01,3.8926E+01,2.2155E+01,9.2168E-02,
     &9.8620E+01,7.6015E+01,5.3889E+01,3.0449E+01,1.2546E-01/
      DATA ((KB(JS,JT,46,13),JS=1,5),JT=1,5) /
     &1.7168E+01,1.3674E+01,1.0102E+01,5.7721E+00,3.1506E-02,
     &2.7551E+01,2.1759E+01,1.5975E+01,9.1472E+00,4.1368E-02,
     &4.2631E+01,3.3389E+01,2.4233E+01,1.3855E+01,5.6581E-02,
     &6.3374E+01,4.9245E+01,3.5311E+01,2.0117E+01,7.4981E-02,
     &9.0545E+01,6.9872E+01,4.9627E+01,2.8091E+01,1.0356E-01/
      DATA ((KB(JS,JT,47,13),JS=1,5),JT=1,5) /
     &1.4285E+01,1.1420E+01,8.4474E+00,4.8173E+00,2.6647E-02,
     &2.3421E+01,1.8547E+01,1.3658E+01,7.8222E+00,3.5142E-02,
     &3.7014E+01,2.9064E+01,2.1182E+01,1.2119E+01,4.6223E-02,
     &5.6196E+01,4.3754E+01,3.1477E+01,1.7951E+01,6.2561E-02,
     &8.1804E+01,6.3215E+01,4.5000E+01,2.5512E+01,8.4936E-02/
      DATA ((KB(JS,JT,48,13),JS=1,5),JT=1,5) /
     &1.1839E+01,9.5013E+00,7.0342E+00,3.9991E+00,2.2276E-02,
     &1.9820E+01,1.5737E+01,1.1620E+01,6.6464E+00,2.9148E-02,
     &3.1994E+01,2.5174E+01,1.8417E+01,1.0540E+01,3.8297E-02,
     &4.9572E+01,3.8675E+01,2.7923E+01,1.5936E+01,5.2300E-02,
     &7.3600E+01,5.6966E+01,4.0638E+01,2.3068E+01,6.9650E-02/
      DATA ((KB(JS,JT,49,13),JS=1,5),JT=1,5) /
     &9.7471E+00,7.8584E+00,5.8267E+00,3.3020E+00,1.8196E-02,
     &1.6704E+01,1.3302E+01,9.8376E+00,5.6165E+00,2.4552E-02,
     &2.7532E+01,2.1706E+01,1.5922E+01,9.1112E+00,3.1859E-02,
     &4.3516E+01,3.4017E+01,2.4645E+01,1.4071E+01,4.2368E-02,
     &6.5913E+01,5.1094E+01,3.6540E+01,2.0762E+01,5.7956E-02/
      DATA ((KB(JS,JT,50,13),JS=1,5),JT=1,5) /
     &8.0804E+00,6.5442E+00,4.8528E+00,2.7471E+00,1.5480E-02,
     &1.4208E+01,1.1343E+01,8.3916E+00,4.7793E+00,2.1108E-02,
     &2.3865E+01,1.8845E+01,1.3856E+01,7.9173E+00,2.8070E-02,
     &3.8439E+01,3.0084E+01,2.1861E+01,1.2484E+01,3.6716E-02,
     &5.9311E+01,4.6040E+01,3.3007E+01,1.8765E+01,4.7982E-02/
      DATA ((KB(JS,JT,51,13),JS=1,5),JT=1,5) /
     &6.6974E+00,5.4506E+00,4.0401E+00,2.2835E+00,1.2897E-02,
     &1.2105E+01,9.6894E+00,7.1742E+00,4.0729E+00,1.8234E-02,
     &2.0726E+01,1.6392E+01,1.2076E+01,6.8856E+00,2.4297E-02,
     &3.4010E+01,2.6646E+01,1.9402E+01,1.1077E+01,3.1447E-02,
     &5.3414E+01,4.1508E+01,2.9825E+01,1.6965E+01,4.1659E-02/
      DATA ((KB(JS,JT,52,13),JS=1,5),JT=1,5) /
     &5.5139E+00,4.5099E+00,3.3452E+00,1.8859E+00,1.0839E-02,
     &1.0265E+01,8.2392E+00,6.1066E+00,3.4594E+00,1.5307E-02,
     &1.7969E+01,1.4231E+01,1.0492E+01,5.9702E+00,2.0782E-02,
     &3.0022E+01,2.3539E+01,1.7173E+01,9.7942E+00,2.7615E-02,
     &4.7976E+01,3.7311E+01,2.6868E+01,1.5284E+01,3.5883E-02/
      DATA ((KB(JS,JT,53,13),JS=1,5),JT=1,5) /
     &4.5089E+00,3.7050E+00,2.7486E+00,1.5449E+00,8.8988E-03,
     &8.6595E+00,6.9701E+00,5.1646E+00,2.9217E+00,1.2928E-02,
     &1.5539E+01,1.2324E+01,9.0856E+00,5.1569E+00,1.7922E-02,
     &2.6425E+01,2.0735E+01,1.5153E+01,8.6253E+00,2.3907E-02,
     &4.2979E+01,3.3444E+01,2.4119E+01,1.3719E+01,3.1307E-02/
      DATA ((KB(JS,JT,54,13),JS=1,5),JT=1,5) /
     &3.7369E+00,3.0844E+00,2.2855E+00,1.2806E+00,7.5969E-03,
     &7.3945E+00,5.9700E+00,4.4241E+00,2.4976E+00,1.1170E-02,
     &1.3610E+01,1.0807E+01,7.9714E+00,4.5128E+00,1.6129E-02,
     &2.3560E+01,1.8494E+01,1.3530E+01,7.6837E+00,2.1838E-02,
     &3.8949E+01,3.0311E+01,2.1882E+01,1.2434E+01,2.8239E-02/
      DATA ((KB(JS,JT,55,13),JS=1,5),JT=1,5) /
     &3.1147E+00,2.5777E+00,1.9050E+00,1.0637E+00,6.5369E-03,
     &6.3439E+00,5.1347E+00,3.8054E+00,2.1454E+00,1.0024E-02,
     &1.1985E+01,9.5229E+00,7.0258E+00,3.9713E+00,1.4330E-02,
     &2.1145E+01,1.6600E+01,1.2148E+01,6.8814E+00,1.9929E-02,
     &3.5505E+01,2.7628E+01,1.9956E+01,1.1323E+01,2.6070E-02/
      DATA ((KB(JS,JT,56,13),JS=1,5),JT=1,5) /
     &2.5841E+00,2.1412E+00,1.5792E+00,8.7847E-01,5.7272E-03,
     &5.4279E+00,4.4047E+00,3.2621E+00,1.8370E+00,9.0085E-03,
     &1.0541E+01,8.3802E+00,6.1801E+00,3.4870E+00,1.2894E-02,
     &1.8998E+01,1.4914E+01,1.0910E+01,6.1631E+00,1.8216E-02,
     &3.2387E+01,2.5195E+01,1.8200E+01,1.0311E+01,2.5017E-02/
      DATA ((KB(JS,JT,57,13),JS=1,5),JT=1,5) /
     &2.1273E+00,1.7663E+00,1.2997E+00,7.2182E-01,4.9990E-03,
     &4.6288E+00,3.7653E+00,2.7876E+00,1.5653E+00,7.9939E-03,
     &9.2459E+00,7.3572E+00,5.4258E+00,3.0550E+00,1.1761E-02,
     &1.7067E+01,1.3395E+01,9.7952E+00,5.5222E+00,1.6851E-02,
     &2.9574E+01,2.2993E+01,1.6606E+01,9.3912E+00,2.2852E-02/
      DATA ((KB(JS,JT,58,13),JS=1,5),JT=1,5) /
     &8.4744E-01,8.1145E-01,7.0194E-01,4.7172E-01,4.4639E-03,
     &1.9303E+00,1.8049E+00,1.5645E+00,1.0595E+00,7.1718E-03,
     &3.9593E+00,3.6185E+00,3.1318E+00,2.1308E+00,1.0759E-02,
     &7.4878E+00,6.7423E+00,5.7807E+00,3.9390E+00,1.5270E-02,
     &1.3201E+01,1.1774E+01,9.9717E+00,6.8098E+00,2.1046E-02/
      DATA ((KB(JS,JT,59,13),JS=1,5),JT=1,5) /
     &7.8389E-01,7.5361E-01,6.5545E-01,4.4390E-01,4.7731E-03,
     &1.8316E+00,1.7144E+00,1.4906E+00,1.0154E+00,7.3182E-03,
     &3.8012E+00,3.4796E+00,3.0220E+00,2.0697E+00,1.0970E-02,
     &7.2668E+00,6.5534E+00,5.6332E+00,3.8611E+00,1.5317E-02,
     &1.2911E+01,1.1536E+01,9.7915E+00,6.7229E+00,2.2015E-02/
      DATA ((KB(JS,JT,13,14),JS=1,5),JT=1,5) /
     &2.9725E+02,2.2295E+02,1.4862E+02,7.4314E+01,8.5883E-01,
     &4.1294E+02,3.0971E+02,2.0649E+02,1.0324E+02,7.4403E-01,
     &5.5502E+02,4.1625E+02,2.7751E+02,1.3875E+02,6.6008E-01,
     &7.2029E+02,5.4024E+02,3.6017E+02,1.8008E+02,1.1155E+00,
     &9.0592E+02,6.7946E+02,4.5296E+02,2.2648E+02,2.5465E+00/
      DATA ((KB(JS,JT,14,14),JS=1,5),JT=1,5) /
     &3.2435E+02,2.4326E+02,1.6217E+02,8.1092E+01,7.8098E-01,
     &4.4892E+02,3.3668E+02,2.2444E+02,1.1223E+02,5.4602E-01,
     &6.0099E+02,4.5075E+02,3.0049E+02,1.5025E+02,1.0325E+00,
     &7.7937E+02,5.8453E+02,3.8969E+02,1.9485E+02,1.5016E+00,
     &9.8034E+02,7.3527E+02,4.9018E+02,2.4510E+02,3.4894E+00/
      DATA ((KB(JS,JT,15,14),JS=1,5),JT=1,5) /
     &3.4430E+02,2.5823E+02,1.7215E+02,8.6071E+01,4.7442E-01,
     &4.7694E+02,3.5770E+02,2.3846E+02,1.1924E+02,9.8957E-01,
     &6.3659E+02,4.7745E+02,3.1829E+02,1.5915E+02,1.3277E+00,
     &8.2316E+02,6.1735E+02,4.1157E+02,2.0578E+02,2.6545E+00,
     &1.0339E+03,7.7536E+02,5.1695E+02,2.5844E+02,4.8753E+00/
      DATA ((KB(JS,JT,16,14),JS=1,5),JT=1,5) /
     &3.6224E+02,2.7168E+02,1.8111E+02,9.0555E+01,8.6361E-01,
     &5.0155E+02,3.7615E+02,2.5077E+02,1.2539E+02,1.3098E+00,
     &6.6682E+02,5.0012E+02,3.3343E+02,1.6672E+02,2.0810E+00,
     &8.5980E+02,6.4485E+02,4.2990E+02,2.1496E+02,4.0118E+00,
     &1.0768E+03,8.0756E+02,5.3838E+02,2.6919E+02,6.0151E+00/
      DATA ((KB(JS,JT,17,14),JS=1,5),JT=1,5) /
     &3.8011E+02,2.8509E+02,1.9007E+02,9.5029E+01,1.2720E+00,
     &5.2601E+02,3.9448E+02,2.6301E+02,1.3150E+02,1.5543E+00,
     &6.9761E+02,5.2320E+02,3.4880E+02,1.7439E+02,2.9841E+00,
     &8.9515E+02,6.7136E+02,4.4757E+02,2.2378E+02,4.6409E+00,
     &1.1181E+03,8.3857E+02,5.5903E+02,2.7954E+02,6.6157E+00/
      DATA ((KB(JS,JT,18,14),JS=1,5),JT=1,5) /
     &3.9222E+02,2.9415E+02,1.9611E+02,9.8051E+01,1.3802E+00,
     &5.4105E+02,4.0577E+02,2.7053E+02,1.3526E+02,2.0079E+00,
     &7.1441E+02,5.3583E+02,3.5723E+02,1.7861E+02,3.3624E+00,
     &9.1265E+02,6.8450E+02,4.5632E+02,2.2816E+02,4.9650E+00,
     &1.1336E+03,8.5015E+02,5.6679E+02,2.8338E+02,6.8761E+00/
      DATA ((KB(JS,JT,19,14),JS=1,5),JT=1,5) /
     &4.0839E+02,3.0630E+02,2.0420E+02,1.0209E+02,1.4198E+00,
     &5.5968E+02,4.1977E+02,2.7985E+02,1.3992E+02,2.2241E+00,
     &7.3637E+02,5.5226E+02,3.6818E+02,1.8410E+02,3.5653E+00,
     &9.3504E+02,7.0126E+02,4.6751E+02,2.3375E+02,5.1035E+00,
     &1.1560E+03,8.6697E+02,5.7801E+02,2.8901E+02,6.9044E+00/
      DATA ((KB(JS,JT,20,14),JS=1,5),JT=1,5) /
     &4.2971E+02,3.2229E+02,2.1485E+02,1.0743E+02,1.5393E+00,
     &5.8587E+02,4.3942E+02,2.9293E+02,1.4647E+02,2.2601E+00,
     &7.6617E+02,5.7464E+02,3.8311E+02,1.9155E+02,3.5353E+00,
     &9.6798E+02,7.2594E+02,4.8398E+02,2.4197E+02,5.0919E+00,
     &1.1898E+03,8.9235E+02,5.9489E+02,2.9744E+02,6.7835E+00/
      DATA ((KB(JS,JT,21,14),JS=1,5),JT=1,5) /
     &4.4889E+02,3.3666E+02,2.2444E+02,1.1222E+02,1.6427E+00,
     &6.0830E+02,4.5623E+02,3.0417E+02,1.5208E+02,2.2298E+00,
     &7.9080E+02,5.9312E+02,3.9541E+02,1.9769E+02,3.4367E+00,
     &9.9371E+02,7.4527E+02,4.9684E+02,2.4842E+02,4.8609E+00,
     &1.2155E+03,9.1159E+02,6.0771E+02,3.0387E+02,6.5479E+00/
      DATA ((KB(JS,JT,22,14),JS=1,5),JT=1,5) /
     &4.7127E+02,3.5343E+02,2.3563E+02,1.1782E+02,1.6925E+00,
     &6.3239E+02,4.7428E+02,3.1618E+02,1.5809E+02,2.2427E+00,
     &8.1553E+02,6.1164E+02,4.0775E+02,2.0390E+02,3.3409E+00,
     &1.0189E+03,7.6417E+02,5.0944E+02,2.5480E+02,4.6697E+00,
     &1.2378E+03,9.2835E+02,6.1890E+02,3.0965E+02,6.2760E+00/
      DATA ((KB(JS,JT,23,14),JS=1,5),JT=1,5) /
     &4.8713E+02,3.6534E+02,2.4356E+02,1.2192E+02,1.6599E+00,
     &6.4775E+02,4.8583E+02,3.2387E+02,1.6212E+02,2.1938E+00,
     &8.3023E+02,6.2268E+02,4.1512E+02,2.0786E+02,3.2003E+00,
     &1.0300E+03,7.7249E+02,5.1499E+02,2.5803E+02,4.4341E+00,
     &1.2450E+03,9.3374E+02,6.2249E+02,3.1208E+02,5.9729E+00/
      DATA ((KB(JS,JT,24,14),JS=1,5),JT=1,5) /
     &5.0112E+02,3.7583E+02,2.5056E+02,1.2575E+02,1.5724E+00,
     &6.6153E+02,4.9614E+02,3.3076E+02,1.6604E+02,2.1250E+00,
     &8.4162E+02,6.3120E+02,4.2079E+02,2.1132E+02,3.0488E+00,
     &1.0387E+03,7.7903E+02,5.1934E+02,2.6092E+02,4.1964E+00,
     &1.2497E+03,9.3727E+02,6.2485E+02,3.1407E+02,5.6661E+00/
      DATA ((KB(JS,JT,25,14),JS=1,5),JT=1,5) /
     &5.0957E+02,3.8217E+02,2.5479E+02,1.2836E+02,1.4865E+00,
     &6.6771E+02,5.0078E+02,3.3385E+02,1.6824E+02,2.0184E+00,
     &8.4466E+02,6.3351E+02,4.2233E+02,2.1290E+02,2.8760E+00,
     &1.0379E+03,7.7843E+02,5.1895E+02,2.6171E+02,3.9646E+00,
     &1.2454E+03,9.3411E+02,6.2273E+02,3.1409E+02,5.3432E+00/
      DATA ((KB(JS,JT,26,14),JS=1,5),JT=1,5) /
     &5.1543E+02,3.8657E+02,2.5772E+02,1.3040E+02,1.4310E+00,
     &6.7055E+02,5.0292E+02,3.3528E+02,1.6969E+02,1.9779E+00,
     &8.4393E+02,6.3294E+02,4.2195E+02,2.1362E+02,2.7140E+00,
     &1.0339E+03,7.7538E+02,5.1691E+02,2.6173E+02,3.7614E+00,
     &1.2377E+03,9.2822E+02,6.1881E+02,3.1339E+02,5.0524E+00/
      DATA ((KB(JS,JT,27,14),JS=1,5),JT=1,5) /
     &5.1680E+02,3.8760E+02,2.5844E+02,1.3139E+02,1.4644E+00,
     &6.6877E+02,5.0158E+02,3.3442E+02,1.7006E+02,1.9743E+00,
     &8.3912E+02,6.2935E+02,4.1964E+02,2.1343E+02,2.6423E+00,
     &1.0255E+03,7.6907E+02,5.1284E+02,2.6091E+02,3.5939E+00,
     &1.2273E+03,9.2048E+02,6.1378E+02,3.1226E+02,4.8265E+00/
      DATA ((KB(JS,JT,28,14),JS=1,5),JT=1,5) /
     &5.1471E+02,3.8604E+02,2.5761E+02,1.3161E+02,1.4975E+00,
     &6.6390E+02,4.9793E+02,3.3227E+02,1.6984E+02,1.9755E+00,
     &8.3099E+02,6.2328E+02,4.1590E+02,2.1266E+02,2.6592E+00,
     &1.0159E+03,7.6197E+02,5.0842E+02,2.5994E+02,3.4854E+00,
     &1.2168E+03,9.1262E+02,6.0898E+02,3.1138E+02,4.6837E+00/
      DATA ((KB(JS,JT,29,14),JS=1,5),JT=1,5) /
     &5.0817E+02,3.8113E+02,2.5474E+02,1.3092E+02,1.4861E+00,
     &6.5385E+02,4.9038E+02,3.2768E+02,1.6851E+02,1.9807E+00,
     &8.1862E+02,6.1397E+02,4.1013E+02,2.1090E+02,2.6083E+00,
     &1.0015E+03,7.5115E+02,5.0169E+02,2.5799E+02,3.4366E+00,
     &1.2004E+03,9.0023E+02,6.0130E+02,3.0911E+02,4.6309E+00/
      DATA ((KB(JS,JT,30,14),JS=1,5),JT=1,5) /
     &4.9890E+02,3.7416E+02,2.5051E+02,1.2967E+02,1.4792E+00,
     &6.4183E+02,4.8137E+02,3.2213E+02,1.6671E+02,1.9639E+00,
     &8.0457E+02,6.0342E+02,4.0369E+02,2.0889E+02,2.5564E+00,
     &9.8521E+02,7.3890E+02,4.9415E+02,2.5564E+02,3.4162E+00,
     &1.1820E+03,8.8651E+02,5.9274E+02,3.0646E+02,4.6345E+00/
      DATA ((KB(JS,JT,31,14),JS=1,5),JT=1,5) /
     &4.8682E+02,3.6513E+02,2.4494E+02,1.2775E+02,1.4549E+00,
     &6.2686E+02,4.7014E+02,3.1520E+02,1.6432E+02,1.8973E+00,
     &7.8640E+02,5.8981E+02,3.9524E+02,2.0591E+02,2.5203E+00,
     &9.6406E+02,7.2305E+02,4.8423E+02,2.5217E+02,3.4800E+00,
     &1.1586E+03,8.6894E+02,5.8171E+02,3.0260E+02,4.7311E+00/
      DATA ((KB(JS,JT,32,14),JS=1,5),JT=1,5) /
     &4.7960E+02,3.5970E+02,2.4176E+02,1.2713E+02,1.4049E+00,
     &6.1788E+02,4.6339E+02,3.1125E+02,1.6347E+02,1.8610E+00,
     &7.7566E+02,5.8175E+02,3.9047E+02,2.0479E+02,2.5736E+00,
     &9.5231E+02,7.1420E+02,4.7904E+02,2.5086E+02,3.5724E+00,
     &1.1464E+03,8.5978E+02,5.7626E+02,3.0128E+02,4.8525E+00/
      DATA ((KB(JS,JT,33,14),JS=1,5),JT=1,5) /
     &4.7673E+02,3.5758E+02,2.4086E+02,1.2764E+02,1.3592E+00,
     &6.1463E+02,4.6099E+02,3.1024E+02,1.6404E+02,1.8844E+00,
     &7.7253E+02,5.7937E+02,3.8948E+02,2.0544E+02,2.6672E+00,
     &9.4922E+02,7.1189E+02,4.7815E+02,2.5158E+02,3.7054E+00,
     &1.1446E+03,8.5842E+02,5.7603E+02,3.0239E+02,5.0353E+00/
      DATA ((KB(JS,JT,34,14),JS=1,5),JT=1,5) /
     &4.7829E+02,3.5882E+02,2.4214E+02,1.2917E+02,1.3360E+00,
     &6.1765E+02,4.6331E+02,3.1226E+02,1.6594E+02,1.9203E+00,
     &7.7743E+02,5.8310E+02,3.9256E+02,2.0792E+02,2.7349E+00,
     &9.5686E+02,7.1762E+02,4.8256E+02,2.5475E+02,3.8031E+00,
     &1.1550E+03,8.6629E+02,5.8189E+02,3.0631E+02,5.2021E+00/
      DATA ((KB(JS,JT,35,14),JS=1,5),JT=1,5) /
     &4.7226E+02,3.5443E+02,2.3957E+02,1.2851E+02,1.3086E+00,
     &6.1214E+02,4.5923E+02,3.0998E+02,1.6546E+02,1.9154E+00,
     &7.7280E+02,5.7976E+02,3.9077E+02,2.0773E+02,2.7357E+00,
     &9.5397E+02,7.1554E+02,4.8165E+02,2.5508E+02,3.8286E+00,
     &1.1540E+03,8.6552E+02,5.8187E+02,3.0708E+02,5.2636E+00/
      DATA ((KB(JS,JT,36,14),JS=1,5),JT=1,5) /
     &4.5693E+02,3.4301E+02,2.3220E+02,1.2520E+02,1.2533E+00,
     &5.9574E+02,4.4710E+02,3.0221E+02,1.6199E+02,1.8411E+00,
     &7.5609E+02,5.6723E+02,3.8282E+02,2.0421E+02,2.6504E+00,
     &9.3751E+02,7.0328E+02,4.7386E+02,2.5165E+02,3.7407E+00,
     &1.1381E+03,8.5353E+02,5.7430E+02,3.0378E+02,5.1704E+00/
      DATA ((KB(JS,JT,37,14),JS=1,5),JT=1,5) /
     &4.2922E+02,3.2232E+02,2.1847E+02,1.1834E+02,1.1213E+00,
     &5.6522E+02,4.2422E+02,2.8713E+02,1.5453E+02,1.6760E+00,
     &7.2332E+02,5.4281E+02,3.6673E+02,1.9621E+02,2.4344E+00,
     &9.0338E+02,6.7777E+02,4.5711E+02,2.4334E+02,3.4735E+00,
     &1.1034E+03,8.2764E+02,5.5725E+02,2.9534E+02,4.8510E+00/
      DATA ((KB(JS,JT,38,14),JS=1,5),JT=1,5) /
     &4.0355E+02,3.0314E+02,2.0578E+02,1.1195E+02,1.0088E+00,
     &5.3660E+02,4.0286E+02,2.7296E+02,1.4742E+02,1.5281E+00,
     &6.9245E+02,5.1973E+02,3.5152E+02,1.8858E+02,2.2407E+00,
     &8.7113E+02,6.5360E+02,4.4117E+02,2.3535E+02,3.2324E+00,
     &1.0703E+03,8.0291E+02,5.4092E+02,2.8714E+02,4.5526E+00/
      DATA ((KB(JS,JT,39,14),JS=1,5),JT=1,5) /
     &3.8048E+02,2.8595E+02,1.9433E+02,1.0614E+02,9.1242E-01,
     &5.1067E+02,3.8348E+02,2.6010E+02,1.4089E+02,1.4025E+00,
     &6.6451E+02,4.9880E+02,3.3759E+02,1.8159E+02,2.0765E+00,
     &8.4141E+02,6.3140E+02,4.2638E+02,2.2792E+02,3.0229E+00,
     &1.0396E+03,7.7992E+02,5.2571E+02,2.7947E+02,4.2952E+00/
      DATA ((KB(JS,JT,40,14),JS=1,5),JT=1,5) /
     &3.5133E+02,2.6415E+02,1.7970E+02,9.8495E+01,7.8366E-01,
     &4.7771E+02,3.5880E+02,2.4356E+02,1.3227E+02,1.2276E+00,
     &6.2817E+02,4.7163E+02,3.1937E+02,1.7209E+02,1.8434E+00,
     &8.0277E+02,6.0241E+02,4.0711E+02,2.1788E+02,2.7123E+00,
     &9.9978E+02,7.5011E+02,5.0577E+02,2.6911E+02,3.8911E+00/
      DATA ((KB(JS,JT,41,14),JS=1,5),JT=1,5) /
     &3.2342E+02,2.4324E+02,1.6567E+02,9.1094E+01,6.6818E-01,
     &4.4573E+02,3.3493E+02,2.2747E+02,1.2382E+02,1.0662E+00,
     &5.9252E+02,4.4488E+02,3.0145E+02,1.6269E+02,1.6310E+00,
     &7.6447E+02,5.7369E+02,3.8787E+02,2.0780E+02,2.4231E+00,
     &9.6002E+02,7.2027E+02,4.8589E+02,2.5869E+02,3.5110E+00/
      DATA ((KB(JS,JT,42,14),JS=1,5),JT=1,5) /
     &2.9741E+02,2.2375E+02,1.5256E+02,8.4130E+01,5.7099E-01,
     &4.1545E+02,3.1224E+02,2.1217E+02,1.1576E+02,9.2628E-01,
     &5.5858E+02,4.1944E+02,2.8433E+02,1.5367E+02,1.4426E+00,
     &7.2759E+02,5.4609E+02,3.6933E+02,1.9808E+02,2.1657E+00,
     &9.2131E+02,6.9128E+02,4.6648E+02,2.4850E+02,3.1673E+00/
      DATA ((KB(JS,JT,43,14),JS=1,5),JT=1,5) /
     &2.7012E+02,2.0330E+02,1.3875E+02,7.6704E+01,4.7188E-01,
     &3.8333E+02,2.8816E+02,1.9596E+02,1.0707E+02,7.8390E-01,
     &5.2268E+02,3.9255E+02,2.6617E+02,1.4400E+02,1.2434E+00,
     &6.8847E+02,5.1676E+02,3.4954E+02,1.8752E+02,1.8919E+00,
     &8.8050E+02,6.6068E+02,4.4591E+02,2.3760E+02,2.7970E+00/
      DATA ((KB(JS,JT,44,14),JS=1,5),JT=1,5) /
     &2.4333E+02,1.8320E+02,1.2513E+02,6.9324E+01,3.8543E-01,
     &3.5160E+02,2.6439E+02,1.7983E+02,9.8391E+01,6.5410E-01,
     &4.8672E+02,3.6559E+02,2.4794E+02,1.3422E+02,1.0574E+00,
     &6.4907E+02,4.8721E+02,3.2959E+02,1.7683E+02,1.6338E+00,
     &8.3935E+02,6.2981E+02,4.2512E+02,2.2646E+02,2.4460E+00/
      DATA ((KB(JS,JT,45,14),JS=1,5),JT=1,5) /
     &2.1826E+02,1.6439E+02,1.1240E+02,6.2387E+01,3.1362E-01,
     &3.2151E+02,2.4179E+02,1.6452E+02,9.0130E+01,5.4229E-01,
     &4.5202E+02,3.3957E+02,2.3034E+02,1.2476E+02,8.9432E-01,
     &6.1098E+02,4.5864E+02,3.1027E+02,1.6648E+02,1.4094E+00,
     &7.9903E+02,5.9956E+02,4.0465E+02,2.1549E+02,2.1336E+00/
      DATA ((KB(JS,JT,46,14),JS=1,5),JT=1,5) /
     &1.9334E+02,1.4567E+02,9.9705E+01,5.5445E+01,2.5106E-01,
     &2.9084E+02,2.1878E+02,1.4895E+02,8.1712E+01,4.4167E-01,
     &4.1605E+02,3.1260E+02,2.1206E+02,1.1494E+02,7.4589E-01,
     &5.7087E+02,4.2857E+02,2.8993E+02,1.5559E+02,1.1995E+00,
     &7.5566E+02,5.6703E+02,3.8272E+02,2.0372E+02,1.8420E+00/
      DATA ((KB(JS,JT,47,14),JS=1,5),JT=1,5) /
     &1.6734E+02,1.2615E+02,8.6467E+01,4.8182E+01,1.9607E-01,
     &2.5798E+02,1.9414E+02,1.3227E+02,7.2690E+01,3.4728E-01,
     &3.7682E+02,2.8319E+02,1.9216E+02,1.0425E+02,6.0496E-01,
     &5.2596E+02,3.9489E+02,2.6718E+02,1.4343E+02,9.9190E-01,
     &7.0637E+02,5.3006E+02,3.5776E+02,1.9039E+02,1.5539E+00/
      DATA ((KB(JS,JT,48,14),JS=1,5),JT=1,5) /
     &1.4359E+02,1.0831E+02,7.4350E+01,4.1515E+01,1.5112E-01,
     &2.2736E+02,1.7115E+02,1.1670E+02,6.4242E+01,2.7228E-01,
     &3.3955E+02,2.5527E+02,1.7326E+02,9.4064E+01,4.8587E-01,
     &4.8257E+02,3.6236E+02,2.4521E+02,1.3165E+02,8.1598E-01,
     &6.5841E+02,4.9408E+02,3.3351E+02,1.7744E+02,1.3043E+00/
      DATA ((KB(JS,JT,49,14),JS=1,5),JT=1,5) /
     &1.2205E+02,9.2102E+01,6.3332E+01,3.5432E+01,1.1595E-01,
     &1.9899E+02,1.4985E+02,1.0228E+02,5.6393E+01,2.1177E-01,
     &3.0425E+02,2.2876E+02,1.5534E+02,8.4415E+01,3.8749E-01,
     &4.4104E+02,3.3122E+02,2.2413E+02,1.2036E+02,6.6950E-01,
     &6.1182E+02,4.5914E+02,3.0987E+02,1.6480E+02,1.0872E+00/
      DATA ((KB(JS,JT,50,14),JS=1,5),JT=1,5) /
     &1.0410E+02,7.8601E+01,5.4134E+01,3.0320E+01,8.9437E-02,
     &1.7476E+02,1.3166E+02,8.9943E+01,4.9647E+01,1.6487E-01,
     &2.7363E+02,2.0578E+02,1.3977E+02,7.5998E+01,3.0880E-01,
     &4.0470E+02,3.0398E+02,2.0569E+02,1.1045E+02,5.4711E-01,
     &5.7059E+02,4.2823E+02,2.8900E+02,1.5363E+02,9.1135E-01/
      DATA ((KB(JS,JT,51,14),JS=1,5),JT=1,5) /
     &8.8591E+01,6.6918E+01,4.6161E+01,2.5881E+01,7.0825E-02,
     &1.5315E+02,1.1542E+02,7.8914E+01,4.3611E+01,1.2808E-01,
     &2.4591E+02,1.8497E+02,1.2567E+02,6.8391E+01,2.4633E-01,
     &3.7125E+02,2.7889E+02,1.8871E+02,1.0133E+02,4.4644E-01,
     &5.3232E+02,3.9953E+02,2.6959E+02,1.4324E+02,7.6098E-01/
      DATA ((KB(JS,JT,52,14),JS=1,5),JT=1,5) /
     &7.4832E+01,5.6551E+01,3.9072E+01,2.1921E+01,5.8568E-02,
     &1.3340E+02,1.0056E+02,6.8804E+01,3.8048E+01,9.9737E-02,
     &2.2000E+02,1.6553E+02,1.1251E+02,6.1251E+01,1.9573E-01,
     &3.3944E+02,2.5503E+02,1.7256E+02,9.2621E+01,3.6167E-01,
     &4.9563E+02,3.7201E+02,2.5099E+02,1.3326E+02,6.3209E-01/
      DATA ((KB(JS,JT,53,14),JS=1,5),JT=1,5) /
     &6.2655E+01,4.7378E+01,3.2786E+01,1.8402E+01,5.0324E-02,
     &1.1533E+02,8.6961E+01,5.9562E+01,3.2947E+01,7.6555E-02,
     &1.9565E+02,1.4725E+02,1.0014E+02,5.4560E+01,1.5441E-01,
     &3.0901E+02,2.3220E+02,1.5711E+02,8.4327E+01,2.9159E-01,
     &4.6024E+02,3.4547E+02,2.3304E+02,1.2363E+02,5.2012E-01/
      DATA ((KB(JS,JT,54,14),JS=1,5),JT=1,5) /
     &5.3046E+01,4.0133E+01,2.7816E+01,1.5611E+01,4.2542E-02,
     &1.0074E+02,7.5982E+01,5.2075E+01,2.8803E+01,6.4322E-02,
     &1.7557E+02,1.3215E+02,8.9882E+01,4.8976E+01,1.2163E-01,
     &2.8382E+02,2.1329E+02,1.4431E+02,7.7417E+01,2.3542E-01,
     &4.3075E+02,3.2335E+02,2.1806E+02,1.1557E+02,4.2927E-01/
      DATA ((KB(JS,JT,55,14),JS=1,5),JT=1,5) /
     &4.5010E+01,3.4076E+01,2.3656E+01,1.3271E+01,3.8508E-02,
     &8.8262E+01,6.6580E+01,4.5655E+01,2.5232E+01,5.7123E-02,
     &1.5805E+02,1.1897E+02,8.0930E+01,4.4073E+01,9.5519E-02,
     &2.6161E+02,1.9662E+02,1.3302E+02,7.1301E+01,1.9000E-01,
     &4.0466E+02,3.0378E+02,2.0480E+02,1.0841E+02,3.5396E-01/
      DATA ((KB(JS,JT,56,14),JS=1,5),JT=1,5) /
     &3.7999E+01,2.8791E+01,2.0014E+01,1.1214E+01,3.4994E-02,
     &7.7059E+01,5.8140E+01,3.9888E+01,2.2021E+01,5.1685E-02,
     &1.4187E+02,1.0680E+02,7.2655E+01,3.9531E+01,7.7408E-02,
     &2.4069E+02,1.8091E+02,1.2237E+02,6.5530E+01,1.5216E-01,
     &3.8007E+02,2.8533E+02,1.9230E+02,1.0164E+02,2.8842E-01/
      DATA ((KB(JS,JT,57,14),JS=1,5),JT=1,5) /
     &3.1951E+01,2.4226E+01,1.6863E+01,9.4281E+00,3.3086E-02,
     &6.6995E+01,5.0555E+01,3.4699E+01,1.9133E+01,4.5516E-02,
     &1.2705E+02,9.5650E+01,6.5062E+01,3.5359E+01,6.7958E-02,
     &2.2106E+02,1.6616E+02,1.1237E+02,6.0096E+01,1.2025E-01,
     &3.5683E+02,2.6789E+02,1.8049E+02,9.5240E+01,2.3463E-01/
      DATA ((KB(JS,JT,58,14),JS=1,5),JT=1,5) /
     &1.3120E+01,1.1427E+01,9.3421E+00,6.3041E+00,2.9290E-02,
     &2.8375E+01,2.4586E+01,1.9815E+01,1.3205E+01,4.1783E-02,
     &5.5462E+01,4.7938E+01,3.8264E+01,2.5126E+01,6.2497E-02,
     &9.8962E+01,8.5397E+01,6.7764E+01,4.3784E+01,9.9579E-02,
     &1.6330E+02,1.4075E+02,1.1126E+02,7.0923E+01,1.9106E-01/
      DATA ((KB(JS,JT,59,14),JS=1,5),JT=1,5) /
     &1.2384E+01,1.0821E+01,8.8760E+00,6.0092E+00,2.9802E-02,
     &2.7135E+01,2.3592E+01,1.9085E+01,1.2767E+01,4.3735E-02,
     &5.3692E+01,4.6568E+01,3.7314E+01,2.4591E+01,6.7061E-02,
     &9.6831E+01,8.3852E+01,6.6810E+01,4.3324E+01,1.0825E-01,
     &1.6129E+02,1.3951E+02,1.1076E+02,7.0881E+01,1.7652E-01/
      DATA ((KB(JS,JT,13,15),JS=1,5),JT=1,5) /
     &4.3408E+02,3.2553E+02,2.1704E+02,1.0851E+02,3.3387E-01,
     &6.1113E+02,4.5841E+02,3.0560E+02,1.5279E+02,3.4060E+00,
     &8.2062E+02,6.1547E+02,4.1031E+02,2.0516E+02,7.3889E+00,
     &1.0625E+03,7.9684E+02,5.3120E+02,2.6560E+02,1.3324E+01,
     &1.3314E+03,9.9861E+02,6.6575E+02,3.3287E+02,1.8510E+01/
      DATA ((KB(JS,JT,14,15),JS=1,5),JT=1,5) /
     &4.8927E+02,3.6696E+02,2.4465E+02,1.2233E+02,1.4639E+00,
     &6.9247E+02,5.1938E+02,3.4624E+02,1.7311E+02,5.0161E+00,
     &9.3693E+02,7.0263E+02,4.6839E+02,2.3422E+02,9.2136E+00,
     &1.2198E+03,9.1484E+02,6.0989E+02,3.0495E+02,1.6015E+01,
     &1.5424E+03,1.1568E+03,7.7122E+02,3.8560E+02,2.0607E+01/
      DATA ((KB(JS,JT,15,15),JS=1,5),JT=1,5) /
     &5.4419E+02,4.0815E+02,2.7209E+02,1.3605E+02,3.3205E+00,
     &7.6785E+02,5.7588E+02,3.8392E+02,1.9198E+02,6.4585E+00,
     &1.0420E+03,7.8154E+02,5.2102E+02,2.6050E+02,1.2593E+01,
     &1.3650E+03,1.0239E+03,6.8254E+02,3.4127E+02,1.7743E+01,
     &1.7328E+03,1.2995E+03,8.6636E+02,4.3319E+02,2.2779E+01/
      DATA ((KB(JS,JT,16,15),JS=1,5),JT=1,5) /
     &5.9961E+02,4.4968E+02,2.9978E+02,1.4989E+02,4.3949E+00,
     &8.4044E+02,6.3032E+02,4.2019E+02,2.1011E+02,9.1201E+00,
     &1.1438E+03,8.5770E+02,5.7195E+02,2.8595E+02,1.4709E+01,
     &1.4993E+03,1.1245E+03,7.4965E+02,3.7484E+02,1.9517E+01,
     &1.9026E+03,1.4270E+03,9.5133E+02,4.7569E+02,2.4995E+01/
      DATA ((KB(JS,JT,17,15),JS=1,5),JT=1,5) /
     &6.5740E+02,4.9304E+02,3.2868E+02,1.6434E+02,5.9877E+00,
     &9.1769E+02,6.8825E+02,4.5884E+02,2.2941E+02,1.1589E+01,
     &1.2441E+03,9.3311E+02,6.2203E+02,3.1103E+02,1.6070E+01,
     &1.6286E+03,1.2214E+03,8.1435E+02,4.0716E+02,2.1263E+01,
     &2.0647E+03,1.5485E+03,1.0323E+03,5.1617E+02,2.7194E+01/
      DATA ((KB(JS,JT,18,15),JS=1,5),JT=1,5) /
     &7.0743E+02,5.3056E+02,3.5371E+02,1.7685E+02,7.5465E+00,
     &9.8473E+02,7.3856E+02,4.9235E+02,2.4618E+02,1.2708E+01,
     &1.3299E+03,9.9741E+02,6.6495E+02,3.3248E+02,1.7433E+01,
     &1.7379E+03,1.3034E+03,8.6887E+02,4.3447E+02,2.2996E+01,
     &2.2009E+03,1.6506E+03,1.1004E+03,5.5020E+02,2.9358E+01/
      DATA ((KB(JS,JT,19,15),JS=1,5),JT=1,5) /
     &7.7797E+02,5.8347E+02,3.8898E+02,1.9449E+02,8.9058E+00,
     &1.0795E+03,8.0964E+02,5.3974E+02,2.6988E+02,1.3760E+01,
     &1.4503E+03,1.0877E+03,7.2515E+02,3.6258E+02,1.8739E+01,
     &1.8906E+03,1.4179E+03,9.4523E+02,4.7263E+02,2.4641E+01,
     &2.3863E+03,1.7897E+03,1.1933E+03,5.9656E+02,3.1485E+01/
      DATA ((KB(JS,JT,20,15),JS=1,5),JT=1,5) /
     &8.7874E+02,6.5907E+02,4.3939E+02,2.1969E+02,9.7556E+00,
     &1.2128E+03,9.0962E+02,6.0638E+02,3.0319E+02,1.4896E+01,
     &1.6209E+03,1.2157E+03,8.1051E+02,4.0524E+02,2.0180E+01,
     &2.1009E+03,1.5756E+03,1.0504E+03,5.2525E+02,2.6433E+01,
     &2.6410E+03,1.9808E+03,1.3205E+03,6.6026E+02,3.3724E+01/
      DATA ((KB(JS,JT,21,15),JS=1,5),JT=1,5) /
     &9.9673E+02,7.4761E+02,4.9839E+02,2.4919E+02,1.0524E+01,
     &1.3673E+03,1.0255E+03,6.8366E+02,3.4184E+02,1.6075E+01,
     &1.8166E+03,1.3625E+03,9.0829E+02,4.5412E+02,2.1690E+01,
     &2.3404E+03,1.7553E+03,1.1702E+03,5.8508E+02,2.8346E+01,
     &2.9258E+03,2.1942E+03,1.4629E+03,7.3140E+02,3.6033E+01/
      DATA ((KB(JS,JT,22,15),JS=1,5),JT=1,5) /
     &1.1483E+03,8.6125E+02,5.7415E+02,2.8707E+02,1.1768E+01,
     &1.5630E+03,1.1723E+03,7.8152E+02,3.9076E+02,1.7624E+01,
     &2.0593E+03,1.5445E+03,1.0296E+03,5.1484E+02,2.3654E+01,
     &2.6282E+03,1.9711E+03,1.3140E+03,6.5702E+02,3.0777E+01,
     &3.2625E+03,2.4468E+03,1.6313E+03,8.1566E+02,3.8871E+01/
      DATA ((KB(JS,JT,23,15),JS=1,5),JT=1,5) /
     &1.3167E+03,9.8756E+02,6.5833E+02,3.2919E+02,1.3119E+01,
     &1.7766E+03,1.3324E+03,8.8830E+02,4.4413E+02,1.9267E+01,
     &2.3173E+03,1.7380E+03,1.1586E+03,5.7933E+02,2.5707E+01,
     &2.9343E+03,2.2007E+03,1.4671E+03,7.3355E+02,3.3186E+01,
     &3.6141E+03,2.7105E+03,1.8070E+03,9.0351E+02,4.1634E+01/
      DATA ((KB(JS,JT,24,15),JS=1,5),JT=1,5) /
     &1.5139E+03,1.1354E+03,7.5695E+02,3.7848E+02,1.4766E+01,
     &2.0213E+03,1.5159E+03,1.0107E+03,5.0532E+02,2.1039E+01,
     &2.6132E+03,1.9598E+03,1.3066E+03,6.5328E+02,2.7799E+01,
     &3.2798E+03,2.4598E+03,1.6399E+03,8.1993E+02,3.5585E+01,
     &4.0096E+03,3.0073E+03,2.0048E+03,1.0024E+03,4.4343E+01/
      DATA ((KB(JS,JT,25,15),JS=1,5),JT=1,5) /
     &1.7311E+03,1.2983E+03,8.6555E+02,4.3279E+02,1.6410E+01,
     &2.2880E+03,1.7160E+03,1.1440E+03,5.7204E+02,2.2852E+01,
     &2.9293E+03,2.1970E+03,1.4646E+03,7.3234E+02,2.9897E+01,
     &3.6441E+03,2.7331E+03,1.8220E+03,9.1101E+02,3.8003E+01,
     &4.4209E+03,3.3157E+03,2.2104E+03,1.1052E+03,4.7037E+01/
      DATA ((KB(JS,JT,26,15),JS=1,5),JT=1,5) /
     &1.9753E+03,1.4814E+03,9.8766E+02,4.9382E+02,1.8018E+01,
     &2.5844E+03,1.9383E+03,1.2922E+03,6.4606E+02,2.4551E+01,
     &3.2758E+03,2.4567E+03,1.6379E+03,8.1896E+02,3.2091E+01,
     &4.0392E+03,3.0293E+03,2.0196E+03,1.0098E+03,4.0504E+01,
     &4.8643E+03,3.6484E+03,2.4323E+03,1.2161E+03,4.9853E+01/
      DATA ((KB(JS,JT,27,15),JS=1,5),JT=1,5) /
     &2.2372E+03,1.6779E+03,1.1187E+03,5.5932E+02,1.9412E+01,
     &2.8964E+03,2.1723E+03,1.4482E+03,7.2410E+02,2.6199E+01,
     &3.6363E+03,2.7272E+03,1.8181E+03,9.0912E+02,3.4164E+01,
     &4.4487E+03,3.3365E+03,2.2244E+03,1.1122E+03,4.3003E+01,
     &5.3193E+03,3.9894E+03,2.6596E+03,1.3298E+03,5.2701E+01/
      DATA ((KB(JS,JT,28,15),JS=1,5),JT=1,5) /
     &2.5116E+03,1.8837E+03,1.2558E+03,6.2784E+02,2.0876E+01,
     &3.2189E+03,2.4142E+03,1.6096E+03,8.0476E+02,2.7949E+01,
     &4.0085E+03,3.0060E+03,2.0042E+03,1.0021E+03,3.6156E+01,
     &4.8660E+03,3.6495E+03,2.4329E+03,1.2165E+03,4.5448E+01,
     &5.7764E+03,4.3322E+03,2.8883E+03,1.4442E+03,5.5591E+01/
      DATA ((KB(JS,JT,29,15),JS=1,5),JT=1,5) /
     &2.7788E+03,2.0842E+03,1.3895E+03,6.9477E+02,2.2561E+01,
     &3.5298E+03,2.6472E+03,1.7648E+03,8.8246E+02,2.9936E+01,
     &4.3597E+03,3.2696E+03,2.1798E+03,1.0899E+03,3.8464E+01,
     &5.2526E+03,3.9395E+03,2.6263E+03,1.3131E+03,4.8125E+01,
     &6.1956E+03,4.6467E+03,3.0979E+03,1.5489E+03,5.8615E+01/
      DATA ((KB(JS,JT,30,15),JS=1,5),JT=1,5) /
     &3.0369E+03,2.2777E+03,1.5185E+03,7.5926E+02,2.4413E+01,
     &3.8244E+03,2.8684E+03,1.9122E+03,9.5609E+02,3.2061E+01,
     &4.6859E+03,3.5141E+03,2.3430E+03,1.1715E+03,4.0933E+01,
     &5.6065E+03,4.2050E+03,2.8032E+03,1.4016E+03,5.0897E+01,
     &6.5717E+03,4.9287E+03,3.2858E+03,1.6429E+03,6.1721E+01/
      DATA ((KB(JS,JT,31,15),JS=1,5),JT=1,5) /
     &3.2648E+03,2.4486E+03,1.6324E+03,8.1618E+02,2.6426E+01,
     &4.0756E+03,3.0566E+03,2.0378E+03,1.0190E+03,3.4471E+01,
     &4.9563E+03,3.7173E+03,2.4782E+03,1.2392E+03,4.3666E+01,
     &5.8911E+03,4.4181E+03,2.9455E+03,1.4727E+03,5.3750E+01,
     &6.8637E+03,5.1477E+03,3.4319E+03,1.7160E+03,6.4980E+01/
      DATA ((KB(JS,JT,32,15),JS=1,5),JT=1,5) /
     &3.4972E+03,2.6230E+03,1.7487E+03,8.7434E+02,2.8607E+01,
     &4.3306E+03,3.2480E+03,2.1653E+03,1.0827E+03,3.6943E+01,
     &5.2288E+03,3.9216E+03,2.6144E+03,1.3072E+03,4.6342E+01,
     &6.1756E+03,4.6314E+03,3.0875E+03,1.5439E+03,5.6744E+01,
     &7.1543E+03,5.3657E+03,3.5769E+03,1.7884E+03,6.8387E+01/
      DATA ((KB(JS,JT,33,15),JS=1,5),JT=1,5) /
     &3.7323E+03,2.7993E+03,1.8662E+03,9.3310E+02,3.0880E+01,
     &4.5855E+03,3.4391E+03,2.2927E+03,1.1463E+03,3.9458E+01,
     &5.4988E+03,4.1239E+03,2.7494E+03,1.3747E+03,4.9066E+01,
     &6.4556E+03,4.8415E+03,3.2279E+03,1.6139E+03,5.9834E+01,
     &7.4364E+03,5.5775E+03,3.7183E+03,1.8591E+03,7.1936E+01/
      DATA ((KB(JS,JT,34,15),JS=1,5),JT=1,5) /
     &3.9743E+03,2.9808E+03,1.9872E+03,9.9359E+02,3.2850E+01,
     &4.8517E+03,3.6384E+03,2.4257E+03,1.2129E+03,4.1615E+01,
     &5.7848E+03,4.3386E+03,2.8923E+03,1.4462E+03,5.1514E+01,
     &6.7566E+03,5.0673E+03,3.3783E+03,1.6891E+03,6.2632E+01,
     &7.7467E+03,5.8099E+03,3.8734E+03,1.9367E+03,7.5129E+01/
      DATA ((KB(JS,JT,35,15),JS=1,5),JT=1,5) /
     &4.1392E+03,3.1044E+03,2.0697E+03,1.0348E+03,3.4005E+01,
     &5.0338E+03,3.7756E+03,2.5169E+03,1.2585E+03,4.2889E+01,
     &5.9824E+03,4.4867E+03,2.9910E+03,1.4955E+03,5.2983E+01,
     &6.9652E+03,5.2239E+03,3.4826E+03,1.7414E+03,6.4327E+01,
     &7.9642E+03,5.9733E+03,3.9822E+03,1.9911E+03,7.7087E+01/
      DATA ((KB(JS,JT,36,15),JS=1,5),JT=1,5) /
     &4.2146E+03,3.1608E+03,2.1072E+03,1.0536E+03,3.4225E+01,
     &5.1200E+03,3.8401E+03,2.5599E+03,1.2800E+03,4.3139E+01,
     &6.0791E+03,4.5594E+03,3.0396E+03,1.5198E+03,5.3291E+01,
     &7.0718E+03,5.3037E+03,3.5357E+03,1.7679E+03,6.4713E+01,
     &8.0803E+03,6.0601E+03,4.0401E+03,2.0201E+03,7.7535E+01/
      DATA ((KB(JS,JT,37,15),JS=1,5),JT=1,5) /
     &4.1830E+03,3.1372E+03,2.0915E+03,1.0457E+03,3.3171E+01,
     &5.0955E+03,3.8218E+03,2.5477E+03,1.2739E+03,4.1938E+01,
     &6.0651E+03,4.5490E+03,3.0327E+03,1.5163E+03,5.1957E+01,
     &7.0708E+03,5.3029E+03,3.5354E+03,1.7678E+03,6.3244E+01,
     &8.0937E+03,6.0708E+03,4.0470E+03,2.0235E+03,7.5914E+01/
      DATA ((KB(JS,JT,38,15),JS=1,5),JT=1,5) /
     &4.1367E+03,3.1023E+03,2.0683E+03,1.0342E+03,3.2061E+01,
     &5.0552E+03,3.7913E+03,2.5275E+03,1.2638E+03,4.0668E+01,
     &6.0331E+03,4.5250E+03,3.0168E+03,1.5083E+03,5.0542E+01,
     &7.0503E+03,5.2874E+03,3.5252E+03,1.7626E+03,6.1670E+01,
     &8.0886E+03,6.0662E+03,4.0441E+03,2.0220E+03,7.4175E+01/
      DATA ((KB(JS,JT,39,15),JS=1,5),JT=1,5) /
     &4.0836E+03,3.0625E+03,2.0418E+03,1.0208E+03,3.0973E+01,
     &5.0068E+03,3.7549E+03,2.5034E+03,1.2516E+03,3.9423E+01,
     &5.9917E+03,4.4934E+03,2.9959E+03,1.4979E+03,4.9140E+01,
     &7.0190E+03,5.2646E+03,3.5096E+03,1.7548E+03,6.0110E+01,
     &8.0703E+03,6.0526E+03,4.0352E+03,2.0176E+03,7.2442E+01/
      DATA ((KB(JS,JT,40,15),JS=1,5),JT=1,5) /
     &3.9731E+03,2.9800E+03,1.9865E+03,9.9327E+02,2.9119E+01,
     &4.9010E+03,3.6760E+03,2.4505E+03,1.2252E+03,3.7284E+01,
     &5.8967E+03,4.4226E+03,2.9482E+03,1.4742E+03,4.6706E+01,
     &6.9401E+03,5.2049E+03,3.4701E+03,1.7350E+03,5.7383E+01,
     &8.0134E+03,6.0096E+03,4.0066E+03,2.0033E+03,6.9395E+01/
      DATA ((KB(JS,JT,41,15),JS=1,5),JT=1,5) /
     &3.8503E+03,2.8877E+03,1.9252E+03,9.6258E+02,2.7224E+01,
     &4.7815E+03,3.5862E+03,2.3908E+03,1.1953E+03,3.5101E+01,
     &5.7872E+03,4.3401E+03,2.8935E+03,1.4467E+03,4.4197E+01,
     &6.8458E+03,5.1341E+03,3.4225E+03,1.7115E+03,5.4583E+01,
     &7.9396E+03,5.9547E+03,3.9699E+03,1.9849E+03,6.6259E+01/
      DATA ((KB(JS,JT,42,15),JS=1,5),JT=1,5) /
     &3.7218E+03,2.7913E+03,1.8581E+03,9.3043E+02,2.5397E+01,
     &4.6552E+03,3.4913E+03,2.3275E+03,1.1638E+03,3.2985E+01,
     &5.6676E+03,4.2515E+03,2.8342E+03,1.4169E+03,4.1777E+01,
     &6.7404E+03,5.0552E+03,3.3706E+03,1.6852E+03,5.1833E+01,
     &7.8548E+03,5.8911E+03,3.9277E+03,1.9637E+03,6.3188E+01/
      DATA ((KB(JS,JT,43,15),JS=1,5),JT=1,5) /
     &3.5738E+03,2.6801E+03,1.7870E+03,8.9342E+02,2.3264E+01,
     &4.5111E+03,3.3834E+03,2.2559E+03,1.1277E+03,3.0494E+01,
     &5.5364E+03,4.1522E+03,2.7681E+03,1.3841E+03,3.8909E+01,
     &6.6297E+03,4.9723E+03,3.3147E+03,1.6574E+03,4.8575E+01,
     &7.7713E+03,5.8285E+03,3.8856E+03,1.9429E+03,5.9539E+01/
      DATA ((KB(JS,JT,44,15),JS=1,5),JT=1,5) /
     &3.4144E+03,2.5608E+03,1.7072E+03,8.5364E+02,2.1065E+01,
     &4.3569E+03,3.2674E+03,2.1784E+03,1.0893E+03,2.7929E+01,
     &5.3944E+03,4.0458E+03,2.6971E+03,1.3486E+03,3.5943E+01,
     &6.5105E+03,4.8828E+03,3.2554E+03,1.6276E+03,4.5182E+01,
     &7.6829E+03,5.7622E+03,3.8414E+03,1.9208E+03,5.5715E+01/
      DATA ((KB(JS,JT,45,15),JS=1,5),JT=1,5) /
     &3.2505E+03,2.4379E+03,1.6254E+03,8.1271E+02,1.8984E+01,
     &4.1974E+03,3.1481E+03,2.0989E+03,1.0493E+03,2.5493E+01,
     &5.2466E+03,3.9350E+03,2.6232E+03,1.3117E+03,3.3113E+01,
     &6.3833E+03,4.7875E+03,3.1918E+03,1.5958E+03,4.1930E+01,
     &7.5868E+03,5.6901E+03,3.7934E+03,1.8967E+03,5.2027E+01/
      DATA ((KB(JS,JT,46,15),JS=1,5),JT=1,5) /
     &3.0662E+03,2.2996E+03,1.5331E+03,7.6672E+02,1.6905E+01,
     &4.0155E+03,3.0116E+03,2.0079E+03,1.0039E+03,2.3041E+01,
     &5.0741E+03,3.8056E+03,2.5370E+03,1.2685E+03,3.0241E+01,
     &6.2294E+03,4.6721E+03,3.1149E+03,1.5573E+03,3.8622E+01,
     &7.4637E+03,5.5978E+03,3.7320E+03,1.8660E+03,4.8257E+01/
      DATA ((KB(JS,JT,47,15),JS=1,5),JT=1,5) /
     &2.8472E+03,2.1354E+03,1.4236E+03,7.1208E+02,1.4723E+01,
     &3.7952E+03,2.8464E+03,1.8976E+03,9.4874E+02,2.0451E+01,
     &4.8581E+03,3.6436E+03,2.4290E+03,1.2145E+03,2.7203E+01,
     &6.0303E+03,4.5227E+03,3.0151E+03,1.5075E+03,3.5112E+01,
     &7.2931E+03,5.4698E+03,3.6467E+03,1.8233E+03,4.4239E+01/
      DATA ((KB(JS,JT,48,15),JS=1,5),JT=1,5) /
     &2.6253E+03,1.9691E+03,1.3127E+03,6.5679E+02,1.2715E+01,
     &3.5692E+03,2.6769E+03,1.7846E+03,8.9231E+02,1.8030E+01,
     &4.6375E+03,3.4782E+03,2.3188E+03,1.1595E+03,2.4364E+01,
     &5.8244E+03,4.3683E+03,2.9120E+03,1.4560E+03,3.1792E+01,
     &7.1141E+03,5.3356E+03,3.5570E+03,1.7785E+03,4.0424E+01/
      DATA ((KB(JS,JT,49,15),JS=1,5),JT=1,5) /
     &2.4040E+03,1.8030E+03,1.2020E+03,6.0155E+02,1.0861E+01,
     &3.3401E+03,2.5051E+03,1.6700E+03,8.3512E+02,1.5777E+01,
     &4.4127E+03,3.3095E+03,2.2063E+03,1.1031E+03,2.1693E+01,
     &5.6115E+03,4.2087E+03,2.8058E+03,1.4030E+03,2.8659E+01,
     &6.9274E+03,5.1956E+03,3.4636E+03,1.7318E+03,3.6808E+01/
      DATA ((KB(JS,JT,50,15),JS=1,5),JT=1,5) /
     &2.2030E+03,1.6523E+03,1.1015E+03,5.5137E+02,9.2813E+00,
     &3.1297E+03,2.3473E+03,1.5649E+03,7.8265E+02,1.3818E+01,
     &4.2081E+03,3.1561E+03,2.1041E+03,1.0519E+03,1.9341E+01,
     &5.4214E+03,4.0660E+03,2.7107E+03,1.3553E+03,2.5902E+01,
     &6.7641E+03,5.0731E+03,3.3821E+03,1.6910E+03,3.3602E+01/
      DATA ((KB(JS,JT,51,15),JS=1,5),JT=1,5) /
     &2.0128E+03,1.5096E+03,1.0064E+03,5.0390E+02,7.8927E+00,
     &2.9276E+03,2.1957E+03,1.4638E+03,7.3206E+02,1.2046E+01,
     &4.0098E+03,3.0073E+03,2.0049E+03,1.0025E+03,1.7204E+01,
     &5.2399E+03,3.9299E+03,2.6200E+03,1.3100E+03,2.3387E+01,
     &6.6101E+03,4.9575E+03,3.3050E+03,1.6525E+03,3.0654E+01/
      DATA ((KB(JS,JT,52,15),JS=1,5),JT=1,5) /
     &1.8272E+03,1.3704E+03,9.1373E+02,4.5761E+02,6.6428E+00,
     &2.7256E+03,2.0442E+03,1.3627E+03,6.8167E+02,1.0409E+01,
     &3.8098E+03,2.8573E+03,1.9049E+03,9.5240E+02,1.5205E+01,
     &5.0575E+03,3.7931E+03,2.5288E+03,1.2643E+03,2.1008E+01,
     &6.4544E+03,4.8408E+03,3.2272E+03,1.6135E+03,2.7863E+01/
      DATA ((KB(JS,JT,53,15),JS=1,5),JT=1,5) /
     &1.6455E+03,1.2341E+03,8.2275E+02,4.1218E+02,5.5292E+00,
     &2.5225E+03,1.8919E+03,1.2613E+03,6.3102E+02,8.9199E+00,
     &3.6054E+03,2.7042E+03,1.8028E+03,9.0141E+02,1.3342E+01,
     &4.8703E+03,3.6527E+03,2.4352E+03,1.2176E+03,1.8766E+01,
     &6.2970E+03,4.7228E+03,3.1485E+03,1.5742E+03,2.5231E+01/
      DATA ((KB(JS,JT,54,15),JS=1,5),JT=1,5) /
     &1.4905E+03,1.1179E+03,7.4526E+02,3.7343E+02,4.6241E+00,
     &2.3494E+03,1.7621E+03,1.1747E+03,5.8778E+02,7.6666E+00,
     &3.4317E+03,2.5738E+03,1.7159E+03,8.5793E+02,1.1744E+01,
     &4.7173E+03,3.5380E+03,2.3587E+03,1.1793E+03,1.6836E+01,
     &6.1810E+03,4.6357E+03,3.0905E+03,1.5452E+03,2.2955E+01/
      DATA ((KB(JS,JT,55,15),JS=1,5),JT=1,5) /
     &1.3503E+03,1.0127E+03,6.7517E+02,3.3837E+02,3.8496E+00,
     &2.1922E+03,1.6441E+03,1.0961E+03,5.4853E+02,6.5708E+00,
     &3.2739E+03,2.4554E+03,1.6370E+03,8.1853E+02,1.0320E+01,
     &4.5818E+03,3.4364E+03,2.2910E+03,1.1455E+03,1.5094E+01,
     &6.0888E+03,4.5666E+03,3.0444E+03,1.5222E+03,2.0876E+01/
      DATA ((KB(JS,JT,56,15),JS=1,5),JT=1,5) /
     &1.2164E+03,9.1227E+02,6.0818E+02,3.0487E+02,3.1724E+00,
     &2.0376E+03,1.5282E+03,1.0188E+03,5.0989E+02,5.5890E+00,
     &3.1175E+03,2.3381E+03,1.5588E+03,7.7947E+02,9.0060E+00,
     &4.4491E+03,3.3368E+03,2.2246E+03,1.1123E+03,1.3463E+01,
     &6.0027E+03,4.5020E+03,3.0014E+03,1.5007E+03,1.8912E+01/
      DATA ((KB(JS,JT,57,15),JS=1,5),JT=1,5) /
     &1.0889E+03,8.1664E+02,5.4443E+02,2.7298E+02,2.5821E+00,
     &1.8871E+03,1.4154E+03,9.4357E+02,4.7231E+02,4.7102E+00,
     &2.9648E+03,2.2236E+03,1.4824E+03,7.4131E+02,7.7911E+00,
     &4.3194E+03,3.2395E+03,2.1597E+03,1.0798E+03,1.1924E+01,
     &5.9252E+03,4.4439E+03,2.9626E+03,1.4813E+03,1.7058E+01/
      DATA ((KB(JS,JT,58,15),JS=1,5),JT=1,5) /
     &4.7296E+02,4.0724E+02,3.1867E+02,1.9341E+02,2.1052E+00,
     &8.4958E+02,7.3152E+02,5.7242E+02,3.4682E+02,3.9643E+00,
     &1.3719E+03,1.1812E+03,9.2434E+02,5.5948E+02,6.7352E+00,
     &2.0410E+03,1.7574E+03,1.3752E+03,8.3221E+02,1.0550E+01,
     &2.8472E+03,2.4515E+03,1.9184E+03,1.1609E+03,1.5395E+01/
      DATA ((KB(JS,JT,59,15),JS=1,5),JT=1,5) /
     &4.5680E+02,3.9477E+02,3.1046E+02,1.8976E+02,1.9256E+00,
     &8.3327E+02,7.2012E+02,5.6632E+02,3.4555E+02,3.6779E+00,
     &1.3611E+03,1.1763E+03,9.2510E+02,5.6393E+02,6.3201E+00,
     &2.0429E+03,1.7655E+03,1.3884E+03,8.4623E+02,9.9804E+00,
     &2.8700E+03,2.4803E+03,1.9506E+03,1.1889E+03,1.4739E+01/
      DATA ((KB(JS,JT,13,16),JS=1,5),JT=1,5) /
     &4.8122E+02,3.6087E+02,2.4060E+02,1.2030E+02,7.3993E+00,
     &6.9206E+02,5.1907E+02,3.4603E+02,1.7302E+02,1.5501E+01,
     &9.4738E+02,7.1056E+02,4.7372E+02,2.3683E+02,2.1040E+01,
     &1.2406E+03,9.3042E+02,6.2029E+02,3.1014E+02,2.9139E+01,
     &1.5703E+03,1.1778E+03,7.8522E+02,3.9259E+02,3.9308E+01/
      DATA ((KB(JS,JT,14,16),JS=1,5),JT=1,5) /
     &5.7576E+02,4.3182E+02,2.8788E+02,1.4394E+02,1.4009E+01,
     &8.3244E+02,6.2431E+02,4.1619E+02,2.0809E+02,1.9135E+01,
     &1.1392E+03,8.5436E+02,5.6956E+02,2.8480E+02,2.5798E+01,
     &1.4970E+03,1.1226E+03,7.4844E+02,3.7423E+02,3.5612E+01,
     &1.8999E+03,1.4249E+03,9.4985E+02,4.7498E+02,4.7897E+01/
      DATA ((KB(JS,JT,15,16),JS=1,5),JT=1,5) /
     &6.7686E+02,5.0758E+02,3.3845E+02,1.6922E+02,1.7232E+01,
     &9.7585E+02,7.3193E+02,4.8790E+02,2.4395E+02,2.3521E+01,
     &1.3377E+03,1.0032E+03,6.6881E+02,3.3441E+02,3.1740E+01,
     &1.7575E+03,1.3181E+03,8.7876E+02,4.3935E+02,4.3321E+01,
     &2.2308E+03,1.6730E+03,1.1154E+03,5.5774E+02,5.7999E+01/
      DATA ((KB(JS,JT,16,16),JS=1,5),JT=1,5) /
     &7.8637E+02,5.8983E+02,3.9321E+02,1.9661E+02,2.1088E+01,
     &1.1333E+03,8.4995E+02,5.6666E+02,2.8332E+02,2.8690E+01,
     &1.5497E+03,1.1623E+03,7.7493E+02,3.8745E+02,3.8949E+01,
     &2.0330E+03,1.5247E+03,1.0164E+03,5.0821E+02,5.2500E+01,
     &2.5789E+03,1.9342E+03,1.2895E+03,6.4478E+02,6.9505E+01/
      DATA ((KB(JS,JT,17,16),JS=1,5),JT=1,5) /
     &9.1371E+02,6.8529E+02,4.5686E+02,2.2843E+02,2.5518E+01,
     &1.3116E+03,9.8366E+02,6.5574E+02,3.2788E+02,3.4904E+01,
     &1.7880E+03,1.3410E+03,8.9396E+02,4.4698E+02,4.7412E+01,
     &2.3411E+03,1.7558E+03,1.1705E+03,5.8526E+02,6.3218E+01,
     &2.9603E+03,2.2204E+03,1.4801E+03,7.4006E+02,8.2344E+01/
      DATA ((KB(JS,JT,18,16),JS=1,5),JT=1,5) /
     &1.0453E+03,7.8401E+02,5.2267E+02,2.6132E+02,3.0565E+01,
     &1.4935E+03,1.1202E+03,7.4674E+02,3.7341E+02,4.2204E+01,
     &2.0309E+03,1.5232E+03,1.0154E+03,5.0502E+02,5.7127E+01,
     &2.6479E+03,1.9862E+03,1.3241E+03,6.6202E+02,7.5429E+01,
     &3.3399E+03,2.5049E+03,1.6700E+03,8.3500E+02,9.7021E+01/
      DATA ((KB(JS,JT,19,16),JS=1,5),JT=1,5) /
     &1.2157E+03,9.1179E+02,6.0790E+02,3.0394E+02,3.6497E+01,
     &1.7308E+03,1.2981E+03,8.6539E+02,4.3270E+02,5.0186E+01,
     &2.3421E+03,1.7565E+03,1.1710E+03,5.8556E+02,6.7960E+01,
     &3.0436E+03,2.2829E+03,1.5219E+03,7.6093E+02,8.8940E+01,
     &3.8257E+03,2.8691E+03,1.9129E+03,9.5637E+02,1.1320E+02/
      DATA ((KB(JS,JT,20,16),JS=1,5),JT=1,5) /
     &1.4499E+03,1.0875E+03,7.2502E+02,3.6250E+02,4.3451E+01,
     &2.0494E+03,1.5371E+03,1.0247E+03,5.1236E+02,5.9923E+01,
     &2.7595E+03,2.0695E+03,1.3797E+03,6.8984E+02,8.0107E+01,
     &3.5702E+03,2.6775E+03,1.7850E+03,8.9253E+02,1.0388E+02,
     &4.4675E+03,3.3505E+03,2.2337E+03,1.1168E+03,1.3102E+02/
      DATA ((KB(JS,JT,21,16),JS=1,5),JT=1,5) /
     &1.7354E+03,1.3015E+03,8.6762E+02,4.3383E+02,5.1121E+01,
     &2.4333E+03,1.8248E+03,1.2166E+03,6.0831E+02,7.0122E+01,
     &3.2566E+03,2.4426E+03,1.6283E+03,8.1420E+02,9.3037E+01,
     &4.1875E+03,3.1404E+03,2.0937E+03,1.0468E+03,1.1968E+02,
     &5.2269E+03,3.9201E+03,2.6133E+03,1.3066E+03,1.4963E+02/
      DATA ((KB(JS,JT,22,16),JS=1,5),JT=1,5) /
     &2.1136E+03,1.5853E+03,1.0569E+03,5.2844E+02,6.0581E+01,
     &2.9316E+03,2.1987E+03,1.4659E+03,7.3292E+02,8.2385E+01,
     &3.8802E+03,2.9101E+03,1.9401E+03,9.7007E+02,1.0823E+02,
     &4.9544E+03,3.7156E+03,2.4770E+03,1.2386E+03,1.3781E+02,
     &6.1512E+03,4.6135E+03,3.0579E+03,1.5378E+03,1.7127E+02/
      DATA ((KB(JS,JT,23,16),JS=1,5),JT=1,5) /
     &2.5612E+03,1.9208E+03,1.2805E+03,6.4031E+02,7.0795E+01,
     &3.5078E+03,2.6308E+03,1.7538E+03,8.7684E+02,9.5347E+01,
     &4.5972E+03,3.4475E+03,2.2984E+03,1.1493E+03,1.2411E+02,
     &5.8246E+03,4.3680E+03,2.9119E+03,1.4559E+03,1.5734E+02,
     &7.1749E+03,5.3812E+03,3.5874E+03,1.7937E+03,1.9485E+02/
      DATA ((KB(JS,JT,24,16),JS=1,5),JT=1,5) /
     &3.1040E+03,2.3279E+03,1.5520E+03,7.7603E+02,8.1731E+01,
     &4.2015E+03,3.1511E+03,2.1007E+03,1.0503E+03,1.0915E+02,
     &5.4526E+03,4.0896E+03,2.7263E+03,1.3632E+03,1.4142E+02,
     &6.8486E+03,5.1365E+03,3.4243E+03,1.7120E+03,1.7856E+02,
     &8.3592E+03,6.2694E+03,4.1793E+03,2.0896E+03,2.2042E+02/
      DATA ((KB(JS,JT,25,16),JS=1,5),JT=1,5) /
     &3.7353E+03,2.8011E+03,1.8675E+03,9.3379E+02,9.3752E+01,
     &4.9915E+03,3.7438E+03,2.4959E+03,1.2479E+03,1.2447E+02,
     &6.4159E+03,4.8120E+03,3.2081E+03,1.6040E+03,1.6041E+02,
     &7.9803E+03,5.9849E+03,3.9899E+03,1.9951E+03,2.0157E+02,
     &9.6532E+03,7.2408E+03,4.8272E+03,2.4135E+03,2.4756E+02/
      DATA ((KB(JS,JT,26,16),JS=1,5),JT=1,5) /
     &4.4736E+03,3.3551E+03,2.2367E+03,1.1183E+03,1.0731E+02,
     &5.9023E+03,4.4264E+03,2.9511E+03,1.4756E+03,1.4156E+02,
     &7.5046E+03,5.6279E+03,3.7521E+03,1.8761E+03,1.8123E+02,
     &9.2412E+03,6.9304E+03,4.6207E+03,2.3102E+03,2.2639E+02,
     &1.1070E+04,8.3029E+03,5.5351E+03,2.7676E+03,2.7645E+02/
      DATA ((KB(JS,JT,27,16),JS=1,5),JT=1,5) /
     &5.2658E+03,3.9745E+03,2.6497E+03,1.3248E+03,1.2199E+02,
     &6.9046E+03,5.1781E+03,3.4305E+03,1.7261E+03,1.5967E+02,
     &8.6809E+03,6.5105E+03,4.3403E+03,2.1700E+03,2.0317E+02,
     &1.0514E+04,7.9337E+03,5.2893E+03,2.6448E+03,2.5202E+02,
     &1.2548E+04,9.4115E+03,6.2746E+03,3.1373E+03,3.0568E+02/
      DATA ((KB(JS,JT,28,16),JS=1,5),JT=1,5) /
     &6.2040E+03,4.6529E+03,3.1020E+03,1.5511E+03,1.3749E+02,
     &7.9799E+03,5.9854E+03,3.9901E+03,1.9952E+03,1.7869E+02,
     &9.9157E+03,7.4385E+03,4.9578E+03,2.4793E+03,2.2573E+02,
     &1.1961E+04,8.9706E+03,5.9799E+03,2.9900E+03,2.7806E+02,
     &1.4060E+04,1.0545E+04,7.0300E+03,3.5151E+03,3.3499E+02/
      DATA ((KB(JS,JT,29,16),JS=1,5),JT=1,5) /
     &7.1341E+03,5.3506E+03,3.5671E+03,1.7835E+03,1.5398E+02,
     &9.0577E+03,6.7935E+03,4.5290E+03,2.2643E+03,1.9863E+02,
     &1.1122E+04,8.3426E+03,5.5615E+03,2.7806E+03,2.4903E+02,
     &1.3280E+04,9.9609E+03,6.6400E+03,3.3199E+03,3.0450E+02,
     &1.5478E+04,1.1609E+04,7.7394E+03,3.8697E+03,3.6431E+02/
      DATA ((KB(JS,JT,30,16),JS=1,5),JT=1,5) /
     &8.0566E+03,6.0423E+03,4.0284E+03,2.0142E+03,1.7115E+02,
     &1.0101E+04,7.5759E+03,5.0505E+03,2.5252E+03,2.1901E+02,
     &1.2267E+04,9.1995E+03,6.1334E+03,3.0668E+03,2.7243E+02,
     &1.4511E+04,1.0883E+04,7.2556E+03,3.6279E+03,3.3082E+02,
     &1.6772E+04,1.2579E+04,8.3858E+03,4.1931E+03,3.9317E+02/
      DATA ((KB(JS,JT,31,16),JS=1,5),JT=1,5) /
     &8.8982E+03,6.6739E+03,4.4493E+03,2.2245E+03,1.8901E+02,
     &1.1025E+04,8.2681E+03,5.5122E+03,2.7560E+03,2.3984E+02,
     &1.3250E+04,9.9387E+03,6.6258E+03,3.3127E+03,2.9609E+02,
     &1.5535E+04,1.1652E+04,7.7678E+03,3.8841E+03,3.5699E+02,
     &1.7813E+04,1.3361E+04,8.9075E+03,4.4535E+03,4.2172E+02/
      DATA ((KB(JS,JT,32,16),JS=1,5),JT=1,5) /
     &9.7468E+03,7.3100E+03,4.8729E+03,2.4366E+03,2.0736E+02,
     &1.1942E+04,8.9562E+03,5.9708E+03,2.9855E+03,2.6092E+02,
     &1.4217E+04,1.0663E+04,7.1086E+03,3.5542E+03,3.1978E+02,
     &1.6526E+04,1.2394E+04,8.2625E+03,4.1313E+03,3.8300E+02,
     &1.8815E+04,1.4111E+04,9.4077E+03,4.7034E+03,4.4968E+02/
      DATA ((KB(JS,JT,33,16),JS=1,5),JT=1,5) /
     &1.0585E+04,7.8868E+03,5.2924E+03,2.6461E+03,2.2603E+02,
     &1.2835E+04,9.6280E+03,6.4182E+03,3.2091E+03,2.8215E+02,
     &1.5147E+04,1.1359E+04,7.5723E+03,3.7863E+03,3.3983E+02,
     &1.7461E+04,1.3096E+04,8.7313E+03,4.3654E+03,4.0847E+02,
     &1.9631E+04,1.4815E+04,9.8770E+03,4.9389E+03,4.7201E+02/
      DATA ((KB(JS,JT,34,16),JS=1,5),JT=1,5) /
     &1.1432E+04,8.5737E+03,5.7158E+03,2.8579E+03,2.4293E+02,
     &1.3656E+04,1.0308E+04,6.8715E+03,3.4360E+03,3.0114E+02,
     &1.6096E+04,1.2073E+04,8.0473E+03,4.0240E+03,3.6423E+02,
     &1.8435E+04,1.3744E+04,9.2181E+03,4.6088E+03,4.3111E+02,
     &2.0743E+04,1.5458E+04,1.0371E+04,5.1857E+03,5.0086E+02/
      DATA ((KB(JS,JT,35,16),JS=1,5),JT=1,5) /
     &1.2052E+04,9.0391E+03,6.0261E+03,3.0130E+03,2.5425E+02,
     &1.4410E+04,1.0808E+04,7.2046E+03,3.6026E+03,3.1392E+02,
     &1.6796E+04,1.2598E+04,8.3987E+03,4.1994E+03,3.7832E+02,
     &1.9160E+04,1.4370E+04,9.5799E+03,4.7904E+03,4.4634E+02,
     &2.1483E+04,1.6114E+04,1.0742E+04,5.3711E+03,5.1708E+02/
      DATA ((KB(JS,JT,36,16),JS=1,5),JT=1,5) /
     &1.2411E+04,9.3078E+03,6.2050E+03,3.1026E+03,2.5887E+02,
     &1.4808E+04,1.1106E+04,7.4043E+03,3.7021E+03,3.1927E+02,
     &1.7228E+04,1.2921E+04,8.6130E+03,4.3067E+03,3.8442E+02,
     &1.9618E+04,1.4714E+04,9.8092E+03,4.9047E+03,4.5297E+02,
     &2.1965E+04,1.6474E+04,1.0982E+04,5.4915E+03,5.1909E+02/
      DATA ((KB(JS,JT,37,16),JS=1,5),JT=1,5) /
     &1.2464E+04,9.3487E+03,6.2318E+03,3.1159E+03,2.5416E+02,
     &1.4910E+04,1.1181E+04,7.4551E+03,3.7272E+03,3.1436E+02,
     &1.7377E+04,1.3033E+04,8.6893E+03,4.3442E+03,3.7942E+02,
     &1.9817E+04,1.4862E+04,9.9088E+03,4.9531E+03,4.4815E+02,
     &2.2212E+04,1.6660E+04,1.1107E+04,5.5531E+03,5.1970E+02/
      DATA ((KB(JS,JT,38,16),JS=1,5),JT=1,5) /
     &1.2455E+04,9.3421E+03,6.2277E+03,3.1139E+03,2.4843E+02,
     &1.4944E+04,1.1208E+04,7.4715E+03,3.7356E+03,3.0837E+02,
     &1.7458E+04,1.3093E+04,8.7289E+03,4.3646E+03,3.7326E+02,
     &1.9945E+04,1.4959E+04,9.9720E+03,4.9866E+03,4.4198E+02,
     &2.2391E+04,1.6792E+04,1.1195E+04,5.5974E+03,5.1349E+02/
      DATA ((KB(JS,JT,39,16),JS=1,5),JT=1,5) /
     &1.2406E+04,9.3076E+03,6.2035E+03,3.1024E+03,2.4239E+02,
     &1.4934E+04,1.1200E+04,7.4672E+03,3.7337E+03,3.0193E+02,
     &1.7492E+04,1.3118E+04,8.7456E+03,4.3725E+03,3.6650E+02,
     &2.0028E+04,1.5022E+04,1.0013E+04,5.0072E+03,4.3512E+02,
     &2.2512E+04,1.6885E+04,1.1257E+04,5.6280E+03,5.0671E+02/
      DATA ((KB(JS,JT,40,16),JS=1,5),JT=1,5) /
     &1.2191E+04,9.1428E+03,6.0955E+03,3.0476E+03,2.3031E+02,
     &1.4768E+04,1.1076E+04,7.3840E+03,3.6920E+03,2.8879E+02,
     &1.7391E+04,1.3044E+04,8.6959E+03,4.3483E+03,3.5253E+02,
     &2.0001E+04,1.5001E+04,1.0001E+04,5.0007E+03,4.2055E+02,
     &2.2559E+04,1.6919E+04,1.1281E+04,5.6404E+03,4.9160E+02/
      DATA ((KB(JS,JT,41,16),JS=1,5),JT=1,5) /
     &1.1918E+04,8.9381E+03,5.9590E+03,2.9794E+03,2.1766E+02,
     &1.4546E+04,1.0910E+04,7.2239E+03,3.6364E+03,2.7473E+02,
     &1.7237E+04,1.2927E+04,8.6187E+03,4.3092E+03,3.3421E+02,
     &1.9925E+04,1.4942E+04,9.9613E+03,4.9808E+03,4.0468E+02,
     &2.2566E+04,1.6925E+04,1.1282E+04,5.6408E+03,4.7546E+02/
      DATA ((KB(JS,JT,42,16),JS=1,5),JT=1,5) /
     &1.1611E+04,8.7088E+03,5.8053E+03,2.9027E+03,2.0505E+02,
     &1.4284E+04,1.0639E+04,7.1417E+03,3.5709E+03,2.6066E+02,
     &1.7038E+04,1.2778E+04,8.5196E+03,4.2591E+03,3.2228E+02,
     &1.9799E+04,1.4850E+04,9.8997E+03,4.9502E+03,3.8865E+02,
     &2.2525E+04,1.6894E+04,1.1262E+04,5.6311E+03,4.5874E+02/
      DATA ((KB(JS,JT,43,16),JS=1,5),JT=1,5) /
     &1.1239E+04,8.4296E+03,5.6199E+03,2.8098E+03,1.8981E+02,
     &1.3966E+04,1.0473E+04,6.9839E+03,3.4914E+03,2.4348E+02,
     &1.6803E+04,1.2602E+04,8.4011E+03,4.2005E+03,3.0350E+02,
     &1.9668E+04,1.4751E+04,9.8339E+03,4.9166E+03,3.6865E+02,
     &2.2506E+04,1.6879E+04,1.1254E+04,5.6261E+03,4.3789E+02/
      DATA ((KB(JS,JT,44,16),JS=1,5),JT=1,5) /
     &1.0825E+04,8.1186E+03,5.4125E+03,2.7064E+03,1.7391E+02,
     &1.3603E+04,1.0202E+04,6.8014E+03,3.4006E+03,2.2526E+02,
     &1.6530E+04,1.2398E+04,8.2649E+03,4.1327E+03,2.8337E+02,
     &1.9511E+04,1.4634E+04,9.7557E+03,4.8778E+03,3.4703E+02,
     &2.2482E+04,1.6861E+04,1.1241E+04,5.6203E+03,4.1512E+02/
      DATA ((KB(JS,JT,45,16),JS=1,5),JT=1,5) /
     &1.0398E+04,7.7989E+03,5.1994E+03,2.5997E+03,1.5876E+02,
     &1.3207E+04,9.9052E+03,6.6032E+03,3.3018E+03,2.0761E+02,
     &1.6220E+04,1.2165E+04,8.1095E+03,4.0543E+03,2.6368E+02,
     &1.9318E+04,1.4390E+04,9.6588E+03,4.8297E+03,3.2574E+02,
     &2.2424E+04,1.6818E+04,1.1212E+04,5.6061E+03,3.9259E+02/
      DATA ((KB(JS,JT,46,16),JS=1,5),JT=1,5) /
     &9.9189E+03,7.4400E+03,4.9600E+03,2.4797E+03,1.4342E+02,
     &1.2731E+04,9.5482E+03,6.3653E+03,3.1826E+03,1.8954E+02,
     &1.5820E+04,1.1865E+04,7.9099E+03,3.9548E+03,2.4324E+02,
     &1.9036E+04,1.4277E+04,9.5173E+03,4.7590E+03,3.0340E+02,
     &2.2283E+04,1.6712E+04,1.1068E+04,5.5708E+03,3.6873E+02/
      DATA ((KB(JS,JT,47,16),JS=1,5),JT=1,5) /
     &9.3465E+03,7.0098E+03,4.6733E+03,2.3366E+03,1.2741E+02,
     &1.2131E+04,9.0979E+03,6.0653E+03,3.0325E+03,1.7033E+02,
     &1.5279E+04,1.1459E+04,7.6395E+03,3.8199E+03,2.2121E+02,
     &1.8609E+04,1.3956E+04,9.3042E+03,4.6522E+03,2.7888E+02,
     &2.2011E+04,1.6508E+04,1.1006E+04,5.5025E+03,3.4244E+02/
      DATA ((KB(JS,JT,48,16),JS=1,5),JT=1,5) /
     &8.7925E+03,6.5945E+03,4.3966E+03,2.1981E+03,1.1262E+02,
     &1.1529E+04,8.6468E+03,5.7644E+03,2.8824E+03,1.5232E+02,
     &1.4702E+04,1.1027E+04,7.3513E+03,3.6755E+03,2.0009E+02,
     &1.8139E+04,1.3604E+04,9.0700E+03,4.5350E+03,2.5528E+02,
     &2.1696E+04,1.6272E+04,1.0846E+04,5.4236E+03,3.1666E+02/
      DATA ((KB(JS,JT,49,16),JS=1,5),JT=1,5) /
     &8.2532E+03,6.1899E+03,4.1262E+03,2.0633E+03,9.9158E+01,
     &1.0925E+04,8.1939E+03,5.4625E+03,2.7312E+03,1.3556E+02,
     &1.4098E+04,1.0574E+04,7.0499E+03,3.5250E+03,1.8015E+02,
     &1.7628E+04,1.3221E+04,8.8139E+03,4.4071E+03,2.3258E+02,
     &2.1334E+04,1.6000E+04,1.0668E+04,5.3338E+03,2.8877E+02/
      DATA ((KB(JS,JT,50,16),JS=1,5),JT=1,5) /
     &7.7886E+03,5.8414E+03,3.8943E+03,1.9471E+03,8.7562E+01,
     &1.0399E+04,7.7996E+03,5.1995E+03,2.6000E+03,1.2099E+02,
     &1.3554E+04,1.0165E+04,6.7769E+03,3.3882E+03,1.6257E+02,
     &1.7158E+04,1.2869E+04,8.5791E+03,4.2889E+03,2.1215E+02,
     &2.1011E+04,1.5758E+04,1.0505E+04,5.2531E+03,2.6885E+02/
      DATA ((KB(JS,JT,51,16),JS=1,5),JT=1,5) /
     &7.3653E+03,5.5240E+03,3.6827E+03,1.8412E+03,7.7231E+01,
     &9.9189E+03,7.4392E+03,4.9594E+03,2.4660E+03,1.0798E+02,
     &1.3047E+04,9.7852E+03,6.5235E+03,3.2615E+03,1.4656E+02,
     &1.6702E+04,1.2527E+04,8.3510E+03,4.1752E+03,1.9328E+02,
     &2.0693E+04,1.5520E+04,1.0347E+04,5.1734E+03,2.4760E+02/
      DATA ((KB(JS,JT,52,16),JS=1,5),JT=1,5) /
     &6.9562E+03,5.2172E+03,3.4778E+03,1.7389E+03,6.7762E+01,
     &9.4563E+03,7.0922E+03,4.7284E+03,2.3642E+03,9.6034E+01,
     &1.2544E+04,9.4081E+03,6.2721E+03,3.1358E+03,1.3163E+02,
     &1.6228E+04,1.2171E+04,8.1139E+03,4.0563E+03,1.7544E+02,
     &2.0214E+04,1.5266E+04,1.0177E+04,5.0897E+03,2.2714E+02/
      DATA ((KB(JS,JT,53,16),JS=1,5),JT=1,5) /
     &6.5707E+03,4.8896E+03,3.2854E+03,1.6428E+03,5.9086E+01,
     &9.0178E+03,6.7633E+03,4.5088E+03,2.2544E+03,8.4973E+01,
     &1.2063E+04,9.0476E+03,6.0317E+03,3.0159E+03,1.1770E+02,
     &1.5755E+04,1.1816E+04,7.8772E+03,3.9386E+03,1.5858E+02,
     &1.9999E+04,1.4999E+04,9.9995E+03,5.0000E+03,2.0751E+02/
      DATA ((KB(JS,JT,54,16),JS=1,5),JT=1,5) /
     &6.2721E+03,4.7041E+03,3.1362E+03,1.5681E+03,5.1875E+01,
     &8.6741E+03,6.5056E+03,4.3370E+03,2.1682E+03,7.5628E+01,
     &1.1700E+04,8.7748E+03,5.8499E+03,2.9249E+03,1.0596E+02,
     &1.5404E+04,1.1553E+04,7.7020E+03,3.8510E+03,1.4404E+02,
     &1.9752E+04,1.4814E+04,9.8758E+03,4.9379E+03,1.9030E+02/
      DATA ((KB(JS,JT,55,16),JS=1,5),JT=1,5) /
     &6.0231E+03,4.5173E+03,3.0116E+03,1.5058E+03,4.5583E+01,
     &8.3823E+03,6.2868E+03,4.1912E+03,2.0956E+03,6.7362E+01,
     &1.1398E+04,8.5488E+03,5.6992E+03,2.8496E+03,9.5542E+01,
     &1.5124E+04,1.1343E+04,7.5617E+03,3.7808E+03,1.3099E+02,
     &1.9568E+04,1.4676E+04,9.7841E+03,4.8920E+03,1.7464E+02/
      DATA ((KB(JS,JT,56,16),JS=1,5),JT=1,5) /
     &5.7989E+03,4.3492E+03,2.8995E+03,1.4497E+03,3.9828E+01,
     &8.1232E+03,6.0924E+03,4.0616E+03,2.0308E+03,5.9729E+01,
     &1.1139E+04,8.3546E+03,5.5697E+03,2.7849E+03,8.5801E+01,
     &1.4890E+04,1.1167E+04,7.4448E+03,3.7224E+03,1.1874E+02,
     &1.9429E+04,1.4572E+04,9.7148E+03,4.8574E+03,1.5988E+02/
      DATA ((KB(JS,JT,57,16),JS=1,5),JT=1,5) /
     &5.6021E+03,4.2016E+03,2.8010E+03,1.4005E+03,3.4593E+01,
     &7.9032E+03,5.9274E+03,3.9516E+03,1.9758E+03,5.2766E+01,
     &1.0919E+04,8.1889E+03,5.4593E+03,2.7295E+03,7.6784E+01,
     &1.4709E+04,1.1031E+04,7.3542E+03,3.6771E+03,1.0741E+02,
     &1.9344E+04,1.4508E+04,9.6719E+03,4.8359E+03,1.4582E+02/
      DATA ((KB(JS,JT,58,16),JS=1,5),JT=1,5) /
     &2.6461E+03,2.2784E+03,1.7829E+03,1.0638E+03,3.0084E+01,
     &3.7547E+03,3.2329E+03,2.5298E+03,1.5309E+03,4.6706E+01,
     &5.2182E+03,4.4930E+03,3.5159E+03,2.1276E+03,6.8855E+01,
     &7.0852E+03,6.1006E+03,4.7738E+03,2.8889E+03,9.7411E+01,
     &9.3867E+03,8.0822E+03,6.3244E+03,3.8273E+03,1.3335E+02/
      DATA ((KB(JS,JT,59,16),JS=1,5),JT=1,5) /
     &2.6519E+03,2.2918E+03,1.8023E+03,1.0985E+03,2.8399E+01,
     &3.7709E+03,3.2589E+03,2.5629E+03,1.5620E+03,4.4429E+01,
     &5.2534E+03,4.5401E+03,3.5704E+03,2.1761E+03,6.5844E+01,
     &7.1555E+03,6.1839E+03,4.8632E+03,2.9640E+03,9.3608E+01,
     &9.5069E+03,8.2160E+03,6.4613E+03,3.9381E+03,1.2854E+02/

C     The array KA_Mxx contains the absorption coefficient for 
C     a minor species at the 16 chosen g-values for a reference pressure
C     level below 100~ mb.   The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.  The second index refers to temperature 
C     in 7.2 degree increments.  For instance, JT = 1 refers to a 
C     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
C     runs over the g-channel (1 to 16).

      DATA (KA_MN2O( 1,JT, 1),JT=1,19)  /
     & 1.28178e-05, 1.55472e-05, 1.88578e-05, 2.28735e-05, 2.77442e-05,
     & 3.36520e-05, 4.08179e-05, 4.95098e-05, 6.00525e-05, 7.28401e-05,
     & 8.83508e-05, 1.07164e-04, 1.29984e-04, 1.57663e-04, 1.91236e-04,
     & 2.31958e-04, 2.81352e-04, 3.41263e-04, 4.13932e-04/
      DATA (KA_MN2O( 2,JT, 1),JT=1,19)  /
     & 1.00725e-01, 1.04470e-01, 1.08355e-01, 1.12384e-01, 1.16563e-01,
     & 1.20898e-01, 1.25394e-01, 1.30057e-01, 1.34893e-01, 1.39909e-01,
     & 1.45112e-01, 1.50508e-01, 1.56104e-01, 1.61909e-01, 1.67930e-01,
     & 1.74175e-01, 1.80652e-01, 1.87369e-01, 1.94337e-01/
      DATA (KA_MN2O( 3,JT, 1),JT=1,19)  /
     & 1.94143e-01, 1.97380e-01, 2.00670e-01, 2.04016e-01, 2.07417e-01,
     & 2.10875e-01, 2.14390e-01, 2.17964e-01, 2.21598e-01, 2.25292e-01,
     & 2.29048e-01, 2.32867e-01, 2.36749e-01, 2.40696e-01, 2.44708e-01,
     & 2.48788e-01, 2.52936e-01, 2.57152e-01, 2.61439e-01/
      DATA (KA_MN2O( 4,JT, 1),JT=1,19)  /
     & 2.98127e-01, 3.00016e-01, 3.01916e-01, 3.03829e-01, 3.05754e-01,
     & 3.07691e-01, 3.09640e-01, 3.11601e-01, 3.13575e-01, 3.15562e-01,
     & 3.17561e-01, 3.19572e-01, 3.21597e-01, 3.23634e-01, 3.25684e-01,
     & 3.27748e-01, 3.29824e-01, 3.31913e-01, 3.34016e-01/
      DATA (KA_MN2O( 5,JT, 1),JT=1,19)  /
     & 4.45029e-01, 4.45243e-01, 4.45458e-01, 4.45673e-01, 4.45889e-01,
     & 4.46104e-01, 4.46319e-01, 4.46535e-01, 4.46750e-01, 4.46966e-01,
     & 4.47182e-01, 4.47398e-01, 4.47614e-01, 4.47830e-01, 4.48046e-01,
     & 4.48262e-01, 4.48479e-01, 4.48695e-01, 4.48912e-01/
      DATA (KA_MN2O( 6,JT, 1),JT=1,19)  /
     & 7.15677e-01, 7.14564e-01, 7.13452e-01, 7.12342e-01, 7.11234e-01,
     & 7.10127e-01, 7.09022e-01, 7.07919e-01, 7.06818e-01, 7.05718e-01,
     & 7.04620e-01, 7.03524e-01, 7.02429e-01, 7.01336e-01, 7.00245e-01,
     & 6.99156e-01, 6.98068e-01, 6.96982e-01, 6.95898e-01/
      DATA (KA_MN2O( 7,JT, 1),JT=1,19)  /
     & 9.89605e-01, 9.85128e-01, 9.80671e-01, 9.76234e-01, 9.71817e-01,
     & 9.67421e-01, 9.63044e-01, 9.58687e-01, 9.54350e-01, 9.50032e-01,
     & 9.45734e-01, 9.41455e-01, 9.37196e-01, 9.32956e-01, 9.28735e-01,
     & 9.24533e-01, 9.20350e-01, 9.16187e-01, 9.12042e-01/
      DATA (KA_MN2O( 8,JT, 1),JT=1,19)  /
     & 1.12229e+00, 1.11502e+00, 1.10779e+00, 1.10061e+00, 1.09348e+00,
     & 1.08639e+00, 1.07935e+00, 1.07235e+00, 1.06540e+00, 1.05850e+00,
     & 1.05164e+00, 1.04482e+00, 1.03805e+00, 1.03132e+00, 1.02464e+00,
     & 1.01799e+00, 1.01140e+00, 1.00484e+00, 9.98328e-01/
      DATA (KA_MN2O( 9,JT, 1),JT=1,19)  /
     & 7.20959e-01, 7.22839e-01, 7.24723e-01, 7.26612e-01, 7.28506e-01,
     & 7.30405e-01, 7.32309e-01, 7.34218e-01, 7.36132e-01, 7.38051e-01,
     & 7.39975e-01, 7.41904e-01, 7.43838e-01, 7.45777e-01, 7.47721e-01,
     & 7.49670e-01, 7.51624e-01, 7.53584e-01, 7.55548e-01/
      DATA (KA_MN2O( 1,JT, 2),JT=1,19)  /
     & 1.62152e-03, 1.81627e-03, 2.03443e-03, 2.27878e-03, 2.55248e-03,
     & 2.85906e-03, 3.20245e-03, 3.58710e-03, 4.01794e-03, 4.50053e-03,
     & 5.04109e-03, 5.64657e-03, 6.32477e-03, 7.08444e-03, 7.93534e-03,
     & 8.88845e-03, 9.95603e-03, 1.11518e-02, 1.24913e-02/
      DATA (KA_MN2O( 2,JT, 2),JT=1,19)  /
     & 3.73716e-01, 3.72491e-01, 3.71271e-01, 3.70054e-01, 3.68841e-01,
     & 3.67633e-01, 3.66428e-01, 3.65227e-01, 3.64031e-01, 3.62838e-01,
     & 3.61649e-01, 3.60464e-01, 3.59283e-01, 3.58106e-01, 3.56932e-01,
     & 3.55763e-01, 3.54597e-01, 3.53435e-01, 3.52277e-01/
      DATA (KA_MN2O( 3,JT, 2),JT=1,19)  /
     & 5.46240e-01, 5.42972e-01, 5.39724e-01, 5.36495e-01, 5.33285e-01,
     & 5.30095e-01, 5.26923e-01, 5.23771e-01, 5.20637e-01, 5.17523e-01,
     & 5.14426e-01, 5.11349e-01, 5.08290e-01, 5.05249e-01, 5.02226e-01,
     & 4.99221e-01, 4.96235e-01, 4.93266e-01, 4.90315e-01/
      DATA (KA_MN2O( 4,JT, 2),JT=1,19)  /
     & 8.35399e-01, 8.36766e-01, 8.38135e-01, 8.39507e-01, 8.40880e-01,
     & 8.42256e-01, 8.43635e-01, 8.45015e-01, 8.46398e-01, 8.47783e-01,
     & 8.49170e-01, 8.50559e-01, 8.51951e-01, 8.53345e-01, 8.54742e-01,
     & 8.56140e-01, 8.57541e-01, 8.58944e-01, 8.60350e-01/
      DATA (KA_MN2O( 5,JT, 2),JT=1,19)  /
     & 1.04433e+00, 1.04864e+00, 1.05297e+00, 1.05731e+00, 1.06168e+00,
     & 1.06606e+00, 1.07046e+00, 1.07488e+00, 1.07932e+00, 1.08377e+00,
     & 1.08824e+00, 1.09274e+00, 1.09725e+00, 1.10178e+00, 1.10632e+00,
     & 1.11089e+00, 1.11547e+00, 1.12008e+00, 1.12470e+00/
      DATA (KA_MN2O( 6,JT, 2),JT=1,19)  /
     & 1.22341e+00, 1.22885e+00, 1.23431e+00, 1.23980e+00, 1.24531e+00,
     & 1.25084e+00, 1.25640e+00, 1.26199e+00, 1.26760e+00, 1.27323e+00,
     & 1.27889e+00, 1.28458e+00, 1.29029e+00, 1.29602e+00, 1.30178e+00,
     & 1.30757e+00, 1.31338e+00, 1.31922e+00, 1.32508e+00/
      DATA (KA_MN2O( 7,JT, 2),JT=1,19)  /
     & 1.67595e+00, 1.68296e+00, 1.69000e+00, 1.69707e+00, 1.70417e+00,
     & 1.71130e+00, 1.71846e+00, 1.72565e+00, 1.73287e+00, 1.74012e+00,
     & 1.74740e+00, 1.75471e+00, 1.76206e+00, 1.76943e+00, 1.77683e+00,
     & 1.78426e+00, 1.79173e+00, 1.79922e+00, 1.80675e+00/
      DATA (KA_MN2O( 8,JT, 2),JT=1,19)  /
     & 2.76890e+00, 2.76981e+00, 2.77072e+00, 2.77163e+00, 2.77254e+00,
     & 2.77345e+00, 2.77436e+00, 2.77527e+00, 2.77618e+00, 2.77709e+00,
     & 2.77800e+00, 2.77891e+00, 2.77982e+00, 2.78074e+00, 2.78165e+00,
     & 2.78256e+00, 2.78348e+00, 2.78439e+00, 2.78530e+00/
      DATA (KA_MN2O( 9,JT, 2),JT=1,19)  /
     & 8.00944e-01, 7.95531e-01, 7.90155e-01, 7.84815e-01, 7.79511e-01,
     & 7.74243e-01, 7.69011e-01, 7.63813e-01, 7.58652e-01, 7.53525e-01,
     & 7.48432e-01, 7.43374e-01, 7.38350e-01, 7.33360e-01, 7.28404e-01,
     & 7.23482e-01, 7.18592e-01, 7.13736e-01, 7.08912e-01/
      DATA (KA_MN2O( 1,JT, 3),JT=1,19)  /
     & 5.26578e-02, 5.59000e-02, 5.93419e-02, 6.29957e-02, 6.68744e-02,
     & 7.09920e-02, 7.53631e-02, 8.00034e-02, 8.49294e-02, 9.01586e-02,
     & 9.57099e-02, 1.01603e-01, 1.07859e-01, 1.14500e-01, 1.21550e-01,
     & 1.29034e-01, 1.36979e-01, 1.45413e-01, 1.54366e-01/
      DATA (KA_MN2O( 2,JT, 3),JT=1,19)  /
     & 8.18393e-01, 8.20623e-01, 8.22860e-01, 8.25103e-01, 8.27352e-01,
     & 8.29608e-01, 8.31869e-01, 8.34137e-01, 8.36410e-01, 8.38690e-01,
     & 8.40976e-01, 8.43269e-01, 8.45567e-01, 8.47872e-01, 8.50183e-01,
     & 8.52501e-01, 8.54825e-01, 8.57155e-01, 8.59491e-01/
      DATA (KA_MN2O( 3,JT, 3),JT=1,19)  /
     & 1.02454e+00, 1.03210e+00, 1.03972e+00, 1.04740e+00, 1.05514e+00,
     & 1.06293e+00, 1.07077e+00, 1.07868e+00, 1.08665e+00, 1.09467e+00,
     & 1.10275e+00, 1.11089e+00, 1.11910e+00, 1.12736e+00, 1.13568e+00,
     & 1.14407e+00, 1.15252e+00, 1.16103e+00, 1.16960e+00/
      DATA (KA_MN2O( 4,JT, 3),JT=1,19)  /
     & 1.11755e+00, 1.12348e+00, 1.12944e+00, 1.13543e+00, 1.14146e+00,
     & 1.14752e+00, 1.15360e+00, 1.15972e+00, 1.16588e+00, 1.17206e+00,
     & 1.17828e+00, 1.18453e+00, 1.19082e+00, 1.19714e+00, 1.20349e+00,
     & 1.20988e+00, 1.21630e+00, 1.22275e+00, 1.22924e+00/
      DATA (KA_MN2O( 5,JT, 3),JT=1,19)  /
     & 1.41993e+00, 1.42353e+00, 1.42713e+00, 1.43074e+00, 1.43436e+00,
     & 1.43799e+00, 1.44163e+00, 1.44528e+00, 1.44894e+00, 1.45261e+00,
     & 1.45628e+00, 1.45997e+00, 1.46367e+00, 1.46737e+00, 1.47108e+00,
     & 1.47481e+00, 1.47854e+00, 1.48228e+00, 1.48603e+00/
      DATA (KA_MN2O( 6,JT, 3),JT=1,19)  /
     & 1.37725e+00, 1.38029e+00, 1.38334e+00, 1.38640e+00, 1.38947e+00,
     & 1.39254e+00, 1.39562e+00, 1.39870e+00, 1.40179e+00, 1.40489e+00,
     & 1.40800e+00, 1.41111e+00, 1.41423e+00, 1.41736e+00, 1.42049e+00,
     & 1.42363e+00, 1.42678e+00, 1.42993e+00, 1.43309e+00/
      DATA (KA_MN2O( 7,JT, 3),JT=1,19)  /
     & 1.34579e+00, 1.34584e+00, 1.34589e+00, 1.34594e+00, 1.34599e+00,
     & 1.34603e+00, 1.34608e+00, 1.34613e+00, 1.34618e+00, 1.34623e+00,
     & 1.34627e+00, 1.34632e+00, 1.34637e+00, 1.34642e+00, 1.34647e+00,
     & 1.34651e+00, 1.34656e+00, 1.34661e+00, 1.34666e+00/
      DATA (KA_MN2O( 8,JT, 3),JT=1,19)  /
     & 9.15268e-01, 9.12779e-01, 9.10298e-01, 9.07823e-01, 9.05355e-01,
     & 9.02893e-01, 9.00438e-01, 8.97990e-01, 8.95549e-01, 8.93114e-01,
     & 8.90686e-01, 8.88264e-01, 8.85849e-01, 8.83441e-01, 8.81039e-01,
     & 8.78644e-01, 8.76255e-01, 8.73873e-01, 8.71497e-01/
      DATA (KA_MN2O( 9,JT, 3),JT=1,19)  /
     & 1.12514e+00, 1.13523e+00, 1.14541e+00, 1.15568e+00, 1.16604e+00,
     & 1.17649e+00, 1.18704e+00, 1.19768e+00, 1.20841e+00, 1.21925e+00,
     & 1.23018e+00, 1.24121e+00, 1.25233e+00, 1.26356e+00, 1.27489e+00,
     & 1.28632e+00, 1.29785e+00, 1.30948e+00, 1.32122e+00/
      DATA (KA_MN2O( 1,JT, 4),JT=1,19)  /
     & 4.65135e-01, 4.69677e-01, 4.74264e-01, 4.78895e-01, 4.83572e-01,
     & 4.88294e-01, 4.93063e-01, 4.97878e-01, 5.02740e-01, 5.07649e-01,
     & 5.12607e-01, 5.17613e-01, 5.22667e-01, 5.27771e-01, 5.32925e-01,
     & 5.38130e-01, 5.43385e-01, 5.48691e-01, 5.54049e-01/
      DATA (KA_MN2O( 2,JT, 4),JT=1,19)  /
     & 9.71592e-01, 9.74472e-01, 9.77360e-01, 9.80257e-01, 9.83163e-01,
     & 9.86077e-01, 9.89000e-01, 9.91931e-01, 9.94871e-01, 9.97820e-01,
     & 1.00078e+00, 1.00374e+00, 1.00672e+00, 1.00970e+00, 1.01270e+00,
     & 1.01570e+00, 1.01871e+00, 1.02173e+00, 1.02476e+00/
      DATA (KA_MN2O( 3,JT, 4),JT=1,19)  /
     & 1.48090e+00, 1.48238e+00, 1.48385e+00, 1.48532e+00, 1.48680e+00,
     & 1.48828e+00, 1.48976e+00, 1.49124e+00, 1.49272e+00, 1.49420e+00,
     & 1.49569e+00, 1.49717e+00, 1.49866e+00, 1.50015e+00, 1.50164e+00,
     & 1.50313e+00, 1.50463e+00, 1.50612e+00, 1.50762e+00/
      DATA (KA_MN2O( 4,JT, 4),JT=1,19)  /
     & 1.50599e+00, 1.50541e+00, 1.50483e+00, 1.50426e+00, 1.50368e+00,
     & 1.50310e+00, 1.50252e+00, 1.50195e+00, 1.50137e+00, 1.50079e+00,
     & 1.50022e+00, 1.49964e+00, 1.49906e+00, 1.49849e+00, 1.49791e+00,
     & 1.49734e+00, 1.49676e+00, 1.49619e+00, 1.49561e+00/
      DATA (KA_MN2O( 5,JT, 4),JT=1,19)  /
     & 1.25396e+00, 1.25230e+00, 1.25065e+00, 1.24900e+00, 1.24735e+00,
     & 1.24570e+00, 1.24405e+00, 1.24241e+00, 1.24077e+00, 1.23913e+00,
     & 1.23749e+00, 1.23586e+00, 1.23423e+00, 1.23260e+00, 1.23097e+00,
     & 1.22934e+00, 1.22772e+00, 1.22610e+00, 1.22448e+00/
      DATA (KA_MN2O( 6,JT, 4),JT=1,19)  /
     & 1.27104e+00, 1.26416e+00, 1.25731e+00, 1.25050e+00, 1.24373e+00,
     & 1.23700e+00, 1.23030e+00, 1.22364e+00, 1.21701e+00, 1.21043e+00,
     & 1.20387e+00, 1.19735e+00, 1.19087e+00, 1.18442e+00, 1.17801e+00,
     & 1.17163e+00, 1.16529e+00, 1.15898e+00, 1.15270e+00/
      DATA (KA_MN2O( 7,JT, 4),JT=1,19)  /
     & 9.57877e-01, 9.49712e-01, 9.41617e-01, 9.33591e-01, 9.25633e-01,
     & 9.17743e-01, 9.09920e-01, 9.02164e-01, 8.94473e-01, 8.86849e-01,
     & 8.79289e-01, 8.71794e-01, 8.64363e-01, 8.56995e-01, 8.49690e-01,
     & 8.42447e-01, 8.35266e-01, 8.28147e-01, 8.21087e-01/
      DATA (KA_MN2O( 8,JT, 4),JT=1,19)  /
     & 4.75787e-01, 4.77208e-01, 4.78633e-01, 4.80063e-01, 4.81496e-01,
     & 4.82934e-01, 4.84377e-01, 4.85823e-01, 4.87274e-01, 4.88730e-01,
     & 4.90189e-01, 4.91653e-01, 4.93122e-01, 4.94595e-01, 4.96072e-01,
     & 4.97553e-01, 4.99039e-01, 5.00530e-01, 5.02025e-01/
      DATA (KA_MN2O( 9,JT, 4),JT=1,19)  /
     & 2.42533e+00, 2.41357e+00, 2.40188e+00, 2.39024e+00, 2.37866e+00,
     & 2.36713e+00, 2.35566e+00, 2.34425e+00, 2.33289e+00, 2.32158e+00,
     & 2.31033e+00, 2.29914e+00, 2.28800e+00, 2.27691e+00, 2.26588e+00,
     & 2.25490e+00, 2.24397e+00, 2.23310e+00, 2.22228e+00/
      DATA (KA_MN2O( 1,JT, 5),JT=1,19)  /
     & 1.53885e+00, 1.53590e+00, 1.53297e+00, 1.53004e+00, 1.52711e+00,
     & 1.52419e+00, 1.52128e+00, 1.51837e+00, 1.51547e+00, 1.51257e+00,
     & 1.50968e+00, 1.50679e+00, 1.50391e+00, 1.50104e+00, 1.49817e+00,
     & 1.49530e+00, 1.49245e+00, 1.48959e+00, 1.48675e+00/
      DATA (KA_MN2O( 2,JT, 5),JT=1,19)  /
     & 1.83368e+00, 1.83530e+00, 1.83692e+00, 1.83854e+00, 1.84016e+00,
     & 1.84178e+00, 1.84340e+00, 1.84503e+00, 1.84665e+00, 1.84828e+00,
     & 1.84991e+00, 1.85154e+00, 1.85317e+00, 1.85480e+00, 1.85644e+00,
     & 1.85807e+00, 1.85971e+00, 1.86135e+00, 1.86299e+00/
      DATA (KA_MN2O( 3,JT, 5),JT=1,19)  /
     & 1.49593e+00, 1.49279e+00, 1.48965e+00, 1.48652e+00, 1.48340e+00,
     & 1.48028e+00, 1.47717e+00, 1.47406e+00, 1.47096e+00, 1.46787e+00,
     & 1.46479e+00, 1.46171e+00, 1.45863e+00, 1.45557e+00, 1.45251e+00,
     & 1.44946e+00, 1.44641e+00, 1.44337e+00, 1.44033e+00/
      DATA (KA_MN2O( 4,JT, 5),JT=1,19)  /
     & 1.40048e+00, 1.39228e+00, 1.38413e+00, 1.37603e+00, 1.36798e+00,
     & 1.35997e+00, 1.35201e+00, 1.34410e+00, 1.33623e+00, 1.32841e+00,
     & 1.32064e+00, 1.31291e+00, 1.30522e+00, 1.29758e+00, 1.28999e+00,
     & 1.28244e+00, 1.27493e+00, 1.26747e+00, 1.26005e+00/
      DATA (KA_MN2O( 5,JT, 5),JT=1,19)  /
     & 1.22253e+00, 1.21202e+00, 1.20160e+00, 1.19126e+00, 1.18102e+00,
     & 1.17087e+00, 1.16080e+00, 1.15082e+00, 1.14092e+00, 1.13111e+00,
     & 1.12139e+00, 1.11174e+00, 1.10219e+00, 1.09271e+00, 1.08331e+00,
     & 1.07400e+00, 1.06476e+00, 1.05561e+00, 1.04653e+00/
      DATA (KA_MN2O( 6,JT, 5),JT=1,19)  /
     & 1.07930e+00, 1.06998e+00, 1.06075e+00, 1.05159e+00, 1.04251e+00,
     & 1.03352e+00, 1.02459e+00, 1.01575e+00, 1.00698e+00, 9.98291e-01,
     & 9.89674e-01, 9.81131e-01, 9.72663e-01, 9.64267e-01, 9.55944e-01,
     & 9.47692e-01, 9.39512e-01, 9.31402e-01, 9.23363e-01/
      DATA (KA_MN2O( 7,JT, 5),JT=1,19)  /
     & 7.87066e-01, 7.82767e-01, 7.78490e-01, 7.74237e-01, 7.70008e-01,
     & 7.65801e-01, 7.61617e-01, 7.57457e-01, 7.53319e-01, 7.49203e-01,
     & 7.45110e-01, 7.41040e-01, 7.36991e-01, 7.32965e-01, 7.28961e-01,
     & 7.24979e-01, 7.21018e-01, 7.17079e-01, 7.13161e-01/
      DATA (KA_MN2O( 8,JT, 5),JT=1,19)  /
     & 3.83362e-01, 3.84405e-01, 3.85452e-01, 3.86501e-01, 3.87552e-01,
     & 3.88607e-01, 3.89665e-01, 3.90725e-01, 3.91788e-01, 3.92855e-01,
     & 3.93924e-01, 3.94996e-01, 3.96071e-01, 3.97149e-01, 3.98229e-01,
     & 3.99313e-01, 4.00400e-01, 4.01489e-01, 4.02582e-01/
      DATA (KA_MN2O( 9,JT, 5),JT=1,19)  /
     & 8.97278e-01, 8.92873e-01, 8.88490e-01, 8.84128e-01, 8.79787e-01,
     & 8.75468e-01, 8.71170e-01, 8.66893e-01, 8.62637e-01, 8.58402e-01,
     & 8.54187e-01, 8.49994e-01, 8.45821e-01, 8.41668e-01, 8.37536e-01,
     & 8.33424e-01, 8.29333e-01, 8.25261e-01, 8.21209e-01/
      DATA (KA_MN2O( 1,JT, 6),JT=1,19)  /
     & 1.83809e+00, 1.84036e+00, 1.84264e+00, 1.84491e+00, 1.84720e+00,
     & 1.84948e+00, 1.85177e+00, 1.85406e+00, 1.85635e+00, 1.85864e+00,
     & 1.86094e+00, 1.86324e+00, 1.86555e+00, 1.86785e+00, 1.87016e+00,
     & 1.87247e+00, 1.87479e+00, 1.87711e+00, 1.87943e+00/
      DATA (KA_MN2O( 2,JT, 6),JT=1,19)  /
     & 1.82624e+00, 1.81564e+00, 1.80510e+00, 1.79463e+00, 1.78421e+00,
     & 1.77386e+00, 1.76356e+00, 1.75333e+00, 1.74315e+00, 1.73304e+00,
     & 1.72298e+00, 1.71298e+00, 1.70304e+00, 1.69316e+00, 1.68333e+00,
     & 1.67356e+00, 1.66385e+00, 1.65419e+00, 1.64459e+00/
      DATA (KA_MN2O( 3,JT, 6),JT=1,19)  /
     & 1.35442e+00, 1.34174e+00, 1.32918e+00, 1.31673e+00, 1.30440e+00,
     & 1.29219e+00, 1.28010e+00, 1.26811e+00, 1.25624e+00, 1.24448e+00,
     & 1.23283e+00, 1.22129e+00, 1.20985e+00, 1.19853e+00, 1.18731e+00,
     & 1.17619e+00, 1.16518e+00, 1.15427e+00, 1.14347e+00/
      DATA (KA_MN2O( 4,JT, 6),JT=1,19)  /
     & 1.10510e+00, 1.09473e+00, 1.08446e+00, 1.07429e+00, 1.06420e+00,
     & 1.05422e+00, 1.04433e+00, 1.03453e+00, 1.02482e+00, 1.01520e+00,
     & 1.00568e+00, 9.96238e-01, 9.86890e-01, 9.77629e-01, 9.68455e-01,
     & 9.59367e-01, 9.50365e-01, 9.41447e-01, 9.32612e-01/
      DATA (KA_MN2O( 5,JT, 6),JT=1,19)  /
     & 1.01083e+00, 1.00221e+00, 9.93656e-01, 9.85178e-01, 9.76772e-01,
     & 9.68437e-01, 9.60174e-01, 9.51981e-01, 9.43859e-01, 9.35805e-01,
     & 9.27821e-01, 9.19904e-01, 9.12055e-01, 9.04273e-01, 8.96557e-01,
     & 8.88907e-01, 8.81323e-01, 8.73803e-01, 8.66347e-01/
      DATA (KA_MN2O( 6,JT, 6),JT=1,19)  /
     & 5.91415e-01, 5.90427e-01, 5.89441e-01, 5.88457e-01, 5.87474e-01,
     & 5.86493e-01, 5.85514e-01, 5.84536e-01, 5.83559e-01, 5.82585e-01,
     & 5.81612e-01, 5.80640e-01, 5.79671e-01, 5.78703e-01, 5.77736e-01,
     & 5.76771e-01, 5.75808e-01, 5.74846e-01, 5.73886e-01/
      DATA (KA_MN2O( 7,JT, 6),JT=1,19)  /
     & 3.68189e-01, 3.70029e-01, 3.71877e-01, 3.73735e-01, 3.75603e-01,
     & 3.77479e-01, 3.79365e-01, 3.81260e-01, 3.83165e-01, 3.85079e-01,
     & 3.87003e-01, 3.88937e-01, 3.90880e-01, 3.92833e-01, 3.94795e-01,
     & 3.96768e-01, 3.98750e-01, 4.00742e-01, 4.02744e-01/
      DATA (KA_MN2O( 8,JT, 6),JT=1,19)  /
     & 2.98721e-01, 2.99932e-01, 3.01149e-01, 3.02370e-01, 3.03597e-01,
     & 3.04828e-01, 3.06064e-01, 3.07306e-01, 3.08552e-01, 3.09804e-01,
     & 3.11060e-01, 3.12322e-01, 3.13589e-01, 3.14860e-01, 3.16138e-01,
     & 3.17420e-01, 3.18707e-01, 3.20000e-01, 3.21298e-01/
      DATA (KA_MN2O( 9,JT, 6),JT=1,19)  /
     & 3.76116e-01, 3.77276e-01, 3.78439e-01, 3.79606e-01, 3.80777e-01,
     & 3.81951e-01, 3.83129e-01, 3.84310e-01, 3.85495e-01, 3.86684e-01,
     & 3.87876e-01, 3.89072e-01, 3.90272e-01, 3.91475e-01, 3.92682e-01,
     & 3.93893e-01, 3.95107e-01, 3.96326e-01, 3.97548e-01/
      DATA (KA_MN2O( 1,JT, 7),JT=1,19)  /
     & 3.22705e+00, 3.21966e+00, 3.21230e+00, 3.20494e+00, 3.19761e+00,
     & 3.19029e+00, 3.18299e+00, 3.17571e+00, 3.16844e+00, 3.16119e+00,
     & 3.15395e+00, 3.14673e+00, 3.13953e+00, 3.13235e+00, 3.12518e+00,
     & 3.11803e+00, 3.11089e+00, 3.10377e+00, 3.09667e+00/
      DATA (KA_MN2O( 2,JT, 7),JT=1,19)  /
     & 1.43811e+00, 1.42367e+00, 1.40938e+00, 1.39522e+00, 1.38121e+00,
     & 1.36735e+00, 1.35362e+00, 1.34002e+00, 1.32657e+00, 1.31325e+00,
     & 1.30006e+00, 1.28701e+00, 1.27408e+00, 1.26129e+00, 1.24862e+00,
     & 1.23609e+00, 1.22367e+00, 1.21139e+00, 1.19922e+00/
      DATA (KA_MN2O( 3,JT, 7),JT=1,19)  /
     & 1.22586e+00, 1.21639e+00, 1.20700e+00, 1.19767e+00, 1.18842e+00,
     & 1.17924e+00, 1.17014e+00, 1.16110e+00, 1.15213e+00, 1.14323e+00,
     & 1.13440e+00, 1.12564e+00, 1.11695e+00, 1.10832e+00, 1.09976e+00,
     & 1.09127e+00, 1.08284e+00, 1.07447e+00, 1.06618e+00/
      DATA (KA_MN2O( 4,JT, 7),JT=1,19)  /
     & 7.94380e-01, 7.92795e-01, 7.91213e-01, 7.89634e-01, 7.88059e-01,
     & 7.86486e-01, 7.84917e-01, 7.83351e-01, 7.81787e-01, 7.80227e-01,
     & 7.78671e-01, 7.77117e-01, 7.75566e-01, 7.74019e-01, 7.72474e-01,
     & 7.70933e-01, 7.69394e-01, 7.67859e-01, 7.66327e-01/
      DATA (KA_MN2O( 5,JT, 7),JT=1,19)  /
     & 4.46935e-01, 4.49760e-01, 4.52602e-01, 4.55462e-01, 4.58340e-01,
     & 4.61237e-01, 4.64152e-01, 4.67085e-01, 4.70037e-01, 4.73007e-01,
     & 4.75996e-01, 4.79004e-01, 4.82031e-01, 4.85078e-01, 4.88143e-01,
     & 4.91228e-01, 4.94332e-01, 4.97456e-01, 5.00600e-01/
      DATA (KA_MN2O( 6,JT, 7),JT=1,19)  /
     & 4.20211e-01, 4.21711e-01, 4.23216e-01, 4.24726e-01, 4.26242e-01,
     & 4.27763e-01, 4.29290e-01, 4.30822e-01, 4.32359e-01, 4.33902e-01,
     & 4.35450e-01, 4.37004e-01, 4.38564e-01, 4.40129e-01, 4.41700e-01,
     & 4.43276e-01, 4.44858e-01, 4.46445e-01, 4.48038e-01/
      DATA (KA_MN2O( 7,JT, 7),JT=1,19)  /
     & 3.42094e-01, 3.43589e-01, 3.45091e-01, 3.46600e-01, 3.48115e-01,
     & 3.49637e-01, 3.51165e-01, 3.52700e-01, 3.54242e-01, 3.55791e-01,
     & 3.57346e-01, 3.58908e-01, 3.60477e-01, 3.62053e-01, 3.63636e-01,
     & 3.65225e-01, 3.66822e-01, 3.68426e-01, 3.70036e-01/
      DATA (KA_MN2O( 8,JT, 7),JT=1,19)  /
     & 2.94919e-01, 2.97460e-01, 3.00022e-01, 3.02606e-01, 3.05212e-01,
     & 3.07841e-01, 3.10492e-01, 3.13167e-01, 3.15864e-01, 3.18584e-01,
     & 3.21328e-01, 3.24096e-01, 3.26887e-01, 3.29703e-01, 3.32543e-01,
     & 3.35407e-01, 3.38296e-01, 3.41210e-01, 3.44148e-01/
      DATA (KA_MN2O( 9,JT, 7),JT=1,19)  /
     & 2.97441e-01, 2.99207e-01, 3.00984e-01, 3.02772e-01, 3.04570e-01,
     & 3.06379e-01, 3.08199e-01, 3.10029e-01, 3.11870e-01, 3.13723e-01,
     & 3.15586e-01, 3.17460e-01, 3.19345e-01, 3.21242e-01, 3.23150e-01,
     & 3.25069e-01, 3.27000e-01, 3.28942e-01, 3.30895e-01/
      DATA (KA_MN2O( 1,JT, 8),JT=1,19)  /
     & 2.14641e+00, 2.12585e+00, 2.10549e+00, 2.08532e+00, 2.06534e+00,
     & 2.04556e+00, 2.02596e+00, 2.00656e+00, 1.98733e+00, 1.96830e+00,
     & 1.94944e+00, 1.93077e+00, 1.91227e+00, 1.89395e+00, 1.87581e+00,
     & 1.85784e+00, 1.84004e+00, 1.82242e+00, 1.80496e+00/
      DATA (KA_MN2O( 2,JT, 8),JT=1,19)  /
     & 8.83687e-01, 8.83170e-01, 8.82654e-01, 8.82137e-01, 8.81621e-01,
     & 8.81106e-01, 8.80590e-01, 8.80075e-01, 8.79560e-01, 8.79046e-01,
     & 8.78531e-01, 8.78017e-01, 8.77504e-01, 8.76990e-01, 8.76477e-01,
     & 8.75965e-01, 8.75452e-01, 8.74940e-01, 8.74428e-01/
      DATA (KA_MN2O( 3,JT, 8),JT=1,19)  /
     & 4.49840e-01, 4.52683e-01, 4.55543e-01, 4.58421e-01, 4.61318e-01,
     & 4.64233e-01, 4.67166e-01, 4.70118e-01, 4.73088e-01, 4.76078e-01,
     & 4.79086e-01, 4.82113e-01, 4.85159e-01, 4.88225e-01, 4.91310e-01,
     & 4.94414e-01, 4.97538e-01, 5.00682e-01, 5.03845e-01/
      DATA (KA_MN2O( 4,JT, 8),JT=1,19)  /
     & 3.92292e-01, 3.93574e-01, 3.94861e-01, 3.96151e-01, 3.97446e-01,
     & 3.98746e-01, 4.00049e-01, 4.01357e-01, 4.02669e-01, 4.03985e-01,
     & 4.05306e-01, 4.06630e-01, 4.07960e-01, 4.09293e-01, 4.10631e-01,
     & 4.11973e-01, 4.13320e-01, 4.14671e-01, 4.16027e-01/
      DATA (KA_MN2O( 5,JT, 8),JT=1,19)  /
     & 3.38920e-01, 3.41151e-01, 3.43397e-01, 3.45658e-01, 3.47934e-01,
     & 3.50225e-01, 3.52531e-01, 3.54852e-01, 3.57189e-01, 3.59541e-01,
     & 3.61908e-01, 3.64291e-01, 3.66689e-01, 3.69104e-01, 3.71534e-01,
     & 3.73980e-01, 3.76443e-01, 3.78921e-01, 3.81416e-01/
      DATA (KA_MN2O( 6,JT, 8),JT=1,19)  /
     & 3.01673e-01, 3.04752e-01, 3.07863e-01, 3.11005e-01, 3.14180e-01,
     & 3.17387e-01, 3.20626e-01, 3.23899e-01, 3.27205e-01, 3.30545e-01,
     & 3.33919e-01, 3.37328e-01, 3.40771e-01, 3.44249e-01, 3.47763e-01,
     & 3.51313e-01, 3.54899e-01, 3.58521e-01, 3.62181e-01/
      DATA (KA_MN2O( 7,JT, 8),JT=1,19)  /
     & 2.99381e-01, 3.02431e-01, 3.05512e-01, 3.08624e-01, 3.11768e-01,
     & 3.14945e-01, 3.18153e-01, 3.21394e-01, 3.24668e-01, 3.27976e-01,
     & 3.31317e-01, 3.34693e-01, 3.38102e-01, 3.41547e-01, 3.45026e-01,
     & 3.48541e-01, 3.52092e-01, 3.55679e-01, 3.59302e-01/
      DATA (KA_MN2O( 8,JT, 8),JT=1,19)  /
     & 2.87559e-01, 2.89153e-01, 2.90756e-01, 2.92367e-01, 2.93987e-01,
     & 2.95617e-01, 2.97255e-01, 2.98902e-01, 3.00559e-01, 3.02225e-01,
     & 3.03899e-01, 3.05584e-01, 3.07277e-01, 3.08980e-01, 3.10693e-01,
     & 3.12414e-01, 3.14146e-01, 3.15887e-01, 3.17638e-01/
      DATA (KA_MN2O( 9,JT, 8),JT=1,19)  /
     & 2.96238e-01, 2.97588e-01, 2.98945e-01, 3.00309e-01, 3.01678e-01,
     & 3.03054e-01, 3.04436e-01, 3.05824e-01, 3.07219e-01, 3.08620e-01,
     & 3.10027e-01, 3.11441e-01, 3.12861e-01, 3.14288e-01, 3.15721e-01,
     & 3.17161e-01, 3.18607e-01, 3.20060e-01, 3.21520e-01/
      DATA (KA_MN2O( 1,JT, 9),JT=1,19)  /
     & 1.56483e+00, 1.55792e+00, 1.55105e+00, 1.54420e+00, 1.53739e+00,
     & 1.53060e+00, 1.52384e+00, 1.51712e+00, 1.51042e+00, 1.50376e+00,
     & 1.49712e+00, 1.49051e+00, 1.48393e+00, 1.47738e+00, 1.47086e+00,
     & 1.46437e+00, 1.45791e+00, 1.45147e+00, 1.44507e+00/
      DATA (KA_MN2O( 2,JT, 9),JT=1,19)  /
     & 4.09526e-01, 4.10301e-01, 4.11078e-01, 4.11857e-01, 4.12637e-01,
     & 4.13418e-01, 4.14201e-01, 4.14986e-01, 4.15771e-01, 4.16559e-01,
     & 4.17348e-01, 4.18138e-01, 4.18930e-01, 4.19723e-01, 4.20518e-01,
     & 4.21315e-01, 4.22112e-01, 4.22912e-01, 4.23713e-01/
      DATA (KA_MN2O( 3,JT, 9),JT=1,19)  /
     & 3.35672e-01, 3.38982e-01, 3.42326e-01, 3.45702e-01, 3.49111e-01,
     & 3.52554e-01, 3.56031e-01, 3.59543e-01, 3.63089e-01, 3.66670e-01,
     & 3.70286e-01, 3.73938e-01, 3.77626e-01, 3.81350e-01, 3.85111e-01,
     & 3.88909e-01, 3.92745e-01, 3.96618e-01, 4.00530e-01/
      DATA (KA_MN2O( 4,JT, 9),JT=1,19)  /
     & 3.19130e-01, 3.23028e-01, 3.26973e-01, 3.30966e-01, 3.35008e-01,
     & 3.39100e-01, 3.43241e-01, 3.47433e-01, 3.51676e-01, 3.55971e-01,
     & 3.60319e-01, 3.64719e-01, 3.69173e-01, 3.73682e-01, 3.78246e-01,
     & 3.82865e-01, 3.87541e-01, 3.92274e-01, 3.97065e-01/
      DATA (KA_MN2O( 5,JT, 9),JT=1,19)  /
     & 3.04385e-01, 3.07155e-01, 3.09949e-01, 3.12770e-01, 3.15616e-01,
     & 3.18488e-01, 3.21386e-01, 3.24310e-01, 3.27261e-01, 3.30239e-01,
     & 3.33244e-01, 3.36276e-01, 3.39336e-01, 3.42424e-01, 3.45540e-01,
     & 3.48684e-01, 3.51857e-01, 3.55059e-01, 3.58289e-01/
      DATA (KA_MN2O( 6,JT, 9),JT=1,19)  /
     & 2.98789e-01, 3.00996e-01, 3.03220e-01, 3.05460e-01, 3.07717e-01,
     & 3.09990e-01, 3.12281e-01, 3.14588e-01, 3.16912e-01, 3.19253e-01,
     & 3.21612e-01, 3.23988e-01, 3.26382e-01, 3.28793e-01, 3.31222e-01,
     & 3.33669e-01, 3.36134e-01, 3.38618e-01, 3.41119e-01/
      DATA (KA_MN2O( 7,JT, 9),JT=1,19)  /
     & 3.08712e-01, 3.10491e-01, 3.12281e-01, 3.14080e-01, 3.15890e-01,
     & 3.17710e-01, 3.19541e-01, 3.21382e-01, 3.23234e-01, 3.25097e-01,
     & 3.26970e-01, 3.28854e-01, 3.30749e-01, 3.32655e-01, 3.34572e-01,
     & 3.36500e-01, 3.38439e-01, 3.40390e-01, 3.42351e-01/
      DATA (KA_MN2O( 8,JT, 9),JT=1,19)  /
     & 3.10571e-01, 3.12262e-01, 3.13961e-01, 3.15670e-01, 3.17388e-01,
     & 3.19115e-01, 3.20852e-01, 3.22598e-01, 3.24354e-01, 3.26120e-01,
     & 3.27895e-01, 3.29679e-01, 3.31474e-01, 3.33278e-01, 3.35092e-01,
     & 3.36915e-01, 3.38749e-01, 3.40593e-01, 3.42447e-01/
      DATA (KA_MN2O( 9,JT, 9),JT=1,19)  /
     & 3.16436e-01, 3.18200e-01, 3.19974e-01, 3.21759e-01, 3.23553e-01,
     & 3.25357e-01, 3.27172e-01, 3.28996e-01, 3.30831e-01, 3.32675e-01,
     & 3.34530e-01, 3.36396e-01, 3.38272e-01, 3.40158e-01, 3.42055e-01,
     & 3.43962e-01, 3.45880e-01, 3.47809e-01, 3.49749e-01/
      DATA (KA_MN2O( 1,JT,10),JT=1,19)  /
     & 7.68616e-01, 7.63263e-01, 7.57948e-01, 7.52669e-01, 7.47428e-01,
     & 7.42223e-01, 7.37054e-01, 7.31921e-01, 7.26824e-01, 7.21762e-01,
     & 7.16736e-01, 7.11744e-01, 7.06788e-01, 7.01866e-01, 6.96978e-01,
     & 6.92124e-01, 6.87304e-01, 6.82517e-01, 6.77764e-01/
      DATA (KA_MN2O( 2,JT,10),JT=1,19)  /
     & 4.97271e-01, 5.10054e-01, 5.23165e-01, 5.36614e-01, 5.50408e-01,
     & 5.64556e-01, 5.79069e-01, 5.93954e-01, 6.09222e-01, 6.24883e-01,
     & 6.40946e-01, 6.57422e-01, 6.74321e-01, 6.91655e-01, 7.09435e-01,
     & 7.27671e-01, 7.46377e-01, 7.65563e-01, 7.85242e-01/
      DATA (KA_MN2O( 3,JT,10),JT=1,19)  /
     & 2.44443e-01, 2.47096e-01, 2.49778e-01, 2.52489e-01, 2.55229e-01,
     & 2.57999e-01, 2.60799e-01, 2.63630e-01, 2.66491e-01, 2.69383e-01,
     & 2.72307e-01, 2.75262e-01, 2.78250e-01, 2.81269e-01, 2.84322e-01,
     & 2.87408e-01, 2.90527e-01, 2.93680e-01, 2.96868e-01/
      DATA (KA_MN2O( 4,JT,10),JT=1,19)  /
     & 2.01964e-01, 2.02869e-01, 2.03777e-01, 2.04690e-01, 2.05606e-01,
     & 2.06527e-01, 2.07452e-01, 2.08381e-01, 2.09314e-01, 2.10251e-01,
     & 2.11193e-01, 2.12139e-01, 2.13089e-01, 2.14043e-01, 2.15002e-01,
     & 2.15964e-01, 2.16932e-01, 2.17903e-01, 2.18879e-01/
      DATA (KA_MN2O( 5,JT,10),JT=1,19)  /
     & 2.56972e-01, 2.56837e-01, 2.56702e-01, 2.56567e-01, 2.56432e-01,
     & 2.56297e-01, 2.56162e-01, 2.56027e-01, 2.55893e-01, 2.55758e-01,
     & 2.55624e-01, 2.55489e-01, 2.55355e-01, 2.55220e-01, 2.55086e-01,
     & 2.54952e-01, 2.54818e-01, 2.54684e-01, 2.54550e-01/
      DATA (KA_MN2O( 6,JT,10),JT=1,19)  /
     & 2.57322e-01, 2.57187e-01, 2.57052e-01, 2.56917e-01, 2.56782e-01,
     & 2.56647e-01, 2.56512e-01, 2.56377e-01, 2.56243e-01, 2.56108e-01,
     & 2.55974e-01, 2.55839e-01, 2.55705e-01, 2.55570e-01, 2.55436e-01,
     & 2.55302e-01, 2.55168e-01, 2.55034e-01, 2.54900e-01/
      DATA (KA_MN2O( 7,JT,10),JT=1,19)  /
     & 2.56551e-01, 2.56421e-01, 2.56291e-01, 2.56161e-01, 2.56030e-01,
     & 2.55900e-01, 2.55770e-01, 2.55640e-01, 2.55511e-01, 2.55381e-01,
     & 2.55251e-01, 2.55121e-01, 2.54992e-01, 2.54862e-01, 2.54733e-01,
     & 2.54603e-01, 2.54474e-01, 2.54345e-01, 2.54215e-01/
      DATA (KA_MN2O( 8,JT,10),JT=1,19)  /
     & 2.73629e-01, 2.73460e-01, 2.73291e-01, 2.73122e-01, 2.72953e-01,
     & 2.72784e-01, 2.72615e-01, 2.72447e-01, 2.72279e-01, 2.72110e-01,
     & 2.71942e-01, 2.71774e-01, 2.71606e-01, 2.71438e-01, 2.71270e-01,
     & 2.71102e-01, 2.70935e-01, 2.70767e-01, 2.70600e-01/
      DATA (KA_MN2O( 9,JT,10),JT=1,19)  /
     & 2.57294e-01, 2.57149e-01, 2.57004e-01, 2.56860e-01, 2.56715e-01,
     & 2.56570e-01, 2.56426e-01, 2.56282e-01, 2.56137e-01, 2.55993e-01,
     & 2.55849e-01, 2.55705e-01, 2.55561e-01, 2.55417e-01, 2.55273e-01,
     & 2.55129e-01, 2.54986e-01, 2.54842e-01, 2.54698e-01/
      DATA (KA_MN2O( 1,JT,11),JT=1,19)  /
     & 6.91062e-01, 6.84151e-01, 6.77309e-01, 6.70535e-01, 6.63829e-01,
     & 6.57190e-01, 6.50617e-01, 6.44111e-01, 6.37669e-01, 6.31292e-01,
     & 6.24978e-01, 6.18728e-01, 6.12540e-01, 6.06414e-01, 6.00349e-01,
     & 5.94345e-01, 5.88401e-01, 5.82517e-01, 5.76691e-01/
      DATA (KA_MN2O( 2,JT,11),JT=1,19)  /
     & 1.98698e-01, 2.01182e-01, 2.03698e-01, 2.06244e-01, 2.08823e-01,
     & 2.11433e-01, 2.14077e-01, 2.16753e-01, 2.19463e-01, 2.22207e-01,
     & 2.24985e-01, 2.27798e-01, 2.30646e-01, 2.33529e-01, 2.36449e-01,
     & 2.39405e-01, 2.42398e-01, 2.45429e-01, 2.48497e-01/
      DATA (KA_MN2O( 3,JT,11),JT=1,19)  /
     & 2.11950e-01, 2.13560e-01, 2.15184e-01, 2.16819e-01, 2.18467e-01,
     & 2.20127e-01, 2.21800e-01, 2.23486e-01, 2.25185e-01, 2.26896e-01,
     & 2.28621e-01, 2.30358e-01, 2.32109e-01, 2.33873e-01, 2.35651e-01,
     & 2.37442e-01, 2.39247e-01, 2.41065e-01, 2.42897e-01/
      DATA (KA_MN2O( 4,JT,11),JT=1,19)  /
     & 3.14210e-01, 3.13143e-01, 3.12080e-01, 3.11021e-01, 3.09965e-01,
     & 3.08913e-01, 3.07864e-01, 3.06819e-01, 3.05777e-01, 3.04739e-01,
     & 3.03705e-01, 3.02674e-01, 3.01646e-01, 3.00622e-01, 2.99602e-01,
     & 2.98584e-01, 2.97571e-01, 2.96561e-01, 2.95554e-01/
      DATA (KA_MN2O( 5,JT,11),JT=1,19)  /
     & 3.13536e-01, 3.12459e-01, 3.11386e-01, 3.10316e-01, 3.09250e-01,
     & 3.08188e-01, 3.07129e-01, 3.06074e-01, 3.05022e-01, 3.03974e-01,
     & 3.02930e-01, 3.01889e-01, 3.00852e-01, 2.99819e-01, 2.98789e-01,
     & 2.97762e-01, 2.96739e-01, 2.95720e-01, 2.94704e-01/
      DATA (KA_MN2O( 6,JT,11),JT=1,19)  /
     & 3.13215e-01, 3.12123e-01, 3.11034e-01, 3.09949e-01, 3.08867e-01,
     & 3.07790e-01, 3.06716e-01, 3.05646e-01, 3.04579e-01, 3.03517e-01,
     & 3.02458e-01, 3.01403e-01, 3.00351e-01, 2.99303e-01, 2.98259e-01,
     & 2.97219e-01, 2.96182e-01, 2.95148e-01, 2.94119e-01/
      DATA (KA_MN2O( 7,JT,11),JT=1,19)  /
     & 3.14236e-01, 3.13123e-01, 3.12014e-01, 3.10908e-01, 3.09806e-01,
     & 3.08709e-01, 3.07615e-01, 3.06525e-01, 3.05439e-01, 3.04357e-01,
     & 3.03278e-01, 3.02204e-01, 3.01133e-01, 3.00066e-01, 2.99003e-01,
     & 2.97944e-01, 2.96888e-01, 2.95836e-01, 2.94788e-01/
      DATA (KA_MN2O( 8,JT,11),JT=1,19)  /
     & 2.97453e-01, 2.96420e-01, 2.95391e-01, 2.94366e-01, 2.93344e-01,
     & 2.92325e-01, 2.91311e-01, 2.90299e-01, 2.89291e-01, 2.88287e-01,
     & 2.87286e-01, 2.86289e-01, 2.85295e-01, 2.84304e-01, 2.83317e-01,
     & 2.82334e-01, 2.81354e-01, 2.80377e-01, 2.79404e-01/
      DATA (KA_MN2O( 9,JT,11),JT=1,19)  /
     & 3.12694e-01, 3.11622e-01, 3.10554e-01, 3.09489e-01, 3.08428e-01,
     & 3.07370e-01, 3.06316e-01, 3.05266e-01, 3.04220e-01, 3.03177e-01,
     & 3.02137e-01, 3.01101e-01, 3.00069e-01, 2.99040e-01, 2.98015e-01,
     & 2.96993e-01, 2.95975e-01, 2.94960e-01, 2.93949e-01/
      DATA (KA_MN2O( 1,JT,12),JT=1,19)  /
     & 5.30796e-01, 5.50444e-01, 5.70818e-01, 5.91947e-01, 6.13857e-01,
     & 6.36579e-01, 6.60142e-01, 6.84577e-01, 7.09916e-01, 7.36194e-01,
     & 7.63444e-01, 7.91702e-01, 8.21007e-01, 8.51396e-01, 8.82910e-01,
     & 9.15591e-01, 9.49481e-01, 9.84626e-01, 1.02107e+00/
      DATA (KA_MN2O( 2,JT,12),JT=1,19)  /
     & 1.38469e-01, 1.40959e-01, 1.43493e-01, 1.46073e-01, 1.48699e-01,
     & 1.51373e-01, 1.54094e-01, 1.56865e-01, 1.59685e-01, 1.62556e-01,
     & 1.65478e-01, 1.68454e-01, 1.71482e-01, 1.74565e-01, 1.77704e-01,
     & 1.80899e-01, 1.84151e-01, 1.87462e-01, 1.90833e-01/
      DATA (KA_MN2O( 3,JT,12),JT=1,19)  /
     & 1.50741e-01, 1.50855e-01, 1.50969e-01, 1.51084e-01, 1.51198e-01,
     & 1.51313e-01, 1.51427e-01, 1.51542e-01, 1.51657e-01, 1.51772e-01,
     & 1.51887e-01, 1.52002e-01, 1.52117e-01, 1.52233e-01, 1.52348e-01,
     & 1.52463e-01, 1.52579e-01, 1.52695e-01, 1.52810e-01/
      DATA (KA_MN2O( 4,JT,12),JT=1,19)  /
     & 1.80444e-01, 1.79944e-01, 1.79445e-01, 1.78948e-01, 1.78452e-01,
     & 1.77958e-01, 1.77465e-01, 1.76973e-01, 1.76483e-01, 1.75994e-01,
     & 1.75506e-01, 1.75020e-01, 1.74535e-01, 1.74051e-01, 1.73569e-01,
     & 1.73088e-01, 1.72609e-01, 1.72131e-01, 1.71654e-01/
      DATA (KA_MN2O( 5,JT,12),JT=1,19)  /
     & 1.80595e-01, 1.80033e-01, 1.79474e-01, 1.78916e-01, 1.78359e-01,
     & 1.77805e-01, 1.77252e-01, 1.76701e-01, 1.76152e-01, 1.75604e-01,
     & 1.75058e-01, 1.74514e-01, 1.73971e-01, 1.73430e-01, 1.72891e-01,
     & 1.72354e-01, 1.71818e-01, 1.71284e-01, 1.70751e-01/
      DATA (KA_MN2O( 6,JT,12),JT=1,19)  /
     & 1.79904e-01, 1.79254e-01, 1.78607e-01, 1.77962e-01, 1.77320e-01,
     & 1.76680e-01, 1.76042e-01, 1.75406e-01, 1.74773e-01, 1.74142e-01,
     & 1.73513e-01, 1.72887e-01, 1.72262e-01, 1.71640e-01, 1.71021e-01,
     & 1.70403e-01, 1.69788e-01, 1.69175e-01, 1.68564e-01/
      DATA (KA_MN2O( 7,JT,12),JT=1,19)  /
     & 1.78712e-01, 1.77868e-01, 1.77027e-01, 1.76190e-01, 1.75357e-01,
     & 1.74528e-01, 1.73703e-01, 1.72882e-01, 1.72064e-01, 1.71251e-01,
     & 1.70441e-01, 1.69636e-01, 1.68834e-01, 1.68036e-01, 1.67241e-01,
     & 1.66451e-01, 1.65664e-01, 1.64881e-01, 1.64101e-01/
      DATA (KA_MN2O( 8,JT,12),JT=1,19)  /
     & 1.72346e-01, 1.70873e-01, 1.69413e-01, 1.67965e-01, 1.66530e-01,
     & 1.65107e-01, 1.63696e-01, 1.62297e-01, 1.60910e-01, 1.59535e-01,
     & 1.58171e-01, 1.56819e-01, 1.55479e-01, 1.54150e-01, 1.52833e-01,
     & 1.51527e-01, 1.50232e-01, 1.48948e-01, 1.47675e-01/
      DATA (KA_MN2O( 9,JT,12),JT=1,19)  /
     & 1.80517e-01, 1.79951e-01, 1.79386e-01, 1.78823e-01, 1.78262e-01,
     & 1.77702e-01, 1.77144e-01, 1.76588e-01, 1.76034e-01, 1.75481e-01,
     & 1.74931e-01, 1.74382e-01, 1.73834e-01, 1.73289e-01, 1.72745e-01,
     & 1.72202e-01, 1.71662e-01, 1.71123e-01, 1.70586e-01/
      DATA (KA_MN2O( 1,JT,13),JT=1,19)  /
     & 2.41966e-01, 2.50534e-01, 2.59406e-01, 2.68591e-01, 2.78102e-01,
     & 2.87950e-01, 2.98146e-01, 3.08704e-01, 3.19635e-01, 3.30953e-01,
     & 3.42672e-01, 3.54806e-01, 3.67370e-01, 3.80379e-01, 3.93848e-01,
     & 4.07794e-01, 4.22234e-01, 4.37186e-01, 4.52667e-01/
      DATA (KA_MN2O( 2,JT,13),JT=1,19)  /
     & 1.54385e-01, 1.54015e-01, 1.53646e-01, 1.53279e-01, 1.52912e-01,
     & 1.52545e-01, 1.52180e-01, 1.51816e-01, 1.51452e-01, 1.51089e-01,
     & 1.50728e-01, 1.50367e-01, 1.50007e-01, 1.49647e-01, 1.49289e-01,
     & 1.48932e-01, 1.48575e-01, 1.48219e-01, 1.47864e-01/
      DATA (KA_MN2O( 3,JT,13),JT=1,19)  /
     & 2.00518e-01, 1.94901e-01, 1.89442e-01, 1.84136e-01, 1.78978e-01,
     & 1.73965e-01, 1.69092e-01, 1.64356e-01, 1.59752e-01, 1.55278e-01,
     & 1.50928e-01, 1.46701e-01, 1.42592e-01, 1.38598e-01, 1.34715e-01,
     & 1.30942e-01, 1.27274e-01, 1.23709e-01, 1.20244e-01/
      DATA (KA_MN2O( 4,JT,13),JT=1,19)  /
     & 2.03974e-01, 1.98258e-01, 1.92703e-01, 1.87302e-01, 1.82054e-01,
     & 1.76952e-01, 1.71993e-01, 1.67173e-01, 1.62489e-01, 1.57935e-01,
     & 1.53509e-01, 1.49207e-01, 1.45026e-01, 1.40962e-01, 1.37012e-01,
     & 1.33172e-01, 1.29440e-01, 1.25813e-01, 1.22287e-01/
      DATA (KA_MN2O( 5,JT,13),JT=1,19)  /
     & 2.09410e-01, 2.03543e-01, 1.97841e-01, 1.92298e-01, 1.86911e-01,
     & 1.81674e-01, 1.76585e-01, 1.71637e-01, 1.66829e-01, 1.62155e-01,
     & 1.57612e-01, 1.53196e-01, 1.48904e-01, 1.44733e-01, 1.40678e-01,
     & 1.36736e-01, 1.32906e-01, 1.29182e-01, 1.25563e-01/
      DATA (KA_MN2O( 6,JT,13),JT=1,19)  /
     & 2.19808e-01, 2.13643e-01, 2.07651e-01, 2.01827e-01, 1.96166e-01,
     & 1.90664e-01, 1.85317e-01, 1.80119e-01, 1.75067e-01, 1.70157e-01,
     & 1.65385e-01, 1.60746e-01, 1.56238e-01, 1.51856e-01, 1.47596e-01,
     & 1.43457e-01, 1.39433e-01, 1.35523e-01, 1.31722e-01/
      DATA (KA_MN2O( 7,JT,13),JT=1,19)  /
     & 2.47074e-01, 2.40127e-01, 2.33375e-01, 2.26813e-01, 2.20436e-01,
     & 2.14238e-01, 2.08215e-01, 2.02360e-01, 1.96671e-01, 1.91141e-01,
     & 1.85767e-01, 1.80544e-01, 1.75467e-01, 1.70534e-01, 1.65739e-01,
     & 1.61079e-01, 1.56550e-01, 1.52148e-01, 1.47870e-01/
      DATA (KA_MN2O( 8,JT,13),JT=1,19)  /
     & 2.55282e-01, 2.48105e-01, 2.41130e-01, 2.34350e-01, 2.27762e-01,
     & 2.21358e-01, 2.15135e-01, 2.09086e-01, 2.03208e-01, 1.97495e-01,
     & 1.91942e-01, 1.86546e-01, 1.81301e-01, 1.76204e-01, 1.71250e-01,
     & 1.66435e-01, 1.61756e-01, 1.57208e-01, 1.52788e-01/
      DATA (KA_MN2O( 9,JT,13),JT=1,19)  /
     & 2.09991e-01, 2.04103e-01, 1.98380e-01, 1.92818e-01, 1.87411e-01,
     & 1.82156e-01, 1.77048e-01, 1.72084e-01, 1.67259e-01, 1.62569e-01,
     & 1.58010e-01, 1.53580e-01, 1.49273e-01, 1.45087e-01, 1.41019e-01,
     & 1.37065e-01, 1.33222e-01, 1.29486e-01, 1.25855e-01/
      DATA (KA_MN2O( 1,JT,14),JT=1,19)  /
     & 9.08340e-02, 9.50421e-02, 9.94452e-02, 1.04052e-01, 1.08873e-01,
     & 1.13917e-01, 1.19194e-01, 1.24716e-01, 1.30494e-01, 1.36540e-01,
     & 1.42865e-01, 1.49484e-01, 1.56409e-01, 1.63655e-01, 1.71237e-01,
     & 1.79170e-01, 1.87471e-01, 1.96156e-01, 2.05243e-01/
      DATA (KA_MN2O( 2,JT,14),JT=1,19)  /
     & 3.36945e-02, 3.45144e-02, 3.53542e-02, 3.62144e-02, 3.70956e-02,
     & 3.79982e-02, 3.89228e-02, 3.98698e-02, 4.08399e-02, 4.18336e-02,
     & 4.28515e-02, 4.38942e-02, 4.49622e-02, 4.60562e-02, 4.71769e-02,
     & 4.83248e-02, 4.95006e-02, 5.07051e-02, 5.19388e-02/
      DATA (KA_MN2O( 3,JT,14),JT=1,19)  /
     & 9.11678e-02, 8.85761e-02, 8.60580e-02, 8.36116e-02, 8.12347e-02,
     & 7.89253e-02, 7.66817e-02, 7.45017e-02, 7.23838e-02, 7.03261e-02,
     & 6.83269e-02, 6.63845e-02, 6.44973e-02, 6.26638e-02, 6.08824e-02,
     & 5.91516e-02, 5.74700e-02, 5.58363e-02, 5.42490e-02/
      DATA (KA_MN2O( 4,JT,14),JT=1,19)  /
     & 8.43999e-02, 8.20004e-02, 7.96692e-02, 7.74042e-02, 7.52037e-02,
     & 7.30656e-02, 7.09884e-02, 6.89702e-02, 6.70094e-02, 6.51044e-02,
     & 6.32535e-02, 6.14552e-02, 5.97081e-02, 5.80106e-02, 5.63614e-02,
     & 5.47590e-02, 5.32022e-02, 5.16897e-02, 5.02202e-02/
      DATA (KA_MN2O( 5,JT,14),JT=1,19)  /
     & 7.41279e-02, 7.20196e-02, 6.99712e-02, 6.79811e-02, 6.60476e-02,
     & 6.41691e-02, 6.23440e-02, 6.05708e-02, 5.88481e-02, 5.71743e-02,
     & 5.55482e-02, 5.39683e-02, 5.24334e-02, 5.09421e-02, 4.94932e-02,
     & 4.80855e-02, 4.67179e-02, 4.53891e-02, 4.40982e-02/
      DATA (KA_MN2O( 6,JT,14),JT=1,19)  /
     & 5.66805e-02, 5.50676e-02, 5.35006e-02, 5.19782e-02, 5.04991e-02,
     & 4.90621e-02, 4.76659e-02, 4.63096e-02, 4.49918e-02, 4.37115e-02,
     & 4.24676e-02, 4.12592e-02, 4.00851e-02, 3.89444e-02, 3.78362e-02,
     & 3.67595e-02, 3.57135e-02, 3.46972e-02, 3.37099e-02/
      DATA (KA_MN2O( 7,JT,14),JT=1,19)  /
     & 1.23018e-02, 1.19517e-02, 1.16116e-02, 1.12811e-02, 1.09601e-02,
     & 1.06482e-02, 1.03452e-02, 1.00508e-02, 9.76474e-03, 9.48685e-03,
     & 9.21687e-03, 8.95458e-03, 8.69974e-03, 8.45216e-03, 8.21163e-03,
     & 7.97794e-03, 7.75091e-03, 7.53033e-03, 7.31603e-03/
      DATA (KA_MN2O( 8,JT,14),JT=1,19)  /
     & 3.22403e-07, 3.75986e-07, 4.38475e-07, 5.11349e-07, 5.96335e-07,
     & 6.95446e-07, 8.11028e-07, 9.45821e-07, 1.10302e-06, 1.28634e-06,
     & 1.50012e-06, 1.74944e-06, 2.04020e-06, 2.37928e-06, 2.77472e-06,
     & 3.23587e-06, 3.77367e-06, 4.40085e-06, 5.13227e-06/
      DATA (KA_MN2O( 9,JT,14),JT=1,19)  /
     & 7.33052e-02, 7.12199e-02, 6.91939e-02, 6.72255e-02, 6.53131e-02,
     & 6.34551e-02, 6.16500e-02, 5.98963e-02, 5.81924e-02, 5.65370e-02,
     & 5.49287e-02, 5.33661e-02, 5.18480e-02, 5.03730e-02, 4.89401e-02,
     & 4.75479e-02, 4.61953e-02, 4.48811e-02, 4.36044e-02/
      DATA (KA_MN2O( 1,JT,15),JT=1,19)  /
     & 8.80247e-02, 9.01793e-02, 9.23868e-02, 9.46482e-02, 9.69650e-02,
     & 9.93385e-02, 1.01770e-01, 1.04261e-01, 1.06813e-01, 1.09428e-01,
     & 1.12107e-01, 1.14851e-01, 1.17662e-01, 1.20542e-01, 1.23493e-01,
     & 1.26516e-01, 1.29613e-01, 1.32785e-01, 1.36036e-01/
      DATA (KA_MN2O( 2,JT,15),JT=1,19)  /
     & 3.89107e-07, 4.53768e-07, 5.29173e-07, 6.17109e-07, 7.19658e-07,
     & 8.39248e-07, 9.78710e-07, 1.14135e-06, 1.33101e-06, 1.55220e-06,
     & 1.81013e-06, 2.11094e-06, 2.46172e-06, 2.87080e-06, 3.34786e-06,
     & 3.90420e-06, 4.55298e-06, 5.30958e-06, 6.19190e-06/
      DATA (KA_MN2O( 3,JT,15),JT=1,19)  /
     & 3.86537e-07, 4.50763e-07, 5.25662e-07, 6.13006e-07, 7.14863e-07,
     & 8.33644e-07, 9.72162e-07, 1.13370e-06, 1.32207e-06, 1.54175e-06,
     & 1.79792e-06, 2.09666e-06, 2.44504e-06, 2.85131e-06, 3.32508e-06,
     & 3.87758e-06, 4.52188e-06, 5.27323e-06, 6.14943e-06/
      DATA (KA_MN2O( 4,JT,15),JT=1,19)  /
     & 3.81913e-07, 4.45369e-07, 5.19369e-07, 6.05664e-07, 7.06297e-07,
     & 8.23651e-07, 9.60503e-07, 1.12009e-06, 1.30620e-06, 1.52323e-06,
     & 1.77632e-06, 2.07147e-06, 2.41565e-06, 2.81701e-06, 3.28507e-06,
     & 3.83090e-06, 4.46741e-06, 5.20969e-06, 6.07529e-06/
      DATA (KA_MN2O( 5,JT,15),JT=1,19)  /
     & 3.77265e-07, 4.39951e-07, 5.13053e-07, 5.98303e-07, 6.97717e-07,
     & 8.13650e-07, 9.48846e-07, 1.10651e-06, 1.29036e-06, 1.50477e-06,
     & 1.75480e-06, 2.04638e-06, 2.38641e-06, 2.78294e-06, 3.24535e-06,
     & 3.78460e-06, 4.41345e-06, 5.14679e-06, 6.00198e-06/
      DATA (KA_MN2O( 6,JT,15),JT=1,19)  /
     & 3.77877e-07, 4.40670e-07, 5.13897e-07, 5.99292e-07, 6.98878e-07,
     & 8.15012e-07, 9.50444e-07, 1.10838e-06, 1.29256e-06, 1.50735e-06,
     & 1.75783e-06, 2.04993e-06, 2.39057e-06, 2.78782e-06, 3.25107e-06,
     & 3.79131e-06, 4.42132e-06, 5.15602e-06, 6.01280e-06/
      DATA (KA_MN2O( 7,JT,15),JT=1,19)  /
     & 3.80495e-07, 4.43726e-07, 5.17465e-07, 6.03458e-07, 7.03741e-07,
     & 8.20689e-07, 9.57072e-07, 1.11612e-06, 1.30160e-06, 1.51790e-06,
     & 1.77014e-06, 2.06430e-06, 2.40735e-06, 2.80741e-06, 3.27394e-06,
     & 3.81801e-06, 4.45249e-06, 5.19241e-06, 6.05528e-06/
      DATA (KA_MN2O( 8,JT,15),JT=1,19)  /
     & 3.87881e-07, 4.52329e-07, 5.27486e-07, 6.15129e-07, 7.17335e-07,
     & 8.36523e-07, 9.75515e-07, 1.13760e-06, 1.32662e-06, 1.54704e-06,
     & 1.80409e-06, 2.10384e-06, 2.45340e-06, 2.86105e-06, 3.33642e-06,
     & 3.89078e-06, 4.53725e-06, 5.29112e-06, 6.17026e-06/
      DATA (KA_MN2O( 9,JT,15),JT=1,19)  /
     & 3.77265e-07, 4.39951e-07, 5.13053e-07, 5.98303e-07, 6.97717e-07,
     & 8.13650e-07, 9.48846e-07, 1.10651e-06, 1.29036e-06, 1.50477e-06,
     & 1.75480e-06, 2.04638e-06, 2.38641e-06, 2.78294e-06, 3.24535e-06,
     & 3.78460e-06, 4.41345e-06, 5.14679e-06, 6.00198e-06/
      DATA (KA_MN2O( 1,JT,16),JT=1,19)  /
     & 8.84606e-02, 9.05971e-02, 9.27852e-02, 9.50261e-02, 9.73212e-02,
     & 9.96717e-02, 1.02079e-01, 1.04544e-01, 1.07069e-01, 1.09655e-01,
     & 1.12304e-01, 1.15016e-01, 1.17794e-01, 1.20639e-01, 1.23553e-01,
     & 1.26537e-01, 1.29593e-01, 1.32723e-01, 1.35928e-01/
      DATA (KA_MN2O( 2,JT,16),JT=1,19)  /
     & 8.13898e-07, 9.49130e-07, 1.10683e-06, 1.29073e-06, 1.50519e-06,
     & 1.75528e-06, 2.04693e-06, 2.38703e-06, 2.78364e-06, 3.24615e-06,
     & 3.78551e-06, 4.41449e-06, 5.14796e-06, 6.00331e-06, 7.00078e-06,
     & 8.16398e-06, 9.52045e-06, 1.11023e-05, 1.29470e-05/
      DATA (KA_MN2O( 3,JT,16),JT=1,19)  /
     & 8.32666e-07, 9.71021e-07, 1.13237e-06, 1.32052e-06, 1.53994e-06,
     & 1.79581e-06, 2.09420e-06, 2.44217e-06, 2.84796e-06, 3.32117e-06,
     & 3.87302e-06, 4.51656e-06, 5.26703e-06, 6.14219e-06, 7.16277e-06,
     & 8.35294e-06, 9.74086e-06, 1.13594e-05, 1.32468e-05/
      DATA (KA_MN2O( 4,JT,16),JT=1,19)  /
     & 8.70348e-07, 1.01496e-06, 1.18360e-06, 1.38026e-06, 1.60959e-06,
     & 1.87703e-06, 2.18890e-06, 2.55259e-06, 2.97671e-06, 3.47130e-06,
     & 4.04807e-06, 4.72067e-06, 5.50502e-06, 6.41970e-06, 7.48635e-06,
     & 8.73023e-06, 1.01808e-05, 1.18724e-05, 1.38450e-05/
      DATA (KA_MN2O( 5,JT,16),JT=1,19)  /
     & 9.07957e-07, 1.05882e-06, 1.23475e-06, 1.43991e-06, 1.67916e-06,
     & 1.95816e-06, 2.28352e-06, 2.66294e-06, 3.10541e-06, 3.62139e-06,
     & 4.22310e-06, 4.92480e-06, 5.74308e-06, 6.69733e-06, 7.81013e-06,
     & 9.10784e-06, 1.06212e-05, 1.23859e-05, 1.44439e-05/
      DATA (KA_MN2O( 6,JT,16),JT=1,19)  /
     & 8.59072e-04, 9.19773e-04, 9.84764e-04, 1.05435e-03, 1.12885e-03,
     & 1.20861e-03, 1.29401e-03, 1.38544e-03, 1.48334e-03, 1.58815e-03,
     & 1.70037e-03, 1.82052e-03, 1.94915e-03, 2.08688e-03, 2.23434e-03,
     & 2.39222e-03, 2.56125e-03, 2.74223e-03, 2.93599e-03/
      DATA (KA_MN2O( 7,JT,16),JT=1,19)  /
     & 9.17294e-07, 1.06971e-06, 1.24746e-06, 1.45474e-06, 1.69646e-06,
     & 1.97835e-06, 2.30708e-06, 2.69043e-06, 3.13748e-06, 3.65880e-06,
     & 4.26676e-06, 4.97574e-06, 5.80251e-06, 6.76667e-06, 7.89104e-06,
     & 9.20223e-06, 1.07313e-05, 1.25144e-05, 1.45939e-05/
      DATA (KA_MN2O( 8,JT,16),JT=1,19)  /
     & 9.17341e-07, 1.06977e-06, 1.24752e-06, 1.45480e-06, 1.69653e-06,
     & 1.97843e-06, 2.30716e-06, 2.69051e-06, 3.13757e-06, 3.65890e-06,
     & 4.26686e-06, 4.97584e-06, 5.80261e-06, 6.76677e-06, 7.89113e-06,
     & 9.20231e-06, 1.07314e-05, 1.25145e-05, 1.45939e-05/
      DATA (KA_MN2O( 9,JT,16),JT=1,19)  /
     & 9.07957e-07, 1.05882e-06, 1.23475e-06, 1.43991e-06, 1.67916e-06,
     & 1.95816e-06, 2.28352e-06, 2.66294e-06, 3.10541e-06, 3.62139e-06,
     & 4.22310e-06, 4.92480e-06, 5.74308e-06, 6.69733e-06, 7.81013e-06,
     & 9.10784e-06, 1.06212e-05, 1.23859e-05, 1.44439e-05/

C     The array KB_Mxx contains the absorption coefficient for 
C     a minor species at the 16 chosen g-values for a reference pressure
C     level above 100~ mb.   The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amounts ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 to 
C     that of gas2.  The second index refers to temperature 
C     in 7.2 degree increments.  For instance, JT = 1 refers to a 
C     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
C     runs over the g-channel (1 to 16).

      DATA (KB_MN2O( 1,JT, 1),JT=1,19)  /
     & 7.72009e-08, 1.15883e-07, 1.73947e-07, 2.61104e-07, 3.91932e-07,
     & 5.88311e-07, 8.83088e-07, 1.32556e-06, 1.98975e-06, 2.98672e-06,
     & 4.48324e-06, 6.72960e-06, 1.01015e-05, 1.51629e-05, 2.27604e-05,
     & 3.41646e-05, 5.12831e-05, 7.69787e-05, 1.15549e-04/
      DATA (KB_MN2O( 2,JT, 1),JT=1,19)  /
     & 1.29932e-05, 1.78207e-05, 2.44419e-05, 3.35232e-05, 4.59786e-05,
     & 6.30617e-05, 8.64920e-05, 1.18628e-04, 1.62703e-04, 2.23155e-04,
     & 3.06067e-04, 4.19784e-04, 5.75753e-04, 7.89671e-04, 1.08307e-03,
     & 1.48548e-03, 2.03740e-03, 2.79439e-03, 3.83262e-03/
      DATA (KB_MN2O( 3,JT, 1),JT=1,19)  /
     & 6.44518e-05, 8.10996e-05, 1.02047e-04, 1.28406e-04, 1.61573e-04,
     & 2.03307e-04, 2.55821e-04, 3.21899e-04, 4.05045e-04, 5.09667e-04,
     & 6.41313e-04, 8.06964e-04, 1.01540e-03, 1.27768e-03, 1.60770e-03,
     & 2.02296e-03, 2.54549e-03, 3.20298e-03, 4.03031e-03/
      DATA (KB_MN2O( 4,JT, 1),JT=1,19)  /
     & 3.23454e-04, 3.82112e-04, 4.51408e-04, 5.33270e-04, 6.29978e-04,
     & 7.44223e-04, 8.79187e-04, 1.03863e-03, 1.22698e-03, 1.44949e-03,
     & 1.71235e-03, 2.02289e-03, 2.38974e-03, 2.82311e-03, 3.33508e-03,
     & 3.93989e-03, 4.65439e-03, 5.49845e-03, 6.49558e-03/
      DATA (KB_MN2O( 5,JT, 1),JT=1,19)  /
     & 1.45978e-04, 1.75646e-04, 2.11344e-04, 2.54296e-04, 3.05978e-04,
     & 3.68163e-04, 4.42986e-04, 5.33017e-04, 6.41344e-04, 7.71687e-04,
     & 9.28522e-04, 1.11723e-03, 1.34429e-03, 1.61750e-03, 1.94623e-03,
     & 2.34177e-03, 2.81770e-03, 3.39035e-03, 4.07939e-03/
      DATA (KB_MN2O( 1,JT, 2),JT=1,19)  /
     & 1.94527e-04, 2.38609e-04, 2.92680e-04, 3.59005e-04, 4.40360e-04,
     & 5.40150e-04, 6.62554e-04, 8.12697e-04, 9.96864e-04, 1.22276e-03,
     & 1.49986e-03, 1.83974e-03, 2.25665e-03, 2.76803e-03, 3.39530e-03,
     & 4.16472e-03, 5.10849e-03, 6.26613e-03, 7.68611e-03/
      DATA (KB_MN2O( 2,JT, 2),JT=1,19)  /
     & 7.49615e-04, 8.82716e-04, 1.03945e-03, 1.22401e-03, 1.44135e-03,
     & 1.69727e-03, 1.99863e-03, 2.35351e-03, 2.77139e-03, 3.26347e-03,
     & 3.84293e-03, 4.52528e-03, 5.32878e-03, 6.27495e-03, 7.38911e-03,
     & 8.70111e-03, 1.02461e-02, 1.20653e-02, 1.42076e-02/
      DATA (KB_MN2O( 3,JT, 2),JT=1,19)  /
     & 1.39162e-03, 1.59859e-03, 1.83634e-03, 2.10946e-03, 2.42319e-03,
     & 2.78358e-03, 3.19758e-03, 3.67314e-03, 4.21944e-03, 4.84698e-03,
     & 5.56786e-03, 6.39595e-03, 7.34720e-03, 8.43992e-03, 9.69516e-03,
     & 1.11371e-02, 1.27935e-02, 1.46962e-02, 1.68819e-02/
      DATA (KB_MN2O( 4,JT, 2),JT=1,19)  /
     & 2.42354e-03, 2.73623e-03, 3.08926e-03, 3.48783e-03, 3.93783e-03,
     & 4.44589e-03, 5.01950e-03, 5.66712e-03, 6.39829e-03, 7.22379e-03,
     & 8.15581e-03, 9.20807e-03, 1.03961e-02, 1.17374e-02, 1.32517e-02,
     & 1.49615e-02, 1.68918e-02, 1.90712e-02, 2.15318e-02/
      DATA (KB_MN2O( 5,JT, 2),JT=1,19)  /
     & 1.39908e-03, 1.59133e-03, 1.81000e-03, 2.05872e-03, 2.34161e-03,
     & 2.66338e-03, 3.02937e-03, 3.44564e-03, 3.91912e-03, 4.45766e-03,
     & 5.07021e-03, 5.76693e-03, 6.55938e-03, 7.46073e-03, 8.48594e-03,
     & 9.65202e-03, 1.09783e-02, 1.24869e-02, 1.42028e-02/
      DATA (KB_MN2O( 1,JT, 3),JT=1,19)  /
     & 8.74797e-03, 9.66828e-03, 1.06854e-02, 1.18095e-02, 1.30519e-02,
     & 1.44250e-02, 1.59426e-02, 1.76198e-02, 1.94735e-02, 2.15221e-02,
     & 2.37863e-02, 2.62887e-02, 2.90544e-02, 3.21110e-02, 3.54891e-02,
     & 3.92227e-02, 4.33491e-02, 4.79095e-02, 5.29497e-02/
      DATA (KB_MN2O( 2,JT, 3),JT=1,19)  /
     & 1.43974e-02, 1.56118e-02, 1.69286e-02, 1.83564e-02, 1.99047e-02,
     & 2.15836e-02, 2.34041e-02, 2.53781e-02, 2.75187e-02, 2.98397e-02,
     & 3.23566e-02, 3.50857e-02, 3.80451e-02, 4.12540e-02, 4.47336e-02,
     & 4.85067e-02, 5.25980e-02, 5.70344e-02, 6.18450e-02/
      DATA (KB_MN2O( 3,JT, 3),JT=1,19)  /
     & 1.83051e-02, 1.96851e-02, 2.11692e-02, 2.27651e-02, 2.44813e-02,
     & 2.63270e-02, 2.83117e-02, 3.04461e-02, 3.27414e-02, 3.52097e-02,
     & 3.78642e-02, 4.07187e-02, 4.37884e-02, 4.70896e-02, 5.06396e-02,
     & 5.44573e-02, 5.85628e-02, 6.29777e-02, 6.77256e-02/
      DATA (KB_MN2O( 4,JT, 3),JT=1,19)  /
     & 2.81258e-02, 2.97806e-02, 3.15328e-02, 3.33880e-02, 3.53524e-02,
     & 3.74324e-02, 3.96348e-02, 4.19667e-02, 4.44358e-02, 4.70502e-02,
     & 4.98185e-02, 5.27496e-02, 5.58531e-02, 5.91393e-02, 6.26187e-02,
     & 6.63030e-02, 7.02039e-02, 7.43344e-02, 7.87079e-02/
      DATA (KB_MN2O( 5,JT, 3),JT=1,19)  /
     & 8.82958e-03, 9.53842e-03, 1.03042e-02, 1.11314e-02, 1.20250e-02,
     & 1.29904e-02, 1.40333e-02, 1.51599e-02, 1.63769e-02, 1.76917e-02,
     & 1.91120e-02, 2.06463e-02, 2.23038e-02, 2.40944e-02, 2.60287e-02,
     & 2.81183e-02, 3.03757e-02, 3.28142e-02, 3.54486e-02/
      DATA (KB_MN2O( 1,JT, 4),JT=1,19)  /
     & 1.18673e-01, 1.22983e-01, 1.27449e-01, 1.32077e-01, 1.36874e-01,
     & 1.41845e-01, 1.46996e-01, 1.52334e-01, 1.57866e-01, 1.63599e-01,
     & 1.69541e-01, 1.75698e-01, 1.82078e-01, 1.88691e-01, 1.95543e-01,
     & 2.02645e-01, 2.10004e-01, 2.17631e-01, 2.25534e-01/
      DATA (KB_MN2O( 2,JT, 4),JT=1,19)  /
     & 1.32161e-01, 1.36550e-01, 1.41084e-01, 1.45769e-01, 1.50610e-01,
     & 1.55611e-01, 1.60779e-01, 1.66118e-01, 1.71634e-01, 1.77334e-01,
     & 1.83223e-01, 1.89307e-01, 1.95594e-01, 2.02089e-01, 2.08800e-01,
     & 2.15734e-01, 2.22898e-01, 2.30300e-01, 2.37947e-01/
      DATA (KB_MN2O( 3,JT, 4),JT=1,19)  /
     & 1.44384e-01, 1.48820e-01, 1.53392e-01, 1.58104e-01, 1.62962e-01,
     & 1.67968e-01, 1.73128e-01, 1.78447e-01, 1.83929e-01, 1.89580e-01,
     & 1.95404e-01, 2.01407e-01, 2.07594e-01, 2.13972e-01, 2.20546e-01,
     & 2.27321e-01, 2.34305e-01, 2.41503e-01, 2.48922e-01/
      DATA (KB_MN2O( 4,JT, 4),JT=1,19)  /
     & 1.58026e-01, 1.62626e-01, 1.67360e-01, 1.72232e-01, 1.77245e-01,
     & 1.82405e-01, 1.87714e-01, 1.93179e-01, 1.98802e-01, 2.04589e-01,
     & 2.10544e-01, 2.16673e-01, 2.22980e-01, 2.29471e-01, 2.36151e-01,
     & 2.43025e-01, 2.50100e-01, 2.57380e-01, 2.64872e-01/
      DATA (KB_MN2O( 5,JT, 4),JT=1,19)  /
     & 4.04885e-02, 4.16064e-02, 4.27551e-02, 4.39355e-02, 4.51485e-02,
     & 4.63950e-02, 4.76759e-02, 4.89921e-02, 5.03448e-02, 5.17347e-02,
     & 5.31630e-02, 5.46308e-02, 5.61391e-02, 5.76890e-02, 5.92817e-02,
     & 6.09184e-02, 6.26003e-02, 6.43286e-02, 6.61047e-02/
      DATA (KB_MN2O( 1,JT, 5),JT=1,19)  /
     & 3.97757e-01, 4.01082e-01, 4.04434e-01, 4.07814e-01, 4.11223e-01,
     & 4.14659e-01, 4.18125e-01, 4.21620e-01, 4.25144e-01, 4.28697e-01,
     & 4.32280e-01, 4.35893e-01, 4.39536e-01, 4.43209e-01, 4.46913e-01,
     & 4.50649e-01, 4.54415e-01, 4.58213e-01, 4.62043e-01/
      DATA (KB_MN2O( 2,JT, 5),JT=1,19)  /
     & 3.99425e-01, 4.02035e-01, 4.04662e-01, 4.07306e-01, 4.09968e-01,
     & 4.12647e-01, 4.15343e-01, 4.18057e-01, 4.20789e-01, 4.23539e-01,
     & 4.26307e-01, 4.29092e-01, 4.31896e-01, 4.34719e-01, 4.37559e-01,
     & 4.40419e-01, 4.43296e-01, 4.46193e-01, 4.49109e-01/
      DATA (KB_MN2O( 3,JT, 5),JT=1,19)  /
     & 4.00527e-01, 4.02848e-01, 4.05182e-01, 4.07530e-01, 4.09892e-01,
     & 4.12267e-01, 4.14656e-01, 4.17058e-01, 4.19475e-01, 4.21906e-01,
     & 4.24351e-01, 4.26809e-01, 4.29283e-01, 4.31770e-01, 4.34272e-01,
     & 4.36788e-01, 4.39319e-01, 4.41865e-01, 4.44426e-01/
      DATA (KB_MN2O( 4,JT, 5),JT=1,19)  /
     & 4.11455e-01, 4.13077e-01, 4.14705e-01, 4.16340e-01, 4.17981e-01,
     & 4.19629e-01, 4.21283e-01, 4.22944e-01, 4.24611e-01, 4.26285e-01,
     & 4.27966e-01, 4.29653e-01, 4.31346e-01, 4.33047e-01, 4.34754e-01,
     & 4.36468e-01, 4.38188e-01, 4.39916e-01, 4.41650e-01/
      DATA (KB_MN2O( 5,JT, 5),JT=1,19)  /
     & 8.65576e-02, 8.83622e-02, 9.02044e-02, 9.20850e-02, 9.40049e-02,
     & 9.59647e-02, 9.79655e-02, 1.00008e-01, 1.02093e-01, 1.04221e-01,
     & 1.06394e-01, 1.08612e-01, 1.10877e-01, 1.13188e-01, 1.15548e-01,
     & 1.17957e-01, 1.20417e-01, 1.22927e-01, 1.25490e-01/
      DATA (KB_MN2O( 1,JT, 6),JT=1,19)  /
     & 6.98675e-01, 7.00999e-01, 7.03331e-01, 7.05671e-01, 7.08019e-01,
     & 7.10375e-01, 7.12738e-01, 7.15110e-01, 7.17489e-01, 7.19876e-01,
     & 7.22271e-01, 7.24674e-01, 7.27085e-01, 7.29504e-01, 7.31931e-01,
     & 7.34366e-01, 7.36809e-01, 7.39261e-01, 7.41720e-01/
      DATA (KB_MN2O( 2,JT, 6),JT=1,19)  /
     & 6.98858e-01, 7.01424e-01, 7.03999e-01, 7.06583e-01, 7.09177e-01,
     & 7.11780e-01, 7.14393e-01, 7.17016e-01, 7.19648e-01, 7.22289e-01,
     & 7.24941e-01, 7.27602e-01, 7.30273e-01, 7.32954e-01, 7.35644e-01,
     & 7.38345e-01, 7.41055e-01, 7.43775e-01, 7.46506e-01/
      DATA (KB_MN2O( 3,JT, 6),JT=1,19)  /
     & 7.08151e-01, 7.10727e-01, 7.13311e-01, 7.15905e-01, 7.18508e-01,
     & 7.21121e-01, 7.23743e-01, 7.26375e-01, 7.29017e-01, 7.31668e-01,
     & 7.34329e-01, 7.36999e-01, 7.39679e-01, 7.42369e-01, 7.45068e-01,
     & 7.47778e-01, 7.50497e-01, 7.53226e-01, 7.55965e-01/
      DATA (KB_MN2O( 4,JT, 6),JT=1,19)  /
     & 7.22269e-01, 7.24981e-01, 7.27704e-01, 7.30437e-01, 7.33180e-01,
     & 7.35933e-01, 7.38697e-01, 7.41471e-01, 7.44256e-01, 7.47051e-01,
     & 7.49856e-01, 7.52672e-01, 7.55499e-01, 7.58336e-01, 7.61184e-01,
     & 7.64043e-01, 7.66912e-01, 7.69792e-01, 7.72683e-01/
      DATA (KB_MN2O( 5,JT, 6),JT=1,19)  /
     & 1.75877e-01, 1.78578e-01, 1.81321e-01, 1.84107e-01, 1.86935e-01,
     & 1.89806e-01, 1.92722e-01, 1.95682e-01, 1.98688e-01, 2.01740e-01,
     & 2.04839e-01, 2.07986e-01, 2.11181e-01, 2.14425e-01, 2.17719e-01,
     & 2.21063e-01, 2.24459e-01, 2.27907e-01, 2.31408e-01/
      DATA (KB_MN2O( 1,JT, 7),JT=1,19)  /
     & 1.82985e+00, 1.83684e+00, 1.84386e+00, 1.85091e+00, 1.85798e+00,
     & 1.86508e+00, 1.87221e+00, 1.87937e+00, 1.88655e+00, 1.89376e+00,
     & 1.90100e+00, 1.90827e+00, 1.91556e+00, 1.92288e+00, 1.93023e+00,
     & 1.93761e+00, 1.94502e+00, 1.95245e+00, 1.95991e+00/
      DATA (KB_MN2O( 2,JT, 7),JT=1,19)  /
     & 1.83229e+00, 1.83943e+00, 1.84659e+00, 1.85379e+00, 1.86100e+00,
     & 1.86825e+00, 1.87553e+00, 1.88283e+00, 1.89016e+00, 1.89753e+00,
     & 1.90492e+00, 1.91233e+00, 1.91978e+00, 1.92726e+00, 1.93476e+00,
     & 1.94230e+00, 1.94986e+00, 1.95746e+00, 1.96508e+00/
      DATA (KB_MN2O( 3,JT, 7),JT=1,19)  /
     & 1.84946e+00, 1.85707e+00, 1.86471e+00, 1.87238e+00, 1.88008e+00,
     & 1.88781e+00, 1.89558e+00, 1.90338e+00, 1.91120e+00, 1.91907e+00,
     & 1.92696e+00, 1.93489e+00, 1.94285e+00, 1.95084e+00, 1.95886e+00,
     & 1.96692e+00, 1.97501e+00, 1.98313e+00, 1.99129e+00/
      DATA (KB_MN2O( 4,JT, 7),JT=1,19)  /
     & 1.88354e+00, 1.89167e+00, 1.89983e+00, 1.90803e+00, 1.91626e+00,
     & 1.92453e+00, 1.93283e+00, 1.94117e+00, 1.94955e+00, 1.95796e+00,
     & 1.96641e+00, 1.97489e+00, 1.98341e+00, 1.99197e+00, 2.00056e+00,
     & 2.00920e+00, 2.01787e+00, 2.02657e+00, 2.03532e+00/
      DATA (KB_MN2O( 5,JT, 7),JT=1,19)  /
     & 3.35154e-01, 3.43258e-01, 3.51557e-01, 3.60058e-01, 3.68764e-01,
     & 3.77680e-01, 3.86812e-01, 3.96164e-01, 4.05743e-01, 4.15553e-01,
     & 4.25601e-01, 4.35892e-01, 4.46431e-01, 4.57225e-01, 4.68280e-01,
     & 4.79603e-01, 4.91199e-01, 5.03075e-01, 5.15239e-01/
      DATA (KB_MN2O( 1,JT, 8),JT=1,19)  /
     & 4.46843e+00, 4.49793e+00, 4.52763e+00, 4.55752e+00, 4.58761e+00,
     & 4.61790e+00, 4.64839e+00, 4.67908e+00, 4.70997e+00, 4.74106e+00,
     & 4.77236e+00, 4.80387e+00, 4.83559e+00, 4.86751e+00, 4.89965e+00,
     & 4.93200e+00, 4.96456e+00, 4.99733e+00, 5.03033e+00/
      DATA (KB_MN2O( 2,JT, 8),JT=1,19)  /
     & 4.44347e+00, 4.47278e+00, 4.50228e+00, 4.53198e+00, 4.56188e+00,
     & 4.59197e+00, 4.62227e+00, 4.65276e+00, 4.68345e+00, 4.71435e+00,
     & 4.74544e+00, 4.77675e+00, 4.80826e+00, 4.83998e+00, 4.87191e+00,
     & 4.90405e+00, 4.93640e+00, 4.96896e+00, 5.00174e+00/
      DATA (KB_MN2O( 3,JT, 8),JT=1,19)  /
     & 4.43138e+00, 4.46017e+00, 4.48916e+00, 4.51834e+00, 4.54770e+00,
     & 4.57725e+00, 4.60700e+00, 4.63694e+00, 4.66708e+00, 4.69741e+00,
     & 4.72793e+00, 4.75866e+00, 4.78958e+00, 4.82071e+00, 4.85204e+00,
     & 4.88357e+00, 4.91531e+00, 4.94725e+00, 4.97941e+00/
      DATA (KB_MN2O( 4,JT, 8),JT=1,19)  /
     & 4.47437e+00, 4.50396e+00, 4.53375e+00, 4.56374e+00, 4.59392e+00,
     & 4.62431e+00, 4.65490e+00, 4.68569e+00, 4.71668e+00, 4.74788e+00,
     & 4.77928e+00, 4.81089e+00, 4.84271e+00, 4.87474e+00, 4.90698e+00,
     & 4.93944e+00, 4.97211e+00, 5.00500e+00, 5.03810e+00/
      DATA (KB_MN2O( 5,JT, 8),JT=1,19)  /
     & 8.82838e-01, 8.92257e-01, 9.01777e-01, 9.11398e-01, 9.21122e-01,
     & 9.30950e-01, 9.40883e-01, 9.50921e-01, 9.61067e-01, 9.71321e-01,
     & 9.81685e-01, 9.92159e-01, 1.00274e+00, 1.01344e+00, 1.02426e+00,
     & 1.03518e+00, 1.04623e+00, 1.05739e+00, 1.06867e+00/
      DATA (KB_MN2O( 1,JT, 9),JT=1,19)  /
     & 7.92826e+00, 7.83168e+00, 7.73628e+00, 7.64204e+00, 7.54895e+00,
     & 7.45699e+00, 7.36616e+00, 7.27643e+00, 7.18779e+00, 7.10023e+00,
     & 7.01374e+00, 6.92831e+00, 6.84391e+00, 6.76054e+00, 6.67819e+00,
     & 6.59684e+00, 6.51648e+00, 6.43710e+00, 6.35869e+00/
      DATA (KB_MN2O( 2,JT, 9),JT=1,19)  /
     & 7.89244e+00, 7.79570e+00, 7.70014e+00, 7.60576e+00, 7.51253e+00,
     & 7.42045e+00, 7.32949e+00, 7.23965e+00, 7.15091e+00, 7.06325e+00,
     & 6.97668e+00, 6.89116e+00, 6.80669e+00, 6.72326e+00, 6.64085e+00,
     & 6.55945e+00, 6.47904e+00, 6.39963e+00, 6.32118e+00/
      DATA (KB_MN2O( 3,JT, 9),JT=1,19)  /
     & 7.79799e+00, 7.70076e+00, 7.60474e+00, 7.50991e+00, 7.41627e+00,
     & 7.32379e+00, 7.23247e+00, 7.14229e+00, 7.05323e+00, 6.96528e+00,
     & 6.87843e+00, 6.79266e+00, 6.70797e+00, 6.62432e+00, 6.54172e+00,
     & 6.46015e+00, 6.37960e+00, 6.30005e+00, 6.22150e+00/
      DATA (KB_MN2O( 4,JT, 9),JT=1,19)  /
     & 7.53750e+00, 7.43715e+00, 7.33814e+00, 7.24045e+00, 7.14406e+00,
     & 7.04895e+00, 6.95510e+00, 6.86251e+00, 6.77115e+00, 6.68101e+00,
     & 6.59206e+00, 6.50430e+00, 6.41771e+00, 6.33227e+00, 6.24797e+00,
     & 6.16479e+00, 6.08272e+00, 6.00174e+00, 5.92184e+00/
      DATA (KB_MN2O( 5,JT, 9),JT=1,19)  /
     & 5.06319e+00, 5.08595e+00, 5.10881e+00, 5.13177e+00, 5.15483e+00,
     & 5.17800e+00, 5.20127e+00, 5.22464e+00, 5.24813e+00, 5.27171e+00,
     & 5.29540e+00, 5.31920e+00, 5.34311e+00, 5.36712e+00, 5.39124e+00,
     & 5.41547e+00, 5.43981e+00, 5.46426e+00, 5.48882e+00/
      DATA (KB_MN2O( 1,JT,10),JT=1,19)  /
     & 1.05265e+00, 1.03986e+00, 1.02723e+00, 1.01475e+00, 1.00243e+00,
     & 9.90250e-01, 9.78220e-01, 9.66338e-01, 9.54599e-01, 9.43003e-01,
     & 9.31548e-01, 9.20232e-01, 9.09054e-01, 8.98011e-01, 8.87102e-01,
     & 8.76326e-01, 8.65681e-01, 8.55165e-01, 8.44777e-01/
      DATA (KB_MN2O( 2,JT,10),JT=1,19)  /
     & 1.05246e+00, 1.03973e+00, 1.02714e+00, 1.01471e+00, 1.00243e+00,
     & 9.90303e-01, 9.78319e-01, 9.66480e-01, 9.54784e-01, 9.43230e-01,
     & 9.31815e-01, 9.20539e-01, 9.09399e-01, 8.98394e-01, 8.87522e-01,
     & 8.76782e-01, 8.66171e-01, 8.55690e-01, 8.45335e-01/
      DATA (KB_MN2O( 3,JT,10),JT=1,19)  /
     & 1.05236e+00, 1.03963e+00, 1.02704e+00, 1.01461e+00, 1.00233e+00,
     & 9.90203e-01, 9.78219e-01, 9.66380e-01, 9.54684e-01, 9.43130e-01,
     & 9.31715e-01, 9.20439e-01, 9.09300e-01, 8.98295e-01, 8.87423e-01,
     & 8.76683e-01, 8.66073e-01, 8.55591e-01, 8.45236e-01/
      DATA (KB_MN2O( 4,JT,10),JT=1,19)  /
     & 9.30836e-01, 9.21099e-01, 9.11464e-01, 9.01930e-01, 8.92495e-01,
     & 8.83159e-01, 8.73921e-01, 8.64779e-01, 8.55733e-01, 8.46781e-01,
     & 8.37923e-01, 8.29158e-01, 8.20485e-01, 8.11902e-01, 8.03409e-01,
     & 7.95005e-01, 7.86689e-01, 7.78460e-01, 7.70316e-01/
      DATA (KB_MN2O( 5,JT,10),JT=1,19)  /
     & 1.65786e+01, 1.66541e+01, 1.67299e+01, 1.68062e+01, 1.68827e+01,
     & 1.69596e+01, 1.70369e+01, 1.71145e+01, 1.71925e+01, 1.72708e+01,
     & 1.73495e+01, 1.74285e+01, 1.75079e+01, 1.75877e+01, 1.76678e+01,
     & 1.77483e+01, 1.78291e+01, 1.79103e+01, 1.79919e+01/
      DATA (KB_MN2O( 1,JT,11),JT=1,19)  /
     & 1.74239e-01, 1.77873e-01, 1.81583e-01, 1.85370e-01, 1.89236e-01,
     & 1.93182e-01, 1.97211e-01, 2.01324e-01, 2.05523e-01, 2.09809e-01,
     & 2.14185e-01, 2.18652e-01, 2.23212e-01, 2.27867e-01, 2.32620e-01,
     & 2.37471e-01, 2.42424e-01, 2.47479e-01, 2.52641e-01/
      DATA (KB_MN2O( 2,JT,11),JT=1,19)  /
     & 1.74114e-01, 1.77756e-01, 1.81475e-01, 1.85271e-01, 1.89147e-01,
     & 1.93104e-01, 1.97144e-01, 2.01268e-01, 2.05479e-01, 2.09778e-01,
     & 2.14166e-01, 2.18647e-01, 2.23221e-01, 2.27890e-01, 2.32658e-01,
     & 2.37525e-01, 2.42494e-01, 2.47567e-01, 2.52746e-01/
      DATA (KB_MN2O( 3,JT,11),JT=1,19)  /
     & 1.74142e-01, 1.77780e-01, 1.81494e-01, 1.85286e-01, 1.89157e-01,
     & 1.93108e-01, 1.97143e-01, 2.01261e-01, 2.05466e-01, 2.09759e-01,
     & 2.14141e-01, 2.18615e-01, 2.23182e-01, 2.27845e-01, 2.32605e-01,
     & 2.37464e-01, 2.42425e-01, 2.47490e-01, 2.52661e-01/
      DATA (KB_MN2O( 4,JT,11),JT=1,19)  /
     & 1.74074e-01, 1.77716e-01, 1.81435e-01, 1.85231e-01, 1.89107e-01,
     & 1.93064e-01, 1.97104e-01, 2.01229e-01, 2.05439e-01, 2.09738e-01,
     & 2.14127e-01, 2.18607e-01, 2.23181e-01, 2.27852e-01, 2.32619e-01,
     & 2.37487e-01, 2.42456e-01, 2.47529e-01, 2.52709e-01/
      DATA (KB_MN2O( 5,JT,11),JT=1,19)  /
     & 2.31905e+01, 2.33011e+01, 2.34123e+01, 2.35240e+01, 2.36362e+01,
     & 2.37489e+01, 2.38622e+01, 2.39760e+01, 2.40904e+01, 2.42053e+01,
     & 2.43208e+01, 2.44368e+01, 2.45533e+01, 2.46705e+01, 2.47881e+01,
     & 2.49064e+01, 2.50252e+01, 2.51446e+01, 2.52645e+01/
      DATA (KB_MN2O( 1,JT,12),JT=1,19)  /
     & 1.60269e-01, 1.62873e-01, 1.65519e-01, 1.68208e-01, 1.70940e-01,
     & 1.73717e-01, 1.76540e-01, 1.79408e-01, 1.82322e-01, 1.85284e-01,
     & 1.88295e-01, 1.91354e-01, 1.94462e-01, 1.97622e-01, 2.00832e-01,
     & 2.04095e-01, 2.07411e-01, 2.10780e-01, 2.14205e-01/
      DATA (KB_MN2O( 2,JT,12),JT=1,19)  /
     & 1.60497e-01, 1.63096e-01, 1.65738e-01, 1.68422e-01, 1.71150e-01,
     & 1.73922e-01, 1.76738e-01, 1.79601e-01, 1.82510e-01, 1.85466e-01,
     & 1.88469e-01, 1.91522e-01, 1.94624e-01, 1.97776e-01, 2.00979e-01,
     & 2.04234e-01, 2.07542e-01, 2.10903e-01, 2.14319e-01/
      DATA (KB_MN2O( 3,JT,12),JT=1,19)  /
     & 1.60407e-01, 1.63006e-01, 1.65648e-01, 1.68332e-01, 1.71060e-01,
     & 1.73832e-01, 1.76649e-01, 1.79511e-01, 1.82420e-01, 1.85376e-01,
     & 1.88380e-01, 1.91433e-01, 1.94535e-01, 1.97687e-01, 2.00891e-01,
     & 2.04146e-01, 2.07454e-01, 2.10816e-01, 2.14232e-01/
      DATA (KB_MN2O( 4,JT,12),JT=1,19)  /
     & 1.60475e-01, 1.63070e-01, 1.65706e-01, 1.68386e-01, 1.71109e-01,
     & 1.73876e-01, 1.76687e-01, 1.79544e-01, 1.82448e-01, 1.85398e-01,
     & 1.88396e-01, 1.91442e-01, 1.94538e-01, 1.97684e-01, 2.00881e-01,
     & 2.04129e-01, 2.07430e-01, 2.10784e-01, 2.14192e-01/
      DATA (KB_MN2O( 5,JT,12),JT=1,19)  /
     & 3.25743e+01, 3.27992e+01, 3.30256e+01, 3.32536e+01, 3.34832e+01,
     & 3.37143e+01, 3.39471e+01, 3.41815e+01, 3.44174e+01, 3.46550e+01,
     & 3.48943e+01, 3.51352e+01, 3.53778e+01, 3.56220e+01, 3.58679e+01,
     & 3.61156e+01, 3.63649e+01, 3.66159e+01, 3.68687e+01/
      DATA (KB_MN2O( 1,JT,13),JT=1,19)  /
     & 2.01846e-01, 2.03110e-01, 2.04381e-01, 2.05660e-01, 2.06947e-01,
     & 2.08242e-01, 2.09546e-01, 2.10857e-01, 2.12177e-01, 2.13505e-01,
     & 2.14841e-01, 2.16186e-01, 2.17539e-01, 2.18900e-01, 2.20270e-01,
     & 2.21649e-01, 2.23036e-01, 2.24432e-01, 2.25837e-01/
      DATA (KB_MN2O( 2,JT,13),JT=1,19)  /
     & 2.01756e-01, 2.03020e-01, 2.04291e-01, 2.05570e-01, 2.06857e-01,
     & 2.08152e-01, 2.09456e-01, 2.10767e-01, 2.12087e-01, 2.13415e-01,
     & 2.14751e-01, 2.16096e-01, 2.17449e-01, 2.18810e-01, 2.20181e-01,
     & 2.21559e-01, 2.22946e-01, 2.24342e-01, 2.25747e-01/
      DATA (KB_MN2O( 3,JT,13),JT=1,19)  /
     & 2.01836e-01, 2.03100e-01, 2.04371e-01, 2.05650e-01, 2.06937e-01,
     & 2.08232e-01, 2.09536e-01, 2.10847e-01, 2.12167e-01, 2.13495e-01,
     & 2.14831e-01, 2.16176e-01, 2.17529e-01, 2.18890e-01, 2.20260e-01,
     & 2.21639e-01, 2.23026e-01, 2.24422e-01, 2.25827e-01/
      DATA (KB_MN2O( 4,JT,13),JT=1,19)  /
     & 2.01845e-01, 2.03103e-01, 2.04370e-01, 2.05644e-01, 2.06926e-01,
     & 2.08217e-01, 2.09515e-01, 2.10822e-01, 2.12136e-01, 2.13459e-01,
     & 2.14790e-01, 2.16129e-01, 2.17477e-01, 2.18833e-01, 2.20198e-01,
     & 2.21571e-01, 2.22952e-01, 2.24343e-01, 2.25741e-01/
      DATA (KB_MN2O( 5,JT,13),JT=1,19)  /
     & 5.34154e+01, 5.31954e+01, 5.29763e+01, 5.27582e+01, 5.25409e+01,
     & 5.23245e+01, 5.21090e+01, 5.18943e+01, 5.16806e+01, 5.14677e+01,
     & 5.12558e+01, 5.10446e+01, 5.08344e+01, 5.06250e+01, 5.04165e+01,
     & 5.02089e+01, 5.00021e+01, 4.97961e+01, 4.95910e+01/
      DATA (KB_MN2O( 1,JT,14),JT=1,19)  /
     & 2.87818e-02, 3.17868e-02, 3.51056e-02, 3.87708e-02, 4.28187e-02,
     & 4.72893e-02, 5.22266e-02, 5.76794e-02, 6.37015e-02, 7.03523e-02,
     & 7.76976e-02, 8.58097e-02, 9.47688e-02, 1.04663e-01, 1.15591e-01,
     & 1.27659e-01, 1.40988e-01, 1.55708e-01, 1.71965e-01/
      DATA (KB_MN2O( 2,JT,14),JT=1,19)  /
     & 2.88500e-02, 3.18494e-02, 3.51606e-02, 3.88161e-02, 4.28517e-02,
     & 4.73068e-02, 5.22251e-02, 5.76547e-02, 6.36488e-02, 7.02661e-02,
     & 7.75714e-02, 8.56362e-02, 9.45395e-02, 1.04368e-01, 1.15219e-01,
     & 1.27198e-01, 1.40422e-01, 1.55021e-01, 1.71138e-01/
      DATA (KB_MN2O( 3,JT,14),JT=1,19)  /
     & 2.88036e-02, 3.18109e-02, 3.51322e-02, 3.88002e-02, 4.28512e-02,
     & 4.73252e-02, 5.22663e-02, 5.77232e-02, 6.37499e-02, 7.04058e-02,
     & 7.77567e-02, 8.58751e-02, 9.48410e-02, 1.04743e-01, 1.15679e-01,
     & 1.27757e-01, 1.41095e-01, 1.55827e-01, 1.72096e-01/
      DATA (KB_MN2O( 4,JT,14),JT=1,19)  /
     & 2.87750e-02, 3.17783e-02, 3.50951e-02, 3.87580e-02, 4.28033e-02,
     & 4.72708e-02, 5.22046e-02, 5.76533e-02, 6.36707e-02, 7.03162e-02,
     & 7.76553e-02, 8.57604e-02, 9.47114e-02, 1.04597e-01, 1.15514e-01,
     & 1.27570e-01, 1.40885e-01, 1.55589e-01, 1.71829e-01/
      DATA (KB_MN2O( 5,JT,14),JT=1,19)  /
     & 1.11848e+02, 1.09489e+02, 1.07179e+02, 1.04918e+02, 1.02705e+02,
     & 1.00538e+02, 9.84175e+01, 9.63414e+01, 9.43091e+01, 9.23196e+01,
     & 9.03722e+01, 8.84658e+01, 8.65996e+01, 8.47728e+01, 8.29845e+01,
     & 8.12339e+01, 7.95203e+01, 7.78428e+01, 7.62007e+01/
      DATA (KB_MN2O( 1,JT,15),JT=1,19)  /
     & 1.52234e-02, 1.69256e-02, 1.88181e-02, 2.09222e-02, 2.32617e-02,
     & 2.58626e-02, 2.87545e-02, 3.19696e-02, 3.55443e-02, 3.95187e-02,
     & 4.39374e-02, 4.88503e-02, 5.43124e-02, 6.03854e-02, 6.71373e-02,
     & 7.46443e-02, 8.29906e-02, 9.22701e-02, 1.02587e-01/
      DATA (KB_MN2O( 2,JT,15),JT=1,19)  /
     & 1.52234e-02, 1.69256e-02, 1.88181e-02, 2.09222e-02, 2.32617e-02,
     & 2.58626e-02, 2.87545e-02, 3.19696e-02, 3.55443e-02, 3.95187e-02,
     & 4.39374e-02, 4.88503e-02, 5.43124e-02, 6.03854e-02, 6.71373e-02,
     & 7.46443e-02, 8.29906e-02, 9.22701e-02, 1.02587e-01/
      DATA (KB_MN2O( 3,JT,15),JT=1,19)  /
     & 1.52076e-02, 1.69049e-02, 1.87916e-02, 2.08890e-02, 2.32203e-02,
     & 2.58119e-02, 2.86928e-02, 3.18951e-02, 3.54549e-02, 3.94120e-02,
     & 4.38107e-02, 4.87003e-02, 5.41357e-02, 6.01777e-02, 6.68940e-02,
     & 7.43600e-02, 8.26593e-02, 9.18847e-02, 1.02140e-01/
      DATA (KB_MN2O( 4,JT,15),JT=1,19)  /
     & 1.52422e-02, 1.69488e-02, 1.88464e-02, 2.09565e-02, 2.33028e-02,
     & 2.59118e-02, 2.88129e-02, 3.20389e-02, 3.56260e-02, 3.96148e-02,
     & 4.40501e-02, 4.89821e-02, 5.44662e-02, 6.05643e-02, 6.73452e-02,
     & 7.48853e-02, 8.32696e-02, 9.25927e-02, 1.02959e-01/
      DATA (KB_MN2O( 5,JT,15),JT=1,19)  /
     & 6.94782e+01, 6.73469e+01, 6.52810e+01, 6.32785e+01, 6.13373e+01,
     & 5.94558e+01, 5.76319e+01, 5.58640e+01, 5.41503e+01, 5.24892e+01,
     & 5.08791e+01, 4.93183e+01, 4.78055e+01, 4.63390e+01, 4.49175e+01,
     & 4.35396e+01, 4.22040e+01, 4.09094e+01, 3.96544e+01/
      DATA (KB_MN2O( 1,JT,16),JT=1,19)  /
     & 1.08257e-02, 1.15188e-02, 1.22563e-02, 1.30410e-02, 1.38759e-02,
     & 1.47643e-02, 1.57096e-02, 1.67154e-02, 1.77857e-02, 1.89244e-02,
     & 2.01360e-02, 2.14252e-02, 2.27970e-02, 2.42565e-02, 2.58096e-02,
     & 2.74620e-02, 2.92203e-02, 3.10911e-02, 3.30817e-02/
      DATA (KB_MN2O( 2,JT,16),JT=1,19)  /
     & 1.08257e-02, 1.15188e-02, 1.22563e-02, 1.30410e-02, 1.38759e-02,
     & 1.47643e-02, 1.57096e-02, 1.67154e-02, 1.77857e-02, 1.89244e-02,
     & 2.01360e-02, 2.14252e-02, 2.27970e-02, 2.42565e-02, 2.58096e-02,
     & 2.74620e-02, 2.92203e-02, 3.10911e-02, 3.30817e-02/
      DATA (KB_MN2O( 3,JT,16),JT=1,19)  /
     & 1.08257e-02, 1.15188e-02, 1.22563e-02, 1.30410e-02, 1.38759e-02,
     & 1.47643e-02, 1.57096e-02, 1.67154e-02, 1.77857e-02, 1.89244e-02,
     & 2.01360e-02, 2.14252e-02, 2.27970e-02, 2.42565e-02, 2.58096e-02,
     & 2.74620e-02, 2.92203e-02, 3.10911e-02, 3.30817e-02/
      DATA (KB_MN2O( 4,JT,16),JT=1,19)  /
     & 1.08263e-02, 1.15191e-02, 1.22562e-02, 1.30404e-02, 1.38749e-02,
     & 1.47627e-02, 1.57073e-02, 1.67124e-02, 1.77818e-02, 1.89196e-02,
     & 2.01302e-02, 2.14183e-02, 2.27888e-02, 2.42470e-02, 2.57986e-02,
     & 2.74494e-02, 2.92058e-02, 3.10746e-02, 3.30630e-02/
      DATA (KB_MN2O( 5,JT,16),JT=1,19)  /
     & 4.53450e-08, 5.75193e-08, 7.29620e-08, 9.25509e-08, 1.17399e-07,
     & 1.48918e-07, 1.88900e-07, 2.39616e-07, 3.03948e-07, 3.85551e-07,
     & 4.89064e-07, 6.20369e-07, 7.86925e-07, 9.98199e-07, 1.26619e-06,
     & 1.60614e-06, 2.03736e-06, 2.58435e-06, 3.27819e-06/

C     The array FORREF contains the coefficient of the water vapor
C     foreign-continuum (including the energy term).  The first 
C     index refers to reference temperature (296,260,224,260) and 
C     pressure (970,475,219,3 mbar) levels.  The second index 
C     runs over the g-channel (1 to 16).

      DATA (FORREF(1,IG),IG=1,16) /
     &9.0039e-04,1.1081e-03,1.0732e-03,1.1881e-03,1.2488e-03,1.3170e-03,
     &1.3317e-03,1.3168e-03,1.3369e-03,1.4228e-03,1.5385e-03,1.7376e-03,
     &1.7122e-03,1.9002e-03,1.8881e-03,2.1595e-03/
      DATA (FORREF(2,IG),IG=1,16) /
     &1.2726e-03,1.3680e-03,1.2494e-03,1.2049e-03,1.2048e-03,1.1256e-03,
     &1.1170e-03,1.0697e-03,1.1177e-03,1.1883e-03,1.2219e-03,1.2179e-03,
     &1.5692e-03,1.9103e-03,2.0219e-03,1.6937e-03/
      DATA (FORREF(3,IG),IG=1,16) /
     &1.5527e-03,1.6477e-03,1.4973e-03,1.3400e-03,1.0820e-03,9.3315e-04,
     &8.8132e-04,8.1508e-04,8.3559e-04,7.6492e-04,8.2343e-04,7.1274e-04,
     &6.6011e-04,6.7179e-04,6.7039e-04,6.7021e-04/
      DATA (FORREF(4,IG),IG=1,16) /
     &1.6763e-03,1.6066e-03,1.3927e-03,1.2087e-03,9.8463e-04,8.8414e-04,
     &8.0976e-04,7.8758e-04,7.7376e-04,7.5785e-04,7.4152e-04,7.3814e-04,
     &7.4278e-04,7.1745e-04,6.7216e-04,6.4097e-04/

C     The array SELFREF contains the coefficient of the water vapor
C     self-continuum (including the energy term).  The first index
C     refers to temperature in 7.2 degree increments.  For instance,
C     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
C     etc.  The second index runs over the g-channel (1 to 16).

      DATA (SELFREF(JT, 1),JT=1,10)  /
     & 5.11926e-01, 4.32863e-01, 3.66010e-01, 3.09482e-01, 2.61685e-01,
     & 2.21269e-01, 1.87096e-01, 1.58200e-01, 1.33767e-01, 1.13108e-01/
      DATA (SELFREF(JT, 2),JT=1,10)  /
     & 5.02863e-01, 4.35008e-01, 3.76310e-01, 3.25532e-01, 2.81606e-01,
     & 2.43607e-01, 2.10736e-01, 1.82300e-01, 1.57701e-01, 1.36422e-01/
      DATA (SELFREF(JT, 3),JT=1,10)  /
     & 4.57628e-01, 3.99663e-01, 3.49040e-01, 3.04829e-01, 2.66218e-01,
     & 2.32498e-01, 2.03049e-01, 1.77330e-01, 1.54869e-01, 1.35252e-01/
      DATA (SELFREF(JT, 4),JT=1,10)  /
     & 4.28634e-01, 3.81736e-01, 3.39970e-01, 3.02773e-01, 2.69647e-01,
     & 2.40144e-01, 2.13870e-01, 1.90470e-01, 1.69630e-01, 1.51071e-01/
      DATA (SELFREF(JT, 5),JT=1,10)  /
     & 4.21002e-01, 3.77493e-01, 3.38480e-01, 3.03499e-01, 2.72133e-01,
     & 2.44009e-01, 2.18792e-01, 1.96180e-01, 1.75905e-01, 1.57726e-01/
      DATA (SELFREF(JT, 6),JT=1,10)  /
     & 3.97517e-01, 3.61167e-01, 3.28140e-01, 2.98133e-01, 2.70871e-01,
     & 2.46101e-01, 2.23597e-01, 2.03150e-01, 1.84573e-01, 1.67695e-01/
      DATA (SELFREF(JT, 7),JT=1,10)  /
     & 3.92114e-01, 3.57554e-01, 3.26040e-01, 2.97304e-01, 2.71100e-01,
     & 2.47206e-01, 2.25418e-01, 2.05550e-01, 1.87433e-01, 1.70913e-01/
      DATA (SELFREF(JT, 8),JT=1,10)  /
     & 3.79555e-01, 3.47264e-01, 3.17720e-01, 2.90690e-01, 2.65959e-01,
     & 2.43332e-01, 2.22631e-01, 2.03690e-01, 1.86361e-01, 1.70506e-01/
      DATA (SELFREF(JT, 9),JT=1,10)  /
     & 3.92644e-01, 3.58048e-01, 3.26500e-01, 2.97732e-01, 2.71498e-01,
     & 2.47576e-01, 2.25762e-01, 2.05870e-01, 1.87731e-01, 1.71190e-01/
      DATA (SELFREF(JT,10),JT=1,10)  /
     & 4.06542e-01, 3.71200e-01, 3.38930e-01, 3.09465e-01, 2.82562e-01,
     & 2.57998e-01, 2.35569e-01, 2.15090e-01, 1.96391e-01, 1.79318e-01/
      DATA (SELFREF(JT,11),JT=1,10)  /
     & 4.09672e-01, 3.76237e-01, 3.45530e-01, 3.17329e-01, 2.91430e-01,
     & 2.67645e-01, 2.45801e-01, 2.25740e-01, 2.07316e-01, 1.90396e-01/
      DATA (SELFREF(JT,12),JT=1,10)  /
     & 3.85140e-01, 3.61989e-01, 3.40230e-01, 3.19779e-01, 3.00557e-01,
     & 2.82490e-01, 2.65510e-01, 2.49550e-01, 2.34549e-01, 2.20451e-01/
      DATA (SELFREF(JT,13),JT=1,10)  /
     & 4.87349e-01, 4.42192e-01, 4.01220e-01, 3.64044e-01, 3.30313e-01,
     & 2.99707e-01, 2.71937e-01, 2.46740e-01, 2.23878e-01, 2.03134e-01/
      DATA (SELFREF(JT,14),JT=1,10)  /
     & 5.64339e-01, 5.06194e-01, 4.54040e-01, 4.07259e-01, 3.65298e-01,
     & 3.27661e-01, 2.93901e-01, 2.63620e-01, 2.36459e-01, 2.12096e-01/
      DATA (SELFREF(JT,15),JT=1,10)  /
     & 5.91123e-01, 5.26420e-01, 4.68800e-01, 4.17486e-01, 3.71790e-01,
     & 3.31095e-01, 2.94854e-01, 2.62580e-01, 2.33839e-01, 2.08243e-01/
      DATA (SELFREF(JT,16),JT=1,10)  /
     & 5.04590e-01, 4.65235e-01, 4.28950e-01, 3.95495e-01, 3.64649e-01,
     & 3.36209e-01, 3.09987e-01, 2.85810e-01, 2.63519e-01, 2.42966e-01/
