C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB04.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.0 $
C     created:   $Date: 2002/06/03 20:35:17 $
       PARAMETER (MG=16)

       REAL KA(9,5,13,MG), KB(5,5,13:59,MG)
       DIMENSION SELFREF(10,MG), FORREF(4,MG)

       COMMON /HVRSN4/ HVRKG4
       COMMON /K4/ KA, KB, FORREF, SELFREF

       CHARACTER*15 HVRKG4

       DATA HVRKG4 /'$Revision: 3.0 $'/

C     The array KA contains absorption coefs for each of the 16 g-intervals
C     for a range of pressure levels > ~100mb, temperatures, and ratios
C     of water vapor to CO2.  The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.
C     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
C     to different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this  pressure 
C     level, JT = 2 refers to the temperature
C     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
C     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
C     to the reference pressure level (e.g. JP = 1 is for a
C     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA ((KA(JS,JT, 1, 1),JS=1,9),JT=1,5) /
     &1.0697E-02,1.0151E-02,9.2549E-03,8.2645E-03,7.2061E-03,6.0662E-03,
     &4.9816E-03,4.8867E-03,2.0269E-04,1.1677E-02,1.1138E-02,1.0216E-02,
     &9.1909E-03,8.0553E-03,6.8223E-03,5.5408E-03,4.6854E-03,2.3825E-04,
     &1.2605E-02,1.2092E-02,1.1179E-02,1.0121E-02,8.9159E-03,7.6027E-03,
     &6.0392E-03,4.3498E-03,2.8245E-04,1.3484E-02,1.3046E-02,1.2153E-02,
     &1.1041E-02,9.7806E-03,8.2921E-03,6.5023E-03,4.3023E-03,3.0318E-04,
     &1.4330E-02,1.3997E-02,1.3114E-02,1.1943E-02,1.0557E-02,8.8567E-03,
     &6.8709E-03,4.3577E-03,3.2751E-04/
      DATA ((KA(JS,JT, 2, 1),JS=1,9),JT=1,5) /
     &1.3833E-02,1.2806E-02,1.1465E-02,1.0025E-02,8.5208E-03,6.9589E-03,
     &5.3336E-03,4.2294E-03,1.4419E-04,1.5144E-02,1.4068E-02,1.2644E-02,
     &1.1119E-02,9.5204E-03,7.8236E-03,6.0220E-03,4.4086E-03,1.7355E-04,
     &1.6397E-02,1.5299E-02,1.3819E-02,1.2230E-02,1.0525E-02,8.6894E-03,
     &6.7322E-03,4.5883E-03,2.1022E-04,1.7608E-02,1.6518E-02,1.5010E-02,
     &1.3349E-02,1.1524E-02,9.5665E-03,7.3586E-03,4.7702E-03,2.1845E-04,
     &1.8795E-02,1.7739E-02,1.6211E-02,1.4458E-02,1.2504E-02,1.0367E-02,
     &7.8746E-03,4.9505E-03,2.4452E-04/
      DATA ((KA(JS,JT, 3, 1),JS=1,9),JT=1,5) /
     &2.3349E-02,2.1073E-02,1.8534E-02,1.5886E-02,1.3154E-02,1.0346E-02,
     &7.4749E-03,4.5440E-03,9.5522E-05,2.5718E-02,2.3272E-02,2.0503E-02,
     &1.7622E-02,1.4648E-02,1.1596E-02,8.4531E-03,5.1652E-03,1.1957E-04,
     &2.8025E-02,2.5421E-02,2.2452E-02,1.9353E-02,1.6163E-02,1.2876E-02,
     &9.4440E-03,5.8151E-03,1.4638E-04,3.0273E-02,2.7542E-02,2.4400E-02,
     &2.1110E-02,1.7713E-02,1.4169E-02,1.0445E-02,6.4078E-03,1.5375E-04,
     &3.2488E-02,2.9668E-02,2.6366E-02,2.2912E-02,1.9285E-02,1.5463E-02,
     &1.1411E-02,6.9035E-03,1.7414E-04/
      DATA ((KA(JS,JT, 4, 1),JS=1,9),JT=1,5) /
     &3.9680E-02,3.5246E-02,3.0687E-02,2.5989E-02,2.1199E-02,1.6340E-02,
     &1.1394E-02,6.3232E-03,6.3142E-05,4.4067E-02,3.9245E-02,3.4186E-02,
     &2.8983E-02,2.3690E-02,1.8315E-02,1.2835E-02,7.2156E-03,8.2154E-05,
     &4.8382E-02,4.3189E-02,3.7634E-02,3.1955E-02,2.6184E-02,2.0317E-02,
     &1.4329E-02,8.1343E-03,1.0015E-04,5.2631E-02,4.7051E-02,4.1069E-02,
     &3.4945E-02,2.8716E-02,2.2361E-02,1.5856E-02,9.0735E-03,1.0763E-04,
     &5.6812E-02,5.0879E-02,4.4486E-02,3.7949E-02,3.1266E-02,2.4439E-02,
     &1.7397E-02,9.9865E-03,1.2433E-04/
      DATA ((KA(JS,JT, 5, 1),JS=1,9),JT=1,5) /
     &6.1659E-02,5.4360E-02,4.7000E-02,3.9571E-02,3.2046E-02,2.4431E-02,
     &1.6731E-02,8.9002E-03,4.4135E-05,6.9177E-02,6.1077E-02,5.2885E-02,
     &4.4540E-02,3.6083E-02,2.7553E-02,1.8920E-02,1.0138E-02,5.7278E-05,
     &7.6561E-02,6.7721E-02,5.8676E-02,4.9436E-02,4.0109E-02,3.0675E-02,
     &2.1149E-02,1.1429E-02,6.8177E-05,8.3855E-02,7.4287E-02,6.4398E-02,
     &5.4317E-02,4.4139E-02,3.3855E-02,2.3434E-02,1.2758E-02,7.5655E-05,
     &9.1112E-02,8.0836E-02,7.0093E-02,5.9205E-02,4.8195E-02,3.7076E-02,
     &2.5757E-02,1.4110E-02,8.9921E-05/
      DATA ((KA(JS,JT, 6, 1),JS=1,9),JT=1,5) /
     &8.8882E-02,7.8094E-02,6.7257E-02,5.6376E-02,4.5468E-02,3.4471E-02,
     &2.3372E-02,1.2141E-02,3.4008E-05,1.0088E-01,8.8690E-02,7.6454E-02,
     &6.4166E-02,5.1764E-02,3.9256E-02,2.6651E-02,1.3906E-02,4.1496E-05,
     &1.1268E-01,9.9170E-02,8.5584E-02,7.1867E-02,5.7997E-02,4.4019E-02,
     &2.9951E-02,1.5714E-02,4.7587E-05,1.2443E-01,1.0961E-01,9.4686E-02,
     &7.9524E-02,6.4216E-02,4.8825E-02,3.3307E-02,1.7586E-02,5.4734E-05,
     &1.3608E-01,1.2003E-01,1.0372E-01,8.7155E-02,7.0466E-02,5.3660E-02,
     &3.6716E-02,1.9490E-02,6.4532E-05/
      DATA ((KA(JS,JT, 7, 1),JS=1,9),JT=1,5) /
     &1.3393E-01,1.1743E-01,1.0091E-01,8.4366E-02,6.7796E-02,5.1191E-02,
     &3.4487E-02,1.7647E-02,2.6258E-05,1.5385E-01,1.3496E-01,1.1603E-01,
     &9.7081E-02,7.8079E-02,5.8981E-02,3.9763E-02,2.0387E-02,3.2089E-05,
     &1.7362E-01,1.5237E-01,1.3107E-01,1.0975E-01,8.8299E-02,6.6730E-02,
     &4.5023E-02,2.3161E-02,4.0067E-05,1.9325E-01,1.6971E-01,1.4609E-01,
     &1.2238E-01,9.8509E-02,7.4481E-02,5.0334E-02,2.5995E-02,4.6630E-05,
     &2.1303E-01,1.8717E-01,1.6126E-01,1.3511E-01,1.0879E-01,8.2319E-02,
     &5.5720E-02,2.8900E-02,5.5874E-05/
      DATA ((KA(JS,JT, 8, 1),JS=1,9),JT=1,5) /
     &2.4085E-01,2.1093E-01,1.8102E-01,1.5107E-01,1.2112E-01,9.1137E-02,
     &6.1112E-02,3.0964E-02,2.6704E-05,2.8040E-01,2.4563E-01,2.1082E-01,
     &1.7598E-01,1.4114E-01,1.0627E-01,7.1313E-02,3.6159E-02,3.4463E-05,
     &3.1986E-01,2.8024E-01,2.4058E-01,2.0091E-01,1.6119E-01,1.2143E-01,
     &8.1504E-02,4.1377E-02,4.2885E-05,3.5910E-01,3.1468E-01,2.7026E-01,
     &2.2578E-01,1.8126E-01,1.3658E-01,9.1734E-02,4.6641E-02,5.1508E-05,
     &3.9881E-01,3.4958E-01,3.0035E-01,2.5107E-01,2.0163E-01,1.5198E-01,
     &1.0212E-01,5.2034E-02,5.9872E-05/
      DATA ((KA(JS,JT, 9, 1),JS=1,9),JT=1,5) /
     &8.1251E-01,7.1113E-01,6.0978E-01,5.0834E-01,4.0692E-01,3.0549E-01,
     &2.0401E-01,1.0247E-01,4.2060E-05,9.6024E-01,8.4039E-01,7.2060E-01,
     &6.0079E-01,4.8095E-01,3.6106E-01,2.4120E-01,1.2123E-01,5.7363E-05,
     &1.1088E+00,9.7056E-01,8.3222E-01,6.9393E-01,5.5555E-01,4.1720E-01,
     &2.7875E-01,1.4021E-01,7.4113E-05,1.2568E+00,1.1001E+00,9.4342E-01,
     &7.8665E-01,6.2985E-01,4.7311E-01,3.1630E-01,1.5915E-01,9.2862E-05,
     &1.4062E+00,1.2309E+00,1.0557E+00,8.8039E-01,7.0513E-01,5.2977E-01,
     &3.5432E-01,1.7839E-01,1.0954E-04/
      DATA ((KA(JS,JT,10, 1),JS=1,9),JT=1,5) /
     &3.0868E+00,2.7010E+00,2.3154E+00,1.9296E+00,1.5440E+00,1.1583E+00,
     &7.7257E-01,3.8682E-01,7.9650E-05,3.6992E+00,3.2371E+00,2.7749E+00,
     &2.3126E+00,1.8504E+00,1.3883E+00,9.2595E-01,4.6361E-01,1.1315E-04,
     &4.3239E+00,3.7838E+00,3.2436E+00,2.7034E+00,2.1630E+00,1.6228E+00,
     &1.0824E+00,5.4204E-01,1.4419E-04,4.9483E+00,4.3302E+00,3.7121E+00,
     &3.0937E+00,2.4754E+00,1.8572E+00,1.2389E+00,6.2062E-01,1.7752E-04,
     &5.5745E+00,4.8780E+00,4.1816E+00,3.4855E+00,2.7890E+00,2.0926E+00,
     &1.3962E+00,6.9963E-01,2.1449E-04/
      DATA ((KA(JS,JT,11, 1),JS=1,9),JT=1,5) /
     &4.4731E+00,3.9138E+00,3.3549E+00,2.7960E+00,2.2371E+00,1.6781E+00,
     &1.1191E+00,5.6013E-01,1.1739E-04,5.3673E+00,4.6967E+00,4.0260E+00,
     &3.3552E+00,2.6847E+00,2.0138E+00,1.3431E+00,6.7224E-01,1.4272E-04,
     &6.2805E+00,5.4954E+00,4.7109E+00,3.9260E+00,3.1412E+00,2.3563E+00,
     &1.5716E+00,7.8663E-01,1.8731E-04,7.1941E+00,6.2951E+00,5.3963E+00,
     &4.4973E+00,3.5984E+00,2.6993E+00,1.8005E+00,9.0138E-01,2.2429E-04,
     &8.1084E+00,7.0952E+00,6.0822E+00,5.0692E+00,4.0560E+00,3.0428E+00,
     &2.0297E+00,1.0163E+00,2.6588E-04/
      DATA ((KA(JS,JT,12, 1),JS=1,9),JT=1,5) /
     &4.8324E+00,4.2285E+00,3.6244E+00,3.0205E+00,2.4167E+00,1.8130E+00,
     &1.2091E+00,6.0509E-01,1.2228E-04,5.8007E+00,5.0761E+00,4.3512E+00,
     &3.6264E+00,2.9012E+00,2.1763E+00,1.4515E+00,7.2651E-01,1.6183E-04,
     &6.7955E+00,5.9463E+00,5.0972E+00,4.2481E+00,3.3989E+00,2.5498E+00,
     &1.7005E+00,8.5109E-01,1.9622E-04,7.7871E+00,6.8141E+00,5.8412E+00,
     &4.8680E+00,3.8949E+00,2.9218E+00,1.9487E+00,9.7554E-01,2.4527E-04,
     &8.7731E+00,7.6770E+00,6.5805E+00,5.4843E+00,4.3883E+00,3.2921E+00,
     &2.1959E+00,1.0994E+00,2.9421E-04/
      DATA ((KA(JS,JT,13, 1),JS=1,9),JT=1,5) /
     &4.1936E+00,3.6695E+00,3.1456E+00,2.6217E+00,2.0976E+00,1.5735E+00,
     &1.0495E+00,5.2527E-01,1.1808E-04,5.0398E+00,4.4101E+00,3.7804E+00,
     &3.1506E+00,2.5209E+00,1.8912E+00,1.2614E+00,6.3136E-01,1.5519E-04,
     &5.9030E+00,5.1655E+00,4.4278E+00,3.6903E+00,2.9527E+00,2.2152E+00,
     &1.4774E+00,7.3950E-01,1.9283E-04,6.7598E+00,5.9151E+00,5.0706E+00,
     &4.2260E+00,3.3815E+00,2.5368E+00,1.6919E+00,8.4706E-01,2.3479E-04,
     &7.6160E+00,6.6645E+00,5.7130E+00,4.7615E+00,3.8100E+00,2.8583E+00,
     &1.9066E+00,9.5472E-01,2.9034E-04/
      DATA ((KA(JS,JT, 1, 2),JS=1,9),JT=1,5) /
     &2.4501E-02,2.2546E-02,2.0206E-02,1.7580E-02,1.4733E-02,1.1757E-02,
     &8.5871E-03,4.9715E-03,4.1358E-04,2.5392E-02,2.3504E-02,2.1061E-02,
     &1.8282E-02,1.5340E-02,1.2238E-02,8.8921E-03,5.1114E-03,3.8966E-04,
     &2.6027E-02,2.4221E-02,2.1673E-02,1.8830E-02,1.5807E-02,1.2525E-02,
     &9.1668E-03,5.5997E-03,3.7711E-04,2.6673E-02,2.4919E-02,2.2282E-02,
     &1.9349E-02,1.6139E-02,1.2835E-02,9.4247E-03,5.9143E-03,4.3807E-04,
     &2.7193E-02,2.5447E-02,2.2733E-02,1.9712E-02,1.6469E-02,1.3190E-02,
     &9.7078E-03,6.2746E-03,5.1500E-04/
      DATA ((KA(JS,JT, 2, 2),JS=1,9),JT=1,5) /
     &3.1935E-02,2.8971E-02,2.5689E-02,2.2139E-02,1.8357E-02,1.4398E-02,
     &1.0314E-02,5.7860E-03,2.7704E-04,3.3322E-02,3.0388E-02,2.6935E-02,
     &2.3180E-02,1.9196E-02,1.5076E-02,1.0778E-02,6.0195E-03,2.7933E-04,
     &3.4372E-02,3.1484E-02,2.7888E-02,2.3966E-02,1.9860E-02,1.5585E-02,
     &1.1079E-02,6.3448E-03,2.7118E-04,3.5247E-02,3.2382E-02,2.8654E-02,
     &2.4627E-02,2.0404E-02,1.5949E-02,1.1392E-02,6.6539E-03,3.3360E-04,
     &3.6022E-02,3.3132E-02,2.9304E-02,2.5200E-02,2.0861E-02,1.6331E-02,
     &1.1785E-02,6.9927E-03,3.9477E-04/
      DATA ((KA(JS,JT, 3, 2),JS=1,9),JT=1,5) /
     &5.5981E-02,4.9895E-02,4.3680E-02,3.7190E-02,3.0485E-02,2.3562E-02,
     &1.6425E-02,9.0449E-03,1.7015E-04,5.8799E-02,5.2631E-02,4.6091E-02,
     &3.9226E-02,3.2137E-02,2.4836E-02,1.7301E-02,9.5109E-03,1.8305E-04,
     &6.0996E-02,5.4813E-02,4.8006E-02,4.0820E-02,3.3414E-02,2.5787E-02,
     &1.7985E-02,9.8187E-03,1.8905E-04,6.2707E-02,5.6481E-02,4.9388E-02,
     &4.1983E-02,3.4344E-02,2.6526E-02,1.8461E-02,1.0117E-02,2.4096E-04,
     &6.4195E-02,5.7890E-02,5.0593E-02,4.2977E-02,3.5166E-02,2.7170E-02,
     &1.8910E-02,1.0511E-02,2.9172E-04/
      DATA ((KA(JS,JT, 4, 2),JS=1,9),JT=1,5) /
     &1.0046E-01,8.8696E-02,7.6950E-02,6.5010E-02,5.2854E-02,4.0445E-02,
     &2.7753E-02,1.4715E-02,1.1527E-04,1.0584E-01,9.3644E-02,8.1343E-02,
     &6.8725E-02,5.5817E-02,4.2663E-02,2.9258E-02,1.5519E-02,1.2102E-04,
     &1.1041E-01,9.7926E-02,8.5123E-02,7.1882E-02,5.8341E-02,4.4558E-02,
     &3.0554E-02,1.6224E-02,1.3450E-04,1.1403E-01,1.0136E-01,8.8078E-02,
     &7.4319E-02,6.0266E-02,4.6028E-02,3.1549E-02,1.6730E-02,1.7483E-04,
     &1.1675E-01,1.0391E-01,9.0226E-02,7.6062E-02,6.1699E-02,4.7119E-02,
     &3.2315E-02,1.7160E-02,2.1415E-04/
      DATA ((KA(JS,JT, 5, 2),JS=1,9),JT=1,5) /
     &1.6440E-01,1.4448E-01,1.2464E-01,1.0475E-01,8.4706E-02,6.4458E-02,
     &4.3883E-02,2.2824E-02,7.5213E-05,1.7418E-01,1.5330E-01,1.3243E-01,
     &1.1140E-01,9.0109E-02,6.8519E-02,4.6576E-02,2.4202E-02,8.0510E-05,
     &1.8254E-01,1.6088E-01,1.3912E-01,1.1702E-01,9.4586E-02,7.1837E-02,
     &4.8767E-02,2.5350E-02,9.6196E-05,1.8937E-01,1.6713E-01,1.4454E-01,
     &1.2155E-01,9.8195E-02,7.4514E-02,5.0569E-02,2.6308E-02,1.2696E-04,
     &1.9452E-01,1.7183E-01,1.4864E-01,1.2495E-01,1.0086E-01,7.6520E-02,
     &5.1964E-02,2.7040E-02,1.5611E-04/
      DATA ((KA(JS,JT, 6, 2),JS=1,9),JT=1,5) /
     &2.4921E-01,2.1859E-01,1.8798E-01,1.5740E-01,1.2679E-01,9.6030E-02,
     &6.5011E-02,3.3513E-02,4.7816E-05,2.6657E-01,2.3398E-01,2.0147E-01,
     &1.6890E-01,1.3619E-01,1.0322E-01,6.9866E-02,3.5915E-02,5.5771E-05,
     &2.8078E-01,2.4667E-01,2.1258E-01,1.7831E-01,1.4376E-01,1.0887E-01,
     &7.3553E-02,3.7752E-02,7.2324E-05,2.9281E-01,2.5752E-01,2.2202E-01,
     &1.8622E-01,1.5008E-01,1.1356E-01,7.6693E-02,3.9339E-02,9.1831E-05,
     &3.0221E-01,2.6598E-01,2.2929E-01,1.9231E-01,1.5490E-01,1.1717E-01,
     &7.9072E-02,4.0614E-02,1.1670E-04/
      DATA ((KA(JS,JT, 7, 2),JS=1,9),JT=1,5) /
     &3.9471E-01,3.4576E-01,2.9687E-01,2.4797E-01,1.9909E-01,1.5016E-01,
     &1.0112E-01,5.1719E-02,4.5280E-05,4.2660E-01,3.7391E-01,3.2118E-01,
     &2.6853E-01,2.1577E-01,1.6297E-01,1.0986E-01,5.6145E-02,5.4459E-05,
     &4.5301E-01,3.9723E-01,3.4149E-01,2.8568E-01,2.2975E-01,1.7359E-01,
     &1.1695E-01,5.9583E-02,6.4819E-05,4.7467E-01,4.1649E-01,3.5820E-01,
     &2.9973E-01,2.4109E-01,1.8208E-01,1.2251E-01,6.2380E-02,7.8660E-05,
     &4.9199E-01,4.3192E-01,3.7144E-01,3.1090E-01,2.5000E-01,1.8865E-01,
     &1.2686E-01,6.4563E-02,9.4184E-05/
      DATA ((KA(JS,JT, 8, 2),JS=1,9),JT=1,5) /
     &7.4598E-01,6.5300E-01,5.6009E-01,4.6718E-01,3.7433E-01,2.8142E-01,
     &1.8848E-01,9.5403E-02,4.9176E-05,8.1434E-01,7.1301E-01,6.1173E-01,
     &5.1044E-01,4.0917E-01,3.0788E-01,2.0653E-01,1.0477E-01,6.1468E-05,
     &8.7268E-01,7.6440E-01,6.5604E-01,5.4759E-01,4.3920E-01,3.3065E-01,
     &2.2200E-01,1.1269E-01,7.5902E-05,9.2025E-01,8.0619E-01,6.9208E-01,
     &5.7794E-01,4.6363E-01,3.4928E-01,2.3455E-01,1.1876E-01,9.2466E-05,
     &9.5892E-01,8.4025E-01,7.2136E-01,6.0245E-01,4.8344E-01,3.6420E-01,
     &2.4431E-01,1.2353E-01,1.1186E-04/
      DATA ((KA(JS,JT, 9, 2),JS=1,9),JT=1,5) /
     &2.6457E+00,2.3152E+00,1.9846E+00,1.6541E+00,1.3236E+00,9.9317E-01,
     &6.6276E-01,3.3240E-01,8.9892E-05,2.9186E+00,2.5541E+00,2.1896E+00,
     &1.8252E+00,1.4607E+00,1.0963E+00,7.3190E-01,3.6751E-01,1.0914E-04,
     &3.1587E+00,2.7643E+00,2.3700E+00,1.9759E+00,1.5816E+00,1.1873E+00,
     &7.9301E-01,3.9869E-01,1.2624E-04,3.3556E+00,2.9370E+00,2.5183E+00,
     &2.0996E+00,1.6808E+00,1.2622E+00,8.4339E-01,4.2436E-01,1.5596E-04,
     &3.5177E+00,3.0788E+00,2.6401E+00,2.2013E+00,1.7625E+00,1.3234E+00,
     &8.8445E-01,4.4528E-01,1.9369E-04/
      DATA ((KA(JS,JT,10, 2),JS=1,9),JT=1,5) /
     &1.0501E+01,9.1884E+00,7.8763E+00,6.5637E+00,5.2509E+00,3.9387E+00,
     &2.6260E+00,1.3137E+00,1.7951E-04,1.1694E+01,1.0233E+01,8.7714E+00,
     &7.3095E+00,5.8477E+00,4.3863E+00,2.9249E+00,1.4636E+00,2.1880E-04,
     &1.2771E+01,1.1175E+01,9.5787E+00,7.9832E+00,6.3867E+00,4.7910E+00,
     &3.1952E+00,1.5993E+00,2.5504E-04,1.3661E+01,1.1954E+01,1.0247E+01,
     &8.5403E+00,6.8331E+00,5.1260E+00,3.4191E+00,1.7121E+00,3.1556E-04,
     &1.4403E+01,1.2603E+01,1.0804E+01,9.0041E+00,7.2046E+00,5.4047E+00,
     &3.6050E+00,1.8055E+00,3.5095E-04/
      DATA ((KA(JS,JT,11, 2),JS=1,9),JT=1,5) /
     &1.5305E+01,1.3391E+01,1.1479E+01,9.5654E+00,7.6527E+00,5.7399E+00,
     &3.8269E+00,1.9139E+00,2.5263E-04,1.7053E+01,1.4921E+01,1.2790E+01,
     &1.0658E+01,8.5272E+00,6.3954E+00,4.2646E+00,2.1334E+00,3.2671E-04,
     &1.8597E+01,1.6273E+01,1.3949E+01,1.1625E+01,9.3007E+00,6.9759E+00,
     &4.6520E+00,2.3277E+00,3.9618E-04,1.9894E+01,1.7409E+01,1.4922E+01,
     &1.2436E+01,9.9497E+00,7.4632E+00,4.9771E+00,2.4907E+00,4.6029E-04,
     &2.0957E+01,1.8337E+01,1.5718E+01,1.3099E+01,1.0480E+01,7.8611E+00,
     &5.2427E+00,2.6238E+00,5.1000E-04/
      DATA ((KA(JS,JT,12, 2),JS=1,9),JT=1,5) /
     &1.6595E+01,1.4521E+01,1.2446E+01,1.0372E+01,8.2975E+00,6.2234E+00,
     &4.1492E+00,2.0749E+00,2.8721E-04,1.8487E+01,1.6178E+01,1.3866E+01,
     &1.1556E+01,9.2444E+00,6.9339E+00,4.6231E+00,2.3126E+00,3.5210E-04,
     &2.0157E+01,1.7638E+01,1.5119E+01,1.2600E+01,1.0080E+01,7.5607E+00,
     &5.0414E+00,2.5223E+00,4.4248E-04,2.1568E+01,1.8872E+01,1.6176E+01,
     &1.3480E+01,1.0785E+01,8.0897E+00,5.3945E+00,2.6993E+00,5.0244E-04,
     &2.2671E+01,1.9838E+01,1.7004E+01,1.4170E+01,1.1337E+01,8.5042E+00,
     &5.6711E+00,2.8381E+00,5.5567E-04/
      DATA ((KA(JS,JT,13, 2),JS=1,9),JT=1,5) /
     &1.4451E+01,1.2644E+01,1.0838E+01,9.0321E+00,7.2259E+00,5.4197E+00,
     &3.6133E+00,1.8070E+00,2.7932E-04,1.6097E+01,1.4085E+01,1.2073E+01,
     &1.0061E+01,8.0489E+00,6.0372E+00,4.0253E+00,2.0137E+00,3.2799E-04,
     &1.7564E+01,1.5369E+01,1.3173E+01,1.0978E+01,8.7826E+00,6.5876E+00,
     &4.3925E+00,2.1975E+00,4.0780E-04,1.8771E+01,1.6426E+01,1.4079E+01,
     &1.1733E+01,9.3868E+00,7.0409E+00,4.6954E+00,2.3495E+00,5.0230E-04,
     &1.9694E+01,1.7232E+01,1.4771E+01,1.2310E+01,9.8489E+00,7.3875E+00,
     &4.9264E+00,2.4656E+00,5.5102E-04/
      DATA ((KA(JS,JT, 1, 3),JS=1,9),JT=1,5) /
     &3.7564E-02,3.3492E-02,2.9385E-02,2.5064E-02,2.0679E-02,1.6159E-02,
     &1.1502E-02,6.5367E-03,3.9794E-04,3.6916E-02,3.3151E-02,2.9160E-02,
     &2.5018E-02,2.0751E-02,1.6389E-02,1.1901E-02,7.2678E-03,5.4686E-04,
     &3.6399E-02,3.2903E-02,2.9031E-02,2.5012E-02,2.0900E-02,1.6718E-02,
     &1.2389E-02,8.0801E-03,7.4220E-04,3.6126E-02,3.2782E-02,2.9047E-02,
     &2.5198E-02,2.1279E-02,1.7152E-02,1.3045E-02,8.9482E-03,8.9478E-04,
     &3.5996E-02,3.2833E-02,2.9270E-02,2.5593E-02,2.1712E-02,1.7723E-02,
     &1.3812E-02,9.7243E-03,1.0975E-03/
      DATA ((KA(JS,JT, 2, 3),JS=1,9),JT=1,5) /
     &4.9545E-02,4.3840E-02,3.8273E-02,3.2472E-02,2.6558E-02,2.0510E-02,
     &1.4332E-02,7.7992E-03,3.0769E-04,4.8709E-02,4.3359E-02,3.7969E-02,
     &3.2304E-02,2.6513E-02,2.0603E-02,1.4626E-02,8.4051E-03,4.1476E-04,
     &4.8165E-02,4.3120E-02,3.7795E-02,3.2248E-02,2.6570E-02,2.0838E-02,
     &1.4977E-02,8.9685E-03,5.6832E-04,4.7962E-02,4.3077E-02,3.7844E-02,
     &3.2393E-02,2.6873E-02,2.1238E-02,1.5407E-02,9.6431E-03,6.7745E-04,
     &4.8025E-02,4.3378E-02,3.8202E-02,3.2847E-02,2.7374E-02,2.1742E-02,
     &1.5999E-02,1.0391E-02,8.3539E-04/
      DATA ((KA(JS,JT, 3, 3),JS=1,9),JT=1,5) /
     &8.8120E-02,7.7386E-02,6.6977E-02,5.6500E-02,4.5838E-02,3.5027E-02,
     &2.3995E-02,1.2704E-02,2.2676E-04,8.6799E-02,7.6419E-02,6.6419E-02,
     &5.6119E-02,4.5623E-02,3.4916E-02,2.4025E-02,1.3004E-02,3.0168E-04,
     &8.6001E-02,7.6005E-02,6.6184E-02,5.6008E-02,4.5591E-02,3.4990E-02,
     &2.4263E-02,1.3424E-02,3.9676E-04,8.5691E-02,7.5994E-02,6.6270E-02,
     &5.6158E-02,4.5788E-02,3.5296E-02,2.4707E-02,1.3830E-02,4.9186E-04,
     &8.6172E-02,7.6716E-02,6.6965E-02,5.6820E-02,4.6489E-02,3.5977E-02,
     &2.5332E-02,1.4387E-02,6.1173E-04/
      DATA ((KA(JS,JT, 4, 3),JS=1,9),JT=1,5) /
     &1.6100E-01,1.4106E-01,1.2117E-01,1.0160E-01,8.1953E-02,6.2189E-02,
     &4.2184E-02,2.1860E-02,1.5920E-04,1.5854E-01,1.3897E-01,1.1977E-01,
     &1.0067E-01,8.1408E-02,6.1866E-02,4.2083E-02,2.1896E-02,2.1901E-04,
     &1.5713E-01,1.3793E-01,1.1924E-01,1.0046E-01,8.1310E-02,6.1926E-02,
     &4.2176E-02,2.2134E-02,2.8281E-04,1.5680E-01,1.3795E-01,1.1956E-01,
     &1.0071E-01,8.1588E-02,6.2136E-02,4.2469E-02,2.2574E-02,3.5509E-04,
     &1.5807E-01,1.3940E-01,1.2093E-01,1.0191E-01,8.2580E-02,6.3036E-02,
     &4.3252E-02,2.3169E-02,4.4437E-04/
      DATA ((KA(JS,JT, 5, 3),JS=1,9),JT=1,5) /
     &2.7295E-01,2.3896E-01,2.0497E-01,1.7107E-01,1.3742E-01,1.0372E-01,
     &6.9897E-02,3.5756E-02,1.1345E-04,2.6909E-01,2.3567E-01,2.0228E-01,
     &1.6922E-01,1.3618E-01,1.0303E-01,6.9598E-02,3.5741E-02,1.5887E-04,
     &2.6654E-01,2.3348E-01,2.0077E-01,1.6833E-01,1.3583E-01,1.0288E-01,
     &6.9627E-02,3.5834E-02,2.0432E-04,2.6633E-01,2.3346E-01,2.0125E-01,
     &1.6903E-01,1.3632E-01,1.0334E-01,6.9968E-02,3.6152E-02,2.5784E-04,
     &2.6868E-01,2.3592E-01,2.0366E-01,1.7109E-01,1.3803E-01,1.0467E-01,
     &7.0932E-02,3.6877E-02,3.2436E-04/
      DATA ((KA(JS,JT, 6, 3),JS=1,9),JT=1,5) /
     &4.3357E-01,3.7951E-01,3.2542E-01,2.7129E-01,2.1728E-01,1.6346E-01,
     &1.0964E-01,5.5662E-02,8.3325E-05,4.2794E-01,3.7459E-01,3.2123E-01,
     &2.6798E-01,2.1494E-01,1.6197E-01,1.0894E-01,5.5488E-02,1.1433E-04,
     &4.2362E-01,3.7090E-01,3.1822E-01,2.6585E-01,2.1359E-01,1.6133E-01,
     &1.0870E-01,5.5444E-02,1.4294E-04,4.2356E-01,3.7092E-01,3.1860E-01,
     &2.6656E-01,2.1457E-01,1.6217E-01,1.0928E-01,5.5858E-02,1.8487E-04,
     &4.2732E-01,3.7444E-01,3.2213E-01,2.6992E-01,2.1742E-01,1.6433E-01,
     &1.1084E-01,5.6756E-02,2.3367E-04/
      DATA ((KA(JS,JT, 7, 3),JS=1,9),JT=1,5) /
     &7.2201E-01,6.3185E-01,5.4168E-01,4.5148E-01,3.6131E-01,2.7123E-01,
     &1.8131E-01,9.1347E-02,6.1051E-05,7.1295E-01,6.2391E-01,5.3487E-01,
     &4.4585E-01,3.5694E-01,2.6824E-01,1.7961E-01,9.0876E-02,8.2662E-05,
     &7.0704E-01,6.1882E-01,5.3061E-01,4.4252E-01,3.5463E-01,2.6681E-01,
     &1.7908E-01,9.0926E-02,1.0796E-04,7.0657E-01,6.1841E-01,5.3039E-01,
     &4.4278E-01,3.5513E-01,2.6769E-01,1.7995E-01,9.1305E-02,1.3920E-04,
     &7.1310E-01,6.2430E-01,5.3600E-01,4.4782E-01,3.5976E-01,2.7158E-01,
     &1.8261E-01,9.2814E-02,1.7572E-04/
      DATA ((KA(JS,JT, 8, 3),JS=1,9),JT=1,5) /
     &1.4344E+00,1.2551E+00,1.0759E+00,8.9667E-01,7.1735E-01,5.3821E-01,
     &3.5899E-01,1.8011E-01,7.5748E-05,1.4191E+00,1.2419E+00,1.0645E+00,
     &8.8713E-01,7.0979E-01,5.3268E-01,3.5557E-01,1.7867E-01,9.9921E-05,
     &1.4086E+00,1.2327E+00,1.0566E+00,8.8065E-01,7.0478E-01,5.2920E-01,
     &3.5364E-01,1.7813E-01,1.2236E-04,1.4087E+00,1.2327E+00,1.0568E+00,
     &8.8106E-01,7.0553E-01,5.2998E-01,3.5460E-01,1.7919E-01,1.5414E-04,
     &1.4217E+00,1.2444E+00,1.0672E+00,8.9025E-01,7.1327E-01,5.3627E-01,
     &3.5965E-01,1.8202E-01,1.9115E-04/
      DATA ((KA(JS,JT, 9, 3),JS=1,9),JT=1,5) /
     &5.3656E+00,4.6949E+00,4.0244E+00,3.3536E+00,2.6829E+00,2.0124E+00,
     &1.3418E+00,6.7121E-01,1.2938E-04,5.3249E+00,4.6593E+00,3.9938E+00,
     &3.3284E+00,2.6628E+00,1.9972E+00,1.3317E+00,6.6623E-01,1.6248E-04,
     &5.2842E+00,4.6238E+00,3.9633E+00,3.3029E+00,2.6426E+00,1.9822E+00,
     &1.3219E+00,6.6174E-01,2.1505E-04,5.2909E+00,4.6297E+00,3.9685E+00,
     &3.3074E+00,2.6461E+00,1.9850E+00,1.3243E+00,6.6344E-01,2.5323E-04,
     &5.3328E+00,4.6665E+00,4.0003E+00,3.3342E+00,2.6682E+00,2.0021E+00,
     &1.3361E+00,6.6998E-01,2.8724E-04/
      DATA ((KA(JS,JT,10, 3),JS=1,9),JT=1,5) /
     &2.2338E+01,1.9545E+01,1.6753E+01,1.3961E+01,1.1170E+01,8.3767E+00,
     &5.5849E+00,2.7925E+00,2.7123E-04,2.2247E+01,1.9467E+01,1.6686E+01,
     &1.3905E+01,1.1124E+01,8.3431E+00,5.5623E+00,2.7817E+00,3.3076E-04,
     &2.2079E+01,1.9319E+01,1.6560E+01,1.3800E+01,1.1040E+01,8.2801E+00,
     &5.5205E+00,2.7607E+00,4.2235E-04,2.2133E+01,1.9366E+01,1.6600E+01,
     &1.3833E+01,1.1067E+01,8.3005E+00,5.5343E+00,2.7680E+00,4.8628E-04,
     &2.2337E+01,1.9545E+01,1.6754E+01,1.3962E+01,1.1171E+01,8.3788E+00,
     &5.5873E+00,2.7956E+00,6.0636E-04/
      DATA ((KA(JS,JT,11, 3),JS=1,9),JT=1,5) /
     &3.2372E+01,2.8324E+01,2.4279E+01,2.0232E+01,1.6186E+01,1.2140E+01,
     &8.0929E+00,4.0469E+00,3.8659E-04,3.2225E+01,2.8197E+01,2.4169E+01,
     &2.0141E+01,1.6113E+01,1.2085E+01,8.0568E+00,4.0284E+00,4.6837E-04,
     &3.2089E+01,2.8078E+01,2.4068E+01,2.0057E+01,1.6046E+01,1.2035E+01,
     &8.0232E+00,4.0121E+00,5.6676E-04,3.2281E+01,2.8246E+01,2.4212E+01,
     &2.0176E+01,1.6141E+01,1.2106E+01,8.0716E+00,4.0370E+00,7.3031E-04,
     &3.2736E+01,2.8646E+01,2.4553E+01,2.0462E+01,1.6370E+01,1.2278E+01,
     &8.1864E+00,4.0949E+00,8.3516E-04/
      DATA ((KA(JS,JT,12, 3),JS=1,9),JT=1,5) /
     &3.4882E+01,3.0522E+01,2.6162E+01,2.1802E+01,1.7441E+01,1.3081E+01,
     &8.7208E+00,4.3607E+00,4.1853E-04,3.4744E+01,3.0400E+01,2.6058E+01,
     &2.1715E+01,1.7372E+01,1.3029E+01,8.6862E+00,4.3435E+00,5.1635E-04,
     &3.4694E+01,3.0356E+01,2.6020E+01,2.1683E+01,1.7347E+01,1.3010E+01,
     &8.6737E+00,4.3374E+00,5.8258E-04,3.4999E+01,3.0625E+01,2.6249E+01,
     &2.1876E+01,1.7501E+01,1.3126E+01,8.7513E+00,4.3768E+00,7.2545E-04,
     &3.5658E+01,3.1201E+01,2.6744E+01,2.2288E+01,1.7831E+01,1.3374E+01,
     &8.9165E+00,4.4593E+00,9.3950E-04/
      DATA ((KA(JS,JT,13, 3),JS=1,9),JT=1,5) /
     &3.0168E+01,2.6399E+01,2.2627E+01,1.8855E+01,1.5085E+01,1.1314E+01,
     &7.5425E+00,3.7715E+00,4.1524E-04,3.0082E+01,2.6321E+01,2.2562E+01,
     &1.8800E+01,1.5040E+01,1.1280E+01,7.5203E+00,3.7604E+00,5.1897E-04,
     &3.0098E+01,2.6336E+01,2.2574E+01,1.8812E+01,1.5049E+01,1.1287E+01,
     &7.5253E+00,3.7634E+00,6.3490E-04,3.0488E+01,2.6677E+01,2.2867E+01,
     &1.9056E+01,1.5245E+01,1.1434E+01,7.6233E+00,3.8122E+00,7.3304E-04,
     &3.1139E+01,2.7247E+01,2.3355E+01,1.9463E+01,1.5570E+01,1.1678E+01,
     &7.7859E+00,3.8940E+00,8.6573E-04/
      DATA ((KA(JS,JT, 1, 4),JS=1,9),JT=1,5) /
     &5.2057E-02,4.6191E-02,4.0791E-02,3.5264E-02,2.9386E-02,2.3311E-02,
     &1.6933E-02,9.9741E-03,9.4742E-04,5.1799E-02,4.6370E-02,4.1424E-02,
     &3.5942E-02,3.0151E-02,2.4090E-02,1.7827E-02,1.1138E-02,1.1643E-03,
     &5.1774E-02,4.6875E-02,4.2240E-02,3.6825E-02,3.1105E-02,2.5101E-02,
     &1.8967E-02,1.2189E-02,1.4467E-03,5.2049E-02,4.7822E-02,4.3286E-02,
     &3.7962E-02,3.2336E-02,2.6505E-02,2.0163E-02,1.3176E-02,1.8457E-03,
     &5.2435E-02,4.8877E-02,4.4449E-02,3.9288E-02,3.3894E-02,2.7971E-02,
     &2.1357E-02,1.4142E-02,2.2765E-03/
      DATA ((KA(JS,JT, 2, 4),JS=1,9),JT=1,5) /
     &6.9283E-02,6.1124E-02,5.3312E-02,4.5637E-02,3.7639E-02,2.9444E-02,
     &2.0926E-02,1.1987E-02,6.7708E-04,6.9230E-02,6.1365E-02,5.4052E-02,
     &4.6528E-02,3.8569E-02,3.0382E-02,2.1758E-02,1.2938E-02,8.4618E-04,
     &6.9474E-02,6.2065E-02,5.5235E-02,4.7695E-02,3.9803E-02,3.1502E-02,
     &2.2924E-02,1.3989E-02,1.0726E-03,7.0041E-02,6.3262E-02,5.6631E-02,
     &4.9140E-02,4.1246E-02,3.2954E-02,2.4393E-02,1.5061E-02,1.3926E-03,
     &7.0798E-02,6.4648E-02,5.8174E-02,5.0781E-02,4.2976E-02,3.4744E-02,
     &2.5864E-02,1.6092E-02,1.7223E-03/
      DATA ((KA(JS,JT, 3, 4),JS=1,9),JT=1,5) /
     &1.2468E-01,1.0948E-01,9.4277E-02,7.9471E-02,6.4703E-02,4.9713E-02,
     &3.4483E-02,1.8729E-02,4.6220E-04,1.2473E-01,1.0972E-01,9.4939E-02,
     &8.0505E-02,6.5924E-02,5.0895E-02,3.5571E-02,1.9546E-02,5.8785E-04,
     &1.2557E-01,1.1074E-01,9.6443E-02,8.2330E-02,6.7617E-02,5.2547E-02,
     &3.6938E-02,2.0666E-02,7.7467E-04,1.2675E-01,1.1231E-01,9.8604E-02,
     &8.4502E-02,6.9700E-02,5.4472E-02,3.8553E-02,2.2075E-02,9.9922E-04,
     &1.2846E-01,1.1449E-01,1.0119E-01,8.7016E-02,7.2084E-02,5.6669E-02,
     &4.0555E-02,2.3518E-02,1.2453E-03/
      DATA ((KA(JS,JT, 4, 4),JS=1,9),JT=1,5) /
     &2.3029E-01,2.0185E-01,1.7335E-01,1.4485E-01,1.1669E-01,8.8611E-02,
     &6.0409E-02,3.1699E-02,3.0371E-04,2.2988E-01,2.0158E-01,1.7329E-01,
     &1.4525E-01,1.1751E-01,8.9738E-02,6.1449E-02,3.2569E-02,4.0236E-04,
     &2.3229E-01,2.0393E-01,1.7566E-01,1.4780E-01,1.2020E-01,9.2062E-02,
     &6.3397E-02,3.3957E-02,5.4454E-04,2.3507E-01,2.0665E-01,1.7868E-01,
     &1.5121E-01,1.2350E-01,9.4964E-02,6.5854E-02,3.5604E-02,7.0998E-04,
     &2.3825E-01,2.0990E-01,1.8240E-01,1.5515E-01,1.2704E-01,9.8075E-02,
     &6.8384E-02,3.7494E-02,8.9536E-04/
      DATA ((KA(JS,JT, 5, 4),JS=1,9),JT=1,5) /
     &3.8945E-01,3.4103E-01,2.9259E-01,2.4415E-01,1.9571E-01,1.4754E-01,
     &9.9565E-02,5.1352E-02,2.0409E-04,3.8981E-01,3.4147E-01,2.9305E-01,
     &2.4466E-01,1.9659E-01,1.4875E-01,1.0088E-01,5.2387E-02,2.7339E-04,
     &3.9497E-01,3.4612E-01,2.9724E-01,2.4861E-01,2.0028E-01,1.5226E-01,
     &1.0369E-01,5.4177E-02,3.7984E-04,4.0149E-01,3.5204E-01,3.0270E-01,
     &2.5382E-01,2.0546E-01,1.5684E-01,1.0724E-01,5.6458E-02,5.0160E-04,
     &4.0773E-01,3.5786E-01,3.0839E-01,2.5956E-01,2.1090E-01,1.6141E-01,
     &1.1086E-01,5.8838E-02,6.4384E-04/
      DATA ((KA(JS,JT, 6, 4),JS=1,9),JT=1,5) /
     &6.2109E-01,5.4370E-01,4.6619E-01,3.8877E-01,3.1132E-01,2.3383E-01,
     &1.5671E-01,7.9602E-02,1.3341E-04,6.2314E-01,5.4556E-01,4.6793E-01,
     &3.9037E-01,3.1270E-01,2.3534E-01,1.5827E-01,8.0992E-02,1.8152E-04,
     &6.2957E-01,5.5136E-01,4.7308E-01,3.9475E-01,3.1676E-01,2.3906E-01,
     &1.6147E-01,8.3225E-02,2.5970E-04,6.4091E-01,5.6147E-01,4.8196E-01,
     &4.0265E-01,3.2370E-01,2.4515E-01,1.6638E-01,8.6255E-02,3.5139E-04,
     &6.5388E-01,5.7307E-01,4.9223E-01,4.1191E-01,3.3205E-01,2.5237E-01,
     &1.7171E-01,8.9448E-02,4.5531E-04/
      DATA ((KA(JS,JT, 7, 4),JS=1,9),JT=1,5) /
     &1.0457E+00,9.1519E-01,7.8460E-01,6.5401E-01,5.2349E-01,3.9292E-01,
     &2.6230E-01,1.3220E-01,1.0032E-04,1.0500E+00,9.1906E-01,7.8807E-01,
     &6.5699E-01,5.2599E-01,3.9492E-01,2.6410E-01,1.3358E-01,1.3899E-04,
     &1.0598E+00,9.2774E-01,7.9565E-01,6.6349E-01,5.3130E-01,3.9936E-01,
     &2.6782E-01,1.3620E-01,1.8444E-04,1.0743E+00,9.4059E-01,8.0685E-01,
     &6.7311E-01,5.3945E-01,4.0621E-01,2.7331E-01,1.3995E-01,2.4657E-04,
     &1.0996E+00,9.6289E-01,8.2608E-01,6.8953E-01,5.5342E-01,4.1738E-01,
     &2.8182E-01,1.4485E-01,3.2431E-04/
      DATA ((KA(JS,JT, 8, 4),JS=1,9),JT=1,5) /
     &2.1071E+00,1.8438E+00,1.5804E+00,1.3173E+00,1.0540E+00,7.9071E-01,
     &5.2749E-01,2.6416E-01,1.1085E-04,2.1142E+00,1.8501E+00,1.5861E+00,
     &1.3219E+00,1.0578E+00,7.9379E-01,5.2971E-01,2.6585E-01,1.4810E-04,
     &2.1318E+00,1.8656E+00,1.5995E+00,1.3333E+00,1.0671E+00,8.0094E-01,
     &5.3475E-01,2.6918E-01,1.9501E-04,2.1555E+00,1.8865E+00,1.6175E+00,
     &1.3486E+00,1.0795E+00,8.1059E-01,5.4205E-01,2.7386E-01,2.4224E-04,
     &2.2062E+00,1.9311E+00,1.6560E+00,1.3807E+00,1.1056E+00,8.3087E-01,
     &5.5626E-01,2.8214E-01,2.8558E-04/
      DATA ((KA(JS,JT, 9, 4),JS=1,9),JT=1,5) /
     &7.9972E+00,6.9979E+00,5.9979E+00,4.9986E+00,3.9987E+00,2.9994E+00,
     &1.9999E+00,1.0002E+00,1.8668E-04,8.0128E+00,7.0114E+00,6.0097E+00,
     &5.0085E+00,4.0070E+00,3.0056E+00,2.0042E+00,1.0027E+00,2.5150E-04,
     &8.0805E+00,7.0702E+00,6.0607E+00,5.0509E+00,4.0412E+00,3.0319E+00,
     &2.0219E+00,1.0119E+00,3.0396E-04,8.1743E+00,7.1533E+00,6.1315E+00,
     &5.1108E+00,4.0892E+00,3.0678E+00,2.0462E+00,1.0247E+00,3.5321E-04,
     &8.3409E+00,7.2988E+00,6.2567E+00,5.2146E+00,4.1728E+00,3.1306E+00,
     &2.0885E+00,1.0471E+00,4.4198E-04/
      DATA ((KA(JS,JT,10, 4),JS=1,9),JT=1,5) /
     &3.3771E+01,2.9548E+01,2.5328E+01,2.1105E+01,1.6886E+01,1.2665E+01,
     &8.4427E+00,4.2216E+00,4.3200E-04,3.3810E+01,2.9587E+01,2.5358E+01,
     &2.1131E+01,1.6905E+01,1.2680E+01,8.4534E+00,4.2274E+00,5.4393E-04,
     &3.4144E+01,2.9876E+01,2.5609E+01,2.1340E+01,1.7073E+01,1.2805E+01,
     &8.5375E+00,4.2697E+00,6.4726E-04,3.4577E+01,3.0255E+01,2.5934E+01,
     &2.1613E+01,1.7291E+01,1.2969E+01,8.6471E+00,4.3251E+00,7.9967E-04,
     &3.5279E+01,3.0869E+01,2.6459E+01,2.2050E+01,1.7642E+01,1.3232E+01,
     &8.8233E+00,4.4139E+00,8.8613E-04/
      DATA ((KA(JS,JT,11, 4),JS=1,9),JT=1,5) /
     &4.9379E+01,4.3210E+01,3.7035E+01,3.0865E+01,2.4692E+01,1.8519E+01,
     &1.2346E+01,6.1734E+00,5.9531E-04,4.9664E+01,4.3455E+01,3.7247E+01,
     &3.1040E+01,2.4833E+01,1.8625E+01,1.2417E+01,6.2092E+00,7.3911E-04,
     &5.0351E+01,4.4056E+01,3.7762E+01,3.1470E+01,2.5175E+01,1.8882E+01,
     &1.2589E+01,6.2954E+00,9.0535E-04,5.1310E+01,4.4899E+01,3.8484E+01,
     &3.2071E+01,2.5657E+01,1.9244E+01,1.2831E+01,6.4171E+00,1.0300E-03,
     &5.2691E+01,4.6105E+01,3.9519E+01,3.2933E+01,2.6348E+01,1.9763E+01,
     &1.3176E+01,6.5918E+00,1.3056E-03/
      DATA ((KA(JS,JT,12, 4),JS=1,9),JT=1,5) /
     &5.3682E+01,4.6971E+01,4.0260E+01,3.3552E+01,2.6842E+01,2.0131E+01,
     &1.3420E+01,6.7107E+00,5.9618E-04,5.4209E+01,4.7433E+01,4.0657E+01,
     &3.3879E+01,2.7104E+01,2.0329E+01,1.3553E+01,6.7772E+00,7.6649E-04,
     &5.5191E+01,4.8293E+01,4.1395E+01,3.4495E+01,2.7597E+01,2.0697E+01,
     &1.3799E+01,6.9009E+00,9.6570E-04,5.6606E+01,4.9530E+01,4.2455E+01,
     &3.5382E+01,2.8306E+01,2.1230E+01,1.4154E+01,7.0794E+00,1.1503E-03,
     &5.8604E+01,5.1279E+01,4.3956E+01,3.6631E+01,2.9306E+01,2.1982E+01,
     &1.4657E+01,7.3321E+00,1.3037E-03/
      DATA ((KA(JS,JT,13, 4),JS=1,9),JT=1,5) /
     &4.6897E+01,4.1036E+01,3.5173E+01,2.9311E+01,2.3449E+01,1.7586E+01,
     &1.1724E+01,5.8626E+00,5.3404E-04,4.7510E+01,4.1569E+01,3.5631E+01,
     &2.9695E+01,2.3756E+01,1.7817E+01,1.1878E+01,5.9396E+00,7.0585E-04,
     &4.8599E+01,4.2525E+01,3.6450E+01,3.0375E+01,2.4299E+01,1.8226E+01,
     &1.2152E+01,6.0774E+00,8.6599E-04,5.0122E+01,4.3856E+01,3.7591E+01,
     &3.1328E+01,2.5063E+01,1.8798E+01,1.2534E+01,6.2697E+00,1.0053E-03,
     &5.2215E+01,4.5689E+01,3.9164E+01,3.2638E+01,2.6111E+01,1.9586E+01,
     &1.3060E+01,6.5334E+00,1.2313E-03/
      DATA ((KA(JS,JT, 1, 5),JS=1,9),JT=1,5) /
     &8.2901E-02,7.3924E-02,6.4657E-02,5.5597E-02,4.6472E-02,3.6796E-02,
     &2.6709E-02,1.5948E-02,1.7802E-03,8.3370E-02,7.4618E-02,6.5698E-02,
     &5.7019E-02,4.7812E-02,3.7978E-02,2.7855E-02,1.7146E-02,2.3935E-03,
     &8.4235E-02,7.5730E-02,6.7257E-02,5.8667E-02,4.9229E-02,3.9298E-02,
     &2.8966E-02,1.8334E-02,3.0382E-03,8.5176E-02,7.7019E-02,6.8972E-02,
     &6.0287E-02,5.0680E-02,4.0612E-02,3.0271E-02,1.9679E-02,3.7478E-03,
     &8.6230E-02,7.8450E-02,7.0705E-02,6.1832E-02,5.2066E-02,4.2065E-02,
     &3.1638E-02,2.1127E-02,4.5344E-03/
      DATA ((KA(JS,JT, 2, 5),JS=1,9),JT=1,5) /
     &1.1319E-01,1.0032E-01,8.7141E-02,7.4086E-02,6.1196E-02,4.7903E-02,
     &3.4053E-02,1.9479E-02,1.3324E-03,1.1444E-01,1.0174E-01,8.8783E-02,
     &7.6019E-02,6.3135E-02,4.9508E-02,3.5403E-02,2.0488E-02,1.7827E-03,
     &1.1608E-01,1.0349E-01,9.0802E-02,7.8322E-02,6.5118E-02,5.1198E-02,
     &3.6801E-02,2.1623E-02,2.2789E-03,1.1786E-01,1.0545E-01,9.3147E-02,
     &8.0587E-02,6.7042E-02,5.2943E-02,3.8201E-02,2.2798E-02,2.8272E-03,
     &1.1969E-01,1.0757E-01,9.5567E-02,8.2763E-02,6.8961E-02,5.4626E-02,
     &3.9785E-02,2.4020E-02,3.4454E-03/
      DATA ((KA(JS,JT, 3, 5),JS=1,9),JT=1,5) /
     &2.0690E-01,1.8215E-01,1.5725E-01,1.3219E-01,1.0725E-01,8.2467E-02,
     &5.7330E-02,3.1338E-02,9.1573E-04,2.1013E-01,1.8537E-01,1.6026E-01,
     &1.3517E-01,1.1017E-01,8.5255E-02,5.9448E-02,3.2689E-02,1.2507E-03,
     &2.1385E-01,1.8904E-01,1.6379E-01,1.3865E-01,1.1374E-01,8.8133E-02,
     &6.1604E-02,3.4070E-02,1.6182E-03,2.1772E-01,1.9276E-01,1.6753E-01,
     &1.4253E-01,1.1723E-01,9.0813E-02,6.3766E-02,3.5513E-02,2.0311E-03,
     &2.2143E-01,1.9638E-01,1.7123E-01,1.4633E-01,1.2052E-01,9.3556E-02,
     &6.5944E-02,3.7115E-02,2.5088E-03/
      DATA ((KA(JS,JT, 4, 5),JS=1,9),JT=1,5) /
     &3.8507E-01,3.3780E-01,2.9048E-01,2.4314E-01,1.9570E-01,1.4827E-01,
     &1.0100E-01,5.3296E-02,6.2147E-04,3.9146E-01,3.4379E-01,2.9605E-01,
     &2.4819E-01,2.0018E-01,1.5228E-01,1.0449E-01,5.5540E-02,8.6088E-04,
     &3.9930E-01,3.5111E-01,3.0278E-01,2.5411E-01,2.0550E-01,1.5718E-01,
     &1.0825E-01,5.7768E-02,1.1308E-03,4.0750E-01,3.5883E-01,3.0957E-01,
     &2.6026E-01,2.1112E-01,1.6215E-01,1.1175E-01,5.9905E-02,1.4435E-03,
     &4.1540E-01,3.6624E-01,3.1618E-01,2.6641E-01,2.1709E-01,1.6699E-01,
     &1.1521E-01,6.2079E-02,1.8081E-03/
      DATA ((KA(JS,JT, 5, 5),JS=1,9),JT=1,5) /
     &6.6039E-01,5.7849E-01,4.9659E-01,4.1465E-01,3.3268E-01,2.5068E-01,
     &1.6878E-01,8.6906E-02,4.1392E-04,6.7138E-01,5.8843E-01,5.0538E-01,
     &4.2238E-01,3.3940E-01,2.5633E-01,1.7334E-01,9.0010E-02,5.9039E-04,
     &6.8434E-01,6.0014E-01,5.1596E-01,4.3167E-01,3.4721E-01,2.6273E-01,
     &1.7850E-01,9.3277E-02,7.8856E-04,6.9935E-01,6.1381E-01,5.2821E-01,
     &4.4224E-01,3.5606E-01,2.7005E-01,1.8435E-01,9.6630E-02,1.0256E-03,
     &7.1524E-01,6.2827E-01,5.4104E-01,4.5319E-01,3.6550E-01,2.7828E-01,
     &1.9025E-01,9.9988E-02,1.3023E-03/
      DATA ((KA(JS,JT, 6, 5),JS=1,9),JT=1,5) /
     &1.0605E+00,9.2835E-01,7.9638E-01,6.6416E-01,5.3204E-01,3.9988E-01,
     &2.6772E-01,1.3599E-01,2.6665E-04,1.0793E+00,9.4508E-01,8.1097E-01,
     &6.7669E-01,5.4239E-01,4.0816E-01,2.7396E-01,1.4011E-01,3.9578E-04,
     &1.0996E+00,9.6312E-01,8.2674E-01,6.9026E-01,5.5385E-01,4.1734E-01,
     &2.8093E-01,1.4437E-01,5.4281E-04,1.1270E+00,9.8758E-01,8.4814E-01,
     &7.0877E-01,5.6910E-01,4.2937E-01,2.8968E-01,1.4948E-01,7.1692E-04,
     &1.1549E+00,1.0125E+00,8.7022E-01,7.2764E-01,5.8478E-01,4.4170E-01,
     &2.9907E-01,1.5477E-01,9.2735E-04/
      DATA ((KA(JS,JT, 7, 5),JS=1,9),JT=1,5) /
     &1.7902E+00,1.5666E+00,1.3432E+00,1.1198E+00,8.9630E-01,6.7291E-01,
     &4.4939E-01,2.2594E-01,1.7788E-04,1.8253E+00,1.5977E+00,1.3701E+00,
     &1.1424E+00,9.1476E-01,6.8709E-01,4.5936E-01,2.3207E-01,2.6007E-04,
     &1.8661E+00,1.6335E+00,1.4010E+00,1.1685E+00,9.3601E-01,7.0359E-01,
     &4.7118E-01,2.3911E-01,3.6579E-04,1.9131E+00,1.6751E+00,1.4368E+00,
     &1.1989E+00,9.6095E-01,7.2299E-01,4.8503E-01,2.4706E-01,4.9009E-04,
     &1.9618E+00,1.7182E+00,1.4745E+00,1.2310E+00,9.8739E-01,7.4364E-01,
     &4.9951E-01,2.5543E-01,6.4417E-04/
      DATA ((KA(JS,JT, 8, 5),JS=1,9),JT=1,5) /
     &3.6222E+00,3.1697E+00,2.7175E+00,2.2647E+00,1.8122E+00,1.3595E+00,
     &9.0703E-01,4.5436E-01,1.7700E-04,3.6989E+00,3.2367E+00,2.7747E+00,
     &2.3129E+00,1.8509E+00,1.3888E+00,9.2689E-01,4.6487E-01,2.2396E-04,
     &3.7900E+00,3.3168E+00,2.8434E+00,2.3702E+00,1.8972E+00,1.4240E+00,
     &9.5085E-01,4.7797E-01,2.7417E-04,3.8908E+00,3.4054E+00,2.9198E+00,
     &2.4343E+00,1.9488E+00,1.4634E+00,9.7805E-01,4.9296E-01,3.4875E-04,
     &3.9856E+00,3.4886E+00,2.9916E+00,2.4947E+00,1.9978E+00,1.5012E+00,
     &1.0044E+00,5.0758E-01,4.5934E-04/
      DATA ((KA(JS,JT, 9, 5),JS=1,9),JT=1,5) /
     &1.3794E+01,1.2070E+01,1.0346E+01,8.6224E+00,6.8983E+00,5.1738E+00,
     &3.4497E+00,1.7256E+00,2.3317E-04,1.4093E+01,1.2332E+01,1.0571E+01,
     &8.8090E+00,7.0478E+00,5.2864E+00,3.5250E+00,1.7636E+00,2.9550E-04,
     &1.4464E+01,1.2658E+01,1.0848E+01,9.0415E+00,7.2337E+00,5.4264E+00,
     &3.6184E+00,1.8107E+00,3.8639E-04,1.4855E+01,1.2999E+01,1.1143E+01,
     &9.2862E+00,7.4306E+00,5.5737E+00,3.7173E+00,1.8614E+00,5.0786E-04,
     &1.5210E+01,1.3311E+01,1.1410E+01,9.5097E+00,7.6091E+00,5.7087E+00,
     &3.8087E+00,1.9087E+00,5.8982E-04/
      DATA ((KA(JS,JT,10, 5),JS=1,9),JT=1,5) /
     &5.8496E+01,5.1180E+01,4.3867E+01,3.6556E+01,2.9247E+01,2.1935E+01,
     &1.4623E+01,7.3123E+00,5.6403E-04,5.9786E+01,5.2317E+01,4.4840E+01,
     &3.7369E+01,2.9895E+01,2.2423E+01,1.4947E+01,7.4749E+00,6.9685E-04,
     &6.1366E+01,5.3692E+01,4.6022E+01,3.8353E+01,3.0682E+01,2.3012E+01,
     &1.5344E+01,7.6729E+00,8.6661E-04,6.3002E+01,5.5128E+01,4.7254E+01,
     &3.9377E+01,3.1505E+01,2.3630E+01,1.5753E+01,7.8780E+00,1.0403E-03,
     &6.4493E+01,5.6436E+01,4.8374E+01,4.0310E+01,3.2253E+01,2.4189E+01,
     &1.6127E+01,8.0668E+00,1.2361E-03/
      DATA ((KA(JS,JT,11, 5),JS=1,9),JT=1,5) /
     &8.7182E+01,7.6287E+01,6.5394E+01,5.4493E+01,4.3594E+01,3.2696E+01,
     &2.1798E+01,1.0900E+01,7.4362E-04,8.9336E+01,7.8172E+01,6.7002E+01,
     &5.5836E+01,4.4668E+01,3.3502E+01,2.2335E+01,1.1168E+01,9.0702E-04,
     &9.1581E+01,8.0131E+01,6.8688E+01,5.7237E+01,4.5792E+01,3.4345E+01,
     &2.2896E+01,1.1449E+01,1.0809E-03,9.3839E+01,8.2107E+01,7.0383E+01,
     &5.8658E+01,4.6921E+01,3.5193E+01,2.3462E+01,1.1732E+01,1.3235E-03,
     &9.5958E+01,8.3967E+01,7.1970E+01,5.9973E+01,4.7982E+01,3.5987E+01,
     &2.3994E+01,1.1998E+01,1.5458E-03/
      DATA ((KA(JS,JT,12, 5),JS=1,9),JT=1,5) /
     &9.6680E+01,8.4597E+01,7.2516E+01,6.0430E+01,4.8347E+01,3.6257E+01,
     &2.4172E+01,1.2087E+01,8.8792E-04,9.9039E+01,8.6662E+01,7.4284E+01,
     &6.1903E+01,4.9522E+01,3.7144E+01,2.4762E+01,1.2382E+01,1.0348E-03,
     &1.0152E+02,8.8834E+01,7.6150E+01,6.3450E+01,5.0765E+01,3.8071E+01,
     &2.5383E+01,1.2692E+01,1.2734E-03,1.0389E+02,9.0902E+01,7.7912E+01,
     &6.4935E+01,5.1946E+01,3.8960E+01,2.5973E+01,1.2989E+01,1.5461E-03,
     &1.0614E+02,9.2872E+01,7.9616E+01,6.6343E+01,5.3076E+01,3.9807E+01,
     &2.6538E+01,1.3271E+01,1.7863E-03/
      DATA ((KA(JS,JT,13, 5),JS=1,9),JT=1,5) /
     &8.5924E+01,7.5190E+01,6.4446E+01,5.3705E+01,4.2964E+01,3.2222E+01,
     &2.1482E+01,1.0742E+01,9.3650E-04,8.8011E+01,7.7009E+01,6.6010E+01,
     &5.5012E+01,4.4009E+01,3.3008E+01,2.2004E+01,1.1003E+01,1.0453E-03,
     &9.0165E+01,7.8893E+01,6.7623E+01,5.6350E+01,4.5080E+01,3.3811E+01,
     &2.2542E+01,1.1273E+01,1.2632E-03,9.2294E+01,8.0759E+01,6.9218E+01,
     &5.7683E+01,4.6146E+01,3.4609E+01,2.3075E+01,1.1539E+01,1.5901E-03,
     &9.4515E+01,8.2699E+01,7.0891E+01,5.9075E+01,4.7260E+01,3.5445E+01,
     &2.3631E+01,1.1818E+01,1.9283E-03/
      DATA ((KA(JS,JT, 1, 6),JS=1,9),JT=1,5) /
     &1.3664E-01,1.2142E-01,1.0604E-01,9.0673E-02,7.5307E-02,5.9951E-02,
     &4.4049E-02,2.7037E-02,3.4200E-03,1.3479E-01,1.2041E-01,1.0581E-01,
     &9.1114E-02,7.6669E-02,6.1851E-02,4.6009E-02,2.9151E-02,4.4244E-03,
     &1.3313E-01,1.1956E-01,1.0561E-01,9.1887E-02,7.8237E-02,6.3771E-02,
     &4.8109E-02,3.1604E-02,5.5644E-03,1.3195E-01,1.1904E-01,1.0583E-01,
     &9.3212E-02,7.9889E-02,6.5652E-02,5.0318E-02,3.4334E-02,6.8097E-03,
     &1.3100E-01,1.1871E-01,1.0645E-01,9.4491E-02,8.1510E-02,6.7455E-02,
     &5.2648E-02,3.7142E-02,8.1798E-03/
      DATA ((KA(JS,JT, 2, 6),JS=1,9),JT=1,5) /
     &1.8948E-01,1.6745E-01,1.4512E-01,1.2300E-01,1.0098E-01,7.9021E-02,
     &5.6595E-02,3.3068E-02,2.5064E-03,1.8719E-01,1.6582E-01,1.4439E-01,
     &1.2310E-01,1.0186E-01,8.0667E-02,5.8428E-02,3.4918E-02,3.2805E-03,
     &1.8550E-01,1.6475E-01,1.4416E-01,1.2351E-01,1.0330E-01,8.2465E-02,
     &6.0314E-02,3.6962E-02,4.1499E-03,1.8451E-01,1.6460E-01,1.4454E-01,
     &1.2487E-01,1.0515E-01,8.4419E-02,6.2353E-02,3.9320E-02,5.1265E-03,
     &1.8423E-01,1.6501E-01,1.4553E-01,1.2672E-01,1.0715E-01,8.6338E-02,
     &6.4353E-02,4.1893E-02,6.2102E-03/
      DATA ((KA(JS,JT, 3, 6),JS=1,9),JT=1,5) /
     &3.5249E-01,3.0976E-01,2.6683E-01,2.2378E-01,1.8098E-01,1.3846E-01,
     &9.6219E-02,5.2862E-02,1.7476E-03,3.4945E-01,3.0729E-01,2.6503E-01,
     &2.2304E-01,1.8135E-01,1.3971E-01,9.8147E-02,5.4704E-02,2.3082E-03,
     &3.4786E-01,3.0616E-01,2.6475E-01,2.2367E-01,1.8257E-01,1.4178E-01,
     &1.0043E-01,5.6633E-02,2.9556E-03,3.4805E-01,3.0690E-01,2.6623E-01,
     &2.2552E-01,1.8508E-01,1.4480E-01,1.0306E-01,5.8846E-02,3.6970E-03,
     &3.5013E-01,3.0948E-01,2.6918E-01,2.2850E-01,1.8865E-01,1.4799E-01,
     &1.0568E-01,6.1131E-02,4.5281E-03/
      DATA ((KA(JS,JT, 4, 6),JS=1,9),JT=1,5) /
     &6.6623E-01,5.8386E-01,5.0153E-01,4.1899E-01,3.3640E-01,2.5407E-01,
     &1.7225E-01,9.1058E-02,1.1958E-03,6.6340E-01,5.8167E-01,4.9974E-01,
     &4.1776E-01,3.3619E-01,2.5503E-01,1.7423E-01,9.3289E-02,1.6080E-03,
     &6.6480E-01,5.8306E-01,5.0121E-01,4.1990E-01,3.3893E-01,2.5818E-01,
     &1.7768E-01,9.5987E-02,2.0929E-03,6.7003E-01,5.8789E-01,5.0627E-01,
     &4.2518E-01,3.4417E-01,2.6306E-01,1.8230E-01,9.9134E-02,2.6527E-03,
     &6.7815E-01,5.9566E-01,5.1416E-01,4.3281E-01,3.5098E-01,2.6952E-01,
     &1.8764E-01,1.0249E-01,3.2896E-03/
      DATA ((KA(JS,JT, 5, 6),JS=1,9),JT=1,5) /
     &1.1550E+00,1.0112E+00,8.6772E-01,7.2399E-01,5.8018E-01,4.3620E-01,
     &2.9244E-01,1.4976E-01,8.1069E-04,1.1564E+00,1.0128E+00,8.6891E-01,
     &7.2534E-01,5.8147E-01,4.3781E-01,2.9477E-01,1.5282E-01,1.1157E-03,
     &1.1669E+00,1.0223E+00,8.7752E-01,7.3265E-01,5.8799E-01,4.4399E-01,
     &3.0054E-01,1.5735E-01,1.4779E-03,1.1830E+00,1.0368E+00,8.9030E-01,
     &7.4407E-01,5.9861E-01,4.5354E-01,3.0826E-01,1.6275E-01,1.9001E-03,
     &1.2016E+00,1.0534E+00,9.0529E-01,7.5813E-01,6.1140E-01,4.6432E-01,
     &3.1746E-01,1.6866E-01,2.3885E-03/
      DATA ((KA(JS,JT, 6, 6),JS=1,9),JT=1,5) /
     &1.8728E+00,1.6394E+00,1.4057E+00,1.1724E+00,9.3873E-01,7.0502E-01,
     &4.7119E-01,2.3746E-01,5.3401E-04,1.8855E+00,1.6506E+00,1.4159E+00,
     &1.1808E+00,9.4575E-01,7.1049E-01,4.7534E-01,2.4122E-01,7.5510E-04,
     &1.9127E+00,1.6747E+00,1.4367E+00,1.1985E+00,9.6017E-01,7.2202E-01,
     &4.8438E-01,2.4807E-01,1.0228E-03,1.9458E+00,1.7041E+00,1.4622E+00,
     &1.2202E+00,9.7826E-01,7.3694E-01,4.9644E-01,2.5634E-01,1.3413E-03,
     &1.9819E+00,1.7360E+00,1.4899E+00,1.2440E+00,9.9883E-01,7.5442E-01,
     &5.0981E-01,2.6524E-01,1.7130E-03/
      DATA ((KA(JS,JT, 7, 6),JS=1,9),JT=1,5) /
     &3.1956E+00,2.7964E+00,2.3973E+00,1.9983E+00,1.5994E+00,1.2005E+00,
     &8.0140E-01,4.0204E-01,3.4739E-04,3.2319E+00,2.8287E+00,2.4254E+00,
     &2.0219E+00,1.6186E+00,1.2150E+00,8.1138E-01,4.0767E-01,4.9767E-04,
     &3.2870E+00,2.8773E+00,2.4673E+00,2.0573E+00,1.6471E+00,1.2367E+00,
     &8.2648E-01,4.1699E-01,6.8883E-04,3.3536E+00,2.9357E+00,2.5178E+00,
     &2.0997E+00,1.6816E+00,1.2633E+00,8.4550E-01,4.2915E-01,9.2075E-04,
     &3.4247E+00,2.9983E+00,2.5718E+00,2.1451E+00,1.7185E+00,1.2924E+00,
     &8.6745E-01,4.4266E-01,1.1994E-03/
      DATA ((KA(JS,JT, 8, 6),JS=1,9),JT=1,5) /
     &6.5522E+00,5.7333E+00,4.9154E+00,4.0958E+00,3.2773E+00,2.4586E+00,
     &1.6399E+00,8.2128E-01,2.5000E-04,6.6534E+00,5.8224E+00,4.9909E+00,
     &4.1598E+00,3.3284E+00,2.4975E+00,1.6667E+00,8.3486E-01,3.5933E-04,
     &6.7871E+00,5.9396E+00,5.0919E+00,4.2443E+00,3.3968E+00,2.5492E+00,
     &1.7012E+00,8.5283E-01,4.9387E-04,6.9317E+00,6.0662E+00,5.2009E+00,
     &4.3357E+00,3.4705E+00,2.6048E+00,1.7389E+00,8.7334E-01,6.4756E-04,
     &7.0935E+00,6.2081E+00,5.3230E+00,4.4380E+00,3.5524E+00,2.6671E+00,
     &1.7815E+00,8.9762E-01,8.2195E-04/
      DATA ((KA(JS,JT, 9, 6),JS=1,9),JT=1,5) /
     &2.5444E+01,2.2265E+01,1.9084E+01,1.5904E+01,1.2723E+01,9.5428E+00,
     &6.3622E+00,3.1820E+00,4.0178E-04,2.5907E+01,2.2668E+01,1.9432E+01,
     &1.6194E+01,1.2956E+01,9.7177E+00,6.4794E+00,3.2416E+00,4.9820E-04,
     &2.6491E+01,2.3181E+01,1.9870E+01,1.6559E+01,1.3249E+01,9.9392E+00,
     &6.6274E+00,3.3163E+00,5.8675E-04,2.7100E+01,2.3714E+01,2.0326E+01,
     &1.6941E+01,1.3555E+01,1.0168E+01,6.7813E+00,3.3943E+00,7.0841E-04,
     &2.7765E+01,2.4297E+01,2.0827E+01,1.7358E+01,1.3889E+01,1.0420E+01,
     &6.9499E+00,3.4794E+00,8.5424E-04/
      DATA ((KA(JS,JT,10, 6),JS=1,9),JT=1,5) /
     &1.1023E+02,9.6432E+01,8.2664E+01,6.8898E+01,5.5114E+01,4.1339E+01,
     &2.7555E+01,1.3778E+01,8.1537E-04,1.1247E+02,9.8427E+01,8.4346E+01,
     &7.0300E+01,5.6236E+01,4.2180E+01,2.8118E+01,1.4061E+01,9.9310E-04,
     &1.1514E+02,1.0076E+02,8.6358E+01,7.1971E+01,5.7576E+01,4.3183E+01,
     &2.8789E+01,1.4396E+01,1.1831E-03,1.1802E+02,1.0327E+02,8.8510E+01,
     &7.3765E+01,5.9016E+01,4.4263E+01,2.9511E+01,1.4759E+01,1.3868E-03,
     &1.2130E+02,1.0614E+02,9.0978E+01,7.5815E+01,6.0657E+01,4.5493E+01,
     &3.0333E+01,1.5172E+01,1.7070E-03/
      DATA ((KA(JS,JT,11, 6),JS=1,9),JT=1,5) /
     &1.6690E+02,1.4603E+02,1.2516E+02,1.0431E+02,8.3442E+01,6.2583E+01,
     &4.1722E+01,2.0862E+01,1.5727E-03,1.7086E+02,1.4949E+02,1.2814E+02,
     &1.0678E+02,8.5424E+01,6.4067E+01,4.2718E+01,2.1360E+01,1.6234E-03,
     &1.7519E+02,1.5329E+02,1.3139E+02,1.0949E+02,8.7589E+01,6.5698E+01,
     &4.3799E+01,2.1903E+01,1.7884E-03,1.8016E+02,1.5762E+02,1.3510E+02,
     &1.1259E+02,9.0076E+01,6.7557E+01,4.5039E+01,2.2524E+01,2.1215E-03,
     &1.8518E+02,1.6203E+02,1.3888E+02,1.1573E+02,9.2591E+01,6.9449E+01,
     &4.6302E+01,2.3157E+01,2.4813E-03/
      DATA ((KA(JS,JT,12, 6),JS=1,9),JT=1,5) /
     &1.8707E+02,1.6368E+02,1.4030E+02,1.1692E+02,9.3541E+01,7.0153E+01,
     &4.6766E+01,2.3384E+01,1.9770E-03,1.9183E+02,1.6788E+02,1.4389E+02,
     &1.1990E+02,9.5932E+01,7.1949E+01,4.7966E+01,2.3985E+01,2.1043E-03,
     &1.9710E+02,1.7246E+02,1.4784E+02,1.2320E+02,9.8552E+01,7.3917E+01,
     &4.9278E+01,2.4644E+01,2.2289E-03,2.0265E+02,1.7731E+02,1.5198E+02,
     &1.2666E+02,1.0133E+02,7.5997E+01,5.0665E+01,2.5338E+01,2.5070E-03,
     &2.0830E+02,1.8227E+02,1.5623E+02,1.3019E+02,1.0416E+02,7.8120E+01,
     &5.2086E+01,2.6047E+01,2.9426E-03/
      DATA ((KA(JS,JT,13, 6),JS=1,9),JT=1,5) /
     &1.6768E+02,1.4672E+02,1.2576E+02,1.0480E+02,8.3836E+01,6.2874E+01,
     &4.1918E+01,2.0960E+01,1.9900E-03,1.7225E+02,1.5072E+02,1.2919E+02,
     &1.0767E+02,8.6132E+01,6.4601E+01,4.3064E+01,2.1534E+01,2.2115E-03,
     &1.7710E+02,1.5497E+02,1.3283E+02,1.1069E+02,8.8549E+01,6.6413E+01,
     &4.4281E+01,2.2144E+01,2.4087E-03,1.8201E+02,1.5926E+02,1.3651E+02,
     &1.1376E+02,9.1007E+01,6.8257E+01,4.5512E+01,2.2758E+01,2.6872E-03,
     &1.8703E+02,1.6366E+02,1.4029E+02,1.1690E+02,9.3529E+01,7.0144E+01,
     &4.6769E+01,2.3390E+01,2.9430E-03/
      DATA ((KA(JS,JT, 1, 7),JS=1,9),JT=1,5) /
     &2.6412E-01,2.3209E-01,2.0136E-01,1.7041E-01,1.3987E-01,1.0997E-01,
     &7.9977E-02,4.8294E-02,7.1406E-03,2.6114E-01,2.3041E-01,2.0084E-01,
     &1.7141E-01,1.4253E-01,1.1370E-01,8.4426E-02,5.2292E-02,9.2339E-03,
     &2.5746E-01,2.2846E-01,2.0043E-01,1.7294E-01,1.4558E-01,1.1774E-01,
     &8.8686E-02,5.6161E-02,1.1607E-02,2.5329E-01,2.2641E-01,2.0046E-01,
     &1.7465E-01,1.4868E-01,1.2202E-01,9.2933E-02,6.0129E-02,1.4258E-02,
     &2.4914E-01,2.2449E-01,2.0080E-01,1.7670E-01,1.5234E-01,1.2632E-01,
     &9.7469E-02,6.4803E-02,1.7193E-02/
      DATA ((KA(JS,JT, 2, 7),JS=1,9),JT=1,5) /
     &3.8226E-01,3.3530E-01,2.8943E-01,2.4384E-01,1.9786E-01,1.5259E-01,
     &1.0817E-01,6.3161E-02,5.4372E-03,3.7769E-01,3.3226E-01,2.8798E-01,
     &2.4326E-01,1.9923E-01,1.5589E-01,1.1262E-01,6.7329E-02,7.0870E-03,
     &3.7182E-01,3.2842E-01,2.8559E-01,2.4304E-01,2.0123E-01,1.5952E-01,
     &1.1734E-01,7.1516E-02,8.9693E-03,3.6545E-01,3.2421E-01,2.8324E-01,
     &2.4318E-01,2.0343E-01,1.6337E-01,1.2179E-01,7.5704E-02,1.1062E-02,
     &3.5934E-01,3.2018E-01,2.8184E-01,2.4404E-01,2.0628E-01,1.6781E-01,
     &1.2654E-01,8.0391E-02,1.3382E-02/
      DATA ((KA(JS,JT, 3, 7),JS=1,9),JT=1,5) /
     &7.3419E-01,6.4302E-01,5.5249E-01,4.6249E-01,3.7279E-01,2.8244E-01,
     &1.9254E-01,1.0461E-01,3.8320E-03,7.2438E-01,6.3531E-01,5.4697E-01,
     &4.5910E-01,3.7055E-01,2.8234E-01,1.9553E-01,1.0953E-01,5.0607E-03,
     &7.1308E-01,6.2644E-01,5.4060E-01,4.5437E-01,3.6826E-01,2.8333E-01,
     &1.9916E-01,1.1441E-01,6.4784E-03,7.0097E-01,6.1696E-01,5.3353E-01,
     &4.4963E-01,3.6700E-01,2.8530E-01,2.0351E-01,1.1914E-01,8.0908E-03,
     &6.8962E-01,6.0838E-01,5.2688E-01,4.4648E-01,3.6708E-01,2.8814E-01,
     &2.0859E-01,1.2387E-01,9.8988E-03/
      DATA ((KA(JS,JT, 4, 7),JS=1,9),JT=1,5) /
     &1.4238E+00,1.2465E+00,1.0693E+00,8.9242E-01,7.1591E-01,5.3976E-01,
     &3.6322E-01,1.8668E-01,2.6351E-03,1.4051E+00,1.2306E+00,1.0566E+00,
     &8.8285E-01,7.0951E-01,5.3582E-01,3.6165E-01,1.8980E-01,3.5337E-03,
     &1.3826E+00,1.2117E+00,1.0413E+00,8.7137E-01,7.0120E-01,5.3024E-01,
     &3.6085E-01,1.9367E-01,4.5912E-03,1.3609E+00,1.1937E+00,1.0271E+00,
     &8.6049E-01,6.9280E-01,5.2650E-01,3.6231E-01,1.9848E-01,5.8142E-03,
     &1.3409E+00,1.1773E+00,1.0140E+00,8.4932E-01,6.8606E-01,5.2486E-01,
     &3.6482E-01,2.0369E-01,7.2048E-03/
      DATA ((KA(JS,JT, 5, 7),JS=1,9),JT=1,5) /
     &2.5206E+00,2.2062E+00,1.8917E+00,1.5773E+00,1.2631E+00,9.4923E-01,
     &6.3588E-01,3.2194E-01,1.8039E-03,2.4864E+00,2.1765E+00,1.8669E+00,
     &1.5575E+00,1.2483E+00,9.3953E-01,6.3051E-01,3.2080E-01,2.4598E-03,
     &2.4502E+00,2.1455E+00,1.8410E+00,1.5370E+00,1.2333E+00,9.2942E-01,
     &6.2403E-01,3.2160E-01,3.2471E-03,2.4176E+00,2.1177E+00,1.8181E+00,
     &1.5189E+00,1.2193E+00,9.1845E-01,6.1937E-01,3.2415E-01,4.1727E-03,
     &2.3943E+00,2.0977E+00,1.8015E+00,1.5055E+00,1.2082E+00,9.1210E-01,
     &6.1892E-01,3.2856E-01,5.2383E-03/
      DATA ((KA(JS,JT, 6, 7),JS=1,9),JT=1,5) /
     &4.1535E+00,3.6349E+00,3.1163E+00,2.5976E+00,2.0789E+00,1.5604E+00,
     &1.0424E+00,5.2499E-01,1.2119E-03,4.0999E+00,3.5882E+00,3.0765E+00,
     &2.5650E+00,2.0536E+00,1.5426E+00,1.0319E+00,5.2076E-01,1.6878E-03,
     &4.0501E+00,3.5452E+00,3.0400E+00,2.5354E+00,2.0310E+00,1.5269E+00,
     &1.0226E+00,5.1681E-01,2.2703E-03,4.0172E+00,3.5170E+00,3.0163E+00,
     &2.5163E+00,2.0166E+00,1.5168E+00,1.0153E+00,5.1695E-01,2.9634E-03,
     &4.0047E+00,3.5059E+00,3.0081E+00,2.5099E+00,2.0120E+00,1.5128E+00,
     &1.0149E+00,5.2194E-01,3.7748E-03/
      DATA ((KA(JS,JT, 7, 7),JS=1,9),JT=1,5) /
     &7.1454E+00,6.2526E+00,5.3597E+00,4.4669E+00,3.5744E+00,2.6816E+00,
     &1.7891E+00,8.9724E-01,7.5005E-04,7.0662E+00,6.1833E+00,5.3006E+00,
     &4.4177E+00,3.5356E+00,2.6534E+00,1.7715E+00,8.9007E-01,1.0984E-03,
     &7.0091E+00,6.1337E+00,5.2586E+00,4.3836E+00,3.5085E+00,2.6339E+00,
     &1.7596E+00,8.8470E-01,1.5427E-03,6.9967E+00,6.1229E+00,5.2499E+00,
     &4.3767E+00,3.5037E+00,2.6314E+00,1.7589E+00,8.8464E-01,2.0814E-03,
     &7.0262E+00,6.1495E+00,5.2733E+00,4.3969E+00,3.5208E+00,2.6451E+00,
     &1.7672E+00,8.9234E-01,2.7067E-03/
      DATA ((KA(JS,JT, 8, 7),JS=1,9),JT=1,5) /
     &1.4691E+01,1.2856E+01,1.1019E+01,9.1832E+00,7.3472E+00,5.5112E+00,
     &3.6752E+00,1.8392E+00,5.0466E-04,1.4561E+01,1.2741E+01,1.0922E+01,
     &9.1018E+00,7.2824E+00,5.4631E+00,3.6434E+00,1.8247E+00,7.0108E-04,
     &1.4517E+01,1.2702E+01,1.0889E+01,9.0751E+00,7.2609E+00,5.4474E+00,
     &3.6338E+00,1.8215E+00,9.5134E-04,1.4592E+01,1.2768E+01,1.0945E+01,
     &9.1223E+00,7.2994E+00,5.4774E+00,3.6552E+00,1.8334E+00,1.2923E-03,
     &1.4780E+01,1.2933E+01,1.1086E+01,9.2409E+00,7.3952E+00,5.5498E+00,
     &3.7048E+00,1.8578E+00,1.7359E-03/
      DATA ((KA(JS,JT, 9, 7),JS=1,9),JT=1,5) /
     &5.6885E+01,4.9776E+01,4.2665E+01,3.5554E+01,2.8444E+01,2.1332E+01,
     &1.4224E+01,7.1126E+00,6.2609E-04,5.6580E+01,4.9509E+01,4.2436E+01,
     &3.5363E+01,2.8291E+01,2.1219E+01,1.4147E+01,7.0751E+00,8.0177E-04,
     &5.6732E+01,4.9637E+01,4.2548E+01,3.5458E+01,2.8366E+01,2.1276E+01,
     &1.4184E+01,7.0949E+00,1.0220E-03,5.7468E+01,5.0286E+01,4.3101E+01,
     &3.5920E+01,2.8736E+01,2.1553E+01,1.4371E+01,7.1892E+00,1.2387E-03,
     &5.8635E+01,5.1306E+01,4.3977E+01,3.6648E+01,2.9321E+01,2.1992E+01,
     &1.4665E+01,7.3378E+00,1.5501E-03/
      DATA ((KA(JS,JT,10, 7),JS=1,9),JT=1,5) /
     &2.4487E+02,2.1424E+02,1.8364E+02,1.5304E+02,1.2243E+02,9.1825E+01,
     &6.1214E+01,3.0606E+01,1.7354E-03,2.4490E+02,2.1431E+02,1.8369E+02,
     &1.5309E+02,1.2247E+02,9.1851E+01,6.1230E+01,3.0619E+01,1.7748E-03,
     &2.4755E+02,2.1661E+02,1.8568E+02,1.5472E+02,1.2378E+02,9.2834E+01,
     &6.1889E+01,3.0945E+01,1.9607E-03,2.5293E+02,2.2132E+02,1.8970E+02,
     &1.5807E+02,1.2647E+02,9.4852E+01,6.3238E+01,3.1620E+01,2.3523E-03,
     &2.5940E+02,2.2699E+02,1.9456E+02,1.6213E+02,1.2971E+02,9.7282E+01,
     &6.4856E+01,3.2431E+01,2.7354E-03/
      DATA ((KA(JS,JT,11, 7),JS=1,9),JT=1,5) /
     &3.6899E+02,3.2288E+02,2.7677E+02,2.3063E+02,1.8452E+02,1.3837E+02,
     &9.2255E+01,4.6125E+01,2.1265E-03,3.7335E+02,3.2670E+02,2.8002E+02,
     &2.3334E+02,1.8669E+02,1.4002E+02,9.3341E+01,4.6674E+01,3.2080E-03,
     &3.8233E+02,3.3453E+02,2.8674E+02,2.3896E+02,1.9116E+02,1.4337E+02,
     &9.5577E+01,4.7794E+01,3.4910E-03,3.9299E+02,3.4383E+02,2.9472E+02,
     &2.4561E+02,1.9648E+02,1.4736E+02,9.8242E+01,4.9120E+01,3.8208E-03,
     &4.0483E+02,3.5423E+02,3.0363E+02,2.5301E+02,2.0242E+02,1.5182E+02,
     &1.0121E+02,5.0609E+01,4.2123E-03/
      DATA ((KA(JS,JT,12, 7),JS=1,9),JT=1,5) /
     &4.1937E+02,3.6695E+02,3.1452E+02,2.6211E+02,2.0969E+02,1.5726E+02,
     &1.0485E+02,5.2423E+01,2.2784E-03,4.2956E+02,3.7586E+02,3.2216E+02,
     &2.6848E+02,2.1478E+02,1.6108E+02,1.0739E+02,5.3697E+01,3.5938E-03,
     &4.4222E+02,3.8693E+02,3.3164E+02,2.7638E+02,2.2109E+02,1.6582E+02,
     &1.1055E+02,5.5277E+01,4.4037E-03,4.5624E+02,3.9921E+02,3.4220E+02,
     &2.8517E+02,2.2812E+02,1.7109E+02,1.1406E+02,5.7035E+01,4.5266E-03,
     &4.7013E+02,4.1136E+02,3.5259E+02,2.9384E+02,2.3506E+02,1.7630E+02,
     &1.1754E+02,5.8765E+01,5.1545E-03/
      DATA ((KA(JS,JT,13, 7),JS=1,9),JT=1,5) /
     &3.8573E+02,3.3753E+02,2.8932E+02,2.4110E+02,1.9287E+02,1.4465E+02,
     &9.6435E+01,4.8220E+01,2.4127E-03,3.9713E+02,3.4748E+02,2.9784E+02,
     &2.4821E+02,1.9856E+02,1.4893E+02,9.9282E+01,4.9641E+01,3.8706E-03,
     &4.1029E+02,3.5900E+02,3.0771E+02,2.5644E+02,2.0514E+02,1.5386E+02,
     &1.0257E+02,5.1288E+01,4.7695E-03,4.2344E+02,3.7050E+02,3.1756E+02,
     &2.6463E+02,2.1170E+02,1.5878E+02,1.0586E+02,5.2932E+01,4.9706E-03,
     &4.3615E+02,3.8165E+02,3.2713E+02,2.7260E+02,2.1808E+02,1.6356E+02,
     &1.0904E+02,5.4523E+01,5.6617E-03/
      DATA ((KA(JS,JT, 1, 8),JS=1,9),JT=1,5) /
     &5.2022E-01,4.5635E-01,3.9252E-01,3.3010E-01,2.6823E-01,2.0567E-01,
     &1.4452E-01,8.4865E-02,1.8396E-02,5.2177E-01,4.5789E-01,3.9474E-01,
     &3.3342E-01,2.7114E-01,2.1031E-01,1.5104E-01,9.2174E-02,2.3774E-02,
     &5.2246E-01,4.5863E-01,3.9708E-01,3.3604E-01,2.7541E-01,2.1692E-01,
     &1.5876E-01,9.9961E-02,3.0156E-02,5.2222E-01,4.5904E-01,3.9936E-01,
     &3.3918E-01,2.8145E-01,2.2396E-01,1.6789E-01,1.0815E-01,3.7634E-02,
     &5.2130E-01,4.5967E-01,4.0135E-01,3.4393E-01,2.8807E-01,2.3225E-01,
     &1.7760E-01,1.1669E-01,4.6345E-02/
      DATA ((KA(JS,JT, 2, 8),JS=1,9),JT=1,5) /
     &8.1852E-01,7.1745E-01,6.1633E-01,5.1564E-01,4.1643E-01,3.1732E-01,
     &2.1786E-01,1.2067E-01,1.4675E-02,8.1998E-01,7.1886E-01,6.1787E-01,
     &5.1883E-01,4.2047E-01,3.2108E-01,2.2369E-01,1.2867E-01,1.9122E-02,
     &8.2161E-01,7.2051E-01,6.2063E-01,5.2305E-01,4.2413E-01,3.2660E-01,
     &2.3145E-01,1.3782E-01,2.4473E-02,8.2149E-01,7.2071E-01,6.2301E-01,
     &5.2587E-01,4.2865E-01,3.3407E-01,2.4032E-01,1.4761E-01,3.0869E-02,
     &8.1957E-01,7.1986E-01,6.2436E-01,5.2838E-01,4.3462E-01,3.4210E-01,
     &2.5070E-01,1.5726E-01,3.8311E-02/
      DATA ((KA(JS,JT, 3, 8),JS=1,9),JT=1,5) /
     &1.7050E+00,1.4932E+00,1.2814E+00,1.0695E+00,8.5775E-01,6.4751E-01,
     &4.3833E-01,2.2806E-01,1.0910E-02,1.7093E+00,1.4971E+00,1.2848E+00,
     &1.0726E+00,8.6216E-01,6.5288E-01,4.4261E-01,2.3435E-01,1.4370E-02,
     &1.7123E+00,1.5000E+00,1.2874E+00,1.0764E+00,8.6711E-01,6.5794E-01,
     &4.4842E-01,2.4360E-01,1.8590E-02,1.7121E+00,1.4998E+00,1.2880E+00,
     &1.0792E+00,8.7145E-01,6.6223E-01,4.5614E-01,2.5394E-01,2.3699E-02,
     &1.7072E+00,1.4957E+00,1.2869E+00,1.0807E+00,8.7401E-01,6.6818E-01,
     &4.6582E-01,2.6619E-01,2.9551E-02/
      DATA ((KA(JS,JT, 4, 8),JS=1,9),JT=1,5) /
     &3.5671E+00,3.1226E+00,2.6780E+00,2.2334E+00,1.7887E+00,1.3439E+00,
     &9.0030E-01,4.5879E-01,7.8646E-03,3.5784E+00,3.1324E+00,2.6867E+00,
     &2.2405E+00,1.7945E+00,1.3495E+00,9.0658E-01,4.6395E-01,1.0548E-02,
     &3.5832E+00,3.1369E+00,2.6902E+00,2.2437E+00,1.7981E+00,1.3549E+00,
     &9.1305E-01,4.7036E-01,1.3834E-02,3.5802E+00,3.1343E+00,2.6882E+00,
     &2.2430E+00,1.8006E+00,1.3596E+00,9.1785E-01,4.7927E-01,1.7787E-02,
     &3.5714E+00,3.1267E+00,2.6827E+00,2.2417E+00,1.8022E+00,1.3635E+00,
     &9.2392E-01,4.9076E-01,2.2306E-02/
      DATA ((KA(JS,JT, 5, 8),JS=1,9),JT=1,5) /
     &6.7418E+00,5.9003E+00,5.0587E+00,4.2171E+00,3.3754E+00,2.5338E+00,
     &1.6921E+00,8.5173E-01,5.5269E-03,6.7656E+00,5.9212E+00,5.0765E+00,
     &4.2319E+00,3.3873E+00,2.5428E+00,1.6990E+00,8.5857E-01,7.5732E-03,
     &6.7746E+00,5.9289E+00,5.0835E+00,4.2380E+00,3.3924E+00,2.5474E+00,
     &1.7057E+00,8.6548E-01,1.0137E-02,6.7641E+00,5.9200E+00,5.0759E+00,
     &4.2320E+00,3.3891E+00,2.5487E+00,1.7099E+00,8.7100E-01,1.3219E-02,
     &6.7413E+00,5.9008E+00,5.0606E+00,4.2207E+00,3.3833E+00,2.5475E+00,
     &1.7128E+00,8.7813E-01,1.6736E-02/
      DATA ((KA(JS,JT, 6, 8),JS=1,9),JT=1,5) /
     &1.1755E+01,1.0287E+01,8.8182E+00,7.3494E+00,5.8812E+00,4.4127E+00,
     &2.9442E+00,1.4757E+00,3.7670E-03,1.1790E+01,1.0318E+01,8.8444E+00,
     &7.3718E+00,5.8990E+00,4.4261E+00,2.9535E+00,1.4824E+00,5.2756E-03,
     &1.1802E+01,1.0328E+01,8.8538E+00,7.3796E+00,5.9055E+00,4.4312E+00,
     &2.9580E+00,1.4892E+00,7.2031E-03,1.1771E+01,1.0301E+01,8.8310E+00,
     &7.3612E+00,5.8917E+00,4.4224E+00,2.9568E+00,1.4927E+00,9.5398E-03,
     &1.1717E+01,1.0254E+01,8.7912E+00,7.3292E+00,5.8672E+00,4.4080E+00,
     &2.9504E+00,1.4942E+00,1.2264E-02/
      DATA ((KA(JS,JT, 7, 8),JS=1,9),JT=1,5) /
     &2.1201E+01,1.8552E+01,1.5902E+01,1.3253E+01,1.0604E+01,7.9546E+00,
     &5.3049E+00,2.6554E+00,2.5163E-03,2.1258E+01,1.8602E+01,1.5945E+01,
     &1.3288E+01,1.0632E+01,7.9754E+00,5.3196E+00,2.6631E+00,3.6166E-03,
     &2.1271E+01,1.8614E+01,1.5957E+01,1.3298E+01,1.0640E+01,7.9825E+00,
     &5.3244E+00,2.6683E+00,5.0339E-03,2.1213E+01,1.8564E+01,1.5913E+01,
     &1.3262E+01,1.0612E+01,7.9619E+00,5.3122E+00,2.6672E+00,6.7768E-03,
     &2.1089E+01,1.8455E+01,1.5820E+01,1.3186E+01,1.0552E+01,7.9178E+00,
     &5.2873E+00,2.6593E+00,8.8413E-03/
      DATA ((KA(JS,JT, 8, 8),JS=1,9),JT=1,5) /
     &4.5180E+01,3.9535E+01,3.3887E+01,2.8239E+01,2.2591E+01,1.6944E+01,
     &1.1298E+01,5.6517E+00,1.3715E-03,4.5290E+01,3.9627E+01,3.3969E+01,
     &2.8308E+01,2.2647E+01,1.6987E+01,1.1327E+01,5.6660E+00,2.0845E-03,
     &4.5261E+01,3.9605E+01,3.3948E+01,2.8290E+01,2.2633E+01,1.6977E+01,
     &1.1320E+01,5.6637E+00,3.2057E-03,4.5126E+01,3.9486E+01,3.3848E+01,
     &2.8205E+01,2.2567E+01,1.6928E+01,1.1288E+01,5.6493E+00,4.5853E-03,
     &4.4865E+01,3.9259E+01,3.3651E+01,2.8046E+01,2.2438E+01,1.6832E+01,
     &1.1226E+01,5.6233E+00,6.2243E-03/
      DATA ((KA(JS,JT, 9, 8),JS=1,9),JT=1,5) /
     &1.7982E+02,1.5734E+02,1.3487E+02,1.1239E+02,8.9912E+01,6.7434E+01,
     &4.4957E+01,2.2481E+01,1.3106E-03,1.7996E+02,1.5746E+02,1.3497E+02,
     &1.1247E+02,8.9976E+01,6.7488E+01,4.4992E+01,2.2498E+01,1.6404E-03,
     &1.7965E+02,1.5719E+02,1.3473E+02,1.1228E+02,8.9821E+01,6.7370E+01,
     &4.4914E+01,2.2461E+01,2.0268E-03,1.7888E+02,1.5653E+02,1.3416E+02,
     &1.1181E+02,8.9443E+01,6.7088E+01,4.4727E+01,2.2367E+01,2.6824E-03,
     &1.7801E+02,1.5576E+02,1.3351E+02,1.1126E+02,8.9014E+01,6.6762E+01,
     &4.4512E+01,2.2261E+01,3.2961E-03/
      DATA ((KA(JS,JT,10, 8),JS=1,9),JT=1,5) /
     &7.9186E+02,6.9285E+02,5.9387E+02,4.9485E+02,3.9587E+02,2.9692E+02,
     &1.9795E+02,9.8980E+01,2.6434E-03,7.9156E+02,6.9260E+02,5.9370E+02,
     &4.9476E+02,3.9580E+02,2.9685E+02,1.9789E+02,9.8956E+01,3.6689E-03,
     &7.8897E+02,6.9037E+02,5.9173E+02,4.9309E+02,3.9450E+02,2.9589E+02,
     &1.9725E+02,9.8635E+01,4.1214E-03,7.8518E+02,6.8703E+02,5.8889E+02,
     &4.9073E+02,3.9258E+02,2.9444E+02,1.9631E+02,9.8149E+01,4.6533E-03,
     &7.8271E+02,6.8490E+02,5.8707E+02,4.8922E+02,3.9137E+02,2.9354E+02,
     &1.9568E+02,9.7851E+01,5.3114E-03/
      DATA ((KA(JS,JT,11, 8),JS=1,9),JT=1,5) /
     &1.2023E+03,1.0521E+03,9.0173E+02,7.5144E+02,6.0116E+02,4.5091E+02,
     &3.0058E+02,1.5029E+02,2.8585E-03,1.1987E+03,1.0489E+03,8.9906E+02,
     &7.4919E+02,5.9938E+02,4.4951E+02,2.9969E+02,1.4984E+02,4.2381E-03,
     &1.1938E+03,1.0446E+03,8.9539E+02,7.4611E+02,5.9694E+02,4.4768E+02,
     &2.9847E+02,1.4923E+02,6.1776E-03,1.1919E+03,1.0429E+03,8.9396E+02,
     &7.4498E+02,5.9597E+02,4.4698E+02,2.9797E+02,1.4900E+02,6.8124E-03,
     &1.1943E+03,1.0450E+03,8.9567E+02,7.4646E+02,5.9716E+02,4.4786E+02,
     &2.9857E+02,1.4929E+02,7.2330E-03/
      DATA ((KA(JS,JT,12, 8),JS=1,9),JT=1,5) /
     &1.3468E+03,1.1784E+03,1.0101E+03,8.4170E+02,6.7334E+02,5.0503E+02,
     &3.3668E+02,1.6834E+02,3.2180E-03,1.3417E+03,1.1740E+03,1.0062E+03,
     &8.3855E+02,6.7082E+02,5.0314E+02,3.3541E+02,1.6772E+02,4.6846E-03,
     &1.3409E+03,1.1734E+03,1.0058E+03,8.3814E+02,6.7048E+02,5.0287E+02,
     &3.3524E+02,1.6763E+02,6.5606E-03,1.3471E+03,1.1787E+03,1.0103E+03,
     &8.4192E+02,6.7354E+02,5.0515E+02,3.3677E+02,1.6839E+02,8.6936E-03,
     &1.3615E+03,1.1913E+03,1.0211E+03,8.5093E+02,6.8072E+02,5.1056E+02,
     &3.4035E+02,1.7018E+02,9.2918E-03/
      DATA ((KA(JS,JT,13, 8),JS=1,9),JT=1,5) /
     &1.2096E+03,1.0584E+03,9.0717E+02,7.5599E+02,6.0478E+02,4.5359E+02,
     &3.0240E+02,1.5119E+02,3.1447E-03,1.2095E+03,1.0583E+03,9.0711E+02,
     &7.5597E+02,6.0474E+02,4.5355E+02,3.0238E+02,1.5119E+02,4.9163E-03,
     &1.2161E+03,1.0641E+03,9.1208E+02,7.6006E+02,6.0804E+02,4.5603E+02,
     &3.0401E+02,1.5201E+02,6.8865E-03,1.2328E+03,1.0787E+03,9.2458E+02,
     &7.7050E+02,6.1637E+02,4.6230E+02,3.0819E+02,1.5410E+02,9.4613E-03,
     &1.2601E+03,1.1026E+03,9.4505E+02,7.8755E+02,6.3004E+02,4.7254E+02,
     &3.1501E+02,1.5751E+02,1.0283E-02/
      DATA ((KA(JS,JT, 1, 9),JS=1,9),JT=1,5) /
     &1.0370E+00,9.0857E-01,7.8023E-01,6.5192E-01,5.2457E-01,4.0025E-01,
     &2.7828E-01,1.5804E-01,5.8897E-02,1.0492E+00,9.1962E-01,7.9014E-01,
     &6.6101E-01,5.3535E-01,4.1219E-01,2.9064E-01,1.7381E-01,7.6414E-02,
     &1.0617E+00,9.3102E-01,8.0032E-01,6.7200E-01,5.4761E-01,4.2620E-01,
     &3.0674E-01,1.9538E-01,9.6701E-02,1.0715E+00,9.3980E-01,8.0850E-01,
     &6.8264E-01,5.6043E-01,4.4205E-01,3.2592E-01,2.2229E-01,1.1943E-01,
     &1.0801E+00,9.4751E-01,8.1733E-01,6.9368E-01,5.7613E-01,4.6079E-01,
     &3.5014E-01,2.5319E-01,1.4487E-01/
      DATA ((KA(JS,JT, 2, 9),JS=1,9),JT=1,5) /
     &1.7442E+00,1.5272E+00,1.3102E+00,1.0933E+00,8.7649E-01,6.6091E-01,
     &4.4902E-01,2.3891E-01,5.2362E-02,1.7617E+00,1.5427E+00,1.3238E+00,
     &1.1049E+00,8.8687E-01,6.7276E-01,4.6180E-01,2.5188E-01,6.8691E-02,
     &1.7768E+00,1.5563E+00,1.3359E+00,1.1155E+00,8.9933E-01,6.8666E-01,
     &4.7568E-01,2.6925E-01,8.7599E-02,1.7902E+00,1.5683E+00,1.3467E+00,
     &1.1272E+00,9.1292E-01,7.0212E-01,4.9313E-01,2.9218E-01,1.0892E-01,
     &1.8007E+00,1.5781E+00,1.3558E+00,1.1390E+00,9.2668E-01,7.1895E-01,
     &5.1345E-01,3.2009E-01,1.3290E-01/
      DATA ((KA(JS,JT, 3, 9),JS=1,9),JT=1,5) /
     &3.9769E+00,3.4805E+00,2.9839E+00,2.4875E+00,1.9912E+00,1.4948E+00,
     &9.9892E-01,5.0928E-01,4.2777E-02,4.0084E+00,3.5082E+00,3.0084E+00,
     &2.5082E+00,2.0082E+00,1.5084E+00,1.0123E+00,5.2189E-01,5.7041E-02,
     &4.0345E+00,3.5316E+00,3.0286E+00,2.5259E+00,2.0232E+00,1.5223E+00,
     &1.0275E+00,5.3508E-01,7.3780E-02,4.0588E+00,3.5535E+00,3.0482E+00,
     &2.5430E+00,2.0380E+00,1.5389E+00,1.0447E+00,5.5284E-01,9.2939E-02,
     &4.0766E+00,3.5694E+00,3.0624E+00,2.5553E+00,2.0517E+00,1.5545E+00,
     &1.0614E+00,5.7409E-01,1.1487E-01/
      DATA ((KA(JS,JT, 4, 9),JS=1,9),JT=1,5) /
     &9.2347E+00,8.0808E+00,6.9267E+00,5.7730E+00,4.6191E+00,3.4653E+00,
     &2.3115E+00,1.1586E+00,3.3639E-02,9.3231E+00,8.1587E+00,6.9942E+00,
     &5.8295E+00,4.6650E+00,3.5006E+00,2.3364E+00,1.1757E+00,4.5584E-02,
     &9.3883E+00,8.2160E+00,7.0435E+00,5.8714E+00,4.6992E+00,3.5271E+00,
     &2.3555E+00,1.1930E+00,5.9759E-02,9.4383E+00,8.2599E+00,7.0821E+00,
     &5.9042E+00,4.7261E+00,3.5482E+00,2.3742E+00,1.2110E+00,7.6294E-02,
     &9.4750E+00,8.2926E+00,7.1106E+00,5.9283E+00,4.7463E+00,3.5648E+00,
     &2.3926E+00,1.2283E+00,9.5542E-02/
      DATA ((KA(JS,JT, 5, 9),JS=1,9),JT=1,5) /
     &1.9585E+01,1.7137E+01,1.4689E+01,1.2242E+01,9.7941E+00,7.3465E+00,
     &4.8988E+00,2.4515E+00,2.6102E-02,1.9780E+01,1.7309E+01,1.4837E+01,
     &1.2365E+01,9.8932E+00,7.4216E+00,4.9500E+00,2.4789E+00,3.5859E-02,
     &1.9935E+01,1.7444E+01,1.4954E+01,1.2463E+01,9.9721E+00,7.4814E+00,
     &4.9911E+00,2.5017E+00,4.7575E-02,2.0051E+01,1.7546E+01,1.5041E+01,
     &1.2537E+01,1.0032E+01,7.5273E+00,5.0227E+00,2.5239E+00,6.1484E-02,
     &2.0135E+01,1.7620E+01,1.5106E+01,1.2591E+01,1.0076E+01,7.5609E+00,
     &5.0463E+00,2.5450E+00,7.7952E-02/
      DATA ((KA(JS,JT, 6, 9),JS=1,9),JT=1,5) /
     &3.8631E+01,3.3801E+01,2.8974E+01,2.4144E+01,1.9316E+01,1.4488E+01,
     &9.6597E+00,4.8315E+00,1.9604E-02,3.9022E+01,3.4145E+01,2.9268E+01,
     &2.4390E+01,1.9513E+01,1.4636E+01,9.7595E+00,4.8831E+00,2.7435E-02,
     &3.9348E+01,3.4431E+01,2.9514E+01,2.4596E+01,1.9679E+01,1.4761E+01,
     &9.8442E+00,4.9267E+00,3.6949E-02,3.9594E+01,3.4646E+01,2.9698E+01,
     &2.4751E+01,1.9803E+01,1.4855E+01,9.9079E+00,4.9603E+00,4.8442E-02,
     &3.9770E+01,3.4801E+01,2.9832E+01,2.4862E+01,1.9893E+01,1.4924E+01,
     &9.9544E+00,4.9871E+00,6.2169E-02/
      DATA ((KA(JS,JT, 7, 9),JS=1,9),JT=1,5) /
     &7.9230E+01,6.9326E+01,5.9424E+01,4.9520E+01,3.9617E+01,2.9713E+01,
     &1.9810E+01,9.9063E+00,1.4333E-02,8.0053E+01,7.0047E+01,6.0041E+01,
     &5.0034E+01,4.0029E+01,3.0023E+01,2.0018E+01,1.0011E+01,2.0474E-02,
     &8.0747E+01,7.0654E+01,6.0562E+01,5.0470E+01,4.0378E+01,3.0286E+01,
     &2.0193E+01,1.0101E+01,2.8098E-02,8.1303E+01,7.1142E+01,6.0980E+01,
     &5.0819E+01,4.0658E+01,3.0496E+01,2.0334E+01,1.0173E+01,3.7439E-02,
     &8.1680E+01,7.1472E+01,6.1265E+01,5.1057E+01,4.0847E+01,3.0638E+01,
     &2.0431E+01,1.0223E+01,4.8718E-02/
      DATA ((KA(JS,JT, 8, 9),JS=1,9),JT=1,5) /
     &1.9140E+02,1.6747E+02,1.4355E+02,1.1962E+02,9.5701E+01,7.1775E+01,
     &4.7850E+01,2.3927E+01,1.0137E-02,1.9353E+02,1.6934E+02,1.4515E+02,
     &1.2096E+02,9.6769E+01,7.2577E+01,4.8385E+01,2.4195E+01,1.4960E-02,
     &1.9528E+02,1.7086E+02,1.4646E+02,1.2205E+02,9.7642E+01,7.3231E+01,
     &4.8824E+01,2.4416E+01,2.0883E-02,1.9672E+02,1.7213E+02,1.4754E+02,
     &1.2295E+02,9.8361E+01,7.3773E+01,4.9186E+01,2.4598E+01,2.8267E-02,
     &1.9763E+02,1.7293E+02,1.4824E+02,1.2352E+02,9.8820E+01,7.4120E+01,
     &4.9417E+01,2.4716E+01,3.7324E-02/
      DATA ((KA(JS,JT, 9, 9),JS=1,9),JT=1,5) /
     &8.5696E+02,7.4986E+02,6.4272E+02,5.3561E+02,4.2849E+02,3.2137E+02,
     &2.1425E+02,1.0712E+02,4.9710E-03,8.6661E+02,7.5827E+02,6.4996E+02,
     &5.4164E+02,4.3331E+02,3.2498E+02,2.1666E+02,1.0833E+02,7.7324E-03,
     &8.7472E+02,7.6537E+02,6.5602E+02,5.4669E+02,4.3735E+02,3.2801E+02,
     &2.1868E+02,1.0935E+02,1.2302E-02,8.8128E+02,7.7113E+02,6.6095E+02,
     &5.5081E+02,4.4064E+02,3.3048E+02,2.2033E+02,1.1017E+02,1.8205E-02,
     &8.8594E+02,7.7518E+02,6.6448E+02,5.5372E+02,4.4298E+02,3.3223E+02,
     &2.2150E+02,1.1076E+02,2.5853E-02/
      DATA ((KA(JS,JT,10, 9),JS=1,9),JT=1,5) /
     &4.2110E+03,3.6847E+03,3.1582E+03,2.6319E+03,2.1055E+03,1.5792E+03,
     &1.0527E+03,5.2637E+02,5.0235E-03,4.2578E+03,3.7256E+03,3.1934E+03,
     &2.6613E+03,2.1289E+03,1.5967E+03,1.0645E+03,5.3224E+02,7.3952E-03,
     &4.2976E+03,3.7604E+03,3.2232E+03,2.6860E+03,2.1488E+03,1.6116E+03,
     &1.0744E+03,5.3720E+02,1.0255E-02,4.3279E+03,3.7869E+03,3.2460E+03,
     &2.7049E+03,2.1640E+03,1.6230E+03,1.0820E+03,5.4099E+02,1.2154E-02,
     &4.3496E+03,3.8060E+03,3.2622E+03,2.7186E+03,2.1748E+03,1.6311E+03,
     &1.0874E+03,5.4372E+02,1.4719E-02/
      DATA ((KA(JS,JT,11, 9),JS=1,9),JT=1,5) /
     &7.1173E+03,6.2277E+03,5.3380E+03,4.4482E+03,3.5586E+03,2.6690E+03,
     &1.7793E+03,8.8967E+02,4.7950E-03,7.1866E+03,6.2881E+03,5.3900E+03,
     &4.4917E+03,3.5933E+03,2.6950E+03,1.7967E+03,8.9836E+02,1.0381E-02,
     &7.2420E+03,6.3363E+03,5.4313E+03,4.5262E+03,3.6209E+03,2.7156E+03,
     &1.8104E+03,9.0520E+02,1.1192E-02,7.2818E+03,6.3715E+03,5.4613E+03,
     &4.5511E+03,3.6409E+03,2.7307E+03,1.8205E+03,9.1025E+02,1.5145E-02,
     &7.3078E+03,6.3944E+03,5.4808E+03,4.5675E+03,3.6540E+03,2.7404E+03,
     &1.8270E+03,9.1351E+02,1.9391E-02/
      DATA ((KA(JS,JT,12, 9),JS=1,9),JT=1,5) /
     &8.7768E+03,7.6797E+03,6.5826E+03,5.4853E+03,4.3884E+03,3.2912E+03,
     &2.1942E+03,1.0970E+03,4.5625E-03,8.8507E+03,7.7442E+03,6.6378E+03,
     &5.5316E+03,4.4251E+03,3.3189E+03,2.2126E+03,1.1063E+03,8.7877E-03,
     &8.9020E+03,7.7891E+03,6.6765E+03,5.5638E+03,4.4512E+03,3.3383E+03,
     &2.2256E+03,1.1128E+03,1.5209E-02,8.9305E+03,7.8144E+03,6.6981E+03,
     &5.5817E+03,4.4653E+03,3.3489E+03,2.2326E+03,1.1163E+03,1.7795E-02,
     &8.9442E+03,7.8262E+03,6.7079E+03,5.5901E+03,4.4720E+03,3.3539E+03,
     &2.2360E+03,1.1180E+03,2.1474E-02/
      DATA ((KA(JS,JT,13, 9),JS=1,9),JT=1,5) /
     &8.5284E+03,7.4622E+03,6.3962E+03,5.3302E+03,4.2643E+03,3.1981E+03,
     &2.1321E+03,1.0660E+03,6.4304E-03,8.5795E+03,7.5072E+03,6.4348E+03,
     &5.3623E+03,4.2900E+03,3.2173E+03,2.1449E+03,1.0725E+03,8.8022E-03,
     &8.6101E+03,7.5338E+03,6.4575E+03,5.3813E+03,4.3050E+03,3.2288E+03,
     &2.1525E+03,1.0763E+03,1.7025E-02,8.6267E+03,7.5481E+03,6.4701E+03,
     &5.3916E+03,4.3132E+03,3.2351E+03,2.1567E+03,1.0783E+03,2.0223E-02,
     &8.6229E+03,7.5451E+03,6.4669E+03,5.3892E+03,4.3114E+03,3.2335E+03,
     &2.1558E+03,1.0779E+03,2.3841E-02/
      DATA ((KA(JS,JT, 1,10),JS=1,9),JT=1,5) /
     &3.0277E+00,2.6495E+00,2.2716E+00,1.8933E+00,1.5153E+00,1.1372E+00,
     &7.5951E-01,4.2431E-01,1.1653E-01,3.0877E+00,2.7021E+00,2.3167E+00,
     &1.9311E+00,1.5454E+00,1.1599E+00,7.9480E-01,4.6158E-01,1.5133E-01,
     &3.1443E+00,2.7514E+00,2.3589E+00,1.9665E+00,1.5738E+00,1.1839E+00,
     &8.4936E-01,4.8883E-01,1.8963E-01,3.1902E+00,2.7921E+00,2.3935E+00,
     &1.9952E+00,1.5971E+00,1.2268E+00,8.9927E-01,5.1426E-01,2.3885E-01,
     &3.2311E+00,2.8275E+00,2.4242E+00,2.0206E+00,1.6182E+00,1.2846E+00,
     &9.3468E-01,5.5470E-01,2.9337E-01/
      DATA ((KA(JS,JT, 2,10),JS=1,9),JT=1,5) /
     &4.5362E+00,3.9696E+00,3.4027E+00,2.8358E+00,2.2692E+00,1.7025E+00,
     &1.1358E+00,5.9446E-01,1.1450E-01,4.6490E+00,4.0681E+00,3.4874E+00,
     &2.9068E+00,2.3258E+00,1.7450E+00,1.1656E+00,6.4847E-01,1.4911E-01,
     &4.7559E+00,4.1617E+00,3.5676E+00,2.9735E+00,2.3793E+00,1.7851E+00,
     &1.2174E+00,6.9018E-01,1.9066E-01,4.8499E+00,4.2438E+00,3.6378E+00,
     &3.0322E+00,2.4263E+00,1.8213E+00,1.2864E+00,7.2155E-01,2.3838E-01,
     &4.9283E+00,4.3130E+00,3.6972E+00,3.0815E+00,2.4657E+00,1.8737E+00,
     &1.3480E+00,7.6180E-01,2.9224E-01/
      DATA ((KA(JS,JT, 3,10),JS=1,9),JT=1,5) /
     &9.1512E+00,8.0077E+00,6.8647E+00,5.7202E+00,4.5764E+00,3.4330E+00,
     &2.2893E+00,1.1456E+00,1.0238E-01,9.4295E+00,8.2512E+00,7.0726E+00,
     &5.8941E+00,4.7160E+00,3.5376E+00,2.3591E+00,1.1894E+00,1.3683E-01,
     &9.6929E+00,8.4812E+00,7.2704E+00,6.0594E+00,4.8479E+00,3.6364E+00,
     &2.4250E+00,1.2581E+00,1.7750E-01,9.9289E+00,8.6885E+00,7.4477E+00,
     &6.2066E+00,4.9652E+00,3.7251E+00,2.4842E+00,1.3376E+00,2.2412E-01,
     &1.0116E+01,8.8511E+00,7.5880E+00,6.3233E+00,5.0592E+00,3.7951E+00,
     &2.5511E+00,1.3941E+00,2.7545E-01/
      DATA ((KA(JS,JT, 4,10),JS=1,9),JT=1,5) /
     &1.9425E+01,1.6997E+01,1.4568E+01,1.2141E+01,9.7127E+00,7.2856E+00,
     &4.8569E+00,2.4292E+00,8.5208E-02,1.9954E+01,1.7460E+01,1.4965E+01,
     &1.2471E+01,9.9767E+00,7.4831E+00,4.9893E+00,2.4954E+00,1.1708E-01,
     &2.0423E+01,1.7870E+01,1.5318E+01,1.2764E+01,1.0212E+01,7.6596E+00,
     &5.1068E+00,2.5544E+00,1.5673E-01,2.0864E+01,1.8257E+01,1.5649E+01,
     &1.3042E+01,1.0433E+01,7.8250E+00,5.2173E+00,2.6098E+00,2.0293E-01,
     &2.1248E+01,1.8592E+01,1.5938E+01,1.3281E+01,1.0624E+01,7.9692E+00,
     &5.3131E+00,2.6931E+00,2.5421E-01/
      DATA ((KA(JS,JT, 5,10),JS=1,9),JT=1,5) /
     &4.0147E+01,3.5130E+01,3.0111E+01,2.5093E+01,2.0073E+01,1.5056E+01,
     &1.0038E+01,5.0189E+00,6.8359E-02,4.0924E+01,3.5810E+01,3.0692E+01,
     &2.5576E+01,2.0461E+01,1.5346E+01,1.0232E+01,5.1160E+00,9.6926E-02,
     &4.1536E+01,3.6343E+01,3.1153E+01,2.5962E+01,2.0769E+01,1.5577E+01,
     &1.0385E+01,5.1928E+00,1.3304E-01,4.2166E+01,3.6896E+01,3.1624E+01,
     &2.6353E+01,2.1083E+01,1.5813E+01,1.0542E+01,5.2715E+00,1.7579E-01,
     &4.2771E+01,3.7425E+01,3.2079E+01,2.6732E+01,2.1385E+01,1.6040E+01,
     &1.0693E+01,5.3473E+00,2.2393E-01/
      DATA ((KA(JS,JT, 6,10),JS=1,9),JT=1,5) /
     &8.0027E+01,7.0022E+01,6.0023E+01,5.0019E+01,4.0013E+01,3.0011E+01,
     &2.0007E+01,1.0004E+01,5.3924E-02,8.1173E+01,7.1024E+01,6.0878E+01,
     &5.0731E+01,4.0584E+01,3.0439E+01,2.0293E+01,1.0147E+01,7.8165E-02,
     &8.2280E+01,7.1996E+01,6.1710E+01,5.1425E+01,4.1141E+01,3.0855E+01,
     &2.0570E+01,1.0285E+01,1.0934E-01,8.3115E+01,7.2722E+01,6.2336E+01,
     &5.1947E+01,4.1558E+01,3.1167E+01,2.0778E+01,1.0390E+01,1.4595E-01,
     &8.3819E+01,7.3349E+01,6.2867E+01,5.2391E+01,4.1913E+01,3.1434E+01,
     &2.0957E+01,1.0479E+01,1.8806E-01/
      DATA ((KA(JS,JT, 7,10),JS=1,9),JT=1,5) /
     &1.6996E+02,1.4871E+02,1.2747E+02,1.0622E+02,8.4977E+01,6.3734E+01,
     &4.2490E+01,2.1246E+01,4.2588E-02,1.7243E+02,1.5088E+02,1.2932E+02,
     &1.0776E+02,8.6211E+01,6.4660E+01,4.3106E+01,2.1553E+01,6.2851E-02,
     &1.7457E+02,1.5274E+02,1.3092E+02,1.0910E+02,8.7283E+01,6.5459E+01,
     &4.3641E+01,2.1821E+01,8.8704E-02,1.7636E+02,1.5432E+02,1.3227E+02,
     &1.1023E+02,8.8183E+01,6.6138E+01,4.4090E+01,2.2046E+01,1.1966E-01,
     &1.7764E+02,1.5544E+02,1.3323E+02,1.1102E+02,8.8816E+01,6.6613E+01,
     &4.4410E+01,2.2206E+01,1.5600E-01/
      DATA ((KA(JS,JT, 8,10),JS=1,9),JT=1,5) /
     &4.3531E+02,3.8090E+02,3.2647E+02,2.7207E+02,2.1766E+02,1.6325E+02,
     &1.0883E+02,5.4412E+01,3.2634E-02,4.4098E+02,3.8585E+02,3.3074E+02,
     &2.7562E+02,2.2050E+02,1.6536E+02,1.1025E+02,5.5123E+01,4.9788E-02,
     &4.4650E+02,3.9069E+02,3.3490E+02,2.7906E+02,2.2325E+02,1.6744E+02,
     &1.1162E+02,5.5816E+01,7.2094E-02,4.5108E+02,3.9470E+02,3.3831E+02,
     &2.8194E+02,2.2555E+02,1.6915E+02,1.1277E+02,5.6387E+01,9.8901E-02,
     &4.5442E+02,3.9761E+02,3.4081E+02,2.8400E+02,2.2721E+02,1.7040E+02,
     &1.1360E+02,5.6798E+01,1.3038E-01/
      DATA ((KA(JS,JT, 9,10),JS=1,9),JT=1,5) /
     &2.1147E+03,1.8504E+03,1.5860E+03,1.3217E+03,1.0574E+03,7.9304E+02,
     &5.2867E+02,2.6435E+02,1.9424E-02,2.1442E+03,1.8762E+03,1.6082E+03,
     &1.3401E+03,1.0721E+03,8.0408E+02,5.3608E+02,2.6803E+02,3.6865E-02,
     &2.1685E+03,1.8976E+03,1.6264E+03,1.3553E+03,1.0842E+03,8.1317E+02,
     &5.4213E+02,2.7107E+02,5.5684E-02,2.1886E+03,1.9151E+03,1.6415E+03,
     &1.3680E+03,1.0943E+03,8.2077E+02,5.4720E+02,2.7360E+02,7.8135E-02,
     &2.2035E+03,1.9281E+03,1.6526E+03,1.3772E+03,1.1018E+03,8.2634E+02,
     &5.5093E+02,2.7546E+02,1.0558E-01/
      DATA ((KA(JS,JT,10,10),JS=1,9),JT=1,5) /
     &1.1340E+04,9.9225E+03,8.5053E+03,7.0882E+03,5.6700E+03,4.2524E+03,
     &2.8350E+03,1.4175E+03,1.1591E-02,1.1483E+04,1.0048E+04,8.6127E+03,
     &7.1771E+03,5.7419E+03,4.3066E+03,2.8709E+03,1.4354E+03,1.2588E-02,
     &1.1610E+04,1.0159E+04,8.7071E+03,7.2559E+03,5.8048E+03,4.3532E+03,
     &2.9023E+03,1.4511E+03,2.5538E-02,1.1702E+04,1.0239E+04,8.7766E+03,
     &7.3135E+03,5.8511E+03,4.3884E+03,2.9255E+03,1.4628E+03,4.5275E-02,
     &1.1737E+04,1.0270E+04,8.8031E+03,7.3358E+03,5.8688E+03,4.4014E+03,
     &2.9344E+03,1.4670E+03,5.8192E-02/
      DATA ((KA(JS,JT,11,10),JS=1,9),JT=1,5) /
     &2.0903E+04,1.8291E+04,1.5678E+04,1.3065E+04,1.0451E+04,7.8389E+03,
     &5.2261E+03,2.6129E+03,7.1886E-03,2.1095E+04,1.8459E+04,1.5821E+04,
     &1.3184E+04,1.0548E+04,7.9109E+03,5.2736E+03,2.6368E+03,6.0460E-03,
     &2.1210E+04,1.8559E+04,1.5908E+04,1.3256E+04,1.0605E+04,7.9536E+03,
     &5.3027E+03,2.6511E+03,2.6262E-02,2.1260E+04,1.8603E+04,1.5945E+04,
     &1.3287E+04,1.0630E+04,7.9726E+03,5.3149E+03,2.6575E+03,3.1824E-02,
     &2.1221E+04,1.8569E+04,1.5915E+04,1.3263E+04,1.0611E+04,7.9580E+03,
     &5.3053E+03,2.6525E+03,4.2831E-02/
      DATA ((KA(JS,JT,12,10),JS=1,9),JT=1,5) /
     &2.8005E+04,2.4506E+04,2.1003E+04,1.7504E+04,1.4003E+04,1.0502E+04,
     &7.0018E+03,3.5007E+03,1.9282E-02,2.8178E+04,2.4656E+04,2.1135E+04,
     &1.7611E+04,1.4090E+04,1.0567E+04,7.0445E+03,3.5221E+03,8.6382E-03,
     &2.8205E+04,2.4680E+04,2.1153E+04,1.7628E+04,1.4103E+04,1.0577E+04,
     &7.0512E+03,3.5256E+03,2.9773E-02,2.8170E+04,2.4648E+04,2.1126E+04,
     &1.7606E+04,1.4084E+04,1.0563E+04,7.0421E+03,3.5211E+03,3.9720E-02,
     &2.8047E+04,2.4540E+04,2.1034E+04,1.7529E+04,1.4023E+04,1.0517E+04,
     &7.0115E+03,3.5058E+03,4.1794E-02/
      DATA ((KA(JS,JT,13,10),JS=1,9),JT=1,5) /
     &2.9533E+04,2.5841E+04,2.2150E+04,1.8457E+04,1.4766E+04,1.1075E+04,
     &7.3833E+03,3.6917E+03,1.5098E-03,2.9558E+04,2.5865E+04,2.2169E+04,
     &1.8475E+04,1.4779E+04,1.1085E+04,7.3900E+03,3.6949E+03,1.2533E-02,
     &2.9540E+04,2.5844E+04,2.2155E+04,1.8463E+04,1.4769E+04,1.1077E+04,
     &7.3851E+03,3.6924E+03,1.7410E-02,2.9338E+04,2.5670E+04,2.2004E+04,
     &1.8336E+04,1.4669E+04,1.1002E+04,7.3346E+03,3.6671E+03,4.5009E-02,
     &2.9073E+04,2.5440E+04,2.1806E+04,1.8171E+04,1.4537E+04,1.0903E+04,
     &7.2684E+03,3.6344E+03,5.0725E-02/
      DATA ((KA(JS,JT, 1,11),JS=1,9),JT=1,5) /
     &5.0284E+00,4.3997E+00,3.7713E+00,3.1433E+00,2.5148E+00,1.8867E+00,
     &1.2585E+00,6.3034E-01,1.3324E-01,5.0428E+00,4.4122E+00,3.7822E+00,
     &3.1521E+00,2.5223E+00,1.8921E+00,1.2620E+00,6.6040E-01,1.7160E-01,
     &5.0450E+00,4.4148E+00,3.7841E+00,3.1540E+00,2.5234E+00,1.8930E+00,
     &1.2629E+00,7.0553E-01,2.2033E-01,5.0314E+00,4.4027E+00,3.7741E+00,
     &3.1454E+00,2.5166E+00,1.8879E+00,1.2828E+00,7.2981E-01,2.7819E-01,
     &5.0061E+00,4.3808E+00,3.7550E+00,3.1298E+00,2.5041E+00,1.8785E+00,
     &1.3311E+00,7.4514E-01,3.4945E-01/
      DATA ((KA(JS,JT, 2,11),JS=1,9),JT=1,5) /
     &7.7109E+00,6.7474E+00,5.7839E+00,4.8201E+00,3.8564E+00,2.8926E+00,
     &1.9289E+00,9.6516E-01,1.3538E-01,7.7553E+00,6.7857E+00,5.8167E+00,
     &4.8473E+00,3.8784E+00,2.9091E+00,1.9400E+00,9.7434E-01,1.7899E-01,
     &7.7777E+00,6.8060E+00,5.8332E+00,4.8617E+00,3.8897E+00,2.9178E+00,
     &1.9457E+00,1.0175E+00,2.2662E-01,7.7756E+00,6.8039E+00,5.8323E+00,
     &4.8602E+00,3.8885E+00,2.9169E+00,1.9452E+00,1.0634E+00,2.8531E-01,
     &7.7495E+00,6.7817E+00,5.8131E+00,4.8446E+00,3.8758E+00,2.9075E+00,
     &1.9643E+00,1.0863E+00,3.5634E-01/
      DATA ((KA(JS,JT, 3,11),JS=1,9),JT=1,5) /
     &1.5932E+01,1.3941E+01,1.1949E+01,9.9578E+00,7.9671E+00,5.9754E+00,
     &3.9840E+00,1.9926E+00,1.2714E-01,1.6076E+01,1.4067E+01,1.2058E+01,
     &1.0048E+01,8.0387E+00,6.0296E+00,4.0199E+00,2.0105E+00,1.7056E-01,
     &1.6164E+01,1.4145E+01,1.2124E+01,1.0103E+01,8.0829E+00,6.0627E+00,
     &4.0424E+00,2.0217E+00,2.2135E-01,1.6211E+01,1.4185E+01,1.2159E+01,
     &1.0132E+01,8.1062E+00,6.0800E+00,4.0538E+00,2.0361E+00,2.7967E-01,
     &1.6213E+01,1.4187E+01,1.2160E+01,1.0134E+01,8.1068E+00,6.0810E+00,
     &4.0544E+00,2.0887E+00,3.5085E-01/
      DATA ((KA(JS,JT, 4,11),JS=1,9),JT=1,5) /
     &3.3505E+01,2.9316E+01,2.5128E+01,2.0940E+01,1.6753E+01,1.2564E+01,
     &8.3770E+00,4.1888E+00,1.1343E-01,3.3957E+01,2.9712E+01,2.5469E+01,
     &2.1224E+01,1.6979E+01,1.2735E+01,8.4899E+00,4.2456E+00,1.5601E-01,
     &3.4273E+01,2.9992E+01,2.5707E+01,2.1421E+01,1.7138E+01,1.2854E+01,
     &8.5693E+00,4.2852E+00,2.0536E-01,3.4537E+01,3.0216E+01,2.5901E+01,
     &2.1585E+01,1.7269E+01,1.2951E+01,8.6346E+00,4.3178E+00,2.6462E-01,
     &3.4713E+01,3.0370E+01,2.6032E+01,2.1696E+01,1.7356E+01,1.3018E+01,
     &8.6791E+00,4.3400E+00,3.3230E-01/
      DATA ((KA(JS,JT, 5,11),JS=1,9),JT=1,5) /
     &6.4813E+01,5.6712E+01,4.8608E+01,4.0507E+01,3.2408E+01,2.4306E+01,
     &1.6204E+01,8.1017E+00,9.6356E-02,6.6164E+01,5.7895E+01,4.9623E+01,
     &4.1352E+01,3.3084E+01,2.4813E+01,1.6542E+01,8.2707E+00,1.3652E-01,
     &6.7228E+01,5.8826E+01,5.0425E+01,4.2018E+01,3.3613E+01,2.5211E+01,
     &1.6808E+01,8.4044E+00,1.8472E-01,6.8035E+01,5.9536E+01,5.1024E+01,
     &4.2523E+01,3.4019E+01,2.5513E+01,1.7010E+01,8.5064E+00,2.4242E-01,
     &6.8554E+01,5.9987E+01,5.1420E+01,4.2849E+01,3.4277E+01,2.5710E+01,
     &1.7140E+01,8.5702E+00,3.0919E-01/
      DATA ((KA(JS,JT, 6,11),JS=1,9),JT=1,5) /
     &1.1801E+02,1.0326E+02,8.8506E+01,7.3757E+01,5.9002E+01,4.4254E+01,
     &2.9503E+01,1.4751E+01,7.7344E-02,1.2108E+02,1.0594E+02,9.0808E+01,
     &7.5672E+01,6.0541E+01,4.5406E+01,3.0271E+01,1.5134E+01,1.1263E-01,
     &1.2354E+02,1.0810E+02,9.2652E+01,7.7213E+01,6.1769E+01,4.6330E+01,
     &3.0886E+01,1.5443E+01,1.5682E-01,1.2526E+02,1.0960E+02,9.3943E+01,
     &7.8284E+01,6.2629E+01,4.6975E+01,3.1316E+01,1.5657E+01,2.1207E-01,
     &1.2664E+02,1.1081E+02,9.4976E+01,7.9149E+01,6.3321E+01,4.7490E+01,
     &3.1658E+01,1.5831E+01,2.7724E-01/
      DATA ((KA(JS,JT, 7,11),JS=1,9),JT=1,5) /
     &2.3249E+02,2.0341E+02,1.7435E+02,1.4529E+02,1.1624E+02,8.7178E+01,
     &5.8117E+01,2.9059E+01,6.0308E-02,2.3796E+02,2.0820E+02,1.7846E+02,
     &1.4871E+02,1.1897E+02,8.9231E+01,5.9488E+01,2.9745E+01,9.0208E-02,
     &2.4226E+02,2.1197E+02,1.8170E+02,1.5141E+02,1.2113E+02,9.0843E+01,
     &6.0568E+01,3.0281E+01,1.2927E-01,2.4544E+02,2.1477E+02,1.8409E+02,
     &1.5341E+02,1.2272E+02,9.2044E+01,6.1361E+01,3.0682E+01,1.7878E-01,
     &2.4764E+02,2.1668E+02,1.8573E+02,1.5477E+02,1.2381E+02,9.2866E+01,
     &6.1907E+01,3.0956E+01,2.3824E-01/
      DATA ((KA(JS,JT, 8,11),JS=1,9),JT=1,5) /
     &5.7428E+02,5.0249E+02,4.3070E+02,3.5893E+02,2.8714E+02,2.1536E+02,
     &1.4357E+02,7.1786E+01,4.7227E-02,5.8499E+02,5.1190E+02,4.3878E+02,
     &3.6564E+02,2.9252E+02,2.1939E+02,1.4626E+02,7.3130E+01,7.2171E-02,
     &5.9291E+02,5.1879E+02,4.4470E+02,3.7058E+02,2.9645E+02,2.2235E+02,
     &1.4822E+02,7.4114E+01,1.0536E-01,5.9816E+02,5.2341E+02,4.4862E+02,
     &3.7386E+02,2.9908E+02,2.2431E+02,1.4954E+02,7.4773E+01,1.4833E-01,
     &6.0144E+02,5.2627E+02,4.5109E+02,3.7590E+02,3.0070E+02,2.2554E+02,
     &1.5036E+02,7.5181E+01,1.9981E-01/
      DATA ((KA(JS,JT, 9,11),JS=1,9),JT=1,5) /
     &2.7514E+03,2.4073E+03,2.0635E+03,1.7196E+03,1.3757E+03,1.0318E+03,
     &6.8788E+02,3.4393E+02,3.3107E-02,2.7973E+03,2.4476E+03,2.0979E+03,
     &1.7482E+03,1.3986E+03,1.0490E+03,6.9932E+02,3.4966E+02,5.6998E-02,
     &2.8265E+03,2.4731E+03,2.1197E+03,1.7664E+03,1.4131E+03,1.0599E+03,
     &7.0662E+02,3.5330E+02,8.5901E-02,2.8388E+03,2.4841E+03,2.1291E+03,
     &1.7743E+03,1.4194E+03,1.0646E+03,7.0974E+02,3.5484E+02,1.2233E-01,
     &2.8373E+03,2.4828E+03,2.1280E+03,1.7734E+03,1.4187E+03,1.0640E+03,
     &7.0933E+02,3.5467E+02,1.6642E-01/
      DATA ((KA(JS,JT,10,11),JS=1,9),JT=1,5) /
     &1.4796E+04,1.2947E+04,1.1097E+04,9.2476E+03,7.3982E+03,5.5489E+03,
     &3.6992E+03,1.8496E+03,1.7335E-02,1.4975E+04,1.3103E+04,1.1231E+04,
     &9.3585E+03,7.4871E+03,5.6155E+03,3.7435E+03,1.8717E+03,3.1226E-02,
     &1.5074E+04,1.3189E+04,1.1305E+04,9.4210E+03,7.5370E+03,5.6528E+03,
     &3.7685E+03,1.8842E+03,4.3228E-02,1.5109E+04,1.3220E+04,1.1331E+04,
     &9.4424E+03,7.5542E+03,5.6659E+03,3.7773E+03,1.8886E+03,5.6685E-02,
     &1.5082E+04,1.3196E+04,1.1311E+04,9.4257E+03,7.5405E+03,5.6555E+03,
     &3.7704E+03,1.8852E+03,8.6311E-02/
      DATA ((KA(JS,JT,11,11),JS=1,9),JT=1,5) /
     &2.7889E+04,2.4402E+04,2.0916E+04,1.7430E+04,1.3944E+04,1.0458E+04,
     &6.9720E+03,3.4860E+03,1.1432E-02,2.8116E+04,2.4602E+04,2.1087E+04,
     &1.7573E+04,1.4058E+04,1.0543E+04,7.0292E+03,3.5144E+03,1.1075E-02,
     &2.8224E+04,2.4695E+04,2.1166E+04,1.7640E+04,1.4112E+04,1.0583E+04,
     &7.0560E+03,3.5276E+03,4.6547E-02,2.8217E+04,2.4690E+04,2.1162E+04,
     &1.7636E+04,1.4108E+04,1.0581E+04,7.0540E+03,3.5272E+03,6.2488E-02,
     &2.8126E+04,2.4609E+04,2.1093E+04,1.7578E+04,1.4063E+04,1.0547E+04,
     &7.0311E+03,3.5155E+03,7.5051E-02/
      DATA ((KA(JS,JT,12,11),JS=1,9),JT=1,5) /
     &3.8808E+04,3.3958E+04,2.9106E+04,2.4255E+04,1.9403E+04,1.4552E+04,
     &9.7020E+03,4.8510E+03,3.0879E-04,3.8964E+04,3.4093E+04,2.9222E+04,
     &2.4351E+04,1.9482E+04,1.4612E+04,9.7411E+03,4.8703E+03,1.3840E-02,
     &3.8935E+04,3.4067E+04,2.9198E+04,2.4333E+04,1.9466E+04,1.4600E+04,
     &9.7333E+03,4.8667E+03,2.1306E-02,3.8831E+04,3.3979E+04,2.9123E+04,
     &2.4270E+04,1.9417E+04,1.4562E+04,9.7077E+03,4.8538E+03,6.5973E-02,
     &3.8549E+04,3.3728E+04,2.8909E+04,2.4091E+04,1.9273E+04,1.4455E+04,
     &9.6358E+03,4.8182E+03,7.9959E-02/
      DATA ((KA(JS,JT,13,11),JS=1,9),JT=1,5) /
     &4.2486E+04,3.7175E+04,3.1864E+04,2.6552E+04,2.1242E+04,1.5932E+04,
     &1.0621E+04,5.3106E+03,2.4053E-04,4.2536E+04,3.7221E+04,3.1903E+04,
     &2.6585E+04,2.1268E+04,1.5951E+04,1.0634E+04,5.3169E+03,2.3604E-02,
     &4.2342E+04,3.7047E+04,3.1757E+04,2.6467E+04,2.1172E+04,1.5879E+04,
     &1.0585E+04,5.2925E+03,1.5018E-02,4.2048E+04,3.6792E+04,3.1537E+04,
     &2.6281E+04,2.1024E+04,1.5767E+04,1.0512E+04,5.2560E+03,5.3807E-02,
     &4.1662E+04,3.6457E+04,3.1248E+04,2.6040E+04,2.0833E+04,1.5623E+04,
     &1.0416E+04,5.2082E+03,6.8318E-02/
      DATA ((KA(JS,JT, 1,12),JS=1,9),JT=1,5) /
     &7.2849E+00,6.3745E+00,5.4643E+00,4.5537E+00,3.6431E+00,2.7326E+00,
     &1.8223E+00,9.1190E-01,1.6091E-01,7.1530E+00,6.2588E+00,5.3648E+00,
     &4.4709E+00,3.5770E+00,2.6830E+00,1.7891E+00,8.9548E-01,2.2421E-01,
     &7.0158E+00,6.1389E+00,5.2624E+00,4.3853E+00,3.5089E+00,2.6317E+00,
     &1.7551E+00,9.0204E-01,3.0513E-01,6.8752E+00,6.0158E+00,5.1568E+00,
     &4.2975E+00,3.4386E+00,2.5792E+00,1.7200E+00,9.2056E-01,4.0130E-01,
     &6.7312E+00,5.8897E+00,5.0486E+00,4.2075E+00,3.3663E+00,2.5251E+00,
     &1.6886E+00,9.1312E-01,5.1163E-01/
      DATA ((KA(JS,JT, 2,12),JS=1,9),JT=1,5) /
     &1.1380E+01,9.9571E+00,8.5349E+00,7.1126E+00,5.6896E+00,4.2680E+00,
     &2.8456E+00,1.4234E+00,1.6023E-01,1.1190E+01,9.7913E+00,8.3926E+00,
     &6.9944E+00,5.5956E+00,4.1971E+00,2.7983E+00,1.3998E+00,2.1092E-01,
     &1.0994E+01,9.6196E+00,8.2451E+00,6.8714E+00,5.4970E+00,4.1233E+00,
     &2.7491E+00,1.3753E+00,2.8249E-01,1.0789E+01,9.4404E+00,8.0917E+00,
     &6.7431E+00,5.3950E+00,4.0464E+00,2.6980E+00,1.3854E+00,3.7167E-01,
     &1.0574E+01,9.2528E+00,7.9306E+00,6.6095E+00,5.2877E+00,3.9662E+00,
     &2.6446E+00,1.3862E+00,4.7628E-01/
      DATA ((KA(JS,JT, 3,12),JS=1,9),JT=1,5) /
     &2.4019E+01,2.1015E+01,1.8012E+01,1.5011E+01,1.2010E+01,9.0070E+00,
     &6.0051E+00,3.0029E+00,1.5458E-01,2.3668E+01,2.0712E+01,1.7752E+01,
     &1.4794E+01,1.1835E+01,8.8764E+00,5.9181E+00,2.9594E+00,2.0548E-01,
     &2.3299E+01,2.0389E+01,1.7475E+01,1.4563E+01,1.1650E+01,8.7378E+00,
     &5.8256E+00,2.9134E+00,2.6510E-01,2.2895E+01,2.0033E+01,1.7172E+01,
     &1.4310E+01,1.1449E+01,8.5868E+00,5.7250E+00,2.8629E+00,3.4340E-01,
     &2.2457E+01,1.9650E+01,1.6845E+01,1.4036E+01,1.1229E+01,8.4225E+00,
     &5.6152E+00,2.8081E+00,4.3834E-01/
      DATA ((KA(JS,JT, 4,12),JS=1,9),JT=1,5) /
     &5.1943E+01,4.5448E+01,3.8958E+01,3.2464E+01,2.5972E+01,1.9479E+01,
     &1.2986E+01,6.4930E+00,1.4248E-01,5.1352E+01,4.4935E+01,3.8514E+01,
     &3.2094E+01,2.5675E+01,1.9257E+01,1.2838E+01,6.4195E+00,1.9502E-01,
     &5.0623E+01,4.4294E+01,3.7964E+01,3.1639E+01,2.5309E+01,1.8983E+01,
     &1.2655E+01,6.3280E+00,2.5898E-01,4.9799E+01,4.3576E+01,3.7352E+01,
     &3.1124E+01,2.4901E+01,1.8676E+01,1.2451E+01,6.2257E+00,3.3035E-01,
     &4.8898E+01,4.2791E+01,3.6677E+01,3.0566E+01,2.4452E+01,1.8340E+01,
     &1.2226E+01,6.1134E+00,4.1835E-01/
      DATA ((KA(JS,JT, 5,12),JS=1,9),JT=1,5) /
     &1.0373E+02,9.0759E+01,7.7796E+01,6.4826E+01,5.1857E+01,3.8894E+01,
     &2.5931E+01,1.2966E+01,1.2887E-01,1.0276E+02,8.9908E+01,7.7065E+01,
     &6.4222E+01,5.1382E+01,3.8535E+01,2.5690E+01,1.2845E+01,1.8027E-01,
     &1.0148E+02,8.8794E+01,7.6113E+01,6.3420E+01,5.0736E+01,3.8055E+01,
     &2.5371E+01,1.2686E+01,2.4350E-01,9.9981E+01,8.7486E+01,7.4989E+01,
     &6.2492E+01,4.9992E+01,3.7496E+01,2.4996E+01,1.2498E+01,3.1895E-01,
     &9.8403E+01,8.6098E+01,7.3801E+01,6.1498E+01,4.9199E+01,3.6902E+01,
     &2.4598E+01,1.2301E+01,4.0491E-01/
      DATA ((KA(JS,JT, 6,12),JS=1,9),JT=1,5) /
     &1.9449E+02,1.7021E+02,1.4589E+02,1.2157E+02,9.7258E+01,7.2943E+01,
     &4.8628E+01,2.4314E+01,1.1014E-01,1.9309E+02,1.6897E+02,1.4483E+02,
     &1.2070E+02,9.6559E+01,7.2419E+01,4.8279E+01,2.4139E+01,1.6004E-01,
     &1.9140E+02,1.6747E+02,1.4356E+02,1.1963E+02,9.5709E+01,7.1777E+01,
     &4.7853E+01,2.3926E+01,2.2190E-01,1.8899E+02,1.6537E+02,1.4174E+02,
     &1.1810E+02,9.4493E+01,7.0867E+01,4.7246E+01,2.3622E+01,2.9571E-01,
     &1.8566E+02,1.6245E+02,1.3925E+02,1.1603E+02,9.2834E+01,6.9623E+01,
     &4.6415E+01,2.3209E+01,3.8274E-01/
      DATA ((KA(JS,JT, 7,12),JS=1,9),JT=1,5) /
     &3.8417E+02,3.3613E+02,2.8811E+02,2.4009E+02,1.9205E+02,1.4405E+02,
     &9.6037E+01,4.8023E+01,9.0335E-02,3.8253E+02,3.3473E+02,2.8690E+02,
     &2.3908E+02,1.9128E+02,1.4345E+02,9.5632E+01,4.7816E+01,1.3557E-01,
     &3.7949E+02,3.3204E+02,2.8460E+02,2.3719E+02,1.8975E+02,1.4230E+02,
     &9.4872E+01,4.7438E+01,1.9476E-01,3.7465E+02,3.2783E+02,2.8099E+02,
     &2.3416E+02,1.8732E+02,1.4050E+02,9.3670E+01,4.6831E+01,2.6694E-01,
     &3.6931E+02,3.2313E+02,2.7696E+02,2.3080E+02,1.8464E+02,1.3849E+02,
     &9.2317E+01,4.6160E+01,3.5213E-01/
      DATA ((KA(JS,JT, 8,12),JS=1,9),JT=1,5) /
     &9.0810E+02,7.9455E+02,6.8107E+02,5.6755E+02,4.5403E+02,3.4053E+02,
     &2.2701E+02,1.1352E+02,7.1564E-02,9.0605E+02,7.9275E+02,6.7956E+02,
     &5.6628E+02,4.5302E+02,3.3978E+02,2.2652E+02,1.1325E+02,1.1086E-01,
     &9.0093E+02,7.8832E+02,6.7569E+02,5.6306E+02,4.5046E+02,3.3783E+02,
     &2.2521E+02,1.1262E+02,1.6463E-01,8.9363E+02,7.8197E+02,6.7027E+02,
     &5.5850E+02,4.4681E+02,3.3513E+02,2.2342E+02,1.1170E+02,2.3145E-01,
     &8.8174E+02,7.7148E+02,6.6129E+02,5.5110E+02,4.4085E+02,3.3064E+02,
     &2.2045E+02,1.1021E+02,3.1429E-01/
      DATA ((KA(JS,JT, 9,12),JS=1,9),JT=1,5) /
     &4.0575E+03,3.5502E+03,3.0431E+03,2.5358E+03,2.0286E+03,1.5215E+03,
     &1.0143E+03,5.0720E+02,5.5603E-02,4.0575E+03,3.5503E+03,3.0431E+03,
     &2.5359E+03,2.0286E+03,1.5216E+03,1.0143E+03,5.0715E+02,8.8381E-02,
     &4.0490E+03,3.5425E+03,3.0365E+03,2.5303E+03,2.0243E+03,1.5183E+03,
     &1.0122E+03,5.0611E+02,1.3462E-01,4.0163E+03,3.5141E+03,3.0122E+03,
     &2.5100E+03,2.0082E+03,1.5061E+03,1.0041E+03,5.0202E+02,1.9418E-01,
     &3.9738E+03,3.4768E+03,2.9801E+03,2.4835E+03,1.9868E+03,1.4900E+03,
     &9.9338E+02,4.9668E+02,2.7001E-01/
      DATA ((KA(JS,JT,10,12),JS=1,9),JT=1,5) /
     &2.0782E+04,1.8184E+04,1.5586E+04,1.2989E+04,1.0391E+04,7.7931E+03,
     &5.1956E+03,2.5977E+03,1.5076E-02,2.0847E+04,1.8242E+04,1.5636E+04,
     &1.3030E+04,1.0424E+04,7.8180E+03,5.2120E+03,2.6061E+03,3.9283E-02,
     &2.0776E+04,1.8179E+04,1.5582E+04,1.2985E+04,1.0387E+04,7.7905E+03,
     &5.1937E+03,2.5968E+03,5.3678E-02,2.0635E+04,1.8055E+04,1.5476E+04,
     &1.2897E+04,1.0317E+04,7.7379E+03,5.1584E+03,2.5793E+03,8.4869E-02,
     &2.0468E+04,1.7910E+04,1.5352E+04,1.2793E+04,1.0235E+04,7.6761E+03,
     &5.1174E+03,2.5585E+03,1.7840E-01/
      DATA ((KA(JS,JT,11,12),JS=1,9),JT=1,5) /
     &3.8086E+04,3.3327E+04,2.8563E+04,2.3804E+04,1.9042E+04,1.4282E+04,
     &9.5217E+03,4.7607E+03,3.5535E-02,3.8167E+04,3.3395E+04,2.8624E+04,
     &2.3853E+04,1.9083E+04,1.4312E+04,9.5414E+03,4.7707E+03,2.0336E-02,
     &3.8095E+04,3.3333E+04,2.8571E+04,2.3809E+04,1.9048E+04,1.4285E+04,
     &9.5235E+03,4.7617E+03,7.3058E-02,3.7840E+04,3.3110E+04,2.8380E+04,
     &2.3651E+04,1.8921E+04,1.4191E+04,9.4603E+03,4.7302E+03,9.2342E-02,
     &3.7466E+04,3.2782E+04,2.8098E+04,2.3416E+04,1.8732E+04,1.4049E+04,
     &9.3659E+03,4.6831E+03,1.1387E-01/
      DATA ((KA(JS,JT,12,12),JS=1,9),JT=1,5) /
     &5.3068E+04,4.6434E+04,3.9801E+04,3.3167E+04,2.6533E+04,1.9901E+04,
     &1.3266E+04,6.6334E+03,5.3631E-05,5.2912E+04,4.6296E+04,3.9684E+04,
     &3.3067E+04,2.6455E+04,1.9841E+04,1.3228E+04,6.6136E+03,3.3045E-02,
     &5.2742E+04,4.6150E+04,3.9556E+04,3.2963E+04,2.6372E+04,1.9779E+04,
     &1.3186E+04,6.5925E+03,2.4038E-02,5.2329E+04,4.5788E+04,3.9248E+04,
     &3.2707E+04,2.6165E+04,1.9623E+04,1.3082E+04,6.5410E+03,8.8033E-02,
     &5.1702E+04,4.5237E+04,3.8772E+04,3.2311E+04,2.5848E+04,1.9386E+04,
     &1.2925E+04,6.4623E+03,1.0528E-01/
      DATA ((KA(JS,JT,13,12),JS=1,9),JT=1,5) /
     &5.9181E+04,5.1784E+04,4.4385E+04,3.6986E+04,2.9590E+04,2.2192E+04,
     &1.4795E+04,7.3976E+03,6.3472E-05,5.9042E+04,5.1661E+04,4.4282E+04,
     &3.6901E+04,2.9521E+04,2.2141E+04,1.4760E+04,7.3802E+03,8.2093E-03,
     &5.8661E+04,5.1328E+04,4.3997E+04,3.6663E+04,2.9331E+04,2.1998E+04,
     &1.4665E+04,7.3324E+03,2.9843E-02,5.8145E+04,5.0874E+04,4.3608E+04,
     &3.6342E+04,2.9072E+04,2.1804E+04,1.4536E+04,7.2678E+03,5.7821E-02,
     &5.7447E+04,5.0266E+04,4.3086E+04,3.5905E+04,2.8722E+04,2.1542E+04,
     &1.4361E+04,7.1808E+03,1.1510E-01/
      DATA ((KA(JS,JT, 1,13),JS=1,9),JT=1,5) /
     &9.2441E+00,8.0893E+00,6.9334E+00,5.7782E+00,4.6228E+00,3.4672E+00,
     &2.3119E+00,1.1567E+00,2.2855E-01,8.8623E+00,7.7552E+00,6.6473E+00,
     &5.5397E+00,4.4320E+00,3.3245E+00,2.2168E+00,1.1091E+00,3.2335E-01,
     &8.4833E+00,7.4233E+00,6.3625E+00,5.3026E+00,4.2423E+00,3.1825E+00,
     &2.1219E+00,1.0618E+00,4.4367E-01,8.1215E+00,7.1065E+00,6.0917E+00,
     &5.0761E+00,4.0614E+00,3.0468E+00,2.0316E+00,1.0641E+00,5.9167E-01,
     &7.7672E+00,6.7964E+00,5.8258E+00,4.8545E+00,3.8845E+00,2.9137E+00,
     &1.9430E+00,1.0446E+00,7.6901E-01/
      DATA ((KA(JS,JT, 2,13),JS=1,9),JT=1,5) /
     &1.4699E+01,1.2863E+01,1.1024E+01,9.1876E+00,7.3499E+00,5.5129E+00,
     &3.6758E+00,1.8383E+00,2.1901E-01,1.4081E+01,1.2321E+01,1.0561E+01,
     &8.8012E+00,7.0414E+00,5.2809E+00,3.5211E+00,1.7613E+00,3.1665E-01,
     &1.3470E+01,1.1786E+01,1.0102E+01,8.4178E+00,6.7345E+00,5.0512E+00,
     &3.3678E+00,1.6847E+00,4.4141E-01,1.2871E+01,1.1263E+01,9.6542E+00,
     &8.0452E+00,6.4365E+00,4.8276E+00,3.2187E+00,1.6111E+00,5.9558E-01,
     &1.2298E+01,1.0761E+01,9.2242E+00,7.6869E+00,6.1502E+00,4.6127E+00,
     &3.0756E+00,1.6035E+00,7.7652E-01/
      DATA ((KA(JS,JT, 3,13),JS=1,9),JT=1,5) /
     &3.1779E+01,2.7807E+01,2.3834E+01,1.9863E+01,1.5890E+01,1.1918E+01,
     &7.9454E+00,3.9733E+00,1.9638E-01,3.0431E+01,2.6628E+01,2.2823E+01,
     &1.9020E+01,1.5217E+01,1.1412E+01,7.6086E+00,3.8049E+00,2.7736E-01,
     &2.9103E+01,2.5465E+01,2.1826E+01,1.8188E+01,1.4551E+01,1.0914E+01,
     &7.2766E+00,3.6387E+00,3.9551E-01,2.7810E+01,2.4334E+01,2.0858E+01,
     &1.7381E+01,1.3906E+01,1.0429E+01,6.9532E+00,3.4769E+00,5.4452E-01,
     &2.6585E+01,2.3262E+01,1.9938E+01,1.6616E+01,1.3293E+01,9.9693E+00,
     &6.6465E+00,3.3243E+00,7.1925E-01/
      DATA ((KA(JS,JT, 4,13),JS=1,9),JT=1,5) /
     &7.0542E+01,6.1725E+01,5.2909E+01,4.4087E+01,3.5272E+01,2.6453E+01,
     &1.7635E+01,8.8184E+00,1.8199E-01,6.7511E+01,5.9069E+01,5.0634E+01,
     &4.2192E+01,3.3755E+01,2.5317E+01,1.6878E+01,8.4389E+00,2.4599E-01,
     &6.4633E+01,5.6554E+01,4.8477E+01,4.0397E+01,3.2316E+01,2.4237E+01,
     &1.6158E+01,8.0799E+00,3.3970E-01,6.1828E+01,5.4103E+01,4.6370E+01,
     &3.8643E+01,3.0915E+01,2.3186E+01,1.5458E+01,7.7299E+00,4.6987E-01,
     &5.9112E+01,5.1730E+01,4.4337E+01,3.6946E+01,2.9558E+01,2.2169E+01,
     &1.4779E+01,7.3903E+00,6.3062E-01/
      DATA ((KA(JS,JT, 5,13),JS=1,9),JT=1,5) /
     &1.4439E+02,1.2634E+02,1.0830E+02,9.0248E+01,7.2199E+01,5.4151E+01,
     &3.6099E+01,1.8050E+01,1.6579E-01,1.3838E+02,1.2109E+02,1.0378E+02,
     &8.6480E+01,6.9180E+01,5.1890E+01,3.4593E+01,1.7299E+01,2.2988E-01,
     &1.3259E+02,1.1602E+02,9.9432E+01,8.2860E+01,6.6285E+01,4.9718E+01,
     &3.3146E+01,1.6573E+01,3.1063E-01,1.2697E+02,1.1110E+02,9.5219E+01,
     &7.9357E+01,6.3482E+01,4.7609E+01,3.1740E+01,1.5871E+01,4.1510E-01,
     &1.2152E+02,1.0632E+02,9.1129E+01,7.5942E+01,6.0752E+01,4.5568E+01,
     &3.0378E+01,1.5190E+01,5.5503E-01/
      DATA ((KA(JS,JT, 6,13),JS=1,9),JT=1,5) /
     &2.7815E+02,2.4339E+02,2.0862E+02,1.7384E+02,1.3908E+02,1.0430E+02,
     &6.9541E+01,3.4769E+01,1.4932E-01,2.6703E+02,2.3365E+02,2.0028E+02,
     &1.6690E+02,1.3351E+02,1.0014E+02,6.6764E+01,3.3381E+01,2.1038E-01,
     &2.5610E+02,2.2409E+02,1.9207E+02,1.6007E+02,1.2805E+02,9.6039E+01,
     &6.4025E+01,3.2016E+01,2.9193E-01,2.4602E+02,2.1527E+02,1.8451E+02,
     &1.5376E+02,1.2300E+02,9.2253E+01,6.1503E+01,3.0752E+01,3.8735E-01,
     &2.3698E+02,2.0737E+02,1.7775E+02,1.4811E+02,1.1849E+02,8.8866E+01,
     &5.9248E+01,2.9622E+01,5.0567E-01/
      DATA ((KA(JS,JT, 7,13),JS=1,9),JT=1,5) /
     &5.6531E+02,4.9465E+02,4.2396E+02,3.5331E+02,2.8267E+02,2.1198E+02,
     &1.4132E+02,7.0665E+01,1.3236E-01,5.4477E+02,4.7663E+02,4.0854E+02,
     &3.4045E+02,2.7236E+02,2.0426E+02,1.3618E+02,6.8089E+01,1.9224E-01,
     &5.2553E+02,4.5986E+02,3.9416E+02,3.2848E+02,2.6277E+02,1.9706E+02,
     &1.3138E+02,6.5693E+01,2.7007E-01,5.0736E+02,4.4395E+02,3.8050E+02,
     &3.1709E+02,2.5367E+02,1.9026E+02,1.2684E+02,6.3421E+01,3.6853E-01,
     &4.8966E+02,4.2846E+02,3.6727E+02,3.0605E+02,2.4484E+02,1.8364E+02,
     &1.2242E+02,6.1208E+01,4.8516E-01/
      DATA ((KA(JS,JT, 8,13),JS=1,9),JT=1,5) /
     &1.3865E+03,1.2132E+03,1.0399E+03,8.6656E+02,6.9323E+02,5.1995E+02,
     &3.4663E+02,1.7332E+02,1.1342E-01,1.3418E+03,1.1740E+03,1.0063E+03,
     &8.3858E+02,6.7084E+02,5.0312E+02,3.3544E+02,1.6771E+02,1.7153E-01,
     &1.2982E+03,1.1360E+03,9.7362E+02,8.1138E+02,6.4912E+02,4.8683E+02,
     &3.2456E+02,1.6229E+02,2.4648E-01,1.2554E+03,1.0986E+03,9.4155E+02,
     &7.8470E+02,6.2776E+02,4.7081E+02,3.1388E+02,1.5694E+02,3.4456E-01,
     &1.2173E+03,1.0650E+03,9.1289E+02,7.6069E+02,6.0860E+02,4.5645E+02,
     &3.0428E+02,1.5215E+02,4.6320E-01/
      DATA ((KA(JS,JT, 9,13),JS=1,9),JT=1,5) /
     &6.4287E+03,5.6254E+03,4.8220E+03,4.0184E+03,3.2146E+03,2.4108E+03,
     &1.6072E+03,8.0366E+02,9.3435E-02,6.2433E+03,5.4627E+03,4.6824E+03,
     &3.9018E+03,3.1215E+03,2.3411E+03,1.5608E+03,7.8032E+02,1.4681E-01,
     &6.0612E+03,5.3034E+03,4.5455E+03,3.7883E+03,3.0305E+03,2.2728E+03,
     &1.5153E+03,7.5756E+02,2.1819E-01,5.8977E+03,5.1604E+03,4.4231E+03,
     &3.6861E+03,2.9487E+03,2.2117E+03,1.4744E+03,7.3720E+02,3.1394E-01,
     &5.7293E+03,5.0131E+03,4.2969E+03,3.5807E+03,2.8646E+03,2.1484E+03,
     &1.4323E+03,7.1617E+02,4.3083E-01/
      DATA ((KA(JS,JT,10,13),JS=1,9),JT=1,5) /
     &3.3200E+04,2.9050E+04,2.4899E+04,2.0749E+04,1.6600E+04,1.2450E+04,
     &8.2998E+03,4.1501E+03,1.3035E-02,3.2379E+04,2.8331E+04,2.4286E+04,
     &2.0236E+04,1.6189E+04,1.2142E+04,8.0946E+03,4.0474E+03,6.4014E-02,
     &3.1566E+04,2.7621E+04,2.3674E+04,1.9730E+04,1.5784E+04,1.1837E+04,
     &7.8919E+03,3.9461E+03,1.0897E-01,3.0728E+04,2.6888E+04,2.3048E+04,
     &1.9205E+04,1.5364E+04,1.1523E+04,7.6820E+03,3.8409E+03,2.5342E-01,
     &2.9824E+04,2.6098E+04,2.2369E+04,1.8641E+04,1.4913E+04,1.1185E+04,
     &7.4563E+03,3.7282E+03,3.9865E-01/
      DATA ((KA(JS,JT,11,13),JS=1,9),JT=1,5) /
     &5.8997E+04,5.1626E+04,4.4246E+04,3.6876E+04,2.9498E+04,2.2124E+04,
     &1.4750E+04,7.3749E+03,3.4853E-05,5.7601E+04,5.0403E+04,4.3203E+04,
     &3.6002E+04,2.8802E+04,2.1601E+04,1.4400E+04,7.2004E+03,3.9149E-02,
     &5.6184E+04,4.9162E+04,4.2136E+04,3.5117E+04,2.8092E+04,2.1068E+04,
     &1.4046E+04,7.0226E+03,4.1745E-02,5.4639E+04,4.7807E+04,4.0979E+04,
     &3.4149E+04,2.7319E+04,2.0489E+04,1.3659E+04,6.8303E+03,1.4397E-01,
     &5.3017E+04,4.6389E+04,3.9763E+04,3.3137E+04,2.6509E+04,1.9881E+04,
     &1.3255E+04,6.6269E+03,2.2772E-01/
      DATA ((KA(JS,JT,12,13),JS=1,9),JT=1,5) /
     &7.7971E+04,6.8226E+04,5.8475E+04,4.8732E+04,3.8985E+04,2.9238E+04,
     &1.9491E+04,9.7458E+03,2.6211E-05,7.6358E+04,6.6812E+04,5.7265E+04,
     &4.7721E+04,3.8180E+04,2.8631E+04,1.9088E+04,9.5449E+03,1.6658E-02,
     &7.4598E+04,6.5272E+04,5.5949E+04,4.6623E+04,3.7300E+04,2.7976E+04,
     &1.8650E+04,9.3250E+03,6.1472E-02,7.2683E+04,6.3600E+04,5.4513E+04,
     &4.5429E+04,3.6343E+04,2.7256E+04,1.8171E+04,9.0852E+03,8.7020E-02,
     &7.0749E+04,6.1901E+04,5.3059E+04,4.4221E+04,3.5375E+04,2.6529E+04,
     &1.7687E+04,8.8438E+03,2.2135E-01/
      DATA ((KA(JS,JT,13,13),JS=1,9),JT=1,5) /
     &8.4389E+04,7.3841E+04,6.3292E+04,5.2741E+04,4.2193E+04,3.1646E+04,
     &2.1097E+04,1.0548E+04,3.5977E-05,8.2810E+04,7.2462E+04,6.2107E+04,
     &5.1755E+04,4.1404E+04,3.1055E+04,2.0703E+04,1.0351E+04,2.8201E-02,
     &8.1175E+04,7.1028E+04,6.0878E+04,5.0733E+04,4.0585E+04,3.0440E+04,
     &2.0293E+04,1.0147E+04,3.8140E-02,7.9409E+04,6.9476E+04,5.9554E+04,
     &4.9626E+04,3.9700E+04,2.9777E+04,1.9850E+04,9.9254E+03,1.0573E-01,
     &7.7670E+04,6.7959E+04,5.8251E+04,4.8545E+04,3.8836E+04,2.9127E+04,
     &1.9417E+04,9.7081E+03,2.2322E-01/
      DATA ((KA(JS,JT, 1,14),JS=1,9),JT=1,5) /
     &1.0586E+01,9.2639E+00,7.9401E+00,6.6170E+00,5.2941E+00,3.9707E+00,
     &2.6478E+00,1.3250E+00,4.3918E-01,1.0067E+01,8.8090E+00,7.5510E+00,
     &6.2924E+00,5.0343E+00,3.7761E+00,2.5179E+00,1.2597E+00,5.9709E-01,
     &9.5510E+00,8.3580E+00,7.1635E+00,5.9699E+00,4.7763E+00,3.5829E+00,
     &2.3891E+00,1.1957E+00,7.8623E-01,9.0745E+00,7.9402E+00,6.8068E+00,
     &5.6724E+00,4.5382E+00,3.4039E+00,2.2698E+00,1.1544E+00,1.0064E+00,
     &8.6119E+00,7.5354E+00,6.4586E+00,5.3823E+00,4.3069E+00,3.2305E+00,
     &2.1544E+00,1.1513E+00,1.2568E+00/
      DATA ((KA(JS,JT, 2,14),JS=1,9),JT=1,5) /
     &1.7127E+01,1.4988E+01,1.2847E+01,1.0706E+01,8.5644E+00,6.4237E+00,
     &4.2830E+00,2.1424E+00,4.0087E-01,1.6266E+01,1.4233E+01,1.2199E+01,
     &1.0167E+01,8.1334E+00,6.1003E+00,4.0675E+00,2.0344E+00,5.5811E-01,
     &1.5417E+01,1.3492E+01,1.1564E+01,9.6364E+00,7.7096E+00,5.7829E+00,
     &3.8557E+00,1.9285E+00,7.4958E-01,1.4610E+01,1.2785E+01,1.0958E+01,
     &9.1323E+00,7.3057E+00,5.4803E+00,3.6538E+00,1.8278E+00,9.7668E-01,
     &1.3849E+01,1.2118E+01,1.0388E+01,8.6567E+00,6.9253E+00,5.1944E+00,
     &3.4637E+00,1.7621E+00,1.2463E+00/
      DATA ((KA(JS,JT, 3,14),JS=1,9),JT=1,5) /
     &3.7731E+01,3.3014E+01,2.8298E+01,2.3584E+01,1.8865E+01,1.4149E+01,
     &9.4337E+00,4.7180E+00,3.4082E-01,3.5785E+01,3.1314E+01,2.6842E+01,
     &2.2368E+01,1.7895E+01,1.3421E+01,8.9480E+00,4.4747E+00,4.8919E-01,
     &3.3896E+01,2.9659E+01,2.5426E+01,2.1185E+01,1.6948E+01,1.2712E+01,
     &8.4759E+00,4.2386E+00,6.7406E-01,3.2057E+01,2.8051E+01,2.4047E+01,
     &2.0037E+01,1.6031E+01,1.2024E+01,8.0158E+00,4.0086E+00,8.9895E-01,
     &3.0352E+01,2.6560E+01,2.2767E+01,1.8972E+01,1.5176E+01,1.1383E+01,
     &7.5899E+00,3.7954E+00,1.1745E+00/
      DATA ((KA(JS,JT, 4,14),JS=1,9),JT=1,5) /
     &8.5512E+01,7.4816E+01,6.4130E+01,5.3439E+01,4.2750E+01,3.2066E+01,
     &2.1376E+01,1.0689E+01,2.7979E-01,8.0825E+01,7.0719E+01,6.0615E+01,
     &5.0514E+01,4.0410E+01,3.0306E+01,2.0206E+01,1.0104E+01,4.1456E-01,
     &7.6512E+01,6.6951E+01,5.7383E+01,4.7821E+01,3.8259E+01,2.8694E+01,
     &1.9130E+01,9.5655E+00,5.8875E-01,7.2339E+01,6.3299E+01,5.4254E+01,
     &4.5213E+01,3.6173E+01,2.7127E+01,1.8087E+01,9.0435E+00,8.0998E-01,
     &6.8331E+01,5.9800E+01,5.1253E+01,4.2714E+01,3.4172E+01,2.5627E+01,
     &1.7086E+01,8.5443E+00,1.0852E+00/
      DATA ((KA(JS,JT, 5,14),JS=1,9),JT=1,5) /
     &1.7862E+02,1.5630E+02,1.3397E+02,1.1164E+02,8.9317E+01,6.6992E+01,
     &4.4659E+01,2.2329E+01,2.4222E-01,1.6866E+02,1.4756E+02,1.2649E+02,
     &1.0541E+02,8.4332E+01,6.3244E+01,4.2162E+01,2.1082E+01,3.4856E-01,
     &1.5941E+02,1.3948E+02,1.1955E+02,9.9631E+01,7.9709E+01,5.9780E+01,
     &3.9852E+01,1.9927E+01,5.0734E-01,1.5067E+02,1.3184E+02,1.1302E+02,
     &9.4183E+01,7.5341E+01,5.6507E+01,3.7674E+01,1.8837E+01,7.2180E-01,
     &1.4230E+02,1.2451E+02,1.0671E+02,8.8935E+01,7.1153E+01,5.3363E+01,
     &3.5577E+01,1.7789E+01,9.9362E-01/
      DATA ((KA(JS,JT, 6,14),JS=1,9),JT=1,5) /
     &3.5096E+02,3.0703E+02,2.6318E+02,2.1933E+02,1.7546E+02,1.3159E+02,
     &8.7733E+01,4.3865E+01,2.1734E-01,3.3138E+02,2.8996E+02,2.4854E+02,
     &2.0711E+02,1.6569E+02,1.2426E+02,8.2845E+01,4.1423E+01,3.0507E-01,
     &3.1254E+02,2.7346E+02,2.3441E+02,1.9532E+02,1.5627E+02,1.1720E+02,
     &7.8130E+01,3.9066E+01,4.3270E-01,2.9529E+02,2.5841E+02,2.2148E+02,
     &1.8456E+02,1.4764E+02,1.1074E+02,7.3826E+01,3.6914E+01,6.2701E-01,
     &2.7880E+02,2.4396E+02,2.0911E+02,1.7424E+02,1.3940E+02,1.0455E+02,
     &6.9706E+01,3.4852E+01,8.8890E-01/
      DATA ((KA(JS,JT, 7,14),JS=1,9),JT=1,5) /
     &7.2513E+02,6.3446E+02,5.4381E+02,4.5320E+02,3.6257E+02,2.7191E+02,
     &1.8128E+02,9.0650E+01,1.9831E-01,6.8456E+02,5.9902E+02,5.1343E+02,
     &4.2785E+02,3.4230E+02,2.5672E+02,1.7115E+02,8.5572E+01,2.7818E-01,
     &6.4547E+02,5.6482E+02,4.8412E+02,4.0342E+02,3.2273E+02,2.4204E+02,
     &1.6137E+02,8.0688E+01,3.8833E-01,6.0978E+02,5.3357E+02,4.5735E+02,
     &3.8114E+02,3.0489E+02,2.2868E+02,1.5246E+02,7.6224E+01,5.4866E-01,
     &5.7729E+02,5.0509E+02,4.3294E+02,3.6078E+02,2.8862E+02,2.1646E+02,
     &1.4432E+02,7.2163E+01,7.7837E-01/
      DATA ((KA(JS,JT, 8,14),JS=1,9),JT=1,5) /
     &1.7967E+03,1.5721E+03,1.3476E+03,1.1230E+03,8.9837E+02,6.7379E+02,
     &4.4917E+02,2.2458E+02,1.7788E-01,1.7006E+03,1.4881E+03,1.2754E+03,
     &1.0629E+03,8.5028E+02,6.3778E+02,4.2515E+02,2.1258E+02,2.5421E-01,
     &1.6106E+03,1.4094E+03,1.2079E+03,1.0068E+03,8.0532E+02,6.0404E+02,
     &4.0268E+02,2.0135E+02,3.5995E-01,1.5246E+03,1.3340E+03,1.1435E+03,
     &9.5278E+02,7.6226E+02,5.7172E+02,3.8114E+02,1.9058E+02,4.9908E-01,
     &1.4465E+03,1.2656E+03,1.0849E+03,9.0407E+02,7.2320E+02,5.4242E+02,
     &3.6158E+02,1.8081E+02,6.9586E-01/
      DATA ((KA(JS,JT, 9,14),JS=1,9),JT=1,5) /
     &8.4840E+03,7.4233E+03,6.3628E+03,5.3023E+03,4.2423E+03,3.1813E+03,
     &2.1210E+03,1.0605E+03,1.5591E-01,8.0479E+03,7.0418E+03,6.0359E+03,
     &5.0301E+03,4.0241E+03,3.0180E+03,2.0121E+03,1.0060E+03,2.2879E-01,
     &7.6325E+03,6.6786E+03,5.7241E+03,4.7707E+03,3.8161E+03,2.8622E+03,
     &1.9081E+03,9.5403E+02,3.3113E-01,7.2431E+03,6.3376E+03,5.4325E+03,
     &4.5268E+03,3.6217E+03,2.7162E+03,1.8109E+03,9.0539E+02,4.6545E-01,
     &6.8956E+03,6.0340E+03,5.1720E+03,4.3099E+03,3.4482E+03,2.5859E+03,
     &1.7240E+03,8.6204E+02,6.4091E-01/
      DATA ((KA(JS,JT,10,14),JS=1,9),JT=1,5) /
     &4.4703E+04,3.9114E+04,3.3523E+04,2.7938E+04,2.2351E+04,1.6764E+04,
     &1.1175E+04,5.5874E+03,4.1455E-02,4.2474E+04,3.7167E+04,3.1854E+04,
     &2.6544E+04,2.1238E+04,1.5927E+04,1.0619E+04,5.3089E+03,6.6750E-02,
     &4.0460E+04,3.5405E+04,3.0347E+04,2.5289E+04,2.0232E+04,1.5174E+04,
     &1.0116E+04,5.0578E+03,2.7442E-01,3.8625E+04,3.3797E+04,2.8970E+04,
     &2.4141E+04,1.9313E+04,1.4484E+04,9.6562E+03,4.8282E+03,4.4714E-01,
     &3.6998E+04,3.2375E+04,2.7750E+04,2.3124E+04,1.8498E+04,1.3874E+04,
     &9.2495E+03,4.6247E+03,6.1795E-01/
      DATA ((KA(JS,JT,11,14),JS=1,9),JT=1,5) /
     &8.0689E+04,7.0605E+04,6.0514E+04,5.0431E+04,4.0345E+04,3.0258E+04,
     &2.0175E+04,1.0088E+04,2.7556E-05,7.7103E+04,6.7463E+04,5.7832E+04,
     &4.8186E+04,3.8550E+04,2.8913E+04,1.9275E+04,9.6376E+03,4.0930E-02,
     &7.3820E+04,6.4596E+04,5.5369E+04,4.6139E+04,3.6913E+04,2.7687E+04,
     &1.8457E+04,9.2272E+03,8.1894E-02,7.1047E+04,6.2162E+04,5.3281E+04,
     &4.4402E+04,3.5522E+04,2.6643E+04,1.7761E+04,8.8802E+03,2.3203E-01,
     &6.8729E+04,6.0139E+04,5.1549E+04,4.2956E+04,3.4366E+04,2.5774E+04,
     &1.7184E+04,8.5912E+03,5.4821E-01/
      DATA ((KA(JS,JT,12,14),JS=1,9),JT=1,5) /
     &1.0931E+05,9.5652E+04,8.1990E+04,6.8319E+04,5.4655E+04,4.0991E+04,
     &2.7328E+04,1.3665E+04,2.8846E-05,1.0521E+05,9.2062E+04,7.8903E+04,
     &6.5759E+04,5.2606E+04,3.9453E+04,2.6301E+04,1.3151E+04,4.7358E-02,
     &1.0163E+05,8.8927E+04,7.6219E+04,6.3520E+04,5.0816E+04,3.8110E+04,
     &2.5405E+04,1.2704E+04,2.4382E-02,9.8710E+04,8.6365E+04,7.4034E+04,
     &6.1691E+04,4.9353E+04,3.7016E+04,2.4677E+04,1.2338E+04,1.4381E-01,
     &9.6361E+04,8.4318E+04,7.2271E+04,6.0231E+04,4.8183E+04,3.6135E+04,
     &2.4090E+04,1.2044E+04,3.4843E-01/
      DATA ((KA(JS,JT,13,14),JS=1,9),JT=1,5) /
     &1.2026E+05,1.0522E+05,9.0197E+04,7.5158E+04,6.0121E+04,4.5095E+04,
     &3.0062E+04,1.5030E+04,2.3562E-05,1.1659E+05,1.0201E+05,8.7436E+04,
     &7.2864E+04,5.8293E+04,4.3717E+04,2.9144E+04,1.4573E+04,1.6351E-02,
     &1.1367E+05,9.9464E+04,8.5255E+04,7.1046E+04,5.6835E+04,4.2627E+04,
     &2.8420E+04,1.4209E+04,2.9522E-02,1.1129E+05,9.7380E+04,8.3472E+04,
     &6.9552E+04,5.5648E+04,4.1732E+04,2.7823E+04,1.3911E+04,7.5810E-02,
     &1.0918E+05,9.5534E+04,8.1880E+04,6.8241E+04,5.4595E+04,4.0946E+04,
     &2.7297E+04,1.3648E+04,2.4333E-01/
      DATA ((KA(JS,JT, 1,15),JS=1,9),JT=1,5) /
     &1.0978E+01,9.6088E+00,8.2350E+00,6.8632E+00,5.4910E+00,4.1182E+00,
     &2.7459E+00,1.3741E+00,7.5097E-01,1.0420E+01,9.1192E+00,7.8159E+00,
     &6.5136E+00,5.2114E+00,3.9092E+00,2.6067E+00,1.3044E+00,1.0341E+00,
     &9.8688E+00,8.6360E+00,7.4026E+00,6.1689E+00,4.9358E+00,3.7018E+00,
     &2.4689E+00,1.2355E+00,1.3726E+00,9.3623E+00,8.1910E+00,7.0229E+00,
     &5.8526E+00,4.6825E+00,3.5124E+00,2.3423E+00,1.1838E+00,1.7645E+00,
     &8.8716E+00,7.7621E+00,6.6540E+00,5.5450E+00,4.4367E+00,3.3283E+00,
     &2.2197E+00,1.4532E+00,2.2082E+00/
      DATA ((KA(JS,JT, 2,15),JS=1,9),JT=1,5) /
     &1.7872E+01,1.5635E+01,1.3402E+01,1.1169E+01,8.9360E+00,6.7019E+00,
     &4.4692E+00,2.2349E+00,7.8713E-01,1.6936E+01,1.4818E+01,1.2703E+01,
     &1.0586E+01,8.4684E+00,6.3517E+00,4.2352E+00,2.1186E+00,1.1015E+00,
     &1.6019E+01,1.4019E+01,1.2014E+01,1.0011E+01,8.0107E+00,6.0080E+00,
     &4.0069E+00,2.0039E+00,1.4812E+00,1.5152E+01,1.3257E+01,1.1364E+01,
     &9.4698E+00,7.5770E+00,5.6829E+00,3.7895E+00,1.8958E+00,1.9253E+00,
     &1.4341E+01,1.2547E+01,1.0755E+01,8.9625E+00,7.1702E+00,5.3783E+00,
     &3.5866E+00,1.8251E+00,2.4314E+00/
      DATA ((KA(JS,JT, 3,15),JS=1,9),JT=1,5) /
     &3.9644E+01,3.4688E+01,2.9736E+01,2.4782E+01,1.9827E+01,1.4870E+01,
     &9.9132E+00,4.9569E+00,7.5098E-01,3.7522E+01,3.2831E+01,2.8147E+01,
     &2.3453E+01,1.8762E+01,1.4073E+01,9.3827E+00,4.6920E+00,1.0782E+00,
     &3.5460E+01,3.1027E+01,2.6599E+01,2.2162E+01,1.7731E+01,1.3300E+01,
     &8.8666E+00,4.4344E+00,1.4809E+00,3.3460E+01,2.9273E+01,2.5092E+01,
     &2.0911E+01,1.6733E+01,1.2547E+01,8.3663E+00,4.1837E+00,1.9598E+00,
     &3.1621E+01,2.7670E+01,2.3718E+01,1.9764E+01,1.5811E+01,1.1859E+01,
     &7.9074E+00,3.9548E+00,2.5132E+00/
      DATA ((KA(JS,JT, 4,15),JS=1,9),JT=1,5) /
     &9.0592E+01,7.9274E+01,6.7952E+01,5.6623E+01,4.5292E+01,3.3974E+01,
     &2.2650E+01,1.1327E+01,6.7358E-01,8.5357E+01,7.4682E+01,6.4009E+01,
     &5.3347E+01,4.2676E+01,3.2015E+01,2.1340E+01,1.0671E+01,9.9693E-01,
     &8.0608E+01,7.0531E+01,6.0449E+01,5.0384E+01,4.0308E+01,3.0230E+01,
     &2.0154E+01,1.0079E+01,1.4044E+00,7.6021E+01,6.6519E+01,5.7017E+01,
     &4.7513E+01,3.8009E+01,2.8510E+01,1.9006E+01,9.5047E+00,1.8983E+00,
     &7.1646E+01,6.2695E+01,5.3735E+01,4.4783E+01,3.5822E+01,2.6870E+01,
     &1.7917E+01,8.9586E+00,2.4776E+00/
      DATA ((KA(JS,JT, 5,15),JS=1,9),JT=1,5) /
     &1.9065E+02,1.6683E+02,1.4299E+02,1.1917E+02,9.5320E+01,7.1489E+01,
     &4.7665E+01,2.3834E+01,5.8170E-01,1.7924E+02,1.5681E+02,1.3443E+02,
     &1.1201E+02,8.9613E+01,6.7209E+01,4.4814E+01,2.2406E+01,8.9003E-01,
     &1.6878E+02,1.4769E+02,1.2660E+02,1.0549E+02,8.4396E+01,6.3295E+01,
     &4.2198E+01,2.1098E+01,1.2889E+00,1.5901E+02,1.3914E+02,1.1927E+02,
     &9.9403E+01,7.9524E+01,5.9641E+01,3.9759E+01,1.9881E+01,1.7818E+00,
     &1.4967E+02,1.3098E+02,1.1227E+02,9.3560E+01,7.4846E+01,5.6123E+01,
     &3.7423E+01,1.8714E+01,2.3703E+00/
      DATA ((KA(JS,JT, 6,15),JS=1,9),JT=1,5) /
     &3.7689E+02,3.2969E+02,2.8264E+02,2.3553E+02,1.8841E+02,1.4134E+02,
     &9.4214E+01,4.7104E+01,4.7634E-01,3.5386E+02,3.0960E+02,2.6540E+02,
     &2.2119E+02,1.7694E+02,1.3270E+02,8.8456E+01,4.4232E+01,7.5759E-01,
     &3.3202E+02,2.9052E+02,2.4901E+02,2.0752E+02,1.6601E+02,1.2451E+02,
     &8.3003E+01,4.1506E+01,1.1321E+00,3.1280E+02,2.7368E+02,2.3460E+02,
     &1.9550E+02,1.5640E+02,1.1729E+02,7.8200E+01,3.9102E+01,1.6067E+00,
     &2.9457E+02,2.5772E+02,2.2093E+02,1.8412E+02,1.4729E+02,1.1048E+02,
     &7.3641E+01,3.6825E+01,2.1838E+00/
      DATA ((KA(JS,JT, 7,15),JS=1,9),JT=1,5) /
     &7.8539E+02,6.8719E+02,5.8900E+02,4.9081E+02,3.9268E+02,2.9449E+02,
     &1.9633E+02,9.8167E+01,3.8693E-01,7.3697E+02,6.4481E+02,5.5276E+02,
     &4.6063E+02,3.6848E+02,2.7636E+02,1.8426E+02,9.2135E+01,6.2265E-01,
     &6.9166E+02,6.0516E+02,5.1875E+02,4.3231E+02,3.4580E+02,2.5935E+02,
     &1.7293E+02,8.6458E+01,9.6225E-01,6.5012E+02,5.6880E+02,4.8758E+02,
     &4.0634E+02,3.2506E+02,2.4380E+02,1.6251E+02,8.1260E+01,1.4063E+00,
     &6.1251E+02,5.3595E+02,4.5937E+02,3.8280E+02,3.0627E+02,2.2970E+02,
     &1.5314E+02,7.6572E+01,1.9665E+00/
      DATA ((KA(JS,JT, 8,15),JS=1,9),JT=1,5) /
     &1.9678E+03,1.7217E+03,1.4759E+03,1.2298E+03,9.8389E+02,7.3793E+02,
     &4.9200E+02,2.4597E+02,3.3326E-01,1.8454E+03,1.6147E+03,1.3840E+03,
     &1.1533E+03,9.2274E+02,6.9199E+02,4.6133E+02,2.3066E+02,5.2281E-01,
     &1.7316E+03,1.5151E+03,1.2986E+03,1.0821E+03,8.6576E+02,6.4926E+02,
     &4.3287E+02,2.1643E+02,8.0537E-01,1.6274E+03,1.4239E+03,1.2204E+03,
     &1.0169E+03,8.1360E+02,6.1025E+02,4.0681E+02,2.0342E+02,1.2167E+00,
     &1.5364E+03,1.3443E+03,1.1523E+03,9.6013E+02,7.6820E+02,5.7614E+02,
     &3.8407E+02,1.9205E+02,1.7524E+00/
      DATA ((KA(JS,JT, 9,15),JS=1,9),JT=1,5) /
     &9.3073E+03,8.1544E+03,6.9894E+03,5.8248E+03,4.6604E+03,3.4950E+03,
     &2.3299E+03,1.1651E+03,2.9954E-01,8.7551E+03,7.6608E+03,6.5662E+03,
     &5.4720E+03,4.3776E+03,3.2831E+03,2.1886E+03,1.0944E+03,4.5642E-01,
     &8.2482E+03,7.2167E+03,6.1860E+03,5.1552E+03,4.1239E+03,3.0929E+03,
     &2.0618E+03,1.0309E+03,6.9066E-01,7.8082E+03,6.8324E+03,5.8568E+03,
     &4.8805E+03,3.9039E+03,2.9280E+03,1.9520E+03,9.7612E+02,1.0400E+00,
     &7.4317E+03,6.5021E+03,5.5734E+03,4.6446E+03,3.7157E+03,2.7869E+03,
     &1.8578E+03,9.2892E+02,1.5452E+00/
      DATA ((KA(JS,JT,10,15),JS=1,9),JT=1,5) /
     &4.9432E+04,4.3258E+04,3.7074E+04,3.0897E+04,2.4721E+04,1.8537E+04,
     &1.2358E+04,6.1790E+03,1.8223E-01,4.6742E+04,4.0903E+04,3.5058E+04,
     &2.9212E+04,2.3371E+04,1.7528E+04,1.1686E+04,5.8428E+03,4.2300E-01,
     &4.4467E+04,3.8905E+04,3.3347E+04,2.7787E+04,2.2232E+04,1.6675E+04,
     &1.1116E+04,5.5580E+03,6.2837E-01,4.2571E+04,3.7248E+04,3.1929E+04,
     &2.6604E+04,2.1284E+04,1.5965E+04,1.0643E+04,5.3212E+03,9.2886E-01,
     &4.1045E+04,3.5912E+04,3.0783E+04,2.5652E+04,2.0522E+04,1.5392E+04,
     &1.0261E+04,5.1304E+03,1.3856E+00/
      DATA ((KA(JS,JT,11,15),JS=1,9),JT=1,5) /
     &9.0769E+04,7.9427E+04,6.8076E+04,5.6731E+04,4.5387E+04,3.4039E+04,
     &2.2692E+04,1.1348E+04,6.3351E-06,8.7118E+04,7.6228E+04,6.5339E+04,
     &5.4453E+04,4.3558E+04,3.2668E+04,2.1780E+04,1.0890E+04,1.2897E-01,
     &8.4111E+04,7.3597E+04,6.3086E+04,5.2568E+04,4.2058E+04,3.1544E+04,
     &2.1027E+04,1.0514E+04,3.6063E-01,8.1812E+04,7.1584E+04,6.1356E+04,
     &5.1132E+04,4.0904E+04,3.0678E+04,2.0453E+04,1.0225E+04,8.1674E-01,
     &7.9895E+04,6.9910E+04,5.9923E+04,4.9935E+04,3.9950E+04,2.9961E+04,
     &1.9975E+04,9.9870E+03,1.4894E+00/
      DATA ((KA(JS,JT,12,15),JS=1,9),JT=1,5) /
     &1.2814E+05,1.1213E+05,9.6104E+04,8.0085E+04,6.4069E+04,4.8051E+04,
     &3.2036E+04,1.6017E+04,4.6990E-06,1.2486E+05,1.0925E+05,9.3637E+04,
     &7.8034E+04,6.2430E+04,4.6820E+04,3.1210E+04,1.5606E+04,1.4051E-05,
     &1.2228E+05,1.0700E+05,9.1710E+04,7.6429E+04,6.1136E+04,4.5856E+04,
     &3.0569E+04,1.5285E+04,1.5080E-01,1.2022E+05,1.0520E+05,9.0163E+04,
     &7.5135E+04,6.0115E+04,4.5084E+04,3.0055E+04,1.5027E+04,4.4115E-01,
     &1.1876E+05,1.0392E+05,8.9071E+04,7.4229E+04,5.9383E+04,4.4534E+04,
     &2.9691E+04,1.4845E+04,1.2230E+00/
      DATA ((KA(JS,JT,13,15),JS=1,9),JT=1,5) /
     &1.4959E+05,1.3089E+05,1.1219E+05,9.3492E+04,7.4791E+04,5.6100E+04,
     &3.7396E+04,1.8698E+04,1.6068E-05,1.4739E+05,1.2897E+05,1.1053E+05,
     &9.2121E+04,7.3693E+04,5.5270E+04,3.6845E+04,1.8424E+04,2.4216E-05,
     &1.4569E+05,1.2748E+05,1.0927E+05,9.1057E+04,7.2849E+04,5.4630E+04,
     &3.6423E+04,1.8211E+04,2.3267E-01,1.4449E+05,1.2643E+05,1.0837E+05,
     &9.0297E+04,7.2240E+04,5.4184E+04,3.6121E+04,1.8059E+04,3.2297E-01,
     &1.4334E+05,1.2542E+05,1.0750E+05,8.9583E+04,7.1673E+04,5.3754E+04,
     &3.5834E+04,1.7916E+04,9.5703E-01/
      DATA ((KA(JS,JT, 1,16),JS=1,9),JT=1,5) /
     &1.1012E+01,9.6385E+00,8.2597E+00,6.8841E+00,5.5077E+00,4.1310E+00,
     &2.7545E+00,1.3780E+00,8.0170E-01,1.0449E+01,9.1438E+00,7.8382E+00,
     &6.5335E+00,5.2262E+00,3.9202E+00,2.6149E+00,1.3083E+00,1.1089E+00,
     &9.8963E+00,8.6604E+00,7.4233E+00,6.1853E+00,4.9489E+00,3.7122E+00,
     &2.4757E+00,1.2390E+00,1.4762E+00,9.3879E+00,8.2127E+00,7.0407E+00,
     &5.8670E+00,4.6947E+00,3.5210E+00,2.3483E+00,1.2086E+00,1.9022E+00,
     &8.8935E+00,7.7813E+00,6.6705E+00,5.5589E+00,4.4480E+00,3.3366E+00,
     &2.2250E+00,1.5141E+00,2.3892E+00/
      DATA ((KA(JS,JT, 2,16),JS=1,9),JT=1,5) /
     &1.7937E+01,1.5695E+01,1.3452E+01,1.1211E+01,8.9664E+00,6.7267E+00,
     &4.4861E+00,2.2435E+00,8.6848E-01,1.6997E+01,1.4871E+01,1.2749E+01,
     &1.0624E+01,8.4984E+00,6.3745E+00,4.2497E+00,2.1262E+00,1.2205E+00,
     &1.6073E+01,1.4067E+01,1.2054E+01,1.0046E+01,8.0383E+00,6.0294E+00,
     &4.0202E+00,2.0108E+00,1.6477E+00,1.5204E+01,1.3304E+01,1.1402E+01,
     &9.4999E+00,7.6031E+00,5.7017E+00,3.8022E+00,1.9021E+00,2.1539E+00,
     &1.4385E+01,1.2589E+01,1.0791E+01,8.9907E+00,7.1928E+00,5.3962E+00,
     &3.5994E+00,1.9006E+00,2.7317E+00/
      DATA ((KA(JS,JT, 3,16),JS=1,9),JT=1,5) /
     &3.9826E+01,3.4837E+01,2.9874E+01,2.4893E+01,1.9916E+01,1.4937E+01,
     &9.9605E+00,4.9801E+00,8.6605E-01,3.7687E+01,3.2981E+01,2.8272E+01,
     &2.3555E+01,1.8843E+01,1.4136E+01,9.4254E+00,4.7126E+00,1.2506E+00,
     &3.5608E+01,3.1162E+01,2.6711E+01,2.2256E+01,1.7812E+01,1.3358E+01,
     &8.9032E+00,4.4535E+00,1.7305E+00,3.3599E+01,2.9402E+01,2.5206E+01,
     &2.1000E+01,1.6804E+01,1.2601E+01,8.4019E+00,4.2020E+00,2.3040E+00,
     &3.1757E+01,2.7783E+01,2.3809E+01,1.9848E+01,1.5875E+01,1.1908E+01,
     &7.9407E+00,3.9713E+00,2.9736E+00/
      DATA ((KA(JS,JT, 4,16),JS=1,9),JT=1,5) /
     &9.1010E+01,7.9617E+01,6.8261E+01,5.6883E+01,4.5501E+01,3.4135E+01,
     &2.2756E+01,1.1381E+01,8.2098E-01,8.5710E+01,7.5003E+01,6.4275E+01,
     &5.3587E+01,4.2849E+01,3.2139E+01,2.1425E+01,1.0717E+01,1.2260E+00,
     &8.0903E+01,7.0806E+01,6.0673E+01,5.0561E+01,4.0455E+01,3.0343E+01,
     &2.0221E+01,1.0019E+01,1.7427E+00,7.6250E+01,6.6729E+01,5.7190E+01,
     &4.7658E+01,3.8119E+01,2.8596E+01,1.9064E+01,9.5357E+00,2.3756E+00,
     &7.1845E+01,6.2892E+01,5.3881E+01,4.4904E+01,3.5931E+01,2.6946E+01,
     &1.7968E+01,8.9829E+00,3.1270E+00/
      DATA ((KA(JS,JT, 5,16),JS=1,9),JT=1,5) /
     &1.9171E+02,1.6775E+02,1.4380E+02,1.1981E+02,9.5875E+01,7.1871E+01,
     &4.7928E+01,2.3964E+01,7.5940E-01,1.8016E+02,1.5760E+02,1.3509E+02,
     &1.1260E+02,9.0071E+01,6.7551E+01,4.5046E+01,2.2517E+01,1.1757E+00,
     &1.6962E+02,1.4839E+02,1.2718E+02,1.0601E+02,8.4813E+01,6.3608E+01,
     &4.2403E+01,2.1198E+01,1.7223E+00,1.5982E+02,1.3980E+02,1.1984E+02,
     &9.9881E+01,7.9889E+01,5.9924E+01,3.9950E+01,1.9975E+01,2.4076E+00,
     &1.5041E+02,1.3158E+02,1.1281E+02,9.3993E+01,7.5196E+01,5.6401E+01,
     &3.7598E+01,1.8805E+01,3.2368E+00/
      DATA ((KA(JS,JT, 6,16),JS=1,9),JT=1,5) /
     &3.8096E+02,3.3337E+02,2.8576E+02,2.3807E+02,1.9047E+02,1.4289E+02,
     &9.5250E+01,4.7621E+01,6.7593E-01,3.5801E+02,3.1325E+02,2.6851E+02,
     &2.2376E+02,1.7905E+02,1.3426E+02,8.9499E+01,4.4742E+01,1.0913E+00,
     &3.3608E+02,2.9405E+02,2.5208E+02,2.1010E+02,1.6803E+02,1.2602E+02,
     &8.4040E+01,4.2005E+01,1.6542E+00,3.1667E+02,2.7704E+02,2.3752E+02,
     &1.9794E+02,1.5835E+02,1.1877E+02,7.9157E+01,3.9584E+01,2.3801E+00,
     &2.9810E+02,2.6093E+02,2.2364E+02,1.8637E+02,1.4910E+02,1.1183E+02,
     &7.4550E+01,3.7278E+01,3.2789E+00/
      DATA ((KA(JS,JT, 7,16),JS=1,9),JT=1,5) /
     &7.9749E+02,6.9796E+02,5.9825E+02,4.9855E+02,3.9886E+02,2.9907E+02,
     &1.9939E+02,9.9689E+01,5.8719E-01,7.4948E+02,6.5592E+02,5.6211E+02,
     &4.6855E+02,3.7478E+02,2.8116E+02,1.8738E+02,9.3692E+01,9.9296E-01,
     &7.0403E+02,6.1598E+02,5.2804E+02,4.4008E+02,3.5206E+02,2.6406E+02,
     &1.7605E+02,8.8000E+01,1.5629E+00,6.6205E+02,5.7919E+02,4.9648E+02,
     &4.1378E+02,3.3107E+02,2.4827E+02,1.6552E+02,8.2766E+01,2.3202E+00,
     &6.2380E+02,5.4580E+02,4.6792E+02,3.8985E+02,3.1191E+02,2.3394E+02,
     &1.5598E+02,7.7978E+01,3.2803E+00/
      DATA ((KA(JS,JT, 8,16),JS=1,9),JT=1,5) /
     &2.0029E+03,1.7526E+03,1.5027E+03,1.2518E+03,1.0017E+03,7.5137E+02,
     &5.0076E+02,2.5041E+02,5.0039E-01,1.8839E+03,1.6487E+03,1.4132E+03,
     &1.1775E+03,9.4211E+02,7.0656E+02,4.7103E+02,2.3550E+02,8.8968E-01,
     &1.7724E+03,1.5508E+03,1.3295E+03,1.1080E+03,8.8638E+02,6.6461E+02,
     &4.4304E+02,2.2162E+02,1.4586E+00,1.6681E+03,1.4594E+03,1.2510E+03,
     &1.0422E+03,8.3394E+02,6.2548E+02,4.1698E+02,2.0850E+02,2.2386E+00,
     &1.5734E+03,1.3768E+03,1.1803E+03,9.8337E+02,7.8678E+02,5.9008E+02,
     &3.9340E+02,1.9668E+02,3.2542E+00/
      DATA ((KA(JS,JT, 9,16),JS=1,9),JT=1,5) /
     &9.5422E+03,8.3482E+03,7.1572E+03,5.9648E+03,4.7724E+03,3.5785E+03,
     &2.3856E+03,1.1929E+03,4.1531E-01,8.9979E+03,7.8727E+03,6.7481E+03,
     &5.6240E+03,4.4988E+03,3.3743E+03,2.2493E+03,1.1247E+03,7.8014E-01,
     &8.4879E+03,7.4273E+03,6.3662E+03,5.3047E+03,4.2442E+03,3.1830E+03,
     &2.1217E+03,1.0610E+03,1.3368E+00,8.0145E+03,7.0116E+03,6.0099E+03,
     &5.0094E+03,4.0072E+03,3.0052E+03,2.0036E+03,1.0018E+03,2.1276E+00,
     &7.6138E+03,6.6618E+03,5.7100E+03,4.7582E+03,3.8067E+03,2.8551E+03,
     &1.9031E+03,9.5177E+02,3.1866E+00/
      DATA ((KA(JS,JT,10,16),JS=1,9),JT=1,5) /
     &5.0991E+04,4.4616E+04,3.8235E+04,3.1865E+04,2.5493E+04,1.9119E+04,
     &1.2748E+04,6.3734E+03,3.5386E-01,4.8246E+04,4.2216E+04,3.6189E+04,
     &3.0155E+04,2.4122E+04,1.8092E+04,1.2062E+04,6.0316E+03,7.0256E-01,
     &4.5828E+04,4.0101E+04,3.4373E+04,2.8642E+04,2.2916E+04,1.7187E+04,
     &1.1458E+04,5.7294E+03,1.2547E+00,4.3978E+04,3.8481E+04,3.2983E+04,
     &2.7486E+04,2.1988E+04,1.6492E+04,1.0995E+04,5.4969E+03,2.0651E+00,
     &4.2519E+04,3.7205E+04,3.1889E+04,2.6577E+04,2.1264E+04,1.5948E+04,
     &1.0631E+04,5.3154E+03,3.1779E+00/
      DATA ((KA(JS,JT,11,16),JS=1,9),JT=1,5) /
     &9.4155E+04,8.2392E+04,7.0618E+04,5.8856E+04,4.7081E+04,3.5308E+04,
     &2.3542E+04,1.1770E+04,6.1346E-06,9.0590E+04,7.9258E+04,6.7935E+04,
     &5.6620E+04,4.5292E+04,3.3967E+04,2.2646E+04,1.1323E+04,3.3281E-01,
     &8.8119E+04,7.7104E+04,6.6094E+04,5.5078E+04,4.4061E+04,3.3053E+04,
     &2.2031E+04,1.1015E+04,1.5023E+00,8.6175E+04,7.5401E+04,6.4627E+04,
     &5.3860E+04,4.3092E+04,3.2317E+04,2.1545E+04,1.0771E+04,2.4696E+00,
     &8.4570E+04,7.4002E+04,6.3432E+04,5.2859E+04,4.2288E+04,3.1714E+04,
     &2.1142E+04,1.0572E+04,3.7979E+00/
      DATA ((KA(JS,JT,12,16),JS=1,9),JT=1,5) /
     &1.3547E+05,1.1853E+05,1.0160E+05,8.4660E+04,6.7729E+04,5.0794E+04,
     &3.3867E+04,1.6929E+04,5.0265E-06,1.3284E+05,1.1623E+05,9.9623E+04,
     &8.3023E+04,6.6416E+04,4.9810E+04,3.3206E+04,1.6603E+04,9.0705E-06,
     &1.3111E+05,1.1471E+05,9.8324E+04,8.1946E+04,6.5544E+04,4.9165E+04,
     &3.2777E+04,1.6388E+04,1.7901E+00,1.2947E+05,1.1329E+05,9.7103E+04,
     &8.0920E+04,6.4734E+04,4.8090E+04,3.2370E+04,1.6184E+04,2.9393E+00,
     &1.2773E+05,1.1176E+05,9.5799E+04,7.9830E+04,6.3866E+04,4.7901E+04,
     &3.1932E+04,1.5966E+04,4.5138E+00/
      DATA ((KA(JS,JT,13,16),JS=1,9),JT=1,5) /
     &1.6206E+05,1.4180E+05,1.2155E+05,1.0128E+05,8.1025E+04,6.0775E+04,
     &4.0514E+04,2.0257E+04,4.1164E-06,1.6103E+05,1.4091E+05,1.2078E+05,
     &1.0065E+05,8.0525E+04,6.0389E+04,4.0260E+04,2.0131E+04,7.4285E-06,
     &1.6003E+05,1.4003E+05,1.2001E+05,1.0001E+05,8.0009E+04,6.0009E+04,
     &4.0005E+04,2.0004E+04,8.7132E-01,1.5863E+05,1.3882E+05,1.1899E+05,
     &9.9157E+04,7.9319E+04,5.9492E+04,3.9661E+04,1.9830E+04,3.4650E+00,
     &1.5756E+05,1.3786E+05,1.1816E+05,9.8476E+04,7.8780E+04,5.9085E+04,
     &3.9388E+04,1.9695E+04,5.3123E+00/

C     The array KB contains absorption coefs for each of the 16 g-intervals
C     for a range of pressure levels  < ~100mb, temperatures, and ratios
C     of H2O to CO2.  The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.  The second index, JT, which
C     runs from 1 to 5, corresponds to different temperatures.  More 
C     specifically, JT = 3 means that the data are for the corresponding 
C     reference temperature TREF for this  pressure level, JT = 2 refers 
C     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
C     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
C     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
C     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
C     16, and tells us which g-interval the absorption coefficients are for.

      DATA ((KB(JS,JT,13, 1),JS=1,5),JT=1,5) /
     &1.9283E+01,1.4533E+01,9.7765E+00,4.9986E+00,1.2562E-02,
     &2.3187E+01,1.7461E+01,1.1734E+01,5.9860E+00,1.4622E-02,
     &2.7169E+01,2.0447E+01,1.3724E+01,6.9897E+00,1.6755E-02,
     &3.1114E+01,2.3405E+01,1.5695E+01,7.9803E+00,1.8932E-02,
     &3.5056E+01,2.6360E+01,1.7664E+01,8.9659E+00,2.1071E-02/
      DATA ((KB(JS,JT,14, 1),JS=1,5),JT=1,5) /
     &1.0180E+01,7.7052E+00,5.2175E+00,2.7059E+00,1.0725E-02,
     &1.2216E+01,9.2332E+00,6.2420E+00,3.2235E+00,1.2472E-02,
     &1.4258E+01,1.0764E+01,7.2673E+00,3.7434E+00,1.4271E-02,
     &1.6297E+01,1.2292E+01,8.2867E+00,4.2597E+00,1.6035E-02,
     &1.8337E+01,1.3822E+01,9.3061E+00,4.7742E+00,1.7777E-02/
      DATA ((KB(JS,JT,15, 1),JS=1,5),JT=1,5) /
     &5.4843E+00,4.1814E+00,2.8583E+00,1.5122E+00,9.1712E-03,
     &6.5509E+00,4.9839E+00,3.3981E+00,1.7878E+00,1.0654E-02,
     &7.6172E+00,5.7836E+00,3.9371E+00,2.0620E+00,1.2109E-02,
     &8.6919E+00,6.5886E+00,4.4776E+00,2.3372E+00,1.3585E-02,
     &9.7770E+00,7.4027E+00,5.0231E+00,2.6136E+00,1.5008E-02/
      DATA ((KB(JS,JT,16, 1),JS=1,5),JT=1,5) /
     &3.5143E+00,2.7004E+00,1.8632E+00,1.0005E+00,7.8549E-03,
     &4.1782E+00,3.2010E+00,2.2008E+00,1.1754E+00,9.0596E-03,
     &4.8461E+00,3.7036E+00,2.5395E+00,1.3499E+00,1.0291E-02,
     &5.5241E+00,4.2125E+00,2.8833E+00,1.5266E+00,1.1500E-02,
     &6.2095E+00,4.7270E+00,3.2297E+00,1.7035E+00,1.2669E-02/
      DATA ((KB(JS,JT,17, 1),JS=1,5),JT=1,5) /
     &2.3317E+00,1.8082E+00,1.2606E+00,6.8451E-01,6.6638E-03,
     &2.7625E+00,2.1339E+00,1.4816E+00,7.9994E-01,7.6839E-03,
     &3.1980E+00,2.4632E+00,1.7043E+00,9.1671E-01,8.7134E-03,
     &3.6437E+00,2.7995E+00,1.9319E+00,1.0349E+00,9.7011E-03,
     &4.0944E+00,3.1388E+00,2.1608E+00,1.1535E+00,1.0621E-02/
      DATA ((KB(JS,JT,18, 1),JS=1,5),JT=1,5) /
     &1.5862E+00,1.2436E+00,8.7489E-01,4.7986E-01,5.6356E-03,
     &1.8744E+00,1.4623E+00,1.0242E+00,5.5874E-01,6.4918E-03,
     &2.1671E+00,1.6845E+00,1.1763E+00,6.3905E-01,7.3340E-03,
     &2.4666E+00,1.9117E+00,1.3311E+00,7.2008E-01,8.1312E-03,
     &2.7713E+00,2.1418E+00,1.4869E+00,8.0122E-01,8.8525E-03/
      DATA ((KB(JS,JT,19, 1),JS=1,5),JT=1,5) /
     &1.0610E+00,8.4360E-01,5.9805E-01,3.3172E-01,4.7490E-03,
     &1.2512E+00,9.8882E-01,6.9811E-01,3.8521E-01,5.4538E-03,
     &1.4451E+00,1.1370E+00,8.0056E-01,4.3959E-01,6.1291E-03,
     &1.6437E+00,1.2883E+00,9.0437E-01,4.9444E-01,6.7635E-03,
     &1.8467E+00,1.4425E+00,1.0099E+00,5.4929E-01,7.3353E-03/
      DATA ((KB(JS,JT,20, 1),JS=1,5),JT=1,5) /
     &7.7133E-01,6.2032E-01,4.4197E-01,2.4707E-01,4.0032E-03,
     &9.0743E-01,7.2503E-01,5.1466E-01,2.8622E-01,4.5715E-03,
     &1.0470E+00,8.3267E-01,5.8918E-01,3.2603E-01,5.1125E-03,
     &1.1900E+00,9.4226E-01,6.6481E-01,3.6603E-01,5.6145E-03,
     &1.3362E+00,1.0539E+00,7.4130E-01,4.0582E-01,6.0699E-03/
      DATA ((KB(JS,JT,21, 1),JS=1,5),JT=1,5) /
     &5.7866E-01,4.6986E-01,3.3621E-01,1.8917E-01,3.3621E-03,
     &6.7950E-01,5.4811E-01,3.9072E-01,2.1877E-01,3.8183E-03,
     &7.8326E-01,6.2869E-01,4.4658E-01,2.4873E-01,4.2512E-03,
     &8.8933E-01,7.1063E-01,5.0334E-01,2.7872E-01,4.6532E-03,
     &9.9790E-01,7.9397E-01,5.6013E-01,3.0841E-01,5.0189E-03/
      DATA ((KB(JS,JT,22, 1),JS=1,5),JT=1,5) /
     &4.5035E-01,3.6838E-01,2.6449E-01,1.4961E-01,2.8371E-03,
     &5.2710E-01,4.2854E-01,3.0641E-01,1.7248E-01,3.2033E-03,
     &6.0621E-01,4.9027E-01,3.4931E-01,1.9546E-01,3.5507E-03,
     &6.8687E-01,5.5302E-01,3.9268E-01,2.1836E-01,3.8721E-03,
     &7.6986E-01,6.1676E-01,4.3619E-01,2.4105E-01,4.1644E-03/
      DATA ((KB(JS,JT,23, 1),JS=1,5),JT=1,5) /
     &3.5288E-01,2.9059E-01,2.0929E-01,1.1896E-01,2.3878E-03,
     &4.1165E-01,3.3703E-01,2.4169E-01,1.3668E-01,2.6830E-03,
     &4.7210E-01,3.8447E-01,2.7478E-01,1.5435E-01,2.9616E-03,
     &5.3412E-01,4.3294E-01,3.0818E-01,1.7203E-01,3.2196E-03,
     &5.9758E-01,4.8162E-01,3.4147E-01,1.8925E-01,3.4517E-03/
      DATA ((KB(JS,JT,24, 1),JS=1,5),JT=1,5) /
     &2.7554E-01,2.2847E-01,1.6509E-01,9.4305E-02,2.0058E-03,
     &3.2038E-01,2.6411E-01,1.9003E-01,1.0793E-01,2.2440E-03,
     &3.6644E-01,3.0049E-01,2.1543E-01,1.2148E-01,2.4688E-03,
     &4.1394E-01,3.3761E-01,2.4100E-01,1.3500E-01,2.6754E-03,
     &4.6205E-01,3.7459E-01,2.6626E-01,1.4798E-01,2.8597E-03/
      DATA ((KB(JS,JT,25, 1),JS=1,5),JT=1,5) /
     &2.1831E-01,1.8211E-01,1.3197E-01,7.5672E-02,1.6848E-03,
     &2.5300E-01,2.0977E-01,1.5139E-01,8.6229E-02,1.8770E-03,
     &2.8861E-01,2.3809E-01,1.7109E-01,9.6778E-02,2.0567E-03,
     &3.2559E-01,2.6686E-01,1.9096E-01,1.0719E-01,2.2230E-03,
     &3.6217E-01,2.9511E-01,2.1013E-01,1.1707E-01,2.3678E-03/
      DATA ((KB(JS,JT,26, 1),JS=1,5),JT=1,5) /
     &1.7639E-01,1.4786E-01,1.0735E-01,6.1680E-02,1.4167E-03,
     &2.0373E-01,1.6972E-01,1.2271E-01,7.0008E-02,1.5712E-03,
     &2.3189E-01,1.9218E-01,1.3830E-01,7.8351E-02,1.7155E-03,
     &2.6096E-01,2.1478E-01,1.5388E-01,8.6437E-02,1.8482E-03,
     &2.8921E-01,2.3658E-01,1.6864E-01,9.4016E-02,1.9628E-03/
      DATA ((KB(JS,JT,27, 1),JS=1,5),JT=1,5) /
     &1.4816E-01,1.2446E-01,9.0381E-02,5.1884E-02,1.1905E-03,
     &1.7052E-01,1.4243E-01,1.0297E-01,5.8708E-02,1.3153E-03,
     &1.9369E-01,1.6085E-01,1.1575E-01,6.5493E-02,1.4309E-03,
     &2.1729E-01,1.7923E-01,1.2834E-01,7.1951E-02,1.5370E-03,
     &2.3994E-01,1.9663E-01,1.4015E-01,7.7968E-02,1.6265E-03/
      DATA ((KB(JS,JT,28, 1),JS=1,5),JT=1,5) /
     &1.2786E-01,1.0743E-01,7.7947E-02,4.4624E-02,1.0001E-03,
     &1.4668E-01,1.2262E-01,8.8533E-02,5.0350E-02,1.1007E-03,
     &1.6624E-01,1.3809E-01,9.9259E-02,5.5949E-02,1.1936E-03,
     &1.8582E-01,1.5336E-01,1.0964E-01,6.1251E-02,1.2774E-03,
     &2.0447E-01,1.6760E-01,1.1929E-01,6.6127E-02,1.3481E-03/
      DATA ((KB(JS,JT,29, 1),JS=1,5),JT=1,5) /
     &1.1723E-01,9.8203E-02,7.1006E-02,4.0413E-02,8.4082E-04,
     &1.3410E-01,1.1181E-01,8.0444E-02,4.5462E-02,9.2201E-04,
     &1.5159E-01,1.2556E-01,8.9943E-02,5.0342E-02,9.9652E-04,
     &1.6878E-01,1.3892E-01,9.8991E-02,5.4945E-02,1.0624E-03,
     &1.8506E-01,1.5133E-01,1.0733E-01,5.9130E-02,1.1186E-03/
      DATA ((KB(JS,JT,30, 1),JS=1,5),JT=1,5) /
     &1.1017E-01,9.1915E-02,6.6158E-02,3.7385E-02,7.0716E-04,
     &1.2571E-01,1.0438E-01,7.4791E-02,4.1937E-02,7.7222E-04,
     &1.4165E-01,1.1688E-01,8.3361E-02,4.6295E-02,8.3205E-04,
     &1.5709E-01,1.2882E-01,9.1412E-02,5.0358E-02,8.8422E-04,
     &1.7161E-01,1.3989E-01,9.8798E-02,5.4060E-02,9.2829E-04/
      DATA ((KB(JS,JT,31, 1),JS=1,5),JT=1,5) /
     &1.0894E-01,9.0338E-02,6.4636E-02,3.6175E-02,5.9489E-04,
     &1.2399E-01,1.0230E-01,7.2900E-02,4.0465E-02,6.4753E-04,
     &1.3920E-01,1.1419E-01,8.0980E-02,4.4552E-02,6.9507E-04,
     &1.5373E-01,1.2537E-01,8.8479E-02,4.8317E-02,7.3661E-04,
     &1.6735E-01,1.3577E-01,9.5380E-02,5.1770E-02,7.7104E-04/
      DATA ((KB(JS,JT,32, 1),JS=1,5),JT=1,5) /
     &1.0900E-01,8.9827E-02,6.3903E-02,3.5410E-02,5.0043E-04,
     &1.2373E-01,1.0144E-01,7.1880E-02,3.9506E-02,5.4269E-04,
     &1.3829E-01,1.1278E-01,7.9528E-02,4.3367E-02,5.8080E-04,
     &1.5213E-01,1.2340E-01,8.6611E-02,4.6908E-02,6.1297E-04,
     &1.6513E-01,1.3334E-01,9.3188E-02,5.0191E-02,6.4067E-04/
      DATA ((KB(JS,JT,33, 1),JS=1,5),JT=1,5) /
     &1.1105E-01,9.0919E-02,6.4301E-02,3.5277E-02,4.2055E-04,
     &1.2562E-01,1.0235E-01,7.2096E-02,3.9245E-02,4.5474E-04,
     &1.3981E-01,1.1334E-01,7.9473E-02,4.2949E-02,4.8461E-04,
     &1.5326E-01,1.2363E-01,8.6303E-02,4.6360E-02,5.1014E-04,
     &1.6587E-01,1.3331E-01,9.2704E-02,4.9561E-02,5.3252E-04/
      DATA ((KB(JS,JT,34, 1),JS=1,5),JT=1,5) /
     &1.0980E-01,8.9454E-02,6.2967E-02,3.4264E-02,3.5179E-04,
     &1.2374E-01,1.0037E-01,7.0363E-02,3.8004E-02,3.7955E-04,
     &1.3725E-01,1.1080E-01,7.7340E-02,4.1494E-02,4.0292E-04,
     &1.5005E-01,1.2058E-01,8.3803E-02,4.4722E-02,4.2388E-04,
     &1.6190E-01,1.2971E-01,8.9844E-02,4.7765E-02,4.4175E-04/
      DATA ((KB(JS,JT,35, 1),JS=1,5),JT=1,5) /
     &1.0733E-01,8.7091E-02,6.1056E-02,3.2994E-02,2.9230E-04,
     &1.2074E-01,9.7561E-02,6.8117E-02,3.6550E-02,3.1434E-04,
     &1.3369E-01,1.0755E-01,7.4768E-02,3.9873E-02,3.3363E-04,
     &1.4588E-01,1.1689E-01,8.0950E-02,4.2958E-02,3.5062E-04,
     &1.5707E-01,1.2552E-01,8.6668E-02,4.5847E-02,3.6479E-04/
      DATA ((KB(JS,JT,36, 1),JS=1,5),JT=1,5) /
     &1.0289E-01,8.3241E-02,5.8159E-02,3.1253E-02,2.4069E-04,
     &1.1571E-01,9.3253E-02,6.4895E-02,3.4641E-02,2.5868E-04,
     &1.2815E-01,1.0284E-01,7.1277E-02,3.7824E-02,2.7449E-04,
     &1.3974E-01,1.1174E-01,7.7168E-02,4.0766E-02,2.8849E-04,
     &1.5033E-01,1.1990E-01,8.2576E-02,4.3496E-02,2.9983E-04/
      DATA ((KB(JS,JT,37, 1),JS=1,5),JT=1,5) /
     &9.4340E-02,7.6226E-02,5.3140E-02,2.8456E-02,1.9559E-04,
     &1.0634E-01,8.5612E-02,5.9452E-02,3.1630E-02,2.1059E-04,
     &1.1803E-01,9.4641E-02,6.5469E-02,3.4631E-02,2.2381E-04,
     &1.2893E-01,1.0302E-01,7.1019E-02,3.7400E-02,2.3549E-04,
     &1.3882E-01,1.1066E-01,7.6074E-02,3.9944E-02,2.4505E-04/
      DATA ((KB(JS,JT,38, 1),JS=1,5),JT=1,5) /
     &8.7666E-02,7.0724E-02,4.9189E-02,2.6244E-02,1.5881E-04,
     &9.9075E-02,7.9666E-02,5.5208E-02,2.9270E-02,1.7135E-04,
     &1.1022E-01,8.8294E-02,6.0961E-02,3.2140E-02,1.8248E-04,
     &1.2063E-01,9.6310E-02,6.6270E-02,3.4786E-02,1.9228E-04,
     &1.3002E-01,1.0355E-01,7.1058E-02,3.7188E-02,2.0028E-04/
      DATA ((KB(JS,JT,39, 1),JS=1,5),JT=1,5) /
     &8.3319E-02,6.7083E-02,4.6540E-02,2.4732E-02,1.2903E-04,
     &9.4409E-02,7.5788E-02,5.2401E-02,2.7679E-02,1.3958E-04,
     &1.0530E-01,8.4225E-02,5.8027E-02,3.0486E-02,1.4894E-04,
     &1.1544E-01,9.2061E-02,6.3226E-02,3.3071E-02,1.5713E-04,
     &1.2457E-01,9.9102E-02,6.7879E-02,3.5400E-02,1.6372E-04/
      DATA ((KB(JS,JT,40, 1),JS=1,5),JT=1,5) /
     &7.3382E-02,5.9091E-02,4.0949E-02,2.1720E-02,1.0369E-04,
     &8.3492E-02,6.7054E-02,4.6317E-02,2.4422E-02,1.1258E-04,
     &9.3502E-02,7.4845E-02,5.1514E-02,2.7021E-02,1.2049E-04,
     &1.0289E-01,8.2115E-02,5.6339E-02,2.9419E-02,1.2744E-04,
     &1.1132E-01,8.8604E-02,6.0629E-02,3.1559E-02,1.3317E-04/
      DATA ((KB(JS,JT,41, 1),JS=1,5),JT=1,5) /
     &6.4289E-02,5.1783E-02,3.5851E-02,1.8983E-02,8.3205E-05,
     &7.3486E-02,5.9047E-02,4.0756E-02,2.1456E-02,9.0601E-05,
     &8.2657E-02,6.6211E-02,4.5539E-02,2.3850E-02,9.7309E-05,
     &9.1325E-02,7.2956E-02,5.0013E-02,2.6075E-02,1.0320E-04,
     &9.9149E-02,7.8969E-02,5.3991E-02,2.8057E-02,1.0825E-04/
      DATA ((KB(JS,JT,42, 1),JS=1,5),JT=1,5) /
     &5.6899E-02,4.5812E-02,3.1686E-02,1.6747E-02,6.6719E-05,
     &6.5316E-02,5.2494E-02,3.6198E-02,1.9026E-02,7.2862E-05,
     &7.3779E-02,5.9136E-02,4.0639E-02,2.1249E-02,7.8557E-05,
     &8.1877E-02,6.5448E-02,4.4826E-02,2.3334E-02,8.3575E-05,
     &8.9207E-02,7.1094E-02,4.8562E-02,2.5195E-02,8.7912E-05/
      DATA ((KB(JS,JT,43, 1),JS=1,5),JT=1,5) /
     &5.0334E-02,4.0495E-02,2.7979E-02,1.4764E-02,5.3104E-05,
     &5.8063E-02,4.6679E-02,3.2159E-02,1.6880E-02,5.8298E-05,
     &6.5961E-02,5.2905E-02,3.6327E-02,1.8968E-02,6.3123E-05,
     &7.3585E-02,5.8862E-02,4.0291E-02,2.0945E-02,6.7425E-05,
     &8.0560E-02,6.4257E-02,4.3859E-02,2.2720E-02,7.1177E-05/
      DATA ((KB(JS,JT,44, 1),JS=1,5),JT=1,5) /
     &4.4899E-02,3.6074E-02,2.4891E-02,1.3115E-02,4.2029E-05,
     &5.2065E-02,4.1850E-02,2.8809E-02,1.5097E-02,4.6479E-05,
     &5.9485E-02,4.7740E-02,3.2758E-02,1.7077E-02,5.0599E-05,
     &6.6781E-02,5.3454E-02,3.6566E-02,1.8982E-02,5.4263E-05,
     &7.3522E-02,5.8690E-02,4.0031E-02,2.0702E-02,5.7530E-05/
      DATA ((KB(JS,JT,45, 1),JS=1,5),JT=1,5) /
     &4.0792E-02,3.2725E-02,2.2543E-02,1.1850E-02,3.3244E-05,
     &4.7552E-02,3.8195E-02,2.6267E-02,1.3739E-02,3.7011E-05,
     &5.4656E-02,4.3858E-02,3.0076E-02,1.5653E-02,4.0475E-05,
     &6.1725E-02,4.9413E-02,3.3782E-02,1.7505E-02,4.3662E-05,
     &6.8362E-02,5.4599E-02,3.7216E-02,1.9215E-02,4.6426E-05/
      DATA ((KB(JS,JT,46, 1),JS=1,5),JT=1,5) /
     &3.7210E-02,2.9813E-02,2.0505E-02,1.0753E-02,2.6192E-05,
     &4.3666E-02,3.5023E-02,2.4062E-02,1.2564E-02,2.9338E-05,
     &5.0484E-02,4.0487E-02,2.7746E-02,1.4418E-02,3.2269E-05,
     &5.7389E-02,4.5948E-02,3.1393E-02,1.6243E-02,3.5047E-05,
     &6.3983E-02,5.1116E-02,3.4828E-02,1.7955E-02,3.7412E-05/
      DATA ((KB(JS,JT,47, 1),JS=1,5),JT=1,5) /
     &3.3307E-02,2.6647E-02,1.8307E-02,9.5851E-03,2.0446E-05,
     &3.9395E-02,3.1552E-02,2.1654E-02,1.1293E-02,2.3124E-05,
     &4.5832E-02,3.6752E-02,2.5172E-02,1.3065E-02,2.5601E-05,
     &5.2491E-02,4.2052E-02,2.8722E-02,1.4843E-02,2.7940E-05,
     &5.8958E-02,4.7137E-02,3.2108E-02,1.6536E-02,3.0007E-05/
      DATA ((KB(JS,JT,48, 1),JS=1,5),JT=1,5) /
     &3.0577E-02,2.4411E-02,1.6745E-02,8.7495E-03,1.5922E-05,
     &3.6464E-02,2.9147E-02,1.9975E-02,1.0397E-02,1.8148E-05,
     &4.2691E-02,3.4197E-02,2.3406E-02,1.2132E-02,2.0290E-05,
     &4.9243E-02,3.9438E-02,2.6932E-02,1.3903E-02,2.2244E-05,
     &5.5751E-02,4.4571E-02,3.0355E-02,1.5610E-02,2.4044E-05/
      DATA ((KB(JS,JT,49, 1),JS=1,5),JT=1,5) /
     &2.9139E-02,2.3202E-02,1.5887E-02,8.2788E-03,1.2379E-05,
     &3.5049E-02,2.7954E-02,1.9124E-02,9.9302E-03,1.4214E-05,
     &4.1342E-02,3.3034E-02,2.2588E-02,1.1686E-02,1.6044E-05,
     &4.8011E-02,3.8402E-02,2.6208E-02,1.3508E-02,1.7733E-05,
     &5.4790E-02,4.3771E-02,2.9799E-02,1.5302E-02,1.9282E-05/
      DATA ((KB(JS,JT,50, 1),JS=1,5),JT=1,5) /
     &2.6464E-02,2.1057E-02,1.4400E-02,7.4918E-03,9.6160E-06,
     &3.2138E-02,2.5589E-02,1.7489E-02,9.0674E-03,1.1117E-05,
     &3.8201E-02,3.0472E-02,2.0816E-02,1.0758E-02,1.2650E-05,
     &4.4627E-02,3.5684E-02,2.4344E-02,1.2533E-02,1.4094E-05,
     &5.1304E-02,4.1009E-02,2.7917E-02,1.4322E-02,1.5452E-05/
      DATA ((KB(JS,JT,51, 1),JS=1,5),JT=1,5) /
     &2.3471E-02,1.8670E-02,1.2760E-02,6.6303E-03,7.4600E-06,
     &2.8809E-02,2.2911E-02,1.5642E-02,8.0988E-03,8.6870E-06,
     &3.4515E-02,2.7502E-02,1.8771E-02,9.6885E-03,9.9502E-06,
     &4.0564E-02,3.2426E-02,2.2116E-02,1.1378E-02,1.1172E-05,
     &4.6952E-02,3.7546E-02,2.5560E-02,1.3107E-02,1.2317E-05/
      DATA ((KB(JS,JT,52, 1),JS=1,5),JT=1,5) /
     &2.1330E-02,1.6945E-02,1.1569E-02,6.0043E-03,5.7740E-06,
     &2.6486E-02,2.1033E-02,1.4344E-02,7.4158E-03,6.7739E-06,
     &3.1984E-02,2.5459E-02,1.7358E-02,8.9483E-03,7.8163E-06,
     &3.7859E-02,3.0220E-02,2.0602E-02,1.0589E-02,8.8379E-06,
     &4.4095E-02,3.5255E-02,2.3994E-02,1.2295E-02,9.8102E-06/
      DATA ((KB(JS,JT,53, 1),JS=1,5),JT=1,5) /
     &2.0104E-02,1.5937E-02,1.0867E-02,5.6295E-03,4.4532E-06,
     &2.5267E-02,2.0039E-02,1.3647E-02,7.0429E-03,5.2727E-06,
     &3.0800E-02,2.4464E-02,1.6661E-02,8.5763E-03,6.1352E-06,
     &3.6739E-02,2.9255E-02,1.9925E-02,1.0232E-02,6.9843E-06,
     &4.3045E-02,3.4379E-02,2.3392E-02,1.1975E-02,7.8095E-06/
      DATA ((KB(JS,JT,54, 1),JS=1,5),JT=1,5) /
     &1.6441E-02,1.3030E-02,8.8847E-03,4.6022E-03,3.4230E-06,
     &2.0888E-02,1.6582E-02,1.1293E-02,5.8278E-03,4.0956E-06,
     &2.5721E-02,2.0433E-02,1.3910E-02,7.1575E-03,4.7876E-06,
     &3.0904E-02,2.4618E-02,1.6759E-02,8.6032E-03,5.4982E-06,
     &3.6412E-02,2.9120E-02,1.9814E-02,1.0143E-02,6.1750E-06/
      DATA ((KB(JS,JT,55, 1),JS=1,5),JT=1,5) /
     &1.2258E-02,9.7268E-03,6.6366E-03,3.4428E-03,2.6213E-06,
     &1.5748E-02,1.2527E-02,8.5365E-03,4.4115E-03,3.1717E-06,
     &1.9594E-02,1.5595E-02,1.0619E-02,5.4666E-03,3.7237E-06,
     &2.3710E-02,1.8931E-02,1.2889E-02,6.6186E-03,4.3031E-06,
     &2.8112E-02,2.2537E-02,1.5336E-02,7.8537E-03,4.8648E-06/
      DATA ((KB(JS,JT,56, 1),JS=1,5),JT=1,5) /
     &9.1055E-03,7.2363E-03,4.9401E-03,2.5664E-03,1.9997E-06,
     &1.1834E-02,9.4303E-03,6.4310E-03,3.3278E-03,2.4479E-06,
     &1.4882E-02,1.1870E-02,8.0848E-03,4.1651E-03,2.8963E-06,
     &1.8155E-02,1.4526E-02,9.8917E-03,5.0809E-03,3.3616E-06,
     &2.1671E-02,1.7405E-02,1.1845E-02,6.0691E-03,3.8293E-06/
      DATA ((KB(JS,JT,57, 1),JS=1,5),JT=1,5) /
     &6.7286E-03,5.3591E-03,3.6618E-03,1.9048E-03,1.5179E-06,
     &8.8620E-03,7.0733E-03,4.8264E-03,2.5013E-03,1.8807E-06,
     &1.1265E-02,9.0088E-03,6.1382E-03,3.1650E-03,2.2483E-06,
     &1.3873E-02,1.1116E-02,7.5709E-03,3.8911E-03,2.6184E-06,
     &1.6676E-02,1.3415E-02,9.1296E-03,4.6803E-03,3.0020E-06/
      DATA ((KB(JS,JT,58, 1),JS=1,5),JT=1,5) /
     &1.3112E-03,1.2811E-03,1.1274E-03,8.2340E-04,1.1519E-06,
     &1.7518E-03,1.7126E-03,1.5045E-03,1.0941E-03,1.4467E-06,
     &2.2498E-03,2.2053E-03,1.9345E-03,1.3994E-03,1.7445E-06,
     &2.7980E-03,2.7467E-03,2.4064E-03,1.7337E-03,2.0427E-06,
     &3.3868E-03,3.3394E-03,2.9224E-03,2.0998E-03,2.3542E-06/
      DATA ((KB(JS,JT,59, 1),JS=1,5),JT=1,5) /
     &1.2094E-03,1.1351E-03,9.3340E-04,6.0964E-04,9.0654E-07,
     &1.6257E-03,1.5254E-03,1.2509E-03,8.1260E-04,1.1440E-06,
     &2.0981E-03,1.9741E-03,1.6151E-03,1.0426E-03,1.3852E-06,
     &2.6203E-03,2.4691E-03,2.0150E-03,1.2943E-03,1.6270E-06,
     &3.1814E-03,3.0122E-03,2.4540E-03,1.5709E-03,1.8687E-06/
      DATA ((KB(JS,JT,13, 2),JS=1,5),JT=1,5) /
     &6.6529E+01,4.9985E+01,3.3446E+01,1.6923E+01,3.5914E-02,
     &7.4095E+01,5.5661E+01,3.7226E+01,1.8804E+01,3.9958E-02,
     &8.0840E+01,6.0720E+01,4.0598E+01,2.0484E+01,4.3881E-02,
     &8.6396E+01,6.4888E+01,4.3378E+01,2.1867E+01,4.7563E-02,
     &9.0642E+01,6.8073E+01,4.5503E+01,2.2931E+01,5.1188E-02/
      DATA ((KB(JS,JT,14, 2),JS=1,5),JT=1,5) /
     &3.4987E+01,2.6327E+01,1.7678E+01,9.0444E+00,3.1025E-02,
     &3.8934E+01,2.9288E+01,1.9648E+01,1.0023E+01,3.4459E-02,
     &4.2399E+01,3.1888E+01,2.1376E+01,1.0881E+01,3.7786E-02,
     &4.5141E+01,3.3946E+01,2.2749E+01,1.1559E+01,4.1037E-02,
     &4.7193E+01,3.5485E+01,2.3775E+01,1.2071E+01,4.3970E-02/
      DATA ((KB(JS,JT,15, 2),JS=1,5),JT=1,5) /
     &1.8797E+01,1.4186E+01,9.5905E+00,4.9916E+00,2.6741E-02,
     &2.0897E+01,1.5761E+01,1.0636E+01,5.5075E+00,2.9658E-02,
     &2.2675E+01,1.7093E+01,1.1518E+01,5.9424E+00,3.2475E-02,
     &2.4040E+01,1.8121E+01,1.2200E+01,6.2773E+00,3.5159E-02,
     &2.5038E+01,1.8870E+01,1.2700E+01,6.5270E+00,3.7635E-02/
      DATA ((KB(JS,JT,16, 2),JS=1,5),JT=1,5) /
     &1.2062E+01,9.1374E+00,6.2260E+00,3.2778E+00,2.3010E-02,
     &1.3368E+01,1.0114E+01,6.8731E+00,3.5955E+00,2.5515E-02,
     &1.4432E+01,1.0911E+01,7.4005E+00,3.8523E+00,2.7873E-02,
     &1.5210E+01,1.1498E+01,7.7878E+00,4.0427E+00,3.0096E-02,
     &1.5795E+01,1.1938E+01,8.0810E+00,4.1897E+00,3.2123E-02/
      DATA ((KB(JS,JT,17, 2),JS=1,5),JT=1,5) /
     &8.0343E+00,6.1202E+00,4.2057E+00,2.2416E+00,1.9722E-02,
     &8.8550E+00,6.7335E+00,4.6112E+00,2.4399E+00,2.1833E-02,
     &9.5028E+00,7.2176E+00,4.9290E+00,2.5918E+00,2.3771E-02,
     &9.9681E+00,7.5665E+00,5.1592E+00,2.7054E+00,2.5587E-02,
     &1.0341E+01,7.8464E+00,5.3464E+00,2.7998E+00,2.7262E-02/
      DATA ((KB(JS,JT,18, 2),JS=1,5),JT=1,5) /
     &5.4784E+00,4.2063E+00,2.9118E+00,1.5707E+00,1.6843E-02,
     &6.0003E+00,4.5949E+00,3.1671E+00,1.6950E+00,1.8568E-02,
     &6.4044E+00,4.8955E+00,3.3617E+00,1.7866E+00,2.0170E-02,
     &6.7000E+00,5.1163E+00,3.5087E+00,1.8600E+00,2.1658E-02,
     &6.9467E+00,5.3017E+00,3.6339E+00,1.9245E+00,2.2992E-02/
      DATA ((KB(JS,JT,19, 2),JS=1,5),JT=1,5) /
     &3.6607E+00,2.8397E+00,1.9832E+00,1.0810E+00,1.4294E-02,
     &3.9888E+00,3.0825E+00,2.1422E+00,1.1564E+00,1.5700E-02,
     &4.2403E+00,3.2678E+00,2.2604E+00,1.2129E+00,1.7026E-02,
     &4.4304E+00,3.4105E+00,2.3562E+00,1.2611E+00,1.8223E-02,
     &4.5892E+00,3.5305E+00,2.4376E+00,1.3052E+00,1.9250E-02/
      DATA ((KB(JS,JT,20, 2),JS=1,5),JT=1,5) /
     &2.6484E+00,2.0725E+00,1.4576E+00,7.9887E-01,1.2095E-02,
     &2.8723E+00,2.2377E+00,1.5638E+00,8.4850E-01,1.3258E-02,
     &3.0432E+00,2.3620E+00,1.6433E+00,8.8749E-01,1.4323E-02,
     &3.1766E+00,2.4628E+00,1.7113E+00,9.2233E-01,1.5251E-02,
     &3.2896E+00,2.5490E+00,1.7710E+00,9.5551E-01,1.6040E-02/
      DATA ((KB(JS,JT,21, 2),JS=1,5),JT=1,5) /
     &1.9737E+00,1.5589E+00,1.1005E+00,6.0564E-01,1.0202E-02,
     &2.1324E+00,1.6743E+00,1.1736E+00,6.4004E-01,1.1146E-02,
     &2.2543E+00,1.7630E+00,1.2313E+00,6.6865E-01,1.1981E-02,
     &2.3508E+00,1.8360E+00,1.2809E+00,6.9497E-01,1.2686E-02,
     &2.4312E+00,1.8986E+00,1.3258E+00,7.2010E-01,1.3291E-02/
      DATA ((KB(JS,JT,22, 2),JS=1,5),JT=1,5) /
     &1.5156E+00,1.2064E+00,8.5276E-01,4.7037E-01,8.6256E-03,
     &1.6299E+00,1.2880E+00,9.0439E-01,4.9507E-01,9.3659E-03,
     &1.7167E+00,1.3521E+00,9.4701E-01,5.1663E-01,1.0004E-02,
     &1.7876E+00,1.4059E+00,9.8421E-01,5.3690E-01,1.0541E-02,
     &1.8482E+00,1.4540E+00,1.0190E+00,5.5667E-01,1.1012E-02/
      DATA ((KB(JS,JT,23, 2),JS=1,5),JT=1,5) /
     &1.1701E+00,9.3735E-01,6.6344E-01,3.6672E-01,7.2585E-03,
     &1.2526E+00,9.9560E-01,7.0066E-01,3.8497E-01,7.8298E-03,
     &1.3157E+00,1.0429E+00,7.3247E-01,4.0155E-01,8.3206E-03,
     &1.3685E+00,1.0835E+00,7.6114E-01,4.1717E-01,8.7383E-03,
     &1.4146E+00,1.1207E+00,7.8818E-01,4.3301E-01,9.1036E-03/
      DATA ((KB(JS,JT,24, 2),JS=1,5),JT=1,5) /
     &8.9949E-01,7.2462E-01,5.1357E-01,2.8470E-01,6.0789E-03,
     &9.5867E-01,7.6639E-01,5.4063E-01,2.9829E-01,6.5218E-03,
     &1.0042E+00,8.0114E-01,5.6436E-01,3.1100E-01,6.9029E-03,
     &1.0431E+00,8.3179E-01,5.8619E-01,3.2299E-01,7.2295E-03,
     &1.0790E+00,8.6138E-01,6.0791E-01,3.3588E-01,7.5120E-03/
      DATA ((KB(JS,JT,25, 2),JS=1,5),JT=1,5) /
     &7.0112E-01,5.6715E-01,4.0233E-01,2.2369E-01,5.0763E-03,
     &7.4350E-01,5.9764E-01,4.2250E-01,2.3404E-01,5.4222E-03,
     &7.7710E-01,6.2349E-01,4.4048E-01,2.4369E-01,5.7195E-03,
     &8.0619E-01,6.4737E-01,4.5753E-01,2.5334E-01,5.9744E-03,
     &8.3531E-01,6.7147E-01,4.7545E-01,2.6391E-01,6.1951E-03/
      DATA ((KB(JS,JT,26, 2),JS=1,5),JT=1,5) /
     &5.5605E-01,4.5118E-01,3.2039E-01,1.7855E-01,4.2346E-03,
     &5.8683E-01,4.7392E-01,3.3566E-01,1.8647E-01,4.5042E-03,
     &6.1229E-01,4.9380E-01,3.4972E-01,1.9404E-01,4.7382E-03,
     &6.3488E-01,5.1281E-01,3.6343E-01,2.0206E-01,4.9373E-03,
     &6.5886E-01,5.3298E-01,3.7847E-01,2.1092E-01,5.1112E-03/
      DATA ((KB(JS,JT,27, 2),JS=1,5),JT=1,5) /
     &4.5766E-01,3.7194E-01,2.6418E-01,1.4728E-01,3.5266E-03,
     &4.8116E-01,3.8971E-01,2.7627E-01,1.5359E-01,3.7388E-03,
     &5.0141E-01,4.0592E-01,2.8779E-01,1.5989E-01,3.9220E-03,
     &5.1998E-01,4.2171E-01,2.9940E-01,1.6680E-01,4.0803E-03,
     &5.4049E-01,4.3926E-01,3.1241E-01,1.7445E-01,4.2171E-03/
      DATA ((KB(JS,JT,28, 2),JS=1,5),JT=1,5) /
     &3.8656E-01,3.1440E-01,2.2322E-01,1.2431E-01,2.9341E-03,
     &4.0539E-01,3.2888E-01,2.3321E-01,1.2952E-01,3.1008E-03,
     &4.2208E-01,3.4256E-01,2.4291E-01,1.3505E-01,3.2456E-03,
     &4.3788E-01,3.5618E-01,2.5311E-01,1.4108E-01,3.3707E-03,
     &4.5599E-01,3.7197E-01,2.6475E-01,1.4784E-01,3.4778E-03/
      DATA ((KB(JS,JT,29, 2),JS=1,5),JT=1,5) /
     &3.4663E-01,2.8147E-01,1.9935E-01,1.1053E-01,2.4407E-03,
     &3.6288E-01,2.9416E-01,2.0825E-01,1.1525E-01,2.5726E-03,
     &3.7738E-01,3.0636E-01,2.1696E-01,1.2034E-01,2.6876E-03,
     &3.9208E-01,3.1911E-01,2.2648E-01,1.2589E-01,2.7881E-03,
     &4.0886E-01,3.3389E-01,2.3740E-01,1.3220E-01,2.8698E-03/
      DATA ((KB(JS,JT,30, 2),JS=1,5),JT=1,5) /
     &3.1859E-01,2.5807E-01,1.8226E-01,1.0052E-01,2.0286E-03,
     &3.3300E-01,2.6960E-01,1.9038E-01,1.0493E-01,2.1345E-03,
     &3.4608E-01,2.8079E-01,1.9849E-01,1.0968E-01,2.2264E-03,
     &3.6002E-01,2.9303E-01,2.0760E-01,1.1495E-01,2.3052E-03,
     &3.7616E-01,3.0718E-01,2.1802E-01,1.2086E-01,2.3703E-03/
      DATA ((KB(JS,JT,31, 2),JS=1,5),JT=1,5) /
     &3.0804E-01,2.4854E-01,1.7488E-01,9.5771E-02,1.6879E-03,
     &3.2148E-01,2.5954E-01,1.8261E-01,1.0007E-01,1.7724E-03,
     &3.3418E-01,2.7047E-01,1.9064E-01,1.0472E-01,1.8461E-03,
     &3.4816E-01,2.8282E-01,1.9976E-01,1.0990E-01,1.9082E-03,
     &3.6451E-01,2.9706E-01,2.1019E-01,1.1572E-01,1.9578E-03/
      DATA ((KB(JS,JT,32, 2),JS=1,5),JT=1,5) /
     &3.0134E-01,2.4222E-01,1.6982E-01,9.2391E-02,1.4045E-03,
     &3.1413E-01,2.5288E-01,1.7732E-01,9.6600E-02,1.4719E-03,
     &3.2677E-01,2.6386E-01,1.8545E-01,1.0123E-01,1.5309E-03,
     &3.4104E-01,2.7646E-01,1.9466E-01,1.0637E-01,1.5796E-03,
     &3.5782E-01,2.9105E-01,2.0529E-01,1.1222E-01,1.6199E-03/
      DATA ((KB(JS,JT,33, 2),JS=1,5),JT=1,5) /
     &3.0007E-01,2.4036E-01,1.6789E-01,9.0749E-02,1.1692E-03,
     &3.1257E-01,2.5093E-01,1.7540E-01,9.4970E-02,1.2231E-03,
     &3.2551E-01,2.6224E-01,1.8373E-01,9.9635E-02,1.2703E-03,
     &3.4043E-01,2.7535E-01,1.9325E-01,1.0486E-01,1.3103E-03,
     &3.5814E-01,2.9066E-01,2.0432E-01,1.1086E-01,1.3413E-03/
      DATA ((KB(JS,JT,34, 2),JS=1,5),JT=1,5) /
     &2.9092E-01,2.3257E-01,1.6200E-01,8.7114E-02,9.7104E-04,
     &3.0301E-01,2.4286E-01,1.6939E-01,9.1256E-02,1.0146E-03,
     &3.1600E-01,2.5431E-01,1.7773E-01,9.5863E-02,1.0532E-03,
     &3.3116E-01,2.6756E-01,1.8732E-01,1.0106E-01,1.0840E-03,
     &3.4944E-01,2.8336E-01,1.9862E-01,1.0710E-01,1.1076E-03/
      DATA ((KB(JS,JT,35, 2),JS=1,5),JT=1,5) /
     &2.8133E-01,2.2448E-01,1.5598E-01,8.3470E-02,8.0326E-04,
     &2.9315E-01,2.3461E-01,1.6327E-01,8.7518E-02,8.3948E-04,
     &3.0606E-01,2.4602E-01,1.7152E-01,9.2018E-02,8.6953E-04,
     &3.2135E-01,2.5937E-01,1.8112E-01,9.7174E-02,8.9330E-04,
     &3.3996E-01,2.7548E-01,1.9256E-01,1.0324E-01,9.1326E-04/
      DATA ((KB(JS,JT,36, 2),JS=1,5),JT=1,5) /
     &2.6927E-01,2.1450E-01,1.4871E-01,7.9228E-02,6.6044E-04,
     &2.8072E-01,2.2434E-01,1.5577E-01,8.3114E-02,6.9019E-04,
     &2.9329E-01,2.3546E-01,1.6379E-01,8.7445E-02,7.1471E-04,
     &3.0843E-01,2.4872E-01,1.7326E-01,9.2498E-02,7.3506E-04,
     &3.2685E-01,2.6470E-01,1.8459E-01,9.8476E-02,7.5121E-04/
      DATA ((KB(JS,JT,37, 2),JS=1,5),JT=1,5) /
     &2.4965E-01,1.9865E-01,1.3749E-01,7.2983E-02,5.3914E-04,
     &2.6042E-01,2.0789E-01,1.4407E-01,7.6575E-02,5.6372E-04,
     &2.7217E-01,2.1833E-01,1.5157E-01,8.0593E-02,5.8448E-04,
     &2.8633E-01,2.3076E-01,1.6043E-01,8.5310E-02,6.0216E-04,
     &3.0356E-01,2.4582E-01,1.7110E-01,9.0929E-02,6.1615E-04/
      DATA ((KB(JS,JT,38, 2),JS=1,5),JT=1,5) /
     &2.3485E-01,1.8661E-01,1.2891E-01,6.8178E-02,4.3970E-04,
     &2.4515E-01,1.9543E-01,1.3515E-01,7.1546E-02,4.6052E-04,
     &2.5629E-01,2.0533E-01,1.4225E-01,7.5330E-02,4.7811E-04,
     &2.6971E-01,2.1715E-01,1.5065E-01,7.9788E-02,4.9330E-04,
     &2.8605E-01,2.3151E-01,1.6083E-01,8.5133E-02,5.0547E-04/
      DATA ((KB(JS,JT,39, 2),JS=1,5),JT=1,5) /
     &2.2602E-01,1.7927E-01,1.2358E-01,6.5103E-02,3.5893E-04,
     &2.3611E-01,1.8789E-01,1.2965E-01,6.8347E-02,3.7626E-04,
     &2.4693E-01,1.9751E-01,1.3653E-01,7.1994E-02,3.9112E-04,
     &2.5998E-01,2.0903E-01,1.4470E-01,7.6316E-02,4.0431E-04,
     &2.7577E-01,2.2297E-01,1.5458E-01,8.1500E-02,4.1520E-04/
      DATA ((KB(JS,JT,40, 2),JS=1,5),JT=1,5) /
     &2.0347E-01,1.6128E-01,1.1107E-01,5.8373E-02,2.9088E-04,
     &2.1275E-01,1.6921E-01,1.1659E-01,6.1296E-02,3.0550E-04,
     &2.2248E-01,1.7787E-01,1.2279E-01,6.4562E-02,3.1830E-04,
     &2.3419E-01,1.8824E-01,1.3013E-01,6.8434E-02,3.2975E-04,
     &2.4824E-01,2.0081E-01,1.3903E-01,7.3098E-02,3.3913E-04/
      DATA ((KB(JS,JT,41, 2),JS=1,5),JT=1,5) /
     &1.8258E-01,1.4470E-01,9.9535E-02,5.2202E-02,2.3535E-04,
     &1.9113E-01,1.5197E-01,1.0458E-01,5.4844E-02,2.4773E-04,
     &1.9995E-01,1.5977E-01,1.1015E-01,5.7766E-02,2.5866E-04,
     &2.1035E-01,1.6906E-01,1.1672E-01,6.1215E-02,2.6866E-04,
     &2.2281E-01,1.8031E-01,1.2469E-01,6.5393E-02,2.7675E-04/
      DATA ((KB(JS,JT,42, 2),JS=1,5),JT=1,5) /
     &1.6555E-01,1.3118E-01,9.0125E-02,4.7172E-02,1.9035E-04,
     &1.7351E-01,1.3791E-01,9.4797E-02,4.9586E-02,2.0086E-04,
     &1.8167E-01,1.4504E-01,9.9843E-02,5.2229E-02,2.1016E-04,
     &1.9101E-01,1.5346E-01,1.0581E-01,5.5333E-02,2.1875E-04,
     &2.0220E-01,1.6362E-01,1.1299E-01,5.9103E-02,2.2587E-04/
      DATA ((KB(JS,JT,43, 2),JS=1,5),JT=1,5) /
     &1.5093E-01,1.1961E-01,8.2075E-02,4.2874E-02,1.5326E-04,
     &1.5853E-01,1.2589E-01,8.6428E-02,4.5110E-02,1.6227E-04,
     &1.6609E-01,1.3244E-01,9.1034E-02,4.7504E-02,1.7029E-04,
     &1.7452E-01,1.4008E-01,9.6428E-02,5.0296E-02,1.7773E-04,
     &1.8456E-01,1.4921E-01,1.0290E-01,5.3684E-02,1.8398E-04/
      DATA ((KB(JS,JT,44, 2),JS=1,5),JT=1,5) /
     &1.3921E-01,1.1030E-01,7.5620E-02,3.9420E-02,1.2316E-04,
     &1.4661E-01,1.1628E-01,7.9723E-02,4.1521E-02,1.3084E-04,
     &1.5377E-01,1.2242E-01,8.4004E-02,4.3727E-02,1.3764E-04,
     &1.6148E-01,1.2941E-01,8.8933E-02,4.6269E-02,1.4416E-04,
     &1.7060E-01,1.3772E-01,9.4815E-02,4.9343E-02,1.4964E-04/
      DATA ((KB(JS,JT,45, 2),JS=1,5),JT=1,5) /
     &1.3086E-01,1.0364E-01,7.0980E-02,3.6935E-02,9.8771E-05,
     &1.3832E-01,1.0957E-01,7.5010E-02,3.8986E-02,1.0533E-04,
     &1.4520E-01,1.1543E-01,7.9072E-02,4.1056E-02,1.1127E-04,
     &1.5249E-01,1.2195E-01,8.3674E-02,4.3425E-02,1.1690E-04,
     &1.6094E-01,1.2967E-01,8.9124E-02,4.6256E-02,1.2176E-04/
      DATA ((KB(JS,JT,46, 2),JS=1,5),JT=1,5) /
     &1.2395E-01,9.8133E-02,6.7135E-02,3.4876E-02,7.8972E-05,
     &1.3154E-01,1.0413E-01,7.1186E-02,3.6923E-02,8.4580E-05,
     &1.3835E-01,1.0981E-01,7.5111E-02,3.8913E-02,8.9707E-05,
     &1.4539E-01,1.1598E-01,7.9454E-02,4.1140E-02,9.4570E-05,
     &1.5328E-01,1.2322E-01,8.4552E-02,4.3768E-02,9.8952E-05/
      DATA ((KB(JS,JT,47, 2),JS=1,5),JT=1,5) /
     &1.1561E-01,9.1621E-02,6.2646E-02,3.2504E-02,6.2836E-05,
     &1.2359E-01,9.7799E-02,6.6803E-02,3.4586E-02,6.7612E-05,
     &1.3036E-01,1.0330E-01,7.0567E-02,3.6497E-02,7.2040E-05,
     &1.3710E-01,1.0912E-01,7.4632E-02,3.8567E-02,7.6196E-05,
     &1.4440E-01,1.1580E-01,7.9334E-02,4.0981E-02,8.0080E-05/
      DATA ((KB(JS,JT,48, 2),JS=1,5),JT=1,5) /
     &1.1035E-01,8.7581E-02,5.9868E-02,3.1032E-02,4.9884E-05,
     &1.1928E-01,9.4310E-02,6.4353E-02,3.3267E-02,5.4019E-05,
     &1.2628E-01,9.9898E-02,6.8156E-02,3.5187E-02,5.7777E-05,
     &1.3294E-01,1.0557E-01,7.2080E-02,3.7168E-02,6.1393E-05,
     &1.3996E-01,1.1191E-01,7.6553E-02,3.9465E-02,6.4815E-05/
      DATA ((KB(JS,JT,49, 2),JS=1,5),JT=1,5) /
     &1.0914E-01,8.6684E-02,5.9236E-02,3.0679E-02,3.9521E-05,
     &1.1962E-01,9.4485E-02,6.4406E-02,3.3233E-02,4.3077E-05,
     &1.2732E-01,1.0058E-01,6.8523E-02,3.5308E-02,4.6318E-05,
     &1.3429E-01,1.0636E-01,7.2504E-02,3.7320E-02,4.9451E-05,
     &1.4147E-01,1.1268E-01,7.6951E-02,3.9591E-02,5.2405E-05/
      DATA ((KB(JS,JT,50, 2),JS=1,5),JT=1,5) /
     &1.0267E-01,8.1582E-02,5.5735E-02,2.8850E-02,3.1268E-05,
     &1.1402E-01,9.0165E-02,6.1437E-02,3.1671E-02,3.4319E-05,
     &1.2234E-01,9.6602E-02,6.5766E-02,3.3840E-02,3.7076E-05,
     &1.2939E-01,1.0230E-01,6.9668E-02,3.5813E-02,3.9737E-05,
     &1.3639E-01,1.0837E-01,7.3903E-02,3.7967E-02,4.2232E-05/
      DATA ((KB(JS,JT,51, 2),JS=1,5),JT=1,5) /
     &9.4284E-02,7.4953E-02,5.1186E-02,2.6482E-02,2.4659E-05,
     &1.0593E-01,8.3948E-02,5.7209E-02,2.9486E-02,2.7298E-05,
     &1.1492E-01,9.0727E-02,6.1733E-02,3.1740E-02,2.9657E-05,
     &1.2197E-01,9.6371E-02,6.5573E-02,3.3673E-02,3.1882E-05,
     &1.2870E-01,1.0212E-01,6.9569E-02,3.5694E-02,3.4030E-05/
      DATA ((KB(JS,JT,52, 2),JS=1,5),JT=1,5) /
     &8.8743E-02,7.0542E-02,4.8148E-02,2.4885E-02,1.9415E-05,
     &1.0078E-01,7.9976E-02,5.4503E-02,2.8085E-02,2.1689E-05,
     &1.1078E-01,8.7454E-02,5.9476E-02,3.0551E-02,2.3703E-05,
     &1.1817E-01,9.3325E-02,6.3448E-02,3.2545E-02,2.5596E-05,
     &1.2490E-01,9.8940E-02,6.7340E-02,3.4514E-02,2.7422E-05/
      DATA ((KB(JS,JT,53, 2),JS=1,5),JT=1,5) /
     &8.6662E-02,6.8864E-02,4.6962E-02,2.4236E-02,1.5263E-05,
     &9.9515E-02,7.8952E-02,5.3787E-02,2.7692E-02,1.7200E-05,
     &1.1085E-01,8.7554E-02,5.9520E-02,3.0542E-02,1.8920E-05,
     &1.1918E-01,9.4022E-02,6.3885E-02,3.2726E-02,2.0582E-05,
     &1.2628E-01,9.9818E-02,6.7862E-02,3.4747E-02,2.2128E-05/
      DATA ((KB(JS,JT,54, 2),JS=1,5),JT=1,5) /
     &7.3195E-02,5.8286E-02,3.9755E-02,2.0520E-02,1.1967E-05,
     &8.4972E-02,6.7544E-02,4.6023E-02,2.3702E-02,1.3585E-05,
     &9.5709E-02,7.5855E-02,5.1595E-02,2.6489E-02,1.5051E-05,
     &1.0394E-01,8.2096E-02,5.5779E-02,2.8575E-02,1.6406E-05,
     &1.1051E-01,8.7391E-02,5.9394E-02,3.0393E-02,1.7745E-05/
      DATA ((KB(JS,JT,55, 2),JS=1,5),JT=1,5) /
     &5.6277E-02,4.4947E-02,3.0672E-02,1.5850E-02,9.3585E-06,
     &6.6102E-02,5.2729E-02,3.5949E-02,1.8531E-02,1.0684E-05,
     &7.5193E-02,5.9877E-02,4.0765E-02,2.0959E-02,1.1938E-05,
     &8.2620E-02,6.5458E-02,4.4488E-02,2.2798E-02,1.3050E-05,
     &8.8216E-02,6.9936E-02,4.7530E-02,2.4316E-02,1.4154E-05/
      DATA ((KB(JS,JT,56, 2),JS=1,5),JT=1,5) /
     &4.3039E-02,3.4453E-02,2.3524E-02,1.2170E-02,7.2880E-06,
     &5.1258E-02,4.1038E-02,2.7994E-02,1.4446E-02,8.3961E-06,
     &5.8906E-02,4.7098E-02,3.2089E-02,1.6519E-02,9.4488E-06,
     &6.5506E-02,5.2094E-02,3.5421E-02,1.8161E-02,1.0382E-05,
     &7.0360E-02,5.5940E-02,3.8018E-02,1.9445E-02,1.1248E-05/
      DATA ((KB(JS,JT,57, 2),JS=1,5),JT=1,5) /
     &3.2674E-02,2.6237E-02,1.7922E-02,9.2805E-03,5.6715E-06,
     &3.9609E-02,3.1835E-02,2.1730E-02,1.1223E-02,6.5904E-06,
     &4.6006E-02,3.6922E-02,2.5172E-02,1.2973E-02,7.4542E-06,
     &5.1740E-02,4.1352E-02,2.8137E-02,1.4436E-02,8.2537E-06,
     &5.6054E-02,4.4686E-02,3.0382E-02,1.5541E-02,8.9675E-06/
      DATA ((KB(JS,JT,58, 2),JS=1,5),JT=1,5) /
     &6.5163E-03,6.4215E-03,5.6470E-03,4.1032E-03,4.4127E-06,
     &8.0617E-03,7.9508E-03,6.9853E-03,5.0619E-03,5.1550E-06,
     &9.4685E-03,9.3297E-03,8.1872E-03,5.9187E-03,5.8809E-06,
     &1.0753E-02,1.0568E-02,9.2585E-03,6.6629E-03,6.5571E-06,
     &1.1773E-02,1.1514E-02,1.0073E-02,7.2198E-03,7.1478E-06/
      DATA ((KB(JS,JT,59, 2),JS=1,5),JT=1,5) /
     &6.0678E-03,5.7484E-03,4.7181E-03,3.0625E-03,3.5292E-06,
     &7.5775E-03,7.1843E-03,5.8871E-03,3.8076E-03,4.1244E-06,
     &8.9504E-03,8.4793E-03,6.9385E-03,4.4706E-03,4.7056E-06,
     &1.0202E-02,9.6400E-03,7.8732E-03,5.0416E-03,5.2546E-06,
     &1.1221E-02,1.0539E-02,8.5853E-03,5.4711E-03,5.7591E-06/
      DATA ((KB(JS,JT,13, 3),JS=1,5),JT=1,5) /
     &1.3886E+02,1.0424E+02,6.9618E+01,3.4998E+01,6.8908E-02,
     &1.3847E+02,1.0394E+02,6.9423E+01,3.4905E+01,7.3584E-02,
     &1.3854E+02,1.0400E+02,6.9461E+01,3.4924E+01,7.8137E-02,
     &1.4034E+02,1.0534E+02,7.0354E+01,3.5368E+01,8.2835E-02,
     &1.4333E+02,1.0759E+02,7.1853E+01,3.6116E+01,8.7500E-02/
      DATA ((KB(JS,JT,14, 3),JS=1,5),JT=1,5) /
     &7.1765E+01,5.3918E+01,3.6073E+01,1.8228E+01,5.9867E-02,
     &7.1567E+01,5.3771E+01,3.5977E+01,1.8183E+01,6.3947E-02,
     &7.1902E+01,5.4021E+01,3.6141E+01,1.8266E+01,6.8160E-02,
     &7.3101E+01,5.4919E+01,3.6739E+01,1.8569E+01,7.2138E-02,
     &7.4813E+01,5.6202E+01,3.7593E+01,1.8992E+01,7.6299E-02/
      DATA ((KB(JS,JT,15, 3),JS=1,5),JT=1,5) /
     &3.7762E+01,2.8418E+01,1.9073E+01,9.7323E+00,5.1937E-02,
     &3.7725E+01,2.8390E+01,1.9057E+01,9.7303E+00,5.5591E-02,
     &3.8048E+01,2.8634E+01,1.9221E+01,9.8224E+00,5.9263E-02,
     &3.8784E+01,2.9182E+01,1.9585E+01,1.0010E+01,6.2883E-02,
     &3.9804E+01,2.9945E+01,2.0089E+01,1.0260E+01,6.6326E-02/
      DATA ((KB(JS,JT,16, 3),JS=1,5),JT=1,5) /
     &2.3667E+01,1.7845E+01,1.2024E+01,6.2150E+00,4.4961E-02,
     &2.3710E+01,1.7881E+01,1.2053E+01,6.2413E+00,4.8227E-02,
     &2.3983E+01,1.8085E+01,1.2193E+01,6.3263E+00,5.1418E-02,
     &2.4541E+01,1.8499E+01,1.2468E+01,6.4708E+00,5.4587E-02,
     &2.5247E+01,1.9026E+01,1.2815E+01,6.6457E+00,5.7578E-02/
      DATA ((KB(JS,JT,17, 3),JS=1,5),JT=1,5) /
     &1.5411E+01,1.1654E+01,7.9029E+00,4.1290E+00,3.8761E-02,
     &1.5483E+01,1.1712E+01,7.9484E+00,4.1656E+00,4.1564E-02,
     &1.5715E+01,1.1885E+01,8.0713E+00,4.2451E+00,4.4369E-02,
     &1.6109E+01,1.2177E+01,8.2663E+00,4.3534E+00,4.7100E-02,
     &1.6611E+01,1.2551E+01,8.5125E+00,4.4825E+00,4.9594E-02/
      DATA ((KB(JS,JT,18, 3),JS=1,5),JT=1,5) /
     &1.0325E+01,7.8390E+00,5.3612E+00,2.8294E+00,3.3186E-02,
     &1.0398E+01,7.8984E+00,5.4111E+00,2.8675E+00,3.5625E-02,
     &1.0571E+01,8.0297E+00,5.5102E+00,2.9332E+00,3.8042E-02,
     &1.0854E+01,8.2395E+00,5.6528E+00,3.0140E+00,4.0327E-02,
     &1.1221E+01,8.5111E+00,5.8333E+00,3.1124E+00,4.2414E-02/
      DATA ((KB(JS,JT,19, 3),JS=1,5),JT=1,5) /
     &6.8208E+00,5.2153E+00,3.5957E+00,1.9227E+00,2.8261E-02,
     &6.8751E+00,5.2621E+00,3.6379E+00,1.9560E+00,3.0383E-02,
     &7.0006E+00,5.3588E+00,3.7145E+00,2.0054E+00,3.2394E-02,
     &7.2016E+00,5.5069E+00,3.8180E+00,2.0649E+00,3.4293E-02,
     &7.4662E+00,5.7018E+00,3.9518E+00,2.1403E+00,3.6047E-02/
      DATA ((KB(JS,JT,20, 3),JS=1,5),JT=1,5) /
     &4.8794E+00,3.7616E+00,2.6099E+00,1.4082E+00,2.4010E-02,
     &4.9222E+00,3.8008E+00,2.6471E+00,1.4364E+00,2.5795E-02,
     &5.0241E+00,3.8811E+00,2.7106E+00,1.4758E+00,2.7487E-02,
     &5.1822E+00,3.9983E+00,2.7942E+00,1.5252E+00,2.9078E-02,
     &5.3938E+00,4.1543E+00,2.9036E+00,1.5872E+00,3.0457E-02/
      DATA ((KB(JS,JT,21, 3),JS=1,5),JT=1,5) /
     &3.5976E+00,2.7957E+00,1.9525E+00,1.0602E+00,2.0310E-02,
     &3.6356E+00,2.8321E+00,1.9867E+00,1.0846E+00,2.1803E-02,
     &3.7222E+00,2.9011E+00,2.0401E+00,1.1175E+00,2.3227E-02,
     &3.8497E+00,2.9972E+00,2.1098E+00,1.1593E+00,2.4505E-02,
     &4.0214E+00,3.1255E+00,2.2004E+00,1.2111E+00,2.5550E-02/
      DATA ((KB(JS,JT,22, 3),JS=1,5),JT=1,5) /
     &2.7203E+00,2.1314E+00,1.4964E+00,8.1782E-01,1.7205E-02,
     &2.7584E+00,2.1682E+00,1.5287E+00,8.3963E-01,1.8458E-02,
     &2.8354E+00,2.2296E+00,1.5749E+00,8.6850E-01,1.9598E-02,
     &2.9415E+00,2.3111E+00,1.6346E+00,9.0426E-01,2.0559E-02,
     &3.0867E+00,2.4212E+00,1.7134E+00,9.4960E-01,2.1311E-02/
      DATA ((KB(JS,JT,23, 3),JS=1,5),JT=1,5) /
     &2.0695E+00,1.6369E+00,1.1532E+00,6.3485E-01,1.4544E-02,
     &2.1080E+00,1.6730E+00,1.1833E+00,6.5423E-01,1.5557E-02,
     &2.1745E+00,1.7262E+00,1.2233E+00,6.7947E-01,1.6419E-02,
     &2.2647E+00,1.7970E+00,1.2752E+00,7.1089E-01,1.7120E-02,
     &2.3823E+00,1.8879E+00,1.3412E+00,7.4903E-01,1.7674E-02/
      DATA ((KB(JS,JT,24, 3),JS=1,5),JT=1,5) /
     &1.5697E+00,1.2531E+00,8.8637E-01,4.9139E-01,1.2257E-02,
     &1.6055E+00,1.2864E+00,9.1332E-01,5.0866E-01,1.3031E-02,
     &1.6631E+00,1.3329E+00,9.4834E-01,5.3086E-01,1.3670E-02,
     &1.7374E+00,1.3923E+00,9.9245E-01,5.5764E-01,1.4194E-02,
     &1.8327E+00,1.4671E+00,1.0467E+00,5.8890E-01,1.4611E-02/
      DATA ((KB(JS,JT,25, 3),JS=1,5),JT=1,5) /
     &1.2086E+00,9.7309E-01,6.9155E-01,3.8568E-01,1.0281E-02,
     &1.2420E+00,1.0035E+00,7.1528E-01,4.0109E-01,1.0857E-02,
     &1.2906E+00,1.0433E+00,7.4566E-01,4.2042E-01,1.1339E-02,
     &1.3533E+00,1.0941E+00,7.8339E-01,4.4308E-01,1.1737E-02,
     &1.4315E+00,1.1563E+00,8.2868E-01,4.6855E-01,1.2054E-02/
      DATA ((KB(JS,JT,26, 3),JS=1,5),JT=1,5) /
     &9.4867E-01,7.6987E-01,5.4929E-01,3.0788E-01,8.5827E-03,
     &9.7957E-01,7.9721E-01,5.7050E-01,3.2189E-01,9.0225E-03,
     &1.0209E+00,8.3198E-01,5.9699E-01,3.3862E-01,9.3908E-03,
     &1.0742E+00,8.7561E-01,6.2951E-01,3.5776E-01,9.6952E-03,
     &1.1410E+00,9.2907E-01,6.6837E-01,3.7907E-01,9.9345E-03/
      DATA ((KB(JS,JT,27, 3),JS=1,5),JT=1,5) /
     &7.7558E-01,6.3324E-01,4.5279E-01,2.5468E-01,7.1414E-03,
     &8.0374E-01,6.5793E-01,4.7219E-01,2.6746E-01,7.4832E-03,
     &8.4002E-01,6.8874E-01,4.9567E-01,2.8203E-01,7.7674E-03,
     &8.8798E-01,7.2827E-01,5.2483E-01,2.9866E-01,7.9993E-03,
     &9.4670E-01,7.7585E-01,5.5890E-01,3.1722E-01,8.1810E-03/
      DATA ((KB(JS,JT,28, 3),JS=1,5),JT=1,5) /
     &6.5247E-01,5.3505E-01,3.8309E-01,2.1606E-01,5.9313E-03,
     &6.7805E-01,5.5765E-01,4.0088E-01,2.2763E-01,6.1964E-03,
     &7.1138E-01,5.8602E-01,4.2234E-01,2.4051E-01,6.4170E-03,
     &7.5565E-01,6.2271E-01,4.4913E-01,2.5531E-01,6.5956E-03,
     &8.0810E-01,6.6536E-01,4.7931E-01,2.7186E-01,6.7356E-03/
      DATA ((KB(JS,JT,29, 3),JS=1,5),JT=1,5) /
     &5.8359E-01,4.7922E-01,3.4299E-01,1.9330E-01,4.9222E-03,
     &6.0836E-01,5.0105E-01,3.5992E-01,2.0402E-01,5.1279E-03,
     &6.4169E-01,5.2929E-01,3.8096E-01,2.1613E-01,5.2989E-03,
     &6.8418E-01,5.6479E-01,4.0659E-01,2.3010E-01,5.4376E-03,
     &7.3388E-01,6.0487E-01,4.3487E-01,2.4554E-01,5.5459E-03/
      DATA ((KB(JS,JT,30, 3),JS=1,5),JT=1,5) /
     &5.3559E-01,4.3987E-01,3.1446E-01,1.7681E-01,4.0812E-03,
     &5.6092E-01,4.6195E-01,3.3123E-01,1.8699E-01,4.2410E-03,
     &5.9467E-01,4.9061E-01,3.5234E-01,1.9880E-01,4.3756E-03,
     &6.3620E-01,5.2529E-01,3.7692E-01,2.1218E-01,4.4820E-03,
     &6.8416E-01,5.6390E-01,4.0420E-01,2.2692E-01,4.5637E-03/
      DATA ((KB(JS,JT,31, 3),JS=1,5),JT=1,5) /
     &5.1816E-01,4.2464E-01,3.0261E-01,1.6922E-01,3.3825E-03,
     &5.4536E-01,4.4814E-01,3.2013E-01,1.7945E-01,3.5084E-03,
     &5.8079E-01,4.7822E-01,3.4203E-01,1.9145E-01,3.6133E-03,
     &6.2360E-01,5.1355E-01,3.6685E-01,2.0495E-01,3.6964E-03,
     &6.7136E-01,5.5242E-01,3.9433E-01,2.1968E-01,3.7632E-03/
      DATA ((KB(JS,JT,32, 3),JS=1,5),JT=1,5) /
     &5.0836E-01,4.1565E-01,2.9513E-01,1.6401E-01,2.8023E-03,
     &5.3755E-01,4.4081E-01,3.1373E-01,1.7458E-01,2.9031E-03,
     &5.7518E-01,4.7260E-01,3.3647E-01,1.8685E-01,2.9841E-03,
     &6.1917E-01,5.0863E-01,3.6188E-01,2.0060E-01,3.0523E-03,
     &6.6737E-01,5.4799E-01,3.8954E-01,2.1543E-01,3.1032E-03/
      DATA ((KB(JS,JT,33, 3),JS=1,5),JT=1,5) /
     &5.0907E-01,4.1513E-01,2.9365E-01,1.6205E-01,2.3233E-03,
     &5.4095E-01,4.4243E-01,3.1363E-01,1.7315E-01,2.4017E-03,
     &5.8099E-01,4.7617E-01,3.3742E-01,1.8595E-01,2.4676E-03,
     &6.2648E-01,5.1328E-01,3.6375E-01,2.0009E-01,2.5196E-03,
     &6.7646E-01,5.5394E-01,3.9218E-01,2.1533E-01,2.5609E-03/
      DATA ((KB(JS,JT,34, 3),JS=1,5),JT=1,5) /
     &4.9704E-01,4.0480E-01,2.8555E-01,1.5673E-01,1.9225E-03,
     &5.3069E-01,4.3364E-01,3.0643E-01,1.6807E-01,1.9847E-03,
     &5.7151E-01,4.6776E-01,3.3046E-01,1.8101E-01,2.0370E-03,
     &6.1711E-01,5.0510E-01,3.5686E-01,1.9508E-01,2.0801E-03,
     &6.6746E-01,5.4585E-01,3.8550E-01,2.1045E-01,2.1144E-03/
      DATA ((KB(JS,JT,35, 3),JS=1,5),JT=1,5) /
     &4.8386E-01,3.9362E-01,2.7689E-01,1.5116E-01,1.5847E-03,
     &5.1832E-01,4.2323E-01,2.9822E-01,1.6263E-01,1.6362E-03,
     &5.5929E-01,4.5721E-01,3.2219E-01,1.7550E-01,1.6795E-03,
     &6.0482E-01,4.9463E-01,3.4852E-01,1.8949E-01,1.7156E-03,
     &6.5512E-01,5.3534E-01,3.7729E-01,2.0487E-01,1.7410E-03/
      DATA ((KB(JS,JT,36, 3),JS=1,5),JT=1,5) /
     &4.6553E-01,3.7836E-01,2.6548E-01,1.4421E-01,1.3024E-03,
     &4.9953E-01,4.0773E-01,2.8657E-01,1.5552E-01,1.3449E-03,
     &5.3980E-01,4.4109E-01,3.1015E-01,1.6814E-01,1.3813E-03,
     &5.8461E-01,4.7793E-01,3.3603E-01,1.8187E-01,1.4105E-03,
     &6.3401E-01,5.1804E-01,3.6447E-01,1.9702E-01,1.4329E-03/
      DATA ((KB(JS,JT,37, 3),JS=1,5),JT=1,5) /
     &4.3247E-01,3.5136E-01,2.4603E-01,1.3313E-01,1.0644E-03,
     &4.6409E-01,3.7893E-01,2.6588E-01,1.4378E-01,1.1011E-03,
     &5.0193E-01,4.1040E-01,2.8814E-01,1.5568E-01,1.1313E-03,
     &5.4423E-01,4.4538E-01,3.1275E-01,1.6870E-01,1.1563E-03,
     &5.9125E-01,4.8359E-01,3.3982E-01,1.8310E-01,1.1762E-03/
      DATA ((KB(JS,JT,38, 3),JS=1,5),JT=1,5) /
     &4.0752E-01,3.3084E-01,2.3116E-01,1.2457E-01,8.6985E-04,
     &4.3734E-01,3.5701E-01,2.5006E-01,1.3472E-01,9.0011E-04,
     &4.7342E-01,3.8717E-01,2.7137E-01,1.4611E-01,9.2699E-04,
     &5.1398E-01,4.2080E-01,2.9507E-01,1.5862E-01,9.4795E-04,
     &5.5926E-01,4.5769E-01,3.2123E-01,1.7252E-01,9.6539E-04/
      DATA ((KB(JS,JT,39, 3),JS=1,5),JT=1,5) /
     &3.9286E-01,3.1853E-01,2.2204E-01,1.1910E-01,7.1027E-04,
     &4.2168E-01,3.4392E-01,2.4040E-01,1.2899E-01,7.3606E-04,
     &4.5685E-01,3.7344E-01,2.6129E-01,1.4014E-01,7.5956E-04,
     &4.9667E-01,4.0652E-01,2.8462E-01,1.5245E-01,7.7770E-04,
     &5.4133E-01,4.4296E-01,3.1045E-01,1.6619E-01,7.9334E-04/
      DATA ((KB(JS,JT,40, 3),JS=1,5),JT=1,5) /
     &3.5355E-01,2.8669E-01,1.9956E-01,1.0673E-01,5.7721E-04,
     &3.7907E-01,3.0944E-01,2.1608E-01,1.1569E-01,5.9933E-04,
     &4.1075E-01,3.3635E-01,2.3514E-01,1.2587E-01,6.1943E-04,
     &4.4707E-01,3.6668E-01,2.5658E-01,1.3717E-01,6.3526E-04,
     &4.8803E-01,4.0025E-01,2.8039E-01,1.4981E-01,6.4905E-04/
      DATA ((KB(JS,JT,41, 3),JS=1,5),JT=1,5) /
     &3.1722E-01,2.5721E-01,1.7878E-01,9.5352E-02,4.6830E-04,
     &3.3984E-01,2.7762E-01,1.9366E-01,1.0349E-01,4.8763E-04,
     &3.6801E-01,3.0195E-01,2.1092E-01,1.1268E-01,5.0461E-04,
     &4.0101E-01,3.2964E-01,2.3053E-01,1.2303E-01,5.1866E-04,
     &4.3854E-01,3.6057E-01,2.5249E-01,1.3467E-01,5.3060E-04/
      DATA ((KB(JS,JT,42, 3),JS=1,5),JT=1,5) /
     &2.8780E-01,2.3320E-01,1.6182E-01,8.6050E-02,3.7987E-04,
     &3.0806E-01,2.5171E-01,1.7535E-01,9.3494E-02,3.9649E-04,
     &3.3326E-01,2.7383E-01,1.9111E-01,1.0188E-01,4.1103E-04,
     &3.6352E-01,2.9931E-01,2.0921E-01,1.1145E-01,4.2329E-04,
     &3.9814E-01,3.2805E-01,2.2962E-01,1.2223E-01,4.3386E-04/
      DATA ((KB(JS,JT,43, 3),JS=1,5),JT=1,5) /
     &2.6265E-01,2.1245E-01,1.4714E-01,7.7969E-02,3.0714E-04,
     &2.8068E-01,2.2918E-01,1.5940E-01,8.4750E-02,3.2151E-04,
     &3.0314E-01,2.4932E-01,1.7384E-01,9.2466E-02,3.3415E-04,
     &3.3080E-01,2.7269E-01,1.9045E-01,1.0127E-01,3.4470E-04,
     &3.6272E-01,2.9942E-01,2.0942E-01,1.1129E-01,3.5407E-04/
      DATA ((KB(JS,JT,44, 3),JS=1,5),JT=1,5) /
     &2.4281E-01,1.9594E-01,1.3540E-01,7.1467E-02,2.4789E-04,
     &2.5884E-01,2.1103E-01,1.4648E-01,7.7626E-02,2.6014E-04,
     &2.7897E-01,2.2939E-01,1.5978E-01,8.4794E-02,2.7117E-04,
     &3.0448E-01,2.5115E-01,1.7522E-01,9.2989E-02,2.8049E-04,
     &3.3408E-01,2.7612E-01,1.9297E-01,1.0236E-01,2.8861E-04/
      DATA ((KB(JS,JT,45, 3),JS=1,5),JT=1,5) /
     &2.2924E-01,1.8447E-01,1.2716E-01,6.6832E-02,2.0004E-04,
     &2.4373E-01,1.9820E-01,1.3728E-01,7.2484E-02,2.1065E-04,
     &2.6228E-01,2.1536E-01,1.4978E-01,7.9297E-02,2.1996E-04,
     &2.8578E-01,2.3573E-01,1.6427E-01,8.6976E-02,2.2795E-04,
     &3.1387E-01,2.5954E-01,1.8123E-01,9.5940E-02,2.3501E-04/
      DATA ((KB(JS,JT,46, 3),JS=1,5),JT=1,5) /
     &2.1864E-01,1.7537E-01,1.2059E-01,6.3114E-02,1.6106E-04,
     &2.3164E-01,1.8773E-01,1.2971E-01,6.8234E-02,1.7008E-04,
     &2.4878E-01,2.0380E-01,1.4148E-01,7.4690E-02,1.7817E-04,
     &2.7041E-01,2.2298E-01,1.5518E-01,8.1986E-02,1.8514E-04,
     &2.9717E-01,2.4573E-01,1.7143E-01,9.0585E-02,1.9112E-04/
      DATA ((KB(JS,JT,47, 3),JS=1,5),JT=1,5) /
     &2.0666E-01,1.6515E-01,1.1329E-01,5.9056E-02,1.2901E-04,
     &2.1779E-01,1.7589E-01,1.2122E-01,6.3515E-02,1.3680E-04,
     &2.3320E-01,1.9053E-01,1.3198E-01,6.9466E-02,1.4384E-04,
     &2.5274E-01,2.0828E-01,1.4478E-01,7.6351E-02,1.4999E-04,
     &2.7761E-01,2.2954E-01,1.5995E-01,8.4385E-02,1.5514E-04/
      DATA ((KB(JS,JT,48, 3),JS=1,5),JT=1,5) /
     &2.0159E-01,1.6032E-01,1.0970E-01,5.6945E-02,1.0330E-04,
     &2.1094E-01,1.6966E-01,1.1661E-01,6.0834E-02,1.0997E-04,
     &2.2505E-01,1.8313E-01,1.2656E-01,6.6365E-02,1.1606E-04,
     &2.4321E-01,1.9993E-01,1.3877E-01,7.3027E-02,1.2143E-04,
     &2.6669E-01,2.2023E-01,1.5323E-01,8.0709E-02,1.2582E-04/
      DATA ((KB(JS,JT,49, 3),JS=1,5),JT=1,5) /
     &2.0550E-01,1.6255E-01,1.1090E-01,5.7322E-02,8.2624E-05,
     &2.1330E-01,1.7068E-01,1.1698E-01,6.0751E-02,8.8378E-05,
     &2.2651E-01,1.8330E-01,1.2630E-01,6.5972E-02,9.3615E-05,
     &2.4409E-01,1.9975E-01,1.3835E-01,7.2591E-02,9.8246E-05,
     &2.6685E-01,2.1980E-01,1.5269E-01,8.0258E-02,1.0201E-04/
      DATA ((KB(JS,JT,50, 3),JS=1,5),JT=1,5) /
     &2.0001E-01,1.5763E-01,1.0735E-01,5.5313E-02,6.6052E-05,
     &2.0622E-01,1.6433E-01,1.1239E-01,5.8166E-02,7.0964E-05,
     &2.1782E-01,1.7560E-01,1.2070E-01,6.2821E-02,7.5460E-05,
     &2.3393E-01,1.9090E-01,1.3196E-01,6.9056E-02,7.9402E-05,
     &2.5520E-01,2.0998E-01,1.4571E-01,7.6464E-02,8.2692E-05/
      DATA ((KB(JS,JT,51, 3),JS=1,5),JT=1,5) /
     &1.9065E-01,1.4985E-01,1.0188E-01,5.2372E-02,5.2796E-05,
     &1.9564E-01,1.5535E-01,1.0604E-01,5.4717E-02,5.6909E-05,
     &2.0531E-01,1.6500E-01,1.1319E-01,5.8726E-02,6.0736E-05,
     &2.1974E-01,1.7886E-01,1.2342E-01,6.4424E-02,6.4172E-05,
     &2.3909E-01,1.9652E-01,1.3622E-01,7.1393E-02,6.6971E-05/
      DATA ((KB(JS,JT,52, 3),JS=1,5),JT=1,5) /
     &1.8687E-01,1.4652E-01,9.9463E-02,5.1012E-02,4.2174E-05,
     &1.9141E-01,1.5137E-01,1.0312E-01,5.3053E-02,4.5594E-05,
     &1.9940E-01,1.5962E-01,1.0927E-01,5.6516E-02,4.8848E-05,
     &2.1252E-01,1.7228E-01,1.1865E-01,6.1768E-02,5.1771E-05,
     &2.3051E-01,1.8896E-01,1.3079E-01,6.8431E-02,5.4234E-05/
      DATA ((KB(JS,JT,53, 3),JS=1,5),JT=1,5) /
     &1.9049E-01,1.4907E-01,1.0107E-01,5.1727E-02,3.3675E-05,
     &1.9537E-01,1.5387E-01,1.0462E-01,5.3675E-02,3.6498E-05,
     &2.0221E-01,1.6109E-01,1.1002E-01,5.6715E-02,3.9286E-05,
     &2.1438E-01,1.7292E-01,1.1878E-01,6.1645E-02,4.1745E-05,
     &2.3164E-01,1.8913E-01,1.3065E-01,6.8198E-02,4.3903E-05/
      DATA ((KB(JS,JT,54, 3),JS=1,5),JT=1,5) /
     &1.6750E-01,1.3117E-01,8.8914E-02,4.5482E-02,2.6834E-05,
     &1.7260E-01,1.3577E-01,9.2225E-02,4.7257E-02,2.9152E-05,
     &1.7790E-01,1.4144E-01,9.6473E-02,4.9632E-02,3.1487E-05,
     &1.8750E-01,1.5107E-01,1.0362E-01,5.3663E-02,3.3610E-05,
     &2.0185E-01,1.6484E-01,1.1376E-01,5.9292E-02,3.5416E-05/
      DATA ((KB(JS,JT,55, 3),JS=1,5),JT=1,5) /
     &1.3399E-01,1.0522E-01,7.1343E-02,3.6503E-02,2.1364E-05,
     &1.3914E-01,1.0951E-01,7.4357E-02,3.8080E-02,2.3275E-05,
     &1.4309E-01,1.1374E-01,7.7519E-02,3.9837E-02,2.5155E-05,
     &1.4990E-01,1.2087E-01,8.2841E-02,4.2848E-02,2.6955E-05,
     &1.6076E-01,1.3155E-01,9.0755E-02,4.7259E-02,2.8512E-05/
      DATA ((KB(JS,JT,56, 3),JS=1,5),JT=1,5) /
     &1.0674E-01,8.4150E-02,5.7088E-02,2.9230E-02,1.7018E-05,
     &1.1202E-01,8.8284E-02,5.9924E-02,3.0675E-02,1.8552E-05,
     &1.1522E-01,9.1603E-02,6.2380E-02,3.2028E-02,2.0079E-05,
     &1.2002E-01,9.6801E-02,6.6273E-02,3.4240E-02,2.1582E-05,
     &1.2813E-01,1.0499E-01,7.2382E-02,3.7660E-02,2.2972E-05/
      DATA ((KB(JS,JT,57, 3),JS=1,5),JT=1,5) /
     &8.4657E-02,6.6996E-02,4.5488E-02,2.3320E-02,1.3524E-05,
     &8.9961E-02,7.1035E-02,4.8219E-02,2.4686E-02,1.4787E-05,
     &9.2828E-02,7.3808E-02,5.0230E-02,2.5772E-02,1.6030E-05,
     &9.6271E-02,7.7620E-02,5.3068E-02,2.7385E-02,1.7279E-05,
     &1.0221E-01,8.3835E-02,5.7725E-02,3.0004E-02,1.8442E-05/
      DATA ((KB(JS,JT,58, 3),JS=1,5),JT=1,5) /
     &1.7656E-02,1.7150E-02,1.4988E-02,1.0779E-02,1.0747E-05,
     &1.9015E-02,1.8411E-02,1.6077E-02,1.1536E-02,1.1805E-05,
     &1.9736E-02,1.9199E-02,1.6794E-02,1.2067E-02,1.2808E-05,
     &2.0419E-02,2.0127E-02,1.7678E-02,1.2766E-02,1.3807E-05,
     &2.1547E-02,2.1640E-02,1.9143E-02,1.3925E-02,1.4766E-05/
      DATA ((KB(JS,JT,59, 3),JS=1,5),JT=1,5) /
     &1.6768E-02,1.5635E-02,1.2738E-02,8.1686E-03,8.6706E-06,
     &1.8151E-02,1.6868E-02,1.3724E-02,8.7749E-03,9.5360E-06,
     &1.8900E-02,1.7641E-02,1.4372E-02,9.2015E-03,1.0356E-05,
     &1.9564E-02,1.8529E-02,1.5159E-02,9.7488E-03,1.1149E-05,
     &2.0620E-02,1.9962E-02,1.6458E-02,1.0647E-02,1.1905E-05/
      DATA ((KB(JS,JT,13, 4),JS=1,5),JT=1,5) /
     &2.1586E+02,1.6199E+02,1.0811E+02,5.4245E+01,1.2105E-01,
     &2.1869E+02,1.6410E+02,1.0952E+02,5.4940E+01,1.2618E-01,
     &2.2370E+02,1.6786E+02,1.1202E+02,5.6190E+01,1.3118E-01,
     &2.3070E+02,1.7312E+02,1.1553E+02,5.7947E+01,1.3630E-01,
     &2.4034E+02,1.8034E+02,1.2035E+02,6.0352E+01,1.4080E-01/
      DATA ((KB(JS,JT,14, 4),JS=1,5),JT=1,5) /
     &1.1263E+02,8.4567E+01,5.6502E+01,2.8444E+01,1.0638E-01,
     &1.1465E+02,8.6072E+01,5.7500E+01,2.8941E+01,1.1108E-01,
     &1.1796E+02,8.8560E+01,5.9161E+01,2.9768E+01,1.1550E-01,
     &1.2248E+02,9.1950E+01,6.1421E+01,3.0896E+01,1.2021E-01,
     &1.2816E+02,9.6211E+01,6.4260E+01,3.2312E+01,1.2485E-01/
      DATA ((KB(JS,JT,15, 4),JS=1,5),JT=1,5) /
     &5.9854E+01,4.4984E+01,3.0119E+01,1.5274E+01,9.2887E-02,
     &6.1271E+01,4.6045E+01,3.0823E+01,1.5619E+01,9.7129E-02,
     &6.3412E+01,4.7652E+01,3.1894E+01,1.6144E+01,1.0153E-01,
     &6.6234E+01,4.9767E+01,3.3302E+01,1.6842E+01,1.0585E-01,
     &6.9392E+01,5.2133E+01,3.4876E+01,1.7625E+01,1.1025E-01/
      DATA ((KB(JS,JT,16, 4),JS=1,5),JT=1,5) /
     &3.7898E+01,2.8521E+01,1.9151E+01,9.8246E+00,8.0720E-02,
     &3.9024E+01,2.9361E+01,1.9706E+01,1.0088E+01,8.4821E-02,
     &4.0630E+01,3.0565E+01,2.0505E+01,1.0472E+01,8.9056E-02,
     &4.2559E+01,3.2011E+01,2.1467E+01,1.0943E+01,9.3186E-02,
     &4.4564E+01,3.3513E+01,2.2465E+01,1.1432E+01,9.7171E-02/
      DATA ((KB(JS,JT,17, 4),JS=1,5),JT=1,5) /
     &2.4925E+01,1.8792E+01,1.2674E+01,6.6287E+00,6.9974E-02,
     &2.5814E+01,1.9454E+01,1.3108E+01,6.8325E+00,7.3907E-02,
     &2.6980E+01,2.0330E+01,1.3687E+01,7.1100E+00,7.7821E-02,
     &2.8287E+01,2.1307E+01,1.4334E+01,7.4176E+00,8.1565E-02,
     &2.9635E+01,2.2318E+01,1.5005E+01,7.7402E+00,8.5222E-02/
      DATA ((KB(JS,JT,18, 4),JS=1,5),JT=1,5) /
     &1.6833E+01,1.2726E+01,8.6533E+00,4.6132E+00,6.0568E-02,
     &1.7515E+01,1.3234E+01,8.9835E+00,4.7781E+00,6.4137E-02,
     &1.8359E+01,1.3866E+01,9.3947E+00,4.9795E+00,6.7564E-02,
     &1.9269E+01,1.4545E+01,9.8365E+00,5.1909E+00,7.0941E-02,
     &2.0186E+01,1.5233E+01,1.0291E+01,5.4115E+00,7.4160E-02/
      DATA ((KB(JS,JT,19, 4),JS=1,5),JT=1,5) /
     &1.1200E+01,8.5062E+00,5.8670E+00,3.1832E+00,5.2174E-02,
     &1.1703E+01,8.8805E+00,6.1092E+00,3.3121E+00,5.5280E-02,
     &1.2289E+01,9.3153E+00,6.3897E+00,3.4520E+00,5.8298E-02,
     &1.2879E+01,9.7549E+00,6.6727E+00,3.5951E+00,6.1230E-02,
     &1.3509E+01,1.0228E+01,6.9797E+00,3.7461E+00,6.3987E-02/
      DATA ((KB(JS,JT,20, 4),JS=1,5),JT=1,5) /
     &8.1017E+00,6.1940E+00,4.3223E+00,2.3773E+00,4.4725E-02,
     &8.4816E+00,6.4735E+00,4.5091E+00,2.4775E+00,4.7408E-02,
     &8.8970E+00,6.7793E+00,4.7079E+00,2.5791E+00,5.0027E-02,
     &9.3252E+00,7.0958E+00,4.9137E+00,2.6856E+00,5.2539E-02,
     &9.8057E+00,7.4546E+00,5.1456E+00,2.8027E+00,5.4910E-02/
      DATA ((KB(JS,JT,21, 4),JS=1,5),JT=1,5) /
     &6.0501E+00,4.6688E+00,3.2884E+00,1.8254E+00,3.8136E-02,
     &6.3357E+00,4.8779E+00,3.4312E+00,1.9011E+00,4.0441E-02,
     &6.6449E+00,5.1029E+00,3.5792E+00,1.9785E+00,4.2660E-02,
     &6.9762E+00,5.3455E+00,3.7404E+00,2.0617E+00,4.4823E-02,
     &7.3528E+00,5.6235E+00,3.9228E+00,2.1569E+00,4.6872E-02/
      DATA ((KB(JS,JT,22, 4),JS=1,5),JT=1,5) /
     &4.6404E+00,3.6182E+00,2.5692E+00,1.4322E+00,3.2495E-02,
     &4.8647E+00,3.7820E+00,2.6806E+00,1.4906E+00,3.4441E-02,
     &5.1076E+00,3.9577E+00,2.7989E+00,1.5529E+00,3.6349E-02,
     &5.3767E+00,4.1547E+00,2.9316E+00,1.6226E+00,3.8200E-02,
     &5.6763E+00,4.3747E+00,3.0789E+00,1.7012E+00,3.9814E-02/
      DATA ((KB(JS,JT,23, 4),JS=1,5),JT=1,5) /
     &3.5795E+00,2.8211E+00,2.0153E+00,1.1263E+00,2.7571E-02,
     &3.7577E+00,2.9513E+00,2.1035E+00,1.1732E+00,2.9222E-02,
     &3.9530E+00,3.0936E+00,2.2016E+00,1.2254E+00,3.0874E-02,
     &4.1701E+00,3.2524E+00,2.3097E+00,1.2838E+00,3.2339E-02,
     &4.4121E+00,3.4311E+00,2.4318E+00,1.3490E+00,3.3498E-02/
      DATA ((KB(JS,JT,24, 4),JS=1,5),JT=1,5) /
     &2.7499E+00,2.1929E+00,1.5716E+00,8.8208E-01,2.3328E-02,
     &2.8912E+00,2.2961E+00,1.6422E+00,9.2052E-01,2.4747E-02,
     &3.0489E+00,2.4127E+00,1.7231E+00,9.6426E-01,2.6067E-02,
     &3.2231E+00,2.5412E+00,1.8120E+00,1.0128E+00,2.7124E-02,
     &3.4149E+00,2.6844E+00,1.9115E+00,1.0663E+00,2.7906E-02/
      DATA ((KB(JS,JT,25, 4),JS=1,5),JT=1,5) /
     &2.1432E+00,1.7277E+00,1.2393E+00,6.9912E-01,1.9707E-02,
     &2.2580E+00,1.8124E+00,1.2983E+00,7.3186E-01,2.0862E-02,
     &2.3862E+00,1.9090E+00,1.3657E+00,7.6856E-01,2.1834E-02,
     &2.5268E+00,2.0149E+00,1.4403E+00,8.0968E-01,2.2567E-02,
     &2.6782E+00,2.1290E+00,1.5196E+00,8.5344E-01,2.3120E-02/
      DATA ((KB(JS,JT,26, 4),JS=1,5),JT=1,5) /
     &1.7021E+00,1.3844E+00,9.9410E-01,5.6358E-01,1.6610E-02,
     &1.7967E+00,1.4558E+00,1.0446E+00,5.9163E-01,1.7478E-02,
     &1.9029E+00,1.5366E+00,1.1015E+00,6.2314E-01,1.8168E-02,
     &2.0167E+00,1.6240E+00,1.1633E+00,6.5758E-01,1.8695E-02,
     &2.1386E+00,1.7169E+00,1.2284E+00,6.9400E-01,1.9096E-02/
      DATA ((KB(JS,JT,27, 4),JS=1,5),JT=1,5) /
     &1.4057E+00,1.1500E+00,8.2663E-01,4.7009E-01,1.3925E-02,
     &1.4879E+00,1.2132E+00,8.7128E-01,4.9476E-01,1.4552E-02,
     &1.5769E+00,1.2821E+00,9.2036E-01,5.2229E-01,1.5059E-02,
     &1.6734E+00,1.3576E+00,9.7388E-01,5.5224E-01,1.5448E-02,
     &1.7761E+00,1.4364E+00,1.0297E+00,5.8351E-01,1.5741E-02/
      DATA ((KB(JS,JT,28, 4),JS=1,5),JT=1,5) /
     &1.1944E+00,9.8092E-01,7.0555E-01,4.0148E-01,1.1607E-02,
     &1.2669E+00,1.0377E+00,7.4577E-01,4.2386E-01,1.2073E-02,
     &1.3434E+00,1.0982E+00,7.8916E-01,4.4819E-01,1.2454E-02,
     &1.4276E+00,1.1642E+00,8.3605E-01,4.7463E-01,1.2747E-02,
     &1.5174E+00,1.2340E+00,8.8572E-01,5.0242E-01,1.2962E-02/
      DATA ((KB(JS,JT,29, 4),JS=1,5),JT=1,5) /
     &1.0796E+00,8.8738E-01,6.3729E-01,3.6140E-01,9.6469E-03,
     &1.1462E+00,9.4012E-01,6.7481E-01,3.8241E-01,1.0006E-02,
     &1.2166E+00,9.9676E-01,7.1549E-01,4.0534E-01,1.0291E-02,
     &1.2950E+00,1.0580E+00,7.5913E-01,4.2989E-01,1.0512E-02,
     &1.3796E+00,1.1246E+00,8.0670E-01,4.5638E-01,1.0678E-02/
      DATA ((KB(JS,JT,30, 4),JS=1,5),JT=1,5) /
     &1.0009E+00,8.2254E-01,5.8934E-01,3.3271E-01,8.0058E-03,
     &1.0631E+00,8.7256E-01,6.2533E-01,3.5305E-01,8.2800E-03,
     &1.1308E+00,9.2710E-01,6.6420E-01,3.7481E-01,8.4963E-03,
     &1.2063E+00,9.8617E-01,7.0646E-01,3.9833E-01,8.6678E-03,
     &1.2872E+00,1.0507E+00,7.5301E-01,4.2433E-01,8.7939E-03/
      DATA ((KB(JS,JT,31, 4),JS=1,5),JT=1,5) /
     &9.7660E-01,8.0084E-01,5.7177E-01,3.2070E-01,6.6382E-03,
     &1.0374E+00,8.5014E-01,6.0734E-01,3.4069E-01,6.8456E-03,
     &1.1075E+00,9.0581E-01,6.4681E-01,3.6261E-01,7.0127E-03,
     &1.1834E+00,9.6644E-01,6.9039E-01,3.8675E-01,7.1469E-03,
     &1.2660E+00,1.0326E+00,7.3825E-01,4.1334E-01,7.2367E-03/
      DATA ((KB(JS,JT,32, 4),JS=1,5),JT=1,5) /
     &9.6422E-01,7.8878E-01,5.6132E-01,3.1280E-01,5.4958E-03,
     &1.0268E+00,8.3964E-01,5.9767E-01,3.3295E-01,5.6574E-03,
     &1.0993E+00,8.9729E-01,6.3870E-01,3.5556E-01,5.7908E-03,
     &1.1769E+00,9.5960E-01,6.8365E-01,3.8056E-01,5.8892E-03,
     &1.2618E+00,1.0283E+00,7.3351E-01,4.0808E-01,5.9563E-03/
      DATA ((KB(JS,JT,33, 4),JS=1,5),JT=1,5) /
     &9.7044E-01,7.9175E-01,5.6148E-01,3.1071E-01,4.5479E-03,
     &1.0377E+00,8.4609E-01,5.9989E-01,3.3169E-01,4.6770E-03,
     &1.1127E+00,9.0612E-01,6.4309E-01,3.5556E-01,4.7785E-03,
     &1.1941E+00,9.7205E-01,6.9062E-01,3.8191E-01,4.8530E-03,
     &1.2827E+00,1.0440E+00,7.4287E-01,4.1072E-01,4.9022E-03/
      DATA ((KB(JS,JT,34, 4),JS=1,5),JT=1,5) /
     &9.5216E-01,7.7596E-01,5.4886E-01,3.0190E-01,3.7602E-03,
     &1.0214E+00,8.3168E-01,5.8836E-01,3.2354E-01,3.8612E-03,
     &1.0976E+00,8.9321E-01,6.3261E-01,3.4797E-01,3.9398E-03,
     &1.1802E+00,9.6059E-01,6.8153E-01,3.7517E-01,3.9961E-03,
     &1.2700E+00,1.0340E+00,7.3462E-01,4.0436E-01,4.0321E-03/
      DATA ((KB(JS,JT,35, 4),JS=1,5),JT=1,5) /
     &9.3109E-01,7.5807E-01,5.3485E-01,2.9258E-01,3.0990E-03,
     &1.0014E+00,8.1463E-01,5.7510E-01,3.1470E-01,3.1794E-03,
     &1.0779E+00,8.7703E-01,6.2017E-01,3.3965E-01,3.2414E-03,
     &1.1611E+00,9.4542E-01,6.6993E-01,3.6723E-01,3.2866E-03,
     &1.2524E+00,1.0199E+00,7.2388E-01,3.9699E-01,3.3190E-03/
      DATA ((KB(JS,JT,36, 4),JS=1,5),JT=1,5) /
     &8.9907E-01,7.3170E-01,5.1516E-01,2.8053E-01,2.5454E-03,
     &9.6904E-01,7.8811E-01,5.5541E-01,3.0260E-01,2.6116E-03,
     &1.0454E+00,8.5074E-01,6.0077E-01,3.2780E-01,2.6639E-03,
     &1.1275E+00,9.1876E-01,6.5041E-01,3.5533E-01,2.7017E-03,
     &1.2188E+00,9.9337E-01,7.0446E-01,3.8526E-01,2.7298E-03/
      DATA ((KB(JS,JT,37, 4),JS=1,5),JT=1,5) /
     &8.3748E-01,6.8208E-01,4.7958E-01,2.6026E-01,2.0819E-03,
     &9.0437E-01,7.3619E-01,5.1822E-01,2.8144E-01,2.1383E-03,
     &9.7724E-01,7.9645E-01,5.6196E-01,3.0574E-01,2.1835E-03,
     &1.0560E+00,8.6198E-01,6.0986E-01,3.3246E-01,2.2167E-03,
     &1.1435E+00,9.3399E-01,6.6218E-01,3.6148E-01,2.2423E-03/
      DATA ((KB(JS,JT,38, 4),JS=1,5),JT=1,5) /
     &7.9164E-01,6.4489E-01,4.5275E-01,2.4481E-01,1.7033E-03,
     &8.5631E-01,6.9735E-01,4.9025E-01,2.6537E-01,1.7520E-03,
     &9.2681E-01,7.5605E-01,5.3294E-01,2.8911E-01,1.7893E-03,
     &1.0032E+00,8.1986E-01,5.7959E-01,3.1521E-01,1.8197E-03,
     &1.0885E+00,8.9047E-01,6.3102E-01,3.4379E-01,1.8432E-03/
      DATA ((KB(JS,JT,39, 4),JS=1,5),JT=1,5) /
     &7.6561E-01,6.2337E-01,4.3685E-01,2.3531E-01,1.3951E-03,
     &8.2959E-01,6.7544E-01,4.7411E-01,2.5572E-01,1.4362E-03,
     &8.9955E-01,7.3386E-01,5.1664E-01,2.7941E-01,1.4681E-03,
     &9.7533E-01,7.9745E-01,5.6319E-01,3.0547E-01,1.4952E-03,
     &1.0606E+00,8.6829E-01,6.1487E-01,3.3424E-01,1.5163E-03/
      DATA ((KB(JS,JT,40, 4),JS=1,5),JT=1,5) /
     &6.9042E-01,5.6314E-01,3.9439E-01,2.1202E-01,1.1367E-03,
     &7.4888E-01,6.1108E-01,4.2878E-01,2.3085E-01,1.1721E-03,
     &8.1362E-01,6.6539E-01,4.6832E-01,2.5287E-01,1.1998E-03,
     &8.8373E-01,7.2479E-01,5.1188E-01,2.7730E-01,1.2242E-03,
     &9.6254E-01,7.9070E-01,5.6015E-01,3.0430E-01,1.2434E-03/
      DATA ((KB(JS,JT,41, 4),JS=1,5),JT=1,5) /
     &6.2032E-01,5.0688E-01,3.5482E-01,1.9040E-01,9.2546E-04,
     &6.7393E-01,5.5118E-01,3.8660E-01,2.0779E-01,9.5549E-04,
     &7.3329E-01,6.0114E-01,4.2302E-01,2.2810E-01,9.8005E-04,
     &7.9788E-01,6.5636E-01,4.6356E-01,2.5084E-01,1.0016E-03,
     &8.7082E-01,7.1789E-01,5.0871E-01,2.7615E-01,1.0188E-03/
      DATA ((KB(JS,JT,42, 4),JS=1,5),JT=1,5) /
     &5.6327E-01,4.6093E-01,3.2241E-01,1.7266E-01,7.5328E-04,
     &6.1295E-01,5.0232E-01,3.5212E-01,1.8890E-01,7.7877E-04,
     &6.6777E-01,5.4861E-01,3.8590E-01,2.0776E-01,8.0043E-04,
     &7.2797E-01,6.0039E-01,4.2397E-01,2.2912E-01,8.1936E-04,
     &7.9621E-01,6.5839E-01,4.6656E-01,2.5303E-01,8.3483E-04/
      DATA ((KB(JS,JT,43, 4),JS=1,5),JT=1,5) /
     &5.1362E-01,4.2068E-01,2.9391E-01,1.5704E-01,6.1131E-04,
     &5.5956E-01,4.5932E-01,3.2171E-01,1.7223E-01,6.3359E-04,
     &6.1053E-01,5.0241E-01,3.5315E-01,1.8977E-01,6.5237E-04,
     &6.6664E-01,5.5084E-01,3.8881E-01,2.0981E-01,6.6921E-04,
     &7.3047E-01,6.0544E-01,4.2894E-01,2.3232E-01,6.8300E-04/
      DATA ((KB(JS,JT,44, 4),JS=1,5),JT=1,5) /
     &4.7369E-01,3.8803E-01,2.7069E-01,1.4426E-01,4.9540E-04,
     &5.1629E-01,4.2426E-01,2.9688E-01,1.5856E-01,5.1475E-04,
     &5.6430E-01,4.6484E-01,3.2640E-01,1.7499E-01,5.3131E-04,
     &6.1717E-01,5.1049E-01,3.6006E-01,1.9393E-01,5.4642E-04,
     &6.7746E-01,5.6241E-01,3.9820E-01,2.1537E-01,5.5870E-04/
      DATA ((KB(JS,JT,45, 4),JS=1,5),JT=1,5) /
     &4.4552E-01,3.6469E-01,2.5398E-01,1.3497E-01,4.0119E-04,
     &4.8593E-01,3.9940E-01,2.7911E-01,1.4871E-01,4.1803E-04,
     &5.3210E-01,4.3837E-01,3.0742E-01,1.6436E-01,4.3281E-04,
     &5.8266E-01,4.8202E-01,3.3961E-01,1.8254E-01,4.4586E-04,
     &6.4061E-01,5.3215E-01,3.7643E-01,2.0327E-01,4.5687E-04/
      DATA ((KB(JS,JT,46, 4),JS=1,5),JT=1,5) /
     &4.2249E-01,3.4536E-01,2.4007E-01,1.2719E-01,3.2444E-04,
     &4.6085E-01,3.7858E-01,2.6416E-01,1.4037E-01,3.3911E-04,
     &5.0558E-01,4.1641E-01,2.9158E-01,1.5550E-01,3.5210E-04,
     &5.5446E-01,4.5852E-01,3.2261E-01,1.7296E-01,3.6323E-04,
     &6.1034E-01,5.0695E-01,3.5817E-01,1.9305E-01,3.7330E-04/
      DATA ((KB(JS,JT,47, 4),JS=1,5),JT=1,5) /
     &3.9554E-01,3.2291E-01,2.2401E-01,1.1833E-01,2.6160E-04,
     &4.3146E-01,3.5412E-01,2.4668E-01,1.3078E-01,2.7433E-04,
     &4.7369E-01,3.9022E-01,2.7284E-01,1.4515E-01,2.8554E-04,
     &5.2055E-01,4.3044E-01,3.0232E-01,1.6167E-01,2.9527E-04,
     &5.7336E-01,4.7635E-01,3.3620E-01,1.8084E-01,3.0428E-04/
      DATA ((KB(JS,JT,48, 4),JS=1,5),JT=1,5) /
     &3.8090E-01,3.1036E-01,2.1482E-01,1.1310E-01,2.1085E-04,
     &4.1533E-01,3.4019E-01,2.3651E-01,1.2501E-01,2.2180E-04,
     &4.5614E-01,3.7537E-01,2.6197E-01,1.3898E-01,2.3143E-04,
     &5.0246E-01,4.1492E-01,2.9081E-01,1.5505E-01,2.3998E-04,
     &5.5365E-01,4.5945E-01,3.2372E-01,1.7366E-01,2.4799E-04/
      DATA ((KB(JS,JT,49, 4),JS=1,5),JT=1,5) /
     &3.8223E-01,3.1052E-01,2.1444E-01,1.1246E-01,1.6987E-04,
     &4.1659E-01,3.4001E-01,2.3576E-01,1.2419E-01,1.7919E-04,
     &4.5734E-01,3.7525E-01,2.6133E-01,1.3821E-01,1.8743E-04,
     &5.0487E-01,4.1574E-01,2.9072E-01,1.5448E-01,1.9508E-04,
     &5.5695E-01,4.6079E-01,3.2385E-01,1.7317E-01,2.0224E-04/
      DATA ((KB(JS,JT,50, 4),JS=1,5),JT=1,5) /
     &3.6631E-01,2.9712E-01,2.0481E-01,1.0712E-01,1.3672E-04,
     &3.9879E-01,3.2486E-01,2.2483E-01,1.1811E-01,1.4458E-04,
     &4.3761E-01,3.5858E-01,2.4934E-01,1.3160E-01,1.5166E-04,
     &4.8398E-01,3.9821E-01,2.7799E-01,1.4737E-01,1.5830E-04,
     &5.3499E-01,4.4212E-01,3.1022E-01,1.6549E-01,1.6465E-04/
      DATA ((KB(JS,JT,51, 4),JS=1,5),JT=1,5) /
     &3.4406E-01,2.7861E-01,1.9179E-01,1.0006E-01,1.0998E-04,
     &3.7372E-01,3.0420E-01,2.1018E-01,1.1015E-01,1.1652E-04,
     &4.0998E-01,3.3570E-01,2.3310E-01,1.2281E-01,1.2263E-04,
     &4.5397E-01,3.7347E-01,2.6041E-01,1.3780E-01,1.2829E-04,
     &5.0293E-01,4.1560E-01,2.9124E-01,1.5503E-01,1.3386E-04/
      DATA ((KB(JS,JT,52, 4),JS=1,5),JT=1,5) /
     &3.3305E-01,2.6887E-01,1.8470E-01,9.6116E-02,8.8414E-05,
     &3.6030E-01,2.9285E-01,2.0201E-01,1.0559E-01,9.3941E-05,
     &3.9501E-01,3.2288E-01,2.2382E-01,1.1765E-01,9.9142E-05,
     &4.3753E-01,3.5954E-01,2.5031E-01,1.3217E-01,1.0404E-04,
     &4.8592E-01,4.0113E-01,2.8062E-01,1.4902E-01,1.0887E-04/
      DATA ((KB(JS,JT,53, 4),JS=1,5),JT=1,5) /
     &3.3673E-01,2.7062E-01,1.8541E-01,9.6126E-02,7.1043E-05,
     &3.6211E-01,2.9355E-01,2.0209E-01,1.0535E-01,7.5715E-05,
     &3.9659E-01,3.2308E-01,2.2347E-01,1.1715E-01,8.0134E-05,
     &4.3895E-01,3.5976E-01,2.5000E-01,1.3170E-01,8.4354E-05,
     &4.8875E-01,4.0230E-01,2.8086E-01,1.4875E-01,8.8431E-05/
      DATA ((KB(JS,JT,54, 4),JS=1,5),JT=1,5) /
     &2.9565E-01,2.3718E-01,1.6225E-01,8.3929E-02,5.7062E-05,
     &3.1566E-01,2.5610E-01,1.7621E-01,9.1726E-02,6.0930E-05,
     &3.4501E-01,2.8145E-01,1.9453E-01,1.0184E-01,6.4630E-05,
     &3.8166E-01,3.1342E-01,2.1772E-01,1.1458E-01,6.8122E-05,
     &4.2580E-01,3.5139E-01,2.4524E-01,1.2978E-01,7.1556E-05/
      DATA ((KB(JS,JT,55, 4),JS=1,5),JT=1,5) /
     &2.3763E-01,1.9054E-01,1.3023E-01,6.7270E-02,4.5734E-05,
     &2.5160E-01,2.0457E-01,1.4076E-01,7.3233E-02,4.8936E-05,
     &2.7408E-01,2.2452E-01,1.5520E-01,8.1193E-02,5.2040E-05,
     &3.0302E-01,2.4999E-01,1.7374E-01,9.1409E-02,5.4914E-05,
     &3.3851E-01,2.8105E-01,1.9629E-01,1.0386E-01,5.7717E-05/
      DATA ((KB(JS,JT,56, 4),JS=1,5),JT=1,5) /
     &1.9160E-01,1.5340E-01,1.0472E-01,5.4007E-02,3.6625E-05,
     &2.0095E-01,1.6357E-01,1.1247E-01,5.8467E-02,3.9320E-05,
     &2.1781E-01,1.7908E-01,1.2379E-01,6.4708E-02,4.1872E-05,
     &2.4047E-01,1.9929E-01,1.3856E-01,7.2864E-02,4.4297E-05,
     &2.6886E-01,2.2463E-01,1.5695E-01,8.3003E-02,4.6496E-05/
      DATA ((KB(JS,JT,57, 4),JS=1,5),JT=1,5) /
     &1.5488E-01,1.2382E-01,8.4407E-02,4.3459E-02,2.9307E-05,
     &1.6082E-01,1.3093E-01,8.9925E-02,4.6681E-02,3.1559E-05,
     &1.7312E-01,1.4284E-01,9.8719E-02,5.1558E-02,3.3681E-05,
     &1.9084E-01,1.5883E-01,1.1043E-01,5.8031E-02,3.5680E-05,
     &2.1336E-01,1.7931E-01,1.2534E-01,6.6236E-02,3.7524E-05/
      DATA ((KB(JS,JT,58, 4),JS=1,5),JT=1,5) /
     &3.3087E-02,3.2322E-02,2.8310E-02,2.0395E-02,2.3455E-05,
     &3.4053E-02,3.3907E-02,2.9921E-02,2.1729E-02,2.5336E-05,
     &3.6376E-02,3.6839E-02,3.2736E-02,2.3935E-02,2.7095E-05,
     &4.0009E-02,4.0914E-02,3.6586E-02,2.6918E-02,2.8737E-05,
     &4.4706E-02,4.6236E-02,4.1585E-02,3.0778E-02,3.0324E-05/
      DATA ((KB(JS,JT,59, 4),JS=1,5),JT=1,5) /
     &3.1774E-02,2.9779E-02,2.4302E-02,1.5595E-02,1.9010E-05,
     &3.2644E-02,3.1267E-02,2.5718E-02,1.6636E-02,2.0536E-05,
     &3.4800E-02,3.4041E-02,2.8207E-02,1.8368E-02,2.1957E-05,
     &3.8295E-02,3.7946E-02,3.1647E-02,2.0746E-02,2.3288E-05,
     &4.2857E-02,4.3069E-02,3.6135E-02,2.3842E-02,2.4528E-05/
      DATA ((KB(JS,JT,13, 5),JS=1,5),JT=1,5) /
     &3.9549E+02,2.9672E+02,1.9794E+02,9.9160E+01,2.1101E-01,
     &4.0510E+02,3.0393E+02,2.0275E+02,1.0157E+02,2.1805E-01,
     &4.1502E+02,3.1136E+02,2.0770E+02,1.0405E+02,2.2406E-01,
     &4.2481E+02,3.1871E+02,2.1261E+02,1.0651E+02,2.2934E-01,
     &4.3504E+02,3.2638E+02,2.1772E+02,1.0907E+02,2.3453E-01/
      DATA ((KB(JS,JT,14, 5),JS=1,5),JT=1,5) /
     &2.0979E+02,1.5743E+02,1.0508E+02,5.2736E+01,1.8842E-01,
     &2.1502E+02,1.6136E+02,1.0770E+02,5.4046E+01,1.9486E-01,
     &2.2030E+02,1.6532E+02,1.1034E+02,5.5365E+01,2.0050E-01,
     &2.2600E+02,1.6960E+02,1.1320E+02,5.6802E+01,2.0562E-01,
     &2.3272E+02,1.7464E+02,1.1657E+02,5.8488E+01,2.1024E-01/
      DATA ((KB(JS,JT,15, 5),JS=1,5),JT=1,5) /
     &1.1299E+02,8.4842E+01,5.6692E+01,2.8544E+01,1.6706E-01,
     &1.1594E+02,8.7050E+01,5.8163E+01,2.9281E+01,1.7285E-01,
     &1.1912E+02,8.9439E+01,5.9757E+01,3.0081E+01,1.7816E-01,
     &1.2274E+02,9.2159E+01,6.1575E+01,3.0997E+01,1.8306E-01,
     &1.2711E+02,9.5434E+01,6.3760E+01,3.2089E+01,1.8793E-01/
      DATA ((KB(JS,JT,16, 5),JS=1,5),JT=1,5) /
     &7.2342E+01,5.4353E+01,3.6365E+01,1.8388E+01,1.4721E-01,
     &7.4310E+01,5.5827E+01,3.7348E+01,1.8883E+01,1.5241E-01,
     &7.6651E+01,5.7588E+01,3.8528E+01,1.9478E+01,1.5739E-01,
     &7.9417E+01,5.9665E+01,3.9914E+01,2.0174E+01,1.6237E-01,
     &8.2509E+01,6.1984E+01,4.1462E+01,2.0947E+01,1.6729E-01/
      DATA ((KB(JS,JT,17, 5),JS=1,5),JT=1,5) /
     &4.7912E+01,3.6032E+01,2.4156E+01,1.2312E+01,1.2867E-01,
     &4.9396E+01,3.7145E+01,2.4898E+01,1.2683E+01,1.3345E-01,
     &5.1211E+01,3.8509E+01,2.5812E+01,1.3139E+01,1.3833E-01,
     &5.3243E+01,4.0036E+01,2.6830E+01,1.3649E+01,1.4345E-01,
     &5.5359E+01,4.1621E+01,2.7887E+01,1.4174E+01,1.4839E-01/
      DATA ((KB(JS,JT,18, 5),JS=1,5),JT=1,5) /
     &3.2517E+01,2.4486E+01,1.6464E+01,8.5255E+00,1.1175E-01,
     &3.3702E+01,2.5376E+01,1.7056E+01,8.8105E+00,1.1647E-01,
     &3.5055E+01,2.6392E+01,1.7736E+01,9.1463E+00,1.2136E-01,
     &3.6466E+01,2.7452E+01,1.8446E+01,9.5008E+00,1.2627E-01,
     &3.7955E+01,2.8569E+01,1.9189E+01,9.8619E+00,1.3101E-01/
      DATA ((KB(JS,JT,19, 5),JS=1,5),JT=1,5) /
     &2.1727E+01,1.6393E+01,1.1086E+01,5.8761E+00,9.6819E-02,
     &2.2617E+01,1.7062E+01,1.1530E+01,6.0896E+00,1.0144E-01,
     &2.3543E+01,1.7760E+01,1.1998E+01,6.3260E+00,1.0605E-01,
     &2.4512E+01,1.8488E+01,1.2483E+01,6.5653E+00,1.1055E-01,
     &2.5548E+01,1.9265E+01,1.2998E+01,6.8170E+00,1.1478E-01/
      DATA ((KB(JS,JT,20, 5),JS=1,5),JT=1,5) /
     &1.5756E+01,1.1916E+01,8.1383E+00,4.3914E+00,8.3853E-02,
     &1.6431E+01,1.2425E+01,8.4724E+00,4.5624E+00,8.8103E-02,
     &1.7121E+01,1.2945E+01,8.8179E+00,4.7428E+00,9.2252E-02,
     &1.7848E+01,1.3492E+01,9.1779E+00,4.9264E+00,9.6228E-02,
     &1.8606E+01,1.4060E+01,9.5528E+00,5.1134E+00,9.9993E-02/
      DATA ((KB(JS,JT,21, 5),JS=1,5),JT=1,5) /
     &1.1787E+01,8.9459E+00,6.1836E+00,3.3861E+00,7.2353E-02,
     &1.2303E+01,9.3354E+00,6.4401E+00,3.5254E+00,7.6084E-02,
     &1.2826E+01,9.7292E+00,6.7034E+00,3.6681E+00,7.9750E-02,
     &1.3367E+01,1.0136E+01,6.9714E+00,3.8111E+00,8.3233E-02,
     &1.3957E+01,1.0578E+01,7.2613E+00,3.9589E+00,8.6478E-02/
      DATA ((KB(JS,JT,22, 5),JS=1,5),JT=1,5) /
     &9.0718E+00,6.9242E+00,4.8361E+00,2.6781E+00,6.2307E-02,
     &9.4616E+00,7.2180E+00,5.0370E+00,2.7912E+00,6.5577E-02,
     &9.8598E+00,7.5169E+00,5.2399E+00,2.9065E+00,6.8755E-02,
     &1.0285E+01,7.8355E+00,5.4531E+00,3.0213E+00,7.1732E-02,
     &1.0774E+01,8.1994E+00,5.6924E+00,3.1454E+00,7.4544E-02/
      DATA ((KB(JS,JT,23, 5),JS=1,5),JT=1,5) /
     &7.0162E+00,5.3998E+00,3.8098E+00,2.1262E+00,5.3397E-02,
     &7.3118E+00,5.6231E+00,3.9665E+00,2.2161E+00,5.6221E-02,
     &7.6257E+00,5.8582E+00,4.1301E+00,2.3090E+00,5.8902E-02,
     &7.9740E+00,6.1181E+00,4.3060E+00,2.4033E+00,6.1507E-02,
     &8.3852E+00,6.4219E+00,4.5083E+00,2.5100E+00,6.3983E-02/
      DATA ((KB(JS,JT,24, 5),JS=1,5),JT=1,5) /
     &5.3945E+00,4.1959E+00,2.9887E+00,1.6764E+00,4.5562E-02,
     &5.6263E+00,4.3723E+00,3.1153E+00,1.7491E+00,4.7953E-02,
     &5.8803E+00,4.5632E+00,3.2505E+00,1.8236E+00,5.0272E-02,
     &6.1740E+00,4.7820E+00,3.4008E+00,1.9048E+00,5.2561E-02,
     &6.5136E+00,5.0303E+00,3.5679E+00,1.9952E+00,5.4580E-02/
      DATA ((KB(JS,JT,25, 5),JS=1,5),JT=1,5) /
     &4.2050E+00,3.3091E+00,2.3724E+00,1.3359E+00,3.8734E-02,
     &4.3935E+00,3.4537E+00,2.4783E+00,1.3955E+00,4.0785E-02,
     &4.6090E+00,3.6169E+00,2.5944E+00,1.4600E+00,4.2817E-02,
     &4.8571E+00,3.8012E+00,2.7227E+00,1.5304E+00,4.4658E-02,
     &5.1379E+00,4.0071E+00,2.8658E+00,1.6091E+00,4.6106E-02/
      DATA ((KB(JS,JT,26, 5),JS=1,5),JT=1,5) /
     &3.3393E+00,2.6590E+00,1.9126E+00,1.0812E+00,3.2872E-02,
     &3.4998E+00,2.7840E+00,2.0042E+00,1.1322E+00,3.4655E-02,
     &3.6839E+00,2.9244E+00,2.1044E+00,1.1892E+00,3.6289E-02,
     &3.8971E+00,3.0834E+00,2.2165E+00,1.2514E+00,3.7614E-02,
     &4.1266E+00,3.2542E+00,2.3379E+00,1.3199E+00,3.8535E-02/
      DATA ((KB(JS,JT,27, 5),JS=1,5),JT=1,5) /
     &2.7587E+00,2.2186E+00,1.5971E+00,9.0467E-01,2.7863E-02,
     &2.9012E+00,2.3317E+00,1.6793E+00,9.5148E-01,2.9310E-02,
     &3.0653E+00,2.4577E+00,1.7694E+00,1.0026E+00,3.0500E-02,
     &3.2491E+00,2.5968E+00,1.8696E+00,1.0593E+00,3.1389E-02,
     &3.4443E+00,2.7432E+00,1.9752E+00,1.1204E+00,3.1994E-02/
      DATA ((KB(JS,JT,28, 5),JS=1,5),JT=1,5) /
     &2.3461E+00,1.9019E+00,1.3684E+00,7.7601E-01,2.3534E-02,
     &2.4760E+00,2.0059E+00,1.4439E+00,8.1944E-01,2.4611E-02,
     &2.6235E+00,2.1209E+00,1.5268E+00,8.6687E-01,2.5434E-02,
     &2.7836E+00,2.2441E+00,1.6160E+00,9.1849E-01,2.6044E-02,
     &2.9562E+00,2.3753E+00,1.7120E+00,9.7389E-01,2.6449E-02/
      DATA ((KB(JS,JT,29, 5),JS=1,5),JT=1,5) /
     &2.1229E+00,1.7281E+00,1.2411E+00,7.0258E-01,1.9767E-02,
     &2.2483E+00,1.8286E+00,1.3142E+00,7.4438E-01,2.0526E-02,
     &2.3867E+00,1.9376E+00,1.3932E+00,7.8990E-01,2.1121E-02,
     &2.5370E+00,2.0544E+00,1.4782E+00,8.3936E-01,2.1540E-02,
     &2.7005E+00,2.1808E+00,1.5709E+00,8.9251E-01,2.1826E-02/
      DATA ((KB(JS,JT,30, 5),JS=1,5),JT=1,5) /
     &1.9731E+00,1.6098E+00,1.1534E+00,6.5097E-01,1.6498E-02,
     &2.0958E+00,1.7088E+00,1.2257E+00,6.9208E-01,1.7054E-02,
     &2.2285E+00,1.8139E+00,1.3022E+00,7.3642E-01,1.7482E-02,
     &2.3729E+00,1.9280E+00,1.3861E+00,7.8518E-01,1.7790E-02,
     &2.5353E+00,2.0546E+00,1.4785E+00,8.3767E-01,1.7989E-02/
      DATA ((KB(JS,JT,31, 5),JS=1,5),JT=1,5) /
     &1.9340E+00,1.5772E+00,1.1264E+00,6.3182E-01,1.3731E-02,
     &2.0574E+00,1.6773E+00,1.1995E+00,6.7358E-01,1.4152E-02,
     &2.1914E+00,1.7848E+00,1.2781E+00,7.1915E-01,1.4466E-02,
     &2.3406E+00,1.9025E+00,1.3648E+00,7.6925E-01,1.4687E-02,
     &2.5107E+00,2.0354E+00,1.4612E+00,8.2397E-01,1.4843E-02/
      DATA ((KB(JS,JT,32, 5),JS=1,5),JT=1,5) /
     &1.9204E+00,1.5654E+00,1.1148E+00,6.2147E-01,1.1411E-02,
     &2.0455E+00,1.6672E+00,1.1895E+00,6.6431E-01,1.1723E-02,
     &2.1839E+00,1.7785E+00,1.2711E+00,7.1180E-01,1.1953E-02,
     &2.3424E+00,1.9038E+00,1.3629E+00,7.6419E-01,1.2125E-02,
     &2.5216E+00,2.0435E+00,1.4643E+00,8.2232E-01,1.2240E-02/
      DATA ((KB(JS,JT,33, 5),JS=1,5),JT=1,5) /
     &1.9423E+00,1.5823E+00,1.1236E+00,6.2280E-01,9.4667E-03,
     &2.0728E+00,1.6884E+00,1.2018E+00,6.6778E-01,9.6991E-03,
     &2.2222E+00,1.8079E+00,1.2892E+00,7.1818E-01,9.8807E-03,
     &2.3928E+00,1.9430E+00,1.3880E+00,7.7444E-01,1.0013E-02,
     &2.5873E+00,2.0935E+00,1.4975E+00,8.3717E-01,1.0093E-02/
      DATA ((KB(JS,JT,34, 5),JS=1,5),JT=1,5) /
     &1.9127E+00,1.5588E+00,1.1053E+00,6.1048E-01,7.8309E-03,
     &2.0473E+00,1.6687E+00,1.1862E+00,6.5698E-01,8.0168E-03,
     &2.2050E+00,1.7947E+00,1.2785E+00,7.0977E-01,8.1571E-03,
     &2.3844E+00,1.9366E+00,1.3818E+00,7.6872E-01,8.2588E-03,
     &2.5878E+00,2.0945E+00,1.4977E+00,8.3524E-01,8.3102E-03/
      DATA ((KB(JS,JT,35, 5),JS=1,5),JT=1,5) /
     &1.8762E+00,1.5298E+00,1.0833E+00,5.9624E-01,6.4645E-03,
     &2.0161E+00,1.6440E+00,1.1673E+00,6.4448E-01,6.6144E-03,
     &2.1796E+00,1.7750E+00,1.2632E+00,6.9909E-01,6.7276E-03,
     &2.3668E+00,1.9227E+00,1.3710E+00,7.6090E-01,6.8022E-03,
     &2.5757E+00,2.0863E+00,1.4915E+00,8.3029E-01,6.8468E-03/
      DATA ((KB(JS,JT,36, 5),JS=1,5),JT=1,5) /
     &1.8177E+00,1.4833E+00,1.0492E+00,5.7567E-01,5.3254E-03,
     &1.9605E+00,1.6001E+00,1.1349E+00,6.2477E-01,5.4464E-03,
     &2.1269E+00,1.7343E+00,1.2332E+00,6.8062E-01,5.5407E-03,
     &2.3182E+00,1.8849E+00,1.3435E+00,7.4416E-01,5.6019E-03,
     &2.5291E+00,2.0513E+00,1.4663E+00,8.1509E-01,5.6408E-03/
      DATA ((KB(JS,JT,37, 5),JS=1,5),JT=1,5) /
     &1.6997E+00,1.3894E+00,9.8190E-01,5.3748E-01,4.3666E-03,
     &1.8378E+00,1.5030E+00,1.0654E+00,5.8540E-01,4.4691E-03,
     &1.9994E+00,1.6341E+00,1.1617E+00,6.4019E-01,4.5481E-03,
     &2.1860E+00,1.7826E+00,1.2707E+00,7.0283E-01,4.6056E-03,
     &2.3914E+00,1.9456E+00,1.3911E+00,7.7270E-01,4.6416E-03/
      DATA ((KB(JS,JT,38, 5),JS=1,5),JT=1,5) /
     &1.6123E+00,1.3193E+00,9.3139E-01,5.0849E-01,3.5784E-03,
     &1.7479E+00,1.4316E+00,1.0139E+00,5.5580E-01,3.6670E-03,
     &1.9074E+00,1.5615E+00,1.1092E+00,6.1015E-01,3.7371E-03,
     &2.0911E+00,1.7089E+00,1.2176E+00,6.7256E-01,3.7869E-03,
     &2.2948E+00,1.8712E+00,1.3379E+00,7.4236E-01,3.8180E-03/
      DATA ((KB(JS,JT,39, 5),JS=1,5),JT=1,5) /
     &1.5653E+00,1.2809E+00,9.0306E-01,4.9152E-01,2.9339E-03,
     &1.7011E+00,1.3939E+00,9.8605E-01,5.3903E-01,3.0110E-03,
     &1.8625E+00,1.5257E+00,1.0827E+00,5.9416E-01,3.0720E-03,
     &2.0480E+00,1.6749E+00,1.1927E+00,6.5763E-01,3.1176E-03,
     &2.2545E+00,1.8403E+00,1.3150E+00,7.2854E-01,3.1424E-03/
      DATA ((KB(JS,JT,40, 5),JS=1,5),JT=1,5) /
     &1.4161E+00,1.1618E+00,8.1883E-01,4.4506E-01,2.3961E-03,
     &1.5422E+00,1.2675E+00,8.9661E-01,4.8961E-01,2.4634E-03,
     &1.6929E+00,1.3914E+00,9.8762E-01,5.4178E-01,2.5182E-03,
     &1.8671E+00,1.5327E+00,1.0918E+00,6.0196E-01,2.5595E-03,
     &2.0610E+00,1.6900E+00,1.2084E+00,6.6961E-01,2.5831E-03/
      DATA ((KB(JS,JT,41, 5),JS=1,5),JT=1,5) /
     &1.2765E+00,1.0500E+00,7.3977E-01,4.0158E-01,1.9558E-03,
     &1.3934E+00,1.1486E+00,8.1252E-01,4.4320E-01,2.0159E-03,
     &1.5329E+00,1.2644E+00,8.9774E-01,4.9220E-01,2.0644E-03,
     &1.6957E+00,1.3977E+00,9.9605E-01,5.4916E-01,2.0998E-03,
     &1.8778E+00,1.5466E+00,1.1067E+00,6.1346E-01,2.1224E-03/
      DATA ((KB(JS,JT,42, 5),JS=1,5),JT=1,5) /
     &1.1627E+00,9.5841E-01,6.7494E-01,3.6583E-01,1.5975E-03,
     &1.2723E+00,1.0513E+00,7.4339E-01,4.0496E-01,1.6498E-03,
     &1.4029E+00,1.1604E+00,8.2397E-01,4.5136E-01,1.6921E-03,
     &1.5564E+00,1.2873E+00,9.1770E-01,5.0574E-01,1.7229E-03,
     &1.7292E+00,1.4295E+00,1.0235E+00,5.6732E-01,1.7439E-03/
      DATA ((KB(JS,JT,43, 5),JS=1,5),JT=1,5) /
     &1.0630E+00,8.7767E-01,6.1763E-01,3.3410E-01,1.3020E-03,
     &1.1654E+00,9.6474E-01,6.8178E-01,3.7078E-01,1.3472E-03,
     &1.2879E+00,1.0676E+00,7.5775E-01,4.1456E-01,1.3843E-03,
     &1.4323E+00,1.1883E+00,8.4702E-01,4.6628E-01,1.4122E-03,
     &1.5961E+00,1.3241E+00,9.4813E-01,5.2525E-01,1.4316E-03/
      DATA ((KB(JS,JT,44, 5),JS=1,5),JT=1,5) /
     &9.8265E-01,8.1189E-01,5.7078E-01,3.0805E-01,1.0595E-03,
     &1.0790E+00,8.9402E-01,6.3105E-01,3.4248E-01,1.0984E-03,
     &1.1944E+00,9.9169E-01,7.0312E-01,3.8396E-01,1.1318E-03,
     &1.3318E+00,1.1077E+00,7.8899E-01,4.3356E-01,1.1566E-03,
     &1.4887E+00,1.2383E+00,8.8644E-01,4.9053E-01,1.1752E-03/
      DATA ((KB(JS,JT,45, 5),JS=1,5),JT=1,5) /
     &9.2676E-01,7.6543E-01,5.3731E-01,2.8917E-01,8.6207E-04,
     &1.0188E+00,8.4420E-01,5.9503E-01,3.2211E-01,8.9589E-04,
     &1.1295E+00,9.3840E-01,6.6449E-01,3.6207E-01,9.2491E-04,
     &1.2624E+00,1.0512E+00,7.4797E-01,4.1011E-01,9.4724E-04,
     &1.4159E+00,1.1794E+00,8.4359E-01,4.6598E-01,9.6431E-04/
      DATA ((KB(JS,JT,46, 5),JS=1,5),JT=1,5) /
     &8.8115E-01,7.2712E-01,5.0946E-01,2.7333E-01,7.0044E-04,
     &9.6873E-01,8.0252E-01,5.6477E-01,3.0486E-01,7.2940E-04,
     &1.0759E+00,8.9393E-01,6.3210E-01,3.4344E-01,7.5456E-04,
     &1.2051E+00,1.0038E+00,7.1323E-01,3.9017E-01,7.7543E-04,
     &1.3559E+00,1.1306E+00,8.0761E-01,4.4513E-01,7.9123E-04/
      DATA ((KB(JS,JT,47, 5),JS=1,5),JT=1,5) /
     &8.2708E-01,6.8179E-01,4.7670E-01,2.5496E-01,5.6723E-04,
     &9.0841E-01,7.5254E-01,5.2877E-01,2.8459E-01,5.9237E-04,
     &1.0102E+00,8.3938E-01,5.9264E-01,3.2108E-01,6.1461E-04,
     &1.1336E+00,9.4433E-01,6.7005E-01,3.6564E-01,6.3367E-04,
     &1.2789E+00,1.0675E+00,7.6147E-01,4.1873E-01,6.4826E-04/
      DATA ((KB(JS,JT,48, 5),JS=1,5),JT=1,5) /
     &7.9882E-01,6.5670E-01,4.5801E-01,2.4404E-01,4.5910E-04,
     &8.7602E-01,7.2469E-01,5.0814E-01,2.7259E-01,4.8082E-04,
     &9.7485E-01,8.0906E-01,5.6998E-01,3.0783E-01,5.0059E-04,
     &1.0951E+00,9.1136E-01,6.4533E-01,3.5105E-01,5.1769E-04,
     &1.2389E+00,1.0335E+00,7.3563E-01,4.0331E-01,5.3087E-04/
      DATA ((KB(JS,JT,49, 5),JS=1,5),JT=1,5) /
     &8.0402E-01,6.5823E-01,4.5761E-01,2.4276E-01,3.7137E-04,
     &8.8031E-01,7.2577E-01,5.0751E-01,2.7123E-01,3.9017E-04,
     &9.7946E-01,8.1065E-01,5.6941E-01,3.0628E-01,4.0777E-04,
     &1.1011E+00,9.1410E-01,6.4521E-01,3.4961E-01,4.2272E-04,
     &1.2484E+00,1.0389E+00,7.3730E-01,4.0277E-01,4.3479E-04/
      DATA ((KB(JS,JT,50, 5),JS=1,5),JT=1,5) /
     &7.7254E-01,6.3104E-01,4.3765E-01,2.3137E-01,3.0017E-04,
     &8.4478E-01,6.9541E-01,4.8529E-01,2.5862E-01,3.1617E-04,
     &9.3925E-01,7.7679E-01,5.4465E-01,2.9213E-01,3.3160E-04,
     &1.0567E+00,8.7678E-01,6.1788E-01,3.3395E-01,3.4487E-04,
     &1.2008E+00,9.9924E-01,7.0798E-01,3.8577E-01,3.5577E-04/
      DATA ((KB(JS,JT,51, 5),JS=1,5),JT=1,5) /
     &7.2669E-01,5.9284E-01,4.1030E-01,2.1627E-01,2.4246E-04,
     &7.9410E-01,6.5300E-01,4.5497E-01,2.4184E-01,2.5602E-04,
     &8.8167E-01,7.2916E-01,5.1056E-01,2.7327E-01,2.6933E-04,
     &9.9265E-01,8.2410E-01,5.8011E-01,3.1286E-01,2.8099E-04,
     &1.1303E+00,9.4117E-01,6.6603E-01,3.6222E-01,2.9075E-04/
      DATA ((KB(JS,JT,52, 5),JS=1,5),JT=1,5) /
     &7.0293E-01,5.7224E-01,3.9526E-01,2.0761E-01,1.9566E-04,
     &7.6814E-01,6.3021E-01,4.3806E-01,2.3215E-01,2.0717E-04,
     &8.5099E-01,7.0282E-01,4.9133E-01,2.6231E-01,2.1874E-04,
     &9.5857E-01,7.9517E-01,5.5876E-01,3.0061E-01,2.2893E-04,
     &1.0928E+00,9.0923E-01,6.4230E-01,3.4850E-01,2.3751E-04/
      DATA ((KB(JS,JT,53, 5),JS=1,5),JT=1,5) /
     &7.0799E-01,5.7451E-01,3.9589E-01,2.0725E-01,1.5775E-04,
     &7.7421E-01,6.3284E-01,4.3870E-01,2.3160E-01,1.6771E-04,
     &8.5551E-01,7.0456E-01,4.9136E-01,2.6152E-01,1.7761E-04,
     &9.6362E-01,7.9737E-01,5.5891E-01,2.9974E-01,1.8647E-04,
     &1.0993E+00,9.1246E-01,6.4296E-01,3.4771E-01,1.9425E-04/
      DATA ((KB(JS,JT,54, 5),JS=1,5),JT=1,5) /
     &6.1781E-01,5.0174E-01,3.4551E-01,1.8062E-01,1.2698E-04,
     &6.7617E-01,5.5332E-01,3.8324E-01,2.0204E-01,1.3548E-04,
     &7.4609E-01,6.1568E-01,4.2927E-01,2.2831E-01,1.4360E-04,
     &8.3975E-01,6.9703E-01,4.8868E-01,2.6191E-01,1.5134E-04,
     &9.5851E-01,7.9875E-01,5.6310E-01,3.0440E-01,1.5803E-04/
      DATA ((KB(JS,JT,55, 5),JS=1,5),JT=1,5) /
     &4.9218E-01,4.0097E-01,2.7614E-01,1.4430E-01,1.0197E-04,
     &5.3911E-01,4.4293E-01,3.0686E-01,1.6168E-01,1.0930E-04,
     &5.9446E-01,4.9291E-01,3.4401E-01,1.8302E-01,1.1592E-04,
     &6.6816E-01,5.5826E-01,3.9205E-01,2.1030E-01,1.2249E-04,
     &7.6300E-01,6.4076E-01,4.5273E-01,2.4510E-01,1.2815E-04/
      DATA ((KB(JS,JT,56, 5),JS=1,5),JT=1,5) /
     &3.9213E-01,3.2040E-01,2.2062E-01,1.1519E-01,8.1886E-05,
     &4.2970E-01,3.5433E-01,2.4555E-01,1.2928E-01,8.8029E-05,
     &4.7372E-01,3.9458E-01,2.7557E-01,1.4657E-01,9.3592E-05,
     &5.3136E-01,4.4682E-01,3.1425E-01,1.6867E-01,9.8924E-05,
     &6.0680E-01,5.1356E-01,3.6377E-01,1.9714E-01,1.0388E-04/
      DATA ((KB(JS,JT,57, 5),JS=1,5),JT=1,5) /
     &3.1256E-01,2.5603E-01,1.7627E-01,9.1926E-02,6.5686E-05,
     &3.4230E-01,2.8322E-01,1.9630E-01,1.0325E-01,7.0810E-05,
     &3.7748E-01,3.1574E-01,2.2058E-01,1.1723E-01,7.5533E-05,
     &4.2229E-01,3.5725E-01,2.5162E-01,1.3506E-01,7.9907E-05,
     &4.8209E-01,4.1127E-01,2.9188E-01,1.5833E-01,8.4096E-05/
      DATA ((KB(JS,JT,58, 5),JS=1,5),JT=1,5) /
     &6.5834E-02,6.6132E-02,5.8548E-02,4.2734E-02,5.2667E-05,
     &7.1968E-02,7.3109E-02,6.5197E-02,4.8002E-02,5.6984E-05,
     &7.9437E-02,8.1656E-02,7.3428E-02,5.4631E-02,6.0874E-05,
     &8.8662E-02,9.2383E-02,8.3809E-02,6.3035E-02,6.4619E-05,
     &1.0118E-01,1.0653E-01,9.7458E-02,7.4110E-02,6.7988E-05/
      DATA ((KB(JS,JT,59, 5),JS=1,5),JT=1,5) /
     &6.3055E-02,6.1069E-02,5.0451E-02,3.2825E-02,4.2796E-05,
     &6.8995E-02,6.7782E-02,5.6462E-02,3.7059E-02,4.6289E-05,
     &7.6280E-02,7.6111E-02,6.4009E-02,4.2464E-02,4.9459E-05,
     &8.5284E-02,8.6606E-02,7.3583E-02,4.9384E-02,5.2442E-05,
     &9.7585E-02,1.0050E-01,8.6230E-02,5.8574E-02,5.5198E-05/
      DATA ((KB(JS,JT,13, 6),JS=1,5),JT=1,5) /
     &7.7180E+02,5.7896E+02,3.8611E+02,1.9327E+02,3.6289E-01,
     &7.9285E+02,5.9474E+02,3.9664E+02,1.9853E+02,3.7298E-01,
     &8.1518E+02,6.1149E+02,4.0780E+02,2.0411E+02,3.8121E-01,
     &8.3776E+02,6.2842E+02,4.1908E+02,2.0974E+02,3.8734E-01,
     &8.6087E+02,6.4575E+02,4.3063E+02,2.1551E+02,3.9230E-01/
      DATA ((KB(JS,JT,14, 6),JS=1,5),JT=1,5) /
     &4.1395E+02,3.1056E+02,2.0718E+02,1.0380E+02,3.3381E-01,
     &4.2539E+02,3.1915E+02,2.1290E+02,1.0666E+02,3.4169E-01,
     &4.3723E+02,3.2803E+02,2.1882E+02,1.0962E+02,3.4947E-01,
     &4.4927E+02,3.3705E+02,2.2483E+02,1.1261E+02,3.5567E-01,
     &4.6195E+02,3.4656E+02,2.3117E+02,1.1578E+02,3.6065E-01/
      DATA ((KB(JS,JT,15, 6),JS=1,5),JT=1,5) /
     &2.2585E+02,1.6949E+02,1.1313E+02,5.6770E+01,3.0356E-01,
     &2.3201E+02,1.7411E+02,1.1621E+02,5.8311E+01,3.1091E-01,
     &2.3839E+02,1.7889E+02,1.1939E+02,5.9899E+01,3.1810E-01,
     &2.4502E+02,1.8386E+02,1.2270E+02,6.1544E+01,3.2391E-01,
     &2.5289E+02,1.8977E+02,1.2664E+02,6.3520E+01,3.2850E-01/
      DATA ((KB(JS,JT,16, 6),JS=1,5),JT=1,5) /
     &1.4635E+02,1.0986E+02,7.3372E+01,3.6890E+01,2.7344E-01,
     &1.5031E+02,1.1283E+02,7.5356E+01,3.7881E+01,2.8092E-01,
     &1.5444E+02,1.1592E+02,7.7407E+01,3.8900E+01,2.8781E-01,
     &1.5922E+02,1.1951E+02,7.9797E+01,4.0091E+01,2.9332E-01,
     &1.6548E+02,1.2420E+02,8.2930E+01,4.1661E+01,2.9808E-01/
      DATA ((KB(JS,JT,17, 6),JS=1,5),JT=1,5) /
     &9.8142E+01,7.3705E+01,4.9268E+01,2.4840E+01,2.4429E-01,
     &1.0076E+02,7.5668E+01,5.0576E+01,2.5493E+01,2.5184E-01,
     &1.0378E+02,7.7926E+01,5.2073E+01,2.6235E+01,2.5821E-01,
     &1.0768E+02,8.0849E+01,5.4024E+01,2.7211E+01,2.6339E-01,
     &1.1267E+02,8.4599E+01,5.6526E+01,2.8462E+01,2.6841E-01/
      DATA ((KB(JS,JT,18, 6),JS=1,5),JT=1,5) /
     &6.7329E+01,5.0594E+01,3.3862E+01,1.7162E+01,2.1677E-01,
     &6.9224E+01,5.2009E+01,3.4803E+01,1.7627E+01,2.2376E-01,
     &7.1671E+01,5.3842E+01,3.6019E+01,1.8223E+01,2.2981E-01,
     &7.4922E+01,5.6283E+01,3.7648E+01,1.9036E+01,2.3516E-01,
     &7.8609E+01,5.9048E+01,3.9493E+01,1.9956E+01,2.4055E-01/
      DATA ((KB(JS,JT,19, 6),JS=1,5),JT=1,5) /
     &4.5351E+01,3.4111E+01,2.2879E+01,1.1748E+01,1.9068E-01,
     &4.6788E+01,3.5180E+01,2.3587E+01,1.2086E+01,1.9727E-01,
     &4.8819E+01,3.6704E+01,2.4596E+01,1.2571E+01,2.0322E-01,
     &5.1243E+01,3.8523E+01,2.5810E+01,1.3165E+01,2.0895E-01,
     &5.3759E+01,4.0411E+01,2.7071E+01,1.3784E+01,2.1468E-01/
      DATA ((KB(JS,JT,20, 6),JS=1,5),JT=1,5) /
     &3.3050E+01,2.4885E+01,1.6741E+01,8.7700E+00,1.6695E-01,
     &3.4346E+01,2.5850E+01,1.7375E+01,9.0666E+00,1.7321E-01,
     &3.6031E+01,2.7114E+01,1.8213E+01,9.4660E+00,1.7929E-01,
     &3.7866E+01,2.8491E+01,1.9130E+01,9.9045E+00,1.8515E-01,
     &3.9713E+01,2.9876E+01,2.0052E+01,1.0350E+01,1.9066E-01/
      DATA ((KB(JS,JT,21, 6),JS=1,5),JT=1,5) /
     &2.4844E+01,1.8731E+01,1.2673E+01,6.7851E+00,1.4553E-01,
     &2.6012E+01,1.9600E+01,1.3239E+01,7.0557E+00,1.5180E-01,
     &2.7347E+01,2.0602E+01,1.3900E+01,7.3743E+00,1.5767E-01,
     &2.8734E+01,2.1643E+01,1.4586E+01,7.7037E+00,1.6319E-01,
     &3.0137E+01,2.2696E+01,1.5284E+01,8.0405E+00,1.6831E-01/
      DATA ((KB(JS,JT,22, 6),JS=1,5),JT=1,5) /
     &1.9244E+01,1.4532E+01,9.9298E+00,5.4125E+00,1.2703E-01,
     &2.0224E+01,1.5263E+01,1.0402E+01,5.6515E+00,1.3287E-01,
     &2.1278E+01,1.6053E+01,1.0915E+01,5.9058E+00,1.3815E-01,
     &2.2359E+01,1.6864E+01,1.1443E+01,6.1676E+00,1.4315E-01,
     &2.3448E+01,1.7683E+01,1.1980E+01,6.4316E+00,1.4780E-01/
      DATA ((KB(JS,JT,23, 6),JS=1,5),JT=1,5) /
     &1.5003E+01,1.1361E+01,7.8631E+00,4.3544E+00,1.1053E-01,
     &1.5788E+01,1.1946E+01,8.2434E+00,4.5541E+00,1.1564E-01,
     &1.6609E+01,1.2560E+01,8.6387E+00,4.7603E+00,1.2034E-01,
     &1.7444E+01,1.3184E+01,9.0429E+00,4.9691E+00,1.2479E-01,
     &1.8318E+01,1.3840E+01,9.4687E+00,5.1869E+00,1.2894E-01/
      DATA ((KB(JS,JT,24, 6),JS=1,5),JT=1,5) /
     &1.1642E+01,8.8646E+00,6.2180E+00,3.4890E+00,9.5642E-02,
     &1.2250E+01,9.3143E+00,6.5164E+00,3.6525E+00,1.0007E-01,
     &1.2878E+01,9.7800E+00,6.8207E+00,3.8184E+00,1.0423E-01,
     &1.3534E+01,1.0267E+01,7.1387E+00,3.9893E+00,1.0818E-01,
     &1.4255E+01,1.0806E+01,7.4905E+00,4.1737E+00,1.1190E-01/
      DATA ((KB(JS,JT,25, 6),JS=1,5),JT=1,5) /
     &9.1475E+00,7.0241E+00,4.9880E+00,2.8234E+00,8.2353E-02,
     &9.6194E+00,7.3705E+00,5.2236E+00,2.9556E+00,8.6208E-02,
     &1.0118E+01,7.7356E+00,5.4684E+00,3.0922E+00,8.9882E-02,
     &1.0662E+01,8.1371E+00,5.7357E+00,3.2382E+00,9.3407E-02,
     &1.1279E+01,8.5947E+00,6.0377E+00,3.4015E+00,9.6770E-02/
      DATA ((KB(JS,JT,26, 6),JS=1,5),JT=1,5) /
     &7.3112E+00,5.6725E+00,4.0689E+00,2.3123E+00,7.0640E-02,
     &7.6950E+00,5.9535E+00,4.2634E+00,2.4227E+00,7.4010E-02,
     &8.1066E+00,6.2538E+00,4.4719E+00,2.5387E+00,7.7271E-02,
     &8.5794E+00,6.6014E+00,4.7086E+00,2.6686E+00,8.0450E-02,
     &9.1099E+00,6.9909E+00,4.9735E+00,2.8158E+00,8.3380E-02/
      DATA ((KB(JS,JT,27, 6),JS=1,5),JT=1,5) /
     &6.0744E+00,4.7606E+00,3.4368E+00,1.9534E+00,6.0404E-02,
     &6.4010E+00,4.9996E+00,3.6064E+00,2.0495E+00,6.3391E-02,
     &6.7712E+00,5.2713E+00,3.7979E+00,2.1556E+00,6.6293E-02,
     &7.1986E+00,5.5846E+00,4.0153E+00,2.2772E+00,6.9007E-02,
     &7.6755E+00,5.9357E+00,4.2585E+00,2.4127E+00,7.1247E-02/
      DATA ((KB(JS,JT,28, 6),JS=1,5),JT=1,5) /
     &5.1866E+00,4.1033E+00,2.9724E+00,1.6878E+00,5.1571E-02,
     &5.4861E+00,4.3239E+00,3.1305E+00,1.7765E+00,5.4219E-02,
     &5.8320E+00,4.5795E+00,3.3130E+00,1.8782E+00,5.6690E-02,
     &6.2247E+00,4.8686E+00,3.5188E+00,1.9940E+00,5.8750E-02,
     &6.6558E+00,5.1871E+00,3.7446E+00,2.1214E+00,6.0243E-02/
      DATA ((KB(JS,JT,29, 6),JS=1,5),JT=1,5) /
     &4.7142E+00,3.7524E+00,2.7162E+00,1.5365E+00,4.4039E-02,
     &5.0090E+00,3.9723E+00,2.8754E+00,1.6258E+00,4.6277E-02,
     &5.3480E+00,4.2236E+00,3.0565E+00,1.7286E+00,4.8156E-02,
     &5.7292E+00,4.5074E+00,3.2622E+00,1.8442E+00,4.9560E-02,
     &6.1329E+00,4.8058E+00,3.4771E+00,1.9687E+00,5.0487E-02/
      DATA ((KB(JS,JT,30, 6),JS=1,5),JT=1,5) /
     &4.4038E+00,3.5211E+00,2.5447E+00,1.4336E+00,3.7528E-02,
     &4.6996E+00,3.7441E+00,2.7067E+00,1.5257E+00,3.9262E-02,
     &5.0396E+00,3.9983E+00,2.8921E+00,1.6308E+00,4.0573E-02,
     &5.4089E+00,4.2744E+00,3.0942E+00,1.7467E+00,4.1475E-02,
     &5.8026E+00,4.5655E+00,3.3058E+00,1.8693E+00,4.2084E-02/
      DATA ((KB(JS,JT,31, 6),JS=1,5),JT=1,5) /
     &4.3406E+00,3.4756E+00,2.5043E+00,1.4029E+00,3.1837E-02,
     &4.6530E+00,3.7116E+00,2.6766E+00,1.5014E+00,3.3063E-02,
     &5.0025E+00,3.9754E+00,2.8716E+00,1.6130E+00,3.3948E-02,
     &5.3785E+00,4.2562E+00,3.0774E+00,1.7319E+00,3.4570E-02,
     &5.7889E+00,4.5595E+00,3.2989E+00,1.8598E+00,3.4986E-02/
      DATA ((KB(JS,JT,32, 6),JS=1,5),JT=1,5) /
     &4.3396E+00,3.4769E+00,2.4992E+00,1.3933E+00,2.6827E-02,
     &4.6714E+00,3.7286E+00,2.6844E+00,1.4997E+00,2.7685E-02,
     &5.0312E+00,4.0002E+00,2.8855E+00,1.6156E+00,2.8303E-02,
     &5.4256E+00,4.2946E+00,3.1010E+00,1.7399E+00,2.8748E-02,
     &5.8665E+00,4.6212E+00,3.3393E+00,1.8767E+00,2.9064E-02/
      DATA ((KB(JS,JT,33, 6),JS=1,5),JT=1,5) /
     &4.4332E+00,3.5489E+00,2.5452E+00,1.4121E+00,2.2496E-02,
     &4.7823E+00,3.8149E+00,2.7429E+00,1.5266E+00,2.3111E-02,
     &5.1647E+00,4.1029E+00,2.9548E+00,1.6483E+00,2.3573E-02,
     &5.5917E+00,4.4208E+00,3.1884E+00,1.7830E+00,2.3904E-02,
     &6.0743E+00,4.7788E+00,3.4474E+00,1.9321E+00,2.4134E-02/
      DATA ((KB(JS,JT,34, 6),JS=1,5),JT=1,5) /
     &4.4125E+00,3.5356E+00,2.5335E+00,1.4023E+00,1.8787E-02,
     &4.7724E+00,3.8103E+00,2.7374E+00,1.5195E+00,1.9239E-02,
     &5.1721E+00,4.1112E+00,2.9584E+00,1.6475E+00,1.9590E-02,
     &5.6244E+00,4.4492E+00,3.2069E+00,1.7903E+00,1.9843E-02,
     &6.1384E+00,4.8292E+00,3.4834E+00,1.9492E+00,2.0036E-02/
      DATA ((KB(JS,JT,35, 6),JS=1,5),JT=1,5) /
     &4.3717E+00,3.5073E+00,2.5119E+00,1.3871E+00,1.5622E-02,
     &4.7431E+00,3.7911E+00,2.7216E+00,1.5076E+00,1.5975E-02,
     &5.1596E+00,4.1047E+00,2.9535E+00,1.6419E+00,1.6252E-02,
     &5.6365E+00,4.4612E+00,3.2141E+00,1.7918E+00,1.6461E-02,
     &6.1774E+00,4.8609E+00,3.5048E+00,1.9589E+00,1.6599E-02/
      DATA ((KB(JS,JT,36, 6),JS=1,5),JT=1,5) /
     &4.2736E+00,3.4354E+00,2.4585E+00,1.3548E+00,1.2936E-02,
     &4.6496E+00,3.7234E+00,2.6724E+00,1.4783E+00,1.3228E-02,
     &5.0769E+00,4.0460E+00,2.9111E+00,1.6163E+00,1.3462E-02,
     &5.5708E+00,4.4155E+00,3.1813E+00,1.7716E+00,1.3637E-02,
     &6.1338E+00,4.8311E+00,3.4822E+00,1.9445E+00,1.3753E-02/
      DATA ((KB(JS,JT,37, 6),JS=1,5),JT=1,5) /
     &4.0234E+00,3.2473E+00,2.3232E+00,1.2788E+00,1.0671E-02,
     &4.3892E+00,3.5290E+00,2.5324E+00,1.3998E+00,1.0924E-02,
     &4.8090E+00,3.8477E+00,2.7688E+00,1.5370E+00,1.1122E-02,
     &5.2982E+00,4.2143E+00,3.0374E+00,1.6915E+00,1.1275E-02,
     &5.8599E+00,4.6308E+00,3.3399E+00,1.8652E+00,1.1382E-02/
      DATA ((KB(JS,JT,38, 6),JS=1,5),JT=1,5) /
     &3.8405E+00,3.1094E+00,2.2232E+00,1.2223E+00,8.8011E-03,
     &4.2026E+00,3.3894E+00,2.4317E+00,1.3429E+00,9.0204E-03,
     &4.6223E+00,3.7094E+00,2.6688E+00,1.4805E+00,9.1889E-03,
     &5.1135E+00,4.0786E+00,2.9400E+00,1.6366E+00,9.3266E-03,
     &5.6812E+00,4.4997E+00,3.2457E+00,1.8125E+00,9.4327E-03/
      DATA ((KB(JS,JT,39, 6),JS=1,5),JT=1,5) /
     &3.7513E+00,3.0429E+00,2.1735E+00,1.1927E+00,7.2681E-03,
     &4.1185E+00,3.3272E+00,2.3853E+00,1.3156E+00,7.4517E-03,
     &4.5480E+00,3.6554E+00,2.6285E+00,1.4564E+00,7.6013E-03,
     &5.0522E+00,4.0351E+00,2.9074E+00,1.6167E+00,7.7185E-03,
     &5.6411E+00,4.4721E+00,3.2250E+00,1.7992E+00,7.8245E-03/
      DATA ((KB(JS,JT,40, 6),JS=1,5),JT=1,5) /
     &3.4100E+00,2.7806E+00,1.9856E+00,1.0896E+00,5.9768E-03,
     &3.7541E+00,3.0505E+00,2.1868E+00,1.2067E+00,6.1348E-03,
     &4.1600E+00,3.3636E+00,2.4194E+00,1.3415E+00,6.2676E-03,
     &4.6404E+00,3.7278E+00,2.6880E+00,1.4963E+00,6.3713E-03,
     &5.2035E+00,4.1476E+00,2.9948E+00,1.6730E+00,6.4667E-03/
      DATA ((KB(JS,JT,41, 6),JS=1,5),JT=1,5) /
     &3.0891E+00,2.5323E+00,1.8076E+00,9.9199E-01,4.9106E-03,
     &3.4100E+00,2.7866E+00,1.9972E+00,1.1027E+00,5.0459E-03,
     &3.7913E+00,3.0833E+00,2.2185E+00,1.2311E+00,5.1622E-03,
     &4.2439E+00,3.4304E+00,2.4754E+00,1.3795E+00,5.2594E-03,
     &4.7807E+00,3.8337E+00,2.7715E+00,1.5507E+00,5.3436E-03/
      DATA ((KB(JS,JT,42, 6),JS=1,5),JT=1,5) /
     &2.8278E+00,2.3283E+00,1.6611E+00,9.1142E-01,4.0331E-03,
     &3.1295E+00,2.5702E+00,1.8417E+00,1.0169E+00,4.1507E-03,
     &3.4910E+00,2.8544E+00,2.0536E+00,1.1401E+00,4.2525E-03,
     &3.9235E+00,3.1883E+00,2.3016E+00,1.2837E+00,4.3408E-03,
     &4.4380E+00,3.5784E+00,2.5896E+00,1.4506E+00,4.4170E-03/
      DATA ((KB(JS,JT,43, 6),JS=1,5),JT=1,5) /
     &2.5971E+00,2.1460E+00,1.5298E+00,8.3854E-01,3.3049E-03,
     &2.8799E+00,2.3759E+00,1.7013E+00,9.3880E-01,3.4092E-03,
     &3.2202E+00,2.6461E+00,1.9035E+00,1.0566E+00,3.5003E-03,
     &3.6329E+00,2.9678E+00,2.1426E+00,1.1949E+00,3.5773E-03,
     &4.1275E+00,3.3455E+00,2.4216E+00,1.3572E+00,3.6480E-03/
      DATA ((KB(JS,JT,44, 6),JS=1,5),JT=1,5) /
     &2.4109E+00,1.9983E+00,1.4225E+00,7.7812E-01,2.7054E-03,
     &2.6776E+00,2.2170E+00,1.5862E+00,8.7403E-01,2.7971E-03,
     &3.0022E+00,2.4769E+00,1.7806E+00,9.8740E-01,2.8773E-03,
     &3.3965E+00,2.7871E+00,2.0115E+00,1.1213E+00,2.9478E-03,
     &3.8747E+00,3.1555E+00,2.2836E+00,1.2791E+00,3.0101E-03/
      DATA ((KB(JS,JT,45, 6),JS=1,5),JT=1,5) /
     &2.2815E+00,1.8944E+00,1.3464E+00,7.3467E-01,2.2130E-03,
     &2.5401E+00,2.1081E+00,1.5065E+00,8.2816E-01,2.2948E-03,
     &2.8533E+00,2.3602E+00,1.6948E+00,9.3826E-01,2.3656E-03,
     &3.2382E+00,2.6655E+00,1.9218E+00,1.0700E+00,2.4291E-03,
     &3.7076E+00,3.0298E+00,2.1912E+00,1.2259E+00,2.4852E-03/
      DATA ((KB(JS,JT,46, 6),JS=1,5),JT=1,5) /
     &2.1752E+00,1.8075E+00,1.2824E+00,6.9758E-01,1.8083E-03,
     &2.4262E+00,2.0168E+00,1.4391E+00,7.8916E-01,1.8803E-03,
     &2.7306E+00,2.2636E+00,1.6229E+00,8.9649E-01,1.9453E-03,
     &3.1079E+00,2.5651E+00,1.8473E+00,1.0263E+00,2.0023E-03,
     &3.5715E+00,2.9262E+00,2.1144E+00,1.1808E+00,2.0547E-03/
      DATA ((KB(JS,JT,47, 6),JS=1,5),JT=1,5) /
     &2.0439E+00,1.6998E+00,1.2039E+00,6.5284E-01,1.4728E-03,
     &2.2849E+00,1.9026E+00,1.3552E+00,7.4124E-01,1.5378E-03,
     &2.5739E+00,2.1396E+00,1.5317E+00,8.4434E-01,1.5971E-03,
     &2.9355E+00,2.4308E+00,1.7484E+00,9.6939E-01,1.6478E-03,
     &3.3837E+00,2.7824E+00,2.0088E+00,1.1198E+00,1.6945E-03/
      DATA ((KB(JS,JT,48, 6),JS=1,5),JT=1,5) /
     &1.9729E+00,1.6396E+00,1.1585E+00,6.2585E-01,1.1998E-03,
     &2.2114E+00,1.8415E+00,1.3088E+00,7.1328E-01,1.2575E-03,
     &2.4937E+00,2.0747E+00,1.4825E+00,8.1439E-01,1.3096E-03,
     &2.8486E+00,2.3616E+00,1.6960E+00,9.3764E-01,1.3556E-03,
     &3.2936E+00,2.7131E+00,1.9561E+00,1.0874E+00,1.3979E-03/
      DATA ((KB(JS,JT,49, 6),JS=1,5),JT=1,5) /
     &1.9817E+00,1.6421E+00,1.1570E+00,6.2210E-01,9.7602E-04,
     &2.2272E+00,1.8506E+00,1.3118E+00,7.1147E-01,1.0279E-03,
     &2.5150E+00,2.0896E+00,1.4898E+00,8.1454E-01,1.0745E-03,
     &2.8769E+00,2.3813E+00,1.7067E+00,9.3965E-01,1.1160E-03,
     &3.3353E+00,2.7446E+00,1.9747E+00,1.0933E+00,1.1545E-03/
      DATA ((KB(JS,JT,50, 6),JS=1,5),JT=1,5) /
     &1.8978E+00,1.5720E+00,1.1055E+00,5.9245E-01,7.9308E-04,
     &2.1399E+00,1.7779E+00,1.2580E+00,6.8007E-01,8.3888E-04,
     &2.4218E+00,2.0138E+00,1.4333E+00,7.8150E-01,8.7996E-04,
     &2.7742E+00,2.2995E+00,1.6455E+00,9.0381E-01,9.1698E-04,
     &3.2255E+00,2.6590E+00,1.9107E+00,1.0555E+00,9.5164E-04/
      DATA ((KB(JS,JT,51, 6),JS=1,5),JT=1,5) /
     &1.7787E+00,1.4741E+00,1.0351E+00,5.5321E-01,6.4322E-04,
     &2.0121E+00,1.6731E+00,1.1819E+00,6.3736E-01,6.8396E-04,
     &2.2825E+00,1.9012E+00,1.3514E+00,7.3514E-01,7.1977E-04,
     &2.6184E+00,2.1760E+00,1.5550E+00,8.5263E-01,7.5276E-04,
     &3.0526E+00,2.5248E+00,1.8126E+00,9.9966E-01,7.8322E-04/
      DATA ((KB(JS,JT,52, 6),JS=1,5),JT=1,5) /
     &1.7138E+00,1.4190E+00,9.9450E-01,5.2987E-01,5.2154E-04,
     &1.9434E+00,1.6150E+00,1.1387E+00,6.1204E-01,5.5749E-04,
     &2.2115E+00,1.8422E+00,1.3069E+00,7.0863E-01,5.8864E-04,
     &2.5398E+00,2.1125E+00,1.5071E+00,8.2393E-01,6.1775E-04,
     &2.9672E+00,2.4581E+00,1.7623E+00,9.6952E-01,6.4493E-04/
      DATA ((KB(JS,JT,53, 6),JS=1,5),JT=1,5) /
     &1.7198E+00,1.4203E+00,9.9324E-01,5.2715E-01,4.2262E-04,
     &1.9529E+00,1.6185E+00,1.1384E+00,6.0925E-01,4.5399E-04,
     &2.2293E+00,1.8530E+00,1.3116E+00,7.0805E-01,4.8128E-04,
     &2.5636E+00,2.1294E+00,1.5160E+00,8.2535E-01,5.0713E-04,
     &3.0004E+00,2.4827E+00,1.7770E+00,9.7383E-01,5.3111E-04/
      DATA ((KB(JS,JT,54, 6),JS=1,5),JT=1,5) /
     &1.4969E+00,1.2401E+00,8.6613E-01,4.5904E-01,3.4135E-04,
     &1.7004E+00,1.4146E+00,9.9400E-01,5.3139E-01,3.6835E-04,
     &1.9475E+00,1.6269E+00,1.1506E+00,6.2081E-01,3.9232E-04,
     &2.2441E+00,1.8758E+00,1.3350E+00,7.2699E-01,4.1441E-04,
     &2.6322E+00,2.1931E+00,1.5695E+00,8.6094E-01,4.3501E-04/
      DATA ((KB(JS,JT,55, 6),JS=1,5),JT=1,5) /
     &1.1902E+00,9.9203E-01,6.9261E-01,3.6696E-01,2.7539E-04,
     &1.3514E+00,1.1327E+00,7.9579E-01,4.2578E-01,2.9805E-04,
     &1.5528E+00,1.3090E+00,9.2585E-01,5.0048E-01,3.1883E-04,
     &1.7945E+00,1.5161E+00,1.0797E+00,5.8958E-01,3.3758E-04,
     &2.1091E+00,1.7786E+00,1.2743E+00,7.0161E-01,3.5497E-04/
      DATA ((KB(JS,JT,56, 6),JS=1,5),JT=1,5) /
     &9.4564E-01,7.9256E-01,5.5332E-01,2.9317E-01,2.2189E-04,
     &1.0727E+00,9.0556E-01,6.3622E-01,3.4063E-01,2.4090E-04,
     &1.2368E+00,1.0514E+00,7.4402E-01,4.0280E-01,2.5859E-04,
     &1.4335E+00,1.2238E+00,8.7212E-01,4.7748E-01,2.7478E-04,
     &1.6876E+00,1.4404E+00,1.0331E+00,5.7092E-01,2.8964E-04/
      DATA ((KB(JS,JT,57, 6),JS=1,5),JT=1,5) /
     &7.5151E-01,6.3315E-01,4.4196E-01,2.3414E-01,1.7834E-04,
     &8.5091E-01,7.2306E-01,5.0804E-01,2.7214E-01,1.9471E-04,
     &9.8353E-01,8.4281E-01,5.9656E-01,3.2337E-01,2.0961E-04,
     &1.1433E+00,9.8609E-01,7.0325E-01,3.8594E-01,2.2327E-04,
     &1.3484E+00,1.1650E+00,8.3657E-01,4.6393E-01,2.3604E-04/
      DATA ((KB(JS,JT,58, 6),JS=1,5),JT=1,5) /
     &1.5793E-01,1.6356E-01,1.4683E-01,1.0896E-01,1.4326E-04,
     &1.7834E-01,1.8665E-01,1.6872E-01,1.2675E-01,1.5731E-04,
     &2.0650E-01,2.1828E-01,1.9887E-01,1.5129E-01,1.6986E-04,
     &2.4084E-01,2.5688E-01,2.3602E-01,1.8197E-01,1.8127E-04,
     &2.8453E-01,3.0466E-01,2.8209E-01,2.2013E-01,1.9222E-04/
      DATA ((KB(JS,JT,59, 6),JS=1,5),JT=1,5) /
     &1.5159E-01,1.5229E-01,1.2764E-01,8.4631E-02,1.1680E-04,
     &1.7166E-01,1.7481E-01,1.4781E-01,9.9479E-02,1.2840E-04,
     &1.9953E-01,2.0595E-01,1.7587E-01,1.2013E-01,1.3871E-04,
     &2.3377E-01,2.4439E-01,2.1097E-01,1.4631E-01,1.4804E-04,
     &2.7769E-01,2.9243E-01,2.5484E-01,1.7920E-01,1.5678E-04/
      DATA ((KB(JS,JT,13, 7),JS=1,5),JT=1,5) /
     &1.7755E+03,1.3317E+03,8.8796E+02,4.4421E+02,6.5972E-01,
     &1.8279E+03,1.3710E+03,9.1418E+02,4.5731E+02,6.6173E-01,
     &1.8885E+03,1.4165E+03,9.4446E+02,4.7244E+02,6.6577E-01,
     &1.9490E+03,1.4619E+03,9.7472E+02,4.8757E+02,6.7090E-01,
     &2.0075E+03,1.5058E+03,1.0040E+03,5.0220E+02,6.7193E-01/
      DATA ((KB(JS,JT,14, 7),JS=1,5),JT=1,5) /
     &9.7594E+02,7.3206E+02,4.8819E+02,2.4432E+02,6.3121E-01,
     &1.0087E+03,7.5661E+02,5.0455E+02,2.5249E+02,6.3502E-01,
     &1.0415E+03,7.8124E+02,5.2096E+02,2.6069E+02,6.3710E-01,
     &1.0744E+03,8.0589E+02,5.3739E+02,2.6890E+02,6.4004E-01,
     &1.1054E+03,8.2913E+02,5.5288E+02,2.7664E+02,6.4122E-01/
      DATA ((KB(JS,JT,15, 7),JS=1,5),JT=1,5) /
     &5.4478E+02,4.0870E+02,2.7262E+02,1.3654E+02,5.9523E-01,
     &5.6305E+02,4.2240E+02,2.8175E+02,1.4110E+02,6.0003E-01,
     &5.8123E+02,4.3603E+02,2.9083E+02,1.4563E+02,6.0181E-01,
     &5.9882E+02,4.4922E+02,2.9962E+02,1.5002E+02,6.0320E-01,
     &6.1530E+02,4.6158E+02,3.0785E+02,1.5413E+02,6.0492E-01/
      DATA ((KB(JS,JT,16, 7),JS=1,5),JT=1,5) /
     &3.5993E+02,2.7006E+02,1.8020E+02,9.0332E+01,5.5493E-01,
     &3.7215E+02,2.7922E+02,1.8629E+02,9.3372E+01,5.5851E-01,
     &3.8394E+02,2.8806E+02,1.9218E+02,9.6308E+01,5.6035E-01,
     &3.9518E+02,2.9649E+02,1.9779E+02,9.9106E+01,5.6267E-01,
     &4.0564E+02,3.0433E+02,2.0302E+02,1.0171E+02,5.6476E-01/
      DATA ((KB(JS,JT,17, 7),JS=1,5),JT=1,5) /
     &2.4595E+02,1.8458E+02,1.2320E+02,6.1838E+01,5.0905E-01,
     &2.5413E+02,1.9070E+02,1.2728E+02,6.3868E+01,5.1185E-01,
     &2.6187E+02,1.9651E+02,1.3115E+02,6.5795E+01,5.1474E-01,
     &2.6921E+02,2.0201E+02,1.3481E+02,6.7615E+01,5.1865E-01,
     &2.7688E+02,2.0776E+02,1.3865E+02,6.9531E+01,5.2170E-01/
      DATA ((KB(JS,JT,18, 7),JS=1,5),JT=1,5) /
     &1.7164E+02,1.2884E+02,8.6050E+01,4.3266E+01,4.6055E-01,
     &1.7713E+02,1.3296E+02,8.8791E+01,4.4628E+01,4.6405E-01,
     &1.8233E+02,1.3686E+02,9.1384E+01,4.5916E+01,4.6825E-01,
     &1.8765E+02,1.4084E+02,9.4032E+01,4.7229E+01,4.7329E-01,
     &1.9405E+02,1.4564E+02,9.7227E+01,4.8824E+01,4.7705E-01/
      DATA ((KB(JS,JT,19, 7),JS=1,5),JT=1,5) /
     &1.1725E+02,8.8048E+01,5.8853E+01,2.9674E+01,4.1247E-01,
     &1.2086E+02,9.0759E+01,6.0656E+01,3.0566E+01,4.1661E-01,
     &1.2440E+02,9.3403E+01,6.2413E+01,3.1438E+01,4.2213E-01,
     &1.2864E+02,9.6587E+01,6.4532E+01,3.2489E+01,4.2779E-01,
     &1.3396E+02,1.0057E+02,6.7181E+01,3.3807E+01,4.3260E-01/
      DATA ((KB(JS,JT,20, 7),JS=1,5),JT=1,5) /
     &8.6468E+01,6.4964E+01,4.3467E+01,2.2017E+01,3.6582E-01,
     &8.9024E+01,6.6879E+01,4.4738E+01,2.2636E+01,3.7131E-01,
     &9.1943E+01,6.9064E+01,4.6188E+01,2.3347E+01,3.7766E-01,
     &9.5737E+01,7.1906E+01,4.8080E+01,2.4283E+01,3.8413E-01,
     &1.0032E+02,7.5342E+01,5.0362E+01,2.5410E+01,3.9048E-01/
      DATA ((KB(JS,JT,21, 7),JS=1,5),JT=1,5) /
     &6.5580E+01,4.9300E+01,3.3030E+01,1.6896E+01,3.2248E-01,
     &6.7679E+01,5.0870E+01,3.4072E+01,1.7386E+01,3.2902E-01,
     &7.0353E+01,5.2872E+01,3.5398E+01,1.8022E+01,3.3617E-01,
     &7.3710E+01,5.5384E+01,3.7067E+01,1.8833E+01,3.4337E-01,
     &7.7378E+01,5.8129E+01,3.8887E+01,1.9718E+01,3.5091E-01/
      DATA ((KB(JS,JT,22, 7),JS=1,5),JT=1,5) /
     &5.0990E+01,3.8360E+01,2.5747E+01,1.3390E+01,2.8355E-01,
     &5.2937E+01,3.9813E+01,2.6706E+01,1.3827E+01,2.9084E-01,
     &5.5472E+01,4.1712E+01,2.7965E+01,1.4417E+01,2.9863E-01,
     &5.8295E+01,4.3822E+01,2.9362E+01,1.5079E+01,3.0668E-01,
     &6.1215E+01,4.6005E+01,3.0807E+01,1.5766E+01,3.1501E-01/
      DATA ((KB(JS,JT,23, 7),JS=1,5),JT=1,5) /
     &3.9928E+01,3.0064E+01,2.0251E+01,1.0753E+01,2.4875E-01,
     &4.1783E+01,3.1450E+01,2.1160E+01,1.1173E+01,2.5662E-01,
     &4.3954E+01,3.3072E+01,2.2227E+01,1.1670E+01,2.6505E-01,
     &4.6239E+01,3.4779E+01,2.3350E+01,1.2195E+01,2.7351E-01,
     &4.8555E+01,3.6509E+01,2.4489E+01,1.2725E+01,2.8191E-01/
      DATA ((KB(JS,JT,24, 7),JS=1,5),JT=1,5) /
     &3.1198E+01,2.3518E+01,1.5962E+01,8.6666E+00,2.1812E-01,
     &3.2836E+01,2.4742E+01,1.6752E+01,9.0412E+00,2.2642E-01,
     &3.4586E+01,2.6047E+01,1.7597E+01,9.4445E+00,2.3475E-01,
     &3.6388E+01,2.7390E+01,1.8470E+01,9.8567E+00,2.4289E-01,
     &3.8237E+01,2.8772E+01,1.9370E+01,1.0281E+01,2.5096E-01/
      DATA ((KB(JS,JT,25, 7),JS=1,5),JT=1,5) /
     &2.4765E+01,1.8701E+01,1.2839E+01,7.1044E+00,1.9118E-01,
     &2.6117E+01,1.9708E+01,1.3481E+01,7.4248E+00,1.9923E-01,
     &2.7518E+01,2.0749E+01,1.4145E+01,7.7545E+00,2.0704E-01,
     &2.8948E+01,2.1814E+01,1.4825E+01,8.0892E+00,2.1475E-01,
     &3.0459E+01,2.2943E+01,1.5551E+01,8.4409E+00,2.2240E-01/
      DATA ((KB(JS,JT,26, 7),JS=1,5),JT=1,5) /
     &1.9997E+01,1.5145E+01,1.0541E+01,5.9203E+00,1.6734E-01,
     &2.1098E+01,1.5958E+01,1.1060E+01,6.1929E+00,1.7471E-01,
     &2.2238E+01,1.6802E+01,1.1594E+01,6.4727E+00,1.8196E-01,
     &2.3407E+01,1.7668E+01,1.2141E+01,6.7596E+00,1.8921E-01,
     &2.4698E+01,1.8629E+01,1.2749E+01,7.0654E+00,1.9648E-01/
      DATA ((KB(JS,JT,27, 7),JS=1,5),JT=1,5) /
     &1.6756E+01,1.2745E+01,8.9780E+00,5.0906E+00,1.4596E-01,
     &1.7682E+01,1.3422E+01,9.4167E+00,5.3320E+00,1.5263E-01,
     &1.8639E+01,1.4123E+01,9.8653E+00,5.5814E+00,1.5946E-01,
     &1.9672E+01,1.4884E+01,1.0349E+01,5.8433E+00,1.6641E-01,
     &2.0853E+01,1.5759E+01,1.0902E+01,6.1333E+00,1.7345E-01/
      DATA ((KB(JS,JT,28, 7),JS=1,5),JT=1,5) /
     &1.4405E+01,1.1016E+01,7.8395E+00,4.4691E+00,1.2690E-01,
     &1.5206E+01,1.1594E+01,8.2236E+00,4.6907E+00,1.3310E-01,
     &1.6055E+01,1.2210E+01,8.6248E+00,4.9200E+00,1.3960E-01,
     &1.7030E+01,1.2924E+01,9.0823E+00,5.1747E+00,1.4629E-01,
     &1.8152E+01,1.3752E+01,9.6123E+00,5.4653E+00,1.5306E-01/
      DATA ((KB(JS,JT,29, 7),JS=1,5),JT=1,5) /
     &1.3149E+01,1.0099E+01,7.2312E+00,4.1269E+00,1.1016E-01,
     &1.3892E+01,1.0633E+01,7.5916E+00,4.3391E+00,1.1614E-01,
     &1.4735E+01,1.1242E+01,7.9958E+00,4.5718E+00,1.2237E-01,
     &1.5717E+01,1.1957E+01,8.4609E+00,4.8366E+00,1.2878E-01,
     &1.6850E+01,1.2790E+01,8.9991E+00,5.1366E+00,1.3504E-01/
      DATA ((KB(JS,JT,30, 7),JS=1,5),JT=1,5) /
     &1.2314E+01,9.4945E+00,6.8243E+00,3.8903E+00,9.5721E-02,
     &1.3054E+01,1.0024E+01,7.1887E+00,4.1054E+00,1.0142E-01,
     &1.3921E+01,1.0650E+01,7.6093E+00,4.3517E+00,1.0739E-01,
     &1.4944E+01,1.1393E+01,8.1010E+00,4.6344E+00,1.1328E-01,
     &1.6104E+01,1.2245E+01,8.6565E+00,4.9501E+00,1.1877E-01/
      DATA ((KB(JS,JT,31, 7),JS=1,5),JT=1,5) /
     &1.2157E+01,9.3878E+00,6.7548E+00,3.8381E+00,8.3345E-02,
     &1.2955E+01,9.9594E+00,7.1498E+00,4.0728E+00,8.8771E-02,
     &1.3911E+01,1.0649E+01,7.6174E+00,4.3452E+00,9.4250E-02,
     &1.5017E+01,1.1456E+01,8.1532E+00,4.6551E+00,9.9406E-02,
     &1.6266E+01,1.2373E+01,8.7552E+00,5.0004E+00,1.0401E-01/
      DATA ((KB(JS,JT,32, 7),JS=1,5),JT=1,5) /
     &1.2189E+01,9.4190E+00,6.7775E+00,3.8398E+00,7.2780E-02,
     &1.3084E+01,1.0062E+01,7.2229E+00,4.1020E+00,7.7761E-02,
     &1.4139E+01,1.0827E+01,7.7437E+00,4.4056E+00,8.2541E-02,
     &1.5347E+01,1.1710E+01,8.3333E+00,4.7481E+00,8.6905E-02,
     &1.6687E+01,1.2692E+01,8.9809E+00,5.1206E+00,9.0564E-02/
      DATA ((KB(JS,JT,33, 7),JS=1,5),JT=1,5) /
     &1.2504E+01,9.6581E+00,6.9429E+00,3.9220E+00,6.3643E-02,
     &1.3523E+01,1.0393E+01,7.4532E+00,4.2218E+00,6.8037E-02,
     &1.4701E+01,1.1251E+01,8.0374E+00,4.5635E+00,7.2051E-02,
     &1.6035E+01,1.2227E+01,8.6879E+00,4.9410E+00,7.5520E-02,
     &1.7498E+01,1.3301E+01,9.3946E+00,5.3470E+00,7.8343E-02/
      DATA ((KB(JS,JT,34, 7),JS=1,5),JT=1,5) /
     &1.2544E+01,9.6932E+00,6.9709E+00,3.9324E+00,5.5495E-02,
     &1.3652E+01,1.0495E+01,7.5288E+00,4.2613E+00,5.9207E-02,
     &1.4931E+01,1.1428E+01,8.1665E+00,4.6328E+00,6.2449E-02,
     &1.6342E+01,1.2460E+01,8.8567E+00,5.0367E+00,6.5144E-02,
     &1.7926E+01,1.3623E+01,9.6166E+00,5.4694E+00,6.7469E-02/
      DATA ((KB(JS,JT,35, 7),JS=1,5),JT=1,5) /
     &1.2550E+01,9.7037E+00,6.9833E+00,3.9358E+00,4.7960E-02,
     &1.3742E+01,1.0569E+01,7.5854E+00,4.2904E+00,5.1023E-02,
     &1.5093E+01,1.1555E+01,8.2621E+00,4.6878E+00,5.3624E-02,
     &1.6591E+01,1.2650E+01,8.9950E+00,5.1151E+00,5.5900E-02,
     &1.8304E+01,1.3907E+01,9.8148E+00,5.5812E+00,5.7988E-02/
      DATA ((KB(JS,JT,36, 7),JS=1,5),JT=1,5) /
     &1.2397E+01,9.5976E+00,6.9138E+00,3.8949E+00,4.1048E-02,
     &1.3655E+01,1.0513E+01,7.5553E+00,4.2704E+00,4.3574E-02,
     &1.5056E+01,1.1535E+01,8.2577E+00,4.6863E+00,4.5767E-02,
     &1.6621E+01,1.2678E+01,9.0220E+00,5.1309E+00,4.7778E-02,
     &1.8454E+01,1.4024E+01,9.9036E+00,5.6291E+00,4.9683E-02/
      DATA ((KB(JS,JT,37, 7),JS=1,5),JT=1,5) /
     &1.1793E+01,9.1604E+00,6.6146E+00,3.7234E+00,3.4707E-02,
     &1.3041E+01,1.0070E+01,7.2604E+00,4.1046E+00,3.6864E-02,
     &1.4439E+01,1.1088E+01,7.9659E+00,4.5244E+00,3.8795E-02,
     &1.6025E+01,1.2245E+01,8.7442E+00,4.9773E+00,4.0613E-02,
     &1.7882E+01,1.3605E+01,9.6420E+00,5.4880E+00,4.2339E-02/
      DATA ((KB(JS,JT,38, 7),JS=1,5),JT=1,5) /
     &1.1383E+01,8.8666E+00,6.4134E+00,3.6072E+00,2.9298E-02,
     &1.2643E+01,9.7859E+00,7.0699E+00,3.9972E+00,3.1148E-02,
     &1.4056E+01,1.0814E+01,7.7862E+00,4.4229E+00,3.2867E-02,
     &1.5686E+01,1.2002E+01,8.5915E+00,4.8935E+00,3.4517E-02,
     &1.7595E+01,1.3400E+01,9.5179E+00,5.4208E+00,3.6067E-02/
      DATA ((KB(JS,JT,39, 7),JS=1,5),JT=1,5) /
     &1.1254E+01,8.7785E+00,6.3532E+00,3.5698E+00,2.4703E-02,
     &1.2546E+01,9.7238E+00,7.0319E+00,3.9725E+00,2.6328E-02,
     &1.4010E+01,1.0789E+01,7.7764E+00,4.4152E+00,2.7854E-02,
     &1.5714E+01,1.2031E+01,8.6190E+00,4.9070E+00,2.9325E-02,
     &1.7752E+01,1.3525E+01,9.6124E+00,5.4718E+00,3.0788E-02/
      DATA ((KB(JS,JT,40, 7),JS=1,5),JT=1,5) /
     &1.0343E+01,8.1149E+00,5.8880E+00,3.3077E+00,2.0662E-02,
     &1.1581E+01,9.0215E+00,6.5477E+00,3.7008E+00,2.2084E-02,
     &1.2986E+01,1.0044E+01,7.2710E+00,4.1322E+00,2.3431E-02,
     &1.4638E+01,1.1247E+01,8.0993E+00,4.6196E+00,2.4776E-02,
     &1.6625E+01,1.2700E+01,9.0740E+00,5.1787E+00,2.6103E-02/
      DATA ((KB(JS,JT,41, 7),JS=1,5),JT=1,5) /
     &9.4683E+00,7.4757E+00,5.4378E+00,3.0540E+00,1.7243E-02,
     &1.0645E+01,8.3400E+00,6.0743E+00,3.4334E+00,1.8487E-02,
     &1.1996E+01,9.3250E+00,6.7794E+00,3.8546E+00,1.9684E-02,
     &1.3587E+01,1.0480E+01,7.5843E+00,4.3322E+00,2.0909E-02,
     &1.5513E+01,1.1886E+01,8.5396E+00,4.8864E+00,2.2113E-02/
      DATA ((KB(JS,JT,42, 7),JS=1,5),JT=1,5) /
     &8.7596E+00,6.9575E+00,5.0695E+00,2.8442E+00,1.4375E-02,
     &9.8918E+00,7.7921E+00,5.6895E+00,3.2145E+00,1.5469E-02,
     &1.1196E+01,8.7450E+00,6.3808E+00,3.6290E+00,1.6542E-02,
     &1.2750E+01,9.8741E+00,7.1757E+00,4.1018E+00,1.7643E-02,
     &1.4631E+01,1.1244E+01,8.1146E+00,4.6494E+00,1.8736E-02/
      DATA ((KB(JS,JT,43, 7),JS=1,5),JT=1,5) /
     &8.1129E+00,6.4828E+00,4.7282E+00,2.6502E+00,1.1920E-02,
     &9.2040E+00,7.2919E+00,5.3332E+00,3.0110E+00,1.2884E-02,
     &1.0467E+01,8.2176E+00,6.0123E+00,3.4195E+00,1.3839E-02,
     &1.1975E+01,9.3139E+00,6.7911E+00,3.8837E+00,1.4824E-02,
     &1.3821E+01,1.0658E+01,7.7247E+00,4.4294E+00,1.5816E-02/
      DATA ((KB(JS,JT,44, 7),JS=1,5),JT=1,5) /
     &7.5813E+00,6.0889E+00,4.4438E+00,2.4886E+00,9.8504E-03,
     &8.6433E+00,6.8838E+00,5.0388E+00,2.8416E+00,1.0695E-02,
     &9.8815E+00,7.7937E+00,5.7119E+00,3.2452E+00,1.1549E-02,
     &1.1354E+01,8.8664E+00,6.4827E+00,3.7047E+00,1.2430E-02,
     &1.3162E+01,1.0183E+01,7.4060E+00,4.2473E+00,1.3335E-02/
      DATA ((KB(JS,JT,45, 7),JS=1,5),JT=1,5) /
     &7.2186E+00,5.8199E+00,4.2461E+00,2.3747E+00,8.1314E-03,
     &8.2698E+00,6.6114E+00,4.8385E+00,2.7251E+00,8.8750E-03,
     &9.5031E+00,7.5246E+00,5.5174E+00,3.1306E+00,9.6297E-03,
     &1.0974E+01,8.5972E+00,6.2944E+00,3.5936E+00,1.0417E-02,
     &1.2791E+01,9.9194E+00,7.2286E+00,4.1456E+00,1.1234E-02/
      DATA ((KB(JS,JT,46, 7),JS=1,5),JT=1,5) /
     &6.9141E+00,5.5940E+00,4.0776E+00,2.2758E+00,6.6876E-03,
     &7.9503E+00,6.3788E+00,4.6670E+00,2.6226E+00,7.3399E-03,
     &9.1864E+00,7.2991E+00,5.3560E+00,3.0335E+00,8.0038E-03,
     &1.0667E+01,8.3803E+00,6.1440E+00,3.5030E+00,8.7040E-03,
     &1.2488E+01,9.7091E+00,7.0857E+00,4.0595E+00,9.4400E-03/
      DATA ((KB(JS,JT,47, 7),JS=1,5),JT=1,5) /
     &6.5158E+00,5.2952E+00,3.8553E+00,2.1461E+00,5.4578E-03,
     &7.5125E+00,6.0542E+00,4.4282E+00,2.4823E+00,6.0287E-03,
     &8.7277E+00,6.9654E+00,5.1130E+00,2.8905E+00,6.6123E-03,
     &1.0180E+01,8.0330E+00,5.8977E+00,3.3599E+00,7.2304E-03,
     &1.1985E+01,9.3498E+00,6.8393E+00,3.9162E+00,7.8875E-03/
      DATA ((KB(JS,JT,48, 7),JS=1,5),JT=1,5) /
     &6.3104E+00,5.1398E+00,3.7343E+00,2.0712E+00,4.4438E-03,
     &7.2865E+00,5.8865E+00,4.2999E+00,2.4038E+00,4.9412E-03,
     &8.5071E+00,6.8079E+00,4.9920E+00,2.8153E+00,5.4521E-03,
     &9.9728E+00,7.8905E+00,5.7928E+00,3.2942E+00,5.9945E-03,
     &1.1799E+01,9.2259E+00,6.7537E+00,3.8639E+00,6.5748E-03/
      DATA ((KB(JS,JT,49, 7),JS=1,5),JT=1,5) /
     &6.3637E+00,5.1793E+00,3.7516E+00,2.0723E+00,3.6085E-03,
     &7.3474E+00,5.9332E+00,4.3233E+00,2.4087E+00,4.0406E-03,
     &8.6221E+00,6.8978E+00,5.0458E+00,2.8357E+00,4.4876E-03,
     &1.0155E+01,8.0340E+00,5.8866E+00,3.3379E+00,4.9641E-03,
     &1.2071E+01,9.4371E+00,6.8986E+00,3.9361E+00,5.4780E-03/
      DATA ((KB(JS,JT,50, 7),JS=1,5),JT=1,5) /
     &6.1287E+00,4.9982E+00,3.6130E+00,1.9898E+00,2.9263E-03,
     &7.0793E+00,5.7315E+00,4.1690E+00,2.3166E+00,3.3022E-03,
     &8.3385E+00,6.6892E+00,4.8872E+00,2.7388E+00,3.6894E-03,
     &9.8705E+00,7.8310E+00,5.7364E+00,3.2460E+00,4.1061E-03,
     &1.1792E+01,9.2428E+00,6.7611E+00,3.8534E+00,4.5631E-03/
      DATA ((KB(JS,JT,51, 7),JS=1,5),JT=1,5) /
     &5.7768E+00,4.7273E+00,3.4121E+00,1.8743E+00,2.3693E-03,
     &6.6763E+00,5.4272E+00,3.9426E+00,2.1849E+00,2.6931E-03,
     &7.8931E+00,6.3576E+00,4.6398E+00,2.5939E+00,3.0298E-03,
     &9.3905E+00,7.4818E+00,5.4825E+00,3.0966E+00,3.3909E-03,
     &1.1270E+01,8.8663E+00,6.4953E+00,3.6986E+00,3.7911E-03/
      DATA ((KB(JS,JT,52, 7),JS=1,5),JT=1,5) /
     &5.5982E+00,4.5875E+00,3.3045E+00,1.8093E+00,1.9133E-03,
     &6.4669E+00,5.2676E+00,3.8189E+00,2.1105E+00,2.1929E-03,
     &7.6692E+00,6.1904E+00,4.5114E+00,2.5133E+00,2.4833E-03,
     &9.1760E+00,7.3261E+00,5.3623E+00,3.0203E+00,2.7953E-03,
     &1.1059E+01,8.7181E+00,6.3851E+00,3.6291E+00,3.1452E-03/
      DATA ((KB(JS,JT,53, 7),JS=1,5),JT=1,5) /
     &5.6498E+00,4.6222E+00,3.3203E+00,1.8115E+00,1.5408E-03,
     &6.5197E+00,5.3054E+00,3.8365E+00,2.1129E+00,1.7821E-03,
     &7.7464E+00,6.2478E+00,4.5414E+00,2.5222E+00,2.0319E-03,
     &9.3204E+00,7.4376E+00,5.4308E+00,3.0476E+00,2.3029E-03,
     &1.1294E+01,8.9013E+00,6.5042E+00,3.6848E+00,2.6089E-03/
      DATA ((KB(JS,JT,54, 7),JS=1,5),JT=1,5) /
     &4.9410E+00,4.0701E+00,2.9220E+00,1.5920E+00,1.2393E-03,
     &5.7011E+00,4.6779E+00,3.3818E+00,1.8599E+00,1.4465E-03,
     &6.7851E+00,5.5214E+00,4.0167E+00,2.2288E+00,1.6602E-03,
     &8.2133E+00,6.6133E+00,4.8372E+00,2.7129E+00,1.8918E-03,
     &1.0009E+01,7.9570E+00,5.8358E+00,3.3045E+00,2.1561E-03/
      DATA ((KB(JS,JT,55, 7),JS=1,5),JT=1,5) /
     &3.9448E+00,3.2894E+00,2.3617E+00,1.2863E+00,9.9479E-04,
     &4.5510E+00,3.7868E+00,2.7406E+00,1.5076E+00,1.1698E-03,
     &5.4272E+00,4.4849E+00,3.2681E+00,1.8142E+00,1.3510E-03,
     &6.6050E+00,5.4031E+00,3.9651E+00,2.2259E+00,1.5494E-03,
     &8.0992E+00,6.5420E+00,4.8249E+00,2.7373E+00,1.7731E-03/
      DATA ((KB(JS,JT,56, 7),JS=1,5),JT=1,5) /
     &3.1456E+00,2.6539E+00,1.9051E+00,1.0370E+00,7.9618E-04,
     &3.6287E+00,3.0618E+00,2.2169E+00,1.2199E+00,9.4437E-04,
     &4.3315E+00,3.6363E+00,2.6526E+00,1.4737E+00,1.0978E-03,
     &5.3003E+00,4.4092E+00,3.2425E+00,1.8210E+00,1.2654E-03,
     &6.5412E+00,5.3749E+00,3.9813E+00,2.2622E+00,1.4546E-03/
      DATA ((KB(JS,JT,57, 7),JS=1,5),JT=1,5) /
     &2.5050E+00,2.1372E+00,1.5333E+00,8.3409E-01,6.3524E-04,
     &2.8897E+00,2.4717E+00,1.7900E+00,9.8489E-01,7.5959E-04,
     &3.4502E+00,2.9412E+00,2.1481E+00,1.1943E+00,8.8948E-04,
     &4.2411E+00,3.5892E+00,2.6434E+00,1.4858E+00,1.0311E-03,
     &5.2712E+00,4.4105E+00,3.2776E+00,1.8647E+00,1.1913E-03/
      DATA ((KB(JS,JT,58, 7),JS=1,5),JT=1,5) /
     &5.2639E-01,5.5628E-01,5.1310E-01,3.9091E-01,5.0641E-04,
     &6.0772E-01,6.4553E-01,6.0135E-01,4.6372E-01,6.1035E-04,
     &7.2539E-01,7.7016E-01,7.2403E-01,5.6463E-01,7.2056E-04,
     &8.9558E-01,9.4507E-01,8.9682E-01,7.0739E-01,8.3918E-04,
     &1.1215E+00,1.1728E+00,1.1240E+00,8.9769E-01,9.7498E-04/
      DATA ((KB(JS,JT,59, 7),JS=1,5),JT=1,5) /
     &5.0774E-01,5.2725E-01,4.5400E-01,3.0925E-01,4.1598E-04,
     &5.8906E-01,6.1772E-01,5.3777E-01,3.7151E-01,5.0342E-04,
     &7.0796E-01,7.4490E-01,6.5525E-01,4.5851E-01,5.9609E-04,
     &8.8130E-01,9.2517E-01,8.2251E-01,5.8308E-01,6.9661E-04,
     &1.1130E+00,1.1619E+00,1.0449E+00,7.5118E-01,8.1226E-04/
      DATA ((KB(JS,JT,13, 8),JS=1,5),JT=1,5) /
     &5.5674E+03,4.1757E+03,2.7839E+03,1.3922E+03,1.1827E+00,
     &5.5672E+03,4.1755E+03,2.7838E+03,1.3922E+03,1.1780E+00,
     &5.5974E+03,4.1981E+03,2.7989E+03,1.3997E+03,1.1714E+00,
     &5.6743E+03,4.2558E+03,2.8374E+03,1.4189E+03,1.1612E+00,
     &5.7999E+03,4.3500E+03,2.9002E+03,1.4503E+03,1.1566E+00/
      DATA ((KB(JS,JT,14, 8),JS=1,5),JT=1,5) /
     &3.0072E+03,2.2555E+03,1.5038E+03,7.5211E+02,1.1873E+00,
     &3.0260E+03,2.2696E+03,1.5132E+03,7.5683E+02,1.1778E+00,
     &3.0739E+03,2.3055E+03,1.5371E+03,7.6880E+02,1.1759E+00,
     &3.1534E+03,2.3651E+03,1.5769E+03,7.8868E+02,1.1686E+00,
     &3.2601E+03,2.4451E+03,1.6302E+03,8.1536E+02,1.1588E+00/
      DATA ((KB(JS,JT,15, 8),JS=1,5),JT=1,5) /
     &1.6681E+03,1.2512E+03,8.3428E+02,4.1737E+02,1.1796E+00,
     &1.6959E+03,1.2720E+03,8.4818E+02,4.2432E+02,1.1712E+00,
     &1.7438E+03,1.3080E+03,8.7214E+02,4.3631E+02,1.1630E+00,
     &1.8057E+03,1.3544E+03,9.0311E+02,4.5180E+02,1.1584E+00,
     &1.8729E+03,1.4048E+03,9.3671E+02,4.6860E+02,1.1490E+00/
      DATA ((KB(JS,JT,16, 8),JS=1,5),JT=1,5) /
     &1.1127E+03,8.3463E+02,5.5657E+02,2.7851E+02,1.1544E+00,
     &1.1452E+03,8.5902E+02,5.7284E+02,2.8665E+02,1.1489E+00,
     &1.1859E+03,8.8958E+02,5.9321E+02,2.9685E+02,1.1423E+00,
     &1.2314E+03,9.2370E+02,6.1596E+02,3.0822E+02,1.1380E+00,
     &1.2793E+03,9.5963E+02,6.3991E+02,3.2020E+02,1.1307E+00/
      DATA ((KB(JS,JT,17, 8),JS=1,5),JT=1,5) /
     &7.7661E+02,5.8258E+02,3.8854E+02,1.9450E+02,1.1162E+00,
     &8.0415E+02,6.0323E+02,4.0231E+02,2.0139E+02,1.1130E+00,
     &8.3554E+02,6.2677E+02,4.1801E+02,2.0924E+02,1.1093E+00,
     &8.6787E+02,6.5102E+02,4.3418E+02,2.1733E+02,1.1057E+00,
     &9.0039E+02,6.7541E+02,4.5043E+02,2.2545E+02,1.0994E+00/
      DATA ((KB(JS,JT,18, 8),JS=1,5),JT=1,5) /
     &5.5593E+02,4.1706E+02,2.7819E+02,1.3933E+02,1.0653E+00,
     &5.7731E+02,4.3309E+02,2.8888E+02,1.4467E+02,1.0637E+00,
     &5.9962E+02,4.4983E+02,3.0005E+02,1.5026E+02,1.0625E+00,
     &6.2213E+02,4.6672E+02,3.1130E+02,1.5589E+02,1.0595E+00,
     &6.4470E+02,4.8364E+02,3.2258E+02,1.6152E+02,1.0552E+00/
      DATA ((KB(JS,JT,19, 8),JS=1,5),JT=1,5) /
     &3.9059E+02,2.9306E+02,1.9552E+02,9.7992E+01,1.0025E+00,
     &4.0544E+02,3.0420E+02,2.0295E+02,1.0172E+02,1.0019E+00,
     &4.2056E+02,3.1554E+02,2.1052E+02,1.0550E+02,1.0025E+00,
     &4.3576E+02,3.2693E+02,2.1811E+02,1.0930E+02,1.0012E+00,
     &4.5126E+02,3.3856E+02,2.2586E+02,1.1317E+02,9.9899E-01/
      DATA ((KB(JS,JT,20, 8),JS=1,5),JT=1,5) /
     &2.9617E+02,2.2224E+02,1.4831E+02,7.4392E+01,9.3059E-01,
     &3.0716E+02,2.3049E+02,1.5382E+02,7.7154E+01,9.3219E-01,
     &3.1816E+02,2.3874E+02,1.5932E+02,7.9908E+01,9.3370E-01,
     &3.2952E+02,2.4726E+02,1.6500E+02,8.2741E+01,9.3435E-01,
     &3.4150E+02,2.5625E+02,1.7099E+02,8.5741E+01,9.3474E-01/
      DATA ((KB(JS,JT,21, 8),JS=1,5),JT=1,5) /
     &2.3042E+02,1.7293E+02,1.1544E+02,5.7965E+01,8.5235E-01,
     &2.3880E+02,1.7922E+02,1.1964E+02,6.0070E+01,8.5599E-01,
     &2.4721E+02,1.8553E+02,1.2385E+02,6.2177E+01,8.5938E-01,
     &2.5622E+02,1.9229E+02,1.2835E+02,6.4426E+01,8.6241E-01,
     &2.6653E+02,2.0002E+02,1.3351E+02,6.7009E+01,8.6670E-01/
      DATA ((KB(JS,JT,22, 8),JS=1,5),JT=1,5) /
     &1.8346E+02,1.3771E+02,9.1962E+01,4.6247E+01,7.7175E-01,
     &1.8996E+02,1.4259E+02,9.5222E+01,4.7880E+01,7.7757E-01,
     &1.9685E+02,1.4775E+02,9.8665E+01,4.9599E+01,7.8369E-01,
     &2.0481E+02,1.5373E+02,1.0265E+02,5.1591E+01,7.9052E-01,
     &2.1438E+02,1.6091E+02,1.0745E+02,5.3989E+01,7.9865E-01/
      DATA ((KB(JS,JT,23, 8),JS=1,5),JT=1,5) /
     &1.4619E+02,1.0976E+02,7.3333E+01,3.7009E+01,6.9269E-01,
     &1.5146E+02,1.1371E+02,7.5969E+01,3.8312E+01,7.0058E-01,
     &1.5752E+02,1.1826E+02,7.9004E+01,3.9812E+01,7.0997E-01,
     &1.6498E+02,1.2386E+02,8.2742E+01,4.1669E+01,7.2082E-01,
     &1.7382E+02,1.3049E+02,8.7175E+01,4.3881E+01,7.3247E-01/
      DATA ((KB(JS,JT,24, 8),JS=1,5),JT=1,5) /
     &1.1546E+02,8.6713E+01,5.7975E+01,2.9484E+01,6.1736E-01,
     &1.1997E+02,9.0096E+01,6.0229E+01,3.0574E+01,6.2822E-01,
     &1.2560E+02,9.4324E+01,6.3051E+01,3.1946E+01,6.4118E-01,
     &1.3251E+02,9.9515E+01,6.6517E+01,3.3646E+01,6.5583E-01,
     &1.4039E+02,1.0542E+02,7.0467E+01,3.5600E+01,6.7045E-01/
      DATA ((KB(JS,JT,25, 8),JS=1,5),JT=1,5) /
     &9.2335E+01,6.9366E+01,4.6428E+01,2.3921E+01,5.4857E-01,
     &9.6533E+01,7.2518E+01,4.8524E+01,2.4911E+01,5.6301E-01,
     &1.0186E+02,7.6521E+01,5.1191E+01,2.6188E+01,5.7925E-01,
     &1.0808E+02,8.1193E+01,5.4315E+01,2.7693E+01,5.9615E-01,
     &1.1475E+02,8.6195E+01,5.7652E+01,2.9318E+01,6.1289E-01/
      DATA ((KB(JS,JT,26, 8),JS=1,5),JT=1,5) /
     &7.5309E+01,5.6599E+01,3.7963E+01,1.9911E+01,4.8832E-01,
     &7.9402E+01,5.9672E+01,3.9995E+01,2.0863E+01,5.0531E-01,
     &8.4365E+01,6.3403E+01,4.2472E+01,2.2029E+01,5.2357E-01,
     &8.9751E+01,6.7447E+01,4.5169E+01,2.3307E+01,5.4165E-01,
     &9.5432E+01,7.1708E+01,4.8005E+01,2.4657E+01,5.6018E-01/
      DATA ((KB(JS,JT,27, 8),JS=1,5),JT=1,5) /
     &6.4036E+01,4.8147E+01,3.2405E+01,1.7310E+01,4.3584E-01,
     &6.8098E+01,5.1198E+01,3.4406E+01,1.8250E+01,4.5420E-01,
     &7.2623E+01,5.4602E+01,3.6656E+01,1.9303E+01,4.7326E-01,
     &7.7443E+01,5.8217E+01,3.9050E+01,2.0426E+01,4.9239E-01,
     &8.2321E+01,6.1875E+01,4.1476E+01,2.1557E+01,5.1192E-01/
      DATA ((KB(JS,JT,28, 8),JS=1,5),JT=1,5) /
     &5.6234E+01,4.2299E+01,2.8597E+01,1.5531E+01,3.8958E-01,
     &6.0088E+01,4.5199E+01,3.0486E+01,1.6430E+01,4.0865E-01,
     &6.4206E+01,4.8292E+01,3.2515E+01,1.7385E+01,4.2800E-01,
     &6.8496E+01,5.1510E+01,3.4630E+01,1.8368E+01,4.4785E-01,
     &7.2933E+01,5.4831E+01,3.6814E+01,1.9374E+01,4.6830E-01/
      DATA ((KB(JS,JT,29, 8),JS=1,5),JT=1,5) /
     &5.2522E+01,3.9524E+01,2.6825E+01,1.4721E+01,3.4924E-01,
     &5.6330E+01,4.2387E+01,2.8683E+01,1.5618E+01,3.6822E-01,
     &6.0271E+01,4.5343E+01,3.0606E+01,1.6531E+01,3.8784E-01,
     &6.4389E+01,4.8431E+01,3.2623E+01,1.7468E+01,4.0814E-01,
     &6.8669E+01,5.1633E+01,3.4713E+01,1.8422E+01,4.2953E-01/
      DATA ((KB(JS,JT,30, 8),JS=1,5),JT=1,5) /
     &5.0335E+01,3.7896E+01,2.5810E+01,1.4271E+01,3.1347E-01,
     &5.4100E+01,4.0719E+01,2.7633E+01,1.5165E+01,3.3234E-01,
     &5.7975E+01,4.3625E+01,2.9511E+01,1.6060E+01,3.5217E-01,
     &6.2057E+01,4.6681E+01,3.1490E+01,1.6979E+01,3.7324E-01,
     &6.6429E+01,4.9951E+01,3.3616E+01,1.7947E+01,3.9520E-01/
      DATA ((KB(JS,JT,31, 8),JS=1,5),JT=1,5) /
     &5.0736E+01,3.8204E+01,2.6057E+01,1.4444E+01,2.8199E-01,
     &5.4607E+01,4.1105E+01,2.7922E+01,1.5358E+01,3.0094E-01,
     &5.8681E+01,4.4155E+01,2.9887E+01,1.6295E+01,3.2130E-01,
     &6.3068E+01,4.7436E+01,3.2008E+01,1.7279E+01,3.4300E-01,
     &6.7873E+01,5.1031E+01,3.4344E+01,1.8340E+01,3.6582E-01/
      DATA ((KB(JS,JT,32, 8),JS=1,5),JT=1,5) /
     &5.1816E+01,3.9019E+01,2.6627E+01,1.4770E+01,2.5449E-01,
     &5.5914E+01,4.2088E+01,2.8597E+01,1.5735E+01,2.7379E-01,
     &6.0292E+01,4.5361E+01,3.0700E+01,1.6736E+01,2.9480E-01,
     &6.5110E+01,4.8965E+01,3.3030E+01,1.7812E+01,3.1717E-01,
     &7.0477E+01,5.2981E+01,3.5640E+01,1.8999E+01,3.4101E-01/
      DATA ((KB(JS,JT,33, 8),JS=1,5),JT=1,5) /
     &5.3927E+01,4.0606E+01,2.7695E+01,1.5341E+01,2.3093E-01,
     &5.8395E+01,4.3947E+01,2.9836E+01,1.6383E+01,2.5073E-01,
     &6.3254E+01,4.7578E+01,3.2172E+01,1.7485E+01,2.7229E-01,
     &6.8732E+01,5.1678E+01,3.4827E+01,1.8707E+01,2.9562E-01,
     &7.4993E+01,5.6366E+01,3.7885E+01,2.0105E+01,3.2058E-01/
      DATA ((KB(JS,JT,34, 8),JS=1,5),JT=1,5) /
     &5.4725E+01,4.1207E+01,2.8111E+01,1.5582E+01,2.1030E-01,
     &5.9482E+01,4.4761E+01,3.0384E+01,1.6682E+01,2.3046E-01,
     &6.4816E+01,4.8747E+01,3.2949E+01,1.7887E+01,2.5288E-01,
     &7.0970E+01,5.3352E+01,3.5935E+01,1.9263E+01,2.7720E-01,
     &7.8000E+01,5.8622E+01,3.9384E+01,2.0853E+01,3.0314E-01/
      DATA ((KB(JS,JT,35, 8),JS=1,5),JT=1,5) /
     &5.5341E+01,4.1670E+01,2.8432E+01,1.5766E+01,1.9105E-01,
     &6.0475E+01,4.5504E+01,3.0887E+01,1.6952E+01,2.1167E-01,
     &6.6351E+01,4.9895E+01,3.3711E+01,1.8277E+01,2.3461E-01,
     &7.3222E+01,5.5040E+01,3.7057E+01,1.9828E+01,2.5964E-01,
     &8.0936E+01,6.0824E+01,4.0848E+01,2.1583E+01,2.8629E-01/
      DATA ((KB(JS,JT,36, 8),JS=1,5),JT=1,5) /
     &5.5260E+01,4.1610E+01,2.8415E+01,1.5779E+01,1.7255E-01,
     &6.0687E+01,4.5661E+01,3.1003E+01,1.7034E+01,1.9343E-01,
     &6.7095E+01,5.0451E+01,3.4089E+01,1.8486E+01,2.1666E-01,
     &7.4593E+01,5.6070E+01,3.7750E+01,2.0193E+01,2.4210E-01,
     &8.2912E+01,6.2305E+01,4.1836E+01,2.2093E+01,2.6939E-01/
      DATA ((KB(JS,JT,37, 8),JS=1,5),JT=1,5) /
     &5.3136E+01,4.0024E+01,2.7403E+01,1.5295E+01,1.5374E-01,
     &5.8700E+01,4.4173E+01,3.0048E+01,1.6588E+01,1.7430E-01,
     &6.5370E+01,4.9158E+01,3.3257E+01,1.8110E+01,1.9744E-01,
     &7.3079E+01,5.4934E+01,3.7017E+01,1.9876E+01,2.2299E-01,
     &8.1729E+01,6.1417E+01,4.1258E+01,2.1852E+01,2.5074E-01/
      DATA ((KB(JS,JT,38, 8),JS=1,5),JT=1,5) /
     &5.1889E+01,3.9094E+01,2.6819E+01,1.5017E+01,1.3711E-01,
     &5.7665E+01,4.3397E+01,2.9561E+01,1.6368E+01,1.5734E-01,
     &6.4668E+01,4.8631E+01,3.2933E+01,1.7981E+01,1.8028E-01,
     &7.2785E+01,5.4713E+01,3.6887E+01,1.9846E+01,2.0601E-01,
     &8.1846E+01,6.1504E+01,4.1328E+01,2.1921E+01,2.3415E-01/
      DATA ((KB(JS,JT,39, 8),JS=1,5),JT=1,5) /
     &5.1946E+01,3.9141E+01,2.6874E+01,1.5056E+01,1.2254E-01,
     &5.8115E+01,4.3735E+01,2.9803E+01,1.6507E+01,1.4241E-01,
     &6.5638E+01,4.9361E+01,3.3432E+01,1.8252E+01,1.6535E-01,
     &7.4281E+01,5.5835E+01,3.7644E+01,2.0246E+01,1.9114E-01,
     &8.4117E+01,6.3205E+01,4.2465E+01,2.2507E+01,2.1954E-01/
      DATA ((KB(JS,JT,40, 8),JS=1,5),JT=1,5) /
     &4.8372E+01,3.6476E+01,2.5167E+01,1.4200E+01,1.0786E-01,
     &5.4435E+01,4.0985E+01,2.8035E+01,1.5644E+01,1.2713E-01,
     &6.1814E+01,4.6498E+01,3.1582E+01,1.7371E+01,1.4957E-01,
     &7.0455E+01,5.2966E+01,3.5777E+01,1.9373E+01,1.7507E-01,
     &8.0314E+01,6.0352E+01,4.0598E+01,2.1643E+01,2.0339E-01/
      DATA ((KB(JS,JT,41, 8),JS=1,5),JT=1,5) /
     &4.4863E+01,3.3865E+01,2.3494E+01,1.3347E+01,9.4622E-02,
     &5.0838E+01,3.8301E+01,2.6314E+01,1.4793E+01,1.1320E-01,
     &5.8061E+01,4.3692E+01,2.9774E+01,1.6500E+01,1.3504E-01,
     &6.6603E+01,5.0081E+01,3.3908E+01,1.8494E+01,1.6019E-01,
     &7.6448E+01,5.7454E+01,3.8706E+01,2.0765E+01,1.8828E-01/
      DATA ((KB(JS,JT,42, 8),JS=1,5),JT=1,5) /
     &4.2143E+01,3.1846E+01,2.2204E+01,1.2680E+01,8.2928E-02,
     &4.7973E+01,3.6167E+01,2.4953E+01,1.4117E+01,1.0072E-01,
     &5.5183E+01,4.1542E+01,2.8395E+01,1.5835E+01,1.2195E-01,
     &6.3709E+01,4.7914E+01,3.2510E+01,1.7836E+01,1.4663E-01,
     &7.3621E+01,5.5334E+01,3.7330E+01,2.0134E+01,1.7447E-01/
      DATA ((KB(JS,JT,43, 8),JS=1,5),JT=1,5) /
     &3.9594E+01,2.9962E+01,2.1003E+01,1.2048E+01,7.1693E-02,
     &4.5330E+01,3.4203E+01,2.3706E+01,1.3485E+01,8.8502E-02,
     &5.2493E+01,3.9537E+01,2.7118E+01,1.5213E+01,1.0887E-01,
     &6.1012E+01,4.5896E+01,3.1221E+01,1.7230E+01,1.3283E-01,
     &7.1011E+01,5.3379E+01,3.6070E+01,1.9559E+01,1.6011E-01/
      DATA ((KB(JS,JT,44, 8),JS=1,5),JT=1,5) /
     &3.7616E+01,2.8507E+01,2.0078E+01,1.1553E+01,6.1401E-02,
     &4.3274E+01,3.2681E+01,2.2747E+01,1.2992E+01,7.7099E-02,
     &5.0385E+01,3.7971E+01,2.6133E+01,1.4732E+01,9.6479E-02,
     &5.8976E+01,4.4379E+01,3.0259E+01,1.6785E+01,1.1952E-01,
     &6.9172E+01,5.2003E+01,3.5195E+01,1.9170E+01,1.4606E-01/
      DATA ((KB(JS,JT,45, 8),JS=1,5),JT=1,5) /
     &3.6417E+01,2.7634E+01,1.9534E+01,1.1252E+01,5.2391E-02,
     &4.2083E+01,3.1808E+01,2.2209E+01,1.2716E+01,6.6909E-02,
     &4.9318E+01,3.7181E+01,2.5653E+01,1.4499E+01,8.5223E-02,
     &5.8109E+01,4.3735E+01,2.9873E+01,1.6620E+01,1.0731E-01,
     &6.8675E+01,5.1635E+01,3.4984E+01,1.9103E+01,1.3302E-01/
      DATA ((KB(JS,JT,46, 8),JS=1,5),JT=1,5) /
     &3.5397E+01,2.6895E+01,1.9070E+01,1.0989E+01,4.4228E-02,
     &4.1150E+01,3.1127E+01,2.1795E+01,1.2497E+01,5.7487E-02,
     &4.8494E+01,3.6574E+01,2.5287E+01,1.4324E+01,7.4577E-02,
     &5.7598E+01,4.3359E+01,2.9657E+01,1.6535E+01,9.5575E-02,
     &6.8559E+01,5.1549E+01,3.4961E+01,1.9128E+01,1.2028E-01/
      DATA ((KB(JS,JT,47, 8),JS=1,5),JT=1,5) /
     &3.3892E+01,2.5799E+01,1.8369E+01,1.0592E+01,3.6658E-02,
     &3.9558E+01,2.9961E+01,2.1065E+01,1.2104E+01,4.8512E-02,
     &4.6821E+01,3.5338E+01,2.4514E+01,1.3933E+01,6.4199E-02,
     &5.6038E+01,4.2200E+01,2.8934E+01,1.6192E+01,8.3849E-02,
     &6.7239E+01,5.0568E+01,3.4350E+01,1.8859E+01,1.0731E-01/
      DATA ((KB(JS,JT,48, 8),JS=1,5),JT=1,5) /
     &3.3363E+01,2.5430E+01,1.8144E+01,1.0446E+01,3.0177E-02,
     &3.9055E+01,2.9607E+01,2.0861E+01,1.1982E+01,4.0640E-02,
     &4.6430E+01,3.5057E+01,2.4367E+01,1.3859E+01,5.4873E-02,
     &5.5939E+01,4.2134E+01,2.8926E+01,1.6205E+01,7.3130E-02,
     &6.7675E+01,5.0896E+01,3.4598E+01,1.9010E+01,9.5352E-02/
      DATA ((KB(JS,JT,49, 8),JS=1,5),JT=1,5) /
     &3.4087E+01,2.5989E+01,1.8530E+01,1.0628E+01,2.4642E-02,
     &4.0143E+01,3.0436E+01,2.1433E+01,1.2264E+01,3.3771E-02,
     &4.7859E+01,3.6137E+01,2.5106E+01,1.4243E+01,4.6570E-02,
     &5.8042E+01,4.3715E+01,2.9997E+01,1.6759E+01,6.3406E-02,
     &7.0774E+01,5.3220E+01,3.6156E+01,1.9813E+01,8.4317E-02/
      DATA ((KB(JS,JT,50, 8),JS=1,5),JT=1,5) /
     &3.3271E+01,2.5407E+01,1.8155E+01,1.0394E+01,2.0105E-02,
     &3.9337E+01,2.9859E+01,2.1080E+01,1.2062E+01,2.8045E-02,
     &4.7124E+01,3.5606E+01,2.4793E+01,1.4082E+01,3.9522E-02,
     &5.7525E+01,4.3340E+01,2.9788E+01,1.6668E+01,5.4974E-02,
     &7.0694E+01,5.3165E+01,3.6155E+01,1.9842E+01,7.4569E-02/
      DATA ((KB(JS,JT,51, 8),JS=1,5),JT=1,5) /
     &3.1799E+01,2.4339E+01,1.7448E+01,9.9788E+00,1.6322E-02,
     &3.7729E+01,2.8686E+01,2.0331E+01,1.1646E+01,2.3187E-02,
     &4.5428E+01,3.4361E+01,2.4014E+01,1.3675E+01,3.3395E-02,
     &5.5764E+01,4.2036E+01,2.8971E+01,1.6259E+01,4.7474E-02,
     &6.9086E+01,5.1969E+01,3.5405E+01,1.9496E+01,6.5720E-02/
      DATA ((KB(JS,JT,52, 8),JS=1,5),JT=1,5) /
     &3.1125E+01,2.3861E+01,1.7130E+01,9.7762E+00,1.3165E-02,
     &3.7206E+01,2.8320E+01,2.0110E+01,1.1507E+01,1.9020E-02,
     &4.4966E+01,3.4037E+01,2.3832E+01,1.3576E+01,2.8007E-02,
     &5.5475E+01,4.1834E+01,2.8875E+01,1.6222E+01,4.0752E-02,
     &6.9286E+01,5.2127E+01,3.5547E+01,1.9593E+01,5.7616E-02/
      DATA ((KB(JS,JT,53, 8),JS=1,5),JT=1,5) /
     &3.1628E+01,2.4253E+01,1.7391E+01,9.8844E+00,1.0543E-02,
     &3.8058E+01,2.8975E+01,2.0560E+01,1.1731E+01,1.5472E-02,
     &4.6305E+01,3.5054E+01,2.4529E+01,1.3933E+01,2.3276E-02,
     &5.7328E+01,4.3229E+01,2.9824E+01,1.6717E+01,3.4695E-02,
     &7.2228E+01,5.4335E+01,3.7034E+01,2.0360E+01,5.0210E-02/
      DATA ((KB(JS,JT,54, 8),JS=1,5),JT=1,5) /
     &2.7866E+01,2.1495E+01,1.5519E+01,8.8346E+00,8.4580E-03,
     &3.3763E+01,2.5815E+01,1.8473E+01,1.0588E+01,1.2602E-02,
     &4.1361E+01,3.1401E+01,2.2155E+01,1.2668E+01,1.9366E-02,
     &5.1507E+01,3.8906E+01,2.7027E+01,1.5284E+01,2.9589E-02,
     &6.5378E+01,4.9225E+01,3.3718E+01,1.8724E+01,4.3797E-02/
      DATA ((KB(JS,JT,55, 8),JS=1,5),JT=1,5) /
     &2.2404E+01,1.7484E+01,1.2754E+01,7.2917E+00,6.7620E-03,
     &2.7309E+01,2.1069E+01,1.5293E+01,8.8299E+00,1.0220E-02,
     &3.3683E+01,2.5733E+01,1.8431E+01,1.0660E+01,1.6054E-02,
     &4.2194E+01,3.1999E+01,2.2529E+01,1.2931E+01,2.5150E-02,
     &5.4011E+01,4.0754E+01,2.8208E+01,1.5935E+01,3.8077E-02/
      DATA ((KB(JS,JT,56, 8),JS=1,5),JT=1,5) /
     &1.7963E+01,1.4222E+01,1.0460E+01,5.9968E+00,5.3696E-03,
     &2.2011E+01,1.7185E+01,1.2632E+01,7.3359E+00,8.2238E-03,
     &2.7341E+01,2.1070E+01,1.5329E+01,8.9492E+00,1.3200E-02,
     &3.4490E+01,2.6306E+01,1.8809E+01,1.0943E+01,2.1214E-02,
     &4.4535E+01,3.3715E+01,2.3630E+01,1.3559E+01,3.2915E-02/
      DATA ((KB(JS,JT,57, 8),JS=1,5),JT=1,5) /
     &1.4368E+01,1.1564E+01,8.5550E+00,4.9118E+00,4.2402E-03,
     &1.7718E+01,1.4043E+01,1.0433E+01,6.0838E+00,6.5672E-03,
     &2.2119E+01,1.7250E+01,1.2736E+01,7.4914E+00,1.0750E-02,
     &2.8111E+01,2.1614E+01,1.5710E+01,9.2466E+00,1.7729E-02,
     &3.6581E+01,2.7832E+01,1.9800E+01,1.1525E+01,2.8247E-02/
      DATA ((KB(JS,JT,58, 8),JS=1,5),JT=1,5) /
     &3.0334E+00,3.0458E+00,2.9118E+00,2.3449E+00,3.3480E-03,
     &3.7595E+00,3.7165E+00,3.5857E+00,2.9410E+00,5.2345E-03,
     &4.7309E+00,4.5866E+00,4.4204E+00,3.6685E+00,8.7466E-03,
     &6.0543E+00,5.7620E+00,5.4869E+00,4.5723E+00,1.4810E-02,
     &7.9336E+00,7.4372E+00,6.9325E+00,5.7367E+00,2.4215E-02/
      DATA ((KB(JS,JT,59, 8),JS=1,5),JT=1,5) /
     &2.9765E+00,2.9765E+00,2.6845E+00,1.9427E+00,2.8320E-03,
     &3.7193E+00,3.6697E+00,3.3576E+00,2.4792E+00,4.5261E-03,
     &4.7245E+00,4.5542E+00,4.1916E+00,3.1428E+00,7.7669E-03,
     &6.1120E+00,5.7342E+00,5.2520E+00,3.9688E+00,1.3461E-02,
     &8.1086E+00,7.4151E+00,6.6769E+00,5.0327E+00,2.2363E-02/
      DATA ((KB(JS,JT,13, 9),JS=1,5),JT=1,5) /
     &3.9255E+04,2.9441E+04,1.9628E+04,9.8141E+03,2.1650E+00,
     &3.9490E+04,2.9618E+04,1.9745E+04,9.8730E+03,2.1321E+00,
     &3.9631E+04,2.9723E+04,1.9816E+04,9.9081E+03,2.0803E+00,
     &3.9707E+04,2.9781E+04,1.9854E+04,9.9272E+03,2.0587E+00,
     &3.9690E+04,2.9768E+04,1.9845E+04,9.9229E+03,2.0351E+00/
      DATA ((KB(JS,JT,14, 9),JS=1,5),JT=1,5) /
     &2.2391E+04,1.6793E+04,1.1196E+04,5.5981E+03,2.2958E+00,
     &2.2483E+04,1.6862E+04,1.1241E+04,5.6209E+03,2.2646E+00,
     &2.2517E+04,1.6888E+04,1.1259E+04,5.6296E+03,2.2164E+00,
     &2.2511E+04,1.6883E+04,1.1256E+04,5.6281E+03,2.1692E+00,
     &2.2470E+04,1.6853E+04,1.1235E+04,5.6178E+03,2.1488E+00/
      DATA ((KB(JS,JT,15, 9),JS=1,5),JT=1,5) /
     &1.2806E+04,9.6046E+03,6.4033E+03,3.2019E+03,2.4251E+00,
     &1.2828E+04,9.6209E+03,6.4142E+03,3.2073E+03,2.3960E+00,
     &1.2826E+04,9.6195E+03,6.4132E+03,3.2069E+03,2.3588E+00,
     &1.2818E+04,9.6139E+03,6.4095E+03,3.2050E+03,2.3106E+00,
     &1.2808E+04,9.6063E+03,6.4044E+03,3.2025E+03,2.2722E+00/
      DATA ((KB(JS,JT,16, 9),JS=1,5),JT=1,5) /
     &8.5967E+03,6.4476E+03,4.2986E+03,2.1496E+03,2.5476E+00,
     &8.5987E+03,6.4492E+03,4.2996E+03,2.1501E+03,2.5204E+00,
     &8.5999E+03,6.4500E+03,4.3002E+03,2.1504E+03,2.4878E+00,
     &8.6043E+03,6.4534E+03,4.3024E+03,2.1515E+03,2.4397E+00,
     &8.6176E+03,6.4634E+03,4.3091E+03,2.1548E+03,2.4008E+00/
      DATA ((KB(JS,JT,17, 9),JS=1,5),JT=1,5) /
     &5.9284E+03,4.4464E+03,2.9645E+03,1.4825E+03,2.6544E+00,
     &5.9327E+03,4.4497E+03,2.9666E+03,1.4836E+03,2.6300E+00,
     &5.9411E+03,4.4560E+03,2.9708E+03,1.4857E+03,2.5993E+00,
     &5.9634E+03,4.4727E+03,2.9820E+03,1.4912E+03,2.5553E+00,
     &6.0032E+03,4.5025E+03,3.0018E+03,1.5012E+03,2.5167E+00/
      DATA ((KB(JS,JT,18, 9),JS=1,5),JT=1,5) /
     &4.1696E+03,3.1274E+03,2.0851E+03,1.0428E+03,2.7386E+00,
     &4.1796E+03,3.1348E+03,2.0901E+03,1.0453E+03,2.7184E+00,
     &4.2028E+03,3.1522E+03,2.1017E+03,1.0511E+03,2.6888E+00,
     &4.2429E+03,3.1823E+03,2.1217E+03,1.0611E+03,2.6491E+00,
     &4.2973E+03,3.2231E+03,2.1489E+03,1.0747E+03,2.6124E+00/
      DATA ((KB(JS,JT,19, 9),JS=1,5),JT=1,5) /
     &2.8753E+03,2.1566E+03,1.4379E+03,7.1922E+02,2.7969E+00,
     &2.8953E+03,2.1716E+03,1.4479E+03,7.2422E+02,2.7817E+00,
     &2.9302E+03,2.1978E+03,1.4654E+03,7.3295E+02,2.7548E+00,
     &2.9782E+03,2.2338E+03,1.4894E+03,7.4494E+02,2.7189E+00,
     &3.0360E+03,2.2771E+03,1.5183E+03,7.5939E+02,2.6829E+00/
      DATA ((KB(JS,JT,20, 9),JS=1,5),JT=1,5) /
     &2.1517E+03,1.6139E+03,1.0761E+03,5.3833E+02,2.8251E+00,
     &2.1814E+03,1.6362E+03,1.0910E+03,5.4575E+02,2.8122E+00,
     &2.2241E+03,1.6682E+03,1.1123E+03,5.5643E+02,2.7893E+00,
     &2.2758E+03,1.7069E+03,1.1381E+03,5.6933E+02,2.7572E+00,
     &2.3338E+03,1.7505E+03,1.1672E+03,5.8384E+02,2.7245E+00/
      DATA ((KB(JS,JT,21, 9),JS=1,5),JT=1,5) /
     &1.6700E+03,1.2526E+03,8.3526E+02,4.1790E+02,2.8188E+00,
     &1.7058E+03,1.2795E+03,8.5318E+02,4.2686E+02,2.8087E+00,
     &1.7510E+03,1.3134E+03,8.7578E+02,4.3816E+02,2.7899E+00,
     &1.8029E+03,1.3523E+03,9.0173E+02,4.5113E+02,2.7632E+00,
     &1.8601E+03,1.3952E+03,9.3032E+02,4.6542E+02,2.7328E+00/
      DATA ((KB(JS,JT,22, 9),JS=1,5),JT=1,5) /
     &1.3403E+03,1.0054E+03,6.7043E+02,3.3549E+02,2.7778E+00,
     &1.3792E+03,1.0345E+03,6.8985E+02,3.4520E+02,2.7715E+00,
     &1.4248E+03,1.0688E+03,7.1269E+02,3.5661E+02,2.7559E+00,
     &1.4749E+03,1.1063E+03,7.3770E+02,3.6911E+02,2.7316E+00,
     &1.5223E+03,1.1418E+03,7.6138E+02,3.8094E+02,2.7088E+00/
      DATA ((KB(JS,JT,23, 9),JS=1,5),JT=1,5) /
     &1.0891E+03,8.1698E+02,5.4484E+02,2.7270E+02,2.7041E+00,
     &1.1283E+03,8.4637E+02,5.6443E+02,2.8249E+02,2.7027E+00,
     &1.1704E+03,8.7791E+02,5.8545E+02,2.9300E+02,2.6907E+00,
     &1.2113E+03,9.0862E+02,6.0592E+02,3.0322E+02,2.6730E+00,
     &1.2507E+03,9.3816E+02,6.2560E+02,3.1305E+02,2.6594E+00/
      DATA ((KB(JS,JT,24, 9),JS=1,5),JT=1,5) /
     &8.8581E+02,6.6450E+02,4.4318E+02,2.2188E+02,2.6023E+00,
     &9.2040E+02,6.9044E+02,4.6047E+02,2.3052E+02,2.6060E+00,
     &9.5496E+02,7.1635E+02,4.7775E+02,2.3914E+02,2.6005E+00,
     &9.8776E+02,7.4094E+02,4.9413E+02,2.4733E+02,2.5922E+00,
     &1.0196E+03,7.6479E+02,5.1001E+02,2.5525E+02,2.5914E+00/
      DATA ((KB(JS,JT,25, 9),JS=1,5),JT=1,5) /
     &7.3035E+02,5.4790E+02,3.6545E+02,1.8302E+02,2.4806E+00,
     &7.5932E+02,5.6963E+02,3.7993E+02,1.9025E+02,2.4895E+00,
     &7.8665E+02,5.9012E+02,3.9359E+02,1.9707E+02,2.4921E+00,
     &8.1328E+02,6.1007E+02,4.0688E+02,2.0370E+02,2.4969E+00,
     &8.3956E+02,6.2979E+02,4.2001E+02,2.1025E+02,2.5085E+00/
      DATA ((KB(JS,JT,26, 9),JS=1,5),JT=1,5) /
     &6.1100E+02,4.5838E+02,3.0577E+02,1.5319E+02,2.3442E+00,
     &6.3406E+02,4.7568E+02,3.1730E+02,1.5893E+02,2.3618E+00,
     &6.5658E+02,4.9255E+02,3.2854E+02,1.6455E+02,2.3770E+00,
     &6.7915E+02,5.0948E+02,3.3981E+02,1.7016E+02,2.3964E+00,
     &7.0247E+02,5.2696E+02,3.5146E+02,1.7598E+02,2.4222E+00/
      DATA ((KB(JS,JT,27, 9),JS=1,5),JT=1,5) /
     &5.2844E+02,3.9646E+02,2.6449E+02,1.3259E+02,2.2032E+00,
     &5.4789E+02,4.1105E+02,2.7421E+02,1.3742E+02,2.2331E+00,
     &5.6778E+02,4.2595E+02,2.8414E+02,1.4236E+02,2.2623E+00,
     &5.8850E+02,4.4149E+02,2.9449E+02,1.4751E+02,2.3009E+00,
     &6.1090E+02,4.5829E+02,3.0567E+02,1.5309E+02,2.3382E+00/
      DATA ((KB(JS,JT,28, 9),JS=1,5),JT=1,5) /
     &4.6826E+02,3.5133E+02,2.3440E+02,1.1763E+02,2.0680E+00,
     &4.8590E+02,3.6454E+02,2.4321E+02,1.2197E+02,2.1100E+00,
     &5.0445E+02,3.7846E+02,2.5247E+02,1.2655E+02,2.1567E+00,
     &5.2474E+02,3.9367E+02,2.6260E+02,1.3159E+02,2.2098E+00,
     &5.4720E+02,4.1051E+02,2.7382E+02,1.3717E+02,2.2620E+00/
      DATA ((KB(JS,JT,29, 9),JS=1,5),JT=1,5) /
     &4.4072E+02,3.3067E+02,2.2063E+02,1.1082E+02,1.9419E+00,
     &4.5821E+02,3.4378E+02,2.2936E+02,1.1511E+02,1.9998E+00,
     &4.7729E+02,3.5808E+02,2.3889E+02,1.1980E+02,2.0671E+00,
     &4.9882E+02,3.7422E+02,2.4964E+02,1.2512E+02,2.1341E+00,
     &5.2331E+02,3.9259E+02,2.6188E+02,1.3121E+02,2.1979E+00/
      DATA ((KB(JS,JT,30, 9),JS=1,5),JT=1,5) /
     &4.2556E+02,3.1930E+02,2.1305E+02,1.0711E+02,1.8309E+00,
     &4.4407E+02,3.3317E+02,2.2229E+02,1.1161E+02,1.9101E+00,
     &4.6505E+02,3.4890E+02,2.3276E+02,1.1676E+02,1.9914E+00,
     &4.8908E+02,3.6692E+02,2.4477E+02,1.2270E+02,2.0709E+00,
     &5.1660E+02,3.8756E+02,2.5853E+02,1.2954E+02,2.1480E+00/
      DATA ((KB(JS,JT,31, 9),JS=1,5),JT=1,5) /
     &4.3357E+02,3.2530E+02,2.1704E+02,1.0913E+02,1.7458E+00,
     &4.5478E+02,3.4120E+02,2.2764E+02,1.1430E+02,1.8393E+00,
     &4.7940E+02,3.5966E+02,2.3993E+02,1.2035E+02,1.9333E+00,
     &5.0804E+02,3.8115E+02,2.5425E+02,1.2744E+02,2.0234E+00,
     &5.4033E+02,4.0536E+02,2.7039E+02,1.3548E+02,2.1150E+00/
      DATA ((KB(JS,JT,32, 9),JS=1,5),JT=1,5) /
     &4.4897E+02,3.3685E+02,2.2474E+02,1.1298E+02,1.6787E+00,
     &4.7419E+02,3.5576E+02,2.3734E+02,1.1915E+02,1.7859E+00,
     &5.0379E+02,3.7796E+02,2.5213E+02,1.2644E+02,1.8899E+00,
     &5.3795E+02,4.0357E+02,2.6921E+02,1.3492E+02,1.9968E+00,
     &5.7556E+02,4.3179E+02,2.8802E+02,1.4429E+02,2.0977E+00/
      DATA ((KB(JS,JT,33, 9),JS=1,5),JT=1,5) /
     &4.7613E+02,3.5721E+02,2.3831E+02,1.1974E+02,1.6313E+00,
     &5.0727E+02,3.8056E+02,2.5387E+02,1.2739E+02,1.7486E+00,
     &5.4363E+02,4.0783E+02,2.7205E+02,1.3639E+02,1.8695E+00,
     &5.8421E+02,4.3828E+02,2.9234E+02,1.4648E+02,1.9835E+00,
     &6.2742E+02,4.7068E+02,3.1394E+02,1.5725E+02,2.0938E+00/
      DATA ((KB(JS,JT,34, 9),JS=1,5),JT=1,5) /
     &4.9479E+02,3.7120E+02,2.4764E+02,1.2439E+02,1.5951E+00,
     &5.3209E+02,3.9918E+02,2.6628E+02,1.3359E+02,1.7258E+00,
     &5.7463E+02,4.3109E+02,2.8755E+02,1.4413E+02,1.8546E+00,
     &6.2052E+02,4.6551E+02,3.1050E+02,1.5556E+02,1.9770E+00,
     &6.6892E+02,5.0180E+02,3.3469E+02,1.6762E+02,2.0917E+00/
      DATA ((KB(JS,JT,35, 9),JS=1,5),JT=1,5) /
     &5.1474E+02,3.8617E+02,2.5762E+02,1.2939E+02,1.5620E+00,
     &5.5847E+02,4.1897E+02,2.7948E+02,1.4019E+02,1.7022E+00,
     &6.0709E+02,4.5544E+02,3.0379E+02,1.5226E+02,1.8365E+00,
     &6.5852E+02,4.9401E+02,3.2950E+02,1.6506E+02,1.9663E+00,
     &7.1282E+02,5.3473E+02,3.5664E+02,1.7860E+02,2.0876E+00/
      DATA ((KB(JS,JT,36, 9),JS=1,5),JT=1,5) /
     &5.3040E+02,3.9792E+02,2.6545E+02,1.3332E+02,1.5229E+00,
     &5.8002E+02,4.3513E+02,2.9026E+02,1.4559E+02,1.6698E+00,
     &6.3422E+02,4.7578E+02,3.1736E+02,1.5904E+02,1.8112E+00,
     &6.9154E+02,5.1877E+02,3.4601E+02,1.7331E+02,1.9470E+00,
     &7.5259E+02,5.6456E+02,3.7653E+02,1.8854E+02,2.0786E+00/
      DATA ((KB(JS,JT,37, 9),JS=1,5),JT=1,5) /
     &5.2761E+02,3.9583E+02,2.6405E+02,1.3269E+02,1.4669E+00,
     &5.8107E+02,4.3593E+02,2.9079E+02,1.4590E+02,1.6200E+00,
     &6.3936E+02,4.7964E+02,3.1993E+02,1.6036E+02,1.7687E+00,
     &7.0149E+02,5.2623E+02,3.5098E+02,1.7581E+02,1.9104E+00,
     &7.6801E+02,5.7612E+02,3.8424E+02,1.9240E+02,2.0492E+00/
      DATA ((KB(JS,JT,38, 9),JS=1,5),JT=1,5) /
     &5.3320E+02,4.0002E+02,2.6686E+02,1.3414E+02,1.4150E+00,
     &5.9148E+02,4.4373E+02,2.9599E+02,1.4854E+02,1.5738E+00,
     &6.5505E+02,4.9141E+02,3.2778E+02,1.6430E+02,1.7289E+00,
     &7.2345E+02,5.4270E+02,3.6197E+02,1.8131E+02,1.8759E+00,
     &7.9740E+02,5.9816E+02,3.9894E+02,1.9975E+02,2.0221E+00/
      DATA ((KB(JS,JT,39, 9),JS=1,5),JT=1,5) /
     &5.5268E+02,4.1463E+02,2.7660E+02,1.3905E+02,1.3683E+00,
     &6.1737E+02,4.6316E+02,3.0895E+02,1.5504E+02,1.5320E+00,
     &6.8821E+02,5.1628E+02,3.4436E+02,1.7260E+02,1.6920E+00,
     &7.6555E+02,5.7429E+02,3.8302E+02,1.9184E+02,1.8468E+00,
     &8.4965E+02,6.3736E+02,4.2508E+02,2.1282E+02,1.9969E+00/
      DATA ((KB(JS,JT,40, 9),JS=1,5),JT=1,5) /
     &5.3311E+02,3.9996E+02,2.6682E+02,1.3428E+02,1.3069E+00,
     &5.9979E+02,4.4997E+02,3.0016E+02,1.5072E+02,1.4753E+00,
     &6.7343E+02,5.0519E+02,3.3697E+02,1.6896E+02,1.6406E+00,
     &7.5472E+02,5.6615E+02,3.7760E+02,1.8916E+02,1.7999E+00,
     &8.4379E+02,6.3296E+02,4.2214E+02,2.1136E+02,1.9558E+00/
      DATA ((KB(JS,JT,41, 9),JS=1,5),JT=1,5) /
     &5.1260E+02,3.8458E+02,2.5658E+02,1.2928E+02,1.2459E+00,
     &5.8131E+02,4.3611E+02,2.9093E+02,1.4621E+02,1.4179E+00,
     &6.5741E+02,4.9318E+02,3.2896E+02,1.6503E+02,1.5871E+00,
     &7.4227E+02,5.5683E+02,3.7139E+02,1.8609E+02,1.7498E+00,
     &8.3623E+02,6.2730E+02,4.1837E+02,2.0950E+02,1.9122E+00/
      DATA ((KB(JS,JT,42, 9),JS=1,5),JT=1,5) /
     &4.9831E+02,3.7386E+02,2.4944E+02,1.2584E+02,1.1865E+00,
     &5.6980E+02,4.2748E+02,2.8517E+02,1.4342E+02,1.3622E+00,
     &6.4955E+02,4.8728E+02,3.2503E+02,1.6313E+02,1.5361E+00,
     &7.3900E+02,5.5437E+02,3.6975E+02,1.8531E+02,1.7026E+00,
     &8.3900E+02,6.2937E+02,4.1975E+02,2.1021E+02,1.8688E+00/
      DATA ((KB(JS,JT,43, 9),JS=1,5),JT=1,5) /
     &4.8522E+02,3.6405E+02,2.4292E+02,1.2271E+02,1.1188E+00,
     &5.5936E+02,4.1965E+02,2.7996E+02,1.4092E+02,1.2979E+00,
     &6.4330E+02,4.8260E+02,3.2191E+02,1.6164E+02,1.4736E+00,
     &7.3773E+02,5.5342E+02,3.6912E+02,1.8505E+02,1.6463E+00,
     &8.4419E+02,6.3327E+02,4.2235E+02,2.1154E+02,1.8168E+00/
      DATA ((KB(JS,JT,44, 9),JS=1,5),JT=1,5) /
     &4.7662E+02,3.5759E+02,2.3863E+02,1.2069E+02,1.0480E+00,
     &5.5453E+02,4.1603E+02,2.7755E+02,1.3982E+02,1.2297E+00,
     &6.4348E+02,4.8273E+02,3.2200E+02,1.6176E+02,1.4085E+00,
     &7.4447E+02,5.5848E+02,3.7249E+02,1.8678E+02,1.5847E+00,
     &8.5855E+02,6.4403E+02,4.2953E+02,2.1515E+02,1.7587E+00/
      DATA ((KB(JS,JT,45, 9),JS=1,5),JT=1,5) /
     &4.7694E+02,3.5784E+02,2.3881E+02,1.2088E+02,9.8025E-01,
     &5.6049E+02,4.2050E+02,2.8054E+02,1.4139E+02,1.1623E+00,
     &6.5632E+02,4.9237E+02,3.2842E+02,1.6503E+02,1.3439E+00,
     &7.6635E+02,5.7488E+02,3.8343E+02,1.9228E+02,1.5236E+00,
     &8.9123E+02,6.6854E+02,4.4587E+02,2.2334E+02,1.7007E+00/
      DATA ((KB(JS,JT,46, 9),JS=1,5),JT=1,5) /
     &4.7924E+02,3.5957E+02,2.3999E+02,1.2157E+02,9.0983E-01,
     &5.6922E+02,4.2705E+02,2.8491E+02,1.4366E+02,1.0922E+00,
     &6.7352E+02,5.0527E+02,3.3703E+02,1.6939E+02,1.2757E+00,
     &7.9367E+02,5.9538E+02,3.9709E+02,1.9915E+02,1.4579E+00,
     &9.3189E+02,6.9904E+02,4.6620E+02,2.3352E+02,1.6382E+00/
      DATA ((KB(JS,JT,47, 9),JS=1,5),JT=1,5) /
     &4.7215E+02,3.5425E+02,2.3648E+02,1.1995E+02,8.3319E-01,
     &5.6710E+02,4.2546E+02,2.8387E+02,1.4325E+02,1.0142E+00,
     &6.7881E+02,5.0924E+02,3.3968E+02,1.7081E+02,1.1988E+00,
     &8.0796E+02,6.0609E+02,4.0424E+02,2.0278E+02,1.3835E+00,
     &9.5794E+02,7.1858E+02,4.7923E+02,2.4007E+02,1.5668E+00/
      DATA ((KB(JS,JT,48, 9),JS=1,5),JT=1,5) /
     &4.7667E+02,3.5764E+02,2.3876E+02,1.2119E+02,7.5823E-01,
     &5.7865E+02,4.3413E+02,2.8965E+02,1.4623E+02,9.3799E-01,
     &7.0145E+02,5.2622E+02,3.5101E+02,1.7653E+02,1.1229E+00,
     &8.4427E+02,6.3333E+02,4.2240E+02,2.1190E+02,1.3089E+00,
     &1.0109E+03,7.5832E+02,5.0573E+02,2.5334E+02,1.4951E+00/
      DATA ((KB(JS,JT,49, 9),JS=1,5),JT=1,5) /
     &4.9957E+02,3.7481E+02,2.5022E+02,1.2697E+02,6.8631E-01,
     &6.1224E+02,4.5931E+02,3.0645E+02,1.5466E+02,8.6353E-01,
     &7.5197E+02,5.6411E+02,3.7627E+02,1.8917E+02,1.0480E+00,
     &9.1643E+02,6.8745E+02,4.5848E+02,2.2994E+02,1.2341E+00,
     &1.1094E+03,8.3219E+02,5.5497E+02,2.7795E+02,1.4234E+00/
      DATA ((KB(JS,JT,50, 9),JS=1,5),JT=1,5) /
     &4.9927E+02,3.7459E+02,2.5011E+02,1.2702E+02,6.2082E-01,
     &6.1745E+02,4.6322E+02,3.0907E+02,1.5606E+02,7.9337E-01,
     &7.6850E+02,5.7651E+02,3.8454E+02,1.9338E+02,9.7702E-01,
     &9.4909E+02,7.1195E+02,4.7482E+02,2.3816E+02,1.1637E+00,
     &1.1628E+03,8.7227E+02,5.8169E+02,2.9133E+02,1.3527E+00/
      DATA ((KB(JS,JT,51, 9),JS=1,5),JT=1,5) /
     &4.8758E+02,3.6583E+02,2.4432E+02,1.2426E+02,5.5888E-01,
     &6.0851E+02,4.5652E+02,3.0463E+02,1.5396E+02,7.2702E-01,
     &7.6706E+02,5.7543E+02,3.8383E+02,1.9312E+02,9.0804E-01,
     &9.6042E+02,7.2045E+02,4.8049E+02,2.4107E+02,1.0946E+00,
     &1.1920E+03,8.9415E+02,5.9629E+02,2.9867E+02,1.2844E+00/
      DATA ((KB(JS,JT,52, 9),JS=1,5),JT=1,5) /
     &4.8860E+02,3.6660E+02,2.4488E+02,1.2464E+02,4.9962E-01,
     &6.1451E+02,4.6102E+02,3.0765E+02,1.5555E+02,6.6320E-01,
     &7.8418E+02,5.8827E+02,3.9240E+02,1.9747E+02,8.4128E-01,
     &9.9602E+02,7.4715E+02,4.9829E+02,2.5001E+02,1.0268E+00,
     &1.2534E+03,9.4018E+02,6.2698E+02,3.1403E+02,1.2165E+00/
      DATA ((KB(JS,JT,53, 9),JS=1,5),JT=1,5) /
     &5.0881E+02,3.8175E+02,2.5500E+02,1.2975E+02,4.4418E-01,
     &6.4426E+02,4.8334E+02,3.2253E+02,1.6302E+02,6.0138E-01,
     &8.3158E+02,6.2382E+02,4.1611E+02,2.0933E+02,7.7570E-01,
     &1.0715E+03,8.0375E+02,5.3603E+02,2.6888E+02,9.5940E-01,
     &1.3680E+03,1.0262E+03,6.8430E+02,3.4269E+02,1.1487E+00/
      DATA ((KB(JS,JT,54, 9),JS=1,5),JT=1,5) /
     &4.6019E+02,3.4529E+02,2.3082E+02,1.1788E+02,3.9422E-01,
     &5.8633E+02,4.3988E+02,2.9364E+02,1.4879E+02,5.4422E-01,
     &7.6477E+02,5.7372E+02,3.8273E+02,1.9285E+02,7.1419E-01,
     &9.9975E+02,7.4995E+02,5.0017E+02,2.5112E+02,8.9603E-01,
     &1.2952E+03,9.7153E+02,6.4788E+02,3.2458E+02,1.0830E+00/
      DATA ((KB(JS,JT,55, 9),JS=1,5),JT=1,5) /
     &3.8020E+02,2.8531E+02,1.9107E+02,9.8307E+01,3.4739E-01,
     &4.8735E+02,3.6565E+02,2.4430E+02,1.2445E+02,4.9078E-01,
     &6.4163E+02,4.8136E+02,3.2124E+02,1.6243E+02,6.5484E-01,
     &8.5082E+02,6.3825E+02,4.2573E+02,2.1419E+02,8.3371E-01,
     &1.1188E+03,8.3927E+02,5.5970E+02,2.8072E+02,1.0198E+00/
      DATA ((KB(JS,JT,56, 9),JS=1,5),JT=1,5) /
     &3.1368E+02,2.3545E+02,1.5809E+02,8.2086E+01,3.0410E-01,
     &4.0416E+02,3.0326E+02,2.0292E+02,1.0407E+02,4.3985E-01,
     &5.3658E+02,4.0257E+02,2.6883E+02,1.3655E+02,5.9766E-01,
     &7.2129E+02,5.4110E+02,3.6102E+02,1.8214E+02,7.7256E-01,
     &9.6339E+02,7.2268E+02,4.8200E+02,2.4214E+02,9.5689E-01/
      DATA ((KB(JS,JT,57, 9),JS=1,5),JT=1,5) /
     &2.5819E+02,1.9390E+02,1.3066E+02,6.8602E+01,2.6463E-01,
     &3.3457E+02,2.5110E+02,1.6838E+02,8.7076E+01,3.9133E-01,
     &4.4726E+02,3.3558E+02,2.2435E+02,1.1462E+02,5.4231E-01,
     &6.0897E+02,4.5687E+02,3.0496E+02,1.5443E+02,7.1198E-01,
     &8.2628E+02,6.1985E+02,4.1347E+02,2.0818E+02,8.9451E-01/
      DATA ((KB(JS,JT,58, 9),JS=1,5),JT=1,5) /
     &5.6144E+01,5.1598E+01,4.4952E+01,3.3575E+01,2.2945E-01,
     &7.3248E+01,6.7230E+01,5.8185E+01,4.2642E+01,3.4680E-01,
     &9.8566E+01,9.0421E+01,7.7903E+01,5.6215E+01,4.9127E-01,
     &1.3577E+02,1.2452E+02,1.0700E+02,7.6316E+01,6.5580E-01,
     &1.8716E+02,1.7164E+02,1.4731E+02,1.0424E+02,8.3481E-01/
      DATA ((KB(JS,JT,59, 9),JS=1,5),JT=1,5) /
     &5.7246E+01,5.0299E+01,4.1347E+01,2.8542E+01,2.1390E-01,
     &7.5569E+01,6.6181E+01,5.3818E+01,3.6138E+01,3.2687E-01,
     &1.0297E+02,9.0031E+01,7.2620E+01,4.7606E+01,4.6582E-01,
     &1.4369E+02,1.2555E+02,1.0072E+02,6.4807E+01,6.2712E-01,
     &2.0105E+02,1.7562E+02,1.4046E+02,8.9199E+01,8.0292E-01/
      DATA ((KB(JS,JT,13,10),JS=1,5),JT=1,5) /
     &1.3594E+05,1.0195E+05,6.7969E+04,3.3985E+04,3.3627E+00,
     &1.3605E+05,1.0204E+05,6.8026E+04,3.4013E+04,3.2528E+00,
     &1.3597E+05,1.0198E+05,6.7984E+04,3.3992E+04,3.1814E+00,
     &1.3504E+05,1.0128E+05,6.7520E+04,3.3760E+04,3.0515E+00,
     &1.3382E+05,1.0037E+05,6.6910E+04,3.3456E+04,3.0303E+00/
      DATA ((KB(JS,JT,14,10),JS=1,5),JT=1,5) /
     &8.3672E+04,6.2754E+04,4.1836E+04,2.0918E+04,3.6220E+00,
     &8.3355E+04,6.2516E+04,4.1677E+04,2.0839E+04,3.5454E+00,
     &8.2924E+04,6.2193E+04,4.1462E+04,2.0731E+04,3.4328E+00,
     &8.2189E+04,6.1641E+04,4.1094E+04,2.0547E+04,3.3922E+00,
     &8.1205E+04,6.0904E+04,4.0602E+04,2.0301E+04,3.2425E+00/
      DATA ((KB(JS,JT,15,10),JS=1,5),JT=1,5) /
     &5.1150E+04,3.8363E+04,2.5576E+04,1.2788E+04,3.9145E+00,
     &5.0875E+04,3.8157E+04,2.5438E+04,1.2719E+04,3.8152E+00,
     &5.0407E+04,3.7806E+04,2.5204E+04,1.2602E+04,3.7733E+00,
     &4.9693E+04,3.7270E+04,2.4847E+04,1.2424E+04,3.6717E+00,
     &4.8987E+04,3.6740E+04,2.4494E+04,1.2247E+04,3.5647E+00/
      DATA ((KB(JS,JT,16,10),JS=1,5),JT=1,5) /
     &3.6535E+04,2.7401E+04,1.8268E+04,9.1341E+03,4.2542E+00,
     &3.6151E+04,2.7114E+04,1.8076E+04,9.0383E+03,4.1666E+00,
     &3.5666E+04,2.6750E+04,1.7833E+04,8.9169E+03,4.1063E+00,
     &3.5133E+04,2.6350E+04,1.7567E+04,8.7838E+03,4.0309E+00,
     &3.4526E+04,2.5894E+04,1.7263E+04,8.6318E+03,3.8978E+00/
      DATA ((KB(JS,JT,17,10),JS=1,5),JT=1,5) /
     &2.6414E+04,1.9811E+04,1.3207E+04,6.6039E+03,4.6454E+00,
     &2.6068E+04,1.9551E+04,1.3034E+04,6.5174E+03,4.5633E+00,
     &2.5689E+04,1.9267E+04,1.2845E+04,6.4225E+03,4.4826E+00,
     &2.5209E+04,1.8907E+04,1.2605E+04,6.3027E+03,4.3889E+00,
     &2.4661E+04,1.8496E+04,1.2331E+04,6.1658E+03,4.2589E+00/
      DATA ((KB(JS,JT,18,10),JS=1,5),JT=1,5) /
     &1.9208E+04,1.4406E+04,9.6044E+03,4.8025E+03,5.0342E+00,
     &1.8927E+04,1.4195E+04,9.4636E+03,4.7320E+03,4.9453E+00,
     &1.8575E+04,1.3931E+04,9.2875E+03,4.6440E+03,4.8565E+00,
     &1.8151E+04,1.3614E+04,9.0760E+03,4.5383E+03,4.7616E+00,
     &1.7715E+04,1.3287E+04,8.8579E+03,4.4292E+03,4.6381E+00/
      DATA ((KB(JS,JT,19,10),JS=1,5),JT=1,5) /
     &1.3561E+04,1.0171E+04,6.7808E+03,3.3906E+03,5.4045E+00,
     &1.3305E+04,9.9790E+03,6.6528E+03,3.3267E+03,5.3114E+00,
     &1.3001E+04,9.7507E+03,6.5006E+03,3.2506E+03,5.2250E+00,
     &1.2687E+04,9.5155E+03,6.3438E+03,3.1722E+03,5.1407E+00,
     &1.2394E+04,9.2960E+03,6.1975E+03,3.0991E+03,5.0251E+00/
      DATA ((KB(JS,JT,20,10),JS=1,5),JT=1,5) /
     &1.0195E+04,7.6466E+03,5.0979E+03,2.5492E+03,5.7652E+00,
     &9.9631E+03,7.4725E+03,4.9818E+03,2.4912E+03,5.6804E+00,
     &9.7293E+03,7.2971E+03,4.8649E+03,2.4328E+03,5.6092E+00,
     &9.5227E+03,7.1421E+03,4.7616E+03,2.3811E+03,5.5285E+00,
     &9.3625E+03,7.0220E+03,4.6816E+03,2.3411E+03,5.3995E+00/
      DATA ((KB(JS,JT,21,10),JS=1,5),JT=1,5) /
     &7.7885E+03,5.8415E+03,3.8945E+03,1.9475E+03,6.1280E+00,
     &7.6092E+03,5.7071E+03,3.8049E+03,1.9027E+03,6.0467E+00,
     &7.4658E+03,5.5995E+03,3.7332E+03,1.8669E+03,5.9782E+00,
     &7.3647E+03,5.5237E+03,3.6826E+03,1.8416E+03,5.8911E+00,
     &7.2928E+03,5.4698E+03,3.6467E+03,1.8237E+03,5.7660E+00/
      DATA ((KB(JS,JT,22,10),JS=1,5),JT=1,5) /
     &6.0472E+03,4.5355E+03,3.0239E+03,1.5122E+03,6.4389E+00,
     &5.9457E+03,4.4594E+03,2.9731E+03,1.4868E+03,6.3534E+00,
     &5.8843E+03,4.4133E+03,2.9424E+03,1.4715E+03,6.3043E+00,
     &5.8543E+03,4.3909E+03,2.9274E+03,1.4640E+03,6.2309E+00,
     &5.8906E+03,4.4181E+03,2.9456E+03,1.4732E+03,6.0993E+00/
      DATA ((KB(JS,JT,23,10),JS=1,5),JT=1,5) /
     &4.7512E+03,3.5635E+03,2.3758E+03,1.1882E+03,6.6888E+00,
     &4.7151E+03,3.5365E+03,2.3578E+03,1.1792E+03,6.6289E+00,
     &4.7153E+03,3.5366E+03,2.3579E+03,1.1792E+03,6.5888E+00,
     &4.7757E+03,3.5820E+03,2.3882E+03,1.1944E+03,6.5103E+00,
     &4.8784E+03,3.6590E+03,2.4396E+03,1.2201E+03,6.3750E+00/
      DATA ((KB(JS,JT,24,10),JS=1,5),JT=1,5) /
     &3.7664E+03,2.8249E+03,1.8835E+03,9.4199E+02,6.8939E+00,
     &3.7833E+03,2.8376E+03,1.8919E+03,9.4626E+02,6.8560E+00,
     &3.8524E+03,2.8895E+03,1.9265E+03,9.6361E+02,6.8233E+00,
     &3.9503E+03,2.9629E+03,1.9755E+03,9.8811E+02,6.7364E+00,
     &4.0500E+03,3.0377E+03,2.0254E+03,1.0130E+03,6.5861E+00/
      DATA ((KB(JS,JT,25,10),JS=1,5),JT=1,5) /
     &3.0705E+03,2.3030E+03,1.5356E+03,7.6808E+02,7.0352E+00,
     &3.1368E+03,2.3527E+03,1.5687E+03,7.8472E+02,7.0310E+00,
     &3.2299E+03,2.4226E+03,1.6153E+03,8.0803E+02,7.0074E+00,
     &3.3291E+03,2.4970E+03,1.6649E+03,8.3282E+02,6.9138E+00,
     &3.4334E+03,2.5753E+03,1.7171E+03,8.5889E+02,6.7836E+00/
      DATA ((KB(JS,JT,26,10),JS=1,5),JT=1,5) /
     &2.5973E+03,1.9481E+03,1.2990E+03,6.4986E+02,7.1301E+00,
     &2.6809E+03,2.0109E+03,1.3408E+03,6.7078E+02,7.1546E+00,
     &2.7748E+03,2.0813E+03,1.3878E+03,6.9426E+02,7.1359E+00,
     &2.8656E+03,2.1494E+03,1.4332E+03,7.1694E+02,7.0388E+00,
     &2.9554E+03,2.2167E+03,1.4780E+03,7.3936E+02,6.9309E+00/
      DATA ((KB(JS,JT,27,10),JS=1,5),JT=1,5) /
     &2.3040E+03,1.7282E+03,1.1524E+03,5.7657E+02,7.1805E+00,
     &2.3938E+03,1.7956E+03,1.1973E+03,5.9902E+02,7.2265E+00,
     &2.4776E+03,1.8584E+03,1.2392E+03,6.1996E+02,7.2160E+00,
     &2.5592E+03,1.9196E+03,1.2799E+03,6.4031E+02,7.1019E+00,
     &2.6344E+03,1.9760E+03,1.3176E+03,6.5914E+02,7.0533E+00/
      DATA ((KB(JS,JT,28,10),JS=1,5),JT=1,5) /
     &2.1016E+03,1.5764E+03,1.0512E+03,5.2597E+02,7.1943E+00,
     &2.1832E+03,1.6376E+03,1.0920E+03,5.4637E+02,7.2562E+00,
     &2.2626E+03,1.6971E+03,1.1316E+03,5.6618E+02,7.2356E+00,
     &2.3367E+03,1.7527E+03,1.1687E+03,5.8470E+02,7.1672E+00,
     &2.4052E+03,1.8041E+03,1.2030E+03,6.0186E+02,7.1806E+00/
      DATA ((KB(JS,JT,29,10),JS=1,5),JT=1,5) /
     &2.0213E+03,1.5162E+03,1.0110E+03,5.0592E+02,7.1826E+00,
     &2.1025E+03,1.5771E+03,1.0516E+03,5.2618E+02,7.2449E+00,
     &2.1817E+03,1.6365E+03,1.0912E+03,5.4596E+02,7.2200E+00,
     &2.2556E+03,1.6919E+03,1.1282E+03,5.6447E+02,7.2591E+00,
     &2.3246E+03,1.7436E+03,1.1626E+03,5.8167E+02,7.2912E+00/
      DATA ((KB(JS,JT,30,10),JS=1,5),JT=1,5) /
     &1.9891E+03,1.4920E+03,9.9489E+02,4.9783E+02,7.1696E+00,
     &2.0704E+03,1.5530E+03,1.0355E+03,5.1812E+02,7.1996E+00,
     &2.1486E+03,1.6117E+03,1.0747E+03,5.3773E+02,7.2564E+00,
     &2.2243E+03,1.6684E+03,1.1125E+03,5.5660E+02,7.3491E+00,
     &2.2969E+03,1.7228E+03,1.1488E+03,5.7471E+02,7.3950E+00/
      DATA ((KB(JS,JT,31,10),JS=1,5),JT=1,5) /
     &2.0600E+03,1.5452E+03,1.0303E+03,5.1552E+02,7.0891E+00,
     &2.1442E+03,1.6083E+03,1.0725E+03,5.3661E+02,7.1940E+00,
     &2.2267E+03,1.6702E+03,1.1137E+03,5.5720E+02,7.3519E+00,
     &2.3069E+03,1.7303E+03,1.1538E+03,5.7721E+02,7.4783E+00,
     &2.3951E+03,1.7965E+03,1.1978E+03,5.9922E+02,7.4978E+00/
      DATA ((KB(JS,JT,32,10),JS=1,5),JT=1,5) /
     &2.1607E+03,1.6207E+03,1.0807E+03,5.4073E+02,7.0921E+00,
     &2.2499E+03,1.6876E+03,1.1253E+03,5.6302E+02,7.2853E+00,
     &2.3389E+03,1.7543E+03,1.1698E+03,5.8523E+02,7.4637E+00,
     &2.4345E+03,1.8261E+03,1.2176E+03,6.0908E+02,7.5300E+00,
     &2.5534E+03,1.9152E+03,1.2769E+03,6.3872E+02,7.5836E+00/
      DATA ((KB(JS,JT,33,10),JS=1,5),JT=1,5) /
     &2.3147E+03,1.7362E+03,1.1577E+03,5.7922E+02,7.1422E+00,
     &2.4114E+03,1.8087E+03,1.2060E+03,6.0335E+02,7.3798E+00,
     &2.5142E+03,1.8858E+03,1.2574E+03,6.2900E+02,7.4990E+00,
     &2.6436E+03,1.9829E+03,1.3221E+03,6.6129E+02,7.6018E+00,
     &2.8166E+03,2.1125E+03,1.4085E+03,7.0447E+02,7.6468E+00/
      DATA ((KB(JS,JT,34,10),JS=1,5),JT=1,5) /
     &2.4210E+03,1.8159E+03,1.2108E+03,6.0577E+02,7.2083E+00,
     &2.5284E+03,1.8965E+03,1.2645E+03,6.3255E+02,7.4180E+00,
     &2.6591E+03,1.9944E+03,1.3298E+03,6.6516E+02,7.5418E+00,
     &2.8359E+03,2.1270E+03,1.4182E+03,7.0928E+02,7.6931E+00,
     &3.0680E+03,2.3011E+03,1.5342E+03,7.6730E+02,7.7811E+00/
      DATA ((KB(JS,JT,35,10),JS=1,5),JT=1,5) /
     &2.5363E+03,1.9024E+03,1.2685E+03,6.3456E+02,7.2309E+00,
     &2.6634E+03,1.9977E+03,1.3320E+03,6.6631E+02,7.4393E+00,
     &2.8345E+03,2.1260E+03,1.4175E+03,7.0897E+02,7.6569E+00,
     &3.0674E+03,2.3007E+03,1.5339E+03,7.6716E+02,7.7801E+00,
     &3.3573E+03,2.5181E+03,1.6788E+03,8.3963E+02,7.8561E+00/
      DATA ((KB(JS,JT,36,10),JS=1,5),JT=1,5) /
     &2.6451E+03,1.9840E+03,1.3229E+03,6.6175E+02,7.2395E+00,
     &2.7976E+03,2.0983E+03,1.3991E+03,6.9981E+02,7.4813E+00,
     &3.0125E+03,2.2595E+03,1.5065E+03,7.5346E+02,7.7309E+00,
     &3.2979E+03,2.4736E+03,1.6492E+03,8.2479E+02,7.8735E+00,
     &3.6475E+03,2.7357E+03,1.8239E+03,9.1218E+02,7.9027E+00/
      DATA ((KB(JS,JT,37,10),JS=1,5),JT=1,5) /
     &2.6819E+03,2.0116E+03,1.3413E+03,6.7096E+02,7.2017E+00,
     &2.8583E+03,2.1439E+03,1.4294E+03,7.1495E+02,7.5003E+00,
     &3.1042E+03,2.3283E+03,1.5523E+03,7.7640E+02,7.7646E+00,
     &3.4272E+03,2.5705E+03,1.7138E+03,8.5714E+02,7.9233E+00,
     &3.8225E+03,2.8670E+03,1.9115E+03,9.5596E+02,7.9456E+00/
      DATA ((KB(JS,JT,38,10),JS=1,5),JT=1,5) /
     &2.7669E+03,2.0753E+03,1.3837E+03,6.9217E+02,7.1724E+00,
     &2.9772E+03,2.2330E+03,1.4888E+03,7.4467E+02,7.5382E+00,
     &3.2630E+03,2.4473E+03,1.6317E+03,8.1609E+02,7.7857E+00,
     &3.6292E+03,2.7220E+03,1.8149E+03,9.0769E+02,7.9649E+00,
     &4.0743E+03,3.0559E+03,2.0374E+03,1.0190E+03,7.9771E+00/
      DATA ((KB(JS,JT,39,10),JS=1,5),JT=1,5) /
     &2.9268E+03,2.1953E+03,1.4637E+03,7.3213E+02,7.1691E+00,
     &3.1832E+03,2.3875E+03,1.5919E+03,7.9619E+02,7.5536E+00,
     &3.5251E+03,2.6440E+03,1.7628E+03,8.8168E+02,7.8089E+00,
     &3.9504E+03,2.9629E+03,1.9755E+03,9.8804E+02,7.9786E+00,
     &4.4598E+03,3.3450E+03,2.2302E+03,1.1154E+03,8.0073E+00/
      DATA ((KB(JS,JT,40,10),JS=1,5),JT=1,5) /
     &2.8874E+03,2.1657E+03,1.4439E+03,7.2221E+02,7.0746E+00,
     &3.1724E+03,2.3794E+03,1.5864E+03,7.9346E+02,7.4831E+00,
     &3.5465E+03,2.6600E+03,1.7735E+03,8.8703E+02,7.7692E+00,
     &4.0044E+03,3.0035E+03,2.0025E+03,1.0016E+03,7.9632E+00,
     &4.5454E+03,3.4092E+03,2.2730E+03,1.1368E+03,8.0081E+00/
      DATA ((KB(JS,JT,41,10),JS=1,5),JT=1,5) /
     &2.8406E+03,2.1306E+03,1.4205E+03,7.1050E+02,6.9600E+00,
     &3.1484E+03,2.3614E+03,1.5744E+03,7.8747E+02,7.3954E+00,
     &3.5576E+03,2.6684E+03,1.7791E+03,8.8987E+02,7.7179E+00,
     &4.0527E+03,3.0397E+03,2.0267E+03,1.0137E+03,7.9444E+00,
     &4.6270E+03,3.4704E+03,2.3138E+03,1.1572E+03,8.0108E+00/
      DATA ((KB(JS,JT,42,10),JS=1,5),JT=1,5) /
     &2.8258E+03,2.1194E+03,1.4131E+03,7.0678E+02,6.8517E+00,
     &3.1581E+03,2.3687E+03,1.5793E+03,7.8990E+02,7.3049E+00,
     &3.6059E+03,2.7046E+03,1.8032E+03,9.0193E+02,7.6524E+00,
     &4.1499E+03,3.1126E+03,2.0753E+03,1.0380E+03,7.9111E+00,
     &4.7763E+03,3.5824E+03,2.3885E+03,1.1945E+03,8.0026E+00/
      DATA ((KB(JS,JT,43,10),JS=1,5),JT=1,5) /
     &2.8194E+03,2.1147E+03,1.4100E+03,7.0522E+02,6.7032E+00,
     &3.1747E+03,2.3812E+03,1.5876E+03,7.9408E+02,7.1735E+00,
     &3.6549E+03,2.7413E+03,1.8278E+03,9.1420E+02,7.5844E+00,
     &4.2522E+03,3.1893E+03,2.1264E+03,1.0635E+03,7.8420E+00,
     &4.9421E+03,3.7067E+03,2.4714E+03,1.2360E+03,7.9777E+00/
      DATA ((KB(JS,JT,44,10),JS=1,5),JT=1,5) /
     &2.8469E+03,2.1353E+03,1.4237E+03,7.1206E+02,6.5380E+00,
     &3.2203E+03,2.4153E+03,1.6104E+03,8.0548E+02,7.0393E+00,
     &3.7360E+03,2.8021E+03,1.8683E+03,9.3448E+02,7.4778E+00,
     &4.3910E+03,3.2934E+03,2.1958E+03,1.0982E+03,7.7716E+00,
     &5.1620E+03,3.8716E+03,2.5813E+03,1.2909E+03,7.9568E+00/
      DATA ((KB(JS,JT,45,10),JS=1,5),JT=1,5) /
     &2.9370E+03,2.2029E+03,1.4687E+03,7.3461E+02,6.3596E+00,
     &3.3323E+03,2.4994E+03,1.6664E+03,8.3351E+02,6.8956E+00,
     &3.8921E+03,2.9193E+03,1.9464E+03,9.7354E+02,7.3748E+00,
     &4.6196E+03,3.4648E+03,2.3101E+03,1.1554E+03,7.7094E+00,
     &5.4975E+03,4.1233E+03,2.7490E+03,1.3748E+03,7.9394E+00/
      DATA ((KB(JS,JT,46,10),JS=1,5),JT=1,5) /
     &3.0543E+03,2.2908E+03,1.5274E+03,7.6393E+02,6.1665E+00,
     &3.4757E+03,2.6069E+03,1.7382E+03,8.6940E+02,6.7524E+00,
     &4.0758E+03,3.0570E+03,2.0382E+03,1.0195E+03,7.2688E+00,
     &4.8832E+03,3.6626E+03,2.4419E+03,1.2213E+03,7.6299E+00,
     &5.8799E+03,4.4101E+03,2.9402E+03,1.4704E+03,7.9039E+00/
      DATA ((KB(JS,JT,47,10),JS=1,5),JT=1,5) /
     &3.1321E+03,2.3492E+03,1.5663E+03,7.8341E+02,5.9258E+00,
     &3.5703E+03,2.6779E+03,1.7855E+03,8.9306E+02,6.5564E+00,
     &4.1981E+03,3.1488E+03,2.0994E+03,1.0501E+03,7.1267E+00,
     &5.0652E+03,3.7991E+03,2.5329E+03,1.2668E+03,7.5455E+00,
     &6.1689E+03,4.6268E+03,3.0847E+03,1.5426E+03,7.8470E+00/
      DATA ((KB(JS,JT,48,10),JS=1,5),JT=1,5) /
     &3.3047E+03,2.4787E+03,1.6526E+03,8.2657E+02,5.6694E+00,
     &3.7747E+03,2.8312E+03,1.8877E+03,9.4418E+02,6.3589E+00,
     &4.4483E+03,3.3364E+03,2.2245E+03,1.1126E+03,6.9569E+00,
     &5.3940E+03,4.0457E+03,2.6973E+03,1.3490E+03,7.4395E+00,
     &6.6398E+03,4.9800E+03,3.3201E+03,1.6603E+03,7.7751E+00/
      DATA ((KB(JS,JT,49,10),JS=1,5),JT=1,5) /
     &3.6256E+03,2.7194E+03,1.8131E+03,9.0682E+02,5.4147E+00,
     &4.1643E+03,3.1234E+03,2.0825E+03,1.0416E+03,6.1453E+00,
     &4.9094E+03,3.6822E+03,2.4550E+03,1.2279E+03,6.7872E+00,
     &5.9847E+03,4.4886E+03,2.9926E+03,1.4966E+03,7.3168E+00,
     &7.4258E+03,5.5695E+03,3.7131E+03,1.8568E+03,7.6869E+00/
      DATA ((KB(JS,JT,50,10),JS=1,5),JT=1,5) /
     &3.7913E+03,2.8436E+03,1.8959E+03,9.4825E+02,5.1338E+00,
     &4.3920E+03,3.2942E+03,2.1963E+03,1.0985E+03,5.9203E+00,
     &5.1851E+03,3.8890E+03,2.5929E+03,1.2968E+03,6.5802E+00,
     &6.3489E+03,4.7618E+03,3.1748E+03,1.5877E+03,7.1705E+00,
     &7.9377E+03,5.9534E+03,3.9691E+03,1.9848E+03,7.5922E+00/
      DATA ((KB(JS,JT,51,10),JS=1,5),JT=1,5) /
     &3.8669E+03,2.9003E+03,1.9338E+03,9.6719E+02,4.8302E+00,
     &4.5318E+03,3.3991E+03,2.2663E+03,1.1335E+03,5.6653E+00,
     &5.3773E+03,4.0331E+03,2.6890E+03,1.3448E+03,6.3736E+00,
     &6.6015E+03,4.9513E+03,3.3010E+03,1.6508E+03,7.0028E+00,
     &8.3208E+03,6.2407E+03,4.1606E+03,2.0805E+03,7.4729E+00/
      DATA ((KB(JS,JT,52,10),JS=1,5),JT=1,5) /
     &4.0341E+03,3.0258E+03,2.0174E+03,1.0090E+03,4.5505E+00,
     &4.7982E+03,3.5989E+03,2.3995E+03,1.2001E+03,5.4004E+00,
     &5.7356E+03,4.3019E+03,2.8682E+03,1.4344E+03,6.1556E+00,
     &7.0672E+03,5.3005E+03,3.5339E+03,1.7672E+03,6.8208E+00,
     &8.9657E+03,6.7244E+03,4.4831E+03,2.2418E+03,7.3432E+00/
      DATA ((KB(JS,JT,53,10),JS=1,5),JT=1,5) /
     &4.3581E+03,3.2687E+03,2.1794E+03,1.0900E+03,4.2696E+00,
     &5.2688E+03,3.9518E+03,2.6348E+03,1.3178E+03,5.1422E+00,
     &6.3653E+03,4.7742E+03,3.1830E+03,1.5919E+03,5.9288E+00,
     &7.8870E+03,5.9154E+03,3.9438E+03,1.9722E+03,6.6345E+00,
     &1.0051E+04,7.5383E+03,5.0257E+03,2.5131E+03,7.2054E+00/
      DATA ((KB(JS,JT,54,10),JS=1,5),JT=1,5) /
     &4.0664E+03,3.0500E+03,2.0336E+03,1.0171E+03,3.9912E+00,
     &5.0070E+03,3.7555E+03,2.5039E+03,1.2523E+03,4.8673E+00,
     &6.1329E+03,4.5998E+03,3.0668E+03,1.5337E+03,5.6727E+00,
     &7.6570E+03,5.7429E+03,3.8288E+03,1.9147E+03,6.4112E+00,
     &9.8073E+03,7.3556E+03,4.9039E+03,2.4522E+03,7.0431E+00/
      DATA ((KB(JS,JT,55,10),JS=1,5),JT=1,5) /
     &3.4487E+03,2.5868E+03,1.7247E+03,8.6275E+02,3.7023E+00,
     &4.3277E+03,3.2460E+03,2.1642E+03,1.0825E+03,4.5324E+00,
     &5.3892E+03,4.0421E+03,2.6950E+03,1.3479E+03,5.4035E+00,
     &6.7963E+03,5.0973E+03,3.3984E+03,1.6995E+03,6.1546E+00,
     &8.7627E+03,6.5722E+03,4.3816E+03,2.1910E+03,6.8267E+00/
      DATA ((KB(JS,JT,56,10),JS=1,5),JT=1,5) /
     &2.9072E+03,2.1806E+03,1.4540E+03,7.2734E+02,3.4115E+00,
     &3.7198E+03,2.7901E+03,1.8603E+03,9.3056E+02,4.2571E+00,
     &4.7203E+03,3.5403E+03,2.3605E+03,1.1806E+03,5.1151E+00,
     &6.0279E+03,4.5211E+03,3.0142E+03,1.5074E+03,5.8984E+00,
     &7.8366E+03,5.8775E+03,3.9185E+03,1.9594E+03,6.6003E+00/
      DATA ((KB(JS,JT,57,10),JS=1,5),JT=1,5) /
     &2.4367E+03,1.8277E+03,1.2187E+03,6.0970E+02,3.1098E+00,
     &3.1766E+03,2.3826E+03,1.5887E+03,7.9475E+02,3.9704E+00,
     &4.1136E+03,3.0854E+03,2.0572E+03,1.0290E+03,4.8038E+00,
     &5.3345E+03,4.0010E+03,2.6675E+03,1.3340E+03,5.6428E+00,
     &7.0017E+03,5.2513E+03,3.5010E+03,1.7507E+03,6.3564E+00/
      DATA ((KB(JS,JT,58,10),JS=1,5),JT=1,5) /
     &5.3797E+02,4.9330E+02,4.2306E+02,2.9653E+02,2.8402E+00,
     &7.1438E+02,6.5505E+02,5.6177E+02,3.9372E+02,3.6954E+00,
     &9.4508E+02,8.6656E+02,7.4311E+02,5.2072E+02,4.5299E+00,
     &1.2473E+03,1.1436E+03,9.8061E+02,6.8699E+02,5.3595E+00,
     &1.6559E+03,1.5182E+03,1.3018E+03,9.1191E+02,6.1054E+00/
      DATA ((KB(JS,JT,59,10),JS=1,5),JT=1,5) /
     &5.5953E+02,4.8866E+02,3.8993E+02,2.4311E+02,2.7081E+00,
     &7.5600E+02,6.6022E+02,5.2680E+02,3.2817E+02,3.5280E+00,
     &1.0213E+03,8.9185E+02,7.1155E+02,4.4309E+02,4.3511E+00,
     &1.3747E+03,1.2004E+03,9.5765E+02,5.9615E+02,5.1215E+00,
     &1.8474E+03,1.6131E+03,1.2868E+03,8.0091E+02,5.9179E+00/
      DATA ((KB(JS,JT,13,11),JS=1,5),JT=1,5) /
     &1.9556E+05,1.4667E+05,9.7780E+04,4.8890E+04,3.8293E+00,
     &1.9579E+05,1.4684E+05,9.7894E+04,4.8947E+04,3.6477E+00,
     &1.9489E+05,1.4617E+05,9.7447E+04,4.8724E+04,3.6240E+00,
     &1.9354E+05,1.4515E+05,9.6770E+04,4.8385E+04,3.4253E+00,
     &1.9176E+05,1.4382E+05,9.5882E+04,4.7942E+04,3.3965E+00/
      DATA ((KB(JS,JT,14,11),JS=1,5),JT=1,5) /
     &1.2532E+05,9.3990E+04,6.2660E+04,3.1330E+04,4.2132E+00,
     &1.2490E+05,9.3675E+04,6.2450E+04,3.1225E+04,4.0914E+00,
     &1.2400E+05,9.3003E+04,6.2001E+04,3.1001E+04,4.0126E+00,
     &1.2262E+05,9.1963E+04,6.1309E+04,3.0654E+04,3.8288E+00,
     &1.2099E+05,9.0745E+04,6.0496E+04,3.0248E+04,3.6494E+00/
      DATA ((KB(JS,JT,15,11),JS=1,5),JT=1,5) /
     &8.0146E+04,6.0110E+04,4.0074E+04,2.0037E+04,4.6025E+00,
     &7.9365E+04,5.9524E+04,3.9683E+04,1.9842E+04,4.5011E+00,
     &7.8437E+04,5.8828E+04,3.9219E+04,1.9610E+04,4.3995E+00,
     &7.7471E+04,5.8104E+04,3.8736E+04,1.9369E+04,4.3087E+00,
     &7.6167E+04,5.7126E+04,3.8084E+04,1.9043E+04,4.1657E+00/
      DATA ((KB(JS,JT,16,11),JS=1,5),JT=1,5) /
     &5.9412E+04,4.4559E+04,2.9706E+04,1.4854E+04,4.9879E+00,
     &5.8737E+04,4.4053E+04,2.9369E+04,1.4685E+04,4.8952E+00,
     &5.7913E+04,4.3435E+04,2.8957E+04,1.4479E+04,4.7931E+00,
     &5.6912E+04,4.2684E+04,2.8456E+04,1.4229E+04,4.7058E+00,
     &5.5858E+04,4.1894E+04,2.7929E+04,1.3965E+04,4.5654E+00/
      DATA ((KB(JS,JT,17,11),JS=1,5),JT=1,5) /
     &4.4739E+04,3.3554E+04,2.2370E+04,1.1185E+04,5.4258E+00,
     &4.4040E+04,3.3030E+04,2.2020E+04,1.1011E+04,5.3316E+00,
     &4.3278E+04,3.2459E+04,2.1639E+04,1.0820E+04,5.2258E+00,
     &4.2484E+04,3.1863E+04,2.1242E+04,1.0622E+04,5.1306E+00,
     &4.1610E+04,3.1208E+04,2.0805E+04,1.0403E+04,4.9611E+00/
      DATA ((KB(JS,JT,18,11),JS=1,5),JT=1,5) /
     &3.3808E+04,2.5356E+04,1.6904E+04,8.4526E+03,5.9588E+00,
     &3.3205E+04,2.4904E+04,1.6603E+04,8.3019E+03,5.8553E+00,
     &3.2587E+04,2.4440E+04,1.6294E+04,8.1473E+03,5.7407E+00,
     &3.1890E+04,2.3917E+04,1.5945E+04,7.9729E+03,5.6396E+00,
     &3.1157E+04,2.3368E+04,1.5579E+04,7.7897E+03,5.4685E+00/
      DATA ((KB(JS,JT,19,11),JS=1,5),JT=1,5) /
     &2.4641E+04,1.8481E+04,1.2321E+04,6.1608E+03,6.5634E+00,
     &2.4168E+04,1.8126E+04,1.2084E+04,6.0424E+03,6.4593E+00,
     &2.3646E+04,1.7735E+04,1.1823E+04,5.9120E+03,6.3292E+00,
     &2.3077E+04,1.7308E+04,1.1539E+04,5.7697E+03,6.2034E+00,
     &2.2489E+04,1.6867E+04,1.1245E+04,5.6226E+03,6.0369E+00/
      DATA ((KB(JS,JT,20,11),JS=1,5),JT=1,5) /
     &1.9106E+04,1.4330E+04,9.5533E+03,4.7770E+03,7.1646E+00,
     &1.8682E+04,1.4011E+04,9.3411E+03,4.6709E+03,7.0409E+00,
     &1.8224E+04,1.3668E+04,9.1125E+03,4.5566E+03,6.8869E+00,
     &1.7734E+04,1.3300E+04,8.8671E+03,4.4339E+03,6.7557E+00,
     &1.7241E+04,1.2931E+04,8.6211E+03,4.3109E+03,6.6027E+00/
      DATA ((KB(JS,JT,21,11),JS=1,5),JT=1,5) /
     &1.5039E+04,1.1280E+04,7.5200E+03,3.7604E+03,7.7170E+00,
     &1.4660E+04,1.0995E+04,7.3306E+03,3.6657E+03,7.5835E+00,
     &1.4253E+04,1.0690E+04,7.1270E+03,3.5639E+03,7.4413E+00,
     &1.3848E+04,1.0387E+04,6.9246E+03,3.4627E+03,7.3214E+00,
     &1.3474E+04,1.0106E+04,6.7374E+03,3.3691E+03,7.1721E+00/
      DATA ((KB(JS,JT,22,11),JS=1,5),JT=1,5) /
     &1.1928E+04,8.9459E+03,5.9642E+03,2.9825E+03,8.2536E+00,
     &1.1588E+04,8.6914E+03,5.7946E+03,2.8977E+03,8.1353E+00,
     &1.1261E+04,8.4462E+03,5.6311E+03,2.8159E+03,8.0046E+00,
     &1.0981E+04,8.2362E+03,5.4911E+03,2.7459E+03,7.8868E+00,
     &1.0767E+04,8.0756E+03,5.3840E+03,2.6924E+03,7.7103E+00/
      DATA ((KB(JS,JT,23,11),JS=1,5),JT=1,5) /
     &9.3738E+03,7.0305E+03,4.6873E+03,2.3441E+03,8.7957E+00,
     &9.1120E+03,6.8342E+03,4.5564E+03,2.2786E+03,8.6750E+00,
     &8.9119E+03,6.6842E+03,4.4564E+03,2.2286E+03,8.5667E+00,
     &8.7698E+03,6.5776E+03,4.3853E+03,2.1931E+03,8.4437E+00,
     &8.7064E+03,6.5300E+03,4.3536E+03,2.1772E+03,8.2499E+00/
      DATA ((KB(JS,JT,24,11),JS=1,5),JT=1,5) /
     &7.2818E+03,5.4615E+03,3.6413E+03,1.8211E+03,9.3047E+00,
     &7.1398E+03,5.3551E+03,3.5703E+03,1.7856E+03,9.1844E+00,
     &7.0551E+03,5.2916E+03,3.5280E+03,1.7644E+03,9.0906E+00,
     &7.0561E+03,5.2923E+03,3.5284E+03,1.7646E+03,8.9639E+00,
     &7.1200E+03,5.3402E+03,3.5604E+03,1.7806E+03,8.7597E+00/
      DATA ((KB(JS,JT,25,11),JS=1,5),JT=1,5) /
     &5.7829E+03,4.3374E+03,2.8918E+03,1.4463E+03,9.7531E+00,
     &5.7416E+03,4.3064E+03,2.8712E+03,1.4360E+03,9.6333E+00,
     &5.7703E+03,4.3279E+03,2.8855E+03,1.4432E+03,9.5575E+00,
     &5.8528E+03,4.3898E+03,2.9268E+03,1.4638E+03,9.4320E+00,
     &5.9946E+03,4.4961E+03,2.9977E+03,1.4993E+03,9.2048E+00/
      DATA ((KB(JS,JT,26,11),JS=1,5),JT=1,5) /
     &4.7547E+03,3.5662E+03,2.3777E+03,1.1892E+03,1.0127E+01,
     &4.7969E+03,3.5979E+03,2.3989E+03,1.1999E+03,1.0014E+01,
     &4.8916E+03,3.6689E+03,2.4462E+03,1.2235E+03,9.9567E+00,
     &5.0339E+03,3.7756E+03,2.5174E+03,1.2591E+03,9.8430E+00,
     &5.1881E+03,3.8913E+03,2.5944E+03,1.2976E+03,9.5879E+00/
      DATA ((KB(JS,JT,27,11),JS=1,5),JT=1,5) /
     &4.1434E+03,3.1078E+03,2.0721E+03,1.0365E+03,1.0438E+01,
     &4.2449E+03,3.1839E+03,2.1229E+03,1.0619E+03,1.0375E+01,
     &4.3814E+03,3.2863E+03,2.1911E+03,1.0960E+03,1.0314E+01,
     &4.5344E+03,3.4010E+03,2.2676E+03,1.1342E+03,1.0178E+01,
     &4.7035E+03,3.5278E+03,2.3521E+03,1.1764E+03,9.9184E+00/
      DATA ((KB(JS,JT,28,11),JS=1,5),JT=1,5) /
     &3.7712E+03,2.8287E+03,1.8861E+03,9.4351E+02,1.0688E+01,
     &3.9032E+03,2.9276E+03,1.9520E+03,9.7644E+02,1.0679E+01,
     &4.0571E+03,3.0430E+03,2.0289E+03,1.0148E+03,1.0623E+01,
     &4.2272E+03,3.1706E+03,2.1139E+03,1.0573E+03,1.0454E+01,
     &4.4031E+03,3.3025E+03,2.2018E+03,1.1012E+03,1.0168E+01/
      DATA ((KB(JS,JT,29,11),JS=1,5),JT=1,5) /
     &3.6879E+03,2.7661E+03,1.8444E+03,9.2260E+02,1.0914E+01,
     &3.8440E+03,2.8832E+03,1.9224E+03,9.6157E+02,1.0945E+01,
     &4.0134E+03,3.0102E+03,2.0070E+03,1.0038E+03,1.0853E+01,
     &4.1909E+03,3.1433E+03,2.0957E+03,1.0481E+03,1.0578E+01,
     &4.3726E+03,3.2796E+03,2.1866E+03,1.0936E+03,1.0403E+01/
      DATA ((KB(JS,JT,30,11),JS=1,5),JT=1,5) /
     &3.7192E+03,2.7896E+03,1.8600E+03,9.3035E+02,1.1141E+01,
     &3.8944E+03,2.9210E+03,1.9475E+03,9.7411E+02,1.1139E+01,
     &4.0753E+03,3.0566E+03,2.0379E+03,1.0192E+03,1.0970E+01,
     &4.2621E+03,3.1967E+03,2.1313E+03,1.0660E+03,1.0736E+01,
     &4.4544E+03,3.3410E+03,2.2275E+03,1.1141E+03,1.0663E+01/
      DATA ((KB(JS,JT,31,11),JS=1,5),JT=1,5) /
     &3.9494E+03,2.9622E+03,1.9750E+03,9.8786E+02,1.1309E+01,
     &4.1497E+03,3.1124E+03,2.0751E+03,1.0378E+03,1.1233E+01,
     &4.3564E+03,3.2674E+03,2.1785E+03,1.0895E+03,1.1031E+01,
     &4.5677E+03,3.4259E+03,2.2841E+03,1.1423E+03,1.1018E+01,
     &4.7823E+03,3.5869E+03,2.3915E+03,1.1960E+03,1.0922E+01/
      DATA ((KB(JS,JT,32,11),JS=1,5),JT=1,5) /
     &4.2398E+03,3.1800E+03,2.1202E+03,1.0604E+03,1.1395E+01,
     &4.4759E+03,3.3571E+03,2.2382E+03,1.1194E+03,1.1282E+01,
     &4.7161E+03,3.5372E+03,2.3583E+03,1.1795E+03,1.1286E+01,
     &4.9603E+03,3.7204E+03,2.4805E+03,1.2406E+03,1.1267E+01,
     &5.2103E+03,3.9079E+03,2.6055E+03,1.3031E+03,1.1177E+01/
      DATA ((KB(JS,JT,33,11),JS=1,5),JT=1,5) /
     &4.6404E+03,3.4804E+03,2.3205E+03,1.1605E+03,1.1433E+01,
     &4.9200E+03,3.6901E+03,2.4603E+03,1.2304E+03,1.1468E+01,
     &5.2076E+03,3.9059E+03,2.6041E+03,1.3024E+03,1.1541E+01,
     &5.4986E+03,4.1241E+03,2.7496E+03,1.3751E+03,1.1519E+01,
     &5.8045E+03,4.3535E+03,2.9026E+03,1.4516E+03,1.1398E+01/
      DATA ((KB(JS,JT,34,11),JS=1,5),JT=1,5) /
     &4.9577E+03,3.7184E+03,2.4791E+03,1.2399E+03,1.1582E+01,
     &5.2771E+03,3.9580E+03,2.6389E+03,1.3198E+03,1.1708E+01,
     &5.6109E+03,4.2083E+03,2.8058E+03,1.4032E+03,1.1770E+01,
     &5.9588E+03,4.4693E+03,2.9798E+03,1.4902E+03,1.1629E+01,
     &6.3300E+03,4.7477E+03,3.1654E+03,1.5830E+03,1.1520E+01/
      DATA ((KB(JS,JT,35,11),JS=1,5),JT=1,5) /
     &5.2909E+03,3.9683E+03,2.6458E+03,1.3232E+03,1.1741E+01,
     &5.6548E+03,4.2413E+03,2.8277E+03,1.4142E+03,1.1903E+01,
     &6.0420E+03,4.5317E+03,3.0214E+03,1.5110E+03,1.1866E+01,
     &6.4601E+03,4.8453E+03,3.2304E+03,1.6156E+03,1.1803E+01,
     &6.9268E+03,5.1953E+03,3.4637E+03,1.7322E+03,1.1652E+01/
      DATA ((KB(JS,JT,36,11),JS=1,5),JT=1,5) /
     &5.5884E+03,4.1915E+03,2.7945E+03,1.3976E+03,1.1878E+01,
     &6.0018E+03,4.5015E+03,3.0012E+03,1.5010E+03,1.2049E+01,
     &6.4517E+03,4.8389E+03,3.2262E+03,1.6135E+03,1.1951E+01,
     &6.9515E+03,5.2138E+03,3.4761E+03,1.7384E+03,1.1938E+01,
     &7.5289E+03,5.6469E+03,3.7648E+03,1.8827E+03,1.1892E+01/
      DATA ((KB(JS,JT,37,11),JS=1,5),JT=1,5) /
     &5.7114E+03,4.2838E+03,2.8561E+03,1.4284E+03,1.1983E+01,
     &6.1629E+03,4.6224E+03,3.0818E+03,1.5413E+03,1.2105E+01,
     &6.6668E+03,5.0003E+03,3.3338E+03,1.6673E+03,1.2063E+01,
     &7.2441E+03,5.4333E+03,3.6224E+03,1.8115E+03,1.2103E+01,
     &7.9256E+03,5.9443E+03,3.9631E+03,1.9819E+03,1.2052E+01/
      DATA ((KB(JS,JT,38,11),JS=1,5),JT=1,5) /
     &5.9457E+03,4.4595E+03,2.9732E+03,1.4870E+03,1.2040E+01,
     &6.4404E+03,4.8305E+03,3.2206E+03,1.6107E+03,1.2135E+01,
     &7.0103E+03,5.2579E+03,3.5055E+03,1.7531E+03,1.2201E+01,
     &7.6883E+03,5.7664E+03,3.8444E+03,1.9225E+03,1.2264E+01,
     &8.5003E+03,6.3754E+03,4.2504E+03,2.1255E+03,1.2214E+01/
      DATA ((KB(JS,JT,39,11),JS=1,5),JT=1,5) /
     &6.3574E+03,4.7683E+03,3.1792E+03,1.5900E+03,1.2058E+01,
     &6.9172E+03,5.1882E+03,3.4591E+03,1.7299E+03,1.2221E+01,
     &7.5768E+03,5.6828E+03,3.7888E+03,1.8948E+03,1.2385E+01,
     &8.3852E+03,6.2891E+03,4.1930E+03,2.0968E+03,1.2417E+01,
     &9.3744E+03,7.0310E+03,4.6875E+03,2.3441E+03,1.2400E+01/
      DATA ((KB(JS,JT,40,11),JS=1,5),JT=1,5) /
     &6.3544E+03,4.7660E+03,3.1776E+03,1.5893E+03,1.2034E+01,
     &6.9547E+03,5.2162E+03,3.4777E+03,1.7393E+03,1.2252E+01,
     &7.6538E+03,5.7405E+03,3.8272E+03,1.9140E+03,1.2461E+01,
     &8.5373E+03,6.4031E+03,4.2689E+03,2.1348E+03,1.2533E+01,
     &9.6388E+03,7.2292E+03,4.8196E+03,2.4101E+03,1.2526E+01/
      DATA ((KB(JS,JT,41,11),JS=1,5),JT=1,5) /
     &6.3521E+03,4.7643E+03,3.1765E+03,1.5887E+03,1.1995E+01,
     &6.9920E+03,5.2442E+03,3.4964E+03,1.7486E+03,1.2280E+01,
     &7.7375E+03,5.8033E+03,3.8691E+03,1.9349E+03,1.2499E+01,
     &8.6900E+03,6.5177E+03,4.3453E+03,2.1730E+03,1.2628E+01,
     &9.9008E+03,7.4257E+03,4.9507E+03,2.4756E+03,1.2622E+01/
      DATA ((KB(JS,JT,42,11),JS=1,5),JT=1,5) /
     &6.4377E+03,4.8285E+03,3.2193E+03,1.6101E+03,1.1943E+01,
     &7.1284E+03,5.3465E+03,3.5646E+03,1.7827E+03,1.2311E+01,
     &7.9472E+03,5.9606E+03,3.9739E+03,1.9873E+03,1.2580E+01,
     &8.9767E+03,6.7326E+03,4.4886E+03,2.2446E+03,1.2710E+01,
     &1.0302E+04,7.7266E+03,5.1512E+03,2.5758E+03,1.2734E+01/
      DATA ((KB(JS,JT,43,11),JS=1,5),JT=1,5) /
     &6.5684E+03,4.9266E+03,3.2847E+03,1.6428E+03,1.1839E+01,
     &7.3100E+03,5.4827E+03,3.6554E+03,1.8281E+03,1.2298E+01,
     &8.2069E+03,6.1553E+03,4.1038E+03,2.0523E+03,1.2585E+01,
     &9.3215E+03,6.9913E+03,4.6611E+03,2.3308E+03,1.2796E+01,
     &1.0756E+04,8.0671E+03,5.3782E+03,2.6894E+03,1.2802E+01/
      DATA ((KB(JS,JT,44,11),JS=1,5),JT=1,5) /
     &6.7770E+03,5.0829E+03,3.3889E+03,1.6949E+03,1.1696E+01,
     &7.6014E+03,5.7012E+03,3.8011E+03,1.9009E+03,1.2235E+01,
     &8.5905E+03,6.4430E+03,4.2955E+03,2.1481E+03,1.2598E+01,
     &9.8167E+03,7.3626E+03,4.9086E+03,2.4546E+03,1.2843E+01,
     &1.1370E+04,8.5274E+03,5.6850E+03,2.8427E+03,1.2862E+01/
      DATA ((KB(JS,JT,45,11),JS=1,5),JT=1,5) /
     &7.1337E+03,5.3505E+03,3.5673E+03,1.7841E+03,1.1553E+01,
     &8.0813E+03,6.0612E+03,4.0411E+03,2.0209E+03,1.2213E+01,
     &9.1915E+03,6.8938E+03,4.5961E+03,2.2984E+03,1.2577E+01,
     &1.0572E+04,7.9290E+03,5.2862E+03,2.6434E+03,1.2862E+01,
     &1.2294E+04,9.2203E+03,6.1470E+03,3.0738E+03,1.2905E+01/
      DATA ((KB(JS,JT,46,11),JS=1,5),JT=1,5) /
     &7.5574E+03,5.6683E+03,3.7792E+03,1.8901E+03,1.1372E+01,
     &8.6566E+03,6.4927E+03,4.3287E+03,2.1648E+03,1.2098E+01,
     &9.9311E+03,7.4485E+03,4.9659E+03,2.4833E+03,1.2508E+01,
     &1.1483E+04,8.6121E+03,5.7416E+03,2.8711E+03,1.2889E+01,
     &1.3417E+04,1.0063E+04,6.7088E+03,3.3546E+03,1.2962E+01/
      DATA ((KB(JS,JT,47,11),JS=1,5),JT=1,5) /
     &7.8727E+03,5.9048E+03,3.9368E+03,1.9689E+03,1.1120E+01,
     &9.1356E+03,6.8519E+03,4.5682E+03,2.2845E+03,1.1918E+01,
     &1.0582E+04,7.9368E+03,5.2914E+03,2.6461E+03,1.2406E+01,
     &1.2301E+04,9.2260E+03,6.1509E+03,3.0757E+03,1.2816E+01,
     &1.4433E+04,1.0825E+04,7.2167E+03,3.6086E+03,1.2983E+01/
      DATA ((KB(JS,JT,48,11),JS=1,5),JT=1,5) /
     &8.4035E+03,6.3029E+03,4.2022E+03,2.1016E+03,1.0897E+01,
     &9.8931E+03,7.4200E+03,4.9470E+03,2.4739E+03,1.1706E+01,
     &1.1589E+04,8.6922E+03,5.7950E+03,2.8979E+03,1.2313E+01,
     &1.3567E+04,1.0175E+04,6.7839E+03,3.3922E+03,1.2741E+01,
     &1.5977E+04,1.1983E+04,7.9888E+03,3.9947E+03,1.2994E+01/
      DATA ((KB(JS,JT,49,11),JS=1,5),JT=1,5) /
     &9.3222E+03,6.9919E+03,4.6615E+03,2.3312E+03,1.0633E+01,
     &1.1123E+04,8.3424E+03,5.5619E+03,2.7813E+03,1.1478E+01,
     &1.3212E+04,9.9089E+03,6.6061E+03,3.3034E+03,1.2190E+01,
     &1.5603E+04,1.1702E+04,7.8017E+03,3.9011E+03,1.2697E+01,
     &1.8442E+04,1.3832E+04,9.2215E+03,4.6110E+03,1.3027E+01/
      DATA ((KB(JS,JT,50,11),JS=1,5),JT=1,5) /
     &9.8729E+03,7.4049E+03,4.9369E+03,2.4688E+03,1.0346E+01,
     &1.1927E+04,8.9452E+03,5.9637E+03,2.9822E+03,1.1213E+01,
     &1.4376E+04,1.0782E+04,7.1884E+03,3.5945E+03,1.2042E+01,
     &1.7156E+04,1.2867E+04,8.5782E+03,4.2894E+03,1.2592E+01,
     &2.0387E+04,1.5290E+04,1.0194E+04,5.0970E+03,1.3035E+01/
      DATA ((KB(JS,JT,51,11),JS=1,5),JT=1,5) /
     &1.0246E+04,7.6846E+03,5.1234E+03,2.5621E+03,1.0080E+01,
     &1.2504E+04,9.3781E+03,6.2523E+03,3.1265E+03,1.0959E+01,
     &1.5294E+04,1.1471E+04,7.6476E+03,3.8241E+03,1.1913E+01,
     &1.8483E+04,1.3863E+04,9.2420E+03,4.6213E+03,1.2523E+01,
     &2.2103E+04,1.6577E+04,1.1052E+04,5.5261E+03,1.3008E+01/
      DATA ((KB(JS,JT,52,11),JS=1,5),JT=1,5) /
     &1.0919E+04,8.1898E+03,5.4601E+03,2.7304E+03,9.7365E+00,
     &1.3474E+04,1.0106E+04,6.7375E+03,3.3691E+03,1.0715E+01,
     &1.6692E+04,1.2519E+04,8.3465E+03,4.1736E+03,1.1714E+01,
     &2.0445E+04,1.5334E+04,1.0223E+04,5.1117E+03,1.2415E+01,
     &2.4642E+04,1.8481E+04,1.2321E+04,6.1608E+03,1.2964E+01/
      DATA ((KB(JS,JT,53,11),JS=1,5),JT=1,5) /
     &1.2096E+04,9.0720E+03,6.0483E+03,3.0245E+03,9.3807E+00,
     &1.5115E+04,1.1337E+04,7.5582E+03,3.7794E+03,1.0467E+01,
     &1.8931E+04,1.4199E+04,9.4661E+03,4.7334E+03,1.1520E+01,
     &2.3491E+04,1.7618E+04,1.1746E+04,5.8732E+03,1.2292E+01,
     &2.8602E+04,2.1452E+04,1.4301E+04,7.1510E+03,1.2913E+01/
      DATA ((KB(JS,JT,54,11),JS=1,5),JT=1,5) /
     &1.1628E+04,8.7215E+03,5.8146E+03,2.9077E+03,8.9653E+00,
     &1.4721E+04,1.1041E+04,7.3608E+03,3.6808E+03,1.0130E+01,
     &1.8638E+04,1.3979E+04,9.3193E+03,4.6600E+03,1.1195E+01,
     &2.3417E+04,1.7563E+04,1.1709E+04,5.8547E+03,1.2060E+01,
     &2.8828E+04,2.1621E+04,1.4414E+04,7.2075E+03,1.2739E+01/
      DATA ((KB(JS,JT,55,11),JS=1,5),JT=1,5) /
     &1.0209E+04,7.6567E+03,5.1047E+03,2.5527E+03,8.5323E+00,
     &1.3095E+04,9.8211E+03,6.5477E+03,3.2742E+03,9.7667E+00,
     &1.6780E+04,1.2585E+04,8.3901E+03,4.1954E+03,1.0760E+01,
     &2.1308E+04,1.5981E+04,1.0654E+04,5.3275E+03,1.1787E+01,
     &2.6526E+04,1.9895E+04,1.3264E+04,6.6321E+03,1.2490E+01/
      DATA ((KB(JS,JT,56,11),JS=1,5),JT=1,5) /
     &8.9242E+03,6.6933E+03,4.4624E+03,2.2315E+03,8.1192E+00,
     &1.1623E+04,8.7170E+03,5.8115E+03,2.9061E+03,9.3346E+00,
     &1.5096E+04,1.1322E+04,7.5482E+03,3.7744E+03,1.0408E+01,
     &1.9354E+04,1.4515E+04,9.6771E+03,4.8388E+03,1.1396E+01,
     &2.4338E+04,1.8253E+04,1.2169E+04,6.0847E+03,1.2212E+01/
      DATA ((KB(JS,JT,57,11),JS=1,5),JT=1,5) /
     &7.7622E+03,5.8218E+03,3.8814E+03,1.9410E+03,7.7106E+00,
     &1.0290E+04,7.7178E+03,5.1454E+03,2.5730E+03,8.9363E+00,
     &1.3552E+04,1.0164E+04,6.7760E+03,3.3882E+03,1.0051E+01,
     &1.7543E+04,1.3157E+04,8.7715E+03,4.3860E+03,1.0990E+01,
     &2.2284E+04,1.6713E+04,1.1142E+04,5.5714E+03,1.1934E+01/
      DATA ((KB(JS,JT,58,11),JS=1,5),JT=1,5) /
     &1.7767E+03,1.6290E+03,1.3968E+03,9.7855E+02,7.2858E+00,
     &2.4068E+03,2.2067E+03,1.8922E+03,1.3254E+03,8.5609E+00,
     &3.2122E+03,2.9452E+03,2.5253E+03,1.7688E+03,9.6597E+00,
     &4.2027E+03,3.8533E+03,3.3039E+03,2.3142E+03,1.0637E+01,
     &5.3882E+03,4.9402E+03,4.2359E+03,2.9669E+03,1.1542E+01/
      DATA ((KB(JS,JT,59,11),JS=1,5),JT=1,5) /
     &1.9233E+03,1.6794E+03,1.3397E+03,8.3393E+02,7.1275E+00,
     &2.6585E+03,2.3214E+03,1.8518E+03,1.1525E+03,8.4302E+00,
     &3.5898E+03,3.1345E+03,2.5004E+03,1.5561E+03,9.5360E+00,
     &4.7292E+03,4.1294E+03,3.2940E+03,2.0499E+03,1.0472E+01,
     &6.0902E+03,5.3178E+03,4.2419E+03,2.6398E+03,1.1150E+01/
      DATA ((KB(JS,JT,13,12),JS=1,5),JT=1,5) /
     &2.7240E+05,2.0430E+05,1.3620E+05,6.8101E+04,4.4161E+00,
     &2.7176E+05,2.0382E+05,1.3588E+05,6.7942E+04,4.2840E+00,
     &2.7001E+05,2.0251E+05,1.3501E+05,6.7503E+04,4.1173E+00,
     &2.6763E+05,2.0073E+05,1.3382E+05,6.6909E+04,3.9336E+00,
     &2.6442E+05,1.9831E+05,1.3221E+05,6.6105E+04,3.6961E+00/
      DATA ((KB(JS,JT,14,12),JS=1,5),JT=1,5) /
     &1.8113E+05,1.3585E+05,9.0565E+04,4.5283E+04,4.8454E+00,
     &1.8030E+05,1.3523E+05,9.0150E+04,4.5075E+04,4.6873E+00,
     &1.7856E+05,1.3392E+05,8.9279E+04,4.4640E+04,4.6210E+00,
     &1.7661E+05,1.3246E+05,8.8303E+04,4.4152E+04,4.4506E+00,
     &1.7414E+05,1.3060E+05,8.7069E+04,4.3535E+04,4.3231E+00/
      DATA ((KB(JS,JT,15,12),JS=1,5),JT=1,5) /
     &1.2085E+05,9.0635E+04,6.0424E+04,3.0213E+04,5.3476E+00,
     &1.1987E+05,8.9903E+04,5.9936E+04,2.9969E+04,5.2285E+00,
     &1.1863E+05,8.8976E+04,5.9318E+04,2.9660E+04,5.0918E+00,
     &1.1686E+05,8.7649E+04,5.8433E+04,2.9217E+04,4.9903E+00,
     &1.1485E+05,8.6139E+04,5.7427E+04,2.8714E+04,4.7856E+00/
      DATA ((KB(JS,JT,16,12),JS=1,5),JT=1,5) /
     &9.4371E+04,7.0779E+04,4.7186E+04,2.3593E+04,5.9193E+00,
     &9.3237E+04,6.9928E+04,4.6619E+04,2.3310E+04,5.7778E+00,
     &9.1868E+04,6.8901E+04,4.5935E+04,2.2968E+04,5.6214E+00,
     &9.0372E+04,6.7780E+04,4.5187E+04,2.2594E+04,5.5103E+00,
     &8.8699E+04,6.6525E+04,4.4350E+04,2.2176E+04,5.3472E+00/
      DATA ((KB(JS,JT,17,12),JS=1,5),JT=1,5) /
     &7.4737E+04,5.6053E+04,3.7369E+04,1.8685E+04,6.5296E+00,
     &7.3678E+04,5.5259E+04,3.6840E+04,1.8420E+04,6.3899E+00,
     &7.2463E+04,5.4347E+04,3.6232E+04,1.8116E+04,6.2234E+00,
     &7.1178E+04,5.3383E+04,3.5589E+04,1.7795E+04,6.1262E+00,
     &6.9846E+04,5.2385E+04,3.4923E+04,1.7462E+04,6.0038E+00/
      DATA ((KB(JS,JT,18,12),JS=1,5),JT=1,5) /
     &5.9561E+04,4.4671E+04,2.9781E+04,1.4891E+04,7.2106E+00,
     &5.8573E+04,4.3930E+04,2.9287E+04,1.4644E+04,7.0772E+00,
     &5.7514E+04,4.3136E+04,2.8757E+04,1.4379E+04,6.9067E+00,
     &5.6474E+04,4.2356E+04,2.8238E+04,1.4119E+04,6.7942E+00,
     &5.5403E+04,4.1552E+04,2.7702E+04,1.3851E+04,6.6477E+00/
      DATA ((KB(JS,JT,19,12),JS=1,5),JT=1,5) /
     &4.5689E+04,3.4267E+04,2.2845E+04,1.1423E+04,7.9750E+00,
     &4.4876E+04,3.3657E+04,2.2438E+04,1.1220E+04,7.8278E+00,
     &4.4040E+04,3.3030E+04,2.2021E+04,1.1011E+04,7.6237E+00,
     &4.3227E+04,3.2420E+04,2.1614E+04,1.0807E+04,7.5070E+00,
     &4.2374E+04,3.1781E+04,2.1187E+04,1.0594E+04,7.3430E+00/
      DATA ((KB(JS,JT,20,12),JS=1,5),JT=1,5) /
     &3.7246E+04,2.7935E+04,1.8623E+04,9.3122E+03,8.8153E+00,
     &3.6550E+04,2.7413E+04,1.8276E+04,9.1383E+03,8.6532E+00,
     &3.5840E+04,2.6880E+04,1.7920E+04,8.9607E+03,8.4391E+00,
     &3.5149E+04,2.6362E+04,1.7575E+04,8.7878E+03,8.2995E+00,
     &3.4405E+04,2.5804E+04,1.7203E+04,8.6018E+03,8.1167E+00/
      DATA ((KB(JS,JT,21,12),JS=1,5),JT=1,5) /
     &3.0709E+04,2.3032E+04,1.5355E+04,7.6780E+03,9.7372E+00,
     &3.0108E+04,2.2581E+04,1.5055E+04,7.5277E+03,9.5645E+00,
     &2.9509E+04,2.2132E+04,1.4755E+04,7.3780E+03,9.3267E+00,
     &2.8892E+04,2.1670E+04,1.4447E+04,7.2238E+03,9.1690E+00,
     &2.8241E+04,2.1181E+04,1.4121E+04,7.0607E+03,8.9671E+00/
      DATA ((KB(JS,JT,22,12),JS=1,5),JT=1,5) /
     &2.5484E+04,1.9113E+04,1.2742E+04,6.3717E+03,1.0681E+01,
     &2.4964E+04,1.8723E+04,1.2483E+04,6.2417E+03,1.0497E+01,
     &2.4423E+04,1.8317E+04,1.2212E+04,6.1064E+03,1.0234E+01,
     &2.3869E+04,1.7902E+04,1.1935E+04,5.9678E+03,1.0059E+01,
     &2.3286E+04,1.7465E+04,1.1643E+04,5.8221E+03,9.8315E+00/
      DATA ((KB(JS,JT,23,12),JS=1,5),JT=1,5) /
     &2.0918E+04,1.5688E+04,1.0459E+04,5.2302E+03,1.1614E+01,
     &2.0451E+04,1.5339E+04,1.0226E+04,5.1135E+03,1.1417E+01,
     &1.9969E+04,1.4977E+04,9.9848E+03,4.9928E+03,1.1125E+01,
     &1.9481E+04,1.4611E+04,9.7407E+03,4.8708E+03,1.0942E+01,
     &1.8998E+04,1.4249E+04,9.4994E+03,4.7501E+03,1.0699E+01/
      DATA ((KB(JS,JT,24,12),JS=1,5),JT=1,5) /
     &1.6828E+04,1.2621E+04,8.4145E+03,4.2078E+03,1.2522E+01,
     &1.6415E+04,1.2311E+04,8.2079E+03,4.1044E+03,1.2299E+01,
     &1.6005E+04,1.2004E+04,8.0027E+03,4.0018E+03,1.2004E+01,
     &1.5632E+04,1.1724E+04,7.8164E+03,3.9086E+03,1.1796E+01,
     &1.5350E+04,1.1513E+04,7.6755E+03,3.8381E+03,1.1532E+01/
      DATA ((KB(JS,JT,25,12),JS=1,5),JT=1,5) /
     &1.3517E+04,1.0138E+04,6.7590E+03,3.3800E+03,1.3378E+01,
     &1.3176E+04,9.8826E+03,6.5887E+03,3.2948E+03,1.3150E+01,
     &1.2900E+04,9.6753E+03,6.4505E+03,3.2257E+03,1.2858E+01,
     &1.2719E+04,9.5392E+03,6.3597E+03,3.1803E+03,1.2628E+01,
     &1.2623E+04,9.4672E+03,6.3117E+03,3.1562E+03,1.2342E+01/
      DATA ((KB(JS,JT,26,12),JS=1,5),JT=1,5) /
     &1.0917E+04,8.1877E+03,5.4588E+03,2.7299E+03,1.4213E+01,
     &1.0711E+04,8.0332E+03,5.3557E+03,2.6783E+03,1.3979E+01,
     &1.0602E+04,7.9514E+03,5.3012E+03,2.6510E+03,1.3677E+01,
     &1.0604E+04,7.9535E+03,5.3026E+03,2.6517E+03,1.3410E+01,
     &1.0730E+04,8.0477E+03,5.3654E+03,2.6831E+03,1.3099E+01/
      DATA ((KB(JS,JT,27,12),JS=1,5),JT=1,5) /
     &9.1749E+03,6.8814E+03,4.5879E+03,2.2944E+03,1.5000E+01,
     &9.1157E+03,6.8370E+03,4.5583E+03,2.2796E+03,1.4706E+01,
     &9.1873E+03,6.8907E+03,4.5941E+03,2.2975E+03,1.4431E+01,
     &9.3840E+03,7.0382E+03,4.6924E+03,2.3467E+03,1.4137E+01,
     &9.6488E+03,7.2368E+03,4.8249E+03,2.4129E+03,1.3775E+01/
      DATA ((KB(JS,JT,28,12),JS=1,5),JT=1,5) /
     &8.0307E+03,6.0232E+03,4.0158E+03,2.0083E+03,1.5711E+01,
     &8.1446E+03,6.1087E+03,4.0727E+03,2.0368E+03,1.5384E+01,
     &8.3784E+03,6.2841E+03,4.1897E+03,2.0953E+03,1.5123E+01,
     &8.6648E+03,6.4989E+03,4.3329E+03,2.1669E+03,1.4791E+01,
     &9.0065E+03,6.7551E+03,4.5037E+03,2.2523E+03,1.4343E+01/
      DATA ((KB(JS,JT,29,12),JS=1,5),JT=1,5) /
     &7.6471E+03,5.7356E+03,3.8240E+03,1.9124E+03,1.6341E+01,
     &7.9071E+03,5.9306E+03,3.9540E+03,1.9775E+03,1.6013E+01,
     &8.2292E+03,6.1721E+03,4.1151E+03,2.0580E+03,1.5732E+01,
     &8.6240E+03,6.4682E+03,4.3125E+03,2.1567E+03,1.5372E+01,
     &9.0598E+03,6.7951E+03,4.5304E+03,2.2657E+03,1.4767E+01/
      DATA ((KB(JS,JT,30,12),JS=1,5),JT=1,5) /
     &7.6323E+03,5.7245E+03,3.8166E+03,1.9088E+03,1.6832E+01,
     &7.9856E+03,5.9894E+03,3.9933E+03,1.9972E+03,1.6592E+01,
     &8.4256E+03,6.3195E+03,4.2133E+03,2.1072E+03,1.6260E+01,
     &8.9027E+03,6.6772E+03,4.4518E+03,2.2264E+03,1.5767E+01,
     &9.4138E+03,7.0606E+03,4.7073E+03,2.3541E+03,1.5140E+01/
      DATA ((KB(JS,JT,31,12),JS=1,5),JT=1,5) /
     &8.1459E+03,6.1097E+03,4.0735E+03,2.0373E+03,1.7334E+01,
     &8.6243E+03,6.4685E+03,4.3127E+03,2.1569E+03,1.7064E+01,
     &9.1518E+03,6.8642E+03,4.5764E+03,2.2887E+03,1.6609E+01,
     &9.7356E+03,7.3019E+03,4.8683E+03,2.4346E+03,1.5848E+01,
     &1.0365E+04,7.7736E+03,5.1827E+03,2.5918E+03,1.5376E+01/
      DATA ((KB(JS,JT,32,12),JS=1,5),JT=1,5) /
     &8.9083E+03,6.6815E+03,4.4547E+03,2.2279E+03,1.7730E+01,
     &9.4979E+03,7.1237E+03,4.7495E+03,2.3753E+03,1.7331E+01,
     &1.0147E+04,7.6108E+03,5.0742E+03,2.5376E+03,1.6589E+01,
     &1.0867E+04,8.1507E+03,5.4341E+03,2.7175E+03,1.6156E+01,
     &1.1646E+04,8.7350E+03,5.8236E+03,2.9122E+03,1.5848E+01/
      DATA ((KB(JS,JT,33,12),JS=1,5),JT=1,5) /
     &9.9979E+03,7.4987E+03,4.9995E+03,2.5003E+03,1.7989E+01,
     &1.0743E+04,8.0578E+03,5.3722E+03,2.6866E+03,1.7365E+01,
     &1.1568E+04,8.6761E+03,5.7844E+03,2.8926E+03,1.6901E+01,
     &1.2466E+04,9.3497E+03,6.2334E+03,3.1171E+03,1.6592E+01,
     &1.3441E+04,1.0081E+04,6.7208E+03,3.3608E+03,1.6160E+01/
      DATA ((KB(JS,JT,34,12),JS=1,5),JT=1,5) /
     &1.1005E+04,8.2543E+03,5.5032E+03,2.7521E+03,1.8094E+01,
     &1.1925E+04,8.9436E+03,5.9627E+03,2.9818E+03,1.7503E+01,
     &1.2929E+04,9.6970E+03,6.4650E+03,3.2329E+03,1.7258E+01,
     &1.4013E+04,1.0510E+04,7.0067E+03,3.5037E+03,1.6964E+01,
     &1.5204E+04,1.1403E+04,7.6022E+03,3.8015E+03,1.6506E+01/
      DATA ((KB(JS,JT,35,12),JS=1,5),JT=1,5) /
     &1.2135E+04,9.1016E+03,6.0680E+03,3.0345E+03,1.8232E+01,
     &1.3244E+04,9.9331E+03,6.6223E+03,3.3116E+03,1.7908E+01,
     &1.4457E+04,1.0843E+04,7.2288E+03,3.6148E+03,1.7659E+01,
     &1.5776E+04,1.1833E+04,7.8886E+03,3.9447E+03,1.7305E+01,
     &1.7218E+04,1.2914E+04,8.6094E+03,4.3051E+03,1.6889E+01/
      DATA ((KB(JS,JT,36,12),JS=1,5),JT=1,5) /
     &1.3247E+04,9.9356E+03,6.6240E+03,3.3125E+03,1.8488E+01,
     &1.4560E+04,1.0920E+04,7.2802E+03,3.6405E+03,1.8270E+01,
     &1.6016E+04,1.2012E+04,8.0085E+03,4.0046E+03,1.8063E+01,
     &1.7602E+04,1.3202E+04,8.8012E+03,4.4010E+03,1.7553E+01,
     &1.9328E+04,1.4496E+04,9.6641E+03,4.8324E+03,1.7048E+01/
      DATA ((KB(JS,JT,37,12),JS=1,5),JT=1,5) /
     &1.3952E+04,1.0464E+04,6.9765E+03,3.4887E+03,1.8801E+01,
     &1.5457E+04,1.1593E+04,7.7287E+03,3.8648E+03,1.8637E+01,
     &1.7141E+04,1.2856E+04,8.5707E+03,4.2857E+03,1.8420E+01,
     &1.8985E+04,1.4239E+04,9.4928E+03,4.7467E+03,1.7805E+01,
     &2.0966E+04,1.5724E+04,1.0483E+04,5.2419E+03,1.7343E+01/
      DATA ((KB(JS,JT,38,12),JS=1,5),JT=1,5) /
     &1.4936E+04,1.1202E+04,7.4684E+03,3.7346E+03,1.9067E+01,
     &1.6693E+04,1.2520E+04,8.3467E+03,4.1737E+03,1.8968E+01,
     &1.8667E+04,1.4000E+04,9.3337E+03,4.6672E+03,1.8667E+01,
     &2.0838E+04,1.5628E+04,1.0419E+04,5.2098E+03,1.8090E+01,
     &2.3152E+04,1.7364E+04,1.1576E+04,5.7883E+03,1.7634E+01/
      DATA ((KB(JS,JT,39,12),JS=1,5),JT=1,5) /
     &1.6411E+04,1.2309E+04,8.2062E+03,4.1035E+03,1.9362E+01,
     &1.8520E+04,1.3890E+04,9.2603E+03,4.6305E+03,1.9256E+01,
     &2.0878E+04,1.5659E+04,1.0439E+04,5.2200E+03,1.8842E+01,
     &2.3481E+04,1.7611E+04,1.1741E+04,5.8709E+03,1.8427E+01,
     &2.6258E+04,1.9693E+04,1.3129E+04,6.5649E+03,1.8005E+01/
      DATA ((KB(JS,JT,40,12),JS=1,5),JT=1,5) /
     &1.6779E+04,1.2584E+04,8.3898E+03,4.1952E+03,1.9573E+01,
     &1.9118E+04,1.4339E+04,9.5593E+03,4.7800E+03,1.9496E+01,
     &2.1747E+04,1.6310E+04,1.0874E+04,5.4372E+03,1.9078E+01,
     &2.4641E+04,1.8481E+04,1.2321E+04,6.1605E+03,1.8680E+01,
     &2.7741E+04,2.0806E+04,1.3871E+04,6.9356E+03,1.8305E+01/
      DATA ((KB(JS,JT,41,12),JS=1,5),JT=1,5) /
     &1.7108E+04,1.2831E+04,8.5543E+03,4.2775E+03,1.9752E+01,
     &1.9696E+04,1.4772E+04,9.8483E+03,4.9245E+03,1.9665E+01,
     &2.2603E+04,1.6953E+04,1.1302E+04,5.6514E+03,1.9347E+01,
     &2.5797E+04,1.9348E+04,1.2899E+04,6.4497E+03,1.8925E+01,
     &2.9237E+04,2.1928E+04,1.4619E+04,7.3098E+03,1.8587E+01/
      DATA ((KB(JS,JT,42,12),JS=1,5),JT=1,5) /
     &1.7650E+04,1.3238E+04,8.8253E+03,4.4130E+03,1.9913E+01,
     &2.0552E+04,1.5414E+04,1.0276E+04,5.1385E+03,1.9817E+01,
     &2.3780E+04,1.7835E+04,1.1890E+04,5.9455E+03,1.9487E+01,
     &2.7331E+04,2.0498E+04,1.3666E+04,6.8331E+03,1.9141E+01,
     &3.1174E+04,2.3380E+04,1.5587E+04,7.7938E+03,1.8842E+01/
      DATA ((KB(JS,JT,43,12),JS=1,5),JT=1,5) /
     &1.8226E+04,1.3670E+04,9.1135E+03,4.5571E+03,2.0107E+01,
     &2.1466E+04,1.6100E+04,1.0734E+04,5.3672E+03,1.9969E+01,
     &2.5067E+04,1.8800E+04,1.2534E+04,6.2672E+03,1.9715E+01,
     &2.9022E+04,2.1767E+04,1.4512E+04,7.2561E+03,1.9331E+01,
     &3.3314E+04,2.4986E+04,1.6658E+04,8.3291E+03,1.9158E+01/
      DATA ((KB(JS,JT,44,12),JS=1,5),JT=1,5) /
     &1.9005E+04,1.4254E+04,9.5029E+03,4.7518E+03,2.0271E+01,
     &2.2627E+04,1.6970E+04,1.1314E+04,5.6570E+03,2.0045E+01,
     &2.6689E+04,2.0017E+04,1.3345E+04,6.6725E+03,1.9909E+01,
     &3.1132E+04,2.3349E+04,1.5566E+04,7.7832E+03,1.9596E+01,
     &3.5955E+04,2.6966E+04,1.7978E+04,8.9890E+03,1.9454E+01/
      DATA ((KB(JS,JT,45,12),JS=1,5),JT=1,5) /
     &2.0230E+04,1.5173E+04,1.0115E+04,5.0580E+03,2.0360E+01,
     &2.4315E+04,1.8237E+04,1.2158E+04,6.0793E+03,2.0061E+01,
     &2.8985E+04,2.1739E+04,1.4493E+04,7.2467E+03,2.0123E+01,
     &3.4069E+04,2.5552E+04,1.7035E+04,8.5176E+03,1.9825E+01,
     &3.9583E+04,2.9687E+04,1.9792E+04,9.8961E+03,1.9819E+01/
      DATA ((KB(JS,JT,46,12),JS=1,5),JT=1,5) /
     &2.1692E+04,1.6269E+04,1.0846E+04,5.4233E+03,2.0397E+01,
     &2.6275E+04,1.9706E+04,1.3138E+04,6.5691E+03,2.0140E+01,
     &3.1629E+04,2.3722E+04,1.5815E+04,7.9076E+03,2.0308E+01,
     &3.7518E+04,2.8139E+04,1.8759E+04,9.3799E+03,2.0045E+01,
     &4.3856E+04,3.2892E+04,2.1928E+04,1.0964E+04,2.0102E+01/
      DATA ((KB(JS,JT,47,12),JS=1,5),JT=1,5) /
     &2.2886E+04,1.7165E+04,1.1443E+04,5.7220E+03,2.0376E+01,
     &2.7889E+04,2.0917E+04,1.3945E+04,6.9727E+03,2.0171E+01,
     &3.3867E+04,2.5401E+04,1.6934E+04,8.4673E+03,2.0409E+01,
     &4.0597E+04,3.0448E+04,2.0299E+04,1.0150E+04,2.0291E+01,
     &4.7822E+04,3.5866E+04,2.3911E+04,1.1956E+04,2.0384E+01/
      DATA ((KB(JS,JT,48,12),JS=1,5),JT=1,5) /
     &2.4867E+04,1.8651E+04,1.2434E+04,6.2173E+03,2.0295E+01,
     &3.0432E+04,2.2824E+04,1.5216E+04,7.6085E+03,2.0270E+01,
     &3.7235E+04,2.7926E+04,1.8618E+04,9.3091E+03,2.0484E+01,
     &4.5063E+04,3.3797E+04,2.2532E+04,1.1266E+04,2.0580E+01,
     &5.3530E+04,4.0148E+04,2.6765E+04,1.3383E+04,2.0621E+01/
      DATA ((KB(JS,JT,49,12),JS=1,5),JT=1,5) /
     &2.8095E+04,2.1071E+04,1.4048E+04,7.0242E+03,2.0197E+01,
     &3.4618E+04,2.5963E+04,1.7309E+04,8.6547E+03,2.0319E+01,
     &4.2591E+04,3.1943E+04,2.1296E+04,1.0648E+04,2.0559E+01,
     &5.1945E+04,3.8959E+04,2.5973E+04,1.2987E+04,2.0853E+01,
     &6.2325E+04,4.6744E+04,3.1163E+04,1.5581E+04,2.0890E+01/
      DATA ((KB(JS,JT,50,12),JS=1,5),JT=1,5) /
     &3.0354E+04,2.2766E+04,1.5178E+04,7.5891E+03,2.0062E+01,
     &3.7734E+04,2.8300E+04,1.8867E+04,9.4338E+03,2.0363E+01,
     &4.6589E+04,3.4942E+04,2.3295E+04,1.1648E+04,2.0543E+01,
     &5.7214E+04,4.2910E+04,2.8607E+04,1.4304E+04,2.0993E+01,
     &6.9238E+04,5.1929E+04,3.4619E+04,1.7310E+04,2.1035E+01/
      DATA ((KB(JS,JT,51,12),JS=1,5),JT=1,5) /
     &3.2115E+04,2.4086E+04,1.6058E+04,8.0292E+03,1.9809E+01,
     &4.0277E+04,3.0208E+04,2.0139E+04,1.0070E+04,2.0313E+01,
     &4.9958E+04,3.7469E+04,2.4979E+04,1.2490E+04,2.0455E+01,
     &6.1681E+04,4.6261E+04,3.0841E+04,1.5421E+04,2.0964E+01,
     &7.5206E+04,5.6405E+04,3.7603E+04,1.8802E+04,2.1060E+01/
      DATA ((KB(JS,JT,52,12),JS=1,5),JT=1,5) /
     &3.4912E+04,2.6184E+04,1.7456E+04,8.7285E+03,1.9582E+01,
     &4.4146E+04,3.3110E+04,2.2073E+04,1.1037E+04,2.0163E+01,
     &5.5147E+04,4.1361E+04,2.7574E+04,1.3787E+04,2.0386E+01,
     &6.8326E+04,5.1245E+04,3.4163E+04,1.7082E+04,2.0999E+01,
     &8.3853E+04,6.2890E+04,4.1927E+04,2.0964E+04,2.1183E+01/
      DATA ((KB(JS,JT,53,12),JS=1,5),JT=1,5) /
     &3.9402E+04,2.9552E+04,1.9702E+04,9.8513E+03,1.9267E+01,
     &5.0308E+04,3.7732E+04,2.5155E+04,1.2578E+04,1.9908E+01,
     &6.3383E+04,4.7538E+04,3.1692E+04,1.5846E+04,2.0279E+01,
     &7.8778E+04,5.9084E+04,3.9389E+04,1.9695E+04,2.1039E+01,
     &9.7229E+04,7.2923E+04,4.8615E+04,2.4308E+04,2.1293E+01/
      DATA ((KB(JS,JT,54,12),JS=1,5),JT=1,5) /
     &3.8624E+04,2.8968E+04,1.9312E+04,9.6566E+03,1.8946E+01,
     &4.9869E+04,3.7402E+04,2.4935E+04,1.2468E+04,1.9724E+01,
     &6.3267E+04,4.7450E+04,3.1634E+04,1.5817E+04,2.0221E+01,
     &7.9005E+04,5.9254E+04,3.9503E+04,1.9752E+04,2.0891E+01,
     &9.7899E+04,7.3425E+04,4.8950E+04,2.4475E+04,2.1235E+01/
      DATA ((KB(JS,JT,55,12),JS=1,5),JT=1,5) /
     &3.4504E+04,2.5878E+04,1.7253E+04,8.6267E+03,1.8561E+01,
     &4.5154E+04,3.3866E+04,2.2578E+04,1.1289E+04,1.9514E+01,
     &5.7700E+04,4.3275E+04,2.8850E+04,1.4425E+04,2.0143E+01,
     &7.2513E+04,5.4385E+04,3.6257E+04,1.8129E+04,2.0526E+01,
     &9.0097E+04,6.7573E+04,4.5049E+04,2.2525E+04,2.1145E+01/
      DATA ((KB(JS,JT,56,12),JS=1,5),JT=1,5) /
     &3.0670E+04,2.3003E+04,1.5335E+04,7.6681E+03,1.8208E+01,
     &4.0775E+04,3.0581E+04,2.0388E+04,1.0194E+04,1.9345E+01,
     &5.2534E+04,3.9401E+04,2.6267E+04,1.3134E+04,1.9986E+01,
     &6.6490E+04,4.9868E+04,3.3245E+04,1.6623E+04,2.0300E+01,
     &8.2863E+04,6.2147E+04,4.1431E+04,2.0716E+04,2.0929E+01/
      DATA ((KB(JS,JT,57,12),JS=1,5),JT=1,5) /
     &2.7134E+04,2.0351E+04,1.3567E+04,6.7841E+03,1.7766E+01,
     &3.6730E+04,2.7547E+04,1.8365E+04,9.1827E+03,1.8983E+01,
     &4.7798E+04,3.5848E+04,2.3899E+04,1.1950E+04,1.9837E+01,
     &6.0858E+04,4.5644E+04,3.0429E+04,1.5215E+04,2.0288E+01,
     &7.6170E+04,5.7127E+04,3.8085E+04,1.9043E+04,2.0539E+01/
      DATA ((KB(JS,JT,58,12),JS=1,5),JT=1,5) /
     &6.3468E+03,5.8191E+03,4.9895E+03,3.4949E+03,1.7351E+01,
     &8.7238E+03,7.9984E+03,6.8580E+03,4.8035E+03,1.8673E+01,
     &1.1493E+04,1.0537E+04,9.0349E+03,6.3281E+03,1.9708E+01,
     &1.4729E+04,1.3504E+04,1.1579E+04,8.1099E+03,2.0210E+01,
     &1.8531E+04,1.6990E+04,1.4568E+04,1.0203E+04,2.0346E+01/
      DATA ((KB(JS,JT,59,12),JS=1,5),JT=1,5) /
     &7.0593E+03,6.1640E+03,4.9170E+03,3.0600E+03,1.7147E+01,
     &9.7799E+03,8.5396E+03,6.8118E+03,4.2390E+03,1.8584E+01,
     &1.2964E+04,1.1320E+04,9.0293E+03,5.6188E+03,1.9434E+01,
     &1.6671E+04,1.4556E+04,1.1611E+04,7.2253E+03,2.0175E+01,
     &2.1035E+04,1.8367E+04,1.4651E+04,9.1168E+03,2.0516E+01/
      DATA ((KB(JS,JT,13,13),JS=1,5),JT=1,5) /
     &3.8843E+05,2.9132E+05,1.9422E+05,9.7109E+04,5.4111E+00,
     &3.8116E+05,2.8587E+05,1.9058E+05,9.5291E+04,5.1021E+00,
     &3.7364E+05,2.8023E+05,1.8682E+05,9.3410E+04,4.8974E+00,
     &3.6551E+05,2.7413E+05,1.8276E+05,9.1378E+04,4.4934E+00,
     &3.5750E+05,2.6813E+05,1.7875E+05,8.9377E+04,3.9773E+00/
      DATA ((KB(JS,JT,14,13),JS=1,5),JT=1,5) /
     &2.5525E+05,1.9143E+05,1.2762E+05,6.3811E+04,5.8071E+00,
     &2.5096E+05,1.8822E+05,1.2548E+05,6.2740E+04,5.6102E+00,
     &2.4685E+05,1.8514E+05,1.2343E+05,6.1713E+04,5.4048E+00,
     &2.4253E+05,1.8190E+05,1.2126E+05,6.0632E+04,5.2557E+00,
     &2.3845E+05,1.7884E+05,1.1922E+05,5.9612E+04,4.9044E+00/
      DATA ((KB(JS,JT,15,13),JS=1,5),JT=1,5) /
     &1.7262E+05,1.2947E+05,8.6313E+04,4.3157E+04,6.3397E+00,
     &1.7029E+05,1.2772E+05,8.5146E+04,4.2574E+04,6.1559E+00,
     &1.6778E+05,1.2583E+05,8.3891E+04,4.1946E+04,5.9275E+00,
     &1.6564E+05,1.2423E+05,8.2824E+04,4.1413E+04,5.8142E+00,
     &1.6363E+05,1.2273E+05,8.1819E+04,4.0910E+04,5.6466E+00/
      DATA ((KB(JS,JT,16,13),JS=1,5),JT=1,5) /
     &1.3945E+05,1.0459E+05,6.9724E+04,3.4863E+04,7.0725E+00,
     &1.3799E+05,1.0349E+05,6.8996E+04,3.4499E+04,6.9039E+00,
     &1.3667E+05,1.0250E+05,6.8336E+04,3.4169E+04,6.6526E+00,
     &1.3532E+05,1.0149E+05,6.7659E+04,3.3830E+04,6.5506E+00,
     &1.3401E+05,1.0051E+05,6.7008E+04,3.3505E+04,6.3946E+00/
      DATA ((KB(JS,JT,17,13),JS=1,5),JT=1,5) /
     &1.1728E+05,8.7962E+04,5.8642E+04,2.9322E+04,7.9743E+00,
     &1.1635E+05,8.7266E+04,5.8178E+04,2.9090E+04,7.7873E+00,
     &1.1534E+05,8.6504E+04,5.7670E+04,2.8835E+04,7.5449E+00,
     &1.1432E+05,8.5738E+04,5.7159E+04,2.8580E+04,7.3894E+00,
     &1.1312E+05,8.4838E+04,5.6559E+04,2.8280E+04,7.2243E+00/
      DATA ((KB(JS,JT,18,13),JS=1,5),JT=1,5) /
     &1.0020E+05,7.5148E+04,5.0099E+04,2.5050E+04,8.9803E+00,
     &9.9423E+04,7.4567E+04,4.9712E+04,2.4856E+04,8.7551E+00,
     &9.8635E+04,7.3977E+04,4.9318E+04,2.4660E+04,8.5049E+00,
     &9.7679E+04,7.3260E+04,4.8840E+04,2.4421E+04,8.3083E+00,
     &9.6616E+04,7.2462E+04,4.8308E+04,2.4155E+04,8.1253E+00/
      DATA ((KB(JS,JT,19,13),JS=1,5),JT=1,5) /
     &8.3124E+04,6.2343E+04,4.1562E+04,2.0782E+04,1.0036E+01,
     &8.2434E+04,6.1826E+04,4.1217E+04,2.0609E+04,9.7882E+00,
     &8.1692E+04,6.1269E+04,4.0847E+04,2.0424E+04,9.5505E+00,
     &8.0821E+04,6.0616E+04,4.0411E+04,2.0206E+04,9.2995E+00,
     &7.9844E+04,5.9883E+04,3.9922E+04,1.9962E+04,9.1204E+00/
      DATA ((KB(JS,JT,20,13),JS=1,5),JT=1,5) /
     &7.3434E+04,5.5076E+04,3.6717E+04,1.8359E+04,1.1173E+01,
     &7.2781E+04,5.4586E+04,3.6391E+04,1.8196E+04,1.0919E+01,
     &7.2073E+04,5.4055E+04,3.6037E+04,1.8019E+04,1.0676E+01,
     &7.1226E+04,5.3419E+04,3.5613E+04,1.7807E+04,1.0406E+01,
     &7.0326E+04,5.2745E+04,3.5164E+04,1.7582E+04,1.0205E+01/
      DATA ((KB(JS,JT,21,13),JS=1,5),JT=1,5) /
     &6.5684E+04,4.9263E+04,3.2843E+04,1.6422E+04,1.2437E+01,
     &6.5060E+04,4.8795E+04,3.2531E+04,1.6266E+04,1.2175E+01,
     &6.4347E+04,4.8261E+04,3.2174E+04,1.6088E+04,1.1913E+01,
     &6.3551E+04,4.7664E+04,3.1776E+04,1.5889E+04,1.1602E+01,
     &6.2699E+04,4.7025E+04,3.1350E+04,1.5676E+04,1.1366E+01/
      DATA ((KB(JS,JT,22,13),JS=1,5),JT=1,5) /
     &5.8992E+04,4.4244E+04,2.9497E+04,1.4749E+04,1.3817E+01,
     &5.8377E+04,4.3783E+04,2.9189E+04,1.4595E+04,1.3522E+01,
     &5.7726E+04,4.3295E+04,2.8863E+04,1.4432E+04,1.3217E+01,
     &5.7003E+04,4.2753E+04,2.8502E+04,1.4252E+04,1.2864E+01,
     &5.6242E+04,4.2182E+04,2.8121E+04,1.4061E+04,1.2581E+01/
      DATA ((KB(JS,JT,23,13),JS=1,5),JT=1,5) /
     &5.2234E+04,3.9176E+04,2.6118E+04,1.3059E+04,1.5301E+01,
     &5.1719E+04,3.8789E+04,2.5860E+04,1.2931E+04,1.4943E+01,
     &5.1144E+04,3.8358E+04,2.5572E+04,1.2787E+04,1.4585E+01,
     &5.0530E+04,3.7898E+04,2.5266E+04,1.2633E+04,1.4170E+01,
     &4.9854E+04,3.7391E+04,2.4928E+04,1.2464E+04,1.3822E+01/
      DATA ((KB(JS,JT,24,13),JS=1,5),JT=1,5) /
     &4.5231E+04,3.3923E+04,2.2616E+04,1.1309E+04,1.6829E+01,
     &4.4807E+04,3.3606E+04,2.2404E+04,1.1203E+04,1.6434E+01,
     &4.4319E+04,3.3240E+04,2.2160E+04,1.1081E+04,1.5981E+01,
     &4.3813E+04,3.2860E+04,2.1907E+04,1.0954E+04,1.5519E+01,
     &4.3229E+04,3.2422E+04,2.1615E+04,1.0808E+04,1.5118E+01/
      DATA ((KB(JS,JT,25,13),JS=1,5),JT=1,5) /
     &3.9084E+04,2.9314E+04,1.9543E+04,9.7719E+03,1.8397E+01,
     &3.8734E+04,2.9050E+04,1.9367E+04,9.6842E+03,1.7930E+01,
     &3.8359E+04,2.8770E+04,1.9180E+04,9.5907E+03,1.7387E+01,
     &3.7930E+04,2.8448E+04,1.8965E+04,9.4832E+03,1.6873E+01,
     &3.7467E+04,2.8100E+04,1.8734E+04,9.3675E+03,1.6400E+01/
      DATA ((KB(JS,JT,26,13),JS=1,5),JT=1,5) /
     &3.3890E+04,2.5418E+04,1.6946E+04,8.4734E+03,1.9920E+01,
     &3.3621E+04,2.5216E+04,1.6811E+04,8.4060E+03,1.9382E+01,
     &3.3332E+04,2.4999E+04,1.6667E+04,8.3338E+03,1.8740E+01,
     &3.3002E+04,2.4752E+04,1.6501E+04,8.2512E+03,1.8176E+01,
     &3.2656E+04,2.4492E+04,1.6328E+04,8.1646E+03,1.7620E+01/
      DATA ((KB(JS,JT,27,13),JS=1,5),JT=1,5) /
     &3.0166E+04,2.2624E+04,1.5083E+04,7.5423E+03,2.1376E+01,
     &2.9996E+04,2.2497E+04,1.4998E+04,7.4998E+03,2.0763E+01,
     &2.9787E+04,2.2341E+04,1.4894E+04,7.4476E+03,2.0015E+01,
     &2.9581E+04,2.2186E+04,1.4791E+04,7.3962E+03,1.9407E+01,
     &2.9406E+04,2.2055E+04,1.4703E+04,7.3522E+03,1.8770E+01/
      DATA ((KB(JS,JT,28,13),JS=1,5),JT=1,5) /
     &2.7326E+04,2.0495E+04,1.3664E+04,6.8324E+03,2.2732E+01,
     &2.7236E+04,2.0428E+04,1.3619E+04,6.8100E+03,2.2041E+01,
     &2.7174E+04,2.0381E+04,1.3588E+04,6.7945E+03,2.1170E+01,
     &2.7191E+04,2.0394E+04,1.3596E+04,6.7985E+03,2.0533E+01,
     &2.7306E+04,2.0480E+04,1.3654E+04,6.8273E+03,1.9803E+01/
      DATA ((KB(JS,JT,29,13),JS=1,5),JT=1,5) /
     &2.6107E+04,1.9580E+04,1.3054E+04,6.5276E+03,2.3952E+01,
     &2.6178E+04,1.9634E+04,1.3090E+04,6.5453E+03,2.3128E+01,
     &2.6373E+04,1.9780E+04,1.3187E+04,6.5941E+03,2.2276E+01,
     &2.6674E+04,2.0006E+04,1.3338E+04,6.6693E+03,2.1526E+01,
     &2.7070E+04,2.0303E+04,1.3535E+04,6.7681E+03,2.0703E+01/
      DATA ((KB(JS,JT,30,13),JS=1,5),JT=1,5) /
     &2.5565E+04,1.9174E+04,1.2783E+04,6.3921E+03,2.5015E+01,
     &2.5924E+04,1.9443E+04,1.2962E+04,6.4818E+03,2.4026E+01,
     &2.6425E+04,1.9819E+04,1.3213E+04,6.6070E+03,2.3238E+01,
     &2.7081E+04,2.0311E+04,1.3541E+04,6.7710E+03,2.2369E+01,
     &2.7860E+04,2.0896E+04,1.3931E+04,6.9658E+03,2.1263E+01/
      DATA ((KB(JS,JT,31,13),JS=1,5),JT=1,5) /
     &2.6519E+04,1.9890E+04,1.3260E+04,6.6306E+03,2.5829E+01,
     &2.7266E+04,2.0450E+04,1.3634E+04,6.8173E+03,2.4917E+01,
     &2.8229E+04,2.1172E+04,1.4115E+04,7.0579E+03,2.4029E+01,
     &2.9353E+04,2.2015E+04,1.4677E+04,7.3390E+03,2.2989E+01,
     &3.0590E+04,2.2943E+04,1.5295E+04,7.6481E+03,2.1638E+01/
      DATA ((KB(JS,JT,32,13),JS=1,5),JT=1,5) /
     &2.8188E+04,2.1141E+04,1.4095E+04,7.0478E+03,2.6468E+01,
     &2.9479E+04,2.2110E+04,1.4740E+04,7.3705E+03,2.5641E+01,
     &3.0998E+04,2.3249E+04,1.5500E+04,7.7503E+03,2.4646E+01,
     &3.2677E+04,2.4508E+04,1.6339E+04,8.1700E+03,2.3083E+01,
     &3.4456E+04,2.5842E+04,1.7228E+04,8.6146E+03,2.1888E+01/
      DATA ((KB(JS,JT,33,13),JS=1,5),JT=1,5) /
     &3.1038E+04,2.3278E+04,1.5519E+04,7.7602E+03,2.7208E+01,
     &3.2999E+04,2.4749E+04,1.6500E+04,8.2505E+03,2.6145E+01,
     &3.5228E+04,2.6421E+04,1.7614E+04,8.8077E+03,2.4544E+01,
     &3.7600E+04,2.8200E+04,1.8800E+04,9.4007E+03,2.3159E+01,
     &4.0073E+04,3.0055E+04,2.0037E+04,1.0019E+04,2.2387E+01/
      DATA ((KB(JS,JT,34,13),JS=1,5),JT=1,5) /
     &3.3858E+04,2.5394E+04,1.6930E+04,8.4653E+03,2.7625E+01,
     &3.6566E+04,2.7425E+04,1.8284E+04,9.1422E+03,2.6243E+01,
     &3.9555E+04,2.9666E+04,1.9778E+04,9.8893E+03,2.4430E+01,
     &4.2704E+04,3.2028E+04,2.1352E+04,1.0677E+04,2.3679E+01,
     &4.5894E+04,3.4420E+04,2.2947E+04,1.1474E+04,2.2773E+01/
      DATA ((KB(JS,JT,35,13),JS=1,5),JT=1,5) /
     &3.7312E+04,2.7984E+04,1.8657E+04,9.3288E+03,2.7942E+01,
     &4.0881E+04,3.0661E+04,2.0441E+04,1.0221E+04,2.6106E+01,
     &4.4738E+04,3.3554E+04,2.2369E+04,1.1185E+04,2.5080E+01,
     &4.8754E+04,3.6566E+04,2.4377E+04,1.2189E+04,2.4179E+01,
     &5.2762E+04,3.9572E+04,2.6381E+04,1.3191E+04,2.3224E+01/
      DATA ((KB(JS,JT,36,13),JS=1,5),JT=1,5) /
     &4.0999E+04,3.0749E+04,2.0500E+04,1.0250E+04,2.8213E+01,
     &4.5493E+04,3.4120E+04,2.2747E+04,1.1374E+04,2.6516E+01,
     &5.0302E+04,3.7726E+04,2.5151E+04,1.2576E+04,2.5690E+01,
     &5.5257E+04,4.1443E+04,2.7629E+04,1.3815E+04,2.4819E+01,
     &6.0175E+04,4.5131E+04,3.0088E+04,1.5044E+04,2.3837E+01/
      DATA ((KB(JS,JT,37,13),JS=1,5),JT=1,5) /
     &4.3597E+04,3.2698E+04,2.1799E+04,1.0900E+04,2.8678E+01,
     &4.8963E+04,3.6723E+04,2.4482E+04,1.2241E+04,2.7079E+01,
     &5.4655E+04,4.0991E+04,2.7328E+04,1.3664E+04,2.6274E+01,
     &6.0506E+04,4.5380E+04,3.0253E+04,1.5127E+04,2.5504E+01,
     &6.6353E+04,4.9765E+04,3.3177E+04,1.6589E+04,2.4385E+01/
      DATA ((KB(JS,JT,38,13),JS=1,5),JT=1,5) /
     &4.7296E+04,3.5472E+04,2.3648E+04,1.1825E+04,2.9114E+01,
     &5.3691E+04,4.0269E+04,2.6846E+04,1.3423E+04,2.7730E+01,
     &6.0448E+04,4.5336E+04,3.0224E+04,1.5113E+04,2.6995E+01,
     &6.7408E+04,5.0556E+04,3.3704E+04,1.6852E+04,2.6164E+01,
     &7.4361E+04,5.5771E+04,3.7181E+04,1.8591E+04,2.5025E+01/
      DATA ((KB(JS,JT,39,13),JS=1,5),JT=1,5) /
     &5.2787E+04,3.9591E+04,2.6394E+04,1.3198E+04,2.9543E+01,
     &6.0481E+04,4.5362E+04,3.0242E+04,1.5121E+04,2.8398E+01,
     &6.8644E+04,5.1483E+04,3.4323E+04,1.7162E+04,2.7686E+01,
     &7.7024E+04,5.7768E+04,3.8513E+04,1.9257E+04,2.6627E+01,
     &8.5404E+04,6.4053E+04,4.2703E+04,2.1352E+04,2.5499E+01/
      DATA ((KB(JS,JT,40,13),JS=1,5),JT=1,5) /
     &5.4787E+04,4.1090E+04,2.7394E+04,1.3697E+04,3.0183E+01,
     &6.3323E+04,4.7492E+04,3.1662E+04,1.5831E+04,2.8961E+01,
     &7.2463E+04,5.4348E+04,3.6232E+04,1.8116E+04,2.8295E+01,
     &8.1867E+04,6.1400E+04,4.0933E+04,2.0467E+04,2.7184E+01,
     &9.1325E+04,6.8494E+04,4.5663E+04,2.2832E+04,2.5988E+01/
      DATA ((KB(JS,JT,41,13),JS=1,5),JT=1,5) /
     &5.6764E+04,4.2573E+04,2.8383E+04,1.4192E+04,3.0791E+01,
     &6.6130E+04,4.9598E+04,3.3066E+04,1.6533E+04,2.9538E+01,
     &7.6243E+04,5.7183E+04,3.8122E+04,1.9062E+04,2.8774E+01,
     &8.6738E+04,6.5054E+04,4.3370E+04,2.1685E+04,2.7771E+01,
     &9.7338E+04,7.3004E+04,4.8670E+04,2.4335E+04,2.6481E+01/
      DATA ((KB(JS,JT,42,13),JS=1,5),JT=1,5) /
     &5.9574E+04,4.4680E+04,2.9787E+04,1.4894E+04,3.1338E+01,
     &6.9874E+04,5.2405E+04,3.4937E+04,1.7469E+04,3.0066E+01,
     &8.1118E+04,6.0839E+04,4.0559E+04,2.0280E+04,2.9330E+01,
     &9.2915E+04,6.9686E+04,4.6457E+04,2.3229E+04,2.8281E+01,
     &1.0485E+05,7.8636E+04,5.2424E+04,2.6212E+04,2.6956E+01/
      DATA ((KB(JS,JT,43,13),JS=1,5),JT=1,5) /
     &6.2565E+04,4.6924E+04,3.1283E+04,1.5642E+04,3.1947E+01,
     &7.3881E+04,5.5411E+04,3.6941E+04,1.8471E+04,3.0710E+01,
     &8.6376E+04,6.4783E+04,4.3189E+04,2.1595E+04,2.9823E+01,
     &9.9633E+04,7.4725E+04,4.9817E+04,2.4909E+04,2.8916E+01,
     &1.1317E+05,8.4879E+04,5.6586E+04,2.8294E+04,2.7433E+01/
      DATA ((KB(JS,JT,44,13),JS=1,5),JT=1,5) /
     &6.6377E+04,4.9783E+04,3.3188E+04,1.6595E+04,3.2537E+01,
     &7.8875E+04,5.9156E+04,3.9437E+04,1.9719E+04,3.1463E+01,
     &9.2826E+04,6.9619E+04,4.6413E+04,2.3207E+04,3.0339E+01,
     &1.0782E+05,8.0864E+04,5.3909E+04,2.6955E+04,2.9519E+01,
     &1.2335E+05,9.2508E+04,6.1672E+04,3.0836E+04,2.7886E+01/
      DATA ((KB(JS,JT,45,13),JS=1,5),JT=1,5) /
     &7.1874E+04,5.3905E+04,3.5937E+04,1.7969E+04,3.3146E+01,
     &8.5887E+04,6.4415E+04,4.2944E+04,2.1472E+04,3.2123E+01,
     &1.0168E+05,7.6262E+04,5.0841E+04,2.5421E+04,3.0727E+01,
     &1.1891E+05,8.9181E+04,5.9454E+04,2.9727E+04,3.0052E+01,
     &1.3695E+05,1.0272E+05,6.8477E+04,3.4239E+04,2.8423E+01/
      DATA ((KB(JS,JT,46,13),JS=1,5),JT=1,5) /
     &7.8328E+04,5.8747E+04,3.9165E+04,1.9583E+04,3.3800E+01,
     &9.4082E+04,7.0562E+04,4.7041E+04,2.3521E+04,3.2751E+01,
     &1.1205E+05,8.4041E+04,5.6028E+04,2.8014E+04,3.1210E+01,
     &1.3188E+05,9.8910E+04,6.5940E+04,3.2971E+04,3.0670E+01,
     &1.5296E+05,1.1472E+05,7.6478E+04,3.8239E+04,2.9020E+01/
      DATA ((KB(JS,JT,47,13),JS=1,5),JT=1,5) /
     &8.3810E+04,6.2858E+04,4.1906E+04,2.0953E+04,3.4456E+01,
     &1.0129E+05,7.5968E+04,5.0646E+04,2.5323E+04,3.3326E+01,
     &1.2133E+05,9.0998E+04,6.0666E+04,3.0333E+04,3.1897E+01,
     &1.4374E+05,1.0781E+05,7.1871E+04,3.5936E+04,3.1165E+01,
     &1.6790E+05,1.2593E+05,8.3952E+04,4.1976E+04,2.9653E+01/
      DATA ((KB(JS,JT,48,13),JS=1,5),JT=1,5) /
     &9.2009E+04,6.9007E+04,4.6005E+04,2.3003E+04,3.5004E+01,
     &1.1207E+05,8.4051E+04,5.6034E+04,2.8018E+04,3.3918E+01,
     &1.3494E+05,1.0121E+05,6.7471E+04,3.3736E+04,3.2425E+01,
     &1.6083E+05,1.2063E+05,8.0418E+04,4.0210E+04,3.1652E+01,
     &1.8920E+05,1.4190E+05,9.4599E+04,4.7300E+04,3.0396E+01/
      DATA ((KB(JS,JT,49,13),JS=1,5),JT=1,5) /
     &1.0515E+05,7.8866E+04,5.2577E+04,2.6289E+04,3.5598E+01,
     &1.2899E+05,9.6745E+04,6.4497E+04,3.2249E+04,3.4541E+01,
     &1.5618E+05,1.1714E+05,7.8092E+04,3.9046E+04,3.3166E+01,
     &1.8721E+05,1.4041E+05,9.3606E+04,4.6803E+04,3.2127E+01,
     &2.2166E+05,1.6624E+05,1.1083E+05,5.5414E+04,3.1114E+01/
      DATA ((KB(JS,JT,50,13),JS=1,5),JT=1,5) /
     &1.1492E+05,8.6190E+04,5.7460E+04,2.8730E+04,3.5920E+01,
     &1.4177E+05,1.0633E+05,7.0884E+04,3.5442E+04,3.5009E+01,
     &1.7284E+05,1.2963E+05,8.6422E+04,4.3212E+04,3.3840E+01,
     &2.0816E+05,1.5612E+05,1.0408E+05,5.2042E+04,3.2614E+01,
     &2.4789E+05,1.8591E+05,1.2394E+05,6.1972E+04,3.1787E+01/
      DATA ((KB(JS,JT,51,13),JS=1,5),JT=1,5) /
     &1.2316E+05,9.2372E+04,6.1582E+04,3.0791E+04,3.6248E+01,
     &1.5257E+05,1.1443E+05,7.6284E+04,3.8142E+04,3.5464E+01,
     &1.8735E+05,1.4051E+05,9.3677E+04,4.6839E+04,3.4431E+01,
     &2.2663E+05,1.6997E+05,1.1332E+05,5.6659E+04,3.2971E+01,
     &2.7128E+05,2.0346E+05,1.3564E+05,6.7820E+04,3.2477E+01/
      DATA ((KB(JS,JT,52,13),JS=1,5),JT=1,5) /
     &1.3564E+05,1.0173E+05,6.7822E+04,3.3911E+04,3.6511E+01,
     &1.6873E+05,1.2655E+05,8.4367E+04,4.2184E+04,3.5955E+01,
     &2.0841E+05,1.5631E+05,1.0421E+05,5.2104E+04,3.4988E+01,
     &2.5356E+05,1.9017E+05,1.2678E+05,6.3390E+04,3.3412E+01,
     &3.0501E+05,2.2876E+05,1.5250E+05,7.6253E+04,3.3108E+01/
      DATA ((KB(JS,JT,53,13),JS=1,5),JT=1,5) /
     &1.5552E+05,1.1664E+05,7.7762E+04,3.8882E+04,3.6856E+01,
     &1.9425E+05,1.4569E+05,9.7128E+04,4.8565E+04,3.6432E+01,
     &2.4103E+05,1.8077E+05,1.2051E+05,6.0258E+04,3.5535E+01,
     &2.9532E+05,2.2149E+05,1.4766E+05,7.3832E+04,3.3878E+01,
     &3.5673E+05,2.6755E+05,1.7837E+05,8.9184E+04,3.3830E+01/
      DATA ((KB(JS,JT,54,13),JS=1,5),JT=1,5) /
     &1.5519E+05,1.1639E+05,7.7595E+04,3.8798E+04,3.7137E+01,
     &1.9455E+05,1.4591E+05,9.7277E+04,4.8639E+04,3.6719E+01,
     &2.4223E+05,1.8167E+05,1.2111E+05,6.0558E+04,3.5737E+01,
     &2.9863E+05,2.2398E+05,1.4932E+05,7.4660E+04,3.4182E+01,
     &3.6225E+05,2.7169E+05,1.8113E+05,9.0564E+04,3.4090E+01/
      DATA ((KB(JS,JT,55,13),JS=1,5),JT=1,5) /
     &1.4179E+05,1.0634E+05,7.0895E+04,3.5448E+04,3.7500E+01,
     &1.7805E+05,1.3354E+05,8.9025E+04,4.4513E+04,3.6673E+01,
     &2.2250E+05,1.6688E+05,1.1125E+05,5.5626E+04,3.6002E+01,
     &2.7565E+05,2.0674E+05,1.3783E+05,6.8913E+04,3.4967E+01,
     &3.3613E+05,2.5210E+05,1.6807E+05,8.4034E+04,3.3605E+01/
      DATA ((KB(JS,JT,56,13),JS=1,5),JT=1,5) /
     &1.2955E+05,9.7160E+04,6.4773E+04,3.2387E+04,3.7592E+01,
     &1.6291E+05,1.2218E+05,8.1452E+04,4.0726E+04,3.6892E+01,
     &2.0430E+05,1.5322E+05,1.0215E+05,5.1074E+04,3.6401E+01,
     &2.5407E+05,1.9055E+05,1.2704E+05,6.3518E+04,3.5416E+01,
     &3.1173E+05,2.3380E+05,1.5586E+05,7.7932E+04,3.3725E+01/
      DATA ((KB(JS,JT,57,13),JS=1,5),JT=1,5) /
     &1.1844E+05,8.8830E+04,5.9220E+04,2.9610E+04,3.7590E+01,
     &1.4902E+05,1.1176E+05,7.4508E+04,3.7254E+04,3.7340E+01,
     &1.8747E+05,1.4060E+05,9.3736E+04,4.6868E+04,3.6437E+01,
     &2.3395E+05,1.7546E+05,1.1697E+05,5.8487E+04,3.5598E+01,
     &2.8870E+05,2.1653E+05,1.4435E+05,7.2175E+04,3.4562E+01/
      DATA ((KB(JS,JT,58,13),JS=1,5),JT=1,5) /
     &2.8654E+04,2.6272E+04,2.2526E+04,1.5777E+04,3.7286E+01,
     &3.6090E+04,3.3089E+04,2.8371E+04,1.9871E+04,3.7547E+01,
     &4.5492E+04,4.1710E+04,3.5762E+04,2.5048E+04,3.6650E+01,
     &5.6953E+04,5.2217E+04,4.4772E+04,3.1358E+04,3.6005E+01,
     &7.0617E+04,6.4745E+04,5.5513E+04,3.8881E+04,3.4983E+01/
      DATA ((KB(JS,JT,59,13),JS=1,5),JT=1,5) /
     &3.2425E+04,2.8312E+04,2.2583E+04,1.4053E+04,3.7337E+01,
     &4.0874E+04,3.5689E+04,2.8468E+04,1.7715E+04,3.7354E+01,
     &5.1569E+04,4.5029E+04,3.5917E+04,2.2350E+04,3.7146E+01,
     &6.4659E+04,5.6458E+04,4.5034E+04,2.8023E+04,3.5794E+01,
     &8.0312E+04,7.0125E+04,5.5936E+04,3.4807E+04,3.4858E+01/
      DATA ((KB(JS,JT,13,14),JS=1,5),JT=1,5) /
     &5.5354E+05,4.1516E+05,2.7677E+05,1.3839E+05,6.6359E+00,
     &5.3662E+05,4.0247E+05,2.6831E+05,1.3416E+05,6.3521E+00,
     &5.2321E+05,3.9241E+05,2.6161E+05,1.3080E+05,6.1777E+00,
     &5.1223E+05,3.8417E+05,2.5612E+05,1.2806E+05,5.8113E+00,
     &5.0254E+05,3.7690E+05,2.5127E+05,1.2564E+05,5.1461E+00/
      DATA ((KB(JS,JT,14,14),JS=1,5),JT=1,5) /
     &3.6531E+05,2.7398E+05,1.8265E+05,9.1327E+04,7.3146E+00,
     &3.5777E+05,2.6833E+05,1.7888E+05,8.9442E+04,7.0661E+00,
     &3.5166E+05,2.6375E+05,1.7583E+05,8.7915E+04,6.6597E+00,
     &3.4675E+05,2.6006E+05,1.7337E+05,8.6687E+04,6.5607E+00,
     &3.4224E+05,2.5668E+05,1.7112E+05,8.5559E+04,6.0728E+00/
      DATA ((KB(JS,JT,15,14),JS=1,5),JT=1,5) /
     &2.5038E+05,1.8779E+05,1.2519E+05,6.2598E+04,8.1437E+00,
     &2.4740E+05,1.8555E+05,1.2370E+05,6.1853E+04,7.8645E+00,
     &2.4508E+05,1.8381E+05,1.2254E+05,6.1272E+04,7.4907E+00,
     &2.4271E+05,1.8203E+05,1.2136E+05,6.0680E+04,7.2641E+00,
     &2.4052E+05,1.8039E+05,1.2026E+05,6.0131E+04,7.0682E+00/
      DATA ((KB(JS,JT,16,14),JS=1,5),JT=1,5) /
     &2.0782E+05,1.5587E+05,1.0391E+05,5.1957E+04,9.0703E+00,
     &2.0661E+05,1.5496E+05,1.0331E+05,5.1654E+04,8.7622E+00,
     &2.0513E+05,1.5385E+05,1.0257E+05,5.1284E+04,8.4635E+00,
     &2.0374E+05,1.5280E+05,1.0187E+05,5.0936E+04,8.1015E+00,
     &2.0191E+05,1.5143E+05,1.0096E+05,5.0479E+04,7.9045E+00/
      DATA ((KB(JS,JT,17,14),JS=1,5),JT=1,5) /
     &1.8037E+05,1.3528E+05,9.0185E+04,4.5093E+04,1.0108E+01,
     &1.7972E+05,1.3479E+05,8.9862E+04,4.4932E+04,9.7857E+00,
     &1.7906E+05,1.3430E+05,8.9533E+04,4.4767E+04,9.4761E+00,
     &1.7788E+05,1.3341E+05,8.8942E+04,4.4472E+04,9.0551E+00,
     &1.7662E+05,1.3247E+05,8.8311E+04,4.4156E+04,8.8726E+00/
      DATA ((KB(JS,JT,18,14),JS=1,5),JT=1,5) /
     &1.6160E+05,1.2120E+05,8.0801E+04,4.0401E+04,1.1327E+01,
     &1.6141E+05,1.2106E+05,8.0704E+04,4.0353E+04,1.1010E+01,
     &1.6076E+05,1.2057E+05,8.0382E+04,4.0192E+04,1.0693E+01,
     &1.6001E+05,1.2001E+05,8.0005E+04,4.0003E+04,1.0193E+01,
     &1.5881E+05,1.1911E+05,7.9406E+04,3.9704E+04,1.0071E+01/
      DATA ((KB(JS,JT,19,14),JS=1,5),JT=1,5) /
     &1.4270E+05,1.0702E+05,7.1350E+04,3.5676E+04,1.2821E+01,
     &1.4247E+05,1.0685E+05,7.1236E+04,3.5619E+04,1.2498E+01,
     &1.4204E+05,1.0653E+05,7.1022E+04,3.5511E+04,1.2171E+01,
     &1.4126E+05,1.0594E+05,7.0629E+04,3.5315E+04,1.1680E+01,
     &1.4024E+05,1.0518E+05,7.0119E+04,3.5060E+04,1.1491E+01/
      DATA ((KB(JS,JT,20,14),JS=1,5),JT=1,5) /
     &1.3563E+05,1.0173E+05,6.7817E+04,3.3909E+04,1.4618E+01,
     &1.3541E+05,1.0156E+05,6.7708E+04,3.3855E+04,1.4263E+01,
     &1.3484E+05,1.0113E+05,6.7419E+04,3.3710E+04,1.3906E+01,
     &1.3404E+05,1.0053E+05,6.7023E+04,3.3512E+04,1.3385E+01,
     &1.3293E+05,9.9699E+04,6.6466E+04,3.3234E+04,1.3122E+01/
      DATA ((KB(JS,JT,21,14),JS=1,5),JT=1,5) /
     &1.3198E+05,9.8983E+04,6.5989E+04,3.2995E+04,1.6661E+01,
     &1.3158E+05,9.8688E+04,6.5792E+04,3.2897E+04,1.6248E+01,
     &1.3094E+05,9.8202E+04,6.5468E+04,3.2735E+04,1.5812E+01,
     &1.3001E+05,9.7504E+04,6.5003E+04,3.2502E+04,1.5225E+01,
     &1.2884E+05,9.6632E+04,6.4422E+04,3.2211E+04,1.4867E+01/
      DATA ((KB(JS,JT,22,14),JS=1,5),JT=1,5) /
     &1.3028E+05,9.7707E+04,6.5139E+04,3.2570E+04,1.8806E+01,
     &1.2981E+05,9.7355E+04,6.4904E+04,3.2452E+04,1.8310E+01,
     &1.2902E+05,9.6763E+04,6.4509E+04,3.2255E+04,1.7798E+01,
     &1.2795E+05,9.5966E+04,6.3978E+04,3.1989E+04,1.7136E+01,
     &1.2666E+05,9.4996E+04,6.3331E+04,3.1666E+04,1.6711E+01/
      DATA ((KB(JS,JT,23,14),JS=1,5),JT=1,5) /
     &1.2794E+05,9.5952E+04,6.3968E+04,3.1985E+04,2.1073E+01,
     &1.2735E+05,9.5515E+04,6.3677E+04,3.1839E+04,2.0511E+01,
     &1.2647E+05,9.4850E+04,6.3234E+04,3.1617E+04,1.9930E+01,
     &1.2537E+05,9.4025E+04,6.2684E+04,3.1342E+04,1.9174E+01,
     &1.2398E+05,9.2985E+04,6.1990E+04,3.0996E+04,1.8667E+01/
      DATA ((KB(JS,JT,24,14),JS=1,5),JT=1,5) /
     &1.2343E+05,9.2570E+04,6.1714E+04,3.0858E+04,2.3485E+01,
     &1.2276E+05,9.2074E+04,6.1383E+04,3.0692E+04,2.2824E+01,
     &1.2194E+05,9.1458E+04,6.0973E+04,3.0487E+04,2.2153E+01,
     &1.2080E+05,9.0601E+04,6.0401E+04,3.0201E+04,2.1291E+01,
     &1.1949E+05,8.9617E+04,5.9745E+04,2.9873E+04,2.0633E+01/
      DATA ((KB(JS,JT,25,14),JS=1,5),JT=1,5) /
     &1.1905E+05,8.9291E+04,5.9528E+04,2.9764E+04,2.5966E+01,
     &1.1853E+05,8.8894E+04,5.9263E+04,2.9632E+04,2.5184E+01,
     &1.1769E+05,8.8271E+04,5.8848E+04,2.9424E+04,2.4373E+01,
     &1.1666E+05,8.7497E+04,5.8331E+04,2.9166E+04,2.3367E+01,
     &1.1542E+05,8.6565E+04,5.7710E+04,2.8855E+04,2.2586E+01/
      DATA ((KB(JS,JT,26,14),JS=1,5),JT=1,5) /
     &1.1553E+05,8.6651E+04,5.7768E+04,2.8884E+04,2.8441E+01,
     &1.1511E+05,8.6329E+04,5.7553E+04,2.8777E+04,2.7500E+01,
     &1.1443E+05,8.5820E+04,5.7213E+04,2.8607E+04,2.6532E+01,
     &1.1356E+05,8.5172E+04,5.6781E+04,2.8391E+04,2.5362E+01,
     &1.1241E+05,8.4309E+04,5.6206E+04,2.8103E+04,2.4468E+01/
      DATA ((KB(JS,JT,27,14),JS=1,5),JT=1,5) /
     &1.1545E+05,8.6587E+04,5.7725E+04,2.8863E+04,3.0839E+01,
     &1.1514E+05,8.6352E+04,5.7568E+04,2.8785E+04,2.9713E+01,
     &1.1466E+05,8.5998E+04,5.7332E+04,2.8667E+04,2.8580E+01,
     &1.1391E+05,8.5436E+04,5.6958E+04,2.8479E+04,2.7213E+01,
     &1.1293E+05,8.4701E+04,5.6467E+04,2.8234E+04,2.6212E+01/
      DATA ((KB(JS,JT,28,14),JS=1,5),JT=1,5) /
     &1.1769E+05,8.8268E+04,5.8845E+04,2.9423E+04,3.3091E+01,
     &1.1765E+05,8.8234E+04,5.8823E+04,2.9412E+04,3.1766E+01,
     &1.1733E+05,8.7997E+04,5.8665E+04,2.9333E+04,3.0463E+01,
     &1.1677E+05,8.7580E+04,5.8387E+04,2.9194E+04,2.8874E+01,
     &1.1593E+05,8.6950E+04,5.7967E+04,2.8984E+04,2.7821E+01/
      DATA ((KB(JS,JT,29,14),JS=1,5),JT=1,5) /
     &1.2676E+05,9.5071E+04,6.3381E+04,3.1691E+04,3.5131E+01,
     &1.2709E+05,9.5318E+04,6.3545E+04,3.1773E+04,3.3613E+01,
     &1.2701E+05,9.5260E+04,6.3507E+04,3.1754E+04,3.1981E+01,
     &1.2660E+05,9.4952E+04,6.3301E+04,3.1651E+04,3.0369E+01,
     &1.2589E+05,9.4414E+04,6.2943E+04,3.1472E+04,2.9250E+01/
      DATA ((KB(JS,JT,30,14),JS=1,5),JT=1,5) /
     &1.3959E+05,1.0469E+05,6.9793E+04,3.4897E+04,3.6931E+01,
     &1.4034E+05,1.0525E+05,7.0169E+04,3.5085E+04,3.5216E+01,
     &1.4057E+05,1.0543E+05,7.0285E+04,3.5143E+04,3.3253E+01,
     &1.4040E+05,1.0530E+05,7.0200E+04,3.5100E+04,3.1871E+01,
     &1.3970E+05,1.0477E+05,6.9850E+04,3.4925E+04,3.0435E+01/
      DATA ((KB(JS,JT,31,14),JS=1,5),JT=1,5) /
     &1.6150E+05,1.2112E+05,8.0748E+04,4.0374E+04,3.8448E+01,
     &1.6274E+05,1.2205E+05,8.1369E+04,4.0685E+04,3.6340E+01,
     &1.6341E+05,1.2256E+05,8.1707E+04,4.0854E+04,3.4532E+01,
     &1.6341E+05,1.2256E+05,8.1706E+04,4.0853E+04,3.3032E+01,
     &1.6281E+05,1.2211E+05,8.1407E+04,4.0704E+04,3.1374E+01/
      DATA ((KB(JS,JT,32,14),JS=1,5),JT=1,5) /
     &1.8902E+05,1.4177E+05,9.4511E+04,4.7256E+04,3.9673E+01,
     &1.9095E+05,1.4322E+05,9.5478E+04,4.7739E+04,3.7210E+01,
     &1.9208E+05,1.4406E+05,9.6041E+04,4.8021E+04,3.5668E+01,
     &1.9230E+05,1.4423E+05,9.6153E+04,4.8077E+04,3.3902E+01,
     &1.9178E+05,1.4383E+05,9.5890E+04,4.7945E+04,3.1255E+01/
      DATA ((KB(JS,JT,33,14),JS=1,5),JT=1,5) /
     &2.2548E+05,1.6911E+05,1.1274E+05,5.6370E+04,4.0253E+01,
     &2.2820E+05,1.7115E+05,1.1410E+05,5.7051E+04,3.8356E+01,
     &2.2980E+05,1.7235E+05,1.1490E+05,5.7450E+04,3.6454E+01,
     &2.3033E+05,1.7275E+05,1.1517E+05,5.7584E+04,3.3797E+01,
     &2.2985E+05,1.7239E+05,1.1492E+05,5.7463E+04,3.1363E+01/
      DATA ((KB(JS,JT,34,14),JS=1,5),JT=1,5) /
     &2.6250E+05,1.9687E+05,1.3125E+05,6.5624E+04,4.1136E+01,
     &2.6605E+05,1.9954E+05,1.3302E+05,6.6512E+04,3.9143E+01,
     &2.6820E+05,2.0115E+05,1.3410E+05,6.7050E+04,3.6807E+01,
     &2.6900E+05,2.0175E+05,1.3450E+05,6.7251E+04,3.3160E+01,
     &2.6861E+05,2.0146E+05,1.3431E+05,6.7153E+04,3.1344E+01/
      DATA ((KB(JS,JT,35,14),JS=1,5),JT=1,5) /
     &3.0587E+05,2.2940E+05,1.5293E+05,7.6467E+04,4.2099E+01,
     &3.1048E+05,2.3286E+05,1.5524E+05,7.7621E+04,3.9785E+01,
     &3.1341E+05,2.3506E+05,1.5670E+05,7.8352E+04,3.6072E+01,
     &3.1462E+05,2.3596E+05,1.5731E+05,7.8655E+04,3.3490E+01,
     &3.1438E+05,2.3579E+05,1.5719E+05,7.8596E+04,3.1828E+01/
      DATA ((KB(JS,JT,36,14),JS=1,5),JT=1,5) /
     &3.5380E+05,2.6535E+05,1.7690E+05,8.8450E+04,4.2948E+01,
     &3.5987E+05,2.6990E+05,1.7993E+05,8.9967E+04,3.9945E+01,
     &3.6383E+05,2.7287E+05,1.8191E+05,9.0957E+04,3.5908E+01,
     &3.6571E+05,2.7429E+05,1.8286E+05,9.1429E+04,3.3881E+01,
     &3.6576E+05,2.7432E+05,1.8288E+05,9.1441E+04,3.2580E+01/
      DATA ((KB(JS,JT,37,14),JS=1,5),JT=1,5) /
     &3.9789E+05,2.9842E+05,1.9894E+05,9.9472E+04,4.3924E+01,
     &4.0582E+05,3.0436E+05,2.0291E+05,1.0145E+05,4.0613E+01,
     &4.1126E+05,3.0845E+05,2.0563E+05,1.0282E+05,3.6440E+01,
     &4.1422E+05,3.1066E+05,2.0711E+05,1.0355E+05,3.4966E+01,
     &4.1491E+05,3.1118E+05,2.0745E+05,1.0373E+05,3.3736E+01/
      DATA ((KB(JS,JT,38,14),JS=1,5),JT=1,5) /
     &4.5404E+05,3.4053E+05,2.2702E+05,1.1351E+05,4.4908E+01,
     &4.6441E+05,3.4830E+05,2.3220E+05,1.1610E+05,4.0968E+01,
     &4.7167E+05,3.5375E+05,2.3583E+05,1.1792E+05,3.7185E+01,
     &4.7591E+05,3.5693E+05,2.3796E+05,1.1898E+05,3.5958E+01,
     &4.7747E+05,3.5810E+05,2.3873E+05,1.1937E+05,3.4345E+01/
      DATA ((KB(JS,JT,39,14),JS=1,5),JT=1,5) /
     &5.3006E+05,3.9755E+05,2.6503E+05,1.3252E+05,4.5571E+01,
     &5.4370E+05,4.0778E+05,2.7185E+05,1.3593E+05,4.1350E+01,
     &5.5324E+05,4.1494E+05,2.7663E+05,1.3831E+05,3.8461E+01,
     &5.5931E+05,4.1948E+05,2.7966E+05,1.3983E+05,3.7172E+01,
     &5.6198E+05,4.2149E+05,2.8099E+05,1.4050E+05,3.5387E+01/
      DATA ((KB(JS,JT,40,14),JS=1,5),JT=1,5) /
     &5.7962E+05,4.3471E+05,2.8981E+05,1.4490E+05,4.6708E+01,
     &5.9661E+05,4.4745E+05,2.9830E+05,1.4915E+05,4.2510E+01,
     &6.0879E+05,4.5659E+05,3.0439E+05,1.5220E+05,3.9273E+01,
     &6.1695E+05,4.6271E+05,3.0847E+05,1.5424E+05,3.8101E+01,
     &6.2122E+05,4.6592E+05,3.1061E+05,1.5530E+05,3.6493E+01/
      DATA ((KB(JS,JT,41,14),JS=1,5),JT=1,5) /
     &6.3170E+05,4.7378E+05,3.1585E+05,1.5793E+05,4.7871E+01,
     &6.5265E+05,4.8949E+05,3.2633E+05,1.6317E+05,4.3729E+01,
     &6.6799E+05,5.0099E+05,3.3400E+05,1.6700E+05,4.0263E+01,
     &6.7856E+05,5.0892E+05,3.3928E+05,1.6964E+05,3.8971E+01,
     &6.8482E+05,5.1361E+05,3.4241E+05,1.7121E+05,3.7519E+01/
      DATA ((KB(JS,JT,42,14),JS=1,5),JT=1,5) /
     &6.9554E+05,5.2166E+05,3.4777E+05,1.7388E+05,4.9144E+01,
     &7.2122E+05,5.4091E+05,3.6061E+05,1.8030E+05,4.4903E+01,
     &7.4054E+05,5.5540E+05,3.7027E+05,1.8513E+05,4.1239E+01,
     &7.5407E+05,5.6555E+05,3.7703E+05,1.8852E+05,4.0019E+01,
     &7.6271E+05,5.7203E+05,3.8135E+05,1.9067E+05,3.8545E+01/
      DATA ((KB(JS,JT,43,14),JS=1,5),JT=1,5) /
     &7.7014E+05,5.7761E+05,3.8508E+05,1.9254E+05,5.0575E+01,
     &8.0215E+05,6.0161E+05,4.0108E+05,2.0054E+05,4.6180E+01,
     &8.2687E+05,6.2015E+05,4.1344E+05,2.0672E+05,4.2529E+01,
     &8.4441E+05,6.3331E+05,4.2221E+05,2.1110E+05,4.0958E+01,
     &8.5614E+05,6.4211E+05,4.2807E+05,2.1404E+05,3.9632E+01/
      DATA ((KB(JS,JT,44,14),JS=1,5),JT=1,5) /
     &8.6239E+05,6.4679E+05,4.3119E+05,2.1559E+05,5.2080E+01,
     &9.0261E+05,6.7696E+05,4.5130E+05,2.2565E+05,4.7569E+01,
     &9.3442E+05,7.0081E+05,4.6721E+05,2.3360E+05,4.3904E+01,
     &9.5755E+05,7.1816E+05,4.7877E+05,2.3938E+05,4.2000E+01,
     &9.7341E+05,7.3005E+05,4.8670E+05,2.4335E+05,4.0861E+01/
      DATA ((KB(JS,JT,45,14),JS=1,5),JT=1,5) /
     &9.8377E+05,7.3783E+05,4.9189E+05,2.4594E+05,5.3464E+01,
     &1.0352E+06,7.7641E+05,5.1760E+05,2.5880E+05,4.8989E+01,
     &1.0762E+06,8.0713E+05,5.3809E+05,2.6904E+05,4.5355E+01,
     &1.1070E+06,8.3023E+05,5.5349E+05,2.7674E+05,4.3217E+01,
     &1.1287E+06,8.4649E+05,5.6433E+05,2.8216E+05,4.1953E+01/
      DATA ((KB(JS,JT,46,14),JS=1,5),JT=1,5) /
     &1.1307E+06,8.4801E+05,5.6534E+05,2.8267E+05,5.4903E+01,
     &1.1967E+06,8.9750E+05,5.9834E+05,2.9917E+05,5.0473E+01,
     &1.2497E+06,9.3728E+05,6.2485E+05,3.1243E+05,4.7017E+01,
     &1.2910E+06,9.6823E+05,6.4549E+05,3.2274E+05,4.4343E+01,
     &1.3205E+06,9.9037E+05,6.6025E+05,3.3012E+05,4.3085E+01/
      DATA ((KB(JS,JT,47,14),JS=1,5),JT=1,5) /
     &1.2818E+06,9.6133E+05,6.4089E+05,3.2045E+05,5.6436E+01,
     &1.3655E+06,1.0241E+06,6.8273E+05,3.4137E+05,5.2412E+01,
     &1.4341E+06,1.0756E+06,7.1708E+05,3.5854E+05,4.8254E+01,
     &1.4885E+06,1.1164E+06,7.4427E+05,3.7214E+05,4.5497E+01,
     &1.5285E+06,1.1464E+06,7.6425E+05,3.8213E+05,4.4276E+01/
      DATA ((KB(JS,JT,48,14),JS=1,5),JT=1,5) /
     &1.4912E+06,1.1184E+06,7.4558E+05,3.7279E+05,5.8070E+01,
     &1.5992E+06,1.1994E+06,7.9959E+05,3.9979E+05,5.4067E+01,
     &1.6898E+06,1.2674E+06,8.4492E+05,4.2246E+05,5.0095E+01,
     &1.7626E+06,1.3220E+06,8.8132E+05,4.4066E+05,4.6945E+01,
     &1.8180E+06,1.3635E+06,9.0900E+05,4.5450E+05,4.5438E+01/
      DATA ((KB(JS,JT,49,14),JS=1,5),JT=1,5) /
     &1.8033E+06,1.3525E+06,9.0165E+05,4.5083E+05,5.9742E+01,
     &1.9472E+06,1.4604E+06,9.7361E+05,4.8680E+05,5.5654E+01,
     &2.0706E+06,1.5529E+06,1.0353E+06,5.1764E+05,5.1796E+01,
     &2.1711E+06,1.6283E+06,1.0855E+06,5.4277E+05,4.8429E+01,
     &2.2497E+06,1.6872E+06,1.1248E+06,5.6241E+05,4.6805E+01/
      DATA ((KB(JS,JT,50,14),JS=1,5),JT=1,5) /
     &2.0759E+06,1.5569E+06,1.0379E+06,5.1897E+05,6.1720E+01,
     &2.2580E+06,1.6935E+06,1.1290E+06,5.6451E+05,5.7265E+01,
     &2.4154E+06,1.8116E+06,1.2077E+06,6.0386E+05,5.3335E+01,
     &2.5463E+06,1.9097E+06,1.2731E+06,6.3657E+05,5.0026E+01,
     &2.6508E+06,1.9881E+06,1.3254E+06,6.6270E+05,4.7879E+01/
      DATA ((KB(JS,JT,51,14),JS=1,5),JT=1,5) /
     &2.3343E+06,1.7507E+06,1.1671E+06,5.8357E+05,6.3629E+01,
     &2.5583E+06,1.9187E+06,1.2791E+06,6.3957E+05,5.8823E+01,
     &2.7536E+06,2.0652E+06,1.3768E+06,6.8840E+05,5.4830E+01,
     &2.9192E+06,2.1894E+06,1.4596E+06,7.2979E+05,5.1797E+01,
     &3.0520E+06,2.2890E+06,1.5260E+06,7.6300E+05,4.8739E+01/
      DATA ((KB(JS,JT,52,14),JS=1,5),JT=1,5) /
     &2.6927E+06,2.0196E+06,1.3464E+06,6.7319E+05,6.5473E+01,
     &2.9755E+06,2.2317E+06,1.4878E+06,7.4389E+05,6.0202E+01,
     &3.2232E+06,2.4174E+06,1.6116E+06,8.0581E+05,5.6406E+01,
     &3.4356E+06,2.5767E+06,1.7178E+06,8.5891E+05,5.3338E+01,
     &3.6105E+06,2.7079E+06,1.8053E+06,9.0264E+05,4.9535E+01/
      DATA ((KB(JS,JT,53,14),JS=1,5),JT=1,5) /
     &3.2282E+06,2.4212E+06,1.6141E+06,8.0707E+05,6.7136E+01,
     &3.5968E+06,2.6976E+06,1.7984E+06,8.9921E+05,6.1503E+01,
     &3.9238E+06,2.9429E+06,1.9619E+06,9.8097E+05,5.8062E+01,
     &4.2071E+06,3.1553E+06,2.1035E+06,1.0518E+06,5.4982E+01,
     &4.4446E+06,3.3334E+06,2.2223E+06,1.1112E+06,5.0414E+01/
      DATA ((KB(JS,JT,54,14),JS=1,5),JT=1,5) /
     &3.3478E+06,2.5109E+06,1.6739E+06,8.3696E+05,6.8647E+01,
     &3.7598E+06,2.8199E+06,1.8799E+06,9.3996E+05,6.3327E+01,
     &4.1308E+06,3.0981E+06,2.0654E+06,1.0327E+06,5.9705E+01,
     &4.4534E+06,3.3401E+06,2.2267E+06,1.1134E+06,5.5841E+01,
     &4.7287E+06,3.5465E+06,2.3644E+06,1.1822E+06,5.1312E+01/
      DATA ((KB(JS,JT,55,14),JS=1,5),JT=1,5) /
     &3.1636E+06,2.3727E+06,1.5818E+06,7.9090E+05,6.9800E+01,
     &3.5827E+06,2.6870E+06,1.7914E+06,8.9569E+05,6.5650E+01,
     &3.9638E+06,2.9728E+06,1.9819E+06,9.9095E+05,6.0566E+01,
     &4.2985E+06,3.2239E+06,2.1493E+06,1.0746E+06,5.6657E+01,
     &4.5858E+06,3.4394E+06,2.2929E+06,1.1465E+06,5.3531E+01/
      DATA ((KB(JS,JT,56,14),JS=1,5),JT=1,5) /
     &2.9822E+06,2.2367E+06,1.4911E+06,7.4555E+05,7.1031E+01,
     &3.4067E+06,2.5550E+06,1.7033E+06,8.5166E+05,6.7133E+01,
     &3.7967E+06,2.8475E+06,1.8983E+06,9.4915E+05,6.1784E+01,
     &4.1424E+06,3.1068E+06,2.0712E+06,1.0356E+06,5.8142E+01,
     &4.4422E+06,3.3317E+06,2.2211E+06,1.1105E+06,5.4348E+01/
      DATA ((KB(JS,JT,57,14),JS=1,5),JT=1,5) /
     &2.8003E+06,2.1002E+06,1.4001E+06,7.0006E+05,7.2686E+01,
     &3.2322E+06,2.4241E+06,1.6161E+06,8.0804E+05,6.8121E+01,
     &3.6290E+06,2.7217E+06,1.8145E+06,9.0724E+05,6.3933E+01,
     &3.9857E+06,2.9893E+06,1.9928E+06,9.9642E+05,5.9242E+01,
     &4.2966E+06,3.2224E+06,2.1482E+06,1.0741E+06,5.5180E+01/
      DATA ((KB(JS,JT,58,14),JS=1,5),JT=1,5) /
     &6.9277E+05,6.3516E+05,5.4460E+05,3.8143E+05,7.4521E+01,
     &8.0841E+05,7.4119E+05,6.3550E+05,4.4510E+05,6.9466E+01,
     &9.1451E+05,8.3847E+05,7.1891E+05,5.0352E+05,6.5445E+01,
     &1.0112E+06,9.2715E+05,7.9494E+05,5.5677E+05,6.0252E+01,
     &1.0957E+06,1.0046E+06,8.6135E+05,6.0328E+05,5.6261E+01/
      DATA ((KB(JS,JT,59,14),JS=1,5),JT=1,5) /
     &7.9105E+05,6.9072E+05,5.5096E+05,3.4284E+05,7.5082E+01,
     &9.2759E+05,8.0994E+05,6.4605E+05,4.0201E+05,7.0591E+01,
     &1.0529E+06,9.1931E+05,7.3330E+05,4.5630E+05,6.5689E+01,
     &1.1673E+06,1.0193E+06,8.1302E+05,5.0591E+05,6.1427E+01,
     &1.2680E+06,1.1071E+06,8.8311E+05,5.4953E+05,5.7108E+01/
      DATA ((KB(JS,JT,13,15),JS=1,5),JT=1,5) /
     &6.8853E+05,5.1640E+05,3.4427E+05,1.7213E+05,8.3646E+00,
     &6.7841E+05,5.0881E+05,3.3921E+05,1.6961E+05,8.1557E+00,
     &6.7058E+05,5.0293E+05,3.3529E+05,1.6765E+05,7.2355E+00,
     &6.6505E+05,4.9879E+05,3.3253E+05,1.6627E+05,7.1104E+00,
     &6.5977E+05,4.9483E+05,3.2989E+05,1.6494E+05,5.0356E+00/
      DATA ((KB(JS,JT,14,15),JS=1,5),JT=1,5) /
     &4.8859E+05,3.6644E+05,2.4429E+05,1.2215E+05,9.3416E+00,
     &4.8530E+05,3.6397E+05,2.4265E+05,1.2132E+05,9.0997E+00,
     &4.8323E+05,3.6243E+05,2.4161E+05,1.2081E+05,8.4842E+00,
     &4.8076E+05,3.6057E+05,2.4038E+05,1.2019E+05,8.2141E+00,
     &4.7824E+05,3.5868E+05,2.3912E+05,1.1956E+05,7.9624E+00/
      DATA ((KB(JS,JT,15,15),JS=1,5),JT=1,5) /
     &3.5725E+05,2.6794E+05,1.7863E+05,8.9315E+04,1.0416E+01,
     &3.5701E+05,2.6776E+05,1.7851E+05,8.9255E+04,1.0132E+01,
     &3.5620E+05,2.6715E+05,1.7810E+05,8.9053E+04,9.8342E+00,
     &3.5534E+05,2.6651E+05,1.7767E+05,8.8838E+04,8.7353E+00,
     &3.5411E+05,2.6559E+05,1.7706E+05,8.8531E+04,9.0528E+00/
      DATA ((KB(JS,JT,16,15),JS=1,5),JT=1,5) /
     &3.1303E+05,2.3478E+05,1.5652E+05,7.8260E+04,1.1678E+01,
     &3.1296E+05,2.3472E+05,1.5648E+05,7.8243E+04,1.1373E+01,
     &3.1311E+05,2.3483E+05,1.5655E+05,7.8278E+04,1.1063E+01,
     &3.1270E+05,2.3452E+05,1.5635E+05,7.8176E+04,1.0185E+01,
     &3.1216E+05,2.3412E+05,1.5608E+05,7.8040E+04,1.0166E+01/
      DATA ((KB(JS,JT,17,15),JS=1,5),JT=1,5) /
     &2.8440E+05,2.1330E+05,1.4220E+05,7.1101E+04,1.3334E+01,
     &2.8479E+05,2.1359E+05,1.4240E+05,7.1199E+04,1.2996E+01,
     &2.8480E+05,2.1360E+05,1.4240E+05,7.1202E+04,1.2651E+01,
     &2.8481E+05,2.1361E+05,1.4240E+05,7.1203E+04,1.1964E+01,
     &2.8402E+05,2.1301E+05,1.4201E+05,7.1006E+04,1.1649E+01/
      DATA ((KB(JS,JT,18,15),JS=1,5),JT=1,5) /
     &2.6460E+05,1.9845E+05,1.3230E+05,6.6150E+04,1.5350E+01,
     &2.6490E+05,1.9868E+05,1.3245E+05,6.6227E+04,1.4954E+01,
     &2.6505E+05,1.9879E+05,1.3252E+05,6.6263E+04,1.4553E+01,
     &2.6448E+05,1.9836E+05,1.3224E+05,6.6121E+04,1.4057E+01,
     &2.6357E+05,1.9768E+05,1.3179E+05,6.5894E+04,1.3341E+01/
      DATA ((KB(JS,JT,19,15),JS=1,5),JT=1,5) /
     &2.4108E+05,1.8081E+05,1.2054E+05,6.0272E+04,1.7626E+01,
     &2.4160E+05,1.8120E+05,1.2080E+05,6.0400E+04,1.7162E+01,
     &2.4138E+05,1.8103E+05,1.2069E+05,6.0347E+04,1.6660E+01,
     &2.4078E+05,1.8058E+05,1.2039E+05,6.0195E+04,1.6133E+01,
     &2.3956E+05,1.7967E+05,1.1978E+05,5.9892E+04,1.5032E+01/
      DATA ((KB(JS,JT,20,15),JS=1,5),JT=1,5) /
     &2.3801E+05,1.7851E+05,1.1901E+05,5.9503E+04,2.0107E+01,
     &2.3824E+05,1.7868E+05,1.1912E+05,5.9560E+04,1.9545E+01,
     &2.3790E+05,1.7842E+05,1.1895E+05,5.9475E+04,1.8935E+01,
     &2.3694E+05,1.7770E+05,1.1847E+05,5.9235E+04,1.8318E+01,
     &2.3546E+05,1.7659E+05,1.1773E+05,5.8866E+04,1.6971E+01/
      DATA ((KB(JS,JT,21,15),JS=1,5),JT=1,5) /
     &2.4153E+05,1.8115E+05,1.2077E+05,6.0385E+04,2.2844E+01,
     &2.4153E+05,1.8115E+05,1.2076E+05,6.0383E+04,2.2202E+01,
     &2.4090E+05,1.8068E+05,1.2045E+05,6.0226E+04,2.1535E+01,
     &2.3957E+05,1.7968E+05,1.1978E+05,5.9893E+04,2.0842E+01,
     &2.3762E+05,1.7822E+05,1.1881E+05,5.9406E+04,1.9479E+01/
      DATA ((KB(JS,JT,22,15),JS=1,5),JT=1,5) /
     &2.5014E+05,1.8760E+05,1.2507E+05,6.2536E+04,2.6039E+01,
     &2.4958E+05,1.8719E+05,1.2479E+05,6.2397E+04,2.5280E+01,
     &2.4838E+05,1.8628E+05,1.2419E+05,6.2096E+04,2.4490E+01,
     &2.4655E+05,1.8492E+05,1.2328E+05,6.1639E+04,2.3671E+01,
     &2.4402E+05,1.8302E+05,1.2201E+05,6.1006E+04,2.2182E+01/
      DATA ((KB(JS,JT,23,15),JS=1,5),JT=1,5) /
     &2.5892E+05,1.9419E+05,1.2946E+05,6.4730E+04,2.9635E+01,
     &2.5767E+05,1.9325E+05,1.2883E+05,6.4418E+04,2.8708E+01,
     &2.5584E+05,1.9188E+05,1.2792E+05,6.3960E+04,2.7743E+01,
     &2.5321E+05,1.8991E+05,1.2660E+05,6.3303E+04,2.6764E+01,
     &2.5010E+05,1.8758E+05,1.2505E+05,6.2526E+04,2.5122E+01/
      DATA ((KB(JS,JT,24,15),JS=1,5),JT=1,5) /
     &2.6502E+05,1.9877E+05,1.3251E+05,6.6257E+04,3.3543E+01,
     &2.6308E+05,1.9731E+05,1.3154E+05,6.5771E+04,3.2390E+01,
     &2.6033E+05,1.9524E+05,1.3016E+05,6.5082E+04,3.1202E+01,
     &2.5704E+05,1.9278E+05,1.2852E+05,6.4262E+04,3.0027E+01,
     &2.5313E+05,1.8984E+05,1.2656E+05,6.3282E+04,2.8238E+01/
      DATA ((KB(JS,JT,25,15),JS=1,5),JT=1,5) /
     &2.7306E+05,2.0480E+05,1.3653E+05,6.8266E+04,3.7656E+01,
     &2.7003E+05,2.0252E+05,1.3501E+05,6.7507E+04,3.6233E+01,
     &2.6644E+05,1.9983E+05,1.3322E+05,6.6611E+04,3.4804E+01,
     &2.6230E+05,1.9672E+05,1.3115E+05,6.5574E+04,3.3361E+01,
     &2.5745E+05,1.9309E+05,1.2873E+05,6.4363E+04,3.1338E+01/
      DATA ((KB(JS,JT,26,15),JS=1,5),JT=1,5) /
     &2.8347E+05,2.1261E+05,1.4174E+05,7.0869E+04,4.1820E+01,
     &2.7951E+05,2.0963E+05,1.3976E+05,6.9878E+04,4.0076E+01,
     &2.7489E+05,2.0617E+05,1.3745E+05,6.8723E+04,3.8351E+01,
     &2.6958E+05,2.0219E+05,1.3479E+05,6.7396E+04,3.6631E+01,
     &2.6383E+05,1.9788E+05,1.3192E+05,6.5959E+04,3.4286E+01/
      DATA ((KB(JS,JT,27,15),JS=1,5),JT=1,5) /
     &3.0277E+05,2.2708E+05,1.5139E+05,7.5694E+04,4.5895E+01,
     &2.9771E+05,2.2329E+05,1.4886E+05,7.4429E+04,4.3819E+01,
     &2.9175E+05,2.1881E+05,1.4587E+05,7.2938E+04,4.1746E+01,
     &2.8521E+05,2.1391E+05,1.4261E+05,7.1304E+04,3.9720E+01,
     &2.7826E+05,2.0870E+05,1.3913E+05,6.9566E+04,3.6964E+01/
      DATA ((KB(JS,JT,28,15),JS=1,5),JT=1,5) /
     &3.2897E+05,2.4673E+05,1.6449E+05,8.2243E+04,4.9767E+01,
     &3.2244E+05,2.4183E+05,1.6122E+05,8.0610E+04,4.7309E+01,
     &3.1503E+05,2.3628E+05,1.5752E+05,7.8759E+04,4.4889E+01,
     &3.0709E+05,2.3032E+05,1.5355E+05,7.6774E+04,4.2541E+01,
     &2.9858E+05,2.2393E+05,1.4929E+05,7.4645E+04,3.9310E+01/
      DATA ((KB(JS,JT,29,15),JS=1,5),JT=1,5) /
     &3.7585E+05,2.8188E+05,1.8792E+05,9.3962E+04,5.3281E+01,
     &3.6712E+05,2.7534E+05,1.8356E+05,9.1780E+04,5.0424E+01,
     &3.5767E+05,2.6826E+05,1.7884E+05,8.9419E+04,4.7662E+01,
     &3.4765E+05,2.6073E+05,1.7382E+05,8.6912E+04,4.4800E+01,
     &3.3714E+05,2.5285E+05,1.6857E+05,8.4284E+04,4.1166E+01/
      DATA ((KB(JS,JT,30,15),JS=1,5),JT=1,5) /
     &4.3604E+05,3.2703E+05,2.1802E+05,1.0901E+05,5.6346E+01,
     &4.2462E+05,3.1847E+05,2.1231E+05,1.0616E+05,5.3119E+01,
     &4.1259E+05,3.0944E+05,2.0629E+05,1.0315E+05,5.0028E+01,
     &3.9989E+05,2.9992E+05,1.9995E+05,9.9973E+04,4.6067E+01,
     &3.8696E+05,2.9022E+05,1.9348E+05,9.6741E+04,4.3622E+01/
      DATA ((KB(JS,JT,31,15),JS=1,5),JT=1,5) /
     &5.2737E+05,3.9553E+05,2.6369E+05,1.3184E+05,5.8898E+01,
     &5.1226E+05,3.8420E+05,2.5613E+05,1.2807E+05,5.5332E+01,
     &4.9638E+05,3.7229E+05,2.4819E+05,1.2410E+05,5.1303E+01,
     &4.8006E+05,3.6004E+05,2.4003E+05,1.2001E+05,4.7154E+01,
     &4.6345E+05,3.4759E+05,2.3173E+05,1.1586E+05,4.5673E+01/
      DATA ((KB(JS,JT,32,15),JS=1,5),JT=1,5) /
     &6.4038E+05,4.8028E+05,3.2019E+05,1.6010E+05,6.0926E+01,
     &6.2037E+05,4.6528E+05,3.1019E+05,1.5509E+05,5.7062E+01,
     &5.9976E+05,4.4982E+05,2.9988E+05,1.4994E+05,5.1911E+01,
     &5.7886E+05,4.3415E+05,2.8943E+05,1.4472E+05,4.9758E+01,
     &5.5779E+05,4.1835E+05,2.7890E+05,1.3945E+05,4.7124E+01/
      DATA ((KB(JS,JT,33,15),JS=1,5),JT=1,5) /
     &7.8604E+05,5.8953E+05,3.9302E+05,1.9651E+05,6.2449E+01,
     &7.5994E+05,5.6995E+05,3.7997E+05,1.8999E+05,5.7026E+01,
     &7.3324E+05,5.4993E+05,3.6662E+05,1.8331E+05,5.3959E+01,
     &7.0633E+05,5.2975E+05,3.5316E+05,1.7658E+05,5.1185E+01,
     &6.7933E+05,5.0950E+05,3.3967E+05,1.6983E+05,4.6145E+01/
      DATA ((KB(JS,JT,34,15),JS=1,5),JT=1,5) /
     &9.3629E+05,7.0222E+05,4.6814E+05,2.3407E+05,6.2950E+01,
     &9.0361E+05,6.7770E+05,4.5180E+05,2.2590E+05,5.7628E+01,
     &8.7048E+05,6.5286E+05,4.3524E+05,2.1762E+05,5.5397E+01,
     &8.3718E+05,6.2788E+05,4.1859E+05,2.0929E+05,5.1885E+01,
     &8.0393E+05,6.0294E+05,4.0196E+05,2.0098E+05,4.4833E+01/
      DATA ((KB(JS,JT,35,15),JS=1,5),JT=1,5) /
     &1.1151E+06,8.3633E+05,5.5755E+05,2.7878E+05,6.3401E+01,
     &1.0748E+06,8.0608E+05,5.3739E+05,2.6869E+05,5.9975E+01,
     &1.0341E+06,7.7556E+05,5.1704E+05,2.5852E+05,5.6633E+01,
     &9.9325E+05,7.4494E+05,4.9662E+05,2.4831E+05,5.0172E+01,
     &9.5274E+05,7.1455E+05,4.7637E+05,2.3818E+05,4.3180E+01/
      DATA ((KB(JS,JT,36,15),JS=1,5),JT=1,5) /
     &1.3204E+06,9.9032E+05,6.6021E+05,3.3011E+05,6.4479E+01,
     &1.2713E+06,9.5347E+05,6.3565E+05,3.1782E+05,6.1661E+01,
     &1.2219E+06,9.1640E+05,6.1093E+05,3.0547E+05,5.7543E+01,
     &1.1726E+06,8.7947E+05,5.8632E+05,2.9316E+05,4.9268E+01,
     &1.1240E+06,8.4303E+05,5.6202E+05,2.8101E+05,4.3422E+01/
      DATA ((KB(JS,JT,37,15),JS=1,5),JT=1,5) /
     &1.5283E+06,1.1462E+06,7.6413E+05,3.8207E+05,6.6367E+01,
     &1.4706E+06,1.1030E+06,7.3532E+05,3.6766E+05,6.3620E+01,
     &1.4128E+06,1.0596E+06,7.0638E+05,3.5319E+05,5.8851E+01,
     &1.3549E+06,1.0162E+06,6.7744E+05,3.3872E+05,4.8460E+01,
     &1.2980E+06,9.7352E+05,6.4901E+05,3.2451E+05,4.3139E+01/
      DATA ((KB(JS,JT,38,15),JS=1,5),JT=1,5) /
     &1.7917E+06,1.3437E+06,8.9582E+05,4.4791E+05,6.8827E+01,
     &1.7232E+06,1.2924E+06,8.6157E+05,4.3078E+05,6.5495E+01,
     &1.6545E+06,1.2409E+06,8.2724E+05,4.1362E+05,5.8860E+01,
     &1.5862E+06,1.1896E+06,7.9309E+05,3.9654E+05,4.7251E+01,
     &1.5188E+06,1.1391E+06,7.5940E+05,3.7970E+05,4.3731E+01/
      DATA ((KB(JS,JT,39,15),JS=1,5),JT=1,5) /
     &2.1445E+06,1.6084E+06,1.0723E+06,5.3613E+05,7.1068E+01,
     &2.0613E+06,1.5460E+06,1.0307E+06,5.1533E+05,6.6419E+01,
     &1.9786E+06,1.4840E+06,9.8932E+05,4.9466E+05,5.6988E+01,
     &1.8964E+06,1.4223E+06,9.4822E+05,4.7411E+05,4.6537E+01,
     &1.8152E+06,1.3614E+06,9.0762E+05,4.5381E+05,4.1463E+01/
      DATA ((KB(JS,JT,40,15),JS=1,5),JT=1,5) /
     &2.4170E+06,1.8127E+06,1.2085E+06,6.0424E+05,7.3096E+01,
     &2.3226E+06,1.7420E+06,1.1613E+06,5.8063E+05,6.8150E+01,
     &2.2296E+06,1.6722E+06,1.1148E+06,5.5739E+05,5.8979E+01,
     &2.1366E+06,1.6025E+06,1.0683E+06,5.3415E+05,4.7816E+01,
     &2.0448E+06,1.5336E+06,1.0224E+06,5.1120E+05,4.2008E+01/
      DATA ((KB(JS,JT,41,15),JS=1,5),JT=1,5) /
     &2.7164E+06,2.0373E+06,1.3582E+06,6.7911E+05,7.4782E+01,
     &2.6095E+06,1.9571E+06,1.3048E+06,6.5238E+05,6.9972E+01,
     &2.5049E+06,1.8787E+06,1.2525E+06,6.2623E+05,6.0957E+01,
     &2.4006E+06,1.8005E+06,1.2003E+06,6.0017E+05,4.9097E+01,
     &2.2975E+06,1.7231E+06,1.1487E+06,5.7438E+05,4.2980E+01/
      DATA ((KB(JS,JT,42,15),JS=1,5),JT=1,5) /
     &3.0827E+06,2.3120E+06,1.5413E+06,7.7067E+05,7.6123E+01,
     &2.9612E+06,2.2209E+06,1.4806E+06,7.4030E+05,7.1662E+01,
     &2.8423E+06,2.1317E+06,1.4211E+06,7.1056E+05,6.2602E+01,
     &2.7244E+06,2.0433E+06,1.3622E+06,6.8108E+05,5.0093E+01,
     &2.6071E+06,1.9553E+06,1.3035E+06,6.5176E+05,4.3774E+01/
      DATA ((KB(JS,JT,43,15),JS=1,5),JT=1,5) /
     &3.5341E+06,2.6506E+06,1.7671E+06,8.8353E+05,7.8436E+01,
     &3.3959E+06,2.5467E+06,1.6978E+06,8.4891E+05,7.3775E+01,
     &3.2585E+06,2.4439E+06,1.6293E+06,8.1464E+05,6.4695E+01,
     &3.1244E+06,2.3433E+06,1.5622E+06,7.8111E+05,5.1912E+01,
     &2.9906E+06,2.2429E+06,1.4953E+06,7.4765E+05,4.5444E+01/
      DATA ((KB(JS,JT,44,15),JS=1,5),JT=1,5) /
     &4.1097E+06,3.0823E+06,2.0548E+06,1.0274E+06,8.1119E+01,
     &3.9487E+06,2.9615E+06,1.9743E+06,9.8717E+05,7.5797E+01,
     &3.7894E+06,2.8420E+06,1.8947E+06,9.4733E+05,6.6793E+01,
     &3.6341E+06,2.7256E+06,1.8170E+06,9.0851E+05,5.3433E+01,
     &3.4797E+06,2.6097E+06,1.7398E+06,8.6990E+05,4.7406E+01/
      DATA ((KB(JS,JT,45,15),JS=1,5),JT=1,5) /
     &4.8722E+06,3.6542E+06,2.4361E+06,1.2181E+06,8.3949E+01,
     &4.6827E+06,3.5120E+06,2.3413E+06,1.1707E+06,7.7974E+01,
     &4.4945E+06,3.3709E+06,2.2473E+06,1.1236E+06,6.9073E+01,
     &4.3103E+06,3.2327E+06,2.1551E+06,1.0776E+06,5.6213E+01,
     &4.1290E+06,3.0968E+06,2.0645E+06,1.0323E+06,4.8762E+01/
      DATA ((KB(JS,JT,46,15),JS=1,5),JT=1,5) /
     &5.8372E+06,4.3779E+06,2.9186E+06,1.4593E+06,8.7007E+01,
     &5.6126E+06,4.2094E+06,2.8063E+06,1.4031E+06,8.0166E+01,
     &5.3885E+06,4.0414E+06,2.6943E+06,1.3471E+06,7.0991E+01,
     &5.1687E+06,3.8765E+06,2.5843E+06,1.2922E+06,5.9015E+01,
     &4.9529E+06,3.7147E+06,2.4764E+06,1.2382E+06,5.0566E+01/
      DATA ((KB(JS,JT,47,15),JS=1,5),JT=1,5) /
     &6.9385E+06,5.2039E+06,3.4693E+06,1.7346E+06,9.1194E+01,
     &6.6774E+06,5.0081E+06,3.3387E+06,1.6694E+06,8.2417E+01,
     &6.4127E+06,4.8095E+06,3.2064E+06,1.6032E+06,7.5225E+01,
     &6.1518E+06,4.6139E+06,3.0759E+06,1.5380E+06,6.2982E+01,
     &5.8970E+06,4.4228E+06,2.9485E+06,1.4743E+06,5.3315E+01/
      DATA ((KB(JS,JT,48,15),JS=1,5),JT=1,5) /
     &8.4803E+06,6.3603E+06,4.2402E+06,2.1201E+06,9.5233E+01,
     &8.1666E+06,6.1249E+06,4.0833E+06,2.0417E+06,8.3938E+01,
     &7.8474E+06,5.8855E+06,3.9237E+06,1.9618E+06,7.8581E+01,
     &7.5308E+06,5.6481E+06,3.7654E+06,1.8827E+06,6.5837E+01,
     &7.2194E+06,5.4145E+06,3.6097E+06,1.8049E+06,5.5833E+01/
      DATA ((KB(JS,JT,49,15),JS=1,5),JT=1,5) /
     &1.0795E+07,8.0961E+06,5.3974E+06,2.6987E+06,9.8694E+01,
     &1.0405E+07,7.8035E+06,5.2023E+06,2.6011E+06,8.7441E+01,
     &1.0006E+07,7.5045E+06,5.0030E+06,2.5015E+06,8.1233E+01,
     &9.6057E+06,7.2043E+06,4.8028E+06,2.4014E+06,6.9160E+01,
     &9.2104E+06,6.9078E+06,4.6052E+06,2.3026E+06,5.7442E+01/
      DATA ((KB(JS,JT,50,15),JS=1,5),JT=1,5) /
     &1.3074E+07,9.8054E+06,6.5369E+06,3.2685E+06,1.0218E+02,
     &1.2610E+07,9.4575E+06,6.3050E+06,3.1525E+06,9.1395E+01,
     &1.2137E+07,9.1025E+06,6.0683E+06,3.0342E+06,8.4017E+01,
     &1.1655E+07,8.7414E+06,5.8276E+06,2.9138E+06,7.1620E+01,
     &1.1180E+07,8.3848E+06,5.5899E+06,2.7949E+06,6.0411E+01/
      DATA ((KB(JS,JT,51,15),JS=1,5),JT=1,5) /
     &1.5480E+07,1.1610E+07,7.7399E+06,3.8700E+06,1.0595E+02,
     &1.4942E+07,1.1207E+07,7.4711E+06,3.7356E+06,9.5091E+01,
     &1.4390E+07,1.0793E+07,7.1952E+06,3.5976E+06,8.6843E+01,
     &1.3829E+07,1.0371E+07,6.9143E+06,3.4572E+06,7.4583E+01,
     &1.3268E+07,9.9514E+06,6.6343E+06,3.3171E+06,6.4529E+01/
      DATA ((KB(JS,JT,52,15),JS=1,5),JT=1,5) /
     &1.8848E+07,1.4136E+07,9.4240E+06,4.7120E+06,1.0974E+02,
     &1.8206E+07,1.3654E+07,9.1030E+06,4.5515E+06,9.9547E+01,
     &1.7547E+07,1.3161E+07,8.7738E+06,4.3869E+06,8.9552E+01,
     &1.6877E+07,1.2658E+07,8.4384E+06,4.2192E+06,7.7635E+01,
     &1.6199E+07,1.2149E+07,8.0997E+06,4.0499E+06,6.8061E+01/
      DATA ((KB(JS,JT,53,15),JS=1,5),JT=1,5) /
     &2.3903E+07,1.7928E+07,1.1952E+07,5.9760E+06,1.1360E+02,
     &2.3112E+07,1.7334E+07,1.1556E+07,5.7781E+06,1.0455E+02,
     &2.2293E+07,1.6719E+07,1.1146E+07,5.5732E+06,9.2320E+01,
     &2.1455E+07,1.6091E+07,1.0728E+07,5.3638E+06,8.0467E+01,
     &2.0604E+07,1.5453E+07,1.0302E+07,5.1511E+06,7.1688E+01/
      DATA ((KB(JS,JT,54,15),JS=1,5),JT=1,5) /
     &2.6168E+07,1.9626E+07,1.3084E+07,6.5420E+06,1.1792E+02,
     &2.5326E+07,1.8995E+07,1.2663E+07,6.3316E+06,1.0689E+02,
     &2.4445E+07,1.8334E+07,1.2223E+07,6.1114E+06,9.4623E+01,
     &2.3543E+07,1.7657E+07,1.1772E+07,5.8858E+06,8.6034E+01,
     &2.2624E+07,1.6968E+07,1.1312E+07,5.6560E+06,7.5610E+01/
      DATA ((KB(JS,JT,55,15),JS=1,5),JT=1,5) /
     &2.6110E+07,1.9583E+07,1.3055E+07,6.5277E+06,1.2293E+02,
     &2.5298E+07,1.8974E+07,1.2649E+07,6.3247E+06,1.0996E+02,
     &2.4435E+07,1.8326E+07,1.2218E+07,6.1089E+06,1.0025E+02,
     &2.3548E+07,1.7661E+07,1.1774E+07,5.8870E+06,8.9943E+01,
     &2.2646E+07,1.6984E+07,1.1323E+07,5.6615E+06,7.8052E+01/
      DATA ((KB(JS,JT,56,15),JS=1,5),JT=1,5) /
     &2.6049E+07,1.9537E+07,1.3025E+07,6.5123E+06,1.2801E+02,
     &2.5263E+07,1.8947E+07,1.2631E+07,6.3155E+06,1.1426E+02,
     &2.4422E+07,1.8316E+07,1.2211E+07,6.1054E+06,1.0290E+02,
     &2.3554E+07,1.7665E+07,1.1777E+07,5.8883E+06,9.1587E+01,
     &2.2663E+07,1.6997E+07,1.1331E+07,5.6657E+06,8.3726E+01/
      DATA ((KB(JS,JT,57,15),JS=1,5),JT=1,5) /
     &2.5975E+07,1.9481E+07,1.2987E+07,6.4936E+06,1.3227E+02,
     &2.5221E+07,1.8915E+07,1.2610E+07,6.3050E+06,1.1939E+02,
     &2.4401E+07,1.8301E+07,1.2201E+07,6.1003E+06,1.0672E+02,
     &2.3548E+07,1.7661E+07,1.1774E+07,5.8869E+06,9.6378E+01,
     &2.2676E+07,1.7007E+07,1.1338E+07,5.6688E+06,8.7523E+01/
      DATA ((KB(JS,JT,58,15),JS=1,5),JT=1,5) /
     &6.8249E+06,6.2574E+06,5.3652E+06,3.7577E+06,1.3651E+02,
     &6.6343E+06,6.0826E+06,5.2153E+06,3.6528E+06,1.2352E+02,
     &6.4258E+06,5.8914E+06,5.0514E+06,3.5379E+06,1.1077E+02,
     &6.2048E+06,5.6888E+06,4.8776E+06,3.4163E+06,9.9878E+01,
     &5.9792E+06,5.4820E+06,4.7004E+06,3.2921E+06,8.9433E+01/
      DATA ((KB(JS,JT,59,15),JS=1,5),JT=1,5) /
     &7.9949E+06,6.9809E+06,5.5683E+06,3.4650E+06,1.3832E+02,
     &7.7778E+06,6.7913E+06,5.4171E+06,3.3709E+06,1.2505E+02,
     &7.5359E+06,6.5801E+06,5.2486E+06,3.2660E+06,1.1363E+02,
     &7.2794E+06,6.3561E+06,5.0700E+06,3.1549E+06,1.0324E+02,
     &7.0157E+06,6.1258E+06,4.8863E+06,3.0406E+06,9.1722E+01/
      DATA ((KB(JS,JT,13,16),JS=1,5),JT=1,5) /
     &7.4591E+05,5.5944E+05,3.7296E+05,1.8648E+05,1.0589E+01,
     &7.4121E+05,5.5591E+05,3.7061E+05,1.8530E+05,1.0476E+01,
     &7.3660E+05,5.5245E+05,3.6830E+05,1.8415E+05,6.4518E+00,
     &7.3017E+05,5.4763E+05,3.6509E+05,1.8254E+05,7.2400E-02,
     &7.2523E+05,5.4392E+05,3.6262E+05,1.8131E+05,8.3840E-02/
      DATA ((KB(JS,JT,14,16),JS=1,5),JT=1,5) /
     &5.4546E+05,4.0910E+05,2.7273E+05,1.3636E+05,1.2083E+01,
     &5.4530E+05,4.0897E+05,2.7264E+05,1.3632E+05,1.1940E+01,
     &5.4326E+05,4.0739E+05,2.7163E+05,1.3581E+05,1.1721E+01,
     &5.4132E+05,4.0599E+05,2.7066E+05,1.3533E+05,4.5827E+00,
     &5.3886E+05,4.0414E+05,2.6943E+05,1.3471E+05,7.8150E-02/
      DATA ((KB(JS,JT,15,16),JS=1,5),JT=1,5) /
     &4.1181E+05,3.0886E+05,2.0591E+05,1.0295E+05,1.3732E+01,
     &4.1235E+05,3.0926E+05,2.0618E+05,1.0309E+05,1.3536E+01,
     &4.1248E+05,3.0936E+05,2.0624E+05,1.0312E+05,1.3259E+01,
     &4.1181E+05,3.0886E+05,2.0591E+05,1.0296E+05,1.2919E+01,
     &4.1010E+05,3.0757E+05,2.0505E+05,1.0253E+05,4.0719E+00/
      DATA ((KB(JS,JT,16,16),JS=1,5),JT=1,5) /
     &3.7257E+05,2.7672E+05,1.8628E+05,9.3143E+04,1.5485E+01,
     &3.7431E+05,2.8074E+05,1.8716E+05,9.3579E+04,1.5222E+01,
     &3.7500E+05,2.8129E+05,1.8753E+05,9.3763E+04,1.4862E+01,
     &3.7444E+05,2.8083E+05,1.8722E+05,9.3612E+04,1.4438E+01,
     &3.7332E+05,2.7999E+05,1.8666E+05,9.3332E+04,7.6230E+00/
      DATA ((KB(JS,JT,17,16),JS=1,5),JT=1,5) /
     &3.5182E+05,2.6386E+05,1.7591E+05,8.7955E+04,1.7290E+01,
     &3.5397E+05,2.6547E+05,1.7698E+05,8.8492E+04,1.6932E+01,
     &3.5462E+05,2.6597E+05,1.7731E+05,8.8656E+04,1.6480E+01,
     &3.5402E+05,2.6552E+05,1.7701E+05,8.8507E+04,1.5962E+01,
     &3.5314E+05,2.6486E+05,1.7657E+05,8.8287E+04,1.0353E+01/
      DATA ((KB(JS,JT,18,16),JS=1,5),JT=1,5) /
     &3.4176E+05,2.5632E+05,1.7088E+05,8.5439E+04,1.9139E+01,
     &3.4367E+05,2.5775E+05,1.7183E+05,8.5917E+04,1.8641E+01,
     &3.4399E+05,2.5800E+05,1.7200E+05,8.5999E+04,1.8079E+01,
     &3.4376E+05,2.5782E+05,1.7188E+05,8.5941E+04,1.7627E+01,
     &3.4258E+05,2.5694E+05,1.7129E+05,8.5646E+04,1.3174E+01/
      DATA ((KB(JS,JT,19,16),JS=1,5),JT=1,5) /
     &3.2677E+05,2.4508E+05,1.6338E+05,8.1692E+04,2.1598E+01,
     &3.2775E+05,2.4581E+05,1.6387E+05,8.1937E+04,2.1013E+01,
     &3.2835E+05,2.4626E+05,1.6417E+05,8.2068E+04,2.0530E+01,
     &3.2780E+05,2.4585E+05,1.6390E+05,8.1950E+04,2.0057E+01,
     &3.2322E+05,2.4484E+05,1.6323E+05,8.1613E+04,1.8218E+01/
      DATA ((KB(JS,JT,20,16),JS=1,5),JT=1,5) /
     &3.3791E+05,2.5343E+05,1.6896E+05,8.4478E+04,2.4811E+01,
     &3.3834E+05,2.5376E+05,1.6917E+05,8.4586E+04,2.4163E+01,
     &3.3842E+05,2.5381E+05,1.6921E+05,8.4605E+04,2.3647E+01,
     &3.3728E+05,2.5296E+05,1.6864E+05,8.4321E+04,2.3144E+01,
     &3.3569E+05,2.5177E+05,1.6785E+05,8.3923E+04,2.2618E+01/
      DATA ((KB(JS,JT,21,16),JS=1,5),JT=1,5) /
     &3.5913E+05,2.6935E+05,1.7956E+05,8.9782E+04,2.8889E+01,
     &3.5914E+05,2.6936E+05,1.7957E+05,8.9786E+04,2.8114E+01,
     &3.5794E+05,2.6846E+05,1.7897E+05,8.9486E+04,2.7459E+01,
     &3.5626E+05,2.6720E+05,1.7813E+05,8.9066E+04,2.6836E+01,
     &3.5369E+05,2.6527E+05,1.7684E+05,8.8423E+04,2.6161E+01/
      DATA ((KB(JS,JT,22,16),JS=1,5),JT=1,5) /
     &3.8948E+05,2.9211E+05,1.9474E+05,9.7369E+04,3.3724E+01,
     &3.8828E+05,2.9121E+05,1.9414E+05,9.7069E+04,3.2720E+01,
     &3.8560E+05,2.8920E+05,1.9280E+05,9.6401E+04,3.1834E+01,
     &3.8253E+05,2.8690E+05,1.9127E+05,9.5633E+04,3.0971E+01,
     &3.7845E+05,2.8383E+05,1.8922E+05,9.4612E+04,3.0080E+01/
      DATA ((KB(JS,JT,23,16),JS=1,5),JT=1,5) /
     &4.2147E+05,3.1611E+05,2.1074E+05,1.0537E+05,3.9276E+01,
     &4.1843E+05,3.1382E+05,2.0921E+05,1.0461E+05,3.7947E+01,
     &4.1438E+05,3.1079E+05,2.0719E+05,1.0360E+05,3.6734E+01,
     &4.0918E+05,3.0688E+05,2.0459E+05,1.0230E+05,3.5522E+01,
     &4.0269E+05,3.0202E+05,2.0135E+05,1.0067E+05,3.4322E+01/
      DATA ((KB(JS,JT,24,16),JS=1,5),JT=1,5) /
     &4.4910E+05,3.3682E+05,2.2455E+05,1.1228E+05,4.5446E+01,
     &4.4436E+05,3.3327E+05,2.2218E+05,1.1109E+05,4.3684E+01,
     &4.3822E+05,3.2867E+05,2.1911E+05,1.0956E+05,4.2010E+01,
     &4.3055E+05,3.2291E+05,2.1528E+05,1.0764E+05,4.0380E+01,
     &4.2183E+05,3.1637E+05,2.1092E+05,1.0546E+05,3.8819E+01/
      DATA ((KB(JS,JT,25,16),JS=1,5),JT=1,5) /
     &4.7951E+05,3.5963E+05,2.3975E+05,1.1988E+05,5.2030E+01,
     &4.7236E+05,3.5427E+05,2.3618E+05,1.1809E+05,4.9759E+01,
     &4.6345E+05,3.4759E+05,2.3173E+05,1.1586E+05,4.7513E+01,
     &4.5307E+05,3.3980E+05,2.2654E+05,1.1327E+05,4.5411E+01,
     &4.4201E+05,3.3151E+05,2.2101E+05,1.1050E+05,4.3416E+01/
      DATA ((KB(JS,JT,26,16),JS=1,5),JT=1,5) /
     &5.1412E+05,3.8559E+05,2.5706E+05,1.2853E+05,5.8735E+01,
     &5.0368E+05,3.7776E+05,2.5184E+05,1.2592E+05,5.5868E+01,
     &4.9157E+05,3.6868E+05,2.4579E+05,1.2289E+05,5.3078E+01,
     &4.7856E+05,3.5892E+05,2.3928E+05,1.1964E+05,5.0425E+01,
     &4.6464E+05,3.4848E+05,2.3232E+05,1.1616E+05,4.7921E+01/
      DATA ((KB(JS,JT,27,16),JS=1,5),JT=1,5) /
     &5.6504E+05,4.2378E+05,2.8252E+05,1.4126E+05,6.5394E+01,
     &5.5002E+05,4.1252E+05,2.7501E+05,1.3751E+05,6.1825E+01,
     &5.3436E+05,4.0077E+05,2.6718E+05,1.3359E+05,5.8497E+01,
     &5.1782E+05,3.8837E+05,2.5891E+05,1.2946E+05,5.5282E+01,
     &5.0051E+05,3.7538E+05,2.5025E+05,1.2513E+05,5.2211E+01/
      DATA ((KB(JS,JT,28,16),JS=1,5),JT=1,5) /
     &6.2869E+05,4.7152E+05,3.1435E+05,1.5717E+05,7.1700E+01,
     &6.0862E+05,4.5646E+05,3.0431E+05,1.5215E+05,6.7460E+01,
     &5.8860E+05,4.4145E+05,2.9430E+05,1.4715E+05,6.3511E+01,
     &5.6780E+05,4.2585E+05,2.8390E+05,1.4195E+05,5.9746E+01,
     &5.4624E+05,4.0968E+05,2.7312E+05,1.3656E+05,5.6156E+01/
      DATA ((KB(JS,JT,29,16),JS=1,5),JT=1,5) /
     &7.3240E+05,5.4930E+05,3.6620E+05,1.8310E+05,7.7436E+01,
     &7.0567E+05,5.2925E+05,3.5284E+05,1.7642E+05,7.2532E+01,
     &6.7920E+05,5.0940E+05,3.3960E+05,1.6980E+05,6.7962E+01,
     &6.5231E+05,4.8923E+05,3.2615E+05,1.6308E+05,6.3669E+01,
     &6.2510E+05,4.6882E+05,3.1255E+05,1.5627E+05,5.9600E+01/
      DATA ((KB(JS,JT,30,16),JS=1,5),JT=1,5) /
     &8.6319E+05,6.4740E+05,4.3160E+05,2.1580E+05,8.2489E+01,
     &8.2811E+05,6.2108E+05,4.1405E+05,2.0703E+05,7.6918E+01,
     &7.9339E+05,5.9504E+05,3.9669E+05,1.9835E+05,7.1793E+01,
     &7.5902E+05,5.6926E+05,3.7951E+05,1.8975E+05,6.6976E+01,
     &7.2513E+05,5.4385E+05,3.6256E+05,1.8128E+05,5.5921E+01/
      DATA ((KB(JS,JT,31,16),JS=1,5),JT=1,5) /
     &1.0572E+06,7.9291E+05,5.2861E+05,2.6430E+05,8.6704E+01,
     &1.0099E+06,7.5744E+05,5.0496E+05,2.5248E+05,8.0546E+01,
     &9.6381E+05,7.2285E+05,4.8190E+05,2.4095E+05,7.4889E+01,
     &9.1917E+05,6.8937E+05,4.5958E+05,2.2979E+05,6.9630E+01,
     &8.7558E+05,6.5669E+05,4.3779E+05,2.1889E+05,5.1048E+01/
      DATA ((KB(JS,JT,32,16),JS=1,5),JT=1,5) /
     &1.2953E+06,9.7146E+05,6.4764E+05,3.2382E+05,9.0053E+01,
     &1.2332E+06,9.2492E+05,6.1662E+05,3.0831E+05,8.3375E+01,
     &1.1732E+06,8.7992E+05,5.8661E+05,2.9331E+05,7.7283E+01,
     &1.1156E+06,8.3672E+05,5.5781E+05,2.7891E+05,5.9068E+01,
     &1.0600E+06,7.9499E+05,5.3000E+05,2.6500E+05,4.7615E+01/
      DATA ((KB(JS,JT,33,16),JS=1,5),JT=1,5) /
     &1.6005E+06,1.2004E+06,8.0025E+05,4.0013E+05,9.2564E+01,
     &1.5042E+06,1.1396E+06,7.5976E+05,3.7988E+05,8.5451E+01,
     &1.4412E+06,1.0809E+06,7.2060E+05,3.6030E+05,6.7956E+01,
     &1.3676E+06,1.0257E+06,6.8379E+05,3.4189E+05,5.3693E+01,
     &1.2966E+06,9.7245E+05,6.4830E+05,3.2415E+05,4.3539E+01/
      DATA ((KB(JS,JT,34,16),JS=1,5),JT=1,5) /
     &1.9162E+06,1.4372E+06,9.5812E+05,4.7906E+05,9.4564E+01,
     &1.8147E+06,1.3610E+06,9.0734E+05,4.5367E+05,8.5602E+01,
     &1.7177E+06,1.2883E+06,8.5884E+05,4.2942E+05,6.2695E+01,
     &1.6266E+06,1.2199E+06,8.1329E+05,4.0664E+05,5.0461E+01,
     &1.5395E+06,1.1546E+06,7.6973E+05,3.8486E+05,4.1009E+01/
      DATA ((KB(JS,JT,35,16),JS=1,5),JT=1,5) /
     &2.2940E+06,1.7205E+06,1.1470E+06,5.7350E+05,9.6683E+01,
     &2.1679E+06,1.6259E+06,1.0839E+06,5.4197E+05,7.5706E+01,
     &2.0487E+06,1.5365E+06,1.0243E+06,5.1216E+05,5.9415E+01,
     &1.9369E+06,1.4527E+06,9.6844E+05,4.8422E+05,4.7837E+01,
     &1.8303E+06,1.3728E+06,9.1517E+05,4.5758E+05,3.3167E+01/
      DATA ((KB(JS,JT,36,16),JS=1,5),JT=1,5) /
     &2.7323E+06,2.0492E+06,1.3661E+06,6.8307E+05,9.9200E+01,
     &2.5780E+06,1.9335E+06,1.2890E+06,6.4450E+05,7.2688E+01,
     &2.4326E+06,1.8244E+06,1.2163E+06,6.0814E+05,5.7708E+01,
     &2.2967E+06,1.7225E+06,1.1483E+06,5.7417E+05,4.6712E+01,
     &2.1679E+06,1.6259E+06,1.0839E+06,5.4197E+05,1.2791E+01/
      DATA ((KB(JS,JT,37,16),JS=1,5),JT=1,5) /
     &3.1885E+06,2.3914E+06,1.5942E+06,7.9711E+05,1.0268E+02,
     &3.0040E+06,2.2530E+06,1.5020E+06,7.5099E+05,7.3443E+01,
     &2.8309E+06,2.1232E+06,1.4155E+06,7.0773E+05,5.8756E+01,
     &2.6696E+06,2.0022E+06,1.3348E+06,6.6739E+05,4.7388E+01,
     &2.5177E+06,1.8883E+06,1.2588E+06,6.2942E+05,7.8483E+00/
      DATA ((KB(JS,JT,38,16),JS=1,5),JT=1,5) /
     &3.7660E+06,2.8245E+06,1.8830E+06,9.4149E+05,1.0053E+02,
     &3.5441E+06,2.6581E+06,1.7720E+06,8.8602E+05,7.3960E+01,
     &3.3357E+06,2.5018E+06,1.6678E+06,8.3391E+05,5.9673E+01,
     &3.1421E+06,2.3566E+06,1.5711E+06,7.8553E+05,4.7953E+01,
     &2.9610E+06,2.2207E+06,1.4805E+06,7.4024E+05,7.1016E-04/
      DATA ((KB(JS,JT,39,16),JS=1,5),JT=1,5) /
     &4.5378E+06,3.4034E+06,2.2689E+06,1.1345E+06,9.8727E+01,
     &4.2667E+06,3.2000E+06,2.1334E+06,1.0667E+06,7.4242E+01,
     &4.0124E+06,3.0093E+06,2.0062E+06,1.0031E+06,5.9575E+01,
     &3.7760E+06,2.8320E+06,1.8880E+06,9.4400E+05,3.9674E+01,
     &3.5558E+06,2.6669E+06,1.7591E+06,8.8898E+05,5.7405E-04/
      DATA ((KB(JS,JT,40,16),JS=1,5),JT=1,5) /
     &5.1586E+06,3.8690E+06,2.5793E+06,1.2896E+06,1.0433E+02,
     &4.8469E+06,3.6347E+06,2.4234E+06,1.2117E+06,7.7760E+01,
     &4.5541E+06,3.4156E+06,2.2770E+06,1.1385E+06,6.1585E+01,
     &4.2818E+06,3.2114E+06,2.1409E+06,1.0704E+06,4.0940E+01,
     &4.0296E+06,3.0222E+06,2.0148E+06,1.0074E+06,4.6888E-04/
      DATA ((KB(JS,JT,41,16),JS=1,5),JT=1,5) /
     &5.8465E+06,4.3849E+06,2.9233E+06,1.4616E+06,1.1317E+02,
     &5.4907E+06,4.1180E+06,2.7454E+06,1.3727E+06,8.1398E+01,
     &5.1550E+06,3.8663E+06,2.5775E+06,1.2888E+06,6.4536E+01,
     &4.8434E+06,3.6326E+06,2.4217E+06,1.2109E+06,4.3960E+01,
     &4.5548E+06,3.4161E+06,2.2774E+06,1.1387E+06,3.7799E-04/
      DATA ((KB(JS,JT,42,16),JS=1,5),JT=1,5) /
     &6.6900E+06,5.0175E+06,3.3450E+06,1.6725E+06,1.2124E+02,
     &6.2794E+06,4.7096E+06,3.1397E+06,1.5698E+06,8.5097E+01,
     &5.8926E+06,4.4195E+06,2.9463E+06,1.4731E+06,6.7520E+01,
     &5.5323E+06,4.1492E+06,2.7661E+06,1.3831E+06,4.6182E+01,
     &5.1983E+06,3.8987E+06,2.5991E+06,1.2996E+06,3.0509E-04/
      DATA ((KB(JS,JT,43,16),JS=1,5),JT=1,5) /
     &7.7419E+06,5.8065E+06,3.8710E+06,1.9355E+06,1.2600E+02,
     &7.2619E+06,5.4481E+06,3.6321E+06,1.8161E+06,9.0385E+01,
     &6.8139E+06,5.1104E+06,3.4070E+06,1.7035E+06,7.0944E+01,
     &6.3928E+06,4.7946E+06,3.1964E+06,1.5982E+06,5.0507E+01,
     &6.0029E+06,4.5022E+06,3.0015E+06,1.5007E+06,2.4615E-04/
      DATA ((KB(JS,JT,44,16),JS=1,5),JT=1,5) /
     &9.0918E+06,6.8188E+06,4.5458E+06,2.2729E+06,1.3122E+02,
     &8.5266E+06,6.3949E+06,4.2633E+06,2.1316E+06,9.7168E+01,
     &7.9959E+06,5.9969E+06,3.9979E+06,1.9989E+06,7.5640E+01,
     &7.4967E+06,5.6225E+06,3.7483E+06,1.8741E+06,5.7032E+01,
     &7.0357E+06,5.2767E+06,3.5178E+06,1.7589E+06,1.1125E-02/
      DATA ((KB(JS,JT,45,16),JS=1,5),JT=1,5) /
     &1.0890E+07,8.1678E+06,5.4452E+06,2.7226E+06,1.3511E+02,
     &1.0206E+07,7.6543E+06,5.1028E+06,2.5514E+06,1.0320E+02,
     &9.5676E+06,7.1757E+06,4.7838E+06,2.3919E+06,7.9521E+01,
     &8.9682E+06,6.7261E+06,4.4841E+06,2.2420E+06,5.3314E+01,
     &8.4107E+06,6.3080E+06,4.2053E+06,2.1027E+06,2.2542E-04/
      DATA ((KB(JS,JT,46,16),JS=1,5),JT=1,5) /
     &1.3200E+07,9.8998E+06,6.5999E+06,3.2999E+06,1.4245E+02,
     &1.2354E+07,9.2658E+06,6.1772E+06,3.0886E+06,1.1090E+02,
     &1.1578E+07,8.6832E+06,5.7888E+06,2.8944E+06,8.3717E+01,
     &1.0851E+07,8.1384E+06,5.4256E+06,2.7128E+06,5.1335E+01,
     &1.0172E+07,7.6289E+06,5.0860E+06,2.5430E+06,1.9729E-04/
      DATA ((KB(JS,JT,47,16),JS=1,5),JT=1,5) /
     &1.5899E+07,1.1924E+07,7.9494E+06,3.9747E+06,1.4926E+02,
     &1.4859E+07,1.1144E+07,7.4297E+06,3.7148E+06,1.2298E+02,
     &1.3924E+07,1.0443E+07,6.9621E+06,3.4810E+06,8.5230E+01,
     &1.3046E+07,9.7847E+06,6.5231E+06,3.2616E+06,5.3561E+01,
     &1.2222E+07,9.1665E+06,6.1110E+06,3.0555E+06,1.6606E-04/
      DATA ((KB(JS,JT,48,16),JS=1,5),JT=1,5) /
     &1.9701E+07,1.4775E+07,9.8503E+06,4.9251E+06,1.5645E+02,
     &1.8394E+07,1.3796E+07,9.1972E+06,4.5986E+06,1.4059E+02,
     &1.7217E+07,1.2913E+07,8.6087E+06,4.3044E+06,8.5580E+01,
     &1.6130E+07,1.2097E+07,8.0649E+06,4.0324E+06,5.5884E+01,
     &1.5108E+07,1.1331E+07,7.5542E+06,3.7771E+06,1.4110E-04/
      DATA ((KB(JS,JT,49,16),JS=1,5),JT=1,5) /
     &2.5446E+07,1.9085E+07,1.2723E+07,6.3615E+06,1.6402E+02,
     &2.3735E+07,1.7801E+07,1.1868E+07,5.9337E+06,1.4463E+02,
     &2.2185E+07,1.6639E+07,1.1093E+07,5.5463E+06,8.5806E+01,
     &2.0781E+07,1.5586E+07,1.0390E+07,5.1952E+06,5.2515E+01,
     &1.9463E+07,1.4597E+07,9.7313E+06,4.8656E+06,1.1804E-04/
      DATA ((KB(JS,JT,50,16),JS=1,5),JT=1,5) /
     &3.1256E+07,2.3442E+07,1.5628E+07,7.8139E+06,1.7145E+02,
     &2.9123E+07,2.1842E+07,1.4562E+07,7.2808E+06,1.4715E+02,
     &2.7197E+07,2.0398E+07,1.3599E+07,6.7993E+06,9.2079E+01,
     &2.5458E+07,1.9094E+07,1.2729E+07,6.3645E+06,5.7113E+01,
     &2.3842E+07,1.7882E+07,1.1921E+07,5.9606E+06,9.7879E-05/
      DATA ((KB(JS,JT,51,16),JS=1,5),JT=1,5) /
     &3.7532E+07,2.8149E+07,1.8766E+07,9.3831E+06,1.7913E+02,
     &3.4951E+07,2.6213E+07,1.7476E+07,8.7379E+06,1.5348E+02,
     &3.2604E+07,2.4453E+07,1.6302E+07,8.1511E+06,9.9906E+01,
     &3.0489E+07,2.2867E+07,1.5245E+07,7.6224E+06,6.1926E+01,
     &2.8553E+07,2.1415E+07,1.4277E+07,7.1383E+06,8.2332E-05/
      DATA ((KB(JS,JT,52,16),JS=1,5),JT=1,5) /
     &4.6363E+07,3.4773E+07,2.3182E+07,1.1591E+07,1.8724E+02,
     &4.3154E+07,3.2365E+07,2.1577E+07,1.0789E+07,1.5735E+02,
     &4.0219E+07,3.0165E+07,2.0110E+07,1.0055E+07,1.0819E+02,
     &3.7571E+07,2.8178E+07,1.8786E+07,9.3929E+06,6.5746E+01,
     &3.5175E+07,2.6382E+07,1.7588E+07,8.7937E+06,2.5991E+00/
      DATA ((KB(JS,JT,53,16),JS=1,5),JT=1,5) /
     &5.9694E+07,4.4771E+07,2.9847E+07,1.4924E+07,1.9593E+02,
     &5.5520E+07,4.1640E+07,2.7760E+07,1.3880E+07,1.5986E+02,
     &5.1713E+07,3.8785E+07,2.5857E+07,1.2928E+07,1.1418E+02,
     &4.8267E+07,3.6200E+07,2.4134E+07,1.2067E+07,6.7101E+01,
     &4.5154E+07,3.3866E+07,2.2577E+07,1.1289E+07,5.4836E-05/
      DATA ((KB(JS,JT,54,16),JS=1,5),JT=1,5) /
     &6.6291E+07,4.9719E+07,3.3146E+07,1.6573E+07,2.0438E+02,
     &6.1631E+07,4.6223E+07,3.0816E+07,1.5408E+07,1.7539E+02,
     &5.7374E+07,4.3031E+07,2.8687E+07,1.4344E+07,1.3582E+02,
     &5.3498E+07,4.0123E+07,2.6749E+07,1.3375E+07,7.9383E+01,
     &5.0001E+07,3.7501E+07,2.5001E+07,1.2501E+07,1.9380E+01/
      DATA ((KB(JS,JT,55,16),JS=1,5),JT=1,5) /
     &6.7110E+07,5.0333E+07,3.3555E+07,1.6778E+07,2.1302E+02,
     &6.2350E+07,4.6763E+07,3.1175E+07,1.5588E+07,1.8842E+02,
     &5.8012E+07,4.3509E+07,2.9006E+07,1.4503E+07,1.5117E+02,
     &5.4054E+07,4.0541E+07,2.7027E+07,1.3514E+07,1.0060E+02,
     &5.0479E+07,3.7859E+07,2.5240E+07,1.2620E+07,5.1596E+01/
      DATA ((KB(JS,JT,56,16),JS=1,5),JT=1,5) /
     &6.7946E+07,5.0959E+07,3.3973E+07,1.6986E+07,2.2213E+02,
     &6.3087E+07,4.7315E+07,3.1543E+07,1.5771E+07,1.9599E+02,
     &5.8660E+07,4.3995E+07,2.9330E+07,1.4665E+07,1.7426E+02,
     &5.4632E+07,4.0974E+07,2.7316E+07,1.3658E+07,1.3341E+02,
     &5.0980E+07,3.8235E+07,2.5490E+07,1.2745E+07,7.5113E+01/
      DATA ((KB(JS,JT,57,16),JS=1,5),JT=1,5) /
     &6.8848E+07,5.1636E+07,3.4424E+07,1.7212E+07,2.3193E+02,
     &6.3831E+07,4.7873E+07,3.1915E+07,1.5958E+07,2.0396E+02,
     &5.9337E+07,4.4503E+07,2.9325E+07,1.4834E+07,1.8090E+02,
     &5.5232E+07,4.1423E+07,2.7615E+07,1.3808E+07,1.4946E+02,
     &5.1498E+07,3.8623E+07,2.5749E+07,1.2874E+07,9.6802E+01/
      DATA ((KB(JS,JT,58,16),JS=1,5),JT=1,5) /
     &1.8392E+07,1.6863E+07,1.4458E+07,1.0126E+07,2.4193E+02,
     &1.7018E+07,1.5603E+07,1.3378E+07,9.3701E+06,2.1195E+02,
     &1.5812E+07,1.4497E+07,1.2430E+07,8.7057E+06,1.8755E+02,
     &1.4710E+07,1.3487E+07,1.1564E+07,8.0993E+06,1.6722E+02,
     &1.3707E+07,1.2567E+07,1.0775E+07,7.5470E+06,1.3461E+02/
      DATA ((KB(JS,JT,59,16),JS=1,5),JT=1,5) /
     &2.1701E+07,1.8948E+07,1.5114E+07,9.4051E+06,2.4616E+02,
     &2.0062E+07,1.7517E+07,1.3973E+07,8.5918E+06,2.1536E+02,
     &1.8637E+07,1.6273E+07,1.2980E+07,8.0770E+06,1.9038E+02,
     &1.7332E+07,1.5134E+07,1.2072E+07,7.5118E+06,1.6959E+02,
     &1.6145E+07,1.4097E+07,1.1245E+07,6.9973E+06,1.5180E+02/

C     The array FORREF contains the coefficient of the water vapor
C     foreign-continuum (including the energy term).  The first 
C     index refers to reference temperature (296,260,224,260) and 
C     pressure (970,475,219,3 mbar) levels.  The second index 
C     runs over the g-channel (1 to 16).

      DATA (FORREF(1,IG),IG=1,16) /
     &3.3839e-04,2.4739e-04,2.2846e-04,2.3376e-04,2.2622e-04,2.3188e-04,
     &2.2990e-04,2.2532e-04,2.1233e-04,2.0593e-04,2.0716e-04,2.0809e-04,
     &2.0889e-04,2.0932e-04,2.0944e-04,2.0945e-04/
      DATA (FORREF(2,IG),IG=1,16) /
     &3.4391e-04,2.6022e-04,2.3449e-04,2.4544e-04,2.3831e-04,2.3014e-04,
     &2.3729e-04,2.2726e-04,2.1892e-04,1.9223e-04,2.1291e-04,2.1406e-04,
     &2.1491e-04,2.1548e-04,2.1562e-04,2.1567e-04/
      DATA (FORREF(3,IG),IG=1,16) /
     &3.4219e-04,2.7334e-04,2.3727e-04,2.4515e-04,2.5272e-04,2.4212e-04,
     &2.3824e-04,2.3615e-04,2.2724e-04,2.2381e-04,1.9634e-04,2.1625e-04,
     &2.1963e-04,2.2032e-04,2.2057e-04,2.2058e-04/
      DATA (FORREF(4,IG),IG=1,16) /
     &3.1684e-04,2.4823e-04,2.4890e-04,2.4577e-04,2.4106e-04,2.4353e-04,
     &2.4038e-04,2.3932e-04,2.3604e-04,2.3773e-04,2.4243e-04,2.2597e-04,
     &2.2879e-04,2.2440e-04,2.1104e-04,2.1460e-04/

C     The array SELFREF contains the coefficient of the water vapor
C     self-continuum (including the energy term).  The first index
C     refers to temperature in 7.2 degree increments.  For instance,
C     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
C     etc.  The second index runs over the g-channel (1 to 16).

      DATA (SELFREF(JT, 1),JT=1,10)  /
     & 2.62922e-01, 2.29106e-01, 1.99640e-01, 1.73964e-01, 1.51589e-01,
     & 1.32093e-01, 1.15104e-01, 1.00300e-01, 8.74000e-02, 7.61592e-02/
      DATA (SELFREF(JT, 2),JT=1,10)  /
     & 2.45448e-01, 2.13212e-01, 1.85210e-01, 1.60886e-01, 1.39756e-01,
     & 1.21401e-01, 1.05457e-01, 9.16070e-02, 7.95759e-02, 6.91249e-02/
      DATA (SELFREF(JT, 3),JT=1,10)  /
     & 2.41595e-01, 2.09697e-01, 1.82010e-01, 1.57979e-01, 1.37121e-01,
     & 1.19016e-01, 1.03302e-01, 8.96630e-02, 7.78246e-02, 6.75492e-02/
      DATA (SELFREF(JT, 4),JT=1,10)  /
     & 2.44818e-01, 2.12172e-01, 1.83880e-01, 1.59360e-01, 1.38110e-01,
     & 1.19694e-01, 1.03733e-01, 8.99010e-02, 7.79131e-02, 6.75238e-02/
      DATA (SELFREF(JT, 5),JT=1,10)  /
     & 2.43458e-01, 2.10983e-01, 1.82840e-01, 1.58451e-01, 1.37315e-01,
     & 1.18998e-01, 1.03125e-01, 8.93690e-02, 7.74480e-02, 6.71171e-02/
      DATA (SELFREF(JT, 6),JT=1,10)  /
     & 2.40186e-01, 2.08745e-01, 1.81420e-01, 1.57672e-01, 1.37032e-01,
     & 1.19095e-01, 1.03505e-01, 8.99560e-02, 7.81806e-02, 6.79467e-02/
      DATA (SELFREF(JT, 7),JT=1,10)  /
     & 2.42752e-01, 2.10579e-01, 1.82670e-01, 1.58460e-01, 1.37459e-01,
     & 1.19240e-01, 1.03437e-01, 8.97280e-02, 7.78359e-02, 6.75200e-02/
      DATA (SELFREF(JT, 8),JT=1,10)  /
     & 2.39620e-01, 2.08166e-01, 1.80840e-01, 1.57101e-01, 1.36479e-01,
     & 1.18563e-01, 1.03000e-01, 8.94790e-02, 7.77332e-02, 6.75292e-02/
      DATA (SELFREF(JT, 9),JT=1,10)  /
     & 2.38856e-01, 2.07166e-01, 1.79680e-01, 1.55841e-01, 1.35165e-01,
     & 1.17232e-01, 1.01678e-01, 8.81880e-02, 7.64877e-02, 6.63397e-02/
      DATA (SELFREF(JT,10),JT=1,10)  /
     & 2.29821e-01, 2.00586e-01, 1.75070e-01, 1.52800e-01, 1.33363e-01,
     & 1.16398e-01, 1.01591e-01, 8.86680e-02, 7.73887e-02, 6.75443e-02/
      DATA (SELFREF(JT,11),JT=1,10)  /
     & 2.39945e-01, 2.08186e-01, 1.80630e-01, 1.56722e-01, 1.35978e-01,
     & 1.17980e-01, 1.02364e-01, 8.88150e-02, 7.70594e-02, 6.68598e-02/
      DATA (SELFREF(JT,12),JT=1,10)  /
     & 2.40271e-01, 2.08465e-01, 1.80870e-01, 1.56927e-01, 1.36154e-01,
     & 1.18131e-01, 1.02494e-01, 8.89260e-02, 7.71545e-02, 6.69412e-02/
      DATA (SELFREF(JT,13),JT=1,10)  /
     & 2.40503e-01, 2.08670e-01, 1.81050e-01, 1.57086e-01, 1.36294e-01,
     & 1.18254e-01, 1.02602e-01, 8.90210e-02, 7.72380e-02, 6.70147e-02/
      DATA (SELFREF(JT,14),JT=1,10)  /
     & 2.40670e-01, 2.08811e-01, 1.81170e-01, 1.57188e-01, 1.36380e-01,
     & 1.18327e-01, 1.02663e-01, 8.90730e-02, 7.72819e-02, 6.70517e-02/
      DATA (SELFREF(JT,15),JT=1,10)  /
     & 2.40711e-01, 2.08846e-01, 1.81200e-01, 1.57213e-01, 1.36402e-01,
     & 1.18346e-01, 1.02679e-01, 8.90870e-02, 7.72939e-02, 6.70621e-02/
      DATA (SELFREF(JT,16),JT=1,10)  /
     & 2.40727e-01, 2.08859e-01, 1.81210e-01, 1.57221e-01, 1.36408e-01,
     & 1.18350e-01, 1.02682e-01, 8.90890e-02, 7.72952e-02, 6.70627e-02/
