C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB05.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.1 $
C     created:   $Date: 2002/08/11 19:37:53 $
      PARAMETER (MG=16)
      DIMENSION SELFREF(10,MG), FORREF(4,MG)
      REAL KA(9,5,13,MG), KB(5,5,13:59,MG)
      REAL KA_MO3(9,19,MG)

      COMMON /HVRSN5/ HVRKG5

      COMMON /K5/ KA, KB, FORREF, SELFREF, KA_MO3

      CHARACTER*15 HVRKG5
      DATA HVRKG5  / '$Revision: 3.1 $' /


C     The array KA contains absorption coefs for each of the 16 g-intervals
C     for a range of pressure levels > ~100mb, temperatures, and ratios
C     of water vapor to CO2.  The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.
C     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
C     to different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this  pressure 
C     level, JT = 2 refers to the temperature
C     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
C     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
C     to the reference pressure level (e.g. JP = 1 is for a
C     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA ((KA(JS,JT, 1, 1),JS=1,9),JT=1,5) /
     &2.0627E-06,7.6619E-06,1.2821E-05,1.8547E-05,2.5694E-05,3.6833E-05,
     &6.0675E-05,1.0691E-04,4.5186E-05,2.7702E-06,1.0260E-05,1.6067E-05,
     &2.2990E-05,3.0808E-05,4.1244E-05,5.9411E-05,1.1066E-04,5.2628E-05,
     &3.6863E-06,1.3689E-05,2.0068E-05,2.8133E-05,3.7359E-05,4.8756E-05,
     &6.5660E-05,1.0750E-04,6.3147E-05,4.8209E-06,1.8184E-05,2.5811E-05,
     &3.2670E-05,4.2393E-05,5.7509E-05,7.7672E-05,1.1739E-04,6.0614E-05,
     &6.2011E-06,2.3679E-05,3.3185E-05,4.1098E-05,4.8872E-05,6.0199E-05,
     &8.6830E-05,1.3320E-04,5.7959E-05/
      DATA ((KA(JS,JT, 2, 1),JS=1,9),JT=1,5) /
     &2.3538E-06,6.7359E-06,1.0280E-05,1.4331E-05,1.9304E-05,2.5963E-05,
     &4.0842E-05,7.0297E-05,3.0786E-05,3.1800E-06,9.2776E-06,1.3401E-05,
     &1.8014E-05,2.3501E-05,3.0468E-05,4.1030E-05,7.2758E-05,3.6807E-05,
     &4.2644E-06,1.2589E-05,1.7414E-05,2.2365E-05,2.8924E-05,3.6996E-05,
     &4.7459E-05,7.1458E-05,4.4453E-05,5.6334E-06,1.6843E-05,2.2937E-05,
     &2.8083E-05,3.3609E-05,4.3642E-05,5.6794E-05,7.9540E-05,3.7769E-05,
     &7.3165E-06,2.2208E-05,2.9987E-05,3.5834E-05,4.1117E-05,4.7236E-05,
     &6.4507E-05,9.1784E-05,4.0356E-05/
      DATA ((KA(JS,JT, 3, 1),JS=1,9),JT=1,5) /
     &3.4149E-06,6.8426E-06,8.9161E-06,1.1292E-05,1.3987E-05,1.7689E-05,
     &2.4623E-05,4.0560E-05,1.8741E-05,4.6295E-06,9.5910E-06,1.2218E-05,
     &1.4773E-05,1.7906E-05,2.1627E-05,2.7175E-05,4.1902E-05,2.3338E-05,
     &6.2620E-06,1.3265E-05,1.6740E-05,1.9517E-05,2.2851E-05,2.6791E-05,
     &3.2311E-05,4.3092E-05,2.7303E-05,8.3825E-06,1.8025E-05,2.2633E-05,
     &2.5988E-05,2.8756E-05,3.2402E-05,3.9084E-05,5.0182E-05,2.3119E-05,
     &1.1030E-05,2.4184E-05,3.0218E-05,3.4428E-05,3.7379E-05,3.9667E-05,
     &4.3975E-05,5.8391E-05,2.6206E-05/
      DATA ((KA(JS,JT, 4, 1),JS=1,9),JT=1,5) /
     &5.0171E-06,7.6880E-06,8.7791E-06,9.8121E-06,1.1212E-05,1.2838E-05,
     &1.6066E-05,2.4377E-05,1.1689E-05,6.7946E-06,1.0789E-05,1.2297E-05,
     &1.3454E-05,1.4738E-05,1.6388E-05,1.8978E-05,2.5098E-05,1.5123E-05,
     &9.2346E-06,1.5122E-05,1.7217E-05,1.8715E-05,1.9870E-05,2.1284E-05,
     &2.3541E-05,2.8475E-05,1.5817E-05,1.2485E-05,2.0883E-05,2.3764E-05,
     &2.5687E-05,2.6834E-05,2.7524E-05,2.9511E-05,3.4495E-05,1.5461E-05,
     &1.6688E-05,2.8377E-05,3.2282E-05,3.4761E-05,3.6075E-05,3.6212E-05,
     &3.5832E-05,4.0812E-05,1.7475E-05/
      DATA ((KA(JS,JT, 5, 1),JS=1,9),JT=1,5) /
     &6.8849E-06,8.9001E-06,9.3032E-06,9.4606E-06,9.6746E-06,1.0252E-05,
     &1.1422E-05,1.5315E-05,7.4550E-06,9.2829E-06,1.2355E-05,1.3006E-05,
     &1.3223E-05,1.3294E-05,1.3454E-05,1.4383E-05,1.6505E-05,9.6725E-06,
     &1.2628E-05,1.7354E-05,1.8341E-05,1.8646E-05,1.8560E-05,1.8269E-05,
     &1.8381E-05,1.9847E-05,1.0746E-05,1.7178E-05,2.4178E-05,2.5699E-05,
     &2.6093E-05,2.5857E-05,2.5047E-05,2.4039E-05,2.4517E-05,1.1239E-05,
     &2.3232E-05,3.3207E-05,3.5417E-05,3.5933E-05,3.5521E-05,3.4179E-05,
     &3.1639E-05,3.0107E-05,1.3413E-05/
      DATA ((KA(JS,JT, 6, 1),JS=1,9),JT=1,5) /
     &8.9763E-06,1.0310E-05,1.0152E-05,9.7112E-06,9.1573E-06,8.7286E-06,
     &8.7100E-06,1.0151E-05,5.0468E-06,1.1944E-05,1.4094E-05,1.4098E-05,
     &1.3570E-05,1.2771E-05,1.1934E-05,1.1288E-05,1.1804E-05,6.4542E-06,
     &1.6264E-05,1.9621E-05,1.9778E-05,1.9110E-05,1.7995E-05,1.6619E-05,
     &1.5210E-05,1.4762E-05,7.7867E-06,2.2127E-05,2.7394E-05,2.7774E-05,
     &2.6897E-05,2.5333E-05,2.3366E-05,2.0855E-05,1.8805E-05,9.1527E-06,
     &3.0031E-05,3.7976E-05,3.8538E-05,3.7483E-05,3.5390E-05,3.2530E-05,
     &2.8729E-05,2.4137E-05,1.0787E-05/
      DATA ((KA(JS,JT, 7, 1),JS=1,9),JT=1,5) /
     &1.2661E-05,1.3255E-05,1.2476E-05,1.1360E-05,1.0126E-05,8.8167E-06,
     &7.6811E-06,7.2819E-06,3.4701E-06,1.6507E-05,1.7720E-05,1.6880E-05,
     &1.5585E-05,1.3986E-05,1.2151E-05,1.0259E-05,8.9670E-06,4.6214E-06,
     &2.2311E-05,2.4431E-05,2.3459E-05,2.1822E-05,1.9662E-05,1.7085E-05,
     &1.4272E-05,1.1641E-05,5.9077E-06,3.0470E-05,3.3907E-05,3.2735E-05,
     &3.0550E-05,2.7736E-05,2.4159E-05,2.0093E-05,1.5711E-05,7.6152E-06,
     &4.1581E-05,4.6778E-05,4.5634E-05,4.2827E-05,3.9000E-05,3.4010E-05,
     &2.8185E-05,2.1414E-05,9.5151E-06/
      DATA ((KA(JS,JT, 8, 1),JS=1,9),JT=1,5) /
     &2.2110E-05,2.1516E-05,1.9520E-05,1.7197E-05,1.4610E-05,1.1834E-05,
     &8.9776E-06,6.4038E-06,2.9294E-06,2.8119E-05,2.7833E-05,2.5591E-05,
     &2.2815E-05,1.9548E-05,1.6035E-05,1.2291E-05,8.4633E-06,3.7469E-06,
     &3.7519E-05,3.7575E-05,3.4963E-05,3.1329E-05,2.6989E-05,2.2379E-05,
     &1.7209E-05,1.1658E-05,5.1343E-06,5.1233E-05,5.1900E-05,4.8534E-05,
     &4.3661E-05,3.7852E-05,3.1455E-05,2.4380E-05,1.6303E-05,6.8677E-06,
     &7.0275E-05,7.1610E-05,6.7129E-05,6.0809E-05,5.2885E-05,4.4177E-05,
     &3.4435E-05,2.2981E-05,8.8724E-06/
      DATA ((KA(JS,JT, 9, 1),JS=1,9),JT=1,5) /
     &7.5307E-05,6.8982E-05,6.0564E-05,5.1649E-05,4.2335E-05,3.2789E-05,
     &2.3004E-05,1.2766E-05,4.1976E-06,9.3306E-05,8.6322E-05,7.6065E-05,
     &6.5167E-05,5.3786E-05,4.2095E-05,2.9960E-05,1.6892E-05,6.0950E-06,
     &1.2202E-04,1.1392E-04,1.0068E-04,8.6696E-05,7.2080E-05,5.6739E-05,
     &4.0820E-05,2.3292E-05,8.3200E-06,1.6580E-04,1.5570E-04,1.3769E-04,
     &1.1869E-04,9.9119E-05,7.8735E-05,5.6759E-05,3.2860E-05,1.0538E-05,
     &2.2845E-04,2.1403E-04,1.8995E-04,1.6428E-04,1.3747E-04,1.0943E-04,
     &7.9478E-05,4.6333E-05,1.2645E-05/
      DATA ((KA(JS,JT,10, 1),JS=1,9),JT=1,5) /
     &2.9742E-04,2.6515E-04,2.2972E-04,1.9315E-04,1.5610E-04,1.1880E-04,
     &8.1117E-05,4.2319E-05,6.3944E-06,3.6180E-04,3.2444E-04,2.8214E-04,
     &2.3809E-04,1.9281E-04,1.4714E-04,1.0099E-04,5.3082E-05,9.7791E-06,
     &4.6752E-04,4.2137E-04,3.6703E-04,3.1031E-04,2.5194E-04,1.9278E-04,
     &1.3274E-04,7.0692E-05,1.3731E-05,6.3024E-04,5.6976E-04,4.9706E-04,
     &4.2128E-04,3.4229E-04,2.6250E-04,1.8103E-04,9.7478E-05,1.8873E-05,
     &8.6816E-04,7.8510E-04,6.8602E-04,5.8224E-04,4.7468E-04,3.6394E-04,
     &2.5185E-04,1.3590E-04,2.4864E-05/
      DATA ((KA(JS,JT,11, 1),JS=1,9),JT=1,5) /
     &4.4215E-04,3.9273E-04,3.3972E-04,2.8576E-04,2.3079E-04,1.7475E-04,
     &1.1858E-04,6.1576E-05,6.9970E-06,5.4524E-04,4.8624E-04,4.2158E-04,
     &3.5507E-04,2.8728E-04,2.1797E-04,1.4849E-04,7.7710E-05,1.0796E-05,
     &7.1212E-04,6.3874E-04,5.5491E-04,4.6791E-04,3.7968E-04,2.8946E-04,
     &1.9751E-04,1.0405E-04,1.6156E-05,9.7112E-04,8.7198E-04,7.5717E-04,
     &6.3918E-04,5.1919E-04,3.9650E-04,2.7055E-04,1.4272E-04,2.2761E-05,
     &1.3431E-03,1.2076E-03,1.0484E-03,8.8503E-04,7.1868E-04,5.4992E-04,
     &3.7609E-04,1.9954E-04,2.9940E-05/
      DATA ((KA(JS,JT,12, 1),JS=1,9),JT=1,5) /
     &4.8443E-04,4.2968E-04,3.7109E-04,3.1171E-04,2.5157E-04,1.9045E-04,
     &1.2868E-04,6.6606E-05,6.8294E-06,6.0269E-04,5.3630E-04,4.6453E-04,
     &3.9092E-04,3.1605E-04,2.4000E-04,1.6259E-04,8.4751E-05,1.0182E-05,
     &7.9706E-04,7.1250E-04,6.1805E-04,5.2087E-04,4.2192E-04,3.2125E-04,
     &2.1834E-04,1.1445E-04,1.5140E-05,1.0910E-03,9.7656E-04,8.4711E-04,
     &7.1442E-04,5.7891E-04,4.4221E-04,3.0181E-04,1.5855E-04,2.1388E-05,
     &1.5134E-03,1.3551E-03,1.1752E-03,9.9093E-04,8.0388E-04,6.1444E-04,
     &4.2020E-04,2.2117E-04,2.9059E-05/
      DATA ((KA(JS,JT,13, 1),JS=1,9),JT=1,5) /
     &4.2625E-04,3.7812E-04,3.2711E-04,2.7465E-04,2.2177E-04,1.6800E-04,
     &1.1342E-04,5.8678E-05,7.1193E-06,5.3759E-04,4.7832E-04,4.1433E-04,
     &3.4844E-04,2.8188E-04,2.1423E-04,1.4519E-04,7.5588E-05,1.0317E-05,
     &7.2018E-04,6.4309E-04,5.5764E-04,4.6948E-04,3.8030E-04,2.8938E-04,
     &1.9678E-04,1.0285E-04,1.4041E-05,9.8953E-04,8.8546E-04,7.6800E-04,
     &6.4711E-04,5.2450E-04,3.9956E-04,2.7312E-04,1.4349E-04,1.9954E-05,
     &1.3790E-03,1.2366E-03,1.0731E-03,9.0477E-04,7.3377E-04,5.6037E-04,
     &3.8365E-04,2.0147E-04,2.6871E-05/
      DATA ((KA(JS,JT, 1, 2),JS=1,9),JT=1,5) /
     &6.2300E-06,2.3124E-05,2.9698E-05,3.9591E-05,5.8380E-05,9.5125E-05,
     &1.3537E-04,2.8288E-04,9.7543E-05,9.0246E-06,3.3229E-05,4.2160E-05,
     &4.9478E-05,6.0779E-05,8.5533E-05,1.5267E-04,2.3904E-04,8.0422E-05,
     &1.2807E-05,4.6362E-05,5.9074E-05,6.7253E-05,7.5131E-05,8.9889E-05,
     &1.2494E-04,2.6418E-04,7.9145E-05,1.7786E-05,6.3031E-05,8.0225E-05,
     &9.3521E-05,1.0301E-04,1.0987E-04,1.2899E-04,2.0499E-04,1.0830E-04,
     &2.4116E-05,8.3783E-05,1.0646E-04,1.2431E-04,1.3944E-04,1.5277E-04,
     &1.5881E-04,2.0933E-04,1.4344E-04/
      DATA ((KA(JS,JT, 2, 2),JS=1,9),JT=1,5) /
     &7.1421E-06,2.2132E-05,2.7590E-05,3.3376E-05,4.3482E-05,6.6128E-05,
     &9.2521E-05,1.8166E-04,6.3119E-05,1.0480E-05,3.2273E-05,3.9804E-05,
     &4.4484E-05,4.9766E-05,6.2224E-05,1.0181E-04,1.6062E-04,5.5112E-05,
     &1.5069E-05,4.5805E-05,5.6454E-05,6.2730E-05,6.6262E-05,7.1655E-05,
     &8.8554E-05,1.7608E-04,5.4833E-05,2.1158E-05,6.3205E-05,7.7534E-05,
     &8.6669E-05,9.2743E-05,9.3710E-05,9.8368E-05,1.4175E-04,8.3989E-05,
     &2.9018E-05,8.5014E-05,1.0387E-04,1.1638E-04,1.2535E-04,1.3160E-04,
     &1.2952E-04,1.4715E-04,1.0168E-04/
      DATA ((KA(JS,JT, 3, 2),JS=1,9),JT=1,5) /
     &1.0134E-05,2.3698E-05,2.8098E-05,3.0832E-05,3.4559E-05,4.2739E-05,
     &5.8413E-05,1.0086E-04,3.2546E-05,1.5067E-05,3.5478E-05,4.1782E-05,
     &4.4927E-05,4.6304E-05,4.9338E-05,6.0952E-05,9.7126E-05,3.2271E-05,
     &2.2020E-05,5.1526E-05,6.0415E-05,6.4785E-05,6.5815E-05,6.4970E-05,
     &6.6401E-05,9.8577E-05,3.7377E-05,3.1402E-05,7.2606E-05,8.4750E-05,
     &9.0680E-05,9.2879E-05,9.1127E-05,8.5666E-05,9.2372E-05,5.9881E-05,
     &4.3798E-05,9.9375E-05,1.1577E-04,1.2361E-04,1.2645E-04,1.2543E-04,
     &1.1954E-04,1.0799E-04,6.6216E-05/
      DATA ((KA(JS,JT, 4, 2),JS=1,9),JT=1,5) /
     &1.4395E-05,2.6113E-05,2.9242E-05,3.0501E-05,3.0825E-05,3.2335E-05,
     &3.9824E-05,5.5770E-05,1.8987E-05,2.1448E-05,3.9639E-05,4.4560E-05,
     &4.6391E-05,4.5970E-05,4.4537E-05,4.5440E-05,6.3416E-05,1.9764E-05,
     &3.1834E-05,5.8680E-05,6.6149E-05,6.8528E-05,6.7668E-05,6.3937E-05,
     &5.8285E-05,6.2232E-05,2.7306E-05,4.6271E-05,8.4438E-05,9.5181E-05,
     &9.8206E-05,9.6873E-05,9.1747E-05,8.1681E-05,6.9834E-05,3.9615E-05,
     &6.5671E-05,1.1809E-04,1.3274E-04,1.3673E-04,1.3457E-04,1.2744E-04,
     &1.1523E-04,9.3255E-05,4.5946E-05/
      DATA ((KA(JS,JT, 5, 2),JS=1,9),JT=1,5) /
     &1.8932E-05,2.8174E-05,3.0127E-05,3.0189E-05,2.9303E-05,2.7710E-05,
     &2.8724E-05,3.6981E-05,1.2871E-05,2.8193E-05,4.3103E-05,4.6483E-05,
     &4.6716E-05,4.5184E-05,4.1972E-05,3.7796E-05,4.2113E-05,1.5002E-05,
     &4.2171E-05,6.4890E-05,7.0138E-05,7.0754E-05,6.8197E-05,6.2875E-05,
     &5.4545E-05,4.7871E-05,1.9971E-05,6.2206E-05,9.5463E-05,1.0284E-04,
     &1.0393E-04,9.9869E-05,9.1904E-05,7.9592E-05,6.1772E-05,2.7676E-05,
     &8.9897E-05,1.3643E-04,1.4635E-04,1.4773E-04,1.4191E-04,1.3018E-04,
     &1.1303E-04,8.6827E-05,3.3409E-05/
      DATA ((KA(JS,JT, 6, 2),JS=1,9),JT=1,5) /
     &2.3688E-05,3.0481E-05,3.1060E-05,3.0054E-05,2.7961E-05,2.5367E-05,
     &2.2999E-05,2.6629E-05,1.0275E-05,3.4582E-05,4.5983E-05,4.7133E-05,
     &4.6002E-05,4.3141E-05,3.8854E-05,3.3303E-05,2.9897E-05,1.2224E-05,
     &5.1699E-05,6.9356E-05,7.1684E-05,7.0505E-05,6.6405E-05,5.9819E-05,
     &5.0541E-05,3.9074E-05,1.6179E-05,7.7368E-05,1.0342E-04,1.0714E-04,
     &1.0541E-04,9.9595E-05,8.9603E-05,7.5459E-05,5.5384E-05,2.1206E-05,
     &1.1347E-04,1.5064E-04,1.5637E-04,1.5316E-04,1.4449E-04,1.2985E-04,
     &1.0910E-04,8.0324E-05,2.6862E-05/
      DATA ((KA(JS,JT, 7, 2),JS=1,9),JT=1,5) /
     &3.2355E-05,3.6612E-05,3.5642E-05,3.3581E-05,3.0393E-05,2.6088E-05,
     &2.1415E-05,1.9368E-05,9.5314E-06,4.6022E-05,5.3816E-05,5.2843E-05,
     &4.9963E-05,4.5493E-05,3.9581E-05,3.2262E-05,2.4294E-05,1.1772E-05,
     &6.7685E-05,8.0405E-05,7.9935E-05,7.5649E-05,6.9218E-05,6.0527E-05,
     &4.9342E-05,3.5155E-05,1.4463E-05,1.0120E-04,1.2036E-04,1.2034E-04,
     &1.1418E-04,1.0434E-04,9.1774E-05,7.5257E-05,5.2793E-05,1.8375E-05,
     &1.5071E-04,1.7822E-04,1.7733E-04,1.6840E-04,1.5410E-04,1.3584E-04,
     &1.1141E-04,7.8080E-05,2.3868E-05/
      DATA ((KA(JS,JT, 8, 2),JS=1,9),JT=1,5) /
     &5.5226E-05,5.6106E-05,5.2275E-05,4.7400E-05,4.1299E-05,3.4449E-05,
     &2.6593E-05,1.7838E-05,1.0224E-05,7.6682E-05,7.9501E-05,7.4950E-05,
     &6.8270E-05,5.9838E-05,5.0360E-05,3.9211E-05,2.5644E-05,1.3679E-05,
     &1.1162E-04,1.1744E-04,1.1105E-04,1.0166E-04,8.9544E-05,7.5446E-05,
     &5.9105E-05,3.8912E-05,1.6924E-05,1.6426E-04,1.7413E-04,1.6536E-04,
     &1.5206E-04,1.3480E-04,1.1398E-04,8.9434E-05,5.9125E-05,2.1439E-05,
     &2.4317E-04,2.5868E-04,2.4524E-04,2.2533E-04,2.0048E-04,1.6943E-04,
     &1.3297E-04,8.8280E-05,2.6395E-05/
      DATA ((KA(JS,JT, 9, 2),JS=1,9),JT=1,5) /
     &1.8480E-04,1.7106E-04,1.5192E-04,1.3086E-04,1.0905E-04,8.6158E-05,
     &6.2340E-05,3.6177E-05,1.4903E-05,2.4641E-04,2.3135E-04,2.0759E-04,
     &1.8017E-04,1.5122E-04,1.2054E-04,8.8111E-05,5.2211E-05,2.0425E-05,
     &3.5294E-04,3.3406E-04,3.0047E-04,2.6193E-04,2.2100E-04,1.7727E-04,
     &1.3000E-04,7.7386E-05,2.5956E-05,5.2033E-04,4.9504E-04,4.4640E-04,
     &3.9034E-04,3.2978E-04,2.6409E-04,1.9434E-04,1.1587E-04,3.4101E-05,
     &7.6495E-04,7.3083E-04,6.5854E-04,5.7617E-04,4.8713E-04,3.9080E-04,
     &2.8811E-04,1.7251E-04,4.3686E-05/
      DATA ((KA(JS,JT,10, 2),JS=1,9),JT=1,5) /
     &7.1951E-04,6.4170E-04,5.5848E-04,4.7254E-04,3.8543E-04,2.9616E-04,
     &2.0442E-04,1.0914E-04,2.8683E-05,9.5077E-04,8.5141E-04,7.4327E-04,
     &6.3053E-04,5.1626E-04,3.9828E-04,2.7613E-04,1.4913E-04,3.8199E-05,
     &1.3355E-03,1.2001E-03,1.0504E-03,8.9360E-04,7.3324E-04,5.6715E-04,
     &3.9425E-04,2.1480E-04,4.7134E-05,1.9553E-03,1.7643E-03,1.5470E-03,
     &1.3173E-03,1.0803E-03,8.3446E-04,5.8166E-04,3.1871E-04,5.8212E-05,
     &2.8783E-03,2.5953E-03,2.2770E-03,1.9407E-03,1.5909E-03,1.2316E-03,
     &8.6003E-04,4.7307E-04,7.1136E-05/
      DATA ((KA(JS,JT,11, 2),JS=1,9),JT=1,5) /
     &1.1139E-03,9.8774E-04,8.5580E-04,7.2091E-04,5.8416E-04,4.4688E-04,
     &3.0678E-04,1.6222E-04,3.9161E-05,1.5083E-03,1.3423E-03,1.1649E-03,
     &9.8455E-04,8.0047E-04,6.1397E-04,4.2291E-04,2.2482E-04,5.4701E-05,
     &2.1559E-03,1.9181E-03,1.6686E-03,1.4112E-03,1.1484E-03,8.7957E-04,
     &6.0584E-04,3.2346E-04,6.6564E-05,3.1472E-03,2.8085E-03,2.4474E-03,
     &2.0740E-03,1.6883E-03,1.2953E-03,8.9345E-04,4.7890E-04,8.3118E-05,
     &4.6362E-03,4.1388E-03,3.6072E-03,3.0601E-03,2.4938E-03,1.9129E-03,
     &1.3182E-03,7.0366E-04,1.0053E-04/
      DATA ((KA(JS,JT,12, 2),JS=1,9),JT=1,5) /
     &1.2746E-03,1.1293E-03,9.7744E-04,8.2280E-04,6.6509E-04,5.0694E-04,
     &3.4671E-04,1.8255E-04,4.0437E-05,1.7556E-03,1.5589E-03,1.3508E-03,
     &1.1390E-03,9.2389E-04,7.0640E-04,4.8477E-04,2.5611E-04,5.8338E-05,
     &2.5208E-03,2.2390E-03,1.9427E-03,1.6407E-03,1.3325E-03,1.0177E-03,
     &6.9952E-04,3.6990E-04,7.2977E-05,3.7199E-03,3.3065E-03,2.8736E-03,
     &2.4286E-03,1.9715E-03,1.5043E-03,1.0308E-03,5.4613E-04,9.0596E-05,
     &5.4892E-03,4.8847E-03,4.2441E-03,3.5888E-03,2.9119E-03,2.2221E-03,
     &1.5249E-03,8.0704E-04,1.1205E-04/
      DATA ((KA(JS,JT,13, 2),JS=1,9),JT=1,5) /
     &1.1670E-03,1.0343E-03,8.9403E-04,7.5206E-04,6.0815E-04,4.6361E-04,
     &3.1684E-04,1.6665E-04,3.8297E-05,1.6263E-03,1.4448E-03,1.2518E-03,
     &1.0548E-03,8.5537E-04,6.5308E-04,4.4734E-04,2.3634E-04,5.4012E-05,
     &2.3576E-03,2.0975E-03,1.8201E-03,1.5368E-03,1.2479E-03,9.5295E-04,
     &6.5303E-04,3.4532E-04,6.8858E-05,3.5158E-03,3.1277E-03,2.7158E-03,
     &2.2939E-03,1.8617E-03,1.4210E-03,9.7237E-04,5.1302E-04,8.6284E-05,
     &5.1868E-03,4.6126E-03,4.0043E-03,3.3796E-03,2.7407E-03,2.0921E-03,
     &1.4302E-03,7.5554E-04,1.0703E-04/
      DATA ((KA(JS,JT, 1, 3),JS=1,9),JT=1,5) /
     &2.1967E-05,7.0847E-05,9.8056E-05,1.1683E-04,1.2672E-04,1.3386E-04,
     &1.7335E-04,3.0889E-04,1.4104E-04,3.2805E-05,1.0021E-04,1.3719E-04,
     &1.6469E-04,1.8755E-04,2.0275E-04,1.9715E-04,2.9590E-04,1.6430E-04,
     &4.7330E-05,1.3749E-04,1.8575E-04,2.2309E-04,2.5257E-04,2.7701E-04,
     &3.0293E-04,3.2277E-04,1.5833E-04,6.6184E-05,1.8358E-04,2.4505E-04,
     &2.9115E-04,3.2275E-04,3.3970E-04,3.6327E-04,4.7032E-04,1.5296E-04,
     &8.9953E-05,2.3845E-04,3.1568E-04,3.7021E-04,4.0111E-04,4.1250E-04,
     &4.1712E-04,4.9013E-04,1.7116E-04/
      DATA ((KA(JS,JT, 2, 3),JS=1,9),JT=1,5) /
     &2.6480E-05,6.7795E-05,8.8273E-05,1.0239E-04,1.1087E-04,1.1252E-04,
     &1.2626E-04,1.7765E-04,1.0235E-04,4.0229E-05,9.8115E-05,1.2639E-04,
     &1.4693E-04,1.6171E-04,1.7149E-04,1.6078E-04,2.0296E-04,1.0513E-04,
     &5.9019E-05,1.3751E-04,1.7468E-04,2.0166E-04,2.2223E-04,2.3730E-04,
     &2.4647E-04,2.3569E-04,1.0639E-04,8.3741E-05,1.8682E-04,2.3419E-04,
     &2.6910E-04,2.9309E-04,3.0629E-04,3.1256E-04,3.4516E-04,1.0584E-04,
     &1.1534E-04,2.4682E-04,3.0598E-04,3.4903E-04,3.7559E-04,3.8169E-04,
     &3.7221E-04,3.8365E-04,1.2786E-04/
      DATA ((KA(JS,JT, 3, 3),JS=1,9),JT=1,5) /
     &3.8574E-05,7.5157E-05,8.9382E-05,9.8254E-05,1.0233E-04,1.0063E-04,
     &1.0056E-04,1.0870E-04,6.8446E-05,6.0142E-05,1.1264E-04,1.3244E-04,
     &1.4504E-04,1.5242E-04,1.5259E-04,1.4806E-04,1.3730E-04,6.4347E-05,
     &9.0381E-05,1.6247E-04,1.8926E-04,2.0538E-04,2.1407E-04,2.1609E-04,
     &2.1113E-04,1.9332E-04,6.7739E-05,1.3106E-04,2.2712E-04,2.6180E-04,
     &2.8099E-04,2.9092E-04,2.9292E-04,2.8375E-04,2.7092E-04,6.8866E-05,
     &1.8403E-04,3.0884E-04,3.5100E-04,3.7380E-04,3.8510E-04,3.8362E-04,
     &3.6289E-04,3.2300E-04,9.2758E-05/
      DATA ((KA(JS,JT, 4, 3),JS=1,9),JT=1,5) /
     &5.4705E-05,8.6072E-05,9.6209E-05,1.0034E-04,9.9953E-05,9.5189E-05,
     &8.3161E-05,7.9207E-05,3.9423E-05,8.7751E-05,1.3347E-04,1.4769E-04,
     &1.5271E-04,1.5230E-04,1.4652E-04,1.3316E-04,1.0796E-04,4.2482E-05,
     &1.3536E-04,1.9949E-04,2.1780E-04,2.2400E-04,2.2194E-04,2.1254E-04,
     &1.9475E-04,1.6332E-04,4.5138E-05,2.0116E-04,2.8783E-04,3.1041E-04,
     &3.1735E-04,3.1196E-04,2.9572E-04,2.7052E-04,2.3211E-04,5.0851E-05,
     &2.8895E-04,4.0188E-04,4.2924E-04,4.3500E-04,4.2412E-04,3.9959E-04,
     &3.6227E-04,3.0072E-04,6.6760E-05/
      DATA ((KA(JS,JT, 5, 3),JS=1,9),JT=1,5) /
     &7.0137E-05,9.4755E-05,1.0063E-04,1.0127E-04,9.8061E-05,9.0698E-05,
     &7.7439E-05,5.9138E-05,2.6683E-05,1.1533E-04,1.5194E-04,1.5997E-04,
     &1.5979E-04,1.5340E-04,1.4208E-04,1.2486E-04,9.3241E-05,2.9592E-05,
     &1.8276E-04,2.3503E-04,2.4432E-04,2.4189E-04,2.3109E-04,2.1296E-04,
     &1.8693E-04,1.4538E-04,3.2790E-05,2.7903E-04,3.5030E-04,3.5953E-04,
     &3.5303E-04,3.3542E-04,3.0702E-04,2.6606E-04,2.0930E-04,3.9551E-05,
     &4.1070E-04,5.0357E-04,5.1208E-04,4.9861E-04,4.7008E-04,4.2683E-04,
     &3.6701E-04,2.8592E-04,5.1146E-05/
      DATA ((KA(JS,JT, 6, 3),JS=1,9),JT=1,5) /
     &8.1368E-05,9.8431E-05,1.0007E-04,9.7542E-05,9.2017E-05,8.3169E-05,
     &7.0090E-05,4.8919E-05,2.1156E-05,1.3706E-04,1.6300E-04,1.6503E-04,
     &1.5990E-04,1.4992E-04,1.3472E-04,1.1399E-04,8.3619E-05,2.5058E-05,
     &2.2338E-04,2.6147E-04,2.6146E-04,2.5118E-04,2.3339E-04,2.0831E-04,
     &1.7568E-04,1.3135E-04,2.8387E-05,3.5127E-04,4.0389E-04,3.9905E-04,
     &3.7918E-04,3.4971E-04,3.1035E-04,2.5984E-04,1.9266E-04,3.2799E-05,
     &5.3129E-04,6.0001E-04,5.8622E-04,5.5309E-04,5.0577E-04,4.4569E-04,
     &3.6955E-04,2.7080E-04,4.1496E-05/
      DATA ((KA(JS,JT, 7, 3),JS=1,9),JT=1,5) /
     &1.0007E-04,1.0969E-04,1.0696E-04,1.0012E-04,9.0860E-05,7.9591E-05,
     &6.5272E-05,4.4404E-05,1.8023E-05,1.6864E-04,1.8414E-04,1.7903E-04,
     &1.6759E-04,1.5212E-04,1.3294E-04,1.0932E-04,7.7110E-05,2.3161E-05,
     &2.8238E-04,3.0439E-04,2.9352E-04,2.7330E-04,2.4706E-04,2.1459E-04,
     &1.7451E-04,1.2351E-04,2.8855E-05,4.5659E-04,4.8716E-04,4.6539E-04,
     &4.2996E-04,3.8506E-04,3.3112E-04,2.6671E-04,1.8725E-04,3.4923E-05,
     &7.1027E-04,7.4800E-04,7.1021E-04,6.5078E-04,5.7777E-04,4.9194E-04,
     &3.9297E-04,2.7155E-04,4.1495E-05/
      DATA ((KA(JS,JT, 8, 3),JS=1,9),JT=1,5) /
     &1.5946E-04,1.5842E-04,1.4746E-04,1.3211E-04,1.1546E-04,9.6168E-05,
     &7.4324E-05,4.8395E-05,1.7989E-05,2.5770E-04,2.5704E-04,2.3941E-04,
     &2.1551E-04,1.8837E-04,1.5713E-04,1.2214E-04,8.1368E-05,2.3968E-05,
     &4.2472E-04,4.2443E-04,3.9713E-04,3.5763E-04,3.1122E-04,2.5901E-04,
     &2.0043E-04,1.3331E-04,3.2118E-05,7.0597E-04,6.9998E-04,6.4911E-04,
     &5.8037E-04,5.0147E-04,4.1570E-04,3.1990E-04,2.0974E-04,3.9608E-05,
     &1.1264E-03,1.1057E-03,1.0236E-03,9.1299E-04,7.8475E-04,6.4516E-04,
     &4.9155E-04,3.1715E-04,4.8541E-05/
      DATA ((KA(JS,JT, 9, 3),JS=1,9),JT=1,5) /
     &5.0227E-04,4.5998E-04,4.0915E-04,3.5429E-04,2.9541E-04,2.3264E-04,
     &1.6588E-04,9.6165E-05,2.6165E-05,7.8676E-04,7.2202E-04,6.4423E-04,
     &5.5868E-04,4.6624E-04,3.6840E-04,2.6387E-04,1.5409E-04,3.5446E-05,
     &1.2789E-03,1.1712E-03,1.0462E-03,9.0711E-04,7.5900E-04,5.9930E-04,
     &4.3043E-04,2.5008E-04,4.6358E-05,2.0840E-03,1.9016E-03,1.6924E-03,
     &1.4648E-03,1.2215E-03,9.6366E-04,6.9084E-04,4.0072E-04,6.1001E-05,
     &3.3367E-03,3.0441E-03,2.7105E-03,2.3462E-03,1.9558E-03,1.5435E-03,
     &1.1056E-03,6.3552E-04,7.9035E-05/
      DATA ((KA(JS,JT,10, 3),JS=1,9),JT=1,5) /
     &1.9385E-03,1.7157E-03,1.4863E-03,1.2534E-03,1.0193E-03,7.7905E-04,
     &5.3570E-04,2.8621E-04,4.8614E-05,2.9395E-03,2.6008E-03,2.2566E-03,
     &1.9073E-03,1.5534E-03,1.1938E-03,8.2332E-04,4.4169E-04,7.1291E-05,
     &4.6962E-03,4.1509E-03,3.6037E-03,3.0461E-03,2.4817E-03,1.9064E-03,
     &1.3190E-03,7.0872E-04,9.5825E-05,7.5852E-03,6.6994E-03,5.8186E-03,
     &4.9195E-03,4.0087E-03,3.0812E-03,2.1247E-03,1.1368E-03,1.1801E-04,
     &1.2000E-02,1.0601E-02,9.2089E-03,7.7807E-03,6.3408E-03,4.8692E-03,
     &3.3607E-03,1.8001E-03,1.5301E-04/
      DATA ((KA(JS,JT,11, 3),JS=1,9),JT=1,5) /
     &3.1614E-03,2.7883E-03,2.4150E-03,2.0359E-03,1.6451E-03,1.2526E-03,
     &8.5416E-04,4.4797E-04,5.8064E-05,4.7730E-03,4.2097E-03,3.6498E-03,
     &3.0671E-03,2.4809E-03,1.8948E-03,1.2977E-03,6.8686E-04,8.3754E-05,
     &7.6614E-03,6.7521E-03,5.8435E-03,4.9093E-03,3.9758E-03,3.0351E-03,
     &2.0807E-03,1.0948E-03,1.2253E-04,1.2246E-02,1.0785E-02,9.3301E-03,
     &7.8482E-03,6.3562E-03,4.8536E-03,3.3260E-03,1.7481E-03,1.5741E-04,
     &1.9021E-02,1.6750E-02,1.4500E-02,1.2206E-02,9.8921E-03,7.5567E-03,
     &5.1767E-03,2.7251E-03,2.0052E-04/
      DATA ((KA(JS,JT,12, 3),JS=1,9),JT=1,5) /
     &3.8826E-03,3.4185E-03,2.9574E-03,2.4900E-03,2.0123E-03,1.5298E-03,
     &1.0368E-03,5.3904E-04,6.3688E-05,5.8362E-03,5.1381E-03,4.4457E-03,
     &3.7372E-03,3.0206E-03,2.2947E-03,1.5681E-03,8.2298E-04,8.9290E-05,
     &9.2251E-03,8.1210E-03,7.0237E-03,5.8967E-03,4.7688E-03,3.6322E-03,
     &2.4807E-03,1.3032E-03,1.3416E-04,1.4709E-02,1.2946E-02,1.1191E-02,
     &9.4045E-03,7.5956E-03,5.7870E-03,3.9575E-03,2.0727E-03,1.8001E-04,
     &2.2619E-02,1.9908E-02,1.7216E-02,1.4475E-02,1.1703E-02,8.9157E-03,
     &6.0792E-03,3.1754E-03,2.2086E-04/
      DATA ((KA(JS,JT,13, 3),JS=1,9),JT=1,5) /
     &3.8309E-03,3.3731E-03,2.9187E-03,2.4542E-03,1.9844E-03,1.5107E-03,
     &1.0279E-03,5.3642E-04,6.4942E-05,5.8347E-03,5.1376E-03,4.4461E-03,
     &3.7352E-03,3.0197E-03,2.2950E-03,1.5588E-03,8.1629E-04,9.2767E-05,
     &9.2194E-03,8.1162E-03,7.0173E-03,5.8930E-03,4.7598E-03,3.6175E-03,
     &2.4591E-03,1.2857E-03,1.3288E-04,1.4386E-02,1.2666E-02,1.0949E-02,
     &9.1979E-03,7.4294E-03,5.6460E-03,3.8493E-03,2.0075E-03,1.7458E-04,
     &2.1887E-02,1.9271E-02,1.6664E-02,1.4007E-02,1.1332E-02,8.6132E-03,
     &5.8543E-03,3.0399E-03,2.1866E-04/
      DATA ((KA(JS,JT, 1, 4),JS=1,9),JT=1,5) /
     &1.2767E-04,2.6436E-04,3.0512E-04,3.1799E-04,3.1958E-04,3.3191E-04,
     &3.9104E-04,5.0710E-04,1.7855E-04,1.7738E-04,3.5053E-04,3.9839E-04,
     &4.1229E-04,4.0492E-04,3.8983E-04,4.1500E-04,5.9614E-04,1.6036E-04,
     &2.3686E-04,4.4965E-04,5.0544E-04,5.1877E-04,5.0600E-04,4.7740E-04,
     &4.5052E-04,5.7236E-04,1.8787E-04,3.0650E-04,5.6569E-04,6.3165E-04,
     &6.4530E-04,6.3512E-04,6.1237E-04,5.6656E-04,5.2891E-04,2.7469E-04,
     &3.8512E-04,6.9752E-04,7.7525E-04,7.9245E-04,7.8883E-04,7.7085E-04,
     &7.4060E-04,6.7719E-04,3.6282E-04/
      DATA ((KA(JS,JT, 2, 4),JS=1,9),JT=1,5) /
     &1.5390E-04,2.7494E-04,3.1261E-04,3.2023E-04,3.1151E-04,2.9547E-04,
     &3.1497E-04,3.9039E-04,1.0989E-04,2.1714E-04,3.7453E-04,4.1638E-04,
     &4.2413E-04,4.1007E-04,3.7857E-04,3.5354E-04,4.2401E-04,1.1763E-04,
     &2.9352E-04,4.8938E-04,5.3784E-04,5.4431E-04,5.2257E-04,4.7749E-04,
     &4.2355E-04,4.2211E-04,1.4157E-04,3.8348E-04,6.2214E-04,6.8003E-04,
     &6.8421E-04,6.5590E-04,6.0605E-04,5.3467E-04,4.5064E-04,2.0612E-04,
     &4.8704E-04,7.7618E-04,8.4540E-04,8.4784E-04,8.1484E-04,7.6245E-04,
     &6.8894E-04,5.8453E-04,2.7190E-04/
      DATA ((KA(JS,JT, 3, 4),JS=1,9),JT=1,5) /
     &2.3071E-04,3.3499E-04,3.6845E-04,3.7270E-04,3.5547E-04,3.2203E-04,
     &2.7656E-04,2.6506E-04,6.2779E-05,3.3368E-04,4.7302E-04,5.1131E-04,
     &5.0923E-04,4.8101E-04,4.3420E-04,3.6192E-04,3.1963E-04,7.8022E-05,
     &4.6167E-04,6.3817E-04,6.7863E-04,6.7148E-04,6.3202E-04,5.6610E-04,
     &4.7208E-04,3.5841E-04,1.0032E-04,6.1421E-04,8.2728E-04,8.7092E-04,
     &8.6012E-04,8.0666E-04,7.1818E-04,5.9937E-04,4.3811E-04,1.4466E-04,
     &7.9318E-04,1.0499E-03,1.1001E-03,1.0825E-03,1.0111E-03,9.0157E-04,
     &7.5964E-04,5.7512E-04,1.9432E-04/
      DATA ((KA(JS,JT, 4, 4),JS=1,9),JT=1,5) /
     &3.4200E-04,4.1990E-04,4.4259E-04,4.3661E-04,4.1163E-04,3.6760E-04,
     &3.0371E-04,2.3149E-04,4.6307E-05,5.0920E-04,6.1539E-04,6.3721E-04,
     &6.1994E-04,5.7603E-04,5.0827E-04,4.1402E-04,2.9065E-04,5.1907E-05,
     &7.2424E-04,8.6063E-04,8.7699E-04,8.4266E-04,7.7721E-04,6.8304E-04,
     &5.5495E-04,3.8326E-04,6.9160E-05,9.8776E-04,1.1516E-03,1.1582E-03,
     &1.1044E-03,1.0138E-03,8.8821E-04,7.1753E-04,4.9169E-04,9.8233E-05,
     &1.2975E-03,1.4918E-03,1.4869E-03,1.4114E-03,1.2930E-03,1.1277E-03,
     &9.0840E-04,6.3197E-04,1.3450E-04/
      DATA ((KA(JS,JT, 5, 4),JS=1,9),JT=1,5) /
     &4.6076E-04,5.0474E-04,5.1144E-04,4.9140E-04,4.5232E-04,3.9779E-04,
     &3.2321E-04,2.2336E-04,3.4201E-05,7.0989E-04,7.6999E-04,7.6963E-04,
     &7.2952E-04,6.6336E-04,5.7413E-04,4.5930E-04,3.0843E-04,4.2292E-05,
     &1.0386E-03,1.1133E-03,1.0985E-03,1.0276E-03,9.2270E-04,7.9078E-04,
     &6.2825E-04,4.1898E-04,5.3586E-05,1.4541E-03,1.5404E-03,1.4988E-03,
     &1.3877E-03,1.2375E-03,1.0544E-03,8.3469E-04,5.5179E-04,6.8395E-05,
     &1.9528E-03,2.0463E-03,1.9719E-03,1.8145E-03,1.6102E-03,1.3677E-03,
     &1.0776E-03,7.0877E-04,9.0444E-05/
      DATA ((KA(JS,JT, 6, 4),JS=1,9),JT=1,5) /
     &5.6492E-04,5.7565E-04,5.5931E-04,5.2434E-04,4.7320E-04,4.0777E-04,
     &3.2512E-04,2.1641E-04,2.6966E-05,9.0441E-04,9.1447E-04,8.8349E-04,
     &8.2170E-04,7.3208E-04,6.2190E-04,4.8768E-04,3.1817E-04,3.4982E-05,
     &1.3664E-03,1.3688E-03,1.3074E-03,1.2015E-03,1.0584E-03,8.8601E-04,
     &6.8532E-04,4.4190E-04,4.5831E-05,1.9708E-03,1.9570E-03,1.8529E-03,
     &1.6859E-03,1.4692E-03,1.2199E-03,9.3583E-04,6.0020E-04,5.8072E-05,
     &2.7158E-03,2.6789E-03,2.5132E-03,2.2684E-03,1.9663E-03,1.6232E-03,
     &1.2393E-03,7.8815E-04,7.1453E-05/
      DATA ((KA(JS,JT, 7, 4),JS=1,9),JT=1,5) /
     &7.1612E-04,6.9080E-04,6.4557E-04,5.8741E-04,5.1690E-04,4.3484E-04,
     &3.3811E-04,2.1958E-04,2.5385E-05,1.1940E-03,1.1449E-03,1.0668E-03,
     &9.6669E-04,8.4588E-04,7.0528E-04,5.3962E-04,3.4196E-04,3.2650E-05,
     &1.8743E-03,1.7868E-03,1.6562E-03,1.4906E-03,1.2906E-03,1.0612E-03,
     &7.9912E-04,4.9523E-04,4.3298E-05,2.7760E-03,2.6274E-03,2.4197E-03,
     &2.1609E-03,1.8570E-03,1.5098E-03,1.1229E-03,6.8654E-04,5.4268E-05,
     &3.9210E-03,3.6980E-03,3.3854E-03,3.0037E-03,2.5627E-03,2.0710E-03,
     &1.5295E-03,9.2840E-04,6.7940E-05/
      DATA ((KA(JS,JT, 8, 4),JS=1,9),JT=1,5) /
     &1.0670E-03,9.8692E-04,8.9134E-04,7.8593E-04,6.7073E-04,5.4467E-04,
     &4.0756E-04,2.5210E-04,2.8359E-05,1.8582E-03,1.7102E-03,1.5414E-03,
     &1.3557E-03,1.1545E-03,9.3501E-04,6.9502E-04,4.2320E-04,3.7233E-05,
     &3.0392E-03,2.7815E-03,2.4987E-03,2.1910E-03,1.8592E-03,1.4974E-03,
     &1.1016E-03,6.5354E-04,4.6926E-05,4.6351E-03,4.2251E-03,3.7893E-03,
     &3.3101E-03,2.7928E-03,2.2311E-03,1.6189E-03,9.4084E-04,6.1285E-05,
     &6.7053E-03,6.1011E-03,5.4490E-03,4.7367E-03,3.9743E-03,3.1531E-03,
     &2.2726E-03,1.3072E-03,7.4486E-05/
      DATA ((KA(JS,JT, 9, 4),JS=1,9),JT=1,5) /
     &3.0079E-03,2.6671E-03,2.3362E-03,1.9921E-03,1.6375E-03,1.2739E-03,
     &8.9947E-04,5.0478E-04,4.8310E-05,5.3604E-03,4.7462E-03,4.1492E-03,
     &3.5341E-03,2.9054E-03,2.2583E-03,1.5943E-03,8.9078E-04,6.1843E-05,
     &9.0324E-03,7.9882E-03,6.9714E-03,5.9320E-03,4.8700E-03,3.7864E-03,
     &2.6693E-03,1.4872E-03,8.4369E-05,1.4329E-02,1.2658E-02,1.1032E-02,
     &9.3748E-03,7.6880E-03,5.9624E-03,4.1846E-03,2.3075E-03,1.0247E-04,
     &2.1261E-02,1.8755E-02,1.6325E-02,1.3858E-02,1.1339E-02,8.7669E-03,
     &6.1142E-03,3.3320E-03,1.2163E-04/
      DATA ((KA(JS,JT,10, 4),JS=1,9),JT=1,5) /
     &1.0911E-02,9.5635E-03,8.2330E-03,6.9092E-03,5.5802E-03,4.2396E-03,
     &2.8819E-03,1.5069E-03,1.0164E-04,1.8579E-02,1.6289E-02,1.4021E-02,
     &1.1757E-02,9.4958E-03,7.2115E-03,4.9034E-03,2.5692E-03,1.2765E-04,
     &3.1018E-02,2.7193E-02,2.3385E-02,1.9601E-02,1.5823E-02,1.2032E-02,
     &8.1956E-03,4.3045E-03,1.7856E-04,5.0111E-02,4.3919E-02,3.7756E-02,
     &3.1628E-02,2.5516E-02,1.9374E-02,1.3194E-02,6.9219E-03,2.2724E-04,
     &7.6376E-02,6.6924E-02,5.7507E-02,4.8151E-02,3.8816E-02,2.9439E-02,
     &2.0003E-02,1.0433E-02,2.6085E-04/
      DATA ((KA(JS,JT,11, 4),JS=1,9),JT=1,5) /
     &1.8971E-02,1.6611E-02,1.4262E-02,1.1923E-02,9.5992E-03,7.2680E-03,
     &4.9113E-03,2.5257E-03,1.6715E-04,3.0950E-02,2.7103E-02,2.3271E-02,
     &1.9463E-02,1.5664E-02,1.1847E-02,7.9981E-03,4.1199E-03,2.1489E-04,
     &4.9685E-02,4.3517E-02,3.7369E-02,3.1256E-02,2.5144E-02,1.9021E-02,
     &1.2853E-02,6.6396E-03,2.5990E-04,7.7374E-02,6.7750E-02,5.8163E-02,
     &4.8608E-02,3.9067E-02,2.9542E-02,1.9962E-02,1.0311E-02,3.2116E-04,
     &1.1501E-01,1.0072E-01,8.6431E-02,7.2217E-02,5.8056E-02,4.3898E-02,
     &2.9647E-02,1.5264E-02,3.7485E-04/
      DATA ((KA(JS,JT,12, 4),JS=1,9),JT=1,5) /
     &2.3401E-02,2.0486E-02,1.7582E-02,1.4686E-02,1.1806E-02,8.9258E-03,
     &6.0297E-03,3.0936E-03,1.8693E-04,3.8133E-02,3.3387E-02,2.8657E-02,
     &2.3944E-02,1.9250E-02,1.4544E-02,9.8021E-03,5.0235E-03,2.4530E-04,
     &6.0110E-02,5.2620E-02,4.5149E-02,3.7710E-02,3.0268E-02,2.2852E-02,
     &1.5390E-02,7.8945E-03,2.8864E-04,9.0890E-02,7.9571E-02,6.8303E-02,
     &5.7049E-02,4.5842E-02,3.4594E-02,2.3289E-02,1.1923E-02,3.6228E-04,
     &1.3100E-01,1.1462E-01,9.8322E-02,8.2088E-02,6.5959E-02,4.9780E-02,
     &3.3534E-02,1.7184E-02,4.3158E-04/
      DATA ((KA(JS,JT,13, 4),JS=1,9),JT=1,5) /
     &2.4303E-02,2.1262E-02,1.8230E-02,1.5211E-02,1.2213E-02,9.2155E-03,
     &6.2046E-03,3.1714E-03,1.9233E-04,3.8296E-02,3.3521E-02,2.8762E-02,
     &2.4031E-02,1.9310E-02,1.4568E-02,9.8072E-03,5.0047E-03,2.4842E-04,
     &5.8379E-02,5.1065E-02,4.3832E-02,3.6631E-02,2.9434E-02,2.2205E-02,
     &1.4940E-02,7.6384E-03,2.8734E-04,8.5558E-02,7.4841E-02,6.4227E-02,
     &5.3638E-02,4.3082E-02,3.2499E-02,2.1863E-02,1.1189E-02,3.6167E-04,
     &1.2105E-01,1.0601E-01,9.0943E-02,7.5945E-02,6.0995E-02,4.5990E-02,
     &3.0953E-02,1.5858E-02,4.3014E-04/
      DATA ((KA(JS,JT, 1, 5),JS=1,9),JT=1,5) /
     &5.2897E-04,6.3863E-04,6.7716E-04,6.8592E-04,6.6781E-04,6.0937E-04,
     &5.2069E-04,5.5022E-04,1.8160E-04,6.5371E-04,8.0837E-04,8.6369E-04,
     &8.8295E-04,8.7230E-04,8.3067E-04,7.4453E-04,6.6477E-04,2.9044E-04,
     &7.9309E-04,1.0041E-03,1.0806E-03,1.1131E-03,1.1135E-03,1.0810E-03,
     &1.0060E-03,8.6363E-04,4.3507E-04,9.5515E-04,1.2330E-03,1.3320E-03,
     &1.3798E-03,1.3866E-03,1.3599E-03,1.2978E-03,1.1703E-03,5.4823E-04,
     &1.1370E-03,1.4922E-03,1.6168E-03,1.6809E-03,1.6969E-03,1.6741E-03,
     &1.6142E-03,1.5306E-03,7.1233E-04/
      DATA ((KA(JS,JT, 2, 5),JS=1,9),JT=1,5) /
     &6.4530E-04,7.2673E-04,7.3348E-04,7.1463E-04,6.7564E-04,6.1110E-04,
     &5.0123E-04,4.4222E-04,1.3962E-04,8.0957E-04,9.2607E-04,9.4414E-04,
     &9.2480E-04,8.8433E-04,8.1497E-04,7.0697E-04,5.2414E-04,2.1889E-04,
     &9.9558E-04,1.1596E-03,1.1892E-03,1.1731E-03,1.1295E-03,1.0550E-03,
     &9.3776E-04,7.6366E-04,3.1779E-04,1.2093E-03,1.4336E-03,1.4751E-03,
     &1.4631E-03,1.4149E-03,1.3281E-03,1.2039E-03,1.0264E-03,4.0743E-04,
     &1.4548E-03,1.7501E-03,1.8041E-03,1.7977E-03,1.7416E-03,1.6424E-03,
     &1.5037E-03,1.3244E-03,5.3155E-04/
      DATA ((KA(JS,JT, 3, 5),JS=1,9),JT=1,5) /
     &1.0073E-03,1.0305E-03,9.9170E-04,9.1685E-04,8.2334E-04,7.1279E-04,
     &5.7365E-04,3.9412E-04,1.0025E-04,1.2880E-03,1.3316E-03,1.2867E-03,
     &1.1967E-03,1.0809E-03,9.4443E-04,7.8179E-04,5.3700E-04,1.5384E-04,
     &1.6107E-03,1.6903E-03,1.6390E-03,1.5300E-03,1.3886E-03,1.2242E-03,
     &1.0235E-03,7.5425E-04,2.1640E-04,1.9797E-03,2.1107E-03,2.0529E-03,
     &1.9209E-03,1.7527E-03,1.5541E-03,1.3094E-03,9.9288E-04,2.8803E-04,
     &2.4113E-03,2.6021E-03,2.5366E-03,2.3815E-03,2.1822E-03,1.9385E-03,
     &1.6375E-03,1.2689E-03,3.7641E-04/
      DATA ((KA(JS,JT, 4, 5),JS=1,9),JT=1,5) /
     &1.5851E-03,1.5181E-03,1.4032E-03,1.2606E-03,1.0883E-03,8.9739E-04,
     &6.8560E-04,4.2854E-04,6.6391E-05,2.0501E-03,1.9754E-03,1.8387E-03,
     &1.6565E-03,1.4386E-03,1.1914E-03,9.2359E-04,6.1319E-04,1.0381E-04,
     &2.6137E-03,2.5384E-03,2.3763E-03,2.1489E-03,1.8706E-03,1.5557E-03,
     &1.2160E-03,8.2392E-04,1.4611E-04,3.2665E-03,3.2074E-03,3.0134E-03,
     &2.7316E-03,2.3866E-03,1.9939E-03,1.5682E-03,1.0781E-03,1.9821E-04,
     &4.0137E-03,3.9873E-03,3.7629E-03,3.4158E-03,2.9921E-03,2.5128E-03,
     &1.9870E-03,1.3733E-03,2.6370E-04/
      DATA ((KA(JS,JT, 5, 5),JS=1,9),JT=1,5) /
     &2.2692E-03,2.1006E-03,1.8869E-03,1.6579E-03,1.4070E-03,1.1280E-03,
     &8.2786E-04,4.9332E-04,4.7300E-05,2.9951E-03,2.7795E-03,2.5097E-03,
     &2.2151E-03,1.8839E-03,1.5178E-03,1.1209E-03,6.8743E-04,6.4441E-05,
     &3.8783E-03,3.6150E-03,3.2821E-03,2.9041E-03,2.4789E-03,2.0050E-03,
     &1.4894E-03,9.2698E-04,9.4008E-05,4.9258E-03,4.6186E-03,4.2220E-03,
     &3.7446E-03,3.2015E-03,2.5968E-03,1.9395E-03,1.2217E-03,1.3185E-04,
     &6.1149E-03,5.7761E-03,5.3147E-03,4.7312E-03,4.0567E-03,3.3012E-03,
     &2.4775E-03,1.5747E-03,1.8186E-04/
      DATA ((KA(JS,JT, 6, 5),JS=1,9),JT=1,5) /
     &2.9777E-03,2.7020E-03,2.3926E-03,2.0653E-03,1.7240E-03,1.3628E-03,
     &9.7585E-04,5.5769E-04,3.7018E-05,4.0405E-03,3.6698E-03,3.2527E-03,
     &2.8150E-03,2.3582E-03,1.8689E-03,1.3459E-03,7.7825E-04,5.0931E-05,
     &5.2985E-03,4.8259E-03,4.2980E-03,3.7351E-03,3.1354E-03,2.4956E-03,
     &1.8046E-03,1.0570E-03,6.8165E-05,6.8330E-03,6.2458E-03,5.5922E-03,
     &4.8800E-03,4.1117E-03,3.2799E-03,2.3798E-03,1.4059E-03,8.9401E-05,
     &8.6003E-03,7.8905E-03,7.1103E-03,6.2229E-03,5.2575E-03,4.2076E-03,
     &3.0687E-03,1.8306E-03,1.2028E-04/
      DATA ((KA(JS,JT, 7, 5),JS=1,9),JT=1,5) /
     &4.0427E-03,3.6171E-03,3.1732E-03,2.7085E-03,2.2305E-03,1.7374E-03,
     &1.2245E-03,6.7631E-04,3.7016E-05,5.6556E-03,5.0622E-03,4.4391E-03,
     &3.7915E-03,3.1262E-03,2.4381E-03,1.7215E-03,9.5894E-04,4.8862E-05,
     &7.5823E-03,6.7945E-03,5.9706E-03,5.1108E-03,4.2263E-03,3.3055E-03,
     &2.3437E-03,1.3169E-03,6.1466E-05,9.8701E-03,8.8589E-03,7.8113E-03,
     &6.7131E-03,5.5681E-03,4.3736E-03,3.1150E-03,1.7640E-03,7.9784E-05,
     &1.2627E-02,1.1349E-02,1.0044E-02,8.6633E-03,7.2033E-03,5.6735E-03,
     &4.0519E-03,2.3093E-03,9.9338E-05/
      DATA ((KA(JS,JT, 8, 5),JS=1,9),JT=1,5) /
     &6.5162E-03,5.7610E-03,5.0100E-03,4.2382E-03,3.4497E-03,2.6520E-03,
     &1.8357E-03,9.8841E-04,5.0893E-05,9.3894E-03,8.3047E-03,7.2233E-03,
     &6.1097E-03,4.9767E-03,3.8267E-03,2.6500E-03,1.4278E-03,6.6360E-05,
     &1.2886E-02,1.1402E-02,9.9227E-03,8.3986E-03,6.8476E-03,5.2715E-03,
     &3.6563E-03,1.9797E-03,8.1964E-05,1.7029E-02,1.5075E-02,1.3132E-02,
     &1.1136E-02,9.1030E-03,7.0269E-03,4.8948E-03,2.6694E-03,1.0083E-04,
     &2.2131E-02,1.9595E-02,1.7101E-02,1.4537E-02,1.1918E-02,9.2249E-03,
     &6.4389E-03,3.5237E-03,1.2644E-04/
      DATA ((KA(JS,JT, 9, 5),JS=1,9),JT=1,5) /
     &1.9574E-02,1.7171E-02,1.4767E-02,1.2373E-02,9.9784E-03,7.5698E-03,
     &5.1323E-03,2.6624E-03,7.9787E-05,2.9063E-02,2.5494E-02,2.1931E-02,
     &1.8384E-02,1.4827E-02,1.1241E-02,7.6171E-03,3.9520E-03,1.0489E-04,
     &4.0973E-02,3.5943E-02,3.0923E-02,2.5930E-02,2.0911E-02,1.5846E-02,
     &1.0739E-02,5.5789E-03,1.2330E-04,5.5333E-02,4.8546E-02,4.1776E-02,
     &3.5034E-02,2.8259E-02,2.1435E-02,1.4550E-02,7.5751E-03,1.5097E-04,
     &7.2795E-02,6.3880E-02,5.4976E-02,4.6114E-02,3.7235E-02,2.8276E-02,
     &1.9247E-02,1.0060E-02,1.9444E-04/
      DATA ((KA(JS,JT,10, 5),JS=1,9),JT=1,5) /
     &6.7876E-02,5.9426E-02,5.0975E-02,4.2524E-02,3.4085E-02,2.5643E-02,
     &1.7219E-02,8.7441E-03,2.1379E-04,1.0363E-01,9.0726E-02,7.7824E-02,
     &6.4925E-02,5.2032E-02,3.9153E-02,2.6288E-02,1.3336E-02,2.7530E-04,
     &1.4868E-01,1.3017E-01,1.1167E-01,9.3161E-02,7.4667E-02,5.6180E-02,
     &3.7706E-02,1.9125E-02,3.1198E-04,2.0441E-01,1.7897E-01,1.5353E-01,
     &1.2809E-01,1.0267E-01,7.7285E-02,5.1877E-02,2.6327E-02,3.7361E-04,
     &2.7248E-01,2.3857E-01,2.0467E-01,1.7078E-01,1.3689E-01,1.0307E-01,
     &6.9236E-02,3.5215E-02,4.4890E-04/
      DATA ((KA(JS,JT,11, 5),JS=1,9),JT=1,5) /
     &1.0259E-01,8.9796E-02,7.7004E-02,6.4217E-02,5.1425E-02,3.8649E-02,
     &2.5882E-02,1.3106E-02,2.9325E-04,1.5400E-01,1.3480E-01,1.1559E-01,
     &9.6403E-02,7.7200E-02,5.8036E-02,3.8878E-02,1.9667E-02,3.5327E-04,
     &2.2118E-01,1.9361E-01,1.6603E-01,1.3846E-01,1.1090E-01,8.3368E-02,
     &5.5861E-02,2.8242E-02,4.6202E-04,3.0353E-01,2.6571E-01,2.2790E-01,
     &1.9008E-01,1.5227E-01,1.1447E-01,7.6708E-02,3.8764E-02,5.6335E-04,
     &4.0552E-01,3.5495E-01,3.0446E-01,2.5391E-01,2.0338E-01,1.5287E-01,
     &1.0246E-01,5.1876E-02,6.9233E-04/
      DATA ((KA(JS,JT,12, 5),JS=1,9),JT=1,5) /
     &1.1805E-01,1.0334E-01,8.8617E-02,7.3889E-02,5.9170E-02,4.4431E-02,
     &2.9722E-02,1.5007E-02,3.3712E-04,1.7261E-01,1.5108E-01,1.2954E-01,
     &1.0804E-01,8.6508E-02,6.5013E-02,4.3529E-02,2.1984E-02,3.8771E-04,
     &2.4519E-01,2.1462E-01,1.8406E-01,1.5350E-01,1.2297E-01,9.2422E-02,
     &6.1905E-02,3.1241E-02,5.1427E-04,3.3550E-01,2.9369E-01,2.5183E-01,
     &2.1003E-01,1.6821E-01,1.2645E-01,8.4714E-02,4.2803E-02,6.2818E-04,
     &4.4900E-01,3.9309E-01,3.3714E-01,2.8120E-01,2.2522E-01,1.6927E-01,
     &1.1341E-01,5.7326E-02,7.6692E-04/
      DATA ((KA(JS,JT,13, 5),JS=1,9),JT=1,5) /
     &1.0921E-01,9.5613E-02,8.2016E-02,6.8423E-02,5.4814E-02,4.1207E-02,
     &2.7589E-02,1.3915E-02,3.0996E-04,1.5908E-01,1.3927E-01,1.1945E-01,
     &9.9633E-02,7.9786E-02,5.9973E-02,4.0176E-02,2.0276E-02,3.7414E-04,
     &2.2086E-01,1.9339E-01,1.6582E-01,1.3829E-01,1.1077E-01,8.3306E-02,
     &5.5823E-02,2.8176E-02,4.9992E-04,3.0195E-01,2.6439E-01,2.2676E-01,
     &1.8917E-01,1.5156E-01,1.1401E-01,7.6395E-02,3.8587E-02,6.2293E-04,
     &4.0305E-01,3.5276E-01,3.0259E-01,2.5241E-01,2.0221E-01,1.5209E-01,
     &1.0190E-01,5.1477E-02,7.6835E-04/
      DATA ((KA(JS,JT, 1, 6),JS=1,9),JT=1,5) /
     &1.3028E-03,1.4792E-03,1.5640E-03,1.5783E-03,1.5338E-03,1.4263E-03,
     &1.2426E-03,1.0270E-03,3.8769E-04,1.5941E-03,1.8539E-03,1.9924E-03,
     &2.0205E-03,1.9782E-03,1.8703E-03,1.6672E-03,1.3063E-03,5.8906E-04,
     &1.9170E-03,2.2892E-03,2.4874E-03,2.5352E-03,2.4910E-03,2.3785E-03,
     &2.1678E-03,1.7982E-03,8.4228E-04,2.2745E-03,2.7857E-03,3.0496E-03,
     &3.1195E-03,3.0784E-03,2.9487E-03,2.7123E-03,2.3729E-03,1.1599E-03,
     &2.6664E-03,3.3396E-03,3.6796E-03,3.7742E-03,3.7339E-03,3.5735E-03,
     &3.3124E-03,2.9540E-03,1.5049E-03/
      DATA ((KA(JS,JT, 2, 6),JS=1,9),JT=1,5) /
     &1.6105E-03,1.7112E-03,1.7440E-03,1.7104E-03,1.6159E-03,1.4650E-03,
     &1.2347E-03,8.8371E-04,2.8335E-04,1.9953E-03,2.1575E-03,2.2293E-03,
     &2.1981E-03,2.0893E-03,1.9131E-03,1.6649E-03,1.2817E-03,4.3740E-04,
     &2.4284E-03,2.6728E-03,2.7960E-03,2.7642E-03,2.6394E-03,2.4361E-03,
     &2.1522E-03,1.6930E-03,6.3499E-04,2.9107E-03,3.2657E-03,3.4379E-03,
     &3.4084E-03,3.2638E-03,3.0336E-03,2.6919E-03,2.1920E-03,8.6677E-04,
     &3.4457E-03,3.9315E-03,4.1602E-03,4.1311E-03,3.9674E-03,3.6982E-03,
     &3.2905E-03,2.7416E-03,1.1277E-03/
      DATA ((KA(JS,JT, 3, 6),JS=1,9),JT=1,5) /
     &2.5362E-03,2.4734E-03,2.3740E-03,2.2299E-03,2.0298E-03,1.7661E-03,
     &1.4316E-03,9.7765E-04,1.9718E-04,3.1979E-03,3.1448E-03,3.0502E-03,
     &2.8893E-03,2.6412E-03,2.3120E-03,1.8934E-03,1.3566E-03,3.0943E-04,
     &3.9564E-03,3.9245E-03,3.8464E-03,3.6625E-03,3.3542E-03,2.9452E-03,
     &2.4362E-03,1.8025E-03,4.5105E-04,4.8099E-03,4.8142E-03,4.7669E-03,
     &4.5499E-03,4.1705E-03,3.6723E-03,3.0586E-03,2.2944E-03,6.1219E-04,
     &5.7692E-03,5.8286E-03,5.8075E-03,5.5468E-03,5.0930E-03,4.4966E-03,
     &3.7644E-03,2.8408E-03,8.0331E-04/
      DATA ((KA(JS,JT, 4, 6),JS=1,9),JT=1,5) /
     &3.9832E-03,3.6741E-03,3.3865E-03,3.0403E-03,2.6684E-03,2.2429E-03,
     &1.7419E-03,1.1291E-03,1.3015E-04,5.1171E-03,4.7408E-03,4.3919E-03,
     &3.9718E-03,3.5069E-03,2.9654E-03,2.3168E-03,1.5306E-03,2.0974E-04,
     &6.4449E-03,5.9980E-03,5.5858E-03,5.0842E-03,4.5074E-03,3.8196E-03,
     &2.9911E-03,2.0056E-03,3.1006E-04,7.9648E-03,7.4434E-03,6.9731E-03,
     &6.3878E-03,5.6676E-03,4.8062E-03,3.7737E-03,2.5549E-03,4.2568E-04,
     &9.7092E-03,9.1026E-03,8.5703E-03,7.8734E-03,6.9867E-03,5.9261E-03,
     &4.6651E-03,3.1844E-03,5.6406E-04/
      DATA ((KA(JS,JT, 5, 6),JS=1,9),JT=1,5) /
     &5.7027E-03,5.1210E-03,4.6077E-03,4.0275E-03,3.4179E-03,2.7812E-03,
     &2.0863E-03,1.2862E-03,7.8383E-05,7.4791E-03,6.7335E-03,6.0729E-03,
     &5.3256E-03,4.5457E-03,3.7228E-03,2.8115E-03,1.7506E-03,1.3561E-04,
     &9.5940E-03,8.6573E-03,7.8294E-03,6.8962E-03,5.9152E-03,4.8604E-03,
     &3.6801E-03,2.2991E-03,2.0565E-04,1.2079E-02,1.0922E-02,9.8984E-03,
     &8.7543E-03,7.5389E-03,6.1967E-03,4.6995E-03,2.9469E-03,2.9267E-04,
     &1.4994E-02,1.3590E-02,1.2330E-02,1.0933E-02,9.4206E-03,7.7402E-03,
     &5.8678E-03,3.6936E-03,3.9433E-04/
      DATA ((KA(JS,JT, 6, 6),JS=1,9),JT=1,5) /
     &7.5110E-03,6.6602E-03,5.8889E-03,5.0761E-03,4.2229E-03,3.3438E-03,
     &2.4265E-03,1.4290E-03,6.0800E-05,1.0081E-02,8.9573E-03,7.9340E-03,
     &6.8466E-03,5.7108E-03,4.5453E-03,3.3197E-03,1.9723E-03,8.3721E-05,
     &1.3198E-02,1.1747E-02,1.0417E-02,9.0067E-03,7.5375E-03,6.0255E-03,
     &4.4194E-03,2.6335E-03,1.2422E-04,1.6984E-02,1.5135E-02,1.3426E-02,
     &1.1628E-02,9.7560E-03,7.8119E-03,5.7333E-03,3.4188E-03,1.8443E-04,
     &2.1488E-02,1.9171E-02,1.7013E-02,1.4755E-02,1.2406E-02,9.9290E-03,
     &7.2811E-03,4.3367E-03,2.5906E-04/
      DATA ((KA(JS,JT, 7, 6),JS=1,9),JT=1,5) /
     &1.0317E-02,9.0822E-03,7.9160E-03,6.7515E-03,5.5440E-03,4.3074E-03,
     &3.0340E-03,1.7035E-03,6.0426E-05,1.4191E-02,1.2505E-02,1.0919E-02,
     &9.3201E-03,7.6597E-03,5.9649E-03,4.2263E-03,2.3919E-03,8.0608E-05,
     &1.9028E-02,1.6789E-02,1.4664E-02,1.2525E-02,1.0306E-02,8.0458E-03,
     &5.7261E-03,3.2535E-03,1.0671E-04,2.5018E-02,2.2107E-02,1.9309E-02,
     &1.6498E-02,1.3592E-02,1.0633E-02,7.5736E-03,4.3041E-03,1.3667E-04,
     &3.2278E-02,2.8550E-02,2.4932E-02,2.1309E-02,1.7576E-02,1.3764E-02,
     &9.7979E-03,5.5674E-03,1.7569E-04/
      DATA ((KA(JS,JT, 8, 6),JS=1,9),JT=1,5) /
     &1.6908E-02,1.4827E-02,1.2781E-02,1.0775E-02,8.7653E-03,6.7156E-03,
     &4.6263E-03,2.4796E-03,7.2095E-05,2.3895E-02,2.0964E-02,1.8085E-02,
     &1.5267E-02,1.2424E-02,9.5170E-03,6.5710E-03,3.5441E-03,9.6806E-05,
     &3.2855E-02,2.8841E-02,2.4900E-02,2.1032E-02,1.7114E-02,1.3120E-02,
     &9.0780E-03,4.9231E-03,1.2768E-04,4.4127E-02,3.8763E-02,3.3492E-02,
     &2.8282E-02,2.3023E-02,1.7668E-02,1.2245E-02,6.6502E-03,1.6091E-04,
     &5.7992E-02,5.0977E-02,4.4047E-02,3.7189E-02,3.0275E-02,2.3248E-02,
     &1.6136E-02,8.7683E-03,1.9428E-04/
      DATA ((KA(JS,JT, 9, 6),JS=1,9),JT=1,5) /
     &5.1709E-02,4.5263E-02,3.8825E-02,3.2404E-02,2.6001E-02,1.9630E-02,
     &1.3270E-02,6.8433E-03,1.6819E-04,7.5377E-02,6.5994E-02,5.6614E-02,
     &4.7250E-02,3.7927E-02,2.8667E-02,1.9405E-02,1.0007E-02,2.0150E-04,
     &1.0637E-01,9.3142E-02,7.9913E-02,6.6713E-02,5.3579E-02,4.0525E-02,
     &2.7438E-02,1.4159E-02,2.5395E-04,1.4601E-01,1.2787E-01,1.0973E-01,
     &9.1640E-02,7.3643E-02,5.5707E-02,3.7721E-02,1.9493E-02,2.9114E-04,
     &1.9540E-01,1.7114E-01,1.4689E-01,1.2270E-01,9.8611E-02,7.4576E-02,
     &5.0506E-02,2.6131E-02,3.2502E-04/
      DATA ((KA(JS,JT,10, 6),JS=1,9),JT=1,5) /
     &1.7908E-01,1.5672E-01,1.3434E-01,1.1197E-01,8.9592E-02,6.7243E-02,
     &4.4903E-02,2.2650E-02,3.5407E-04,2.6809E-01,2.3461E-01,2.0111E-01,
     &1.6763E-01,1.3416E-01,1.0070E-01,6.7289E-02,3.4001E-02,4.2267E-04,
     &3.8962E-01,3.4094E-01,2.9228E-01,2.4365E-01,1.9501E-01,1.4639E-01,
     &9.7852E-02,4.9496E-02,5.5217E-04,5.4709E-01,4.7880E-01,4.1047E-01,
     &3.4221E-01,2.7390E-01,2.0562E-01,1.3748E-01,6.9566E-02,6.7800E-04,
     &7.4383E-01,6.5097E-01,5.5813E-01,4.6528E-01,3.7246E-01,2.7966E-01,
     &1.8702E-01,9.4633E-02,7.9930E-04/
      DATA ((KA(JS,JT,11, 6),JS=1,9),JT=1,5) /
     &2.6405E-01,2.3107E-01,1.9807E-01,1.6508E-01,1.3209E-01,9.9087E-02,
     &6.6140E-02,3.3239E-02,4.6661E-04,3.9885E-01,3.4898E-01,2.9917E-01,
     &2.4935E-01,1.9952E-01,1.4970E-01,9.9938E-02,5.0287E-02,6.6831E-04,
     &5.8178E-01,5.0910E-01,4.3644E-01,3.6379E-01,2.9110E-01,2.1843E-01,
     &1.4582E-01,7.3440E-02,7.3058E-04,8.2081E-01,7.1832E-01,6.1577E-01,
     &5.1330E-01,4.1077E-01,3.0826E-01,2.0583E-01,1.0374E-01,9.0801E-04,
     &1.1196E+00,9.7976E-01,8.3991E-01,7.0013E-01,5.6034E-01,4.2058E-01,
     &2.8087E-01,1.4156E-01,1.1083E-03/
      DATA ((KA(JS,JT,12, 6),JS=1,9),JT=1,5) /
     &2.9667E-01,2.5960E-01,2.2251E-01,1.8545E-01,1.4837E-01,1.1135E-01,
     &7.4300E-02,3.7344E-02,4.3166E-04,4.4544E-01,3.8980E-01,3.3414E-01,
     &2.7849E-01,2.2283E-01,1.6719E-01,1.1158E-01,5.6122E-02,7.5682E-04,
     &6.4877E-01,5.6770E-01,4.8669E-01,4.0564E-01,3.2461E-01,2.4355E-01,
     &1.6257E-01,8.1850E-02,7.9167E-04,9.1198E-01,7.9809E-01,6.8416E-01,
     &5.7025E-01,4.5635E-01,3.4245E-01,2.2863E-01,1.1515E-01,9.9906E-04,
     &1.2467E+00,1.0910E+00,9.3529E-01,7.7959E-01,6.2391E-01,4.6827E-01,
     &3.1271E-01,1.5753E-01,1.2003E-03/
      DATA ((KA(JS,JT,13, 6),JS=1,9),JT=1,5) /
     &2.7690E-01,2.4228E-01,2.0769E-01,1.7308E-01,1.3848E-01,1.0389E-01,
     &6.9340E-02,3.4888E-02,4.3050E-04,4.0226E-01,3.5198E-01,3.0172E-01,
     &2.5145E-01,2.0123E-01,1.5101E-01,1.0081E-01,5.0783E-02,7.1649E-04,
     &5.7863E-01,5.0634E-01,4.3410E-01,3.6182E-01,2.8956E-01,2.1728E-01,
     &1.4512E-01,7.3148E-02,7.7482E-04,8.1324E-01,7.1165E-01,6.1013E-01,
     &5.0851E-01,4.0696E-01,3.0541E-01,2.0404E-01,1.0287E-01,9.9392E-04,
     &1.1104E+00,9.7179E-01,8.3315E-01,6.9450E-01,5.5586E-01,4.1728E-01,
     &2.7889E-01,1.4068E-01,1.1816E-03/
      DATA ((KA(JS,JT, 1, 7),JS=1,9),JT=1,5) /
     &3.5054E-03,3.5055E-03,3.5120E-03,3.3810E-03,3.1730E-03,2.8811E-03,
     &2.4850E-03,1.7479E-03,1.1652E-03,4.3050E-03,4.3583E-03,4.3910E-03,
     &4.2644E-03,4.0306E-03,3.6880E-03,3.2528E-03,2.5892E-03,1.6752E-03,
     &5.1735E-03,5.2976E-03,5.3803E-03,5.2761E-03,5.0137E-03,4.6183E-03,
     &4.1353E-03,3.5068E-03,2.2495E-03,6.1057E-03,6.3115E-03,6.4786E-03,
     &6.4038E-03,6.1210E-03,5.6909E-03,5.1278E-03,4.5615E-03,2.9063E-03,
     &7.0959E-03,7.4049E-03,7.6778E-03,7.6470E-03,7.3706E-03,6.8965E-03,
     &6.2418E-03,5.7511E-03,3.6720E-03/
      DATA ((KA(JS,JT, 2, 7),JS=1,9),JT=1,5) /
     &4.4522E-03,4.2827E-03,4.1712E-03,3.9058E-03,3.5730E-03,3.1581E-03,
     &2.6434E-03,1.9182E-03,8.6485E-04,5.5183E-03,5.3551E-03,5.2393E-03,
     &4.9436E-03,4.5529E-03,4.0469E-03,3.4309E-03,2.6479E-03,1.2370E-03,
     &6.6858E-03,6.5555E-03,6.4351E-03,6.1353E-03,5.6849E-03,5.0737E-03,
     &4.3365E-03,3.4457E-03,1.6663E-03,7.9566E-03,7.8606E-03,7.7697E-03,
     &7.4702E-03,6.9634E-03,6.2571E-03,5.3849E-03,4.3375E-03,2.1739E-03,
     &9.3107E-03,9.2749E-03,9.2506E-03,8.9459E-03,8.3896E-03,7.5840E-03,
     &6.5605E-03,5.3408E-03,2.7747E-03/
      DATA ((KA(JS,JT, 3, 7),JS=1,9),JT=1,5) /
     &7.1663E-03,6.5385E-03,6.0832E-03,5.5176E-03,4.8422E-03,4.1012E-03,
     &3.2557E-03,2.2244E-03,5.9815E-04,9.0118E-03,8.2694E-03,7.7301E-03,
     &7.0328E-03,6.2053E-03,5.2869E-03,4.2235E-03,2.9652E-03,8.5322E-04,
     &1.1073E-02,1.0215E-02,9.5832E-03,8.7498E-03,7.7844E-03,6.6733E-03,
     &5.3588E-03,3.8104E-03,1.1597E-03,1.3336E-02,1.2373E-02,1.1642E-02,
     &1.0696E-02,9.5807E-03,8.2482E-03,6.6726E-03,4.7891E-03,1.5317E-03,
     &1.5766E-02,1.4727E-02,1.3917E-02,1.2876E-02,1.1585E-02,1.0016E-02,
     &8.1535E-03,5.8982E-03,1.9785E-03/
      DATA ((KA(JS,JT, 4, 7),JS=1,9),JT=1,5) /
     &1.1443E-02,1.0194E-02,9.0847E-03,8.0229E-03,6.8443E-03,5.5702E-03,
     &4.2183E-03,2.6813E-03,4.0030E-04,1.4659E-02,1.3095E-02,1.1714E-02,
     &1.0375E-02,8.8664E-03,7.2483E-03,5.5253E-03,3.5568E-03,5.7754E-04,
     &1.8306E-02,1.6401E-02,1.4719E-02,1.3058E-02,1.1190E-02,9.2063E-03,
     &7.0626E-03,4.5942E-03,7.9824E-04,2.2363E-02,2.0101E-02,1.8107E-02,
     &1.6087E-02,1.3850E-02,1.1470E-02,8.8334E-03,5.7997E-03,1.0688E-03,
     &2.6741E-02,2.4136E-02,2.1831E-02,1.9473E-02,1.6867E-02,1.4029E-02,
     &1.0846E-02,7.1614E-03,1.3988E-03/
      DATA ((KA(JS,JT, 5, 7),JS=1,9),JT=1,5) /
     &1.6600E-02,1.4668E-02,1.2778E-02,1.1029E-02,9.2361E-03,7.3333E-03,
     &5.3444E-03,3.2124E-03,2.6040E-04,2.1709E-02,1.9200E-02,1.6777E-02,
     &1.4511E-02,1.2172E-02,9.6744E-03,7.0766E-03,4.2987E-03,3.8620E-04,
     &2.7589E-02,2.4430E-02,2.1405E-02,1.8550E-02,1.5579E-02,1.2414E-02,
     &9.1361E-03,5.5941E-03,5.4726E-04,3.4183E-02,3.0324E-02,2.6641E-02,
     &2.3153E-02,1.9480E-02,1.5601E-02,1.1542E-02,7.1098E-03,7.4652E-04,
     &4.1421E-02,3.6823E-02,3.2447E-02,2.8275E-02,2.3873E-02,1.9232E-02,
     &1.4297E-02,8.8472E-03,9.9177E-04/
      DATA ((KA(JS,JT, 6, 7),JS=1,9),JT=1,5) /
     &2.2041E-02,1.9394E-02,1.6757E-02,1.4215E-02,1.1736E-02,9.1749E-03,
     &6.5141E-03,3.7310E-03,1.4404E-04,2.9498E-02,2.5961E-02,2.2459E-02,
     &1.9104E-02,1.5796E-02,1.2359E-02,8.7857E-03,5.0673E-03,2.3466E-04,
     &3.8260E-02,3.3683E-02,2.9196E-02,2.4887E-02,2.0608E-02,1.6142E-02,
     &1.1503E-02,6.6775E-03,3.4879E-04,4.8196E-02,4.2468E-02,3.6884E-02,
     &3.1502E-02,2.6137E-02,2.0520E-02,1.4704E-02,8.5847E-03,4.9990E-04,
     &5.9282E-02,5.2285E-02,4.5513E-02,3.8965E-02,3.2393E-02,2.5526E-02,
     &1.8401E-02,1.0794E-02,6.8674E-04/
      DATA ((KA(JS,JT, 7, 7),JS=1,9),JT=1,5) /
     &3.0340E-02,2.6632E-02,2.2911E-02,1.9238E-02,1.5651E-02,1.2078E-02,
     &8.4116E-03,4.6225E-03,1.1044E-04,4.1630E-02,3.6541E-02,3.1448E-02,
     &2.6441E-02,2.1565E-02,1.6662E-02,1.1608E-02,6.3979E-03,1.5103E-04,
     &5.5141E-02,4.8404E-02,4.1697E-02,3.5120E-02,2.8696E-02,2.2204E-02,
     &1.5482E-02,8.5690E-03,2.0480E-04,7.0797E-02,6.2144E-02,5.3596E-02,
     &4.5212E-02,3.6995E-02,2.8664E-02,2.0039E-02,1.1163E-02,2.9866E-04,
     &8.8459E-02,7.7674E-02,6.7088E-02,5.6677E-02,4.6470E-02,3.6087E-02,
     &2.5332E-02,1.4195E-02,4.2372E-04/
      DATA ((KA(JS,JT, 8, 7),JS=1,9),JT=1,5) /
     &4.9601E-02,4.3472E-02,3.7321E-02,3.1177E-02,2.5072E-02,1.9045E-02,
     &1.3035E-02,6.9120E-03,1.2554E-04,6.9873E-02,6.1229E-02,5.2577E-02,
     &4.3926E-02,3.5352E-02,2.6911E-02,1.8460E-02,9.7927E-03,1.5143E-04,
     &9.4645E-02,8.2931E-02,7.1217E-02,5.9530E-02,4.7979E-02,3.6597E-02,
     &2.5135E-02,1.3350E-02,1.8982E-04,1.2398E-01,1.0863E-01,9.3295E-02,
     &7.8049E-02,6.2983E-02,4.8099E-02,3.3072E-02,1.7624E-02,2.4338E-04,
     &1.5756E-01,1.3808E-01,1.1863E-01,9.9354E-02,8.0265E-02,6.1390E-02,
     &4.2297E-02,2.2655E-02,3.0934E-04/
      DATA ((KA(JS,JT, 9, 7),JS=1,9),JT=1,5) /
     &1.5112E-01,1.3227E-01,1.1344E-01,9.4596E-02,7.5748E-02,5.6892E-02,
     &3.8080E-02,1.9401E-02,2.5169E-04,2.1904E-01,1.9173E-01,1.6442E-01,
     &1.3710E-01,1.0978E-01,8.2457E-02,5.5213E-02,2.8220E-02,3.2207E-04,
     &3.0409E-01,2.6618E-01,2.2825E-01,1.9033E-01,1.5240E-01,1.1448E-01,
     &7.6724E-02,3.9326E-02,3.9043E-04,4.0691E-01,3.5618E-01,3.0544E-01,
     &2.5467E-01,2.0393E-01,1.5326E-01,1.0281E-01,5.2796E-02,4.7191E-04,
     &5.2694E-01,4.6123E-01,3.9556E-01,3.2985E-01,2.6417E-01,1.9865E-01,
     &1.3342E-01,6.8629E-02,5.3966E-04/
      DATA ((KA(JS,JT,10, 7),JS=1,9),JT=1,5) /
     &5.2400E-01,4.5853E-01,3.9306E-01,3.2760E-01,2.6216E-01,1.9669E-01,
     &1.3123E-01,6.5752E-02,5.0343E-04,7.8161E-01,6.8400E-01,5.8634E-01,
     &4.8867E-01,3.9103E-01,2.9337E-01,1.9570E-01,9.8059E-02,7.7212E-04,
     &1.1108E+00,9.7208E-01,8.3335E-01,6.9453E-01,5.5575E-01,4.1693E-01,
     &2.7814E-01,1.3935E-01,8.3303E-04,1.5159E+00,1.3265E+00,1.1372E+00,
     &9.4781E-01,7.5840E-01,5.6900E-01,3.7960E-01,1.9025E-01,1.0516E-03,
     &2.0008E+00,1.7509E+00,1.5009E+00,1.2510E+00,1.0010E+00,7.5106E-01,
     &5.0105E-01,2.5132E-01,1.2795E-03/
      DATA ((KA(JS,JT,11, 7),JS=1,9),JT=1,5) /
     &7.6934E-01,6.7322E-01,5.7711E-01,4.8095E-01,3.8483E-01,2.8868E-01,
     &1.9254E-01,9.6383E-02,4.1213E-04,1.1531E+00,1.0090E+00,8.6492E-01,
     &7.2086E-01,5.7680E-01,4.3268E-01,2.8857E-01,1.4445E-01,7.8643E-04,
     &1.6479E+00,1.4420E+00,1.2361E+00,1.0302E+00,8.2427E-01,6.1836E-01,
     &4.1243E-01,2.0646E-01,1.3424E-03,2.2624E+00,1.9796E+00,1.6970E+00,
     &1.4143E+00,1.1316E+00,8.4892E-01,5.6619E-01,2.8348E-01,1.4044E-03,
     &3.0074E+00,2.6315E+00,2.2558E+00,1.8800E+00,1.5042E+00,1.1285E+00,
     &7.5266E-01,3.7695E-01,1.6947E-03/
      DATA ((KA(JS,JT,12, 7),JS=1,9),JT=1,5) /
     &8.4478E-01,7.3926E-01,6.3371E-01,5.2813E-01,4.2255E-01,3.1696E-01,
     &2.1141E-01,1.0578E-01,4.0897E-04,1.2687E+00,1.1101E+00,9.5161E-01,
     &7.9307E-01,6.3449E-01,4.7596E-01,3.1742E-01,1.5884E-01,7.3572E-04,
     &1.8247E+00,1.5966E+00,1.3686E+00,1.1406E+00,9.1261E-01,6.8459E-01,
     &4.5656E-01,2.2852E-01,1.3876E-03,2.5294E+00,2.2134E+00,1.8973E+00,
     &1.5812E+00,1.2652E+00,9.4906E-01,6.3294E-01,3.1685E-01,1.6774E-03,
     &3.3840E+00,2.9611E+00,2.5383E+00,2.1154E+00,1.6926E+00,1.2697E+00,
     &8.4679E-01,4.2403E-01,1.9227E-03/
      DATA ((KA(JS,JT,13, 7),JS=1,9),JT=1,5) /
     &7.4992E-01,6.5626E-01,5.6252E-01,4.6882E-01,3.7512E-01,2.8140E-01,
     &1.8768E-01,9.3938E-02,4.2556E-04,1.1304E+00,9.8913E-01,8.4793E-01,
     &7.0671E-01,5.6541E-01,4.2417E-01,2.8288E-01,1.4159E-01,7.8986E-04,
     &1.6343E+00,1.4300E+00,1.2259E+00,1.0217E+00,8.1745E-01,6.1321E-01,
     &4.0897E-01,2.0475E-01,1.4019E-03,2.2667E+00,1.9834E+00,1.7002E+00,
     &1.4170E+00,1.1337E+00,8.5047E-01,5.6722E-01,2.8408E-01,1.6857E-03,
     &3.0450E+00,2.6646E+00,2.2841E+00,1.9036E+00,1.5231E+00,1.1426E+00,
     &7.6204E-01,3.8179E-01,1.9578E-03/
      DATA ((KA(JS,JT, 1, 8),JS=1,9),JT=1,5) /
     &7.5530E-03,7.1946E-03,6.9309E-03,6.6476E-03,6.1286E-03,5.5188E-03,
     &4.8784E-03,4.0369E-03,3.2329E-03,9.1868E-03,8.8285E-03,8.6011E-03,
     &8.3060E-03,7.7227E-03,7.0815E-03,6.4738E-03,5.8694E-03,4.4599E-03,
     &1.0993E-02,1.0661E-02,1.0487E-02,1.0178E-02,9.5750E-03,8.9143E-03,
     &8.3359E-03,7.9019E-03,5.9682E-03,1.2929E-02,1.2692E-02,1.2580E-02,
     &1.2285E-02,1.1693E-02,1.1035E-02,1.0548E-02,1.0225E-02,7.8210E-03,
     &1.4992E-02,1.4924E-02,1.4888E-02,1.4659E-02,1.4068E-02,1.3474E-02,
     &1.3107E-02,1.2867E-02,1.0020E-02/
      DATA ((KA(JS,JT, 2, 8),JS=1,9),JT=1,5) /
     &1.0207E-02,9.4797E-03,8.8085E-03,8.2309E-03,7.4348E-03,6.4679E-03,
     &5.3282E-03,4.0056E-03,2.5229E-03,1.2558E-02,1.1748E-02,1.1002E-02,
     &1.0338E-02,9.3997E-03,8.2648E-03,6.9317E-03,5.5570E-03,3.5029E-03,
     &1.5167E-02,1.4277E-02,1.3509E-02,1.2727E-02,1.1653E-02,1.0352E-02,
     &8.8205E-03,7.4037E-03,4.7140E-03,1.7986E-02,1.7073E-02,1.6287E-02,
     &1.5417E-02,1.4234E-02,1.2722E-02,1.1029E-02,9.5450E-03,6.1941E-03,
     &2.1016E-02,2.0104E-02,1.9317E-02,1.8415E-02,1.7125E-02,1.5397E-02,
     &1.3573E-02,1.2029E-02,7.9674E-03/
      DATA ((KA(JS,JT, 3, 8),JS=1,9),JT=1,5) /
     &1.7495E-02,1.5793E-02,1.4039E-02,1.2465E-02,1.0907E-02,9.1072E-03,
     &7.1058E-03,4.8343E-03,1.7832E-03,2.1893E-02,1.9841E-02,1.7709E-02,
     &1.5801E-02,1.3894E-02,1.1662E-02,9.2038E-03,6.3817E-03,2.5128E-03,
     &2.6790E-02,2.4372E-02,2.1871E-02,1.9635E-02,1.7311E-02,1.4624E-02,
     &1.1658E-02,8.2109E-03,3.4348E-03,3.2142E-02,2.9358E-02,2.6490E-02,
     &2.3921E-02,2.1182E-02,1.8026E-02,1.4487E-02,1.0373E-02,4.5646E-03,
     &3.7933E-02,3.4749E-02,3.1541E-02,2.8628E-02,2.5501E-02,2.1864E-02,
     &1.7709E-02,1.2883E-02,5.9131E-03/
      DATA ((KA(JS,JT, 4, 8),JS=1,9),JT=1,5) /
     &2.9550E-02,2.6227E-02,2.2910E-02,1.9604E-02,1.6469E-02,1.3339E-02,
     &9.9415E-03,6.2262E-03,1.2135E-03,3.7687E-02,3.3528E-02,2.9343E-02,
     &2.5186E-02,2.1249E-02,1.7292E-02,1.2959E-02,8.2307E-03,1.7374E-03,
     &4.6817E-02,4.1770E-02,3.6634E-02,3.1558E-02,2.6759E-02,2.1861E-02,
     &1.6492E-02,1.0607E-02,2.4118E-03,5.6963E-02,5.0934E-02,4.4739E-02,
     &3.8692E-02,3.2979E-02,2.7058E-02,2.0566E-02,1.3387E-02,3.2525E-03,
     &6.8137E-02,6.0987E-02,5.3660E-02,4.6589E-02,3.9864E-02,3.2872E-02,
     &2.5218E-02,1.6596E-02,4.2777E-03/
      DATA ((KA(JS,JT, 5, 8),JS=1,9),JT=1,5) /
     &4.4958E-02,3.9602E-02,3.4298E-02,2.8957E-02,2.3691E-02,1.8601E-02,
     &1.3441E-02,7.9068E-03,8.1517E-04,5.8476E-02,5.1578E-02,4.4743E-02,
     &3.7815E-02,3.1045E-02,2.4482E-02,1.7770E-02,1.0541E-02,1.1885E-03,
     &7.3906E-02,6.5268E-02,5.6679E-02,4.8013E-02,3.9537E-02,3.1318E-02,
     &2.2852E-02,1.3697E-02,1.6746E-03,9.1296E-02,8.0739E-02,7.0175E-02,
     &5.9533E-02,4.9168E-02,3.9100E-02,2.8676E-02,1.7397E-02,2.2909E-03,
     &1.1069E-01,9.7986E-02,8.5202E-02,7.2388E-02,5.9975E-02,4.7864E-02,
     &3.5291E-02,2.1668E-02,3.0530E-03/
      DATA ((KA(JS,JT, 6, 8),JS=1,9),JT=1,5) /
     &6.2124E-02,5.4544E-02,4.6999E-02,3.9470E-02,3.1923E-02,2.4497E-02,
     &1.7234E-02,9.7062E-03,5.1266E-04,8.2639E-02,7.2604E-02,6.2611E-02,
     &5.2626E-02,4.2613E-02,3.2833E-02,2.3213E-02,1.3144E-02,7.8429E-04,
     &1.0657E-01,9.3700E-02,8.0879E-02,6.8013E-02,5.5195E-02,4.2665E-02,
     &3.0306E-02,1.7290E-02,1.1388E-03,1.3398E-01,1.1789E-01,1.0183E-01,
     &8.5694E-02,6.9665E-02,5.3995E-02,3.8486E-02,2.2145E-02,1.5829E-03,
     &1.6490E-01,1.4520E-01,1.2544E-01,1.0568E-01,8.6025E-02,6.6861E-02,
     &4.7818E-02,2.7758E-02,2.1408E-03/
      DATA ((KA(JS,JT, 7, 8),JS=1,9),JT=1,5) /
     &8.8474E-02,7.7539E-02,6.6627E-02,5.5731E-02,4.4842E-02,3.3990E-02,
     &2.3276E-02,1.2620E-02,2.5937E-04,1.2057E-01,1.0571E-01,9.0876E-02,
     &7.6061E-02,6.1253E-02,4.6466E-02,3.1963E-02,1.7441E-02,4.2731E-04,
     &1.5880E-01,1.3927E-01,1.1980E-01,1.0034E-01,8.0808E-02,6.1423E-02,
     &4.2427E-02,2.3279E-02,6.8413E-04,2.0345E-01,1.7853E-01,1.5363E-01,
     &1.2871E-01,1.0372E-01,7.9011E-02,5.4743E-02,3.0170E-02,1.0214E-03,
     &2.5461E-01,2.2346E-01,1.9234E-01,1.6117E-01,1.3002E-01,9.9184E-02,
     &6.8901E-02,3.8181E-02,1.4552E-03/
      DATA ((KA(JS,JT, 8, 8),JS=1,9),JT=1,5) /
     &1.4868E-01,1.3017E-01,1.1167E-01,9.3201E-02,7.4739E-02,5.6278E-02,
     &3.7905E-02,1.9693E-02,2.2804E-04,2.0798E-01,1.8213E-01,1.5630E-01,
     &1.3048E-01,1.0468E-01,7.8891E-02,5.3152E-02,2.7778E-02,2.9739E-04,
     &2.8017E-01,2.4539E-01,2.1065E-01,1.7590E-01,1.4119E-01,1.0644E-01,
     &7.1779E-02,3.7725E-02,3.8946E-04,3.6604E-01,3.2068E-01,2.7532E-01,
     &2.2999E-01,1.8464E-01,1.3919E-01,9.4095E-02,4.9659E-02,5.6194E-04,
     &4.6634E-01,4.0858E-01,3.5083E-01,2.9310E-01,2.3536E-01,1.7756E-01,
     &1.2024E-01,6.3667E-02,8.0698E-04/
      DATA ((KA(JS,JT, 9, 8),JS=1,9),JT=1,5) /
     &4.6269E-01,4.0493E-01,3.4715E-01,2.8935E-01,2.3157E-01,1.7382E-01,
     &1.1609E-01,5.8382E-02,3.9623E-04,6.6628E-01,5.8309E-01,4.9991E-01,
     &4.1673E-01,3.3358E-01,2.5043E-01,1.6730E-01,8.4243E-02,5.2033E-04,
     &9.1981E-01,8.0501E-01,6.9024E-01,5.7543E-01,4.6067E-01,3.4594E-01,
     &2.3120E-01,1.1646E-01,6.1848E-04,1.2275E+00,1.0743E+00,9.2117E-01,
     &7.6798E-01,6.1489E-01,4.6180E-01,3.0869E-01,1.5554E-01,7.6432E-04,
     &1.5931E+00,1.3944E+00,1.1956E+00,9.9699E-01,7.9825E-01,5.9958E-01,
     &4.0095E-01,2.0227E-01,9.3678E-04/
      DATA ((KA(JS,JT,10, 8),JS=1,9),JT=1,5) /
     &1.6306E+00,1.4267E+00,1.2230E+00,1.0192E+00,8.1547E-01,6.1164E-01,
     &4.0787E-01,2.0413E-01,4.5853E-04,2.4126E+00,2.1111E+00,1.8096E+00,
     &1.5081E+00,1.2066E+00,9.0513E-01,6.0364E-01,3.0217E-01,8.3201E-04,
     &3.4093E+00,2.9833E+00,2.5573E+00,2.1313E+00,1.7053E+00,1.2792E+00,
     &8.5320E-01,4.2724E-01,1.5974E-03,4.6433E+00,4.0630E+00,3.4826E+00,
     &2.9025E+00,2.3226E+00,1.7423E+00,1.1621E+00,5.8201E-01,1.5962E-03,
     &6.1277E+00,5.3619E+00,4.5964E+00,3.8308E+00,3.0651E+00,2.2994E+00,
     &1.5338E+00,7.6843E-01,2.0260E-03/
      DATA ((KA(JS,JT,11, 8),JS=1,9),JT=1,5) /
     &2.4162E+00,2.1143E+00,1.8124E+00,1.5103E+00,1.2083E+00,9.0631E-01,
     &6.0429E-01,3.0233E-01,6.1607E-04,3.5951E+00,3.1458E+00,2.6963E+00,
     &2.2470E+00,1.7978E+00,1.3484E+00,8.9917E-01,4.4993E-01,6.5176E-04,
     &5.1060E+00,4.4678E+00,3.8297E+00,3.1915E+00,2.5535E+00,1.9153E+00,
     &1.2772E+00,6.3920E-01,1.2930E-03,6.9828E+00,6.1098E+00,5.2373E+00,
     &4.3645E+00,3.4923E+00,2.6195E+00,1.7469E+00,8.7439E-01,2.6451E-03,
     &9.2372E+00,8.0825E+00,6.9284E+00,5.7745E+00,4.6202E+00,3.4655E+00,
     &2.3113E+00,1.1571E+00,3.2091E-03/
      DATA ((KA(JS,JT,12, 8),JS=1,9),JT=1,5) /
     &2.6551E+00,2.3231E+00,1.9913E+00,1.6595E+00,1.3276E+00,9.9570E-01,
     &6.6396E-01,3.3215E-01,5.7595E-04,3.9875E+00,3.4892E+00,2.9906E+00,
     &2.4922E+00,1.9940E+00,1.4956E+00,9.9727E-01,4.9897E-01,7.2773E-04,
     &5.6951E+00,4.9832E+00,4.2714E+00,3.5598E+00,2.8480E+00,2.1362E+00,
     &1.4245E+00,7.1282E-01,1.1732E-03,7.8078E+00,6.8322E+00,5.8562E+00,
     &4.8804E+00,3.9048E+00,2.9289E+00,1.9532E+00,9.7758E-01,2.5629E-03,
     &1.0362E+01,9.0671E+00,7.7724E+00,6.4775E+00,5.1823E+00,3.8873E+00,
     &2.5926E+00,1.2977E+00,3.8105E-03/
      DATA ((KA(JS,JT,13, 8),JS=1,9),JT=1,5) /
     &2.3258E+00,2.0350E+00,1.7444E+00,1.4537E+00,1.1630E+00,8.7226E-01,
     &5.8161E-01,2.9098E-01,5.9908E-04,3.5360E+00,3.0938E+00,2.6520E+00,
     &2.2101E+00,1.7681E+00,1.3262E+00,8.8435E-01,4.4250E-01,8.1555E-04,
     &5.0896E+00,4.4536E+00,3.8175E+00,3.1814E+00,2.5452E+00,1.9091E+00,
     &1.2732E+00,6.3712E-01,1.2640E-03,7.0210E+00,6.1435E+00,5.2660E+00,
     &4.3886E+00,3.5112E+00,2.6338E+00,1.7565E+00,8.7919E-01,2.6701E-03,
     &9.3671E+00,8.1963E+00,7.0260E+00,5.8554E+00,4.6849E+00,3.5142E+00,
     &2.3437E+00,1.1734E+00,3.9606E-03/
      DATA ((KA(JS,JT, 1, 9),JS=1,9),JT=1,5) /
     &1.7557E-02,1.6098E-02,1.5252E-02,1.4591E-02,1.4194E-02,1.3841E-02,
     &1.3213E-02,1.1760E-02,1.0941E-02,2.1322E-02,1.9727E-02,1.8932E-02,
     &1.8315E-02,1.8048E-02,1.7757E-02,1.7105E-02,1.5377E-02,1.4897E-02,
     &2.5364E-02,2.3730E-02,2.3058E-02,2.2569E-02,2.2483E-02,2.2337E-02,
     &2.1647E-02,1.9659E-02,1.9740E-02,2.9651E-02,2.8091E-02,2.7567E-02,
     &2.7373E-02,2.7544E-02,2.7572E-02,2.6885E-02,2.4698E-02,2.5506E-02,
     &3.4147E-02,3.2801E-02,3.2509E-02,3.2696E-02,3.3242E-02,3.3466E-02,
     &3.2763E-02,3.0530E-02,3.2414E-02/
      DATA ((KA(JS,JT, 2, 9),JS=1,9),JT=1,5) /
     &2.4912E-02,2.2331E-02,2.0288E-02,1.8446E-02,1.6840E-02,1.5437E-02,
     &1.4050E-02,1.2105E-02,9.2979E-03,3.0564E-02,2.7515E-02,2.5261E-02,
     &2.3219E-02,2.1400E-02,1.9828E-02,1.8282E-02,1.5938E-02,1.2847E-02,
     &3.6716E-02,3.3250E-02,3.0813E-02,2.8576E-02,2.6652E-02,2.4969E-02,
     &2.3242E-02,2.0434E-02,1.7255E-02,4.3274E-02,3.9470E-02,3.6945E-02,
     &3.4546E-02,3.2567E-02,3.0902E-02,2.8990E-02,2.5608E-02,2.2622E-02,
     &5.0151E-02,4.6154E-02,4.3548E-02,4.1147E-02,3.9208E-02,3.7617E-02,
     &3.5476E-02,3.1506E-02,2.9070E-02/
      DATA ((KA(JS,JT, 3, 9),JS=1,9),JT=1,5) /
     &4.5824E-02,4.0428E-02,3.5360E-02,3.0531E-02,2.5873E-02,2.1515E-02,
     &1.7437E-02,1.3182E-02,7.2135E-03,5.7122E-02,5.0441E-02,4.4296E-02,
     &3.8535E-02,3.2887E-02,2.7626E-02,2.2637E-02,1.7470E-02,1.0156E-02,
     &6.9514E-02,6.1484E-02,5.4267E-02,4.7520E-02,4.0893E-02,3.4647E-02,
     &2.8731E-02,2.2576E-02,1.3878E-02,8.2919E-02,7.3512E-02,6.5273E-02,
     &5.7524E-02,4.9783E-02,4.2603E-02,3.5784E-02,2.8563E-02,1.8502E-02,
     &9.7170E-02,8.6431E-02,7.7261E-02,6.8346E-02,5.9584E-02,5.1514E-02,
     &4.3768E-02,3.5379E-02,2.4141E-02/
      DATA ((KA(JS,JT, 4, 9),JS=1,9),JT=1,5) /
     &8.5028E-02,7.4675E-02,6.4408E-02,5.4349E-02,4.4385E-02,3.4667E-02,
     &2.5298E-02,1.6347E-02,5.3723E-03,1.0799E-01,9.4832E-02,8.1887E-02,
     &6.9265E-02,5.6849E-02,4.4649E-02,3.2963E-02,2.1613E-02,7.7235E-03,
     &1.3350E-01,1.1723E-01,1.0141E-01,8.6053E-02,7.1006E-02,5.6113E-02,
     &4.1792E-02,2.7868E-02,1.0747E-02,1.6142E-01,1.4180E-01,1.2297E-01,
     &1.0476E-01,8.6810E-02,6.8956E-02,5.1841E-02,3.5143E-02,1.4564E-02,
     &1.9126E-01,1.6822E-01,1.4629E-01,1.2515E-01,1.0422E-01,8.3176E-02,
     &6.3089E-02,4.3500E-02,1.9267E-02/
      DATA ((KA(JS,JT, 5, 9),JS=1,9),JT=1,5) /
     &1.4488E-01,1.2702E-01,1.0917E-01,9.1352E-02,7.3672E-02,5.6082E-02,
     &3.8867E-02,2.2212E-02,3.9357E-03,1.8767E-01,1.6453E-01,1.4140E-01,
     &1.1846E-01,9.5672E-02,7.3107E-02,5.0961E-02,2.9559E-02,5.7686E-03,
     &2.3604E-01,2.0693E-01,1.7791E-01,1.4922E-01,1.2079E-01,9.2713E-02,
     &6.4987E-02,3.8154E-02,8.1725E-03,2.8921E-01,2.5355E-01,2.1818E-01,
     &1.8330E-01,1.4882E-01,1.1469E-01,8.0893E-02,4.8061E-02,1.1257E-02,
     &3.4679E-01,3.0409E-01,2.6204E-01,2.2057E-01,1.7963E-01,1.3899E-01,
     &9.8558E-02,5.9364E-02,1.5113E-02/
      DATA ((KA(JS,JT, 6, 9),JS=1,9),JT=1,5) /
     &2.2687E-01,1.9870E-01,1.7053E-01,1.4235E-01,1.1424E-01,8.6261E-02,
     &5.8407E-02,3.1198E-02,2.7719E-03,3.0049E-01,2.6318E-01,2.2586E-01,
     &1.8856E-01,1.5147E-01,1.1450E-01,7.7818E-02,4.1952E-02,4.1659E-03,
     &3.8494E-01,3.3714E-01,2.8934E-01,2.4170E-01,1.9431E-01,1.4714E-01,
     &1.0048E-01,5.4667E-02,6.0249E-03,4.7888E-01,4.1941E-01,3.6000E-01,
     &3.0097E-01,2.4222E-01,1.8390E-01,1.2612E-01,6.9245E-02,8.4412E-03,
     &5.8181E-01,5.0960E-01,4.3765E-01,3.6614E-01,2.9513E-01,2.2467E-01,
     &1.5478E-01,8.5677E-02,1.1500E-02/
      DATA ((KA(JS,JT, 7, 9),JS=1,9),JT=1,5) /
     &3.6399E-01,3.1864E-01,2.7330E-01,2.2796E-01,1.8261E-01,1.3731E-01,
     &9.2161E-02,4.7386E-02,1.8335E-03,4.9404E-01,4.3249E-01,3.7094E-01,
     &3.0937E-01,2.4784E-01,1.8651E-01,1.2531E-01,6.4814E-02,2.9040E-03,
     &6.4560E-01,5.6518E-01,4.8472E-01,4.0430E-01,3.2403E-01,2.4402E-01,
     &1.6421E-01,8.5452E-02,4.3365E-03,8.1690E-01,7.1513E-01,6.1336E-01,
     &5.1171E-01,4.1038E-01,3.0928E-01,2.0863E-01,1.0932E-01,6.1934E-03,
     &1.0068E+00,8.8147E-01,7.5616E-01,6.3106E-01,5.0635E-01,3.8205E-01,
     &2.5843E-01,1.3634E-01,8.5588E-03/
      DATA ((KA(JS,JT, 8, 9),JS=1,9),JT=1,5) /
     &6.8384E-01,5.9848E-01,5.1310E-01,4.2775E-01,3.4242E-01,2.5705E-01,
     &1.7171E-01,8.6607E-02,8.9761E-04,9.5272E-01,8.3382E-01,7.1490E-01,
     &5.9597E-01,4.7702E-01,3.5811E-01,2.3935E-01,1.2088E-01,1.5768E-03,
     &1.2716E+00,1.1128E+00,9.5409E-01,7.9538E-01,6.3666E-01,4.7804E-01,
     &3.1975E-01,1.6179E-01,2.6889E-03,1.6381E+00,1.4337E+00,1.2291E+00,
     &1.0247E+00,8.2031E-01,6.1622E-01,4.1239E-01,2.0929E-01,4.1353E-03,
     &2.0497E+00,1.7940E+00,1.5381E+00,1.2824E+00,1.0268E+00,7.7156E-01,
     &5.1676E-01,2.6319E-01,6.0327E-03/
      DATA ((KA(JS,JT, 9, 9),JS=1,9),JT=1,5) /
     &2.3562E+00,2.0618E+00,1.7675E+00,1.4730E+00,1.1786E+00,8.8409E-01,
     &5.8968E-01,2.9523E-01,7.8820E-04,3.3780E+00,2.9558E+00,2.5337E+00,
     &2.1117E+00,1.6896E+00,1.2675E+00,8.4537E-01,4.2322E-01,1.1025E-03,
     &4.6138E+00,4.0373E+00,3.4607E+00,2.8840E+00,2.3076E+00,1.7311E+00,
     &1.1546E+00,5.7817E-01,1.6643E-03,6.0608E+00,5.3032E+00,4.5462E+00,
     &3.7886E+00,3.0313E+00,2.2740E+00,1.5168E+00,7.6000E-01,2.3974E-03,
     &7.7085E+00,6.7454E+00,5.7823E+00,4.8189E+00,3.8558E+00,2.8925E+00,
     &1.9295E+00,9.6718E-01,3.2535E-03/
      DATA ((KA(JS,JT,10, 9),JS=1,9),JT=1,5) /
     &9.1055E+00,7.9675E+00,6.8292E+00,5.6913E+00,4.5531E+00,3.4149E+00,
     &2.2769E+00,1.1388E+00,5.8809E-04,1.3404E+01,1.1729E+01,1.0053E+01,
     &8.3780E+00,6.7024E+00,5.0271E+00,3.3517E+00,1.6763E+00,9.0563E-04,
     &1.8696E+01,1.6359E+01,1.4022E+01,1.1685E+01,9.3484E+00,7.0117E+00,
     &4.6747E+00,2.3381E+00,1.7881E-03,2.4995E+01,2.1869E+01,1.8747E+01,
     &1.5622E+01,1.2498E+01,9.3741E+00,6.2500E+00,3.1259E+00,3.1813E-03,
     &3.2273E+01,2.8239E+01,2.4206E+01,2.0172E+01,1.6138E+01,1.2104E+01,
     &8.0701E+00,4.0364E+00,3.7345E-03/
      DATA ((KA(JS,JT,11, 9),JS=1,9),JT=1,5) /
     &1.4610E+01,1.2784E+01,1.0958E+01,9.1318E+00,7.3053E+00,5.4792E+00,
     &3.6529E+00,1.8269E+00,9.3673E-05,2.1482E+01,1.8797E+01,1.6112E+01,
     &1.3427E+01,1.0742E+01,8.0564E+00,5.3711E+00,2.6860E+00,1.0848E-03,
     &2.9982E+01,2.6234E+01,2.2487E+01,1.8739E+01,1.4992E+01,1.1244E+01,
     &7.4965E+00,3.7489E+00,1.4593E-03,4.0102E+01,3.5090E+01,3.0079E+01,
     &2.5065E+01,2.0053E+01,1.5039E+01,1.0027E+01,5.0144E+00,2.0582E-03,
     &5.1873E+01,4.5387E+01,3.8905E+01,3.2421E+01,2.5937E+01,1.9453E+01,
     &1.2970E+01,6.4862E+00,4.4703E-03/
      DATA ((KA(JS,JT,12, 9),JS=1,9),JT=1,5) /
     &1.7189E+01,1.5041E+01,1.2892E+01,1.0744E+01,8.5949E+00,6.4462E+00,
     &4.2976E+00,2.1491E+00,3.9266E-05,2.5282E+01,2.2121E+01,1.8962E+01,
     &1.5801E+01,1.2641E+01,9.4811E+00,6.3210E+00,3.1609E+00,6.4444E-04,
     &3.5289E+01,3.0879E+01,2.6468E+01,2.2056E+01,1.7646E+01,1.3235E+01,
     &8.8231E+00,4.4124E+00,1.8228E-03,4.7291E+01,4.1381E+01,3.5468E+01,
     &2.9558E+01,2.3647E+01,1.7735E+01,1.1825E+01,5.9130E+00,2.3757E-03,
     &6.1297E+01,5.3636E+01,4.5972E+01,3.8311E+01,3.0649E+01,2.2988E+01,
     &1.5326E+01,7.6642E+00,3.9341E-03/
      DATA ((KA(JS,JT,13, 9),JS=1,9),JT=1,5) /
     &1.6000E+01,1.4000E+01,1.2000E+01,9.9998E+00,8.0002E+00,6.0002E+00,
     &4.0003E+00,2.0005E+00,3.8486E-05,2.3551E+01,2.0607E+01,1.7663E+01,
     &1.4719E+01,1.1776E+01,8.8325E+00,5.8883E+00,2.9447E+00,5.3945E-04,
     &3.2950E+01,2.8830E+01,2.4711E+01,2.0594E+01,1.6475E+01,1.2356E+01,
     &8.2382E+00,4.1197E+00,1.7722E-03,4.4263E+01,3.8730E+01,3.3198E+01,
     &2.7666E+01,2.2132E+01,1.6600E+01,1.1067E+01,5.5345E+00,2.5081E-03,
     &5.7461E+01,5.0277E+01,4.3096E+01,3.5913E+01,2.8731E+01,2.1549E+01,
     &1.4366E+01,7.1843E+00,4.3602E-03/
      DATA ((KA(JS,JT, 1,10),JS=1,9),JT=1,5) /
     &4.8312E-02,4.2395E-02,3.7029E-02,3.4268E-02,3.1631E-02,2.8012E-02,
     &2.4227E-02,1.9340E-02,2.3819E-02,5.7978E-02,5.0880E-02,4.5259E-02,
     &4.2684E-02,3.9233E-02,3.5182E-02,3.0643E-02,2.5810E-02,3.1295E-02,
     &6.8091E-02,5.9773E-02,5.4735E-02,5.1517E-02,4.7810E-02,4.2960E-02,
     &3.8310E-02,3.3678E-02,4.0832E-02,7.8444E-02,6.8870E-02,6.5474E-02,
     &6.0764E-02,5.6861E-02,5.2020E-02,4.6525E-02,4.3019E-02,5.3025E-02,
     &8.8955E-02,7.8190E-02,7.6227E-02,7.0877E-02,6.6771E-02,6.2214E-02,
     &5.5680E-02,5.4857E-02,6.6965E-02/
      DATA ((KA(JS,JT, 2,10),JS=1,9),JT=1,5) /
     &6.8494E-02,6.0019E-02,5.1535E-02,4.5753E-02,4.0717E-02,3.4636E-02,
     &2.8735E-02,2.2359E-02,2.2396E-02,8.3057E-02,7.2786E-02,6.2703E-02,
     &5.6353E-02,5.0990E-02,4.3733E-02,3.6309E-02,2.8660E-02,2.9863E-02,
     &9.8445E-02,8.6268E-02,7.5172E-02,6.9101E-02,6.1861E-02,5.3608E-02,
     &4.5462E-02,3.5628E-02,3.9584E-02,1.1465E-01,1.0047E-01,8.9322E-02,
     &8.2399E-02,7.3847E-02,6.4459E-02,5.5729E-02,4.5259E-02,5.1011E-02,
     &1.3121E-01,1.1499E-01,1.0547E-01,9.5942E-02,8.6700E-02,7.6912E-02,
     &6.7683E-02,5.7087E-02,6.4331E-02/
      DATA ((KA(JS,JT, 3,10),JS=1,9),JT=1,5) /
     &1.2396E-01,1.0851E-01,9.3078E-02,7.7936E-02,6.5430E-02,5.3555E-02,
     &4.0149E-02,2.8165E-02,1.9103E-02,1.5308E-01,1.3401E-01,1.1495E-01,
     &9.6317E-02,8.2061E-02,6.7720E-02,5.1563E-02,3.6346E-02,2.6147E-02,
     &1.8438E-01,1.6143E-01,1.3846E-01,1.1685E-01,1.0065E-01,8.3573E-02,
     &6.4169E-02,4.6273E-02,3.5249E-02,2.1730E-01,1.9024E-01,1.6317E-01,
     &1.3937E-01,1.2182E-01,1.0076E-01,7.7802E-02,5.7458E-02,4.6106E-02,
     &2.5114E-01,2.1989E-01,1.8862E-01,1.6558E-01,1.4330E-01,1.1936E-01,
     &9.3594E-02,7.0438E-02,5.9048E-02/
      DATA ((KA(JS,JT, 4,10),JS=1,9),JT=1,5) /
     &2.2307E-01,1.9520E-01,1.6737E-01,1.3960E-01,1.1281E-01,8.7662E-02,
     &6.3355E-02,3.7440E-02,1.5143E-02,2.8121E-01,2.4610E-01,2.1101E-01,
     &1.7601E-01,1.4219E-01,1.1180E-01,8.0961E-02,4.9348E-02,2.1248E-02,
     &3.4426E-01,3.0128E-01,2.5831E-01,2.1545E-01,1.7407E-01,1.3850E-01,
     &1.0170E-01,6.2450E-02,2.9486E-02,4.1162E-01,3.6021E-01,3.0885E-01,
     &2.5755E-01,2.0938E-01,1.6873E-01,1.2428E-01,7.7637E-02,3.9623E-02,
     &4.8400E-01,4.2357E-01,3.6318E-01,3.0275E-01,2.4837E-01,2.0175E-01,
     &1.4904E-01,9.5123E-02,5.2032E-02/
      DATA ((KA(JS,JT, 5,10),JS=1,9),JT=1,5) /
     &3.6240E-01,3.1713E-01,2.7189E-01,2.2715E-01,1.8287E-01,1.3915E-01,
     &9.6038E-02,5.3151E-02,1.1469E-02,4.6684E-01,4.0853E-01,3.5029E-01,
     &2.9260E-01,2.3543E-01,1.7892E-01,1.2501E-01,6.9710E-02,1.6590E-02,
     &5.8305E-01,5.1017E-01,4.3746E-01,3.6540E-01,2.9385E-01,2.2314E-01,
     &1.5770E-01,8.9552E-02,2.3682E-02,7.1039E-01,6.2164E-01,5.3285E-01,
     &4.4486E-01,3.5759E-01,2.7242E-01,1.9452E-01,1.1176E-01,3.2616E-02,
     &8.4585E-01,7.4016E-01,6.3454E-01,5.2965E-01,4.2558E-01,3.2651E-01,
     &2.3601E-01,1.3577E-01,4.3721E-02/
      DATA ((KA(JS,JT, 6,10),JS=1,9),JT=1,5) /
     &5.4565E-01,4.7774E-01,4.0998E-01,3.4242E-01,2.7503E-01,2.0802E-01,
     &1.4092E-01,7.4294E-02,8.5994E-03,7.2281E-01,6.3285E-01,5.4312E-01,
     &4.5353E-01,3.6423E-01,2.7526E-01,1.8607E-01,9.8990E-02,1.2620E-02,
     &9.2293E-01,8.0812E-01,6.9347E-01,5.7897E-01,4.6479E-01,3.5103E-01,
     &2.3728E-01,1.2747E-01,1.8407E-02,1.1448E+00,1.0023E+00,8.6003E-01,
     &7.1795E-01,5.7619E-01,4.3493E-01,2.9519E-01,1.6083E-01,2.5918E-02,
     &1.3870E+00,1.2144E+00,1.0419E+00,8.6977E-01,6.9789E-01,5.2651E-01,
     &3.5987E-01,1.9795E-01,3.5516E-02/
      DATA ((KA(JS,JT, 7,10),JS=1,9),JT=1,5) /
     &9.0563E-01,7.9294E-01,6.8033E-01,5.6775E-01,4.5526E-01,3.4288E-01,
     &2.2993E-01,1.1636E-01,6.3281E-03,1.2304E+00,1.0774E+00,9.2435E-01,
     &7.7129E-01,6.1846E-01,4.6574E-01,3.1230E-01,1.5802E-01,9.6345E-03,
     &1.6067E+00,1.4068E+00,1.2068E+00,1.0069E+00,8.0717E-01,6.0759E-01,
     &4.0707E-01,2.0698E-01,1.4230E-02,2.0379E+00,1.7842E+00,1.5305E+00,
     &1.2770E+00,1.0235E+00,7.6992E-01,5.1539E-01,2.6359E-01,2.0362E-02,
     &2.5042E+00,2.1925E+00,1.8806E+00,1.5690E+00,1.2574E+00,9.4558E-01,
     &6.3281E-01,3.2569E-01,2.8537E-02/
      DATA ((KA(JS,JT, 8,10),JS=1,9),JT=1,5) /
     &1.8551E+00,1.6239E+00,1.3926E+00,1.1613E+00,9.2995E-01,6.9848E-01,
     &4.6667E-01,2.3461E-01,3.7282E-03,2.5887E+00,2.2659E+00,1.9430E+00,
     &1.6201E+00,1.2969E+00,9.7383E-01,6.5051E-01,3.2684E-01,7.1685E-03,
     &3.4601E+00,3.0282E+00,2.5964E+00,2.1645E+00,1.7327E+00,1.3007E+00,
     &8.6869E-01,4.3618E-01,1.0869E-02,4.4635E+00,3.9062E+00,3.3492E+00,
     &2.7923E+00,2.2350E+00,1.6778E+00,1.1202E+00,5.6241E-01,1.5855E-02,
     &5.5614E+00,4.8670E+00,4.1730E+00,3.4788E+00,2.7845E+00,2.0899E+00,
     &1.3954E+00,7.0042E-01,2.2369E-02/
      DATA ((KA(JS,JT, 9,10),JS=1,9),JT=1,5) /
     &7.0057E+00,6.1306E+00,5.2555E+00,4.3802E+00,3.5047E+00,2.6291E+00,
     &1.7537E+00,8.7821E-01,2.6651E-03,1.0071E+01,8.8120E+00,7.5539E+00,
     &6.2955E+00,5.0368E+00,3.7786E+00,2.5204E+00,1.2618E+00,3.6187E-03,
     &1.3793E+01,1.2069E+01,1.0345E+01,8.6215E+00,6.8979E+00,5.1747E+00,
     &3.4512E+00,1.7274E+00,5.0886E-03,1.8095E+01,1.5834E+01,1.3574E+01,
     &1.1311E+01,9.0505E+00,6.7893E+00,4.5277E+00,2.2659E+00,6.6445E-03,
     &2.2909E+01,2.0046E+01,1.7183E+01,1.4320E+01,1.1458E+01,8.5941E+00,
     &5.7315E+00,2.8684E+00,1.0715E-02/
      DATA ((KA(JS,JT,10,10),JS=1,9),JT=1,5) /
     &2.9637E+01,2.5932E+01,2.2227E+01,1.8524E+01,1.4818E+01,1.1115E+01,
     &7.4105E+00,3.7062E+00,1.7663E-03,4.3734E+01,3.8266E+01,3.2801E+01,
     &2.7334E+01,2.1867E+01,1.6402E+01,1.0936E+01,5.4691E+00,2.0817E-03,
     &6.1232E+01,5.3576E+01,4.5921E+01,3.8272E+01,3.0616E+01,2.2963E+01,
     &1.5310E+01,7.6576E+00,1.7504E-03,8.1674E+01,7.1459E+01,6.1256E+01,
     &5.1048E+01,4.0839E+01,3.0631E+01,2.0421E+01,1.0211E+01,7.5551E-03,
     &1.0484E+02,9.1726E+01,7.8618E+01,6.5522E+01,5.2414E+01,3.9315E+01,
     &2.6210E+01,1.3108E+01,1.2092E-02/
      DATA ((KA(JS,JT,11,10),JS=1,9),JT=1,5) /
     &5.2035E+01,4.5533E+01,3.9026E+01,3.2522E+01,2.6019E+01,1.9514E+01,
     &1.3010E+01,6.5060E+00,2.3377E-05,7.6878E+01,6.7270E+01,5.7660E+01,
     &4.8051E+01,3.8444E+01,2.8832E+01,1.9221E+01,9.6129E+00,3.4131E-05,
     &1.0695E+02,9.3584E+01,8.0221E+01,6.6851E+01,5.3480E+01,4.0109E+01,
     &2.6742E+01,1.3372E+01,6.5532E-03,1.4204E+02,1.2428E+02,1.0653E+02,
     &8.8779E+01,7.1025E+01,5.3267E+01,3.5513E+01,1.7760E+01,3.6230E-03,
     &1.8146E+02,1.5877E+02,1.3608E+02,1.1341E+02,9.0723E+01,6.8041E+01,
     &4.5364E+01,2.2685E+01,5.3060E-03/
      DATA ((KA(JS,JT,12,10),JS=1,9),JT=1,5) /
     &6.6709E+01,5.8372E+01,5.0033E+01,4.1695E+01,3.3357E+01,2.5018E+01,
     &1.6679E+01,8.3409E+00,1.6896E-05,9.8021E+01,8.5767E+01,7.3510E+01,
     &6.1263E+01,4.9006E+01,3.6758E+01,2.4506E+01,1.2254E+01,2.4443E-05,
     &1.3575E+02,1.1880E+02,1.0183E+02,8.4855E+01,6.7883E+01,5.0907E+01,
     &3.3942E+01,1.6972E+01,3.9041E-05,1.7930E+02,1.5689E+02,1.3447E+02,
     &1.1206E+02,8.9651E+01,6.7236E+01,4.4831E+01,2.2414E+01,2.5406E-03,
     &2.2752E+02,1.9909E+02,1.7067E+02,1.4220E+02,1.1376E+02,8.5325E+01,
     &5.6889E+01,2.8448E+01,5.4913E-03/
      DATA ((KA(JS,JT,13,10),JS=1,9),JT=1,5) /
     &6.7103E+01,5.8720E+01,5.0329E+01,4.1943E+01,3.3555E+01,2.5165E+01,
     &1.6777E+01,8.3902E+00,1.5511E-05,9.7787E+01,8.5564E+01,7.3344E+01,
     &6.1125E+01,4.8896E+01,3.6672E+01,2.4451E+01,1.2226E+01,2.1977E-05,
     &1.3463E+02,1.1780E+02,1.0097E+02,8.4145E+01,6.7313E+01,5.0486E+01,
     &3.3658E+01,1.6832E+01,3.2342E-05,1.7688E+02,1.5477E+02,1.3267E+02,
     &1.1056E+02,8.8438E+01,6.6334E+01,4.4220E+01,2.2113E+01,5.6189E-03,
     &2.2476E+02,1.9667E+02,1.6857E+02,1.4047E+02,1.1238E+02,8.4289E+01,
     &5.6195E+01,2.8100E+01,6.0459E-03/
      DATA ((KA(JS,JT, 1,11),JS=1,9),JT=1,5) /
     &6.9001E-02,6.0529E-02,5.2064E-02,4.5590E-02,4.0628E-02,3.5945E-02,
     &2.9389E-02,2.3144E-02,2.9176E-02,8.2103E-02,7.2020E-02,6.1937E-02,
     &5.5694E-02,5.0508E-02,4.4515E-02,3.6553E-02,3.0757E-02,3.9695E-02,
     &9.5630E-02,8.3878E-02,7.2481E-02,6.7965E-02,6.0680E-02,5.4180E-02,
     &4.4143E-02,4.0422E-02,5.1968E-02,1.0928E-01,9.5880E-02,8.4382E-02,
     &8.0469E-02,7.1798E-02,6.4108E-02,5.3608E-02,5.2409E-02,6.6870E-02,
     &1.2299E-01,1.0790E-01,9.8888E-02,9.2808E-02,8.4009E-02,7.5069E-02,
     &6.6004E-02,6.6900E-02,8.4455E-02/
      DATA ((KA(JS,JT, 2,11),JS=1,9),JT=1,5) /
     &1.0031E-01,8.7857E-02,7.5407E-02,6.3060E-02,5.4499E-02,4.6504E-02,
     &3.6770E-02,2.6380E-02,2.8413E-02,1.2053E-01,1.0559E-01,9.0627E-02,
     &7.6829E-02,6.7033E-02,5.8104E-02,4.6509E-02,3.3638E-02,3.8310E-02,
     &1.4155E-01,1.2398E-01,1.0644E-01,9.2248E-02,8.1983E-02,7.0441E-02,
     &5.6590E-02,4.3821E-02,5.0130E-02,1.6305E-01,1.4282E-01,1.2262E-01,
     &1.1049E-01,9.7062E-02,8.3848E-02,6.7975E-02,5.5529E-02,6.5378E-02,
     &1.8507E-01,1.6212E-01,1.3962E-01,1.2935E-01,1.1281E-01,9.7726E-02,
     &8.0117E-02,6.9954E-02,8.3371E-02/
      DATA ((KA(JS,JT, 3,11),JS=1,9),JT=1,5) /
     &1.8667E-01,1.6338E-01,1.4010E-01,1.1682E-01,9.3557E-02,7.4325E-02,
     &5.5984E-02,3.5878E-02,2.5531E-02,2.2795E-01,1.9954E-01,1.7113E-01,
     &1.4270E-01,1.1480E-01,9.2509E-02,7.0623E-02,4.6178E-02,3.4917E-02,
     &2.7211E-01,2.3816E-01,2.0423E-01,1.7032E-01,1.3866E-01,1.1338E-01,
     &8.6877E-02,5.7191E-02,4.6054E-02,3.1770E-01,2.7809E-01,2.3849E-01,
     &1.9887E-01,1.6548E-01,1.3614E-01,1.0464E-01,7.0039E-02,6.0217E-02,
     &3.6403E-01,3.1863E-01,2.7328E-01,2.2795E-01,1.9641E-01,1.5908E-01,
     &1.2312E-01,8.3529E-02,7.7572E-02/
      DATA ((KA(JS,JT, 4,11),JS=1,9),JT=1,5) /
     &3.4588E-01,3.0268E-01,2.5948E-01,2.1629E-01,1.7307E-01,1.2990E-01,
     &9.1217E-02,5.3135E-02,2.1767E-02,4.3145E-01,3.7755E-01,3.2366E-01,
     &2.6977E-01,2.1589E-01,1.6201E-01,1.1572E-01,6.8208E-02,3.0409E-02,
     &5.2311E-01,4.5776E-01,3.9244E-01,3.2707E-01,2.6176E-01,1.9718E-01,
     &1.4225E-01,8.5649E-02,4.0906E-02,6.1949E-01,5.4214E-01,4.6476E-01,
     &3.8737E-01,3.1001E-01,2.3606E-01,1.7310E-01,1.0459E-01,5.4382E-02,
     &7.1941E-01,6.2950E-01,5.3975E-01,4.4985E-01,3.6002E-01,2.8013E-01,
     &2.0492E-01,1.2467E-01,7.0400E-02/
      DATA ((KA(JS,JT, 5,11),JS=1,9),JT=1,5) /
     &5.8048E-01,5.0796E-01,4.3542E-01,3.6286E-01,2.9032E-01,2.1780E-01,
     &1.4642E-01,8.0688E-02,1.7624E-02,7.4078E-01,6.4817E-01,5.5562E-01,
     &4.6305E-01,3.7047E-01,2.7793E-01,1.8667E-01,1.0393E-01,2.5321E-02,
     &9.1562E-01,8.0121E-01,6.8680E-01,5.7241E-01,4.5798E-01,3.4354E-01,
     &2.3145E-01,1.3051E-01,3.5008E-02,1.1041E+00,9.6607E-01,8.2810E-01,
     &6.9018E-01,5.5220E-01,4.1422E-01,2.8137E-01,1.6106E-01,4.7504E-02,
     &1.3000E+00,1.1374E+00,9.7498E-01,8.1255E-01,6.5013E-01,4.8767E-01,
     &3.3622E-01,1.9350E-01,6.2782E-02/
      DATA ((KA(JS,JT, 6,11),JS=1,9),JT=1,5) /
     &8.9158E-01,7.8014E-01,6.6870E-01,5.5724E-01,4.4582E-01,3.3441E-01,
     &2.2372E-01,1.1615E-01,1.3452E-02,1.1678E+00,1.0218E+00,8.7586E-01,
     &7.2991E-01,5.8393E-01,4.3799E-01,2.9305E-01,1.5296E-01,1.9872E-02,
     &1.4777E+00,1.2930E+00,1.1083E+00,9.2359E-01,7.3888E-01,5.5427E-01,
     &3.7059E-01,1.9566E-01,2.8227E-02,1.8119E+00,1.5855E+00,1.3592E+00,
     &1.1325E+00,9.0614E-01,6.7964E-01,4.5430E-01,2.4269E-01,3.9342E-02,
     &2.1657E+00,1.8951E+00,1.6242E+00,1.3536E+00,1.0830E+00,8.1233E-01,
     &5.4303E-01,2.9520E-01,5.3415E-02/
      DATA ((KA(JS,JT, 7,11),JS=1,9),JT=1,5) /
     &1.4142E+00,1.2374E+00,1.0606E+00,8.8396E-01,7.0710E-01,5.3041E-01,
     &3.5484E-01,1.8101E-01,1.0092E-02,1.9068E+00,1.6686E+00,1.4303E+00,
     &1.1919E+00,9.5353E-01,7.1519E-01,4.7813E-01,2.4337E-01,1.5041E-02,
     &2.4672E+00,2.1587E+00,1.8505E+00,1.5421E+00,1.2336E+00,9.2548E-01,
     &6.1872E-01,3.1448E-01,2.1900E-02,3.0809E+00,2.6959E+00,2.3109E+00,
     &1.9258E+00,1.5405E+00,1.1559E+00,7.7290E-01,3.9302E-01,3.1410E-02,
     &3.7474E+00,3.2787E+00,2.8103E+00,2.3419E+00,1.8737E+00,1.4060E+00,
     &9.3991E-01,4.7981E-01,4.3693E-02/
      DATA ((KA(JS,JT, 8,11),JS=1,9),JT=1,5) /
     &2.6683E+00,2.3349E+00,2.0012E+00,1.6677E+00,1.3344E+00,1.0014E+00,
     &6.6874E-01,3.3701E-01,7.4648E-03,3.7060E+00,3.2430E+00,2.7797E+00,
     &2.3168E+00,1.8539E+00,1.3914E+00,9.2912E-01,4.6800E-01,1.1435E-02,
     &4.9130E+00,4.2993E+00,3.6854E+00,3.0718E+00,2.4583E+00,1.8451E+00,
     &1.2322E+00,6.2028E-01,1.6885E-02,6.2797E+00,5.4950E+00,4.7108E+00,
     &3.9265E+00,3.1420E+00,2.3582E+00,1.5746E+00,7.9222E-01,2.4688E-02,
     &7.7638E+00,6.7943E+00,5.8243E+00,4.8546E+00,3.8850E+00,2.9154E+00,
     &1.9466E+00,9.7896E-01,3.5101E-02/
      DATA ((KA(JS,JT, 9,11),JS=1,9),JT=1,5) /
     &9.7135E+00,8.4998E+00,7.2860E+00,6.0723E+00,4.8583E+00,3.6448E+00,
     &2.4304E+00,1.2171E+00,3.5233E-03,1.3929E+01,1.2189E+01,1.0449E+01,
     &8.7078E+00,6.9673E+00,5.2263E+00,3.4856E+00,1.7453E+00,4.1308E-03,
     &1.8989E+01,1.6615E+01,1.4243E+01,1.1869E+01,9.4966E+00,7.1244E+00,
     &4.7516E+00,2.3792E+00,6.6319E-03,2.4785E+01,2.1688E+01,1.8591E+01,
     &1.5493E+01,1.2396E+01,9.2991E+00,6.2019E+00,3.1051E+00,1.1490E-02,
     &3.1283E+01,2.7373E+01,2.3465E+01,1.9556E+01,1.5646E+01,1.1737E+01,
     &7.8279E+00,3.9188E+00,2.1019E-02/
      DATA ((KA(JS,JT,10,11),JS=1,9),JT=1,5) /
     &4.1666E+01,3.6458E+01,3.1251E+01,2.6043E+01,2.0835E+01,1.5628E+01,
     &1.0419E+01,5.2119E+00,1.6494E-03,6.1694E+01,5.3987E+01,4.6271E+01,
     &3.8561E+01,3.0850E+01,2.3139E+01,1.5428E+01,7.7161E+00,4.8320E-03,
     &8.6109E+01,7.5347E+01,6.4581E+01,5.3821E+01,4.3056E+01,3.2294E+01,
     &2.1533E+01,1.0770E+01,3.2818E-03,1.1458E+02,1.0025E+02,8.5946E+01,
     &7.1620E+01,5.7298E+01,4.2975E+01,2.8651E+01,1.4330E+01,1.0923E-02,
     &1.4689E+02,1.2853E+02,1.1017E+02,9.1808E+01,7.3452E+01,5.5088E+01,
     &3.6731E+01,1.8371E+01,1.7421E-02/
      DATA ((KA(JS,JT,11,11),JS=1,9),JT=1,5) /
     &7.6402E+01,6.6855E+01,5.7300E+01,4.7753E+01,3.8204E+01,2.8655E+01,
     &1.9105E+01,9.5538E+00,4.1075E-05,1.1253E+02,9.8463E+01,8.4399E+01,
     &7.0331E+01,5.6269E+01,4.2202E+01,2.8136E+01,1.4070E+01,5.7635E-05,
     &1.5636E+02,1.3680E+02,1.1725E+02,9.7724E+01,7.8173E+01,5.8632E+01,
     &3.9090E+01,1.9548E+01,8.0706E-05,2.0774E+02,1.8177E+02,1.5580E+02,
     &1.2984E+02,1.0387E+02,7.7908E+01,5.1937E+01,2.5972E+01,1.1256E-02,
     &2.6504E+02,2.3192E+02,1.9880E+02,1.6566E+02,1.3254E+02,9.9402E+01,
     &6.6269E+01,3.3138E+01,8.3317E-03/
      DATA ((KA(JS,JT,12,11),JS=1,9),JT=1,5) /
     &1.0209E+02,8.9323E+01,7.6564E+01,6.3800E+01,5.1042E+01,3.8285E+01,
     &2.5522E+01,1.2763E+01,2.5628E-05,1.4952E+02,1.3083E+02,1.1214E+02,
     &9.3447E+01,7.4760E+01,5.6068E+01,3.7381E+01,1.8692E+01,3.7727E-05,
     &2.0709E+02,1.8121E+02,1.5533E+02,1.2944E+02,1.0355E+02,7.7656E+01,
     &5.1777E+01,2.5887E+01,4.7198E-05,2.7380E+02,2.3961E+02,2.0536E+02,
     &1.7114E+02,1.3691E+02,1.0268E+02,6.8461E+01,3.4230E+01,7.7074E-03,
     &3.4895E+02,3.0533E+02,2.6172E+02,2.1811E+02,1.7449E+02,1.3086E+02,
     &8.7241E+01,4.3626E+01,8.7565E-03/
      DATA ((KA(JS,JT,13,11),JS=1,9),JT=1,5) /
     &1.0675E+02,9.3411E+01,8.0067E+01,6.6725E+01,5.3379E+01,4.0032E+01,
     &2.6688E+01,1.3347E+01,1.6230E-05,1.5608E+02,1.3657E+02,1.1706E+02,
     &9.7552E+01,7.8046E+01,5.8531E+01,3.9024E+01,1.9513E+01,2.2466E-05,
     &2.1549E+02,1.8855E+02,1.6162E+02,1.3468E+02,1.0774E+02,8.0803E+01,
     &5.3874E+01,2.6939E+01,3.0542E-05,2.8371E+02,2.4826E+02,2.1280E+02,
     &1.7733E+02,1.4186E+02,1.0640E+02,7.0935E+01,3.5470E+01,1.3758E-03,
     &3.5962E+02,3.1467E+02,2.6973E+02,2.2478E+02,1.7981E+02,1.3487E+02,
     &8.9910E+01,4.4960E+01,3.9903E-03/
      DATA ((KA(JS,JT, 1,12),JS=1,9),JT=1,5) /
     &9.6318E-02,8.4306E-02,7.2320E-02,6.0347E-02,5.2079E-02,4.4235E-02,
     &3.5296E-02,3.0172E-02,3.8372E-02,1.1333E-01,9.9268E-02,8.5214E-02,
     &7.2014E-02,6.3588E-02,5.4323E-02,4.4306E-02,4.1727E-02,5.1292E-02,
     &1.3065E-01,1.1448E-01,9.8324E-02,8.5358E-02,7.7141E-02,6.4277E-02,
     &5.5750E-02,5.5415E-02,6.7933E-02,1.4795E-01,1.2969E-01,1.1146E-01,
     &1.0185E-01,9.0045E-02,7.5178E-02,6.8885E-02,7.0700E-02,8.8138E-02,
     &1.6491E-01,1.4461E-01,1.2472E-01,1.1761E-01,1.0268E-01,8.7802E-02,
     &8.5057E-02,9.0208E-02,1.1284E-01/
      DATA ((KA(JS,JT, 2,12),JS=1,9),JT=1,5) /
     &1.4316E-01,1.2534E-01,1.0752E-01,8.9701E-02,7.2577E-02,5.9608E-02,
     &4.6628E-02,3.2233E-02,3.6922E-02,1.7023E-01,1.4907E-01,1.2790E-01,
     &1.0674E-01,8.8738E-02,7.3250E-02,5.7353E-02,4.3254E-02,4.9659E-02,
     &1.9792E-01,1.7332E-01,1.4875E-01,1.2418E-01,1.0651E-01,8.8601E-02,
     &6.9038E-02,5.5574E-02,6.6062E-02,2.2567E-01,1.9768E-01,1.6971E-01,
     &1.4278E-01,1.2696E-01,1.0366E-01,8.1948E-02,7.1191E-02,8.6127E-02,
     &2.5314E-01,2.2175E-01,1.9032E-01,1.6565E-01,1.4606E-01,1.1970E-01,
     &9.8165E-02,9.0526E-02,1.1061E-01/
      DATA ((KA(JS,JT, 3,12),JS=1,9),JT=1,5) /
     &2.7385E-01,2.3971E-01,2.0552E-01,1.7136E-01,1.3716E-01,1.0300E-01,
     &7.5178E-02,4.5691E-02,3.3533E-02,3.3090E-01,2.8961E-01,2.4836E-01,
     &2.0707E-01,1.6581E-01,1.2597E-01,9.2542E-02,5.7168E-02,4.5647E-02,
     &3.8960E-01,3.4098E-01,2.9239E-01,2.4379E-01,1.9517E-01,1.5181E-01,
     &1.1308E-01,7.0212E-02,6.1610E-02,4.4888E-01,3.9285E-01,3.3686E-01,
     &2.8085E-01,2.2487E-01,1.8074E-01,1.3367E-01,8.4795E-02,8.0803E-02,
     &5.0777E-01,4.4444E-01,3.8104E-01,3.1773E-01,2.5631E-01,2.1146E-01,
     &1.5502E-01,1.0449E-01,1.0410E-01/
      DATA ((KA(JS,JT, 4,12),JS=1,9),JT=1,5) /
     &5.2233E-01,4.5708E-01,3.9182E-01,3.2654E-01,2.6131E-01,1.9604E-01,
     &1.3079E-01,7.4640E-02,2.9498E-02,6.4217E-01,5.6200E-01,4.8174E-01,
     &4.0151E-01,3.2131E-01,2.4104E-01,1.6124E-01,9.3279E-02,4.1076E-02,
     &7.6818E-01,6.7216E-01,5.7628E-01,4.8026E-01,3.8431E-01,2.8834E-01,
     &1.9584E-01,1.1499E-01,5.5764E-02,8.9714E-01,7.8510E-01,6.7304E-01,
     &5.6095E-01,4.4882E-01,3.3677E-01,2.3398E-01,1.3732E-01,7.3695E-02,
     &1.0267E+00,8.9838E-01,7.7018E-01,6.4193E-01,5.1368E-01,3.8545E-01,
     &2.7687E-01,1.6073E-01,9.6046E-02/
      DATA ((KA(JS,JT, 5,12),JS=1,9),JT=1,5) /
     &9.0551E-01,7.9235E-01,6.7918E-01,5.6601E-01,4.5286E-01,3.3967E-01,
     &2.2649E-01,1.1543E-01,2.5575E-02,1.1369E+00,9.9490E-01,8.5273E-01,
     &7.1065E-01,5.6855E-01,4.2647E-01,2.8441E-01,1.4706E-01,3.6472E-02,
     &1.3835E+00,1.2106E+00,1.0376E+00,8.6468E-01,6.9181E-01,5.1896E-01,
     &3.4607E-01,1.8250E-01,5.0201E-02,1.6400E+00,1.4350E+00,1.2302E+00,
     &1.0252E+00,8.2021E-01,6.1526E-01,4.1028E-01,2.2034E-01,6.6839E-02,
     &1.9010E+00,1.6635E+00,1.4259E+00,1.1884E+00,9.5076E-01,7.1323E-01,
     &4.7563E-01,2.6201E-01,8.7568E-02/
      DATA ((KA(JS,JT, 6,12),JS=1,9),JT=1,5) /
     &1.4399E+00,1.2599E+00,1.0800E+00,9.0001E-01,7.2000E-01,5.4003E-01,
     &3.6008E-01,1.8026E-01,2.1293E-02,1.8513E+00,1.6198E+00,1.3886E+00,
     &1.1570E+00,9.2575E-01,6.9429E-01,4.6294E-01,2.3182E-01,3.1128E-02,
     &2.3002E+00,2.0128E+00,1.7253E+00,1.4377E+00,1.1502E+00,8.6271E-01,
     &5.7522E-01,2.8786E-01,4.3673E-02,2.7724E+00,2.4259E+00,2.0792E+00,
     &1.7327E+00,1.3862E+00,1.0398E+00,6.9321E-01,3.4832E-01,5.9465E-02,
     &3.2575E+00,2.8504E+00,2.4432E+00,2.0359E+00,1.6288E+00,1.2216E+00,
     &8.1457E-01,4.1431E-01,7.8852E-02/
      DATA ((KA(JS,JT, 7,12),JS=1,9),JT=1,5) /
     &2.3706E+00,2.0741E+00,1.7778E+00,1.4816E+00,1.1852E+00,8.8892E-01,
     &5.9261E-01,2.9636E-01,1.6814E-02,3.1315E+00,2.7398E+00,2.3484E+00,
     &1.9572E+00,1.5657E+00,1.1742E+00,7.8297E-01,3.9150E-01,2.5425E-02,
     &3.9698E+00,3.4734E+00,2.9772E+00,2.4811E+00,1.9850E+00,1.4887E+00,
     &9.9245E-01,4.9628E-01,3.6698E-02,4.8729E+00,4.2639E+00,3.6548E+00,
     &3.0457E+00,2.4366E+00,1.8275E+00,1.2184E+00,6.0927E-01,5.1098E-02,
     &5.8302E+00,5.1015E+00,4.3726E+00,3.6438E+00,2.9154E+00,2.1865E+00,
     &1.4578E+00,7.2896E-01,6.9201E-02/
      DATA ((KA(JS,JT, 8,12),JS=1,9),JT=1,5) /
     &4.6083E+00,4.0328E+00,3.4566E+00,2.8804E+00,2.3046E+00,1.7283E+00,
     &1.1523E+00,5.7615E-01,1.2896E-02,6.2568E+00,5.4739E+00,4.6922E+00,
     &3.9099E+00,3.1281E+00,2.3461E+00,1.5641E+00,7.8209E-01,1.9880E-02,
     &8.1358E+00,7.1187E+00,6.1015E+00,5.0849E+00,4.0679E+00,3.0509E+00,
     &2.0338E+00,1.0170E+00,2.9497E-02,1.0204E+01,8.9284E+00,7.6531E+00,
     &6.3773E+00,5.1020E+00,3.8269E+00,2.5510E+00,1.2755E+00,4.2115E-02,
     &1.2434E+01,1.0880E+01,9.3260E+00,7.7708E+00,6.2169E+00,4.6632E+00,
     &3.1088E+00,1.5543E+00,5.8665E-02/
      DATA ((KA(JS,JT, 9,12),JS=1,9),JT=1,5) /
     &1.6573E+01,1.4502E+01,1.2430E+01,1.0358E+01,8.2865E+00,6.2149E+00,
     &4.1429E+00,2.0717E+00,3.2506E-03,2.3241E+01,2.0336E+01,1.7432E+01,
     &1.4525E+01,1.1622E+01,8.7162E+00,5.8106E+00,2.9051E+00,8.0054E-03,
     &3.1035E+01,2.7156E+01,2.3277E+01,1.9396E+01,1.5516E+01,1.1638E+01,
     &7.7589E+00,3.8795E+00,1.2478E-02,3.9794E+01,3.4820E+01,2.9846E+01,
     &2.4871E+01,1.9897E+01,1.4923E+01,9.9485E+00,4.9745E+00,2.7934E-02,
     &4.9259E+01,4.3099E+01,3.6943E+01,3.0785E+01,2.4628E+01,1.8472E+01,
     &1.2315E+01,6.1576E+00,4.7661E-02/
      DATA ((KA(JS,JT,10,12),JS=1,9),JT=1,5) /
     &6.7160E+01,5.8765E+01,5.0369E+01,4.1974E+01,3.3581E+01,2.5186E+01,
     &1.6790E+01,8.3953E+00,3.7061E-05,9.7116E+01,8.4979E+01,7.2826E+01,
     &6.0693E+01,4.8559E+01,3.6416E+01,2.4277E+01,1.2139E+01,5.3890E-03,
     &1.3274E+02,1.1614E+02,9.9552E+01,8.2959E+01,6.6370E+01,4.9775E+01,
     &3.3183E+01,1.6592E+01,5.5995E-03,1.7342E+02,1.5174E+02,1.3008E+02,
     &1.0839E+02,8.6716E+01,6.5036E+01,4.3354E+01,2.1678E+01,7.3568E-03,
     &2.1869E+02,1.9137E+02,1.6402E+02,1.3669E+02,1.0934E+02,8.2010E+01,
     &5.4674E+01,2.7339E+01,1.9171E-02/
      DATA ((KA(JS,JT,11,12),JS=1,9),JT=1,5) /
     &1.1512E+02,1.0073E+02,8.6335E+01,7.1940E+01,5.7559E+01,4.3164E+01,
     &2.8776E+01,1.4390E+01,3.3905E-05,1.6697E+02,1.4609E+02,1.2523E+02,
     &1.0436E+02,8.3482E+01,6.2612E+01,4.1744E+01,2.0873E+01,5.9590E-05,
     &2.2930E+02,2.0064E+02,1.7196E+02,1.4331E+02,1.1466E+02,8.5994E+01,
     &5.7327E+01,2.8668E+01,8.9833E-05,3.0132E+02,2.6364E+02,2.2598E+02,
     &1.8835E+02,1.5066E+02,1.1300E+02,7.5334E+01,3.7671E+01,8.4167E-03,
     &3.8162E+02,3.3392E+02,2.8622E+02,2.3853E+02,1.9083E+02,1.4312E+02,
     &9.5410E+01,4.7709E+01,1.8161E-02/
      DATA ((KA(JS,JT,12,12),JS=1,9),JT=1,5) /
     &1.5129E+02,1.3238E+02,1.1347E+02,9.4558E+01,7.5645E+01,5.6733E+01,
     &3.7823E+01,1.8915E+01,3.6770E-05,2.2053E+02,1.9297E+02,1.6541E+02,
     &1.3784E+02,1.1026E+02,8.2702E+01,5.5137E+01,2.7573E+01,5.2389E-05,
     &3.0464E+02,2.6657E+02,2.2849E+02,1.9040E+02,1.5233E+02,1.1424E+02,
     &7.6159E+01,3.8090E+01,7.1306E-05,4.0144E+02,3.5128E+02,3.0110E+02,
     &2.5092E+02,2.0072E+02,1.5055E+02,1.0037E+02,5.0190E+01,9.4766E-05,
     &5.1041E+02,4.4660E+02,3.8281E+02,3.1900E+02,2.5521E+02,1.9140E+02,
     &1.2761E+02,6.3809E+01,8.9549E-03/
      DATA ((KA(JS,JT,13,12),JS=1,9),JT=1,5) /
     &1.6406E+02,1.4356E+02,1.2306E+02,1.0255E+02,8.2037E+01,6.1534E+01,
     &4.1023E+01,2.0513E+01,2.9105E-05,2.3966E+02,2.0971E+02,1.7976E+02,
     &1.4978E+02,1.1983E+02,8.9879E+01,5.9920E+01,2.9966E+01,3.6736E-05,
     &3.3040E+02,2.8909E+02,2.4781E+02,2.0651E+02,1.6521E+02,1.2390E+02,
     &8.2608E+01,4.1307E+01,4.7139E-05,4.3608E+02,3.8160E+02,3.2708E+02,
     &2.7256E+02,2.1804E+02,1.6354E+02,1.0903E+02,5.4517E+01,5.9953E-05,
     &5.5401E+02,4.8478E+02,4.1553E+02,3.4627E+02,2.7701E+02,2.0776E+02,
     &1.3851E+02,6.9261E+01,1.3826E-02/
      DATA ((KA(JS,JT, 1,13),JS=1,9),JT=1,5) /
     &1.2490E-01,1.0932E-01,9.3720E-02,7.8121E-02,6.3794E-02,5.1600E-02,
     &4.4680E-02,4.2635E-02,5.5634E-02,1.4548E-01,1.2733E-01,1.0918E-01,
     &9.1021E-02,7.6620E-02,6.3500E-02,5.7581E-02,5.7524E-02,7.4793E-02,
     &1.6600E-01,1.4529E-01,1.2460E-01,1.0392E-01,9.0379E-02,7.8694E-02,
     &7.4384E-02,7.8232E-02,9.9775E-02,1.8636E-01,1.6314E-01,1.3994E-01,
     &1.1863E-01,1.0661E-01,9.7110E-02,9.8012E-02,1.0654E-01,1.3265E-01,
     &2.0606E-01,1.8040E-01,1.5476E-01,1.3669E-01,1.2405E-01,1.1873E-01,
     &1.2869E-01,1.4070E-01,1.7529E-01/
      DATA ((KA(JS,JT, 2,13),JS=1,9),JT=1,5) /
     &1.8895E-01,1.6535E-01,1.4175E-01,1.1814E-01,9.4551E-02,7.3809E-02,
     &5.5615E-02,4.4637E-02,5.3030E-02,2.2250E-01,1.9470E-01,1.6692E-01,
     &1.3914E-01,1.1136E-01,8.8262E-02,7.0022E-02,6.0363E-02,7.3472E-02,
     &2.5567E-01,2.2376E-01,1.9185E-01,1.5991E-01,1.3005E-01,1.0599E-01,
     &8.7655E-02,7.9726E-02,9.6994E-02,2.8747E-01,2.5157E-01,2.1569E-01,
     &1.7980E-01,1.5083E-01,1.2699E-01,1.0917E-01,1.0493E-01,1.2703E-01,
     &3.1781E-01,2.7817E-01,2.3857E-01,1.9898E-01,1.7411E-01,1.5016E-01,
     &1.3454E-01,1.3707E-01,1.6656E-01/
      DATA ((KA(JS,JT, 3,13),JS=1,9),JT=1,5) /
     &3.6978E-01,3.2357E-01,2.7737E-01,2.3116E-01,1.8494E-01,1.3872E-01,
     &9.4432E-02,5.7465E-02,4.7026E-02,4.3903E-01,3.8415E-01,3.2929E-01,
     &2.7445E-01,2.1956E-01,1.6470E-01,1.1482E-01,7.4394E-02,6.6138E-02,
     &5.0855E-01,4.4506E-01,3.8154E-01,3.1805E-01,2.5451E-01,1.9102E-01,
     &1.3670E-01,9.4825E-02,8.9406E-02,5.7817E-01,5.0599E-01,4.3381E-01,
     &3.6166E-01,2.8948E-01,2.2042E-01,1.6420E-01,1.1827E-01,1.1730E-01,
     &6.4715E-01,5.6638E-01,4.8566E-01,4.0494E-01,3.2419E-01,2.5446E-01,
     &1.9367E-01,1.4612E-01,1.5219E-01/
      DATA ((KA(JS,JT, 4,13),JS=1,9),JT=1,5) /
     &7.1857E-01,6.2877E-01,5.3894E-01,4.4919E-01,3.5935E-01,2.6957E-01,
     &1.7976E-01,9.3998E-02,4.1187E-02,8.6835E-01,7.5986E-01,6.5131E-01,
     &5.4283E-01,4.3435E-01,3.2583E-01,2.1731E-01,1.1522E-01,5.8302E-02,
     &1.0243E+00,8.9626E-01,7.6836E-01,6.4035E-01,5.1240E-01,3.8438E-01,
     &2.5643E-01,1.3949E-01,7.9878E-02,1.1800E+00,1.0326E+00,8.8512E-01,
     &7.3767E-01,5.9020E-01,4.4282E-01,2.9609E-01,1.6997E-01,1.0651E-01,
     &1.3277E+00,1.1619E+00,9.9598E-01,8.3009E-01,6.6410E-01,4.9823E-01,
     &3.3917E-01,2.0392E-01,1.3923E-01/
      DATA ((KA(JS,JT, 5,13),JS=1,9),JT=1,5) /
     &1.2769E+00,1.1173E+00,9.5773E-01,7.9808E-01,6.3854E-01,4.7892E-01,
     &3.1932E-01,1.5974E-01,3.6366E-02,1.5754E+00,1.3783E+00,1.1815E+00,
     &9.8457E-01,7.8769E-01,5.9081E-01,3.9400E-01,1.9711E-01,5.2068E-02,
     &1.8818E+00,1.6466E+00,1.4114E+00,1.1761E+00,9.4096E-01,7.0577E-01,
     &4.7057E-01,2.3659E-01,7.1428E-02,2.1862E+00,1.9130E+00,1.6397E+00,
     &1.3666E+00,1.0933E+00,8.2000E-01,5.4672E-01,2.8019E-01,9.6282E-02,
     &2.4918E+00,2.1806E+00,1.8691E+00,1.5576E+00,1.2460E+00,9.3474E-01,
     &6.2322E-01,3.2775E-01,1.2758E-01/
      DATA ((KA(JS,JT, 6,13),JS=1,9),JT=1,5) /
     &2.0873E+00,1.8265E+00,1.5654E+00,1.3046E+00,1.0437E+00,7.8276E-01,
     &5.2187E-01,2.6100E-01,3.1022E-02,2.6230E+00,2.2953E+00,1.9673E+00,
     &1.6394E+00,1.3116E+00,9.8380E-01,6.5587E-01,3.2796E-01,4.5564E-02,
     &3.1789E+00,2.7816E+00,2.3843E+00,1.9870E+00,1.5894E+00,1.1921E+00,
     &7.9481E-01,3.9748E-01,6.4081E-02,3.7665E+00,3.2952E+00,2.8247E+00,
     &2.3538E+00,1.8832E+00,1.4124E+00,9.4165E-01,4.7095E-01,8.7003E-02,
     &4.3632E+00,3.8180E+00,3.2726E+00,2.7273E+00,2.1819E+00,1.6363E+00,
     &1.0910E+00,5.4560E-01,1.1609E-01/
      DATA ((KA(JS,JT, 7,13),JS=1,9),JT=1,5) /
     &3.5237E+00,3.0834E+00,2.6428E+00,2.2023E+00,1.7619E+00,1.3214E+00,
     &8.8102E-01,4.4047E-01,2.5898E-02,4.5331E+00,3.9665E+00,3.3999E+00,
     &2.8333E+00,2.2667E+00,1.6999E+00,1.1334E+00,5.6671E-01,3.9066E-02,
     &5.6378E+00,4.9326E+00,4.2280E+00,3.5234E+00,2.8189E+00,2.1142E+00,
     &1.4094E+00,7.0475E-01,5.6679E-02,6.8044E+00,5.9541E+00,5.1033E+00,
     &4.2525E+00,3.4021E+00,2.5518E+00,1.7012E+00,8.5062E-01,7.8214E-02,
     &7.9748E+00,6.9785E+00,5.9814E+00,4.9841E+00,3.9872E+00,2.9906E+00,
     &1.9939E+00,9.9695E-01,1.0573E-01/
      DATA ((KA(JS,JT, 8,13),JS=1,9),JT=1,5) /
     &7.0539E+00,6.1726E+00,5.2906E+00,4.4088E+00,3.5267E+00,2.6453E+00,
     &1.7634E+00,8.8179E-01,2.1249E-02,9.3702E+00,8.1985E+00,7.0273E+00,
     &5.8560E+00,4.6849E+00,3.5137E+00,2.3424E+00,1.1713E+00,3.3095E-02,
     &1.1943E+01,1.0450E+01,8.9569E+00,7.4646E+00,5.9714E+00,4.4785E+00,
     &2.9858E+00,1.4929E+00,4.9465E-02,1.4646E+01,1.2815E+01,1.0984E+01,
     &9.1536E+00,7.3228E+00,5.4925E+00,3.6616E+00,1.8307E+00,7.0099E-02,
     &1.7489E+01,1.5303E+01,1.3117E+01,1.0930E+01,8.7446E+00,6.5589E+00,
     &4.3724E+00,2.1863E+00,9.5981E-02/
      DATA ((KA(JS,JT, 9,13),JS=1,9),JT=1,5) /
     &2.6371E+01,2.3078E+01,1.9780E+01,1.6484E+01,1.3187E+01,9.8900E+00,
     &6.5930E+00,3.2967E+00,6.8943E-03,3.6211E+01,3.1684E+01,2.7158E+01,
     &2.2631E+01,1.8105E+01,1.3579E+01,9.0530E+00,4.5262E+00,1.7485E-02,
     &4.7281E+01,4.1374E+01,3.5462E+01,2.9549E+01,2.3642E+01,1.7731E+01,
     &1.1820E+01,5.9103E+00,4.0011E-02,5.9381E+01,5.1957E+01,4.4537E+01,
     &3.7114E+01,2.9690E+01,2.2267E+01,1.4846E+01,7.4229E+00,6.1300E-02,
     &7.2474E+01,6.3419E+01,5.4356E+01,4.5296E+01,3.6239E+01,2.7178E+01,
     &1.8119E+01,9.0595E+00,8.5682E-02/
      DATA ((KA(JS,JT,10,13),JS=1,9),JT=1,5) /
     &1.1184E+02,9.7849E+01,8.3875E+01,6.9894E+01,5.5915E+01,4.1936E+01,
     &2.7957E+01,1.3979E+01,1.8093E-05,1.5816E+02,1.3839E+02,1.1862E+02,
     &9.8846E+01,7.9081E+01,5.9311E+01,3.9538E+01,1.9769E+01,2.0368E-03,
     &2.1176E+02,1.8530E+02,1.5882E+02,1.3236E+02,1.0588E+02,7.9412E+01,
     &5.2940E+01,2.6470E+01,1.0379E-02,2.7234E+02,2.3829E+02,2.0425E+02,
     &1.7021E+02,1.3616E+02,1.0213E+02,6.8082E+01,3.4042E+01,8.3550E-03,
     &3.3838E+02,2.9608E+02,2.5378E+02,2.1148E+02,1.6919E+02,1.2688E+02,
     &8.4588E+01,4.2296E+01,2.4237E-02/
      DATA ((KA(JS,JT,11,13),JS=1,9),JT=1,5) /
     &1.9607E+02,1.7156E+02,1.4706E+02,1.2254E+02,9.8035E+01,7.3528E+01,
     &4.9019E+01,2.4510E+01,1.9563E-05,2.7783E+02,2.4308E+02,2.0836E+02,
     &1.7363E+02,1.3891E+02,1.0418E+02,6.9451E+01,3.4727E+01,2.1737E-05,
     &3.7392E+02,3.2720E+02,2.8047E+02,2.3371E+02,1.8697E+02,1.4023E+02,
     &9.3485E+01,4.6744E+01,2.8098E-05,4.8258E+02,4.2223E+02,3.6194E+02,
     &3.0162E+02,2.4128E+02,1.8096E+02,1.2064E+02,6.0325E+01,6.2823E-03,
     &6.0149E+02,5.2626E+02,4.5111E+02,3.7591E+02,3.0076E+02,2.2554E+02,
     &1.5037E+02,7.5184E+01,1.4409E-02/
      DATA ((KA(JS,JT,12,13),JS=1,9),JT=1,5) /
     &2.5475E+02,2.2289E+02,1.9106E+02,1.5923E+02,1.2737E+02,9.5526E+01,
     &6.3684E+01,3.1843E+01,2.0642E-05,3.6233E+02,3.1704E+02,2.7175E+02,
     &2.2647E+02,1.8117E+02,1.3587E+02,9.0584E+01,4.5292E+01,3.1983E-05,
     &4.8916E+02,4.2803E+02,3.6684E+02,3.0571E+02,2.4456E+02,1.8343E+02,
     &1.2228E+02,6.1143E+01,4.9821E-05,6.3314E+02,5.5397E+02,4.7487E+02,
     &3.9571E+02,3.1654E+02,2.3742E+02,1.5828E+02,7.9139E+01,7.0156E-05,
     &7.9128E+02,6.9231E+02,5.9347E+02,4.9456E+02,3.9565E+02,2.9675E+02,
     &1.9782E+02,9.8911E+01,2.0440E-02/
      DATA ((KA(JS,JT,13,13),JS=1,9),JT=1,5) /
     &2.6423E+02,2.3120E+02,1.9817E+02,1.6514E+02,1.3211E+02,9.9077E+01,
     &6.6055E+01,3.3026E+01,2.0316E-05,3.7762E+02,3.3041E+02,2.8322E+02,
     &2.3600E+02,1.8882E+02,1.4161E+02,9.4405E+01,4.7199E+01,3.9220E-05,
     &5.1221E+02,4.4817E+02,3.8414E+02,3.2014E+02,2.5611E+02,1.9208E+02,
     &1.2806E+02,6.4027E+01,5.9611E-05,6.6615E+02,5.8290E+02,4.9961E+02,
     &4.1636E+02,3.3309E+02,2.4982E+02,1.6655E+02,8.3275E+01,8.3600E-05,
     &8.3847E+02,7.3367E+02,6.2884E+02,5.2405E+02,4.1925E+02,3.1441E+02,
     &2.0962E+02,1.0481E+02,8.6814E-03/
      DATA ((KA(JS,JT, 1,14),JS=1,9),JT=1,5) /
     &1.4546E-01,1.2729E-01,1.0913E-01,9.0969E-02,7.2816E-02,6.3783E-02,
     &5.7732E-02,5.8710E-02,8.0301E-02,1.6927E-01,1.4814E-01,1.2702E-01,
     &1.0589E-01,8.6710E-02,8.1091E-02,8.1369E-02,8.2706E-02,1.1649E-01,
     &1.9294E-01,1.6889E-01,1.4479E-01,1.2072E-01,1.0647E-01,1.0625E-01,
     &1.1521E-01,1.1490E-01,1.6620E-01,2.1639E-01,1.8940E-01,1.6240E-01,
     &1.3541E-01,1.3447E-01,1.4239E-01,1.5920E-01,1.5808E-01,2.2919E-01,
     &2.3882E-01,2.0905E-01,1.7929E-01,1.5673E-01,1.6730E-01,1.8853E-01,
     &2.1227E-01,2.1249E-01,3.0359E-01/
      DATA ((KA(JS,JT, 2,14),JS=1,9),JT=1,5) /
     &2.2939E-01,2.0073E-01,1.7206E-01,1.4339E-01,1.1475E-01,8.6951E-02,
     &7.2184E-02,6.3155E-02,8.0463E-02,2.6931E-01,2.3569E-01,2.0200E-01,
     &1.6840E-01,1.3475E-01,1.0880E-01,9.2729E-02,8.6720E-02,1.1351E-01,
     &3.0958E-01,2.7100E-01,2.3236E-01,1.9370E-01,1.5506E-01,1.3547E-01,
     &1.2355E-01,1.2394E-01,1.6330E-01,3.5073E-01,3.0694E-01,2.6319E-01,
     &2.1943E-01,1.7928E-01,1.7126E-01,1.6643E-01,1.7360E-01,2.2783E-01,
     &3.9134E-01,3.4248E-01,2.9368E-01,2.4496E-01,2.1593E-01,2.1367E-01,
     &2.2253E-01,2.3537E-01,3.0544E-01/
      DATA ((KA(JS,JT, 3,14),JS=1,9),JT=1,5) /
     &4.7010E-01,4.1135E-01,3.5261E-01,2.9387E-01,2.3512E-01,1.7638E-01,
     &1.1764E-01,7.8616E-02,7.6241E-02,5.6247E-01,4.9221E-01,4.2195E-01,
     &3.5165E-01,2.8136E-01,2.1111E-01,1.4480E-01,1.0039E-01,1.0523E-01,
     &6.5749E-01,5.7537E-01,4.9319E-01,4.1105E-01,3.2895E-01,2.4684E-01,
     &1.7889E-01,1.3157E-01,1.4752E-01,7.5292E-01,6.5895E-01,5.6476E-01,
     &4.7081E-01,3.7678E-01,2.8272E-01,2.2206E-01,1.7756E-01,2.0769E-01,
     &8.4721E-01,7.4147E-01,6.3570E-01,5.2989E-01,4.2402E-01,3.2414E-01,
     &2.7831E-01,2.3784E-01,2.8406E-01/
      DATA ((KA(JS,JT, 4,14),JS=1,9),JT=1,5) /
     &9.7171E-01,8.5020E-01,7.2877E-01,6.0734E-01,4.8590E-01,3.6445E-01,
     &2.4301E-01,1.2213E-01,6.9724E-02,1.1819E+00,1.0342E+00,8.8647E-01,
     &7.3863E-01,5.9101E-01,4.4338E-01,2.9560E-01,1.5522E-01,9.6103E-02,
     &1.3997E+00,1.2249E+00,1.0500E+00,8.7515E-01,7.0004E-01,5.2502E-01,
     &3.5022E-01,1.9543E-01,1.3302E-01,1.6223E+00,1.4197E+00,1.2167E+00,
     &1.0141E+00,8.1148E-01,6.0893E-01,4.0620E-01,2.4484E-01,1.8472E-01,
     &1.8526E+00,1.6213E+00,1.3899E+00,1.1585E+00,9.2711E-01,6.9563E-01,
     &4.6462E-01,3.0719E-01,2.5304E-01/
      DATA ((KA(JS,JT, 5,14),JS=1,9),JT=1,5) /
     &1.8192E+00,1.5916E+00,1.3645E+00,1.1369E+00,9.0965E-01,6.8222E-01,
     &4.5478E-01,2.2743E-01,6.1385E-02,2.2491E+00,1.9677E+00,1.6869E+00,
     &1.4056E+00,1.1246E+00,8.4332E-01,5.6233E-01,2.8119E-01,8.6006E-02,
     &2.7102E+00,2.3722E+00,2.0328E+00,1.6939E+00,1.3553E+00,1.0165E+00,
     &6.7791E-01,3.3919E-01,1.2062E-01,3.1976E+00,2.7982E+00,2.3984E+00,
     &1.9988E+00,1.5996E+00,1.1997E+00,8.0003E-01,4.0180E-01,1.6649E-01,
     &3.6973E+00,3.2349E+00,2.7730E+00,2.3110E+00,1.8489E+00,1.3873E+00,
     &9.2506E-01,4.7326E-01,2.2654E-01/
      DATA ((KA(JS,JT, 6,14),JS=1,9),JT=1,5) /
     &3.1019E+00,2.7140E+00,2.3265E+00,1.9387E+00,1.5510E+00,1.1633E+00,
     &7.7552E-01,3.8777E-01,5.2928E-02,3.9302E+00,3.4386E+00,2.9473E+00,
     &2.4561E+00,1.9652E+00,1.4738E+00,9.8267E-01,4.9148E-01,7.5058E-02,
     &4.8343E+00,4.2298E+00,3.6258E+00,3.0217E+00,2.4174E+00,1.8133E+00,
     &1.2090E+00,6.0467E-01,1.0698E-01,5.7912E+00,5.0677E+00,4.3433E+00,
     &3.6195E+00,2.8961E+00,2.1723E+00,1.4483E+00,7.2440E-01,1.4901E-01,
     &6.7811E+00,5.9338E+00,5.0864E+00,4.2388E+00,3.3910E+00,2.5430E+00,
     &1.6957E+00,8.4831E-01,2.0161E-01/
      DATA ((KA(JS,JT, 7,14),JS=1,9),JT=1,5) /
     &5.4638E+00,4.7799E+00,4.0972E+00,3.4147E+00,2.7314E+00,2.0488E+00,
     &1.3659E+00,6.8294E-01,4.5673E-02,7.1063E+00,6.2177E+00,5.3292E+00,
     &4.4410E+00,3.5530E+00,2.6647E+00,1.7765E+00,8.8835E-01,6.5608E-02,
     &8.9165E+00,7.8008E+00,6.6867E+00,5.5727E+00,4.4582E+00,3.3435E+00,
     &2.2293E+00,1.1147E+00,9.3558E-02,1.0858E+01,9.5015E+00,8.1441E+00,
     &6.7868E+00,5.4291E+00,4.0729E+00,2.7150E+00,1.3577E+00,1.3310E-01,
     &1.2930E+01,1.1317E+01,9.6983E+00,8.0819E+00,6.4667E+00,4.8496E+00,
     &3.2333E+00,1.6168E+00,1.8236E-01/
      DATA ((KA(JS,JT, 8,14),JS=1,9),JT=1,5) /
     &1.1346E+01,9.9283E+00,8.5084E+00,7.0912E+00,5.6732E+00,4.2544E+00,
     &2.8362E+00,1.4181E+00,3.9157E-02,1.5150E+01,1.3257E+01,1.1363E+01,
     &9.4692E+00,7.5753E+00,5.6816E+00,3.7878E+00,1.8940E+00,5.7302E-02,
     &1.9415E+01,1.6989E+01,1.4562E+01,1.2134E+01,9.7069E+00,7.2806E+00,
     &4.8539E+00,2.4270E+00,8.2333E-02,2.4092E+01,2.1079E+01,1.8070E+01,
     &1.5059E+01,1.2046E+01,9.0355E+00,6.0239E+00,3.0117E+00,1.1787E-01,
     &2.9062E+01,2.5429E+01,2.1796E+01,1.8164E+01,1.4531E+01,1.0899E+01,
     &7.2663E+00,3.6329E+00,1.6482E-01/
      DATA ((KA(JS,JT, 9,14),JS=1,9),JT=1,5) /
     &4.3556E+01,3.8120E+01,3.2674E+01,2.7224E+01,2.1783E+01,1.6334E+01,
     &1.0888E+01,5.4440E+00,2.2652E-02,5.9826E+01,5.2350E+01,4.4870E+01,
     &3.7394E+01,2.9916E+01,2.2436E+01,1.4957E+01,7.4785E+00,4.6893E-02,
     &7.8381E+01,6.8585E+01,5.8789E+01,4.8993E+01,3.9194E+01,2.9396E+01,
     &1.9597E+01,9.7990E+00,7.2210E-02,9.9048E+01,8.6676E+01,7.4294E+01,
     &6.1915E+01,4.9526E+01,3.7147E+01,2.4767E+01,1.2383E+01,1.0452E-01,
     &1.2130E+02,1.0614E+02,9.0980E+01,7.5818E+01,6.0656E+01,4.5493E+01,
     &3.0327E+01,1.5163E+01,1.4798E-01/
      DATA ((KA(JS,JT,10,14),JS=1,9),JT=1,5) /
     &1.8821E+02,1.6469E+02,1.4116E+02,1.1763E+02,9.4105E+01,7.0580E+01,
     &4.7054E+01,2.3527E+01,9.8284E-06,2.6476E+02,2.3166E+02,1.9858E+02,
     &1.6548E+02,1.3239E+02,9.9294E+01,6.6189E+01,3.3094E+01,1.2967E-05,
     &3.5496E+02,3.1059E+02,2.6621E+02,2.2185E+02,1.7748E+02,1.3310E+02,
     &8.8736E+01,4.4370E+01,2.4344E-02,4.5706E+02,3.9992E+02,3.4280E+02,
     &2.8566E+02,2.2852E+02,1.7137E+02,1.1427E+02,5.7136E+01,2.2864E-02,
     &5.6918E+02,4.9801E+02,4.2687E+02,3.5573E+02,2.8459E+02,2.1346E+02,
     &1.4231E+02,7.1148E+01,3.1037E-02/
      DATA ((KA(JS,JT,11,14),JS=1,9),JT=1,5) /
     &3.3285E+02,2.9123E+02,2.4962E+02,2.0803E+02,1.6643E+02,1.2482E+02,
     &8.3209E+01,4.1605E+01,7.6787E-06,4.7091E+02,4.1207E+02,3.5320E+02,
     &2.9434E+02,2.3549E+02,1.7660E+02,1.1774E+02,5.8871E+01,1.2053E-05,
     &6.3434E+02,5.5505E+02,4.7579E+02,3.9648E+02,3.1719E+02,2.3787E+02,
     &1.5859E+02,7.9298E+01,1.7979E-05,8.2080E+02,7.1819E+02,6.1562E+02,
     &5.1300E+02,4.1039E+02,3.0781E+02,2.0518E+02,1.0261E+02,2.6043E-05,
     &1.0279E+03,8.9936E+02,7.7089E+02,6.4243E+02,5.1399E+02,3.8545E+02,
     &2.5700E+02,1.2849E+02,3.6811E-02/
      DATA ((KA(JS,JT,12,14),JS=1,9),JT=1,5) /
     &4.4072E+02,3.8565E+02,3.3056E+02,2.7546E+02,2.2036E+02,1.6527E+02,
     &1.1018E+02,5.5100E+01,6.3836E-06,6.2804E+02,5.4949E+02,4.7103E+02,
     &3.9252E+02,3.1400E+02,2.3550E+02,1.5700E+02,7.8501E+01,1.0354E-05,
     &8.4964E+02,7.4346E+02,6.3726E+02,5.3106E+02,4.2484E+02,3.1862E+02,
     &2.1241E+02,1.0621E+02,1.6673E-05,1.1033E+03,9.6532E+02,8.2745E+02,
     &6.8953E+02,5.5162E+02,4.1376E+02,2.7582E+02,1.3790E+02,2.5500E-05,
     &1.3847E+03,1.2117E+03,1.0386E+03,8.6544E+02,6.9241E+02,5.1925E+02,
     &3.4620E+02,1.7310E+02,3.8579E-05/
      DATA ((KA(JS,JT,13,14),JS=1,9),JT=1,5) /
     &4.7310E+02,4.1397E+02,3.5483E+02,2.9569E+02,2.3655E+02,1.7741E+02,
     &1.1827E+02,5.9135E+01,7.3062E-06,6.7569E+02,5.9130E+02,5.0679E+02,
     &4.2232E+02,3.3786E+02,2.5340E+02,1.6892E+02,8.4465E+01,8.6740E-06,
     &9.1788E+02,8.0315E+02,6.8841E+02,5.7369E+02,4.5893E+02,3.4424E+02,
     &2.2946E+02,1.1474E+02,1.3663E-05,1.1975E+03,1.0479E+03,8.9816E+02,
     &7.4843E+02,5.9874E+02,4.4905E+02,2.9938E+02,1.4969E+02,2.1412E-05,
     &1.5101E+03,1.3214E+03,1.1326E+03,9.4376E+02,7.5504E+02,5.6626E+02,
     &3.7752E+02,1.8876E+02,3.3615E-05/
      DATA ((KA(JS,JT, 1,15),JS=1,9),JT=1,5) /
     &1.9051E-01,1.6674E-01,1.4292E-01,1.1918E-01,9.5396E-02,7.5613E-02,
     &8.0457E-02,7.8890E-02,1.1694E-01,2.2168E-01,1.9400E-01,1.6634E-01,
     &1.3865E-01,1.1100E-01,1.0009E-01,1.1113E-01,1.0913E-01,1.6166E-01,
     &2.5284E-01,2.2130E-01,1.8975E-01,1.5816E-01,1.2778E-01,1.3319E-01,
     &1.4805E-01,1.4559E-01,2.1625E-01,2.8343E-01,2.4807E-01,2.1270E-01,
     &1.7731E-01,1.5213E-01,1.7480E-01,1.9314E-01,1.8830E-01,2.8691E-01,
     &3.1350E-01,2.7439E-01,2.3527E-01,1.9622E-01,1.9594E-01,2.3135E-01,
     &2.5307E-01,2.4156E-01,3.8082E-01/
      DATA ((KA(JS,JT, 2,15),JS=1,9),JT=1,5) /
     &3.2111E-01,2.8102E-01,2.4090E-01,2.0079E-01,1.6069E-01,1.2054E-01,
     &9.0034E-02,8.9831E-02,1.2243E-01,3.7636E-01,3.2926E-01,2.8226E-01,
     &2.3534E-01,1.8831E-01,1.4126E-01,1.2281E-01,1.2620E-01,1.7187E-01,
     &4.3275E-01,3.7860E-01,3.2463E-01,2.7055E-01,2.1650E-01,1.6706E-01,
     &1.6578E-01,1.7060E-01,2.3384E-01,4.8952E-01,4.2824E-01,3.6725E-01,
     &3.0597E-01,2.4488E-01,2.0300E-01,2.2012E-01,2.2396E-01,3.1375E-01,
     &5.4581E-01,4.7748E-01,4.0943E-01,3.4119E-01,2.7312E-01,2.6005E-01,
     &2.9166E-01,2.9212E-01,4.1866E-01/
      DATA ((KA(JS,JT, 3,15),JS=1,9),JT=1,5) /
     &6.9979E-01,6.1213E-01,5.2483E-01,4.3719E-01,3.4984E-01,2.6243E-01,
     &1.7501E-01,9.9676E-02,1.1688E-01,8.3387E-01,7.2959E-01,6.2545E-01,
     &5.2112E-01,4.1694E-01,3.1278E-01,2.0862E-01,1.3660E-01,1.6827E-01,
     &9.7266E-01,8.5098E-01,7.2958E-01,6.0802E-01,4.8655E-01,3.6492E-01,
     &2.4335E-01,1.8790E-01,2.3450E-01,1.1134E+00,9.7421E-01,8.3530E-01,
     &6.9606E-01,5.5697E-01,4.1779E-01,2.8251E-01,2.5378E-01,3.2011E-01,
     &1.2541E+00,1.0974E+00,9.4084E-01,7.8396E-01,6.2738E-01,4.7061E-01,
     &3.3812E-01,3.3805E-01,4.3341E-01/
      DATA ((KA(JS,JT, 4,15),JS=1,9),JT=1,5) /
     &1.5338E+00,1.3422E+00,1.1503E+00,9.5870E-01,7.6686E-01,5.7527E-01,
     &3.8351E-01,1.9180E-01,1.0723E-01,1.8631E+00,1.6302E+00,1.3974E+00,
     &1.1644E+00,9.3180E-01,6.9872E-01,4.6589E-01,2.3301E-01,1.5610E-01,
     &2.2077E+00,1.9315E+00,1.6557E+00,1.3803E+00,1.1039E+00,8.2801E-01,
     &5.5191E-01,2.7612E-01,2.2377E-01,2.5609E+00,2.2407E+00,1.9209E+00,
     &1.6005E+00,1.2804E+00,9.6050E-01,6.4039E-01,3.2615E-01,3.1195E-01,
     &2.9154E+00,2.5514E+00,2.1867E+00,1.8223E+00,1.4581E+00,1.0937E+00,
     &7.2913E-01,3.9607E-01,4.2846E-01/
      DATA ((KA(JS,JT, 5,15),JS=1,9),JT=1,5) /
     &3.0736E+00,2.6896E+00,2.3057E+00,1.9212E+00,1.5370E+00,1.1527E+00,
     &7.6854E-01,3.8431E-01,1.0147E-01,3.8075E+00,3.3314E+00,2.8555E+00,
     &2.3797E+00,1.9037E+00,1.4279E+00,9.5192E-01,4.7599E-01,1.4471E-01,
     &4.5849E+00,4.0117E+00,3.4370E+00,2.8652E+00,2.2919E+00,1.7190E+00,
     &1.1462E+00,5.7315E-01,2.0749E-01,5.3872E+00,4.7143E+00,4.0418E+00,
     &3.3672E+00,2.6939E+00,2.0205E+00,1.3469E+00,6.7361E-01,2.9614E-01,
     &6.2028E+00,5.4263E+00,4.6517E+00,3.8766E+00,3.1014E+00,2.3260E+00,
     &1.5507E+00,7.7527E-01,4.1447E-01/
      DATA ((KA(JS,JT, 6,15),JS=1,9),JT=1,5) /
     &5.6666E+00,4.9583E+00,4.2496E+00,3.5417E+00,2.8332E+00,2.1246E+00,
     &1.4165E+00,7.0837E-01,9.5689E-02,7.1702E+00,6.2735E+00,5.3788E+00,
     &4.4810E+00,3.5859E+00,2.6888E+00,1.7925E+00,8.9634E-01,1.3582E-01,
     &8.7850E+00,7.6873E+00,6.5880E+00,5.4902E+00,4.3923E+00,3.2943E+00,
     &2.1960E+00,1.0981E+00,1.9014E-01,1.0471E+01,9.1623E+00,7.8537E+00,
     &6.5443E+00,5.2362E+00,3.9265E+00,2.6173E+00,1.3091E+00,2.7084E-01,
     &1.2195E+01,1.0670E+01,9.1465E+00,7.6219E+00,6.0976E+00,4.5729E+00,
     &3.0483E+00,1.5247E+00,3.8788E-01/
      DATA ((KA(JS,JT, 7,15),JS=1,9),JT=1,5) /
     &1.0821E+01,9.4694E+00,8.1159E+00,6.7641E+00,5.4109E+00,4.0578E+00,
     &2.7049E+00,1.3527E+00,8.8090E-02,1.4005E+01,1.2256E+01,1.0505E+01,
     &8.7544E+00,7.0039E+00,5.2527E+00,3.5019E+00,1.7510E+00,1.2836E-01,
     &1.7472E+01,1.5288E+01,1.3104E+01,1.0920E+01,8.7370E+00,6.5526E+00,
     &4.3682E+00,2.1842E+00,1.7912E-01,2.1133E+01,1.8491E+01,1.5850E+01,
     &1.3209E+01,1.0568E+01,7.9265E+00,5.2835E+00,2.6416E+00,2.4968E-01,
     &2.4946E+01,2.1829E+01,1.8712E+01,1.5594E+01,1.2475E+01,9.3563E+00,
     &6.2369E+00,3.1183E+00,3.5418E-01/
      DATA ((KA(JS,JT, 8,15),JS=1,9),JT=1,5) /
     &2.4402E+01,2.1362E+01,1.8302E+01,1.5253E+01,1.2203E+01,9.1488E+00,
     &6.1012E+00,3.0503E+00,8.0172E-02,3.2338E+01,2.8299E+01,2.4254E+01,
     &2.0211E+01,1.6168E+01,1.2127E+01,8.0850E+00,4.0423E+00,1.1917E-01,
     &4.1117E+01,3.5977E+01,3.0837E+01,2.5703E+01,2.0563E+01,1.5418E+01,
     &1.0280E+01,5.1397E+00,1.6937E-01,5.0705E+01,4.4368E+01,3.8026E+01,
     &3.1698E+01,2.5350E+01,1.9014E+01,1.2673E+01,6.3384E+00,2.3470E-01,
     &6.0900E+01,5.3282E+01,4.5673E+01,3.8064E+01,3.0449E+01,2.2835E+01,
     &1.5224E+01,7.6126E+00,3.2704E-01/
      DATA ((KA(JS,JT, 9,15),JS=1,9),JT=1,5) /
     &1.0170E+02,8.8996E+01,7.6286E+01,6.3569E+01,5.0854E+01,3.8145E+01,
     &2.5429E+01,1.2713E+01,7.1359E-02,1.3845E+02,1.2114E+02,1.0384E+02,
     &8.6532E+01,6.9224E+01,5.1921E+01,3.4611E+01,1.7307E+01,1.0767E-01,
     &1.8073E+02,1.5810E+02,1.3551E+02,1.1293E+02,9.0345E+01,6.7755E+01,
     &4.5176E+01,2.2583E+01,1.5849E-01,2.2745E+02,1.9903E+02,1.7061E+02,
     &1.4217E+02,1.1373E+02,8.5301E+01,5.6875E+01,2.8433E+01,2.2030E-01,
     &2.7773E+02,2.4298E+02,2.0829E+02,1.7358E+02,1.3886E+02,1.0414E+02,
     &6.9430E+01,3.4715E+01,3.0575E-01/
      DATA ((KA(JS,JT,10,15),JS=1,9),JT=1,5) /
     &4.7674E+02,4.1715E+02,3.5753E+02,2.9794E+02,2.3835E+02,1.7878E+02,
     &1.1918E+02,5.9592E+01,7.9888E-06,6.6856E+02,5.8521E+02,5.0164E+02,
     &4.1786E+02,3.3435E+02,2.5071E+02,1.6719E+02,8.3597E+01,1.0572E-05,
     &8.9281E+02,7.8118E+02,6.6956E+02,5.5797E+02,4.4639E+02,3.3479E+02,
     &2.2318E+02,1.1160E+02,1.3235E-05,1.1439E+03,1.0009E+03,8.5793E+02,
     &7.1497E+02,5.7192E+02,4.2885E+02,2.8596E+02,1.4299E+02,7.9928E-02,
     &1.4160E+03,1.2390E+03,1.0620E+03,8.8492E+02,7.0798E+02,5.3098E+02,
     &3.5397E+02,1.7699E+02,2.0557E-01/
      DATA ((KA(JS,JT,11,15),JS=1,9),JT=1,5) /
     &9.1777E+02,8.0296E+02,6.8835E+02,5.7354E+02,4.5882E+02,3.4414E+02,
     &2.2941E+02,1.1472E+02,9.0079E-06,1.2897E+03,1.1284E+03,9.6718E+02,
     &8.0605E+02,6.4484E+02,4.8368E+02,3.2242E+02,1.6120E+02,1.0534E-05,
     &1.7217E+03,1.5064E+03,1.2912E+03,1.0761E+03,8.6072E+02,6.4564E+02,
     &4.3042E+02,2.1520E+02,1.2890E-05,2.2030E+03,1.9276E+03,1.6522E+03,
     &1.3769E+03,1.1015E+03,8.2614E+02,5.5075E+02,2.7537E+02,1.8773E-05,
     &2.7288E+03,2.3877E+03,2.0468E+03,1.7056E+03,1.3645E+03,1.0232E+03,
     &6.8218E+02,3.4109E+02,2.8192E-05/
      DATA ((KA(JS,JT,12,15),JS=1,9),JT=1,5) /
     &1.3049E+03,1.1418E+03,9.7855E+02,8.1546E+02,6.5249E+02,4.8934E+02,
     &3.2625E+02,1.6311E+02,7.4201E-06,1.8314E+03,1.6024E+03,1.3735E+03,
     &1.1446E+03,9.1569E+02,6.8677E+02,4.5789E+02,2.2893E+02,9.0712E-06,
     &2.4447E+03,2.1390E+03,1.8335E+03,1.5279E+03,1.2222E+03,9.1674E+02,
     &6.1121E+02,3.0557E+02,9.2932E-06,3.1395E+03,2.7470E+03,2.3545E+03,
     &1.9622E+03,1.5697E+03,1.1774E+03,7.8488E+02,3.9241E+02,1.2651E-05,
     &3.8988E+03,3.4115E+03,2.9243E+03,2.4367E+03,1.9495E+03,1.4621E+03,
     &9.7464E+02,4.8737E+02,2.0431E-05/
      DATA ((KA(JS,JT,13,15),JS=1,9),JT=1,5) /
     &1.4703E+03,1.2867E+03,1.1028E+03,9.1904E+02,7.3532E+02,5.5150E+02,
     &3.6759E+02,1.8380E+02,5.1458E-06,2.0704E+03,1.8115E+03,1.5528E+03,
     &1.2939E+03,1.0351E+03,7.7638E+02,5.1765E+02,2.5875E+02,6.1867E-06,
     &2.7739E+03,2.4272E+03,2.0805E+03,1.7336E+03,1.3869E+03,1.0403E+03,
     &6.9356E+02,3.4674E+02,7.7061E-06,3.5658E+03,3.1198E+03,2.6740E+03,
     &2.2287E+03,1.7830E+03,1.3371E+03,8.9142E+02,4.4572E+02,1.1573E-05,
     &4.4270E+03,3.8738E+03,3.3205E+03,2.7670E+03,2.2135E+03,1.6602E+03,
     &1.1068E+03,5.5337E+02,1.8919E-05/
      DATA ((KA(JS,JT, 1,16),JS=1,9),JT=1,5) /
     &2.0584E-01,1.8014E-01,1.5444E-01,1.2874E-01,1.0304E-01,7.7345E-02,
     &8.4273E-02,8.1561E-02,1.2397E-01,2.4103E-01,2.1093E-01,1.8085E-01,
     &1.5075E-01,1.2067E-01,1.0583E-01,1.1670E-01,1.1303E-01,1.7190E-01,
     &2.7664E-01,2.4213E-01,2.0759E-01,1.7305E-01,1.3852E-01,1.4127E-01,
     &1.5588E-01,1.5105E-01,2.2980E-01,3.1217E-01,2.7321E-01,2.3426E-01,
     &1.9529E-01,1.5635E-01,1.8285E-01,2.0187E-01,1.9571E-01,2.9781E-01,
     &3.4704E-01,3.0374E-01,2.6044E-01,2.1712E-01,2.0704E-01,2.4179E-01,
     &2.6249E-01,2.4688E-01,4.0744E-01/
      DATA ((KA(JS,JT, 2,16),JS=1,9),JT=1,5) /
     &3.5775E-01,3.1302E-01,2.6832E-01,2.2363E-01,1.7894E-01,1.3423E-01,
     &9.4199E-02,9.5152E-02,1.3347E-01,4.2272E-01,3.6993E-01,3.1710E-01,
     &2.6431E-01,2.1146E-01,1.5866E-01,1.3268E-01,1.3412E-01,1.8823E-01,
     &4.8911E-01,4.2798E-01,3.6687E-01,3.0577E-01,2.4466E-01,1.8360E-01,
     &1.7978E-01,1.8185E-01,2.5529E-01,5.5559E-01,4.8623E-01,4.1679E-01,
     &3.4735E-01,2.7796E-01,2.0932E-01,2.3570E-01,2.3853E-01,3.3493E-01,
     &6.2130E-01,5.4374E-01,4.6609E-01,3.8845E-01,3.1090E-01,2.6998E-01,
     &3.0230E-01,3.0412E-01,4.4787E-01/
      DATA ((KA(JS,JT, 3,16),JS=1,9),JT=1,5) /
     &8.0759E-01,7.0655E-01,6.0564E-01,5.0473E-01,4.0382E-01,3.0291E-01,
     &2.0195E-01,1.0457E-01,1.3240E-01,9.6833E-01,8.4737E-01,7.2636E-01,
     &6.0527E-01,4.8421E-01,3.6321E-01,2.4220E-01,1.5138E-01,1.9184E-01,
     &1.1342E+00,9.9245E-01,8.5072E-01,7.0903E-01,5.6727E-01,4.2548E-01,
     &2.8373E-01,2.0993E-01,2.6621E-01,1.3024E+00,1.1395E+00,9.7685E-01,
     &8.1409E-01,6.5126E-01,4.8855E-01,3.2575E-01,2.8072E-01,3.5605E-01,
     &1.4698E+00,1.2860E+00,1.1024E+00,9.1880E-01,7.3505E-01,5.5132E-01,
     &3.6767E-01,3.6382E-01,4.6256E-01/
      DATA ((KA(JS,JT, 4,16),JS=1,9),JT=1,5) /
     &1.8354E+00,1.6059E+00,1.3766E+00,1.1471E+00,9.1770E-01,6.8825E-01,
     &4.5887E-01,2.2948E-01,1.2512E-01,2.2391E+00,1.9593E+00,1.6796E+00,
     &1.3998E+00,1.1197E+00,8.3982E-01,5.5988E-01,2.7997E-01,1.8724E-01,
     &2.6616E+00,2.3290E+00,1.9963E+00,1.6635E+00,1.3310E+00,9.9835E-01,
     &6.6551E-01,3.3282E-01,2.6695E-01,3.0942E+00,2.7077E+00,2.3212E+00,
     &1.9341E+00,1.5474E+00,1.1605E+00,7.7373E-01,3.8698E-01,3.6534E-01,
     &3.5299E+00,3.0886E+00,2.6475E+00,2.2065E+00,1.7650E+00,1.3239E+00,
     &8.8260E-01,4.4141E-01,4.8300E-01/
      DATA ((KA(JS,JT, 5,16),JS=1,9),JT=1,5) /
     &3.8226E+00,3.3446E+00,2.8509E+00,2.3892E+00,1.9114E+00,1.4335E+00,
     &9.5565E-01,4.7787E-01,1.1560E-01,4.7529E+00,4.1589E+00,3.5644E+00,
     &2.9706E+00,2.3763E+00,1.7823E+00,1.1883E+00,5.9413E-01,1.7922E-01,
     &5.7385E+00,5.0213E+00,4.3040E+00,3.5869E+00,2.8697E+00,2.1522E+00,
     &1.4347E+00,7.1742E-01,2.6311E-01,6.7615E+00,5.9164E+00,5.0713E+00,
     &4.2261E+00,3.3806E+00,2.5357E+00,1.6905E+00,8.4524E-01,3.6914E-01,
     &7.8020E+00,6.8269E+00,5.8507E+00,4.8765E+00,3.9008E+00,2.9261E+00,
     &1.9507E+00,9.7534E-01,4.9832E-01/
      DATA ((KA(JS,JT, 6,16),JS=1,9),JT=1,5) /
     &7.3571E+00,6.4369E+00,5.5172E+00,4.5985E+00,3.6783E+00,2.7589E+00,
     &1.8291E+00,9.1965E-01,1.0645E-01,9.3468E+00,8.1778E+00,7.0095E+00,
     &5.8414E+00,4.6732E+00,3.5051E+00,2.3366E+00,1.1682E+00,1.6617E-01,
     &1.1491E+01,1.0055E+01,8.6175E+00,7.1820E+00,5.7127E+00,4.3090E+00,
     &2.8724E+00,1.4282E+00,2.5233E-01,1.3744E+01,1.2025E+01,1.0308E+01,
     &8.5898E+00,6.8725E+00,5.1546E+00,3.4361E+00,1.7180E+00,3.6410E-01,
     &1.6063E+01,1.4056E+01,1.2048E+01,1.0040E+01,8.0325E+00,6.0238E+00,
     &4.0162E+00,2.0081E+00,5.0340E-01/
      DATA ((KA(JS,JT, 7,16),JS=1,9),JT=1,5) /
     &1.4766E+01,1.2923E+01,1.1075E+01,9.2294E+00,7.3836E+00,5.5378E+00,
     &3.6915E+00,1.8460E+00,1.0988E-01,1.9210E+01,1.6809E+01,1.4406E+01,
     &1.2004E+01,9.6049E+00,7.2040E+00,4.8023E+00,2.4010E+00,1.5119E-01,
     &2.4080E+01,2.1071E+01,1.8060E+01,1.5050E+01,1.2042E+01,9.0305E+00,
     &6.0199E+00,2.9934E+00,2.3822E-01,2.9278E+01,2.5619E+01,2.1957E+01,
     &1.8300E+01,1.4640E+01,1.0980E+01,7.3208E+00,3.6596E+00,3.5444E-01,
     &3.4690E+01,3.0352E+01,2.6017E+01,2.1683E+01,1.7349E+01,1.3009E+01,
     &8.6734E+00,4.3366E+00,5.0281E-01/
      DATA ((KA(JS,JT, 8,16),JS=1,9),JT=1,5) /
     &3.5305E+01,3.0898E+01,2.6479E+01,2.2066E+01,1.7653E+01,1.3237E+01,
     &8.8267E+00,4.4136E+00,1.1225E-01,4.7105E+01,4.1217E+01,3.5327E+01,
     &2.9443E+01,2.3551E+01,1.7664E+01,1.1776E+01,5.8880E+00,1.4909E-01,
     &6.0289E+01,5.2760E+01,4.5222E+01,3.7680E+01,3.0141E+01,2.2609E+01,
     &1.5075E+01,7.5364E+00,2.2235E-01,7.4572E+01,6.4882E+01,5.5930E+01,
     &4.6614E+01,3.7287E+01,2.7965E+01,1.8642E+01,9.3209E+00,3.4182E-01,
     &8.9645E+01,7.8444E+01,6.7227E+01,5.6021E+01,4.4815E+01,3.3612E+01,
     &2.2408E+01,1.1205E+01,4.9824E-01/
      DATA ((KA(JS,JT, 9,16),JS=1,9),JT=1,5) /
     &1.5759E+02,1.3788E+02,1.1817E+02,9.8475E+01,7.8796E+01,5.9083E+01,
     &3.9390E+01,1.9699E+01,1.1304E-01,2.1616E+02,1.8914E+02,1.6212E+02,
     &1.3510E+02,1.0808E+02,8.1068E+01,5.4043E+01,2.7021E+01,1.5445E-01,
     &2.8258E+02,2.4760E+02,2.1223E+02,1.7686E+02,1.4149E+02,1.0611E+02,
     &7.0744E+01,3.5373E+01,2.0441E-01,3.5653E+02,3.1192E+02,2.6735E+02,
     &2.2280E+02,1.7825E+02,1.3369E+02,8.9123E+01,4.4565E+01,3.2503E-01,
     &4.3513E+02,3.8075E+02,3.2632E+02,2.7197E+02,2.1754E+02,1.6316E+02,
     &1.0877E+02,5.4390E+01,4.8785E-01/
      DATA ((KA(JS,JT,10,16),JS=1,9),JT=1,5) /
     &7.9828E+02,6.9859E+02,5.9871E+02,4.9899E+02,3.9914E+02,2.9935E+02,
     &1.9957E+02,9.9786E+01,1.4112E-06,1.1235E+03,9.8329E+02,8.4282E+02,
     &7.0236E+02,5.6188E+02,4.2131E+02,2.8094E+02,1.4047E+02,1.8812E-06,
     &1.5014E+03,1.3138E+03,1.1261E+03,9.3840E+02,7.5072E+02,5.6311E+02,
     &3.7536E+02,1.8771E+02,2.5472E-06,1.9233E+03,1.6832E+03,1.4427E+03,
     &1.2020E+03,9.6160E+02,7.2135E+02,4.8081E+02,2.4039E+02,3.1592E-01,
     &2.3793E+03,2.0824E+03,1.7849E+03,1.4876E+03,1.1900E+03,8.9243E+02,
     &5.9503E+02,2.9747E+02,4.8703E-01/
      DATA ((KA(JS,JT,11,16),JS=1,9),JT=1,5) /
     &1.6695E+03,1.4608E+03,1.2521E+03,1.0434E+03,8.3472E+02,6.2605E+02,
     &4.1737E+02,2.0867E+02,1.1529E-06,2.3476E+03,2.0540E+03,1.7608E+03,
     &1.4673E+03,1.1739E+03,8.8029E+02,5.8691E+02,2.9349E+02,1.5382E-06,
     &3.1326E+03,2.7416E+03,2.3500E+03,1.9579E+03,1.5664E+03,1.1749E+03,
     &7.8334E+02,3.9162E+02,2.0823E-06,4.0087E+03,3.5076E+03,3.0065E+03,
     &2.5054E+03,2.0043E+03,1.5033E+03,1.0022E+03,5.0110E+02,2.4008E-06,
     &4.9540E+03,4.3346E+03,3.7151E+03,3.0963E+03,2.4766E+03,1.8577E+03,
     &1.2385E+03,6.1917E+02,1.3302E-05/
      DATA ((KA(JS,JT,12,16),JS=1,9),JT=1,5) /
     &2.5940E+03,2.2689E+03,1.9455E+03,1.6210E+03,1.2970E+03,9.7271E+02,
     &6.4849E+02,3.2418E+02,9.4397E-07,3.6401E+03,3.1850E+03,2.7301E+03,
     &2.2751E+03,1.8200E+03,1.3650E+03,9.1001E+02,4.5497E+02,1.2594E-06,
     &4.8482E+03,4.2436E+03,3.6368E+03,3.0301E+03,2.4250E+03,1.8187E+03,
     &1.2120E+03,6.0606E+02,1.2513E-05,6.1914E+03,5.4187E+03,4.6435E+03,
     &3.8696E+03,3.0964E+03,2.3220E+03,1.5479E+03,7.7403E+02,2.0845E-05,
     &7.6366E+03,6.6419E+03,5.7257E+03,4.7728E+03,3.8188E+03,2.8637E+03,
     &1.9092E+03,9.4962E+02,2.1463E-05/
      DATA ((KA(JS,JT,13,16),JS=1,9),JT=1,5) /
     &3.2192E+03,2.8160E+03,2.4141E+03,2.0117E+03,1.6091E+03,1.2070E+03,
     &8.0460E+02,4.0235E+02,2.5866E-06,4.5059E+03,3.9428E+03,3.3791E+03,
     &2.8160E+03,2.2531E+03,1.6897E+03,1.1264E+03,5.6328E+02,9.4719E-06,
     &5.9881E+03,5.2388E+03,4.4907E+03,3.7423E+03,2.9935E+03,2.2450E+03,
     &1.4968E+03,7.4841E+02,1.6561E-05,7.6265E+03,6.6729E+03,5.7200E+03,
     &4.7671E+03,3.8133E+03,2.8600E+03,1.9066E+03,9.4757E+02,2.1537E-05,
     &9.3827E+03,8.2086E+03,7.0366E+03,5.8639E+03,4.6917E+03,3.5181E+03,
     &2.3456E+03,1.1729E+03,2.1283E-05/

C     The array KB contains absorption coefs for each of the 16 g-intervals
C     for a range of pressure levels  < ~100mb, temperatures, and ratios
C     of H2O to CO2.  The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.  The second index, JT, which
C     runs from 1 to 5, corresponds to different temperatures.  More 
C     specifically, JT = 3 means that the data are for the corresponding 
C     reference temperature TREF for this  pressure level, JT = 2 refers 
C     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
C     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
C     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
C     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
C     16, and tells us which g-interval the absorption coefficients are for.

      DATA ((KB(JS,JT,13, 1),JS=1,5),JT=1,5) /
     &1.5731E-03,1.8696E-03,1.8486E-03,1.7186E-03,1.3898E-03,
     &1.8623E-03,2.3963E-03,2.4362E-03,2.2990E-03,1.8223E-03,
     &2.3718E-03,3.1878E-03,3.2540E-03,3.0430E-03,2.2915E-03,
     &3.1921E-03,4.3104E-03,4.3590E-03,3.9821E-03,2.7709E-03,
     &4.4313E-03,5.8691E-03,5.8118E-03,5.1528E-03,3.2426E-03/
      DATA ((KB(JS,JT,14, 1),JS=1,5),JT=1,5) /
     &8.1496E-04,1.1449E-03,1.2521E-03,1.2864E-03,1.1830E-03,
     &9.7291E-04,1.4990E-03,1.6700E-03,1.7215E-03,1.5434E-03,
     &1.2487E-03,2.0089E-03,2.2296E-03,2.2624E-03,1.9289E-03,
     &1.6881E-03,2.7166E-03,2.9639E-03,2.9248E-03,2.3207E-03,
     &2.3524E-03,3.6802E-03,3.9082E-03,3.7262E-03,2.7008E-03/
      DATA ((KB(JS,JT,15, 1),JS=1,5),JT=1,5) /
     &4.3177E-04,7.4258E-04,8.9651E-04,1.0013E-03,1.0098E-03,
     &5.2028E-04,9.8643E-04,1.2013E-03,1.3351E-03,1.3087E-03,
     &6.7289E-04,1.3258E-03,1.5978E-03,1.7375E-03,1.6233E-03,
     &9.1389E-04,1.7863E-03,2.1013E-03,2.2138E-03,1.9402E-03,
     &1.2783E-03,2.4005E-03,2.7322E-03,2.7722E-03,2.2422E-03/
      DATA ((KB(JS,JT,16, 1),JS=1,5),JT=1,5) /
     &2.7315E-04,5.4830E-04,7.0218E-04,8.1997E-04,8.6240E-04,
     &3.3240E-04,7.3351E-04,9.4112E-04,1.0872E-03,1.1098E-03,
     &4.3314E-04,9.8584E-04,1.2457E-03,1.4034E-03,1.3664E-03,
     &5.9092E-04,1.3229E-03,1.6223E-03,1.7684E-03,1.6211E-03,
     &8.2878E-04,1.7642E-03,2.0878E-03,2.1890E-03,1.8647E-03/
      DATA ((KB(JS,JT,17, 1),JS=1,5),JT=1,5) /
     &1.7965E-04,4.1801E-04,5.6155E-04,6.7756E-04,7.3362E-04,
     &2.2058E-04,5.6121E-04,7.5064E-04,8.9254E-04,9.3681E-04,
     &2.8939E-04,7.5257E-04,9.8597E-04,1.1419E-03,1.1452E-03,
     &3.9639E-04,1.0037E-03,1.2718E-03,1.4256E-03,1.3514E-03,
     &5.5678E-04,1.3263E-03,1.6209E-03,1.7480E-03,1.5479E-03/
      DATA ((KB(JS,JT,18, 1),JS=1,5),JT=1,5) /
     &1.2144E-04,3.2556E-04,4.5465E-04,5.6224E-04,6.2157E-04,
     &1.5036E-04,4.3710E-04,6.0499E-04,7.3530E-04,7.8763E-04,
     &1.9855E-04,5.8365E-04,7.8791E-04,9.3325E-04,9.5745E-04,
     &2.7288E-04,7.7253E-04,1.0079E-03,1.1563E-03,1.1247E-03,
     &3.8348E-04,1.0128E-03,1.2724E-03,1.4068E-03,1.2838E-03/
      DATA ((KB(JS,JT,19, 1),JS=1,5),JT=1,5) /
     &8.0908E-05,2.5355E-04,3.6780E-04,4.6534E-04,5.2420E-04,
     &1.0097E-04,3.3963E-04,4.8637E-04,6.0408E-04,6.5997E-04,
     &1.3403E-04,4.5064E-04,6.2806E-04,7.6126E-04,7.9854E-04,
     &1.8471E-04,5.9188E-04,7.9637E-04,9.3587E-04,9.3436E-04,
     &2.5970E-04,7.6935E-04,9.9605E-04,1.1301E-03,1.0631E-03/
      DATA ((KB(JS,JT,20, 1),JS=1,5),JT=1,5) /
     &5.8651E-05,2.0533E-04,3.0468E-04,3.8991E-04,4.4299E-04,
     &7.3858E-05,2.7425E-04,4.0056E-04,5.0325E-04,5.5439E-04,
     &9.8558E-05,3.6201E-04,5.1389E-04,6.3043E-04,6.6745E-04,
     &1.3624E-04,4.7289E-04,6.4732E-04,7.7044E-04,7.7770E-04,
     &1.9168E-04,6.1111E-04,8.0443E-04,9.2550E-04,8.8213E-04/
      DATA ((KB(JS,JT,21, 1),JS=1,5),JT=1,5) /
     &4.3969E-05,1.6839E-04,2.5404E-04,3.2750E-04,3.7386E-04,
     &5.5807E-05,2.2425E-04,3.3214E-04,4.2065E-04,4.6519E-04,
     &7.4871E-05,2.9470E-04,4.2375E-04,5.2400E-04,5.5744E-04,
     &1.0381E-04,3.8330E-04,5.3089E-04,6.3750E-04,6.4727E-04,
     &1.4611E-04,4.9243E-04,6.5637E-04,7.6218E-04,7.3199E-04/
      DATA ((KB(JS,JT,22, 1),JS=1,5),JT=1,5) /
     &3.4337E-05,1.4203E-04,2.1658E-04,2.8040E-04,3.2005E-04,
     &4.4095E-05,1.8845E-04,2.8132E-04,3.5774E-04,3.9514E-04,
     &5.9627E-05,2.4659E-04,3.5661E-04,4.4266E-04,4.7049E-04,
     &8.3001E-05,3.1905E-04,4.4430E-04,5.3537E-04,5.4306E-04,
     &1.1688E-04,4.0732E-04,5.4669E-04,6.3703E-04,6.1162E-04/
      DATA ((KB(JS,JT,23, 1),JS=1,5),JT=1,5) /
     &2.7088E-05,1.2024E-04,1.8486E-04,2.4028E-04,2.7381E-04,
     &3.5182E-05,1.5885E-04,2.3849E-04,3.0423E-04,3.3547E-04,
     &4.7910E-05,2.0687E-04,3.0043E-04,3.7399E-04,3.9686E-04,
     &6.6975E-05,2.6613E-04,3.7259E-04,4.4994E-04,4.5570E-04,
     &9.4305E-05,3.3770E-04,4.5596E-04,5.3292E-04,5.1097E-04/
      DATA ((KB(JS,JT,24, 1),JS=1,5),JT=1,5) /
     &2.1382E-05,1.0191E-04,1.5778E-04,2.0583E-04,2.3424E-04,
     &2.8085E-05,1.3391E-04,2.0214E-04,2.5863E-04,2.8484E-04,
     &3.8505E-05,1.7343E-04,2.5313E-04,3.1592E-04,3.3477E-04,
     &5.3997E-05,2.2171E-04,3.1228E-04,3.7804E-04,3.8231E-04,
     &7.5953E-05,2.7966E-04,3.7978E-04,4.4568E-04,4.2681E-04/
      DATA ((KB(JS,JT,25, 1),JS=1,5),JT=1,5) /
     &1.7217E-05,8.6935E-05,1.3520E-04,1.7667E-04,2.0051E-04,
     &2.2860E-05,1.1361E-04,1.7201E-04,2.2028E-04,2.4198E-04,
     &3.1540E-05,1.4632E-04,2.1426E-04,2.6745E-04,2.8247E-04,
     &4.4330E-05,1.8594E-04,2.6272E-04,3.1846E-04,3.2089E-04,
     &6.2260E-05,2.3327E-04,3.1770E-04,3.7373E-04,3.5666E-04/
      DATA ((KB(JS,JT,26, 1),JS=1,5),JT=1,5) /
     &1.4222E-05,7.4853E-05,1.1659E-04,1.5229E-04,1.7205E-04,
     &1.9097E-05,9.7290E-05,1.4733E-04,1.8840E-04,2.0595E-04,
     &2.6498E-05,1.2462E-04,1.8247E-04,2.2740E-04,2.3871E-04,
     &3.7304E-05,1.5749E-04,2.2244E-04,2.6950E-04,2.6966E-04,
     &5.2263E-05,1.9669E-04,2.6764E-04,3.1472E-04,2.9848E-04/
      DATA ((KB(JS,JT,27, 1),JS=1,5),JT=1,5) /
     &1.2263E-05,6.5144E-05,1.0108E-04,1.3156E-04,1.4744E-04,
     &1.6644E-05,8.4290E-05,1.2696E-04,1.6163E-04,1.7509E-04,
     &2.3202E-05,1.0755E-04,1.5651E-04,1.9419E-04,2.0159E-04,
     &3.2669E-05,1.3540E-04,1.9003E-04,2.2917E-04,2.2657E-04,
     &4.5636E-05,1.6849E-04,2.2778E-04,2.6648E-04,2.4966E-04/
      DATA ((KB(JS,JT,28, 1),JS=1,5),JT=1,5) /
     &1.0907E-05,5.7118E-05,8.7946E-05,1.1378E-04,1.2622E-04,
     &1.4925E-05,7.3661E-05,1.0996E-04,1.3907E-04,1.4872E-04,
     &2.0909E-05,9.3671E-05,1.3497E-04,1.6629E-04,1.7014E-04,
     &2.9425E-05,1.1761E-04,1.6330E-04,1.9540E-04,1.9022E-04,
     &4.0966E-05,1.4604E-04,1.9535E-04,2.2654E-04,2.0877E-04/
      DATA ((KB(JS,JT,29, 1),JS=1,5),JT=1,5) /
     &1.0363E-05,5.1128E-05,7.7457E-05,9.9099E-05,1.0807E-04,
     &1.4287E-05,6.5810E-05,9.6485E-05,1.2056E-04,1.2631E-04,
     &2.0078E-05,8.3622E-05,1.1822E-04,1.4364E-04,1.4366E-04,
     &2.8213E-05,1.0495E-04,1.4288E-04,1.6839E-04,1.5982E-04,
     &3.9150E-05,1.3025E-04,1.7086E-04,1.9491E-04,1.7468E-04/
      DATA ((KB(JS,JT,30, 1),JS=1,5),JT=1,5) /
     &1.0130E-05,4.6183E-05,6.8547E-05,8.6516E-05,9.2360E-05,
     &1.4060E-05,5.9445E-05,8.5241E-05,1.0481E-04,1.0719E-04,
     &1.9789E-05,7.5542E-05,1.0433E-04,1.2454E-04,1.2117E-04,
     &2.7737E-05,9.4871E-05,1.2613E-04,1.4578E-04,1.3421E-04,
     &3.8345E-05,1.1778E-04,1.5088E-04,1.6869E-04,1.4612E-04/
      DATA ((KB(JS,JT,31, 1),JS=1,5),JT=1,5) /
     &1.0468E-05,4.2679E-05,6.1533E-05,7.6101E-05,7.8936E-05,
     &1.4602E-05,5.5015E-05,7.6472E-05,9.1912E-05,9.0925E-05,
     &2.0565E-05,7.0045E-05,9.3754E-05,1.0914E-04,1.0226E-04,
     &2.8741E-05,8.8177E-05,1.1361E-04,1.2783E-04,1.1277E-04,
     &3.9551E-05,1.0965E-04,1.3625E-04,1.4816E-04,1.2240E-04/
      DATA ((KB(JS,JT,32, 1),JS=1,5),JT=1,5) /
     &1.0980E-05,3.9860E-05,5.5596E-05,6.7154E-05,6.7396E-05,
     &1.5378E-05,5.1481E-05,6.9207E-05,8.1024E-05,7.7105E-05,
     &2.1641E-05,6.5723E-05,8.5005E-05,9.6172E-05,8.6258E-05,
     &3.0131E-05,8.2891E-05,1.0329E-04,1.1283E-04,9.4767E-05,
     &4.1276E-05,1.0326E-04,1.2427E-04,1.3104E-04,1.0241E-04/
      DATA ((KB(JS,JT,33, 1),JS=1,5),JT=1,5) /
     &1.1748E-05,3.7749E-05,5.0777E-05,5.9616E-05,5.7446E-05,
     &1.6501E-05,4.8915E-05,6.3363E-05,7.1901E-05,6.5353E-05,
     &2.3188E-05,6.2624E-05,7.8070E-05,8.5481E-05,7.2776E-05,
     &3.2156E-05,7.9179E-05,9.5194E-05,1.0052E-04,7.9571E-05,
     &4.3815E-05,9.8786E-05,1.1493E-04,1.1713E-04,8.5692E-05/
      DATA ((KB(JS,JT,34, 1),JS=1,5),JT=1,5) /
     &1.2122E-05,3.5250E-05,4.5906E-05,5.2480E-05,4.8658E-05,
     &1.7058E-05,4.5800E-05,5.7395E-05,6.3326E-05,5.5101E-05,
     &2.3918E-05,5.8762E-05,7.0946E-05,7.5460E-05,6.1101E-05,
     &3.3054E-05,7.4431E-05,8.6803E-05,8.8957E-05,6.6540E-05,
     &4.4827E-05,9.2907E-05,1.0510E-04,1.0393E-04,7.1470E-05/
      DATA ((KB(JS,JT,35, 1),JS=1,5),JT=1,5) /
     &1.2136E-05,3.2274E-05,4.0784E-05,4.5493E-05,4.0671E-05,
     &1.7085E-05,4.2082E-05,5.1198E-05,5.5056E-05,4.5918E-05,
     &2.3916E-05,5.4183E-05,6.3553E-05,6.5795E-05,5.0794E-05,
     &3.2983E-05,6.8784E-05,7.8061E-05,7.7848E-05,5.5215E-05,
     &4.4608E-05,8.5962E-05,9.4799E-05,9.1316E-05,5.9185E-05/
      DATA ((KB(JS,JT,36, 1),JS=1,5),JT=1,5) /
     &1.1639E-05,2.8710E-05,3.5389E-05,3.8647E-05,3.3496E-05,
     &1.6387E-05,3.7611E-05,4.4660E-05,4.6982E-05,3.7819E-05,
     &2.2931E-05,4.8613E-05,5.5727E-05,5.6405E-05,4.1793E-05,
     &3.1614E-05,6.1937E-05,6.8745E-05,6.7054E-05,4.5416E-05,
     &4.2736E-05,7.7667E-05,8.3834E-05,7.9002E-05,4.8700E-05/
      DATA ((KB(JS,JT,37, 1),JS=1,5),JT=1,5) /
     &1.0334E-05,2.4228E-05,2.9412E-05,3.1719E-05,2.7018E-05,
     &1.4545E-05,3.1907E-05,3.7329E-05,3.8760E-05,3.0586E-05,
     &2.0385E-05,4.1462E-05,4.6849E-05,4.6806E-05,3.3891E-05,
     &2.8167E-05,5.3075E-05,5.8122E-05,5.5962E-05,3.6915E-05,
     &3.8188E-05,6.6903E-05,7.1250E-05,6.6274E-05,3.9679E-05/
      DATA ((KB(JS,JT,38, 1),JS=1,5),JT=1,5) /
     &9.2873E-06,2.0587E-05,2.4545E-05,2.6080E-05,2.1759E-05,
     &1.3062E-05,2.7262E-05,3.1359E-05,3.2085E-05,2.4714E-05,
     &1.8340E-05,3.5628E-05,3.9617E-05,3.8992E-05,2.7465E-05,
     &2.5394E-05,4.5875E-05,4.9461E-05,4.6884E-05,2.9998E-05,
     &3.4528E-05,5.8131E-05,6.0967E-05,5.5861E-05,3.2334E-05/
      DATA ((KB(JS,JT,39, 1),JS=1,5),JT=1,5) /
     &8.5453E-06,1.7761E-05,2.0713E-05,2.1598E-05,1.7527E-05,
     &1.2008E-05,2.3655E-05,2.6655E-05,2.6765E-05,1.9983E-05,
     &1.6881E-05,3.1100E-05,3.3909E-05,3.2745E-05,2.2276E-05,
     &2.3421E-05,4.0278E-05,4.2620E-05,3.9657E-05,2.4422E-05,
     &3.1935E-05,5.1364E-05,5.2889E-05,4.7569E-05,2.6373E-05/
      DATA ((KB(JS,JT,40, 1),JS=1,5),JT=1,5) /
     &7.1461E-06,1.4361E-05,1.6604E-05,1.7207E-05,1.3880E-05,
     &1.0009E-05,1.9228E-05,2.1496E-05,2.1462E-05,1.5923E-05,
     &1.4089E-05,2.5420E-05,2.7521E-05,2.6424E-05,1.7845E-05,
     &1.9620E-05,3.3119E-05,3.4800E-05,3.2193E-05,1.9645E-05,
     &2.6885E-05,4.2499E-05,4.3444E-05,3.8836E-05,2.1269E-05/
      DATA ((KB(JS,JT,41, 1),JS=1,5),JT=1,5) /
     &5.9442E-06,1.1549E-05,1.3242E-05,1.3641E-05,1.0951E-05,
     &8.2890E-06,1.5538E-05,1.7245E-05,1.7129E-05,1.2647E-05,
     &1.1675E-05,2.0658E-05,2.2220E-05,2.1226E-05,1.4267E-05,
     &1.6317E-05,2.7083E-05,2.8276E-05,2.6013E-05,1.5751E-05,
     &2.2462E-05,3.4966E-05,3.5519E-05,3.1566E-05,1.7118E-05/
      DATA ((KB(JS,JT,42, 1),JS=1,5),JT=1,5) /
     &5.0039E-06,9.3487E-06,1.0601E-05,1.0831E-05,8.6234E-06,
     &6.9419E-06,1.2631E-05,1.3888E-05,1.3698E-05,1.0034E-05,
     &9.7739E-06,1.6890E-05,1.8015E-05,1.7096E-05,1.1383E-05,
     &1.3702E-05,2.2284E-05,2.3078E-05,2.1084E-05,1.2617E-05,
     &1.8946E-05,2.8958E-05,2.9188E-05,2.5746E-05,1.3767E-05/
      DATA ((KB(JS,JT,43, 1),JS=1,5),JT=1,5) /
     &4.1873E-06,7.4795E-06,8.3830E-06,8.4906E-06,6.7096E-06,
     &5.7609E-06,1.0144E-05,1.1051E-05,1.0826E-05,7.8872E-06,
     &8.0947E-06,1.3657E-05,1.4441E-05,1.3617E-05,9.0007E-06,
     &1.1379E-05,1.8143E-05,1.8645E-05,1.6928E-05,1.0041E-05,
     &1.5813E-05,2.3749E-05,2.3760E-05,2.0820E-05,1.1010E-05/
      DATA ((KB(JS,JT,44, 1),JS=1,5),JT=1,5) /
     &3.5435E-06,5.9971E-06,6.6151E-06,6.6257E-06,5.1813E-06,
     &4.8184E-06,8.1565E-06,8.7802E-06,8.5231E-06,6.1554E-06,
     &6.7381E-06,1.1044E-05,1.1560E-05,1.0814E-05,7.0815E-06,
     &9.4910E-06,1.4784E-05,1.5050E-05,1.3555E-05,7.9532E-06,
     &1.3248E-05,1.9506E-05,1.9344E-05,1.6815E-05,8.7723E-06/
      DATA ((KB(JS,JT,45, 1),JS=1,5),JT=1,5) /
     &3.0781E-06,4.8864E-06,5.2730E-06,5.1910E-06,3.9885E-06,
     &4.1281E-06,6.6470E-06,7.0382E-06,6.7401E-06,4.7888E-06,
     &5.7272E-06,9.0419E-06,9.3373E-06,8.6331E-06,5.5575E-06,
     &8.0675E-06,1.2195E-05,1.2269E-05,1.0924E-05,6.2888E-06,
     &1.1304E-05,1.6230E-05,1.5911E-05,1.3670E-05,6.9809E-06/
      DATA ((KB(JS,JT,46, 1),JS=1,5),JT=1,5) /
     &2.7031E-06,4.0051E-06,4.2052E-06,4.0513E-06,3.0391E-06,
     &3.5629E-06,5.4291E-06,5.6384E-06,5.3109E-06,3.6957E-06,
     &4.8917E-06,7.4052E-06,7.5318E-06,6.8686E-06,4.3368E-06,
     &6.8735E-06,1.0056E-05,9.9863E-06,8.7795E-06,4.9486E-06,
     &9.6601E-06,1.3493E-05,1.3073E-05,1.1090E-05,5.5328E-06/
      DATA ((KB(JS,JT,47, 1),JS=1,5),JT=1,5) /
     &2.3513E-06,3.2459E-06,3.3109E-06,3.1126E-06,2.2809E-06,
     &3.0285E-06,4.3632E-06,4.4435E-06,4.1169E-06,2.8160E-06,
     &4.0963E-06,5.9519E-06,5.9675E-06,5.3774E-06,3.3494E-06,
     &5.7200E-06,8.1250E-06,7.9789E-06,6.9425E-06,3.8611E-06,
     &8.0548E-06,1.0990E-05,1.0545E-05,8.8570E-06,4.3522E-06/
      DATA ((KB(JS,JT,48, 1),JS=1,5),JT=1,5) /
     &2.1277E-06,2.7115E-06,2.6627E-06,2.4165E-06,1.7021E-06,
     &2.6703E-06,3.5982E-06,3.5641E-06,3.2218E-06,2.1347E-06,
     &3.5476E-06,4.8904E-06,4.8030E-06,4.2482E-06,2.5746E-06,
     &4.9045E-06,6.6952E-06,6.4687E-06,5.5412E-06,3.0044E-06,
     &6.9032E-06,9.1233E-06,8.6345E-06,7.1468E-06,3.4162E-06/
      DATA ((KB(JS,JT,49, 1),JS=1,5),JT=1,5) /
     &2.0328E-06,2.3718E-06,2.2199E-06,1.9157E-06,1.2610E-06,
     &2.4767E-06,3.0887E-06,2.9459E-06,2.5646E-06,1.6091E-06,
     &3.2245E-06,4.1594E-06,3.9687E-06,3.4109E-06,1.9688E-06,
     &4.3950E-06,5.6964E-06,5.3766E-06,4.4963E-06,2.3270E-06,
     &6.1628E-06,7.8088E-06,7.2467E-06,5.8704E-06,2.6722E-06/
      DATA ((KB(JS,JT,50, 1),JS=1,5),JT=1,5) /
     &1.8800E-06,2.0468E-06,1.8384E-06,1.5142E-06,9.3123E-07,
     &2.2261E-06,2.6068E-06,2.4062E-06,2.0250E-06,1.2100E-06,
     &2.8323E-06,3.4659E-06,3.2264E-06,2.7071E-06,1.5035E-06,
     &3.7999E-06,4.7249E-06,4.3788E-06,3.5953E-06,1.7997E-06,
     &5.2884E-06,6.4943E-06,5.9393E-06,4.7367E-06,2.0882E-06/
      DATA ((KB(JS,JT,51, 1),JS=1,5),JT=1,5) /
     &1.7210E-06,1.7678E-06,1.5277E-06,1.2003E-06,6.8440E-07,
     &1.9818E-06,2.1939E-06,1.9638E-06,1.5963E-06,9.0698E-07,
     &2.4588E-06,2.8718E-06,2.6104E-06,2.1370E-06,1.1441E-06,
     &3.2428E-06,3.8817E-06,3.5358E-06,2.8541E-06,1.3878E-06,
     &4.4645E-06,5.3335E-06,4.8140E-06,3.7885E-06,1.6275E-06/
      DATA ((KB(JS,JT,52, 1),JS=1,5),JT=1,5) /
     &1.6367E-06,1.5882E-06,1.3178E-06,9.7791E-07,4.9920E-07,
     &1.8355E-06,1.9143E-06,1.6527E-06,1.2853E-06,6.7537E-07,
     &2.2162E-06,2.4540E-06,2.1676E-06,1.7156E-06,8.6642E-07,
     &2.8651E-06,3.2774E-06,2.9188E-06,2.2996E-06,1.0660E-06,
     &3.8903E-06,4.4871E-06,3.9803E-06,3.0728E-06,1.2649E-06/
      DATA ((KB(JS,JT,53, 1),JS=1,5),JT=1,5) /
     &1.6359E-06,1.5065E-06,1.1971E-06,8.3215E-07,3.6108E-07,
     &1.7884E-06,1.7570E-06,1.4552E-06,1.0704E-06,4.9954E-07,
     &2.1010E-06,2.1926E-06,1.8706E-06,1.4156E-06,6.5257E-07,
     &2.6543E-06,2.8821E-06,2.4935E-06,1.8975E-06,8.1519E-07,
     &3.5462E-06,3.9143E-06,3.3945E-06,2.5503E-06,9.8011E-07/
      DATA ((KB(JS,JT,54, 1),JS=1,5),JT=1,5) /
     &1.4300E-06,1.2802E-06,9.9257E-07,6.6497E-07,2.6129E-07,
     &1.5262E-06,1.4508E-06,1.1768E-06,8.3958E-07,3.6958E-07,
     &1.7484E-06,1.7685E-06,1.4827E-06,1.0992E-06,4.9169E-07,
     &2.1569E-06,2.2883E-06,1.9539E-06,1.4679E-06,6.2244E-07,
     &2.8354E-06,3.0764E-06,2.6455E-06,1.9748E-06,7.5773E-07/
      DATA ((KB(JS,JT,55, 1),JS=1,5),JT=1,5) /
     &1.1496E-06,1.0107E-06,7.7300E-07,5.0639E-07,1.8790E-07,
     &1.1995E-06,1.1187E-06,8.9719E-07,6.3009E-07,2.7269E-07,
     &1.3422E-06,1.3346E-06,1.1096E-06,8.1740E-07,3.6933E-07,
     &1.6169E-06,1.6973E-06,1.4454E-06,1.0866E-06,4.7429E-07,
     &2.0871E-06,2.2587E-06,1.9432E-06,1.4592E-06,5.8406E-07/
      DATA ((KB(JS,JT,56, 1),JS=1,5),JT=1,5) /
     &9.3098E-07,8.0374E-07,6.0662E-07,3.8780E-07,1.3395E-07,
     &9.4853E-07,8.6979E-07,6.8824E-07,4.7493E-07,1.9978E-07,
     &1.0383E-06,1.0136E-06,8.3527E-07,6.0949E-07,2.7592E-07,
     &1.2210E-06,1.2652E-06,1.0730E-06,8.0519E-07,3.6001E-07,
     &1.5443E-06,1.6630E-06,1.4302E-06,1.0789E-06,4.4877E-07/
      DATA ((KB(JS,JT,57, 1),JS=1,5),JT=1,5) /
     &7.5869E-07,6.4433E-07,4.7913E-07,2.9908E-07,9.4559E-08,
     &7.5680E-07,6.8154E-07,5.3140E-07,3.5955E-07,1.4504E-07,
     &8.0958E-07,7.7512E-07,6.3252E-07,4.5567E-07,2.0501E-07,
     &9.2953E-07,9.4815E-07,7.9932E-07,5.9759E-07,2.7208E-07,
     &1.1491E-06,1.2288E-06,1.0552E-06,7.9844E-07,3.4355E-07/
      DATA ((KB(JS,JT,58, 1),JS=1,5),JT=1,5) /
     &1.6388E-07,1.6804E-07,1.5881E-07,1.3627E-07,6.6479E-08,
     &1.6042E-07,1.7409E-07,1.7274E-07,1.6106E-07,1.0511E-07,
     &1.6792E-07,1.9377E-07,2.0193E-07,2.0193E-07,1.5191E-07,
     &1.8861E-07,2.3235E-07,2.5117E-07,2.6306E-07,2.0537E-07,
     &2.2793E-07,2.9684E-07,3.2824E-07,3.5018E-07,2.6292E-07/
      DATA ((KB(JS,JT,59, 1),JS=1,5),JT=1,5) /
     &1.5765E-07,1.5618E-07,1.3958E-07,1.1007E-07,5.0739E-08,
     &1.5325E-07,1.6219E-07,1.5348E-07,1.3308E-07,8.1077E-08,
     &1.5900E-07,1.8099E-07,1.8121E-07,1.6979E-07,1.1831E-07,
     &1.7701E-07,2.1714E-07,2.2693E-07,2.2335E-07,1.6137E-07,
     &2.1198E-07,2.7749E-07,2.9703E-07,2.9803E-07,2.0840E-07/
      DATA ((KB(JS,JT,13, 2),JS=1,5),JT=1,5) /
     &3.6279E-03,6.1760E-03,7.4137E-03,8.1756E-03,7.6678E-03,
     &4.7275E-03,8.3099E-03,9.8779E-03,1.0590E-02,9.2190E-03,
     &6.7817E-03,1.1546E-02,1.3324E-02,1.3748E-02,1.0778E-02,
     &1.0391E-02,1.6290E-02,1.8048E-02,1.7786E-02,1.2299E-02,
     &1.6231E-02,2.2973E-02,2.4369E-02,2.2866E-02,1.3775E-02/
      DATA ((KB(JS,JT,14, 2),JS=1,5),JT=1,5) /
     &1.9069E-03,4.2185E-03,5.5573E-03,6.5712E-03,6.6234E-03,
     &2.5180E-03,5.7108E-03,7.3682E-03,8.4311E-03,7.9352E-03,
     &3.6614E-03,7.8938E-03,9.8216E-03,1.0792E-02,9.2480E-03,
     &5.6530E-03,1.1002E-02,1.3072E-02,1.3740E-02,1.0517E-02,
     &8.8619E-03,1.5292E-02,1.7338E-02,1.7343E-02,1.1731E-02/
      DATA ((KB(JS,JT,15, 2),JS=1,5),JT=1,5) /
     &1.0269E-03,3.0313E-03,4.3258E-03,5.3827E-03,5.7089E-03,
     &1.3765E-03,4.1045E-03,5.6876E-03,6.8515E-03,6.8087E-03,
     &2.0273E-03,5.6227E-03,7.4759E-03,8.6449E-03,7.9051E-03,
     &3.1553E-03,7.7214E-03,9.7810E-03,1.0828E-02,8.9583E-03,
     &4.9678E-03,1.0557E-02,1.2725E-02,1.3447E-02,9.9499E-03/
      DATA ((KB(JS,JT,16, 2),JS=1,5),JT=1,5) /
     &6.6110E-04,2.3925E-03,3.5607E-03,4.5272E-03,4.9025E-03,
     &8.9912E-04,3.2391E-03,4.6534E-03,5.7377E-03,5.8262E-03,
     &1.3419E-03,4.4091E-03,6.0651E-03,7.1821E-03,6.7308E-03,
     &2.1065E-03,5.9970E-03,7.8566E-03,8.9138E-03,7.5936E-03,
     &3.3254E-03,8.1145E-03,1.0111E-02,1.0963E-02,8.4021E-03/
      DATA ((KB(JS,JT,17, 2),JS=1,5),JT=1,5) /
     &4.4242E-04,1.9273E-03,2.9584E-03,3.8169E-03,4.1910E-03,
     &6.0993E-04,2.6019E-03,3.8415E-03,4.8112E-03,4.9579E-03,
     &9.2221E-04,3.5184E-03,4.9669E-03,5.9811E-03,5.6981E-03,
     &1.4572E-03,4.7461E-03,6.3751E-03,7.3581E-03,6.3963E-03,
     &2.3036E-03,6.3581E-03,8.1281E-03,8.9737E-03,7.0378E-03/
      DATA ((KB(JS,JT,18, 2),JS=1,5),JT=1,5) /
     &3.0388E-04,1.5707E-03,2.4656E-03,3.2158E-03,3.5652E-03,
     &4.2513E-04,2.1109E-03,3.1840E-03,4.0302E-03,4.1950E-03,
     &6.4993E-04,2.8372E-03,4.0815E-03,4.9772E-03,4.7960E-03,
     &1.0315E-03,3.7953E-03,5.1949E-03,6.0778E-03,5.3518E-03,
     &1.6331E-03,5.0371E-03,6.5707E-03,7.3465E-03,5.8586E-03/
      DATA ((KB(JS,JT,19, 2),JS=1,5),JT=1,5) /
     &2.0547E-04,1.2763E-03,2.0458E-03,2.6959E-03,3.0176E-03,
     &2.9169E-04,1.7044E-03,2.6231E-03,3.3550E-03,3.5313E-03,
     &4.4987E-04,2.2721E-03,3.3322E-03,4.1113E-03,4.0121E-03,
     &7.1653E-04,3.0090E-03,4.2013E-03,4.9750E-03,4.4532E-03,
     &1.1358E-03,3.9520E-03,5.2567E-03,5.9542E-03,4.8572E-03/
      DATA ((KB(JS,JT,20, 2),JS=1,5),JT=1,5) /
     &1.5174E-04,1.0642E-03,1.7200E-03,2.2761E-03,2.5514E-03,
     &2.1846E-04,1.4153E-03,2.1942E-03,2.8165E-03,2.9650E-03,
     &3.3982E-04,1.8745E-03,2.7705E-03,3.4277E-03,3.3482E-03,
     &5.4313E-04,2.4649E-03,3.4676E-03,4.1183E-03,3.7008E-03,
     &8.6061E-04,3.2127E-03,4.3062E-03,4.9014E-03,4.0252E-03/
      DATA ((KB(JS,JT,21, 2),JS=1,5),JT=1,5) /
     &1.1592E-04,8.9297E-04,1.4493E-03,1.9202E-03,2.1482E-03,
     &1.6918E-04,1.1825E-03,1.8389E-03,2.3614E-03,2.4794E-03,
     &2.6522E-04,1.5570E-03,2.3088E-03,2.8574E-03,2.7868E-03,
     &4.2461E-04,2.0332E-03,2.8744E-03,3.4170E-03,3.0702E-03,
     &6.7177E-04,2.6322E-03,3.5494E-03,4.0519E-03,3.3309E-03/
      DATA ((KB(JS,JT,22, 2),JS=1,5),JT=1,5) /
     &9.3055E-05,7.6606E-04,1.2409E-03,1.6398E-03,1.8197E-03,
     &1.3841E-04,1.0092E-03,1.5660E-03,2.0038E-03,2.0843E-03,
     &2.1899E-04,1.3206E-03,1.9566E-03,2.4125E-03,2.3311E-03,
     &3.5071E-04,1.7145E-03,2.4240E-03,2.8744E-03,2.5586E-03,
     &5.5216E-04,2.2067E-03,2.9792E-03,3.3952E-03,2.7680E-03/
      DATA ((KB(JS,JT,23, 2),JS=1,5),JT=1,5) /
     &7.5659E-05,6.5668E-04,1.0605E-03,1.3970E-03,1.5365E-03,
     &1.1449E-04,8.6018E-04,1.3327E-03,1.6978E-03,1.7494E-03,
     &1.8237E-04,1.1195E-03,1.6581E-03,2.0367E-03,1.9476E-03,
     &2.9157E-04,1.4455E-03,2.0441E-03,2.4187E-03,2.1305E-03,
     &4.5638E-04,1.8506E-03,2.4994E-03,2.8459E-03,2.2986E-03/
      DATA ((KB(JS,JT,24, 2),JS=1,5),JT=1,5) /
     &6.1686E-05,5.6133E-04,9.0530E-04,1.1887E-03,1.2959E-03,
     &9.4868E-05,7.3156E-04,1.1327E-03,1.4379E-03,1.4672E-03,
     &1.5170E-04,9.4694E-04,1.4023E-03,1.7186E-03,1.6265E-03,
     &2.4184E-04,1.2160E-03,1.7202E-03,2.0324E-03,1.7732E-03,
     &3.7584E-04,1.5479E-03,2.0924E-03,2.3822E-03,1.9076E-03/
      DATA ((KB(JS,JT,25, 2),JS=1,5),JT=1,5) /
     &5.1420E-05,4.8151E-04,7.7480E-04,1.0127E-03,1.0925E-03,
     &8.0205E-05,6.2472E-04,9.6537E-04,1.2206E-03,1.2305E-03,
     &1.2852E-04,8.0481E-04,1.1895E-03,1.4535E-03,1.3583E-03,
     &2.0384E-04,1.0284E-03,1.4523E-03,1.7128E-03,1.4762E-03,
     &3.1446E-04,1.3022E-03,1.7587E-03,1.9996E-03,1.5839E-03/
      DATA ((KB(JS,JT,26, 2),JS=1,5),JT=1,5) /
     &4.4173E-05,4.1605E-04,6.6653E-04,8.6651E-04,9.2186E-04,
     &6.9706E-05,5.3779E-04,8.2701E-04,1.0408E-03,1.0329E-03,
     &1.1164E-04,6.8982E-04,1.0147E-03,1.2348E-03,1.1353E-03,
     &1.7590E-04,8.7786E-04,1.2337E-03,1.4499E-03,1.2294E-03,
     &2.6942E-04,1.1054E-03,1.4885E-03,1.6863E-03,1.3161E-03/
      DATA ((KB(JS,JT,27, 2),JS=1,5),JT=1,5) /
     &3.9675E-05,3.6275E-04,5.7658E-04,7.4423E-04,7.7727E-04,
     &6.3079E-05,4.6769E-04,7.1304E-04,8.9128E-04,8.6622E-04,
     &1.0080E-04,5.9857E-04,8.7226E-04,1.0546E-03,9.4873E-04,
     &1.5784E-04,7.5914E-04,1.0582E-03,1.2346E-03,1.0243E-03,
     &2.3988E-04,9.5199E-04,1.2727E-03,1.4326E-03,1.0935E-03/
      DATA ((KB(JS,JT,28, 2),JS=1,5),JT=1,5) /
     &3.6787E-05,3.1827E-04,5.0054E-04,6.4070E-04,6.5436E-04,
     &5.8744E-05,4.0999E-04,6.1769E-04,7.6553E-04,7.2608E-04,
     &9.3496E-05,5.2404E-04,7.5434E-04,9.0364E-04,7.9234E-04,
     &1.4539E-04,6.6291E-04,9.1412E-04,1.0560E-03,8.5294E-04,
     &2.1931E-04,8.2828E-04,1.0967E-03,1.2236E-03,9.0840E-04/
      DATA ((KB(JS,JT,29, 2),JS=1,5),JT=1,5) /
     &3.6448E-05,2.8470E-04,4.4017E-04,5.5630E-04,5.5097E-04,
     &5.8278E-05,3.6727E-04,5.4285E-04,6.6380E-04,6.0864E-04,
     &9.2358E-05,4.6962E-04,6.6368E-04,7.8295E-04,6.6201E-04,
     &1.4253E-04,5.9354E-04,8.0405E-04,9.1518E-04,7.1060E-04,
     &2.1329E-04,7.4124E-04,9.6341E-04,1.0599E-03,7.5499E-04/
      DATA ((KB(JS,JT,30, 2),JS=1,5),JT=1,5) /
     &3.7091E-05,2.5711E-04,3.8922E-04,4.8469E-04,4.6359E-04,
     &5.9310E-05,3.3239E-04,4.8070E-04,5.7820E-04,5.1002E-04,
     &9.3453E-05,4.2556E-04,5.8851E-04,6.8238E-04,5.5293E-04,
     &1.4319E-04,5.3792E-04,7.1341E-04,7.9807E-04,5.9204E-04,
     &2.1251E-04,6.7254E-04,8.5446E-04,9.2424E-04,6.2785E-04/
      DATA ((KB(JS,JT,31, 2),JS=1,5),JT=1,5) /
     &3.9864E-05,2.3712E-04,3.4911E-04,4.2654E-04,3.8998E-04,
     &6.3592E-05,3.0797E-04,4.3283E-04,5.0926E-04,4.2741E-04,
     &9.9603E-05,3.9506E-04,5.3137E-04,6.0258E-04,4.6195E-04,
     &1.5142E-04,5.0071E-04,6.4518E-04,7.0554E-04,4.9395E-04,
     &2.2297E-04,6.2830E-04,7.7442E-04,8.1724E-04,5.2260E-04/
      DATA ((KB(JS,JT,32, 2),JS=1,5),JT=1,5) /
     &4.3430E-05,2.2111E-04,3.1573E-04,3.7714E-04,3.2795E-04,
     &6.9083E-05,2.8816E-04,3.9276E-04,4.5160E-04,3.5813E-04,
     &1.0740E-04,3.7075E-04,4.8372E-04,5.3513E-04,3.8620E-04,
     &1.6196E-04,4.7193E-04,5.8843E-04,6.2745E-04,4.1195E-04,
     &2.3647E-04,5.9479E-04,7.0866E-04,7.2794E-04,4.3506E-04/
      DATA ((KB(JS,JT,33, 2),JS=1,5),JT=1,5) /
     &4.8220E-05,2.0906E-04,2.8832E-04,3.3596E-04,2.7570E-04,
     &7.6368E-05,2.7329E-04,3.6023E-04,4.0330E-04,3.0019E-04,
     &1.1780E-04,3.5332E-04,4.4506E-04,4.7900E-04,3.2295E-04,
     &1.7613E-04,4.5198E-04,5.4349E-04,5.6284E-04,3.4357E-04,
     &2.5515E-04,5.7259E-04,6.5773E-04,6.5473E-04,3.6197E-04/
      DATA ((KB(JS,JT,34, 2),JS=1,5),JT=1,5) /
     &5.1326E-05,1.9484E-04,2.6083E-04,2.9705E-04,2.3085E-04,
     &8.0913E-05,2.5559E-04,3.2688E-04,3.5738E-04,2.5079E-04,
     &1.2390E-04,3.3190E-04,4.0497E-04,4.2508E-04,2.6902E-04,
     &1.8386E-04,4.2648E-04,4.9662E-04,5.0061E-04,2.8571E-04,
     &2.6467E-04,5.4249E-04,6.0361E-04,5.8398E-04,3.0059E-04/
      DATA ((KB(JS,JT,35, 2),JS=1,5),JT=1,5) /
     &5.2281E-05,1.7754E-04,2.3171E-04,2.5859E-04,1.9168E-04,
     &8.2157E-05,2.3435E-04,2.9174E-04,3.1208E-04,2.0781E-04,
     &1.2528E-04,3.0602E-04,3.6300E-04,3.7259E-04,2.2270E-04,
     &1.8516E-04,3.9534E-04,4.4759E-04,4.4038E-04,2.3630E-04,
     &2.6552E-04,5.0554E-04,5.4703E-04,5.1605E-04,2.4840E-04/
      DATA ((KB(JS,JT,36, 2),JS=1,5),JT=1,5) /
     &5.0331E-05,1.5710E-04,2.0093E-04,2.2058E-04,1.5759E-04,
     &7.9043E-05,2.0874E-04,2.5435E-04,2.6739E-04,1.7077E-04,
     &1.2045E-04,2.7440E-04,3.1834E-04,3.2085E-04,1.8310E-04,
     &1.7786E-04,3.5687E-04,3.9494E-04,3.8113E-04,1.9431E-04,
     &2.5490E-04,4.5880E-04,4.8570E-04,4.4889E-04,2.0416E-04/
      DATA ((KB(JS,JT,37, 2),JS=1,5),JT=1,5) /
     &4.4029E-05,1.3168E-04,1.6668E-04,1.8164E-04,1.2776E-04,
     &6.9369E-05,1.7622E-04,2.1241E-04,2.2140E-04,1.3874E-04,
     &1.0612E-04,2.3332E-04,2.6770E-04,2.6723E-04,1.4898E-04,
     &1.5731E-04,3.0549E-04,3.3418E-04,3.1918E-04,1.5836E-04,
     &2.2631E-04,3.9537E-04,4.1350E-04,3.7792E-04,1.6663E-04/
      DATA ((KB(JS,JT,38, 2),JS=1,5),JT=1,5) /
     &3.8922E-05,1.1094E-04,1.3878E-04,1.4984E-04,1.0348E-04,
     &6.1507E-05,1.4964E-04,1.7814E-04,1.8378E-04,1.1264E-04,
     &9.4510E-05,1.9970E-04,2.2619E-04,2.2325E-04,1.2117E-04,
     &1.4072E-04,2.6356E-04,2.8447E-04,2.6849E-04,1.2897E-04,
     &2.0319E-04,3.4350E-04,3.5441E-04,3.1981E-04,1.3588E-04/
      DATA ((KB(JS,JT,39, 2),JS=1,5),JT=1,5) /
     &3.5197E-05,9.4645E-05,1.1658E-04,1.2439E-04,8.3852E-05,
     &5.5773E-05,1.2882E-04,1.5091E-04,1.5369E-04,9.1477E-05,
     &8.6079E-05,1.7350E-04,1.9331E-04,1.8814E-04,9.8545E-05,
     &1.2878E-04,2.3093E-04,2.4509E-04,2.2784E-04,1.0505E-04,
     &1.8672E-04,3.0343E-04,3.0781E-04,2.7347E-04,1.1084E-04/
      DATA ((KB(JS,JT,40, 2),JS=1,5),JT=1,5) /
     &2.8482E-05,7.5721E-05,9.3100E-05,9.9288E-05,6.7184E-05,
     &4.5322E-05,1.0379E-04,1.2136E-04,1.2342E-04,7.3552E-05,
     &7.0466E-05,1.4083E-04,1.5650E-04,1.5207E-04,7.9463E-05,
     &1.0624E-04,1.8883E-04,1.9975E-04,1.8533E-04,8.4957E-05,
     &1.5520E-04,2.4983E-04,2.5250E-04,2.2369E-04,8.9879E-05/
      DATA ((KB(JS,JT,41, 2),JS=1,5),JT=1,5) /
     &2.2852E-05,6.0191E-05,7.3911E-05,7.8847E-05,5.3707E-05,
     &3.6477E-05,8.3074E-05,9.7030E-05,9.8640E-05,5.9019E-05,
     &5.7117E-05,1.1353E-04,1.2598E-04,1.2230E-04,6.3954E-05,
     &8.6797E-05,1.5338E-04,1.6193E-04,1.5005E-04,6.8580E-05,
     &1.2784E-04,2.0441E-04,2.0604E-04,1.8219E-04,7.2757E-05/
      DATA ((KB(JS,JT,42, 2),JS=1,5),JT=1,5) /
     &1.8532E-05,4.8021E-05,5.8809E-05,6.2677E-05,4.2889E-05,
     &2.9639E-05,6.6772E-05,7.7781E-05,7.8945E-05,4.7319E-05,
     &4.6699E-05,9.1970E-05,1.0173E-04,9.8516E-05,5.1447E-05,
     &7.1536E-05,1.2527E-04,1.3174E-04,1.2174E-04,5.5341E-05,
     &1.0622E-04,1.6829E-04,1.6888E-04,1.4882E-04,5.8857E-05/
      DATA ((KB(JS,JT,43, 2),JS=1,5),JT=1,5) /
     &1.4784E-05,3.7715E-05,4.6105E-05,4.9162E-05,3.3989E-05,
     &2.3635E-05,5.2843E-05,6.1488E-05,6.2402E-05,3.7696E-05,
     &3.7482E-05,7.3434E-05,8.1121E-05,7.8491E-05,4.1167E-05,
     &5.7957E-05,1.0094E-04,1.0596E-04,9.7736E-05,4.4450E-05,
     &8.6918E-05,1.3688E-04,1.3695E-04,1.2041E-04,4.7444E-05/
      DATA ((KB(JS,JT,44, 2),JS=1,5),JT=1,5) /
     &1.1851E-05,2.9526E-05,3.5985E-05,3.8353E-05,2.6802E-05,
     &1.8865E-05,4.1676E-05,4.8402E-05,4.9101E-05,2.9917E-05,
     &3.0080E-05,5.8471E-05,6.4462E-05,6.2284E-05,3.2834E-05,
     &4.6945E-05,8.1180E-05,8.5021E-05,7.8278E-05,3.5598E-05,
     &7.1168E-05,1.1121E-04,1.1093E-04,9.7235E-05,3.8149E-05/
      DATA ((KB(JS,JT,45, 2),JS=1,5),JT=1,5) /
     &9.7426E-06,2.3333E-05,2.8230E-05,2.9988E-05,2.1086E-05,
     &1.5361E-05,3.3173E-05,3.8317E-05,3.8748E-05,2.3700E-05,
     &2.4573E-05,4.7011E-05,5.1561E-05,4.9622E-05,2.6158E-05,
     &3.8674E-05,6.5958E-05,6.8724E-05,6.2989E-05,2.8488E-05,
     &5.9269E-05,9.1392E-05,9.0638E-05,7.9041E-05,3.0648E-05/
      DATA ((KB(JS,JT,46, 2),JS=1,5),JT=1,5) /
     &8.0813E-06,1.8394E-05,2.2048E-05,2.3302E-05,1.6499E-05,
     &1.2533E-05,2.6309E-05,3.0179E-05,3.0408E-05,1.8696E-05,
     &2.0044E-05,3.7660E-05,4.1056E-05,3.9350E-05,2.0768E-05,
     &3.1770E-05,5.3410E-05,5.5319E-05,5.0478E-05,2.2728E-05,
     &4.9215E-05,7.4898E-05,7.3800E-05,6.4019E-05,2.4552E-05/
      DATA ((KB(JS,JT,47, 2),JS=1,5),JT=1,5) /
     &6.6192E-06,1.4238E-05,1.6907E-05,1.7806E-05,1.2778E-05,
     &9.9788E-06,2.0419E-05,2.3301E-05,2.3456E-05,1.4630E-05,
     &1.5864E-05,2.9439E-05,3.2011E-05,3.0659E-05,1.6375E-05,
     &2.5298E-05,4.2209E-05,4.3617E-05,3.9755E-05,1.8027E-05,
     &3.9602E-05,5.9887E-05,5.8840E-05,5.0962E-05,1.9570E-05/
      DATA ((KB(JS,JT,48, 2),JS=1,5),JT=1,5) /
     &5.6786E-06,1.1254E-05,1.3112E-05,1.3664E-05,9.8559E-06,
     &8.2415E-06,1.6109E-05,1.8176E-05,1.8172E-05,1.1406E-05,
     &1.2920E-05,2.3359E-05,2.5209E-05,2.4020E-05,1.2882E-05,
     &2.0668E-05,3.3871E-05,3.4762E-05,3.1514E-05,1.4268E-05,
     &3.2629E-05,4.8666E-05,4.7495E-05,4.0906E-05,1.5578E-05/
      DATA ((KB(JS,JT,49, 2),JS=1,5),JT=1,5) /
     &5.1748E-06,9.2021E-06,1.0379E-05,1.0585E-05,7.5665E-06,
     &7.1867E-06,1.3062E-05,1.4427E-05,1.4215E-05,8.8627E-06,
     &1.1001E-05,1.9012E-05,2.0206E-05,1.9017E-05,1.0112E-05,
     &1.7557E-05,2.7865E-05,2.8224E-05,2.5298E-05,1.1279E-05,
     &2.7899E-05,4.0582E-05,3.9130E-05,3.3306E-05,1.2389E-05/
      DATA ((KB(JS,JT,50, 2),JS=1,5),JT=1,5) /
     &4.6020E-06,7.4638E-06,8.1645E-06,8.1559E-06,5.7980E-06,
     &6.1191E-06,1.0436E-05,1.1320E-05,1.1020E-05,6.8814E-06,
     &9.0820E-06,1.5149E-05,1.5926E-05,1.4870E-05,7.9274E-06,
     &1.4367E-05,2.2331E-05,2.2448E-05,1.9990E-05,8.9091E-06,
     &2.2930E-05,3.2870E-05,3.1485E-05,2.6634E-05,9.8428E-06/
      DATA ((KB(JS,JT,51, 2),JS=1,5),JT=1,5) /
     &4.0738E-06,6.0767E-06,6.4322E-06,6.2775E-06,4.4265E-06,
     &5.2028E-06,8.3182E-06,8.8519E-06,8.5040E-06,5.3268E-06,
     &7.4386E-06,1.1969E-05,1.2454E-05,1.1549E-05,6.2015E-06,
     &1.1580E-05,1.7676E-05,1.7666E-05,1.5659E-05,7.0249E-06,
     &1.8500E-05,2.6231E-05,2.5018E-05,2.1082E-05,7.8088E-06/
      DATA ((KB(JS,JT,52, 2),JS=1,5),JT=1,5) /
     &3.7602E-06,5.1251E-06,5.1954E-06,4.8922E-06,3.3637E-06,
     &4.6219E-06,6.8269E-06,7.0581E-06,6.6280E-06,4.1074E-06,
     &6.3416E-06,9.6823E-06,9.8934E-06,9.0485E-06,4.8363E-06,
     &9.6360E-06,1.4271E-05,1.4108E-05,1.2374E-05,5.5264E-06,
     &1.5337E-05,2.1320E-05,2.0165E-05,1.6846E-05,6.1865E-06/
      DATA ((KB(JS,JT,53, 2),JS=1,5),JT=1,5) /
     &3.6702E-06,4.5390E-06,4.3659E-06,3.9002E-06,2.5423E-06,
     &4.3437E-06,5.8533E-06,5.8072E-06,5.2588E-06,3.1537E-06,
     &5.7127E-06,8.1219E-06,8.0674E-06,7.2006E-06,3.7613E-06,
     &8.4068E-06,1.1886E-05,1.1528E-05,9.9298E-06,4.3399E-06,
     &1.3242E-05,1.7846E-05,1.6632E-05,1.3680E-05,4.8970E-06/
      DATA ((KB(JS,JT,54, 2),JS=1,5),JT=1,5) /
     &3.1403E-06,3.6924E-06,3.4557E-06,2.9996E-06,1.9177E-06,
     &3.5986E-06,4.6301E-06,4.4986E-06,4.0115E-06,2.4155E-06,
     &4.5617E-06,6.2669E-06,6.1686E-06,5.4741E-06,2.9175E-06,
     &6.4783E-06,9.0433E-06,8.7626E-06,7.5562E-06,3.4007E-06,
     &1.0042E-05,1.3533E-05,1.2655E-05,1.0455E-05,3.8639E-06/
      DATA ((KB(JS,JT,55, 2),JS=1,5),JT=1,5) /
     &2.4739E-06,2.8343E-06,2.6165E-06,2.2420E-06,1.4427E-06,
     &2.7553E-06,3.4672E-06,3.3435E-06,2.9758E-06,1.8442E-06,
     &3.3782E-06,4.5817E-06,4.5186E-06,4.0371E-06,2.2544E-06,
     &4.6246E-06,6.4927E-06,6.3529E-06,5.5548E-06,2.6558E-06,
     &7.0125E-06,9.6319E-06,9.1393E-06,7.6813E-06,3.0372E-06/
      DATA ((KB(JS,JT,56, 2),JS=1,5),JT=1,5) /
     &1.9604E-06,2.1929E-06,1.9920E-06,1.6797E-06,1.0797E-06,
     &2.1351E-06,2.6170E-06,2.4998E-06,2.2137E-06,1.4022E-06,
     &2.5317E-06,3.3754E-06,3.3236E-06,2.9840E-06,1.7372E-06,
     &3.3387E-06,4.6862E-06,4.6202E-06,4.0882E-06,2.0679E-06,
     &4.9234E-06,6.8724E-06,6.6108E-06,5.6459E-06,2.3854E-06/
      DATA ((KB(JS,JT,57, 2),JS=1,5),JT=1,5) /
     &1.5649E-06,1.7047E-06,1.5250E-06,1.2613E-06,8.0294E-07,
     &1.6685E-06,1.9908E-06,1.8801E-06,1.6502E-06,1.0613E-06,
     &1.9178E-06,2.5066E-06,2.4556E-06,2.2101E-06,1.3329E-06,
     &2.4407E-06,3.4025E-06,3.3722E-06,3.0127E-06,1.6045E-06,
     &3.4802E-06,4.9175E-06,4.7870E-06,4.1514E-06,1.8688E-06/
      DATA ((KB(JS,JT,58, 2),JS=1,5),JT=1,5) /
     &3.3188E-07,4.3313E-07,4.9294E-07,5.6291E-07,5.9615E-07,
     &3.4670E-07,4.9696E-07,5.9930E-07,7.3314E-07,8.0253E-07,
     &3.8806E-07,6.1237E-07,7.7019E-07,9.7654E-07,1.0216E-06,
     &4.7831E-07,8.1333E-07,1.0442E-06,1.3240E-06,1.2449E-06,
     &6.5898E-07,1.1558E-06,1.4682E-06,1.8176E-06,1.4615E-06/
      DATA ((KB(JS,JT,59, 2),JS=1,5),JT=1,5) /
     &3.1712E-07,4.1538E-07,4.5873E-07,4.9478E-07,4.6737E-07,
     &3.2863E-07,4.7977E-07,5.6611E-07,6.5498E-07,6.3397E-07,
     &3.6418E-07,5.9318E-07,7.3191E-07,8.7648E-07,8.1119E-07,
     &4.4347E-07,7.8664E-07,9.8989E-07,1.1827E-06,9.9218E-07,
     &6.0215E-07,1.1090E-06,1.3813E-06,1.6064E-06,1.1684E-06/
      DATA ((KB(JS,JT,13, 3),JS=1,5),JT=1,5) /
     &9.1540E-03,2.0983E-02,2.7409E-02,3.0450E-02,2.3144E-02,
     &1.5150E-02,2.9836E-02,3.7088E-02,3.9562E-02,2.6157E-02,
     &2.6705E-02,4.3495E-02,5.0489E-02,5.0868E-02,2.9169E-02,
     &4.6501E-02,6.3525E-02,6.8930E-02,6.5213E-02,3.2207E-02,
     &7.7883E-02,9.1957E-02,9.3471E-02,8.3394E-02,3.5205E-02/
      DATA ((KB(JS,JT,14, 3),JS=1,5),JT=1,5) /
     &4.9769E-03,1.5542E-02,2.1404E-02,2.4888E-02,2.0102E-02,
     &8.3891E-03,2.1811E-02,2.8513E-02,3.1898E-02,2.2689E-02,
     &1.4857E-02,3.0975E-02,3.8046E-02,4.0288E-02,2.5289E-02,
     &2.5874E-02,4.3884E-02,5.0681E-02,5.0529E-02,2.7965E-02,
     &4.3258E-02,6.1604E-02,6.6800E-02,6.3228E-02,3.0564E-02/
      DATA ((KB(JS,JT,15, 3),JS=1,5),JT=1,5) /
     &2.7780E-03,1.1828E-02,1.7073E-02,2.0490E-02,1.7377E-02,
     &4.7591E-03,1.6367E-02,2.2382E-02,2.5900E-02,1.9610E-02,
     &8.4707E-03,2.2715E-02,2.9226E-02,3.2287E-02,2.1849E-02,
     &1.4726E-02,3.1294E-02,3.8074E-02,3.9870E-02,2.4127E-02,
     &2.4582E-02,4.2700E-02,4.9087E-02,4.8962E-02,2.6357E-02/
      DATA ((KB(JS,JT,16, 3),JS=1,5),JT=1,5) /
     &1.8575E-03,9.6428E-03,1.4258E-02,1.7308E-02,1.4967E-02,
     &3.2295E-03,1.3222E-02,1.8534E-02,2.1716E-02,1.6894E-02,
     &5.7622E-03,1.8134E-02,2.3952E-02,2.6895E-02,1.8844E-02,
     &1.0014E-02,2.4628E-02,3.0790E-02,3.2975E-02,2.0792E-02,
     &1.6651E-02,3.3072E-02,3.9202E-02,4.0100E-02,2.2651E-02/
      DATA ((KB(JS,JT,17, 3),JS=1,5),JT=1,5) /
     &1.2913E-03,7.9469E-03,1.1927E-02,1.4612E-02,1.2832E-02,
     &2.2741E-03,1.0816E-02,1.5424E-02,1.8211E-02,1.4484E-02,
     &4.0659E-03,1.4661E-02,1.9799E-02,2.2441E-02,1.6158E-02,
     &7.0575E-03,1.9668E-02,2.5205E-02,2.7372E-02,1.7784E-02,
     &1.1701E-02,2.6124E-02,3.1755E-02,3.3025E-02,1.9312E-02/
      DATA ((KB(JS,JT,18, 3),JS=1,5),JT=1,5) /
     &9.2490E-04,6.5924E-03,1.0000E-02,1.2327E-02,1.0954E-02,
     &1.6450E-03,8.9024E-03,1.2876E-02,1.5279E-02,1.2362E-02,
     &2.9476E-03,1.1938E-02,1.6432E-02,1.8727E-02,1.3771E-02,
     &5.1050E-03,1.5852E-02,2.0747E-02,2.2702E-02,1.5108E-02,
     &8.4407E-03,2.0877E-02,2.5905E-02,2.7220E-02,1.6353E-02/
      DATA ((KB(JS,JT,19, 3),JS=1,5),JT=1,5) /
     &6.5306E-04,5.4276E-03,8.3228E-03,1.0321E-02,9.3064E-03,
     &1.1720E-03,7.2659E-03,1.0659E-02,1.2719E-02,1.0490E-02,
     &2.1010E-03,9.6452E-03,1.3501E-02,1.5485E-02,1.1656E-02,
     &3.6298E-03,1.2682E-02,1.6890E-02,1.8630E-02,1.2744E-02,
     &5.9733E-03,1.6533E-02,2.0894E-02,2.2160E-02,1.3725E-02/
      DATA ((KB(JS,JT,20, 3),JS=1,5),JT=1,5) /
     &5.0525E-04,4.5786E-03,7.0416E-03,8.7290E-03,7.8885E-03,
     &9.1391E-04,6.1018E-03,8.9804E-03,1.0717E-02,8.8768E-03,
     &1.6371E-03,8.0525E-03,1.1310E-02,1.2976E-02,9.8259E-03,
     &2.8150E-03,1.0522E-02,1.4057E-02,1.5517E-02,1.0692E-02,
     &4.6066E-03,1.3646E-02,1.7296E-02,1.8359E-02,1.1448E-02/
      DATA ((KB(JS,JT,21, 3),JS=1,5),JT=1,5) /
     &4.0425E-04,3.8829E-03,5.9693E-03,7.3863E-03,6.6651E-03,
     &7.3484E-04,5.1547E-03,7.5787E-03,9.0292E-03,7.4787E-03,
     &1.3153E-03,6.7705E-03,9.4934E-03,1.0877E-02,8.2368E-03,
     &2.2503E-03,8.8142E-03,1.1739E-02,1.2939E-02,8.9114E-03,
     &3.6575E-03,1.1380E-02,1.4377E-02,1.5231E-02,9.5025E-03/
      DATA ((KB(JS,JT,22, 3),JS=1,5),JT=1,5) /
     &3.4523E-04,3.3635E-03,5.1429E-03,6.3294E-03,5.6535E-03,
     &6.2993E-04,4.4492E-03,6.4923E-03,7.6957E-03,6.3107E-03,
     &1.1206E-03,5.8192E-03,8.0871E-03,9.2166E-03,6.9018E-03,
     &1.8990E-03,7.5458E-03,9.9517E-03,1.0900E-02,7.4316E-03,
     &3.0583E-03,9.7051E-03,1.2139E-02,1.2766E-02,7.8941E-03/
      DATA ((KB(JS,JT,23, 3),JS=1,5),JT=1,5) /
     &2.9783E-04,2.9108E-03,4.4177E-03,5.4056E-03,4.7807E-03,
     &5.4387E-04,3.8320E-03,5.5435E-03,6.5345E-03,5.2974E-03,
     &9.5952E-04,4.9950E-03,6.8655E-03,7.7757E-03,5.7630E-03,
     &1.6092E-03,6.4496E-03,8.4095E-03,9.1440E-03,6.1817E-03,
     &2.5684E-03,8.2494E-03,1.0215E-02,1.0668E-02,6.5447E-03/
      DATA ((KB(JS,JT,24, 3),JS=1,5),JT=1,5) /
     &2.5715E-04,2.5095E-03,3.7777E-03,4.5997E-03,4.0260E-03,
     &4.6827E-04,3.2888E-03,4.7107E-03,5.5207E-03,4.4325E-03,
     &8.1828E-04,4.2677E-03,5.8000E-03,6.5285E-03,4.8028E-03,
     &1.3581E-03,5.4776E-03,7.0696E-03,7.6441E-03,5.1338E-03,
     &2.1494E-03,6.9550E-03,8.5500E-03,8.8910E-03,5.4193E-03/
      DATA ((KB(JS,JT,25, 3),JS=1,5),JT=1,5) /
     &2.2632E-04,2.1696E-03,3.2330E-03,3.9113E-03,3.3801E-03,
     &4.0936E-04,2.8320E-03,4.0052E-03,4.6615E-03,3.7035E-03,
     &7.0836E-04,3.6547E-03,4.9096E-03,5.4885E-03,3.9989E-03,
     &1.1642E-03,4.6613E-03,5.9642E-03,6.4094E-03,4.2600E-03,
     &1.8243E-03,5.8764E-03,7.1830E-03,7.4369E-03,4.4844E-03/
      DATA ((KB(JS,JT,26, 3),JS=1,5),JT=1,5) /
     &2.0471E-04,1.8893E-03,2.7768E-03,3.3315E-03,2.8361E-03,
     &3.6709E-04,2.4543E-03,3.4258E-03,3.9516E-03,3.0939E-03,
     &6.2789E-04,3.1504E-03,4.1849E-03,4.6387E-03,3.3286E-03,
     &1.0213E-03,3.9950E-03,5.0687E-03,5.4088E-03,3.5346E-03,
     &1.5815E-03,5.0074E-03,6.0787E-03,6.2593E-03,3.7107E-03/
      DATA ((KB(JS,JT,27, 3),JS=1,5),JT=1,5) /
     &1.9251E-04,1.6617E-03,2.4029E-03,2.8514E-03,2.3762E-03,
     &3.4185E-04,2.1525E-03,2.9600E-03,3.3730E-03,2.5825E-03,
     &5.7778E-04,2.7512E-03,3.6092E-03,3.9563E-03,2.7684E-03,
     &9.2854E-04,3.4753E-03,4.3621E-03,4.6091E-03,2.9308E-03,
     &1.4199E-03,4.3436E-03,5.2156E-03,5.3258E-03,3.0691E-03/
      DATA ((KB(JS,JT,28, 3),JS=1,5),JT=1,5) /
     &1.8568E-04,1.4731E-03,2.0943E-03,2.4502E-03,1.9883E-03,
     &3.2639E-04,1.9038E-03,2.5783E-03,2.8978E-03,2.1535E-03,
     &5.4487E-04,2.4257E-03,3.1398E-03,3.3991E-03,2.3010E-03,
     &8.6497E-04,3.0580E-03,3.7865E-03,3.9564E-03,2.4290E-03,
     &1.3039E-03,3.8186E-03,4.5211E-03,4.5655E-03,2.5382E-03/
      DATA ((KB(JS,JT,29, 3),JS=1,5),JT=1,5) /
     &1.9062E-04,1.3364E-03,1.8603E-03,2.1354E-03,1.6643E-03,
     &3.3121E-04,1.7267E-03,2.2927E-03,2.5300E-03,1.7960E-03,
     &5.4570E-04,2.2011E-03,2.7931E-03,2.9723E-03,1.9129E-03,
     &8.5435E-04,2.7794E-03,3.3678E-03,3.4607E-03,2.0139E-03,
     &1.2701E-03,3.4715E-03,4.0279E-03,3.9937E-03,2.1000E-03/
      DATA ((KB(JS,JT,30, 3),JS=1,5),JT=1,5) /
     &2.0043E-04,1.2258E-03,1.6689E-03,1.8766E-03,1.3916E-03,
     &3.4350E-04,1.5850E-03,2.0586E-03,2.2288E-03,1.4967E-03,
     &5.5868E-04,2.0253E-03,2.5096E-03,2.6211E-03,1.5893E-03,
     &8.6173E-04,2.5636E-03,3.0320E-03,3.0532E-03,1.6692E-03,
     &1.2648E-03,3.2006E-03,3.6329E-03,3.5289E-03,1.7373E-03/
      DATA ((KB(JS,JT,31, 3),JS=1,5),JT=1,5) /
     &2.2172E-04,1.1517E-03,1.5273E-03,1.6764E-03,1.1637E-03,
     &3.7478E-04,1.4949E-03,1.8875E-03,1.9960E-03,1.2474E-03,
     &6.0019E-04,1.9228E-03,2.3094E-03,2.3523E-03,1.3210E-03,
     &9.1186E-04,2.4398E-03,2.8016E-03,2.7471E-03,1.3843E-03,
     &1.3231E-03,3.0462E-03,3.3613E-03,3.1855E-03,1.4373E-03/
      DATA ((KB(JS,JT,32, 3),JS=1,5),JT=1,5) /
     &2.4768E-04,1.0937E-03,1.4089E-03,1.5091E-03,9.7256E-04,
     &4.1248E-04,1.4292E-03,1.7477E-03,1.8006E-03,1.0394E-03,
     &6.5047E-04,1.8467E-03,2.1484E-03,2.1275E-03,1.0979E-03,
     &9.7457E-04,2.3473E-03,2.6140E-03,2.4947E-03,1.1482E-03,
     &1.3990E-03,2.9324E-03,3.1399E-03,2.8984E-03,1.1898E-03/
      DATA ((KB(JS,JT,33, 3),JS=1,5),JT=1,5) /
     &2.8078E-04,1.0552E-03,1.3156E-03,1.3710E-03,8.1280E-04,
     &4.6027E-04,1.3891E-03,1.6405E-03,1.6404E-03,8.6605E-04,
     &7.1527E-04,1.8015E-03,2.0264E-03,1.9473E-03,9.1257E-04,
     &1.0579E-03,2.2936E-03,2.4711E-03,2.2904E-03,9.5249E-04,
     &1.5037E-03,2.8717E-03,2.9734E-03,2.6646E-03,9.8557E-04/
      DATA ((KB(JS,JT,34, 3),JS=1,5),JT=1,5) /
     &3.0359E-04,1.0038E-03,1.2140E-03,1.2334E-03,6.7695E-04,
     &4.9090E-04,1.3275E-03,1.5216E-03,1.4814E-03,7.1957E-04,
     &7.5358E-04,1.7240E-03,1.8846E-03,1.7651E-03,7.5712E-04,
     &1.1033E-03,2.1975E-03,2.2999E-03,2.0785E-03,7.8887E-04,
     &1.5542E-03,2.7592E-03,2.7749E-03,2.4194E-03,8.1541E-04/
      DATA ((KB(JS,JT,35, 3),JS=1,5),JT=1,5) /
     &3.1210E-04,9.3394E-04,1.1014E-03,1.0942E-03,5.6016E-04,
     &5.0058E-04,1.2412E-03,1.3879E-03,1.3212E-03,5.9529E-04,
     &7.6299E-04,1.6182E-03,1.7248E-03,1.5791E-03,6.2556E-04,
     &1.1110E-03,2.0696E-03,2.1107E-03,1.8624E-03,6.5155E-04,
     &1.5579E-03,2.6064E-03,2.5562E-03,2.1725E-03,6.7276E-04/
      DATA ((KB(JS,JT,36, 3),JS=1,5),JT=1,5) /
     &3.0156E-04,8.4185E-04,9.7484E-04,9.5194E-04,4.6045E-04,
     &4.8313E-04,1.1258E-03,1.2357E-03,1.1559E-03,4.8953E-04,
     &7.3505E-04,1.4756E-03,1.5422E-03,1.3864E-03,5.1450E-04,
     &1.0692E-03,1.8983E-03,1.8970E-03,1.6403E-03,5.3594E-04,
     &1.4983E-03,2.4025E-03,2.3079E-03,1.9210E-03,5.5373E-04/
      DATA ((KB(JS,JT,37, 3),JS=1,5),JT=1,5) /
     &2.6336E-04,7.1618E-04,8.2306E-04,7.9778E-04,3.7474E-04,
     &4.2453E-04,9.6471E-04,1.0505E-03,9.7428E-04,3.9893E-04,
     &6.5002E-04,1.2743E-03,1.3189E-03,1.1741E-03,4.2011E-04,
     &9.5041E-04,1.6515E-03,1.6323E-03,1.3957E-03,4.3822E-04,
     &1.3379E-03,2.1029E-03,1.9967E-03,1.6424E-03,4.5330E-04/
      DATA ((KB(JS,JT,38, 3),JS=1,5),JT=1,5) /
     &2.3216E-04,6.1241E-04,6.9804E-04,6.7090E-04,3.0479E-04,
     &3.7692E-04,8.3215E-04,8.9807E-04,8.2465E-04,3.2506E-04,
     &5.8109E-04,1.1090E-03,1.1350E-03,9.9936E-04,3.4289E-04,
     &8.5435E-04,1.4493E-03,1.4148E-03,1.1944E-03,3.5825E-04,
     &1.2083E-03,1.8590E-03,1.7421E-03,1.4132E-03,3.7105E-04/
      DATA ((KB(JS,JT,39, 3),JS=1,5),JT=1,5) /
     &2.0931E-04,5.3070E-04,5.9845E-04,5.6903E-04,2.4791E-04,
     &3.4220E-04,7.2810E-04,7.7651E-04,7.0438E-04,2.6488E-04,
     &5.3115E-04,9.8088E-04,9.9044E-04,8.5969E-04,2.7995E-04,
     &7.8539E-04,1.2946E-03,1.2451E-03,1.0342E-03,2.9299E-04,
     &1.1164E-03,1.6738E-03,1.5453E-03,1.2315E-03,3.0388E-04/
      DATA ((KB(JS,JT,40, 3),JS=1,5),JT=1,5) /
     &1.6775E-04,4.2853E-04,4.8421E-04,4.6094E-04,1.9976E-04,
     &2.7762E-04,5.9348E-04,6.3343E-04,5.7451E-04,2.1416E-04,
     &4.3621E-04,8.0667E-04,8.1437E-04,7.0551E-04,2.2701E-04,
     &6.5215E-04,1.0751E-03,1.0317E-03,8.5401E-04,2.3821E-04,
     &9.3504E-04,1.4004E-03,1.2886E-03,1.0222E-03,2.4759E-04/
      DATA ((KB(JS,JT,41, 3),JS=1,5),JT=1,5) /
     &1.3280E-04,3.4319E-04,3.8888E-04,3.7131E-04,1.6067E-04,
     &2.2274E-04,4.8016E-04,5.1341E-04,4.6640E-04,1.7291E-04,
     &3.5456E-04,6.5866E-04,6.6545E-04,5.7628E-04,1.8383E-04,
     &5.3629E-04,8.8588E-04,8.4970E-04,7.0181E-04,1.9338E-04,
     &7.7683E-04,1.1654E-03,1.0693E-03,8.4547E-04,2.0151E-04/
      DATA ((KB(JS,JT,42, 3),JS=1,5),JT=1,5) /
     &1.0593E-04,2.7588E-04,3.1299E-04,2.9948E-04,1.2916E-04,
     &1.8005E-04,3.9002E-04,4.1742E-04,3.7944E-04,1.3949E-04,
     &2.9034E-04,5.4056E-04,5.4599E-04,4.7208E-04,1.4879E-04,
     &4.4476E-04,7.3427E-04,7.0341E-04,5.7900E-04,1.5686E-04,
     &6.5058E-04,9.7580E-04,8.9207E-04,7.0236E-04,1.6390E-04/
      DATA ((KB(JS,JT,43, 3),JS=1,5),JT=1,5) /
     &8.2227E-05,2.1779E-04,2.4797E-04,2.3838E-04,1.0321E-04,
     &1.4211E-04,3.1159E-04,3.3460E-04,3.0498E-04,1.1196E-04,
     &2.3284E-04,4.3690E-04,4.4252E-04,3.8287E-04,1.1989E-04,
     &3.6233E-04,6.0081E-04,5.7601E-04,4.7373E-04,1.2682E-04,
     &5.3702E-04,8.0864E-04,7.3797E-04,5.7931E-04,1.3294E-04/
      DATA ((KB(JS,JT,44, 3),JS=1,5),JT=1,5) /
     &6.3384E-05,1.7094E-04,1.9525E-04,1.8879E-04,8.2201E-05,
     &1.1160E-04,2.4797E-04,2.6713E-04,2.4425E-04,8.9566E-05,
     &1.8608E-04,3.5211E-04,3.5750E-04,3.0979E-04,9.6374E-05,
     &2.9467E-04,4.9085E-04,4.7122E-04,3.8724E-04,1.0229E-04,
     &4.4331E-04,6.6909E-04,6.1037E-04,4.7753E-04,1.0759E-04/
      DATA ((KB(JS,JT,45, 3),JS=1,5),JT=1,5) /
     &4.9661E-05,1.3506E-04,1.5438E-04,1.4993E-04,6.5369E-05,
     &8.8927E-05,1.9883E-04,2.1432E-04,1.9642E-04,7.1593E-05,
     &1.5097E-04,2.8657E-04,2.9095E-04,2.5226E-04,7.7369E-05,
     &2.4324E-04,4.0505E-04,3.8855E-04,3.1866E-04,8.2473E-05,
     &3.7189E-04,5.6030E-04,5.1022E-04,3.9740E-04,8.7038E-05/
      DATA ((KB(JS,JT,46, 3),JS=1,5),JT=1,5) /
     &3.8628E-05,1.0586E-04,1.2112E-04,1.1814E-04,5.1792E-05,
     &7.0302E-05,1.5840E-04,1.7081E-04,1.5701E-04,5.7032E-05,
     &1.2164E-04,2.3200E-04,2.3559E-04,2.0456E-04,6.1939E-05,
     &1.9963E-04,3.3271E-04,3.1891E-04,2.6146E-04,6.6327E-05,
     &3.1076E-04,4.6749E-04,4.2492E-04,3.2997E-04,7.0248E-05/
      DATA ((KB(JS,JT,47, 3),JS=1,5),JT=1,5) /
     &2.8886E-05,8.0656E-05,9.2760E-05,9.1121E-05,4.0766E-05,
     &5.3342E-05,1.2263E-04,1.3276E-04,1.2283E-04,4.5144E-05,
     &9.4301E-05,1.8266E-04,1.8617E-04,1.6258E-04,4.9298E-05,
     &1.5800E-04,2.6616E-04,2.5579E-04,2.1061E-04,5.3068E-05,
     &2.5109E-04,3.7981E-04,3.4582E-04,2.6887E-04,5.6458E-05/
      DATA ((KB(JS,JT,48, 3),JS=1,5),JT=1,5) /
     &2.2227E-05,6.2023E-05,7.1458E-05,7.0462E-05,3.1996E-05,
     &4.1346E-05,9.5908E-05,1.0391E-04,9.6415E-05,3.5660E-05,
     &7.4574E-05,1.4557E-04,1.4830E-04,1.2990E-04,3.9158E-05,
     &1.2768E-04,2.1605E-04,2.0753E-04,1.7110E-04,4.2391E-05,
     &2.0727E-04,3.1336E-04,2.8498E-04,2.2145E-04,4.5305E-05/
      DATA ((KB(JS,JT,49, 3),JS=1,5),JT=1,5) /
     &1.7958E-05,4.8535E-05,5.5723E-05,5.4851E-05,2.5055E-05,
     &3.3224E-05,7.6396E-05,8.2450E-05,7.6323E-05,2.8114E-05,
     &6.0934E-05,1.1837E-04,1.1999E-04,1.0483E-04,3.1052E-05,
     &1.0660E-04,1.7943E-04,1.7133E-04,1.4083E-04,3.3806E-05,
     &1.7683E-04,2.6555E-04,2.4004E-04,1.8562E-04,3.6333E-05/
      DATA ((KB(JS,JT,50, 3),JS=1,5),JT=1,5) /
     &1.4221E-05,3.7289E-05,4.2772E-05,4.2112E-05,1.9622E-05,
     &2.5770E-05,5.9303E-05,6.4074E-05,5.9411E-05,2.2155E-05,
     &4.7760E-05,9.3560E-05,9.4851E-05,8.2933E-05,2.4619E-05,
     &8.5239E-05,1.4440E-04,1.3769E-04,1.1329E-04,2.6943E-05,
     &1.4427E-04,2.1753E-04,1.9626E-04,1.5178E-04,2.9098E-05/
      DATA ((KB(JS,JT,51, 3),JS=1,5),JT=1,5) /
     &1.1317E-05,2.8454E-05,3.2589E-05,3.2092E-05,1.5353E-05,
     &1.9742E-05,4.5457E-05,4.9229E-05,4.5791E-05,1.7432E-05,
     &3.6711E-05,7.2714E-05,7.3963E-05,6.4841E-05,1.9496E-05,
     &6.6639E-05,1.1416E-04,1.0901E-04,8.9977E-05,2.1439E-05,
     &1.1501E-04,1.7496E-04,1.5780E-04,1.2232E-04,2.3266E-05/
      DATA ((KB(JS,JT,52, 3),JS=1,5),JT=1,5) /
     &9.5193E-06,2.2151E-05,2.5124E-05,2.4603E-05,1.1980E-05,
     &1.5692E-05,3.5362E-05,3.8197E-05,3.5510E-05,1.3701E-05,
     &2.8933E-05,5.7282E-05,5.8273E-05,5.1019E-05,1.5415E-05,
     &5.3248E-05,9.1604E-05,8.7350E-05,7.2017E-05,1.7048E-05,
     &9.3646E-05,1.4304E-04,1.2865E-04,9.9576E-05,1.8583E-05/
      DATA ((KB(JS,JT,53, 3),JS=1,5),JT=1,5) /
     &8.6013E-06,1.7806E-05,1.9756E-05,1.9080E-05,9.3222E-06,
     &1.3174E-05,2.8179E-05,3.0144E-05,2.7850E-05,1.0743E-05,
     &2.3711E-05,4.6162E-05,4.6700E-05,4.0629E-05,1.2161E-05,
     &4.4006E-05,7.5218E-05,7.1366E-05,5.8426E-05,1.3528E-05,
     &7.8885E-05,1.1994E-04,1.0719E-04,8.2389E-05,1.4819E-05/
      DATA ((KB(JS,JT,54, 3),JS=1,5),JT=1,5) /
     &6.9789E-06,1.3437E-05,1.4771E-05,1.4238E-05,7.2546E-06,
     &9.9119E-06,2.0811E-05,2.2371E-05,2.0824E-05,8.4185E-06,
     &1.7167E-05,3.4065E-05,3.4800E-05,3.0574E-05,9.5808E-06,
     &3.1909E-05,5.5956E-05,5.3708E-05,4.4436E-05,1.0721E-05,
     &5.8081E-05,9.0422E-05,8.1544E-05,6.3307E-05,1.1799E-05/
      DATA ((KB(JS,JT,55, 3),JS=1,5),JT=1,5) /
     &5.3128E-06,9.7390E-06,1.0688E-05,1.0358E-05,5.6367E-06,
     &6.9987E-06,1.4672E-05,1.5984E-05,1.5113E-05,6.5876E-06,
     &1.1522E-05,2.3785E-05,2.4757E-05,2.2203E-05,7.5366E-06,
     &2.1231E-05,3.9099E-05,3.8355E-05,3.2404E-05,8.4801E-06,
     &3.9115E-05,6.3594E-05,5.8504E-05,4.6398E-05,9.3778E-06/
      DATA ((KB(JS,JT,56, 3),JS=1,5),JT=1,5) /
     &4.1255E-06,7.1364E-06,7.7808E-06,7.5482E-06,4.3681E-06,
     &5.0603E-06,1.0419E-05,1.1462E-05,1.0974E-05,5.1464E-06,
     &7.8194E-06,1.6631E-05,1.7619E-05,1.6112E-05,5.9174E-06,
     &1.4119E-05,2.7308E-05,2.7375E-05,2.3608E-05,6.6946E-06,
     &2.6208E-05,4.4637E-05,4.1923E-05,3.3985E-05,7.4429E-06/
      DATA ((KB(JS,JT,57, 3),JS=1,5),JT=1,5) /
     &3.2493E-06,5.2971E-06,5.6993E-06,5.5117E-06,3.3724E-06,
     &3.7488E-06,7.4571E-06,8.2480E-06,7.9737E-06,4.0105E-06,
     &5.3914E-06,1.1658E-05,1.2555E-05,1.1685E-05,4.6429E-06,
     &9.4028E-06,1.9067E-05,1.9516E-05,1.7175E-05,5.2749E-06,
     &1.7491E-05,3.1266E-05,3.0002E-05,2.4856E-05,5.8965E-06/
      DATA ((KB(JS,JT,58, 3),JS=1,5),JT=1,5) /
     &6.8210E-07,1.3006E-06,1.7801E-06,2.4088E-06,2.6011E-06,
     &7.5233E-07,1.7695E-06,2.5293E-06,3.4612E-06,3.1260E-06,
     &1.0077E-06,2.6981E-06,3.8040E-06,5.0545E-06,3.6427E-06,
     &1.6789E-06,4.3767E-06,5.8928E-06,7.4329E-06,4.1541E-06,
     &3.1035E-06,7.1707E-06,9.0733E-06,1.0789E-05,4.6675E-06/
      DATA ((KB(JS,JT,59, 3),JS=1,5),JT=1,5) /
     &6.5007E-07,1.2934E-06,1.7266E-06,2.1835E-06,2.0738E-06,
     &7.0640E-07,1.7649E-06,2.4593E-06,3.1227E-06,2.5027E-06,
     &9.2077E-07,2.6612E-06,3.6625E-06,4.5103E-06,2.9231E-06,
     &1.5013E-06,4.2541E-06,5.5816E-06,6.5373E-06,3.3365E-06,
     &2.7629E-06,6.8551E-06,8.4568E-06,9.3583E-06,3.7483E-06/
      DATA ((KB(JS,JT,13, 4),JS=1,5),JT=1,5) /
     &6.7049E-02,1.0578E-01,1.2049E-01,1.1447E-01,5.3996E-02,
     &1.2378E-01,1.5839E-01,1.6716E-01,1.4967E-01,5.8724E-02,
     &2.1508E-01,2.3357E-01,2.2807E-01,1.9256E-01,6.3468E-02,
     &3.4658E-01,3.3547E-01,3.0532E-01,2.4368E-01,6.7895E-02,
     &5.1918E-01,4.6542E-01,4.0071E-01,3.0351E-01,7.2180E-02/
      DATA ((KB(JS,JT,14, 4),JS=1,5),JT=1,5) /
     &3.7591E-02,7.5935E-02,8.9834E-02,8.8154E-02,4.7370E-02,
     &6.9282E-02,1.0939E-01,1.2082E-01,1.1264E-01,5.1597E-02,
     &1.1973E-01,1.5456E-01,1.5973E-01,1.4179E-01,5.5698E-02,
     &1.9141E-01,2.1319E-01,2.0757E-01,1.7567E-01,5.9503E-02,
     &2.8419E-01,2.8689E-01,2.6537E-01,2.1426E-01,6.3167E-02/
      DATA ((KB(JS,JT,15, 4),JS=1,5),JT=1,5) /
     &2.1562E-02,5.5383E-02,6.7683E-02,6.8583E-02,4.1403E-02,
     &3.9720E-02,7.6977E-02,8.8827E-02,8.5804E-02,4.5107E-02,
     &6.8049E-02,1.0522E-01,1.1458E-01,1.0592E-01,4.8636E-02,
     &1.0779E-01,1.4096E-01,1.4532E-01,1.2906E-01,5.1972E-02,
     &1.5865E-01,1.8497E-01,1.8175E-01,1.5501E-01,5.5102E-02/
      DATA ((KB(JS,JT,16, 4),JS=1,5),JT=1,5) /
     &1.4772E-02,4.3932E-02,5.4513E-02,5.6391E-02,3.6009E-02,
     &2.7132E-02,5.9972E-02,7.0550E-02,6.9709E-02,3.9169E-02,
     &4.6049E-02,8.0444E-02,8.9769E-02,8.5125E-02,4.2209E-02,
     &7.2213E-02,1.0588E-01,1.1245E-01,1.0271E-01,4.5097E-02,
     &1.0534E-01,1.3693E-01,1.3910E-01,1.2239E-01,4.7833E-02/
      DATA ((KB(JS,JT,17, 4),JS=1,5),JT=1,5) /
     &1.0505E-02,3.5195E-02,4.4278E-02,4.6677E-02,3.1091E-02,
     &1.9166E-02,4.7335E-02,5.6632E-02,5.7162E-02,3.3802E-02,
     &3.2242E-02,6.2594E-02,7.1319E-02,6.9208E-02,3.6407E-02,
     &4.9961E-02,8.1341E-02,8.8470E-02,8.2810E-02,3.8893E-02,
     &7.2404E-02,1.0400E-01,1.0862E-01,9.8084E-02,4.1273E-02/
      DATA ((KB(JS,JT,18, 4),JS=1,5),JT=1,5) /
     &7.6562E-03,2.8333E-02,3.6121E-02,3.8835E-02,2.6686E-02,
     &1.3867E-02,3.7676E-02,4.5765E-02,4.7147E-02,2.9013E-02,
     &2.3086E-02,4.9274E-02,5.7143E-02,5.6661E-02,3.1231E-02,
     &3.5350E-02,6.3412E-02,7.0379E-02,6.7363E-02,3.3367E-02,
     &5.0974E-02,8.0253E-02,8.5775E-02,7.9284E-02,3.5380E-02/
      DATA ((KB(JS,JT,19, 4),JS=1,5),JT=1,5) /
     &5.4803E-03,2.2514E-02,2.9208E-02,3.2099E-02,2.2789E-02,
     &9.8317E-03,2.9614E-02,3.6650E-02,3.8632E-02,2.4757E-02,
     &1.6184E-02,3.8312E-02,4.5365E-02,4.6081E-02,2.6634E-02,
     &2.4529E-02,4.8776E-02,5.5440E-02,5.4451E-02,2.8434E-02,
     &3.5233E-02,6.1231E-02,6.7107E-02,6.3779E-02,3.0105E-02/
      DATA ((KB(JS,JT,20, 4),JS=1,5),JT=1,5) /
     &4.2828E-03,1.8555E-02,2.4277E-02,2.6995E-02,1.9406E-02,
     &7.5931E-03,2.4236E-02,3.0290E-02,3.2347E-02,2.1050E-02,
     &1.2330E-02,3.1123E-02,3.7288E-02,3.8414E-02,2.2621E-02,
     &1.8510E-02,3.9358E-02,4.5374E-02,4.5224E-02,2.4107E-02,
     &2.6546E-02,4.9149E-02,5.4720E-02,5.2789E-02,2.5443E-02/
      DATA ((KB(JS,JT,21, 4),JS=1,5),JT=1,5) /
     &3.4446E-03,1.5454E-02,2.0322E-02,2.2766E-02,1.6445E-02,
     &6.0284E-03,2.0063E-02,2.5258E-02,2.7191E-02,1.7819E-02,
     &9.6698E-03,2.5633E-02,3.0993E-02,3.2202E-02,1.9116E-02,
     &1.4416E-02,3.2230E-02,3.7573E-02,3.7789E-02,2.0305E-02,
     &2.0653E-02,4.0104E-02,4.5153E-02,4.3956E-02,2.1322E-02/
      DATA ((KB(JS,JT,22, 4),JS=1,5),JT=1,5) /
     &2.9417E-03,1.3191E-02,1.7364E-02,1.9451E-02,1.3960E-02,
     &5.0614E-03,1.7031E-02,2.1496E-02,2.3163E-02,1.5084E-02,
     &7.9857E-03,2.1643E-02,2.6269E-02,2.7349E-02,1.6128E-02,
     &1.1815E-02,2.7096E-02,3.1716E-02,3.1974E-02,1.7035E-02,
     &1.6874E-02,3.3630E-02,3.8023E-02,3.7066E-02,1.7780E-02/
      DATA ((KB(JS,JT,23, 4),JS=1,5),JT=1,5) /
     &2.5270E-03,1.1266E-02,1.4840E-02,1.6589E-02,1.1804E-02,
     &4.2729E-03,1.4464E-02,1.8293E-02,1.9688E-02,1.2713E-02,
     &6.6524E-03,1.8294E-02,2.2254E-02,2.3162E-02,1.3520E-02,
     &9.7631E-03,2.2820E-02,2.6759E-02,2.6972E-02,1.4190E-02,
     &1.3880E-02,2.8296E-02,3.2015E-02,3.1138E-02,1.4756E-02/
      DATA ((KB(JS,JT,24, 4),JS=1,5),JT=1,5) /
     &2.1649E-03,9.5893E-03,1.2641E-02,1.4093E-02,9.9437E-03,
     &3.5984E-03,1.2238E-02,1.5497E-02,1.6660E-02,1.0660E-02,
     &5.5343E-03,1.5407E-02,1.8761E-02,1.9506E-02,1.1265E-02,
     &8.0630E-03,1.9178E-02,2.2493E-02,2.2596E-02,1.1775E-02,
     &1.1384E-02,2.3746E-02,2.6831E-02,2.5965E-02,1.2211E-02/
      DATA ((KB(JS,JT,25, 4),JS=1,5),JT=1,5) /
     &1.8852E-03,8.1978E-03,1.0793E-02,1.1983E-02,8.3500E-03,
     &3.0822E-03,1.0410E-02,1.3161E-02,1.4105E-02,8.8930E-03,
     &4.6788E-03,1.3060E-02,1.5866E-02,1.6423E-02,9.3555E-03,
     &6.7672E-03,1.6246E-02,1.8965E-02,1.8919E-02,9.7508E-03,
     &9.4703E-03,2.0069E-02,2.2560E-02,2.1660E-02,1.0087E-02/
      DATA ((KB(JS,JT,26, 4),JS=1,5),JT=1,5) /
     &1.6838E-03,7.0691E-03,9.2649E-03,1.0222E-02,6.9856E-03,
     &2.7021E-03,8.9432E-03,1.1240E-02,1.1970E-02,7.4013E-03,
     &4.0452E-03,1.1195E-02,1.3497E-02,1.3851E-02,7.7588E-03,
     &5.8017E-03,1.3912E-02,1.6094E-02,1.5906E-02,8.0669E-03,
     &8.0448E-03,1.7140E-02,1.9095E-02,1.8175E-02,8.3263E-03/
      DATA ((KB(JS,JT,27, 4),JS=1,5),JT=1,5) /
     &1.5607E-03,6.1890E-03,8.0258E-03,8.7683E-03,5.8228E-03,
     &2.4561E-03,7.8183E-03,9.7010E-03,1.0217E-02,6.1459E-03,
     &3.6253E-03,9.7806E-03,1.1625E-02,1.1787E-02,6.4270E-03,
     &5.1578E-03,1.2146E-02,1.3856E-02,1.3525E-02,6.6670E-03,
     &7.0917E-03,1.4929E-02,1.6419E-02,1.5452E-02,6.8676E-03/
      DATA ((KB(JS,JT,28, 4),JS=1,5),JT=1,5) /
     &1.4790E-03,5.4823E-03,6.9976E-03,7.5478E-03,4.8444E-03,
     &2.2841E-03,6.9262E-03,8.4418E-03,8.7670E-03,5.0989E-03,
     &3.3280E-03,8.6594E-03,1.0117E-02,1.0108E-02,5.3174E-03,
     &4.7002E-03,1.0747E-02,1.2065E-02,1.1610E-02,5.5053E-03,
     &6.4216E-03,1.3181E-02,1.4294E-02,1.3272E-02,5.6597E-03/
      DATA ((KB(JS,JT,29, 4),JS=1,5),JT=1,5) /
     &1.4846E-03,5.0115E-03,6.2330E-03,6.5969E-03,4.0271E-03,
     &2.2530E-03,6.3449E-03,7.5362E-03,7.6648E-03,4.2267E-03,
     &3.2510E-03,7.9458E-03,9.0603E-03,8.8629E-03,4.3989E-03,
     &4.5516E-03,9.8569E-03,1.0828E-02,1.0206E-02,4.5467E-03,
     &6.1805E-03,1.2091E-02,1.2839E-02,1.1688E-02,4.6649E-03/
      DATA ((KB(JS,JT,30, 4),JS=1,5),JT=1,5) /
     &1.5199E-03,4.6536E-03,5.6184E-03,5.8111E-03,3.3446E-03,
     &2.2691E-03,5.9027E-03,6.8239E-03,6.7733E-03,3.5018E-03,
     &3.2488E-03,7.4072E-03,8.2321E-03,7.8632E-03,3.6376E-03,
     &4.5119E-03,9.1886E-03,9.8595E-03,9.0823E-03,3.7530E-03,
     &6.0862E-03,1.1295E-02,1.1709E-02,1.0421E-02,3.8437E-03/
      DATA ((KB(JS,JT,31, 4),JS=1,5),JT=1,5) /
     &1.6311E-03,4.4648E-03,5.2027E-03,5.2222E-03,2.7768E-03,
     &2.3988E-03,5.6776E-03,6.3545E-03,6.1217E-03,2.9011E-03,
     &3.4145E-03,7.1414E-03,7.7030E-03,7.1444E-03,3.0093E-03,
     &4.7033E-03,8.8852E-03,9.2526E-03,8.2855E-03,3.0977E-03,
     &6.2907E-03,1.0964E-02,1.1034E-02,9.5381E-03,3.1698E-03/
      DATA ((KB(JS,JT,32, 4),JS=1,5),JT=1,5) /
     &1.7646E-03,4.3392E-03,4.8857E-03,4.7446E-03,2.3054E-03,
     &2.5651E-03,5.5295E-03,5.9929E-03,5.5951E-03,2.4036E-03,
     &3.6260E-03,6.9759E-03,7.2903E-03,6.5646E-03,2.4876E-03,
     &4.9515E-03,8.7151E-03,8.7927E-03,7.6385E-03,2.5574E-03,
     &6.5598E-03,1.0782E-02,1.0540E-02,8.8332E-03,2.6142E-03/
      DATA ((KB(JS,JT,33, 4),JS=1,5),JT=1,5) /
     &1.9374E-03,4.2874E-03,4.6591E-03,4.3717E-03,1.9130E-03,
     &2.7949E-03,5.4803E-03,5.7408E-03,5.1902E-03,1.9904E-03,
     &3.9103E-03,6.9411E-03,7.0122E-03,6.1134E-03,2.0570E-03,
     &5.2898E-03,8.7072E-03,8.5064E-03,7.1438E-03,2.1115E-03,
     &6.9527E-03,1.0788E-02,1.0239E-02,8.3069E-03,2.1568E-03/
      DATA ((KB(JS,JT,34, 4),JS=1,5),JT=1,5) /
     &2.0406E-03,4.1540E-03,4.3826E-03,3.9946E-03,1.5845E-03,
     &2.9261E-03,5.3300E-03,5.4194E-03,4.7632E-03,1.6461E-03,
     &4.0546E-03,6.7773E-03,6.6513E-03,5.6287E-03,1.6983E-03,
     &5.4348E-03,8.5143E-03,8.1040E-03,6.6107E-03,1.7421E-03,
     &7.1060E-03,1.0544E-02,9.7699E-03,7.7212E-03,1.7780E-03/
      DATA ((KB(JS,JT,35, 4),JS=1,5),JT=1,5) /
     &2.0728E-03,3.9485E-03,4.0574E-03,3.6081E-03,1.3068E-03,
     &2.9602E-03,5.0932E-03,5.0438E-03,4.3192E-03,1.3565E-03,
     &4.0769E-03,6.5016E-03,6.2270E-03,5.1307E-03,1.3990E-03,
     &5.4354E-03,8.1764E-03,7.6137E-03,6.0597E-03,1.4343E-03,
     &7.0821E-03,1.0134E-02,9.1905E-03,7.1011E-03,1.4630E-03/
      DATA ((KB(JS,JT,36, 4),JS=1,5),JT=1,5) /
     &2.0103E-03,3.6479E-03,3.6691E-03,3.1952E-03,1.0729E-03,
     &2.8662E-03,4.7338E-03,4.5904E-03,3.8448E-03,1.1132E-03,
     &3.9368E-03,6.0663E-03,5.7008E-03,4.5973E-03,1.1487E-03,
     &5.2410E-03,7.6444E-03,6.9919E-03,5.4585E-03,1.1779E-03,
     &6.8204E-03,9.5005E-03,8.4610E-03,6.4164E-03,1.2022E-03/
      DATA ((KB(JS,JT,37, 4),JS=1,5),JT=1,5) /
     &1.7959E-03,3.1864E-03,3.1663E-03,2.7239E-03,8.7469E-04,
     &2.5697E-03,4.1617E-03,3.9876E-03,3.2966E-03,9.0931E-04,
     &3.5391E-03,5.3610E-03,4.9818E-03,3.9676E-03,9.3897E-04,
     &4.7240E-03,6.7847E-03,6.1364E-03,4.7358E-03,9.6399E-04,
     &6.1586E-03,8.4655E-03,7.4564E-03,5.5875E-03,9.8533E-04/
      DATA ((KB(JS,JT,38, 4),JS=1,5),JT=1,5) /
     &1.6221E-03,2.8081E-03,2.7522E-03,2.3347E-03,7.1314E-04,
     &2.3291E-03,3.6929E-03,3.4899E-03,2.8446E-03,7.4249E-04,
     &3.2190E-03,4.7846E-03,4.3892E-03,3.4480E-03,7.6765E-04,
     &4.3100E-03,6.0843E-03,5.4322E-03,4.1379E-03,7.8970E-04,
     &5.6295E-03,7.6227E-03,6.6325E-03,4.9024E-03,8.0762E-04/
      DATA ((KB(JS,JT,39, 4),JS=1,5),JT=1,5) /
     &1.4985E-03,2.5181E-03,2.4272E-03,2.0247E-03,5.8188E-04,
     &2.1580E-03,3.3353E-03,3.1025E-03,2.4863E-03,6.0647E-04,
     &2.9946E-03,4.3491E-03,3.9298E-03,3.0357E-03,6.2817E-04,
     &4.0211E-03,5.5590E-03,4.8918E-03,3.6649E-03,6.4668E-04,
     &5.2642E-03,6.9995E-03,6.0040E-03,4.3661E-03,6.6239E-04/
      DATA ((KB(JS,JT,40, 4),JS=1,5),JT=1,5) /
     &1.2480E-03,2.0953E-03,2.0102E-03,1.6690E-03,4.7210E-04,
     &1.8115E-03,2.7936E-03,2.5861E-03,2.0625E-03,4.9296E-04,
     &2.5332E-03,3.6693E-03,3.2977E-03,2.5337E-03,5.1142E-04,
     &3.4226E-03,4.7175E-03,4.1297E-03,3.0758E-03,5.2719E-04,
     &4.4988E-03,5.9686E-03,5.0929E-03,3.6827E-03,5.4108E-04/
      DATA ((KB(JS,JT,41, 4),JS=1,5),JT=1,5) /
     &1.0279E-03,1.7303E-03,1.6546E-03,1.3684E-03,3.8259E-04,
     &1.5100E-03,2.3260E-03,2.1442E-03,1.7025E-03,4.0029E-04,
     &2.1257E-03,3.0759E-03,2.7514E-03,2.1044E-03,4.1598E-04,
     &2.8920E-03,3.9799E-03,3.4670E-03,2.5693E-03,4.2980E-04,
     &3.8245E-03,5.0645E-03,4.3009E-03,3.0935E-03,4.4154E-04/
      DATA ((KB(JS,JT,42, 4),JS=1,5),JT=1,5) /
     &8.5248E-04,1.4366E-03,1.3681E-03,1.1259E-03,3.0986E-04,
     &1.2693E-03,1.9496E-03,1.7879E-03,1.4116E-03,3.2494E-04,
     &1.7992E-03,2.5962E-03,2.3093E-03,1.7561E-03,3.3826E-04,
     &2.4657E-03,3.3829E-03,2.9302E-03,2.1577E-03,3.5033E-04,
     &3.2835E-03,4.3314E-03,3.6581E-03,2.6128E-03,3.6051E-04/
      DATA ((KB(JS,JT,43, 4),JS=1,5),JT=1,5) /
     &6.9299E-04,1.1756E-03,1.1172E-03,9.1666E-04,2.5008E-04,
     &1.0504E-03,1.6147E-03,1.4746E-03,1.1591E-03,2.6296E-04,
     &1.5042E-03,2.1683E-03,1.9190E-03,1.4524E-03,2.7439E-04,
     &2.0819E-03,2.8510E-03,2.4566E-03,1.7990E-03,2.8482E-04,
     &2.7959E-03,3.6773E-03,3.0899E-03,2.1936E-03,2.9376E-04/
      DATA ((KB(JS,JT,44, 4),JS=1,5),JT=1,5) /
     &5.6092E-04,9.5981E-04,9.1038E-04,7.4434E-04,2.0138E-04,
     &8.6869E-04,1.3365E-03,1.2153E-03,9.5085E-04,2.1240E-04,
     &1.2605E-03,1.8133E-03,1.5968E-03,1.2017E-03,2.2220E-04,
     &1.7639E-03,2.4086E-03,2.0630E-03,1.5011E-03,2.3130E-04,
     &2.3892E-03,3.1325E-03,2.6172E-03,1.8457E-03,2.3904E-04/
      DATA ((KB(JS,JT,45, 4),JS=1,5),JT=1,5) /
     &4.5956E-04,7.9161E-04,7.4840E-04,6.0859E-04,1.6203E-04,
     &7.2822E-04,1.1187E-03,1.0117E-03,7.8592E-04,1.7142E-04,
     &1.0767E-03,1.5389E-03,1.3458E-03,1.0038E-03,1.7986E-04,
     &1.5195E-03,2.0634E-03,1.7544E-03,1.2651E-03,1.8773E-04,
     &2.0790E-03,2.7102E-03,2.2473E-03,1.5700E-03,1.9451E-04/
      DATA ((KB(JS,JT,46, 4),JS=1,5),JT=1,5) /
     &3.7292E-04,6.4911E-04,6.1209E-04,4.9545E-04,1.3008E-04,
     &6.0673E-04,9.3287E-04,8.3976E-04,6.4802E-04,1.3811E-04,
     &9.1635E-04,1.3033E-03,1.1323E-03,8.3718E-04,1.4541E-04,
     &1.3083E-03,1.7659E-03,1.4916E-03,1.0659E-03,1.5214E-04,
     &1.8099E-03,2.3458E-03,1.9309E-03,1.3365E-03,1.5810E-04/
      DATA ((KB(JS,JT,47, 4),JS=1,5),JT=1,5) /
     &2.8950E-04,5.1677E-04,4.8802E-04,3.9502E-04,1.0398E-04,
     &4.8670E-04,7.5660E-04,6.8049E-04,5.2378E-04,1.1085E-04,
     &7.5525E-04,1.0762E-03,9.3123E-04,6.8496E-04,1.1715E-04,
     &1.0969E-03,1.4777E-03,1.2426E-03,8.8223E-04,1.2295E-04,
     &1.5354E-03,1.9852E-03,1.6256E-03,1.1178E-03,1.2805E-04/
      DATA ((KB(JS,JT,48, 4),JS=1,5),JT=1,5) /
     &2.2732E-04,4.1628E-04,3.9316E-04,3.1737E-04,8.2969E-05,
     &3.9696E-04,6.2251E-04,5.5852E-04,4.2777E-04,8.8908E-05,
     &6.3462E-04,9.0305E-04,7.7729E-04,5.6732E-04,9.4308E-05,
     &9.4204E-04,1.2622E-03,1.0539E-03,7.4093E-04,9.9236E-05,
     &1.3331E-03,1.7143E-03,1.3938E-03,9.4935E-04,1.0368E-04/
      DATA ((KB(JS,JT,49, 4),JS=1,5),JT=1,5) /
     &1.8300E-04,3.4217E-04,3.2264E-04,2.5877E-04,6.6118E-05,
     &3.3312E-04,5.2483E-04,4.6829E-04,3.5552E-04,7.1194E-05,
     &5.4973E-04,7.7839E-04,6.6473E-04,4.7940E-04,7.5813E-05,
     &8.3663E-04,1.1105E-03,9.1800E-04,6.3658E-04,8.0100E-05,
     &1.2004E-03,1.5281E-03,1.2307E-03,8.2653E-04,8.3935E-05/
      DATA ((KB(JS,JT,50, 4),JS=1,5),JT=1,5) /
     &1.4039E-04,2.7151E-04,2.5713E-04,2.0628E-04,5.2648E-05,
     &2.6610E-04,4.2689E-04,3.8091E-04,2.8831E-04,5.6961E-05,
     &4.5427E-04,6.4624E-04,5.5025E-04,3.9479E-04,6.0907E-05,
     &7.0950E-04,9.4070E-04,7.7361E-04,5.3217E-04,6.4571E-05,
     &1.0374E-03,1.3149E-03,1.0530E-03,7.0038E-04,6.7890E-05/
      DATA ((KB(JS,JT,51, 4),JS=1,5),JT=1,5) /
     &1.0489E-04,2.1109E-04,2.0141E-04,1.6218E-04,4.1878E-05,
     &2.0633E-04,3.4016E-04,3.0444E-04,2.3054E-04,4.5538E-05,
     &3.6536E-04,5.2580E-04,4.4746E-04,3.2051E-04,4.8874E-05,
     &5.8696E-04,7.8085E-04,6.4023E-04,4.3829E-04,5.1997E-05,
     &8.7556E-04,1.1091E-03,8.8460E-04,5.8473E-04,5.4858E-05/
      DATA ((KB(JS,JT,52, 4),JS=1,5),JT=1,5) /
     &7.9793E-05,1.6601E-04,1.5918E-04,1.2853E-04,3.3276E-05,
     &1.6247E-04,2.7468E-04,2.4631E-04,1.8617E-04,3.6357E-05,
     &2.9905E-04,4.3474E-04,3.6924E-04,2.6353E-04,3.9196E-05,
     &4.9530E-04,6.5976E-04,5.3847E-04,3.6618E-04,4.1839E-05,
     &7.5546E-04,9.5475E-04,7.5721E-04,4.9627E-04,4.4317E-05/
      DATA ((KB(JS,JT,53, 4),JS=1,5),JT=1,5) /
     &6.2729E-05,1.3307E-04,1.2792E-04,1.0321E-04,2.6401E-05,
     &1.3138E-04,2.2658E-04,2.0324E-04,1.5289E-04,2.9006E-05,
     &2.5160E-04,3.6877E-04,3.1205E-04,2.2094E-04,3.1410E-05,
     &4.3128E-04,5.7326E-04,4.6479E-04,3.1290E-04,3.3663E-05,
     &6.7436E-04,8.4743E-04,6.6688E-04,4.3200E-04,3.5790E-05/
      DATA ((KB(JS,JT,54, 4),JS=1,5),JT=1,5) /
     &4.3536E-05,9.6993E-05,9.4650E-05,7.7465E-05,2.0921E-05,
     &9.2752E-05,1.6814E-04,1.5268E-04,1.1626E-04,2.3103E-05,
     &1.8378E-04,2.7919E-04,2.3835E-04,1.7016E-04,2.5121E-05,
     &3.2645E-04,4.4256E-04,3.6033E-04,2.4382E-04,2.7012E-05,
     &5.2349E-04,6.6571E-04,5.2497E-04,3.4104E-04,2.8788E-05/
      DATA ((KB(JS,JT,55, 4),JS=1,5),JT=1,5) /
     &2.7968E-05,6.6619E-05,6.6506E-05,5.5712E-05,1.6550E-05,
     &5.9858E-05,1.1651E-04,1.0803E-04,8.4126E-05,1.8363E-05,
     &1.2216E-04,1.9620E-04,1.7047E-04,1.2407E-04,2.0057E-05,
     &2.2490E-04,3.1581E-04,2.6032E-04,1.7892E-04,2.1634E-05,
     &3.7032E-04,4.8266E-04,3.8398E-04,2.5251E-04,2.3108E-05/
      DATA ((KB(JS,JT,56, 4),JS=1,5),JT=1,5) /
     &1.8187E-05,4.5780E-05,4.6700E-05,4.0035E-05,1.3073E-05,
     &3.8391E-05,8.0472E-05,7.6243E-05,6.0757E-05,1.4582E-05,
     &8.0424E-05,1.3728E-04,1.2154E-04,9.0284E-05,1.6006E-05,
     &1.5350E-04,2.2433E-04,1.8750E-04,1.3109E-04,1.7305E-05,
     &2.6031E-04,3.4853E-04,2.7994E-04,1.8653E-04,1.8526E-05/
      DATA ((KB(JS,JT,57, 4),JS=1,5),JT=1,5) /
     &1.2069E-05,3.1511E-05,3.2815E-05,2.8783E-05,1.0310E-05,
     &2.4551E-05,5.5416E-05,5.3688E-05,4.3795E-05,1.1563E-05,
     &5.2372E-05,9.5634E-05,8.6379E-05,6.5547E-05,1.2748E-05,
     &1.0355E-04,1.5851E-04,1.3458E-04,9.5855E-05,1.3838E-05,
     &1.8156E-04,2.5040E-04,2.0330E-04,1.3740E-04,1.4854E-05/
      DATA ((KB(JS,JT,58, 4),JS=1,5),JT=1,5) /
     &2.1923E-06,7.1667E-06,9.7990E-06,1.2334E-05,8.1331E-06,
     &4.2014E-06,1.2514E-05,1.5980E-05,1.8735E-05,9.1661E-06,
     &9.0349E-06,2.1751E-05,2.5847E-05,2.8162E-05,1.0154E-05,
     &1.8408E-05,3.6461E-05,4.0575E-05,4.1376E-05,1.1069E-05,
     &3.3398E-05,5.8421E-05,6.1871E-05,5.9629E-05,1.1910E-05/
      DATA ((KB(JS,JT,59, 4),JS=1,5),JT=1,5) /
     &1.9895E-06,7.0146E-06,9.2666E-06,1.0819E-05,6.5530E-06,
     &3.7103E-06,1.1985E-05,1.4798E-05,1.6119E-05,7.3922E-06,
     &7.9795E-06,2.0481E-05,2.3504E-05,2.3808E-05,8.1931E-06,
     &1.6446E-05,3.3891E-05,3.6329E-05,3.4426E-05,8.9453E-06,
     &3.0202E-05,5.3874E-05,5.4799E-05,4.8960E-05,9.6374E-06/
      DATA ((KB(JS,JT,13, 5),JS=1,5),JT=1,5) /
     &4.3236E-01,4.3213E-01,3.9701E-01,3.2546E-01,1.1197E-01,
     &6.6372E-01,6.1379E-01,5.3578E-01,4.1378E-01,1.1749E-01,
     &9.6012E-01,8.4543E-01,7.0690E-01,5.2039E-01,1.2229E-01,
     &1.3340E+00,1.1343E+00,9.1491E-01,6.4651E-01,1.2717E-01,
     &1.8059E+00,1.4945E+00,1.1687E+00,7.9501E-01,1.3200E-01/
      DATA ((KB(JS,JT,14, 5),JS=1,5),JT=1,5) /
     &2.3576E-01,2.7360E-01,2.7141E-01,2.4039E-01,9.8792E-02,
     &3.5903E-01,3.7743E-01,3.5638E-01,2.9754E-01,1.0359E-01,
     &5.1761E-01,5.0746E-01,4.5981E-01,3.6575E-01,1.0816E-01,
     &7.1963E-01,6.6997E-01,5.8434E-01,4.4555E-01,1.1272E-01,
     &9.7673E-01,8.7084E-01,7.3356E-01,5.3881E-01,1.1732E-01/
      DATA ((KB(JS,JT,15, 5),JS=1,5),JT=1,5) /
     &1.3110E-01,1.8103E-01,1.9281E-01,1.8264E-01,8.6582E-02,
     &1.9817E-01,2.4413E-01,2.4684E-01,2.2172E-01,9.0925E-02,
     &2.8519E-01,3.2198E-01,3.1178E-01,2.6742E-01,9.5231E-02,
     &3.9693E-01,4.1797E-01,3.8987E-01,3.1982E-01,9.9470E-02,
     &5.3979E-01,5.3546E-01,4.8283E-01,3.8058E-01,1.0367E-01/
      DATA ((KB(JS,JT,16, 5),JS=1,5),JT=1,5) /
     &8.6780E-02,1.3641E-01,1.5186E-01,1.4818E-01,7.5514E-02,
     &1.3047E-01,1.8113E-01,1.9135E-01,1.7835E-01,7.9533E-02,
     &1.8753E-01,2.3639E-01,2.3875E-01,2.1304E-01,8.3481E-02,
     &2.6140E-01,3.0428E-01,2.9551E-01,2.5256E-01,8.7293E-02,
     &3.5574E-01,3.8652E-01,3.6267E-01,2.9793E-01,9.1094E-02/
      DATA ((KB(JS,JT,17, 5),JS=1,5),JT=1,5) /
     &5.9400E-02,1.0544E-01,1.2175E-01,1.2140E-01,6.5571E-02,
     &8.8982E-02,1.3824E-01,1.5175E-01,1.4491E-01,6.9197E-02,
     &1.2788E-01,1.7890E-01,1.8755E-01,1.7185E-01,7.2708E-02,
     &1.7835E-01,2.2856E-01,2.3024E-01,2.0241E-01,7.6161E-02,
     &2.4297E-01,2.8834E-01,2.8043E-01,2.3722E-01,7.9603E-02/
      DATA ((KB(JS,JT,18, 5),JS=1,5),JT=1,5) /
     &4.1651E-02,8.2911E-02,9.8455E-02,9.9593E-02,5.6662E-02,
     &6.2251E-02,1.0765E-01,1.2173E-01,1.1843E-01,5.9831E-02,
     &8.9419E-02,1.3828E-01,1.4944E-01,1.3970E-01,6.2923E-02,
     &1.2470E-01,1.7541E-01,1.8216E-01,1.6372E-01,6.6077E-02,
     &1.6992E-01,2.1986E-01,2.2047E-01,1.9095E-01,6.9212E-02/
      DATA ((KB(JS,JT,19, 5),JS=1,5),JT=1,5) /
     &2.8717E-02,6.4742E-02,7.8819E-02,8.0895E-02,4.8664E-02,
     &4.2849E-02,8.3244E-02,9.6815E-02,9.5751E-02,5.1433E-02,
     &6.1454E-02,1.0605E-01,1.1801E-01,1.1248E-01,5.4215E-02,
     &8.5699E-02,1.3356E-01,1.4292E-01,1.3115E-01,5.7031E-02,
     &1.1681E-01,1.6622E-01,1.7182E-01,1.5204E-01,5.9790E-02/
      DATA ((KB(JS,JT,20, 5),JS=1,5),JT=1,5) /
     &2.1632E-02,5.2943E-02,6.5235E-02,6.7363E-02,4.1610E-02,
     &3.2163E-02,6.7696E-02,7.9852E-02,7.9447E-02,4.4062E-02,
     &4.6057E-02,8.5815E-02,9.6980E-02,9.3049E-02,4.6553E-02,
     &6.4136E-02,1.0754E-01,1.1694E-01,1.0820E-01,4.9013E-02,
     &8.7379E-02,1.3322E-01,1.3995E-01,1.2502E-01,5.1455E-02/
      DATA ((KB(JS,JT,21, 5),JS=1,5),JT=1,5) /
     &1.6823E-02,4.3877E-02,5.4527E-02,5.6402E-02,3.5455E-02,
     &2.4936E-02,5.5953E-02,6.6511E-02,6.6307E-02,3.7602E-02,
     &3.5634E-02,7.0642E-02,8.0513E-02,7.7454E-02,3.9786E-02,
     &4.9531E-02,8.8177E-02,9.6745E-02,8.9935E-02,4.1920E-02,
     &6.7455E-02,1.0884E-01,1.1539E-01,1.0375E-01,4.4030E-02/
      DATA ((KB(JS,JT,22, 5),JS=1,5),JT=1,5) /
     &1.3789E-02,3.7331E-02,4.6413E-02,4.7878E-02,3.0220E-02,
     &2.0294E-02,4.7459E-02,5.6444E-02,5.6212E-02,3.2091E-02,
     &2.8887E-02,5.9685E-02,6.8142E-02,6.5522E-02,3.3949E-02,
     &4.0024E-02,7.4193E-02,8.1621E-02,7.5940E-02,3.5793E-02,
     &5.4487E-02,9.1298E-02,9.7079E-02,8.7446E-02,3.7515E-02/
      DATA ((KB(JS,JT,23, 5),JS=1,5),JT=1,5) /
     &1.1373E-02,3.1797E-02,3.9445E-02,4.0631E-02,2.5676E-02,
     &1.6630E-02,4.0276E-02,4.7874E-02,4.7621E-02,2.7276E-02,
     &2.3572E-02,5.0445E-02,5.7632E-02,5.5405E-02,2.8857E-02,
     &3.2590E-02,6.2506E-02,6.8883E-02,6.4105E-02,3.0360E-02,
     &4.4383E-02,7.6716E-02,8.1703E-02,7.3646E-02,3.1632E-02/
      DATA ((KB(JS,JT,24, 5),JS=1,5),JT=1,5) /
     &9.3521E-03,2.6988E-02,3.3405E-02,3.4382E-02,2.1758E-02,
     &1.3592E-02,3.4040E-02,4.0452E-02,4.0217E-02,2.3106E-02,
     &1.9190E-02,4.2486E-02,4.8570E-02,4.6701E-02,2.4399E-02,
     &2.6527E-02,5.2454E-02,5.7886E-02,5.3878E-02,2.5528E-02,
     &3.6127E-02,6.4240E-02,6.8480E-02,6.1740E-02,2.6418E-02/
      DATA ((KB(JS,JT,25, 5),JS=1,5),JT=1,5) /
     &7.8143E-03,2.3046E-02,2.8423E-02,2.9180E-02,1.8391E-02,
     &1.1292E-02,2.8965E-02,3.4350E-02,3.4059E-02,1.9498E-02,
     &1.5906E-02,3.6033E-02,4.1158E-02,3.9460E-02,2.0484E-02,
     &2.2015E-02,4.4387E-02,4.8915E-02,4.5425E-02,2.1291E-02,
     &2.9929E-02,5.4292E-02,5.7748E-02,5.1892E-02,2.1939E-02/
      DATA ((KB(JS,JT,26, 5),JS=1,5),JT=1,5) /
     &6.6841E-03,1.9882E-02,2.4386E-02,2.4902E-02,1.5507E-02,
     &9.6187E-03,2.4917E-02,2.9404E-02,2.8998E-02,1.6368E-02,
     &1.3541E-02,3.0916E-02,3.5147E-02,3.3522E-02,1.7088E-02,
     &1.8734E-02,3.8045E-02,4.1676E-02,3.8461E-02,1.7679E-02,
     &2.5382E-02,4.6534E-02,4.9183E-02,4.3795E-02,1.8164E-02/
      DATA ((KB(JS,JT,27, 5),JS=1,5),JT=1,5) /
     &5.9464E-03,1.7461E-02,2.1207E-02,2.1457E-02,1.3019E-02,
     &8.5411E-03,2.1855E-02,2.5534E-02,2.4945E-02,1.3658E-02,
     &1.2012E-02,2.7098E-02,3.0472E-02,2.8773E-02,1.4192E-02,
     &1.6580E-02,3.3382E-02,3.6146E-02,3.2904E-02,1.4638E-02,
     &2.2392E-02,4.0890E-02,4.2671E-02,3.7399E-02,1.5005E-02/
      DATA ((KB(JS,JT,28, 5),JS=1,5),JT=1,5) /
     &5.4489E-03,1.5531E-02,1.8614E-02,1.8613E-02,1.0873E-02,
     &7.8148E-03,1.9440E-02,2.2401E-02,2.1604E-02,1.1349E-02,
     &1.0969E-02,2.4138E-02,2.6729E-02,2.4848E-02,1.1757E-02,
     &1.5087E-02,2.9815E-02,3.1728E-02,2.8368E-02,1.2101E-02,
     &2.0299E-02,3.6555E-02,3.7502E-02,3.2280E-02,1.2378E-02/
      DATA ((KB(JS,JT,29, 5),JS=1,5),JT=1,5) /
     &5.3270E-03,1.4285E-02,1.6775E-02,1.6453E-02,9.0474E-03,
     &7.6276E-03,1.7927E-02,2.0207E-02,1.9083E-02,9.4132E-03,
     &1.0673E-02,2.2373E-02,2.4172E-02,2.1940E-02,9.7284E-03,
     &1.4614E-02,2.7730E-02,2.8795E-02,2.5116E-02,9.9926E-03,
     &1.9579E-02,3.4081E-02,3.4110E-02,2.8684E-02,1.0207E-02/
      DATA ((KB(JS,JT,30, 5),JS=1,5),JT=1,5) /
     &5.3535E-03,1.3353E-02,1.5300E-02,1.4666E-02,7.5129E-03,
     &7.6380E-03,1.6853E-02,1.8473E-02,1.7010E-02,7.7968E-03,
     &1.0647E-02,2.1132E-02,2.2202E-02,1.9612E-02,8.0434E-03,
     &1.4510E-02,2.6289E-02,2.6550E-02,2.2553E-02,8.2450E-03,
     &1.9367E-02,3.2371E-02,3.1546E-02,2.5868E-02,8.4082E-03/
      DATA ((KB(JS,JT,31, 5),JS=1,5),JT=1,5) /
     &5.6746E-03,1.2936E-02,1.4343E-02,1.3343E-02,6.2303E-03,
     &8.0577E-03,1.6447E-02,1.7425E-02,1.5532E-02,6.4556E-03,
     &1.1174E-02,2.0739E-02,2.1078E-02,1.8020E-02,6.6441E-03,
     &1.5165E-02,2.5916E-02,2.5346E-02,2.0861E-02,6.8034E-03,
     &2.0188E-02,3.1999E-02,3.0259E-02,2.4055E-02,6.9268E-03/
      DATA ((KB(JS,JT,32, 5),JS=1,5),JT=1,5) /
     &6.0895E-03,1.2732E-02,1.3622E-02,1.2258E-02,5.1656E-03,
     &8.5996E-03,1.6298E-02,1.6681E-02,1.4366E-02,5.3392E-03,
     &1.1871E-02,2.0666E-02,2.0302E-02,1.6787E-02,5.4899E-03,
     &1.6059E-02,2.5901E-02,2.4547E-02,1.9547E-02,5.6119E-03,
     &2.1313E-02,3.2082E-02,2.9454E-02,2.2664E-02,5.7070E-03/
      DATA ((KB(JS,JT,33, 5),JS=1,5),JT=1,5) /
     &6.6515E-03,1.2796E-02,1.3188E-02,1.1442E-02,4.2781E-03,
     &9.3384E-03,1.6485E-02,1.6266E-02,1.3517E-02,4.4167E-03,
     &1.2846E-02,2.0999E-02,1.9943E-02,1.5910E-02,4.5341E-03,
     &1.7327E-02,2.6399E-02,2.4247E-02,1.8651E-02,4.6303E-03,
     &2.2895E-02,3.2829E-02,2.9267E-02,2.1750E-02,4.7019E-03/
      DATA ((KB(JS,JT,34, 5),JS=1,5),JT=1,5) /
     &6.9862E-03,1.2631E-02,1.2600E-02,1.0591E-02,3.5376E-03,
     &9.7726E-03,1.6353E-02,1.5653E-02,1.2600E-02,3.6473E-03,
     &1.3409E-02,2.0887E-02,1.9295E-02,1.4929E-02,3.7406E-03,
     &1.8037E-02,2.6346E-02,2.3581E-02,1.7591E-02,3.8148E-03,
     &2.3704E-02,3.2885E-02,2.8616E-02,2.0638E-02,3.8707E-03/
      DATA ((KB(JS,JT,35, 5),JS=1,5),JT=1,5) /
     &7.0977E-03,1.2235E-02,1.1878E-02,9.7122E-03,2.9156E-03,
     &9.9249E-03,1.5915E-02,1.4862E-02,1.1642E-02,3.0042E-03,
     &1.3615E-02,2.0413E-02,1.8425E-02,1.3882E-02,3.0791E-03,
     &1.8271E-02,2.5881E-02,2.2655E-02,1.6461E-02,3.1387E-03,
     &2.3900E-02,3.2414E-02,2.7651E-02,1.9450E-02,3.1837E-03/
      DATA ((KB(JS,JT,36, 5),JS=1,5),JT=1,5) /
     &6.9060E-03,1.1498E-02,1.0932E-02,8.7493E-03,2.3952E-03,
     &9.6735E-03,1.5042E-02,1.3779E-02,1.0573E-02,2.4672E-03,
     &1.3291E-02,1.9415E-02,1.7205E-02,1.2691E-02,2.5290E-03,
     &1.7820E-02,2.4753E-02,2.1299E-02,1.5151E-02,2.5791E-03,
     &2.3253E-02,3.1113E-02,2.6141E-02,1.8030E-02,2.6175E-03/
      DATA ((KB(JS,JT,37, 5),JS=1,5),JT=1,5) /
     &6.2139E-03,1.0192E-02,9.5802E-03,7.5798E-03,1.9567E-03,
     &8.7456E-03,1.3428E-02,1.2164E-02,9.2244E-03,2.0181E-03,
     &1.2068E-02,1.7456E-02,1.5302E-02,1.1147E-02,2.0706E-03,
     &1.6229E-02,2.2411E-02,1.9089E-02,1.3408E-02,2.1134E-03,
     &2.1208E-02,2.8314E-02,2.3560E-02,1.6063E-02,2.1467E-03/
      DATA ((KB(JS,JT,38, 5),JS=1,5),JT=1,5) /
     &5.6546E-03,9.1081E-03,8.4597E-03,6.6101E-03,1.5995E-03,
     &7.9966E-03,1.2093E-02,1.0832E-02,8.1085E-03,1.6506E-03,
     &1.1084E-02,1.5851E-02,1.3740E-02,9.8767E-03,1.6948E-03,
     &1.4944E-02,2.0494E-02,1.7272E-02,1.1975E-02,1.7322E-03,
     &1.9571E-02,2.6031E-02,2.1445E-02,1.4447E-02,1.7614E-03/
      DATA ((KB(JS,JT,39, 5),JS=1,5),JT=1,5) /
     &5.2606E-03,8.2861E-03,7.5918E-03,5.8448E-03,1.3077E-03,
     &7.4758E-03,1.1098E-02,9.8108E-03,7.2343E-03,1.3505E-03,
     &1.0407E-02,1.4668E-02,1.2553E-02,8.8880E-03,1.3888E-03,
     &1.4072E-02,1.9102E-02,1.5911E-02,1.0872E-02,1.4211E-03,
     &1.8472E-02,2.4391E-02,1.9883E-02,1.3211E-02,1.4470E-03/
      DATA ((KB(JS,JT,40, 5),JS=1,5),JT=1,5) /
     &4.4239E-03,6.9683E-03,6.3619E-03,4.8825E-03,1.0643E-03,
     &6.3289E-03,9.4143E-03,8.2870E-03,6.0882E-03,1.1007E-03,
     &8.8723E-03,1.2550E-02,1.0689E-02,7.5344E-03,1.1340E-03,
     &1.2075E-02,1.6469E-02,1.3655E-02,9.2842E-03,1.1620E-03,
     &1.5933E-02,2.1174E-02,1.7180E-02,1.1354E-02,1.1848E-03/
      DATA ((KB(JS,JT,41, 5),JS=1,5),JT=1,5) /
     &3.6867E-03,5.8128E-03,5.2949E-03,4.0553E-03,8.6561E-04,
     &5.3143E-03,7.9271E-03,6.9551E-03,5.0947E-03,8.9710E-04,
     &7.5044E-03,1.0658E-02,9.0449E-03,6.3522E-03,9.2517E-04,
     &1.0281E-02,1.4099E-02,1.1643E-02,7.8856E-03,9.4938E-04,
     &1.3649E-02,1.8248E-02,1.4748E-02,9.7057E-03,9.6963E-04/
      DATA ((KB(JS,JT,42, 5),JS=1,5),JT=1,5) /
     &3.0985E-03,4.8781E-03,4.4299E-03,3.3820E-03,7.0400E-04,
     &4.5009E-03,6.7165E-03,5.8698E-03,4.2829E-03,7.3071E-04,
     &6.4001E-03,9.1103E-03,7.7007E-03,5.3843E-03,7.5479E-04,
     &8.8324E-03,1.2154E-02,9.9941E-03,6.7362E-03,7.7572E-04,
     &1.1799E-02,1.5850E-02,1.2750E-02,8.3487E-03,7.9315E-04/
      DATA ((KB(JS,JT,43, 5),JS=1,5),JT=1,5) /
     &2.5629E-03,4.0329E-03,3.6588E-03,2.7901E-03,5.7114E-04,
     &3.7578E-03,5.6142E-03,4.8977E-03,3.5662E-03,5.9379E-04,
     &5.3881E-03,7.6915E-03,6.4844E-03,4.5229E-03,6.1455E-04,
     &7.5091E-03,1.0367E-02,8.4990E-03,5.7086E-03,6.3259E-04,
     &1.0110E-02,1.3645E-02,1.0937E-02,7.1314E-03,6.4809E-04/
      DATA ((KB(JS,JT,44, 5),JS=1,5),JT=1,5) /
     &2.1195E-03,3.3263E-03,3.0153E-03,2.2974E-03,4.6259E-04,
     &3.1405E-03,4.6890E-03,4.0834E-03,2.9671E-03,4.8211E-04,
     &4.5449E-03,6.4956E-03,5.4625E-03,3.8015E-03,4.9986E-04,
     &6.4001E-03,8.8502E-03,7.2321E-03,4.8421E-03,5.1551E-04,
     &8.6977E-03,1.1779E-02,9.4064E-03,6.1062E-03,5.2910E-04/
      DATA ((KB(JS,JT,45, 5),JS=1,5),JT=1,5) /
     &1.7814E-03,2.7759E-03,2.5092E-03,1.9068E-03,3.7475E-04,
     &2.6678E-03,3.9635E-03,3.4407E-03,2.4906E-03,3.9120E-04,
     &3.8999E-03,5.5595E-03,4.6558E-03,3.2267E-03,4.0640E-04,
     &5.5475E-03,7.6646E-03,6.2331E-03,4.1536E-03,4.1988E-04,
     &7.6146E-03,1.0314E-02,8.1967E-03,5.2910E-03,4.3189E-04/
      DATA ((KB(JS,JT,46, 5),JS=1,5),JT=1,5) /
     &1.4913E-03,2.3049E-03,2.0781E-03,1.5752E-03,3.0303E-04,
     &2.2619E-03,3.3394E-03,2.8896E-03,2.0839E-03,3.1705E-04,
     &3.3424E-03,4.7455E-03,3.9592E-03,2.7324E-03,3.2997E-04,
     &4.8041E-03,6.6271E-03,5.3667E-03,3.5579E-03,3.4174E-04,
     &6.6700E-03,9.0306E-03,7.1468E-03,4.5847E-03,3.5220E-04/
      DATA ((KB(JS,JT,47, 5),JS=1,5),JT=1,5) /
     &1.2089E-03,1.8595E-03,1.6774E-03,1.2733E-03,2.4435E-04,
     &1.8589E-03,2.7359E-03,2.3669E-03,1.7064E-03,2.5622E-04,
     &2.7805E-03,3.9417E-03,3.2867E-03,2.2649E-03,2.6731E-04,
     &4.0468E-03,5.5810E-03,4.5086E-03,2.9823E-03,2.7740E-04,
     &5.6890E-03,7.7116E-03,6.0862E-03,3.8914E-03,2.8663E-04/
      DATA ((KB(JS,JT,48, 5),JS=1,5),JT=1,5) /
     &1.0010E-03,1.5219E-03,1.3705E-03,1.0399E-03,1.9690E-04,
     &1.5623E-03,2.2781E-03,1.9661E-03,1.4139E-03,2.0690E-04,
     &2.3663E-03,3.3328E-03,2.7724E-03,1.9027E-03,2.1643E-04,
     &3.4895E-03,4.7876E-03,3.8543E-03,2.5388E-03,2.2513E-04,
     &4.9716E-03,6.7160E-03,5.2797E-03,3.3578E-03,2.3320E-04/
      DATA ((KB(JS,JT,49, 5),JS=1,5),JT=1,5) /
     &8.5765E-04,1.2765E-03,1.1434E-03,8.6362E-04,1.5857E-04,
     &1.3602E-03,1.9488E-03,1.6723E-03,1.1956E-03,1.6712E-04,
     &2.0873E-03,2.8996E-03,2.4000E-03,1.6350E-03,1.7515E-04,
     &3.1195E-03,4.2309E-03,3.3880E-03,2.2146E-03,1.8269E-04,
     &4.5042E-03,6.0317E-03,4.7143E-03,2.9742E-03,1.8971E-04/
      DATA ((KB(JS,JT,50, 5),JS=1,5),JT=1,5) /
     &7.0327E-04,1.0357E-03,9.2617E-04,6.9913E-04,1.2768E-04,
     &1.1341E-03,1.6088E-03,1.3773E-03,9.8362E-04,1.3488E-04,
     &1.7633E-03,2.4334E-03,2.0087E-03,1.3647E-03,1.4174E-04,
     &2.6686E-03,3.6011E-03,2.8760E-03,1.8731E-03,1.4819E-04,
     &3.9042E-03,5.2110E-03,4.0582E-03,2.5499E-03,1.5417E-04/
      DATA ((KB(JS,JT,51, 5),JS=1,5),JT=1,5) /
     &5.6283E-04,8.2479E-04,7.3777E-04,5.5772E-04,1.0280E-04,
     &9.2490E-04,1.3030E-03,1.1149E-03,7.9673E-04,1.0882E-04,
     &1.4569E-03,2.0026E-03,1.6508E-03,1.1213E-03,1.1463E-04,
     &2.2322E-03,3.0043E-03,2.3967E-03,1.5580E-03,1.2010E-04,
     &3.3090E-03,4.4133E-03,3.4281E-03,2.1477E-03,1.2516E-04/
      DATA ((KB(JS,JT,52, 5),JS=1,5),JT=1,5) /
     &4.5964E-04,6.6706E-04,5.9570E-04,4.4969E-04,8.2695E-05,
     &7.7113E-04,1.0739E-03,9.1646E-04,6.5362E-04,8.7774E-05,
     &1.2329E-03,1.6791E-03,1.3796E-03,9.3460E-04,9.2675E-05,
     &1.9124E-03,2.5569E-03,2.0345E-03,1.3172E-03,9.7314E-05,
     &2.8744E-03,3.8139E-03,2.9526E-03,1.8404E-03,1.0157E-04/
      DATA ((KB(JS,JT,53, 5),JS=1,5),JT=1,5) /
     &3.8730E-04,5.5282E-04,4.9108E-04,3.6874E-04,6.6480E-05,
     &6.6529E-04,9.0913E-04,7.7130E-04,5.4660E-04,7.0743E-05,
     &1.0811E-03,1.4483E-03,1.1832E-03,7.9661E-04,7.4902E-05,
     &1.6977E-03,2.2425E-03,1.7750E-03,1.1419E-03,7.8801E-05,
     &2.5875E-03,3.3978E-03,2.6180E-03,1.6189E-03,8.2434E-05/
      DATA ((KB(JS,JT,54, 5),JS=1,5),JT=1,5) /
     &2.8438E-04,4.1240E-04,3.6923E-04,2.8032E-04,5.3391E-05,
     &5.0038E-04,6.8881E-04,5.8764E-04,4.1957E-04,5.6986E-05,
     &8.2710E-04,1.1130E-03,9.1323E-04,6.1896E-04,6.0464E-05,
     &1.3140E-03,1.7467E-03,1.3863E-03,8.9674E-04,6.3698E-05,
     &2.0289E-03,2.6791E-03,2.0677E-03,1.2826E-03,6.6754E-05/
      DATA ((KB(JS,JT,55, 5),JS=1,5),JT=1,5) /
     &1.9032E-04,2.8714E-04,2.6164E-04,2.0312E-04,4.2857E-05,
     &3.4354E-04,4.8514E-04,4.1940E-04,3.0487E-04,4.5872E-05,
     &5.7798E-04,7.9314E-04,6.5789E-04,4.5289E-04,4.8737E-05,
     &9.2977E-04,1.2582E-03,1.0072E-03,6.6019E-04,5.1425E-05,
     &1.4533E-03,1.9484E-03,1.5135E-03,9.4927E-04,5.3965E-05/
      DATA ((KB(JS,JT,56, 5),JS=1,5),JT=1,5) /
     &1.2624E-04,1.9945E-04,1.8526E-04,1.4713E-04,3.4367E-05,
     &2.3425E-04,3.4034E-04,2.9855E-04,2.2108E-04,3.6885E-05,
     &4.0201E-04,5.6312E-04,4.7257E-04,3.3069E-04,3.9253E-05,
     &6.5545E-04,9.0280E-04,7.2955E-04,4.8511E-04,4.1521E-05,
     &1.0372E-03,1.4120E-03,1.1051E-03,7.0135E-04,4.3631E-05/
      DATA ((KB(JS,JT,57, 5),JS=1,5),JT=1,5) /
     &8.2825E-05,1.3826E-04,1.3105E-04,1.0648E-04,2.7541E-05,
     &1.5848E-04,2.3765E-04,2.1180E-04,1.6006E-04,2.9646E-05,
     &2.7802E-04,3.9802E-04,3.3815E-04,2.4085E-04,3.1604E-05,
     &4.6014E-04,6.4521E-04,5.2696E-04,3.5556E-04,3.3502E-05,
     &7.3676E-04,1.0192E-03,8.0418E-04,5.1690E-04,3.5248E-05/
      DATA ((KB(JS,JT,58, 5),JS=1,5),JT=1,5) /
     &1.4413E-05,3.1415E-05,3.9206E-05,4.5793E-05,2.2070E-05,
     &2.8319E-05,5.4166E-05,6.3295E-05,6.8680E-05,2.3823E-05,
     &5.0851E-05,9.1643E-05,1.0172E-04,1.0358E-04,2.5450E-05,
     &8.5536E-05,1.4999E-04,1.5967E-04,1.5367E-04,2.7016E-05,
     &1.3845E-04,2.3895E-04,2.4509E-04,2.2418E-04,2.8488E-05/
      DATA ((KB(JS,JT,59, 5),JS=1,5),JT=1,5) /
     &1.2766E-05,2.9930E-05,3.6342E-05,3.9546E-05,1.7924E-05,
     &2.5308E-05,5.0886E-05,5.7559E-05,5.8137E-05,1.9351E-05,
     &4.5886E-05,8.5371E-05,9.1314E-05,8.6129E-05,2.0681E-05,
     &7.7783E-05,1.3897E-04,1.4192E-04,1.2608E-04,2.1937E-05,
     &1.2671E-04,2.2060E-04,2.1586E-04,1.8160E-04,2.3122E-05/
      DATA ((KB(JS,JT,13, 6),JS=1,5),JT=1,5) /
     &1.2091E+00,1.0925E+00,9.7132E-01,7.6832E-01,2.2429E-01,
     &1.8464E+00,1.5640E+00,1.2977E+00,9.6738E-01,2.2945E-01,
     &2.7006E+00,2.1933E+00,1.7174E+00,1.2089E+00,2.3586E-01,
     &3.8041E+00,3.0098E+00,2.2534E+00,1.4966E+00,2.4148E-01,
     &5.1874E+00,4.0404E+00,2.9277E+00,1.8384E+00,2.4717E-01/
      DATA ((KB(JS,JT,14, 6),JS=1,5),JT=1,5) /
     &6.6672E-01,6.8855E-01,6.6353E-01,5.5608E-01,2.0092E-01,
     &1.0160E+00,9.4963E-01,8.6392E-01,6.8590E-01,2.0621E-01,
     &1.4836E+00,1.2937E+00,1.1112E+00,8.3934E-01,2.1228E-01,
     &2.0856E+00,1.7366E+00,1.4142E+00,1.0186E+00,2.1791E-01,
     &2.8402E+00,2.2928E+00,1.7814E+00,1.2275E+00,2.2338E-01/
      DATA ((KB(JS,JT,15, 6),JS=1,5),JT=1,5) /
     &3.7534E-01,4.5732E-01,4.6750E-01,4.0917E-01,1.7874E-01,
     &5.7029E-01,6.1390E-01,5.9540E-01,4.9734E-01,1.8407E-01,
     &8.2994E-01,8.1258E-01,7.5038E-01,5.9870E-01,1.8982E-01,
     &1.1635E+00,1.0593E+00,9.3529E-01,7.1512E-01,1.9538E-01,
     &1.5834E+00,1.3649E+00,1.1537E+00,8.4763E-01,2.0092E-01/
      DATA ((KB(JS,JT,16, 6),JS=1,5),JT=1,5) /
     &2.5139E-01,3.4640E-01,3.6560E-01,3.2723E-01,1.5796E-01,
     &3.8033E-01,4.5844E-01,4.5962E-01,3.9345E-01,1.6322E-01,
     &5.5135E-01,5.9731E-01,5.7234E-01,4.6896E-01,1.6890E-01,
     &7.7178E-01,7.6699E-01,7.0504E-01,5.5557E-01,1.7446E-01,
     &1.0505E+00,9.7332E-01,8.6035E-01,6.5296E-01,1.7998E-01/
      DATA ((KB(JS,JT,17, 6),JS=1,5),JT=1,5) /
     &1.7391E-01,2.6830E-01,2.8935E-01,2.6535E-01,1.3871E-01,
     &2.6196E-01,3.5091E-01,3.6089E-01,3.1647E-01,1.4388E-01,
     &3.7888E-01,4.5188E-01,4.4522E-01,3.7420E-01,1.4950E-01,
     &5.3041E-01,5.7470E-01,5.4379E-01,4.3949E-01,1.5497E-01,
     &7.2254E-01,7.2344E-01,6.5849E-01,5.1285E-01,1.6018E-01/
      DATA ((KB(JS,JT,18, 6),JS=1,5),JT=1,5) /
     &1.2310E-01,2.1053E-01,2.3152E-01,2.1713E-01,1.2112E-01,
     &1.8497E-01,2.7232E-01,2.8648E-01,2.5684E-01,1.2635E-01,
     &2.6727E-01,3.4798E-01,3.5045E-01,3.0154E-01,1.3167E-01,
     &3.7442E-01,4.3958E-01,4.2522E-01,3.5185E-01,1.3670E-01,
     &5.0994E-01,5.4989E-01,5.1174E-01,4.0832E-01,1.4125E-01/
      DATA ((KB(JS,JT,19, 6),JS=1,5),JT=1,5) /
     &8.5532E-02,1.6314E-01,1.8367E-01,1.7636E-01,1.0532E-01,
     &1.2828E-01,2.0893E-01,2.2484E-01,2.0705E-01,1.1032E-01,
     &1.8543E-01,2.6474E-01,2.7268E-01,2.4148E-01,1.1512E-01,
     &2.5984E-01,3.3238E-01,3.2852E-01,2.8001E-01,1.1952E-01,
     &3.5320E-01,4.1295E-01,3.9317E-01,3.2333E-01,1.2366E-01/
      DATA ((KB(JS,JT,20, 6),JS=1,5),JT=1,5) /
     &6.4796E-02,1.3254E-01,1.5120E-01,1.4730E-01,9.1341E-02,
     &9.6990E-02,1.6885E-01,1.8400E-01,1.7239E-01,9.5796E-02,
     &1.4017E-01,2.1315E-01,2.2212E-01,2.0058E-01,9.9929E-02,
     &1.9600E-01,2.6649E-01,2.6658E-01,2.3206E-01,1.0386E-01,
     &2.6559E-01,3.2963E-01,3.1802E-01,2.6726E-01,1.0762E-01/
      DATA ((KB(JS,JT,21, 6),JS=1,5),JT=1,5) /
     &5.0649E-02,1.0928E-01,1.2583E-01,1.2405E-01,7.8779E-02,
     &7.5738E-02,1.3875E-01,1.5264E-01,1.4489E-01,8.2609E-02,
     &1.0925E-01,1.7464E-01,1.8399E-01,1.6832E-01,8.6258E-02,
     &1.5216E-01,2.1765E-01,2.2035E-01,1.9451E-01,8.9821E-02,
     &2.0550E-01,2.6822E-01,2.6230E-01,2.2354E-01,9.3160E-02/
      DATA ((KB(JS,JT,22, 6),JS=1,5),JT=1,5) /
     &4.1767E-02,9.2608E-02,1.0699E-01,1.0611E-01,6.7766E-02,
     &6.2192E-02,1.1726E-01,1.2959E-01,1.2363E-01,7.1096E-02,
     &8.9136E-02,1.4711E-01,1.5605E-01,1.4343E-01,7.4363E-02,
     &1.2346E-01,1.8283E-01,1.8672E-01,1.6558E-01,7.7494E-02,
     &1.6595E-01,2.2428E-01,2.2184E-01,1.9008E-01,8.0478E-02/
      DATA ((KB(JS,JT,23, 6),JS=1,5),JT=1,5) /
     &3.4739E-02,7.8664E-02,9.1136E-02,9.0610E-02,5.8065E-02,
     &5.1379E-02,9.9376E-02,1.1032E-01,1.0537E-01,6.0980E-02,
     &7.3154E-02,1.2441E-01,1.3261E-01,1.2218E-01,6.3866E-02,
     &1.0075E-01,1.5392E-01,1.5845E-01,1.4087E-01,6.6610E-02,
     &1.3481E-01,1.8817E-01,1.8784E-01,1.6172E-01,6.9269E-02/
      DATA ((KB(JS,JT,24, 6),JS=1,5),JT=1,5) /
     &2.8818E-02,6.6682E-02,7.7471E-02,7.7057E-02,4.9574E-02,
     &4.2313E-02,8.4062E-02,9.3582E-02,8.9537E-02,5.2146E-02,
     &5.9843E-02,1.0485E-01,1.1232E-01,1.0372E-01,5.4645E-02,
     &8.1952E-02,1.2924E-01,1.3388E-01,1.1954E-01,5.7051E-02,
     &1.0925E-01,1.5756E-01,1.5837E-01,1.3710E-01,5.9328E-02/
      DATA ((KB(JS,JT,25, 6),JS=1,5),JT=1,5) /
     &2.4289E-02,5.7018E-02,6.6182E-02,6.5743E-02,4.2224E-02,
     &3.5371E-02,7.1685E-02,7.9860E-02,7.6400E-02,4.4451E-02,
     &4.9695E-02,8.9091E-02,9.5704E-02,8.8452E-02,4.6603E-02,
     &6.7687E-02,1.0953E-01,1.1385E-01,1.0188E-01,4.8655E-02,
     &9.0080E-02,1.3324E-01,1.3448E-01,1.1679E-01,5.0366E-02/
      DATA ((KB(JS,JT,26, 6),JS=1,5),JT=1,5) /
     &2.0940E-02,4.9340E-02,5.7029E-02,5.6467E-02,3.5910E-02,
     &3.0229E-02,6.1848E-02,6.8786E-02,6.5644E-02,3.7816E-02,
     &4.2173E-02,7.6666E-02,8.2327E-02,7.6015E-02,3.9629E-02,
     &5.7238E-02,9.4072E-02,9.7854E-02,8.7548E-02,4.1173E-02,
     &7.6058E-02,1.1436E-01,1.1545E-01,1.0034E-01,4.2300E-02/
      DATA ((KB(JS,JT,27, 6),JS=1,5),JT=1,5) /
     &1.8730E-02,4.3572E-02,4.9937E-02,4.9064E-02,3.0474E-02,
     &2.6831E-02,5.4541E-02,6.0259E-02,5.7134E-02,3.2064E-02,
     &3.7216E-02,6.7578E-02,7.2151E-02,6.6197E-02,3.3458E-02,
     &5.0417E-02,8.2889E-02,8.5762E-02,7.6299E-02,3.4507E-02,
     &6.6884E-02,1.0088E-01,1.0129E-01,8.7542E-02,3.5247E-02/
      DATA ((KB(JS,JT,28, 6),JS=1,5),JT=1,5) /
     &1.7190E-02,3.9051E-02,4.4263E-02,4.3005E-02,2.5796E-02,
     &2.4452E-02,4.8897E-02,5.3477E-02,5.0169E-02,2.7044E-02,
     &3.3807E-02,6.0596E-02,6.4111E-02,5.8195E-02,2.8015E-02,
     &4.5722E-02,7.4408E-02,7.6314E-02,6.7197E-02,2.8722E-02,
     &6.0503E-02,9.0881E-02,9.0351E-02,7.7127E-02,2.9243E-02/
      DATA ((KB(JS,JT,29, 6),JS=1,5),JT=1,5) /
     &1.6778E-02,3.6309E-02,4.0421E-02,3.8540E-02,2.1757E-02,
     &2.3732E-02,4.5567E-02,4.8987E-02,4.5076E-02,2.2654E-02,
     &3.2754E-02,5.6621E-02,5.8900E-02,5.2465E-02,2.3325E-02,
     &4.4197E-02,6.9861E-02,7.0379E-02,6.0698E-02,2.3826E-02,
     &5.8243E-02,8.5699E-02,8.3806E-02,6.9875E-02,2.4188E-02/
      DATA ((KB(JS,JT,30, 6),JS=1,5),JT=1,5) /
     &1.6788E-02,3.4359E-02,3.7447E-02,3.4898E-02,1.8241E-02,
     &2.3674E-02,4.3260E-02,4.5554E-02,4.0970E-02,1.8874E-02,
     &3.2611E-02,5.3991E-02,5.4995E-02,4.7819E-02,1.9352E-02,
     &4.3823E-02,6.7000E-02,6.6123E-02,5.5495E-02,1.9717E-02,
     &5.7496E-02,8.2562E-02,7.9216E-02,6.4205E-02,1.9974E-02/
      DATA ((KB(JS,JT,31, 6),JS=1,5),JT=1,5) /
     &1.7729E-02,3.3726E-02,3.5756E-02,3.2351E-02,1.5217E-02,
     &2.4948E-02,4.2686E-02,4.3734E-02,3.8162E-02,1.5670E-02,
     &3.4225E-02,5.3676E-02,5.3194E-02,4.4735E-02,1.6031E-02,
     &4.5784E-02,6.7038E-02,6.4468E-02,5.2256E-02,1.6295E-02,
     &5.9817E-02,8.2952E-02,7.7737E-02,6.0918E-02,1.6485E-02/
      DATA ((KB(JS,JT,32, 6),JS=1,5),JT=1,5) /
     &1.9003E-02,3.3583E-02,3.4583E-02,3.0306E-02,1.2654E-02,
     &2.6663E-02,4.2837E-02,4.2596E-02,3.5915E-02,1.2998E-02,
     &3.6385E-02,5.4256E-02,5.2269E-02,4.2382E-02,1.3260E-02,
     &4.8425E-02,6.8084E-02,6.3837E-02,4.9934E-02,1.3455E-02,
     &6.3023E-02,8.4608E-02,7.7399E-02,5.8694E-02,1.3589E-02/
      DATA ((KB(JS,JT,33, 6),JS=1,5),JT=1,5) /
     &2.0794E-02,3.4164E-02,3.4049E-02,2.8789E-02,1.0506E-02,
     &2.9020E-02,4.3934E-02,4.2358E-02,3.4361E-02,1.0761E-02,
     &3.9409E-02,5.5981E-02,5.2449E-02,4.0931E-02,1.0954E-02,
     &5.2184E-02,7.0595E-02,6.4456E-02,4.8674E-02,1.1100E-02,
     &6.7723E-02,8.8066E-02,7.8614E-02,5.7672E-02,1.1201E-02/
      DATA ((KB(JS,JT,34, 6),JS=1,5),JT=1,5) /
     &2.1935E-02,3.4165E-02,3.3105E-02,2.7057E-02,8.7014E-03,
     &3.0477E-02,4.4226E-02,4.1562E-02,3.2560E-02,8.8925E-03,
     &4.1199E-02,5.6620E-02,5.1809E-02,3.9153E-02,9.0424E-03,
     &5.4372E-02,7.1709E-02,6.4039E-02,4.6915E-02,9.1557E-03,
     &7.0476E-02,8.9710E-02,7.8542E-02,5.5979E-02,9.2318E-03/
      DATA ((KB(JS,JT,35, 6),JS=1,5),JT=1,5) /
     &2.2432E-02,3.3575E-02,3.1770E-02,2.5159E-02,7.1825E-03,
     &3.1101E-02,4.3743E-02,4.0231E-02,3.0588E-02,7.3372E-03,
     &4.1959E-02,5.6323E-02,5.0491E-02,3.7114E-02,7.4571E-03,
     &5.5361E-02,7.1664E-02,6.2827E-02,4.4829E-02,7.5457E-03,
     &7.1841E-02,8.9995E-02,7.7538E-02,5.3898E-02,7.6098E-03/
      DATA ((KB(JS,JT,36, 6),JS=1,5),JT=1,5) /
     &2.1971E-02,3.2052E-02,2.9773E-02,2.2980E-02,5.9169E-03,
     &3.0496E-02,4.2068E-02,3.8012E-02,2.8228E-02,6.0417E-03,
     &4.1195E-02,5.4532E-02,4.8068E-02,3.4542E-02,6.1403E-03,
     &5.4471E-02,6.9759E-02,6.0254E-02,4.2072E-02,6.2148E-03,
     &7.0911E-02,8.8088E-02,7.4912E-02,5.0992E-02,6.2662E-03/
      DATA ((KB(JS,JT,37, 6),JS=1,5),JT=1,5) /
     &1.9922E-02,2.8852E-02,2.6493E-02,2.0135E-02,4.8546E-03,
     &2.7802E-02,3.8202E-02,3.4133E-02,2.4969E-02,4.9597E-03,
     &3.7750E-02,4.9930E-02,4.3532E-02,3.0816E-02,5.0441E-03,
     &5.0184E-02,6.4346E-02,5.5012E-02,3.7855E-02,5.1082E-03,
     &6.5650E-02,8.1819E-02,6.8970E-02,4.6262E-02,5.1546E-03/
      DATA ((KB(JS,JT,38, 6),JS=1,5),JT=1,5) /
     &1.8261E-02,2.6220E-02,2.3783E-02,1.7789E-02,3.9817E-03,
     &2.5634E-02,3.5047E-02,3.0941E-02,2.2280E-02,4.0729E-03,
     &3.5007E-02,4.6188E-02,3.9826E-02,2.7761E-02,4.1447E-03,
     &4.6818E-02,5.9985E-02,5.0782E-02,3.4412E-02,4.1996E-03,
     &6.1549E-02,7.6851E-02,6.4240E-02,4.2442E-02,4.2409E-03/
      DATA ((KB(JS,JT,39, 6),JS=1,5),JT=1,5) /
     &1.7120E-02,2.4268E-02,2.1723E-02,1.5967E-02,3.2683E-03,
     &2.4172E-02,3.2753E-02,2.8567E-02,2.0215E-02,3.3454E-03,
     &3.3206E-02,4.3552E-02,3.7135E-02,2.5455E-02,3.4062E-03,
     &4.4652E-02,5.7021E-02,4.7802E-02,3.1863E-02,3.4542E-03,
     &5.8989E-02,7.3628E-02,6.1045E-02,3.9701E-02,3.4927E-03/
      DATA ((KB(JS,JT,40, 6),JS=1,5),JT=1,5) /
     &1.4508E-02,2.0729E-02,1.8466E-02,1.3481E-02,2.6735E-03,
     &2.0675E-02,2.8264E-02,2.4526E-02,1.7230E-02,2.7394E-03,
     &2.8640E-02,3.7952E-02,3.2186E-02,2.1896E-02,2.7930E-03,
     &3.8810E-02,5.0166E-02,4.1826E-02,2.7660E-02,2.8356E-03,
     &5.1624E-02,6.5327E-02,5.3925E-02,3.4781E-02,2.8708E-03/
      DATA ((KB(JS,JT,41, 6),JS=1,5),JT=1,5) /
     &1.2173E-02,1.7558E-02,1.5577E-02,1.1317E-02,2.1860E-03,
     &1.7521E-02,2.4204E-02,2.0905E-02,1.4606E-02,2.2431E-03,
     &2.4494E-02,3.2840E-02,2.7710E-02,1.8738E-02,2.2897E-03,
     &3.3465E-02,4.3838E-02,3.6359E-02,2.3890E-02,2.3273E-03,
     &4.4815E-02,5.7614E-02,4.7337E-02,3.0319E-02,2.3593E-03/
      DATA ((KB(JS,JT,42, 6),JS=1,5),JT=1,5) /
     &1.0295E-02,1.4955E-02,1.3204E-02,9.5463E-03,1.7869E-03,
     &1.4969E-02,2.0854E-02,1.7923E-02,1.2449E-02,1.8368E-03,
     &2.1120E-02,2.8597E-02,2.4004E-02,1.6130E-02,1.8766E-03,
     &2.9097E-02,3.8565E-02,3.1822E-02,2.0764E-02,1.9105E-03,
     &3.9250E-02,5.1179E-02,4.1851E-02,2.6620E-02,1.9390E-03/
      DATA ((KB(JS,JT,43, 6),JS=1,5),JT=1,5) /
     &8.5600E-03,1.2537E-02,1.1032E-02,7.9541E-03,1.4581E-03,
     &1.2604E-02,1.7710E-02,1.5163E-02,1.0490E-02,1.5008E-03,
     &1.7986E-02,2.4578E-02,2.0552E-02,1.3738E-02,1.5357E-03,
     &2.5016E-02,3.3532E-02,2.7550E-02,1.7878E-02,1.5671E-03,
     &3.4031E-02,4.4978E-02,3.6624E-02,2.3164E-02,1.5928E-03/
      DATA ((KB(JS,JT,44, 6),JS=1,5),JT=1,5) /
     &7.1102E-03,1.0482E-02,9.1923E-03,6.6123E-03,1.1883E-03,
     &1.0618E-02,1.5014E-02,1.2809E-02,8.8284E-03,1.2254E-03,
     &1.5336E-02,2.1109E-02,1.7587E-02,1.1700E-02,1.2566E-03,
     &2.1558E-02,2.9159E-02,2.3862E-02,1.5404E-02,1.2849E-03,
     &2.9601E-02,3.9572E-02,3.2092E-02,2.0188E-02,1.3081E-03/
      DATA ((KB(JS,JT,45, 6),JS=1,5),JT=1,5) /
     &5.9959E-03,8.8564E-03,7.7363E-03,5.5453E-03,9.6825E-04,
     &9.0798E-03,1.2878E-02,1.0936E-02,7.5039E-03,1.0003E-03,
     &1.3290E-02,1.8346E-02,1.5227E-02,1.0074E-02,1.0284E-03,
     &1.8884E-02,2.5678E-02,2.0927E-02,1.3427E-02,1.0535E-03,
     &2.6185E-02,3.5270E-02,2.8485E-02,1.7812E-02,1.0746E-03/
      DATA ((KB(JS,JT,46, 6),JS=1,5),JT=1,5) /
     &5.0299E-03,7.4350E-03,6.4749E-03,4.6277E-03,7.8776E-04,
     &7.7400E-03,1.0992E-02,9.2918E-03,6.3536E-03,8.1609E-04,
     &1.1482E-02,1.5887E-02,1.3136E-02,8.6493E-03,8.4114E-04,
     &1.6521E-02,2.2547E-02,1.8306E-02,1.1680E-02,8.6343E-04,
     &2.3160E-02,3.1365E-02,2.5232E-02,1.5694E-02,8.8222E-04/
      DATA ((KB(JS,JT,47, 6),JS=1,5),JT=1,5) /
     &4.0735E-03,6.0481E-03,5.2664E-03,3.7670E-03,6.3966E-04,
     &6.3819E-03,9.1048E-03,7.6804E-03,5.2485E-03,6.6459E-04,
     &9.6180E-03,1.3376E-02,1.1030E-02,7.2481E-03,6.8646E-04,
     &1.4038E-02,1.9266E-02,1.5600E-02,9.9209E-03,7.0632E-04,
     &1.9923E-02,2.7168E-02,2.1786E-02,1.3500E-02,7.2294E-04/
      DATA ((KB(JS,JT,48, 6),JS=1,5),JT=1,5) /
     &3.3654E-03,4.9911E-03,4.3393E-03,3.1001E-03,5.1894E-04,
     &5.3738E-03,7.6583E-03,6.4413E-03,4.3896E-03,5.4055E-04,
     &8.2348E-03,1.1452E-02,9.4090E-03,6.1594E-03,5.5982E-04,
     &1.2194E-02,1.6751E-02,1.3518E-02,8.5585E-03,5.7759E-04,
     &1.7535E-02,2.3969E-02,1.9153E-02,1.1809E-02,5.9223E-04/
      DATA ((KB(JS,JT,49, 6),JS=1,5),JT=1,5) /
     &2.8714E-03,4.2192E-03,3.6533E-03,2.6003E-03,4.2066E-04,
     &4.6796E-03,6.6096E-03,5.5332E-03,3.7482E-03,4.3948E-04,
     &7.3002E-03,1.0080E-02,8.2347E-03,5.3596E-03,4.5652E-04,
     &1.0971E-02,1.4981E-02,1.2046E-02,7.5739E-03,4.7234E-04,
     &1.5995E-02,2.1767E-02,1.7330E-02,1.0614E-02,4.8568E-04/
      DATA ((KB(JS,JT,50, 6),JS=1,5),JT=1,5) /
     &2.3434E-03,3.4410E-03,2.9786E-03,2.1205E-03,3.4069E-04,
     &3.8971E-03,5.4992E-03,4.5940E-03,3.1036E-03,3.5714E-04,
     &6.1900E-03,8.5460E-03,6.9553E-03,4.5152E-03,3.7212E-04,
     &9.4451E-03,1.2909E-02,1.0349E-02,6.4854E-03,3.8582E-04,
     &1.3954E-02,1.9042E-02,1.5119E-02,9.2171E-03,3.9788E-04/
      DATA ((KB(JS,JT,51, 6),JS=1,5),JT=1,5) /
     &1.8670E-03,2.7492E-03,2.3841E-03,1.7021E-03,2.7578E-04,
     &3.1678E-03,4.4826E-03,3.7408E-03,2.5267E-03,2.9005E-04,
     &5.1260E-03,7.0985E-03,5.7656E-03,3.7383E-03,3.0300E-04,
     &7.9439E-03,1.0904E-02,8.7196E-03,5.4539E-03,3.1487E-04,
     &1.1900E-02,1.6326E-02,1.2929E-02,7.8597E-03,3.2578E-04/
      DATA ((KB(JS,JT,52, 6),JS=1,5),JT=1,5) /
     &1.5181E-03,2.2298E-03,1.9337E-03,1.3821E-03,2.2294E-04,
     &2.6323E-03,3.7113E-03,3.0904E-03,2.0844E-03,2.3535E-04,
     &4.3389E-03,5.9943E-03,4.8574E-03,3.1382E-03,2.4655E-04,
     &6.8363E-03,9.3770E-03,7.4736E-03,4.6599E-03,2.5711E-04,
     &1.0389E-02,1.4256E-02,1.1263E-02,6.8242E-03,2.6665E-04/
      DATA ((KB(JS,JT,53, 6),JS=1,5),JT=1,5) /
     &1.2752E-03,1.8531E-03,1.6024E-03,1.1428E-03,1.8014E-04,
     &2.2594E-03,3.1508E-03,2.6140E-03,1.7561E-03,1.9085E-04,
     &3.7990E-03,5.2013E-03,4.1982E-03,2.6961E-03,2.0067E-04,
     &6.0922E-03,8.2959E-03,6.5816E-03,4.0835E-03,2.0982E-04,
     &9.3947E-03,1.2809E-02,1.0095E-02,6.0875E-03,2.1819E-04/
      DATA ((KB(JS,JT,54, 6),JS=1,5),JT=1,5) /
     &9.3663E-04,1.3820E-03,1.2040E-03,8.6807E-04,1.4544E-04,
     &1.6914E-03,2.3887E-03,1.9911E-03,1.3482E-03,1.5460E-04,
     &2.8997E-03,4.0201E-03,3.2494E-03,2.0953E-03,1.6297E-04,
     &4.7306E-03,6.5273E-03,5.1758E-03,3.2189E-03,1.7075E-04,
     &7.3984E-03,1.0238E-02,8.0539E-03,4.8622E-03,1.7797E-04/
      DATA ((KB(JS,JT,55, 6),JS=1,5),JT=1,5) /
     &6.2935E-04,9.5969E-04,8.4900E-04,6.2465E-04,1.1738E-04,
     &1.1558E-03,1.6799E-03,1.4161E-03,9.7472E-04,1.2508E-04,
     &2.0209E-03,2.8749E-03,2.3378E-03,1.5244E-03,1.3211E-04,
     &3.3522E-03,4.7482E-03,3.7736E-03,2.3654E-03,1.3870E-04,
     &5.3187E-03,7.5686E-03,5.9480E-03,3.6106E-03,1.4478E-04/
      DATA ((KB(JS,JT,56, 6),JS=1,5),JT=1,5) /
     &4.2101E-04,6.6332E-04,5.9672E-04,4.4860E-04,9.4587E-05,
     &7.8466E-04,1.1752E-03,1.0029E-03,7.0318E-04,1.0112E-04,
     &1.3999E-03,2.0432E-03,1.6739E-03,1.1053E-03,1.0709E-04,
     &2.3635E-03,3.4329E-03,2.7372E-03,1.7318E-03,1.1258E-04,
     &3.8069E-03,5.5637E-03,4.3696E-03,2.6702E-03,1.1773E-04/
      DATA ((KB(JS,JT,57, 6),JS=1,5),JT=1,5) /
     &2.8076E-04,4.5641E-04,4.1815E-04,3.2142E-04,7.6115E-05,
     &5.2895E-04,8.1778E-04,7.0771E-04,5.0616E-04,8.1716E-05,
     &9.6334E-04,1.4422E-03,1.1917E-03,7.9834E-04,8.6757E-05,
     &1.6571E-03,2.4651E-03,1.9746E-03,1.2622E-03,9.1332E-05,
     &2.7119E-03,4.0628E-03,3.1926E-03,1.9661E-03,9.5684E-05/
      DATA ((KB(JS,JT,58, 6),JS=1,5),JT=1,5) /
     &4.9720E-05,1.0269E-04,1.2366E-04,1.3663E-04,6.1273E-05,
     &9.4473E-05,1.8553E-04,2.1007E-04,2.1548E-04,6.5992E-05,
     &1.7530E-04,3.3103E-04,3.5575E-04,3.4010E-04,7.0239E-05,
     &3.0720E-04,5.7469E-04,5.9600E-04,5.4082E-04,7.4141E-05,
     &5.1103E-04,9.6242E-04,9.7487E-04,8.4973E-04,7.7747E-05/
      DATA ((KB(JS,JT,59, 6),JS=1,5),JT=1,5) /
     &4.4314E-05,9.6972E-05,1.1293E-04,1.1582E-04,4.9949E-05,
     &8.4700E-05,1.7358E-04,1.8881E-04,1.7917E-04,5.3859E-05,
     &1.5856E-04,3.0848E-04,3.1562E-04,2.7815E-04,5.7310E-05,
     &2.8032E-04,5.3615E-04,5.2587E-04,4.3688E-04,6.0507E-05,
     &4.7008E-04,9.0261E-04,8.5908E-04,6.8167E-04,6.3447E-05/
      DATA ((KB(JS,JT,13, 7),JS=1,5),JT=1,5) /
     &3.5002E+00,2.8426E+00,2.2229E+00,1.5940E+00,4.6284E-01,
     &5.2764E+00,4.1532E+00,3.0774E+00,2.0245E+00,4.6449E-01,
     &7.6096E+00,5.8846E+00,4.2048E+00,2.5664E+00,4.6564E-01,
     &1.0545E+01,8.0718E+00,5.6353E+00,3.2573E+00,4.6805E-01,
     &1.4101E+01,1.0726E+01,7.3776E+00,4.1071E+00,4.6959E-01/
      DATA ((KB(JS,JT,14, 7),JS=1,5),JT=1,5) /
     &1.9332E+00,1.6833E+00,1.4584E+00,1.1419E+00,4.2549E-01,
     &2.9208E+00,2.4028E+00,1.9264E+00,1.4148E+00,4.2845E-01,
     &4.2111E+00,3.3491E+00,2.5401E+00,1.7447E+00,4.2997E-01,
     &5.8219E+00,4.5369E+00,3.3137E+00,2.1374E+00,4.3233E-01,
     &7.7805E+00,5.9890E+00,4.2588E+00,2.5955E+00,4.3475E-01/
      DATA ((KB(JS,JT,15, 7),JS=1,5),JT=1,5) /
     &1.0958E+00,1.0674E+00,1.0130E+00,8.4961E-01,3.8730E-01,
     &1.6536E+00,1.4690E+00,1.3041E+00,1.0292E+00,3.9101E-01,
     &2.3745E+00,1.9914E+00,1.6603E+00,1.2452E+00,3.9344E-01,
     &3.2750E+00,2.6468E+00,2.0887E+00,1.4951E+00,3.9613E-01,
     &4.3749E+00,3.4526E+00,2.6092E+00,1.7780E+00,3.9900E-01/
      DATA ((KB(JS,JT,16, 7),JS=1,5),JT=1,5) /
     &7.4165E-01,8.0405E-01,7.9283E-01,6.9114E-01,3.4911E-01,
     &1.1136E+00,1.0786E+00,1.0091E+00,8.2862E-01,3.5314E-01,
     &1.5923E+00,1.4242E+00,1.2681E+00,9.9143E-01,3.5636E-01,
     &2.1926E+00,1.8566E+00,1.5712E+00,1.1771E+00,3.6013E-01,
     &2.9285E+00,2.3901E+00,1.9279E+00,1.3859E+00,3.6399E-01/
      DATA ((KB(JS,JT,17, 7),JS=1,5),JT=1,5) /
     &5.1887E-01,6.2476E-01,6.3724E-01,5.7083E-01,3.1167E-01,
     &7.7486E-01,8.2693E-01,8.0143E-01,6.7854E-01,3.1621E-01,
     &1.1045E+00,1.0746E+00,9.9649E-01,8.0449E-01,3.2014E-01,
     &1.5180E+00,1.3742E+00,1.2231E+00,9.4686E-01,3.2461E-01,
     &2.0257E+00,1.7386E+00,1.4858E+00,1.1069E+00,3.2955E-01/
      DATA ((KB(JS,JT,18, 7),JS=1,5),JT=1,5) /
     &3.7097E-01,4.9432E-01,5.1840E-01,4.7504E-01,2.7614E-01,
     &5.5115E-01,6.4712E-01,6.4514E-01,5.6072E-01,2.8084E-01,
     &7.8296E-01,8.3225E-01,7.9447E-01,6.5954E-01,2.8571E-01,
     &1.0738E+00,1.0535E+00,9.6779E-01,7.7088E-01,2.9112E-01,
     &1.4335E+00,1.3170E+00,1.1664E+00,8.9595E-01,2.9703E-01/
      DATA ((KB(JS,JT,19, 7),JS=1,5),JT=1,5) /
     &2.5985E-01,3.8651E-01,4.1602E-01,3.9308E-01,2.4307E-01,
     &3.8422E-01,5.0067E-01,5.1275E-01,4.5968E-01,2.4809E-01,
     &5.4420E-01,6.3764E-01,6.2617E-01,5.3586E-01,2.5358E-01,
     &7.4603E-01,7.9981E-01,7.5671E-01,6.2198E-01,2.5998E-01,
     &9.9708E-01,9.9236E-01,9.0617E-01,7.1829E-01,2.6615E-01/
      DATA ((KB(JS,JT,20, 7),JS=1,5),JT=1,5) /
     &1.9760E-01,3.1836E-01,3.4770E-01,3.3477E-01,2.1277E-01,
     &2.9095E-01,4.0925E-01,4.2592E-01,3.8937E-01,2.1827E-01,
     &4.1127E-01,5.1768E-01,5.1739E-01,4.5140E-01,2.2458E-01,
     &5.6427E-01,6.4625E-01,6.2247E-01,5.2174E-01,2.3101E-01,
     &7.5526E-01,7.9836E-01,7.4304E-01,6.0027E-01,2.3711E-01/
      DATA ((KB(JS,JT,21, 7),JS=1,5),JT=1,5) /
     &1.5484E-01,2.6582E-01,2.9382E-01,2.8708E-01,1.8550E-01,
     &2.2722E-01,3.3963E-01,3.5832E-01,3.3257E-01,1.9141E-01,
     &3.2108E-01,4.2782E-01,4.3333E-01,3.8435E-01,1.9782E-01,
     &4.4098E-01,5.3304E-01,5.1997E-01,4.4275E-01,2.0379E-01,
     &5.9030E-01,6.5709E-01,6.1970E-01,5.0864E-01,2.0956E-01/
      DATA ((KB(JS,JT,22, 7),JS=1,5),JT=1,5) /
     &1.2753E-01,2.2781E-01,2.5360E-01,2.4962E-01,1.6164E-01,
     &1.8637E-01,2.8970E-01,3.0789E-01,2.8854E-01,1.6761E-01,
     &2.6299E-01,3.6404E-01,3.7114E-01,3.3280E-01,1.7333E-01,
     &3.6059E-01,4.5267E-01,4.4472E-01,3.8285E-01,1.7883E-01,
     &4.8104E-01,5.5702E-01,5.2923E-01,4.3976E-01,1.8428E-01/
      DATA ((KB(JS,JT,23, 7),JS=1,5),JT=1,5) /
     &1.0589E-01,1.9529E-01,2.1876E-01,2.1679E-01,1.4037E-01,
     &1.5420E-01,2.4758E-01,2.6461E-01,2.5042E-01,1.4579E-01,
     &2.1702E-01,3.1068E-01,3.1854E-01,2.8852E-01,1.5094E-01,
     &2.9661E-01,3.8564E-01,3.8128E-01,3.3195E-01,1.5614E-01,
     &3.9397E-01,4.7355E-01,4.5341E-01,3.8121E-01,1.6132E-01/
      DATA ((KB(JS,JT,24, 7),JS=1,5),JT=1,5) /
     &8.7788E-02,1.6668E-01,1.8799E-01,1.8780E-01,1.2140E-01,
     &1.2734E-01,2.1083E-01,2.2703E-01,2.1652E-01,1.2618E-01,
     &1.7857E-01,2.6413E-01,2.7303E-01,2.4936E-01,1.3098E-01,
     &2.4296E-01,3.2721E-01,3.2661E-01,2.8698E-01,1.3586E-01,
     &3.2098E-01,4.0055E-01,3.8785E-01,3.2936E-01,1.4075E-01/
      DATA ((KB(JS,JT,25, 7),JS=1,5),JT=1,5) /
     &7.4114E-02,1.4357E-01,1.6268E-01,1.6299E-01,1.0454E-01,
     &1.0696E-01,1.8148E-01,1.9639E-01,1.8781E-01,1.0890E-01,
     &1.4921E-01,2.2686E-01,2.3627E-01,2.1648E-01,1.1337E-01,
     &2.0169E-01,2.8030E-01,2.8233E-01,2.4913E-01,1.1793E-01,
     &2.6511E-01,3.4240E-01,3.3494E-01,2.8598E-01,1.2261E-01/
      DATA ((KB(JS,JT,26, 7),JS=1,5),JT=1,5) /
     &6.4102E-02,1.2562E-01,1.4220E-01,1.4209E-01,8.9836E-02,
     &9.1903E-02,1.5853E-01,1.7179E-01,1.6391E-01,9.3830E-02,
     &1.2732E-01,1.9782E-01,2.0670E-01,1.8917E-01,9.8002E-02,
     &1.7095E-01,2.4388E-01,2.4691E-01,2.1801E-01,1.0234E-01,
     &2.2376E-01,2.9731E-01,2.9277E-01,2.5044E-01,1.0674E-01/
      DATA ((KB(JS,JT,27, 7),JS=1,5),JT=1,5) /
     &5.7622E-02,1.1249E-01,1.2636E-01,1.2511E-01,7.7055E-02,
     &8.1983E-02,1.4196E-01,1.5312E-01,1.4485E-01,8.0791E-02,
     &1.1275E-01,1.7697E-01,1.8437E-01,1.6781E-01,8.4713E-02,
     &1.5055E-01,2.1794E-01,2.2039E-01,1.9390E-01,8.8731E-02,
     &1.9638E-01,2.6555E-01,2.6132E-01,2.2312E-01,9.2655E-02/
      DATA ((KB(JS,JT,28, 7),JS=1,5),JT=1,5) /
     &5.3140E-02,1.0241E-01,1.1379E-01,1.1112E-01,6.6059E-02,
     &7.5045E-02,1.2928E-01,1.3817E-01,1.2935E-01,6.9529E-02,
     &1.0252E-01,1.6119E-01,1.6672E-01,1.5050E-01,7.3142E-02,
     &1.3625E-01,1.9862E-01,1.9953E-01,1.7444E-01,7.6746E-02,
     &1.7752E-01,2.4214E-01,2.3714E-01,2.0133E-01,7.9941E-02/
      DATA ((KB(JS,JT,29, 7),JS=1,5),JT=1,5) /
     &5.2099E-02,9.6941E-02,1.0563E-01,1.0097E-01,5.6668E-02,
     &7.3009E-02,1.2266E-01,1.2890E-01,1.1850E-01,5.9859E-02,
     &9.9110E-02,1.5322E-01,1.5608E-01,1.3860E-01,6.3089E-02,
     &1.3136E-01,1.8918E-01,1.8750E-01,1.6146E-01,6.6000E-02,
     &1.7133E-01,2.3120E-01,2.2375E-01,1.8721E-01,6.8384E-02/
      DATA ((KB(JS,JT,30, 7),JS=1,5),JT=1,5) /
     &5.2298E-02,9.3477E-02,9.9631E-02,9.3041E-02,4.8653E-02,
     &7.2744E-02,1.1854E-01,1.2224E-01,1.0996E-01,5.1507E-02,
     &9.8307E-02,1.4854E-01,1.4866E-01,1.2943E-01,5.4141E-02,
     &1.3030E-01,1.8393E-01,1.7946E-01,1.5167E-01,5.6316E-02,
     &1.7017E-01,2.2583E-01,2.1516E-01,1.7690E-01,5.8003E-02/
      DATA ((KB(JS,JT,31, 7),JS=1,5),JT=1,5) /
     &5.5237E-02,9.3530E-02,9.7080E-02,8.7885E-02,4.1801E-02,
     &7.6342E-02,1.1917E-01,1.1987E-01,1.0485E-01,4.4162E-02,
     &1.0297E-01,1.4987E-01,1.4665E-01,1.2435E-01,4.6139E-02,
     &1.3657E-01,1.8654E-01,1.7810E-01,1.4680E-01,4.7704E-02,
     &1.7842E-01,2.3057E-01,2.1509E-01,1.7253E-01,4.8947E-02/
      DATA ((KB(JS,JT,32, 7),JS=1,5),JT=1,5) /
     &5.9027E-02,9.4969E-02,9.5943E-02,8.4194E-02,3.5812E-02,
     &8.1201E-02,1.2151E-01,1.1922E-01,1.0130E-01,3.7617E-02,
     &1.0955E-01,1.5358E-01,1.4681E-01,1.2117E-01,3.9058E-02,
     &1.4540E-01,1.9256E-01,1.7966E-01,1.4421E-01,4.0236E-02,
     &1.8982E-01,2.3938E-01,2.1889E-01,1.7084E-01,4.1181E-02/
      DATA ((KB(JS,JT,33, 7),JS=1,5),JT=1,5) /
     &6.4219E-02,9.8255E-02,9.6625E-02,8.2099E-02,3.0519E-02,
     &8.8246E-02,1.2633E-01,1.2088E-01,9.9705E-02,3.1855E-02,
     &1.1912E-01,1.6083E-01,1.5001E-01,1.2028E-01,3.2953E-02,
     &1.5802E-01,2.0300E-01,1.8528E-01,1.4442E-01,3.3850E-02,
     &2.0596E-01,2.5392E-01,2.2791E-01,1.7303E-01,3.4585E-02/
      DATA ((KB(JS,JT,34, 7),JS=1,5),JT=1,5) /
     &6.7485E-02,9.9620E-02,9.5868E-02,7.9332E-02,2.5830E-02,
     &9.2815E-02,1.2890E-01,1.2075E-01,9.7213E-02,2.6848E-02,
     &1.2537E-01,1.6529E-01,1.5122E-01,1.1822E-01,2.7699E-02,
     &1.6617E-01,2.0989E-01,1.8860E-01,1.4346E-01,2.8411E-02,
     &2.1641E-01,2.6338E-01,2.3365E-01,1.7367E-01,2.9006E-02/
      DATA ((KB(JS,JT,35, 7),JS=1,5),JT=1,5) /
     &6.9002E-02,9.9168E-02,9.3611E-02,7.5846E-02,2.1704E-02,
     &9.5177E-02,1.2935E-01,1.1903E-01,9.3690E-02,2.2517E-02,
     &1.2872E-01,1.6713E-01,1.5066E-01,1.1518E-01,2.3202E-02,
     &1.7076E-01,2.1347E-01,1.8964E-01,1.4135E-01,2.3785E-02,
     &2.2264E-01,2.6908E-01,2.3665E-01,1.7298E-01,2.4252E-02/
      DATA ((KB(JS,JT,36, 7),JS=1,5),JT=1,5) /
     &6.7865E-02,9.5879E-02,8.9211E-02,7.0981E-02,1.8133E-02,
     &9.4007E-02,1.2625E-01,1.1466E-01,8.8573E-02,1.8797E-02,
     &1.2751E-01,1.6450E-01,1.4669E-01,1.1023E-01,1.9364E-02,
     &1.6969E-01,2.1129E-01,1.8634E-01,1.3684E-01,1.9848E-02,
     &2.2199E-01,2.6776E-01,2.3416E-01,1.6920E-01,2.0253E-02/
      DATA ((KB(JS,JT,37, 7),JS=1,5),JT=1,5) /
     &6.1910E-02,8.7392E-02,8.0722E-02,6.3503E-02,1.5050E-02,
     &8.6402E-02,1.1634E-01,1.0496E-01,8.0172E-02,1.5605E-02,
     &1.1792E-01,1.5301E-01,1.3575E-01,1.0102E-01,1.6089E-02,
     &1.5786E-01,1.9811E-01,1.7416E-01,1.2688E-01,1.6504E-02,
     &2.0776E-01,2.5283E-01,2.2073E-01,1.5856E-01,1.6861E-02/
      DATA ((KB(JS,JT,38, 7),JS=1,5),JT=1,5) /
     &5.7180E-02,8.0434E-02,7.3641E-02,5.7228E-02,1.2479E-02,
     &8.0361E-02,1.0828E-01,9.6955E-02,7.3200E-02,1.2947E-02,
     &1.1043E-01,1.4379E-01,1.2688E-01,9.3375E-02,1.3365E-02,
     &1.4883E-01,1.8786E-01,1.6450E-01,1.1879E-01,1.3732E-02,
     &1.9707E-01,2.4129E-01,2.1013E-01,1.4998E-01,1.4049E-02/
      DATA ((KB(JS,JT,39, 7),JS=1,5),JT=1,5) /
     &5.4044E-02,7.5469E-02,6.8324E-02,5.2315E-02,1.0342E-02,
     &7.6525E-02,1.0279E-01,9.1154E-02,6.7832E-02,1.0747E-02,
     &1.0591E-01,1.3783E-01,1.2080E-01,8.7775E-02,1.1116E-02,
     &1.4369E-01,1.8148E-01,1.5809E-01,1.1309E-01,1.1438E-02,
     &1.9144E-01,2.3501E-01,2.0393E-01,1.4445E-01,1.1716E-02/
      DATA ((KB(JS,JT,40, 7),JS=1,5),JT=1,5) /
     &4.6217E-02,6.5370E-02,5.9012E-02,4.4989E-02,8.5358E-03,
     &6.6114E-02,9.0173E-02,7.9777E-02,5.9045E-02,8.8901E-03,
     &9.2339E-02,1.2222E-01,1.0699E-01,7.7378E-02,9.2084E-03,
     &1.2639E-01,1.6256E-01,1.4164E-01,1.0101E-01,9.4930E-03,
     &1.6986E-01,2.1255E-01,1.8467E-01,1.3055E-01,9.7467E-03/
      DATA ((KB(JS,JT,41, 7),JS=1,5),JT=1,5) /
     &3.9155E-02,5.6183E-02,5.0596E-02,3.8424E-02,7.0383E-03,
     &5.6659E-02,7.8503E-02,6.9340E-02,5.1085E-02,7.3470E-03,
     &7.9928E-02,1.0766E-01,9.4225E-02,6.7858E-02,7.6230E-03,
     &1.1042E-01,1.4475E-01,1.2626E-01,8.9781E-02,7.8762E-03,
     &1.4975E-01,1.9111E-01,1.6637E-01,1.1739E-01,8.1039E-03/
      DATA ((KB(JS,JT,42, 7),JS=1,5),JT=1,5) /
     &3.3442E-02,4.8574E-02,4.3613E-02,3.2930E-02,5.8050E-03,
     &4.8965E-02,6.8792E-02,6.0620E-02,4.4408E-02,6.0682E-03,
     &6.9803E-02,9.5533E-02,8.3532E-02,5.9826E-02,6.3116E-03,
     &9.7360E-02,1.2988E-01,1.1328E-01,8.0240E-02,6.5330E-03,
     &1.3333E-01,1.7321E-01,1.5102E-01,1.0628E-01,6.7345E-03/
      DATA ((KB(JS,JT,43, 7),JS=1,5),JT=1,5) /
     &2.8074E-02,4.1293E-02,3.7000E-02,2.7812E-02,4.7712E-03,
     &4.1661E-02,5.9380E-02,5.2205E-02,3.8045E-02,4.9985E-03,
     &6.0156E-02,8.3670E-02,7.3060E-02,5.2075E-02,5.2119E-03,
     &8.4838E-02,1.1520E-01,1.0043E-01,7.0829E-02,5.4068E-03,
     &1.1748E-01,1.5547E-01,1.3568E-01,9.5209E-02,5.5907E-03/
      DATA ((KB(JS,JT,44, 7),JS=1,5),JT=1,5) /
     &2.3517E-02,3.4984E-02,3.1261E-02,2.3397E-02,3.9133E-03,
     &3.5440E-02,5.1145E-02,4.4838E-02,3.2508E-02,4.1113E-03,
     &5.1856E-02,7.3218E-02,6.3748E-02,4.5187E-02,4.2980E-03,
     &7.4068E-02,1.0225E-01,8.9058E-02,6.2496E-02,4.4682E-03,
     &1.0378E-01,1.3965E-01,1.2187E-01,8.5218E-02,4.6319E-03/
      DATA ((KB(JS,JT,45, 7),JS=1,5),JT=1,5) /
     &1.9987E-02,2.9948E-02,2.6638E-02,1.9815E-02,3.2076E-03,
     &3.0595E-02,4.4514E-02,3.8859E-02,2.7978E-02,3.3798E-03,
     &4.5403E-02,6.4811E-02,5.6194E-02,3.9557E-02,3.5406E-03,
     &6.5696E-02,9.1866E-02,7.9797E-02,5.5645E-02,3.6912E-03,
     &9.3194E-02,1.2710E-01,1.1078E-01,7.7097E-02,3.8387E-03/
      DATA ((KB(JS,JT,46, 7),JS=1,5),JT=1,5) /
     &1.6883E-02,2.5455E-02,2.2540E-02,1.6677E-02,2.6234E-03,
     &2.6297E-02,3.8534E-02,3.3486E-02,2.3954E-02,2.7725E-03,
     &3.9636E-02,5.7120E-02,4.9278E-02,3.4454E-02,2.9133E-03,
     &5.8158E-02,8.2259E-02,7.1230E-02,4.9351E-02,3.0483E-03,
     &8.3561E-02,1.1543E-01,1.0042E-01,6.9545E-02,3.1794E-03/
      DATA ((KB(JS,JT,47, 7),JS=1,5),JT=1,5) /
     &1.3750E-02,2.0931E-02,1.8489E-02,1.3652E-02,2.1369E-03,
     &2.1838E-02,3.2305E-02,2.7989E-02,1.9957E-02,2.2678E-03,
     &3.3497E-02,4.8835E-02,4.1985E-02,2.9214E-02,2.3899E-03,
     &4.9929E-02,7.1624E-02,6.1836E-02,4.2605E-02,2.5094E-03,
     &7.2757E-02,1.0217E-01,8.8738E-02,6.1180E-02,2.6247E-03/
      DATA ((KB(JS,JT,48, 7),JS=1,5),JT=1,5) /
     &1.1414E-02,1.7437E-02,1.5334E-02,1.1272E-02,1.7386E-03,
     &1.8495E-02,2.7458E-02,2.3694E-02,1.6798E-02,1.8526E-03,
     &2.8896E-02,4.2355E-02,3.6253E-02,2.5061E-02,1.9592E-03,
     &4.3780E-02,6.3320E-02,5.4439E-02,3.7255E-02,2.0628E-03,
     &6.4736E-02,9.1889E-02,7.9609E-02,5.4563E-02,2.1644E-03/
      DATA ((KB(JS,JT,49, 7),JS=1,5),JT=1,5) /
     &9.7792E-03,1.4862E-02,1.2975E-02,9.4608E-03,1.4121E-03,
     &1.6175E-02,2.3898E-02,2.0488E-02,1.4406E-02,1.5117E-03,
     &2.5763E-02,3.7620E-02,3.1995E-02,2.1936E-02,1.6039E-03,
     &3.9714E-02,5.7411E-02,4.9041E-02,3.3299E-02,1.6946E-03,
     &5.9638E-02,8.4793E-02,7.3080E-02,4.9749E-02,1.7852E-03/
      DATA ((KB(JS,JT,50, 7),JS=1,5),JT=1,5) /
     &8.0131E-03,1.2216E-02,1.0631E-02,7.7241E-03,1.1467E-03,
     &1.3522E-02,2.0069E-02,1.7141E-02,1.2008E-02,1.2327E-03,
     &2.1961E-02,3.2239E-02,2.7314E-02,1.8640E-02,1.3124E-03,
     &3.4440E-02,5.0209E-02,4.2737E-02,2.8885E-02,1.3920E-03,
     &5.2495E-02,7.5521E-02,6.4947E-02,4.4030E-02,1.4733E-03/
      DATA ((KB(JS,JT,51, 7),JS=1,5),JT=1,5) /
     &6.4036E-03,9.8290E-03,8.5406E-03,6.2032E-03,9.3043E-04,
     &1.1026E-02,1.6501E-02,1.4064E-02,9.8397E-03,1.0045E-03,
     &1.8273E-02,2.7056E-02,2.2864E-02,1.5565E-02,1.0742E-03,
     &2.9163E-02,4.3028E-02,3.6523E-02,2.4601E-02,1.1437E-03,
     &4.5145E-02,6.5958E-02,5.6628E-02,3.8264E-02,1.2140E-03/
      DATA ((KB(JS,JT,52, 7),JS=1,5),JT=1,5) /
     &5.2190E-03,8.0088E-03,6.9367E-03,5.0245E-03,7.5434E-04,
     &9.1694E-03,1.3764E-02,1.1684E-02,8.1486E-03,8.1834E-04,
     &1.5524E-02,2.3049E-02,1.9394E-02,1.3151E-02,8.7913E-04,
     &2.5232E-02,3.7442E-02,3.1647E-02,2.1215E-02,9.3902E-04,
     &3.9698E-02,5.8529E-02,5.0101E-02,3.3714E-02,1.0010E-03/
      DATA ((KB(JS,JT,53, 7),JS=1,5),JT=1,5) /
     &4.3882E-03,6.6717E-03,5.7454E-03,4.1343E-03,6.1055E-04,
     &7.8762E-03,1.1762E-02,9.9163E-03,6.8660E-03,6.6611E-04,
     &1.3621E-02,2.0115E-02,1.6825E-02,1.1330E-02,7.1874E-04,
     &2.2577E-02,3.3386E-02,2.8049E-02,1.8668E-02,7.7087E-04,
     &3.6135E-02,5.3261E-02,4.5341E-02,3.0337E-02,8.2493E-04/
      DATA ((KB(JS,JT,54, 7),JS=1,5),JT=1,5) /
     &3.2171E-03,4.9791E-03,4.3152E-03,3.1327E-03,4.9375E-04,
     &5.9006E-03,8.9891E-03,7.6027E-03,5.2931E-03,5.4126E-04,
     &1.0411E-02,1.5699E-02,1.3153E-02,8.8893E-03,5.8635E-04,
     &1.7599E-02,2.6636E-02,2.2397E-02,1.4923E-02,6.3108E-04,
     &2.8648E-02,4.3428E-02,3.7016E-02,2.4766E-02,6.7747E-04/
      DATA ((KB(JS,JT,55, 7),JS=1,5),JT=1,5) /
     &2.1501E-03,3.4516E-03,3.0360E-03,2.2475E-03,3.9872E-04,
     &4.0344E-03,6.3713E-03,5.4431E-03,3.8454E-03,4.3910E-04,
     &7.2610E-03,1.1366E-02,9.5883E-03,6.5518E-03,4.7768E-04,
     &1.2517E-02,1.9714E-02,1.6657E-02,1.1171E-02,5.1535E-04,
     &2.0727E-02,3.2905E-02,2.8181E-02,1.8908E-02,5.5486E-04/
      DATA ((KB(JS,JT,56, 7),JS=1,5),JT=1,5) /
     &1.4245E-03,2.3749E-03,2.1236E-03,1.6049E-03,3.2130E-04,
     &2.7381E-03,4.4799E-03,3.8718E-03,2.7798E-03,3.5587E-04,
     &5.0259E-03,8.1674E-03,6.9450E-03,4.8004E-03,3.8862E-04,
     &8.8432E-03,1.4489E-02,1.2307E-02,8.3071E-03,4.2064E-04,
     &1.4910E-02,2.4779E-02,2.1310E-02,1.4337E-02,4.5360E-04/
      DATA ((KB(JS,JT,57, 7),JS=1,5),JT=1,5) /
     &9.3471E-04,1.6209E-03,1.4751E-03,1.1411E-03,2.5838E-04,
     &1.8436E-03,3.1233E-03,2.7344E-03,1.9986E-03,2.8780E-04,
     &3.4502E-03,5.8213E-03,4.9934E-03,3.4957E-03,3.1565E-04,
     &6.2020E-03,1.0562E-02,9.0212E-03,6.1326E-03,3.4283E-04,
     &1.0656E-02,1.8525E-02,1.5995E-02,1.0788E-02,3.7043E-04/
      DATA ((KB(JS,JT,58, 7),JS=1,5),JT=1,5) /
     &1.6224E-04,3.6080E-04,4.3166E-04,4.8123E-04,2.0767E-04,
     &3.2835E-04,7.0851E-04,8.1160E-04,8.4893E-04,2.3260E-04,
     &6.2650E-04,1.3493E-03,1.5057E-03,1.4999E-03,2.5617E-04,
     &1.1500E-03,2.5038E-03,2.7715E-03,2.6635E-03,2.7921E-04,
     &2.0128E-03,4.5008E-03,5.0240E-03,4.7643E-03,3.0249E-04/
      DATA ((KB(JS,JT,59, 7),JS=1,5),JT=1,5) /
     &1.4374E-04,3.4167E-04,3.9743E-04,4.1474E-04,1.7016E-04,
     &2.9460E-04,6.7320E-04,7.4449E-04,7.2184E-04,1.9072E-04,
     &5.6936E-04,1.2962E-03,1.3859E-03,1.2659E-03,2.1044E-04,
     &1.0579E-03,2.4467E-03,2.5761E-03,2.2456E-03,2.2959E-04,
     &1.8733E-03,4.4959E-03,4.7523E-03,4.0463E-03,2.4889E-04/
      DATA ((KB(JS,JT,13, 8),JS=1,5),JT=1,5) /
     &1.0984E+01,8.3644E+00,5.8323E+00,3.5207E+00,9.5573E-01,
     &1.6457E+01,1.2460E+01,8.5024E+00,4.7543E+00,9.4898E-01,
     &2.3514E+01,1.7749E+01,1.1998E+01,6.4125E+00,9.3955E-01,
     &3.2333E+01,2.4359E+01,1.6389E+01,8.5253E+00,9.2689E-01,
     &4.3124E+01,3.2448E+01,2.1775E+01,1.1152E+01,9.1779E-01/
      DATA ((KB(JS,JT,14, 8),JS=1,5),JT=1,5) /
     &6.1000E+00,4.7207E+00,3.5104E+00,2.4718E+00,9.1734E-01,
     &9.1253E+00,6.9681E+00,4.9378E+00,3.1340E+00,9.1181E-01,
     &1.3035E+01,9.8900E+00,6.8208E+00,3.9957E+00,9.0546E-01,
     &1.7969E+01,1.3584E+01,9.2328E+00,5.1032E+00,8.9760E-01,
     &2.4021E+01,1.8119E+01,1.2229E+01,6.5133E+00,8.8920E-01/
      DATA ((KB(JS,JT,15, 8),JS=1,5),JT=1,5) /
     &3.4743E+00,2.8067E+00,2.3437E+00,1.8996E+00,8.7156E-01,
     &5.1884E+00,4.0500E+00,3.1125E+00,2.2977E+00,8.6786E-01,
     &7.4263E+00,5.6964E+00,4.1330E+00,2.7795E+00,8.6394E-01,
     &1.0261E+01,7.8059E+00,5.4699E+00,3.3858E+00,8.5908E-01,
     &1.3736E+01,1.0405E+01,7.1459E+00,4.1475E+00,8.5337E-01/
      DATA ((KB(JS,JT,16, 8),JS=1,5),JT=1,5) /
     &2.3668E+00,2.0348E+00,1.8716E+00,1.6135E+00,8.1894E-01,
     &3.5375E+00,2.8566E+00,2.3918E+00,1.9179E+00,8.1793E-01,
     &5.0738E+00,3.9641E+00,3.0738E+00,2.2799E+00,8.1574E-01,
     &7.0147E+00,5.3888E+00,3.9564E+00,2.7115E+00,8.1291E-01,
     &9.3829E+00,7.1458E+00,5.0571E+00,3.2258E+00,8.0943E-01/
      DATA ((KB(JS,JT,17, 8),JS=1,5),JT=1,5) /
     &1.6738E+00,1.5709E+00,1.5512E+00,1.3915E+00,7.6163E-01,
     &2.5071E+00,2.1423E+00,1.9466E+00,1.6331E+00,7.6194E-01,
     &3.5973E+00,2.9044E+00,2.4376E+00,1.9200E+00,7.6176E-01,
     &4.9653E+00,3.8871E+00,3.0499E+00,2.2591E+00,7.6112E-01,
     &6.6200E+00,5.0972E+00,3.7961E+00,2.6511E+00,7.6001E-01/
      DATA ((KB(JS,JT,18, 8),JS=1,5),JT=1,5) /
     &1.2159E+00,1.2682E+00,1.3055E+00,1.2114E+00,6.9972E-01,
     &1.8215E+00,1.6846E+00,1.6207E+00,1.4074E+00,7.0172E-01,
     &2.6063E+00,2.2250E+00,2.0059E+00,1.6407E+00,7.0349E-01,
     &3.5864E+00,2.9083E+00,2.4603E+00,1.9137E+00,7.0440E-01,
     &4.7701E+00,3.7503E+00,2.9936E+00,2.2226E+00,7.0559E-01/
      DATA ((KB(JS,JT,19, 8),JS=1,5),JT=1,5) /
     &8.6896E-01,1.0218E+00,1.0917E+00,1.0431E+00,6.3571E-01,
     &1.2971E+00,1.3348E+00,1.3390E+00,1.2022E+00,6.3915E-01,
     &1.8500E+00,1.7190E+00,1.6367E+00,1.3904E+00,6.4265E-01,
     &2.5377E+00,2.1918E+00,1.9845E+00,1.6067E+00,6.4523E-01,
     &3.3694E+00,2.7695E+00,2.3848E+00,1.8478E+00,6.4962E-01/
      DATA ((KB(JS,JT,20, 8),JS=1,5),JT=1,5) /
     &6.7593E-01,8.7052E-01,9.5066E-01,9.1950E-01,5.7154E-01,
     &1.0037E+00,1.1265E+00,1.1588E+00,1.0572E+00,5.7670E-01,
     &1.4256E+00,1.4357E+00,1.4052E+00,1.2186E+00,5.8150E-01,
     &1.9488E+00,1.8041E+00,1.6911E+00,1.4006E+00,5.8703E-01,
     &2.5835E+00,2.2440E+00,2.0193E+00,1.6034E+00,5.9399E-01/
      DATA ((KB(JS,JT,21, 8),JS=1,5),JT=1,5) /
     &5.4036E-01,7.5420E-01,8.3572E-01,8.1199E-01,5.0987E-01,
     &7.9845E-01,9.6809E-01,1.0141E+00,9.3456E-01,5.1627E-01,
     &1.1289E+00,1.2252E+00,1.2225E+00,1.0751E+00,5.2292E-01,
     &1.5394E+00,1.5293E+00,1.4635E+00,1.2321E+00,5.3121E-01,
     &2.0388E+00,1.8858E+00,1.7395E+00,1.4066E+00,5.4074E-01/
      DATA ((KB(JS,JT,22, 8),JS=1,5),JT=1,5) /
     &4.5347E-01,6.7088E-01,7.4705E-01,7.2463E-01,4.5233E-01,
     &6.6420E-01,8.5466E-01,9.0352E-01,8.3532E-01,4.6020E-01,
     &9.3312E-01,1.0751E+00,1.0854E+00,9.5995E-01,4.6942E-01,
     &1.2674E+00,1.3357E+00,1.2944E+00,1.0988E+00,4.8015E-01,
     &1.6769E+00,1.6408E+00,1.5338E+00,1.2527E+00,4.9182E-01/
      DATA ((KB(JS,JT,23, 8),JS=1,5),JT=1,5) /
     &3.8192E-01,5.9551E-01,6.6526E-01,6.4489E-01,3.9997E-01,
     &5.5484E-01,7.5433E-01,8.0227E-01,7.4370E-01,4.0956E-01,
     &7.7517E-01,9.4347E-01,9.6125E-01,8.5431E-01,4.2064E-01,
     &1.0504E+00,1.1678E+00,1.1437E+00,9.7728E-01,4.3319E-01,
     &1.3891E+00,1.4314E+00,1.3533E+00,1.1142E+00,4.4599E-01/
      DATA ((KB(JS,JT,24, 8),JS=1,5),JT=1,5) /
     &3.1980E-01,5.2485E-01,5.8816E-01,5.7121E-01,3.5303E-01,
     &4.6136E-01,6.6155E-01,7.0757E-01,6.5873E-01,3.6427E-01,
     &6.4223E-01,8.2371E-01,8.4561E-01,7.5649E-01,3.7674E-01,
     &8.6939E-01,1.0172E+00,1.0047E+00,8.6558E-01,3.8981E-01,
     &1.1484E+00,1.2449E+00,1.1880E+00,9.8717E-01,4.0255E-01/
      DATA ((KB(JS,JT,25, 8),JS=1,5),JT=1,5) /
     &2.7156E-01,4.6457E-01,5.2127E-01,5.0714E-01,3.1176E-01,
     &3.8962E-01,5.8326E-01,6.2605E-01,5.8521E-01,3.2376E-01,
     &5.4140E-01,7.2573E-01,7.4721E-01,6.7267E-01,3.3654E-01,
     &7.3158E-01,8.9514E-01,8.8800E-01,7.7033E-01,3.4916E-01,
     &9.6557E-01,1.0940E+00,1.0510E+00,8.7991E-01,3.6188E-01/
      DATA ((KB(JS,JT,26, 8),JS=1,5),JT=1,5) /
     &2.3603E-01,4.1514E-01,4.6570E-01,4.5317E-01,2.7528E-01,
     &3.3729E-01,5.2062E-01,5.5904E-01,5.2356E-01,2.8722E-01,
     &4.6762E-01,6.4812E-01,6.6791E-01,6.0289E-01,2.9963E-01,
     &6.3043E-01,7.9949E-01,7.9540E-01,6.9207E-01,3.1197E-01,
     &8.2894E-01,9.7604E-01,9.4222E-01,7.9275E-01,3.2460E-01/
      DATA ((KB(JS,JT,27, 8),JS=1,5),JT=1,5) /
     &2.1329E-01,3.7886E-01,4.2295E-01,4.0982E-01,2.4262E-01,
     &3.0405E-01,4.7609E-01,5.0881E-01,4.7490E-01,2.5434E-01,
     &4.2047E-01,5.9404E-01,6.1027E-01,5.4870E-01,2.6611E-01,
     &5.6493E-01,7.3338E-01,7.2904E-01,6.3251E-01,2.7831E-01,
     &7.3961E-01,8.9452E-01,8.6490E-01,7.2735E-01,2.9101E-01/
      DATA ((KB(JS,JT,28, 8),JS=1,5),JT=1,5) /
     &1.9857E-01,3.5152E-01,3.8897E-01,3.7421E-01,2.1366E-01,
     &2.8199E-01,4.4350E-01,4.7029E-01,4.3552E-01,2.2475E-01,
     &3.8828E-01,5.5465E-01,5.6697E-01,5.0558E-01,2.3636E-01,
     &5.1944E-01,6.8554E-01,6.7950E-01,5.8599E-01,2.4843E-01,
     &6.7804E-01,8.3583E-01,8.0789E-01,6.7686E-01,2.6132E-01/
      DATA ((KB(JS,JT,29, 8),JS=1,5),JT=1,5) /
     &1.9699E-01,3.4001E-01,3.6948E-01,3.4985E-01,1.8812E-01,
     &2.7846E-01,4.3155E-01,4.5041E-01,4.0987E-01,1.9891E-01,
     &3.8140E-01,5.4168E-01,5.4658E-01,4.7968E-01,2.1027E-01,
     &5.0817E-01,6.7028E-01,6.5795E-01,5.5982E-01,2.2267E-01,
     &6.6092E-01,8.1811E-01,7.8466E-01,6.5003E-01,2.3569E-01/
      DATA ((KB(JS,JT,30, 8),JS=1,5),JT=1,5) /
     &2.0038E-01,3.3558E-01,3.5744E-01,3.3111E-01,1.6586E-01,
     &2.8170E-01,4.2849E-01,4.3945E-01,3.9159E-01,1.7645E-01,
     &3.8386E-01,5.3939E-01,5.3663E-01,4.6240E-01,1.8797E-01,
     &5.0944E-01,6.6904E-01,6.4909E-01,5.4342E-01,2.0032E-01,
     &6.6110E-01,8.1719E-01,7.7645E-01,6.3464E-01,2.1343E-01/
      DATA ((KB(JS,JT,31, 8),JS=1,5),JT=1,5) /
     &2.1457E-01,3.4491E-01,3.5799E-01,3.2199E-01,1.4677E-01,
     &3.0025E-01,4.4295E-01,4.4440E-01,3.8528E-01,1.5733E-01,
     &4.0706E-01,5.5909E-01,5.4635E-01,4.5932E-01,1.6888E-01,
     &5.3865E-01,6.9458E-01,6.6400E-01,5.4394E-01,1.8129E-01,
     &6.9836E-01,8.4979E-01,7.9754E-01,6.3956E-01,1.9424E-01/
      DATA ((KB(JS,JT,32, 8),JS=1,5),JT=1,5) /
     &2.3301E-01,3.6002E-01,3.6447E-01,3.1806E-01,1.3061E-01,
     &3.2391E-01,4.6378E-01,4.5628E-01,3.8494E-01,1.4116E-01,
     &4.3762E-01,5.8716E-01,5.6420E-01,4.6300E-01,1.5266E-01,
     &5.7844E-01,7.3058E-01,6.8894E-01,5.5249E-01,1.6489E-01,
     &7.5012E-01,8.9521E-01,8.3056E-01,6.5369E-01,1.7758E-01/
      DATA ((KB(JS,JT,33, 8),JS=1,5),JT=1,5) /
     &2.5790E-01,3.8312E-01,3.7883E-01,3.2071E-01,1.1691E-01,
     &3.5669E-01,4.9524E-01,4.7746E-01,3.9236E-01,1.2744E-01,
     &4.8068E-01,6.2777E-01,5.9359E-01,4.7601E-01,1.3874E-01,
     &6.3465E-01,7.8244E-01,7.2784E-01,5.7215E-01,1.5065E-01,
     &8.2463E-01,9.6158E-01,8.8094E-01,6.8112E-01,1.6290E-01/
      DATA ((KB(JS,JT,34, 8),JS=1,5),JT=1,5) /
     &2.7501E-01,3.9928E-01,3.8789E-01,3.2093E-01,1.0495E-01,
     &3.7955E-01,5.1722E-01,4.9202E-01,3.9633E-01,1.1524E-01,
     &5.1074E-01,6.5671E-01,6.1416E-01,4.8473E-01,1.2623E-01,
     &6.7545E-01,8.2065E-01,7.5592E-01,5.8631E-01,1.3772E-01,
     &8.8010E-01,1.0115E+00,9.1893E-01,7.0176E-01,1.4967E-01/
      DATA ((KB(JS,JT,35, 8),JS=1,5),JT=1,5) /
     &2.8491E-01,4.0792E-01,3.9124E-01,3.1768E-01,9.3815E-02,
     &3.9304E-01,5.3008E-01,4.9917E-01,3.9612E-01,1.0372E-01,
     &5.3059E-01,6.7569E-01,6.2665E-01,4.8824E-01,1.1431E-01,
     &7.0463E-01,8.4744E-01,7.7517E-01,5.9483E-01,1.2547E-01,
     &9.2289E-01,1.0490E+00,9.4773E-01,7.1638E-01,1.3729E-01/
      DATA ((KB(JS,JT,36, 8),JS=1,5),JT=1,5) /
     &2.8335E-01,4.0444E-01,3.8444E-01,3.0785E-01,8.3181E-02,
     &3.9231E-01,5.2837E-01,4.9425E-01,3.8787E-01,9.2674E-02,
     &5.3277E-01,6.7716E-01,6.2485E-01,4.8257E-01,1.0284E-01,
     &7.1164E-01,8.5400E-01,7.7825E-01,5.9239E-01,1.1370E-01,
     &9.3841E-01,1.0634E+00,9.5733E-01,7.1881E-01,1.2521E-01/
      DATA ((KB(JS,JT,37, 8),JS=1,5),JT=1,5) /
     &2.6099E-01,3.7794E-01,3.5839E-01,2.8510E-01,7.2608E-02,
     &3.6453E-01,4.9803E-01,4.6544E-01,3.6354E-01,8.1599E-02,
     &4.9925E-01,6.4313E-01,5.9376E-01,4.5692E-01,9.1324E-02,
     &6.7318E-01,8.1735E-01,7.4579E-01,5.6616E-01,1.0177E-01,
     &8.9497E-01,1.0258E+00,9.2402E-01,6.9303E-01,1.1300E-01/
      DATA ((KB(JS,JT,38, 8),JS=1,5),JT=1,5) /
     &2.4331E-01,3.5651E-01,3.3705E-01,2.6611E-01,6.3364E-02,
     &3.4315E-01,4.7401E-01,4.4240E-01,3.4349E-01,7.1841E-02,
     &4.7415E-01,6.1710E-01,5.6959E-01,4.3645E-01,8.1122E-02,
     &6.4535E-01,7.9084E-01,7.2136E-01,5.4612E-01,9.1255E-02,
     &8.6575E-01,1.0005E+00,9.0147E-01,6.7461E-01,1.0216E-01/
      DATA ((KB(JS,JT,39, 8),JS=1,5),JT=1,5) /
     &2.3205E-01,3.4217E-01,3.2219E-01,2.5204E-01,5.5366E-02,
     &3.3051E-01,4.5923E-01,4.2752E-01,3.2956E-01,6.3325E-02,
     &4.6126E-01,6.0310E-01,5.5564E-01,4.2338E-01,7.2166E-02,
     &6.3405E-01,7.7976E-01,7.0985E-01,5.3501E-01,8.2008E-02,
     &8.5903E-01,9.9488E-01,8.9458E-01,6.6726E-01,9.2704E-02/
      DATA ((KB(JS,JT,40, 8),JS=1,5),JT=1,5) /
     &2.0024E-01,3.0416E-01,2.8720E-01,2.2448E-01,4.7646E-02,
     &2.8846E-01,4.1256E-01,3.8572E-01,2.9759E-01,5.5021E-02,
     &4.0740E-01,5.4726E-01,5.0694E-01,3.8698E-01,6.3373E-02,
     &5.6679E-01,7.1454E-01,6.5407E-01,4.9457E-01,7.2804E-02,
     &7.7703E-01,9.2066E-01,8.3239E-01,6.2266E-01,8.3210E-02/
      DATA ((KB(JS,JT,41, 8),JS=1,5),JT=1,5) /
     &1.7113E-01,2.6826E-01,2.5417E-01,1.9867E-01,4.0876E-02,
     &2.4978E-01,3.6831E-01,3.4599E-01,2.6723E-01,4.7680E-02,
     &3.5705E-01,4.9395E-01,4.5991E-01,3.5185E-01,5.5528E-02,
     &5.0326E-01,6.5160E-01,5.9993E-01,4.5499E-01,6.4535E-02,
     &6.9778E-01,8.4752E-01,7.7088E-01,5.7861E-01,7.4659E-02/
      DATA ((KB(JS,JT,42, 8),JS=1,5),JT=1,5) /
     &1.4736E-01,2.3782E-01,2.2594E-01,1.7650E-01,3.4992E-02,
     &2.1817E-01,3.3087E-01,3.1198E-01,2.4105E-01,4.1263E-02,
     &3.1590E-01,4.4893E-01,4.1987E-01,3.2183E-01,4.8631E-02,
     &4.5063E-01,5.9836E-01,5.5343E-01,4.2092E-01,5.7226E-02,
     &6.3264E-01,7.8621E-01,7.1837E-01,5.4085E-01,6.7074E-02/
      DATA ((KB(JS,JT,43, 8),JS=1,5),JT=1,5) /
     &1.2471E-01,2.0767E-01,1.9765E-01,1.5433E-01,2.9617E-02,
     &1.8736E-01,2.9309E-01,2.7736E-01,2.1438E-01,3.5333E-02,
     &2.7561E-01,4.0307E-01,3.7854E-01,2.9057E-01,4.2142E-02,
     &3.9834E-01,5.4356E-01,5.0521E-01,3.8507E-01,5.0246E-02,
     &5.6689E-01,7.2237E-01,6.6289E-01,5.0065E-01,5.9725E-02/
      DATA ((KB(JS,JT,44, 8),JS=1,5),JT=1,5) /
     &1.0535E-01,1.8057E-01,1.7198E-01,1.3418E-01,2.4874E-02,
     &1.6101E-01,2.5912E-01,2.4579E-01,1.8994E-01,3.0018E-02,
     &2.4038E-01,3.6143E-01,3.4064E-01,2.6166E-01,3.6275E-02,
     &3.5302E-01,4.9391E-01,4.6079E-01,3.5170E-01,4.3858E-02,
     &5.0915E-01,6.6446E-01,6.1193E-01,4.6316E-01,5.2911E-02/
      DATA ((KB(JS,JT,45, 8),JS=1,5),JT=1,5) /
     &9.0316E-02,1.5846E-01,1.5081E-01,1.1736E-01,2.0815E-02,
     &1.4022E-01,2.3128E-01,2.1952E-01,1.6935E-01,2.5419E-02,
     &2.1290E-01,3.2756E-01,3.0923E-01,2.3736E-01,3.1129E-02,
     &3.1767E-01,4.5386E-01,4.2443E-01,3.2399E-01,3.8187E-02,
     &4.6514E-01,6.1840E-01,5.7081E-01,4.3233E-01,4.6782E-02/
      DATA ((KB(JS,JT,46, 8),JS=1,5),JT=1,5) /
     &7.6970E-02,1.3789E-01,1.3114E-01,1.0166E-01,1.7264E-02,
     &1.2176E-01,2.0534E-01,1.9482E-01,1.4994E-01,2.1346E-02,
     &1.8790E-01,2.9566E-01,2.7941E-01,2.1415E-01,2.6490E-02,
     &2.8511E-01,4.1574E-01,3.8936E-01,2.9707E-01,3.3007E-02,
     &4.2418E-01,5.7427E-01,5.3095E-01,4.0219E-01,4.1080E-02/
      DATA ((KB(JS,JT,47, 8),JS=1,5),JT=1,5) /
     &6.3210E-02,1.1622E-01,1.1043E-01,8.5380E-02,1.4119E-02,
     &1.0215E-01,1.7705E-01,1.6808E-01,1.2908E-01,1.7662E-02,
     &1.6053E-01,2.5968E-01,2.4579E-01,1.8828E-01,2.2222E-02,
     &2.4774E-01,3.7111E-01,3.4851E-01,2.6604E-01,2.8126E-02,
     &3.7525E-01,5.2022E-01,4.8241E-01,3.6582E-01,3.5589E-02/
      DATA ((KB(JS,JT,48, 8),JS=1,5),JT=1,5) /
     &5.2856E-02,9.8941E-02,9.3700E-02,7.2138E-02,1.1481E-02,
     &8.7380E-02,1.5439E-01,1.4631E-01,1.1192E-01,1.4532E-02,
     &1.4008E-01,2.3111E-01,2.1862E-01,1.6701E-01,1.8538E-02,
     &2.2000E-01,3.3600E-01,3.1573E-01,2.4065E-01,2.3829E-02,
     &3.3939E-01,4.7860E-01,4.4403E-01,3.3641E-01,3.0679E-02/
      DATA ((KB(JS,JT,49, 8),JS=1,5),JT=1,5) /
     &4.5594E-02,8.5787E-02,8.0733E-02,6.1668E-02,9.2832E-03,
     &7.7236E-02,1.3755E-01,1.2964E-01,9.8500E-02,1.1885E-02,
     &1.2646E-01,2.1033E-01,1.9831E-01,1.5059E-01,1.5367E-02,
     &2.0223E-01,3.1150E-01,2.9194E-01,2.2146E-01,2.0076E-02,
     &3.1773E-01,4.5116E-01,4.1757E-01,3.1527E-01,2.6302E-02/
      DATA ((KB(JS,JT,50, 8),JS=1,5),JT=1,5) /
     &3.7552E-02,7.1895E-02,6.7424E-02,5.1302E-02,7.5009E-03,
     &6.5207E-02,1.1840E-01,1.1139E-01,8.4335E-02,9.7205E-03,
     &1.0908E-01,1.8529E-01,1.7464E-01,1.3230E-01,1.2741E-02,
     &1.7795E-01,2.7969E-01,2.6224E-01,1.9866E-01,1.6912E-02,
     &2.8480E-01,4.1182E-01,3.8156E-01,2.8786E-01,2.2557E-02/
      DATA ((KB(JS,JT,51, 8),JS=1,5),JT=1,5) /
     &3.0119E-02,5.9038E-02,5.5227E-02,4.1909E-02,6.0436E-03,
     &5.3723E-02,1.0012E-01,9.4083E-02,7.1011E-02,7.9244E-03,
     &9.1816E-02,1.6026E-01,1.5113E-01,1.1438E-01,1.0530E-02,
     &1.5289E-01,2.4665E-01,2.3169E-01,1.7549E-01,1.4198E-02,
     &2.4923E-01,3.6941E-01,3.4309E-01,2.5907E-01,1.9285E-02/
      DATA ((KB(JS,JT,52, 8),JS=1,5),JT=1,5) /
     &2.4575E-02,4.8862E-02,4.5516E-02,3.4388E-02,4.8448E-03,
     &4.5073E-02,8.5520E-02,8.0105E-02,6.0149E-02,6.4237E-03,
     &7.8951E-02,1.4049E-01,1.3220E-01,9.9732E-02,8.6480E-03,
     &1.3416E-01,2.2067E-01,2.0720E-01,1.5657E-01,1.1852E-02,
     &2.2319E-01,3.3661E-01,3.1253E-01,2.3574E-01,1.6412E-02/
      DATA ((KB(JS,JT,53, 8),JS=1,5),JT=1,5) /
     &2.0612E-02,4.1138E-02,3.8068E-02,2.8547E-02,3.8662E-03,
     &3.9008E-02,7.4441E-02,6.9299E-02,5.1635E-02,5.1786E-03,
     &7.0078E-02,1.2575E-01,1.1775E-01,8.8269E-02,7.0623E-03,
     &1.2164E-01,2.0192E-01,1.8894E-01,1.4209E-01,9.8285E-03,
     &2.0657E-01,3.1414E-01,2.9077E-01,2.1839E-01,1.3889E-02/
      DATA ((KB(JS,JT,54, 8),JS=1,5),JT=1,5) /
     &1.5065E-02,3.1280E-02,2.9021E-02,2.1865E-02,3.0881E-03,
     &2.9415E-02,5.8678E-02,5.4740E-02,4.0841E-02,4.1803E-03,
     &5.4186E-02,1.0195E-01,9.5873E-02,7.1991E-02,5.7700E-03,
     &9.6215E-02,1.6747E-01,1.5763E-01,1.1902E-01,8.1641E-03,
     &1.6671E-01,2.6518E-01,2.4733E-01,1.8663E-01,1.1760E-02/
      DATA ((KB(JS,JT,55, 8),JS=1,5),JT=1,5) /
     &1.0025E-02,2.2183E-02,2.0776E-02,1.5843E-02,2.4606E-03,
     &2.0216E-02,4.3248E-02,4.0605E-02,3.0502E-02,3.3650E-03,
     &3.8225E-02,7.7452E-02,7.3454E-02,5.5488E-02,4.7010E-03,
     &6.9405E-02,1.3019E-01,1.2386E-01,9.4370E-02,6.7604E-03,
     &1.2275E-01,2.0976E-01,1.9836E-01,1.5118E-01,9.9237E-03/
      DATA ((KB(JS,JT,56, 8),JS=1,5),JT=1,5) /
     &6.5953E-03,1.5532E-02,1.4697E-02,1.1369E-02,1.9523E-03,
     &1.3758E-02,3.1499E-02,2.9770E-02,2.2525E-02,2.6931E-03,
     &2.6733E-02,5.8400E-02,5.5794E-02,4.2378E-02,3.8077E-03,
     &4.9676E-02,1.0081E-01,9.6783E-02,7.4327E-02,5.5587E-03,
     &8.9711E-02,1.6544E-01,1.5844E-01,1.2195E-01,8.3185E-03/
      DATA ((KB(JS,JT,57, 8),JS=1,5),JT=1,5) /
     &4.2820E-03,1.0722E-02,1.0258E-02,8.0796E-03,1.5428E-03,
     &9.2544E-03,2.2704E-02,2.1598E-02,1.6468E-02,2.1441E-03,
     &1.8521E-02,4.3686E-02,4.1983E-02,3.2044E-02,3.0664E-03,
     &3.5250E-02,7.7586E-02,7.5143E-02,5.8070E-02,4.5371E-03,
     &6.5084E-02,1.3004E-01,1.2594E-01,9.7902E-02,6.9329E-03/
      DATA ((KB(JS,JT,58, 8),JS=1,5),JT=1,5) /
     &7.3360E-04,2.4101E-03,3.0107E-03,3.3982E-03,1.2193E-03,
     &1.6434E-03,5.3110E-03,6.5569E-03,7.0857E-03,1.7049E-03,
     &3.3887E-03,1.0643E-02,1.3244E-02,1.4263E-02,2.4670E-03,
     &6.6116E-03,1.9492E-02,2.4519E-02,2.6730E-02,3.7032E-03,
     &1.2475E-02,3.3432E-02,4.2135E-02,4.6396E-02,5.7742E-03/
      DATA ((KB(JS,JT,59, 8),JS=1,5),JT=1,5) /
     &6.5322E-04,2.3892E-03,2.8729E-03,2.9916E-03,1.0154E-03,
     &1.4925E-03,5.3944E-03,6.3528E-03,6.2709E-03,1.4376E-03,
     &3.1352E-03,1.1095E-02,1.3136E-02,1.2884E-02,2.1132E-03,
     &6.2265E-03,2.0748E-02,2.4885E-02,2.4670E-02,3.2435E-03,
     &1.1971E-02,3.6140E-02,4.3523E-02,4.3765E-02,5.1685E-03/
      DATA ((KB(JS,JT,13, 9),JS=1,5),JT=1,5) /
     &7.3666E+01,5.5396E+01,3.7129E+01,1.8928E+01,2.0240E+00,
     &1.0840E+02,8.1447E+01,5.4490E+01,2.7556E+01,1.9929E+00,
     &1.5167E+02,1.1389E+02,7.6113E+01,3.8343E+01,1.9601E+00,
     &2.0374E+02,1.5294E+02,1.0214E+02,5.1349E+01,1.9301E+00,
     &2.6449E+02,1.9850E+02,1.3251E+02,6.6525E+01,1.8945E+00/
      DATA ((KB(JS,JT,14, 9),JS=1,5),JT=1,5) /
     &4.2021E+01,3.1664E+01,2.1327E+01,1.1250E+01,2.1001E+00,
     &6.1662E+01,4.6390E+01,3.1123E+01,1.5991E+01,2.0721E+00,
     &8.6125E+01,6.4733E+01,4.3345E+01,2.2004E+01,2.0419E+00,
     &1.1550E+02,8.6758E+01,5.8024E+01,2.9304E+01,2.0094E+00,
     &1.4971E+02,1.1242E+02,7.5125E+01,3.7838E+01,1.9780E+00/
      DATA ((KB(JS,JT,15, 9),JS=1,5),JT=1,5) /
     &2.4325E+01,1.8394E+01,1.2572E+01,7.1971E+00,2.1558E+00,
     &3.5582E+01,2.6831E+01,1.8117E+01,9.7575E+00,2.1305E+00,
     &4.9567E+01,3.7318E+01,2.5078E+01,1.3071E+01,2.1029E+00,
     &6.6327E+01,4.9885E+01,3.3445E+01,1.7135E+01,2.0733E+00,
     &8.5909E+01,6.4569E+01,4.3231E+01,2.1949E+01,2.0415E+00/
      DATA ((KB(JS,JT,16, 9),JS=1,5),JT=1,5) /
     &1.6702E+01,1.2688E+01,8.9156E+00,5.6745E+00,2.1884E+00,
     &2.4341E+01,1.8405E+01,1.2602E+01,7.2943E+00,2.1658E+00,
     &3.3812E+01,2.5504E+01,1.7253E+01,9.4143E+00,2.1418E+00,
     &4.5185E+01,3.4031E+01,2.2894E+01,1.2063E+01,2.1149E+00,
     &5.8502E+01,4.4016E+01,2.9536E+01,1.5253E+01,2.0863E+00/
      DATA ((KB(JS,JT,17, 9),JS=1,5),JT=1,5) /
     &1.1824E+01,9.0729E+00,6.6968E+00,4.8304E+00,2.1968E+00,
     &1.7172E+01,1.3045E+01,9.1828E+00,5.8938E+00,2.1784E+00,
     &2.3815E+01,1.8013E+01,1.2370E+01,7.2830E+00,2.1580E+00,
     &3.1829E+01,2.4018E+01,1.6287E+01,9.0400E+00,2.1352E+00,
     &4.1298E+01,3.1117E+01,2.0970E+01,1.1193E+01,2.1100E+00/
      DATA ((KB(JS,JT,18, 9),JS=1,5),JT=1,5) /
     &8.5582E+00,6.6960E+00,5.3232E+00,4.2870E+00,2.1819E+00,
     &1.2402E+01,9.5125E+00,7.0290E+00,5.0519E+00,2.1680E+00,
     &1.7200E+01,1.3071E+01,9.2389E+00,6.0101E+00,2.1517E+00,
     &2.3032E+01,1.7428E+01,1.2014E+01,7.2086E+00,2.1334E+00,
     &2.9959E+01,2.2618E+01,1.5385E+01,8.6965E+00,2.1122E+00/
      DATA ((KB(JS,JT,19, 9),JS=1,5),JT=1,5) /
     &6.0876E+00,4.9589E+00,4.3617E+00,3.8537E+00,2.1426E+00,
     &8.8178E+00,6.9019E+00,5.5120E+00,4.4148E+00,2.1341E+00,
     &1.2247E+01,9.4065E+00,7.0194E+00,5.0977E+00,2.1226E+00,
     &1.6435E+01,1.2508E+01,8.9285E+00,5.9346E+00,2.1084E+00,
     &2.1395E+01,1.6206E+01,1.1260E+01,6.9507E+00,2.0906E+00/
      DATA ((KB(JS,JT,20, 9),JS=1,5),JT=1,5) /
     &4.7338E+00,4.0618E+00,3.8673E+00,3.5847E+00,2.0812E+00,
     &6.8571E+00,5.5334E+00,4.7582E+00,4.0685E+00,2.0765E+00,
     &9.5336E+00,7.4447E+00,5.9012E+00,4.6250E+00,2.0694E+00,
     &1.2791E+01,9.8219E+00,7.3358E+00,5.2854E+00,2.0598E+00,
     &1.6650E+01,1.2677E+01,9.0899E+00,6.0678E+00,2.0475E+00/
      DATA ((KB(JS,JT,21, 9),JS=1,5),JT=1,5) /
     &3.8172E+00,3.4906E+00,3.5314E+00,3.3393E+00,1.9987E+00,
     &5.5293E+00,4.6505E+00,4.2636E+00,3.7764E+00,1.9988E+00,
     &7.6789E+00,6.1523E+00,5.1831E+00,4.2770E+00,1.9964E+00,
     &1.0301E+01,8.0282E+00,6.3179E+00,4.8454E+00,1.9916E+00,
     &1.3413E+01,1.0296E+01,7.6922E+00,5.4909E+00,1.9849E+00/
      DATA ((KB(JS,JT,22, 9),JS=1,5),JT=1,5) /
     &3.2538E+00,3.1636E+00,3.3083E+00,3.1336E+00,1.8994E+00,
     &4.6904E+00,4.1275E+00,3.9601E+00,3.5392E+00,1.9038E+00,
     &6.4936E+00,5.3647E+00,4.7415E+00,4.0033E+00,1.9062E+00,
     &8.6858E+00,6.9049E+00,5.6919E+00,4.5273E+00,1.9068E+00,
     &1.1287E+01,8.7705E+00,6.8305E+00,5.1089E+00,1.9070E+00/
      DATA ((KB(JS,JT,23, 9),JS=1,5),JT=1,5) /
     &2.7990E+00,2.9004E+00,3.0888E+00,2.9221E+00,1.7866E+00,
     &4.0164E+00,3.7193E+00,3.6884E+00,3.3009E+00,1.7963E+00,
     &5.5385E+00,4.7530E+00,4.3835E+00,3.7336E+00,1.8046E+00,
     &7.3874E+00,6.0323E+00,5.1957E+00,4.2187E+00,1.8111E+00,
     &9.5697E+00,7.5707E+00,6.1486E+00,4.7536E+00,1.8191E+00/
      DATA ((KB(JS,JT,24, 9),JS=1,5),JT=1,5) /
     &2.4093E+00,2.6666E+00,2.8613E+00,2.7031E+00,1.6662E+00,
     &3.4388E+00,3.3672E+00,3.4097E+00,3.0567E+00,1.6812E+00,
     &4.7196E+00,4.2384E+00,4.0418E+00,3.4577E+00,1.6956E+00,
     &6.2610E+00,5.2923E+00,4.7542E+00,3.9053E+00,1.7103E+00,
     &8.0725E+00,6.5459E+00,5.5528E+00,4.3943E+00,1.7280E+00/
      DATA ((KB(JS,JT,25, 9),JS=1,5),JT=1,5) /
     &2.1093E+00,2.4777E+00,2.6576E+00,2.5025E+00,1.5428E+00,
     &2.9902E+00,3.0964E+00,3.1653E+00,2.8347E+00,1.5643E+00,
     &4.0768E+00,3.8394E+00,3.7463E+00,3.2106E+00,1.5865E+00,
     &5.3785E+00,4.7237E+00,4.3881E+00,3.6281E+00,1.6115E+00,
     &6.9128E+00,5.7727E+00,5.0863E+00,4.0788E+00,1.6376E+00/
      DATA ((KB(JS,JT,26, 9),JS=1,5),JT=1,5) /
     &1.8856E+00,2.3262E+00,2.4875E+00,2.3287E+00,1.4224E+00,
     &2.6493E+00,2.8890E+00,2.9641E+00,2.6458E+00,1.4515E+00,
     &3.5871E+00,3.5368E+00,3.5013E+00,3.0021E+00,1.4824E+00,
     &4.7140E+00,4.3024E+00,4.0862E+00,3.3950E+00,1.5166E+00,
     &6.0446E+00,5.2045E+00,4.7238E+00,3.8145E+00,1.5518E+00/
      DATA ((KB(JS,JT,27, 9),JS=1,5),JT=1,5) /
     &1.7455E+00,2.2279E+00,2.3691E+00,2.1938E+00,1.3093E+00,
     &2.4331E+00,2.7544E+00,2.8270E+00,2.5043E+00,1.3459E+00,
     &3.2766E+00,3.3516E+00,3.3333E+00,2.8520E+00,1.3862E+00,
     &4.2923E+00,4.0432E+00,3.8852E+00,3.2303E+00,1.4289E+00,
     &5.4942E+00,4.8565E+00,4.4878E+00,3.6320E+00,1.4726E+00/
      DATA ((KB(JS,JT,28, 9),JS=1,5),JT=1,5) /
     &1.6557E+00,2.1623E+00,2.2857E+00,2.0892E+00,1.2058E+00,
     &2.2924E+00,2.6651E+00,2.7290E+00,2.3996E+00,1.2506E+00,
     &3.0749E+00,3.2332E+00,3.2167E+00,2.7436E+00,1.2996E+00,
     &4.0186E+00,3.8816E+00,3.7505E+00,3.1131E+00,1.3503E+00,
     &5.1433E+00,4.6442E+00,4.3346E+00,3.5087E+00,1.4023E+00/
      DATA ((KB(JS,JT,29, 9),JS=1,5),JT=1,5) /
     &1.6682E+00,2.1786E+00,2.2786E+00,2.0447E+00,1.1144E+00,
     &2.2981E+00,2.6823E+00,2.7239E+00,2.3673E+00,1.1675E+00,
     &3.0738E+00,3.2536E+00,3.2170E+00,2.7185E+00,1.2244E+00,
     &4.0119E+00,3.9041E+00,3.7595E+00,3.0962E+00,1.2824E+00,
     &5.1340E+00,4.6678E+00,4.3550E+00,3.5038E+00,1.3425E+00/
      DATA ((KB(JS,JT,30, 9),JS=1,5),JT=1,5) /
     &1.7221E+00,2.2297E+00,2.3038E+00,2.0342E+00,1.0364E+00,
     &2.3632E+00,2.7462E+00,2.7611E+00,2.3703E+00,1.0967E+00,
     &3.1545E+00,3.3332E+00,3.2697E+00,2.7338E+00,1.1597E+00,
     &4.1176E+00,4.0031E+00,3.8327E+00,3.1282E+00,1.2250E+00,
     &5.2710E+00,4.7910E+00,4.4538E+00,3.5548E+00,1.2942E+00/
      DATA ((KB(JS,JT,31, 9),JS=1,5),JT=1,5) /
     &1.8733E+00,2.3643E+00,2.4037E+00,2.0831E+00,9.7071E-01,
     &2.5621E+00,2.9163E+00,2.8917E+00,2.4413E+00,1.0371E+00,
     &3.4185E+00,3.5458E+00,3.4392E+00,2.8321E+00,1.1068E+00,
     &4.4630E+00,4.2725E+00,4.0472E+00,3.2583E+00,1.1813E+00,
     &5.7201E+00,5.1339E+00,4.7206E+00,3.7217E+00,1.2572E+00/
      DATA ((KB(JS,JT,32, 9),JS=1,5),JT=1,5) /
     &2.0653E+00,2.5337E+00,2.5386E+00,2.1600E+00,9.1680E-01,
     &2.8216E+00,3.1306E+00,3.0669E+00,2.5463E+00,9.8936E-01,
     &3.7648E+00,3.8151E+00,3.6619E+00,2.9702E+00,1.0685E+00,
     &4.9201E+00,4.6180E+00,4.3259E+00,3.4358E+00,1.1502E+00,
     &6.3088E+00,5.5739E+00,5.0619E+00,3.9444E+00,1.2333E+00/
      DATA ((KB(JS,JT,33, 9),JS=1,5),JT=1,5) /
     &2.3272E+00,2.7583E+00,2.7254E+00,2.2760E+00,8.7514E-01,
     &3.1779E+00,3.4161E+00,3.3066E+00,2.6982E+00,9.5639E-01,
     &4.2411E+00,4.1786E+00,3.9626E+00,3.1651E+00,1.0431E+00,
     &5.5462E+00,5.0836E+00,4.6978E+00,3.6805E+00,1.1309E+00,
     &7.1174E+00,6.1675E+00,5.5124E+00,4.2455E+00,1.2216E+00/
      DATA ((KB(JS,JT,34, 9),JS=1,5),JT=1,5) /
     &2.5377E+00,2.9389E+00,2.8782E+00,2.3730E+00,8.4364E-01,
     &3.4681E+00,3.6495E+00,3.5041E+00,2.8278E+00,9.3211E-01,
     &4.6355E+00,4.4791E+00,4.2141E+00,3.3332E+00,1.0240E+00,
     &6.0678E+00,5.4727E+00,5.0128E+00,3.8930E+00,1.1193E+00,
     &7.8056E+00,6.6744E+00,5.8925E+00,4.5074E+00,1.2154E+00/
      DATA ((KB(JS,JT,35, 9),JS=1,5),JT=1,5) /
     &2.6973E+00,3.0775E+00,2.9953E+00,2.4483E+00,8.1381E-01,
     &3.6991E+00,3.8360E+00,3.6636E+00,2.9345E+00,9.0760E-01,
     &4.9601E+00,4.7300E+00,4.4278E+00,3.4777E+00,1.0051E+00,
     &6.5186E+00,5.8127E+00,5.2832E+00,4.0814E+00,1.1048E+00,
     &8.4126E+00,7.1259E+00,6.2273E+00,4.7423E+00,1.2066E+00/
      DATA ((KB(JS,JT,36, 9),JS=1,5),JT=1,5) /
     &2.7598E+00,3.1389E+00,3.0464E+00,2.4794E+00,7.8185E-01,
     &3.8096E+00,3.9341E+00,3.7503E+00,2.9909E+00,8.7896E-01,
     &5.1379E+00,4.8766E+00,4.5549E+00,3.5652E+00,9.8107E-01,
     &6.7937E+00,6.0302E+00,5.4578E+00,4.2069E+00,1.0852E+00,
     &8.8141E+00,7.4326E+00,6.4589E+00,4.9083E+00,1.1912E+00/
      DATA ((KB(JS,JT,37, 9),JS=1,5),JT=1,5) /
     &2.6230E+00,3.0408E+00,2.9596E+00,2.4124E+00,7.3962E-01,
     &3.6580E+00,3.8393E+00,3.6702E+00,2.9331E+00,8.3992E-01,
     &4.9824E+00,4.7866E+00,4.4878E+00,3.5210E+00,9.4491E-01,
     &6.6454E+00,5.9484E+00,5.4110E+00,4.1812E+00,1.0538E+00,
     &8.6934E+00,7.3704E+00,6.4379E+00,4.9067E+00,1.1625E+00/
      DATA ((KB(JS,JT,38, 9),JS=1,5),JT=1,5) /
     &2.5251E+00,2.9721E+00,2.8975E+00,2.3630E+00,7.0093E-01,
     &3.5600E+00,3.7826E+00,3.6219E+00,2.8967E+00,8.0383E-01,
     &4.9004E+00,4.7489E+00,4.4611E+00,3.5032E+00,9.1176E-01,
     &6.5939E+00,5.9343E+00,5.4149E+00,4.1893E+00,1.0245E+00,
     &8.7067E+00,7.4030E+00,6.4798E+00,4.9449E+00,1.1358E+00/
      DATA ((KB(JS,JT,39, 9),JS=1,5),JT=1,5) /
     &2.4904E+00,2.9537E+00,2.8793E+00,2.3443E+00,6.6673E-01,
     &3.5509E+00,3.7917E+00,3.6298E+00,2.8981E+00,7.7181E-01,
     &4.9392E+00,4.7973E+00,4.5055E+00,3.5337E+00,8.8209E-01,
     &6.7119E+00,6.0406E+00,5.5079E+00,4.2551E+00,9.9828E-01,
     &8.9447E+00,7.5957E+00,6.6321E+00,5.0544E+00,1.1121E+00/
      DATA ((KB(JS,JT,40, 9),JS=1,5),JT=1,5) /
     &2.2209E+00,2.7364E+00,2.6885E+00,2.2038E+00,6.2428E-01,
     &3.2135E+00,3.5469E+00,3.4206E+00,2.7501E+00,7.3025E-01,
     &4.5302E+00,4.5210E+00,4.2832E+00,3.3810E+00,8.4222E-01,
     &6.2335E+00,5.7214E+00,5.2769E+00,4.1014E+00,9.6000E-01,
     &8.4037E+00,7.2349E+00,6.3985E+00,4.9070E+00,1.0766E+00/
      DATA ((KB(JS,JT,41, 9),JS=1,5),JT=1,5) /
     &1.9647E+00,2.5201E+00,2.4974E+00,2.0614E+00,5.8325E-01,
     &2.8852E+00,3.2999E+00,3.2081E+00,2.5978E+00,6.8959E-01,
     &4.1243E+00,4.2421E+00,4.0540E+00,3.2221E+00,8.0263E-01,
     &5.7517E+00,5.3978E+00,5.0364E+00,3.9392E+00,9.2181E-01,
     &7.8523E+00,6.8657E+00,6.1521E+00,4.7480E+00,1.0405E+00/
      DATA ((KB(JS,JT,42, 9),JS=1,5),JT=1,5) /
     &1.7512E+00,2.3349E+00,2.3318E+00,1.9366E+00,5.4463E-01,
     &2.6144E+00,3.0905E+00,3.0258E+00,2.4663E+00,6.5106E-01,
     &3.7920E+00,4.0117E+00,3.8605E+00,3.0859E+00,7.6489E-01,
     &5.3603E+00,5.1368E+00,4.8392E+00,3.8039E+00,8.8471E-01,
     &7.4143E+00,6.5758E+00,5.9582E+00,4.6208E+00,1.0054E+00/
      DATA ((KB(JS,JT,43, 9),JS=1,5),JT=1,5) /
     &1.5310E+00,2.1360E+00,2.1508E+00,1.7978E+00,5.0265E-01,
     &2.3335E+00,2.8636E+00,2.8240E+00,2.3172E+00,6.0791E-01,
     &3.4398E+00,3.7600E+00,3.6428E+00,2.9301E+00,7.2170E-01,
     &4.9392E+00,4.8535E+00,4.6142E+00,3.6458E+00,8.4218E-01,
     &6.9338E+00,6.2557E+00,5.7358E+00,4.4687E+00,9.6366E-01/
      DATA ((KB(JS,JT,44, 9),JS=1,5),JT=1,5) /
     &1.3351E+00,1.9503E+00,1.9789E+00,1.6632E+00,4.6023E-01,
     &2.0772E+00,2.6507E+00,2.6321E+00,2.1724E+00,5.6381E-01,
     &3.1248E+00,3.5269E+00,3.4366E+00,2.7797E+00,6.7693E-01,
     &4.5611E+00,4.5989E+00,4.4033E+00,3.4949E+00,7.9737E-01,
     &6.5042E+00,5.9719E+00,5.5317E+00,4.3254E+00,9.1937E-01/
      DATA ((KB(JS,JT,45, 9),JS=1,5),JT=1,5) /
     &1.1794E+00,1.7969E+00,1.8343E+00,1.5476E+00,4.2007E-01,
     &1.8762E+00,2.4795E+00,2.4742E+00,2.0501E+00,5.2163E-01,
     &2.8809E+00,3.3442E+00,3.2721E+00,2.6566E+00,6.3409E-01,
     &4.2825E+00,4.4131E+00,4.2443E+00,3.3788E+00,7.5354E-01,
     &6.2077E+00,5.7830E+00,5.3934E+00,4.2249E+00,8.7651E-01/
      DATA ((KB(JS,JT,46, 9),JS=1,5),JT=1,5) /
     &1.0327E+00,1.6453E+00,1.6900E+00,1.4307E+00,3.8001E-01,
     &1.6840E+00,2.3071E+00,2.3154E+00,1.9251E+00,4.7892E-01,
     &2.6449E+00,3.1623E+00,3.1054E+00,2.5294E+00,5.8968E-01,
     &4.0149E+00,4.2299E+00,4.0828E+00,3.2577E+00,7.0805E-01,
     &5.9211E+00,5.5984E+00,5.2528E+00,4.1223E+00,8.3110E-01/
      DATA ((KB(JS,JT,47, 9),JS=1,5),JT=1,5) /
     &8.6791E-01,1.4650E+00,1.5175E+00,1.2909E+00,3.3829E-01,
     &1.4548E+00,2.0919E+00,2.1155E+00,1.7684E+00,4.3374E-01,
     &2.3437E+00,2.9171E+00,2.8820E+00,2.3592E+00,5.4146E-01,
     &3.6410E+00,3.9658E+00,3.8455E+00,3.0807E+00,6.5808E-01,
     &5.4757E+00,5.2982E+00,5.0168E+00,3.9488E+00,7.8042E-01/
      DATA ((KB(JS,JT,48, 9),JS=1,5),JT=1,5) /
     &7.4197E-01,1.3175E+00,1.3727E+00,1.1710E+00,2.9912E-01,
     &1.2795E+00,1.9175E+00,1.9504E+00,1.6359E+00,3.9088E-01,
     &2.1163E+00,2.7243E+00,2.7026E+00,2.2191E+00,4.9535E-01,
     &3.3685E+00,3.7692E+00,3.6648E+00,2.9415E+00,6.0991E-01,
     &5.1784E+00,5.1043E+00,4.8553E+00,3.8227E+00,7.3131E-01/
      DATA ((KB(JS,JT,49, 9),JS=1,5),JT=1,5) /
     &6.5229E-01,1.2051E+00,1.2591E+00,1.0738E+00,2.6269E-01,
     &1.1591E+00,1.7908E+00,1.8269E+00,1.5329E+00,3.5032E-01,
     &1.9719E+00,2.5959E+00,2.5784E+00,2.1177E+00,4.5127E-01,
     &3.2176E+00,3.6617E+00,3.5592E+00,2.8538E+00,5.6309E-01,
     &5.0660E+00,5.0444E+00,4.7964E+00,3.7669E+00,6.8298E-01/
      DATA ((KB(JS,JT,50, 9),JS=1,5),JT=1,5) /
     &5.4718E-01,1.0700E+00,1.1242E+00,9.6269E-01,2.3041E-01,
     &1.0029E+00,1.6230E+00,1.6660E+00,1.4048E+00,3.1350E-01,
     &1.7557E+00,2.3977E+00,2.3952E+00,1.9754E+00,4.1052E-01,
     &2.9398E+00,3.4467E+00,3.3608E+00,2.7053E+00,5.1916E-01,
     &4.7374E+00,4.8217E+00,4.6033E+00,3.6228E+00,6.3755E-01/
      DATA ((KB(JS,JT,51, 9),JS=1,5),JT=1,5) /
     &4.4659E-01,9.3305E-01,9.8713E-01,8.5042E-01,2.0131E-01,
     &8.4503E-01,1.4458E+00,1.4962E+00,1.2698E+00,2.7950E-01,
     &1.5227E+00,2.1776E+00,2.1908E+00,1.8185E+00,3.7211E-01,
     &2.6197E+00,3.1878E+00,3.1271E+00,2.5305E+00,4.7775E-01,
     &4.3246E+00,4.5333E+00,4.3504E+00,3.4392E+00,5.9331E-01/
      DATA ((KB(JS,JT,52, 9),JS=1,5),JT=1,5) /
     &3.7000E-01,8.2088E-01,8.7232E-01,7.5398E-01,1.7473E-01,
     &7.2411E-01,1.3013E+00,1.3548E+00,1.1545E+00,2.4775E-01,
     &1.3455E+00,2.0001E+00,2.0236E+00,1.6871E+00,3.3555E-01,
     &2.3815E+00,2.9886E+00,2.9408E+00,2.3888E+00,4.3798E-01,
     &4.0315E+00,4.3264E+00,4.1654E+00,3.2990E+00,5.5079E-01/
      DATA ((KB(JS,JT,53, 9),JS=1,5),JT=1,5) /
     &3.1522E-01,7.3236E-01,7.7935E-01,6.7369E-01,1.5034E-01,
     &6.3787E-01,1.1908E+00,1.2433E+00,1.0610E+00,2.1835E-01,
     &1.2250E+00,1.8717E+00,1.8985E+00,1.5852E+00,3.0124E-01,
     &2.2328E+00,2.8593E+00,2.8149E+00,2.2876E+00,3.9993E-01,
     &3.8806E+00,4.2255E+00,4.0654E+00,3.2164E+00,5.0965E-01/
      DATA ((KB(JS,JT,54, 9),JS=1,5),JT=1,5) /
     &2.3422E-01,6.0076E-01,6.4671E-01,5.6503E-01,1.2928E-01,
     &4.9005E-01,1.0010E+00,1.0587E+00,9.1460E-01,1.9217E-01,
     &9.7166E-01,1.6014E+00,1.6473E+00,1.3943E+00,2.7068E-01,
     &1.8237E+00,2.4909E+00,2.4828E+00,2.0443E+00,3.6438E-01,
     &3.2575E+00,3.7456E+00,3.6419E+00,2.9148E+00,4.7112E-01/
      DATA ((KB(JS,JT,55, 9),JS=1,5),JT=1,5) /
     &1.5838E-01,4.6639E-01,5.1049E-01,4.5411E-01,1.1083E-01,
     &3.4306E-01,7.9590E-01,8.5878E-01,7.5589E-01,1.6856E-01,
     &7.0266E-01,1.2949E+00,1.3605E+00,1.1760E+00,2.4233E-01,
     &1.3593E+00,2.0439E+00,2.0790E+00,1.7490E+00,3.3108E-01,
     &2.4959E+00,3.1221E+00,3.0894E+00,2.5235E+00,4.3367E-01/
      DATA ((KB(JS,JT,56, 9),JS=1,5),JT=1,5) /
     &1.0564E-01,3.5968E-01,4.0062E-01,3.6250E-01,9.4093E-02,
     &2.3778E-01,6.3076E-01,6.9353E-01,6.2192E-01,1.4691E-01,
     &5.0289E-01,1.0440E+00,1.1212E+00,9.8957E-01,2.1564E-01,
     &1.0047E+00,1.6731E+00,1.7388E+00,1.4948E+00,2.9947E-01,
     &1.8976E+00,2.5969E+00,2.6179E+00,2.1832E+00,3.9803E-01/
      DATA ((KB(JS,JT,57, 9),JS=1,5),JT=1,5) /
     &6.9404E-02,2.7490E-01,3.1190E-01,2.8693E-01,7.9174E-02,
     &1.6275E-01,4.9714E-01,5.5717E-01,5.0875E-01,1.2713E-01,
     &3.5620E-01,8.3998E-01,9.2115E-01,8.2990E-01,1.9063E-01,
     &7.3515E-01,1.3656E+00,1.4515E+00,1.2750E+00,2.6981E-01,
     &1.4305E+00,2.1547E+00,2.2152E+00,1.8869E+00,3.6361E-01/
      DATA ((KB(JS,JT,58, 9),JS=1,5),JT=1,5) /
     &1.2018E-02,6.8819E-02,1.0253E-01,1.3454E-01,6.6409E-02,
     &2.9376E-02,1.2869E-01,1.8932E-01,2.4688E-01,1.0988E-01,
     &6.6678E-02,2.2200E-01,3.2071E-01,4.1332E-01,1.6852E-01,
     &1.4218E-01,3.6629E-01,5.1309E-01,6.4691E-01,2.4300E-01,
     &2.8506E-01,5.8551E-01,7.9229E-01,9.6816E-01,3.3198E-01/
      DATA ((KB(JS,JT,59, 9),JS=1,5),JT=1,5) /
     &1.0974E-02,7.7674E-02,1.1174E-01,1.3484E-01,6.0877E-02,
     &2.7572E-02,1.4726E-01,2.0947E-01,2.5117E-01,1.0237E-01,
     &6.4218E-02,2.5542E-01,3.5789E-01,4.2487E-01,1.5885E-01,
     &1.3998E-01,4.2159E-01,5.7382E-01,6.6846E-01,2.3069E-01,
     &2.8653E-01,6.7350E-01,8.8507E-01,9.9974E-01,3.1701E-01/
      DATA ((KB(JS,JT,13,10),JS=1,5),JT=1,5) /
     &3.0887E+02,2.3182E+02,1.5477E+02,7.7734E+01,3.2340E+00,
     &4.5010E+02,3.3773E+02,2.2537E+02,1.1301E+02,3.1679E+00,
     &6.1970E+02,4.6492E+02,3.1014E+02,1.5536E+02,3.1118E+00,
     &8.1413E+02,6.1074E+02,4.0734E+02,2.0395E+02,3.0351E+00,
     &1.0345E+03,7.7604E+02,5.1753E+02,2.5903E+02,2.9847E+00/
      DATA ((KB(JS,JT,14,10),JS=1,5),JT=1,5) /
     &1.8722E+02,1.4057E+02,9.3932E+01,4.7308E+01,3.5502E+00,
     &2.7007E+02,2.0269E+02,1.3533E+02,6.7970E+01,3.4874E+00,
     &3.6889E+02,2.7681E+02,1.8473E+02,9.2654E+01,3.4323E+00,
     &4.8380E+02,3.6298E+02,2.4217E+02,1.2136E+02,3.3766E+00,
     &6.1384E+02,4.6051E+02,3.0717E+02,1.5385E+02,3.3022E+00/
      DATA ((KB(JS,JT,15,10),JS=1,5),JT=1,5) /
     &1.1327E+02,8.5100E+01,5.6942E+01,2.8827E+01,3.8722E+00,
     &1.6194E+02,1.2160E+02,8.1262E+01,4.0948E+01,3.8151E+00,
     &2.2047E+02,1.6549E+02,1.1051E+02,5.5552E+01,3.7597E+00,
     &2.8853E+02,2.1653E+02,1.4453E+02,7.2538E+01,3.6967E+00,
     &3.6531E+02,2.7411E+02,1.8291E+02,9.1708E+01,3.6313E+00/
      DATA ((KB(JS,JT,16,10),JS=1,5),JT=1,5) /
     &8.0065E+01,6.0189E+01,4.0328E+01,2.0552E+01,4.2109E+00,
     &1.1401E+02,8.5639E+01,5.7279E+01,2.8971E+01,4.1507E+00,
     &1.5472E+02,1.1617E+02,7.7619E+01,3.9099E+01,4.0906E+00,
     &2.0197E+02,1.5160E+02,1.0123E+02,5.0878E+01,4.0252E+00,
     &2.5492E+02,1.9130E+02,1.2769E+02,6.4095E+01,3.9532E+00/
      DATA ((KB(JS,JT,17,10),JS=1,5),JT=1,5) /
     &5.7968E+01,4.3609E+01,2.9277E+01,1.5223E+01,4.5287E+00,
     &8.2190E+01,6.1765E+01,4.1354E+01,2.1049E+01,4.4713E+00,
     &1.1116E+02,8.3481E+01,5.5816E+01,2.8216E+01,4.4079E+00,
     &1.4447E+02,1.0846E+02,7.2459E+01,3.6495E+01,4.3339E+00,
     &1.8168E+02,1.3637E+02,9.1060E+01,4.5781E+01,4.2592E+00/
      DATA ((KB(JS,JT,18,10),JS=1,5),JT=1,5) /
     &4.2612E+01,3.2081E+01,2.1612E+01,1.2271E+01,4.8071E+00,
     &6.0147E+01,4.5223E+01,3.0329E+01,1.5934E+01,4.7499E+00,
     &8.0941E+01,6.0812E+01,4.0702E+01,2.0761E+01,4.6797E+00,
     &1.0473E+02,7.8652E+01,5.2586E+01,2.6600E+01,4.6080E+00,
     &1.3143E+02,9.8677E+01,6.5930E+01,3.3232E+01,4.5353E+00/
      DATA ((KB(JS,JT,19,10),JS=1,5),JT=1,5) /
     &3.0448E+01,2.2951E+01,1.5620E+01,1.0168E+01,5.0350E+00,
     &4.2741E+01,3.2162E+01,2.1658E+01,1.2576E+01,4.9712E+00,
     &5.7239E+01,4.3029E+01,2.8857E+01,1.5561E+01,4.9060E+00,
     &7.3990E+01,5.5595E+01,3.7227E+01,1.9263E+01,4.8462E+00,
     &9.3283E+01,7.0062E+01,4.6859E+01,2.3820E+01,4.7826E+00/
      DATA ((KB(JS,JT,20,10),JS=1,5),JT=1,5) /
     &2.3494E+01,1.7742E+01,1.2645E+01,9.3657E+00,5.1974E+00,
     &3.2767E+01,2.4679E+01,1.6836E+01,1.0930E+01,5.1468E+00,
     &4.3805E+01,3.2955E+01,2.2186E+01,1.3029E+01,5.0951E+00,
     &5.6900E+01,4.2771E+01,2.8686E+01,1.5712E+01,5.0360E+00,
     &7.2009E+01,5.4098E+01,3.6220E+01,1.9012E+01,4.9716E+00/
      DATA ((KB(JS,JT,21,10),JS=1,5),JT=1,5) /
     &1.8574E+01,1.4067E+01,1.0798E+01,9.1144E+00,5.2989E+00,
     &2.5833E+01,1.9488E+01,1.3882E+01,1.0250E+01,5.2602E+00,
     &3.4706E+01,2.6128E+01,1.7872E+01,1.1627E+01,5.2166E+00,
     &4.5183E+01,3.3979E+01,2.2895E+01,1.3514E+01,5.1658E+00,
     &5.7162E+01,4.2958E+01,2.8816E+01,1.5946E+01,5.1078E+00/
      DATA ((KB(JS,JT,22,10),JS=1,5),JT=1,5) /
     &1.5385E+01,1.1760E+01,9.8072E+00,8.9715E+00,5.3316E+00,
     &2.1421E+01,1.6187E+01,1.2154E+01,1.0019E+01,5.3065E+00,
     &2.8763E+01,2.1675E+01,1.5363E+01,1.1158E+01,5.2767E+00,
     &3.7378E+01,2.8123E+01,1.9262E+01,1.2474E+01,5.2393E+00,
     &4.7335E+01,3.5583E+01,2.3996E+01,1.4183E+01,5.1848E+00/
      DATA ((KB(JS,JT,23,10),JS=1,5),JT=1,5) /
     &1.2958E+01,1.0148E+01,9.3026E+00,8.7646E+00,5.3174E+00,
     &1.8016E+01,1.3712E+01,1.1027E+01,9.7388E+00,5.3065E+00,
     &2.4116E+01,1.8203E+01,1.3458E+01,1.0800E+01,5.2863E+00,
     &3.1331E+01,2.3589E+01,1.6625E+01,1.1918E+01,5.2605E+00,
     &3.9751E+01,2.9901E+01,2.0473E+01,1.3180E+01,5.2164E+00/
      DATA ((KB(JS,JT,24,10),JS=1,5),JT=1,5) /
     &1.0965E+01,8.9178E+00,8.8968E+00,8.4756E+00,5.2609E+00,
     &1.5180E+01,1.1787E+01,1.0354E+01,9.3845E+00,5.2622E+00,
     &2.0304E+01,1.5418E+01,1.2131E+01,1.0371E+01,5.2552E+00,
     &2.6453E+01,1.9955E+01,1.4586E+01,1.1412E+01,5.2428E+00,
     &3.3727E+01,2.5409E+01,1.7807E+01,1.2537E+01,5.2080E+00/
      DATA ((KB(JS,JT,25,10),JS=1,5),JT=1,5) /
     &9.4802E+00,8.0678E+00,8.5346E+00,8.1689E+00,5.1602E+00,
     &1.3091E+01,1.0412E+01,9.8804E+00,9.0420E+00,5.1798E+00,
     &1.7556E+01,1.3502E+01,1.1390E+01,9.9740E+00,5.1919E+00,
     &2.2937E+01,1.7389E+01,1.3318E+01,1.0956E+01,5.1855E+00,
     &2.9162E+01,2.2007E+01,1.5910E+01,1.2043E+01,5.1753E+00/
      DATA ((KB(JS,JT,26,10),JS=1,5),JT=1,5) /
     &8.4883E+00,7.6029E+00,8.2305E+00,7.8781E+00,5.0300E+00,
     &1.1732E+01,9.5611E+00,9.4929E+00,8.7340E+00,5.0703E+00,
     &1.5710E+01,1.2274E+01,1.0941E+01,9.6483E+00,5.1008E+00,
     &2.0377E+01,1.5577E+01,1.2626E+01,1.0617E+01,5.1143E+00,
     &2.5762E+01,1.9497E+01,1.4646E+01,1.1691E+01,5.1337E+00/
      DATA ((KB(JS,JT,27,10),JS=1,5),JT=1,5) /
     &7.9831E+00,7.4657E+00,8.0386E+00,7.6712E+00,4.8762E+00,
     &1.1007E+01,9.2258E+00,9.2928E+00,8.5396E+00,4.9402E+00,
     &1.4621E+01,1.1594E+01,1.0757E+01,9.4652E+00,4.9915E+00,
     &1.8847E+01,1.4547E+01,1.2326E+01,1.0475E+01,5.0304E+00,
     &2.3744E+01,1.8045E+01,1.4056E+01,1.1545E+01,5.0808E+00/
      DATA ((KB(JS,JT,28,10),JS=1,5),JT=1,5) /
     &7.7237E+00,7.4713E+00,7.9486E+00,7.5349E+00,4.7172E+00,
     &1.0564E+01,9.1113E+00,9.2602E+00,8.4182E+00,4.8066E+00,
     &1.3950E+01,1.1225E+01,1.0715E+01,9.3795E+00,4.8773E+00,
     &1.7938E+01,1.3957E+01,1.2227E+01,1.0437E+01,4.9557E+00,
     &2.2520E+01,1.7201E+01,1.3827E+01,1.1495E+01,5.0256E+00/
      DATA ((KB(JS,JT,29,10),JS=1,5),JT=1,5) /
     &7.9252E+00,7.7575E+00,8.1492E+00,7.5791E+00,4.5608E+00,
     &1.0756E+01,9.3871E+00,9.5612E+00,8.5083E+00,4.6721E+00,
     &1.4151E+01,1.1455E+01,1.1026E+01,9.5615E+00,4.7742E+00,
     &1.8135E+01,1.4153E+01,1.2557E+01,1.0665E+01,4.8851E+00,
     &2.2757E+01,1.7409E+01,1.4161E+01,1.1730E+01,4.9738E+00/
      DATA ((KB(JS,JT,30,10),JS=1,5),JT=1,5) /
     &8.3260E+00,8.1445E+00,8.5115E+00,7.7075E+00,4.4112E+00,
     &1.1239E+01,9.8059E+00,9.9796E+00,8.7369E+00,4.5506E+00,
     &1.4731E+01,1.1916E+01,1.1495E+01,9.8748E+00,4.7011E+00,
     &1.8856E+01,1.4710E+01,1.3064E+01,1.1008E+01,4.8328E+00,
     &2.3705E+01,1.8124E+01,1.4716E+01,1.2119E+01,4.9257E+00/
      DATA ((KB(JS,JT,31,10),JS=1,5),JT=1,5) /
     &9.2196E+00,8.8116E+00,9.1465E+00,8.0622E+00,4.2873E+00,
     &1.2392E+01,1.0607E+01,1.0704E+01,9.2367E+00,4.4733E+00,
     &1.6211E+01,1.2983E+01,1.2309E+01,1.0449E+01,4.6511E+00,
     &2.0762E+01,1.6100E+01,1.3996E+01,1.1659E+01,4.7878E+00,
     &2.6150E+01,1.9908E+01,1.5819E+01,1.2859E+01,4.9198E+00/
      DATA ((KB(JS,JT,32,10),JS=1,5),JT=1,5) /
     &1.0359E+01,9.6137E+00,9.8752E+00,8.5830E+00,4.2174E+00,
     &1.3877E+01,1.1631E+01,1.1538E+01,9.8576E+00,4.4285E+00,
     &1.8140E+01,1.4380E+01,1.3269E+01,1.1160E+01,4.5970E+00,
     &2.3264E+01,1.7927E+01,1.5118E+01,1.2461E+01,4.7493E+00,
     &2.9418E+01,2.2303E+01,1.7227E+01,1.3746E+01,4.9087E+00/
      DATA ((KB(JS,JT,33,10),JS=1,5),JT=1,5) /
     &1.1859E+01,1.0640E+01,1.0773E+01,9.2560E+00,4.1651E+00,
     &1.5884E+01,1.3011E+01,1.2572E+01,1.0635E+01,4.3715E+00,
     &2.0782E+01,1.6260E+01,1.4502E+01,1.2047E+01,4.5449E+00,
     &2.6731E+01,2.0436E+01,1.6585E+01,1.3454E+01,4.7445E+00,
     &3.3983E+01,2.5659E+01,1.9186E+01,1.4880E+01,4.8947E+00/
      DATA ((KB(JS,JT,34,10),JS=1,5),JT=1,5) /
     &1.3139E+01,1.1513E+01,1.1537E+01,9.8375E+00,4.1077E+00,
     &1.7636E+01,1.4225E+01,1.3489E+01,1.1311E+01,4.3160E+00,
     &2.3141E+01,1.7962E+01,1.5594E+01,1.2810E+01,4.5443E+00,
     &2.9960E+01,2.2778E+01,1.7924E+01,1.4335E+01,4.7397E+00,
     &3.8261E+01,2.8825E+01,2.1079E+01,1.5921E+01,4.9149E+00/
      DATA ((KB(JS,JT,35,10),JS=1,5),JT=1,5) /
     &1.4201E+01,1.2261E+01,1.2213E+01,1.0330E+01,4.0399E+00,
     &1.9135E+01,1.5305E+01,1.4323E+01,1.1895E+01,4.2894E+00,
     &2.5318E+01,1.9545E+01,1.6589E+01,1.3508E+01,4.5397E+00,
     &3.3021E+01,2.5025E+01,1.9285E+01,1.5170E+01,4.7565E+00,
     &4.2461E+01,3.1954E+01,2.3012E+01,1.6958E+01,4.9332E+00/
      DATA ((KB(JS,JT,36,10),JS=1,5),JT=1,5) /
     &1.4798E+01,1.2717E+01,1.2670E+01,1.0657E+01,3.9724E+00,
     &2.0092E+01,1.6016E+01,1.4899E+01,1.2316E+01,4.2681E+00,
     &2.6852E+01,2.0677E+01,1.7358E+01,1.4052E+01,4.5368E+00,
     &3.5362E+01,2.6747E+01,2.0391E+01,1.5864E+01,4.7528E+00,
     &4.5869E+01,3.4503E+01,2.4644E+01,1.7859E+01,4.9480E+00/
      DATA ((KB(JS,JT,37,10),JS=1,5),JT=1,5) /
     &1.4369E+01,1.2549E+01,1.2615E+01,1.0629E+01,3.8875E+00,
     &1.9757E+01,1.5840E+01,1.4922E+01,1.2359E+01,4.2086E+00,
     &2.6704E+01,2.0605E+01,1.7493E+01,1.4185E+01,4.4864E+00,
     &3.5588E+01,2.6935E+01,2.0650E+01,1.6109E+01,4.7274E+00,
     &4.6659E+01,3.5099E+01,2.5115E+01,1.8232E+01,4.9396E+00/
      DATA ((KB(JS,JT,38,10),JS=1,5),JT=1,5) /
     &1.4144E+01,1.2516E+01,1.2646E+01,1.0674E+01,3.8121E+00,
     &1.9692E+01,1.5869E+01,1.5055E+01,1.2490E+01,4.1526E+00,
     &2.6928E+01,2.0800E+01,1.7766E+01,1.4428E+01,4.4461E+00,
     &3.6364E+01,2.7528E+01,2.1122E+01,1.6470E+01,4.6931E+00,
     &4.8190E+01,3.6248E+01,2.5894E+01,1.8774E+01,4.9281E+00/
      DATA ((KB(JS,JT,39,10),JS=1,5),JT=1,5) /
     &1.4265E+01,1.2699E+01,1.2840E+01,1.0848E+01,3.7413E+00,
     &2.0117E+01,1.6218E+01,1.5387E+01,1.2783E+01,4.1060E+00,
     &2.7852E+01,2.1494E+01,1.8320E+01,1.4851E+01,4.4149E+00,
     &3.8047E+01,2.8782E+01,2.1981E+01,1.7084E+01,4.6584E+00,
     &5.1036E+01,3.8378E+01,2.7311E+01,1.9599E+01,4.9209E+00/
      DATA ((KB(JS,JT,40,10),JS=1,5),JT=1,5) /
     &1.3045E+01,1.2072E+01,1.2332E+01,1.0515E+01,3.6349E+00,
     &1.8669E+01,1.5342E+01,1.4892E+01,1.2474E+01,4.0124E+00,
     &2.6244E+01,2.0390E+01,1.7841E+01,1.4589E+01,4.3337E+00,
     &3.6291E+01,2.7528E+01,2.1453E+01,1.6896E+01,4.5936E+00,
     &4.9350E+01,3.7123E+01,2.6680E+01,1.9495E+01,4.8667E+00/
      DATA ((KB(JS,JT,41,10),JS=1,5),JT=1,5) /
     &1.1803E+01,1.1439E+01,1.1786E+01,1.0149E+01,3.5171E+00,
     &1.7194E+01,1.4495E+01,1.4344E+01,1.2127E+01,3.9113E+00,
     &2.4539E+01,1.9243E+01,1.7307E+01,1.4275E+01,4.2454E+00,
     &3.4381E+01,2.6175E+01,2.0871E+01,1.6646E+01,4.5236E+00,
     &4.7387E+01,3.5674E+01,2.5938E+01,1.9314E+01,4.8021E+00/
      DATA ((KB(JS,JT,42,10),JS=1,5),JT=1,5) /
     &1.0775E+01,1.0903E+01,1.1326E+01,9.8291E+00,3.4027E+00,
     &1.5966E+01,1.3847E+01,1.3900E+01,1.1829E+01,3.8068E+00,
     &2.3163E+01,1.8350E+01,1.6888E+01,1.4033E+01,4.1524E+00,
     &3.2905E+01,2.5146E+01,2.0462E+01,1.6474E+01,4.4507E+00,
     &4.5959E+01,3.4632E+01,2.5458E+01,1.9233E+01,4.7372E+00/
      DATA ((KB(JS,JT,43,10),JS=1,5),JT=1,5) /
     &9.6785E+00,1.0293E+01,1.0788E+01,9.4380E+00,3.2651E+00,
     &1.4578E+01,1.3133E+01,1.3380E+01,1.1460E+01,3.6820E+00,
     &2.1568E+01,1.7343E+01,1.6367E+01,1.3704E+01,4.0432E+00,
     &3.1160E+01,2.3941E+01,1.9961E+01,1.6215E+01,4.3540E+00,
     &4.4112E+01,3.3295E+01,2.4834E+01,1.9063E+01,4.6487E+00/
      DATA ((KB(JS,JT,44,10),JS=1,5),JT=1,5) /
     &8.6703E+00,9.7103E+00,1.0263E+01,9.0428E+00,3.1167E+00,
     &1.3323E+01,1.2507E+01,1.2872E+01,1.1099E+01,3.5429E+00,
     &2.0055E+01,1.6451E+01,1.5900E+01,1.3381E+01,3.9213E+00,
     &2.9535E+01,2.2835E+01,1.9530E+01,1.5970E+01,4.2481E+00,
     &4.2449E+01,3.2099E+01,2.4329E+01,1.8926E+01,4.5571E+00/
      DATA ((KB(JS,JT,45,10),JS=1,5),JT=1,5) /
     &7.8818E+00,9.2454E+00,9.8403E+00,8.7130E+00,2.9638E+00,
     &1.2355E+01,1.2035E+01,1.2482E+01,1.0822E+01,3.4038E+00,
     &1.8948E+01,1.5842E+01,1.5587E+01,1.3162E+01,3.7919E+00,
     &2.8443E+01,2.2122E+01,1.9322E+01,1.5846E+01,4.1405E+00,
     &4.1558E+01,3.1475E+01,2.4163E+01,1.8949E+01,4.4650E+00/
      DATA ((KB(JS,JT,46,10),JS=1,5),JT=1,5) /
     &7.1089E+00,8.7733E+00,9.3941E+00,8.3547E+00,2.8054E+00,
     &1.1401E+01,1.1562E+01,1.2067E+01,1.0520E+01,3.2536E+00,
     &1.7834E+01,1.5248E+01,1.5247E+01,1.2927E+01,3.6528E+00,
     &2.7249E+01,2.1375E+01,1.9093E+01,1.5705E+01,4.0192E+00,
     &4.0651E+01,3.0866E+01,2.4015E+01,1.8943E+01,4.3574E+00/
      DATA ((KB(JS,JT,47,10),JS=1,5),JT=1,5) /
     &6.1649E+00,8.1403E+00,8.7798E+00,7.8562E+00,2.6253E+00,
     &1.0138E+01,1.0874E+01,1.1437E+01,1.0055E+01,3.0768E+00,
     &1.6220E+01,1.4389E+01,1.4631E+01,1.2502E+01,3.4927E+00,
     &2.5292E+01,2.0083E+01,1.8506E+01,1.5334E+01,3.8713E+00,
     &3.8579E+01,2.9419E+01,2.3431E+01,1.8659E+01,4.2295E+00/
      DATA ((KB(JS,JT,48,10),JS=1,5),JT=1,5) /
     &5.4216E+00,7.6284E+00,8.2781E+00,7.4282E+00,2.4448E+00,
     &9.1674E+00,1.0353E+01,1.0955E+01,9.6794E+00,2.8941E+00,
     &1.5043E+01,1.3839E+01,1.4203E+01,1.2197E+01,3.3245E+00,
     &2.3974E+01,1.9288E+01,1.8167E+01,1.5125E+01,3.7165E+00,
     &3.7305E+01,2.8554E+01,2.3217E+01,1.8594E+01,4.0932E+00/
      DATA ((KB(JS,JT,49,10),JS=1,5),JT=1,5) /
     &4.8939E+00,7.2548E+00,7.9080E+00,7.0906E+00,2.2660E+00,
     &8.5415E+00,1.0039E+01,1.0662E+01,9.4308E+00,2.7166E+00,
     &1.4366E+01,1.3618E+01,1.4041E+01,1.2074E+01,3.1539E+00,
     &2.3519E+01,1.9097E+01,1.8194E+01,1.5161E+01,3.5625E+00,
     &3.7354E+01,2.8637E+01,2.3540E+01,1.8862E+01,3.9655E+00/
      DATA ((KB(JS,JT,50,10),JS=1,5),JT=1,5) /
     &4.2089E+00,6.7050E+00,7.3787E+00,6.6334E+00,2.0951E+00,
     &7.5781E+00,9.4477E+00,1.0132E+01,8.9977E+00,2.5467E+00,
     &1.3098E+01,1.3002E+01,1.3521E+01,1.1708E+01,2.9888E+00,
     &2.2021E+01,1.8246E+01,1.7755E+01,1.4869E+01,3.4160E+00,
     &3.5802E+01,2.7586E+01,2.3214E+01,1.8702E+01,3.8321E+00/
      DATA ((KB(JS,JT,51,10),JS=1,5),JT=1,5) /
     &3.5246E+00,6.0952E+00,6.7836E+00,6.1221E+00,1.9285E+00,
     &6.5392E+00,8.7579E+00,9.5007E+00,8.4899E+00,2.3790E+00,
     &1.1662E+01,1.2207E+01,1.2854E+01,1.1229E+01,2.8289E+00,
     &2.0094E+01,1.7146E+01,1.7077E+01,1.4419E+01,3.2637E+00,
     &3.3544E+01,2.6031E+01,2.2586E+01,1.8311E+01,3.6955E+00/
      DATA ((KB(JS,JT,52,10),JS=1,5),JT=1,5) /
     &2.9972E+00,5.5809E+00,6.2670E+00,5.6729E+00,1.7637E+00,
     &5.7401E+00,8.2025E+00,8.9834E+00,8.0597E+00,2.2115E+00,
     &1.0553E+01,1.1618E+01,1.2357E+01,1.0861E+01,2.6710E+00,
     &1.8666E+01,1.6392E+01,1.6645E+01,1.4126E+01,3.1091E+00,
     &3.2058E+01,2.5069E+01,2.2259E+01,1.8128E+01,3.5578E+00/
      DATA ((KB(JS,JT,53,10),JS=1,5),JT=1,5) /
     &2.6079E+00,5.1734E+00,5.8449E+00,5.2987E+00,1.6026E+00,
     &5.1862E+00,7.8030E+00,8.6055E+00,7.7246E+00,2.0456E+00,
     &9.8254E+00,1.1267E+01,1.2065E+01,1.0633E+01,2.5075E+00,
     &1.7902E+01,1.6069E+01,1.6506E+01,1.4053E+01,2.9528E+00,
     &3.1626E+01,2.4842E+01,2.2382E+01,1.8272E+01,3.4166E+00/
      DATA ((KB(JS,JT,54,10),JS=1,5),JT=1,5) /
     &1.9692E+00,4.4492E+00,5.0971E+00,4.6730E+00,1.4560E+00,
     &4.0777E+00,6.8483E+00,7.6942E+00,6.9748E+00,1.8918E+00,
     &7.9636E+00,1.0044E+01,1.0960E+01,9.7978E+00,2.3486E+00,
     &1.4982E+01,1.4434E+01,1.5164E+01,1.3125E+01,2.8028E+00,
     &2.7158E+01,2.1902E+01,2.0733E+01,1.7211E+01,3.2543E+00/
      DATA ((KB(JS,JT,55,10),JS=1,5),JT=1,5) /
     &1.3507E+00,3.6433E+00,4.2566E+00,3.9661E+00,1.3130E+00,
     &2.9154E+00,5.7215E+00,6.5830E+00,6.0536E+00,1.7424E+00,
     &5.8789E+00,8.5105E+00,9.5339E+00,8.6749E+00,2.1951E+00,
     &1.1400E+01,1.2318E+01,1.3311E+01,1.1788E+01,2.6530E+00,
     &2.1258E+01,1.8155E+01,1.8294E+01,1.5532E+01,3.0990E+00/
      DATA ((KB(JS,JT,56,10),JS=1,5),JT=1,5) /
     &9.1417E-01,2.9676E+00,3.5310E+00,3.3437E+00,1.1797E+00,
     &2.0541E+00,4.7744E+00,5.6130E+00,5.2303E+00,1.5997E+00,
     &4.2988E+00,7.2236E+00,8.2994E+00,7.6574E+00,2.0435E+00,
     &8.5903E+00,1.0539E+01,1.1687E+01,1.0572E+01,2.5005E+00,
     &1.6506E+01,1.5331E+01,1.6174E+01,1.4030E+01,2.9531E+00/
      DATA ((KB(JS,JT,57,10),JS=1,5),JT=1,5) /
     &6.0887E-01,2.4030E+00,2.9065E+00,2.7971E+00,1.0495E+00,
     &1.4281E+00,3.9782E+00,4.7656E+00,4.4965E+00,1.4561E+00,
     &3.1054E+00,6.1238E+00,7.2122E+00,6.7209E+00,1.8934E+00,
     &6.4056E+00,9.0325E+00,1.0294E+01,9.4596E+00,2.3523E+00,
     &1.2719E+01,1.3167E+01,1.4312E+01,1.2682E+01,2.8029E+00/
      DATA ((KB(JS,JT,58,10),JS=1,5),JT=1,5) /
     &1.0707E-01,6.3953E-01,1.0127E+00,1.3896E+00,9.3114E-01,
     &2.6195E-01,1.0902E+00,1.7100E+00,2.2949E+00,1.3241E+00,
     &5.9147E-01,1.7109E+00,2.6503E+00,3.5010E+00,1.7544E+00,
     &1.2606E+00,2.5523E+00,3.8433E+00,5.0138E+00,2.2018E+00,
     &2.5874E+00,3.7372E+00,5.3689E+00,6.8137E+00,2.6612E+00/
      DATA ((KB(JS,JT,59,10),JS=1,5),JT=1,5) /
     &9.9298E-02,7.6667E-01,1.1645E+00,1.4612E+00,8.8547E-01,
     &2.4968E-01,1.3224E+00,1.9807E+00,2.4248E+00,1.2655E+00,
     &5.7897E-01,2.0921E+00,3.0941E+00,3.7073E+00,1.6878E+00,
     &1.2660E+00,3.1094E+00,4.5051E+00,5.3308E+00,2.1316E+00,
     &2.6665E+00,4.5101E+00,6.2520E+00,7.2627E+00,2.5824E+00/
      DATA ((KB(JS,JT,13,11),JS=1,5),JT=1,5) /
     &4.9137E+02,3.6866E+02,2.4595E+02,1.2325E+02,3.7154E+00,
     &7.1842E+02,5.3894E+02,3.5946E+02,1.7998E+02,3.6255E+00,
     &9.9186E+02,7.4402E+02,4.9618E+02,2.4833E+02,3.5452E+00,
     &1.3059E+03,9.7954E+02,6.5319E+02,3.2683E+02,3.4736E+00,
     &1.6553E+03,1.2416E+03,8.2787E+02,4.1417E+02,3.4158E+00/
      DATA ((KB(JS,JT,14,11),JS=1,5),JT=1,5) /
     &3.1242E+02,2.3443E+02,1.5644E+02,7.8454E+01,4.0956E+00,
     &4.5149E+02,3.3873E+02,2.2597E+02,1.1322E+02,4.0089E+00,
     &6.1672E+02,4.6265E+02,3.0858E+02,1.5452E+02,3.9350E+00,
     &8.0574E+02,6.0442E+02,4.0309E+02,2.0177E+02,3.8665E+00,
     &1.0145E+03,7.6099E+02,5.0748E+02,2.5397E+02,3.7755E+00/
      DATA ((KB(JS,JT,15,11),JS=1,5),JT=1,5) /
     &1.9759E+02,1.4830E+02,9.9018E+01,4.9739E+01,4.5712E+00,
     &2.8230E+02,2.1184E+02,1.4137E+02,7.0907E+01,4.4810E+00,
     &3.8219E+02,2.8675E+02,1.9132E+02,9.5881E+01,4.3973E+00,
     &4.9586E+02,3.7201E+02,2.4816E+02,1.2430E+02,4.3207E+00,
     &6.2301E+02,4.6738E+02,3.1174E+02,1.5610E+02,4.2419E+00/
      DATA ((KB(JS,JT,16,11),JS=1,5),JT=1,5) /
     &1.4534E+02,1.0912E+02,7.2899E+01,3.6687E+01,5.0599E+00,
     &2.0548E+02,1.5423E+02,1.0297E+02,5.1715E+01,4.9736E+00,
     &2.7637E+02,2.0739E+02,1.3841E+02,6.9439E+01,4.8882E+00,
     &3.5789E+02,2.6854E+02,1.7918E+02,8.9827E+01,4.8052E+00,
     &4.4907E+02,3.3692E+02,2.2477E+02,1.1262E+02,4.7153E+00/
      DATA ((KB(JS,JT,17,11),JS=1,5),JT=1,5) /
     &1.0823E+02,8.1288E+01,5.4344E+01,2.7412E+01,5.5645E+00,
     &1.5200E+02,1.1412E+02,7.6233E+01,3.8355E+01,5.4748E+00,
     &2.0403E+02,1.5314E+02,1.0225E+02,5.1364E+01,5.3859E+00,
     &2.6361E+02,1.9782E+02,1.3204E+02,6.6255E+01,5.2931E+00,
     &3.3009E+02,2.4768E+02,1.6528E+02,8.2867E+01,5.1961E+00/
      DATA ((KB(JS,JT,18,11),JS=1,5),JT=1,5) /
     &8.1232E+01,6.1036E+01,4.0843E+01,2.0768E+01,6.0688E+00,
     &1.1380E+02,8.5466E+01,5.7129E+01,2.8802E+01,5.9719E+00,
     &1.5225E+02,1.1430E+02,7.6349E+01,3.8404E+01,5.8780E+00,
     &1.9624E+02,1.4729E+02,9.8340E+01,4.9394E+01,5.7787E+00,
     &2.4493E+02,1.8381E+02,1.2268E+02,6.1561E+01,5.6709E+00/
      DATA ((KB(JS,JT,19,11),JS=1,5),JT=1,5) /
     &5.9301E+01,4.4585E+01,2.9875E+01,1.6238E+01,6.5385E+00,
     &8.2717E+01,6.2145E+01,4.1575E+01,2.1335E+01,6.4509E+00,
     &1.1031E+02,8.2837E+01,5.5366E+01,2.7948E+01,6.3522E+00,
     &1.4167E+02,1.0635E+02,7.1041E+01,3.5737E+01,6.2392E+00,
     &1.7630E+02,1.3232E+02,8.8349E+01,4.4378E+01,6.1191E+00/
      DATA ((KB(JS,JT,20,11),JS=1,5),JT=1,5) /
     &4.6675E+01,3.5111E+01,2.3575E+01,1.4266E+01,6.9620E+00,
     &6.4787E+01,4.8692E+01,3.2603E+01,1.7833E+01,6.8738E+00,
     &8.5965E+01,6.4574E+01,4.3185E+01,2.2381E+01,6.7710E+00,
     &1.0993E+02,8.2545E+01,5.5164E+01,2.7968E+01,6.6598E+00,
     &1.3666E+02,1.0259E+02,6.8531E+01,3.4499E+01,6.5455E+00/
      DATA ((KB(JS,JT,21,11),JS=1,5),JT=1,5) /
     &3.7501E+01,2.8227E+01,1.9281E+01,1.3115E+01,7.3104E+00,
     &5.1743E+01,3.8905E+01,2.6108E+01,1.5684E+01,7.2251E+00,
     &6.8349E+01,5.1361E+01,3.4375E+01,1.9019E+01,7.1334E+00,
     &8.7361E+01,6.5620E+01,4.3882E+01,2.3034E+01,7.0346E+00,
     &1.0904E+02,8.1880E+01,5.4724E+01,2.7964E+01,6.9286E+00/
      DATA ((KB(JS,JT,22,11),JS=1,5),JT=1,5) /
     &3.1289E+01,2.3566E+01,1.6825E+01,1.2828E+01,7.5760E+00,
     &4.2825E+01,3.2216E+01,2.1971E+01,1.4588E+01,7.5079E+00,
     &5.6403E+01,4.2401E+01,2.8462E+01,1.6984E+01,7.4270E+00,
     &7.2294E+01,5.4320E+01,3.6353E+01,2.0165E+01,7.3380E+00,
     &9.0391E+01,6.7890E+01,4.5398E+01,2.4037E+01,7.2398E+00/
      DATA ((KB(JS,JT,23,11),JS=1,5),JT=1,5) /
     &2.6113E+01,1.9694E+01,1.4984E+01,1.2807E+01,7.7662E+00,
     &3.5611E+01,2.6805E+01,1.8996E+01,1.4145E+01,7.7141E+00,
     &4.7007E+01,3.5353E+01,2.4112E+01,1.5803E+01,7.6529E+00,
     &6.0260E+01,4.5296E+01,3.0446E+01,1.8119E+01,7.5779E+00,
     &7.5402E+01,5.6642E+01,3.7917E+01,2.1118E+01,7.4889E+00/
      DATA ((KB(JS,JT,24,11),JS=1,5),JT=1,5) /
     &2.1744E+01,1.6531E+01,1.3667E+01,1.2705E+01,7.8734E+00,
     &2.9665E+01,2.2353E+01,1.6710E+01,1.3918E+01,7.8466E+00,
     &3.9143E+01,2.9459E+01,2.0787E+01,1.5226E+01,7.8065E+00,
     &5.0222E+01,3.7761E+01,2.5773E+01,1.6824E+01,7.7511E+00,
     &6.2928E+01,4.7282E+01,3.1824E+01,1.8958E+01,7.6816E+00/
      DATA ((KB(JS,JT,25,11),JS=1,5),JT=1,5) /
     &1.8556E+01,1.4391E+01,1.2986E+01,1.2542E+01,7.9223E+00,
     &2.5288E+01,1.9166E+01,1.5272E+01,1.3696E+01,7.9207E+00,
     &3.3328E+01,2.5101E+01,1.8448E+01,1.4913E+01,7.9039E+00,
     &4.2799E+01,3.2187E+01,2.2557E+01,1.6216E+01,7.8725E+00,
     &5.3844E+01,4.0473E+01,2.7585E+01,1.7777E+01,7.8216E+00/
      DATA ((KB(JS,JT,26,11),JS=1,5),JT=1,5) /
     &1.6321E+01,1.3012E+01,1.2671E+01,1.2389E+01,7.9293E+00,
     &2.2176E+01,1.7013E+01,1.4541E+01,1.3492E+01,7.9549E+00,
     &2.9236E+01,2.2092E+01,1.7014E+01,1.4647E+01,7.9628E+00,
     &3.7703E+01,2.8378E+01,2.0439E+01,1.5868E+01,7.9537E+00,
     &4.7623E+01,3.5826E+01,2.4857E+01,1.7188E+01,7.9177E+00/
      DATA ((KB(JS,JT,27,11),JS=1,5),JT=1,5) /
     &1.5028E+01,1.2264E+01,1.2582E+01,1.2313E+01,7.9116E+00,
     &2.0393E+01,1.5855E+01,1.4339E+01,1.3407E+01,7.9620E+00,
     &2.6998E+01,2.0503E+01,1.6441E+01,1.4550E+01,7.9958E+00,
     &3.4948E+01,2.6342E+01,1.9460E+01,1.5757E+01,8.0119E+00,
     &4.4164E+01,3.3250E+01,2.3464E+01,1.7068E+01,7.9872E+00/
      DATA ((KB(JS,JT,28,11),JS=1,5),JT=1,5) /
     &1.4343E+01,1.1935E+01,1.2606E+01,1.2286E+01,7.8708E+00,
     &1.9534E+01,1.5338E+01,1.4333E+01,1.3405E+01,7.9546E+00,
     &2.5909E+01,1.9792E+01,1.6354E+01,1.4575E+01,8.0164E+00,
     &3.3450E+01,2.5271E+01,1.9104E+01,1.5810E+01,8.0394E+00,
     &4.2201E+01,3.1789E+01,2.2776E+01,1.7191E+01,8.0384E+00/
      DATA ((KB(JS,JT,29,11),JS=1,5),JT=1,5) /
     &1.4799E+01,1.2334E+01,1.2951E+01,1.2470E+01,7.8248E+00,
     &2.0134E+01,1.5845E+01,1.4778E+01,1.3682E+01,7.9390E+00,
     &2.6563E+01,2.0336E+01,1.6926E+01,1.4933E+01,8.0194E+00,
     &3.4143E+01,2.5818E+01,1.9648E+01,1.6307E+01,8.0590E+00,
     &4.2969E+01,3.2368E+01,2.3282E+01,1.7794E+01,8.0931E+00/
      DATA ((KB(JS,JT,30,11),JS=1,5),JT=1,5) /
     &1.5772E+01,1.3097E+01,1.3464E+01,1.2783E+01,7.7812E+00,
     &2.1344E+01,1.6785E+01,1.5505E+01,1.4108E+01,7.9232E+00,
     &2.7999E+01,2.1429E+01,1.7759E+01,1.5492E+01,8.0114E+00,
     &3.5848E+01,2.7096E+01,2.0562E+01,1.7031E+01,8.0836E+00,
     &4.5004E+01,3.3889E+01,2.4347E+01,1.8589E+01,8.1429E+00/
      DATA ((KB(JS,JT,31,11),JS=1,5),JT=1,5) /
     &1.7716E+01,1.4511E+01,1.4478E+01,1.3396E+01,7.7478E+00,
     &2.3853E+01,1.8632E+01,1.6766E+01,1.4874E+01,7.8974E+00,
     &3.1182E+01,2.3768E+01,1.9223E+01,1.6499E+01,8.0055E+00,
     &3.9834E+01,3.0054E+01,2.2404E+01,1.8165E+01,8.1138E+00,
     &4.9938E+01,3.7588E+01,2.6690E+01,1.9788E+01,8.1481E+00/
      DATA ((KB(JS,JT,32,11),JS=1,5),JT=1,5) /
     &2.0151E+01,1.6250E+01,1.5786E+01,1.4153E+01,7.7024E+00,
     &2.7022E+01,2.0930E+01,1.8243E+01,1.5874E+01,7.8766E+00,
     &3.5292E+01,2.6776E+01,2.1045E+01,1.7666E+01,8.0370E+00,
     &4.5050E+01,3.3940E+01,2.4811E+01,1.9434E+01,8.1312E+00,
     &5.6497E+01,4.2506E+01,2.9790E+01,2.1188E+01,8.1409E+00/
      DATA ((KB(JS,JT,33,11),JS=1,5),JT=1,5) /
     &2.3401E+01,1.8533E+01,1.7371E+01,1.5193E+01,7.6839E+00,
     &3.1308E+01,2.4009E+01,2.0094E+01,1.7155E+01,7.9059E+00,
     &4.0829E+01,3.0856E+01,2.3455E+01,1.9076E+01,8.0587E+00,
     &5.2189E+01,3.9272E+01,2.8099E+01,2.1008E+01,8.1274E+00,
     &6.5586E+01,4.9320E+01,3.4075E+01,2.2993E+01,8.2027E+00/
      DATA ((KB(JS,JT,34,11),JS=1,5),JT=1,5) /
     &2.6313E+01,2.0607E+01,1.8746E+01,1.6201E+01,7.7021E+00,
     &3.5155E+01,2.6805E+01,2.1758E+01,1.8283E+01,7.9397E+00,
     &4.5927E+01,3.4632E+01,2.5705E+01,2.0353E+01,8.0605E+00,
     &5.8835E+01,4.4252E+01,3.1197E+01,2.2458E+01,8.1311E+00,
     &7.4250E+01,5.5815E+01,3.8184E+01,2.4701E+01,8.2150E+00/
      DATA ((KB(JS,JT,35,11),JS=1,5),JT=1,5) /
     &2.8876E+01,2.2455E+01,1.9946E+01,1.7124E+01,7.7224E+00,
     &3.8715E+01,2.9405E+01,2.3284E+01,1.9326E+01,7.9252E+00,
     &5.0778E+01,3.8237E+01,2.7902E+01,2.1577E+01,8.0258E+00,
     &6.5355E+01,4.9140E+01,3.4259E+01,2.3860E+01,8.1543E+00,
     &8.3003E+01,6.2372E+01,4.2365E+01,2.6463E+01,8.1938E+00/
      DATA ((KB(JS,JT,36,11),JS=1,5),JT=1,5) /
     &3.0603E+01,2.3731E+01,2.0817E+01,1.7816E+01,7.6876E+00,
     &4.1304E+01,3.1313E+01,2.4462E+01,2.0172E+01,7.8715E+00,
     &5.4533E+01,4.1035E+01,2.9662E+01,2.2576E+01,7.9878E+00,
     &7.0736E+01,5.3175E+01,3.6832E+01,2.5052E+01,8.1404E+00,
     &9.0535E+01,6.8017E+01,4.6007E+01,2.8044E+01,8.2152E+00/
      DATA ((KB(JS,JT,37,11),JS=1,5),JT=1,5) /
     &3.0255E+01,2.3559E+01,2.0925E+01,1.7969E+01,7.6093E+00,
     &4.1246E+01,3.1319E+01,2.4672E+01,2.0442E+01,7.8000E+00,
     &5.5008E+01,4.1404E+01,3.0029E+01,2.2965E+01,7.9652E+00,
     &7.2100E+01,5.4198E+01,3.7564E+01,2.5602E+01,8.1174E+00,
     &9.3252E+01,7.0052E+01,4.7363E+01,2.8813E+01,8.2379E+00/
      DATA ((KB(JS,JT,38,11),JS=1,5),JT=1,5) /
     &3.0319E+01,2.3676E+01,2.1203E+01,1.8223E+01,7.5198E+00,
     &4.1784E+01,3.1741E+01,2.5125E+01,2.0837E+01,7.7243E+00,
     &5.6316E+01,4.2385E+01,3.0775E+01,2.3517E+01,7.9363E+00,
     &7.4582E+01,5.6053E+01,3.8823E+01,2.6361E+01,8.1242E+00,
     &9.7510E+01,7.3243E+01,4.9498E+01,2.9889E+01,8.2559E+00/
      DATA ((KB(JS,JT,39,11),JS=1,5),JT=1,5) /
     &3.1111E+01,2.4293E+01,2.1786E+01,1.8666E+01,7.4239E+00,
     &4.3408E+01,3.2962E+01,2.6016E+01,2.1461E+01,7.6345E+00,
     &5.9150E+01,4.4506E+01,3.2172E+01,2.4357E+01,7.9192E+00,
     &7.9245E+01,5.9549E+01,4.1085E+01,2.7494E+01,8.1496E+00,
     &1.0467E+02,7.8610E+01,5.2990E+01,3.1523E+01,8.2789E+00/
      DATA ((KB(JS,JT,40,11),JS=1,5),JT=1,5) /
     &2.8917E+01,2.2849E+01,2.1212E+01,1.8303E+01,7.3082E+00,
     &4.0995E+01,3.1270E+01,2.5375E+01,2.1193E+01,7.5582E+00,
     &5.6673E+01,4.2684E+01,3.1298E+01,2.4183E+01,7.8695E+00,
     &7.6946E+01,5.7826E+01,4.0125E+01,2.7426E+01,8.1312E+00,
     &1.0293E+02,7.7305E+01,5.2205E+01,3.1496E+01,8.2689E+00/
      DATA ((KB(JS,JT,41,11),JS=1,5),JT=1,5) /
     &2.6634E+01,2.1385E+01,2.0561E+01,1.7885E+01,7.1901E+00,
     &3.8375E+01,2.9451E+01,2.4682E+01,2.0867E+01,7.4740E+00,
     &5.3928E+01,4.0671E+01,3.0356E+01,2.3955E+01,7.8182E+00,
     &7.4310E+01,5.5850E+01,3.9033E+01,2.7309E+01,8.0950E+00,
     &1.0067E+02,7.5610E+01,5.1206E+01,3.1414E+01,8.2644E+00/
      DATA ((KB(JS,JT,42,11),JS=1,5),JT=1,5) /
     &2.4738E+01,2.0233E+01,2.0020E+01,1.7547E+01,7.0619E+00,
     &3.6234E+01,2.7982E+01,2.4175E+01,2.0637E+01,7.4025E+00,
     &5.1779E+01,3.9115E+01,2.9714E+01,2.3853E+01,7.7568E+00,
     &7.2527E+01,5.4511E+01,3.8357E+01,2.7357E+01,8.0593E+00,
     &9.9602E+01,7.4807E+01,5.0774E+01,3.1579E+01,8.2618E+00/
      DATA ((KB(JS,JT,43,11),JS=1,5),JT=1,5) /
     &2.2598E+01,1.8979E+01,1.9339E+01,1.7092E+01,6.9063E+00,
     &3.3721E+01,2.6289E+01,2.3541E+01,2.0300E+01,7.2922E+00,
     &4.9059E+01,3.7168E+01,2.8920E+01,2.3665E+01,7.6599E+00,
     &6.9947E+01,5.2582E+01,3.7401E+01,2.7324E+01,7.9953E+00,
     &9.7637E+01,7.3334E+01,4.9954E+01,3.1634E+01,8.2449E+00/
      DATA ((KB(JS,JT,44,11),JS=1,5),JT=1,5) /
     &2.0598E+01,1.7877E+01,1.8670E+01,1.6634E+01,6.7349E+00,
     &3.1385E+01,2.4755E+01,2.2973E+01,1.9973E+01,7.1646E+00,
     &4.6533E+01,3.5381E+01,2.8231E+01,2.3518E+01,7.5534E+00,
     &6.7572E+01,5.0818E+01,3.6582E+01,2.7361E+01,7.9184E+00,
     &9.6116E+01,7.2195E+01,4.9367E+01,3.1819E+01,8.2107E+00/
      DATA ((KB(JS,JT,45,11),JS=1,5),JT=1,5) /
     &1.9103E+01,1.7116E+01,1.8163E+01,1.6283E+01,6.5605E+00,
     &2.9658E+01,2.3682E+01,2.2618E+01,1.9789E+01,7.0239E+00,
     &4.4853E+01,3.4227E+01,2.7909E+01,2.3555E+01,7.4383E+00,
     &6.6390E+01,4.9954E+01,3.6314E+01,2.7640E+01,7.8580E+00,
     &9.6230E+01,7.2282E+01,4.9573E+01,3.2349E+01,8.1505E+00/
      DATA ((KB(JS,JT,46,11),JS=1,5),JT=1,5) /
     &1.7603E+01,1.6408E+01,1.7601E+01,1.5877E+01,6.3549E+00,
     &2.7890E+01,2.2645E+01,2.2217E+01,1.9546E+01,6.8535E+00,
     &4.3095E+01,3.3035E+01,2.7597E+01,2.3556E+01,7.2985E+00,
     &6.5080E+01,4.9001E+01,3.6011E+01,2.7911E+01,7.7668E+00,
     &9.6111E+01,7.2194E+01,4.9702E+01,3.2895E+01,8.0887E+00/
      DATA ((KB(JS,JT,47,11),JS=1,5),JT=1,5) /
     &1.5582E+01,1.5416E+01,1.6712E+01,1.5202E+01,6.1058E+00,
     &2.5371E+01,2.1144E+01,2.1438E+01,1.8984E+01,6.6529E+00,
     &4.0058E+01,3.0957E+01,2.6834E+01,2.3189E+01,7.1345E+00,
     &6.1807E+01,4.6615E+01,3.4933E+01,2.7758E+01,7.6397E+00,
     &9.3127E+01,6.9962E+01,4.8499E+01,3.2952E+01,7.9851E+00/
      DATA ((KB(JS,JT,48,11),JS=1,5),JT=1,5) /
     &1.4034E+01,1.4681E+01,1.5989E+01,1.4629E+01,5.8421E+00,
     &2.3558E+01,2.0186E+01,2.0890E+01,1.8564E+01,6.4412E+00,
     &3.8004E+01,2.9609E+01,2.6472E+01,2.3010E+01,6.9605E+00,
     &5.9949E+01,4.5296E+01,3.4518E+01,2.7885E+01,7.5000E+00,
     &9.2277E+01,6.9322E+01,4.8288E+01,3.3402E+01,7.8874E+00/
      DATA ((KB(JS,JT,49,11),JS=1,5),JT=1,5) /
     &1.3020E+01,1.4223E+01,1.5508E+01,1.4222E+01,5.5629E+00,
     &2.2531E+01,1.9765E+01,2.0674E+01,1.8360E+01,6.2033E+00,
     &3.7326E+01,2.9255E+01,2.6622E+01,2.3133E+01,6.7696E+00,
     &6.0141E+01,4.5507E+01,3.5009E+01,2.8438E+01,7.3484E+00,
     &9.4669E+01,7.1125E+01,4.9613E+01,3.4451E+01,7.7676E+00/
      DATA ((KB(JS,JT,50,11),JS=1,5),JT=1,5) /
     &1.1528E+01,1.3385E+01,1.4676E+01,1.3553E+01,5.2886E+00,
     &2.0590E+01,1.8779E+01,1.9954E+01,1.7785E+01,5.9683E+00,
     &3.5112E+01,2.7878E+01,2.6128E+01,2.2750E+01,6.5812E+00,
     &5.7821E+01,4.3871E+01,3.4428E+01,2.8358E+01,7.1800E+00,
     &9.2920E+01,6.9817E+01,4.9041E+01,3.4691E+01,7.6346E+00/
      DATA ((KB(JS,JT,51,11),JS=1,5),JT=1,5) /
     &9.9087E+00,1.2389E+01,1.3702E+01,1.2771E+01,5.0110E+00,
     &1.8347E+01,1.7625E+01,1.8991E+01,1.7018E+01,5.7321E+00,
     &3.2210E+01,2.6119E+01,2.5308E+01,2.2105E+01,6.3824E+00,
     &5.4374E+01,4.1438E+01,3.3397E+01,2.7944E+01,7.0038E+00,
     &8.9118E+01,6.6984E+01,4.7570E+01,3.4540E+01,7.4941E+00/
      DATA ((KB(JS,JT,52,11),JS=1,5),JT=1,5) /
     &8.6167E+00,1.1576E+01,1.2899E+01,1.2089E+01,4.7245E+00,
     &1.6651E+01,1.6818E+01,1.8231E+01,1.6395E+01,5.4842E+00,
     &3.0138E+01,2.4957E+01,2.4762E+01,2.1646E+01,6.1679E+00,
     &5.2273E+01,4.0011E+01,3.2952E+01,2.7789E+01,6.8199E+00,
     &8.7481E+01,6.5781E+01,4.7111E+01,3.4770E+01,7.3415E+00/
      DATA ((KB(JS,JT,53,11),JS=1,5),JT=1,5) /
     &7.6702E+00,1.0979E+01,1.2289E+01,1.1530E+01,4.4295E+00,
     &1.5508E+01,1.6366E+01,1.7771E+01,1.5970E+01,5.2253E+00,
     &2.9086E+01,2.4490E+01,2.4633E+01,2.1484E+01,5.9485E+00,
     &5.1881E+01,3.9852E+01,3.3235E+01,2.8055E+01,6.6238E+00,
     &8.8988E+01,6.6930E+01,4.8082E+01,3.5589E+01,7.1849E+00/
      DATA ((KB(JS,JT,54,11),JS=1,5),JT=1,5) /
     &5.9450E+00,9.6177E+00,1.0972E+01,1.0431E+01,4.1455E+00,
     &1.2556E+01,1.4668E+01,1.6126E+01,1.4708E+01,4.9524E+00,
     &2.4491E+01,2.1770E+01,2.2780E+01,2.0031E+01,5.7134E+00,
     &4.4954E+01,3.5031E+01,3.0908E+01,2.6515E+01,6.4122E+00,
     &7.9027E+01,5.9569E+01,4.4065E+01,3.4001E+01,7.0090E+00/
      DATA ((KB(JS,JT,55,11),JS=1,5),JT=1,5) /
     &4.1710E+00,8.0225E+00,9.3978E+00,9.1226E+00,3.8682E+00,
     &9.2293E+00,1.2486E+01,1.4001E+01,1.3070E+01,4.6969E+00,
     &1.8778E+01,1.8456E+01,2.0084E+01,1.7971E+01,5.4658E+00,
     &3.5574E+01,2.8777E+01,2.7568E+01,2.4021E+01,6.1617E+00,
     &6.4114E+01,4.8674E+01,3.8113E+01,3.1115E+01,6.8236E+00/
      DATA ((KB(JS,JT,56,11),JS=1,5),JT=1,5) /
     &2.8728E+00,6.6889E+00,8.0328E+00,7.9557E+00,3.5989E+00,
     &6.6874E+00,1.0605E+01,1.2156E+01,1.1597E+01,4.4247E+00,
     &1.4226E+01,1.5908E+01,1.7667E+01,1.6104E+01,5.2042E+00,
     &2.7945E+01,2.3989E+01,2.4626E+01,2.1735E+01,5.9393E+00,
     &5.1707E+01,3.9775E+01,3.3431E+01,2.8442E+01,6.5979E+00/
      DATA ((KB(JS,JT,57,11),JS=1,5),JT=1,5) /
     &1.9429E+00,5.5686E+00,6.8405E+00,6.9151E+00,3.3226E+00,
     &4.7724E+00,8.9791E+00,1.0545E+01,1.0240E+01,4.1527E+00,
     &1.0641E+01,1.3735E+01,1.5504E+01,1.4420E+01,4.9657E+00,
     &2.1776E+01,2.0320E+01,2.1929E+01,1.9615E+01,5.6966E+00,
     &4.1383E+01,3.2617E+01,2.9771E+01,2.5932E+01,6.3597E+00/
      DATA ((KB(JS,JT,58,11),JS=1,5),JT=1,5) /
     &3.4498E-01,1.5267E+00,2.4690E+00,3.5849E+00,3.0713E+00,
     &8.9647E-01,2.5018E+00,3.8790E+00,5.3697E+00,3.9024E+00,
     &2.0963E+00,3.8966E+00,5.7628E+00,7.6647E+00,4.7137E+00,
     &4.4774E+00,5.7497E+00,8.2495E+00,1.0504E+01,5.4718E+00,
     &8.7673E+00,8.8663E+00,1.1318E+01,1.3996E+01,6.1538E+00/
      DATA ((KB(JS,JT,59,11),JS=1,5),JT=1,5) /
     &3.2685E-01,1.8752E+00,2.9232E+00,3.9328E+00,2.9672E+00,
     &8.8018E-01,3.0635E+00,4.5809E+00,5.8034E+00,3.8049E+00,
     &2.1278E+00,4.7401E+00,6.7591E+00,8.2573E+00,4.6076E+00,
     &4.6712E+00,6.9756E+00,9.6079E+00,1.1224E+01,5.3733E+00,
     &9.3271E+00,1.0056E+01,1.3155E+01,1.4840E+01,6.0503E+00/
      DATA ((KB(JS,JT,13,12),JS=1,5),JT=1,5) /
     &7.5516E+02,5.6651E+02,3.7786E+02,1.8921E+02,4.6057E+00,
     &1.1031E+03,8.2746E+02,5.5183E+02,2.7620E+02,4.4752E+00,
     &1.5208E+03,1.1407E+03,7.6067E+02,3.8062E+02,4.3357E+00,
     &2.0072E+03,1.5056E+03,1.0039E+03,5.0221E+02,4.1960E+00,
     &2.5500E+03,1.9126E+03,1.2753E+03,6.3790E+02,4.0223E+00/
      DATA ((KB(JS,JT,14,12),JS=1,5),JT=1,5) /
     &5.0313E+02,3.7749E+02,2.5185E+02,1.2621E+02,5.0046E+00,
     &7.2897E+02,5.4687E+02,3.6476E+02,1.8266E+02,4.8590E+00,
     &9.9893E+02,7.4933E+02,4.9972E+02,2.5013E+02,4.7095E+00,
     &1.3102E+03,9.8276E+02,6.5533E+02,3.2791E+02,4.5769E+00,
     &1.6551E+03,1.2414E+03,8.2775E+02,4.1411E+02,4.4631E+00/
      DATA ((KB(JS,JT,15,12),JS=1,5),JT=1,5) /
     &3.3639E+02,2.5243E+02,1.6847E+02,8.4507E+01,5.4523E+00,
     &4.8280E+02,3.6223E+02,2.4166E+02,1.2109E+02,5.3133E+00,
     &6.5719E+02,4.9302E+02,3.2884E+02,1.6466E+02,5.1834E+00,
     &8.5550E+02,6.4175E+02,4.2799E+02,2.1423E+02,5.0660E+00,
     &1.0728E+03,8.0472E+02,5.3663E+02,2.6854E+02,4.9623E+00/
      DATA ((KB(JS,JT,16,12),JS=1,5),JT=1,5) /
     &2.6229E+02,1.9684E+02,1.3139E+02,6.5935E+01,6.0512E+00,
     &3.7303E+02,2.7989E+02,1.8674E+02,9.3604E+01,5.9120E+00,
     &5.0297E+02,3.7733E+02,2.5170E+02,1.2607E+02,5.7872E+00,
     &6.4911E+02,4.8694E+02,3.2477E+02,1.6260E+02,5.6679E+00,
     &8.0986E+02,6.0750E+02,4.0515E+02,2.0279E+02,5.5547E+00/
      DATA ((KB(JS,JT,17,12),JS=1,5),JT=1,5) /
     &2.0705E+02,1.5540E+02,1.0375E+02,5.2106E+01,6.7730E+00,
     &2.9135E+02,2.1862E+02,1.4589E+02,7.3163E+01,6.6333E+00,
     &3.8916E+02,2.9197E+02,1.9479E+02,9.7603E+01,6.4989E+00,
     &4.9976E+02,3.7492E+02,2.5009E+02,1.2525E+02,6.3687E+00,
     &6.2230E+02,4.6683E+02,3.1136E+02,1.5589E+02,6.2358E+00/
      DATA ((KB(JS,JT,18,12),JS=1,5),JT=1,5) /
     &1.6333E+02,1.2261E+02,8.1888E+01,4.1178E+01,7.5424E+00,
     &2.2759E+02,1.7080E+02,1.1401E+02,5.7226E+01,7.4084E+00,
     &3.0244E+02,2.2693E+02,1.5143E+02,7.5931E+01,7.2669E+00,
     &3.8758E+02,2.9079E+02,1.9400E+02,9.7216E+01,7.1208E+00,
     &4.8269E+02,3.6212E+02,2.4155E+02,1.2098E+02,6.9720E+00/
      DATA ((KB(JS,JT,19,12),JS=1,5),JT=1,5) /
     &1.2382E+02,9.2977E+01,6.2136E+01,3.1325E+01,8.3597E+00,
     &1.7154E+02,1.2877E+02,8.5994E+01,4.3233E+01,8.2061E+00,
     &2.2748E+02,1.7072E+02,1.1396E+02,5.7206E+01,8.0513E+00,
     &2.9138E+02,2.1864E+02,1.4590E+02,7.3167E+01,7.8994E+00,
     &3.6253E+02,2.7200E+02,1.8147E+02,9.0939E+01,7.7452E+00/
      DATA ((KB(JS,JT,20,12),JS=1,5),JT=1,5) /
     &1.0042E+02,7.5430E+01,5.0444E+01,2.5891E+01,9.1675E+00,
     &1.3861E+02,1.0407E+02,6.9532E+01,3.5031E+01,9.0030E+00,
     &1.8351E+02,1.3774E+02,9.1975E+01,4.6211E+01,8.8390E+00,
     &2.3463E+02,1.7607E+02,1.1752E+02,5.8971E+01,8.6735E+00,
     &2.9128E+02,2.1856E+02,1.4583E+02,7.3117E+01,8.5016E+00/
      DATA ((KB(JS,JT,21,12),JS=1,5),JT=1,5) /
     &8.3057E+01,6.2407E+01,4.1762E+01,2.2683E+01,9.9550E+00,
     &1.1435E+02,8.5868E+01,5.7394E+01,2.9474E+01,9.7863E+00,
     &1.5096E+02,1.1332E+02,7.5686E+01,3.8128E+01,9.6108E+00,
     &1.9244E+02,1.4443E+02,9.6415E+01,4.8410E+01,9.4311E+00,
     &2.3840E+02,1.7889E+02,1.1939E+02,5.9885E+01,9.2417E+00/
      DATA ((KB(JS,JT,22,12),JS=1,5),JT=1,5) /
     &7.1250E+01,5.3549E+01,3.5853E+01,2.1126E+01,1.0685E+01,
     &9.7414E+01,7.3164E+01,4.8918E+01,2.6307E+01,1.0512E+01,
     &1.2780E+02,9.5945E+01,6.4097E+01,3.2967E+01,1.0335E+01,
     &1.6218E+02,1.2173E+02,8.1281E+01,4.1038E+01,1.0145E+01,
     &2.0041E+02,1.5040E+02,1.0039E+02,5.0398E+01,9.9454E+00/
      DATA ((KB(JS,JT,23,12),JS=1,5),JT=1,5) /
     &6.0942E+01,4.5813E+01,3.0934E+01,2.0012E+01,1.1340E+01,
     &8.2640E+01,6.2081E+01,4.1527E+01,2.4053E+01,1.1180E+01,
     &1.0785E+02,8.0983E+01,5.4124E+01,2.9110E+01,1.1001E+01,
     &1.3652E+02,1.0249E+02,6.8454E+01,3.5343E+01,1.0812E+01,
     &1.6894E+02,1.2680E+02,8.4663E+01,4.2880E+01,1.0609E+01/
      DATA ((KB(JS,JT,24,12),JS=1,5),JT=1,5) /
     &5.1406E+01,3.8659E+01,2.6835E+01,1.9368E+01,1.1917E+01,
     &6.9266E+01,5.2052E+01,3.5118E+01,2.2283E+01,1.1770E+01,
     &9.0127E+01,6.7693E+01,4.5282E+01,2.6104E+01,1.1607E+01,
     &1.1424E+02,8.5780E+01,5.7328E+01,3.0937E+01,1.1421E+01,
     &1.4182E+02,1.0646E+02,7.1109E+01,3.6894E+01,1.1218E+01/
      DATA ((KB(JS,JT,25,12),JS=1,5),JT=1,5) /
     &4.3762E+01,3.2928E+01,2.3974E+01,1.9297E+01,1.2406E+01,
     &5.8726E+01,4.4147E+01,3.0453E+01,2.1379E+01,1.2284E+01,
     &7.6463E+01,5.7453E+01,3.8735E+01,2.4187E+01,1.2134E+01,
     &9.7222E+01,7.3021E+01,4.8859E+01,2.7987E+01,1.1961E+01,
     &1.2098E+02,9.0828E+01,6.0694E+01,3.2765E+01,1.1759E+01/
      DATA ((KB(JS,JT,26,12),JS=1,5),JT=1,5) /
     &3.8022E+01,2.8659E+01,2.2105E+01,1.9516E+01,1.2805E+01,
     &5.0994E+01,3.8356E+01,2.7362E+01,2.1131E+01,1.2709E+01,
     &6.6538E+01,5.0014E+01,3.4258E+01,2.3250E+01,1.2582E+01,
     &8.4702E+01,6.3631E+01,4.2833E+01,2.6169E+01,1.2418E+01,
     &1.0565E+02,7.9327E+01,5.3062E+01,3.0028E+01,1.2216E+01/
      DATA ((KB(JS,JT,27,12),JS=1,5),JT=1,5) /
     &3.4489E+01,2.6132E+01,2.1235E+01,1.9878E+01,1.3122E+01,
     &4.6305E+01,3.4844E+01,2.5714E+01,2.1342E+01,1.3062E+01,
     &6.0441E+01,4.5443E+01,3.1734E+01,2.3085E+01,1.2955E+01,
     &7.7109E+01,5.7931E+01,3.9347E+01,2.5409E+01,1.2800E+01,
     &9.6578E+01,7.2521E+01,4.8662E+01,2.8654E+01,1.2602E+01/
      DATA ((KB(JS,JT,28,12),JS=1,5),JT=1,5) /
     &3.2427E+01,2.4737E+01,2.0948E+01,2.0280E+01,1.3386E+01,
     &4.3501E+01,3.2787E+01,2.4919E+01,2.1714E+01,1.3352E+01,
     &5.6891E+01,4.2776E+01,3.0416E+01,2.3252E+01,1.3262E+01,
     &7.2922E+01,5.4789E+01,3.7531E+01,2.5273E+01,1.3118E+01,
     &9.1872E+01,6.8992E+01,4.6457E+01,2.8166E+01,1.2926E+01/
      DATA ((KB(JS,JT,29,12),JS=1,5),JT=1,5) /
     &3.2667E+01,2.5018E+01,2.1498E+01,2.0955E+01,1.3603E+01,
     &4.3912E+01,3.3123E+01,2.5431E+01,2.2422E+01,1.3591E+01,
     &5.7701E+01,4.3385E+01,3.1008E+01,2.3974E+01,1.3517E+01,
     &7.4275E+01,5.5806E+01,3.8313E+01,2.6005E+01,1.3383E+01,
     &9.3871E+01,7.0500E+01,4.7521E+01,2.8930E+01,1.3178E+01/
      DATA ((KB(JS,JT,30,12),JS=1,5),JT=1,5) /
     &3.4156E+01,2.6153E+01,2.2429E+01,2.1713E+01,1.3788E+01,
     &4.6027E+01,3.4711E+01,2.6560E+01,2.3234E+01,1.3795E+01,
     &6.0622E+01,4.5582E+01,3.2488E+01,2.4921E+01,1.3734E+01,
     &7.8321E+01,5.8857E+01,4.0368E+01,2.7080E+01,1.3599E+01,
     &9.9301E+01,7.4592E+01,5.0256E+01,3.0286E+01,1.3384E+01/
      DATA ((KB(JS,JT,31,12),JS=1,5),JT=1,5) /
     &3.8076E+01,2.9005E+01,2.4159E+01,2.2772E+01,1.3950E+01,
     &5.1386E+01,3.8696E+01,2.8953E+01,2.4505E+01,1.3973E+01,
     &6.7843E+01,5.1009E+01,3.5918E+01,2.6433E+01,1.3920E+01,
     &8.7812E+01,6.5990E+01,4.4995E+01,2.9071E+01,1.3753E+01,
     &1.1160E+02,8.3824E+01,5.6340E+01,3.3050E+01,1.3573E+01/
      DATA ((KB(JS,JT,32,12),JS=1,5),JT=1,5) /
     &4.3422E+01,3.2909E+01,2.6354E+01,2.4011E+01,1.4101E+01,
     &5.8749E+01,4.4202E+01,3.2268E+01,2.6008E+01,1.4129E+01,
     &7.7682E+01,5.8398E+01,4.0569E+01,2.8355E+01,1.4037E+01,
     &1.0053E+02,7.5534E+01,5.1158E+01,3.1768E+01,1.3909E+01,
     &1.2780E+02,9.5988E+01,6.4344E+01,3.6705E+01,1.3757E+01/
      DATA ((KB(JS,JT,33,12),JS=1,5),JT=1,5) /
     &5.0972E+01,3.8474E+01,2.9509E+01,2.5608E+01,1.4236E+01,
     &6.8978E+01,5.1873E+01,3.6983E+01,2.7940E+01,1.4225E+01,
     &9.1196E+01,6.8536E+01,4.6964E+01,3.1045E+01,1.4156E+01,
     &1.1806E+02,8.8684E+01,5.9688E+01,3.5479E+01,1.4053E+01,
     &1.5026E+02,1.1283E+02,7.5476E+01,4.1722E+01,1.3797E+01/
      DATA ((KB(JS,JT,34,12),JS=1,5),JT=1,5) /
     &5.8196E+01,4.3842E+01,3.2696E+01,2.7075E+01,1.4322E+01,
     &7.8717E+01,5.9180E+01,4.1505E+01,2.9899E+01,1.4304E+01,
     &1.0408E+02,7.8203E+01,5.3150E+01,3.3676E+01,1.4279E+01,
     &1.3497E+02,1.0137E+02,6.8004E+01,3.9142E+01,1.4130E+01,
     &1.7215E+02,1.2926E+02,8.6400E+01,4.6696E+01,1.3817E+01/
      DATA ((KB(JS,JT,35,12),JS=1,5),JT=1,5) /
     &6.4953E+01,4.8885E+01,3.5777E+01,2.8513E+01,1.4376E+01,
     &8.7973E+01,6.6128E+01,4.5876E+01,3.1844E+01,1.4423E+01,
     &1.1659E+02,8.7588E+01,5.9213E+01,3.6344E+01,1.4380E+01,
     &1.5177E+02,1.1397E+02,7.6316E+01,4.2891E+01,1.4142E+01,
     &1.9438E+02,1.4593E+02,9.7521E+01,5.1793E+01,1.3951E+01/
      DATA ((KB(JS,JT,36,12),JS=1,5),JT=1,5) /
     &7.0028E+01,5.2692E+01,3.8196E+01,2.9764E+01,1.4429E+01,
     &9.5230E+01,7.1580E+01,4.9388E+01,3.3491E+01,1.4515E+01,
     &1.2679E+02,9.5251E+01,6.4219E+01,3.8654E+01,1.4447E+01,
     &1.6604E+02,1.2468E+02,8.3408E+01,4.6199E+01,1.4226E+01,
     &2.1406E+02,1.6070E+02,1.0737E+02,5.6401E+01,1.4079E+01/
      DATA ((KB(JS,JT,37,12),JS=1,5),JT=1,5) /
     &7.0336E+01,5.2944E+01,3.8605E+01,3.0262E+01,1.4492E+01,
     &9.6465E+01,7.2514E+01,5.0131E+01,3.4164E+01,1.4585E+01,
     &1.2955E+02,9.7324E+01,6.5642E+01,3.9574E+01,1.4537E+01,
     &1.7114E+02,1.2851E+02,8.5971E+01,4.7570E+01,1.4312E+01,
     &2.2257E+02,1.6708E+02,1.1162E+02,5.8523E+01,1.4157E+01/
      DATA ((KB(JS,JT,38,12),JS=1,5),JT=1,5) /
     &7.1653E+01,5.3935E+01,3.9443E+01,3.0956E+01,1.4537E+01,
     &9.9371E+01,7.4697E+01,5.1646E+01,3.5117E+01,1.4670E+01,
     &1.3467E+02,1.0116E+02,6.8199E+01,4.0938E+01,1.4595E+01,
     &1.7944E+02,1.3474E+02,9.0110E+01,4.9614E+01,1.4367E+01,
     &2.3537E+02,1.7668E+02,1.1802E+02,6.1608E+01,1.4213E+01/
      DATA ((KB(JS,JT,39,12),JS=1,5),JT=1,5) /
     &7.4953E+01,5.6404E+01,4.1108E+01,3.2048E+01,1.4593E+01,
     &1.0508E+02,7.8982E+01,5.4463E+01,3.6606E+01,1.4737E+01,
     &1.4387E+02,1.0807E+02,7.2745E+01,4.3123E+01,1.4593E+01,
     &1.9336E+02,1.4518E+02,9.7046E+01,5.2882E+01,1.4422E+01,
     &2.5579E+02,1.9200E+02,1.2823E+02,6.6478E+01,1.4241E+01/
      DATA ((KB(JS,JT,40,12),JS=1,5),JT=1,5) /
     &7.1125E+01,5.3576E+01,3.9744E+01,3.1845E+01,1.4584E+01,
     &1.0123E+02,7.6093E+01,5.2813E+01,3.6464E+01,1.4753E+01,
     &1.4047E+02,1.0551E+02,7.1189E+01,4.2876E+01,1.4635E+01,
     &1.9075E+02,1.4322E+02,9.5759E+01,5.2592E+01,1.4461E+01,
     &2.5487E+02,1.9131E+02,1.2777E+02,6.6443E+01,1.4311E+01/
      DATA ((KB(JS,JT,41,12),JS=1,5),JT=1,5) /
     &6.6999E+01,5.0553E+01,3.8328E+01,3.1540E+01,1.4557E+01,
     &9.6989E+01,7.2904E+01,5.1038E+01,3.6239E+01,1.4754E+01,
     &1.3645E+02,1.0250E+02,6.9354E+01,4.2559E+01,1.4660E+01,
     &1.8750E+02,1.4078E+02,9.4178E+01,5.2196E+01,1.4491E+01,
     &2.5297E+02,1.8988E+02,1.2682E+02,6.6184E+01,1.4389E+01/
      DATA ((KB(JS,JT,42,12),JS=1,5),JT=1,5) /
     &6.3698E+01,4.8173E+01,3.7314E+01,3.1356E+01,1.4515E+01,
     &9.3921E+01,7.0600E+01,4.9842E+01,3.6216E+01,1.4716E+01,
     &1.3407E+02,1.0072E+02,6.8313E+01,4.2558E+01,1.4673E+01,
     &1.8663E+02,1.4013E+02,9.3782E+01,5.2338E+01,1.4521E+01,
     &2.5424E+02,1.9084E+02,1.2745E+02,6.6667E+01,1.4444E+01/
      DATA ((KB(JS,JT,43,12),JS=1,5),JT=1,5) /
     &5.9556E+01,4.5221E+01,3.6039E+01,3.0985E+01,1.4424E+01,
     &8.9715E+01,6.7448E+01,4.8196E+01,3.6053E+01,1.4672E+01,
     &1.3041E+02,9.7958E+01,6.6682E+01,4.2356E+01,1.4685E+01,
     &1.8413E+02,1.3825E+02,9.2592E+01,5.2204E+01,1.4530E+01,
     &2.5372E+02,1.9044E+02,1.2719E+02,6.6793E+01,1.4531E+01/
      DATA ((KB(JS,JT,44,12),JS=1,5),JT=1,5) /
     &5.5617E+01,4.2462E+01,3.4926E+01,3.0616E+01,1.4301E+01,
     &8.5711E+01,6.4467E+01,4.6726E+01,3.5948E+01,1.4602E+01,
     &1.2713E+02,9.5499E+01,6.5283E+01,4.2294E+01,1.4674E+01,
     &1.8238E+02,1.3694E+02,9.1783E+01,5.2246E+01,1.4528E+01,
     &2.5466E+02,1.9115E+02,1.2766E+02,6.7294E+01,1.4570E+01/
      DATA ((KB(JS,JT,45,12),JS=1,5),JT=1,5) /
     &5.2685E+01,4.0486E+01,3.4264E+01,3.0427E+01,1.4151E+01,
     &8.3179E+01,6.2605E+01,4.5965E+01,3.6072E+01,1.4507E+01,
     &1.2601E+02,9.4652E+01,6.4923E+01,4.2669E+01,1.4643E+01,
     &1.8401E+02,1.3816E+02,9.2634E+01,5.3005E+01,1.4503E+01,
     &2.6050E+02,1.9553E+02,1.3058E+02,6.8905E+01,1.4618E+01/
      DATA ((KB(JS,JT,46,12),JS=1,5),JT=1,5) /
     &4.9550E+01,3.8366E+01,3.3605E+01,3.0155E+01,1.3963E+01,
     &8.0337E+01,6.0538E+01,4.5156E+01,3.6142E+01,1.4400E+01,
     &1.2453E+02,9.3545E+01,6.4429E+01,4.3023E+01,1.4594E+01,
     &1.8550E+02,1.3927E+02,9.3438E+01,5.3784E+01,1.4498E+01,
     &2.6666E+02,2.0015E+02,1.3366E+02,7.0579E+01,1.4676E+01/
      DATA ((KB(JS,JT,47,12),JS=1,5),JT=1,5) /
     &4.4761E+01,3.5144E+01,3.2385E+01,2.9408E+01,1.3714E+01,
     &7.4836E+01,5.6569E+01,4.3337E+01,3.5671E+01,1.4241E+01,
     &1.1904E+02,8.9427E+01,6.2124E+01,4.2720E+01,1.4513E+01,
     &1.8135E+02,1.3615E+02,9.1529E+01,5.3518E+01,1.4491E+01,
     &2.6557E+02,1.9933E+02,1.3311E+02,7.0671E+01,1.4708E+01/
      DATA ((KB(JS,JT,48,12),JS=1,5),JT=1,5) /
     &4.1069E+01,3.2801E+01,3.1586E+01,2.8865E+01,1.3457E+01,
     &7.0975E+01,5.3819E+01,4.2302E+01,3.5478E+01,1.4056E+01,
     &1.1614E+02,8.7254E+01,6.1078E+01,4.2908E+01,1.4399E+01,
     &1.8113E+02,1.3599E+02,9.1560E+01,5.4099E+01,1.4482E+01,
     &2.7078E+02,2.0323E+02,1.3570E+02,7.2222E+01,1.4704E+01/
      DATA ((KB(JS,JT,49,12),JS=1,5),JT=1,5) /
     &3.8731E+01,3.1486E+01,3.1265E+01,2.8628E+01,1.3159E+01,
     &6.9397E+01,5.2759E+01,4.2223E+01,3.5759E+01,1.3841E+01,
     &1.1709E+02,8.7966E+01,6.1851E+01,4.3836E+01,1.4254E+01,
     &1.8714E+02,1.4049E+02,9.4623E+01,5.5973E+01,1.4472E+01,
     &2.8581E+02,2.1450E+02,1.4321E+02,7.6013E+01,1.4713E+01/
      DATA ((KB(JS,JT,50,12),JS=1,5),JT=1,5) /
     &3.4845E+01,2.9222E+01,3.0219E+01,2.7841E+01,1.2848E+01,
     &6.4780E+01,4.9517E+01,4.0909E+01,3.5306E+01,1.3605E+01,
     &1.1280E+02,8.4759E+01,6.0286E+01,4.3805E+01,1.4114E+01,
     &1.8491E+02,1.3882E+02,9.3723E+01,5.6179E+01,1.4404E+01,
     &2.8849E+02,2.1650E+02,1.4455E+02,7.7018E+01,1.4673E+01/
      DATA ((KB(JS,JT,51,12),JS=1,5),JT=1,5) /
     &3.0519E+01,2.6754E+01,2.8814E+01,2.6775E+01,1.2516E+01,
     &5.8895E+01,4.5411E+01,3.9106E+01,3.4462E+01,1.3344E+01,
     &1.0594E+02,7.9673E+01,5.7668E+01,4.3297E+01,1.3940E+01,
     &1.7846E+02,1.3399E+02,9.0800E+01,5.5546E+01,1.4316E+01,
     &2.8452E+02,2.1353E+02,1.4260E+02,7.6552E+01,1.4603E+01/
      DATA ((KB(JS,JT,52,12),JS=1,5),JT=1,5) /
     &2.7172E+01,2.4938E+01,2.7638E+01,2.5911E+01,1.2154E+01,
     &5.4443E+01,4.2404E+01,3.7930E+01,3.3867E+01,1.3047E+01,
     &1.0140E+02,7.6335E+01,5.6140E+01,4.3191E+01,1.3744E+01,
     &1.7597E+02,1.3212E+02,8.9791E+01,5.5744E+01,1.4204E+01,
     &2.8690E+02,2.1531E+02,1.4382E+02,7.7564E+01,1.4539E+01/
      DATA ((KB(JS,JT,53,12),JS=1,5),JT=1,5) /
     &2.4852E+01,2.3783E+01,2.6797E+01,2.5306E+01,1.1753E+01,
     &5.1806E+01,4.0721E+01,3.7447E+01,3.3656E+01,1.2720E+01,
     &1.0002E+02,7.5369E+01,5.6019E+01,4.3667E+01,1.3525E+01,
     &1.7916E+02,1.3451E+02,9.1517E+01,5.7134E+01,1.4067E+01,
     &2.9931E+02,2.2462E+02,1.5004E+02,8.0825E+01,1.4479E+01/
      DATA ((KB(JS,JT,54,12),JS=1,5),JT=1,5) /
     &1.9814E+01,2.1046E+01,2.4392E+01,2.3477E+01,1.1367E+01,
     &4.3028E+01,3.5019E+01,3.4545E+01,3.1504E+01,1.2419E+01,
     &8.5988E+01,6.5126E+01,5.0588E+01,4.1403E+01,1.3282E+01,
     &1.5878E+02,1.1923E+02,8.2044E+01,5.3856E+01,1.3889E+01,
     &2.7225E+02,2.0433E+02,1.3669E+02,7.5460E+01,1.4357E+01/
      DATA ((KB(JS,JT,55,12),JS=1,5),JT=1,5) /
     &1.4388E+01,1.7950E+01,2.1372E+01,2.1168E+01,1.0974E+01,
     &3.2596E+01,2.8570E+01,3.0630E+01,2.8429E+01,1.2112E+01,
     &6.7426E+01,5.1747E+01,4.3446E+01,3.7705E+01,1.3016E+01,
     &1.2839E+02,9.6452E+01,6.8218E+01,4.8732E+01,1.3748E+01,
     &2.2612E+02,1.6973E+02,1.1415E+02,6.6296E+01,1.4200E+01/
      DATA ((KB(JS,JT,56,12),JS=1,5),JT=1,5) /
     &1.0289E+01,1.5296E+01,1.8729E+01,1.9182E+01,1.0528E+01,
     &2.4440E+01,2.3761E+01,2.7083E+01,2.5668E+01,1.1786E+01,
     &5.2397E+01,4.1238E+01,3.7979E+01,3.4254E+01,1.2753E+01,
     &1.0299E+02,7.7598E+01,5.7468E+01,4.4519E+01,1.3526E+01,
     &1.8650E+02,1.4002E+02,9.5113E+01,5.8818E+01,1.4062E+01/
      DATA ((KB(JS,JT,57,12),JS=1,5),JT=1,5) /
     &7.2296E+00,1.3018E+01,1.6426E+01,1.7434E+01,1.0060E+01,
     &1.8079E+01,2.0222E+01,2.3856E+01,2.3179E+01,1.1422E+01,
     &4.0328E+01,3.3389E+01,3.3719E+01,3.1042E+01,1.2469E+01,
     &8.1861E+01,6.2161E+01,4.9031E+01,4.0727E+01,1.3313E+01,
     &1.5269E+02,1.1466E+02,7.9200E+01,5.2806E+01,1.3923E+01/
      DATA ((KB(JS,JT,58,12),JS=1,5),JT=1,5) /
     &1.3378E+00,3.6524E+00,6.1661E+00,9.4777E+00,9.5880E+00,
     &3.5257E+00,5.7408E+00,8.9221E+00,1.2503E+01,1.1030E+01,
     &8.2101E+00,9.0368E+00,1.2733E+01,1.6723E+01,1.2197E+01,
     &1.7210E+01,1.6233E+01,1.7913E+01,2.2101E+01,1.3072E+01,
     &3.3035E+01,3.0353E+01,2.7850E+01,2.8452E+01,1.3763E+01/
      DATA ((KB(JS,JT,59,12),JS=1,5),JT=1,5) /
     &1.3260E+00,4.5998E+00,7.5889E+00,1.0717E+01,9.4033E+00,
     &3.6097E+00,7.0919E+00,1.0659E+01,1.3898E+01,1.0849E+01,
     &8.5987E+00,1.0607E+01,1.5006E+01,1.8102E+01,1.2070E+01,
     &1.8312E+01,1.7368E+01,2.0492E+01,2.3593E+01,1.3009E+01,
     &3.5634E+01,3.1449E+01,2.9305E+01,3.0122E+01,1.3723E+01/
      DATA ((KB(JS,JT,13,13),JS=1,5),JT=1,5) /
     &1.2162E+03,9.1228E+02,6.0835E+02,3.0442E+02,5.7609E+00,
     &1.7381E+03,1.3037E+03,8.6931E+02,4.3490E+02,5.6432E+00,
     &2.3576E+03,1.7683E+03,1.1791E+03,5.8977E+02,5.5255E+00,
     &3.0662E+03,2.2998E+03,1.5334E+03,7.6694E+02,5.4044E+00,
     &3.8594E+03,2.8947E+03,1.9299E+03,9.6523E+02,5.2355E+00/
      DATA ((KB(JS,JT,14,13),JS=1,5),JT=1,5) /
     &7.9362E+02,5.9533E+02,3.9705E+02,1.9877E+02,6.3709E+00,
     &1.1345E+03,8.5102E+02,5.6751E+02,2.8400E+02,6.2388E+00,
     &1.5436E+03,1.1578E+03,7.7203E+02,3.8627E+02,6.0986E+00,
     &2.0139E+03,1.5105E+03,1.0072E+03,5.0384E+02,5.9465E+00,
     &2.5413E+03,1.9061E+03,1.2709E+03,6.3569E+02,5.7898E+00/
      DATA ((KB(JS,JT,15,13),JS=1,5),JT=1,5) /
     &5.3943E+02,4.0470E+02,2.6997E+02,1.3524E+02,7.0503E+00,
     &7.7270E+02,5.7965E+02,3.8660E+02,1.9355E+02,6.8771E+00,
     &1.0520E+03,7.8913E+02,5.2626E+02,2.6338E+02,6.6997E+00,
     &1.3743E+03,1.0308E+03,6.8738E+02,3.4394E+02,6.5201E+00,
     &1.7371E+03,1.3030E+03,8.6881E+02,4.3464E+02,6.3410E+00/
      DATA ((KB(JS,JT,16,13),JS=1,5),JT=1,5) /
     &4.4449E+02,3.3349E+02,2.2249E+02,1.1150E+02,7.7448E+00,
     &6.3512E+02,4.7646E+02,3.1780E+02,1.5915E+02,7.5481E+00,
     &8.6257E+02,6.4705E+02,4.3152E+02,2.1600E+02,7.3457E+00,
     &1.1249E+03,8.4376E+02,5.6265E+02,2.8155E+02,7.1472E+00,
     &1.4185E+03,1.0640E+03,7.0946E+02,3.5494E+02,6.9622E+00/
      DATA ((KB(JS,JT,17,13),JS=1,5),JT=1,5) /
     &3.7725E+02,2.8305E+02,1.8886E+02,9.4667E+01,8.5153E+00,
     &5.3579E+02,4.0195E+02,2.6812E+02,1.3428E+02,8.2959E+00,
     &7.2432E+02,5.4334E+02,3.6237E+02,1.8140E+02,8.0790E+00,
     &9.4095E+02,7.0582E+02,4.7068E+02,2.3555E+02,7.8782E+00,
     &1.1800E+03,8.8510E+02,5.9020E+02,2.9531E+02,7.6889E+00/
      DATA ((KB(JS,JT,18,13),JS=1,5),JT=1,5) /
     &3.2277E+02,2.4218E+02,1.6159E+02,8.1002E+01,9.4611E+00,
     &4.5535E+02,3.4161E+02,2.2787E+02,1.1413E+02,9.2187E+00,
     &6.1248E+02,4.5945E+02,3.0643E+02,1.5340E+02,8.9925E+00,
     &7.9039E+02,5.9288E+02,3.9538E+02,1.9787E+02,8.7824E+00,
     &9.8664E+02,7.4007E+02,4.9351E+02,2.4694E+02,8.5832E+00/
      DATA ((KB(JS,JT,19,13),JS=1,5),JT=1,5) /
     &2.6617E+02,1.9972E+02,1.3326E+02,6.6812E+01,1.0581E+01,
     &3.7316E+02,2.7996E+02,1.8675E+02,9.3549E+01,1.0334E+01,
     &4.9811E+02,3.7366E+02,2.4922E+02,1.2478E+02,1.0097E+01,
     &6.3941E+02,4.7964E+02,3.1987E+02,1.6011E+02,9.8657E+00,
     &7.9554E+02,5.9674E+02,3.9794E+02,1.9915E+02,9.6319E+00/
      DATA ((KB(JS,JT,20,13),JS=1,5),JT=1,5) /
     &2.3446E+02,1.7592E+02,1.1738E+02,5.8849E+01,1.1882E+01,
     &3.2565E+02,2.4431E+02,1.6298E+02,8.1640E+01,1.1619E+01,
     &4.3162E+02,3.2380E+02,2.1597E+02,1.0814E+02,1.1360E+01,
     &5.5163E+02,4.1380E+02,2.7598E+02,1.3815E+02,1.1092E+01,
     &6.8433E+02,5.1333E+02,3.4234E+02,1.7134E+02,1.0817E+01/
      DATA ((KB(JS,JT,21,13),JS=1,5),JT=1,5) /
     &2.0791E+02,1.5600E+02,1.0410E+02,5.2196E+01,1.3299E+01,
     &2.8639E+02,2.1487E+02,1.4335E+02,7.1825E+01,1.3019E+01,
     &3.7808E+02,2.8364E+02,1.8920E+02,9.4762E+01,1.2725E+01,
     &4.8188E+02,3.6150E+02,2.4111E+02,1.2072E+02,1.2414E+01,
     &5.9751E+02,4.4821E+02,2.9892E+02,1.4963E+02,1.2098E+01/
      DATA ((KB(JS,JT,22,13),JS=1,5),JT=1,5) /
     &1.8905E+02,1.4186E+02,9.4669E+01,4.7658E+01,1.4760E+01,
     &2.5846E+02,1.9392E+02,1.2939E+02,6.4852E+01,1.4444E+01,
     &3.3936E+02,2.5460E+02,1.6984E+02,8.5086E+01,1.4104E+01,
     &4.3137E+02,3.2361E+02,2.1585E+02,1.0809E+02,1.3746E+01,
     &5.3388E+02,4.0049E+02,2.6710E+02,1.3372E+02,1.3378E+01/
      DATA ((KB(JS,JT,23,13),JS=1,5),JT=1,5) /
     &1.7012E+02,1.2766E+02,8.5209E+01,4.3736E+01,1.6211E+01,
     &2.3107E+02,1.7338E+02,1.1569E+02,5.8148E+01,1.5847E+01,
     &3.0241E+02,2.2689E+02,1.5137E+02,7.5851E+01,1.5467E+01,
     &3.8349E+02,2.8770E+02,1.9191E+02,9.6125E+01,1.5066E+01,
     &4.7369E+02,3.5535E+02,2.3701E+02,1.1867E+02,1.4651E+01/
      DATA ((KB(JS,JT,24,13),JS=1,5),JT=1,5) /
     &1.5057E+02,1.1300E+02,7.5436E+01,4.0246E+01,1.7609E+01,
     &2.0367E+02,1.5283E+02,1.0199E+02,5.2083E+01,1.7203E+01,
     &2.6558E+02,1.9927E+02,1.3295E+02,6.6835E+01,1.6770E+01,
     &3.3594E+02,2.5203E+02,1.6813E+02,8.4226E+01,1.6325E+01,
     &4.1379E+02,3.1042E+02,2.0705E+02,1.0369E+02,1.5864E+01/
      DATA ((KB(JS,JT,25,13),JS=1,5),JT=1,5) /
     &1.3420E+02,1.0073E+02,6.7255E+01,3.7941E+01,1.8922E+01,
     &1.8061E+02,1.3554E+02,9.0464E+01,4.7603E+01,1.8471E+01,
     &2.3464E+02,1.7606E+02,1.1747E+02,5.9840E+01,1.7998E+01,
     &2.9580E+02,2.2193E+02,1.4806E+02,7.4446E+01,1.7506E+01,
     &3.6422E+02,2.7325E+02,1.8228E+02,9.1309E+01,1.6997E+01/
      DATA ((KB(JS,JT,26,13),JS=1,5),JT=1,5) /
     &1.2114E+02,9.0934E+01,6.0946E+01,3.6699E+01,2.0129E+01,
     &1.6224E+02,1.2175E+02,8.1268E+01,4.4540E+01,1.9645E+01,
     &2.0993E+02,1.5753E+02,1.0512E+02,5.4768E+01,1.9134E+01,
     &2.6457E+02,1.9850E+02,1.3244E+02,6.7280E+01,1.8599E+01,
     &3.2617E+02,2.4471E+02,1.6326E+02,8.2064E+01,1.8043E+01/
      DATA ((KB(JS,JT,27,13),JS=1,5),JT=1,5) /
     &1.1288E+02,8.4731E+01,5.7258E+01,3.6591E+01,2.1235E+01,
     &1.5040E+02,1.1288E+02,7.5447E+01,4.3146E+01,2.0722E+01,
     &1.9447E+02,1.4593E+02,9.7397E+01,5.2019E+01,2.0175E+01,
     &2.4522E+02,1.8400E+02,1.2279E+02,6.3250E+01,1.9596E+01,
     &3.0305E+02,2.2738E+02,1.5172E+02,7.6751E+01,1.8997E+01/
      DATA ((KB(JS,JT,28,13),JS=1,5),JT=1,5) /
     &1.0746E+02,8.0667E+01,5.5081E+01,3.7035E+01,2.2229E+01,
     &1.4298E+02,1.0731E+02,7.1965E+01,4.2784E+01,2.1691E+01,
     &1.8493E+02,1.3878E+02,9.2649E+01,5.0725E+01,2.1105E+01,
     &2.3378E+02,1.7543E+02,1.1708E+02,6.1166E+01,2.0486E+01,
     &2.9002E+02,2.1761E+02,1.4521E+02,7.3973E+01,1.9841E+01/
      DATA ((KB(JS,JT,29,13),JS=1,5),JT=1,5) /
     &1.0862E+02,8.1537E+01,5.6008E+01,3.8525E+01,2.3108E+01,
     &1.4451E+02,1.0847E+02,7.2927E+01,4.4121E+01,2.2541E+01,
     &1.8742E+02,1.4066E+02,9.3939E+01,5.2003E+01,2.1917E+01,
     &2.3814E+02,1.7870E+02,1.1927E+02,6.2626E+01,2.1254E+01,
     &2.9712E+02,2.2294E+02,1.4877E+02,7.5955E+01,2.0559E+01/
      DATA ((KB(JS,JT,30,13),JS=1,5),JT=1,5) /
     &1.1263E+02,8.4559E+01,5.8240E+01,4.0363E+01,2.3867E+01,
     &1.5031E+02,1.1283E+02,7.5908E+01,4.6135E+01,2.3263E+01,
     &1.9606E+02,1.4715E+02,9.8280E+01,5.4419E+01,2.2598E+01,
     &2.5065E+02,1.8809E+02,1.2553E+02,6.5875E+01,2.1889E+01,
     &3.1497E+02,2.3633E+02,1.5769E+02,8.0462E+01,2.1149E+01/
      DATA ((KB(JS,JT,31,13),JS=1,5),JT=1,5) /
     &1.2378E+02,9.2930E+01,6.3680E+01,4.3209E+01,2.4494E+01,
     &1.6598E+02,1.2458E+02,8.3650E+01,4.9789E+01,2.3857E+01,
     &2.1788E+02,1.6351E+02,1.0916E+02,5.9548E+01,2.3152E+01,
     &2.8056E+02,2.1051E+02,1.4048E+02,7.3069E+01,2.2400E+01,
     &3.5485E+02,2.6624E+02,1.7763E+02,9.0172E+01,2.1588E+01/
      DATA ((KB(JS,JT,32,13),JS=1,5),JT=1,5) /
     &1.3906E+02,1.0439E+02,7.1039E+01,4.6595E+01,2.5004E+01,
     &1.8760E+02,1.4080E+02,9.4311E+01,5.4496E+01,2.4327E+01,
     &2.4774E+02,1.8590E+02,1.2408E+02,6.6467E+01,2.3584E+01,
     &3.2109E+02,2.4091E+02,1.6074E+02,8.2698E+01,2.2768E+01,
     &4.0872E+02,3.0664E+02,2.0456E+02,1.0327E+02,2.1879E+01/
      DATA ((KB(JS,JT,33,13),JS=1,5),JT=1,5) /
     &1.6104E+02,1.2087E+02,8.1641E+01,5.1002E+01,2.5402E+01,
     &2.1845E+02,1.6394E+02,1.0954E+02,6.1146E+01,2.4688E+01,
     &2.9039E+02,2.1789E+02,1.4539E+02,7.6233E+01,2.3897E+01,
     &3.7885E+02,2.8424E+02,1.8963E+02,9.6481E+01,2.2987E+01,
     &4.8539E+02,3.6414E+02,2.4290E+02,1.2206E+02,2.2183E+01/
      DATA ((KB(JS,JT,34,13),JS=1,5),JT=1,5) /
     &1.8189E+02,1.3651E+02,9.1768E+01,5.5207E+01,2.5729E+01,
     &2.4868E+02,1.8660E+02,1.2456E+02,6.7745E+01,2.4984E+01,
     &3.3298E+02,2.4983E+02,1.6669E+02,8.6174E+01,2.4083E+01,
     &4.3751E+02,3.2823E+02,2.1895E+02,1.1064E+02,2.3253E+01,
     &5.6416E+02,4.2322E+02,2.8227E+02,1.4151E+02,2.2432E+01/
      DATA ((KB(JS,JT,35,13),JS=1,5),JT=1,5) /
     &2.0192E+02,1.5153E+02,1.0158E+02,5.9346E+01,2.6044E+01,
     &2.7880E+02,2.0919E+02,1.3960E+02,7.4527E+01,2.5204E+01,
     &3.7683E+02,2.8271E+02,1.8860E+02,9.6532E+01,2.4315E+01,
     &4.9906E+02,3.7439E+02,2.4972E+02,1.2566E+02,2.3549E+01,
     &6.4817E+02,4.8622E+02,3.2427E+02,1.6242E+02,2.2556E+01/
      DATA ((KB(JS,JT,36,13),JS=1,5),JT=1,5) /
     &2.1718E+02,1.6298E+02,1.0911E+02,6.2682E+01,2.6372E+01,
     &3.0353E+02,2.2773E+02,1.5196E+02,8.0255E+01,2.5484E+01,
     &4.1487E+02,3.1124E+02,2.0762E+02,1.0565E+02,2.4690E+01,
     &5.5465E+02,4.1607E+02,2.7750E+02,1.3934E+02,2.3815E+01,
     &7.2608E+02,5.4465E+02,3.6322E+02,1.8189E+02,2.2654E+01/
      DATA ((KB(JS,JT,37,13),JS=1,5),JT=1,5) /
     &2.1788E+02,1.6349E+02,1.0950E+02,6.3289E+01,2.6719E+01,
     &3.0912E+02,2.3193E+02,1.5476E+02,8.1797E+01,2.5860E+01,
     &4.2846E+02,3.2142E+02,2.1440E+02,1.0906E+02,2.5054E+01,
     &5.7982E+02,4.3495E+02,2.9008E+02,1.4561E+02,2.4158E+01,
     &7.6717E+02,5.7546E+02,3.8377E+02,1.9217E+02,2.2948E+01/
      DATA ((KB(JS,JT,38,13),JS=1,5),JT=1,5) /
     &2.2254E+02,1.6699E+02,1.1184E+02,6.4633E+01,2.7030E+01,
     &3.2031E+02,2.4031E+02,1.6035E+02,8.4610E+01,2.6154E+01,
     &4.5000E+02,3.3758E+02,2.2517E+02,1.1439E+02,2.5377E+01,
     &6.1626E+02,4.6228E+02,3.0831E+02,1.5466E+02,2.4449E+01,
     &8.2391E+02,6.1802E+02,4.1215E+02,2.0635E+02,2.3228E+01/
      DATA ((KB(JS,JT,39,13),JS=1,5),JT=1,5) /
     &2.3401E+02,1.7560E+02,1.1754E+02,6.7259E+01,2.7265E+01,
     &3.4141E+02,2.5613E+02,1.7089E+02,8.9638E+01,2.6464E+01,
     &4.8579E+02,3.6442E+02,2.4308E+02,1.2315E+02,2.5687E+01,
     &6.7297E+02,5.0482E+02,3.3668E+02,1.6875E+02,2.4654E+01,
     &9.0884E+02,6.8173E+02,4.5462E+02,2.2758E+02,2.3620E+01/
      DATA ((KB(JS,JT,40,13),JS=1,5),JT=1,5) /
     &2.2310E+02,1.6742E+02,1.1224E+02,6.5625E+01,2.7589E+01,
     &3.3051E+02,2.4796E+02,1.6546E+02,8.7436E+01,2.6816E+01,
     &4.7705E+02,3.5787E+02,2.3871E+02,1.2127E+02,2.6052E+01,
     &6.7033E+02,5.0284E+02,3.3536E+02,1.6816E+02,2.5038E+01,
     &9.1616E+02,6.8722E+02,4.5828E+02,2.2941E+02,2.4007E+01/
      DATA ((KB(JS,JT,41,13),JS=1,5),JT=1,5) /
     &2.1165E+02,1.5884E+02,1.0674E+02,6.4017E+01,2.7888E+01,
     &3.1819E+02,2.3873E+02,1.5932E+02,8.5003E+01,2.7118E+01,
     &4.6591E+02,3.4951E+02,2.3314E+02,1.1880E+02,2.6396E+01,
     &6.6349E+02,4.9771E+02,3.3195E+02,1.6656E+02,2.5465E+01,
     &9.1847E+02,6.8895E+02,4.5944E+02,2.3000E+02,2.4337E+01/
      DATA ((KB(JS,JT,42,13),JS=1,5),JT=1,5) /
     &2.0335E+02,1.5260E+02,1.0282E+02,6.3023E+01,2.8153E+01,
     &3.1003E+02,2.3260E+02,1.5524E+02,8.3539E+01,2.7395E+01,
     &4.6024E+02,3.4526E+02,2.3031E+02,1.1765E+02,2.6718E+01,
     &6.6381E+02,4.9795E+02,3.3210E+02,1.6673E+02,2.5846E+01,
     &9.3041E+02,6.9790E+02,4.6540E+02,2.3298E+02,2.4647E+01/
      DATA ((KB(JS,JT,43,13),JS=1,5),JT=1,5) /
     &1.9244E+02,1.4443E+02,9.7744E+01,6.1682E+01,2.8431E+01,
     &2.9785E+02,2.2347E+02,1.4920E+02,8.1276E+01,2.7711E+01,
     &4.4872E+02,3.3663E+02,2.2458E+02,1.1517E+02,2.7073E+01,
     &6.5646E+02,4.9243E+02,3.2842E+02,1.6500E+02,2.6290E+01,
     &9.3268E+02,6.9961E+02,4.6654E+02,2.3355E+02,2.5000E+01/
      DATA ((KB(JS,JT,44,13),JS=1,5),JT=1,5) /
     &1.8195E+02,1.3656E+02,9.2955E+01,6.0559E+01,2.8683E+01,
     &2.8673E+02,2.1514E+02,1.4371E+02,7.9343E+01,2.8022E+01,
     &4.3845E+02,3.2893E+02,2.1944E+02,1.1299E+02,2.7430E+01,
     &6.5082E+02,4.8820E+02,3.2560E+02,1.6371E+02,2.6724E+01,
     &9.3739E+02,7.0313E+02,4.6889E+02,2.3472E+02,2.5409E+01/
      DATA ((KB(JS,JT,45,13),JS=1,5),JT=1,5) /
     &1.7490E+02,1.3128E+02,8.9889E+01,6.0087E+01,2.8892E+01,
     &2.8115E+02,2.1096E+02,1.4101E+02,7.8697E+01,2.8297E+01,
     &4.3612E+02,3.2718E+02,2.1828E+02,1.1266E+02,2.7806E+01,
     &6.5668E+02,4.9260E+02,3.2854E+02,1.6526E+02,2.7097E+01,
     &9.5876E+02,7.1917E+02,4.7958E+02,2.4006E+02,2.5776E+01/
      DATA ((KB(JS,JT,46,13),JS=1,5),JT=1,5) /
     &1.6728E+02,1.2556E+02,8.6592E+01,5.9568E+01,2.9082E+01,
     &2.7457E+02,2.0602E+02,1.3784E+02,7.7967E+01,2.8545E+01,
     &4.3313E+02,3.2494E+02,2.1678E+02,1.1222E+02,2.8139E+01,
     &6.6163E+02,4.9632E+02,3.3103E+02,1.6658E+02,2.7449E+01,
     &9.8004E+02,7.3512E+02,4.9021E+02,2.4539E+02,2.6122E+01/
      DATA ((KB(JS,JT,47,13),JS=1,5),JT=1,5) /
     &1.5431E+02,1.1585E+02,8.0931E+01,5.8232E+01,2.9262E+01,
     &2.5885E+02,1.9423E+02,1.3026E+02,7.5643E+01,2.8798E+01,
     &4.1682E+02,3.1271E+02,2.0862E+02,1.0877E+02,2.8446E+01,
     &6.4684E+02,4.8523E+02,3.2363E+02,1.6308E+02,2.7814E+01,
     &9.7279E+02,7.2968E+02,4.8659E+02,2.4359E+02,2.6548E+01/
      DATA ((KB(JS,JT,48,13),JS=1,5),JT=1,5) /
     &1.4538E+02,1.0915E+02,7.7289E+01,5.7662E+01,2.9351E+01,
     &2.4931E+02,1.8708E+02,1.2577E+02,7.4691E+01,2.8998E+01,
     &4.1014E+02,3.0770E+02,2.0528E+02,1.0766E+02,2.8726E+01,
     &6.4756E+02,4.8577E+02,3.2399E+02,1.6338E+02,2.8115E+01,
     &9.8831E+02,7.4133E+02,4.9436E+02,2.4748E+02,2.6944E+01/
      DATA ((KB(JS,JT,49,13),JS=1,5),JT=1,5) /
     &1.4120E+02,1.0604E+02,7.5941E+01,5.8065E+01,2.9380E+01,
     &2.4862E+02,1.8657E+02,1.2564E+02,7.5519E+01,2.9233E+01,
     &4.1758E+02,3.1328E+02,2.0900E+02,1.0986E+02,2.8989E+01,
     &6.7203E+02,5.0412E+02,3.3622E+02,1.6950E+02,2.8333E+01,
     &1.0415E+03,7.8124E+02,5.2096E+02,2.6077E+02,2.7256E+01/
      DATA ((KB(JS,JT,50,13),JS=1,5),JT=1,5) /
     &1.3115E+02,9.8605E+01,7.2172E+01,5.7503E+01,2.9363E+01,
     &2.3790E+02,1.7854E+02,1.2070E+02,7.4407E+01,2.9364E+01,
     &4.0744E+02,3.0568E+02,2.0394E+02,1.0804E+02,2.9149E+01,
     &6.6872E+02,5.0163E+02,3.3456E+02,1.6889E+02,2.8599E+01,
     &1.0519E+03,7.8905E+02,5.2618E+02,2.6337E+02,2.7606E+01/
      DATA ((KB(JS,JT,51,13),JS=1,5),JT=1,5) /
     &1.1865E+02,8.9445E+01,6.7680E+01,5.6587E+01,2.9290E+01,
     &2.2216E+02,1.6674E+02,1.1346E+02,7.2415E+01,2.9435E+01,
     &3.8895E+02,2.9182E+02,1.9472E+02,1.0439E+02,2.9207E+01,
     &6.5048E+02,4.8795E+02,3.2544E+02,1.6473E+02,2.8819E+01,
     &1.0401E+03,7.8020E+02,5.2027E+02,2.6042E+02,2.7943E+01/
      DATA ((KB(JS,JT,52,13),JS=1,5),JT=1,5) /
     &1.0900E+02,8.2517E+01,6.4683E+01,5.6184E+01,2.9159E+01,
     &2.1154E+02,1.5879E+02,1.0876E+02,7.1453E+01,2.9466E+01,
     &3.8014E+02,2.8522E+02,1.9038E+02,1.0306E+02,2.9320E+01,
     &6.4723E+02,4.8552E+02,3.2381E+02,1.6425E+02,2.8993E+01,
     &1.0537E+03,7.9041E+02,5.2708E+02,2.6382E+02,2.8208E+01/
      DATA ((KB(JS,JT,53,13),JS=1,5),JT=1,5) /
     &1.0283E+02,7.8224E+01,6.3272E+01,5.6425E+01,2.8966E+01,
     &2.0760E+02,1.5584E+02,1.0728E+02,7.1858E+01,2.9467E+01,
     &3.8429E+02,2.8834E+02,1.9251E+02,1.0470E+02,2.9381E+01,
     &6.6697E+02,5.0033E+02,3.3369E+02,1.6926E+02,2.9144E+01,
     &1.1061E+03,8.2971E+02,5.5328E+02,2.7691E+02,2.8402E+01/
      DATA ((KB(JS,JT,54,13),JS=1,5),JT=1,5) /
     &8.4612E+01,6.5337E+01,5.7223E+01,5.4259E+01,2.8744E+01,
     &1.7755E+02,1.3329E+02,9.3740E+01,6.7487E+01,2.9376E+01,
     &3.3886E+02,2.5427E+02,1.7017E+02,9.5886E+01,2.9463E+01,
     &6.0067E+02,4.5060E+02,3.0055E+02,1.5369E+02,2.9315E+01,
     &1.0127E+03,7.5962E+02,5.0655E+02,2.5368E+02,2.8705E+01/
      DATA ((KB(JS,JT,55,13),JS=1,5),JT=1,5) /
     &6.3387E+01,5.0935E+01,5.0168E+01,5.0996E+01,2.8487E+01,
     &1.3831E+02,1.0410E+02,7.7011E+01,6.1667E+01,2.9169E+01,
     &2.7282E+02,2.0475E+02,1.3822E+02,8.3541E+01,2.9521E+01,
     &4.9509E+02,3.7143E+02,2.4779E+02,1.2925E+02,2.9355E+01,
     &8.4764E+02,6.3583E+02,4.2402E+02,2.1299E+02,2.9013E+01/
      DATA ((KB(JS,JT,56,13),JS=1,5),JT=1,5) /
     &4.6914E+01,4.0782E+01,4.5015E+01,4.7952E+01,2.8186E+01,
     &1.0661E+02,8.1027E+01,6.4934E+01,5.7313E+01,2.9008E+01,
     &2.1790E+02,1.6356E+02,1.1223E+02,7.3951E+01,2.9460E+01,
     &4.0585E+02,3.0451E+02,2.0325E+02,1.0953E+02,2.9455E+01,
     &7.0659E+02,5.3004E+02,3.5349E+02,1.7883E+02,2.9213E+01/
      DATA ((KB(JS,JT,57,13),JS=1,5),JT=1,5) /
     &3.4230E+01,3.3758E+01,4.1164E+01,4.5068E+01,2.7829E+01,
     &8.1249E+01,6.3007E+01,5.6061E+01,5.3761E+01,2.8811E+01,
     &1.7223E+02,1.2931E+02,9.1411E+01,6.6606E+01,2.9335E+01,
     &3.3026E+02,2.4783E+02,1.6598E+02,9.4193E+01,2.9500E+01,
     &5.8636E+02,4.3987E+02,2.9340E+02,1.5031E+02,2.9335E+01/
      DATA ((KB(JS,JT,58,13),JS=1,5),JT=1,5) /
     &6.5933E+00,9.4893E+00,1.6089E+01,2.5300E+01,2.7425E+01,
     &1.6360E+01,1.6224E+01,2.0957E+01,3.0182E+01,2.8583E+01,
     &3.5957E+01,3.3123E+01,3.1853E+01,3.6291E+01,2.9233E+01,
     &7.1076E+01,6.5212E+01,5.6746E+01,4.8699E+01,2.9472E+01,
     &1.2897E+02,1.1828E+02,1.0149E+02,7.4519E+01,2.9400E+01/
      DATA ((KB(JS,JT,59,13),JS=1,5),JT=1,5) /
     &6.7458E+00,1.2021E+01,2.0178E+01,2.9391E+01,2.7237E+01,
     &1.7109E+01,1.8183E+01,2.5274E+01,3.4440E+01,2.8519E+01,
     &3.8233E+01,3.4158E+01,3.4619E+01,4.0204E+01,2.9240E+01,
     &7.6647E+01,6.6998E+01,5.6073E+01,4.9489E+01,2.9509E+01,
     &1.4043E+02,1.2268E+02,9.8230E+01,6.8889E+01,2.9402E+01/
      DATA ((KB(JS,JT,13,14),JS=1,5),JT=1,5) /
     &2.1776E+03,1.6333E+03,1.0891E+03,5.4478E+02,7.3262E+00,
     &3.1101E+03,2.3327E+03,1.5553E+03,7.7788E+02,7.3124E+00,
     &4.2249E+03,3.1687E+03,2.1126E+03,1.0565E+03,7.2480E+00,
     &5.5118E+03,4.1339E+03,2.7561E+03,1.3783E+03,7.1568E+00,
     &6.9506E+03,5.2131E+03,3.4755E+03,1.7380E+03,7.0367E+00/
      DATA ((KB(JS,JT,14,14),JS=1,5),JT=1,5) /
     &1.4496E+03,1.0873E+03,7.2501E+02,3.6272E+02,8.3339E+00,
     &2.0734E+03,1.5551E+03,1.0369E+03,5.1863E+02,8.2705E+00,
     &2.8238E+03,2.1179E+03,1.4121E+03,7.0623E+02,8.1703E+00,
     &3.6841E+03,2.7632E+03,1.8422E+03,9.2131E+02,8.0387E+00,
     &4.6457E+03,3.4843E+03,2.3230E+03,1.1617E+03,7.8896E+00/
      DATA ((KB(JS,JT,15,14),JS=1,5),JT=1,5) /
     &9.9772E+02,7.4839E+02,4.9906E+02,2.4972E+02,9.4242E+00,
     &1.4271E+03,1.0704E+03,7.1374E+02,3.5707E+02,9.3124E+00,
     &1.9364E+03,1.4524E+03,9.6841E+02,4.8440E+02,9.1590E+00,
     &2.5268E+03,1.8952E+03,1.2636E+03,6.3198E+02,8.9837E+00,
     &3.1888E+03,2.3917E+03,1.5946E+03,7.9748E+02,8.7913E+00/
      DATA ((KB(JS,JT,16,14),JS=1,5),JT=1,5) /
     &8.2535E+02,6.1910E+02,4.1286E+02,2.0662E+02,1.0617E+01,
     &1.1765E+03,8.8250E+02,5.8845E+02,2.9441E+02,1.0441E+01,
     &1.5988E+03,1.1992E+03,7.9956E+02,3.9995E+02,1.0240E+01,
     &2.0853E+03,1.5640E+03,1.0428E+03,5.2160E+02,1.0022E+01,
     &2.6260E+03,1.9696E+03,1.3132E+03,6.5679E+02,9.7853E+00/
      DATA ((KB(JS,JT,17,14),JS=1,5),JT=1,5) /
     &7.1446E+02,5.3593E+02,3.5740E+02,1.7888E+02,1.1902E+01,
     &1.0170E+03,7.6281E+02,5.0866E+02,2.5450E+02,1.1678E+01,
     &1.3782E+03,1.0338E+03,6.8929E+02,3.4482E+02,1.1434E+01,
     &1.7913E+03,1.3436E+03,8.9585E+02,4.4810E+02,1.1160E+01,
     &2.2531E+03,1.6899E+03,1.1267E+03,5.6354E+02,1.0872E+01/
      DATA ((KB(JS,JT,18,14),JS=1,5),JT=1,5) /
     &6.3627E+02,4.7728E+02,3.1830E+02,1.5932E+02,1.3306E+01,
     &9.0279E+02,6.7718E+02,4.5157E+02,2.2596E+02,1.3021E+01,
     &1.2176E+03,9.1326E+02,6.0896E+02,3.0466E+02,1.2705E+01,
     &1.5793E+03,1.1846E+03,7.8983E+02,3.9509E+02,1.2374E+01,
     &1.9821E+03,1.4867E+03,9.9125E+02,4.9580E+02,1.2038E+01/
      DATA ((KB(JS,JT,19,14),JS=1,5),JT=1,5) /
     &5.5701E+02,4.1784E+02,2.7868E+02,1.3951E+02,1.4835E+01,
     &7.8555E+02,5.8924E+02,3.9294E+02,1.9665E+02,1.4471E+01,
     &1.0565E+03,7.9246E+02,5.2842E+02,2.6438E+02,1.4088E+01,
     &1.3666E+03,1.0251E+03,6.8348E+02,3.4191E+02,1.3700E+01,
     &1.7097E+03,1.2824E+03,8.5504E+02,4.2769E+02,1.3330E+01/
      DATA ((KB(JS,JT,20,14),JS=1,5),JT=1,5) /
     &5.2902E+02,3.9685E+02,2.6468E+02,1.3251E+02,1.6461E+01,
     &7.4221E+02,5.5674E+02,3.7128E+02,1.8581E+02,1.6028E+01,
     &9.9413E+02,7.4568E+02,4.9723E+02,2.4879E+02,1.5588E+01,
     &1.2802E+03,9.6022E+02,6.4026E+02,3.2030E+02,1.5170E+01,
     &1.5959E+03,1.1970E+03,7.9814E+02,3.9924E+02,1.4766E+01/
      DATA ((KB(JS,JT,21,14),JS=1,5),JT=1,5) /
     &5.1643E+02,3.8740E+02,2.5838E+02,1.2935E+02,1.8266E+01,
     &7.2079E+02,5.4067E+02,3.6056E+02,1.8045E+02,1.7763E+01,
     &9.5965E+02,7.1982E+02,4.7999E+02,2.4017E+02,1.7272E+01,
     &1.2302E+03,9.2274E+02,6.1527E+02,3.0781E+02,1.6803E+01,
     &1.5280E+03,1.1461E+03,7.6416E+02,3.8225E+02,1.6348E+01/
      DATA ((KB(JS,JT,22,14),JS=1,5),JT=1,5) /
     &5.2623E+02,3.9475E+02,2.6327E+02,1.3179E+02,2.0243E+01,
     &7.2644E+02,5.4491E+02,3.6339E+02,1.8186E+02,1.9664E+01,
     &9.5925E+02,7.1952E+02,4.7979E+02,2.4006E+02,1.9116E+01,
     &1.2211E+03,9.1590E+02,6.1071E+02,3.0553E+02,1.8593E+01,
     &1.5078E+03,1.1310E+03,7.5409E+02,3.7722E+02,1.8080E+01/
      DATA ((KB(JS,JT,23,14),JS=1,5),JT=1,5) /
     &5.3158E+02,3.9876E+02,2.6595E+02,1.3313E+02,2.2446E+01,
     &7.2667E+02,5.4508E+02,3.6349E+02,1.8191E+02,2.1789E+01,
     &9.5159E+02,7.1378E+02,4.7596E+02,2.3814E+02,2.1156E+01,
     &1.2042E+03,9.0323E+02,6.0227E+02,3.0131E+02,2.0541E+01,
     &1.4791E+03,1.1094E+03,7.3972E+02,3.7004E+02,1.9936E+01/
      DATA ((KB(JS,JT,24,14),JS=1,5),JT=1,5) /
     &5.2674E+02,3.9513E+02,2.6351E+02,1.3189E+02,2.4861E+01,
     &7.1320E+02,5.3497E+02,3.5675E+02,1.7852E+02,2.4105E+01,
     &9.2799E+02,6.9608E+02,4.6416E+02,2.3224E+02,2.3357E+01,
     &1.1676E+03,8.7581E+02,5.8399E+02,2.9218E+02,2.2617E+01,
     &1.4298E+03,1.0724E+03,7.1508E+02,3.5774E+02,2.1888E+01/
      DATA ((KB(JS,JT,25,14),JS=1,5),JT=1,5) /
     &5.2185E+02,3.9145E+02,2.6105E+02,1.3066E+02,2.7396E+01,
     &7.0140E+02,5.2612E+02,3.5084E+02,1.7556E+02,2.6509E+01,
     &9.0713E+02,6.8043E+02,4.5373E+02,2.2703E+02,2.5618E+01,
     &1.1371E+03,8.5288E+02,5.6870E+02,2.8453E+02,2.4730E+01,
     &1.3891E+03,1.0419E+03,6.9474E+02,3.4757E+02,2.3860E+01/
      DATA ((KB(JS,JT,26,14),JS=1,5),JT=1,5) /
     &5.2251E+02,3.9195E+02,2.6138E+02,1.3085E+02,2.9927E+01,
     &6.9730E+02,5.2305E+02,3.4880E+02,1.7455E+02,2.8877E+01,
     &8.9735E+02,6.7309E+02,4.4884E+02,2.2459E+02,2.7820E+01,
     &1.1213E+03,8.4105E+02,5.6081E+02,2.8058E+02,2.6772E+01,
     &1.3665E+03,1.0250E+03,6.8346E+02,3.4192E+02,2.5741E+01/
      DATA ((KB(JS,JT,27,14),JS=1,5),JT=1,5) /
     &5.3834E+02,4.0383E+02,2.6931E+02,1.3510E+02,3.2357E+01,
     &7.1439E+02,5.3587E+02,3.5735E+02,1.7883E+02,3.1116E+01,
     &9.1626E+02,6.8728E+02,4.5830E+02,2.2932E+02,2.9881E+01,
     &1.1424E+03,8.5692E+02,5.7140E+02,2.8587E+02,2.8666E+01,
     &1.3901E+03,1.0427E+03,6.9525E+02,3.4781E+02,2.7467E+01/
      DATA ((KB(JS,JT,28,14),JS=1,5),JT=1,5) /
     &5.6592E+02,4.2451E+02,2.8310E+02,1.4237E+02,3.4583E+01,
     &7.4785E+02,5.6096E+02,3.7408E+02,1.8720E+02,3.3140E+01,
     &9.5690E+02,7.1776E+02,4.7862E+02,2.3947E+02,3.1724E+01,
     &1.1915E+03,8.9371E+02,5.9592E+02,2.9814E+02,3.0340E+01,
     &1.4480E+03,1.0861E+03,7.2421E+02,3.6229E+02,2.8988E+01/
      DATA ((KB(JS,JT,29,14),JS=1,5),JT=1,5) /
     &6.3031E+02,4.7280E+02,3.1529E+02,1.5867E+02,3.6546E+01,
     &8.3056E+02,6.2300E+02,4.1543E+02,2.0788E+02,3.4912E+01,
     &1.0608E+03,7.9566E+02,5.3055E+02,2.6544E+02,3.3320E+01,
     &1.3185E+03,9.8899E+02,6.5945E+02,3.2990E+02,3.1769E+01,
     &1.6020E+03,1.2016E+03,8.0116E+02,4.0076E+02,3.0274E+01/
      DATA ((KB(JS,JT,30,14),JS=1,5),JT=1,5) /
     &7.1878E+02,5.3916E+02,3.5953E+02,1.8082E+02,3.8231E+01,
     &9.4502E+02,7.0884E+02,4.7266E+02,2.3650E+02,3.6421E+01,
     &1.2048E+03,9.0370E+02,6.0258E+02,3.0145E+02,3.4660E+01,
     &1.4966E+03,1.1225E+03,7.4846E+02,3.7440E+02,3.2964E+01,
     &1.8180E+03,1.3636E+03,9.0918E+02,4.5477E+02,3.1338E+01/
      DATA ((KB(JS,JT,31,14),JS=1,5),JT=1,5) /
     &8.6352E+02,6.4770E+02,4.3189E+02,2.1681E+02,3.9626E+01,
     &1.1338E+03,8.5039E+02,5.6702E+02,2.8366E+02,3.7649E+01,
     &1.4436E+03,1.0827E+03,7.2193E+02,3.6112E+02,3.5738E+01,
     &1.7919E+03,1.3440E+03,8.9611E+02,4.4823E+02,3.3911E+01,
     &2.1766E+03,1.6325E+03,1.0885E+03,5.4442E+02,3.2168E+01/
      DATA ((KB(JS,JT,32,14),JS=1,5),JT=1,5) /
     &1.0534E+03,7.9009E+02,5.2682E+02,2.6397E+02,4.0725E+01,
     &1.3802E+03,1.0352E+03,6.9024E+02,3.4527E+02,3.8603E+01,
     &1.7557E+03,1.3169E+03,8.7802E+02,4.3918E+02,3.6565E+01,
     &2.1789E+03,1.6342E+03,1.0896E+03,5.4499E+02,3.4625E+01,
     &2.6446E+03,1.9836E+03,1.3225E+03,6.6145E+02,3.2784E+01/
      DATA ((KB(JS,JT,33,14),JS=1,5),JT=1,5) /
     &1.3124E+03,9.8436E+02,6.5633E+02,3.2843E+02,4.1548E+01,
     &1.7177E+03,1.2883E+03,8.5900E+02,4.2966E+02,3.9303E+01,
     &2.1832E+03,1.6375E+03,1.0918E+03,5.4605E+02,3.7160E+01,
     &2.7063E+03,2.0298E+03,1.3533E+03,6.7686E+02,3.5130E+01,
     &3.2806E+03,2.4606E+03,1.6405E+03,8.2046E+02,3.3063E+01/
      DATA ((KB(JS,JT,34,14),JS=1,5),JT=1,5) /
     &1.5860E+03,1.1896E+03,7.9315E+02,3.9672E+02,4.2202E+01,
     &2.0745E+03,1.5559E+03,1.0374E+03,5.1886E+02,3.9853E+01,
     &2.6355E+03,1.9767E+03,1.3179E+03,6.5913E+02,3.7623E+01,
     &3.2644E+03,2.4484E+03,1.6324E+03,8.1637E+02,3.5405E+01,
     &3.9520E+03,2.9641E+03,1.9762E+03,9.8832E+02,3.3276E+01/
      DATA ((KB(JS,JT,35,14),JS=1,5),JT=1,5) /
     &1.8756E+03,1.4068E+03,9.3797E+02,4.6914E+02,4.2878E+01,
     &2.4578E+03,1.8434E+03,1.2290E+03,6.1469E+02,4.0440E+01,
     &3.1268E+03,2.3452E+03,1.5636E+03,7.8197E+02,3.8129E+01,
     &3.8751E+03,2.9064E+03,1.9378E+03,9.6909E+02,3.5715E+01,
     &4.6936E+03,3.5203E+03,2.3471E+03,1.1738E+03,3.3797E+01/
      DATA ((KB(JS,JT,36,14),JS=1,5),JT=1,5) /
     &2.1453E+03,1.6090E+03,1.0728E+03,5.3655E+02,4.3664E+01,
     &2.8245E+03,2.1184E+03,1.4124E+03,7.0636E+02,4.1138E+01,
     &3.6063E+03,2.7048E+03,1.8033E+03,9.0186E+02,3.8589E+01,
     &4.4821E+03,3.3616E+03,2.2412E+03,1.1208E+03,3.6195E+01,
     &5.4418E+03,4.0814E+03,2.7211E+03,1.3608E+03,3.4367E+01/
      DATA ((KB(JS,JT,37,14),JS=1,5),JT=1,5) /
     &2.2940E+03,1.7205E+03,1.1471E+03,5.7372E+02,4.4724E+01,
     &3.0476E+03,2.2858E+03,1.5240E+03,7.6217E+02,4.2103E+01,
     &3.9216E+03,2.9413E+03,1.9610E+03,9.8070E+02,3.9415E+01,
     &4.9050E+03,3.6789E+03,2.4527E+03,1.2266E+03,3.7136E+01,
     &5.9876E+03,4.4908E+03,2.9940E+03,1.4972E+03,3.5121E+01/
      DATA ((KB(JS,JT,38,14),JS=1,5),JT=1,5) /
     &2.4855E+03,1.8642E+03,1.2429E+03,6.2161E+02,4.5721E+01,
     &3.3318E+03,2.4989E+03,1.6661E+03,8.3322E+02,4.3010E+01,
     &4.3213E+03,3.2410E+03,2.1608E+03,1.0806E+03,4.0195E+01,
     &5.4403E+03,4.0803E+03,2.7203E+03,1.3604E+03,3.7939E+01,
     &6.6754E+03,5.0066E+03,3.3379E+03,1.6692E+03,3.5824E+01/
      DATA ((KB(JS,JT,39,14),JS=1,5),JT=1,5) /
     &2.7579E+03,2.0685E+03,1.3791E+03,6.8973E+02,4.6636E+01,
     &3.7311E+03,2.7984E+03,1.8657E+03,9.3308E+02,4.3764E+01,
     &4.8740E+03,3.6556E+03,2.4372E+03,1.2188E+03,4.0901E+01,
     &6.1755E+03,4.6318E+03,3.0880E+03,1.5442E+03,3.8692E+01,
     &7.6168E+03,5.7128E+03,3.8087E+03,1.9046E+03,3.6244E+01/
      DATA ((KB(JS,JT,40,14),JS=1,5),JT=1,5) /
     &2.7806E+03,2.0855E+03,1.3905E+03,6.9541E+02,4.7781E+01,
     &3.8105E+03,2.8580E+03,1.9054E+03,9.5291E+02,4.4820E+01,
     &5.0317E+03,3.7739E+03,2.5160E+03,1.2582E+03,4.1870E+01,
     &6.4348E+03,4.8262E+03,3.2176E+03,1.6090E+03,3.9597E+01,
     &7.9965E+03,5.9975E+03,3.9985E+03,1.9995E+03,3.7061E+01/
      DATA ((KB(JS,JT,41,14),JS=1,5),JT=1,5) /
     &2.7787E+03,2.0841E+03,1.3895E+03,6.9500E+02,4.8925E+01,
     &3.8614E+03,2.8961E+03,1.9309E+03,9.6566E+02,4.5922E+01,
     &5.1574E+03,3.8681E+03,2.5789E+03,1.2897E+03,4.2853E+01,
     &6.6587E+03,4.9941E+03,3.3296E+03,1.6650E+03,4.0428E+01,
     &8.3439E+03,6.2581E+03,4.1723E+03,2.0864E+03,3.7900E+01/
      DATA ((KB(JS,JT,42,14),JS=1,5),JT=1,5) /
     &2.7998E+03,2.0999E+03,1.4001E+03,7.0041E+02,5.0031E+01,
     &3.9460E+03,2.9596E+03,1.9732E+03,9.8680E+02,4.6998E+01,
     &5.3323E+03,3.9993E+03,2.6663E+03,1.3334E+03,4.3819E+01,
     &6.9531E+03,5.2149E+03,3.4767E+03,1.7386E+03,4.1253E+01,
     &8.7873E+03,6.5906E+03,4.3939E+03,2.1972E+03,3.8745E+01/
      DATA ((KB(JS,JT,43,14),JS=1,5),JT=1,5) /
     &2.7784E+03,2.0839E+03,1.3894E+03,6.9544E+02,5.1292E+01,
     &3.9830E+03,2.9874E+03,1.9917E+03,9.9606E+02,4.8177E+01,
     &5.4603E+03,4.0953E+03,2.7304E+03,1.3654E+03,4.4925E+01,
     &7.2065E+03,5.4050E+03,3.6035E+03,1.8020E+03,4.2242E+01,
     &9.2025E+03,6.9020E+03,4.6015E+03,2.3010E+03,3.9649E+01/
      DATA ((KB(JS,JT,44,14),JS=1,5),JT=1,5) /
     &2.7542E+03,2.0657E+03,1.3772E+03,6.8977E+02,5.2617E+01,
     &4.0230E+03,3.0173E+03,2.0117E+03,1.0060E+03,4.9427E+01,
     &5.6050E+03,4.2038E+03,2.8027E+03,1.4015E+03,4.6077E+01,
     &7.4959E+03,5.6220E+03,3.7481E+03,1.8743E+03,4.3276E+01,
     &9.6875E+03,7.2657E+03,4.8439E+03,2.4222E+03,4.0647E+01/
      DATA ((KB(JS,JT,45,14),JS=1,5),JT=1,5) /
     &2.7680E+03,2.0761E+03,1.3842E+03,6.9371E+02,5.3927E+01,
     &4.1247E+03,3.0936E+03,2.0625E+03,1.0314E+03,5.0672E+01,
     &5.8448E+03,4.3837E+03,2.9226E+03,1.4615E+03,4.7150E+01,
     &7.9284E+03,5.9463E+03,3.9644E+03,1.9824E+03,4.4329E+01,
     &1.0369E+04,7.7768E+03,5.1847E+03,2.5926E+03,4.1634E+01/
      DATA ((KB(JS,JT,46,14),JS=1,5),JT=1,5) /
     &2.7642E+03,2.0732E+03,1.3822E+03,6.9344E+02,5.5299E+01,
     &4.2127E+03,3.1596E+03,2.1065E+03,1.0534E+03,5.1989E+01,
     &6.0817E+03,4.5614E+03,3.0411E+03,1.5207E+03,4.8362E+01,
     &8.3835E+03,6.2877E+03,4.1920E+03,2.0962E+03,4.5451E+01,
     &1.1109E+04,8.3315E+03,5.5545E+03,2.7775E+03,4.2710E+01/
      DATA ((KB(JS,JT,47,14),JS=1,5),JT=1,5) /
     &2.6579E+03,1.9935E+03,1.3291E+03,6.6810E+02,5.6805E+01,
     &4.1618E+03,3.1214E+03,2.0811E+03,1.0407E+03,5.3447E+01,
     &6.1402E+03,4.6053E+03,3.0703E+03,1.5354E+03,4.9761E+01,
     &8.6262E+03,6.4697E+03,4.3133E+03,2.1569E+03,4.6695E+01,
     &1.1609E+04,8.7071E+03,5.8049E+03,2.9027E+03,4.4026E+01/
      DATA ((KB(JS,JT,48,14),JS=1,5),JT=1,5) /
     &2.5983E+03,1.9488E+03,1.2993E+03,6.5451E+02,5.8316E+01,
     &4.1890E+03,3.1418E+03,2.0947E+03,1.0476E+03,5.4906E+01,
     &6.3280E+03,4.7461E+03,3.1642E+03,1.5823E+03,5.1153E+01,
     &9.0666E+03,6.8001E+03,4.5335E+03,2.2670E+03,4.7961E+01,
     &1.2413E+04,9.3096E+03,6.2066E+03,3.1035E+03,4.5348E+01/
      DATA ((KB(JS,JT,49,14),JS=1,5),JT=1,5) /
     &2.6146E+03,1.9610E+03,1.3074E+03,6.5952E+02,5.9823E+01,
     &4.3479E+03,3.2610E+03,2.1741E+03,1.0874E+03,5.6229E+01,
     &6.7401E+03,5.0552E+03,3.3702E+03,1.6853E+03,5.2522E+01,
     &9.8602E+03,7.3953E+03,4.9303E+03,2.4653E+03,4.9326E+01,
     &1.3745E+04,1.0309E+04,6.8727E+03,3.4366E+03,4.6702E+01/
      DATA ((KB(JS,JT,50,14),JS=1,5),JT=1,5) /
     &2.5099E+03,1.8825E+03,1.2551E+03,6.3476E+02,6.1230E+01,
     &4.3054E+03,3.2291E+03,2.1528E+03,1.0772E+03,5.7584E+01,
     &6.8503E+03,5.1378E+03,3.4253E+03,1.7128E+03,5.3876E+01,
     &1.0235E+04,7.6760E+03,5.1175E+03,2.5589E+03,5.0609E+01,
     &1.4527E+04,1.0895E+04,7.2636E+03,3.6320E+03,4.7904E+01/
      DATA ((KB(JS,JT,51,14),JS=1,5),JT=1,5) /
     &2.3421E+03,1.7566E+03,1.1712E+03,5.9456E+02,6.2588E+01,
     &4.1517E+03,3.1138E+03,2.0760E+03,1.0393E+03,5.8927E+01,
     &6.7861E+03,5.0897E+03,3.3932E+03,1.6968E+03,5.5331E+01,
     &1.0366E+04,7.7746E+03,5.1832E+03,2.5918E+03,5.1728E+01,
     &1.4983E+04,1.1238E+04,7.4919E+03,3.7462E+03,4.9071E+01/
      DATA ((KB(JS,JT,52,14),JS=1,5),JT=1,5) /
     &2.2192E+03,1.6645E+03,1.1098E+03,5.6550E+02,6.3929E+01,
     &4.0774E+03,3.0581E+03,2.0388E+03,1.0215E+03,6.0266E+01,
     &6.8574E+03,5.1432E+03,3.4289E+03,1.7146E+03,5.6630E+01,
     &1.0728E+04,8.0459E+03,5.3641E+03,2.6822E+03,5.3054E+01,
     &1.5806E+04,1.1855E+04,7.9035E+03,3.9520E+03,5.0321E+01/
      DATA ((KB(JS,JT,53,14),JS=1,5),JT=1,5) /
     &2.1588E+03,1.6192E+03,1.0797E+03,5.5175E+02,6.5259E+01,
     &4.1225E+03,3.0919E+03,2.0614E+03,1.0332E+03,6.1546E+01,
     &7.1492E+03,5.3620E+03,3.5747E+03,1.7875E+03,5.7918E+01,
     &1.1475E+04,8.6063E+03,5.7376E+03,2.8690E+03,5.4409E+01,
     &1.7262E+04,1.2946E+04,8.6311E+03,4.3158E+03,5.1571E+01/
      DATA ((KB(JS,JT,54,14),JS=1,5),JT=1,5) /
     &1.8282E+03,1.3713E+03,9.1520E+02,4.7290E+02,6.6448E+01,
     &3.6279E+03,2.7210E+03,1.8141E+03,9.1135E+02,6.2844E+01,
     &6.4841E+03,4.8631E+03,3.2422E+03,1.6212E+03,5.9155E+01,
     &1.0670E+04,8.0025E+03,5.3351E+03,2.6677E+03,5.5552E+01,
     &1.6384E+04,1.2288E+04,8.1922E+03,4.0963E+03,5.2636E+01/
      DATA ((KB(JS,JT,55,14),JS=1,5),JT=1,5) /
     &1.4067E+03,1.0551E+03,7.0638E+02,3.7354E+02,6.7558E+01,
     &2.9041E+03,2.1781E+03,1.4522E+03,7.3353E+02,6.4148E+01,
     &5.3593E+03,4.0195E+03,2.6797E+03,1.3404E+03,6.0390E+01,
     &9.0439E+03,6.7830E+03,4.5221E+03,2.2612E+03,5.6702E+01,
     &1.4184E+04,1.0638E+04,7.0920E+03,3.5462E+03,5.3319E+01/
      DATA ((KB(JS,JT,56,14),JS=1,5),JT=1,5) /
     &1.0676E+03,8.0078E+02,5.3961E+02,2.9566E+02,6.8630E+01,
     &2.3009E+03,1.7258E+03,1.1507E+03,5.8655E+02,6.5294E+01,
     &4.3913E+03,3.2935E+03,2.1958E+03,1.1000E+03,6.1700E+01,
     &7.6108E+03,5.7081E+03,3.8055E+03,1.9028E+03,5.7982E+01,
     &1.2207E+04,9.1554E+03,6.1037E+03,3.0520E+03,5.4269E+01/
      DATA ((KB(JS,JT,57,14),JS=1,5),JT=1,5) /
     &7.9773E+02,5.9861E+02,4.0826E+02,2.3574E+02,6.9656E+01,
     &1.8005E+03,1.3505E+03,9.0146E+02,4.6638E+02,6.6420E+01,
     &3.5629E+03,2.6722E+03,1.7816E+03,8.9534E+02,6.2948E+01,
     &6.3553E+03,4.7665E+03,3.1777E+03,1.5890E+03,5.9228E+01,
     &1.0437E+04,7.8281E+03,5.2188E+03,2.6095E+03,5.5502E+01/
      DATA ((KB(JS,JT,58,14),JS=1,5),JT=1,5) /
     &1.5691E+02,1.4430E+02,1.2945E+02,1.1296E+02,7.0583E+01,
     &3.7146E+02,3.4061E+02,2.9343E+02,2.1801E+02,6.7460E+01,
     &7.6282E+02,6.9942E+02,5.9974E+02,4.2478E+02,6.4030E+01,
     &1.4014E+03,1.2849E+03,1.1017E+03,7.7206E+02,6.0507E+01,
     &2.3564E+03,2.1605E+03,1.8525E+03,1.2975E+03,5.6760E+01/
      DATA ((KB(JS,JT,59,14),JS=1,5),JT=1,5) /
     &1.6269E+02,1.4372E+02,1.2601E+02,1.1040E+02,7.0952E+01,
     &3.9338E+02,3.4354E+02,2.7833E+02,1.9401E+02,6.7878E+01,
     &8.2073E+02,7.1668E+02,5.7208E+02,3.6616E+02,6.4473E+01,
     &1.5267E+03,1.3331E+03,1.0634E+03,6.6456E+02,6.0953E+01,
     &2.5924E+03,2.2637E+03,1.8057E+03,1.1237E+03,5.7434E+01/
      DATA ((KB(JS,JT,13,15),JS=1,5),JT=1,5) /
     &6.7676E+03,5.0758E+03,3.3840E+03,1.6922E+03,9.0910E+00,
     &9.5300E+03,7.1475E+03,4.7651E+03,2.3827E+03,8.9593E+00,
     &1.2768E+04,9.5761E+03,6.3842E+03,3.1923E+03,8.8860E+00,
     &1.6413E+04,1.2310E+04,8.2067E+03,4.1035E+03,8.8094E+00,
     &2.0377E+04,1.5283E+04,1.0189E+04,5.0946E+03,8.7010E+00/
      DATA ((KB(JS,JT,14,15),JS=1,5),JT=1,5) /
     &4.6855E+03,3.5142E+03,2.3429E+03,1.1716E+03,1.0351E+01,
     &6.5777E+03,4.9333E+03,3.2890E+03,1.6447E+03,1.0245E+01,
     &8.7780E+03,6.5835E+03,4.3891E+03,2.1947E+03,1.0189E+01,
     &1.1257E+04,8.4428E+03,5.6286E+03,2.8145E+03,1.0105E+01,
     &1.3964E+04,1.0473E+04,6.9821E+03,3.4912E+03,9.9926E+00/
      DATA ((KB(JS,JT,15,15),JS=1,5),JT=1,5) /
     &3.2854E+03,2.4642E+03,1.6429E+03,8.2169E+02,1.1907E+01,
     &4.5889E+03,3.4418E+03,2.2947E+03,1.1475E+03,1.1847E+01,
     &6.1056E+03,4.5793E+03,3.0530E+03,1.5267E+03,1.1796E+01,
     &7.8011E+03,5.8510E+03,3.9008E+03,1.9506E+03,1.1682E+01,
     &9.6352E+03,7.2265E+03,4.8178E+03,2.4091E+03,1.1548E+01/
      DATA ((KB(JS,JT,16,15),JS=1,5),JT=1,5) /
     &2.7156E+03,2.0368E+03,1.3580E+03,6.7918E+02,1.3833E+01,
     &3.7730E+03,2.8298E+03,1.8867E+03,9.4350E+02,1.3786E+01,
     &4.9942E+03,3.7457E+03,2.4973E+03,1.2488E+03,1.3682E+01,
     &6.3607E+03,4.7706E+03,3.1805E+03,1.5904E+03,1.3533E+01,
     &7.8514E+03,5.8886E+03,3.9259E+03,1.9631E+03,1.3377E+01/
      DATA ((KB(JS,JT,17,15),JS=1,5),JT=1,5) /
     &2.3075E+03,1.7307E+03,1.1539E+03,5.7711E+02,1.6126E+01,
     &3.1956E+03,2.3967E+03,1.5979E+03,7.9911E+02,1.6029E+01,
     &4.2241E+03,3.1681E+03,2.1122E+03,1.0562E+03,1.5863E+01,
     &5.3821E+03,4.0366E+03,2.6912E+03,1.3457E+03,1.5685E+01,
     &6.6465E+03,4.9850E+03,3.3234E+03,1.6618E+03,1.5496E+01/
      DATA ((KB(JS,JT,18,15),JS=1,5),JT=1,5) /
     &2.0119E+03,1.5090E+03,1.0061E+03,5.0318E+02,1.8668E+01,
     &2.7815E+03,2.0862E+03,1.3909E+03,6.9557E+02,1.8505E+01,
     &3.6794E+03,2.7596E+03,1.8398E+03,9.2005E+02,1.8343E+01,
     &4.6884E+03,3.5164E+03,2.3443E+03,1.1723E+03,1.8140E+01,
     &5.7908E+03,4.3432E+03,2.8955E+03,1.4479E+03,1.7901E+01/
      DATA ((KB(JS,JT,19,15),JS=1,5),JT=1,5) /
     &1.7281E+03,1.2962E+03,8.6418E+02,4.3222E+02,2.1496E+01,
     &2.3903E+03,1.7928E+03,1.1953E+03,5.9777E+02,2.1311E+01,
     &3.1615E+03,2.3712E+03,1.5809E+03,7.9055E+02,2.1106E+01,
     &4.0222E+03,3.0167E+03,2.0112E+03,1.0057E+03,2.0849E+01,
     &4.9621E+03,3.7216E+03,2.4811E+03,1.2407E+03,2.0531E+01/
      DATA ((KB(JS,JT,20,15),JS=1,5),JT=1,5) /
     &1.6235E+03,1.2177E+03,8.1188E+02,4.0606E+02,2.4735E+01,
     &2.2387E+03,1.6791E+03,1.1195E+03,5.5984E+02,2.4475E+01,
     &2.9488E+03,2.2116E+03,1.4745E+03,7.3737E+02,2.4178E+01,
     &3.7459E+03,2.8095E+03,1.8731E+03,9.3665E+02,2.3818E+01,
     &4.6161E+03,3.4621E+03,2.3081E+03,1.1542E+03,2.3401E+01/
      DATA ((KB(JS,JT,21,15),JS=1,5),JT=1,5) /
     &1.5705E+03,1.1779E+03,7.8536E+02,3.9279E+02,2.8368E+01,
     &2.1555E+03,1.6166E+03,1.0778E+03,5.3903E+02,2.7972E+01,
     &2.8340E+03,2.1256E+03,1.4171E+03,7.0866E+02,2.7543E+01,
     &3.5949E+03,2.6962E+03,1.7975E+03,8.9888E+02,2.7047E+01,
     &4.4249E+03,3.3187E+03,2.2126E+03,1.1064E+03,2.6508E+01/
      DATA ((KB(JS,JT,22,15),JS=1,5),JT=1,5) /
     &1.5869E+03,1.1902E+03,7.9356E+02,3.9688E+02,3.2318E+01,
     &2.1673E+03,1.6255E+03,1.0838E+03,5.4198E+02,3.1767E+01,
     &2.8378E+03,2.1284E+03,1.4190E+03,7.0961E+02,3.1126E+01,
     &3.5877E+03,2.6908E+03,1.7940E+03,8.9709E+02,3.0424E+01,
     &4.4005E+03,3.3004E+03,2.2004E+03,1.1003E+03,2.9694E+01/
      DATA ((KB(JS,JT,23,15),JS=1,5),JT=1,5) /
     &1.6232E+03,1.2174E+03,8.1169E+02,4.0594E+02,3.6426E+01,
     &2.2045E+03,1.6534E+03,1.1023E+03,5.5127E+02,3.5632E+01,
     &2.8697E+03,2.1523E+03,1.4350E+03,7.1760E+02,3.4766E+01,
     &3.6072E+03,2.7054E+03,1.8037E+03,9.0197E+02,3.3867E+01,
     &4.4070E+03,3.3053E+03,2.2036E+03,1.1019E+03,3.2942E+01/
      DATA ((KB(JS,JT,24,15),JS=1,5),JT=1,5) /
     &1.6638E+03,1.2479E+03,8.3204E+02,4.1615E+02,4.0555E+01,
     &2.2399E+03,1.6800E+03,1.1201E+03,5.6017E+02,3.9512E+01,
     &2.8950E+03,2.1713E+03,1.4476E+03,7.2392E+02,3.8430E+01,
     &3.6214E+03,2.7161E+03,1.8108E+03,9.0552E+02,3.7312E+01,
     &4.4048E+03,3.3036E+03,2.2025E+03,1.1014E+03,3.6172E+01/
      DATA ((KB(JS,JT,25,15),JS=1,5),JT=1,5) /
     &1.7332E+03,1.2999E+03,8.6673E+02,4.3352E+02,4.4719E+01,
     &2.3131E+03,1.7349E+03,1.1567E+03,5.7851E+02,4.3381E+01,
     &2.9711E+03,2.2284E+03,1.4857E+03,7.4302E+02,4.2032E+01,
     &3.6954E+03,2.7716E+03,1.8478E+03,9.2407E+02,4.0668E+01,
     &4.4711E+03,3.3534E+03,2.2357E+03,1.1180E+03,3.9312E+01/
      DATA ((KB(JS,JT,26,15),JS=1,5),JT=1,5) /
     &1.8457E+03,1.3843E+03,9.2300E+02,4.6166E+02,4.8798E+01,
     &2.4421E+03,1.8317E+03,1.2212E+03,6.1078E+02,4.7150E+01,
     &3.1127E+03,2.3346E+03,1.5565E+03,7.7843E+02,4.5507E+01,
     &3.8432E+03,2.8825E+03,1.9217E+03,9.6104E+02,4.3884E+01,
     &4.6197E+03,3.4648E+03,2.3100E+03,1.1552E+03,4.2296E+01/
      DATA ((KB(JS,JT,27,15),JS=1,5),JT=1,5) /
     &2.0401E+03,1.5302E+03,1.0202E+03,5.1030E+02,5.2748E+01,
     &2.6727E+03,2.0046E+03,1.3365E+03,6.6845E+02,5.0763E+01,
     &3.3765E+03,2.5325E+03,1.6885E+03,8.4441E+02,4.8815E+01,
     &4.1373E+03,3.1031E+03,2.0688E+03,1.0346E+03,4.6912E+01,
     &4.9426E+03,3.7071E+03,2.4715E+03,1.2359E+03,4.5084E+01/
      DATA ((KB(JS,JT,28,15),JS=1,5),JT=1,5) /
     &2.3062E+03,1.7297E+03,1.1533E+03,5.7684E+02,5.6494E+01,
     &2.9911E+03,2.2434E+03,1.4957E+03,7.4806E+02,5.4164E+01,
     &3.7467E+03,2.8101E+03,1.8736E+03,9.3698E+02,5.1914E+01,
     &4.5581E+03,3.4187E+03,2.2792E+03,1.1398E+03,4.9734E+01,
     &5.4121E+03,4.0592E+03,2.7063E+03,1.3533E+03,4.7639E+01/
      DATA ((KB(JS,JT,29,15),JS=1,5),JT=1,5) /
     &2.7587E+03,2.0691E+03,1.3796E+03,6.8998E+02,5.9883E+01,
     &3.5427E+03,2.6571E+03,1.7716E+03,8.8598E+02,5.7214E+01,
     &4.3997E+03,3.2998E+03,2.2000E+03,1.1002E+03,5.4658E+01,
     &5.3158E+03,3.9869E+03,2.6581E+03,1.3292E+03,5.2215E+01,
     &6.2710E+03,4.7033E+03,3.1357E+03,1.5680E+03,4.9872E+01/
      DATA ((KB(JS,JT,30,15),JS=1,5),JT=1,5) /
     &3.3645E+03,2.5235E+03,1.6825E+03,8.4145E+02,6.2847E+01,
     &4.2782E+03,3.2088E+03,2.1393E+03,1.0699E+03,5.9850E+01,
     &5.2706E+03,3.9531E+03,2.6355E+03,1.3180E+03,5.7012E+01,
     &6.3236E+03,4.7428E+03,3.1620E+03,1.5812E+03,5.4322E+01,
     &7.4122E+03,5.5592E+03,3.7063E+03,1.8534E+03,5.1754E+01/
      DATA ((KB(JS,JT,31,15),JS=1,5),JT=1,5) /
     &4.2971E+03,3.2230E+03,2.1488E+03,1.0746E+03,6.5331E+01,
     &5.4121E+03,4.0592E+03,2.7063E+03,1.3534E+03,6.2034E+01,
     &6.6141E+03,4.9607E+03,3.3073E+03,1.6539E+03,5.8947E+01,
     &7.8758E+03,5.9069E+03,3.9381E+03,1.9693E+03,5.6027E+01,
     &9.1717E+03,6.8788E+03,4.5860E+03,2.2932E+03,5.3266E+01/
      DATA ((KB(JS,JT,32,15),JS=1,5),JT=1,5) /
     &5.5229E+03,4.1423E+03,2.7617E+03,1.3811E+03,6.7311E+01,
     &6.8909E+03,5.1683E+03,3.4457E+03,1.7231E+03,6.3759E+01,
     &8.3530E+03,6.2649E+03,4.1768E+03,2.0886E+03,6.0452E+01,
     &9.8746E+03,7.4061E+03,4.9375E+03,2.4690E+03,5.7340E+01,
     &1.1429E+04,8.5717E+03,5.7146E+03,2.8575E+03,5.4420E+01/
      DATA ((KB(JS,JT,33,15),JS=1,5),JT=1,5) /
     &7.1868E+03,5.3902E+03,3.5936E+03,1.7971E+03,6.8810E+01,
     &8.8853E+03,6.6641E+03,4.4429E+03,2.2217E+03,6.5053E+01,
     &1.0684E+04,8.0128E+03,5.3420E+03,2.6713E+03,6.1559E+01,
     &1.2545E+04,9.4087E+03,6.2726E+03,3.1365E+03,5.8295E+01,
     &1.4437E+04,1.0828E+04,7.2187E+03,3.6096E+03,5.5243E+01/
      DATA ((KB(JS,JT,34,15),JS=1,5),JT=1,5) /
     &8.9946E+03,6.7461E+03,4.4975E+03,2.2490E+03,7.0022E+01,
     &1.1036E+04,8.2772E+03,5.5183E+03,2.7594E+03,6.6087E+01,
     &1.3184E+04,9.8877E+03,6.5920E+03,3.2962E+03,6.2443E+01,
     &1.5394E+04,1.1546E+04,7.6972E+03,3.8488E+03,5.9052E+01,
     &1.7632E+04,1.3224E+04,8.8161E+03,4.4083E+03,5.5884E+01/
      DATA ((KB(JS,JT,35,15),JS=1,5),JT=1,5) /
     &1.0993E+04,8.2446E+03,5.4966E+03,2.7485E+03,7.1272E+01,
     &1.3428E+04,1.0071E+04,6.7141E+03,3.3573E+03,6.7165E+01,
     &1.5977E+04,1.1983E+04,7.9889E+03,3.9949E+03,6.3376E+01,
     &1.8595E+04,1.3946E+04,9.2975E+03,4.6490E+03,5.9869E+01,
     &2.1231E+04,1.5923E+04,1.0616E+04,5.3081E+03,5.6025E+01/
      DATA ((KB(JS,JT,36,15),JS=1,5),JT=1,5) /
     &1.3006E+04,9.7547E+03,6.5033E+03,3.2519E+03,7.2705E+01,
     &1.5874E+04,1.1905E+04,7.9370E+03,3.9687E+03,6.8413E+01,
     &1.8861E+04,1.4146E+04,9.4305E+03,4.7155E+03,6.4479E+01,
     &2.1927E+04,1.6445E+04,1.0964E+04,5.4821E+03,6.0843E+01,
     &2.5014E+04,1.8760E+04,1.2507E+04,6.2537E+03,5.6544E+01/
      DATA ((KB(JS,JT,37,15),JS=1,5),JT=1,5) /
     &1.4489E+04,1.0867E+04,7.2447E+03,3.6226E+03,7.4617E+01,
     &1.7744E+04,1.3308E+04,8.8720E+03,4.4362E+03,7.0104E+01,
     &2.1142E+04,1.5857E+04,1.0571E+04,5.2858E+03,6.5985E+01,
     &2.4633E+04,1.8475E+04,1.2317E+04,6.1586E+03,6.1723E+01,
     &2.8152E+04,2.1114E+04,1.4076E+04,7.0383E+03,5.7616E+01/
      DATA ((KB(JS,JT,38,15),JS=1,5),JT=1,5) /
     &1.6314E+04,1.2236E+04,8.1572E+03,4.0788E+03,7.6413E+01,
     &2.0055E+04,1.5041E+04,1.0028E+04,5.0140E+03,7.1696E+01,
     &2.3973E+04,1.7980E+04,1.1987E+04,5.9936E+03,6.7406E+01,
     &2.8001E+04,2.1001E+04,1.4001E+04,7.0006E+03,6.2768E+01,
     &3.2071E+04,2.4053E+04,1.6036E+04,8.0180E+03,5.8602E+01/
      DATA ((KB(JS,JT,39,15),JS=1,5),JT=1,5) /
     &1.8759E+04,1.4069E+04,9.3797E+03,4.6901E+03,7.8086E+01,
     &2.3153E+04,1.7365E+04,1.1577E+04,5.7886E+03,7.3162E+01,
     &2.7770E+04,2.0828E+04,1.3886E+04,6.9431E+03,6.8719E+01,
     &3.2517E+04,2.4388E+04,1.6259E+04,8.1299E+03,6.3661E+01,
     &3.7323E+04,2.7992E+04,1.8662E+04,9.3312E+03,5.9468E+01/
      DATA ((KB(JS,JT,40,15),JS=1,5),JT=1,5) /
     &1.9750E+04,1.4812E+04,9.8751E+03,4.9378E+03,8.0192E+01,
     &2.4562E+04,1.8422E+04,1.2281E+04,6.1409E+03,7.5032E+01,
     &2.9646E+04,2.2235E+04,1.4823E+04,7.4118E+03,7.0393E+01,
     &3.4890E+04,2.6167E+04,1.7445E+04,8.7227E+03,6.5151E+01,
     &4.0218E+04,3.0164E+04,2.0109E+04,1.0055E+04,6.0809E+01/
      DATA ((KB(JS,JT,41,15),JS=1,5),JT=1,5) /
     &2.0620E+04,1.5465E+04,1.0310E+04,5.1555E+03,8.2333E+01,
     &2.5862E+04,1.9396E+04,1.2931E+04,6.4659E+03,7.6930E+01,
     &3.1429E+04,2.3571E+04,1.5714E+04,7.8575E+03,7.2080E+01,
     &3.7207E+04,2.7905E+04,1.8604E+04,9.3022E+03,6.6689E+01,
     &4.3090E+04,3.2318E+04,2.1545E+04,1.0773E+04,6.2194E+01/
      DATA ((KB(JS,JT,42,15),JS=1,5),JT=1,5) /
     &2.1691E+04,1.6268E+04,1.0846E+04,5.4231E+03,8.4448E+01,
     &2.7444E+04,2.0583E+04,1.3722E+04,6.8623E+03,7.8791E+01,
     &3.3603E+04,2.5202E+04,1.6802E+04,8.4010E+03,7.3737E+01,
     &4.0024E+04,3.0018E+04,2.0012E+04,1.0006E+04,6.8167E+01,
     &4.6588E+04,3.4941E+04,2.3294E+04,1.1647E+04,6.3488E+01/
      DATA ((KB(JS,JT,43,15),JS=1,5),JT=1,5) /
     &2.2603E+04,1.6952E+04,1.1302E+04,5.6511E+03,8.6896E+01,
     &2.8935E+04,2.1702E+04,1.4468E+04,7.2343E+03,8.0969E+01,
     &3.5766E+04,2.6825E+04,1.7883E+04,8.9419E+03,7.5666E+01,
     &4.2940E+04,3.2205E+04,2.1471E+04,1.0736E+04,6.9870E+01,
     &5.0307E+04,3.7731E+04,2.5154E+04,1.2577E+04,6.5095E+01/
      DATA ((KB(JS,JT,44,15),JS=1,5),JT=1,5) /
     &2.3606E+04,1.7705E+04,1.1803E+04,5.9018E+03,8.9540E+01,
     &3.0627E+04,2.2970E+04,1.5314E+04,7.6570E+03,8.3300E+01,
     &3.8272E+04,2.8704E+04,1.9136E+04,9.5682E+03,7.7742E+01,
     &4.6369E+04,3.4777E+04,2.3185E+04,1.1593E+04,7.1787E+01,
     &5.4746E+04,4.1060E+04,2.7373E+04,1.3687E+04,6.6743E+01/
      DATA ((KB(JS,JT,45,15),JS=1,5),JT=1,5) /
     &2.5020E+04,1.8765E+04,1.2510E+04,6.2554E+03,9.2249E+01,
     &3.2921E+04,2.4691E+04,1.6461E+04,8.2305E+03,8.5687E+01,
     &4.1630E+04,3.1222E+04,2.0815E+04,1.0408E+04,7.9854E+01,
     &5.0934E+04,3.8200E+04,2.5467E+04,1.2734E+04,7.3688E+01,
     &6.0623E+04,4.5467E+04,3.0312E+04,1.5156E+04,6.8450E+01/
      DATA ((KB(JS,JT,46,15),JS=1,5),JT=1,5) /
     &2.6462E+04,1.9847E+04,1.3231E+04,6.6159E+03,9.5173E+01,
     &3.5388E+04,2.6541E+04,1.7694E+04,8.8474E+03,8.8256E+01,
     &4.5343E+04,3.4008E+04,2.2672E+04,1.1336E+04,8.2143E+01,
     &5.6094E+04,4.2071E+04,2.8047E+04,1.4024E+04,7.5728E+01,
     &6.7389E+04,5.0542E+04,3.3695E+04,1.6848E+04,7.0196E+01/
      DATA ((KB(JS,JT,47,15),JS=1,5),JT=1,5) /
     &2.7156E+04,2.0367E+04,1.3578E+04,6.7894E+03,9.8564E+01,
     &3.7028E+04,2.7771E+04,1.8514E+04,9.2574E+03,9.1210E+01,
     &4.8225E+04,3.6169E+04,2.4113E+04,1.2057E+04,8.4753E+01,
     &6.0453E+04,4.5340E+04,3.0227E+04,1.5114E+04,7.8168E+01,
     &7.3441E+04,5.5081E+04,3.6721E+04,1.8361E+04,7.1964E+01/
      DATA ((KB(JS,JT,48,15),JS=1,5),JT=1,5) /
     &2.8408E+04,2.1306E+04,1.4204E+04,7.1024E+03,1.0210E+02,
     &3.9561E+04,2.9671E+04,1.9781E+04,9.8907E+03,9.4282E+01,
     &5.2433E+04,3.9325E+04,2.6217E+04,1.3109E+04,8.7454E+01,
     &6.6685E+04,5.0014E+04,3.3343E+04,1.6672E+04,8.0648E+01,
     &8.1969E+04,6.1477E+04,4.0985E+04,2.0493E+04,7.3773E+01/
      DATA ((KB(JS,JT,49,15),JS=1,5),JT=1,5) /
     &3.0665E+04,2.2999E+04,1.5333E+04,7.6665E+03,1.0579E+02,
     &4.3701E+04,3.2776E+04,2.1851E+04,1.0926E+04,9.7512E+01,
     &5.9013E+04,4.4260E+04,2.9506E+04,1.4753E+04,9.0273E+01,
     &7.6235E+04,5.7177E+04,3.8118E+04,1.9059E+04,8.3012E+01,
     &9.4928E+04,7.1196E+04,4.7464E+04,2.3732E+04,7.5643E+01/
      DATA ((KB(JS,JT,50,15),JS=1,5),JT=1,5) /
     &3.1512E+04,2.3634E+04,1.5756E+04,7.8783E+03,1.0944E+02,
     &4.5989E+04,3.4492E+04,2.2995E+04,1.1498E+04,1.0069E+02,
     &6.3288E+04,4.7466E+04,3.1644E+04,1.5822E+04,9.3050E+01,
     &8.3061E+04,6.2296E+04,4.1531E+04,2.0766E+04,8.5379E+01,
     &1.0477E+05,7.8579E+04,5.2386E+04,2.6193E+04,7.7745E+01/
      DATA ((KB(JS,JT,51,15),JS=1,5),JT=1,5) /
     &3.1512E+04,2.3634E+04,1.5756E+04,7.8783E+03,1.1317E+02,
     &4.7162E+04,3.5373E+04,2.3581E+04,1.1791E+04,1.0391E+02,
     &6.6209E+04,4.9657E+04,3.3105E+04,1.6553E+04,9.5852E+01,
     &8.8316E+04,6.6238E+04,4.4164E+04,2.2080E+04,8.8232E+01,
     &1.1292E+05,8.4693E+04,5.6462E+04,2.8231E+04,8.0003E+01/
      DATA ((KB(JS,JT,52,15),JS=1,5),JT=1,5) /
     &3.2076E+04,2.4057E+04,1.6038E+04,8.0198E+03,1.1706E+02,
     &4.9342E+04,3.7006E+04,2.4671E+04,1.2336E+04,1.0727E+02,
     &7.0777E+04,5.3083E+04,3.5389E+04,1.7695E+04,9.8793E+01,
     &9.6072E+04,7.2054E+04,4.8037E+04,2.4019E+04,9.0662E+01,
     &1.2464E+05,9.3484E+04,6.2323E+04,3.1162E+04,8.2138E+01/
      DATA ((KB(JS,JT,53,15),JS=1,5),JT=1,5) /
     &3.3608E+04,2.5207E+04,1.6805E+04,8.4025E+03,1.2114E+02,
     &5.3290E+04,3.9968E+04,2.6645E+04,1.3323E+04,1.1081E+02,
     &7.8269E+04,5.8702E+04,3.9135E+04,1.9568E+04,1.0185E+02,
     &1.0824E+05,8.1183E+04,5.4123E+04,2.7062E+04,9.3093E+01,
     &1.4266E+05,1.0700E+05,7.1333E+04,3.5667E+04,8.4356E+01/
      DATA ((KB(JS,JT,54,15),JS=1,5),JT=1,5) /
     &3.0554E+04,2.2916E+04,1.5277E+04,7.6389E+03,1.2510E+02,
     &4.9936E+04,3.7452E+04,2.4968E+04,1.2484E+04,1.1423E+02,
     &7.5079E+04,5.6309E+04,3.7540E+04,1.8770E+04,1.0480E+02,
     &1.0578E+05,7.9333E+04,5.2889E+04,2.6445E+04,9.5981E+01,
     &1.4151E+05,1.0613E+05,7.0756E+04,3.5378E+04,8.6958E+01/
      DATA ((KB(JS,JT,55,15),JS=1,5),JT=1,5) /
     &2.5242E+04,1.8932E+04,1.2621E+04,6.3108E+03,1.2910E+02,
     &4.2561E+04,3.1921E+04,2.1281E+04,1.0641E+04,1.1763E+02,
     &6.5579E+04,4.9184E+04,3.2790E+04,1.6395E+04,1.0775E+02,
     &9.4190E+04,7.0643E+04,4.7095E+04,2.3548E+04,9.9196E+01,
     &1.2798E+05,9.5983E+04,6.3989E+04,3.1995E+04,9.0570E+01/
      DATA ((KB(JS,JT,56,15),JS=1,5),JT=1,5) /
     &2.0611E+04,1.5459E+04,1.0306E+04,5.1530E+03,1.3327E+02,
     &3.5961E+04,2.6970E+04,1.7980E+04,8.9902E+03,1.2118E+02,
     &5.6902E+04,4.2676E+04,2.8451E+04,1.4227E+04,1.1083E+02,
     &8.3426E+04,6.2569E+04,4.1713E+04,2.0856E+04,1.0187E+02,
     &1.1523E+05,8.6424E+04,5.7616E+04,2.8808E+04,9.3771E+01/
      DATA ((KB(JS,JT,57,15),JS=1,5),JT=1,5) /
     &1.6610E+04,1.2457E+04,8.3049E+03,4.1526E+03,1.3769E+02,
     &3.0089E+04,2.2567E+04,1.5044E+04,7.5226E+03,1.2490E+02,
     &4.8979E+04,3.6734E+04,2.4489E+04,1.2245E+04,1.1405E+02,
     &7.3462E+04,5.5096E+04,3.6731E+04,1.8365E+04,1.0465E+02,
     &1.0326E+05,7.7443E+04,5.1628E+04,2.5814E+04,9.6480E+01/
      DATA ((KB(JS,JT,58,15),JS=1,5),JT=1,5) /
     &3.5201E+03,3.2274E+03,2.7672E+03,1.9382E+03,1.4211E+02,
     &6.6315E+03,6.0801E+03,5.2132E+03,3.6514E+03,1.2863E+02,
     &1.1117E+04,1.0193E+04,8.7395E+03,6.1212E+03,1.1722E+02,
     &1.7057E+04,1.5638E+04,1.3409E+04,9.3914E+03,1.0740E+02,
     &2.4410E+04,2.2380E+04,1.9189E+04,1.3440E+04,9.8884E+01/
      DATA ((KB(JS,JT,59,15),JS=1,5),JT=1,5) /
     &3.7699E+03,3.2918E+03,2.6257E+03,1.6340E+03,1.4398E+02,
     &7.2215E+03,6.3055E+03,5.0297E+03,3.1299E+03,1.3019E+02,
     &1.2258E+04,1.0703E+04,8.5377E+03,5.3128E+03,1.1856E+02,
     &1.8986E+04,1.6578E+04,1.3224E+04,8.2288E+03,1.0855E+02,
     &2.7379E+04,2.3906E+04,1.9069E+04,1.1866E+04,9.9884E+01/
      DATA ((KB(JS,JT,13,16),JS=1,5),JT=1,5) /
     &1.4818E+04,1.1113E+04,7.4089E+03,3.7045E+03,1.1371E+01,
     &2.0739E+04,1.5555E+04,1.0370E+04,5.1851E+03,1.0985E+01,
     &2.7562E+04,2.0672E+04,1.3781E+04,6.8906E+03,1.0720E+01,
     &3.5104E+04,2.6328E+04,1.7552E+04,8.7760E+03,1.0594E+01,
     &4.3187E+04,3.2390E+04,2.1594E+04,1.0797E+04,1.0676E+01/
      DATA ((KB(JS,JT,14,16),JS=1,5),JT=1,5) /
     &1.1265E+04,8.4488E+03,5.6325E+03,2.8163E+03,1.3004E+01,
     &1.5638E+04,1.1729E+04,7.8191E+03,3.9096E+03,1.2745E+01,
     &2.0632E+04,1.5474E+04,1.0316E+04,5.1580E+03,1.2511E+01,
     &2.6158E+04,1.9619E+04,1.3079E+04,6.5395E+03,1.2514E+01,
     &3.2161E+04,2.4120E+04,1.6080E+04,8.0400E+03,1.2574E+01/
      DATA ((KB(JS,JT,15,16),JS=1,5),JT=1,5) /
     &8.6626E+03,6.4970E+03,4.3314E+03,2.1657E+03,1.5047E+01,
     &1.1944E+04,8.8995E+03,5.9720E+03,2.9860E+03,1.4804E+01,
     &1.5730E+04,1.1798E+04,7.8651E+03,3.9326E+03,1.4621E+01,
     &1.9953E+04,1.4965E+04,9.9768E+03,4.9885E+03,1.4704E+01,
     &2.4510E+04,1.8382E+04,1.2255E+04,6.1276E+03,1.4738E+01/
      DATA ((KB(JS,JT,16,16),JS=1,5),JT=1,5) /
     &7.9177E+03,5.9383E+03,3.9589E+03,1.9795E+03,1.7379E+01,
     &1.0905E+04,8.1790E+03,5.4527E+03,2.7264E+03,1.7087E+01,
     &1.4336E+04,1.0752E+04,7.1680E+03,3.5840E+03,1.7079E+01,
     &1.8134E+04,1.3600E+04,9.0670E+03,4.5335E+03,1.7162E+01,
     &2.2206E+04,1.6655E+04,1.1103E+04,5.5517E+03,1.7193E+01/
      DATA ((KB(JS,JT,17,16),JS=1,5),JT=1,5) /
     &7.5178E+03,5.6384E+03,3.7589E+03,1.8795E+03,1.9948E+01,
     &1.0311E+04,7.7335E+03,5.1557E+03,2.5779E+03,1.9796E+01,
     &1.3498E+04,1.0124E+04,6.7488E+03,3.3746E+03,1.9858E+01,
     &1.6996E+04,1.2747E+04,8.4978E+03,4.2489E+03,1.9944E+01,
     &2.0726E+04,1.5544E+04,1.0363E+04,5.1815E+03,1.9956E+01/
      DATA ((KB(JS,JT,18,16),JS=1,5),JT=1,5) /
     &7.2889E+03,5.4667E+03,3.6445E+03,1.8223E+03,2.3259E+01,
     &9.9353E+03,7.4515E+03,4.9677E+03,2.4839E+03,2.3214E+01,
     &1.2928E+04,9.6956E+03,6.4638E+03,3.2319E+03,2.3116E+01,
     &1.6189E+04,1.2142E+04,8.0944E+03,4.0472E+03,2.3106E+01,
     &1.9640E+04,1.4730E+04,9.8201E+03,4.9101E+03,2.3045E+01/
      DATA ((KB(JS,JT,19,16),JS=1,5),JT=1,5) /
     &6.8892E+03,5.1669E+03,3.4446E+03,1.7223E+03,2.7312E+01,
     &9.3210E+03,6.9908E+03,4.6605E+03,2.3303E+03,2.7199E+01,
     &1.2050E+04,9.0375E+03,6.0250E+03,3.0125E+03,2.6980E+01,
     &1.5046E+04,1.1284E+04,7.5228E+03,3.7614E+03,2.6786E+01,
     &1.8241E+04,1.3681E+04,9.1205E+03,4.5603E+03,2.6595E+01/
      DATA ((KB(JS,JT,20,16),JS=1,5),JT=1,5) /
     &7.0094E+03,5.2570E+03,3.5047E+03,1.7524E+03,3.2009E+01,
     &9.4364E+03,7.0773E+03,4.7182E+03,2.3591E+03,3.1788E+01,
     &1.2173E+04,9.1297E+03,6.0865E+03,3.0433E+03,3.1450E+01,
     &1.5155E+04,1.1367E+04,7.5778E+03,3.7889E+03,3.1059E+01,
     &1.8307E+04,1.3730E+04,9.1534E+03,4.5767E+03,3.0674E+01/
      DATA ((KB(JS,JT,21,16),JS=1,5),JT=1,5) /
     &7.3306E+03,5.4980E+03,3.6654E+03,1.8327E+03,3.7355E+01,
     &9.8238E+03,7.3679E+03,4.9119E+03,2.4560E+03,3.6998E+01,
     &1.2609E+04,9.4571E+03,6.3047E+03,3.1524E+03,3.6493E+01,
     &1.5617E+04,1.1713E+04,7.8084E+03,3.9042E+03,3.5962E+01,
     &1.8773E+04,1.4079E+04,9.3863E+03,4.6932E+03,3.5346E+01/
      DATA ((KB(JS,JT,22,16),JS=1,5),JT=1,5) /
     &7.9668E+03,5.9751E+03,3.9834E+03,1.9917E+03,4.3325E+01,
     &1.0571E+04,7.9286E+03,5.2858E+03,2.6429E+03,4.2793E+01,
     &1.3449E+04,1.0087E+04,6.7244E+03,3.3622E+03,4.2221E+01,
     &1.6524E+04,1.2393E+04,8.2619E+03,4.1310E+03,4.1607E+01,
     &1.9754E+04,1.4816E+04,9.8771E+03,4.9386E+03,4.0888E+01/
      DATA ((KB(JS,JT,23,16),JS=1,5),JT=1,5) /
     &8.6210E+03,6.4658E+03,4.3105E+03,2.1553E+03,5.0428E+01,
     &1.1316E+04,8.4866E+03,5.6578E+03,2.8289E+03,4.9764E+01,
     &1.4291E+04,1.0718E+04,7.1454E+03,3.5727E+03,4.9049E+01,
     &1.7469E+04,1.3102E+04,8.7344E+03,4.3672E+03,4.8146E+01,
     &2.0774E+04,1.5580E+04,1.0387E+04,5.1935E+03,4.7113E+01/
      DATA ((KB(JS,JT,24,16),JS=1,5),JT=1,5) /
     &9.2015E+03,6.9011E+03,4.6008E+03,2.3004E+03,5.8527E+01,
     &1.1985E+04,8.9232E+03,5.9928E+03,2.9964E+03,5.7489E+01,
     &1.5026E+04,1.1269E+04,7.5129E+03,3.7565E+03,5.6333E+01,
     &1.8238E+04,1.3679E+04,9.1191E+03,4.5596E+03,5.5030E+01,
     &2.1539E+04,1.6154E+04,1.0769E+04,5.3848E+03,5.3599E+01/
      DATA ((KB(JS,JT,25,16),JS=1,5),JT=1,5) /
     &9.9033E+03,7.4275E+03,4.9517E+03,2.4759E+03,6.7091E+01,
     &1.2768E+04,9.5762E+03,6.3841E+03,3.1921E+03,6.5542E+01,
     &1.5871E+04,1.1903E+04,7.9355E+03,3.9678E+03,6.3831E+01,
     &1.9110E+04,1.4333E+04,9.5551E+03,4.7776E+03,6.2029E+01,
     &2.2417E+04,1.6813E+04,1.1208E+04,5.6043E+03,6.0136E+01/
      DATA ((KB(JS,JT,26,16),JS=1,5),JT=1,5) /
     &1.0777E+04,8.0825E+03,5.3884E+03,2.6942E+03,7.5807E+01,
     &1.3749E+04,1.0312E+04,6.8746E+03,3.4373E+03,7.3586E+01,
     &1.6921E+04,1.2690E+04,8.4603E+03,4.2302E+03,7.1246E+01,
     &2.0227E+04,1.5170E+04,1.0114E+04,5.0568E+03,6.8870E+01,
     &2.3585E+04,1.7688E+04,1.1792E+04,5.8962E+03,6.6424E+01/
      DATA ((KB(JS,JT,27,16),JS=1,5),JT=1,5) /
     &1.2052E+04,9.0388E+03,6.0259E+03,3.0130E+03,8.4316E+01,
     &1.5222E+04,1.1417E+04,7.6111E+03,3.8056E+03,8.1386E+01,
     &1.8590E+04,1.3942E+04,9.2948E+03,4.6474E+03,7.8348E+01,
     &2.2058E+04,1.6543E+04,1.1029E+04,5.5145E+03,7.5340E+01,
     &2.5550E+04,1.9162E+04,1.2775E+04,6.3875E+03,7.2329E+01/
      DATA ((KB(JS,JT,28,16),JS=1,5),JT=1,5) /
     &1.3724E+04,1.0293E+04,6.8620E+03,3.4310E+03,9.2351E+01,
     &1.7171E+04,1.2878E+04,8.5855E+03,4.2928E+03,8.8670E+01,
     &2.0788E+04,1.5591E+04,1.0394E+04,5.1970E+03,8.4928E+01,
     &2.4487E+04,1.8365E+04,1.2244E+04,6.1218E+03,8.1255E+01,
     &2.8173E+04,2.1130E+04,1.4087E+04,7.0433E+03,7.7666E+01/
      DATA ((KB(JS,JT,29,16),JS=1,5),JT=1,5) /
     &1.6469E+04,1.2352E+04,8.2344E+03,4.1172E+03,9.9675E+01,
     &2.0402E+04,1.5302E+04,1.0201E+04,5.1006E+03,9.5182E+01,
     &2.4499E+04,1.8374E+04,1.2249E+04,6.1246E+03,9.0759E+01,
     &2.8632E+04,2.1474E+04,1.4316E+04,7.1579E+03,8.6444E+01,
     &3.2723E+04,2.4542E+04,1.6361E+04,8.1807E+03,8.2287E+01/
      DATA ((KB(JS,JT,30,16),JS=1,5),JT=1,5) /
     &2.0078E+04,1.5058E+04,1.0039E+04,5.0195E+03,1.0609E+02,
     &2.4638E+04,1.8479E+04,1.2319E+04,6.1595E+03,1.0084E+02,
     &2.9329E+04,2.1997E+04,1.4664E+04,7.3322E+03,9.5740E+01,
     &3.4034E+04,2.5525E+04,1.7017E+04,8.5085E+03,9.0849E+01,
     &3.8657E+04,2.8993E+04,1.9329E+04,9.6643E+03,8.6169E+01/
      DATA ((KB(JS,JT,31,16),JS=1,5),JT=1,5) /
     &2.5548E+04,1.9161E+04,1.2774E+04,6.3870E+03,1.1146E+02,
     &3.1052E+04,2.3289E+04,1.5526E+04,7.7630E+03,1.0555E+02,
     &3.6674E+04,2.7505E+04,1.8172E+04,9.1684E+03,9.9833E+01,
     &4.2278E+04,3.1708E+04,2.1139E+04,1.0569E+04,9.4413E+01,
     &4.7725E+04,3.5794E+04,2.3863E+04,1.1931E+04,8.9289E+01/
      DATA ((KB(JS,JT,32,16),JS=1,5),JT=1,5) /
     &3.2648E+04,2.4486E+04,1.6324E+04,8.1620E+03,1.1579E+02,
     &3.9333E+04,2.9500E+04,1.9666E+04,9.8333E+03,1.0928E+02,
     &4.6114E+04,3.4586E+04,2.3057E+04,1.1529E+04,1.0305E+02,
     &5.2809E+04,3.9607E+04,2.6404E+04,1.3202E+04,9.7184E+01,
     &5.9284E+04,4.4463E+04,2.9311E+04,1.4821E+04,9.1687E+01/
      DATA ((KB(JS,JT,33,16),JS=1,5),JT=1,5) /
     &4.2212E+04,3.1659E+04,2.1106E+04,1.0553E+04,1.1913E+02,
     &5.0427E+04,3.7820E+04,2.5214E+04,1.2607E+04,1.1210E+02,
     &5.8684E+04,4.4013E+04,2.9342E+04,1.4671E+04,1.0546E+02,
     &6.6793E+04,5.0095E+04,3.3396E+04,1.6698E+04,9.9210E+01,
     &7.4575E+04,5.5932E+04,3.7288E+04,1.8644E+04,9.3412E+01/
      DATA ((KB(JS,JT,34,16),JS=1,5),JT=1,5) /
     &5.2540E+04,3.9405E+04,2.6270E+04,1.3135E+04,1.2180E+02,
     &6.2330E+04,4.6748E+04,3.1165E+04,1.5582E+04,1.1436E+02,
     &7.2093E+04,5.4070E+04,3.6046E+04,1.8023E+04,1.0734E+02,
     &8.1593E+04,6.1194E+04,4.0796E+04,2.0398E+04,1.0080E+02,
     &9.0697E+04,6.8023E+04,4.5349E+04,2.2674E+04,9.4753E+01/
      DATA ((KB(JS,JT,35,16),JS=1,5),JT=1,5) /
     &6.4051E+04,4.8038E+04,3.2026E+04,1.6013E+04,1.2446E+02,
     &7.5644E+04,5.6733E+04,3.7822E+04,1.8911E+04,1.1662E+02,
     &8.7172E+04,6.5379E+04,4.3586E+04,2.1792E+04,1.0929E+02,
     &9.8380E+04,7.3786E+04,4.9191E+04,2.4595E+04,1.0249E+02,
     &1.0903E+05,8.1776E+04,5.4517E+04,2.7259E+04,9.6197E+01/
      DATA ((KB(JS,JT,36,16),JS=1,5),JT=1,5) /
     &7.5878E+04,5.6908E+04,3.7939E+04,1.8969E+04,1.2742E+02,
     &8.9471E+04,6.7103E+04,4.4735E+04,2.2368E+04,1.1920E+02,
     &1.0302E+05,7.7263E+04,5.1509E+04,2.5436E+04,1.1154E+02,
     &1.1614E+05,8.7108E+04,5.8072E+04,2.9036E+04,1.0445E+02,
     &1.2862E+05,9.6465E+04,6.4310E+04,3.2155E+04,9.7922E+01/
      DATA ((KB(JS,JT,37,16),JS=1,5),JT=1,5) /
     &8.5083E+04,6.3812E+04,4.2541E+04,2.1271E+04,1.3125E+02,
     &1.0058E+05,7.5436E+04,5.0291E+04,2.5145E+04,1.2185E+02,
     &1.1610E+05,8.7073E+04,5.8049E+04,2.9024E+04,1.1457E+02,
     &1.3117E+05,9.8374E+04,6.5582E+04,3.2791E+04,1.0715E+02,
     &1.4551E+05,1.0913E+05,7.2757E+04,3.6378E+04,1.0034E+02/
      DATA ((KB(JS,JT,38,16),JS=1,5),JT=1,5) /
     &9.5077E+04,7.2333E+04,4.8222E+04,2.4111E+04,1.3486E+02,
     &1.1439E+05,8.5793E+04,5.7195E+04,2.8598E+04,1.2580E+02,
     &1.3231E+05,9.9236E+04,6.6157E+04,3.3078E+04,1.1743E+02,
     &1.4989E+05,1.1242E+05,7.4945E+04,3.7472E+04,1.0969E+02,
     &1.6664E+05,1.2498E+05,8.3321E+04,4.1660E+04,1.0261E+02/
      DATA ((KB(JS,JT,39,16),JS=1,5),JT=1,5) /
     &1.1158E+05,8.3685E+04,5.5790E+04,2.7895E+04,1.3820E+02,
     &1.3280E+05,9.9602E+04,6.6401E+04,3.3201E+04,1.2875E+02,
     &1.5408E+05,1.1556E+05,7.7040E+04,3.8520E+04,1.2007E+02,
     &1.7495E+05,1.3121E+05,8.7476E+04,4.3738E+04,1.1204E+02,
     &1.9488E+05,1.4616E+05,9.7443E+04,4.8722E+04,1.0472E+02/
      DATA ((KB(JS,JT,40,16),JS=1,5),JT=1,5) /
     &1.1876E+05,8.9071E+04,5.9380E+04,2.9690E+04,1.4235E+02,
     &1.4221E+05,1.0666E+05,7.1106E+04,3.5553E+04,1.3244E+02,
     &1.6587E+05,1.2440E+05,8.2934E+04,4.1467E+04,1.2341E+02,
     &1.8920E+05,1.4190E+05,9.4601E+04,4.7300E+04,1.1506E+02,
     &2.1165E+05,1.5874E+05,1.0583E+05,5.2913E+04,1.0743E+02/
      DATA ((KB(JS,JT,41,16),JS=1,5),JT=1,5) /
     &1.2546E+05,9.4099E+04,6.2733E+04,3.1367E+04,1.4657E+02,
     &1.5125E+05,1.1344E+05,7.5625E+04,3.7812E+04,1.3531E+02,
     &1.7744E+05,1.3308E+05,8.8723E+04,4.4362E+04,1.2676E+02,
     &2.0341E+05,1.5256E+05,1.0171E+05,5.0854E+04,1.1810E+02,
     &2.2858E+05,1.7144E+05,1.1429E+05,5.7146E+04,1.1015E+02/
      DATA ((KB(JS,JT,42,16),JS=1,5),JT=1,5) /
     &1.3356E+05,1.0017E+05,6.6777E+04,3.3389E+04,1.5077E+02,
     &1.6221E+05,1.2166E+05,8.1105E+04,4.0545E+04,1.3986E+02,
     &1.9146E+05,1.4359E+05,9.5729E+04,4.7864E+04,1.3005E+02,
     &2.1781E+05,1.6546E+05,1.1031E+05,5.5153E+04,1.2109E+02,
     &2.4912E+05,1.8684E+05,1.2456E+05,6.2279E+04,1.1284E+02/
      DATA ((KB(JS,JT,43,16),JS=1,5),JT=1,5) /
     &1.4126E+05,1.0594E+05,7.0630E+04,3.5315E+04,1.5567E+02,
     &1.7322E+05,1.2992E+05,8.6612E+04,4.3306E+04,1.4408E+02,
     &2.0611E+05,1.5458E+05,1.0200E+05,5.1528E+04,1.3385E+02,
     &2.3919E+05,1.7940E+05,1.1960E+05,5.9799E+04,1.2454E+02,
     &2.7160E+05,2.0370E+05,1.3580E+05,6.7900E+04,1.1596E+02/
      DATA ((KB(JS,JT,44,16),JS=1,5),JT=1,5) /
     &1.5000E+05,1.1250E+05,7.5001E+04,3.7500E+04,1.6094E+02,
     &1.8602E+05,1.3952E+05,9.3011E+04,4.6505E+04,1.4866E+02,
     &2.2342E+05,1.6756E+05,1.1171E+05,5.5854E+04,1.3792E+02,
     &2.6122E+05,1.9592E+05,1.3061E+05,6.5304E+04,1.2823E+02,
     &2.9874E+05,2.2406E+05,1.4937E+05,7.4685E+04,1.1932E+02/
      DATA ((KB(JS,JT,45,16),JS=1,5),JT=1,5) /
     &1.6171E+05,1.2128E+05,8.0854E+04,4.0427E+04,1.6635E+02,
     &2.0304E+05,1.5228E+05,1.0152E+05,5.0760E+04,1.5336E+02,
     &2.4630E+05,1.8473E+05,1.2315E+05,6.1576E+04,1.4204E+02,
     &2.9041E+05,2.1781E+05,1.4520E+05,7.2602E+04,1.3193E+02,
     &3.3433E+05,2.5074E+05,1.6716E+05,8.3581E+04,1.2271E+02/
      DATA ((KB(JS,JT,46,16),JS=1,5),JT=1,5) /
     &1.7432E+05,1.3074E+05,8.7162E+04,4.3581E+04,1.7227E+02,
     &2.2186E+05,1.6640E+05,1.1093E+05,5.5465E+04,1.5849E+02,
     &2.7221E+05,2.0416E+05,1.3611E+05,6.8053E+04,1.4648E+02,
     &3.2411E+05,2.4308E+05,1.6205E+05,8.1026E+04,1.3593E+02,
     &3.7610E+05,2.8208E+05,1.8805E+05,9.4025E+04,1.2634E+02/
      DATA ((KB(JS,JT,47,16),JS=1,5),JT=1,5) /
     &1.8289E+05,1.3717E+05,9.1447E+04,4.5723E+04,1.7909E+02,
     &2.3679E+05,1.7759E+05,1.1839E+05,5.9198E+04,1.6436E+02,
     &2.9447E+05,2.2085E+05,1.4724E+05,7.3618E+04,1.5159E+02,
     &3.5454E+05,2.6590E+05,1.7727E+05,8.8635E+04,1.4045E+02,
     &4.1548E+05,3.1161E+05,2.0774E+05,1.0387E+05,1.3046E+02/
      DATA ((KB(JS,JT,48,16),JS=1,5),JT=1,5) /
     &1.9579E+05,1.4684E+05,9.7896E+04,4.8948E+04,1.8623E+02,
     &2.5824E+05,1.9368E+05,1.2912E+05,6.4559E+04,1.7055E+02,
     &3.2608E+05,2.4456E+05,1.6304E+05,8.0315E+04,1.5696E+02,
     &3.9734E+05,2.9801E+05,1.9867E+05,9.9336E+04,1.4512E+02,
     &4.7039E+05,3.5279E+05,2.3519E+05,1.1760E+05,1.3467E+02/
      DATA ((KB(JS,JT,49,16),JS=1,5),JT=1,5) /
     &2.1650E+05,1.6238E+05,1.0825E+05,5.4125E+04,1.9381E+02,
     &2.9149E+05,2.1861E+05,1.4574E+05,7.2871E+04,1.7704E+02,
     &3.7402E+05,2.8052E+05,1.8701E+05,9.3505E+04,1.6258E+02,
     &4.6192E+05,3.4644E+05,2.3096E+05,1.1548E+05,1.4999E+02,
     &5.5289E+05,4.1467E+05,2.7644E+05,1.3822E+05,1.3901E+02/
      DATA ((KB(JS,JT,50,16),JS=1,5),JT=1,5) /
     &2.2791E+05,1.7093E+05,1.1395E+05,5.6977E+04,2.0134E+02,
     &3.1325E+05,2.3494E+05,1.5662E+05,7.8312E+04,1.8345E+02,
     &4.0878E+05,3.0659E+05,2.0439E+05,1.0220E+05,1.6811E+02,
     &5.1152E+05,3.8364E+05,2.5576E+05,1.2788E+05,1.5482E+02,
     &6.1913E+05,4.6434E+05,3.0956E+05,1.5478E+05,1.4323E+02/
      DATA ((KB(JS,JT,51,16),JS=1,5),JT=1,5) /
     &2.3351E+05,1.7513E+05,1.1675E+05,5.8377E+04,2.0909E+02,
     &3.2811E+05,2.4608E+05,1.6406E+05,8.2029E+04,1.9001E+02,
     &4.3579E+05,3.2684E+05,2.1790E+05,1.0895E+05,1.7377E+02,
     &5.5314E+05,4.1486E+05,2.7653E+05,1.3829E+05,1.5970E+02,
     &6.7717E+05,5.0788E+05,3.3859E+05,1.6929E+05,1.4750E+02/
      DATA ((KB(JS,JT,52,16),JS=1,5),JT=1,5) /
     &2.4395E+05,1.8296E+05,1.2197E+05,6.0984E+04,2.1739E+02,
     &3.5104E+05,2.6328E+05,1.7552E+05,8.7761E+04,1.9693E+02,
     &4.7523E+05,3.5643E+05,2.3762E+05,1.1881E+05,1.7968E+02,
     &6.1247E+05,4.5936E+05,3.0624E+05,1.5312E+05,1.6481E+02,
     &7.5898E+05,5.6924E+05,3.7949E+05,1.8975E+05,1.5192E+02/
      DATA ((KB(JS,JT,53,16),JS=1,5),JT=1,5) /
     &2.6284E+05,1.9713E+05,1.3142E+05,6.5712E+04,2.2625E+02,
     &3.8810E+05,2.9108E+05,1.9405E+05,9.7027E+04,2.0424E+02,
     &5.3641E+05,4.0231E+05,2.6821E+05,1.3410E+05,1.8589E+02,
     &7.0283E+05,5.2713E+05,3.5142E+05,1.7571E+05,1.7018E+02,
     &8.8260E+05,6.6195E+05,4.4130E+05,2.2065E+05,1.5658E+02/
      DATA ((KB(JS,JT,54,16),JS=1,5),JT=1,5) /
     &2.4532E+05,1.8399E+05,1.2266E+05,6.1332E+04,2.3489E+02,
     &3.7212E+05,2.7909E+05,1.8606E+05,9.3031E+04,2.1139E+02,
     &5.1860E+05,3.9351E+05,2.6234E+05,1.3117E+05,1.9188E+02,
     &6.9903E+05,5.2427E+05,3.4952E+05,1.7476E+05,1.7536E+02,
     &8.8946E+05,6.6416E+05,4.4474E+05,2.2237E+05,1.6106E+02/
      DATA ((KB(JS,JT,55,16),JS=1,5),JT=1,5) /
     &2.0815E+05,1.5612E+05,1.0408E+05,5.2039E+04,2.4370E+02,
     &3.2440E+05,2.4330E+05,1.6220E+05,8.1100E+04,2.1865E+02,
     &4.6741E+05,3.5056E+05,2.3371E+05,1.1685E+05,1.9795E+02,
     &6.3338E+05,4.7504E+05,3.1669E+05,1.5835E+05,1.8053E+02,
     &8.1696E+05,6.1272E+05,4.0848E+05,2.0424E+05,1.6554E+02/
      DATA ((KB(JS,JT,56,16),JS=1,5),JT=1,5) /
     &1.7485E+05,1.3114E+05,8.7424E+04,4.3712E+04,2.5296E+02,
     &2.8084E+05,2.1063E+05,1.4042E+05,7.0208E+04,2.2634E+02,
     &4.1394E+05,3.1046E+05,2.0697E+05,1.0347E+05,2.0431E+02,
     &5.7118E+05,4.2838E+05,2.8559E+05,1.4279E+05,1.8592E+02,
     &7.4759E+05,5.6069E+05,3.7379E+05,1.8690E+05,1.7020E+02/
      DATA ((KB(JS,JT,57,16),JS=1,5),JT=1,5) /
     &1.4522E+05,1.0891E+05,7.2607E+04,3.6303E+04,2.6280E+02,
     &2.4098E+05,1.8073E+05,1.2049E+05,6.0242E+04,2.3450E+02,
     &3.6414E+05,2.7311E+05,1.8207E+05,9.1034E+04,2.1103E+02,
     &5.1231E+05,3.8423E+05,2.5615E+05,1.2807E+05,1.9160E+02,
     &6.8106E+05,5.1079E+05,3.4053E+05,1.7026E+05,1.7509E+02/
      DATA ((KB(JS,JT,58,16),JS=1,5),JT=1,5) /
     &3.1730E+04,2.9092E+04,2.4944E+04,1.7470E+04,2.7269E+02,
     &5.4453E+04,4.9925E+04,4.2806E+04,2.9981E+04,2.4268E+02,
     &8.4447E+04,7.7425E+04,6.6385E+04,4.6495E+04,2.1781E+02,
     &1.2116E+05,1.1108E+05,9.5242E+04,6.6707E+04,1.9723E+02,
     &1.6365E+05,1.5004E+05,1.2865E+05,9.0103E+04,1.7991E+02/
      DATA ((KB(JS,JT,59,16),JS=1,5),JT=1,5) /
     &3.4421E+04,3.0055E+04,2.3973E+04,1.4918E+04,2.7694E+02,
     &5.9930E+04,5.2328E+04,4.1740E+04,2.5973E+04,2.4614E+02,
     &9.3934E+04,8.2019E+04,6.5423E+04,4.0711E+04,2.2066E+02,
     &1.3595E+05,1.1871E+05,9.4687E+04,5.8920E+04,1.9962E+02,
     &1.8479E+05,1.6135E+05,1.2650E+05,8.0089E+04,1.8195E+02/

C     The array KA_Mxx contains the absorption coefficient for 
C     a minor species at the 16 chosen g-values for a reference pressure
C     level below 100~ mb.   The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.  The second index refers to temperature 
C     in 7.2 degree increments.  For instance, JT = 1 refers to a 
C     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
C     runs over the g-channel (1 to 16).

       DATA (KA_MO3( 1,JT, 1),JT=1,19)  /
     & 9.31040e-03, 1.01286e-02, 1.10186e-02, 1.19869e-02, 1.30403e-02,
     & 1.41862e-02, 1.54328e-02, 1.67890e-02, 1.82644e-02, 1.98694e-02,
     & 2.16154e-02, 2.35149e-02, 2.55813e-02, 2.78293e-02, 3.02749e-02,
     & 3.29353e-02, 3.58295e-02, 3.89781e-02, 4.24034e-02/
       DATA (KA_MO3( 2,JT, 1),JT=1,19)  /
     & 1.11200e-02, 1.20461e-02, 1.30493e-02, 1.41360e-02, 1.53133e-02,
     & 1.65886e-02, 1.79701e-02, 1.94666e-02, 2.10878e-02, 2.28440e-02,
     & 2.47465e-02, 2.68074e-02, 2.90399e-02, 3.14583e-02, 3.40782e-02,
     & 3.69162e-02, 3.99907e-02, 4.33211e-02, 4.69289e-02/
       DATA (KA_MO3( 3,JT, 1),JT=1,19)  /
     & 1.21630e-02, 1.31401e-02, 1.41956e-02, 1.53359e-02, 1.65679e-02,
     & 1.78988e-02, 1.93366e-02, 2.08899e-02, 2.25680e-02, 2.43808e-02,
     & 2.63394e-02, 2.84552e-02, 3.07410e-02, 3.32104e-02, 3.58782e-02,
     & 3.87603e-02, 4.18739e-02, 4.52377e-02, 4.88716e-02/
       DATA (KA_MO3( 4,JT, 1),JT=1,19)  /
     & 1.26231e-02, 1.36243e-02, 1.47049e-02, 1.58713e-02, 1.71301e-02,
     & 1.84888e-02, 1.99553e-02, 2.15380e-02, 2.32463e-02, 2.50901e-02,
     & 2.70801e-02, 2.92280e-02, 3.15463e-02, 3.40484e-02, 3.67489e-02,
     & 3.96637e-02, 4.28097e-02, 4.62051e-02, 4.98699e-02/
       DATA (KA_MO3( 5,JT, 1),JT=1,19)  /
     & 1.33345e-02, 1.43736e-02, 1.54938e-02, 1.67012e-02, 1.80027e-02,
     & 1.94057e-02, 2.09180e-02, 2.25481e-02, 2.43053e-02, 2.61994e-02,
     & 2.82411e-02, 3.04419e-02, 3.28142e-02, 3.53714e-02, 3.81279e-02,
     & 4.10992e-02, 4.43021e-02, 4.77545e-02, 5.14760e-02/
       DATA (KA_MO3( 6,JT, 1),JT=1,19)  /
     & 1.43294e-02, 1.54133e-02, 1.65791e-02, 1.78331e-02, 1.91819e-02,
     & 2.06328e-02, 2.21935e-02, 2.38721e-02, 2.56778e-02, 2.76200e-02,
     & 2.97091e-02, 3.19562e-02, 3.43733e-02, 3.69732e-02, 3.97698e-02,
     & 4.27779e-02, 4.60136e-02, 4.94939e-02, 5.32375e-02/
       DATA (KA_MO3( 7,JT, 1),JT=1,19)  /
     & 1.48298e-02, 1.59503e-02, 1.71554e-02, 1.84517e-02, 1.98458e-02,
     & 2.13453e-02, 2.29581e-02, 2.46928e-02, 2.65585e-02, 2.85652e-02,
     & 3.07235e-02, 3.30449e-02, 3.55417e-02, 3.82272e-02, 4.11155e-02,
     & 4.42221e-02, 4.75634e-02, 5.11572e-02, 5.50225e-02/
       DATA (KA_MO3( 8,JT, 1),JT=1,19)  /
     & 1.41792e-02, 1.53141e-02, 1.65398e-02, 1.78637e-02, 1.92935e-02,
     & 2.08378e-02, 2.25057e-02, 2.43071e-02, 2.62526e-02, 2.83539e-02,
     & 3.06234e-02, 3.30745e-02, 3.57218e-02, 3.85810e-02, 4.16690e-02,
     & 4.50042e-02, 4.86064e-02, 5.24969e-02, 5.66988e-02/
       DATA (KA_MO3( 9,JT, 1),JT=1,19)  /
     & 8.82784e-03, 9.48321e-03, 1.01872e-02, 1.09435e-02, 1.17560e-02,
     & 1.26287e-02, 1.35662e-02, 1.45734e-02, 1.56553e-02, 1.68175e-02,
     & 1.80660e-02, 1.94072e-02, 2.08480e-02, 2.23958e-02, 2.40584e-02,
     & 2.58445e-02, 2.77631e-02, 2.98242e-02, 3.20383e-02/
       DATA (KA_MO3( 1,JT, 2),JT=1,19)  /
     & 4.28238e-02, 4.51015e-02, 4.75003e-02, 5.00266e-02, 5.26873e-02,
     & 5.54896e-02, 5.84409e-02, 6.15491e-02, 6.48227e-02, 6.82704e-02,
     & 7.19014e-02, 7.57256e-02, 7.97532e-02, 8.39949e-02, 8.84623e-02,
     & 9.31673e-02, 9.81225e-02, 1.03341e-01, 1.08838e-01/
       DATA (KA_MO3( 2,JT, 2),JT=1,19)  /
     & 4.83672e-02, 5.07219e-02, 5.31911e-02, 5.57806e-02, 5.84962e-02,
     & 6.13440e-02, 6.43303e-02, 6.74621e-02, 7.07464e-02, 7.41905e-02,
     & 7.78023e-02, 8.15899e-02, 8.55619e-02, 8.97273e-02, 9.40955e-02,
     & 9.86763e-02, 1.03480e-01, 1.08518e-01, 1.13801e-01/
       DATA (KA_MO3( 3,JT, 2),JT=1,19)  /
     & 5.24315e-02, 5.48650e-02, 5.74115e-02, 6.00762e-02, 6.28645e-02,
     & 6.57822e-02, 6.88354e-02, 7.20302e-02, 7.53734e-02, 7.88717e-02,
     & 8.25324e-02, 8.63630e-02, 9.03714e-02, 9.45658e-02, 9.89549e-02,
     & 1.03548e-01, 1.08354e-01, 1.13383e-01, 1.18645e-01/
       DATA (KA_MO3( 4,JT, 2),JT=1,19)  /
     & 5.65191e-02, 5.90383e-02, 6.16699e-02, 6.44187e-02, 6.72901e-02,
     & 7.02894e-02, 7.34224e-02, 7.66951e-02, 8.01137e-02, 8.36846e-02,
     & 8.74147e-02, 9.13111e-02, 9.53812e-02, 9.96326e-02, 1.04074e-01,
     & 1.08712e-01, 1.13558e-01, 1.18620e-01, 1.23907e-01/
       DATA (KA_MO3( 5,JT, 2),JT=1,19)  /
     & 6.03171e-02, 6.29114e-02, 6.56172e-02, 6.84394e-02, 7.13830e-02,
     & 7.44532e-02, 7.76555e-02, 8.09955e-02, 8.44791e-02, 8.81125e-02,
     & 9.19023e-02, 9.58550e-02, 9.99778e-02, 1.04278e-01, 1.08763e-01,
     & 1.13441e-01, 1.18320e-01, 1.23409e-01, 1.28717e-01/
       DATA (KA_MO3( 6,JT, 2),JT=1,19)  /
     & 6.51092e-02, 6.77827e-02, 7.05660e-02, 7.34635e-02, 7.64801e-02,
     & 7.96204e-02, 8.28898e-02, 8.62934e-02, 8.98367e-02, 9.35255e-02,
     & 9.73658e-02, 1.01364e-01, 1.05526e-01, 1.09859e-01, 1.14370e-01,
     & 1.19066e-01, 1.23955e-01, 1.29045e-01, 1.34344e-01/
       DATA (KA_MO3( 7,JT, 2),JT=1,19)  /
     & 7.09653e-02, 7.37378e-02, 7.66187e-02, 7.96121e-02, 8.27225e-02,
     & 8.59543e-02, 8.93125e-02, 9.28018e-02, 9.64275e-02, 1.00195e-01,
     & 1.04109e-01, 1.08177e-01, 1.12403e-01, 1.16795e-01, 1.21358e-01,
     & 1.26099e-01, 1.31026e-01, 1.36145e-01, 1.41464e-01/
       DATA (KA_MO3( 8,JT, 2),JT=1,19)  /
     & 7.69193e-02, 7.97926e-02, 8.27733e-02, 8.58653e-02, 8.90728e-02,
     & 9.24002e-02, 9.58518e-02, 9.94324e-02, 1.03147e-01, 1.07000e-01,
     & 1.10997e-01, 1.15143e-01, 1.19444e-01, 1.23906e-01, 1.28535e-01,
     & 1.33336e-01, 1.38317e-01, 1.43484e-01, 1.48844e-01/
       DATA (KA_MO3( 9,JT, 2),JT=1,19)  /
     & 4.57962e-02, 4.76027e-02, 4.94805e-02, 5.14323e-02, 5.34611e-02,
     & 5.55700e-02, 5.77620e-02, 6.00405e-02, 6.24089e-02, 6.48707e-02,
     & 6.74296e-02, 7.00895e-02, 7.28542e-02, 7.57281e-02, 7.87153e-02,
     & 8.18203e-02, 8.50478e-02, 8.84027e-02, 9.18898e-02/
       DATA (KA_MO3( 1,JT, 3),JT=1,19)  /
     & 1.12607e-01, 1.16047e-01, 1.19591e-01, 1.23244e-01, 1.27009e-01,
     & 1.30888e-01, 1.34886e-01, 1.39006e-01, 1.43252e-01, 1.47628e-01,
     & 1.52137e-01, 1.56785e-01, 1.61574e-01, 1.66509e-01, 1.71595e-01,
     & 1.76836e-01, 1.82238e-01, 1.87804e-01, 1.93541e-01/
       DATA (KA_MO3( 2,JT, 3),JT=1,19)  /
     & 1.14531e-01, 1.17850e-01, 1.21266e-01, 1.24781e-01, 1.28397e-01,
     & 1.32119e-01, 1.35948e-01, 1.39888e-01, 1.43943e-01, 1.48115e-01,
     & 1.52407e-01, 1.56825e-01, 1.61370e-01, 1.66047e-01, 1.70860e-01,
     & 1.75812e-01, 1.80907e-01, 1.86150e-01, 1.91546e-01/
       DATA (KA_MO3( 3,JT, 3),JT=1,19)  /
     & 1.13986e-01, 1.17222e-01, 1.20551e-01, 1.23974e-01, 1.27494e-01,
     & 1.31114e-01, 1.34837e-01, 1.38666e-01, 1.42604e-01, 1.46653e-01,
     & 1.50817e-01, 1.55099e-01, 1.59503e-01, 1.64032e-01, 1.68690e-01,
     & 1.73480e-01, 1.78406e-01, 1.83472e-01, 1.88682e-01/
       DATA (KA_MO3( 4,JT, 3),JT=1,19)  /
     & 1.13713e-01, 1.16892e-01, 1.20160e-01, 1.23519e-01, 1.26972e-01,
     & 1.30522e-01, 1.34171e-01, 1.37922e-01, 1.41778e-01, 1.45742e-01,
     & 1.49817e-01, 1.54005e-01, 1.58311e-01, 1.62737e-01, 1.67287e-01,
     & 1.71964e-01, 1.76771e-01, 1.81714e-01, 1.86794e-01/
       DATA (KA_MO3( 5,JT, 3),JT=1,19)  /
     & 1.12321e-01, 1.15413e-01, 1.18591e-01, 1.21856e-01, 1.25211e-01,
     & 1.28658e-01, 1.32200e-01, 1.35840e-01, 1.39580e-01, 1.43423e-01,
     & 1.47372e-01, 1.51429e-01, 1.55599e-01, 1.59883e-01, 1.64284e-01,
     & 1.68808e-01, 1.73455e-01, 1.78231e-01, 1.83138e-01/
       DATA (KA_MO3( 6,JT, 3),JT=1,19)  /
     & 1.14158e-01, 1.17218e-01, 1.20360e-01, 1.23586e-01, 1.26899e-01,
     & 1.30300e-01, 1.33793e-01, 1.37379e-01, 1.41061e-01, 1.44842e-01,
     & 1.48724e-01, 1.52711e-01, 1.56804e-01, 1.61007e-01, 1.65322e-01,
     & 1.69754e-01, 1.74304e-01, 1.78976e-01, 1.83773e-01/
       DATA (KA_MO3( 7,JT, 3),JT=1,19)  /
     & 1.21015e-01, 1.23989e-01, 1.27036e-01, 1.30157e-01, 1.33355e-01,
     & 1.36632e-01, 1.39990e-01, 1.43429e-01, 1.46954e-01, 1.50565e-01,
     & 1.54264e-01, 1.58055e-01, 1.61939e-01, 1.65918e-01, 1.69995e-01,
     & 1.74172e-01, 1.78452e-01, 1.82836e-01, 1.87329e-01/
       DATA (KA_MO3( 8,JT, 3),JT=1,19)  /
     & 1.33952e-01, 1.36939e-01, 1.39992e-01, 1.43114e-01, 1.46305e-01,
     & 1.49567e-01, 1.52902e-01, 1.56311e-01, 1.59797e-01, 1.63360e-01,
     & 1.67002e-01, 1.70726e-01, 1.74533e-01, 1.78424e-01, 1.82403e-01,
     & 1.86470e-01, 1.90627e-01, 1.94878e-01, 1.99223e-01/
       DATA (KA_MO3( 9,JT, 3),JT=1,19)  /
     & 1.01003e-01, 1.03713e-01, 1.06495e-01, 1.09352e-01, 1.12285e-01,
     & 1.15297e-01, 1.18390e-01, 1.21566e-01, 1.24827e-01, 1.28176e-01,
     & 1.31614e-01, 1.35145e-01, 1.38770e-01, 1.42493e-01, 1.46315e-01,
     & 1.50240e-01, 1.54271e-01, 1.58409e-01, 1.62659e-01/
       DATA (KA_MO3( 1,JT, 4),JT=1,19)  /
     & 2.35597e-01, 2.37975e-01, 2.40376e-01, 2.42802e-01, 2.45253e-01,
     & 2.47728e-01, 2.50228e-01, 2.52753e-01, 2.55304e-01, 2.57881e-01,
     & 2.60483e-01, 2.63112e-01, 2.65767e-01, 2.68450e-01, 2.71159e-01,
     & 2.73895e-01, 2.76660e-01, 2.79452e-01, 2.82272e-01/
       DATA (KA_MO3( 2,JT, 4),JT=1,19)  /
     & 2.27965e-01, 2.30334e-01, 2.32728e-01, 2.35146e-01, 2.37590e-01,
     & 2.40059e-01, 2.42554e-01, 2.45075e-01, 2.47621e-01, 2.50195e-01,
     & 2.52795e-01, 2.55422e-01, 2.58077e-01, 2.60759e-01, 2.63468e-01,
     & 2.66206e-01, 2.68973e-01, 2.71768e-01, 2.74593e-01/
       DATA (KA_MO3( 3,JT, 4),JT=1,19)  /
     & 2.25956e-01, 2.28277e-01, 2.30622e-01, 2.32991e-01, 2.35384e-01,
     & 2.37802e-01, 2.40244e-01, 2.42712e-01, 2.45205e-01, 2.47724e-01,
     & 2.50268e-01, 2.52839e-01, 2.55436e-01, 2.58060e-01, 2.60711e-01,
     & 2.63389e-01, 2.66094e-01, 2.68827e-01, 2.71589e-01/
       DATA (KA_MO3( 4,JT, 4),JT=1,19)  /
     & 2.28371e-01, 2.30595e-01, 2.32840e-01, 2.35107e-01, 2.37397e-01,
     & 2.39708e-01, 2.42042e-01, 2.44399e-01, 2.46779e-01, 2.49182e-01,
     & 2.51608e-01, 2.54058e-01, 2.56532e-01, 2.59030e-01, 2.61552e-01,
     & 2.64099e-01, 2.66671e-01, 2.69267e-01, 2.71889e-01/
       DATA (KA_MO3( 5,JT, 4),JT=1,19)  /
     & 2.42563e-01, 2.44620e-01, 2.46695e-01, 2.48787e-01, 2.50897e-01,
     & 2.53024e-01, 2.55170e-01, 2.57334e-01, 2.59516e-01, 2.61717e-01,
     & 2.63936e-01, 2.66174e-01, 2.68431e-01, 2.70708e-01, 2.73003e-01,
     & 2.75318e-01, 2.77653e-01, 2.80008e-01, 2.82382e-01/
       DATA (KA_MO3( 6,JT, 4),JT=1,19)  /
     & 2.54052e-01, 2.56017e-01, 2.57997e-01, 2.59992e-01, 2.62003e-01,
     & 2.64029e-01, 2.66071e-01, 2.68129e-01, 2.70203e-01, 2.72293e-01,
     & 2.74398e-01, 2.76521e-01, 2.78659e-01, 2.80814e-01, 2.82986e-01,
     & 2.85175e-01, 2.87380e-01, 2.89603e-01, 2.91842e-01/
       DATA (KA_MO3( 7,JT, 4),JT=1,19)  /
     & 2.54061e-01, 2.55982e-01, 2.57917e-01, 2.59867e-01, 2.61832e-01,
     & 2.63811e-01, 2.65806e-01, 2.67815e-01, 2.69840e-01, 2.71880e-01,
     & 2.73936e-01, 2.76007e-01, 2.78093e-01, 2.80196e-01, 2.82314e-01,
     & 2.84449e-01, 2.86599e-01, 2.88766e-01, 2.90949e-01/
       DATA (KA_MO3( 8,JT, 4),JT=1,19)  /
     & 2.72482e-01, 2.73916e-01, 2.75358e-01, 2.76807e-01, 2.78264e-01,
     & 2.79729e-01, 2.81201e-01, 2.82681e-01, 2.84169e-01, 2.85665e-01,
     & 2.87168e-01, 2.88680e-01, 2.90199e-01, 2.91726e-01, 2.93262e-01,
     & 2.94805e-01, 2.96357e-01, 2.97917e-01, 2.99485e-01/
       DATA (KA_MO3( 9,JT, 4),JT=1,19)  /
     & 1.93414e-01, 1.95498e-01, 1.97605e-01, 1.99734e-01, 2.01886e-01,
     & 2.04062e-01, 2.06261e-01, 2.08483e-01, 2.10730e-01, 2.13001e-01,
     & 2.15296e-01, 2.17616e-01, 2.19961e-01, 2.22331e-01, 2.24727e-01,
     & 2.27148e-01, 2.29596e-01, 2.32070e-01, 2.34571e-01/
       DATA (KA_MO3( 1,JT, 5),JT=1,19)  /
     & 5.30785e-01, 5.30477e-01, 5.30169e-01, 5.29861e-01, 5.29553e-01,
     & 5.29246e-01, 5.28938e-01, 5.28631e-01, 5.28324e-01, 5.28017e-01,
     & 5.27711e-01, 5.27404e-01, 5.27098e-01, 5.26792e-01, 5.26486e-01,
     & 5.26180e-01, 5.25875e-01, 5.25569e-01, 5.25264e-01/
       DATA (KA_MO3( 2,JT, 5),JT=1,19)  /
     & 5.33406e-01, 5.32997e-01, 5.32587e-01, 5.32178e-01, 5.31769e-01,
     & 5.31360e-01, 5.30952e-01, 5.30544e-01, 5.30137e-01, 5.29729e-01,
     & 5.29322e-01, 5.28916e-01, 5.28509e-01, 5.28103e-01, 5.27697e-01,
     & 5.27292e-01, 5.26887e-01, 5.26482e-01, 5.26077e-01/
       DATA (KA_MO3( 3,JT, 5),JT=1,19)  /
     & 5.39814e-01, 5.39234e-01, 5.38655e-01, 5.38077e-01, 5.37499e-01,
     & 5.36922e-01, 5.36345e-01, 5.35769e-01, 5.35194e-01, 5.34620e-01,
     & 5.34045e-01, 5.33472e-01, 5.32899e-01, 5.32327e-01, 5.31756e-01,
     & 5.31185e-01, 5.30614e-01, 5.30045e-01, 5.29475e-01/
       DATA (KA_MO3( 4,JT, 5),JT=1,19)  /
     & 5.39054e-01, 5.38348e-01, 5.37643e-01, 5.36938e-01, 5.36235e-01,
     & 5.35532e-01, 5.34831e-01, 5.34130e-01, 5.33431e-01, 5.32732e-01,
     & 5.32034e-01, 5.31337e-01, 5.30641e-01, 5.29946e-01, 5.29252e-01,
     & 5.28559e-01, 5.27866e-01, 5.27175e-01, 5.26484e-01/
       DATA (KA_MO3( 5,JT, 5),JT=1,19)  /
     & 5.29240e-01, 5.28475e-01, 5.27711e-01, 5.26949e-01, 5.26187e-01,
     & 5.25427e-01, 5.24668e-01, 5.23909e-01, 5.23152e-01, 5.22396e-01,
     & 5.21641e-01, 5.20888e-01, 5.20135e-01, 5.19383e-01, 5.18633e-01,
     & 5.17883e-01, 5.17135e-01, 5.16388e-01, 5.15642e-01/
       DATA (KA_MO3( 6,JT, 5),JT=1,19)  /
     & 5.21746e-01, 5.20815e-01, 5.19886e-01, 5.18958e-01, 5.18032e-01,
     & 5.17107e-01, 5.16184e-01, 5.15263e-01, 5.14343e-01, 5.13425e-01,
     & 5.12509e-01, 5.11594e-01, 5.10681e-01, 5.09770e-01, 5.08860e-01,
     & 5.07952e-01, 5.07045e-01, 5.06140e-01, 5.05237e-01/
       DATA (KA_MO3( 7,JT, 5),JT=1,19)  /
     & 5.26752e-01, 5.25550e-01, 5.24352e-01, 5.23156e-01, 5.21963e-01,
     & 5.20772e-01, 5.19584e-01, 5.18399e-01, 5.17217e-01, 5.16038e-01,
     & 5.14861e-01, 5.13686e-01, 5.12515e-01, 5.11346e-01, 5.10180e-01,
     & 5.09016e-01, 5.07855e-01, 5.06697e-01, 5.05541e-01/
       DATA (KA_MO3( 8,JT, 5),JT=1,19)  /
     & 5.23581e-01, 5.22513e-01, 5.21446e-01, 5.20382e-01, 5.19320e-01,
     & 5.18260e-01, 5.17203e-01, 5.16147e-01, 5.15094e-01, 5.14042e-01,
     & 5.12993e-01, 5.11946e-01, 5.10901e-01, 5.09859e-01, 5.08818e-01,
     & 5.07780e-01, 5.06743e-01, 5.05709e-01, 5.04677e-01/
       DATA (KA_MO3( 9,JT, 5),JT=1,19)  /
     & 3.80393e-01, 3.80680e-01, 3.80967e-01, 3.81254e-01, 3.81542e-01,
     & 3.81829e-01, 3.82117e-01, 3.82405e-01, 3.82693e-01, 3.82982e-01,
     & 3.83271e-01, 3.83559e-01, 3.83849e-01, 3.84138e-01, 3.84428e-01,
     & 3.84717e-01, 3.85007e-01, 3.85298e-01, 3.85588e-01/
       DATA (KA_MO3( 1,JT, 6),JT=1,19)  /
     & 6.14818e-01, 6.10664e-01, 6.06539e-01, 6.02441e-01, 5.98372e-01,
     & 5.94330e-01, 5.90315e-01, 5.86327e-01, 5.82366e-01, 5.78432e-01,
     & 5.74524e-01, 5.70643e-01, 5.66788e-01, 5.62959e-01, 5.59156e-01,
     & 5.55379e-01, 5.51627e-01, 5.47901e-01, 5.44199e-01/
       DATA (KA_MO3( 2,JT, 6),JT=1,19)  /
     & 6.10199e-01, 6.06143e-01, 6.02114e-01, 5.98112e-01, 5.94136e-01,
     & 5.90187e-01, 5.86264e-01, 5.82367e-01, 5.78496e-01, 5.74651e-01,
     & 5.70831e-01, 5.67037e-01, 5.63268e-01, 5.59524e-01, 5.55805e-01,
     & 5.52110e-01, 5.48440e-01, 5.44795e-01, 5.41174e-01/
       DATA (KA_MO3( 3,JT, 6),JT=1,19)  /
     & 6.02949e-01, 5.99057e-01, 5.95190e-01, 5.91348e-01, 5.87531e-01,
     & 5.83739e-01, 5.79971e-01, 5.76227e-01, 5.72508e-01, 5.68812e-01,
     & 5.65140e-01, 5.61493e-01, 5.57868e-01, 5.54267e-01, 5.50690e-01,
     & 5.47135e-01, 5.43603e-01, 5.40094e-01, 5.36608e-01/
       DATA (KA_MO3( 4,JT, 6),JT=1,19)  /
     & 6.05047e-01, 6.01155e-01, 5.97289e-01, 5.93448e-01, 5.89631e-01,
     & 5.85838e-01, 5.82071e-01, 5.78327e-01, 5.74607e-01, 5.70912e-01,
     & 5.67240e-01, 5.63592e-01, 5.59967e-01, 5.56365e-01, 5.52787e-01,
     & 5.49232e-01, 5.45699e-01, 5.42190e-01, 5.38703e-01/
       DATA (KA_MO3( 5,JT, 6),JT=1,19)  /
     & 6.03593e-01, 5.99867e-01, 5.96164e-01, 5.92483e-01, 5.88825e-01,
     & 5.85190e-01, 5.81577e-01, 5.77987e-01, 5.74419e-01, 5.70872e-01,
     & 5.67348e-01, 5.63846e-01, 5.60365e-01, 5.56905e-01, 5.53467e-01,
     & 5.50050e-01, 5.46654e-01, 5.43279e-01, 5.39926e-01/
       DATA (KA_MO3( 6,JT, 6),JT=1,19)  /
     & 6.03940e-01, 6.00224e-01, 5.96531e-01, 5.92861e-01, 5.89213e-01,
     & 5.85588e-01, 5.81985e-01, 5.78404e-01, 5.74845e-01, 5.71308e-01,
     & 5.67793e-01, 5.64299e-01, 5.60827e-01, 5.57377e-01, 5.53947e-01,
     & 5.50539e-01, 5.47151e-01, 5.43785e-01, 5.40439e-01/
       DATA (KA_MO3( 7,JT, 6),JT=1,19)  /
     & 6.06242e-01, 6.02257e-01, 5.98299e-01, 5.94367e-01, 5.90461e-01,
     & 5.86580e-01, 5.82725e-01, 5.78895e-01, 5.75090e-01, 5.71311e-01,
     & 5.67556e-01, 5.63826e-01, 5.60120e-01, 5.56439e-01, 5.52782e-01,
     & 5.49149e-01, 5.45540e-01, 5.41954e-01, 5.38393e-01/
       DATA (KA_MO3( 8,JT, 6),JT=1,19)  /
     & 6.11929e-01, 6.07173e-01, 6.02454e-01, 5.97773e-01, 5.93127e-01,
     & 5.88518e-01, 5.83944e-01, 5.79406e-01, 5.74903e-01, 5.70436e-01,
     & 5.66002e-01, 5.61604e-01, 5.57239e-01, 5.52909e-01, 5.48612e-01,
     & 5.44349e-01, 5.40118e-01, 5.35921e-01, 5.31756e-01/
       DATA (KA_MO3( 9,JT, 6),JT=1,19)  /
     & 6.21189e-01, 6.17338e-01, 6.13511e-01, 6.09707e-01, 6.05927e-01,
     & 6.02170e-01, 5.98437e-01, 5.94726e-01, 5.91039e-01, 5.87375e-01,
     & 5.83733e-01, 5.80114e-01, 5.76517e-01, 5.72943e-01, 5.69390e-01,
     & 5.65860e-01, 5.62352e-01, 5.58865e-01, 5.55400e-01/
       DATA (KA_MO3( 1,JT, 7),JT=1,19)  /
     & 7.41310e-01, 7.30108e-01, 7.19075e-01, 7.08209e-01, 6.97507e-01,
     & 6.86967e-01, 6.76586e-01, 6.66362e-01, 6.56292e-01, 6.46374e-01,
     & 6.36607e-01, 6.26987e-01, 6.17512e-01, 6.08181e-01, 5.98990e-01,
     & 5.89939e-01, 5.81024e-01, 5.72244e-01, 5.63597e-01/
       DATA (KA_MO3( 2,JT, 7),JT=1,19)  /
     & 7.38780e-01, 7.27631e-01, 7.16651e-01, 7.05836e-01, 6.95185e-01,
     & 6.84695e-01, 6.74362e-01, 6.64186e-01, 6.54163e-01, 6.44292e-01,
     & 6.34569e-01, 6.24993e-01, 6.15562e-01, 6.06273e-01, 5.97124e-01,
     & 5.88113e-01, 5.79238e-01, 5.70498e-01, 5.61889e-01/
       DATA (KA_MO3( 3,JT, 7),JT=1,19)  /
     & 7.33846e-01, 7.22799e-01, 7.11919e-01, 7.01203e-01, 6.90648e-01,
     & 6.80252e-01, 6.70012e-01, 6.59927e-01, 6.49993e-01, 6.40209e-01,
     & 6.30572e-01, 6.21080e-01, 6.11731e-01, 6.02523e-01, 5.93453e-01,
     & 5.84520e-01, 5.75721e-01, 5.67055e-01, 5.58519e-01/
       DATA (KA_MO3( 4,JT, 7),JT=1,19)  /
     & 7.21218e-01, 7.10492e-01, 6.99926e-01, 6.89517e-01, 6.79262e-01,
     & 6.69160e-01, 6.59209e-01, 6.49405e-01, 6.39747e-01, 6.30233e-01,
     & 6.20860e-01, 6.11627e-01, 6.02531e-01, 5.93570e-01, 5.84743e-01,
     & 5.76047e-01, 5.67480e-01, 5.59040e-01, 5.50726e-01/
       DATA (KA_MO3( 5,JT, 7),JT=1,19)  /
     & 7.10588e-01, 7.00014e-01, 6.89596e-01, 6.79334e-01, 6.69225e-01,
     & 6.59266e-01, 6.49455e-01, 6.39790e-01, 6.30269e-01, 6.20889e-01,
     & 6.11650e-01, 6.02547e-01, 5.93581e-01, 5.84747e-01, 5.76045e-01,
     & 5.67473e-01, 5.59028e-01, 5.50709e-01, 5.42513e-01/
       DATA (KA_MO3( 6,JT, 7),JT=1,19)  /
     & 6.98166e-01, 6.87706e-01, 6.77402e-01, 6.67253e-01, 6.57256e-01,
     & 6.47408e-01, 6.37708e-01, 6.28154e-01, 6.18742e-01, 6.09472e-01,
     & 6.00340e-01, 5.91346e-01, 5.82486e-01, 5.73758e-01, 5.65162e-01,
     & 5.56694e-01, 5.48353e-01, 5.40138e-01, 5.32045e-01/
       DATA (KA_MO3( 7,JT, 7),JT=1,19)  /
     & 6.76974e-01, 6.67034e-01, 6.57240e-01, 6.47590e-01, 6.38081e-01,
     & 6.28712e-01, 6.19481e-01, 6.10385e-01, 6.01422e-01, 5.92592e-01,
     & 5.83891e-01, 5.75317e-01, 5.66870e-01, 5.58547e-01, 5.50345e-01,
     & 5.42265e-01, 5.34303e-01, 5.26457e-01, 5.18727e-01/
       DATA (KA_MO3( 8,JT, 7),JT=1,19)  /
     & 6.30061e-01, 6.21017e-01, 6.12102e-01, 6.03316e-01, 5.94656e-01,
     & 5.86120e-01, 5.77706e-01, 5.69414e-01, 5.61240e-01, 5.53184e-01,
     & 5.45243e-01, 5.37416e-01, 5.29702e-01, 5.22098e-01, 5.14604e-01,
     & 5.07217e-01, 4.99936e-01, 4.92760e-01, 4.85687e-01/
       DATA (KA_MO3( 9,JT, 7),JT=1,19)  /
     & 8.97633e-01, 8.87307e-01, 8.77100e-01, 8.67010e-01, 8.57036e-01,
     & 8.47176e-01, 8.37431e-01, 8.27797e-01, 8.18274e-01, 8.08861e-01,
     & 7.99555e-01, 7.90357e-01, 7.81265e-01, 7.72278e-01, 7.63393e-01,
     & 7.54611e-01, 7.45930e-01, 7.37349e-01, 7.28867e-01/
       DATA (KA_MO3( 1,JT, 8),JT=1,19)  /
     & 4.87356e-01, 4.80743e-01, 4.74220e-01, 4.67785e-01, 4.61437e-01,
     & 4.55176e-01, 4.49000e-01, 4.42907e-01, 4.36897e-01, 4.30969e-01,
     & 4.25121e-01, 4.19353e-01, 4.13663e-01, 4.08049e-01, 4.02513e-01,
     & 3.97051e-01, 3.91663e-01, 3.86349e-01, 3.81106e-01/
       DATA (KA_MO3( 2,JT, 8),JT=1,19)  /
     & 4.86776e-01, 4.80157e-01, 4.73627e-01, 4.67187e-01, 4.60834e-01,
     & 4.54567e-01, 4.48386e-01, 4.42289e-01, 4.36274e-01, 4.30342e-01,
     & 4.24490e-01, 4.18718e-01, 4.13024e-01, 4.07407e-01, 4.01867e-01,
     & 3.96403e-01, 3.91012e-01, 3.85695e-01, 3.80450e-01/
       DATA (KA_MO3( 3,JT, 8),JT=1,19)  /
     & 4.86111e-01, 4.79496e-01, 4.72972e-01, 4.66536e-01, 4.60188e-01,
     & 4.53926e-01, 4.47750e-01, 4.41657e-01, 4.35648e-01, 4.29720e-01,
     & 4.23873e-01, 4.18105e-01, 4.12416e-01, 4.06804e-01, 4.01269e-01,
     & 3.95809e-01, 3.90423e-01, 3.85111e-01, 3.79871e-01/
       DATA (KA_MO3( 4,JT, 8),JT=1,19)  /
     & 4.85501e-01, 4.78880e-01, 4.72350e-01, 4.65908e-01, 4.59554e-01,
     & 4.53288e-01, 4.47106e-01, 4.41009e-01, 4.34995e-01, 4.29063e-01,
     & 4.23211e-01, 4.17440e-01, 4.11747e-01, 4.06132e-01, 4.00594e-01,
     & 3.95131e-01, 3.89743e-01, 3.84428e-01, 3.79185e-01/
       DATA (KA_MO3( 5,JT, 8),JT=1,19)  /
     & 4.83679e-01, 4.77140e-01, 4.70691e-01, 4.64328e-01, 4.58051e-01,
     & 4.51859e-01, 4.45751e-01, 4.39726e-01, 4.33781e-01, 4.27918e-01,
     & 4.22133e-01, 4.16427e-01, 4.10798e-01, 4.05245e-01, 3.99767e-01,
     & 3.94363e-01, 3.89032e-01, 3.83773e-01, 3.78585e-01/
       DATA (KA_MO3( 6,JT, 8),JT=1,19)  /
     & 4.72120e-01, 4.65834e-01, 4.59630e-01, 4.53510e-01, 4.47471e-01,
     & 4.41513e-01, 4.35633e-01, 4.29833e-01, 4.24109e-01, 4.18461e-01,
     & 4.12889e-01, 4.07391e-01, 4.01966e-01, 3.96614e-01, 3.91332e-01,
     & 3.86122e-01, 3.80980e-01, 3.75907e-01, 3.70901e-01/
       DATA (KA_MO3( 7,JT, 8),JT=1,19)  /
     & 4.58683e-01, 4.52758e-01, 4.46909e-01, 4.41135e-01, 4.35437e-01,
     & 4.29812e-01, 4.24259e-01, 4.18779e-01, 4.13369e-01, 4.08029e-01,
     & 4.02758e-01, 3.97555e-01, 3.92419e-01, 3.87350e-01, 3.82346e-01,
     & 3.77406e-01, 3.72531e-01, 3.67719e-01, 3.62968e-01/
       DATA (KA_MO3( 8,JT, 8),JT=1,19)  /
     & 4.56091e-01, 4.50481e-01, 4.44940e-01, 4.39467e-01, 4.34062e-01,
     & 4.28722e-01, 4.23449e-01, 4.18240e-01, 4.13096e-01, 4.08015e-01,
     & 4.02996e-01, 3.98039e-01, 3.93143e-01, 3.88307e-01, 3.83531e-01,
     & 3.78813e-01, 3.74154e-01, 3.69552e-01, 3.65006e-01/
       DATA (KA_MO3( 9,JT, 8),JT=1,19)  /
     & 9.11213e-01, 9.03270e-01, 8.95396e-01, 8.87591e-01, 8.79855e-01,
     & 8.72185e-01, 8.64583e-01, 8.57046e-01, 8.49576e-01, 8.42170e-01,
     & 8.34829e-01, 8.27552e-01, 8.20339e-01, 8.13188e-01, 8.06100e-01,
     & 7.99073e-01, 7.92108e-01, 7.85204e-01, 7.78359e-01/
       DATA (KA_MO3( 1,JT, 9),JT=1,19)  /
     & 5.56194e-01, 5.48595e-01, 5.41100e-01, 5.33707e-01, 5.26415e-01,
     & 5.19223e-01, 5.12129e-01, 5.05132e-01, 4.98231e-01, 4.91424e-01,
     & 4.84710e-01, 4.78087e-01, 4.71556e-01, 4.65113e-01, 4.58758e-01,
     & 4.52491e-01, 4.46309e-01, 4.40211e-01, 4.34197e-01/
       DATA (KA_MO3( 2,JT, 9),JT=1,19)  /
     & 5.56174e-01, 5.48575e-01, 5.41079e-01, 5.33687e-01, 5.26395e-01,
     & 5.19203e-01, 5.12109e-01, 5.05112e-01, 4.98211e-01, 4.91404e-01,
     & 4.84690e-01, 4.78068e-01, 4.71536e-01, 4.65093e-01, 4.58739e-01,
     & 4.52471e-01, 4.46289e-01, 4.40191e-01, 4.34177e-01/
       DATA (KA_MO3( 3,JT, 9),JT=1,19)  /
     & 5.55996e-01, 5.48403e-01, 5.40913e-01, 5.33526e-01, 5.26239e-01,
     & 5.19052e-01, 5.11963e-01, 5.04971e-01, 4.98074e-01, 4.91272e-01,
     & 4.84562e-01, 4.77944e-01, 4.71417e-01, 4.64978e-01, 4.58628e-01,
     & 4.52364e-01, 4.46186e-01, 4.40092e-01, 4.34081e-01/
       DATA (KA_MO3( 4,JT, 9),JT=1,19)  /
     & 5.55859e-01, 5.48271e-01, 5.40786e-01, 5.33404e-01, 5.26123e-01,
     & 5.18941e-01, 5.11856e-01, 5.04869e-01, 4.97977e-01, 4.91179e-01,
     & 4.84474e-01, 4.77861e-01, 4.71337e-01, 4.64903e-01, 4.58557e-01,
     & 4.52297e-01, 4.46123e-01, 4.40033e-01, 4.34026e-01/
       DATA (KA_MO3( 5,JT, 9),JT=1,19)  /
     & 5.54550e-01, 5.46921e-01, 5.39397e-01, 5.31976e-01, 5.24657e-01,
     & 5.17439e-01, 5.10320e-01, 5.03300e-01, 4.96376e-01, 4.89547e-01,
     & 4.82812e-01, 4.76170e-01, 4.69619e-01, 4.63158e-01, 4.56786e-01,
     & 4.50502e-01, 4.44304e-01, 4.38192e-01, 4.32163e-01/
       DATA (KA_MO3( 6,JT, 9),JT=1,19)  /
     & 5.53514e-01, 5.45883e-01, 5.38358e-01, 5.30937e-01, 5.23618e-01,
     & 5.16399e-01, 5.09280e-01, 5.02260e-01, 4.95336e-01, 4.88507e-01,
     & 4.81773e-01, 4.75132e-01, 4.68582e-01, 4.62122e-01, 4.55752e-01,
     & 4.49469e-01, 4.43273e-01, 4.37162e-01, 4.31136e-01/
       DATA (KA_MO3( 7,JT, 9),JT=1,19)  /
     & 5.49865e-01, 5.42303e-01, 5.34846e-01, 5.27491e-01, 5.20237e-01,
     & 5.13084e-01, 5.06028e-01, 4.99070e-01, 4.92207e-01, 4.85438e-01,
     & 4.78763e-01, 4.72179e-01, 4.65686e-01, 4.59282e-01, 4.52967e-01,
     & 4.46738e-01, 4.40595e-01, 4.34536e-01, 4.28561e-01/
       DATA (KA_MO3( 8,JT, 9),JT=1,19)  /
     & 5.25435e-01, 5.18437e-01, 5.11533e-01, 5.04721e-01, 4.97999e-01,
     & 4.91367e-01, 4.84823e-01, 4.78366e-01, 4.71996e-01, 4.65710e-01,
     & 4.59508e-01, 4.53388e-01, 4.47350e-01, 4.41393e-01, 4.35515e-01,
     & 4.29715e-01, 4.23992e-01, 4.18345e-01, 4.12774e-01/
       DATA (KA_MO3( 9,JT, 9),JT=1,19)  /
     & 3.48228e-01, 3.45949e-01, 3.43686e-01, 3.41437e-01, 3.39203e-01,
     & 3.36983e-01, 3.34778e-01, 3.32588e-01, 3.30412e-01, 3.28250e-01,
     & 3.26102e-01, 3.23968e-01, 3.21848e-01, 3.19742e-01, 3.17650e-01,
     & 3.15572e-01, 3.13507e-01, 3.11456e-01, 3.09418e-01/
       DATA (KA_MO3( 1,JT,10),JT=1,19)  /
     & 8.34107e-01, 8.27276e-01, 8.20501e-01, 8.13781e-01, 8.07117e-01,
     & 8.00507e-01, 7.93951e-01, 7.87449e-01, 7.81000e-01, 7.74604e-01,
     & 7.68260e-01, 7.61968e-01, 7.55728e-01, 7.49539e-01, 7.43400e-01,
     & 7.37312e-01, 7.31274e-01, 7.25285e-01, 7.19345e-01/
       DATA (KA_MO3( 2,JT,10),JT=1,19)  /
     & 8.32838e-01, 8.26022e-01, 8.19263e-01, 8.12558e-01, 8.05908e-01,
     & 7.99313e-01, 7.92772e-01, 7.86284e-01, 7.79849e-01, 7.73467e-01,
     & 7.67137e-01, 7.60859e-01, 7.54633e-01, 7.48457e-01, 7.42332e-01,
     & 7.36257e-01, 7.30232e-01, 7.24256e-01, 7.18329e-01/
       DATA (KA_MO3( 3,JT,10),JT=1,19)  /
     & 8.31167e-01, 8.24361e-01, 8.17611e-01, 8.10916e-01, 8.04276e-01,
     & 7.97691e-01, 7.91159e-01, 7.84681e-01, 7.78256e-01, 7.71883e-01,
     & 7.65563e-01, 7.59294e-01, 7.53077e-01, 7.46910e-01, 7.40795e-01,
     & 7.34729e-01, 7.28713e-01, 7.22746e-01, 7.16828e-01/
       DATA (KA_MO3( 4,JT,10),JT=1,19)  /
     & 8.29026e-01, 8.22246e-01, 8.15521e-01, 8.08851e-01, 8.02236e-01,
     & 7.95675e-01, 7.89167e-01, 7.82713e-01, 7.76312e-01, 7.69962e-01,
     & 7.63665e-01, 7.57419e-01, 7.51225e-01, 7.45081e-01, 7.38987e-01,
     & 7.32943e-01, 7.26949e-01, 7.21003e-01, 7.15107e-01/
       DATA (KA_MO3( 5,JT,10),JT=1,19)  /
     & 8.26226e-01, 8.19471e-01, 8.12771e-01, 8.06126e-01, 7.99536e-01,
     & 7.92999e-01, 7.86515e-01, 7.80085e-01, 7.73707e-01, 7.67382e-01,
     & 7.61108e-01, 7.54885e-01, 7.48714e-01, 7.42592e-01, 7.36521e-01,
     & 7.30500e-01, 7.24527e-01, 7.18604e-01, 7.12729e-01/
       DATA (KA_MO3( 6,JT,10),JT=1,19)  /
     & 8.33246e-01, 8.26510e-01, 8.19828e-01, 8.13200e-01, 8.06626e-01,
     & 8.00105e-01, 7.93637e-01, 7.87221e-01, 7.80856e-01, 7.74544e-01,
     & 7.68282e-01, 7.62071e-01, 7.55910e-01, 7.49799e-01, 7.43737e-01,
     & 7.37725e-01, 7.31760e-01, 7.25845e-01, 7.19977e-01/
       DATA (KA_MO3( 7,JT,10),JT=1,19)  /
     & 8.45693e-01, 8.38967e-01, 8.32295e-01, 8.25675e-01, 8.19108e-01,
     & 8.12594e-01, 8.06131e-01, 7.99719e-01, 7.93359e-01, 7.87049e-01,
     & 7.80789e-01, 7.74579e-01, 7.68419e-01, 7.62307e-01, 7.56244e-01,
     & 7.50230e-01, 7.44263e-01, 7.38343e-01, 7.32471e-01/
       DATA (KA_MO3( 8,JT,10),JT=1,19)  /
     & 8.32139e-01, 8.25565e-01, 8.19044e-01, 8.12574e-01, 8.06156e-01,
     & 7.99788e-01, 7.93470e-01, 7.87202e-01, 7.80984e-01, 7.74815e-01,
     & 7.68694e-01, 7.62622e-01, 7.56598e-01, 7.50622e-01, 7.44692e-01,
     & 7.38810e-01, 7.32974e-01, 7.27184e-01, 7.21440e-01/
       DATA (KA_MO3( 9,JT,10),JT=1,19)  /
     & 2.34258e-01, 2.35247e-01, 2.36239e-01, 2.37236e-01, 2.38237e-01,
     & 2.39242e-01, 2.40252e-01, 2.41265e-01, 2.42283e-01, 2.43306e-01,
     & 2.44332e-01, 2.45363e-01, 2.46398e-01, 2.47438e-01, 2.48482e-01,
     & 2.49531e-01, 2.50583e-01, 2.51641e-01, 2.52702e-01/
       DATA (KA_MO3( 1,JT,11),JT=1,19)  /
     & 8.31308e-01, 8.22153e-01, 8.13098e-01, 8.04143e-01, 7.95287e-01,
     & 7.86528e-01, 7.77866e-01, 7.69299e-01, 7.60827e-01, 7.52448e-01,
     & 7.44161e-01, 7.35965e-01, 7.27860e-01, 7.19844e-01, 7.11916e-01,
     & 7.04075e-01, 6.96321e-01, 6.88652e-01, 6.81068e-01/
       DATA (KA_MO3( 2,JT,11),JT=1,19)  /
     & 8.31577e-01, 8.22400e-01, 8.13324e-01, 8.04349e-01, 7.95472e-01,
     & 7.86693e-01, 7.78011e-01, 7.69425e-01, 7.60934e-01, 7.52537e-01,
     & 7.44232e-01, 7.36019e-01, 7.27896e-01, 7.19863e-01, 7.11919e-01,
     & 7.04062e-01, 6.96292e-01, 6.88608e-01, 6.81009e-01/
       DATA (KA_MO3( 3,JT,11),JT=1,19)  /
     & 8.31578e-01, 8.22422e-01, 8.13368e-01, 8.04413e-01, 7.95557e-01,
     & 7.86798e-01, 7.78136e-01, 7.69569e-01, 7.61097e-01, 7.52717e-01,
     & 7.44430e-01, 7.36235e-01, 7.28129e-01, 7.20113e-01, 7.12185e-01,
     & 7.04344e-01, 6.96589e-01, 6.88920e-01, 6.81336e-01/
       DATA (KA_MO3( 4,JT,11),JT=1,19)  /
     & 8.31261e-01, 8.22111e-01, 8.13062e-01, 8.04112e-01, 7.95261e-01,
     & 7.86507e-01, 7.77850e-01, 7.69288e-01, 7.60820e-01, 7.52445e-01,
     & 7.44163e-01, 7.35971e-01, 7.27870e-01, 7.19858e-01, 7.11935e-01,
     & 7.04098e-01, 6.96348e-01, 6.88683e-01, 6.81102e-01/
       DATA (KA_MO3( 5,JT,11),JT=1,19)  /
     & 8.31565e-01, 8.22404e-01, 8.13344e-01, 8.04384e-01, 7.95523e-01,
     & 7.86760e-01, 7.78092e-01, 7.69521e-01, 7.61044e-01, 7.52660e-01,
     & 7.44368e-01, 7.36168e-01, 7.28058e-01, 7.20038e-01, 7.12106e-01,
     & 7.04261e-01, 6.96503e-01, 6.88830e-01, 6.81242e-01/
       DATA (KA_MO3( 6,JT,11),JT=1,19)  /
     & 8.17636e-01, 8.08497e-01, 7.99461e-01, 7.90525e-01, 7.81690e-01,
     & 7.72953e-01, 7.64314e-01, 7.55771e-01, 7.47324e-01, 7.38971e-01,
     & 7.30712e-01, 7.22545e-01, 7.14469e-01, 7.06483e-01, 6.98587e-01,
     & 6.90779e-01, 6.83058e-01, 6.75424e-01, 6.67875e-01/
       DATA (KA_MO3( 7,JT,11),JT=1,19)  /
     & 7.95247e-01, 7.86140e-01, 7.77137e-01, 7.68238e-01, 7.59440e-01,
     & 7.50743e-01, 7.42145e-01, 7.33646e-01, 7.25245e-01, 7.16939e-01,
     & 7.08729e-01, 7.00612e-01, 6.92589e-01, 6.84658e-01, 6.76817e-01,
     & 6.69066e-01, 6.61404e-01, 6.53830e-01, 6.46342e-01/
       DATA (KA_MO3( 8,JT,11),JT=1,19)  /
     & 7.63069e-01, 7.54006e-01, 7.45051e-01, 7.36202e-01, 7.27458e-01,
     & 7.18818e-01, 7.10281e-01, 7.01845e-01, 6.93509e-01, 6.85272e-01,
     & 6.77133e-01, 6.69091e-01, 6.61144e-01, 6.53292e-01, 6.45533e-01,
     & 6.37866e-01, 6.30290e-01, 6.22804e-01, 6.15407e-01/
       DATA (KA_MO3( 9,JT,11),JT=1,19)  /
     & 2.03255e-01, 2.03004e-01, 2.02753e-01, 2.02502e-01, 2.02252e-01,
     & 2.02001e-01, 2.01752e-01, 2.01502e-01, 2.01253e-01, 2.01004e-01,
     & 2.00755e-01, 2.00507e-01, 2.00259e-01, 2.00011e-01, 1.99764e-01,
     & 1.99517e-01, 1.99270e-01, 1.99024e-01, 1.98777e-01/
       DATA (KA_MO3( 1,JT,12),JT=1,19)  /
     & 4.13201e-01, 4.05258e-01, 3.97468e-01, 3.89828e-01, 3.82334e-01,
     & 3.74985e-01, 3.67777e-01, 3.60707e-01, 3.53774e-01, 3.46973e-01,
     & 3.40303e-01, 3.33762e-01, 3.27346e-01, 3.21054e-01, 3.14882e-01,
     & 3.08829e-01, 3.02893e-01, 2.97071e-01, 2.91360e-01/
       DATA (KA_MO3( 2,JT,12),JT=1,19)  /
     & 4.12835e-01, 4.04897e-01, 3.97112e-01, 3.89477e-01, 3.81988e-01,
     & 3.74644e-01, 3.67440e-01, 3.60376e-01, 3.53447e-01, 3.46651e-01,
     & 3.39986e-01, 3.33449e-01, 3.27038e-01, 3.20750e-01, 3.14582e-01,
     & 3.08534e-01, 3.02602e-01, 2.96784e-01, 2.91077e-01/
       DATA (KA_MO3( 3,JT,12),JT=1,19)  /
     & 4.13023e-01, 4.05079e-01, 3.97289e-01, 3.89648e-01, 3.82155e-01,
     & 3.74805e-01, 3.67597e-01, 3.60527e-01, 3.53594e-01, 3.46793e-01,
     & 3.40124e-01, 3.33583e-01, 3.27167e-01, 3.20875e-01, 3.14704e-01,
     & 3.08652e-01, 3.02716e-01, 2.96894e-01, 2.91184e-01/
       DATA (KA_MO3( 4,JT,12),JT=1,19)  /
     & 4.13397e-01, 4.05437e-01, 3.97630e-01, 3.89973e-01, 3.82463e-01,
     & 3.75099e-01, 3.67876e-01, 3.60792e-01, 3.53844e-01, 3.47031e-01,
     & 3.40348e-01, 3.33794e-01, 3.27367e-01, 3.21063e-01, 3.14880e-01,
     & 3.08817e-01, 3.02870e-01, 2.97038e-01, 2.91318e-01/
       DATA (KA_MO3( 5,JT,12),JT=1,19)  /
     & 4.13043e-01, 4.05106e-01, 3.97321e-01, 3.89686e-01, 3.82198e-01,
     & 3.74854e-01, 3.67651e-01, 3.60586e-01, 3.53657e-01, 3.46861e-01,
     & 3.40195e-01, 3.33658e-01, 3.27246e-01, 3.20958e-01, 3.14790e-01,
     & 3.08741e-01, 3.02808e-01, 2.96990e-01, 2.91283e-01/
       DATA (KA_MO3( 6,JT,12),JT=1,19)  /
     & 4.13151e-01, 4.05202e-01, 3.97406e-01, 3.89760e-01, 3.82261e-01,
     & 3.74906e-01, 3.67693e-01, 3.60619e-01, 3.53680e-01, 3.46876e-01,
     & 3.40202e-01, 3.33656e-01, 3.27237e-01, 3.20941e-01, 3.14766e-01,
     & 3.08710e-01, 3.02770e-01, 2.96945e-01, 2.91232e-01/
       DATA (KA_MO3( 7,JT,12),JT=1,19)  /
     & 4.13052e-01, 4.05109e-01, 3.97319e-01, 3.89678e-01, 3.82185e-01,
     & 3.74835e-01, 3.67627e-01, 3.60557e-01, 3.53624e-01, 3.46823e-01,
     & 3.40154e-01, 3.33612e-01, 3.27197e-01, 3.20905e-01, 3.14734e-01,
     & 3.08681e-01, 3.02745e-01, 2.96923e-01, 2.91213e-01/
       DATA (KA_MO3( 8,JT,12),JT=1,19)  /
     & 4.13152e-01, 4.05209e-01, 3.97418e-01, 3.89778e-01, 3.82284e-01,
     & 3.74935e-01, 3.67727e-01, 3.60657e-01, 3.53723e-01, 3.46923e-01,
     & 3.40253e-01, 3.33712e-01, 3.27296e-01, 3.21004e-01, 3.14833e-01,
     & 3.08780e-01, 3.02844e-01, 2.97021e-01, 2.91311e-01/
       DATA (KA_MO3( 9,JT,12),JT=1,19)  /
     & 1.31008e-01, 1.30607e-01, 1.30208e-01, 1.29810e-01, 1.29413e-01,
     & 1.29017e-01, 1.28623e-01, 1.28229e-01, 1.27837e-01, 1.27446e-01,
     & 1.27056e-01, 1.26668e-01, 1.26280e-01, 1.25894e-01, 1.25509e-01,
     & 1.25125e-01, 1.24743e-01, 1.24361e-01, 1.23981e-01/
       DATA (KA_MO3( 1,JT,13),JT=1,19)  /
     & 4.66826e-01, 4.71437e-01, 4.76094e-01, 4.80798e-01, 4.85547e-01,
     & 4.90344e-01, 4.95187e-01, 5.00079e-01, 5.05019e-01, 5.10008e-01,
     & 5.15046e-01, 5.20134e-01, 5.25272e-01, 5.30461e-01, 5.35701e-01,
     & 5.40993e-01, 5.46338e-01, 5.51735e-01, 5.57185e-01/
       DATA (KA_MO3( 2,JT,13),JT=1,19)  /
     & 4.66579e-01, 4.71199e-01, 4.75865e-01, 4.80577e-01, 4.85336e-01,
     & 4.90141e-01, 4.94995e-01, 4.99896e-01, 5.04846e-01, 5.09845e-01,
     & 5.14893e-01, 5.19992e-01, 5.25141e-01, 5.30340e-01, 5.35592e-01,
     & 5.40895e-01, 5.46251e-01, 5.51660e-01, 5.57122e-01/
       DATA (KA_MO3( 3,JT,13),JT=1,19)  /
     & 4.66956e-01, 4.71567e-01, 4.76224e-01, 4.80927e-01, 4.85677e-01,
     & 4.90474e-01, 4.95318e-01, 5.00209e-01, 5.05149e-01, 5.10138e-01,
     & 5.15176e-01, 5.20264e-01, 5.25402e-01, 5.30591e-01, 5.35831e-01,
     & 5.41123e-01, 5.46467e-01, 5.51864e-01, 5.57314e-01/
       DATA (KA_MO3( 4,JT,13),JT=1,19)  /
     & 4.66456e-01, 4.71080e-01, 4.75750e-01, 4.80467e-01, 4.85230e-01,
     & 4.90040e-01, 4.94898e-01, 4.99804e-01, 5.04759e-01, 5.09763e-01,
     & 5.14817e-01, 5.19920e-01, 5.25075e-01, 5.30280e-01, 5.35537e-01,
     & 5.40846e-01, 5.46208e-01, 5.51622e-01, 5.57091e-01/
       DATA (KA_MO3( 5,JT,13),JT=1,19)  /
     & 4.66853e-01, 4.71456e-01, 4.76104e-01, 4.80798e-01, 4.85539e-01,
     & 4.90326e-01, 4.95160e-01, 5.00042e-01, 5.04973e-01, 5.09952e-01,
     & 5.14979e-01, 5.20057e-01, 5.25185e-01, 5.30363e-01, 5.35592e-01,
     & 5.40873e-01, 5.46205e-01, 5.51591e-01, 5.57029e-01/
       DATA (KA_MO3( 6,JT,13),JT=1,19)  /
     & 4.66832e-01, 4.71448e-01, 4.76110e-01, 4.80817e-01, 4.85571e-01,
     & 4.90372e-01, 4.95221e-01, 5.00118e-01, 5.05063e-01, 5.10056e-01,
     & 5.15100e-01, 5.20193e-01, 5.25336e-01, 5.30531e-01, 5.35776e-01,
     & 5.41074e-01, 5.46424e-01, 5.51826e-01, 5.57283e-01/
       DATA (KA_MO3( 7,JT,13),JT=1,19)  /
     & 4.66679e-01, 4.71299e-01, 4.75965e-01, 4.80677e-01, 4.85436e-01,
     & 4.90241e-01, 4.95095e-01, 4.99996e-01, 5.04946e-01, 5.09945e-01,
     & 5.14993e-01, 5.20092e-01, 5.25240e-01, 5.30440e-01, 5.35692e-01,
     & 5.40995e-01, 5.46351e-01, 5.51759e-01, 5.57222e-01/
       DATA (KA_MO3( 8,JT,13),JT=1,19)  /
     & 4.66982e-01, 4.71598e-01, 4.76260e-01, 4.80967e-01, 4.85721e-01,
     & 4.90522e-01, 4.95371e-01, 5.00268e-01, 5.05213e-01, 5.10206e-01,
     & 5.15250e-01, 5.20343e-01, 5.25486e-01, 5.30680e-01, 5.35926e-01,
     & 5.41223e-01, 5.46573e-01, 5.51976e-01, 5.57432e-01/
       DATA (KA_MO3( 9,JT,13),JT=1,19)  /
     & 1.13709e-01, 1.13141e-01, 1.12576e-01, 1.12013e-01, 1.11453e-01,
     & 1.10897e-01, 1.10342e-01, 1.09791e-01, 1.09242e-01, 1.08696e-01,
     & 1.08153e-01, 1.07613e-01, 1.07075e-01, 1.06540e-01, 1.06007e-01,
     & 1.05478e-01, 1.04951e-01, 1.04426e-01, 1.03904e-01/
       DATA (KA_MO3( 1,JT,14),JT=1,19)  /
     & 5.67608e-01, 5.55796e-01, 5.44230e-01, 5.32904e-01, 5.21814e-01,
     & 5.10955e-01, 5.00322e-01, 4.89910e-01, 4.79714e-01, 4.69731e-01,
     & 4.59956e-01, 4.50384e-01, 4.41011e-01, 4.31834e-01, 4.22847e-01,
     & 4.14048e-01, 4.05431e-01, 3.96994e-01, 3.88732e-01/
       DATA (KA_MO3( 2,JT,14),JT=1,19)  /
     & 5.67766e-01, 5.55948e-01, 5.44376e-01, 5.33045e-01, 5.21950e-01,
     & 5.11086e-01, 5.00448e-01, 4.90031e-01, 4.79831e-01, 4.69844e-01,
     & 4.60064e-01, 4.50488e-01, 4.41111e-01, 4.31930e-01, 4.22939e-01,
     & 4.14136e-01, 4.05516e-01, 3.97075e-01, 3.88810e-01/
       DATA (KA_MO3( 3,JT,14),JT=1,19)  /
     & 5.67460e-01, 5.55647e-01, 5.44080e-01, 5.32754e-01, 5.21664e-01,
     & 5.10805e-01, 5.00172e-01, 4.89760e-01, 4.79564e-01, 4.69582e-01,
     & 4.59806e-01, 4.50235e-01, 4.40862e-01, 4.31685e-01, 4.22699e-01,
     & 4.13900e-01, 4.05284e-01, 3.96847e-01, 3.88586e-01/
       DATA (KA_MO3( 4,JT,14),JT=1,19)  /
     & 5.67925e-01, 5.56107e-01, 5.44536e-01, 5.33205e-01, 5.22110e-01,
     & 5.11246e-01, 5.00608e-01, 4.90191e-01, 4.79991e-01, 4.70004e-01,
     & 4.60224e-01, 4.50647e-01, 4.41270e-01, 4.32088e-01, 4.23097e-01,
     & 4.14293e-01, 4.05673e-01, 3.97231e-01, 3.88966e-01/
       DATA (KA_MO3( 5,JT,14),JT=1,19)  /
     & 5.67520e-01, 5.55733e-01, 5.44190e-01, 5.32887e-01, 5.21818e-01,
     & 5.10980e-01, 5.00366e-01, 4.89974e-01, 4.79797e-01, 4.69831e-01,
     & 4.60072e-01, 4.50516e-01, 4.41159e-01, 4.31996e-01, 4.23023e-01,
     & 4.14236e-01, 4.05633e-01, 3.97207e-01, 3.88957e-01/
       DATA (KA_MO3( 6,JT,14),JT=1,19)  /
     & 5.67549e-01, 5.55749e-01, 5.44195e-01, 5.32880e-01, 5.21801e-01,
     & 5.10952e-01, 5.00329e-01, 4.89927e-01, 4.79740e-01, 4.69766e-01,
     & 4.59999e-01, 4.50435e-01, 4.41070e-01, 4.31900e-01, 4.22920e-01,
     & 4.14127e-01, 4.05517e-01, 3.97086e-01, 3.88830e-01/
       DATA (KA_MO3( 7,JT,14),JT=1,19)  /
     & 5.67727e-01, 5.55909e-01, 5.44337e-01, 5.33005e-01, 5.21910e-01,
     & 5.11046e-01, 5.00408e-01, 4.89991e-01, 4.79791e-01, 4.69804e-01,
     & 4.60024e-01, 4.50448e-01, 4.41071e-01, 4.31890e-01, 4.22900e-01,
     & 4.14096e-01, 4.05476e-01, 3.97036e-01, 3.88771e-01/
       DATA (KA_MO3( 8,JT,14),JT=1,19)  /
     & 5.67795e-01, 5.55965e-01, 5.44381e-01, 5.33039e-01, 5.21933e-01,
     & 5.11058e-01, 5.00410e-01, 4.89984e-01, 4.79775e-01, 4.69779e-01,
     & 4.59991e-01, 4.50407e-01, 4.41023e-01, 4.31834e-01, 4.22836e-01,
     & 4.14026e-01, 4.05400e-01, 3.96953e-01, 3.88683e-01/
       DATA (KA_MO3( 9,JT,14),JT=1,19)  /
     & 1.32957e-01, 1.31737e-01, 1.30528e-01, 1.29330e-01, 1.28143e-01,
     & 1.26967e-01, 1.25802e-01, 1.24648e-01, 1.23504e-01, 1.22370e-01,
     & 1.21247e-01, 1.20135e-01, 1.19032e-01, 1.17940e-01, 1.16857e-01,
     & 1.15785e-01, 1.14722e-01, 1.13669e-01, 1.12626e-01/
       DATA (KA_MO3( 1,JT,15),JT=1,19)  /
     & 1.51281e-01, 1.53439e-01, 1.55628e-01, 1.57848e-01, 1.60100e-01,
     & 1.62384e-01, 1.64700e-01, 1.67049e-01, 1.69432e-01, 1.71849e-01,
     & 1.74301e-01, 1.76787e-01, 1.79309e-01, 1.81866e-01, 1.84461e-01,
     & 1.87092e-01, 1.89761e-01, 1.92468e-01, 1.95213e-01/
       DATA (KA_MO3( 2,JT,15),JT=1,19)  /
     & 1.51431e-01, 1.53589e-01, 1.55778e-01, 1.57998e-01, 1.60250e-01,
     & 1.62534e-01, 1.64850e-01, 1.67199e-01, 1.69582e-01, 1.71999e-01,
     & 1.74450e-01, 1.76937e-01, 1.79458e-01, 1.82016e-01, 1.84610e-01,
     & 1.87241e-01, 1.89909e-01, 1.92616e-01, 1.95361e-01/
       DATA (KA_MO3( 3,JT,15),JT=1,19)  /
     & 1.51299e-01, 1.53461e-01, 1.55654e-01, 1.57878e-01, 1.60134e-01,
     & 1.62422e-01, 1.64744e-01, 1.67098e-01, 1.69486e-01, 1.71908e-01,
     & 1.74364e-01, 1.76856e-01, 1.79383e-01, 1.81947e-01, 1.84547e-01,
     & 1.87184e-01, 1.89859e-01, 1.92572e-01, 1.95324e-01/
       DATA (KA_MO3( 4,JT,15),JT=1,19)  /
     & 1.51281e-01, 1.53439e-01, 1.55628e-01, 1.57848e-01, 1.60100e-01,
     & 1.62384e-01, 1.64700e-01, 1.67049e-01, 1.69432e-01, 1.71849e-01,
     & 1.74301e-01, 1.76787e-01, 1.79309e-01, 1.81866e-01, 1.84461e-01,
     & 1.87092e-01, 1.89761e-01, 1.92468e-01, 1.95213e-01/
       DATA (KA_MO3( 5,JT,15),JT=1,19)  /
     & 1.51281e-01, 1.53439e-01, 1.55628e-01, 1.57848e-01, 1.60100e-01,
     & 1.62384e-01, 1.64700e-01, 1.67049e-01, 1.69432e-01, 1.71849e-01,
     & 1.74301e-01, 1.76787e-01, 1.79309e-01, 1.81866e-01, 1.84461e-01,
     & 1.87092e-01, 1.89761e-01, 1.92468e-01, 1.95213e-01/
       DATA (KA_MO3( 6,JT,15),JT=1,19)  /
     & 1.51299e-01, 1.53461e-01, 1.55654e-01, 1.57878e-01, 1.60134e-01,
     & 1.62422e-01, 1.64744e-01, 1.67098e-01, 1.69486e-01, 1.71908e-01,
     & 1.74364e-01, 1.76856e-01, 1.79383e-01, 1.81947e-01, 1.84547e-01,
     & 1.87184e-01, 1.89859e-01, 1.92572e-01, 1.95324e-01/
       DATA (KA_MO3( 7,JT,15),JT=1,19)  /
     & 1.51299e-01, 1.53461e-01, 1.55654e-01, 1.57878e-01, 1.60134e-01,
     & 1.62422e-01, 1.64744e-01, 1.67098e-01, 1.69486e-01, 1.71908e-01,
     & 1.74364e-01, 1.76856e-01, 1.79383e-01, 1.81947e-01, 1.84547e-01,
     & 1.87184e-01, 1.89859e-01, 1.92572e-01, 1.95324e-01/
       DATA (KA_MO3( 8,JT,15),JT=1,19)  /
     & 1.51281e-01, 1.53439e-01, 1.55628e-01, 1.57848e-01, 1.60100e-01,
     & 1.62384e-01, 1.64700e-01, 1.67049e-01, 1.69432e-01, 1.71849e-01,
     & 1.74301e-01, 1.76787e-01, 1.79309e-01, 1.81866e-01, 1.84461e-01,
     & 1.87092e-01, 1.89761e-01, 1.92468e-01, 1.95213e-01/
       DATA (KA_MO3( 9,JT,15),JT=1,19)  /
     & 2.44180e-01, 2.35686e-01, 2.27487e-01, 2.19574e-01, 2.11935e-01,
     & 2.04563e-01, 1.97447e-01, 1.90578e-01, 1.83949e-01, 1.77550e-01,
     & 1.71373e-01, 1.65412e-01, 1.59658e-01, 1.54104e-01, 1.48743e-01,
     & 1.43569e-01, 1.38574e-01, 1.33754e-01, 1.29101e-01/
       DATA (KA_MO3( 1,JT,16),JT=1,19)  /
     & 1.02934e-01, 1.04369e-01, 1.05825e-01, 1.07300e-01, 1.08797e-01,
     & 1.10314e-01, 1.11852e-01, 1.13412e-01, 1.14993e-01, 1.16597e-01,
     & 1.18223e-01, 1.19871e-01, 1.21543e-01, 1.23238e-01, 1.24956e-01,
     & 1.26699e-01, 1.28466e-01, 1.30257e-01, 1.32073e-01/
       DATA (KA_MO3( 2,JT,16),JT=1,19)  /
     & 1.02934e-01, 1.04369e-01, 1.05825e-01, 1.07300e-01, 1.08797e-01,
     & 1.10314e-01, 1.11852e-01, 1.13412e-01, 1.14993e-01, 1.16597e-01,
     & 1.18223e-01, 1.19871e-01, 1.21543e-01, 1.23238e-01, 1.24956e-01,
     & 1.26699e-01, 1.28466e-01, 1.30257e-01, 1.32073e-01/
       DATA (KA_MO3( 3,JT,16),JT=1,19)  /
     & 1.02934e-01, 1.04369e-01, 1.05825e-01, 1.07300e-01, 1.08797e-01,
     & 1.10314e-01, 1.11852e-01, 1.13412e-01, 1.14993e-01, 1.16597e-01,
     & 1.18223e-01, 1.19871e-01, 1.21543e-01, 1.23238e-01, 1.24956e-01,
     & 1.26699e-01, 1.28466e-01, 1.30257e-01, 1.32073e-01/
       DATA (KA_MO3( 4,JT,16),JT=1,19)  /
     & 1.02934e-01, 1.04369e-01, 1.05825e-01, 1.07300e-01, 1.08797e-01,
     & 1.10314e-01, 1.11852e-01, 1.13412e-01, 1.14993e-01, 1.16597e-01,
     & 1.18223e-01, 1.19871e-01, 1.21543e-01, 1.23238e-01, 1.24956e-01,
     & 1.26699e-01, 1.28466e-01, 1.30257e-01, 1.32073e-01/
       DATA (KA_MO3( 5,JT,16),JT=1,19)  /
     & 1.02934e-01, 1.04369e-01, 1.05825e-01, 1.07300e-01, 1.08797e-01,
     & 1.10314e-01, 1.11852e-01, 1.13412e-01, 1.14993e-01, 1.16597e-01,
     & 1.18223e-01, 1.19871e-01, 1.21543e-01, 1.23238e-01, 1.24956e-01,
     & 1.26699e-01, 1.28466e-01, 1.30257e-01, 1.32073e-01/
       DATA (KA_MO3( 6,JT,16),JT=1,19)  /
     & 1.02934e-01, 1.04369e-01, 1.05825e-01, 1.07300e-01, 1.08797e-01,
     & 1.10314e-01, 1.11852e-01, 1.13412e-01, 1.14993e-01, 1.16597e-01,
     & 1.18223e-01, 1.19871e-01, 1.21543e-01, 1.23238e-01, 1.24956e-01,
     & 1.26699e-01, 1.28466e-01, 1.30257e-01, 1.32073e-01/
       DATA (KA_MO3( 7,JT,16),JT=1,19)  /
     & 1.02934e-01, 1.04369e-01, 1.05825e-01, 1.07300e-01, 1.08797e-01,
     & 1.10314e-01, 1.11852e-01, 1.13412e-01, 1.14993e-01, 1.16597e-01,
     & 1.18223e-01, 1.19871e-01, 1.21543e-01, 1.23238e-01, 1.24956e-01,
     & 1.26699e-01, 1.28466e-01, 1.30257e-01, 1.32073e-01/
       DATA (KA_MO3( 8,JT,16),JT=1,19)  /
     & 1.02934e-01, 1.04369e-01, 1.05825e-01, 1.07300e-01, 1.08797e-01,
     & 1.10314e-01, 1.11852e-01, 1.13412e-01, 1.14993e-01, 1.16597e-01,
     & 1.18223e-01, 1.19871e-01, 1.21543e-01, 1.23238e-01, 1.24956e-01,
     & 1.26699e-01, 1.28466e-01, 1.30257e-01, 1.32073e-01/
       DATA (KA_MO3( 9,JT,16),JT=1,19)  /
     & 3.91531e-01, 3.78978e-01, 3.66827e-01, 3.55067e-01, 3.43683e-01,
     & 3.32664e-01, 3.21999e-01, 3.11675e-01, 3.01683e-01, 2.92011e-01,
     & 2.82648e-01, 2.73586e-01, 2.64815e-01, 2.56325e-01, 2.48107e-01,
     & 2.40152e-01, 2.32453e-01, 2.25000e-01, 2.17787e-01/

C     The array FORREF contains the coefficient of the water vapor
C     foreign-continuum (including the energy term).  The first 
C     index refers to reference temperature (296,260,224,260) and 
C     pressure (970,475,219,3 mbar) levels.  The second index 
C     runs over the g-channel (1 to 16).

      DATA (FORREF(1,IG),IG=1,16) /
     &1.0689e-05,1.6987e-05,1.8993e-05,3.4470e-05,4.0873e-05,4.8275e-05,
     &6.1178e-05,6.4035e-05,6.6253e-05,7.8914e-05,8.1640e-05,7.9738e-05,
     &7.8492e-05,9.1565e-05,1.0262e-04,1.0368e-04/
      DATA (FORREF(2,IG),IG=1,16) /
     &1.1194e-05,1.6128e-05,1.7213e-05,2.6845e-05,4.1361e-05,5.1508e-05,
     &6.8245e-05,7.4063e-05,7.6273e-05,8.4061e-05,8.2492e-05,8.1720e-05,
     &7.7626e-05,1.0096e-04,1.0519e-04,1.0631e-04/
      DATA (FORREF(3,IG),IG=1,16) /
     &1.0891e-05,1.4933e-05,1.7964e-05,2.2577e-05,4.4290e-05,5.4675e-05,
     &7.2494e-05,7.8410e-05,7.6948e-05,7.5742e-05,7.7654e-05,8.2760e-05,
     &7.8443e-05,9.8384e-05,1.0634e-04,1.0838e-04/
      DATA (FORREF(4,IG),IG=1,16) /
     &1.1316e-05,1.5470e-05,2.1246e-05,3.3349e-05,4.8704e-05,5.6424e-05,
     &5.8569e-05,5.8780e-05,6.0358e-05,6.1586e-05,6.4281e-05,6.9333e-05,
     &7.2763e-05,7.2675e-05,7.3754e-05,1.0131e-04/

C     The array SELFREF contains the coefficient of the water vapor
C     self-continuum (including the energy term).  The first index
C     refers to temperature in 7.2 degree increments.  For instance,
C     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
C     etc.  The second index runs over the g-channel (1 to 16).

      DATA (SELFREF(JT, 1),JT=1,10)  /
     & 1.27686e-01, 1.09347e-01, 9.36410e-02, 8.01912e-02, 6.86732e-02,
     & 5.88096e-02, 5.03627e-02, 4.31290e-02, 3.69343e-02, 3.16294e-02/
      DATA (SELFREF(JT, 2),JT=1,10)  /
     & 1.40051e-01, 1.20785e-01, 1.04170e-01, 8.98402e-02, 7.74816e-02,
     & 6.68231e-02, 5.76308e-02, 4.97030e-02, 4.28658e-02, 3.69691e-02/
      DATA (SELFREF(JT, 3),JT=1,10)  /
     & 1.42322e-01, 1.22872e-01, 1.06080e-01, 9.15829e-02, 7.90671e-02,
     & 6.82616e-02, 5.89329e-02, 5.08790e-02, 4.39258e-02, 3.79228e-02/
      DATA (SELFREF(JT, 4),JT=1,10)  /
     & 1.53244e-01, 1.33057e-01, 1.15530e-01, 1.00311e-01, 8.70977e-02,
     & 7.56244e-02, 6.56626e-02, 5.70130e-02, 4.95028e-02, 4.29819e-02/
      DATA (SELFREF(JT, 5),JT=1,10)  /
     & 1.71011e-01, 1.46680e-01, 1.25810e-01, 1.07910e-01, 9.25563e-02,
     & 7.93874e-02, 6.80922e-02, 5.84040e-02, 5.00943e-02, 4.29669e-02/
      DATA (SELFREF(JT, 6),JT=1,10)  /
     & 1.76012e-01, 1.51010e-01, 1.29560e-01, 1.11157e-01, 9.53672e-02,
     & 8.18207e-02, 7.01984e-02, 6.02270e-02, 5.16720e-02, 4.43322e-02/
      DATA (SELFREF(JT, 7),JT=1,10)  /
     & 1.85600e-01, 1.59051e-01, 1.36300e-01, 1.16803e-01, 1.00095e-01,
     & 8.57776e-02, 7.35077e-02, 6.29930e-02, 5.39823e-02, 4.62606e-02/
      DATA (SELFREF(JT, 8),JT=1,10)  /
     & 1.88931e-01, 1.61727e-01, 1.38440e-01, 1.18506e-01, 1.01442e-01,
     & 8.68356e-02, 7.43321e-02, 6.36290e-02, 5.44670e-02, 4.66243e-02/
      DATA (SELFREF(JT, 9),JT=1,10)  /
     & 1.91122e-01, 1.63407e-01, 1.39710e-01, 1.19450e-01, 1.02128e-01,
     & 8.73176e-02, 7.46552e-02, 6.38290e-02, 5.45728e-02, 4.66589e-02/
      DATA (SELFREF(JT,10),JT=1,10)  /
     & 1.91334e-01, 1.64872e-01, 1.42070e-01, 1.22421e-01, 1.05490e-01,
     & 9.09008e-02, 7.83291e-02, 6.74960e-02, 5.81612e-02, 5.01174e-02/
      DATA (SELFREF(JT,11),JT=1,10)  /
     & 1.89858e-01, 1.63934e-01, 1.41550e-01, 1.22222e-01, 1.05534e-01,
     & 9.11237e-02, 7.86814e-02, 6.79380e-02, 5.86615e-02, 5.06517e-02/
      DATA (SELFREF(JT,12),JT=1,10)  /
     & 1.89783e-01, 1.63757e-01, 1.41300e-01, 1.21923e-01, 1.05203e-01,
     & 9.07760e-02, 7.83274e-02, 6.75860e-02, 5.83176e-02, 5.03202e-02/
      DATA (SELFREF(JT,13),JT=1,10)  /
     & 1.87534e-01, 1.62016e-01, 1.39970e-01, 1.20924e-01, 1.04470e-01,
     & 9.02541e-02, 7.79730e-02, 6.73630e-02, 5.81967e-02, 5.02778e-02/
      DATA (SELFREF(JT,14),JT=1,10)  /
     & 1.99128e-01, 1.71410e-01, 1.47550e-01, 1.27011e-01, 1.09332e-01,
     & 9.41131e-02, 8.10128e-02, 6.97360e-02, 6.00289e-02, 5.16731e-02/
      DATA (SELFREF(JT,15),JT=1,10)  /
     & 1.99460e-01, 1.72342e-01, 1.48910e-01, 1.28664e-01, 1.11171e-01,
     & 9.60560e-02, 8.29962e-02, 7.17120e-02, 6.19620e-02, 5.35376e-02/
      DATA (SELFREF(JT,16),JT=1,10)  /
     & 1.99906e-01, 1.72737e-01, 1.49260e-01, 1.28974e-01, 1.11445e-01,
     & 9.62982e-02, 8.32102e-02, 7.19010e-02, 6.21288e-02, 5.36848e-02/
