C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB07.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.0 $
C     created:   $Date: 2002/06/03 20:37:09 $
       PARAMETER (MG=16)
       DIMENSION SELFREF(10,MG), FORREF(4,MG)
       REAL KA(9,5,13,MG), KB(5,13:59,MG)
       REAL KA_MCO2(9,19,MG), KB_MCO2(19,MG)

       COMMON /HVRSN7/ HVRKG7

       COMMON /K7/ KA, KB, FORREF, SELFREF, KA_MCO2, KB_MCO2

       CHARACTER*15 HVRKG7
       DATA HVRKG7 /'$Revision: 3.0 $'/

C     The array KA contains absorption coefs for each of the 16 g-intervals
C     for a range of pressure levels > ~100mb, temperatures, and ratios
C     of water vapor to CO2.  The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.
C     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
C     to different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this  pressure 
C     level, JT = 2 refers to the temperature
C     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
C     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
C     to the reference pressure level (e.g. JP = 1 is for a
C     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA ((KA(JS,JT, 1, 1),JS=1,9),JT=1,5) /
     &2.0715E-06,2.0394E-06,5.0240E-06,1.0614E-05,1.1983E-05,1.5554E-05,
     &1.7831E-05,2.6227E-05,1.2374E-05,2.6968E-06,2.7207E-06,3.6723E-06,
     &1.1698E-05,1.3601E-05,1.5350E-05,2.0818E-05,2.8393E-05,1.1509E-05,
     &3.4058E-06,3.5757E-06,3.8081E-06,7.3554E-06,1.4372E-05,1.6368E-05,
     &1.9019E-05,3.0058E-05,1.1256E-05,4.2245E-06,4.8570E-06,4.7347E-06,
     &6.0087E-06,1.4347E-05,1.6902E-05,1.9725E-05,2.9609E-05,1.0323E-05,
     &5.1348E-06,6.1189E-06,5.9979E-06,6.4031E-06,9.6268E-06,1.7276E-05,
     &1.9533E-05,2.5577E-05,1.1200E-05/
      DATA ((KA(JS,JT, 2, 1),JS=1,9),JT=1,5) /
     &2.7400E-06,2.6398E-06,3.5715E-06,8.9653E-06,1.1704E-05,1.2732E-05,
     &1.5109E-05,1.8326E-05,7.6584E-06,3.7023E-06,3.5996E-06,3.5466E-06,
     &6.4138E-06,1.4301E-05,1.4484E-05,1.7298E-05,2.1003E-05,7.8450E-06,
     &4.8529E-06,4.7902E-06,4.4795E-06,5.2052E-06,1.0079E-05,1.6425E-05,
     &1.7110E-05,2.3533E-05,8.0830E-06,6.0952E-06,6.1266E-06,5.7794E-06,
     &5.6603E-06,7.5131E-06,1.6775E-05,1.7862E-05,2.1237E-05,6.9720E-06,
     &7.4621E-06,7.9816E-06,7.3755E-06,7.0507E-06,7.2782E-06,1.2172E-05,
     &1.8558E-05,2.1490E-05,7.0903E-06/
      DATA ((KA(JS,JT, 3, 1),JS=1,9),JT=1,5) /
     &4.8603E-06,4.7726E-06,4.1802E-06,5.2554E-06,9.0303E-06,1.4041E-05,
     &1.3465E-05,1.4273E-05,4.5115E-06,6.5045E-06,6.5033E-06,5.8343E-06,
     &5.3408E-06,7.3167E-06,1.4520E-05,1.5602E-05,1.7982E-05,4.5301E-06,
     &8.5550E-06,8.5301E-06,7.7170E-06,6.8750E-06,6.6921E-06,1.0610E-05,
     &1.8653E-05,1.7976E-05,3.9894E-06,1.0940E-05,1.0943E-05,9.9861E-06,
     &8.8481E-06,7.8291E-06,8.3918E-06,1.7829E-05,1.8992E-05,3.8512E-06,
     &1.3936E-05,1.3811E-05,1.2489E-05,1.1153E-05,9.8326E-06,8.7685E-06,
     &1.2193E-05,1.9703E-05,4.2059E-06/
      DATA ((KA(JS,JT, 4, 1),JS=1,9),JT=1,5) /
     &8.9960E-06,8.6210E-06,7.6632E-06,6.4630E-06,6.4239E-06,9.4367E-06,
     &1.6258E-05,1.3756E-05,2.4163E-06,1.2134E-05,1.1807E-05,1.0673E-05,
     &9.1029E-06,7.7016E-06,8.4861E-06,1.4567E-05,1.5036E-05,2.1658E-06,
     &1.6015E-05,1.5688E-05,1.4339E-05,1.2455E-05,1.0313E-05,8.5777E-06,
     &1.1331E-05,1.8116E-05,2.2633E-06,2.0597E-05,2.0155E-05,1.8480E-05,
     &1.6165E-05,1.3589E-05,1.0837E-05,9.4849E-06,2.1131E-05,2.4289E-06,
     &2.5729E-05,2.5473E-05,2.3255E-05,2.0429E-05,1.7213E-05,1.3828E-05,
     &1.0618E-05,1.5874E-05,3.2874E-06/
      DATA ((KA(JS,JT, 5, 1),JS=1,9),JT=1,5) /
     &1.6376E-05,1.4981E-05,1.3148E-05,1.1171E-05,9.2339E-06,7.8648E-06,
     &1.1215E-05,1.5160E-05,1.0907E-06,2.2074E-05,2.0407E-05,1.8083E-05,
     &1.5475E-05,1.2746E-05,1.0050E-05,1.0049E-05,1.8902E-05,1.3007E-06,
     &2.9048E-05,2.7094E-05,2.4278E-05,2.1033E-05,1.7417E-05,1.3618E-05,
     &1.0309E-05,1.5056E-05,1.4150E-06,3.7623E-05,3.5233E-05,3.1800E-05,
     &2.7623E-05,2.3164E-05,1.8269E-05,1.3014E-05,1.1951E-05,2.0520E-06,
     &4.7365E-05,4.4556E-05,4.0255E-05,3.5279E-05,2.9803E-05,2.3695E-05,
     &1.6824E-05,1.0864E-05,3.0931E-06/
      DATA ((KA(JS,JT, 6, 1),JS=1,9),JT=1,5) /
     &2.9059E-05,2.6117E-05,2.2727E-05,1.9184E-05,1.5516E-05,1.1998E-05,
     &9.5851E-06,1.6016E-05,6.6366E-07,3.9281E-05,3.5568E-05,3.1182E-05,
     &2.6432E-05,2.1505E-05,1.6402E-05,1.1717E-05,1.2828E-05,7.2868E-07,
     &5.2094E-05,4.7264E-05,4.1432E-05,3.5398E-05,2.9041E-05,2.2416E-05,
     &1.5568E-05,1.1439E-05,1.0703E-06,6.7466E-05,6.1301E-05,5.3945E-05,
     &4.6275E-05,3.8268E-05,2.9782E-05,2.0926E-05,1.2149E-05,1.6636E-06,
     &8.5711E-05,7.8253E-05,6.9113E-05,5.9588E-05,4.9429E-05,3.8720E-05,
     &2.7357E-05,1.5302E-05,2.4859E-06/
      DATA ((KA(JS,JT, 7, 1),JS=1,9),JT=1,5) /
     &5.4651E-05,4.8396E-05,4.1917E-05,3.5300E-05,2.8526E-05,2.1678E-05,
     &1.5027E-05,1.1124E-05,3.7210E-07,7.4826E-05,6.6392E-05,5.7621E-05,
     &4.8629E-05,3.9371E-05,2.9959E-05,2.0404E-05,1.1926E-05,4.6517E-07,
     &9.9886E-05,8.9008E-05,7.7375E-05,6.5427E-05,5.3175E-05,4.0667E-05,
     &2.7777E-05,1.4838E-05,7.6733E-07,1.3028E-04,1.1642E-04,1.0145E-04,
     &8.5974E-05,7.0058E-05,5.3698E-05,3.6993E-05,1.9660E-05,1.2756E-06,
     &1.6675E-04,1.4925E-04,1.3030E-04,1.1056E-04,9.0256E-05,6.9412E-05,
     &4.8077E-05,2.5971E-05,2.0598E-06/
      DATA ((KA(JS,JT, 8, 1),JS=1,9),JT=1,5) /
     &1.3360E-04,1.1739E-04,1.0102E-04,8.4552E-05,6.8007E-05,5.1398E-05,
     &3.4619E-05,1.8035E-05,1.9024E-07,1.8185E-04,1.6006E-04,1.3792E-04,
     &1.1564E-04,9.3245E-05,7.0615E-05,4.7676E-05,2.4529E-05,3.0949E-07,
     &2.4405E-04,2.1504E-04,1.8547E-04,1.5570E-04,1.2559E-04,9.5220E-05,
     &6.4517E-05,3.3270E-05,5.6654E-07,3.2056E-04,2.8296E-04,2.4441E-04,
     &2.0538E-04,1.6592E-04,1.2607E-04,8.5723E-05,4.4370E-05,1.0126E-06,
     &4.1126E-04,3.6352E-04,3.1426E-04,2.6419E-04,2.1364E-04,1.6265E-04,
     &1.1079E-04,5.7674E-05,1.7042E-06/
      DATA ((KA(JS,JT, 9, 1),JS=1,9),JT=1,5) /
     &6.2463E-04,5.4698E-04,4.6923E-04,3.9140E-04,3.1352E-04,2.3558E-04,
     &1.5756E-04,7.9405E-05,1.4148E-07,8.5834E-04,7.5200E-04,6.4533E-04,
     &5.3850E-04,4.3155E-04,3.2449E-04,2.1732E-04,1.0986E-04,2.9809E-07,
     &1.1576E-03,1.0147E-03,8.7098E-04,7.2712E-04,5.8298E-04,4.3871E-04,
     &2.9418E-04,1.4894E-04,5.9602E-07,1.5307E-03,1.3423E-03,1.1527E-03,
     &9.6254E-04,7.7214E-04,5.8148E-04,3.9028E-04,1.9773E-04,1.1255E-06,
     &1.9847E-03,1.7410E-03,1.4953E-03,1.2490E-03,1.0025E-03,7.5537E-04,
     &5.0679E-04,2.5732E-04,1.9162E-06/
      DATA ((KA(JS,JT,10, 1),JS=1,9),JT=1,5) /
     &3.6169E-03,3.1652E-03,2.7133E-03,2.2615E-03,1.8097E-03,1.3577E-03,
     &9.0574E-04,4.5358E-04,1.4845E-07,4.9699E-03,4.3495E-03,3.7290E-03,
     &3.1084E-03,2.4876E-03,1.8667E-03,1.2456E-03,6.2420E-04,3.2434E-07,
     &6.7347E-03,5.8945E-03,5.0543E-03,4.2138E-03,3.3728E-03,2.5314E-03,
     &1.6895E-03,8.4729E-04,6.8830E-07,8.9371E-03,7.8231E-03,6.7088E-03,
     &5.5938E-03,4.4779E-03,3.3612E-03,2.2441E-03,1.1262E-03,1.3449E-06,
     &1.1613E-02,1.0166E-02,8.7190E-03,7.2700E-03,5.8199E-03,4.3690E-03,
     &2.9176E-03,1.4653E-03,2.4729E-06/
      DATA ((KA(JS,JT,11, 1),JS=1,9),JT=1,5) /
     &8.2249E-03,7.1970E-03,6.1693E-03,5.1415E-03,4.1138E-03,3.0859E-03,
     &2.0579E-03,1.0298E-03,1.4864E-07,1.1270E-02,9.8625E-03,8.4545E-03,
     &7.0466E-03,5.6386E-03,4.2301E-03,2.8215E-03,1.4124E-03,3.4574E-07,
     &1.5223E-02,1.3322E-02,1.1421E-02,9.5200E-03,7.6187E-03,5.7167E-03,
     &3.8140E-03,1.9100E-03,7.2590E-07,2.0093E-02,1.7585E-02,1.5077E-02,
     &1.2568E-02,1.0059E-02,7.5477E-03,5.0358E-03,2.5228E-03,1.4168E-06,
     &2.5957E-02,2.2717E-02,1.9478E-02,1.6238E-02,1.2998E-02,9.7533E-03,
     &6.5080E-03,3.2606E-03,2.6860E-06/
      DATA ((KA(JS,JT,12, 1),JS=1,9),JT=1,5) /
     &1.1827E-02,1.0349E-02,8.8708E-03,7.3929E-03,5.9148E-03,4.4367E-03,
     &2.9587E-03,1.4802E-03,1.3931E-07,1.6211E-02,1.4185E-02,1.2160E-02,
     &1.0134E-02,8.1087E-03,6.0831E-03,4.0569E-03,2.0301E-03,3.2171E-07,
     &2.1828E-02,1.9101E-02,1.6374E-02,1.3648E-02,1.0921E-02,8.1937E-03,
     &5.4651E-03,2.7355E-03,6.8081E-07,2.8730E-02,2.5142E-02,2.1554E-02,
     &1.7967E-02,1.4379E-02,1.0788E-02,7.1961E-03,3.6027E-03,1.3459E-06,
     &3.6999E-02,3.2380E-02,2.7760E-02,2.3140E-02,1.8520E-02,1.3896E-02,
     &9.2700E-03,4.6424E-03,2.5690E-06/
      DATA ((KA(JS,JT,13, 1),JS=1,9),JT=1,5) /
     &1.3632E-02,1.1928E-02,1.0225E-02,8.5212E-03,6.8176E-03,5.1139E-03,
     &3.4100E-03,1.7059E-03,1.1695E-07,1.8706E-02,1.6369E-02,1.4031E-02,
     &1.1694E-02,9.3569E-03,7.0195E-03,4.6811E-03,2.3422E-03,2.7119E-07,
     &2.5132E-02,2.1993E-02,1.8852E-02,1.5713E-02,1.2573E-02,9.4331E-03,
     &6.2911E-03,3.1482E-03,5.7144E-07,3.3041E-02,2.8914E-02,2.4787E-02,
     &2.0660E-02,1.6533E-02,1.2406E-02,8.2739E-03,4.1414E-03,1.1335E-06,
     &4.2440E-02,3.7140E-02,3.1841E-02,2.6541E-02,2.1241E-02,1.5937E-02,
     &1.0630E-02,5.3218E-03,2.1676E-06/
      DATA ((KA(JS,JT, 1, 2),JS=1,9),JT=1,5) /
     &4.1413E-06,5.7568E-06,5.6875E-06,2.2265E-05,2.6421E-05,2.7053E-05,
     &2.9360E-05,4.0970E-05,1.4958E-05,5.1991E-06,7.4465E-06,7.4944E-06,
     &1.1514E-05,2.6560E-05,2.7448E-05,2.9314E-05,3.8310E-05,1.7668E-05,
     &6.3145E-06,9.3150E-06,9.9659E-06,1.0415E-05,2.4448E-05,2.8503E-05,
     &3.1282E-05,4.1769E-05,1.5395E-05,7.5825E-06,1.1197E-05,1.2631E-05,
     &1.2849E-05,1.2505E-05,2.7705E-05,3.1429E-05,4.1459E-05,1.9577E-05,
     &9.0691E-06,1.3548E-05,1.5444E-05,1.5939E-05,1.4634E-05,2.1478E-05,
     &3.0373E-05,4.6504E-05,1.5074E-05/
      DATA ((KA(JS,JT, 2, 2),JS=1,9),JT=1,5) /
     &6.1165E-06,7.4934E-06,6.8625E-06,7.6121E-06,3.0817E-05,3.2183E-05,
     &3.0483E-05,3.3496E-05,1.0690E-05,7.6538E-06,9.6280E-06,9.7301E-06,
     &8.1097E-06,1.6826E-05,3.2430E-05,3.0532E-05,3.1851E-05,9.7120E-06,
     &9.2709E-06,1.2057E-05,1.2568E-05,1.1762E-05,1.2621E-05,3.1032E-05,
     &3.2269E-05,3.2750E-05,1.1309E-05,1.1033E-05,1.5040E-05,1.5728E-05,
     &1.5466E-05,1.4259E-05,1.7169E-05,3.1754E-05,3.4497E-05,1.2084E-05,
     &1.2896E-05,1.7847E-05,1.9251E-05,1.9193E-05,1.8160E-05,1.5443E-05,
     &2.9856E-05,3.4316E-05,1.0107E-05/
      DATA ((KA(JS,JT, 3, 2),JS=1,9),JT=1,5) /
     &1.2491E-05,1.2769E-05,1.2392E-05,1.0198E-05,9.0495E-06,2.4479E-05,
     &4.2929E-05,3.4687E-05,5.7323E-06,1.5715E-05,1.6378E-05,1.5890E-05,
     &1.4699E-05,1.1686E-05,1.2801E-05,4.3476E-05,3.5317E-05,5.8828E-06,
     &1.9226E-05,2.0527E-05,2.0237E-05,1.8901E-05,1.6806E-05,1.2767E-05,
     &3.2801E-05,3.5650E-05,7.0460E-06,2.3182E-05,2.5284E-05,2.5183E-05,
     &2.3943E-05,2.1697E-05,1.8156E-05,1.6231E-05,3.6132E-05,6.5848E-06,
     &2.7146E-05,3.0591E-05,3.0801E-05,2.9528E-05,2.6930E-05,2.3450E-05,
     &1.7771E-05,3.6010E-05,8.7258E-06/
      DATA ((KA(JS,JT, 4, 2),JS=1,9),JT=1,5) /
     &2.6397E-05,2.4798E-05,2.2448E-05,1.9931E-05,1.6167E-05,1.1187E-05,
     &1.9967E-05,5.0094E-05,2.6889E-06,3.3110E-05,3.1403E-05,2.8621E-05,
     &2.5685E-05,2.2077E-05,1.6320E-05,1.2528E-05,5.0766E-05,3.5011E-06,
     &4.1079E-05,3.9262E-05,3.5800E-05,3.2065E-05,2.7986E-05,2.3135E-05,
     &1.5357E-05,4.2293E-05,3.6570E-06,4.9814E-05,4.8178E-05,4.4142E-05,
     &4.0008E-05,3.5086E-05,2.9575E-05,2.2305E-05,2.4338E-05,5.5271E-06,
     &5.8999E-05,5.7911E-05,5.3941E-05,4.9131E-05,4.3508E-05,3.6745E-05,
     &2.8595E-05,1.7749E-05,7.9465E-06/
      DATA ((KA(JS,JT, 5, 2),JS=1,9),JT=1,5) /
     &5.2146E-05,4.7415E-05,4.1895E-05,3.6100E-05,2.9831E-05,2.2853E-05,
     &1.2797E-05,3.5615E-05,1.8756E-06,6.6386E-05,6.0667E-05,5.3871E-05,
     &4.6587E-05,3.8801E-05,3.0645E-05,1.9749E-05,1.7747E-05,1.8651E-06,
     &8.2249E-05,7.5613E-05,6.7372E-05,5.8338E-05,4.8872E-05,3.9037E-05,
     &2.7917E-05,1.3785E-05,2.9415E-06,1.0042E-04,9.2832E-05,8.2527E-05,
     &7.1569E-05,6.0116E-05,4.8290E-05,3.5743E-05,1.9373E-05,4.5717E-06,
     &1.2062E-04,1.1245E-04,1.0036E-04,8.7051E-05,7.3237E-05,5.8949E-05,
     &4.4093E-05,2.6901E-05,6.6085E-06/
      DATA ((KA(JS,JT, 6, 2),JS=1,9),JT=1,5) /
     &9.7868E-05,8.7352E-05,7.6231E-05,6.4624E-05,5.2909E-05,4.0689E-05,
     &2.7103E-05,1.2458E-05,1.0529E-06,1.2683E-04,1.1378E-04,9.9028E-05,
     &8.4157E-05,6.8945E-05,5.3462E-05,3.6917E-05,1.5991E-05,1.3630E-06,
     &1.5959E-04,1.4323E-04,1.2528E-04,1.0669E-04,8.7707E-05,6.8030E-05,
     &4.7823E-05,2.4263E-05,2.3097E-06,1.9648E-04,1.7730E-04,1.5536E-04,
     &1.3239E-04,1.0876E-04,8.4595E-05,5.9848E-05,3.3068E-05,3.7113E-06,
     &2.3620E-04,2.1365E-04,1.8738E-04,1.5973E-04,1.3145E-04,1.0268E-04,
     &7.2957E-05,4.1703E-05,5.6387E-06/
      DATA ((KA(JS,JT, 7, 2),JS=1,9),JT=1,5) /
     &1.9683E-04,1.7373E-04,1.5000E-04,1.2604E-04,1.0197E-04,7.7797E-05,
     &5.2829E-05,2.4870E-05,6.2713E-07,2.5760E-04,2.2793E-04,1.9707E-04,
     &1.6593E-04,1.3495E-04,1.0291E-04,7.0455E-05,3.6046E-05,1.0898E-06,
     &3.2772E-04,2.9045E-04,2.5191E-04,2.1251E-04,1.7232E-04,1.3160E-04,
     &9.0425E-05,4.7870E-05,1.9368E-06,4.0755E-04,3.6253E-04,3.1479E-04,
     &2.6553E-04,2.1537E-04,1.6486E-04,1.1337E-04,6.0602E-05,3.1700E-06,
     &4.9614E-04,4.4343E-04,3.8479E-04,3.2448E-04,2.6368E-04,2.0203E-04,
     &1.3939E-04,7.4791E-05,4.9446E-06/
      DATA ((KA(JS,JT, 8, 2),JS=1,9),JT=1,5) /
     &5.0097E-04,4.3939E-04,3.7796E-04,3.1605E-04,2.5384E-04,1.9144E-04,
     &1.2886E-04,6.5770E-05,4.5473E-07,6.6297E-04,5.8193E-04,5.0094E-04,
     &4.1901E-04,3.3675E-04,2.5431E-04,1.7173E-04,8.8413E-05,9.2809E-07,
     &8.5051E-04,7.4751E-04,6.4368E-04,5.3885E-04,4.3363E-04,3.2808E-04,
     &2.2228E-04,1.1512E-04,1.7364E-06,1.0693E-03,9.4111E-04,8.1096E-04,
     &6.7960E-04,5.4760E-04,4.1579E-04,2.8187E-04,1.4563E-04,2.9681E-06,
     &1.3123E-03,1.1563E-03,9.9722E-04,8.3695E-04,6.7599E-04,5.1257E-04,
     &3.4753E-04,1.7994E-04,4.7447E-06/
      DATA ((KA(JS,JT, 9, 2),JS=1,9),JT=1,5) /
     &2.4740E-03,2.1654E-03,1.8568E-03,1.5484E-03,1.2400E-03,9.3161E-04,
     &6.2283E-04,3.1298E-04,4.6685E-07,3.2850E-03,2.8753E-03,2.4661E-03,
     &2.0570E-03,1.6482E-03,1.2389E-03,8.2844E-04,4.1698E-04,9.7197E-07,
     &4.2422E-03,3.7138E-03,3.1860E-03,2.6588E-03,2.1312E-03,1.6022E-03,
     &1.0719E-03,5.4052E-04,1.8767E-06,5.3553E-03,4.6891E-03,4.0243E-03,
     &3.3598E-03,2.6939E-03,2.0261E-03,1.3568E-03,6.8626E-04,3.3456E-06,
     &6.6220E-03,5.7995E-03,4.9792E-03,4.1587E-03,3.3345E-03,2.5085E-03,
     &1.6821E-03,8.5317E-04,5.6245E-06/
      DATA ((KA(JS,JT,10, 2),JS=1,9),JT=1,5) /
     &1.5050E-02,1.3169E-02,1.1289E-02,9.4076E-03,7.5270E-03,5.6463E-03,
     &3.7658E-03,1.8853E-03,4.7266E-07,1.9971E-02,1.7476E-02,1.4981E-02,
     &1.2485E-02,9.9900E-03,7.4947E-03,4.9999E-03,2.5053E-03,1.0606E-06,
     &2.5996E-02,2.2748E-02,1.9499E-02,1.6252E-02,1.3005E-02,9.7575E-03,
     &6.5102E-03,3.2633E-03,2.1957E-06,3.3067E-02,2.8935E-02,2.4804E-02,
     &2.0673E-02,1.6543E-02,1.2414E-02,8.2853E-03,4.1549E-03,4.2322E-06,
     &4.1113E-02,3.5978E-02,3.0842E-02,2.5708E-02,2.0575E-02,1.5443E-02,
     &1.0311E-02,5.1716E-03,7.6651E-06/
      DATA ((KA(JS,JT,11, 2),JS=1,9),JT=1,5) /
     &3.5447E-02,3.1017E-02,2.6586E-02,2.2156E-02,1.7726E-02,1.3295E-02,
     &8.8649E-03,4.4348E-03,5.0606E-07,4.6742E-02,4.0900E-02,3.5058E-02,
     &2.9216E-02,2.3374E-02,1.7532E-02,1.1691E-02,5.8504E-03,1.1095E-06,
     &6.0406E-02,5.2857E-02,4.5306E-02,3.7757E-02,3.0208E-02,2.2660E-02,
     &1.5111E-02,7.5645E-03,2.3165E-06,7.6519E-02,6.6955E-02,5.7393E-02,
     &4.7830E-02,3.8268E-02,2.8708E-02,1.9148E-02,9.5895E-03,4.5048E-06,
     &9.5074E-02,8.3196E-02,7.1315E-02,5.9435E-02,4.7553E-02,3.5677E-02,
     &2.3800E-02,1.1926E-02,8.0597E-06/
      DATA ((KA(JS,JT,12, 2),JS=1,9),JT=1,5) /
     &5.2692E-02,4.6104E-02,3.9518E-02,3.2933E-02,2.6346E-02,1.9761E-02,
     &1.3176E-02,6.5900E-03,4.7314E-07,6.9235E-02,6.0581E-02,5.1926E-02,
     &4.3273E-02,3.4620E-02,2.5967E-02,1.7314E-02,8.6616E-03,1.0517E-06,
     &8.9222E-02,7.8070E-02,6.6918E-02,5.5767E-02,4.4616E-02,3.3465E-02,
     &2.2315E-02,1.1167E-02,2.1820E-06,1.1266E-01,9.8579E-02,8.4496E-02,
     &7.0418E-02,5.6336E-02,4.2258E-02,2.8182E-02,1.4107E-02,4.2014E-06,
     &1.3942E-01,1.2199E-01,1.0457E-01,8.7148E-02,6.9722E-02,5.2304E-02,
     &3.4887E-02,1.7469E-02,7.4819E-06/
      DATA ((KA(JS,JT,13, 2),JS=1,9),JT=1,5) /
     &6.2876E-02,5.5018E-02,4.7159E-02,3.9299E-02,3.1440E-02,2.3581E-02,
     &1.5722E-02,7.8632E-03,4.0954E-07,8.2400E-02,7.2100E-02,6.1801E-02,
     &5.1502E-02,4.1203E-02,3.0903E-02,2.0605E-02,1.0307E-02,9.1322E-07,
     &1.0586E-01,9.2633E-02,7.9402E-02,6.6169E-02,5.2938E-02,3.9706E-02,
     &2.6476E-02,1.3248E-02,1.8983E-06,1.3330E-01,1.1664E-01,9.9979E-02,
     &8.3320E-02,6.6657E-02,4.9998E-02,3.3342E-02,1.6688E-02,3.6054E-06,
     &1.6451E-01,1.4395E-01,1.2339E-01,1.0283E-01,8.2267E-02,6.1710E-02,
     &4.1158E-02,2.0605E-02,6.1726E-06/
      DATA ((KA(JS,JT, 1, 3),JS=1,9),JT=1,5) /
     &1.0158E-05,1.3198E-05,1.2933E-05,1.7710E-05,3.0455E-05,3.0829E-05,
     &3.6460E-05,4.7058E-05,1.7479E-05,1.1438E-05,1.5570E-05,1.6943E-05,
     &1.4755E-05,2.6165E-05,3.0134E-05,3.4781E-05,5.6113E-05,2.1722E-05,
     &1.2956E-05,1.8129E-05,1.9971E-05,1.8485E-05,1.6628E-05,3.1264E-05,
     &3.4010E-05,5.1158E-05,2.4518E-05,1.4615E-05,2.0830E-05,2.2660E-05,
     &2.2625E-05,1.9967E-05,2.4812E-05,3.9103E-05,5.0423E-05,1.7758E-05,
     &1.6017E-05,2.3480E-05,2.5498E-05,2.6186E-05,2.5773E-05,1.9360E-05,
     &3.6373E-05,5.8002E-05,2.1777E-05/
      DATA ((KA(JS,JT, 2, 3),JS=1,9),JT=1,5) /
     &1.6325E-05,1.8415E-05,1.8317E-05,1.4470E-05,2.4482E-05,3.9161E-05,
     &3.6427E-05,3.6776E-05,1.2226E-05,1.8436E-05,2.1492E-05,2.2101E-05,
     &2.0928E-05,1.7486E-05,3.4569E-05,3.4173E-05,4.1432E-05,1.6945E-05,
     &2.0725E-05,2.4812E-05,2.5608E-05,2.5315E-05,2.0861E-05,2.2865E-05,
     &3.3858E-05,3.7106E-05,1.4100E-05,2.3257E-05,2.7888E-05,2.9222E-05,
     &2.9285E-05,2.7055E-05,2.2581E-05,3.3589E-05,3.8281E-05,1.2084E-05,
     &2.5809E-05,3.1443E-05,3.3009E-05,3.2988E-05,3.1499E-05,2.8005E-05,
     &2.1824E-05,4.6522E-05,1.8788E-05/
      DATA ((KA(JS,JT, 3, 3),JS=1,9),JT=1,5) /
     &3.6153E-05,3.6160E-05,3.3889E-05,3.0515E-05,2.3824E-05,2.0510E-05,
     &5.5046E-05,4.3679E-05,8.4874E-06,4.1441E-05,4.2015E-05,3.9744E-05,
     &3.6451E-05,3.1872E-05,2.2157E-05,3.7036E-05,4.0290E-05,7.7192E-06,
     &4.6667E-05,4.8191E-05,4.5785E-05,4.2457E-05,3.7818E-05,3.1272E-05,
     &2.3354E-05,3.9936E-05,6.8348E-06,5.1877E-05,5.4060E-05,5.1719E-05,
     &4.8126E-05,4.3652E-05,3.8051E-05,2.7576E-05,4.1113E-05,1.0881E-05,
     &5.7673E-05,6.0087E-05,5.7843E-05,5.4035E-05,4.9732E-05,4.3859E-05,
     &3.4661E-05,3.3926E-05,1.5564E-05/
      DATA ((KA(JS,JT, 4, 3),JS=1,9),JT=1,5) /
     &8.1569E-05,7.6506E-05,6.9052E-05,6.0598E-05,5.1130E-05,3.9208E-05,
     &2.1647E-05,7.1331E-05,4.7464E-06,9.5409E-05,8.9513E-05,8.1016E-05,
     &7.1228E-05,6.0322E-05,4.8270E-05,3.1172E-05,4.9123E-05,3.8536E-06,
     &1.0835E-04,1.0286E-04,9.3383E-05,8.2438E-05,7.0089E-05,5.7019E-05,
     &4.1480E-05,3.2272E-05,5.8347E-06,1.2088E-04,1.1587E-04,1.0589E-04,
     &9.3297E-05,7.9862E-05,6.5329E-05,4.9231E-05,2.5421E-05,9.1036E-06,
     &1.3349E-04,1.2852E-04,1.1738E-04,1.0384E-04,8.9286E-05,7.3614E-05,
     &5.6906E-05,3.4260E-05,1.3290E-05/
      DATA ((KA(JS,JT, 5, 3),JS=1,9),JT=1,5) /
     &1.7345E-04,1.5727E-04,1.3841E-04,1.1872E-04,9.8241E-05,7.6833E-05,
     &5.2762E-05,2.6555E-05,1.9880E-06,2.0342E-04,1.8508E-04,1.6349E-04,
     &1.4064E-04,1.1678E-04,9.1597E-05,6.4678E-05,2.5634E-05,3.0971E-06,
     &2.3455E-04,2.1397E-04,1.8954E-04,1.6295E-04,1.3528E-04,1.0632E-04,
     &7.5971E-05,4.0302E-05,5.0300E-06,2.6426E-04,2.4201E-04,2.1476E-04,
     &1.8503E-04,1.5431E-04,1.2132E-04,8.7057E-05,4.9691E-05,7.6275E-06,
     &2.9276E-04,2.6878E-04,2.3851E-04,2.0652E-04,1.7242E-04,1.3630E-04,
     &9.8498E-05,5.7853E-05,1.1134E-05/
      DATA ((KA(JS,JT, 6, 3),JS=1,9),JT=1,5) /
     &3.5315E-04,3.1458E-04,2.7325E-04,2.3096E-04,1.8808E-04,1.4453E-04,
     &9.9918E-05,4.6331E-05,1.2347E-06,4.1518E-04,3.7021E-04,3.2222E-04,
     &2.7318E-04,2.2345E-04,1.7257E-04,1.2006E-04,6.3507E-05,2.6453E-06,
     &4.8020E-04,4.2942E-04,3.7435E-04,3.1847E-04,2.6105E-04,2.0180E-04,
     &1.4068E-04,7.6253E-05,4.2798E-06,5.4571E-04,4.8797E-04,4.2639E-04,
     &3.6432E-04,2.9826E-04,2.3028E-04,1.6074E-04,8.8155E-05,6.6580E-06,
     &6.1051E-04,5.4685E-04,4.8080E-04,4.0919E-04,3.3486E-04,2.5913E-04,
     &1.8080E-04,9.9384E-05,9.9722E-06/
      DATA ((KA(JS,JT, 7, 3),JS=1,9),JT=1,5) /
     &7.5693E-04,6.6624E-04,5.7513E-04,4.8344E-04,3.9061E-04,2.9600E-04,
     &2.0095E-04,1.0427E-04,1.0591E-06,8.9608E-04,7.8973E-04,6.8311E-04,
     &5.7440E-04,4.6329E-04,3.5236E-04,2.4053E-04,1.2653E-04,2.0677E-06,
     &1.0434E-03,9.2160E-04,7.9776E-04,6.7036E-04,5.4238E-04,4.1393E-04,
     &2.8414E-04,1.5011E-04,3.4509E-06,1.1912E-03,1.0536E-03,9.1065E-04,
     &7.6644E-04,6.2208E-04,4.7601E-04,3.2680E-04,1.7285E-04,5.5547E-06,
     &1.3354E-03,1.1809E-03,1.0220E-03,8.6241E-04,7.0147E-04,5.3735E-04,
     &3.6893E-04,1.9541E-04,8.3477E-06/
      DATA ((KA(JS,JT, 8, 3),JS=1,9),JT=1,5) /
     &2.0322E-03,1.7810E-03,1.5293E-03,1.2777E-03,1.0262E-03,7.7431E-04,
     &5.2105E-04,2.6538E-04,9.6103E-07,2.4399E-03,2.1393E-03,1.8380E-03,
     &1.5373E-03,1.2364E-03,9.3375E-04,6.2913E-04,3.2110E-04,1.7921E-06,
     &2.8537E-03,2.5030E-03,2.1528E-03,1.8027E-03,1.4507E-03,1.0966E-03,
     &7.3847E-04,3.7883E-04,3.0446E-06,3.2833E-03,2.8808E-03,2.4800E-03,
     &2.0779E-03,1.6729E-03,1.2622E-03,8.5179E-04,4.3974E-04,4.8671E-06,
     &3.6992E-03,3.2483E-03,2.7990E-03,2.3454E-03,1.8857E-03,1.4259E-03,
     &9.6561E-04,4.9917E-04,7.5866E-06/
      DATA ((KA(JS,JT, 9, 3),JS=1,9),JT=1,5) /
     &1.0280E-02,8.9965E-03,7.7134E-03,6.4300E-03,5.1466E-03,3.8628E-03,
     &2.5792E-03,1.2964E-03,9.2162E-07,1.2564E-02,1.0997E-02,9.4289E-03,
     &7.8609E-03,6.2929E-03,4.7248E-03,3.1577E-03,1.5902E-03,1.8412E-06,
     &1.4876E-02,1.3021E-02,1.1166E-02,9.3099E-03,7.4544E-03,5.6000E-03,
     &3.7464E-03,1.8890E-03,3.6551E-06,1.7233E-02,1.5085E-02,1.2936E-02,
     &1.0788E-02,8.6402E-03,6.4946E-03,4.3480E-03,2.1937E-03,6.4505E-06,
     &1.9529E-02,1.7097E-02,1.4665E-02,1.2232E-02,9.8022E-03,7.3739E-03,
     &4.9380E-03,2.4934E-03,1.0329E-05/
      DATA ((KA(JS,JT,10, 3),JS=1,9),JT=1,5) /
     &6.2934E-02,5.5068E-02,4.7203E-02,3.9337E-02,3.1472E-02,2.3606E-02,
     &1.5740E-02,7.8743E-03,1.2141E-06,7.7985E-02,6.8239E-02,5.8492E-02,
     &4.8746E-02,3.8999E-02,2.9252E-02,1.9507E-02,9.7597E-03,2.5517E-06,
     &9.3312E-02,8.1650E-02,6.9991E-02,5.8328E-02,4.6667E-02,3.5007E-02,
     &2.3345E-02,1.1684E-02,4.6909E-06,1.0852E-01,9.4962E-02,8.1401E-02,
     &6.7840E-02,5.4279E-02,4.0718E-02,2.7157E-02,1.3598E-02,7.7426E-06,
     &1.2387E-01,1.0840E-01,9.2920E-02,7.7443E-02,6.1965E-02,4.6488E-02,
     &3.1009E-02,1.5537E-02,1.2033E-05/
      DATA ((KA(JS,JT,11, 3),JS=1,9),JT=1,5) /
     &1.4431E-01,1.2627E-01,1.0823E-01,9.0195E-02,7.2157E-02,5.4120E-02,
     &3.6082E-02,1.8045E-02,1.2885E-06,1.7767E-01,1.5546E-01,1.3326E-01,
     &1.1105E-01,8.8842E-02,6.6637E-02,4.4429E-02,2.2220E-02,2.6746E-06,
     &2.1192E-01,1.8543E-01,1.5895E-01,1.3246E-01,1.0597E-01,7.9483E-02,
     &5.2995E-02,2.6507E-02,4.8840E-06,2.4571E-01,2.1501E-01,1.8430E-01,
     &1.5358E-01,1.2287E-01,9.2163E-02,6.1452E-02,3.0740E-02,7.9723E-06,
     &2.7981E-01,2.4483E-01,2.0987E-01,1.7490E-01,1.3993E-01,1.0496E-01,
     &6.9988E-02,3.5019E-02,1.2223E-05/
      DATA ((KA(JS,JT,12, 3),JS=1,9),JT=1,5) /
     &2.0829E-01,1.8226E-01,1.5622E-01,1.3018E-01,1.0415E-01,7.8112E-02,
     &5.2077E-02,2.6041E-02,1.2025E-06,2.5587E-01,2.2388E-01,1.9190E-01,
     &1.5992E-01,1.2794E-01,9.5954E-02,6.3973E-02,3.1992E-02,2.4634E-06,
     &3.0401E-01,2.6600E-01,2.2801E-01,1.9001E-01,1.5201E-01,1.1401E-01,
     &7.6014E-02,3.8015E-02,4.4929E-06,3.5185E-01,3.0787E-01,2.6390E-01,
     &2.1992E-01,1.7594E-01,1.3196E-01,8.7984E-02,4.4005E-02,7.2358E-06,
     &3.9955E-01,3.4961E-01,2.9967E-01,2.4973E-01,1.9980E-01,1.4985E-01,
     &9.9920E-02,4.9982E-02,1.1171E-05/
      DATA ((KA(JS,JT,13, 3),JS=1,9),JT=1,5) /
     &2.4192E-01,2.1167E-01,1.8143E-01,1.5120E-01,1.2096E-01,9.0718E-02,
     &6.0481E-02,3.0243E-02,1.0138E-06,2.9636E-01,2.5932E-01,2.2227E-01,
     &1.8523E-01,1.4819E-01,1.1114E-01,7.4096E-02,3.7053E-02,2.0810E-06,
     &3.5109E-01,3.0721E-01,2.6332E-01,2.1944E-01,1.7555E-01,1.3167E-01,
     &8.7782E-02,4.3898E-02,3.6752E-06,4.0523E-01,3.5457E-01,3.0393E-01,
     &2.5327E-01,2.0263E-01,1.5197E-01,1.0132E-01,5.0676E-02,6.1123E-06,
     &4.5914E-01,4.0175E-01,3.4437E-01,2.8698E-01,2.2959E-01,1.7221E-01,
     &1.1482E-01,5.7432E-02,9.7404E-06/
      DATA ((KA(JS,JT, 1, 4),JS=1,9),JT=1,5) /
     &2.1350E-05,2.4552E-05,2.3723E-05,1.5777E-05,2.7169E-05,3.2921E-05,
     &3.9368E-05,6.8629E-05,2.6626E-05,2.2878E-05,2.6833E-05,2.6737E-05,
     &2.0377E-05,2.2142E-05,3.1966E-05,4.1566E-05,6.1320E-05,2.3858E-05,
     &2.3851E-05,2.8963E-05,2.9322E-05,2.7907E-05,1.9726E-05,2.5598E-05,
     &4.2650E-05,6.7498E-05,2.1250E-05,2.4297E-05,3.1053E-05,3.2431E-05,
     &3.1771E-05,2.7799E-05,2.0892E-05,3.7144E-05,7.1944E-05,2.3747E-05,
     &2.4515E-05,3.3133E-05,3.5554E-05,3.5376E-05,3.4171E-05,2.9240E-05,
     &2.7955E-05,6.5059E-05,3.8779E-05/
      DATA ((KA(JS,JT, 2, 4),JS=1,9),JT=1,5) /
     &3.5233E-05,3.6967E-05,3.5192E-05,3.0346E-05,1.9517E-05,3.6227E-05,
     &3.6486E-05,4.4755E-05,1.7210E-05,3.7659E-05,4.0104E-05,3.8633E-05,
     &3.5461E-05,2.4007E-05,2.9205E-05,3.6839E-05,4.4274E-05,1.6582E-05,
     &3.9567E-05,4.2994E-05,4.2107E-05,3.9324E-05,3.3808E-05,2.0621E-05,
     &3.2387E-05,5.0199E-05,1.2696E-05,4.0697E-05,4.5929E-05,4.5740E-05,
     &4.2992E-05,3.9709E-05,2.8967E-05,2.4180E-05,4.8120E-05,2.0582E-05,
     &4.1514E-05,4.8565E-05,4.9023E-05,4.7662E-05,4.4382E-05,3.8389E-05,
     &2.5686E-05,4.1842E-05,3.1906E-05/
      DATA ((KA(JS,JT, 3, 4),JS=1,9),JT=1,5) /
     &8.1562E-05,7.8380E-05,7.1455E-05,6.3207E-05,5.2782E-05,3.3109E-05,
     &4.1621E-05,4.2434E-05,8.8242E-06,8.6593E-05,8.4470E-05,7.7554E-05,
     &6.8896E-05,5.8997E-05,4.4824E-05,3.0840E-05,4.1510E-05,8.5693E-06,
     &9.1353E-05,8.9996E-05,8.3114E-05,7.4541E-05,6.4935E-05,5.3159E-05,
     &2.8537E-05,3.9838E-05,1.1226E-05,9.5365E-05,9.5648E-05,8.9016E-05,
     &8.0719E-05,7.0818E-05,5.8632E-05,4.0977E-05,3.3245E-05,1.8214E-05,
     &9.7542E-05,1.0001E-04,9.4766E-05,8.7247E-05,7.6489E-05,6.4569E-05,
     &5.1322E-05,2.4346E-05,2.6190E-05/
      DATA ((KA(JS,JT, 4, 4),JS=1,9),JT=1,5) /
     &1.9526E-04,1.7866E-04,1.5808E-04,1.3593E-04,1.1271E-04,8.7918E-05,
     &5.1266E-05,5.4774E-05,4.6025E-06,2.0650E-04,1.9062E-04,1.6960E-04,
     &1.4698E-04,1.2286E-04,9.7273E-05,6.7543E-05,4.4150E-05,5.6277E-06,
     &2.1739E-04,2.0276E-04,1.8135E-04,1.5734E-04,1.3233E-04,1.0548E-04,
     &7.6274E-05,3.0228E-05,9.8992E-06,2.2749E-04,2.1410E-04,1.9235E-04,
     &1.6801E-04,1.4178E-04,1.1383E-04,8.3889E-05,3.8831E-05,1.4832E-05,
     &2.3672E-04,2.2535E-04,2.0298E-04,1.7817E-04,1.5157E-04,1.2285E-04,
     &9.1248E-05,5.4055E-05,2.0953E-05/
      DATA ((KA(JS,JT, 5, 4),JS=1,9),JT=1,5) /
     &4.3901E-04,3.9096E-04,3.4083E-04,2.8855E-04,2.3566E-04,1.8135E-04,
     &1.2520E-04,3.9791E-05,2.8698E-06,4.6450E-04,4.1602E-04,3.6285E-04,
     &3.0879E-04,2.5330E-04,1.9642E-04,1.3685E-04,6.9096E-05,4.7432E-06,
     &4.8882E-04,4.4052E-04,3.8581E-04,3.3048E-04,2.7253E-04,2.1160E-04,
     &1.4899E-04,8.1167E-05,8.1879E-06,5.1005E-04,4.6303E-04,4.0950E-04,
     &3.5246E-04,2.9060E-04,2.2675E-04,1.6042E-04,8.9994E-05,1.2389E-05,
     &5.2999E-04,4.8642E-04,4.3340E-04,3.7157E-04,3.0721E-04,2.4050E-04,
     &1.7156E-04,9.8341E-05,1.7831E-05/
      DATA ((KA(JS,JT, 6, 4),JS=1,9),JT=1,5) /
     &9.3945E-04,8.2623E-04,7.1331E-04,5.9949E-04,4.8483E-04,3.6836E-04,
     &2.5086E-04,1.2938E-04,2.1494E-06,1.0016E-03,8.8499E-04,7.6750E-04,
     &6.4657E-04,5.2304E-04,3.9902E-04,2.7391E-04,1.4413E-04,3.8318E-06,
     &1.0547E-03,9.3464E-04,8.1142E-04,6.8349E-04,5.5479E-04,4.2609E-04,
     &2.9394E-04,1.5646E-04,6.4475E-06,1.1032E-03,9.8345E-04,8.5527E-04,
     &7.2211E-04,5.9000E-04,4.5529E-04,3.1446E-04,1.6904E-04,9.9612E-06,
     &1.1467E-03,1.0269E-03,8.9466E-04,7.6180E-04,6.2654E-04,4.8317E-04,
     &3.3526E-04,1.8155E-04,1.4635E-05/
      DATA ((KA(JS,JT, 7, 4),JS=1,9),JT=1,5) /
     &2.0968E-03,1.8382E-03,1.5799E-03,1.3200E-03,1.0602E-03,8.0055E-04,
     &5.3931E-04,2.7613E-04,1.7495E-06,2.2692E-03,1.9926E-03,1.7142E-03,
     &1.4356E-03,1.1561E-03,8.7560E-04,5.9192E-04,3.0494E-04,3.2823E-06,
     &2.3957E-03,2.1065E-03,1.8155E-03,1.5242E-03,1.2302E-03,9.3213E-04,
     &6.3098E-04,3.2845E-04,5.4452E-06,2.5154E-03,2.2153E-03,1.9155E-03,
     &1.6120E-03,1.3009E-03,9.8717E-04,6.7313E-04,3.5215E-04,8.4591E-06,
     &2.6221E-03,2.3149E-03,2.0078E-03,1.6896E-03,1.3663E-03,1.0418E-03,
     &7.1380E-04,3.7558E-04,1.3208E-05/
      DATA ((KA(JS,JT, 8, 4),JS=1,9),JT=1,5) /
     &5.9687E-03,5.2249E-03,4.4818E-03,3.7390E-03,2.9959E-03,2.2513E-03,
     &1.5068E-03,7.6107E-04,1.5072E-06,6.4060E-03,5.6103E-03,4.8155E-03,
     &4.0184E-03,3.2203E-03,2.4232E-03,1.6246E-03,8.2361E-04,2.9177E-06,
     &6.8363E-03,5.9919E-03,5.1443E-03,4.2950E-03,3.4467E-03,2.5980E-03,
     &1.7471E-03,8.8934E-04,5.0920E-06,7.1796E-03,6.2954E-03,5.4063E-03,
     &4.5177E-03,3.6307E-03,2.7430E-03,1.8488E-03,9.4284E-04,8.3290E-06,
     &7.5276E-03,6.6017E-03,5.6732E-03,4.7473E-03,3.8229E-03,2.8925E-03,
     &1.9515E-03,1.0013E-03,1.2816E-05/
      DATA ((KA(JS,JT, 9, 4),JS=1,9),JT=1,5) /
     &3.2487E-02,2.8428E-02,2.4369E-02,2.0309E-02,1.6251E-02,1.2192E-02,
     &8.1342E-03,4.0755E-03,1.9489E-06,3.4271E-02,2.9992E-02,2.5712E-02,
     &2.1432E-02,1.7152E-02,1.2873E-02,8.5913E-03,4.3059E-03,3.6526E-06,
     &3.6903E-02,3.2297E-02,2.7692E-02,2.3087E-02,1.8480E-02,1.3870E-02,
     &9.2583E-03,4.6485E-03,5.8762E-06,3.8979E-02,3.4119E-02,2.9257E-02,
     &2.4392E-02,1.9526E-02,1.4659E-02,9.7912E-03,4.9264E-03,9.0883E-06,
     &4.0909E-02,3.5808E-02,3.0705E-02,2.5602E-02,2.0497E-02,1.5392E-02,
     &1.0293E-02,5.1880E-03,1.4132E-05/
      DATA ((KA(JS,JT,10, 4),JS=1,9),JT=1,5) /
     &2.1003E-01,1.8378E-01,1.5753E-01,1.3127E-01,1.0502E-01,7.8770E-02,
     &5.2516E-02,2.6264E-02,2.2708E-06,2.2303E-01,1.9515E-01,1.6728E-01,
     &1.3940E-01,1.1153E-01,8.3651E-02,5.5777E-02,2.7901E-02,4.3388E-06,
     &2.3715E-01,2.0752E-01,1.7788E-01,1.4824E-01,1.1861E-01,8.8964E-02,
     &5.9326E-02,2.9681E-02,8.0389E-06,2.5270E-01,2.2113E-01,1.8955E-01,
     &1.5796E-01,1.2638E-01,9.4802E-02,6.3220E-02,3.1633E-02,1.4122E-05,
     &2.6544E-01,2.3227E-01,1.9911E-01,1.6593E-01,1.3276E-01,9.9586E-02,
     &6.6411E-02,3.3237E-02,2.0958E-05/
      DATA ((KA(JS,JT,11, 4),JS=1,9),JT=1,5) /
     &4.6663E-01,4.0831E-01,3.4998E-01,2.9165E-01,2.3332E-01,1.7500E-01,
     &1.1667E-01,5.8341E-02,2.3420E-06,4.9719E-01,4.3506E-01,3.7290E-01,
     &3.1076E-01,2.4862E-01,1.8647E-01,1.2432E-01,6.2174E-02,4.5807E-06,
     &5.2774E-01,4.6176E-01,3.9581E-01,3.2984E-01,2.6389E-01,1.9793E-01,
     &1.3196E-01,6.5997E-02,8.8811E-06,5.6221E-01,4.9195E-01,4.2167E-01,
     &3.5141E-01,2.8114E-01,2.1086E-01,1.4059E-01,7.0317E-02,1.5538E-05,
     &5.9121E-01,5.1732E-01,4.4343E-01,3.6953E-01,2.9564E-01,2.2174E-01,
     &1.4785E-01,7.3949E-02,2.4433E-05/
      DATA ((KA(JS,JT,12, 4),JS=1,9),JT=1,5) /
     &6.5249E-01,5.7093E-01,4.8937E-01,4.0781E-01,3.2625E-01,2.4469E-01,
     &1.6313E-01,8.1572E-02,2.2330E-06,6.9534E-01,6.0842E-01,5.2151E-01,
     &4.3459E-01,3.4768E-01,2.6076E-01,1.7385E-01,8.6935E-02,4.3967E-06,
     &7.4143E-01,6.4875E-01,5.5607E-01,4.6339E-01,3.7072E-01,2.7805E-01,
     &1.8537E-01,9.2701E-02,8.3925E-06,7.8904E-01,6.9042E-01,5.9179E-01,
     &4.9316E-01,3.9453E-01,2.9591E-01,1.9728E-01,9.8661E-02,1.5232E-05,
     &8.3131E-01,7.2741E-01,6.2350E-01,5.1959E-01,4.1567E-01,3.1177E-01,
     &2.0786E-01,1.0395E-01,2.3060E-05/
      DATA ((KA(JS,JT,13, 4),JS=1,9),JT=1,5) /
     &7.3322E-01,6.4157E-01,5.4992E-01,4.5827E-01,3.6662E-01,2.7497E-01,
     &1.8332E-01,9.1663E-02,1.8044E-06,7.8224E-01,6.8446E-01,5.8668E-01,
     &4.8890E-01,3.9113E-01,2.9335E-01,1.9557E-01,9.7794E-02,3.6622E-06,
     &8.3769E-01,7.3298E-01,6.2826E-01,5.2356E-01,4.1885E-01,3.1414E-01,
     &2.0944E-01,1.0473E-01,6.8549E-06,8.9145E-01,7.8000E-01,6.6858E-01,
     &5.5715E-01,4.4572E-01,3.3430E-01,2.2288E-01,1.1145E-01,1.1699E-05,
     &9.4256E-01,8.2475E-01,7.0694E-01,5.8912E-01,4.7129E-01,3.5348E-01,
     &2.3566E-01,1.1785E-01,1.9250E-05/
      DATA ((KA(JS,JT, 1, 5),JS=1,9),JT=1,5) /
     &3.1890E-05,3.3428E-05,3.1339E-05,1.9062E-05,2.1359E-05,2.6190E-05,
     &4.2364E-05,7.2281E-05,2.8801E-05,3.2241E-05,3.5034E-05,3.4311E-05,
     &2.9337E-05,1.6956E-05,2.7153E-05,4.1595E-05,7.5807E-05,2.1642E-05,
     &3.2685E-05,3.7104E-05,3.7239E-05,3.5440E-05,2.4683E-05,2.0584E-05,
     &3.9467E-05,7.0498E-05,2.5433E-05,3.3108E-05,3.9233E-05,3.9843E-05,
     &4.0632E-05,3.9351E-05,2.7492E-05,2.7372E-05,6.6136E-05,4.2940E-05,
     &3.3102E-05,4.1126E-05,4.3706E-05,4.7600E-05,5.0514E-05,4.9463E-05,
     &3.6482E-05,4.9147E-05,6.6970E-05/
      DATA ((KA(JS,JT, 2, 5),JS=1,9),JT=1,5) /
     &5.3936E-05,5.3705E-05,4.9534E-05,4.3483E-05,2.4468E-05,2.7314E-05,
     &3.0874E-05,5.5614E-05,1.6658E-05,5.4860E-05,5.5845E-05,5.2280E-05,
     &4.7572E-05,3.6459E-05,1.9946E-05,3.1643E-05,4.8991E-05,1.3490E-05,
     &5.5709E-05,5.8014E-05,5.5306E-05,5.1404E-05,4.5520E-05,2.7920E-05,
     &2.4697E-05,4.8298E-05,2.2442E-05,5.6594E-05,6.0421E-05,5.8710E-05,
     &5.5553E-05,5.0533E-05,4.1849E-05,2.3926E-05,4.4332E-05,3.8077E-05,
     &5.6989E-05,6.3301E-05,6.2702E-05,5.9556E-05,5.7075E-05,5.4328E-05,
     &4.2106E-05,3.0435E-05,5.5304E-05/
      DATA ((KA(JS,JT, 3, 5),JS=1,9),JT=1,5) /
     &1.3054E-04,1.2243E-04,1.0960E-04,9.5396E-05,7.9466E-05,5.1293E-05,
     &3.9755E-05,3.4475E-05,8.0698E-06,1.3254E-04,1.2631E-04,1.1422E-04,
     &1.0017E-04,8.4724E-05,6.6970E-05,3.1985E-05,3.1748E-05,1.1668E-05,
     &1.3451E-04,1.3069E-04,1.1849E-04,1.0449E-04,8.9441E-05,7.3066E-05,
     &4.0433E-05,3.2069E-05,2.1119E-05,1.3620E-04,1.3418E-04,1.2287E-04,
     &1.0958E-04,9.5020E-05,7.9300E-05,5.8519E-05,2.5240E-05,3.2095E-05,
     &1.3805E-04,1.3888E-04,1.2760E-04,1.1481E-04,1.0157E-04,8.6256E-05,
     &6.7417E-05,3.0660E-05,4.5147E-05/
      DATA ((KA(JS,JT, 4, 5),JS=1,9),JT=1,5) /
     &3.2379E-04,2.9036E-04,2.5461E-04,2.1829E-04,1.8055E-04,1.4064E-04,
     &9.6199E-05,5.2600E-05,5.3338E-06,3.2979E-04,2.9999E-04,2.6566E-04,
     &2.2924E-04,1.9018E-04,1.4831E-04,1.0429E-04,3.7208E-05,1.1382E-05,
     &3.3647E-04,3.0773E-04,2.7537E-04,2.3841E-04,1.9818E-04,1.5534E-04,
     &1.1107E-04,4.2940E-05,1.8774E-05,3.4222E-04,3.1790E-04,2.8515E-04,
     &2.4672E-04,2.0544E-04,1.6267E-04,1.1806E-04,6.5823E-05,2.7569E-05,
     &3.4598E-04,3.2526E-04,2.9297E-04,2.5514E-04,2.1384E-04,1.7093E-04,
     &1.2620E-04,7.6156E-05,3.8829E-05/
      DATA ((KA(JS,JT, 5, 5),JS=1,9),JT=1,5) /
     &7.4853E-04,6.5989E-04,5.7237E-04,4.8339E-04,3.9258E-04,3.0112E-04,
     &2.0775E-04,1.0511E-04,4.9046E-06,7.7296E-04,6.8526E-04,5.9860E-04,
     &5.0629E-04,4.1334E-04,3.1913E-04,2.2288E-04,1.1662E-04,9.7426E-06,
     &7.8512E-04,7.0191E-04,6.1328E-04,5.2156E-04,4.2917E-04,3.3432E-04,
     &2.3232E-04,1.2535E-04,1.4908E-05,8.0065E-04,7.1779E-04,6.2814E-04,
     &5.3808E-04,4.4471E-04,3.4601E-04,2.4241E-04,1.3326E-04,2.1852E-05,
     &8.1368E-04,7.3211E-04,6.4458E-04,5.5662E-04,4.6149E-04,3.6022E-04,
     &2.5323E-04,1.4142E-04,3.1532E-05/
      DATA ((KA(JS,JT, 6, 5),JS=1,9),JT=1,5) /
     &1.6528E-03,1.4497E-03,1.2477E-03,1.0459E-03,8.4296E-04,6.4013E-04,
     &4.3541E-04,2.2882E-04,4.1025E-06,1.7167E-03,1.5070E-03,1.2980E-03,
     &1.0901E-03,8.8256E-04,6.7196E-04,4.5785E-04,2.4158E-04,7.1575E-06,
     &1.7542E-03,1.5443E-03,1.3374E-03,1.1305E-03,9.1589E-04,6.9839E-04,
     &4.8070E-04,2.5576E-04,1.1170E-05,1.7835E-03,1.5745E-03,1.3686E-03,
     &1.1552E-03,9.3898E-04,7.2100E-04,4.9974E-04,2.6756E-04,1.6778E-05,
     &1.8173E-03,1.6109E-03,1.3997E-03,1.1836E-03,9.6533E-04,7.4477E-04,
     &5.1869E-04,2.7889E-04,2.4339E-05/
      DATA ((KA(JS,JT, 7, 5),JS=1,9),JT=1,5) /
     &3.9726E-03,3.4772E-03,2.9832E-03,2.4912E-03,1.9978E-03,1.5048E-03,
     &1.0114E-03,5.1606E-04,3.0815E-06,3.9885E-03,3.4924E-03,2.9992E-03,
     &2.5047E-03,2.0117E-03,1.5168E-03,1.0225E-03,5.2471E-04,5.4224E-06,
     &4.1133E-03,3.6053E-03,3.0965E-03,2.5896E-03,2.0823E-03,1.5758E-03,
     &1.0680E-03,5.5159E-04,9.0931E-06,4.1858E-03,3.6723E-03,3.1582E-03,
     &2.6449E-03,2.1343E-03,1.6217E-03,1.1005E-03,5.7513E-04,1.3973E-05,
     &4.2673E-03,3.7471E-03,3.2256E-03,2.7082E-03,2.1908E-03,1.6652E-03,
     &1.1349E-03,5.9686E-04,1.9907E-05/
      DATA ((KA(JS,JT, 8, 5),JS=1,9),JT=1,5) /
     &1.1789E-02,1.0316E-02,8.8432E-03,7.3701E-03,5.8982E-03,4.4284E-03,
     &2.9575E-03,1.4868E-03,2.6362E-06,1.1815E-02,1.0339E-02,8.8633E-03,
     &7.3911E-03,5.9198E-03,4.4454E-03,2.9722E-03,1.4993E-03,4.7391E-06,
     &1.2063E-02,1.0556E-02,9.0547E-03,7.5533E-03,6.0485E-03,4.5441E-03,
     &3.0419E-03,1.5395E-03,7.9686E-06,1.2374E-02,1.0835E-02,9.2985E-03,
     &7.7571E-03,6.2150E-03,4.6751E-03,3.1349E-03,1.5981E-03,1.2907E-05,
     &1.2586E-02,1.1028E-02,9.4648E-03,7.8998E-03,6.3362E-03,4.7714E-03,
     &3.2105E-03,1.6437E-03,1.9633E-05/
      DATA ((KA(JS,JT, 9, 5),JS=1,9),JT=1,5) /
     &6.5443E-02,5.7264E-02,4.9084E-02,4.0904E-02,3.2723E-02,2.4543E-02,
     &1.6364E-02,8.1848E-03,3.1432E-06,6.6880E-02,5.8521E-02,5.0162E-02,
     &4.1802E-02,3.3443E-02,2.5083E-02,1.6728E-02,8.3763E-03,5.7297E-06,
     &6.6965E-02,5.8596E-02,5.0227E-02,4.1857E-02,3.3491E-02,2.5128E-02,
     &1.6767E-02,8.3954E-03,1.0132E-05,6.9095E-02,6.0459E-02,5.1827E-02,
     &4.3201E-02,3.4575E-02,2.5948E-02,1.7311E-02,8.6749E-03,1.6592E-05,
     &7.0723E-02,6.1894E-02,5.3070E-02,4.4247E-02,3.5417E-02,2.6580E-02,
     &1.7739E-02,8.9030E-03,2.5109E-05/
      DATA ((KA(JS,JT,10, 5),JS=1,9),JT=1,5) /
     &4.3117E-01,3.7727E-01,3.2338E-01,2.6948E-01,2.1559E-01,1.6169E-01,
     &1.0779E-01,5.3898E-02,3.8321E-06,4.4275E-01,3.8740E-01,3.3206E-01,
     &2.7672E-01,2.2138E-01,1.6603E-01,1.1069E-01,5.5347E-02,7.9189E-06,
     &4.5038E-01,3.9409E-01,3.3779E-01,2.8149E-01,2.2519E-01,1.6890E-01,
     &1.1260E-01,5.6313E-02,1.3890E-05,4.5731E-01,4.0015E-01,3.4299E-01,
     &2.8583E-01,2.2868E-01,1.7152E-01,1.1436E-01,5.7212E-02,2.2042E-05,
     &4.7192E-01,4.1294E-01,3.5396E-01,2.9499E-01,2.3600E-01,1.7703E-01,
     &1.1805E-01,5.9063E-02,3.5819E-05/
      DATA ((KA(JS,JT,11, 5),JS=1,9),JT=1,5) /
     &9.6082E-01,8.4073E-01,7.2062E-01,6.0052E-01,4.8042E-01,3.6032E-01,
     &2.4021E-01,1.2011E-01,4.1252E-06,9.8883E-01,8.6524E-01,7.4164E-01,
     &6.1802E-01,4.9442E-01,3.7082E-01,2.4722E-01,1.2361E-01,8.2890E-06,
     &1.0099E+00,8.8371E-01,7.5745E-01,6.3122E-01,5.0498E-01,3.7874E-01,
     &2.5251E-01,1.2627E-01,1.3752E-05,1.0275E+00,8.9904E-01,7.7063E-01,
     &6.4220E-01,5.1377E-01,3.8534E-01,2.5691E-01,1.2849E-01,2.1878E-05,
     &1.0619E+00,9.2921E-01,7.9651E-01,6.6374E-01,5.3103E-01,3.9829E-01,
     &2.6556E-01,1.3282E-01,3.3798E-05/
      DATA ((KA(JS,JT,12, 5),JS=1,9),JT=1,5) /
     &1.3448E+00,1.1767E+00,1.0086E+00,8.4049E-01,6.7240E-01,5.0429E-01,
     &3.3620E-01,1.6810E-01,3.8444E-06,1.3870E+00,1.2136E+00,1.0403E+00,
     &8.6689E-01,6.9351E-01,5.2014E-01,3.4675E-01,1.7338E-01,8.1656E-06,
     &1.4199E+00,1.2424E+00,1.0649E+00,8.8747E-01,7.0998E-01,5.3249E-01,
     &3.5500E-01,1.7752E-01,1.3518E-05,1.4553E+00,1.2734E+00,1.0915E+00,
     &9.0958E-01,7.2769E-01,5.4578E-01,3.6386E-01,1.8196E-01,2.0674E-05,
     &1.5049E+00,1.3168E+00,1.1287E+00,9.4058E-01,7.5249E-01,5.6439E-01,
     &3.7628E-01,1.8817E-01,3.3221E-05/
      DATA ((KA(JS,JT,13, 5),JS=1,9),JT=1,5) /
     &1.5112E+00,1.3223E+00,1.1334E+00,9.4452E-01,7.5561E-01,5.6670E-01,
     &3.7781E-01,1.8891E-01,3.4136E-06,1.5630E+00,1.3677E+00,1.1723E+00,
     &9.7690E-01,7.8153E-01,5.8614E-01,3.9077E-01,1.9539E-01,7.2314E-06,
     &1.6029E+00,1.4025E+00,1.2022E+00,1.0018E+00,8.0146E-01,6.0110E-01,
     &4.0074E-01,2.0039E-01,1.2933E-05,1.6548E+00,1.4480E+00,1.2411E+00,
     &1.0343E+00,8.2742E-01,6.2059E-01,4.1374E-01,2.0689E-01,2.1420E-05,
     &1.7129E+00,1.4988E+00,1.2846E+00,1.0706E+00,8.5645E-01,6.4235E-01,
     &4.2827E-01,2.1415E-01,3.1482E-05/
      DATA ((KA(JS,JT, 1, 6),JS=1,9),JT=1,5) /
     &4.0608E-05,4.2185E-05,3.9730E-05,2.6630E-05,1.5870E-05,2.1720E-05,
     &4.0183E-05,5.7933E-05,1.9230E-05,4.0560E-05,4.3924E-05,4.2843E-05,
     &4.0587E-05,1.9599E-05,1.9434E-05,2.9187E-05,8.1729E-05,2.4180E-05,
     &4.0596E-05,4.5223E-05,4.7233E-05,4.8206E-05,4.1815E-05,2.4282E-05,
     &2.7535E-05,5.3025E-05,4.5769E-05,4.0424E-05,4.7527E-05,5.3798E-05,
     &5.7119E-05,5.7658E-05,5.2268E-05,3.6355E-05,4.4941E-05,8.6910E-05,
     &4.0234E-05,5.1685E-05,6.0703E-05,6.7173E-05,7.3473E-05,7.8264E-05,
     &7.7542E-05,6.1561E-05,1.1878E-04/
      DATA ((KA(JS,JT, 2, 6),JS=1,9),JT=1,5) /
     &7.1743E-05,6.9776E-05,6.4069E-05,5.6253E-05,3.2492E-05,1.5299E-05,
     &2.5979E-05,5.8422E-05,1.3265E-05,7.1061E-05,7.2097E-05,6.7274E-05,
     &6.0734E-05,5.1280E-05,2.1520E-05,1.9911E-05,4.4529E-05,1.9523E-05,
     &7.0841E-05,7.4370E-05,7.0760E-05,6.5655E-05,6.0306E-05,4.1020E-05,
     &2.4466E-05,3.0981E-05,4.7368E-05,7.0995E-05,7.6358E-05,7.4085E-05,
     &7.2263E-05,6.9627E-05,6.3412E-05,3.9010E-05,3.3220E-05,7.3941E-05,
     &7.1418E-05,7.8720E-05,7.9350E-05,8.0487E-05,8.0635E-05,7.8967E-05,
     &7.4070E-05,4.7509E-05,9.9451E-05/
      DATA ((KA(JS,JT, 3, 6),JS=1,9),JT=1,5) /
     &1.7804E-04,1.6309E-04,1.4603E-04,1.2640E-04,1.0532E-04,7.7851E-05,
     &3.0401E-05,3.2808E-05,1.0278E-05,1.7807E-04,1.6656E-04,1.5059E-04,
     &1.3159E-04,1.1024E-04,8.6966E-05,3.8390E-05,2.7178E-05,2.3712E-05,
     &1.7838E-04,1.6972E-04,1.5616E-04,1.3747E-04,1.1728E-04,9.5070E-05,
     &6.7563E-05,2.2396E-05,4.2459E-05,1.7857E-04,1.7475E-04,1.6100E-04,
     &1.4311E-04,1.2411E-04,1.0321E-04,8.1061E-05,2.7084E-05,5.9922E-05,
     &1.7913E-04,1.7932E-04,1.6663E-04,1.4905E-04,1.3079E-04,1.1234E-04,
     &9.4176E-05,5.9304E-05,8.0703E-05/
      DATA ((KA(JS,JT, 4, 6),JS=1,9),JT=1,5) /
     &4.5849E-04,4.0719E-04,3.5630E-04,3.0212E-04,2.4723E-04,1.9208E-04,
     &1.3224E-04,4.0670E-05,1.0786E-05,4.6326E-04,4.1501E-04,3.6371E-04,
     &3.1046E-04,2.5726E-04,2.0145E-04,1.4032E-04,4.2661E-05,2.2724E-05,
     &4.5999E-04,4.1805E-04,3.6892E-04,3.1975E-04,2.6673E-04,2.0947E-04,
     &1.4924E-04,6.8954E-05,3.3787E-05,4.6003E-04,4.1972E-04,3.7753E-04,
     &3.3032E-04,2.7779E-04,2.1909E-04,1.5785E-04,9.1573E-05,4.7343E-05,
     &4.6253E-04,4.2854E-04,3.8917E-04,3.4007E-04,2.8599E-04,2.2760E-04,
     &1.6713E-04,1.0392E-04,6.4507E-05/
      DATA ((KA(JS,JT, 5, 6),JS=1,9),JT=1,5) /
     &1.1046E-03,9.7210E-04,8.3818E-04,7.0474E-04,5.7182E-04,4.3731E-04,
     &3.0078E-04,1.5849E-04,1.0669E-05,1.1184E-03,9.8522E-04,8.5052E-04,
     &7.1956E-04,5.8448E-04,4.4708E-04,3.0943E-04,1.6582E-04,1.7856E-05,
     &1.1214E-03,9.8952E-04,8.6298E-04,7.3058E-04,5.9526E-04,4.5967E-04,
     &3.2343E-04,1.7504E-04,2.7384E-05,1.1214E-03,9.9887E-04,8.7233E-04,
     &7.4058E-04,6.1074E-04,4.7706E-04,3.3627E-04,1.8500E-04,4.0071E-05,
     &1.1239E-03,1.0058E-03,8.8047E-04,7.5602E-04,6.2667E-04,4.9193E-04,
     &3.4864E-04,1.9526E-04,5.6262E-05/
      DATA ((KA(JS,JT, 6, 6),JS=1,9),JT=1,5) /
     &2.6585E-03,2.3289E-03,2.0017E-03,1.6725E-03,1.3436E-03,1.0134E-03,
     &6.8348E-04,3.5116E-04,8.2810E-06,2.5863E-03,2.2683E-03,1.9501E-03,
     &1.6316E-03,1.3110E-03,9.9174E-04,6.7274E-04,3.5111E-04,1.4039E-05,
     &2.6176E-03,2.2991E-03,1.9771E-03,1.6537E-03,1.3367E-03,1.0179E-03,
     &6.9352E-04,3.6693E-04,2.2683E-05,2.6217E-03,2.3046E-03,1.9871E-03,
     &1.6757E-03,1.3567E-03,1.0347E-03,7.1195E-04,3.8176E-04,3.4748E-05,
     &2.6329E-03,2.3195E-03,2.0094E-03,1.6960E-03,1.3768E-03,1.0589E-03,
     &7.3230E-04,3.9783E-04,4.9695E-05/
      DATA ((KA(JS,JT, 7, 6),JS=1,9),JT=1,5) /
     &6.5036E-03,5.6927E-03,4.8817E-03,4.0715E-03,3.2636E-03,2.4531E-03,
     &1.6426E-03,8.2916E-04,6.2936E-06,6.4462E-03,5.6438E-03,4.8427E-03,
     &4.0443E-03,3.2425E-03,2.4409E-03,1.6364E-03,8.3288E-04,1.1136E-05,
     &6.4103E-03,5.6141E-03,4.8233E-03,4.0268E-03,3.2317E-03,2.4336E-03,
     &1.6355E-03,8.3675E-04,1.7991E-05,6.4801E-03,5.6797E-03,4.8784E-03,
     &4.0772E-03,3.2734E-03,2.4699E-03,1.6705E-03,8.6234E-04,2.8124E-05,
     &6.4899E-03,5.6954E-03,4.8999E-03,4.1019E-03,3.3007E-03,2.5022E-03,
     &1.6963E-03,8.8568E-04,4.2294E-05/
      DATA ((KA(JS,JT, 8, 6),JS=1,9),JT=1,5) /
     &1.9938E-02,1.7447E-02,1.4956E-02,1.2465E-02,9.9746E-03,7.4836E-03,
     &4.9963E-03,2.5067E-03,5.1161E-06,2.0028E-02,1.7527E-02,1.5026E-02,
     &1.2525E-02,1.0025E-02,7.5295E-03,5.0298E-03,2.5282E-03,9.0850E-06,
     &1.9800E-02,1.7330E-02,1.4859E-02,1.2391E-02,9.9275E-03,7.4581E-03,
     &4.9868E-03,2.5105E-03,1.5352E-05,1.9943E-02,1.7456E-02,1.4973E-02,
     &1.2495E-02,1.0008E-02,7.5213E-03,5.0327E-03,2.5396E-03,2.4408E-05,
     &2.0100E-02,1.7597E-02,1.5105E-02,1.2604E-02,1.0099E-02,7.5963E-03,
     &5.0871E-03,2.5804E-03,3.7067E-05/
      DATA ((KA(JS,JT, 9, 6),JS=1,9),JT=1,5) /
     &1.1579E-01,1.0132E-01,8.6843E-02,7.2372E-02,5.7899E-02,4.3426E-02,
     &2.8954E-02,1.4481E-02,4.8758E-06,1.1661E-01,1.0203E-01,8.7460E-02,
     &7.2886E-02,5.8311E-02,4.3737E-02,2.9163E-02,1.4591E-02,1.0307E-05,
     &1.1709E-01,1.0246E-01,8.7825E-02,7.3192E-02,5.8559E-02,4.3925E-02,
     &2.9293E-02,1.4674E-02,1.8955E-05,1.1566E-01,1.0121E-01,8.6757E-02,
     &7.2304E-02,5.7852E-02,4.3402E-02,2.8967E-02,1.4512E-02,3.1114E-05,
     &1.1720E-01,1.0255E-01,8.7909E-02,7.3266E-02,5.8634E-02,4.4011E-02,
     &2.9372E-02,1.4720E-02,4.7731E-05/
      DATA ((KA(JS,JT,10, 6),JS=1,9),JT=1,5) /
     &7.9704E-01,6.9741E-01,5.9778E-01,4.9815E-01,3.9852E-01,2.9889E-01,
     &1.9926E-01,9.9635E-02,6.0881E-06,8.0524E-01,7.0458E-01,6.0393E-01,
     &5.0328E-01,4.0263E-01,3.0197E-01,2.0132E-01,1.0067E-01,9.9592E-06,
     &8.0944E-01,7.0827E-01,6.0708E-01,5.0591E-01,4.0473E-01,3.0356E-01,
     &2.0238E-01,1.0120E-01,1.7097E-05,8.0782E-01,7.0685E-01,6.0589E-01,
     &5.0491E-01,4.0393E-01,3.0295E-01,2.0198E-01,1.0100E-01,2.9862E-05,
     &8.0293E-01,7.0255E-01,6.0220E-01,5.0184E-01,4.0149E-01,3.0112E-01,
     &2.0077E-01,1.0043E-01,4.8674E-05/
      DATA ((KA(JS,JT,11, 6),JS=1,9),JT=1,5) /
     &1.8320E+00,1.6031E+00,1.3740E+00,1.1450E+00,9.1602E-01,6.8703E-01,
     &4.5802E-01,2.2901E-01,6.4794E-06,1.8510E+00,1.6196E+00,1.3883E+00,
     &1.1569E+00,9.2553E-01,6.9415E-01,4.6277E-01,2.3139E-01,1.1218E-05,
     &1.8631E+00,1.6303E+00,1.3974E+00,1.1645E+00,9.3160E-01,6.9871E-01,
     &4.6580E-01,2.3291E-01,1.9228E-05,1.8640E+00,1.6310E+00,1.3980E+00,
     &1.1650E+00,9.3201E-01,6.9904E-01,4.6603E-01,2.3304E-01,3.3633E-05,
     &1.8480E+00,1.6170E+00,1.3860E+00,1.1550E+00,9.2402E-01,6.9305E-01,
     &4.6206E-01,2.3108E-01,5.6086E-05/
      DATA ((KA(JS,JT,12, 6),JS=1,9),JT=1,5) /
     &2.6276E+00,2.2991E+00,1.9707E+00,1.6422E+00,1.3138E+00,9.8536E-01,
     &6.5690E-01,3.2845E-01,6.1969E-06,2.6587E+00,2.3264E+00,1.9940E+00,
     &1.6617E+00,1.3293E+00,9.9701E-01,6.6468E-01,3.3234E-01,9.9191E-06,
     &2.6771E+00,2.3425E+00,2.0078E+00,1.6732E+00,1.3386E+00,1.0039E+00,
     &6.6929E-01,3.3465E-01,1.7326E-05,2.6786E+00,2.3438E+00,2.0090E+00,
     &1.6742E+00,1.3393E+00,1.0045E+00,6.6968E-01,3.3487E-01,3.0600E-05,
     &2.6738E+00,2.3396E+00,2.0054E+00,1.6711E+00,1.3369E+00,1.0027E+00,
     &6.6852E-01,3.3432E-01,4.9574E-05/
      DATA ((KA(JS,JT,13, 6),JS=1,9),JT=1,5) /
     &3.0141E+00,2.6373E+00,2.2606E+00,1.8838E+00,1.5070E+00,1.1303E+00,
     &7.5353E-01,3.7676E-01,5.4676E-06,3.0533E+00,2.6716E+00,2.2900E+00,
     &1.9083E+00,1.5266E+00,1.1450E+00,7.6332E-01,3.8166E-01,9.0049E-06,
     &3.0797E+00,2.6947E+00,2.3097E+00,1.9248E+00,1.5398E+00,1.1549E+00,
     &7.6993E-01,3.8499E-01,1.5493E-05,3.0841E+00,2.6986E+00,2.3131E+00,
     &1.9276E+00,1.5421E+00,1.1566E+00,7.7107E-01,3.8557E-01,2.5494E-05,
     &3.0968E+00,2.7097E+00,2.3226E+00,1.9355E+00,1.5484E+00,1.1613E+00,
     &7.7428E-01,3.8723E-01,4.2043E-05/
      DATA ((KA(JS,JT, 1, 7),JS=1,9),JT=1,5) /
     &4.9351E-05,5.1634E-05,5.0550E-05,4.1436E-05,1.6376E-05,2.1065E-05,
     &3.5627E-05,5.1301E-05,2.4192E-05,4.8474E-05,5.5540E-05,5.6343E-05,
     &5.4221E-05,4.2170E-05,2.4823E-05,3.1731E-05,5.9201E-05,4.8733E-05,
     &4.7492E-05,6.0199E-05,6.3032E-05,6.6317E-05,6.8647E-05,6.4541E-05,
     &4.0308E-05,5.5421E-05,1.0385E-04,4.5731E-05,6.4480E-05,7.0656E-05,
     &8.0927E-05,9.1209E-05,1.0812E-04,1.1177E-04,6.7578E-05,1.5053E-04,
     &4.5536E-05,6.8791E-05,8.4361E-05,1.0008E-04,1.1558E-04,1.4310E-04,
     &1.8138E-04,1.7860E-04,2.0339E-04/
      DATA ((KA(JS,JT, 2, 7),JS=1,9),JT=1,5) /
     &8.7853E-05,8.5975E-05,8.0217E-05,7.2158E-05,5.1923E-05,1.7714E-05,
     &2.3551E-05,3.4001E-05,1.8843E-05,8.7406E-05,8.8950E-05,8.5976E-05,
     &7.9247E-05,6.9532E-05,3.6395E-05,2.2706E-05,4.1033E-05,5.5544E-05,
     &8.7368E-05,9.3020E-05,9.1442E-05,8.8073E-05,8.2295E-05,7.2901E-05,
     &4.3354E-05,4.6618E-05,9.4748E-05,8.6439E-05,9.8041E-05,9.9373E-05,
     &9.8643E-05,9.7447E-05,9.7462E-05,9.8905E-05,6.1372E-05,1.3473E-04,
     &8.4149E-05,1.0269E-04,1.0851E-04,1.1232E-04,1.1694E-04,1.2384E-04,
     &1.3615E-04,1.5254E-04,1.8188E-04/
      DATA ((KA(JS,JT, 3, 7),JS=1,9),JT=1,5) /
     &2.2417E-04,2.0404E-04,1.8235E-04,1.5974E-04,1.3536E-04,1.0733E-04,
     &2.8889E-05,2.3292E-05,2.7610E-05,2.2507E-04,2.0905E-04,1.8945E-04,
     &1.6889E-04,1.4442E-04,1.1619E-04,5.9496E-05,2.4524E-05,5.6641E-05,
     &2.2338E-04,2.1298E-04,1.9588E-04,1.7647E-04,1.5321E-04,1.2706E-04,
     &9.4765E-05,2.7601E-05,8.4458E-05,2.2342E-04,2.1728E-04,2.0413E-04,
     &1.8620E-04,1.6349E-04,1.4113E-04,1.1467E-04,6.7006E-05,1.1844E-04,
     &2.2238E-04,2.2192E-04,2.1227E-04,1.9647E-04,1.7779E-04,1.5802E-04,
     &1.3658E-04,1.1946E-04,1.6048E-04/
      DATA ((KA(JS,JT, 4, 7),JS=1,9),JT=1,5) /
     &5.9406E-04,5.2735E-04,4.5854E-04,3.9146E-04,3.2173E-04,2.5115E-04,
     &1.8204E-04,3.3380E-05,2.9857E-05,6.0105E-04,5.3531E-04,4.6978E-04,
     &4.0022E-04,3.3097E-04,2.6221E-04,1.8773E-04,5.6092E-05,4.7642E-05,
     &5.9920E-04,5.3954E-04,4.7635E-04,4.1122E-04,3.4497E-04,2.7525E-04,
     &1.9878E-04,1.0920E-04,7.1351E-05,5.9595E-04,5.4459E-04,4.8204E-04,
     &4.2190E-04,3.5656E-04,2.8691E-04,2.1194E-04,1.2834E-04,1.0247E-04,
     &5.9682E-04,5.4845E-04,4.9542E-04,4.3507E-04,3.7084E-04,3.0256E-04,
     &2.2629E-04,1.4673E-04,1.4061E-04/
      DATA ((KA(JS,JT, 5, 7),JS=1,9),JT=1,5) /
     &1.5636E-03,1.3738E-03,1.1854E-03,9.9627E-04,8.0358E-04,6.1134E-04,
     &4.1794E-04,2.1940E-04,2.4302E-05,1.5046E-03,1.3266E-03,1.1472E-03,
     &9.6320E-04,7.8248E-04,5.9833E-04,4.1211E-04,2.2595E-04,3.8463E-05,
     &1.5168E-03,1.3431E-03,1.1615E-03,9.8412E-04,8.0210E-04,6.1684E-04,
     &4.2935E-04,2.3832E-04,5.7958E-05,1.5026E-03,1.3336E-03,1.1649E-03,
     &9.9050E-04,8.0890E-04,6.2936E-04,4.4480E-04,2.5053E-04,8.4195E-05,
     &1.4982E-03,1.3418E-03,1.1752E-03,9.9791E-04,8.2403E-04,6.4480E-04,
     &4.6309E-04,2.6575E-04,1.1855E-04/
      DATA ((KA(JS,JT, 6, 7),JS=1,9),JT=1,5) /
     &3.8022E-03,3.3297E-03,2.8587E-03,2.3909E-03,1.9206E-03,1.4508E-03,
     &9.7686E-04,5.0103E-04,1.8374E-05,3.7188E-03,3.2606E-03,2.8078E-03,
     &2.3509E-03,1.8941E-03,1.4317E-03,9.6949E-04,5.0170E-04,2.9781E-05,
     &3.6568E-03,3.2124E-03,2.7660E-03,2.3181E-03,1.8667E-03,1.4148E-03,
     &9.6121E-04,5.0473E-04,4.5442E-05,3.6655E-03,3.2274E-03,2.7830E-03,
     &2.3318E-03,1.8859E-03,1.4380E-03,9.8239E-04,5.2260E-04,6.7780E-05,
     &3.6236E-03,3.1965E-03,2.7643E-03,2.3328E-03,1.8928E-03,1.4444E-03,
     &9.9870E-04,5.3910E-04,9.8293E-05/
      DATA ((KA(JS,JT, 7, 7),JS=1,9),JT=1,5) /
     &9.7756E-03,8.5557E-03,7.3357E-03,6.1160E-03,4.8978E-03,3.6826E-03,
     &2.4642E-03,1.2466E-03,1.4263E-05,9.5966E-03,8.4005E-03,7.2050E-03,
     &6.0128E-03,4.8216E-03,3.6274E-03,2.4345E-03,1.2337E-03,2.4094E-05,
     &9.2939E-03,8.1388E-03,6.9869E-03,5.8375E-03,4.6843E-03,3.5321E-03,
     &2.3720E-03,1.2113E-03,3.8518E-05,9.3185E-03,8.1650E-03,7.0200E-03,
     &5.8680E-03,4.7180E-03,3.5579E-03,2.3933E-03,1.2260E-03,6.0065E-05,
     &9.2942E-03,8.1544E-03,7.0105E-03,5.8689E-03,4.7186E-03,3.5646E-03,
     &2.4113E-03,1.2505E-03,8.8114E-05/
      DATA ((KA(JS,JT, 8, 7),JS=1,9),JT=1,5) /
     &3.1428E-02,2.7501E-02,2.3574E-02,1.9646E-02,1.5719E-02,1.1792E-02,
     &7.8652E-03,3.9445E-03,1.1179E-05,3.0933E-02,2.7068E-02,2.3204E-02,
     &1.9341E-02,1.5477E-02,1.1614E-02,7.7579E-03,3.8961E-03,2.0761E-05,
     &3.0367E-02,2.6575E-02,2.2784E-02,1.8992E-02,1.5203E-02,1.1421E-02,
     &7.6337E-03,3.8475E-03,3.6107E-05,2.9365E-02,2.5702E-02,2.2039E-02,
     &1.8381E-02,1.4731E-02,1.1072E-02,7.4163E-03,3.7447E-03,5.6666E-05,
     &2.9621E-02,2.5930E-02,2.2243E-02,1.8569E-02,1.4884E-02,1.1199E-02,
     &7.5061E-03,3.7957E-03,8.4702E-05/
      DATA ((KA(JS,JT, 9, 7),JS=1,9),JT=1,5) /
     &1.9031E-01,1.6652E-01,1.4273E-01,1.1894E-01,9.5159E-02,7.1370E-02,
     &4.7583E-02,2.3794E-02,1.1825E-05,1.8790E-01,1.6442E-01,1.4093E-01,
     &1.1744E-01,9.3958E-02,7.0471E-02,4.6985E-02,2.3500E-02,2.0873E-05,
     &1.8549E-01,1.6231E-01,1.3912E-01,1.1594E-01,9.2757E-02,6.9574E-02,
     &4.6391E-02,2.3213E-02,3.5554E-05,1.8255E-01,1.5974E-01,1.3693E-01,
     &1.1411E-01,9.1298E-02,6.8486E-02,4.5672E-02,2.2886E-02,5.8671E-05,
     &1.7785E-01,1.5563E-01,1.3341E-01,1.1118E-01,8.8960E-02,6.6737E-02,
     &4.4547E-02,2.2336E-02,9.5234E-05/
      DATA ((KA(JS,JT,10, 7),JS=1,9),JT=1,5) /
     &1.3607E+00,1.1905E+00,1.0205E+00,8.5040E-01,6.8031E-01,5.1024E-01,
     &3.4016E-01,1.7008E-01,8.4759E-06,1.3482E+00,1.1796E+00,1.0111E+00,
     &8.4260E-01,6.7408E-01,5.0556E-01,3.3705E-01,1.6853E-01,1.7938E-05,
     &1.3360E+00,1.1690E+00,1.0020E+00,8.3498E-01,6.6798E-01,5.0099E-01,
     &3.3400E-01,1.6701E-01,3.3302E-05,1.3243E+00,1.1588E+00,9.9325E-01,
     &8.2771E-01,6.6217E-01,4.9664E-01,3.3111E-01,1.6557E-01,5.5097E-05,
     &1.3047E+00,1.1416E+00,9.7851E-01,8.1543E-01,6.5236E-01,4.8929E-01,
     &3.2621E-01,1.6314E-01,9.0393E-05/
      DATA ((KA(JS,JT,11, 7),JS=1,9),JT=1,5) /
     &3.2276E+00,2.8242E+00,2.4208E+00,2.0173E+00,1.6138E+00,1.2104E+00,
     &8.0693E-01,4.0346E-01,7.3681E-06,3.2117E+00,2.8103E+00,2.4088E+00,
     &2.0073E+00,1.6059E+00,1.2044E+00,8.0294E-01,4.0147E-01,1.5281E-05,
     &3.1949E+00,2.7955E+00,2.3962E+00,1.9968E+00,1.5975E+00,1.1981E+00,
     &7.9874E-01,3.9938E-01,2.9166E-05,3.1739E+00,2.7771E+00,2.3804E+00,
     &1.9837E+00,1.5870E+00,1.1902E+00,7.9350E-01,3.9677E-01,4.9026E-05,
     &3.1466E+00,2.7532E+00,2.3599E+00,1.9666E+00,1.5733E+00,1.1800E+00,
     &7.8668E-01,3.9338E-01,8.3128E-05/
      DATA ((KA(JS,JT,12, 7),JS=1,9),JT=1,5) /
     &4.8071E+00,4.2062E+00,3.6053E+00,3.0044E+00,2.4035E+00,1.8027E+00,
     &1.2018E+00,6.0089E-01,7.8311E-06,4.7982E+00,4.1985E+00,3.5987E+00,
     &2.9989E+00,2.3991E+00,1.7993E+00,1.1996E+00,5.9978E-01,1.6500E-05,
     &4.7853E+00,4.1872E+00,3.5890E+00,2.9909E+00,2.3927E+00,1.7945E+00,
     &1.1963E+00,5.9818E-01,3.1398E-05,4.7636E+00,4.1682E+00,3.5727E+00,
     &2.9773E+00,2.3818E+00,1.7864E+00,1.1909E+00,5.9548E-01,5.6315E-05,
     &4.7234E+00,4.1330E+00,3.5426E+00,2.9521E+00,2.3618E+00,1.7713E+00,
     &1.1809E+00,5.9047E-01,9.4104E-05/
      DATA ((KA(JS,JT,13, 7),JS=1,9),JT=1,5) /
     &5.7320E+00,5.0155E+00,4.2989E+00,3.5824E+00,2.8660E+00,2.1495E+00,
     &1.4330E+00,7.1649E-01,9.5542E-06,5.7353E+00,5.0184E+00,4.3015E+00,
     &3.5845E+00,2.8676E+00,2.1507E+00,1.4338E+00,7.1691E-01,1.9109E-05,
     &5.7278E+00,5.0119E+00,4.2959E+00,3.5799E+00,2.8639E+00,2.1479E+00,
     &1.4320E+00,7.1599E-01,3.6436E-05,5.7108E+00,4.9969E+00,4.2830E+00,
     &3.5692E+00,2.8554E+00,2.1415E+00,1.4277E+00,7.1386E-01,6.4763E-05,
     &5.6635E+00,4.9556E+00,4.2476E+00,3.5397E+00,2.8317E+00,2.1238E+00,
     &1.4159E+00,7.0796E-01,1.0153E-04/
      DATA ((KA(JS,JT, 1, 8),JS=1,9),JT=1,5) /
     &5.6440E-05,6.3815E-05,6.7040E-05,7.2656E-05,5.7075E-05,3.5497E-05,
     &4.7197E-05,3.9064E-05,8.4705E-05,5.6956E-05,6.9440E-05,7.5002E-05,
     &9.1724E-05,1.1786E-04,1.1581E-04,7.2124E-05,6.3862E-05,2.0332E-04,
     &5.4856E-05,7.4835E-05,8.9381E-05,1.1688E-04,1.6480E-04,2.0403E-04,
     &2.1723E-04,1.2068E-04,2.9982E-04,5.2749E-05,8.4849E-05,1.1205E-04,
     &1.5064E-04,2.1741E-04,2.8178E-04,3.3958E-04,3.6475E-04,4.0572E-04,
     &4.5645E-05,1.0085E-04,1.3954E-04,1.9411E-04,2.8393E-04,3.7289E-04,
     &4.5784E-04,5.5744E-04,5.3928E-04/
      DATA ((KA(JS,JT, 2, 8),JS=1,9),JT=1,5) /
     &1.0540E-04,1.0513E-04,1.0042E-04,9.6258E-05,8.8970E-05,4.3184E-05,
     &2.9692E-05,3.3913E-05,8.0284E-05,1.0559E-04,1.0940E-04,1.0770E-04,
     &1.0381E-04,1.0664E-04,1.1502E-04,8.1785E-05,5.3525E-05,1.4202E-04,
     &1.0218E-04,1.1568E-04,1.1773E-04,1.2016E-04,1.3039E-04,1.6512E-04,
     &1.8884E-04,1.2031E-04,2.0363E-04,9.8487E-05,1.1922E-04,1.3281E-04,
     &1.4606E-04,1.6549E-04,2.1784E-04,2.7427E-04,3.0595E-04,2.8029E-04,
     &9.4987E-05,1.2846E-04,1.5591E-04,1.8268E-04,2.1442E-04,2.8547E-04,
     &3.6877E-04,4.4657E-04,3.7746E-04/
      DATA ((KA(JS,JT, 3, 8),JS=1,9),JT=1,5) /
     &2.7647E-04,2.5246E-04,2.2770E-04,2.0041E-04,1.7472E-04,1.4681E-04,
     &4.5677E-05,2.9185E-05,7.9704E-05,2.7846E-04,2.6060E-04,2.3622E-04,
     &2.0968E-04,1.8322E-04,1.5414E-04,1.2348E-04,3.8961E-05,1.2336E-04,
     &2.7763E-04,2.6427E-04,2.4553E-04,2.2406E-04,1.9856E-04,1.7101E-04,
     &1.5714E-04,1.3645E-04,1.7764E-04,2.7073E-04,2.6684E-04,2.5482E-04,
     &2.3763E-04,2.1876E-04,2.0158E-04,1.9981E-04,2.4173E-04,2.4735E-04,
     &2.6027E-04,2.7336E-04,2.6560E-04,2.5755E-04,2.5236E-04,2.4811E-04,
     &2.5900E-04,3.3153E-04,3.3717E-04/
      DATA ((KA(JS,JT, 4, 8),JS=1,9),JT=1,5) /
     &7.9130E-04,7.0063E-04,6.1298E-04,5.1987E-04,4.2755E-04,3.3326E-04,
     &2.3363E-04,3.7051E-05,7.4199E-05,7.5980E-04,6.7845E-04,5.9445E-04,
     &5.1095E-04,4.1981E-04,3.2923E-04,2.4168E-04,1.3135E-04,1.1471E-04,
     &7.6644E-04,6.8984E-04,6.0948E-04,5.2391E-04,4.3682E-04,3.5056E-04,
     &2.5756E-04,1.6433E-04,1.6687E-04,7.5595E-04,6.9178E-04,6.1629E-04,
     &5.3601E-04,4.5434E-04,3.7215E-04,2.8231E-04,1.9566E-04,2.3395E-04,
     &7.4067E-04,6.8825E-04,6.1664E-04,5.5301E-04,4.7442E-04,3.9621E-04,
     &3.1512E-04,2.4572E-04,3.2210E-04/
      DATA ((KA(JS,JT, 5, 8),JS=1,9),JT=1,5) /
     &2.0703E-03,1.8139E-03,1.5621E-03,1.3106E-03,1.0600E-03,8.0652E-04,
     &5.5133E-04,2.9069E-04,6.3670E-05,1.9818E-03,1.7441E-03,1.5082E-03,
     &1.2728E-03,1.0326E-03,7.9434E-04,5.4918E-04,2.9978E-04,1.0147E-04,
     &1.9776E-03,1.7438E-03,1.5149E-03,1.2743E-03,1.0380E-03,7.9656E-04,
     &5.5670E-04,3.0633E-04,1.5212E-04,1.9765E-03,1.7561E-03,1.5287E-03,
     &1.2973E-03,1.0616E-03,8.2154E-04,5.8167E-04,3.3115E-04,2.1510E-04,
     &1.9526E-03,1.7391E-03,1.5270E-03,1.3031E-03,1.0804E-03,8.4755E-04,
     &6.0189E-04,3.6102E-04,2.9241E-04/
      DATA ((KA(JS,JT, 6, 8),JS=1,9),JT=1,5) /
     &5.2193E-03,4.5684E-03,3.9176E-03,3.2705E-03,2.6232E-03,1.9766E-03,
     &1.3309E-03,6.8212E-04,5.1398E-05,5.0808E-03,4.4486E-03,3.8217E-03,
     &3.1970E-03,2.5720E-03,1.9485E-03,1.3187E-03,6.8335E-04,8.5267E-05,
     &4.8228E-03,4.2284E-03,3.6430E-03,3.0578E-03,2.4711E-03,1.8742E-03,
     &1.2774E-03,6.7264E-04,1.3245E-04,4.8943E-03,4.3003E-03,3.7080E-03,
     &3.1199E-03,2.5213E-03,1.9154E-03,1.3062E-03,6.9055E-04,1.9661E-04,
     &4.8824E-03,4.3025E-03,3.7232E-03,3.1333E-03,2.5429E-03,1.9512E-03,
     &1.3415E-03,7.2251E-04,2.7802E-04/
      DATA ((KA(JS,JT, 7, 8),JS=1,9),JT=1,5) /
     &1.3875E-02,1.2141E-02,1.0408E-02,8.6749E-03,6.9418E-03,5.2118E-03,
     &3.4839E-03,1.7560E-03,4.0537E-05,1.3633E-02,1.1931E-02,1.0229E-02,
     &8.5279E-03,6.8346E-03,5.1400E-03,3.4444E-03,1.7477E-03,6.8687E-05,
     &1.3328E-02,1.1666E-02,1.0007E-02,8.3587E-03,6.7074E-03,5.0533E-03,
     &3.4014E-03,1.7372E-03,1.1189E-04,1.2636E-02,1.1066E-02,9.5081E-03,
     &7.9486E-03,6.3850E-03,4.8258E-03,3.2564E-03,1.6750E-03,1.7143E-04,
     &1.2752E-02,1.1174E-02,9.6135E-03,8.0399E-03,6.4759E-03,4.9028E-03,
     &3.3183E-03,1.7153E-03,2.5158E-04/
      DATA ((KA(JS,JT, 8, 8),JS=1,9),JT=1,5) /
     &4.6547E-02,4.0730E-02,3.4913E-02,2.9095E-02,2.3277E-02,1.7460E-02,
     &1.1642E-02,5.8282E-03,3.2784E-05,4.5721E-02,4.0008E-02,3.4294E-02,
     &2.8581E-02,2.2868E-02,1.7154E-02,1.1445E-02,5.7448E-03,5.6960E-05,
     &4.4866E-02,3.9261E-02,3.3657E-02,2.8053E-02,2.2449E-02,1.6850E-02,
     &1.1263E-02,5.6659E-03,9.3969E-05,4.3949E-02,3.8462E-02,3.2975E-02,
     &2.7489E-02,2.2013E-02,1.6548E-02,1.1065E-02,5.5874E-03,1.4907E-04,
     &4.1860E-02,3.6641E-02,3.1420E-02,2.6211E-02,2.1011E-02,1.5788E-02,
     &1.0584E-02,5.3726E-03,2.2697E-04/
      DATA ((KA(JS,JT, 9, 8),JS=1,9),JT=1,5) /
     &2.9682E-01,2.5971E-01,2.2262E-01,1.8551E-01,1.4841E-01,1.1131E-01,
     &7.4208E-02,3.7107E-02,2.8713E-05,2.9173E-01,2.5526E-01,2.1881E-01,
     &1.8234E-01,1.4587E-01,1.0941E-01,7.2941E-02,3.6477E-02,5.3026E-05,
     &2.8647E-01,2.5066E-01,2.1486E-01,1.7905E-01,1.4325E-01,1.0744E-01,
     &7.1634E-02,3.5829E-02,9.1273E-05,2.8100E-01,2.4588E-01,2.1076E-01,
     &1.7564E-01,1.4052E-01,1.0540E-01,7.0282E-02,3.5177E-02,1.4937E-04,
     &2.7385E-01,2.3963E-01,2.0540E-01,1.7118E-01,1.3696E-01,1.0274E-01,
     &6.8516E-02,3.4350E-02,2.3011E-04/
      DATA ((KA(JS,JT,10, 8),JS=1,9),JT=1,5) /
     &2.2461E+00,1.9654E+00,1.6846E+00,1.4038E+00,1.1231E+00,8.4230E-01,
     &5.6154E-01,2.8077E-01,2.2240E-05,2.2106E+00,1.9343E+00,1.6579E+00,
     &1.3816E+00,1.1053E+00,8.2897E-01,5.5265E-01,2.7633E-01,4.4575E-05,
     &2.1737E+00,1.9020E+00,1.6303E+00,1.3586E+00,1.0869E+00,8.1516E-01,
     &5.4345E-01,2.7173E-01,8.8587E-05,2.1348E+00,1.8680E+00,1.6011E+00,
     &1.3342E+00,1.0674E+00,8.0056E-01,5.3373E-01,2.6688E-01,1.5800E-04,
     &2.0952E+00,1.8333E+00,1.5714E+00,1.3095E+00,1.0476E+00,7.8572E-01,
     &5.2383E-01,2.6194E-01,2.5854E-04/
      DATA ((KA(JS,JT,11, 8),JS=1,9),JT=1,5) /
     &5.6263E+00,4.9230E+00,4.2197E+00,3.5164E+00,2.8132E+00,2.1099E+00,
     &1.4066E+00,7.0330E-01,2.4215E-05,5.5442E+00,4.8512E+00,4.1582E+00,
     &3.4652E+00,2.7721E+00,2.0791E+00,1.3861E+00,6.9304E-01,5.0673E-05,
     &5.4573E+00,4.7752E+00,4.0930E+00,3.4108E+00,2.7286E+00,2.0465E+00,
     &1.3643E+00,6.8218E-01,9.6231E-05,5.3719E+00,4.7004E+00,4.0290E+00,
     &3.3575E+00,2.6860E+00,2.0145E+00,1.3430E+00,6.7153E-01,1.7007E-04,
     &5.2804E+00,4.6204E+00,3.9603E+00,3.3002E+00,2.6402E+00,1.9802E+00,
     &1.3201E+00,6.6009E-01,2.7665E-04/
      DATA ((KA(JS,JT,12, 8),JS=1,9),JT=1,5) /
     &8.8343E+00,7.7300E+00,6.6256E+00,5.5214E+00,4.4171E+00,3.3128E+00,
     &2.2085E+00,1.1043E+00,2.5372E-05,8.7174E+00,7.6278E+00,6.5381E+00,
     &5.4484E+00,4.3587E+00,3.2690E+00,2.1794E+00,1.0897E+00,5.2642E-05,
     &8.5962E+00,7.5216E+00,6.4471E+00,5.3726E+00,4.2981E+00,3.2236E+00,
     &2.1490E+00,1.0745E+00,9.9934E-05,8.4730E+00,7.4139E+00,6.3547E+00,
     &5.2956E+00,4.2365E+00,3.1774E+00,2.1183E+00,1.0591E+00,1.7486E-04,
     &8.3427E+00,7.2999E+00,6.2571E+00,5.2142E+00,4.1714E+00,3.1285E+00,
     &2.0857E+00,1.0429E+00,2.8225E-04/
      DATA ((KA(JS,JT,13, 8),JS=1,9),JT=1,5) /
     &1.1088E+01,9.7019E+00,8.3159E+00,6.9299E+00,5.5439E+00,4.1579E+00,
     &2.7720E+00,1.3860E+00,2.2843E-05,1.0963E+01,9.5924E+00,8.2220E+00,
     &6.8518E+00,5.4814E+00,4.1110E+00,2.7407E+00,1.3703E+00,4.7912E-05,
     &1.0836E+01,9.4815E+00,8.1269E+00,6.7725E+00,5.4179E+00,4.0635E+00,
     &2.7090E+00,1.3545E+00,9.1850E-05,1.0705E+01,9.3666E+00,8.0284E+00,
     &6.6904E+00,5.3523E+00,4.0142E+00,2.6761E+00,1.3381E+00,1.6522E-04,
     &1.0568E+01,9.2475E+00,7.9263E+00,6.6053E+00,5.2842E+00,3.9632E+00,
     &2.6421E+00,1.3211E+00,2.8269E-04/
      DATA ((KA(JS,JT, 1, 9),JS=1,9),JT=1,5) /
     &6.2917E-05,8.4558E-05,1.3686E-04,1.9740E-04,2.4967E-04,2.7515E-04,
     &1.6338E-04,4.8223E-05,4.6728E-04,5.3089E-05,9.0420E-05,1.8251E-04,
     &2.7670E-04,3.5886E-04,4.3834E-04,4.9477E-04,2.3929E-04,6.8730E-04,
     &4.3039E-05,1.0946E-04,2.4429E-04,3.7961E-04,4.9689E-04,6.1288E-04,
     &7.2274E-04,7.7240E-04,9.6431E-04,3.4069E-05,1.3830E-04,3.2177E-04,
     &5.0878E-04,6.6994E-04,8.2945E-04,9.8413E-04,1.1125E-03,1.3109E-03,
     &3.0399E-05,1.7548E-04,4.1760E-04,6.6731E-04,8.8167E-04,1.0941E-03,
     &1.3015E-03,1.4854E-03,1.7348E-03/
      DATA ((KA(JS,JT, 2, 9),JS=1,9),JT=1,5) /
     &1.1900E-04,1.2836E-04,1.4231E-04,1.8014E-04,2.2526E-04,2.6329E-04,
     &2.2981E-04,4.7447E-05,3.9923E-04,1.1384E-04,1.2703E-04,1.6170E-04,
     &2.3947E-04,3.1945E-04,3.8888E-04,4.4936E-04,3.6063E-04,5.9020E-04,
     &9.6344E-05,1.3540E-04,2.0202E-04,3.2063E-04,4.4367E-04,5.4566E-04,
     &6.4489E-04,7.2550E-04,8.3580E-04,7.7835E-05,1.6099E-04,2.5994E-04,
     &4.2610E-04,6.0189E-04,7.4414E-04,8.8531E-04,1.0210E-03,1.1481E-03,
     &6.0959E-05,1.9625E-04,3.3515E-04,5.6029E-04,7.9618E-04,9.9092E-04,
     &1.1822E-03,1.3661E-03,1.5393E-03/
      DATA ((KA(JS,JT, 3, 9),JS=1,9),JT=1,5) /
     &3.4384E-04,3.1901E-04,2.9656E-04,2.7161E-04,2.4956E-04,2.4575E-04,
     &2.4892E-04,1.2874E-04,2.5500E-04,3.2651E-04,2.9987E-04,2.8407E-04,
     &2.6822E-04,2.8382E-04,3.2698E-04,3.7690E-04,3.8984E-04,3.8097E-04,
     &3.1133E-04,2.9825E-04,2.8892E-04,2.8983E-04,3.4857E-04,4.4151E-04,
     &5.3596E-04,6.0662E-04,5.5422E-04,2.6650E-04,2.9032E-04,3.1626E-04,
     &3.4521E-04,4.5449E-04,5.9386E-04,7.4052E-04,8.5104E-04,7.8265E-04,
     &2.2412E-04,2.9039E-04,3.7283E-04,4.3223E-04,5.9364E-04,7.9041E-04,
     &9.9696E-04,1.1553E-03,1.0705E-03/
      DATA ((KA(JS,JT, 4, 9),JS=1,9),JT=1,5) /
     &1.0105E-03,8.9198E-04,7.7732E-04,6.6567E-04,5.5452E-04,4.4086E-04,
     &3.2869E-04,1.9418E-04,1.7212E-04,9.2169E-04,8.2421E-04,7.2924E-04,
     &6.3857E-04,5.4763E-04,4.5198E-04,3.7244E-04,3.3779E-04,2.7365E-04,
     &9.1340E-04,8.1831E-04,7.2882E-04,6.3523E-04,5.3088E-04,4.5658E-04,
     &4.4489E-04,4.8577E-04,4.2302E-04,8.9251E-04,8.0269E-04,7.3471E-04,
     &6.4402E-04,5.5905E-04,5.1386E-04,5.6577E-04,6.8086E-04,6.2344E-04,
     &7.9475E-04,7.3797E-04,7.1362E-04,6.7001E-04,6.3957E-04,6.1730E-04,
     &7.4587E-04,9.2826E-04,8.7756E-04/
      DATA ((KA(JS,JT, 5, 9),JS=1,9),JT=1,5) /
     &2.6935E-03,2.3593E-03,2.0323E-03,1.7047E-03,1.3798E-03,1.0522E-03,
     &7.2780E-04,3.9954E-04,1.6653E-04,2.6191E-03,2.2983E-03,1.9871E-03,
     &1.6780E-03,1.3636E-03,1.0535E-03,7.4346E-04,4.3038E-04,2.6682E-04,
     &2.3650E-03,2.0866E-03,1.8132E-03,1.5443E-03,1.2810E-03,1.0093E-03,
     &7.2606E-04,4.8378E-04,4.1282E-04,2.4014E-03,2.1168E-03,1.8401E-03,
     &1.5793E-03,1.3157E-03,1.0190E-03,7.3809E-04,5.7085E-04,6.1502E-04,
     &2.3689E-03,2.1027E-03,1.8524E-03,1.6218E-03,1.3262E-03,1.0531E-03,
     &8.0904E-04,7.1684E-04,8.8985E-04/
      DATA ((KA(JS,JT, 6, 9),JS=1,9),JT=1,5) /
     &6.9308E-03,6.0665E-03,5.2022E-03,4.3390E-03,3.4845E-03,2.6255E-03,
     &1.7705E-03,9.1297E-04,1.4507E-04,6.7707E-03,5.9271E-03,5.0849E-03,
     &4.2542E-03,3.4202E-03,2.5899E-03,1.7563E-03,9.2722E-04,2.4197E-04,
     &6.6111E-03,5.7877E-03,4.9821E-03,4.1734E-03,3.3664E-03,2.5641E-03,
     &1.7626E-03,9.4198E-04,3.8026E-04,6.0438E-03,5.3003E-03,4.5745E-03,
     &3.8441E-03,3.1111E-03,2.3922E-03,1.6672E-03,9.3430E-04,5.5692E-04,
     &6.1335E-03,5.3879E-03,4.6501E-03,3.9141E-03,3.1883E-03,2.4602E-03,
     &1.7143E-03,9.6080E-04,7.9260E-04/
      DATA ((KA(JS,JT, 7, 9),JS=1,9),JT=1,5) /
     &1.9047E-02,1.6668E-02,1.4288E-02,1.1909E-02,9.5299E-03,7.1507E-03,
     &4.7825E-03,2.4097E-03,1.1330E-04,1.8614E-02,1.6290E-02,1.3965E-02,
     &1.1641E-02,9.3171E-03,7.0086E-03,4.6932E-03,2.3827E-03,1.9275E-04,
     &1.8191E-02,1.5921E-02,1.3650E-02,1.1382E-02,9.1322E-03,6.8769E-03,
     &4.6246E-03,2.3704E-03,3.0881E-04,1.7657E-02,1.5455E-02,1.3252E-02,
     &1.1078E-02,8.8961E-03,6.7169E-03,4.5330E-03,2.3676E-03,4.7256E-04,
     &1.6605E-02,1.4537E-02,1.2495E-02,1.0448E-02,8.3949E-03,6.3348E-03,
     &4.3112E-03,2.2623E-03,7.0061E-04/
      DATA ((KA(JS,JT, 8, 9),JS=1,9),JT=1,5) /
     &6.6522E-02,5.8208E-02,4.9894E-02,4.1580E-02,3.3266E-02,2.4952E-02,
     &1.6638E-02,8.3237E-03,8.8556E-05,6.5331E-02,5.7166E-02,4.9002E-02,
     &4.0837E-02,3.2672E-02,2.4508E-02,1.6344E-02,8.1975E-03,1.5988E-04,
     &6.4113E-02,5.6102E-02,4.8090E-02,4.0078E-02,3.2067E-02,2.4056E-02,
     &1.6062E-02,8.0735E-03,2.6393E-04,6.2675E-02,5.4844E-02,4.7014E-02,
     &3.9184E-02,3.1353E-02,2.3542E-02,1.5747E-02,7.9493E-03,4.0578E-04,
     &6.0829E-02,5.3229E-02,4.5632E-02,3.8033E-02,3.0464E-02,2.2925E-02,
     &1.5354E-02,7.7739E-03,6.0582E-04/
      DATA ((KA(JS,JT, 9, 9),JS=1,9),JT=1,5) /
     &4.4562E-01,3.8992E-01,3.3422E-01,2.7852E-01,2.2281E-01,1.6711E-01,
     &1.1141E-01,5.5708E-02,6.4708E-05,4.3840E-01,3.8360E-01,3.2881E-01,
     &2.7401E-01,2.1921E-01,1.6441E-01,1.0961E-01,5.4811E-02,1.2246E-04,
     &4.3101E-01,3.7714E-01,3.2326E-01,2.6939E-01,2.1551E-01,1.6164E-01,
     &1.0777E-01,5.3892E-02,2.1404E-04,4.2341E-01,3.7048E-01,3.1756E-01,
     &2.6464E-01,2.1171E-01,1.5879E-01,1.0587E-01,5.2950E-02,3.4919E-04,
     &4.1490E-01,3.6305E-01,3.1119E-01,2.5933E-01,2.0748E-01,1.5561E-01,
     &1.0376E-01,5.1933E-02,5.3978E-04/
      DATA ((KA(JS,JT,10, 9),JS=1,9),JT=1,5) /
     &3.5739E+00,3.1272E+00,2.6804E+00,2.2337E+00,1.7870E+00,1.3402E+00,
     &8.9349E-01,4.4675E-01,3.6923E-05,3.5173E+00,3.0777E+00,2.6381E+00,
     &2.1983E+00,1.7587E+00,1.3190E+00,8.7936E-01,4.3968E-01,7.4734E-05,
     &3.4601E+00,3.0276E+00,2.5951E+00,2.1626E+00,1.7301E+00,1.2976E+00,
     &8.6506E-01,4.3253E-01,1.2645E-04,3.4013E+00,2.9762E+00,2.5510E+00,
     &2.1258E+00,1.7007E+00,1.2755E+00,8.5034E-01,4.2518E-01,2.0434E-04,
     &3.3408E+00,2.9231E+00,2.5056E+00,2.0880E+00,1.6704E+00,1.2528E+00,
     &8.3521E-01,4.1763E-01,3.0930E-04/
      DATA ((KA(JS,JT,11, 9),JS=1,9),JT=1,5) /
     &9.5423E+00,8.3495E+00,7.1567E+00,5.9639E+00,4.7712E+00,3.5784E+00,
     &2.3856E+00,1.1928E+00,3.3494E-05,9.3929E+00,8.2188E+00,7.0447E+00,
     &5.8706E+00,4.6965E+00,3.5224E+00,2.3483E+00,1.1741E+00,6.4875E-05,
     &9.2404E+00,8.0853E+00,6.9303E+00,5.7752E+00,4.6202E+00,3.4651E+00,
     &2.3101E+00,1.1551E+00,1.1378E-04,9.0863E+00,7.9506E+00,6.8148E+00,
     &5.6790E+00,4.5432E+00,3.4074E+00,2.2716E+00,1.1358E+00,1.8195E-04,
     &8.9334E+00,7.8167E+00,6.7001E+00,5.5834E+00,4.4668E+00,3.3501E+00,
     &2.2334E+00,1.1167E+00,2.6874E-04/
      DATA ((KA(JS,JT,12, 9),JS=1,9),JT=1,5) /
     &1.6018E+01,1.4016E+01,1.2013E+01,1.0011E+01,8.0089E+00,6.0065E+00,
     &4.0043E+00,2.0022E+00,3.3227E-05,1.5778E+01,1.3806E+01,1.1834E+01,
     &9.8614E+00,7.8892E+00,5.9169E+00,3.9446E+00,1.9723E+00,6.4843E-05,
     &1.5536E+01,1.3594E+01,1.1652E+01,9.7100E+00,7.7679E+00,5.8260E+00,
     &3.8840E+00,1.9420E+00,1.1290E-04,1.5292E+01,1.3380E+01,1.1469E+01,
     &9.5575E+00,7.6460E+00,5.7344E+00,3.8230E+00,1.9115E+00,1.7636E-04,
     &1.5044E+01,1.3163E+01,1.1283E+01,9.4022E+00,7.5218E+00,5.6414E+00,
     &3.7609E+00,1.8805E+00,2.6723E-04/
      DATA ((KA(JS,JT,13, 9),JS=1,9),JT=1,5) /
     &2.1597E+01,1.8897E+01,1.6197E+01,1.3498E+01,1.0798E+01,8.0986E+00,
     &5.3991E+00,2.6995E+00,3.8904E-05,2.1295E+01,1.8633E+01,1.5971E+01,
     &1.3309E+01,1.0647E+01,7.9855E+00,5.3237E+00,2.6618E+00,7.5857E-05,
     &2.0989E+01,1.8366E+01,1.5742E+01,1.3118E+01,1.0494E+01,7.8710E+00,
     &5.2472E+00,2.6236E+00,1.3015E-04,2.0668E+01,1.8085E+01,1.5501E+01,
     &1.2918E+01,1.0334E+01,7.7506E+00,5.1670E+00,2.5835E+00,2.0228E-04,
     &2.0333E+01,1.7791E+01,1.5249E+01,1.2708E+01,1.0166E+01,7.6247E+00,
     &5.0831E+00,2.5416E+00,2.9840E-04/
      DATA ((KA(JS,JT, 1,10),JS=1,9),JT=1,5) /
     &5.6592E-05,1.3380E-04,2.8259E-04,4.0725E-04,5.2722E-04,6.3771E-04,
     &7.3618E-04,6.8809E-05,1.0230E-03,3.4000E-05,1.7762E-04,3.9282E-04,
     &5.7189E-04,7.4744E-04,9.1578E-04,1.0739E-03,1.1530E-03,1.4652E-03,
     &3.1822E-05,2.4313E-04,5.2738E-04,7.7595E-04,1.0231E-03,1.2640E-03,
     &1.5000E-03,1.6967E-03,2.0181E-03,3.1887E-05,3.1730E-04,7.0142E-04,
     &1.0376E-03,1.3716E-03,1.7032E-03,2.0256E-03,2.3355E-03,2.7159E-03,
     &3.2974E-05,4.0500E-04,9.2096E-04,1.3701E-03,1.8162E-03,2.2594E-03,
     &2.6867E-03,3.0973E-03,3.6043E-03/
      DATA ((KA(JS,JT, 2,10),JS=1,9),JT=1,5) /
     &1.2846E-04,1.5522E-04,2.7655E-04,3.8379E-04,4.9079E-04,5.9529E-04,
     &6.9141E-04,5.6796E-04,9.2767E-04,6.5990E-05,1.6552E-04,3.7419E-04,
     &5.3648E-04,6.9689E-04,8.5375E-04,1.0031E-03,1.1095E-03,1.3393E-03,
     &5.6435E-05,1.5534E-04,5.0363E-04,7.3034E-04,9.5369E-04,1.1711E-03,
     &1.3827E-03,1.5608E-03,1.8461E-03,5.4174E-05,1.7810E-04,6.6905E-04,
     &9.7686E-04,1.2783E-03,1.5737E-03,1.8611E-03,2.1178E-03,2.4942E-03,
     &5.2370E-05,1.9597E-04,8.6044E-04,1.2706E-03,1.6729E-03,2.0703E-03,
     &2.4603E-03,2.8342E-03,3.2918E-03/
      DATA ((KA(JS,JT, 3,10),JS=1,9),JT=1,5) /
     &4.4469E-04,4.0346E-04,3.7124E-04,3.9072E-04,4.6265E-04,5.3518E-04,
     &6.0670E-04,6.5723E-04,7.6901E-04,2.7821E-04,2.8769E-04,3.4636E-04,
     &4.5772E-04,6.3733E-04,7.5575E-04,8.7290E-04,9.7779E-04,1.1248E-03,
     &1.6712E-04,2.0135E-04,3.1664E-04,6.0259E-04,8.6177E-04,1.0373E-03,
     &1.2106E-03,1.3752E-03,1.5723E-03,1.5303E-04,2.3452E-04,3.6629E-04,
     &7.9270E-04,1.1535E-03,1.4036E-03,1.6498E-03,1.8820E-03,2.1596E-03,
     &1.4546E-04,2.9515E-04,4.4927E-04,1.0579E-03,1.5163E-03,1.8612E-03,
     &2.1985E-03,2.5140E-03,2.9016E-03/
      DATA ((KA(JS,JT, 4,10),JS=1,9),JT=1,5) /
     &1.2138E-03,1.0643E-03,9.4070E-04,8.1504E-04,7.0358E-04,5.9316E-04,
     &5.5104E-04,5.6438E-04,3.2078E-04,1.1514E-03,1.0125E-03,9.4071E-04,
     &8.3600E-04,7.4220E-04,6.5907E-04,7.7143E-04,8.3267E-04,4.7891E-04,
     &8.3276E-04,7.0376E-04,7.1208E-04,6.8052E-04,7.6194E-04,8.9019E-04,
     &1.0682E-03,1.1778E-03,6.1825E-04,6.2678E-04,5.3178E-04,5.1712E-04,
     &6.2090E-04,7.5690E-04,1.1872E-03,1.4563E-03,1.6302E-03,8.5537E-04,
     &4.2987E-04,5.2033E-04,6.3756E-04,7.6564E-04,7.8218E-04,1.6224E-03,
     &1.9482E-03,2.2056E-03,1.2455E-03/
      DATA ((KA(JS,JT, 5,10),JS=1,9),JT=1,5) /
     &3.3420E-03,2.9247E-03,2.5126E-03,2.0946E-03,1.6924E-03,1.3030E-03,
     &9.3410E-04,5.8986E-04,3.1969E-04,3.1398E-03,2.7488E-03,2.3818E-03,
     &2.0259E-03,1.6962E-03,1.3524E-03,9.7217E-04,7.2894E-04,5.2320E-04,
     &3.0330E-03,2.6759E-03,2.3370E-03,2.0014E-03,1.6490E-03,1.4032E-03,
     &1.0593E-03,1.0067E-03,7.5418E-04,2.5775E-03,2.3167E-03,2.0477E-03,
     &1.6916E-03,1.3663E-03,1.1599E-03,1.0841E-03,1.3957E-03,9.6520E-04,
     &2.1866E-03,2.0017E-03,1.5507E-03,1.2425E-03,1.2248E-03,1.1086E-03,
     &1.2483E-03,1.9173E-03,1.1788E-03/
      DATA ((KA(JS,JT, 6,10),JS=1,9),JT=1,5) /
     &8.8838E-03,7.7745E-03,6.6646E-03,5.5555E-03,4.4614E-03,3.3623E-03,
     &2.2796E-03,1.1799E-03,1.7827E-04,8.6572E-03,7.5770E-03,6.4955E-03,
     &5.4321E-03,4.3605E-03,3.3104E-03,2.2427E-03,1.2382E-03,2.5800E-04,
     &8.3335E-03,7.2931E-03,6.2759E-03,5.2475E-03,4.2339E-03,3.2059E-03,
     &2.2047E-03,1.3240E-03,4.2156E-04,7.5549E-03,6.6060E-03,5.7369E-03,
     &4.8380E-03,4.0096E-03,3.1204E-03,2.3001E-03,1.3603E-03,7.8178E-04,
     &6.8684E-03,6.0886E-03,5.1989E-03,4.4067E-03,3.6681E-03,2.8099E-03,
     &1.8970E-03,1.4204E-03,1.3480E-03/
      DATA ((KA(JS,JT, 7,10),JS=1,9),JT=1,5) /
     &2.4586E-02,2.1513E-02,1.8440E-02,1.5369E-02,1.2296E-02,9.2230E-03,
     &6.1633E-03,3.1137E-03,1.3933E-04,2.4170E-02,2.1150E-02,1.8129E-02,
     &1.5109E-02,1.2088E-02,9.0886E-03,6.0878E-03,3.1114E-03,2.3190E-04,
     &2.3662E-02,2.0705E-02,1.7748E-02,1.4791E-02,1.1861E-02,8.9271E-03,
     &6.0215E-03,3.0844E-03,3.6298E-04,2.2469E-02,1.9660E-02,1.6853E-02,
     &1.4086E-02,1.1306E-02,8.5420E-03,5.7631E-03,3.0626E-03,5.4029E-04,
     &1.9809E-02,1.7349E-02,1.4886E-02,1.2460E-02,1.0092E-02,7.8522E-03,
     &5.3378E-03,3.0999E-03,7.7423E-04/
      DATA ((KA(JS,JT, 8,10),JS=1,9),JT=1,5) /
     &8.6508E-02,7.5696E-02,6.4882E-02,5.4068E-02,4.3255E-02,3.2443E-02,
     &2.1630E-02,1.0817E-02,1.6191E-04,8.4528E-02,7.3960E-02,6.3397E-02,
     &5.2832E-02,4.2266E-02,3.1701E-02,2.1136E-02,1.0597E-02,3.0221E-04,
     &8.2999E-02,7.2627E-02,6.2253E-02,5.1878E-02,4.1506E-02,3.1132E-02,
     &2.0757E-02,1.0444E-02,5.5391E-04,8.1486E-02,7.1301E-02,6.1120E-02,
     &5.0928E-02,4.0746E-02,3.0564E-02,2.0452E-02,1.0346E-02,1.0152E-03,
     &7.7129E-02,6.7490E-02,5.7855E-02,4.8214E-02,3.8581E-02,2.9014E-02,
     &1.9443E-02,9.9515E-03,1.5121E-03/
      DATA ((KA(JS,JT, 9,10),JS=1,9),JT=1,5) /
     &5.8674E-01,5.1340E-01,4.4007E-01,3.6671E-01,2.9337E-01,2.2003E-01,
     &1.4669E-01,7.3347E-02,1.3954E-04,5.7350E-01,5.0184E-01,4.3015E-01,
     &3.5845E-01,2.8676E-01,2.1507E-01,1.4339E-01,7.1694E-02,3.0044E-04,
     &5.6021E-01,4.9017E-01,4.2014E-01,3.5012E-01,2.8010E-01,2.1008E-01,
     &1.4005E-01,7.0031E-02,5.5636E-04,5.4802E-01,4.7953E-01,4.1105E-01,
     &3.4251E-01,2.7403E-01,2.0552E-01,1.3702E-01,6.8512E-02,9.3561E-04,
     &5.3709E-01,4.6991E-01,4.0280E-01,3.3568E-01,2.6852E-01,2.0142E-01,
     &1.3428E-01,6.7143E-02,1.4485E-03/
      DATA ((KA(JS,JT,10,10),JS=1,9),JT=1,5) /
     &4.7861E+00,4.1878E+00,3.5896E+00,2.9913E+00,2.3930E+00,1.7948E+00,
     &1.1965E+00,5.9827E-01,3.2704E-06,4.6903E+00,4.1040E+00,3.5178E+00,
     &2.9315E+00,2.3452E+00,1.7589E+00,1.1726E+00,5.8632E-01,5.9185E-06,
     &4.5984E+00,4.0237E+00,3.4487E+00,2.8740E+00,2.2992E+00,1.7244E+00,
     &1.1496E+00,5.7479E-01,9.9252E-06,4.5067E+00,3.9434E+00,3.3802E+00,
     &2.8168E+00,2.2535E+00,1.6901E+00,1.1267E+00,5.6337E-01,1.5639E-05,
     &4.4320E+00,3.8780E+00,3.3239E+00,2.7699E+00,2.2160E+00,1.6620E+00,
     &1.1080E+00,5.5401E-01,2.3260E-05/
      DATA ((KA(JS,JT,11,10),JS=1,9),JT=1,5) /
     &1.3118E+01,1.1478E+01,9.8381E+00,8.1983E+00,6.5588E+00,4.9192E+00,
     &3.2794E+00,1.6397E+00,2.2734E-06,1.2878E+01,1.1268E+01,9.6587E+00,
     &8.0488E+00,6.4391E+00,4.8293E+00,3.2196E+00,1.6098E+00,4.2460E-06,
     &1.2677E+01,1.1092E+01,9.5076E+00,7.9230E+00,6.3383E+00,4.7539E+00,
     &3.1692E+00,1.5846E+00,7.1509E-06,1.2452E+01,1.0896E+01,9.3395E+00,
     &7.7831E+00,6.2263E+00,4.6699E+00,3.1133E+00,1.5566E+00,1.2244E-05,
     &1.2241E+01,1.0711E+01,9.1810E+00,7.6509E+00,6.1207E+00,4.5903E+00,
     &3.0604E+00,1.5302E+00,2.0967E-05/
      DATA ((KA(JS,JT,12,10),JS=1,9),JT=1,5) /
     &2.2864E+01,2.0005E+01,1.7148E+01,1.4290E+01,1.1432E+01,8.5738E+00,
     &5.7157E+00,2.8580E+00,1.8184E-06,2.2487E+01,1.9676E+01,1.6864E+01,
     &1.4054E+01,1.1243E+01,8.4321E+00,5.6215E+00,2.8107E+00,3.3852E-06,
     &2.2126E+01,1.9360E+01,1.6594E+01,1.3829E+01,1.1063E+01,8.2969E+00,
     &5.5315E+00,2.7657E+00,6.4086E-06,2.1772E+01,1.9050E+01,1.6328E+01,
     &1.3607E+01,1.0886E+01,8.1644E+00,5.4429E+00,2.7215E+00,1.1402E-05,
     &2.1416E+01,1.8740E+01,1.6063E+01,1.3386E+01,1.0708E+01,8.0313E+00,
     &5.3540E+00,2.6771E+00,1.6645E-05/
      DATA ((KA(JS,JT,13,10),JS=1,9),JT=1,5) /
     &3.2272E+01,2.8237E+01,2.4203E+01,2.0170E+01,1.6136E+01,1.2101E+01,
     &8.0677E+00,4.0338E+00,1.4317E-06,3.1783E+01,2.7810E+01,2.3837E+01,
     &1.9864E+01,1.5891E+01,1.1919E+01,7.9455E+00,3.9728E+00,3.0046E-06,
     &3.1267E+01,2.7359E+01,2.3450E+01,1.9542E+01,1.5633E+01,1.1725E+01,
     &7.8169E+00,3.9083E+00,5.7473E-06,3.0805E+01,2.6955E+01,2.3103E+01,
     &1.9253E+01,1.5402E+01,1.1552E+01,7.7014E+00,3.8506E+00,8.5901E-06,
     &3.0347E+01,2.6554E+01,2.2760E+01,1.8967E+01,1.5174E+01,1.1380E+01,
     &7.5867E+00,3.7933E+00,1.2367E-05/
      DATA ((KA(JS,JT, 1,11),JS=1,9),JT=1,5) /
     &4.7098E-05,1.8036E-04,3.4819E-04,5.0638E-04,6.6181E-04,8.1065E-04,
     &9.3902E-04,7.7167E-04,1.3022E-03,3.0033E-05,2.6523E-04,5.0795E-04,
     &7.4803E-04,9.8321E-04,1.2080E-03,1.4174E-03,1.6176E-03,1.9428E-03,
     &3.0544E-05,3.7128E-04,7.2058E-04,1.0671E-03,1.4084E-03,1.7391E-03,
     &2.0379E-03,2.3032E-03,2.7938E-03,3.0472E-05,4.9757E-04,9.8168E-04,
     &1.4606E-03,1.9374E-03,2.4057E-03,2.8449E-03,3.1636E-03,3.8517E-03,
     &2.4091E-05,6.5444E-04,1.2934E-03,1.9295E-03,2.5676E-03,3.2003E-03,
     &3.8144E-03,4.2439E-03,5.1123E-03/
      DATA ((KA(JS,JT, 2,11),JS=1,9),JT=1,5) /
     &1.3816E-04,1.6153E-04,3.3849E-04,4.7695E-04,6.1250E-04,7.4207E-04,
     &8.5768E-04,9.1861E-04,1.1708E-03,6.1066E-05,1.7974E-04,4.7651E-04,
     &6.8520E-04,8.9139E-04,1.0930E-03,1.2848E-03,1.4278E-03,1.7346E-03,
     &5.7831E-05,2.0028E-04,6.5612E-04,9.5859E-04,1.2605E-03,1.5625E-03,
     &1.8554E-03,2.0988E-03,2.4798E-03,5.4516E-05,2.3064E-04,8.8062E-04,
     &1.3017E-03,1.7223E-03,2.1436E-03,2.5645E-03,2.9565E-03,3.4038E-03,
     &5.5309E-05,3.0448E-04,1.1705E-03,1.7340E-03,2.2966E-03,2.8601E-03,
     &3.4280E-03,3.9900E-03,4.5458E-03/
      DATA ((KA(JS,JT, 3,11),JS=1,9),JT=1,5) /
     &4.5525E-04,4.1659E-04,4.0041E-04,4.3594E-04,5.6841E-04,6.6824E-04,
     &7.6559E-04,8.3275E-04,9.8673E-04,2.7564E-04,3.1143E-04,4.0133E-04,
     &6.4539E-04,8.1010E-04,9.7483E-04,1.1326E-03,1.2606E-03,1.4783E-03,
     &1.5755E-04,2.0262E-04,4.4233E-04,8.8058E-04,1.1240E-03,1.3655E-03,
     &1.6023E-03,1.8183E-03,2.1060E-03,1.5225E-04,2.1360E-04,4.5750E-04,
     &1.1722E-03,1.5129E-03,1.8525E-03,2.1885E-03,2.5141E-03,2.8848E-03,
     &1.4157E-04,2.5829E-04,4.6589E-04,1.5429E-03,2.0085E-03,2.4737E-03,
     &2.9344E-03,3.3883E-03,3.8756E-03/
      DATA ((KA(JS,JT, 4,11),JS=1,9),JT=1,5) /
     &1.2968E-03,1.1627E-03,1.0295E-03,8.8852E-04,7.5100E-04,6.8878E-04,
     &7.0217E-04,7.2855E-04,6.6909E-04,1.2901E-03,1.1618E-03,9.9278E-04,
     &8.6686E-04,8.2710E-04,9.1628E-04,1.0053E-03,1.0921E-03,9.3719E-04,
     &8.4696E-04,8.0992E-04,6.6835E-04,7.5797E-04,8.8170E-04,1.2538E-03,
     &1.4194E-03,1.5777E-03,1.2930E-03,4.0946E-04,5.3575E-04,5.3156E-04,
     &6.5607E-04,1.0924E-03,1.6886E-03,1.9410E-03,2.1799E-03,1.6795E-03,
     &4.1161E-04,5.7102E-04,5.8841E-04,6.9122E-04,1.4036E-03,2.2467E-03,
     &2.6025E-03,2.9419E-03,2.1668E-03/
      DATA ((KA(JS,JT, 5,11),JS=1,9),JT=1,5) /
     &3.5249E-03,3.0877E-03,2.6707E-03,2.2562E-03,1.8574E-03,1.4440E-03,
     &1.0135E-03,7.0090E-04,2.4879E-04,3.4987E-03,3.0660E-03,2.6585E-03,
     &2.2616E-03,1.8230E-03,1.3947E-03,1.1338E-03,9.8875E-04,4.4035E-04,
     &3.2338E-03,2.8640E-03,2.5128E-03,2.2224E-03,1.8369E-03,1.4590E-03,
     &1.3054E-03,1.4040E-03,6.0764E-04,2.1959E-03,1.9312E-03,1.7650E-03,
     &1.5181E-03,1.3319E-03,1.3218E-03,1.7587E-03,1.9394E-03,9.4777E-04,
     &1.2468E-03,1.0861E-03,1.1609E-03,1.1515E-03,1.2470E-03,1.3220E-03,
     &2.3659E-03,2.6308E-03,1.2356E-03/
      DATA ((KA(JS,JT, 6,11),JS=1,9),JT=1,5) /
     &9.5223E-03,8.3335E-03,7.1442E-03,5.9544E-03,4.7779E-03,3.5984E-03,
     &2.4247E-03,1.2737E-03,1.4692E-04,9.2485E-03,8.0943E-03,6.9406E-03,
     &5.8161E-03,4.6851E-03,3.5677E-03,2.4748E-03,1.3469E-03,2.5178E-04,
     &8.7789E-03,7.6827E-03,6.6150E-03,5.5437E-03,4.4673E-03,3.4787E-03,
     &2.4528E-03,1.4847E-03,3.7920E-04,8.2164E-03,7.2018E-03,6.2465E-03,
     &5.3375E-03,4.3691E-03,3.4064E-03,2.4151E-03,1.7544E-03,5.7438E-04,
     &6.8576E-03,6.0356E-03,5.1755E-03,4.2553E-03,3.2890E-03,2.6043E-03,
     &1.9585E-03,2.3328E-03,8.0859E-04/
      DATA ((KA(JS,JT, 7,11),JS=1,9),JT=1,5) /
     &2.6634E-02,2.3306E-02,1.9979E-02,1.6651E-02,1.3321E-02,9.9924E-03,
     &6.6684E-03,3.3709E-03,1.8920E-04,2.5938E-02,2.2696E-02,1.9456E-02,
     &1.6215E-02,1.2974E-02,9.7488E-03,6.5437E-03,3.3574E-03,3.7520E-04,
     &2.5453E-02,2.2274E-02,1.9096E-02,1.5918E-02,1.2777E-02,9.6455E-03,
     &6.5081E-03,3.3802E-03,5.3158E-04,2.4271E-02,2.1241E-02,1.8214E-02,
     &1.5233E-02,1.2290E-02,9.3599E-03,6.4912E-03,3.4387E-03,8.0667E-04,
     &2.2422E-02,1.9613E-02,1.6806E-02,1.4145E-02,1.1493E-02,8.8108E-03,
     &6.0692E-03,3.4048E-03,1.1367E-03/
      DATA ((KA(JS,JT, 8,11),JS=1,9),JT=1,5) /
     &9.5097E-02,8.3206E-02,7.1322E-02,5.9437E-02,4.7550E-02,3.5664E-02,
     &2.3777E-02,1.1891E-02,8.8895E-05,9.2657E-02,8.1078E-02,6.9498E-02,
     &5.7915E-02,4.6333E-02,3.4754E-02,2.3172E-02,1.1611E-02,1.6093E-04,
     &8.9553E-02,7.8360E-02,6.7165E-02,5.5974E-02,4.4782E-02,3.3592E-02,
     &2.2399E-02,1.1297E-02,2.7559E-04,8.7450E-02,7.6527E-02,6.5593E-02,
     &5.4667E-02,4.3739E-02,3.2808E-02,2.1983E-02,1.1121E-02,4.3678E-04,
     &8.6068E-02,7.5315E-02,6.4565E-02,5.3811E-02,4.3053E-02,3.2463E-02,
     &2.1814E-02,1.1203E-02,7.8846E-04/
      DATA ((KA(JS,JT, 9,11),JS=1,9),JT=1,5) /
     &6.4279E-01,5.6245E-01,4.8207E-01,4.0173E-01,3.2138E-01,2.4105E-01,
     &1.6070E-01,8.0350E-02,1.4861E-06,6.2663E-01,5.4828E-01,4.6997E-01,
     &3.9164E-01,3.1331E-01,2.3498E-01,1.5666E-01,7.8331E-02,2.7002E-06,
     &6.1151E-01,5.3505E-01,4.5861E-01,3.8220E-01,3.0575E-01,2.2931E-01,
     &1.5288E-01,7.6443E-02,4.4491E-06,5.9675E-01,5.2214E-01,4.4753E-01,
     &3.7296E-01,2.9837E-01,2.2379E-01,1.4920E-01,7.4612E-02,6.8192E-06,
     &5.8474E-01,5.1167E-01,4.3855E-01,3.6547E-01,2.9239E-01,2.1930E-01,
     &1.4621E-01,7.3117E-02,1.0152E-05/
      DATA ((KA(JS,JT,10,11),JS=1,9),JT=1,5) /
     &5.2427E+00,4.5875E+00,3.9320E+00,3.2767E+00,2.6214E+00,1.9660E+00,
     &1.3107E+00,6.5538E-01,3.2405E-06,5.1308E+00,4.4894E+00,3.8480E+00,
     &3.2067E+00,2.5654E+00,1.9241E+00,1.2827E+00,6.4136E-01,6.0207E-06,
     &5.0278E+00,4.3993E+00,3.7708E+00,3.1424E+00,2.5139E+00,1.8854E+00,
     &1.2569E+00,6.2847E-01,1.0181E-05,4.9276E+00,4.3117E+00,3.6956E+00,
     &3.0798E+00,2.4638E+00,1.8478E+00,1.2319E+00,6.1596E-01,1.5690E-05,
     &4.8175E+00,4.2154E+00,3.6129E+00,3.0109E+00,2.4088E+00,1.8066E+00,
     &1.2044E+00,6.0226E-01,2.2851E-05/
      DATA ((KA(JS,JT,11,11),JS=1,9),JT=1,5) /
     &1.4444E+01,1.2639E+01,1.0833E+01,9.0277E+00,7.2223E+00,5.4167E+00,
     &3.6111E+00,1.8056E+00,3.3928E-06,1.4191E+01,1.2417E+01,1.0643E+01,
     &8.8695E+00,7.0956E+00,5.3217E+00,3.5476E+00,1.7739E+00,6.3163E-06,
     &1.3919E+01,1.2179E+01,1.0439E+01,8.6994E+00,6.9594E+00,5.2197E+00,
     &3.4797E+00,1.7399E+00,1.0603E-05,1.3652E+01,1.1946E+01,1.0239E+01,
     &8.5326E+00,6.8259E+00,5.1193E+00,3.4129E+00,1.7065E+00,1.6659E-05,
     &1.3348E+01,1.1680E+01,1.0011E+01,8.3424E+00,6.6742E+00,5.0056E+00,
     &3.3371E+00,1.6685E+00,2.4500E-05/
      DATA ((KA(JS,JT,12,11),JS=1,9),JT=1,5) /
     &2.5285E+01,2.2125E+01,1.8964E+01,1.5803E+01,1.2642E+01,9.4819E+00,
     &6.3210E+00,3.1605E+00,2.1167E-06,2.4880E+01,2.1769E+01,1.8659E+01,
     &1.5550E+01,1.2440E+01,9.3299E+00,6.2198E+00,3.1099E+00,3.8897E-06,
     &2.4433E+01,2.1379E+01,1.8325E+01,1.5271E+01,1.2217E+01,9.1622E+00,
     &6.1081E+00,3.0541E+00,6.6786E-06,2.3948E+01,2.0955E+01,1.7960E+01,
     &1.4967E+01,1.1974E+01,8.9803E+00,5.9870E+00,2.9934E+00,1.0649E-05,
     &2.3474E+01,2.0540E+01,1.7606E+01,1.4671E+01,1.1737E+01,8.8029E+00,
     &5.8685E+00,2.9342E+00,1.7444E-05/
      DATA ((KA(JS,JT,13,11),JS=1,9),JT=1,5) /
     &3.6004E+01,3.1505E+01,2.7003E+01,2.2503E+01,1.8003E+01,1.3502E+01,
     &9.0009E+00,4.5004E+00,1.4918E-06,3.5389E+01,3.0965E+01,2.6541E+01,
     &2.2118E+01,1.7694E+01,1.3271E+01,8.8469E+00,4.4235E+00,2.8535E-06,
     &3.4779E+01,3.0432E+01,2.6084E+01,2.1737E+01,1.7389E+01,1.3042E+01,
     &8.6948E+00,4.3474E+00,4.8793E-06,3.4139E+01,2.9872E+01,2.5605E+01,
     &2.1337E+01,1.7070E+01,1.2802E+01,8.5348E+00,4.2675E+00,8.8607E-06,
     &3.3563E+01,2.9368E+01,2.5171E+01,2.0976E+01,1.6781E+01,1.2586E+01,
     &8.3906E+00,4.1953E+00,1.4420E-05/
      DATA ((KA(JS,JT, 1,12),JS=1,9),JT=1,5) /
     &6.4900E-05,2.8719E-04,5.6307E-04,8.4351E-04,1.1291E-03,1.4211E-03,
     &1.7201E-03,1.9852E-03,2.2469E-03,3.4635E-05,4.0542E-04,7.9731E-04,
     &1.1929E-03,1.5968E-03,2.0148E-03,2.4518E-03,2.8750E-03,3.1817E-03,
     &3.0386E-05,5.5544E-04,1.0947E-03,1.6361E-03,2.1835E-03,2.7444E-03,
     &3.3456E-03,3.9572E-03,4.3509E-03,2.1896E-05,7.4746E-04,1.4741E-03,
     &2.1992E-03,2.9238E-03,3.6527E-03,4.4093E-03,5.2454E-03,5.8288E-03,
     &2.2978E-05,9.8728E-04,1.9484E-03,2.9034E-03,3.8494E-03,4.7859E-03,
     &5.7216E-03,6.7414E-03,7.6777E-03/
      DATA ((KA(JS,JT, 2,12),JS=1,9),JT=1,5) /
     &1.5749E-04,2.0866E-04,4.6787E-04,6.8742E-04,9.1071E-04,1.1382E-03,
     &1.3780E-03,1.6236E-03,1.7971E-03,6.4613E-05,2.9516E-04,6.7832E-04,
     &1.0033E-03,1.3310E-03,1.6630E-03,2.0071E-03,2.4028E-03,2.6327E-03,
     &5.7078E-05,4.5933E-04,9.6118E-04,1.4236E-03,1.8857E-03,2.3486E-03,
     &2.8168E-03,3.3472E-03,3.7377E-03,4.9262E-05,6.5877E-04,1.3301E-03,
     &1.9726E-03,2.6111E-03,3.2436E-03,3.8662E-03,4.5052E-03,5.1847E-03,
     &4.0132E-05,8.9682E-04,1.7993E-03,2.6705E-03,3.5334E-03,4.3806E-03,
     &5.1960E-03,5.9592E-03,7.0262E-03/
      DATA ((KA(JS,JT, 3,12),JS=1,9),JT=1,5) /
     &4.4536E-04,4.2140E-04,4.1326E-04,5.8784E-04,7.3376E-04,8.8410E-04,
     &1.0353E-03,1.1868E-03,1.3506E-03,3.6360E-04,3.5667E-04,4.9101E-04,
     &8.4210E-04,1.0791E-03,1.3181E-03,1.5590E-03,1.8085E-03,2.0516E-03,
     &1.5077E-04,2.9297E-04,7.2917E-04,1.2081E-03,1.5723E-03,1.9339E-03,
     &2.2902E-03,2.6377E-03,3.0400E-03,1.4163E-04,2.2426E-04,1.0557E-03,
     &1.7084E-03,2.2382E-03,2.7621E-03,3.2708E-03,3.7457E-03,4.3687E-03,
     &1.3019E-04,2.3338E-04,1.4920E-03,2.3388E-03,3.0800E-03,3.8155E-03,
     &4.5352E-03,5.1815E-03,6.0536E-03/
      DATA ((KA(JS,JT, 4,12),JS=1,9),JT=1,5) /
     &1.4099E-03,1.2519E-03,1.0992E-03,9.6157E-04,8.5060E-04,8.2135E-04,
     &8.8574E-04,9.4943E-04,1.0571E-03,1.2160E-03,1.0633E-03,1.0308E-03,
     &9.5807E-04,9.2808E-04,1.1772E-03,1.3218E-03,1.4545E-03,1.6420E-03,
     &7.7631E-04,7.4153E-04,7.5882E-04,8.7236E-04,1.3771E-03,1.6770E-03,
     &1.9300E-03,2.1670E-03,2.4676E-03,4.5228E-04,5.1764E-04,4.9825E-04,
     &1.0410E-03,1.9642E-03,2.3602E-03,2.7572E-03,3.1444E-03,3.5784E-03,
     &3.7162E-04,5.4517E-04,4.7653E-04,1.0804E-03,2.6516E-03,3.2347E-03,
     &3.8223E-03,4.4076E-03,4.9248E-03/
      DATA ((KA(JS,JT, 5,12),JS=1,9),JT=1,5) /
     &3.8990E-03,3.4146E-03,2.9418E-03,2.4792E-03,1.9894E-03,1.5917E-03,
     &1.1813E-03,8.6801E-04,2.1028E-04,3.6199E-03,3.1680E-03,2.6938E-03,
     &2.3090E-03,1.9956E-03,1.6463E-03,1.2997E-03,1.3006E-03,2.4494E-04,
     &3.4415E-03,3.0220E-03,2.5761E-03,2.2036E-03,1.8689E-03,1.5859E-03,
     &1.7898E-03,1.9074E-03,5.0679E-04,2.1716E-03,1.9079E-03,1.6133E-03,
     &1.3356E-03,1.5050E-03,1.8145E-03,2.4880E-03,2.7223E-03,8.8637E-04,
     &1.3077E-03,1.2440E-03,1.1158E-03,9.0020E-04,1.2713E-03,2.3698E-03,
     &3.3646E-03,3.7560E-03,1.3375E-03/
      DATA ((KA(JS,JT, 6,12),JS=1,9),JT=1,5) /
     &1.0196E-02,8.9244E-03,7.6531E-03,6.3818E-03,5.1267E-03,3.9081E-03,
     &2.6537E-03,1.4661E-03,1.6889E-04,1.0111E-02,8.8532E-03,7.5941E-03,
     &6.3593E-03,5.1154E-03,3.8577E-03,2.6627E-03,1.5273E-03,2.6786E-04,
     &9.5574E-03,8.3745E-03,7.2096E-03,6.0967E-03,4.9927E-03,3.8753E-03,
     &2.6940E-03,1.7929E-03,4.4721E-04,9.1448E-03,8.0065E-03,6.8180E-03,
     &5.6454E-03,4.5888E-03,3.5047E-03,2.6334E-03,2.4842E-03,6.5846E-04,
     &5.7075E-03,5.0049E-03,4.5271E-03,4.0365E-03,3.0612E-03,2.5106E-03,
     &2.5238E-03,3.3792E-03,9.8239E-04/
      DATA ((KA(JS,JT, 7,12),JS=1,9),JT=1,5) /
     &2.9179E-02,2.5534E-02,2.1889E-02,1.8245E-02,1.4599E-02,1.0955E-02,
     &7.3101E-03,3.7189E-03,1.6629E-04,2.8331E-02,2.4795E-02,2.1258E-02,
     &1.7722E-02,1.4184E-02,1.0647E-02,7.1746E-03,3.6882E-03,3.2759E-04,
     &2.7584E-02,2.4141E-02,2.0699E-02,1.7251E-02,1.3817E-02,1.0419E-02,
     &6.9883E-03,3.6331E-03,7.5693E-04,2.7092E-02,2.3710E-02,2.0332E-02,
     &1.6950E-02,1.3669E-02,1.0331E-02,6.9978E-03,3.6886E-03,1.3272E-03,
     &2.4668E-02,2.1578E-02,1.8509E-02,1.5691E-02,1.2680E-02,9.7141E-03,
     &6.7022E-03,3.7141E-03,1.7778E-03/
      DATA ((KA(JS,JT, 8,12),JS=1,9),JT=1,5) /
     &1.0361E-01,9.0667E-02,7.7713E-02,6.4765E-02,5.1815E-02,3.8864E-02,
     &2.5914E-02,1.2965E-02,1.1677E-04,1.0115E-01,8.8507E-02,7.5864E-02,
     &6.3225E-02,5.0584E-02,3.7943E-02,2.5302E-02,1.2662E-02,2.2624E-04,
     &9.8784E-02,8.6438E-02,7.4094E-02,6.1749E-02,4.9403E-02,3.7059E-02,
     &2.4715E-02,1.2461E-02,3.7810E-04,9.5779E-02,8.3802E-02,7.1837E-02,
     &5.9866E-02,4.7899E-02,3.5935E-02,2.4068E-02,1.2158E-02,6.1406E-04,
     &9.3500E-02,8.1816E-02,7.0121E-02,5.8448E-02,4.6756E-02,3.5152E-02,
     &2.3515E-02,1.2003E-02,9.1223E-04/
      DATA ((KA(JS,JT, 9,12),JS=1,9),JT=1,5) /
     &7.0616E-01,6.1791E-01,5.2965E-01,4.4136E-01,3.5309E-01,2.6483E-01,
     &1.7655E-01,8.8282E-02,1.5290E-06,6.9151E-01,6.0507E-01,5.1861E-01,
     &4.3218E-01,3.4576E-01,2.5930E-01,1.7288E-01,8.6445E-02,2.6717E-06,
     &6.7650E-01,5.9194E-01,5.0740E-01,4.2284E-01,3.3827E-01,2.5371E-01,
     &1.6914E-01,8.4579E-02,4.4922E-06,6.5888E-01,5.7654E-01,4.9417E-01,
     &4.1183E-01,3.2946E-01,2.4710E-01,1.6473E-01,8.2371E-02,7.3887E-06,
     &6.4040E-01,5.6034E-01,4.8031E-01,4.0028E-01,3.2019E-01,2.4016E-01,
     &1.6010E-01,8.0057E-02,1.1597E-05/
      DATA ((KA(JS,JT,10,12),JS=1,9),JT=1,5) /
     &5.7734E+00,5.0518E+00,4.3301E+00,3.6085E+00,2.8866E+00,2.1651E+00,
     &1.4434E+00,7.2167E-01,9.1748E-07,5.6550E+00,4.9481E+00,4.2414E+00,
     &3.5344E+00,2.8275E+00,2.1206E+00,1.4138E+00,7.0688E-01,1.6728E-06,
     &5.5293E+00,4.8379E+00,4.1470E+00,3.4558E+00,2.7646E+00,2.0735E+00,
     &1.3823E+00,6.9113E-01,2.9526E-06,5.4054E+00,4.7297E+00,4.0540E+00,
     &3.3783E+00,2.7027E+00,2.0270E+00,1.3514E+00,6.7568E-01,4.8767E-06,
     &5.2733E+00,4.6145E+00,3.9550E+00,3.2959E+00,2.6366E+00,1.9775E+00,
     &1.3184E+00,6.5919E-01,7.7655E-06/
      DATA ((KA(JS,JT,11,12),JS=1,9),JT=1,5) /
     &1.5785E+01,1.3812E+01,1.1839E+01,9.8659E+00,7.8925E+00,5.9194E+00,
     &3.9463E+00,1.9732E+00,7.4549E-07,1.5479E+01,1.3544E+01,1.1609E+01,
     &9.6738E+00,7.7393E+00,5.8045E+00,3.8695E+00,1.9348E+00,1.4083E-06,
     &1.5180E+01,1.3283E+01,1.1385E+01,9.4881E+00,7.5902E+00,5.6927E+00,
     &3.7951E+00,1.8975E+00,2.4492E-06,1.4875E+01,1.3016E+01,1.1157E+01,
     &9.2972E+00,7.4378E+00,5.5784E+00,3.7189E+00,1.8594E+00,4.0481E-06,
     &1.4584E+01,1.2761E+01,1.0938E+01,9.1150E+00,7.2921E+00,5.4689E+00,
     &3.6460E+00,1.8230E+00,6.1324E-06/
      DATA ((KA(JS,JT,12,12),JS=1,9),JT=1,5) /
     &2.7851E+01,2.4369E+01,2.0888E+01,1.7407E+01,1.3925E+01,1.0444E+01,
     &6.9625E+00,3.4813E+00,1.7967E-06,2.7381E+01,2.3958E+01,2.0536E+01,
     &1.7113E+01,1.3691E+01,1.0268E+01,6.8453E+00,3.4226E+00,3.3551E-06,
     &2.6898E+01,2.3535E+01,2.0173E+01,1.6811E+01,1.3449E+01,1.0086E+01,
     &6.7243E+00,3.3621E+00,5.7999E-06,2.6422E+01,2.3120E+01,1.9816E+01,
     &1.6513E+01,1.3211E+01,9.9083E+00,6.6055E+00,3.3027E+00,8.8648E-06,
     &2.5893E+01,2.2657E+01,1.9420E+01,1.6183E+01,1.2946E+01,9.7098E+00,
     &6.4732E+00,3.2366E+00,1.3030E-05/
      DATA ((KA(JS,JT,13,12),JS=1,9),JT=1,5) /
     &4.0056E+01,3.5049E+01,3.0042E+01,2.5035E+01,2.0028E+01,1.5021E+01,
     &1.0014E+01,5.0068E+00,1.9339E-06,3.9543E+01,3.4599E+01,2.9657E+01,
     &2.4713E+01,1.9771E+01,1.4828E+01,9.8854E+00,4.9428E+00,3.6424E-06,
     &3.8932E+01,3.4065E+01,2.9198E+01,2.4333E+01,1.9465E+01,1.4599E+01,
     &9.7330E+00,4.8663E+00,6.0957E-06,3.8278E+01,3.3493E+01,2.8708E+01,
     &2.3923E+01,1.9139E+01,1.4354E+01,9.5693E+00,4.7847E+00,9.5853E-06,
     &3.7502E+01,3.2815E+01,2.8127E+01,2.3438E+01,1.8751E+01,1.4063E+01,
     &9.3751E+00,4.6877E+00,1.4124E-05/
      DATA ((KA(JS,JT, 1,13),JS=1,9),JT=1,5) /
     &7.4486E-05,5.1116E-04,1.0025E-03,1.4842E-03,1.9493E-03,2.3797E-03,
     &2.7258E-03,2.8231E-03,3.8853E-03,6.5327E-05,7.3706E-04,1.4529E-03,
     &2.1556E-03,2.8349E-03,3.4671E-03,3.9764E-03,4.1729E-03,5.6550E-03,
     &2.8267E-05,1.0173E-03,2.0120E-03,2.9905E-03,3.9385E-03,4.8257E-03,
     &5.5630E-03,5.8315E-03,7.8638E-03,2.3738E-05,1.3547E-03,2.6849E-03,
     &3.9940E-03,5.2660E-03,6.4652E-03,7.4857E-03,7.8673E-03,1.0519E-02,
     &2.6320E-05,1.7490E-03,3.4713E-03,5.1691E-03,6.8225E-03,8.3917E-03,
     &9.7490E-03,1.0316E-02,1.3632E-02/
      DATA ((KA(JS,JT, 2,13),JS=1,9),JT=1,5) /
     &1.3584E-04,4.6683E-04,9.0905E-04,1.3477E-03,1.7804E-03,2.1997E-03,
     &2.5843E-03,2.8459E-03,3.5348E-03,1.2342E-04,6.7608E-04,1.3278E-03,
     &1.9757E-03,2.6172E-03,3.2432E-03,3.8268E-03,4.2250E-03,5.2098E-03,
     &5.7073E-05,9.3916E-04,1.8537E-03,2.7640E-03,3.6667E-03,4.5531E-03,
     &5.3892E-03,5.9774E-03,7.3088E-03,4.3007E-05,1.2575E-03,2.4910E-03,
     &3.7207E-03,4.9408E-03,6.1442E-03,7.2881E-03,8.1201E-03,9.8567E-03,
     &4.4050E-05,1.6325E-03,3.2411E-03,4.8448E-03,6.4428E-03,8.0196E-03,
     &9.5284E-03,1.0661E-02,1.2860E-02/
      DATA ((KA(JS,JT, 3,13),JS=1,9),JT=1,5) /
     &4.8847E-04,4.8646E-04,7.2624E-04,1.0874E-03,1.4317E-03,1.7747E-03,
     &2.1141E-03,2.4304E-03,2.8058E-03,3.4302E-04,4.5845E-04,1.0966E-03,
     &1.6182E-03,2.1396E-03,2.6609E-03,3.1797E-03,3.6788E-03,4.2203E-03,
     &2.3118E-04,5.8673E-04,1.5488E-03,2.2966E-03,3.0451E-03,3.7949E-03,
     &4.5473E-03,5.2834E-03,6.0295E-03,1.2745E-04,7.5679E-04,2.1131E-03,
     &3.1366E-03,4.1628E-03,5.1929E-03,6.2318E-03,7.2646E-03,8.2577E-03,
     &1.0163E-04,9.0005E-04,2.8013E-03,4.1651E-03,5.5261E-03,6.8877E-03,
     &8.2517E-03,9.6360E-03,1.0972E-02/
      DATA ((KA(JS,JT, 4,13),JS=1,9),JT=1,5) /
     &1.4481E-03,1.2897E-03,1.1542E-03,1.0925E-03,1.1503E-03,1.3566E-03,
     &1.5821E-03,1.8266E-03,2.0462E-03,1.3895E-03,1.2964E-03,1.0801E-03,
     &1.1824E-03,1.6797E-03,2.0441E-03,2.4259E-03,2.8265E-03,3.1666E-03,
     &8.4970E-04,9.1322E-04,9.4827E-04,1.6805E-03,2.4256E-03,2.9871E-03,
     &3.5538E-03,4.1410E-03,4.6574E-03,4.1870E-04,6.5230E-04,1.1618E-03,
     &2.4565E-03,3.3994E-03,4.2007E-03,5.0069E-03,5.8294E-03,6.5858E-03,
     &3.3416E-04,5.3110E-04,1.2880E-03,3.5329E-03,4.6400E-03,5.7434E-03,
     &6.8465E-03,7.9498E-03,9.0475E-03/
      DATA ((KA(JS,JT, 5,13),JS=1,9),JT=1,5) /
     &4.2095E-03,3.6897E-03,3.1731E-03,2.7426E-03,2.2812E-03,1.8053E-03,
     &1.3867E-03,1.3663E-03,1.0788E-03,4.0034E-03,3.5161E-03,3.1982E-03,
     &2.7135E-03,2.2188E-03,1.8636E-03,1.9269E-03,2.1141E-03,1.6636E-03,
     &3.5828E-03,3.2123E-03,2.7997E-03,2.3571E-03,1.9942E-03,2.3633E-03,
     &2.8135E-03,3.1780E-03,2.3977E-03,2.0578E-03,1.9948E-03,1.9739E-03,
     &1.8494E-03,2.1664E-03,3.4722E-03,4.0379E-03,4.6191E-03,3.3853E-03,
     &8.8300E-04,9.5901E-04,1.3118E-03,1.4619E-03,2.8921E-03,4.8304E-03,
     &5.6699E-03,6.5165E-03,5.0451E-03/
      DATA ((KA(JS,JT, 6,13),JS=1,9),JT=1,5) /
     &1.1518E-02,1.0082E-02,8.6450E-03,7.2094E-03,5.7738E-03,4.4142E-03,
     &2.9967E-03,1.6414E-03,2.3528E-04,1.0779E-02,9.4346E-03,8.0897E-03,
     &6.7606E-03,5.5435E-03,4.2583E-03,3.0675E-03,1.8475E-03,3.7683E-04,
     &1.0564E-02,9.2493E-03,7.9306E-03,6.7005E-03,5.4724E-03,4.2002E-03,
     &3.0432E-03,2.5995E-03,5.6137E-04,8.9592E-03,7.8426E-03,6.9339E-03,
     &5.9610E-03,4.9577E-03,4.0115E-03,3.3973E-03,3.7509E-03,7.8787E-04,
     &5.6084E-03,4.9031E-03,4.1060E-03,3.7154E-03,3.3523E-03,3.1522E-03,
     &4.6655E-03,5.3564E-03,1.1263E-03/
      DATA ((KA(JS,JT, 7,13),JS=1,9),JT=1,5) /
     &3.2240E-02,2.8212E-02,2.4183E-02,2.0155E-02,1.6127E-02,1.2099E-02,
     &8.0718E-03,4.1324E-03,2.8875E-04,3.1311E-02,2.7399E-02,2.3486E-02,
     &1.9574E-02,1.5661E-02,1.1749E-02,7.9670E-03,4.1256E-03,4.9392E-04,
     &2.9762E-02,2.6043E-02,2.2324E-02,1.8611E-02,1.4888E-02,1.1369E-02,
     &7.7126E-03,4.2395E-03,7.8171E-04,2.8871E-02,2.5265E-02,2.1655E-02,
     &1.8050E-02,1.4581E-02,1.1027E-02,7.5640E-03,4.2437E-03,1.1828E-03,
     &2.6386E-02,2.3095E-02,1.9798E-02,1.6677E-02,1.3324E-02,1.0191E-02,
     &7.1310E-03,4.8298E-03,2.2511E-03/
      DATA ((KA(JS,JT, 8,13),JS=1,9),JT=1,5) /
     &1.1497E-01,1.0060E-01,8.6231E-02,7.1859E-02,5.7486E-02,4.3117E-02,
     &2.8748E-02,1.4377E-02,1.6465E-04,1.1189E-01,9.7901E-02,8.3916E-02,
     &6.9933E-02,5.5946E-02,4.1961E-02,2.7977E-02,1.3991E-02,2.9555E-04,
     &1.0913E-01,9.5494E-02,8.1850E-02,6.8211E-02,5.4570E-02,4.0928E-02,
     &2.7290E-02,1.3843E-02,5.2136E-04,1.0534E-01,9.2180E-02,7.9010E-02,
     &6.5847E-02,5.2678E-02,3.9513E-02,2.6523E-02,1.3514E-02,8.6919E-04,
     &1.0155E-01,8.8866E-02,7.6173E-02,6.3476E-02,5.0785E-02,3.8190E-02,
     &2.5826E-02,1.3344E-02,1.3651E-03/
      DATA ((KA(JS,JT, 9,13),JS=1,9),JT=1,5) /
     &7.8551E-01,6.8732E-01,5.8909E-01,4.9092E-01,3.9275E-01,2.9457E-01,
     &1.9638E-01,9.8187E-02,1.8629E-06,7.6466E-01,6.6906E-01,5.7351E-01,
     &4.7791E-01,3.8233E-01,2.8675E-01,1.9117E-01,9.5586E-02,3.1593E-06,
     &7.4558E-01,6.5237E-01,5.5922E-01,4.6601E-01,3.7282E-01,2.7960E-01,
     &1.8640E-01,9.3207E-02,5.1342E-06,7.2909E-01,6.3798E-01,5.4684E-01,
     &4.5571E-01,3.6456E-01,2.7343E-01,1.8229E-01,9.1144E-02,7.8192E-06,
     &7.0726E-01,6.1887E-01,5.3047E-01,4.4203E-01,3.5366E-01,2.6523E-01,
     &1.7683E-01,8.8423E-02,1.1206E-05/
      DATA ((KA(JS,JT,10,13),JS=1,9),JT=1,5) /
     &6.4269E+00,5.6236E+00,4.8204E+00,4.0168E+00,3.2134E+00,2.4100E+00,
     &1.6066E+00,8.0335E-01,1.1293E-06,6.2640E+00,5.4811E+00,4.6981E+00,
     &3.9150E+00,3.1320E+00,2.3491E+00,1.5660E+00,7.8302E-01,2.0871E-06,
     &6.1220E+00,5.3567E+00,4.5912E+00,3.8262E+00,3.0609E+00,2.2959E+00,
     &1.5304E+00,7.6518E-01,3.5513E-06,5.9998E+00,5.2499E+00,4.4998E+00,
     &3.7498E+00,2.9997E+00,2.2499E+00,1.5000E+00,7.4994E-01,5.6768E-06,
     &5.8812E+00,5.1459E+00,4.4109E+00,3.6757E+00,2.9406E+00,2.2054E+00,
     &1.4703E+00,7.3514E-01,8.5300E-06/
      DATA ((KA(JS,JT,11,13),JS=1,9),JT=1,5) /
     &1.7678E+01,1.5468E+01,1.3258E+01,1.1049E+01,8.8386E+00,6.6292E+00,
     &4.4195E+00,2.2097E+00,9.5807E-07,1.7256E+01,1.5100E+01,1.2942E+01,
     &1.0785E+01,8.6284E+00,6.4710E+00,4.3143E+00,2.1571E+00,1.8271E-06,
     &1.6917E+01,1.4802E+01,1.2687E+01,1.0572E+01,8.4580E+00,6.3436E+00,
     &4.2290E+00,2.1146E+00,3.1322E-06,1.6624E+01,1.4546E+01,1.2468E+01,
     &1.0390E+01,8.3118E+00,6.2340E+00,4.1559E+00,2.0780E+00,4.9941E-06,
     &1.6312E+01,1.4273E+01,1.2234E+01,1.0195E+01,8.1562E+00,6.1169E+00,
     &4.0780E+00,2.0391E+00,7.8208E-06/
      DATA ((KA(JS,JT,12,13),JS=1,9),JT=1,5) /
     &3.1083E+01,2.7197E+01,2.3312E+01,1.9426E+01,1.5541E+01,1.1655E+01,
     &7.7704E+00,3.8852E+00,7.4323E-07,3.0431E+01,2.6627E+01,2.2823E+01,
     &1.9019E+01,1.5215E+01,1.1411E+01,7.6077E+00,3.8037E+00,1.4468E-06,
     &2.9924E+01,2.6183E+01,2.2443E+01,1.8702E+01,1.4961E+01,1.1221E+01,
     &7.4808E+00,3.7405E+00,2.6259E-06,2.9439E+01,2.5759E+01,2.2079E+01,
     &1.8399E+01,1.4719E+01,1.1040E+01,7.3599E+00,3.6798E+00,4.5448E-06,
     &2.8940E+01,2.5323E+01,2.1705E+01,1.8088E+01,1.4470E+01,1.0853E+01,
     &7.2348E+00,3.6174E+00,7.3875E-06/
      DATA ((KA(JS,JT,13,13),JS=1,9),JT=1,5) /
     &4.5024E+01,3.9395E+01,3.3766E+01,2.8140E+01,2.2511E+01,1.6883E+01,
     &1.1256E+01,5.6279E+00,6.0376E-07,4.4143E+01,3.8625E+01,3.3107E+01,
     &2.7589E+01,2.2071E+01,1.6554E+01,1.1035E+01,5.5177E+00,1.1756E-06,
     &4.3457E+01,3.8026E+01,3.2594E+01,2.7161E+01,2.1728E+01,1.6297E+01,
     &1.0864E+01,5.4320E+00,2.1118E-06,4.2787E+01,3.7437E+01,3.2089E+01,
     &2.6742E+01,2.1393E+01,1.6044E+01,1.0696E+01,5.3482E+00,3.5390E-06,
     &4.2071E+01,3.6811E+01,3.1552E+01,2.6294E+01,2.1034E+01,1.5776E+01,
     &1.0517E+01,5.2587E+00,5.6752E-06/
      DATA ((KA(JS,JT, 1,14),JS=1,9),JT=1,5) /
     &8.0615E-05,9.4684E-04,1.8810E-03,2.8058E-03,3.7171E-03,4.6066E-03,
     &5.4471E-03,6.0480E-03,7.4265E-03,7.2907E-05,1.3385E-03,2.6578E-03,
     &3.9621E-03,5.2462E-03,6.4943E-03,7.6854E-03,8.5660E-03,1.0483E-02,
     &6.3747E-05,1.8288E-03,3.6296E-03,5.4086E-03,7.1575E-03,8.8508E-03,
     &1.0431E-02,1.1658E-02,1.4300E-02,3.9260E-05,2.4240E-03,4.8114E-03,
     &7.1688E-03,9.4794E-03,1.1704E-02,1.3748E-02,1.5334E-02,1.8941E-02,
     &2.4568E-05,3.1272E-03,6.2078E-03,9.2494E-03,1.2223E-02,1.5067E-02,
     &1.7657E-02,1.9583E-02,2.4427E-02/
      DATA ((KA(JS,JT, 2,14),JS=1,9),JT=1,5) /
     &1.5596E-04,8.5463E-04,1.6898E-03,2.5200E-03,3.3406E-03,4.1439E-03,
     &4.9117E-03,5.5191E-03,6.6708E-03,1.3504E-04,1.2362E-03,2.4448E-03,
     &3.6435E-03,4.8236E-03,5.9777E-03,7.0641E-03,7.9635E-03,9.6287E-03,
     &1.1284E-04,1.7193E-03,3.4047E-03,5.0732E-03,6.7143E-03,8.3092E-03,
     &9.8022E-03,1.1012E-02,1.3405E-02,7.1068E-05,2.3136E-03,4.5842E-03,
     &6.8306E-03,9.0376E-03,1.1180E-02,1.3169E-02,1.4761E-02,1.8047E-02,
     &4.9683E-05,3.0234E-03,5.9956E-03,8.9376E-03,1.1824E-02,1.4613E-02,
     &1.7201E-02,1.9221E-02,2.3615E-02/
      DATA ((KA(JS,JT, 3,14),JS=1,9),JT=1,5) /
     &4.8559E-04,6.3562E-04,1.4148E-03,2.0956E-03,2.7735E-03,3.4411E-03,
     &4.0892E-03,4.6631E-03,5.5086E-03,3.9874E-04,1.0860E-03,2.1105E-03,
     &3.1322E-03,4.1464E-03,5.1442E-03,6.1073E-03,6.9472E-03,8.2419E-03,
     &3.0553E-04,1.5424E-03,3.0141E-03,4.4802E-03,5.9320E-03,7.3631E-03,
     &8.7355E-03,9.9159E-03,1.1803E-02,2.0300E-04,2.1134E-03,4.1489E-03,
     &6.1729E-03,8.1791E-03,1.0152E-02,1.2037E-02,1.3637E-02,1.6288E-02,
     &1.2261E-04,2.8083E-03,5.5298E-03,8.2360E-03,1.0915E-02,1.3546E-02,
     &1.6061E-02,1.8163E-02,2.1753E-02/
      DATA ((KA(JS,JT, 4,14),JS=1,9),JT=1,5) /
     &1.6340E-03,1.4799E-03,1.3812E-03,1.7164E-03,2.2393E-03,2.7610E-03,
     &3.2750E-03,3.7562E-03,4.3569E-03,1.3493E-03,1.1314E-03,1.6943E-03,
     &2.6409E-03,3.4636E-03,4.2822E-03,5.0857E-03,5.8323E-03,6.7806E-03,
     &9.9538E-04,9.6503E-04,2.6483E-03,3.8772E-03,5.1039E-03,6.3200E-03,
     &7.5138E-03,8.6138E-03,1.0038E-02,7.1686E-04,9.6594E-04,3.7129E-03,
     &5.4649E-03,7.2111E-03,8.9436E-03,1.0638E-02,1.2197E-02,1.4232E-02,
     &3.7667E-04,1.0457E-03,5.0357E-03,7.4391E-03,9.8310E-03,1.2205E-02,
     &1.4525E-02,1.6653E-02,1.9453E-02/
      DATA ((KA(JS,JT, 5,14),JS=1,9),JT=1,5) /
     &4.8186E-03,4.2167E-03,3.6150E-03,3.0747E-03,2.5291E-03,2.2936E-03,
     &2.5986E-03,2.9578E-03,3.3675E-03,4.3147E-03,3.7763E-03,3.3322E-03,
     &2.8723E-03,2.9945E-03,3.5591E-03,4.1803E-03,4.7800E-03,5.4630E-03,
     &3.5596E-03,3.1147E-03,2.7981E-03,3.1802E-03,4.4145E-03,5.3933E-03,
     &6.3651E-03,7.3014E-03,8.3701E-03,2.3785E-03,2.2217E-03,2.2338E-03,
     &4.4885E-03,6.3608E-03,7.8120E-03,9.2509E-03,1.0634E-02,1.2219E-02,
     &1.3285E-03,1.6004E-03,2.5745E-03,6.3438E-03,8.8283E-03,1.0885E-02,
     &1.2921E-02,1.4873E-02,1.7112E-02/
      DATA ((KA(JS,JT, 6,14),JS=1,9),JT=1,5) /
     &1.2819E-02,1.1217E-02,9.6163E-03,8.0152E-03,6.4138E-03,4.8948E-03,
     &3.3434E-03,2.3020E-03,2.0077E-03,1.2485E-02,1.0926E-02,9.3667E-03,
     &7.8075E-03,6.3840E-03,4.8805E-03,3.7061E-03,3.8075E-03,3.4020E-03,
     &1.1272E-02,9.8625E-03,8.4554E-03,7.3206E-03,6.0114E-03,5.1792E-03,
     &5.3340E-03,6.0074E-03,5.3316E-03,1.0208E-02,8.9332E-03,7.9437E-03,
     &6.6798E-03,5.8609E-03,6.4855E-03,7.9228E-03,9.0010E-03,7.9567E-03,
     &6.0521E-03,5.2891E-03,4.8269E-03,4.6206E-03,6.6176E-03,9.3039E-03,
     &1.1293E-02,1.2903E-02,1.1196E-02/
      DATA ((KA(JS,JT, 7,14),JS=1,9),JT=1,5) /
     &3.6443E-02,3.1891E-02,2.7336E-02,2.2781E-02,1.8226E-02,1.3673E-02,
     &9.1182E-03,4.6764E-03,1.4855E-04,3.5471E-02,3.1039E-02,2.6606E-02,
     &2.2173E-02,1.7742E-02,1.3309E-02,9.0490E-03,4.6704E-03,2.5095E-04,
     &3.4456E-02,3.0149E-02,2.5845E-02,2.1540E-02,1.7235E-02,1.3185E-02,
     &8.9735E-03,5.4794E-03,4.0737E-04,3.1652E-02,2.7700E-02,2.3744E-02,
     &1.9792E-02,1.6225E-02,1.2450E-02,9.1363E-03,7.6445E-03,6.2917E-04,
     &2.9864E-02,2.6135E-02,2.2399E-02,1.8923E-02,1.5530E-02,1.2143E-02,
     &1.0151E-02,1.1058E-02,9.1130E-04/
      DATA ((KA(JS,JT, 8,14),JS=1,9),JT=1,5) /
     &1.3223E-01,1.1571E-01,9.9174E-02,8.2651E-02,6.6122E-02,4.9592E-02,
     &3.3063E-02,1.6534E-02,2.3921E-04,1.2869E-01,1.1260E-01,9.6519E-02,
     &8.0434E-02,6.4349E-02,4.8263E-02,3.2179E-02,1.6093E-02,4.2965E-04,
     &1.2518E-01,1.0953E-01,9.3886E-02,7.8243E-02,6.2597E-02,4.6952E-02,
     &3.1306E-02,1.5992E-02,7.4452E-04,1.2188E-01,1.0664E-01,9.1414E-02,
     &7.6180E-02,6.0947E-02,4.5714E-02,3.0548E-02,1.5885E-02,1.1502E-03,
     &1.1492E-01,1.0055E-01,8.6192E-02,7.1832E-02,5.7467E-02,4.3105E-02,
     &2.9610E-02,1.5934E-02,1.8646E-03/
      DATA ((KA(JS,JT, 9,14),JS=1,9),JT=1,5) /
     &9.2387E-01,8.0839E-01,6.9293E-01,5.7740E-01,4.6193E-01,3.4646E-01,
     &2.3098E-01,1.1549E-01,2.2371E-06,9.0122E-01,7.8856E-01,6.7591E-01,
     &5.6327E-01,4.5061E-01,3.3795E-01,2.2531E-01,1.1266E-01,3.5853E-06,
     &8.7866E-01,7.6881E-01,6.5900E-01,5.4913E-01,4.3933E-01,3.2948E-01,
     &2.1967E-01,1.0984E-01,5.0567E-06,8.5611E-01,7.4910E-01,6.4207E-01,
     &5.3506E-01,4.2806E-01,3.2105E-01,2.1404E-01,1.0702E-01,6.9838E-06,
     &8.3494E-01,7.3059E-01,6.2623E-01,5.2185E-01,4.1749E-01,3.1312E-01,
     &2.0874E-01,1.0439E-01,9.6651E-06/
      DATA ((KA(JS,JT,10,14),JS=1,9),JT=1,5) /
     &7.7336E+00,6.7669E+00,5.8002E+00,4.8337E+00,3.8667E+00,2.9002E+00,
     &1.9334E+00,9.6674E-01,1.4759E-06,7.5671E+00,6.6210E+00,5.6751E+00,
     &4.7295E+00,3.7835E+00,2.8377E+00,1.8919E+00,9.4588E-01,2.4483E-06,
     &7.3934E+00,6.4694E+00,5.5449E+00,4.6209E+00,3.6964E+00,2.7725E+00,
     &1.8483E+00,9.2413E-01,3.6428E-06,7.2085E+00,6.3072E+00,5.4063E+00,
     &4.5053E+00,3.6041E+00,2.7031E+00,1.8022E+00,9.0111E-01,5.1643E-06,
     &7.0344E+00,6.1551E+00,5.2759E+00,4.3968E+00,3.5172E+00,2.6378E+00,
     &1.7586E+00,8.7933E-01,7.2619E-06/
      DATA ((KA(JS,JT,11,14),JS=1,9),JT=1,5) /
     &2.1626E+01,1.8923E+01,1.6220E+01,1.3516E+01,1.0813E+01,8.1097E+00,
     &5.4065E+00,2.7033E+00,1.2148E-06,2.1170E+01,1.8523E+01,1.5877E+01,
     &1.3231E+01,1.0585E+01,7.9391E+00,5.2925E+00,2.6462E+00,1.9377E-06,
     &2.0665E+01,1.8082E+01,1.5499E+01,1.2916E+01,1.0333E+01,7.7495E+00,
     &5.1662E+00,2.5832E+00,2.9701E-06,2.0140E+01,1.7623E+01,1.5106E+01,
     &1.2588E+01,1.0071E+01,7.5528E+00,5.0352E+00,2.5176E+00,4.4558E-06,
     &1.9664E+01,1.7206E+01,1.4748E+01,1.2290E+01,9.8317E+00,7.3738E+00,
     &4.9159E+00,2.4579E+00,6.2661E-06/
      DATA ((KA(JS,JT,12,14),JS=1,9),JT=1,5) /
     &3.8270E+01,3.3486E+01,2.8703E+01,2.3919E+01,1.9135E+01,1.4352E+01,
     &9.5673E+00,4.7836E+00,1.1282E-06,3.7417E+01,3.2741E+01,2.8063E+01,
     &2.3387E+01,1.8709E+01,1.4031E+01,9.3545E+00,4.6770E+00,1.8527E-06,
     &3.6489E+01,3.1928E+01,2.7367E+01,2.2805E+01,1.8244E+01,1.3683E+01,
     &9.1218E+00,4.5610E+00,2.7902E-06,3.5556E+01,3.1112E+01,2.6666E+01,
     &2.2223E+01,1.7778E+01,1.3333E+01,8.8890E+00,4.4446E+00,3.8795E-06,
     &3.4682E+01,3.0344E+01,2.6011E+01,2.1676E+01,1.7341E+01,1.3005E+01,
     &8.6702E+00,4.3349E+00,5.0987E-06/
      DATA ((KA(JS,JT,13,14),JS=1,9),JT=1,5) /
     &5.4806E+01,4.7955E+01,4.1104E+01,3.4254E+01,2.7403E+01,2.0551E+01,
     &1.3701E+01,6.8507E+00,9.3782E-07,5.3507E+01,4.6818E+01,4.0130E+01,
     &3.3442E+01,2.6753E+01,2.0066E+01,1.3376E+01,6.6886E+00,1.6696E-06,
     &5.2032E+01,4.5528E+01,3.9023E+01,3.2519E+01,2.6015E+01,1.9512E+01,
     &1.3008E+01,6.5038E+00,2.8850E-06,5.0622E+01,4.4293E+01,3.7966E+01,
     &3.1638E+01,2.5310E+01,1.8983E+01,1.2655E+01,6.3275E+00,4.3456E-06,
     &4.9341E+01,4.3174E+01,3.7007E+01,3.0838E+01,2.4670E+01,1.8503E+01,
     &1.2335E+01,6.1672E+00,6.2672E-06/
      DATA ((KA(JS,JT, 1,15),JS=1,9),JT=1,5) /
     &9.0368E-05,1.7587E-03,3.4692E-03,5.1215E-03,6.6729E-03,8.0447E-03,
     &9.0360E-03,8.9574E-03,1.3337E-02,8.5673E-05,2.5288E-03,4.9923E-03,
     &7.3709E-03,9.6068E-03,1.1588E-02,1.3021E-02,1.2915E-02,1.9203E-02,
     &7.5800E-05,3.4920E-03,6.8957E-03,1.0184E-02,1.3280E-02,1.6021E-02,
     &1.8010E-02,1.7888E-02,2.6548E-02,6.6885E-05,4.6582E-03,9.2038E-03,
     &1.3596E-02,1.7729E-02,2.1393E-02,2.4064E-02,2.3923E-02,3.5446E-02,
     &2.9277E-05,6.0336E-03,1.1922E-02,1.7611E-02,2.2979E-02,2.7733E-02,
     &3.1220E-02,3.1058E-02,4.5944E-02/
      DATA ((KA(JS,JT, 2,15),JS=1,9),JT=1,5) /
     &1.6162E-04,1.7658E-03,3.4927E-03,5.1816E-03,6.8087E-03,8.3146E-03,
     &9.5542E-03,9.9349E-03,1.3602E-02,1.4940E-04,2.5810E-03,5.1093E-03,
     &7.5846E-03,9.9670E-03,1.2178E-02,1.4000E-02,1.4578E-02,1.9917E-02,
     &1.4212E-04,3.6142E-03,7.1589E-03,1.0631E-02,1.3977E-02,1.7085E-02,
     &1.9645E-02,2.0472E-02,2.7934E-02,1.2057E-04,4.8773E-03,9.6676E-03,
     &1.4359E-02,1.8882E-02,2.3081E-02,2.6561E-02,2.7724E-02,3.7741E-02,
     &6.0191E-05,6.3788E-03,1.2648E-02,1.8790E-02,2.4713E-02,3.0224E-02,
     &3.4797E-02,3.6354E-02,4.9402E-02/
      DATA ((KA(JS,JT, 3,15),JS=1,9),JT=1,5) /
     &4.4246E-04,1.6142E-03,3.1839E-03,4.7378E-03,6.2661E-03,7.7441E-03,
     &9.0975E-03,1.0015E-02,1.2497E-02,3.8619E-04,2.4195E-03,4.7839E-03,
     &7.1249E-03,9.4281E-03,1.1657E-02,1.3699E-02,1.5096E-02,1.8815E-02,
     &3.7186E-04,3.4615E-03,6.8531E-03,1.0215E-02,1.3514E-02,1.6722E-02,
     &1.9664E-02,2.1688E-02,2.6981E-02,3.4136E-04,4.7556E-03,9.4307E-03,
     &1.4062E-02,1.8619E-02,2.3030E-02,2.7098E-02,2.9910E-02,3.7185E-02,
     &2.7238E-04,6.3154E-03,1.2533E-02,1.8695E-02,2.4762E-02,3.0640E-02,
     &3.6060E-02,3.9831E-02,4.9464E-02/
      DATA ((KA(JS,JT, 4,15),JS=1,9),JT=1,5) /
     &1.8439E-03,1.6255E-03,2.7662E-03,4.1011E-03,5.4250E-03,6.7307E-03,
     &7.9903E-03,9.0701E-03,1.0766E-02,1.2780E-03,2.0382E-03,4.2819E-03,
     &6.3618E-03,8.4274E-03,1.0464E-02,1.2431E-02,1.4123E-02,1.6753E-02,
     &1.0129E-03,3.1935E-03,6.2902E-03,9.3615E-03,1.2411E-02,1.5417E-02,
     &1.8325E-02,2.0828E-02,2.4703E-02,9.5662E-04,4.4942E-03,8.8414E-03,
     &1.3166E-02,1.7466E-02,2.1716E-02,2.5826E-02,2.9379E-02,3.4795E-02,
     &7.9817E-04,6.0664E-03,1.1965E-02,1.7841E-02,2.3679E-02,2.9437E-02,
     &3.5012E-02,3.9861E-02,4.7202E-02/
      DATA ((KA(JS,JT, 5,15),JS=1,9),JT=1,5) /
     &5.1399E-03,4.4963E-03,3.8550E-03,3.7300E-03,4.5601E-03,5.6445E-03,
     &6.7084E-03,7.7027E-03,8.9288E-03,4.9517E-03,4.3316E-03,4.1416E-03,
     &5.5566E-03,7.3222E-03,9.0762E-03,1.0805E-02,1.2425E-02,1.4409E-02,
     &3.6157E-03,3.1633E-03,5.3630E-03,8.3885E-03,1.1080E-02,1.3756E-02,
     &1.6391E-02,1.8868E-02,2.1878E-02,2.5485E-03,3.2448E-03,8.0168E-03,
     &1.2065E-02,1.5959E-02,1.9835E-02,2.3656E-02,2.7245E-02,3.1588E-02,
     &2.2002E-03,3.7004E-03,1.1229E-02,1.6648E-02,2.2051E-02,2.7414E-02,
     &3.2714E-02,3.7713E-02,4.3725E-02/
      DATA ((KA(JS,JT, 6,15),JS=1,9),JT=1,5) /
     &1.3785E-02,1.2061E-02,1.0339E-02,8.6158E-03,6.8942E-03,5.5266E-03,
     &5.3843E-03,6.1361E-03,7.0081E-03,1.3401E-02,1.1726E-02,1.0052E-02,
     &8.3774E-03,7.3256E-03,7.6626E-03,8.9483E-03,1.0302E-02,1.1787E-02,
     &1.3001E-02,1.1375E-02,9.7516E-03,8.8385E-03,9.7753E-03,1.1803E-02,
     &1.4015E-02,1.6165E-02,1.8521E-02,1.0311E-02,9.0242E-03,7.7593E-03,
     &9.8758E-03,1.4142E-02,1.7458E-02,2.0764E-02,2.3987E-02,2.7500E-02,
     &6.1007E-03,5.3334E-03,8.4379E-03,1.3947E-02,1.9967E-02,2.4665E-02,
     &2.9359E-02,3.3960E-02,3.8947E-02/
      DATA ((KA(JS,JT, 7,15),JS=1,9),JT=1,5) /
     &3.9607E-02,3.4655E-02,2.9704E-02,2.4754E-02,1.9804E-02,1.4853E-02,
     &9.9024E-03,5.6087E-03,4.7437E-03,3.8786E-02,3.3939E-02,2.9089E-02,
     &2.4244E-02,1.9395E-02,1.4546E-02,1.0087E-02,8.3483E-03,8.1480E-03,
     &3.7941E-02,3.3203E-02,2.8458E-02,2.3715E-02,1.8973E-02,1.4624E-02,
     &1.2669E-02,1.3455E-02,1.2971E-02,3.7052E-02,3.2423E-02,2.7792E-02,
     &2.3160E-02,1.8933E-02,1.7157E-02,1.8083E-02,2.0593E-02,1.9406E-02,
     &3.1592E-02,2.7646E-02,2.3693E-02,2.0299E-02,1.8491E-02,2.1228E-02,
     &2.6244E-02,2.9985E-02,2.7520E-02/
      DATA ((KA(JS,JT, 8,15),JS=1,9),JT=1,5) /
     &1.4580E-01,1.2758E-01,1.0936E-01,9.1128E-02,7.2910E-02,5.4675E-02,
     &3.6454E-02,1.8228E-02,7.5823E-04,1.4341E-01,1.2548E-01,1.0755E-01,
     &8.9631E-02,7.1703E-02,5.3780E-02,3.5854E-02,1.7928E-02,1.3701E-03,
     &1.4083E-01,1.2323E-01,1.0562E-01,8.8019E-02,7.0413E-02,5.2809E-02,
     &3.5210E-02,1.8039E-02,2.2984E-03,1.3806E-01,1.2080E-01,1.0354E-01,
     &8.6290E-02,6.9028E-02,5.1771E-02,3.4515E-02,2.0878E-02,3.6182E-03,
     &1.3508E-01,1.1820E-01,1.0132E-01,8.4431E-02,6.7546E-02,5.0657E-02,
     &3.5330E-02,2.7298E-02,5.3909E-03/
      DATA ((KA(JS,JT, 9,15),JS=1,9),JT=1,5) /
     &1.0374E+00,9.0767E-01,7.7802E-01,6.4832E-01,5.1864E-01,3.8900E-01,
     &2.5933E-01,1.2966E-01,2.1397E-06,1.0197E+00,8.9224E-01,7.6478E-01,
     &6.3733E-01,5.0988E-01,3.8239E-01,2.5493E-01,1.2747E-01,3.4826E-06,
     &1.0031E+00,8.7777E-01,7.5240E-01,6.2700E-01,5.0158E-01,3.7619E-01,
     &2.5081E-01,1.2540E-01,5.6811E-06,9.8558E-01,8.6233E-01,7.3918E-01,
     &6.1597E-01,4.9277E-01,3.6960E-01,2.4641E-01,1.2320E-01,9.7907E-06,
     &9.6612E-01,8.4542E-01,7.2465E-01,6.0387E-01,4.8310E-01,3.6231E-01,
     &2.4155E-01,1.2077E-01,1.4737E-05/
      DATA ((KA(JS,JT,10,15),JS=1,9),JT=1,5) /
     &8.9111E+00,7.7969E+00,6.6836E+00,5.5691E+00,4.4554E+00,3.3414E+00,
     &2.2275E+00,1.1138E+00,1.1507E-06,8.7649E+00,7.6684E+00,6.5728E+00,
     &5.4777E+00,4.3822E+00,3.2866E+00,2.1910E+00,1.0955E+00,1.9584E-06,
     &8.6133E+00,7.5361E+00,6.4598E+00,5.3829E+00,4.3064E+00,3.2299E+00,
     &2.1532E+00,1.0766E+00,3.2367E-06,8.4534E+00,7.3969E+00,6.3406E+00,
     &5.2836E+00,4.2270E+00,3.1701E+00,2.1135E+00,1.0568E+00,5.5316E-06,
     &8.2801E+00,7.2444E+00,6.2095E+00,5.1748E+00,4.1398E+00,3.1049E+00,
     &2.0699E+00,1.0350E+00,8.6177E-06/
      DATA ((KA(JS,JT,11,15),JS=1,9),JT=1,5) /
     &2.5435E+01,2.2258E+01,1.9079E+01,1.5898E+01,1.2719E+01,9.5392E+00,
     &6.3596E+00,3.1798E+00,8.0677E-07,2.5109E+01,2.1970E+01,1.8832E+01,
     &1.5693E+01,1.2554E+01,9.4153E+00,6.2771E+00,3.1385E+00,1.4119E-06,
     &2.4708E+01,2.1620E+01,1.8532E+01,1.5442E+01,1.2355E+01,9.2660E+00,
     &6.1771E+00,3.0885E+00,2.4283E-06,2.4206E+01,2.1181E+01,1.8155E+01,
     &1.5130E+01,1.2103E+01,9.0784E+00,6.0520E+00,3.0256E+00,3.8467E-06,
     &2.3645E+01,2.0690E+01,1.7735E+01,1.4778E+01,1.1822E+01,8.8671E+00,
     &5.9114E+00,2.9557E+00,6.2945E-06/
      DATA ((KA(JS,JT,12,15),JS=1,9),JT=1,5) /
     &4.5821E+01,4.0093E+01,3.4365E+01,2.8640E+01,2.2910E+01,1.7183E+01,
     &1.1455E+01,5.7277E+00,5.6905E-07,4.5215E+01,3.9561E+01,3.3912E+01,
     &2.8260E+01,2.2608E+01,1.6955E+01,1.1304E+01,5.6520E+00,1.0466E-06,
     &4.4441E+01,3.8886E+01,3.3332E+01,2.7776E+01,2.2220E+01,1.6665E+01,
     &1.1110E+01,5.5552E+00,1.8066E-06,4.3598E+01,3.8150E+01,3.2698E+01,
     &2.7250E+01,2.1798E+01,1.6350E+01,1.0900E+01,5.4499E+00,2.8751E-06,
     &4.2666E+01,3.7332E+01,3.2000E+01,2.6665E+01,2.1333E+01,1.6001E+01,
     &1.0666E+01,5.3333E+00,4.5303E-06/
      DATA ((KA(JS,JT,13,15),JS=1,9),JT=1,5) /
     &6.6305E+01,5.8017E+01,4.9731E+01,4.1443E+01,3.3153E+01,2.4866E+01,
     &1.6576E+01,8.2888E+00,6.5868E-07,6.5425E+01,5.7245E+01,4.9068E+01,
     &4.0889E+01,3.2711E+01,2.4534E+01,1.6356E+01,8.1783E+00,1.0770E-06,
     &6.4452E+01,5.6397E+01,4.8336E+01,4.0283E+01,3.2227E+01,2.4169E+01,
     &1.6113E+01,8.0564E+00,1.3521E-06,6.3313E+01,5.5397E+01,4.7486E+01,
     &3.9571E+01,3.1655E+01,2.3741E+01,1.5828E+01,7.9140E+00,2.2152E-06,
     &6.1963E+01,5.4219E+01,4.6473E+01,3.8726E+01,3.0982E+01,2.3236E+01,
     &1.5490E+01,7.7450E+00,3.4066E-06/
      DATA ((KA(JS,JT, 1,16),JS=1,9),JT=1,5) /
     &8.8773E-05,1.9140E-03,3.7690E-03,5.5469E-03,7.2016E-03,8.6351E-03,
     &9.6093E-03,9.3558E-03,1.4394E-02,8.4216E-05,2.7660E-03,5.4492E-03,
     &8.0218E-03,1.0416E-02,1.2486E-02,1.3893E-02,1.3527E-02,2.0822E-02,
     &8.0290E-05,3.8383E-03,7.5630E-03,1.1136E-02,1.4457E-02,1.7334E-02,
     &1.9290E-02,1.8781E-02,2.8902E-02,7.6611E-05,5.1452E-03,1.0139E-02,
     &1.4930E-02,1.9392E-02,2.3248E-02,2.5870E-02,2.5185E-02,3.8771E-02,
     &7.3163E-05,6.6935E-03,1.3197E-02,1.9435E-02,2.5235E-02,3.0263E-02,
     &3.3675E-02,3.2771E-02,5.0455E-02/
      DATA ((KA(JS,JT, 2,16),JS=1,9),JT=1,5) /
     &1.5679E-04,1.9888E-03,3.9277E-03,5.8149E-03,7.6126E-03,9.2475E-03,
     &1.0521E-02,1.0714E-02,1.5210E-02,1.4773E-04,2.9274E-03,5.7862E-03,
     &8.5677E-03,1.1217E-02,1.3627E-02,1.5504E-02,1.5787E-02,2.2417E-02,
     &1.4025E-04,4.1262E-03,8.1606E-03,1.2085E-02,1.5823E-02,1.9223E-02,
     &2.1876E-02,2.2273E-02,3.1626E-02,1.3354E-04,5.6053E-03,1.1089E-02,
     &1.6429E-02,2.1516E-02,2.6138E-02,2.9742E-02,3.0283E-02,4.3010E-02,
     &1.2725E-04,7.3793E-03,1.4605E-02,2.1632E-02,2.8334E-02,3.4423E-02,
     &3.9175E-02,3.9879E-02,5.6642E-02/
      DATA ((KA(JS,JT, 3,16),JS=1,9),JT=1,5) /
     &4.1725E-04,1.8982E-03,3.7447E-03,5.5658E-03,7.3458E-03,9.0433E-03,
     &1.0548E-02,1.1397E-02,1.4655E-02,3.9098E-04,2.8734E-03,5.6787E-03,
     &8.4482E-03,1.1153E-02,1.3733E-02,1.6021E-02,1.7312E-02,2.2262E-02,
     &3.4851E-04,4.1474E-03,8.2100E-03,1.2218E-02,1.6131E-02,1.9869E-02,
     &2.3184E-02,2.5055E-02,3.2211E-02,3.3110E-04,5.7507E-03,1.1396E-02,
     &1.6965E-02,2.2409E-02,2.7601E-02,3.2208E-02,3.4575E-02,4.4760E-02,
     &3.1495E-04,7.7054E-03,1.5281E-02,2.2758E-02,3.0062E-02,3.7025E-02,
     &4.3208E-02,4.6704E-02,6.0059E-02/
      DATA ((KA(JS,JT, 4,16),JS=1,9),JT=1,5) /
     &1.7281E-03,1.7667E-03,3.4371E-03,5.0959E-03,6.7367E-03,8.3430E-03,
     &9.8600E-03,1.1050E-02,1.3383E-02,1.1628E-03,2.7537E-03,5.3881E-03,
     &8.0069E-03,1.0596E-02,1.3125E-02,1.5518E-02,1.7399E-02,2.1083E-02,
     &1.1124E-03,4.0786E-03,8.0137E-03,1.1921E-02,1.5788E-02,1.9566E-02,
     &2.3141E-02,2.5952E-02,3.1447E-02,1.0810E-03,5.7837E-03,1.1394E-02,
     &1.6970E-02,2.2483E-02,2.7876E-02,3.2974E-02,3.6985E-02,4.4815E-02,
     &9.9376E-04,7.9012E-03,1.5599E-02,2.3249E-02,3.0813E-02,3.8207E-02,
     &4.5202E-02,5.0705E-02,6.1455E-02/
      DATA ((KA(JS,JT, 5,16),JS=1,9),JT=1,5) /
     &5.4114E-03,4.7354E-03,4.0587E-03,4.6142E-03,6.0695E-03,7.5080E-03,
     &8.9059E-03,1.0147E-02,1.1928E-02,5.1867E-03,4.5542E-03,5.0981E-03,
     &7.5059E-03,9.9017E-03,1.2267E-02,1.4567E-02,1.6610E-02,1.9542E-02,
     &3.0269E-03,2.6488E-03,7.7938E-03,1.1517E-02,1.5221E-02,1.8876E-02,
     &2.2431E-02,2.5594E-02,3.0125E-02,2.9184E-03,2.5534E-03,1.1353E-02,
     &1.6816E-02,2.2248E-02,2.7623E-02,3.2847E-02,3.7486E-02,4.4122E-02,
     &2.8186E-03,8.1567E-03,1.5865E-02,2.3545E-02,3.1185E-02,3.8732E-02,
     &4.6076E-02,5.2599E-02,6.1936E-02/
      DATA ((KA(JS,JT, 6,16),JS=1,9),JT=1,5) /
     &1.4590E-02,1.2765E-02,1.0941E-02,9.1186E-03,7.2947E-03,6.5373E-03,
     &7.7212E-03,8.8306E-03,1.0195E-02,1.4301E-02,1.2513E-02,1.0724E-02,
     &8.9392E-03,9.0428E-03,1.1132E-02,1.3188E-02,1.5117E-02,1.7482E-02,
     &1.3976E-02,1.2228E-02,1.0485E-02,1.0970E-02,1.4363E-02,1.7735E-02,
     &2.1052E-02,2.4167E-02,2.7980E-02,7.5839E-03,6.6346E-03,9.3364E-03,
     &1.6444E-02,2.1598E-02,2.6720E-02,3.1771E-02,3.6510E-02,4.2297E-02,
     &7.3499E-03,6.4297E-03,1.6063E-02,2.3546E-02,3.1010E-02,3.8427E-02,
     &4.5729E-02,5.2589E-02,6.0961E-02/
      DATA ((KA(JS,JT, 7,16),JS=1,9),JT=1,5) /
     &4.2002E-02,3.6747E-02,3.1501E-02,2.6251E-02,2.1002E-02,1.5754E-02,
     &1.0500E-02,7.5058E-03,8.4905E-03,4.1348E-02,3.6182E-02,3.1017E-02,
     &2.5842E-02,2.0675E-02,1.5509E-02,1.1819E-02,1.3466E-02,1.5310E-02,
     &4.0563E-02,3.5489E-02,3.0424E-02,2.5351E-02,2.0286E-02,1.6643E-02,
     &1.9563E-02,2.2386E-02,2.5539E-02,3.9401E-02,3.4717E-02,2.9752E-02,
     &2.4793E-02,2.1115E-02,2.5798E-02,3.0449E-02,3.4941E-02,3.9945E-02,
     &2.0373E-02,1.7827E-02,1.5278E-02,1.2733E-02,3.0987E-02,3.8017E-02,
     &4.4987E-02,5.1736E-02,5.9242E-02/
      DATA ((KA(JS,JT, 8,16),JS=1,9),JT=1,5) /
     &1.5400E-01,1.3474E-01,1.1553E-01,9.6239E-02,7.7005E-02,5.7761E-02,
     &3.8504E-02,1.9252E-02,6.9298E-03,1.5231E-01,1.3330E-01,1.1425E-01,
     &9.5219E-02,7.6158E-02,5.7117E-02,3.8082E-02,1.9041E-02,1.3109E-02,
     &1.4996E-01,1.3122E-01,1.1247E-01,9.3714E-02,7.4984E-02,5.6235E-02,
     &3.7492E-02,2.0794E-02,2.1673E-02,1.4710E-01,1.2871E-01,1.1034E-01,
     &9.1947E-02,7.3562E-02,5.5161E-02,3.6783E-02,3.3457E-02,3.2749E-02,
     &1.4389E-01,1.2590E-01,1.0792E-01,8.9927E-02,7.1955E-02,5.3965E-02,
     &4.4963E-02,5.0849E-02,4.4095E-02/
      DATA ((KA(JS,JT, 9,16),JS=1,9),JT=1,5) /
     &1.0859E+00,9.5014E-01,8.1454E-01,6.7879E-01,5.4303E-01,4.0724E-01,
     &2.7149E-01,1.3574E-01,5.1220E-06,1.0768E+00,9.4216E-01,8.0759E-01,
     &6.7299E-01,5.3840E-01,4.0381E-01,2.6917E-01,1.3460E-01,1.2021E-05,
     &1.0636E+00,9.3068E-01,7.9788E-01,6.6477E-01,5.3197E-01,3.9888E-01,
     &2.6599E-01,1.3299E-01,2.0747E-05,1.0462E+00,9.1536E-01,7.8477E-01,
     &6.5394E-01,5.2317E-01,3.9241E-01,2.6164E-01,1.3081E-01,2.6757E-05,
     &1.0256E+00,8.9712E-01,7.6891E-01,6.4089E-01,5.1277E-01,3.8454E-01,
     &2.5635E-01,1.2820E-01,3.3237E-05/
      DATA ((KA(JS,JT,10,16),JS=1,9),JT=1,5) /
     &9.2943E+00,8.1330E+00,6.9713E+00,5.8089E+00,4.6478E+00,3.4621E+00,
     &2.3237E+00,1.1620E+00,2.5199E-06,9.1327E+00,7.9905E+00,6.8491E+00,
     &5.7077E+00,4.5656E+00,3.4245E+00,2.2832E+00,1.1416E+00,6.1820E-06,
     &9.0419E+00,7.9114E+00,6.7812E+00,5.6501E+00,4.5208E+00,3.3897E+00,
     &2.2603E+00,1.1303E+00,1.2253E-05,8.9128E+00,7.7986E+00,6.6845E+00,
     &5.5708E+00,4.4561E+00,3.3428E+00,2.2285E+00,1.1142E+00,1.7974E-05,
     &8.7796E+00,7.6831E+00,6.5851E+00,5.4876E+00,4.3892E+00,3.2921E+00,
     &2.1948E+00,1.0975E+00,2.4232E-05/
      DATA ((KA(JS,JT,11,16),JS=1,9),JT=1,5) /
     &2.7588E+01,2.4141E+01,2.0693E+01,1.7244E+01,1.3795E+01,1.0345E+01,
     &6.8978E+00,3.4484E+00,2.0595E-06,2.6657E+01,2.3323E+01,1.9991E+01,
     &1.6660E+01,1.3327E+01,9.9952E+00,6.6638E+00,3.3322E+00,4.7312E-06,
     &2.5989E+01,2.2740E+01,1.9493E+01,1.6242E+01,1.2994E+01,9.7462E+00,
     &6.4977E+00,3.2488E+00,8.7718E-06,2.5704E+01,2.2492E+01,1.9279E+01,
     &1.6066E+01,1.2854E+01,9.6403E+00,6.4266E+00,3.2130E+00,1.4050E-05,
     &2.5636E+01,2.2431E+01,1.9229E+01,1.6023E+01,1.2819E+01,9.6138E+00,
     &6.4100E+00,3.2046E+00,1.9441E-05/
      DATA ((KA(JS,JT,12,16),JS=1,9),JT=1,5) /
     &5.2064E+01,4.5551E+01,3.9046E+01,3.2542E+01,2.6032E+01,1.9524E+01,
     &1.3016E+01,6.5078E+00,1.7091E-06,5.0183E+01,4.3912E+01,3.7638E+01,
     &3.1363E+01,2.5091E+01,1.8819E+01,1.2545E+01,6.2729E+00,3.7298E-06,
     &4.8961E+01,4.2840E+01,3.6719E+01,3.0598E+01,2.4478E+01,1.8358E+01,
     &1.2239E+01,6.1197E+00,6.4267E-06,4.8192E+01,4.2165E+01,3.6143E+01,
     &3.0118E+01,2.4096E+01,1.8071E+01,1.2047E+01,6.0236E+00,1.0438E-05,
     &4.7950E+01,4.1951E+01,3.5955E+01,2.9964E+01,2.3968E+01,1.7977E+01,
     &1.1985E+01,5.9924E+00,1.5532E-05/
      DATA ((KA(JS,JT,13,16),JS=1,9),JT=1,5) /
     &7.9237E+01,6.9320E+01,5.9418E+01,4.9515E+01,3.9615E+01,2.9712E+01,
     &1.9806E+01,9.9046E+00,1.3997E-06,7.6481E+01,6.6913E+01,5.7358E+01,
     &4.7795E+01,3.8238E+01,2.8679E+01,1.9119E+01,9.5593E+00,2.8864E-06,
     &7.4663E+01,6.5336E+01,5.5998E+01,4.6664E+01,3.7331E+01,2.7999E+01,
     &1.8666E+01,9.3324E+00,4.8512E-06,7.3334E+01,6.4170E+01,5.5002E+01,
     &4.5830E+01,3.6668E+01,2.7499E+01,1.8332E+01,9.1667E+00,7.8505E-06,
     &7.2543E+01,6.3471E+01,5.4398E+01,4.5335E+01,3.6267E+01,2.7201E+01,
     &1.8133E+01,9.0671E+00,1.1235E-05/

C     The array KB contains absorption coefs at the 16 chosen g-values 
C     for a range of pressure levels < ~100mb and temperatures. The first 
C     index in the array, JT, which runs from 1 to 5, corresponds to 
C     different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this pressure 
C     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
C     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
C     The second index, JP, runs from 13 to 59 and refers to the JPth
C     reference pressure level (see taumol.f for the value of these
C     pressure levels in mb).  The third index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA (KB(JT,13, 1),JT=1,5) /
     &6.2747E-02,8.6102E-02,1.1568E-01,1.5208E-01,1.9535E-01/
      DATA (KB(JT,14, 1),JT=1,5) /
     &5.7861E-02,7.9151E-02,1.0594E-01,1.3846E-01,1.7643E-01/
      DATA (KB(JT,15, 1),JT=1,5) /
     &5.3092E-02,7.2482E-02,9.6781E-02,1.2588E-01,1.5918E-01/
      DATA (KB(JT,16, 1),JT=1,5) /
     &4.8457E-02,6.6047E-02,8.7760E-02,1.1351E-01,1.4288E-01/
      DATA (KB(JT,17, 1),JT=1,5) /
     &4.3912E-02,5.9676E-02,7.8923E-02,1.0151E-01,1.2709E-01/
      DATA (KB(JT,18, 1),JT=1,5) /
     &3.9426E-02,5.3365E-02,7.0341E-02,8.9953E-02,1.1230E-01/
      DATA (KB(JT,19, 1),JT=1,5) /
     &3.5046E-02,4.7312E-02,6.2046E-02,7.9063E-02,9.8334E-02/
      DATA (KB(JT,20, 1),JT=1,5) /
     &3.1115E-02,4.1839E-02,5.4636E-02,6.9407E-02,8.5975E-02/
      DATA (KB(JT,21, 1),JT=1,5) /
     &2.7465E-02,3.6785E-02,4.7830E-02,6.0600E-02,7.4770E-02/
      DATA (KB(JT,22, 1),JT=1,5) /
     &2.4593E-02,3.2747E-02,4.2384E-02,5.3412E-02,6.5545E-02/
      DATA (KB(JT,23, 1),JT=1,5) /
     &2.1937E-02,2.9046E-02,3.7411E-02,4.6873E-02,5.7167E-02/
      DATA (KB(JT,24, 1),JT=1,5) /
     &1.9516E-02,2.5711E-02,3.2910E-02,4.0910E-02,4.9576E-02/
      DATA (KB(JT,25, 1),JT=1,5) /
     &1.7347E-02,2.2706E-02,2.8823E-02,3.5568E-02,4.2803E-02/
      DATA (KB(JT,26, 1),JT=1,5) /
     &1.5431E-02,2.0022E-02,2.5209E-02,3.0861E-02,3.6863E-02/
      DATA (KB(JT,27, 1),JT=1,5) /
     &1.3676E-02,1.7588E-02,2.1954E-02,2.6656E-02,3.1628E-02/
      DATA (KB(JT,28, 1),JT=1,5) /
     &1.2072E-02,1.5389E-02,1.9040E-02,2.2944E-02,2.7092E-02/
      DATA (KB(JT,29, 1),JT=1,5) /
     &1.0638E-02,1.3440E-02,1.6483E-02,1.9764E-02,2.3215E-02/
      DATA (KB(JT,30, 1),JT=1,5) /
     &9.3452E-03,1.1695E-02,1.4256E-02,1.7011E-02,1.9889E-02/
      DATA (KB(JT,31, 1),JT=1,5) /
     &8.1958E-03,1.0179E-02,1.2343E-02,1.4653E-02,1.7063E-02/
      DATA (KB(JT,32, 1),JT=1,5) /
     &7.1787E-03,8.8627E-03,1.0685E-02,1.2626E-02,1.4630E-02/
      DATA (KB(JT,33, 1),JT=1,5) /
     &6.2851E-03,7.7078E-03,9.2476E-03,1.0876E-02,1.2551E-02/
      DATA (KB(JT,34, 1),JT=1,5) /
     &5.4503E-03,6.6513E-03,7.9437E-03,9.3044E-03,1.0718E-02/
      DATA (KB(JT,35, 1),JT=1,5) /
     &4.6286E-03,5.6362E-03,6.7164E-03,7.8605E-03,9.0307E-03/
      DATA (KB(JT,36, 1),JT=1,5) /
     &3.8439E-03,4.6777E-03,5.5784E-03,6.5325E-03,7.4907E-03/
      DATA (KB(JT,37, 1),JT=1,5) /
     &3.0907E-03,3.7733E-03,4.5151E-03,5.2952E-03,6.0875E-03/
      DATA (KB(JT,38, 1),JT=1,5) /
     &2.4803E-03,3.0385E-03,3.6485E-03,4.2895E-03,4.9493E-03/
      DATA (KB(JT,39, 1),JT=1,5) /
     &1.9914E-03,2.4489E-03,2.9506E-03,3.4809E-03,4.0250E-03/
      DATA (KB(JT,40, 1),JT=1,5) /
     &1.5591E-03,1.9289E-03,2.3368E-03,2.7699E-03,3.2181E-03/
      DATA (KB(JT,41, 1),JT=1,5) /
     &1.2156E-03,1.5132E-03,1.8431E-03,2.1975E-03,2.5662E-03/
      DATA (KB(JT,42, 1),JT=1,5) /
     &9.4642E-04,1.1860E-03,1.4531E-03,1.7422E-03,2.0436E-03/
      DATA (KB(JT,43, 1),JT=1,5) /
     &7.2576E-04,9.1670E-04,1.1319E-03,1.3659E-03,1.6136E-03/
      DATA (KB(JT,44, 1),JT=1,5) /
     &5.5191E-04,7.0339E-04,8.7651E-04,1.0654E-03,1.2677E-03/
      DATA (KB(JT,45, 1),JT=1,5) /
     &4.1864E-04,5.3928E-04,6.7793E-04,8.3043E-04,9.9568E-04/
      DATA (KB(JT,46, 1),JT=1,5) /
     &3.1490E-04,4.0992E-04,5.2032E-04,6.4322E-04,7.7812E-04/
      DATA (KB(JT,47, 1),JT=1,5) /
     &2.3273E-04,3.0659E-04,3.9375E-04,4.9208E-04,6.0088E-04/
      DATA (KB(JT,48, 1),JT=1,5) /
     &1.7128E-04,2.2854E-04,2.9725E-04,3.7557E-04,4.6327E-04/
      DATA (KB(JT,49, 1),JT=1,5) /
     &1.2553E-04,1.6987E-04,2.2375E-04,2.8623E-04,3.5677E-04/
      DATA (KB(JT,50, 1),JT=1,5) /
     &9.2117E-05,1.2634E-04,1.6842E-04,2.1802E-04,2.7404E-04/
      DATA (KB(JT,51, 1),JT=1,5) /
     &6.7482E-05,9.3783E-05,1.2646E-04,1.6541E-04,2.1004E-04/
      DATA (KB(JT,52, 1),JT=1,5) /
     &4.9294E-05,6.9377E-05,9.4622E-05,1.2516E-04,1.6083E-04/
      DATA (KB(JT,53, 1),JT=1,5) /
     &3.5898E-05,5.1131E-05,7.0555E-05,9.4518E-05,1.2315E-04/
      DATA (KB(JT,54, 1),JT=1,5) /
     &2.6237E-05,3.7710E-05,5.2593E-05,7.1209E-05,9.3663E-05/
      DATA (KB(JT,55, 1),JT=1,5) /
     &1.9162E-05,2.7753E-05,3.9112E-05,5.3467E-05,7.0840E-05/
      DATA (KB(JT,56, 1),JT=1,5) /
     &1.3954E-05,2.0386E-05,2.8986E-05,3.9982E-05,5.3468E-05/
      DATA (KB(JT,57, 1),JT=1,5) /
     &1.0137E-05,1.4950E-05,2.1433E-05,2.9844E-05,4.0285E-05/
      DATA (KB(JT,58, 1),JT=1,5) /
     &7.3955E-06,1.0988E-05,1.5849E-05,2.2304E-05,3.0355E-05/
      DATA (KB(JT,59, 1),JT=1,5) /
     &5.7756E-06,8.5841E-06,1.2417E-05,1.7454E-05,2.3825E-05/
      DATA (KB(JT,13, 2),JT=1,5) /
     &2.8941E-01,3.7928E-01,4.8728E-01,6.1356E-01,7.5720E-01/
      DATA (KB(JT,14, 2),JT=1,5) /
     &2.7482E-01,3.5907E-01,4.5923E-01,5.7444E-01,7.0479E-01/
      DATA (KB(JT,15, 2),JT=1,5) /
     &2.6012E-01,3.3844E-01,4.3050E-01,5.3565E-01,6.5360E-01/
      DATA (KB(JT,16, 2),JT=1,5) /
     &2.4469E-01,3.1749E-01,4.0174E-01,4.9749E-01,6.0352E-01/
      DATA (KB(JT,17, 2),JT=1,5) /
     &2.2805E-01,2.9482E-01,3.7163E-01,4.5800E-01,5.5300E-01/
      DATA (KB(JT,18, 2),JT=1,5) /
     &2.1066E-01,2.7121E-01,3.4050E-01,4.1816E-01,5.0173E-01/
      DATA (KB(JT,19, 2),JT=1,5) /
     &1.9258E-01,2.4696E-01,3.0899E-01,3.7763E-01,4.5019E-01/
      DATA (KB(JT,20, 2),JT=1,5) /
     &1.7535E-01,2.2386E-01,2.7870E-01,3.3833E-01,4.0121E-01/
      DATA (KB(JT,21, 2),JT=1,5) /
     &1.5823E-01,2.0117E-01,2.4903E-01,3.0059E-01,3.5459E-01/
      DATA (KB(JT,22, 2),JT=1,5) /
     &1.4393E-01,1.8176E-01,2.2349E-01,2.6801E-01,3.1434E-01/
      DATA (KB(JT,23, 2),JT=1,5) /
     &1.2993E-01,1.6307E-01,1.9923E-01,2.3752E-01,2.7733E-01/
      DATA (KB(JT,24, 2),JT=1,5) /
     &1.1668E-01,1.4559E-01,1.7680E-01,2.0966E-01,2.4384E-01/
      DATA (KB(JT,25, 2),JT=1,5) /
     &1.0441E-01,1.2946E-01,1.5637E-01,1.8462E-01,2.1368E-01/
      DATA (KB(JT,26, 2),JT=1,5) /
     &9.3354E-02,1.1505E-01,1.3816E-01,1.6244E-01,1.8706E-01/
      DATA (KB(JT,27, 2),JT=1,5) /
     &8.3171E-02,1.0190E-01,1.2182E-01,1.4246E-01,1.6301E-01/
      DATA (KB(JT,28, 2),JT=1,5) /
     &7.3897E-02,9.0049E-02,1.0712E-01,1.2442E-01,1.4130E-01/
      DATA (KB(JT,29, 2),JT=1,5) /
     &6.5628E-02,7.9501E-02,9.3908E-02,1.0826E-01,1.2190E-01/
      DATA (KB(JT,30, 2),JT=1,5) /
     &5.8144E-02,6.9960E-02,8.1950E-02,9.3660E-02,1.0454E-01/
      DATA (KB(JT,31, 2),JT=1,5) /
     &5.1413E-02,6.1336E-02,7.1221E-02,8.0615E-02,8.9347E-02/
      DATA (KB(JT,32, 2),JT=1,5) /
     &4.5308E-02,5.3538E-02,6.1586E-02,6.9140E-02,7.6180E-02/
      DATA (KB(JT,33, 2),JT=1,5) /
     &3.9776E-02,4.6552E-02,5.3085E-02,5.9155E-02,6.4885E-02/
      DATA (KB(JT,34, 2),JT=1,5) /
     &3.4566E-02,4.0142E-02,4.5387E-02,5.0362E-02,5.5085E-02/
      DATA (KB(JT,35, 2),JT=1,5) /
     &2.9501E-02,3.4063E-02,3.8371E-02,4.2482E-02,4.6355E-02/
      DATA (KB(JT,36, 2),JT=1,5) /
     &2.4731E-02,2.8480E-02,3.2042E-02,3.5445E-02,3.8685E-02/
      DATA (KB(JT,37, 2),JT=1,5) /
     &2.0227E-02,2.3337E-02,2.6311E-02,2.9150E-02,3.1875E-02/
      DATA (KB(JT,38, 2),JT=1,5) /
     &1.6522E-02,1.9118E-02,2.1594E-02,2.3970E-02,2.6280E-02/
      DATA (KB(JT,39, 2),JT=1,5) /
     &1.3506E-02,1.5663E-02,1.7734E-02,1.9723E-02,2.1666E-02/
      DATA (KB(JT,40, 2),JT=1,5) /
     &1.0839E-02,1.2642E-02,1.4374E-02,1.6039E-02,1.7665E-02/
      DATA (KB(JT,41, 2),JT=1,5) /
     &8.6687E-03,1.0169E-02,1.1614E-02,1.3014E-02,1.4376E-02/
      DATA (KB(JT,42, 2),JT=1,5) /
     &6.9249E-03,8.1709E-03,9.3824E-03,1.0556E-02,1.1694E-02/
      DATA (KB(JT,43, 2),JT=1,5) /
     &5.4677E-03,6.5006E-03,7.5154E-03,8.4985E-03,9.4530E-03/
      DATA (KB(JT,44, 2),JT=1,5) /
     &4.2855E-03,5.1437E-03,5.9926E-03,6.8145E-03,7.6201E-03/
      DATA (KB(JT,45, 2),JT=1,5) /
     &3.3515E-03,4.0607E-03,4.7699E-03,5.4599E-03,6.1332E-03/
      DATA (KB(JT,46, 2),JT=1,5) /
     &2.6019E-03,3.1870E-03,3.7777E-03,4.3556E-03,4.9205E-03/
      DATA (KB(JT,47, 2),JT=1,5) /
     &1.9902E-03,2.4722E-03,2.9627E-03,3.4486E-03,3.9210E-03/
      DATA (KB(JT,48, 2),JT=1,5) /
     &1.5153E-03,1.9102E-03,2.3171E-03,2.7244E-03,3.1206E-03/
      DATA (KB(JT,49, 2),JT=1,5) /
     &1.1469E-03,1.4720E-03,1.8085E-03,2.1494E-03,2.4830E-03/
      DATA (KB(JT,50, 2),JT=1,5) /
     &8.6648E-04,1.1333E-03,1.4108E-03,1.6953E-03,1.9769E-03/
      DATA (KB(JT,51, 2),JT=1,5) /
     &6.5125E-04,8.6980E-04,1.0984E-03,1.3342E-03,1.5715E-03/
      DATA (KB(JT,52, 2),JT=1,5) /
     &4.8660E-04,6.6498E-04,8.5250E-04,1.0475E-03,1.2461E-03/
      DATA (KB(JT,53, 2),JT=1,5) /
     &3.6091E-04,5.0560E-04,6.5947E-04,8.2040E-04,9.8603E-04/
      DATA (KB(JT,54, 2),JT=1,5) /
     &2.6798E-04,3.8317E-04,5.0899E-04,6.4130E-04,7.7856E-04/
      DATA (KB(JT,55, 2),JT=1,5) /
     &1.9837E-04,2.8906E-04,3.9148E-04,4.9955E-04,6.1247E-04/
      DATA (KB(JT,56, 2),JT=1,5) /
     &1.4613E-04,2.1685E-04,3.0004E-04,3.8773E-04,4.8096E-04/
      DATA (KB(JT,57, 2),JT=1,5) /
     &1.0691E-04,1.6173E-04,2.2873E-04,3.0001E-04,3.7637E-04/
      DATA (KB(JT,58, 2),JT=1,5) /
     &7.8236E-05,1.2069E-04,1.7421E-04,2.3200E-04,2.9412E-04/
      DATA (KB(JT,59, 2),JT=1,5) /
     &6.1826E-05,9.5990E-05,1.3927E-04,1.8625E-04,2.3654E-04/
      DATA (KB(JT,13, 3),JT=1,5) /
     &1.1135E+00,1.3641E+00,1.6160E+00,1.8652E+00,2.1134E+00/
      DATA (KB(JT,14, 3),JT=1,5) /
     &1.0304E+00,1.2521E+00,1.4746E+00,1.6946E+00,1.9141E+00/
      DATA (KB(JT,15, 3),JT=1,5) /
     &9.5384E-01,1.1492E+00,1.3443E+00,1.5379E+00,1.7345E+00/
      DATA (KB(JT,16, 3),JT=1,5) /
     &8.8007E-01,1.0512E+00,1.2220E+00,1.3952E+00,1.5691E+00/
      DATA (KB(JT,17, 3),JT=1,5) /
     &8.0715E-01,9.5537E-01,1.1063E+00,1.2596E+00,1.4122E+00/
      DATA (KB(JT,18, 3),JT=1,5) /
     &7.3500E-01,8.6436E-01,9.9708E-01,1.1308E+00,1.2638E+00/
      DATA (KB(JT,19, 3),JT=1,5) /
     &6.6442E-01,7.7800E-01,8.9341E-01,1.0094E+00,1.1240E+00/
      DATA (KB(JT,20, 3),JT=1,5) /
     &5.9870E-01,6.9782E-01,7.9815E-01,8.9858E-01,9.9720E-01/
      DATA (KB(JT,21, 3),JT=1,5) /
     &5.3577E-01,6.2165E-01,7.0893E-01,7.9562E-01,8.8013E-01/
      DATA (KB(JT,22, 3),JT=1,5) /
     &4.8056E-01,5.5531E-01,6.3060E-01,7.0436E-01,7.7687E-01/
      DATA (KB(JT,23, 3),JT=1,5) /
     &4.2855E-01,4.9296E-01,5.5690E-01,6.1984E-01,6.8212E-01/
      DATA (KB(JT,24, 3),JT=1,5) /
     &3.8024E-01,4.3497E-01,4.8911E-01,5.4325E-01,5.9676E-01/
      DATA (KB(JT,25, 3),JT=1,5) /
     &3.3570E-01,3.8197E-01,4.2813E-01,4.7450E-01,5.2085E-01/
      DATA (KB(JT,26, 3),JT=1,5) /
     &2.9535E-01,3.3462E-01,3.7428E-01,4.1425E-01,4.5431E-01/
      DATA (KB(JT,27, 3),JT=1,5) /
     &2.5873E-01,2.9239E-01,3.2655E-01,3.6110E-01,3.9601E-01/
      DATA (KB(JT,28, 3),JT=1,5) /
     &2.2605E-01,2.5498E-01,2.8445E-01,3.1460E-01,3.4506E-01/
      DATA (KB(JT,29, 3),JT=1,5) /
     &1.9728E-01,2.2221E-01,2.4794E-01,2.7429E-01,3.0081E-01/
      DATA (KB(JT,30, 3),JT=1,5) /
     &1.7195E-01,1.9369E-01,2.1631E-01,2.3929E-01,2.6198E-01/
      DATA (KB(JT,31, 3),JT=1,5) /
     &1.5004E-01,1.6915E-01,1.8896E-01,2.0886E-01,2.2799E-01/
      DATA (KB(JT,32, 3),JT=1,5) /
     &1.3116E-01,1.4802E-01,1.6521E-01,1.8200E-01,1.9806E-01/
      DATA (KB(JT,33, 3),JT=1,5) /
     &1.1493E-01,1.2958E-01,1.4418E-01,1.5826E-01,1.7170E-01/
      DATA (KB(JT,34, 3),JT=1,5) /
     &1.0026E-01,1.1281E-01,1.2510E-01,1.3692E-01,1.4804E-01/
      DATA (KB(JT,35, 3),JT=1,5) /
     &8.6407E-02,9.7015E-02,1.0743E-01,1.1729E-01,1.2663E-01/
      DATA (KB(JT,36, 3),JT=1,5) /
     &7.3396E-02,8.2443E-02,9.1165E-02,9.9519E-02,1.0753E-01/
      DATA (KB(JT,37, 3),JT=1,5) /
     &6.1173E-02,6.8860E-02,7.6255E-02,8.3361E-02,9.0284E-02/
      DATA (KB(JT,38, 3),JT=1,5) /
     &5.0910E-02,5.7435E-02,6.3715E-02,6.9817E-02,7.5733E-02/
      DATA (KB(JT,39, 3),JT=1,5) /
     &4.2376E-02,4.7913E-02,5.3247E-02,5.8502E-02,6.3619E-02/
      DATA (KB(JT,40, 3),JT=1,5) /
     &3.4748E-02,3.9459E-02,4.3993E-02,4.8510E-02,5.2956E-02/
      DATA (KB(JT,41, 3),JT=1,5) /
     &2.8418E-02,3.2417E-02,3.6282E-02,4.0161E-02,4.3993E-02/
      DATA (KB(JT,42, 3),JT=1,5) /
     &2.3210E-02,2.6614E-02,2.9916E-02,3.3242E-02,3.6540E-02/
      DATA (KB(JT,43, 3),JT=1,5) /
     &1.8779E-02,2.1673E-02,2.4493E-02,2.7336E-02,3.0182E-02/
      DATA (KB(JT,44, 3),JT=1,5) /
     &1.5102E-02,1.7567E-02,1.9972E-02,2.2410E-02,2.4858E-02/
      DATA (KB(JT,45, 3),JT=1,5) /
     &1.2119E-02,1.4212E-02,1.6271E-02,1.8344E-02,2.0451E-02/
      DATA (KB(JT,46, 3),JT=1,5) /
     &9.6639E-03,1.1430E-02,1.3190E-02,1.4958E-02,1.6759E-02/
      DATA (KB(JT,47, 3),JT=1,5) /
     &7.6185E-03,9.1001E-03,1.0599E-02,1.2098E-02,1.3639E-02/
      DATA (KB(JT,48, 3),JT=1,5) /
     &5.9842E-03,7.2206E-03,8.5005E-03,9.7716E-03,1.1086E-02/
      DATA (KB(JT,49, 3),JT=1,5) /
     &4.6860E-03,5.7121E-03,6.7999E-03,7.8773E-03,8.9943E-03/
      DATA (KB(JT,50, 3),JT=1,5) /
     &3.6738E-03,4.5201E-03,5.4386E-03,6.3525E-03,7.2951E-03/
      DATA (KB(JT,51, 3),JT=1,5) /
     &2.8749E-03,3.5695E-03,4.3389E-03,5.1158E-03,5.9116E-03/
      DATA (KB(JT,52, 3),JT=1,5) /
     &2.2412E-03,2.8111E-03,3.4548E-03,4.1149E-03,4.7853E-03/
      DATA (KB(JT,53, 3),JT=1,5) /
     &1.7396E-03,2.2062E-03,2.7406E-03,3.3024E-03,3.8694E-03/
      DATA (KB(JT,54, 3),JT=1,5) /
     &1.3505E-03,1.7325E-03,2.1715E-03,2.6457E-03,3.1233E-03/
      DATA (KB(JT,55, 3),JT=1,5) /
     &1.0458E-03,1.3574E-03,1.7165E-03,2.1138E-03,2.5149E-03/
      DATA (KB(JT,56, 3),JT=1,5) /
     &8.0583E-04,1.0599E-03,1.3530E-03,1.6840E-03,2.0192E-03/
      DATA (KB(JT,57, 3),JT=1,5) /
     &6.1766E-04,8.2479E-04,1.0628E-03,1.3371E-03,1.6185E-03/
      DATA (KB(JT,58, 3),JT=1,5) /
     &4.7327E-04,6.4160E-04,8.3562E-04,1.0608E-03,1.2972E-03/
      DATA (KB(JT,59, 3),JT=1,5) /
     &3.8292E-04,5.2222E-04,6.8284E-04,8.6897E-04,1.0664E-03/
      DATA (KB(JT,13, 4),JT=1,5) /
     &3.3749E+00,3.6005E+00,3.8557E+00,4.1032E+00,4.3385E+00/
      DATA (KB(JT,14, 4),JT=1,5) /
     &2.9858E+00,3.1916E+00,3.4148E+00,3.6458E+00,3.8704E+00/
      DATA (KB(JT,15, 4),JT=1,5) /
     &2.6360E+00,2.8231E+00,3.0273E+00,3.2443E+00,3.4520E+00/
      DATA (KB(JT,16, 4),JT=1,5) /
     &2.3243E+00,2.4974E+00,2.6921E+00,2.8866E+00,3.0804E+00/
      DATA (KB(JT,17, 4),JT=1,5) /
     &2.0501E+00,2.2124E+00,2.3895E+00,2.5647E+00,2.7458E+00/
      DATA (KB(JT,18, 4),JT=1,5) /
     &1.8079E+00,1.9578E+00,2.1149E+00,2.2757E+00,2.4444E+00/
      DATA (KB(JT,19, 4),JT=1,5) /
     &1.5916E+00,1.7262E+00,1.8683E+00,2.0160E+00,2.1705E+00/
      DATA (KB(JT,20, 4),JT=1,5) /
     &1.3988E+00,1.5220E+00,1.6508E+00,1.7854E+00,1.9234E+00/
      DATA (KB(JT,21, 4),JT=1,5) /
     &1.2283E+00,1.3399E+00,1.4559E+00,1.5766E+00,1.6985E+00/
      DATA (KB(JT,22, 4),JT=1,5) /
     &1.0842E+00,1.1844E+00,1.2884E+00,1.3958E+00,1.5035E+00/
      DATA (KB(JT,23, 4),JT=1,5) /
     &9.5535E-01,1.0448E+00,1.1388E+00,1.2338E+00,1.3273E+00/
      DATA (KB(JT,24, 4),JT=1,5) /
     &8.3937E-01,9.2038E-01,1.0041E+00,1.0871E+00,1.1675E+00/
      DATA (KB(JT,25, 4),JT=1,5) /
     &7.3697E-01,8.0962E-01,8.8296E-01,9.5450E-01,1.0251E+00/
      DATA (KB(JT,26, 4),JT=1,5) /
     &6.4730E-01,7.1109E-01,7.7450E-01,8.3674E-01,9.0032E-01/
      DATA (KB(JT,27, 4),JT=1,5) /
     &5.6756E-01,6.2293E-01,6.7780E-01,7.3355E-01,7.9083E-01/
      DATA (KB(JT,28, 4),JT=1,5) /
     &4.9666E-01,5.4463E-01,5.9308E-01,6.4333E-01,6.9525E-01/
      DATA (KB(JT,29, 4),JT=1,5) /
     &4.3427E-01,4.7629E-01,5.1987E-01,5.6530E-01,6.1288E-01/
      DATA (KB(JT,30, 4),JT=1,5) /
     &3.7957E-01,4.1709E-01,4.5651E-01,4.9797E-01,5.4181E-01/
      DATA (KB(JT,31, 4),JT=1,5) /
     &3.3226E-01,3.6617E-01,4.0201E-01,4.4025E-01,4.8083E-01/
      DATA (KB(JT,32, 4),JT=1,5) /
     &2.9152E-01,3.2232E-01,3.5534E-01,3.9102E-01,4.2785E-01/
      DATA (KB(JT,33, 4),JT=1,5) /
     &2.5658E-01,2.8478E-01,3.1566E-01,3.4846E-01,3.8205E-01/
      DATA (KB(JT,34, 4),JT=1,5) /
     &2.2568E-01,2.5200E-01,2.8059E-01,3.1045E-01,3.4133E-01/
      DATA (KB(JT,35, 4),JT=1,5) /
     &1.9721E-01,2.2158E-01,2.4755E-01,2.7492E-01,3.0313E-01/
      DATA (KB(JT,36, 4),JT=1,5) /
     &1.7069E-01,1.9278E-01,2.1640E-01,2.4134E-01,2.6698E-01/
      DATA (KB(JT,37, 4),JT=1,5) /
     &1.4514E-01,1.6486E-01,1.8617E-01,2.0876E-01,2.3216E-01/
      DATA (KB(JT,38, 4),JT=1,5) /
     &1.2328E-01,1.4085E-01,1.6011E-01,1.8057E-01,2.0182E-01/
      DATA (KB(JT,39, 4),JT=1,5) /
     &1.0472E-01,1.2042E-01,1.3775E-01,1.5631E-01,1.7570E-01/
      DATA (KB(JT,40, 4),JT=1,5) /
     &8.7593E-02,1.0140E-01,1.1682E-01,1.3356E-01,1.5106E-01/
      DATA (KB(JT,41, 4),JT=1,5) /
     &7.2991E-02,8.5111E-02,9.8743E-02,1.1375E-01,1.2963E-01/
      DATA (KB(JT,42, 4),JT=1,5) /
     &6.0719E-02,7.1311E-02,8.3382E-02,9.6810E-02,1.1115E-01/
      DATA (KB(JT,43, 4),JT=1,5) /
     &4.9944E-02,5.9103E-02,6.9670E-02,8.1603E-02,9.4469E-02/
      DATA (KB(JT,44, 4),JT=1,5) /
     &4.0785E-02,4.8637E-02,5.7853E-02,6.8379E-02,7.9912E-02/
      DATA (KB(JT,45, 4),JT=1,5) /
     &3.3215E-02,3.9939E-02,4.7926E-02,5.7208E-02,6.7537E-02/
      DATA (KB(JT,46, 4),JT=1,5) /
     &2.6843E-02,3.2560E-02,3.9436E-02,4.7558E-02,5.6745E-02/
      DATA (KB(JT,47, 4),JT=1,5) /
     &2.1428E-02,2.6226E-02,3.2052E-02,3.9057E-02,4.7184E-02/
      DATA (KB(JT,48, 4),JT=1,5) /
     &1.7029E-02,2.1031E-02,2.5943E-02,3.1986E-02,3.9099E-02/
      DATA (KB(JT,49, 4),JT=1,5) /
     &1.3477E-02,1.6802E-02,2.0926E-02,2.6109E-02,3.2294E-02/
      DATA (KB(JT,50, 4),JT=1,5) /
     &1.0673E-02,1.3423E-02,1.6872E-02,2.1279E-02,2.6629E-02/
      DATA (KB(JT,51, 4),JT=1,5) /
     &8.4370E-03,1.0700E-02,1.3568E-02,1.7289E-02,2.1889E-02/
      DATA (KB(JT,52, 4),JT=1,5) /
     &6.6453E-03,8.4949E-03,1.0870E-02,1.3987E-02,1.7931E-02/
      DATA (KB(JT,53, 4),JT=1,5) /
     &5.2146E-03,6.7176E-03,8.6804E-03,1.1275E-02,1.4637E-02/
      DATA (KB(JT,54, 4),JT=1,5) /
     &4.1029E-03,5.3246E-03,6.9354E-03,9.0873E-03,1.1925E-02/
      DATA (KB(JT,55, 4),JT=1,5) /
     &3.2267E-03,4.2135E-03,5.5289E-03,7.2992E-03,9.6811E-03/
      DATA (KB(JT,56, 4),JT=1,5) /
     &2.5269E-03,3.3219E-03,4.3912E-03,5.8434E-03,7.8299E-03/
      DATA (KB(JT,57, 4),JT=1,5) /
     &1.9715E-03,2.6095E-03,3.4757E-03,4.6583E-03,6.3020E-03/
      DATA (KB(JT,58, 4),JT=1,5) /
     &1.5393E-03,2.0522E-03,2.7523E-03,3.7145E-03,5.0709E-03/
      DATA (KB(JT,59, 4),JT=1,5) /
     &1.2601E-03,1.6926E-03,2.2864E-03,3.1046E-03,4.2734E-03/
      DATA (KB(JT,13, 5),JT=1,5) /
     &6.9559E+00,7.1944E+00,7.3778E+00,7.6168E+00,7.8840E+00/
      DATA (KB(JT,14, 5),JT=1,5) /
     &6.1197E+00,6.3419E+00,6.5357E+00,6.7535E+00,7.0053E+00/
      DATA (KB(JT,15, 5),JT=1,5) /
     &5.3579E+00,5.5744E+00,5.7766E+00,5.9767E+00,6.2167E+00/
      DATA (KB(JT,16, 5),JT=1,5) /
     &4.6816E+00,4.8936E+00,5.0862E+00,5.2967E+00,5.5327E+00/
      DATA (KB(JT,17, 5),JT=1,5) /
     &4.0899E+00,4.2917E+00,4.4812E+00,4.7025E+00,4.9201E+00/
      DATA (KB(JT,18, 5),JT=1,5) /
     &3.5771E+00,3.7678E+00,3.9593E+00,4.1715E+00,4.3722E+00/
      DATA (KB(JT,19, 5),JT=1,5) /
     &3.1364E+00,3.3176E+00,3.5013E+00,3.6935E+00,3.8830E+00/
      DATA (KB(JT,20, 5),JT=1,5) /
     &2.7593E+00,2.9230E+00,3.0933E+00,3.2687E+00,3.4499E+00/
      DATA (KB(JT,21, 5),JT=1,5) /
     &2.4256E+00,2.5724E+00,2.7298E+00,2.8928E+00,3.0638E+00/
      DATA (KB(JT,22, 5),JT=1,5) /
     &2.1368E+00,2.2729E+00,2.4183E+00,2.5689E+00,2.7252E+00/
      DATA (KB(JT,23, 5),JT=1,5) /
     &1.8817E+00,2.0092E+00,2.1410E+00,2.2786E+00,2.4217E+00/
      DATA (KB(JT,24, 5),JT=1,5) /
     &1.6588E+00,1.7749E+00,1.8947E+00,2.0208E+00,2.1527E+00/
      DATA (KB(JT,25, 5),JT=1,5) /
     &1.4616E+00,1.5668E+00,1.6777E+00,1.7944E+00,1.9128E+00/
      DATA (KB(JT,26, 5),JT=1,5) /
     &1.2875E+00,1.3850E+00,1.4881E+00,1.5943E+00,1.7005E+00/
      DATA (KB(JT,27, 5),JT=1,5) /
     &1.1342E+00,1.2250E+00,1.3195E+00,1.4155E+00,1.5121E+00/
      DATA (KB(JT,28, 5),JT=1,5) /
     &1.0000E+00,1.0834E+00,1.1694E+00,1.2569E+00,1.3467E+00/
      DATA (KB(JT,29, 5),JT=1,5) /
     &8.8272E-01,9.5878E-01,1.0375E+00,1.1189E+00,1.2039E+00/
      DATA (KB(JT,30, 5),JT=1,5) /
     &7.8028E-01,8.4986E-01,9.2253E-01,9.9927E-01,1.0809E+00/
      DATA (KB(JT,31, 5),JT=1,5) /
     &6.9115E-01,7.5536E-01,8.2388E-01,8.9787E-01,9.7590E-01/
      DATA (KB(JT,32, 5),JT=1,5) /
     &6.1412E-01,6.7446E-01,7.4048E-01,8.1095E-01,8.8670E-01/
      DATA (KB(JT,33, 5),JT=1,5) /
     &5.4810E-01,6.0636E-01,6.6911E-01,7.3734E-01,8.1091E-01/
      DATA (KB(JT,34, 5),JT=1,5) /
     &4.9071E-01,5.4601E-01,6.0648E-01,6.7271E-01,7.4441E-01/
      DATA (KB(JT,35, 5),JT=1,5) /
     &4.3693E-01,4.8943E-01,5.4769E-01,6.1149E-01,6.8198E-01/
      DATA (KB(JT,36, 5),JT=1,5) /
     &3.8551E-01,4.3547E-01,4.9121E-01,5.5301E-01,6.2109E-01/
      DATA (KB(JT,37, 5),JT=1,5) /
     &3.3480E-01,3.8150E-01,4.3408E-01,4.9278E-01,5.5808E-01/
      DATA (KB(JT,38, 5),JT=1,5) /
     &2.9081E-01,3.3450E-01,3.8398E-01,4.3987E-01,5.0248E-01/
      DATA (KB(JT,39, 5),JT=1,5) /
     &2.5305E-01,2.9380E-01,3.4050E-01,3.9390E-01,4.5364E-01/
      DATA (KB(JT,40, 5),JT=1,5) /
     &2.1671E-01,2.5418E-01,2.9763E-01,3.4779E-01,4.0458E-01/
      DATA (KB(JT,41, 5),JT=1,5) /
     &1.8493E-01,2.1926E-01,2.5954E-01,3.0662E-01,3.6037E-01/
      DATA (KB(JT,42, 5),JT=1,5) /
     &1.5752E-01,1.8888E-01,2.2625E-01,2.7031E-01,3.2124E-01/
      DATA (KB(JT,43, 5),JT=1,5) /
     &1.3255E-01,1.6078E-01,1.9491E-01,2.3576E-01,2.8350E-01/
      DATA (KB(JT,44, 5),JT=1,5) /
     &1.1061E-01,1.3578E-01,1.6666E-01,2.0425E-01,2.4865E-01/
      DATA (KB(JT,45, 5),JT=1,5) /
     &9.1951E-02,1.1424E-01,1.4202E-01,1.7639E-01,2.1757E-01/
      DATA (KB(JT,46, 5),JT=1,5) /
     &7.5781E-02,9.5221E-02,1.1993E-01,1.5099E-01,1.8901E-01/
      DATA (KB(JT,47, 5),JT=1,5) /
     &6.1487E-02,7.8164E-02,9.9731E-02,1.2737E-01,1.6179E-01/
      DATA (KB(JT,48, 5),JT=1,5) /
     &4.9580E-02,6.3770E-02,8.2434E-02,1.0684E-01,1.3786E-01/
      DATA (KB(JT,49, 5),JT=1,5) /
     &3.9738E-02,5.1709E-02,6.7733E-02,8.9073E-02,1.1686E-01/
      DATA (KB(JT,50, 5),JT=1,5) /
     &3.1862E-02,4.1943E-02,5.5637E-02,7.4270E-02,9.9031E-02/
      DATA (KB(JT,51, 5),JT=1,5) /
     &2.5469E-02,3.3911E-02,4.5561E-02,6.1725E-02,8.3692E-02/
      DATA (KB(JT,52, 5),JT=1,5) /
     &2.0254E-02,2.7266E-02,3.7097E-02,5.1018E-02,7.0332E-02/
      DATA (KB(JT,53, 5),JT=1,5) /
     &1.6008E-02,2.1779E-02,3.0012E-02,4.1907E-02,5.8779E-02/
      DATA (KB(JT,54, 5),JT=1,5) /
     &1.2684E-02,1.7422E-02,2.4313E-02,3.4417E-02,4.9062E-02/
      DATA (KB(JT,55, 5),JT=1,5) /
     &1.0038E-02,1.3916E-02,1.9644E-02,2.8164E-02,4.0795E-02/
      DATA (KB(JT,56, 5),JT=1,5) /
     &7.9079E-03,1.1053E-02,1.5781E-02,2.2925E-02,3.3750E-02/
      DATA (KB(JT,57, 5),JT=1,5) /
     &6.2010E-03,8.7295E-03,1.2598E-02,1.8552E-02,2.7742E-02/
      DATA (KB(JT,58, 5),JT=1,5) /
     &4.8646E-03,6.8966E-03,1.0058E-02,1.5005E-02,2.2774E-02/
      DATA (KB(JT,59, 5),JT=1,5) /
     &4.0331E-03,5.7872E-03,8.5542E-03,1.2975E-02,2.0014E-02/
      DATA (KB(JT,13, 6),JT=1,5) /
     &1.3874E+01,1.4054E+01,1.4175E+01,1.4196E+01,1.4254E+01/
      DATA (KB(JT,14, 6),JT=1,5) /
     &1.2387E+01,1.2564E+01,1.2698E+01,1.2762E+01,1.2781E+01/
      DATA (KB(JT,15, 6),JT=1,5) /
     &1.0973E+01,1.1145E+01,1.1274E+01,1.1365E+01,1.1424E+01/
      DATA (KB(JT,16, 6),JT=1,5) /
     &9.6521E+00,9.8053E+00,9.9370E+00,1.0047E+01,1.0150E+01/
      DATA (KB(JT,17, 6),JT=1,5) /
     &8.4222E+00,8.5719E+00,8.7195E+00,8.8488E+00,9.0159E+00/
      DATA (KB(JT,18, 6),JT=1,5) /
     &7.3090E+00,7.4668E+00,7.6322E+00,7.7932E+00,8.0086E+00/
      DATA (KB(JT,19, 6),JT=1,5) /
     &6.3279E+00,6.4985E+00,6.6813E+00,6.8756E+00,7.1176E+00/
      DATA (KB(JT,20, 6),JT=1,5) /
     &5.4862E+00,5.6719E+00,5.8682E+00,6.0850E+00,6.3337E+00/
      DATA (KB(JT,21, 6),JT=1,5) /
     &4.7753E+00,4.9682E+00,5.1665E+00,5.3943E+00,5.6406E+00/
      DATA (KB(JT,22, 6),JT=1,5) /
     &4.1854E+00,4.3703E+00,4.5713E+00,4.7990E+00,5.0439E+00/
      DATA (KB(JT,23, 6),JT=1,5) /
     &3.6767E+00,3.8508E+00,4.0542E+00,4.2776E+00,4.5191E+00/
      DATA (KB(JT,24, 6),JT=1,5) /
     &3.2355E+00,3.4077E+00,3.6072E+00,3.8245E+00,4.0534E+00/
      DATA (KB(JT,25, 6),JT=1,5) /
     &2.8580E+00,3.0303E+00,3.2220E+00,3.4257E+00,3.6444E+00/
      DATA (KB(JT,26, 6),JT=1,5) /
     &2.5405E+00,2.7078E+00,2.8872E+00,3.0816E+00,3.2880E+00/
      DATA (KB(JT,27, 6),JT=1,5) /
     &2.2677E+00,2.4258E+00,2.5973E+00,2.7818E+00,2.9766E+00/
      DATA (KB(JT,28, 6),JT=1,5) /
     &2.0273E+00,2.1803E+00,2.3462E+00,2.5211E+00,2.7040E+00/
      DATA (KB(JT,29, 6),JT=1,5) /
     &1.8190E+00,1.9689E+00,2.1279E+00,2.2941E+00,2.4662E+00/
      DATA (KB(JT,30, 6),JT=1,5) /
     &1.6397E+00,1.7844E+00,1.9371E+00,2.0958E+00,2.2590E+00/
      DATA (KB(JT,31, 6),JT=1,5) /
     &1.4852E+00,1.6249E+00,1.7714E+00,1.9226E+00,2.0813E+00/
      DATA (KB(JT,32, 6),JT=1,5) /
     &1.3517E+00,1.4862E+00,1.6264E+00,1.7745E+00,1.9335E+00/
      DATA (KB(JT,33, 6),JT=1,5) /
     &1.2364E+00,1.3651E+00,1.5027E+00,1.6513E+00,1.8098E+00/
      DATA (KB(JT,34, 6),JT=1,5) /
     &1.1317E+00,1.2571E+00,1.3947E+00,1.5426E+00,1.7001E+00/
      DATA (KB(JT,35, 6),JT=1,5) /
     &1.0305E+00,1.1540E+00,1.2902E+00,1.4368E+00,1.5937E+00/
      DATA (KB(JT,36, 6),JT=1,5) /
     &9.3137E-01,1.0526E+00,1.1856E+00,1.3299E+00,1.4860E+00/
      DATA (KB(JT,37, 6),JT=1,5) /
     &8.2931E-01,9.4564E-01,1.0739E+00,1.2152E+00,1.3682E+00/
      DATA (KB(JT,38, 6),JT=1,5) /
     &7.3906E-01,8.5034E-01,9.7478E-01,1.1125E+00,1.2627E+00/
      DATA (KB(JT,39, 6),JT=1,5) /
     &6.6006E-01,7.6663E-01,8.8732E-01,1.0214E+00,1.1704E+00/
      DATA (KB(JT,40, 6),JT=1,5) /
     &5.8074E-01,6.8151E-01,7.9698E-01,9.2673E-01,1.0719E+00/
      DATA (KB(JT,41, 6),JT=1,5) /
     &5.0970E-01,6.0467E-01,7.1469E-01,8.3962E-01,9.8097E-01/
      DATA (KB(JT,42, 6),JT=1,5) /
     &4.4691E-01,5.3653E-01,6.4112E-01,7.6136E-01,8.9846E-01/
      DATA (KB(JT,43, 6),JT=1,5) /
     &3.8720E-01,4.7067E-01,5.6921E-01,6.8346E-01,8.1541E-01/
      DATA (KB(JT,44, 6),JT=1,5) /
     &3.3270E-01,4.0984E-01,5.0209E-01,6.1017E-01,7.3637E-01/
      DATA (KB(JT,45, 6),JT=1,5) /
     &2.8475E-01,3.5595E-01,4.4190E-01,5.4378E-01,6.6410E-01/
      DATA (KB(JT,46, 6),JT=1,5) /
     &2.4137E-01,3.0640E-01,3.8581E-01,4.8130E-01,5.9507E-01/
      DATA (KB(JT,47, 6),JT=1,5) /
     &2.0121E-01,2.5952E-01,3.3199E-01,4.2038E-01,5.2702E-01/
      DATA (KB(JT,48, 6),JT=1,5) /
     &1.6644E-01,2.1836E-01,2.8412E-01,3.6558E-01,4.6520E-01/
      DATA (KB(JT,49, 6),JT=1,5) /
     &1.3664E-01,1.8247E-01,2.4166E-01,3.1637E-01,4.0912E-01/
      DATA (KB(JT,50, 6),JT=1,5) /
     &1.1203E-01,1.5228E-01,2.0551E-01,2.7399E-01,3.6023E-01/
      DATA (KB(JT,51, 6),JT=1,5) /
     &9.1424E-02,1.2652E-01,1.7413E-01,2.3648E-01,3.1642E-01/
      DATA (KB(JT,52, 6),JT=1,5) /
     &7.4033E-02,1.0433E-01,1.4653E-01,2.0289E-01,2.7670E-01/
      DATA (KB(JT,53, 6),JT=1,5) /
     &5.9468E-02,8.5397E-02,1.2237E-01,1.7301E-01,2.4059E-01/
      DATA (KB(JT,54, 6),JT=1,5) /
     &4.7831E-02,6.9932E-02,1.0222E-01,1.4759E-01,2.0954E-01/
      DATA (KB(JT,55, 6),JT=1,5) /
     &3.8375E-02,5.7032E-02,8.5062E-02,1.2546E-01,1.8204E-01/
      DATA (KB(JT,56, 6),JT=1,5) /
     &3.0600E-02,4.6150E-02,7.0262E-02,1.0594E-01,1.5707E-01/
      DATA (KB(JT,57, 6),JT=1,5) /
     &2.4221E-02,3.7043E-02,5.7569E-02,8.8786E-02,1.3465E-01/
      DATA (KB(JT,58, 6),JT=1,5) /
     &1.9170E-02,2.9713E-02,4.7101E-02,7.4302E-02,1.1534E-01/
      DATA (KB(JT,59, 6),JT=1,5) /
     &1.6314E-02,2.5760E-02,4.1528E-02,6.6912E-02,1.0596E-01/
      DATA (KB(JT,13, 7),JT=1,5) /
     &2.6383E+01,2.6399E+01,2.6364E+01,2.6286E+01,2.6068E+01/
      DATA (KB(JT,14, 7),JT=1,5) /
     &2.4391E+01,2.4435E+01,2.4445E+01,2.4411E+01,2.4344E+01/
      DATA (KB(JT,15, 7),JT=1,5) /
     &2.2267E+01,2.2343E+01,2.2391E+01,2.2420E+01,2.2406E+01/
      DATA (KB(JT,16, 7),JT=1,5) /
     &2.0101E+01,2.0222E+01,2.0311E+01,2.0370E+01,2.0373E+01/
      DATA (KB(JT,17, 7),JT=1,5) /
     &1.7987E+01,1.8130E+01,1.8242E+01,1.8316E+01,1.8338E+01/
      DATA (KB(JT,18, 7),JT=1,5) /
     &1.5956E+01,1.6114E+01,1.6238E+01,1.6337E+01,1.6400E+01/
      DATA (KB(JT,19, 7),JT=1,5) /
     &1.4050E+01,1.4210E+01,1.4354E+01,1.4495E+01,1.4623E+01/
      DATA (KB(JT,20, 7),JT=1,5) /
     &1.2287E+01,1.2462E+01,1.2644E+01,1.2837E+01,1.3036E+01/
      DATA (KB(JT,21, 7),JT=1,5) /
     &1.0697E+01,1.0904E+01,1.1136E+01,1.1376E+01,1.1647E+01/
      DATA (KB(JT,22, 7),JT=1,5) /
     &9.3216E+00,9.5704E+00,9.8418E+00,1.0134E+01,1.0464E+01/
      DATA (KB(JT,23, 7),JT=1,5) /
     &8.1552E+00,8.4381E+00,8.7358E+00,9.0546E+00,9.4274E+00/
      DATA (KB(JT,24, 7),JT=1,5) /
     &7.1742E+00,7.4714E+00,7.7800E+00,8.1293E+00,8.5227E+00/
      DATA (KB(JT,25, 7),JT=1,5) /
     &6.3453E+00,6.6371E+00,6.9572E+00,7.3300E+00,7.7371E+00/
      DATA (KB(JT,26, 7),JT=1,5) /
     &5.6325E+00,5.9213E+00,6.2619E+00,6.6436E+00,7.0622E+00/
      DATA (KB(JT,27, 7),JT=1,5) /
     &5.0177E+00,5.3180E+00,5.6685E+00,6.0556E+00,6.4791E+00/
      DATA (KB(JT,28, 7),JT=1,5) /
     &4.5006E+00,4.8114E+00,5.1630E+00,5.5512E+00,5.9725E+00/
      DATA (KB(JT,29, 7),JT=1,5) /
     &4.0763E+00,4.3869E+00,4.7357E+00,5.1215E+00,5.5415E+00/
      DATA (KB(JT,30, 7),JT=1,5) /
     &3.7197E+00,4.0279E+00,4.3734E+00,4.7560E+00,5.1758E+00/
      DATA (KB(JT,31, 7),JT=1,5) /
     &3.4217E+00,3.7276E+00,4.0700E+00,4.4513E+00,4.8709E+00/
      DATA (KB(JT,32, 7),JT=1,5) /
     &3.1725E+00,3.4760E+00,3.8179E+00,4.1999E+00,4.6169E+00/
      DATA (KB(JT,33, 7),JT=1,5) /
     &2.9640E+00,3.2682E+00,3.6118E+00,3.9912E+00,4.4110E+00/
      DATA (KB(JT,34, 7),JT=1,5) /
     &2.7815E+00,3.0881E+00,3.4286E+00,3.8090E+00,4.2366E+00/
      DATA (KB(JT,35, 7),JT=1,5) /
     &2.6027E+00,2.9073E+00,3.2445E+00,3.6269E+00,4.0627E+00/
      DATA (KB(JT,36, 7),JT=1,5) /
     &2.4195E+00,2.7195E+00,3.0535E+00,3.4362E+00,3.8766E+00/
      DATA (KB(JT,37, 7),JT=1,5) /
     &2.2155E+00,2.5099E+00,2.8373E+00,3.2150E+00,3.6504E+00/
      DATA (KB(JT,38, 7),JT=1,5) /
     &2.0317E+00,2.3214E+00,2.6457E+00,3.0187E+00,3.4497E+00/
      DATA (KB(JT,39, 7),JT=1,5) /
     &1.8675E+00,2.1535E+00,2.4775E+00,2.8467E+00,3.2732E+00/
      DATA (KB(JT,40, 7),JT=1,5) /
     &1.6933E+00,1.9726E+00,2.2917E+00,2.6527E+00,3.0690E+00/
      DATA (KB(JT,41, 7),JT=1,5) /
     &1.5321E+00,1.8045E+00,2.1184E+00,2.4731E+00,2.8788E+00/
      DATA (KB(JT,42, 7),JT=1,5) /
     &1.3858E+00,1.6512E+00,1.9598E+00,2.3096E+00,2.7061E+00/
      DATA (KB(JT,43, 7),JT=1,5) /
     &1.2395E+00,1.4953E+00,1.7959E+00,2.1389E+00,2.5250E+00/
      DATA (KB(JT,44, 7),JT=1,5) /
     &1.1006E+00,1.3456E+00,1.6365E+00,1.9712E+00,2.3479E+00/
      DATA (KB(JT,45, 7),JT=1,5) /
     &9.7411E-01,1.2078E+00,1.4892E+00,1.8150E+00,2.1832E+00/
      DATA (KB(JT,46, 7),JT=1,5) /
     &8.5489E-01,1.0759E+00,1.3456E+00,1.6612E+00,2.0197E+00/
      DATA (KB(JT,47, 7),JT=1,5) /
     &7.3930E-01,9.4494E-01,1.2000E+00,1.5026E+00,1.8496E+00/
      DATA (KB(JT,48, 7),JT=1,5) /
     &6.3547E-01,8.2535E-01,1.0653E+00,1.3544E+00,1.6889E+00/
      DATA (KB(JT,49, 7),JT=1,5) /
     &5.4241E-01,7.1674E-01,9.4139E-01,1.2160E+00,1.5375E+00/
      DATA (KB(JT,50, 7),JT=1,5) /
     &4.6304E-01,6.2300E-01,8.3217E-01,1.0925E+00,1.4012E+00/
      DATA (KB(JT,51, 7),JT=1,5) /
     &3.9371E-01,5.3995E-01,7.3373E-01,9.7980E-01,1.2748E+00/
      DATA (KB(JT,52, 7),JT=1,5) /
     &3.3220E-01,4.6493E-01,6.4396E-01,8.7508E-01,1.1558E+00/
      DATA (KB(JT,53, 7),JT=1,5) /
     &2.7778E-01,3.9741E-01,5.6181E-01,7.7785E-01,1.0434E+00/
      DATA (KB(JT,54, 7),JT=1,5) /
     &2.3274E-01,3.4050E-01,4.9090E-01,6.9261E-01,9.4387E-01/
      DATA (KB(JT,55, 7),JT=1,5) /
     &1.9435E-01,2.9105E-01,4.2805E-01,6.1562E-01,8.5235E-01/
      DATA (KB(JT,56, 7),JT=1,5) /
     &1.6083E-01,2.4693E-01,3.7158E-01,5.4415E-01,7.6669E-01/
      DATA (KB(JT,57, 7),JT=1,5) /
     &1.3183E-01,2.0770E-01,3.2034E-01,4.7818E-01,6.8649E-01/
      DATA (KB(JT,58, 7),JT=1,5) /
     &1.0786E-01,1.7445E-01,2.7618E-01,4.2058E-01,6.1481E-01/
      DATA (KB(JT,59, 7),JT=1,5) /
     &9.5778E-02,1.5879E-01,2.5699E-01,3.9684E-01,5.8283E-01/
      DATA (KB(JT,13, 8),JT=1,5) /
     &5.1036E+01,5.0460E+01,4.9876E+01,4.9272E+01,4.8645E+01/
      DATA (KB(JT,14, 8),JT=1,5) /
     &4.9659E+01,4.9240E+01,4.8789E+01,4.8317E+01,4.7813E+01/
      DATA (KB(JT,15, 8),JT=1,5) /
     &4.7836E+01,4.7533E+01,4.7179E+01,4.6807E+01,4.6408E+01/
      DATA (KB(JT,16, 8),JT=1,5) /
     &4.5523E+01,4.5307E+01,4.5074E+01,4.4798E+01,4.4497E+01/
      DATA (KB(JT,17, 8),JT=1,5) /
     &4.2751E+01,4.2659E+01,4.2523E+01,4.2351E+01,4.2128E+01/
      DATA (KB(JT,18, 8),JT=1,5) /
     &3.9675E+01,3.9678E+01,3.9613E+01,3.9512E+01,3.9377E+01/
      DATA (KB(JT,19, 8),JT=1,5) /
     &3.6385E+01,3.6442E+01,3.6467E+01,3.6453E+01,3.6385E+01/
      DATA (KB(JT,20, 8),JT=1,5) /
     &3.2988E+01,3.3119E+01,3.3207E+01,3.3253E+01,3.3266E+01/
      DATA (KB(JT,21, 8),JT=1,5) /
     &2.9629E+01,2.9807E+01,2.9950E+01,3.0074E+01,3.0195E+01/
      DATA (KB(JT,22, 8),JT=1,5) /
     &2.6389E+01,2.6615E+01,2.6833E+01,2.7054E+01,2.7281E+01/
      DATA (KB(JT,23, 8),JT=1,5) /
     &2.3355E+01,2.3644E+01,2.3948E+01,2.4296E+01,2.4660E+01/
      DATA (KB(JT,24, 8),JT=1,5) /
     &2.0595E+01,2.0963E+01,2.1391E+01,2.1861E+01,2.2380E+01/
      DATA (KB(JT,25, 8),JT=1,5) /
     &1.8159E+01,1.8637E+01,1.9183E+01,1.9778E+01,2.0439E+01/
      DATA (KB(JT,26, 8),JT=1,5) /
     &1.6089E+01,1.6677E+01,1.7319E+01,1.8032E+01,1.8814E+01/
      DATA (KB(JT,27, 8),JT=1,5) /
     &1.4363E+01,1.5028E+01,1.5757E+01,1.6564E+01,1.7443E+01/
      DATA (KB(JT,28, 8),JT=1,5) /
     &1.2926E+01,1.3648E+01,1.4446E+01,1.5323E+01,1.6326E+01/
      DATA (KB(JT,29, 8),JT=1,5) /
     &1.1723E+01,1.2493E+01,1.3349E+01,1.4336E+01,1.5419E+01/
      DATA (KB(JT,30, 8),JT=1,5) /
     &1.0720E+01,1.1535E+01,1.2485E+01,1.3543E+01,1.4696E+01/
      DATA (KB(JT,31, 8),JT=1,5) /
     &9.8953E+00,1.0794E+01,1.1807E+01,1.2928E+01,1.4151E+01/
      DATA (KB(JT,32, 8),JT=1,5) /
     &9.2630E+00,1.0213E+01,1.1281E+01,1.2468E+01,1.3783E+01/
      DATA (KB(JT,33, 8),JT=1,5) /
     &8.7693E+00,9.7682E+00,1.0900E+01,1.2171E+01,1.3564E+01/
      DATA (KB(JT,34, 8),JT=1,5) /
     &8.3550E+00,9.4057E+00,1.0612E+01,1.1954E+01,1.3416E+01/
      DATA (KB(JT,35, 8),JT=1,5) /
     &7.9503E+00,9.0506E+00,1.0311E+01,1.1711E+01,1.3230E+01/
      DATA (KB(JT,36, 8),JT=1,5) /
     &7.5260E+00,8.6513E+00,9.9500E+00,1.1393E+01,1.2954E+01/
      DATA (KB(JT,37, 8),JT=1,5) /
     &7.0166E+00,8.1408E+00,9.4476E+00,1.0907E+01,1.2489E+01/
      DATA (KB(JT,38, 8),JT=1,5) /
     &6.5631E+00,7.6815E+00,8.9895E+00,1.0461E+01,1.2064E+01/
      DATA (KB(JT,39, 8),JT=1,5) /
     &6.1678E+00,7.2805E+00,8.5861E+00,1.0065E+01,1.1676E+01/
      DATA (KB(JT,40, 8),JT=1,5) /
     &5.7155E+00,6.7987E+00,8.0775E+00,9.5392E+00,1.1142E+01/
      DATA (KB(JT,41, 8),JT=1,5) /
     &5.2949E+00,6.3470E+00,7.5914E+00,9.0258E+00,1.0614E+01/
      DATA (KB(JT,42, 8),JT=1,5) /
     &4.9139E+00,5.9322E+00,7.1403E+00,8.5407E+00,1.0110E+01/
      DATA (KB(JT,43, 8),JT=1,5) /
     &4.5194E+00,5.4902E+00,6.6498E+00,8.0033E+00,9.5351E+00/
      DATA (KB(JT,44, 8),JT=1,5) /
     &4.1399E+00,5.0576E+00,6.1633E+00,7.4614E+00,8.9447E+00/
      DATA (KB(JT,45, 8),JT=1,5) /
     &3.7947E+00,4.6596E+00,5.7095E+00,6.9501E+00,8.3804E+00/
      DATA (KB(JT,46, 8),JT=1,5) /
     &3.4645E+00,4.2731E+00,5.2631E+00,6.4408E+00,7.8107E+00/
      DATA (KB(JT,47, 8),JT=1,5) /
     &3.1333E+00,3.8817E+00,4.8032E+00,5.9109E+00,7.2077E+00/
      DATA (KB(JT,48, 8),JT=1,5) /
     &2.8272E+00,3.5252E+00,4.3790E+00,5.4161E+00,6.6403E+00/
      DATA (KB(JT,49, 8),JT=1,5) /
     &2.5419E+00,3.2000E+00,3.9894E+00,4.9550E+00,6.1077E+00/
      DATA (KB(JT,50, 8),JT=1,5) /
     &2.2876E+00,2.9151E+00,3.6507E+00,4.5513E+00,5.6358E+00/
      DATA (KB(JT,51, 8),JT=1,5) /
     &2.0539E+00,2.6537E+00,3.3480E+00,4.1860E+00,5.2042E+00/
      DATA (KB(JT,52, 8),JT=1,5) /
     &1.8359E+00,2.4075E+00,3.0676E+00,3.8482E+00,4.8005E+00/
      DATA (KB(JT,53, 8),JT=1,5) /
     &1.6315E+00,2.1744E+00,2.8043E+00,3.5342E+00,4.4242E+00/
      DATA (KB(JT,54, 8),JT=1,5) /
     &1.4536E+00,1.9689E+00,2.5734E+00,3.2651E+00,4.0977E+00/
      DATA (KB(JT,55, 8),JT=1,5) /
     &1.2924E+00,1.7818E+00,2.3616E+00,3.0234E+00,3.8040E+00/
      DATA (KB(JT,56, 8),JT=1,5) /
     &1.1428E+00,1.6042E+00,2.1584E+00,2.7950E+00,3.5303E+00/
      DATA (KB(JT,57, 8),JT=1,5) /
     &1.0034E+00,1.4376E+00,1.9645E+00,2.5766E+00,3.2746E+00/
      DATA (KB(JT,58, 8),JT=1,5) /
     &8.7989E-01,1.2882E+00,1.7895E+00,2.3775E+00,3.0470E+00/
      DATA (KB(JT,59, 8),JT=1,5) /
     &8.2607E-01,1.2253E+00,1.7145E+00,2.2929E+00,2.9546E+00/
      DATA (KB(JT,13, 9),JT=1,5) /
     &9.9406E+01,9.8017E+01,9.6610E+01,9.5133E+01,9.3589E+01/
      DATA (KB(JT,14, 9),JT=1,5) /
     &1.0426E+02,1.0289E+02,1.0145E+02,9.9955E+01,9.8418E+01/
      DATA (KB(JT,15, 9),JT=1,5) /
     &1.0831E+02,1.0700E+02,1.0565E+02,1.0422E+02,1.0271E+02/
      DATA (KB(JT,16, 9),JT=1,5) /
     &1.1144E+02,1.1027E+02,1.0899E+02,1.0766E+02,1.0626E+02/
      DATA (KB(JT,17, 9),JT=1,5) /
     &1.1357E+02,1.1252E+02,1.1140E+02,1.1022E+02,1.0897E+02/
      DATA (KB(JT,18, 9),JT=1,5) /
     &1.1451E+02,1.1366E+02,1.1275E+02,1.1172E+02,1.1059E+02/
      DATA (KB(JT,19, 9),JT=1,5) /
     &1.1419E+02,1.1358E+02,1.1283E+02,1.1199E+02,1.1108E+02/
      DATA (KB(JT,20, 9),JT=1,5) /
     &1.1253E+02,1.1217E+02,1.1170E+02,1.1113E+02,1.1043E+02/
      DATA (KB(JT,21, 9),JT=1,5) /
     &1.0964E+02,1.0959E+02,1.0941E+02,1.0911E+02,1.0868E+02/
      DATA (KB(JT,22, 9),JT=1,5) /
     &1.0576E+02,1.0601E+02,1.0614E+02,1.0616E+02,1.0606E+02/
      DATA (KB(JT,23, 9),JT=1,5) /
     &1.0113E+02,1.0172E+02,1.0220E+02,1.0257E+02,1.0280E+02/
      DATA (KB(JT,24, 9),JT=1,5) /
     &9.6005E+01,9.6976E+01,9.7826E+01,9.8561E+01,9.9182E+01/
      DATA (KB(JT,25, 9),JT=1,5) /
     &9.0658E+01,9.2026E+01,9.3302E+01,9.4462E+01,9.5504E+01/
      DATA (KB(JT,26, 9),JT=1,5) /
     &8.5398E+01,8.7188E+01,8.8895E+01,9.0506E+01,9.1994E+01/
      DATA (KB(JT,27, 9),JT=1,5) /
     &8.0425E+01,8.2648E+01,8.4817E+01,8.6900E+01,8.8861E+01/
      DATA (KB(JT,28, 9),JT=1,5) /
     &7.5902E+01,7.8597E+01,8.1250E+01,8.3817E+01,8.6189E+01/
      DATA (KB(JT,29, 9),JT=1,5) /
     &7.2021E+01,7.5193E+01,7.8323E+01,8.1284E+01,8.4079E+01/
      DATA (KB(JT,30, 9),JT=1,5) /
     &6.8846E+01,7.2476E+01,7.5986E+01,7.9352E+01,8.2517E+01/
      DATA (KB(JT,31, 9),JT=1,5) /
     &6.6391E+01,7.0389E+01,7.4280E+01,7.7994E+01,8.1462E+01/
      DATA (KB(JT,32, 9),JT=1,5) /
     &6.4577E+01,6.8942E+01,7.3166E+01,7.7157E+01,8.0829E+01/
      DATA (KB(JT,33, 9),JT=1,5) /
     &6.3392E+01,6.8071E+01,7.2548E+01,7.6730E+01,8.0569E+01/
      DATA (KB(JT,34, 9),JT=1,5) /
     &6.2591E+01,6.7517E+01,7.2182E+01,7.6523E+01,8.0479E+01/
      DATA (KB(JT,35, 9),JT=1,5) /
     &6.1727E+01,6.6854E+01,7.1692E+01,7.6175E+01,8.0232E+01/
      DATA (KB(JT,36, 9),JT=1,5) /
     &6.0594E+01,6.5914E+01,7.0919E+01,7.5536E+01,7.9714E+01/
      DATA (KB(JT,37, 9),JT=1,5) /
     &5.8846E+01,6.4364E+01,6.9558E+01,7.4349E+01,7.8713E+01/
      DATA (KB(JT,38, 9),JT=1,5) /
     &5.7194E+01,6.2887E+01,6.8247E+01,7.3195E+01,7.8049E+01/
      DATA (KB(JT,39, 9),JT=1,5) /
     &5.5665E+01,6.1507E+01,6.7008E+01,7.2147E+01,7.7547E+01/
      DATA (KB(JT,40, 9),JT=1,5) /
     &5.3621E+01,5.9617E+01,6.5286E+01,7.0695E+01,7.6340E+01/
      DATA (KB(JT,41, 9),JT=1,5) /
     &5.1554E+01,5.7685E+01,6.3510E+01,6.9201E+01,7.4982E+01/
      DATA (KB(JT,42, 9),JT=1,5) /
     &4.9528E+01,5.5776E+01,6.1743E+01,6.7740E+01,7.3659E+01/
      DATA (KB(JT,43, 9),JT=1,5) /
     &4.7178E+01,5.3540E+01,5.9647E+01,6.5886E+01,7.2015E+01/
      DATA (KB(JT,44, 9),JT=1,5) /
     &4.4688E+01,5.1145E+01,5.7387E+01,6.3891E+01,7.0203E+01/
      DATA (KB(JT,45, 9),JT=1,5) /
     &4.2221E+01,4.8754E+01,5.5108E+01,6.1908E+01,6.8361E+01/
      DATA (KB(JT,46, 9),JT=1,5) /
     &3.9637E+01,4.6220E+01,5.2693E+01,5.9708E+01,6.6363E+01/
      DATA (KB(JT,47, 9),JT=1,5) /
     &3.6803E+01,4.3409E+01,4.9987E+01,5.7153E+01,6.3987E+01/
      DATA (KB(JT,48, 9),JT=1,5) /
     &3.4015E+01,4.0603E+01,4.7276E+01,5.4594E+01,6.1608E+01/
      DATA (KB(JT,49, 9),JT=1,5) /
     &3.1288E+01,3.7812E+01,4.4636E+01,5.2065E+01,5.9201E+01/
      DATA (KB(JT,50, 9),JT=1,5) /
     &2.8795E+01,3.5220E+01,4.2061E+01,4.9552E+01,5.6813E+01/
      DATA (KB(JT,51, 9),JT=1,5) /
     &2.6450E+01,3.2748E+01,3.9528E+01,4.7065E+01,5.4424E+01/
      DATA (KB(JT,52, 9),JT=1,5) /
     &2.4182E+01,3.0329E+01,3.7052E+01,4.4584E+01,5.2041E+01/
      DATA (KB(JT,53, 9),JT=1,5) /
     &2.1996E+01,2.7965E+01,3.4636E+01,4.2155E+01,4.9659E+01/
      DATA (KB(JT,54, 9),JT=1,5) /
     &2.0069E+01,2.5858E+01,3.2251E+01,3.9700E+01,4.7245E+01/
      DATA (KB(JT,55, 9),JT=1,5) /
     &1.8302E+01,2.3898E+01,3.0045E+01,3.7230E+01,4.4781E+01/
      DATA (KB(JT,56, 9),JT=1,5) /
     &1.6618E+01,2.2006E+01,2.7997E+01,3.4787E+01,4.2319E+01/
      DATA (KB(JT,57, 9),JT=1,5) /
     &1.5017E+01,2.0180E+01,2.5997E+01,3.2401E+01,3.9855E+01/
      DATA (KB(JT,58, 9),JT=1,5) /
     &1.3581E+01,1.8514E+01,2.4151E+01,3.0332E+01,3.7487E+01/
      DATA (KB(JT,59, 9),JT=1,5) /
     &1.3022E+01,1.7859E+01,2.3425E+01,2.9551E+01,3.6092E+01/
      DATA (KB(JT,13,10),JT=1,5) /
     &1.4854E+02,1.4629E+02,1.4392E+02,1.4179E+02,1.3968E+02/
      DATA (KB(JT,14,10),JT=1,5) /
     &1.6449E+02,1.6201E+02,1.5966E+02,1.5740E+02,1.5475E+02/
      DATA (KB(JT,15,10),JT=1,5) /
     &1.8113E+02,1.7883E+02,1.7633E+02,1.7356E+02,1.7082E+02/
      DATA (KB(JT,16,10),JT=1,5) /
     &1.9869E+02,1.9617E+02,1.9337E+02,1.9057E+02,1.8767E+02/
      DATA (KB(JT,17,10),JT=1,5) /
     &2.1579E+02,2.1310E+02,2.1009E+02,2.0678E+02,2.0344E+02/
      DATA (KB(JT,18,10),JT=1,5) /
     &2.3175E+02,2.2862E+02,2.2543E+02,2.2232E+02,2.1916E+02/
      DATA (KB(JT,19,10),JT=1,5) /
     &2.4595E+02,2.4325E+02,2.4040E+02,2.3730E+02,2.3384E+02/
      DATA (KB(JT,20,10),JT=1,5) /
     &2.5917E+02,2.5646E+02,2.5347E+02,2.5026E+02,2.4697E+02/
      DATA (KB(JT,21,10),JT=1,5) /
     &2.7002E+02,2.6751E+02,2.6472E+02,2.6184E+02,2.5881E+02/
      DATA (KB(JT,22,10),JT=1,5) /
     &2.7788E+02,2.7617E+02,2.7411E+02,2.7166E+02,2.6869E+02/
      DATA (KB(JT,23,10),JT=1,5) /
     &2.8310E+02,2.8234E+02,2.8114E+02,2.7929E+02,2.7687E+02/
      DATA (KB(JT,24,10),JT=1,5) /
     &2.8635E+02,2.8652E+02,2.8615E+02,2.8511E+02,2.8345E+02/
      DATA (KB(JT,25,10),JT=1,5) /
     &2.8819E+02,2.8935E+02,2.8976E+02,2.8954E+02,2.8857E+02/
      DATA (KB(JT,26,10),JT=1,5) /
     &2.8894E+02,2.9109E+02,2.9250E+02,2.9307E+02,2.9272E+02/
      DATA (KB(JT,27,10),JT=1,5) /
     &2.8895E+02,2.9239E+02,2.9473E+02,2.9595E+02,2.9616E+02/
      DATA (KB(JT,28,10),JT=1,5) /
     &2.8893E+02,2.9347E+02,2.9660E+02,2.9845E+02,2.9908E+02/
      DATA (KB(JT,29,10),JT=1,5) /
     &2.8896E+02,2.9449E+02,2.9830E+02,3.0067E+02,3.0167E+02/
      DATA (KB(JT,30,10),JT=1,5) /
     &2.8928E+02,2.9562E+02,2.9995E+02,3.0268E+02,3.0395E+02/
      DATA (KB(JT,31,10),JT=1,5) /
     &2.9009E+02,2.9691E+02,3.0163E+02,3.0456E+02,3.0602E+02/
      DATA (KB(JT,32,10),JT=1,5) /
     &2.9131E+02,2.9842E+02,3.0331E+02,3.0639E+02,3.0785E+02/
      DATA (KB(JT,33,10),JT=1,5) /
     &2.9285E+02,3.0006E+02,3.0500E+02,3.0808E+02,3.0942E+02/
      DATA (KB(JT,34,10),JT=1,5) /
     &2.9430E+02,3.0156E+02,3.0650E+02,3.0954E+02,3.1081E+02/
      DATA (KB(JT,35,10),JT=1,5) /
     &2.9506E+02,3.0251E+02,3.0756E+02,3.1064E+02,3.1189E+02/
      DATA (KB(JT,36,10),JT=1,5) /
     &2.9495E+02,3.0278E+02,3.0811E+02,3.1136E+02,3.1273E+02/
      DATA (KB(JT,37,10),JT=1,5) /
     &2.9340E+02,3.0194E+02,3.0787E+02,3.1159E+02,3.1314E+02/
      DATA (KB(JT,38,10),JT=1,5) /
     &2.9167E+02,3.0090E+02,3.0743E+02,3.1157E+02,3.1035E+02/
      DATA (KB(JT,39,10),JT=1,5) /
     &2.8984E+02,2.9975E+02,3.0683E+02,3.1096E+02,3.0638E+02/
      DATA (KB(JT,40,10),JT=1,5) /
     &2.8667E+02,2.9751E+02,3.0546E+02,3.0937E+02,3.0473E+02/
      DATA (KB(JT,41,10),JT=1,5) /
     &2.8308E+02,2.9489E+02,3.0373E+02,3.0736E+02,3.0363E+02/
      DATA (KB(JT,42,10),JT=1,5) /
     &2.7921E+02,2.9200E+02,3.0174E+02,3.0479E+02,3.0187E+02/
      DATA (KB(JT,43,10),JT=1,5) /
     &2.7420E+02,2.8820E+02,2.9899E+02,3.0230E+02,2.9999E+02/
      DATA (KB(JT,44,10),JT=1,5) /
     &2.6840E+02,2.8368E+02,2.9562E+02,2.9904E+02,2.9872E+02/
      DATA (KB(JT,45,10),JT=1,5) /
     &2.6218E+02,2.7870E+02,2.9185E+02,2.9503E+02,2.9798E+02/
      DATA (KB(JT,46,10),JT=1,5) /
     &2.5505E+02,2.7298E+02,2.8727E+02,2.9090E+02,2.9720E+02/
      DATA (KB(JT,47,10),JT=1,5) /
     &2.4654E+02,2.6603E+02,2.8160E+02,2.8645E+02,2.9469E+02/
      DATA (KB(JT,48,10),JT=1,5) /
     &2.3740E+02,2.5847E+02,2.7519E+02,2.8106E+02,2.9248E+02/
      DATA (KB(JT,49,10),JT=1,5) /
     &2.2763E+02,2.5025E+02,2.6743E+02,2.7456E+02,2.9049E+02/
      DATA (KB(JT,50,10),JT=1,5) /
     &2.1791E+02,2.4202E+02,2.6048E+02,2.6898E+02,2.8731E+02/
      DATA (KB(JT,51,10),JT=1,5) /
     &2.0797E+02,2.3350E+02,2.5355E+02,2.6334E+02,2.8310E+02/
      DATA (KB(JT,52,10),JT=1,5) /
     &1.9757E+02,2.2449E+02,2.4576E+02,2.5715E+02,2.7915E+02/
      DATA (KB(JT,53,10),JT=1,5) /
     &1.8669E+02,2.1495E+02,2.3714E+02,2.5067E+02,2.7496E+02/
      DATA (KB(JT,54,10),JT=1,5) /
     &1.7638E+02,2.0577E+02,2.3068E+02,2.4491E+02,2.6874E+02/
      DATA (KB(JT,55,10),JT=1,5) /
     &1.6621E+02,1.9659E+02,2.2369E+02,2.4095E+02,2.6031E+02/
      DATA (KB(JT,56,10),JT=1,5) /
     &1.5581E+02,1.8709E+02,2.1533E+02,2.3658E+02,2.5187E+02/
      DATA (KB(JT,57,10),JT=1,5) /
     &1.4523E+02,1.7728E+02,2.0662E+02,2.3157E+02,2.4581E+02/
      DATA (KB(JT,58,10),JT=1,5) /
     &1.3508E+02,1.6774E+02,1.9802E+02,2.2497E+02,2.4252E+02/
      DATA (KB(JT,59,10),JT=1,5) /
     &1.3094E+02,1.6382E+02,1.9446E+02,2.2185E+02,2.4525E+02/
      DATA (KB(JT,13,11),JT=1,5) /
     &1.6572E+02,1.6289E+02,1.6008E+02,1.5714E+02,1.5448E+02/
      DATA (KB(JT,14,11),JT=1,5) /
     &1.8540E+02,1.8266E+02,1.7967E+02,1.7665E+02,1.7387E+02/
      DATA (KB(JT,15,11),JT=1,5) /
     &2.0814E+02,2.0518E+02,2.0210E+02,1.9898E+02,1.9569E+02/
      DATA (KB(JT,16,11),JT=1,5) /
     &2.3282E+02,2.2978E+02,2.2643E+02,2.2243E+02,2.1800E+02/
      DATA (KB(JT,17,11),JT=1,5) /
     &2.5856E+02,2.5501E+02,2.5085E+02,2.4632E+02,2.4166E+02/
      DATA (KB(JT,18,11),JT=1,5) /
     &2.8422E+02,2.8031E+02,2.7577E+02,2.7086E+02,2.6564E+02/
      DATA (KB(JT,19,11),JT=1,5) /
     &3.0919E+02,3.0467E+02,2.9960E+02,2.9432E+02,2.8897E+02/
      DATA (KB(JT,20,11),JT=1,5) /
     &3.3207E+02,3.2741E+02,3.2245E+02,3.1728E+02,3.1181E+02/
      DATA (KB(JT,21,11),JT=1,5) /
     &3.5360E+02,3.4929E+02,3.4457E+02,3.3936E+02,3.3368E+02/
      DATA (KB(JT,22,11),JT=1,5) /
     &3.7366E+02,3.6938E+02,3.6457E+02,3.5924E+02,3.5347E+02/
      DATA (KB(JT,23,11),JT=1,5) /
     &3.9151E+02,3.8745E+02,3.8282E+02,3.7760E+02,3.7188E+02/
      DATA (KB(JT,24,11),JT=1,5) /
     &4.0699E+02,4.0355E+02,3.9930E+02,3.9428E+02,3.8859E+02/
      DATA (KB(JT,25,11),JT=1,5) /
     &4.2010E+02,4.1762E+02,4.1382E+02,4.0900E+02,4.0333E+02/
      DATA (KB(JT,26,11),JT=1,5) /
     &4.3097E+02,4.2949E+02,4.2634E+02,4.2177E+02,4.1610E+02/
      DATA (KB(JT,27,11),JT=1,5) /
     &4.4020E+02,4.3958E+02,4.3704E+02,4.3277E+02,4.2718E+02/
      DATA (KB(JT,28,11),JT=1,5) /
     &4.4818E+02,4.4821E+02,4.4611E+02,4.4212E+02,4.3652E+02/
      DATA (KB(JT,29,11),JT=1,5) /
     &4.5504E+02,4.5548E+02,4.5376E+02,4.4984E+02,4.4415E+02/
      DATA (KB(JT,30,11),JT=1,5) /
     &4.6091E+02,4.6162E+02,4.6010E+02,4.5616E+02,4.5025E+02/
      DATA (KB(JT,31,11),JT=1,5) /
     &4.6598E+02,4.6680E+02,4.6528E+02,4.6118E+02,4.5498E+02/
      DATA (KB(JT,32,11),JT=1,5) /
     &4.7040E+02,4.7120E+02,4.6944E+02,4.6509E+02,4.5862E+02/
      DATA (KB(JT,33,11),JT=1,5) /
     &4.7430E+02,4.7493E+02,4.7283E+02,4.6810E+02,4.6122E+02/
      DATA (KB(JT,34,11),JT=1,5) /
     &4.7770E+02,4.7802E+02,4.7557E+02,4.7044E+02,4.6319E+02/
      DATA (KB(JT,35,11),JT=1,5) /
     &4.8041E+02,4.8064E+02,4.7804E+02,4.7275E+02,4.6531E+02/
      DATA (KB(JT,36,11),JT=1,5) /
     &4.8253E+02,4.8296E+02,4.8047E+02,4.7521E+02,4.6778E+02/
      DATA (KB(JT,37,11),JT=1,5) /
     &4.8393E+02,4.8502E+02,4.8301E+02,4.7821E+02,4.7102E+02/
      DATA (KB(JT,38,11),JT=1,5) /
     &4.8486E+02,4.8663E+02,4.8514E+02,4.8082E+02,4.7394E+02/
      DATA (KB(JT,39,11),JT=1,5) /
     &4.8541E+02,4.8785E+02,4.8691E+02,4.8302E+02,4.7647E+02/
      DATA (KB(JT,40,11),JT=1,5) /
     &4.8510E+02,4.8864E+02,4.8854E+02,4.8540E+02,4.7945E+02/
      DATA (KB(JT,41,11),JT=1,5) /
     &4.8418E+02,4.8891E+02,4.8975E+02,4.8740E+02,4.8219E+02/
      DATA (KB(JT,42,11),JT=1,5) /
     &4.8279E+02,4.8873E+02,4.9057E+02,4.8904E+02,4.8458E+02/
      DATA (KB(JT,43,11),JT=1,5) /
     &4.8041E+02,4.8782E+02,4.9100E+02,4.9049E+02,4.8682E+02/
      DATA (KB(JT,44,11),JT=1,5) /
     &4.7714E+02,4.8618E+02,4.9081E+02,4.9150E+02,4.8756E+02/
      DATA (KB(JT,45,11),JT=1,5) /
     &4.7308E+02,4.8395E+02,4.9007E+02,4.9204E+02,4.8671E+02/
      DATA (KB(JT,46,11),JT=1,5) /
     &4.6783E+02,4.8086E+02,4.8862E+02,4.9205E+02,4.8480E+02/
      DATA (KB(JT,47,11),JT=1,5) /
     &4.6080E+02,4.7644E+02,4.8623E+02,4.9139E+02,4.8469E+02/
      DATA (KB(JT,48,11),JT=1,5) /
     &4.5259E+02,4.7102E+02,4.8306E+02,4.9003E+02,4.8230E+02/
      DATA (KB(JT,49,11),JT=1,5) /
     &4.4320E+02,4.6445E+02,4.7901E+02,4.8786E+02,4.7807E+02/
      DATA (KB(JT,50,11),JT=1,5) /
     &4.3321E+02,4.5728E+02,4.7435E+02,4.8518E+02,4.7550E+02/
      DATA (KB(JT,51,11),JT=1,5) /
     &4.2248E+02,4.4931E+02,4.6891E+02,4.8193E+02,4.7366E+02/
      DATA (KB(JT,52,11),JT=1,5) /
     &4.1065E+02,4.4034E+02,4.6257E+02,4.7793E+02,4.7004E+02/
      DATA (KB(JT,53,11),JT=1,5) /
     &3.9765E+02,4.3037E+02,4.5526E+02,4.7213E+02,4.6510E+02/
      DATA (KB(JT,54,11),JT=1,5) /
     &3.8467E+02,4.2027E+02,4.4777E+02,4.6790E+02,4.6484E+02/
      DATA (KB(JT,55,11),JT=1,5) /
     &3.7132E+02,4.0974E+02,4.3973E+02,4.6220E+02,4.6820E+02/
      DATA (KB(JT,56,11),JT=1,5) /
     &3.5710E+02,3.9837E+02,4.3097E+02,4.5580E+02,4.7038E+02/
      DATA (KB(JT,57,11),JT=1,5) /
     &3.4209E+02,3.8602E+02,4.2139E+02,4.4866E+02,4.6860E+02/
      DATA (KB(JT,58,11),JT=1,5) /
     &3.2702E+02,3.7354E+02,4.1153E+02,4.4115E+02,4.6327E+02/
      DATA (KB(JT,59,11),JT=1,5) /
     &3.2074E+02,3.6827E+02,4.0735E+02,4.3797E+02,4.6099E+02/
      DATA (KB(JT,13,12),JT=1,5) /
     &1.8437E+02,1.8201E+02,1.7920E+02,1.7619E+02,1.7262E+02/
      DATA (KB(JT,14,12),JT=1,5) /
     &2.0920E+02,2.0655E+02,2.0368E+02,2.0039E+02,1.9660E+02/
      DATA (KB(JT,15,12),JT=1,5) /
     &2.3807E+02,2.3483E+02,2.3126E+02,2.2723E+02,2.2261E+02/
      DATA (KB(JT,16,12),JT=1,5) /
     &2.7050E+02,2.6622E+02,2.6148E+02,2.5668E+02,2.5203E+02/
      DATA (KB(JT,17,12),JT=1,5) /
     &3.0550E+02,3.0047E+02,2.9528E+02,2.8984E+02,2.8414E+02/
      DATA (KB(JT,18,12),JT=1,5) /
     &3.4308E+02,3.3718E+02,3.3104E+02,3.2458E+02,3.1787E+02/
      DATA (KB(JT,19,12),JT=1,5) /
     &3.8177E+02,3.7532E+02,3.6857E+02,3.6127E+02,3.5363E+02/
      DATA (KB(JT,20,12),JT=1,5) /
     &4.2186E+02,4.1506E+02,4.0728E+02,3.9905E+02,3.9052E+02/
      DATA (KB(JT,21,12),JT=1,5) /
     &4.6246E+02,4.5454E+02,4.4606E+02,4.3704E+02,4.2747E+02/
      DATA (KB(JT,22,12),JT=1,5) /
     &5.0135E+02,4.9292E+02,4.8363E+02,4.7369E+02,4.6338E+02/
      DATA (KB(JT,23,12),JT=1,5) /
     &5.3861E+02,5.2961E+02,5.1962E+02,5.0894E+02,4.9767E+02/
      DATA (KB(JT,24,12),JT=1,5) /
     &5.7338E+02,5.6389E+02,5.5338E+02,5.4189E+02,5.2932E+02/
      DATA (KB(JT,25,12),JT=1,5) /
     &6.0539E+02,5.9528E+02,5.8404E+02,5.7158E+02,5.5798E+02/
      DATA (KB(JT,26,12),JT=1,5) /
     &6.3403E+02,6.2334E+02,6.1112E+02,5.9770E+02,5.8310E+02/
      DATA (KB(JT,27,12),JT=1,5) /
     &6.5936E+02,6.4795E+02,6.3483E+02,6.2036E+02,6.0455E+02/
      DATA (KB(JT,28,12),JT=1,5) /
     &6.8125E+02,6.6919E+02,6.5513E+02,6.3951E+02,6.2260E+02/
      DATA (KB(JT,29,12),JT=1,5) /
     &6.9998E+02,6.8712E+02,6.7207E+02,6.5530E+02,6.3734E+02/
      DATA (KB(JT,30,12),JT=1,5) /
     &7.1583E+02,7.0209E+02,6.8590E+02,6.6805E+02,6.4904E+02/
      DATA (KB(JT,31,12),JT=1,5) /
     &7.2876E+02,7.1404E+02,6.9677E+02,6.7790E+02,6.5793E+02/
      DATA (KB(JT,32,12),JT=1,5) /
     &7.3900E+02,7.2324E+02,7.0493E+02,6.8513E+02,6.6427E+02/
      DATA (KB(JT,33,12),JT=1,5) /
     &7.4681E+02,7.2991E+02,7.1072E+02,6.9001E+02,6.6847E+02/
      DATA (KB(JT,34,12),JT=1,5) /
     &7.5291E+02,7.3522E+02,7.1519E+02,6.9374E+02,6.7158E+02/
      DATA (KB(JT,35,12),JT=1,5) /
     &7.5888E+02,7.4060E+02,7.1995E+02,6.9804E+02,6.7534E+02/
      DATA (KB(JT,36,12),JT=1,5) /
     &7.6530E+02,7.4674E+02,7.2578E+02,7.0348E+02,6.8047E+02/
      DATA (KB(JT,37,12),JT=1,5) /
     &7.7324E+02,7.5477E+02,7.3385E+02,7.1142E+02,6.8821E+02/
      DATA (KB(JT,38,12),JT=1,5) /
     &7.8031E+02,7.6209E+02,7.4126E+02,7.1874E+02,6.9540E+02/
      DATA (KB(JT,39,12),JT=1,5) /
     &7.8648E+02,7.6857E+02,7.4796E+02,7.2542E+02,7.0198E+02/
      DATA (KB(JT,40,12),JT=1,5) /
     &7.9353E+02,7.7637E+02,7.5617E+02,7.3391E+02,7.1045E+02/
      DATA (KB(JT,41,12),JT=1,5) /
     &7.9989E+02,7.8377E+02,7.6410E+02,7.4214E+02,7.1879E+02/
      DATA (KB(JT,42,12),JT=1,5) /
     &8.0558E+02,7.9048E+02,7.7152E+02,7.4994E+02,7.2677E+02/
      DATA (KB(JT,43,12),JT=1,5) /
     &8.1116E+02,7.9747E+02,7.7955E+02,7.5862E+02,7.3574E+02/
      DATA (KB(JT,44,12),JT=1,5) /
     &8.1607E+02,8.0410E+02,7.8744E+02,7.6731E+02,7.4497E+02/
      DATA (KB(JT,45,12),JT=1,5) /
     &8.1994E+02,8.0997E+02,7.9477E+02,7.7561E+02,7.5385E+02/
      DATA (KB(JT,46,12),JT=1,5) /
     &8.2292E+02,8.1527E+02,8.0168E+02,7.8384E+02,7.6285E+02/
      DATA (KB(JT,47,12),JT=1,5) /
     &8.2480E+02,8.1993E+02,8.0858E+02,7.9229E+02,7.7235E+02/
      DATA (KB(JT,48,12),JT=1,5) /
     &8.2522E+02,8.2345E+02,8.1455E+02,8.0002E+02,7.8135E+02/
      DATA (KB(JT,49,12),JT=1,5) /
     &8.2404E+02,8.2558E+02,8.1941E+02,8.0697E+02,7.8982E+02/
      DATA (KB(JT,50,12),JT=1,5) /
     &8.2131E+02,8.2647E+02,8.2301E+02,8.1277E+02,7.9722E+02/
      DATA (KB(JT,51,12),JT=1,5) /
     &8.1699E+02,8.2604E+02,8.2550E+02,8.1759E+02,8.0380E+02/
      DATA (KB(JT,52,12),JT=1,5) /
     &8.1118E+02,8.2427E+02,8.2691E+02,8.2151E+02,8.0969E+02/
      DATA (KB(JT,53,12),JT=1,5) /
     &8.0369E+02,8.2099E+02,8.2725E+02,8.2455E+02,8.1493E+02/
      DATA (KB(JT,54,12),JT=1,5) /
     &7.9519E+02,8.1662E+02,8.2647E+02,8.2649E+02,8.1904E+02/
      DATA (KB(JT,55,12),JT=1,5) /
     &7.8525E+02,8.1122E+02,8.2466E+02,8.2753E+02,8.2231E+02/
      DATA (KB(JT,56,12),JT=1,5) /
     &7.7348E+02,8.0460E+02,8.2163E+02,8.2776E+02,8.2487E+02/
      DATA (KB(JT,57,12),JT=1,5) /
     &7.5991E+02,7.9652E+02,8.1752E+02,8.2701E+02,8.2675E+02/
      DATA (KB(JT,58,12),JT=1,5) /
     &7.4511E+02,7.8730E+02,8.1251E+02,8.2536E+02,8.2776E+02/
      DATA (KB(JT,59,12),JT=1,5) /
     &7.3866E+02,7.8320E+02,8.1026E+02,8.2449E+02,8.2800E+02/
      DATA (KB(JT,13,13),JT=1,5) /
     &2.0724E+02,2.0318E+02,2.0003E+02,1.9694E+02,1.9365E+02/
      DATA (KB(JT,14,13),JT=1,5) /
     &2.3785E+02,2.3358E+02,2.2976E+02,2.2561E+02,2.2123E+02/
      DATA (KB(JT,15,13),JT=1,5) /
     &2.7371E+02,2.6880E+02,2.6365E+02,2.5854E+02,2.5349E+02/
      DATA (KB(JT,16,13),JT=1,5) /
     &3.1341E+02,3.0766E+02,3.0218E+02,2.9651E+02,2.9050E+02/
      DATA (KB(JT,17,13),JT=1,5) /
     &3.5823E+02,3.5167E+02,3.4512E+02,3.3848E+02,3.3144E+02/
      DATA (KB(JT,18,13),JT=1,5) /
     &4.0795E+02,4.0075E+02,3.9354E+02,3.8585E+02,3.7775E+02/
      DATA (KB(JT,19,13),JT=1,5) /
     &4.6454E+02,4.5636E+02,4.4761E+02,4.3852E+02,4.2883E+02/
      DATA (KB(JT,20,13),JT=1,5) /
     &5.2670E+02,5.1674E+02,5.0627E+02,4.9500E+02,4.8317E+02/
      DATA (KB(JT,21,13),JT=1,5) /
     &5.9234E+02,5.8071E+02,5.6797E+02,5.5430E+02,5.3997E+02/
      DATA (KB(JT,22,13),JT=1,5) /
     &6.5952E+02,6.4514E+02,6.2980E+02,6.1347E+02,5.9629E+02/
      DATA (KB(JT,23,13),JT=1,5) /
     &7.2668E+02,7.0946E+02,6.9096E+02,6.7135E+02,6.5090E+02/
      DATA (KB(JT,24,13),JT=1,5) /
     &7.9179E+02,7.7144E+02,7.4939E+02,7.2625E+02,7.0273E+02/
      DATA (KB(JT,25,13),JT=1,5) /
     &8.5340E+02,8.2954E+02,8.0385E+02,7.7737E+02,7.5044E+02/
      DATA (KB(JT,26,13),JT=1,5) /
     &9.1011E+02,8.8231E+02,8.5326E+02,8.2331E+02,7.9319E+02/
      DATA (KB(JT,27,13),JT=1,5) /
     &9.6106E+02,9.2973E+02,8.9712E+02,8.6391E+02,8.3062E+02/
      DATA (KB(JT,28,13),JT=1,5) /
     &1.0059E+03,9.7091E+02,9.3507E+02,8.9869E+02,8.6233E+02/
      DATA (KB(JT,29,13),JT=1,5) /
     &1.0437E+03,1.0055E+03,9.6641E+02,9.2715E+02,8.8802E+02/
      DATA (KB(JT,30,13),JT=1,5) /
     &1.0747E+03,1.0334E+03,9.9156E+02,9.4965E+02,9.0810E+02/
      DATA (KB(JT,31,13),JT=1,5) /
     &1.0990E+03,1.0548E+03,1.0106E+03,9.6642E+02,9.2291E+02/
      DATA (KB(JT,32,13),JT=1,5) /
     &1.1170E+03,1.0705E+03,1.0242E+03,9.7810E+02,9.3290E+02/
      DATA (KB(JT,33,13),JT=1,5) /
     &1.1295E+03,1.0810E+03,1.0329E+03,9.8524E+02,9.3872E+02/
      DATA (KB(JT,34,13),JT=1,5) /
     &1.1390E+03,1.0889E+03,1.0392E+03,9.9037E+02,9.4276E+02/
      DATA (KB(JT,35,13),JT=1,5) /
     &1.1495E+03,1.0980E+03,1.0471E+03,9.9723E+02,9.4859E+02/
      DATA (KB(JT,36,13),JT=1,5) /
     &1.1627E+03,1.1100E+03,1.0580E+03,1.0071E+03,9.5754E+02/
      DATA (KB(JT,37,13),JT=1,5) /
     &1.1817E+03,1.1279E+03,1.0749E+03,1.0229E+03,9.7232E+02/
      DATA (KB(JT,38,13),JT=1,5) /
     &1.1995E+03,1.1446E+03,1.0907E+03,1.0378E+03,9.8626E+02/
      DATA (KB(JT,39,13),JT=1,5) /
     &1.2156E+03,1.1601E+03,1.1053E+03,1.0516E+03,9.9926E+02/
      DATA (KB(JT,40,13),JT=1,5) /
     &1.2364E+03,1.1800E+03,1.1244E+03,1.0699E+03,1.0167E+03/
      DATA (KB(JT,41,13),JT=1,5) /
     &1.2568E+03,1.1999E+03,1.1435E+03,1.0883E+03,1.0343E+03/
      DATA (KB(JT,42,13),JT=1,5) /
     &1.2764E+03,1.2191E+03,1.1621E+03,1.1062E+03,1.0515E+03/
      DATA (KB(JT,43,13),JT=1,5) /
     &1.2983E+03,1.2411E+03,1.1834E+03,1.1268E+03,1.0715E+03/
      DATA (KB(JT,44,13),JT=1,5) /
     &1.3210E+03,1.2639E+03,1.2059E+03,1.1485E+03,1.0925E+03/
      DATA (KB(JT,45,13),JT=1,5) /
     &1.3430E+03,1.2862E+03,1.2280E+03,1.1702E+03,1.1134E+03/
      DATA (KB(JT,46,13),JT=1,5) /
     &1.3658E+03,1.3092E+03,1.2511E+03,1.1929E+03,1.1355E+03/
      DATA (KB(JT,47,13),JT=1,5) /
     &1.3902E+03,1.3342E+03,1.2766E+03,1.2180E+03,1.1600E+03/
      DATA (KB(JT,48,13),JT=1,5) /
     &1.4137E+03,1.3587E+03,1.3015E+03,1.2430E+03,1.1845E+03/
      DATA (KB(JT,49,13),JT=1,5) /
     &1.4360E+03,1.3827E+03,1.3260E+03,1.2679E+03,1.2090E+03/
      DATA (KB(JT,50,13),JT=1,5) /
     &1.4561E+03,1.4046E+03,1.3487E+03,1.2910E+03,1.2321E+03/
      DATA (KB(JT,51,13),JT=1,5) /
     &1.4745E+03,1.4251E+03,1.3704E+03,1.3131E+03,1.2546E+03/
      DATA (KB(JT,52,13),JT=1,5) /
     &1.4914E+03,1.4448E+03,1.3917E+03,1.3349E+03,1.2767E+03/
      DATA (KB(JT,53,13),JT=1,5) /
     &1.5066E+03,1.4635E+03,1.4124E+03,1.3565E+03,1.2987E+03/
      DATA (KB(JT,54,13),JT=1,5) /
     &1.5189E+03,1.4798E+03,1.4307E+03,1.3761E+03,1.3187E+03/
      DATA (KB(JT,55,13),JT=1,5) /
     &1.5296E+03,1.4942E+03,1.4476E+03,1.3946E+03,1.3376E+03/
      DATA (KB(JT,56,13),JT=1,5) /
     &1.5385E+03,1.5073E+03,1.4637E+03,1.4124E+03,1.3564E+03/
      DATA (KB(JT,57,13),JT=1,5) /
     &1.5454E+03,1.5190E+03,1.4793E+03,1.4298E+03,1.3750E+03/
      DATA (KB(JT,58,13),JT=1,5) /
     &1.5501E+03,1.5291E+03,1.4929E+03,1.4457E+03,1.3924E+03/
      DATA (KB(JT,59,13),JT=1,5) /
     &1.5515E+03,1.5328E+03,1.4982E+03,1.4521E+03,1.3993E+03/
      DATA (KB(JT,13,14),JT=1,5) /
     &2.5226E+02,2.4628E+02,2.3949E+02,2.3300E+02,2.2711E+02/
      DATA (KB(JT,14,14),JT=1,5) /
     &2.8391E+02,2.7613E+02,2.6825E+02,2.6100E+02,2.5461E+02/
      DATA (KB(JT,15,14),JT=1,5) /
     &3.2054E+02,3.1155E+02,3.0330E+02,2.9588E+02,2.8901E+02/
      DATA (KB(JT,16,14),JT=1,5) /
     &3.6563E+02,3.5616E+02,3.4734E+02,3.3914E+02,3.3106E+02/
      DATA (KB(JT,17,14),JT=1,5) /
     &4.2096E+02,4.1081E+02,4.0125E+02,3.9214E+02,3.8323E+02/
      DATA (KB(JT,18,14),JT=1,5) /
     &4.8740E+02,4.7626E+02,4.6528E+02,4.5466E+02,4.4412E+02/
      DATA (KB(JT,19,14),JT=1,5) /
     &5.6419E+02,5.5097E+02,5.3827E+02,5.2557E+02,5.1276E+02/
      DATA (KB(JT,20,14),JT=1,5) /
     &6.5011E+02,6.3415E+02,6.1868E+02,6.0321E+02,5.8733E+02/
      DATA (KB(JT,21,14),JT=1,5) /
     &7.4435E+02,7.2484E+02,7.0550E+02,6.8621E+02,6.6643E+02/
      DATA (KB(JT,22,14),JT=1,5) /
     &8.4421E+02,8.2013E+02,7.9603E+02,7.7185E+02,7.4730E+02/
      DATA (KB(JT,23,14),JT=1,5) /
     &9.4857E+02,9.1895E+02,8.8918E+02,8.5916E+02,8.2913E+02/
      DATA (KB(JT,24,14),JT=1,5) /
     &1.0549E+03,1.0183E+03,9.8186E+02,9.4534E+02,9.0882E+02/
      DATA (KB(JT,25,14),JT=1,5) /
     &1.1590E+03,1.1145E+03,1.0708E+03,1.0270E+03,9.8371E+02/
      DATA (KB(JT,26,14),JT=1,5) /
     &1.2562E+03,1.2038E+03,1.1521E+03,1.1010E+03,1.0508E+03/
      DATA (KB(JT,27,14),JT=1,5) /
     &1.3447E+03,1.2836E+03,1.2238E+03,1.1655E+03,1.1088E+03/
      DATA (KB(JT,28,14),JT=1,5) /
     &1.4217E+03,1.3523E+03,1.2847E+03,1.2199E+03,1.1573E+03/
      DATA (KB(JT,29,14),JT=1,5) /
     &1.4859E+03,1.4088E+03,1.3346E+03,1.2639E+03,1.1961E+03/
      DATA (KB(JT,30,14),JT=1,5) /
     &1.5380E+03,1.4539E+03,1.3740E+03,1.2981E+03,1.2259E+03/
      DATA (KB(JT,31,14),JT=1,5) /
     &1.5776E+03,1.4880E+03,1.4031E+03,1.3231E+03,1.2472E+03/
      DATA (KB(JT,32,14),JT=1,5) /
     &1.6062E+03,1.5119E+03,1.4231E+03,1.3398E+03,1.2610E+03/
      DATA (KB(JT,33,14),JT=1,5) /
     &1.6248E+03,1.5270E+03,1.4353E+03,1.3494E+03,1.2686E+03/
      DATA (KB(JT,34,14),JT=1,5) /
     &1.6386E+03,1.5378E+03,1.4439E+03,1.3560E+03,1.2737E+03/
      DATA (KB(JT,35,14),JT=1,5) /
     &1.6557E+03,1.5522E+03,1.4559E+03,1.3661E+03,1.2821E+03/
      DATA (KB(JT,36,14),JT=1,5) /
     &1.6790E+03,1.5727E+03,1.4740E+03,1.3819E+03,1.2962E+03/
      DATA (KB(JT,37,14),JT=1,5) /
     &1.7154E+03,1.6055E+03,1.5035E+03,1.4086E+03,1.3204E+03/
      DATA (KB(JT,38,14),JT=1,5) /
     &1.7499E+03,1.6367E+03,1.5316E+03,1.4342E+03,1.3436E+03/
      DATA (KB(JT,39,14),JT=1,5) /
     &1.7821E+03,1.6659E+03,1.5579E+03,1.4580E+03,1.3653E+03/
      DATA (KB(JT,40,14),JT=1,5) /
     &1.8250E+03,1.7051E+03,1.5937E+03,1.4906E+03,1.3951E+03/
      DATA (KB(JT,41,14),JT=1,5) /
     &1.8687E+03,1.7449E+03,1.6302E+03,1.5239E+03,1.4257E+03/
      DATA (KB(JT,42,14),JT=1,5) /
     &1.9118E+03,1.7843E+03,1.6662E+03,1.5570E+03,1.4560E+03/
      DATA (KB(JT,43,14),JT=1,5) /
     &1.9625E+03,1.8305E+03,1.7087E+03,1.5959E+03,1.4917E+03/
      DATA (KB(JT,44,14),JT=1,5) /
     &2.0169E+03,1.8802E+03,1.7544E+03,1.6379E+03,1.5302E+03/
      DATA (KB(JT,45,14),JT=1,5) /
     &2.0719E+03,1.9306E+03,1.8005E+03,1.6804E+03,1.5693E+03/
      DATA (KB(JT,46,14),JT=1,5) /
     &2.1310E+03,1.9850E+03,1.8502E+03,1.7262E+03,1.6114E+03/
      DATA (KB(JT,47,14),JT=1,5) /
     &2.1977E+03,2.0465E+03,1.9066E+03,1.7781E+03,1.6592E+03/
      DATA (KB(JT,48,14),JT=1,5) /
     &2.2663E+03,2.1096E+03,1.9646E+03,1.8312E+03,1.7082E+03/
      DATA (KB(JT,49,14),JT=1,5) /
     &2.3369E+03,2.1743E+03,2.0243E+03,1.8859E+03,1.7586E+03/
      DATA (KB(JT,50,14),JT=1,5) /
     &2.4050E+03,2.2366E+03,2.0818E+03,1.9387E+03,1.8071E+03/
      DATA (KB(JT,51,14),JT=1,5) /
     &2.4725E+03,2.2988E+03,2.1390E+03,1.9914E+03,1.8554E+03/
      DATA (KB(JT,52,14),JT=1,5) /
     &2.5415E+03,2.3629E+03,2.1974E+03,2.0453E+03,1.9050E+03/
      DATA (KB(JT,53,14),JT=1,5) /
     &2.6121E+03,2.4283E+03,2.2576E+03,2.1009E+03,1.9561E+03/
      DATA (KB(JT,54,14),JT=1,5) /
     &2.6782E+03,2.4899E+03,2.3146E+03,2.1531E+03,2.0043E+03/
      DATA (KB(JT,55,14),JT=1,5) /
     &2.7428E+03,2.5502E+03,2.3706E+03,2.2044E+03,2.0516E+03/
      DATA (KB(JT,56,14),JT=1,5) /
     &2.8087E+03,2.6116E+03,2.4275E+03,2.2567E+03,2.0999E+03/
      DATA (KB(JT,57,14),JT=1,5) /
     &2.8759E+03,2.6742E+03,2.4859E+03,2.3106E+03,2.1494E+03/
      DATA (KB(JT,58,14),JT=1,5) /
     &2.9406E+03,2.7347E+03,2.5423E+03,2.3630E+03,2.1974E+03/
      DATA (KB(JT,59,14),JT=1,5) /
     &2.9672E+03,2.7595E+03,2.5656E+03,2.3846E+03,2.2171E+03/
      DATA (KB(JT,13,15),JT=1,5) /
     &3.0519E+02,3.0114E+02,2.9666E+02,2.9142E+02,2.8521E+02/
      DATA (KB(JT,14,15),JT=1,5) /
     &3.4479E+02,3.4114E+02,3.3631E+02,3.3085E+02,3.2433E+02/
      DATA (KB(JT,15,15),JT=1,5) /
     &3.8993E+02,3.8674E+02,3.8200E+02,3.7573E+02,3.6825E+02/
      DATA (KB(JT,16,15),JT=1,5) /
     &4.4412E+02,4.3994E+02,4.3428E+02,4.2699E+02,4.1897E+02/
      DATA (KB(JT,17,15),JT=1,5) /
     &5.0918E+02,5.0358E+02,4.9594E+02,4.8667E+02,4.7654E+02/
      DATA (KB(JT,18,15),JT=1,5) /
     &5.8800E+02,5.7963E+02,5.6899E+02,5.5650E+02,5.4319E+02/
      DATA (KB(JT,19,15),JT=1,5) /
     &6.8137E+02,6.6869E+02,6.5385E+02,6.3714E+02,6.1975E+02/
      DATA (KB(JT,20,15),JT=1,5) /
     &7.8942E+02,7.7129E+02,7.5076E+02,7.2873E+02,7.0666E+02/
      DATA (KB(JT,21,15),JT=1,5) /
     &9.1222E+02,8.8683E+02,8.5955E+02,8.3129E+02,8.0321E+02/
      DATA (KB(JT,22,15),JT=1,5) /
     &1.0462E+03,1.0122E+03,9.7665E+02,9.4080E+02,9.0511E+02/
      DATA (KB(JT,23,15),JT=1,5) /
     &1.1896E+03,1.1445E+03,1.0990E+03,1.0540E+03,1.0094E+03/
      DATA (KB(JT,24,15),JT=1,5) /
     &1.3365E+03,1.2790E+03,1.2222E+03,1.1664E+03,1.1117E+03/
      DATA (KB(JT,25,15),JT=1,5) /
     &1.4807E+03,1.4091E+03,1.3391E+03,1.2717E+03,1.2073E+03/
      DATA (KB(JT,26,15),JT=1,5) /
     &1.6156E+03,1.5289E+03,1.4461E+03,1.3673E+03,1.2929E+03/
      DATA (KB(JT,27,15),JT=1,5) /
     &1.7387E+03,1.6377E+03,1.5427E+03,1.4535E+03,1.3699E+03/
      DATA (KB(JT,28,15),JT=1,5) /
     &1.8481E+03,1.7337E+03,1.6274E+03,1.5282E+03,1.4358E+03/
      DATA (KB(JT,29,15),JT=1,5) /
     &1.9406E+03,1.8143E+03,1.6975E+03,1.5890E+03,1.4891E+03/
      DATA (KB(JT,30,15),JT=1,5) /
     &2.0157E+03,1.8789E+03,1.7529E+03,1.6367E+03,1.5303E+03/
      DATA (KB(JT,31,15),JT=1,5) /
     &2.0726E+03,1.9271E+03,1.7935E+03,1.6714E+03,1.5596E+03/
      DATA (KB(JT,32,15),JT=1,5) /
     &2.1128E+03,1.9603E+03,1.8210E+03,1.6943E+03,1.5785E+03/
      DATA (KB(JT,33,15),JT=1,5) /
     &2.1379E+03,1.9802E+03,1.8368E+03,1.7069E+03,1.5884E+03/
      DATA (KB(JT,34,15),JT=1,5) /
     &2.1559E+03,1.9943E+03,1.8478E+03,1.7154E+03,1.5948E+03/
      DATA (KB(JT,35,15),JT=1,5) /
     &2.1801E+03,2.0143E+03,1.8645E+03,1.7293E+03,1.6063E+03/
      DATA (KB(JT,36,15),JT=1,5) /
     &2.2153E+03,2.0448E+03,1.8906E+03,1.7519E+03,1.6260E+03/
      DATA (KB(JT,37,15),JT=1,5) /
     &2.2726E+03,2.0949E+03,1.9348E+03,1.7908E+03,1.6606E+03/
      DATA (KB(JT,38,15),JT=1,5) /
     &2.3276E+03,2.1431E+03,1.9773E+03,1.8285E+03,1.6940E+03/
      DATA (KB(JT,39,15),JT=1,5) /
     &2.3794E+03,2.1884E+03,2.0174E+03,1.8638E+03,1.7255E+03/
      DATA (KB(JT,40,15),JT=1,5) /
     &2.4500E+03,2.2506E+03,2.0727E+03,1.9128E+03,1.7693E+03/
      DATA (KB(JT,41,15),JT=1,5) /
     &2.5230E+03,2.3148E+03,2.1296E+03,1.9633E+03,1.8145E+03/
      DATA (KB(JT,42,15),JT=1,5) /
     &2.5961E+03,2.3790E+03,2.1863E+03,2.0139E+03,1.8595E+03/
      DATA (KB(JT,43,15),JT=1,5) /
     &2.6832E+03,2.4556E+03,2.2539E+03,2.0744E+03,1.9133E+03/
      DATA (KB(JT,44,15),JT=1,5) /
     &2.7787E+03,2.5394E+03,2.3280E+03,2.1403E+03,1.9719E+03/
      DATA (KB(JT,45,15),JT=1,5) /
     &2.8773E+03,2.6257E+03,2.4039E+03,2.2077E+03,2.0320E+03/
      DATA (KB(JT,46,15),JT=1,5) /
     &2.9856E+03,2.7201E+03,2.4871E+03,2.2811E+03,2.0978E+03/
      DATA (KB(JT,47,15),JT=1,5) /
     &3.1115E+03,2.8292E+03,2.5830E+03,2.3659E+03,2.1733E+03/
      DATA (KB(JT,48,15),JT=1,5) /
     &3.2432E+03,2.9440E+03,2.6832E+03,2.4542E+03,2.2517E+03/
      DATA (KB(JT,49,15),JT=1,5) /
     &3.3819E+03,3.0648E+03,2.7882E+03,2.5466E+03,2.3333E+03/
      DATA (KB(JT,50,15),JT=1,5) /
     &3.5188E+03,3.1840E+03,2.8918E+03,2.6374E+03,2.4134E+03/
      DATA (KB(JT,51,15),JT=1,5) /
     &3.6589E+03,3.3051E+03,2.9974E+03,2.7291E+03,2.4943E+03/
      DATA (KB(JT,52,15),JT=1,5) /
     &3.8062E+03,3.4317E+03,3.1077E+03,2.8252E+03,2.5787E+03/
      DATA (KB(JT,53,15),JT=1,5) /
     &3.9623E+03,3.5652E+03,3.2237E+03,2.9261E+03,2.6671E+03/
      DATA (KB(JT,54,15),JT=1,5) /
     &4.1133E+03,3.6940E+03,3.3349E+03,3.0230E+03,2.7515E+03/
      DATA (KB(JT,55,15),JT=1,5) /
     &4.2651E+03,3.8236E+03,3.4464E+03,3.1202E+03,2.8359E+03/
      DATA (KB(JT,56,15),JT=1,5) /
     &4.4246E+03,3.9598E+03,3.5625E+03,3.2212E+03,2.9236E+03/
      DATA (KB(JT,57,15),JT=1,5) /
     &4.5926E+03,4.1026E+03,3.6846E+03,3.3264E+03,3.0154E+03/
      DATA (KB(JT,58,15),JT=1,5) /
     &4.7612E+03,4.2446E+03,3.8056E+03,3.4306E+03,3.1063E+03/
      DATA (KB(JT,59,15),JT=1,5) /
     &4.8322E+03,4.3040E+03,3.8565E+03,3.4742E+03,3.1440E+03/
      DATA (KB(JT,13,16),JT=1,5) /
     &3.6471E+02,3.5203E+02,3.4366E+02,3.3754E+02,3.3391E+02/
      DATA (KB(JT,14,16),JT=1,5) /
     &4.3205E+02,4.1910E+02,4.0949E+02,4.0181E+02,3.9611E+02/
      DATA (KB(JT,15,16),JT=1,5) /
     &5.1076E+02,4.9691E+02,4.8535E+02,4.7583E+02,4.6772E+02/
      DATA (KB(JT,16,16),JT=1,5) /
     &6.0124E+02,5.8532E+02,5.7134E+02,5.5921E+02,5.4786E+02/
      DATA (KB(JT,17,16),JT=1,5) /
     &7.0293E+02,6.8353E+02,6.6658E+02,6.5132E+02,6.3843E+02/
      DATA (KB(JT,18,16),JT=1,5) /
     &8.1350E+02,7.9054E+02,7.7108E+02,7.5418E+02,7.3825E+02/
      DATA (KB(JT,19,16),JT=1,5) /
     &9.3232E+02,9.0753E+02,8.8580E+02,8.6501E+02,8.4456E+02/
      DATA (KB(JT,20,16),JT=1,5) /
     &1.0608E+03,1.0329E+03,1.0063E+03,9.8009E+02,9.5395E+02/
      DATA (KB(JT,21,16),JT=1,5) /
     &1.1958E+03,1.1622E+03,1.1292E+03,1.0962E+03,1.0633E+03/
      DATA (KB(JT,22,16),JT=1,5) /
     &1.3311E+03,1.2897E+03,1.2482E+03,1.2072E+03,1.1676E+03/
      DATA (KB(JT,23,16),JT=1,5) /
     &1.4683E+03,1.4174E+03,1.3670E+03,1.3170E+03,1.2708E+03/
      DATA (KB(JT,24,16),JT=1,5) /
     &1.6081E+03,1.5439E+03,1.4829E+03,1.4263E+03,1.3726E+03/
      DATA (KB(JT,25,16),JT=1,5) /
     &1.7506E+03,1.6769E+03,1.6089E+03,1.5421E+03,1.4771E+03/
      DATA (KB(JT,26,16),JT=1,5) /
     &1.9057E+03,1.8182E+03,1.7345E+03,1.6548E+03,1.5773E+03/
      DATA (KB(JT,27,16),JT=1,5) /
     &2.0569E+03,1.9520E+03,1.8523E+03,1.7577E+03,1.6669E+03/
      DATA (KB(JT,28,16),JT=1,5) /
     &2.1937E+03,2.0714E+03,1.9558E+03,1.8469E+03,1.7437E+03/
      DATA (KB(JT,29,16),JT=1,5) /
     &2.3109E+03,2.1712E+03,2.0410E+03,1.9197E+03,1.8067E+03/
      DATA (KB(JT,30,16),JT=1,5) /
     &2.4059E+03,2.2511E+03,2.1086E+03,1.9768E+03,1.8554E+03/
      DATA (KB(JT,31,16),JT=1,5) /
     &2.4785E+03,2.3110E+03,2.1586E+03,2.0181E+03,1.8908E+03/
      DATA (KB(JT,32,16),JT=1,5) /
     &2.5298E+03,2.3528E+03,2.1923E+03,2.0454E+03,1.9136E+03/
      DATA (KB(JT,33,16),JT=1,5) /
     &2.5622E+03,2.3783E+03,2.2119E+03,2.0610E+03,1.9258E+03/
      DATA (KB(JT,34,16),JT=1,5) /
     &2.5858E+03,2.3964E+03,2.2256E+03,2.0716E+03,1.9341E+03/
      DATA (KB(JT,35,16),JT=1,5) /
     &2.6161E+03,2.4209E+03,2.2454E+03,2.0882E+03,1.9479E+03/
      DATA (KB(JT,36,16),JT=1,5) /
     &2.6591E+03,2.4573E+03,2.2765E+03,2.1149E+03,1.9709E+03/
      DATA (KB(JT,37,16),JT=1,5) /
     &2.7282E+03,2.5168E+03,2.3287E+03,2.1606E+03,2.0108E+03/
      DATA (KB(JT,38,16),JT=1,5) /
     &2.7948E+03,2.5745E+03,2.3791E+03,2.2045E+03,2.0494E+03/
      DATA (KB(JT,39,16),JT=1,5) /
     &2.8577E+03,2.6290E+03,2.4266E+03,2.2455E+03,2.0858E+03/
      DATA (KB(JT,40,16),JT=1,5) /
     &2.9439E+03,2.7038E+03,2.4920E+03,2.3032E+03,2.1363E+03/
      DATA (KB(JT,41,16),JT=1,5) /
     &3.0330E+03,2.7810E+03,2.5596E+03,2.3632E+03,2.1888E+03/
      DATA (KB(JT,42,16),JT=1,5) /
     &3.1221E+03,2.8586E+03,2.6274E+03,2.4230E+03,2.2411E+03/
      DATA (KB(JT,43,16),JT=1,5) /
     &3.2294E+03,2.9518E+03,2.6848E+03,2.4944E+03,2.3041E+03/
      DATA (KB(JT,44,16),JT=1,5) /
     &3.3475E+03,3.0539E+03,2.7976E+03,2.5728E+03,2.3737E+03/
      DATA (KB(JT,45,16),JT=1,5) /
     &3.4703E+03,3.1592E+03,2.8896E+03,2.6532E+03,2.4448E+03/
      DATA (KB(JT,46,16),JT=1,5) /
     &3.6062E+03,3.2757E+03,2.9905E+03,2.7415E+03,2.5226E+03/
      DATA (KB(JT,47,16),JT=1,5) /
     &3.7659E+03,3.4109E+03,3.1077E+03,2.8434E+03,2.6124E+03/
      DATA (KB(JT,48,16),JT=1,5) /
     &3.9357E+03,3.5542E+03,3.2307E+03,2.9507E+03,2.7060E+03/
      DATA (KB(JT,49,16),JT=1,5) /
     &4.1183E+03,3.7067E+03,3.3602E+03,3.0634E+03,2.8046E+03/
      DATA (KB(JT,50,16),JT=1,5) /
     &4.3018E+03,3.8593E+03,3.4893E+03,3.1743E+03,2.9010E+03/
      DATA (KB(JT,51,16),JT=1,5) /
     &4.4921E+03,4.0168E+03,3.6208E+03,3.2876E+03,3.0000E+03/
      DATA (KB(JT,52,16),JT=1,5) /
     &4.6953E+03,4.1848E+03,3.7620E+03,3.4065E+03,3.1029E+03/
      DATA (KB(JT,53,16),JT=1,5) /
     &4.9149E+03,4.3644E+03,3.9107E+03,3.5325E+03,3.2110E+03/
      DATA (KB(JT,54,16),JT=1,5) /
     &5.1330E+03,4.5400E+03,4.0560E+03,3.6544E+03,3.3151E+03/
      DATA (KB(JT,55,16),JT=1,5) /
     &5.3615E+03,4.7192E+03,4.2041E+03,3.7779E+03,3.4198E+03/
      DATA (KB(JT,56,16),JT=1,5) /
     &5.6061E+03,4.9107E+03,4.3608E+03,3.9074E+03,3.5296E+03/
      DATA (KB(JT,57,16),JT=1,5) /
     &5.8683E+03,5.1170E+03,4.5267E+03,4.0448E+03,3.6452E+03/
      DATA (KB(JT,58,16),JT=1,5) /
     &6.1353E+03,5.3291E+03,4.6942E+03,4.1832E+03,3.7603E+03/
      DATA (KB(JT,59,16),JT=1,5) /
     &6.2495E+03,5.4200E+03,4.7647E+03,4.2413E+03,3.8086E+03/

C     The array KA_Mxx contains the absorption coefficient for 
C     a minor species at the 16 chosen g-values for a reference pressure
C     level below 100~ mb.   The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.  The second index refers to temperature 
C     in 7.2 degree increments.  For instance, JT = 1 refers to a 
C     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
C     runs over the g-channel (1 to 16).

      DATA (KA_MCO2( 1,JT, 1),JT=1,19)  /
     & 7.38630e-06, 8.97432e-06, 1.09037e-05, 1.32480e-05, 1.60963e-05,
     & 1.95569e-05, 2.37615e-05, 2.88701e-05, 3.50770e-05, 4.26184e-05,
     & 5.17811e-05, 6.29138e-05, 7.64400e-05, 9.28742e-05, 1.12842e-04,
     & 1.37102e-04, 1.66578e-04, 2.02392e-04, 2.45905e-04/
      DATA (KA_MCO2( 2,JT, 1),JT=1,19)  /
     & 7.03916e-06, 8.58785e-06, 1.04773e-05, 1.27824e-05, 1.55947e-05,
     & 1.90257e-05, 2.32115e-05, 2.83183e-05, 3.45487e-05, 4.21498e-05,
     & 5.14233e-05, 6.27370e-05, 7.65398e-05, 9.33794e-05, 1.13924e-04,
     & 1.38989e-04, 1.69568e-04, 2.06874e-04, 2.52389e-04/
      DATA (KA_MCO2( 3,JT, 1),JT=1,19)  /
     & 7.80015e-06, 9.48520e-06, 1.15343e-05, 1.40260e-05, 1.70560e-05,
     & 2.07405e-05, 2.52211e-05, 3.06695e-05, 3.72950e-05, 4.53517e-05,
     & 5.51489e-05, 6.70626e-05, 8.15499e-05, 9.91670e-05, 1.20590e-04,
     & 1.46640e-04, 1.78319e-04, 2.16841e-04, 2.63684e-04/
      DATA (KA_MCO2( 4,JT, 1),JT=1,19)  /
     & 9.24267e-06, 1.11747e-05, 1.35105e-05, 1.63346e-05, 1.97490e-05,
     & 2.38771e-05, 2.88682e-05, 3.49025e-05, 4.21981e-05, 5.10188e-05,
     & 6.16832e-05, 7.45768e-05, 9.01656e-05, 1.09013e-04, 1.31800e-04,
     & 1.59350e-04, 1.92659e-04, 2.32930e-04, 2.81619e-04/
      DATA (KA_MCO2( 5,JT, 1),JT=1,19)  /
     & 1.59506e-05, 1.90078e-05, 2.26509e-05, 2.69923e-05, 3.21658e-05,
     & 3.83309e-05, 4.56777e-05, 5.44325e-05, 6.48654e-05, 7.72978e-05,
     & 9.21132e-05, 1.09768e-04, 1.30807e-04, 1.55878e-04, 1.85755e-04,
     & 2.21357e-04, 2.63784e-04, 3.14342e-04, 3.74591e-04/
      DATA (KA_MCO2( 6,JT, 1),JT=1,19)  /
     & 3.53189e-05, 4.14789e-05, 4.87131e-05, 5.72092e-05, 6.71870e-05,
     & 7.89050e-05, 9.26667e-05, 1.08829e-04, 1.27809e-04, 1.50100e-04,
     & 1.76279e-04, 2.07024e-04, 2.43131e-04, 2.85535e-04, 3.35335e-04,
     & 3.93821e-04, 4.62507e-04, 5.43172e-04, 6.37906e-04/
      DATA (KA_MCO2( 7,JT, 1),JT=1,19)  /
     & 6.63273e-05, 7.76356e-05, 9.08718e-05, 1.06365e-04, 1.24499e-04,
     & 1.45725e-04, 1.70570e-04, 1.99651e-04, 2.33689e-04, 2.73531e-04,
     & 3.20166e-04, 3.74752e-04, 4.38644e-04, 5.13429e-04, 6.00964e-04,
     & 7.03424e-04, 8.23352e-04, 9.63726e-04, 1.12803e-03/
      DATA (KA_MCO2( 8,JT, 1),JT=1,19)  /
     & 9.01134e-05, 1.05517e-04, 1.23553e-04, 1.44673e-04, 1.69402e-04,
     & 1.98359e-04, 2.32265e-04, 2.71967e-04, 3.18456e-04, 3.72890e-04,
     & 4.36630e-04, 5.11265e-04, 5.98657e-04, 7.00989e-04, 8.20811e-04,
     & 9.61116e-04, 1.12540e-03, 1.31777e-03, 1.54302e-03/
      DATA (KA_MCO2( 9,JT, 1),JT=1,19)  /
     & 1.14205e-05, 1.36364e-05, 1.62823e-05, 1.94416e-05, 2.32139e-05,
     & 2.77181e-05, 3.30963e-05, 3.95181e-05, 4.71858e-05, 5.63414e-05,
     & 6.72734e-05, 8.03266e-05, 9.59124e-05, 1.14523e-04, 1.36743e-04,
     & 1.63276e-04, 1.94957e-04, 2.32784e-04, 2.77952e-04/
      DATA (KA_MCO2( 1,JT, 2),JT=1,19)  /
     & 2.01754e-05, 2.40506e-05, 2.86701e-05, 3.41769e-05, 4.07414e-05,
     & 4.85668e-05, 5.78953e-05, 6.90155e-05, 8.22717e-05, 9.80739e-05,
     & 1.16912e-04, 1.39367e-04, 1.66136e-04, 1.98047e-04, 2.36087e-04,
     & 2.81433e-04, 3.35489e-04, 3.99928e-04, 4.76744e-04/
      DATA (KA_MCO2( 2,JT, 2),JT=1,19)  /
     & 2.08613e-05, 2.48759e-05, 2.96631e-05, 3.53716e-05, 4.21786e-05,
     & 5.02955e-05, 5.99746e-05, 7.15163e-05, 8.52791e-05, 1.01690e-04,
     & 1.21260e-04, 1.44596e-04, 1.72422e-04, 2.05604e-04, 2.45171e-04,
     & 2.92352e-04, 3.48613e-04, 4.15702e-04, 4.95700e-04/
      DATA (KA_MCO2( 3,JT, 2),JT=1,19)  /
     & 2.06879e-05, 2.47009e-05, 2.94924e-05, 3.52133e-05, 4.20439e-05,
     & 5.01995e-05, 5.99372e-05, 7.15637e-05, 8.54456e-05, 1.02020e-04,
     & 1.21810e-04, 1.45439e-04, 1.73651e-04, 2.07335e-04, 2.47554e-04,
     & 2.95574e-04, 3.52909e-04, 4.21366e-04, 5.03102e-04/
      DATA (KA_MCO2( 4,JT, 2),JT=1,19)  /
     & 2.12700e-05, 2.54064e-05, 3.03472e-05, 3.62490e-05, 4.32984e-05,
     & 5.17188e-05, 6.17767e-05, 7.37906e-05, 8.81410e-05, 1.05282e-04,
     & 1.25757e-04, 1.50213e-04, 1.79425e-04, 2.14319e-04, 2.55998e-04,
     & 3.05782e-04, 3.65249e-04, 4.36280e-04, 5.21125e-04/
      DATA (KA_MCO2( 5,JT, 2),JT=1,19)  /
     & 1.88144e-05, 2.25220e-05, 2.69602e-05, 3.22730e-05, 3.86328e-05,
     & 4.62458e-05, 5.53591e-05, 6.62682e-05, 7.93271e-05, 9.49594e-05,
     & 1.13672e-04, 1.36073e-04, 1.62887e-04, 1.94986e-04, 2.33410e-04,
     & 2.79406e-04, 3.34467e-04, 4.00377e-04, 4.79275e-04/
      DATA (KA_MCO2( 6,JT, 2),JT=1,19)  /
     & 1.20964e-05, 1.46021e-05, 1.76268e-05, 2.12780e-05, 2.56856e-05,
     & 3.10062e-05, 3.74289e-05, 4.51820e-05, 5.45411e-05, 6.58388e-05,
     & 7.94769e-05, 9.59399e-05, 1.15813e-04, 1.39803e-04, 1.68762e-04,
     & 2.03720e-04, 2.45919e-04, 2.96859e-04, 3.58350e-04/
      DATA (KA_MCO2( 7,JT, 2),JT=1,19)  /
     & 3.07117e-05, 3.64441e-05, 4.32465e-05, 5.13186e-05, 6.08974e-05,
     & 7.22642e-05, 8.57525e-05, 1.01758e-04, 1.20752e-04, 1.43291e-04,
     & 1.70037e-04, 2.01775e-04, 2.39436e-04, 2.84128e-04, 3.37161e-04,
     & 4.00094e-04, 4.74773e-04, 5.63391e-04, 6.68549e-04/
      DATA (KA_MCO2( 8,JT, 2),JT=1,19)  /
     & 9.34077e-05, 1.10481e-04, 1.30675e-04, 1.54559e-04, 1.82810e-04,
     & 2.16224e-04, 2.55745e-04, 3.02491e-04, 3.57780e-04, 4.23175e-04,
     & 5.00523e-04, 5.92009e-04, 7.00217e-04, 8.28203e-04, 9.79582e-04,
     & 1.15863e-03, 1.37041e-03, 1.62089e-03, 1.91716e-03/
      DATA (KA_MCO2( 9,JT, 2),JT=1,19)  /
     & 1.15325e-05, 1.37935e-05, 1.64978e-05, 1.97322e-05, 2.36007e-05,
     & 2.82277e-05, 3.37618e-05, 4.03808e-05, 4.82976e-05, 5.77664e-05,
     & 6.90916e-05, 8.26372e-05, 9.88384e-05, 1.18216e-04, 1.41392e-04,
     & 1.69113e-04, 2.02267e-04, 2.41922e-04, 2.89352e-04/
      DATA (KA_MCO2( 1,JT, 3),JT=1,19)  /
     & 2.56142e-05, 3.05385e-05, 3.64096e-05, 4.34093e-05, 5.17547e-05,
     & 6.17045e-05, 7.35672e-05, 8.77104e-05, 1.04573e-04, 1.24677e-04,
     & 1.48646e-04, 1.77223e-04, 2.11294e-04, 2.51915e-04, 3.00346e-04,
     & 3.58087e-04, 4.26929e-04, 5.09006e-04, 6.06862e-04/
      DATA (KA_MCO2( 2,JT, 3),JT=1,19)  /
     & 2.49802e-05, 2.98040e-05, 3.55593e-05, 4.24259e-05, 5.06186e-05,
     & 6.03932e-05, 7.20554e-05, 8.59696e-05, 1.02571e-04, 1.22377e-04,
     & 1.46009e-04, 1.74204e-04, 2.07844e-04, 2.47979e-04, 2.95865e-04,
     & 3.52998e-04, 4.21163e-04, 5.02491e-04, 5.99524e-04/
      DATA (KA_MCO2( 3,JT, 3),JT=1,19)  /
     & 2.54644e-05, 3.03959e-05, 3.62825e-05, 4.33091e-05, 5.16965e-05,
     & 6.17083e-05, 7.36589e-05, 8.79240e-05, 1.04952e-04, 1.25277e-04,
     & 1.49539e-04, 1.78499e-04, 2.13068e-04, 2.54331e-04, 3.03586e-04,
     & 3.62380e-04, 4.32560e-04, 5.16331e-04, 6.16326e-04/
      DATA (KA_MCO2( 4,JT, 3),JT=1,19)  /
     & 2.55054e-05, 3.04699e-05, 3.64007e-05, 4.34859e-05, 5.19501e-05,
     & 6.20619e-05, 7.41418e-05, 8.85731e-05, 1.05813e-04, 1.26409e-04,
     & 1.51014e-04, 1.80408e-04, 2.15523e-04, 2.57474e-04, 3.07589e-04,
     & 3.67459e-04, 4.38983e-04, 5.24428e-04, 6.26505e-04/
      DATA (KA_MCO2( 5,JT, 3),JT=1,19)  /
     & 2.48615e-05, 2.97398e-05, 3.55754e-05, 4.25560e-05, 5.09064e-05,
     & 6.08952e-05, 7.28441e-05, 8.71375e-05, 1.04236e-04, 1.24689e-04,
     & 1.49155e-04, 1.78423e-04, 2.13433e-04, 2.55313e-04, 3.05410e-04,
     & 3.65338e-04, 4.37024e-04, 5.22777e-04, 6.25356e-04/
      DATA (KA_MCO2( 6,JT, 3),JT=1,19)  /
     & 2.09074e-05, 2.50891e-05, 3.01072e-05, 3.61290e-05, 4.33553e-05,
     & 5.20269e-05, 6.24329e-05, 7.49202e-05, 8.99051e-05, 1.07887e-04,
     & 1.29466e-04, 1.55361e-04, 1.86435e-04, 2.23724e-04, 2.68471e-04,
     & 3.22169e-04, 3.86607e-04, 4.63933e-04, 5.56725e-04/
      DATA (KA_MCO2( 7,JT, 3),JT=1,19)  /
     & 1.25163e-05, 1.51688e-05, 1.83835e-05, 2.22795e-05, 2.70011e-05,
     & 3.27234e-05, 3.96583e-05, 4.80630e-05, 5.82488e-05, 7.05933e-05,
     & 8.55539e-05, 1.03685e-04, 1.25659e-04, 1.52289e-04, 1.84563e-04,
     & 2.23677e-04, 2.71081e-04, 3.28530e-04, 3.98154e-04/
      DATA (KA_MCO2( 8,JT, 3),JT=1,19)  /
     & 1.00408e-04, 1.20081e-04, 1.43608e-04, 1.71745e-04, 2.05395e-04,
     & 2.45637e-04, 2.93765e-04, 3.51322e-04, 4.20156e-04, 5.02476e-04,
     & 6.00926e-04, 7.18665e-04, 8.59472e-04, 1.02787e-03, 1.22926e-03,
     & 1.47010e-03, 1.75814e-03, 2.10261e-03, 2.51457e-03/
      DATA (KA_MCO2( 9,JT, 3),JT=1,19)  /
     & 8.50402e-06, 1.02737e-05, 1.24116e-05, 1.49945e-05, 1.81148e-05,
     & 2.18844e-05, 2.64385e-05, 3.19403e-05, 3.85871e-05, 4.66169e-05,
     & 5.63178e-05, 6.80375e-05, 8.21959e-05, 9.93008e-05, 1.19965e-04,
     & 1.44930e-04, 1.75089e-04, 2.11525e-04, 2.55543e-04/
      DATA (KA_MCO2( 1,JT, 4),JT=1,19)  /
     & 2.68659e-05, 3.20986e-05, 3.83506e-05, 4.58203e-05, 5.47450e-05,
     & 6.54078e-05, 7.81476e-05, 9.33687e-05, 1.11555e-04, 1.33282e-04,
     & 1.59242e-04, 1.90259e-04, 2.27316e-04, 2.71592e-04, 3.24490e-04,
     & 3.87693e-04, 4.63206e-04, 5.53426e-04, 6.61218e-04/
      DATA (KA_MCO2( 2,JT, 4),JT=1,19)  /
     & 2.74827e-05, 3.28460e-05, 3.92560e-05, 4.69169e-05, 5.60728e-05,
     & 6.70155e-05, 8.00937e-05, 9.57241e-05, 1.14405e-04, 1.36731e-04,
     & 1.63415e-04, 1.95305e-04, 2.33419e-04, 2.78972e-04, 3.33413e-04,
     & 3.98480e-04, 4.76244e-04, 5.69184e-04, 6.80261e-04/
      DATA (KA_MCO2( 3,JT, 4),JT=1,19)  /
     & 2.84702e-05, 3.40189e-05, 4.06490e-05, 4.85713e-05, 5.80375e-05,
     & 6.93487e-05, 8.28644e-05, 9.90142e-05, 1.18312e-04, 1.41370e-04,
     & 1.68922e-04, 2.01844e-04, 2.41182e-04, 2.88188e-04, 3.44354e-04,
     & 4.11466e-04, 4.91659e-04, 5.87481e-04, 7.01977e-04/
      DATA (KA_MCO2( 4,JT, 4),JT=1,19)  /
     & 2.92293e-05, 3.49243e-05, 4.17289e-05, 4.98593e-05, 5.95738e-05,
     & 7.11810e-05, 8.50498e-05, 1.01621e-04, 1.21420e-04, 1.45078e-04,
     & 1.73344e-04, 2.07119e-04, 2.47473e-04, 2.95690e-04, 3.53302e-04,
     & 4.22139e-04, 5.04388e-04, 6.02662e-04, 7.20083e-04/
      DATA (KA_MCO2( 5,JT, 4),JT=1,19)  /
     & 2.88531e-05, 3.45646e-05, 4.14067e-05, 4.96033e-05, 5.94224e-05,
     & 7.11851e-05, 8.52764e-05, 1.02157e-04, 1.22379e-04, 1.46604e-04,
     & 1.75625e-04, 2.10391e-04, 2.52038e-04, 3.01929e-04, 3.61697e-04,
     & 4.33295e-04, 5.19067e-04, 6.21818e-04, 7.44908e-04/
      DATA (KA_MCO2( 6,JT, 4),JT=1,19)  /
     & 2.79869e-05, 3.36885e-05, 4.05516e-05, 4.88130e-05, 5.87574e-05,
     & 7.07278e-05, 8.51368e-05, 1.02481e-04, 1.23359e-04, 1.48490e-04,
     & 1.78742e-04, 2.15156e-04, 2.58988e-04, 3.11751e-04, 3.75262e-04,
     & 4.51712e-04, 5.43737e-04, 6.54510e-04, 7.87849e-04/
      DATA (KA_MCO2( 7,JT, 4),JT=1,19)  /
     & 1.45797e-05, 1.78204e-05, 2.17815e-05, 2.66230e-05, 3.25407e-05,
     & 3.97737e-05, 4.86145e-05, 5.94203e-05, 7.26281e-05, 8.87715e-05,
     & 1.08503e-04, 1.32621e-04, 1.62100e-04, 1.98130e-04, 2.42170e-04,
     & 2.95999e-04, 3.61792e-04, 4.42210e-04, 5.40503e-04/
      DATA (KA_MCO2( 8,JT, 4),JT=1,19)  /
     & 6.32607e-05, 7.63420e-05, 9.21282e-05, 1.11179e-04, 1.34169e-04,
     & 1.61913e-04, 1.95393e-04, 2.35797e-04, 2.84557e-04, 3.43398e-04,
     & 4.14407e-04, 5.00100e-04, 6.03512e-04, 7.28308e-04, 8.78909e-04,
     & 1.06065e-03, 1.27998e-03, 1.54466e-03, 1.86407e-03/
      DATA (KA_MCO2( 9,JT, 4),JT=1,19)  /
     & 1.52296e-05, 1.84301e-05, 2.23032e-05, 2.69902e-05, 3.26622e-05,
     & 3.95261e-05, 4.78324e-05, 5.78844e-05, 7.00487e-05, 8.47694e-05,
     & 1.02584e-04, 1.24142e-04, 1.50230e-04, 1.81800e-04, 2.20005e-04,
     & 2.66239e-04, 3.22190e-04, 3.89897e-04, 4.71833e-04/
      DATA (KA_MCO2( 1,JT, 5),JT=1,19)  /
     & 3.43213e-05, 4.11301e-05, 4.92896e-05, 5.90679e-05, 7.07860e-05,
     & 8.48288e-05, 1.01657e-04, 1.21825e-04, 1.45993e-04, 1.74955e-04,
     & 2.09663e-04, 2.51257e-04, 3.01103e-04, 3.60837e-04, 4.32421e-04,
     & 5.18206e-04, 6.21010e-04, 7.44208e-04, 8.91846e-04/
      DATA (KA_MCO2( 2,JT, 5),JT=1,19)  /
     & 3.14792e-05, 3.79075e-05, 4.56485e-05, 5.49703e-05, 6.61956e-05,
     & 7.97133e-05, 9.59914e-05, 1.15594e-04, 1.39199e-04, 1.67624e-04,
     & 2.01854e-04, 2.43075e-04, 2.92712e-04, 3.52487e-04, 4.24467e-04,
     & 5.11147e-04, 6.15527e-04, 7.41222e-04, 8.92585e-04/
      DATA (KA_MCO2( 3,JT, 5),JT=1,19)  /
     & 3.21655e-05, 3.87990e-05, 4.68006e-05, 5.64523e-05, 6.80945e-05,
     & 8.21377e-05, 9.90770e-05, 1.19510e-04, 1.44156e-04, 1.73886e-04,
     & 2.09746e-04, 2.53002e-04, 3.05179e-04, 3.68117e-04, 4.44033e-04,
     & 5.35607e-04, 6.46066e-04, 7.79304e-04, 9.40020e-04/
      DATA (KA_MCO2( 4,JT, 5),JT=1,19)  /
     & 3.22870e-05, 3.89864e-05, 4.70759e-05, 5.68439e-05, 6.86388e-05,
     & 8.28810e-05, 1.00078e-04, 1.20844e-04, 1.45919e-04, 1.76196e-04,
     & 2.12756e-04, 2.56902e-04, 3.10207e-04, 3.74574e-04, 4.52296e-04,
     & 5.46146e-04, 6.59468e-04, 7.96304e-04, 9.61533e-04/
      DATA (KA_MCO2( 5,JT, 5),JT=1,19)  /
     & 3.31190e-05, 3.99528e-05, 4.81967e-05, 5.81417e-05, 7.01387e-05,
     & 8.46111e-05, 1.02070e-04, 1.23131e-04, 1.48538e-04, 1.79187e-04,
     & 2.16161e-04, 2.60764e-04, 3.14570e-04, 3.79479e-04, 4.57781e-04,
     & 5.52240e-04, 6.66190e-04, 8.03652e-04, 9.69477e-04/
      DATA (KA_MCO2( 6,JT, 5),JT=1,19)  /
     & 3.31287e-05, 3.99772e-05, 4.82413e-05, 5.82139e-05, 7.02480e-05,
     & 8.47698e-05, 1.02294e-04, 1.23440e-04, 1.48958e-04, 1.79750e-04,
     & 2.16909e-04, 2.61749e-04, 3.15858e-04, 3.81153e-04, 4.59945e-04,
     & 5.55026e-04, 6.69762e-04, 8.08216e-04, 9.75292e-04/
      DATA (KA_MCO2( 7,JT, 5),JT=1,19)  /
     & 3.35235e-05, 4.02832e-05, 4.84061e-05, 5.81668e-05, 6.98958e-05,
     & 8.39898e-05, 1.00926e-04, 1.21277e-04, 1.45731e-04, 1.75117e-04,
     & 2.10428e-04, 2.52860e-04, 3.03847e-04, 3.65116e-04, 4.38739e-04,
     & 5.27208e-04, 6.33516e-04, 7.61260e-04, 9.14762e-04/
      DATA (KA_MCO2( 8,JT, 5),JT=1,19)  /
     & 3.57666e-05, 4.27511e-05, 5.10995e-05, 6.10783e-05, 7.30057e-05,
     & 8.72622e-05, 1.04303e-04, 1.24671e-04, 1.49017e-04, 1.78117e-04,
     & 2.12900e-04, 2.54475e-04, 3.04169e-04, 3.63567e-04, 4.34565e-04,
     & 5.19427e-04, 6.20861e-04, 7.42103e-04, 8.87020e-04/
      DATA (KA_MCO2( 9,JT, 5),JT=1,19)  /
     & 2.96349e-05, 3.55202e-05, 4.25743e-05, 5.10292e-05, 6.11633e-05,
     & 7.33099e-05, 8.78687e-05, 1.05319e-04, 1.26234e-04, 1.51304e-04,
     & 1.81352e-04, 2.17367e-04, 2.60534e-04, 3.12275e-04, 3.74290e-04,
     & 4.48622e-04, 5.37715e-04, 6.44502e-04, 7.72495e-04/
      DATA (KA_MCO2( 1,JT, 6),JT=1,19)  /
     & 4.14659e-05, 4.98693e-05, 5.99757e-05, 7.21302e-05, 8.67479e-05,
     & 1.04328e-04, 1.25471e-04, 1.50899e-04, 1.81479e-04, 2.18257e-04,
     & 2.62489e-04, 3.15685e-04, 3.79660e-04, 4.56601e-04, 5.49135e-04,
     & 6.60422e-04, 7.94261e-04, 9.55224e-04, 1.14881e-03/
      DATA (KA_MCO2( 2,JT, 6),JT=1,19)  /
     & 4.25940e-05, 5.11162e-05, 6.13434e-05, 7.36168e-05, 8.83459e-05,
     & 1.06022e-04, 1.27235e-04, 1.52691e-04, 1.83241e-04, 2.19904e-04,
     & 2.63902e-04, 3.16703e-04, 3.80068e-04, 4.56111e-04, 5.47368e-04,
     & 6.56885e-04, 7.88313e-04, 9.46036e-04, 1.13532e-03/
      DATA (KA_MCO2( 3,JT, 6),JT=1,19)  /
     & 4.44940e-05, 5.32922e-05, 6.38303e-05, 7.64522e-05, 9.15700e-05,
     & 1.09677e-04, 1.31365e-04, 1.57341e-04, 1.88454e-04, 2.25719e-04,
     & 2.70353e-04, 3.23813e-04, 3.87844e-04, 4.64537e-04, 5.56395e-04,
     & 6.66418e-04, 7.98196e-04, 9.56032e-04, 1.14508e-03/
      DATA (KA_MCO2( 4,JT, 6),JT=1,19)  /
     & 4.83402e-05, 5.78065e-05, 6.91265e-05, 8.26633e-05, 9.88510e-05,
     & 1.18209e-04, 1.41357e-04, 1.69038e-04, 2.02140e-04, 2.41725e-04,
     & 2.89061e-04, 3.45667e-04, 4.13357e-04, 4.94303e-04, 5.91101e-04,
     & 7.06854e-04, 8.45275e-04, 1.01080e-03, 1.20874e-03/
      DATA (KA_MCO2( 5,JT, 6),JT=1,19)  /
     & 5.14797e-05, 6.15328e-05, 7.35491e-05, 8.79120e-05, 1.05080e-04,
     & 1.25600e-04, 1.50128e-04, 1.79445e-04, 2.14487e-04, 2.56373e-04,
     & 3.06438e-04, 3.66281e-04, 4.37809e-04, 5.23305e-04, 6.25498e-04,
     & 7.47647e-04, 8.93650e-04, 1.06816e-03, 1.27676e-03/
      DATA (KA_MCO2( 6,JT, 6),JT=1,19)  /
     & 5.71481e-05, 6.83156e-05, 8.16652e-05, 9.76237e-05, 1.16701e-04,
     & 1.39505e-04, 1.66766e-04, 1.99354e-04, 2.38311e-04, 2.84879e-04,
     & 3.40548e-04, 4.07096e-04, 4.86647e-04, 5.81744e-04, 6.95424e-04,
     & 8.31318e-04, 9.93769e-04, 1.18796e-03, 1.42010e-03/
      DATA (KA_MCO2( 7,JT, 6),JT=1,19)  /
     & 5.69513e-05, 6.84420e-05, 8.22512e-05, 9.88466e-05, 1.18790e-04,
     & 1.42758e-04, 1.71562e-04, 2.06177e-04, 2.47776e-04, 2.97768e-04,
     & 3.57848e-04, 4.30049e-04, 5.16817e-04, 6.21093e-04, 7.46407e-04,
     & 8.97006e-04, 1.07799e-03, 1.29549e-03, 1.55687e-03/
      DATA (KA_MCO2( 8,JT, 6),JT=1,19)  /
     & 4.39361e-06, 5.50076e-06, 6.88690e-06, 8.62235e-06, 1.07951e-05,
     & 1.35154e-05, 1.69212e-05, 2.11851e-05, 2.65236e-05, 3.32074e-05,
     & 4.15754e-05, 5.20520e-05, 6.51687e-05, 8.15907e-05, 1.02151e-04,
     & 1.27892e-04, 1.60120e-04, 2.00469e-04, 2.50985e-04/
      DATA (KA_MCO2( 9,JT, 6),JT=1,19)  /
     & 5.75515e-05, 6.86850e-05, 8.19722e-05, 9.78298e-05, 1.16755e-04,
     & 1.39342e-04, 1.66297e-04, 1.98468e-04, 2.36862e-04, 2.82683e-04,
     & 3.37369e-04, 4.02633e-04, 4.80523e-04, 5.73481e-04, 6.84422e-04,
     & 8.16824e-04, 9.74841e-04, 1.16342e-03, 1.38849e-03/
      DATA (KA_MCO2( 1,JT, 7),JT=1,19)  /
     & 6.84544e-05, 8.16461e-05, 9.73799e-05, 1.16146e-04, 1.38528e-04,
     & 1.65223e-04, 1.97063e-04, 2.35039e-04, 2.80333e-04, 3.34355e-04,
     & 3.98788e-04, 4.75637e-04, 5.67296e-04, 6.76618e-04, 8.07008e-04,
     & 9.62525e-04, 1.14801e-03, 1.36924e-03, 1.63310e-03/
      DATA (KA_MCO2( 2,JT, 7),JT=1,19)  /
     & 6.88332e-05, 8.21719e-05, 9.80955e-05, 1.17105e-04, 1.39798e-04,
     & 1.66888e-04, 1.99229e-04, 2.37836e-04, 2.83925e-04, 3.38944e-04,
     & 4.04627e-04, 4.83037e-04, 5.76641e-04, 6.88385e-04, 8.21782e-04,
     & 9.81031e-04, 1.17114e-03, 1.39809e-03, 1.66901e-03/
      DATA (KA_MCO2( 3,JT, 7),JT=1,19)  /
     & 7.49899e-05, 8.94606e-05, 1.06724e-04, 1.27318e-04, 1.51887e-04,
     & 1.81196e-04, 2.16161e-04, 2.57873e-04, 3.07635e-04, 3.66999e-04,
     & 4.37818e-04, 5.22304e-04, 6.23092e-04, 7.43330e-04, 8.86769e-04,
     & 1.05789e-03, 1.26203e-03, 1.50556e-03, 1.79608e-03/
      DATA (KA_MCO2( 4,JT, 7),JT=1,19)  /
     & 8.26801e-05, 9.85802e-05, 1.17538e-04, 1.40141e-04, 1.67092e-04,
     & 1.99225e-04, 2.37537e-04, 2.83217e-04, 3.37682e-04, 4.02621e-04,
     & 4.80048e-04, 5.72365e-04, 6.82435e-04, 8.13673e-04, 9.70148e-04,
     & 1.15671e-03, 1.37916e-03, 1.64438e-03, 1.96061e-03/
      DATA (KA_MCO2( 5,JT, 7),JT=1,19)  /
     & 9.29561e-05, 1.10845e-04, 1.32176e-04, 1.57612e-04, 1.87944e-04,
     & 2.24112e-04, 2.67241e-04, 3.18669e-04, 3.79995e-04, 4.53121e-04,
     & 5.40321e-04, 6.44302e-04, 7.68293e-04, 9.16146e-04, 1.09245e-03,
     & 1.30268e-03, 1.55338e-03, 1.85231e-03, 2.20877e-03/
      DATA (KA_MCO2( 6,JT, 7),JT=1,19)  /
     & 1.09700e-04, 1.30879e-04, 1.56148e-04, 1.86294e-04, 2.22261e-04,
     & 2.65172e-04, 3.16367e-04, 3.77446e-04, 4.50317e-04, 5.37257e-04,
     & 6.40983e-04, 7.64734e-04, 9.12376e-04, 1.08852e-03, 1.29868e-03,
     & 1.54941e-03, 1.84854e-03, 2.20543e-03, 2.63122e-03/
      DATA (KA_MCO2( 7,JT, 7),JT=1,19)  /
     & 1.43457e-04, 1.71554e-04, 2.05153e-04, 2.45332e-04, 2.93381e-04,
     & 3.50840e-04, 4.19552e-04, 5.01722e-04, 5.99985e-04, 7.17492e-04,
     & 8.58014e-04, 1.02606e-03, 1.22701e-03, 1.46732e-03, 1.75470e-03,
     & 2.09836e-03, 2.50933e-03, 3.00078e-03, 3.58849e-03/
      DATA (KA_MCO2( 8,JT, 7),JT=1,19)  /
     & 1.52152e-05, 1.89421e-05, 2.35819e-05, 2.93582e-05, 3.65494e-05,
     & 4.55021e-05, 5.66476e-05, 7.05233e-05, 8.77978e-05, 1.09304e-04,
     & 1.36077e-04, 1.69409e-04, 2.10905e-04, 2.62565e-04, 3.26880e-04,
     & 4.06948e-04, 5.06629e-04, 6.30726e-04, 7.85219e-04/
      DATA (KA_MCO2( 9,JT, 7),JT=1,19)  /
     & 1.15683e-04, 1.37544e-04, 1.63535e-04, 1.94438e-04, 2.31180e-04,
     & 2.74866e-04, 3.26807e-04, 3.88563e-04, 4.61989e-04, 5.49289e-04,
     & 6.53088e-04, 7.76501e-04, 9.23234e-04, 1.09770e-03, 1.30512e-03,
     & 1.55175e-03, 1.84498e-03, 2.19362e-03, 2.60815e-03/
      DATA (KA_MCO2( 1,JT, 8),JT=1,19)  /
     & 1.18154e-04, 1.40516e-04, 1.67111e-04, 1.98739e-04, 2.36353e-04,
     & 2.81086e-04, 3.34285e-04, 3.97553e-04, 4.72796e-04, 5.62278e-04,
     & 6.68697e-04, 7.95257e-04, 9.45770e-04, 1.12477e-03, 1.33765e-03,
     & 1.59081e-03, 1.89190e-03, 2.24996e-03, 2.67580e-03/
      DATA (KA_MCO2( 2,JT, 8),JT=1,19)  /
     & 1.40874e-04, 1.67009e-04, 1.97993e-04, 2.34726e-04, 2.78273e-04,
     & 3.29899e-04, 3.91102e-04, 4.63661e-04, 5.49680e-04, 6.51659e-04,
     & 7.72556e-04, 9.15884e-04, 1.08580e-03, 1.28724e-03, 1.52605e-03,
     & 1.80917e-03, 2.14482e-03, 2.54273e-03, 3.01446e-03/
      DATA (KA_MCO2( 3,JT, 8),JT=1,19)  /
     & 1.55092e-04, 1.84132e-04, 2.18609e-04, 2.59542e-04, 3.08140e-04,
     & 3.65837e-04, 4.34337e-04, 5.15664e-04, 6.12219e-04, 7.26853e-04,
     & 8.62952e-04, 1.02453e-03, 1.21637e-03, 1.44413e-03, 1.71453e-03,
     & 2.03557e-03, 2.41671e-03, 2.86923e-03, 3.40647e-03/
      DATA (KA_MCO2( 4,JT, 8),JT=1,19)  /
     & 1.80666e-04, 2.14521e-04, 2.54721e-04, 3.02454e-04, 3.59131e-04,
     & 4.26429e-04, 5.06339e-04, 6.01223e-04, 7.13887e-04, 8.47663e-04,
     & 1.00651e-03, 1.19512e-03, 1.41908e-03, 1.68500e-03, 2.00076e-03,
     & 2.37568e-03, 2.82087e-03, 3.34947e-03, 3.97714e-03/
      DATA (KA_MCO2( 5,JT, 8),JT=1,19)  /
     & 2.21554e-04, 2.63265e-04, 3.12829e-04, 3.71724e-04, 4.41707e-04,
     & 5.24865e-04, 6.23679e-04, 7.41096e-04, 8.80619e-04, 1.04641e-03,
     & 1.24341e-03, 1.47750e-03, 1.75567e-03, 2.08620e-03, 2.47896e-03,
     & 2.94566e-03, 3.50023e-03, 4.15920e-03, 4.94224e-03/
      DATA (KA_MCO2( 6,JT, 8),JT=1,19)  /
     & 2.78997e-04, 3.32548e-04, 3.96378e-04, 4.72460e-04, 5.63146e-04,
     & 6.71238e-04, 8.00077e-04, 9.53647e-04, 1.13669e-03, 1.35487e-03,
     & 1.61493e-03, 1.92491e-03, 2.29438e-03, 2.73477e-03, 3.25969e-03,
     & 3.88537e-03, 4.63114e-03, 5.52005e-03, 6.57958e-03/
      DATA (KA_MCO2( 7,JT, 8),JT=1,19)  /
     & 2.84939e-04, 3.40606e-04, 4.07149e-04, 4.86691e-04, 5.81774e-04,
     & 6.95432e-04, 8.31295e-04, 9.93700e-04, 1.18783e-03, 1.41989e-03,
     & 1.69729e-03, 2.02888e-03, 2.42526e-03, 2.89907e-03, 3.46544e-03,
     & 4.14246e-03, 4.95176e-03, 5.91915e-03, 7.07554e-03/
      DATA (KA_MCO2( 8,JT, 8),JT=1,19)  /
     & 5.30764e-05, 6.47812e-05, 7.90673e-05, 9.65039e-05, 1.17786e-04,
     & 1.43761e-04, 1.75464e-04, 2.14159e-04, 2.61387e-04, 3.19030e-04,
     & 3.89385e-04, 4.75255e-04, 5.80062e-04, 7.07982e-04, 8.64111e-04,
     & 1.05467e-03, 1.28726e-03, 1.57113e-03, 1.91761e-03/
      DATA (KA_MCO2( 9,JT, 8),JT=1,19)  /
     & 2.76806e-04, 3.29639e-04, 3.92556e-04, 4.67481e-04, 5.56708e-04,
     & 6.62964e-04, 7.89501e-04, 9.40190e-04, 1.11964e-03, 1.33334e-03,
     & 1.58783e-03, 1.89089e-03, 2.25180e-03, 2.68159e-03, 3.19341e-03,
     & 3.80293e-03, 4.52878e-03, 5.39316e-03, 6.42253e-03/
      DATA (KA_MCO2( 1,JT, 9),JT=1,19)  /
     & 3.30614e-04, 3.93289e-04, 4.67844e-04, 5.56534e-04, 6.62036e-04,
     & 7.87539e-04, 9.36833e-04, 1.11443e-03, 1.32569e-03, 1.57700e-03,
     & 1.87596e-03, 2.23158e-03, 2.65463e-03, 3.15787e-03, 3.75650e-03,
     & 4.46862e-03, 5.31575e-03, 6.32345e-03, 7.52219e-03/
      DATA (KA_MCO2( 2,JT, 9),JT=1,19)  /
     & 3.78453e-04, 4.50735e-04, 5.36824e-04, 6.39355e-04, 7.61469e-04,
     & 9.06906e-04, 1.08012e-03, 1.28642e-03, 1.53212e-03, 1.82475e-03,
     & 2.17326e-03, 2.58835e-03, 3.08271e-03, 3.67149e-03, 4.37273e-03,
     & 5.20790e-03, 6.20259e-03, 7.38725e-03, 8.79818e-03/
      DATA (KA_MCO2( 3,JT, 9),JT=1,19)  /
     & 4.57576e-04, 5.45512e-04, 6.50348e-04, 7.75330e-04, 9.24332e-04,
     & 1.10197e-03, 1.31374e-03, 1.56621e-03, 1.86721e-03, 2.22604e-03,
     & 2.65384e-03, 3.16385e-03, 3.77187e-03, 4.49675e-03, 5.36092e-03,
     & 6.39117e-03, 7.61942e-03, 9.08370e-03, 1.08294e-02/
      DATA (KA_MCO2( 4,JT, 9),JT=1,19)  /
     & 5.18277e-04, 6.18764e-04, 7.38735e-04, 8.81967e-04, 1.05297e-03,
     & 1.25713e-03, 1.50087e-03, 1.79187e-03, 2.13929e-03, 2.55407e-03,
     & 3.04928e-03, 3.64050e-03, 4.34635e-03, 5.18905e-03, 6.19514e-03,
     & 7.39631e-03, 8.83036e-03, 1.05425e-02, 1.25865e-02/
      DATA (KA_MCO2( 5,JT, 9),JT=1,19)  /
     & 4.45365e-04, 5.32106e-04, 6.35742e-04, 7.59563e-04, 9.07500e-04,
     & 1.08425e-03, 1.29542e-03, 1.54773e-03, 1.84917e-03, 2.20933e-03,
     & 2.63963e-03, 3.15374e-03, 3.76797e-03, 4.50184e-03, 5.37865e-03,
     & 6.42622e-03, 7.67783e-03, 9.17320e-03, 1.09598e-02/
      DATA (KA_MCO2( 6,JT, 9),JT=1,19)  /
     & 2.87301e-04, 3.43009e-04, 4.09519e-04, 4.88926e-04, 5.83730e-04,
     & 6.96916e-04, 8.32050e-04, 9.93386e-04, 1.18601e-03, 1.41597e-03,
     & 1.69053e-03, 2.01833e-03, 2.40969e-03, 2.87693e-03, 3.43478e-03,
     & 4.10079e-03, 4.89594e-03, 5.84527e-03, 6.97867e-03/
      DATA (KA_MCO2( 7,JT, 9),JT=1,19)  /
     & 1.10743e-04, 1.32286e-04, 1.58020e-04, 1.88760e-04, 2.25480e-04,
     & 2.69342e-04, 3.21738e-04, 3.84326e-04, 4.59090e-04, 5.48397e-04,
     & 6.55078e-04, 7.82511e-04, 9.34734e-04, 1.11657e-03, 1.33378e-03,
     & 1.59324e-03, 1.90318e-03, 2.27340e-03, 2.71565e-03/
      DATA (KA_MCO2( 8,JT, 9),JT=1,19)  /
     & 8.63177e-05, 1.03067e-04, 1.23066e-04, 1.46946e-04, 1.75459e-04,
     & 2.09505e-04, 2.50158e-04, 2.98698e-04, 3.56658e-04, 4.25864e-04,
     & 5.08498e-04, 6.07168e-04, 7.24982e-04, 8.65658e-04, 1.03363e-03,
     & 1.23420e-03, 1.47368e-03, 1.75963e-03, 2.10107e-03/
      DATA (KA_MCO2( 9,JT, 9),JT=1,19)  /
     & 4.52715e-04, 5.41540e-04, 6.47792e-04, 7.74892e-04, 9.26929e-04,
     & 1.10880e-03, 1.32635e-03, 1.58658e-03, 1.89787e-03, 2.27024e-03,
     & 2.71568e-03, 3.24850e-03, 3.88587e-03, 4.64830e-03, 5.56031e-03,
     & 6.65127e-03, 7.95627e-03, 9.51732e-03, 1.13847e-02/
      DATA (KA_MCO2( 1,JT,10),JT=1,19)  /
     & 9.10418e-04, 1.08631e-03, 1.29619e-03, 1.54662e-03, 1.84543e-03,
     & 2.20198e-03, 2.62741e-03, 3.13503e-03, 3.74073e-03, 4.46344e-03,
     & 5.32580e-03, 6.35476e-03, 7.58251e-03, 9.04748e-03, 1.07955e-02,
     & 1.28812e-02, 1.53699e-02, 1.83394e-02, 2.18826e-02/
      DATA (KA_MCO2( 2,JT,10),JT=1,19)  /
     & 9.06680e-04, 1.08622e-03, 1.30130e-03, 1.55898e-03, 1.86768e-03,
     & 2.23750e-03, 2.68056e-03, 3.21135e-03, 3.84724e-03, 4.60905e-03,
     & 5.52171e-03, 6.61508e-03, 7.92496e-03, 9.49421e-03, 1.13742e-02,
     & 1.36265e-02, 1.63247e-02, 1.95572e-02, 2.34298e-02/
      DATA (KA_MCO2( 3,JT,10),JT=1,19)  /
     & 8.17976e-04, 9.79458e-04, 1.17282e-03, 1.40435e-03, 1.68160e-03,
     & 2.01357e-03, 2.41108e-03, 2.88707e-03, 3.45703e-03, 4.13950e-03,
     & 4.95671e-03, 5.93525e-03, 7.10696e-03, 8.51000e-03, 1.01900e-02,
     & 1.22017e-02, 1.46105e-02, 1.74949e-02, 2.09486e-02/
      DATA (KA_MCO2( 4,JT,10),JT=1,19)  /
     & 3.70314e-04, 4.41440e-04, 5.26226e-04, 6.27298e-04, 7.47782e-04,
     & 8.91407e-04, 1.06262e-03, 1.26671e-03, 1.51001e-03, 1.80003e-03,
     & 2.14576e-03, 2.55789e-03, 3.04918e-03, 3.63483e-03, 4.33297e-03,
     & 5.16520e-03, 6.15727e-03, 7.33988e-03, 8.74963e-03/
      DATA (KA_MCO2( 5,JT,10),JT=1,19)  /
     & 1.00859e-04, 1.19692e-04, 1.42041e-04, 1.68563e-04, 2.00038e-04,
     & 2.37389e-04, 2.81715e-04, 3.34318e-04, 3.96742e-04, 4.70823e-04,
     & 5.58736e-04, 6.63065e-04, 7.86874e-04, 9.33801e-04, 1.10816e-03,
     & 1.31508e-03, 1.56064e-03, 1.85204e-03, 2.19786e-03/
      DATA (KA_MCO2( 6,JT,10),JT=1,19)  /
     & 9.24477e-05, 1.09659e-04, 1.30074e-04, 1.54290e-04, 1.83015e-04,
     & 2.17087e-04, 2.57503e-04, 3.05442e-04, 3.62307e-04, 4.29759e-04,
     & 5.09768e-04, 6.04672e-04, 7.17245e-04, 8.50776e-04, 1.00917e-03,
     & 1.19704e-03, 1.41990e-03, 1.68425e-03, 1.99780e-03/
      DATA (KA_MCO2( 7,JT,10),JT=1,19)  /
     & 8.42943e-05, 1.00044e-04, 1.18735e-04, 1.40919e-04, 1.67248e-04,
     & 1.98496e-04, 2.35582e-04, 2.79597e-04, 3.31836e-04, 3.93835e-04,
     & 4.67418e-04, 5.54748e-04, 6.58395e-04, 7.81407e-04, 9.27402e-04,
     & 1.10067e-03, 1.30632e-03, 1.55039e-03, 1.84005e-03/
      DATA (KA_MCO2( 8,JT,10),JT=1,19)  /
     & 6.86464e-05, 8.18163e-05, 9.75129e-05, 1.16221e-04, 1.38518e-04,
     & 1.65093e-04, 1.96767e-04, 2.34517e-04, 2.79509e-04, 3.33133e-04,
     & 3.97046e-04, 4.73220e-04, 5.64008e-04, 6.72214e-04, 8.01179e-04,
     & 9.54887e-04, 1.13808e-03, 1.35643e-03, 1.61666e-03/
      DATA (KA_MCO2( 9,JT,10),JT=1,19)  /
     & 1.03095e-04, 1.21985e-04, 1.44335e-04, 1.70781e-04, 2.02072e-04,
     & 2.39096e-04, 2.82904e-04, 3.34739e-04, 3.96070e-04, 4.68639e-04,
     & 5.54505e-04, 6.56103e-04, 7.76316e-04, 9.18556e-04, 1.08686e-03,
     & 1.28599e-03, 1.52162e-03, 1.80041e-03, 2.13029e-03/
      DATA (KA_MCO2( 1,JT,11),JT=1,19)  /
     & 1.01275e-03, 1.21433e-03, 1.45605e-03, 1.74587e-03, 2.09339e-03,
     & 2.51007e-03, 3.00970e-03, 3.60878e-03, 4.32711e-03, 5.18842e-03,
     & 6.22117e-03, 7.45950e-03, 8.94430e-03, 1.07247e-02, 1.28594e-02,
     & 1.54191e-02, 1.84882e-02, 2.21683e-02, 2.65809e-02/
      DATA (KA_MCO2( 2,JT,11),JT=1,19)  /
     & 1.06856e-03, 1.27885e-03, 1.53052e-03, 1.83171e-03, 2.19218e-03,
     & 2.62359e-03, 3.13990e-03, 3.75781e-03, 4.49732e-03, 5.38236e-03,
     & 6.44158e-03, 7.70924e-03, 9.22637e-03, 1.10421e-02, 1.32151e-02,
     & 1.58157e-02, 1.89281e-02, 2.26531e-02, 2.71110e-02/
      DATA (KA_MCO2( 3,JT,11),JT=1,19)  /
     & 7.34896e-04, 8.77863e-04, 1.04864e-03, 1.25265e-03, 1.49634e-03,
     & 1.78744e-03, 2.13516e-03, 2.55054e-03, 3.04672e-03, 3.63943e-03,
     & 4.34745e-03, 5.19321e-03, 6.20349e-03, 7.41032e-03, 8.85192e-03,
     & 1.05740e-02, 1.26311e-02, 1.50883e-02, 1.80236e-02/
      DATA (KA_MCO2( 4,JT,11),JT=1,19)  /
     & 5.89491e-05, 7.12560e-05, 8.61322e-05, 1.04114e-04, 1.25850e-04,
     & 1.52124e-04, 1.83883e-04, 2.22272e-04, 2.68676e-04, 3.24768e-04,
     & 3.92571e-04, 4.74528e-04, 5.73595e-04, 6.93346e-04, 8.38096e-04,
     & 1.01307e-03, 1.22457e-03, 1.48022e-03, 1.78924e-03/
      DATA (KA_MCO2( 5,JT,11),JT=1,19)  /
     & 5.32400e-05, 6.45465e-05, 7.82542e-05, 9.48731e-05, 1.15021e-04,
     & 1.39448e-04, 1.69063e-04, 2.04966e-04, 2.48495e-04, 3.01268e-04,
     & 3.65248e-04, 4.42816e-04, 5.36856e-04, 6.50868e-04, 7.89092e-04,
     & 9.56672e-04, 1.15984e-03, 1.40615e-03, 1.70478e-03/
      DATA (KA_MCO2( 6,JT,11),JT=1,19)  /
     & 5.31408e-05, 6.42409e-05, 7.76597e-05, 9.38814e-05, 1.13491e-04,
     & 1.37198e-04, 1.65856e-04, 2.00500e-04, 2.42381e-04, 2.93010e-04,
     & 3.54214e-04, 4.28203e-04, 5.17647e-04, 6.25774e-04, 7.56486e-04,
     & 9.14503e-04, 1.10553e-03, 1.33645e-03, 1.61561e-03/
      DATA (KA_MCO2( 7,JT,11),JT=1,19)  /
     & 5.24517e-05, 6.32485e-05, 7.62676e-05, 9.19667e-05, 1.10897e-04,
     & 1.33725e-04, 1.61251e-04, 1.94443e-04, 2.34467e-04, 2.82730e-04,
     & 3.40928e-04, 4.11106e-04, 4.95728e-04, 5.97770e-04, 7.20816e-04,
     & 8.69190e-04, 1.04811e-03, 1.26385e-03, 1.52400e-03/
      DATA (KA_MCO2( 8,JT,11),JT=1,19)  /
     & 5.01768e-05, 6.02217e-05, 7.22774e-05, 8.67466e-05, 1.04112e-04,
     & 1.24955e-04, 1.49969e-04, 1.79991e-04, 2.16024e-04, 2.59270e-04,
     & 3.11173e-04, 3.73467e-04, 4.48231e-04, 5.37962e-04, 6.45656e-04,
     & 7.74910e-04, 9.30039e-04, 1.11622e-03, 1.33968e-03/
      DATA (KA_MCO2( 9,JT,11),JT=1,19)  /
     & 5.46391e-05, 6.58765e-05, 7.94252e-05, 9.57603e-05, 1.15455e-04,
     & 1.39200e-04, 1.67829e-04, 2.02346e-04, 2.43962e-04, 2.94137e-04,
     & 3.54632e-04, 4.27568e-04, 5.15504e-04, 6.21526e-04, 7.49353e-04,
     & 9.03471e-04, 1.08929e-03, 1.31331e-03, 1.58342e-03/
      DATA (KA_MCO2( 1,JT,12),JT=1,19)  /
     & 1.18469e-03, 1.41755e-03, 1.69619e-03, 2.02959e-03, 2.42854e-03,
     & 2.90589e-03, 3.47708e-03, 4.16055e-03, 4.97836e-03, 5.95691e-03,
     & 7.12782e-03, 8.52889e-03, 1.02053e-02, 1.22113e-02, 1.46116e-02,
     & 1.74837e-02, 2.09204e-02, 2.50325e-02, 2.99530e-02/
      DATA (KA_MCO2( 2,JT,12),JT=1,19)  /
     & 1.09092e-03, 1.30288e-03, 1.55602e-03, 1.85834e-03, 2.21940e-03,
     & 2.65061e-03, 3.16560e-03, 3.78064e-03, 4.51519e-03, 5.39245e-03,
     & 6.44016e-03, 7.69143e-03, 9.18580e-03, 1.09705e-02, 1.31020e-02,
     & 1.56476e-02, 1.86878e-02, 2.23187e-02, 2.66550e-02/
      DATA (KA_MCO2( 3,JT,12),JT=1,19)  /
     & 3.97521e-04, 4.74103e-04, 5.65438e-04, 6.74369e-04, 8.04285e-04,
     & 9.59228e-04, 1.14402e-03, 1.36442e-03, 1.62727e-03, 1.94076e-03,
     & 2.31464e-03, 2.76055e-03, 3.29237e-03, 3.92663e-03, 4.68309e-03,
     & 5.58528e-03, 6.66128e-03, 7.94456e-03, 9.47505e-03/
      DATA (KA_MCO2( 4,JT,12),JT=1,19)  /
     & 7.18557e-05, 8.56230e-05, 1.02028e-04, 1.21576e-04, 1.44870e-04,
     & 1.72626e-04, 2.05701e-04, 2.45112e-04, 2.92075e-04, 3.48035e-04,
     & 4.14718e-04, 4.94176e-04, 5.88858e-04, 7.01682e-04, 8.36121e-04,
     & 9.96319e-04, 1.18721e-03, 1.41467e-03, 1.68572e-03/
      DATA (KA_MCO2( 5,JT,12),JT=1,19)  /
     & 7.33026e-05, 8.69077e-05, 1.03038e-04, 1.22162e-04, 1.44836e-04,
     & 1.71717e-04, 2.03588e-04, 2.41375e-04, 2.86175e-04, 3.39289e-04,
     & 4.02262e-04, 4.76923e-04, 5.65440e-04, 6.70387e-04, 7.94812e-04,
     & 9.42331e-04, 1.11723e-03, 1.32459e-03, 1.57044e-03/
      DATA (KA_MCO2( 6,JT,12),JT=1,19)  /
     & 7.44053e-05, 8.82167e-05, 1.04592e-04, 1.24007e-04, 1.47025e-04,
     & 1.74317e-04, 2.06674e-04, 2.45038e-04, 2.90523e-04, 3.44451e-04,
     & 4.08389e-04, 4.84196e-04, 5.74074e-04, 6.80637e-04, 8.06979e-04,
     & 9.56774e-04, 1.13437e-03, 1.34494e-03, 1.59459e-03/
      DATA (KA_MCO2( 7,JT,12),JT=1,19)  /
     & 7.68762e-05, 9.11305e-05, 1.08028e-04, 1.28058e-04, 1.51802e-04,
     & 1.79949e-04, 2.13315e-04, 2.52868e-04, 2.99754e-04, 3.55334e-04,
     & 4.21220e-04, 4.99322e-04, 5.91905e-04, 7.01656e-04, 8.31756e-04,
     & 9.85979e-04, 1.16880e-03, 1.38551e-03, 1.64241e-03/
      DATA (KA_MCO2( 8,JT,12),JT=1,19)  /
     & 8.45996e-05, 1.00214e-04, 1.18711e-04, 1.40622e-04, 1.66577e-04,
     & 1.97323e-04, 2.33743e-04, 2.76885e-04, 3.27991e-04, 3.88529e-04,
     & 4.60241e-04, 5.45189e-04, 6.45816e-04, 7.65016e-04, 9.06216e-04,
     & 1.07348e-03, 1.27161e-03, 1.50632e-03, 1.78434e-03/
      DATA (KA_MCO2( 9,JT,12),JT=1,19)  /
     & 7.73583e-05, 9.16767e-05, 1.08645e-04, 1.28755e-04, 1.52586e-04,
     & 1.80829e-04, 2.14299e-04, 2.53964e-04, 3.00970e-04, 3.56678e-04,
     & 4.22696e-04, 5.00934e-04, 5.93652e-04, 7.03533e-04, 8.33751e-04,
     & 9.88072e-04, 1.17096e-03, 1.38769e-03, 1.64454e-03/
      DATA (KA_MCO2( 1,JT,13),JT=1,19)  /
     & 1.20952e-03, 1.44504e-03, 1.72642e-03, 2.06260e-03, 2.46423e-03,
     & 2.94407e-03, 3.51735e-03, 4.20226e-03, 5.02053e-03, 5.99814e-03,
     & 7.16612e-03, 8.56153e-03, 1.02287e-02, 1.22204e-02, 1.46000e-02,
     & 1.74430e-02, 2.08395e-02, 2.48974e-02, 2.97455e-02/
      DATA (KA_MCO2( 2,JT,13),JT=1,19)  /
     & 8.47667e-04, 1.01027e-03, 1.20407e-03, 1.43505e-03, 1.71034e-03,
     & 2.03843e-03, 2.42946e-03, 2.89550e-03, 3.45094e-03, 4.11293e-03,
     & 4.90192e-03, 5.84225e-03, 6.96296e-03, 8.29866e-03, 9.89058e-03,
     & 1.17879e-02, 1.40492e-02, 1.67442e-02, 1.99562e-02/
      DATA (KA_MCO2( 3,JT,13),JT=1,19)  /
     & 1.45612e-04, 1.71739e-04, 2.02554e-04, 2.38897e-04, 2.81762e-04,
     & 3.32318e-04, 3.91945e-04, 4.62271e-04, 5.45215e-04, 6.43041e-04,
     & 7.58421e-04, 8.94503e-04, 1.05500e-03, 1.24430e-03, 1.46756e-03,
     & 1.73088e-03, 2.04145e-03, 2.40774e-03, 2.83975e-03/
      DATA (KA_MCO2( 4,JT,13),JT=1,19)  /
     & 1.40167e-04, 1.65266e-04, 1.94858e-04, 2.29750e-04, 2.70889e-04,
     & 3.19394e-04, 3.76585e-04, 4.44016e-04, 5.23522e-04, 6.17264e-04,
     & 7.27791e-04, 8.58110e-04, 1.01176e-03, 1.19293e-03, 1.40654e-03,
     & 1.65839e-03, 1.95534e-03, 2.30547e-03, 2.71828e-03/
      DATA (KA_MCO2( 5,JT,13),JT=1,19)  /
     & 1.37406e-04, 1.61990e-04, 1.90973e-04, 2.25141e-04, 2.65423e-04,
     & 3.12911e-04, 3.68896e-04, 4.34898e-04, 5.12709e-04, 6.04442e-04,
     & 7.12587e-04, 8.40082e-04, 9.90387e-04, 1.16758e-03, 1.37648e-03,
     & 1.62276e-03, 1.91310e-03, 2.25539e-03, 2.65892e-03/
      DATA (KA_MCO2( 6,JT,13),JT=1,19)  /
     & 1.35356e-04, 1.59577e-04, 1.88132e-04, 2.21797e-04, 2.61485e-04,
     & 3.08276e-04, 3.63440e-04, 4.28475e-04, 5.05147e-04, 5.95539e-04,
     & 7.02106e-04, 8.27743e-04, 9.75861e-04, 1.15048e-03, 1.35635e-03,
     & 1.59906e-03, 1.88520e-03, 2.22255e-03, 2.62025e-03/
      DATA (KA_MCO2( 7,JT,13),JT=1,19)  /
     & 1.33359e-04, 1.57252e-04, 1.85424e-04, 2.18645e-04, 2.57817e-04,
     & 3.04007e-04, 3.58472e-04, 4.22695e-04, 4.98425e-04, 5.87722e-04,
     & 6.93017e-04, 8.17177e-04, 9.63581e-04, 1.13621e-03, 1.33978e-03,
     & 1.57981e-03, 1.86284e-03, 2.19659e-03, 2.59012e-03/
      DATA (KA_MCO2( 8,JT,13),JT=1,19)  /
     & 1.29667e-04, 1.53001e-04, 1.80534e-04, 2.13022e-04, 2.51356e-04,
     & 2.96589e-04, 3.49961e-04, 4.12938e-04, 4.87249e-04, 5.74931e-04,
     & 6.78393e-04, 8.00473e-04, 9.44521e-04, 1.11449e-03, 1.31505e-03,
     & 1.55170e-03, 1.83094e-03, 2.16042e-03, 2.54920e-03/
      DATA (KA_MCO2( 9,JT,13),JT=1,19)  /
     & 1.37892e-04, 1.62557e-04, 1.91635e-04, 2.25914e-04, 2.66324e-04,
     & 3.13963e-04, 3.70124e-04, 4.36330e-04, 5.14379e-04, 6.06389e-04,
     & 7.14858e-04, 8.42730e-04, 9.93473e-04, 1.17118e-03, 1.38068e-03,
     & 1.62765e-03, 1.91880e-03, 2.26202e-03, 2.66665e-03/
      DATA (KA_MCO2( 1,JT,14),JT=1,19)  /
     & 1.28098e-03, 1.52939e-03, 1.82597e-03, 2.18007e-03, 2.60284e-03,
     & 3.10759e-03, 3.71022e-03, 4.42972e-03, 5.28874e-03, 6.31435e-03,
     & 7.53885e-03, 9.00081e-03, 1.07463e-02, 1.28302e-02, 1.53183e-02,
     & 1.82889e-02, 2.18355e-02, 2.60699e-02, 3.11255e-02/
      DATA (KA_MCO2( 2,JT,14),JT=1,19)  /
     & 1.27275e-04, 1.48842e-04, 1.74064e-04, 2.03561e-04, 2.38055e-04,
     & 2.78395e-04, 3.25570e-04, 3.80740e-04, 4.45259e-04, 5.20710e-04,
     & 6.08947e-04, 7.12137e-04, 8.32812e-04, 9.73937e-04, 1.13898e-03,
     & 1.33198e-03, 1.55769e-03, 1.82165e-03, 2.13034e-03/
      DATA (KA_MCO2( 3,JT,14),JT=1,19)  /
     & 1.27744e-04, 1.49255e-04, 1.74389e-04, 2.03755e-04, 2.38066e-04,
     & 2.78155e-04, 3.24995e-04, 3.79722e-04, 4.43666e-04, 5.18376e-04,
     & 6.05668e-04, 7.07660e-04, 8.26826e-04, 9.66059e-04, 1.12874e-03,
     & 1.31881e-03, 1.54089e-03, 1.80037e-03, 2.10354e-03/
      DATA (KA_MCO2( 4,JT,14),JT=1,19)  /
     & 1.28543e-04, 1.50136e-04, 1.75357e-04, 2.04814e-04, 2.39219e-04,
     & 2.79404e-04, 3.26339e-04, 3.81159e-04, 4.45188e-04, 5.19972e-04,
     & 6.07319e-04, 7.09339e-04, 8.28496e-04, 9.67670e-04, 1.13022e-03,
     & 1.32008e-03, 1.54184e-03, 1.80084e-03, 2.10335e-03/
      DATA (KA_MCO2( 5,JT,14),JT=1,19)  /
     & 1.29218e-04, 1.50897e-04, 1.76214e-04, 2.05778e-04, 2.40302e-04,
     & 2.80618e-04, 3.27698e-04, 3.82678e-04, 4.46881e-04, 5.21855e-04,
     & 6.09409e-04, 7.11652e-04, 8.31048e-04, 9.70475e-04, 1.13330e-03,
     & 1.32343e-03, 1.54547e-03, 1.80476e-03, 2.10755e-03/
      DATA (KA_MCO2( 6,JT,14),JT=1,19)  /
     & 1.30502e-04, 1.52368e-04, 1.77898e-04, 2.07706e-04, 2.42508e-04,
     & 2.83141e-04, 3.30583e-04, 3.85974e-04, 4.50646e-04, 5.26153e-04,
     & 6.14313e-04, 7.17244e-04, 8.37422e-04, 9.77736e-04, 1.14156e-03,
     & 1.33283e-03, 1.55616e-03, 1.81690e-03, 2.12133e-03/
      DATA (KA_MCO2( 7,JT,14),JT=1,19)  /
     & 1.32820e-04, 1.55041e-04, 1.80980e-04, 2.11259e-04, 2.46604e-04,
     & 2.87862e-04, 3.36022e-04, 3.92240e-04, 4.57864e-04, 5.34467e-04,
     & 6.23886e-04, 7.28265e-04, 8.50107e-04, 9.92334e-04, 1.15836e-03,
     & 1.35215e-03, 1.57838e-03, 1.84244e-03, 2.15069e-03/
      DATA (KA_MCO2( 8,JT,14),JT=1,19)  /
     & 1.40203e-04, 1.63590e-04, 1.90879e-04, 2.22720e-04, 2.59872e-04,
     & 3.03221e-04, 3.53801e-04, 4.12819e-04, 4.81681e-04, 5.62031e-04,
     & 6.55783e-04, 7.65175e-04, 8.92814e-04, 1.04174e-03, 1.21552e-03,
     & 1.41828e-03, 1.65486e-03, 1.93091e-03, 2.25301e-03/
      DATA (KA_MCO2( 9,JT,14),JT=1,19)  /
     & 1.30642e-04, 1.52513e-04, 1.78046e-04, 2.07853e-04, 2.42651e-04,
     & 2.83275e-04, 3.30699e-04, 3.86063e-04, 4.50696e-04, 5.26149e-04,
     & 6.14234e-04, 7.17066e-04, 8.37113e-04, 9.77259e-04, 1.14087e-03,
     & 1.33186e-03, 1.55484e-03, 1.81514e-03, 2.11902e-03/
      DATA (KA_MCO2( 1,JT,15),JT=1,19)  /
     & 1.37603e-03, 1.64035e-03, 1.95543e-03, 2.33105e-03, 2.77881e-03,
     & 3.31257e-03, 3.94887e-03, 4.70739e-03, 5.61162e-03, 6.68952e-03,
     & 7.97449e-03, 9.50627e-03, 1.13323e-02, 1.35091e-02, 1.61039e-02,
     & 1.91973e-02, 2.28848e-02, 2.72806e-02, 3.25208e-02/
      DATA (KA_MCO2( 2,JT,15),JT=1,19)  /
     & 1.67843e-04, 1.93707e-04, 2.23557e-04, 2.58007e-04, 2.97765e-04,
     & 3.43650e-04, 3.96606e-04, 4.57722e-04, 5.28256e-04, 6.09659e-04,
     & 7.03606e-04, 8.12031e-04, 9.37163e-04, 1.08158e-03, 1.24825e-03,
     & 1.44060e-03, 1.66259e-03, 1.91880e-03, 2.21448e-03/
      DATA (KA_MCO2( 3,JT,15),JT=1,19)  /
     & 1.67595e-04, 1.93410e-04, 2.23200e-04, 2.57579e-04, 2.97253e-04,
     & 3.43039e-04, 3.95876e-04, 4.56852e-04, 5.27220e-04, 6.08426e-04,
     & 7.02141e-04, 8.10291e-04, 9.35098e-04, 1.07913e-03, 1.24534e-03,
     & 1.43716e-03, 1.65853e-03, 1.91398e-03, 2.20879e-03/
      DATA (KA_MCO2( 4,JT,15),JT=1,19)  /
     & 1.67354e-04, 1.93130e-04, 2.22877e-04, 2.57206e-04, 2.96823e-04,
     & 3.42541e-04, 3.95301e-04, 4.56187e-04, 5.26452e-04, 6.07539e-04,
     & 7.01116e-04, 8.09106e-04, 9.33728e-04, 1.07755e-03, 1.24352e-03,
     & 1.43505e-03, 1.65608e-03, 1.91116e-03, 2.20553e-03/
      DATA (KA_MCO2( 5,JT,15),JT=1,19)  /
     & 1.67437e-04, 1.93232e-04, 2.23002e-04, 2.57358e-04, 2.97006e-04,
     & 3.42763e-04, 3.95570e-04, 4.56511e-04, 5.26842e-04, 6.08007e-04,
     & 7.01677e-04, 8.09778e-04, 9.34533e-04, 1.07851e-03, 1.24466e-03,
     & 1.43642e-03, 1.65771e-03, 1.91310e-03, 2.20783e-03/
      DATA (KA_MCO2( 6,JT,15),JT=1,19)  /
     & 1.67267e-04, 1.93027e-04, 2.22753e-04, 2.57057e-04, 2.96645e-04,
     & 3.42328e-04, 3.95047e-04, 4.55885e-04, 5.26092e-04, 6.07110e-04,
     & 7.00606e-04, 8.08500e-04, 9.33010e-04, 1.07669e-03, 1.24251e-03,
     & 1.43385e-03, 1.65467e-03, 1.90949e-03, 2.20355e-03/
      DATA (KA_MCO2( 7,JT,15),JT=1,19)  /
     & 1.67354e-04, 1.93130e-04, 2.22877e-04, 2.57206e-04, 2.96823e-04,
     & 3.42541e-04, 3.95301e-04, 4.56187e-04, 5.26452e-04, 6.07539e-04,
     & 7.01116e-04, 8.09106e-04, 9.33728e-04, 1.07755e-03, 1.24352e-03,
     & 1.43505e-03, 1.65608e-03, 1.91116e-03, 2.20553e-03/
      DATA (KA_MCO2( 8,JT,15),JT=1,19)  /
     & 1.67276e-04, 1.93038e-04, 2.22769e-04, 2.57079e-04, 2.96673e-04,
     & 3.42365e-04, 3.95094e-04, 4.55944e-04, 5.26166e-04, 6.07203e-04,
     & 7.00722e-04, 8.08643e-04, 9.33186e-04, 1.07691e-03, 1.24277e-03,
     & 1.43417e-03, 1.65506e-03, 1.90996e-03, 2.20412e-03/
      DATA (KA_MCO2( 9,JT,15),JT=1,19)  /
     & 1.67437e-04, 1.93232e-04, 2.23002e-04, 2.57358e-04, 2.97006e-04,
     & 3.42763e-04, 3.95570e-04, 4.56511e-04, 5.26842e-04, 6.08007e-04,
     & 7.01677e-04, 8.09778e-04, 9.34533e-04, 1.07851e-03, 1.24466e-03,
     & 1.43642e-03, 1.65771e-03, 1.91310e-03, 2.20783e-03/
      DATA (KA_MCO2( 1,JT,16),JT=1,19)  /
     & 1.42104e-03, 1.69791e-03, 2.02872e-03, 2.42399e-03, 2.89626e-03,
     & 3.46055e-03, 4.13478e-03, 4.94038e-03, 5.90294e-03, 7.05303e-03,
     & 8.42720e-03, 1.00691e-02, 1.20309e-02, 1.43749e-02, 1.71757e-02,
     & 2.05221e-02, 2.45205e-02, 2.92979e-02, 3.50061e-02/
      DATA (KA_MCO2( 2,JT,16),JT=1,19)  /
     & 1.63777e-04, 1.88736e-04, 2.17498e-04, 2.50643e-04, 2.88839e-04,
     & 3.32857e-04, 3.83582e-04, 4.42037e-04, 5.09401e-04, 5.87030e-04,
     & 6.76490e-04, 7.79583e-04, 8.98386e-04, 1.03530e-03, 1.19307e-03,
     & 1.37488e-03, 1.58441e-03, 1.82586e-03, 2.10411e-03/
      DATA (KA_MCO2( 3,JT,16),JT=1,19)  /
     & 1.63679e-04, 1.88621e-04, 2.17365e-04, 2.50489e-04, 2.88661e-04,
     & 3.32650e-04, 3.83342e-04, 4.41759e-04, 5.09079e-04, 5.86657e-04,
     & 6.76057e-04, 7.79080e-04, 8.97804e-04, 1.03462e-03, 1.19228e-03,
     & 1.37397e-03, 1.58335e-03, 1.82464e-03, 2.10269e-03/
      DATA (KA_MCO2( 4,JT,16),JT=1,19)  /
     & 1.63679e-04, 1.88621e-04, 2.17365e-04, 2.50489e-04, 2.88661e-04,
     & 3.32650e-04, 3.83342e-04, 4.41759e-04, 5.09079e-04, 5.86657e-04,
     & 6.76057e-04, 7.79080e-04, 8.97804e-04, 1.03462e-03, 1.19228e-03,
     & 1.37397e-03, 1.58335e-03, 1.82464e-03, 2.10269e-03/
      DATA (KA_MCO2( 5,JT,16),JT=1,19)  /
     & 1.63586e-04, 1.88513e-04, 2.17239e-04, 2.50343e-04, 2.88490e-04,
     & 3.32451e-04, 3.83111e-04, 4.41490e-04, 5.08766e-04, 5.86292e-04,
     & 6.75633e-04, 7.78588e-04, 8.97231e-04, 1.03395e-03, 1.19151e-03,
     & 1.37307e-03, 1.58231e-03, 1.82342e-03, 2.10128e-03/
      DATA (KA_MCO2( 6,JT,16),JT=1,19)  /
     & 1.63679e-04, 1.88621e-04, 2.17365e-04, 2.50489e-04, 2.88661e-04,
     & 3.32650e-04, 3.83342e-04, 4.41759e-04, 5.09079e-04, 5.86657e-04,
     & 6.76057e-04, 7.79080e-04, 8.97804e-04, 1.03462e-03, 1.19228e-03,
     & 1.37397e-03, 1.58335e-03, 1.82464e-03, 2.10269e-03/
      DATA (KA_MCO2( 7,JT,16),JT=1,19)  /
     & 1.63679e-04, 1.88621e-04, 2.17365e-04, 2.50489e-04, 2.88661e-04,
     & 3.32650e-04, 3.83342e-04, 4.41759e-04, 5.09079e-04, 5.86657e-04,
     & 6.76057e-04, 7.79080e-04, 8.97804e-04, 1.03462e-03, 1.19228e-03,
     & 1.37397e-03, 1.58335e-03, 1.82464e-03, 2.10269e-03/
      DATA (KA_MCO2( 8,JT,16),JT=1,19)  /
     & 1.63479e-04, 1.88391e-04, 2.17098e-04, 2.50180e-04, 2.88303e-04,
     & 3.32236e-04, 3.82863e-04, 4.41205e-04, 5.08437e-04, 5.85914e-04,
     & 6.75198e-04, 7.78087e-04, 8.96654e-04, 1.03329e-03, 1.19074e-03,
     & 1.37219e-03, 1.58129e-03, 1.82226e-03, 2.09994e-03/
      DATA (KA_MCO2( 9,JT,16),JT=1,19)  /
     & 1.63586e-04, 1.88513e-04, 2.17239e-04, 2.50343e-04, 2.88490e-04,
     & 3.32451e-04, 3.83111e-04, 4.41490e-04, 5.08766e-04, 5.86292e-04,
     & 6.75633e-04, 7.78588e-04, 8.97231e-04, 1.03395e-03, 1.19151e-03,
     & 1.37307e-03, 1.58231e-03, 1.82342e-03, 2.10128e-03/

C     The array KB_Mxx contains the absorption coefficient for 
C     a minor species at the 16 chosen g-values for a reference pressure
C     level above 100~ mb.   The first index refers to temperature 
C     in 7.2 degree increments.  For instance, JT = 1 refers to a 
C     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
C     runs over the g-channel (1 to 16).

      DATA (KB_MCO2(JT, 1),JT=1,19)  /
     & 3.72069e-06, 4.81866e-06, 6.24064e-06, 8.08226e-06, 1.04673e-05,
     & 1.35562e-05, 1.75567e-05, 2.27376e-05, 2.94475e-05, 3.81375e-05,
     & 4.93918e-05, 6.39674e-05, 8.28441e-05, 1.07291e-04, 1.38953e-04,
     & 1.79958e-04, 2.33064e-04, 3.01840e-04, 3.90913e-04/
      DATA (KB_MCO2(JT, 2),JT=1,19)  /
     & 8.14357e-06, 1.06031e-05, 1.38056e-05, 1.79752e-05, 2.34041e-05,
     & 3.04728e-05, 3.96763e-05, 5.16596e-05, 6.72622e-05, 8.75770e-05,
     & 1.14027e-04, 1.48467e-04, 1.93307e-04, 2.51691e-04, 3.27708e-04,
     & 4.26685e-04, 5.55555e-04, 7.23346e-04, 9.41814e-04/
      DATA (KB_MCO2(JT, 3),JT=1,19)  /
     & 1.09367e-05, 1.42063e-05, 1.84533e-05, 2.39701e-05, 3.11362e-05,
     & 4.04446e-05, 5.25358e-05, 6.82417e-05, 8.86432e-05, 1.15144e-04,
     & 1.49567e-04, 1.94281e-04, 2.52363e-04, 3.27809e-04, 4.25810e-04,
     & 5.53109e-04, 7.18466e-04, 9.33256e-04, 1.21226e-03/
      DATA (KB_MCO2(JT, 4),JT=1,19)  /
     & 1.76192e-05, 2.27752e-05, 2.94401e-05, 3.80553e-05, 4.91916e-05,
     & 6.35867e-05, 8.21944e-05, 1.06247e-04, 1.37339e-04, 1.77529e-04,
     & 2.29480e-04, 2.96635e-04, 3.83440e-04, 4.95648e-04, 6.40691e-04,
     & 8.28180e-04, 1.07054e-03, 1.38381e-03, 1.78876e-03/
      DATA (KB_MCO2(JT, 5),JT=1,19)  /
     & 3.72142e-05, 4.78603e-05, 6.15520e-05, 7.91605e-05, 1.01806e-04,
     & 1.30931e-04, 1.68387e-04, 2.16558e-04, 2.78510e-04, 3.58185e-04,
     & 4.60653e-04, 5.92435e-04, 7.61915e-04, 9.79881e-04, 1.26020e-03,
     & 1.62071e-03, 2.08436e-03, 2.68064e-03, 3.44751e-03/
      DATA (KB_MCO2(JT, 6),JT=1,19)  /
     & 7.74131e-05, 9.98876e-05, 1.28887e-04, 1.66305e-04, 2.14587e-04,
     & 2.76886e-04, 3.57272e-04, 4.60994e-04, 5.94831e-04, 7.67521e-04,
     & 9.90348e-04, 1.27787e-03, 1.64886e-03, 2.12755e-03, 2.74522e-03,
     & 3.54221e-03, 4.57059e-03, 5.89752e-03, 7.60968e-03/
      DATA (KB_MCO2(JT, 7),JT=1,19)  /
     & 1.32294e-04, 1.70977e-04, 2.20973e-04, 2.85587e-04, 3.69095e-04,
     & 4.77022e-04, 6.16507e-04, 7.96779e-04, 1.02976e-03, 1.33088e-03,
     & 1.72004e-03, 2.22299e-03, 2.87301e-03, 3.71310e-03, 4.79884e-03,
     & 6.20207e-03, 8.01561e-03, 1.03594e-02, 1.33886e-02/
      DATA (KB_MCO2(JT, 8),JT=1,19)  /
     & 3.59868e-05, 4.63611e-05, 5.97261e-05, 7.69439e-05, 9.91253e-05,
     & 1.27701e-04, 1.64515e-04, 2.11941e-04, 2.73040e-04, 3.51752e-04,
     & 4.53155e-04, 5.83790e-04, 7.52085e-04, 9.68897e-04, 1.24821e-03,
     & 1.60804e-03, 2.07161e-03, 2.66882e-03, 3.43818e-03/
      DATA (KB_MCO2(JT, 9),JT=1,19)  /
     & 5.09543e-05, 6.60510e-05, 8.56205e-05, 1.10988e-04, 1.43872e-04,
     & 1.86498e-04, 2.41753e-04, 3.13380e-04, 4.06228e-04, 5.26585e-04,
     & 6.82601e-04, 8.84842e-04, 1.14700e-03, 1.48684e-03, 1.92735e-03,
     & 2.49839e-03, 3.23861e-03, 4.19814e-03, 5.44196e-03/
      DATA (KB_MCO2(JT,10),JT=1,19)  /
     & 2.08253e-05, 2.64900e-05, 3.36954e-05, 4.28609e-05, 5.45194e-05,
     & 6.93491e-05, 8.82125e-05, 1.12207e-04, 1.42728e-04, 1.81551e-04,
     & 2.30935e-04, 2.93751e-04, 3.73653e-04, 4.75290e-04, 6.04572e-04,
     & 7.69021e-04, 9.78201e-04, 1.24428e-03, 1.58273e-03/
      DATA (KB_MCO2(JT,11),JT=1,19)  /
     & 2.08953e-05, 2.65543e-05, 3.37459e-05, 4.28852e-05, 5.44996e-05,
     & 6.92595e-05, 8.80169e-05, 1.11854e-04, 1.42147e-04, 1.80644e-04,
     & 2.29568e-04, 2.91741e-04, 3.70752e-04, 4.71161e-04, 5.98764e-04,
     & 7.60925e-04, 9.67005e-04, 1.22889e-03, 1.56171e-03/
      DATA (KB_MCO2(JT,12),JT=1,19)  /
     & 2.65295e-05, 3.36318e-05, 4.26356e-05, 5.40498e-05, 6.85198e-05,
     & 8.68636e-05, 1.10118e-04, 1.39599e-04, 1.76972e-04, 2.24350e-04,
     & 2.84412e-04, 3.60553e-04, 4.57079e-04, 5.79446e-04, 7.34572e-04,
     & 9.31230e-04, 1.18053e-03, 1.49658e-03, 1.89724e-03/
      DATA (KB_MCO2(JT,13),JT=1,19)  /
     & 3.45358e-05, 4.36743e-05, 5.52309e-05, 6.98455e-05, 8.83273e-05,
     & 1.11700e-04, 1.41256e-04, 1.78634e-04, 2.25902e-04, 2.85678e-04,
     & 3.61271e-04, 4.56867e-04, 5.77758e-04, 7.30639e-04, 9.23973e-04,
     & 1.16847e-03, 1.47765e-03, 1.86865e-03, 2.36311e-03/
      DATA (KB_MCO2(JT,14),JT=1,19)  /
     & 3.99721e-05, 5.12343e-05, 6.56698e-05, 8.41725e-05, 1.07888e-04,
     & 1.38286e-04, 1.77249e-04, 2.27190e-04, 2.91201e-04, 3.73248e-04,
     & 4.78412e-04, 6.13207e-04, 7.85980e-04, 1.00743e-03, 1.29128e-03,
     & 1.65510e-03, 2.12144e-03, 2.71916e-03, 3.48529e-03/
      DATA (KB_MCO2(JT,15),JT=1,19)  /
     & 8.51533e-06, 1.23021e-05, 1.77730e-05, 2.56767e-05, 3.70953e-05,
     & 5.35918e-05, 7.74243e-05, 1.11855e-04, 1.61598e-04, 2.33461e-04,
     & 3.37283e-04, 4.87275e-04, 7.03968e-04, 1.01703e-03, 1.46930e-03,
     & 2.12271e-03, 3.06670e-03, 4.43047e-03, 6.40072e-03/
      DATA (KB_MCO2(JT,16),JT=1,19)  /
     & 2.93050e-06, 3.65298e-06, 4.55358e-06, 5.67622e-06, 7.07564e-06,
     & 8.82006e-06, 1.09945e-05, 1.37051e-05, 1.70840e-05, 2.12959e-05,
     & 2.65461e-05, 3.30908e-05, 4.12490e-05, 5.14185e-05, 6.40952e-05,
     & 7.98972e-05, 9.95951e-05, 1.24149e-04, 1.54757e-04/

C     The array FORREF contains the coefficient of the water vapor
C     foreign-continuum (including the energy term).  The first 
C     index refers to reference temperature (296,260,224,260) and 
C     pressure (970,475,219,3 mbar) levels.  The second index 
C     runs over the g-channel (1 to 16).

      DATA (FORREF(1,IG),IG=1,16) /
     &2.0677e-07,2.0363e-07,2.0583e-07,2.0547e-07,2.0267e-07,2.0154e-07,
     &2.0190e-07,2.0103e-07,1.9869e-07,1.9663e-07,1.9701e-07,2.0103e-07,
     &2.0527e-07,2.0206e-07,2.0364e-07,2.0364e-07/
      DATA (FORREF(2,IG),IG=1,16) /
     &2.2427e-07,2.1489e-07,2.0453e-07,1.9710e-07,1.9650e-07,1.9738e-07,
     &1.9767e-07,1.9769e-07,1.9940e-07,1.9846e-07,1.9898e-07,1.9853e-07,
     &2.0000e-07,2.0517e-07,2.0482e-07,2.0482e-07/
      DATA (FORREF(3,IG),IG=1,16) /
     &2.2672e-07,2.1706e-07,2.0571e-07,1.9747e-07,1.9706e-07,1.9698e-07,
     &1.9781e-07,1.9774e-07,1.9724e-07,1.9714e-07,1.9751e-07,1.9758e-07,
     &1.9840e-07,1.9968e-07,1.9931e-07,1.9880e-07/
      DATA (FORREF(4,IG),IG=1,16) /
     &2.2191e-07,2.0899e-07,2.0265e-07,2.0101e-07,2.0034e-07,2.0021e-07,
     &1.9987e-07,1.9978e-07,1.9902e-07,1.9742e-07,1.9672e-07,1.9615e-07,
     &1.9576e-07,1.9540e-07,1.9588e-07,1.9590e-07/

C     The array SELFREF contains the coefficient of the water vapor
C     self-continuum (including the energy term).  The first index
C     refers to temperature in 7.2 degree increments.  For instance,
C     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
C     etc.  The second index runs over the g-channel (1 to 16).

      DATA (SELFREF(JT, 1),JT=1,10)  /
     & 5.18832e-02, 4.28690e-02, 3.54210e-02, 2.92670e-02, 2.41822e-02,
     & 1.99808e-02, 1.65093e-02, 1.36410e-02, 1.12710e-02, 9.31280e-03/
      DATA (SELFREF(JT, 2),JT=1,10)  /
     & 4.36030e-02, 3.78379e-02, 3.28350e-02, 2.84936e-02, 2.47262e-02,
     & 2.14569e-02, 1.86199e-02, 1.61580e-02, 1.40216e-02, 1.21677e-02/
      DATA (SELFREF(JT, 3),JT=1,10)  /
     & 4.26492e-02, 3.71443e-02, 3.23500e-02, 2.81745e-02, 2.45379e-02,
     & 2.13707e-02, 1.86124e-02, 1.62100e-02, 1.41177e-02, 1.22955e-02/
      DATA (SELFREF(JT, 4),JT=1,10)  /
     & 4.03591e-02, 3.54614e-02, 3.11580e-02, 2.73769e-02, 2.40546e-02,
     & 2.11355e-02, 1.85706e-02, 1.63170e-02, 1.43369e-02, 1.25970e-02/
      DATA (SELFREF(JT, 5),JT=1,10)  /
     & 3.94512e-02, 3.46232e-02, 3.03860e-02, 2.66674e-02, 2.34038e-02,
     & 2.05397e-02, 1.80260e-02, 1.58200e-02, 1.38839e-02, 1.21848e-02/
      DATA (SELFREF(JT, 6),JT=1,10)  /
     & 3.90567e-02, 3.40694e-02, 2.97190e-02, 2.59241e-02, 2.26138e-02,
     & 1.97261e-02, 1.72072e-02, 1.50100e-02, 1.30933e-02, 1.14214e-02/
      DATA (SELFREF(JT, 7),JT=1,10)  /
     & 3.85397e-02, 3.36462e-02, 2.93740e-02, 2.56443e-02, 2.23881e-02,
     & 1.95454e-02, 1.70636e-02, 1.48970e-02, 1.30055e-02, 1.13541e-02/
      DATA (SELFREF(JT, 8),JT=1,10)  /
     & 3.79692e-02, 3.31360e-02, 2.89180e-02, 2.52369e-02, 2.20245e-02,
     & 1.92209e-02, 1.67742e-02, 1.46390e-02, 1.27756e-02, 1.11493e-02/
      DATA (SELFREF(JT, 9),JT=1,10)  /
     & 3.68819e-02, 3.22827e-02, 2.82570e-02, 2.47333e-02, 2.16490e-02,
     & 1.89494e-02, 1.65863e-02, 1.45180e-02, 1.27076e-02, 1.11229e-02/
      DATA (SELFREF(JT,10),JT=1,10)  /
     & 3.65157e-02, 3.20121e-02, 2.80640e-02, 2.46028e-02, 2.15685e-02,
     & 1.89084e-02, 1.65764e-02, 1.45320e-02, 1.27397e-02, 1.11685e-02/
      DATA (SELFREF(JT,11),JT=1,10)  /
     & 3.59917e-02, 3.16727e-02, 2.78720e-02, 2.45274e-02, 2.15841e-02,
     & 1.89940e-02, 1.67148e-02, 1.47090e-02, 1.29439e-02, 1.13907e-02/
      DATA (SELFREF(JT,12),JT=1,10)  /
     & 3.66963e-02, 3.20483e-02, 2.79890e-02, 2.44439e-02, 2.13478e-02,
     & 1.86438e-02, 1.62824e-02, 1.42200e-02, 1.24189e-02, 1.08459e-02/
      DATA (SELFREF(JT,13),JT=1,10)  /
     & 3.66422e-02, 3.19026e-02, 2.77760e-02, 2.41832e-02, 2.10551e-02,
     & 1.83317e-02, 1.59605e-02, 1.38960e-02, 1.20986e-02, 1.05336e-02/
      DATA (SELFREF(JT,14),JT=1,10)  /
     & 3.81260e-02, 3.29322e-02, 2.84460e-02, 2.45709e-02, 2.12237e-02,
     & 1.83325e-02, 1.58352e-02, 1.36780e-02, 1.18147e-02, 1.02052e-02/
      DATA (SELFREF(JT,15),JT=1,10)  /
     & 3.51264e-02, 3.05081e-02, 2.64970e-02, 2.30133e-02, 1.99876e-02,
     & 1.73597e-02, 1.50773e-02, 1.30950e-02, 1.13733e-02, 9.87800e-03/
      DATA (SELFREF(JT,16),JT=1,10)  /
     & 3.51264e-02, 3.05081e-02, 2.64970e-02, 2.30133e-02, 1.99876e-02,
     & 1.73597e-02, 1.50773e-02, 1.30950e-02, 1.13733e-02, 9.87800e-03/
