C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB08.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.0 $
C     created:   $Date: 2002/06/03 20:38:03 $
       PARAMETER (MG=16)
       DIMENSION SELFREF(10,MG), FORREF(4,MG)
       REAL KA(5,13,MG), KB(5,13:59,MG)
       REAL KA_MCO2(19,MG), KA_MO3(19,MG), KA_MN2O(19,MG), 
     &             KB_MCO2(19,MG), KB_MN2O(19,MG)

       COMMON /HVRSN8/ HVRKG8
       COMMON /K8/ KA ,KB, FORREF, SELFREF, KA_MCO2, KA_MO3,
     &             KA_MN2O, KB_MCO2, KB_MN2O              

       CHARACTER*15 HVRKG8

       DATA HVRKG8 /'$Revision: 3.0 $'/

C     The array KA contains absorption coefs at the 16 chosen g-values 
C     for a range of pressure levels > ~100mb and temperatures.  The first
C     index in the array, JT, which runs from 1 to 5, corresponds to 
C     different temperatures.  More specifically, JT = 3 means that the 
C     data are for the corresponding TREF for this  pressure level, 
C     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
C     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
C     index, JP, runs from 1 to 13 and refers to the corresponding 
C     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
C     The third index, IG, goes from 1 to 16, and tells us which 
C     g-interval the absorption coefficients are for.

      DATA (KA(JT, 1, 1),JT=1,5) /
     &1.4664E-05,1.7114E-05,1.8876E-05,2.2301E-05,2.6622E-05/
      DATA (KA(JT, 2, 1),JT=1,5) /
     &1.0571E-05,1.1718E-05,1.4060E-05,1.7193E-05,2.1557E-05/
      DATA (KA(JT, 3, 1),JT=1,5) /
     &6.6138E-06,8.1523E-06,1.0695E-05,1.3782E-05,1.7449E-05/
      DATA (KA(JT, 4, 1),JT=1,5) /
     &5.1390E-06,7.0055E-06,9.4447E-06,1.2362E-05,1.5431E-05/
      DATA (KA(JT, 5, 1),JT=1,5) /
     &4.7765E-06,6.4140E-06,8.4242E-06,1.0772E-05,1.3788E-05/
      DATA (KA(JT, 6, 1),JT=1,5) /
     &4.4818E-06,6.1945E-06,8.3186E-06,1.0638E-05,1.3072E-05/
      DATA (KA(JT, 7, 1),JT=1,5) /
     &4.1781E-06,5.8651E-06,8.2034E-06,1.0966E-05,1.3592E-05/
      DATA (KA(JT, 8, 1),JT=1,5) /
     &4.6559E-06,6.5570E-06,8.8606E-06,1.1636E-05,1.4449E-05/
      DATA (KA(JT, 9, 1),JT=1,5) /
     &6.3964E-06,9.3461E-06,1.3202E-05,1.7140E-05,2.2124E-05/
      DATA (KA(JT,10, 1),JT=1,5) /
     &1.0453E-05,1.6266E-05,2.2571E-05,3.2675E-05,4.3832E-05/
      DATA (KA(JT,11, 1),JT=1,5) /
     &1.9225E-05,2.5219E-05,3.3439E-05,4.2567E-05,5.0999E-05/
      DATA (KA(JT,12, 1),JT=1,5) /
     &1.8581E-05,2.6464E-05,3.4892E-05,4.5782E-05,5.8008E-05/
      DATA (KA(JT,13, 1),JT=1,5) /
     &2.3252E-05,2.6601E-05,3.1497E-05,4.1728E-05,5.3564E-05/
      DATA (KA(JT, 1, 2),JT=1,5) /
     &2.4622E-05,2.2121E-05,2.5151E-05,3.1972E-05,4.1114E-05/
      DATA (KA(JT, 2, 2),JT=1,5) /
     &1.5738E-05,1.6913E-05,2.0782E-05,2.6880E-05,3.4084E-05/
      DATA (KA(JT, 3, 2),JT=1,5) /
     &9.8655E-06,1.2753E-05,1.6558E-05,2.1755E-05,2.8126E-05/
      DATA (KA(JT, 4, 2),JT=1,5) /
     &7.9265E-06,1.0229E-05,1.3524E-05,1.7603E-05,2.3192E-05/
      DATA (KA(JT, 5, 2),JT=1,5) /
     &7.0537E-06,9.6733E-06,1.2570E-05,1.6079E-05,2.0384E-05/
      DATA (KA(JT, 6, 2),JT=1,5) /
     &6.5277E-06,9.1084E-06,1.2443E-05,1.5914E-05,2.0339E-05/
      DATA (KA(JT, 7, 2),JT=1,5) /
     &7.4442E-06,1.0146E-05,1.2791E-05,1.6212E-05,2.1044E-05/
      DATA (KA(JT, 8, 2),JT=1,5) /
     &7.4223E-06,1.0854E-05,1.4643E-05,1.9376E-05,2.5625E-05/
      DATA (KA(JT, 9, 2),JT=1,5) /
     &1.4157E-05,1.8510E-05,2.5064E-05,3.4631E-05,4.4655E-05/
      DATA (KA(JT,10, 2),JT=1,5) /
     &3.4785E-05,4.4053E-05,5.4155E-05,6.0764E-05,5.9887E-05/
      DATA (KA(JT,11, 2),JT=1,5) /
     &4.4199E-05,5.6024E-05,6.6252E-05,8.3322E-05,1.0437E-04/
      DATA (KA(JT,12, 2),JT=1,5) /
     &4.8012E-05,6.2560E-05,7.6674E-05,8.6164E-05,1.0081E-04/
      DATA (KA(JT,13, 2),JT=1,5) /
     &3.9220E-05,5.8614E-05,7.6090E-05,8.9710E-05,9.6705E-05/
      DATA (KA(JT, 1, 3),JT=1,5) /
     &2.7517E-05,3.2252E-05,4.5774E-05,5.9187E-05,7.3901E-05/
      DATA (KA(JT, 2, 3),JT=1,5) /
     &1.9414E-05,2.5349E-05,3.4494E-05,4.4078E-05,5.4475E-05/
      DATA (KA(JT, 3, 3),JT=1,5) /
     &1.4431E-05,1.9862E-05,2.6815E-05,3.5045E-05,4.4510E-05/
      DATA (KA(JT, 4, 3),JT=1,5) /
     &1.1163E-05,1.5886E-05,2.1047E-05,2.7352E-05,3.5151E-05/
      DATA (KA(JT, 5, 3),JT=1,5) /
     &1.0004E-05,1.3946E-05,1.9070E-05,2.4940E-05,3.2122E-05/
      DATA (KA(JT, 6, 3),JT=1,5) /
     &9.8796E-06,1.2389E-05,1.6574E-05,2.2677E-05,2.9114E-05/
      DATA (KA(JT, 7, 3),JT=1,5) /
     &9.6705E-06,1.3203E-05,1.8009E-05,2.4248E-05,2.9926E-05/
      DATA (KA(JT, 8, 3),JT=1,5) /
     &1.2684E-05,1.5798E-05,2.0751E-05,2.7135E-05,3.4302E-05/
      DATA (KA(JT, 9, 3),JT=1,5) /
     &2.3748E-05,2.8117E-05,3.3728E-05,4.1366E-05,5.3787E-05/
      DATA (KA(JT,10, 3),JT=1,5) /
     &4.9449E-05,6.0387E-05,8.1388E-05,1.0134E-04,1.3311E-04/
      DATA (KA(JT,11, 3),JT=1,5) /
     &6.5933E-05,8.9755E-05,1.2191E-04,1.3795E-04,1.5355E-04/
      DATA (KA(JT,12, 3),JT=1,5) /
     &6.2437E-05,8.0247E-05,1.0990E-04,1.3683E-04,1.6418E-04/
      DATA (KA(JT,13, 3),JT=1,5) /
     &5.9989E-05,6.7831E-05,9.4332E-05,1.1542E-04,1.5040E-04/
      DATA (KA(JT, 1, 4),JT=1,5) /
     &3.6489E-05,5.9568E-05,7.8043E-05,9.8599E-05,1.2261E-04/
      DATA (KA(JT, 2, 4),JT=1,5) /
     &3.0751E-05,4.5700E-05,5.9720E-05,7.6230E-05,9.5698E-05/
      DATA (KA(JT, 3, 4),JT=1,5) /
     &2.6862E-05,3.6448E-05,4.6703E-05,5.7936E-05,7.1216E-05/
      DATA (KA(JT, 4, 4),JT=1,5) /
     &2.0754E-05,2.7900E-05,3.6677E-05,4.8008E-05,6.1630E-05/
      DATA (KA(JT, 5, 4),JT=1,5) /
     &1.6362E-05,2.1862E-05,2.9666E-05,3.8981E-05,5.0305E-05/
      DATA (KA(JT, 6, 4),JT=1,5) /
     &1.4991E-05,2.0957E-05,2.6223E-05,3.2254E-05,4.2632E-05/
      DATA (KA(JT, 7, 4),JT=1,5) /
     &1.3833E-05,1.9399E-05,2.5656E-05,3.2001E-05,4.1685E-05/
      DATA (KA(JT, 8, 4),JT=1,5) /
     &1.6855E-05,2.2852E-05,3.0265E-05,3.5778E-05,4.6073E-05/
      DATA (KA(JT, 9, 4),JT=1,5) /
     &3.3370E-05,4.7904E-05,5.8243E-05,6.4094E-05,7.6700E-05/
      DATA (KA(JT,10, 4),JT=1,5) /
     &6.8238E-05,1.0340E-04,1.2739E-04,1.5464E-04,1.7523E-04/
      DATA (KA(JT,11, 4),JT=1,5) /
     &6.1230E-05,9.6227E-05,1.3743E-04,1.9846E-04,2.3838E-04/
      DATA (KA(JT,12, 4),JT=1,5) /
     &6.8823E-05,1.0715E-04,1.3058E-04,1.9049E-04,2.2996E-04/
      DATA (KA(JT,13, 4),JT=1,5) /
     &6.5444E-05,1.1659E-04,1.2685E-04,1.7368E-04,2.0128E-04/
      DATA (KA(JT, 1, 5),JT=1,5) /
     &7.8999E-05,1.0665E-04,1.3776E-04,1.7432E-04,2.1687E-04/
      DATA (KA(JT, 2, 5),JT=1,5) /
     &6.1797E-05,8.3347E-05,1.0862E-04,1.3836E-04,1.7490E-04/
      DATA (KA(JT, 3, 5),JT=1,5) /
     &4.7325E-05,6.2800E-05,8.1194E-05,1.0315E-04,1.3026E-04/
      DATA (KA(JT, 4, 5),JT=1,5) /
     &3.8433E-05,5.0865E-05,6.5549E-05,8.2585E-05,1.0247E-04/
      DATA (KA(JT, 5, 5),JT=1,5) /
     &3.0177E-05,3.9082E-05,4.9288E-05,6.5674E-05,8.5494E-05/
      DATA (KA(JT, 6, 5),JT=1,5) /
     &2.4712E-05,3.2374E-05,4.1224E-05,5.5035E-05,7.0157E-05/
      DATA (KA(JT, 7, 5),JT=1,5) /
     &2.2530E-05,2.6200E-05,3.5121E-05,4.6306E-05,5.9652E-05/
      DATA (KA(JT, 8, 5),JT=1,5) /
     &2.8297E-05,3.6551E-05,4.4329E-05,5.9550E-05,7.1792E-05/
      DATA (KA(JT, 9, 5),JT=1,5) /
     &5.6002E-05,7.4631E-05,8.8607E-05,1.1720E-04,1.2997E-04/
      DATA (KA(JT,10, 5),JT=1,5) /
     &8.1020E-05,1.1580E-04,1.6197E-04,2.3825E-04,2.8441E-04/
      DATA (KA(JT,11, 5),JT=1,5) /
     &9.6146E-05,1.4644E-04,1.7805E-04,2.2438E-04,3.1753E-04/
      DATA (KA(JT,12, 5),JT=1,5) /
     &9.5441E-05,1.4982E-04,2.4222E-04,2.7134E-04,3.3168E-04/
      DATA (KA(JT,13, 5),JT=1,5) /
     &9.5058E-05,1.4349E-04,2.4835E-04,2.9526E-04,3.7011E-04/
      DATA (KA(JT, 1, 6),JT=1,5) /
     &1.5625E-04,2.0681E-04,2.6299E-04,3.2669E-04,4.0038E-04/
      DATA (KA(JT, 2, 6),JT=1,5) /
     &1.1702E-04,1.5581E-04,2.0084E-04,2.5419E-04,3.1669E-04/
      DATA (KA(JT, 3, 6),JT=1,5) /
     &8.6159E-05,1.1329E-04,1.4769E-04,1.9151E-04,2.4537E-04/
      DATA (KA(JT, 4, 6),JT=1,5) /
     &7.1655E-05,9.4348E-05,1.2251E-04,1.5312E-04,1.8840E-04/
      DATA (KA(JT, 5, 6),JT=1,5) /
     &5.9776E-05,8.0388E-05,1.0504E-04,1.3009E-04,1.5686E-04/
      DATA (KA(JT, 6, 6),JT=1,5) /
     &4.1587E-05,5.6800E-05,7.7481E-05,9.9930E-05,1.3028E-04/
      DATA (KA(JT, 7, 6),JT=1,5) /
     &3.7625E-05,5.2950E-05,6.5572E-05,8.3943E-05,1.0947E-04/
      DATA (KA(JT, 8, 6),JT=1,5) /
     &4.0934E-05,5.1706E-05,6.6726E-05,8.2858E-05,1.0389E-04/
      DATA (KA(JT, 9, 6),JT=1,5) /
     &8.3177E-05,1.0693E-04,1.2771E-04,1.5344E-04,1.9338E-04/
      DATA (KA(JT,10, 6),JT=1,5) /
     &1.2590E-04,1.6860E-04,2.4332E-04,2.8123E-04,4.3002E-04/
      DATA (KA(JT,11, 6),JT=1,5) /
     &1.5778E-04,2.1103E-04,2.9773E-04,4.5434E-04,5.2006E-04/
      DATA (KA(JT,12, 6),JT=1,5) /
     &1.7734E-04,2.3169E-04,2.6921E-04,4.5377E-04,6.4453E-04/
      DATA (KA(JT,13, 6),JT=1,5) /
     &1.7874E-04,2.2968E-04,2.8292E-04,4.5303E-04,6.1897E-04/
      DATA (KA(JT, 1, 7),JT=1,5) /
     &3.7144E-04,4.7830E-04,6.0203E-04,7.4238E-04,8.9847E-04/
      DATA (KA(JT, 2, 7),JT=1,5) /
     &2.8002E-04,3.6431E-04,4.6140E-04,5.7047E-04,6.9195E-04/
      DATA (KA(JT, 3, 7),JT=1,5) /
     &1.8338E-04,2.5018E-04,3.2929E-04,4.2096E-04,5.2583E-04/
      DATA (KA(JT, 4, 7),JT=1,5) /
     &1.3365E-04,1.7565E-04,2.2370E-04,2.9770E-04,3.9171E-04/
      DATA (KA(JT, 5, 7),JT=1,5) /
     &1.1609E-04,1.5410E-04,1.9723E-04,2.4620E-04,3.0830E-04/
      DATA (KA(JT, 6, 7),JT=1,5) /
     &1.0480E-04,1.3862E-04,1.7991E-04,2.2372E-04,2.7406E-04/
      DATA (KA(JT, 7, 7),JT=1,5) /
     &8.7767E-05,1.1689E-04,1.5270E-04,1.9631E-04,2.3773E-04/
      DATA (KA(JT, 8, 7),JT=1,5) /
     &9.8366E-05,1.1738E-04,1.4725E-04,1.8494E-04,2.3601E-04/
      DATA (KA(JT, 9, 7),JT=1,5) /
     &1.5443E-04,1.9009E-04,2.4404E-04,2.8078E-04,3.3602E-04/
      DATA (KA(JT,10, 7),JT=1,5) /
     &1.5274E-04,2.6878E-04,3.7659E-04,5.3377E-04,5.6306E-04/
      DATA (KA(JT,11, 7),JT=1,5) /
     &2.0214E-04,2.6794E-04,4.2457E-04,5.7376E-04,8.8285E-04/
      DATA (KA(JT,12, 7),JT=1,5) /
     &2.5054E-04,3.1232E-04,4.4996E-04,6.0765E-04,8.8689E-04/
      DATA (KA(JT,13, 7),JT=1,5) /
     &2.7318E-04,3.6929E-04,4.5362E-04,6.1364E-04,9.2141E-04/
      DATA (KA(JT, 1, 8),JT=1,5) /
     &1.1751E-03,1.5113E-03,1.8892E-03,2.3109E-03,2.7776E-03/
      DATA (KA(JT, 2, 8),JT=1,5) /
     &8.9844E-04,1.1675E-03,1.4748E-03,1.8223E-03,2.2105E-03/
      DATA (KA(JT, 3, 8),JT=1,5) /
     &6.3916E-04,8.4337E-04,1.0777E-03,1.3420E-03,1.6361E-03/
      DATA (KA(JT, 4, 8),JT=1,5) /
     &3.9704E-04,5.5491E-04,7.4493E-04,9.5633E-04,1.1972E-03/
      DATA (KA(JT, 5, 8),JT=1,5) /
     &2.8104E-04,3.5275E-04,4.8572E-04,6.7373E-04,9.0464E-04/
      DATA (KA(JT, 6, 8),JT=1,5) /
     &2.6538E-04,3.4221E-04,4.3816E-04,5.5889E-04,6.9563E-04/
      DATA (KA(JT, 7, 8),JT=1,5) /
     &2.6802E-04,3.3443E-04,4.3228E-04,5.4299E-04,6.7937E-04/
      DATA (KA(JT, 8, 8),JT=1,5) /
     &2.6587E-04,3.6538E-04,4.4243E-04,5.3612E-04,6.5384E-04/
      DATA (KA(JT, 9, 8),JT=1,5) /
     &3.1669E-04,4.3173E-04,5.9018E-04,7.8164E-04,9.3453E-04/
      DATA (KA(JT,10, 8),JT=1,5) /
     &2.7923E-04,3.5605E-04,4.7230E-04,7.5710E-04,1.3303E-03/
      DATA (KA(JT,11, 8),JT=1,5) /
     &3.9189E-04,4.5454E-04,6.3718E-04,5.9520E-04,8.3511E-04/
      DATA (KA(JT,12, 8),JT=1,5) /
     &2.6981E-04,5.3035E-04,6.9787E-04,8.5120E-04,7.8888E-04/
      DATA (KA(JT,13, 8),JT=1,5) /
     &2.5533E-04,5.3884E-04,7.3128E-04,1.0359E-03,9.5286E-04/
      DATA (KA(JT, 1, 9),JT=1,5) /
     &4.1658E-03,5.4654E-03,6.9658E-03,8.6722E-03,1.0572E-02/
      DATA (KA(JT, 2, 9),JT=1,5) /
     &3.6223E-03,4.7934E-03,6.1539E-03,7.6963E-03,9.3961E-03/
      DATA (KA(JT, 3, 9),JT=1,5) /
     &2.8899E-03,3.8874E-03,5.0544E-03,6.3815E-03,7.8638E-03/
      DATA (KA(JT, 4, 9),JT=1,5) /
     &2.1989E-03,3.0197E-03,3.9971E-03,5.1085E-03,6.3356E-03/
      DATA (KA(JT, 5, 9),JT=1,5) /
     &1.5192E-03,2.2278E-03,3.0194E-03,3.9009E-03,4.8746E-03/
      DATA (KA(JT, 6, 9),JT=1,5) /
     &8.7921E-04,1.3751E-03,1.9853E-03,2.7076E-03,3.5697E-03/
      DATA (KA(JT, 7, 9),JT=1,5) /
     &8.1169E-04,1.0620E-03,1.3025E-03,1.8213E-03,2.5733E-03/
      DATA (KA(JT, 8, 9),JT=1,5) /
     &8.9592E-04,1.1349E-03,1.5068E-03,1.9574E-03,2.3526E-03/
      DATA (KA(JT, 9, 9),JT=1,5) /
     &6.4937E-04,9.7395E-04,1.5824E-03,2.3319E-03,3.1640E-03/
      DATA (KA(JT,10, 9),JT=1,5) /
     &5.2173E-04,1.2542E-03,1.3511E-03,1.8295E-03,2.2102E-03/
      DATA (KA(JT,11, 9),JT=1,5) /
     &3.8299E-05,7.6837E-04,1.6073E-03,2.1707E-03,2.6859E-03/
      DATA (KA(JT,12, 9),JT=1,5) /
     &5.7389E-05,4.8395E-04,1.3815E-03,2.5956E-03,2.8856E-03/
      DATA (KA(JT,13, 9),JT=1,5) /
     &6.6437E-05,4.1020E-04,1.3561E-03,2.3769E-03,2.6400E-03/
      DATA (KA(JT, 1,10),JT=1,5) /
     &8.5531E-03,1.1311E-02,1.4946E-02,1.9199E-02,2.4070E-02/
      DATA (KA(JT, 2,10),JT=1,5) /
     &7.9512E-03,1.0579E-02,1.3947E-02,1.7937E-02,2.2682E-02/
      DATA (KA(JT, 3,10),JT=1,5) /
     &6.8586E-03,9.3196E-03,1.2459E-02,1.6108E-02,2.0278E-02/
      DATA (KA(JT, 4,10),JT=1,5) /
     &5.7104E-03,7.9133E-03,1.0642E-02,1.3936E-02,1.7830E-02/
      DATA (KA(JT, 5,10),JT=1,5) /
     &4.5965E-03,6.4891E-03,8.9433E-03,1.1923E-02,1.5372E-02/
      DATA (KA(JT, 6,10),JT=1,5) /
     &3.5770E-03,5.1433E-03,7.2049E-03,9.7750E-03,1.2529E-02/
      DATA (KA(JT, 7,10),JT=1,5) /
     &1.4544E-03,1.6129E-03,4.3574E-03,7.0808E-03,9.3333E-03/
      DATA (KA(JT, 8,10),JT=1,5) /
     &1.6681E-03,2.3313E-03,2.9075E-03,3.3382E-03,4.3787E-03/
      DATA (KA(JT, 9,10),JT=1,5) /
     &8.5765E-04,1.7252E-03,1.7039E-03,3.3311E-03,4.8997E-03/
      DATA (KA(JT,10,10),JT=1,5) /
     &2.2034E-05,3.2730E-05,2.9477E-03,2.5954E-03,5.2191E-03/
      DATA (KA(JT,11,10),JT=1,5) /
     &1.5700E-05,2.2697E-05,3.1811E-05,9.1022E-03,5.0873E-03/
      DATA (KA(JT,12,10),JT=1,5) /
     &1.1747E-05,1.7581E-05,2.4222E-05,3.4764E-05,8.4666E-03/
      DATA (KA(JT,13,10),JT=1,5) /
     &8.0435E-06,1.2386E-05,1.8547E-05,2.6164E-05,8.2788E-03/
      DATA (KA(JT, 1,11),JT=1,5) /
     &1.1747E-02,1.5703E-02,2.0198E-02,2.5614E-02,3.2111E-02/
      DATA (KA(JT, 2,11),JT=1,5) /
     &1.0674E-02,1.4371E-02,1.8733E-02,2.4132E-02,3.0707E-02/
      DATA (KA(JT, 3,11),JT=1,5) /
     &9.1890E-03,1.2390E-02,1.6367E-02,2.1591E-02,2.7893E-02/
      DATA (KA(JT, 4,11),JT=1,5) /
     &7.8825E-03,1.0755E-02,1.4391E-02,1.9071E-02,2.4702E-02/
      DATA (KA(JT, 5,11),JT=1,5) /
     &6.5907E-03,9.1636E-03,1.2468E-02,1.6782E-02,2.1901E-02/
      DATA (KA(JT, 6,11),JT=1,5) /
     &5.2625E-03,7.5549E-03,1.0521E-02,1.4321E-02,1.8906E-02/
      DATA (KA(JT, 7,11),JT=1,5) /
     &1.3421E-03,5.0016E-03,8.2742E-03,1.0825E-02,1.4096E-02/
      DATA (KA(JT, 8,11),JT=1,5) /
     &1.1288E-03,2.7904E-03,2.9048E-03,3.8915E-03,1.0764E-02/
      DATA (KA(JT, 9,11),JT=1,5) /
     &1.1212E-03,3.3992E-03,2.3130E-03,2.5518E-03,6.4495E-03/
      DATA (KA(JT,10,11),JT=1,5) /
     &2.4789E-05,3.8028E-05,7.9034E-03,4.9082E-03,4.7487E-03/
      DATA (KA(JT,11,11),JT=1,5) /
     &1.5630E-05,2.4780E-05,3.4663E-05,4.3353E-05,1.1174E-02/
      DATA (KA(JT,12,11),JT=1,5) /
     &1.2516E-05,1.8590E-05,2.5768E-05,3.2997E-05,7.6429E-03/
      DATA (KA(JT,13,11),JT=1,5) /
     &9.1474E-06,1.3280E-05,1.7796E-05,2.4600E-05,8.5245E-03/
      DATA (KA(JT, 1,12),JT=1,5) /
     &1.9137E-02,2.4205E-02,3.0237E-02,3.7229E-02,4.5273E-02/
      DATA (KA(JT, 2,12),JT=1,5) /
     &1.6304E-02,2.1414E-02,2.7665E-02,3.5151E-02,4.3535E-02/
      DATA (KA(JT, 3,12),JT=1,5) /
     &1.3446E-02,1.8468E-02,2.4699E-02,3.1802E-02,4.0159E-02/
      DATA (KA(JT, 4,12),JT=1,5) /
     &1.0988E-02,1.5565E-02,2.1262E-02,2.7914E-02,3.5968E-02/
      DATA (KA(JT, 5,12),JT=1,5) /
     &9.1659E-03,1.3233E-02,1.8175E-02,2.4059E-02,3.1596E-02/
      DATA (KA(JT, 6,12),JT=1,5) /
     &7.6758E-03,1.1199E-02,1.5520E-02,2.0906E-02,2.7754E-02/
      DATA (KA(JT, 7,12),JT=1,5) /
     &5.4756E-03,9.3901E-03,1.3292E-02,1.8129E-02,2.3738E-02/
      DATA (KA(JT, 8,12),JT=1,5) /
     &8.4306E-04,3.0332E-03,3.5332E-03,1.1602E-02,1.7968E-02/
      DATA (KA(JT, 9,12),JT=1,5) /
     &1.4946E-03,1.5749E-03,3.2158E-03,3.1867E-03,3.5737E-03/
      DATA (KA(JT,10,12),JT=1,5) /
     &2.3105E-05,3.7657E-05,5.4692E-05,1.0942E-02,7.6646E-03/
      DATA (KA(JT,11,12),JT=1,5) /
     &1.6278E-05,2.6849E-05,3.8655E-05,5.4498E-05,7.7401E-03/
      DATA (KA(JT,12,12),JT=1,5) /
     &1.1713E-05,1.9330E-05,2.9159E-05,3.9386E-05,5.6995E-05/
      DATA (KA(JT,13,12),JT=1,5) /
     &9.2970E-06,1.5197E-05,2.2881E-05,3.3051E-05,4.6248E-05/
      DATA (KA(JT, 1,13),JT=1,5) /
     &3.6366E-02,4.6887E-02,5.8513E-02,7.0986E-02,8.4117E-02/
      DATA (KA(JT, 2,13),JT=1,5) /
     &3.3990E-02,4.3857E-02,5.4708E-02,6.6354E-02,7.9156E-02/
      DATA (KA(JT, 3,13),JT=1,5) /
     &2.8482E-02,3.7147E-02,4.6806E-02,5.7889E-02,7.0408E-02/
      DATA (KA(JT, 4,13),JT=1,5) /
     &2.2450E-02,2.9975E-02,3.8835E-02,4.9297E-02,6.1450E-02/
      DATA (KA(JT, 5,13),JT=1,5) /
     &1.7322E-02,2.3874E-02,3.2063E-02,4.2032E-02,5.3868E-02/
      DATA (KA(JT, 6,13),JT=1,5) /
     &1.3022E-02,1.8695E-02,2.6114E-02,3.5380E-02,4.6717E-02/
      DATA (KA(JT, 7,13),JT=1,5) /
     &9.9635E-03,1.4798E-02,2.1337E-02,2.9901E-02,4.0578E-02/
      DATA (KA(JT, 8,13),JT=1,5) /
     &9.7470E-04,2.7616E-03,1.5907E-02,2.2415E-02,2.7492E-02/
      DATA (KA(JT, 9,13),JT=1,5) /
     &1.9362E-03,1.8145E-03,4.1737E-03,3.7651E-03,6.5913E-03/
      DATA (KA(JT,10,13),JT=1,5) /
     &2.8915E-05,4.8621E-05,6.9201E-05,8.4840E-03,1.1790E-02/
      DATA (KA(JT,11,13),JT=1,5) /
     &2.3309E-05,3.4553E-05,5.2552E-05,7.2505E-05,8.3347E-05/
      DATA (KA(JT,12,13),JT=1,5) /
     &1.5870E-05,2.3577E-05,3.4029E-05,5.3277E-05,6.5207E-05/
      DATA (KA(JT,13,13),JT=1,5) /
     &1.1931E-05,1.9929E-05,2.7393E-05,3.2822E-05,4.4265E-05/
      DATA (KA(JT, 1,14),JT=1,5) /
     &6.9682E-02,8.7076E-02,1.0644E-01,1.2772E-01,1.5052E-01/
      DATA (KA(JT, 2,14),JT=1,5) /
     &6.7443E-02,8.6048E-02,1.0697E-01,1.3011E-01,1.5516E-01/
      DATA (KA(JT, 3,14),JT=1,5) /
     &6.1305E-02,8.0158E-02,1.0175E-01,1.2582E-01,1.5220E-01/
      DATA (KA(JT, 4,14),JT=1,5) /
     &5.3357E-02,7.1652E-02,9.2935E-02,1.1706E-01,1.4376E-01/
      DATA (KA(JT, 5,14),JT=1,5) /
     &4.5060E-02,6.2229E-02,8.2609E-02,1.0608E-01,1.3238E-01/
      DATA (KA(JT, 6,14),JT=1,5) /
     &3.6438E-02,5.1966E-02,7.0824E-02,9.2958E-02,1.1819E-01/
      DATA (KA(JT, 7,14),JT=1,5) /
     &2.8491E-02,4.2112E-02,5.9112E-02,7.9508E-02,1.0325E-01/
      DATA (KA(JT, 8,14),JT=1,5) /
     &1.8236E-02,3.3304E-02,4.8438E-02,6.6896E-02,8.8683E-02/
      DATA (KA(JT, 9,14),JT=1,5) /
     &2.4537E-03,2.3453E-03,8.8067E-03,2.0762E-02,4.5513E-02/
      DATA (KA(JT,10,14),JT=1,5) /
     &1.4330E-05,1.7518E-05,3.1868E-05,4.9025E-05,3.3153E-02/
      DATA (KA(JT,11,14),JT=1,5) /
     &1.4087E-05,2.3580E-05,3.6793E-05,4.1734E-05,4.2976E-05/
      DATA (KA(JT,12,14),JT=1,5) /
     &1.3087E-05,2.2036E-05,3.4770E-05,3.7226E-05,3.8663E-05/
      DATA (KA(JT,13,14),JT=1,5) /
     &6.3004E-06,7.4647E-06,1.3256E-05,1.9422E-05,2.7358E-05/
      DATA (KA(JT, 1,15),JT=1,5) /
     &1.0457E-01,1.3337E-01,1.6543E-01,2.0044E-01,2.3788E-01/
      DATA (KA(JT, 2,15),JT=1,5) /
     &1.1420E-01,1.4734E-01,1.8451E-01,2.2524E-01,2.6907E-01/
      DATA (KA(JT, 3,15),JT=1,5) /
     &1.1631E-01,1.5291E-01,1.9437E-01,2.4033E-01,2.9013E-01/
      DATA (KA(JT, 4,15),JT=1,5) /
     &1.1302E-01,1.5183E-01,1.9657E-01,2.4665E-01,3.0148E-01/
      DATA (KA(JT, 5,15),JT=1,5) /
     &1.0669E-01,1.4681E-01,1.9375E-01,2.4698E-01,3.0586E-01/
      DATA (KA(JT, 6,15),JT=1,5) /
     &9.6727E-02,1.3681E-01,1.8458E-01,2.3961E-01,3.0104E-01/
      DATA (KA(JT, 7,15),JT=1,5) /
     &8.4990E-02,1.2388E-01,1.7124E-01,2.2660E-01,2.8964E-01/
      DATA (KA(JT, 8,15),JT=1,5) /
     &7.2581E-02,1.0932E-01,1.5506E-01,2.1052E-01,2.7593E-01/
      DATA (KA(JT, 9,15),JT=1,5) /
     &2.1552E-02,6.6962E-02,1.2166E-01,1.8985E-01,2.2620E-01/
      DATA (KA(JT,10,15),JT=1,5) /
     &8.5757E-06,7.9319E-06,7.5384E-06,5.2149E-06,3.5776E-06/
      DATA (KA(JT,11,15),JT=1,5) /
     &7.3855E-06,7.4681E-06,7.1804E-06,6.5771E-06,3.3890E-06/
      DATA (KA(JT,12,15),JT=1,5) /
     &5.9318E-06,6.7082E-06,7.4828E-06,6.0815E-06,3.2500E-06/
      DATA (KA(JT,13,15),JT=1,5) /
     &7.9734E-06,1.0467E-05,1.8551E-05,3.3018E-05,1.4396E-05/
      DATA (KA(JT, 1,16),JT=1,5) /
     &1.0940E-01,1.4000E-01,1.7421E-01,2.1173E-01,2.5214E-01/
      DATA (KA(JT, 2,16),JT=1,5) /
     &1.2207E-01,1.5824E-01,1.9908E-01,2.4418E-01,2.9310E-01/
      DATA (KA(JT, 3,16),JT=1,5) /
     &1.2803E-01,1.6941E-01,2.1687E-01,2.6992E-01,3.2810E-01/
      DATA (KA(JT, 4,16),JT=1,5) /
     &1.2912E-01,1.7512E-01,2.2885E-01,2.8989E-01,3.5760E-01/
      DATA (KA(JT, 5,16),JT=1,5) /
     &1.2782E-01,1.7809E-01,2.3798E-01,3.0717E-01,3.8500E-01/
      DATA (KA(JT, 6,16),JT=1,5) /
     &1.2288E-01,1.7665E-01,2.4226E-01,3.1945E-01,4.0769E-01/
      DATA (KA(JT, 7,16),JT=1,5) /
     &1.1601E-01,1.7265E-01,2.4356E-01,3.2874E-01,4.2783E-01/
      DATA (KA(JT, 8,16),JT=1,5) /
     &1.0802E-01,1.6690E-01,2.4265E-01,3.3582E-01,4.4617E-01/
      DATA (KA(JT, 9,16),JT=1,5) /
     &9.8584E-02,1.5878E-01,2.3864E-01,3.3924E-01,4.6085E-01/
      DATA (KA(JT,10,16),JT=1,5) /
     &2.5370E-06,3.6996E-06,5.1180E-06,9.0911E-06,1.0521E-05/
      DATA (KA(JT,11,16),JT=1,5) /
     &2.1410E-06,3.1393E-06,2.7559E-06,9.6933E-06,1.1052E-05/
      DATA (KA(JT,12,16),JT=1,5) /
     &1.7911E-06,2.0648E-06,1.9476E-06,1.0250E-05,1.1569E-05/
      DATA (KA(JT,13,16),JT=1,5) /
     &6.8424E-07,2.1307E-05,3.0235E-05,1.0419E-05,1.1877E-05/

C     The array KB contains absorption coefs at the 16 chosen g-values 
C     for a range of pressure levels < ~100mb and temperatures. The first 
C     index in the array, JT, which runs from 1 to 5, corresponds to 
C     different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this pressure 
C     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
C     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
C     The second index, JP, runs from 13 to 59 and refers to the JPth
C     reference pressure level (see taumol.f for the value of these
C     pressure levels in mb).  The third index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA (KB(JT,13, 1),JT=1,5) /
     &2.1590E-02,2.2747E-02,2.3755E-02,2.4762E-02,2.5739E-02/
      DATA (KB(JT,14, 1),JT=1,5) /
     &1.5891E-02,1.6865E-02,1.7785E-02,1.8588E-02,1.9375E-02/
      DATA (KB(JT,15, 1),JT=1,5) /
     &1.2008E-02,1.2891E-02,1.3700E-02,1.4369E-02,1.4970E-02/
      DATA (KB(JT,16, 1),JT=1,5) /
     &9.5594E-03,1.0266E-02,1.0893E-02,1.1429E-02,1.1863E-02/
      DATA (KB(JT,17, 1),JT=1,5) /
     &7.6979E-03,8.2617E-03,8.7527E-03,9.1620E-03,9.5161E-03/
      DATA (KB(JT,18, 1),JT=1,5) /
     &6.2689E-03,6.7130E-03,7.1029E-03,7.4199E-03,7.7032E-03/
      DATA (KB(JT,19, 1),JT=1,5) /
     &5.1124E-03,5.4669E-03,5.7636E-03,6.0175E-03,6.2439E-03/
      DATA (KB(JT,20, 1),JT=1,5) /
     &4.2074E-03,4.4879E-03,4.7226E-03,4.9240E-03,5.1066E-03/
      DATA (KB(JT,21, 1),JT=1,5) /
     &3.4689E-03,3.6905E-03,3.8771E-03,4.0402E-03,4.1874E-03/
      DATA (KB(JT,22, 1),JT=1,5) /
     &2.8675E-03,3.0422E-03,3.1923E-03,3.3247E-03,3.4419E-03/
      DATA (KB(JT,23, 1),JT=1,5) /
     &2.3673E-03,2.5068E-03,2.6269E-03,2.7338E-03,2.8272E-03/
      DATA (KB(JT,24, 1),JT=1,5) /
     &1.9512E-03,2.0620E-03,2.1580E-03,2.2436E-03,2.3178E-03/
      DATA (KB(JT,25, 1),JT=1,5) /
     &1.6104E-03,1.6991E-03,1.7756E-03,1.8445E-03,1.9031E-03/
      DATA (KB(JT,26, 1),JT=1,5) /
     &1.3324E-03,1.4030E-03,1.4641E-03,1.5181E-03,1.5647E-03/
      DATA (KB(JT,27, 1),JT=1,5) /
     &1.1030E-03,1.1588E-03,1.2079E-03,1.2506E-03,1.2885E-03/
      DATA (KB(JT,28, 1),JT=1,5) /
     &9.1277E-04,9.5694E-04,9.9621E-04,1.0308E-03,1.0603E-03/
      DATA (KB(JT,29, 1),JT=1,5) /
     &7.5709E-04,7.9257E-04,8.2415E-04,8.5205E-04,8.7500E-04/
      DATA (KB(JT,30, 1),JT=1,5) /
     &6.2805E-04,6.5667E-04,6.8205E-04,7.0403E-04,7.2224E-04/
      DATA (KB(JT,31, 1),JT=1,5) /
     &5.2190E-04,5.4469E-04,5.6521E-04,5.8274E-04,5.9713E-04/
      DATA (KB(JT,32, 1),JT=1,5) /
     &4.3349E-04,4.5214E-04,4.6842E-04,4.8237E-04,4.9367E-04/
      DATA (KB(JT,33, 1),JT=1,5) /
     &3.5999E-04,3.7522E-04,3.8828E-04,3.9917E-04,4.0831E-04/
      DATA (KB(JT,34, 1),JT=1,5) /
     &2.9885E-04,3.1108E-04,3.2123E-04,3.3020E-04,3.3735E-04/
      DATA (KB(JT,35, 1),JT=1,5) /
     &2.4686E-04,2.5649E-04,2.6489E-04,2.7217E-04,2.7798E-04/
      DATA (KB(JT,36, 1),JT=1,5) /
     &2.0249E-04,2.1050E-04,2.1752E-04,2.2349E-04,2.2845E-04/
      DATA (KB(JT,37, 1),JT=1,5) /
     &1.6556E-04,1.7221E-04,1.7821E-04,1.8323E-04,1.8756E-04/
      DATA (KB(JT,38, 1),JT=1,5) /
     &1.3530E-04,1.4093E-04,1.4599E-04,1.5028E-04,1.5406E-04/
      DATA (KB(JT,39, 1),JT=1,5) /
     &1.1062E-04,1.1539E-04,1.1961E-04,1.2331E-04,1.2663E-04/
      DATA (KB(JT,40, 1),JT=1,5) /
     &8.9884E-05,9.3980E-05,9.7546E-05,1.0075E-04,1.0361E-04/
      DATA (KB(JT,41, 1),JT=1,5) /
     &7.2964E-05,7.6433E-05,7.9468E-05,8.2219E-05,8.4723E-05/
      DATA (KB(JT,42, 1),JT=1,5) /
     &5.9182E-05,6.2146E-05,6.4721E-05,6.7085E-05,6.9267E-05/
      DATA (KB(JT,43, 1),JT=1,5) /
     &4.7864E-05,5.0382E-05,5.2591E-05,5.4634E-05,5.6528E-05/
      DATA (KB(JT,44, 1),JT=1,5) /
     &3.8628E-05,4.0783E-05,4.2701E-05,4.4436E-05,4.6114E-05/
      DATA (KB(JT,45, 1),JT=1,5) /
     &3.1127E-05,3.3002E-05,3.4654E-05,3.6151E-05,3.7566E-05/
      DATA (KB(JT,46, 1),JT=1,5) /
     &2.5026E-05,2.6649E-05,2.8068E-05,2.9367E-05,3.0563E-05/
      DATA (KB(JT,47, 1),JT=1,5) /
     &2.0040E-05,2.1423E-05,2.2656E-05,2.3781E-05,2.4816E-05/
      DATA (KB(JT,48, 1),JT=1,5) /
     &1.6036E-05,1.7209E-05,1.8283E-05,1.9267E-05,2.0138E-05/
      DATA (KB(JT,49, 1),JT=1,5) /
     &1.2828E-05,1.3830E-05,1.4752E-05,1.5602E-05,1.6354E-05/
      DATA (KB(JT,50, 1),JT=1,5) /
     &1.0257E-05,1.1106E-05,1.1884E-05,1.2616E-05,1.3265E-05/
      DATA (KB(JT,51, 1),JT=1,5) /
     &8.1934E-06,8.9110E-06,9.5669E-06,1.0186E-05,1.0748E-05/
      DATA (KB(JT,52, 1),JT=1,5) /
     &6.5467E-06,7.1424E-06,7.7065E-06,8.2286E-06,8.7123E-06/
      DATA (KB(JT,53, 1),JT=1,5) /
     &5.2332E-06,5.7328E-06,6.2119E-06,6.6510E-06,7.0700E-06/
      DATA (KB(JT,54, 1),JT=1,5) /
     &4.1577E-06,4.5779E-06,4.9804E-06,5.3498E-06,5.7020E-06/
      DATA (KB(JT,55, 1),JT=1,5) /
     &3.2878E-06,3.6403E-06,3.9741E-06,4.2805E-06,4.5760E-06/
      DATA (KB(JT,56, 1),JT=1,5) /
     &2.5965E-06,2.8911E-06,3.1663E-06,3.4265E-06,3.6666E-06/
      DATA (KB(JT,57, 1),JT=1,5) /
     &2.0466E-06,2.2908E-06,2.5217E-06,2.7403E-06,2.9373E-06/
      DATA (KB(JT,58, 1),JT=1,5) /
     &1.6093E-06,1.8128E-06,2.0059E-06,2.1882E-06,2.3529E-06/
      DATA (KB(JT,59, 1),JT=1,5) /
     &1.2776E-06,1.4459E-06,1.6042E-06,1.7524E-06,1.8906E-06/
      DATA (KB(JT,13, 2),JT=1,5) /
     &3.8014E-02,3.9737E-02,4.1825E-02,4.3879E-02,4.5802E-02/
      DATA (KB(JT,14, 2),JT=1,5) /
     &3.0759E-02,3.2195E-02,3.3860E-02,3.5735E-02,3.7445E-02/
      DATA (KB(JT,15, 2),JT=1,5) /
     &2.4737E-02,2.6065E-02,2.7499E-02,2.8985E-02,3.0345E-02/
      DATA (KB(JT,16, 2),JT=1,5) /
     &2.0386E-02,2.1604E-02,2.2870E-02,2.4062E-02,2.5169E-02/
      DATA (KB(JT,17, 2),JT=1,5) /
     &1.6973E-02,1.8030E-02,1.9046E-02,1.9999E-02,2.0836E-02/
      DATA (KB(JT,18, 2),JT=1,5) /
     &1.4179E-02,1.5045E-02,1.5843E-02,1.6598E-02,1.7207E-02/
      DATA (KB(JT,19, 2),JT=1,5) /
     &1.1784E-02,1.2488E-02,1.3131E-02,1.3688E-02,1.4139E-02/
      DATA (KB(JT,20, 2),JT=1,5) /
     &9.8208E-03,1.0377E-02,1.0872E-02,1.1296E-02,1.1641E-02/
      DATA (KB(JT,21, 2),JT=1,5) /
     &8.1632E-03,8.5996E-03,8.9808E-03,9.3040E-03,9.5696E-03/
      DATA (KB(JT,22, 2),JT=1,5) /
     &6.7970E-03,7.1290E-03,7.4204E-03,7.6665E-03,7.8692E-03/
      DATA (KB(JT,23, 2),JT=1,5) /
     &5.6384E-03,5.8917E-03,6.1228E-03,6.3098E-03,6.4698E-03/
      DATA (KB(JT,24, 2),JT=1,5) /
     &4.6602E-03,4.8595E-03,5.0396E-03,5.1884E-03,5.3131E-03/
      DATA (KB(JT,25, 2),JT=1,5) /
     &3.8492E-03,4.0101E-03,4.1507E-03,4.2656E-03,4.3666E-03/
      DATA (KB(JT,26, 2),JT=1,5) /
     &3.1817E-03,3.3089E-03,3.4202E-03,3.5130E-03,3.5943E-03/
      DATA (KB(JT,27, 2),JT=1,5) /
     &2.6312E-03,2.7340E-03,2.8215E-03,2.8952E-03,2.9585E-03/
      DATA (KB(JT,28, 2),JT=1,5) /
     &2.1766E-03,2.2592E-03,2.3277E-03,2.3874E-03,2.4369E-03/
      DATA (KB(JT,29, 2),JT=1,5) /
     &1.8050E-03,1.8690E-03,1.9243E-03,1.9721E-03,2.0134E-03/
      DATA (KB(JT,30, 2),JT=1,5) /
     &1.4965E-03,1.5474E-03,1.5922E-03,1.6307E-03,1.6644E-03/
      DATA (KB(JT,31, 2),JT=1,5) /
     &1.2416E-03,1.2835E-03,1.3200E-03,1.3519E-03,1.3783E-03/
      DATA (KB(JT,32, 2),JT=1,5) /
     &1.0308E-03,1.0652E-03,1.0950E-03,1.1207E-03,1.1427E-03/
      DATA (KB(JT,33, 2),JT=1,5) /
     &8.5698E-04,8.8430E-04,9.0863E-04,9.2966E-04,9.4803E-04/
      DATA (KB(JT,34, 2),JT=1,5) /
     &7.1109E-04,7.3332E-04,7.5331E-04,7.7074E-04,7.8601E-04/
      DATA (KB(JT,35, 2),JT=1,5) /
     &5.8729E-04,6.0603E-04,6.2268E-04,6.3737E-04,6.5045E-04/
      DATA (KB(JT,36, 2),JT=1,5) /
     &4.8310E-04,4.9861E-04,5.1251E-04,5.2508E-04,5.3615E-04/
      DATA (KB(JT,37, 2),JT=1,5) /
     &3.9625E-04,4.0955E-04,4.2151E-04,4.3225E-04,4.4172E-04/
      DATA (KB(JT,38, 2),JT=1,5) /
     &3.2503E-04,3.3643E-04,3.4664E-04,3.5587E-04,3.6445E-04/
      DATA (KB(JT,39, 2),JT=1,5) /
     &2.6664E-04,2.7639E-04,2.8514E-04,2.9332E-04,3.0098E-04/
      DATA (KB(JT,40, 2),JT=1,5) /
     &2.1759E-04,2.2608E-04,2.3348E-04,2.4050E-04,2.4712E-04/
      DATA (KB(JT,41, 2),JT=1,5) /
     &1.7739E-04,1.8462E-04,1.9097E-04,1.9703E-04,2.0268E-04/
      DATA (KB(JT,42, 2),JT=1,5) /
     &1.4453E-04,1.5070E-04,1.5612E-04,1.6130E-04,1.6626E-04/
      DATA (KB(JT,43, 2),JT=1,5) /
     &1.1750E-04,1.2276E-04,1.2736E-04,1.3185E-04,1.3616E-04/
      DATA (KB(JT,44, 2),JT=1,5) /
     &9.5367E-05,9.9857E-05,1.0380E-04,1.0768E-04,1.1140E-04/
      DATA (KB(JT,45, 2),JT=1,5) /
     &7.7428E-05,8.1152E-05,8.4582E-05,8.7898E-05,9.1175E-05/
      DATA (KB(JT,46, 2),JT=1,5) /
     &6.2722E-05,6.5854E-05,6.8828E-05,7.1656E-05,7.4494E-05/
      DATA (KB(JT,47, 2),JT=1,5) /
     &5.0620E-05,5.3291E-05,5.5834E-05,5.8234E-05,6.0703E-05/
      DATA (KB(JT,48, 2),JT=1,5) /
     &4.0839E-05,4.3112E-05,4.5285E-05,4.7326E-05,4.9468E-05/
      DATA (KB(JT,49, 2),JT=1,5) /
     &3.2956E-05,3.4871E-05,3.6734E-05,3.8477E-05,4.0339E-05/
      DATA (KB(JT,50, 2),JT=1,5) /
     &2.6578E-05,2.8186E-05,2.9765E-05,3.1246E-05,3.2810E-05/
      DATA (KB(JT,51, 2),JT=1,5) /
     &2.1419E-05,2.2753E-05,2.4086E-05,2.5342E-05,2.6653E-05/
      DATA (KB(JT,52, 2),JT=1,5) /
     &1.7265E-05,1.8376E-05,1.9492E-05,2.0556E-05,2.1651E-05/
      DATA (KB(JT,53, 2),JT=1,5) /
     &1.3928E-05,1.4844E-05,1.5782E-05,1.6689E-05,1.7614E-05/
      DATA (KB(JT,54, 2),JT=1,5) /
     &1.1205E-05,1.1963E-05,1.2726E-05,1.3478E-05,1.4240E-05/
      DATA (KB(JT,55, 2),JT=1,5) /
     &8.9889E-06,9.6190E-06,1.0235E-05,1.0868E-05,1.1479E-05/
      DATA (KB(JT,56, 2),JT=1,5) /
     &7.2032E-06,7.7304E-06,8.2333E-06,8.7486E-06,9.2547E-06/
      DATA (KB(JT,57, 2),JT=1,5) /
     &5.7621E-06,6.2097E-06,6.6195E-06,7.0372E-06,7.4615E-06/
      DATA (KB(JT,58, 2),JT=1,5) /
     &4.6073E-06,4.9865E-06,5.3240E-06,5.6615E-06,6.0083E-06/
      DATA (KB(JT,59, 2),JT=1,5) /
     &3.7094E-06,4.0178E-06,4.3021E-06,4.5755E-06,4.8477E-06/
      DATA (KB(JT,13, 3),JT=1,5) /
     &6.3405E-02,6.5846E-02,6.7902E-02,7.0344E-02,7.3087E-02/
      DATA (KB(JT,14, 3),JT=1,5) /
     &5.1252E-02,5.3361E-02,5.5658E-02,5.8048E-02,6.0738E-02/
      DATA (KB(JT,15, 3),JT=1,5) /
     &4.2340E-02,4.4418E-02,4.6657E-02,4.8923E-02,5.1338E-02/
      DATA (KB(JT,16, 3),JT=1,5) /
     &3.5507E-02,3.7339E-02,3.9465E-02,4.1652E-02,4.3669E-02/
      DATA (KB(JT,17, 3),JT=1,5) /
     &2.9824E-02,3.1523E-02,3.3435E-02,3.5273E-02,3.6953E-02/
      DATA (KB(JT,18, 3),JT=1,5) /
     &2.5125E-02,2.6683E-02,2.8323E-02,2.9797E-02,3.1126E-02/
      DATA (KB(JT,19, 3),JT=1,5) /
     &2.1223E-02,2.2544E-02,2.3820E-02,2.4985E-02,2.5990E-02/
      DATA (KB(JT,20, 3),JT=1,5) /
     &1.7915E-02,1.8986E-02,1.9994E-02,2.0861E-02,2.1602E-02/
      DATA (KB(JT,21, 3),JT=1,5) /
     &1.5062E-02,1.5916E-02,1.6665E-02,1.7312E-02,1.7872E-02/
      DATA (KB(JT,22, 3),JT=1,5) /
     &1.2635E-02,1.3292E-02,1.3846E-02,1.4329E-02,1.4769E-02/
      DATA (KB(JT,23, 3),JT=1,5) /
     &1.0554E-02,1.1051E-02,1.1464E-02,1.1841E-02,1.2180E-02/
      DATA (KB(JT,24, 3),JT=1,5) /
     &8.7770E-03,9.1488E-03,9.4668E-03,9.7625E-03,1.0031E-02/
      DATA (KB(JT,25, 3),JT=1,5) /
     &7.2756E-03,7.5544E-03,7.8035E-03,8.0431E-03,8.2495E-03/
      DATA (KB(JT,26, 3),JT=1,5) /
     &6.0226E-03,6.2378E-03,6.4382E-03,6.6253E-03,6.7857E-03/
      DATA (KB(JT,27, 3),JT=1,5) /
     &4.9811E-03,5.1501E-03,5.3115E-03,5.4587E-03,5.5851E-03/
      DATA (KB(JT,28, 3),JT=1,5) /
     &4.1172E-03,4.2566E-03,4.3852E-03,4.4995E-03,4.6022E-03/
      DATA (KB(JT,29, 3),JT=1,5) /
     &3.4101E-03,3.5232E-03,3.6273E-03,3.7181E-03,3.8009E-03/
      DATA (KB(JT,30, 3),JT=1,5) /
     &2.8248E-03,2.9164E-03,2.9992E-03,3.0754E-03,3.1419E-03/
      DATA (KB(JT,31, 3),JT=1,5) /
     &2.3450E-03,2.4195E-03,2.4879E-03,2.5493E-03,2.6070E-03/
      DATA (KB(JT,32, 3),JT=1,5) /
     &1.9491E-03,2.0095E-03,2.0670E-03,2.1190E-03,2.1683E-03/
      DATA (KB(JT,33, 3),JT=1,5) /
     &1.6195E-03,1.6713E-03,1.7189E-03,1.7649E-03,1.8032E-03/
      DATA (KB(JT,34, 3),JT=1,5) /
     &1.3454E-03,1.3883E-03,1.4290E-03,1.4663E-03,1.4976E-03/
      DATA (KB(JT,35, 3),JT=1,5) /
     &1.1151E-03,1.1504E-03,1.1846E-03,1.2147E-03,1.2425E-03/
      DATA (KB(JT,36, 3),JT=1,5) /
     &9.1872E-04,9.4904E-04,9.7800E-04,1.0033E-03,1.0278E-03/
      DATA (KB(JT,37, 3),JT=1,5) /
     &7.5556E-04,7.8161E-04,8.0630E-04,8.2845E-04,8.4914E-04/
      DATA (KB(JT,38, 3),JT=1,5) /
     &6.2192E-04,6.4458E-04,6.6572E-04,6.8474E-04,7.0313E-04/
      DATA (KB(JT,39, 3),JT=1,5) /
     &5.1238E-04,5.3172E-04,5.4973E-04,5.6636E-04,5.8235E-04/
      DATA (KB(JT,40, 3),JT=1,5) /
     &4.1982E-04,4.3621E-04,4.5139E-04,4.6596E-04,4.7961E-04/
      DATA (KB(JT,41, 3),JT=1,5) /
     &3.4388E-04,3.5746E-04,3.7054E-04,3.8291E-04,3.9470E-04/
      DATA (KB(JT,42, 3),JT=1,5) /
     &2.8144E-04,2.9295E-04,3.0424E-04,3.1457E-04,3.2459E-04/
      DATA (KB(JT,43, 3),JT=1,5) /
     &2.2990E-04,2.3955E-04,2.4928E-04,2.5827E-04,2.6672E-04/
      DATA (KB(JT,44, 3),JT=1,5) /
     &1.8744E-04,1.9582E-04,2.0413E-04,2.1176E-04,2.1912E-04/
      DATA (KB(JT,45, 3),JT=1,5) /
     &1.5285E-04,1.6000E-04,1.6711E-04,1.7363E-04,1.7993E-04/
      DATA (KB(JT,46, 3),JT=1,5) /
     &1.2448E-04,1.3059E-04,1.3656E-04,1.4216E-04,1.4758E-04/
      DATA (KB(JT,47, 3),JT=1,5) /
     &1.0103E-04,1.0628E-04,1.1130E-04,1.1611E-04,1.2074E-04/
      DATA (KB(JT,48, 3),JT=1,5) /
     &8.1983E-05,8.6504E-05,9.0728E-05,9.4862E-05,9.8826E-05/
      DATA (KB(JT,49, 3),JT=1,5) /
     &6.6563E-05,7.0429E-05,7.4014E-05,7.7542E-05,8.0976E-05/
      DATA (KB(JT,50, 3),JT=1,5) /
     &5.3952E-05,5.7235E-05,6.0247E-05,6.3258E-05,6.6182E-05/
      DATA (KB(JT,51, 3),JT=1,5) /
     &4.3663E-05,4.6470E-05,4.9001E-05,5.1519E-05,5.4013E-05/
      DATA (KB(JT,52, 3),JT=1,5) /
     &3.5323E-05,3.7705E-05,3.9846E-05,4.1973E-05,4.4086E-05/
      DATA (KB(JT,53, 3),JT=1,5) /
     &2.8583E-05,3.0614E-05,3.2428E-05,3.4214E-05,3.6024E-05/
      DATA (KB(JT,54, 3),JT=1,5) /
     &2.3052E-05,2.4741E-05,2.6291E-05,2.7754E-05,2.9233E-05/
      DATA (KB(JT,55, 3),JT=1,5) /
     &1.8532E-05,1.9924E-05,2.1226E-05,2.2443E-05,2.3644E-05/
      DATA (KB(JT,56, 3),JT=1,5) /
     &1.4892E-05,1.6026E-05,1.7132E-05,1.8148E-05,1.9127E-05/
      DATA (KB(JT,57, 3),JT=1,5) /
     &1.1957E-05,1.2880E-05,1.3809E-05,1.4669E-05,1.5458E-05/
      DATA (KB(JT,58, 3),JT=1,5) /
     &9.6000E-06,1.0349E-05,1.1127E-05,1.1847E-05,1.2497E-05/
      DATA (KB(JT,59, 3),JT=1,5) /
     &7.7452E-06,8.3627E-06,8.9895E-06,9.5703E-06,1.0120E-05/
      DATA (KB(JT,13, 4),JT=1,5) /
     &9.9915E-02,1.0385E-01,1.0749E-01,1.1095E-01,1.1480E-01/
      DATA (KB(JT,14, 4),JT=1,5) /
     &8.4174E-02,8.7314E-02,9.0833E-02,9.4040E-02,9.7483E-02/
      DATA (KB(JT,15, 4),JT=1,5) /
     &7.1798E-02,7.3772E-02,7.6218E-02,7.9303E-02,8.2911E-02/
      DATA (KB(JT,16, 4),JT=1,5) /
     &6.0987E-02,6.2861E-02,6.5027E-02,6.7869E-02,7.1492E-02/
      DATA (KB(JT,17, 4),JT=1,5) /
     &5.1988E-02,5.3759E-02,5.5853E-02,5.8672E-02,6.1980E-02/
      DATA (KB(JT,18, 4),JT=1,5) /
     &4.4171E-02,4.5935E-02,4.8095E-02,5.0759E-02,5.3616E-02/
      DATA (KB(JT,19, 4),JT=1,5) /
     &3.7411E-02,3.9215E-02,4.1337E-02,4.3631E-02,4.5910E-02/
      DATA (KB(JT,20, 4),JT=1,5) /
     &3.1780E-02,3.3510E-02,3.5386E-02,3.7312E-02,3.9095E-02/
      DATA (KB(JT,21, 4),JT=1,5) /
     &2.6954E-02,2.8513E-02,3.0099E-02,3.1617E-02,3.2915E-02/
      DATA (KB(JT,22, 4),JT=1,5) /
     &2.2888E-02,2.4194E-02,2.5477E-02,2.6596E-02,2.7511E-02/
      DATA (KB(JT,23, 4),JT=1,5) /
     &1.9346E-02,2.0404E-02,2.1382E-02,2.2165E-02,2.2830E-02/
      DATA (KB(JT,24, 4),JT=1,5) /
     &1.6247E-02,1.7083E-02,1.7781E-02,1.8353E-02,1.8851E-02/
      DATA (KB(JT,25, 4),JT=1,5) /
     &1.3597E-02,1.4221E-02,1.4742E-02,1.5163E-02,1.5551E-02/
      DATA (KB(JT,26, 4),JT=1,5) /
     &1.1347E-02,1.1808E-02,1.2193E-02,1.2519E-02,1.2827E-02/
      DATA (KB(JT,27, 4),JT=1,5) /
     &9.4352E-03,9.7820E-03,1.0071E-02,1.0331E-02,1.0583E-02/
      DATA (KB(JT,28, 4),JT=1,5) /
     &7.8281E-03,8.0857E-03,8.3110E-03,8.5276E-03,8.7304E-03/
      DATA (KB(JT,29, 4),JT=1,5) /
     &6.4877E-03,6.6881E-03,6.8753E-03,7.0489E-03,7.2105E-03/
      DATA (KB(JT,30, 4),JT=1,5) /
     &5.3741E-03,5.5372E-03,5.6910E-03,5.8358E-03,5.9652E-03/
      DATA (KB(JT,31, 4),JT=1,5) /
     &4.4624E-03,4.5974E-03,4.7269E-03,4.8416E-03,4.9477E-03/
      DATA (KB(JT,32, 4),JT=1,5) /
     &3.7110E-03,3.8251E-03,3.9302E-03,4.0264E-03,4.1112E-03/
      DATA (KB(JT,33, 4),JT=1,5) /
     &3.0918E-03,3.1864E-03,3.2713E-03,3.3504E-03,3.4219E-03/
      DATA (KB(JT,34, 4),JT=1,5) /
     &2.5734E-03,2.6501E-03,2.7238E-03,2.7897E-03,2.8499E-03/
      DATA (KB(JT,35, 4),JT=1,5) /
     &2.1361E-03,2.2030E-03,2.2659E-03,2.3224E-03,2.3696E-03/
      DATA (KB(JT,36, 4),JT=1,5) /
     &1.7673E-03,1.8262E-03,1.8805E-03,1.9284E-03,1.9688E-03/
      DATA (KB(JT,37, 4),JT=1,5) /
     &1.4584E-03,1.5086E-03,1.5546E-03,1.5960E-03,1.6338E-03/
      DATA (KB(JT,38, 4),JT=1,5) /
     &1.2034E-03,1.2453E-03,1.2856E-03,1.3227E-03,1.3572E-03/
      DATA (KB(JT,39, 4),JT=1,5) /
     &9.9454E-04,1.0299E-03,1.0651E-03,1.0982E-03,1.1293E-03/
      DATA (KB(JT,40, 4),JT=1,5) /
     &8.1766E-04,8.4814E-04,8.7922E-04,9.0780E-04,9.3604E-04/
      DATA (KB(JT,41, 4),JT=1,5) /
     &6.7161E-04,6.9882E-04,7.2604E-04,7.5179E-04,7.7573E-04/
      DATA (KB(JT,42, 4),JT=1,5) /
     &5.5233E-04,5.7642E-04,5.9983E-04,6.2278E-04,6.4351E-04/
      DATA (KB(JT,43, 4),JT=1,5) /
     &4.5350E-04,4.7458E-04,4.9522E-04,5.1500E-04,5.3326E-04/
      DATA (KB(JT,44, 4),JT=1,5) /
     &3.7202E-04,3.9025E-04,4.0848E-04,4.2568E-04,4.4143E-04/
      DATA (KB(JT,45, 4),JT=1,5) /
     &3.0534E-04,3.2126E-04,3.3706E-04,3.5201E-04,3.6606E-04/
      DATA (KB(JT,46, 4),JT=1,5) /
     &2.5026E-04,2.6416E-04,2.7768E-04,2.9081E-04,3.0319E-04/
      DATA (KB(JT,47, 4),JT=1,5) /
     &2.0428E-04,2.1616E-04,2.2794E-04,2.3946E-04,2.5046E-04/
      DATA (KB(JT,48, 4),JT=1,5) /
     &1.6667E-04,1.7701E-04,1.8729E-04,1.9740E-04,2.0693E-04/
      DATA (KB(JT,49, 4),JT=1,5) /
     &1.3611E-04,1.4498E-04,1.5402E-04,1.6290E-04,1.7121E-04/
      DATA (KB(JT,50, 4),JT=1,5) /
     &1.1088E-04,1.1847E-04,1.2631E-04,1.3390E-04,1.4119E-04/
      DATA (KB(JT,51, 4),JT=1,5) /
     &9.0216E-05,9.6607E-05,1.0331E-04,1.0986E-04,1.1615E-04/
      DATA (KB(JT,52, 4),JT=1,5) /
     &7.3423E-05,7.8834E-05,8.4566E-05,9.0143E-05,9.5562E-05/
      DATA (KB(JT,53, 4),JT=1,5) /
     &5.9754E-05,6.4377E-05,6.9227E-05,7.4054E-05,7.8692E-05/
      DATA (KB(JT,54, 4),JT=1,5) /
     &4.8298E-05,5.2166E-05,5.6219E-05,6.0246E-05,6.4263E-05/
      DATA (KB(JT,55, 4),JT=1,5) /
     &3.8831E-05,4.2066E-05,4.5431E-05,4.8757E-05,5.2064E-05/
      DATA (KB(JT,56, 4),JT=1,5) /
     &3.1190E-05,3.3925E-05,3.6680E-05,3.9437E-05,4.2169E-05/
      DATA (KB(JT,57, 4),JT=1,5) /
     &2.5026E-05,2.7326E-05,2.9588E-05,3.1864E-05,3.4154E-05/
      DATA (KB(JT,58, 4),JT=1,5) /
     &2.0044E-05,2.1985E-05,2.3836E-05,2.5731E-05,2.7590E-05/
      DATA (KB(JT,59, 4),JT=1,5) /
     &1.6187E-05,1.7736E-05,1.9214E-05,2.0762E-05,2.2244E-05/
      DATA (KB(JT,13, 5),JT=1,5) /
     &1.6183E-01,1.6388E-01,1.6830E-01,1.7476E-01,1.8120E-01/
      DATA (KB(JT,14, 5),JT=1,5) /
     &1.4136E-01,1.4390E-01,1.4614E-01,1.5033E-01,1.5561E-01/
      DATA (KB(JT,15, 5),JT=1,5) /
     &1.2277E-01,1.2594E-01,1.2862E-01,1.3140E-01,1.3513E-01/
      DATA (KB(JT,16, 5),JT=1,5) /
     &1.0716E-01,1.1019E-01,1.1295E-01,1.1569E-01,1.1878E-01/
      DATA (KB(JT,17, 5),JT=1,5) /
     &9.2722E-02,9.5517E-02,9.8213E-02,1.0105E-01,1.0426E-01/
      DATA (KB(JT,18, 5),JT=1,5) /
     &7.9838E-02,8.2414E-02,8.5010E-02,8.8074E-02,9.1598E-02/
      DATA (KB(JT,19, 5),JT=1,5) /
     &6.8325E-02,7.0740E-02,7.3430E-02,7.6659E-02,8.0269E-02/
      DATA (KB(JT,20, 5),JT=1,5) /
     &5.8275E-02,6.0721E-02,6.3630E-02,6.6772E-02,7.0098E-02/
      DATA (KB(JT,21, 5),JT=1,5) /
     &4.9672E-02,5.2190E-02,5.4967E-02,5.7853E-02,6.0822E-02/
      DATA (KB(JT,22, 5),JT=1,5) /
     &4.2534E-02,4.4900E-02,4.7398E-02,4.9961E-02,5.2416E-02/
      DATA (KB(JT,23, 5),JT=1,5) /
     &3.6361E-02,3.8477E-02,4.0633E-02,4.2770E-02,4.4639E-02/
      DATA (KB(JT,24, 5),JT=1,5) /
     &3.0984E-02,3.2792E-02,3.4594E-02,3.6198E-02,3.7541E-02/
      DATA (KB(JT,25, 5),JT=1,5) /
     &2.6322E-02,2.7818E-02,2.9192E-02,3.0375E-02,3.1335E-02/
      DATA (KB(JT,26, 5),JT=1,5) /
     &2.2285E-02,2.3473E-02,2.4485E-02,2.5360E-02,2.6084E-02/
      DATA (KB(JT,27, 5),JT=1,5) /
     &1.8777E-02,1.9670E-02,2.0440E-02,2.1104E-02,2.1661E-02/
      DATA (KB(JT,28, 5),JT=1,5) /
     &1.5739E-02,1.6410E-02,1.7009E-02,1.7502E-02,1.7957E-02/
      DATA (KB(JT,29, 5),JT=1,5) /
     &1.3157E-02,1.3689E-02,1.4135E-02,1.4550E-02,1.4908E-02/
      DATA (KB(JT,30, 5),JT=1,5) /
     &1.0985E-02,1.1390E-02,1.1749E-02,1.2076E-02,1.2372E-02/
      DATA (KB(JT,31, 5),JT=1,5) /
     &9.1582E-03,9.4742E-03,9.7675E-03,1.0044E-02,1.0289E-02/
      DATA (KB(JT,32, 5),JT=1,5) /
     &7.6339E-03,7.8923E-03,8.1271E-03,8.3548E-03,8.5695E-03/
      DATA (KB(JT,33, 5),JT=1,5) /
     &6.3715E-03,6.5845E-03,6.7878E-03,6.9736E-03,7.1535E-03/
      DATA (KB(JT,34, 5),JT=1,5) /
     &5.3224E-03,5.5025E-03,5.6652E-03,5.8262E-03,5.9749E-03/
      DATA (KB(JT,35, 5),JT=1,5) /
     &4.4348E-03,4.5841E-03,4.7248E-03,4.8589E-03,4.9851E-03/
      DATA (KB(JT,36, 5),JT=1,5) /
     &3.6880E-03,3.8127E-03,3.9338E-03,4.0484E-03,4.1576E-03/
      DATA (KB(JT,37, 5),JT=1,5) /
     &3.0534E-03,3.1615E-03,3.2693E-03,3.3693E-03,3.4657E-03/
      DATA (KB(JT,38, 5),JT=1,5) /
     &2.5332E-03,2.6300E-03,2.7225E-03,2.8131E-03,2.8939E-03/
      DATA (KB(JT,39, 5),JT=1,5) /
     &2.1084E-03,2.1961E-03,2.2783E-03,2.3583E-03,2.4286E-03/
      DATA (KB(JT,40, 5),JT=1,5) /
     &1.7458E-03,1.8240E-03,1.8981E-03,1.9682E-03,2.0283E-03/
      DATA (KB(JT,41, 5),JT=1,5) /
     &1.4453E-03,1.5145E-03,1.5781E-03,1.6391E-03,1.6964E-03/
      DATA (KB(JT,42, 5),JT=1,5) /
     &1.1954E-03,1.2559E-03,1.3113E-03,1.3662E-03,1.4193E-03/
      DATA (KB(JT,43, 5),JT=1,5) /
     &9.8711E-04,1.0388E-03,1.0881E-03,1.1376E-03,1.1854E-03/
      DATA (KB(JT,44, 5),JT=1,5) /
     &8.1670E-04,8.6083E-04,9.0273E-04,9.4724E-04,9.9183E-04/
      DATA (KB(JT,45, 5),JT=1,5) /
     &6.7571E-04,7.1462E-04,7.5340E-04,7.9241E-04,8.3252E-04/
      DATA (KB(JT,46, 5),JT=1,5) /
     &5.5868E-04,5.9210E-04,6.2784E-04,6.6315E-04,6.9901E-04/
      DATA (KB(JT,47, 5),JT=1,5) /
     &4.6002E-04,4.8924E-04,5.2084E-04,5.5250E-04,5.8555E-04/
      DATA (KB(JT,48, 5),JT=1,5) /
     &3.7900E-04,4.0478E-04,4.3312E-04,4.6138E-04,4.9219E-04/
      DATA (KB(JT,49, 5),JT=1,5) /
     &3.1223E-04,3.3515E-04,3.6106E-04,3.8737E-04,4.1475E-04/
      DATA (KB(JT,50, 5),JT=1,5) /
     &2.5631E-04,2.7625E-04,2.9941E-04,3.2338E-04,3.4759E-04/
      DATA (KB(JT,51, 5),JT=1,5) /
     &2.0956E-04,2.2726E-04,2.4758E-04,2.6894E-04,2.9020E-04/
      DATA (KB(JT,52, 5),JT=1,5) /
     &1.7113E-04,1.8689E-04,2.0470E-04,2.2361E-04,2.4260E-04/
      DATA (KB(JT,53, 5),JT=1,5) /
     &1.3975E-04,1.5381E-04,1.6939E-04,1.8611E-04,2.0352E-04/
      DATA (KB(JT,54, 5),JT=1,5) /
     &1.1323E-04,1.2519E-04,1.3824E-04,1.5269E-04,1.6768E-04/
      DATA (KB(JT,55, 5),JT=1,5) /
     &9.1211E-05,1.0111E-04,1.1195E-04,1.2407E-04,1.3663E-04/
      DATA (KB(JT,56, 5),JT=1,5) /
     &7.3375E-05,8.1461E-05,9.0533E-05,1.0060E-04,1.1119E-04/
      DATA (KB(JT,57, 5),JT=1,5) /
     &5.8946E-05,6.5535E-05,7.3109E-05,8.1511E-05,9.0294E-05/
      DATA (KB(JT,58, 5),JT=1,5) /
     &4.7323E-05,5.2682E-05,5.8966E-05,6.5820E-05,7.3137E-05/
      DATA (KB(JT,59, 5),JT=1,5) /
     &3.8250E-05,4.2565E-05,4.7446E-05,5.2866E-05,5.8710E-05/
      DATA (KB(JT,13, 6),JT=1,5) /
     &2.7197E-01,2.7739E-01,2.8096E-01,2.8231E-01,2.8660E-01/
      DATA (KB(JT,14, 6),JT=1,5) /
     &2.4407E-01,2.4904E-01,2.5343E-01,2.5569E-01,2.5783E-01/
      DATA (KB(JT,15, 6),JT=1,5) /
     &2.1616E-01,2.2099E-01,2.2537E-01,2.2864E-01,2.3140E-01/
      DATA (KB(JT,16, 6),JT=1,5) /
     &1.9106E-01,1.9585E-01,1.9991E-01,2.0367E-01,2.0768E-01/
      DATA (KB(JT,17, 6),JT=1,5) /
     &1.6891E-01,1.7330E-01,1.7742E-01,1.8116E-01,1.8548E-01/
      DATA (KB(JT,18, 6),JT=1,5) /
     &1.4873E-01,1.5292E-01,1.5684E-01,1.6048E-01,1.6482E-01/
      DATA (KB(JT,19, 6),JT=1,5) /
     &1.3023E-01,1.3403E-01,1.3773E-01,1.4155E-01,1.4625E-01/
      DATA (KB(JT,20, 6),JT=1,5) /
     &1.1343E-01,1.1684E-01,1.2043E-01,1.2478E-01,1.2990E-01/
      DATA (KB(JT,21, 6),JT=1,5) /
     &9.8160E-02,1.0135E-01,1.0525E-01,1.1007E-01,1.1526E-01/
      DATA (KB(JT,22, 6),JT=1,5) /
     &8.4655E-02,8.8120E-02,9.2429E-02,9.7184E-02,1.0215E-01/
      DATA (KB(JT,23, 6),JT=1,5) /
     &7.3019E-02,7.6775E-02,8.1076E-02,8.5515E-02,9.0104E-02/
      DATA (KB(JT,24, 6),JT=1,5) /
     &6.3162E-02,6.6861E-02,7.0760E-02,7.4872E-02,7.8956E-02/
      DATA (KB(JT,25, 6),JT=1,5) /
     &5.4670E-02,5.8059E-02,6.1565E-02,6.5142E-02,6.8514E-02/
      DATA (KB(JT,26, 6),JT=1,5) /
     &4.7238E-02,5.0243E-02,5.3330E-02,5.6237E-02,5.8783E-02/
      DATA (KB(JT,27, 6),JT=1,5) /
     &4.0718E-02,4.3335E-02,4.5897E-02,4.8107E-02,4.9970E-02/
      DATA (KB(JT,28, 6),JT=1,5) /
     &3.4992E-02,3.7210E-02,3.9178E-02,4.0837E-02,4.2251E-02/
      DATA (KB(JT,29, 6),JT=1,5) /
     &2.9986E-02,3.1757E-02,3.3246E-02,3.4515E-02,3.5697E-02/
      DATA (KB(JT,30, 6),JT=1,5) /
     &2.5598E-02,2.6947E-02,2.8105E-02,2.9142E-02,3.0127E-02/
      DATA (KB(JT,31, 6),JT=1,5) /
     &2.1742E-02,2.2800E-02,2.3733E-02,2.4625E-02,2.5488E-02/
      DATA (KB(JT,32, 6),JT=1,5) /
     &1.8409E-02,1.9261E-02,2.0062E-02,2.0837E-02,2.1556E-02/
      DATA (KB(JT,33, 6),JT=1,5) /
     &1.5564E-02,1.6264E-02,1.6973E-02,1.7637E-02,1.8281E-02/
      DATA (KB(JT,34, 6),JT=1,5) /
     &1.3120E-02,1.3750E-02,1.4364E-02,1.4950E-02,1.5574E-02/
      DATA (KB(JT,35, 6),JT=1,5) /
     &1.1037E-02,1.1597E-02,1.2120E-02,1.2671E-02,1.3247E-02/
      DATA (KB(JT,36, 6),JT=1,5) /
     &9.2368E-03,9.7140E-03,1.0180E-02,1.0677E-02,1.1200E-02/
      DATA (KB(JT,37, 6),JT=1,5) /
     &7.7240E-03,8.1368E-03,8.5470E-03,8.9958E-03,9.4504E-03/
      DATA (KB(JT,38, 6),JT=1,5) /
     &6.4758E-03,6.8295E-03,7.1958E-03,7.5972E-03,8.0066E-03/
      DATA (KB(JT,39, 6),JT=1,5) /
     &5.4501E-03,5.7576E-03,6.0862E-03,6.4345E-03,6.8065E-03/
      DATA (KB(JT,40, 6),JT=1,5) /
     &4.5611E-03,4.8311E-03,5.1160E-03,5.4160E-03,5.7404E-03/
      DATA (KB(JT,41, 6),JT=1,5) /
     &3.8156E-03,4.0605E-03,4.3157E-03,4.5812E-03,4.8631E-03/
      DATA (KB(JT,42, 6),JT=1,5) /
     &3.1991E-03,3.4174E-03,3.6479E-03,3.8959E-03,4.1438E-03/
      DATA (KB(JT,43, 6),JT=1,5) /
     &2.6778E-03,2.8754E-03,3.0830E-03,3.3106E-03,3.5418E-03/
      DATA (KB(JT,44, 6),JT=1,5) /
     &2.2384E-03,2.4221E-03,2.6165E-03,2.8279E-03,3.0365E-03/
      DATA (KB(JT,45, 6),JT=1,5) /
     &1.8762E-03,2.0454E-03,2.2217E-03,2.4182E-03,2.6139E-03/
      DATA (KB(JT,46, 6),JT=1,5) /
     &1.5669E-03,1.7239E-03,1.8868E-03,2.0694E-03,2.2548E-03/
      DATA (KB(JT,47, 6),JT=1,5) /
     &1.2965E-03,1.4378E-03,1.5876E-03,1.7568E-03,1.9326E-03/
      DATA (KB(JT,48, 6),JT=1,5) /
     &1.0774E-03,1.2001E-03,1.3389E-03,1.4948E-03,1.6630E-03/
      DATA (KB(JT,49, 6),JT=1,5) /
     &8.9852E-04,1.0105E-03,1.1309E-03,1.2754E-03,1.4391E-03/
      DATA (KB(JT,50, 6),JT=1,5) /
     &7.4445E-04,8.4643E-04,9.5631E-04,1.0809E-03,1.2318E-03/
      DATA (KB(JT,51, 6),JT=1,5) /
     &6.1558E-04,7.0452E-04,8.0429E-04,9.1653E-04,1.0518E-03/
      DATA (KB(JT,52, 6),JT=1,5) /
     &5.0970E-04,5.8893E-04,6.7706E-04,7.7959E-04,9.0341E-04/
      DATA (KB(JT,53, 6),JT=1,5) /
     &4.2152E-04,4.9282E-04,5.7291E-04,6.6638E-04,7.8149E-04/
      DATA (KB(JT,54, 6),JT=1,5) /
     &3.4337E-04,4.0415E-04,4.7438E-04,5.5660E-04,6.5618E-04/
      DATA (KB(JT,55, 6),JT=1,5) /
     &2.7643E-04,3.2706E-04,3.8585E-04,4.5635E-04,5.3989E-04/
      DATA (KB(JT,56, 6),JT=1,5) /
     &2.2200E-04,2.6388E-04,3.1337E-04,3.7328E-04,4.4370E-04/
      DATA (KB(JT,57, 6),JT=1,5) /
     &1.7748E-04,2.1244E-04,2.5395E-04,3.0395E-04,3.6371E-04/
      DATA (KB(JT,58, 6),JT=1,5) /
     &1.4157E-04,1.7062E-04,2.0500E-04,2.4610E-04,2.9686E-04/
      DATA (KB(JT,59, 6),JT=1,5) /
     &1.1414E-04,1.3738E-04,1.6469E-04,1.9701E-04,2.3735E-04/
      DATA (KB(JT,13, 7),JT=1,5) /
     &4.6955E-01,4.7919E-01,4.8757E-01,4.9335E-01,4.9501E-01/
      DATA (KB(JT,14, 7),JT=1,5) /
     &4.3446E-01,4.4412E-01,4.5217E-01,4.5833E-01,4.6211E-01/
      DATA (KB(JT,15, 7),JT=1,5) /
     &3.9856E-01,4.0695E-01,4.1403E-01,4.2050E-01,4.2565E-01/
      DATA (KB(JT,16, 7),JT=1,5) /
     &3.6468E-01,3.7159E-01,3.7817E-01,3.8407E-01,3.8859E-01/
      DATA (KB(JT,17, 7),JT=1,5) /
     &3.3137E-01,3.3763E-01,3.4358E-01,3.4927E-01,3.5406E-01/
      DATA (KB(JT,18, 7),JT=1,5) /
     &2.9961E-01,3.0527E-01,3.1117E-01,3.1677E-01,3.2160E-01/
      DATA (KB(JT,19, 7),JT=1,5) /
     &2.6897E-01,2.7470E-01,2.8068E-01,2.8609E-01,2.9127E-01/
      DATA (KB(JT,20, 7),JT=1,5) /
     &2.4079E-01,2.4662E-01,2.5228E-01,2.5749E-01,2.6294E-01/
      DATA (KB(JT,21, 7),JT=1,5) /
     &2.1419E-01,2.1985E-01,2.2509E-01,2.3029E-01,2.3688E-01/
      DATA (KB(JT,22, 7),JT=1,5) /
     &1.8948E-01,1.9472E-01,1.9983E-01,2.0584E-01,2.1394E-01/
      DATA (KB(JT,23, 7),JT=1,5) /
     &1.6639E-01,1.7145E-01,1.7716E-01,1.8457E-01,1.9389E-01/
      DATA (KB(JT,24, 7),JT=1,5) /
     &1.4538E-01,1.5085E-01,1.5765E-01,1.6633E-01,1.7588E-01/
      DATA (KB(JT,25, 7),JT=1,5) /
     &1.2705E-01,1.3331E-01,1.4121E-01,1.5025E-01,1.5987E-01/
      DATA (KB(JT,26, 7),JT=1,5) /
     &1.1163E-01,1.1872E-01,1.2704E-01,1.3598E-01,1.4549E-01/
      DATA (KB(JT,27, 7),JT=1,5) /
     &9.8775E-02,1.0620E-01,1.1436E-01,1.2321E-01,1.3236E-01/
      DATA (KB(JT,28, 7),JT=1,5) /
     &8.7819E-02,9.5125E-02,1.0304E-01,1.1161E-01,1.2007E-01/
      DATA (KB(JT,29, 7),JT=1,5) /
     &7.8356E-02,8.5376E-02,9.3117E-02,1.0101E-01,1.0879E-01/
      DATA (KB(JT,30, 7),JT=1,5) /
     &7.0020E-02,7.6849E-02,8.4078E-02,9.1302E-02,9.8416E-02/
      DATA (KB(JT,31, 7),JT=1,5) /
     &6.2819E-02,6.9270E-02,7.5879E-02,8.2483E-02,8.8967E-02/
      DATA (KB(JT,32, 7),JT=1,5) /
     &5.6483E-02,6.2430E-02,6.8481E-02,7.4539E-02,8.0648E-02/
      DATA (KB(JT,33, 7),JT=1,5) /
     &5.0860E-02,5.6316E-02,6.1885E-02,6.7612E-02,7.3808E-02/
      DATA (KB(JT,34, 7),JT=1,5) /
     &4.5682E-02,5.0745E-02,5.5935E-02,6.1551E-02,6.7601E-02/
      DATA (KB(JT,35, 7),JT=1,5) /
     &4.0692E-02,4.5316E-02,5.0264E-02,5.5834E-02,6.1807E-02/
      DATA (KB(JT,36, 7),JT=1,5) /
     &3.5794E-02,4.0089E-02,4.4914E-02,5.0304E-02,5.6176E-02/
      DATA (KB(JT,37, 7),JT=1,5) /
     &3.0961E-02,3.4978E-02,3.9573E-02,4.4775E-02,5.0561E-02/
      DATA (KB(JT,38, 7),JT=1,5) /
     &2.6776E-02,3.0559E-02,3.4968E-02,3.9997E-02,4.5685E-02/
      DATA (KB(JT,39, 7),JT=1,5) /
     &2.3185E-02,2.6765E-02,3.1022E-02,3.5959E-02,4.1519E-02/
      DATA (KB(JT,40, 7),JT=1,5) /
     &1.9763E-02,2.3065E-02,2.7085E-02,3.1775E-02,3.7215E-02/
      DATA (KB(JT,41, 7),JT=1,5) /
     &1.6812E-02,1.9830E-02,2.3604E-02,2.8085E-02,3.3399E-02/
      DATA (KB(JT,42, 7),JT=1,5) /
     &1.4318E-02,1.7069E-02,2.0605E-02,2.4882E-02,3.0046E-02/
      DATA (KB(JT,43, 7),JT=1,5) /
     &1.2083E-02,1.4567E-02,1.7802E-02,2.1853E-02,2.6807E-02/
      DATA (KB(JT,44, 7),JT=1,5) /
     &1.0170E-02,1.2372E-02,1.5314E-02,1.9108E-02,2.3821E-02/
      DATA (KB(JT,45, 7),JT=1,5) /
     &8.6090E-03,1.0534E-02,1.3191E-02,1.6726E-02,2.1197E-02/
      DATA (KB(JT,46, 7),JT=1,5) /
     &7.3022E-03,8.9907E-03,1.1353E-02,1.4581E-02,1.8771E-02/
      DATA (KB(JT,47, 7),JT=1,5) /
     &6.1213E-03,7.6431E-03,9.7321E-03,1.2583E-02,1.6455E-02/
      DATA (KB(JT,48, 7),JT=1,5) /
     &5.1186E-03,6.5188E-03,8.4138E-03,1.0987E-02,1.4502E-02/
      DATA (KB(JT,49, 7),JT=1,5) /
     &4.2957E-03,5.5597E-03,7.3442E-03,9.7283E-03,1.2936E-02/
      DATA (KB(JT,50, 7),JT=1,5) /
     &3.6145E-03,4.7398E-03,6.3555E-03,8.6287E-03,1.1590E-02/
      DATA (KB(JT,51, 7),JT=1,5) /
     &3.0102E-03,4.0430E-03,5.4860E-03,7.5896E-03,1.0447E-02/
      DATA (KB(JT,52, 7),JT=1,5) /
     &2.4958E-03,3.4406E-03,4.7896E-03,6.7274E-03,9.4519E-03/
      DATA (KB(JT,53, 7),JT=1,5) /
     &2.0685E-03,2.9229E-03,4.2030E-03,6.0566E-03,8.6137E-03/
      DATA (KB(JT,54, 7),JT=1,5) /
     &1.6899E-03,2.4174E-03,3.5607E-03,5.2595E-03,7.6384E-03/
      DATA (KB(JT,55, 7),JT=1,5) /
     &1.3559E-03,1.9570E-03,2.9412E-03,4.4253E-03,6.5827E-03/
      DATA (KB(JT,56, 7),JT=1,5) /
     &1.0806E-03,1.5745E-03,2.4094E-03,3.7108E-03,5.6277E-03/
      DATA (KB(JT,57, 7),JT=1,5) /
     &8.5457E-04,1.2632E-03,1.9536E-03,3.0874E-03,4.7870E-03/
      DATA (KB(JT,58, 7),JT=1,5) /
     &6.7302E-04,1.0065E-03,1.5736E-03,2.5427E-03,4.0334E-03/
      DATA (KB(JT,59, 7),JT=1,5) /
     &5.4147E-04,8.1396E-04,1.2891E-03,2.1042E-03,3.3560E-03/
      DATA (KB(JT,13, 8),JT=1,5) /
     &8.0034E-01,8.1640E-01,8.3288E-01,8.4808E-01,8.6148E-01/
      DATA (KB(JT,14, 8),JT=1,5) /
     &7.8054E-01,7.9433E-01,8.0919E-01,8.2411E-01,8.3905E-01/
      DATA (KB(JT,15, 8),JT=1,5) /
     &7.5909E-01,7.7248E-01,7.8592E-01,7.9872E-01,8.1170E-01/
      DATA (KB(JT,16, 8),JT=1,5) /
     &7.3580E-01,7.4804E-01,7.6085E-01,7.7248E-01,7.8295E-01/
      DATA (KB(JT,17, 8),JT=1,5) /
     &7.0630E-01,7.1844E-01,7.2965E-01,7.3912E-01,7.4743E-01/
      DATA (KB(JT,18, 8),JT=1,5) /
     &6.7101E-01,6.8279E-01,6.9322E-01,7.0102E-01,7.0887E-01/
      DATA (KB(JT,19, 8),JT=1,5) /
     &6.2981E-01,6.4055E-01,6.4979E-01,6.5773E-01,6.6515E-01/
      DATA (KB(JT,20, 8),JT=1,5) /
     &5.8544E-01,5.9608E-01,6.0511E-01,6.1342E-01,6.2187E-01/
      DATA (KB(JT,21, 8),JT=1,5) /
     &5.3944E-01,5.5063E-01,5.6005E-01,5.6946E-01,5.7856E-01/
      DATA (KB(JT,22, 8),JT=1,5) /
     &4.9436E-01,5.0585E-01,5.1644E-01,5.2703E-01,5.3664E-01/
      DATA (KB(JT,23, 8),JT=1,5) /
     &4.5102E-01,4.6300E-01,4.7455E-01,4.8579E-01,4.9663E-01/
      DATA (KB(JT,24, 8),JT=1,5) /
     &4.0950E-01,4.2198E-01,4.3426E-01,4.4606E-01,4.5946E-01/
      DATA (KB(JT,25, 8),JT=1,5) /
     &3.7091E-01,3.8365E-01,3.9643E-01,4.1000E-01,4.2576E-01/
      DATA (KB(JT,26, 8),JT=1,5) /
     &3.3534E-01,3.4839E-01,3.6241E-01,3.7838E-01,3.9777E-01/
      DATA (KB(JT,27, 8),JT=1,5) /
     &3.0274E-01,3.1698E-01,3.3298E-01,3.5138E-01,3.7450E-01/
      DATA (KB(JT,28, 8),JT=1,5) /
     &2.7401E-01,2.8968E-01,3.0792E-01,3.3011E-01,3.5579E-01/
      DATA (KB(JT,29, 8),JT=1,5) /
     &2.4984E-01,2.6749E-01,2.8805E-01,3.1339E-01,3.4148E-01/
      DATA (KB(JT,30, 8),JT=1,5) /
     &2.2976E-01,2.4923E-01,2.7317E-01,3.0058E-01,3.3054E-01/
      DATA (KB(JT,31, 8),JT=1,5) /
     &2.1378E-01,2.3592E-01,2.6234E-01,2.9177E-01,3.2355E-01/
      DATA (KB(JT,32, 8),JT=1,5) /
     &2.0184E-01,2.2666E-01,2.5501E-01,2.8631E-01,3.1911E-01/
      DATA (KB(JT,33, 8),JT=1,5) /
     &1.9381E-01,2.2050E-01,2.5091E-01,2.8341E-01,3.1739E-01/
      DATA (KB(JT,34, 8),JT=1,5) /
     &1.8744E-01,2.1594E-01,2.4774E-01,2.8137E-01,3.1632E-01/
      DATA (KB(JT,35, 8),JT=1,5) /
     &1.8056E-01,2.1069E-01,2.4353E-01,2.7798E-01,3.1405E-01/
      DATA (KB(JT,36, 8),JT=1,5) /
     &1.7277E-01,2.0381E-01,2.3716E-01,2.7253E-01,3.0956E-01/
      DATA (KB(JT,37, 8),JT=1,5) /
     &1.6168E-01,1.9289E-01,2.2650E-01,2.6234E-01,2.9987E-01/
      DATA (KB(JT,38, 8),JT=1,5) /
     &1.5148E-01,1.8272E-01,2.1663E-01,2.5277E-01,2.9084E-01/
      DATA (KB(JT,39, 8),JT=1,5) /
     &1.4247E-01,1.7365E-01,2.0770E-01,2.4421E-01,2.8306E-01/
      DATA (KB(JT,40, 8),JT=1,5) /
     &1.3121E-01,1.6190E-01,1.9569E-01,2.3227E-01,2.7141E-01/
      DATA (KB(JT,41, 8),JT=1,5) /
     &1.2044E-01,1.5044E-01,1.8388E-01,2.2048E-01,2.5951E-01/
      DATA (KB(JT,42, 8),JT=1,5) /
     &1.1043E-01,1.3967E-01,1.7269E-01,2.0919E-01,2.4811E-01/
      DATA (KB(JT,43, 8),JT=1,5) /
     &9.9679E-02,1.2792E-01,1.6034E-01,1.9622E-01,2.3472E-01/
      DATA (KB(JT,44, 8),JT=1,5) /
     &8.9034E-02,1.1631E-01,1.4764E-01,1.8285E-01,2.2093E-01/
      DATA (KB(JT,45, 8),JT=1,5) /
     &7.9054E-02,1.0536E-01,1.3566E-01,1.6992E-01,2.0745E-01/
      DATA (KB(JT,46, 8),JT=1,5) /
     &6.9318E-02,9.4501E-02,1.2377E-01,1.5667E-01,1.9349E-01/
      DATA (KB(JT,47, 8),JT=1,5) /
     &5.9551E-02,8.3032E-02,1.1103E-01,1.4286E-01,1.7816E-01/
      DATA (KB(JT,48, 8),JT=1,5) /
     &5.0798E-02,7.2525E-02,9.9035E-02,1.2969E-01,1.6375E-01/
      DATA (KB(JT,49, 8),JT=1,5) /
     &4.3152E-02,6.3003E-02,8.7833E-02,1.1716E-01,1.5024E-01/
      DATA (KB(JT,50, 8),JT=1,5) /
     &3.6793E-02,5.4813E-02,7.7929E-02,1.0576E-01,1.3787E-01/
      DATA (KB(JT,51, 8),JT=1,5) /
     &3.1426E-02,4.7509E-02,6.8953E-02,9.5149E-02,1.2582E-01/
      DATA (KB(JT,52, 8),JT=1,5) /
     &2.6907E-02,4.1306E-02,6.0841E-02,8.5477E-02,1.1483E-01/
      DATA (KB(JT,53, 8),JT=1,5) /
     &2.3168E-02,3.6049E-02,5.3816E-02,7.6669E-02,1.0462E-01/
      DATA (KB(JT,54, 8),JT=1,5) /
     &1.9633E-02,3.1217E-02,4.7423E-02,6.8592E-02,9.4967E-02/
      DATA (KB(JT,55, 8),JT=1,5) /
     &1.6386E-02,2.6769E-02,4.1346E-02,6.0965E-02,8.5476E-02/
      DATA (KB(JT,56, 8),JT=1,5) /
     &1.3620E-02,2.2714E-02,3.5826E-02,5.3847E-02,7.6755E-02/
      DATA (KB(JT,57, 8),JT=1,5) /
     &1.1197E-02,1.9124E-02,3.0904E-02,4.7282E-02,6.8602E-02/
      DATA (KB(JT,58, 8),JT=1,5) /
     &9.1481E-03,1.6046E-02,2.6605E-02,4.1371E-02,6.1207E-02/
      DATA (KB(JT,59, 8),JT=1,5) /
     &7.9051E-03,1.4193E-02,2.3774E-02,3.7742E-02,5.6658E-02/
      DATA (KB(JT,13, 9),JT=1,5) /
     &1.3350E+00,1.3653E+00,1.3981E+00,1.4396E+00,1.4753E+00/
      DATA (KB(JT,14, 9),JT=1,5) /
     &1.4178E+00,1.4520E+00,1.4843E+00,1.5206E+00,1.5583E+00/
      DATA (KB(JT,15, 9),JT=1,5) /
     &1.4732E+00,1.5083E+00,1.5396E+00,1.5755E+00,1.6045E+00/
      DATA (KB(JT,16, 9),JT=1,5) /
     &1.5430E+00,1.5830E+00,1.6160E+00,1.6547E+00,1.6902E+00/
      DATA (KB(JT,17, 9),JT=1,5) /
     &1.6452E+00,1.6845E+00,1.7176E+00,1.7564E+00,1.7915E+00/
      DATA (KB(JT,18, 9),JT=1,5) /
     &1.7229E+00,1.7605E+00,1.7922E+00,1.8300E+00,1.8621E+00/
      DATA (KB(JT,19, 9),JT=1,5) /
     &1.7775E+00,1.8140E+00,1.8454E+00,1.8798E+00,1.9094E+00/
      DATA (KB(JT,20, 9),JT=1,5) /
     &1.8038E+00,1.8386E+00,1.8699E+00,1.9034E+00,1.9311E+00/
      DATA (KB(JT,21, 9),JT=1,5) /
     &1.8050E+00,1.8386E+00,1.8712E+00,1.9046E+00,1.9320E+00/
      DATA (KB(JT,22, 9),JT=1,5) /
     &1.7869E+00,1.8213E+00,1.8557E+00,1.8890E+00,1.9178E+00/
      DATA (KB(JT,23, 9),JT=1,5) /
     &1.7516E+00,1.7874E+00,1.8248E+00,1.8592E+00,1.8901E+00/
      DATA (KB(JT,24, 9),JT=1,5) /
     &1.7051E+00,1.7440E+00,1.7841E+00,1.8220E+00,1.8561E+00/
      DATA (KB(JT,25, 9),JT=1,5) /
     &1.6513E+00,1.6948E+00,1.7396E+00,1.7805E+00,1.8194E+00/
      DATA (KB(JT,26, 9),JT=1,5) /
     &1.5955E+00,1.6454E+00,1.6945E+00,1.7402E+00,1.7819E+00/
      DATA (KB(JT,27, 9),JT=1,5) /
     &1.5421E+00,1.5985E+00,1.6517E+00,1.7028E+00,1.7485E+00/
      DATA (KB(JT,28, 9),JT=1,5) /
     &1.4940E+00,1.5568E+00,1.6151E+00,1.6694E+00,1.7213E+00/
      DATA (KB(JT,29, 9),JT=1,5) /
     &1.4533E+00,1.5206E+00,1.5846E+00,1.6444E+00,1.7003E+00/
      DATA (KB(JT,30, 9),JT=1,5) /
     &1.4208E+00,1.4930E+00,1.5618E+00,1.6263E+00,1.6869E+00/
      DATA (KB(JT,31, 9),JT=1,5) /
     &1.3961E+00,1.4744E+00,1.5474E+00,1.6161E+00,1.6805E+00/
      DATA (KB(JT,32, 9),JT=1,5) /
     &1.3821E+00,1.4633E+00,1.5401E+00,1.6122E+00,1.6817E+00/
      DATA (KB(JT,33, 9),JT=1,5) /
     &1.3749E+00,1.4598E+00,1.5393E+00,1.6160E+00,1.6953E+00/
      DATA (KB(JT,34, 9),JT=1,5) /
     &1.3713E+00,1.4588E+00,1.5429E+00,1.6218E+00,1.7156E+00/
      DATA (KB(JT,35, 9),JT=1,5) /
     &1.3644E+00,1.4561E+00,1.5422E+00,1.6338E+00,1.7288E+00/
      DATA (KB(JT,36, 9),JT=1,5) /
     &1.3516E+00,1.4466E+00,1.5348E+00,1.6360E+00,1.7340E+00/
      DATA (KB(JT,37, 9),JT=1,5) /
     &1.3275E+00,1.4250E+00,1.5169E+00,1.6237E+00,1.7238E+00/
      DATA (KB(JT,38, 9),JT=1,5) /
     &1.3040E+00,1.4043E+00,1.5021E+00,1.6114E+00,1.7135E+00/
      DATA (KB(JT,39, 9),JT=1,5) /
     &1.2823E+00,1.3849E+00,1.4910E+00,1.6008E+00,1.7062E+00/
      DATA (KB(JT,40, 9),JT=1,5) /
     &1.2494E+00,1.3552E+00,1.4636E+00,1.5759E+00,1.6836E+00/
      DATA (KB(JT,41, 9),JT=1,5) /
     &1.2158E+00,1.3244E+00,1.4340E+00,1.5489E+00,1.6593E+00/
      DATA (KB(JT,42, 9),JT=1,5) /
     &1.1826E+00,1.2939E+00,1.4045E+00,1.5221E+00,1.6360E+00/
      DATA (KB(JT,43, 9),JT=1,5) /
     &1.1430E+00,1.2570E+00,1.3680E+00,1.4889E+00,1.6061E+00/
      DATA (KB(JT,44, 9),JT=1,5) /
     &1.1001E+00,1.2164E+00,1.3282E+00,1.4525E+00,1.5734E+00/
      DATA (KB(JT,45, 9),JT=1,5) /
     &1.0569E+00,1.1761E+00,1.2894E+00,1.4161E+00,1.5408E+00/
      DATA (KB(JT,46, 9),JT=1,5) /
     &1.0113E+00,1.1324E+00,1.2480E+00,1.3769E+00,1.5047E+00/
      DATA (KB(JT,47, 9),JT=1,5) /
     &9.5935E-01,1.0831E+00,1.2009E+00,1.3301E+00,1.4611E+00/
      DATA (KB(JT,48, 9),JT=1,5) /
     &9.0670E-01,1.0329E+00,1.1535E+00,1.2830E+00,1.4185E+00/
      DATA (KB(JT,49, 9),JT=1,5) /
     &8.5414E-01,9.8225E-01,1.1056E+00,1.2370E+00,1.3774E+00/
      DATA (KB(JT,50, 9),JT=1,5) /
     &8.0339E-01,9.3369E-01,1.0592E+00,1.1907E+00,1.3340E+00/
      DATA (KB(JT,51, 9),JT=1,5) /
     &7.5351E-01,8.8571E-01,1.0133E+00,1.1450E+00,1.2894E+00/
      DATA (KB(JT,52, 9),JT=1,5) /
     &7.0363E-01,8.3718E-01,9.6715E-01,1.0991E+00,1.2446E+00/
      DATA (KB(JT,53, 9),JT=1,5) /
     &6.5356E-01,7.8813E-01,9.1966E-01,1.0529E+00,1.2015E+00/
      DATA (KB(JT,54, 9),JT=1,5) /
     &6.0842E-01,7.4258E-01,8.7513E-01,1.0061E+00,1.1543E+00/
      DATA (KB(JT,55, 9),JT=1,5) /
     &5.6587E-01,6.9834E-01,8.3229E-01,9.6266E-01,1.1037E+00/
      DATA (KB(JT,56, 9),JT=1,5) /
     &5.2358E-01,6.5442E-01,7.8939E-01,9.2104E-01,1.0541E+00/
      DATA (KB(JT,57, 9),JT=1,5) /
     &4.8183E-01,6.1174E-01,7.4558E-01,8.7862E-01,1.0077E+00/
      DATA (KB(JT,58, 9),JT=1,5) /
     &4.4300E-01,5.7151E-01,7.0375E-01,8.3825E-01,9.6862E-01/
      DATA (KB(JT,59, 9),JT=1,5) /
     &4.2745E-01,5.5483E-01,6.8739E-01,8.2045E-01,9.5225E-01/
      DATA (KB(JT,13,10),JT=1,5) /
     &1.9893E+00,1.9563E+00,1.9174E+00,1.9426E+00,2.0503E+00/
      DATA (KB(JT,14,10),JT=1,5) /
     &1.9716E+00,2.0101E+00,2.0332E+00,2.0825E+00,2.0990E+00/
      DATA (KB(JT,15,10),JT=1,5) /
     &2.2404E+00,2.3114E+00,2.3474E+00,2.4414E+00,2.5235E+00/
      DATA (KB(JT,16,10),JT=1,5) /
     &2.6948E+00,2.7693E+00,2.8500E+00,2.9277E+00,3.0098E+00/
      DATA (KB(JT,17,10),JT=1,5) /
     &2.9786E+00,3.0578E+00,3.1508E+00,3.2081E+00,3.2791E+00/
      DATA (KB(JT,18,10),JT=1,5) /
     &3.2445E+00,3.3300E+00,3.4200E+00,3.4641E+00,3.5430E+00/
      DATA (KB(JT,19,10),JT=1,5) /
     &3.4975E+00,3.5857E+00,3.6668E+00,3.7210E+00,3.8007E+00/
      DATA (KB(JT,20,10),JT=1,5) /
     &3.7569E+00,3.8465E+00,3.9165E+00,3.9790E+00,4.0533E+00/
      DATA (KB(JT,21,10),JT=1,5) /
     &4.0221E+00,4.1092E+00,4.1701E+00,4.2261E+00,4.2948E+00/
      DATA (KB(JT,22,10),JT=1,5) /
     &4.2735E+00,4.3579E+00,4.4003E+00,4.4698E+00,4.5287E+00/
      DATA (KB(JT,23,10),JT=1,5) /
     &4.4889E+00,4.5713E+00,4.6026E+00,4.6888E+00,4.7442E+00/
      DATA (KB(JT,24,10),JT=1,5) /
     &4.6627E+00,4.7429E+00,4.7936E+00,4.8738E+00,4.9305E+00/
      DATA (KB(JT,25,10),JT=1,5) /
     &4.8010E+00,4.8792E+00,4.9473E+00,5.0350E+00,5.0940E+00/
      DATA (KB(JT,26,10),JT=1,5) /
     &4.9124E+00,4.9871E+00,5.0797E+00,5.1628E+00,5.2299E+00/
      DATA (KB(JT,27,10),JT=1,5) /
     &4.9985E+00,5.0753E+00,5.2023E+00,5.2822E+00,5.3506E+00/
      DATA (KB(JT,28,10),JT=1,5) /
     &5.0601E+00,5.1633E+00,5.2946E+00,5.3826E+00,5.4390E+00/
      DATA (KB(JT,29,10),JT=1,5) /
     &5.1149E+00,5.2551E+00,5.3769E+00,5.4560E+00,5.5331E+00/
      DATA (KB(JT,30,10),JT=1,5) /
     &5.1829E+00,5.3405E+00,5.4468E+00,5.5366E+00,5.6267E+00/
      DATA (KB(JT,31,10),JT=1,5) /
     &5.2708E+00,5.3990E+00,5.5145E+00,5.6271E+00,5.7226E+00/
      DATA (KB(JT,32,10),JT=1,5) /
     &5.3210E+00,5.4615E+00,5.6064E+00,5.7149E+00,5.7961E+00/
      DATA (KB(JT,33,10),JT=1,5) /
     &5.3784E+00,5.5514E+00,5.6898E+00,5.7825E+00,5.7881E+00/
      DATA (KB(JT,34,10),JT=1,5) /
     &5.4610E+00,5.6264E+00,5.7421E+00,5.8351E+00,5.7469E+00/
      DATA (KB(JT,35,10),JT=1,5) /
     &5.5182E+00,5.6646E+00,5.7805E+00,5.8049E+00,5.8731E+00/
      DATA (KB(JT,36,10),JT=1,5) /
     &5.5474E+00,5.6825E+00,5.8317E+00,5.7746E+00,5.9436E+00/
      DATA (KB(JT,37,10),JT=1,5) /
     &5.5356E+00,5.6848E+00,5.8413E+00,5.7830E+00,5.9888E+00/
      DATA (KB(JT,38,10),JT=1,5) /
     &5.5240E+00,5.6924E+00,5.8161E+00,5.8447E+00,6.0305E+00/
      DATA (KB(JT,39,10),JT=1,5) /
     &5.5062E+00,5.7035E+00,5.7750E+00,5.8907E+00,6.0598E+00/
      DATA (KB(JT,40,10),JT=1,5) /
     &5.4721E+00,5.6790E+00,5.7621E+00,5.8808E+00,6.0578E+00/
      DATA (KB(JT,41,10),JT=1,5) /
     &5.4259E+00,5.6462E+00,5.7509E+00,5.8640E+00,6.0494E+00/
      DATA (KB(JT,42,10),JT=1,5) /
     &5.3746E+00,5.6111E+00,5.7387E+00,5.8493E+00,6.0309E+00/
      DATA (KB(JT,43,10),JT=1,5) /
     &5.3001E+00,5.5493E+00,5.7206E+00,5.8145E+00,6.0040E+00/
      DATA (KB(JT,44,10),JT=1,5) /
     &5.2173E+00,5.4929E+00,5.6988E+00,5.7584E+00,5.9757E+00/
      DATA (KB(JT,45,10),JT=1,5) /
     &5.1348E+00,5.4235E+00,5.6596E+00,5.7148E+00,5.9430E+00/
      DATA (KB(JT,46,10),JT=1,5) /
     &5.0314E+00,5.3386E+00,5.5941E+00,5.6594E+00,5.8994E+00/
      DATA (KB(JT,47,10),JT=1,5) /
     &4.9050E+00,5.2288E+00,5.5164E+00,5.5882E+00,5.8407E+00/
      DATA (KB(JT,48,10),JT=1,5) /
     &4.7768E+00,5.1235E+00,5.4274E+00,5.5412E+00,5.7765E+00/
      DATA (KB(JT,49,10),JT=1,5) /
     &4.6322E+00,5.0058E+00,5.3313E+00,5.4722E+00,5.7006E+00/
      DATA (KB(JT,50,10),JT=1,5) /
     &4.4926E+00,4.8780E+00,5.2241E+00,5.4133E+00,5.6277E+00/
      DATA (KB(JT,51,10),JT=1,5) /
     &4.3523E+00,4.7488E+00,5.1238E+00,5.3514E+00,5.5587E+00/
      DATA (KB(JT,52,10),JT=1,5) /
     &4.2056E+00,4.6099E+00,5.0074E+00,5.2732E+00,5.4803E+00/
      DATA (KB(JT,53,10),JT=1,5) /
     &4.0530E+00,4.4698E+00,4.8873E+00,5.1842E+00,5.3844E+00/
      DATA (KB(JT,54,10),JT=1,5) /
     &3.8976E+00,4.3362E+00,4.7616E+00,5.1168E+00,5.2766E+00/
      DATA (KB(JT,55,10),JT=1,5) /
     &3.7298E+00,4.2020E+00,4.6200E+00,5.0133E+00,5.2077E+00/
      DATA (KB(JT,56,10),JT=1,5) /
     &3.5605E+00,4.0625E+00,4.4800E+00,4.8943E+00,5.1989E+00/
      DATA (KB(JT,57,10),JT=1,5) /
     &3.3848E+00,3.9107E+00,4.3536E+00,4.7626E+00,5.1398E+00/
      DATA (KB(JT,58,10),JT=1,5) /
     &3.2413E+00,3.7494E+00,4.2254E+00,4.6312E+00,5.0237E+00/
      DATA (KB(JT,59,10),JT=1,5) /
     &3.1874E+00,3.6712E+00,4.1570E+00,4.5764E+00,4.9431E+00/
      DATA (KB(JT,13,11),JT=1,5) /
     &2.0655E+00,2.2522E+00,2.3749E+00,2.3793E+00,2.3141E+00/
      DATA (KB(JT,14,11),JT=1,5) /
     &2.3056E+00,2.3392E+00,2.3483E+00,2.4161E+00,2.4783E+00/
      DATA (KB(JT,15,11),JT=1,5) /
     &2.5044E+00,2.5910E+00,2.7153E+00,2.7838E+00,2.9462E+00/
      DATA (KB(JT,16,11),JT=1,5) /
     &3.2130E+00,3.2960E+00,3.3708E+00,3.3957E+00,3.4936E+00/
      DATA (KB(JT,17,11),JT=1,5) /
     &3.5929E+00,3.6854E+00,3.7568E+00,3.8084E+00,3.9070E+00/
      DATA (KB(JT,18,11),JT=1,5) /
     &3.9502E+00,4.0564E+00,4.1260E+00,4.2219E+00,4.3335E+00/
      DATA (KB(JT,19,11),JT=1,5) /
     &4.3215E+00,4.4423E+00,4.5361E+00,4.6179E+00,4.7405E+00/
      DATA (KB(JT,20,11),JT=1,5) /
     &4.7059E+00,4.8304E+00,4.9342E+00,4.9958E+00,5.1320E+00/
      DATA (KB(JT,21,11),JT=1,5) /
     &5.0845E+00,5.2089E+00,5.3085E+00,5.3635E+00,5.4973E+00/
      DATA (KB(JT,22,11),JT=1,5) /
     &5.4678E+00,5.5866E+00,5.6718E+00,5.7157E+00,5.8446E+00/
      DATA (KB(JT,23,11),JT=1,5) /
     &5.8472E+00,5.9542E+00,6.0224E+00,6.0657E+00,6.1751E+00/
      DATA (KB(JT,24,11),JT=1,5) /
     &6.2102E+00,6.3055E+00,6.3477E+00,6.4025E+00,6.4818E+00/
      DATA (KB(JT,25,11),JT=1,5) /
     &6.5425E+00,6.6276E+00,6.6464E+00,6.7138E+00,6.7776E+00/
      DATA (KB(JT,26,11),JT=1,5) /
     &6.8397E+00,6.9134E+00,6.9153E+00,7.0099E+00,7.0590E+00/
      DATA (KB(JT,27,11),JT=1,5) /
     &7.1001E+00,7.1597E+00,7.1676E+00,7.2592E+00,7.2956E+00/
      DATA (KB(JT,28,11),JT=1,5) /
     &7.3310E+00,7.3578E+00,7.4192E+00,7.4714E+00,7.5147E+00/
      DATA (KB(JT,29,11),JT=1,5) /
     &7.5220E+00,7.5568E+00,7.6448E+00,7.6786E+00,7.7106E+00/
      DATA (KB(JT,30,11),JT=1,5) /
     &7.6639E+00,7.7470E+00,7.8152E+00,7.8571E+00,7.8626E+00/
      DATA (KB(JT,31,11),JT=1,5) /
     &7.8082E+00,7.9292E+00,7.9711E+00,7.9864E+00,7.9914E+00/
      DATA (KB(JT,32,11),JT=1,5) /
     &7.9725E+00,8.0661E+00,8.0888E+00,8.1052E+00,8.1459E+00/
      DATA (KB(JT,33,11),JT=1,5) /
     &8.1196E+00,8.1648E+00,8.2204E+00,8.2561E+00,8.2714E+00/
      DATA (KB(JT,34,11),JT=1,5) /
     &8.1982E+00,8.2822E+00,8.3431E+00,8.3695E+00,8.3494E+00/
      DATA (KB(JT,35,11),JT=1,5) /
     &8.2893E+00,8.3914E+00,8.4459E+00,8.4367E+00,8.2201E+00/
      DATA (KB(JT,36,11),JT=1,5) /
     &8.3709E+00,8.4754E+00,8.5081E+00,8.5002E+00,8.2056E+00/
      DATA (KB(JT,37,11),JT=1,5) /
     &8.4255E+00,8.5299E+00,8.5562E+00,8.5457E+00,8.3297E+00/
      DATA (KB(JT,38,11),JT=1,5) /
     &8.4692E+00,8.5729E+00,8.6048E+00,8.5329E+00,8.4574E+00/
      DATA (KB(JT,39,11),JT=1,5) /
     &8.5044E+00,8.6011E+00,8.6529E+00,8.5036E+00,8.5412E+00/
      DATA (KB(JT,40,11),JT=1,5) /
     &8.5034E+00,8.6122E+00,8.6861E+00,8.5500E+00,8.5878E+00/
      DATA (KB(JT,41,11),JT=1,5) /
     &8.4921E+00,8.6152E+00,8.7146E+00,8.6037E+00,8.6322E+00/
      DATA (KB(JT,42,11),JT=1,5) /
     &8.4716E+00,8.6012E+00,8.7281E+00,8.6344E+00,8.6768E+00/
      DATA (KB(JT,43,11),JT=1,5) /
     &8.4399E+00,8.6022E+00,8.7354E+00,8.6857E+00,8.7108E+00/
      DATA (KB(JT,44,11),JT=1,5) /
     &8.4042E+00,8.5707E+00,8.7247E+00,8.7306E+00,8.7301E+00/
      DATA (KB(JT,45,11),JT=1,5) /
     &8.3422E+00,8.5367E+00,8.7092E+00,8.7655E+00,8.7531E+00/
      DATA (KB(JT,46,11),JT=1,5) /
     &8.2614E+00,8.4925E+00,8.6796E+00,8.7911E+00,8.7636E+00/
      DATA (KB(JT,47,11),JT=1,5) /
     &8.1773E+00,8.4296E+00,8.6376E+00,8.8172E+00,8.7465E+00/
      DATA (KB(JT,48,11),JT=1,5) /
     &8.0681E+00,8.3512E+00,8.5867E+00,8.7946E+00,8.7119E+00/
      DATA (KB(JT,49,11),JT=1,5) /
     &7.9551E+00,8.2607E+00,8.5307E+00,8.7608E+00,8.6937E+00/
      DATA (KB(JT,50,11),JT=1,5) /
     &7.8252E+00,8.1751E+00,8.4616E+00,8.7182E+00,8.6487E+00/
      DATA (KB(JT,51,11),JT=1,5) /
     &7.6779E+00,8.0748E+00,8.3664E+00,8.6630E+00,8.6216E+00/
      DATA (KB(JT,52,11),JT=1,5) /
     &7.5020E+00,7.9591E+00,8.2751E+00,8.6024E+00,8.6131E+00/
      DATA (KB(JT,53,11),JT=1,5) /
     &7.3138E+00,7.8339E+00,8.1806E+00,8.5263E+00,8.5994E+00/
      DATA (KB(JT,54,11),JT=1,5) /
     &7.1204E+00,7.6772E+00,8.0838E+00,8.4459E+00,8.6417E+00/
      DATA (KB(JT,55,11),JT=1,5) /
     &6.9256E+00,7.5251E+00,7.9750E+00,8.3203E+00,8.6369E+00/
      DATA (KB(JT,56,11),JT=1,5) /
     &6.7619E+00,7.3247E+00,7.8477E+00,8.2055E+00,8.5418E+00/
      DATA (KB(JT,57,11),JT=1,5) /
     &6.5989E+00,7.1193E+00,7.6865E+00,8.1073E+00,8.4236E+00/
      DATA (KB(JT,58,11),JT=1,5) /
     &6.3964E+00,6.9666E+00,7.5354E+00,7.9999E+00,8.3228E+00/
      DATA (KB(JT,59,11),JT=1,5) /
     &6.3130E+00,6.9330E+00,7.4209E+00,7.9087E+00,8.2712E+00/
      DATA (KB(JT,13,12),JT=1,5) /
     &2.2326E+00,2.2492E+00,2.2166E+00,2.2179E+00,2.3939E+00/
      DATA (KB(JT,14,12),JT=1,5) /
     &2.6624E+00,2.8068E+00,2.8766E+00,2.8509E+00,2.8616E+00/
      DATA (KB(JT,15,12),JT=1,5) /
     &3.7151E+00,3.8338E+00,3.8710E+00,3.8938E+00,4.0387E+00/
      DATA (KB(JT,16,12),JT=1,5) /
     &4.1478E+00,4.2453E+00,4.2845E+00,4.3058E+00,4.4171E+00/
      DATA (KB(JT,17,12),JT=1,5) /
     &4.4594E+00,4.5666E+00,4.6335E+00,4.6600E+00,4.7776E+00/
      DATA (KB(JT,18,12),JT=1,5) /
     &4.8949E+00,5.0141E+00,5.1198E+00,5.1461E+00,5.2514E+00/
      DATA (KB(JT,19,12),JT=1,5) /
     &5.4166E+00,5.5448E+00,5.6541E+00,5.7098E+00,5.7608E+00/
      DATA (KB(JT,20,12),JT=1,5) /
     &5.9687E+00,6.1117E+00,6.2318E+00,6.2991E+00,6.3382E+00/
      DATA (KB(JT,21,12),JT=1,5) /
     &6.5357E+00,6.6891E+00,6.8185E+00,6.8922E+00,6.9339E+00/
      DATA (KB(JT,22,12),JT=1,5) /
     &7.1247E+00,7.2763E+00,7.4121E+00,7.4770E+00,7.5498E+00/
      DATA (KB(JT,23,12),JT=1,5) /
     &7.7039E+00,7.8572E+00,7.9884E+00,8.0284E+00,8.1432E+00/
      DATA (KB(JT,24,12),JT=1,5) /
     &8.2700E+00,8.4098E+00,8.5280E+00,8.5448E+00,8.6892E+00/
      DATA (KB(JT,25,12),JT=1,5) /
     &8.8099E+00,8.9417E+00,9.0327E+00,9.0480E+00,9.1843E+00/
      DATA (KB(JT,26,12),JT=1,5) /
     &9.3282E+00,9.4425E+00,9.5016E+00,9.4918E+00,9.6320E+00/
      DATA (KB(JT,27,12),JT=1,5) /
     &9.8120E+00,9.9020E+00,9.8963E+00,9.9235E+00,1.0029E+01/
      DATA (KB(JT,28,12),JT=1,5) /
     &1.0246E+01,1.0311E+01,1.0256E+01,1.0345E+01,1.0401E+01/
      DATA (KB(JT,29,12),JT=1,5) /
     &1.0631E+01,1.0621E+01,1.0577E+01,1.0691E+01,1.0719E+01/
      DATA (KB(JT,30,12),JT=1,5) /
     &1.0962E+01,1.0883E+01,1.0936E+01,1.0968E+01,1.0995E+01/
      DATA (KB(JT,31,12),JT=1,5) /
     &1.1183E+01,1.1144E+01,1.1216E+01,1.1241E+01,1.1250E+01/
      DATA (KB(JT,32,12),JT=1,5) /
     &1.1390E+01,1.1439E+01,1.1434E+01,1.1471E+01,1.1430E+01/
      DATA (KB(JT,33,12),JT=1,5) /
     &1.1588E+01,1.1624E+01,1.1599E+01,1.1614E+01,1.1630E+01/
      DATA (KB(JT,34,12),JT=1,5) /
     &1.1823E+01,1.1780E+01,1.1748E+01,1.1805E+01,1.1825E+01/
      DATA (KB(JT,35,12),JT=1,5) /
     &1.1935E+01,1.1885E+01,1.1934E+01,1.1981E+01,1.2011E+01/
      DATA (KB(JT,36,12),JT=1,5) /
     &1.2055E+01,1.2055E+01,1.2092E+01,1.2129E+01,1.2083E+01/
      DATA (KB(JT,37,12),JT=1,5) /
     &1.2143E+01,1.2189E+01,1.2217E+01,1.2211E+01,1.2038E+01/
      DATA (KB(JT,38,12),JT=1,5) /
     &1.2240E+01,1.2287E+01,1.2320E+01,1.2293E+01,1.1958E+01/
      DATA (KB(JT,39,12),JT=1,5) /
     &1.2384E+01,1.2401E+01,1.2395E+01,1.2388E+01,1.1943E+01/
      DATA (KB(JT,40,12),JT=1,5) /
     &1.2464E+01,1.2479E+01,1.2477E+01,1.2446E+01,1.2032E+01/
      DATA (KB(JT,41,12),JT=1,5) /
     &1.2528E+01,1.2533E+01,1.2534E+01,1.2503E+01,1.2103E+01/
      DATA (KB(JT,42,12),JT=1,5) /
     &1.2585E+01,1.2609E+01,1.2591E+01,1.2562E+01,1.2170E+01/
      DATA (KB(JT,43,12),JT=1,5) /
     &1.2648E+01,1.2666E+01,1.2643E+01,1.2594E+01,1.2252E+01/
      DATA (KB(JT,44,12),JT=1,5) /
     &1.2682E+01,1.2728E+01,1.2701E+01,1.2655E+01,1.2340E+01/
      DATA (KB(JT,45,12),JT=1,5) /
     &1.2706E+01,1.2763E+01,1.2739E+01,1.2702E+01,1.2417E+01/
      DATA (KB(JT,46,12),JT=1,5) /
     &1.2744E+01,1.2798E+01,1.2795E+01,1.2773E+01,1.2516E+01/
      DATA (KB(JT,47,12),JT=1,5) /
     &1.2744E+01,1.2852E+01,1.2846E+01,1.2816E+01,1.2652E+01/
      DATA (KB(JT,48,12),JT=1,5) /
     &1.2714E+01,1.2860E+01,1.2886E+01,1.2860E+01,1.2772E+01/
      DATA (KB(JT,49,12),JT=1,5) /
     &1.2667E+01,1.2862E+01,1.2927E+01,1.2926E+01,1.2873E+01/
      DATA (KB(JT,50,12),JT=1,5) /
     &1.2568E+01,1.2858E+01,1.2953E+01,1.2955E+01,1.2993E+01/
      DATA (KB(JT,51,12),JT=1,5) /
     &1.2506E+01,1.2803E+01,1.2982E+01,1.2983E+01,1.3071E+01/
      DATA (KB(JT,52,12),JT=1,5) /
     &1.2444E+01,1.2786E+01,1.2969E+01,1.3005E+01,1.3112E+01/
      DATA (KB(JT,53,12),JT=1,5) /
     &1.2352E+01,1.2737E+01,1.2961E+01,1.3024E+01,1.3150E+01/
      DATA (KB(JT,54,12),JT=1,5) /
     &1.2273E+01,1.2640E+01,1.2911E+01,1.3015E+01,1.3144E+01/
      DATA (KB(JT,55,12),JT=1,5) /
     &1.2241E+01,1.2456E+01,1.2830E+01,1.3015E+01,1.3103E+01/
      DATA (KB(JT,56,12),JT=1,5) /
     &1.2129E+01,1.2403E+01,1.2744E+01,1.2955E+01,1.3054E+01/
      DATA (KB(JT,57,12),JT=1,5) /
     &1.1983E+01,1.2327E+01,1.2603E+01,1.2910E+01,1.3056E+01/
      DATA (KB(JT,58,12),JT=1,5) /
     &1.1825E+01,1.2269E+01,1.2506E+01,1.2817E+01,1.3023E+01/
      DATA (KB(JT,59,12),JT=1,5) /
     &1.1756E+01,1.2243E+01,1.2496E+01,1.2736E+01,1.2923E+01/
      DATA (KB(JT,13,13),JT=1,5) /
     &2.4382E+00,2.5269E+00,2.6487E+00,2.6115E+00,2.6014E+00/
      DATA (KB(JT,14,13),JT=1,5) /
     &3.1530E+00,3.3624E+00,3.5863E+00,3.8586E+00,4.4708E+00/
      DATA (KB(JT,15,13),JT=1,5) /
     &5.2015E+00,5.3405E+00,5.5020E+00,5.5114E+00,5.5124E+00/
      DATA (KB(JT,16,13),JT=1,5) /
     &5.7225E+00,5.8966E+00,6.0571E+00,6.0559E+00,6.0668E+00/
      DATA (KB(JT,17,13),JT=1,5) /
     &6.2716E+00,6.4422E+00,6.5990E+00,6.6435E+00,6.5757E+00/
      DATA (KB(JT,18,13),JT=1,5) /
     &6.7715E+00,6.9371E+00,7.0939E+00,7.1586E+00,7.0596E+00/
      DATA (KB(JT,19,13),JT=1,5) /
     &7.2728E+00,7.4403E+00,7.6008E+00,7.7026E+00,7.6789E+00/
      DATA (KB(JT,20,13),JT=1,5) /
     &7.8570E+00,8.0286E+00,8.1992E+00,8.3169E+00,8.3122E+00/
      DATA (KB(JT,21,13),JT=1,5) /
     &8.5574E+00,8.7300E+00,8.9004E+00,9.0231E+00,9.0274E+00/
      DATA (KB(JT,22,13),JT=1,5) /
     &9.3806E+00,9.5518E+00,9.7137E+00,9.8169E+00,9.7877E+00/
      DATA (KB(JT,23,13),JT=1,5) /
     &1.0275E+01,1.0446E+01,1.0597E+01,1.0672E+01,1.0640E+01/
      DATA (KB(JT,24,13),JT=1,5) /
     &1.1189E+01,1.1360E+01,1.1491E+01,1.1535E+01,1.1479E+01/
      DATA (KB(JT,25,13),JT=1,5) /
     &1.2097E+01,1.2245E+01,1.2356E+01,1.2332E+01,1.2284E+01/
      DATA (KB(JT,26,13),JT=1,5) /
     &1.2961E+01,1.3082E+01,1.3167E+01,1.3081E+01,1.3047E+01/
      DATA (KB(JT,27,13),JT=1,5) /
     &1.3759E+01,1.3850E+01,1.3907E+01,1.3774E+01,1.3731E+01/
      DATA (KB(JT,28,13),JT=1,5) /
     &1.4487E+01,1.4544E+01,1.4510E+01,1.4345E+01,1.4410E+01/
      DATA (KB(JT,29,13),JT=1,5) /
     &1.5131E+01,1.5152E+01,1.4989E+01,1.4893E+01,1.4931E+01/
      DATA (KB(JT,30,13),JT=1,5) /
     &1.5691E+01,1.5628E+01,1.5428E+01,1.5458E+01,1.5409E+01/
      DATA (KB(JT,31,13),JT=1,5) /
     &1.6170E+01,1.5957E+01,1.5859E+01,1.5855E+01,1.5824E+01/
      DATA (KB(JT,32,13),JT=1,5) /
     &1.6473E+01,1.6259E+01,1.6330E+01,1.6208E+01,1.6186E+01/
      DATA (KB(JT,33,13),JT=1,5) /
     &1.6723E+01,1.6704E+01,1.6654E+01,1.6563E+01,1.6454E+01/
      DATA (KB(JT,34,13),JT=1,5) /
     &1.6982E+01,1.6991E+01,1.6942E+01,1.6797E+01,1.6670E+01/
      DATA (KB(JT,35,13),JT=1,5) /
     &1.7322E+01,1.7270E+01,1.7135E+01,1.6953E+01,1.6879E+01/
      DATA (KB(JT,36,13),JT=1,5) /
     &1.7562E+01,1.7451E+01,1.7282E+01,1.7228E+01,1.7169E+01/
      DATA (KB(JT,37,13),JT=1,5) /
     &1.7777E+01,1.7615E+01,1.7471E+01,1.7494E+01,1.7411E+01/
      DATA (KB(JT,38,13),JT=1,5) /
     &1.7932E+01,1.7773E+01,1.7733E+01,1.7665E+01,1.7616E+01/
      DATA (KB(JT,39,13),JT=1,5) /
     &1.7993E+01,1.7881E+01,1.7968E+01,1.7898E+01,1.7772E+01/
      DATA (KB(JT,40,13),JT=1,5) /
     &1.8148E+01,1.8027E+01,1.8107E+01,1.8066E+01,1.7907E+01/
      DATA (KB(JT,41,13),JT=1,5) /
     &1.8273E+01,1.8183E+01,1.8251E+01,1.8205E+01,1.8057E+01/
      DATA (KB(JT,42,13),JT=1,5) /
     &1.8408E+01,1.8324E+01,1.8378E+01,1.8322E+01,1.8177E+01/
      DATA (KB(JT,43,13),JT=1,5) /
     &1.8505E+01,1.8424E+01,1.8497E+01,1.8450E+01,1.8293E+01/
      DATA (KB(JT,44,13),JT=1,5) /
     &1.8604E+01,1.8490E+01,1.8578E+01,1.8585E+01,1.8430E+01/
      DATA (KB(JT,45,13),JT=1,5) /
     &1.8704E+01,1.8600E+01,1.8704E+01,1.8731E+01,1.8566E+01/
      DATA (KB(JT,46,13),JT=1,5) /
     &1.8778E+01,1.8729E+01,1.8813E+01,1.8830E+01,1.8670E+01/
      DATA (KB(JT,47,13),JT=1,5) /
     &1.8850E+01,1.8781E+01,1.8910E+01,1.8941E+01,1.8764E+01/
      DATA (KB(JT,48,13),JT=1,5) /
     &1.8986E+01,1.8857E+01,1.8976E+01,1.9005E+01,1.8895E+01/
      DATA (KB(JT,49,13),JT=1,5) /
     &1.9095E+01,1.9011E+01,1.9061E+01,1.9086E+01,1.9025E+01/
      DATA (KB(JT,50,13),JT=1,5) /
     &1.9280E+01,1.9083E+01,1.9157E+01,1.9191E+01,1.9123E+01/
      DATA (KB(JT,51,13),JT=1,5) /
     &1.9385E+01,1.9151E+01,1.9215E+01,1.9259E+01,1.9196E+01/
      DATA (KB(JT,52,13),JT=1,5) /
     &1.9488E+01,1.9188E+01,1.9260E+01,1.9328E+01,1.9259E+01/
      DATA (KB(JT,53,13),JT=1,5) /
     &1.9657E+01,1.9231E+01,1.9381E+01,1.9391E+01,1.9331E+01/
      DATA (KB(JT,54,13),JT=1,5) /
     &1.9810E+01,1.9362E+01,1.9357E+01,1.9443E+01,1.9402E+01/
      DATA (KB(JT,55,13),JT=1,5) /
     &1.9885E+01,1.9515E+01,1.9337E+01,1.9415E+01,1.9400E+01/
      DATA (KB(JT,56,13),JT=1,5) /
     &1.9952E+01,1.9629E+01,1.9325E+01,1.9383E+01,1.9431E+01/
      DATA (KB(JT,57,13),JT=1,5) /
     &2.0005E+01,1.9822E+01,1.9466E+01,1.9235E+01,1.9419E+01/
      DATA (KB(JT,58,13),JT=1,5) /
     &2.0044E+01,1.9891E+01,1.9520E+01,1.9352E+01,1.9344E+01/
      DATA (KB(JT,59,13),JT=1,5) /
     &2.0058E+01,1.9920E+01,1.9627E+01,1.9319E+01,1.9225E+01/
      DATA (KB(JT,13,14),JT=1,5) /
     &3.1216E+00,3.1914E+00,3.0899E+00,3.3224E+00,4.2010E+00/
      DATA (KB(JT,14,14),JT=1,5) /
     &7.0173E+00,7.2031E+00,7.3581E+00,7.0289E+00,6.9115E+00/
      DATA (KB(JT,15,14),JT=1,5) /
     &7.9333E+00,8.1347E+00,8.2980E+00,8.2914E+00,7.9259E+00/
      DATA (KB(JT,16,14),JT=1,5) /
     &8.8725E+00,9.0683E+00,9.2568E+00,9.4307E+00,9.0182E+00/
      DATA (KB(JT,17,14),JT=1,5) /
     &9.8363E+00,1.0075E+01,1.0298E+01,1.0509E+01,1.0358E+01/
      DATA (KB(JT,18,14),JT=1,5) /
     &1.0886E+01,1.1174E+01,1.1435E+01,1.1674E+01,1.1694E+01/
      DATA (KB(JT,19,14),JT=1,5) /
     &1.2011E+01,1.2333E+01,1.2632E+01,1.2897E+01,1.3012E+01/
      DATA (KB(JT,20,14),JT=1,5) /
     &1.3190E+01,1.3540E+01,1.3861E+01,1.4163E+01,1.4313E+01/
      DATA (KB(JT,21,14),JT=1,5) /
     &1.4385E+01,1.4764E+01,1.5119E+01,1.5437E+01,1.5593E+01/
      DATA (KB(JT,22,14),JT=1,5) /
     &1.5599E+01,1.6013E+01,1.6388E+01,1.6714E+01,1.6844E+01/
      DATA (KB(JT,23,14),JT=1,5) /
     &1.6855E+01,1.7274E+01,1.7644E+01,1.7957E+01,1.7983E+01/
      DATA (KB(JT,24,14),JT=1,5) /
     &1.8152E+01,1.8541E+01,1.8882E+01,1.9172E+01,1.9130E+01/
      DATA (KB(JT,25,14),JT=1,5) /
     &1.9440E+01,1.9782E+01,2.0084E+01,2.0333E+01,2.0194E+01/
      DATA (KB(JT,26,14),JT=1,5) /
     &2.0688E+01,2.0983E+01,2.1232E+01,2.1433E+01,2.1144E+01/
      DATA (KB(JT,27,14),JT=1,5) /
     &2.1870E+01,2.2106E+01,2.2296E+01,2.2344E+01,2.1989E+01/
      DATA (KB(JT,28,14),JT=1,5) /
     &2.2959E+01,2.3128E+01,2.3255E+01,2.3127E+01,2.2540E+01/
      DATA (KB(JT,29,14),JT=1,5) /
     &2.3936E+01,2.4040E+01,2.4108E+01,2.3686E+01,2.3118E+01/
      DATA (KB(JT,30,14),JT=1,5) /
     &2.4794E+01,2.4831E+01,2.4631E+01,2.3967E+01,2.3807E+01/
      DATA (KB(JT,31,14),JT=1,5) /
     &2.5525E+01,2.5458E+01,2.4921E+01,2.4395E+01,2.4482E+01/
      DATA (KB(JT,32,14),JT=1,5) /
     &2.6140E+01,2.5757E+01,2.4988E+01,2.5111E+01,2.5399E+01/
      DATA (KB(JT,33,14),JT=1,5) /
     &2.6507E+01,2.5703E+01,2.5535E+01,2.5869E+01,2.6121E+01/
      DATA (KB(JT,34,14),JT=1,5) /
     &2.6569E+01,2.5953E+01,2.6151E+01,2.6361E+01,2.6801E+01/
      DATA (KB(JT,35,14),JT=1,5) /
     &2.6562E+01,2.6504E+01,2.6810E+01,2.7029E+01,2.7434E+01/
      DATA (KB(JT,36,14),JT=1,5) /
     &2.6827E+01,2.6824E+01,2.7232E+01,2.7537E+01,2.7695E+01/
      DATA (KB(JT,37,14),JT=1,5) /
     &2.7090E+01,2.7286E+01,2.7649E+01,2.7765E+01,2.8180E+01/
      DATA (KB(JT,38,14),JT=1,5) /
     &2.7488E+01,2.7623E+01,2.7893E+01,2.8192E+01,2.8556E+01/
      DATA (KB(JT,39,14),JT=1,5) /
     &2.7778E+01,2.8122E+01,2.8064E+01,2.8480E+01,2.8841E+01/
      DATA (KB(JT,40,14),JT=1,5) /
     &2.8002E+01,2.8307E+01,2.8286E+01,2.8653E+01,2.9020E+01/
      DATA (KB(JT,41,14),JT=1,5) /
     &2.8205E+01,2.8457E+01,2.8430E+01,2.8865E+01,2.9164E+01/
      DATA (KB(JT,42,14),JT=1,5) /
     &2.8421E+01,2.8563E+01,2.8567E+01,2.9033E+01,2.9360E+01/
      DATA (KB(JT,43,14),JT=1,5) /
     &2.8605E+01,2.8649E+01,2.8746E+01,2.9195E+01,2.9582E+01/
      DATA (KB(JT,44,14),JT=1,5) /
     &2.8719E+01,2.8847E+01,2.8915E+01,2.9326E+01,2.9712E+01/
      DATA (KB(JT,45,14),JT=1,5) /
     &2.9008E+01,2.9000E+01,2.9085E+01,2.9440E+01,2.9882E+01/
      DATA (KB(JT,46,14),JT=1,5) /
     &2.9283E+01,2.9066E+01,2.9214E+01,2.9505E+01,3.0075E+01/
      DATA (KB(JT,47,14),JT=1,5) /
     &2.9505E+01,2.9215E+01,2.9192E+01,2.9549E+01,3.0231E+01/
      DATA (KB(JT,48,14),JT=1,5) /
     &2.9847E+01,2.9465E+01,2.9377E+01,2.9796E+01,3.0530E+01/
      DATA (KB(JT,49,14),JT=1,5) /
     &3.0209E+01,2.9590E+01,2.9613E+01,2.9947E+01,3.0891E+01/
      DATA (KB(JT,50,14),JT=1,5) /
     &3.0555E+01,2.9682E+01,2.9721E+01,3.0034E+01,3.0987E+01/
      DATA (KB(JT,51,14),JT=1,5) /
     &3.0932E+01,2.9941E+01,2.9791E+01,3.0042E+01,3.0973E+01/
      DATA (KB(JT,52,14),JT=1,5) /
     &3.1304E+01,3.0128E+01,2.9896E+01,3.0085E+01,3.1235E+01/
      DATA (KB(JT,53,14),JT=1,5) /
     &3.1593E+01,3.0463E+01,3.0008E+01,3.0297E+01,3.1448E+01/
      DATA (KB(JT,54,14),JT=1,5) /
     &3.1880E+01,3.0666E+01,3.0079E+01,3.0245E+01,3.1244E+01/
      DATA (KB(JT,55,14),JT=1,5) /
     &3.2179E+01,3.1215E+01,3.0197E+01,3.0244E+01,3.0630E+01/
      DATA (KB(JT,56,14),JT=1,5) /
     &3.2496E+01,3.1618E+01,3.0405E+01,3.0157E+01,3.0368E+01/
      DATA (KB(JT,57,14),JT=1,5) /
     &3.2846E+01,3.1885E+01,3.0675E+01,3.0336E+01,3.0326E+01/
      DATA (KB(JT,58,14),JT=1,5) /
     &3.3194E+01,3.2160E+01,3.1205E+01,3.0229E+01,3.0346E+01/
      DATA (KB(JT,59,14),JT=1,5) /
     &3.3342E+01,3.2279E+01,3.1453E+01,3.0328E+01,3.0152E+01/
      DATA (KB(JT,13,15),JT=1,5) /
     &4.0030E+00,4.7414E+00,5.8560E+00,6.7438E+00,3.2808E+00/
      DATA (KB(JT,14,15),JT=1,5) /
     &9.0899E+00,9.4664E+00,9.7823E+00,1.0059E+01,8.9794E+00/
      DATA (KB(JT,15,15),JT=1,5) /
     &1.0857E+01,1.1261E+01,1.1617E+01,1.1923E+01,1.1563E+01/
      DATA (KB(JT,16,15),JT=1,5) /
     &1.2889E+01,1.3334E+01,1.3725E+01,1.4064E+01,1.4341E+01/
      DATA (KB(JT,17,15),JT=1,5) /
     &1.5204E+01,1.5687E+01,1.6115E+01,1.6474E+01,1.6771E+01/
      DATA (KB(JT,18,15),JT=1,5) /
     &1.7808E+01,1.8322E+01,1.8770E+01,1.9149E+01,1.9438E+01/
      DATA (KB(JT,19,15),JT=1,5) /
     &2.0675E+01,2.1216E+01,2.1671E+01,2.2040E+01,2.2294E+01/
      DATA (KB(JT,20,15),JT=1,5) /
     &2.3784E+01,2.4335E+01,2.4780E+01,2.5092E+01,2.5318E+01/
      DATA (KB(JT,21,15),JT=1,5) /
     &2.7074E+01,2.7616E+01,2.7992E+01,2.8260E+01,2.8435E+01/
      DATA (KB(JT,22,15),JT=1,5) /
     &3.0512E+01,3.0967E+01,3.1281E+01,3.1482E+01,3.1588E+01/
      DATA (KB(JT,23,15),JT=1,5) /
     &3.3946E+01,3.4307E+01,3.4554E+01,3.4683E+01,3.4702E+01/
      DATA (KB(JT,24,15),JT=1,5) /
     &3.7353E+01,3.7642E+01,3.7797E+01,3.7830E+01,3.7737E+01/
      DATA (KB(JT,25,15),JT=1,5) /
     &4.0725E+01,4.0910E+01,4.0948E+01,4.0847E+01,4.0612E+01/
      DATA (KB(JT,26,15),JT=1,5) /
     &4.3991E+01,4.4018E+01,4.3898E+01,4.3642E+01,4.3255E+01/
      DATA (KB(JT,27,15),JT=1,5) /
     &4.7033E+01,4.6887E+01,4.6594E+01,4.6165E+01,4.5614E+01/
      DATA (KB(JT,28,15),JT=1,5) /
     &4.9783E+01,4.9454E+01,4.8983E+01,4.8387E+01,4.7672E+01/
      DATA (KB(JT,29,15),JT=1,5) /
     &5.2209E+01,5.1689E+01,5.1048E+01,5.0282E+01,4.9143E+01/
      DATA (KB(JT,30,15),JT=1,5) /
     &5.4285E+01,5.3590E+01,5.2778E+01,5.1862E+01,4.9504E+01/
      DATA (KB(JT,31,15),JT=1,5) /
     &5.6017E+01,5.5158E+01,5.4192E+01,5.2520E+01,4.8958E+01/
      DATA (KB(JT,32,15),JT=1,5) /
     &5.7422E+01,5.6414E+01,5.5126E+01,5.1643E+01,4.7729E+01/
      DATA (KB(JT,33,15),JT=1,5) /
     &5.8538E+01,5.7396E+01,5.4438E+01,4.9797E+01,4.8468E+01/
      DATA (KB(JT,34,15),JT=1,5) /
     &5.9425E+01,5.7428E+01,5.3101E+01,5.0744E+01,5.0414E+01/
      DATA (KB(JT,35,15),JT=1,5) /
     &6.0220E+01,5.6550E+01,5.2246E+01,5.2031E+01,5.2160E+01/
      DATA (KB(JT,36,15),JT=1,5) /
     &6.0380E+01,5.6323E+01,5.3290E+01,5.3091E+01,5.1837E+01/
      DATA (KB(JT,37,15),JT=1,5) /
     &6.1064E+01,5.6288E+01,5.3962E+01,5.4330E+01,5.1190E+01/
      DATA (KB(JT,38,15),JT=1,5) /
     &6.1244E+01,5.6422E+01,5.4974E+01,5.5783E+01,5.0823E+01/
      DATA (KB(JT,39,15),JT=1,5) /
     &6.1491E+01,5.6521E+01,5.6495E+01,5.7139E+01,5.0363E+01/
      DATA (KB(JT,40,15),JT=1,5) /
     &6.2285E+01,5.7310E+01,5.7143E+01,5.8068E+01,5.1166E+01/
      DATA (KB(JT,41,15),JT=1,5) /
     &6.3214E+01,5.7786E+01,5.7889E+01,5.8807E+01,5.2057E+01/
      DATA (KB(JT,42,15),JT=1,5) /
     &6.3921E+01,5.8540E+01,5.8564E+01,5.9508E+01,5.2732E+01/
      DATA (KB(JT,43,15),JT=1,5) /
     &6.4936E+01,5.9750E+01,5.9252E+01,6.0188E+01,5.3641E+01/
      DATA (KB(JT,44,15),JT=1,5) /
     &6.6180E+01,6.0810E+01,5.9653E+01,6.1132E+01,5.4737E+01/
      DATA (KB(JT,45,15),JT=1,5) /
     &6.6949E+01,6.1798E+01,5.9966E+01,6.1660E+01,5.5582E+01/
      DATA (KB(JT,46,15),JT=1,5) /
     &6.7824E+01,6.2979E+01,6.0686E+01,6.2546E+01,5.6565E+01/
      DATA (KB(JT,47,15),JT=1,5) /
     &6.9039E+01,6.4342E+01,6.1803E+01,6.2906E+01,5.8086E+01/
      DATA (KB(JT,48,15),JT=1,5) /
     &6.9761E+01,6.5409E+01,6.2421E+01,6.3565E+01,5.8945E+01/
      DATA (KB(JT,49,15),JT=1,5) /
     &7.0431E+01,6.6423E+01,6.3050E+01,6.4501E+01,5.9296E+01/
      DATA (KB(JT,50,15),JT=1,5) /
     &7.1030E+01,6.7738E+01,6.3115E+01,6.5100E+01,6.0669E+01/
      DATA (KB(JT,51,15),JT=1,5) /
     &7.1594E+01,6.8849E+01,6.3996E+01,6.5429E+01,6.2495E+01/
      DATA (KB(JT,52,15),JT=1,5) /
     &7.2143E+01,7.0005E+01,6.4776E+01,6.5575E+01,6.3548E+01/
      DATA (KB(JT,53,15),JT=1,5) /
     &7.2670E+01,7.0732E+01,6.5046E+01,6.6263E+01,6.4505E+01/
      DATA (KB(JT,54,15),JT=1,5) /
     &7.3127E+01,7.1823E+01,6.6914E+01,6.6275E+01,6.7029E+01/
      DATA (KB(JT,55,15),JT=1,5) /
     &7.3553E+01,7.2289E+01,6.8950E+01,6.5529E+01,6.7722E+01/
      DATA (KB(JT,56,15),JT=1,5) /
     &7.3983E+01,7.2738E+01,7.0656E+01,6.5646E+01,6.6961E+01/
      DATA (KB(JT,57,15),JT=1,5) /
     &7.4388E+01,7.3166E+01,7.1848E+01,6.6976E+01,6.6137E+01/
      DATA (KB(JT,58,15),JT=1,5) /
     &7.4771E+01,7.3567E+01,7.2279E+01,6.9020E+01,6.5380E+01/
      DATA (KB(JT,59,15),JT=1,5) /
     &7.4949E+01,7.3730E+01,7.2460E+01,7.0691E+01,6.5332E+01/
      DATA (KB(JT,13,16),JT=1,5) /
     &5.0420E+00,8.6337E+00,8.8692E+00,1.2195E+00,9.3776E-01/
      DATA (KB(JT,14,16),JT=1,5) /
     &1.0108E+01,1.0449E+01,1.0740E+01,1.1004E+01,9.1915E-01/
      DATA (KB(JT,15,16),JT=1,5) /
     &1.2227E+01,1.2648E+01,1.3007E+01,1.3327E+01,1.3667E+01/
      DATA (KB(JT,16,16),JT=1,5) /
     &1.4789E+01,1.5299E+01,1.5728E+01,1.6109E+01,1.6498E+01/
      DATA (KB(JT,17,16),JT=1,5) /
     &1.7862E+01,1.8466E+01,1.8964E+01,1.9401E+01,1.9824E+01/
      DATA (KB(JT,18,16),JT=1,5) /
     &2.1506E+01,2.2192E+01,2.2762E+01,2.3238E+01,2.3665E+01/
      DATA (KB(JT,19,16),JT=1,5) /
     &2.5786E+01,2.6523E+01,2.7142E+01,2.7627E+01,2.8030E+01/
      DATA (KB(JT,20,16),JT=1,5) /
     &3.0723E+01,3.1489E+01,3.2109E+01,3.2556E+01,3.2877E+01/
      DATA (KB(JT,21,16),JT=1,5) /
     &3.6293E+01,3.7031E+01,3.7583E+01,3.7941E+01,3.8130E+01/
      DATA (KB(JT,22,16),JT=1,5) /
     &4.2493E+01,4.3104E+01,4.3485E+01,4.3668E+01,4.3655E+01/
      DATA (KB(JT,23,16),JT=1,5) /
     &4.9099E+01,4.9493E+01,4.9618E+01,4.9538E+01,4.9251E+01/
      DATA (KB(JT,24,16),JT=1,5) /
     &5.5931E+01,5.5983E+01,5.5792E+01,5.5378E+01,5.4757E+01/
      DATA (KB(JT,25,16),JT=1,5) /
     &6.2744E+01,6.2387E+01,6.1774E+01,6.0982E+01,5.9987E+01/
      DATA (KB(JT,26,16),JT=1,5) /
     &6.9294E+01,6.8455E+01,6.7400E+01,6.6158E+01,6.4771E+01/
      DATA (KB(JT,27,16),JT=1,5) /
     &7.5369E+01,7.4018E+01,7.2501E+01,7.0820E+01,6.9030E+01/
      DATA (KB(JT,28,16),JT=1,5) /
     &8.0847E+01,7.8971E+01,7.6973E+01,7.4879E+01,7.2699E+01/
      DATA (KB(JT,29,16),JT=1,5) /
     &8.5588E+01,8.3223E+01,8.0777E+01,7.8292E+01,7.5762E+01/
      DATA (KB(JT,30,16),JT=1,5) /
     &8.9575E+01,8.6758E+01,8.3320E+01,8.1073E+01,7.8238E+01/
      DATA (KB(JT,31,16),JT=1,5) /
     &9.2801E+01,8.9596E+01,8.6404E+01,8.3251E+01,8.0171E+01/
      DATA (KB(JT,32,16),JT=1,5) /
     &9.5328E+01,9.1774E+01,8.8298E+01,8.4902E+01,7.6985E+01/
      DATA (KB(JT,33,16),JT=1,5) /
     &9.7221E+01,9.3383E+01,8.9667E+01,8.6065E+01,5.8850E+01/
      DATA (KB(JT,34,16),JT=1,5) /
     &9.8688E+01,9.4629E+01,9.0722E+01,7.0430E+01,3.0605E+01/
      DATA (KB(JT,35,16),JT=1,5) /
     &1.0011E+02,9.5862E+01,8.7207E+01,5.0589E+01,4.4567E+00/
      DATA (KB(JT,36,16),JT=1,5) /
     &1.0168E+02,9.7257E+01,7.6588E+01,3.3945E+01,3.3821E-01/
      DATA (KB(JT,37,16),JT=1,5) /
     &1.0369E+02,9.9078E+01,7.2492E+01,2.6526E+01,3.3765E-01/
      DATA (KB(JT,38,16),JT=1,5) /
     &1.0555E+02,1.0077E+02,6.5594E+01,1.3779E+01,3.3740E-01/
      DATA (KB(JT,39,16),JT=1,5) /
     &1.0726E+02,9.7866E+01,5.5055E+01,3.4196E-01,3.3714E-01/
      DATA (KB(JT,40,16),JT=1,5) /
     &1.0936E+02,1.0037E+02,5.6740E+01,3.4227E-01,3.3798E-01/
      DATA (KB(JT,41,16),JT=1,5) /
     &1.1147E+02,1.0552E+02,5.9119E+01,1.0312E+00,3.3873E-01/
      DATA (KB(JT,42,16),JT=1,5) /
     &1.1349E+02,1.0806E+02,6.1522E+01,2.4025E+00,3.3958E-01/
      DATA (KB(JT,43,16),JT=1,5) /
     &1.1581E+02,1.1021E+02,6.4818E+01,5.9686E+00,3.4048E-01/
      DATA (KB(JT,44,16),JT=1,5) /
     &1.1830E+02,1.1248E+02,7.1730E+01,8.2150E+00,3.4135E-01/
      DATA (KB(JT,45,16),JT=1,5) /
     &1.2075E+02,1.1473E+02,7.7444E+01,1.2041E+01,3.1303E-01/
      DATA (KB(JT,46,16),JT=1,5) /
     &1.2335E+02,1.1716E+02,8.1949E+01,1.5245E+01,3.1351E-01/
      DATA (KB(JT,47,16),JT=1,5) /
     &1.2629E+02,1.1987E+02,8.8206E+01,2.5272E+01,3.1369E-01/
      DATA (KB(JT,48,16),JT=1,5) /
     &1.2931E+02,1.2262E+02,9.4686E+01,2.9706E+01,3.1394E-01/
      DATA (KB(JT,49,16),JT=1,5) /
     &1.3237E+02,1.2544E+02,9.8342E+01,3.1959E+01,3.1361E-01/
      DATA (KB(JT,50,16),JT=1,5) /
     &1.3530E+02,1.2816E+02,1.0881E+02,3.8226E+01,3.1326E-01/
      DATA (KB(JT,51,16),JT=1,5) /
     &1.3828E+02,1.3089E+02,1.1491E+02,4.8666E+01,3.1193E-01/
      DATA (KB(JT,52,16),JT=1,5) /
     &1.4134E+02,1.3361E+02,1.2195E+02,5.9393E+01,3.1051E-01/
      DATA (KB(JT,53,16),JT=1,5) /
     &1.4442E+02,1.3646E+02,1.2918E+02,6.3097E+01,3.0922E-01/
      DATA (KB(JT,54,16),JT=1,5) /
     &1.4741E+02,1.3916E+02,1.3165E+02,7.8318E+01,3.0699E-01/
      DATA (KB(JT,55,16),JT=1,5) /
     &1.5037E+02,1.4182E+02,1.3403E+02,1.0259E+02,2.6611E+01/
      DATA (KB(JT,56,16),JT=1,5) /
     &1.5341E+02,1.4449E+02,1.3650E+02,1.2291E+02,5.4887E+01/
      DATA (KB(JT,57,16),JT=1,5) /
     &1.5661E+02,1.4731E+02,1.3904E+02,1.3152E+02,7.9860E+01/
      DATA (KB(JT,58,16),JT=1,5) /
     &1.5976E+02,1.5007E+02,1.4153E+02,1.3378E+02,1.0477E+02/
      DATA (KB(JT,59,16),JT=1,5) /
     &1.6110E+02,1.5124E+02,1.4255E+02,1.3470E+02,1.2755E+02/

C     The array KA_Mxx contains the absorption coefficient for 
C     a minor species at the 16 chosen g-values for a reference pressure
C     level below 100~ mb.   The first index refers to temperature 
C     in 7.2 degree increments.  For instance, JT = 1 refers to a 
C     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
C     runs over the g-channel (1 to 16).

      DATA (KA_MCO2(JT, 1),JT=1,19)  /
     & 8.88964e-07, 1.13087e-06, 1.43861e-06, 1.83010e-06, 2.32811e-06,
     & 2.96165e-06, 3.76760e-06, 4.79286e-06, 6.09712e-06, 7.75630e-06,
     & 9.86699e-06, 1.25521e-05, 1.59678e-05, 2.03130e-05, 2.58407e-05,
     & 3.28727e-05, 4.18182e-05, 5.31980e-05, 6.76745e-05/
      DATA (KA_MCO2(JT, 2),JT=1,19)  /
     & 1.10492e-05, 1.35003e-05, 1.64952e-05, 2.01545e-05, 2.46256e-05,
     & 3.00885e-05, 3.67632e-05, 4.49188e-05, 5.48835e-05, 6.70588e-05,
     & 8.19351e-05, 1.00111e-04, 1.22320e-04, 1.49455e-04, 1.82610e-04,
     & 2.23121e-04, 2.72618e-04, 3.33095e-04, 4.06988e-04/
      DATA (KA_MCO2(JT, 3),JT=1,19)  /
     & 1.51034e-05, 1.81249e-05, 2.17508e-05, 2.61020e-05, 3.13238e-05,
     & 3.75901e-05, 4.51101e-05, 5.41344e-05, 6.49640e-05, 7.79601e-05,
     & 9.35562e-05, 1.12272e-04, 1.34732e-04, 1.61686e-04, 1.94031e-04,
     & 2.32847e-04, 2.79429e-04, 3.35329e-04, 4.02411e-04/
      DATA (KA_MCO2(JT, 4),JT=1,19)  /
     & 1.57088e-05, 1.89537e-05, 2.28688e-05, 2.75928e-05, 3.32924e-05,
     & 4.01695e-05, 4.84671e-05, 5.84787e-05, 7.05584e-05, 8.51332e-05,
     & 1.02719e-04, 1.23937e-04, 1.49538e-04, 1.80427e-04, 2.17697e-04,
     & 2.62666e-04, 3.16923e-04, 3.82388e-04, 4.61376e-04/
      DATA (KA_MCO2(JT, 5),JT=1,19)  /
     & 3.09299e-05, 3.73196e-05, 4.50294e-05, 5.43320e-05, 6.55563e-05,
     & 7.90995e-05, 9.54405e-05, 1.15157e-04, 1.38948e-04, 1.67652e-04,
     & 2.02288e-04, 2.44078e-04, 2.94501e-04, 3.55342e-04, 4.28751e-04,
     & 5.17327e-04, 6.24200e-04, 7.53153e-04, 9.08745e-04/
      DATA (KA_MCO2(JT, 6),JT=1,19)  /
     & 1.98653e-05, 2.38878e-05, 2.87248e-05, 3.45413e-05, 4.15355e-05,
     & 4.99459e-05, 6.00593e-05, 7.22206e-05, 8.68445e-05, 1.04429e-04,
     & 1.25575e-04, 1.51003e-04, 1.81579e-04, 2.18346e-04, 2.62559e-04,
     & 3.15724e-04, 3.79654e-04, 4.56529e-04, 5.48971e-04/
      DATA (KA_MCO2(JT, 7),JT=1,19)  /
     & 1.54276e-06, 1.90144e-06, 2.34351e-06, 2.88836e-06, 3.55989e-06,
     & 4.38754e-06, 5.40761e-06, 6.66485e-06, 8.21439e-06, 1.01242e-05,
     & 1.24780e-05, 1.53790e-05, 1.89546e-05, 2.33614e-05, 2.87928e-05,
     & 3.54869e-05, 4.37374e-05, 5.39060e-05, 6.64388e-05/
      DATA (KA_MCO2(JT, 8),JT=1,19)  /
     & 1.66907e-06, 2.11106e-06, 2.67008e-06, 3.37714e-06, 4.27143e-06,
     & 5.40254e-06, 6.83318e-06, 8.64266e-06, 1.09313e-05, 1.38260e-05,
     & 1.74872e-05, 2.21180e-05, 2.79750e-05, 3.53830e-05, 4.47527e-05,
     & 5.66036e-05, 7.15927e-05, 9.05509e-05, 1.14529e-04/
      DATA (KA_MCO2(JT, 9),JT=1,19)  /
     & 1.22817e-06, 1.56416e-06, 1.99206e-06, 2.53703e-06, 3.23108e-06,
     & 4.11501e-06, 5.24074e-06, 6.67445e-06, 8.50037e-06, 1.08258e-05,
     & 1.37874e-05, 1.75592e-05, 2.23629e-05, 2.84807e-05, 3.62721e-05,
     & 4.61950e-05, 5.88325e-05, 7.49272e-05, 9.54249e-05/
      DATA (KA_MCO2(JT,10),JT=1,19)  /
     & 3.45943e-08, 3.84726e-08, 4.27856e-08, 4.75821e-08, 5.29164e-08,
     & 5.88487e-08, 6.54460e-08, 7.27829e-08, 8.09423e-08, 9.00164e-08,
     & 1.00108e-07, 1.11331e-07, 1.23811e-07, 1.37691e-07, 1.53128e-07,
     & 1.70294e-07, 1.89385e-07, 2.10616e-07, 2.34228e-07/
      DATA (KA_MCO2(JT,11),JT=1,19)  /
     & 2.89971e-08, 3.35110e-08, 3.87275e-08, 4.47561e-08, 5.17230e-08,
     & 5.97745e-08, 6.90794e-08, 7.98327e-08, 9.22599e-08, 1.06622e-07,
     & 1.23219e-07, 1.42400e-07, 1.64567e-07, 1.90184e-07, 2.19789e-07,
     & 2.54003e-07, 2.93542e-07, 3.39237e-07, 3.92044e-07/
      DATA (KA_MCO2(JT,12),JT=1,19)  /
     & 2.51330e-08, 2.96783e-08, 3.50457e-08, 4.13837e-08, 4.88679e-08,
     & 5.77056e-08, 6.81416e-08, 8.04650e-08, 9.50171e-08, 1.12201e-07,
     & 1.32492e-07, 1.56454e-07, 1.84748e-07, 2.18160e-07, 2.57614e-07,
     & 3.04203e-07, 3.59218e-07, 4.24182e-07, 5.00895e-07/
      DATA (KA_MCO2(JT,13),JT=1,19)  /
     & 1.16966e-07, 1.13960e-07, 1.11032e-07, 1.08179e-07, 1.05400e-07,
     & 1.02691e-07, 1.00053e-07, 9.74820e-08, 9.49772e-08, 9.25368e-08,
     & 9.01591e-08, 8.78425e-08, 8.55854e-08, 8.33863e-08, 8.12437e-08,
     & 7.91562e-08, 7.71223e-08, 7.51407e-08, 7.32100e-08/
      DATA (KA_MCO2(JT,14),JT=1,19)  /
     & 9.17853e-08, 8.94322e-08, 8.71395e-08, 8.49055e-08, 8.27289e-08,
     & 8.06080e-08, 7.85415e-08, 7.65279e-08, 7.45660e-08, 7.26544e-08,
     & 7.07918e-08, 6.89770e-08, 6.72086e-08, 6.54856e-08, 6.38068e-08,
     & 6.21710e-08, 6.05772e-08, 5.90242e-08, 5.75110e-08/
      DATA (KA_MCO2(JT,15),JT=1,19)  /
     & 8.34607e-08, 8.13236e-08, 7.92413e-08, 7.72122e-08, 7.52351e-08,
     & 7.33087e-08, 7.14315e-08, 6.96025e-08, 6.78202e-08, 6.60837e-08,
     & 6.43915e-08, 6.27427e-08, 6.11361e-08, 5.95707e-08, 5.80453e-08,
     & 5.65590e-08, 5.51108e-08, 5.36996e-08, 5.23246e-08/
      DATA (KA_MCO2(JT,16),JT=1,19)  /
     & 8.34607e-08, 8.13236e-08, 7.92413e-08, 7.72122e-08, 7.52351e-08,
     & 7.33087e-08, 7.14315e-08, 6.96025e-08, 6.78202e-08, 6.60837e-08,
     & 6.43915e-08, 6.27427e-08, 6.11361e-08, 5.95707e-08, 5.80453e-08,
     & 5.65590e-08, 5.51108e-08, 5.36996e-08, 5.23246e-08/
       DATA (KA_MO3(JT, 1),JT=1,19)  /
     & 1.18276e-01, 1.18009e-01, 1.17742e-01, 1.17476e-01, 1.17210e-01,
     & 1.16945e-01, 1.16681e-01, 1.16417e-01, 1.16153e-01, 1.15891e-01,
     & 1.15629e-01, 1.15367e-01, 1.15106e-01, 1.14846e-01, 1.14586e-01,
     & 1.14327e-01, 1.14069e-01, 1.13811e-01, 1.13553e-01/
       DATA (KA_MO3(JT, 2),JT=1,19)  /
     & 1.83777e-01, 1.84268e-01, 1.84761e-01, 1.85255e-01, 1.85751e-01,
     & 1.86248e-01, 1.86746e-01, 1.87245e-01, 1.87746e-01, 1.88248e-01,
     & 1.88752e-01, 1.89257e-01, 1.89763e-01, 1.90270e-01, 1.90779e-01,
     & 1.91290e-01, 1.91801e-01, 1.92314e-01, 1.92829e-01/
       DATA (KA_MO3(JT, 3),JT=1,19)  /
     & 2.33414e-01, 2.34511e-01, 2.35614e-01, 2.36722e-01, 2.37836e-01,
     & 2.38954e-01, 2.40078e-01, 2.41207e-01, 2.42342e-01, 2.43481e-01,
     & 2.44626e-01, 2.45777e-01, 2.46933e-01, 2.48094e-01, 2.49261e-01,
     & 2.50433e-01, 2.51611e-01, 2.52794e-01, 2.53983e-01/
       DATA (KA_MO3(JT, 4),JT=1,19)  /
     & 2.84906e-01, 2.87358e-01, 2.89832e-01, 2.92328e-01, 2.94844e-01,
     & 2.97383e-01, 2.99943e-01, 3.02525e-01, 3.05130e-01, 3.07757e-01,
     & 3.10406e-01, 3.13078e-01, 3.15774e-01, 3.18492e-01, 3.21234e-01,
     & 3.24000e-01, 3.26789e-01, 3.29603e-01, 3.32440e-01/
       DATA (KA_MO3(JT, 5),JT=1,19)  /
     & 3.40508e-01, 3.44095e-01, 3.47720e-01, 3.51383e-01, 3.55084e-01,
     & 3.58824e-01, 3.62604e-01, 3.66424e-01, 3.70284e-01, 3.74184e-01,
     & 3.78126e-01, 3.82109e-01, 3.86134e-01, 3.90202e-01, 3.94312e-01,
     & 3.98466e-01, 4.02663e-01, 4.06905e-01, 4.11191e-01/
       DATA (KA_MO3(JT, 6),JT=1,19)  /
     & 3.78368e-01, 3.83690e-01, 3.89086e-01, 3.94558e-01, 4.00107e-01,
     & 4.05735e-01, 4.11441e-01, 4.17227e-01, 4.23095e-01, 4.29046e-01,
     & 4.35080e-01, 4.41199e-01, 4.47404e-01, 4.53697e-01, 4.60078e-01,
     & 4.66548e-01, 4.73110e-01, 4.79764e-01, 4.86511e-01/
       DATA (KA_MO3(JT, 7),JT=1,19)  /
     & 4.51965e-01, 4.58461e-01, 4.65051e-01, 4.71735e-01, 4.78516e-01,
     & 4.85394e-01, 4.92371e-01, 4.99448e-01, 5.06627e-01, 5.13909e-01,
     & 5.21296e-01, 5.28789e-01, 5.36390e-01, 5.44100e-01, 5.51920e-01,
     & 5.59854e-01, 5.67901e-01, 5.76064e-01, 5.84344e-01/
       DATA (KA_MO3(JT, 8),JT=1,19)  /
     & 3.00557e-01, 3.03974e-01, 3.07430e-01, 3.10925e-01, 3.14460e-01,
     & 3.18035e-01, 3.21651e-01, 3.25307e-01, 3.29006e-01, 3.32746e-01,
     & 3.36529e-01, 3.40355e-01, 3.44224e-01, 3.48137e-01, 3.52095e-01,
     & 3.56098e-01, 3.60146e-01, 3.64241e-01, 3.68381e-01/
       DATA (KA_MO3(JT, 9),JT=1,19)  /
     & 2.10042e-01, 2.12905e-01, 2.15806e-01, 2.18748e-01, 2.21729e-01,
     & 2.24751e-01, 2.27814e-01, 2.30919e-01, 2.34066e-01, 2.37256e-01,
     & 2.40489e-01, 2.43767e-01, 2.47089e-01, 2.50457e-01, 2.53870e-01,
     & 2.57330e-01, 2.60837e-01, 2.64392e-01, 2.67996e-01/
       DATA (KA_MO3(JT,10),JT=1,19)  /
     & 2.09288e-01, 2.11759e-01, 2.14259e-01, 2.16789e-01, 2.19349e-01,
     & 2.21939e-01, 2.24559e-01, 2.27210e-01, 2.29893e-01, 2.32607e-01,
     & 2.35354e-01, 2.38133e-01, 2.40944e-01, 2.43789e-01, 2.46667e-01,
     & 2.49580e-01, 2.52527e-01, 2.55508e-01, 2.58525e-01/
       DATA (KA_MO3(JT,11),JT=1,19)  /
     & 2.28947e-01, 2.30609e-01, 2.32283e-01, 2.33969e-01, 2.35667e-01,
     & 2.37378e-01, 2.39101e-01, 2.40836e-01, 2.42584e-01, 2.44345e-01,
     & 2.46118e-01, 2.47905e-01, 2.49704e-01, 2.51516e-01, 2.53342e-01,
     & 2.55181e-01, 2.57033e-01, 2.58899e-01, 2.60778e-01/
       DATA (KA_MO3(JT,12),JT=1,19)  /
     & 2.57263e-01, 2.58272e-01, 2.59285e-01, 2.60302e-01, 2.61323e-01,
     & 2.62347e-01, 2.63376e-01, 2.64409e-01, 2.65446e-01, 2.66487e-01,
     & 2.67532e-01, 2.68581e-01, 2.69635e-01, 2.70692e-01, 2.71753e-01,
     & 2.72819e-01, 2.73889e-01, 2.74963e-01, 2.76042e-01/
       DATA (KA_MO3(JT,13),JT=1,19)  /
     & 2.43322e-01, 2.45918e-01, 2.48541e-01, 2.51192e-01, 2.53872e-01,
     & 2.56580e-01, 2.59317e-01, 2.62083e-01, 2.64879e-01, 2.67704e-01,
     & 2.70560e-01, 2.73446e-01, 2.76363e-01, 2.79311e-01, 2.82290e-01,
     & 2.85302e-01, 2.88345e-01, 2.91421e-01, 2.94529e-01/
       DATA (KA_MO3(JT,14),JT=1,19)  /
     & 2.10568e-01, 2.16529e-01, 2.22660e-01, 2.28964e-01, 2.35446e-01,
     & 2.42113e-01, 2.48967e-01, 2.56016e-01, 2.63265e-01, 2.70719e-01,
     & 2.78383e-01, 2.86265e-01, 2.94370e-01, 3.02704e-01, 3.11275e-01,
     & 3.20088e-01, 3.29150e-01, 3.38470e-01, 3.48052e-01/
       DATA (KA_MO3(JT,15),JT=1,19)  /
     & 2.60406e-02, 2.78779e-02, 2.98448e-02, 3.19505e-02, 3.42048e-02,
     & 3.66181e-02, 3.92017e-02, 4.19675e-02, 4.49285e-02, 4.80985e-02,
     & 5.14920e-02, 5.51250e-02, 5.90143e-02, 6.31781e-02, 6.76356e-02,
     & 7.24076e-02, 7.75163e-02, 8.29854e-02, 8.88404e-02/
       DATA (KA_MO3(JT,16),JT=1,19)  /
     & 2.31483e-02, 2.46840e-02, 2.63217e-02, 2.80681e-02, 2.99302e-02,
     & 3.19160e-02, 3.40335e-02, 3.62914e-02, 3.86992e-02, 4.12668e-02,
     & 4.40046e-02, 4.69242e-02, 5.00374e-02, 5.33571e-02, 5.68971e-02,
     & 6.06720e-02, 6.46974e-02, 6.89897e-02, 7.35669e-02/
      DATA (KA_MN2O(JT, 1),JT=1,19)  /
     & 3.02276e-02, 3.10321e-02, 3.18580e-02, 3.27059e-02, 3.35764e-02,
     & 3.44700e-02, 3.53875e-02, 3.63293e-02, 3.72962e-02, 3.82889e-02,
     & 3.93079e-02, 4.03541e-02, 4.14281e-02, 4.25307e-02, 4.36627e-02,
     & 4.48248e-02, 4.60178e-02, 4.72425e-02, 4.84999e-02/
      DATA (KA_MN2O(JT, 2),JT=1,19)  /
     & 6.10132e-02, 6.17435e-02, 6.24825e-02, 6.32304e-02, 6.39872e-02,
     & 6.47531e-02, 6.55281e-02, 6.63124e-02, 6.71061e-02, 6.79093e-02,
     & 6.87221e-02, 6.95446e-02, 7.03770e-02, 7.12194e-02, 7.20718e-02,
     & 7.29344e-02, 7.38074e-02, 7.46908e-02, 7.55848e-02/
      DATA (KA_MN2O(JT, 3),JT=1,19)  /
     & 1.04479e-01, 1.05566e-01, 1.06664e-01, 1.07774e-01, 1.08895e-01,
     & 1.10028e-01, 1.11173e-01, 1.12329e-01, 1.13498e-01, 1.14679e-01,
     & 1.15872e-01, 1.17077e-01, 1.18295e-01, 1.19526e-01, 1.20770e-01,
     & 1.22026e-01, 1.23296e-01, 1.24578e-01, 1.25875e-01/
      DATA (KA_MN2O(JT, 4),JT=1,19)  /
     & 2.07260e-01, 2.08126e-01, 2.08996e-01, 2.09869e-01, 2.10746e-01,
     & 2.11627e-01, 2.12511e-01, 2.13399e-01, 2.14291e-01, 2.15187e-01,
     & 2.16086e-01, 2.16989e-01, 2.17896e-01, 2.18807e-01, 2.19721e-01,
     & 2.20640e-01, 2.21562e-01, 2.22488e-01, 2.23418e-01/
      DATA (KA_MN2O(JT, 5),JT=1,19)  /
     & 3.71566e-01, 3.71353e-01, 3.71141e-01, 3.70928e-01, 3.70716e-01,
     & 3.70504e-01, 3.70292e-01, 3.70080e-01, 3.69869e-01, 3.69657e-01,
     & 3.69446e-01, 3.69234e-01, 3.69023e-01, 3.68812e-01, 3.68601e-01,
     & 3.68390e-01, 3.68179e-01, 3.67969e-01, 3.67758e-01/
      DATA (KA_MN2O(JT, 6),JT=1,19)  /
     & 5.28092e-01, 5.27262e-01, 5.26433e-01, 5.25605e-01, 5.24779e-01,
     & 5.23954e-01, 5.23130e-01, 5.22307e-01, 5.21486e-01, 5.20666e-01,
     & 5.19847e-01, 5.19030e-01, 5.18214e-01, 5.17399e-01, 5.16586e-01,
     & 5.15773e-01, 5.14962e-01, 5.14153e-01, 5.13344e-01/
      DATA (KA_MN2O(JT, 7),JT=1,19)  /
     & 3.88140e-01, 3.87956e-01, 3.87773e-01, 3.87590e-01, 3.87407e-01,
     & 3.87224e-01, 3.87041e-01, 3.86858e-01, 3.86675e-01, 3.86492e-01,
     & 3.86310e-01, 3.86127e-01, 3.85945e-01, 3.85763e-01, 3.85580e-01,
     & 3.85398e-01, 3.85216e-01, 3.85034e-01, 3.84852e-01/
      DATA (KA_MN2O(JT, 8),JT=1,19)  /
     & 3.12991e-01, 3.12246e-01, 3.11504e-01, 3.10763e-01, 3.10024e-01,
     & 3.09287e-01, 3.08552e-01, 3.07818e-01, 3.07086e-01, 3.06356e-01,
     & 3.05628e-01, 3.04901e-01, 3.04176e-01, 3.03453e-01, 3.02732e-01,
     & 3.02012e-01, 3.01294e-01, 3.00577e-01, 2.99863e-01/
      DATA (KA_MN2O(JT, 9),JT=1,19)  /
     & 4.11761e-01, 4.11309e-01, 4.10858e-01, 4.10407e-01, 4.09957e-01,
     & 4.09507e-01, 4.09057e-01, 4.08608e-01, 4.08160e-01, 4.07712e-01,
     & 4.07265e-01, 4.06818e-01, 4.06371e-01, 4.05925e-01, 4.05480e-01,
     & 4.05035e-01, 4.04590e-01, 4.04146e-01, 4.03703e-01/
      DATA (KA_MN2O(JT,10),JT=1,19)  /
     & 2.84648e-01, 2.87025e-01, 2.89421e-01, 2.91838e-01, 2.94275e-01,
     & 2.96732e-01, 2.99210e-01, 3.01708e-01, 3.04227e-01, 3.06768e-01,
     & 3.09329e-01, 3.11912e-01, 3.14517e-01, 3.17143e-01, 3.19791e-01,
     & 3.22461e-01, 3.25154e-01, 3.27869e-01, 3.30606e-01/
      DATA (KA_MN2O(JT,11),JT=1,19)  /
     & 2.75090e-01, 2.79370e-01, 2.83716e-01, 2.88129e-01, 2.92611e-01,
     & 2.97163e-01, 3.01786e-01, 3.06480e-01, 3.11248e-01, 3.16090e-01,
     & 3.21007e-01, 3.26001e-01, 3.31072e-01, 3.36222e-01, 3.41452e-01,
     & 3.46764e-01, 3.52158e-01, 3.57636e-01, 3.63200e-01/
      DATA (KA_MN2O(JT,12),JT=1,19)  /
     & 1.67753e-01, 1.71386e-01, 1.75098e-01, 1.78890e-01, 1.82765e-01,
     & 1.86723e-01, 1.90767e-01, 1.94899e-01, 1.99120e-01, 2.03433e-01,
     & 2.07839e-01, 2.12340e-01, 2.16939e-01, 2.21638e-01, 2.26438e-01,
     & 2.31342e-01, 2.36353e-01, 2.41472e-01, 2.46701e-01/
      DATA (KA_MN2O(JT,13),JT=1,19)  /
     & 1.40543e-01, 1.42049e-01, 1.43571e-01, 1.45109e-01, 1.46663e-01,
     & 1.48234e-01, 1.49822e-01, 1.51427e-01, 1.53049e-01, 1.54689e-01,
     & 1.56346e-01, 1.58021e-01, 1.59713e-01, 1.61424e-01, 1.63153e-01,
     & 1.64901e-01, 1.66668e-01, 1.68453e-01, 1.70258e-01/
      DATA (KA_MN2O(JT,14),JT=1,19)  /
     & 1.51530e-01, 1.50944e-01, 1.50360e-01, 1.49779e-01, 1.49199e-01,
     & 1.48622e-01, 1.48047e-01, 1.47474e-01, 1.46903e-01, 1.46335e-01,
     & 1.45769e-01, 1.45205e-01, 1.44643e-01, 1.44083e-01, 1.43526e-01,
     & 1.42971e-01, 1.42418e-01, 1.41867e-01, 1.41318e-01/
      DATA (KA_MN2O(JT,15),JT=1,19)  /
     & 2.20492e-01, 2.16479e-01, 2.12539e-01, 2.08671e-01, 2.04873e-01,
     & 2.01145e-01, 1.97484e-01, 1.93890e-01, 1.90361e-01, 1.86897e-01,
     & 1.83495e-01, 1.80156e-01, 1.76877e-01, 1.73658e-01, 1.70497e-01,
     & 1.67394e-01, 1.64348e-01, 1.61356e-01, 1.58420e-01/
      DATA (KA_MN2O(JT,16),JT=1,19)  /
     & 2.19848e-01, 2.15847e-01, 2.11919e-01, 2.08062e-01, 2.04275e-01,
     & 2.00558e-01, 1.96908e-01, 1.93324e-01, 1.89806e-01, 1.86351e-01,
     & 1.82960e-01, 1.79630e-01, 1.76361e-01, 1.73151e-01, 1.70000e-01,
     & 1.66906e-01, 1.63868e-01, 1.60886e-01, 1.57958e-01/

C     The array KB_Mxx contains the absorption coefficient for 
C     a minor species at the 16 chosen g-values for a reference pressure
C     level above 100~ mb.   The first index refers to temperature 
C     in 7.2 degree increments.  For instance, JT = 1 refers to a 
C     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
C     runs over the g-channel (1 to 16).

      DATA (KB_MCO2(JT, 1),JT=1,19)  /
     & 4.74280e-08, 6.62724e-08, 9.26042e-08, 1.29398e-07, 1.80812e-07,
     & 2.52653e-07, 3.53039e-07, 4.93310e-07, 6.89316e-07, 9.63198e-07,
     & 1.34590e-06, 1.88067e-06, 2.62790e-06, 3.67204e-06, 5.13104e-06,
     & 7.16974e-06, 1.00185e-05, 1.39991e-05, 1.95613e-05/
      DATA (KB_MCO2(JT, 2),JT=1,19)  /
     & 1.14872e-07, 1.63356e-07, 2.32304e-07, 3.30352e-07, 4.69783e-07,
     & 6.68064e-07, 9.50033e-07, 1.35101e-06, 1.92123e-06, 2.73213e-06,
     & 3.88527e-06, 5.52513e-06, 7.85711e-06, 1.11734e-05, 1.58893e-05,
     & 2.25957e-05, 3.21326e-05, 4.56948e-05, 6.49811e-05/
      DATA (KB_MCO2(JT, 3),JT=1,19)  /
     & 3.30676e-07, 4.76313e-07, 6.86094e-07, 9.88267e-07, 1.42353e-06,
     & 2.05048e-06, 2.95356e-06, 4.25439e-06, 6.12813e-06, 8.82711e-06,
     & 1.27148e-05, 1.83147e-05, 2.63810e-05, 3.79998e-05, 5.47359e-05,
     & 7.88430e-05, 1.13568e-04, 1.63585e-04, 2.35632e-04/
      DATA (KB_MCO2(JT, 4),JT=1,19)  /
     & 6.58642e-07, 9.52761e-07, 1.37822e-06, 1.99368e-06, 2.88396e-06,
     & 4.17181e-06, 6.03475e-06, 8.72960e-06, 1.26279e-05, 1.82669e-05,
     & 2.64241e-05, 3.82239e-05, 5.52929e-05, 7.99844e-05, 1.15702e-04,
     & 1.67369e-04, 2.42109e-04, 3.50223e-04, 5.06617e-04/
      DATA (KB_MCO2(JT, 5),JT=1,19)  /
     & 1.26418e-06, 1.82095e-06, 2.62292e-06, 3.77810e-06, 5.44204e-06,
     & 7.83881e-06, 1.12911e-05, 1.62640e-05, 2.34269e-05, 3.37445e-05,
     & 4.86061e-05, 7.00131e-05, 1.00848e-04, 1.45263e-04, 2.09239e-04,
     & 3.01392e-04, 4.34131e-04, 6.25329e-04, 9.00733e-04/
      DATA (KB_MCO2(JT, 6),JT=1,19)  /
     & 2.38529e-06, 3.43110e-06, 4.93545e-06, 7.09937e-06, 1.02120e-05,
     & 1.46895e-05, 2.11300e-05, 3.03943e-05, 4.37205e-05, 6.28894e-05,
     & 9.04630e-05, 1.30126e-04, 1.87179e-04, 2.69247e-04, 3.87296e-04,
     & 5.57104e-04, 8.01364e-04, 1.15272e-03, 1.65812e-03/
      DATA (KB_MCO2(JT, 7),JT=1,19)  /
     & 5.41398e-06, 7.54295e-06, 1.05091e-05, 1.46417e-05, 2.03993e-05,
     & 2.84211e-05, 3.95973e-05, 5.51683e-05, 7.68626e-05, 1.07088e-04,
     & 1.49199e-04, 2.07869e-04, 2.89610e-04, 4.03496e-04, 5.62165e-04,
     & 7.83229e-04, 1.09122e-03, 1.52033e-03, 2.11818e-03/
      DATA (KB_MCO2(JT, 8),JT=1,19)  /
     & 1.09995e-05, 1.54018e-05, 2.15660e-05, 3.01973e-05, 4.22831e-05,
     & 5.92059e-05, 8.29017e-05, 1.16081e-04, 1.62540e-04, 2.27592e-04,
     & 3.18681e-04, 4.46226e-04, 6.24817e-04, 8.74886e-04, 1.22504e-03,
     & 1.71533e-03, 2.40185e-03, 3.36313e-03, 4.70915e-03/
      DATA (KB_MCO2(JT, 9),JT=1,19)  /
     & 3.29051e-05, 4.59996e-05, 6.43050e-05, 8.98950e-05, 1.25668e-04,
     & 1.75678e-04, 2.45588e-04, 3.43319e-04, 4.79942e-04, 6.70933e-04,
     & 9.37930e-04, 1.31118e-03, 1.83295e-03, 2.56237e-03, 3.58206e-03,
     & 5.00753e-03, 7.00027e-03, 9.78599e-03, 1.36803e-02/
      DATA (KB_MCO2(JT,10),JT=1,19)  /
     & 1.95126e-05, 2.65944e-05, 3.62463e-05, 4.94013e-05, 6.73305e-05,
     & 9.17669e-05, 1.25072e-04, 1.70465e-04, 2.32332e-04, 3.16652e-04,
     & 4.31575e-04, 5.88208e-04, 8.01687e-04, 1.09264e-03, 1.48920e-03,
     & 2.02968e-03, 2.76631e-03, 3.77029e-03, 5.13865e-03/
      DATA (KB_MCO2(JT,11),JT=1,19)  /
     & 8.67271e-05, 1.19228e-04, 1.63908e-04, 2.25332e-04, 3.09774e-04,
     & 4.25860e-04, 5.85450e-04, 8.04845e-04, 1.10646e-03, 1.52110e-03,
     & 2.09112e-03, 2.87476e-03, 3.95207e-03, 5.43309e-03, 7.46911e-03,
     & 1.02681e-02, 1.41161e-02, 1.94060e-02, 2.66783e-02/
      DATA (KB_MCO2(JT,12),JT=1,19)  /
     & 3.79194e-07, 5.51419e-07, 8.01866e-07, 1.16606e-06, 1.69567e-06,
     & 2.46582e-06, 3.58577e-06, 5.21438e-06, 7.58268e-06, 1.10266e-05,
     & 1.60348e-05, 2.33176e-05, 3.39081e-05, 4.93087e-05, 7.17040e-05,
     & 1.04271e-04, 1.51630e-04, 2.20498e-04, 3.20644e-04/
      DATA (KB_MCO2(JT,13),JT=1,19)  /
     & 1.72555e-07, 2.29952e-07, 3.06441e-07, 4.08373e-07, 5.44209e-07,
     & 7.25229e-07, 9.66461e-07, 1.28793e-06, 1.71634e-06, 2.28724e-06,
     & 3.04805e-06, 4.06192e-06, 5.41303e-06, 7.21356e-06, 9.61299e-06,
     & 1.28106e-05, 1.70717e-05, 2.27503e-05, 3.03177e-05/
      DATA (KB_MCO2(JT,14),JT=1,19)  /
     & 7.42245e-09, 7.17780e-09, 6.94122e-09, 6.71243e-09, 6.49118e-09,
     & 6.27723e-09, 6.07032e-09, 5.87024e-09, 5.67675e-09, 5.48964e-09,
     & 5.30870e-09, 5.13372e-09, 4.96451e-09, 4.80087e-09, 4.64263e-09,
     & 4.48961e-09, 4.34163e-09, 4.19852e-09, 4.06014e-09/
      DATA (KB_MCO2(JT,15),JT=1,19)  /
     & 7.41847e-09, 7.17332e-09, 6.93627e-09, 6.70705e-09, 6.48541e-09,
     & 6.27109e-09, 6.06386e-09, 5.86347e-09, 5.66970e-09, 5.48234e-09,
     & 5.30117e-09, 5.12599e-09, 4.95659e-09, 4.79280e-09, 4.63441e-09,
     & 4.48126e-09, 4.33317e-09, 4.18998e-09, 4.05152e-09/
      DATA (KB_MCO2(JT,16),JT=1,19)  /
     & 7.42855e-09, 7.18278e-09, 6.94513e-09, 6.71535e-09, 6.49317e-09,
     & 6.27834e-09, 6.07062e-09, 5.86977e-09, 5.67557e-09, 5.48779e-09,
     & 5.30622e-09, 5.13066e-09, 4.96091e-09, 4.79678e-09, 4.63808e-09,
     & 4.48462e-09, 4.33625e-09, 4.19278e-09, 4.05406e-09/
      DATA (KB_MN2O(JT, 1),JT=1,19)  /
     & 2.49055e-04, 2.53574e-04, 2.58175e-04, 2.62860e-04, 2.67629e-04,
     & 2.72485e-04, 2.77429e-04, 2.82463e-04, 2.87588e-04, 2.92806e-04,
     & 2.98119e-04, 3.03528e-04, 3.09036e-04, 3.14643e-04, 3.20352e-04,
     & 3.26165e-04, 3.32083e-04, 3.38109e-04, 3.44243e-04/
      DATA (KB_MN2O(JT, 2),JT=1,19)  /
     & 3.79251e-04, 4.04353e-04, 4.31117e-04, 4.59652e-04, 4.90075e-04,
     & 5.22513e-04, 5.57097e-04, 5.93970e-04, 6.33284e-04, 6.75200e-04,
     & 7.19890e-04, 7.67539e-04, 8.18340e-04, 8.72505e-04, 9.30255e-04,
     & 9.91827e-04, 1.05747e-03, 1.12747e-03, 1.20209e-03/
      DATA (KB_MN2O(JT, 3),JT=1,19)  /
     & 7.61140e-04, 8.36483e-04, 9.19284e-04, 1.01028e-03, 1.11029e-03,
     & 1.22019e-03, 1.34098e-03, 1.47372e-03, 1.61959e-03, 1.77991e-03,
     & 1.95610e-03, 2.14973e-03, 2.36253e-03, 2.59639e-03, 2.85340e-03,
     & 3.13585e-03, 3.44626e-03, 3.78740e-03, 4.16230e-03/
      DATA (KB_MN2O(JT, 4),JT=1,19)  /
     & 2.01074e-03, 2.26915e-03, 2.56077e-03, 2.88987e-03, 3.26126e-03,
     & 3.68038e-03, 4.15337e-03, 4.68714e-03, 5.28951e-03, 5.96929e-03,
     & 6.73643e-03, 7.60217e-03, 8.57916e-03, 9.68172e-03, 1.09260e-02,
     & 1.23301e-02, 1.39147e-02, 1.57030e-02, 1.77211e-02/
      DATA (KB_MN2O(JT, 5),JT=1,19)  /
     & 7.43302e-03, 8.32582e-03, 9.32585e-03, 1.04460e-02, 1.17007e-02,
     & 1.31061e-02, 1.46803e-02, 1.64436e-02, 1.84186e-02, 2.06309e-02,
     & 2.31090e-02, 2.58846e-02, 2.89937e-02, 3.24762e-02, 3.63769e-02,
     & 4.07463e-02, 4.56404e-02, 5.11223e-02, 5.72627e-02/
      DATA (KB_MN2O(JT, 6),JT=1,19)  /
     & 2.71911e-02, 2.94258e-02, 3.18441e-02, 3.44612e-02, 3.72933e-02,
     & 4.03582e-02, 4.36750e-02, 4.72644e-02, 5.11487e-02, 5.53523e-02,
     & 5.99014e-02, 6.48243e-02, 7.01518e-02, 7.59172e-02, 8.21563e-02,
     & 8.89082e-02, 9.62150e-02, 1.04122e-01, 1.12679e-01/
      DATA (KB_MN2O(JT, 7),JT=1,19)  /
     & 1.63331e-01, 1.80469e-01, 1.99406e-01, 2.20330e-01, 2.43449e-01,
     & 2.68995e-01, 2.97221e-01, 3.28408e-01, 3.62869e-01, 4.00945e-01,
     & 4.43017e-01, 4.89503e-01, 5.40867e-01, 5.97621e-01, 6.60330e-01,
     & 7.29619e-01, 8.06179e-01, 8.90772e-01, 9.84242e-01/
      DATA (KB_MN2O(JT, 8),JT=1,19)  /
     & 1.32648e+00, 1.33515e+00, 1.34387e+00, 1.35265e+00, 1.36149e+00,
     & 1.37038e+00, 1.37933e+00, 1.38835e+00, 1.39742e+00, 1.40655e+00,
     & 1.41574e+00, 1.42499e+00, 1.43429e+00, 1.44367e+00, 1.45310e+00,
     & 1.46259e+00, 1.47215e+00, 1.48176e+00, 1.49144e+00/
      DATA (KB_MN2O(JT, 9),JT=1,19)  /
     & 3.12620e+00, 3.03118e+00, 2.93905e+00, 2.84972e+00, 2.76310e+00,
     & 2.67911e+00, 2.59768e+00, 2.51873e+00, 2.44217e+00, 2.36794e+00,
     & 2.29596e+00, 2.22618e+00, 2.15851e+00, 2.09290e+00, 2.02929e+00,
     & 1.96761e+00, 1.90780e+00, 1.84982e+00, 1.79359e+00/
      DATA (KB_MN2O(JT,10),JT=1,19)  /
     & 1.60677e-02, 1.82485e-02, 2.07254e-02, 2.35384e-02, 2.67332e-02,
     & 3.03617e-02, 3.44827e-02, 3.91629e-02, 4.44785e-02, 5.05154e-02,
     & 5.73718e-02, 6.51589e-02, 7.40027e-02, 8.40470e-02, 9.54546e-02,
     & 1.08411e-01, 1.23125e-01, 1.39836e-01, 1.58816e-01/
      DATA (KB_MN2O(JT,11),JT=1,19)  /
     & 1.55287e-02, 1.78265e-02, 2.04642e-02, 2.34922e-02, 2.69683e-02,
     & 3.09588e-02, 3.55397e-02, 4.07984e-02, 4.68352e-02, 5.37653e-02,
     & 6.17208e-02, 7.08535e-02, 8.13375e-02, 9.33728e-02, 1.07189e-01,
     & 1.23049e-01, 1.41257e-01, 1.62158e-01, 1.86152e-01/
      DATA (KB_MN2O(JT,12),JT=1,19)  /
     & 7.13719e-03, 8.18879e-03, 9.39535e-03, 1.07797e-02, 1.23680e-02,
     & 1.41903e-02, 1.62811e-02, 1.86800e-02, 2.14324e-02, 2.45902e-02,
     & 2.82134e-02, 3.23704e-02, 3.71400e-02, 4.26122e-02, 4.88908e-02,
     & 5.60945e-02, 6.43596e-02, 7.38424e-02, 8.47224e-02/
      DATA (KB_MN2O(JT,13),JT=1,19)  /
     & 9.28813e-03, 1.06108e-02, 1.21218e-02, 1.38480e-02, 1.58199e-02,
     & 1.80727e-02, 2.06463e-02, 2.35864e-02, 2.69452e-02, 3.07822e-02,
     & 3.51657e-02, 4.01734e-02, 4.58941e-02, 5.24296e-02, 5.98956e-02,
     & 6.84249e-02, 7.81688e-02, 8.93002e-02, 1.02017e-01/
      DATA (KB_MN2O(JT,14),JT=1,19)  /
     & 2.17205e-02, 2.51661e-02, 2.91581e-02, 3.37835e-02, 3.91425e-02,
     & 4.53517e-02, 5.25458e-02, 6.08811e-02, 7.05387e-02, 8.17282e-02,
     & 9.46927e-02, 1.09714e-01, 1.27118e-01, 1.47282e-01, 1.70645e-01,
     & 1.97715e-01, 2.29078e-01, 2.65417e-01, 3.07520e-01/
      DATA (KB_MN2O(JT,15),JT=1,19)  /
     & 4.89156e-02, 5.70504e-02, 6.65379e-02, 7.76033e-02, 9.05089e-02,
     & 1.05561e-01, 1.23116e-01, 1.43590e-01, 1.67469e-01, 1.95320e-01,
     & 2.27802e-01, 2.65686e-01, 3.09869e-01, 3.61401e-01, 4.21503e-01,
     & 4.91600e-01, 5.73354e-01, 6.68703e-01, 7.79910e-01/
      DATA (KB_MN2O(JT,16),JT=1,19)  /
     & 1.13156e-02, 1.46199e-02, 1.88891e-02, 2.44050e-02, 3.15316e-02,
     & 4.07393e-02, 5.26358e-02, 6.80061e-02, 8.78649e-02, 1.13523e-01,
     & 1.46673e-01, 1.89504e-01, 2.44841e-01, 3.16338e-01, 4.08713e-01,
     & 5.28064e-01, 6.82266e-01, 8.81496e-01, 1.13891e+00/

C     The array FORREF contains the coefficient of the water vapor
C     foreign-continuum (including the energy term).  The first 
C     index refers to reference temperature (296,260,224,260) and 
C     pressure (970,475,219,3 mbar) levels.  The second index 
C     runs over the g-channel (1 to 16).

      DATA (FORREF(1,IG),IG=1,16) /
     &4.8166e-07,3.7500e-07,4.8978e-07,5.9624e-07,6.3742e-07,7.5551e-07,
     &7.7706e-07,6.8681e-07,7.5212e-07,8.0956e-07,7.8117e-07,7.4835e-07,
     &9.4118e-07,1.2585e-06,1.4976e-06,1.4976e-06/
      DATA (FORREF(2,IG),IG=1,16) /
     &3.1320e-07,4.0764e-07,4.7468e-07,5.9976e-07,7.3324e-07,8.1488e-07,
     &7.6442e-07,8.2007e-07,7.7721e-07,7.6377e-07,8.0327e-07,7.1881e-07,
     &8.2148e-07,1.0203e-06,1.5033e-06,1.5032e-06/
      DATA (FORREF(3,IG),IG=1,16) /
     &4.1831e-07,5.5043e-07,5.7783e-07,6.1294e-07,6.3396e-07,6.2292e-07,
     &6.1719e-07,6.4183e-07,7.6180e-07,9.5477e-07,9.5901e-07,1.0207e-06,
     &1.0387e-06,1.1305e-06,1.3602e-06,1.5063e-06/
      DATA (FORREF(4,IG),IG=1,16) /
     &8.5878e-07,6.0921e-07,5.5773e-07,5.3374e-07,5.0495e-07,4.9844e-07,
     &5.1536e-07,5.2908e-07,4.7977e-07,5.3177e-07,4.9266e-07,4.5403e-07,
     &3.9695e-07,3.4792e-07,3.4912e-07,3.4102e-07/

C     The array SELFREF contains the coefficient of the water vapor
C     self-continuum (including the energy term).  The first index
C     refers to temperature in 7.2 degree increments.  For instance,
C     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
C     etc.  The second index runs over the g-channel (1 to 16).

      DATA (SELFREF(JT, 1),JT=1,10)  /
     & 3.16029e-02, 2.74633e-02, 2.38660e-02, 2.07399e-02, 1.80232e-02,
     & 1.56624e-02, 1.36108e-02, 1.18280e-02, 1.02787e-02, 8.93231e-03/
      DATA (SELFREF(JT, 2),JT=1,10)  /
     & 3.10422e-02, 2.71312e-02, 2.37130e-02, 2.07254e-02, 1.81142e-02,
     & 1.58320e-02, 1.38374e-02, 1.20940e-02, 1.05703e-02, 9.23854e-03/
      DATA (SELFREF(JT, 3),JT=1,10)  /
     & 3.08657e-02, 2.69431e-02, 2.35190e-02, 2.05301e-02, 1.79210e-02,
     & 1.56435e-02, 1.36554e-02, 1.19200e-02, 1.04051e-02, 9.08279e-03/
      DATA (SELFREF(JT, 4),JT=1,10)  /
     & 3.02668e-02, 2.64686e-02, 2.31470e-02, 2.02422e-02, 1.77020e-02,
     & 1.54806e-02, 1.35379e-02, 1.18390e-02, 1.03533e-02, 9.05406e-03/
      DATA (SELFREF(JT, 5),JT=1,10)  /
     & 2.98317e-02, 2.61491e-02, 2.29210e-02, 2.00914e-02, 1.76112e-02,
     & 1.54371e-02, 1.35314e-02, 1.18610e-02, 1.03968e-02, 9.11332e-03/
      DATA (SELFREF(JT, 6),JT=1,10)  /
     & 2.95545e-02, 2.59083e-02, 2.27120e-02, 1.99100e-02, 1.74537e-02,
     & 1.53004e-02, 1.34128e-02, 1.17580e-02, 1.03074e-02, 9.03576e-03/
      DATA (SELFREF(JT, 7),JT=1,10)  /
     & 2.97352e-02, 2.60320e-02, 2.27900e-02, 1.99517e-02, 1.74670e-02,
     & 1.52916e-02, 1.33872e-02, 1.17200e-02, 1.02604e-02, 8.98258e-03/
      DATA (SELFREF(JT, 8),JT=1,10)  /
     & 2.96543e-02, 2.59760e-02, 2.27540e-02, 1.99316e-02, 1.74593e-02,
     & 1.52937e-02, 1.33967e-02, 1.17350e-02, 1.02794e-02, 9.00437e-03/
      DATA (SELFREF(JT, 9),JT=1,10)  /
     & 2.97998e-02, 2.60786e-02, 2.28220e-02, 1.99721e-02, 1.74781e-02,
     & 1.52955e-02, 1.33855e-02, 1.17140e-02, 1.02512e-02, 8.97110e-03/
      DATA (SELFREF(JT,10),JT=1,10)  /
     & 2.98826e-02, 2.61096e-02, 2.28130e-02, 1.99326e-02, 1.74159e-02,
     & 1.52170e-02, 1.32957e-02, 1.16170e-02, 1.01502e-02, 8.86867e-03/
      DATA (SELFREF(JT,11),JT=1,10)  /
     & 2.94710e-02, 2.58147e-02, 2.26120e-02, 1.98066e-02, 1.73493e-02,
     & 1.51969e-02, 1.33115e-02, 1.16600e-02, 1.02134e-02, 8.94628e-03/
      DATA (SELFREF(JT,12),JT=1,10)  /
     & 2.96297e-02, 2.59544e-02, 2.27350e-02, 1.99149e-02, 1.74446e-02,
     & 1.52808e-02, 1.33853e-02, 1.17250e-02, 1.02706e-02, 8.99663e-03/
      DATA (SELFREF(JT,13),JT=1,10)  /
     & 2.96272e-02, 2.59013e-02, 2.26440e-02, 1.97963e-02, 1.73067e-02,
     & 1.51302e-02, 1.32275e-02, 1.15640e-02, 1.01097e-02, 8.83833e-03/
      DATA (SELFREF(JT,14),JT=1,10)  /
     & 2.89906e-02, 2.53971e-02, 2.22490e-02, 1.94911e-02, 1.70751e-02,
     & 1.49585e-02, 1.31044e-02, 1.14800e-02, 1.00570e-02, 8.81038e-03/
      DATA (SELFREF(JT,15),JT=1,10)  /
     & 2.80884e-02, 2.46987e-02, 2.17180e-02, 1.90970e-02, 1.67924e-02,
     & 1.47659e-02, 1.29839e-02, 1.14170e-02, 1.00392e-02, 8.82765e-03/
      DATA (SELFREF(JT,16),JT=1,10)  /
     & 2.80884e-02, 2.46987e-02, 2.17180e-02, 1.90970e-02, 1.67924e-02,
     & 1.47659e-02, 1.29839e-02, 1.14170e-02, 1.00392e-02, 8.82765e-03/
