C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB09.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.0 $
C     created:   $Date: 2002/06/03 20:38:41 $
       PARAMETER (MG=16)

       DIMENSION SELFREF(10,MG), FORREF(4,MG)
       REAL KA(9,5,13,MG), KB(5,13:59,MG)
       REAL KA_MN2O(9,19,MG), KB_MN2O(19,MG)

       COMMON /HVRSN9/ HVRKG9

       COMMON /K9/ KA, KB, FORREF, SELFREF, KA_MN2O, KB_MN2O

       CHARACTER*15 HVRKG9
       DATA HVRKG9 /'$Revision: 3.0 $'/

C     The array KA contains absorption coefs for each of the 16 g-intervals
C     for a range of pressure levels > ~100mb, temperatures, and ratios
C     of water vapor to CO2.  The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.
C     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
C     to different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this  pressure 
C     level, JT = 2 refers to the temperature
C     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
C     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
C     to the reference pressure level (e.g. JP = 1 is for a
C     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA ((KA(JS,JT, 1, 1),JS=1,9),JT=1,5) /
     &2.1746E-06,2.0220E-05,3.5039E-05,4.9564E-05,6.4547E-05,8.0645E-05,
     &1.0050E-04,1.3591E-04,1.1422E-04,2.4567E-06,2.4642E-05,4.2577E-05,
     &6.0179E-05,7.8156E-05,9.7521E-05,1.2325E-04,1.6438E-04,1.3834E-04,
     &2.7778E-06,2.9755E-05,5.1233E-05,7.2538E-05,9.4256E-05,1.1716E-04,
     &1.4583E-04,1.9818E-04,1.6722E-04,3.1364E-06,3.5376E-05,6.1122E-05,
     &8.6709E-05,1.1261E-04,1.4025E-04,1.7411E-04,2.3326E-04,2.0043E-04,
     &3.4866E-06,4.1773E-05,7.2421E-05,1.0284E-04,1.3368E-04,1.6658E-04,
     &2.0645E-04,2.7379E-04,2.3933E-04/
      DATA ((KA(JS,JT, 2, 1),JS=1,9),JT=1,5) /
     &2.7658E-06,1.8665E-05,2.9579E-05,4.0556E-05,5.1475E-05,6.3012E-05,
     &7.6030E-05,9.6554E-05,8.6790E-05,3.1474E-06,2.2675E-05,3.6322E-05,
     &4.9569E-05,6.2848E-05,7.6725E-05,9.2975E-05,1.1920E-04,1.0628E-04,
     &3.5619E-06,2.7222E-05,4.3763E-05,5.9895E-05,7.6025E-05,9.2855E-05,
     &1.1166E-04,1.4410E-04,1.2840E-04,4.0332E-06,3.2194E-05,5.2284E-05,
     &7.1664E-05,9.1201E-05,1.1132E-04,1.3395E-04,1.6948E-04,1.5482E-04,
     &4.5426E-06,3.7892E-05,6.1930E-05,8.5200E-05,1.0845E-04,1.3257E-04,
     &1.5957E-04,2.0150E-04,1.8531E-04/
      DATA ((KA(JS,JT, 3, 1),JS=1,9),JT=1,5) /
     &4.6515E-06,1.9518E-05,2.8024E-05,3.5437E-05,4.2060E-05,4.8949E-05,
     &5.6458E-05,6.6193E-05,6.4702E-05,5.3085E-06,2.3661E-05,3.4250E-05,
     &4.3649E-05,5.1882E-05,6.0429E-05,6.9536E-05,8.2456E-05,7.9400E-05,
     &6.0401E-06,2.8338E-05,4.1344E-05,5.2675E-05,6.2996E-05,7.3527E-05,
     &8.4697E-05,9.9499E-05,9.6161E-05,6.8636E-06,3.3625E-05,4.9393E-05,
     &6.2729E-05,7.5705E-05,8.8632E-05,1.0218E-04,1.1965E-04,1.1595E-04,
     &7.7592E-06,3.9481E-05,5.8243E-05,7.4429E-05,9.0184E-05,1.0593E-04,
     &1.2226E-04,1.4329E-04,1.3957E-04/
      DATA ((KA(JS,JT, 4, 1),JS=1,9),JT=1,5) /
     &7.8254E-06,2.2162E-05,2.8768E-05,3.4092E-05,3.8273E-05,4.1617E-05,
     &4.4585E-05,4.7843E-05,5.0090E-05,9.0107E-06,2.6852E-05,3.5234E-05,
     &4.2063E-05,4.7365E-05,5.1787E-05,5.5276E-05,5.9864E-05,6.1930E-05,
     &1.0349E-05,3.2172E-05,4.2565E-05,5.1061E-05,5.7654E-05,6.3243E-05,
     &6.7675E-05,7.3397E-05,7.5548E-05,1.1906E-05,3.8190E-05,5.0960E-05,
     &6.1161E-05,6.9192E-05,7.6085E-05,8.1960E-05,8.9085E-05,9.1511E-05,
     &1.3610E-05,4.4853E-05,6.0373E-05,7.2336E-05,8.2116E-05,9.0436E-05,
     &9.8270E-05,1.0717E-04,1.0994E-04/
      DATA ((KA(JS,JT, 5, 1),JS=1,9),JT=1,5) /
     &1.2215E-05,2.6429E-05,3.0893E-05,3.4176E-05,3.6538E-05,3.7893E-05,
     &3.8292E-05,3.7482E-05,3.9876E-05,1.4086E-05,3.1907E-05,3.7874E-05,
     &4.2237E-05,4.5377E-05,4.7376E-05,4.7976E-05,4.7239E-05,4.9622E-05,
     &1.6264E-05,3.8161E-05,4.5845E-05,5.1471E-05,5.5412E-05,5.8145E-05,
     &5.8993E-05,5.8204E-05,6.0963E-05,1.8858E-05,4.5142E-05,5.4763E-05,
     &6.1781E-05,6.6831E-05,7.0144E-05,7.1439E-05,7.0642E-05,7.3664E-05,
     &2.1682E-05,5.2995E-05,6.4832E-05,7.3555E-05,7.9689E-05,8.3689E-05,
     &8.5451E-05,8.5137E-05,8.8330E-05/
      DATA ((KA(JS,JT, 6, 1),JS=1,9),JT=1,5) /
     &1.7737E-05,3.1507E-05,3.4689E-05,3.5923E-05,3.6042E-05,3.5547E-05,
     &3.3855E-05,3.0889E-05,3.3707E-05,2.0662E-05,3.8270E-05,4.2282E-05,
     &4.3931E-05,4.4914E-05,4.4463E-05,4.2744E-05,3.9347E-05,4.1797E-05,
     &2.4128E-05,4.5613E-05,5.0898E-05,5.3590E-05,5.4968E-05,5.4808E-05,
     &5.3000E-05,4.8943E-05,5.1147E-05,2.7999E-05,5.3907E-05,6.0955E-05,
     &6.4423E-05,6.6442E-05,6.6605E-05,6.4604E-05,5.9878E-05,6.1516E-05,
     &3.2152E-05,6.3564E-05,7.2012E-05,7.6692E-05,7.9463E-05,7.9823E-05,
     &7.7573E-05,7.2281E-05,7.4081E-05/
      DATA ((KA(JS,JT, 7, 1),JS=1,9),JT=1,5) /
     &2.6880E-05,4.1451E-05,4.2153E-05,4.1795E-05,4.0071E-05,3.7010E-05,
     &3.2935E-05,2.7157E-05,3.0165E-05,3.1867E-05,5.0449E-05,5.1950E-05,
     &5.1350E-05,4.9502E-05,4.6117E-05,4.1536E-05,3.4782E-05,3.7420E-05,
     &3.7274E-05,6.0537E-05,6.2610E-05,6.2280E-05,6.0355E-05,5.6848E-05,
     &5.1457E-05,4.3658E-05,4.5586E-05,4.3315E-05,7.1931E-05,7.4511E-05,
     &7.5005E-05,7.2731E-05,6.8916E-05,6.2904E-05,5.3755E-05,5.5264E-05,
     &4.9907E-05,8.4683E-05,8.8542E-05,8.9292E-05,8.6631E-05,8.2549E-05,
     &7.6077E-05,6.5242E-05,6.5892E-05/
      DATA ((KA(JS,JT, 8, 1),JS=1,9),JT=1,5) /
     &4.7627E-05,6.4864E-05,6.3521E-05,5.9018E-05,5.3108E-05,4.6571E-05,
     &3.8650E-05,2.8473E-05,2.9135E-05,5.7767E-05,7.9036E-05,7.7751E-05,
     &7.3012E-05,6.6279E-05,5.8148E-05,4.8459E-05,3.6303E-05,3.6552E-05,
     &6.8331E-05,9.5161E-05,9.3980E-05,8.8741E-05,8.0901E-05,7.1279E-05,
     &5.9682E-05,4.5314E-05,4.4112E-05,7.9894E-05,1.1320E-04,1.1263E-04,
     &1.0646E-04,9.7413E-05,8.6626E-05,7.2540E-05,5.5667E-05,5.2996E-05,
     &9.2972E-05,1.3437E-04,1.3320E-04,1.2651E-04,1.1648E-04,1.0389E-04,
     &8.7249E-05,6.7590E-05,6.3371E-05/
      DATA ((KA(JS,JT, 9, 1),JS=1,9),JT=1,5) /
     &1.5799E-04,1.8833E-04,1.7550E-04,1.5612E-04,1.3380E-04,1.0918E-04,
     &8.2063E-05,5.1241E-05,3.5341E-05,1.9443E-04,2.2819E-04,2.1471E-04,
     &1.9244E-04,1.6566E-04,1.3587E-04,1.0320E-04,6.4536E-05,4.5195E-05,
     &2.3622E-04,2.7685E-04,2.6057E-04,2.3445E-04,2.0276E-04,1.6671E-04,
     &1.2651E-04,7.9797E-05,5.6882E-05,2.7828E-04,3.3139E-04,3.1210E-04,
     &2.8146E-04,2.4413E-04,2.0071E-04,1.5211E-04,9.7273E-05,6.9081E-05,
     &3.2528E-04,3.9307E-04,3.6944E-04,3.3441E-04,2.9052E-04,2.3944E-04,
     &1.8220E-04,1.1689E-04,8.4202E-05/
      DATA ((KA(JS,JT,10, 1),JS=1,9),JT=1,5) /
     &5.9822E-04,6.2372E-04,5.8089E-04,5.1261E-04,4.3322E-04,3.4273E-04,
     &2.4200E-04,1.3558E-04,7.2135E-05,7.4373E-04,7.8308E-04,7.2223E-04,
     &6.3443E-04,5.3223E-04,4.2429E-04,3.0242E-04,1.7107E-04,9.5831E-05,
     &9.1691E-04,9.5621E-04,8.7625E-04,7.6950E-04,6.5144E-04,5.1701E-04,
     &3.7121E-04,2.1199E-04,1.2423E-04,1.1043E-03,1.1414E-03,1.0539E-03,
     &9.3161E-04,7.8672E-04,6.2626E-04,4.5160E-04,2.5892E-04,1.5666E-04,
     &1.3045E-03,1.3552E-03,1.2556E-03,1.1172E-03,9.4316E-04,7.4718E-04,
     &5.4008E-04,3.1196E-04,1.9599E-04/
      DATA ((KA(JS,JT,11, 1),JS=1,9),JT=1,5) /
     &8.7712E-04,8.8837E-04,8.1430E-04,7.2064E-04,6.0791E-04,4.8638E-04,
     &3.4855E-04,1.8904E-04,9.5086E-05,1.1025E-03,1.1220E-03,1.0310E-03,
     &9.0820E-04,7.5807E-04,5.9864E-04,4.3064E-04,2.3702E-04,1.2669E-04,
     &1.3684E-03,1.3746E-03,1.2594E-03,1.1058E-03,9.3187E-04,7.3748E-04,
     &5.2465E-04,2.9520E-04,1.6181E-04,1.6471E-03,1.6623E-03,1.5206E-03,
     &1.3382E-03,1.1315E-03,8.9471E-04,6.4214E-04,3.6310E-04,2.0489E-04,
     &1.9688E-03,1.9772E-03,1.8138E-03,1.6028E-03,1.3619E-03,1.0826E-03,
     &7.7699E-04,4.3404E-04,2.5459E-04/
      DATA ((KA(JS,JT,12, 1),JS=1,9),JT=1,5) /
     &9.4409E-04,9.5030E-04,8.6958E-04,7.6723E-04,6.4799E-04,5.1804E-04,
     &3.7162E-04,2.0179E-04,1.0181E-04,1.2024E-03,1.2024E-03,1.1035E-03,
     &9.7105E-04,8.1245E-04,6.4379E-04,4.6123E-04,2.5624E-04,1.3746E-04,
     &1.5009E-03,1.4895E-03,1.3527E-03,1.1889E-03,1.0016E-03,7.9376E-04,
     &5.6671E-04,3.1943E-04,1.7568E-04,1.8192E-03,1.8117E-03,1.6422E-03,
     &1.4410E-03,1.2151E-03,9.6812E-04,6.9546E-04,3.9137E-04,2.1782E-04,
     &2.1766E-03,2.1635E-03,1.9700E-03,1.7314E-03,1.4651E-03,1.1736E-03,
     &8.4593E-04,4.7032E-04,2.5768E-04/
      DATA ((KA(JS,JT,13, 1),JS=1,9),JT=1,5) /
     &8.2069E-04,8.2445E-04,7.5154E-04,6.6188E-04,5.6185E-04,4.5083E-04,
     &3.2275E-04,1.7851E-04,9.1099E-05,1.0473E-03,1.0502E-03,9.5966E-04,
     &8.4257E-04,7.0741E-04,5.6233E-04,4.0370E-04,2.2679E-04,1.2172E-04,
     &1.3133E-03,1.3024E-03,1.1846E-03,1.0375E-03,8.7436E-04,6.9645E-04,
     &5.0292E-04,2.8463E-04,1.5549E-04,1.6064E-03,1.5873E-03,1.4461E-03,
     &1.2677E-03,1.0715E-03,8.5901E-04,6.1842E-04,3.4781E-04,1.9357E-04,
     &1.9305E-03,1.9051E-03,1.7364E-03,1.5314E-03,1.2972E-03,1.0440E-03,
     &7.5312E-04,4.2210E-04,2.3145E-04/
      DATA ((KA(JS,JT, 1, 2),JS=1,9),JT=1,5) /
     &8.1346E-06,1.0615E-04,1.6451E-04,2.1843E-04,2.7217E-04,3.3271E-04,
     &4.0424E-04,5.2737E-04,4.6457E-04,9.5357E-06,1.2245E-04,1.9203E-04,
     &2.5686E-04,3.2147E-04,3.9091E-04,4.7632E-04,6.1736E-04,5.3890E-04,
     &1.0894E-05,1.4027E-04,2.2328E-04,3.0098E-04,3.7740E-04,4.5873E-04,
     &5.6256E-04,7.2836E-04,6.2820E-04,1.2218E-05,1.6125E-04,2.5837E-04,
     &3.4988E-04,4.3991E-04,5.3396E-04,6.5212E-04,8.5783E-04,7.3258E-04,
     &1.3559E-05,1.8418E-04,2.9709E-04,4.0563E-04,5.0913E-04,6.2018E-04,
     &7.5464E-04,9.9267E-04,8.5248E-04/
      DATA ((KA(JS,JT, 2, 2),JS=1,9),JT=1,5) /
     &1.0648E-05,1.0205E-04,1.5218E-04,1.9460E-04,2.3469E-04,2.7445E-04,
     &3.2374E-04,3.9687E-04,3.7021E-04,1.2479E-05,1.1864E-04,1.7693E-04,
     &2.2906E-04,2.7817E-04,3.2635E-04,3.8100E-04,4.6812E-04,4.2972E-04,
     &1.4325E-05,1.3615E-04,2.0613E-04,2.6822E-04,3.2742E-04,3.8532E-04,
     &4.4992E-04,5.5581E-04,5.0382E-04,1.6131E-05,1.5522E-04,2.3823E-04,
     &3.1216E-04,3.8163E-04,4.4987E-04,5.2423E-04,6.5095E-04,5.8901E-04,
     &1.7840E-05,1.7738E-04,2.7413E-04,3.6145E-04,4.4307E-04,5.2217E-04,
     &6.0968E-04,7.4929E-04,6.8588E-04/
      DATA ((KA(JS,JT, 3, 2),JS=1,9),JT=1,5) /
     &1.7975E-05,1.1236E-04,1.5383E-04,1.8734E-04,2.1612E-04,2.4014E-04,
     &2.6058E-04,2.9343E-04,2.9752E-04,2.1208E-05,1.3084E-04,1.8013E-04,
     &2.2080E-04,2.5543E-04,2.8432E-04,3.1199E-04,3.4846E-04,3.5196E-04,
     &2.4558E-05,1.5021E-04,2.0878E-04,2.5693E-04,2.9945E-04,3.3619E-04,
     &3.7048E-04,4.1334E-04,4.1350E-04,2.7720E-05,1.7111E-04,2.4012E-04,
     &2.9904E-04,3.4910E-04,3.9367E-04,4.3560E-04,4.8351E-04,4.8248E-04,
     &3.0839E-05,1.9412E-04,2.7570E-04,3.4584E-04,4.0483E-04,4.5917E-04,
     &5.0628E-04,5.6356E-04,5.6016E-04/
      DATA ((KA(JS,JT, 4, 2),JS=1,9),JT=1,5) /
     &3.0257E-05,1.3348E-04,1.6797E-04,1.9240E-04,2.0954E-04,2.2222E-04,
     &2.2898E-04,2.3143E-04,2.5081E-04,3.6110E-05,1.5427E-04,1.9683E-04,
     &2.2498E-04,2.4900E-04,2.6495E-04,2.7383E-04,2.7831E-04,3.0130E-04,
     &4.2020E-05,1.7731E-04,2.2733E-04,2.6268E-04,2.9200E-04,3.1270E-04,
     &3.2430E-04,3.3243E-04,3.4977E-04,4.7704E-05,2.0254E-04,2.6080E-04,
     &3.0470E-04,3.4066E-04,3.6571E-04,3.8177E-04,3.9329E-04,4.0928E-04,
     &5.3448E-05,2.2883E-04,2.9767E-04,3.4976E-04,3.9269E-04,4.2565E-04,
     &4.4636E-04,4.5989E-04,4.7277E-04/
      DATA ((KA(JS,JT, 5, 2),JS=1,9),JT=1,5) /
     &4.6988E-05,1.6787E-04,1.9191E-04,2.0648E-04,2.1525E-04,2.1596E-04,
     &2.0906E-04,1.9576E-04,2.0610E-04,5.6510E-05,1.9317E-04,2.2448E-04,
     &2.4373E-04,2.5210E-04,2.5521E-04,2.5032E-04,2.3737E-04,2.5015E-04,
     &6.6097E-05,2.2111E-04,2.5901E-04,2.8182E-04,2.9480E-04,2.9992E-04,
     &2.9852E-04,2.8340E-04,3.0111E-04,7.5373E-05,2.5095E-04,2.9694E-04,
     &3.2434E-04,3.4231E-04,3.5125E-04,3.5172E-04,3.3625E-04,3.5720E-04,
     &8.4653E-05,2.8271E-04,3.3633E-04,3.7103E-04,3.9540E-04,4.0854E-04,
     &4.1017E-04,3.9523E-04,4.0911E-04/
      DATA ((KA(JS,JT, 6, 2),JS=1,9),JT=1,5) /
     &6.8194E-05,2.1119E-04,2.2511E-04,2.2905E-04,2.2761E-04,2.1982E-04,
     &2.0183E-04,1.7113E-04,1.7129E-04,8.3032E-05,2.4138E-04,2.6267E-04,
     &2.7055E-04,2.6995E-04,2.6005E-04,2.3793E-04,2.0771E-04,2.1052E-04,
     &9.7316E-05,2.7435E-04,3.0334E-04,3.1415E-04,3.1605E-04,3.0269E-04,
     &2.8123E-04,2.4990E-04,2.5531E-04,1.1184E-04,3.0984E-04,3.4680E-04,
     &3.6228E-04,3.6303E-04,3.5165E-04,3.2989E-04,2.9654E-04,3.0715E-04,
     &1.2632E-04,3.4683E-04,3.9318E-04,4.1205E-04,4.1568E-04,4.0572E-04,
     &3.8584E-04,3.4794E-04,3.6334E-04/
      DATA ((KA(JS,JT, 7, 2),JS=1,9),JT=1,5) /
     &1.0382E-04,2.6395E-04,2.8989E-04,2.8076E-04,2.6344E-04,2.4071E-04,
     &2.1106E-04,1.6791E-04,1.4516E-04,1.2713E-04,3.0635E-04,3.3550E-04,
     &3.2897E-04,3.1196E-04,2.8824E-04,2.5288E-04,2.0031E-04,1.8143E-04,
     &1.5126E-04,3.5047E-04,3.8510E-04,3.8068E-04,3.6466E-04,3.3889E-04,
     &2.9600E-04,2.3790E-04,2.2323E-04,1.7453E-04,3.9749E-04,4.3569E-04,
     &4.3708E-04,4.2166E-04,3.9085E-04,3.4474E-04,2.8074E-04,2.7137E-04,
     &1.9815E-04,4.4700E-04,4.9020E-04,4.9608E-04,4.8316E-04,4.4845E-04,
     &4.0007E-04,3.2811E-04,3.2529E-04/
      DATA ((KA(JS,JT, 8, 2),JS=1,9),JT=1,5) /
     &1.8568E-04,3.7522E-04,4.0441E-04,4.0400E-04,3.7101E-04,3.2090E-04,
     &2.6014E-04,1.8741E-04,1.4093E-04,2.2706E-04,4.4100E-04,4.7331E-04,
     &4.6941E-04,4.3330E-04,3.7933E-04,3.1116E-04,2.2753E-04,1.7550E-04,
     &2.7313E-04,5.0681E-04,5.4665E-04,5.4041E-04,5.0328E-04,4.4299E-04,
     &3.6626E-04,2.6706E-04,2.1512E-04,3.2050E-04,5.7784E-04,6.2469E-04,
     &6.1766E-04,5.7799E-04,5.1310E-04,4.2712E-04,3.1237E-04,2.5864E-04,
     &3.6492E-04,6.4972E-04,7.0632E-04,6.9926E-04,6.5563E-04,5.8535E-04,
     &4.8972E-04,3.6487E-04,3.1085E-04/
      DATA ((KA(JS,JT, 9, 2),JS=1,9),JT=1,5) /
     &6.2599E-04,8.6654E-04,9.0634E-04,8.8937E-04,8.1140E-04,7.1027E-04,
     &5.7167E-04,3.5735E-04,2.0982E-04,7.7627E-04,1.0704E-03,1.1043E-03,
     &1.0586E-03,9.6032E-04,8.3995E-04,6.6547E-04,4.2636E-04,2.5832E-04,
     &9.3794E-04,1.2619E-03,1.2949E-03,1.2284E-03,1.1156E-03,9.7182E-04,
     &7.6979E-04,5.0109E-04,3.1973E-04,1.1114E-03,1.4537E-03,1.4722E-03,
     &1.4030E-03,1.2802E-03,1.1177E-03,8.8445E-04,5.8120E-04,3.8922E-04,
     &1.2779E-03,1.6415E-03,1.6560E-03,1.5834E-03,1.4519E-03,1.2713E-03,
     &1.0105E-03,6.6729E-04,4.6624E-04/
      DATA ((KA(JS,JT,10, 2),JS=1,9),JT=1,5) /
     &2.4553E-03,2.6165E-03,2.4993E-03,2.2847E-03,2.0267E-03,1.7115E-03,
     &1.3397E-03,8.6368E-04,3.6576E-04,3.0620E-03,3.2511E-03,3.1049E-03,
     &2.8553E-03,2.5348E-03,2.1265E-03,1.6314E-03,1.0269E-03,4.5803E-04,
     &3.7364E-03,3.9627E-03,3.7660E-03,3.4224E-03,3.0121E-03,2.5166E-03,
     &1.9135E-03,1.1990E-03,5.6685E-04,4.4530E-03,4.6554E-03,4.3836E-03,
     &3.9682E-03,3.4829E-03,2.8809E-03,2.1972E-03,1.3815E-03,6.9188E-04,
     &5.1575E-03,5.3264E-03,4.9909E-03,4.5087E-03,3.9257E-03,3.2602E-03,
     &2.4888E-03,1.5715E-03,8.2270E-04/
      DATA ((KA(JS,JT,11, 2),JS=1,9),JT=1,5) /
     &3.7833E-03,3.8112E-03,3.5566E-03,3.1989E-03,2.7686E-03,2.2723E-03,
     &1.7364E-03,1.0753E-03,4.0590E-04,4.6966E-03,4.7207E-03,4.4156E-03,
     &3.9736E-03,3.4554E-03,2.8577E-03,2.1338E-03,1.2945E-03,5.0517E-04,
     &5.7189E-03,5.7590E-03,5.3345E-03,4.7708E-03,4.1084E-03,3.3729E-03,
     &2.5008E-03,1.5078E-03,6.3337E-04,6.7827E-03,6.7469E-03,6.2278E-03,
     &5.5367E-03,4.7380E-03,3.8594E-03,2.8648E-03,1.7294E-03,7.7415E-04,
     &7.8200E-03,7.7382E-03,7.0901E-03,6.2644E-03,5.3533E-03,4.3510E-03,
     &3.2356E-03,1.9722E-03,9.3312E-04/
      DATA ((KA(JS,JT,12, 2),JS=1,9),JT=1,5) /
     &4.2783E-03,4.2041E-03,3.8742E-03,3.4634E-03,2.9720E-03,2.4393E-03,
     &1.8351E-03,1.1175E-03,3.9253E-04,5.3337E-03,5.2652E-03,4.8301E-03,
     &4.3189E-03,3.7223E-03,3.0228E-03,2.2408E-03,1.3443E-03,4.8795E-04,
     &6.5143E-03,6.3579E-03,5.8237E-03,5.1812E-03,4.4118E-03,3.5721E-03,
     &2.6281E-03,1.5684E-03,6.0394E-04,7.6468E-03,7.4276E-03,6.7625E-03,
     &6.0120E-03,5.0805E-03,4.0892E-03,3.0024E-03,1.8032E-03,7.4856E-04,
     &8.7322E-03,8.4845E-03,7.6878E-03,6.7875E-03,5.7064E-03,4.6095E-03,
     &3.4027E-03,2.0497E-03,9.3030E-04/
      DATA ((KA(JS,JT,13, 2),JS=1,9),JT=1,5) /
     &3.8383E-03,3.7685E-03,3.4781E-03,3.1000E-03,2.6661E-03,2.1777E-03,
     &1.6207E-03,9.7395E-04,3.4434E-04,4.7991E-03,4.7287E-03,4.3604E-03,
     &3.8801E-03,3.3054E-03,2.6658E-03,1.9755E-03,1.1692E-03,4.3018E-04,
     &5.8240E-03,5.6632E-03,5.1895E-03,4.6114E-03,3.9052E-03,3.1338E-03,
     &2.3066E-03,1.3724E-03,5.3490E-04,6.7942E-03,6.6067E-03,6.0062E-03,
     &5.2927E-03,4.4607E-03,3.5870E-03,2.6413E-03,1.5766E-03,6.6330E-04,
     &7.7135E-03,7.4856E-03,6.7623E-03,5.9543E-03,5.0216E-03,4.0477E-03,
     &2.9856E-03,1.7918E-03,8.1116E-04/
      DATA ((KA(JS,JT, 1, 3),JS=1,9),JT=1,5) /
     &2.4793E-05,3.0799E-04,4.6290E-04,5.9325E-04,7.1737E-04,8.2193E-04,
     &9.4048E-04,1.1399E-03,1.0252E-03,2.6296E-05,3.5350E-04,5.3963E-04,
     &6.9573E-04,8.4910E-04,9.9005E-04,1.1353E-03,1.3914E-03,1.2872E-03,
     &2.7819E-05,4.0345E-04,6.2337E-04,8.1130E-04,9.9260E-04,1.1727E-03,
     &1.3740E-03,1.6958E-03,1.5768E-03,2.9505E-05,4.5829E-04,7.1308E-04,
     &9.3786E-04,1.1508E-03,1.3827E-03,1.6466E-03,2.0604E-03,1.9074E-03,
     &3.1281E-05,5.1795E-04,8.1473E-04,1.0770E-03,1.3366E-03,1.6108E-03,
     &1.9547E-03,2.4904E-03,2.2803E-03/
      DATA ((KA(JS,JT, 2, 3),JS=1,9),JT=1,5) /
     &3.2793E-05,3.0694E-04,4.5221E-04,5.6459E-04,6.5806E-04,7.4456E-04,
     &8.0925E-04,9.1019E-04,8.6945E-04,3.4666E-05,3.5123E-04,5.2466E-04,
     &6.5968E-04,7.7040E-04,8.8249E-04,9.7906E-04,1.1056E-03,1.0654E-03,
     &3.6731E-05,4.0004E-04,6.0292E-04,7.6491E-04,9.0091E-04,1.0289E-03,
     &1.1668E-03,1.3438E-03,1.2804E-03,3.8918E-05,4.5420E-04,6.8900E-04,
     &8.8273E-04,1.0463E-03,1.2043E-03,1.3845E-03,1.6322E-03,1.5338E-03,
     &4.1070E-05,5.1139E-04,7.8412E-04,1.0082E-03,1.2070E-03,1.4003E-03,
     &1.6106E-03,1.9566E-03,1.8338E-03/
      DATA ((KA(JS,JT, 3, 3),JS=1,9),JT=1,5) /
     &5.7419E-05,3.4417E-04,4.7657E-04,5.8011E-04,6.5776E-04,7.1017E-04,
     &7.4352E-04,7.5165E-04,7.1905E-04,6.1098E-05,3.8894E-04,5.5050E-04,
     &6.7283E-04,7.6814E-04,8.3562E-04,8.7563E-04,9.0812E-04,8.7884E-04,
     &6.4950E-05,4.3994E-04,6.3159E-04,7.7584E-04,8.9433E-04,9.7562E-04,
     &1.0278E-03,1.0860E-03,1.0655E-03,6.9137E-05,4.9606E-04,7.1905E-04,
     &8.8979E-04,1.0295E-03,1.1315E-03,1.2033E-03,1.2952E-03,1.2839E-03,
     &7.3375E-05,5.5536E-04,8.1436E-04,1.0155E-03,1.1795E-03,1.3051E-03,
     &1.4046E-03,1.5168E-03,1.5296E-03/
      DATA ((KA(JS,JT, 4, 3),JS=1,9),JT=1,5) /
     &1.0086E-04,4.2454E-04,5.2985E-04,6.0848E-04,6.7121E-04,7.0723E-04,
     &7.1237E-04,6.8193E-04,6.1640E-04,1.0794E-04,4.6886E-04,6.0099E-04,
     &7.0397E-04,7.8290E-04,8.2924E-04,8.4042E-04,8.0656E-04,7.3923E-04,
     &1.1564E-04,5.1937E-04,6.8316E-04,8.0764E-04,9.0488E-04,9.5975E-04,
     &9.8680E-04,9.5115E-04,8.9690E-04,1.2339E-04,5.7610E-04,7.7301E-04,
     &9.2354E-04,1.0350E-03,1.1092E-03,1.1493E-03,1.1169E-03,1.0760E-03,
     &1.3105E-04,6.3905E-04,8.6996E-04,1.0475E-03,1.1809E-03,1.2763E-03,
     &1.3289E-03,1.3078E-03,1.2869E-03/
      DATA ((KA(JS,JT, 5, 3),JS=1,9),JT=1,5) /
     &1.6100E-04,5.0634E-04,6.1668E-04,6.6467E-04,6.8745E-04,6.9758E-04,
     &6.8538E-04,6.2098E-04,6.1721E-04,1.7365E-04,5.5505E-04,6.8253E-04,
     &7.5603E-04,7.9631E-04,8.1600E-04,8.0888E-04,7.3807E-04,7.1431E-04,
     &1.8648E-04,6.0992E-04,7.6141E-04,8.5901E-04,9.1428E-04,9.4703E-04,
     &9.4315E-04,8.7432E-04,8.2918E-04,1.9988E-04,6.7074E-04,8.4873E-04,
     &9.7496E-04,1.0437E-03,1.0922E-03,1.0916E-03,1.0269E-03,9.7489E-04,
     &2.1403E-04,7.3152E-04,9.4776E-04,1.0959E-03,1.1876E-03,1.2477E-03,
     &1.2592E-03,1.1994E-03,1.1556E-03/
      DATA ((KA(JS,JT, 6, 3),JS=1,9),JT=1,5) /
     &2.3782E-04,5.8473E-04,7.0057E-04,7.3727E-04,7.3866E-04,7.0622E-04,
     &6.5578E-04,5.7152E-04,6.4834E-04,2.5744E-04,6.5190E-04,7.6744E-04,
     &8.2296E-04,8.3569E-04,8.1871E-04,7.7021E-04,6.8232E-04,7.1639E-04,
     &2.7664E-04,7.1488E-04,8.5237E-04,9.1762E-04,9.4622E-04,9.4392E-04,
     &8.9795E-04,8.0363E-04,8.0674E-04,2.9757E-04,7.7689E-04,9.3669E-04,
     &1.0212E-03,1.0750E-03,1.0793E-03,1.0394E-03,9.3920E-04,9.2478E-04,
     &3.2013E-04,8.4833E-04,1.0249E-03,1.1443E-03,1.2150E-03,1.2313E-03,
     &1.1962E-03,1.0926E-03,1.0558E-03/
      DATA ((KA(JS,JT, 7, 3),JS=1,9),JT=1,5) /
     &3.7226E-04,7.2122E-04,8.2273E-04,8.7424E-04,8.4905E-04,7.9504E-04,
     &6.8600E-04,5.4748E-04,6.4757E-04,4.0471E-04,8.0580E-04,9.2241E-04,
     &9.6290E-04,9.4856E-04,8.9436E-04,7.9088E-04,6.5024E-04,7.6906E-04,
     &4.3485E-04,8.8728E-04,1.0201E-03,1.0664E-03,1.0598E-03,1.0046E-03,
     &9.1434E-04,7.6471E-04,8.8345E-04,4.6779E-04,9.6940E-04,1.1214E-03,
     &1.1802E-03,1.1771E-03,1.1317E-03,1.0506E-03,8.9487E-04,9.7870E-04,
     &5.0564E-04,1.0493E-03,1.2285E-03,1.2989E-03,1.3103E-03,1.2822E-03,
     &1.2004E-03,1.0399E-03,1.0827E-03/
      DATA ((KA(JS,JT, 8, 3),JS=1,9),JT=1,5) /
     &6.8834E-04,1.0497E-03,1.1354E-03,1.1403E-03,1.1091E-03,1.0282E-03,
     &8.6922E-04,6.2179E-04,6.4394E-04,7.5262E-04,1.1719E-03,1.2711E-03,
     &1.2847E-03,1.2498E-03,1.1356E-03,9.7177E-04,7.1700E-04,7.5449E-04,
     &8.1196E-04,1.2925E-03,1.4075E-03,1.4221E-03,1.3886E-03,1.2652E-03,
     &1.0898E-03,8.2946E-04,8.8164E-04,8.7357E-04,1.4119E-03,1.5462E-03,
     &1.5662E-03,1.5234E-03,1.4066E-03,1.2187E-03,9.5583E-04,1.0263E-03,
     &9.4776E-04,1.5351E-03,1.6779E-03,1.7191E-03,1.6760E-03,1.5541E-03,
     &1.3711E-03,1.0942E-03,1.1866E-03/
      DATA ((KA(JS,JT, 9, 3),JS=1,9),JT=1,5) /
     &2.4030E-03,2.8116E-03,2.7490E-03,2.5782E-03,2.3739E-03,2.0451E-03,
     &1.6352E-03,1.1525E-03,7.8397E-04,2.6406E-03,3.0780E-03,3.0311E-03,
     &2.8880E-03,2.6562E-03,2.3012E-03,1.8579E-03,1.2942E-03,9.5305E-04,
     &2.8588E-03,3.3826E-03,3.3331E-03,3.2003E-03,2.9491E-03,2.5645E-03,
     &2.0822E-03,1.4320E-03,1.1371E-03,3.0751E-03,3.6837E-03,3.6521E-03,
     &3.5172E-03,3.2330E-03,2.8266E-03,2.3022E-03,1.5958E-03,1.3270E-03,
     &3.3401E-03,4.0139E-03,3.9712E-03,3.8387E-03,3.5273E-03,3.0908E-03,
     &2.5332E-03,1.7734E-03,1.5421E-03/
      DATA ((KA(JS,JT,10, 3),JS=1,9),JT=1,5) /
     &9.4661E-03,9.3672E-03,8.6815E-03,7.7670E-03,6.6533E-03,5.4267E-03,
     &4.0804E-03,2.5558E-03,1.0683E-03,1.0403E-02,1.0310E-02,9.5215E-03,
     &8.5122E-03,7.3124E-03,5.9813E-03,4.5509E-03,2.8739E-03,1.2946E-03,
     &1.1289E-02,1.1218E-02,1.0349E-02,9.3127E-03,8.0182E-03,6.6138E-03,
     &5.0551E-03,3.2072E-03,1.5622E-03,1.2130E-02,1.2221E-02,1.1320E-02,
     &1.0189E-02,8.7979E-03,7.2832E-03,5.5873E-03,3.5427E-03,1.8389E-03,
     &1.3100E-02,1.3300E-02,1.2340E-02,1.1131E-02,9.6189E-03,7.9428E-03,
     &6.1291E-03,3.8793E-03,2.1440E-03/
      DATA ((KA(JS,JT,11, 3),JS=1,9),JT=1,5) /
     &1.3487E-02,1.2984E-02,1.1782E-02,1.0398E-02,8.8336E-03,7.1334E-03,
     &5.2262E-03,3.1590E-03,1.1845E-03,1.4804E-02,1.4185E-02,1.2823E-02,
     &1.1346E-02,9.6530E-03,7.7631E-03,5.7673E-03,3.5383E-03,1.4275E-03,
     &1.5980E-02,1.5367E-02,1.3971E-02,1.2366E-02,1.0542E-02,8.5565E-03,
     &6.3780E-03,3.9351E-03,1.7235E-03,1.7219E-02,1.6745E-02,1.5253E-02,
     &1.3475E-02,1.1557E-02,9.4243E-03,6.9880E-03,4.3338E-03,2.0121E-03,
     &1.8659E-02,1.8178E-02,1.6582E-02,1.4739E-02,1.2667E-02,1.0254E-02,
     &7.6524E-03,4.7481E-03,2.3669E-03/
      DATA ((KA(JS,JT,12, 3),JS=1,9),JT=1,5) /
     &1.4430E-02,1.3711E-02,1.2344E-02,1.0793E-02,9.1312E-03,7.2788E-03,
     &5.2885E-03,3.1556E-03,1.1392E-03,1.5757E-02,1.4929E-02,1.3431E-02,
     &1.1729E-02,9.9240E-03,7.9738E-03,5.8467E-03,3.5123E-03,1.3911E-03,
     &1.6948E-02,1.6169E-02,1.4634E-02,1.2830E-02,1.0856E-02,8.7512E-03,
     &6.4418E-03,3.8765E-03,1.6585E-03,1.8340E-02,1.7651E-02,1.6013E-02,
     &1.4019E-02,1.1962E-02,9.6662E-03,7.0623E-03,4.2621E-03,1.9806E-03,
     &1.9917E-02,1.9194E-02,1.7450E-02,1.5375E-02,1.3136E-02,1.0559E-02,
     &7.7061E-03,4.6735E-03,2.2886E-03/
      DATA ((KA(JS,JT,13, 3),JS=1,9),JT=1,5) /
     &1.2378E-02,1.1740E-02,1.0520E-02,9.1794E-03,7.7313E-03,6.1547E-03,
     &4.4837E-03,2.6655E-03,9.8041E-04,1.3400E-02,1.2704E-02,1.1442E-02,
     &9.9607E-03,8.4166E-03,6.7824E-03,4.9464E-03,2.9635E-03,1.2027E-03,
     &1.4376E-02,1.3828E-02,1.2497E-02,1.0944E-02,9.2894E-03,7.4859E-03,
     &5.4627E-03,3.2639E-03,1.4455E-03,1.5663E-02,1.5087E-02,1.3675E-02,
     &1.2023E-02,1.0248E-02,8.2522E-03,5.9994E-03,3.5980E-03,1.7132E-03,
     &1.7084E-02,1.6538E-02,1.5027E-02,1.3180E-02,1.1220E-02,9.0513E-03,
     &6.5567E-03,3.9396E-03,2.0154E-03/
      DATA ((KA(JS,JT, 1, 4),JS=1,9),JT=1,5) /
     &4.5432E-05,6.4085E-04,1.0470E-03,1.4404E-03,1.8333E-03,2.2857E-03,
     &2.8540E-03,3.7474E-03,3.3078E-03,4.6775E-05,7.3260E-04,1.2196E-03,
     &1.6906E-03,2.1700E-03,2.7279E-03,3.3928E-03,4.5435E-03,4.0031E-03,
     &4.7907E-05,8.4030E-04,1.4168E-03,1.9771E-03,2.5623E-03,3.2199E-03,
     &4.0380E-03,5.3656E-03,4.7474E-03,4.8733E-05,9.6171E-04,1.6416E-03,
     &2.3126E-03,3.0275E-03,3.7946E-03,4.7571E-03,6.3684E-03,5.6396E-03,
     &4.9568E-05,1.0960E-03,1.8926E-03,2.6893E-03,3.5365E-03,4.4677E-03,
     &5.5986E-03,7.4848E-03,6.6760E-03/
      DATA ((KA(JS,JT, 2, 4),JS=1,9),JT=1,5) /
     &5.9644E-05,6.5165E-04,9.7095E-04,1.2735E-03,1.5693E-03,1.8723E-03,
     &2.2435E-03,2.8303E-03,2.5518E-03,6.1550E-05,7.3433E-04,1.1155E-03,
     &1.4862E-03,1.8480E-03,2.2144E-03,2.6782E-03,3.3851E-03,3.1028E-03,
     &6.3424E-05,8.2814E-04,1.2862E-03,1.7299E-03,2.1667E-03,2.6220E-03,
     &3.1654E-03,4.0290E-03,3.7219E-03,6.4618E-05,9.2770E-04,1.4812E-03,
     &2.0000E-03,2.5281E-03,3.0889E-03,3.7301E-03,4.7467E-03,4.4551E-03,
     &6.6495E-05,1.0413E-03,1.6912E-03,2.3096E-03,2.9324E-03,3.6063E-03,
     &4.3915E-03,5.5831E-03,5.2779E-03/
      DATA ((KA(JS,JT, 3, 4),JS=1,9),JT=1,5) /
     &1.0462E-04,7.2939E-04,1.0510E-03,1.2708E-03,1.4590E-03,1.6268E-03,
     &1.8071E-03,2.0571E-03,1.9983E-03,1.0853E-04,8.1591E-04,1.1915E-03,
     &1.4605E-03,1.6878E-03,1.9079E-03,2.1403E-03,2.4652E-03,2.3859E-03,
     &1.1161E-04,9.0807E-04,1.3452E-03,1.6696E-03,1.9436E-03,2.2298E-03,
     &2.5245E-03,2.9256E-03,2.8236E-03,1.1463E-04,1.0096E-03,1.5126E-03,
     &1.9029E-03,2.2460E-03,2.5957E-03,2.9637E-03,3.4539E-03,3.3286E-03,
     &1.1771E-04,1.1227E-03,1.6998E-03,2.1624E-03,2.5867E-03,3.0031E-03,
     &3.4507E-03,4.0691E-03,3.9216E-03/
      DATA ((KA(JS,JT, 4, 4),JS=1,9),JT=1,5) /
     &1.8980E-04,8.1690E-04,1.1496E-03,1.3743E-03,1.5174E-03,1.5997E-03,
     &1.6364E-03,1.6486E-03,1.6867E-03,1.9681E-04,9.1682E-04,1.2947E-03,
     &1.5538E-03,1.7351E-03,1.8526E-03,1.9065E-03,1.9583E-03,2.0215E-03,
     &2.0208E-04,1.0146E-03,1.4514E-03,1.7516E-03,1.9841E-03,2.1383E-03,
     &2.2138E-03,2.3082E-03,2.3998E-03,2.0762E-04,1.1226E-03,1.6211E-03,
     &1.9728E-03,2.2623E-03,2.4506E-03,2.5563E-03,2.7166E-03,2.8343E-03,
     &2.1385E-04,1.2397E-03,1.8026E-03,2.2223E-03,2.5659E-03,2.7894E-03,
     &2.9545E-03,3.1771E-03,3.3076E-03/
      DATA ((KA(JS,JT, 5, 4),JS=1,9),JT=1,5) /
     &3.1379E-04,9.3426E-04,1.2166E-03,1.4285E-03,1.5654E-03,1.6404E-03,
     &1.5965E-03,1.4828E-03,1.3604E-03,3.2699E-04,1.0358E-03,1.3783E-03,
     &1.6163E-03,1.7786E-03,1.8763E-03,1.8530E-03,1.7399E-03,1.6555E-03,
     &3.3749E-04,1.1387E-03,1.5374E-03,1.8184E-03,2.0178E-03,2.1215E-03,
     &2.1453E-03,2.0239E-03,1.9794E-03,3.4807E-04,1.2529E-03,1.7131E-03,
     &2.0397E-03,2.2808E-03,2.4051E-03,2.4718E-03,2.3502E-03,2.3300E-03,
     &3.5954E-04,1.3777E-03,1.8982E-03,2.2796E-03,2.5586E-03,2.7323E-03,
     &2.8236E-03,2.7161E-03,2.7237E-03/
      DATA ((KA(JS,JT, 6, 4),JS=1,9),JT=1,5) /
     &4.7800E-04,1.0890E-03,1.3133E-03,1.4652E-03,1.5696E-03,1.6077E-03,
     &1.5816E-03,1.3782E-03,1.1543E-03,5.0135E-04,1.1692E-03,1.4789E-03,
     &1.6725E-03,1.7871E-03,1.8348E-03,1.8106E-03,1.6080E-03,1.4185E-03,
     &5.2250E-04,1.2684E-03,1.6447E-03,1.8893E-03,2.0173E-03,2.0845E-03,
     &2.0641E-03,1.8764E-03,1.6970E-03,5.4010E-04,1.3890E-03,1.8350E-03,
     &2.1143E-03,2.2731E-03,2.3591E-03,2.3476E-03,2.1762E-03,2.0061E-03,
     &5.6086E-04,1.5152E-03,2.0323E-03,2.3522E-03,2.5434E-03,2.6585E-03,
     &2.6646E-03,2.5043E-03,2.3580E-03/
      DATA ((KA(JS,JT, 7, 4),JS=1,9),JT=1,5) /
     &7.6472E-04,1.4103E-03,1.5811E-03,1.6521E-03,1.6700E-03,1.6355E-03,
     &1.5716E-03,1.3655E-03,1.1953E-03,8.0405E-04,1.4820E-03,1.7182E-03,
     &1.8432E-03,1.9040E-03,1.8839E-03,1.8004E-03,1.5836E-03,1.3245E-03,
     &8.3976E-04,1.5925E-03,1.8706E-03,2.0547E-03,2.1511E-03,2.1580E-03,
     &2.0497E-03,1.8151E-03,1.5136E-03,8.7606E-04,1.7044E-03,2.0552E-03,
     &2.2845E-03,2.4212E-03,2.4433E-03,2.3312E-03,2.0671E-03,1.7685E-03,
     &9.1065E-04,1.8368E-03,2.2563E-03,2.5472E-03,2.7054E-03,2.7384E-03,
     &2.6284E-03,2.3513E-03,2.0612E-03/
      DATA ((KA(JS,JT, 8, 4),JS=1,9),JT=1,5) /
     &1.4362E-03,2.1402E-03,2.2733E-03,2.2579E-03,2.1547E-03,1.9686E-03,
     &1.7196E-03,1.4177E-03,1.4603E-03,1.5196E-03,2.2635E-03,2.4111E-03,
     &2.4495E-03,2.3642E-03,2.2258E-03,1.9891E-03,1.6444E-03,1.7173E-03,
     &1.5863E-03,2.3882E-03,2.5869E-03,2.6588E-03,2.5952E-03,2.5025E-03,
     &2.2780E-03,1.8819E-03,1.8908E-03,1.6588E-03,2.5177E-03,2.7792E-03,
     &2.8954E-03,2.8908E-03,2.7990E-03,2.5915E-03,2.1558E-03,2.0333E-03,
     &1.7367E-03,2.6935E-03,3.0017E-03,3.1619E-03,3.2065E-03,3.1297E-03,
     &2.9147E-03,2.4525E-03,2.1765E-03/
      DATA ((KA(JS,JT, 9, 4),JS=1,9),JT=1,5) /
     &5.1377E-03,5.6879E-03,5.6413E-03,5.3776E-03,4.8224E-03,4.1689E-03,
     &3.3325E-03,2.2481E-03,2.0122E-03,5.4511E-03,6.1548E-03,6.1332E-03,
     &5.7185E-03,5.1593E-03,4.4551E-03,3.6302E-03,2.5234E-03,2.3673E-03,
     &5.7014E-03,6.5729E-03,6.5250E-03,6.0830E-03,5.4507E-03,4.7941E-03,
     &3.9451E-03,2.8561E-03,2.7249E-03,5.9876E-03,6.9491E-03,6.9266E-03,
     &6.3994E-03,5.8665E-03,5.2094E-03,4.3177E-03,3.2100E-03,3.0655E-03,
     &6.2578E-03,7.3161E-03,7.3395E-03,6.8572E-03,6.3066E-03,5.6391E-03,
     &4.7410E-03,3.6035E-03,3.3864E-03/
      DATA ((KA(JS,JT,10, 4),JS=1,9),JT=1,5) /
     &2.0796E-02,2.0019E-02,1.8165E-02,1.6068E-02,1.3873E-02,1.1404E-02,
     &8.6779E-03,5.2784E-03,2.8413E-03,2.2188E-02,2.1487E-02,1.9617E-02,
     &1.7448E-02,1.5124E-02,1.2499E-02,9.2630E-03,5.6664E-03,3.3963E-03,
     &2.3219E-02,2.2843E-02,2.1086E-02,1.8777E-02,1.6130E-02,1.3209E-02,
     &9.9059E-03,6.0802E-03,4.0019E-03,2.4435E-02,2.4082E-02,2.2303E-02,
     &1.9851E-02,1.7023E-02,1.4121E-02,1.0410E-02,6.5843E-03,4.6477E-03,
     &2.5609E-02,2.5343E-02,2.3560E-02,2.0930E-02,1.8042E-02,1.4937E-02,
     &1.1163E-02,7.1400E-03,5.2598E-03/
      DATA ((KA(JS,JT,11, 4),JS=1,9),JT=1,5) /
     &3.0218E-02,2.8464E-02,2.5566E-02,2.2189E-02,1.8763E-02,1.5165E-02,
     &1.1286E-02,6.7271E-03,3.0443E-03,3.2017E-02,3.0288E-02,2.7351E-02,
     &2.3960E-02,2.0417E-02,1.6571E-02,1.2201E-02,7.2159E-03,3.6072E-03,
     &3.3713E-02,3.2141E-02,2.9172E-02,2.5698E-02,2.1768E-02,1.7546E-02,
     &1.2989E-02,7.6734E-03,4.2021E-03,3.5523E-02,3.3941E-02,3.0802E-02,
     &2.7264E-02,2.3091E-02,1.8512E-02,1.3848E-02,8.2207E-03,4.9261E-03,
     &3.7048E-02,3.5659E-02,3.2500E-02,2.8766E-02,2.4380E-02,1.9724E-02,
     &1.4735E-02,8.8773E-03,5.6292E-03/
      DATA ((KA(JS,JT,12, 4),JS=1,9),JT=1,5) /
     &3.2170E-02,2.9965E-02,2.6774E-02,2.3265E-02,1.9604E-02,1.5767E-02,
     &1.1665E-02,6.8628E-03,2.9693E-03,3.3877E-02,3.1857E-02,2.8686E-02,
     &2.5070E-02,2.1306E-02,1.7043E-02,1.2460E-02,7.3567E-03,3.5157E-03,
     &3.5821E-02,3.3840E-02,3.0497E-02,2.6646E-02,2.2619E-02,1.8108E-02,
     &1.3276E-02,7.8561E-03,4.1559E-03,3.7503E-02,3.5506E-02,3.2126E-02,
     &2.8288E-02,2.3902E-02,1.9181E-02,1.4142E-02,8.3990E-03,4.8088E-03,
     &3.9218E-02,3.7289E-02,3.3764E-02,2.9747E-02,2.5253E-02,2.0345E-02,
     &1.5175E-02,9.0569E-03,5.5254E-03/
      DATA ((KA(JS,JT,13, 4),JS=1,9),JT=1,5) /
     &2.7021E-02,2.5240E-02,2.2638E-02,1.9764E-02,1.6669E-02,1.3389E-02,
     &9.8031E-03,5.7609E-03,2.5391E-03,2.8550E-02,2.6888E-02,2.4164E-02,
     &2.1146E-02,1.7859E-02,1.4211E-02,1.0456E-02,6.1648E-03,3.0359E-03,
     &3.0206E-02,2.8336E-02,2.5560E-02,2.2362E-02,1.8953E-02,1.5151E-02,
     &1.1086E-02,6.5998E-03,3.5704E-03,3.1495E-02,2.9878E-02,2.6989E-02,
     &2.3626E-02,1.9993E-02,1.6052E-02,1.1891E-02,7.0977E-03,4.1349E-03,
     &3.2969E-02,3.1259E-02,2.8282E-02,2.5005E-02,2.1232E-02,1.7061E-02,
     &1.2808E-02,7.6578E-03,4.7180E-03/
      DATA ((KA(JS,JT, 1, 5),JS=1,9),JT=1,5) /
     &7.7208E-05,1.2983E-03,2.1990E-03,3.0698E-03,3.9335E-03,4.8939E-03,
     &6.0507E-03,7.9864E-03,7.3950E-03,7.7960E-05,1.4953E-03,2.5372E-03,
     &3.5852E-03,4.6877E-03,5.9141E-03,7.4453E-03,9.6664E-03,8.9362E-03,
     &7.8616E-05,1.7027E-03,2.9428E-03,4.1895E-03,5.5241E-03,7.0220E-03,
     &8.8894E-03,1.1837E-02,1.0698E-02,7.9284E-05,1.9233E-03,3.3889E-03,
     &4.8861E-03,6.4864E-03,8.2886E-03,1.0489E-02,1.4031E-02,1.2687E-02,
     &8.0311E-05,2.1623E-03,3.8730E-03,5.6513E-03,7.5603E-03,9.7064E-03,
     &1.2306E-02,1.6419E-02,1.4857E-02/
      DATA ((KA(JS,JT, 2, 5),JS=1,9),JT=1,5) /
     &1.0510E-04,1.2010E-03,1.9708E-03,2.6863E-03,3.3801E-03,4.0401E-03,
     &4.8065E-03,5.9839E-03,5.8720E-03,1.0618E-04,1.3719E-03,2.2892E-03,
     &3.1040E-03,3.9264E-03,4.7961E-03,5.8356E-03,7.3351E-03,7.0925E-03,
     &1.0689E-04,1.5661E-03,2.6266E-03,3.5943E-03,4.5681E-03,5.6180E-03,
     &6.8759E-03,8.8640E-03,8.4509E-03,1.0861E-04,1.7752E-03,2.9853E-03,
     &4.1453E-03,5.3192E-03,6.5973E-03,8.1274E-03,1.0456E-02,1.0031E-02,
     &1.1004E-04,1.9945E-03,3.3831E-03,4.7368E-03,6.1454E-03,7.6846E-03,
     &9.5320E-03,1.2312E-02,1.1757E-02/
      DATA ((KA(JS,JT, 3, 5),JS=1,9),JT=1,5) /
     &1.9166E-04,1.3172E-03,1.9278E-03,2.4677E-03,2.9707E-03,3.4895E-03,
     &3.9440E-03,4.4484E-03,4.3497E-03,1.9336E-04,1.4888E-03,2.1997E-03,
     &2.8500E-03,3.4656E-03,4.0405E-03,4.6494E-03,5.3886E-03,5.2876E-03,
     &1.9552E-04,1.6719E-03,2.4978E-03,3.2794E-03,4.0171E-03,4.6883E-03,
     &5.3810E-03,6.3663E-03,6.3594E-03,1.9793E-04,1.8618E-03,2.8193E-03,
     &3.7421E-03,4.6002E-03,5.4246E-03,6.2790E-03,7.4939E-03,7.6260E-03,
     &2.0202E-04,2.0622E-03,3.1772E-03,4.2408E-03,5.2345E-03,6.2239E-03,
     &7.2922E-03,8.8196E-03,9.0035E-03/
      DATA ((KA(JS,JT, 4, 5),JS=1,9),JT=1,5) /
     &3.5080E-04,1.5106E-03,2.1048E-03,2.5530E-03,2.8923E-03,3.1426E-03,
     &3.3832E-03,3.6360E-03,3.6099E-03,3.5494E-04,1.6898E-03,2.3828E-03,
     &2.9160E-03,3.3056E-03,3.6304E-03,3.9520E-03,4.2994E-03,4.2882E-03,
     &3.5978E-04,1.8836E-03,2.6877E-03,3.3008E-03,3.7593E-03,4.1815E-03,
     &4.6053E-03,4.9917E-03,5.0514E-03,3.6746E-04,2.0763E-03,3.0082E-03,
     &3.7203E-03,4.2549E-03,4.7934E-03,5.3242E-03,5.8169E-03,5.8760E-03,
     &3.7911E-04,2.2831E-03,3.3520E-03,4.1619E-03,4.7913E-03,5.4605E-03,
     &6.1003E-03,6.7476E-03,6.8032E-03/
      DATA ((KA(JS,JT, 5, 5),JS=1,9),JT=1,5) /
     &5.8701E-04,1.7294E-03,2.3007E-03,2.6940E-03,2.9671E-03,3.1134E-03,
     &3.1768E-03,3.0490E-03,3.1049E-03,5.9308E-04,1.9111E-03,2.5835E-03,
     &3.0407E-03,3.3851E-03,3.5845E-03,3.6445E-03,3.5746E-03,3.6940E-03,
     &6.0356E-04,2.1186E-03,2.8868E-03,3.4242E-03,3.8486E-03,4.1112E-03,
     &4.1722E-03,4.1940E-03,4.3605E-03,6.1818E-04,2.3278E-03,3.1936E-03,
     &3.8321E-03,4.3352E-03,4.6666E-03,4.7552E-03,4.8779E-03,5.1110E-03,
     &6.3535E-04,2.5512E-03,3.5322E-03,4.2882E-03,4.8679E-03,5.2358E-03,
     &5.3921E-03,5.6199E-03,5.9412E-03/
      DATA ((KA(JS,JT, 6, 5),JS=1,9),JT=1,5) /
     &9.2532E-04,2.0015E-03,2.5277E-03,2.8421E-03,3.0437E-03,3.1018E-03,
     &3.0296E-03,2.8221E-03,2.6040E-03,9.2928E-04,2.2000E-03,2.8005E-03,
     &3.1777E-03,3.4468E-03,3.5577E-03,3.5029E-03,3.2686E-03,3.0871E-03,
     &9.4818E-04,2.4342E-03,3.0892E-03,3.5513E-03,3.8786E-03,4.0485E-03,
     &4.0367E-03,3.7564E-03,3.6084E-03,9.7245E-04,2.6688E-03,3.4060E-03,
     &3.9527E-03,4.3416E-03,4.5754E-03,4.6140E-03,4.3161E-03,4.2427E-03,
     &9.9339E-04,2.9158E-03,3.7426E-03,4.3630E-03,4.8503E-03,5.1436E-03,
     &5.2166E-03,4.9082E-03,4.9378E-03/
      DATA ((KA(JS,JT, 7, 5),JS=1,9),JT=1,5) /
     &1.5302E-03,2.5414E-03,2.9540E-03,3.1974E-03,3.3103E-03,3.2792E-03,
     &3.0626E-03,2.6477E-03,2.2296E-03,1.5437E-03,2.8069E-03,3.2725E-03,
     &3.5730E-03,3.6894E-03,3.7000E-03,3.5141E-03,3.0866E-03,2.7517E-03,
     &1.5828E-03,3.0663E-03,3.6143E-03,3.9451E-03,4.1195E-03,4.1576E-03,
     &4.0163E-03,3.5822E-03,3.3032E-03,1.6196E-03,3.3257E-03,3.9578E-03,
     &4.3834E-03,4.5853E-03,4.6606E-03,4.5385E-03,4.1261E-03,3.9000E-03,
     &1.6660E-03,3.6179E-03,4.3451E-03,4.8226E-03,5.0668E-03,5.1930E-03,
     &5.1180E-03,4.7030E-03,4.5474E-03/
      DATA ((KA(JS,JT, 8, 5),JS=1,9),JT=1,5) /
     &2.9602E-03,3.9304E-03,4.1580E-03,4.2228E-03,4.1165E-03,3.9147E-03,
     &3.5216E-03,2.8265E-03,2.2242E-03,2.9996E-03,4.2668E-03,4.6028E-03,
     &4.6806E-03,4.6212E-03,4.3859E-03,3.9542E-03,3.2447E-03,2.5165E-03,
     &3.0790E-03,4.6440E-03,5.0256E-03,5.1447E-03,5.1348E-03,4.8892E-03,
     &4.4430E-03,3.7287E-03,2.9386E-03,3.1467E-03,5.0515E-03,5.4655E-03,
     &5.6295E-03,5.6440E-03,5.4532E-03,4.9689E-03,4.2347E-03,3.5150E-03,
     &3.2473E-03,5.4319E-03,5.9099E-03,6.1513E-03,6.2421E-03,6.0606E-03,
     &5.5483E-03,4.7752E-03,4.1476E-03/
      DATA ((KA(JS,JT, 9, 5),JS=1,9),JT=1,5) /
     &1.0715E-02,1.1382E-02,1.0899E-02,1.0007E-02,9.0437E-03,7.6976E-03,
     &6.2825E-03,4.4971E-03,3.7652E-03,1.0909E-02,1.1862E-02,1.1397E-02,
     &1.0777E-02,9.8877E-03,8.5937E-03,7.0755E-03,5.0938E-03,4.2507E-03,
     &1.1246E-02,1.2418E-02,1.2293E-02,1.1701E-02,1.0880E-02,9.4889E-03,
     &7.8244E-03,5.6718E-03,4.5213E-03,1.1484E-02,1.3245E-02,1.3252E-02,
     &1.2816E-02,1.1850E-02,1.0328E-02,8.6168E-03,6.3257E-03,4.7999E-03,
     &1.1883E-02,1.4169E-02,1.4256E-02,1.3856E-02,1.2835E-02,1.1196E-02,
     &9.4286E-03,7.0084E-03,5.1834E-03/
      DATA ((KA(JS,JT,10, 5),JS=1,9),JT=1,5) /
     &4.3348E-02,4.0646E-02,3.6539E-02,3.2078E-02,2.7151E-02,2.1841E-02,
     &1.6185E-02,9.9201E-03,6.7193E-03,4.4149E-02,4.2066E-02,3.8091E-02,
     &3.3609E-02,2.8552E-02,2.2983E-02,1.7376E-02,1.1009E-02,7.5436E-03,
     &4.5674E-02,4.3639E-02,3.9624E-02,3.4947E-02,3.0188E-02,2.4887E-02,
     &1.8903E-02,1.2177E-02,8.3556E-03,4.6947E-02,4.5302E-02,4.1477E-02,
     &3.7249E-02,3.2588E-02,2.6746E-02,2.0815E-02,1.3320E-02,9.0276E-03,
     &4.8633E-02,4.7885E-02,4.4096E-02,3.9864E-02,3.4957E-02,2.9104E-02,
     &2.2653E-02,1.4428E-02,9.7333E-03/
      DATA ((KA(JS,JT,11, 5),JS=1,9),JT=1,5) /
     &6.1692E-02,5.6780E-02,5.0232E-02,4.3693E-02,3.6664E-02,2.9101E-02,
     &2.1139E-02,1.2500E-02,7.3091E-03,6.3633E-02,5.9268E-02,5.2865E-02,
     &4.5871E-02,3.8419E-02,3.0609E-02,2.2496E-02,1.3660E-02,8.2073E-03,
     &6.5598E-02,6.1281E-02,5.4828E-02,4.7713E-02,4.0401E-02,3.2790E-02,
     &2.4296E-02,1.5126E-02,8.8706E-03,6.7575E-02,6.3884E-02,5.7739E-02,
     &5.0715E-02,4.3385E-02,3.5358E-02,2.6343E-02,1.6652E-02,9.5120E-03,
     &7.0953E-02,6.7728E-02,6.1195E-02,5.3939E-02,4.6283E-02,3.8093E-02,
     &2.8648E-02,1.8051E-02,1.0472E-02/
      DATA ((KA(JS,JT,12, 5),JS=1,9),JT=1,5) /
     &6.6289E-02,6.0781E-02,5.3636E-02,4.6304E-02,3.8429E-02,3.0261E-02,
     &2.1777E-02,1.2752E-02,6.7746E-03,6.8551E-02,6.3174E-02,5.6063E-02,
     &4.8348E-02,4.0059E-02,3.1785E-02,2.3315E-02,1.3856E-02,7.6622E-03,
     &7.0441E-02,6.5327E-02,5.8258E-02,5.0611E-02,4.2587E-02,3.4170E-02,
     &2.5237E-02,1.5295E-02,8.3950E-03,7.3259E-02,6.8842E-02,6.1685E-02,
     &5.3758E-02,4.5436E-02,3.6706E-02,2.7377E-02,1.6771E-02,8.9439E-03,
     &7.7467E-02,7.3081E-02,6.5449E-02,5.7418E-02,4.8677E-02,3.9671E-02,
     &2.9550E-02,1.8202E-02,9.6319E-03/
      DATA ((KA(JS,JT,13, 5),JS=1,9),JT=1,5) /
     &5.6671E-02,5.1982E-02,4.5878E-02,3.9500E-02,3.2807E-02,2.5894E-02,
     &1.8717E-02,1.0942E-02,5.7523E-03,5.8577E-02,5.4011E-02,4.7896E-02,
     &4.1459E-02,3.4661E-02,2.7671E-02,2.0186E-02,1.2025E-02,6.4664E-03,
     &6.0296E-02,5.6294E-02,5.0261E-02,4.3702E-02,3.6751E-02,2.9579E-02,
     &2.1985E-02,1.3253E-02,7.0517E-03,6.3403E-02,5.9492E-02,5.3202E-02,
     &4.6643E-02,3.9435E-02,3.1951E-02,2.3841E-02,1.4493E-02,7.4965E-03,
     &6.7016E-02,6.3341E-02,5.7105E-02,5.0058E-02,4.2357E-02,3.4571E-02,
     &2.5674E-02,1.5753E-02,8.1075E-03/
      DATA ((KA(JS,JT, 1, 6),JS=1,9),JT=1,5) /
     &1.5042E-04,2.4198E-03,4.3016E-03,6.2979E-03,8.5168E-03,1.0968E-02,
     &1.3929E-02,1.8584E-02,1.6834E-02,1.5402E-04,2.7874E-03,5.0906E-03,
     &7.5405E-03,1.0172E-02,1.3049E-02,1.6523E-02,2.2172E-02,2.0134E-02,
     &1.5658E-04,3.2116E-03,5.9652E-03,8.9274E-03,1.2070E-02,1.5491E-02,
     &1.9553E-02,2.6056E-02,2.3919E-02,1.5960E-04,3.6836E-03,6.9617E-03,
     &1.0460E-02,1.4154E-02,1.8205E-02,2.3055E-02,3.0555E-02,2.8089E-02,
     &1.6165E-04,4.2037E-03,8.0817E-03,1.2177E-02,1.6484E-02,2.1191E-02,
     &2.6875E-02,3.5769E-02,3.2739E-02/
      DATA ((KA(JS,JT, 2, 6),JS=1,9),JT=1,5) /
     &2.0998E-04,2.2589E-03,3.7899E-03,5.2410E-03,6.7744E-03,8.5703E-03,
     &1.0697E-02,1.3881E-02,1.3198E-02,2.1456E-04,2.6007E-03,4.3946E-03,
     &6.1987E-03,8.1361E-03,1.0272E-02,1.2733E-02,1.6541E-02,1.5875E-02,
     &2.1842E-04,2.9560E-03,5.0887E-03,7.2752E-03,9.6552E-03,1.2252E-02,
     &1.5232E-02,1.9582E-02,1.8968E-02,2.2236E-04,3.3459E-03,5.8736E-03,
     &8.5067E-03,1.1349E-02,1.4414E-02,1.7964E-02,2.3187E-02,2.2355E-02,
     &2.2547E-04,3.7713E-03,6.7501E-03,9.9039E-03,1.3264E-02,1.6870E-02,
     &2.1032E-02,2.7154E-02,2.6176E-02/
      DATA ((KA(JS,JT, 3, 6),JS=1,9),JT=1,5) /
     &3.8749E-04,2.3567E-03,3.5784E-03,4.7302E-03,5.7992E-03,6.7584E-03,
     &7.8929E-03,9.6810E-03,9.8950E-03,3.9603E-04,2.6464E-03,4.1366E-03,
     &5.5007E-03,6.7822E-03,8.0470E-03,9.4913E-03,1.1619E-02,1.2036E-02,
     &4.0456E-04,2.9559E-03,4.7389E-03,6.3508E-03,7.8799E-03,9.4907E-03,
     &1.1392E-02,1.3956E-02,1.4457E-02,4.1360E-04,3.3032E-03,5.4024E-03,
     &7.2987E-03,9.1447E-03,1.1131E-02,1.3466E-02,1.6568E-02,1.7113E-02,
     &4.1860E-04,3.6941E-03,6.1025E-03,8.3274E-03,1.0570E-02,1.3013E-02,
     &1.5813E-02,1.9496E-02,2.0111E-02/
      DATA ((KA(JS,JT, 4, 6),JS=1,9),JT=1,5) /
     &7.1991E-04,2.8586E-03,3.8493E-03,4.6115E-03,5.2750E-03,5.9823E-03,
     &6.5939E-03,7.1204E-03,6.9950E-03,7.3932E-04,3.1546E-03,4.3292E-03,
     &5.2487E-03,6.1632E-03,7.0322E-03,7.8025E-03,8.5583E-03,8.4949E-03,
     &7.5829E-04,3.4592E-03,4.8355E-03,5.9709E-03,7.1395E-03,8.1909E-03,
     &9.1159E-03,1.0292E-02,1.0335E-02,7.6959E-04,3.8025E-03,5.3880E-03,
     &6.7853E-03,8.1872E-03,9.4673E-03,1.0631E-02,1.2218E-02,1.2516E-02,
     &7.7964E-04,4.1796E-03,5.9947E-03,7.6582E-03,9.3446E-03,1.0850E-02,
     &1.2339E-02,1.4388E-02,1.5009E-02/
      DATA ((KA(JS,JT, 5, 6),JS=1,9),JT=1,5) /
     &1.2241E-03,3.4685E-03,4.4046E-03,5.0844E-03,5.4871E-03,5.7179E-03,
     &5.7620E-03,5.9818E-03,6.1472E-03,1.2601E-03,3.8071E-03,4.8995E-03,
     &5.7159E-03,6.2114E-03,6.5597E-03,6.8164E-03,7.1370E-03,7.3501E-03,
     &1.2927E-03,4.1224E-03,5.4389E-03,6.3889E-03,6.9938E-03,7.4901E-03,
     &7.9768E-03,8.3697E-03,8.6918E-03,1.3168E-03,4.4980E-03,6.0112E-03,
     &7.1194E-03,7.8654E-03,8.4979E-03,9.2325E-03,9.7616E-03,1.0181E-02,
     &1.3499E-03,4.8864E-03,6.6201E-03,7.8699E-03,8.7970E-03,9.6632E-03,
     &1.0606E-02,1.1344E-02,1.1812E-02/
      DATA ((KA(JS,JT, 6, 6),JS=1,9),JT=1,5) /
     &1.9359E-03,4.1954E-03,5.0050E-03,5.5462E-03,5.8539E-03,5.9443E-03,
     &5.7417E-03,5.1473E-03,5.2472E-03,2.0045E-03,4.5957E-03,5.5374E-03,
     &6.1876E-03,6.5964E-03,6.7501E-03,6.5907E-03,6.0581E-03,6.2872E-03,
     &2.0656E-03,4.9538E-03,6.0748E-03,6.8772E-03,7.3778E-03,7.6157E-03,
     &7.5054E-03,7.1291E-03,7.4717E-03,2.1235E-03,5.3117E-03,6.6418E-03,
     &7.6042E-03,8.2374E-03,8.5589E-03,8.5173E-03,8.3153E-03,8.7345E-03,
     &2.1708E-03,5.7022E-03,7.2758E-03,8.4071E-03,9.1623E-03,9.5678E-03,
     &9.5860E-03,9.6197E-03,1.0118E-02/
      DATA ((KA(JS,JT, 7, 6),JS=1,9),JT=1,5) /
     &3.2088E-03,5.3976E-03,6.1152E-03,6.4273E-03,6.5565E-03,6.4169E-03,
     &6.0483E-03,5.1718E-03,4.3840E-03,3.3329E-03,5.8617E-03,6.7065E-03,
     &7.1293E-03,7.3332E-03,7.2483E-03,6.8991E-03,6.0070E-03,5.1893E-03,
     &3.4526E-03,6.3215E-03,7.2907E-03,7.8484E-03,8.1105E-03,8.1244E-03,
     &7.7961E-03,6.9012E-03,6.1115E-03,3.5398E-03,6.7841E-03,7.9069E-03,
     &8.5448E-03,8.9613E-03,9.0608E-03,8.7760E-03,7.8768E-03,7.1030E-03,
     &3.6419E-03,7.2100E-03,8.5218E-03,9.3036E-03,9.8959E-03,1.0073E-02,
     &9.8505E-03,8.9292E-03,8.2308E-03/
      DATA ((KA(JS,JT, 8, 6),JS=1,9),JT=1,5) /
     &6.2734E-03,8.1929E-03,8.7347E-03,8.8396E-03,8.5498E-03,7.9153E-03,
     &7.0346E-03,5.6808E-03,4.1552E-03,6.5441E-03,8.8580E-03,9.5108E-03,
     &9.7024E-03,9.3653E-03,8.8364E-03,7.9480E-03,6.5304E-03,4.9813E-03,
     &6.7938E-03,9.5212E-03,1.0312E-02,1.0573E-02,1.0260E-02,9.7376E-03,
     &8.8728E-03,7.4306E-03,5.9661E-03,6.9763E-03,1.0160E-02,1.1107E-02,
     &1.1420E-02,1.1193E-02,1.0684E-02,9.8581E-03,8.3990E-03,6.9644E-03,
     &7.1912E-03,1.0832E-02,1.1979E-02,1.2319E-02,1.2084E-02,1.1646E-02,
     &1.0942E-02,9.4605E-03,8.0079E-03/
      DATA ((KA(JS,JT, 9, 6),JS=1,9),JT=1,5) /
     &2.3423E-02,2.3874E-02,2.2570E-02,2.0907E-02,1.8747E-02,1.6279E-02,
     &1.3268E-02,9.1967E-03,5.4472E-03,2.4372E-02,2.5487E-02,2.4526E-02,
     &2.2806E-02,2.0430E-02,1.7721E-02,1.4547E-02,1.0257E-02,5.8874E-03,
     &2.5322E-02,2.7228E-02,2.6228E-02,2.4576E-02,2.2164E-02,1.9365E-02,
     &1.5921E-02,1.1389E-02,6.8168E-03,2.6144E-02,2.8709E-02,2.7958E-02,
     &2.6366E-02,2.3791E-02,2.0979E-02,1.7361E-02,1.2542E-02,7.8623E-03,
     &2.7002E-02,3.0246E-02,2.9564E-02,2.8028E-02,2.5537E-02,2.2731E-02,
     &1.8860E-02,1.3722E-02,9.0318E-03/
      DATA ((KA(JS,JT,10, 6),JS=1,9),JT=1,5) /
     &9.6759E-02,8.9920E-02,8.0281E-02,6.9298E-02,5.8160E-02,4.6685E-02,
     &3.4489E-02,2.1137E-02,9.1317E-03,1.0130E-01,9.4928E-02,8.5063E-02,
     &7.4190E-02,6.2751E-02,5.0819E-02,3.7815E-02,2.3107E-02,9.7753E-03,
     &1.0500E-01,9.9899E-02,9.0245E-02,7.9682E-02,6.7667E-02,5.4638E-02,
     &4.0873E-02,2.5040E-02,1.0330E-02,1.0896E-01,1.0463E-01,9.5171E-02,
     &8.3946E-02,7.1420E-02,5.8144E-02,4.3799E-02,2.7205E-02,1.1084E-02,
     &1.1285E-01,1.0942E-01,9.9931E-02,8.8439E-02,7.5783E-02,6.1708E-02,
     &4.6484E-02,2.9531E-02,1.2060E-02/
      DATA ((KA(JS,JT,11, 6),JS=1,9),JT=1,5) /
     &1.4204E-01,1.2997E-01,1.1520E-01,9.8769E-02,8.1420E-02,6.4217E-02,
     &4.6399E-02,2.7414E-02,9.3511E-03,1.4781E-01,1.3669E-01,1.2188E-01,
     &1.0492E-01,8.7668E-02,6.9566E-02,5.0549E-02,3.0014E-02,1.0330E-02,
     &1.5380E-01,1.4353E-01,1.2793E-01,1.1113E-01,9.3325E-02,7.4108E-02,
     &5.4029E-02,3.2498E-02,1.1533E-02,1.6004E-01,1.5059E-01,1.3460E-01,
     &1.1704E-01,9.8404E-02,7.8709E-02,5.7847E-02,3.4798E-02,1.2510E-02,
     &1.6529E-01,1.5606E-01,1.4056E-01,1.2310E-01,1.0396E-01,8.3240E-02,
     &6.1355E-02,3.7415E-02,1.3283E-02/
      DATA ((KA(JS,JT,12, 6),JS=1,9),JT=1,5) /
     &1.5238E-01,1.3897E-01,1.2274E-01,1.0509E-01,8.6816E-02,6.8213E-02,
     &4.8813E-02,2.8303E-02,8.9094E-03,1.5887E-01,1.4598E-01,1.2939E-01,
     &1.1123E-01,9.2497E-02,7.3141E-02,5.2574E-02,3.0889E-02,9.4910E-03,
     &1.6583E-01,1.5402E-01,1.3664E-01,1.1788E-01,9.8276E-02,7.7826E-02,
     &5.6134E-02,3.3329E-02,1.0354E-02,1.7232E-01,1.6056E-01,1.4294E-01,
     &1.2398E-01,1.0387E-01,8.2524E-02,5.9981E-02,3.5800E-02,1.1471E-02,
     &1.7822E-01,1.6713E-01,1.4985E-01,1.3045E-01,1.0965E-01,8.7208E-02,
     &6.3531E-02,3.8400E-02,1.2648E-02/
      DATA ((KA(JS,JT,13, 6),JS=1,9),JT=1,5) /
     &1.2851E-01,1.1760E-01,1.0432E-01,8.9471E-02,7.3952E-02,5.7965E-02,
     &4.1571E-02,2.4244E-02,7.5271E-03,1.3461E-01,1.2431E-01,1.1020E-01,
     &9.4715E-02,7.8713E-02,6.2191E-02,4.4720E-02,2.6349E-02,7.9374E-03,
     &1.4091E-01,1.3079E-01,1.1585E-01,1.0015E-01,8.3554E-02,6.6181E-02,
     &4.7816E-02,2.8551E-02,8.7113E-03,1.4657E-01,1.3673E-01,1.2189E-01,
     &1.0573E-01,8.8680E-02,7.0418E-02,5.0990E-02,3.0632E-02,9.8158E-03,
     &1.5197E-01,1.4281E-01,1.2778E-01,1.1111E-01,9.3402E-02,7.4099E-02,
     &5.4192E-02,3.2952E-02,1.0865E-02/
      DATA ((KA(JS,JT, 1, 7),JS=1,9),JT=1,5) /
     &2.9775E-04,4.9903E-03,9.5966E-03,1.4458E-02,1.9550E-02,2.5066E-02,
     &3.1548E-02,4.0907E-02,3.8920E-02,2.9974E-04,5.8708E-03,1.1484E-02,
     &1.7340E-02,2.3486E-02,3.0156E-02,3.8022E-02,4.9522E-02,4.6798E-02,
     &3.0249E-04,6.8379E-03,1.3523E-02,2.0453E-02,2.7734E-02,3.5680E-02,
     &4.5116E-02,5.8960E-02,5.5301E-02,3.0505E-04,7.9161E-03,1.5750E-02,
     &2.3843E-02,3.2353E-02,4.1634E-02,5.2683E-02,6.9279E-02,6.4544E-02,
     &3.0784E-04,9.1145E-03,1.8178E-02,2.7529E-02,3.7353E-02,4.8074E-02,
     &6.0824E-02,8.0052E-02,7.4551E-02/
      DATA ((KA(JS,JT, 2, 7),JS=1,9),JT=1,5) /
     &4.4044E-04,4.5745E-03,7.9442E-03,1.1658E-02,1.5612E-02,1.9809E-02,
     &2.4586E-02,3.1373E-02,3.0910E-02,4.4502E-04,5.2457E-03,9.4321E-03,
     &1.4009E-02,1.8804E-02,2.3915E-02,2.9756E-02,3.8088E-02,3.7317E-02,
     &4.4893E-04,5.9898E-03,1.1101E-02,1.6604E-02,2.2319E-02,2.8413E-02,
     &3.5386E-02,4.5425E-02,4.4358E-02,4.5303E-04,6.8346E-03,1.2966E-02,
     &1.9451E-02,2.6168E-02,3.3333E-02,4.1534E-02,5.3372E-02,5.2063E-02,
     &4.5653E-04,7.7989E-03,1.5045E-02,2.2592E-02,3.0407E-02,3.8717E-02,
     &4.8217E-02,6.1953E-02,6.0541E-02/
      DATA ((KA(JS,JT, 3, 7),JS=1,9),JT=1,5) /
     &8.7011E-04,4.7519E-03,7.4191E-03,9.7724E-03,1.2242E-02,1.5076E-02,
     &1.8293E-02,2.2402E-02,2.3454E-02,8.7761E-04,5.4004E-03,8.5169E-03,
     &1.1449E-02,1.4656E-02,1.8245E-02,2.2203E-02,2.7303E-02,2.8468E-02,
     &8.8555E-04,6.0960E-03,9.7399E-03,1.3383E-02,1.7420E-02,2.1805E-02,
     &2.6578E-02,3.2747E-02,3.4102E-02,8.8837E-04,6.8303E-03,1.1116E-02,
     &1.5598E-02,2.0532E-02,2.5757E-02,3.1445E-02,3.8773E-02,4.0387E-02,
     &8.9568E-04,7.6159E-03,1.2685E-02,1.8136E-02,2.4011E-02,3.0157E-02,
     &3.6817E-02,4.5383E-02,4.7355E-02/
      DATA ((KA(JS,JT, 4, 7),JS=1,9),JT=1,5) /
     &1.7216E-03,5.6014E-03,7.5736E-03,9.4674E-03,1.1191E-02,1.2535E-02,
     &1.3987E-02,1.6268E-02,1.7296E-02,1.7298E-03,6.1879E-03,8.6832E-03,
     &1.0978E-02,1.2974E-02,1.4749E-02,1.6870E-02,1.9909E-02,2.1431E-02,
     &1.7341E-03,6.8367E-03,9.8584E-03,1.2616E-02,1.4944E-02,1.7324E-02,
     &2.0237E-02,2.4035E-02,2.5998E-02,1.7534E-03,7.5128E-03,1.1127E-02,
     &1.4362E-02,1.7213E-02,2.0310E-02,2.4053E-02,2.8665E-02,3.1074E-02,
     &1.7641E-03,8.2760E-03,1.2507E-02,1.6268E-02,1.9802E-02,2.3773E-02,
     &2.8361E-02,3.3846E-02,3.6727E-02/
      DATA ((KA(JS,JT, 5, 7),JS=1,9),JT=1,5) /
     &3.0539E-03,7.3205E-03,8.9564E-03,9.9240E-03,1.0675E-02,1.1625E-02,
     &1.2424E-02,1.2649E-02,1.2475E-02,3.0697E-03,8.0642E-03,9.9550E-03,
     &1.1166E-02,1.2428E-02,1.3587E-02,1.4545E-02,1.5222E-02,1.4936E-02,
     &3.0978E-03,8.8320E-03,1.1001E-02,1.2560E-02,1.4306E-02,1.5802E-02,
     &1.6906E-02,1.8302E-02,1.7957E-02,3.1191E-03,9.5288E-03,1.2130E-02,
     &1.4148E-02,1.6348E-02,1.8245E-02,1.9668E-02,2.1849E-02,2.2010E-02,
     &3.1173E-03,1.0269E-02,1.3281E-02,1.5937E-02,1.8604E-02,2.0861E-02,
     &2.2868E-02,2.5903E-02,2.6735E-02/
      DATA ((KA(JS,JT, 6, 7),JS=1,9),JT=1,5) /
     &4.9571E-03,9.1596E-03,1.0920E-02,1.1683E-02,1.1947E-02,1.1808E-02,
     &1.1212E-02,1.1074E-02,1.1113E-02,5.0027E-03,9.9969E-03,1.2157E-02,
     &1.3082E-02,1.3449E-02,1.3422E-02,1.3156E-02,1.3134E-02,1.3279E-02,
     &5.0299E-03,1.0940E-02,1.3400E-02,1.4481E-02,1.5090E-02,1.5137E-02,
     &1.5334E-02,1.5370E-02,1.5787E-02,5.0401E-03,1.1872E-02,1.4616E-02,
     &1.5947E-02,1.6778E-02,1.7087E-02,1.7734E-02,1.7868E-02,1.8548E-02,
     &5.0929E-03,1.2799E-02,1.5866E-02,1.7551E-02,1.8584E-02,1.9414E-02,
     &2.0410E-02,2.0816E-02,2.1713E-02/
      DATA ((KA(JS,JT, 7, 7),JS=1,9),JT=1,5) /
     &8.4314E-03,1.2463E-02,1.3843E-02,1.4407E-02,1.4329E-02,1.3643E-02,
     &1.2423E-02,1.0398E-02,1.0049E-02,8.4877E-03,1.3426E-02,1.5237E-02,
     &1.6099E-02,1.6143E-02,1.5465E-02,1.4143E-02,1.1980E-02,1.1912E-02,
     &8.5061E-03,1.4450E-02,1.6739E-02,1.7865E-02,1.8006E-02,1.7376E-02,
     &1.5998E-02,1.3868E-02,1.3962E-02,8.5919E-03,1.5490E-02,1.8250E-02,
     &1.9632E-02,1.9933E-02,1.9343E-02,1.7978E-02,1.6120E-02,1.6346E-02,
     &8.6244E-03,1.6546E-02,1.9762E-02,2.1475E-02,2.1907E-02,2.1414E-02,
     &2.0099E-02,1.8617E-02,1.9113E-02/
      DATA ((KA(JS,JT, 8, 7),JS=1,9),JT=1,5) /
     &1.6801E-02,2.0166E-02,2.0707E-02,2.0359E-02,1.9438E-02,1.7889E-02,
     &1.5556E-02,1.2093E-02,8.8687E-03,1.6841E-02,2.1258E-02,2.2460E-02,
     &2.2381E-02,2.1605E-02,2.0124E-02,1.7632E-02,1.3928E-02,1.0513E-02,
     &1.6945E-02,2.2389E-02,2.4138E-02,2.4525E-02,2.3968E-02,2.2498E-02,
     &1.9836E-02,1.5792E-02,1.2224E-02,1.7081E-02,2.3610E-02,2.5903E-02,
     &2.6682E-02,2.6351E-02,2.4884E-02,2.2197E-02,1.7790E-02,1.4133E-02,
     &1.7107E-02,2.4831E-02,2.7681E-02,2.8814E-02,2.8766E-02,2.7453E-02,
     &2.4610E-02,1.9914E-02,1.6383E-02/
      DATA ((KA(JS,JT, 9, 7),JS=1,9),JT=1,5) /
     &6.2717E-02,6.2735E-02,5.8603E-02,5.2748E-02,4.6263E-02,3.9117E-02,
     &3.0759E-02,2.1087E-02,9.9200E-03,6.3094E-02,6.4670E-02,6.0602E-02,
     &5.5392E-02,4.9420E-02,4.2558E-02,3.4002E-02,2.3733E-02,1.2138E-02,
     &6.3563E-02,6.6269E-02,6.3058E-02,5.8357E-02,5.2632E-02,4.5743E-02,
     &3.7261E-02,2.6594E-02,1.4716E-02,6.4005E-02,6.8005E-02,6.5556E-02,
     &6.1466E-02,5.6121E-02,4.9302E-02,4.0642E-02,2.9533E-02,1.7598E-02,
     &6.4303E-02,6.9477E-02,6.8109E-02,6.4600E-02,5.9691E-02,5.2874E-02,
     &4.4056E-02,3.2670E-02,2.0612E-02/
      DATA ((KA(JS,JT,10, 7),JS=1,9),JT=1,5) /
     &2.6283E-01,2.3848E-01,2.1237E-01,1.8399E-01,1.5364E-01,1.2096E-01,
     &8.6686E-02,5.0921E-02,1.2662E-02,2.6495E-01,2.4348E-01,2.1796E-01,
     &1.8933E-01,1.5813E-01,1.2513E-01,9.1228E-02,5.5191E-02,1.6120E-02,
     &2.6701E-01,2.4762E-01,2.2286E-01,1.9379E-01,1.6250E-01,1.3046E-01,
     &9.6273E-02,5.9643E-02,2.0041E-02,2.6827E-01,2.5124E-01,2.2683E-01,
     &1.9843E-01,1.6799E-01,1.3618E-01,1.0159E-01,6.3939E-02,2.4035E-02,
     &2.7234E-01,2.5705E-01,2.3264E-01,2.0401E-01,1.7374E-01,1.4157E-01,
     &1.0689E-01,6.8300E-02,2.8241E-02/
      DATA ((KA(JS,JT,11, 7),JS=1,9),JT=1,5) /
     &3.8435E-01,3.4486E-01,3.0408E-01,2.6025E-01,2.1577E-01,1.6840E-01,
     &1.1827E-01,6.6862E-02,1.4067E-02,3.8808E-01,3.5079E-01,3.0947E-01,
     &2.6705E-01,2.2115E-01,1.7271E-01,1.2306E-01,7.1102E-02,1.7282E-02,
     &3.9133E-01,3.5683E-01,3.1692E-01,2.7320E-01,2.2652E-01,1.7854E-01,
     &1.2887E-01,7.5471E-02,2.0650E-02,3.9688E-01,3.6404E-01,3.2547E-01,
     &2.8118E-01,2.3421E-01,1.8549E-01,1.3490E-01,8.0175E-02,2.4385E-02,
     &4.0366E-01,3.7211E-01,3.3310E-01,2.8891E-01,2.4168E-01,1.9277E-01,
     &1.4118E-01,8.5255E-02,2.8315E-02/
      DATA ((KA(JS,JT,12, 7),JS=1,9),JT=1,5) /
     &4.1788E-01,3.7417E-01,3.2848E-01,2.8026E-01,2.3093E-01,1.7900E-01,
     &1.2516E-01,6.9829E-02,1.3077E-02,4.2346E-01,3.8197E-01,3.3568E-01,
     &2.8761E-01,2.3734E-01,1.8458E-01,1.3037E-01,7.4069E-02,1.6501E-02,
     &4.3061E-01,3.9035E-01,3.4485E-01,2.9676E-01,2.4502E-01,1.9175E-01,
     &1.3672E-01,7.8434E-02,1.9942E-02,4.3991E-01,4.0142E-01,3.5621E-01,
     &3.0583E-01,2.5354E-01,1.9941E-01,1.4294E-01,8.2867E-02,2.3156E-02,
     &4.5018E-01,4.1383E-01,3.6847E-01,3.1728E-01,2.6385E-01,2.0769E-01,
     &1.4984E-01,8.7550E-02,2.5906E-02/
      DATA ((KA(JS,JT,13, 7),JS=1,9),JT=1,5) /
     &3.5954E-01,3.2293E-01,2.8290E-01,2.4149E-01,1.9855E-01,1.5392E-01,
     &1.0799E-01,6.0538E-02,1.1582E-02,3.6620E-01,3.3095E-01,2.9118E-01,
     &2.4962E-01,2.0579E-01,1.6035E-01,1.1345E-01,6.4561E-02,1.4555E-02,
     &3.7497E-01,3.4139E-01,3.0205E-01,2.5902E-01,2.1397E-01,1.6755E-01,
     &1.1907E-01,6.8274E-02,1.7516E-02,3.8491E-01,3.5293E-01,3.1344E-01,
     &2.6951E-01,2.2338E-01,1.7537E-01,1.2550E-01,7.2213E-02,1.9685E-02,
     &3.9456E-01,3.6430E-01,3.2370E-01,2.7885E-01,2.3209E-01,1.8326E-01,
     &1.3235E-01,7.6929E-02,2.1105E-02/
      DATA ((KA(JS,JT, 1, 8),JS=1,9),JT=1,5) /
     &6.2097E-04,1.4117E-02,2.8277E-02,4.2775E-02,5.7848E-02,7.3960E-02,
     &9.2407E-02,1.1864E-01,1.1554E-01,6.1974E-04,1.6905E-02,3.3889E-02,
     &5.1276E-02,6.9348E-02,8.8703E-02,1.1084E-01,1.4177E-01,1.3853E-01,
     &6.1587E-04,1.9900E-02,3.9925E-02,6.0422E-02,8.1729E-02,1.0451E-01,
     &1.3061E-01,1.6696E-01,1.6328E-01,6.1184E-04,2.3086E-02,4.6344E-02,
     &7.0163E-02,9.4901E-02,1.2137E-01,1.5165E-01,1.9370E-01,1.8962E-01,
     &6.0950E-04,2.6468E-02,5.3164E-02,8.0478E-02,1.0886E-01,1.3922E-01,
     &1.7398E-01,2.2192E-01,2.1753E-01/
      DATA ((KA(JS,JT, 2, 8),JS=1,9),JT=1,5) /
     &9.4214E-04,1.1864E-02,2.3368E-02,3.5168E-02,4.7308E-02,6.0060E-02,
     &7.4293E-02,9.3548E-02,9.4381E-02,9.3967E-04,1.4205E-02,2.8221E-02,
     &4.2491E-02,5.7165E-02,7.2616E-02,8.9835E-02,1.1322E-01,1.1408E-01,
     &9.3666E-04,1.6793E-02,3.3453E-02,5.0403E-02,6.7823E-02,8.6143E-02,
     &1.0657E-01,1.3437E-01,1.3538E-01,9.3490E-04,1.9589E-02,3.9087E-02,
     &5.8901E-02,7.9281E-02,1.0068E-01,1.2458E-01,1.5697E-01,1.5829E-01,
     &9.3255E-04,2.2561E-02,4.5087E-02,6.7983E-02,9.1508E-02,1.1621E-01,
     &1.4375E-01,1.8108E-01,1.8274E-01/
      DATA ((KA(JS,JT, 3, 8),JS=1,9),JT=1,5) /
     &1.9614E-03,1.1299E-02,1.9005E-02,2.7782E-02,3.7000E-02,4.6522E-02,
     &5.6657E-02,6.9080E-02,7.3508E-02,1.9548E-03,1.2955E-02,2.2891E-02,
     &3.3903E-02,4.5254E-02,5.6922E-02,6.9355E-02,8.4555E-02,9.0001E-02,
     &1.9534E-03,1.4833E-02,2.7240E-02,4.0599E-02,5.4239E-02,6.8264E-02,
     &8.3194E-02,1.0146E-01,1.0796E-01,1.9479E-03,1.6939E-02,3.1981E-02,
     &4.7805E-02,6.3918E-02,8.0501E-02,9.8164E-02,1.1980E-01,1.2731E-01,
     &1.9437E-03,1.9215E-02,3.7014E-02,5.5432E-02,7.4159E-02,9.3422E-02,
     &1.1404E-01,1.3937E-01,1.4780E-01/
      DATA ((KA(JS,JT, 4, 8),JS=1,9),JT=1,5) /
     &4.1141E-03,1.2873E-02,1.8872E-02,2.3795E-02,2.9310E-02,3.5813E-02,
     &4.3001E-02,5.1220E-02,5.6278E-02,4.1183E-03,1.4575E-02,2.1599E-02,
     &2.8253E-02,3.5801E-02,4.4309E-02,5.3363E-02,6.3628E-02,6.9867E-02,
     &4.1349E-03,1.6355E-02,2.4672E-02,3.3305E-02,4.3074E-02,5.3625E-02,
     &6.4673E-02,7.7228E-02,8.4695E-02,4.1308E-03,1.8173E-02,2.8034E-02,
     &3.8865E-02,5.0949E-02,6.3606E-02,7.6798E-02,9.1846E-02,1.0056E-01,
     &4.1264E-03,1.9905E-02,3.1676E-02,4.4946E-02,5.9333E-02,7.4191E-02,
     &8.9640E-02,1.0735E-01,1.1739E-01/
      DATA ((KA(JS,JT, 5, 8),JS=1,9),JT=1,5) /
     &7.8459E-03,1.5273E-02,2.0315E-02,2.4490E-02,2.7833E-02,3.0201E-02,
     &3.3378E-02,3.8411E-02,4.1001E-02,7.8747E-03,1.6898E-02,2.3176E-02,
     &2.8487E-02,3.2405E-02,3.6383E-02,4.1437E-02,4.8316E-02,5.2769E-02,
     &7.8992E-03,1.8661E-02,2.6253E-02,3.2541E-02,3.7550E-02,4.3266E-02,
     &5.0422E-02,5.9136E-02,6.5527E-02,7.8989E-03,2.0558E-02,2.9408E-02,
     &3.6576E-02,4.3219E-02,5.0946E-02,6.0207E-02,7.0821E-02,7.8616E-02,
     &7.9229E-03,2.2512E-02,3.2599E-02,4.0913E-02,4.9454E-02,5.9390E-02,
     &7.0729E-02,8.3313E-02,9.2573E-02/
      DATA ((KA(JS,JT, 6, 8),JS=1,9),JT=1,5) /
     &1.3755E-02,2.1264E-02,2.4103E-02,2.5712E-02,2.7798E-02,2.9236E-02,
     &2.9846E-02,2.9593E-02,2.7586E-02,1.3782E-02,2.2999E-02,2.6490E-02,
     &2.9514E-02,3.2454E-02,3.4496E-02,3.5566E-02,3.7000E-02,3.5132E-02,
     &1.3863E-02,2.4665E-02,2.9042E-02,3.3641E-02,3.7254E-02,4.0147E-02,
     &4.1998E-02,4.5403E-02,4.4921E-02,1.3921E-02,2.6309E-02,3.1937E-02,
     &3.7874E-02,4.2332E-02,4.5980E-02,4.9161E-02,5.4719E-02,5.5713E-02,
     &1.4010E-02,2.7955E-02,3.5119E-02,4.2034E-02,4.7545E-02,5.2148E-02,
     &5.7163E-02,6.4833E-02,6.7480E-02/
      DATA ((KA(JS,JT, 7, 8),JS=1,9),JT=1,5) /
     &2.4762E-02,3.1775E-02,3.3749E-02,3.4176E-02,3.3323E-02,3.1060E-02,
     &2.9254E-02,2.6750E-02,2.6287E-02,2.4951E-02,3.3870E-02,3.6729E-02,
     &3.7700E-02,3.7125E-02,3.5645E-02,3.4725E-02,3.2382E-02,3.2363E-02,
     &2.5173E-02,3.5837E-02,3.9660E-02,4.1206E-02,4.1346E-02,4.1029E-02,
     &4.0471E-02,3.8518E-02,3.8913E-02,2.5363E-02,3.7886E-02,4.2599E-02,
     &4.5028E-02,4.5616E-02,4.6713E-02,4.6613E-02,4.5204E-02,4.5916E-02,
     &2.5554E-02,3.9913E-02,4.5725E-02,4.8757E-02,5.0398E-02,5.2532E-02,
     &5.3118E-02,5.2718E-02,5.3341E-02/
      DATA ((KA(JS,JT, 8, 8),JS=1,9),JT=1,5) /
     &5.1772E-02,5.6742E-02,5.6311E-02,5.3676E-02,4.9761E-02,4.4432E-02,
     &3.7642E-02,2.8159E-02,2.5366E-02,5.2310E-02,5.9935E-02,6.0103E-02,
     &5.8243E-02,5.4861E-02,4.9530E-02,4.2560E-02,3.2942E-02,3.0796E-02,
     &5.2803E-02,6.3037E-02,6.4134E-02,6.2766E-02,5.9645E-02,5.4655E-02,
     &4.7864E-02,3.8688E-02,3.7143E-02,5.3460E-02,6.5918E-02,6.8003E-02,
     &6.7271E-02,6.4711E-02,6.0132E-02,5.3215E-02,4.4724E-02,4.4005E-02,
     &5.3710E-02,6.8699E-02,7.1633E-02,7.2036E-02,6.9887E-02,6.5520E-02,
     &5.8694E-02,5.1143E-02,5.1305E-02/
      DATA ((KA(JS,JT, 9, 8),JS=1,9),JT=1,5) /
     &2.0198E-01,1.8901E-01,1.7403E-01,1.5566E-01,1.3460E-01,1.1050E-01,
     &8.4423E-02,5.5049E-02,2.7409E-02,2.0495E-01,1.9639E-01,1.8291E-01,
     &1.6519E-01,1.4305E-01,1.1881E-01,9.2245E-02,6.1787E-02,3.3663E-02,
     &2.0775E-01,2.0359E-01,1.9173E-01,1.7370E-01,1.5212E-01,1.2752E-01,
     &1.0028E-01,6.8520E-02,3.9556E-02,2.0971E-01,2.1033E-01,1.9959E-01,
     &1.8173E-01,1.6052E-01,1.3619E-01,1.0838E-01,7.5430E-02,4.6210E-02,
     &2.1122E-01,2.1661E-01,2.0701E-01,1.8977E-01,1.6868E-01,1.4451E-01,
     &1.1695E-01,8.2426E-02,5.2611E-02/
      DATA ((KA(JS,JT,10, 8),JS=1,9),JT=1,5) /
     &8.7179E-01,7.7305E-01,6.7676E-01,5.7800E-01,4.7858E-01,3.7509E-01,
     &2.6780E-01,1.5257E-01,3.4825E-02,8.8690E-01,7.9154E-01,6.9682E-01,
     &6.0089E-01,5.0085E-01,3.9677E-01,2.8510E-01,1.6381E-01,4.0840E-02,
     &8.9846E-01,8.0873E-01,7.1712E-01,6.2211E-01,5.2235E-01,4.1529E-01,
     &3.0033E-01,1.7576E-01,4.8253E-02,9.1202E-01,8.2713E-01,7.3854E-01,
     &6.4399E-01,5.4276E-01,4.3255E-01,3.1463E-01,1.8727E-01,5.7567E-02,
     &9.1292E-01,8.3520E-01,7.5311E-01,6.6058E-01,5.5851E-01,4.4868E-01,
     &3.2919E-01,1.9841E-01,6.5659E-02/
      DATA ((KA(JS,JT,11, 8),JS=1,9),JT=1,5) /
     &1.3103E+00,1.1565E+00,1.0072E+00,8.5492E-01,7.0080E-01,5.4405E-01,
     &3.8288E-01,2.1296E-01,3.6932E-02,1.3299E+00,1.1796E+00,1.0327E+00,
     &8.8125E-01,7.2693E-01,5.6857E-01,4.0335E-01,2.2633E-01,4.3190E-02,
     &1.3530E+00,1.2064E+00,1.0600E+00,9.1131E-01,7.5598E-01,5.9411E-01,
     &4.2265E-01,2.3978E-01,5.2762E-02,1.3587E+00,1.2195E+00,1.0781E+00,
     &9.3079E-01,7.7634E-01,6.1327E-01,4.3892E-01,2.5297E-01,6.4865E-02,
     &1.3600E+00,1.2284E+00,1.0908E+00,9.4457E-01,7.9211E-01,6.2699E-01,
     &4.5262E-01,2.6437E-01,7.6848E-02/
      DATA ((KA(JS,JT,12, 8),JS=1,9),JT=1,5) /
     &1.4407E+00,1.2713E+00,1.1065E+00,9.3835E-01,7.6825E-01,5.9432E-01,
     &4.1638E-01,2.2888E-01,3.4685E-02,1.4696E+00,1.3029E+00,1.1378E+00,
     &9.6981E-01,7.9767E-01,6.2103E-01,4.3779E-01,2.4254E-01,4.2654E-02,
     &1.4810E+00,1.3211E+00,1.1578E+00,9.9148E-01,8.2013E-01,6.4181E-01,
     &4.5466E-01,2.5578E-01,5.2496E-02,1.4858E+00,1.3306E+00,1.1727E+00,
     &1.0074E+00,8.3618E-01,6.5672E-01,4.6743E-01,2.6737E-01,6.3361E-02,
     &1.4815E+00,1.3335E+00,1.1804E+00,1.0190E+00,8.4985E-01,6.7121E-01,
     &4.8121E-01,2.7853E-01,7.5291E-02/
      DATA ((KA(JS,JT,13, 8),JS=1,9),JT=1,5) /
     &1.2616E+00,1.1163E+00,9.7204E-01,8.2547E-01,6.7669E-01,5.2391E-01,
     &3.6673E-01,2.0106E-01,2.9782E-02,1.2777E+00,1.1375E+00,9.9345E-01,
     &8.4804E-01,6.9806E-01,5.4388E-01,3.8298E-01,2.1265E-01,3.7539E-02,
     &1.2857E+00,1.1501E+00,1.0105E+00,8.6538E-01,7.1567E-01,5.5928E-01,
     &3.9596E-01,2.2292E-01,4.5370E-02,1.2877E+00,1.1566E+00,1.0204E+00,
     &8.7739E-01,7.2832E-01,5.7170E-01,4.0727E-01,2.3325E-01,5.5134E-02,
     &1.2810E+00,1.1580E+00,1.0267E+00,8.8778E-01,7.3941E-01,5.8252E-01,
     &4.1760E-01,2.4248E-01,6.6222E-02/
      DATA ((KA(JS,JT, 1, 9),JS=1,9),JT=1,5) /
     &1.6209E-03,5.7589E-02,1.1558E-01,1.7436E-01,2.3438E-01,2.9678E-01,
     &3.6435E-01,4.4557E-01,4.6867E-01,1.6160E-03,6.8254E-02,1.3700E-01,
     &2.0665E-01,2.7776E-01,3.5160E-01,4.3147E-01,5.2804E-01,5.5543E-01,
     &1.6156E-03,7.9739E-02,1.6004E-01,2.4140E-01,3.2446E-01,4.1061E-01,
     &5.0337E-01,6.1528E-01,6.4882E-01,1.6118E-03,9.1878E-02,1.8447E-01,
     &2.7828E-01,3.7409E-01,4.7339E-01,5.8011E-01,7.0748E-01,7.4809E-01,
     &1.6027E-03,1.0449E-01,2.0983E-01,3.1665E-01,4.2579E-01,5.3908E-01,
     &6.6087E-01,8.0485E-01,8.5148E-01/
      DATA ((KA(JS,JT, 2, 9),JS=1,9),JT=1,5) /
     &2.5385E-03,4.9947E-02,1.0010E-01,1.5075E-01,2.0224E-01,2.5529E-01,
     &3.1202E-01,3.8059E-01,4.0436E-01,2.5420E-03,5.9613E-02,1.1949E-01,
     &1.7998E-01,2.4152E-01,3.0496E-01,3.7260E-01,4.5413E-01,4.8291E-01,
     &2.5425E-03,6.9977E-02,1.4031E-01,2.1138E-01,2.8370E-01,3.5840E-01,
     &4.3825E-01,5.3358E-01,5.6726E-01,2.5349E-03,8.0938E-02,1.6229E-01,
     &2.4456E-01,3.2834E-01,4.1497E-01,5.0769E-01,6.1900E-01,6.5654E-01,
     &2.5236E-03,9.2377E-02,1.8522E-01,2.7915E-01,3.7480E-01,4.7381E-01,
     &5.8018E-01,7.0850E-01,7.4944E-01/
      DATA ((KA(JS,JT, 3, 9),JS=1,9),JT=1,5) /
     &5.2884E-03,4.1358E-02,8.2480E-02,1.2391E-01,1.6574E-01,2.0832E-01,
     &2.5278E-01,3.0394E-01,3.3126E-01,5.3098E-03,4.9746E-02,9.9365E-02,
     &1.4928E-01,1.9972E-01,2.5111E-01,3.0480E-01,3.6676E-01,3.9919E-01,
     &5.3133E-03,5.8864E-02,1.1765E-01,1.7679E-01,2.3653E-01,2.9742E-01,
     &3.6115E-01,4.3493E-01,4.7279E-01,5.3184E-03,6.8570E-02,1.3708E-01,
     &2.0601E-01,2.7562E-01,3.4665E-01,4.2100E-01,5.0744E-01,5.5094E-01,
     &5.2937E-03,7.8913E-02,1.5776E-01,2.3709E-01,3.1721E-01,3.9889E-01,
     &4.8431E-01,5.8366E-01,6.3409E-01/
      DATA ((KA(JS,JT, 4, 9),JS=1,9),JT=1,5) /
     &1.1189E-02,3.7631E-02,6.6855E-02,9.9420E-02,1.3264E-01,1.6622E-01,
     &2.0064E-01,2.3828E-01,2.6479E-01,1.1235E-02,4.3836E-02,8.1298E-02,
     &1.2151E-01,1.6212E-01,2.0319E-01,2.4526E-01,2.9131E-01,3.2370E-01,
     &1.1256E-02,5.0846E-02,9.7157E-02,1.4551E-01,1.9420E-01,2.4340E-01,
     &2.9384E-01,3.4897E-01,3.8783E-01,1.1233E-02,5.8695E-02,1.1439E-01,
     &1.7147E-01,2.2883E-01,2.8678E-01,3.4608E-01,4.1077E-01,4.5705E-01,
     &1.1193E-02,6.7408E-02,1.3290E-01,1.9926E-01,2.6591E-01,3.3325E-01,
     &4.0214E-01,4.7714E-01,5.3115E-01/
      DATA ((KA(JS,JT, 5, 9),JS=1,9),JT=1,5) /
     &2.1456E-02,4.5196E-02,6.1958E-02,8.2153E-02,1.0545E-01,1.3112E-01,
     &1.5772E-01,1.8584E-01,2.0874E-01,2.1627E-02,4.9543E-02,7.2420E-02,
     &9.9628E-02,1.3042E-01,1.6274E-01,1.9580E-01,2.3075E-01,2.5926E-01,
     &2.1648E-02,5.4430E-02,8.4381E-02,1.1963E-01,1.5816E-01,1.9769E-01,
     &2.3786E-01,2.8024E-01,3.1505E-01,2.1655E-02,5.9909E-02,9.8020E-02,
     &1.4216E-01,1.8871E-01,2.3596E-01,2.8391E-01,3.3439E-01,3.7619E-01,
     &2.1575E-02,6.6071E-02,1.1341E-01,1.6675E-01,2.2186E-01,2.7746E-01,
     &3.3388E-01,3.9317E-01,4.4246E-01/
      DATA ((KA(JS,JT, 6, 9),JS=1,9),JT=1,5) /
     &3.8314E-02,5.9481E-02,7.1457E-02,8.1684E-02,9.1784E-02,1.0487E-01,
     &1.2171E-01,1.4213E-01,1.5860E-01,3.8611E-02,6.4337E-02,7.9461E-02,
     &9.3850E-02,1.0993E-01,1.2967E-01,1.5327E-01,1.7946E-01,2.0255E-01,
     &3.8670E-02,6.9241E-02,8.8613E-02,1.0808E-01,1.3134E-01,1.5836E-01,
     &1.8890E-01,2.2142E-01,2.5002E-01,3.8675E-02,7.4319E-02,9.8760E-02,
     &1.2484E-01,1.5591E-01,1.9105E-01,2.2866E-01,2.6805E-01,3.0304E-01,
     &3.8508E-02,7.9526E-02,1.0987E-01,1.4404E-01,1.8357E-01,2.2696E-01,
     &2.7218E-01,3.1912E-01,3.6102E-01/
      DATA ((KA(JS,JT, 7, 9),JS=1,9),JT=1,5) /
     &7.2084E-02,8.8512E-02,9.7172E-02,1.0090E-01,1.0168E-01,1.0216E-01,
     &1.0271E-01,1.0842E-01,1.0501E-01,7.2564E-02,9.4711E-02,1.0583E-01,
     &1.1196E-01,1.1550E-01,1.2008E-01,1.2583E-01,1.3849E-01,1.4021E-01,
     &7.2730E-02,1.0095E-01,1.1490E-01,1.2380E-01,1.3141E-01,1.4065E-01,
     &1.5344E-01,1.7335E-01,1.8125E-01,7.2941E-02,1.0706E-01,1.2422E-01,
     &1.3654E-01,1.5005E-01,1.6497E-01,1.8541E-01,2.1284E-01,2.2809E-01,
     &7.3026E-02,1.1297E-01,1.3379E-01,1.5116E-01,1.7068E-01,1.9286E-01,
     &2.2139E-01,2.5637E-01,2.7993E-01/
      DATA ((KA(JS,JT, 8, 9),JS=1,9),JT=1,5) /
     &1.6179E-01,1.6443E-01,1.6310E-01,1.5765E-01,1.4868E-01,1.3533E-01,
     &1.1770E-01,9.8380E-02,8.1836E-02,1.6423E-01,1.7218E-01,1.7516E-01,
     &1.7171E-01,1.6374E-01,1.5153E-01,1.3534E-01,1.1999E-01,1.0061E-01,
     &1.6654E-01,1.7965E-01,1.8707E-01,1.8587E-01,1.7956E-01,1.6926E-01,
     &1.5537E-01,1.4544E-01,1.2284E-01,1.6762E-01,1.8741E-01,1.9894E-01,
     &2.0043E-01,1.9638E-01,1.8821E-01,1.7907E-01,1.7570E-01,1.5659E-01,
     &1.6808E-01,1.9570E-01,2.1084E-01,2.1493E-01,2.1406E-01,2.0908E-01,
     &2.0616E-01,2.1009E-01,1.9730E-01/
      DATA ((KA(JS,JT, 9, 9),JS=1,9),JT=1,5) /
     &7.0428E-01,6.3434E-01,5.6644E-01,4.9559E-01,4.2070E-01,3.4143E-01,
     &2.6063E-01,1.7246E-01,1.1446E-01,7.1533E-01,6.5148E-01,5.8487E-01,
     &5.1694E-01,4.4379E-01,3.6693E-01,2.8562E-01,1.9355E-01,1.3717E-01,
     &7.2105E-01,6.6501E-01,6.0595E-01,5.4025E-01,4.6705E-01,3.9267E-01,
     &3.1101E-01,2.1648E-01,1.6351E-01,7.2262E-01,6.7430E-01,6.2376E-01,
     &5.6249E-01,4.9295E-01,4.1839E-01,3.3764E-01,2.4119E-01,1.9114E-01,
     &7.2252E-01,6.8406E-01,6.4078E-01,5.8400E-01,5.1738E-01,4.4614E-01,
     &3.6505E-01,2.6763E-01,2.2362E-01/
      DATA ((KA(JS,JT,10, 9),JS=1,9),JT=1,5) /
     &3.3754E+00,2.9579E+00,2.5567E+00,2.1598E+00,1.7623E+00,1.3527E+00,
     &9.4464E-01,5.2414E-01,1.6022E-01,3.4121E+00,2.9947E+00,2.5993E+00,
     &2.2033E+00,1.8038E+00,1.3952E+00,9.8851E-01,5.5797E-01,1.9922E-01,
     &3.4354E+00,3.0219E+00,2.6345E+00,2.2476E+00,1.8449E+00,1.4451E+00,
     &1.0317E+00,5.9234E-01,2.4180E-01,3.4369E+00,3.0367E+00,2.6577E+00,
     &2.2740E+00,1.8821E+00,1.4871E+00,1.0728E+00,6.2615E-01,2.8291E-01,
     &3.4461E+00,3.0546E+00,2.6839E+00,2.3057E+00,1.9262E+00,1.5287E+00,
     &1.1134E+00,6.5955E-01,3.3010E-01/
      DATA ((KA(JS,JT,11, 9),JS=1,9),JT=1,5) /
     &5.5731E+00,4.8785E+00,4.1979E+00,3.5322E+00,2.8619E+00,2.1883E+00,
     &1.5051E+00,8.1479E-01,1.7197E-01,5.6124E+00,4.9158E+00,4.2449E+00,
     &3.5793E+00,2.9170E+00,2.2388E+00,1.5568E+00,8.5687E-01,2.2531E-01,
     &5.6253E+00,4.9334E+00,4.2755E+00,3.6196E+00,2.9577E+00,2.2787E+00,
     &1.6022E+00,8.9680E-01,2.6360E-01,5.6351E+00,4.9513E+00,4.3021E+00,
     &3.6565E+00,2.9923E+00,2.3311E+00,1.6513E+00,9.3728E-01,3.0681E-01,
     &5.6511E+00,4.9808E+00,4.3475E+00,3.7008E+00,3.0483E+00,2.3866E+00,
     &1.7012E+00,9.7887E-01,3.4951E-01/
      DATA ((KA(JS,JT,12, 9),JS=1,9),JT=1,5) /
     &6.6833E+00,5.8503E+00,5.0320E+00,4.2291E+00,3.4220E+00,2.6133E+00,
     &1.7900E+00,9.6260E-01,1.7445E-01,6.6977E+00,5.8665E+00,5.0629E+00,
     &4.2649E+00,3.4722E+00,2.6560E+00,1.8378E+00,1.0034E+00,2.1910E-01,
     &6.7112E+00,5.8830E+00,5.0943E+00,4.3071E+00,3.5122E+00,2.7000E+00,
     &1.8863E+00,1.0455E+00,2.5420E-01,6.7306E+00,5.9135E+00,5.1333E+00,
     &4.3624E+00,3.5635E+00,2.7641E+00,1.9469E+00,1.0906E+00,2.9618E-01,
     &6.7198E+00,5.9182E+00,5.1572E+00,4.3874E+00,3.6068E+00,2.8158E+00,
     &1.9979E+00,1.1364E+00,3.4172E-01/
      DATA ((KA(JS,JT,13, 9),JS=1,9),JT=1,5) /
     &6.2228E+00,5.4483E+00,4.6948E+00,3.9489E+00,3.2053E+00,2.4477E+00,
     &1.6826E+00,9.0899E-01,1.6340E-01,6.2479E+00,5.4750E+00,4.7365E+00,
     &3.9942E+00,3.2532E+00,2.4916E+00,1.7319E+00,9.4656E-01,1.9164E-01,
     &6.2720E+00,5.5063E+00,4.7748E+00,4.0523E+00,3.3026E+00,2.5508E+00,
     &1.7859E+00,9.9108E-01,2.3050E-01,6.2663E+00,5.5165E+00,4.8016E+00,
     &4.0858E+00,3.3448E+00,2.6010E+00,1.8364E+00,1.0337E+00,2.6420E-01,
     &6.2869E+00,5.5494E+00,4.8492E+00,4.1318E+00,3.4036E+00,2.6598E+00,
     &1.8865E+00,1.0759E+00,2.9687E-01/
      DATA ((KA(JS,JT, 1,10),JS=1,9),JT=1,5) /
     &2.7731E-03,1.5625E-01,3.1254E-01,4.6910E-01,6.2583E-01,7.8249E-01,
     &9.3706E-01,1.0845E+00,1.2516E+00,2.6994E-03,1.8576E-01,3.7148E-01,
     &5.5698E-01,7.4226E-01,9.2683E-01,1.1083E+00,1.2874E+00,1.4844E+00,
     &2.5977E-03,2.1688E-01,4.3344E-01,6.4957E-01,8.6528E-01,1.0791E+00,
     &1.2881E+00,1.4959E+00,1.7305E+00,2.4994E-03,2.5005E-01,4.9954E-01,
     &7.4789E-01,9.9444E-01,1.2373E+00,1.4746E+00,1.7076E+00,1.9888E+00,
     &2.4443E-03,2.8623E-01,5.7132E-01,8.5454E-01,1.1344E+00,1.4080E+00,
     &1.6698E+00,1.9238E+00,2.2687E+00/
      DATA ((KA(JS,JT, 2,10),JS=1,9),JT=1,5) /
     &4.6033E-03,1.4235E-01,2.8494E-01,4.2818E-01,5.7234E-01,7.1833E-01,
     &8.6574E-01,1.0139E+00,1.1445E+00,4.4279E-03,1.7116E-01,3.4236E-01,
     &5.1392E-01,6.8612E-01,8.5990E-01,1.0377E+00,1.2137E+00,1.3721E+00,
     &4.2606E-03,2.0315E-01,4.0616E-01,6.0913E-01,8.1201E-01,1.0152E+00,
     &1.2192E+00,1.4256E+00,1.6238E+00,4.1205E-03,2.3773E-01,4.7526E-01,
     &7.1252E-01,9.4929E-01,1.1850E+00,1.4175E+00,1.6433E+00,1.8984E+00,
     &4.0494E-03,2.7547E-01,5.5055E-01,8.2539E-01,1.0993E+00,1.3710E+00,
     &1.6368E+00,1.8772E+00,2.1984E+00/
      DATA ((KA(JS,JT, 3,10),JS=1,9),JT=1,5) /
     &1.0161E-02,1.2214E-01,2.4424E-01,3.6667E-01,4.8955E-01,6.1355E-01,
     &7.4009E-01,8.7555E-01,9.7887E-01,9.8188E-03,1.5023E-01,3.0029E-01,
     &4.5055E-01,6.0115E-01,7.5236E-01,9.0544E-01,1.0662E+00,1.2020E+00,
     &9.4977E-03,1.8146E-01,3.6272E-01,5.4423E-01,7.2598E-01,9.0829E-01,
     &1.0912E+00,1.2774E+00,1.4517E+00,9.2658E-03,2.1540E-01,4.3072E-01,
     &6.4627E-01,8.6225E-01,1.0787E+00,1.2961E+00,1.5118E+00,1.7242E+00,
     &9.2390E-03,2.5102E-01,5.0193E-01,7.5312E-01,1.0052E+00,1.2582E+00,
     &1.5132E+00,1.7682E+00,2.0100E+00/
      DATA ((KA(JS,JT, 4,10),JS=1,9),JT=1,5) /
     &2.2805E-02,1.0395E-01,2.0752E-01,3.1119E-01,4.1502E-01,5.1909E-01,
     &6.2381E-01,7.3100E-01,8.2961E-01,2.2222E-02,1.2866E-01,2.5687E-01,
     &3.8520E-01,5.1380E-01,6.4273E-01,7.7289E-01,9.0648E-01,1.0271E+00,
     &2.1664E-02,1.5642E-01,3.1238E-01,4.6876E-01,6.2523E-01,7.8254E-01,
     &9.4140E-01,1.1052E+00,1.2499E+00,2.1586E-02,1.8661E-01,3.7283E-01,
     &5.5940E-01,7.4664E-01,9.3462E-01,1.1258E+00,1.3254E+00,1.4927E+00,
     &2.1462E-02,2.1863E-01,4.3680E-01,6.5519E-01,8.7456E-01,1.0957E+00,
     &1.3203E+00,1.5569E+00,1.7484E+00/
      DATA ((KA(JS,JT, 5,10),JS=1,9),JT=1,5) /
     &4.7130E-02,9.3953E-02,1.7393E-01,2.6053E-01,3.4731E-01,4.3431E-01,
     &5.2182E-01,6.1134E-01,6.9380E-01,4.5557E-02,1.1245E-01,2.1773E-01,
     &3.2619E-01,4.3487E-01,5.4373E-01,6.5319E-01,7.6497E-01,8.6883E-01,
     &4.5179E-02,1.3419E-01,2.6606E-01,3.9876E-01,5.3167E-01,6.6490E-01,
     &7.9898E-01,9.3637E-01,1.0624E+00,4.5058E-02,1.5943E-01,3.1786E-01,
     &4.7639E-01,6.3534E-01,7.9462E-01,9.5569E-01,1.1218E+00,1.2696E+00,
     &4.5124E-02,1.8659E-01,3.7199E-01,5.5748E-01,7.4317E-01,9.2965E-01,
     &1.1179E+00,1.3144E+00,1.4843E+00/
      DATA ((KA(JS,JT, 6,10),JS=1,9),JT=1,5) /
     &9.1822E-02,1.2595E-01,1.5650E-01,2.1453E-01,2.8383E-01,3.5468E-01,
     &4.2569E-01,4.9790E-01,5.6600E-01,9.0834E-02,1.3514E-01,1.8905E-01,
     &2.7114E-01,3.6116E-01,4.5123E-01,5.4153E-01,6.3330E-01,7.2013E-01,
     &9.0336E-02,1.4401E-01,2.2730E-01,3.3603E-01,4.4738E-01,5.5884E-01,
     &6.7092E-01,7.8481E-01,8.9194E-01,9.0439E-02,1.5770E-01,2.7084E-01,
     &4.0445E-01,5.3847E-01,6.7263E-01,8.0760E-01,9.4541E-01,1.0734E+00,
     &8.9534E-02,1.7535E-01,3.1878E-01,4.7665E-01,6.3445E-01,7.9249E-01,
     &9.5149E-01,1.1135E+00,1.2646E+00/
      DATA ((KA(JS,JT, 7,10),JS=1,9),JT=1,5) /
     &1.8704E-01,2.0782E-01,2.1870E-01,2.2895E-01,2.4473E-01,2.8566E-01,
     &3.3903E-01,3.9559E-01,4.4999E-01,1.8532E-01,2.1563E-01,2.3939E-01,
     &2.5636E-01,3.0272E-01,3.6581E-01,4.3811E-01,5.1140E-01,5.8167E-01,
     &1.8680E-01,2.2377E-01,2.5927E-01,2.9855E-01,3.7097E-01,4.5865E-01,
     &5.4953E-01,6.4162E-01,7.2947E-01,1.8310E-01,2.3512E-01,2.8042E-01,
     &3.5020E-01,4.4840E-01,5.5852E-01,6.6925E-01,7.8169E-01,8.8834E-01,
     &1.7882E-01,2.4826E-01,3.0849E-01,4.0772E-01,5.3530E-01,6.6727E-01,
     &7.9969E-01,9.3357E-01,1.0615E+00/
      DATA ((KA(JS,JT, 8,10),JS=1,9),JT=1,5) /
     &4.1112E-01,4.0974E-01,4.1065E-01,3.9316E-01,3.5874E-01,3.2789E-01,
     &2.9581E-01,3.0764E-01,1.9137E-01,4.0366E-01,4.2457E-01,4.2635E-01,
     &4.1703E-01,3.9720E-01,3.6880E-01,3.6253E-01,4.0327E-01,3.4592E-01,
     &3.8607E-01,4.4207E-01,4.4571E-01,4.4555E-01,4.3797E-01,4.1894E-01,
     &4.4727E-01,5.1245E-01,5.5117E-01,3.7227E-01,4.5775E-01,4.6855E-01,
     &4.7950E-01,4.7625E-01,4.8559E-01,5.4513E-01,6.3288E-01,7.1148E-01,
     &3.6637E-01,4.6773E-01,4.9188E-01,5.1329E-01,5.2260E-01,5.7072E-01,
     &6.6113E-01,7.6991E-01,8.6824E-01/
      DATA ((KA(JS,JT, 9,10),JS=1,9),JT=1,5) /
     &1.5096E+00,1.3467E+00,1.2191E+00,1.0959E+00,9.8221E-01,8.6433E-01,
     &6.8915E-01,4.5155E-01,2.5455E-01,1.4729E+00,1.3283E+00,1.2484E+00,
     &1.1515E+00,1.0570E+00,9.2603E-01,7.4690E-01,5.0470E-01,3.4249E-01,
     &1.4533E+00,1.3348E+00,1.2453E+00,1.1987E+00,1.1351E+00,9.9543E-01,
     &8.1023E-01,5.6196E-01,4.0591E-01,1.4744E+00,1.3676E+00,1.2850E+00,
     &1.2602E+00,1.1957E+00,1.0697E+00,8.6704E-01,6.2711E-01,4.8211E-01,
     &1.4999E+00,1.4091E+00,1.3355E+00,1.3264E+00,1.2721E+00,1.1339E+00,
     &9.2252E-01,7.1025E-01,5.3091E-01/
      DATA ((KA(JS,JT,10,10),JS=1,9),JT=1,5) /
     &7.2829E+00,6.3687E+00,5.4628E+00,4.5827E+00,3.6816E+00,2.8784E+00,
     &1.9461E+00,1.1228E+00,2.9615E-01,7.2567E+00,6.3523E+00,5.5013E+00,
     &4.6178E+00,3.8060E+00,2.8925E+00,1.9877E+00,1.2045E+00,5.0840E-01,
     &7.3526E+00,6.4384E+00,5.5471E+00,4.6686E+00,3.8188E+00,2.9106E+00,
     &2.0584E+00,1.3182E+00,5.8969E-01,7.6517E+00,6.6965E+00,5.8098E+00,
     &4.9129E+00,3.9609E+00,3.0608E+00,2.1952E+00,1.4642E+00,7.2061E-01,
     &7.6682E+00,6.7495E+00,5.8665E+00,4.9992E+00,4.0971E+00,3.1895E+00,
     &2.3244E+00,1.6171E+00,8.0277E-01/
      DATA ((KA(JS,JT,11,10),JS=1,9),JT=1,5) /
     &1.2863E+01,1.1253E+01,9.6455E+00,8.0559E+00,6.4984E+00,4.9709E+00,
     &3.3831E+00,1.7991E+00,3.6644E-01,1.3151E+01,1.1511E+01,9.8627E+00,
     &8.2765E+00,6.6703E+00,5.1195E+00,3.4235E+00,1.8440E+00,4.6729E-01,
     &1.3385E+01,1.1711E+01,1.0081E+01,8.4279E+00,6.8536E+00,5.2620E+00,
     &3.6394E+00,1.9452E+00,7.7574E-01,1.3506E+01,1.1818E+01,1.0183E+01,
     &8.6029E+00,7.0409E+00,5.3665E+00,3.7651E+00,2.0591E+00,8.8231E-01,
     &1.3392E+01,1.1719E+01,1.0115E+01,8.6680E+00,7.0525E+00,5.5043E+00,
     &3.9029E+00,2.2010E+00,9.9688E-01/
      DATA ((KA(JS,JT,12,10),JS=1,9),JT=1,5) /
     &1.6670E+01,1.4588E+01,1.2501E+01,1.0421E+01,8.3941E+00,6.4270E+00,
     &4.3660E+00,2.2934E+00,3.9405E-01,1.7105E+01,1.4960E+01,1.2826E+01,
     &1.0751E+01,8.6199E+00,6.6739E+00,4.5154E+00,2.4126E+00,5.4759E-01,
     &1.7307E+01,1.5147E+01,1.3016E+01,1.0902E+01,8.9354E+00,6.8220E+00,
     &4.7181E+00,2.5631E+00,8.3787E-01,1.7279E+01,1.5121E+01,1.3042E+01,
     &1.0948E+01,8.9655E+00,6.8546E+00,4.7965E+00,2.6658E+00,9.5310E-01,
     &1.7622E+01,1.5423E+01,1.3295E+01,1.1391E+01,9.1951E+00,7.1021E+00,
     &4.9630E+00,2.7853E+00,1.0381E+00/
      DATA ((KA(JS,JT,13,10),JS=1,9),JT=1,5) /
     &1.7285E+01,1.5124E+01,1.2963E+01,1.0843E+01,8.6958E+00,6.7399E+00,
     &4.5324E+00,2.3893E+00,3.8223E-01,1.7394E+01,1.5220E+01,1.3045E+01,
     &1.0933E+01,8.8783E+00,6.8319E+00,4.6535E+00,2.5278E+00,6.6322E-01,
     &1.7534E+01,1.5350E+01,1.3222E+01,1.1038E+01,9.1270E+00,6.8978E+00,
     &4.7818E+00,2.6214E+00,7.3123E-01,1.7891E+01,1.5660E+01,1.3479E+01,
     &1.1400E+01,9.3159E+00,7.0998E+00,4.9577E+00,2.7354E+00,8.9654E-01,
     &1.8019E+01,1.5767E+01,1.3610E+01,1.1614E+01,9.4166E+00,7.3122E+00,
     &5.1530E+00,2.8785E+00,1.0692E+00/
      DATA ((KA(JS,JT, 1,11),JS=1,9),JT=1,5) /
     &3.1711E-03,2.2841E-01,4.5620E-01,6.8299E-01,9.0802E-01,1.1291E+00,
     &1.3398E+00,1.4993E+00,1.8159E+00,3.0704E-03,2.7128E-01,5.4234E-01,
     &8.1284E-01,1.0822E+00,1.3468E+00,1.5998E+00,1.7945E+00,2.1643E+00,
     &2.9866E-03,3.1478E-01,6.2947E-01,9.4408E-01,1.2581E+00,1.5709E+00,
     &1.8741E+00,2.1028E+00,2.5161E+00,2.9163E-03,3.5938E-01,7.1835E-01,
     &1.0774E+00,1.4362E+00,1.7946E+00,2.1451E+00,2.4217E+00,2.8722E+00,
     &2.8034E-03,4.0521E-01,8.0970E-01,1.2136E+00,1.6171E+00,2.0187E+00,
     &2.4125E+00,2.7343E+00,3.2340E+00/
      DATA ((KA(JS,JT, 2,11),JS=1,9),JT=1,5) /
     &5.2383E-03,2.1282E-01,4.2542E-01,6.3727E-01,8.4863E-01,1.0581E+00,
     &1.2660E+00,1.4631E+00,1.6971E+00,5.1027E-03,2.5414E-01,5.0811E-01,
     &7.6215E-01,1.0157E+00,1.2690E+00,1.5182E+00,1.7540E+00,2.0313E+00,
     &4.9821E-03,2.9639E-01,5.9276E-01,8.8910E-01,1.1857E+00,1.4825E+00,
     &1.7783E+00,2.0622E+00,2.3711E+00,4.8330E-03,3.4110E-01,6.8181E-01,
     &1.0221E+00,1.3622E+00,1.7021E+00,2.0428E+00,2.3773E+00,2.7241E+00,
     &4.6466E-03,3.8845E-01,7.7604E-01,1.1627E+00,1.5479E+00,1.9317E+00,
     &2.3125E+00,2.6917E+00,3.0955E+00/
      DATA ((KA(JS,JT, 3,11),JS=1,9),JT=1,5) /
     &1.1968E-02,1.8925E-01,3.7814E-01,5.6720E-01,7.5640E-01,9.4598E-01,
     &1.1354E+00,1.3192E+00,1.5123E+00,1.1738E-02,2.2858E-01,4.5676E-01,
     &6.8520E-01,9.1426E-01,1.1439E+00,1.3747E+00,1.6035E+00,1.8280E+00,
     &1.1441E-02,2.7028E-01,5.3999E-01,8.0979E-01,1.0799E+00,1.3506E+00,
     &1.6224E+00,1.8949E+00,2.1592E+00,1.1066E-02,3.1556E-01,6.3024E-01,
     &9.4495E-01,1.2595E+00,1.5736E+00,1.8868E+00,2.1970E+00,2.5183E+00,
     &1.0627E-02,3.6442E-01,7.2807E-01,1.0914E+00,1.4538E+00,1.8154E+00,
     &2.1726E+00,2.5191E+00,2.9067E+00/
      DATA ((KA(JS,JT, 4,11),JS=1,9),JT=1,5) /
     &2.8048E-02,1.6151E-01,3.2202E-01,4.8262E-01,6.4375E-01,8.0530E-01,
     &9.6854E-01,1.1364E+00,1.2863E+00,2.7460E-02,1.9867E-01,3.9620E-01,
     &5.9396E-01,7.9208E-01,9.9102E-01,1.1917E+00,1.3983E+00,1.5828E+00,
     &2.6672E-02,2.3899E-01,4.7658E-01,7.1429E-01,9.5231E-01,1.1913E+00,
     &1.4318E+00,1.6791E+00,1.9031E+00,2.5665E-02,2.8345E-01,5.6525E-01,
     &8.4715E-01,1.1294E+00,1.4117E+00,1.6956E+00,1.9833E+00,2.2571E+00,
     &2.4958E-02,3.3271E-01,6.6383E-01,9.9466E-01,1.3259E+00,1.6572E+00,
     &1.9874E+00,2.3183E+00,2.6500E+00/
      DATA ((KA(JS,JT, 5,11),JS=1,9),JT=1,5) /
     &5.9740E-02,1.3717E-01,2.6992E-01,4.0387E-01,5.3789E-01,6.7238E-01,
     &8.0752E-01,9.4549E-01,1.0734E+00,5.8323E-02,1.6942E-01,3.3625E-01,
     &5.0313E-01,6.7036E-01,8.3790E-01,1.0063E+00,1.1790E+00,1.3380E+00,
     &5.6700E-02,2.0744E-01,4.1183E-01,6.1629E-01,8.2117E-01,1.0263E+00,
     &1.2326E+00,1.4427E+00,1.6392E+00,5.4845E-02,2.5070E-01,4.9802E-01,
     &7.4525E-01,9.9296E-01,1.2407E+00,1.4895E+00,1.7409E+00,1.9825E+00,
     &5.3384E-02,2.9836E-01,5.9305E-01,8.8824E-01,1.1834E+00,1.4792E+00,
     &1.7758E+00,2.0754E+00,2.3639E+00/
      DATA ((KA(JS,JT, 6,11),JS=1,9),JT=1,5) /
     &1.1443E-01,1.5330E-01,2.2814E-01,3.3358E-01,4.4343E-01,5.5347E-01,
     &6.6399E-01,7.7608E-01,8.8294E-01,1.1139E-01,1.6753E-01,2.8410E-01,
     &4.2322E-01,5.6271E-01,7.0257E-01,8.4275E-01,9.8447E-01,1.1213E+00,
     &1.0816E-01,1.9391E-01,3.5154E-01,5.2463E-01,6.9799E-01,8.7181E-01,
     &1.0460E+00,1.2220E+00,1.3917E+00,1.0514E-01,2.2522E-01,4.2775E-01,
     &6.3893E-01,8.5037E-01,1.0626E+00,1.2753E+00,1.4901E+00,1.6964E+00,
     &1.0414E-01,2.6189E-01,5.1110E-01,7.6424E-01,1.0178E+00,1.2716E+00,
     &1.5264E+00,1.7854E+00,2.0311E+00/
      DATA ((KA(JS,JT, 7,11),JS=1,9),JT=1,5) /
     &2.3680E-01,2.5474E-01,2.7467E-01,2.9968E-01,3.6549E-01,4.4931E-01,
     &5.3835E-01,6.2811E-01,7.1559E-01,2.3126E-01,2.6667E-01,2.9742E-01,
     &3.6770E-01,4.6828E-01,5.8355E-01,6.9932E-01,8.1593E-01,9.2966E-01,
     &2.2333E-01,2.8145E-01,3.3561E-01,4.4803E-01,5.8828E-01,7.3378E-01,
     &8.7969E-01,1.0266E+00,1.1700E+00,2.2006E-01,2.9370E-01,3.8943E-01,
     &5.4388E-01,7.2193E-01,9.0087E-01,1.0804E+00,1.2609E+00,1.4372E+00,
     &2.1836E-01,3.0927E-01,4.5013E-01,6.5145E-01,8.6638E-01,1.0814E+00,
     &1.2967E+00,1.5147E+00,1.7257E+00/
      DATA ((KA(JS,JT, 8,11),JS=1,9),JT=1,5) /
     &5.7508E-01,5.5228E-01,5.1832E-01,4.8920E-01,4.5962E-01,4.2790E-01,
     &4.4544E-01,5.0496E-01,5.4406E-01,5.5570E-01,5.5086E-01,5.3954E-01,
     &5.2836E-01,5.0571E-01,5.1612E-01,5.7597E-01,6.6763E-01,7.6063E-01,
     &5.4644E-01,5.5917E-01,5.6849E-01,5.6772E-01,5.6845E-01,6.3045E-01,
     &7.3261E-01,8.5320E-01,9.7237E-01,5.4298E-01,5.6882E-01,5.9693E-01,
     &6.1038E-01,6.5823E-01,7.6720E-01,9.1091E-01,1.0615E+00,1.2099E+00,
     &5.3663E-01,5.8485E-01,6.2913E-01,6.6732E-01,7.6736E-01,9.2195E-01,
     &1.1025E+00,1.2850E+00,1.4649E+00/
      DATA ((KA(JS,JT, 9,11),JS=1,9),JT=1,5) /
     &2.5279E+00,2.2431E+00,2.0106E+00,1.7600E+00,1.4790E+00,1.2051E+00,
     &8.9590E-01,5.8517E-01,3.0795E-01,2.4601E+00,2.1917E+00,2.0103E+00,
     &1.7592E+00,1.5280E+00,1.2575E+00,9.5967E-01,6.7082E-01,3.9930E-01,
     &2.4168E+00,2.1757E+00,2.0177E+00,1.7994E+00,1.5699E+00,1.3186E+00,
     &1.0425E+00,7.7727E-01,5.2484E-01,2.3770E+00,2.1985E+00,2.0410E+00,
     &1.8443E+00,1.6274E+00,1.3869E+00,1.1288E+00,9.2337E-01,5.9212E-01,
     &2.3400E+00,2.1850E+00,2.0960E+00,1.9025E+00,1.6878E+00,1.4602E+00,
     &1.2280E+00,1.0954E+00,7.2073E-01/
      DATA ((KA(JS,JT,10,11),JS=1,9),JT=1,5) /
     &1.1112E+01,9.7248E+00,8.3361E+00,7.0270E+00,5.7440E+00,4.5096E+00,
     &3.2779E+00,1.8950E+00,4.0940E-01,1.0924E+01,9.5564E+00,8.1917E+00,
     &6.9650E+00,5.7085E+00,4.6298E+00,3.3486E+00,2.0156E+00,4.6752E-01,
     &1.0832E+01,9.4781E+00,8.2229E+00,6.9872E+00,5.8796E+00,4.6954E+00,
     &3.5108E+00,2.1192E+00,8.0168E-01,1.0490E+01,9.1768E+00,8.0065E+00,
     &6.9497E+00,5.9506E+00,4.7816E+00,3.6391E+00,2.2227E+00,9.3825E-01,
     &1.0399E+01,9.1010E+00,8.0219E+00,7.0325E+00,5.9506E+00,4.9243E+00,
     &3.8048E+00,2.3499E+00,1.1716E+00/
      DATA ((KA(JS,JT,11,11),JS=1,9),JT=1,5) /
     &1.6964E+01,1.4849E+01,1.2726E+01,1.0607E+01,8.5722E+00,6.5304E+00,
     &4.5723E+00,2.5353E+00,5.7715E-01,1.6824E+01,1.4725E+01,1.2623E+01,
     &1.0586E+01,8.5709E+00,6.6756E+00,4.7183E+00,2.7595E+00,6.2192E-01,
     &1.6755E+01,1.4665E+01,1.2572E+01,1.0610E+01,8.6759E+00,6.8661E+00,
     &4.7973E+00,2.9494E+00,7.1889E-01,1.6922E+01,1.4802E+01,1.2769E+01,
     &1.0738E+01,8.9005E+00,6.9130E+00,5.0022E+00,3.1663E+00,1.1906E+00,
     &1.7198E+01,1.5045E+01,1.3001E+01,1.1038E+01,9.0834E+00,7.0679E+00,
     &5.2222E+00,3.3529E+00,1.3885E+00/
      DATA ((KA(JS,JT,12,11),JS=1,9),JT=1,5) /
     &2.1802E+01,1.9077E+01,1.6353E+01,1.3626E+01,1.0986E+01,8.2719E+00,
     &5.7215E+00,2.9889E+00,6.5084E-01,2.2052E+01,1.9310E+01,1.6546E+01,
     &1.3830E+01,1.1139E+01,8.5492E+00,5.8655E+00,3.1860E+00,7.2046E-01,
     &2.2451E+01,1.9654E+01,1.6841E+01,1.4123E+01,1.1335E+01,8.7814E+00,
     &5.9237E+00,3.3098E+00,8.3218E-01,2.3090E+01,2.0216E+01,1.7353E+01,
     &1.4511E+01,1.1935E+01,9.0228E+00,6.2499E+00,3.5354E+00,1.3462E+00,
     &2.3297E+01,2.0383E+01,1.7601E+01,1.4664E+01,1.2080E+01,9.1910E+00,
     &6.4263E+00,3.7093E+00,1.5753E+00/
      DATA ((KA(JS,JT,13,11),JS=1,9),JT=1,5) /
     &2.3137E+01,2.0253E+01,1.7360E+01,1.4461E+01,1.1660E+01,8.7711E+00,
     &6.0766E+00,3.2004E+00,6.2333E-01,2.3705E+01,2.0739E+01,1.7789E+01,
     &1.4919E+01,1.1958E+01,9.2720E+00,6.2579E+00,3.3419E+00,6.6494E-01,
     &2.4274E+01,2.1226E+01,1.8190E+01,1.5260E+01,1.2326E+01,9.5663E+00,
     &6.4788E+00,3.4909E+00,1.1201E+00,2.4386E+01,2.1333E+01,1.8377E+01,
     &1.5357E+01,1.2667E+01,9.6781E+00,6.7508E+00,3.6779E+00,1.3420E+00,
     &2.4394E+01,2.1348E+01,1.8396E+01,1.5507E+01,1.2756E+01,9.7415E+00,
     &6.8863E+00,3.8176E+00,1.6819E+00/
      DATA ((KA(JS,JT, 1,12),JS=1,9),JT=1,5) /
     &3.7292E-03,3.2906E-01,6.5580E-01,9.7933E-01,1.2975E+00,1.6059E+00,
     &1.8953E+00,2.1342E+00,2.5948E+00,3.6338E-03,3.9331E-01,7.8289E-01,
     &1.1672E+00,1.5430E+00,1.9051E+00,2.2331E+00,2.4741E+00,3.0857E+00,
     &3.5564E-03,4.6323E-01,9.2190E-01,1.3739E+00,1.8144E+00,2.2323E+00,
     &2.6037E+00,2.8683E+00,3.6286E+00,3.4829E-03,5.3356E-01,1.0626E+00,
     &1.5845E+00,2.0933E+00,2.5784E+00,3.0158E+00,3.3179E+00,4.1863E+00,
     &3.4329E-03,6.0324E-01,1.2029E+00,1.7965E+00,2.3794E+00,2.9402E+00,
     &3.4530E+00,3.8265E+00,4.7585E+00/
      DATA ((KA(JS,JT, 2,12),JS=1,9),JT=1,5) /
     &6.2080E-03,3.1766E-01,6.3367E-01,9.4784E-01,1.2588E+00,1.5639E+00,
     &1.8558E+00,2.1035E+00,2.5172E+00,6.0635E-03,3.8413E-01,7.6634E-01,
     &1.1462E+00,1.5215E+00,1.8884E+00,2.2355E+00,2.5176E+00,3.0427E+00,
     &5.9382E-03,4.5423E-01,9.0644E-01,1.3562E+00,1.8011E+00,2.2367E+00,
     &2.6480E+00,2.9724E+00,3.6017E+00,5.8323E-03,5.2519E-01,1.0487E+00,
     &1.5700E+00,2.0875E+00,2.5951E+00,3.0747E+00,3.4387E+00,4.1744E+00,
     &5.7338E-03,5.9386E-01,1.1863E+00,1.7768E+00,2.3632E+00,2.9403E+00,
     &3.4914E+00,3.9302E+00,4.7260E+00/
      DATA ((KA(JS,JT, 3,12),JS=1,9),JT=1,5) /
     &1.4176E-02,2.8836E-01,5.7586E-01,8.6297E-01,1.1493E+00,1.4343E+00,
     &1.7160E+00,1.9825E+00,2.2980E+00,1.3806E-02,3.5186E-01,7.0276E-01,
     &1.0533E+00,1.4030E+00,1.7510E+00,2.0945E+00,2.4186E+00,2.8053E+00,
     &1.3514E-02,4.1890E-01,8.3697E-01,1.2547E+00,1.6718E+00,2.0870E+00,
     &2.4990E+00,2.8908E+00,3.3428E+00,1.3249E-02,4.8707E-01,9.7331E-01,
     &1.4597E+00,1.9459E+00,2.4316E+00,2.9156E+00,3.3828E+00,3.8910E+00,
     &1.3015E-02,5.5537E-01,1.1100E+00,1.6644E+00,2.2195E+00,2.7745E+00,
     &3.3300E+00,3.8734E+00,4.4382E+00/
      DATA ((KA(JS,JT, 4,12),JS=1,9),JT=1,5) /
     &3.3184E-02,2.5339E-01,5.0565E-01,7.5787E-01,1.0100E+00,1.2620E+00,
     &1.5135E+00,1.7634E+00,2.0190E+00,3.2427E-02,3.1318E-01,6.2514E-01,
     &9.3708E-01,1.2489E+00,1.5601E+00,1.8704E+00,2.1781E+00,2.4966E+00,
     &3.1776E-02,3.7781E-01,7.5434E-01,1.1309E+00,1.5072E+00,1.8833E+00,
     &2.2580E+00,2.6266E+00,3.0132E+00,3.1130E-02,4.4383E-01,8.8640E-01,
     &1.3292E+00,1.7718E+00,2.2142E+00,2.6572E+00,3.0981E+00,3.5423E+00,
     &3.0303E-02,5.1080E-01,1.0203E+00,1.5301E+00,2.0399E+00,2.5495E+00,
     &3.0593E+00,3.5718E+00,4.0785E+00/
      DATA ((KA(JS,JT, 5,12),JS=1,9),JT=1,5) /
     &7.0197E-02,2.2033E-01,4.3908E-01,6.5775E-01,8.7643E-01,1.0950E+00,
     &1.3134E+00,1.5311E+00,1.7514E+00,6.8848E-02,2.7720E-01,5.5265E-01,
     &8.2808E-01,1.1036E+00,1.3787E+00,1.6538E+00,1.9275E+00,2.2056E+00,
     &6.6971E-02,3.3853E-01,6.7513E-01,1.0119E+00,1.3485E+00,1.6854E+00,
     &2.0224E+00,2.3592E+00,2.6952E+00,6.5365E-02,4.0161E-01,8.0132E-01,
     &1.2011E+00,1.6012E+00,2.0009E+00,2.4008E+00,2.8038E+00,3.2005E+00,
     &6.3431E-02,4.6828E-01,9.3456E-01,1.4005E+00,1.8671E+00,2.3331E+00,
     &2.7981E+00,3.2640E+00,3.7323E+00/
      DATA ((KA(JS,JT, 6,12),JS=1,9),JT=1,5) /
     &1.3973E-01,2.0662E-01,3.6962E-01,5.5318E-01,7.3681E-01,9.2064E-01,
     &1.1045E+00,1.2891E+00,1.4713E+00,1.3671E-01,2.4877E-01,4.7403E-01,
     &7.0978E-01,9.4572E-01,1.1814E+00,1.4179E+00,1.6551E+00,1.8888E+00,
     &1.3368E-01,2.9917E-01,5.8968E-01,8.8312E-01,1.1767E+00,1.4704E+00,
     &1.7646E+00,2.0602E+00,2.3507E+00,1.2994E-01,3.5894E-01,7.1459E-01,
     &1.0704E+00,1.4263E+00,1.7824E+00,2.1385E+00,2.4959E+00,2.8498E+00,
     &1.2525E-01,4.2650E-01,8.4975E-01,1.2729E+00,1.6963E+00,2.1200E+00,
     &2.5435E+00,2.9674E+00,3.3897E+00/
      DATA ((KA(JS,JT, 7,12),JS=1,9),JT=1,5) /
     &2.8974E-01,3.1610E-01,3.5823E-01,4.6930E-01,6.1329E-01,7.6583E-01,
     &9.1850E-01,1.0715E+00,1.2231E+00,2.8480E-01,3.2946E-01,4.3038E-01,
     &6.0019E-01,7.9796E-01,9.9665E-01,1.1955E+00,1.3949E+00,1.5921E+00,
     &2.7871E-01,3.5067E-01,5.1857E-01,7.5801E-01,1.0094E+00,1.2608E+00,
     &1.5125E+00,1.7653E+00,2.0145E+00,2.7300E-01,3.8461E-01,6.2621E-01,
     &9.3301E-01,1.2423E+00,1.5518E+00,1.8620E+00,2.1734E+00,2.4799E+00,
     &2.6591E-01,4.2736E-01,7.5270E-01,1.1266E+00,1.5003E+00,1.8747E+00,
     &2.2489E+00,2.6247E+00,2.9958E+00/
      DATA ((KA(JS,JT, 8,12),JS=1,9),JT=1,5) /
     &7.1395E-01,6.8533E-01,6.5866E-01,6.2646E-01,6.1056E-01,6.5589E-01,
     &7.5232E-01,8.7691E-01,1.0005E+00,7.0494E-01,6.9398E-01,6.9094E-01,
     &6.7668E-01,7.2746E-01,8.4153E-01,1.0006E+00,1.1668E+00,1.3319E+00,
     &6.9397E-01,7.0598E-01,7.2266E-01,7.6185E-01,8.8476E-01,1.0705E+00,
     &1.2831E+00,1.4961E+00,1.7076E+00,6.8087E-01,7.2362E-01,7.6721E-01,
     &8.7767E-01,1.0787E+00,1.3359E+00,1.6015E+00,1.8678E+00,2.1324E+00,
     &6.7139E-01,7.3688E-01,8.3187E-01,1.0246E+00,1.3106E+00,1.6352E+00,
     &1.9607E+00,2.2865E+00,2.6110E+00/
      DATA ((KA(JS,JT, 9,12),JS=1,9),JT=1,5) /
     &3.4095E+00,2.9940E+00,2.6084E+00,2.2712E+00,1.8987E+00,1.5323E+00,
     &1.1724E+00,8.1780E-01,4.0421E-01,3.3693E+00,2.9832E+00,2.6354E+00,
     &2.2978E+00,1.9462E+00,1.6166E+00,1.2713E+00,1.0128E+00,5.1858E-01,
     &3.3273E+00,2.9606E+00,2.6476E+00,2.3138E+00,2.0240E+00,1.7033E+00,
     &1.3935E+00,1.2814E+00,6.1493E-01,3.2577E+00,2.9148E+00,2.6437E+00,
     &2.3667E+00,2.0968E+00,1.8097E+00,1.5817E+00,1.6061E+00,8.7818E-01,
     &3.1999E+00,2.9208E+00,2.6366E+00,2.4121E+00,2.1879E+00,1.9394E+00,
     &1.8270E+00,1.9776E+00,1.4315E+00/
      DATA ((KA(JS,JT,10,12),JS=1,9),JT=1,5) /
     &1.8080E+01,1.5820E+01,1.3560E+01,1.1300E+01,9.1208E+00,6.9174E+00,
     &4.8050E+00,2.5816E+00,5.9225E-01,1.7863E+01,1.5633E+01,1.3401E+01,
     &1.1233E+01,9.0719E+00,6.9705E+00,4.8769E+00,2.6813E+00,6.3411E-01,
     &1.7446E+01,1.5265E+01,1.3103E+01,1.1057E+01,9.0250E+00,7.0448E+00,
     &4.8922E+00,2.7949E+00,7.0806E-01,1.7175E+01,1.5031E+01,1.2961E+01,
     &1.0925E+01,8.9744E+00,7.0129E+00,4.9823E+00,2.9347E+00,1.2270E+00,
     &1.6980E+01,1.4865E+01,1.2847E+01,1.0927E+01,9.0016E+00,7.0557E+00,
     &5.0460E+00,3.0782E+00,1.3161E+00/
      DATA ((KA(JS,JT,11,12),JS=1,9),JT=1,5) /
     &3.1621E+01,2.7664E+01,2.3716E+01,1.9762E+01,1.5836E+01,1.2028E+01,
     &8.3404E+00,4.4951E+00,7.7226E-01,3.1089E+01,2.7197E+01,2.3314E+01,
     &1.9432E+01,1.5688E+01,1.1946E+01,8.4568E+00,4.5500E+00,1.2396E+00,
     &3.0576E+01,2.6758E+01,2.2933E+01,1.9212E+01,1.5533E+01,1.1953E+01,
     &8.4697E+00,4.6829E+00,1.0564E+00,3.0097E+01,2.6346E+01,2.2583E+01,
     &1.9026E+01,1.5507E+01,1.2181E+01,8.5232E+00,4.7855E+00,1.0613E+00,
     &2.9719E+01,2.6007E+01,2.2377E+01,1.8843E+01,1.5650E+01,1.2244E+01,
     &8.6646E+00,4.9270E+00,1.7788E+00/
      DATA ((KA(JS,JT,12,12),JS=1,9),JT=1,5) /
     &3.8089E+01,3.3321E+01,2.8563E+01,2.3805E+01,1.9048E+01,1.4479E+01,
     &1.0042E+01,5.5700E+00,1.0139E+00,3.7254E+01,3.2590E+01,2.7941E+01,
     &2.3286E+01,1.8814E+01,1.4266E+01,1.0187E+01,5.6505E+00,1.3358E+00,
     &3.6753E+01,3.2149E+01,2.7565E+01,2.3058E+01,1.8681E+01,1.4515E+01,
     &1.0441E+01,5.8743E+00,1.3962E+00,3.6095E+01,3.1568E+01,2.7073E+01,
     &2.2830E+01,1.8483E+01,1.4754E+01,1.0446E+01,6.0858E+00,1.2630E+00,
     &3.5605E+01,3.1165E+01,2.6709E+01,2.2579E+01,1.8648E+01,1.4780E+01,
     &1.0721E+01,6.3554E+00,1.9400E+00/
      DATA ((KA(JS,JT,13,12),JS=1,9),JT=1,5) /
     &3.6373E+01,3.1828E+01,2.7282E+01,2.2746E+01,1.8235E+01,1.3858E+01,
     &9.7116E+00,5.3620E+00,1.4114E+00,3.6095E+01,3.1587E+01,2.7062E+01,
     &2.2560E+01,1.8254E+01,1.3864E+01,1.0010E+01,5.5792E+00,1.4567E+00,
     &3.5583E+01,3.1140E+01,2.6700E+01,2.2381E+01,1.8087E+01,1.4135E+01,
     &1.0160E+01,5.8997E+00,1.1528E+00,3.5474E+01,3.1045E+01,2.6613E+01,
     &2.2429E+01,1.8206E+01,1.4545E+01,1.0311E+01,6.1832E+00,1.6292E+00,
     &3.5565E+01,3.1124E+01,2.6773E+01,2.2531E+01,1.8670E+01,1.4802E+01,
     &1.0686E+01,6.5577E+00,2.3163E+00/
      DATA ((KA(JS,JT, 1,13),JS=1,9),JT=1,5) /
     &4.6813E-03,5.0961E-01,1.0176E+00,1.5220E+00,2.0224E+00,2.5138E+00,
     &2.9825E+00,3.3723E+00,4.0446E+00,4.5378E-03,5.9150E-01,1.1812E+00,
     &1.7694E+00,2.3540E+00,2.9329E+00,3.4999E+00,3.9983E+00,4.7077E+00,
     &4.3993E-03,6.8031E-01,1.3585E+00,2.0344E+00,2.7071E+00,3.3760E+00,
     &4.0375E+00,4.6330E+00,5.4138E+00,4.2648E-03,7.8088E-01,1.5583E+00,
     &2.3313E+00,3.0997E+00,3.8593E+00,4.5971E+00,5.2655E+00,6.1991E+00,
     &4.1347E-03,8.9242E-01,1.7790E+00,2.6579E+00,3.5250E+00,4.3745E+00,
     &5.1887E+00,5.9002E+00,7.0497E+00/
      DATA ((KA(JS,JT, 2,13),JS=1,9),JT=1,5) /
     &7.6228E-03,4.9032E-01,9.7924E-01,1.4667E+00,1.9517E+00,2.4315E+00,
     &2.8986E+00,3.3149E+00,3.9031E+00,7.3845E-03,5.7215E-01,1.1423E+00,
     &1.7099E+00,2.2735E+00,2.8309E+00,3.3762E+00,3.8853E+00,4.5466E+00,
     &7.1668E-03,6.6400E-01,1.3252E+00,1.9825E+00,2.6343E+00,3.2753E+00,
     &3.8969E+00,4.4792E+00,5.2681E+00,6.9674E-03,7.6745E-01,1.5306E+00,
     &2.2881E+00,3.0362E+00,3.7701E+00,4.4777E+00,5.1450E+00,6.0719E+00,
     &6.7870E-03,8.8445E-01,1.7639E+00,2.6357E+00,3.4964E+00,4.3377E+00,
     &5.1390E+00,5.8595E+00,6.9924E+00/
      DATA ((KA(JS,JT, 3,13),JS=1,9),JT=1,5) /
     &1.6838E-02,4.6207E-01,9.2280E-01,1.3820E+00,1.8387E+00,2.2901E+00,
     &2.7306E+00,3.1427E+00,3.6769E+00,1.6384E-02,5.4636E-01,1.0908E+00,
     &1.6331E+00,2.1721E+00,2.7041E+00,3.2216E+00,3.6963E+00,4.3436E+00,
     &1.5944E-02,6.4109E-01,1.2798E+00,1.9157E+00,2.5468E+00,3.1693E+00,
     &3.7717E+00,4.3145E+00,5.0931E+00,1.5558E-02,7.4877E-01,1.4944E+00,
     &2.2360E+00,2.9707E+00,3.6929E+00,4.3862E+00,5.0013E+00,5.9409E+00,
     &1.5161E-02,8.6996E-01,1.7361E+00,2.5972E+00,3.4498E+00,4.2854E+00,
     &5.0840E+00,5.7719E+00,6.8989E+00/
      DATA ((KA(JS,JT, 4,13),JS=1,9),JT=1,5) /
     &3.7812E-02,4.2471E-01,8.4847E-01,1.2717E+00,1.6944E+00,2.1155E+00,
     &2.5337E+00,2.9379E+00,3.3881E+00,3.6812E-02,5.1516E-01,1.0290E+00,
     &1.5422E+00,2.0538E+00,2.5636E+00,3.0667E+00,3.5462E+00,4.1066E+00,
     &3.5849E-02,6.1666E-01,1.2316E+00,1.8451E+00,2.4569E+00,3.0640E+00,
     &3.6618E+00,4.2232E+00,4.9129E+00,3.5079E-02,7.3193E-01,1.4618E+00,
     &2.1899E+00,2.9146E+00,3.6330E+00,4.3356E+00,4.9789E+00,5.8283E+00,
     &3.4393E-02,8.5645E-01,1.7103E+00,2.5622E+00,3.4100E+00,4.2503E+00,
     &5.0712E+00,5.8174E+00,6.8190E+00/
      DATA ((KA(JS,JT, 5,13),JS=1,9),JT=1,5) /
     &8.0627E-02,3.8028E-01,7.5923E-01,1.1381E+00,1.5165E+00,1.8947E+00,
     &2.2720E+00,2.6453E+00,3.0318E+00,7.8562E-02,4.7262E-01,9.4356E-01,
     &1.4144E+00,1.8847E+00,2.3543E+00,2.8214E+00,3.2802E+00,3.7680E+00,
     &7.6982E-02,5.7810E-01,1.1544E+00,1.7303E+00,2.3053E+00,2.8784E+00,
     &3.4478E+00,4.0008E+00,4.6091E+00,7.5657E-02,6.9735E-01,1.3928E+00,
     &2.0875E+00,2.7814E+00,3.4728E+00,4.1587E+00,4.8230E+00,5.5613E+00,
     &7.4333E-02,8.2506E-01,1.6482E+00,2.4702E+00,3.2916E+00,4.1103E+00,
     &4.9228E+00,5.7104E+00,6.5816E+00/
      DATA ((KA(JS,JT, 6,13),JS=1,9),JT=1,5) /
     &1.6425E-01,3.3608E-01,6.6609E-01,9.9817E-01,1.3302E+00,1.6619E+00,
     &1.9931E+00,2.3215E+00,2.6587E+00,1.6074E-01,4.2522E-01,8.4831E-01,
     &1.2715E+00,1.6941E+00,2.1166E+00,2.5378E+00,2.9543E+00,3.3863E+00,
     &1.5834E-01,5.2989E-01,1.0574E+00,1.5848E+00,2.1117E+00,2.6382E+00,
     &3.1634E+00,3.6820E+00,4.2213E+00,1.5607E-01,6.4460E-01,1.2868E+00,
     &1.9290E+00,2.5707E+00,3.2115E+00,3.8511E+00,4.4833E+00,5.1392E+00,
     &1.5296E-01,7.6868E-01,1.5350E+00,2.3008E+00,3.0663E+00,3.8313E+00,
     &4.5942E+00,5.3490E+00,6.1304E+00/
      DATA ((KA(JS,JT, 7,13),JS=1,9),JT=1,5) /
     &3.5667E-01,3.9890E-01,5.8897E-01,8.6077E-01,1.1469E+00,1.4325E+00,
     &1.7184E+00,2.0036E+00,2.2913E+00,3.5161E-01,4.4967E-01,7.5040E-01,
     &1.1221E+00,1.4950E+00,1.8682E+00,2.2405E+00,2.6119E+00,2.9872E+00,
     &3.4606E-01,5.1859E-01,9.4635E-01,1.4181E+00,1.8897E+00,2.3609E+00,
     &2.8323E+00,3.3018E+00,3.7764E+00,3.3825E-01,6.0265E-01,1.1668E+00,
     &1.7485E+00,2.3304E+00,2.9114E+00,3.4925E+00,4.0716E+00,4.6575E+00,
     &3.3043E-01,7.1091E-01,1.4088E+00,2.1112E+00,2.8136E+00,3.5161E+00,
     &4.2182E+00,4.9170E+00,5.6239E+00/
      DATA ((KA(JS,JT, 8,13),JS=1,9),JT=1,5) /
     &9.2067E-01,8.6182E-01,8.2952E-01,8.7491E-01,1.0086E+00,1.2181E+00,
     &1.4607E+00,1.7034E+00,1.9462E+00,9.0671E-01,8.7567E-01,8.9610E-01,
     &1.0491E+00,1.2996E+00,1.6153E+00,1.9371E+00,2.2592E+00,2.5816E+00,
     &8.8973E-01,8.8439E-01,1.0044E+00,1.2766E+00,1.6623E+00,2.0766E+00,
     &2.4910E+00,2.9049E+00,3.3193E+00,8.6846E-01,9.1357E-01,1.1469E+00,
     &1.5675E+00,2.0797E+00,2.5979E+00,3.1162E+00,3.6352E+00,4.1539E+00,
     &8.4664E-01,9.6627E-01,1.3262E+00,1.9064E+00,2.5399E+00,3.1734E+00,
     &3.8073E+00,4.4405E+00,5.0740E+00/
      DATA ((KA(JS,JT, 9,13),JS=1,9),JT=1,5) /
     &4.4067E+00,3.8562E+00,3.3799E+00,2.9279E+00,2.4898E+00,2.0023E+00,
     &1.6061E+00,1.4556E+00,5.3966E-01,4.3584E+00,3.8431E+00,3.3719E+00,
     &2.9985E+00,2.5395E+00,2.1329E+00,1.8824E+00,1.9290E+00,1.2534E+00,
     &4.2715E+00,3.7950E+00,3.4185E+00,3.0378E+00,2.6388E+00,2.3497E+00,
     &2.2667E+00,2.5092E+00,2.3205E+00,4.1934E+00,3.7482E+00,3.4519E+00,
     &3.0862E+00,2.7969E+00,2.6493E+00,2.7789E+00,3.1851E+00,3.5246E+00,
     &4.0917E+00,3.7105E+00,3.4634E+00,3.1979E+00,3.0093E+00,3.0525E+00,
     &3.4012E+00,3.9555E+00,4.5178E+00/
      DATA ((KA(JS,JT,10,13),JS=1,9),JT=1,5) /
     &2.3719E+01,2.0753E+01,1.7788E+01,1.4825E+01,1.1907E+01,9.0621E+00,
     &6.2541E+00,3.4363E+00,9.1814E-01,2.3432E+01,2.0501E+01,1.7571E+01,
     &1.4658E+01,1.1890E+01,9.0622E+00,6.4024E+00,3.5910E+00,1.1158E+00,
     &2.3069E+01,2.0187E+01,1.7300E+01,1.4541E+01,1.1793E+01,9.1570E+00,
     &6.5099E+00,3.8249E+00,9.3188E-01,2.2641E+01,1.9809E+01,1.6998E+01,
     &1.4367E+01,1.1776E+01,9.2770E+00,6.6180E+00,4.0885E+00,9.9189E-01,
     &2.2220E+01,1.9436E+01,1.6770E+01,1.4187E+01,1.1792E+01,9.2910E+00,
     &6.8771E+00,4.4865E+00,1.9399E+00/
      DATA ((KA(JS,JT,11,13),JS=1,9),JT=1,5) /
     &4.4319E+01,3.8780E+01,3.3240E+01,2.7701E+01,2.2160E+01,1.6704E+01,
     &1.1307E+01,6.0563E+00,5.8625E-01,4.3809E+01,3.8330E+01,3.2852E+01,
     &2.7376E+01,2.1936E+01,1.6626E+01,1.1378E+01,6.1989E+00,8.1730E-01,
     &4.3202E+01,3.7799E+01,3.2400E+01,2.7000E+01,2.1788E+01,1.6575E+01,
     &1.1586E+01,6.3577E+00,1.8296E+00,4.2458E+01,3.7147E+01,3.1841E+01,
     &2.6621E+01,2.1500E+01,1.6577E+01,1.1663E+01,6.6208E+00,1.8735E+00,
     &4.1634E+01,3.6429E+01,3.1221E+01,2.6233E+01,2.1246E+01,1.6580E+01,
     &1.1685E+01,6.9092E+00,1.7032E+00/
      DATA ((KA(JS,JT,12,13),JS=1,9),JT=1,5) /
     &6.1904E+01,5.4167E+01,4.6429E+01,3.8690E+01,3.0952E+01,2.3248E+01,
     &1.5661E+01,8.2582E+00,4.3930E-01,6.1270E+01,5.3611E+01,4.5953E+01,
     &3.8296E+01,3.0637E+01,2.3190E+01,1.5723E+01,8.4338E+00,1.2396E+00,
     &6.0345E+01,5.2802E+01,4.5261E+01,3.7714E+01,3.0326E+01,2.2898E+01,
     &1.5824E+01,8.5563E+00,2.5106E+00,5.9306E+01,5.1895E+01,4.4474E+01,
     &3.7089E+01,2.9895E+01,2.2756E+01,1.5929E+01,8.7873E+00,2.2974E+00,
     &5.8419E+01,5.1111E+01,4.3811E+01,3.6683E+01,2.9523E+01,2.2821E+01,
     &1.5911E+01,9.0327E+00,2.2973E+00/
      DATA ((KA(JS,JT,13,13),JS=1,9),JT=1,5) /
     &6.8544E+01,5.9975E+01,5.1408E+01,4.2840E+01,3.4272E+01,2.5775E+01,
     &1.7340E+01,9.2235E+00,4.0824E-01,6.7698E+01,5.9233E+01,5.0770E+01,
     &4.2312E+01,3.3875E+01,2.5602E+01,1.7402E+01,9.3485E+00,1.7747E+00,
     &6.6803E+01,5.8453E+01,5.0103E+01,4.1750E+01,3.3601E+01,2.5372E+01,
     &1.7686E+01,9.4660E+00,2.9931E+00,6.5956E+01,5.7706E+01,4.9463E+01,
     &4.1288E+01,3.3259E+01,2.5336E+01,1.7750E+01,9.7483E+00,2.7732E+00,
     &6.5110E+01,5.6969E+01,4.8829E+01,4.0948E+01,3.2989E+01,2.5559E+01,
     &1.7705E+01,9.9706E+00,2.2584E+00/
      DATA ((KA(JS,JT, 1,14),JS=1,9),JT=1,5) /
     &5.3617E-03,8.8862E-01,1.7657E+00,2.6246E+00,3.4547E+00,4.2326E+00,
     &4.9022E+00,5.2848E+00,6.9093E+00,5.2510E-03,1.0670E+00,2.1191E+00,
     &3.1492E+00,4.1423E+00,5.0696E+00,5.8593E+00,6.2778E+00,8.2844E+00,
     &5.1410E-03,1.2574E+00,2.4970E+00,3.7095E+00,4.8778E+00,5.9654E+00,
     &6.8831E+00,7.3419E+00,9.7553E+00,5.0266E-03,1.4566E+00,2.8932E+00,
     &4.2987E+00,5.6515E+00,6.9086E+00,7.9640E+00,8.4651E+00,1.1303E+01,
     &4.9104E-03,1.6562E+00,3.2920E+00,4.8956E+00,6.4440E+00,7.8868E+00,
     &9.0871E+00,9.6375E+00,1.2888E+01/
      DATA ((KA(JS,JT, 2,14),JS=1,9),JT=1,5) /
     &8.7449E-03,9.0334E-01,1.7988E+00,2.6821E+00,3.5450E+00,4.3691E+00,
     &5.1072E+00,5.5794E+00,7.0898E+00,8.5771E-03,1.0973E+00,2.1846E+00,
     &3.2569E+00,4.3031E+00,5.3011E+00,6.1907E+00,6.7403E+00,8.6059E+00,
     &8.3757E-03,1.3007E+00,2.5910E+00,3.8649E+00,5.1100E+00,6.3010E+00,
     &7.3563E+00,7.9915E+00,1.0220E+01,8.1726E-03,1.5076E+00,3.0039E+00,
     &4.4835E+00,5.9326E+00,7.3236E+00,8.5740E+00,9.3177E+00,1.1865E+01,
     &7.9706E-03,1.7155E+00,3.4194E+00,5.1046E+00,6.7592E+00,8.3528E+00,
     &9.7973E+00,1.0700E+01,1.3518E+01/
      DATA ((KA(JS,JT, 3,14),JS=1,9),JT=1,5) /
     &1.9310E-02,8.7468E-01,1.7453E+00,2.6103E+00,3.4663E+00,4.3037E+00,
     &5.0955E+00,5.7297E+00,6.9321E+00,1.8969E-02,1.0738E+00,2.1432E+00,
     &3.2076E+00,4.2608E+00,5.2941E+00,6.2765E+00,7.0620E+00,8.5210E+00,
     &1.8605E-02,1.2813E+00,2.5582E+00,3.8286E+00,5.0883E+00,6.3262E+00,
     &7.5114E+00,8.4846E+00,1.0176E+01,1.8213E-02,1.4944E+00,2.9835E+00,
     &4.4663E+00,5.9372E+00,7.3859E+00,8.7760E+00,9.9435E+00,1.1874E+01,
     &1.7876E-02,1.7091E+00,3.4131E+00,5.1104E+00,6.7954E+00,8.4548E+00,
     &1.0056E+01,1.1421E+01,1.3590E+01/
      DATA ((KA(JS,JT, 4,14),JS=1,9),JT=1,5) /
     &4.4344E-02,8.3370E-01,1.6650E+00,2.4941E+00,3.3185E+00,4.1344E+00,
     &4.9297E+00,5.6430E+00,6.6364E+00,4.3566E-02,1.0283E+00,2.0545E+00,
     &3.0778E+00,4.0971E+00,5.1067E+00,6.0943E+00,6.9950E+00,8.1935E+00,
     &4.2932E-02,1.2330E+00,2.4636E+00,3.6915E+00,4.9148E+00,6.1292E+00,
     &7.3214E+00,8.4254E+00,9.8287E+00,4.2251E-02,1.4427E+00,2.8831E+00,
     &4.3208E+00,5.7549E+00,7.1799E+00,8.5827E+00,9.9037E+00,1.1509E+01,
     &4.1551E-02,1.6617E+00,3.3208E+00,4.9772E+00,6.6290E+00,8.2714E+00,
     &9.8934E+00,1.1428E+01,1.3257E+01/
      DATA ((KA(JS,JT, 5,14),JS=1,9),JT=1,5) /
     &9.4754E-02,7.8821E-01,1.5748E+00,2.3603E+00,3.1437E+00,3.9237E+00,
     &4.6947E+00,5.4302E+00,6.2865E+00,9.3575E-02,9.7845E-01,1.9550E+00,
     &2.9310E+00,3.9047E+00,4.8748E+00,5.8356E+00,6.7595E+00,7.8084E+00,
     &9.2188E-02,1.1782E+00,2.3547E+00,3.5302E+00,4.7038E+00,5.8743E+00,
     &7.0357E+00,8.1610E+00,9.4064E+00,9.0816E-02,1.3863E+00,2.7710E+00,
     &4.1546E+00,5.5362E+00,6.9136E+00,8.2813E+00,9.6122E+00,1.1071E+01,
     &8.9641E-02,1.6059E+00,3.2095E+00,4.8121E+00,6.4122E+00,8.0077E+00,
     &9.5924E+00,1.1136E+01,1.2823E+01/
      DATA ((KA(JS,JT, 6,14),JS=1,9),JT=1,5) /
     &1.9317E-01,7.2809E-01,1.4547E+00,2.1811E+00,2.9065E+00,3.6305E+00,
     &4.3507E+00,5.0577E+00,5.8117E+00,1.9031E-01,9.0988E-01,1.8182E+00,
     &2.7260E+00,3.6329E+00,4.5385E+00,5.4408E+00,6.3293E+00,7.2643E+00,
     &1.8758E-01,1.1038E+00,2.2061E+00,3.3074E+00,4.4083E+00,5.5073E+00,
     &6.6028E+00,7.6822E+00,8.8149E+00,1.8516E-01,1.3141E+00,2.6258E+00,
     &3.9372E+00,5.2485E+00,6.5558E+00,7.8598E+00,9.1449E+00,1.0495E+01,
     &1.8433E-01,1.5378E+00,3.0732E+00,4.6078E+00,6.1419E+00,7.6735E+00,
     &9.1990E+00,1.0701E+01,1.2282E+01/
      DATA ((KA(JS,JT, 7,14),JS=1,9),JT=1,5) /
     &4.2545E-01,7.0197E-01,1.3229E+00,1.9833E+00,2.6434E+00,3.3025E+00,
     &3.9608E+00,4.6133E+00,5.2849E+00,4.1807E-01,8.4884E-01,1.6721E+00,
     &2.5066E+00,3.3410E+00,4.1750E+00,5.0067E+00,5.8326E+00,6.6798E+00,
     &4.1332E-01,1.0301E+00,2.0577E+00,3.0848E+00,4.1118E+00,5.1378E+00,
     &6.1618E+00,7.1777E+00,8.2211E+00,4.0936E-01,1.2414E+00,2.4798E+00,
     &3.7180E+00,4.9556E+00,6.1921E+00,7.4267E+00,8.6520E+00,9.9083E+00,
     &4.0685E-01,1.4675E+00,2.9318E+00,4.3961E+00,5.8593E+00,7.3214E+00,
     &8.7804E+00,1.0230E+01,1.1715E+01/
      DATA ((KA(JS,JT, 8,14),JS=1,9),JT=1,5) /
     &1.1195E+00,1.0895E+00,1.3598E+00,1.7846E+00,2.3466E+00,2.9325E+00,
     &3.5182E+00,4.1012E+00,4.6898E+00,1.1037E+00,1.1788E+00,1.6176E+00,
     &2.2927E+00,3.0553E+00,3.8181E+00,4.5804E+00,5.3406E+00,6.1069E+00,
     &1.0884E+00,1.2851E+00,1.9342E+00,2.8650E+00,3.8186E+00,4.7719E+00,
     &5.7236E+00,6.6739E+00,7.6330E+00,1.0777E+00,1.3879E+00,2.3316E+00,
     &3.4927E+00,4.6551E+00,5.8169E+00,6.9783E+00,8.1364E+00,9.3055E+00,
     &1.0697E+00,1.5195E+00,2.7843E+00,4.1737E+00,5.5632E+00,6.9521E+00,
     &8.3391E+00,9.7222E+00,1.1121E+01/
      DATA ((KA(JS,JT, 9,14),JS=1,9),JT=1,5) /
     &5.6190E+00,4.9167E+00,4.3250E+00,3.7358E+00,3.4047E+00,3.1579E+00,
     &3.1500E+00,3.5459E+00,3.9362E+00,5.5255E+00,4.8418E+00,4.3146E+00,
     &3.9154E+00,3.7623E+00,3.7282E+00,4.0980E+00,4.7612E+00,5.4406E+00,
     &5.4430E+00,4.8357E+00,4.3573E+00,4.2040E+00,4.1594E+00,4.5007E+00,
     &5.2453E+00,6.1166E+00,6.9893E+00,5.3842E+00,4.8388E+00,4.5334E+00,
     &4.4707E+00,4.7073E+00,5.4536E+00,6.5005E+00,7.5810E+00,8.6617E+00,
     &5.3385E+00,4.8392E+00,4.7032E+00,4.7787E+00,5.4197E+00,6.5502E+00,
     &7.8564E+00,9.1615E+00,1.0470E+01/
      DATA ((KA(JS,JT,10,14),JS=1,9),JT=1,5) /
     &3.1503E+01,2.7564E+01,2.3627E+01,1.9689E+01,1.5752E+01,1.2029E+01,
     &8.2850E+00,5.0089E+00,2.6421E-01,3.1041E+01,2.7162E+01,2.3282E+01,
     &1.9402E+01,1.5696E+01,1.2052E+01,8.5363E+00,5.5767E+00,1.2004E+00,
     &3.0653E+01,2.6822E+01,2.2991E+01,1.9210E+01,1.5684E+01,1.2101E+01,
     &9.0343E+00,6.3229E+00,1.6811E+00,3.0330E+01,2.6541E+01,2.2749E+01,
     &1.9185E+01,1.5678E+01,1.2425E+01,9.5207E+00,7.4497E+00,1.5881E+00,
     &2.9986E+01,2.6238E+01,2.2506E+01,1.9078E+01,1.5796E+01,1.2833E+01,
     &1.0036E+01,8.8467E+00,2.8996E+00/
      DATA ((KA(JS,JT,11,14),JS=1,9),JT=1,5) /
     &6.1029E+01,5.3402E+01,4.5771E+01,3.8145E+01,3.0515E+01,2.2887E+01,
     &1.5544E+01,8.4710E+00,5.1903E-01,6.0319E+01,5.2777E+01,4.5238E+01,
     &3.7700E+01,3.0160E+01,2.2857E+01,1.5622E+01,8.8835E+00,1.0450E+00,
     &5.9632E+01,5.2177E+01,4.4723E+01,3.7270E+01,2.9909E+01,2.2818E+01,
     &1.5829E+01,9.3768E+00,1.3014E+00,5.9020E+01,5.1642E+01,4.4266E+01,
     &3.6888E+01,2.9847E+01,2.2764E+01,1.6262E+01,9.9702E+00,2.2647E+00,
     &5.8283E+01,5.0998E+01,4.3714E+01,3.6531E+01,2.9620E+01,2.3044E+01,
     &1.6667E+01,1.0858E+01,2.1604E+00/
      DATA ((KA(JS,JT,12,14),JS=1,9),JT=1,5) /
     &8.6818E+01,7.5961E+01,6.5105E+01,5.4264E+01,4.3410E+01,3.2557E+01,
     &2.1958E+01,1.1756E+01,1.0818E+00,8.5898E+01,7.5160E+01,6.4423E+01,
     &5.3685E+01,4.2947E+01,3.2329E+01,2.1951E+01,1.2183E+01,6.2703E-01,
     &8.4970E+01,7.4354E+01,6.3731E+01,5.3109E+01,4.2485E+01,3.2310E+01,
     &2.2149E+01,1.2602E+01,1.0531E+00,8.4043E+01,7.3537E+01,6.3034E+01,
     &5.2533E+01,4.2288E+01,3.2140E+01,2.2696E+01,1.3012E+01,4.3852E+00,
     &8.3130E+01,7.2745E+01,6.2351E+01,5.1964E+01,4.2084E+01,3.2159E+01,
     &2.3067E+01,1.3670E+01,3.1697E+00/
      DATA ((KA(JS,JT,13,14),JS=1,9),JT=1,5) /
     &9.9062E+01,8.6679E+01,7.4295E+01,6.1914E+01,4.9531E+01,3.7148E+01,
     &2.5053E+01,1.3336E+01,1.0355E+00,9.8005E+01,8.5755E+01,7.3503E+01,
     &6.1254E+01,4.9004E+01,3.6913E+01,2.4991E+01,1.3937E+01,6.5467E-01,
     &9.6910E+01,8.4797E+01,7.2683E+01,6.0573E+01,4.8483E+01,3.6814E+01,
     &2.5110E+01,1.4339E+01,1.8215E+00,9.5837E+01,8.3857E+01,7.1882E+01,
     &5.9896E+01,4.8229E+01,3.6584E+01,2.5752E+01,1.4680E+01,4.3881E+00,
     &9.4386E+01,8.2585E+01,7.0788E+01,5.9024E+01,4.7765E+01,3.6452E+01,
     &2.6308E+01,1.5330E+01,4.3734E+00/
      DATA ((KA(JS,JT, 1,15),JS=1,9),JT=1,5) /
     &6.2662E-03,2.0747E+00,4.1170E+00,6.1089E+00,8.0146E+00,9.7584E+00,
     &1.1145E+01,1.1422E+01,1.6029E+01,6.1351E-03,2.4271E+00,4.8178E+00,
     &7.1504E+00,9.3877E+00,1.1443E+01,1.3088E+01,1.3461E+01,1.8775E+01,
     &6.0097E-03,2.7826E+00,5.5248E+00,8.2041E+00,1.0775E+01,1.3145E+01,
     &1.5060E+01,1.5543E+01,2.1551E+01,5.9020E-03,3.1403E+00,6.2337E+00,
     &9.2578E+00,1.2161E+01,1.4850E+01,1.7039E+01,1.7642E+01,2.4321E+01,
     &5.8030E-03,3.5098E+00,6.9636E+00,1.0331E+01,1.3560E+01,1.6533E+01,
     &1.8991E+01,1.9724E+01,2.7120E+01/
      DATA ((KA(JS,JT, 2,15),JS=1,9),JT=1,5) /
     &1.0266E-02,2.1405E+00,4.2622E+00,6.3547E+00,8.3970E+00,1.0344E+01,
     &1.2064E+01,1.2985E+01,1.6794E+01,1.0014E-02,2.5163E+00,5.0119E+00,
     &7.4752E+00,9.8815E+00,1.2172E+01,1.4218E+01,1.5356E+01,1.9763E+01,
     &9.8638E-03,2.9079E+00,5.7890E+00,8.6292E+00,1.1401E+01,1.4046E+01,
     &1.6408E+01,1.7772E+01,2.2802E+01,9.7234E-03,3.3191E+00,6.6057E+00,
     &9.8408E+00,1.2995E+01,1.5989E+01,1.8633E+01,2.0195E+01,2.5989E+01,
     &9.5893E-03,3.7435E+00,7.4476E+00,1.1096E+01,1.4644E+01,1.8006E+01,
     &2.0946E+01,2.2600E+01,2.9288E+01/
      DATA ((KA(JS,JT, 3,15),JS=1,9),JT=1,5) /
     &2.3937E-02,2.0884E+00,4.1689E+00,6.2403E+00,8.2897E+00,1.0301E+01,
     &1.2219E+01,1.3769E+01,1.6579E+01,2.3289E-02,2.4959E+00,4.9798E+00,
     &7.4513E+00,9.8967E+00,1.2286E+01,1.4557E+01,1.6412E+01,1.9793E+01,
     &2.2745E-02,2.9294E+00,5.8465E+00,8.7448E+00,1.1610E+01,1.4408E+01,
     &1.7054E+01,1.9158E+01,2.3219E+01,2.2330E-02,3.3848E+00,6.7550E+00,
     &1.0101E+01,1.3409E+01,1.6637E+01,1.9679E+01,2.2057E+01,2.6817E+01,
     &2.1962E-02,3.8549E+00,7.6925E+00,1.1504E+01,1.5265E+01,1.8935E+01,
     &2.2399E+01,2.5067E+01,3.0529E+01/
      DATA ((KA(JS,JT, 4,15),JS=1,9),JT=1,5) /
     &5.8511E-02,1.9940E+00,3.9844E+00,5.9687E+00,7.9437E+00,9.9016E+00,
     &1.1811E+01,1.3553E+01,1.5887E+01,5.6982E-02,2.4233E+00,4.8420E+00,
     &7.2530E+00,9.6512E+00,1.2029E+01,1.4341E+01,1.6438E+01,1.9302E+01,
     &5.5673E-02,2.8886E+00,5.7711E+00,8.6444E+00,1.1501E+01,1.4329E+01,
     &1.7084E+01,1.9562E+01,2.3002E+01,5.4580E-02,3.3869E+00,6.7661E+00,
     &1.0134E+01,1.3482E+01,1.6795E+01,2.0015E+01,2.2895E+01,2.6964E+01,
     &5.3615E-02,3.9077E+00,7.8058E+00,1.1691E+01,1.5555E+01,1.9373E+01,
     &2.3083E+01,2.6384E+01,3.1109E+01/
      DATA ((KA(JS,JT, 5,15),JS=1,9),JT=1,5) /
     &1.2989E-01,1.8900E+00,3.7783E+00,5.6637E+00,7.5463E+00,9.4177E+00,
     &1.1267E+01,1.3028E+01,1.5093E+01,1.2665E-01,2.3422E+00,4.6829E+00,
     &7.0179E+00,9.3476E+00,1.1662E+01,1.3953E+01,1.6125E+01,1.8695E+01,
     &1.2397E-01,2.8405E+00,5.6772E+00,8.5098E+00,1.1334E+01,1.4142E+01,
     &1.6912E+01,1.9527E+01,2.2668E+01,1.2164E-01,3.3767E+00,6.7490E+00,
     &1.0116E+01,1.3472E+01,1.6807E+01,2.0097E+01,2.3197E+01,2.6943E+01,
     &1.1945E-01,3.9432E+00,7.8814E+00,1.1812E+01,1.5732E+01,1.9624E+01,
     &2.3463E+01,2.7077E+01,3.1463E+01/
      DATA ((KA(JS,JT, 6,15),JS=1,9),JT=1,5) /
     &2.7269E-01,1.7592E+00,3.5166E+00,5.2733E+00,7.0272E+00,8.7771E+00,
     &1.0515E+01,1.2209E+01,1.4054E+01,2.6586E-01,2.2331E+00,4.4644E+00,
     &6.6948E+00,8.9210E+00,1.1141E+01,1.3343E+01,1.5486E+01,1.7841E+01,
     &2.5987E-01,2.7625E+00,5.5224E+00,8.2799E+00,1.1033E+01,1.3778E+01,
     &1.6504E+01,1.9146E+01,2.2064E+01,2.5470E-01,3.3380E+00,6.6713E+00,
     &1.0004E+01,1.3331E+01,1.6646E+01,1.9934E+01,2.3121E+01,2.6661E+01,
     &2.4980E-01,3.9509E+00,7.8982E+00,1.1841E+01,1.5778E+01,1.9702E+01,
     &2.3595E+01,2.7362E+01,3.1554E+01/
      DATA ((KA(JS,JT, 7,15),JS=1,9),JT=1,5) /
     &6.0751E-01,1.6155E+00,3.2295E+00,4.8433E+00,6.4556E+00,8.0666E+00,
     &9.6721E+00,1.1255E+01,1.2910E+01,5.9214E-01,2.1056E+00,4.2107E+00,
     &6.3119E+00,8.4131E+00,1.0511E+01,1.2602E+01,1.4667E+01,1.6825E+01,
     &5.7904E-01,2.6613E+00,5.3198E+00,7.9772E+00,1.0632E+01,1.3285E+01,
     &1.5925E+01,1.8528E+01,2.1262E+01,5.6819E-01,3.2710E+00,6.5412E+00,
     &9.8097E+00,1.3074E+01,1.6330E+01,1.9581E+01,2.2775E+01,2.6146E+01,
     &5.5940E-01,3.9287E+00,7.8537E+00,1.1777E+01,1.5697E+01,1.9610E+01,
     &2.3510E+01,2.7346E+01,3.1392E+01/
      DATA ((KA(JS,JT, 8,15),JS=1,9),JT=1,5) /
     &1.5944E+00,1.8253E+00,2.9741E+00,4.4602E+00,5.9464E+00,7.4314E+00,
     &8.9145E+00,1.0387E+01,1.1892E+01,1.5557E+00,2.1022E+00,3.9278E+00,
     &5.8889E+00,7.8512E+00,9.8106E+00,1.1770E+01,1.3716E+01,1.5700E+01,
     &1.5271E+00,2.5583E+00,5.0719E+00,7.6057E+00,1.0139E+01,1.2670E+01,
     &1.5200E+01,1.7713E+01,2.0275E+01,1.5040E+00,3.1773E+00,6.3513E+00,
     &9.5214E+00,1.2692E+01,1.5861E+01,1.9025E+01,2.2168E+01,2.5379E+01,
     &1.4829E+00,3.8723E+00,7.7385E+00,1.1605E+01,1.5469E+01,1.9331E+01,
     &2.3189E+01,2.7019E+01,3.0932E+01/
      DATA ((KA(JS,JT, 9,15),JS=1,9),JT=1,5) /
     &7.9603E+00,6.9650E+00,6.1670E+00,5.9409E+00,5.9163E+00,6.8445E+00,
     &8.2104E+00,9.5758E+00,1.0949E+01,7.7491E+00,6.7807E+00,6.5143E+00,
     &6.5222E+00,7.4209E+00,9.1698E+00,1.1001E+01,1.2830E+01,1.4668E+01,
     &7.6260E+00,6.7058E+00,6.8127E+00,7.5772E+00,9.5702E+00,1.1961E+01,
     &1.4350E+01,1.6735E+01,1.9129E+01,7.5222E+00,6.8189E+00,7.2464E+00,
     &9.2266E+00,1.2156E+01,1.5192E+01,1.8221E+01,2.1251E+01,2.4297E+01,
     &7.4213E+00,6.9850E+00,8.1141E+00,1.1288E+01,1.5041E+01,1.8797E+01,
     &2.2550E+01,2.6298E+01,3.0063E+01/
      DATA ((KA(JS,JT,10,15),JS=1,9),JT=1,5) /
     &4.4970E+01,3.9351E+01,3.3728E+01,2.8106E+01,2.2484E+01,1.7001E+01,
     &1.2662E+01,9.3833E+00,3.0844E+00,4.3703E+01,3.8241E+01,3.2779E+01,
     &2.7313E+01,2.1862E+01,1.7553E+01,1.3621E+01,1.2273E+01,6.8989E+00,
     &4.2828E+01,3.7472E+01,3.2122E+01,2.6765E+01,2.2087E+01,1.8341E+01,
     &1.5372E+01,1.6156E+01,1.4584E+01,4.2192E+01,3.6921E+01,3.1646E+01,
     &2.6524E+01,2.2776E+01,1.9260E+01,1.8346E+01,2.0694E+01,2.3643E+01,
     &4.1609E+01,3.6411E+01,3.1210E+01,2.6835E+01,2.3359E+01,2.1143E+01,
     &2.2256E+01,2.5773E+01,2.9447E+01/
      DATA ((KA(JS,JT,11,15),JS=1,9),JT=1,5) /
     &8.7878E+01,7.6892E+01,6.5913E+01,5.4929E+01,4.3942E+01,3.2958E+01,
     &2.2278E+01,1.3146E+01,1.2934E+00,8.5528E+01,7.4837E+01,6.4148E+01,
     &5.3454E+01,4.2765E+01,3.2087E+01,2.2860E+01,1.5064E+01,9.2095E-01,
     &8.3842E+01,7.3371E+01,6.2884E+01,5.2405E+01,4.1923E+01,3.2241E+01,
     &2.3615E+01,1.8250E+01,5.0549E+00,8.2422E+01,7.2123E+01,6.1819E+01,
     &5.1515E+01,4.1404E+01,3.2935E+01,2.5033E+01,2.2612E+01,1.1342E+01,
     &8.1155E+01,7.1009E+01,6.0866E+01,5.0722E+01,4.1664E+01,3.3361E+01,
     &2.7672E+01,2.7836E+01,2.1588E+01/
      DATA ((KA(JS,JT,12,15),JS=1,9),JT=1,5) /
     &1.2764E+02,1.1168E+02,9.5717E+01,7.9766E+01,6.3821E+01,4.7862E+01,
     &3.1927E+01,1.7517E+01,5.0733E-04,1.2458E+02,1.0901E+02,9.3437E+01,
     &7.7867E+01,6.2287E+01,4.6718E+01,3.2041E+01,1.8889E+01,1.2295E+00,
     &1.2214E+02,1.0687E+02,9.1606E+01,7.6332E+01,6.1069E+01,4.6041E+01,
     &3.2605E+01,2.1597E+01,1.0764E+00,1.1993E+02,1.0494E+02,8.9942E+01,
     &7.4954E+01,5.9961E+01,4.6289E+01,3.3082E+01,2.5581E+01,1.5268E+00,
     &1.1793E+02,1.0318E+02,8.8443E+01,7.3700E+01,5.9323E+01,4.6666E+01,
     &3.5017E+01,3.0597E+01,1.3997E+01/
      DATA ((KA(JS,JT,13,15),JS=1,9),JT=1,5) /
     &1.4863E+02,1.3005E+02,1.1147E+02,9.2892E+01,7.4315E+01,5.5737E+01,
     &3.7199E+01,2.0080E+01,6.4806E-01,1.4520E+02,1.2704E+02,1.0889E+02,
     &9.0753E+01,7.2597E+01,5.4452E+01,3.7281E+01,2.1314E+01,1.2348E+00,
     &1.4229E+02,1.2450E+02,1.0672E+02,8.8931E+01,7.1150E+01,5.3675E+01,
     &3.7660E+01,2.4186E+01,1.1194E+00,1.3965E+02,1.2219E+02,1.0474E+02,
     &8.7285E+01,6.9825E+01,5.3800E+01,3.7958E+01,2.8295E+01,2.6393E+00,
     &1.3732E+02,1.2017E+02,1.0299E+02,8.5829E+01,6.9074E+01,5.3874E+01,
     &3.9693E+01,3.3322E+01,1.2822E+01/
      DATA ((KA(JS,JT, 1,16),JS=1,9),JT=1,5) /
     &6.7483E-03,2.7477E+00,5.4216E+00,7.9838E+00,1.0362E+01,1.2414E+01,
     &1.3792E+01,1.3364E+01,2.0724E+01,6.6276E-03,3.2705E+00,6.4539E+00,
     &9.5049E+00,1.2338E+01,1.4784E+01,1.6428E+01,1.5929E+01,2.4675E+01,
     &6.5036E-03,3.8140E+00,7.5283E+00,1.1085E+01,1.4395E+01,1.7249E+01,
     &1.9172E+01,1.8603E+01,2.8790E+01,6.3721E-03,4.3730E+00,8.6292E+00,
     &1.2711E+01,1.6503E+01,1.9784E+01,2.1993E+01,2.1351E+01,3.3006E+01,
     &6.2363E-03,4.9396E+00,9.7465E+00,1.4357E+01,1.8648E+01,2.2353E+01,
     &2.4860E+01,2.4146E+01,3.7295E+01/
      DATA ((KA(JS,JT, 2,16),JS=1,9),JT=1,5) /
     &1.1399E-02,3.0700E+00,6.0865E+00,9.0222E+00,1.1819E+01,1.4357E+01,
     &1.6335E+01,1.6615E+01,2.3637E+01,1.1191E-02,3.6855E+00,7.3071E+00,
     &1.0831E+01,1.4189E+01,1.7243E+01,1.9624E+01,1.9971E+01,2.8378E+01,
     &1.0967E-02,4.3287E+00,8.5840E+00,1.2722E+01,1.6670E+01,2.0258E+01,
     &2.3062E+01,2.3488E+01,3.3340E+01,1.0738E-02,4.9902E+00,9.8948E+00,
     &1.4671E+01,1.9224E+01,2.3370E+01,2.6613E+01,2.7035E+01,3.8446E+01,
     &1.0463E-02,5.6638E+00,1.1230E+01,1.6648E+01,2.1823E+01,2.6530E+01,
     &3.0222E+01,3.0819E+01,4.3644E+01/
      DATA ((KA(JS,JT, 3,16),JS=1,9),JT=1,5) /
     &2.6306E-02,3.2694E+00,6.5125E+00,9.7138E+00,1.2840E+01,1.5828E+01,
     &1.8484E+01,2.0009E+01,2.5680E+01,2.5884E-02,3.9785E+00,7.9277E+00,
     &1.1819E+01,1.5631E+01,1.9201E+01,2.2505E+01,2.4372E+01,3.1262E+01,
     &2.5346E-02,4.7273E+00,9.4145E+00,1.4042E+01,1.8571E+01,2.2894E+01,
     &2.6751E+01,2.8974E+01,3.7022E+01,2.4784E-02,5.5013E+00,1.0958E+01,
     &1.6345E+01,2.1611E+01,2.6651E+01,3.1147E+01,3.3763E+01,4.3221E+01,
     &2.4200E-02,6.2942E+00,1.2535E+01,1.8701E+01,2.4733E+01,3.0502E+01,
     &3.5641E+01,3.8658E+01,4.9465E+01/
      DATA ((KA(JS,JT, 4,16),JS=1,9),JT=1,5) /
     &6.3011E-02,3.3909E+00,6.7686E+00,1.0126E+01,1.3449E+01,1.6701E+01,
     &1.9789E+01,2.2242E+01,2.6898E+01,6.1738E-02,4.1953E+00,8.3750E+00,
     &1.2529E+01,1.6640E+01,2.0669E+01,2.4483E+01,2.7534E+01,3.3280E+01,
     &6.0385E-02,5.0522E+00,1.0085E+01,1.5088E+01,2.0041E+01,2.4891E+01,
     &2.9498E+01,3.3182E+01,4.0082E+01,5.8960E-02,5.9475E+00,1.1873E+01,
     &1.7764E+01,2.3588E+01,2.9299E+01,3.4723E+01,3.9079E+01,4.7175E+01,
     &5.7513E-02,6.8674E+00,1.3704E+01,2.0508E+01,2.7243E+01,3.3832E+01,
     &4.0104E+01,4.5142E+01,5.4486E+01/
      DATA ((KA(JS,JT, 5,16),JS=1,9),JT=1,5) /
     &1.5311E-01,3.4647E+00,6.9218E+00,1.0370E+01,1.3799E+01,1.7194E+01,
     &2.0501E+01,2.3473E+01,2.7599E+01,1.4808E-01,4.3642E+00,8.7211E+00,
     &1.3066E+01,1.7386E+01,2.1656E+01,2.5836E+01,2.9576E+01,3.4772E+01,
     &1.4324E-01,5.3326E+00,1.0656E+01,1.5962E+01,2.1244E+01,2.6472E+01,
     &3.1566E+01,3.6158E+01,4.2487E+01,1.3867E-01,6.3343E+00,1.2694E+01,
     &1.9018E+01,2.5310E+01,3.1544E+01,3.7609E+01,4.3076E+01,5.0619E+01,
     &1.3442E-01,7.4110E+00,1.4809E+01,2.2187E+01,2.9523E+01,3.6788E+01,
     &4.3874E+01,5.0262E+01,5.9046E+01/
      DATA ((KA(JS,JT, 6,16),JS=1,9),JT=1,5) /
     &3.3965E-01,3.4550E+00,6.9058E+00,1.0352E+01,1.3789E+01,1.7206E+01,
     &2.0578E+01,2.3766E+01,2.7578E+01,3.2990E-01,4.4451E+00,8.8565E+00,
     &1.3318E+01,1.7740E+01,2.2139E+01,2.6477E+01,3.0582E+01,3.5479E+01,
     &3.2021E-01,5.5240E+00,1.1042E+01,1.6554E+01,2.2048E+01,2.7511E+01,
     &3.2908E+01,3.8025E+01,4.4095E+01,3.1092E-01,6.6752E+00,1.3341E+01,
     &2.0002E+01,2.6641E+01,3.3245E+01,3.9761E+01,4.5941E+01,5.3282E+01,
     &3.0227E-01,7.8771E+00,1.5743E+01,2.3602E+01,3.1434E+01,3.9236E+01,
     &4.6923E+01,5.4228E+01,6.2865E+01/
      DATA ((KA(JS,JT, 7,16),JS=1,9),JT=1,5) /
     &7.9672E-01,3.3862E+00,6.7703E+00,1.0151E+01,1.3528E+01,1.6895E+01,
     &2.0243E+01,2.3498E+01,2.7056E+01,7.7399E-01,4.4592E+00,8.9171E+00,
     &1.3369E+01,1.7816E+01,2.2252E+01,2.6655E+01,3.0954E+01,3.5514E+01,
     &7.5170E-01,5.6480E+00,1.1293E+01,1.6933E+01,2.2566E+01,2.8186E+01,
     &3.3769E+01,3.9205E+01,4.5131E+01,7.3106E-01,6.9294E+00,1.3857E+01,
     &2.0779E+01,2.7691E+01,3.4583E+01,4.1435E+01,4.8102E+01,5.5380E+01,
     &7.1147E-01,8.2841E+00,1.6563E+01,2.4830E+01,3.3089E+01,4.1334E+01,
     &4.9522E+01,5.7496E+01,6.6175E+01/
      DATA ((KA(JS,JT, 8,16),JS=1,9),JT=1,5) /
     &2.2037E+00,3.2722E+00,6.5418E+00,9.8122E+00,1.3082E+01,1.6344E+01,
     &1.9599E+01,2.2817E+01,2.6163E+01,2.1416E+00,4.4204E+00,8.8385E+00,
     &1.3255E+01,1.7675E+01,2.2079E+01,2.6477E+01,3.0833E+01,3.5348E+01,
     &2.0842E+00,5.7151E+00,1.1428E+01,1.7137E+01,2.2842E+01,2.8548E+01,
     &3.4230E+01,3.9856E+01,4.5681E+01,2.0305E+00,7.1274E+00,1.4255E+01,
     &2.1373E+01,2.8489E+01,3.5598E+01,4.2693E+01,4.9704E+01,5.6975E+01,
     &1.9781E+00,8.6369E+00,1.7269E+01,2.5895E+01,3.4524E+01,4.3140E+01,
     &5.1725E+01,6.0225E+01,6.9043E+01/
      DATA ((KA(JS,JT, 9,16),JS=1,9),JT=1,5) /
     &1.1509E+01,1.0070E+01,8.6316E+00,9.3146E+00,1.2418E+01,1.5525E+01,
     &1.8622E+01,2.1717E+01,2.4834E+01,1.1216E+01,9.8124E+00,8.9628E+00,
     &1.2947E+01,1.7258E+01,2.1566E+01,2.5882E+01,3.0171E+01,3.4512E+01,
     &1.0936E+01,9.5703E+00,1.1414E+01,1.7115E+01,2.2811E+01,2.8515E+01,
     &3.4212E+01,3.9896E+01,4.5613E+01,1.0665E+01,9.3327E+00,1.4497E+01,
     &2.1741E+01,2.8981E+01,3.6218E+01,4.3300E+01,5.0677E+01,5.7950E+01,
     &1.0398E+01,9.5016E+00,1.7820E+01,2.6724E+01,3.5623E+01,4.4518E+01,
     &5.3410E+01,6.2271E+01,7.1226E+01/
      DATA ((KA(JS,JT,10,16),JS=1,9),JT=1,5) /
     &6.7305E+01,5.8689E+01,5.0477E+01,4.2062E+01,3.3650E+01,2.5240E+01,
     &1.8527E+01,2.0871E+01,2.3854E+01,6.5751E+01,5.7530E+01,4.9313E+01,
     &4.1093E+01,3.2876E+01,2.4802E+01,2.5524E+01,2.9774E+01,3.4038E+01,
     &6.4198E+01,5.6172E+01,4.8149E+01,4.0130E+01,3.2100E+01,2.8998E+01,
     &3.4448E+01,4.0179E+01,4.5916E+01,6.2664E+01,5.4833E+01,4.6832E+01,
     &3.9166E+01,3.2607E+01,3.7058E+01,4.4476E+01,5.1875E+01,5.9284E+01,
     &6.1101E+01,5.3467E+01,4.5664E+01,3.8190E+01,3.7365E+01,4.6149E+01,
     &5.5367E+01,6.4570E+01,7.3787E+01/
      DATA ((KA(JS,JT,11,16),JS=1,9),JT=1,5) /
     &1.3576E+02,1.1879E+02,1.0182E+02,8.4849E+01,6.7875E+01,5.0907E+01,
     &3.3938E+01,2.3799E+01,9.0162E+00,1.3280E+02,1.1619E+02,9.9587E+01,
     &8.3000E+01,6.6392E+01,4.9800E+01,3.3906E+01,3.3859E+01,3.7265E+01,
     &1.2969E+02,1.1350E+02,9.7289E+01,8.1076E+01,6.4844E+01,4.8642E+01,
     &3.9970E+01,4.5587E+01,5.2094E+01,1.2653E+02,1.1071E+02,9.4885E+01,
     &7.9077E+01,6.3265E+01,4.8850E+01,5.0310E+01,5.8678E+01,6.7071E+01,
     &1.2325E+02,1.0784E+02,9.2433E+01,7.7029E+01,6.1622E+01,5.4553E+01,
     &6.2511E+01,7.2895E+01,8.3291E+01/
      DATA ((KA(JS,JT,12,16),JS=1,9),JT=1,5) /
     &2.0298E+02,1.7762E+02,1.5224E+02,1.2687E+02,1.0147E+02,7.6126E+01,
     &5.0748E+01,2.9045E+01,9.6314E-05,1.9850E+02,1.7368E+02,1.4888E+02,
     &1.2405E+02,9.9250E+01,7.4435E+01,4.9625E+01,3.8234E+01,2.3705E+01,
     &1.9369E+02,1.6949E+02,1.4528E+02,1.2103E+02,9.6845E+01,7.2640E+01,
     &5.1319E+01,5.1242E+01,5.0529E+01,1.8865E+02,1.6508E+02,1.4148E+02,
     &1.1791E+02,9.4323E+01,7.0746E+01,5.9155E+01,6.5776E+01,7.5148E+01,
     &1.8345E+02,1.6051E+02,1.3757E+02,1.1465E+02,9.1715E+01,7.1673E+01,
     &7.0340E+01,8.1440E+01,9.3046E+01/
      DATA ((KA(JS,JT,13,16),JS=1,9),JT=1,5) /
     &2.4179E+02,2.1156E+02,1.8133E+02,1.5111E+02,1.2089E+02,9.0670E+01,
     &6.0447E+01,3.4181E+01,7.5740E-05,2.3602E+02,2.0653E+02,1.7702E+02,
     &1.4755E+02,1.1802E+02,8.8512E+01,5.9018E+01,4.3484E+01,2.5520E+01,
     &2.2984E+02,2.0112E+02,1.7238E+02,1.4366E+02,1.1493E+02,8.6216E+01,
     &6.0956E+01,5.6909E+01,5.1259E+01,2.2335E+02,1.9547E+02,1.6749E+02,
     &1.3960E+02,1.1169E+02,8.3756E+01,6.8596E+01,7.2790E+01,7.7355E+01,
     &2.1661E+02,1.8954E+02,1.6247E+02,1.3539E+02,1.0832E+02,8.5058E+01,
     &7.9741E+01,8.9915E+01,1.0226E+02/

C     The array KB contains absorption coefs at the 16 chosen g-values 
C     for a range of pressure levels < ~100mb and temperatures. The first 
C     index in the array, JT, which runs from 1 to 5, corresponds to 
C     different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this pressure 
C     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
C     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
C     The second index, JP, runs from 13 to 59 and refers to the JPth
C     reference pressure level (see taumol.f for the value of these
C     pressure levels in mb).  The third index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA (KB(JT,13, 1),JT=1,5) /
     &2.3382E-03,2.8918E-03,3.5228E-03,4.2513E-03,5.0992E-03/
      DATA (KB(JT,14, 1),JT=1,5) /
     &2.0993E-03,2.6087E-03,3.2027E-03,3.9155E-03,4.7075E-03/
      DATA (KB(JT,15, 1),JT=1,5) /
     &1.9068E-03,2.4224E-03,2.9993E-03,3.6366E-03,4.4490E-03/
      DATA (KB(JT,16, 1),JT=1,5) /
     &1.7630E-03,2.2267E-03,2.7514E-03,3.4114E-03,4.1614E-03/
      DATA (KB(JT,17, 1),JT=1,5) /
     &1.6519E-03,2.0886E-03,2.6010E-03,3.2457E-03,3.9066E-03/
      DATA (KB(JT,18, 1),JT=1,5) /
     &1.5561E-03,1.9733E-03,2.5429E-03,3.1325E-03,3.6764E-03/
      DATA (KB(JT,19, 1),JT=1,5) /
     &1.4778E-03,1.9477E-03,2.4734E-03,2.9725E-03,3.4413E-03/
      DATA (KB(JT,20, 1),JT=1,5) /
     &1.3764E-03,1.8206E-03,2.2794E-03,2.6918E-03,3.0807E-03/
      DATA (KB(JT,21, 1),JT=1,5) /
     &1.2547E-03,1.6614E-03,2.0387E-03,2.3912E-03,2.7222E-03/
      DATA (KB(JT,22, 1),JT=1,5) /
     &1.1692E-03,1.5034E-03,1.8117E-03,2.1136E-03,2.3959E-03/
      DATA (KB(JT,23, 1),JT=1,5) /
     &1.0852E-03,1.3578E-03,1.6152E-03,1.8580E-03,2.0983E-03/
      DATA (KB(JT,24, 1),JT=1,5) /
     &9.9196E-04,1.2216E-03,1.4332E-03,1.6336E-03,1.8396E-03/
      DATA (KB(JT,25, 1),JT=1,5) /
     &9.0621E-04,1.0934E-03,1.2579E-03,1.4326E-03,1.5972E-03/
      DATA (KB(JT,26, 1),JT=1,5) /
     &8.1196E-04,9.6544E-04,1.0989E-03,1.2439E-03,1.3772E-03/
      DATA (KB(JT,27, 1),JT=1,5) /
     &7.2402E-04,8.4382E-04,9.5455E-04,1.0692E-03,1.1790E-03/
      DATA (KB(JT,28, 1),JT=1,5) /
     &6.3816E-04,7.3173E-04,8.2333E-04,9.1530E-04,1.0008E-03/
      DATA (KB(JT,29, 1),JT=1,5) /
     &5.5611E-04,6.2561E-04,7.0457E-04,7.7239E-04,8.4074E-04/
      DATA (KB(JT,30, 1),JT=1,5) /
     &4.7758E-04,5.3585E-04,5.9602E-04,6.4848E-04,7.0299E-04/
      DATA (KB(JT,31, 1),JT=1,5) /
     &4.0233E-04,4.5494E-04,5.0095E-04,5.4165E-04,5.8359E-04/
      DATA (KB(JT,32, 1),JT=1,5) /
     &3.4147E-04,3.8327E-04,4.2049E-04,4.5512E-04,4.8721E-04/
      DATA (KB(JT,33, 1),JT=1,5) /
     &2.9210E-04,3.2465E-04,3.5276E-04,3.8153E-04,4.1121E-04/
      DATA (KB(JT,34, 1),JT=1,5) /
     &2.4930E-04,2.7584E-04,2.9920E-04,3.2247E-04,3.4759E-04/
      DATA (KB(JT,35, 1),JT=1,5) /
     &2.1208E-04,2.3419E-04,2.5253E-04,2.7252E-04,2.9279E-04/
      DATA (KB(JT,36, 1),JT=1,5) /
     &1.7811E-04,1.9459E-04,2.1195E-04,2.2908E-04,2.4619E-04/
      DATA (KB(JT,37, 1),JT=1,5) /
     &1.4252E-04,1.5802E-04,1.7124E-04,1.8557E-04,1.9967E-04/
      DATA (KB(JT,38, 1),JT=1,5) /
     &1.1316E-04,1.2691E-04,1.3875E-04,1.4940E-04,1.6149E-04/
      DATA (KB(JT,39, 1),JT=1,5) /
     &8.9734E-05,1.0111E-04,1.1110E-04,1.2104E-04,1.3018E-04/
      DATA (KB(JT,40, 1),JT=1,5) /
     &6.9862E-05,7.9338E-05,8.7351E-05,9.5361E-05,1.0350E-04/
      DATA (KB(JT,41, 1),JT=1,5) /
     &5.3903E-05,6.1377E-05,6.8596E-05,7.4910E-05,8.1525E-05/
      DATA (KB(JT,42, 1),JT=1,5) /
     &4.1353E-05,4.7327E-05,5.3464E-05,5.8873E-05,6.3813E-05/
      DATA (KB(JT,43, 1),JT=1,5) /
     &3.1177E-05,3.6021E-05,4.0748E-05,4.5236E-05,4.9388E-05/
      DATA (KB(JT,44, 1),JT=1,5) /
     &2.3155E-05,2.7105E-05,3.0750E-05,3.4487E-05,3.7902E-05/
      DATA (KB(JT,45, 1),JT=1,5) /
     &1.6939E-05,2.0019E-05,2.3152E-05,2.6034E-05,2.8825E-05/
      DATA (KB(JT,46, 1),JT=1,5) /
     &1.2188E-05,1.4774E-05,1.7220E-05,1.9590E-05,2.1820E-05/
      DATA (KB(JT,47, 1),JT=1,5) /
     &8.5598E-06,1.0765E-05,1.2719E-05,1.4628E-05,1.6428E-05/
      DATA (KB(JT,48, 1),JT=1,5) /
     &5.9262E-06,7.6349E-06,9.2601E-06,1.0811E-05,1.2306E-05/
      DATA (KB(JT,49, 1),JT=1,5) /
     &3.9332E-06,5.2612E-06,6.6345E-06,7.8390E-06,9.0160E-06/
      DATA (KB(JT,50, 1),JT=1,5) /
     &2.6915E-06,3.7062E-06,4.7528E-06,5.7591E-06,6.6828E-06/
      DATA (KB(JT,51, 1),JT=1,5) /
     &1.9031E-06,2.5633E-06,3.3817E-06,4.2212E-06,4.9973E-06/
      DATA (KB(JT,52, 1),JT=1,5) /
     &1.3022E-06,1.7876E-06,2.4129E-06,3.0582E-06,3.6770E-06/
      DATA (KB(JT,53, 1),JT=1,5) /
     &8.8514E-07,1.2531E-06,1.6651E-06,2.1701E-06,2.6821E-06/
      DATA (KB(JT,54, 1),JT=1,5) /
     &6.3174E-07,9.0490E-07,1.2164E-06,1.6231E-06,2.0201E-06/
      DATA (KB(JT,55, 1),JT=1,5) /
     &4.6092E-07,6.6386E-07,9.1477E-07,1.2278E-06,1.5504E-06/
      DATA (KB(JT,56, 1),JT=1,5) /
     &3.3312E-07,4.8579E-07,6.8774E-07,9.1495E-07,1.1856E-06/
      DATA (KB(JT,57, 1),JT=1,5) /
     &2.4004E-07,3.5567E-07,5.1418E-07,6.8280E-07,9.0960E-07/
      DATA (KB(JT,58, 1),JT=1,5) /
     &1.7424E-07,2.6290E-07,3.8304E-07,5.1880E-07,6.9948E-07/
      DATA (KB(JT,59, 1),JT=1,5) /
     &1.4545E-07,2.2249E-07,3.3056E-07,4.4487E-07,6.0780E-07/
      DATA (KB(JT,13, 2),JT=1,5) /
     &1.0289E-02,1.3009E-02,1.5474E-02,1.7839E-02,2.0097E-02/
      DATA (KB(JT,14, 2),JT=1,5) /
     &9.5725E-03,1.1818E-02,1.3904E-02,1.5918E-02,1.7958E-02/
      DATA (KB(JT,15, 2),JT=1,5) /
     &8.9675E-03,1.0842E-02,1.2642E-02,1.4399E-02,1.6048E-02/
      DATA (KB(JT,16, 2),JT=1,5) /
     &8.1677E-03,9.7202E-03,1.1280E-02,1.2681E-02,1.4168E-02/
      DATA (KB(JT,17, 2),JT=1,5) /
     &7.4338E-03,8.8205E-03,1.0076E-02,1.1262E-02,1.2428E-02/
      DATA (KB(JT,18, 2),JT=1,5) /
     &6.8634E-03,8.0133E-03,8.9513E-03,9.9366E-03,1.1014E-02/
      DATA (KB(JT,19, 2),JT=1,5) /
     &6.3552E-03,7.2047E-03,8.0129E-03,8.8966E-03,9.8381E-03/
      DATA (KB(JT,20, 2),JT=1,5) /
     &5.6397E-03,6.2755E-03,6.9887E-03,7.7846E-03,8.5391E-03/
      DATA (KB(JT,21, 2),JT=1,5) /
     &4.8925E-03,5.4088E-03,6.0399E-03,6.7004E-03,7.3289E-03/
      DATA (KB(JT,22, 2),JT=1,5) /
     &4.2004E-03,4.6864E-03,5.2247E-03,5.7527E-03,6.2510E-03/
      DATA (KB(JT,23, 2),JT=1,5) /
     &3.5982E-03,4.0432E-03,4.4892E-03,4.9192E-03,5.3260E-03/
      DATA (KB(JT,24, 2),JT=1,5) /
     &3.1341E-03,3.4942E-03,3.8506E-03,4.1837E-03,4.5083E-03/
      DATA (KB(JT,25, 2),JT=1,5) /
     &2.7078E-03,2.9853E-03,3.2644E-03,3.5527E-03,3.8354E-03/
      DATA (KB(JT,26, 2),JT=1,5) /
     &2.3166E-03,2.5349E-03,2.7760E-03,3.0099E-03,3.2441E-03/
      DATA (KB(JT,27, 2),JT=1,5) /
     &1.9581E-03,2.1476E-03,2.3442E-03,2.5333E-03,2.7284E-03/
      DATA (KB(JT,28, 2),JT=1,5) /
     &1.6566E-03,1.8064E-03,1.9708E-03,2.1221E-03,2.2915E-03/
      DATA (KB(JT,29, 2),JT=1,5) /
     &1.3865E-03,1.5225E-03,1.6510E-03,1.7817E-03,1.9308E-03/
      DATA (KB(JT,30, 2),JT=1,5) /
     &1.1671E-03,1.2777E-03,1.3825E-03,1.4960E-03,1.6203E-03/
      DATA (KB(JT,31, 2),JT=1,5) /
     &9.8586E-04,1.0724E-03,1.1604E-03,1.2563E-03,1.3588E-03/
      DATA (KB(JT,32, 2),JT=1,5) /
     &8.3378E-04,9.0396E-04,9.7429E-04,1.0568E-03,1.1470E-03/
      DATA (KB(JT,33, 2),JT=1,5) /
     &7.0369E-04,7.5618E-04,8.2196E-04,8.9196E-04,9.6493E-04/
      DATA (KB(JT,34, 2),JT=1,5) /
     &5.9334E-04,6.3847E-04,6.9888E-04,7.5675E-04,8.1741E-04/
      DATA (KB(JT,35, 2),JT=1,5) /
     &4.9419E-04,5.3430E-04,5.8625E-04,6.3690E-04,6.8685E-04/
      DATA (KB(JT,36, 2),JT=1,5) /
     &4.1196E-04,4.5151E-04,4.9203E-04,5.3162E-04,5.7140E-04/
      DATA (KB(JT,37, 2),JT=1,5) /
     &3.3813E-04,3.6860E-04,4.0277E-04,4.3459E-04,4.6722E-04/
      DATA (KB(JT,38, 2),JT=1,5) /
     &2.7817E-04,3.0151E-04,3.2943E-04,3.5593E-04,3.8227E-04/
      DATA (KB(JT,39, 2),JT=1,5) /
     &2.2867E-04,2.4762E-04,2.6968E-04,2.9008E-04,3.1209E-04/
      DATA (KB(JT,40, 2),JT=1,5) /
     &1.8342E-04,1.9773E-04,2.1631E-04,2.3254E-04,2.4976E-04/
      DATA (KB(JT,41, 2),JT=1,5) /
     &1.4676E-04,1.5810E-04,1.7216E-04,1.8594E-04,1.9960E-04/
      DATA (KB(JT,42, 2),JT=1,5) /
     &1.1746E-04,1.2665E-04,1.3672E-04,1.4836E-04,1.5881E-04/
      DATA (KB(JT,43, 2),JT=1,5) /
     &9.3086E-05,1.0013E-04,1.0780E-04,1.1711E-04,1.2583E-04/
      DATA (KB(JT,44, 2),JT=1,5) /
     &7.3232E-05,7.8805E-05,8.4882E-05,9.2011E-05,9.9424E-05/
      DATA (KB(JT,45, 2),JT=1,5) /
     &5.7257E-05,6.2283E-05,6.6827E-05,7.2104E-05,7.8039E-05/
      DATA (KB(JT,46, 2),JT=1,5) /
     &4.5024E-05,4.8935E-05,5.2600E-05,5.6600E-05,6.1280E-05/
      DATA (KB(JT,47, 2),JT=1,5) /
     &3.5357E-05,3.8098E-05,4.1339E-05,4.4405E-05,4.7940E-05/
      DATA (KB(JT,48, 2),JT=1,5) /
     &2.7815E-05,2.9967E-05,3.2437E-05,3.4873E-05,3.7402E-05/
      DATA (KB(JT,49, 2),JT=1,5) /
     &2.1939E-05,2.3492E-05,2.5305E-05,2.7332E-05,2.9323E-05/
      DATA (KB(JT,50, 2),JT=1,5) /
     &1.7237E-05,1.8528E-05,1.9953E-05,2.1525E-05,2.3159E-05/
      DATA (KB(JT,51, 2),JT=1,5) /
     &1.3436E-05,1.4671E-05,1.5802E-05,1.6957E-05,1.8296E-05/
      DATA (KB(JT,52, 2),JT=1,5) /
     &1.0450E-05,1.1538E-05,1.2438E-05,1.3421E-05,1.4433E-05/
      DATA (KB(JT,53, 2),JT=1,5) /
     &8.1106E-06,9.0282E-06,9.8120E-06,1.0593E-05,1.1339E-05/
      DATA (KB(JT,54, 2),JT=1,5) /
     &6.3166E-06,7.0785E-06,7.7924E-06,8.4016E-06,8.9926E-06/
      DATA (KB(JT,55, 2),JT=1,5) /
     &4.9361E-06,5.5830E-06,6.1858E-06,6.7021E-06,7.1744E-06/
      DATA (KB(JT,56, 2),JT=1,5) /
     &3.8472E-06,4.3596E-06,4.8727E-06,5.3362E-06,5.7261E-06/
      DATA (KB(JT,57, 2),JT=1,5) /
     &2.9833E-06,3.4045E-06,3.8019E-06,4.2184E-06,4.5533E-06/
      DATA (KB(JT,58, 2),JT=1,5) /
     &2.2932E-06,2.6742E-06,3.0024E-06,3.3291E-06,3.6047E-06/
      DATA (KB(JT,59, 2),JT=1,5) /
     &1.8323E-06,2.1714E-06,2.4292E-06,2.6999E-06,2.9218E-06/
      DATA (KB(JT,13, 3),JT=1,5) /
     &3.0891E-02,3.3118E-02,3.6308E-02,3.9588E-02,4.3089E-02/
      DATA (KB(JT,14, 3),JT=1,5) /
     &2.6329E-02,2.8653E-02,3.1325E-02,3.4211E-02,3.7000E-02/
      DATA (KB(JT,15, 3),JT=1,5) /
     &2.2620E-02,2.4702E-02,2.7101E-02,2.9342E-02,3.1645E-02/
      DATA (KB(JT,16, 3),JT=1,5) /
     &1.9521E-02,2.1493E-02,2.3534E-02,2.5338E-02,2.7120E-02/
      DATA (KB(JT,17, 3),JT=1,5) /
     &1.7199E-02,1.8861E-02,2.0377E-02,2.1918E-02,2.3545E-02/
      DATA (KB(JT,18, 3),JT=1,5) /
     &1.5181E-02,1.6445E-02,1.7796E-02,1.9171E-02,2.0759E-02/
      DATA (KB(JT,19, 3),JT=1,5) /
     &1.3401E-02,1.4529E-02,1.5713E-02,1.7031E-02,1.8531E-02/
      DATA (KB(JT,20, 3),JT=1,5) /
     &1.1566E-02,1.2595E-02,1.3616E-02,1.4797E-02,1.6195E-02/
      DATA (KB(JT,21, 3),JT=1,5) /
     &9.9790E-03,1.0856E-02,1.1739E-02,1.2840E-02,1.4039E-02/
      DATA (KB(JT,22, 3),JT=1,5) /
     &8.5571E-03,9.3189E-03,1.0148E-02,1.1149E-02,1.2271E-02/
      DATA (KB(JT,23, 3),JT=1,5) /
     &7.3578E-03,7.9960E-03,8.8066E-03,9.6774E-03,1.0719E-02/
      DATA (KB(JT,24, 3),JT=1,5) /
     &6.2710E-03,6.8510E-03,7.5829E-03,8.4285E-03,9.3410E-03/
      DATA (KB(JT,25, 3),JT=1,5) /
     &5.3189E-03,5.9223E-03,6.5735E-03,7.3163E-03,8.1167E-03/
      DATA (KB(JT,26, 3),JT=1,5) /
     &4.5763E-03,5.1227E-03,5.7207E-03,6.3561E-03,7.0425E-03/
      DATA (KB(JT,27, 3),JT=1,5) /
     &3.9329E-03,4.4226E-03,4.9281E-03,5.4554E-03,6.0474E-03/
      DATA (KB(JT,28, 3),JT=1,5) /
     &3.3818E-03,3.7926E-03,4.2066E-03,4.6531E-03,5.1585E-03/
      DATA (KB(JT,29, 3),JT=1,5) /
     &2.9035E-03,3.2271E-03,3.5855E-03,3.9705E-03,4.3799E-03/
      DATA (KB(JT,30, 3),JT=1,5) /
     &2.4837E-03,2.7647E-03,3.0488E-03,3.3703E-03,3.7029E-03/
      DATA (KB(JT,31, 3),JT=1,5) /
     &2.0927E-03,2.3283E-03,2.5712E-03,2.8545E-03,3.1157E-03/
      DATA (KB(JT,32, 3),JT=1,5) /
     &1.7660E-03,1.9568E-03,2.1676E-03,2.3923E-03,2.6159E-03/
      DATA (KB(JT,33, 3),JT=1,5) /
     &1.4871E-03,1.6499E-03,1.8213E-03,2.0066E-03,2.1979E-03/
      DATA (KB(JT,34, 3),JT=1,5) /
     &1.2670E-03,1.4012E-03,1.5485E-03,1.7073E-03,1.8735E-03/
      DATA (KB(JT,35, 3),JT=1,5) /
     &1.0672E-03,1.1813E-03,1.3131E-03,1.4449E-03,1.5924E-03/
      DATA (KB(JT,36, 3),JT=1,5) /
     &8.9185E-04,9.8733E-04,1.0955E-03,1.2168E-03,1.3441E-03/
      DATA (KB(JT,37, 3),JT=1,5) /
     &7.2820E-04,8.0537E-04,8.9528E-04,9.9910E-04,1.1050E-03/
      DATA (KB(JT,38, 3),JT=1,5) /
     &5.9186E-04,6.5591E-04,7.2922E-04,8.1759E-04,9.0441E-04/
      DATA (KB(JT,39, 3),JT=1,5) /
     &4.8327E-04,5.3477E-04,5.9527E-04,6.6884E-04,7.4026E-04/
      DATA (KB(JT,40, 3),JT=1,5) /
     &3.8671E-04,4.2869E-04,4.7628E-04,5.3686E-04,5.9502E-04/
      DATA (KB(JT,41, 3),JT=1,5) /
     &3.0862E-04,3.4166E-04,3.8000E-04,4.2745E-04,4.7580E-04/
      DATA (KB(JT,42, 3),JT=1,5) /
     &2.4577E-04,2.7168E-04,3.0221E-04,3.3942E-04,3.8025E-04/
      DATA (KB(JT,43, 3),JT=1,5) /
     &1.9416E-04,2.1479E-04,2.3878E-04,2.6702E-04,3.0069E-04/
      DATA (KB(JT,44, 3),JT=1,5) /
     &1.5374E-04,1.6929E-04,1.8776E-04,2.0950E-04,2.3556E-04/
      DATA (KB(JT,45, 3),JT=1,5) /
     &1.2163E-04,1.3301E-04,1.4695E-04,1.6433E-04,1.8435E-04/
      DATA (KB(JT,46, 3),JT=1,5) /
     &9.4928E-05,1.0426E-04,1.1546E-04,1.2841E-04,1.4410E-04/
      DATA (KB(JT,47, 3),JT=1,5) /
     &7.3995E-05,8.2130E-05,9.0212E-05,1.0006E-04,1.1186E-04/
      DATA (KB(JT,48, 3),JT=1,5) /
     &5.7893E-05,6.3962E-05,7.0352E-05,7.8032E-05,8.7072E-05/
      DATA (KB(JT,49, 3),JT=1,5) /
     &4.5051E-05,4.9908E-05,5.5306E-05,6.0837E-05,6.7927E-05/
      DATA (KB(JT,50, 3),JT=1,5) /
     &3.5303E-05,3.9326E-05,4.3324E-05,4.7812E-05,5.3164E-05/
      DATA (KB(JT,51, 3),JT=1,5) /
     &2.7771E-05,3.0856E-05,3.4054E-05,3.7804E-05,4.1758E-05/
      DATA (KB(JT,52, 3),JT=1,5) /
     &2.1938E-05,2.4227E-05,2.6919E-05,2.9733E-05,3.2981E-05/
      DATA (KB(JT,53, 3),JT=1,5) /
     &1.7187E-05,1.9050E-05,2.1224E-05,2.3374E-05,2.5986E-05/
      DATA (KB(JT,54, 3),JT=1,5) /
     &1.3551E-05,1.5084E-05,1.6671E-05,1.8493E-05,2.0639E-05/
      DATA (KB(JT,55, 3),JT=1,5) /
     &1.0736E-05,1.1998E-05,1.3230E-05,1.4714E-05,1.6387E-05/
      DATA (KB(JT,56, 3),JT=1,5) /
     &8.4780E-06,9.5613E-06,1.0535E-05,1.1722E-05,1.2981E-05/
      DATA (KB(JT,57, 3),JT=1,5) /
     &6.6892E-06,7.5486E-06,8.3874E-06,9.3040E-06,1.0324E-05/
      DATA (KB(JT,58, 3),JT=1,5) /
     &5.3282E-06,5.9530E-06,6.6841E-06,7.4078E-06,8.2298E-06/
      DATA (KB(JT,59, 3),JT=1,5) /
     &4.3459E-06,4.8321E-06,5.4567E-06,6.0369E-06,6.7261E-06/
      DATA (KB(JT,13, 4),JT=1,5) /
     &6.7009E-02,7.0746E-02,7.4150E-02,7.7569E-02,8.1680E-02/
      DATA (KB(JT,14, 4),JT=1,5) /
     &5.5943E-02,5.8697E-02,6.1678E-02,6.4914E-02,6.9379E-02/
      DATA (KB(JT,15, 4),JT=1,5) /
     &4.6843E-02,4.9217E-02,5.1833E-02,5.5783E-02,5.9767E-02/
      DATA (KB(JT,16, 4),JT=1,5) /
     &3.9239E-02,4.1262E-02,4.4032E-02,4.7642E-02,5.1925E-02/
      DATA (KB(JT,17, 4),JT=1,5) /
     &3.3107E-02,3.5295E-02,3.8541E-02,4.2220E-02,4.6357E-02/
      DATA (KB(JT,18, 4),JT=1,5) /
     &2.8797E-02,3.1620E-02,3.4631E-02,3.8034E-02,4.1725E-02/
      DATA (KB(JT,19, 4),JT=1,5) /
     &2.5628E-02,2.8281E-02,3.1139E-02,3.4358E-02,3.7925E-02/
      DATA (KB(JT,20, 4),JT=1,5) /
     &2.2579E-02,2.4906E-02,2.7554E-02,3.0345E-02,3.3488E-02/
      DATA (KB(JT,21, 4),JT=1,5) /
     &1.9528E-02,2.1738E-02,2.4107E-02,2.6707E-02,2.9475E-02/
      DATA (KB(JT,22, 4),JT=1,5) /
     &1.7101E-02,1.8986E-02,2.1039E-02,2.3296E-02,2.5855E-02/
      DATA (KB(JT,23, 4),JT=1,5) /
     &1.4866E-02,1.6502E-02,1.8337E-02,2.0414E-02,2.2548E-02/
      DATA (KB(JT,24, 4),JT=1,5) /
     &1.2821E-02,1.4288E-02,1.5941E-02,1.7747E-02,1.9679E-02/
      DATA (KB(JT,25, 4),JT=1,5) /
     &1.1061E-02,1.2369E-02,1.3872E-02,1.5379E-02,1.7059E-02/
      DATA (KB(JT,26, 4),JT=1,5) /
     &9.5354E-03,1.0723E-02,1.2012E-02,1.3430E-02,1.4839E-02/
      DATA (KB(JT,27, 4),JT=1,5) /
     &8.1975E-03,9.2673E-03,1.0387E-02,1.1650E-02,1.2827E-02/
      DATA (KB(JT,28, 4),JT=1,5) /
     &7.0231E-03,7.9702E-03,8.9828E-03,1.0032E-02,1.1053E-02/
      DATA (KB(JT,29, 4),JT=1,5) /
     &6.0200E-03,6.8421E-03,7.7670E-03,8.6094E-03,9.5249E-03/
      DATA (KB(JT,30, 4),JT=1,5) /
     &5.1558E-03,5.8823E-03,6.6735E-03,7.4143E-03,8.2222E-03/
      DATA (KB(JT,31, 4),JT=1,5) /
     &4.4508E-03,5.1031E-03,5.7395E-03,6.3990E-03,7.0930E-03/
      DATA (KB(JT,32, 4),JT=1,5) /
     &3.8687E-03,4.4226E-03,4.9634E-03,5.5499E-03,6.1447E-03/
      DATA (KB(JT,33, 4),JT=1,5) /
     &3.3860E-03,3.8414E-03,4.3170E-03,4.8129E-03,5.3113E-03/
      DATA (KB(JT,34, 4),JT=1,5) /
     &2.9667E-03,3.3572E-03,3.7642E-03,4.1882E-03,4.5973E-03/
      DATA (KB(JT,35, 4),JT=1,5) /
     &2.5854E-03,2.9160E-03,3.2542E-03,3.6120E-03,3.9574E-03/
      DATA (KB(JT,36, 4),JT=1,5) /
     &2.2132E-03,2.5004E-03,2.7859E-03,3.0722E-03,3.3673E-03/
      DATA (KB(JT,37, 4),JT=1,5) /
     &1.8397E-03,2.0798E-03,2.3185E-03,2.5525E-03,2.8046E-03/
      DATA (KB(JT,38, 4),JT=1,5) /
     &1.5241E-03,1.7240E-03,1.9250E-03,2.1190E-03,2.3334E-03/
      DATA (KB(JT,39, 4),JT=1,5) /
     &1.2578E-03,1.4258E-03,1.5974E-03,1.7602E-03,1.9414E-03/
      DATA (KB(JT,40, 4),JT=1,5) /
     &1.0136E-03,1.1511E-03,1.2925E-03,1.4274E-03,1.5799E-03/
      DATA (KB(JT,41, 4),JT=1,5) /
     &8.1255E-04,9.2485E-04,1.0421E-03,1.1560E-03,1.2823E-03/
      DATA (KB(JT,42, 4),JT=1,5) /
     &6.5076E-04,7.4076E-04,8.3891E-04,9.3536E-04,1.0398E-03/
      DATA (KB(JT,43, 4),JT=1,5) /
     &5.1457E-04,5.8675E-04,6.6625E-04,7.5025E-04,8.3332E-04/
      DATA (KB(JT,44, 4),JT=1,5) /
     &4.0130E-04,4.6112E-04,5.2500E-04,5.9353E-04,6.6396E-04/
      DATA (KB(JT,45, 4),JT=1,5) /
     &3.1174E-04,3.6176E-04,4.1281E-04,4.6943E-04,5.2749E-04/
      DATA (KB(JT,46, 4),JT=1,5) /
     &2.4198E-04,2.8347E-04,3.2327E-04,3.6940E-04,4.1847E-04/
      DATA (KB(JT,47, 4),JT=1,5) /
     &1.8653E-04,2.1946E-04,2.5297E-04,2.9033E-04,3.3117E-04/
      DATA (KB(JT,48, 4),JT=1,5) /
     &1.4273E-04,1.6990E-04,1.9780E-04,2.2703E-04,2.6076E-04/
      DATA (KB(JT,49, 4),JT=1,5) /
     &1.1020E-04,1.3076E-04,1.5369E-04,1.7736E-04,2.0453E-04/
      DATA (KB(JT,50, 4),JT=1,5) /
     &8.5840E-05,1.0098E-04,1.2003E-04,1.3937E-04,1.6133E-04/
      DATA (KB(JT,51, 4),JT=1,5) /
     &6.7375E-05,7.8667E-05,9.3691E-05,1.0967E-04,1.2714E-04/
      DATA (KB(JT,52, 4),JT=1,5) /
     &5.2333E-05,6.1321E-05,7.2765E-05,8.6008E-05,9.9915E-05/
      DATA (KB(JT,53, 4),JT=1,5) /
     &4.0658E-05,4.7664E-05,5.6514E-05,6.7300E-05,7.8701E-05/
      DATA (KB(JT,54, 4),JT=1,5) /
     &3.1857E-05,3.7478E-05,4.4306E-05,5.3025E-05,6.2299E-05/
      DATA (KB(JT,55, 4),JT=1,5) /
     &2.4955E-05,2.9435E-05,3.4823E-05,4.1578E-05,4.9419E-05/
      DATA (KB(JT,56, 4),JT=1,5) /
     &1.9655E-05,2.3009E-05,2.7169E-05,3.2570E-05,3.9005E-05/
      DATA (KB(JT,57, 4),JT=1,5) /
     &1.5476E-05,1.8100E-05,2.1340E-05,2.5521E-05,3.0667E-05/
      DATA (KB(JT,58, 4),JT=1,5) /
     &1.2154E-05,1.4292E-05,1.6827E-05,2.0050E-05,2.4167E-05/
      DATA (KB(JT,59, 4),JT=1,5) /
     &9.8901E-06,1.1647E-05,1.3760E-05,1.6454E-05,1.9831E-05/
      DATA (KB(JT,13, 5),JT=1,5) /
     &1.3634E-01,1.4252E-01,1.5001E-01,1.6028E-01,1.7134E-01/
      DATA (KB(JT,14, 5),JT=1,5) /
     &1.1274E-01,1.1839E-01,1.2582E-01,1.3453E-01,1.4378E-01/
      DATA (KB(JT,15, 5),JT=1,5) /
     &9.3550E-02,9.9682E-02,1.0681E-01,1.1432E-01,1.2335E-01/
      DATA (KB(JT,16, 5),JT=1,5) /
     &7.9704E-02,8.5926E-02,9.2006E-02,9.9216E-02,1.0669E-01/
      DATA (KB(JT,17, 5),JT=1,5) /
     &6.9562E-02,7.4399E-02,8.0031E-02,8.6090E-02,9.3210E-02/
      DATA (KB(JT,18, 5),JT=1,5) /
     &6.1028E-02,6.5373E-02,7.1097E-02,7.7143E-02,8.4153E-02/
      DATA (KB(JT,19, 5),JT=1,5) /
     &5.4138E-02,5.9145E-02,6.4366E-02,7.0461E-02,7.6822E-02/
      DATA (KB(JT,20, 5),JT=1,5) /
     &4.7698E-02,5.2419E-02,5.7657E-02,6.3398E-02,6.9523E-02/
      DATA (KB(JT,21, 5),JT=1,5) /
     &4.2126E-02,4.6323E-02,5.1164E-02,5.6007E-02,6.1597E-02/
      DATA (KB(JT,22, 5),JT=1,5) /
     &3.6873E-02,4.0763E-02,4.4958E-02,4.9556E-02,5.4204E-02/
      DATA (KB(JT,23, 5),JT=1,5) /
     &3.2201E-02,3.5761E-02,3.9530E-02,4.3670E-02,4.7920E-02/
      DATA (KB(JT,24, 5),JT=1,5) /
     &2.8239E-02,3.1305E-02,3.4844E-02,3.8415E-02,4.2157E-02/
      DATA (KB(JT,25, 5),JT=1,5) /
     &2.4669E-02,2.7511E-02,3.0568E-02,3.3769E-02,3.6890E-02/
      DATA (KB(JT,26, 5),JT=1,5) /
     &2.1582E-02,2.4173E-02,2.6811E-02,2.9496E-02,3.2330E-02/
      DATA (KB(JT,27, 5),JT=1,5) /
     &1.8849E-02,2.1094E-02,2.3446E-02,2.5755E-02,2.8374E-02/
      DATA (KB(JT,28, 5),JT=1,5) /
     &1.6379E-02,1.8330E-02,2.0367E-02,2.2542E-02,2.4931E-02/
      DATA (KB(JT,29, 5),JT=1,5) /
     &1.4280E-02,1.5993E-02,1.7723E-02,1.9736E-02,2.1895E-02/
      DATA (KB(JT,30, 5),JT=1,5) /
     &1.2451E-02,1.3902E-02,1.5477E-02,1.7322E-02,1.9234E-02/
      DATA (KB(JT,31, 5),JT=1,5) /
     &1.0840E-02,1.2122E-02,1.3593E-02,1.5159E-02,1.6921E-02/
      DATA (KB(JT,32, 5),JT=1,5) /
     &9.4753E-03,1.0651E-02,1.1992E-02,1.3397E-02,1.4887E-02/
      DATA (KB(JT,33, 5),JT=1,5) /
     &8.3358E-03,9.4249E-03,1.0592E-02,1.1871E-02,1.3208E-02/
      DATA (KB(JT,34, 5),JT=1,5) /
     &7.3799E-03,8.3765E-03,9.4456E-03,1.0582E-02,1.1863E-02/
      DATA (KB(JT,35, 5),JT=1,5) /
     &6.4631E-03,7.3628E-03,8.3364E-03,9.3419E-03,1.0526E-02/
      DATA (KB(JT,36, 5),JT=1,5) /
     &5.5926E-03,6.3888E-03,7.2585E-03,8.2192E-03,9.2462E-03/
      DATA (KB(JT,37, 5),JT=1,5) /
     &4.7015E-03,5.3951E-03,6.1680E-03,7.0229E-03,7.9329E-03/
      DATA (KB(JT,38, 5),JT=1,5) /
     &3.9517E-03,4.5644E-03,5.2429E-03,6.0141E-03,6.8184E-03/
      DATA (KB(JT,39, 5),JT=1,5) /
     &3.3266E-03,3.8629E-03,4.4575E-03,5.1473E-03,5.8646E-03/
      DATA (KB(JT,40, 5),JT=1,5) /
     &2.7281E-03,3.1818E-03,3.6932E-03,4.2742E-03,4.8976E-03/
      DATA (KB(JT,41, 5),JT=1,5) /
     &2.2270E-03,2.6113E-03,3.0386E-03,3.5308E-03,4.0601E-03/
      DATA (KB(JT,42, 5),JT=1,5) /
     &1.8093E-03,2.1403E-03,2.4947E-03,2.9136E-03,3.3566E-03/
      DATA (KB(JT,43, 5),JT=1,5) /
     &1.4510E-03,1.7247E-03,2.0294E-03,2.3716E-03,2.7407E-03/
      DATA (KB(JT,44, 5),JT=1,5) /
     &1.1565E-03,1.3809E-03,1.6356E-03,1.9170E-03,2.2199E-03/
      DATA (KB(JT,45, 5),JT=1,5) /
     &9.2074E-04,1.1011E-03,1.3110E-03,1.5432E-03,1.7974E-03/
      DATA (KB(JT,46, 5),JT=1,5) /
     &7.2799E-04,8.7147E-04,1.0468E-03,1.2375E-03,1.4475E-03/
      DATA (KB(JT,47, 5),JT=1,5) /
     &5.6825E-04,6.8576E-04,8.2827E-04,9.8300E-04,1.1595E-03/
      DATA (KB(JT,48, 5),JT=1,5) /
     &4.4362E-04,5.3785E-04,6.5132E-04,7.7947E-04,9.2729E-04/
      DATA (KB(JT,49, 5),JT=1,5) /
     &3.4360E-04,4.2004E-04,5.1060E-04,6.1673E-04,7.3913E-04/
      DATA (KB(JT,50, 5),JT=1,5) /
     &2.6639E-04,3.2974E-04,4.0310E-04,4.8991E-04,5.9182E-04/
      DATA (KB(JT,51, 5),JT=1,5) /
     &2.0705E-04,2.5803E-04,3.1790E-04,3.8886E-04,4.7401E-04/
      DATA (KB(JT,52, 5),JT=1,5) /
     &1.6104E-04,2.0156E-04,2.4998E-04,3.0713E-04,3.7759E-04/
      DATA (KB(JT,53, 5),JT=1,5) /
     &1.2422E-04,1.5670E-04,1.9587E-04,2.4211E-04,2.9925E-04/
      DATA (KB(JT,54, 5),JT=1,5) /
     &9.6443E-05,1.2239E-04,1.5459E-04,1.9203E-04,2.3866E-04/
      DATA (KB(JT,55, 5),JT=1,5) /
     &7.5345E-05,9.6163E-05,1.2185E-04,1.5278E-04,1.9092E-04/
      DATA (KB(JT,56, 5),JT=1,5) /
     &5.8479E-05,7.5388E-05,9.6163E-05,1.2109E-04,1.5224E-04/
      DATA (KB(JT,57, 5),JT=1,5) /
     &4.5173E-05,5.8728E-05,7.5432E-05,9.5735E-05,1.2084E-04/
      DATA (KB(JT,58, 5),JT=1,5) /
     &3.5110E-05,4.5659E-05,5.9108E-05,7.5684E-05,9.5780E-05/
      DATA (KB(JT,59, 5),JT=1,5) /
     &2.8669E-05,3.7452E-05,4.8577E-05,6.2553E-05,7.9913E-05/
      DATA (KB(JT,13, 6),JT=1,5) /
     &3.1943E-01,3.3627E-01,3.5152E-01,3.6856E-01,3.8489E-01/
      DATA (KB(JT,14, 6),JT=1,5) /
     &2.6955E-01,2.8315E-01,2.9631E-01,3.1035E-01,3.2480E-01/
      DATA (KB(JT,15, 6),JT=1,5) /
     &2.2744E-01,2.3792E-01,2.4935E-01,2.6127E-01,2.7359E-01/
      DATA (KB(JT,16, 6),JT=1,5) /
     &1.9190E-01,2.0128E-01,2.1209E-01,2.2354E-01,2.3634E-01/
      DATA (KB(JT,17, 6),JT=1,5) /
     &1.6550E-01,1.7572E-01,1.8575E-01,1.9639E-01,2.0864E-01/
      DATA (KB(JT,18, 6),JT=1,5) /
     &1.4664E-01,1.5533E-01,1.6464E-01,1.7496E-01,1.8532E-01/
      DATA (KB(JT,19, 6),JT=1,5) /
     &1.3086E-01,1.3857E-01,1.4754E-01,1.5676E-01,1.6804E-01/
      DATA (KB(JT,20, 6),JT=1,5) /
     &1.1476E-01,1.2256E-01,1.3048E-01,1.3999E-01,1.5052E-01/
      DATA (KB(JT,21, 6),JT=1,5) /
     &1.0042E-01,1.0755E-01,1.1552E-01,1.2457E-01,1.3541E-01/
      DATA (KB(JT,22, 6),JT=1,5) /
     &8.7811E-02,9.4376E-02,1.0240E-01,1.1139E-01,1.2190E-01/
      DATA (KB(JT,23, 6),JT=1,5) /
     &7.6746E-02,8.3440E-02,9.0958E-02,9.9436E-02,1.0837E-01/
      DATA (KB(JT,24, 6),JT=1,5) /
     &6.7020E-02,7.3597E-02,8.0186E-02,8.7655E-02,9.5847E-02/
      DATA (KB(JT,25, 6),JT=1,5) /
     &5.8852E-02,6.4342E-02,7.0651E-02,7.7553E-02,8.5595E-02/
      DATA (KB(JT,26, 6),JT=1,5) /
     &5.1501E-02,5.6677E-02,6.2671E-02,6.9309E-02,7.6862E-02/
      DATA (KB(JT,27, 6),JT=1,5) /
     &4.5068E-02,5.0089E-02,5.5571E-02,6.2056E-02,6.8532E-02/
      DATA (KB(JT,28, 6),JT=1,5) /
     &3.9606E-02,4.4193E-02,4.9408E-02,5.5057E-02,6.0956E-02/
      DATA (KB(JT,29, 6),JT=1,5) /
     &3.4989E-02,3.9176E-02,4.4032E-02,4.9174E-02,5.4655E-02/
      DATA (KB(JT,30, 6),JT=1,5) /
     &3.0943E-02,3.4971E-02,3.9398E-02,4.4027E-02,4.9163E-02/
      DATA (KB(JT,31, 6),JT=1,5) /
     &2.7553E-02,3.1287E-02,3.5351E-02,3.9782E-02,4.4558E-02/
      DATA (KB(JT,32, 6),JT=1,5) /
     &2.4710E-02,2.8155E-02,3.1869E-02,3.6099E-02,4.0666E-02/
      DATA (KB(JT,33, 6),JT=1,5) /
     &2.2173E-02,2.5362E-02,2.8990E-02,3.2965E-02,3.7297E-02/
      DATA (KB(JT,34, 6),JT=1,5) /
     &2.0107E-02,2.3109E-02,2.6574E-02,3.0332E-02,3.4357E-02/
      DATA (KB(JT,35, 6),JT=1,5) /
     &1.8022E-02,2.0877E-02,2.4132E-02,2.7710E-02,3.1520E-02/
      DATA (KB(JT,36, 6),JT=1,5) /
     &1.5963E-02,1.8659E-02,2.1660E-02,2.4929E-02,2.8560E-02/
      DATA (KB(JT,37, 6),JT=1,5) /
     &1.3764E-02,1.6188E-02,1.8916E-02,2.1932E-02,2.5294E-02/
      DATA (KB(JT,38, 6),JT=1,5) /
     &1.1849E-02,1.4028E-02,1.6494E-02,1.9269E-02,2.2340E-02/
      DATA (KB(JT,39, 6),JT=1,5) /
     &1.0207E-02,1.2194E-02,1.4401E-02,1.6941E-02,1.9796E-02/
      DATA (KB(JT,40, 6),JT=1,5) /
     &8.5573E-03,1.0315E-02,1.2260E-02,1.4559E-02,1.7141E-02/
      DATA (KB(JT,41, 6),JT=1,5) /
     &7.1290E-03,8.6738E-03,1.0403E-02,1.2445E-02,1.4801E-02/
      DATA (KB(JT,42, 6),JT=1,5) /
     &5.9179E-03,7.2709E-03,8.8122E-03,1.0627E-02,1.2787E-02/
      DATA (KB(JT,43, 6),JT=1,5) /
     &4.8318E-03,5.9892E-03,7.3334E-03,8.9514E-03,1.0874E-02/
      DATA (KB(JT,44, 6),JT=1,5) /
     &3.8999E-03,4.8767E-03,6.0501E-03,7.4816E-03,9.1794E-03/
      DATA (KB(JT,45, 6),JT=1,5) /
     &3.1360E-03,3.9601E-03,4.9837E-03,6.2240E-03,7.7311E-03/
      DATA (KB(JT,46, 6),JT=1,5) /
     &2.5027E-03,3.1827E-03,4.0540E-03,5.1329E-03,6.4480E-03/
      DATA (KB(JT,47, 6),JT=1,5) /
     &1.9756E-03,2.5273E-03,3.2610E-03,4.1749E-03,5.3122E-03/
      DATA (KB(JT,48, 6),JT=1,5) /
     &1.5473E-03,1.9960E-03,2.6043E-03,3.3772E-03,4.3437E-03/
      DATA (KB(JT,49, 6),JT=1,5) /
     &1.2068E-03,1.5706E-03,2.0674E-03,2.7091E-03,3.5307E-03/
      DATA (KB(JT,50, 6),JT=1,5) /
     &9.4521E-04,1.2396E-03,1.6445E-03,2.1801E-03,2.8792E-03/
      DATA (KB(JT,51, 6),JT=1,5) /
     &7.3804E-04,9.7746E-04,1.3076E-03,1.7542E-03,2.3409E-03/
      DATA (KB(JT,52, 6),JT=1,5) /
     &5.7206E-04,7.6763E-04,1.0338E-03,1.4015E-03,1.8909E-03/
      DATA (KB(JT,53, 6),JT=1,5) /
     &4.4225E-04,5.9805E-04,8.1248E-04,1.1113E-03,1.5170E-03/
      DATA (KB(JT,54, 6),JT=1,5) /
     &3.4467E-04,4.7010E-04,6.4272E-04,8.8848E-04,1.2276E-03/
      DATA (KB(JT,55, 6),JT=1,5) /
     &2.6885E-04,3.6925E-04,5.1051E-04,7.1238E-04,9.9424E-04/
      DATA (KB(JT,56, 6),JT=1,5) /
     &2.0891E-04,2.8866E-04,4.0323E-04,5.6854E-04,8.0318E-04/
      DATA (KB(JT,57, 6),JT=1,5) /
     &1.6206E-04,2.2457E-04,3.1663E-04,4.5154E-04,6.4436E-04/
      DATA (KB(JT,58, 6),JT=1,5) /
     &1.2565E-04,1.7534E-04,2.4919E-04,3.5849E-04,5.1835E-04/
      DATA (KB(JT,59, 6),JT=1,5) /
     &1.0370E-04,1.4590E-04,2.0972E-04,3.0572E-04,4.4824E-04/
      DATA (KB(JT,13, 7),JT=1,5) /
     &8.6885E-01,8.9426E-01,9.2071E-01,9.5081E-01,9.7593E-01/
      DATA (KB(JT,14, 7),JT=1,5) /
     &7.3422E-01,7.5692E-01,7.8528E-01,8.1141E-01,8.3349E-01/
      DATA (KB(JT,15, 7),JT=1,5) /
     &6.1192E-01,6.3447E-01,6.5837E-01,6.7854E-01,7.0269E-01/
      DATA (KB(JT,16, 7),JT=1,5) /
     &5.0884E-01,5.2842E-01,5.4670E-01,5.6627E-01,5.8867E-01/
      DATA (KB(JT,17, 7),JT=1,5) /
     &4.3640E-01,4.5419E-01,4.7288E-01,4.9197E-01,5.1336E-01/
      DATA (KB(JT,18, 7),JT=1,5) /
     &3.8407E-01,4.0203E-01,4.1993E-01,4.4018E-01,4.6362E-01/
      DATA (KB(JT,19, 7),JT=1,5) /
     &3.4228E-01,3.5912E-01,3.7740E-01,3.9888E-01,4.2103E-01/
      DATA (KB(JT,20, 7),JT=1,5) /
     &3.0199E-01,3.1730E-01,3.3484E-01,3.5351E-01,3.7675E-01/
      DATA (KB(JT,21, 7),JT=1,5) /
     &2.6553E-01,2.8042E-01,2.9603E-01,3.1609E-01,3.3882E-01/
      DATA (KB(JT,22, 7),JT=1,5) /
     &2.3320E-01,2.4726E-01,2.6434E-01,2.8368E-01,3.0736E-01/
      DATA (KB(JT,23, 7),JT=1,5) /
     &2.0578E-01,2.1941E-01,2.3579E-01,2.5629E-01,2.8224E-01/
      DATA (KB(JT,24, 7),JT=1,5) /
     &1.8045E-01,1.9362E-01,2.1135E-01,2.3376E-01,2.5793E-01/
      DATA (KB(JT,25, 7),JT=1,5) /
     &1.5885E-01,1.7311E-01,1.9174E-01,2.1249E-01,2.3261E-01/
      DATA (KB(JT,26, 7),JT=1,5) /
     &1.4101E-01,1.5639E-01,1.7418E-01,1.9114E-01,2.1048E-01/
      DATA (KB(JT,27, 7),JT=1,5) /
     &1.2599E-01,1.4076E-01,1.5557E-01,1.7183E-01,1.9023E-01/
      DATA (KB(JT,28, 7),JT=1,5) /
     &1.1218E-01,1.2546E-01,1.3903E-01,1.5482E-01,1.7215E-01/
      DATA (KB(JT,29, 7),JT=1,5) /
     &1.0072E-01,1.1254E-01,1.2583E-01,1.4062E-01,1.5650E-01/
      DATA (KB(JT,30, 7),JT=1,5) /
     &9.0713E-02,1.0192E-01,1.1464E-01,1.2854E-01,1.4398E-01/
      DATA (KB(JT,31, 7),JT=1,5) /
     &8.2277E-02,9.3097E-02,1.0524E-01,1.1856E-01,1.3355E-01/
      DATA (KB(JT,32, 7),JT=1,5) /
     &7.5303E-02,8.5763E-02,9.7401E-02,1.1054E-01,1.2526E-01/
      DATA (KB(JT,33, 7),JT=1,5) /
     &6.9506E-02,7.9549E-02,9.0902E-02,1.0398E-01,1.1862E-01/
      DATA (KB(JT,34, 7),JT=1,5) /
     &6.4727E-02,7.4554E-02,8.5918E-02,9.8930E-02,1.1374E-01/
      DATA (KB(JT,35, 7),JT=1,5) /
     &5.9573E-02,6.9480E-02,8.0602E-02,9.3549E-02,1.0847E-01/
      DATA (KB(JT,36, 7),JT=1,5) /
     &5.4200E-02,6.3825E-02,7.4842E-02,8.7689E-02,1.0224E-01/
      DATA (KB(JT,37, 7),JT=1,5) /
     &4.7941E-02,5.7083E-02,6.7560E-02,8.0041E-02,9.3919E-02/
      DATA (KB(JT,38, 7),JT=1,5) /
     &4.2423E-02,5.1057E-02,6.0983E-02,7.2873E-02,8.6484E-02/
      DATA (KB(JT,39, 7),JT=1,5) /
     &3.7589E-02,4.5606E-02,5.5155E-02,6.6511E-02,7.9703E-02/
      DATA (KB(JT,40, 7),JT=1,5) /
     &3.2287E-02,3.9605E-02,4.8489E-02,5.9153E-02,7.1379E-02/
      DATA (KB(JT,41, 7),JT=1,5) /
     &2.7611E-02,3.4241E-02,4.2425E-02,5.2312E-02,6.3597E-02/
      DATA (KB(JT,42, 7),JT=1,5) /
     &2.3526E-02,2.9544E-02,3.7050E-02,4.6066E-02,5.6624E-02/
      DATA (KB(JT,43, 7),JT=1,5) /
     &1.9724E-02,2.5077E-02,3.1787E-02,3.9922E-02,4.9656E-02/
      DATA (KB(JT,44, 7),JT=1,5) /
     &1.6360E-02,2.1054E-02,2.6994E-02,3.4254E-02,4.3106E-02/
      DATA (KB(JT,45, 7),JT=1,5) /
     &1.3479E-02,1.7563E-02,2.2810E-02,2.9308E-02,3.7331E-02/
      DATA (KB(JT,46, 7),JT=1,5) /
     &1.0982E-02,1.4524E-02,1.9109E-02,2.4872E-02,3.2032E-02/
      DATA (KB(JT,47, 7),JT=1,5) /
     &8.8182E-03,1.1815E-02,1.5755E-02,2.0785E-02,2.7117E-02/
      DATA (KB(JT,48, 7),JT=1,5) /
     &7.0297E-03,9.5228E-03,1.2883E-02,1.7248E-02,2.2808E-02/
      DATA (KB(JT,49, 7),JT=1,5) /
     &5.5570E-03,7.6141E-03,1.0446E-02,1.4193E-02,1.9030E-02/
      DATA (KB(JT,50, 7),JT=1,5) /
     &4.4018E-03,6.0988E-03,8.5078E-03,1.1727E-02,1.5958E-02/
      DATA (KB(JT,51, 7),JT=1,5) /
     &3.4813E-03,4.8790E-03,6.9087E-03,9.6740E-03,1.3370E-02/
      DATA (KB(JT,52, 7),JT=1,5) /
     &2.7259E-03,3.8645E-03,5.5503E-03,7.9313E-03,1.1133E-02/
      DATA (KB(JT,53, 7),JT=1,5) /
     &2.1153E-03,3.0336E-03,4.4195E-03,6.4300E-03,9.1714E-03/
      DATA (KB(JT,54, 7),JT=1,5) /
     &1.6649E-03,2.4099E-03,3.5602E-03,5.2651E-03,7.6558E-03/
      DATA (KB(JT,55, 7),JT=1,5) /
     &1.3120E-03,1.9223E-03,2.8746E-03,4.3204E-03,6.4144E-03/
      DATA (KB(JT,56, 7),JT=1,5) /
     &1.0280E-03,1.5213E-03,2.3034E-03,3.5254E-03,5.3355E-03/
      DATA (KB(JT,57, 7),JT=1,5) /
     &8.0119E-04,1.1961E-03,1.8353E-03,2.8565E-03,4.4054E-03/
      DATA (KB(JT,58, 7),JT=1,5) /
     &6.2596E-04,9.4223E-04,1.4648E-03,2.3194E-03,3.6416E-03/
      DATA (KB(JT,59, 7),JT=1,5) /
     &5.2923E-04,8.1079E-04,1.2847E-03,2.0681E-03,3.3065E-03/
      DATA (KB(JT,13, 8),JT=1,5) /
     &3.0137E+00,3.0721E+00,3.1135E+00,3.1353E+00,3.1526E+00/
      DATA (KB(JT,14, 8),JT=1,5) /
     &2.5881E+00,2.6331E+00,2.6669E+00,2.6887E+00,2.7106E+00/
      DATA (KB(JT,15, 8),JT=1,5) /
     &2.2017E+00,2.2477E+00,2.2747E+00,2.3022E+00,2.3199E+00/
      DATA (KB(JT,16, 8),JT=1,5) /
     &1.8745E+00,1.9119E+00,1.9407E+00,1.9650E+00,1.9910E+00/
      DATA (KB(JT,17, 8),JT=1,5) /
     &1.5865E+00,1.6181E+00,1.6438E+00,1.6744E+00,1.7044E+00/
      DATA (KB(JT,18, 8),JT=1,5) /
     &1.3469E+00,1.3737E+00,1.4061E+00,1.4422E+00,1.4784E+00/
      DATA (KB(JT,19, 8),JT=1,5) /
     &1.1589E+00,1.1936E+00,1.2348E+00,1.2728E+00,1.3146E+00/
      DATA (KB(JT,20, 8),JT=1,5) /
     &1.0242E+00,1.0660E+00,1.1056E+00,1.1466E+00,1.1869E+00/
      DATA (KB(JT,21, 8),JT=1,5) /
     &9.1121E-01,9.5273E-01,9.9427E-01,1.0332E+00,1.0710E+00/
      DATA (KB(JT,22, 8),JT=1,5) /
     &8.0647E-01,8.4440E-01,8.8114E-01,9.1866E-01,9.5785E-01/
      DATA (KB(JT,23, 8),JT=1,5) /
     &7.0834E-01,7.4542E-01,7.7998E-01,8.1759E-01,8.5850E-01/
      DATA (KB(JT,24, 8),JT=1,5) /
     &6.2177E-01,6.5425E-01,6.8799E-01,7.2751E-01,7.7799E-01/
      DATA (KB(JT,25, 8),JT=1,5) /
     &5.4589E-01,5.7729E-01,6.1309E-01,6.5804E-01,7.1412E-01/
      DATA (KB(JT,26, 8),JT=1,5) /
     &4.8128E-01,5.1418E-01,5.5324E-01,6.0347E-01,6.6308E-01/
      DATA (KB(JT,27, 8),JT=1,5) /
     &4.2682E-01,4.6055E-01,5.0524E-01,5.5765E-01,6.2135E-01/
      DATA (KB(JT,28, 8),JT=1,5) /
     &3.8006E-01,4.1721E-01,4.6337E-01,5.1919E-01,5.8322E-01/
      DATA (KB(JT,29, 8),JT=1,5) /
     &3.4196E-01,3.8125E-01,4.2943E-01,4.8588E-01,5.5221E-01/
      DATA (KB(JT,30, 8),JT=1,5) /
     &3.1093E-01,3.5114E-01,4.0038E-01,4.5863E-01,5.2276E-01/
      DATA (KB(JT,31, 8),JT=1,5) /
     &2.8616E-01,3.2668E-01,3.7633E-01,4.3472E-01,4.9941E-01/
      DATA (KB(JT,32, 8),JT=1,5) /
     &2.6688E-01,3.0820E-01,3.5883E-01,4.1523E-01,4.8206E-01/
      DATA (KB(JT,33, 8),JT=1,5) /
     &2.5149E-01,2.9538E-01,3.4473E-01,4.0327E-01,4.6953E-01/
      DATA (KB(JT,34, 8),JT=1,5) /
     &2.4069E-01,2.8516E-01,3.3563E-01,3.9421E-01,4.6040E-01/
      DATA (KB(JT,35, 8),JT=1,5) /
     &2.2923E-01,2.7328E-01,3.2510E-01,3.8300E-01,4.4899E-01/
      DATA (KB(JT,36, 8),JT=1,5) /
     &2.1677E-01,2.6037E-01,3.1183E-01,3.6883E-01,4.3509E-01/
      DATA (KB(JT,37, 8),JT=1,5) /
     &1.9848E-01,2.3986E-01,2.8965E-01,3.4421E-01,4.0854E-01/
      DATA (KB(JT,38, 8),JT=1,5) /
     &1.8143E-01,2.2127E-01,2.6901E-01,3.2212E-01,3.8468E-01/
      DATA (KB(JT,39, 8),JT=1,5) /
     &1.6606E-01,2.0455E-01,2.5024E-01,3.0203E-01,3.6363E-01/
      DATA (KB(JT,40, 8),JT=1,5) /
     &1.4741E-01,1.8322E-01,2.2603E-01,2.7520E-01,3.3417E-01/
      DATA (KB(JT,41, 8),JT=1,5) /
     &1.3011E-01,1.6308E-01,2.0319E-01,2.4965E-01,3.0588E-01/
      DATA (KB(JT,42, 8),JT=1,5) /
     &1.1484E-01,1.4491E-01,1.8233E-01,2.2638E-01,2.7964E-01/
      DATA (KB(JT,43, 8),JT=1,5) /
     &9.9279E-02,1.2633E-01,1.6039E-01,2.0179E-01,2.5143E-01/
      DATA (KB(JT,44, 8),JT=1,5) /
     &8.4904E-02,1.0929E-01,1.3953E-01,1.7766E-01,2.2379E-01/
      DATA (KB(JT,45, 8),JT=1,5) /
     &7.2367E-02,9.4015E-02,1.2097E-01,1.5526E-01,1.9786E-01/
      DATA (KB(JT,46, 8),JT=1,5) /
     &6.1012E-02,8.0269E-02,1.0419E-01,1.3470E-01,1.7331E-01/
      DATA (KB(JT,47, 8),JT=1,5) /
     &5.0418E-02,6.7581E-02,8.8667E-02,1.1556E-01,1.5023E-01/
      DATA (KB(JT,48, 8),JT=1,5) /
     &4.1555E-02,5.6345E-02,7.4999E-02,9.8811E-02,1.2934E-01/
      DATA (KB(JT,49, 8),JT=1,5) /
     &3.3904E-02,4.6392E-02,6.2939E-02,8.3873E-02,1.1077E-01/
      DATA (KB(JT,50, 8),JT=1,5) /
     &2.7924E-02,3.8644E-02,5.3103E-02,7.1817E-02,9.5860E-02/
      DATA (KB(JT,51, 8),JT=1,5) /
     &2.3027E-02,3.2254E-02,4.4770E-02,6.1630E-02,8.3189E-02/
      DATA (KB(JT,52, 8),JT=1,5) /
     &1.8860E-02,2.6783E-02,3.7563E-02,5.2481E-02,7.1941E-02/
      DATA (KB(JT,53, 8),JT=1,5) /
     &1.5315E-02,2.2045E-02,3.1363E-02,4.4231E-02,6.1710E-02/
      DATA (KB(JT,54, 8),JT=1,5) /
     &1.2583E-02,1.8403E-02,2.6586E-02,3.7901E-02,5.3727E-02/
      DATA (KB(JT,55, 8),JT=1,5) /
     &1.0382E-02,1.5404E-02,2.2584E-02,3.2684E-02,4.7053E-02/
      DATA (KB(JT,56, 8),JT=1,5) /
     &8.4944E-03,1.2799E-02,1.9133E-02,2.8106E-02,4.1010E-02/
      DATA (KB(JT,57, 8),JT=1,5) /
     &6.8852E-03,1.0598E-02,1.6081E-02,2.3991E-02,3.5498E-02/
      DATA (KB(JT,58, 8),JT=1,5) /
     &5.5895E-03,8.7768E-03,1.3535E-02,2.0567E-02,3.0872E-02/
      DATA (KB(JT,59, 8),JT=1,5) /
     &4.9705E-03,7.9600E-03,1.2473E-02,1.9319E-02,2.9463E-02/
      DATA (KB(JT,13, 9),JT=1,5) /
     &1.4590E+01,1.4670E+01,1.4841E+01,1.4854E+01,1.4880E+01/
      DATA (KB(JT,14, 9),JT=1,5) /
     &1.3239E+01,1.3368E+01,1.3423E+01,1.3479E+01,1.3588E+01/
      DATA (KB(JT,15, 9),JT=1,5) /
     &1.1801E+01,1.1873E+01,1.1983E+01,1.2092E+01,1.2194E+01/
      DATA (KB(JT,16, 9),JT=1,5) /
     &1.0397E+01,1.0519E+01,1.0636E+01,1.0761E+01,1.0910E+01/
      DATA (KB(JT,17, 9),JT=1,5) /
     &9.1941E+00,9.3273E+00,9.4699E+00,9.6116E+00,9.7497E+00/
      DATA (KB(JT,18, 9),JT=1,5) /
     &8.2105E+00,8.3532E+00,8.4897E+00,8.6223E+00,8.7373E+00/
      DATA (KB(JT,19, 9),JT=1,5) /
     &7.2827E+00,7.4240E+00,7.5562E+00,7.6727E+00,7.7914E+00/
      DATA (KB(JT,20, 9),JT=1,5) /
     &6.3721E+00,6.4943E+00,6.6028E+00,6.7186E+00,6.8391E+00/
      DATA (KB(JT,21, 9),JT=1,5) /
     &5.5515E+00,5.6468E+00,5.7503E+00,5.8563E+00,5.9656E+00/
      DATA (KB(JT,22, 9),JT=1,5) /
     &4.8000E+00,4.8972E+00,4.9944E+00,5.1084E+00,5.2408E+00/
      DATA (KB(JT,23, 9),JT=1,5) /
     &4.1624E+00,4.2656E+00,4.3811E+00,4.5085E+00,4.6380E+00/
      DATA (KB(JT,24, 9),JT=1,5) /
     &3.6468E+00,3.7664E+00,3.9092E+00,4.0407E+00,4.1687E+00/
      DATA (KB(JT,25, 9),JT=1,5) /
     &3.2292E+00,3.3800E+00,3.5189E+00,3.6529E+00,3.8087E+00/
      DATA (KB(JT,26, 9),JT=1,5) /
     &2.9129E+00,3.0593E+00,3.1926E+00,3.3487E+00,3.5171E+00/
      DATA (KB(JT,27, 9),JT=1,5) /
     &2.6651E+00,2.7860E+00,2.9417E+00,3.1050E+00,3.2838E+00/
      DATA (KB(JT,28, 9),JT=1,5) /
     &2.4547E+00,2.5852E+00,2.7243E+00,2.8973E+00,3.0879E+00/
      DATA (KB(JT,29, 9),JT=1,5) /
     &2.2775E+00,2.4144E+00,2.5520E+00,2.7166E+00,2.9171E+00/
      DATA (KB(JT,30, 9),JT=1,5) /
     &2.1281E+00,2.2766E+00,2.4266E+00,2.5792E+00,2.7778E+00/
      DATA (KB(JT,31, 9),JT=1,5) /
     &1.9982E+00,2.1596E+00,2.3215E+00,2.4758E+00,2.6690E+00/
      DATA (KB(JT,32, 9),JT=1,5) /
     &1.8974E+00,2.0696E+00,2.2391E+00,2.4103E+00,2.6183E+00/
      DATA (KB(JT,33, 9),JT=1,5) /
     &1.8191E+00,1.9994E+00,2.1809E+00,2.3775E+00,2.6019E+00/
      DATA (KB(JT,34, 9),JT=1,5) /
     &1.7674E+00,1.9617E+00,2.1590E+00,2.3767E+00,2.6194E+00/
      DATA (KB(JT,35, 9),JT=1,5) /
     &1.7160E+00,1.9253E+00,2.1379E+00,2.3725E+00,2.6356E+00/
      DATA (KB(JT,36, 9),JT=1,5) /
     &1.6660E+00,1.8913E+00,2.1169E+00,2.3615E+00,2.6378E+00/
      DATA (KB(JT,37, 9),JT=1,5) /
     &1.5784E+00,1.8090E+00,2.0343E+00,2.2860E+00,2.5707E+00/
      DATA (KB(JT,38, 9),JT=1,5) /
     &1.4967E+00,1.7299E+00,1.9619E+00,2.2122E+00,2.4970E+00/
      DATA (KB(JT,39, 9),JT=1,5) /
     &1.4275E+00,1.6566E+00,1.8885E+00,2.1422E+00,2.4238E+00/
      DATA (KB(JT,40, 9),JT=1,5) /
     &1.3319E+00,1.5527E+00,1.7867E+00,2.0342E+00,2.3084E+00/
      DATA (KB(JT,41, 9),JT=1,5) /
     &1.2324E+00,1.4488E+00,1.6798E+00,1.9260E+00,2.1920E+00/
      DATA (KB(JT,42, 9),JT=1,5) /
     &1.1393E+00,1.3560E+00,1.5786E+00,1.8237E+00,2.0822E+00/
      DATA (KB(JT,43, 9),JT=1,5) /
     &1.0393E+00,1.2480E+00,1.4586E+00,1.7011E+00,1.9564E+00/
      DATA (KB(JT,44, 9),JT=1,5) /
     &9.4004E-01,1.1318E+00,1.3401E+00,1.5753E+00,1.8301E+00/
      DATA (KB(JT,45, 9),JT=1,5) /
     &8.4677E-01,1.0287E+00,1.2277E+00,1.4538E+00,1.7017E+00/
      DATA (KB(JT,46, 9),JT=1,5) /
     &7.5668E-01,9.2772E-01,1.1175E+00,1.3351E+00,1.5740E+00/
      DATA (KB(JT,47, 9),JT=1,5) /
     &6.6952E-01,8.3230E-01,1.0096E+00,1.2100E+00,1.4418E+00/
      DATA (KB(JT,48, 9),JT=1,5) /
     &5.9179E-01,7.4047E-01,9.0922E-01,1.0966E+00,1.3183E+00/
      DATA (KB(JT,49, 9),JT=1,5) /
     &5.2110E-01,6.5712E-01,8.1623E-01,9.9075E-01,1.1944E+00/
      DATA (KB(JT,50, 9),JT=1,5) /
     &4.6158E-01,5.8589E-01,7.3680E-01,8.9883E-01,1.0896E+00/
      DATA (KB(JT,51, 9),JT=1,5) /
     &4.0970E-01,5.2471E-01,6.6511E-01,8.1893E-01,1.0001E+00/
      DATA (KB(JT,52, 9),JT=1,5) /
     &3.6376E-01,4.6797E-01,5.9787E-01,7.4696E-01,9.1589E-01/
      DATA (KB(JT,53, 9),JT=1,5) /
     &3.2051E-01,4.1628E-01,5.3506E-01,6.7993E-01,8.3743E-01/
      DATA (KB(JT,54, 9),JT=1,5) /
     &2.8466E-01,3.7491E-01,4.8412E-01,6.2077E-01,7.6925E-01/
      DATA (KB(JT,55, 9),JT=1,5) /
     &2.5367E-01,3.3870E-01,4.3869E-01,5.6524E-01,7.0875E-01/
      DATA (KB(JT,56, 9),JT=1,5) /
     &2.2562E-01,3.0476E-01,3.9766E-01,5.1473E-01,6.5170E-01/
      DATA (KB(JT,57, 9),JT=1,5) /
     &1.9827E-01,2.7217E-01,3.6127E-01,4.6695E-01,5.9679E-01/
      DATA (KB(JT,58, 9),JT=1,5) /
     &1.7439E-01,2.4383E-01,3.2816E-01,4.2523E-01,5.4584E-01/
      DATA (KB(JT,59, 9),JT=1,5) /
     &1.6511E-01,2.3377E-01,3.1581E-01,4.1157E-01,5.2975E-01/
      DATA (KB(JT,13,10),JT=1,5) /
     &4.0695E+01,4.0469E+01,4.0155E+01,4.1544E+01,4.2682E+01/
      DATA (KB(JT,14,10),JT=1,5) /
     &3.9304E+01,3.9060E+01,4.0807E+01,4.1587E+01,4.0953E+01/
      DATA (KB(JT,15,10),JT=1,5) /
     &3.7657E+01,3.9117E+01,3.9307E+01,3.8957E+01,3.9710E+01/
      DATA (KB(JT,16,10),JT=1,5) /
     &3.6278E+01,3.6420E+01,3.6566E+01,3.7322E+01,3.7268E+01/
      DATA (KB(JT,17,10),JT=1,5) /
     &3.3662E+01,3.3973E+01,3.4667E+01,3.4884E+01,3.5251E+01/
      DATA (KB(JT,18,10),JT=1,5) /
     &3.1195E+01,3.1946E+01,3.2272E+01,3.2818E+01,3.3898E+01/
      DATA (KB(JT,19,10),JT=1,5) /
     &2.9346E+01,2.9678E+01,3.0231E+01,3.1581E+01,3.2542E+01/
      DATA (KB(JT,20,10),JT=1,5) /
     &2.6569E+01,2.7189E+01,2.8571E+01,2.9702E+01,3.0461E+01/
      DATA (KB(JT,21,10),JT=1,5) /
     &2.3800E+01,2.5133E+01,2.6296E+01,2.7333E+01,2.8348E+01/
      DATA (KB(JT,22,10),JT=1,5) /
     &2.1748E+01,2.2899E+01,2.3947E+01,2.5006E+01,2.6299E+01/
      DATA (KB(JT,23,10),JT=1,5) /
     &1.9685E+01,2.0476E+01,2.1391E+01,2.2690E+01,2.3900E+01/
      DATA (KB(JT,24,10),JT=1,5) /
     &1.7032E+01,1.7826E+01,1.8674E+01,1.9703E+01,2.1087E+01/
      DATA (KB(JT,25,10),JT=1,5) /
     &1.4880E+01,1.5564E+01,1.6390E+01,1.7502E+01,1.8671E+01/
      DATA (KB(JT,26,10),JT=1,5) /
     &1.3363E+01,1.4020E+01,1.5087E+01,1.6178E+01,1.7289E+01/
      DATA (KB(JT,27,10),JT=1,5) /
     &1.1727E+01,1.2959E+01,1.3942E+01,1.5094E+01,1.6463E+01/
      DATA (KB(JT,28,10),JT=1,5) /
     &1.0659E+01,1.1764E+01,1.3018E+01,1.4300E+01,1.5936E+01/
      DATA (KB(JT,29,10),JT=1,5) /
     &9.6581E+00,1.0907E+01,1.2325E+01,1.4028E+01,1.5807E+01/
      DATA (KB(JT,30,10),JT=1,5) /
     &8.9612E+00,1.0145E+01,1.1747E+01,1.3771E+01,1.5726E+01/
      DATA (KB(JT,31,10),JT=1,5) /
     &8.6124E+00,9.7350E+00,1.1421E+01,1.3475E+01,1.5366E+01/
      DATA (KB(JT,32,10),JT=1,5) /
     &8.5911E+00,9.4800E+00,1.1115E+01,1.3010E+01,1.4984E+01/
      DATA (KB(JT,33,10),JT=1,5) /
     &8.6709E+00,9.3343E+00,1.0809E+01,1.2622E+01,1.4676E+01/
      DATA (KB(JT,34,10),JT=1,5) /
     &8.8793E+00,9.5541E+00,1.0639E+01,1.2461E+01,1.4700E+01/
      DATA (KB(JT,35,10),JT=1,5) /
     &9.1036E+00,9.7617E+00,1.0550E+01,1.2303E+01,1.4597E+01/
      DATA (KB(JT,36,10),JT=1,5) /
     &9.1500E+00,9.8472E+00,1.0675E+01,1.1920E+01,1.4033E+01/
      DATA (KB(JT,37,10),JT=1,5) /
     &8.9913E+00,9.7513E+00,1.0626E+01,1.1848E+01,1.3311E+01/
      DATA (KB(JT,38,10),JT=1,5) /
     &8.8541E+00,9.6133E+00,1.0479E+01,1.1805E+01,1.2978E+01/
      DATA (KB(JT,39,10),JT=1,5) /
     &8.6355E+00,9.4791E+00,1.0441E+01,1.1774E+01,1.2974E+01/
      DATA (KB(JT,40,10),JT=1,5) /
     &8.2572E+00,9.1900E+00,1.0103E+01,1.1340E+01,1.2612E+01/
      DATA (KB(JT,41,10),JT=1,5) /
     &7.9700E+00,8.8564E+00,9.7227E+00,1.0892E+01,1.2191E+01/
      DATA (KB(JT,42,10),JT=1,5) /
     &7.7269E+00,8.5147E+00,9.3572E+00,1.0449E+01,1.1769E+01/
      DATA (KB(JT,43,10),JT=1,5) /
     &7.3457E+00,8.1022E+00,8.9870E+00,9.9755E+00,1.1267E+01/
      DATA (KB(JT,44,10),JT=1,5) /
     &6.8559E+00,7.7825E+00,8.6085E+00,9.5618E+00,1.0705E+01/
      DATA (KB(JT,45,10),JT=1,5) /
     &6.3680E+00,7.3808E+00,8.2404E+00,9.1444E+00,1.0228E+01/
      DATA (KB(JT,46,10),JT=1,5) /
     &5.9178E+00,6.9688E+00,7.8931E+00,8.8310E+00,9.8114E+00/
      DATA (KB(JT,47,10),JT=1,5) /
     &5.4530E+00,6.4924E+00,7.5375E+00,8.5314E+00,9.4745E+00/
      DATA (KB(JT,48,10),JT=1,5) /
     &4.9630E+00,6.0598E+00,7.0862E+00,8.1895E+00,9.1462E+00/
      DATA (KB(JT,49,10),JT=1,5) /
     &4.4814E+00,5.6082E+00,6.6461E+00,7.8385E+00,8.8792E+00/
      DATA (KB(JT,50,10),JT=1,5) /
     &4.0666E+00,5.1497E+00,6.2742E+00,7.4367E+00,8.5539E+00/
      DATA (KB(JT,51,10),JT=1,5) /
     &3.6813E+00,4.7093E+00,5.9040E+00,7.0217E+00,8.2062E+00/
      DATA (KB(JT,52,10),JT=1,5) /
     &3.3213E+00,4.2985E+00,5.4430E+00,6.5658E+00,7.7730E+00/
      DATA (KB(JT,53,10),JT=1,5) /
     &2.9730E+00,3.8940E+00,5.0012E+00,6.1367E+00,7.2957E+00/
      DATA (KB(JT,54,10),JT=1,5) /
     &2.6494E+00,3.5088E+00,4.5590E+00,5.7479E+00,6.8609E+00/
      DATA (KB(JT,55,10),JT=1,5) /
     &2.3517E+00,3.1542E+00,4.1525E+00,5.3587E+00,6.4637E+00/
      DATA (KB(JT,56,10),JT=1,5) /
     &2.0870E+00,2.8232E+00,3.7684E+00,4.9288E+00,6.0659E+00/
      DATA (KB(JT,57,10),JT=1,5) /
     &1.8716E+00,2.5211E+00,3.3862E+00,4.4963E+00,5.6364E+00/
      DATA (KB(JT,58,10),JT=1,5) /
     &1.6996E+00,2.2494E+00,3.0457E+00,4.0946E+00,5.2813E+00/
      DATA (KB(JT,59,10),JT=1,5) /
     &1.6125E+00,2.1057E+00,2.8675E+00,3.8607E+00,5.0173E+00/
      DATA (KB(JT,13,11),JT=1,5) /
     &5.4280E+01,5.5937E+01,5.6472E+01,5.6083E+01,5.6645E+01/
      DATA (KB(JT,14,11),JT=1,5) /
     &5.6104E+01,5.7569E+01,5.6325E+01,5.6970E+01,5.8322E+01/
      DATA (KB(JT,15,11),JT=1,5) /
     &5.6157E+01,5.5505E+01,5.6534E+01,5.8680E+01,5.8495E+01/
      DATA (KB(JT,16,11),JT=1,5) /
     &5.4215E+01,5.5590E+01,5.7381E+01,5.6844E+01,5.6502E+01/
      DATA (KB(JT,17,11),JT=1,5) /
     &5.3917E+01,5.5209E+01,5.4751E+01,5.5176E+01,5.5535E+01/
      DATA (KB(JT,18,11),JT=1,5) /
     &5.2925E+01,5.3017E+01,5.3849E+01,5.4671E+01,5.5470E+01/
      DATA (KB(JT,19,11),JT=1,5) /
     &5.0412E+01,5.1474E+01,5.2761E+01,5.3623E+01,5.4522E+01/
      DATA (KB(JT,20,11),JT=1,5) /
     &4.7799E+01,4.9437E+01,5.0594E+01,5.1515E+01,5.3379E+01/
      DATA (KB(JT,21,11),JT=1,5) /
     &4.5510E+01,4.6838E+01,4.7923E+01,4.9803E+01,5.2087E+01/
      DATA (KB(JT,22,11),JT=1,5) /
     &4.2197E+01,4.3528E+01,4.5703E+01,4.8296E+01,5.0603E+01/
      DATA (KB(JT,23,11),JT=1,5) /
     &3.8776E+01,4.1167E+01,4.4015E+01,4.6341E+01,4.9195E+01/
      DATA (KB(JT,24,11),JT=1,5) /
     &3.6077E+01,3.8799E+01,4.1478E+01,4.4468E+01,4.7105E+01/
      DATA (KB(JT,25,11),JT=1,5) /
     &3.3423E+01,3.6288E+01,3.9007E+01,4.1836E+01,4.5174E+01/
      DATA (KB(JT,26,11),JT=1,5) /
     &3.0575E+01,3.3241E+01,3.5927E+01,3.9133E+01,4.2785E+01/
      DATA (KB(JT,27,11),JT=1,5) /
     &2.7764E+01,3.0312E+01,3.3054E+01,3.6826E+01,4.0509E+01/
      DATA (KB(JT,28,11),JT=1,5) /
     &2.5413E+01,2.8045E+01,3.1419E+01,3.5118E+01,3.8747E+01/
      DATA (KB(JT,29,11),JT=1,5) /
     &2.4096E+01,2.6980E+01,3.0700E+01,3.4243E+01,3.7699E+01/
      DATA (KB(JT,30,11),JT=1,5) /
     &2.3140E+01,2.6541E+01,2.9953E+01,3.3565E+01,3.7298E+01/
      DATA (KB(JT,31,11),JT=1,5) /
     &2.2574E+01,2.6228E+01,2.9925E+01,3.3653E+01,3.8032E+01/
      DATA (KB(JT,32,11),JT=1,5) /
     &2.2078E+01,2.6231E+01,3.0164E+01,3.4342E+01,3.9067E+01/
      DATA (KB(JT,33,11),JT=1,5) /
     &2.1802E+01,2.6392E+01,3.0637E+01,3.5356E+01,4.0173E+01/
      DATA (KB(JT,34,11),JT=1,5) /
     &2.1886E+01,2.6523E+01,3.1557E+01,3.6504E+01,4.1183E+01/
      DATA (KB(JT,35,11),JT=1,5) /
     &2.1287E+01,2.6137E+01,3.1875E+01,3.7051E+01,4.1397E+01/
      DATA (KB(JT,36,11),JT=1,5) /
     &2.0396E+01,2.5293E+01,3.0920E+01,3.6387E+01,4.1546E+01/
      DATA (KB(JT,37,11),JT=1,5) /
     &1.9398E+01,2.4195E+01,2.9734E+01,3.5138E+01,4.1598E+01/
      DATA (KB(JT,38,11),JT=1,5) /
     &1.8580E+01,2.3161E+01,2.8626E+01,3.3912E+01,4.1158E+01/
      DATA (KB(JT,39,11),JT=1,5) /
     &1.8482E+01,2.2205E+01,2.7504E+01,3.3104E+01,4.0527E+01/
      DATA (KB(JT,40,11),JT=1,5) /
     &1.7984E+01,2.0750E+01,2.5770E+01,3.1669E+01,3.8818E+01/
      DATA (KB(JT,41,11),JT=1,5) /
     &1.7355E+01,1.9936E+01,2.4013E+01,3.0152E+01,3.7102E+01/
      DATA (KB(JT,42,11),JT=1,5) /
     &1.6681E+01,1.9220E+01,2.2251E+01,2.8625E+01,3.5420E+01/
      DATA (KB(JT,43,11),JT=1,5) /
     &1.5870E+01,1.8435E+01,2.1070E+01,2.6668E+01,3.3375E+01/
      DATA (KB(JT,44,11),JT=1,5) /
     &1.5165E+01,1.7568E+01,2.0082E+01,2.4204E+01,3.1050E+01/
      DATA (KB(JT,45,11),JT=1,5) /
     &1.4453E+01,1.6684E+01,1.9148E+01,2.2404E+01,2.8741E+01/
      DATA (KB(JT,46,11),JT=1,5) /
     &1.3674E+01,1.5793E+01,1.8236E+01,2.1064E+01,2.6017E+01/
      DATA (KB(JT,47,11),JT=1,5) /
     &1.2730E+01,1.4847E+01,1.7129E+01,1.9769E+01,2.3301E+01/
      DATA (KB(JT,48,11),JT=1,5) /
     &1.1966E+01,1.3921E+01,1.6062E+01,1.8570E+01,2.1519E+01/
      DATA (KB(JT,49,11),JT=1,5) /
     &1.1256E+01,1.2947E+01,1.5051E+01,1.7441E+01,2.0164E+01/
      DATA (KB(JT,50,11),JT=1,5) /
     &1.0630E+01,1.2231E+01,1.4125E+01,1.6384E+01,1.9019E+01/
      DATA (KB(JT,51,11),JT=1,5) /
     &9.8987E+00,1.1569E+01,1.3215E+01,1.5489E+01,1.7851E+01/
      DATA (KB(JT,52,11),JT=1,5) /
     &9.1901E+00,1.0969E+01,1.2500E+01,1.4560E+01,1.6807E+01/
      DATA (KB(JT,53,11),JT=1,5) /
     &8.5518E+00,1.0279E+01,1.1856E+01,1.3672E+01,1.5980E+01/
      DATA (KB(JT,54,11),JT=1,5) /
     &7.8898E+00,9.6237E+00,1.1322E+01,1.2850E+01,1.5109E+01/
      DATA (KB(JT,55,11),JT=1,5) /
     &7.2910E+00,9.0794E+00,1.0802E+01,1.2222E+01,1.4316E+01/
      DATA (KB(JT,56,11),JT=1,5) /
     &6.6231E+00,8.4503E+00,1.0147E+01,1.1641E+01,1.3475E+01/
      DATA (KB(JT,57,11),JT=1,5) /
     &5.9797E+00,7.8956E+00,9.5656E+00,1.1172E+01,1.2770E+01/
      DATA (KB(JT,58,11),JT=1,5) /
     &5.3792E+00,7.3070E+00,9.0406E+00,1.0661E+01,1.2099E+01/
      DATA (KB(JT,59,11),JT=1,5) /
     &5.1187E+00,7.0446E+00,8.7908E+00,1.0434E+01,1.1861E+01/
      DATA (KB(JT,13,12),JT=1,5) /
     &8.5594E+01,8.5081E+01,8.4548E+01,8.3781E+01,8.2265E+01/
      DATA (KB(JT,14,12),JT=1,5) /
     &8.5160E+01,8.5106E+01,8.5561E+01,8.4404E+01,8.6474E+01/
      DATA (KB(JT,15,12),JT=1,5) /
     &8.6225E+01,8.6934E+01,8.6406E+01,8.7005E+01,8.9359E+01/
      DATA (KB(JT,16,12),JT=1,5) /
     &8.5430E+01,8.5513E+01,8.6639E+01,9.0490E+01,9.3290E+01/
      DATA (KB(JT,17,12),JT=1,5) /
     &8.2443E+01,8.4907E+01,8.8384E+01,9.0076E+01,9.1263E+01/
      DATA (KB(JT,18,12),JT=1,5) /
     &8.5149E+01,8.7540E+01,8.9291E+01,9.0823E+01,9.2775E+01/
      DATA (KB(JT,19,12),JT=1,5) /
     &8.8628E+01,9.0598E+01,9.2322E+01,9.4441E+01,9.6854E+01/
      DATA (KB(JT,20,12),JT=1,5) /
     &8.9356E+01,9.1085E+01,9.4127E+01,9.6914E+01,9.9051E+01/
      DATA (KB(JT,21,12),JT=1,5) /
     &8.7608E+01,9.1521E+01,9.5537E+01,9.7630E+01,9.9135E+01/
      DATA (KB(JT,22,12),JT=1,5) /
     &8.6703E+01,9.1359E+01,9.3725E+01,9.6097E+01,9.8620E+01/
      DATA (KB(JT,23,12),JT=1,5) /
     &8.4986E+01,8.8658E+01,9.1547E+01,9.4897E+01,9.8884E+01/
      DATA (KB(JT,24,12),JT=1,5) /
     &8.1861E+01,8.5495E+01,8.9569E+01,9.4335E+01,9.9177E+01/
      DATA (KB(JT,25,12),JT=1,5) /
     &7.8144E+01,8.2621E+01,8.8221E+01,9.4555E+01,9.9082E+01/
      DATA (KB(JT,26,12),JT=1,5) /
     &7.5558E+01,8.1550E+01,8.8515E+01,9.4800E+01,1.0018E+02/
      DATA (KB(JT,27,12),JT=1,5) /
     &7.4385E+01,8.1401E+01,8.8755E+01,9.4867E+01,9.9863E+01/
      DATA (KB(JT,28,12),JT=1,5) /
     &7.2786E+01,8.0630E+01,8.7375E+01,9.3177E+01,9.7577E+01/
      DATA (KB(JT,29,12),JT=1,5) /
     &7.2494E+01,7.9832E+01,8.6004E+01,9.1472E+01,9.7317E+01/
      DATA (KB(JT,30,12),JT=1,5) /
     &7.1849E+01,7.8701E+01,8.4991E+01,9.0891E+01,9.7338E+01/
      DATA (KB(JT,31,12),JT=1,5) /
     &7.1241E+01,7.7805E+01,8.4010E+01,9.1171E+01,1.0059E+02/
      DATA (KB(JT,32,12),JT=1,5) /
     &7.0698E+01,7.7293E+01,8.4547E+01,9.6001E+01,1.0686E+02/
      DATA (KB(JT,33,12),JT=1,5) /
     &7.0154E+01,7.8613E+01,9.0857E+01,1.0245E+02,1.1312E+02/
      DATA (KB(JT,34,12),JT=1,5) /
     &7.1031E+01,8.3561E+01,9.6187E+01,1.0815E+02,1.1901E+02/
      DATA (KB(JT,35,12),JT=1,5) /
     &7.5071E+01,8.8162E+01,1.0114E+02,1.1296E+02,1.2569E+02/
      DATA (KB(JT,36,12),JT=1,5) /
     &7.8029E+01,9.1692E+01,1.0504E+02,1.1849E+02,1.3079E+02/
      DATA (KB(JT,37,12),JT=1,5) /
     &7.7450E+01,9.1080E+01,1.0499E+02,1.1872E+02,1.3083E+02/
      DATA (KB(JT,38,12),JT=1,5) /
     &7.6390E+01,9.0295E+01,1.0451E+02,1.1896E+02,1.3094E+02/
      DATA (KB(JT,39,12),JT=1,5) /
     &7.4846E+01,8.9967E+01,1.0468E+02,1.1884E+02,1.3087E+02/
      DATA (KB(JT,40,12),JT=1,5) /
     &7.0636E+01,8.6765E+01,1.0145E+02,1.1588E+02,1.2805E+02/
      DATA (KB(JT,41,12),JT=1,5) /
     &6.6305E+01,8.2647E+01,9.8224E+01,1.1219E+02,1.2504E+02/
      DATA (KB(JT,42,12),JT=1,5) /
     &6.2198E+01,7.8258E+01,9.4811E+01,1.0862E+02,1.2155E+02/
      DATA (KB(JT,43,12),JT=1,5) /
     &5.7303E+01,7.2832E+01,8.9604E+01,1.0357E+02,1.1674E+02/
      DATA (KB(JT,44,12),JT=1,5) /
     &5.2689E+01,6.6907E+01,8.3558E+01,9.8406E+01,1.1125E+02/
      DATA (KB(JT,45,12),JT=1,5) /
     &4.8182E+01,6.1264E+01,7.7478E+01,9.3228E+01,1.0590E+02/
      DATA (KB(JT,46,12),JT=1,5) /
     &4.3386E+01,5.6258E+01,7.0871E+01,8.6833E+01,1.0102E+02/
      DATA (KB(JT,47,12),JT=1,5) /
     &3.8704E+01,5.0818E+01,6.4039E+01,7.9666E+01,9.5229E+01/
      DATA (KB(JT,48,12),JT=1,5) /
     &3.3968E+01,4.5364E+01,5.8393E+01,7.2512E+01,8.8396E+01/
      DATA (KB(JT,49,12),JT=1,5) /
     &2.9879E+01,4.0583E+01,5.2774E+01,6.5752E+01,8.1056E+01/
      DATA (KB(JT,50,12),JT=1,5) /
     &2.7602E+01,3.6039E+01,4.7664E+01,6.0460E+01,7.4304E+01/
      DATA (KB(JT,51,12),JT=1,5) /
     &2.6051E+01,3.1889E+01,4.2974E+01,5.5102E+01,6.8169E+01/
      DATA (KB(JT,52,12),JT=1,5) /
     &2.4438E+01,2.8876E+01,3.8469E+01,5.0102E+01,6.2912E+01/
      DATA (KB(JT,53,12),JT=1,5) /
     &2.2776E+01,2.7295E+01,3.4271E+01,4.5285E+01,5.7384E+01/
      DATA (KB(JT,54,12),JT=1,5) /
     &2.1249E+01,2.5821E+01,3.0686E+01,4.1216E+01,5.2669E+01/
      DATA (KB(JT,55,12),JT=1,5) /
     &2.0155E+01,2.4296E+01,2.8676E+01,3.7338E+01,4.8393E+01/
      DATA (KB(JT,56,12),JT=1,5) /
     &1.8949E+01,2.2808E+01,2.7284E+01,3.3732E+01,4.4387E+01/
      DATA (KB(JT,57,12),JT=1,5) /
     &1.7651E+01,2.1401E+01,2.5896E+01,3.0538E+01,4.0399E+01/
      DATA (KB(JT,58,12),JT=1,5) /
     &1.6454E+01,2.0257E+01,2.4400E+01,2.8791E+01,3.6888E+01/
      DATA (KB(JT,59,12),JT=1,5) /
     &1.6078E+01,1.9650E+01,2.3686E+01,2.8130E+01,3.5337E+01/
      DATA (KB(JT,13,13),JT=1,5) /
     &1.6179E+02,1.5851E+02,1.5620E+02,1.5532E+02,1.5316E+02/
      DATA (KB(JT,14,13),JT=1,5) /
     &1.7476E+02,1.7156E+02,1.7068E+02,1.6952E+02,1.6413E+02/
      DATA (KB(JT,15,13),JT=1,5) /
     &1.8520E+02,1.8372E+02,1.8384E+02,1.8019E+02,1.7522E+02/
      DATA (KB(JT,16,13),JT=1,5) /
     &1.9454E+02,1.9542E+02,1.9248E+02,1.8773E+02,1.8813E+02/
      DATA (KB(JT,17,13),JT=1,5) /
     &2.0028E+02,1.9793E+02,1.9596E+02,1.9785E+02,2.0205E+02/
      DATA (KB(JT,18,13),JT=1,5) /
     &1.9037E+02,1.9170E+02,1.9555E+02,2.0164E+02,2.0309E+02/
      DATA (KB(JT,19,13),JT=1,5) /
     &1.7958E+02,1.8623E+02,1.9196E+02,1.9543E+02,1.9670E+02/
      DATA (KB(JT,20,13),JT=1,5) /
     &1.7423E+02,1.8217E+02,1.8721E+02,1.9064E+02,1.9763E+02/
      DATA (KB(JT,21,13),JT=1,5) /
     &1.7205E+02,1.7751E+02,1.8259E+02,1.9102E+02,1.9985E+02/
      DATA (KB(JT,22,13),JT=1,5) /
     &1.7310E+02,1.7837E+02,1.8681E+02,1.9582E+02,2.0409E+02/
      DATA (KB(JT,23,13),JT=1,5) /
     &1.7691E+02,1.8432E+02,1.9387E+02,2.0103E+02,2.1026E+02/
      DATA (KB(JT,24,13),JT=1,5) /
     &1.8088E+02,1.8942E+02,1.9891E+02,2.0699E+02,2.1646E+02/
      DATA (KB(JT,25,13),JT=1,5) /
     &1.8492E+02,1.9434E+02,2.0408E+02,2.1437E+02,2.2277E+02/
      DATA (KB(JT,26,13),JT=1,5) /
     &1.8625E+02,1.9837E+02,2.0945E+02,2.1941E+02,2.3087E+02/
      DATA (KB(JT,27,13),JT=1,5) /
     &1.9010E+02,2.0364E+02,2.1615E+02,2.2715E+02,2.4079E+02/
      DATA (KB(JT,28,13),JT=1,5) /
     &1.9712E+02,2.1090E+02,2.2463E+02,2.3844E+02,2.5439E+02/
      DATA (KB(JT,29,13),JT=1,5) /
     &2.0453E+02,2.1990E+02,2.3570E+02,2.5241E+02,2.6509E+02/
      DATA (KB(JT,30,13),JT=1,5) /
     &2.1308E+02,2.3113E+02,2.4908E+02,2.6461E+02,2.7735E+02/
      DATA (KB(JT,31,13),JT=1,5) /
     &2.2395E+02,2.4239E+02,2.6296E+02,2.7710E+02,2.8754E+02/
      DATA (KB(JT,32,13),JT=1,5) /
     &2.3649E+02,2.5891E+02,2.7696E+02,2.8809E+02,2.9409E+02/
      DATA (KB(JT,33,13),JT=1,5) /
     &2.5295E+02,2.7352E+02,2.8553E+02,2.9364E+02,3.0036E+02/
      DATA (KB(JT,34,13),JT=1,5) /
     &2.6621E+02,2.8028E+02,2.9209E+02,2.9925E+02,3.0905E+02/
      DATA (KB(JT,35,13),JT=1,5) /
     &2.7274E+02,2.8720E+02,2.9678E+02,3.0598E+02,3.1573E+02/
      DATA (KB(JT,36,13),JT=1,5) /
     &2.7668E+02,2.9126E+02,3.0131E+02,3.1293E+02,3.2456E+02/
      DATA (KB(JT,37,13),JT=1,5) /
     &2.7566E+02,2.9125E+02,3.0241E+02,3.1513E+02,3.2636E+02/
      DATA (KB(JT,38,13),JT=1,5) /
     &2.7524E+02,2.9197E+02,3.0411E+02,3.1688E+02,3.2854E+02/
      DATA (KB(JT,39,13),JT=1,5) /
     &2.7502E+02,2.9241E+02,3.0488E+02,3.1825E+02,3.3122E+02/
      DATA (KB(JT,40,13),JT=1,5) /
     &2.7103E+02,2.8939E+02,3.0276E+02,3.1510E+02,3.2909E+02/
      DATA (KB(JT,41,13),JT=1,5) /
     &2.6612E+02,2.8502E+02,2.9924E+02,3.1164E+02,3.2628E+02/
      DATA (KB(JT,42,13),JT=1,5) /
     &2.6020E+02,2.7999E+02,2.9554E+02,3.0769E+02,3.2142E+02/
      DATA (KB(JT,43,13),JT=1,5) /
     &2.5242E+02,2.7289E+02,2.9079E+02,3.0394E+02,3.1657E+02/
      DATA (KB(JT,44,13),JT=1,5) /
     &2.4141E+02,2.6492E+02,2.8389E+02,2.9851E+02,3.1003E+02/
      DATA (KB(JT,45,13),JT=1,5) /
     &2.3199E+02,2.5697E+02,2.7534E+02,2.9238E+02,3.0488E+02/
      DATA (KB(JT,46,13),JT=1,5) /
     &2.2099E+02,2.4628E+02,2.6862E+02,2.8625E+02,2.9891E+02/
      DATA (KB(JT,47,13),JT=1,5) /
     &2.0813E+02,2.3515E+02,2.5936E+02,2.7698E+02,2.9245E+02/
      DATA (KB(JT,48,13),JT=1,5) /
     &1.9611E+02,2.2305E+02,2.4767E+02,2.6948E+02,2.8622E+02/
      DATA (KB(JT,49,13),JT=1,5) /
     &1.8313E+02,2.1047E+02,2.3654E+02,2.6025E+02,2.7775E+02/
      DATA (KB(JT,50,13),JT=1,5) /
     &1.6903E+02,1.9938E+02,2.2519E+02,2.4907E+02,2.7015E+02/
      DATA (KB(JT,51,13),JT=1,5) /
     &1.5421E+02,1.8800E+02,2.1428E+02,2.3876E+02,2.6215E+02/
      DATA (KB(JT,52,13),JT=1,5) /
     &1.4056E+02,1.7488E+02,2.0358E+02,2.2873E+02,2.5153E+02/
      DATA (KB(JT,53,13),JT=1,5) /
     &1.2774E+02,1.6089E+02,1.9159E+02,2.1758E+02,2.4063E+02/
      DATA (KB(JT,54,13),JT=1,5) /
     &1.1505E+02,1.4830E+02,1.8148E+02,2.0706E+02,2.3185E+02/
      DATA (KB(JT,55,13),JT=1,5) /
     &1.0455E+02,1.3680E+02,1.7009E+02,1.9749E+02,2.2149E+02/
      DATA (KB(JT,56,13),JT=1,5) /
     &9.5380E+01,1.2458E+02,1.5763E+02,1.8850E+02,2.1165E+02/
      DATA (KB(JT,57,13),JT=1,5) /
     &8.6328E+01,1.1370E+02,1.4580E+02,1.7843E+02,2.0341E+02/
      DATA (KB(JT,58,13),JT=1,5) /
     &7.7503E+01,1.0463E+02,1.3405E+02,1.6684E+02,1.9463E+02/
      DATA (KB(JT,59,13),JT=1,5) /
     &7.3613E+01,1.0087E+02,1.2946E+02,1.6169E+02,1.9043E+02/
      DATA (KB(JT,13,14),JT=1,5) /
     &2.3384E+02,2.3134E+02,2.2678E+02,2.2105E+02,2.2130E+02/
      DATA (KB(JT,14,14),JT=1,5) /
     &2.6370E+02,2.6091E+02,2.5467E+02,2.5118E+02,2.4954E+02/
      DATA (KB(JT,15,14),JT=1,5) /
     &2.9591E+02,2.9159E+02,2.8464E+02,2.8328E+02,2.7984E+02/
      DATA (KB(JT,16,14),JT=1,5) /
     &3.2944E+02,3.2156E+02,3.1816E+02,3.1521E+02,3.0449E+02/
      DATA (KB(JT,17,14),JT=1,5) /
     &3.5907E+02,3.5209E+02,3.5084E+02,3.4076E+02,3.2553E+02/
      DATA (KB(JT,18,14),JT=1,5) /
     &3.8932E+02,3.8700E+02,3.7610E+02,3.6121E+02,3.5570E+02/
      DATA (KB(JT,19,14),JT=1,5) /
     &4.2093E+02,4.0885E+02,3.9722E+02,3.9095E+02,3.9197E+02/
      DATA (KB(JT,20,14),JT=1,5) /
     &4.4653E+02,4.3247E+02,4.2391E+02,4.2574E+02,4.2089E+02/
      DATA (KB(JT,21,14),JT=1,5) /
     &4.6745E+02,4.5974E+02,4.5782E+02,4.5591E+02,4.4616E+02/
      DATA (KB(JT,22,14),JT=1,5) /
     &4.8396E+02,4.8410E+02,4.8532E+02,4.7987E+02,4.6662E+02/
      DATA (KB(JT,23,14),JT=1,5) /
     &5.0568E+02,5.0696E+02,5.0168E+02,4.9917E+02,4.8477E+02/
      DATA (KB(JT,24,14),JT=1,5) /
     &5.2372E+02,5.2925E+02,5.2568E+02,5.1576E+02,5.0916E+02/
      DATA (KB(JT,25,14),JT=1,5) /
     &5.4773E+02,5.4681E+02,5.4261E+02,5.3467E+02,5.2926E+02/
      DATA (KB(JT,26,14),JT=1,5) /
     &5.6992E+02,5.6525E+02,5.5986E+02,5.5383E+02,5.4189E+02/
      DATA (KB(JT,27,14),JT=1,5) /
     &5.8413E+02,5.7753E+02,5.7399E+02,5.6915E+02,5.5630E+02/
      DATA (KB(JT,28,14),JT=1,5) /
     &5.9410E+02,5.9489E+02,5.8870E+02,5.8276E+02,5.7225E+02/
      DATA (KB(JT,29,14),JT=1,5) /
     &6.0586E+02,6.0400E+02,6.0319E+02,5.9066E+02,5.8348E+02/
      DATA (KB(JT,30,14),JT=1,5) /
     &6.2023E+02,6.2112E+02,6.1269E+02,6.0507E+02,5.8831E+02/
      DATA (KB(JT,31,14),JT=1,5) /
     &6.3249E+02,6.3678E+02,6.2186E+02,6.1145E+02,5.9841E+02/
      DATA (KB(JT,32,14),JT=1,5) /
     &6.5129E+02,6.4085E+02,6.3065E+02,6.1664E+02,6.0677E+02/
      DATA (KB(JT,33,14),JT=1,5) /
     &6.5648E+02,6.4719E+02,6.3483E+02,6.2799E+02,6.1689E+02/
      DATA (KB(JT,34,14),JT=1,5) /
     &6.6261E+02,6.5214E+02,6.4542E+02,6.3852E+02,6.1993E+02/
      DATA (KB(JT,35,14),JT=1,5) /
     &6.7078E+02,6.6309E+02,6.5953E+02,6.4635E+02,6.1863E+02/
      DATA (KB(JT,36,14),JT=1,5) /
     &6.8510E+02,6.7944E+02,6.7467E+02,6.5682E+02,6.1696E+02/
      DATA (KB(JT,37,14),JT=1,5) /
     &6.9465E+02,6.8814E+02,6.8342E+02,6.6410E+02,6.2485E+02/
      DATA (KB(JT,38,14),JT=1,5) /
     &7.0151E+02,6.9441E+02,6.9017E+02,6.7086E+02,6.3205E+02/
      DATA (KB(JT,39,14),JT=1,5) /
     &7.0868E+02,7.0183E+02,6.9685E+02,6.7866E+02,6.3921E+02/
      DATA (KB(JT,40,14),JT=1,5) /
     &7.1075E+02,7.0438E+02,7.0305E+02,6.8866E+02,6.5105E+02/
      DATA (KB(JT,41,14),JT=1,5) /
     &7.0971E+02,7.0837E+02,7.0822E+02,6.9421E+02,6.5990E+02/
      DATA (KB(JT,42,14),JT=1,5) /
     &7.1142E+02,7.1113E+02,7.1018E+02,6.9720E+02,6.7342E+02/
      DATA (KB(JT,43,14),JT=1,5) /
     &7.1363E+02,7.1120E+02,7.0210E+02,7.0055E+02,6.8488E+02/
      DATA (KB(JT,44,14),JT=1,5) /
     &7.1148E+02,7.0646E+02,7.0565E+02,7.0398E+02,6.8877E+02/
      DATA (KB(JT,45,14),JT=1,5) /
     &7.0895E+02,7.0958E+02,7.0605E+02,6.9798E+02,6.9240E+02/
      DATA (KB(JT,46,14),JT=1,5) /
     &6.9950E+02,7.0866E+02,7.0226E+02,6.9819E+02,6.9658E+02/
      DATA (KB(JT,47,14),JT=1,5) /
     &6.8721E+02,7.0244E+02,7.0188E+02,6.9806E+02,6.9161E+02/
      DATA (KB(JT,48,14),JT=1,5) /
     &6.8035E+02,6.9565E+02,6.9976E+02,6.9387E+02,6.8913E+02/
      DATA (KB(JT,49,14),JT=1,5) /
     &6.6852E+02,6.8533E+02,6.9809E+02,6.9470E+02,6.8647E+02/
      DATA (KB(JT,50,14),JT=1,5) /
     &6.5815E+02,6.7824E+02,6.9156E+02,6.9473E+02,6.8677E+02/
      DATA (KB(JT,51,14),JT=1,5) /
     &6.5633E+02,6.6741E+02,6.8334E+02,6.9427E+02,6.8718E+02/
      DATA (KB(JT,52,14),JT=1,5) /
     &6.4799E+02,6.6007E+02,6.7742E+02,6.8641E+02,6.8886E+02/
      DATA (KB(JT,53,14),JT=1,5) /
     &6.3478E+02,6.5848E+02,6.6595E+02,6.8004E+02,6.8977E+02/
      DATA (KB(JT,54,14),JT=1,5) /
     &6.3075E+02,6.5140E+02,6.6048E+02,6.7510E+02,6.7898E+02/
      DATA (KB(JT,55,14),JT=1,5) /
     &6.2053E+02,6.3982E+02,6.5909E+02,6.6252E+02,6.7620E+02/
      DATA (KB(JT,56,14),JT=1,5) /
     &6.0488E+02,6.3692E+02,6.5472E+02,6.5961E+02,6.7144E+02/
      DATA (KB(JT,57,14),JT=1,5) /
     &5.9240E+02,6.2947E+02,6.4320E+02,6.5881E+02,6.5824E+02/
      DATA (KB(JT,58,14),JT=1,5) /
     &5.7619E+02,6.1537E+02,6.4199E+02,6.5527E+02,6.5777E+02/
      DATA (KB(JT,59,14),JT=1,5) /
     &5.7161E+02,6.1151E+02,6.3977E+02,6.4718E+02,6.5762E+02/
      DATA (KB(JT,13,15),JT=1,5) /
     &3.5083E+02,3.4274E+02,3.3588E+02,3.2964E+02,3.0980E+02/
      DATA (KB(JT,14,15),JT=1,5) /
     &4.0382E+02,3.9443E+02,3.8616E+02,3.7379E+02,3.5621E+02/
      DATA (KB(JT,15,15),JT=1,5) /
     &4.6271E+02,4.5170E+02,4.4204E+02,4.2053E+02,4.0520E+02/
      DATA (KB(JT,16,15),JT=1,5) /
     &5.2768E+02,5.1495E+02,4.9504E+02,4.7377E+02,4.6833E+02/
      DATA (KB(JT,17,15),JT=1,5) /
     &5.9879E+02,5.8378E+02,5.5161E+02,5.3753E+02,5.3799E+02/
      DATA (KB(JT,18,15),JT=1,5) /
     &6.7489E+02,6.3850E+02,6.1688E+02,6.0987E+02,5.7677E+02/
      DATA (KB(JT,19,15),JT=1,5) /
     &7.3779E+02,7.0513E+02,6.9510E+02,6.5830E+02,6.0487E+02/
      DATA (KB(JT,20,15),JT=1,5) /
     &8.1079E+02,7.9490E+02,7.5998E+02,6.9897E+02,6.4843E+02/
      DATA (KB(JT,21,15),JT=1,5) /
     &8.8426E+02,8.6003E+02,8.0304E+02,7.3384E+02,6.9837E+02/
      DATA (KB(JT,22,15),JT=1,5) /
     &9.6812E+02,9.1088E+02,8.3391E+02,7.8330E+02,7.5669E+02/
      DATA (KB(JT,23,15),JT=1,5) /
     &1.0128E+03,9.4218E+02,8.8720E+02,8.2530E+02,7.8833E+02/
      DATA (KB(JT,24,15),JT=1,5) /
     &1.0622E+03,9.7878E+02,9.1791E+02,8.7765E+02,7.9731E+02/
      DATA (KB(JT,25,15),JT=1,5) /
     &1.0853E+03,1.0245E+03,9.5328E+02,8.9340E+02,8.1721E+02/
      DATA (KB(JT,26,15),JT=1,5) /
     &1.1200E+03,1.0458E+03,9.9235E+02,9.0775E+02,8.4493E+02/
      DATA (KB(JT,27,15),JT=1,5) /
     &1.1556E+03,1.0812E+03,1.0090E+03,9.2343E+02,8.1758E+02/
      DATA (KB(JT,28,15),JT=1,5) /
     &1.1865E+03,1.1049E+03,1.0073E+03,9.1620E+02,7.7173E+02/
      DATA (KB(JT,29,15),JT=1,5) /
     &1.1906E+03,1.1065E+03,1.0028E+03,8.7527E+02,7.2650E+02/
      DATA (KB(JT,30,15),JT=1,5) /
     &1.1992E+03,1.0831E+03,9.6830E+02,8.1150E+02,6.8040E+02/
      DATA (KB(JT,31,15),JT=1,5) /
     &1.1794E+03,1.0618E+03,9.0601E+02,7.5400E+02,6.0274E+02/
      DATA (KB(JT,32,15),JT=1,5) /
     &1.1491E+03,9.9644E+02,8.3044E+02,6.7287E+02,5.1890E+02/
      DATA (KB(JT,33,15),JT=1,5) /
     &1.0978E+03,9.1760E+02,7.5228E+02,5.8187E+02,4.2649E+02/
      DATA (KB(JT,34,15),JT=1,5) /
     &1.0237E+03,8.4870E+02,6.6311E+02,4.9111E+02,3.3958E+02/
      DATA (KB(JT,35,15),JT=1,5) /
     &9.6010E+02,7.7009E+02,5.7949E+02,4.1414E+02,2.7668E+02/
      DATA (KB(JT,36,15),JT=1,5) /
     &9.0171E+02,7.0086E+02,5.0886E+02,3.3823E+02,2.2240E+02/
      DATA (KB(JT,37,15),JT=1,5) /
     &9.0464E+02,7.0259E+02,5.0334E+02,3.3120E+02,2.1250E+02/
      DATA (KB(JT,38,15),JT=1,5) /
     &9.1272E+02,7.0777E+02,5.0236E+02,3.2627E+02,2.0281E+02/
      DATA (KB(JT,39,15),JT=1,5) /
     &9.1592E+02,7.0699E+02,5.0029E+02,3.1832E+02,1.8984E+02/
      DATA (KB(JT,40,15),JT=1,5) /
     &9.7111E+02,7.5888E+02,5.4218E+02,3.5289E+02,2.1710E+02/
      DATA (KB(JT,41,15),JT=1,5) /
     &1.0392E+03,8.1334E+02,5.9329E+02,4.0507E+02,2.5679E+02/
      DATA (KB(JT,42,15),JT=1,5) /
     &1.1018E+03,8.7332E+02,6.5360E+02,4.6461E+02,2.9410E+02/
      DATA (KB(JT,43,15),JT=1,5) /
     &1.1780E+03,9.5750E+02,7.5295E+02,5.3640E+02,3.4968E+02/
      DATA (KB(JT,44,15),JT=1,5) /
     &1.2774E+03,1.0610E+03,8.3382E+02,6.1903E+02,4.3881E+02/
      DATA (KB(JT,45,15),JT=1,5) /
     &1.3696E+03,1.1411E+03,9.2825E+02,7.2390E+02,5.2087E+02/
      DATA (KB(JT,46,15),JT=1,5) /
     &1.4458E+03,1.2392E+03,1.0284E+03,8.1462E+02,6.0446E+02/
      DATA (KB(JT,47,15),JT=1,5) /
     &1.5185E+03,1.3558E+03,1.1323E+03,9.2353E+02,7.1923E+02/
      DATA (KB(JT,48,15),JT=1,5) /
     &1.5480E+03,1.4278E+03,1.2433E+03,1.0338E+03,8.2416E+02/
      DATA (KB(JT,49,15),JT=1,5) /
     &1.6321E+03,1.4959E+03,1.3391E+03,1.1340E+03,9.3754E+02/
      DATA (KB(JT,50,15),JT=1,5) /
     &1.7049E+03,1.5268E+03,1.4037E+03,1.2337E+03,1.0324E+03/
      DATA (KB(JT,51,15),JT=1,5) /
     &1.7473E+03,1.6024E+03,1.4662E+03,1.3130E+03,1.1235E+03/
      DATA (KB(JT,52,15),JT=1,5) /
     &1.7742E+03,1.6697E+03,1.4942E+03,1.3753E+03,1.2160E+03/
      DATA (KB(JT,53,15),JT=1,5) /
     &1.8257E+03,1.7098E+03,1.5772E+03,1.4297E+03,1.2866E+03/
      DATA (KB(JT,54,15),JT=1,5) /
     &1.8238E+03,1.7301E+03,1.6290E+03,1.4640E+03,1.3508E+03/
      DATA (KB(JT,55,15),JT=1,5) /
     &1.8598E+03,1.7789E+03,1.6666E+03,1.5389E+03,1.3930E+03/
      DATA (KB(JT,56,15),JT=1,5) /
     &1.9305E+03,1.7834E+03,1.6800E+03,1.5831E+03,1.4252E+03/
      DATA (KB(JT,57,15),JT=1,5) /
     &1.9902E+03,1.8099E+03,1.7296E+03,1.6197E+03,1.4994E+03/
      DATA (KB(JT,58,15),JT=1,5) /
     &2.0569E+03,1.8785E+03,1.7252E+03,1.6299E+03,1.5366E+03/
      DATA (KB(JT,59,15),JT=1,5) /
     &2.0792E+03,1.9024E+03,1.7290E+03,1.6559E+03,1.5493E+03/
      DATA (KB(JT,13,16),JT=1,5) /
     &5.7074E+02,5.5713E+02,5.4253E+02,5.2721E+02,5.1131E+02/
      DATA (KB(JT,14,16),JT=1,5) /
     &6.6774E+02,6.5027E+02,6.3161E+02,6.1261E+02,5.9377E+02/
      DATA (KB(JT,15,16),JT=1,5) /
     &7.7763E+02,7.5535E+02,7.3247E+02,7.0914E+02,6.8554E+02/
      DATA (KB(JT,16,16),JT=1,5) /
     &9.0056E+02,8.7306E+02,8.4456E+02,8.1516E+02,7.0895E+02/
      DATA (KB(JT,17,16),JT=1,5) /
     &1.0366E+03,1.0015E+03,9.6519E+02,8.8128E+02,7.1380E+02/
      DATA (KB(JT,18,16),JT=1,5) /
     &1.1817E+03,1.1369E+03,1.0597E+03,8.5644E+02,7.3707E+02/
      DATA (KB(JT,19,16),JT=1,5) /
     &1.3316E+03,1.2750E+03,1.0321E+03,8.8674E+02,7.7129E+02/
      DATA (KB(JT,20,16),JT=1,5) /
     &1.4803E+03,1.2710E+03,1.0855E+03,9.4408E+02,7.2356E+02/
      DATA (KB(JT,21,16),JT=1,5) /
     &1.6247E+03,1.3272E+03,1.1530E+03,9.8338E+02,6.9198E+02/
      DATA (KB(JT,22,16),JT=1,5) /
     &1.6008E+03,1.3778E+03,1.2081E+03,9.0370E+02,5.5641E+02/
      DATA (KB(JT,23,16),JT=1,5) /
     &1.6342E+03,1.4243E+03,1.1304E+03,8.5528E+02,4.9240E+02/
      DATA (KB(JT,24,16),JT=1,5) /
     &1.6690E+03,1.4128E+03,1.0773E+03,6.8055E+02,4.3204E+02/
      DATA (KB(JT,25,16),JT=1,5) /
     &1.6932E+03,1.3171E+03,9.9569E+02,5.6924E+02,2.7405E+02/
      DATA (KB(JT,26,16),JT=1,5) /
     &1.5997E+03,1.2565E+03,7.2147E+02,4.1508E+02,1.6363E+00/
      DATA (KB(JT,27,16),JT=1,5) /
     &1.4709E+03,1.0620E+03,5.5367E+02,1.6801E+02,1.7711E+00/
      DATA (KB(JT,28,16),JT=1,5) /
     &1.2868E+03,7.4225E+02,4.1091E+02,1.3979E+00,1.9138E+00/
      DATA (KB(JT,29,16),JT=1,5) /
     &1.1046E+03,5.7327E+02,1.1435E+02,1.5227E+00,2.0690E+00/
      DATA (KB(JT,30,16),JT=1,5) /
     &7.5951E+02,3.1070E+02,1.1800E+00,1.6572E+00,2.2234E+00/
      DATA (KB(JT,31,16),JT=1,5) /
     &5.2269E+02,8.9357E-01,1.2993E+00,1.7936E+00,2.3615E+00/
      DATA (KB(JT,32,16),JT=1,5) /
     &1.3504E+02,9.8754E-01,1.4263E+00,1.9479E+00,2.5792E+00/
      DATA (KB(JT,33,16),JT=1,5) /
     &7.3408E-01,1.0937E+00,1.5601E+00,2.1018E+00,2.7689E+00/
      DATA (KB(JT,34,16),JT=1,5) /
     &8.0973E-01,1.1916E+00,1.6719E+00,2.2462E+00,2.9376E+00/
      DATA (KB(JT,35,16),JT=1,5) /
     &8.5624E-01,1.2515E+00,1.7457E+00,2.3340E+00,3.0393E+00/
      DATA (KB(JT,36,16),JT=1,5) /
     &8.6582E-01,1.2640E+00,1.7620E+00,2.3537E+00,3.0624E+00/
      DATA (KB(JT,37,16),JT=1,5) /
     &8.2392E-01,1.2109E+00,1.6970E+00,2.2619E+00,2.9651E+00/
      DATA (KB(JT,38,16),JT=1,5) /
     &7.7820E-01,1.1515E+00,1.6284E+00,2.1818E+00,2.8537E+00/
      DATA (KB(JT,39,16),JT=1,5) /
     &7.3137E-01,1.0905E+00,1.5568E+00,2.1026E+00,2.7617E+00/
      DATA (KB(JT,40,16),JT=1,5) /
     &6.6113E-01,9.9827E-01,1.4324E+00,1.9599E+00,2.5782E+00/
      DATA (KB(JT,41,16),JT=1,5) /
     &5.8979E-01,9.0432E-01,1.3165E+00,1.8211E+00,2.4166E+00/
      DATA (KB(JT,42,16),JT=1,5) /
     &5.2189E-01,8.1262E-01,1.2033E+00,1.6872E+00,2.2584E+00/
      DATA (KB(JT,43,16),JT=1,5) /
     &4.5012E-01,7.1522E-01,1.0693E+00,1.5212E+00,2.0670E+00/
      DATA (KB(JT,44,16),JT=1,5) /
     &3.7946E-01,6.1667E-01,9.4312E-01,1.3624E+00,1.8770E+00/
      DATA (KB(JT,45,16),JT=1,5) /
     &3.1558E-01,5.2623E-01,8.0787E-01,1.2032E+00,1.6863E+00/
      DATA (KB(JT,46,16),JT=1,5) /
     &2.9590E+02,4.4343E-01,7.0619E-01,1.0578E+00,1.5068E+00/
      DATA (KB(JT,47,16),JT=1,5) /
     &7.2659E+02,3.5873E-01,5.9101E-01,9.0599E-01,1.3156E+00/
      DATA (KB(JT,48,16),JT=1,5) /
     &1.3181E+03,3.4672E+02,4.8767E-01,7.6683E-01,1.1370E+00/
      DATA (KB(JT,49,16),JT=1,5) /
     &1.6047E+03,7.6641E+02,7.0071E+01,6.4471E-01,9.8037E-01/
      DATA (KB(JT,50,16),JT=1,5) /
     &1.8848E+03,1.3103E+03,4.1613E+02,5.4100E-01,8.3899E-01/
      DATA (KB(JT,51,16),JT=1,5) /
     &2.2044E+03,1.5848E+03,7.6808E+02,1.1316E+02,7.2276E-01/
      DATA (KB(JT,52,16),JT=1,5) /
     &2.7162E+03,1.8452E+03,1.2957E+03,4.5829E+02,6.1559E-01/
      DATA (KB(JT,53,16),JT=1,5) /
     &3.1107E+03,2.1559E+03,1.5529E+03,8.4689E+02,1.7464E+02/
      DATA (KB(JT,54,16),JT=1,5) /
     &3.6955E+03,2.6522E+03,1.8196E+03,1.2866E+03,5.0615E+02/
      DATA (KB(JT,55,16),JT=1,5) /
     &4.0343E+03,2.9873E+03,2.0751E+03,1.5293E+03,8.5669E+02/
      DATA (KB(JT,56,16),JT=1,5) /
     &4.1921E+03,3.4914E+03,2.5653E+03,1.7745E+03,1.2881E+03/
      DATA (KB(JT,57,16),JT=1,5) /
     &4.3609E+03,3.8712E+03,2.9041E+03,2.0379E+03,1.5211E+03/
      DATA (KB(JT,58,16),JT=1,5) /
     &4.5313E+03,4.0098E+03,3.4243E+03,2.5213E+03,1.7627E+03/
      DATA (KB(JT,59,16),JT=1,5) /
     &4.6034E+03,4.0679E+03,3.6299E+03,2.7016E+03,1.9029E+03/

C     The array KA_Mxx contains the absorption coefficient for 
C     a minor species at the 16 chosen g-values for a reference pressure
C     level below 100~ mb.   The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.  The second index refers to temperature 
C     in 7.2 degree increments.  For instance, JT = 1 refers to a 
C     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
C     runs over the g-channel (1 to 16).

      DATA (KA_MN2O( 1,JT, 1),JT=1,19)  /
     & 5.41078e-02, 5.59051e-02, 5.77620e-02, 5.96805e-02, 6.16628e-02,
     & 6.37110e-02, 6.58272e-02, 6.80137e-02, 7.02728e-02, 7.26069e-02,
     & 7.50185e-02, 7.75103e-02, 8.00848e-02, 8.27449e-02, 8.54933e-02,
     & 8.83330e-02, 9.12670e-02, 9.42984e-02, 9.74306e-02/
      DATA (KA_MN2O( 2,JT, 1),JT=1,19)  /
     & 1.19602e-01, 1.22963e-01, 1.26417e-01, 1.29969e-01, 1.33621e-01,
     & 1.37375e-01, 1.41235e-01, 1.45203e-01, 1.49283e-01, 1.53477e-01,
     & 1.57789e-01, 1.62223e-01, 1.66780e-01, 1.71466e-01, 1.76284e-01,
     & 1.81237e-01, 1.86329e-01, 1.91564e-01, 1.96946e-01/
      DATA (KA_MN2O( 3,JT, 1),JT=1,19)  /
     & 1.49614e-01, 1.53427e-01, 1.57337e-01, 1.61346e-01, 1.65457e-01,
     & 1.69674e-01, 1.73997e-01, 1.78431e-01, 1.82978e-01, 1.87641e-01,
     & 1.92422e-01, 1.97325e-01, 2.02354e-01, 2.07510e-01, 2.12798e-01,
     & 2.18221e-01, 2.23781e-01, 2.29484e-01, 2.35331e-01/
      DATA (KA_MN2O( 4,JT, 1),JT=1,19)  /
     & 1.80029e-01, 1.84202e-01, 1.88472e-01, 1.92841e-01, 1.97311e-01,
     & 2.01884e-01, 2.06564e-01, 2.11352e-01, 2.16252e-01, 2.21264e-01,
     & 2.26393e-01, 2.31641e-01, 2.37010e-01, 2.42504e-01, 2.48126e-01,
     & 2.53877e-01, 2.59762e-01, 2.65783e-01, 2.71944e-01/
      DATA (KA_MN2O( 5,JT, 1),JT=1,19)  /
     & 2.08279e-01, 2.13029e-01, 2.17888e-01, 2.22858e-01, 2.27941e-01,
     & 2.33140e-01, 2.38458e-01, 2.43897e-01, 2.49460e-01, 2.55150e-01,
     & 2.60969e-01, 2.66922e-01, 2.73010e-01, 2.79237e-01, 2.85606e-01,
     & 2.92120e-01, 2.98783e-01, 3.05598e-01, 3.12568e-01/
      DATA (KA_MN2O( 6,JT, 1),JT=1,19)  /
     & 2.17336e-01, 2.22571e-01, 2.27931e-01, 2.33421e-01, 2.39043e-01,
     & 2.44801e-01, 2.50697e-01, 2.56735e-01, 2.62918e-01, 2.69251e-01,
     & 2.75735e-01, 2.82377e-01, 2.89178e-01, 2.96142e-01, 3.03275e-01,
     & 3.10579e-01, 3.18060e-01, 3.25720e-01, 3.33565e-01/
      DATA (KA_MN2O( 7,JT, 1),JT=1,19)  /
     & 2.23903e-01, 2.29349e-01, 2.34926e-01, 2.40640e-01, 2.46493e-01,
     & 2.52488e-01, 2.58628e-01, 2.64918e-01, 2.71361e-01, 2.77961e-01,
     & 2.84721e-01, 2.91646e-01, 2.98739e-01, 3.06005e-01, 3.13447e-01,
     & 3.21070e-01, 3.28879e-01, 3.36877e-01, 3.45071e-01/
      DATA (KA_MN2O( 8,JT, 1),JT=1,19)  /
     & 2.23400e-01, 2.28843e-01, 2.34418e-01, 2.40130e-01, 2.45980e-01,
     & 2.51973e-01, 2.58112e-01, 2.64401e-01, 2.70843e-01, 2.77442e-01,
     & 2.84202e-01, 2.91126e-01, 2.98219e-01, 3.05485e-01, 3.12928e-01,
     & 3.20552e-01, 3.28362e-01, 3.36362e-01, 3.44557e-01/
      DATA (KA_MN2O( 9,JT, 1),JT=1,19)  /
     & 1.89279e-01, 1.94423e-01, 1.99707e-01, 2.05135e-01, 2.10710e-01,
     & 2.16437e-01, 2.22319e-01, 2.28361e-01, 2.34568e-01, 2.40943e-01,
     & 2.47492e-01, 2.54218e-01, 2.61127e-01, 2.68224e-01, 2.75514e-01,
     & 2.83002e-01, 2.90694e-01, 2.98594e-01, 3.06709e-01/
      DATA (KA_MN2O( 1,JT, 2),JT=1,19)  /
     & 9.46669e-02, 9.77137e-02, 1.00858e-01, 1.04104e-01, 1.07455e-01,
     & 1.10913e-01, 1.14483e-01, 1.18167e-01, 1.21971e-01, 1.25896e-01,
     & 1.29948e-01, 1.34130e-01, 1.38447e-01, 1.42903e-01, 1.47502e-01,
     & 1.52249e-01, 1.57149e-01, 1.62207e-01, 1.67427e-01/
      DATA (KA_MN2O( 2,JT, 2),JT=1,19)  /
     & 5.11901e-01, 5.24950e-01, 5.38331e-01, 5.52053e-01, 5.66125e-01,
     & 5.80556e-01, 5.95354e-01, 6.10530e-01, 6.26093e-01, 6.42052e-01,
     & 6.58418e-01, 6.75202e-01, 6.92413e-01, 7.10062e-01, 7.28162e-01,
     & 7.46723e-01, 7.65758e-01, 7.85277e-01, 8.05294e-01/
      DATA (KA_MN2O( 3,JT, 2),JT=1,19)  /
     & 8.32946e-01, 8.45780e-01, 8.58813e-01, 8.72046e-01, 8.85482e-01,
     & 8.99126e-01, 9.12980e-01, 9.27048e-01, 9.41332e-01, 9.55837e-01,
     & 9.70565e-01, 9.85520e-01, 1.00070e+00, 1.01612e+00, 1.03178e+00,
     & 1.04768e+00, 1.06382e+00, 1.08021e+00, 1.09686e+00/
      DATA (KA_MN2O( 4,JT, 2),JT=1,19)  /
     & 1.04032e+00, 1.05475e+00, 1.06937e+00, 1.08419e+00, 1.09922e+00,
     & 1.11446e+00, 1.12991e+00, 1.14557e+00, 1.16145e+00, 1.17755e+00,
     & 1.19387e+00, 1.21042e+00, 1.22720e+00, 1.24421e+00, 1.26146e+00,
     & 1.27895e+00, 1.29668e+00, 1.31465e+00, 1.33287e+00/
      DATA (KA_MN2O( 5,JT, 2),JT=1,19)  /
     & 1.22685e+00, 1.24267e+00, 1.25870e+00, 1.27493e+00, 1.29137e+00,
     & 1.30803e+00, 1.32490e+00, 1.34199e+00, 1.35930e+00, 1.37683e+00,
     & 1.39459e+00, 1.41257e+00, 1.43079e+00, 1.44925e+00, 1.46794e+00,
     & 1.48687e+00, 1.50605e+00, 1.52547e+00, 1.54515e+00/
      DATA (KA_MN2O( 6,JT, 2),JT=1,19)  /
     & 1.53781e+00, 1.55206e+00, 1.56645e+00, 1.58097e+00, 1.59563e+00,
     & 1.61042e+00, 1.62535e+00, 1.64042e+00, 1.65562e+00, 1.67097e+00,
     & 1.68646e+00, 1.70210e+00, 1.71788e+00, 1.73380e+00, 1.74987e+00,
     & 1.76610e+00, 1.78247e+00, 1.79899e+00, 1.81567e+00/
      DATA (KA_MN2O( 7,JT, 2),JT=1,19)  /
     & 1.90476e+00, 1.91858e+00, 1.93251e+00, 1.94653e+00, 1.96065e+00,
     & 1.97488e+00, 1.98921e+00, 2.00365e+00, 2.01819e+00, 2.03283e+00,
     & 2.04758e+00, 2.06244e+00, 2.07741e+00, 2.09248e+00, 2.10767e+00,
     & 2.12296e+00, 2.13837e+00, 2.15388e+00, 2.16951e+00/
      DATA (KA_MN2O( 8,JT, 2),JT=1,19)  /
     & 2.38211e+00, 2.39819e+00, 2.41438e+00, 2.43068e+00, 2.44709e+00,
     & 2.46361e+00, 2.48024e+00, 2.49699e+00, 2.51384e+00, 2.53082e+00,
     & 2.54790e+00, 2.56510e+00, 2.58242e+00, 2.59985e+00, 2.61741e+00,
     & 2.63508e+00, 2.65287e+00, 2.67078e+00, 2.68881e+00/
      DATA (KA_MN2O( 9,JT, 2),JT=1,19)  /
     & 1.26464e+00, 1.28107e+00, 1.29772e+00, 1.31458e+00, 1.33166e+00,
     & 1.34896e+00, 1.36649e+00, 1.38424e+00, 1.40223e+00, 1.42044e+00,
     & 1.43890e+00, 1.45759e+00, 1.47653e+00, 1.49572e+00, 1.51515e+00,
     & 1.53483e+00, 1.55478e+00, 1.57498e+00, 1.59544e+00/
      DATA (KA_MN2O( 1,JT, 3),JT=1,19)  /
     & 1.50082e-01, 1.59095e-01, 1.68650e-01, 1.78779e-01, 1.89516e-01,
     & 2.00898e-01, 2.12963e-01, 2.25753e-01, 2.39311e-01, 2.53683e-01,
     & 2.68919e-01, 2.85069e-01, 3.02190e-01, 3.20339e-01, 3.39577e-01,
     & 3.59971e-01, 3.81590e-01, 4.04507e-01, 4.28801e-01/
      DATA (KA_MN2O( 2,JT, 3),JT=1,19)  /
     & 3.09551e+00, 3.09780e+00, 3.10008e+00, 3.10237e+00, 3.10466e+00,
     & 3.10695e+00, 3.10925e+00, 3.11154e+00, 3.11384e+00, 3.11614e+00,
     & 3.11844e+00, 3.12074e+00, 3.12305e+00, 3.12535e+00, 3.12766e+00,
     & 3.12997e+00, 3.13228e+00, 3.13459e+00, 3.13691e+00/
      DATA (KA_MN2O( 3,JT, 3),JT=1,19)  /
     & 4.42661e+00, 4.40858e+00, 4.39062e+00, 4.37274e+00, 4.35493e+00,
     & 4.33719e+00, 4.31953e+00, 4.30193e+00, 4.28441e+00, 4.26696e+00,
     & 4.24958e+00, 4.23227e+00, 4.21503e+00, 4.19787e+00, 4.18077e+00,
     & 4.16374e+00, 4.14678e+00, 4.12989e+00, 4.11307e+00/
      DATA (KA_MN2O( 4,JT, 3),JT=1,19)  /
     & 5.77864e+00, 5.74085e+00, 5.70331e+00, 5.66602e+00, 5.62897e+00,
     & 5.59216e+00, 5.55559e+00, 5.51926e+00, 5.48317e+00, 5.44731e+00,
     & 5.41169e+00, 5.37631e+00, 5.34115e+00, 5.30622e+00, 5.27152e+00,
     & 5.23705e+00, 5.20281e+00, 5.16879e+00, 5.13499e+00/
      DATA (KA_MN2O( 5,JT, 3),JT=1,19)  /
     & 7.17294e+00, 7.10890e+00, 7.04542e+00, 6.98251e+00, 6.92017e+00,
     & 6.85838e+00, 6.79714e+00, 6.73645e+00, 6.67630e+00, 6.61669e+00,
     & 6.55761e+00, 6.49905e+00, 6.44102e+00, 6.38351e+00, 6.32651e+00,
     & 6.27003e+00, 6.21404e+00, 6.15856e+00, 6.10357e+00/
      DATA (KA_MN2O( 6,JT, 3),JT=1,19)  /
     & 9.05082e+00, 8.96132e+00, 8.87271e+00, 8.78498e+00, 8.69811e+00,
     & 8.61210e+00, 8.52694e+00, 8.44262e+00, 8.35914e+00, 8.27648e+00,
     & 8.19464e+00, 8.11361e+00, 8.03338e+00, 7.95394e+00, 7.87529e+00,
     & 7.79742e+00, 7.72032e+00, 7.64398e+00, 7.56839e+00/
      DATA (KA_MN2O( 7,JT, 3),JT=1,19)  /
     & 1.18749e+01, 1.17648e+01, 1.16556e+01, 1.15475e+01, 1.14403e+01,
     & 1.13342e+01, 1.12290e+01, 1.11248e+01, 1.10216e+01, 1.09194e+01,
     & 1.08180e+01, 1.07177e+01, 1.06182e+01, 1.05197e+01, 1.04221e+01,
     & 1.03254e+01, 1.02296e+01, 1.01347e+01, 1.00407e+01/
      DATA (KA_MN2O( 8,JT, 3),JT=1,19)  /
     & 1.41428e+01, 1.40323e+01, 1.39227e+01, 1.38139e+01, 1.37060e+01,
     & 1.35989e+01, 1.34927e+01, 1.33873e+01, 1.32827e+01, 1.31790e+01,
     & 1.30760e+01, 1.29738e+01, 1.28725e+01, 1.27719e+01, 1.26722e+01,
     & 1.25732e+01, 1.24750e+01, 1.23775e+01, 1.22808e+01/
      DATA (KA_MN2O( 9,JT, 3),JT=1,19)  /
     & 7.34993e+00, 7.29335e+00, 7.23720e+00, 7.18149e+00, 7.12620e+00,
     & 7.07134e+00, 7.01690e+00, 6.96288e+00, 6.90928e+00, 6.85609e+00,
     & 6.80331e+00, 6.75094e+00, 6.69897e+00, 6.64739e+00, 6.59622e+00,
     & 6.54544e+00, 6.49505e+00, 6.44505e+00, 6.39543e+00/
      DATA (KA_MN2O( 1,JT, 4),JT=1,19)  /
     & 6.11248e-01, 6.37225e-01, 6.64306e-01, 6.92538e-01, 7.21970e-01,
     & 7.52653e-01, 7.84639e-01, 8.17985e-01, 8.52749e-01, 8.88989e-01,
     & 9.26770e-01, 9.66157e-01, 1.00722e+00, 1.05002e+00, 1.09465e+00,
     & 1.14117e+00, 1.18967e+00, 1.24022e+00, 1.29293e+00/
      DATA (KA_MN2O( 2,JT, 4),JT=1,19)  /
     & 5.07253e+00, 5.05299e+00, 5.03353e+00, 5.01414e+00, 4.99483e+00,
     & 4.97559e+00, 4.95642e+00, 4.93733e+00, 4.91831e+00, 4.89937e+00,
     & 4.88050e+00, 4.86170e+00, 4.84297e+00, 4.82432e+00, 4.80573e+00,
     & 4.78722e+00, 4.76878e+00, 4.75042e+00, 4.73212e+00/
      DATA (KA_MN2O( 3,JT, 4),JT=1,19)  /
     & 7.45829e+00, 7.42266e+00, 7.38719e+00, 7.35190e+00, 7.31677e+00,
     & 7.28181e+00, 7.24702e+00, 7.21240e+00, 7.17794e+00, 7.14364e+00,
     & 7.10951e+00, 7.07554e+00, 7.04173e+00, 7.00809e+00, 6.97461e+00,
     & 6.94128e+00, 6.90812e+00, 6.87511e+00, 6.84226e+00/
      DATA (KA_MN2O( 4,JT, 4),JT=1,19)  /
     & 9.58893e+00, 9.54796e+00, 9.50716e+00, 9.46654e+00, 9.42609e+00,
     & 9.38581e+00, 9.34571e+00, 9.30578e+00, 9.26602e+00, 9.22642e+00,
     & 9.18700e+00, 9.14775e+00, 9.10866e+00, 9.06974e+00, 9.03099e+00,
     & 8.99240e+00, 8.95398e+00, 8.91572e+00, 8.87762e+00/
      DATA (KA_MN2O( 5,JT, 4),JT=1,19)  /
     & 1.16344e+01, 1.16012e+01, 1.15681e+01, 1.15351e+01, 1.15022e+01,
     & 1.14694e+01, 1.14366e+01, 1.14040e+01, 1.13715e+01, 1.13390e+01,
     & 1.13067e+01, 1.12744e+01, 1.12422e+01, 1.12102e+01, 1.11782e+01,
     & 1.11463e+01, 1.11145e+01, 1.10828e+01, 1.10511e+01/
      DATA (KA_MN2O( 6,JT, 4),JT=1,19)  /
     & 1.12460e+01, 1.12402e+01, 1.12344e+01, 1.12286e+01, 1.12228e+01,
     & 1.12170e+01, 1.12112e+01, 1.12055e+01, 1.11997e+01, 1.11939e+01,
     & 1.11882e+01, 1.11824e+01, 1.11766e+01, 1.11709e+01, 1.11651e+01,
     & 1.11594e+01, 1.11536e+01, 1.11479e+01, 1.11421e+01/
      DATA (KA_MN2O( 7,JT, 4),JT=1,19)  /
     & 8.89265e+00, 8.91419e+00, 8.93578e+00, 8.95743e+00, 8.97913e+00,
     & 9.00088e+00, 9.02268e+00, 9.04454e+00, 9.06645e+00, 9.08841e+00,
     & 9.11043e+00, 9.13250e+00, 9.15462e+00, 9.17680e+00, 9.19903e+00,
     & 9.22131e+00, 9.24365e+00, 9.26604e+00, 9.28849e+00/
      DATA (KA_MN2O( 8,JT, 4),JT=1,19)  /
     & 6.83933e+00, 6.86688e+00, 6.89453e+00, 6.92230e+00, 6.95018e+00,
     & 6.97817e+00, 7.00627e+00, 7.03449e+00, 7.06282e+00, 7.09126e+00,
     & 7.11982e+00, 7.14850e+00, 7.17729e+00, 7.20619e+00, 7.23521e+00,
     & 7.26435e+00, 7.29361e+00, 7.32298e+00, 7.35248e+00/
      DATA (KA_MN2O( 9,JT, 4),JT=1,19)  /
     & 1.10637e+01, 1.10232e+01, 1.09829e+01, 1.09427e+01, 1.09026e+01,
     & 1.08627e+01, 1.08230e+01, 1.07833e+01, 1.07439e+01, 1.07046e+01,
     & 1.06654e+01, 1.06263e+01, 1.05875e+01, 1.05487e+01, 1.05101e+01,
     & 1.04716e+01, 1.04333e+01, 1.03951e+01, 1.03571e+01/
      DATA (KA_MN2O( 1,JT, 5),JT=1,19)  /
     & 2.53460e+00, 2.56050e+00, 2.58667e+00, 2.61310e+00, 2.63980e+00,
     & 2.66678e+00, 2.69403e+00, 2.72156e+00, 2.74937e+00, 2.77746e+00,
     & 2.80585e+00, 2.83452e+00, 2.86348e+00, 2.89275e+00, 2.92231e+00,
     & 2.95217e+00, 2.98234e+00, 3.01281e+00, 3.04360e+00/
      DATA (KA_MN2O( 2,JT, 5),JT=1,19)  /
     & 7.45650e+00, 7.44283e+00, 7.42919e+00, 7.41557e+00, 7.40198e+00,
     & 7.38841e+00, 7.37487e+00, 7.36135e+00, 7.34786e+00, 7.33439e+00,
     & 7.32095e+00, 7.30753e+00, 7.29413e+00, 7.28076e+00, 7.26742e+00,
     & 7.25410e+00, 7.24080e+00, 7.22753e+00, 7.21428e+00/
      DATA (KA_MN2O( 3,JT, 5),JT=1,19)  /
     & 1.06311e+01, 1.06110e+01, 1.05909e+01, 1.05709e+01, 1.05509e+01,
     & 1.05310e+01, 1.05111e+01, 1.04912e+01, 1.04713e+01, 1.04516e+01,
     & 1.04318e+01, 1.04121e+01, 1.03924e+01, 1.03727e+01, 1.03531e+01,
     & 1.03336e+01, 1.03140e+01, 1.02945e+01, 1.02751e+01/
      DATA (KA_MN2O( 4,JT, 5),JT=1,19)  /
     & 1.03924e+01, 1.03895e+01, 1.03867e+01, 1.03838e+01, 1.03809e+01,
     & 1.03780e+01, 1.03751e+01, 1.03722e+01, 1.03693e+01, 1.03665e+01,
     & 1.03636e+01, 1.03607e+01, 1.03578e+01, 1.03549e+01, 1.03521e+01,
     & 1.03492e+01, 1.03463e+01, 1.03434e+01, 1.03406e+01/
      DATA (KA_MN2O( 5,JT, 5),JT=1,19)  /
     & 7.82277e+00, 7.83872e+00, 7.85471e+00, 7.87073e+00, 7.88678e+00,
     & 7.90287e+00, 7.91899e+00, 7.93514e+00, 7.95132e+00, 7.96754e+00,
     & 7.98379e+00, 8.00008e+00, 8.01639e+00, 8.03274e+00, 8.04913e+00,
     & 8.06555e+00, 8.08200e+00, 8.09848e+00, 8.11500e+00/
      DATA (KA_MN2O( 6,JT, 5),JT=1,19)  /
     & 6.05225e+00, 6.06883e+00, 6.08545e+00, 6.10212e+00, 6.11883e+00,
     & 6.13559e+00, 6.15240e+00, 6.16925e+00, 6.18615e+00, 6.20309e+00,
     & 6.22008e+00, 6.23712e+00, 6.25420e+00, 6.27133e+00, 6.28851e+00,
     & 6.30574e+00, 6.32301e+00, 6.34033e+00, 6.35769e+00/
      DATA (KA_MN2O( 7,JT, 5),JT=1,19)  /
     & 5.24135e+00, 5.25696e+00, 5.27261e+00, 5.28831e+00, 5.30405e+00,
     & 5.31984e+00, 5.33568e+00, 5.35157e+00, 5.36750e+00, 5.38348e+00,
     & 5.39951e+00, 5.41558e+00, 5.43171e+00, 5.44788e+00, 5.46410e+00,
     & 5.48037e+00, 5.49668e+00, 5.51305e+00, 5.52946e+00/
      DATA (KA_MN2O( 8,JT, 5),JT=1,19)  /
     & 4.40240e+00, 4.40915e+00, 4.41591e+00, 4.42268e+00, 4.42946e+00,
     & 4.43625e+00, 4.44305e+00, 4.44986e+00, 4.45668e+00, 4.46351e+00,
     & 4.47035e+00, 4.47720e+00, 4.48407e+00, 4.49094e+00, 4.49782e+00,
     & 4.50472e+00, 4.51162e+00, 4.51854e+00, 4.52547e+00/
      DATA (KA_MN2O( 9,JT, 5),JT=1,19)  /
     & 8.56554e+00, 8.59185e+00, 8.61824e+00, 8.64470e+00, 8.67125e+00,
     & 8.69788e+00, 8.72460e+00, 8.75139e+00, 8.77827e+00, 8.80523e+00,
     & 8.83227e+00, 8.85939e+00, 8.88660e+00, 8.91389e+00, 8.94127e+00,
     & 8.96873e+00, 8.99627e+00, 9.02390e+00, 9.05161e+00/
      DATA (KA_MN2O( 1,JT, 6),JT=1,19)  /
     & 5.78695e+00, 5.78939e+00, 5.79182e+00, 5.79426e+00, 5.79670e+00,
     & 5.79914e+00, 5.80158e+00, 5.80403e+00, 5.80647e+00, 5.80892e+00,
     & 5.81136e+00, 5.81381e+00, 5.81626e+00, 5.81870e+00, 5.82115e+00,
     & 5.82361e+00, 5.82606e+00, 5.82851e+00, 5.83096e+00/
      DATA (KA_MN2O( 2,JT, 6),JT=1,19)  /
     & 1.22893e+01, 1.22556e+01, 1.22221e+01, 1.21886e+01, 1.21552e+01,
     & 1.21220e+01, 1.20888e+01, 1.20557e+01, 1.20227e+01, 1.19898e+01,
     & 1.19569e+01, 1.19242e+01, 1.18915e+01, 1.18590e+01, 1.18265e+01,
     & 1.17941e+01, 1.17618e+01, 1.17296e+01, 1.16975e+01/
      DATA (KA_MN2O( 3,JT, 6),JT=1,19)  /
     & 7.93118e+00, 7.94590e+00, 7.96065e+00, 7.97542e+00, 7.99022e+00,
     & 8.00505e+00, 8.01990e+00, 8.03478e+00, 8.04970e+00, 8.06463e+00,
     & 8.07960e+00, 8.09459e+00, 8.10961e+00, 8.12466e+00, 8.13974e+00,
     & 8.15485e+00, 8.16998e+00, 8.18514e+00, 8.20033e+00/
      DATA (KA_MN2O( 4,JT, 6),JT=1,19)  /
     & 4.08899e+00, 4.11435e+00, 4.13988e+00, 4.16556e+00, 4.19140e+00,
     & 4.21740e+00, 4.24357e+00, 4.26989e+00, 4.29638e+00, 4.32304e+00,
     & 4.34985e+00, 4.37684e+00, 4.40399e+00, 4.43131e+00, 4.45880e+00,
     & 4.48646e+00, 4.51430e+00, 4.54230e+00, 4.57048e+00/
      DATA (KA_MN2O( 5,JT, 6),JT=1,19)  /
     & 2.61358e+00, 2.64029e+00, 2.66728e+00, 2.69454e+00, 2.72209e+00,
     & 2.74991e+00, 2.77802e+00, 2.80641e+00, 2.83510e+00, 2.86408e+00,
     & 2.89335e+00, 2.92293e+00, 2.95280e+00, 2.98299e+00, 3.01348e+00,
     & 3.04428e+00, 3.07540e+00, 3.10683e+00, 3.13859e+00/
      DATA (KA_MN2O( 6,JT, 6),JT=1,19)  /
     & 2.40720e+00, 2.43430e+00, 2.46169e+00, 2.48940e+00, 2.51741e+00,
     & 2.54575e+00, 2.57440e+00, 2.60337e+00, 2.63267e+00, 2.66230e+00,
     & 2.69226e+00, 2.72256e+00, 2.75320e+00, 2.78419e+00, 2.81552e+00,
     & 2.84721e+00, 2.87925e+00, 2.91166e+00, 2.94443e+00/
      DATA (KA_MN2O( 7,JT, 6),JT=1,19)  /
     & 1.99607e+00, 2.01725e+00, 2.03865e+00, 2.06028e+00, 2.08214e+00,
     & 2.10423e+00, 2.12655e+00, 2.14912e+00, 2.17192e+00, 2.19496e+00,
     & 2.21825e+00, 2.24179e+00, 2.26557e+00, 2.28961e+00, 2.31390e+00,
     & 2.33845e+00, 2.36326e+00, 2.38834e+00, 2.41368e+00/
      DATA (KA_MN2O( 8,JT, 6),JT=1,19)  /
     & 1.94150e+00, 1.96398e+00, 1.98671e+00, 2.00971e+00, 2.03298e+00,
     & 2.05651e+00, 2.08032e+00, 2.10440e+00, 2.12876e+00, 2.15341e+00,
     & 2.17834e+00, 2.20355e+00, 2.22906e+00, 2.25487e+00, 2.28097e+00,
     & 2.30738e+00, 2.33409e+00, 2.36111e+00, 2.38844e+00/
      DATA (KA_MN2O( 9,JT, 6),JT=1,19)  /
     & 2.47259e+00, 2.48950e+00, 2.50653e+00, 2.52367e+00, 2.54093e+00,
     & 2.55831e+00, 2.57581e+00, 2.59343e+00, 2.61117e+00, 2.62903e+00,
     & 2.64701e+00, 2.66511e+00, 2.68334e+00, 2.70169e+00, 2.72017e+00,
     & 2.73878e+00, 2.75751e+00, 2.77637e+00, 2.79536e+00/
      DATA (KA_MN2O( 1,JT, 7),JT=1,19)  /
     & 1.23417e+01, 1.22618e+01, 1.21823e+01, 1.21034e+01, 1.20250e+01,
     & 1.19471e+01, 1.18697e+01, 1.17928e+01, 1.17164e+01, 1.16405e+01,
     & 1.15651e+01, 1.14901e+01, 1.14157e+01, 1.13417e+01, 1.12683e+01,
     & 1.11952e+01, 1.11227e+01, 1.10507e+01, 1.09791e+01/
      DATA (KA_MN2O( 2,JT, 7),JT=1,19)  /
     & 9.30957e+00, 9.32775e+00, 9.34597e+00, 9.36421e+00, 9.38250e+00,
     & 9.40082e+00, 9.41918e+00, 9.43757e+00, 9.45600e+00, 9.47446e+00,
     & 9.49296e+00, 9.51150e+00, 9.53007e+00, 9.54868e+00, 9.56732e+00,
     & 9.58601e+00, 9.60472e+00, 9.62348e+00, 9.64227e+00/
      DATA (KA_MN2O( 3,JT, 7),JT=1,19)  /
     & 4.15867e+00, 4.19254e+00, 4.22668e+00, 4.26110e+00, 4.29581e+00,
     & 4.33079e+00, 4.36606e+00, 4.40162e+00, 4.43747e+00, 4.47360e+00,
     & 4.51004e+00, 4.54677e+00, 4.58380e+00, 4.62113e+00, 4.65876e+00,
     & 4.69670e+00, 4.73495e+00, 4.77351e+00, 4.81239e+00/
      DATA (KA_MN2O( 4,JT, 7),JT=1,19)  /
     & 3.55634e+00, 3.59382e+00, 3.63169e+00, 3.66996e+00, 3.70863e+00,
     & 3.74771e+00, 3.78720e+00, 3.82711e+00, 3.86744e+00, 3.90820e+00,
     & 3.94938e+00, 3.99100e+00, 4.03305e+00, 4.07555e+00, 4.11850e+00,
     & 4.16190e+00, 4.20576e+00, 4.25008e+00, 4.29486e+00/
      DATA (KA_MN2O( 5,JT, 7),JT=1,19)  /
     & 3.09468e+00, 3.12655e+00, 3.15876e+00, 3.19129e+00, 3.22416e+00,
     & 3.25737e+00, 3.29092e+00, 3.32482e+00, 3.35907e+00, 3.39366e+00,
     & 3.42862e+00, 3.46393e+00, 3.49961e+00, 3.53566e+00, 3.57208e+00,
     & 3.60887e+00, 3.64604e+00, 3.68360e+00, 3.72154e+00/
      DATA (KA_MN2O( 6,JT, 7),JT=1,19)  /
     & 2.75473e+00, 2.78356e+00, 2.81268e+00, 2.84211e+00, 2.87185e+00,
     & 2.90190e+00, 2.93227e+00, 2.96295e+00, 2.99395e+00, 3.02528e+00,
     & 3.05694e+00, 3.08892e+00, 3.12125e+00, 3.15391e+00, 3.18691e+00,
     & 3.22025e+00, 3.25395e+00, 3.28800e+00, 3.32240e+00/
      DATA (KA_MN2O( 7,JT, 7),JT=1,19)  /
     & 2.68587e+00, 2.71431e+00, 2.74306e+00, 2.77211e+00, 2.80146e+00,
     & 2.83113e+00, 2.86111e+00, 2.89141e+00, 2.92203e+00, 2.95298e+00,
     & 2.98425e+00, 3.01585e+00, 3.04779e+00, 3.08006e+00, 3.11268e+00,
     & 3.14564e+00, 3.17896e+00, 3.21262e+00, 3.24664e+00/
      DATA (KA_MN2O( 8,JT, 7),JT=1,19)  /
     & 2.54778e+00, 2.57461e+00, 2.60173e+00, 2.62914e+00, 2.65683e+00,
     & 2.68482e+00, 2.71310e+00, 2.74168e+00, 2.77056e+00, 2.79974e+00,
     & 2.82923e+00, 2.85903e+00, 2.88915e+00, 2.91958e+00, 2.95033e+00,
     & 2.98141e+00, 3.01282e+00, 3.04455e+00, 3.07662e+00/
      DATA (KA_MN2O( 9,JT, 7),JT=1,19)  /
     & 2.78137e+00, 2.80957e+00, 2.83805e+00, 2.86682e+00, 2.89589e+00,
     & 2.92525e+00, 2.95491e+00, 2.98486e+00, 3.01512e+00, 3.04569e+00,
     & 3.07657e+00, 3.10776e+00, 3.13927e+00, 3.17110e+00, 3.20324e+00,
     & 3.23572e+00, 3.26852e+00, 3.30166e+00, 3.33513e+00/
      DATA (KA_MN2O( 1,JT, 8),JT=1,19)  /
     & 2.28384e+01, 2.27450e+01, 2.26519e+01, 2.25593e+01, 2.24670e+01,
     & 2.23751e+01, 2.22835e+01, 2.21924e+01, 2.21016e+01, 2.20112e+01,
     & 2.19211e+01, 2.18314e+01, 2.17421e+01, 2.16532e+01, 2.15646e+01,
     & 2.14764e+01, 2.13885e+01, 2.13010e+01, 2.12139e+01/
      DATA (KA_MN2O( 2,JT, 8),JT=1,19)  /
     & 4.48608e+00, 4.52259e+00, 4.55939e+00, 4.59649e+00, 4.63389e+00,
     & 4.67160e+00, 4.70961e+00, 4.74793e+00, 4.78656e+00, 4.82551e+00,
     & 4.86478e+00, 4.90436e+00, 4.94427e+00, 4.98450e+00, 5.02506e+00,
     & 5.06595e+00, 5.10717e+00, 5.14873e+00, 5.19062e+00/
      DATA (KA_MN2O( 3,JT, 8),JT=1,19)  /
     & 3.69928e+00, 3.72584e+00, 3.75259e+00, 3.77953e+00, 3.80666e+00,
     & 3.83399e+00, 3.86152e+00, 3.88924e+00, 3.91717e+00, 3.94529e+00,
     & 3.97361e+00, 4.00214e+00, 4.03088e+00, 4.05982e+00, 4.08896e+00,
     & 4.11832e+00, 4.14789e+00, 4.17767e+00, 4.20766e+00/
      DATA (KA_MN2O( 4,JT, 8),JT=1,19)  /
     & 3.17856e+00, 3.19596e+00, 3.21345e+00, 3.23104e+00, 3.24872e+00,
     & 3.26650e+00, 3.28437e+00, 3.30235e+00, 3.32042e+00, 3.33859e+00,
     & 3.35686e+00, 3.37523e+00, 3.39370e+00, 3.41227e+00, 3.43095e+00,
     & 3.44972e+00, 3.46860e+00, 3.48758e+00, 3.50667e+00/
      DATA (KA_MN2O( 5,JT, 8),JT=1,19)  /
     & 3.16549e+00, 3.18288e+00, 3.20037e+00, 3.21795e+00, 3.23563e+00,
     & 3.25340e+00, 3.27128e+00, 3.28925e+00, 3.30732e+00, 3.32549e+00,
     & 3.34376e+00, 3.36213e+00, 3.38060e+00, 3.39917e+00, 3.41785e+00,
     & 3.43662e+00, 3.45551e+00, 3.47449e+00, 3.49358e+00/
      DATA (KA_MN2O( 6,JT, 8),JT=1,19)  /
     & 3.16612e+00, 3.18355e+00, 3.20108e+00, 3.21870e+00, 3.23643e+00,
     & 3.25425e+00, 3.27217e+00, 3.29018e+00, 3.30830e+00, 3.32652e+00,
     & 3.34483e+00, 3.36325e+00, 3.38177e+00, 3.40039e+00, 3.41911e+00,
     & 3.43794e+00, 3.45687e+00, 3.47591e+00, 3.49505e+00/
      DATA (KA_MN2O( 7,JT, 8),JT=1,19)  /
     & 3.19644e+00, 3.21419e+00, 3.23203e+00, 3.24996e+00, 3.26800e+00,
     & 3.28614e+00, 3.30438e+00, 3.32272e+00, 3.34116e+00, 3.35970e+00,
     & 3.37835e+00, 3.39710e+00, 3.41596e+00, 3.43492e+00, 3.45398e+00,
     & 3.47315e+00, 3.49243e+00, 3.51181e+00, 3.53130e+00/
      DATA (KA_MN2O( 8,JT, 8),JT=1,19)  /
     & 3.35759e+00, 3.37775e+00, 3.39804e+00, 3.41845e+00, 3.43899e+00,
     & 3.45964e+00, 3.48042e+00, 3.50133e+00, 3.52236e+00, 3.54351e+00,
     & 3.56480e+00, 3.58621e+00, 3.60775e+00, 3.62942e+00, 3.65122e+00,
     & 3.67315e+00, 3.69521e+00, 3.71741e+00, 3.73974e+00/
      DATA (KA_MN2O( 9,JT, 8),JT=1,19)  /
     & 3.17378e+00, 3.19135e+00, 3.20901e+00, 3.22677e+00, 3.24462e+00,
     & 3.26258e+00, 3.28063e+00, 3.29879e+00, 3.31704e+00, 3.33540e+00,
     & 3.35386e+00, 3.37242e+00, 3.39108e+00, 3.40984e+00, 3.42871e+00,
     & 3.44769e+00, 3.46677e+00, 3.48595e+00, 3.50524e+00/
      DATA (KA_MN2O( 1,JT, 9),JT=1,19)  /
     & 2.09106e+01, 2.08779e+01, 2.08452e+01, 2.08126e+01, 2.07800e+01,
     & 2.07475e+01, 2.07150e+01, 2.06826e+01, 2.06502e+01, 2.06179e+01,
     & 2.05856e+01, 2.05534e+01, 2.05213e+01, 2.04891e+01, 2.04571e+01,
     & 2.04251e+01, 2.03931e+01, 2.03612e+01, 2.03293e+01/
      DATA (KA_MN2O( 2,JT, 9),JT=1,19)  /
     & 2.60494e+00, 2.62757e+00, 2.65040e+00, 2.67343e+00, 2.69665e+00,
     & 2.72008e+00, 2.74372e+00, 2.76756e+00, 2.79160e+00, 2.81586e+00,
     & 2.84032e+00, 2.86500e+00, 2.88989e+00, 2.91500e+00, 2.94033e+00,
     & 2.96588e+00, 2.99164e+00, 3.01764e+00, 3.04386e+00/
      DATA (KA_MN2O( 3,JT, 9),JT=1,19)  /
     & 2.42238e+00, 2.44514e+00, 2.46811e+00, 2.49130e+00, 2.51471e+00,
     & 2.53834e+00, 2.56219e+00, 2.58626e+00, 2.61056e+00, 2.63509e+00,
     & 2.65985e+00, 2.68484e+00, 2.71007e+00, 2.73554e+00, 2.76124e+00,
     & 2.78718e+00, 2.81337e+00, 2.83981e+00, 2.86649e+00/
      DATA (KA_MN2O( 4,JT, 9),JT=1,19)  /
     & 2.33681e+00, 2.35961e+00, 2.38263e+00, 2.40588e+00, 2.42935e+00,
     & 2.45305e+00, 2.47699e+00, 2.50115e+00, 2.52556e+00, 2.55020e+00,
     & 2.57508e+00, 2.60021e+00, 2.62558e+00, 2.65119e+00, 2.67706e+00,
     & 2.70318e+00, 2.72955e+00, 2.75619e+00, 2.78308e+00/
      DATA (KA_MN2O( 5,JT, 9),JT=1,19)  /
     & 2.26420e+00, 2.28696e+00, 2.30996e+00, 2.33319e+00, 2.35665e+00,
     & 2.38035e+00, 2.40429e+00, 2.42846e+00, 2.45288e+00, 2.47755e+00,
     & 2.50246e+00, 2.52763e+00, 2.55304e+00, 2.57871e+00, 2.60465e+00,
     & 2.63084e+00, 2.65729e+00, 2.68401e+00, 2.71100e+00/
      DATA (KA_MN2O( 6,JT, 9),JT=1,19)  /
     & 2.19628e+00, 2.21902e+00, 2.24199e+00, 2.26520e+00, 2.28865e+00,
     & 2.31234e+00, 2.33628e+00, 2.36047e+00, 2.38491e+00, 2.40959e+00,
     & 2.43454e+00, 2.45974e+00, 2.48521e+00, 2.51094e+00, 2.53693e+00,
     & 2.56319e+00, 2.58973e+00, 2.61654e+00, 2.64363e+00/
      DATA (KA_MN2O( 7,JT, 9),JT=1,19)  /
     & 2.07829e+00, 2.10090e+00, 2.12375e+00, 2.14685e+00, 2.17021e+00,
     & 2.19381e+00, 2.21767e+00, 2.24180e+00, 2.26618e+00, 2.29083e+00,
     & 2.31575e+00, 2.34094e+00, 2.36640e+00, 2.39214e+00, 2.41816e+00,
     & 2.44446e+00, 2.47105e+00, 2.49793e+00, 2.52510e+00/
      DATA (KA_MN2O( 8,JT, 9),JT=1,19)  /
     & 1.68230e+00, 1.70305e+00, 1.72404e+00, 1.74530e+00, 1.76681e+00,
     & 1.78860e+00, 1.81065e+00, 1.83297e+00, 1.85557e+00, 1.87845e+00,
     & 1.90161e+00, 1.92505e+00, 1.94878e+00, 1.97281e+00, 1.99713e+00,
     & 2.02176e+00, 2.04668e+00, 2.07191e+00, 2.09746e+00/
      DATA (KA_MN2O( 9,JT, 9),JT=1,19)  /
     & 2.23224e+00, 2.25486e+00, 2.27771e+00, 2.30079e+00, 2.32411e+00,
     & 2.34766e+00, 2.37145e+00, 2.39548e+00, 2.41975e+00, 2.44427e+00,
     & 2.46904e+00, 2.49406e+00, 2.51933e+00, 2.54486e+00, 2.57065e+00,
     & 2.59670e+00, 2.62301e+00, 2.64959e+00, 2.67644e+00/
      DATA (KA_MN2O( 1,JT,10),JT=1,19)  /
     & 1.30711e+01, 1.31853e+01, 1.33004e+01, 1.34166e+01, 1.35339e+01,
     & 1.36521e+01, 1.37714e+01, 1.38917e+01, 1.40130e+01, 1.41355e+01,
     & 1.42590e+01, 1.43835e+01, 1.45092e+01, 1.46360e+01, 1.47638e+01,
     & 1.48928e+01, 1.50229e+01, 1.51542e+01, 1.52866e+01/
      DATA (KA_MN2O( 2,JT,10),JT=1,19)  /
     & 2.71206e-01, 2.90148e-01, 3.10413e-01, 3.32093e-01, 3.55287e-01,
     & 3.80102e-01, 4.06649e-01, 4.35051e-01, 4.65436e-01, 4.97943e-01,
     & 5.32721e-01, 5.69928e-01, 6.09733e-01, 6.52319e-01, 6.97879e-01,
     & 7.46621e-01, 7.98767e-01, 8.54555e-01, 9.14239e-01/
      DATA (KA_MN2O( 3,JT,10),JT=1,19)  /
     & 2.65609e-01, 2.84236e-01, 3.04170e-01, 3.25501e-01, 3.48329e-01,
     & 3.72758e-01, 3.98900e-01, 4.26875e-01, 4.56812e-01, 4.88849e-01,
     & 5.23132e-01, 5.59820e-01, 5.99080e-01, 6.41095e-01, 6.86055e-01,
     & 7.34169e-01, 7.85657e-01, 8.40756e-01, 8.99718e-01/
      DATA (KA_MN2O( 4,JT,10),JT=1,19)  /
     & 2.55277e-01, 2.73370e-01, 2.92745e-01, 3.13494e-01, 3.35714e-01,
     & 3.59508e-01, 3.84989e-01, 4.12275e-01, 4.41496e-01, 4.72788e-01,
     & 5.06298e-01, 5.42183e-01, 5.80611e-01, 6.21763e-01, 6.65831e-01,
     & 7.13023e-01, 7.63560e-01, 8.17678e-01, 8.75633e-01/
      DATA (KA_MN2O( 5,JT,10),JT=1,19)  /
     & 2.41481e-01, 2.58840e-01, 2.77446e-01, 2.97390e-01, 3.18768e-01,
     & 3.41682e-01, 3.66244e-01, 3.92571e-01, 4.20791e-01, 4.51039e-01,
     & 4.83461e-01, 5.18215e-01, 5.55466e-01, 5.95396e-01, 6.38195e-01,
     & 6.84071e-01, 7.33245e-01, 7.85954e-01, 8.42452e-01/
      DATA (KA_MN2O( 6,JT,10),JT=1,19)  /
     & 2.37173e-01, 2.54360e-01, 2.72792e-01, 2.92559e-01, 3.13759e-01,
     & 3.36495e-01, 3.60878e-01, 3.87029e-01, 4.15074e-01, 4.45152e-01,
     & 4.77409e-01, 5.12004e-01, 5.49105e-01, 5.88895e-01, 6.31569e-01,
     & 6.77334e-01, 7.26416e-01, 7.79055e-01, 8.35508e-01/
      DATA (KA_MN2O( 7,JT,10),JT=1,19)  /
     & 2.27414e-01, 2.44231e-01, 2.62292e-01, 2.81689e-01, 3.02520e-01,
     & 3.24891e-01, 3.48917e-01, 3.74720e-01, 4.02430e-01, 4.32190e-01,
     & 4.64151e-01, 4.98475e-01, 5.35337e-01, 5.74926e-01, 6.17442e-01,
     & 6.63102e-01, 7.12138e-01, 7.64801e-01, 8.21358e-01/
      DATA (KA_MN2O( 8,JT,10),JT=1,19)  /
     & 1.77234e-01, 1.92029e-01, 2.08060e-01, 2.25429e-01, 2.44248e-01,
     & 2.64638e-01, 2.86730e-01, 3.10667e-01, 3.36601e-01, 3.64701e-01,
     & 3.95147e-01, 4.28134e-01, 4.63875e-01, 5.02600e-01, 5.44557e-01,
     & 5.90017e-01, 6.39272e-01, 6.92639e-01, 7.50461e-01/
      DATA (KA_MN2O( 9,JT,10),JT=1,19)  /
     & 2.41727e-01, 2.59094e-01, 2.77710e-01, 2.97662e-01, 3.19049e-01,
     & 3.41972e-01, 3.66541e-01, 3.92877e-01, 4.21104e-01, 4.51359e-01,
     & 4.83788e-01, 5.18547e-01, 5.55804e-01, 5.95737e-01, 6.38539e-01,
     & 6.84417e-01, 7.33590e-01, 7.86297e-01, 8.42790e-01/
      DATA (KA_MN2O( 1,JT,11),JT=1,19)  /
     & 6.65287e+00, 6.69137e+00, 6.73008e+00, 6.76903e+00, 6.80820e+00,
     & 6.84759e+00, 6.88721e+00, 6.92707e+00, 6.96715e+00, 7.00746e+00,
     & 7.04801e+00, 7.08879e+00, 7.12981e+00, 7.17107e+00, 7.21256e+00,
     & 7.25430e+00, 7.29628e+00, 7.33850e+00, 7.38096e+00/
      DATA (KA_MN2O( 2,JT,11),JT=1,19)  /
     & 2.06252e-01, 2.27731e-01, 2.51447e-01, 2.77633e-01, 3.06546e-01,
     & 3.38470e-01, 3.73719e-01, 4.12638e-01, 4.55611e-01, 5.03058e-01,
     & 5.55447e-01, 6.13292e-01, 6.77160e-01, 7.47680e-01, 8.25544e-01,
     & 9.11517e-01, 1.00644e+00, 1.11125e+00, 1.22698e+00/
      DATA (KA_MN2O( 3,JT,11),JT=1,19)  /
     & 2.05840e-01, 2.27279e-01, 2.50952e-01, 2.77090e-01, 3.05950e-01,
     & 3.37816e-01, 3.73002e-01, 4.11852e-01, 4.54748e-01, 5.02113e-01,
     & 5.54411e-01, 6.12155e-01, 6.75915e-01, 7.46315e-01, 8.24047e-01,
     & 9.09876e-01, 1.00465e+00, 1.10928e+00, 1.22482e+00/
      DATA (KA_MN2O( 4,JT,11),JT=1,19)  /
     & 2.04702e-01, 2.26031e-01, 2.49582e-01, 2.75587e-01, 3.04301e-01,
     & 3.36008e-01, 3.71018e-01, 4.09675e-01, 4.52361e-01, 4.99495e-01,
     & 5.51539e-01, 6.09007e-01, 6.72461e-01, 7.42528e-01, 8.19895e-01,
     & 9.05323e-01, 9.99653e-01, 1.10381e+00, 1.21882e+00/
      DATA (KA_MN2O( 5,JT,11),JT=1,19)  /
     & 2.03481e-01, 2.24689e-01, 2.48108e-01, 2.73967e-01, 3.02522e-01,
     & 3.34053e-01, 3.68871e-01, 4.07317e-01, 4.49771e-01, 4.96649e-01,
     & 5.48414e-01, 6.05574e-01, 6.68691e-01, 7.38387e-01, 8.15347e-01,
     & 9.00329e-01, 9.94168e-01, 1.09779e+00, 1.21221e+00/
      DATA (KA_MN2O( 6,JT,11),JT=1,19)  /
     & 2.01513e-01, 2.22529e-01, 2.45738e-01, 2.71367e-01, 2.99670e-01,
     & 3.30924e-01, 3.65437e-01, 4.03550e-01, 4.45639e-01, 4.92117e-01,
     & 5.43442e-01, 6.00120e-01, 6.62710e-01, 7.31827e-01, 8.08153e-01,
     & 8.92439e-01, 9.85516e-01, 1.08830e+00, 1.20180e+00/
      DATA (KA_MN2O( 7,JT,11),JT=1,19)  /
     & 1.97136e-01, 2.17723e-01, 2.40459e-01, 2.65570e-01, 2.93304e-01,
     & 3.23933e-01, 3.57762e-01, 3.95122e-01, 4.36385e-01, 4.81956e-01,
     & 5.32287e-01, 5.87873e-01, 6.49264e-01, 7.17067e-01, 7.91950e-01,
     & 8.74653e-01, 9.65992e-01, 1.06687e+00, 1.17828e+00/
      DATA (KA_MN2O( 8,JT,11),JT=1,19)  /
     & 1.79518e-01, 1.98371e-01, 2.19204e-01, 2.42224e-01, 2.67662e-01,
     & 2.95772e-01, 3.26833e-01, 3.61157e-01, 3.99085e-01, 4.40996e-01,
     & 4.87309e-01, 5.38486e-01, 5.95037e-01, 6.57526e-01, 7.26579e-01,
     & 8.02883e-01, 8.87201e-01, 9.80373e-01, 1.08333e+00/
      DATA (KA_MN2O( 9,JT,11),JT=1,19)  /
     & 2.03481e-01, 2.24689e-01, 2.48108e-01, 2.73967e-01, 3.02522e-01,
     & 3.34053e-01, 3.68871e-01, 4.07317e-01, 4.49771e-01, 4.96649e-01,
     & 5.48414e-01, 6.05574e-01, 6.68691e-01, 7.38387e-01, 8.15347e-01,
     & 9.00329e-01, 9.94168e-01, 1.09779e+00, 1.21221e+00/
      DATA (KA_MN2O( 1,JT,12),JT=1,19)  /
     & 5.89636e+00, 5.95081e+00, 6.00576e+00, 6.06121e+00, 6.11718e+00,
     & 6.17366e+00, 6.23067e+00, 6.28820e+00, 6.34627e+00, 6.40487e+00,
     & 6.46401e+00, 6.52369e+00, 6.58393e+00, 6.64472e+00, 6.70608e+00,
     & 6.76800e+00, 6.83050e+00, 6.89357e+00, 6.95722e+00/
      DATA (KA_MN2O( 2,JT,12),JT=1,19)  /
     & 7.18699e-05, 9.48140e-05, 1.25083e-04, 1.65015e-04, 2.17695e-04,
     & 2.87193e-04, 3.78877e-04, 4.99831e-04, 6.59400e-04, 8.69909e-04,
     & 1.14762e-03, 1.51400e-03, 1.99733e-03, 2.63497e-03, 3.47616e-03,
     & 4.58591e-03, 6.04993e-03, 7.98133e-03, 1.05293e-02/
      DATA (KA_MN2O( 3,JT,12),JT=1,19)  /
     & 7.20868e-05, 9.50993e-05, 1.25458e-04, 1.65508e-04, 2.18344e-04,
     & 2.88046e-04, 3.80000e-04, 5.01307e-04, 6.61341e-04, 8.72462e-04,
     & 1.15098e-03, 1.51841e-03, 2.00313e-03, 2.64260e-03, 3.48620e-03,
     & 4.59911e-03, 6.06729e-03, 8.00416e-03, 1.05593e-02/
      DATA (KA_MN2O( 4,JT,12),JT=1,19)  /
     & 7.21734e-05, 9.52161e-05, 1.25616e-04, 1.65721e-04, 2.18630e-04,
     & 2.88432e-04, 3.80519e-04, 5.02007e-04, 6.62282e-04, 8.73727e-04,
     & 1.15268e-03, 1.52070e-03, 2.00621e-03, 2.64673e-03, 3.49174e-03,
     & 4.60655e-03, 6.07727e-03, 8.01755e-03, 1.05773e-02/
      DATA (KA_MN2O( 5,JT,12),JT=1,19)  /
     & 7.22599e-05, 9.53329e-05, 1.25773e-04, 1.65933e-04, 2.18916e-04,
     & 2.88818e-04, 3.81038e-04, 5.02706e-04, 6.63223e-04, 8.74992e-04,
     & 1.15438e-03, 1.52298e-03, 2.00928e-03, 2.65085e-03, 3.49728e-03,
     & 4.61398e-03, 6.08725e-03, 8.03094e-03, 1.05952e-02/
      DATA (KA_MN2O( 6,JT,12),JT=1,19)  /
     & 7.29962e-05, 9.63091e-05, 1.27067e-04, 1.67649e-04, 2.21191e-04,
     & 2.91833e-04, 3.85036e-04, 5.08005e-04, 6.70247e-04, 8.84304e-04,
     & 1.16672e-03, 1.53934e-03, 2.03096e-03, 2.67959e-03, 3.53537e-03,
     & 4.66447e-03, 6.15417e-03, 8.11962e-03, 1.07128e-02/
      DATA (KA_MN2O( 7,JT,12),JT=1,19)  /
     & 7.47398e-05, 9.86139e-05, 1.30114e-04, 1.71677e-04, 2.26516e-04,
     & 2.98872e-04, 3.94340e-04, 5.20305e-04, 6.86506e-04, 9.05797e-04,
     & 1.19514e-03, 1.57690e-03, 2.08061e-03, 2.74522e-03, 3.62213e-03,
     & 4.77915e-03, 6.30576e-03, 8.32001e-03, 1.09777e-02/
      DATA (KA_MN2O( 8,JT,12),JT=1,19)  /
     & 7.57487e-05, 9.99802e-05, 1.31963e-04, 1.74177e-04, 2.29896e-04,
     & 3.03438e-04, 4.00506e-04, 5.28625e-04, 6.97729e-04, 9.20927e-04,
     & 1.21553e-03, 1.60437e-03, 2.11759e-03, 2.79499e-03, 3.68909e-03,
     & 4.86921e-03, 6.42684e-03, 8.48274e-03, 1.11963e-02/
      DATA (KA_MN2O( 9,JT,12),JT=1,19)  /
     & 7.22467e-05, 9.53177e-05, 1.25756e-04, 1.65915e-04, 2.18898e-04,
     & 2.88800e-04, 3.81024e-04, 5.02700e-04, 6.63231e-04, 8.75024e-04,
     & 1.15445e-03, 1.52311e-03, 2.00950e-03, 2.65121e-03, 3.49784e-03,
     & 4.61483e-03, 6.08852e-03, 8.03280e-03, 1.05980e-02/
      DATA (KA_MN2O( 1,JT,13),JT=1,19)  /
     & 1.14265e+01, 1.16380e+01, 1.18534e+01, 1.20728e+01, 1.22962e+01,
     & 1.25238e+01, 1.27556e+01, 1.29917e+01, 1.32322e+01, 1.34771e+01,
     & 1.37265e+01, 1.39806e+01, 1.42394e+01, 1.45029e+01, 1.47714e+01,
     & 1.50448e+01, 1.53232e+01, 1.56068e+01, 1.58957e+01/
      DATA (KA_MN2O( 2,JT,13),JT=1,19)  /
     & 7.97796e-05, 1.05659e-04, 1.39932e-04, 1.85324e-04, 2.45439e-04,
     & 3.25054e-04, 4.30496e-04, 5.70140e-04, 7.55082e-04, 1.00002e-03,
     & 1.32440e-03, 1.75401e-03, 2.32298e-03, 3.07651e-03, 4.07447e-03,
     & 5.39614e-03, 7.14655e-03, 9.46475e-03, 1.25349e-02/
      DATA (KA_MN2O( 3,JT,13),JT=1,19)  /
     & 7.95035e-05, 1.05293e-04, 1.39449e-04, 1.84684e-04, 2.44592e-04,
     & 3.23934e-04, 4.29013e-04, 5.68178e-04, 7.52486e-04, 9.96580e-04,
     & 1.31985e-03, 1.74800e-03, 2.31502e-03, 3.06597e-03, 4.06052e-03,
     & 5.37770e-03, 7.12214e-03, 9.43244e-03, 1.24922e-02/
      DATA (KA_MN2O( 4,JT,13),JT=1,19)  /
     & 7.92339e-05, 1.04938e-04, 1.38980e-04, 1.84065e-04, 2.43776e-04,
     & 3.22857e-04, 4.27593e-04, 5.66305e-04, 7.50016e-04, 9.93322e-04,
     & 1.31556e-03, 1.74233e-03, 2.30754e-03, 3.05612e-03, 4.04752e-03,
     & 5.36055e-03, 7.09953e-03, 9.40262e-03, 1.24528e-02/
      DATA (KA_MN2O( 5,JT,13),JT=1,19)  /
     & 7.90000e-05, 1.04627e-04, 1.38566e-04, 1.83516e-04, 2.43046e-04,
     & 3.21887e-04, 4.26303e-04, 5.64591e-04, 7.47738e-04, 9.90295e-04,
     & 1.31154e-03, 1.73698e-03, 2.30044e-03, 3.04667e-03, 4.03498e-03,
     & 5.34388e-03, 7.07737e-03, 9.37318e-03, 1.24137e-02/
      DATA (KA_MN2O( 6,JT,13),JT=1,19)  /
     & 7.76004e-05, 1.02776e-04, 1.36118e-04, 1.80278e-04, 2.38764e-04,
     & 3.16224e-04, 4.18814e-04, 5.54686e-04, 7.34638e-04, 9.72970e-04,
     & 1.28862e-03, 1.70668e-03, 2.26036e-03, 2.99367e-03, 3.96488e-03,
     & 5.25118e-03, 6.95477e-03, 9.21105e-03, 1.21993e-02/
      DATA (KA_MN2O( 7,JT,13),JT=1,19)  /
     & 7.52813e-05, 9.97094e-05, 1.32064e-04, 1.74918e-04, 2.31677e-04,
     & 3.06854e-04, 4.06426e-04, 5.38308e-04, 7.12984e-04, 9.44341e-04,
     & 1.25077e-03, 1.65664e-03, 2.19420e-03, 2.90620e-03, 3.84923e-03,
     & 5.09828e-03, 6.75263e-03, 8.94379e-03, 1.18460e-02/
      DATA (KA_MN2O( 8,JT,13),JT=1,19)  /
     & 6.87436e-05, 9.10605e-05, 1.20622e-04, 1.59781e-04, 2.11653e-04,
     & 2.80364e-04, 3.71381e-04, 4.91946e-04, 6.51651e-04, 8.63203e-04,
     & 1.14343e-03, 1.51464e-03, 2.00635e-03, 2.65769e-03, 3.52048e-03,
     & 4.66337e-03, 6.17729e-03, 8.18269e-03, 1.08391e-02/
      DATA (KA_MN2O( 9,JT,13),JT=1,19)  /
     & 7.90357e-05, 1.04671e-04, 1.38622e-04, 1.83585e-04, 2.43132e-04,
     & 3.21994e-04, 4.26434e-04, 5.64750e-04, 7.47931e-04, 9.90526e-04,
     & 1.31181e-03, 1.73730e-03, 2.30081e-03, 3.04709e-03, 4.03543e-03,
     & 5.34435e-03, 7.07782e-03, 9.37355e-03, 1.24139e-02/
      DATA (KA_MN2O( 1,JT,14),JT=1,19)  /
     & 1.61373e+01, 1.64784e+01, 1.68266e+01, 1.71822e+01, 1.75454e+01,
     & 1.79162e+01, 1.82948e+01, 1.86814e+01, 1.90762e+01, 1.94794e+01,
     & 1.98911e+01, 2.03114e+01, 2.07407e+01, 2.11790e+01, 2.16266e+01,
     & 2.20836e+01, 2.25504e+01, 2.30269e+01, 2.35136e+01/
      DATA (KA_MN2O( 2,JT,14),JT=1,19)  /
     & 6.92866e-10, 9.24655e-10, 1.23398e-09, 1.64680e-09, 2.19771e-09,
     & 2.93292e-09, 3.91409e-09, 5.22349e-09, 6.97093e-09, 9.30295e-09,
     & 1.24151e-08, 1.65684e-08, 2.21111e-08, 2.95081e-08, 3.93796e-08,
     & 5.25535e-08, 7.01346e-08, 9.35970e-08, 1.24908e-07/
      DATA (KA_MN2O( 3,JT,14),JT=1,19)  /
     & 6.94564e-10, 9.26928e-10, 1.23703e-09, 1.65088e-09, 2.20317e-09,
     & 2.94024e-09, 3.92389e-09, 5.23661e-09, 6.98851e-09, 9.32650e-09,
     & 1.24467e-08, 1.66107e-08, 2.21677e-08, 2.95839e-08, 3.94811e-08,
     & 5.26894e-08, 7.03165e-08, 9.38407e-08, 1.25235e-07/
      DATA (KA_MN2O( 4,JT,14),JT=1,19)  /
     & 6.98644e-10, 9.32310e-10, 1.24413e-09, 1.66023e-09, 2.21551e-09,
     & 2.95649e-09, 3.94531e-09, 5.26484e-09, 7.02570e-09, 9.37548e-09,
     & 1.25112e-08, 1.66956e-08, 2.22795e-08, 2.97311e-08, 3.96748e-08,
     & 5.29443e-08, 7.06518e-08, 9.42817e-08, 1.25815e-07/
      DATA (KA_MN2O( 5,JT,14),JT=1,19)  /
     & 7.03261e-10, 9.38472e-10, 1.25235e-09, 1.67121e-09, 2.23016e-09,
     & 2.97605e-09, 3.97141e-09, 5.29968e-09, 7.07220e-09, 9.43754e-09,
     & 1.25940e-08, 1.68062e-08, 2.24271e-08, 2.99280e-08, 3.99376e-08,
     & 5.32951e-08, 7.11200e-08, 9.49066e-08, 1.26649e-07/
      DATA (KA_MN2O( 6,JT,14),JT=1,19)  /
     & 7.12478e-10, 9.50674e-10, 1.26850e-09, 1.69259e-09, 2.25845e-09,
     & 3.01350e-09, 4.02096e-09, 5.36525e-09, 7.15896e-09, 9.55233e-09,
     & 1.27459e-08, 1.70071e-08, 2.26928e-08, 3.02795e-08, 4.04025e-08,
     & 5.39099e-08, 7.19330e-08, 9.59815e-08, 1.28070e-07/
      DATA (KA_MN2O( 7,JT,14),JT=1,19)  /
     & 7.28994e-10, 9.72644e-10, 1.29773e-09, 1.73147e-09, 2.31017e-09,
     & 3.08230e-09, 4.11249e-09, 5.48700e-09, 7.32092e-09, 9.76777e-09,
     & 1.30324e-08, 1.73883e-08, 2.31999e-08, 3.09540e-08, 4.12996e-08,
     & 5.51032e-08, 7.35203e-08, 9.80928e-08, 1.30878e-07/
      DATA (KA_MN2O( 8,JT,14),JT=1,19)  /
     & 7.87604e-10, 1.05043e-09, 1.40097e-09, 1.86848e-09, 2.49201e-09,
     & 3.32360e-09, 4.43271e-09, 5.91194e-09, 7.88479e-09, 1.05160e-08,
     & 1.40253e-08, 1.87056e-08, 2.49478e-08, 3.32730e-08, 4.43764e-08,
     & 5.91851e-08, 7.89356e-08, 1.05277e-07, 1.40408e-07/
      DATA (KA_MN2O( 9,JT,14),JT=1,19)  /
     & 7.03261e-10, 9.38472e-10, 1.25235e-09, 1.67121e-09, 2.23016e-09,
     & 2.97605e-09, 3.97141e-09, 5.29968e-09, 7.07220e-09, 9.43754e-09,
     & 1.25940e-08, 1.68062e-08, 2.24271e-08, 2.99280e-08, 3.99376e-08,
     & 5.32951e-08, 7.11200e-08, 9.49066e-08, 1.26649e-07/
      DATA (KA_MN2O( 1,JT,15),JT=1,19)  /
     & 2.14029e+01, 2.16782e+01, 2.19571e+01, 2.22396e+01, 2.25257e+01,
     & 2.28155e+01, 2.31090e+01, 2.34063e+01, 2.37074e+01, 2.40124e+01,
     & 2.43213e+01, 2.46342e+01, 2.49511e+01, 2.52721e+01, 2.55972e+01,
     & 2.59265e+01, 2.62600e+01, 2.65979e+01, 2.69400e+01/
      DATA (KA_MN2O( 2,JT,15),JT=1,19)  /
     & 5.68659e-10, 7.55629e-10, 1.00407e-09, 1.33421e-09, 1.77288e-09,
     & 2.35579e-09, 3.13036e-09, 4.15960e-09, 5.52724e-09, 7.34455e-09,
     & 9.75939e-09, 1.29682e-08, 1.72320e-08, 2.28978e-08, 3.04264e-08,
     & 4.04304e-08, 5.37236e-08, 7.13875e-08, 9.48591e-08/
      DATA (KA_MN2O( 3,JT,15),JT=1,19)  /
     & 5.59573e-10, 7.43558e-10, 9.88035e-10, 1.31290e-09, 1.74457e-09,
     & 2.31817e-09, 3.08037e-09, 4.09318e-09, 5.43900e-09, 7.22730e-09,
     & 9.60360e-09, 1.27612e-08, 1.69570e-08, 2.25324e-08, 2.99409e-08,
     & 3.97853e-08, 5.28665e-08, 7.02486e-08, 9.33459e-08/
      DATA (KA_MN2O( 4,JT,15),JT=1,19)  /
     & 5.50488e-10, 7.31486e-10, 9.71996e-10, 1.29158e-09, 1.71625e-09,
     & 2.28055e-09, 3.03039e-09, 4.02676e-09, 5.35075e-09, 7.11005e-09,
     & 9.44781e-09, 1.25542e-08, 1.66820e-08, 2.21670e-08, 2.94554e-08,
     & 3.91402e-08, 5.20093e-08, 6.91098e-08, 9.18327e-08/
      DATA (KA_MN2O( 5,JT,15),JT=1,19)  /
     & 5.34010e-10, 7.09574e-10, 9.42858e-10, 1.25284e-09, 1.66473e-09,
     & 2.21203e-09, 2.93927e-09, 3.90560e-09, 5.18963e-09, 6.89580e-09,
     & 9.16290e-09, 1.21754e-08, 1.61782e-08, 2.14970e-08, 2.85645e-08,
     & 3.79555e-08, 5.04340e-08, 6.70149e-08, 8.90470e-08/
      DATA (KA_MN2O( 6,JT,15),JT=1,19)  /
     & 5.08144e-10, 6.75221e-10, 8.97231e-10, 1.19224e-09, 1.58424e-09,
     & 2.10513e-09, 2.79729e-09, 3.71703e-09, 4.93919e-09, 6.56317e-09,
     & 8.72112e-09, 1.15886e-08, 1.53989e-08, 2.04620e-08, 2.71898e-08,
     & 3.61297e-08, 4.80091e-08, 6.37943e-08, 8.47696e-08/
      DATA (KA_MN2O( 7,JT,15),JT=1,19)  /
     & 4.56716e-10, 6.06884e-10, 8.06427e-10, 1.07158e-09, 1.42391e-09,
     & 1.89210e-09, 2.51422e-09, 3.34089e-09, 4.43938e-09, 5.89904e-09,
     & 7.83864e-09, 1.04160e-08, 1.38408e-08, 1.83916e-08, 2.44387e-08,
     & 3.24742e-08, 4.31517e-08, 5.73399e-08, 7.61932e-08/
      DATA (KA_MN2O( 8,JT,15),JT=1,19)  /
     & 2.78366e-10, 3.69881e-10, 4.91482e-10, 6.53061e-10, 8.67760e-10,
     & 1.15304e-09, 1.53211e-09, 2.03581e-09, 2.70510e-09, 3.59441e-09,
     & 4.77611e-09, 6.34629e-09, 8.43268e-09, 1.12050e-08, 1.48887e-08,
     & 1.97835e-08, 2.62875e-08, 3.49296e-08, 4.64130e-08/
      DATA (KA_MN2O( 9,JT,15),JT=1,19)  /
     & 5.34010e-10, 7.09574e-10, 9.42858e-10, 1.25284e-09, 1.66473e-09,
     & 2.21203e-09, 2.93927e-09, 3.90560e-09, 5.18963e-09, 6.89580e-09,
     & 9.16290e-09, 1.21754e-08, 1.61782e-08, 2.14970e-08, 2.85645e-08,
     & 3.79555e-08, 5.04340e-08, 6.70149e-08, 8.90470e-08/
      DATA (KA_MN2O( 1,JT,16),JT=1,19)  /
     & 2.90784e+01, 2.93787e+01, 2.96820e+01, 2.99885e+01, 3.02982e+01,
     & 3.06110e+01, 3.09271e+01, 3.12464e+01, 3.15690e+01, 3.18950e+01,
     & 3.22243e+01, 3.25571e+01, 3.28932e+01, 3.32329e+01, 3.35760e+01,
     & 3.39227e+01, 3.42730e+01, 3.46269e+01, 3.49844e+01/
      DATA (KA_MN2O( 2,JT,16),JT=1,19)  /
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00/
      DATA (KA_MN2O( 3,JT,16),JT=1,19)  /
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00/
      DATA (KA_MN2O( 4,JT,16),JT=1,19)  /
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00/
      DATA (KA_MN2O( 5,JT,16),JT=1,19)  /
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00/
      DATA (KA_MN2O( 6,JT,16),JT=1,19)  /
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00/
      DATA (KA_MN2O( 7,JT,16),JT=1,19)  /
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00/
      DATA (KA_MN2O( 8,JT,16),JT=1,19)  /
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00/
      DATA (KA_MN2O( 9,JT,16),JT=1,19)  /
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00,
     & 0.00000e+00, 0.00000e+00, 0.00000e+00, 0.00000e+00/

C     The array KB_Mxx contains the absorption coefficient for 
C     a minor species at the 16 chosen g-values for a reference pressure
C     level above 100~ mb.   The first index refers to temperature 
C     in 7.2 degree increments.  For instance, JT = 1 refers to a 
C     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
C     runs over the g-channel (1 to 16).

      DATA (KB_MN2O(JT, 1),JT=1,19)  /
     & 8.42688e-03, 8.96787e-03, 9.54358e-03, 1.01563e-02, 1.08083e-02,
     & 1.15021e-02, 1.22405e-02, 1.30263e-02, 1.38626e-02, 1.47525e-02,
     & 1.56996e-02, 1.67075e-02, 1.77800e-02, 1.89215e-02, 2.01362e-02,
     & 2.14289e-02, 2.28045e-02, 2.42685e-02, 2.58265e-02/
      DATA (KB_MN2O(JT, 2),JT=1,19)  /
     & 2.24976e-02, 2.38935e-02, 2.53762e-02, 2.69508e-02, 2.86231e-02,
     & 3.03991e-02, 3.22854e-02, 3.42887e-02, 3.64163e-02, 3.86760e-02,
     & 4.10759e-02, 4.36246e-02, 4.63315e-02, 4.92064e-02, 5.22597e-02,
     & 5.55024e-02, 5.89464e-02, 6.26040e-02, 6.64886e-02/
      DATA (KB_MN2O(JT, 3),JT=1,19)  /
     & 5.93542e-02, 6.37312e-02, 6.84310e-02, 7.34774e-02, 7.88960e-02,
     & 8.47141e-02, 9.09613e-02, 9.76692e-02, 1.04872e-01, 1.12605e-01,
     & 1.20910e-01, 1.29826e-01, 1.39400e-01, 1.49680e-01, 1.60718e-01,
     & 1.72570e-01, 1.85296e-01, 1.98961e-01, 2.13633e-01/
      DATA (KB_MN2O(JT, 4),JT=1,19)  /
     & 1.98022e-01, 2.05895e-01, 2.14082e-01, 2.22594e-01, 2.31445e-01,
     & 2.40647e-01, 2.50216e-01, 2.60164e-01, 2.70509e-01, 2.81265e-01,
     & 2.92448e-01, 3.04076e-01, 3.16167e-01, 3.28738e-01, 3.41809e-01,
     & 3.55400e-01, 3.69531e-01, 3.84224e-01, 3.99501e-01/
      DATA (KB_MN2O(JT, 5),JT=1,19)  /
     & 6.41413e-01, 6.46239e-01, 6.51101e-01, 6.56000e-01, 6.60936e-01,
     & 6.65910e-01, 6.70920e-01, 6.75968e-01, 6.81054e-01, 6.86179e-01,
     & 6.91342e-01, 6.96544e-01, 7.01785e-01, 7.07065e-01, 7.12385e-01,
     & 7.17746e-01, 7.23146e-01, 7.28587e-01, 7.34070e-01/
      DATA (KB_MN2O(JT, 6),JT=1,19)  /
     & 1.47906e+00, 1.48768e+00, 1.49635e+00, 1.50507e+00, 1.51384e+00,
     & 1.52267e+00, 1.53154e+00, 1.54047e+00, 1.54944e+00, 1.55847e+00,
     & 1.56755e+00, 1.57669e+00, 1.58588e+00, 1.59512e+00, 1.60442e+00,
     & 1.61377e+00, 1.62317e+00, 1.63263e+00, 1.64215e+00/
      DATA (KB_MN2O(JT, 7),JT=1,19)  /
     & 3.53152e+00, 3.55492e+00, 3.57848e+00, 3.60219e+00, 3.62606e+00,
     & 3.65008e+00, 3.67427e+00, 3.69862e+00, 3.72313e+00, 3.74780e+00,
     & 3.77263e+00, 3.79763e+00, 3.82279e+00, 3.84812e+00, 3.87362e+00,
     & 3.89929e+00, 3.92513e+00, 3.95114e+00, 3.97732e+00/
      DATA (KB_MN2O(JT, 8),JT=1,19)  /
     & 9.06783e+00, 9.04597e+00, 9.02415e+00, 9.00239e+00, 8.98069e+00,
     & 8.95903e+00, 8.93743e+00, 8.91588e+00, 8.89438e+00, 8.87293e+00,
     & 8.85154e+00, 8.83020e+00, 8.80890e+00, 8.78766e+00, 8.76647e+00,
     & 8.74533e+00, 8.72425e+00, 8.70321e+00, 8.68223e+00/
      DATA (KB_MN2O(JT, 9),JT=1,19)  /
     & 3.88220e+01, 3.85805e+01, 3.83405e+01, 3.81019e+01, 3.78649e+01,
     & 3.76293e+01, 3.73952e+01, 3.71625e+01, 3.69313e+01, 3.67016e+01,
     & 3.64732e+01, 3.62463e+01, 3.60208e+01, 3.57967e+01, 3.55740e+01,
     & 3.53527e+01, 3.51327e+01, 3.49142e+01, 3.46970e+01/
      DATA (KB_MN2O(JT,10),JT=1,19)  /
     & 1.14211e+02, 1.13955e+02, 1.13700e+02, 1.13445e+02, 1.13191e+02,
     & 1.12938e+02, 1.12685e+02, 1.12433e+02, 1.12181e+02, 1.11930e+02,
     & 1.11679e+02, 1.11429e+02, 1.11180e+02, 1.10931e+02, 1.10682e+02,
     & 1.10434e+02, 1.10187e+02, 1.09940e+02, 1.09694e+02/
      DATA (KB_MN2O(JT,11),JT=1,19)  /
     & 1.60513e+02, 1.60857e+02, 1.61201e+02, 1.61547e+02, 1.61893e+02,
     & 1.62240e+02, 1.62587e+02, 1.62936e+02, 1.63285e+02, 1.63635e+02,
     & 1.63985e+02, 1.64337e+02, 1.64689e+02, 1.65041e+02, 1.65395e+02,
     & 1.65749e+02, 1.66105e+02, 1.66460e+02, 1.66817e+02/
      DATA (KB_MN2O(JT,12),JT=1,19)  /
     & 1.71473e+02, 1.72766e+02, 1.74068e+02, 1.75381e+02, 1.76703e+02,
     & 1.78035e+02, 1.79377e+02, 1.80729e+02, 1.82091e+02, 1.83464e+02,
     & 1.84847e+02, 1.86240e+02, 1.87644e+02, 1.89059e+02, 1.90484e+02,
     & 1.91920e+02, 1.93367e+02, 1.94824e+02, 1.96293e+02/
      DATA (KB_MN2O(JT,13),JT=1,19)  /
     & 2.71287e+01, 2.75538e+01, 2.79856e+01, 2.84241e+01, 2.88695e+01,
     & 2.93219e+01, 2.97814e+01, 3.02480e+01, 3.07220e+01, 3.12035e+01,
     & 3.16924e+01, 3.21890e+01, 3.26934e+01, 3.32058e+01, 3.37261e+01,
     & 3.42546e+01, 3.47914e+01, 3.53365e+01, 3.58903e+01/
      DATA (KB_MN2O(JT,14),JT=1,19)  /
     & 1.70389e+01, 1.70899e+01, 1.71411e+01, 1.71924e+01, 1.72439e+01,
     & 1.72955e+01, 1.73473e+01, 1.73992e+01, 1.74513e+01, 1.75035e+01,
     & 1.75559e+01, 1.76085e+01, 1.76612e+01, 1.77141e+01, 1.77671e+01,
     & 1.78203e+01, 1.78736e+01, 1.79271e+01, 1.79808e+01/
      DATA (KB_MN2O(JT,15),JT=1,19)  /
     & 2.49725e+00, 2.66861e+00, 2.85174e+00, 3.04743e+00, 3.25655e+00,
     & 3.48003e+00, 3.71883e+00, 3.97403e+00, 4.24673e+00, 4.53815e+00,
     & 4.84957e+00, 5.18236e+00, 5.53798e+00, 5.91801e+00, 6.32412e+00,
     & 6.75809e+00, 7.22185e+00, 7.71742e+00, 8.24701e+00/
      DATA (KB_MN2O(JT,16),JT=1,19)  /
     & 1.82935e-03, 2.58912e-03, 3.66444e-03, 5.18637e-03, 7.34039e-03,
     & 1.03890e-02, 1.47038e-02, 2.08106e-02, 2.94538e-02, 4.16865e-02,
     & 5.89999e-02, 8.35040e-02, 1.18185e-01, 1.67270e-01, 2.36741e-01,
     & 3.35065e-01, 4.74225e-01, 6.71180e-01, 9.49936e-01/

C     The array FORREF contains the coefficient of the water vapor
C     foreign-continuum (including the energy term).  The first 
C     index refers to reference temperature (296,260,224,260) and 
C     pressure (970,475,219,3 mbar) levels.  The second index 
C     runs over the g-channel (1 to 16).

      DATA (FORREF(1,IG),IG=1,16) /
     &7.5352e-06,2.9812e-05,1.4497e-04,4.4006e-04,1.0492e-03,1.9676e-03,
     &1.9989e-03,1.9099e-03,2.2121e-03,2.4491e-03,2.9573e-03,2.6344e-03,
     &3.0629e-03,3.3547e-03,5.0643e-03,5.0642e-03/
      DATA (FORREF(2,IG),IG=1,16) /
     &6.6070e-06,4.8618e-05,3.1112e-04,8.4235e-04,1.4179e-03,1.4315e-03,
     &1.4685e-03,1.6554e-03,2.1171e-03,2.3545e-03,2.5165e-03,2.7680e-03,
     &2.6985e-03,3.5345e-03,4.2924e-03,5.0712e-03/
      DATA (FORREF(3,IG),IG=1,16) /
     &6.5962e-06,7.2595e-04,1.3429e-03,1.1675e-03,9.8384e-04,8.8787e-04,
     &8.7557e-04,8.0589e-04,7.7024e-04,8.7518e-04,9.5213e-04,9.0849e-04,
     &1.2596e-03,2.5106e-03,3.9471e-03,5.0742e-03/
      DATA (FORREF(4,IG),IG=1,16) /
     &3.6217e-04,1.0709e-03,1.0628e-03,8.5640e-04,8.9332e-04,8.3372e-04,
     &7.8539e-04,8.2828e-04,8.3329e-04,8.5118e-04,8.2878e-04,6.8570e-04,
     &6.3815e-04,8.0648e-04,2.3236e-03,4.0321e-03/

C     The array SELFREF contains the coefficient of the water vapor
C     self-continuum (including the energy term).  The first index
C     refers to temperature in 7.2 degree increments.  For instance,
C     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
C     etc.  The second index runs over the g-channel (1 to 16).

      DATA (SELFREF(JT, 1),JT=1,10)  /
     & 2.83453e-02, 2.51439e-02, 2.23040e-02, 1.97849e-02, 1.75503e-02,
     & 1.55681e-02, 1.38097e-02, 1.22500e-02, 1.08664e-02, 9.63912e-03/
      DATA (SELFREF(JT, 2),JT=1,10)  /
     & 3.05185e-02, 2.72374e-02, 2.43090e-02, 2.16955e-02, 1.93629e-02,
     & 1.72811e-02, 1.54232e-02, 1.37650e-02, 1.22851e-02, 1.09643e-02/
      DATA (SELFREF(JT, 3),JT=1,10)  /
     & 4.23833e-02, 3.76250e-02, 3.34010e-02, 2.96512e-02, 2.63223e-02,
     & 2.33672e-02, 2.07439e-02, 1.84150e-02, 1.63476e-02, 1.45123e-02/
      DATA (SELFREF(JT, 4),JT=1,10)  /
     & 5.76481e-02, 5.13686e-02, 4.57730e-02, 4.07870e-02, 3.63441e-02,
     & 3.23851e-02, 2.88574e-02, 2.57140e-02, 2.29130e-02, 2.04171e-02/
      DATA (SELFREF(JT, 5),JT=1,10)  /
     & 6.92255e-02, 6.33521e-02, 5.79770e-02, 5.30580e-02, 4.85563e-02,
     & 4.44365e-02, 4.06663e-02, 3.72160e-02, 3.40584e-02, 3.11687e-02/
      DATA (SELFREF(JT, 6),JT=1,10)  /
     & 6.07694e-02, 5.94182e-02, 5.80970e-02, 5.68052e-02, 5.55422e-02,
     & 5.43072e-02, 5.30997e-02, 5.19190e-02, 5.07646e-02, 4.96358e-02/
      DATA (SELFREF(JT, 7),JT=1,10)  /
     & 6.23749e-02, 6.07744e-02, 5.92150e-02, 5.76956e-02, 5.62152e-02,
     & 5.47728e-02, 5.33674e-02, 5.19980e-02, 5.06638e-02, 4.93638e-02/
      DATA (SELFREF(JT, 8),JT=1,10)  /
     & 6.90744e-02, 6.61811e-02, 6.34090e-02, 6.07530e-02, 5.82083e-02,
     & 5.57702e-02, 5.34342e-02, 5.11960e-02, 4.90516e-02, 4.69970e-02/
      DATA (SELFREF(JT, 9),JT=1,10)  /
     & 8.08992e-02, 7.68876e-02, 7.30750e-02, 6.94514e-02, 6.60075e-02,
     & 6.27344e-02, 5.96236e-02, 5.66670e-02, 5.38570e-02, 5.11864e-02/
      DATA (SELFREF(JT,10),JT=1,10)  /
     & 8.70197e-02, 8.27485e-02, 7.86870e-02, 7.48248e-02, 7.11522e-02,
     & 6.76599e-02, 6.43389e-02, 6.11810e-02, 5.81781e-02, 5.53225e-02/
      DATA (SELFREF(JT,11),JT=1,10)  /
     & 8.84776e-02, 8.54262e-02, 8.24800e-02, 7.96354e-02, 7.68890e-02,
     & 7.42373e-02, 7.16770e-02, 6.92050e-02, 6.68183e-02, 6.45139e-02/
      DATA (SELFREF(JT,12),JT=1,10)  /
     & 9.82552e-02, 9.25696e-02, 8.72130e-02, 8.21664e-02, 7.74118e-02,
     & 7.29323e-02, 6.87121e-02, 6.47360e-02, 6.09900e-02, 5.74608e-02/
      DATA (SELFREF(JT,13),JT=1,10)  /
     & 9.32447e-02, 8.96818e-02, 8.62550e-02, 8.29592e-02, 7.97893e-02,
     & 7.67405e-02, 7.38082e-02, 7.09880e-02, 6.82755e-02, 6.56667e-02/
      DATA (SELFREF(JT,14),JT=1,10)  /
     & 1.15363e-01, 1.08593e-01, 1.02220e-01, 9.62210e-02, 9.05741e-02,
     & 8.52585e-02, 8.02549e-02, 7.55450e-02, 7.11115e-02, 6.69382e-02/
      DATA (SELFREF(JT,15),JT=1,10)  /
     & 1.23179e-01, 1.19247e-01, 1.15440e-01, 1.11755e-01, 1.08187e-01,
     & 1.04734e-01, 1.01391e-01, 9.81540e-02, 9.50207e-02, 9.19875e-02/
      DATA (SELFREF(JT,16),JT=1,10)  /
     & 1.44104e-01, 1.36412e-01, 1.29130e-01, 1.22237e-01, 1.15712e-01,
     & 1.09535e-01, 1.03688e-01, 9.81530e-02, 9.29135e-02, 8.79537e-02/
