C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB10.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.0 $
C     created:   $Date: 2002/06/03 20:39:22 $
      PARAMETER (MG=16)
      REAL KA(5,13,MG), KB(5,13:59,MG)
      DIMENSION SELFREF(10,MG), FORREF(4,MG)

      COMMON /HVRSN10/  HVRKG10
      COMMON /K10/ KA ,KB, FORREF, SELFREF

      CHARACTER*15 HVRKG10

      DATA HVRKG10  / '$Revision: 3.0 $' /

C     The array KA contains absorption coefs at the 16 chosen g-values 
C     for a range of pressure levels > ~100mb and temperatures.  The first
C     index in the array, JT, which runs from 1 to 5, corresponds to 
C     different temperatures.  More specifically, JT = 3 means that the 
C     data are for the corresponding TREF for this  pressure level, 
C     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
C     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
C     index, JP, runs from 1 to 13 and refers to the corresponding 
C     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
C     The third index, IG, goes from 1 to 16, and tells us which 
C     g-interval the absorption coefficients are for.
      DATA (KA(JT, 1, 1),JT=1,5) /
     &2.7213E-02,2.9029E-02,3.0838E-02,3.2767E-02,3.4630E-02/
      DATA (KA(JT, 2, 1),JT=1,5) /
     &2.1383E-02,2.2832E-02,2.4365E-02,2.5925E-02,2.7376E-02/
      DATA (KA(JT, 3, 1),JT=1,5) /
     &1.6478E-02,1.7675E-02,1.8942E-02,2.0177E-02,2.1374E-02/
      DATA (KA(JT, 4, 1),JT=1,5) /
     &1.2848E-02,1.3809E-02,1.4825E-02,1.5852E-02,1.6799E-02/
      DATA (KA(JT, 5, 1),JT=1,5) /
     &1.0029E-02,1.0847E-02,1.1686E-02,1.2512E-02,1.3297E-02/
      DATA (KA(JT, 6, 1),JT=1,5) /
     &7.8313E-03,8.5460E-03,9.2025E-03,9.9079E-03,1.0554E-02/
      DATA (KA(JT, 7, 1),JT=1,5) /
     &6.1234E-03,6.6846E-03,7.2818E-03,7.8451E-03,8.4144E-03/
      DATA (KA(JT, 8, 1),JT=1,5) /
     &4.8747E-03,5.2881E-03,5.7474E-03,6.2355E-03,6.7085E-03/
      DATA (KA(JT, 9, 1),JT=1,5) /
     &4.1059E-03,4.5848E-03,4.9152E-03,5.2401E-03,5.5908E-03/
      DATA (KA(JT,10, 1),JT=1,5) /
     &3.5412E-03,4.0565E-03,4.5689E-03,5.1092E-03,5.6716E-03/
      DATA (KA(JT,11, 1),JT=1,5) /
     &3.0492E-03,3.6436E-03,4.0799E-03,4.5260E-03,4.9802E-03/
      DATA (KA(JT,12, 1),JT=1,5) /
     &2.5821E-03,3.0995E-03,3.5069E-03,3.8699E-03,4.2575E-03/
      DATA (KA(JT,13, 1),JT=1,5) /
     &2.1558E-03,2.5890E-03,2.9127E-03,3.2139E-03,3.5455E-03/
      DATA (KA(JT, 1, 2),JT=1,5) /
     &5.2889E-02,5.6315E-02,5.9927E-02,6.3408E-02,6.6329E-02/
      DATA (KA(JT, 2, 2),JT=1,5) /
     &4.1932E-02,4.4934E-02,4.8030E-02,5.0855E-02,5.3372E-02/
      DATA (KA(JT, 3, 2),JT=1,5) /
     &3.2754E-02,3.5198E-02,3.7786E-02,4.0294E-02,4.2438E-02/
      DATA (KA(JT, 4, 2),JT=1,5) /
     &2.5838E-02,2.7680E-02,2.9873E-02,3.1963E-02,3.3931E-02/
      DATA (KA(JT, 5, 2),JT=1,5) /
     &2.0528E-02,2.2079E-02,2.3740E-02,2.5501E-02,2.7219E-02/
      DATA (KA(JT, 6, 2),JT=1,5) /
     &1.6350E-02,1.7491E-02,1.8902E-02,2.0280E-02,2.1774E-02/
      DATA (KA(JT, 7, 2),JT=1,5) /
     &1.2732E-02,1.3953E-02,1.5005E-02,1.6145E-02,1.7323E-02/
      DATA (KA(JT, 8, 2),JT=1,5) /
     &9.7464E-03,1.1159E-02,1.2150E-02,1.2940E-02,1.3856E-02/
      DATA (KA(JT, 9, 2),JT=1,5) /
     &7.5337E-03,8.5370E-03,9.6841E-03,1.0825E-02,1.1894E-02/
      DATA (KA(JT,10, 2),JT=1,5) /
     &7.1476E-03,7.8468E-03,8.6104E-03,9.4234E-03,1.0165E-02/
      DATA (KA(JT,11, 2),JT=1,5) /
     &7.4726E-03,7.8619E-03,8.4110E-03,8.8097E-03,9.3621E-03/
      DATA (KA(JT,12, 2),JT=1,5) /
     &6.8212E-03,7.3104E-03,7.6521E-03,8.0570E-03,8.3782E-03/
      DATA (KA(JT,13, 2),JT=1,5) /
     &5.7626E-03,6.1115E-03,6.3578E-03,6.6833E-03,6.9834E-03/
      DATA (KA(JT, 1, 3),JT=1,5) /
     &9.2909E-02,9.6713E-02,9.9436E-02,1.0242E-01,1.0613E-01/
      DATA (KA(JT, 2, 3),JT=1,5) /
     &7.4548E-02,7.7785E-02,8.0363E-02,8.2840E-02,8.6028E-02/
      DATA (KA(JT, 3, 3),JT=1,5) /
     &5.8714E-02,6.1823E-02,6.4284E-02,6.6702E-02,6.9231E-02/
      DATA (KA(JT, 4, 3),JT=1,5) /
     &4.6349E-02,4.9440E-02,5.1743E-02,5.3890E-02,5.5994E-02/
      DATA (KA(JT, 5, 3),JT=1,5) /
     &3.6507E-02,3.9309E-02,4.1637E-02,4.3586E-02,4.5365E-02/
      DATA (KA(JT, 6, 3),JT=1,5) /
     &2.8427E-02,3.1177E-02,3.3328E-02,3.5180E-02,3.6733E-02/
      DATA (KA(JT, 7, 3),JT=1,5) /
     &2.2397E-02,2.4640E-02,2.6638E-02,2.8311E-02,2.9747E-02/
      DATA (KA(JT, 8, 3),JT=1,5) /
     &1.7861E-02,1.9252E-02,2.1033E-02,2.2648E-02,2.3985E-02/
      DATA (KA(JT, 9, 3),JT=1,5) /
     &1.4398E-02,1.5884E-02,1.6962E-02,1.7935E-02,1.8840E-02/
      DATA (KA(JT,10, 3),JT=1,5) /
     &1.3336E-02,1.5085E-02,1.6848E-02,1.8578E-02,1.9024E-02/
      DATA (KA(JT,11, 3),JT=1,5) /
     &1.0996E-02,1.2680E-02,1.4233E-02,1.6184E-02,1.7835E-02/
      DATA (KA(JT,12, 3),JT=1,5) /
     &9.6066E-03,1.0608E-02,1.2101E-02,1.3713E-02,1.5338E-02/
      DATA (KA(JT,13, 3),JT=1,5) /
     &8.0007E-03,8.9344E-03,1.0260E-02,1.1651E-02,1.2914E-02/
      DATA (KA(JT, 1, 4),JT=1,5) /
     &1.4098E-01,1.4735E-01,1.5390E-01,1.6007E-01,1.6623E-01/
      DATA (KA(JT, 2, 4),JT=1,5) /
     &1.1373E-01,1.1930E-01,1.2491E-01,1.3057E-01,1.3593E-01/
      DATA (KA(JT, 3, 4),JT=1,5) /
     &9.0856E-02,9.5503E-02,1.0012E-01,1.0479E-01,1.0971E-01/
      DATA (KA(JT, 4, 4),JT=1,5) /
     &7.2695E-02,7.6746E-02,8.0662E-02,8.4622E-02,8.8881E-02/
      DATA (KA(JT, 5, 4),JT=1,5) /
     &5.8402E-02,6.1962E-02,6.5265E-02,6.8694E-02,7.2371E-02/
      DATA (KA(JT, 6, 4),JT=1,5) /
     &4.7100E-02,5.0100E-02,5.2955E-02,5.5897E-02,5.9012E-02/
      DATA (KA(JT, 7, 4),JT=1,5) /
     &3.7714E-02,4.0303E-02,4.2858E-02,4.5396E-02,4.8032E-02/
      DATA (KA(JT, 8, 4),JT=1,5) /
     &2.9938E-02,3.2418E-02,3.4599E-02,3.6801E-02,3.9055E-02/
      DATA (KA(JT, 9, 4),JT=1,5) /
     &2.3570E-02,2.5475E-02,2.7580E-02,2.9598E-02,3.1549E-02/
      DATA (KA(JT,10, 4),JT=1,5) /
     &2.3291E-02,2.1658E-02,2.1418E-02,2.1490E-02,2.3536E-02/
      DATA (KA(JT,11, 4),JT=1,5) /
     &2.1808E-02,2.2150E-02,2.2833E-02,2.0354E-02,1.9688E-02/
      DATA (KA(JT,12, 4),JT=1,5) /
     &1.9246E-02,1.9438E-02,1.9839E-02,2.0164E-02,1.7716E-02/
      DATA (KA(JT,13, 4),JT=1,5) /
     &1.6236E-02,1.6164E-02,1.6551E-02,1.6579E-02,1.4849E-02/
      DATA (KA(JT, 1, 5),JT=1,5) /
     &2.5886E-01,2.7100E-01,2.8220E-01,2.9245E-01,3.0214E-01/
      DATA (KA(JT, 2, 5),JT=1,5) /
     &2.0909E-01,2.1918E-01,2.2861E-01,2.3740E-01,2.4610E-01/
      DATA (KA(JT, 3, 5),JT=1,5) /
     &1.6622E-01,1.7497E-01,1.8311E-01,1.9088E-01,1.9860E-01/
      DATA (KA(JT, 4, 5),JT=1,5) /
     &1.3301E-01,1.4069E-01,1.4792E-01,1.5478E-01,1.6132E-01/
      DATA (KA(JT, 5, 5),JT=1,5) /
     &1.0688E-01,1.1355E-01,1.1989E-01,1.2584E-01,1.3154E-01/
      DATA (KA(JT, 6, 5),JT=1,5) /
     &8.5419E-02,9.1274E-02,9.6848E-02,1.0202E-01,1.0704E-01/
      DATA (KA(JT, 7, 5),JT=1,5) /
     &6.8100E-02,7.3262E-02,7.8047E-02,8.2594E-02,8.7027E-02/
      DATA (KA(JT, 8, 5),JT=1,5) /
     &5.4252E-02,5.8815E-02,6.2989E-02,6.6937E-02,7.0783E-02/
      DATA (KA(JT, 9, 5),JT=1,5) /
     &4.3117E-02,4.7224E-02,5.0916E-02,5.4328E-02,5.7817E-02/
      DATA (KA(JT,10, 5),JT=1,5) /
     &2.9151E-02,3.5667E-02,4.0092E-02,4.3888E-02,4.6870E-02/
      DATA (KA(JT,11, 5),JT=1,5) /
     &2.3941E-02,2.7450E-02,2.9750E-02,3.5348E-02,3.9440E-02/
      DATA (KA(JT,12, 5),JT=1,5) /
     &2.0570E-02,2.3238E-02,2.5236E-02,2.7327E-02,3.2816E-02/
      DATA (KA(JT,13, 5),JT=1,5) /
     &1.7253E-02,1.9755E-02,2.1401E-02,2.3591E-02,2.8114E-02/
      DATA (KA(JT, 1, 6),JT=1,5) /
     &5.6993E-01,6.0360E-01,6.3489E-01,6.6230E-01,6.8659E-01/
      DATA (KA(JT, 2, 6),JT=1,5) /
     &4.6502E-01,4.9401E-01,5.2007E-01,5.4304E-01,5.6306E-01/
      DATA (KA(JT, 3, 6),JT=1,5) /
     &3.7271E-01,3.9757E-01,4.1967E-01,4.3927E-01,4.5631E-01/
      DATA (KA(JT, 4, 6),JT=1,5) /
     &2.9874E-01,3.1990E-01,3.3890E-01,3.5594E-01,3.7139E-01/
      DATA (KA(JT, 5, 6),JT=1,5) /
     &2.3859E-01,2.5711E-01,2.7375E-01,2.8893E-01,3.0280E-01/
      DATA (KA(JT, 6, 6),JT=1,5) /
     &1.8917E-01,2.0549E-01,2.2017E-01,2.3369E-01,2.4611E-01/
      DATA (KA(JT, 7, 6),JT=1,5) /
     &1.4938E-01,1.6367E-01,1.7681E-01,1.8887E-01,1.9989E-01/
      DATA (KA(JT, 8, 6),JT=1,5) /
     &1.1758E-01,1.3011E-01,1.4157E-01,1.5226E-01,1.6197E-01/
      DATA (KA(JT, 9, 6),JT=1,5) /
     &9.1609E-02,1.0230E-01,1.1226E-01,1.2154E-01,1.2990E-01/
      DATA (KA(JT,10, 6),JT=1,5) /
     &7.2629E-02,8.2527E-02,9.1786E-02,1.0065E-01,1.0832E-01/
      DATA (KA(JT,11, 6),JT=1,5) /
     &6.0173E-02,6.9095E-02,7.8339E-02,8.6340E-02,9.2996E-02/
      DATA (KA(JT,12, 6),JT=1,5) /
     &5.1074E-02,5.9514E-02,6.6969E-02,7.3447E-02,7.9277E-02/
      DATA (KA(JT,13, 6),JT=1,5) /
     &4.3826E-02,5.0848E-02,5.7125E-02,6.2916E-02,6.7915E-02/
      DATA (KA(JT, 1, 7),JT=1,5) /
     &1.4129E+00,1.4750E+00,1.5277E+00,1.5727E+00,1.6117E+00/
      DATA (KA(JT, 2, 7),JT=1,5) /
     &1.1749E+00,1.2287E+00,1.2750E+00,1.3159E+00,1.3523E+00/
      DATA (KA(JT, 3, 7),JT=1,5) /
     &9.5348E-01,1.0008E+00,1.0433E+00,1.0822E+00,1.1168E+00/
      DATA (KA(JT, 4, 7),JT=1,5) /
     &7.6995E-01,8.1381E-01,8.5421E-01,8.9012E-01,9.2111E-01/
      DATA (KA(JT, 5, 7),JT=1,5) /
     &6.2211E-01,6.6255E-01,6.9934E-01,7.3149E-01,7.5879E-01/
      DATA (KA(JT, 6, 7),JT=1,5) /
     &5.0056E-01,5.3742E-01,5.7038E-01,5.9882E-01,6.2305E-01/
      DATA (KA(JT, 7, 7),JT=1,5) /
     &4.0115E-01,4.3352E-01,4.6244E-01,4.8765E-01,5.0920E-01/
      DATA (KA(JT, 8, 7),JT=1,5) /
     &3.1902E-01,3.4754E-01,3.7305E-01,3.9544E-01,4.1482E-01/
      DATA (KA(JT, 9, 7),JT=1,5) /
     &2.5207E-01,2.7718E-01,2.9962E-01,3.1933E-01,3.3666E-01/
      DATA (KA(JT,10, 7),JT=1,5) /
     &1.9498E-01,2.1588E-01,2.3464E-01,2.5127E-01,2.6668E-01/
      DATA (KA(JT,11, 7),JT=1,5) /
     &1.6583E-01,1.8332E-01,1.9835E-01,2.1191E-01,2.2523E-01/
      DATA (KA(JT,12, 7),JT=1,5) /
     &1.3827E-01,1.5202E-01,1.6547E-01,1.7854E-01,1.8991E-01/
      DATA (KA(JT,13, 7),JT=1,5) /
     &1.1534E-01,1.2733E-01,1.3962E-01,1.4987E-01,1.6008E-01/
      DATA (KA(JT, 1, 8),JT=1,5) /
     &3.5920E+00,3.7800E+00,3.9524E+00,4.1109E+00,4.2529E+00/
      DATA (KA(JT, 2, 8),JT=1,5) /
     &3.2111E+00,3.3886E+00,3.5521E+00,3.6948E+00,3.8225E+00/
      DATA (KA(JT, 3, 8),JT=1,5) /
     &2.7787E+00,2.9477E+00,3.0955E+00,3.2271E+00,3.3442E+00/
      DATA (KA(JT, 4, 8),JT=1,5) /
     &2.3588E+00,2.5119E+00,2.6472E+00,2.7686E+00,2.8775E+00/
      DATA (KA(JT, 5, 8),JT=1,5) /
     &1.9705E+00,2.1082E+00,2.2326E+00,2.3452E+00,2.4470E+00/
      DATA (KA(JT, 6, 8),JT=1,5) /
     &1.6168E+00,1.7418E+00,1.8565E+00,1.9616E+00,2.0551E+00/
      DATA (KA(JT, 7, 8),JT=1,5) /
     &1.3089E+00,1.4235E+00,1.5288E+00,1.6233E+00,1.7079E+00/
      DATA (KA(JT, 8, 8),JT=1,5) /
     &1.0505E+00,1.1539E+00,1.2478E+00,1.3319E+00,1.4095E+00/
      DATA (KA(JT, 9, 8),JT=1,5) /
     &8.3583E-01,9.2738E-01,1.0101E+00,1.0861E+00,1.1567E+00/
      DATA (KA(JT,10, 8),JT=1,5) /
     &6.6552E-01,7.4516E-01,8.1795E-01,8.8505E-01,9.4596E-01/
      DATA (KA(JT,11, 8),JT=1,5) /
     &5.5048E-01,6.1499E-01,6.7571E-01,7.3145E-01,7.8064E-01/
      DATA (KA(JT,12, 8),JT=1,5) /
     &4.5804E-01,5.1260E-01,5.6222E-01,6.0624E-01,6.4709E-01/
      DATA (KA(JT,13, 8),JT=1,5) /
     &3.8513E-01,4.3049E-01,4.7109E-01,5.0795E-01,5.3980E-01/
      DATA (KA(JT, 1, 9),JT=1,5) /
     &1.0443E+01,1.1048E+01,1.1589E+01,1.2078E+01,1.2523E+01/
      DATA (KA(JT, 2, 9),JT=1,5) /
     &1.0305E+01,1.0938E+01,1.1513E+01,1.2045E+01,1.2531E+01/
      DATA (KA(JT, 3, 9),JT=1,5) /
     &9.8576E+00,1.0529E+01,1.1150E+01,1.1712E+01,1.2221E+01/
      DATA (KA(JT, 4, 9),JT=1,5) /
     &9.2371E+00,9.9233E+00,1.0551E+01,1.1124E+01,1.1647E+01/
      DATA (KA(JT, 5, 9),JT=1,5) /
     &8.4700E+00,9.1602E+00,9.7951E+00,1.0380E+01,1.0911E+01/
      DATA (KA(JT, 6, 9),JT=1,5) /
     &7.5880E+00,8.2763E+00,8.9154E+00,9.5007E+00,1.0024E+01/
      DATA (KA(JT, 7, 9),JT=1,5) /
     &6.6790E+00,7.3503E+00,7.9748E+00,8.5357E+00,9.0412E+00/
      DATA (KA(JT, 8, 9),JT=1,5) /
     &5.7712E+00,6.4120E+00,7.0009E+00,7.5325E+00,8.0088E+00/
      DATA (KA(JT, 9, 9),JT=1,5) /
     &4.8989E+00,5.4909E+00,6.0328E+00,6.5241E+00,6.9680E+00/
      DATA (KA(JT,10, 9),JT=1,5) /
     &4.1164E+00,4.6491E+00,5.1402E+00,5.5886E+00,6.0036E+00/
      DATA (KA(JT,11, 9),JT=1,5) /
     &3.6151E+00,4.0753E+00,4.5022E+00,4.8994E+00,5.2546E+00/
      DATA (KA(JT,12, 9),JT=1,5) /
     &3.1350E+00,3.5329E+00,3.9073E+00,4.2435E+00,4.5415E+00/
      DATA (KA(JT,13, 9),JT=1,5) /
     &2.6929E+00,3.0365E+00,3.3480E+00,3.6295E+00,3.8842E+00/
      DATA (KA(JT, 1,10),JT=1,5) /
     &1.9924E+01,2.0919E+01,2.2000E+01,2.2972E+01,2.3773E+01/
      DATA (KA(JT, 2,10),JT=1,5) /
     &2.0689E+01,2.1909E+01,2.3034E+01,2.3987E+01,2.4788E+01/
      DATA (KA(JT, 3,10),JT=1,5) /
     &2.0776E+01,2.2053E+01,2.3211E+01,2.4276E+01,2.5292E+01/
      DATA (KA(JT, 4,10),JT=1,5) /
     &2.0236E+01,2.1839E+01,2.3315E+01,2.4662E+01,2.5879E+01/
      DATA (KA(JT, 5,10),JT=1,5) /
     &1.9987E+01,2.1808E+01,2.3390E+01,2.4727E+01,2.5958E+01/
      DATA (KA(JT, 6,10),JT=1,5) /
     &1.9523E+01,2.1285E+01,2.2798E+01,2.4193E+01,2.5643E+01/
      DATA (KA(JT, 7,10),JT=1,5) /
     &1.8326E+01,2.0057E+01,2.1638E+01,2.3310E+01,2.4996E+01/
      DATA (KA(JT, 8,10),JT=1,5) /
     &1.6812E+01,1.8592E+01,2.0423E+01,2.2320E+01,2.4092E+01/
      DATA (KA(JT, 9,10),JT=1,5) /
     &1.5126E+01,1.7059E+01,1.9069E+01,2.1023E+01,2.2713E+01/
      DATA (KA(JT,10,10),JT=1,5) /
     &1.3603E+01,1.5643E+01,1.7659E+01,1.9476E+01,2.1017E+01/
      DATA (KA(JT,11,10),JT=1,5) /
     &1.3136E+01,1.5065E+01,1.6788E+01,1.8298E+01,1.9745E+01/
      DATA (KA(JT,12,10),JT=1,5) /
     &1.2291E+01,1.3925E+01,1.5389E+01,1.6819E+01,1.8254E+01/
      DATA (KA(JT,13,10),JT=1,5) /
     &1.1103E+01,1.2502E+01,1.3897E+01,1.5277E+01,1.6528E+01/
      DATA (KA(JT, 1,11),JT=1,5) /
     &2.4296E+01,2.5293E+01,2.6167E+01,2.7129E+01,2.8181E+01/
      DATA (KA(JT, 2,11),JT=1,5) /
     &2.5960E+01,2.7094E+01,2.8248E+01,2.9459E+01,3.0485E+01/
      DATA (KA(JT, 3,11),JT=1,5) /
     &2.6865E+01,2.8307E+01,2.9751E+01,3.1102E+01,3.2279E+01/
      DATA (KA(JT, 4,11),JT=1,5) /
     &2.7354E+01,2.8995E+01,3.0628E+01,3.2100E+01,3.3421E+01/
      DATA (KA(JT, 5,11),JT=1,5) /
     &2.6969E+01,2.8892E+01,3.0767E+01,3.2621E+01,3.4273E+01/
      DATA (KA(JT, 6,11),JT=1,5) /
     &2.6094E+01,2.8469E+01,3.0801E+01,3.2980E+01,3.4919E+01/
      DATA (KA(JT, 7,11),JT=1,5) /
     &2.5366E+01,2.8149E+01,3.0864E+01,3.3154E+01,3.5069E+01/
      DATA (KA(JT, 8,11),JT=1,5) /
     &2.4570E+01,2.7568E+01,3.0172E+01,3.2348E+01,3.4412E+01/
      DATA (KA(JT, 9,11),JT=1,5) /
     &2.3141E+01,2.6027E+01,2.8564E+01,3.0892E+01,3.3292E+01/
      DATA (KA(JT,10,11),JT=1,5) /
     &2.1375E+01,2.4163E+01,2.6748E+01,2.9381E+01,3.2113E+01/
      DATA (KA(JT,11,11),JT=1,5) /
     &2.0563E+01,2.3343E+01,2.6200E+01,2.9082E+01,3.1737E+01/
      DATA (KA(JT,12,11),JT=1,5) /
     &1.9759E+01,2.2669E+01,2.5592E+01,2.8225E+01,3.0484E+01/
      DATA (KA(JT,13,11),JT=1,5) /
     &1.9005E+01,2.1823E+01,2.4335E+01,2.6560E+01,2.8649E+01/
      DATA (KA(JT, 1,12),JT=1,5) /
     &2.8554E+01,3.0109E+01,3.1534E+01,3.2820E+01,3.3912E+01/
      DATA (KA(JT, 2,12),JT=1,5) /
     &3.1883E+01,3.3547E+01,3.5069E+01,3.6425E+01,3.7803E+01/
      DATA (KA(JT, 3,12),JT=1,5) /
     &3.5025E+01,3.6824E+01,3.8424E+01,3.9924E+01,4.1396E+01/
      DATA (KA(JT, 4,12),JT=1,5) /
     &3.7112E+01,3.9231E+01,4.1147E+01,4.2932E+01,4.4646E+01/
      DATA (KA(JT, 5,12),JT=1,5) /
     &3.8447E+01,4.0861E+01,4.3125E+01,4.5199E+01,4.7297E+01/
      DATA (KA(JT, 6,12),JT=1,5) /
     &3.8994E+01,4.1741E+01,4.4237E+01,4.6637E+01,4.8930E+01/
      DATA (KA(JT, 7,12),JT=1,5) /
     &3.8693E+01,4.1674E+01,4.4392E+01,4.7287E+01,5.0041E+01/
      DATA (KA(JT, 8,12),JT=1,5) /
     &3.7231E+01,4.0534E+01,4.3968E+01,4.7486E+01,5.0745E+01/
      DATA (KA(JT, 9,12),JT=1,5) /
     &3.5314E+01,3.9308E+01,4.3458E+01,4.7418E+01,5.1164E+01/
      DATA (KA(JT,10,12),JT=1,5) /
     &3.3674E+01,3.8340E+01,4.2937E+01,4.7301E+01,5.1085E+01/
      DATA (KA(JT,11,12),JT=1,5) /
     &3.4306E+01,3.9228E+01,4.3781E+01,4.7771E+01,5.1424E+01/
      DATA (KA(JT,12,12),JT=1,5) /
     &3.4432E+01,3.9064E+01,4.3274E+01,4.7292E+01,5.1289E+01/
      DATA (KA(JT,13,12),JT=1,5) /
     &3.3504E+01,3.7950E+01,4.2337E+01,4.6726E+01,5.1022E+01/
      DATA (KA(JT, 1,13),JT=1,5) /
     &3.3083E+01,3.5231E+01,3.7169E+01,3.8902E+01,4.0496E+01/
      DATA (KA(JT, 2,13),JT=1,5) /
     &3.7816E+01,4.0283E+01,4.2419E+01,4.4328E+01,4.6116E+01/
      DATA (KA(JT, 3,13),JT=1,5) /
     &4.2916E+01,4.5668E+01,4.8087E+01,5.0367E+01,5.2460E+01/
      DATA (KA(JT, 4,13),JT=1,5) /
     &4.7941E+01,5.0937E+01,5.3613E+01,5.6174E+01,5.8534E+01/
      DATA (KA(JT, 5,13),JT=1,5) /
     &5.2708E+01,5.6040E+01,5.9163E+01,6.2033E+01,6.4593E+01/
      DATA (KA(JT, 6,13),JT=1,5) /
     &5.6670E+01,6.0546E+01,6.4072E+01,6.7245E+01,7.0176E+01/
      DATA (KA(JT, 7,13),JT=1,5) /
     &5.9263E+01,6.3946E+01,6.8113E+01,7.1753E+01,7.5271E+01/
      DATA (KA(JT, 8,13),JT=1,5) /
     &6.0990E+01,6.6317E+01,7.1009E+01,7.5310E+01,7.9458E+01/
      DATA (KA(JT, 9,13),JT=1,5) /
     &6.1500E+01,6.7310E+01,7.2473E+01,7.7444E+01,8.1955E+01/
      DATA (KA(JT,10,13),JT=1,5) /
     &6.1095E+01,6.7188E+01,7.2950E+01,7.8366E+01,8.3528E+01/
      DATA (KA(JT,11,13),JT=1,5) /
     &6.2204E+01,6.8688E+01,7.5122E+01,8.1365E+01,8.7577E+01/
      DATA (KA(JT,12,13),JT=1,5) /
     &6.2610E+01,7.0078E+01,7.7313E+01,8.4495E+01,9.1274E+01/
      DATA (KA(JT,13,13),JT=1,5) /
     &6.3252E+01,7.1343E+01,7.9418E+01,8.6956E+01,9.3893E+01/
      DATA (KA(JT, 1,14),JT=1,5) /
     &4.3344E+01,4.5304E+01,4.7200E+01,4.8977E+01,5.0634E+01/
      DATA (KA(JT, 2,14),JT=1,5) /
     &4.8672E+01,5.1219E+01,5.3748E+01,5.6207E+01,5.8584E+01/
      DATA (KA(JT, 3,14),JT=1,5) /
     &5.3835E+01,5.7385E+01,6.0811E+01,6.4094E+01,6.7183E+01/
      DATA (KA(JT, 4,14),JT=1,5) /
     &5.9051E+01,6.3463E+01,6.7847E+01,7.2047E+01,7.6005E+01/
      DATA (KA(JT, 5,14),JT=1,5) /
     &6.4910E+01,7.0372E+01,7.5734E+01,8.0867E+01,8.5466E+01/
      DATA (KA(JT, 6,14),JT=1,5) /
     &7.1177E+01,7.7830E+01,8.4454E+01,9.0502E+01,9.5851E+01/
      DATA (KA(JT, 7,14),JT=1,5) /
     &7.8645E+01,8.6401E+01,9.3877E+01,1.0067E+02,1.0680E+02/
      DATA (KA(JT, 8,14),JT=1,5) /
     &8.6837E+01,9.5972E+01,1.0455E+02,1.1218E+02,1.1889E+02/
      DATA (KA(JT, 9,14),JT=1,5) /
     &9.4588E+01,1.0523E+02,1.1528E+02,1.2405E+02,1.3172E+02/
      DATA (KA(JT,10,14),JT=1,5) /
     &1.0185E+02,1.1428E+02,1.2585E+02,1.3577E+02,1.4474E+02/
      DATA (KA(JT,11,14),JT=1,5) /
     &1.1416E+02,1.2817E+02,1.4064E+02,1.5135E+02,1.6079E+02/
      DATA (KA(JT,12,14),JT=1,5) /
     &1.2658E+02,1.4157E+02,1.5496E+02,1.6630E+02,1.7621E+02/
      DATA (KA(JT,13,14),JT=1,5) /
     &1.3763E+02,1.5352E+02,1.6709E+02,1.7925E+02,1.9013E+02/
      DATA (KA(JT, 1,15),JT=1,5) /
     &5.4748E+01,5.6924E+01,5.8795E+01,6.0375E+01,6.1716E+01/
      DATA (KA(JT, 2,15),JT=1,5) /
     &6.5566E+01,6.8287E+01,7.0585E+01,7.2551E+01,7.4160E+01/
      DATA (KA(JT, 3,15),JT=1,5) /
     &7.7583E+01,8.1027E+01,8.3928E+01,8.6358E+01,8.8397E+01/
      DATA (KA(JT, 4,15),JT=1,5) /
     &8.9871E+01,9.4173E+01,9.7817E+01,1.0084E+02,1.0339E+02/
      DATA (KA(JT, 5,15),JT=1,5) /
     &1.0246E+02,1.0776E+02,1.1220E+02,1.1592E+02,1.1961E+02/
      DATA (KA(JT, 6,15),JT=1,5) /
     &1.1487E+02,1.2133E+02,1.2665E+02,1.3188E+02,1.3707E+02/
      DATA (KA(JT, 7,15),JT=1,5) /
     &1.2683E+02,1.3446E+02,1.4160E+02,1.4872E+02,1.5558E+02/
      DATA (KA(JT, 8,15),JT=1,5) /
     &1.3795E+02,1.4756E+02,1.5674E+02,1.6606E+02,1.7523E+02/
      DATA (KA(JT, 9,15),JT=1,5) /
     &1.4965E+02,1.6170E+02,1.7284E+02,1.8422E+02,1.9597E+02/
      DATA (KA(JT,10,15),JT=1,5) /
     &1.6376E+02,1.7796E+02,1.9116E+02,2.0528E+02,2.1939E+02/
      DATA (KA(JT,11,15),JT=1,5) /
     &1.8752E+02,2.0335E+02,2.1913E+02,2.3662E+02,2.5359E+02/
      DATA (KA(JT,12,15),JT=1,5) /
     &2.1430E+02,2.3299E+02,2.5241E+02,2.7277E+02,2.9286E+02/
      DATA (KA(JT,13,15),JT=1,5) /
     &2.4469E+02,2.6735E+02,2.9101E+02,3.1438E+02,3.3674E+02/
      DATA (KA(JT, 1,16),JT=1,5) /
     &5.6182E+01,5.8534E+01,6.0580E+01,6.2336E+01,6.3846E+01/
      DATA (KA(JT, 2,16),JT=1,5) /
     &6.7714E+01,7.1253E+01,7.3886E+01,7.6167E+01,7.8129E+01/
      DATA (KA(JT, 3,16),JT=1,5) /
     &8.2239E+01,8.6274E+01,8.9810E+01,9.2865E+01,9.5500E+01/
      DATA (KA(JT, 4,16),JT=1,5) /
     &9.7623E+01,1.0299E+02,1.0769E+02,1.1178E+02,1.1532E+02/
      DATA (KA(JT, 5,16),JT=1,5) /
     &1.1485E+02,1.2193E+02,1.2815E+02,1.3359E+02,1.3829E+02/
      DATA (KA(JT, 6,16),JT=1,5) /
     &1.3405E+02,1.4336E+02,1.5157E+02,1.5875E+02,1.6501E+02/
      DATA (KA(JT, 7,16),JT=1,5) /
     &1.5562E+02,1.6780E+02,1.7860E+02,1.8805E+02,1.9632E+02/
      DATA (KA(JT, 8,16),JT=1,5) /
     &1.7987E+02,1.9571E+02,2.0979E+02,2.2214E+02,2.3298E+02/
      DATA (KA(JT, 9,16),JT=1,5) /
     &2.0674E+02,2.2717E+02,2.4538E+02,2.6145E+02,2.7552E+02/
      DATA (KA(JT,10,16),JT=1,5) /
     &2.3822E+02,2.6423E+02,2.8739E+02,3.0794E+02,3.2592E+02/
      DATA (KA(JT,11,16),JT=1,5) /
     &2.8871E+02,3.1996E+02,3.4774E+02,3.7226E+02,3.9354E+02/
      DATA (KA(JT,12,16),JT=1,5) /
     &3.4916E+02,3.8637E+02,4.1932E+02,4.4825E+02,4.7321E+02/
      DATA (KA(JT,13,16),JT=1,5) /
     &4.2045E+02,4.6429E+02,5.0303E+02,5.3671E+02,5.6546E+02/

C     The array KB contains absorption coefs at the 16 chosen g-values 
C     for a range of pressure levels < ~100mb and temperatures. The first 
C     index in the array, JT, which runs from 1 to 5, corresponds to 
C     different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this pressure 
C     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
C     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
C     The second index, JP, runs from 13 to 59 and refers to the JPth
C     reference pressure level (see taumol.f for the value of these
C     pressure levels in mb).  The third index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.
      DATA (KB(JT,13, 1),JT=1,5) /
     &2.1558E-03,2.5890E-03,2.9127E-03,3.2139E-03,3.5455E-03/
      DATA (KB(JT,14, 1),JT=1,5) /
     &1.8304E-03,2.1809E-03,2.4298E-03,2.6878E-03,2.9625E-03/
      DATA (KB(JT,15, 1),JT=1,5) /
     &1.5486E-03,1.7962E-03,2.0058E-03,2.2286E-03,2.4705E-03/
      DATA (KB(JT,16, 1),JT=1,5) /
     &1.3025E-03,1.4833E-03,1.6606E-03,1.8503E-03,2.0485E-03/
      DATA (KB(JT,17, 1),JT=1,5) /
     &1.0810E-03,1.2227E-03,1.3725E-03,1.5304E-03,1.6938E-03/
      DATA (KB(JT,18, 1),JT=1,5) /
     &8.7942E-04,1.0015E-03,1.1266E-03,1.2596E-03,1.3951E-03/
      DATA (KB(JT,19, 1),JT=1,5) /
     &7.2280E-04,8.2373E-04,9.2739E-04,1.0381E-03,1.1467E-03/
      DATA (KB(JT,20, 1),JT=1,5) /
     &6.0184E-04,6.8491E-04,7.6954E-04,8.5989E-04,9.4913E-04/
      DATA (KB(JT,21, 1),JT=1,5) /
     &5.0117E-04,5.6823E-04,6.3855E-04,7.1320E-04,7.8654E-04/
      DATA (KB(JT,22, 1),JT=1,5) /
     &4.1938E-04,4.7543E-04,5.3375E-04,5.9543E-04,6.5571E-04/
      DATA (KB(JT,23, 1),JT=1,5) /
     &3.5199E-04,3.9855E-04,4.4679E-04,4.9714E-04,5.4750E-04/
      DATA (KB(JT,24, 1),JT=1,5) /
     &2.9639E-04,3.3452E-04,3.7432E-04,4.1615E-04,4.5706E-04/
      DATA (KB(JT,25, 1),JT=1,5) /
     &2.4906E-04,2.8117E-04,3.1412E-04,3.4839E-04,3.7317E-04/
      DATA (KB(JT,26, 1),JT=1,5) /
     &2.1029E-04,2.3678E-04,2.6421E-04,2.9238E-04,3.0575E-04/
      DATA (KB(JT,27, 1),JT=1,5) /
     &1.7727E-04,1.9942E-04,2.2208E-04,2.4556E-04,2.5262E-04/
      DATA (KB(JT,28, 1),JT=1,5) /
     &1.4969E-04,1.6790E-04,1.8692E-04,2.0183E-04,2.0915E-04/
      DATA (KB(JT,29, 1),JT=1,5) /
     &1.2629E-04,1.4151E-04,1.5706E-04,1.6548E-04,1.7223E-04/
      DATA (KB(JT,30, 1),JT=1,5) /
     &1.0651E-04,1.1909E-04,1.3186E-04,1.3639E-04,1.4198E-04/
      DATA (KB(JT,31, 1),JT=1,5) /
     &8.9698E-05,1.0002E-04,1.0798E-04,1.1271E-04,1.1661E-04/
      DATA (KB(JT,32, 1),JT=1,5) /
     &7.5536E-05,8.4037E-05,8.8553E-05,9.2337E-05,9.5468E-05/
      DATA (KB(JT,33, 1),JT=1,5) /
     &6.3563E-05,7.0507E-05,7.3023E-05,7.6153E-05,7.8142E-05/
      DATA (KB(JT,34, 1),JT=1,5) /
     &5.3365E-05,5.7820E-05,6.0490E-05,6.2653E-05,6.4307E-05/
      DATA (KB(JT,35, 1),JT=1,5) /
     &4.4295E-05,4.7505E-05,4.9568E-05,5.1436E-05,5.2756E-05/
      DATA (KB(JT,36, 1),JT=1,5) /
     &3.6359E-05,3.8955E-05,4.0612E-05,4.2071E-05,4.3157E-05/
      DATA (KB(JT,37, 1),JT=1,5) /
     &2.9443E-05,3.1950E-05,3.3272E-05,3.4376E-05,3.5259E-05/
      DATA (KB(JT,38, 1),JT=1,5) /
     &2.3815E-05,2.6274E-05,2.7165E-05,2.8049E-05,2.8811E-05/
      DATA (KB(JT,39, 1),JT=1,5) /
     &1.9245E-05,2.1354E-05,2.2111E-05,2.2930E-05,2.3532E-05/
      DATA (KB(JT,40, 1),JT=1,5) /
     &1.5405E-05,1.7147E-05,1.8049E-05,1.8756E-05,1.9282E-05/
      DATA (KB(JT,41, 1),JT=1,5) /
     &1.2319E-05,1.3748E-05,1.4753E-05,1.5289E-05,1.5770E-05/
      DATA (KB(JT,42, 1),JT=1,5) /
     &9.8357E-06,1.1012E-05,1.2183E-05,1.2499E-05,1.2877E-05/
      DATA (KB(JT,43, 1),JT=1,5) /
     &7.7892E-06,8.7858E-06,9.7457E-06,1.0234E-05,1.0599E-05/
      DATA (KB(JT,44, 1),JT=1,5) /
     &6.1605E-06,6.9805E-06,7.7675E-06,8.4197E-06,8.6950E-06/
      DATA (KB(JT,45, 1),JT=1,5) /
     &4.8809E-06,5.5274E-06,6.1865E-06,6.8268E-06,7.0906E-06/
      DATA (KB(JT,46, 1),JT=1,5) /
     &3.8470E-06,4.3665E-06,4.9029E-06,5.4349E-06,5.8089E-06/
      DATA (KB(JT,47, 1),JT=1,5) /
     &3.0311E-06,3.4294E-06,3.8630E-06,4.3044E-06,4.7453E-06/
      DATA (KB(JT,48, 1),JT=1,5) /
     &2.3694E-06,2.7049E-06,3.0473E-06,3.4008E-06,3.7674E-06/
      DATA (KB(JT,49, 1),JT=1,5) /
     &1.8467E-06,2.1296E-06,2.4020E-06,2.6917E-06,2.9837E-06/
      DATA (KB(JT,50, 1),JT=1,5) /
     &1.4542E-06,1.6765E-06,1.8996E-06,2.1320E-06,2.3692E-06/
      DATA (KB(JT,51, 1),JT=1,5) /
     &1.1539E-06,1.3178E-06,1.5055E-06,1.6911E-06,1.8864E-06/
      DATA (KB(JT,52, 1),JT=1,5) /
     &8.7493E-07,1.0411E-06,1.1898E-06,1.3435E-06,1.4983E-06/
      DATA (KB(JT,53, 1),JT=1,5) /
     &6.6072E-07,8.3282E-07,9.4298E-07,1.0653E-06,1.1935E-06/
      DATA (KB(JT,54, 1),JT=1,5) /
     &5.0251E-07,6.4316E-07,7.5237E-07,8.5108E-07,9.5630E-07/
      DATA (KB(JT,55, 1),JT=1,5) /
     &3.8195E-07,4.9281E-07,6.0554E-07,6.8279E-07,7.6458E-07/
      DATA (KB(JT,56, 1),JT=1,5) /
     &2.8943E-07,3.7779E-07,4.8048E-07,5.4688E-07,6.1650E-07/
      DATA (KB(JT,57, 1),JT=1,5) /
     &2.1868E-07,2.8870E-07,3.7076E-07,4.4677E-07,4.9616E-07/
      DATA (KB(JT,58, 1),JT=1,5) /
     &1.6598E-07,2.2133E-07,2.8693E-07,3.5995E-07,4.0195E-07/
      DATA (KB(JT,59, 1),JT=1,5) /
     &1.3312E-07,1.7804E-07,2.3134E-07,2.9072E-07,3.3304E-07/
      DATA (KB(JT,13, 2),JT=1,5) /
     &5.7626E-03,6.1115E-03,6.3578E-03,6.6833E-03,6.9834E-03/
      DATA (KB(JT,14, 2),JT=1,5) /
     &4.7365E-03,4.9915E-03,5.2669E-03,5.5245E-03,5.7996E-03/
      DATA (KB(JT,15, 2),JT=1,5) /
     &3.8570E-03,4.0469E-03,4.3101E-03,4.5195E-03,4.7607E-03/
      DATA (KB(JT,16, 2),JT=1,5) /
     &3.0836E-03,3.2692E-03,3.4748E-03,3.6812E-03,3.8941E-03/
      DATA (KB(JT,17, 2),JT=1,5) /
     &2.4665E-03,2.6482E-03,2.8018E-03,2.9854E-03,3.1785E-03/
      DATA (KB(JT,18, 2),JT=1,5) /
     &1.9741E-03,2.1245E-03,2.2564E-03,2.4081E-03,2.5780E-03/
      DATA (KB(JT,19, 2),JT=1,5) /
     &1.5958E-03,1.7126E-03,1.8351E-03,1.9560E-03,2.0570E-03/
      DATA (KB(JT,20, 2),JT=1,5) /
     &1.3038E-03,1.3978E-03,1.5013E-03,1.6102E-03,1.6734E-03/
      DATA (KB(JT,21, 2),JT=1,5) /
     &1.0706E-03,1.1492E-03,1.2352E-03,1.3269E-03,1.3755E-03/
      DATA (KB(JT,22, 2),JT=1,5) /
     &8.8260E-04,9.4987E-04,1.0209E-03,1.0834E-03,1.1278E-03/
      DATA (KB(JT,23, 2),JT=1,5) /
     &7.2583E-04,7.8218E-04,8.4637E-04,8.8814E-04,9.2896E-04/
      DATA (KB(JT,24, 2),JT=1,5) /
     &6.0040E-04,6.4872E-04,7.0437E-04,7.3258E-04,7.6936E-04/
      DATA (KB(JT,25, 2),JT=1,5) /
     &4.9798E-04,5.3936E-04,5.8024E-04,6.0451E-04,6.4613E-04/
      DATA (KB(JT,26, 2),JT=1,5) /
     &4.1436E-04,4.5078E-04,4.7645E-04,5.0082E-04,5.4367E-04/
      DATA (KB(JT,27, 2),JT=1,5) /
     &3.4567E-04,3.7682E-04,3.9546E-04,4.1621E-04,4.5625E-04/
      DATA (KB(JT,28, 2),JT=1,5) /
     &2.8902E-04,3.1546E-04,3.2798E-04,3.5075E-04,3.8306E-04/
      DATA (KB(JT,29, 2),JT=1,5) /
     &2.4193E-04,2.5865E-04,2.7208E-04,2.9507E-04,3.2156E-04/
      DATA (KB(JT,30, 2),JT=1,5) /
     &2.0282E-04,2.1375E-04,2.2606E-04,2.4794E-04,2.6904E-04/
      DATA (KB(JT,31, 2),JT=1,5) /
     &1.6986E-04,1.7726E-04,1.9036E-04,2.0754E-04,2.2529E-04/
      DATA (KB(JT,32, 2),JT=1,5) /
     &1.3922E-04,1.4692E-04,1.5999E-04,1.7445E-04,1.8931E-04/
      DATA (KB(JT,33, 2),JT=1,5) /
     &1.1520E-04,1.2220E-04,1.3453E-04,1.4590E-04,1.5875E-04/
      DATA (KB(JT,34, 2),JT=1,5) /
     &9.5764E-05,1.0295E-04,1.1231E-04,1.2221E-04,1.3235E-04/
      DATA (KB(JT,35, 2),JT=1,5) /
     &7.8951E-05,8.5467E-05,9.3381E-05,1.0154E-04,1.0962E-04/
      DATA (KB(JT,36, 2),JT=1,5) /
     &6.4805E-05,7.0212E-05,7.6766E-05,8.3544E-05,9.0139E-05/
      DATA (KB(JT,37, 2),JT=1,5) /
     &5.2918E-05,5.7064E-05,6.2426E-05,6.8102E-05,7.3562E-05/
      DATA (KB(JT,38, 2),JT=1,5) /
     &4.3224E-05,4.6216E-05,5.0772E-05,5.5504E-05,6.0016E-05/
      DATA (KB(JT,39, 2),JT=1,5) /
     &3.5291E-05,3.7592E-05,4.1355E-05,4.5145E-05,4.8932E-05/
      DATA (KB(JT,40, 2),JT=1,5) /
     &2.8761E-05,3.0515E-05,3.3449E-05,3.6463E-05,3.9654E-05/
      DATA (KB(JT,41, 2),JT=1,5) /
     &2.3487E-05,2.4801E-05,2.6922E-05,2.9459E-05,3.2147E-05/
      DATA (KB(JT,42, 2),JT=1,5) /
     &1.9314E-05,2.0243E-05,2.1564E-05,2.3753E-05,2.5964E-05/
      DATA (KB(JT,43, 2),JT=1,5) /
     &1.5553E-05,1.6470E-05,1.7479E-05,1.9035E-05,2.0784E-05/
      DATA (KB(JT,44, 2),JT=1,5) /
     &1.2457E-05,1.3468E-05,1.4190E-05,1.5199E-05,1.6632E-05/
      DATA (KB(JT,45, 2),JT=1,5) /
     &9.9734E-06,1.1008E-05,1.1581E-05,1.2254E-05,1.3346E-05/
      DATA (KB(JT,46, 2),JT=1,5) /
     &7.9698E-06,8.8088E-06,9.4445E-06,9.9340E-06,1.0690E-05/
      DATA (KB(JT,47, 2),JT=1,5) /
     &6.3565E-06,7.0249E-06,7.7396E-06,8.1033E-06,8.5527E-06/
      DATA (KB(JT,48, 2),JT=1,5) /
     &5.1256E-06,5.5929E-06,6.1735E-06,6.6021E-06,6.9371E-06/
      DATA (KB(JT,49, 2),JT=1,5) /
     &4.0784E-06,4.4718E-06,4.9212E-06,5.4190E-06,5.6740E-06/
      DATA (KB(JT,50, 2),JT=1,5) /
     &3.3297E-06,3.6155E-06,3.9436E-06,4.3292E-06,4.6291E-06/
      DATA (KB(JT,51, 2),JT=1,5) /
     &2.7486E-06,2.9107E-06,3.1698E-06,3.4767E-06,3.8139E-06/
      DATA (KB(JT,52, 2),JT=1,5) /
     &2.2530E-06,2.4006E-06,2.5759E-06,2.7925E-06,3.0627E-06/
      DATA (KB(JT,53, 2),JT=1,5) /
     &1.8678E-06,1.9765E-06,2.1052E-06,2.2503E-06,2.4591E-06/
      DATA (KB(JT,54, 2),JT=1,5) /
     &1.5340E-06,1.6385E-06,1.7450E-06,1.8671E-06,1.9805E-06/
      DATA (KB(JT,55, 2),JT=1,5) /
     &1.2873E-06,1.3532E-06,1.4432E-06,1.5328E-06,1.6236E-06/
      DATA (KB(JT,56, 2),JT=1,5) /
     &1.0668E-06,1.1355E-06,1.1865E-06,1.2884E-06,1.3667E-06/
      DATA (KB(JT,57, 2),JT=1,5) /
     &8.4592E-07,9.6149E-07,9.8845E-07,1.0536E-06,1.1286E-06/
      DATA (KB(JT,58, 2),JT=1,5) /
     &6.5721E-07,8.0847E-07,8.4916E-07,8.7196E-07,9.4267E-07/
      DATA (KB(JT,59, 2),JT=1,5) /
     &5.2809E-07,6.6890E-07,7.2431E-07,7.4028E-07,7.8416E-07/
      DATA (KB(JT,13, 3),JT=1,5) /
     &8.0007E-03,8.9344E-03,1.0260E-02,1.1651E-02,1.2914E-02/
      DATA (KB(JT,14, 3),JT=1,5) /
     &6.8039E-03,7.6829E-03,8.7921E-03,9.9141E-03,1.0757E-02/
      DATA (KB(JT,15, 3),JT=1,5) /
     &5.7029E-03,6.5489E-03,7.4475E-03,8.3471E-03,8.8091E-03/
      DATA (KB(JT,16, 3),JT=1,5) /
     &4.8074E-03,5.5085E-03,6.2455E-03,6.9353E-03,7.1997E-03/
      DATA (KB(JT,17, 3),JT=1,5) /
     &4.0213E-03,4.6076E-03,5.2117E-03,5.6731E-03,5.8805E-03/
      DATA (KB(JT,18, 3),JT=1,5) /
     &3.3461E-03,3.8362E-03,4.3242E-03,4.6154E-03,4.7757E-03/
      DATA (KB(JT,19, 3),JT=1,5) /
     &2.7996E-03,3.2075E-03,3.5883E-03,3.7732E-03,3.8872E-03/
      DATA (KB(JT,20, 3),JT=1,5) /
     &2.3589E-03,2.6931E-03,2.9843E-03,3.1004E-03,3.1743E-03/
      DATA (KB(JT,21, 3),JT=1,5) /
     &1.9734E-03,2.2564E-03,2.4531E-03,2.5572E-03,2.5979E-03/
      DATA (KB(JT,22, 3),JT=1,5) /
     &1.6777E-03,1.9014E-03,2.0201E-03,2.0877E-03,2.1290E-03/
      DATA (KB(JT,23, 3),JT=1,5) /
     &1.4255E-03,1.6043E-03,1.6675E-03,1.7121E-03,1.7219E-03/
      DATA (KB(JT,24, 3),JT=1,5) /
     &1.2066E-03,1.3233E-03,1.3782E-03,1.4109E-03,1.3842E-03/
      DATA (KB(JT,25, 3),JT=1,5) /
     &1.0218E-03,1.0936E-03,1.1313E-03,1.1590E-03,1.1132E-03/
      DATA (KB(JT,26, 3),JT=1,5) /
     &8.6686E-04,9.0770E-04,9.3474E-04,9.3738E-04,9.0394E-04/
      DATA (KB(JT,27, 3),JT=1,5) /
     &7.2332E-04,7.5480E-04,7.7347E-04,7.5530E-04,7.3995E-04/
      DATA (KB(JT,28, 3),JT=1,5) /
     &5.9945E-04,6.1747E-04,6.3797E-04,6.1191E-04,6.1018E-04/
      DATA (KB(JT,29, 3),JT=1,5) /
     &4.9636E-04,5.1141E-04,5.1979E-04,4.9718E-04,5.0501E-04/
      DATA (KB(JT,30, 3),JT=1,5) /
     &4.1287E-04,4.2400E-04,4.1392E-04,4.0737E-04,4.1659E-04/
      DATA (KB(JT,31, 3),JT=1,5) /
     &3.3517E-04,3.4906E-04,3.3288E-04,3.3660E-04,3.4335E-04/
      DATA (KB(JT,32, 3),JT=1,5) /
     &2.7784E-04,2.7984E-04,2.7143E-04,2.7785E-04,2.8417E-04/
      DATA (KB(JT,33, 3),JT=1,5) /
     &2.3052E-04,2.2367E-04,2.2307E-04,2.2883E-04,2.3495E-04/
      DATA (KB(JT,34, 3),JT=1,5) /
     &1.9073E-04,1.8192E-04,1.8515E-04,1.8942E-04,1.9507E-04/
      DATA (KB(JT,35, 3),JT=1,5) /
     &1.5683E-04,1.4914E-04,1.5288E-04,1.5663E-04,1.6156E-04/
      DATA (KB(JT,36, 3),JT=1,5) /
     &1.2835E-04,1.2262E-04,1.2564E-04,1.2896E-04,1.3319E-04/
      DATA (KB(JT,37, 3),JT=1,5) /
     &1.0651E-04,1.0086E-04,1.0335E-04,1.0615E-04,1.0970E-04/
      DATA (KB(JT,38, 3),JT=1,5) /
     &8.7372E-05,8.2916E-05,8.4948E-05,8.7192E-05,9.0174E-05/
      DATA (KB(JT,39, 3),JT=1,5) /
     &7.1580E-05,6.8441E-05,6.9733E-05,7.1507E-05,7.4030E-05/
      DATA (KB(JT,40, 3),JT=1,5) /
     &5.8422E-05,5.7750E-05,5.6983E-05,5.8663E-05,6.0682E-05/
      DATA (KB(JT,41, 3),JT=1,5) /
     &4.7623E-05,4.8587E-05,4.6749E-05,4.8145E-05,4.9685E-05/
      DATA (KB(JT,42, 3),JT=1,5) /
     &3.8729E-05,4.0813E-05,3.8776E-05,3.9518E-05,4.0826E-05/
      DATA (KB(JT,43, 3),JT=1,5) /
     &3.2019E-05,3.3273E-05,3.2653E-05,3.2753E-05,3.3527E-05/
      DATA (KB(JT,44, 3),JT=1,5) /
     &2.6412E-05,2.7141E-05,2.7698E-05,2.6940E-05,2.7582E-05/
      DATA (KB(JT,45, 3),JT=1,5) /
     &2.1266E-05,2.2156E-05,2.3306E-05,2.2397E-05,2.2801E-05/
      DATA (KB(JT,46, 3),JT=1,5) /
     &1.7333E-05,1.8301E-05,1.8885E-05,1.9036E-05,1.8747E-05/
      DATA (KB(JT,47, 3),JT=1,5) /
     &1.4070E-05,1.4972E-05,1.5353E-05,1.6172E-05,1.5451E-05/
      DATA (KB(JT,48, 3),JT=1,5) /
     &1.0908E-05,1.2143E-05,1.2701E-05,1.3131E-05,1.3135E-05/
      DATA (KB(JT,49, 3),JT=1,5) /
     &8.5257E-06,9.9029E-06,1.0615E-05,1.0623E-05,1.1229E-05/
      DATA (KB(JT,50, 3),JT=1,5) /
     &6.5831E-06,7.8068E-06,8.5689E-06,8.8823E-06,9.1397E-06/
      DATA (KB(JT,51, 3),JT=1,5) /
     &5.0124E-06,6.1123E-06,6.9735E-06,7.5152E-06,7.4209E-06/
      DATA (KB(JT,52, 3),JT=1,5) /
     &3.8557E-06,4.7153E-06,5.6513E-06,6.0740E-06,6.2588E-06/
      DATA (KB(JT,53, 3),JT=1,5) /
     &2.9713E-06,3.6139E-06,4.3749E-06,4.9165E-06,5.3050E-06/
      DATA (KB(JT,54, 3),JT=1,5) /
     &2.2856E-06,2.7967E-06,3.4018E-06,4.0149E-06,4.3280E-06/
      DATA (KB(JT,55, 3),JT=1,5) /
     &1.7432E-06,2.1952E-06,2.6416E-06,3.2063E-06,3.5207E-06/
      DATA (KB(JT,56, 3),JT=1,5) /
     &1.3460E-06,1.6981E-06,2.0681E-06,2.4690E-06,2.8558E-06/
      DATA (KB(JT,57, 3),JT=1,5) /
     &1.0794E-06,1.2900E-06,1.6260E-06,1.9447E-06,2.3391E-06/
      DATA (KB(JT,58, 3),JT=1,5) /
     &9.2042E-07,9.9682E-07,1.2594E-06,1.5341E-06,1.8245E-06/
      DATA (KB(JT,59, 3),JT=1,5) /
     &7.5487E-07,8.2111E-07,1.0075E-06,1.2341E-06,1.4799E-06/
      DATA (KB(JT,13, 4),JT=1,5) /
     &1.6236E-02,1.6164E-02,1.6551E-02,1.6579E-02,1.4849E-02/
      DATA (KB(JT,14, 4),JT=1,5) /
     &1.3333E-02,1.3358E-02,1.3723E-02,1.3164E-02,1.2310E-02/
      DATA (KB(JT,15, 4),JT=1,5) /
     &1.0791E-02,1.1005E-02,1.1347E-02,1.0262E-02,1.0198E-02/
      DATA (KB(JT,16, 4),JT=1,5) /
     &8.7740E-03,9.0551E-03,8.8988E-03,8.1326E-03,8.4246E-03/
      DATA (KB(JT,17, 4),JT=1,5) /
     &7.1855E-03,7.4271E-03,6.8507E-03,6.6124E-03,6.9447E-03/
      DATA (KB(JT,18, 4),JT=1,5) /
     &5.8832E-03,5.8794E-03,5.3061E-03,5.4156E-03,5.7271E-03/
      DATA (KB(JT,19, 4),JT=1,5) /
     &4.7612E-03,4.5173E-03,4.2495E-03,4.4758E-03,4.7797E-03/
      DATA (KB(JT,20, 4),JT=1,5) /
     &3.8929E-03,3.5371E-03,3.4837E-03,3.7081E-03,4.0335E-03/
      DATA (KB(JT,21, 4),JT=1,5) /
     &3.1210E-03,2.8158E-03,2.9040E-03,3.0717E-03,3.3855E-03/
      DATA (KB(JT,22, 4),JT=1,5) /
     &2.4122E-03,2.2915E-03,2.4348E-03,2.6102E-03,2.8568E-03/
      DATA (KB(JT,23, 4),JT=1,5) /
     &1.8931E-03,1.8847E-03,2.0226E-03,2.2045E-03,2.4293E-03/
      DATA (KB(JT,24, 4),JT=1,5) /
     &1.5231E-03,1.5878E-03,1.6899E-03,1.8552E-03,2.0775E-03/
      DATA (KB(JT,25, 4),JT=1,5) /
     &1.2458E-03,1.3309E-03,1.4317E-03,1.5678E-03,1.7779E-03/
      DATA (KB(JT,26, 4),JT=1,5) /
     &1.0318E-03,1.1118E-03,1.2146E-03,1.3449E-03,1.5065E-03/
      DATA (KB(JT,27, 4),JT=1,5) /
     &8.6665E-04,9.3057E-04,1.0235E-03,1.1557E-03,1.2745E-03/
      DATA (KB(JT,28, 4),JT=1,5) /
     &7.2935E-04,7.9123E-04,8.6656E-04,9.8388E-04,1.0757E-03/
      DATA (KB(JT,29, 4),JT=1,5) /
     &6.1286E-04,6.7240E-04,7.4124E-04,8.3872E-04,9.0911E-04/
      DATA (KB(JT,30, 4),JT=1,5) /
     &5.1400E-04,5.6684E-04,6.4255E-04,7.1220E-04,7.7258E-04/
      DATA (KB(JT,31, 4),JT=1,5) /
     &4.4005E-04,4.8076E-04,5.5017E-04,6.0255E-04,6.5647E-04/
      DATA (KB(JT,32, 4),JT=1,5) /
     &3.7263E-04,4.1679E-04,4.6901E-04,5.1118E-04,5.5709E-04/
      DATA (KB(JT,33, 4),JT=1,5) /
     &3.1452E-04,3.5853E-04,3.9810E-04,4.3526E-04,4.7464E-04/
      DATA (KB(JT,34, 4),JT=1,5) /
     &2.6538E-04,3.0537E-04,3.3607E-04,3.6889E-04,4.0236E-04/
      DATA (KB(JT,35, 4),JT=1,5) /
     &2.2314E-04,2.5674E-04,2.8212E-04,3.1017E-04,3.3804E-04/
      DATA (KB(JT,36, 4),JT=1,5) /
     &1.8558E-04,2.1307E-04,2.3484E-04,2.5807E-04,2.8146E-04/
      DATA (KB(JT,37, 4),JT=1,5) /
     &1.5092E-04,1.7515E-04,1.9371E-04,2.1363E-04,2.3312E-04/
      DATA (KB(JT,38, 4),JT=1,5) /
     &1.2396E-04,1.4379E-04,1.5969E-04,1.7662E-04,1.9284E-04/
      DATA (KB(JT,39, 4),JT=1,5) /
     &1.0157E-04,1.1773E-04,1.3175E-04,1.4587E-04,1.5934E-04/
      DATA (KB(JT,40, 4),JT=1,5) /
     &8.2605E-05,9.4273E-05,1.0813E-04,1.1977E-04,1.3107E-04/
      DATA (KB(JT,41, 4),JT=1,5) /
     &6.6939E-05,7.5416E-05,8.8332E-05,9.8121E-05,1.0774E-04/
      DATA (KB(JT,42, 4),JT=1,5) /
     &5.4049E-05,6.0030E-05,7.1511E-05,8.0199E-05,8.8261E-05/
      DATA (KB(JT,43, 4),JT=1,5) /
     &4.3092E-05,4.8470E-05,5.6902E-05,6.4800E-05,7.1905E-05/
      DATA (KB(JT,44, 4),JT=1,5) /
     &3.4303E-05,3.8888E-05,4.4709E-05,5.2317E-05,5.8294E-05/
      DATA (KB(JT,45, 4),JT=1,5) /
     &2.7706E-05,3.1192E-05,3.5138E-05,4.1880E-05,4.7037E-05/
      DATA (KB(JT,46, 4),JT=1,5) /
     &2.2020E-05,2.4816E-05,2.8235E-05,3.2847E-05,3.7855E-05/
      DATA (KB(JT,47, 4),JT=1,5) /
     &1.7397E-05,1.9571E-05,2.2339E-05,2.5403E-05,3.0154E-05/
      DATA (KB(JT,48, 4),JT=1,5) /
     &1.4464E-05,1.5535E-05,1.7628E-05,2.0160E-05,2.3523E-05/
      DATA (KB(JT,49, 4),JT=1,5) /
     &1.2203E-05,1.2334E-05,1.3809E-05,1.5955E-05,1.8189E-05/
      DATA (KB(JT,50, 4),JT=1,5) /
     &1.0868E-05,1.0166E-05,1.1038E-05,1.2542E-05,1.4482E-05/
      DATA (KB(JT,51, 4),JT=1,5) /
     &9.5445E-06,8.4914E-06,8.8728E-06,9.7788E-06,1.1531E-05/
      DATA (KB(JT,52, 4),JT=1,5) /
     &7.6675E-06,7.5593E-06,7.1200E-06,7.9511E-06,9.0030E-06/
      DATA (KB(JT,53, 4),JT=1,5) /
     &6.1578E-06,6.8621E-06,5.9549E-06,6.4007E-06,7.0103E-06/
      DATA (KB(JT,54, 4),JT=1,5) /
     &4.9970E-06,5.5372E-06,5.2950E-06,5.1133E-06,5.6754E-06/
      DATA (KB(JT,55, 4),JT=1,5) /
     &4.1058E-06,4.4463E-06,4.8381E-06,4.2110E-06,4.6398E-06/
      DATA (KB(JT,56, 4),JT=1,5) /
     &3.3825E-06,3.6285E-06,4.0286E-06,3.7391E-06,3.7193E-06/
      DATA (KB(JT,57, 4),JT=1,5) /
     &2.7087E-06,2.9631E-06,3.2500E-06,3.4185E-06,3.0256E-06/
      DATA (KB(JT,58, 4),JT=1,5) /
     &2.0759E-06,2.4918E-06,2.6378E-06,2.9253E-06,2.6729E-06/
      DATA (KB(JT,59, 4),JT=1,5) /
     &1.6942E-06,2.0927E-06,2.1992E-06,2.4373E-06,2.3395E-06/
      DATA (KB(JT,13, 5),JT=1,5) /
     &1.7253E-02,1.9755E-02,2.1401E-02,2.3591E-02,2.8114E-02/
      DATA (KB(JT,14, 5),JT=1,5) /
     &1.4836E-02,1.6934E-02,1.8341E-02,2.1005E-02,2.4456E-02/
      DATA (KB(JT,15, 5),JT=1,5) /
     &1.2786E-02,1.4254E-02,1.5589E-02,1.8700E-02,2.1272E-02/
      DATA (KB(JT,16, 5),JT=1,5) /
     &1.0892E-02,1.2056E-02,1.3761E-02,1.6336E-02,1.8224E-02/
      DATA (KB(JT,17, 5),JT=1,5) /
     &9.1405E-03,1.0167E-02,1.2171E-02,1.4009E-02,1.5426E-02/
      DATA (KB(JT,18, 5),JT=1,5) /
     &7.6420E-03,8.7762E-03,1.0582E-02,1.1875E-02,1.2969E-02/
      DATA (KB(JT,19, 5),JT=1,5) /
     &6.4312E-03,7.6685E-03,8.9635E-03,9.9226E-03,1.0844E-02/
      DATA (KB(JT,20, 5),JT=1,5) /
     &5.4039E-03,6.6521E-03,7.5702E-03,8.3653E-03,9.0934E-03/
      DATA (KB(JT,21, 5),JT=1,5) /
     &4.6584E-03,5.7137E-03,6.4063E-03,7.0462E-03,7.6384E-03/
      DATA (KB(JT,22, 5),JT=1,5) /
     &4.1485E-03,4.9033E-03,5.4200E-03,5.9610E-03,6.4648E-03/
      DATA (KB(JT,23, 5),JT=1,5) /
     &3.6403E-03,4.1705E-03,4.6055E-03,5.0423E-03,5.4667E-03/
      DATA (KB(JT,24, 5),JT=1,5) /
     &3.1466E-03,3.5285E-03,3.8988E-03,4.2642E-03,4.6134E-03/
      DATA (KB(JT,25, 5),JT=1,5) /
     &2.6968E-03,2.9919E-03,3.3029E-03,3.6014E-03,3.8905E-03/
      DATA (KB(JT,26, 5),JT=1,5) /
     &2.2919E-03,2.5427E-03,2.7966E-03,3.0460E-03,3.3030E-03/
      DATA (KB(JT,27, 5),JT=1,5) /
     &1.9487E-03,2.1617E-03,2.3708E-03,2.5760E-03,2.8001E-03/
      DATA (KB(JT,28, 5),JT=1,5) /
     &1.6604E-03,1.8339E-03,2.0064E-03,2.1858E-03,2.3683E-03/
      DATA (KB(JT,29, 5),JT=1,5) /
     &1.4167E-03,1.5573E-03,1.7005E-03,1.8546E-03,2.0015E-03/
      DATA (KB(JT,30, 5),JT=1,5) /
     &1.2043E-03,1.3228E-03,1.4435E-03,1.5699E-03,1.6896E-03/
      DATA (KB(JT,31, 5),JT=1,5) /
     &1.0225E-03,1.1229E-03,1.2273E-03,1.3283E-03,1.4296E-03/
      DATA (KB(JT,32, 5),JT=1,5) /
     &8.6992E-04,9.5293E-04,1.0416E-03,1.1243E-03,1.2104E-03/
      DATA (KB(JT,33, 5),JT=1,5) /
     &7.3968E-04,8.1278E-04,8.8420E-04,9.5333E-04,1.0276E-03/
      DATA (KB(JT,34, 5),JT=1,5) /
     &6.2724E-04,6.8945E-04,7.4802E-04,8.0740E-04,8.7396E-04/
      DATA (KB(JT,35, 5),JT=1,5) /
     &5.2729E-04,5.7995E-04,6.2910E-04,6.7983E-04,7.3853E-04/
      DATA (KB(JT,36, 5),JT=1,5) /
     &4.3895E-04,4.8339E-04,5.2479E-04,5.6936E-04,6.1891E-04/
      DATA (KB(JT,37, 5),JT=1,5) /
     &3.6323E-04,4.0071E-04,4.3613E-04,4.7458E-04,5.1673E-04/
      DATA (KB(JT,38, 5),JT=1,5) /
     &3.0001E-04,3.3215E-04,3.6263E-04,3.9587E-04,4.3165E-04/
      DATA (KB(JT,39, 5),JT=1,5) /
     &2.4808E-04,2.7543E-04,3.0133E-04,3.3050E-04,3.6200E-04/
      DATA (KB(JT,40, 5),JT=1,5) /
     &2.0392E-04,2.2766E-04,2.5038E-04,2.7569E-04,3.0329E-04/
      DATA (KB(JT,41, 5),JT=1,5) /
     &1.6718E-04,1.8754E-04,2.0771E-04,2.3036E-04,2.5452E-04/
      DATA (KB(JT,42, 5),JT=1,5) /
     &1.3676E-04,1.5432E-04,1.7210E-04,1.9216E-04,2.1391E-04/
      DATA (KB(JT,43, 5),JT=1,5) /
     &1.1103E-04,1.2612E-04,1.4186E-04,1.5938E-04,1.7898E-04/
      DATA (KB(JT,44, 5),JT=1,5) /
     &8.9549E-05,1.0259E-04,1.1643E-04,1.3169E-04,1.4912E-04/
      DATA (KB(JT,45, 5),JT=1,5) /
     &7.2088E-05,8.3098E-05,9.5307E-05,1.0860E-04,1.2373E-04/
      DATA (KB(JT,46, 5),JT=1,5) /
     &5.7589E-05,6.6833E-05,7.7497E-05,8.9096E-05,1.0212E-04/
      DATA (KB(JT,47, 5),JT=1,5) /
     &4.5404E-05,5.3366E-05,6.2424E-05,7.2413E-05,8.3476E-05/
      DATA (KB(JT,48, 5),JT=1,5) /
     &3.5296E-05,4.2388E-05,4.9972E-05,5.8618E-05,6.7991E-05/
      DATA (KB(JT,49, 5),JT=1,5) /
     &2.7057E-05,3.3322E-05,3.9733E-05,4.7217E-05,5.5093E-05/
      DATA (KB(JT,50, 5),JT=1,5) /
     &2.0028E-05,2.6063E-05,3.1674E-05,3.7934E-05,4.4693E-05/
      DATA (KB(JT,51, 5),JT=1,5) /
     &1.4762E-05,2.0261E-05,2.5067E-05,3.0345E-05,3.6144E-05/
      DATA (KB(JT,52, 5),JT=1,5) /
     &1.1471E-05,1.5106E-05,1.9721E-05,2.4107E-05,2.9127E-05/
      DATA (KB(JT,53, 5),JT=1,5) /
     &8.8078E-06,1.0927E-05,1.5370E-05,1.9101E-05,2.3328E-05/
      DATA (KB(JT,54, 5),JT=1,5) /
     &6.7922E-06,8.5333E-06,1.1608E-05,1.5114E-05,1.8676E-05/
      DATA (KB(JT,55, 5),JT=1,5) /
     &5.2087E-06,6.6736E-06,8.5401E-06,1.1909E-05,1.4884E-05/
      DATA (KB(JT,56, 5),JT=1,5) /
     &3.9778E-06,5.1458E-06,6.5614E-06,9.1281E-06,1.1849E-05/
      DATA (KB(JT,57, 5),JT=1,5) /
     &3.4293E-06,3.9957E-06,5.1202E-06,6.7753E-06,9.3431E-06/
      DATA (KB(JT,58, 5),JT=1,5) /
     &3.0812E-06,3.0418E-06,3.9938E-06,5.1720E-06,7.2446E-06/
      DATA (KB(JT,59, 5),JT=1,5) /
     &2.6710E-06,2.4462E-06,3.2530E-06,4.2384E-06,5.8592E-06/
      DATA (KB(JT,13, 6),JT=1,5) /
     &4.3826E-02,5.0848E-02,5.7125E-02,6.2916E-02,6.7915E-02/
      DATA (KB(JT,14, 6),JT=1,5) /
     &3.8242E-02,4.3851E-02,4.9242E-02,5.3907E-02,5.8385E-02/
      DATA (KB(JT,15, 6),JT=1,5) /
     &3.3170E-02,3.7873E-02,4.2212E-02,4.6203E-02,5.0021E-02/
      DATA (KB(JT,16, 6),JT=1,5) /
     &2.8430E-02,3.2381E-02,3.6071E-02,3.9408E-02,4.2554E-02/
      DATA (KB(JT,17, 6),JT=1,5) /
     &2.4252E-02,2.7453E-02,3.0545E-02,3.3265E-02,3.5923E-02/
      DATA (KB(JT,18, 6),JT=1,5) /
     &2.0461E-02,2.3166E-02,2.5616E-02,2.7856E-02,3.0048E-02/
      DATA (KB(JT,19, 6),JT=1,5) /
     &1.7273E-02,1.9462E-02,2.1473E-02,2.3367E-02,2.5163E-02/
      DATA (KB(JT,20, 6),JT=1,5) /
     &1.4713E-02,1.6450E-02,1.8126E-02,1.9702E-02,2.1262E-02/
      DATA (KB(JT,21, 6),JT=1,5) /
     &1.2468E-02,1.3887E-02,1.5268E-02,1.6611E-02,1.7949E-02/
      DATA (KB(JT,22, 6),JT=1,5) /
     &1.0608E-02,1.1782E-02,1.2961E-02,1.4100E-02,1.5205E-02/
      DATA (KB(JT,23, 6),JT=1,5) /
     &8.9996E-03,9.9872E-03,1.1001E-02,1.1992E-02,1.2875E-02/
      DATA (KB(JT,24, 6),JT=1,5) /
     &7.6639E-03,8.5225E-03,9.3703E-03,1.0166E-02,1.0905E-02/
      DATA (KB(JT,25, 6),JT=1,5) /
     &6.5402E-03,7.2570E-03,7.9762E-03,8.6328E-03,9.2482E-03/
      DATA (KB(JT,26, 6),JT=1,5) /
     &5.5998E-03,6.2109E-03,6.7992E-03,7.3298E-03,7.8244E-03/
      DATA (KB(JT,27, 6),JT=1,5) /
     &4.7932E-03,5.3061E-03,5.7794E-03,6.2257E-03,6.6438E-03/
      DATA (KB(JT,28, 6),JT=1,5) /
     &4.0951E-03,4.5312E-03,4.9233E-03,5.2892E-03,5.6437E-03/
      DATA (KB(JT,29, 6),JT=1,5) /
     &3.5062E-03,3.8638E-03,4.1941E-03,4.4995E-03,4.7944E-03/
      DATA (KB(JT,30, 6),JT=1,5) /
     &2.9997E-03,3.2915E-03,3.5642E-03,3.8238E-03,4.0827E-03/
      DATA (KB(JT,31, 6),JT=1,5) /
     &2.5609E-03,2.8021E-03,3.0278E-03,3.2471E-03,3.4700E-03/
      DATA (KB(JT,32, 6),JT=1,5) /
     &2.1838E-03,2.3823E-03,2.5746E-03,2.7615E-03,2.9515E-03/
      DATA (KB(JT,33, 6),JT=1,5) /
     &1.8610E-03,2.0261E-03,2.1868E-03,2.3490E-03,2.5125E-03/
      DATA (KB(JT,34, 6),JT=1,5) /
     &1.5812E-03,1.7190E-03,1.8561E-03,1.9953E-03,2.1347E-03/
      DATA (KB(JT,35, 6),JT=1,5) /
     &1.3323E-03,1.4487E-03,1.5664E-03,1.6864E-03,1.8025E-03/
      DATA (KB(JT,36, 6),JT=1,5) /
     &1.1120E-03,1.2101E-03,1.3111E-03,1.4134E-03,1.5124E-03/
      DATA (KB(JT,37, 6),JT=1,5) /
     &9.2067E-04,1.0045E-03,1.0903E-03,1.1790E-03,1.2650E-03/
      DATA (KB(JT,38, 6),JT=1,5) /
     &7.6186E-04,8.3301E-04,9.0690E-04,9.8204E-04,1.0582E-03/
      DATA (KB(JT,39, 6),JT=1,5) /
     &6.3121E-04,6.9074E-04,7.5442E-04,8.1836E-04,8.8377E-04/
      DATA (KB(JT,40, 6),JT=1,5) /
     &5.2096E-04,5.7198E-04,6.2426E-04,6.7904E-04,7.3548E-04/
      DATA (KB(JT,41, 6),JT=1,5) /
     &4.2992E-04,4.7365E-04,5.1846E-04,5.6371E-04,6.1228E-04/
      DATA (KB(JT,42, 6),JT=1,5) /
     &3.5500E-04,3.9262E-04,4.3159E-04,4.7009E-04,5.1120E-04/
      DATA (KB(JT,43, 6),JT=1,5) /
     &2.9285E-04,3.2562E-04,3.5900E-04,3.9210E-04,4.2694E-04/
      DATA (KB(JT,44, 6),JT=1,5) /
     &2.4061E-04,2.6923E-04,2.9805E-04,3.2732E-04,3.5760E-04/
      DATA (KB(JT,45, 6),JT=1,5) /
     &1.9754E-04,2.2270E-04,2.4799E-04,2.7345E-04,3.0033E-04/
      DATA (KB(JT,46, 6),JT=1,5) /
     &1.6118E-04,1.8331E-04,2.0573E-04,2.2834E-04,2.5255E-04/
      DATA (KB(JT,47, 6),JT=1,5) /
     &1.3001E-04,1.4919E-04,1.6905E-04,1.8953E-04,2.1172E-04/
      DATA (KB(JT,48, 6),JT=1,5) /
     &1.0430E-04,1.2103E-04,1.3853E-04,1.5665E-04,1.7689E-04/
      DATA (KB(JT,49, 6),JT=1,5) /
     &8.3158E-05,9.7679E-05,1.1288E-04,1.2898E-04,1.4689E-04/
      DATA (KB(JT,50, 6),JT=1,5) /
     &6.6182E-05,7.8799E-05,9.1873E-05,1.0601E-04,1.2184E-04/
      DATA (KB(JT,51, 6),JT=1,5) /
     &5.2460E-05,6.3349E-05,7.4559E-05,8.7033E-05,1.0081E-04/
      DATA (KB(JT,52, 6),JT=1,5) /
     &4.1391E-05,5.0671E-05,6.0237E-05,7.1015E-05,8.3290E-05/
      DATA (KB(JT,53, 6),JT=1,5) /
     &3.2451E-05,4.0299E-05,4.8474E-05,5.7732E-05,6.8499E-05/
      DATA (KB(JT,54, 6),JT=1,5) /
     &2.5414E-05,3.2075E-05,3.9061E-05,4.7059E-05,5.6458E-05/
      DATA (KB(JT,55, 6),JT=1,5) /
     &1.9791E-05,2.5430E-05,3.1447E-05,3.8320E-05,4.6433E-05/
      DATA (KB(JT,56, 6),JT=1,5) /
     &1.5282E-05,2.0059E-05,2.5203E-05,3.1033E-05,3.8063E-05/
      DATA (KB(JT,57, 6),JT=1,5) /
     &1.1377E-05,1.5690E-05,2.0076E-05,2.5035E-05,3.1091E-05/
      DATA (KB(JT,58, 6),JT=1,5) /
     &8.3098E-06,1.2203E-05,1.5952E-05,2.0176E-05,2.5366E-05/
      DATA (KB(JT,59, 6),JT=1,5) /
     &6.5651E-06,9.9766E-06,1.3186E-05,1.6915E-05,2.1496E-05/
      DATA (KB(JT,13, 7),JT=1,5) /
     &1.1534E-01,1.2733E-01,1.3962E-01,1.4987E-01,1.6008E-01/
      DATA (KB(JT,14, 7),JT=1,5) /
     &9.8557E-02,1.0921E-01,1.1846E-01,1.2756E-01,1.3545E-01/
      DATA (KB(JT,15, 7),JT=1,5) /
     &8.4816E-02,9.3361E-02,1.0130E-01,1.0828E-01,1.1452E-01/
      DATA (KB(JT,16, 7),JT=1,5) /
     &7.2792E-02,7.9992E-02,8.6025E-02,9.1745E-02,9.7220E-02/
      DATA (KB(JT,17, 7),JT=1,5) /
     &6.2250E-02,6.8145E-02,7.3215E-02,7.8161E-02,8.2912E-02/
      DATA (KB(JT,18, 7),JT=1,5) /
     &5.2897E-02,5.7617E-02,6.2131E-02,6.6296E-02,7.0468E-02/
      DATA (KB(JT,19, 7),JT=1,5) /
     &4.4630E-02,4.8620E-02,5.2395E-02,5.5983E-02,5.9561E-02/
      DATA (KB(JT,20, 7),JT=1,5) /
     &3.7638E-02,4.1018E-02,4.4192E-02,4.7348E-02,5.0426E-02/
      DATA (KB(JT,21, 7),JT=1,5) /
     &3.1712E-02,3.4570E-02,3.7337E-02,4.0055E-02,4.2699E-02/
      DATA (KB(JT,22, 7),JT=1,5) /
     &2.6951E-02,2.9361E-02,3.1724E-02,3.4058E-02,3.6337E-02/
      DATA (KB(JT,23, 7),JT=1,5) /
     &2.2985E-02,2.5005E-02,2.7002E-02,2.8884E-02,3.0844E-02/
      DATA (KB(JT,24, 7),JT=1,5) /
     &1.9564E-02,2.1275E-02,2.2950E-02,2.4579E-02,2.6269E-02/
      DATA (KB(JT,25, 7),JT=1,5) /
     &1.6678E-02,1.8134E-02,1.9557E-02,2.0984E-02,2.2448E-02/
      DATA (KB(JT,26, 7),JT=1,5) /
     &1.4215E-02,1.5478E-02,1.6731E-02,1.8053E-02,1.9409E-02/
      DATA (KB(JT,27, 7),JT=1,5) /
     &1.2146E-02,1.3259E-02,1.4401E-02,1.5542E-02,1.6732E-02/
      DATA (KB(JT,28, 7),JT=1,5) /
     &1.0451E-02,1.1387E-02,1.2366E-02,1.3378E-02,1.4403E-02/
      DATA (KB(JT,29, 7),JT=1,5) /
     &8.9638E-03,9.7824E-03,1.0625E-02,1.1522E-02,1.2402E-02/
      DATA (KB(JT,30, 7),JT=1,5) /
     &7.7059E-03,8.4110E-03,9.1535E-03,9.9173E-03,1.0684E-02/
      DATA (KB(JT,31, 7),JT=1,5) /
     &6.6159E-03,7.2344E-03,7.8777E-03,8.5358E-03,9.2030E-03/
      DATA (KB(JT,32, 7),JT=1,5) /
     &5.6925E-03,6.2370E-03,6.7880E-03,7.3601E-03,7.9298E-03/
      DATA (KB(JT,33, 7),JT=1,5) /
     &4.9047E-03,5.3755E-03,5.8574E-03,6.3478E-03,6.8444E-03/
      DATA (KB(JT,34, 7),JT=1,5) /
     &4.2261E-03,4.6310E-03,5.0504E-03,5.4765E-03,5.9065E-03/
      DATA (KB(JT,35, 7),JT=1,5) /
     &3.6014E-03,3.9541E-03,4.3177E-03,4.6806E-03,5.0649E-03/
      DATA (KB(JT,36, 7),JT=1,5) /
     &3.0405E-03,3.3438E-03,3.6573E-03,3.9714E-03,4.3136E-03/
      DATA (KB(JT,37, 7),JT=1,5) /
     &2.5476E-03,2.8157E-03,3.0872E-03,3.3632E-03,3.6681E-03/
      DATA (KB(JT,38, 7),JT=1,5) /
     &2.1334E-03,2.3678E-03,2.6052E-03,2.8532E-03,3.1134E-03/
      DATA (KB(JT,39, 7),JT=1,5) /
     &1.7845E-03,1.9869E-03,2.1996E-03,2.4178E-03,2.6484E-03/
      DATA (KB(JT,40, 7),JT=1,5) /
     &1.4840E-03,1.6609E-03,1.8504E-03,2.0474E-03,2.2560E-03/
      DATA (KB(JT,41, 7),JT=1,5) /
     &1.2344E-03,1.3898E-03,1.5559E-03,1.7345E-03,1.9234E-03/
      DATA (KB(JT,42, 7),JT=1,5) /
     &1.0314E-03,1.1653E-03,1.3107E-03,1.4669E-03,1.6353E-03/
      DATA (KB(JT,43, 7),JT=1,5) /
     &8.5631E-04,9.7409E-04,1.1003E-03,1.2355E-03,1.3860E-03/
      DATA (KB(JT,44, 7),JT=1,5) /
     &7.0883E-04,8.1303E-04,9.2536E-04,1.0435E-03,1.1739E-03/
      DATA (KB(JT,45, 7),JT=1,5) /
     &5.8732E-04,6.7556E-04,7.7384E-04,8.8025E-04,9.9590E-04/
      DATA (KB(JT,46, 7),JT=1,5) /
     &4.8484E-04,5.6171E-04,6.4432E-04,7.3847E-04,8.4169E-04/
      DATA (KB(JT,47, 7),JT=1,5) /
     &3.9752E-04,4.6412E-04,5.3807E-04,6.1858E-04,7.0821E-04/
      DATA (KB(JT,48, 7),JT=1,5) /
     &3.2593E-04,3.8380E-04,4.4885E-04,5.1997E-04,5.9487E-04/
      DATA (KB(JT,49, 7),JT=1,5) /
     &2.6581E-04,3.1620E-04,3.7509E-04,4.3658E-04,5.0219E-04/
      DATA (KB(JT,50, 7),JT=1,5) /
     &2.1682E-04,2.6203E-04,3.1361E-04,3.6786E-04,4.2524E-04/
      DATA (KB(JT,51, 7),JT=1,5) /
     &1.7696E-04,2.1726E-04,2.6292E-04,3.1080E-04,3.6141E-04/
      DATA (KB(JT,52, 7),JT=1,5) /
     &1.4350E-04,1.8000E-04,2.2008E-04,2.6275E-04,3.0811E-04/
      DATA (KB(JT,53, 7),JT=1,5) /
     &1.1566E-04,1.4775E-04,1.8326E-04,2.2179E-04,2.6354E-04/
      DATA (KB(JT,54, 7),JT=1,5) /
     &9.3174E-05,1.2130E-04,1.5287E-04,1.8794E-04,2.2723E-04/
      DATA (KB(JT,55, 7),JT=1,5) /
     &7.4812E-05,9.9351E-05,1.2721E-04,1.5976E-04,1.9539E-04/
      DATA (KB(JT,56, 7),JT=1,5) /
     &5.9751E-05,8.0907E-05,1.0532E-04,1.3503E-04,1.6719E-04/
      DATA (KB(JT,57, 7),JT=1,5) /
     &4.7338E-05,6.5345E-05,8.6815E-05,1.1307E-04,1.4234E-04/
      DATA (KB(JT,58, 7),JT=1,5) /
     &3.7388E-05,5.2674E-05,7.1720E-05,9.4757E-05,1.2118E-04/
      DATA (KB(JT,59, 7),JT=1,5) /
     &3.1368E-05,4.4899E-05,6.2069E-05,8.2754E-05,1.0682E-04/
      DATA (KB(JT,13, 8),JT=1,5) /
     &3.8513E-01,4.3049E-01,4.7109E-01,5.0795E-01,5.3980E-01/
      DATA (KB(JT,14, 8),JT=1,5) /
     &3.2769E-01,3.6398E-01,3.9786E-01,4.2776E-01,4.5444E-01/
      DATA (KB(JT,15, 8),JT=1,5) /
     &2.7898E-01,3.0981E-01,3.3796E-01,3.6334E-01,3.8812E-01/
      DATA (KB(JT,16, 8),JT=1,5) /
     &2.3683E-01,2.6231E-01,2.8577E-01,3.0755E-01,3.2800E-01/
      DATA (KB(JT,17, 8),JT=1,5) /
     &2.0036E-01,2.2125E-01,2.4047E-01,2.5907E-01,2.7604E-01/
      DATA (KB(JT,18, 8),JT=1,5) /
     &1.7015E-01,1.8726E-01,2.0338E-01,2.1873E-01,2.3341E-01/
      DATA (KB(JT,19, 8),JT=1,5) /
     &1.4494E-01,1.5899E-01,1.7245E-01,1.8542E-01,1.9788E-01/
      DATA (KB(JT,20, 8),JT=1,5) /
     &1.2385E-01,1.3588E-01,1.4742E-01,1.5823E-01,1.6882E-01/
      DATA (KB(JT,21, 8),JT=1,5) /
     &1.0654E-01,1.1655E-01,1.2609E-01,1.3545E-01,1.4408E-01/
      DATA (KB(JT,22, 8),JT=1,5) /
     &9.1991E-02,1.0041E-01,1.0849E-01,1.1626E-01,1.2371E-01/
      DATA (KB(JT,23, 8),JT=1,5) /
     &7.9046E-02,8.6400E-02,9.3327E-02,9.9889E-02,1.0642E-01/
      DATA (KB(JT,24, 8),JT=1,5) /
     &6.8021E-02,7.4328E-02,8.0300E-02,8.6084E-02,9.1544E-02/
      DATA (KB(JT,25, 8),JT=1,5) /
     &5.8516E-02,6.3854E-02,6.9101E-02,7.4075E-02,7.8861E-02/
      DATA (KB(JT,26, 8),JT=1,5) /
     &5.0443E-02,5.5091E-02,5.9525E-02,6.3760E-02,6.7833E-02/
      DATA (KB(JT,27, 8),JT=1,5) /
     &4.3538E-02,4.7477E-02,5.1180E-02,5.4850E-02,5.8530E-02/
      DATA (KB(JT,28, 8),JT=1,5) /
     &3.7617E-02,4.0916E-02,4.4139E-02,4.7301E-02,5.0513E-02/
      DATA (KB(JT,29, 8),JT=1,5) /
     &3.2546E-02,3.5342E-02,3.8069E-02,4.0845E-02,4.3756E-02/
      DATA (KB(JT,30, 8),JT=1,5) /
     &2.8067E-02,3.0536E-02,3.2922E-02,3.5388E-02,3.8072E-02/
      DATA (KB(JT,31, 8),JT=1,5) /
     &2.4245E-02,2.6387E-02,2.8550E-02,3.0769E-02,3.3007E-02/
      DATA (KB(JT,32, 8),JT=1,5) /
     &2.1010E-02,2.2870E-02,2.4839E-02,2.6760E-02,2.8725E-02/
      DATA (KB(JT,33, 8),JT=1,5) /
     &1.8247E-02,1.9921E-02,2.1633E-02,2.3376E-02,2.5089E-02/
      DATA (KB(JT,34, 8),JT=1,5) /
     &1.5899E-02,1.7453E-02,1.8953E-02,2.0489E-02,2.2006E-02/
      DATA (KB(JT,35, 8),JT=1,5) /
     &1.3799E-02,1.5171E-02,1.6500E-02,1.7816E-02,1.9222E-02/
      DATA (KB(JT,36, 8),JT=1,5) /
     &1.1856E-02,1.3040E-02,1.4223E-02,1.5409E-02,1.6675E-02/
      DATA (KB(JT,37, 8),JT=1,5) /
     &1.0122E-02,1.1172E-02,1.2227E-02,1.3320E-02,1.4426E-02/
      DATA (KB(JT,38, 8),JT=1,5) /
     &8.6297E-03,9.5720E-03,1.0548E-02,1.1499E-02,1.2504E-02/
      DATA (KB(JT,39, 8),JT=1,5) /
     &7.3583E-03,8.2086E-03,9.0807E-03,9.9445E-03,1.0852E-02/
      DATA (KB(JT,40, 8),JT=1,5) /
     &6.2575E-03,7.0294E-03,7.8131E-03,8.5974E-03,9.4311E-03/
      DATA (KB(JT,41, 8),JT=1,5) /
     &5.3221E-03,6.0117E-03,6.7242E-03,7.4367E-03,8.2130E-03/
      DATA (KB(JT,42, 8),JT=1,5) /
     &4.5217E-03,5.1291E-03,5.7774E-03,6.4411E-03,7.1607E-03/
      DATA (KB(JT,43, 8),JT=1,5) /
     &3.8118E-03,4.3626E-03,4.9535E-03,5.5702E-03,6.2186E-03/
      DATA (KB(JT,44, 8),JT=1,5) /
     &3.1928E-03,3.7055E-03,4.2384E-03,4.7956E-03,5.3949E-03/
      DATA (KB(JT,45, 8),JT=1,5) /
     &2.6724E-03,3.1345E-03,3.6292E-03,4.1408E-03,4.6835E-03/
      DATA (KB(JT,46, 8),JT=1,5) /
     &2.2327E-03,2.6446E-03,3.0956E-03,3.5684E-03,4.0653E-03/
      DATA (KB(JT,47, 8),JT=1,5) /
     &1.8490E-03,2.2161E-03,2.6105E-03,3.0391E-03,3.5058E-03/
      DATA (KB(JT,48, 8),JT=1,5) /
     &1.5271E-03,1.8513E-03,2.2029E-03,2.5798E-03,3.0175E-03/
      DATA (KB(JT,49, 8),JT=1,5) /
     &1.2568E-03,1.5444E-03,1.8551E-03,2.1969E-03,2.5931E-03/
      DATA (KB(JT,50, 8),JT=1,5) /
     &1.0411E-03,1.2920E-03,1.5680E-03,1.8789E-03,2.2434E-03/
      DATA (KB(JT,51, 8),JT=1,5) /
     &8.6157E-04,1.0792E-03,1.3252E-03,1.6044E-03,1.9374E-03/
      DATA (KB(JT,52, 8),JT=1,5) /
     &7.1345E-04,8.9803E-04,1.1146E-03,1.3696E-03,1.6714E-03/
      DATA (KB(JT,53, 8),JT=1,5) /
     &5.9120E-04,7.4871E-04,9.4040E-04,1.1662E-03,1.4395E-03/
      DATA (KB(JT,54, 8),JT=1,5) /
     &4.9248E-04,6.3323E-04,7.9771E-04,9.9957E-04,1.2405E-03/
      DATA (KB(JT,55, 8),JT=1,5) /
     &4.1065E-04,5.3488E-04,6.8225E-04,8.6108E-04,1.0736E-03/
      DATA (KB(JT,56, 8),JT=1,5) /
     &3.4182E-04,4.5283E-04,5.8716E-04,7.4149E-04,9.3761E-04/
      DATA (KB(JT,57, 8),JT=1,5) /
     &2.8276E-04,3.8428E-04,5.0468E-04,6.4575E-04,8.2300E-04/
      DATA (KB(JT,58, 8),JT=1,5) /
     &2.3443E-04,3.2611E-04,4.3528E-04,5.6896E-04,7.2980E-04/
      DATA (KB(JT,59, 8),JT=1,5) /
     &2.0666E-04,2.9266E-04,3.9707E-04,5.2680E-04,6.7824E-04/
      DATA (KB(JT,13, 9),JT=1,5) /
     &2.6929E+00,3.0365E+00,3.3480E+00,3.6295E+00,3.8842E+00/
      DATA (KB(JT,14, 9),JT=1,5) /
     &2.3218E+00,2.6065E+00,2.8670E+00,3.1040E+00,3.3162E+00/
      DATA (KB(JT,15, 9),JT=1,5) /
     &1.9883E+00,2.2252E+00,2.4424E+00,2.6373E+00,2.8081E+00/
      DATA (KB(JT,16, 9),JT=1,5) /
     &1.6988E+00,1.8964E+00,2.0747E+00,2.2343E+00,2.3791E+00/
      DATA (KB(JT,17, 9),JT=1,5) /
     &1.4495E+00,1.6116E+00,1.7595E+00,1.8933E+00,2.0138E+00/
      DATA (KB(JT,18, 9),JT=1,5) /
     &1.2318E+00,1.3662E+00,1.4893E+00,1.6003E+00,1.6980E+00/
      DATA (KB(JT,19, 9),JT=1,5) /
     &1.0432E+00,1.1554E+00,1.2571E+00,1.3476E+00,1.4284E+00/
      DATA (KB(JT,20, 9),JT=1,5) /
     &8.8399E-01,9.7584E-01,1.0583E+00,1.1327E+00,1.2000E+00/
      DATA (KB(JT,21, 9),JT=1,5) /
     &7.4719E-01,8.2246E-01,8.9025E-01,9.5182E-01,1.0085E+00/
      DATA (KB(JT,22, 9),JT=1,5) /
     &6.3607E-01,6.9712E-01,7.5292E-01,8.0394E-01,8.5135E-01/
      DATA (KB(JT,23, 9),JT=1,5) /
     &5.4262E-01,5.9143E-01,6.3738E-01,6.8008E-01,7.1995E-01/
      DATA (KB(JT,24, 9),JT=1,5) /
     &4.6285E-01,5.0331E-01,5.4067E-01,5.7573E-01,6.1046E-01/
      DATA (KB(JT,25, 9),JT=1,5) /
     &3.9562E-01,4.2919E-01,4.6040E-01,4.9042E-01,5.1991E-01/
      DATA (KB(JT,26, 9),JT=1,5) /
     &3.4017E-01,3.6788E-01,3.9442E-01,4.2037E-01,4.4731E-01/
      DATA (KB(JT,27, 9),JT=1,5) /
     &2.9399E-01,3.1651E-01,3.3903E-01,3.6222E-01,3.8618E-01/
      DATA (KB(JT,28, 9),JT=1,5) /
     &2.5435E-01,2.7396E-01,2.9328E-01,3.1366E-01,3.3524E-01/
      DATA (KB(JT,29, 9),JT=1,5) /
     &2.2098E-01,2.3815E-01,2.5600E-01,2.7395E-01,2.9332E-01/
      DATA (KB(JT,30, 9),JT=1,5) /
     &1.9332E-01,2.0838E-01,2.2416E-01,2.4057E-01,2.5735E-01/
      DATA (KB(JT,31, 9),JT=1,5) /
     &1.6991E-01,1.8327E-01,1.9737E-01,2.1207E-01,2.2734E-01/
      DATA (KB(JT,32, 9),JT=1,5) /
     &1.4986E-01,1.6194E-01,1.7445E-01,1.8782E-01,2.0152E-01/
      DATA (KB(JT,33, 9),JT=1,5) /
     &1.3279E-01,1.4378E-01,1.5504E-01,1.6697E-01,1.7955E-01/
      DATA (KB(JT,34, 9),JT=1,5) /
     &1.1789E-01,1.2771E-01,1.3816E-01,1.4885E-01,1.6033E-01/
      DATA (KB(JT,35, 9),JT=1,5) /
     &1.0423E-01,1.1314E-01,1.2268E-01,1.3249E-01,1.4303E-01/
      DATA (KB(JT,36, 9),JT=1,5) /
     &9.1569E-02,9.9843E-02,1.0848E-01,1.1752E-01,1.2715E-01/
      DATA (KB(JT,37, 9),JT=1,5) /
     &7.9654E-02,8.7324E-02,9.5396E-02,1.0365E-01,1.1217E-01/
      DATA (KB(JT,38, 9),JT=1,5) /
     &6.9582E-02,7.6500E-02,8.3939E-02,9.1706E-02,9.9308E-02/
      DATA (KB(JT,39, 9),JT=1,5) /
     &6.0817E-02,6.7147E-02,7.4089E-02,8.1389E-02,8.8469E-02/
      DATA (KB(JT,40, 9),JT=1,5) /
     &5.2895E-02,5.8816E-02,6.5088E-02,7.1837E-02,7.8761E-02/
      DATA (KB(JT,41, 9),JT=1,5) /
     &4.5994E-02,5.1507E-02,5.7306E-02,6.3493E-02,7.0017E-02/
      DATA (KB(JT,42, 9),JT=1,5) /
     &3.9933E-02,4.5126E-02,5.0659E-02,5.6440E-02,6.2355E-02/
      DATA (KB(JT,43, 9),JT=1,5) /
     &3.4407E-02,3.9333E-02,4.4505E-02,5.0025E-02,5.5477E-02/
      DATA (KB(JT,44, 9),JT=1,5) /
     &2.9641E-02,3.4179E-02,3.9085E-02,4.4243E-02,4.9585E-02/
      DATA (KB(JT,45, 9),JT=1,5) /
     &2.5534E-02,2.9717E-02,3.4321E-02,3.9331E-02,4.4385E-02/
      DATA (KB(JT,46, 9),JT=1,5) /
     &2.1943E-02,2.5772E-02,3.0011E-02,3.4665E-02,3.9677E-02/
      DATA (KB(JT,47, 9),JT=1,5) /
     &1.8799E-02,2.2299E-02,2.6155E-02,3.0452E-02,3.5108E-02/
      DATA (KB(JT,48, 9),JT=1,5) /
     &1.6134E-02,1.9292E-02,2.2898E-02,2.6798E-02,3.1152E-02/
      DATA (KB(JT,49, 9),JT=1,5) /
     &1.3799E-02,1.6693E-02,1.9932E-02,2.3629E-02,2.7686E-02/
      DATA (KB(JT,50, 9),JT=1,5) /
     &1.1807E-02,1.4439E-02,1.7455E-02,2.0914E-02,2.4717E-02/
      DATA (KB(JT,51, 9),JT=1,5) /
     &1.0105E-02,1.2520E-02,1.5304E-02,1.8588E-02,2.2129E-02/
      DATA (KB(JT,52, 9),JT=1,5) /
     &8.6629E-03,1.0849E-02,1.3445E-02,1.6444E-02,1.9913E-02/
      DATA (KB(JT,53, 9),JT=1,5) /
     &7.4874E-03,9.4257E-03,1.1801E-02,1.4610E-02,1.7870E-02/
      DATA (KB(JT,54, 9),JT=1,5) /
     &6.4970E-03,8.2758E-03,1.0456E-02,1.3093E-02,1.6122E-02/
      DATA (KB(JT,55, 9),JT=1,5) /
     &5.6140E-03,7.3217E-03,9.3276E-03,1.1747E-02,1.4696E-02/
      DATA (KB(JT,56, 9),JT=1,5) /
     &4.8349E-03,6.4792E-03,8.3317E-03,1.0602E-02,1.3343E-02/
      DATA (KB(JT,57, 9),JT=1,5) /
     &4.1640E-03,5.6963E-03,7.4736E-03,9.6066E-03,1.2192E-02/
      DATA (KB(JT,58, 9),JT=1,5) /
     &3.5901E-03,5.0045E-03,6.7274E-03,8.7656E-03,1.1231E-02/
      DATA (KB(JT,59, 9),JT=1,5) /
     &3.3029E-03,4.6798E-03,6.3469E-03,8.3368E-03,1.0817E-02/
      DATA (KB(JT,13,10),JT=1,5) /
     &1.1103E+01,1.2502E+01,1.3897E+01,1.5277E+01,1.6528E+01/
      DATA (KB(JT,14,10),JT=1,5) /
     &9.9415E+00,1.1260E+01,1.2546E+01,1.3697E+01,1.4756E+01/
      DATA (KB(JT,15,10),JT=1,5) /
     &8.8808E+00,1.0035E+01,1.1086E+01,1.2088E+01,1.3034E+01/
      DATA (KB(JT,16,10),JT=1,5) /
     &7.8211E+00,8.7752E+00,9.7015E+00,1.0578E+01,1.1354E+01/
      DATA (KB(JT,17,10),JT=1,5) /
     &6.7833E+00,7.6204E+00,8.4176E+00,9.1234E+00,9.7674E+00/
      DATA (KB(JT,18,10),JT=1,5) /
     &5.8703E+00,6.5862E+00,7.2317E+00,7.8324E+00,8.4128E+00/
      DATA (KB(JT,19,10),JT=1,5) /
     &5.0772E+00,5.6603E+00,6.2160E+00,6.7517E+00,7.2522E+00/
      DATA (KB(JT,20,10),JT=1,5) /
     &4.3641E+00,4.8646E+00,5.3518E+00,5.8113E+00,6.2183E+00/
      DATA (KB(JT,21,10),JT=1,5) /
     &3.7436E+00,4.1787E+00,4.5968E+00,4.9653E+00,5.2958E+00/
      DATA (KB(JT,22,10),JT=1,5) /
     &3.2384E+00,3.6097E+00,3.9430E+00,4.2432E+00,4.5244E+00/
      DATA (KB(JT,23,10),JT=1,5) /
     &2.7953E+00,3.1049E+00,3.3758E+00,3.6302E+00,3.8688E+00/
      DATA (KB(JT,24,10),JT=1,5) /
     &2.4111E+00,2.6600E+00,2.8956E+00,3.1175E+00,3.3165E+00/
      DATA (KB(JT,25,10),JT=1,5) /
     &2.0794E+00,2.2877E+00,2.4858E+00,2.6707E+00,2.8419E+00/
      DATA (KB(JT,26,10),JT=1,5) /
     &1.7863E+00,1.9622E+00,2.1280E+00,2.2830E+00,2.4241E+00/
      DATA (KB(JT,27,10),JT=1,5) /
     &1.5261E+00,1.6805E+00,1.8222E+00,1.9507E+00,2.0763E+00/
      DATA (KB(JT,28,10),JT=1,5) /
     &1.3094E+00,1.4366E+00,1.5593E+00,1.6738E+00,1.7905E+00/
      DATA (KB(JT,29,10),JT=1,5) /
     &1.1331E+00,1.2336E+00,1.3334E+00,1.4402E+00,1.5544E+00/
      DATA (KB(JT,30,10),JT=1,5) /
     &9.7850E-01,1.0622E+00,1.1514E+00,1.2513E+00,1.3634E+00/
      DATA (KB(JT,31,10),JT=1,5) /
     &8.4902E-01,9.2389E-01,1.0050E+00,1.1001E+00,1.2086E+00/
      DATA (KB(JT,32,10),JT=1,5) /
     &7.4130E-01,8.0932E-01,8.8870E-01,9.7905E-01,1.0856E+00/
      DATA (KB(JT,33,10),JT=1,5) /
     &6.5296E-01,7.1655E-01,7.9236E-01,8.8248E-01,9.8250E-01/
      DATA (KB(JT,34,10),JT=1,5) /
     &5.7962E-01,6.3885E-01,7.0985E-01,7.9650E-01,8.9263E-01/
      DATA (KB(JT,35,10),JT=1,5) /
     &5.1372E-01,5.6904E-01,6.3621E-01,7.1633E-01,8.0771E-01/
      DATA (KB(JT,36,10),JT=1,5) /
     &4.5469E-01,5.0394E-01,5.6668E-01,6.4061E-01,7.2625E-01/
      DATA (KB(JT,37,10),JT=1,5) /
     &3.9957E-01,4.4312E-01,4.9317E-01,5.6045E-01,6.4131E-01/
      DATA (KB(JT,38,10),JT=1,5) /
     &3.5188E-01,3.9249E-01,4.3332E-01,4.9135E-01,5.6831E-01/
      DATA (KB(JT,39,10),JT=1,5) /
     &3.1275E-01,3.5014E-01,3.8817E-01,4.3541E-01,5.0377E-01/
      DATA (KB(JT,40,10),JT=1,5) /
     &2.7524E-01,3.0717E-01,3.4405E-01,3.8385E-01,4.3866E-01/
      DATA (KB(JT,41,10),JT=1,5) /
     &2.4392E-01,2.7163E-01,3.0427E-01,3.4320E-01,3.8763E-01/
      DATA (KB(JT,42,10),JT=1,5) /
     &2.1672E-01,2.4359E-01,2.7030E-01,3.0489E-01,3.4816E-01/
      DATA (KB(JT,43,10),JT=1,5) /
     &1.9366E-01,2.1755E-01,2.4331E-01,2.6943E-01,3.1064E-01/
      DATA (KB(JT,44,10),JT=1,5) /
     &1.7412E-01,1.9505E-01,2.1790E-01,2.4485E-01,2.7503E-01/
      DATA (KB(JT,45,10),JT=1,5) /
     &1.5640E-01,1.7593E-01,1.9695E-01,2.2100E-01,2.4918E-01/
      DATA (KB(JT,46,10),JT=1,5) /
     &1.3989E-01,1.5897E-01,1.7897E-01,2.0081E-01,2.2644E-01/
      DATA (KB(JT,47,10),JT=1,5) /
     &1.2271E-01,1.4204E-01,1.6295E-01,1.8322E-01,2.0661E-01/
      DATA (KB(JT,48,10),JT=1,5) /
     &1.0686E-01,1.2583E-01,1.4636E-01,1.6777E-01,1.9011E-01/
      DATA (KB(JT,49,10),JT=1,5) /
     &9.3685E-02,1.1078E-01,1.3130E-01,1.5261E-01,1.7455E-01/
      DATA (KB(JT,50,10),JT=1,5) /
     &8.2656E-02,9.8591E-02,1.1744E-01,1.3916E-01,1.6129E-01/
      DATA (KB(JT,51,10),JT=1,5) /
     &7.2693E-02,8.8183E-02,1.0575E-01,1.2537E-01,1.4856E-01/
      DATA (KB(JT,52,10),JT=1,5) /
     &6.4048E-02,7.9108E-02,9.5503E-02,1.1470E-01,1.3627E-01/
      DATA (KB(JT,53,10),JT=1,5) /
     &5.5496E-02,7.0682E-02,8.5938E-02,1.0406E-01,1.2637E-01/
      DATA (KB(JT,54,10),JT=1,5) /
     &4.9035E-02,6.2876E-02,7.7887E-02,9.5399E-02,1.1721E-01/
      DATA (KB(JT,55,10),JT=1,5) /
     &4.3446E-02,5.6855E-02,7.1213E-02,8.8342E-02,1.0826E-01/
      DATA (KB(JT,56,10),JT=1,5) /
     &3.8859E-02,5.1445E-02,6.5981E-02,8.2010E-02,1.0158E-01/
      DATA (KB(JT,57,10),JT=1,5) /
     &3.5022E-02,4.6988E-02,6.1022E-02,7.6424E-02,9.5735E-02/
      DATA (KB(JT,58,10),JT=1,5) /
     &3.1909E-02,4.3092E-02,5.6695E-02,7.2335E-02,9.0564E-02/
      DATA (KB(JT,59,10),JT=1,5) /
     &3.0556E-02,4.1959E-02,5.5206E-02,7.1568E-02,9.0259E-02/
      DATA (KB(JT,13,11),JT=1,5) /
     &1.9005E+01,2.1823E+01,2.4335E+01,2.6560E+01,2.8649E+01/
      DATA (KB(JT,14,11),JT=1,5) /
     &1.8043E+01,2.0403E+01,2.2563E+01,2.4639E+01,2.6669E+01/
      DATA (KB(JT,15,11),JT=1,5) /
     &1.6503E+01,1.8586E+01,2.0593E+01,2.2552E+01,2.4342E+01/
      DATA (KB(JT,16,11),JT=1,5) /
     &1.4859E+01,1.6766E+01,1.8612E+01,2.0317E+01,2.1884E+01/
      DATA (KB(JT,17,11),JT=1,5) /
     &1.3269E+01,1.4973E+01,1.6543E+01,1.8024E+01,1.9429E+01/
      DATA (KB(JT,18,11),JT=1,5) /
     &1.1718E+01,1.3157E+01,1.4545E+01,1.5849E+01,1.7039E+01/
      DATA (KB(JT,19,11),JT=1,5) /
     &1.0207E+01,1.1484E+01,1.2680E+01,1.3769E+01,1.4775E+01/
      DATA (KB(JT,20,11),JT=1,5) /
     &8.8979E+00,9.9836E+00,1.0976E+01,1.1897E+01,1.2806E+01/
      DATA (KB(JT,21,11),JT=1,5) /
     &7.7345E+00,8.6287E+00,9.4674E+00,1.0308E+01,1.1126E+01/
      DATA (KB(JT,22,11),JT=1,5) /
     &6.7360E+00,7.4922E+00,8.2529E+00,8.9982E+00,9.7172E+00/
      DATA (KB(JT,23,11),JT=1,5) /
     &5.8386E+00,6.5155E+00,7.1951E+00,7.8490E+00,8.4500E+00/
      DATA (KB(JT,24,11),JT=1,5) /
     &5.0807E+00,5.6843E+00,6.2699E+00,6.8121E+00,7.3100E+00/
      DATA (KB(JT,25,11),JT=1,5) /
     &4.4422E+00,4.9643E+00,5.4499E+00,5.8998E+00,6.3372E+00/
      DATA (KB(JT,26,11),JT=1,5) /
     &3.9004E+00,4.3334E+00,4.7344E+00,5.1243E+00,5.5060E+00/
      DATA (KB(JT,27,11),JT=1,5) /
     &3.4204E+00,3.7816E+00,4.1294E+00,4.4714E+00,4.7992E+00/
      DATA (KB(JT,28,11),JT=1,5) /
     &2.9981E+00,3.3076E+00,3.6130E+00,3.9107E+00,4.1979E+00/
      DATA (KB(JT,29,11),JT=1,5) /
     &2.6272E+00,2.9045E+00,3.1705E+00,3.4300E+00,3.6761E+00/
      DATA (KB(JT,30,11),JT=1,5) /
     &2.3072E+00,2.5571E+00,2.7905E+00,3.0127E+00,3.2425E+00/
      DATA (KB(JT,31,11),JT=1,5) /
     &2.0315E+00,2.2496E+00,2.4602E+00,2.6655E+00,2.8882E+00/
      DATA (KB(JT,32,11),JT=1,5) /
     &1.7947E+00,1.9859E+00,2.1751E+00,2.3754E+00,2.5995E+00/
      DATA (KB(JT,33,11),JT=1,5) /
     &1.5917E+00,1.7608E+00,1.9393E+00,2.1339E+00,2.3696E+00/
      DATA (KB(JT,34,11),JT=1,5) /
     &1.4106E+00,1.5681E+00,1.7384E+00,1.9365E+00,2.1773E+00/
      DATA (KB(JT,35,11),JT=1,5) /
     &1.2470E+00,1.3941E+00,1.5593E+00,1.7605E+00,1.9959E+00/
      DATA (KB(JT,36,11),JT=1,5) /
     &1.0975E+00,1.2350E+00,1.3953E+00,1.5917E+00,1.8213E+00/
      DATA (KB(JT,37,11),JT=1,5) /
     &9.5256E-01,1.0776E+00,1.2351E+00,1.4193E+00,1.6407E+00/
      DATA (KB(JT,38,11),JT=1,5) /
     &8.3116E-01,9.4539E-01,1.0963E+00,1.2721E+00,1.4845E+00/
      DATA (KB(JT,39,11),JT=1,5) /
     &7.2978E-01,8.3514E-01,9.7338E-01,1.1448E+00,1.3526E+00/
      DATA (KB(JT,40,11),JT=1,5) /
     &6.3508E-01,7.2958E-01,8.5453E-01,1.0153E+00,1.2157E+00/
      DATA (KB(JT,41,11),JT=1,5) /
     &5.5559E-01,6.3933E-01,7.5266E-01,8.9822E-01,1.0902E+00/
      DATA (KB(JT,42,11),JT=1,5) /
     &4.9132E-01,5.6247E-01,6.6545E-01,8.0063E-01,9.7700E-01/
      DATA (KB(JT,43,11),JT=1,5) /
     &4.3434E-01,4.9358E-01,5.8232E-01,7.0818E-01,8.6923E-01/
      DATA (KB(JT,44,11),JT=1,5) /
     &3.8638E-01,4.3517E-01,5.1097E-01,6.1891E-01,7.7146E-01/
      DATA (KB(JT,45,11),JT=1,5) /
     &3.4515E-01,3.9086E-01,4.5155E-01,5.4453E-01,6.8039E-01/
      DATA (KB(JT,46,11),JT=1,5) /
     &3.1047E-01,3.4972E-01,4.0476E-01,4.8078E-01,5.9879E-01/
      DATA (KB(JT,47,11),JT=1,5) /
     &2.8096E-01,3.1543E-01,3.6034E-01,4.2515E-01,5.2456E-01/
      DATA (KB(JT,48,11),JT=1,5) /
     &2.5443E-01,2.8861E-01,3.2488E-01,3.8074E-01,4.6176E-01/
      DATA (KB(JT,49,11),JT=1,5) /
     &2.3075E-01,2.6370E-01,2.9745E-01,3.4508E-01,4.1364E-01/
      DATA (KB(JT,50,11),JT=1,5) /
     &2.0955E-01,2.4450E-01,2.7626E-01,3.1515E-01,3.7610E-01/
      DATA (KB(JT,51,11),JT=1,5) /
     &1.9162E-01,2.2508E-01,2.5888E-01,2.9434E-01,3.4519E-01/
      DATA (KB(JT,52,11),JT=1,5) /
     &1.7326E-01,2.0725E-01,2.4087E-01,2.7521E-01,3.1976E-01/
      DATA (KB(JT,53,11),JT=1,5) /
     &1.5761E-01,1.9120E-01,2.2695E-01,2.6019E-01,2.9822E-01/
      DATA (KB(JT,54,11),JT=1,5) /
     &1.4365E-01,1.7736E-01,2.1379E-01,2.4744E-01,2.8175E-01/
      DATA (KB(JT,55,11),JT=1,5) /
     &1.3037E-01,1.6532E-01,2.0060E-01,2.3640E-01,2.6972E-01/
      DATA (KB(JT,56,11),JT=1,5) /
     &1.1768E-01,1.5347E-01,1.8925E-01,2.2636E-01,2.6180E-01/
      DATA (KB(JT,57,11),JT=1,5) /
     &1.0584E-01,1.4146E-01,1.7843E-01,2.1611E-01,2.5112E-01/
      DATA (KB(JT,58,11),JT=1,5) /
     &9.5443E-02,1.3188E-01,1.6746E-01,2.0707E-01,2.4328E-01/
      DATA (KB(JT,59,11),JT=1,5) /
     &9.0897E-02,1.2729E-01,1.6511E-01,2.0322E-01,2.4119E-01/
      DATA (KB(JT,13,12),JT=1,5) /
     &3.3504E+01,3.7950E+01,4.2337E+01,4.6726E+01,5.1022E+01/
      DATA (KB(JT,14,12),JT=1,5) /
     &3.2726E+01,3.7291E+01,4.1814E+01,4.6223E+01,5.0163E+01/
      DATA (KB(JT,15,12),JT=1,5) /
     &3.1900E+01,3.6439E+01,4.0782E+01,4.4671E+01,4.8184E+01/
      DATA (KB(JT,16,12),JT=1,5) /
     &3.0776E+01,3.4900E+01,3.8620E+01,4.2065E+01,4.5353E+01/
      DATA (KB(JT,17,12),JT=1,5) /
     &2.8746E+01,3.2300E+01,3.5697E+01,3.8925E+01,4.2020E+01/
      DATA (KB(JT,18,12),JT=1,5) /
     &2.6146E+01,2.9399E+01,3.2494E+01,3.5494E+01,3.8316E+01/
      DATA (KB(JT,19,12),JT=1,5) /
     &2.3524E+01,2.6429E+01,2.9272E+01,3.2000E+01,3.4621E+01/
      DATA (KB(JT,20,12),JT=1,5) /
     &2.1002E+01,2.3641E+01,2.6168E+01,2.8626E+01,3.0966E+01/
      DATA (KB(JT,21,12),JT=1,5) /
     &1.8638E+01,2.0929E+01,2.3211E+01,2.5404E+01,2.7506E+01/
      DATA (KB(JT,22,12),JT=1,5) /
     &1.6511E+01,1.8592E+01,2.0614E+01,2.2575E+01,2.4466E+01/
      DATA (KB(JT,23,12),JT=1,5) /
     &1.4666E+01,1.6512E+01,1.8295E+01,2.0007E+01,2.1707E+01/
      DATA (KB(JT,24,12),JT=1,5) /
     &1.3045E+01,1.4646E+01,1.6188E+01,1.7728E+01,1.9330E+01/
      DATA (KB(JT,25,12),JT=1,5) /
     &1.1583E+01,1.2959E+01,1.4347E+01,1.5799E+01,1.7308E+01/
      DATA (KB(JT,26,12),JT=1,5) /
     &1.0289E+01,1.1524E+01,1.2828E+01,1.4195E+01,1.5608E+01/
      DATA (KB(JT,27,12),JT=1,5) /
     &9.1629E+00,1.0320E+01,1.1545E+01,1.2818E+01,1.4160E+01/
      DATA (KB(JT,28,12),JT=1,5) /
     &8.1951E+00,9.2900E+00,1.0435E+01,1.1638E+01,1.2904E+01/
      DATA (KB(JT,29,12),JT=1,5) /
     &7.3862E+00,8.4074E+00,9.4905E+00,1.0629E+01,1.1848E+01/
      DATA (KB(JT,30,12),JT=1,5) /
     &6.7112E+00,7.6605E+00,8.6762E+00,9.7816E+00,1.0954E+01/
      DATA (KB(JT,31,12),JT=1,5) /
     &6.1419E+00,7.0283E+00,8.0036E+00,9.0662E+00,1.0224E+01/
      DATA (KB(JT,32,12),JT=1,5) /
     &5.6561E+00,6.5080E+00,7.4459E+00,8.4904E+00,9.6547E+00/
      DATA (KB(JT,33,12),JT=1,5) /
     &5.2496E+00,6.0774E+00,7.0019E+00,8.0523E+00,9.2390E+00/
      DATA (KB(JT,34,12),JT=1,5) /
     &4.8878E+00,5.7010E+00,6.6301E+00,7.6985E+00,8.9231E+00/
      DATA (KB(JT,35,12),JT=1,5) /
     &4.5253E+00,5.3274E+00,6.2605E+00,7.3465E+00,8.6116E+00/
      DATA (KB(JT,36,12),JT=1,5) /
     &4.1488E+00,4.9390E+00,5.8698E+00,6.9625E+00,8.2516E+00/
      DATA (KB(JT,37,12),JT=1,5) /
     &3.7312E+00,4.4908E+00,5.4013E+00,6.4804E+00,7.7554E+00/
      DATA (KB(JT,38,12),JT=1,5) /
     &3.3680E+00,4.1012E+00,4.9908E+00,6.0547E+00,7.3121E+00/
      DATA (KB(JT,39,12),JT=1,5) /
     &3.0586E+00,3.7669E+00,4.6363E+00,5.6845E+00,6.9229E+00/
      DATA (KB(JT,40,12),JT=1,5) /
     &2.7296E+00,3.4041E+00,4.2320E+00,5.2462E+00,6.4437E+00/
      DATA (KB(JT,41,12),JT=1,5) /
     &2.4362E+00,3.0740E+00,3.8624E+00,4.8348E+00,5.9904E+00/
      DATA (KB(JT,42,12),JT=1,5) /
     &2.1809E+00,2.7810E+00,3.5324E+00,4.4598E+00,5.5747E+00/
      DATA (KB(JT,43,12),JT=1,5) /
     &1.9255E+00,2.4860E+00,3.1917E+00,4.0645E+00,5.1258E+00/
      DATA (KB(JT,44,12),JT=1,5) /
     &1.6844E+00,2.2090E+00,2.8652E+00,3.6821E+00,4.6820E+00/
      DATA (KB(JT,45,12),JT=1,5) /
     &1.4745E+00,1.9569E+00,2.5696E+00,3.3333E+00,4.2717E+00/
      DATA (KB(JT,46,12),JT=1,5) /
     &1.2799E+00,1.7238E+00,2.2842E+00,2.9993E+00,3.8727E+00/
      DATA (KB(JT,47,12),JT=1,5) /
     &1.0954E+00,1.4926E+00,2.0054E+00,2.6579E+00,3.4668E+00/
      DATA (KB(JT,48,12),JT=1,5) /
     &9.3943E-01,1.2870E+00,1.7558E+00,2.3470E+00,3.0956E+00/
      DATA (KB(JT,49,12),JT=1,5) /
     &8.0789E-01,1.1100E+00,1.5297E+00,2.0665E+00,2.7506E+00/
      DATA (KB(JT,50,12),JT=1,5) /
     &7.0633E-01,9.6173E-01,1.3381E+00,1.8318E+00,2.4528E+00/
      DATA (KB(JT,51,12),JT=1,5) /
     &6.2380E-01,8.4012E-01,1.1696E+00,1.6208E+00,2.1914E+00/
      DATA (KB(JT,52,12),JT=1,5) /
     &5.6356E-01,7.3733E-01,1.0234E+00,1.4290E+00,1.9532E+00/
      DATA (KB(JT,53,12),JT=1,5) /
     &5.0909E-01,6.5068E-01,8.9219E-01,1.2539E+00,1.7345E+00/
      DATA (KB(JT,54,12),JT=1,5) /
     &4.6136E-01,5.8883E-01,7.8810E-01,1.1078E+00,1.5488E+00/
      DATA (KB(JT,55,12),JT=1,5) /
     &4.1950E-01,5.3756E-01,7.0213E-01,9.8100E-01,1.3825E+00/
      DATA (KB(JT,56,12),JT=1,5) /
     &3.8410E-01,4.8996E-01,6.3016E-01,8.6652E-01,1.2252E+00/
      DATA (KB(JT,57,12),JT=1,5) /
     &3.5624E-01,4.4831E-01,5.7215E-01,7.6572E-01,1.0848E+00/
      DATA (KB(JT,58,12),JT=1,5) /
     &3.2868E-01,4.1829E-01,5.2553E-01,6.8368E-01,9.6165E-01/
      DATA (KB(JT,59,12),JT=1,5) /
     &3.1733E-01,4.0674E-01,5.0354E-01,6.5575E-01,9.0743E-01/
      DATA (KB(JT,13,13),JT=1,5) /
     &6.3252E+01,7.1343E+01,7.9418E+01,8.6956E+01,9.3893E+01/
      DATA (KB(JT,14,13),JT=1,5) /
     &6.4432E+01,7.3277E+01,8.1636E+01,8.9410E+01,9.6695E+01/
      DATA (KB(JT,15,13),JT=1,5) /
     &6.5832E+01,7.4648E+01,8.2893E+01,9.0741E+01,9.8138E+01/
      DATA (KB(JT,16,13),JT=1,5) /
     &6.5929E+01,7.4500E+01,8.2870E+01,9.0803E+01,9.8296E+01/
      DATA (KB(JT,17,13),JT=1,5) /
     &6.5097E+01,7.3774E+01,8.2069E+01,9.0039E+01,9.7697E+01/
      DATA (KB(JT,18,13),JT=1,5) /
     &6.3876E+01,7.2341E+01,8.0612E+01,8.8540E+01,9.6103E+01/
      DATA (KB(JT,19,13),JT=1,5) /
     &6.1808E+01,7.0129E+01,7.8103E+01,8.5721E+01,9.2920E+01/
      DATA (KB(JT,20,13),JT=1,5) /
     &5.9337E+01,6.7178E+01,7.4740E+01,8.1921E+01,8.8860E+01/
      DATA (KB(JT,21,13),JT=1,5) /
     &5.6051E+01,6.3423E+01,7.0500E+01,7.7416E+01,8.4103E+01/
      DATA (KB(JT,22,13),JT=1,5) /
     &5.2578E+01,5.9410E+01,6.6220E+01,7.2967E+01,7.9639E+01/
      DATA (KB(JT,23,13),JT=1,5) /
     &4.8800E+01,5.5307E+01,6.1937E+01,6.8633E+01,7.5406E+01/
      DATA (KB(JT,24,13),JT=1,5) /
     &4.5172E+01,5.1522E+01,5.8057E+01,6.4742E+01,7.1436E+01/
      DATA (KB(JT,25,13),JT=1,5) /
     &4.2002E+01,4.8199E+01,5.4646E+01,6.1219E+01,6.7880E+01/
      DATA (KB(JT,26,13),JT=1,5) /
     &3.9325E+01,4.5395E+01,5.1713E+01,5.8235E+01,6.4961E+01/
      DATA (KB(JT,27,13),JT=1,5) /
     &3.7049E+01,4.2989E+01,4.9236E+01,5.5807E+01,6.2667E+01/
      DATA (KB(JT,28,13),JT=1,5) /
     &3.5161E+01,4.0996E+01,4.7272E+01,5.3955E+01,6.1012E+01/
      DATA (KB(JT,29,13),JT=1,5) /
     &3.3638E+01,3.9504E+01,4.5884E+01,5.2759E+01,6.0034E+01/
      DATA (KB(JT,30,13),JT=1,5) /
     &3.2492E+01,3.8479E+01,4.5047E+01,5.2111E+01,5.9617E+01/
      DATA (KB(JT,31,13),JT=1,5) /
     &3.1781E+01,3.7957E+01,4.4719E+01,5.2013E+01,5.9720E+01/
      DATA (KB(JT,32,13),JT=1,5) /
     &3.1516E+01,3.7888E+01,4.4882E+01,5.2382E+01,6.0245E+01/
      DATA (KB(JT,33,13),JT=1,5) /
     &3.1641E+01,3.8231E+01,4.5439E+01,5.3118E+01,6.1113E+01/
      DATA (KB(JT,34,13),JT=1,5) /
     &3.1881E+01,3.8668E+01,4.6052E+01,5.3873E+01,6.1967E+01/
      DATA (KB(JT,35,13),JT=1,5) /
     &3.1765E+01,3.8677E+01,4.6167E+01,5.4068E+01,6.2237E+01/
      DATA (KB(JT,36,13),JT=1,5) /
     &3.1127E+01,3.8083E+01,4.5619E+01,5.3554E+01,6.1754E+01/
      DATA (KB(JT,37,13),JT=1,5) /
     &2.9631E+01,3.6533E+01,4.4019E+01,5.1934E+01,6.0138E+01/
      DATA (KB(JT,38,13),JT=1,5) /
     &2.8216E+01,3.5039E+01,4.2468E+01,5.0350E+01,5.8547E+01/
      DATA (KB(JT,39,13),JT=1,5) /
     &2.6913E+01,3.3654E+01,4.1024E+01,4.8851E+01,5.7030E+01/
      DATA (KB(JT,40,13),JT=1,5) /
     &2.5061E+01,3.1637E+01,3.8879E+01,4.6620E+01,5.4739E+01/
      DATA (KB(JT,41,13),JT=1,5) /
     &2.3239E+01,2.9632E+01,3.6721E+01,4.4349E+01,5.2395E+01/
      DATA (KB(JT,42,13),JT=1,5) /
     &2.1518E+01,2.7714E+01,3.4638E+01,4.2154E+01,5.0111E+01/
      DATA (KB(JT,43,13),JT=1,5) /
     &1.9578E+01,2.5525E+01,3.2232E+01,3.9588E+01,4.7417E+01/
      DATA (KB(JT,44,13),JT=1,5) /
     &1.7631E+01,2.3285E+01,2.9750E+01,3.6914E+01,4.4596E+01/
      DATA (KB(JT,45,13),JT=1,5) /
     &1.5817E+01,2.1168E+01,2.7372E+01,3.4312E+01,4.1842E+01/
      DATA (KB(JT,46,13),JT=1,5) /
     &1.4031E+01,1.9049E+01,2.4960E+01,3.1648E+01,3.8993E+01/
      DATA (KB(JT,47,13),JT=1,5) /
     &1.2204E+01,1.6850E+01,2.2409E+01,2.8797E+01,3.5899E+01/
      DATA (KB(JT,48,13),JT=1,5) /
     &1.0543E+01,1.4813E+01,2.0005E+01,2.6074E+01,3.2906E+01/
      DATA (KB(JT,49,13),JT=1,5) /
     &9.0410E+00,1.2940E+01,1.7763E+01,2.3491E+01,3.0027E+01/
      DATA (KB(JT,50,13),JT=1,5) /
     &7.7723E+00,1.1328E+01,1.5799E+01,2.1188E+01,2.7436E+01/
      DATA (KB(JT,51,13),JT=1,5) /
     &6.6603E+00,9.8956E+00,1.4031E+01,1.9082E+01,2.5030E+01/
      DATA (KB(JT,52,13),JT=1,5) /
     &5.6483E+00,8.5936E+00,1.2389E+01,1.7108E+01,2.2735E+01/
      DATA (KB(JT,53,13),JT=1,5) /
     &4.7548E+00,7.4145E+00,1.0879E+01,1.5253E+01,2.0556E+01/
      DATA (KB(JT,54,13),JT=1,5) /
     &4.0362E+00,6.4182E+00,9.6047E+00,1.3672E+01,1.8664E+01/
      DATA (KB(JT,55,13),JT=1,5) /
     &3.4328E+00,5.5491E+00,8.4816E+00,1.2254E+01,1.6947E+01/
      DATA (KB(JT,56,13),JT=1,5) /
     &2.9068E+00,4.7740E+00,7.4485E+00,1.0936E+01,1.5335E+01/
      DATA (KB(JT,57,13),JT=1,5) /
     &2.4469E+00,4.0838E+00,6.4921E+00,9.7157E+00,1.3818E+01/
      DATA (KB(JT,58,13),JT=1,5) /
     &2.0735E+00,3.4925E+00,5.6637E+00,8.6413E+00,1.2467E+01/
      DATA (KB(JT,59,13),JT=1,5) /
     &1.9355E+00,3.2709E+00,5.3499E+00,8.2221E+00,1.1950E+01/
      DATA (KB(JT,13,14),JT=1,5) /
     &1.3763E+02,1.5352E+02,1.6709E+02,1.7925E+02,1.9013E+02/
      DATA (KB(JT,14,14),JT=1,5) /
     &1.4836E+02,1.6388E+02,1.7793E+02,1.9078E+02,2.0291E+02/
      DATA (KB(JT,15,14),JT=1,5) /
     &1.5609E+02,1.7227E+02,1.8754E+02,2.0210E+02,2.1605E+02/
      DATA (KB(JT,16,14),JT=1,5) /
     &1.6287E+02,1.8058E+02,1.9742E+02,2.1358E+02,2.2879E+02/
      DATA (KB(JT,17,14),JT=1,5) /
     &1.6936E+02,1.8829E+02,2.0654E+02,2.2380E+02,2.3943E+02/
      DATA (KB(JT,18,14),JT=1,5) /
     &1.7409E+02,1.9426E+02,2.1359E+02,2.3157E+02,2.4840E+02/
      DATA (KB(JT,19,14),JT=1,5) /
     &1.7751E+02,1.9877E+02,2.1900E+02,2.3829E+02,2.5666E+02/
      DATA (KB(JT,20,14),JT=1,5) /
     &1.8029E+02,2.0255E+02,2.2414E+02,2.4492E+02,2.6421E+02/
      DATA (KB(JT,21,14),JT=1,5) /
     &1.8288E+02,2.0645E+02,2.2930E+02,2.5080E+02,2.7109E+02/
      DATA (KB(JT,22,14),JT=1,5) /
     &1.8758E+02,2.1208E+02,2.3543E+02,2.5750E+02,2.7832E+02/
      DATA (KB(JT,23,14),JT=1,5) /
     &1.9239E+02,2.1719E+02,2.4091E+02,2.6350E+02,2.8469E+02/
      DATA (KB(JT,24,14),JT=1,5) /
     &1.9651E+02,2.2173E+02,2.4591E+02,2.6890E+02,2.9066E+02/
      DATA (KB(JT,25,14),JT=1,5) /
     &2.0022E+02,2.2597E+02,2.5071E+02,2.7426E+02,2.9648E+02/
      DATA (KB(JT,26,14),JT=1,5) /
     &2.0417E+02,2.3049E+02,2.5589E+02,2.7996E+02,3.0257E+02/
      DATA (KB(JT,27,14),JT=1,5) /
     &2.0832E+02,2.3518E+02,2.6110E+02,2.8565E+02,3.0854E+02/
      DATA (KB(JT,28,14),JT=1,5) /
     &2.1279E+02,2.4021E+02,2.6653E+02,2.9138E+02,3.1446E+02/
      DATA (KB(JT,29,14),JT=1,5) /
     &2.1796E+02,2.4575E+02,2.7237E+02,2.9736E+02,3.2050E+02/
      DATA (KB(JT,30,14),JT=1,5) /
     &2.2364E+02,2.5171E+02,2.7842E+02,3.0343E+02,3.2655E+02/
      DATA (KB(JT,31,14),JT=1,5) /
     &2.2986E+02,2.5803E+02,2.8476E+02,3.0967E+02,3.3263E+02/
      DATA (KB(JT,32,14),JT=1,5) /
     &2.3644E+02,2.6463E+02,2.9123E+02,3.1599E+02,3.3870E+02/
      DATA (KB(JT,33,14),JT=1,5) /
     &2.4330E+02,2.7142E+02,2.9784E+02,3.2234E+02,3.4468E+02/
      DATA (KB(JT,34,14),JT=1,5) /
     &2.4932E+02,2.7733E+02,3.0352E+02,3.2779E+02,3.4977E+02/
      DATA (KB(JT,35,14),JT=1,5) /
     &2.5266E+02,2.8063E+02,3.0678E+02,3.3096E+02,3.5278E+02/
      DATA (KB(JT,36,14),JT=1,5) /
     &2.5297E+02,2.8101E+02,3.0732E+02,3.3158E+02,3.5352E+02/
      DATA (KB(JT,37,14),JT=1,5) /
     &2.4886E+02,2.7734E+02,3.0396E+02,3.2863E+02,3.5100E+02/
      DATA (KB(JT,38,14),JT=1,5) /
     &2.4449E+02,2.7331E+02,3.0032E+02,3.2535E+02,3.4818E+02/
      DATA (KB(JT,39,14),JT=1,5) /
     &2.4014E+02,2.6925E+02,2.9663E+02,3.2206E+02,3.4524E+02/
      DATA (KB(JT,40,14),JT=1,5) /
     &2.3269E+02,2.6223E+02,2.9013E+02,3.1615E+02,3.3997E+02/
      DATA (KB(JT,41,14),JT=1,5) /
     &2.2477E+02,2.5475E+02,2.8316E+02,3.0972E+02,3.3417E+02/
      DATA (KB(JT,42,14),JT=1,5) /
     &2.1674E+02,2.4709E+02,2.7597E+02,3.0309E+02,3.2816E+02/
      DATA (KB(JT,43,14),JT=1,5) /
     &2.0690E+02,2.3764E+02,2.6708E+02,2.9483E+02,3.2058E+02/
      DATA (KB(JT,44,14),JT=1,5) /
     &1.9620E+02,2.2728E+02,2.5727E+02,2.8565E+02,3.1213E+02/
      DATA (KB(JT,45,14),JT=1,5) /
     &1.8544E+02,2.1679E+02,2.4722E+02,2.7624E+02,3.0339E+02/
      DATA (KB(JT,46,14),JT=1,5) /
     &1.7394E+02,2.0555E+02,2.3639E+02,2.6594E+02,2.9386E+02/
      DATA (KB(JT,47,14),JT=1,5) /
     &1.6112E+02,1.9279E+02,2.2405E+02,2.5421E+02,2.8283E+02/
      DATA (KB(JT,48,14),JT=1,5) /
     &1.4837E+02,1.8000E+02,2.1155E+02,2.4220E+02,2.7155E+02/
      DATA (KB(JT,49,14),JT=1,5) /
     &1.3570E+02,1.6720E+02,1.9889E+02,2.3000E+02,2.5992E+02/
      DATA (KB(JT,50,14),JT=1,5) /
     &1.2401E+02,1.5522E+02,1.8690E+02,2.1834E+02,2.4877E+02/
      DATA (KB(JT,51,14),JT=1,5) /
     &1.1285E+02,1.4368E+02,1.7528E+02,2.0692E+02,2.3777E+02/
      DATA (KB(JT,52,14),JT=1,5) /
     &1.0205E+02,1.3225E+02,1.6371E+02,1.9541E+02,2.2663E+02/
      DATA (KB(JT,53,14),JT=1,5) /
     &9.1561E+01,1.2094E+02,1.5208E+02,1.8381E+02,2.1529E+02/
      DATA (KB(JT,54,14),JT=1,5) /
     &8.2288E+01,1.1082E+02,1.4154E+02,1.7313E+02,2.0480E+02/
      DATA (KB(JT,55,14),JT=1,5) /
     &7.3729E+01,1.0135E+02,1.3152E+02,1.6297E+02,1.9471E+02/
      DATA (KB(JT,56,14),JT=1,5) /
     &6.5504E+01,9.2170E+01,1.2164E+02,1.5283E+02,1.8453E+02/
      DATA (KB(JT,57,14),JT=1,5) /
     &5.7661E+01,8.3295E+01,1.1195E+02,1.4273E+02,1.7435E+02/
      DATA (KB(JT,58,14),JT=1,5) /
     &5.0636E+01,7.5168E+01,1.0296E+02,1.3321E+02,1.6472E+02/
      DATA (KB(JT,59,14),JT=1,5) /
     &4.7932E+01,7.1971E+01,9.9421E+01,1.2944E+02,1.6088E+02/
      DATA (KB(JT,13,15),JT=1,5) /
     &2.4469E+02,2.6735E+02,2.9101E+02,3.1438E+02,3.3674E+02/
      DATA (KB(JT,14,15),JT=1,5) /
     &2.8094E+02,3.0921E+02,3.3701E+02,3.6348E+02,3.8824E+02/
      DATA (KB(JT,15,15),JT=1,5) /
     &3.2313E+02,3.5640E+02,3.8804E+02,4.1754E+02,4.4448E+02/
      DATA (KB(JT,16,15),JT=1,5) /
     &3.6992E+02,4.0761E+02,4.4269E+02,4.7470E+02,5.0364E+02/
      DATA (KB(JT,17,15),JT=1,5) /
     &4.1926E+02,4.6079E+02,4.9879E+02,5.3327E+02,5.6513E+02/
      DATA (KB(JT,18,15),JT=1,5) /
     &4.7156E+02,5.1653E+02,5.5718E+02,5.9454E+02,6.2828E+02/
      DATA (KB(JT,19,15),JT=1,5) /
     &5.2525E+02,5.7308E+02,6.1700E+02,6.5663E+02,6.9127E+02/
      DATA (KB(JT,20,15),JT=1,5) /
     &5.7876E+02,6.2973E+02,6.7595E+02,7.1709E+02,7.5345E+02/
      DATA (KB(JT,21,15),JT=1,5) /
     &6.2988E+02,6.8342E+02,7.3148E+02,7.7494E+02,8.1239E+02/
      DATA (KB(JT,22,15),JT=1,5) /
     &6.8118E+02,7.3681E+02,7.8702E+02,8.3157E+02,8.6949E+02/
      DATA (KB(JT,23,15),JT=1,5) /
     &7.2944E+02,7.8796E+02,8.3973E+02,8.8478E+02,9.2278E+02/
      DATA (KB(JT,24,15),JT=1,5) /
     &7.7652E+02,8.3661E+02,8.8931E+02,9.3457E+02,9.7211E+02/
      DATA (KB(JT,25,15),JT=1,5) /
     &8.2208E+02,8.8322E+02,9.3559E+02,9.8038E+02,1.0170E+03/
      DATA (KB(JT,26,15),JT=1,5) /
     &8.6654E+02,9.2755E+02,9.7898E+02,1.0223E+03,1.0574E+03/
      DATA (KB(JT,27,15),JT=1,5) /
     &9.0828E+02,9.6846E+02,1.0184E+03,1.0599E+03,1.0932E+03/
      DATA (KB(JT,28,15),JT=1,5) /
     &9.4716E+02,1.0058E+03,1.0539E+03,1.0933E+03,1.1247E+03/
      DATA (KB(JT,29,15),JT=1,5) /
     &9.8313E+02,1.0399E+03,1.0858E+03,1.1230E+03,1.1519E+03/
      DATA (KB(JT,30,15),JT=1,5) /
     &1.0160E+03,1.0704E+03,1.1141E+03,1.1489E+03,1.1756E+03/
      DATA (KB(JT,31,15),JT=1,5) /
     &1.0460E+03,1.0956E+03,1.1391E+03,1.1716E+03,1.1960E+03/
      DATA (KB(JT,32,15),JT=1,5) /
     &1.0732E+03,1.1224E+03,1.1612E+03,1.1912E+03,1.2136E+03/
      DATA (KB(JT,33,15),JT=1,5) /
     &1.0978E+03,1.1441E+03,1.1805E+03,1.2081E+03,1.2287E+03/
      DATA (KB(JT,34,15),JT=1,5) /
     &1.1183E+03,1.1622E+03,1.1963E+03,1.2219E+03,1.2409E+03/
      DATA (KB(JT,35,15),JT=1,5) /
     &1.1319E+03,1.1747E+03,1.2074E+03,1.2320E+03,1.2497E+03/
      DATA (KB(JT,36,15),JT=1,5) /
     &1.1393E+03,1.1815E+03,1.2141E+03,1.2383E+03,1.2557E+03/
      DATA (KB(JT,37,15),JT=1,5) /
     &1.1379E+03,1.1816E+03,1.2154E+03,1.2404E+03,1.2585E+03/
      DATA (KB(JT,38,15),JT=1,5) /
     &1.1350E+03,1.1805E+03,1.2153E+03,1.2413E+03,1.2601E+03/
      DATA (KB(JT,39,15),JT=1,5) /
     &1.1312E+03,1.1782E+03,1.2145E+03,1.2415E+03,1.2613E+03/
      DATA (KB(JT,40,15),JT=1,5) /
     &1.1209E+03,1.1709E+03,1.2094E+03,1.2385E+03,1.2597E+03/
      DATA (KB(JT,41,15),JT=1,5) /
     &1.1085E+03,1.1615E+03,1.2028E+03,1.2343E+03,1.2572E+03/
      DATA (KB(JT,42,15),JT=1,5) /
     &1.0950E+03,1.1510E+03,1.1953E+03,1.2290E+03,1.2540E+03/
      DATA (KB(JT,43,15),JT=1,5) /
     &1.0762E+03,1.1364E+03,1.1842E+03,1.2211E+03,1.2485E+03/
      DATA (KB(JT,44,15),JT=1,5) /
     &1.0545E+03,1.1188E+03,1.1706E+03,1.2111E+03,1.2414E+03/
      DATA (KB(JT,45,15),JT=1,5) /
     &1.0306E+03,1.0995E+03,1.1556E+03,1.1997E+03,1.2332E+03/
      DATA (KB(JT,46,15),JT=1,5) /
     &1.0035E+03,1.0771E+03,1.1376E+03,1.1860E+03,1.2231E+03/
      DATA (KB(JT,47,15),JT=1,5) /
     &9.7068E+02,1.0499E+03,1.1155E+03,1.1686E+03,1.2101E+03/
      DATA (KB(JT,48,15),JT=1,5) /
     &9.3560E+02,1.0200E+03,1.0913E+03,1.1493E+03,1.1954E+03/
      DATA (KB(JT,49,15),JT=1,5) /
     &8.9859E+02,9.8816E+02,1.0648E+03,1.1280E+03,1.1788E+03/
      DATA (KB(JT,50,15),JT=1,5) /
     &8.6187E+02,9.5626E+02,1.0379E+03,1.1061E+03,1.1615E+03/
      DATA (KB(JT,51,15),JT=1,5) /
     &8.2436E+02,9.2347E+02,1.0097E+03,1.0831E+03,1.1429E+03/
      DATA (KB(JT,52,15),JT=1,5) /
     &7.8552E+02,8.8919E+02,9.8012E+02,1.0582E+03,1.1227E+03/
      DATA (KB(JT,53,15),JT=1,5) /
     &7.4472E+02,8.5281E+02,9.4852E+02,1.0314E+03,1.1008E+03/
      DATA (KB(JT,54,15),JT=1,5) /
     &7.0603E+02,8.1807E+02,9.1796E+02,1.0053E+03,1.0792E+03/
      DATA (KB(JT,55,15),JT=1,5) /
     &6.6818E+02,7.8362E+02,8.8753E+02,9.7880E+02,1.0572E+03/
      DATA (KB(JT,56,15),JT=1,5) /
     &6.2949E+02,7.4771E+02,8.5573E+02,9.5104E+02,1.0336E+03/
      DATA (KB(JT,57,15),JT=1,5) /
     &5.9013E+02,7.1102E+02,8.2256E+02,9.2198E+02,1.0088E+03/
      DATA (KB(JT,58,15),JT=1,5) /
     &5.5222E+02,6.7509E+02,7.8994E+02,8.9322E+02,9.8385E+02/
      DATA (KB(JT,59,15),JT=1,5) /
     &5.3696E+02,6.6055E+02,7.7661E+02,8.8142E+02,9.7364E+02/
      DATA (KB(JT,13,16),JT=1,5) /
     &4.2045E+02,4.6429E+02,5.0303E+02,5.3671E+02,5.6546E+02/
      DATA (KB(JT,14,16),JT=1,5) /
     &5.0808E+02,5.5889E+02,6.0315E+02,6.4104E+02,6.7319E+02/
      DATA (KB(JT,15,16),JT=1,5) /
     &6.0971E+02,6.6729E+02,7.1666E+02,7.5857E+02,7.9337E+02/
      DATA (KB(JT,16,16),JT=1,5) /
     &7.2443E+02,7.8825E+02,8.4219E+02,8.8727E+02,9.2382E+02/
      DATA (KB(JT,17,16),JT=1,5) /
     &8.5000E+02,9.1908E+02,9.7683E+02,1.0239E+03,1.0613E+03/
      DATA (KB(JT,18,16),JT=1,5) /
     &9.8305E+02,1.0566E+03,1.1167E+03,1.1645E+03,1.2017E+03/
      DATA (KB(JT,19,16),JT=1,5) /
     &1.1204E+03,1.1968E+03,1.2579E+03,1.3058E+03,1.3449E+03/
      DATA (KB(JT,20,16),JT=1,5) /
     &1.2624E+03,1.3419E+03,1.4045E+03,1.4519E+03,1.4914E+03/
      DATA (KB(JT,21,16),JT=1,5) /
     &1.4128E+03,1.4938E+03,1.5557E+03,1.6009E+03,1.6375E+03/
      DATA (KB(JT,22,16),JT=1,5) /
     &1.5738E+03,1.6513E+03,1.7095E+03,1.7503E+03,1.7825E+03/
      DATA (KB(JT,23,16),JT=1,5) /
     &1.7348E+03,1.8057E+03,1.8583E+03,1.8939E+03,1.9201E+03/
      DATA (KB(JT,24,16),JT=1,5) /
     &1.8918E+03,1.9538E+03,1.9990E+03,2.0285E+03,2.0481E+03/
      DATA (KB(JT,25,16),JT=1,5) /
     &2.0394E+03,2.0915E+03,2.1288E+03,2.1514E+03,2.1633E+03/
      DATA (KB(JT,26,16),JT=1,5) /
     &2.1757E+03,2.2166E+03,2.2458E+03,2.2605E+03,2.2652E+03/
      DATA (KB(JT,27,16),JT=1,5) /
     &2.2965E+03,2.3277E+03,2.3485E+03,2.3546E+03,2.3529E+03/
      DATA (KB(JT,28,16),JT=1,5) /
     &2.4019E+03,2.4242E+03,2.4364E+03,2.4355E+03,2.4262E+03/
      DATA (KB(JT,29,16),JT=1,5) /
     &2.4918E+03,2.5053E+03,2.5101E+03,2.5025E+03,2.4871E+03/
      DATA (KB(JT,30,16),JT=1,5) /
     &2.5673E+03,2.5738E+03,2.5706E+03,2.5574E+03,2.5361E+03/
      DATA (KB(JT,31,16),JT=1,5) /
     &2.6301E+03,2.6241E+03,2.6201E+03,2.6003E+03,2.5741E+03/
      DATA (KB(JT,32,16),JT=1,5) /
     &2.6807E+03,2.6744E+03,2.6583E+03,2.6342E+03,2.6035E+03/
      DATA (KB(JT,33,16),JT=1,5) /
     &2.7216E+03,2.7096E+03,2.6883E+03,2.6595E+03,2.6244E+03/
      DATA (KB(JT,34,16),JT=1,5) /
     &2.7530E+03,2.7368E+03,2.7115E+03,2.6793E+03,2.6415E+03/
      DATA (KB(JT,35,16),JT=1,5) /
     &2.7800E+03,2.7599E+03,2.7318E+03,2.6972E+03,2.6568E+03/
      DATA (KB(JT,36,16),JT=1,5) /
     &2.8032E+03,2.7809E+03,2.7511E+03,2.7149E+03,2.6728E+03/
      DATA (KB(JT,37,16),JT=1,5) /
     &2.8255E+03,2.8022E+03,2.7720E+03,2.7352E+03,2.6929E+03/
      DATA (KB(JT,38,16),JT=1,5) /
     &2.8447E+03,2.8207E+03,2.7907E+03,2.7534E+03,2.7108E+03/
      DATA (KB(JT,39,16),JT=1,5) /
     &2.8614E+03,2.8371E+03,2.8072E+03,2.7697E+03,2.7272E+03/
      DATA (KB(JT,40,16),JT=1,5) /
     &2.8775E+03,2.8542E+03,2.8246E+03,2.7882E+03,2.7463E+03/
      DATA (KB(JT,41,16),JT=1,5) /
     &2.8919E+03,2.8698E+03,2.8410E+03,2.8060E+03,2.7644E+03/
      DATA (KB(JT,42,16),JT=1,5) /
     &2.9035E+03,2.8842E+03,2.8555E+03,2.8221E+03,2.7810E+03/
      DATA (KB(JT,43,16),JT=1,5) /
     &2.9142E+03,2.8974E+03,2.8713E+03,2.8381E+03,2.7994E+03/
      DATA (KB(JT,44,16),JT=1,5) /
     &2.9225E+03,2.9100E+03,2.8852E+03,2.8542E+03,2.8174E+03/
      DATA (KB(JT,45,16),JT=1,5) /
     &2.9284E+03,2.9199E+03,2.8988E+03,2.8699E+03,2.8343E+03/
      DATA (KB(JT,46,16),JT=1,5) /
     &2.9312E+03,2.9287E+03,2.9114E+03,2.8839E+03,2.8514E+03/
      DATA (KB(JT,47,16),JT=1,5) /
     &2.9278E+03,2.9353E+03,2.9229E+03,2.8988E+03,2.8673E+03/
      DATA (KB(JT,48,16),JT=1,5) /
     &2.9198E+03,2.9382E+03,2.9322E+03,2.9123E+03,2.8825E+03/
      DATA (KB(JT,49,16),JT=1,5) /
     &2.9055E+03,2.9369E+03,2.9391E+03,2.9238E+03,2.8967E+03/
      DATA (KB(JT,50,16),JT=1,5) /
     &2.8866E+03,2.9312E+03,2.9427E+03,2.9328E+03,2.9100E+03/
      DATA (KB(JT,51,16),JT=1,5) /
     &2.8621E+03,2.9209E+03,2.9426E+03,2.9399E+03,2.9204E+03/
      DATA (KB(JT,52,16),JT=1,5) /
     &2.8313E+03,2.9062E+03,2.9403E+03,2.9447E+03,2.9298E+03/
      DATA (KB(JT,53,16),JT=1,5) /
     &2.7937E+03,2.8849E+03,2.9330E+03,2.9466E+03,2.9378E+03/
      DATA (KB(JT,54,16),JT=1,5) /
     &2.7518E+03,2.8608E+03,2.9213E+03,2.9463E+03,2.9434E+03/
      DATA (KB(JT,55,16),JT=1,5) /
     &2.7066E+03,2.8327E+03,2.9070E+03,2.9427E+03,2.9473E+03/
      DATA (KB(JT,56,16),JT=1,5) /
     &2.6539E+03,2.7985E+03,2.8885E+03,2.9351E+03,2.9485E+03/
      DATA (KB(JT,57,16),JT=1,5) /
     &2.5953E+03,2.7598E+03,2.8651E+03,2.9247E+03,2.9481E+03/
      DATA (KB(JT,58,16),JT=1,5) /
     &2.5319E+03,2.7165E+03,2.8391E+03,2.9117E+03,2.9450E+03/
      DATA (KB(JT,59,16),JT=1,5) /
     &2.5058E+03,2.6981E+03,2.8277E+03,2.9062E+03,2.9427E+03/

C     The array FORREF contains the coefficient of the water vapor
C     foreign-continuum (including the energy term).  The first 
C     index refers to reference temperature (296,260,224,260) and 
C     pressure (970,475,219,3 mbar) levels.  The second index 
C     runs over the g-channel (1 to 16).

      DATA (FORREF(1,IG),IG=1,16) /
     &1.0515e-02,1.4860e-02,1.7181e-02,1.6642e-02,1.6644e-02,1.5649e-02,
     &1.7734e-02,1.7521e-02,1.7868e-02,1.8400e-02,1.9361e-02,2.1487e-02,
     &2.0192e-02,1.6545e-02,2.0922e-02,2.0922e-02/
      DATA (FORREF(2,IG),IG=1,16) /
     &1.0423e-02,1.4593e-02,1.6329e-02,1.7071e-02,1.7252e-02,1.6188e-02,
     &1.7752e-02,1.7913e-02,1.7551e-02,1.8203e-02,1.7946e-02,1.9828e-02,
     &2.1566e-02,1.9707e-02,2.0944e-02,2.0944e-02/
      DATA (FORREF(3,IG),IG=1,16) /
     &9.2770e-03,1.2818e-02,1.7181e-02,1.7858e-02,1.7888e-02,1.7121e-02,
     &1.8116e-02,1.8230e-02,1.7719e-02,1.7833e-02,1.8438e-02,1.7995e-02,
     &2.0895e-02,2.1525e-02,2.0517e-02,2.0954e-02/
      DATA (FORREF(4,IG),IG=1,16) /
     &8.3290e-03,1.3483e-02,1.5432e-02,2.0793e-02,1.8404e-02,1.7470e-02,
     &1.7253e-02,1.7132e-02,1.7119e-02,1.7376e-02,1.7030e-02,1.6847e-02,
     &1.5562e-02,1.6836e-02,1.8746e-02,2.1233e-02/

C     The array SELFREF contains the coefficient of the water vapor
C     self-continuum (including the energy term).  The first index
C     refers to temperature in 7.2 degree increments.  For instance,
C     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
C     etc.  The second index runs over the g-channel (1 to 16).

      DATA (SELFREF(JT, 1),JT=1,10)  /
     & 2.41120e-01, 2.27071e-01, 2.13840e-01, 2.01380e-01, 1.89646e-01,
     & 1.78596e-01, 1.68190e-01, 1.58390e-01, 1.49161e-01, 1.40470e-01/
      DATA (SELFREF(JT, 2),JT=1,10)  /
     & 3.11156e-01, 2.92249e-01, 2.74490e-01, 2.57810e-01, 2.42144e-01,
     & 2.27430e-01, 2.13610e-01, 2.00630e-01, 1.88439e-01, 1.76988e-01/
      DATA (SELFREF(JT, 3),JT=1,10)  /
     & 3.37148e-01, 3.17767e-01, 2.99500e-01, 2.82283e-01, 2.66056e-01,
     & 2.50762e-01, 2.36347e-01, 2.22760e-01, 2.09955e-01, 1.97885e-01/
      DATA (SELFREF(JT, 4),JT=1,10)  /
     & 3.57139e-01, 3.32763e-01, 3.10050e-01, 2.88888e-01, 2.69170e-01,
     & 2.50798e-01, 2.33680e-01, 2.17730e-01, 2.02869e-01, 1.89022e-01/
      DATA (SELFREF(JT, 5),JT=1,10)  /
     & 3.60626e-01, 3.35433e-01, 3.12000e-01, 2.90204e-01, 2.69931e-01,
     & 2.51074e-01, 2.33534e-01, 2.17220e-01, 2.02045e-01, 1.87931e-01/
      DATA (SELFREF(JT, 6),JT=1,10)  /
     & 3.42420e-01, 3.18795e-01, 2.96800e-01, 2.76323e-01, 2.57258e-01,
     & 2.39509e-01, 2.22985e-01, 2.07600e-01, 1.93277e-01, 1.79942e-01/
      DATA (SELFREF(JT, 7),JT=1,10)  /
     & 3.65491e-01, 3.41599e-01, 3.19270e-01, 2.98400e-01, 2.78895e-01,
     & 2.60664e-01, 2.43625e-01, 2.27700e-01, 2.12816e-01, 1.98905e-01/
      DATA (SELFREF(JT, 8),JT=1,10)  /
     & 3.70354e-01, 3.45005e-01, 3.21390e-01, 2.99392e-01, 2.78899e-01,
     & 2.59809e-01, 2.42026e-01, 2.25460e-01, 2.10028e-01, 1.95652e-01/
      DATA (SELFREF(JT, 9),JT=1,10)  /
     & 3.60483e-01, 3.37846e-01, 3.16630e-01, 2.96747e-01, 2.78112e-01,
     & 2.60648e-01, 2.44280e-01, 2.28940e-01, 2.14563e-01, 2.01090e-01/
      DATA (SELFREF(JT,10),JT=1,10)  /
     & 3.71845e-01, 3.48164e-01, 3.25990e-01, 3.05229e-01, 2.85790e-01,
     & 2.67588e-01, 2.50547e-01, 2.34590e-01, 2.19650e-01, 2.05661e-01/
      DATA (SELFREF(JT,11),JT=1,10)  /
     & 3.60606e-01, 3.40789e-01, 3.22060e-01, 3.04361e-01, 2.87634e-01,
     & 2.71826e-01, 2.56888e-01, 2.42770e-01, 2.29428e-01, 2.16819e-01/
      DATA (SELFREF(JT,12),JT=1,10)  /
     & 3.90046e-01, 3.68879e-01, 3.48860e-01, 3.29928e-01, 3.12023e-01,
     & 2.95089e-01, 2.79075e-01, 2.63930e-01, 2.49607e-01, 2.36061e-01/
      DATA (SELFREF(JT,13),JT=1,10)  /
     & 4.38542e-01, 4.05139e-01, 3.74280e-01, 3.45771e-01, 3.19434e-01,
     & 2.95103e-01, 2.72626e-01, 2.51860e-01, 2.32676e-01, 2.14953e-01/
      DATA (SELFREF(JT,14),JT=1,10)  /
     & 4.19448e-01, 3.81920e-01, 3.47750e-01, 3.16637e-01, 2.88307e-01,
     & 2.62513e-01, 2.39026e-01, 2.17640e-01, 1.98168e-01, 1.80438e-01/
      DATA (SELFREF(JT,15),JT=1,10)  /
     & 4.20276e-01, 3.92281e-01, 3.66150e-01, 3.41760e-01, 3.18995e-01,
     & 2.97746e-01, 2.77912e-01, 2.59400e-01, 2.42121e-01, 2.25993e-01/
      DATA (SELFREF(JT,16),JT=1,10)  /
     & 4.20276e-01, 3.92281e-01, 3.66150e-01, 3.41760e-01, 3.18995e-01,
     & 2.97746e-01, 2.77912e-01, 2.59400e-01, 2.42121e-01, 2.25993e-01/
