C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB11.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.0 $
C     created:   $Date: 2002/06/03 20:41:02 $
       PARAMETER (MG=16)
       DIMENSION SELFREF(10,MG), FORREF(4,MG)
       REAL KA(5,13,MG), KB(5,13:59,MG), KA_MO2(19,MG), KB_MO2(19,MG)

       COMMON /HVRSN11/ HVRKG11
       COMMON /K11/ KA ,KB, FORREF, SELFREF, KA_MO2, KB_MO2

       CHARACTER*15 HVRKG11
       DATA HVRKG11 /'$Revision: 3.0 $'/
C     The array KA contains absorption coefs at the 16 chosen g-values 
C     for a range of pressure levels > ~100mb and temperatures.  The first
C     index in the array, JT, which runs from 1 to 5, corresponds to 
C     different temperatures.  More specifically, JT = 3 means that the 
C     data are for the corresponding TREF for this  pressure level, 
C     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
C     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
C     index, JP, runs from 1 to 13 and refers to the corresponding 
C     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
C     The third index, IG, goes from 1 to 16, and tells us which 
C     g-interval the absorption coefficients are for.
      DATA (KA(JT, 1, 1),JT=1,5) /
     &4.9423E-02,4.8938E-02,4.8236E-02,4.7630E-02,4.7027E-02/
      DATA (KA(JT, 2, 1),JT=1,5) /
     &4.0264E-02,3.9991E-02,3.9414E-02,3.8921E-02,3.8455E-02/
      DATA (KA(JT, 3, 1),JT=1,5) /
     &3.2762E-02,3.2612E-02,3.2225E-02,3.1842E-02,3.1448E-02/
      DATA (KA(JT, 4, 1),JT=1,5) /
     &2.6929E-02,2.6828E-02,2.6636E-02,2.6311E-02,2.5979E-02/
      DATA (KA(JT, 5, 1),JT=1,5) /
     &2.2254E-02,2.2190E-02,2.2139E-02,2.1844E-02,2.1606E-02/
      DATA (KA(JT, 6, 1),JT=1,5) /
     &1.8428E-02,1.8406E-02,1.8346E-02,1.8223E-02,1.7986E-02/
      DATA (KA(JT, 7, 1),JT=1,5) /
     &1.5302E-02,1.5279E-02,1.5227E-02,1.5173E-02,1.5001E-02/
      DATA (KA(JT, 8, 1),JT=1,5) /
     &1.2917E-02,1.2821E-02,1.2762E-02,1.2673E-02,1.2614E-02/
      DATA (KA(JT, 9, 1),JT=1,5) /
     &1.4361E-02,1.3355E-02,1.2836E-02,1.2424E-02,1.2069E-02/
      DATA (KA(JT,10, 1),JT=1,5) /
     &1.9078E-02,1.9077E-02,1.9301E-02,1.9494E-02,1.9600E-02/
      DATA (KA(JT,11, 1),JT=1,5) /
     &1.6651E-02,1.7279E-02,1.7762E-02,1.8212E-02,1.8508E-02/
      DATA (KA(JT,12, 1),JT=1,5) /
     &1.4359E-02,1.4912E-02,1.5370E-02,1.5766E-02,1.6068E-02/
      DATA (KA(JT,13, 1),JT=1,5) /
     &1.2190E-02,1.2693E-02,1.3086E-02,1.3355E-02,1.3602E-02/
      DATA (KA(JT, 1, 2),JT=1,5) /
     &1.3874E-01,1.3507E-01,1.3188E-01,1.2875E-01,1.2573E-01/
      DATA (KA(JT, 2, 2),JT=1,5) /
     &1.1449E-01,1.1143E-01,1.0880E-01,1.0626E-01,1.0384E-01/
      DATA (KA(JT, 3, 2),JT=1,5) /
     &9.4610E-02,9.2157E-02,8.9899E-02,8.7836E-02,8.5813E-02/
      DATA (KA(JT, 4, 2),JT=1,5) /
     &7.8921E-02,7.6917E-02,7.5042E-02,7.3283E-02,7.1619E-02/
      DATA (KA(JT, 5, 2),JT=1,5) /
     &6.6025E-02,6.4395E-02,6.2788E-02,6.1406E-02,5.9938E-02/
      DATA (KA(JT, 6, 2),JT=1,5) /
     &5.5198E-02,5.3979E-02,5.2652E-02,5.1421E-02,5.0291E-02/
      DATA (KA(JT, 7, 2),JT=1,5) /
     &4.5982E-02,4.5142E-02,4.4142E-02,4.3045E-02,4.2121E-02/
      DATA (KA(JT, 8, 2),JT=1,5) /
     &3.8128E-02,3.7632E-02,3.6913E-02,3.6127E-02,3.5207E-02/
      DATA (KA(JT, 9, 2),JT=1,5) /
     &2.9988E-02,3.0199E-02,2.9924E-02,2.9588E-02,2.9106E-02/
      DATA (KA(JT,10, 2),JT=1,5) /
     &4.8557E-02,4.4974E-02,3.7588E-02,3.1508E-02,2.7381E-02/
      DATA (KA(JT,11, 2),JT=1,5) /
     &4.6113E-02,4.4271E-02,4.2375E-02,4.0024E-02,3.7665E-02/
      DATA (KA(JT,12, 2),JT=1,5) /
     &4.0305E-02,3.9408E-02,3.7504E-02,3.5981E-02,3.4390E-02/
      DATA (KA(JT,13, 2),JT=1,5) /
     &3.3779E-02,3.2735E-02,3.1178E-02,2.9814E-02,2.8271E-02/
      DATA (KA(JT, 1, 3),JT=1,5) /
     &2.4150E-01,2.3616E-01,2.3111E-01,2.2673E-01,2.2290E-01/
      DATA (KA(JT, 2, 3),JT=1,5) /
     &2.0007E-01,1.9568E-01,1.9176E-01,1.8825E-01,1.8518E-01/
      DATA (KA(JT, 3, 3),JT=1,5) /
     &1.6573E-01,1.6221E-01,1.5908E-01,1.5616E-01,1.5376E-01/
      DATA (KA(JT, 4, 3),JT=1,5) /
     &1.3876E-01,1.3573E-01,1.3298E-01,1.3059E-01,1.2856E-01/
      DATA (KA(JT, 5, 3),JT=1,5) /
     &1.1663E-01,1.1399E-01,1.1156E-01,1.0951E-01,1.0785E-01/
      DATA (KA(JT, 6, 3),JT=1,5) /
     &9.8259E-02,9.5861E-02,9.3802E-02,9.1948E-02,9.0492E-02/
      DATA (KA(JT, 7, 3),JT=1,5) /
     &8.2887E-02,8.0616E-02,7.8766E-02,7.7206E-02,7.5856E-02/
      DATA (KA(JT, 8, 3),JT=1,5) /
     &6.9730E-02,6.7730E-02,6.5964E-02,6.4565E-02,6.3437E-02/
      DATA (KA(JT, 9, 3),JT=1,5) /
     &5.8101E-02,5.6452E-02,5.5028E-02,5.3674E-02,5.2557E-02/
      DATA (KA(JT,10, 3),JT=1,5) /
     &3.7373E-02,3.5041E-02,3.8621E-02,4.1558E-02,4.3012E-02/
      DATA (KA(JT,11, 3),JT=1,5) /
     &5.3584E-02,4.0890E-02,3.3882E-02,2.9034E-02,2.6383E-02/
      DATA (KA(JT,12, 3),JT=1,5) /
     &5.8428E-02,4.4689E-02,3.5111E-02,2.9172E-02,2.4695E-02/
      DATA (KA(JT,13, 3),JT=1,5) /
     &4.7904E-02,3.6965E-02,2.8601E-02,2.3919E-02,2.0680E-02/
      DATA (KA(JT, 1, 4),JT=1,5) /
     &4.2548E-01,4.1807E-01,4.1094E-01,4.0423E-01,3.9806E-01/
      DATA (KA(JT, 2, 4),JT=1,5) /
     &3.5494E-01,3.4863E-01,3.4235E-01,3.3657E-01,3.3155E-01/
      DATA (KA(JT, 3, 4),JT=1,5) /
     &2.9648E-01,2.9099E-01,2.8545E-01,2.8071E-01,2.7648E-01/
      DATA (KA(JT, 4, 4),JT=1,5) /
     &2.4939E-01,2.4483E-01,2.4021E-01,2.3626E-01,2.3256E-01/
      DATA (KA(JT, 5, 4),JT=1,5) /
     &2.1025E-01,2.0654E-01,2.0285E-01,1.9937E-01,1.9615E-01/
      DATA (KA(JT, 6, 4),JT=1,5) /
     &1.7714E-01,1.7417E-01,1.7124E-01,1.6826E-01,1.6547E-01/
      DATA (KA(JT, 7, 4),JT=1,5) /
     &1.4884E-01,1.4658E-01,1.4422E-01,1.4179E-01,1.3940E-01/
      DATA (KA(JT, 8, 4),JT=1,5) /
     &1.2471E-01,1.2286E-01,1.2117E-01,1.1917E-01,1.1721E-01/
      DATA (KA(JT, 9, 4),JT=1,5) /
     &1.0337E-01,1.0218E-01,1.0077E-01,9.9333E-02,9.7869E-02/
      DATA (KA(JT,10, 4),JT=1,5) /
     &8.5198E-02,8.3413E-02,8.1099E-02,7.8395E-02,7.6293E-02/
      DATA (KA(JT,11, 4),JT=1,5) /
     &6.0820E-02,6.7915E-02,6.7626E-02,6.6844E-02,6.6371E-02/
      DATA (KA(JT,12, 4),JT=1,5) /
     &4.0000E-02,4.8190E-02,5.3574E-02,5.5575E-02,5.5151E-02/
      DATA (KA(JT,13, 4),JT=1,5) /
     &3.3587E-02,4.0386E-02,4.5135E-02,4.6401E-02,4.5805E-02/
      DATA (KA(JT, 1, 5),JT=1,5) /
     &7.7524E-01,7.6536E-01,7.5522E-01,7.4431E-01,7.3311E-01/
      DATA (KA(JT, 2, 5),JT=1,5) /
     &6.5185E-01,6.4405E-01,6.3568E-01,6.2684E-01,6.1765E-01/
      DATA (KA(JT, 3, 5),JT=1,5) /
     &5.4580E-01,5.3942E-01,5.3289E-01,5.2546E-01,5.1768E-01/
      DATA (KA(JT, 4, 5),JT=1,5) /
     &4.5945E-01,4.5416E-01,4.4868E-01,4.4229E-01,4.3592E-01/
      DATA (KA(JT, 5, 5),JT=1,5) /
     &3.8777E-01,3.8350E-01,3.7876E-01,3.7352E-01,3.6853E-01/
      DATA (KA(JT, 6, 5),JT=1,5) /
     &3.2750E-01,3.2403E-01,3.2009E-01,3.1598E-01,3.1216E-01/
      DATA (KA(JT, 7, 5),JT=1,5) /
     &2.7610E-01,2.7333E-01,2.7016E-01,2.6699E-01,2.6402E-01/
      DATA (KA(JT, 8, 5),JT=1,5) /
     &2.3237E-01,2.3021E-01,2.2764E-01,2.2511E-01,2.2263E-01/
      DATA (KA(JT, 9, 5),JT=1,5) /
     &1.9461E-01,1.9312E-01,1.9116E-01,1.8911E-01,1.8708E-01/
      DATA (KA(JT,10, 5),JT=1,5) /
     &1.4772E-01,1.4997E-01,1.5067E-01,1.5164E-01,1.5169E-01/
      DATA (KA(JT,11, 5),JT=1,5) /
     &1.1317E-01,1.1322E-01,1.1552E-01,1.1824E-01,1.1886E-01/
      DATA (KA(JT,12, 5),JT=1,5) /
     &9.7948E-02,9.4310E-02,9.3527E-02,9.3094E-02,9.5273E-02/
      DATA (KA(JT,13, 5),JT=1,5) /
     &8.1443E-02,7.8686E-02,7.8076E-02,7.8298E-02,8.0221E-02/
      DATA (KA(JT, 1, 6),JT=1,5) /
     &1.5697E+00,1.5485E+00,1.5270E+00,1.5062E+00,1.4845E+00/
      DATA (KA(JT, 2, 6),JT=1,5) /
     &1.3465E+00,1.3286E+00,1.3101E+00,1.2912E+00,1.2719E+00/
      DATA (KA(JT, 3, 6),JT=1,5) /
     &1.1474E+00,1.1322E+00,1.1161E+00,1.0997E+00,1.0837E+00/
      DATA (KA(JT, 4, 6),JT=1,5) /
     &9.7861E-01,9.6591E-01,9.5236E-01,9.3871E-01,9.2522E-01/
      DATA (KA(JT, 5, 6),JT=1,5) /
     &8.3345E-01,8.2282E-01,8.1147E-01,8.0015E-01,7.8882E-01/
      DATA (KA(JT, 6, 6),JT=1,5) /
     &7.0768E-01,6.9919E-01,6.8975E-01,6.8018E-01,6.7024E-01/
      DATA (KA(JT, 7, 6),JT=1,5) /
     &5.9916E-01,5.9240E-01,5.8444E-01,5.7632E-01,5.6762E-01/
      DATA (KA(JT, 8, 6),JT=1,5) /
     &5.0612E-01,5.0051E-01,4.9423E-01,4.8731E-01,4.7989E-01/
      DATA (KA(JT, 9, 6),JT=1,5) /
     &4.2622E-01,4.2196E-01,4.1690E-01,4.1124E-01,4.0525E-01/
      DATA (KA(JT,10, 6),JT=1,5) /
     &3.5041E-01,3.4937E-01,3.4686E-01,3.4326E-01,3.3900E-01/
      DATA (KA(JT,11, 6),JT=1,5) /
     &2.8138E-01,2.8270E-01,2.8314E-01,2.8109E-01,2.7863E-01/
      DATA (KA(JT,12, 6),JT=1,5) /
     &2.2569E-01,2.3115E-01,2.3249E-01,2.3233E-01,2.3100E-01/
      DATA (KA(JT,13, 6),JT=1,5) /
     &1.8817E-01,1.9206E-01,1.9341E-01,1.9316E-01,1.9216E-01/
      DATA (KA(JT, 1, 7),JT=1,5) /
     &3.4196E+00,3.3801E+00,3.3399E+00,3.2946E+00,3.2477E+00/
      DATA (KA(JT, 2, 7),JT=1,5) /
     &3.0295E+00,2.9903E+00,2.9469E+00,2.9032E+00,2.8599E+00/
      DATA (KA(JT, 3, 7),JT=1,5) /
     &2.6483E+00,2.6096E+00,2.5696E+00,2.5316E+00,2.4936E+00/
      DATA (KA(JT, 4, 7),JT=1,5) /
     &2.3044E+00,2.2705E+00,2.2374E+00,2.2055E+00,2.1724E+00/
      DATA (KA(JT, 5, 7),JT=1,5) /
     &1.9970E+00,1.9688E+00,1.9416E+00,1.9143E+00,1.8852E+00/
      DATA (KA(JT, 6, 7),JT=1,5) /
     &1.7224E+00,1.6992E+00,1.6760E+00,1.6526E+00,1.6276E+00/
      DATA (KA(JT, 7, 7),JT=1,5) /
     &1.4770E+00,1.4579E+00,1.4384E+00,1.4185E+00,1.3976E+00/
      DATA (KA(JT, 8, 7),JT=1,5) /
     &1.2593E+00,1.2433E+00,1.2274E+00,1.2112E+00,1.1939E+00/
      DATA (KA(JT, 9, 7),JT=1,5) /
     &1.0697E+00,1.0563E+00,1.0434E+00,1.0295E+00,1.0150E+00/
      DATA (KA(JT,10, 7),JT=1,5) /
     &9.0213E-01,8.9139E-01,8.8119E-01,8.6954E-01,8.5716E-01/
      DATA (KA(JT,11, 7),JT=1,5) /
     &7.5061E-01,7.4446E-01,7.3597E-01,7.2638E-01,7.1615E-01/
      DATA (KA(JT,12, 7),JT=1,5) /
     &6.2457E-01,6.1924E-01,6.1219E-01,6.0465E-01,5.9633E-01/
      DATA (KA(JT,13, 7),JT=1,5) /
     &5.2204E-01,5.1758E-01,5.1182E-01,5.0530E-01,4.9787E-01/
      DATA (KA(JT, 1, 8),JT=1,5) /
     &7.9795E+00,7.8457E+00,7.7132E+00,7.5890E+00,7.4645E+00/
      DATA (KA(JT, 2, 8),JT=1,5) /
     &7.5076E+00,7.3733E+00,7.2519E+00,7.1316E+00,7.0099E+00/
      DATA (KA(JT, 3, 8),JT=1,5) /
     &6.9340E+00,6.8148E+00,6.7036E+00,6.5875E+00,6.4766E+00/
      DATA (KA(JT, 4, 8),JT=1,5) /
     &6.3414E+00,6.2366E+00,6.1298E+00,6.0215E+00,5.9183E+00/
      DATA (KA(JT, 5, 8),JT=1,5) /
     &5.7373E+00,5.6423E+00,5.5412E+00,5.4426E+00,5.3434E+00/
      DATA (KA(JT, 6, 8),JT=1,5) /
     &5.1373E+00,5.0482E+00,4.9577E+00,4.8621E+00,4.7659E+00/
      DATA (KA(JT, 7, 8),JT=1,5) /
     &4.5492E+00,4.4684E+00,4.3821E+00,4.2928E+00,4.2067E+00/
      DATA (KA(JT, 8, 8),JT=1,5) /
     &3.9884E+00,3.9140E+00,3.8349E+00,3.7563E+00,3.6821E+00/
      DATA (KA(JT, 9, 8),JT=1,5) /
     &3.4656E+00,3.3995E+00,3.3300E+00,3.2636E+00,3.2010E+00/
      DATA (KA(JT,10, 8),JT=1,5) /
     &2.9841E+00,2.9267E+00,2.8680E+00,2.8124E+00,2.7592E+00/
      DATA (KA(JT,11, 8),JT=1,5) /
     &2.5294E+00,2.4795E+00,2.4321E+00,2.3862E+00,2.3418E+00/
      DATA (KA(JT,12, 8),JT=1,5) /
     &2.1315E+00,2.0918E+00,2.0527E+00,2.0146E+00,1.9776E+00/
      DATA (KA(JT,13, 8),JT=1,5) /
     &1.7932E+00,1.7598E+00,1.7272E+00,1.6957E+00,1.6643E+00/
      DATA (KA(JT, 1, 9),JT=1,5) /
     &1.8965E+01,1.8711E+01,1.8469E+01,1.8242E+01,1.8035E+01/
      DATA (KA(JT, 2, 9),JT=1,5) /
     &1.9621E+01,1.9373E+01,1.9124E+01,1.8882E+01,1.8648E+01/
      DATA (KA(JT, 3, 9),JT=1,5) /
     &2.0111E+01,1.9849E+01,1.9576E+01,1.9310E+01,1.9047E+01/
      DATA (KA(JT, 4, 9),JT=1,5) /
     &2.0303E+01,2.0017E+01,1.9726E+01,1.9447E+01,1.9174E+01/
      DATA (KA(JT, 5, 9),JT=1,5) /
     &2.0176E+01,1.9882E+01,1.9591E+01,1.9312E+01,1.9035E+01/
      DATA (KA(JT, 6, 9),JT=1,5) /
     &1.9747E+01,1.9457E+01,1.9166E+01,1.8888E+01,1.8606E+01/
      DATA (KA(JT, 7, 9),JT=1,5) /
     &1.9018E+01,1.8727E+01,1.8446E+01,1.8173E+01,1.7878E+01/
      DATA (KA(JT, 8, 9),JT=1,5) /
     &1.8015E+01,1.7734E+01,1.7466E+01,1.7191E+01,1.6898E+01/
      DATA (KA(JT, 9, 9),JT=1,5) /
     &1.6785E+01,1.6527E+01,1.6264E+01,1.5992E+01,1.5711E+01/
      DATA (KA(JT,10, 9),JT=1,5) /
     &1.5379E+01,1.5144E+01,1.4899E+01,1.4648E+01,1.4396E+01/
      DATA (KA(JT,11, 9),JT=1,5) /
     &1.3809E+01,1.3588E+01,1.3370E+01,1.3146E+01,1.2927E+01/
      DATA (KA(JT,12, 9),JT=1,5) /
     &1.2243E+01,1.2056E+01,1.1862E+01,1.1669E+01,1.1464E+01/
      DATA (KA(JT,13, 9),JT=1,5) /
     &1.0743E+01,1.0581E+01,1.0416E+01,1.0238E+01,1.0057E+01/
      DATA (KA(JT, 1,10),JT=1,5) /
     &3.4918E+01,3.4410E+01,3.3938E+01,3.3384E+01,3.2811E+01/
      DATA (KA(JT, 2,10),JT=1,5) /
     &3.7421E+01,3.6860E+01,3.6321E+01,3.5822E+01,3.5445E+01/
      DATA (KA(JT, 3,10),JT=1,5) /
     &4.0412E+01,3.9722E+01,3.9217E+01,3.8832E+01,3.8460E+01/
      DATA (KA(JT, 4,10),JT=1,5) /
     &4.3162E+01,4.2539E+01,4.2112E+01,4.1640E+01,4.1120E+01/
      DATA (KA(JT, 5,10),JT=1,5) /
     &4.5609E+01,4.5045E+01,4.4552E+01,4.3899E+01,4.3271E+01/
      DATA (KA(JT, 6,10),JT=1,5) /
     &4.7877E+01,4.7338E+01,4.6747E+01,4.6031E+01,4.5492E+01/
      DATA (KA(JT, 7,10),JT=1,5) /
     &4.9831E+01,4.9324E+01,4.8717E+01,4.8005E+01,4.7611E+01/
      DATA (KA(JT, 8,10),JT=1,5) /
     &5.1031E+01,5.0574E+01,4.9915E+01,4.9244E+01,4.8761E+01/
      DATA (KA(JT, 9,10),JT=1,5) /
     &5.1465E+01,5.0984E+01,5.0270E+01,4.9612E+01,4.9032E+01/
      DATA (KA(JT,10,10),JT=1,5) /
     &5.0911E+01,5.0267E+01,4.9512E+01,4.8818E+01,4.8092E+01/
      DATA (KA(JT,11,10),JT=1,5) /
     &4.8719E+01,4.7980E+01,4.7190E+01,4.6412E+01,4.5593E+01/
      DATA (KA(JT,12,10),JT=1,5) /
     &4.5566E+01,4.4779E+01,4.4020E+01,4.3287E+01,4.2695E+01/
      DATA (KA(JT,13,10),JT=1,5) /
     &4.1842E+01,4.1126E+01,4.0474E+01,3.9934E+01,3.9455E+01/
      DATA (KA(JT, 1,11),JT=1,5) /
     &4.3485E+01,4.3086E+01,4.2575E+01,4.2046E+01,4.1574E+01/
      DATA (KA(JT, 2,11),JT=1,5) /
     &4.8017E+01,4.7410E+01,4.6743E+01,4.6112E+01,4.5460E+01/
      DATA (KA(JT, 3,11),JT=1,5) /
     &5.1964E+01,5.1351E+01,5.0628E+01,4.9892E+01,4.9112E+01/
      DATA (KA(JT, 4,11),JT=1,5) /
     &5.5970E+01,5.5232E+01,5.4425E+01,5.3658E+01,5.2964E+01/
      DATA (KA(JT, 5,11),JT=1,5) /
     &6.0234E+01,5.9398E+01,5.8467E+01,5.7720E+01,5.7104E+01/
      DATA (KA(JT, 6,11),JT=1,5) /
     &6.4036E+01,6.3174E+01,6.2265E+01,6.1623E+01,6.0928E+01/
      DATA (KA(JT, 7,11),JT=1,5) /
     &6.7087E+01,6.6347E+01,6.5603E+01,6.4996E+01,6.4192E+01/
      DATA (KA(JT, 8,11),JT=1,5) /
     &6.9922E+01,6.9386E+01,6.8783E+01,6.8159E+01,6.7317E+01/
      DATA (KA(JT, 9,11),JT=1,5) /
     &7.2326E+01,7.1863E+01,7.1404E+01,7.0792E+01,6.9972E+01/
      DATA (KA(JT,10,11),JT=1,5) /
     &7.3782E+01,7.3486E+01,7.3017E+01,7.2321E+01,7.1486E+01/
      DATA (KA(JT,11,11),JT=1,5) /
     &7.4137E+01,7.3779E+01,7.3113E+01,7.2218E+01,7.1354E+01/
      DATA (KA(JT,12,11),JT=1,5) /
     &7.3214E+01,7.2506E+01,7.1526E+01,7.0521E+01,6.9446E+01/
      DATA (KA(JT,13,11),JT=1,5) /
     &7.0360E+01,6.9342E+01,6.8249E+01,6.7098E+01,6.5980E+01/
      DATA (KA(JT, 1,12),JT=1,5) /
     &5.1887E+01,5.1393E+01,5.0969E+01,5.0675E+01,5.0203E+01/
      DATA (KA(JT, 2,12),JT=1,5) /
     &5.9704E+01,5.9201E+01,5.8829E+01,5.8469E+01,5.7899E+01/
      DATA (KA(JT, 3,12),JT=1,5) /
     &6.7858E+01,6.7238E+01,6.6756E+01,6.6195E+01,6.5626E+01/
      DATA (KA(JT, 4,12),JT=1,5) /
     &7.5062E+01,7.4258E+01,7.3522E+01,7.2807E+01,7.2094E+01/
      DATA (KA(JT, 5,12),JT=1,5) /
     &8.1152E+01,8.0143E+01,7.9393E+01,7.8647E+01,7.7881E+01/
      DATA (KA(JT, 6,12),JT=1,5) /
     &8.7340E+01,8.6150E+01,8.5372E+01,8.4516E+01,8.3657E+01/
      DATA (KA(JT, 7,12),JT=1,5) /
     &9.4121E+01,9.2665E+01,9.1695E+01,9.0706E+01,8.9764E+01/
      DATA (KA(JT, 8,12),JT=1,5) /
     &1.0086E+02,9.9171E+01,9.7989E+01,9.6851E+01,9.5921E+01/
      DATA (KA(JT, 9,12),JT=1,5) /
     &1.0671E+02,1.0483E+02,1.0352E+02,1.0233E+02,1.0145E+02/
      DATA (KA(JT,10,12),JT=1,5) /
     &1.1135E+02,1.0957E+02,1.0846E+02,1.0742E+02,1.0652E+02/
      DATA (KA(JT,11,12),JT=1,5) /
     &1.1430E+02,1.1336E+02,1.1254E+02,1.1170E+02,1.1063E+02/
      DATA (KA(JT,12,12),JT=1,5) /
     &1.1681E+02,1.1638E+02,1.1571E+02,1.1469E+02,1.1347E+02/
      DATA (KA(JT,13,12),JT=1,5) /
     &1.1832E+02,1.1787E+02,1.1696E+02,1.1585E+02,1.1448E+02/
      DATA (KA(JT, 1,13),JT=1,5) /
     &6.2138E+01,6.1536E+01,6.0957E+01,6.0185E+01,5.9644E+01/
      DATA (KA(JT, 2,13),JT=1,5) /
     &7.3104E+01,7.2436E+01,7.1604E+01,7.0616E+01,6.9923E+01/
      DATA (KA(JT, 3,13),JT=1,5) /
     &8.5575E+01,8.4690E+01,8.3633E+01,8.2595E+01,8.1733E+01/
      DATA (KA(JT, 4,13),JT=1,5) /
     &9.8880E+01,9.7932E+01,9.6845E+01,9.5711E+01,9.4631E+01/
      DATA (KA(JT, 5,13),JT=1,5) /
     &1.1273E+02,1.1168E+02,1.1051E+02,1.0912E+02,1.0775E+02/
      DATA (KA(JT, 6,13),JT=1,5) /
     &1.2651E+02,1.2538E+02,1.2389E+02,1.2226E+02,1.2074E+02/
      DATA (KA(JT, 7,13),JT=1,5) /
     &1.4003E+02,1.3861E+02,1.3671E+02,1.3477E+02,1.3302E+02/
      DATA (KA(JT, 8,13),JT=1,5) /
     &1.5267E+02,1.5069E+02,1.4845E+02,1.4633E+02,1.4433E+02/
      DATA (KA(JT, 9,13),JT=1,5) /
     &1.6510E+02,1.6280E+02,1.6039E+02,1.5803E+02,1.5572E+02/
      DATA (KA(JT,10,13),JT=1,5) /
     &1.7758E+02,1.7506E+02,1.7227E+02,1.6951E+02,1.6718E+02/
      DATA (KA(JT,11,13),JT=1,5) /
     &1.8910E+02,1.8565E+02,1.8227E+02,1.7970E+02,1.7779E+02/
      DATA (KA(JT,12,13),JT=1,5) /
     &1.9894E+02,1.9500E+02,1.9204E+02,1.8987E+02,1.8782E+02/
      DATA (KA(JT,13,13),JT=1,5) /
     &2.0665E+02,2.0326E+02,2.0074E+02,1.9867E+02,1.9680E+02/
      DATA (KA(JT, 1,14),JT=1,5) /
     &7.2473E+01,7.1368E+01,7.0428E+01,6.9932E+01,6.9604E+01/
      DATA (KA(JT, 2,14),JT=1,5) /
     &8.7789E+01,8.6447E+01,8.5315E+01,8.4536E+01,8.3865E+01/
      DATA (KA(JT, 3,14),JT=1,5) /
     &1.0616E+02,1.0473E+02,1.0338E+02,1.0236E+02,1.0132E+02/
      DATA (KA(JT, 4,14),JT=1,5) /
     &1.2669E+02,1.2502E+02,1.2342E+02,1.2210E+02,1.2081E+02/
      DATA (KA(JT, 5,14),JT=1,5) /
     &1.4951E+02,1.4761E+02,1.4568E+02,1.4409E+02,1.4262E+02/
      DATA (KA(JT, 6,14),JT=1,5) /
     &1.7487E+02,1.7259E+02,1.7054E+02,1.6873E+02,1.6691E+02/
      DATA (KA(JT, 7,14),JT=1,5) /
     &2.0246E+02,2.0010E+02,1.9793E+02,1.9585E+02,1.9382E+02/
      DATA (KA(JT, 8,14),JT=1,5) /
     &2.3272E+02,2.3034E+02,2.2811E+02,2.2588E+02,2.2363E+02/
      DATA (KA(JT, 9,14),JT=1,5) /
     &2.6521E+02,2.6298E+02,2.6062E+02,2.5802E+02,2.5525E+02/
      DATA (KA(JT,10,14),JT=1,5) /
     &2.9843E+02,2.9609E+02,2.9357E+02,2.9069E+02,2.8721E+02/
      DATA (KA(JT,11,14),JT=1,5) /
     &3.3019E+02,3.2789E+02,3.2506E+02,3.2111E+02,3.1667E+02/
      DATA (KA(JT,12,14),JT=1,5) /
     &3.6200E+02,3.5928E+02,3.5512E+02,3.5030E+02,3.4598E+02/
      DATA (KA(JT,13,14),JT=1,5) /
     &3.9453E+02,3.9054E+02,3.8556E+02,3.8029E+02,3.7518E+02/
      DATA (KA(JT, 1,15),JT=1,5) /
     &8.4296E+01,8.4294E+01,8.4592E+01,8.4817E+01,8.4944E+01/
      DATA (KA(JT, 2,15),JT=1,5) /
     &1.0316E+02,1.0286E+02,1.0304E+02,1.0333E+02,1.0370E+02/
      DATA (KA(JT, 3,15),JT=1,5) /
     &1.2648E+02,1.2563E+02,1.2552E+02,1.2542E+02,1.2564E+02/
      DATA (KA(JT, 4,15),JT=1,5) /
     &1.5355E+02,1.5194E+02,1.5117E+02,1.5062E+02,1.5044E+02/
      DATA (KA(JT, 5,15),JT=1,5) /
     &1.8607E+02,1.8324E+02,1.8143E+02,1.8019E+02,1.7911E+02/
      DATA (KA(JT, 6,15),JT=1,5) /
     &2.2538E+02,2.2140E+02,2.1806E+02,2.1567E+02,2.1369E+02/
      DATA (KA(JT, 7,15),JT=1,5) /
     &2.7204E+02,2.6705E+02,2.6220E+02,2.5861E+02,2.5549E+02/
      DATA (KA(JT, 8,15),JT=1,5) /
     &3.2681E+02,3.2069E+02,3.1478E+02,3.0961E+02,3.0517E+02/
      DATA (KA(JT, 9,15),JT=1,5) /
     &3.9109E+02,3.8311E+02,3.7570E+02,3.6941E+02,3.6369E+02/
      DATA (KA(JT,10,15),JT=1,5) /
     &4.6558E+02,4.5519E+02,4.4566E+02,4.3786E+02,4.3114E+02/
      DATA (KA(JT,11,15),JT=1,5) /
     &5.4422E+02,5.3170E+02,5.2160E+02,5.1300E+02,5.0502E+02/
      DATA (KA(JT,12,15),JT=1,5) /
     &6.3083E+02,6.1809E+02,6.0782E+02,5.9755E+02,5.8778E+02/
      DATA (KA(JT,13,15),JT=1,5) /
     &7.2633E+02,7.1401E+02,7.0254E+02,6.9098E+02,6.8020E+02/
      DATA (KA(JT, 1,16),JT=1,5) /
     &9.0293E+01,9.1524E+01,9.2499E+01,9.3157E+01,9.3569E+01/
      DATA (KA(JT, 2,16),JT=1,5) /
     &1.1228E+02,1.1346E+02,1.1477E+02,1.1575E+02,1.1638E+02/
      DATA (KA(JT, 3,16),JT=1,5) /
     &1.3962E+02,1.4080E+02,1.4217E+02,1.4343E+02,1.4444E+02/
      DATA (KA(JT, 4,16),JT=1,5) /
     &1.7141E+02,1.7272E+02,1.7425E+02,1.7564E+02,1.7671E+02/
      DATA (KA(JT, 5,16),JT=1,5) /
     &2.0680E+02,2.1031E+02,2.1221E+02,2.1383E+02,2.1512E+02/
      DATA (KA(JT, 6,16),JT=1,5) /
     &2.5314E+02,2.5478E+02,2.5735E+02,2.5955E+02,2.6116E+02/
      DATA (KA(JT, 7,16),JT=1,5) /
     &3.0938E+02,3.0774E+02,3.1113E+02,3.1414E+02,3.1633E+02/
      DATA (KA(JT, 8,16),JT=1,5) /
     &3.7909E+02,3.7514E+02,3.7476E+02,3.7901E+02,3.8212E+02/
      DATA (KA(JT, 9,16),JT=1,5) /
     &4.6433E+02,4.5795E+02,4.5378E+02,4.5558E+02,4.5979E+02/
      DATA (KA(JT,10,16),JT=1,5) /
     &5.6730E+02,5.5767E+02,5.5088E+02,5.4957E+02,5.5150E+02/
      DATA (KA(JT,11,16),JT=1,5) /
     &6.8668E+02,6.7309E+02,6.6516E+02,6.6333E+02,6.6322E+02/
      DATA (KA(JT,12,16),JT=1,5) /
     &8.3053E+02,8.1176E+02,8.0043E+02,7.9744E+02,7.9485E+02/
      DATA (KA(JT,13,16),JT=1,5) /
     &1.0026E+03,9.7775E+02,9.6058E+02,9.5314E+02,9.4719E+02/

C     The array KB contains absorption coefs at the 16 chosen g-values 
C     for a range of pressure levels < ~100mb and temperatures. The first 
C     index in the array, JT, which runs from 1 to 5, corresponds to 
C     different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this pressure 
C     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
C     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
C     The second index, JP, runs from 13 to 59 and refers to the JPth
C     reference pressure level (see taumol.f for the value of these
C     pressure levels in mb).  The third index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA (KB(JT,13, 1),JT=1,5) /
     &1.2190E-02,1.2693E-02,1.3086E-02,1.3355E-02,1.3602E-02/
      DATA (KB(JT,14, 1),JT=1,5) /
     &1.0639E-02,1.0991E-02,1.1315E-02,1.1564E-02,1.1518E-02/
      DATA (KB(JT,15, 1),JT=1,5) /
     &9.4343E-03,9.6676E-03,9.5938E-03,9.5530E-03,9.4890E-03/
      DATA (KB(JT,16, 1),JT=1,5) /
     &7.9681E-03,7.8419E-03,7.8162E-03,7.7492E-03,7.7652E-03/
      DATA (KB(JT,17, 1),JT=1,5) /
     &6.4068E-03,6.3539E-03,6.3265E-03,6.3294E-03,6.2292E-03/
      DATA (KB(JT,18, 1),JT=1,5) /
     &5.1420E-03,5.1335E-03,5.0780E-03,5.0408E-03,5.0223E-03/
      DATA (KB(JT,19, 1),JT=1,5) /
     &4.1739E-03,4.1404E-03,4.1032E-03,4.0908E-03,4.0562E-03/
      DATA (KB(JT,20, 1),JT=1,5) /
     &3.3887E-03,3.3668E-03,3.3481E-03,3.3359E-03,3.2948E-03/
      DATA (KB(JT,21, 1),JT=1,5) /
     &2.7580E-03,2.7551E-03,2.7356E-03,2.7092E-03,2.6841E-03/
      DATA (KB(JT,22, 1),JT=1,5) /
     &2.2558E-03,2.2435E-03,2.2235E-03,2.2041E-03,2.1870E-03/
      DATA (KB(JT,23, 1),JT=1,5) /
     &1.8426E-03,1.8324E-03,1.8088E-03,1.7975E-03,1.7882E-03/
      DATA (KB(JT,24, 1),JT=1,5) /
     &1.5091E-03,1.4914E-03,1.4770E-03,1.4698E-03,1.4675E-03/
      DATA (KB(JT,25, 1),JT=1,5) /
     &1.2361E-03,1.2170E-03,1.2068E-03,1.2059E-03,1.2054E-03/
      DATA (KB(JT,26, 1),JT=1,5) /
     &1.0050E-03,9.9424E-04,9.8921E-04,9.8950E-04,9.9102E-04/
      DATA (KB(JT,27, 1),JT=1,5) /
     &8.1924E-04,8.1181E-04,8.1111E-04,8.1148E-04,8.1057E-04/
      DATA (KB(JT,28, 1),JT=1,5) /
     &6.6881E-04,6.6398E-04,6.6473E-04,6.6536E-04,6.6057E-04/
      DATA (KB(JT,29, 1),JT=1,5) /
     &5.4452E-04,5.4181E-04,5.4254E-04,5.4342E-04,5.3551E-04/
      DATA (KB(JT,30, 1),JT=1,5) /
     &4.4259E-04,4.4140E-04,4.4207E-04,4.4326E-04,4.2874E-04/
      DATA (KB(JT,31, 1),JT=1,5) /
     &3.5899E-04,3.5826E-04,3.5911E-04,3.5984E-04,3.4298E-04/
      DATA (KB(JT,32, 1),JT=1,5) /
     &2.9138E-04,2.9104E-04,2.9178E-04,2.9237E-04,2.7522E-04/
      DATA (KB(JT,33, 1),JT=1,5) /
     &2.3674E-04,2.3667E-04,2.3708E-04,2.3749E-04,2.2116E-04/
      DATA (KB(JT,34, 1),JT=1,5) /
     &1.9293E-04,1.9295E-04,1.9307E-04,1.9353E-04,1.7944E-04/
      DATA (KB(JT,35, 1),JT=1,5) /
     &1.5741E-04,1.5737E-04,1.5735E-04,1.5778E-04,1.4713E-04/
      DATA (KB(JT,36, 1),JT=1,5) /
     &1.2872E-04,1.2833E-04,1.2856E-04,1.2886E-04,1.2147E-04/
      DATA (KB(JT,37, 1),JT=1,5) /
     &1.0573E-04,1.0521E-04,1.0532E-04,1.0552E-04,1.0153E-04/
      DATA (KB(JT,38, 1),JT=1,5) /
     &8.6912E-05,8.6294E-05,8.6278E-05,8.6393E-05,8.5663E-05/
      DATA (KB(JT,39, 1),JT=1,5) /
     &7.1476E-05,7.0797E-05,7.0693E-05,7.0706E-05,7.0752E-05/
      DATA (KB(JT,40, 1),JT=1,5) /
     &5.8778E-05,5.8375E-05,5.8149E-05,5.8120E-05,5.8038E-05/
      DATA (KB(JT,41, 1),JT=1,5) /
     &4.8208E-05,4.8291E-05,4.7939E-05,4.7839E-05,4.7717E-05/
      DATA (KB(JT,42, 1),JT=1,5) /
     &3.9735E-05,3.9794E-05,3.9588E-05,3.9414E-05,3.9275E-05/
      DATA (KB(JT,43, 1),JT=1,5) /
     &3.3069E-05,3.2750E-05,3.2898E-05,3.2646E-05,3.2434E-05/
      DATA (KB(JT,44, 1),JT=1,5) /
     &2.7160E-05,2.7263E-05,2.7120E-05,2.7165E-05,2.6874E-05/
      DATA (KB(JT,45, 1),JT=1,5) /
     &2.2285E-05,2.2565E-05,2.2508E-05,2.2456E-05,2.2357E-05/
      DATA (KB(JT,46, 1),JT=1,5) /
     &1.8468E-05,1.8529E-05,1.8744E-05,1.8640E-05,1.8584E-05/
      DATA (KB(JT,47, 1),JT=1,5) /
     &1.5267E-05,1.5373E-05,1.5389E-05,1.5590E-05,1.5417E-05/
      DATA (KB(JT,48, 1),JT=1,5) /
     &1.2576E-05,1.2765E-05,1.2771E-05,1.2828E-05,1.2953E-05/
      DATA (KB(JT,49, 1),JT=1,5) /
     &1.0526E-05,1.0503E-05,1.0641E-05,1.0645E-05,1.0671E-05/
      DATA (KB(JT,50, 1),JT=1,5) /
     &8.5146E-06,8.8286E-06,8.7879E-06,8.8870E-06,8.8515E-06/
      DATA (KB(JT,51, 1),JT=1,5) /
     &6.8551E-06,7.1714E-06,7.4262E-06,7.3568E-06,7.4039E-06/
      DATA (KB(JT,52, 1),JT=1,5) /
     &5.5111E-06,5.7854E-06,6.0431E-06,6.2230E-06,6.1473E-06/
      DATA (KB(JT,53, 1),JT=1,5) /
     &4.4382E-06,4.6559E-06,4.8718E-06,5.0815E-06,5.1941E-06/
      DATA (KB(JT,54, 1),JT=1,5) /
     &3.6177E-06,3.7935E-06,3.9613E-06,4.1342E-06,4.2936E-06/
      DATA (KB(JT,55, 1),JT=1,5) /
     &2.9336E-06,3.1004E-06,3.2420E-06,3.3846E-06,3.5194E-06/
      DATA (KB(JT,56, 1),JT=1,5) /
     &2.3777E-06,2.5393E-06,2.6559E-06,2.7737E-06,2.8819E-06/
      DATA (KB(JT,57, 1),JT=1,5) /
     &1.9258E-06,2.0635E-06,2.1875E-06,2.2772E-06,2.3684E-06/
      DATA (KB(JT,58, 1),JT=1,5) /
     &1.5658E-06,1.6813E-06,1.7910E-06,1.8800E-06,1.9530E-06/
      DATA (KB(JT,59, 1),JT=1,5) /
     &1.3188E-06,1.4141E-06,1.4979E-06,1.5764E-06,1.6384E-06/
      DATA (KB(JT,13, 2),JT=1,5) /
     &3.3779E-02,3.2735E-02,3.1178E-02,2.9814E-02,2.8271E-02/
      DATA (KB(JT,14, 2),JT=1,5) /
     &2.7945E-02,2.6846E-02,2.5419E-02,2.4157E-02,2.2814E-02/
      DATA (KB(JT,15, 2),JT=1,5) /
     &2.2748E-02,2.1521E-02,2.0571E-02,1.9559E-02,1.8047E-02/
      DATA (KB(JT,16, 2),JT=1,5) /
     &1.8337E-02,1.7587E-02,1.6750E-02,1.5705E-02,1.3259E-02/
      DATA (KB(JT,17, 2),JT=1,5) /
     &1.5034E-02,1.4343E-02,1.3736E-02,1.1541E-02,9.7400E-03/
      DATA (KB(JT,18, 2),JT=1,5) /
     &1.2164E-02,1.1828E-02,9.9998E-03,8.2911E-03,6.9774E-03/
      DATA (KB(JT,19, 2),JT=1,5) /
     &1.0053E-02,8.7760E-03,7.2944E-03,6.0291E-03,5.2188E-03/
      DATA (KB(JT,20, 2),JT=1,5) /
     &8.0996E-03,6.6628E-03,5.4744E-03,4.5474E-03,4.0343E-03/
      DATA (KB(JT,21, 2),JT=1,5) /
     &6.1685E-03,5.0455E-03,4.1278E-03,3.5537E-03,3.1461E-03/
      DATA (KB(JT,22, 2),JT=1,5) /
     &4.6680E-03,3.7894E-03,3.1347E-03,2.7602E-03,2.4538E-03/
      DATA (KB(JT,23, 2),JT=1,5) /
     &3.5105E-03,2.8430E-03,2.4311E-03,2.1442E-03,1.9116E-03/
      DATA (KB(JT,24, 2),JT=1,5) /
     &2.6394E-03,2.1852E-03,1.8960E-03,1.6702E-03,1.4993E-03/
      DATA (KB(JT,25, 2),JT=1,5) /
     &2.0041E-03,1.6920E-03,1.4784E-03,1.3107E-03,1.1883E-03/
      DATA (KB(JT,26, 2),JT=1,5) /
     &1.5414E-03,1.3189E-03,1.1564E-03,1.0333E-03,9.4710E-04/
      DATA (KB(JT,27, 2),JT=1,5) /
     &1.2025E-03,1.0381E-03,9.1423E-04,8.1996E-04,7.6323E-04/
      DATA (KB(JT,28, 2),JT=1,5) /
     &9.4481E-04,8.2314E-04,7.2601E-04,6.5680E-04,6.2105E-04/
      DATA (KB(JT,29, 2),JT=1,5) /
     &7.4291E-04,6.5138E-04,5.7968E-04,5.2914E-04,5.0508E-04/
      DATA (KB(JT,30, 2),JT=1,5) /
     &5.8796E-04,5.1841E-04,4.6161E-04,4.2521E-04,4.1671E-04/
      DATA (KB(JT,31, 2),JT=1,5) /
     &4.6334E-04,4.1198E-04,3.6828E-04,3.4267E-04,3.4322E-04/
      DATA (KB(JT,32, 2),JT=1,5) /
     &3.6683E-04,3.2718E-04,2.9598E-04,2.7743E-04,2.8106E-04/
      DATA (KB(JT,33, 2),JT=1,5) /
     &2.9220E-04,2.6104E-04,2.3912E-04,2.2529E-04,2.3032E-04/
      DATA (KB(JT,34, 2),JT=1,5) /
     &2.3494E-04,2.1114E-04,1.9458E-04,1.8336E-04,1.8849E-04/
      DATA (KB(JT,35, 2),JT=1,5) /
     &1.9117E-04,1.7220E-04,1.5969E-04,1.5013E-04,1.5359E-04/
      DATA (KB(JT,36, 2),JT=1,5) /
     &1.5747E-04,1.4221E-04,1.3171E-04,1.2370E-04,1.2459E-04/
      DATA (KB(JT,37, 2),JT=1,5) /
     &1.3250E-04,1.1910E-04,1.0968E-04,1.0296E-04,1.0130E-04/
      DATA (KB(JT,38, 2),JT=1,5) /
     &1.1160E-04,9.9715E-05,9.1665E-05,8.5730E-05,8.1933E-05/
      DATA (KB(JT,39, 2),JT=1,5) /
     &9.4135E-05,8.3974E-05,7.6783E-05,7.1718E-05,6.7517E-05/
      DATA (KB(JT,40, 2),JT=1,5) /
     &8.0997E-05,7.2288E-05,6.5235E-05,6.0491E-05,5.6970E-05/
      DATA (KB(JT,41, 2),JT=1,5) /
     &7.0436E-05,6.2097E-05,5.5431E-05,5.1123E-05,4.8054E-05/
      DATA (KB(JT,42, 2),JT=1,5) /
     &6.1655E-05,5.3367E-05,4.7548E-05,4.3416E-05,4.0552E-05/
      DATA (KB(JT,43, 2),JT=1,5) /
     &5.5272E-05,4.6832E-05,4.1549E-05,3.7143E-05,3.4563E-05/
      DATA (KB(JT,44, 2),JT=1,5) /
     &5.0350E-05,4.1911E-05,3.6573E-05,3.2553E-05,2.9621E-05/
      DATA (KB(JT,45, 2),JT=1,5) /
     &4.6680E-05,3.8062E-05,3.2149E-05,2.8703E-05,2.5694E-05/
      DATA (KB(JT,46, 2),JT=1,5) /
     &4.2769E-05,3.5698E-05,2.9139E-05,2.5199E-05,2.2638E-05/
      DATA (KB(JT,47, 2),JT=1,5) /
     &3.6477E-05,3.2822E-05,2.7467E-05,2.2730E-05,2.0075E-05/
      DATA (KB(JT,48, 2),JT=1,5) /
     &3.0609E-05,2.9832E-05,2.5641E-05,2.1246E-05,1.7927E-05/
      DATA (KB(JT,49, 2),JT=1,5) /
     &2.5892E-05,2.4976E-05,2.3819E-05,2.0178E-05,1.6719E-05/
      DATA (KB(JT,50, 2),JT=1,5) /
     &2.2068E-05,2.0897E-05,2.0445E-05,1.8401E-05,1.5648E-05/
      DATA (KB(JT,51, 2),JT=1,5) /
     &1.8894E-05,1.8060E-05,1.7047E-05,1.6809E-05,1.4426E-05/
      DATA (KB(JT,52, 2),JT=1,5) /
     &1.6131E-05,1.5345E-05,1.4613E-05,1.3961E-05,1.3398E-05/
      DATA (KB(JT,53, 2),JT=1,5) /
     &1.3727E-05,1.3222E-05,1.2619E-05,1.1906E-05,1.1467E-05/
      DATA (KB(JT,54, 2),JT=1,5) /
     &1.1644E-05,1.1203E-05,1.0779E-05,1.0373E-05,9.7090E-06/
      DATA (KB(JT,55, 2),JT=1,5) /
     &9.9606E-06,9.5440E-06,9.2216E-06,8.7822E-06,8.3198E-06/
      DATA (KB(JT,56, 2),JT=1,5) /
     &8.4517E-06,8.1696E-06,7.8373E-06,7.5094E-06,7.2266E-06/
      DATA (KB(JT,57, 2),JT=1,5) /
     &7.1634E-06,7.0985E-06,6.7296E-06,6.4794E-06,6.1647E-06/
      DATA (KB(JT,58, 2),JT=1,5) /
     &6.2286E-06,5.9713E-06,5.8323E-06,5.5370E-06,5.3465E-06/
      DATA (KB(JT,59, 2),JT=1,5) /
     &5.3307E-06,5.0367E-06,4.9690E-06,4.6758E-06,4.5062E-06/
      DATA (KB(JT,13, 3),JT=1,5) /
     &4.7904E-02,3.6965E-02,2.8601E-02,2.3919E-02,2.0680E-02/
      DATA (KB(JT,14, 3),JT=1,5) /
     &3.6570E-02,2.7810E-02,2.1848E-02,1.8508E-02,1.6582E-02/
      DATA (KB(JT,15, 3),JT=1,5) /
     &2.6097E-02,1.9628E-02,1.6268E-02,1.4252E-02,1.3801E-02/
      DATA (KB(JT,16, 3),JT=1,5) /
     &1.8293E-02,1.4393E-02,1.2369E-02,1.1568E-02,1.2855E-02/
      DATA (KB(JT,17, 3),JT=1,5) /
     &1.3004E-02,1.0838E-02,9.6882E-03,1.0818E-02,1.1950E-02/
      DATA (KB(JT,18, 3),JT=1,5) /
     &9.6007E-03,8.2004E-03,9.1048E-03,1.0148E-02,1.0662E-02/
      DATA (KB(JT,19, 3),JT=1,5) /
     &7.2730E-03,7.5847E-03,8.4339E-03,9.0734E-03,9.2118E-03/
      DATA (KB(JT,20, 3),JT=1,5) /
     &5.9400E-03,6.7100E-03,7.4249E-03,7.7409E-03,7.7182E-03/
      DATA (KB(JT,21, 3),JT=1,5) /
     &5.2740E-03,5.8871E-03,6.3746E-03,6.4908E-03,6.3895E-03/
      DATA (KB(JT,22, 3),JT=1,5) /
     &4.5973E-03,5.1329E-03,5.3865E-03,5.3473E-03,5.2488E-03/
      DATA (KB(JT,23, 3),JT=1,5) /
     &4.0216E-03,4.3958E-03,4.5011E-03,4.3919E-03,4.3384E-03/
      DATA (KB(JT,24, 3),JT=1,5) /
     &3.5050E-03,3.6950E-03,3.6848E-03,3.6232E-03,3.5889E-03/
      DATA (KB(JT,25, 3),JT=1,5) /
     &3.0079E-03,3.0947E-03,3.0321E-03,2.9863E-03,2.9569E-03/
      DATA (KB(JT,26, 3),JT=1,5) /
     &2.5223E-03,2.5389E-03,2.4899E-03,2.4616E-03,2.4119E-03/
      DATA (KB(JT,27, 3),JT=1,5) /
     &2.0904E-03,2.0720E-03,2.0405E-03,2.0263E-03,1.9704E-03/
      DATA (KB(JT,28, 3),JT=1,5) /
     &1.7240E-03,1.6892E-03,1.6695E-03,1.6561E-03,1.6055E-03/
      DATA (KB(JT,29, 3),JT=1,5) /
     &1.4068E-03,1.3720E-03,1.3607E-03,1.3422E-03,1.3070E-03/
      DATA (KB(JT,30, 3),JT=1,5) /
     &1.1328E-03,1.1145E-03,1.1117E-03,1.0886E-03,1.0628E-03/
      DATA (KB(JT,31, 3),JT=1,5) /
     &9.1589E-04,9.0415E-04,9.0310E-04,8.8069E-04,8.6082E-04/
      DATA (KB(JT,32, 3),JT=1,5) /
     &7.4268E-04,7.3425E-04,7.3091E-04,7.1193E-04,7.0016E-04/
      DATA (KB(JT,33, 3),JT=1,5) /
     &5.9881E-04,5.9536E-04,5.8909E-04,5.7513E-04,5.6984E-04/
      DATA (KB(JT,34, 3),JT=1,5) /
     &4.8522E-04,4.8326E-04,4.7702E-04,4.6806E-04,4.6482E-04/
      DATA (KB(JT,35, 3),JT=1,5) /
     &3.9408E-04,3.9282E-04,3.8758E-04,3.8191E-04,3.7951E-04/
      DATA (KB(JT,36, 3),JT=1,5) /
     &3.2090E-04,3.1998E-04,3.1651E-04,3.1185E-04,3.1064E-04/
      DATA (KB(JT,37, 3),JT=1,5) /
     &2.6225E-04,2.6215E-04,2.6078E-04,2.5651E-04,2.5549E-04/
      DATA (KB(JT,38, 3),JT=1,5) /
     &2.1480E-04,2.1472E-04,2.1476E-04,2.1116E-04,2.0969E-04/
      DATA (KB(JT,39, 3),JT=1,5) /
     &1.7555E-04,1.7537E-04,1.7598E-04,1.7350E-04,1.7249E-04/
      DATA (KB(JT,40, 3),JT=1,5) /
     &1.4506E-04,1.4338E-04,1.4427E-04,1.4359E-04,1.4195E-04/
      DATA (KB(JT,41, 3),JT=1,5) /
     &1.1753E-04,1.1789E-04,1.1842E-04,1.1899E-04,1.1706E-04/
      DATA (KB(JT,42, 3),JT=1,5) /
     &9.4811E-05,9.6651E-05,9.6909E-05,9.7780E-05,9.6573E-05/
      DATA (KB(JT,43, 3),JT=1,5) /
     &7.5161E-05,7.9489E-05,7.9256E-05,8.0096E-05,8.0065E-05/
      DATA (KB(JT,44, 3),JT=1,5) /
     &5.8204E-05,6.3635E-05,6.5251E-05,6.5174E-05,6.6162E-05/
      DATA (KB(JT,45, 3),JT=1,5) /
     &4.3809E-05,5.0393E-05,5.3351E-05,5.3552E-05,5.3892E-05/
      DATA (KB(JT,46, 3),JT=1,5) /
     &3.2980E-05,3.7988E-05,4.2459E-05,4.3951E-05,4.3847E-05/
      DATA (KB(JT,47, 3),JT=1,5) /
     &2.7646E-05,2.8723E-05,3.2811E-05,3.5391E-05,3.6137E-05/
      DATA (KB(JT,48, 3),JT=1,5) /
     &2.4543E-05,2.1924E-05,2.4598E-05,2.7741E-05,2.9339E-05/
      DATA (KB(JT,49, 3),JT=1,5) /
     &2.2466E-05,1.9218E-05,1.8251E-05,2.0876E-05,2.3032E-05/
      DATA (KB(JT,50, 3),JT=1,5) /
     &2.1181E-05,1.7247E-05,1.5253E-05,1.5927E-05,1.7960E-05/
      DATA (KB(JT,51, 3),JT=1,5) /
     &2.0829E-05,1.5682E-05,1.3335E-05,1.2152E-05,1.3683E-05/
      DATA (KB(JT,52, 3),JT=1,5) /
     &2.0195E-05,1.5008E-05,1.2032E-05,1.0543E-05,1.0211E-05/
      DATA (KB(JT,53, 3),JT=1,5) /
     &1.9323E-05,1.4642E-05,1.1065E-05,9.3359E-06,8.4701E-06/
      DATA (KB(JT,54, 3),JT=1,5) /
     &1.7666E-05,1.4231E-05,1.0596E-05,8.3241E-06,7.3928E-06/
      DATA (KB(JT,55, 3),JT=1,5) /
     &1.5462E-05,1.3265E-05,1.0248E-05,7.8075E-06,6.5230E-06/
      DATA (KB(JT,56, 3),JT=1,5) /
     &1.3370E-05,1.2106E-05,9.7995E-06,7.4236E-06,5.8878E-06/
      DATA (KB(JT,57, 3),JT=1,5) /
     &1.1515E-05,1.0653E-05,9.2073E-06,7.1981E-06,5.4819E-06/
      DATA (KB(JT,58, 3),JT=1,5) /
     &1.0034E-05,9.2814E-06,8.4358E-06,6.8772E-06,5.2130E-06/
      DATA (KB(JT,59, 3),JT=1,5) /
     &8.4460E-06,7.8198E-06,7.3452E-06,6.2331E-06,4.7237E-06/
      DATA (KB(JT,13, 4),JT=1,5) /
     &3.3587E-02,4.0386E-02,4.5135E-02,4.6401E-02,4.5805E-02/
      DATA (KB(JT,14, 4),JT=1,5) /
     &3.1030E-02,3.6513E-02,3.9636E-02,3.9291E-02,3.8805E-02/
      DATA (KB(JT,15, 4),JT=1,5) /
     &2.9952E-02,3.3504E-02,3.3526E-02,3.3527E-02,3.2785E-02/
      DATA (KB(JT,16, 4),JT=1,5) /
     &2.7625E-02,2.8337E-02,2.8532E-02,2.8121E-02,2.7038E-02/
      DATA (KB(JT,17, 4),JT=1,5) /
     &2.3797E-02,2.4231E-02,2.3927E-02,2.3137E-02,2.2675E-02/
      DATA (KB(JT,18, 4),JT=1,5) /
     &2.0364E-02,2.0218E-02,1.9689E-02,1.9353E-02,1.9321E-02/
      DATA (KB(JT,19, 4),JT=1,5) /
     &1.7135E-02,1.6671E-02,1.6414E-02,1.6325E-02,1.6362E-02/
      DATA (KB(JT,20, 4),JT=1,5) /
     &1.4048E-02,1.3836E-02,1.3650E-02,1.3725E-02,1.3743E-02/
      DATA (KB(JT,21, 4),JT=1,5) /
     &1.1598E-02,1.1451E-02,1.1386E-02,1.1434E-02,1.1536E-02/
      DATA (KB(JT,22, 4),JT=1,5) /
     &9.5671E-03,9.4431E-03,9.4962E-03,9.5565E-03,9.6638E-03/
      DATA (KB(JT,23, 4),JT=1,5) /
     &7.8733E-03,7.8272E-03,7.8608E-03,8.0045E-03,8.0429E-03/
      DATA (KB(JT,24, 4),JT=1,5) /
     &6.4854E-03,6.5239E-03,6.5932E-03,6.6847E-03,6.6897E-03/
      DATA (KB(JT,25, 4),JT=1,5) /
     &5.3475E-03,5.3959E-03,5.5055E-03,5.5513E-03,5.5516E-03/
      DATA (KB(JT,26, 4),JT=1,5) /
     &4.4370E-03,4.4984E-03,4.5821E-03,4.5978E-03,4.6194E-03/
      DATA (KB(JT,27, 4),JT=1,5) /
     &3.6654E-03,3.7378E-03,3.7830E-03,3.7897E-03,3.8209E-03/
      DATA (KB(JT,28, 4),JT=1,5) /
     &3.0135E-03,3.0852E-03,3.1155E-03,3.1198E-03,3.1538E-03/
      DATA (KB(JT,29, 4),JT=1,5) /
     &2.4690E-03,2.5299E-03,2.5457E-03,2.5581E-03,2.5884E-03/
      DATA (KB(JT,30, 4),JT=1,5) /
     &2.0282E-03,2.0645E-03,2.0716E-03,2.0943E-03,2.1183E-03/
      DATA (KB(JT,31, 4),JT=1,5) /
     &1.6532E-03,1.6753E-03,1.6810E-03,1.7064E-03,1.7271E-03/
      DATA (KB(JT,32, 4),JT=1,5) /
     &1.3440E-03,1.3610E-03,1.3688E-03,1.3929E-03,1.4080E-03/
      DATA (KB(JT,33, 4),JT=1,5) /
     &1.0937E-03,1.1058E-03,1.1183E-03,1.1384E-03,1.1495E-03/
      DATA (KB(JT,34, 4),JT=1,5) /
     &8.9328E-04,9.0340E-04,9.1730E-04,9.3209E-04,9.4284E-04/
      DATA (KB(JT,35, 4),JT=1,5) /
     &7.2895E-04,7.3894E-04,7.5120E-04,7.6322E-04,7.7389E-04/
      DATA (KB(JT,36, 4),JT=1,5) /
     &5.9465E-04,6.0388E-04,6.1360E-04,6.2477E-04,6.3446E-04/
      DATA (KB(JT,37, 4),JT=1,5) /
     &4.8509E-04,4.9426E-04,5.0234E-04,5.1316E-04,5.2248E-04/
      DATA (KB(JT,38, 4),JT=1,5) /
     &3.9518E-04,4.0486E-04,4.1118E-04,4.2126E-04,4.3035E-04/
      DATA (KB(JT,39, 4),JT=1,5) /
     &3.2206E-04,3.3126E-04,3.3692E-04,3.4570E-04,3.5386E-04/
      DATA (KB(JT,40, 4),JT=1,5) /
     &2.6189E-04,2.7140E-04,2.7744E-04,2.8454E-04,2.9309E-04/
      DATA (KB(JT,41, 4),JT=1,5) /
     &2.1513E-04,2.2151E-04,2.2843E-04,2.3405E-04,2.4235E-04/
      DATA (KB(JT,42, 4),JT=1,5) /
     &1.7598E-04,1.8130E-04,1.8775E-04,1.9283E-04,2.0002E-04/
      DATA (KB(JT,43, 4),JT=1,5) /
     &1.4391E-04,1.4742E-04,1.5366E-04,1.5883E-04,1.6416E-04/
      DATA (KB(JT,44, 4),JT=1,5) /
     &1.1869E-04,1.2058E-04,1.2494E-04,1.3042E-04,1.3475E-04/
      DATA (KB(JT,45, 4),JT=1,5) /
     &9.8053E-05,9.8247E-05,1.0155E-04,1.0624E-04,1.1079E-04/
      DATA (KB(JT,46, 4),JT=1,5) /
     &8.0733E-05,8.0988E-05,8.2961E-05,8.6570E-05,9.0733E-05/
      DATA (KB(JT,47, 4),JT=1,5) /
     &6.6646E-05,6.6793E-05,6.7614E-05,7.0248E-05,7.3658E-05/
      DATA (KB(JT,48, 4),JT=1,5) /
     &5.5124E-05,5.5074E-05,5.5667E-05,5.7150E-05,5.9800E-05/
      DATA (KB(JT,49, 4),JT=1,5) /
     &4.4694E-05,4.5221E-05,4.5769E-05,4.6677E-05,4.8625E-05/
      DATA (KB(JT,50, 4),JT=1,5) /
     &3.5617E-05,3.7343E-05,3.7522E-05,3.8384E-05,3.9484E-05/
      DATA (KB(JT,51, 4),JT=1,5) /
     &2.7917E-05,3.0153E-05,3.0833E-05,3.1535E-05,3.2403E-05/
      DATA (KB(JT,52, 4),JT=1,5) /
     &2.1904E-05,2.3837E-05,2.5410E-05,2.5925E-05,2.6605E-05/
      DATA (KB(JT,53, 4),JT=1,5) /
     &1.6636E-05,1.9086E-05,2.0539E-05,2.1236E-05,2.1831E-05/
      DATA (KB(JT,54, 4),JT=1,5) /
     &1.2490E-05,1.4743E-05,1.6336E-05,1.7546E-05,1.7865E-05/
      DATA (KB(JT,55, 4),JT=1,5) /
     &1.0189E-05,1.1568E-05,1.3196E-05,1.4286E-05,1.4740E-05/
      DATA (KB(JT,56, 4),JT=1,5) /
     &9.0688E-06,8.6690E-06,1.0255E-05,1.1493E-05,1.2371E-05/
      DATA (KB(JT,57, 4),JT=1,5) /
     &8.8593E-06,6.9758E-06,8.0033E-06,9.3145E-06,1.0058E-05/
      DATA (KB(JT,58, 4),JT=1,5) /
     &8.9813E-06,6.2718E-06,5.9506E-06,7.1169E-06,8.0866E-06/
      DATA (KB(JT,59, 4),JT=1,5) /
     &8.3077E-06,5.6478E-06,4.7582E-06,5.5908E-06,6.6051E-06/
      DATA (KB(JT,13, 5),JT=1,5) /
     &8.1443E-02,7.8686E-02,7.8076E-02,7.8298E-02,8.0221E-02/
      DATA (KB(JT,14, 5),JT=1,5) /
     &6.8138E-02,6.7426E-02,6.7266E-02,6.8778E-02,7.0029E-02/
      DATA (KB(JT,15, 5),JT=1,5) /
     &5.7566E-02,5.8181E-02,6.0037E-02,6.1077E-02,6.2170E-02/
      DATA (KB(JT,16, 5),JT=1,5) /
     &4.9602E-02,5.1862E-02,5.2830E-02,5.3796E-02,5.4837E-02/
      DATA (KB(JT,17, 5),JT=1,5) /
     &4.4316E-02,4.5504E-02,4.6554E-02,4.7427E-02,4.7730E-02/
      DATA (KB(JT,18, 5),JT=1,5) /
     &3.9127E-02,4.0270E-02,4.1019E-02,4.1264E-02,4.1372E-02/
      DATA (KB(JT,19, 5),JT=1,5) /
     &3.4464E-02,3.5381E-02,3.5731E-02,3.5860E-02,3.6031E-02/
      DATA (KB(JT,20, 5),JT=1,5) /
     &2.9866E-02,3.0433E-02,3.0697E-02,3.0719E-02,3.0767E-02/
      DATA (KB(JT,21, 5),JT=1,5) /
     &2.5526E-02,2.5898E-02,2.6044E-02,2.5989E-02,2.5913E-02/
      DATA (KB(JT,22, 5),JT=1,5) /
     &2.1617E-02,2.1821E-02,2.1825E-02,2.1764E-02,2.1636E-02/
      DATA (KB(JT,23, 5),JT=1,5) /
     &1.8178E-02,1.8256E-02,1.8221E-02,1.8126E-02,1.8025E-02/
      DATA (KB(JT,24, 5),JT=1,5) /
     &1.5221E-02,1.5229E-02,1.5185E-02,1.5079E-02,1.4988E-02/
      DATA (KB(JT,25, 5),JT=1,5) /
     &1.2672E-02,1.2670E-02,1.2609E-02,1.2518E-02,1.2439E-02/
      DATA (KB(JT,26, 5),JT=1,5) /
     &1.0521E-02,1.0503E-02,1.0444E-02,1.0375E-02,1.0305E-02/
      DATA (KB(JT,27, 5),JT=1,5) /
     &8.6769E-03,8.6518E-03,8.6102E-03,8.5574E-03,8.4970E-03/
      DATA (KB(JT,28, 5),JT=1,5) /
     &7.1348E-03,7.1122E-03,7.0812E-03,7.0380E-03,6.9899E-03/
      DATA (KB(JT,29, 5),JT=1,5) /
     &5.8206E-03,5.8023E-03,5.7788E-03,5.7535E-03,5.7174E-03/
      DATA (KB(JT,30, 5),JT=1,5) /
     &4.7381E-03,4.7263E-03,4.7093E-03,4.6856E-03,4.6651E-03/
      DATA (KB(JT,31, 5),JT=1,5) /
     &3.8310E-03,3.8249E-03,3.8179E-03,3.8007E-03,3.7880E-03/
      DATA (KB(JT,32, 5),JT=1,5) /
     &3.1058E-03,3.1004E-03,3.0969E-03,3.0876E-03,3.0842E-03/
      DATA (KB(JT,33, 5),JT=1,5) /
     &2.5170E-03,2.5165E-03,2.5146E-03,2.5120E-03,2.5162E-03/
      DATA (KB(JT,34, 5),JT=1,5) /
     &2.0509E-03,2.0525E-03,2.0528E-03,2.0549E-03,2.0638E-03/
      DATA (KB(JT,35, 5),JT=1,5) /
     &1.6738E-03,1.6767E-03,1.6787E-03,1.6855E-03,1.6962E-03/
      DATA (KB(JT,36, 5),JT=1,5) /
     &1.3688E-03,1.3726E-03,1.3769E-03,1.3854E-03,1.3974E-03/
      DATA (KB(JT,37, 5),JT=1,5) /
     &1.1244E-03,1.1287E-03,1.1344E-03,1.1436E-03,1.1555E-03/
      DATA (KB(JT,38, 5),JT=1,5) /
     &9.2354E-04,9.2789E-04,9.3393E-04,9.4440E-04,9.5553E-04/
      DATA (KB(JT,39, 5),JT=1,5) /
     &7.5825E-04,7.6213E-04,7.6943E-04,7.7957E-04,7.9082E-04/
      DATA (KB(JT,40, 5),JT=1,5) /
     &6.2483E-04,6.2933E-04,6.3674E-04,6.4631E-04,6.5698E-04/
      DATA (KB(JT,41, 5),JT=1,5) /
     &5.1520E-04,5.2035E-04,5.2751E-04,5.3662E-04,5.4646E-04/
      DATA (KB(JT,42, 5),JT=1,5) /
     &4.2480E-04,4.3031E-04,4.3691E-04,4.4575E-04,4.5526E-04/
      DATA (KB(JT,43, 5),JT=1,5) /
     &3.5001E-04,3.5557E-04,3.6220E-04,3.7053E-04,3.7981E-04/
      DATA (KB(JT,44, 5),JT=1,5) /
     &2.8750E-04,2.9363E-04,3.0042E-04,3.0784E-04,3.1671E-04/
      DATA (KB(JT,45, 5),JT=1,5) /
     &2.3558E-04,2.4233E-04,2.4882E-04,2.5588E-04,2.6409E-04/
      DATA (KB(JT,46, 5),JT=1,5) /
     &1.9252E-04,1.9920E-04,2.0547E-04,2.1209E-04,2.1984E-04/
      DATA (KB(JT,47, 5),JT=1,5) /
     &1.5646E-04,1.6321E-04,1.6931E-04,1.7555E-04,1.8250E-04/
      DATA (KB(JT,48, 5),JT=1,5) /
     &1.2570E-04,1.3295E-04,1.3900E-04,1.4479E-04,1.5118E-04/
      DATA (KB(JT,49, 5),JT=1,5) /
     &1.0046E-04,1.0778E-04,1.1356E-04,1.1908E-04,1.2499E-04/
      DATA (KB(JT,50, 5),JT=1,5) /
     &8.0435E-05,8.6489E-05,9.2769E-05,9.7911E-05,1.0325E-04/
      DATA (KB(JT,51, 5),JT=1,5) /
     &6.3458E-05,6.9460E-05,7.5498E-05,8.0303E-05,8.5194E-05/
      DATA (KB(JT,52, 5),JT=1,5) /
     &4.9865E-05,5.5730E-05,6.0501E-05,6.5586E-05,7.0113E-05/
      DATA (KB(JT,53, 5),JT=1,5) /
     &3.9952E-05,4.3532E-05,4.8481E-05,5.3147E-05,5.7399E-05/
      DATA (KB(JT,54, 5),JT=1,5) /
     &3.2880E-05,3.4587E-05,3.8794E-05,4.2722E-05,4.7074E-05/
      DATA (KB(JT,55, 5),JT=1,5) /
     &2.7120E-05,2.7717E-05,3.0553E-05,3.4428E-05,3.8350E-05/
      DATA (KB(JT,56, 5),JT=1,5) /
     &2.2127E-05,2.2850E-05,2.4431E-05,2.7545E-05,3.0669E-05/
      DATA (KB(JT,57, 5),JT=1,5) /
     &1.8252E-05,1.8866E-05,1.9461E-05,2.1577E-05,2.4721E-05/
      DATA (KB(JT,58, 5),JT=1,5) /
     &1.4337E-05,1.5384E-05,1.6084E-05,1.7424E-05,1.9750E-05/
      DATA (KB(JT,59, 5),JT=1,5) /
     &1.1278E-05,1.2651E-05,1.3368E-05,1.4398E-05,1.6235E-05/
      DATA (KB(JT,13, 6),JT=1,5) /
     &1.8817E-01,1.9206E-01,1.9341E-01,1.9316E-01,1.9216E-01/
      DATA (KB(JT,14, 6),JT=1,5) /
     &1.5839E-01,1.6013E-01,1.6098E-01,1.6083E-01,1.6026E-01/
      DATA (KB(JT,15, 6),JT=1,5) /
     &1.3908E-01,1.4022E-01,1.4029E-01,1.3949E-01,1.3862E-01/
      DATA (KB(JT,16, 6),JT=1,5) /
     &1.2016E-01,1.2041E-01,1.1995E-01,1.1931E-01,1.1861E-01/
      DATA (KB(JT,17, 6),JT=1,5) /
     &1.0302E-01,1.0297E-01,1.0263E-01,1.0230E-01,1.0181E-01/
      DATA (KB(JT,18, 6),JT=1,5) /
     &8.8231E-02,8.8161E-02,8.7913E-02,8.7602E-02,8.7188E-02/
      DATA (KB(JT,19, 6),JT=1,5) /
     &7.6358E-02,7.6259E-02,7.5975E-02,7.5746E-02,7.5236E-02/
      DATA (KB(JT,20, 6),JT=1,5) /
     &6.5716E-02,6.5541E-02,6.5322E-02,6.5232E-02,6.4993E-02/
      DATA (KB(JT,21, 6),JT=1,5) /
     &5.5986E-02,5.5897E-02,5.5927E-02,5.6065E-02,5.6062E-02/
      DATA (KB(JT,22, 6),JT=1,5) /
     &4.7367E-02,4.7462E-02,4.7736E-02,4.7820E-02,4.7753E-02/
      DATA (KB(JT,23, 6),JT=1,5) /
     &4.0099E-02,4.0361E-02,4.0481E-02,4.0442E-02,4.0254E-02/
      DATA (KB(JT,24, 6),JT=1,5) /
     &3.3998E-02,3.4135E-02,3.4123E-02,3.4025E-02,3.3829E-02/
      DATA (KB(JT,25, 6),JT=1,5) /
     &2.8658E-02,2.8658E-02,2.8582E-02,2.8475E-02,2.8305E-02/
      DATA (KB(JT,26, 6),JT=1,5) /
     &2.3955E-02,2.3909E-02,2.3836E-02,2.3748E-02,2.3606E-02/
      DATA (KB(JT,27, 6),JT=1,5) /
     &1.9889E-02,1.9852E-02,1.9780E-02,1.9709E-02,1.9615E-02/
      DATA (KB(JT,28, 6),JT=1,5) /
     &1.6444E-02,1.6406E-02,1.6372E-02,1.6318E-02,1.6245E-02/
      DATA (KB(JT,29, 6),JT=1,5) /
     &1.3491E-02,1.3473E-02,1.3456E-02,1.3404E-02,1.3356E-02/
      DATA (KB(JT,30, 6),JT=1,5) /
     &1.1049E-02,1.1039E-02,1.1036E-02,1.1011E-02,1.0973E-02/
      DATA (KB(JT,31, 6),JT=1,5) /
     &9.0143E-03,9.0192E-03,9.0194E-03,9.0134E-03,9.0031E-03/
      DATA (KB(JT,32, 6),JT=1,5) /
     &7.3665E-03,7.3853E-03,7.3885E-03,7.3955E-03,7.4067E-03/
      DATA (KB(JT,33, 6),JT=1,5) /
     &6.0271E-03,6.0462E-03,6.0622E-03,6.0836E-03,6.1045E-03/
      DATA (KB(JT,34, 6),JT=1,5) /
     &4.9546E-03,4.9811E-03,5.0047E-03,5.0339E-03,5.0627E-03/
      DATA (KB(JT,35, 6),JT=1,5) /
     &4.0822E-03,4.1121E-03,4.1424E-03,4.1730E-03,4.2061E-03/
      DATA (KB(JT,36, 6),JT=1,5) /
     &3.3681E-03,3.3993E-03,3.4334E-03,3.4635E-03,3.4987E-03/
      DATA (KB(JT,37, 6),JT=1,5) /
     &2.7875E-03,2.8195E-03,2.8505E-03,2.8836E-03,2.9180E-03/
      DATA (KB(JT,38, 6),JT=1,5) /
     &2.3080E-03,2.3382E-03,2.3688E-03,2.3992E-03,2.4337E-03/
      DATA (KB(JT,39, 6),JT=1,5) /
     &1.9086E-03,1.9391E-03,1.9678E-03,1.9967E-03,2.0294E-03/
      DATA (KB(JT,40, 6),JT=1,5) /
     &1.5841E-03,1.6128E-03,1.6390E-03,1.6667E-03,1.6980E-03/
      DATA (KB(JT,41, 6),JT=1,5) /
     &1.3139E-03,1.3408E-03,1.3651E-03,1.3913E-03,1.4213E-03/
      DATA (KB(JT,42, 6),JT=1,5) /
     &1.0897E-03,1.1135E-03,1.1369E-03,1.1616E-03,1.1887E-03/
      DATA (KB(JT,43, 6),JT=1,5) /
     &9.0311E-04,9.2481E-04,9.4572E-04,9.6914E-04,9.9399E-04/
      DATA (KB(JT,44, 6),JT=1,5) /
     &7.4776E-04,7.6718E-04,7.8637E-04,8.0787E-04,8.3044E-04/
      DATA (KB(JT,45, 6),JT=1,5) /
     &6.1863E-04,6.3626E-04,6.5392E-04,6.7285E-04,6.9425E-04/
      DATA (KB(JT,46, 6),JT=1,5) /
     &5.1188E-04,5.2759E-04,5.4354E-04,5.6054E-04,5.8050E-04/
      DATA (KB(JT,47, 6),JT=1,5) /
     &4.2255E-04,4.3715E-04,4.5173E-04,4.6695E-04,4.8462E-04/
      DATA (KB(JT,48, 6),JT=1,5) /
     &3.4819E-04,3.6156E-04,3.7458E-04,3.8864E-04,4.0475E-04/
      DATA (KB(JT,49, 6),JT=1,5) /
     &2.8602E-04,2.9814E-04,3.1015E-04,3.2283E-04,3.3769E-04/
      DATA (KB(JT,50, 6),JT=1,5) /
     &2.3475E-04,2.4603E-04,2.5676E-04,2.6851E-04,2.8207E-04/
      DATA (KB(JT,51, 6),JT=1,5) /
     &1.9267E-04,2.0293E-04,2.1257E-04,2.2327E-04,2.3584E-04/
      DATA (KB(JT,52, 6),JT=1,5) /
     &1.5736E-04,1.6664E-04,1.7558E-04,1.8519E-04,1.9650E-04/
      DATA (KB(JT,53, 6),JT=1,5) /
     &1.2741E-04,1.3627E-04,1.4450E-04,1.5309E-04,1.6331E-04/
      DATA (KB(JT,54, 6),JT=1,5) /
     &1.0368E-04,1.1186E-04,1.1942E-04,1.2720E-04,1.3642E-04/
      DATA (KB(JT,55, 6),JT=1,5) /
     &8.4018E-05,9.1900E-05,9.8814E-05,1.0595E-04,1.1419E-04/
      DATA (KB(JT,56, 6),JT=1,5) /
     &6.7644E-05,7.5107E-05,8.1537E-05,8.8130E-05,9.5553E-05/
      DATA (KB(JT,57, 6),JT=1,5) /
     &5.3052E-05,6.0800E-05,6.7049E-05,7.3153E-05,7.9865E-05/
      DATA (KB(JT,58, 6),JT=1,5) /
     &4.1297E-05,4.9020E-05,5.4922E-05,6.0589E-05,6.6753E-05/
      DATA (KB(JT,59, 6),JT=1,5) /
     &3.4006E-05,4.0647E-05,4.6127E-05,5.1418E-05,5.7293E-05/
      DATA (KB(JT,13, 7),JT=1,5) /
     &5.2204E-01,5.1758E-01,5.1182E-01,5.0530E-01,4.9787E-01/
      DATA (KB(JT,14, 7),JT=1,5) /
     &4.3225E-01,4.2797E-01,4.2283E-01,4.1695E-01,4.1054E-01/
      DATA (KB(JT,15, 7),JT=1,5) /
     &3.5438E-01,3.5034E-01,3.4544E-01,3.4060E-01,3.3555E-01/
      DATA (KB(JT,16, 7),JT=1,5) /
     &3.0255E-01,2.9825E-01,2.9421E-01,2.8975E-01,2.8561E-01/
      DATA (KB(JT,17, 7),JT=1,5) /
     &2.5944E-01,2.5596E-01,2.5201E-01,2.4828E-01,2.4466E-01/
      DATA (KB(JT,18, 7),JT=1,5) /
     &2.2110E-01,2.1760E-01,2.1435E-01,2.1143E-01,2.0904E-01/
      DATA (KB(JT,19, 7),JT=1,5) /
     &1.8864E-01,1.8589E-01,1.8343E-01,1.8143E-01,1.7990E-01/
      DATA (KB(JT,20, 7),JT=1,5) /
     &1.6121E-01,1.5932E-01,1.5784E-01,1.5634E-01,1.5506E-01/
      DATA (KB(JT,21, 7),JT=1,5) /
     &1.3878E-01,1.3751E-01,1.3632E-01,1.3482E-01,1.3362E-01/
      DATA (KB(JT,22, 7),JT=1,5) /
     &1.1962E-01,1.1845E-01,1.1744E-01,1.1632E-01,1.1539E-01/
      DATA (KB(JT,23, 7),JT=1,5) /
     &1.0245E-01,1.0173E-01,1.0097E-01,1.0038E-01,9.9933E-02/
      DATA (KB(JT,24, 7),JT=1,5) /
     &8.7666E-02,8.7158E-02,8.6968E-02,8.6971E-02,8.7255E-02/
      DATA (KB(JT,25, 7),JT=1,5) /
     &7.4640E-02,7.4734E-02,7.5053E-02,7.5269E-02,7.5390E-02/
      DATA (KB(JT,26, 7),JT=1,5) /
     &6.3735E-02,6.4061E-02,6.4333E-02,6.4421E-02,6.4368E-02/
      DATA (KB(JT,27, 7),JT=1,5) /
     &5.4126E-02,5.4429E-02,5.4564E-02,5.4521E-02,5.4525E-02/
      DATA (KB(JT,28, 7),JT=1,5) /
     &4.5724E-02,4.5897E-02,4.5948E-02,4.5981E-02,4.6016E-02/
      DATA (KB(JT,29, 7),JT=1,5) /
     &3.8172E-02,3.8308E-02,3.8382E-02,3.8489E-02,3.8585E-02/
      DATA (KB(JT,30, 7),JT=1,5) /
     &3.1718E-02,3.1883E-02,3.2020E-02,3.2173E-02,3.2316E-02/
      DATA (KB(JT,31, 7),JT=1,5) /
     &2.6252E-02,2.6436E-02,2.6597E-02,2.6780E-02,2.6950E-02/
      DATA (KB(JT,32, 7),JT=1,5) /
     &2.1754E-02,2.1941E-02,2.2153E-02,2.2326E-02,2.2517E-02/
      DATA (KB(JT,33, 7),JT=1,5) /
     &1.8085E-02,1.8277E-02,1.8461E-02,1.8652E-02,1.8849E-02/
      DATA (KB(JT,34, 7),JT=1,5) /
     &1.5122E-02,1.5298E-02,1.5478E-02,1.5652E-02,1.5844E-02/
      DATA (KB(JT,35, 7),JT=1,5) /
     &1.2625E-02,1.2802E-02,1.2974E-02,1.3152E-02,1.3333E-02/
      DATA (KB(JT,36, 7),JT=1,5) /
     &1.0557E-02,1.0724E-02,1.0878E-02,1.1051E-02,1.1225E-02/
      DATA (KB(JT,37, 7),JT=1,5) /
     &8.8496E-03,9.0081E-03,9.1627E-03,9.3269E-03,9.4871E-03/
      DATA (KB(JT,38, 7),JT=1,5) /
     &7.4071E-03,7.5543E-03,7.6993E-03,7.8541E-03,8.0170E-03/
      DATA (KB(JT,39, 7),JT=1,5) /
     &6.1854E-03,6.3247E-03,6.4677E-03,6.6094E-03,6.7526E-03/
      DATA (KB(JT,40, 7),JT=1,5) /
     &5.1922E-03,5.3234E-03,5.4554E-03,5.5916E-03,5.7266E-03/
      DATA (KB(JT,41, 7),JT=1,5) /
     &4.3585E-03,4.4819E-03,4.6086E-03,4.7343E-03,4.8561E-03/
      DATA (KB(JT,42, 7),JT=1,5) /
     &3.6533E-03,3.7711E-03,3.8861E-03,3.9990E-03,4.1168E-03/
      DATA (KB(JT,43, 7),JT=1,5) /
     &3.0584E-03,3.1667E-03,3.2727E-03,3.3777E-03,3.4881E-03/
      DATA (KB(JT,44, 7),JT=1,5) /
     &2.5534E-03,2.6526E-03,2.7492E-03,2.8491E-03,2.9548E-03/
      DATA (KB(JT,45, 7),JT=1,5) /
     &2.1284E-03,2.2160E-03,2.3074E-03,2.3986E-03,2.4950E-03/
      DATA (KB(JT,46, 7),JT=1,5) /
     &1.7695E-03,1.8482E-03,1.9316E-03,2.0146E-03,2.1010E-03/
      DATA (KB(JT,47, 7),JT=1,5) /
     &1.4673E-03,1.5398E-03,1.6138E-03,1.6894E-03,1.7692E-03/
      DATA (KB(JT,48, 7),JT=1,5) /
     &1.2142E-03,1.2798E-03,1.3450E-03,1.4129E-03,1.4833E-03/
      DATA (KB(JT,49, 7),JT=1,5) /
     &1.0007E-03,1.0578E-03,1.1143E-03,1.1757E-03,1.2387E-03/
      DATA (KB(JT,50, 7),JT=1,5) /
     &8.2795E-04,8.7794E-04,9.2798E-04,9.8346E-04,1.0399E-03/
      DATA (KB(JT,51, 7),JT=1,5) /
     &6.8604E-04,7.3011E-04,7.7427E-04,8.2321E-04,8.7374E-04/
      DATA (KB(JT,52, 7),JT=1,5) /
     &5.6660E-04,6.0603E-04,6.4555E-04,6.8763E-04,7.3282E-04/
      DATA (KB(JT,53, 7),JT=1,5) /
     &4.6575E-04,5.0073E-04,5.3612E-04,5.7296E-04,6.1258E-04/
      DATA (KB(JT,54, 7),JT=1,5) /
     &3.8679E-04,4.1843E-04,4.5022E-04,4.8415E-04,5.2013E-04/
      DATA (KB(JT,55, 7),JT=1,5) /
     &3.2310E-04,3.5117E-04,3.8038E-04,4.1226E-04,4.4542E-04/
      DATA (KB(JT,56, 7),JT=1,5) /
     &2.6895E-04,2.9441E-04,3.2135E-04,3.5045E-04,3.8084E-04/
      DATA (KB(JT,57, 7),JT=1,5) /
     &2.2346E-04,2.4644E-04,2.7077E-04,2.9691E-04,3.2529E-04/
      DATA (KB(JT,58, 7),JT=1,5) /
     &1.8566E-04,2.0641E-04,2.2834E-04,2.5256E-04,2.7894E-04/
      DATA (KB(JT,59, 7),JT=1,5) /
     &1.5949E-04,1.7859E-04,1.9903E-04,2.2176E-04,2.4718E-04/
      DATA (KB(JT,13, 8),JT=1,5) /
     &1.7932E+00,1.7598E+00,1.7272E+00,1.6957E+00,1.6643E+00/
      DATA (KB(JT,14, 8),JT=1,5) /
     &1.5024E+00,1.4748E+00,1.4482E+00,1.4213E+00,1.3943E+00/
      DATA (KB(JT,15, 8),JT=1,5) /
     &1.2493E+00,1.2269E+00,1.2042E+00,1.1821E+00,1.1593E+00/
      DATA (KB(JT,16, 8),JT=1,5) /
     &1.0236E+00,1.0050E+00,9.8683E-01,9.6754E-01,9.4805E-01/
      DATA (KB(JT,17, 8),JT=1,5) /
     &8.3764E-01,8.2167E-01,8.0558E-01,7.8848E-01,7.7231E-01/
      DATA (KB(JT,18, 8),JT=1,5) /
     &7.0049E-01,6.8715E-01,6.7310E-01,6.5885E-01,6.4482E-01/
      DATA (KB(JT,19, 8),JT=1,5) /
     &6.0067E-01,5.8909E-01,5.7714E-01,5.6481E-01,5.5329E-01/
      DATA (KB(JT,20, 8),JT=1,5) /
     &5.1436E-01,5.0417E-01,4.9351E-01,4.8348E-01,4.7495E-01/
      DATA (KB(JT,21, 8),JT=1,5) /
     &4.3696E-01,4.2847E-01,4.2014E-01,4.1292E-01,4.0709E-01/
      DATA (KB(JT,22, 8),JT=1,5) /
     &3.7052E-01,3.6397E-01,3.5765E-01,3.5323E-01,3.4919E-01/
      DATA (KB(JT,23, 8),JT=1,5) /
     &3.1534E-01,3.1049E-01,3.0630E-01,3.0316E-01,3.0035E-01/
      DATA (KB(JT,24, 8),JT=1,5) /
     &2.7112E-01,2.6740E-01,2.6459E-01,2.6223E-01,2.5988E-01/
      DATA (KB(JT,25, 8),JT=1,5) /
     &2.3380E-01,2.3133E-01,2.2943E-01,2.2772E-01,2.2653E-01/
      DATA (KB(JT,26, 8),JT=1,5) /
     &2.0236E-01,2.0088E-01,1.9954E-01,1.9878E-01,1.9870E-01/
      DATA (KB(JT,27, 8),JT=1,5) /
     &1.7470E-01,1.7394E-01,1.7356E-01,1.7393E-01,1.7411E-01/
      DATA (KB(JT,28, 8),JT=1,5) /
     &1.5024E-01,1.5047E-01,1.5098E-01,1.5164E-01,1.5243E-01/
      DATA (KB(JT,29, 8),JT=1,5) /
     &1.2816E-01,1.2887E-01,1.2996E-01,1.3066E-01,1.3197E-01/
      DATA (KB(JT,30, 8),JT=1,5) /
     &1.0887E-01,1.0998E-01,1.1099E-01,1.1227E-01,1.1365E-01/
      DATA (KB(JT,31, 8),JT=1,5) /
     &9.1656E-02,9.2754E-02,9.3840E-02,9.5163E-02,9.6499E-02/
      DATA (KB(JT,32, 8),JT=1,5) /
     &7.7165E-02,7.8228E-02,7.9327E-02,8.0584E-02,8.1883E-02/
      DATA (KB(JT,33, 8),JT=1,5) /
     &6.4796E-02,6.5863E-02,6.6915E-02,6.7986E-02,6.9105E-02/
      DATA (KB(JT,34, 8),JT=1,5) /
     &5.4901E-02,5.5964E-02,5.6945E-02,5.8000E-02,5.9045E-02/
      DATA (KB(JT,35, 8),JT=1,5) /
     &4.6607E-02,4.7594E-02,4.8499E-02,4.9452E-02,5.0386E-02/
      DATA (KB(JT,36, 8),JT=1,5) /
     &3.9577E-02,4.0492E-02,4.1341E-02,4.2242E-02,4.3090E-02/
      DATA (KB(JT,37, 8),JT=1,5) /
     &3.3790E-02,3.4662E-02,3.5486E-02,3.6314E-02,3.7168E-02/
      DATA (KB(JT,38, 8),JT=1,5) /
     &2.8754E-02,2.9559E-02,3.0387E-02,3.1137E-02,3.1929E-02/
      DATA (KB(JT,39, 8),JT=1,5) /
     &2.4394E-02,2.5115E-02,2.5838E-02,2.6544E-02,2.7274E-02/
      DATA (KB(JT,40, 8),JT=1,5) /
     &2.0920E-02,2.1659E-02,2.2398E-02,2.3092E-02,2.3784E-02/
      DATA (KB(JT,41, 8),JT=1,5) /
     &1.7960E-02,1.8686E-02,1.9408E-02,2.0118E-02,2.0798E-02/
      DATA (KB(JT,42, 8),JT=1,5) /
     &1.5382E-02,1.6080E-02,1.6764E-02,1.7451E-02,1.8100E-02/
      DATA (KB(JT,43, 8),JT=1,5) /
     &1.3156E-02,1.3822E-02,1.4465E-02,1.5132E-02,1.5767E-02/
      DATA (KB(JT,44, 8),JT=1,5) /
     &1.1236E-02,1.1847E-02,1.2471E-02,1.3074E-02,1.3675E-02/
      DATA (KB(JT,45, 8),JT=1,5) /
     &9.5475E-03,1.0122E-02,1.0686E-02,1.1243E-02,1.1794E-02/
      DATA (KB(JT,46, 8),JT=1,5) /
     &8.0771E-03,8.6018E-03,9.1254E-03,9.6411E-03,1.0156E-02/
      DATA (KB(JT,47, 8),JT=1,5) /
     &6.8185E-03,7.3016E-03,7.7913E-03,8.2730E-03,8.7590E-03/
      DATA (KB(JT,48, 8),JT=1,5) /
     &5.7132E-03,6.1559E-03,6.5990E-03,7.0467E-03,7.5035E-03/
      DATA (KB(JT,49, 8),JT=1,5) /
     &4.7309E-03,5.1282E-03,5.5334E-03,5.9379E-03,6.3413E-03/
      DATA (KB(JT,50, 8),JT=1,5) /
     &3.9545E-03,4.3092E-03,4.6836E-03,5.0555E-03,5.4339E-03/
      DATA (KB(JT,51, 8),JT=1,5) /
     &3.3094E-03,3.6354E-03,3.9810E-03,4.3245E-03,4.6768E-03/
      DATA (KB(JT,52, 8),JT=1,5) /
     &2.7556E-03,3.0488E-03,3.3581E-03,3.6757E-03,3.9978E-03/
      DATA (KB(JT,53, 8),JT=1,5) /
     &2.2741E-03,2.5328E-03,2.8070E-03,3.0901E-03,3.3837E-03/
      DATA (KB(JT,54, 8),JT=1,5) /
     &1.9244E-03,2.1630E-03,2.4199E-03,2.6919E-03,2.9670E-03/
      DATA (KB(JT,55, 8),JT=1,5) /
     &1.6527E-03,1.8750E-03,2.1244E-03,2.3895E-03,2.6621E-03/
      DATA (KB(JT,56, 8),JT=1,5) /
     &1.4187E-03,1.6262E-03,1.8617E-03,2.1120E-03,2.3834E-03/
      DATA (KB(JT,57, 8),JT=1,5) /
     &1.2123E-03,1.4102E-03,1.6308E-03,1.8701E-03,2.1361E-03/
      DATA (KB(JT,58, 8),JT=1,5) /
     &1.0428E-03,1.2269E-03,1.4357E-03,1.6692E-03,1.9342E-03/
      DATA (KB(JT,59, 8),JT=1,5) /
     &9.5774E-04,1.1485E-03,1.3717E-03,1.6313E-03,1.9270E-03/
      DATA (KB(JT,13, 9),JT=1,5) /
     &1.0743E+01,1.0581E+01,1.0416E+01,1.0238E+01,1.0057E+01/
      DATA (KB(JT,14, 9),JT=1,5) /
     &9.3266E+00,9.1890E+00,9.0401E+00,8.8785E+00,8.7093E+00/
      DATA (KB(JT,15, 9),JT=1,5) /
     &8.0329E+00,7.9105E+00,7.7721E+00,7.6225E+00,7.4769E+00/
      DATA (KB(JT,16, 9),JT=1,5) /
     &6.8686E+00,6.7530E+00,6.6275E+00,6.5036E+00,6.3858E+00/
      DATA (KB(JT,17, 9),JT=1,5) /
     &5.8249E+00,5.7232E+00,5.6209E+00,5.5225E+00,5.4281E+00/
      DATA (KB(JT,18, 9),JT=1,5) /
     &4.8929E+00,4.8094E+00,4.7279E+00,4.6483E+00,4.5724E+00/
      DATA (KB(JT,19, 9),JT=1,5) /
     &4.0706E+00,4.0042E+00,3.9380E+00,3.8751E+00,3.8145E+00/
      DATA (KB(JT,20, 9),JT=1,5) /
     &3.3806E+00,3.3267E+00,3.2749E+00,3.2247E+00,3.1746E+00/
      DATA (KB(JT,21, 9),JT=1,5) /
     &2.8074E+00,2.7644E+00,2.7235E+00,2.6821E+00,2.6407E+00/
      DATA (KB(JT,22, 9),JT=1,5) /
     &2.3283E+00,2.2955E+00,2.2616E+00,2.2266E+00,2.1957E+00/
      DATA (KB(JT,23, 9),JT=1,5) /
     &1.9321E+00,1.9042E+00,1.8758E+00,1.8494E+00,1.8261E+00/
      DATA (KB(JT,24, 9),JT=1,5) /
     &1.6234E+00,1.5933E+00,1.5660E+00,1.5420E+00,1.5232E+00/
      DATA (KB(JT,25, 9),JT=1,5) /
     &1.3980E+00,1.3704E+00,1.3436E+00,1.3210E+00,1.3008E+00/
      DATA (KB(JT,26, 9),JT=1,5) /
     &1.2106E+00,1.1883E+00,1.1672E+00,1.1488E+00,1.1330E+00/
      DATA (KB(JT,27, 9),JT=1,5) /
     &1.0466E+00,1.0297E+00,1.0139E+00,1.0016E+00,9.9022E-01/
      DATA (KB(JT,28, 9),JT=1,5) /
     &9.0567E-01,8.9244E-01,8.8275E-01,8.7361E-01,8.6722E-01/
      DATA (KB(JT,29, 9),JT=1,5) /
     &7.7743E-01,7.6923E-01,7.6234E-01,7.5840E-01,7.5702E-01/
      DATA (KB(JT,30, 9),JT=1,5) /
     &6.6693E-01,6.6196E-01,6.5810E-01,6.5663E-01,6.5785E-01/
      DATA (KB(JT,31, 9),JT=1,5) /
     &5.6777E-01,5.6527E-01,5.6420E-01,5.6593E-01,5.6662E-01/
      DATA (KB(JT,32, 9),JT=1,5) /
     &4.8384E-01,4.8324E-01,4.8562E-01,4.8803E-01,4.8996E-01/
      DATA (KB(JT,33, 9),JT=1,5) /
     &4.1137E-01,4.1406E-01,4.1751E-01,4.2081E-01,4.2550E-01/
      DATA (KB(JT,34, 9),JT=1,5) /
     &3.5416E-01,3.5806E-01,3.6166E-01,3.6664E-01,3.7277E-01/
      DATA (KB(JT,35, 9),JT=1,5) /
     &3.0554E-01,3.0948E-01,3.1424E-01,3.1976E-01,3.2676E-01/
      DATA (KB(JT,36, 9),JT=1,5) /
     &2.6418E-01,2.6871E-01,2.7383E-01,2.8027E-01,2.8707E-01/
      DATA (KB(JT,37, 9),JT=1,5) /
     &2.2969E-01,2.3421E-01,2.3975E-01,2.4624E-01,2.5310E-01/
      DATA (KB(JT,38, 9),JT=1,5) /
     &1.9950E-01,2.0421E-01,2.0978E-01,2.1651E-01,2.2302E-01/
      DATA (KB(JT,39, 9),JT=1,5) /
     &1.7282E-01,1.7783E-01,1.8337E-01,1.9005E-01,1.9644E-01/
      DATA (KB(JT,40, 9),JT=1,5) /
     &1.5139E-01,1.5623E-01,1.6190E-01,1.6820E-01,1.7447E-01/
      DATA (KB(JT,41, 9),JT=1,5) /
     &1.3264E-01,1.3745E-01,1.4301E-01,1.4932E-01,1.5546E-01/
      DATA (KB(JT,42, 9),JT=1,5) /
     &1.1607E-01,1.2085E-01,1.2625E-01,1.3247E-01,1.3847E-01/
      DATA (KB(JT,43, 9),JT=1,5) /
     &1.0129E-01,1.0600E-01,1.1131E-01,1.1735E-01,1.2314E-01/
      DATA (KB(JT,44, 9),JT=1,5) /
     &8.8076E-02,9.2672E-02,9.7764E-02,1.0358E-01,1.0942E-01/
      DATA (KB(JT,45, 9),JT=1,5) /
     &7.6267E-02,8.0788E-02,8.5604E-02,9.1124E-02,9.6796E-02/
      DATA (KB(JT,46, 9),JT=1,5) /
     &6.5896E-02,7.0073E-02,7.4628E-02,7.9860E-02,8.5349E-02/
      DATA (KB(JT,47, 9),JT=1,5) /
     &5.6947E-02,6.0912E-02,6.5102E-02,6.9953E-02,7.5324E-02/
      DATA (KB(JT,48, 9),JT=1,5) /
     &4.8993E-02,5.2552E-02,5.6622E-02,6.1050E-02,6.6050E-02/
      DATA (KB(JT,49, 9),JT=1,5) /
     &4.1828E-02,4.5103E-02,4.8726E-02,5.2827E-02,5.7536E-02/
      DATA (KB(JT,50, 9),JT=1,5) /
     &3.6237E-02,3.9173E-02,4.2523E-02,4.6248E-02,5.0679E-02/
      DATA (KB(JT,51, 9),JT=1,5) /
     &3.1483E-02,3.4194E-02,3.7317E-02,4.0792E-02,4.4937E-02/
      DATA (KB(JT,52, 9),JT=1,5) /
     &2.7288E-02,2.9720E-02,3.2635E-02,3.5833E-02,3.9605E-02/
      DATA (KB(JT,53, 9),JT=1,5) /
     &2.3553E-02,2.5752E-02,2.8298E-02,3.1273E-02,3.4805E-02/
      DATA (KB(JT,54, 9),JT=1,5) /
     &2.0927E-02,2.2955E-02,2.5436E-02,2.8294E-02,3.1547E-02/
      DATA (KB(JT,55, 9),JT=1,5) /
     &1.8850E-02,2.0892E-02,2.3245E-02,2.6068E-02,2.9259E-02/
      DATA (KB(JT,56, 9),JT=1,5) /
     &1.7133E-02,1.9134E-02,2.1378E-02,2.4152E-02,2.7278E-02/
      DATA (KB(JT,57, 9),JT=1,5) /
     &1.5614E-02,1.7616E-02,1.9861E-02,2.2450E-02,2.5658E-02/
      DATA (KB(JT,58, 9),JT=1,5) /
     &1.4386E-02,1.6367E-02,1.8612E-02,2.1235E-02,2.4366E-02/
      DATA (KB(JT,59, 9),JT=1,5) /
     &1.4750E-02,1.6838E-02,1.9250E-02,2.2069E-02,2.5653E-02/
      DATA (KB(JT,13,10),JT=1,5) /
     &4.1842E+01,4.1126E+01,4.0474E+01,3.9934E+01,3.9455E+01/
      DATA (KB(JT,14,10),JT=1,5) /
     &3.7817E+01,3.7244E+01,3.6754E+01,3.6387E+01,3.5986E+01/
      DATA (KB(JT,15,10),JT=1,5) /
     &3.3775E+01,3.3359E+01,3.3057E+01,3.2734E+01,3.2346E+01/
      DATA (KB(JT,16,10),JT=1,5) /
     &2.9866E+01,2.9628E+01,2.9352E+01,2.8982E+01,2.8500E+01/
      DATA (KB(JT,17,10),JT=1,5) /
     &2.6256E+01,2.6026E+01,2.5674E+01,2.5248E+01,2.4813E+01/
      DATA (KB(JT,18,10),JT=1,5) /
     &2.2845E+01,2.2539E+01,2.2184E+01,2.1830E+01,2.1506E+01/
      DATA (KB(JT,19,10),JT=1,5) /
     &1.9624E+01,1.9336E+01,1.9054E+01,1.8789E+01,1.8555E+01/
      DATA (KB(JT,20,10),JT=1,5) /
     &1.6714E+01,1.6495E+01,1.6283E+01,1.6088E+01,1.5920E+01/
      DATA (KB(JT,21,10),JT=1,5) /
     &1.4184E+01,1.4023E+01,1.3853E+01,1.3722E+01,1.3615E+01/
      DATA (KB(JT,22,10),JT=1,5) /
     &1.2010E+01,1.1876E+01,1.1769E+01,1.1693E+01,1.1608E+01/
      DATA (KB(JT,23,10),JT=1,5) /
     &1.0140E+01,1.0060E+01,1.0004E+01,9.9480E+00,9.8828E+00/
      DATA (KB(JT,24,10),JT=1,5) /
     &8.3529E+00,8.3955E+00,8.4004E+00,8.3887E+00,8.3750E+00/
      DATA (KB(JT,25,10),JT=1,5) /
     &6.5990E+00,6.6692E+00,6.7250E+00,6.7763E+00,6.8513E+00/
      DATA (KB(JT,26,10),JT=1,5) /
     &5.2218E+00,5.2429E+00,5.2934E+00,5.3672E+00,5.4447E+00/
      DATA (KB(JT,27,10),JT=1,5) /
     &4.4199E+00,4.3564E+00,4.3290E+00,4.3162E+00,4.3878E+00/
      DATA (KB(JT,28,10),JT=1,5) /
     &3.8059E+00,3.7536E+00,3.6821E+00,3.6546E+00,3.6556E+00/
      DATA (KB(JT,29,10),JT=1,5) /
     &3.2943E+00,3.2284E+00,3.1752E+00,3.1401E+00,3.1165E+00/
      DATA (KB(JT,30,10),JT=1,5) /
     &2.8426E+00,2.7881E+00,2.7489E+00,2.7185E+00,2.7182E+00/
      DATA (KB(JT,31,10),JT=1,5) /
     &2.4366E+00,2.4010E+00,2.3877E+00,2.3684E+00,2.4040E+00/
      DATA (KB(JT,32,10),JT=1,5) /
     &2.1031E+00,2.0888E+00,2.0634E+00,2.0885E+00,2.1581E+00/
      DATA (KB(JT,33,10),JT=1,5) /
     &1.8304E+00,1.8104E+00,1.8138E+00,1.8703E+00,1.9665E+00/
      DATA (KB(JT,34,10),JT=1,5) /
     &1.5963E+00,1.5877E+00,1.6209E+00,1.6809E+00,1.8060E+00/
      DATA (KB(JT,35,10),JT=1,5) /
     &1.3950E+00,1.4093E+00,1.4535E+00,1.5372E+00,1.6748E+00/
      DATA (KB(JT,36,10),JT=1,5) /
     &1.2291E+00,1.2517E+00,1.3081E+00,1.4001E+00,1.5466E+00/
      DATA (KB(JT,37,10),JT=1,5) /
     &1.0841E+00,1.1159E+00,1.1678E+00,1.2585E+00,1.4003E+00/
      DATA (KB(JT,38,10),JT=1,5) /
     &9.5502E-01,9.9217E-01,1.0459E+00,1.1387E+00,1.2834E+00/
      DATA (KB(JT,39,10),JT=1,5) /
     &8.4320E-01,8.8008E-01,9.3921E-01,1.0432E+00,1.1899E+00/
      DATA (KB(JT,40,10),JT=1,5) /
     &7.4742E-01,7.8308E-01,8.3378E-01,9.2859E-01,1.0715E+00/
      DATA (KB(JT,41,10),JT=1,5) /
     &6.6607E-01,6.9838E-01,7.4378E-01,8.2580E-01,9.6253E-01/
      DATA (KB(JT,42,10),JT=1,5) /
     &5.9399E-01,6.2402E-01,6.6818E-01,7.3908E-01,8.7040E-01/
      DATA (KB(JT,43,10),JT=1,5) /
     &5.3134E-01,5.5822E-01,5.9679E-01,6.5834E-01,7.8163E-01/
      DATA (KB(JT,44,10),JT=1,5) /
     &4.7483E-01,4.9813E-01,5.3656E-01,5.8775E-01,7.0057E-01/
      DATA (KB(JT,45,10),JT=1,5) /
     &4.2242E-01,4.4383E-01,4.8053E-01,5.2923E-01,6.3377E-01/
      DATA (KB(JT,46,10),JT=1,5) /
     &3.7426E-01,3.9626E-01,4.2998E-01,4.7693E-01,5.7307E-01/
      DATA (KB(JT,47,10),JT=1,5) /
     &3.3305E-01,3.5232E-01,3.8380E-01,4.2680E-01,5.1056E-01/
      DATA (KB(JT,48,10),JT=1,5) /
     &2.9118E-01,3.1195E-01,3.3996E-01,3.8124E-01,4.5847E-01/
      DATA (KB(JT,49,10),JT=1,5) /
     &2.5186E-01,2.7185E-01,2.9957E-01,3.4007E-01,4.1454E-01/
      DATA (KB(JT,50,10),JT=1,5) /
     &2.1978E-01,2.4030E-01,2.6478E-01,3.0486E-01,3.7227E-01/
      DATA (KB(JT,51,10),JT=1,5) /
     &1.9384E-01,2.1260E-01,2.3536E-01,2.7096E-01,3.3311E-01/
      DATA (KB(JT,52,10),JT=1,5) /
     &1.6918E-01,1.8784E-01,2.0901E-01,2.4060E-01,2.9976E-01/
      DATA (KB(JT,53,10),JT=1,5) /
     &1.4644E-01,1.6376E-01,1.8425E-01,2.1431E-01,2.7054E-01/
      DATA (KB(JT,54,10),JT=1,5) /
     &1.3139E-01,1.4808E-01,1.6611E-01,1.9208E-01,2.4005E-01/
      DATA (KB(JT,55,10),JT=1,5) /
     &1.2172E-01,1.3644E-01,1.5558E-01,1.7831E-01,2.1286E-01/
      DATA (KB(JT,56,10),JT=1,5) /
     &1.1074E-01,1.2717E-01,1.4642E-01,1.6603E-01,1.9730E-01/
      DATA (KB(JT,57,10),JT=1,5) /
     &1.0195E-01,1.1787E-01,1.3707E-01,1.5838E-01,1.8439E-01/
      DATA (KB(JT,58,10),JT=1,5) /
     &9.6243E-02,1.1076E-01,1.2956E-01,1.5169E-01,1.7652E-01/
      DATA (KB(JT,59,10),JT=1,5) /
     &9.7302E-02,1.1627E-01,1.3740E-01,1.6328E-01,1.9053E-01/
      DATA (KB(JT,13,11),JT=1,5) /
     &7.0360E+01,6.9342E+01,6.8249E+01,6.7098E+01,6.5980E+01/
      DATA (KB(JT,14,11),JT=1,5) /
     &6.5791E+01,6.4723E+01,6.3625E+01,6.2598E+01,6.1783E+01/
      DATA (KB(JT,15,11),JT=1,5) /
     &6.0426E+01,5.9395E+01,5.8516E+01,5.7828E+01,5.7219E+01/
      DATA (KB(JT,16,11),JT=1,5) /
     &5.4683E+01,5.3915E+01,5.3328E+01,5.2878E+01,5.2385E+01/
      DATA (KB(JT,17,11),JT=1,5) /
     &4.8953E+01,4.8487E+01,4.8177E+01,4.7782E+01,4.7308E+01/
      DATA (KB(JT,18,11),JT=1,5) /
     &4.3480E+01,4.3274E+01,4.2982E+01,4.2563E+01,4.2021E+01/
      DATA (KB(JT,19,11),JT=1,5) /
     &3.8401E+01,3.8213E+01,3.7862E+01,3.7391E+01,3.6879E+01/
      DATA (KB(JT,20,11),JT=1,5) /
     &3.3602E+01,3.3341E+01,3.2960E+01,3.2565E+01,3.2185E+01/
      DATA (KB(JT,21,11),JT=1,5) /
     &2.9094E+01,2.8806E+01,2.8524E+01,2.8243E+01,2.8023E+01/
      DATA (KB(JT,22,11),JT=1,5) /
     &2.4954E+01,2.4758E+01,2.4575E+01,2.4433E+01,2.4352E+01/
      DATA (KB(JT,23,11),JT=1,5) /
     &2.1326E+01,2.1219E+01,2.1148E+01,2.1108E+01,2.1117E+01/
      DATA (KB(JT,24,11),JT=1,5) /
     &1.8212E+01,1.8167E+01,1.8172E+01,1.8221E+01,1.8288E+01/
      DATA (KB(JT,25,11),JT=1,5) /
     &1.5541E+01,1.5569E+01,1.5649E+01,1.5756E+01,1.5867E+01/
      DATA (KB(JT,26,11),JT=1,5) /
     &1.3185E+01,1.3326E+01,1.3479E+01,1.3624E+01,1.3786E+01/
      DATA (KB(JT,27,11),JT=1,5) /
     &1.0920E+01,1.1211E+01,1.1487E+01,1.1743E+01,1.1957E+01/
      DATA (KB(JT,28,11),JT=1,5) /
     &9.0678E+00,9.3710E+00,9.6834E+00,9.9920E+00,1.0324E+01/
      DATA (KB(JT,29,11),JT=1,5) /
     &7.6881E+00,7.9879E+00,8.2968E+00,8.6379E+00,9.0061E+00/
      DATA (KB(JT,30,11),JT=1,5) /
     &6.6033E+00,6.8954E+00,7.2204E+00,7.5787E+00,7.9480E+00/
      DATA (KB(JT,31,11),JT=1,5) /
     &5.8224E+00,6.1213E+00,6.4394E+00,6.7947E+00,7.1839E+00/
      DATA (KB(JT,32,11),JT=1,5) /
     &5.1825E+00,5.4854E+00,5.8203E+00,6.1672E+00,6.5644E+00/
      DATA (KB(JT,33,11),JT=1,5) /
     &4.6793E+00,4.9853E+00,5.3218E+00,5.6796E+00,6.0723E+00/
      DATA (KB(JT,34,11),JT=1,5) /
     &4.2112E+00,4.5240E+00,4.8672E+00,5.2510E+00,5.6439E+00/
      DATA (KB(JT,35,11),JT=1,5) /
     &3.8061E+00,4.1193E+00,4.4694E+00,4.8571E+00,5.2645E+00/
      DATA (KB(JT,36,11),JT=1,5) /
     &3.4331E+00,3.7452E+00,4.0978E+00,4.4887E+00,4.9173E+00/
      DATA (KB(JT,37,11),JT=1,5) /
     &3.0586E+00,3.3607E+00,3.7172E+00,4.1153E+00,4.5572E+00/
      DATA (KB(JT,38,11),JT=1,5) /
     &2.7517E+00,3.0453E+00,3.3976E+00,3.7947E+00,4.2441E+00/
      DATA (KB(JT,39,11),JT=1,5) /
     &2.5013E+00,2.7908E+00,3.1383E+00,3.5236E+00,3.9765E+00/
      DATA (KB(JT,40,11),JT=1,5) /
     &2.2268E+00,2.5094E+00,2.8534E+00,3.2426E+00,3.6921E+00/
      DATA (KB(JT,41,11),JT=1,5) /
     &1.9832E+00,2.2609E+00,2.6000E+00,2.9899E+00,3.4337E+00/
      DATA (KB(JT,42,11),JT=1,5) /
     &1.7785E+00,2.0479E+00,2.3793E+00,2.7692E+00,3.2048E+00/
      DATA (KB(JT,43,11),JT=1,5) /
     &1.5856E+00,1.8448E+00,2.1667E+00,2.5496E+00,2.9735E+00/
      DATA (KB(JT,44,11),JT=1,5) /
     &1.4123E+00,1.6629E+00,1.9679E+00,2.3444E+00,2.7547E+00/
      DATA (KB(JT,45,11),JT=1,5) /
     &1.2640E+00,1.5067E+00,1.7987E+00,2.1603E+00,2.5558E+00/
      DATA (KB(JT,46,11),JT=1,5) /
     &1.1290E+00,1.3620E+00,1.6422E+00,1.9855E+00,2.3652E+00/
      DATA (KB(JT,47,11),JT=1,5) /
     &9.9161E-01,1.2154E+00,1.4836E+00,1.8087E+00,2.1736E+00/
      DATA (KB(JT,48,11),JT=1,5) /
     &8.7615E-01,1.0875E+00,1.3440E+00,1.6515E+00,1.9976E+00/
      DATA (KB(JT,49,11),JT=1,5) /
     &7.7782E-01,9.7773E-01,1.2220E+00,1.5130E+00,1.8356E+00/
      DATA (KB(JT,50,11),JT=1,5) /
     &6.8345E-01,8.7089E-01,1.1065E+00,1.3830E+00,1.6924E+00/
      DATA (KB(JT,51,11),JT=1,5) /
     &5.9562E-01,7.7251E-01,9.9776E-01,1.2648E+00,1.5621E+00/
      DATA (KB(JT,52,11),JT=1,5) /
     &5.1948E-01,6.8509E-01,8.9806E-01,1.1564E+00,1.4407E+00/
      DATA (KB(JT,53,11),JT=1,5) /
     &4.5430E-01,6.0810E-01,8.0999E-01,1.0551E+00,1.3256E+00/
      DATA (KB(JT,54,11),JT=1,5) /
     &3.8584E-01,5.2960E-01,7.1926E-01,9.5469E-01,1.2208E+00/
      DATA (KB(JT,55,11),JT=1,5) /
     &3.2585E-01,4.5415E-01,6.2813E-01,8.5255E-01,1.1189E+00/
      DATA (KB(JT,56,11),JT=1,5) /
     &2.9347E-01,3.8309E-01,5.4571E-01,7.5695E-01,1.0111E+00/
      DATA (KB(JT,57,11),JT=1,5) /
     &2.6872E-01,3.3263E-01,4.6996E-01,6.6376E-01,9.0688E-01/
      DATA (KB(JT,58,11),JT=1,5) /
     &2.4960E-01,3.0758E-01,4.0207E-01,5.8213E-01,8.0803E-01/
      DATA (KB(JT,59,11),JT=1,5) /
     &2.6183E-01,3.2106E-01,3.9760E-01,5.1091E-01,7.1717E-01/
      DATA (KB(JT,13,12),JT=1,5) /
     &1.1832E+02,1.1787E+02,1.1696E+02,1.1585E+02,1.1448E+02/
      DATA (KB(JT,14,12),JT=1,5) /
     &1.1787E+02,1.1706E+02,1.1585E+02,1.1435E+02,1.1282E+02/
      DATA (KB(JT,15,12),JT=1,5) /
     &1.1482E+02,1.1352E+02,1.1198E+02,1.1040E+02,1.0880E+02/
      DATA (KB(JT,16,12),JT=1,5) /
     &1.0896E+02,1.0749E+02,1.0590E+02,1.0433E+02,1.0304E+02/
      DATA (KB(JT,17,12),JT=1,5) /
     &1.0128E+02,9.9814E+01,9.8422E+01,9.7349E+01,9.6504E+01/
      DATA (KB(JT,18,12),JT=1,5) /
     &9.2677E+01,9.1506E+01,9.0639E+01,9.0100E+01,8.9682E+01/
      DATA (KB(JT,19,12),JT=1,5) /
     &8.3897E+01,8.3222E+01,8.2911E+01,8.2751E+01,8.2502E+01/
      DATA (KB(JT,20,12),JT=1,5) /
     &7.5342E+01,7.5217E+01,7.5315E+01,7.5254E+01,7.5130E+01/
      DATA (KB(JT,21,12),JT=1,5) /
     &6.7351E+01,6.7622E+01,6.7745E+01,6.7796E+01,6.7734E+01/
      DATA (KB(JT,22,12),JT=1,5) /
     &5.9964E+01,6.0293E+01,6.0504E+01,6.0565E+01,6.0581E+01/
      DATA (KB(JT,23,12),JT=1,5) /
     &5.3111E+01,5.3464E+01,5.3681E+01,5.3837E+01,5.4061E+01/
      DATA (KB(JT,24,12),JT=1,5) /
     &4.6795E+01,4.7144E+01,4.7460E+01,4.7828E+01,4.8279E+01/
      DATA (KB(JT,25,12),JT=1,5) /
     &4.1060E+01,4.1497E+01,4.1989E+01,4.2550E+01,4.3265E+01/
      DATA (KB(JT,26,12),JT=1,5) /
     &3.6007E+01,3.6594E+01,3.7261E+01,3.8060E+01,3.9005E+01/
      DATA (KB(JT,27,12),JT=1,5) /
     &3.1657E+01,3.2380E+01,3.3234E+01,3.4259E+01,3.5455E+01/
      DATA (KB(JT,28,12),JT=1,5) /
     &2.7936E+01,2.8816E+01,2.9878E+01,3.1120E+01,3.2499E+01/
      DATA (KB(JT,29,12),JT=1,5) /
     &2.4811E+01,2.5887E+01,2.7138E+01,2.8541E+01,3.0069E+01/
      DATA (KB(JT,30,12),JT=1,5) /
     &2.2271E+01,2.3484E+01,2.4883E+01,2.6431E+01,2.8119E+01/
      DATA (KB(JT,31,12),JT=1,5) /
     &2.0203E+01,2.1534E+01,2.3058E+01,2.4751E+01,2.6602E+01/
      DATA (KB(JT,32,12),JT=1,5) /
     &1.8534E+01,1.9980E+01,2.1635E+01,2.3479E+01,2.5477E+01/
      DATA (KB(JT,33,12),JT=1,5) /
     &1.7225E+01,1.8794E+01,2.0572E+01,2.2559E+01,2.4699E+01/
      DATA (KB(JT,34,12),JT=1,5) /
     &1.6174E+01,1.7857E+01,1.9770E+01,2.1880E+01,2.4147E+01/
      DATA (KB(JT,35,12),JT=1,5) /
     &1.5236E+01,1.7017E+01,1.9034E+01,2.1242E+01,2.3610E+01/
      DATA (KB(JT,36,12),JT=1,5) /
     &1.4322E+01,1.6183E+01,1.8272E+01,2.0552E+01,2.2984E+01/
      DATA (KB(JT,37,12),JT=1,5) /
     &1.3315E+01,1.5210E+01,1.7331E+01,1.9645E+01,2.2115E+01/
      DATA (KB(JT,38,12),JT=1,5) /
     &1.2427E+01,1.4349E+01,1.6493E+01,1.8831E+01,2.1326E+01/
      DATA (KB(JT,39,12),JT=1,5) /
     &1.1655E+01,1.3594E+01,1.5756E+01,1.8111E+01,2.0619E+01/
      DATA (KB(JT,40,12),JT=1,5) /
     &1.0800E+01,1.2718E+01,1.4870E+01,1.7214E+01,1.9711E+01/
      DATA (KB(JT,41,12),JT=1,5) /
     &1.0009E+01,1.1890E+01,1.4023E+01,1.6343E+01,1.8829E+01/
      DATA (KB(JT,42,12),JT=1,5) /
     &9.2911E+00,1.1131E+01,1.3230E+01,1.5526E+01,1.7990E+01/
      DATA (KB(JT,43,12),JT=1,5) /
     &8.5453E+00,1.0322E+01,1.2366E+01,1.4622E+01,1.7049E+01/
      DATA (KB(JT,44,12),JT=1,5) /
     &7.8249E+00,9.5233E+00,1.1499E+01,1.3704E+01,1.6085E+01/
      DATA (KB(JT,45,12),JT=1,5) /
     &7.1656E+00,8.7847E+00,1.0682E+01,1.2826E+01,1.5159E+01/
      DATA (KB(JT,46,12),JT=1,5) /
     &6.5222E+00,8.0621E+00,9.8691E+00,1.1939E+01,1.4215E+01/
      DATA (KB(JT,47,12),JT=1,5) /
     &5.8688E+00,7.3253E+00,9.0292E+00,1.1003E+01,1.3207E+01/
      DATA (KB(JT,48,12),JT=1,5) /
     &5.2686E+00,6.6401E+00,8.2460E+00,1.0116E+01,1.2240E+01/
      DATA (KB(JT,49,12),JT=1,5) /
     &4.7119E+00,6.0011E+00,7.5181E+00,9.2810E+00,1.1309E+01/
      DATA (KB(JT,50,12),JT=1,5) /
     &4.2243E+00,5.4409E+00,6.8771E+00,8.5451E+00,1.0476E+01/
      DATA (KB(JT,51,12),JT=1,5) /
     &3.7894E+00,4.9333E+00,6.2908E+00,7.8717E+00,9.7058E+00/
      DATA (KB(JT,52,12),JT=1,5) /
     &3.3915E+00,4.4569E+00,5.7416E+00,7.2423E+00,8.9799E+00/
      DATA (KB(JT,53,12),JT=1,5) /
     &3.0222E+00,4.0130E+00,5.2245E+00,6.6473E+00,8.2931E+00/
      DATA (KB(JT,54,12),JT=1,5) /
     &2.7077E+00,3.6347E+00,4.7766E+00,6.1280E+00,7.6968E+00/
      DATA (KB(JT,55,12),JT=1,5) /
     &2.4210E+00,3.2970E+00,4.3697E+00,5.6562E+00,7.1563E+00/
      DATA (KB(JT,56,12),JT=1,5) /
     &2.1307E+00,2.9831E+00,3.9864E+00,5.2103E+00,6.6404E+00/
      DATA (KB(JT,57,12),JT=1,5) /
     &1.8552E+00,2.6736E+00,3.6295E+00,4.7868E+00,6.1491E+00/
      DATA (KB(JT,58,12),JT=1,5) /
     &1.6050E+00,2.3734E+00,3.3136E+00,4.4004E+00,5.7055E+00/
      DATA (KB(JT,59,12),JT=1,5) /
     &1.4434E+00,2.1814E+00,3.1118E+00,4.2418E+00,5.5300E+00/
      DATA (KB(JT,13,13),JT=1,5) /
     &2.0665E+02,2.0326E+02,2.0074E+02,1.9867E+02,1.9680E+02/
      DATA (KB(JT,14,13),JT=1,5) /
     &2.1250E+02,2.0998E+02,2.0827E+02,2.0659E+02,2.0468E+02/
      DATA (KB(JT,15,13),JT=1,5) /
     &2.1695E+02,2.1587E+02,2.1446E+02,2.1260E+02,2.1056E+02/
      DATA (KB(JT,16,13),JT=1,5) /
     &2.2062E+02,2.1972E+02,2.1811E+02,2.1619E+02,2.1401E+02/
      DATA (KB(JT,17,13),JT=1,5) /
     &2.2121E+02,2.1996E+02,2.1823E+02,2.1618E+02,2.1385E+02/
      DATA (KB(JT,18,13),JT=1,5) /
     &2.1775E+02,2.1636E+02,2.1445E+02,2.1229E+02,2.1021E+02/
      DATA (KB(JT,19,13),JT=1,5) /
     &2.1064E+02,2.0900E+02,2.0712E+02,2.0551E+02,2.0407E+02/
      DATA (KB(JT,20,13),JT=1,5) /
     &2.0008E+02,1.9874E+02,1.9769E+02,1.9686E+02,1.9621E+02/
      DATA (KB(JT,21,13),JT=1,5) /
     &1.8747E+02,1.8700E+02,1.8691E+02,1.8703E+02,1.8742E+02/
      DATA (KB(JT,22,13),JT=1,5) /
     &1.7415E+02,1.7476E+02,1.7572E+02,1.7701E+02,1.7852E+02/
      DATA (KB(JT,23,13),JT=1,5) /
     &1.6113E+02,1.6295E+02,1.6510E+02,1.6752E+02,1.7009E+02/
      DATA (KB(JT,24,13),JT=1,5) /
     &1.4912E+02,1.5211E+02,1.5536E+02,1.5887E+02,1.6232E+02/
      DATA (KB(JT,25,13),JT=1,5) /
     &1.3846E+02,1.4246E+02,1.4677E+02,1.5111E+02,1.5523E+02/
      DATA (KB(JT,26,13),JT=1,5) /
     &1.2926E+02,1.3422E+02,1.3933E+02,1.4432E+02,1.4910E+02/
      DATA (KB(JT,27,13),JT=1,5) /
     &1.2138E+02,1.2724E+02,1.3302E+02,1.3864E+02,1.4402E+02/
      DATA (KB(JT,28,13),JT=1,5) /
     &1.1492E+02,1.2144E+02,1.2785E+02,1.3411E+02,1.4008E+02/
      DATA (KB(JT,29,13),JT=1,5) /
     &1.0978E+02,1.1690E+02,1.2395E+02,1.3076E+02,1.3730E+02/
      DATA (KB(JT,30,13),JT=1,5) /
     &1.0580E+02,1.1355E+02,1.2118E+02,1.2849E+02,1.3548E+02/
      DATA (KB(JT,31,13),JT=1,5) /
     &1.0304E+02,1.1137E+02,1.1944E+02,1.2716E+02,1.3451E+02/
      DATA (KB(JT,32,13),JT=1,5) /
     &1.0136E+02,1.1014E+02,1.1859E+02,1.2663E+02,1.3416E+02/
      DATA (KB(JT,33,13),JT=1,5) /
     &1.0056E+02,1.0971E+02,1.1845E+02,1.2667E+02,1.3431E+02/
      DATA (KB(JT,34,13),JT=1,5) /
     &1.0020E+02,1.0961E+02,1.1855E+02,1.2688E+02,1.3458E+02/
      DATA (KB(JT,35,13),JT=1,5) /
     &9.9483E+01,1.0912E+02,1.1821E+02,1.2667E+02,1.3443E+02/
      DATA (KB(JT,36,13),JT=1,5) /
     &9.8103E+01,1.0792E+02,1.1721E+02,1.2581E+02,1.3368E+02/
      DATA (KB(JT,37,13),JT=1,5) /
     &9.5455E+01,1.0552E+02,1.1504E+02,1.2386E+02,1.3193E+02/
      DATA (KB(JT,38,13),JT=1,5) /
     &9.2912E+01,1.0319E+02,1.1292E+02,1.2195E+02,1.3022E+02/
      DATA (KB(JT,39,13),JT=1,5) /
     &9.0538E+01,1.0100E+02,1.1091E+02,1.2014E+02,1.2859E+02/
      DATA (KB(JT,40,13),JT=1,5) /
     &8.7195E+01,9.7854E+01,1.0799E+02,1.1748E+02,1.2618E+02/
      DATA (KB(JT,41,13),JT=1,5) /
     &8.3785E+01,9.4631E+01,1.0497E+02,1.1470E+02,1.2366E+02/
      DATA (KB(JT,42,13),JT=1,5) /
     &8.0430E+01,9.1433E+01,1.0197E+02,1.1192E+02,1.2113E+02/
      DATA (KB(JT,43,13),JT=1,5) /
     &7.6477E+01,8.7634E+01,9.8384E+01,1.0856E+02,1.1808E+02/
      DATA (KB(JT,44,13),JT=1,5) /
     &7.2299E+01,8.3562E+01,9.4524E+01,1.0494E+02,1.1474E+02/
      DATA (KB(JT,45,13),JT=1,5) /
     &6.8166E+01,7.9496E+01,9.0629E+01,1.0127E+02,1.1130E+02/
      DATA (KB(JT,46,13),JT=1,5) /
     &6.3834E+01,7.5188E+01,8.6450E+01,9.7312E+01,1.0760E+02/
      DATA (KB(JT,47,13),JT=1,5) /
     &5.9081E+01,7.0413E+01,8.1772E+01,9.2852E+01,1.0340E+02/
      DATA (KB(JT,48,13),JT=1,5) /
     &5.4396E+01,6.5661E+01,7.7060E+01,8.8317E+01,9.9114E+01/
      DATA (KB(JT,49,13),JT=1,5) /
     &4.9801E+01,6.0961E+01,7.2354E+01,8.3709E+01,9.4725E+01/
      DATA (KB(JT,50,13),JT=1,5) /
     &4.5581E+01,5.6585E+01,6.7933E+01,7.9345E+01,9.0545E+01/
      DATA (KB(JT,51,13),JT=1,5) /
     &4.1581E+01,5.2405E+01,6.3662E+01,7.5096E+01,8.6425E+01/
      DATA (KB(JT,52,13),JT=1,5) /
     &3.7719E+01,4.8309E+01,5.9448E+01,7.0850E+01,8.2254E+01/
      DATA (KB(JT,53,13),JT=1,5) /
     &3.4012E+01,4.4282E+01,5.5265E+01,6.6609E+01,7.8050E+01/
      DATA (KB(JT,54,13),JT=1,5) /
     &3.0756E+01,4.0675E+01,5.1476E+01,6.2735E+01,7.4183E+01/
      DATA (KB(JT,55,13),JT=1,5) /
     &2.7771E+01,3.7316E+01,4.7906E+01,5.9042E+01,7.0461E+01/
      DATA (KB(JT,56,13),JT=1,5) /
     &2.4943E+01,3.4093E+01,4.4398E+01,5.5401E+01,6.6760E+01/
      DATA (KB(JT,57,13),JT=1,5) /
     &2.2280E+01,3.0993E+01,4.0957E+01,5.1794E+01,6.3073E+01/
      DATA (KB(JT,58,13),JT=1,5) /
     &1.9914E+01,2.8171E+01,3.7788E+01,4.8428E+01,5.9596E+01/
      DATA (KB(JT,59,13),JT=1,5) /
     &1.9003E+01,2.7062E+01,3.6534E+01,4.7084E+01,5.8201E+01/
      DATA (KB(JT,13,14),JT=1,5) /
     &3.9453E+02,3.9054E+02,3.8556E+02,3.8029E+02,3.7518E+02/
      DATA (KB(JT,14,14),JT=1,5) /
     &4.2588E+02,4.2023E+02,4.1375E+02,4.0776E+02,4.0199E+02/
      DATA (KB(JT,15,14),JT=1,5) /
     &4.5408E+02,4.4627E+02,4.3917E+02,4.3301E+02,4.2714E+02/
      DATA (KB(JT,16,14),JT=1,5) /
     &4.7789E+02,4.6976E+02,4.6328E+02,4.5698E+02,4.5114E+02/
      DATA (KB(JT,17,14),JT=1,5) /
     &5.0033E+02,4.9329E+02,4.8659E+02,4.8030E+02,4.7472E+02/
      DATA (KB(JT,18,14),JT=1,5) /
     &5.2160E+02,5.1479E+02,5.0850E+02,5.0281E+02,4.9755E+02/
      DATA (KB(JT,19,14),JT=1,5) /
     &5.3975E+02,5.3405E+02,5.2880E+02,5.2359E+02,5.1826E+02/
      DATA (KB(JT,20,14),JT=1,5) /
     &5.5471E+02,5.5025E+02,5.4544E+02,5.4054E+02,5.3559E+02/
      DATA (KB(JT,21,14),JT=1,5) /
     &5.6616E+02,5.6246E+02,5.5854E+02,5.5439E+02,5.5012E+02/
      DATA (KB(JT,22,14),JT=1,5) /
     &5.7373E+02,5.7143E+02,5.6842E+02,5.6526E+02,5.6165E+02/
      DATA (KB(JT,23,14),JT=1,5) /
     &5.7822E+02,5.7745E+02,5.7602E+02,5.7378E+02,5.7033E+02/
      DATA (KB(JT,24,14),JT=1,5) /
     &5.8038E+02,5.8144E+02,5.8147E+02,5.7978E+02,5.7697E+02/
      DATA (KB(JT,25,14),JT=1,5) /
     &5.8144E+02,5.8416E+02,5.8500E+02,5.8436E+02,5.8236E+02/
      DATA (KB(JT,26,14),JT=1,5) /
     &5.8189E+02,5.8575E+02,5.8780E+02,5.8818E+02,5.8686E+02/
      DATA (KB(JT,27,14),JT=1,5) /
     &5.8218E+02,5.8719E+02,5.9038E+02,5.9148E+02,5.9059E+02/
      DATA (KB(JT,28,14),JT=1,5) /
     &5.8262E+02,5.8871E+02,5.9261E+02,5.9417E+02,5.9365E+02/
      DATA (KB(JT,29,14),JT=1,5) /
     &5.8351E+02,5.9046E+02,5.9468E+02,5.9643E+02,5.9604E+02/
      DATA (KB(JT,30,14),JT=1,5) /
     &5.8500E+02,5.9236E+02,5.9667E+02,5.9846E+02,5.9808E+02/
      DATA (KB(JT,31,14),JT=1,5) /
     &5.8683E+02,5.9418E+02,5.9850E+02,6.0020E+02,5.9975E+02/
      DATA (KB(JT,32,14),JT=1,5) /
     &5.8889E+02,5.9602E+02,6.0013E+02,6.0165E+02,6.0111E+02/
      DATA (KB(JT,33,14),JT=1,5) /
     &5.9113E+02,5.9792E+02,6.0167E+02,6.0289E+02,6.0219E+02/
      DATA (KB(JT,34,14),JT=1,5) /
     &5.9309E+02,5.9954E+02,6.0296E+02,6.0390E+02,6.0309E+02/
      DATA (KB(JT,35,14),JT=1,5) /
     &5.9425E+02,6.0057E+02,6.0391E+02,6.0481E+02,6.0395E+02/
      DATA (KB(JT,36,14),JT=1,5) /
     &5.9453E+02,6.0102E+02,6.0449E+02,6.0555E+02,6.0478E+02/
      DATA (KB(JT,37,14),JT=1,5) /
     &5.9344E+02,6.0064E+02,6.0466E+02,6.0613E+02,6.0565E+02/
      DATA (KB(JT,38,14),JT=1,5) /
     &5.9210E+02,6.0005E+02,6.0460E+02,6.0657E+02,6.0636E+02/
      DATA (KB(JT,39,14),JT=1,5) /
     &5.9062E+02,5.9933E+02,6.0439E+02,6.0685E+02,6.0693E+02/
      DATA (KB(JT,40,14),JT=1,5) /
     &5.8781E+02,5.9770E+02,6.0363E+02,6.0675E+02,6.0742E+02/
      DATA (KB(JT,41,14),JT=1,5) /
     &5.8441E+02,5.9563E+02,6.0254E+02,6.0641E+02,6.0773E+02/
      DATA (KB(JT,42,14),JT=1,5) /
     &5.8066E+02,5.9320E+02,6.0125E+02,6.0582E+02,6.0784E+02/
      DATA (KB(JT,43,14),JT=1,5) /
     &5.7546E+02,5.8975E+02,5.9921E+02,6.0478E+02,6.0764E+02/
      DATA (KB(JT,44,14),JT=1,5) /
     &5.6919E+02,5.8551E+02,5.9655E+02,6.0334E+02,6.0709E+02/
      DATA (KB(JT,45,14),JT=1,5) /
     &5.6228E+02,5.8057E+02,5.9328E+02,6.0149E+02,6.0621E+02/
      DATA (KB(JT,46,14),JT=1,5) /
     &5.5416E+02,5.7453E+02,5.8925E+02,5.9904E+02,6.0487E+02/
      DATA (KB(JT,47,14),JT=1,5) /
     &5.4413E+02,5.6695E+02,5.8396E+02,5.9568E+02,6.0296E+02/
      DATA (KB(JT,48,14),JT=1,5) /
     &5.3289E+02,5.5838E+02,5.7778E+02,5.9151E+02,6.0055E+02/
      DATA (KB(JT,49,14),JT=1,5) /
     &5.2046E+02,5.4886E+02,5.7056E+02,5.8661E+02,5.9745E+02/
      DATA (KB(JT,50,14),JT=1,5) /
     &5.0763E+02,5.3890E+02,5.6309E+02,5.8123E+02,5.9389E+02/
      DATA (KB(JT,51,14),JT=1,5) /
     &4.9397E+02,5.2829E+02,5.5490E+02,5.7522E+02,5.8985E+02/
      DATA (KB(JT,52,14),JT=1,5) /
     &4.7917E+02,5.1663E+02,5.4597E+02,5.6843E+02,5.8514E+02/
      DATA (KB(JT,53,14),JT=1,5) /
     &4.6310E+02,5.0389E+02,5.3606E+02,5.6086E+02,5.7969E+02/
      DATA (KB(JT,54,14),JT=1,5) /
     &4.4738E+02,4.9113E+02,5.2610E+02,5.5325E+02,5.7401E+02/
      DATA (KB(JT,55,14),JT=1,5) /
     &4.3145E+02,4.7800E+02,5.1576E+02,5.4530E+02,5.6795E+02/
      DATA (KB(JT,56,14),JT=1,5) /
     &4.1442E+02,4.6397E+02,5.0460E+02,5.3665E+02,5.6135E+02/
      DATA (KB(JT,57,14),JT=1,5) /
     &3.9638E+02,4.4904E+02,4.9255E+02,5.2719E+02,5.5411E+02/
      DATA (KB(JT,58,14),JT=1,5) /
     &3.7836E+02,4.3410E+02,4.8026E+02,5.1754E+02,5.4672E+02/
      DATA (KB(JT,59,14),JT=1,5) /
     &3.7094E+02,4.2781E+02,4.7507E+02,5.1348E+02,5.4351E+02/
      DATA (KB(JT,13,15),JT=1,5) /
     &7.2633E+02,7.1401E+02,7.0254E+02,6.9098E+02,6.8020E+02/
      DATA (KB(JT,14,15),JT=1,5) /
     &8.3011E+02,8.1776E+02,8.0585E+02,7.9323E+02,7.8158E+02/
      DATA (KB(JT,15,15),JT=1,5) /
     &9.4371E+02,9.3141E+02,9.1779E+02,9.0358E+02,8.9021E+02/
      DATA (KB(JT,16,15),JT=1,5) /
     &1.0657E+03,1.0512E+03,1.0343E+03,1.0183E+03,1.0024E+03/
      DATA (KB(JT,17,15),JT=1,5) /
     &1.1900E+03,1.1715E+03,1.1530E+03,1.1344E+03,1.1149E+03/
      DATA (KB(JT,18,15),JT=1,5) /
     &1.3144E+03,1.2934E+03,1.2719E+03,1.2491E+03,1.2254E+03/
      DATA (KB(JT,19,15),JT=1,5) /
     &1.4395E+03,1.4148E+03,1.3884E+03,1.3607E+03,1.3337E+03/
      DATA (KB(JT,20,15),JT=1,5) /
     &1.5639E+03,1.5338E+03,1.5021E+03,1.4707E+03,1.4392E+03/
      DATA (KB(JT,21,15),JT=1,5) /
     &1.6839E+03,1.6488E+03,1.6126E+03,1.5763E+03,1.5389E+03/
      DATA (KB(JT,22,15),JT=1,5) /
     &1.7952E+03,1.7545E+03,1.7135E+03,1.6710E+03,1.6285E+03/
      DATA (KB(JT,23,15),JT=1,5) /
     &1.8976E+03,1.8509E+03,1.8033E+03,1.7556E+03,1.7089E+03/
      DATA (KB(JT,24,15),JT=1,5) /
     &1.9890E+03,1.9360E+03,1.8826E+03,1.8303E+03,1.7792E+03/
      DATA (KB(JT,25,15),JT=1,5) /
     &2.0674E+03,2.0090E+03,1.9512E+03,1.8940E+03,1.8389E+03/
      DATA (KB(JT,26,15),JT=1,5) /
     &2.1327E+03,2.0701E+03,2.0075E+03,1.9460E+03,1.8872E+03/
      DATA (KB(JT,27,15),JT=1,5) /
     &2.1871E+03,2.1199E+03,2.0526E+03,1.9878E+03,1.9258E+03/
      DATA (KB(JT,28,15),JT=1,5) /
     &2.2305E+03,2.1590E+03,2.0884E+03,2.0207E+03,1.9559E+03/
      DATA (KB(JT,29,15),JT=1,5) /
     &2.2640E+03,2.1881E+03,2.1149E+03,2.0446E+03,1.9773E+03/
      DATA (KB(JT,30,15),JT=1,5) /
     &2.2867E+03,2.2086E+03,2.1332E+03,2.0610E+03,1.9920E+03/
      DATA (KB(JT,31,15),JT=1,5) /
     &2.3021E+03,2.2217E+03,2.1448E+03,2.0709E+03,2.0000E+03/
      DATA (KB(JT,32,15),JT=1,5) /
     &2.3102E+03,2.2286E+03,2.1502E+03,2.0751E+03,2.0031E+03/
      DATA (KB(JT,33,15),JT=1,5) /
     &2.3126E+03,2.2299E+03,2.1503E+03,2.0747E+03,2.0018E+03/
      DATA (KB(JT,34,15),JT=1,5) /
     &2.3131E+03,2.2295E+03,2.1494E+03,2.0730E+03,1.9993E+03/
      DATA (KB(JT,35,15),JT=1,5) /
     &2.3181E+03,2.2337E+03,2.1530E+03,2.0757E+03,2.0015E+03/
      DATA (KB(JT,36,15),JT=1,5) /
     &2.3296E+03,2.2444E+03,2.1625E+03,2.0844E+03,2.0094E+03/
      DATA (KB(JT,37,15),JT=1,5) /
     &2.3524E+03,2.2655E+03,2.1822E+03,2.1029E+03,2.0270E+03/
      DATA (KB(JT,38,15),JT=1,5) /
     &2.3744E+03,2.2859E+03,2.2015E+03,2.1208E+03,2.0440E+03/
      DATA (KB(JT,39,15),JT=1,5) /
     &2.3947E+03,2.3050E+03,2.2197E+03,2.1376E+03,2.0600E+03/
      DATA (KB(JT,40,15),JT=1,5) /
     &2.4238E+03,2.3323E+03,2.2455E+03,2.1621E+03,2.0831E+03/
      DATA (KB(JT,41,15),JT=1,5) /
     &2.4535E+03,2.3601E+03,2.2718E+03,2.1873E+03,2.1067E+03/
      DATA (KB(JT,42,15),JT=1,5) /
     &2.4827E+03,2.3879E+03,2.2978E+03,2.2120E+03,2.1299E+03/
      DATA (KB(JT,43,15),JT=1,5) /
     &2.5170E+03,2.4207E+03,2.3287E+03,2.2417E+03,2.1580E+03/
      DATA (KB(JT,44,15),JT=1,5) /
     &2.5535E+03,2.4558E+03,2.3619E+03,2.2731E+03,2.1881E+03/
      DATA (KB(JT,45,15),JT=1,5) /
     &2.5895E+03,2.4909E+03,2.3955E+03,2.3046E+03,2.2183E+03/
      DATA (KB(JT,46,15),JT=1,5) /
     &2.6275E+03,2.5286E+03,2.4314E+03,2.3383E+03,2.2507E+03/
      DATA (KB(JT,47,15),JT=1,5) /
     &2.6692E+03,2.5702E+03,2.4716E+03,2.3766E+03,2.2868E+03/
      DATA (KB(JT,48,15),JT=1,5) /
     &2.7104E+03,2.6117E+03,2.5124E+03,2.4158E+03,2.3235E+03/
      DATA (KB(JT,49,15),JT=1,5) /
     &2.7515E+03,2.6527E+03,2.5535E+03,2.4553E+03,2.3608E+03/
      DATA (KB(JT,50,15),JT=1,5) /
     &2.7894E+03,2.6912E+03,2.5919E+03,2.4928E+03,2.3968E+03/
      DATA (KB(JT,51,15),JT=1,5) /
     &2.8258E+03,2.7283E+03,2.6293E+03,2.5297E+03,2.4319E+03/
      DATA (KB(JT,52,15),JT=1,5) /
     &2.8615E+03,2.7650E+03,2.6661E+03,2.5667E+03,2.4680E+03/
      DATA (KB(JT,53,15),JT=1,5) /
     &2.8958E+03,2.8012E+03,2.7030E+03,2.6033E+03,2.5041E+03/
      DATA (KB(JT,54,15),JT=1,5) /
     &2.9257E+03,2.8343E+03,2.7368E+03,2.6377E+03,2.5378E+03/
      DATA (KB(JT,55,15),JT=1,5) /
     &2.9533E+03,2.8653E+03,2.7685E+03,2.6697E+03,2.5700E+03/
      DATA (KB(JT,56,15),JT=1,5) /
     &2.9793E+03,2.8948E+03,2.8002E+03,2.7018E+03,2.6024E+03/
      DATA (KB(JT,57,15),JT=1,5) /
     &3.0042E+03,2.9237E+03,2.8317E+03,2.7340E+03,2.6347E+03/
      DATA (KB(JT,58,15),JT=1,5) /
     &3.0257E+03,2.9495E+03,2.8610E+03,2.7641E+03,2.6651E+03/
      DATA (KB(JT,59,15),JT=1,5) /
     &3.0338E+03,2.9597E+03,2.8725E+03,2.7761E+03,2.6773E+03/
      DATA (KB(JT,13,16),JT=1,5) /
     &1.0026E+03,9.7775E+02,9.6058E+02,9.5314E+02,9.4719E+02/
      DATA (KB(JT,14,16),JT=1,5) /
     &1.2035E+03,1.1711E+03,1.1486E+03,1.1339E+03,1.1211E+03/
      DATA (KB(JT,15,16),JT=1,5) /
     &1.4371E+03,1.3952E+03,1.3661E+03,1.3423E+03,1.3197E+03/
      DATA (KB(JT,16,16),JT=1,5) /
     &1.7031E+03,1.6520E+03,1.6127E+03,1.5775E+03,1.5442E+03/
      DATA (KB(JT,17,16),JT=1,5) /
     &2.0034E+03,1.9408E+03,1.8881E+03,1.8394E+03,1.7917E+03/
      DATA (KB(JT,18,16),JT=1,5) /
     &2.3372E+03,2.2594E+03,2.1891E+03,2.1223E+03,2.0585E+03/
      DATA (KB(JT,19,16),JT=1,5) /
     &2.7003E+03,2.6007E+03,2.5092E+03,2.4222E+03,2.3387E+03/
      DATA (KB(JT,20,16),JT=1,5) /
     &3.0827E+03,2.9575E+03,2.8405E+03,2.7290E+03,2.6233E+03/
      DATA (KB(JT,21,16),JT=1,5) /
     &3.4765E+03,3.3200E+03,3.1728E+03,3.0348E+03,2.9062E+03/
      DATA (KB(JT,22,16),JT=1,5) /
     &3.8557E+03,3.6642E+03,3.4867E+03,3.3227E+03,3.1685E+03/
      DATA (KB(JT,23,16),JT=1,5) /
     &4.2141E+03,3.9881E+03,3.7808E+03,3.5882E+03,3.4103E+03/
      DATA (KB(JT,24,16),JT=1,5) /
     &4.5433E+03,4.2837E+03,4.0442E+03,3.8246E+03,3.6242E+03/
      DATA (KB(JT,25,16),JT=1,5) /
     &4.8340E+03,4.5405E+03,4.2717E+03,4.0284E+03,3.8059E+03/
      DATA (KB(JT,26,16),JT=1,5) /
     &5.0756E+03,4.7511E+03,4.4591E+03,4.1940E+03,3.9524E+03/
      DATA (KB(JT,27,16),JT=1,5) /
     &5.2698E+03,4.9206E+03,4.6082E+03,4.3247E+03,4.0667E+03/
      DATA (KB(JT,28,16),JT=1,5) /
     &5.4203E+03,5.0514E+03,4.7208E+03,4.4225E+03,4.1519E+03/
      DATA (KB(JT,29,16),JT=1,5) /
     &5.5225E+03,5.1430E+03,4.7990E+03,4.4889E+03,4.2086E+03/
      DATA (KB(JT,30,16),JT=1,5) /
     &5.5968E+03,5.2018E+03,4.8479E+03,4.5299E+03,4.2431E+03/
      DATA (KB(JT,31,16),JT=1,5) /
     &5.6319E+03,5.2297E+03,4.8692E+03,4.5471E+03,4.2577E+03/
      DATA (KB(JT,32,16),JT=1,5) /
     &5.6393E+03,5.2323E+03,4.8693E+03,4.5451E+03,4.2544E+03/
      DATA (KB(JT,33,16),JT=1,5) /
     &5.6219E+03,5.2153E+03,4.8522E+03,4.5281E+03,4.2389E+03/
      DATA (KB(JT,34,16),JT=1,5) /
     &5.6014E+03,5.1950E+03,4.8333E+03,4.5105E+03,4.2225E+03/
      DATA (KB(JT,35,16),JT=1,5) /
     &5.6085E+03,5.1993E+03,4.8360E+03,4.5120E+03,4.2238E+03/
      DATA (KB(JT,36,16),JT=1,5) /
     &5.6508E+03,5.2362E+03,4.8672E+03,4.5401E+03,4.2477E+03/
      DATA (KB(JT,37,16),JT=1,5) /
     &5.7523E+03,5.3259E+03,4.9464E+03,4.6095E+03,4.3092E+03/
      DATA (KB(JT,38,16),JT=1,5) /
     &5.8536E+03,5.4145E+03,5.0247E+03,4.6788E+03,4.3703E+03/
      DATA (KB(JT,39,16),JT=1,5) /
     &5.9499E+03,5.4442E+03,5.0495E+03,4.7451E+03,4.4289E+03/
      DATA (KB(JT,40,16),JT=1,5) /
     &6.0943E+03,5.6261E+03,5.2115E+03,4.8437E+03,4.5174E+03/
      DATA (KB(JT,41,16),JT=1,5) /
     &6.2466E+03,5.7599E+03,5.3292E+03,4.9481E+03,4.6100E+03/
      DATA (KB(JT,42,16),JT=1,5) /
     &6.4016E+03,5.8949E+03,5.4490E+03,5.0540E+03,4.7039E+03/
      DATA (KB(JT,43,16),JT=1,5) /
     &6.5921E+03,6.0603E+03,5.5952E+03,5.1830E+03,4.8181E+03/
      DATA (KB(JT,44,16),JT=1,5) /
     &6.8054E+03,6.2437E+03,5.7562E+03,5.3258E+03,4.9439E+03/
      DATA (KB(JT,45,16),JT=1,5) /
     &7.0283E+03,6.4351E+03,5.9235E+03,5.4736E+03,5.0747E+03/
      DATA (KB(JT,46,16),JT=1,5) /
     &7.2775E+03,6.6473E+03,6.1076E+03,5.6361E+03,5.2188E+03/
      DATA (KB(JT,47,16),JT=1,5) /
     &7.5694E+03,6.8970E+03,6.3223E+03,5.8241E+03,5.3852E+03/
      DATA (KB(JT,48,16),JT=1,5) /
     &7.8805E+03,7.1623E+03,6.5487E+03,6.0220E+03,5.5600E+03/
      DATA (KB(JT,49,16),JT=1,5) /
     &8.2112E+03,7.4430E+03,6.7899E+03,6.2293E+03,5.7432E+03/
      DATA (KB(JT,50,16),JT=1,5) /
     &8.5417E+03,7.7234E+03,7.0279E+03,6.4340E+03,5.9223E+03/
      DATA (KB(JT,51,16),JT=1,5) /
     &8.8820E+03,8.0126E+03,7.2736E+03,6.6439E+03,6.1042E+03/
      DATA (KB(JT,52,16),JT=1,5) /
     &9.2420E+03,8.3170E+03,7.5326E+03,6.8651E+03,6.2940E+03/
      DATA (KB(JT,53,16),JT=1,5) /
     &9.6269E+03,8.6414E+03,7.8081E+03,7.0991E+03,6.4953E+03/
      DATA (KB(JT,54,16),JT=1,5) /
     &1.0002E+04,8.9556E+03,8.0739E+03,7.3265E+03,6.6894E+03/
      DATA (KB(JT,55,16),JT=1,5) /
     &1.0382E+04,9.2723E+03,8.3431E+03,7.5548E+03,6.8840E+03/
      DATA (KB(JT,56,16),JT=1,5) /
     &1.0780E+04,9.6091E+03,8.6265E+03,7.7944E+03,7.0899E+03/
      DATA (KB(JT,57,16),JT=1,5) /
     &1.1201E+04,9.9648E+03,8.9241E+03,8.0480E+03,7.3039E+03/
      DATA (KB(JT,58,16),JT=1,5) /
     &1.1621E+04,1.0321E+04,9.2223E+03,8.3005E+03,7.5182E+03/
      DATA (KB(JT,59,16),JT=1,5) /
     &1.1796E+04,1.0468E+04,9.3476E+03,8.4058E+03,7.6078E+03/

C     The array KA_Mxx contains the absorption coefficient for 
C     a minor species at the 16 chosen g-values for a reference pressure
C     level below 100~ mb.   The first index refers to temperature 
C     in 7.2 degree increments.  For instance, JT = 1 refers to a 
C     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
C     runs over the g-channel (1 to 16).

       DATA (KA_MO2(JT, 1),JT=1,19)  /
     & 2.31723e-06, 2.28697e-06, 2.25710e-06, 2.22762e-06, 2.19852e-06,
     & 2.16981e-06, 2.14147e-06, 2.11350e-06, 2.08590e-06, 2.05865e-06,
     & 2.03176e-06, 2.00523e-06, 1.97904e-06, 1.95319e-06, 1.92768e-06,
     & 1.90250e-06, 1.87765e-06, 1.85313e-06, 1.82893e-06/
       DATA (KA_MO2(JT, 2),JT=1,19)  /
     & 1.81980e-06, 1.81352e-06, 1.80726e-06, 1.80101e-06, 1.79479e-06,
     & 1.78860e-06, 1.78242e-06, 1.77626e-06, 1.77013e-06, 1.76402e-06,
     & 1.75792e-06, 1.75185e-06, 1.74580e-06, 1.73977e-06, 1.73377e-06,
     & 1.72778e-06, 1.72181e-06, 1.71587e-06, 1.70994e-06/
       DATA (KA_MO2(JT, 3),JT=1,19)  /
     & 2.26922e-06, 2.25413e-06, 2.23914e-06, 2.22425e-06, 2.20945e-06,
     & 2.19476e-06, 2.18016e-06, 2.16566e-06, 2.15126e-06, 2.13695e-06,
     & 2.12274e-06, 2.10862e-06, 2.09459e-06, 2.08066e-06, 2.06683e-06,
     & 2.05308e-06, 2.03942e-06, 2.02586e-06, 2.01239e-06/
       DATA (KA_MO2(JT, 4),JT=1,19)  /
     & 2.15555e-06, 2.14539e-06, 2.13527e-06, 2.12520e-06, 2.11517e-06,
     & 2.10520e-06, 2.09527e-06, 2.08538e-06, 2.07555e-06, 2.06576e-06,
     & 2.05601e-06, 2.04631e-06, 2.03666e-06, 2.02706e-06, 2.01749e-06,
     & 2.00798e-06, 1.99851e-06, 1.98908e-06, 1.97970e-06/
       DATA (KA_MO2(JT, 5),JT=1,19)  /
     & 2.05821e-06, 2.04914e-06, 2.04011e-06, 2.03111e-06, 2.02216e-06,
     & 2.01324e-06, 2.00437e-06, 1.99553e-06, 1.98673e-06, 1.97798e-06,
     & 1.96926e-06, 1.96057e-06, 1.95193e-06, 1.94333e-06, 1.93476e-06,
     & 1.92623e-06, 1.91774e-06, 1.90928e-06, 1.90087e-06/
       DATA (KA_MO2(JT, 6),JT=1,19)  /
     & 2.20148e-06, 2.18998e-06, 2.17854e-06, 2.16717e-06, 2.15585e-06,
     & 2.14459e-06, 2.13339e-06, 2.12225e-06, 2.11117e-06, 2.10014e-06,
     & 2.08918e-06, 2.07827e-06, 2.06741e-06, 2.05662e-06, 2.04588e-06,
     & 2.03519e-06, 2.02457e-06, 2.01399e-06, 2.00348e-06/
       DATA (KA_MO2(JT, 7),JT=1,19)  /
     & 2.28960e-06, 2.27651e-06, 2.26349e-06, 2.25054e-06, 2.23767e-06,
     & 2.22487e-06, 2.21215e-06, 2.19950e-06, 2.18692e-06, 2.17441e-06,
     & 2.16198e-06, 2.14961e-06, 2.13732e-06, 2.12509e-06, 2.11294e-06,
     & 2.10085e-06, 2.08884e-06, 2.07689e-06, 2.06501e-06/
       DATA (KA_MO2(JT, 8),JT=1,19)  /
     & 2.28564e-06, 2.27363e-06, 2.26168e-06, 2.24980e-06, 2.23798e-06,
     & 2.22622e-06, 2.21452e-06, 2.20288e-06, 2.19131e-06, 2.17980e-06,
     & 2.16834e-06, 2.15695e-06, 2.14562e-06, 2.13434e-06, 2.12313e-06,
     & 2.11197e-06, 2.10087e-06, 2.08984e-06, 2.07886e-06/
       DATA (KA_MO2(JT, 9),JT=1,19)  /
     & 2.28505e-06, 2.27395e-06, 2.26291e-06, 2.25192e-06, 2.24099e-06,
     & 2.23011e-06, 2.21928e-06, 2.20850e-06, 2.19778e-06, 2.18711e-06,
     & 2.17649e-06, 2.16592e-06, 2.15540e-06, 2.14494e-06, 2.13452e-06,
     & 2.12416e-06, 2.11385e-06, 2.10358e-06, 2.09337e-06/
       DATA (KA_MO2(JT,10),JT=1,19)  /
     & 2.25915e-06, 2.24938e-06, 2.23965e-06, 2.22997e-06, 2.22032e-06,
     & 2.21072e-06, 2.20116e-06, 2.19164e-06, 2.18216e-06, 2.17272e-06,
     & 2.16333e-06, 2.15397e-06, 2.14465e-06, 2.13538e-06, 2.12614e-06,
     & 2.11695e-06, 2.10779e-06, 2.09868e-06, 2.08960e-06/
       DATA (KA_MO2(JT,11),JT=1,19)  /
     & 2.52025e-06, 2.50423e-06, 2.48831e-06, 2.47249e-06, 2.45677e-06,
     & 2.44115e-06, 2.42563e-06, 2.41021e-06, 2.39489e-06, 2.37967e-06,
     & 2.36454e-06, 2.34951e-06, 2.33457e-06, 2.31973e-06, 2.30498e-06,
     & 2.29033e-06, 2.27577e-06, 2.26130e-06, 2.24692e-06/
       DATA (KA_MO2(JT,12),JT=1,19)  /
     & 2.52634e-06, 2.51180e-06, 2.49735e-06, 2.48299e-06, 2.46871e-06,
     & 2.45451e-06, 2.44039e-06, 2.42635e-06, 2.41239e-06, 2.39851e-06,
     & 2.38472e-06, 2.37100e-06, 2.35736e-06, 2.34380e-06, 2.33032e-06,
     & 2.31691e-06, 2.30358e-06, 2.29033e-06, 2.27716e-06/
       DATA (KA_MO2(JT,13),JT=1,19)  /
     & 2.66614e-06, 2.64897e-06, 2.63191e-06, 2.61496e-06, 2.59812e-06,
     & 2.58138e-06, 2.56476e-06, 2.54824e-06, 2.53183e-06, 2.51552e-06,
     & 2.49932e-06, 2.48322e-06, 2.46723e-06, 2.45134e-06, 2.43555e-06,
     & 2.41987e-06, 2.40428e-06, 2.38880e-06, 2.37341e-06/
       DATA (KA_MO2(JT,14),JT=1,19)  /
     & 2.96755e-06, 2.94803e-06, 2.92864e-06, 2.90937e-06, 2.89023e-06,
     & 2.87122e-06, 2.85233e-06, 2.83357e-06, 2.81493e-06, 2.79641e-06,
     & 2.77802e-06, 2.75974e-06, 2.74159e-06, 2.72355e-06, 2.70563e-06,
     & 2.68784e-06, 2.67015e-06, 2.65259e-06, 2.63514e-06/
       DATA (KA_MO2(JT,15),JT=1,19)  /
     & 1.30668e-06, 1.31378e-06, 1.32091e-06, 1.32808e-06, 1.33530e-06,
     & 1.34255e-06, 1.34984e-06, 1.35717e-06, 1.36454e-06, 1.37195e-06,
     & 1.37941e-06, 1.38690e-06, 1.39443e-06, 1.40200e-06, 1.40962e-06,
     & 1.41727e-06, 1.42497e-06, 1.43271e-06, 1.44049e-06/
       DATA (KA_MO2(JT,16),JT=1,19)  /
     & 5.99001e-07, 6.16844e-07, 6.35219e-07, 6.54141e-07, 6.73626e-07,
     & 6.93692e-07, 7.14356e-07, 7.35635e-07, 7.57548e-07, 7.80114e-07,
     & 8.03352e-07, 8.27282e-07, 8.51925e-07, 8.77302e-07, 9.03435e-07,
     & 9.30347e-07, 9.58060e-07, 9.86599e-07, 1.01599e-06/
C     The array KB_Mxx contains the absorption coefficient for 
C     a minor species at the 16 chosen g-values for a reference pressure
C     level above 100~ mb.   The first index refers to temperature 
C     in 7.2 degree increments.  For instance, JT = 1 refers to a 
C     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
C     runs over the g-channel (1 to 16).
       DATA (KB_MO2(JT, 1),JT=1,19)  /
     & 4.97626e-07, 5.05955e-07, 5.14424e-07, 5.23034e-07, 5.31789e-07,
     & 5.40690e-07, 5.49739e-07, 5.58941e-07, 5.68296e-07, 5.77808e-07,
     & 5.87479e-07, 5.97312e-07, 6.07310e-07, 6.17475e-07, 6.27810e-07,
     & 6.38318e-07, 6.49002e-07, 6.59865e-07, 6.70910e-07/
       DATA (KB_MO2(JT, 2),JT=1,19)  /
     & 3.10232e-06, 3.06339e-06, 3.02496e-06, 2.98700e-06, 2.94952e-06,
     & 2.91252e-06, 2.87597e-06, 2.83989e-06, 2.80426e-06, 2.76907e-06,
     & 2.73433e-06, 2.70002e-06, 2.66614e-06, 2.63269e-06, 2.59966e-06,
     & 2.56704e-06, 2.53483e-06, 2.50303e-06, 2.47162e-06/
       DATA (KB_MO2(JT, 3),JT=1,19)  /
     & 2.91635e-06, 2.88637e-06, 2.85669e-06, 2.82733e-06, 2.79826e-06,
     & 2.76949e-06, 2.74102e-06, 2.71284e-06, 2.68495e-06, 2.65735e-06,
     & 2.63003e-06, 2.60299e-06, 2.57623e-06, 2.54975e-06, 2.52353e-06,
     & 2.49759e-06, 2.47191e-06, 2.44650e-06, 2.42135e-06/
       DATA (KB_MO2(JT, 4),JT=1,19)  /
     & 3.15584e-06, 3.11986e-06, 3.08430e-06, 3.04914e-06, 3.01438e-06,
     & 2.98002e-06, 2.94605e-06, 2.91247e-06, 2.87927e-06, 2.84645e-06,
     & 2.81400e-06, 2.78192e-06, 2.75021e-06, 2.71886e-06, 2.68787e-06,
     & 2.65723e-06, 2.62694e-06, 2.59699e-06, 2.56739e-06/
       DATA (KB_MO2(JT, 5),JT=1,19)  /
     & 2.52067e-06, 2.50127e-06, 2.48202e-06, 2.46291e-06, 2.44396e-06,
     & 2.42515e-06, 2.40648e-06, 2.38796e-06, 2.36958e-06, 2.35134e-06,
     & 2.33324e-06, 2.31529e-06, 2.29747e-06, 2.27978e-06, 2.26224e-06,
     & 2.24482e-06, 2.22755e-06, 2.21040e-06, 2.19339e-06/
       DATA (KB_MO2(JT, 6),JT=1,19)  /
     & 2.37304e-06, 2.36340e-06, 2.35380e-06, 2.34423e-06, 2.33471e-06,
     & 2.32522e-06, 2.31578e-06, 2.30637e-06, 2.29700e-06, 2.28766e-06,
     & 2.27837e-06, 2.26911e-06, 2.25989e-06, 2.25071e-06, 2.24157e-06,
     & 2.23246e-06, 2.22339e-06, 2.21436e-06, 2.20536e-06/
       DATA (KB_MO2(JT, 7),JT=1,19)  /
     & 2.56366e-06, 2.56395e-06, 2.56424e-06, 2.56453e-06, 2.56482e-06,
     & 2.56510e-06, 2.56539e-06, 2.56568e-06, 2.56597e-06, 2.56625e-06,
     & 2.56654e-06, 2.56683e-06, 2.56712e-06, 2.56741e-06, 2.56769e-06,
     & 2.56798e-06, 2.56827e-06, 2.56856e-06, 2.56885e-06/
       DATA (KB_MO2(JT, 8),JT=1,19)  /
     & 2.54502e-06, 2.55393e-06, 2.56287e-06, 2.57185e-06, 2.58085e-06,
     & 2.58989e-06, 2.59896e-06, 2.60806e-06, 2.61719e-06, 2.62636e-06,
     & 2.63555e-06, 2.64478e-06, 2.65404e-06, 2.66334e-06, 2.67266e-06,
     & 2.68202e-06, 2.69141e-06, 2.70084e-06, 2.71030e-06/
       DATA (KB_MO2(JT, 9),JT=1,19)  /
     & 1.84106e-06, 1.83922e-06, 1.83737e-06, 1.83553e-06, 1.83369e-06,
     & 1.83186e-06, 1.83002e-06, 1.82819e-06, 1.82636e-06, 1.82453e-06,
     & 1.82270e-06, 1.82087e-06, 1.81905e-06, 1.81723e-06, 1.81541e-06,
     & 1.81359e-06, 1.81177e-06, 1.80996e-06, 1.80814e-06/
       DATA (KB_MO2(JT,10),JT=1,19)  /
     & 1.83886e-06, 1.83632e-06, 1.83379e-06, 1.83126e-06, 1.82874e-06,
     & 1.82622e-06, 1.82370e-06, 1.82119e-06, 1.81868e-06, 1.81617e-06,
     & 1.81367e-06, 1.81117e-06, 1.80867e-06, 1.80618e-06, 1.80369e-06,
     & 1.80120e-06, 1.79872e-06, 1.79624e-06, 1.79377e-06/
       DATA (KB_MO2(JT,11),JT=1,19)  /
     & 2.30390e-06, 2.30269e-06, 2.30148e-06, 2.30028e-06, 2.29907e-06,
     & 2.29787e-06, 2.29667e-06, 2.29546e-06, 2.29426e-06, 2.29306e-06,
     & 2.29186e-06, 2.29066e-06, 2.28946e-06, 2.28826e-06, 2.28706e-06,
     & 2.28586e-06, 2.28466e-06, 2.28347e-06, 2.28227e-06/
       DATA (KB_MO2(JT,12),JT=1,19)  /
     & 2.38201e-06, 2.36536e-06, 2.34882e-06, 2.33240e-06, 2.31609e-06,
     & 2.29990e-06, 2.28382e-06, 2.26785e-06, 2.25199e-06, 2.23625e-06,
     & 2.22061e-06, 2.20508e-06, 2.18967e-06, 2.17436e-06, 2.15915e-06,
     & 2.14406e-06, 2.12907e-06, 2.11418e-06, 2.09940e-06/
       DATA (KB_MO2(JT,13),JT=1,19)  /
     & 2.33326e-06, 2.32549e-06, 2.31775e-06, 2.31003e-06, 2.30234e-06,
     & 2.29467e-06, 2.28703e-06, 2.27941e-06, 2.27182e-06, 2.26426e-06,
     & 2.25672e-06, 2.24920e-06, 2.24171e-06, 2.23424e-06, 2.22680e-06,
     & 2.21939e-06, 2.21200e-06, 2.20463e-06, 2.19729e-06/
       DATA (KB_MO2(JT,14),JT=1,19)  /
     & 2.75292e-06, 2.75210e-06, 2.75129e-06, 2.75047e-06, 2.74965e-06,
     & 2.74883e-06, 2.74801e-06, 2.74720e-06, 2.74638e-06, 2.74556e-06,
     & 2.74475e-06, 2.74393e-06, 2.74311e-06, 2.74230e-06, 2.74148e-06,
     & 2.74067e-06, 2.73985e-06, 2.73904e-06, 2.73822e-06/
       DATA (KB_MO2(JT,15),JT=1,19)  /
     & 2.55262e-06, 2.53364e-06, 2.51480e-06, 2.49611e-06, 2.47755e-06,
     & 2.45913e-06, 2.44084e-06, 2.42269e-06, 2.40468e-06, 2.38680e-06,
     & 2.36906e-06, 2.35144e-06, 2.33396e-06, 2.31660e-06, 2.29938e-06,
     & 2.28228e-06, 2.26531e-06, 2.24847e-06, 2.23175e-06/
       DATA (KB_MO2(JT,16),JT=1,19)  /
     & 3.11382e-06, 3.08751e-06, 3.06141e-06, 3.03554e-06, 3.00989e-06,
     & 2.98445e-06, 2.95923e-06, 2.93422e-06, 2.90942e-06, 2.88483e-06,
     & 2.86045e-06, 2.83628e-06, 2.81231e-06, 2.78854e-06, 2.76498e-06,
     & 2.74161e-06, 2.71844e-06, 2.69547e-06, 2.67269e-06/

C     The array FORREF contains the coefficient of the water vapor
C     foreign-continuum (including the energy term).  The first 
C     index refers to reference temperature (296,260,224,260) and 
C     pressure (970,475,219,3 mbar) levels.  The second index 
C     runs over the g-channel (1 to 16).
      DATA (FORREF(1,IG),IG=1,16) /
     &2.8858e-02,3.6879e-02,4.0746e-02,4.2561e-02,4.2740e-02,4.2707e-02,
     &4.4109e-02,4.4540e-02,4.5206e-02,4.4679e-02,4.5034e-02,4.5364e-02,
     &4.6790e-02,4.7857e-02,4.8328e-02,4.8084e-02/
      DATA (FORREF(2,IG),IG=1,16) /
     &2.7887e-02,3.7376e-02,4.0980e-02,4.2986e-02,4.3054e-02,4.2975e-02,
     &4.3754e-02,4.4352e-02,4.4723e-02,4.6236e-02,4.5273e-02,4.5360e-02,
     &4.5332e-02,4.7587e-02,4.7035e-02,5.0267e-02/
      DATA (FORREF(3,IG),IG=1,16) /
     &2.5846e-02,3.6753e-02,4.2334e-02,4.3806e-02,4.3848e-02,4.3215e-02,
     &4.3838e-02,4.4278e-02,4.4658e-02,4.5403e-02,4.5255e-02,4.6347e-02,
     &4.4722e-02,4.6612e-02,4.6836e-02,4.8720e-02/
      DATA (FORREF(4,IG),IG=1,16) /
     &2.8955e-02,3.7608e-02,4.1989e-02,4.4919e-02,4.2803e-02,4.2842e-02,
     &4.2632e-02,4.1056e-02,4.0086e-02,4.1401e-02,4.2746e-02,4.2142e-02,
     &4.1871e-02,4.3917e-02,4.5462e-02,4.8359e-02/

C     The array SELFREF contains the coefficient of the water vapor
C     self-continuum (including the energy term).  The first index
C     refers to temperature in 7.2 degree increments.  For instance,
C     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
C     etc.  The second index runs over the g-channel (1 to 16).

      DATA (SELFREF(JT, 1),JT=1,10)  /
     & 5.96496e-01, 5.49171e-01, 5.05600e-01, 4.65486e-01, 4.28555e-01,
     & 3.94554e-01, 3.63250e-01, 3.34430e-01, 3.07897e-01, 2.83468e-01/
      DATA (SELFREF(JT, 2),JT=1,10)  /
     & 7.46455e-01, 6.82459e-01, 6.23950e-01, 5.70457e-01, 5.21550e-01,
     & 4.76836e-01, 4.35956e-01, 3.98580e-01, 3.64409e-01, 3.33167e-01/
      DATA (SELFREF(JT, 3),JT=1,10)  /
     & 7.86805e-01, 7.21186e-01, 6.61040e-01, 6.05910e-01, 5.55378e-01,
     & 5.09059e-01, 4.66605e-01, 4.27690e-01, 3.92021e-01, 3.59327e-01/
      DATA (SELFREF(JT, 4),JT=1,10)  /
     & 8.11740e-01, 7.44359e-01, 6.82570e-01, 6.25910e-01, 5.73954e-01,
     & 5.26311e-01, 4.82622e-01, 4.42560e-01, 4.05823e-01, 3.72136e-01/
      DATA (SELFREF(JT, 5),JT=1,10)  /
     & 8.14870e-01, 7.47200e-01, 6.85150e-01, 6.28253e-01, 5.76081e-01,
     & 5.28241e-01, 4.84374e-01, 4.44150e-01, 4.07266e-01, 3.73446e-01/
      DATA (SELFREF(JT, 6),JT=1,10)  /
     & 8.10104e-01, 7.43259e-01, 6.81930e-01, 6.25661e-01, 5.74035e-01,
     & 5.26669e-01, 4.83212e-01, 4.43340e-01, 4.06758e-01, 3.73195e-01/
      DATA (SELFREF(JT, 7),JT=1,10)  /
     & 8.13119e-01, 7.48127e-01, 6.88330e-01, 6.33312e-01, 5.82692e-01,
     & 5.36118e-01, 4.93267e-01, 4.53840e-01, 4.17565e-01, 3.84189e-01/
      DATA (SELFREF(JT, 8),JT=1,10)  /
     & 8.26137e-01, 7.58984e-01, 6.97290e-01, 6.40611e-01, 5.88539e-01,
     & 5.40699e-01, 4.96748e-01, 4.56370e-01, 4.19274e-01, 3.85193e-01/
      DATA (SELFREF(JT, 9),JT=1,10)  /
     & 8.30566e-01, 7.63984e-01, 7.02740e-01, 6.46405e-01, 5.94587e-01,
     & 5.46922e-01, 5.03079e-01, 4.62750e-01, 4.25654e-01, 3.91532e-01/
      DATA (SELFREF(JT,10),JT=1,10)  /
     & 8.67471e-01, 7.91575e-01, 7.22320e-01, 6.59124e-01, 6.01457e-01,
     & 5.48835e-01, 5.00817e-01, 4.57000e-01, 4.17017e-01, 3.80532e-01/
      DATA (SELFREF(JT,11),JT=1,10)  /
     & 8.51029e-01, 7.79373e-01, 7.13750e-01, 6.53652e-01, 5.98615e-01,
     & 5.48212e-01, 5.02053e-01, 4.59780e-01, 4.21067e-01, 3.85613e-01/
      DATA (SELFREF(JT,12),JT=1,10)  /
     & 8.36772e-01, 7.68751e-01, 7.06260e-01, 6.48848e-01, 5.96104e-01,
     & 5.47647e-01, 5.03129e-01, 4.62230e-01, 4.24655e-01, 3.90136e-01/
      DATA (SELFREF(JT,13),JT=1,10)  /
     & 8.36551e-01, 7.71089e-01, 7.10750e-01, 6.55133e-01, 6.03867e-01,
     & 5.56614e-01, 5.13058e-01, 4.72910e-01, 4.35904e-01, 4.01794e-01/
      DATA (SELFREF(JT,14),JT=1,10)  /
     & 8.84307e-01, 8.11175e-01, 7.44090e-01, 6.82553e-01, 6.26106e-01,
     & 5.74326e-01, 5.26829e-01, 4.83260e-01, 4.43294e-01, 4.06633e-01/
      DATA (SELFREF(JT,15),JT=1,10)  /
     & 8.90356e-01, 8.19830e-01, 7.54890e-01, 6.95094e-01, 6.40035e-01,
     & 5.89337e-01, 5.42655e-01, 4.99670e-01, 4.60090e-01, 4.23646e-01/
      DATA (SELFREF(JT,16),JT=1,10)  /
     & 9.67549e-01, 8.79393e-01, 7.99270e-01, 7.26447e-01, 6.60259e-01,
     & 6.00101e-01, 5.45425e-01, 4.95730e-01, 4.50563e-01, 4.09511e-01/
