C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB12.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.0 $
C     created:   $Date: 2002/06/03 20:41:33 $
       PARAMETER (MG=16)
       DIMENSION SELFREF(10,MG), FORREF(4,MG)
       REAL KA(9,5,13,MG)

       COMMON /HVRSN12/ HVRKG12

       COMMON /K12/ KA, FORREF, SELFREF

       CHARACTER*15 HVRKG12
       DATA HVRKG12 /'$Revision: 3.0 $'/
C     The array KA contains absorption coefs for each of the 16 g-intervals
C     for a range of pressure levels > ~100mb, temperatures, and ratios
C     of water vapor to CO2.  The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.
C     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
C     to different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this  pressure 
C     level, JT = 2 refers to the temperature
C     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
C     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
C     to the reference pressure level (e.g. JP = 1 is for a
C     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA ((KA(JS,JT, 1, 1),JS=1,9),JT=1,5) /
     &1.7511E-07,6.8135E-05,1.1804E-04,1.6931E-04,2.2006E-04,2.8275E-04,
     &3.5722E-04,4.9530E-04,3.5719E-04,1.9831E-07,7.7459E-05,1.3459E-04,
     &1.9095E-04,2.5338E-04,3.1724E-04,4.1347E-04,5.5823E-04,4.1876E-04,
     &2.2440E-07,8.7653E-05,1.5288E-04,2.1636E-04,2.8321E-04,3.6387E-04,
     &4.5547E-04,6.4036E-04,4.9001E-04,2.4907E-07,9.8921E-05,1.7279E-04,
     &2.4495E-04,3.1911E-04,4.0317E-04,5.1922E-04,7.1060E-04,5.5803E-04,
     &2.7577E-07,1.1088E-04,1.9448E-04,2.7670E-04,3.6112E-04,4.5291E-04,
     &5.7232E-04,7.9647E-04,6.3718E-04/
      DATA ((KA(JS,JT, 2, 1),JS=1,9),JT=1,5) /
     &2.1743E-07,5.9697E-05,1.0011E-04,1.3856E-04,1.7837E-04,2.1937E-04,
     &2.7665E-04,3.5934E-04,2.6865E-04,2.4689E-07,6.8199E-05,1.1473E-04,
     &1.5826E-04,2.0299E-04,2.5265E-04,3.0999E-04,4.0941E-04,3.2103E-04,
     &2.7759E-07,7.7428E-05,1.3086E-04,1.8044E-04,2.2946E-04,2.8434E-04,
     &3.5412E-04,4.7313E-04,3.7455E-04,3.1162E-07,8.7312E-05,1.4837E-04,
     &2.0486E-04,2.6086E-04,3.2026E-04,3.9490E-04,5.1882E-04,4.3142E-04,
     &3.4483E-07,9.7902E-05,1.6760E-04,2.3163E-04,2.9600E-04,3.6332E-04,
     &4.4224E-04,5.8485E-04,4.9654E-04/
      DATA ((KA(JS,JT, 3, 1),JS=1,9),JT=1,5) /
     &3.5522E-07,5.4633E-05,8.9953E-05,1.1946E-04,1.4735E-04,1.7547E-04,
     &2.0438E-04,2.5064E-04,1.9532E-04,4.0312E-07,6.2965E-05,1.0335E-04,
     &1.3746E-04,1.6817E-04,1.9939E-04,2.3562E-04,2.9335E-04,2.3482E-04,
     &4.5344E-07,7.1817E-05,1.1822E-04,1.5709E-04,1.9287E-04,2.2736E-04,
     &2.6619E-04,3.2521E-04,2.7722E-04,5.1341E-07,8.1197E-05,1.3399E-04,
     &1.7909E-04,2.2021E-04,2.5936E-04,3.0089E-04,3.7007E-04,3.2243E-04,
     &5.7093E-07,9.0935E-05,1.5129E-04,2.0303E-04,2.4981E-04,2.9482E-04,
     &3.4243E-04,4.0910E-04,3.7408E-04/
      DATA ((KA(JS,JT, 4, 1),JS=1,9),JT=1,5) /
     &5.9029E-07,4.8269E-05,8.1661E-05,1.0687E-04,1.2826E-04,1.4610E-04,
     &1.6333E-04,1.8670E-04,1.4151E-04,6.7060E-07,5.6349E-05,9.4916E-05,
     &1.2365E-04,1.4803E-04,1.6776E-04,1.8719E-04,2.1036E-04,1.7196E-04,
     &7.5759E-07,6.4869E-05,1.0916E-04,1.4206E-04,1.6962E-04,1.9348E-04,
     &2.1325E-04,2.4238E-04,2.0611E-04,8.5937E-07,7.4063E-05,1.2416E-04,
     &1.6207E-04,1.9412E-04,2.2126E-04,2.4479E-04,2.7146E-04,2.4157E-04,
     &9.5897E-07,8.3687E-05,1.3973E-04,1.8364E-04,2.2051E-04,2.5234E-04,
     &2.7911E-04,3.0928E-04,2.8248E-04/
      DATA ((KA(JS,JT, 5, 1),JS=1,9),JT=1,5) /
     &9.1759E-07,4.1947E-05,7.0794E-05,9.4885E-05,1.1243E-04,1.2599E-04,
     &1.3683E-04,1.4293E-04,1.0336E-04,1.0425E-06,4.9113E-05,8.3728E-05,
     &1.1140E-04,1.3168E-04,1.4605E-04,1.5650E-04,1.6563E-04,1.2713E-04,
     &1.1835E-06,5.7263E-05,9.7394E-05,1.2924E-04,1.5190E-04,1.6881E-04,
     &1.8096E-04,1.8906E-04,1.5436E-04,1.3393E-06,6.6178E-05,1.1132E-04,
     &1.4759E-04,1.7411E-04,1.9396E-04,2.0764E-04,2.1628E-04,1.8190E-04,
     &1.4988E-06,7.5103E-05,1.2617E-04,1.6721E-04,1.9778E-04,2.2104E-04,
     &2.3789E-04,2.4796E-04,2.1416E-04/
      DATA ((KA(JS,JT, 6, 1),JS=1,9),JT=1,5) /
     &1.3509E-06,3.6190E-05,6.0186E-05,8.0089E-05,9.7447E-05,1.0817E-04,
     &1.1477E-04,1.1459E-04,7.5216E-05,1.5379E-06,4.3048E-05,7.1223E-05,
     &9.5429E-05,1.1555E-04,1.2778E-04,1.3385E-04,1.3550E-04,9.3747E-05,
     &1.7505E-06,5.0649E-05,8.3443E-05,1.1225E-04,1.3468E-04,1.4925E-04,
     &1.5516E-04,1.5522E-04,1.1566E-04,1.9769E-06,5.8613E-05,9.7176E-05,
     &1.2952E-04,1.5512E-04,1.7221E-04,1.7952E-04,1.7884E-04,1.3754E-04,
     &2.2201E-06,6.7356E-05,1.1202E-04,1.4825E-04,1.7722E-04,1.9650E-04,
     &2.0554E-04,2.0495E-04,1.6355E-04/
      DATA ((KA(JS,JT, 7, 1),JS=1,9),JT=1,5) /
     &2.1304E-06,3.3089E-05,5.1849E-05,6.8730E-05,8.2305E-05,9.3472E-05,
     &9.9164E-05,9.8631E-05,5.9418E-05,2.4308E-06,3.9636E-05,6.2051E-05,
     &8.1968E-05,9.8909E-05,1.1256E-04,1.1810E-04,1.1396E-04,7.5269E-05,
     &2.7537E-06,4.6821E-05,7.3795E-05,9.6812E-05,1.1738E-04,1.3274E-04,
     &1.3903E-04,1.3282E-04,9.2641E-05,3.1212E-06,5.4439E-05,8.6765E-05,
     &1.1374E-04,1.3694E-04,1.5474E-04,1.6192E-04,1.5375E-04,1.1184E-04,
     &3.5210E-06,6.2611E-05,9.9782E-05,1.3214E-04,1.5850E-04,1.7752E-04,
     &1.8622E-04,1.7734E-04,1.3357E-04/
      DATA ((KA(JS,JT, 8, 1),JS=1,9),JT=1,5) /
     &4.1180E-06,3.5356E-05,4.9875E-05,6.2112E-05,7.3272E-05,8.1665E-05,
     &8.7559E-05,8.6370E-05,4.9881E-05,4.6880E-06,4.2308E-05,6.0139E-05,
     &7.5108E-05,8.8001E-05,9.9269E-05,1.0597E-04,1.0409E-04,6.3232E-05,
     &5.2893E-06,4.9705E-05,7.1733E-05,8.9997E-05,1.0540E-04,1.1807E-04,
     &1.2729E-04,1.2367E-04,7.9488E-05,5.9934E-06,5.7629E-05,8.3852E-05,
     &1.0617E-04,1.2505E-04,1.3960E-04,1.5001E-04,1.4519E-04,9.7332E-05,
     &6.8016E-06,6.6193E-05,9.7237E-05,1.2349E-04,1.4561E-04,1.6359E-04,
     &1.7405E-04,1.6782E-04,1.1691E-04/
      DATA ((KA(JS,JT, 9, 1),JS=1,9),JT=1,5) /
     &1.5173E-05,6.0073E-05,7.5522E-05,8.4608E-05,8.9391E-05,9.1045E-05,
     &9.0015E-05,8.5089E-05,6.2916E-05,1.7118E-05,7.2165E-05,9.0975E-05,
     &1.0209E-04,1.0823E-04,1.1031E-04,1.0910E-04,1.0450E-04,8.0378E-05,
     &1.9333E-05,8.4779E-05,1.0715E-04,1.2042E-04,1.2865E-04,1.3251E-04,
     &1.3198E-04,1.2575E-04,1.0185E-04,2.2020E-05,9.7885E-05,1.2402E-04,
     &1.4031E-04,1.5091E-04,1.5615E-04,1.5775E-04,1.5010E-04,1.2495E-04,
     &2.4990E-05,1.1102E-04,1.4167E-04,1.6181E-04,1.7511E-04,1.8231E-04,
     &1.8406E-04,1.7738E-04,1.4891E-04/
      DATA ((KA(JS,JT,10, 1),JS=1,9),JT=1,5) /
     &6.3843E-05,1.3785E-04,1.5635E-04,1.6287E-04,1.6037E-04,1.5248E-04,
     &1.3606E-04,1.0761E-04,1.0144E-04,7.2156E-05,1.6111E-04,1.8530E-04,
     &1.9419E-04,1.9482E-04,1.8548E-04,1.6571E-04,1.3139E-04,1.2609E-04,
     &8.1633E-05,1.8623E-04,2.1467E-04,2.2993E-04,2.3146E-04,2.2096E-04,
     &1.9656E-04,1.5757E-04,1.5350E-04,9.2413E-05,2.1393E-04,2.4898E-04,
     &2.6688E-04,2.6838E-04,2.5715E-04,2.2901E-04,1.8640E-04,1.8257E-04,
     &1.0426E-04,2.4538E-04,2.8330E-04,3.0298E-04,3.0752E-04,2.9416E-04,
     &2.6511E-04,2.1835E-04,2.1288E-04/
      DATA ((KA(JS,JT,11, 1),JS=1,9),JT=1,5) /
     &9.9914E-05,1.8204E-04,1.9923E-04,2.0432E-04,1.9733E-04,1.8201E-04,
     &1.5904E-04,1.2299E-04,1.0910E-04,1.1199E-04,2.1265E-04,2.3389E-04,
     &2.4089E-04,2.3442E-04,2.2069E-04,1.9371E-04,1.4882E-04,1.3411E-04,
     &1.2687E-04,2.4499E-04,2.7026E-04,2.7909E-04,2.7675E-04,2.6044E-04,
     &2.2915E-04,1.7718E-04,1.6026E-04,1.4261E-04,2.8101E-04,3.1141E-04,
     &3.2255E-04,3.1948E-04,3.0150E-04,2.6612E-04,2.0752E-04,1.8601E-04,
     &1.5789E-04,3.1929E-04,3.5513E-04,3.6602E-04,3.6282E-04,3.4410E-04,
     &3.0577E-04,2.4097E-04,2.1352E-04/
      DATA ((KA(JS,JT,12, 1),JS=1,9),JT=1,5) /
     &1.1122E-04,1.9022E-04,2.0568E-04,2.0798E-04,2.0013E-04,1.8369E-04,
     &1.5756E-04,1.2037E-04,1.0098E-04,1.2500E-04,2.2156E-04,2.4046E-04,
     &2.4347E-04,2.3764E-04,2.2116E-04,1.9272E-04,1.4643E-04,1.2390E-04,
     &1.4056E-04,2.5489E-04,2.7764E-04,2.8122E-04,2.7905E-04,2.5886E-04,
     &2.2636E-04,1.7352E-04,1.4664E-04,1.5858E-04,2.9021E-04,3.1841E-04,
     &3.2551E-04,3.1903E-04,2.9848E-04,2.6254E-04,2.0265E-04,1.7061E-04,
     &1.7398E-04,3.2750E-04,3.6207E-04,3.6880E-04,3.6058E-04,3.3907E-04,
     &2.9970E-04,2.3401E-04,1.9575E-04/
      DATA ((KA(JS,JT,13, 1),JS=1,9),JT=1,5) /
     &9.9982E-05,1.6786E-04,1.8157E-04,1.8311E-04,1.7732E-04,1.6257E-04,
     &1.4107E-04,1.0684E-04,8.8282E-05,1.1208E-04,1.9489E-04,2.1207E-04,
     &2.1420E-04,2.0856E-04,1.9501E-04,1.6942E-04,1.2896E-04,1.0706E-04,
     &1.2580E-04,2.2390E-04,2.4368E-04,2.4899E-04,2.4426E-04,2.2695E-04,
     &1.9796E-04,1.5273E-04,1.2657E-04,1.4115E-04,2.5382E-04,2.8079E-04,
     &2.8499E-04,2.7843E-04,2.6072E-04,2.2903E-04,1.7905E-04,1.4711E-04,
     &1.5465E-04,2.8798E-04,3.1774E-04,3.2258E-04,3.1431E-04,2.9430E-04,
     &2.6133E-04,2.0499E-04,1.6802E-04/
      DATA ((KA(JS,JT, 1, 2),JS=1,9),JT=1,5) /
     &3.7683E-07,1.9808E-04,3.6685E-04,5.3916E-04,7.1167E-04,8.9309E-04,
     &1.1251E-03,1.6060E-03,1.3216E-03,4.2181E-07,2.2081E-04,4.0843E-04,
     &6.0005E-04,7.9854E-04,1.0235E-03,1.2747E-03,1.7730E-03,1.5072E-03,
     &4.6205E-07,2.4503E-04,4.5395E-04,6.6471E-04,8.8503E-04,1.1345E-03,
     &1.4567E-03,1.9804E-03,1.6670E-03,5.1491E-07,2.7069E-04,5.0378E-04,
     &7.3699E-04,9.7626E-04,1.2446E-03,1.5952E-03,2.2188E-03,1.8463E-03,
     &5.5977E-07,2.9608E-04,5.5719E-04,8.1557E-04,1.0806E-03,1.3738E-03,
     &1.7497E-03,2.4313E-03,2.0562E-03/
      DATA ((KA(JS,JT, 2, 2),JS=1,9),JT=1,5) /
     &4.7123E-07,1.6943E-04,3.0287E-04,4.3680E-04,5.7665E-04,7.0994E-04,
     &8.5911E-04,1.1308E-03,1.0172E-03,5.2931E-07,1.8961E-04,3.3976E-04,
     &4.8868E-04,6.4337E-04,8.0862E-04,9.8935E-04,1.2742E-03,1.1602E-03,
     &5.8844E-07,2.1120E-04,3.7935E-04,5.4606E-04,7.1722E-04,8.9758E-04,
     &1.1168E-03,1.4348E-03,1.3002E-03,6.4390E-07,2.3336E-04,4.2266E-04,
     &6.0899E-04,7.9911E-04,9.9511E-04,1.2304E-03,1.6357E-03,1.4539E-03,
     &7.0717E-07,2.5573E-04,4.6939E-04,6.7801E-04,8.8876E-04,1.1052E-03,
     &1.3595E-03,1.7810E-03,1.6268E-03/
      DATA ((KA(JS,JT, 3, 2),JS=1,9),JT=1,5) /
     &7.7382E-07,1.5592E-04,2.6004E-04,3.5917E-04,4.5597E-04,5.6221E-04,
     &6.6191E-04,7.8092E-04,7.5320E-04,8.7904E-07,1.7462E-04,2.9301E-04,
     &4.0553E-04,5.1639E-04,6.3236E-04,7.5999E-04,8.9592E-04,8.6804E-04,
     &9.8281E-07,1.9263E-04,3.2870E-04,4.5631E-04,5.8039E-04,7.0848E-04,
     &8.4867E-04,1.0369E-03,9.8463E-04,1.0791E-06,2.1196E-04,3.6740E-04,
     &5.1125E-04,6.5128E-04,7.9536E-04,9.4873E-04,1.1498E-03,1.1137E-03,
     &1.1811E-06,2.3314E-04,4.0444E-04,5.7096E-04,7.2953E-04,8.9019E-04,
     &1.0598E-03,1.2765E-03,1.2563E-03/
      DATA ((KA(JS,JT, 4, 2),JS=1,9),JT=1,5) /
     &1.2931E-06,1.5459E-04,2.3712E-04,3.1151E-04,3.8051E-04,4.4732E-04,
     &5.1939E-04,5.8139E-04,5.5932E-04,1.4961E-06,1.6924E-04,2.6743E-04,
     &3.5309E-04,4.3277E-04,5.1005E-04,5.8720E-04,6.8557E-04,6.5449E-04,
     &1.6687E-06,1.8668E-04,2.9946E-04,3.9815E-04,4.8978E-04,5.7712E-04,
     &6.6568E-04,7.7293E-04,7.4803E-04,1.8491E-06,2.0517E-04,3.2982E-04,
     &4.4741E-04,5.5202E-04,6.5205E-04,7.5198E-04,8.7064E-04,8.5540E-04,
     &2.0324E-06,2.2162E-04,3.6469E-04,4.9544E-04,6.1968E-04,7.3378E-04,
     &8.4769E-04,9.7614E-04,9.7197E-04/
      DATA ((KA(JS,JT, 5, 2),JS=1,9),JT=1,5) /
     &2.0065E-06,1.5150E-04,2.2968E-04,2.8386E-04,3.3168E-04,3.7581E-04,
     &4.1489E-04,4.5675E-04,4.1358E-04,2.3252E-06,1.6854E-04,2.5480E-04,
     &3.2081E-04,3.7754E-04,4.3026E-04,4.7606E-04,5.2820E-04,4.9368E-04,
     &2.6085E-06,1.8331E-04,2.8033E-04,3.6056E-04,4.2825E-04,4.8928E-04,
     &5.4309E-04,5.9807E-04,5.6993E-04,2.9132E-06,1.9761E-04,3.1015E-04,
     &3.9882E-04,4.8412E-04,5.5460E-04,6.1782E-04,6.7980E-04,6.5837E-04,
     &3.2361E-06,2.1434E-04,3.4118E-04,4.4180E-04,5.3752E-04,6.2588E-04,
     &6.9930E-04,7.7113E-04,7.5327E-04/
      DATA ((KA(JS,JT, 6, 2),JS=1,9),JT=1,5) /
     &2.9230E-06,1.3806E-04,2.1835E-04,2.7095E-04,3.0194E-04,3.2758E-04,
     &3.4587E-04,3.6408E-04,3.0468E-04,3.4021E-06,1.5365E-04,2.4578E-04,
     &3.0400E-04,3.4286E-04,3.7318E-04,3.9861E-04,4.1438E-04,3.7021E-04,
     &3.8620E-06,1.7051E-04,2.7334E-04,3.3438E-04,3.8715E-04,4.2432E-04,
     &4.5662E-04,4.7772E-04,4.3260E-04,4.2870E-06,1.8887E-04,2.9668E-04,
     &3.7137E-04,4.2886E-04,4.8133E-04,5.2053E-04,5.4689E-04,5.0258E-04,
     &4.8423E-06,2.0662E-04,3.1977E-04,4.1089E-04,4.7609E-04,5.3742E-04,
     &5.9126E-04,6.2337E-04,5.7823E-04/
      DATA ((KA(JS,JT, 7, 2),JS=1,9),JT=1,5) /
     &4.5404E-06,1.3143E-04,2.0727E-04,2.6052E-04,2.9635E-04,3.0743E-04,
     &3.0825E-04,2.9703E-04,2.2197E-04,5.2640E-06,1.4772E-04,2.3068E-04,
     &2.9687E-04,3.3184E-04,3.4986E-04,3.5249E-04,3.4543E-04,2.7330E-04,
     &6.0466E-06,1.6470E-04,2.5696E-04,3.3234E-04,3.6914E-04,3.9626E-04,
     &4.0246E-04,3.9902E-04,3.2329E-04,6.7565E-06,1.8107E-04,2.8421E-04,
     &3.6286E-04,4.1183E-04,4.3876E-04,4.5748E-04,4.5835E-04,3.7913E-04,
     &7.6474E-06,1.9867E-04,3.1475E-04,3.9310E-04,4.5438E-04,4.8957E-04,
     &5.1385E-04,5.2320E-04,4.4016E-04/
      DATA ((KA(JS,JT, 8, 2),JS=1,9),JT=1,5) /
     &8.6520E-06,1.4110E-04,2.0496E-04,2.5993E-04,2.9742E-04,3.1821E-04,
     &3.1456E-04,2.7649E-04,1.8485E-04,1.0009E-05,1.5517E-04,2.3206E-04,
     &2.9171E-04,3.4405E-04,3.6414E-04,3.5939E-04,3.1713E-04,2.2424E-04,
     &1.1509E-05,1.7205E-04,2.6018E-04,3.2636E-04,3.8244E-04,4.1241E-04,
     &4.0304E-04,3.6377E-04,2.6821E-04,1.3117E-05,1.8959E-04,2.8945E-04,
     &3.6544E-04,4.2147E-04,4.5788E-04,4.4922E-04,4.1527E-04,3.1806E-04,
     &1.4790E-05,2.0902E-04,3.1840E-04,4.0603E-04,4.6521E-04,4.9945E-04,
     &5.0220E-04,4.7045E-04,3.7190E-04/
      DATA ((KA(JS,JT, 9, 2),JS=1,9),JT=1,5) /
     &3.0998E-05,2.0637E-04,2.7947E-04,3.3530E-04,3.6480E-04,3.8205E-04,
     &3.8653E-04,3.4762E-04,1.8242E-04,3.6096E-05,2.3076E-04,3.1240E-04,
     &3.7284E-04,4.1471E-04,4.3432E-04,4.4125E-04,4.0372E-04,2.2363E-04,
     &4.2035E-05,2.5734E-04,3.4822E-04,4.1425E-04,4.6570E-04,4.9153E-04,
     &4.9534E-04,4.6243E-04,2.6686E-04,4.8029E-05,2.8335E-04,3.8624E-04,
     &4.5968E-04,5.1473E-04,5.5196E-04,5.5517E-04,5.1807E-04,3.1577E-04,
     &5.5331E-05,3.0966E-04,4.2837E-04,5.0793E-04,5.6875E-04,6.0971E-04,
     &6.2368E-04,5.6511E-04,3.7171E-04/
      DATA ((KA(JS,JT,10, 2),JS=1,9),JT=1,5) /
     &1.2964E-04,4.0632E-04,5.1358E-04,5.5581E-04,5.6980E-04,5.6112E-04,
     &5.2892E-04,4.3728E-04,2.8865E-04,1.5095E-04,4.5953E-04,5.7199E-04,
     &6.2596E-04,6.3988E-04,6.3023E-04,5.9124E-04,5.0100E-04,3.5610E-04,
     &1.7573E-04,5.1815E-04,6.3409E-04,6.9698E-04,7.1541E-04,7.0519E-04,
     &6.6061E-04,5.7112E-04,4.2862E-04,2.0254E-04,5.7408E-04,7.0140E-04,
     &7.6485E-04,7.9509E-04,7.8487E-04,7.3767E-04,6.4340E-04,5.0196E-04,
     &2.3735E-04,6.3435E-04,7.7477E-04,8.4107E-04,8.7369E-04,8.7290E-04,
     &8.2035E-04,7.1353E-04,5.7378E-04/
      DATA ((KA(JS,JT,11, 2),JS=1,9),JT=1,5) /
     &2.0611E-04,5.0579E-04,6.0906E-04,6.6598E-04,6.7463E-04,6.4325E-04,
     &5.7358E-04,4.6594E-04,3.7105E-04,2.4168E-04,5.7457E-04,6.8930E-04,
     &7.4695E-04,7.5788E-04,7.2324E-04,6.4676E-04,5.2943E-04,4.4283E-04,
     &2.7855E-04,6.5109E-04,7.7336E-04,8.3624E-04,8.3721E-04,8.0652E-04,
     &7.2648E-04,5.9132E-04,5.1523E-04,3.2934E-04,7.2843E-04,8.5922E-04,
     &9.2211E-04,9.2829E-04,8.9207E-04,8.1359E-04,6.5969E-04,5.9146E-04,
     &3.7624E-04,8.0764E-04,9.4816E-04,1.0176E-03,1.0267E-03,9.8589E-04,
     &9.0003E-04,7.3360E-04,6.6373E-04/
      DATA ((KA(JS,JT,12, 2),JS=1,9),JT=1,5) /
     &2.3690E-04,5.2345E-04,6.1583E-04,6.6206E-04,6.7308E-04,6.4411E-04,
     &5.7108E-04,4.4594E-04,3.6966E-04,2.7636E-04,5.9693E-04,6.9824E-04,
     &7.5086E-04,7.5372E-04,7.2129E-04,6.4015E-04,5.0417E-04,4.3519E-04,
     &3.2475E-04,6.7274E-04,7.7976E-04,8.4185E-04,8.4051E-04,8.0110E-04,
     &7.2036E-04,5.6771E-04,5.0173E-04,3.7742E-04,7.5354E-04,8.6958E-04,
     &9.2971E-04,9.3567E-04,8.9034E-04,7.9942E-04,6.3511E-04,5.6743E-04,
     &4.2656E-04,8.3460E-04,9.6197E-04,1.0276E-03,1.0348E-03,9.8795E-04,
     &8.8414E-04,7.0917E-04,6.3181E-04/
      DATA ((KA(JS,JT,13, 2),JS=1,9),JT=1,5) /
     &2.1559E-04,4.7034E-04,5.5318E-04,5.8764E-04,5.9246E-04,5.7342E-04,
     &5.0467E-04,3.9184E-04,3.4198E-04,2.5152E-04,5.3422E-04,6.2195E-04,
     &6.6659E-04,6.7272E-04,6.3853E-04,5.7068E-04,4.4436E-04,3.9456E-04,
     &3.0302E-04,6.0127E-04,6.9437E-04,7.4686E-04,7.5249E-04,7.1183E-04,
     &6.4004E-04,5.0162E-04,4.4714E-04,3.4242E-04,6.7081E-04,7.7273E-04,
     &8.2774E-04,8.3533E-04,7.9499E-04,7.1004E-04,5.6394E-04,5.0105E-04,
     &3.8220E-04,7.4575E-04,8.5383E-04,9.1037E-04,9.2303E-04,8.8587E-04,
     &7.8559E-04,6.3207E-04,5.5475E-04/
      DATA ((KA(JS,JT, 1, 3),JS=1,9),JT=1,5) /
     &5.3797E-07,4.8188E-04,8.9729E-04,1.3200E-03,1.7770E-03,2.3291E-03,
     &3.1122E-03,4.4511E-03,3.5150E-03,6.1262E-07,5.2615E-04,9.8845E-04,
     &1.4517E-03,1.9408E-03,2.5148E-03,3.2963E-03,4.8584E-03,3.8321E-03,
     &7.0635E-07,5.6647E-04,1.0753E-03,1.5925E-03,2.1392E-03,2.7441E-03,
     &3.5300E-03,5.0419E-03,4.2299E-03,7.6766E-07,6.0727E-04,1.1623E-03,
     &1.7247E-03,2.3255E-03,3.0054E-03,3.8553E-03,5.3163E-03,4.6081E-03,
     &8.3851E-07,6.4796E-04,1.2484E-03,1.8617E-03,2.5127E-03,3.2521E-03,
     &4.1787E-03,5.7407E-03,4.9828E-03/
      DATA ((KA(JS,JT, 2, 3),JS=1,9),JT=1,5) /
     &6.9858E-07,4.1220E-04,7.5871E-04,1.0893E-03,1.4250E-03,1.8069E-03,
     &2.3218E-03,3.2208E-03,2.7451E-03,8.1006E-07,4.4690E-04,8.3751E-04,
     &1.2083E-03,1.5781E-03,1.9758E-03,2.4966E-03,3.4638E-03,3.0268E-03,
     &9.0719E-07,4.8245E-04,9.0580E-04,1.3167E-03,1.7362E-03,2.1788E-03,
     &2.7148E-03,3.6613E-03,3.3476E-03,9.9070E-07,5.1202E-04,9.7859E-04,
     &1.4272E-03,1.8822E-03,2.3784E-03,2.9761E-03,3.9189E-03,3.6534E-03,
     &1.0800E-06,5.4986E-04,1.0443E-03,1.5370E-03,2.0346E-03,2.5754E-03,
     &3.2289E-03,4.2581E-03,3.9665E-03/
      DATA ((KA(JS,JT, 3, 3),JS=1,9),JT=1,5) /
     &1.1956E-06,3.6533E-04,6.4857E-04,9.1797E-04,1.1753E-03,1.4236E-03,
     &1.7165E-03,2.2362E-03,2.0894E-03,1.3685E-06,3.9659E-04,7.1084E-04,
     &1.0164E-03,1.3082E-03,1.5859E-03,1.8841E-03,2.3586E-03,2.3274E-03,
     &1.5093E-06,4.2397E-04,7.7009E-04,1.1048E-03,1.4344E-03,1.7565E-03,
     &2.0870E-03,2.5514E-03,2.5907E-03,1.6732E-06,4.5580E-04,8.2534E-04,
     &1.1953E-03,1.5533E-03,1.9057E-03,2.2804E-03,2.8031E-03,2.8387E-03,
     &1.8304E-06,4.8851E-04,8.8340E-04,1.2735E-03,1.6704E-03,2.0642E-03,
     &2.4727E-03,3.0561E-03,3.0939E-03/
      DATA ((KA(JS,JT, 4, 3),JS=1,9),JT=1,5) /
     &2.0440E-06,3.4190E-04,5.7528E-04,7.8555E-04,9.8576E-04,1.1789E-03,
     &1.3557E-03,1.6128E-03,1.5891E-03,2.2803E-06,3.6626E-04,6.2613E-04,
     &8.6621E-04,1.0945E-03,1.3150E-03,1.5191E-03,1.7412E-03,1.7827E-03,
     &2.5344E-06,3.9307E-04,6.7511E-04,9.4372E-04,1.1954E-03,1.4474E-03,
     &1.6882E-03,1.9262E-03,2.0030E-03,2.8636E-06,4.1974E-04,7.2769E-04,
     &1.0153E-03,1.2977E-03,1.5716E-03,1.8427E-03,2.1315E-03,2.2084E-03,
     &3.0668E-06,4.5207E-04,7.8267E-04,1.0885E-03,1.3854E-03,1.6897E-03,
     &1.9964E-03,2.3147E-03,2.4195E-03/
      DATA ((KA(JS,JT, 5, 3),JS=1,9),JT=1,5) /
     &3.1319E-06,3.2418E-04,5.2433E-04,6.9885E-04,8.4707E-04,9.8232E-04,
     &1.1112E-03,1.2410E-03,1.2226E-03,3.5295E-06,3.4929E-04,5.6868E-04,
     &7.6274E-04,9.3852E-04,1.0972E-03,1.2472E-03,1.3812E-03,1.3798E-03,
     &3.9745E-06,3.7641E-04,6.1261E-04,8.2611E-04,1.0255E-03,1.2065E-03,
     &1.3836E-03,1.5454E-03,1.5563E-03,4.4389E-06,4.0602E-04,6.5760E-04,
     &8.9247E-04,1.1052E-03,1.3151E-03,1.5074E-03,1.7081E-03,1.7334E-03,
     &4.7663E-06,4.3568E-04,7.0547E-04,9.6253E-04,1.1901E-03,1.4105E-03,
     &1.6319E-03,1.8559E-03,1.9044E-03/
      DATA ((KA(JS,JT, 6, 3),JS=1,9),JT=1,5) /
     &4.5500E-06,3.2085E-04,4.8959E-04,6.2597E-04,7.4855E-04,8.4386E-04,
     &9.2463E-04,9.8196E-04,9.3322E-04,5.1832E-06,3.4894E-04,5.2646E-04,
     &6.8892E-04,8.2642E-04,9.4419E-04,1.0344E-03,1.1120E-03,1.0567E-03,
     &5.7454E-06,3.7624E-04,5.6596E-04,7.4193E-04,8.9866E-04,1.0339E-03,
     &1.1478E-03,1.2434E-03,1.1989E-03,6.4183E-06,4.0049E-04,6.1119E-04,
     &7.9917E-04,9.7241E-04,1.1206E-03,1.2562E-03,1.3721E-03,1.3554E-03,
     &6.9324E-06,4.2668E-04,6.6038E-04,8.5368E-04,1.0486E-03,1.2116E-03,
     &1.3599E-03,1.5001E-03,1.5043E-03/
      DATA ((KA(JS,JT, 7, 3),JS=1,9),JT=1,5) /
     &7.2797E-06,3.0677E-04,4.8071E-04,5.9971E-04,6.8742E-04,7.5672E-04,
     &8.0124E-04,8.1058E-04,7.0953E-04,8.1177E-06,3.3920E-04,5.2455E-04,
     &6.4489E-04,7.6436E-04,8.4338E-04,9.0408E-04,9.2147E-04,8.0482E-04,
     &8.9509E-06,3.6425E-04,5.6797E-04,6.9667E-04,8.2046E-04,9.2590E-04,
     &9.9874E-04,1.0317E-03,9.2280E-04,9.9962E-06,3.8975E-04,6.1216E-04,
     &7.5517E-04,8.8215E-04,1.0000E-03,1.0895E-03,1.1382E-03,1.0492E-03,
     &1.0669E-05,4.1752E-04,6.5205E-04,8.1765E-04,9.5018E-04,1.0745E-03,
     &1.1767E-03,1.2498E-03,1.1757E-03/
      DATA ((KA(JS,JT, 8, 3),JS=1,9),JT=1,5) /
     &1.3269E-05,3.0208E-04,4.8542E-04,6.1720E-04,7.0751E-04,7.5832E-04,
     &7.5956E-04,7.2658E-04,5.2753E-04,1.5282E-05,3.2807E-04,5.3968E-04,
     &6.8467E-04,7.6733E-04,8.2175E-04,8.4708E-04,8.2655E-04,6.1209E-04,
     &1.6919E-05,3.5455E-04,5.8673E-04,7.5006E-04,8.3417E-04,8.8820E-04,
     &9.3120E-04,9.2583E-04,7.0621E-04,1.8616E-05,3.8664E-04,6.2653E-04,
     &8.0927E-04,9.0712E-04,9.6236E-04,1.0056E-03,1.0184E-03,8.0931E-04,
     &2.0327E-05,4.2321E-04,6.7354E-04,8.6755E-04,9.7906E-04,1.0424E-03,
     &1.0862E-03,1.0982E-03,9.1316E-04/
      DATA ((KA(JS,JT, 9, 3),JS=1,9),JT=1,5) /
     &5.0114E-05,4.1653E-04,5.9063E-04,7.3539E-04,8.5123E-04,9.2178E-04,
     &9.4309E-04,8.5391E-04,5.1499E-04,5.7273E-05,4.5656E-04,6.4069E-04,
     &7.9699E-04,9.4296E-04,1.0365E-03,1.0446E-03,9.3220E-04,6.0883E-04,
     &6.4035E-05,4.9861E-04,7.0653E-04,8.6985E-04,1.0116E-03,1.1468E-03,
     &1.1543E-03,1.0092E-03,7.0553E-04,7.2188E-05,5.4617E-04,7.8095E-04,
     &9.4772E-04,1.1003E-03,1.2322E-03,1.2562E-03,1.0988E-03,7.9526E-04,
     &7.9550E-05,6.0184E-04,8.5464E-04,1.0416E-03,1.1956E-03,1.3190E-03,
     &1.3528E-03,1.1984E-03,8.7997E-04/
      DATA ((KA(JS,JT,10, 3),JS=1,9),JT=1,5) /
     &2.3306E-04,7.9772E-04,9.8566E-04,1.1183E-03,1.1737E-03,1.1902E-03,
     &1.1793E-03,1.0698E-03,6.6407E-04,2.6771E-04,8.8993E-04,1.0956E-03,
     &1.2259E-03,1.2971E-03,1.3020E-03,1.2785E-03,1.2036E-03,7.5718E-04,
     &3.0294E-04,9.8041E-04,1.2123E-03,1.3475E-03,1.4168E-03,1.4273E-03,
     &1.4006E-03,1.3282E-03,8.5838E-04,3.4186E-04,1.0838E-03,1.3329E-03,
     &1.4855E-03,1.5514E-03,1.5775E-03,1.5302E-03,1.4297E-03,9.7732E-04,
     &3.7940E-04,1.2006E-03,1.4657E-03,1.6333E-03,1.7070E-03,1.7269E-03,
     &1.6832E-03,1.5552E-03,1.1108E-03/
      DATA ((KA(JS,JT,11, 3),JS=1,9),JT=1,5) /
     &4.1370E-04,1.0481E-03,1.2382E-03,1.3193E-03,1.3405E-03,1.3128E-03,
     &1.2136E-03,1.0530E-03,7.9947E-04,4.6551E-04,1.1702E-03,1.3813E-03,
     &1.4636E-03,1.4831E-03,1.4472E-03,1.3317E-03,1.1447E-03,9.1716E-04,
     &5.2337E-04,1.3114E-03,1.5380E-03,1.6111E-03,1.6417E-03,1.5910E-03,
     &1.4641E-03,1.2585E-03,1.0575E-03,5.8236E-04,1.4612E-03,1.6981E-03,
     &1.7829E-03,1.8015E-03,1.7452E-03,1.6069E-03,1.3761E-03,1.2010E-03,
     &6.7131E-04,1.6254E-03,1.8811E-03,1.9666E-03,1.9744E-03,1.9137E-03,
     &1.7677E-03,1.5105E-03,1.3428E-03/
      DATA ((KA(JS,JT,12, 3),JS=1,9),JT=1,5) /
     &5.0548E-04,1.1217E-03,1.2964E-03,1.3785E-03,1.3692E-03,1.2935E-03,
     &1.1705E-03,9.6704E-04,8.2680E-04,5.7320E-04,1.2560E-03,1.4612E-03,
     &1.5290E-03,1.5133E-03,1.4345E-03,1.2992E-03,1.0595E-03,9.5961E-04,
     &6.3853E-04,1.4125E-03,1.6378E-03,1.6918E-03,1.6663E-03,1.5909E-03,
     &1.4283E-03,1.1648E-03,1.0789E-03,7.1367E-04,1.5888E-03,1.8194E-03,
     &1.8745E-03,1.8358E-03,1.7471E-03,1.5691E-03,1.2862E-03,1.2039E-03,
     &8.2207E-04,1.7742E-03,2.0103E-03,2.0603E-03,2.0193E-03,1.9194E-03,
     &1.7244E-03,1.4199E-03,1.3514E-03/
      DATA ((KA(JS,JT,13, 3),JS=1,9),JT=1,5) /
     &5.0420E-04,1.0317E-03,1.1965E-03,1.2627E-03,1.2425E-03,1.1623E-03,
     &1.0397E-03,8.4556E-04,7.6156E-04,5.6808E-04,1.1670E-03,1.3463E-03,
     &1.4009E-03,1.3701E-03,1.2956E-03,1.1567E-03,9.3024E-04,8.8050E-04,
     &6.1838E-04,1.3214E-03,1.5180E-03,1.5502E-03,1.5020E-03,1.4361E-03,
     &1.2780E-03,1.0272E-03,9.9967E-04,7.0527E-04,1.4908E-03,1.6794E-03,
     &1.7102E-03,1.6621E-03,1.5793E-03,1.4142E-03,1.1355E-03,1.1267E-03,
     &8.1247E-04,1.6340E-03,1.8549E-03,1.8870E-03,1.8374E-03,1.7298E-03,
     &1.5606E-03,1.2534E-03,1.2510E-03/
      DATA ((KA(JS,JT, 1, 4),JS=1,9),JT=1,5) /
     &7.9349E-07,1.0718E-03,2.1076E-03,3.1773E-03,4.3493E-03,5.6505E-03,
     &7.2449E-03,1.0124E-02,8.6807E-03,7.9171E-07,1.1405E-03,2.2617E-03,
     &3.4209E-03,4.6727E-03,6.0666E-03,7.8396E-03,1.0702E-02,9.3285E-03,
     &8.3534E-07,1.2022E-03,2.3697E-03,3.6079E-03,4.9651E-03,6.4864E-03,
     &8.3654E-03,1.1513E-02,9.9193E-03,9.5267E-07,1.2723E-03,2.4978E-03,
     &3.7943E-03,5.1994E-03,6.8025E-03,8.8715E-03,1.2190E-02,1.0375E-02,
     &1.1458E-06,1.3554E-03,2.6484E-03,4.0109E-03,5.4856E-03,7.1578E-03,
     &9.2726E-03,1.2904E-02,1.0954E-02/
      DATA ((KA(JS,JT, 2, 4),JS=1,9),JT=1,5) /
     &9.1454E-07,9.0539E-04,1.7315E-03,2.5817E-03,3.4611E-03,4.4469E-03,
     &5.5705E-03,7.4448E-03,6.8782E-03,9.5187E-07,9.6041E-04,1.8588E-03,
     &2.7755E-03,3.7306E-03,4.7775E-03,6.0319E-03,7.9894E-03,7.4238E-03,
     &1.1150E-06,1.0164E-03,1.9573E-03,2.9264E-03,3.9480E-03,5.1214E-03,
     &6.4611E-03,8.5702E-03,7.8654E-03,1.3385E-06,1.0876E-03,2.0659E-03,
     &3.0814E-03,4.1574E-03,5.3507E-03,6.8052E-03,9.1287E-03,8.2842E-03,
     &1.6022E-06,1.1568E-03,2.2052E-03,3.2703E-03,4.4002E-03,5.6510E-03,
     &7.1684E-03,9.6207E-03,8.7667E-03/
      DATA ((KA(JS,JT, 3, 4),JS=1,9),JT=1,5) /
     &1.5574E-06,7.6371E-04,1.4483E-03,2.1006E-03,2.7598E-03,3.4620E-03,
     &4.1959E-03,5.2056E-03,5.3344E-03,1.7591E-06,8.1114E-04,1.5471E-03,
     &2.2761E-03,2.9860E-03,3.7307E-03,4.5489E-03,5.7315E-03,5.7929E-03,
     &2.0958E-06,8.7335E-04,1.6413E-03,2.3988E-03,3.1565E-03,3.9689E-03,
     &4.8920E-03,6.1466E-03,6.1501E-03,2.4948E-06,9.3193E-04,1.7550E-03,
     &2.5427E-03,3.3388E-03,4.1838E-03,5.1384E-03,6.5670E-03,6.5006E-03,
     &2.9808E-06,9.8734E-04,1.8752E-03,2.7256E-03,3.5562E-03,4.4297E-03,
     &5.4345E-03,6.8804E-03,6.9100E-03/
      DATA ((KA(JS,JT, 4, 4),JS=1,9),JT=1,5) /
     &2.8339E-06,6.5550E-04,1.2204E-03,1.7505E-03,2.2569E-03,2.7626E-03,
     &3.2755E-03,3.8524E-03,4.1315E-03,3.2988E-06,7.0845E-04,1.2966E-03,
     &1.8754E-03,2.4581E-03,3.0020E-03,3.5639E-03,4.2448E-03,4.5130E-03,
     &3.9491E-06,7.6198E-04,1.3871E-03,1.9942E-03,2.6023E-03,3.1978E-03,
     &3.8488E-03,4.5802E-03,4.8443E-03,4.6425E-06,8.1982E-04,1.4902E-03,
     &2.1380E-03,2.7710E-03,3.3974E-03,4.0487E-03,4.8659E-03,5.1413E-03,
     &5.6265E-06,8.8017E-04,1.5882E-03,2.2893E-03,2.9763E-03,3.6352E-03,
     &4.2916E-03,5.1439E-03,5.4622E-03/
      DATA ((KA(JS,JT, 5, 4),JS=1,9),JT=1,5) /
     &4.8447E-06,5.8594E-04,1.0296E-03,1.4656E-03,1.8696E-03,2.2619E-03,
     &2.6388E-03,3.0084E-03,3.1950E-03,5.5680E-06,6.3350E-04,1.1054E-03,
     &1.5640E-03,2.0148E-03,2.4702E-03,2.8772E-03,3.3130E-03,3.5193E-03,
     &6.5723E-06,6.8615E-04,1.1977E-03,1.6753E-03,2.1497E-03,2.6254E-03,
     &3.0969E-03,3.5912E-03,3.8422E-03,7.8530E-06,7.4277E-04,1.2884E-03,
     &1.8101E-03,2.3101E-03,2.7992E-03,3.2952E-03,3.8151E-03,4.0689E-03,
     &9.4527E-06,8.0105E-04,1.3871E-03,1.9371E-03,2.4908E-03,3.0121E-03,
     &3.5288E-03,4.0532E-03,4.3486E-03/
      DATA ((KA(JS,JT, 6, 4),JS=1,9),JT=1,5) /
     &7.9687E-06,5.4507E-04,8.9513E-04,1.2382E-03,1.5589E-03,1.8510E-03,
     &2.1398E-03,2.3860E-03,2.4635E-03,8.8712E-06,5.9098E-04,9.7039E-04,
     &1.3235E-03,1.6755E-03,2.0285E-03,2.3501E-03,2.6411E-03,2.7555E-03,
     &1.0300E-05,6.3947E-04,1.0497E-03,1.4366E-03,1.7944E-03,2.1608E-03,
     &2.5184E-03,2.8809E-03,3.0211E-03,1.2171E-05,6.9277E-04,1.1370E-03,
     &1.5510E-03,1.9450E-03,2.3217E-03,2.6890E-03,3.0692E-03,3.2284E-03,
     &1.4564E-05,7.4600E-04,1.2318E-03,1.6801E-03,2.0948E-03,2.5115E-03,
     &2.8923E-03,3.2756E-03,3.4483E-03/
      DATA ((KA(JS,JT, 7, 4),JS=1,9),JT=1,5) /
     &1.3302E-05,5.5386E-04,8.3382E-04,1.0993E-03,1.3564E-03,1.5663E-03,
     &1.7522E-03,1.9212E-03,1.8928E-03,1.5137E-05,6.0362E-04,9.0303E-04,
     &1.1816E-03,1.4350E-03,1.6949E-03,1.9391E-03,2.1345E-03,2.1400E-03,
     &1.7393E-05,6.5556E-04,9.7760E-04,1.2752E-03,1.5638E-03,1.8142E-03,
     &2.0760E-03,2.3419E-03,2.3618E-03,2.0190E-05,7.0877E-04,1.0583E-03,
     &1.3832E-03,1.6934E-03,1.9720E-03,2.2273E-03,2.4896E-03,2.5682E-03,
     &2.3865E-05,7.6246E-04,1.1476E-03,1.5003E-03,1.8325E-03,2.1363E-03,
     &2.4216E-03,2.6647E-03,2.7377E-03/
      DATA ((KA(JS,JT, 8, 4),JS=1,9),JT=1,5) /
     &2.8723E-05,5.8785E-04,8.8654E-04,1.0769E-03,1.2579E-03,1.4310E-03,
     &1.5394E-03,1.5987E-03,1.4479E-03,3.1951E-05,6.5934E-04,9.7493E-04,
     &1.1672E-03,1.3594E-03,1.5243E-03,1.6749E-03,1.7779E-03,1.6535E-03,
     &3.6028E-05,7.3349E-04,1.0597E-03,1.2704E-03,1.4675E-03,1.6499E-03,
     &1.7965E-03,1.9280E-03,1.8443E-03,4.1972E-05,7.9901E-04,1.1534E-03,
     &1.3845E-03,1.5898E-03,1.7819E-03,1.9610E-03,2.0652E-03,2.0278E-03,
     &4.8818E-05,8.6068E-04,1.2469E-03,1.5029E-03,1.7252E-03,1.9359E-03,
     &2.1153E-03,2.2493E-03,2.1613E-03/
      DATA ((KA(JS,JT, 9, 4),JS=1,9),JT=1,5) /
     &1.2151E-04,7.9394E-04,1.1551E-03,1.4165E-03,1.6142E-03,1.6912E-03,
     &1.6602E-03,1.6194E-03,1.1991E-03,1.3408E-04,8.8305E-04,1.2970E-03,
     &1.6023E-03,1.7938E-03,1.8665E-03,1.8031E-03,1.7264E-03,1.3714E-03,
     &1.5040E-04,9.7901E-04,1.4287E-03,1.7867E-03,2.0033E-03,2.0339E-03,
     &1.9620E-03,1.8611E-03,1.5284E-03,1.6901E-04,1.0844E-03,1.5638E-03,
     &1.9651E-03,2.1812E-03,2.2146E-03,2.1459E-03,2.0086E-03,1.6589E-03,
     &1.9165E-04,1.1941E-03,1.7106E-03,2.1260E-03,2.3624E-03,2.4142E-03,
     &2.3405E-03,2.1792E-03,1.8085E-03/
      DATA ((KA(JS,JT,10, 4),JS=1,9),JT=1,5) /
     &5.9868E-04,1.5993E-03,1.9364E-03,2.1129E-03,2.2524E-03,2.3246E-03,
     &2.2594E-03,2.0146E-03,1.3568E-03,6.6752E-04,1.7567E-03,2.1277E-03,
     &2.3435E-03,2.4977E-03,2.6109E-03,2.5681E-03,2.2608E-03,1.5177E-03,
     &7.4901E-04,1.9228E-03,2.3324E-03,2.5957E-03,2.7706E-03,2.8949E-03,
     &2.8715E-03,2.4740E-03,1.6681E-03,8.4268E-04,2.1035E-03,2.5651E-03,
     &2.8675E-03,3.0553E-03,3.1760E-03,3.1745E-03,2.7207E-03,1.8575E-03,
     &9.4245E-04,2.2879E-03,2.8080E-03,3.1494E-03,3.3540E-03,3.4813E-03,
     &3.4487E-03,2.9536E-03,2.0691E-03/
      DATA ((KA(JS,JT,11, 4),JS=1,9),JT=1,5) /
     &1.0805E-03,2.1148E-03,2.4220E-03,2.5310E-03,2.5389E-03,2.4625E-03,
     &2.3509E-03,2.0401E-03,1.4417E-03,1.2248E-03,2.3043E-03,2.6421E-03,
     &2.7805E-03,2.8051E-03,2.7290E-03,2.6298E-03,2.3094E-03,1.6718E-03,
     &1.3919E-03,2.5018E-03,2.8694E-03,3.0522E-03,3.0921E-03,3.0140E-03,
     &2.9024E-03,2.5763E-03,1.8644E-03,1.5591E-03,2.7193E-03,3.1319E-03,
     &3.3417E-03,3.3992E-03,3.3292E-03,3.1865E-03,2.8388E-03,2.0955E-03,
     &1.7150E-03,2.9473E-03,3.3980E-03,3.6551E-03,3.7158E-03,3.6708E-03,
     &3.4907E-03,3.0872E-03,2.3494E-03/
      DATA ((KA(JS,JT,12, 4),JS=1,9),JT=1,5) /
     &1.3897E-03,2.3284E-03,2.5562E-03,2.6114E-03,2.5756E-03,2.4579E-03,
     &2.2328E-03,1.8907E-03,1.4460E-03,1.5697E-03,2.5462E-03,2.7773E-03,
     &2.8739E-03,2.8515E-03,2.7127E-03,2.4702E-03,2.1317E-03,1.6710E-03,
     &1.7564E-03,2.7736E-03,3.0368E-03,3.1575E-03,3.1336E-03,2.9932E-03,
     &2.7316E-03,2.3689E-03,1.9165E-03,1.9373E-03,3.0028E-03,3.3026E-03,
     &3.4473E-03,3.4197E-03,3.2885E-03,3.0105E-03,2.5975E-03,2.1734E-03,
     &2.1103E-03,3.2861E-03,3.6126E-03,3.7579E-03,3.7472E-03,3.5983E-03,
     &3.3137E-03,2.8243E-03,2.4241E-03/
      DATA ((KA(JS,JT,13, 4),JS=1,9),JT=1,5) /
     &1.4034E-03,2.2073E-03,2.3423E-03,2.3940E-03,2.3352E-03,2.2289E-03,
     &1.9861E-03,1.6453E-03,1.3641E-03,1.5468E-03,2.3993E-03,2.5715E-03,
     &2.6353E-03,2.5905E-03,2.4689E-03,2.2035E-03,1.8516E-03,1.5595E-03,
     &1.7054E-03,2.6002E-03,2.8041E-03,2.9001E-03,2.8726E-03,2.7020E-03,
     &2.4437E-03,2.0505E-03,1.7798E-03,1.8746E-03,2.8344E-03,3.0758E-03,
     &3.1886E-03,3.1543E-03,2.9591E-03,2.7010E-03,2.2473E-03,2.0185E-03,
     &2.0493E-03,3.1290E-03,3.3711E-03,3.5047E-03,3.4626E-03,3.2529E-03,
     &2.9617E-03,2.4466E-03,2.2855E-03/
      DATA ((KA(JS,JT, 1, 5),JS=1,9),JT=1,5) /
     &2.7288E-06,2.0772E-03,4.1339E-03,6.3040E-03,8.6169E-03,1.1216E-02,
     &1.4425E-02,1.9774E-02,1.7219E-02,3.1343E-06,2.2547E-03,4.4747E-03,
     &6.8269E-03,9.3305E-03,1.2134E-02,1.5662E-02,2.1511E-02,1.8646E-02,
     &3.5230E-06,2.4421E-03,4.8659E-03,7.3919E-03,1.0064E-02,1.3080E-02,
     &1.6864E-02,2.3200E-02,2.0105E-02,3.8970E-06,2.6162E-03,5.2335E-03,
     &7.9722E-03,1.0895E-02,1.4129E-02,1.8093E-02,2.4994E-02,2.1780E-02,
     &4.2153E-06,2.7842E-03,5.5880E-03,8.5221E-03,1.1648E-02,1.5136E-02,
     &1.9474E-02,2.6742E-02,2.3280E-02/
      DATA ((KA(JS,JT, 2, 5),JS=1,9),JT=1,5) /
     &3.8170E-06,1.7299E-03,3.3770E-03,5.0561E-03,6.8488E-03,8.8137E-03,
     &1.1142E-02,1.4709E-02,1.3674E-02,4.3252E-06,1.8890E-03,3.6509E-03,
     &5.4769E-03,7.4269E-03,9.5439E-03,1.2081E-02,1.6033E-02,1.4831E-02,
     &4.7646E-06,2.0435E-03,3.9774E-03,5.9664E-03,8.0622E-03,1.0295E-02,
     &1.3026E-02,1.7373E-02,1.6093E-02,5.2162E-06,2.1898E-03,4.2814E-03,
     &6.4462E-03,8.7251E-03,1.1197E-02,1.4093E-02,1.8642E-02,1.7418E-02,
     &5.6571E-06,2.3346E-03,4.5674E-03,6.8936E-03,9.3452E-03,1.2004E-02,
     &1.5146E-02,2.0072E-02,1.8662E-02/
      DATA ((KA(JS,JT, 3, 5),JS=1,9),JT=1,5) /
     &6.7841E-06,1.4874E-03,2.7805E-03,4.0760E-03,5.3909E-03,6.7517E-03,
     &8.3542E-03,1.0487E-02,1.0633E-02,7.5652E-06,1.6242E-03,3.0372E-03,
     &4.4125E-03,5.8428E-03,7.3572E-03,9.0599E-03,1.1418E-02,1.1564E-02,
     &8.3338E-06,1.7491E-03,3.3027E-03,4.8269E-03,6.3750E-03,7.9902E-03,
     &9.8070E-03,1.2345E-02,1.2611E-02,9.1322E-06,1.8750E-03,3.5479E-03,
     &5.2057E-03,6.8969E-03,8.6842E-03,1.0693E-02,1.3305E-02,1.3678E-02,
     &9.9531E-06,2.0097E-03,3.7981E-03,5.5735E-03,7.4004E-03,9.3447E-03,
     &1.1509E-02,1.4423E-02,1.4706E-02/
      DATA ((KA(JS,JT, 4, 5),JS=1,9),JT=1,5) /
     &1.2103E-05,1.3043E-03,2.3537E-03,3.3772E-03,4.3942E-03,5.3862E-03,
     &6.4402E-03,7.7504E-03,8.3034E-03,1.3453E-05,1.4203E-03,2.5925E-03,
     &3.7016E-03,4.7682E-03,5.8654E-03,7.0102E-03,8.4347E-03,9.0709E-03,
     &1.4828E-05,1.5367E-03,2.8071E-03,4.0356E-03,5.2345E-03,6.4096E-03,
     &7.5937E-03,9.1611E-03,9.8978E-03,1.6265E-05,1.6502E-03,3.0181E-03,
     &4.3485E-03,5.6510E-03,6.9455E-03,8.2885E-03,9.9540E-03,1.0767E-02,
     &1.7755E-05,1.7615E-03,3.2390E-03,4.6692E-03,6.0695E-03,7.4667E-03,
     &8.9542E-03,1.0781E-02,1.1635E-02/
      DATA ((KA(JS,JT, 5, 5),JS=1,9),JT=1,5) /
     &2.0332E-05,1.1698E-03,2.0394E-03,2.8422E-03,3.6398E-03,4.4106E-03,
     &5.1682E-03,5.9629E-03,6.5029E-03,2.2530E-05,1.2736E-03,2.2339E-03,
     &3.1431E-03,3.9975E-03,4.8072E-03,5.6451E-03,6.5119E-03,7.1285E-03,
     &2.4796E-05,1.3790E-03,2.4265E-03,3.4174E-03,4.3749E-03,5.2936E-03,
     &6.1677E-03,7.0807E-03,7.7613E-03,2.7075E-05,1.4796E-03,2.6222E-03,
     &3.6840E-03,4.7300E-03,5.7397E-03,6.7237E-03,7.7301E-03,8.5090E-03,
     &2.9544E-05,1.5786E-03,2.8146E-03,3.9658E-03,5.0797E-03,6.1834E-03,
     &7.2517E-03,8.3791E-03,9.2155E-03/
      DATA ((KA(JS,JT, 6, 5),JS=1,9),JT=1,5) /
     &3.1599E-05,1.0623E-03,1.7784E-03,2.4227E-03,3.0276E-03,3.6296E-03,
     &4.1838E-03,4.7343E-03,5.0477E-03,3.5232E-05,1.1598E-03,1.9531E-03,
     &2.6761E-03,3.3625E-03,3.9768E-03,4.5866E-03,5.2016E-03,5.5671E-03,
     &3.8902E-05,1.2546E-03,2.1314E-03,2.9272E-03,3.6836E-03,4.3880E-03,
     &5.0585E-03,5.6644E-03,6.0941E-03,4.2647E-05,1.3467E-03,2.3051E-03,
     &3.1735E-03,3.9922E-03,4.7680E-03,5.5151E-03,6.2191E-03,6.7036E-03,
     &4.6653E-05,1.4422E-03,2.4729E-03,3.4216E-03,4.3101E-03,5.1401E-03,
     &5.9675E-03,6.7430E-03,7.2989E-03/
      DATA ((KA(JS,JT, 7, 5),JS=1,9),JT=1,5) /
     &5.0846E-05,1.0315E-03,1.6111E-03,2.1236E-03,2.5799E-03,3.0310E-03,
     &3.4624E-03,3.8172E-03,3.8938E-03,5.6601E-05,1.1149E-03,1.7798E-03,
     &2.3658E-03,2.8898E-03,3.3716E-03,3.7952E-03,4.1967E-03,4.3621E-03,
     &6.2823E-05,1.2046E-03,1.9431E-03,2.5998E-03,3.1765E-03,3.7177E-03,
     &4.2137E-03,4.5955E-03,4.7978E-03,6.9611E-05,1.2957E-03,2.0957E-03,
     &2.8201E-03,3.4636E-03,4.0605E-03,4.6007E-03,5.0741E-03,5.2639E-03,
     &7.6939E-05,1.3859E-03,2.2478E-03,3.0375E-03,3.7523E-03,4.4027E-03,
     &4.9784E-03,5.5148E-03,5.7724E-03/
      DATA ((KA(JS,JT, 8, 5),JS=1,9),JT=1,5) /
     &9.6301E-05,1.1719E-03,1.6543E-03,2.0770E-03,2.3972E-03,2.6733E-03,
     &2.9412E-03,3.1694E-03,3.0111E-03,1.0686E-04,1.2764E-03,1.7930E-03,
     &2.2808E-03,2.6778E-03,3.0239E-03,3.3001E-03,3.5015E-03,3.3999E-03,
     &1.1947E-04,1.3739E-03,1.9473E-03,2.4712E-03,2.9582E-03,3.3516E-03,
     &3.6623E-03,3.8834E-03,3.7468E-03,1.3232E-04,1.4765E-03,2.1012E-03,
     &2.6685E-03,3.2209E-03,3.6672E-03,4.0113E-03,4.2720E-03,4.1080E-03,
     &1.4706E-04,1.5789E-03,2.2554E-03,2.8711E-03,3.4655E-03,3.9725E-03,
     &4.3795E-03,4.6534E-03,4.5441E-03/
      DATA ((KA(JS,JT, 9, 5),JS=1,9),JT=1,5) /
     &3.5361E-04,1.7799E-03,2.5051E-03,2.9026E-03,3.0684E-03,3.1720E-03,
     &3.1736E-03,2.9481E-03,2.3479E-03,3.8911E-04,1.9917E-03,2.7818E-03,
     &3.1870E-03,3.3554E-03,3.4634E-03,3.5258E-03,3.3674E-03,2.6687E-03,
     &4.2895E-04,2.2031E-03,3.0511E-03,3.4571E-03,3.6423E-03,3.7656E-03,
     &3.8544E-03,3.7669E-03,2.9800E-03,4.7521E-04,2.4131E-03,3.3032E-03,
     &3.7275E-03,3.9589E-03,4.0895E-03,4.1693E-03,4.1455E-03,3.3334E-03,
     &5.2696E-04,2.6212E-03,3.5469E-03,4.0100E-03,4.2674E-03,4.4062E-03,
     &4.4862E-03,4.5098E-03,3.6774E-03/
      DATA ((KA(JS,JT,10, 5),JS=1,9),JT=1,5) /
     &1.5564E-03,3.2260E-03,4.0223E-03,4.5990E-03,4.8864E-03,4.9553E-03,
     &4.6372E-03,3.8115E-03,2.4163E-03,1.6655E-03,3.5530E-03,4.4984E-03,
     &5.1615E-03,5.5140E-03,5.5636E-03,5.1458E-03,4.1627E-03,2.8169E-03,
     &1.7970E-03,3.9283E-03,4.9975E-03,5.7194E-03,6.1431E-03,6.1500E-03,
     &5.6336E-03,4.5688E-03,3.2157E-03,1.9389E-03,4.3419E-03,5.5082E-03,
     &6.3036E-03,6.7602E-03,6.7061E-03,6.1219E-03,4.9831E-03,3.5478E-03,
     &2.1200E-03,4.8101E-03,6.0597E-03,6.9046E-03,7.3538E-03,7.2522E-03,
     &6.6229E-03,5.4082E-03,3.8617E-03/
      DATA ((KA(JS,JT,11, 5),JS=1,9),JT=1,5) /
     &2.5844E-03,4.2072E-03,4.7201E-03,5.1141E-03,5.3078E-03,5.2931E-03,
     &4.9397E-03,3.9983E-03,2.6464E-03,2.7239E-03,4.5852E-03,5.1921E-03,
     &5.6631E-03,5.9270E-03,5.9381E-03,5.5459E-03,4.4351E-03,2.9283E-03,
     &2.8937E-03,4.9994E-03,5.7378E-03,6.2452E-03,6.5647E-03,6.5969E-03,
     &6.1297E-03,4.8694E-03,3.2879E-03,3.0973E-03,5.4803E-03,6.2977E-03,
     &6.8750E-03,7.2241E-03,7.2627E-03,6.7036E-03,5.3184E-03,3.6746E-03,
     &3.3444E-03,6.0139E-03,6.9682E-03,7.5496E-03,7.9438E-03,7.9183E-03,
     &7.2786E-03,5.7800E-03,4.1120E-03/
      DATA ((KA(JS,JT,12, 5),JS=1,9),JT=1,5) /
     &3.1142E-03,4.6509E-03,5.0639E-03,5.2099E-03,5.2596E-03,5.1306E-03,
     &4.7167E-03,3.8189E-03,2.7150E-03,3.2756E-03,5.0359E-03,5.5390E-03,
     &5.7321E-03,5.8154E-03,5.7214E-03,5.2745E-03,4.2400E-03,3.0513E-03,
     &3.4985E-03,5.4685E-03,6.0590E-03,6.2917E-03,6.4404E-03,6.3170E-03,
     &5.8354E-03,4.6512E-03,3.3763E-03,3.7766E-03,5.9630E-03,6.6546E-03,
     &6.9419E-03,7.0961E-03,6.9336E-03,6.4037E-03,5.0749E-03,3.7160E-03,
     &4.1085E-03,6.5232E-03,7.2797E-03,7.6482E-03,7.7587E-03,7.5770E-03,
     &6.9583E-03,5.5150E-03,4.0847E-03/
      DATA ((KA(JS,JT,13, 5),JS=1,9),JT=1,5) /
     &2.9969E-03,4.3888E-03,4.7684E-03,4.8307E-03,4.7938E-03,4.5847E-03,
     &4.1916E-03,3.3359E-03,2.6072E-03,3.2153E-03,4.7897E-03,5.2331E-03,
     &5.3333E-03,5.2913E-03,5.1054E-03,4.6633E-03,3.6830E-03,2.9306E-03,
     &3.4754E-03,5.2096E-03,5.7373E-03,5.8606E-03,5.8296E-03,5.6492E-03,
     &5.1331E-03,4.0274E-03,3.2891E-03,3.7596E-03,5.6812E-03,6.2772E-03,
     &6.4413E-03,6.4105E-03,6.2095E-03,5.6055E-03,4.3924E-03,3.6856E-03,
     &4.1250E-03,6.2069E-03,6.8482E-03,7.0531E-03,7.0243E-03,6.7656E-03,
     &6.0849E-03,4.7766E-03,4.1519E-03/
      DATA ((KA(JS,JT, 1, 6),JS=1,9),JT=1,5) /
     &8.6000E-06,4.4651E-03,9.0097E-03,1.3704E-02,1.8645E-02,2.4046E-02,
     &3.0633E-02,4.1152E-02,3.7281E-02,9.1677E-06,4.8343E-03,9.7595E-03,
     &1.4853E-02,2.0235E-02,2.6158E-02,3.3249E-02,4.4739E-02,4.0461E-02,
     &9.7617E-06,5.2064E-03,1.0520E-02,1.6024E-02,2.1831E-02,2.8229E-02,
     &3.6006E-02,4.8415E-02,4.3651E-02,1.0395E-05,5.5866E-03,1.1290E-02,
     &1.7191E-02,2.3426E-02,3.0307E-02,3.8717E-02,5.2240E-02,4.6842E-02,
     &1.1075E-05,5.9593E-03,1.2050E-02,1.8360E-02,2.5043E-02,3.2426E-02,
     &4.1434E-02,5.5912E-02,5.0074E-02/
      DATA ((KA(JS,JT, 2, 6),JS=1,9),JT=1,5) /
     &1.1648E-05,3.7355E-03,7.3892E-03,1.1190E-02,1.5132E-02,1.9317E-02,
     &2.4213E-02,3.1544E-02,3.0250E-02,1.2445E-05,4.0410E-03,8.0302E-03,
     &1.2160E-02,1.6448E-02,2.1055E-02,2.6369E-02,3.4311E-02,3.2880E-02,
     &1.3310E-05,4.3542E-03,8.6703E-03,1.3133E-02,1.7778E-02,2.2773E-02,
     &2.8564E-02,3.7228E-02,3.5538E-02,1.4232E-05,4.6616E-03,9.3074E-03,
     &1.4103E-02,1.9095E-02,2.4467E-02,3.0730E-02,4.0202E-02,3.8172E-02,
     &1.5231E-05,4.9691E-03,9.9386E-03,1.5066E-02,2.0413E-02,2.6167E-02,
     &3.2915E-02,4.3077E-02,4.0807E-02/
      DATA ((KA(JS,JT, 3, 6),JS=1,9),JT=1,5) /
     &2.0796E-05,3.1636E-03,6.0427E-03,8.9479E-03,1.1951E-02,1.5111E-02,
     &1.8532E-02,2.3072E-02,2.3870E-02,2.2285E-05,3.4357E-03,6.5684E-03,
     &9.7449E-03,1.3046E-02,1.6505E-02,2.0281E-02,2.5200E-02,2.6059E-02,
     &2.3921E-05,3.7148E-03,7.1066E-03,1.0556E-02,1.4151E-02,1.7911E-02,
     &2.2018E-02,2.7457E-02,2.8268E-02,2.5678E-05,3.9815E-03,7.6234E-03,
     &1.1355E-02,1.5233E-02,1.9276E-02,2.3703E-02,2.9635E-02,3.0431E-02,
     &2.7604E-05,4.2441E-03,8.1373E-03,1.2146E-02,1.6312E-02,2.0656E-02,
     &2.5417E-02,3.1780E-02,3.2590E-02/
      DATA ((KA(JS,JT, 4, 6),JS=1,9),JT=1,5) /
     &3.7548E-05,2.7525E-03,5.0829E-03,7.3519E-03,9.5921E-03,1.1880E-02,
     &1.4330E-02,1.7270E-02,1.8770E-02,4.0479E-05,3.0018E-03,5.5477E-03,
     &8.0335E-03,1.0500E-02,1.3017E-02,1.5741E-02,1.8989E-02,2.0592E-02,
     &4.3632E-05,3.2358E-03,6.0288E-03,8.7218E-03,1.1388E-02,1.4152E-02,
     &1.7154E-02,2.0724E-02,2.2417E-02,4.6956E-05,3.4641E-03,6.4839E-03,
     &9.3953E-03,1.2286E-02,1.5294E-02,1.8543E-02,2.2416E-02,2.4245E-02,
     &5.0658E-05,3.6946E-03,6.9352E-03,1.0060E-02,1.3165E-02,1.6424E-02,
     &1.9935E-02,2.4115E-02,2.6056E-02/
      DATA ((KA(JS,JT, 5, 6),JS=1,9),JT=1,5) /
     &6.1528E-05,2.4644E-03,4.3512E-03,6.1626E-03,7.9327E-03,9.6496E-03,
     &1.1347E-02,1.3264E-02,1.4745E-02,6.6793E-05,2.6844E-03,4.7746E-03,
     &6.7632E-03,8.7202E-03,1.0626E-02,1.2508E-02,1.4649E-02,1.6279E-02,
     &7.2459E-05,2.8961E-03,5.1774E-03,7.3853E-03,9.5105E-03,1.1570E-02,
     &1.3632E-02,1.6051E-02,1.7802E-02,7.8727E-05,3.1045E-03,5.5659E-03,
     &7.9693E-03,1.0288E-02,1.2541E-02,1.4785E-02,1.7438E-02,1.9338E-02,
     &8.5530E-05,3.3182E-03,5.9543E-03,8.5528E-03,1.1059E-02,1.3485E-02,
     &1.5922E-02,1.8829E-02,2.0873E-02/
      DATA ((KA(JS,JT, 6, 6),JS=1,9),JT=1,5) /
     &9.4265E-05,2.2301E-03,3.8046E-03,5.2488E-03,6.6170E-03,7.9289E-03,
     &9.1950E-03,1.0423E-02,1.1518E-02,1.0266E-04,2.4246E-03,4.1792E-03,
     &5.7800E-03,7.2894E-03,8.7747E-03,1.0200E-02,1.1548E-02,1.2780E-02,
     &1.1200E-04,2.6239E-03,4.5381E-03,6.2992E-03,7.9916E-03,9.6188E-03,
     &1.1174E-02,1.2683E-02,1.4059E-02,1.2224E-04,2.8287E-03,4.8898E-03,
     &6.8010E-03,8.6582E-03,1.0462E-02,1.2176E-02,1.3803E-02,1.5334E-02,
     &1.3337E-04,3.0366E-03,5.2437E-03,7.3027E-03,9.3153E-03,1.1279E-02,
     &1.3144E-02,1.4949E-02,1.6628E-02/
      DATA ((KA(JS,JT, 7, 6),JS=1,9),JT=1,5) /
     &1.5263E-04,2.1146E-03,3.4378E-03,4.6052E-03,5.6815E-03,6.6787E-03,
     &7.5592E-03,8.3902E-03,8.9861E-03,1.6683E-04,2.3125E-03,3.7648E-03,
     &5.0866E-03,6.2982E-03,7.4001E-03,8.4314E-03,9.3717E-03,1.0001E-02,
     &1.8246E-04,2.5152E-03,4.0947E-03,5.5502E-03,6.9009E-03,8.1426E-03,
     &9.2748E-03,1.0344E-02,1.1085E-02,1.9965E-04,2.7190E-03,4.4394E-03,
     &6.0162E-03,7.4822E-03,8.8463E-03,1.0151E-02,1.1321E-02,1.2163E-02,
     &2.1839E-04,2.9201E-03,4.7890E-03,6.4854E-03,8.0589E-03,9.5473E-03,
     &1.0985E-02,1.2296E-02,1.3266E-02/
      DATA ((KA(JS,JT, 8, 6),JS=1,9),JT=1,5) /
     &2.9912E-04,2.3311E-03,3.4065E-03,4.3529E-03,5.1991E-03,5.9115E-03,
     &6.5345E-03,6.9536E-03,6.9673E-03,3.2667E-04,2.5198E-03,3.7444E-03,
     &4.8113E-03,5.7475E-03,6.5852E-03,7.2722E-03,7.8027E-03,7.8100E-03,
     &3.5783E-04,2.7045E-03,4.0852E-03,5.2736E-03,6.2947E-03,7.2359E-03,
     &8.0488E-03,8.6314E-03,8.7294E-03,3.9253E-04,2.8930E-03,4.4286E-03,
     &5.7246E-03,6.8467E-03,7.8891E-03,8.7826E-03,9.4970E-03,9.6421E-03,
     &4.3012E-04,3.0887E-03,4.7690E-03,6.1815E-03,7.4286E-03,8.5468E-03,
     &9.5146E-03,1.0319E-02,1.0565E-02/
      DATA ((KA(JS,JT, 9, 6),JS=1,9),JT=1,5) /
     &1.0976E-03,4.1506E-03,5.1147E-03,5.7794E-03,6.2915E-03,6.5755E-03,
     &6.7173E-03,6.5721E-03,5.2619E-03,1.2019E-03,4.4814E-03,5.5166E-03,
     &6.2823E-03,6.8818E-03,7.2627E-03,7.4725E-03,7.3662E-03,5.9464E-03,
     &1.3207E-03,4.7927E-03,5.9242E-03,6.7576E-03,7.4599E-03,7.9614E-03,
     &8.2442E-03,8.1477E-03,6.6764E-03,1.4520E-03,5.0989E-03,6.3402E-03,
     &7.2519E-03,8.0196E-03,8.6608E-03,9.0083E-03,8.9373E-03,7.4095E-03,
     &1.5966E-03,5.4241E-03,6.7693E-03,7.7581E-03,8.6262E-03,9.3645E-03,
     &9.7704E-03,9.7289E-03,8.1550E-03/
      DATA ((KA(JS,JT,10, 6),JS=1,9),JT=1,5) /
     &4.4394E-03,9.1190E-03,1.0725E-02,1.1220E-02,1.1152E-02,1.0508E-02,
     &9.4386E-03,7.8107E-03,4.9143E-03,4.8803E-03,1.0187E-02,1.1809E-02,
     &1.2265E-02,1.2072E-02,1.1380E-02,1.0318E-02,8.6414E-03,5.6112E-03,
     &5.3784E-03,1.1243E-02,1.2866E-02,1.3294E-02,1.2988E-02,1.2282E-02,
     &1.1181E-02,9.4518E-03,6.2671E-03,5.9406E-03,1.2247E-02,1.3888E-02,
     &1.4276E-02,1.3911E-02,1.3225E-02,1.2026E-02,1.0238E-02,6.9421E-03,
     &6.5660E-03,1.3194E-02,1.4891E-02,1.5253E-02,1.4902E-02,1.4176E-02,
     &1.2864E-02,1.1066E-02,7.6281E-03/
      DATA ((KA(JS,JT,11, 6),JS=1,9),JT=1,5) /
     &6.6711E-03,1.1267E-02,1.2748E-02,1.3242E-02,1.2977E-02,1.2030E-02,
     &1.0523E-02,8.3002E-03,5.3202E-03,7.3092E-03,1.2565E-02,1.4207E-02,
     &1.4653E-02,1.4245E-02,1.3138E-02,1.1437E-02,9.1124E-03,6.0956E-03,
     &8.0261E-03,1.3900E-02,1.5599E-02,1.6022E-02,1.5510E-02,1.4232E-02,
     &1.2399E-02,9.8954E-03,6.7920E-03,8.8835E-03,1.5218E-02,1.7018E-02,
     &1.7348E-02,1.6755E-02,1.5328E-02,1.3427E-02,1.0676E-02,7.4156E-03,
     &9.8592E-03,1.6591E-02,1.8382E-02,1.8693E-02,1.7995E-02,1.6489E-02,
     &1.4464E-02,1.1488E-02,8.0687E-03/
      DATA ((KA(JS,JT,12, 6),JS=1,9),JT=1,5) /
     &7.8286E-03,1.1844E-02,1.2951E-02,1.3269E-02,1.2819E-02,1.1719E-02,
     &1.0146E-02,7.7901E-03,5.3706E-03,8.5205E-03,1.3089E-02,1.4355E-02,
     &1.4624E-02,1.4116E-02,1.2895E-02,1.1103E-02,8.5730E-03,5.9882E-03,
     &9.3309E-03,1.4405E-02,1.5746E-02,1.6010E-02,1.5387E-02,1.4067E-02,
     &1.2065E-02,9.3726E-03,6.6686E-03,1.0285E-02,1.5780E-02,1.7147E-02,
     &1.7368E-02,1.6677E-02,1.5224E-02,1.3058E-02,1.0197E-02,7.3827E-03,
     &1.1378E-02,1.7192E-02,1.8621E-02,1.8778E-02,1.8045E-02,1.6433E-02,
     &1.4105E-02,1.1017E-02,8.1428E-03/
      DATA ((KA(JS,JT,13, 6),JS=1,9),JT=1,5) /
     &7.7075E-03,1.1053E-02,1.1788E-02,1.1798E-02,1.1282E-02,1.0218E-02,
     &8.7608E-03,6.6974E-03,4.9774E-03,8.3931E-03,1.2074E-02,1.2868E-02,
     &1.2866E-02,1.2320E-02,1.1165E-02,9.5984E-03,7.4025E-03,5.6029E-03,
     &9.1257E-03,1.3198E-02,1.3994E-02,1.3989E-02,1.3400E-02,1.2194E-02,
     &1.0455E-02,8.1317E-03,6.2279E-03,9.9594E-03,1.4337E-02,1.5200E-02,
     &1.5161E-02,1.4494E-02,1.3263E-02,1.1356E-02,8.8525E-03,6.8478E-03,
     &1.0855E-02,1.5527E-02,1.6501E-02,1.6412E-02,1.5661E-02,1.4395E-02,
     &1.2355E-02,9.5887E-03,7.3951E-03/
      DATA ((KA(JS,JT, 1, 7),JS=1,9),JT=1,5) /
     &2.8482E-05,1.1072E-02,2.2376E-02,3.4052E-02,4.6363E-02,5.9888E-02,
     &7.6137E-02,1.0147E-01,9.2714E-02,2.9459E-05,1.1920E-02,2.4092E-02,
     &3.6662E-02,4.9933E-02,6.4531E-02,8.2136E-02,1.0950E-01,9.9856E-02,
     &3.0378E-05,1.2748E-02,2.5776E-02,3.9242E-02,5.3450E-02,6.9069E-02,
     &8.7941E-02,1.1741E-01,1.0689E-01,3.1242E-05,1.3565E-02,2.7429E-02,
     &4.1762E-02,5.6896E-02,7.3556E-02,9.3626E-02,1.2500E-01,1.1378E-01,
     &3.2096E-05,1.4368E-02,2.9038E-02,4.4226E-02,6.0256E-02,7.7920E-02,
     &9.9246E-02,1.3270E-01,1.2050E-01/
      DATA ((KA(JS,JT, 2, 7),JS=1,9),JT=1,5) /
     &3.8108E-05,9.1980E-03,1.8505E-02,2.8037E-02,3.7923E-02,4.8524E-02,
     &6.0800E-02,7.8866E-02,7.5829E-02,3.9453E-05,9.9404E-03,2.0012E-02,
     &3.0307E-02,4.0999E-02,5.2467E-02,6.5752E-02,8.5496E-02,8.1980E-02,
     &4.0728E-05,1.0645E-02,2.1444E-02,3.2483E-02,4.3962E-02,5.6282E-02,
     &7.0607E-02,9.1834E-02,8.7906E-02,4.1960E-05,1.1349E-02,2.2852E-02,
     &3.4627E-02,4.6872E-02,6.0009E-02,7.5320E-02,9.8100E-02,9.3725E-02,
     &4.3152E-05,1.2042E-02,2.4257E-02,3.6759E-02,4.9754E-02,6.3714E-02,
     &7.9963E-02,1.0426E-01,9.9487E-02/
      DATA ((KA(JS,JT, 3, 7),JS=1,9),JT=1,5) /
     &6.8682E-05,7.6817E-03,1.5032E-02,2.2610E-02,3.0354E-02,3.8397E-02,
     &4.7144E-02,5.8545E-02,6.0680E-02,7.1048E-05,8.3077E-03,1.6309E-02,
     &2.4554E-02,3.2973E-02,4.1716E-02,5.1249E-02,6.3726E-02,6.5916E-02,
     &7.3516E-05,8.8904E-03,1.7519E-02,2.6389E-02,3.5446E-02,4.4862E-02,
     &5.5125E-02,6.8637E-02,7.0859E-02,7.5927E-05,9.4787E-03,1.8742E-02,
     &2.8235E-02,3.7922E-02,4.7994E-02,5.8964E-02,7.3444E-02,7.5806E-02,
     &7.8228E-05,1.0059E-02,1.9946E-02,3.0057E-02,4.0372E-02,5.1096E-02,
     &6.2816E-02,7.8277E-02,8.0701E-02/
      DATA ((KA(JS,JT, 4, 7),JS=1,9),JT=1,5) /
     &1.2728E-04,6.6847E-03,1.2528E-02,1.8338E-02,2.4310E-02,3.0521E-02,
     &3.7034E-02,4.4629E-02,4.8506E-02,1.3229E-04,7.2462E-03,1.3606E-02,
     &1.9949E-02,2.6505E-02,3.3306E-02,4.0432E-02,4.8804E-02,5.2931E-02,
     &1.3690E-04,7.7950E-03,1.4636E-02,2.1498E-02,2.8618E-02,3.5967E-02,
     &4.3669E-02,5.2720E-02,5.7159E-02,1.4141E-04,8.3363E-03,1.5650E-02,
     &2.3036E-02,3.0707E-02,3.8607E-02,4.6880E-02,5.6623E-02,6.1327E-02,
     &1.4572E-04,8.8720E-03,1.6649E-02,2.4570E-02,3.2799E-02,4.1227E-02,
     &5.0069E-02,6.0500E-02,6.5502E-02/
      DATA ((KA(JS,JT, 5, 7),JS=1,9),JT=1,5) /
     &2.1573E-04,5.8827E-03,1.0779E-02,1.5450E-02,1.9971E-02,2.4513E-02,
     &2.9346E-02,3.4831E-02,3.8718E-02,2.2440E-04,6.4009E-03,1.1752E-02,
     &1.6862E-02,2.1813E-02,2.6822E-02,3.2187E-02,3.8239E-02,4.2467E-02,
     &2.3312E-04,6.9022E-03,1.2696E-02,1.8213E-02,2.3573E-02,2.9063E-02,
     &3.4955E-02,4.1525E-02,4.6111E-02,2.4120E-04,7.3983E-03,1.3629E-02,
     &1.9546E-02,2.5293E-02,3.1249E-02,3.7630E-02,4.4709E-02,4.9634E-02,
     &2.4900E-04,7.8813E-03,1.4548E-02,2.0857E-02,2.7012E-02,3.3451E-02,
     &4.0320E-02,4.7915E-02,5.3175E-02/
      DATA ((KA(JS,JT, 6, 7),JS=1,9),JT=1,5) /
     &3.4036E-04,5.3231E-03,9.2729E-03,1.3061E-02,1.6728E-02,2.0215E-02,
     &2.3560E-02,2.7195E-02,3.0556E-02,3.5502E-04,5.8134E-03,1.0151E-02,
     &1.4345E-02,1.8389E-02,2.2227E-02,2.5905E-02,3.0036E-02,3.3756E-02,
     &3.6934E-04,6.2790E-03,1.1006E-02,1.5584E-02,1.9972E-02,2.4157E-02,
     &2.8189E-02,3.2811E-02,3.6865E-02,3.8386E-04,6.7401E-03,1.1853E-02,
     &1.6807E-02,2.1541E-02,2.6034E-02,3.0406E-02,3.5498E-02,3.9873E-02,
     &3.9798E-04,7.1899E-03,1.2680E-02,1.7996E-02,2.3081E-02,2.7888E-02,
     &3.2622E-02,3.8170E-02,4.2864E-02/
      DATA ((KA(JS,JT, 7, 7),JS=1,9),JT=1,5) /
     &5.6321E-04,5.0131E-03,8.3197E-03,1.1342E-02,1.4164E-02,1.6877E-02,
     &1.9447E-02,2.1713E-02,2.3905E-02,5.9016E-04,5.4925E-03,9.1570E-03,
     &1.2482E-02,1.5641E-02,1.8693E-02,2.1556E-02,2.4086E-02,2.6629E-02,
     &6.1706E-04,5.9641E-03,9.9615E-03,1.3605E-02,1.7087E-02,2.0445E-02,
     &2.3593E-02,2.6361E-02,2.9262E-02,6.4250E-04,6.4355E-03,1.0740E-02,
     &1.4689E-02,1.8507E-02,2.2162E-02,2.5558E-02,2.8565E-02,3.1822E-02,
     &6.6706E-04,6.9143E-03,1.1505E-02,1.5753E-02,1.9886E-02,2.3836E-02,
     &2.7497E-02,3.0749E-02,3.4313E-02/
      DATA ((KA(JS,JT, 8, 7),JS=1,9),JT=1,5) /
     &1.1137E-03,5.2798E-03,8.0960E-03,1.0553E-02,1.2781E-02,1.4788E-02,
     &1.6508E-02,1.7972E-02,1.8634E-02,1.1746E-03,5.8110E-03,8.9215E-03,
     &1.1680E-02,1.4167E-02,1.6394E-02,1.8389E-02,2.0091E-02,2.0946E-02,
     &1.2333E-03,6.3510E-03,9.7459E-03,1.2786E-02,1.5523E-02,1.7978E-02,
     &2.0210E-02,2.2150E-02,2.3198E-02,1.2923E-03,6.8806E-03,1.0573E-02,
     &1.3874E-02,1.6833E-02,1.9520E-02,2.2008E-02,2.4130E-02,2.5397E-02,
     &1.3493E-03,7.4001E-03,1.1421E-02,1.4955E-02,1.8119E-02,2.1028E-02,
     &2.3751E-02,2.6082E-02,2.7521E-02/
      DATA ((KA(JS,JT, 9, 7),JS=1,9),JT=1,5) /
     &4.1652E-03,9.1226E-03,1.1391E-02,1.3127E-02,1.4574E-02,1.5712E-02,
     &1.6412E-02,1.6590E-02,1.4324E-02,4.4077E-03,9.7658E-03,1.2393E-02,
     &1.4489E-02,1.6135E-02,1.7441E-02,1.8307E-02,1.8536E-02,1.6186E-02,
     &4.6510E-03,1.0425E-02,1.3450E-02,1.5897E-02,1.7759E-02,1.9177E-02,
     &2.0163E-02,2.0445E-02,1.8103E-02,4.8932E-03,1.1096E-02,1.4490E-02,
     &1.7265E-02,1.9404E-02,2.0920E-02,2.2008E-02,2.2308E-02,1.9978E-02,
     &5.1319E-03,1.1758E-02,1.5541E-02,1.8602E-02,2.0988E-02,2.2688E-02,
     &2.3851E-02,2.4156E-02,2.1799E-02/
      DATA ((KA(JS,JT,10, 7),JS=1,9),JT=1,5) /
     &1.7349E-02,2.4277E-02,2.5467E-02,2.5566E-02,2.4825E-02,2.3373E-02,
     &2.1223E-02,1.8524E-02,1.1809E-02,1.8441E-02,2.5550E-02,2.7079E-02,
     &2.7402E-02,2.6767E-02,2.5495E-02,2.3503E-02,2.0675E-02,1.3556E-02,
     &1.9634E-02,2.6955E-02,2.8784E-02,2.9151E-02,2.8790E-02,2.7521E-02,
     &2.5774E-02,2.2876E-02,1.5334E-02,2.0834E-02,2.8474E-02,3.0492E-02,
     &3.0988E-02,3.0837E-02,2.9673E-02,2.8036E-02,2.5100E-02,1.7072E-02,
     &2.2004E-02,3.0118E-02,3.2233E-02,3.2923E-02,3.2760E-02,3.1852E-02,
     &3.0321E-02,2.7280E-02,1.8710E-02/
      DATA ((KA(JS,JT,11, 7),JS=1,9),JT=1,5) /
     &2.5621E-02,3.2655E-02,3.3386E-02,3.2478E-02,3.0535E-02,2.7796E-02,
     &2.3855E-02,1.8680E-02,1.0565E-02,2.7487E-02,3.4718E-02,3.5449E-02,
     &3.4659E-02,3.2784E-02,2.9958E-02,2.6042E-02,2.0737E-02,1.2143E-02,
     &2.9493E-02,3.6885E-02,3.7684E-02,3.6984E-02,3.4999E-02,3.2138E-02,
     &2.8186E-02,2.2834E-02,1.3640E-02,3.1405E-02,3.9361E-02,4.0123E-02,
     &3.9393E-02,3.7354E-02,3.4345E-02,3.0182E-02,2.4896E-02,1.5233E-02,
     &3.3372E-02,4.1804E-02,4.2639E-02,4.1888E-02,3.9776E-02,3.6559E-02,
     &3.2377E-02,2.6934E-02,1.6905E-02/
      DATA ((KA(JS,JT,12, 7),JS=1,9),JT=1,5) /
     &2.8107E-02,3.4513E-02,3.4691E-02,3.3440E-02,3.1149E-02,2.8092E-02,
     &2.3835E-02,1.7987E-02,9.8223E-03,3.0318E-02,3.7007E-02,3.7165E-02,
     &3.5894E-02,3.3524E-02,3.0240E-02,2.5840E-02,1.9792E-02,1.1332E-02,
     &3.2580E-02,3.9682E-02,3.9790E-02,3.8457E-02,3.5971E-02,3.2486E-02,
     &2.7883E-02,2.1561E-02,1.2728E-02,3.4838E-02,4.2408E-02,4.2616E-02,
     &4.1228E-02,3.8571E-02,3.4918E-02,2.9920E-02,2.3363E-02,1.4318E-02,
     &3.7163E-02,4.5231E-02,4.5400E-02,4.4006E-02,4.1203E-02,3.7331E-02,
     &3.2004E-02,2.5209E-02,1.5927E-02/
      DATA ((KA(JS,JT,13, 7),JS=1,9),JT=1,5) /
     &2.5217E-02,3.0486E-02,3.0548E-02,2.9385E-02,2.7336E-02,2.4524E-02,
     &2.0890E-02,1.5756E-02,9.4392E-03,2.7202E-02,3.2841E-02,3.2933E-02,
     &3.1772E-02,2.9593E-02,2.6611E-02,2.2741E-02,1.7329E-02,1.0602E-02,
     &2.9280E-02,3.5351E-02,3.5444E-02,3.4289E-02,3.1993E-02,2.8821E-02,
     &2.4603E-02,1.8828E-02,1.1938E-02,3.1331E-02,3.7956E-02,3.7975E-02,
     &3.6801E-02,3.4445E-02,3.1086E-02,2.6513E-02,2.0428E-02,1.3267E-02,
     &3.3613E-02,4.0685E-02,4.0655E-02,3.9388E-02,3.6935E-02,3.3268E-02,
     &2.8459E-02,2.2050E-02,1.4574E-02/
      DATA ((KA(JS,JT, 1, 8),JS=1,9),JT=1,5) /
     &7.0857E-05,3.1247E-02,6.3050E-02,9.5741E-02,1.2991E-01,1.6688E-01,
     &2.1008E-01,2.7194E-01,2.5981E-01,7.3061E-05,3.3759E-02,6.8122E-02,
     &1.0346E-01,1.4038E-01,1.8030E-01,2.2703E-01,2.9445E-01,2.8076E-01,
     &7.5439E-05,3.6248E-02,7.3153E-02,1.1109E-01,1.5077E-01,1.9367E-01,
     &2.4381E-01,3.1652E-01,3.0153E-01,7.7957E-05,3.8675E-02,7.8063E-02,
     &1.1859E-01,1.6099E-01,2.0691E-01,2.6053E-01,3.3811E-01,3.2197E-01,
     &8.0722E-05,4.1119E-02,8.2986E-02,1.2604E-01,1.7112E-01,2.1995E-01,
     &2.7714E-01,3.5946E-01,3.4222E-01/
      DATA ((KA(JS,JT, 2, 8),JS=1,9),JT=1,5) /
     &9.7224E-05,2.6558E-02,5.3452E-02,8.0855E-02,1.0918E-01,1.3924E-01,
     &1.7330E-01,2.2109E-01,2.1834E-01,1.0058E-04,2.8759E-02,5.7870E-02,
     &8.7575E-02,1.1827E-01,1.5089E-01,1.8793E-01,2.3994E-01,2.3652E-01,
     &1.0421E-04,3.0964E-02,6.2308E-02,9.4299E-02,1.2733E-01,1.6243E-01,
     &2.0230E-01,2.5862E-01,2.5463E-01,1.0798E-04,3.3179E-02,6.6764E-02,
     &1.0101E-01,1.3640E-01,1.7400E-01,2.1675E-01,2.7715E-01,2.7277E-01,
     &1.1188E-04,3.5361E-02,7.1160E-02,1.0767E-01,1.4545E-01,1.8554E-01,
     &2.3113E-01,2.9555E-01,2.9088E-01/
      DATA ((KA(JS,JT, 3, 8),JS=1,9),JT=1,5) /
     &1.7704E-04,2.1958E-02,4.4006E-02,6.6294E-02,8.8988E-02,1.1245E-01,
     &1.3781E-01,1.7014E-01,1.7794E-01,1.8401E-04,2.3898E-02,4.7908E-02,
     &7.2164E-02,9.6867E-02,1.2239E-01,1.4998E-01,1.8528E-01,1.9370E-01,
     &1.9123E-04,2.5882E-02,5.1886E-02,7.8168E-02,1.0491E-01,1.3257E-01,
     &1.6241E-01,2.0047E-01,2.0978E-01,1.9826E-04,2.7841E-02,5.5828E-02,
     &8.4093E-02,1.1289E-01,1.4266E-01,1.7485E-01,2.1582E-01,2.2574E-01,
     &2.0558E-04,2.9781E-02,5.9723E-02,8.9997E-02,1.2076E-01,1.5262E-01,
     &1.8706E-01,2.3095E-01,2.4148E-01/
      DATA ((KA(JS,JT, 4, 8),JS=1,9),JT=1,5) /
     &3.2677E-04,1.8554E-02,3.5926E-02,5.3829E-02,7.1995E-02,9.0469E-02,
     &1.0973E-01,1.3198E-01,1.4393E-01,3.3998E-04,2.0214E-02,3.9351E-02,
     &5.9051E-02,7.8970E-02,9.9220E-02,1.2030E-01,1.4461E-01,1.5787E-01,
     &3.5423E-04,2.1886E-02,4.2819E-02,6.4313E-02,8.6016E-02,1.0809E-01,
     &1.3108E-01,1.5763E-01,1.7196E-01,3.6836E-04,2.3526E-02,4.6236E-02,
     &6.9481E-02,9.2916E-02,1.1677E-01,1.4164E-01,1.7039E-01,1.8576E-01,
     &3.8269E-04,2.5159E-02,4.9646E-02,7.4614E-02,9.9776E-02,1.2541E-01,
     &1.5213E-01,1.8307E-01,1.9947E-01/
      DATA ((KA(JS,JT, 5, 8),JS=1,9),JT=1,5) /
     &5.5618E-04,1.6693E-02,3.0352E-02,4.4004E-02,5.8213E-02,7.2865E-02,
     &8.7904E-02,1.0425E-01,1.1619E-01,5.8090E-04,1.8251E-02,3.3255E-02,
     &4.8452E-02,6.4257E-02,8.0492E-02,9.7115E-02,1.1513E-01,1.2836E-01,
     &6.0567E-04,1.9782E-02,3.6119E-02,5.2854E-02,7.0252E-02,8.8045E-02,
     &1.0624E-01,1.2602E-01,1.4037E-01,6.3036E-04,2.1279E-02,3.8977E-02,
     &5.7257E-02,7.6243E-02,9.5550E-02,1.1529E-01,1.3680E-01,1.5235E-01,
     &6.5503E-04,2.2767E-02,4.1832E-02,6.1655E-02,8.2195E-02,1.0302E-01,
     &1.2434E-01,1.4756E-01,1.6424E-01/
      DATA ((KA(JS,JT, 6, 8),JS=1,9),JT=1,5) /
     &8.8779E-04,1.5219E-02,2.6847E-02,3.7621E-02,4.8063E-02,5.8817E-02,
     &7.0265E-02,8.2696E-02,9.3190E-02,9.2874E-04,1.6673E-02,2.9554E-02,
     &4.1458E-02,5.3049E-02,6.5160E-02,7.8074E-02,9.1921E-02,1.0355E-01,
     &9.6950E-04,1.8111E-02,3.2190E-02,4.5211E-02,5.8015E-02,7.1500E-02,
     &8.5838E-02,1.0107E-01,1.1382E-01,1.0101E-03,1.9522E-02,3.4803E-02,
     &4.8905E-02,6.3015E-02,7.7875E-02,9.3602E-02,1.1021E-01,1.2414E-01,
     &1.0515E-03,2.0916E-02,3.7389E-02,5.2547E-02,6.7966E-02,8.4205E-02,
     &1.0130E-01,1.1932E-01,1.3433E-01/
      DATA ((KA(JS,JT, 7, 8),JS=1,9),JT=1,5) /
     &1.4977E-03,1.4733E-02,2.4381E-02,3.3428E-02,4.1931E-02,4.9753E-02,
     &5.7173E-02,6.5580E-02,7.4312E-02,1.5637E-03,1.6075E-02,2.6857E-02,
     &3.6980E-02,4.6449E-02,5.5152E-02,6.3551E-02,7.3261E-02,8.3066E-02,
     &1.6297E-03,1.7399E-02,2.9305E-02,4.0484E-02,5.0904E-02,6.0470E-02,
     &6.9956E-02,8.1009E-02,9.1840E-02,1.7004E-03,1.8688E-02,3.1747E-02,
     &4.3982E-02,5.5347E-02,6.5760E-02,7.6435E-02,8.8798E-02,1.0066E-01,
     &1.7747E-03,1.9942E-02,3.4156E-02,4.7424E-02,5.9706E-02,7.0996E-02,
     &8.2872E-02,9.6510E-02,1.0938E-01/
      DATA ((KA(JS,JT, 8, 8),JS=1,9),JT=1,5) /
     &3.0289E-03,1.6187E-02,2.4623E-02,3.1800E-02,3.8382E-02,4.4473E-02,
     &4.9956E-02,5.4111E-02,5.8932E-02,3.1588E-03,1.7601E-02,2.6972E-02,
     &3.5067E-02,4.2580E-02,4.9539E-02,5.5733E-02,6.0374E-02,6.6309E-02,
     &3.2918E-03,1.8992E-02,2.9294E-02,3.8315E-02,4.6735E-02,5.4548E-02,
     &6.1452E-02,6.6677E-02,7.3699E-02,3.4281E-03,2.0362E-02,3.1558E-02,
     &4.1571E-02,5.0908E-02,5.9537E-02,6.7138E-02,7.3015E-02,8.1106E-02,
     &3.5753E-03,2.1737E-02,3.3774E-02,4.4733E-02,5.4993E-02,6.4441E-02,
     &7.2719E-02,7.9338E-02,8.8474E-02/
      DATA ((KA(JS,JT, 9, 8),JS=1,9),JT=1,5) /
     &1.1613E-02,2.6600E-02,3.4830E-02,4.1045E-02,4.5758E-02,4.9187E-02,
     &5.0957E-02,5.0881E-02,4.6332E-02,1.2035E-02,2.8837E-02,3.7970E-02,
     &4.4834E-02,5.0301E-02,5.4274E-02,5.6564E-02,5.6979E-02,5.2710E-02,
     &1.2460E-02,3.1118E-02,4.1014E-02,4.8606E-02,5.4716E-02,5.9241E-02,
     &6.2128E-02,6.3036E-02,5.8975E-02,1.2980E-02,3.3463E-02,4.4127E-02,
     &5.2378E-02,5.9008E-02,6.4138E-02,6.7667E-02,6.9075E-02,6.5274E-02,
     &1.3559E-02,3.5809E-02,4.7263E-02,5.6212E-02,6.3302E-02,6.8912E-02,
     &7.3069E-02,7.5010E-02,7.1590E-02/
      DATA ((KA(JS,JT,10, 8),JS=1,9),JT=1,5) /
     &4.9669E-02,6.5649E-02,7.1116E-02,7.3534E-02,7.3825E-02,7.2083E-02,
     &6.7844E-02,5.9498E-02,3.3788E-02,5.1505E-02,7.0624E-02,7.6814E-02,
     &7.9826E-02,8.0618E-02,7.8892E-02,7.4439E-02,6.5949E-02,3.8529E-02,
     &5.3297E-02,7.5384E-02,8.2789E-02,8.6542E-02,8.7369E-02,8.5820E-02,
     &8.1089E-02,7.2258E-02,4.3360E-02,5.5068E-02,8.0008E-02,8.8749E-02,
     &9.3221E-02,9.4169E-02,9.2692E-02,8.7784E-02,7.8437E-02,4.8014E-02,
     &5.7734E-02,8.4667E-02,9.4556E-02,9.9634E-02,1.0118E-01,9.9703E-02,
     &9.4571E-02,8.4495E-02,5.2667E-02/
      DATA ((KA(JS,JT,11, 8),JS=1,9),JT=1,5) /
     &7.6448E-02,9.0381E-02,9.1555E-02,9.0047E-02,8.6717E-02,8.1217E-02,
     &7.3241E-02,6.1179E-02,3.1726E-02,7.9612E-02,9.5621E-02,9.8574E-02,
     &9.7505E-02,9.4314E-02,8.8768E-02,8.0204E-02,6.7360E-02,3.6181E-02,
     &8.2652E-02,1.0183E-01,1.0547E-01,1.0483E-01,1.0201E-01,9.6508E-02,
     &8.7273E-02,7.3474E-02,4.0817E-02,8.5862E-02,1.0806E-01,1.1212E-01,
     &1.1216E-01,1.0950E-01,1.0402E-01,9.4626E-02,7.9735E-02,4.5328E-02,
     &8.9572E-02,1.1434E-01,1.1896E-01,1.1939E-01,1.1678E-01,1.1141E-01,
     &1.0160E-01,8.6030E-02,4.9522E-02/
      DATA ((KA(JS,JT,12, 8),JS=1,9),JT=1,5) /
     &8.7861E-02,9.9993E-02,9.9171E-02,9.4628E-02,8.8704E-02,8.0579E-02,
     &7.0917E-02,5.7333E-02,2.8393E-02,9.1432E-02,1.0608E-01,1.0583E-01,
     &1.0218E-01,9.6300E-02,8.8064E-02,7.7816E-02,6.3024E-02,3.2578E-02,
     &9.5110E-02,1.1196E-01,1.1325E-01,1.0996E-01,1.0369E-01,9.5361E-02,
     &8.4644E-02,6.8902E-02,3.7335E-02,9.9318E-02,1.1859E-01,1.2042E-01,
     &1.1748E-01,1.1108E-01,1.0241E-01,9.1344E-02,7.4779E-02,4.1207E-02,
     &1.0395E-01,1.2551E-01,1.2774E-01,1.2502E-01,1.1865E-01,1.0948E-01,
     &9.7810E-02,8.0483E-02,4.4886E-02/
      DATA ((KA(JS,JT,13, 8),JS=1,9),JT=1,5) /
     &7.9847E-02,9.1714E-02,9.0958E-02,8.6422E-02,8.0456E-02,7.2533E-02,
     &6.2189E-02,4.9649E-02,2.4638E-02,8.3442E-02,9.7407E-02,9.6872E-02,
     &9.3129E-02,8.7376E-02,7.8985E-02,6.8360E-02,5.4702E-02,2.8608E-02,
     &8.7437E-02,1.0293E-01,1.0345E-01,9.9852E-02,9.3864E-02,8.5454E-02,
     &7.4382E-02,5.9885E-02,3.2171E-02,9.2235E-02,1.0932E-01,1.1033E-01,
     &1.0673E-01,1.0043E-01,9.1575E-02,8.0229E-02,6.4806E-02,3.5846E-02,
     &9.7358E-02,1.1603E-01,1.1725E-01,1.1373E-01,1.0722E-01,9.7942E-02,
     &8.5906E-02,6.9573E-02,3.9453E-02/
      DATA ((KA(JS,JT, 1, 9),JS=1,9),JT=1,5) /
     &2.3734E-04,1.2635E-01,2.5378E-01,3.8280E-01,5.1449E-01,6.5095E-01,
     &7.9709E-01,9.7059E-01,1.0290E+00,2.4162E-04,1.3562E-01,2.7235E-01,
     &4.1078E-01,5.5198E-01,6.9838E-01,8.5534E-01,1.0400E+00,1.1040E+00,
     &2.4599E-04,1.4459E-01,2.9042E-01,4.3810E-01,5.8884E-01,7.4499E-01,
     &9.1233E-01,1.1085E+00,1.1777E+00,2.5041E-04,1.5330E-01,3.0793E-01,
     &4.6450E-01,6.2431E-01,7.9002E-01,9.6789E-01,1.1761E+00,1.2486E+00,
     &2.5474E-04,1.6182E-01,3.2498E-01,4.9034E-01,6.5899E-01,8.3368E-01,
     &1.0214E+00,1.2421E+00,1.3180E+00/
      DATA ((KA(JS,JT, 2, 9),JS=1,9),JT=1,5) /
     &3.4870E-04,1.1450E-01,2.2975E-01,3.4621E-01,4.6468E-01,5.8691E-01,
     &7.1765E-01,8.7423E-01,9.2933E-01,3.5536E-04,1.2334E-01,2.4755E-01,
     &3.7300E-01,5.0064E-01,6.3232E-01,7.7280E-01,9.4059E-01,1.0013E+00,
     &3.6217E-04,1.3183E-01,2.6460E-01,3.9876E-01,5.3531E-01,6.7635E-01,
     &8.2730E-01,1.0064E+00,1.0706E+00,3.6933E-04,1.4017E-01,2.8129E-01,
     &4.2395E-01,5.6909E-01,7.1898E-01,8.7939E-01,1.0712E+00,1.1382E+00,
     &3.7836E-04,1.4828E-01,2.9766E-01,4.4860E-01,6.0234E-01,7.6096E-01,
     &9.3060E-01,1.1332E+00,1.2047E+00/
      DATA ((KA(JS,JT, 3, 9),JS=1,9),JT=1,5) /
     &6.8597E-04,1.0077E-01,2.0189E-01,3.0366E-01,4.0641E-01,5.1122E-01,
     &6.2085E-01,7.4738E-01,8.1281E-01,6.9976E-04,1.0900E-01,2.1840E-01,
     &3.2848E-01,4.3972E-01,5.5316E-01,6.7192E-01,8.0915E-01,8.7943E-01,
     &7.1420E-04,1.1699E-01,2.3444E-01,3.5259E-01,4.7192E-01,5.9381E-01,
     &7.2140E-01,8.6946E-01,9.4382E-01,7.3229E-04,1.2483E-01,2.5014E-01,
     &3.7620E-01,5.0367E-01,6.3374E-01,7.7001E-01,9.2785E-01,1.0073E+00,
     &7.5049E-04,1.3237E-01,2.6526E-01,3.9901E-01,5.3417E-01,6.7225E-01,
     &8.1699E-01,9.8549E-01,1.0683E+00/
      DATA ((KA(JS,JT, 4, 9),JS=1,9),JT=1,5) /
     &1.3742E-03,8.7179E-02,1.7451E-01,2.6209E-01,3.5019E-01,4.3920E-01,
     &5.3064E-01,6.3091E-01,7.0034E-01,1.4034E-03,9.4872E-02,1.8987E-01,
     &2.8522E-01,3.8105E-01,4.7796E-01,5.7741E-01,6.8650E-01,7.6206E-01,
     &1.4371E-03,1.0231E-01,2.0478E-01,3.0758E-01,4.1096E-01,5.1550E-01,
     &6.2287E-01,7.4083E-01,8.2187E-01,1.4753E-03,1.0953E-01,2.1924E-01,
     &3.2932E-01,4.4000E-01,5.5196E-01,6.6692E-01,7.9351E-01,8.7995E-01,
     &1.5185E-03,1.1661E-01,2.3342E-01,3.5060E-01,4.6845E-01,5.8764E-01,
     &7.1008E-01,8.4502E-01,9.3684E-01/
      DATA ((KA(JS,JT, 5, 9),JS=1,9),JT=1,5) /
     &2.5355E-03,7.5685E-02,1.4908E-01,2.2375E-01,2.9863E-01,3.7400E-01,
     &4.5045E-01,5.3139E-01,5.9720E-01,2.5953E-03,8.2577E-02,1.6333E-01,
     &2.4515E-01,3.2721E-01,4.0982E-01,4.9365E-01,5.8247E-01,6.5435E-01,
     &2.6636E-03,8.9208E-02,1.7705E-01,2.6573E-01,3.5473E-01,4.4427E-01,
     &5.3522E-01,6.3160E-01,7.0937E-01,2.7420E-03,9.5746E-02,1.9046E-01,
     &2.8588E-01,3.8160E-01,4.7792E-01,5.7573E-01,6.7936E-01,7.6310E-01,
     &2.8238E-03,1.0214E-01,2.0360E-01,3.0562E-01,4.0796E-01,5.1095E-01,
     &6.1550E-01,7.2630E-01,8.1581E-01/
      DATA ((KA(JS,JT, 6, 9),JS=1,9),JT=1,5) /
     &4.3605E-03,6.9106E-02,1.2775E-01,1.8881E-01,2.5131E-01,3.1447E-01,
     &3.7819E-01,4.4408E-01,5.0252E-01,4.4677E-03,7.5202E-02,1.4031E-01,
     &2.0810E-01,2.7735E-01,3.4706E-01,4.1739E-01,4.9016E-01,5.5457E-01,
     &4.5887E-03,8.1094E-02,1.5254E-01,2.2684E-01,3.0254E-01,3.7858E-01,
     &4.5531E-01,5.3473E-01,6.0493E-01,4.7247E-03,8.6870E-02,1.6450E-01,
     &2.4527E-01,3.2719E-01,4.0945E-01,4.9240E-01,5.7834E-01,6.5421E-01,
     &4.8692E-03,9.2597E-02,1.7638E-01,2.6357E-01,3.5163E-01,4.4001E-01,
     &5.2913E-01,6.2153E-01,7.0308E-01/
      DATA ((KA(JS,JT, 7, 9),JS=1,9),JT=1,5) /
     &7.8126E-03,6.9794E-02,1.1632E-01,1.6292E-01,2.1140E-01,2.6176E-01,
     &3.1398E-01,3.6765E-01,4.1782E-01,8.0155E-03,7.6059E-02,1.2742E-01,
     &1.7989E-01,2.3439E-01,2.9098E-01,3.4941E-01,4.0917E-01,4.6495E-01,
     &8.2416E-03,8.1970E-02,1.3813E-01,1.9625E-01,2.5659E-01,3.1926E-01,
     &3.8354E-01,4.4917E-01,5.1030E-01,8.4921E-03,8.7603E-02,1.4873E-01,
     &2.1252E-01,2.7865E-01,3.4736E-01,4.1730E-01,4.8866E-01,5.5524E-01,
     &8.7515E-03,9.3044E-02,1.5925E-01,2.2867E-01,3.0064E-01,3.7532E-01,
     &4.5091E-01,5.2808E-01,5.9993E-01/
      DATA ((KA(JS,JT, 8, 9),JS=1,9),JT=1,5) /
     &1.6603E-02,7.8794E-02,1.2181E-01,1.5872E-01,1.9167E-01,2.2528E-01,
     &2.6122E-01,3.0128E-01,3.4340E-01,1.7055E-02,8.5849E-02,1.3372E-01,
     &1.7446E-01,2.1153E-01,2.5044E-01,2.9195E-01,3.3805E-01,3.8527E-01,
     &1.7594E-02,9.2738E-02,1.4493E-01,1.8895E-01,2.3080E-01,2.7486E-01,
     &3.2173E-01,3.7362E-01,4.2584E-01,1.8162E-02,9.9290E-02,1.5571E-01,
     &2.0324E-01,2.5013E-01,2.9946E-01,3.5175E-01,4.0935E-01,4.6655E-01,
     &1.8749E-02,1.0557E-01,1.6622E-01,2.1745E-01,2.6934E-01,3.2386E-01,
     &3.8166E-01,4.4484E-01,5.0696E-01/
      DATA ((KA(JS,JT, 9, 9),JS=1,9),JT=1,5) /
     &6.5840E-02,1.3860E-01,1.7838E-01,2.0998E-01,2.3508E-01,2.5392E-01,
     &2.6499E-01,2.6488E-01,2.7801E-01,6.7872E-02,1.4849E-01,1.9371E-01,
     &2.2975E-01,2.5869E-01,2.8072E-01,2.9363E-01,2.9601E-01,3.1493E-01,
     &7.0225E-02,1.5836E-01,2.0886E-01,2.4918E-01,2.8159E-01,3.0644E-01,
     &3.2072E-01,3.2657E-01,3.5112E-01,7.2560E-02,1.6804E-01,2.2356E-01,
     &2.6776E-01,3.0359E-01,3.3128E-01,3.4695E-01,3.5732E-01,3.8745E-01,
     &7.5125E-02,1.7750E-01,2.3755E-01,2.8560E-01,3.2501E-01,3.5553E-01,
     &3.7247E-01,3.8768E-01,4.2319E-01/
      DATA ((KA(JS,JT,10, 9),JS=1,9),JT=1,5) /
     &2.8983E-01,3.6990E-01,4.0037E-01,4.0949E-01,4.0589E-01,3.9081E-01,
     &3.6404E-01,3.1914E-01,2.2264E-01,2.9917E-01,3.8833E-01,4.2499E-01,
     &4.3869E-01,4.3868E-01,4.2555E-01,3.9991E-01,3.5416E-01,2.5485E-01,
     &3.0939E-01,4.0713E-01,4.4875E-01,4.6776E-01,4.7103E-01,4.6014E-01,
     &4.3525E-01,3.8827E-01,2.8738E-01,3.2110E-01,4.2672E-01,4.7284E-01,
     &4.9667E-01,5.0290E-01,4.9348E-01,4.6953E-01,4.2184E-01,3.1974E-01,
     &3.3272E-01,4.4730E-01,4.9768E-01,5.2532E-01,5.3384E-01,5.2588E-01,
     &5.0287E-01,4.5423E-01,3.5166E-01/
      DATA ((KA(JS,JT,11, 9),JS=1,9),JT=1,5) /
     &4.4524E-01,5.1679E-01,5.3684E-01,5.3332E-01,5.1092E-01,4.7255E-01,
     &4.1877E-01,3.4229E-01,1.8048E-01,4.5963E-01,5.4202E-01,5.6658E-01,
     &5.6626E-01,5.4700E-01,5.0983E-01,4.5605E-01,3.7725E-01,2.0742E-01,
     &4.7588E-01,5.6665E-01,5.9649E-01,5.9968E-01,5.8254E-01,5.4674E-01,
     &4.9265E-01,4.1176E-01,2.3443E-01,4.9478E-01,5.9201E-01,6.2710E-01,
     &6.3330E-01,6.1823E-01,5.8344E-01,5.2842E-01,4.4573E-01,2.6065E-01,
     &5.1485E-01,6.2017E-01,6.5811E-01,6.6709E-01,6.5355E-01,6.1972E-01,
     &5.6393E-01,4.7838E-01,2.8720E-01/
      DATA ((KA(JS,JT,12, 9),JS=1,9),JT=1,5) /
     &5.0543E-01,5.6903E-01,5.8050E-01,5.7018E-01,5.4105E-01,4.9466E-01,
     &4.2828E-01,3.3843E-01,1.4652E-01,5.2298E-01,5.9603E-01,6.1306E-01,
     &6.0448E-01,5.7710E-01,5.3128E-01,4.6400E-01,3.7149E-01,1.6865E-01,
     &5.4270E-01,6.2472E-01,6.4493E-01,6.3902E-01,6.1334E-01,5.6783E-01,
     &4.9936E-01,4.0428E-01,1.8993E-01,5.6576E-01,6.5409E-01,6.7814E-01,
     &6.7406E-01,6.4973E-01,6.0390E-01,5.3494E-01,4.3628E-01,2.1164E-01,
     &5.9076E-01,6.8665E-01,7.1248E-01,7.0991E-01,6.8560E-01,6.4007E-01,
     &5.7053E-01,4.6743E-01,2.3320E-01/
      DATA ((KA(JS,JT,13, 9),JS=1,9),JT=1,5) /
     &4.5979E-01,5.1890E-01,5.2855E-01,5.1825E-01,4.9146E-01,4.4960E-01,
     &3.8971E-01,3.0598E-01,1.2566E-01,4.7640E-01,5.4480E-01,5.5925E-01,
     &5.5059E-01,5.2436E-01,4.8283E-01,4.2163E-01,3.3565E-01,1.4550E-01,
     &4.9565E-01,5.7250E-01,5.8989E-01,5.8311E-01,5.5799E-01,5.1559E-01,
     &4.5382E-01,3.6511E-01,1.6523E-01,5.1794E-01,6.0150E-01,6.2192E-01,
     &6.1629E-01,5.9157E-01,5.4908E-01,4.8624E-01,3.9414E-01,1.8408E-01,
     &5.4127E-01,6.3348E-01,6.5477E-01,6.5028E-01,6.2556E-01,5.8254E-01,
     &5.1808E-01,4.2264E-01,2.0283E-01/
      DATA ((KA(JS,JT, 1,10),JS=1,9),JT=1,5) /
     &6.5918E-04,3.4888E-01,6.9848E-01,1.0485E+00,1.4002E+00,1.7549E+00,
     &2.1190E+00,2.5078E+00,2.8004E+00,6.7280E-04,3.7184E-01,7.4416E-01,
     &1.1175E+00,1.4925E+00,1.8689E+00,2.2475E+00,2.6390E+00,2.9850E+00,
     &6.8523E-04,3.9709E-01,7.9353E-01,1.1893E+00,1.5844E+00,1.9796E+00,
     &2.3755E+00,2.7728E+00,3.1689E+00,6.9619E-04,4.2236E-01,8.4460E-01,
     &1.2663E+00,1.6869E+00,2.1024E+00,2.5075E+00,2.8990E+00,3.3737E+00,
     &7.0541E-04,4.4505E-01,8.9002E-01,1.3353E+00,1.7799E+00,2.2235E+00,
     &2.6534E+00,3.0275E+00,3.5598E+00/
      DATA ((KA(JS,JT, 2,10),JS=1,9),JT=1,5) /
     &1.0168E-03,3.3520E-01,6.7064E-01,1.0063E+00,1.3424E+00,1.6793E+00,
     &2.0199E+00,2.3746E+00,2.6847E+00,1.0383E-03,3.6090E-01,7.2200E-01,
     &1.0832E+00,1.4445E+00,1.8057E+00,2.1681E+00,2.5457E+00,2.8891E+00,
     &1.0584E-03,3.8758E-01,7.7508E-01,1.1623E+00,1.5490E+00,1.9350E+00,
     &2.3176E+00,2.7064E+00,3.0980E+00,1.0746E-03,4.1292E-01,8.2598E-01,
     &1.2389E+00,1.6519E+00,2.0646E+00,2.4744E+00,2.8678E+00,3.3037E+00,
     &1.0744E-03,4.3717E-01,8.7417E-01,1.3107E+00,1.7471E+00,2.1834E+00,
     &2.6192E+00,3.0444E+00,3.4941E+00/
      DATA ((KA(JS,JT, 3,10),JS=1,9),JT=1,5) /
     &2.0748E-03,3.1600E-01,6.3217E-01,9.4857E-01,1.2657E+00,1.5838E+00,
     &1.9039E+00,2.2287E+00,2.5314E+00,2.1217E-03,3.4261E-01,6.8545E-01,
     &1.0284E+00,1.3716E+00,1.7154E+00,2.0606E+00,2.4138E+00,2.7432E+00,
     &2.1619E-03,3.6999E-01,7.4010E-01,1.1107E+00,1.4817E+00,1.8526E+00,
     &2.2240E+00,2.5942E+00,2.9634E+00,2.1755E-03,3.9596E-01,7.9208E-01,
     &1.1885E+00,1.5854E+00,1.9831E+00,2.3825E+00,2.7842E+00,3.1709E+00,
     &2.1880E-03,4.2191E-01,8.4399E-01,1.2664E+00,1.6893E+00,2.1130E+00,
     &2.5373E+00,2.9615E+00,3.3787E+00/
      DATA ((KA(JS,JT, 4,10),JS=1,9),JT=1,5) /
     &4.2494E-03,2.8992E-01,5.8012E-01,8.7071E-01,1.1620E+00,1.4546E+00,
     &1.7505E+00,2.0568E+00,2.3239E+00,4.3512E-03,3.1537E-01,6.3099E-01,
     &9.4695E-01,1.2638E+00,1.5819E+00,1.9039E+00,2.2390E+00,2.5276E+00,
     &4.4136E-03,3.4243E-01,6.8516E-01,1.0282E+00,1.3719E+00,1.7170E+00,
     &2.0650E+00,2.4245E+00,2.7438E+00,4.4541E-03,3.6913E-01,7.3845E-01,
     &1.1085E+00,1.4792E+00,1.8513E+00,2.2276E+00,2.6166E+00,2.9583E+00,
     &4.4637E-03,3.9522E-01,7.9055E-01,1.1865E+00,1.5830E+00,1.9815E+00,
     &2.3838E+00,2.7994E+00,3.1659E+00/
      DATA ((KA(JS,JT, 5,10),JS=1,9),JT=1,5) /
     &7.8944E-03,2.6027E-01,5.2060E-01,7.8129E-01,1.0423E+00,1.3045E+00,
     &1.5691E+00,1.8427E+00,2.0845E+00,8.0572E-03,2.8413E-01,5.6833E-01,
     &8.5287E-01,1.1378E+00,1.4238E+00,1.7119E+00,2.0096E+00,2.2754E+00,
     &8.1742E-03,3.1030E-01,6.2054E-01,9.3122E-01,1.2421E+00,1.5541E+00,
     &1.8685E+00,2.1911E+00,2.4841E+00,8.2414E-03,3.3618E-01,6.7234E-01,
     &1.0088E+00,1.3458E+00,1.6840E+00,2.0247E+00,2.3758E+00,2.6915E+00,
     &8.3003E-03,3.6135E-01,7.2289E-01,1.0847E+00,1.4472E+00,1.8109E+00,
     &2.1782E+00,2.5572E+00,2.8943E+00/
      DATA ((KA(JS,JT, 6,10),JS=1,9),JT=1,5) /
     &1.3769E-02,2.2868E-01,4.5729E-01,6.8615E-01,9.1532E-01,1.1447E+00,
     &1.3758E+00,1.6126E+00,1.8305E+00,1.4077E-02,2.5186E-01,5.0368E-01,
     &7.5558E-01,1.0079E+00,1.2605E+00,1.5146E+00,1.7737E+00,2.0155E+00,
     &1.4339E-02,2.7680E-01,5.5350E-01,8.3033E-01,1.1075E+00,1.3852E+00,
     &1.6642E+00,1.9484E+00,2.2148E+00,1.4519E-02,3.0142E-01,6.0270E-01,
     &9.0418E-01,1.2061E+00,1.5083E+00,1.8129E+00,2.1232E+00,2.4121E+00,
     &1.4692E-02,3.2398E-01,6.4788E-01,9.7210E-01,1.2967E+00,1.6219E+00,
     &1.9490E+00,2.2841E+00,2.5932E+00/
      DATA ((KA(JS,JT, 7,10),JS=1,9),JT=1,5) /
     &2.5736E-02,2.1730E-01,3.9499E-01,5.9240E-01,7.9003E-01,9.8783E-01,
     &1.1864E+00,1.3877E+00,1.5798E+00,2.6391E-02,2.3410E-01,4.4100E-01,
     &6.6147E-01,8.8204E-01,1.1029E+00,1.3242E+00,1.5482E+00,1.7637E+00,
     &2.6951E-02,2.5201E-01,4.8957E-01,7.3433E-01,9.7905E-01,1.2243E+00,
     &1.4699E+00,1.7185E+00,1.9578E+00,2.7390E-02,2.7020E-01,5.3407E-01,
     &8.0106E-01,1.0682E+00,1.3359E+00,1.6042E+00,1.8761E+00,2.1361E+00,
     &2.8064E-02,2.8861E-01,5.7611E-01,8.6397E-01,1.1521E+00,1.4408E+00,
     &1.7300E+00,2.0229E+00,2.3040E+00/
      DATA ((KA(JS,JT, 8,10),JS=1,9),JT=1,5) /
     &5.8578E-02,2.6880E-01,4.0001E-01,5.2061E-01,6.7938E-01,8.4922E-01,
     &1.0194E+00,1.1905E+00,1.3581E+00,6.0087E-02,2.9139E-01,4.3501E-01,
     &5.7583E-01,7.6491E-01,9.5619E-01,1.1477E+00,1.3402E+00,1.5292E+00,
     &6.1083E-02,3.1400E-01,4.7010E-01,6.4266E-01,8.5685E-01,1.0710E+00,
     &1.2856E+00,1.5014E+00,1.7131E+00,6.2072E-02,3.3715E-01,5.0004E-01,
     &7.0498E-01,9.3980E-01,1.1748E+00,1.4102E+00,1.6468E+00,1.8789E+00,
     &6.3481E-02,3.5691E-01,5.2888E-01,7.6432E-01,1.0191E+00,1.2740E+00,
     &1.5290E+00,1.7860E+00,2.0375E+00/
      DATA ((KA(JS,JT, 9,10),JS=1,9),JT=1,5) /
     &2.5051E-01,4.8216E-01,6.3956E-01,7.5081E-01,8.3417E-01,8.8639E-01,
     &9.0389E-01,1.0106E+00,1.1541E+00,2.5603E-01,5.1856E-01,6.9227E-01,
     &8.2007E-01,9.1537E-01,9.7189E-01,9.9778E-01,1.1454E+00,1.3083E+00,
     &2.6013E-01,5.5198E-01,7.4416E-01,8.8806E-01,9.9547E-01,1.0583E+00,
     &1.1091E+00,1.2896E+00,1.4729E+00,2.6455E-01,5.8224E-01,7.9653E-01,
     &9.5696E-01,1.0752E+00,1.1310E+00,1.2203E+00,1.4235E+00,1.6258E+00,
     &2.6779E-01,6.1167E-01,8.4854E-01,1.0208E+00,1.1434E+00,1.1964E+00,
     &1.3330E+00,1.5553E+00,1.7761E+00/
      DATA ((KA(JS,JT,10,10),JS=1,9),JT=1,5) /
     &1.1877E+00,1.3423E+00,1.4114E+00,1.4638E+00,1.4747E+00,1.4384E+00,
     &1.3561E+00,1.1884E+00,9.6724E-01,1.2130E+00,1.4001E+00,1.4986E+00,
     &1.5677E+00,1.5910E+00,1.5689E+00,1.4918E+00,1.3127E+00,1.1039E+00,
     &1.2346E+00,1.4593E+00,1.5877E+00,1.6627E+00,1.7012E+00,1.6974E+00,
     &1.6231E+00,1.4376E+00,1.2384E+00,1.2516E+00,1.5151E+00,1.6747E+00,
     &1.7501E+00,1.8076E+00,1.8250E+00,1.7537E+00,1.5512E+00,1.3735E+00,
     &1.2661E+00,1.5638E+00,1.7522E+00,1.8374E+00,1.9121E+00,1.9420E+00,
     &1.8736E+00,1.6582E+00,1.5128E+00/
      DATA ((KA(JS,JT,11,10),JS=1,9),JT=1,5) /
     &1.9480E+00,2.0492E+00,2.0295E+00,1.9735E+00,1.8970E+00,1.7736E+00,
     &1.5866E+00,1.3339E+00,8.4829E-01,1.9908E+00,2.1211E+00,2.1260E+00,
     &2.0949E+00,2.0240E+00,1.9060E+00,1.7325E+00,1.4683E+00,9.6828E-01,
     &2.0285E+00,2.1879E+00,2.2239E+00,2.2116E+00,2.1470E+00,2.0366E+00,
     &1.8735E+00,1.6014E+00,1.0930E+00,2.0556E+00,2.2562E+00,2.3222E+00,
     &2.3233E+00,2.2648E+00,2.1592E+00,2.0072E+00,1.7228E+00,1.2296E+00,
     &2.0825E+00,2.3069E+00,2.4192E+00,2.4269E+00,2.3834E+00,2.2768E+00,
     &2.1248E+00,1.8445E+00,1.3568E+00/
      DATA ((KA(JS,JT,12,10),JS=1,9),JT=1,5) /
     &2.3362E+00,2.4153E+00,2.3669E+00,2.2577E+00,2.1055E+00,1.9147E+00,
     &1.6820E+00,1.3486E+00,7.4407E-01,2.3893E+00,2.4937E+00,2.4670E+00,
     &2.3773E+00,2.2296E+00,2.0482E+00,1.8201E+00,1.4800E+00,8.5242E-01,
     &2.4357E+00,2.5702E+00,2.5666E+00,2.4887E+00,2.3537E+00,2.1812E+00,
     &1.9511E+00,1.6049E+00,9.6662E-01,2.4652E+00,2.6456E+00,2.6664E+00,
     &2.5981E+00,2.4742E+00,2.3104E+00,2.0695E+00,1.7245E+00,1.0828E+00,
     &2.4945E+00,2.7001E+00,2.7645E+00,2.7014E+00,2.5936E+00,2.4312E+00,
     &2.1779E+00,1.8427E+00,1.2015E+00/
      DATA ((KA(JS,JT,13,10),JS=1,9),JT=1,5) /
     &2.2054E+00,2.3120E+00,2.2775E+00,2.1807E+00,2.0276E+00,1.8297E+00,
     &1.5931E+00,1.2531E+00,5.9202E-01,2.2559E+00,2.3878E+00,2.3725E+00,
     &2.2888E+00,2.1438E+00,1.9536E+00,1.7172E+00,1.3694E+00,6.7488E-01,
     &2.2951E+00,2.4612E+00,2.4689E+00,2.3923E+00,2.2596E+00,2.0732E+00,
     &1.8332E+00,1.4777E+00,7.6019E-01,2.3235E+00,2.5286E+00,2.5591E+00,
     &2.4947E+00,2.3722E+00,2.1862E+00,1.9383E+00,1.5857E+00,8.5248E-01,
     &2.3616E+00,2.5838E+00,2.6490E+00,2.5951E+00,2.4760E+00,2.2908E+00,
     &2.0454E+00,1.6895E+00,9.4490E-01/
      DATA ((KA(JS,JT, 1,11),JS=1,9),JT=1,5) /
     &9.3294E-04,5.3309E-01,1.0647E+00,1.5932E+00,2.1160E+00,2.6255E+00,
     &3.0986E+00,3.3968E+00,4.2319E+00,9.5345E-04,5.6455E-01,1.1277E+00,
     &1.6875E+00,2.2413E+00,2.7825E+00,3.2884E+00,3.6383E+00,4.4826E+00,
     &9.7241E-04,5.9098E-01,1.1810E+00,1.7692E+00,2.3540E+00,2.9286E+00,
     &3.4675E+00,3.8516E+00,4.7080E+00,9.8984E-04,6.1800E-01,1.2338E+00,
     &1.8462E+00,2.4536E+00,3.0526E+00,3.6266E+00,4.0600E+00,4.9071E+00,
     &1.0059E-03,6.4816E-01,1.2933E+00,1.9339E+00,2.5658E+00,3.1822E+00,
     &3.7668E+00,4.2510E+00,5.1316E+00/
      DATA ((KA(JS,JT, 2,11),JS=1,9),JT=1,5) /
     &1.5074E-03,5.1913E-01,1.0387E+00,1.5585E+00,2.0790E+00,2.5998E+00,
     &3.1169E+00,3.5984E+00,4.1578E+00,1.5417E-03,5.5254E-01,1.1053E+00,
     &1.6578E+00,2.2101E+00,2.7629E+00,3.3129E+00,3.8170E+00,4.4201E+00,
     &1.5713E-03,5.8438E-01,1.1685E+00,1.7524E+00,2.3358E+00,2.9174E+00,
     &3.4950E+00,4.0242E+00,4.6716E+00,1.5983E-03,6.1743E-01,1.2340E+00,
     &1.8490E+00,2.4617E+00,3.0691E+00,3.6659E+00,4.2202E+00,4.9233E+00,
     &1.6216E-03,6.5216E-01,1.3030E+00,1.9521E+00,2.5969E+00,3.2326E+00,
     &3.8472E+00,4.4004E+00,5.1936E+00/
      DATA ((KA(JS,JT, 3,11),JS=1,9),JT=1,5) /
     &3.2100E-03,4.8846E-01,9.7712E-01,1.4663E+00,1.9565E+00,2.4483E+00,
     &2.9445E+00,3.4602E+00,3.9130E+00,3.2832E-03,5.2715E-01,1.0544E+00,
     &1.5820E+00,2.1102E+00,2.6392E+00,3.1691E+00,3.7028E+00,4.2204E+00,
     &3.3509E-03,5.6319E-01,1.1265E+00,1.6900E+00,2.2533E+00,2.8179E+00,
     &3.3838E+00,3.9526E+00,4.5066E+00,3.4122E-03,6.0075E-01,1.2012E+00,
     &1.8012E+00,2.4005E+00,2.9988E+00,3.5947E+00,4.1839E+00,4.8011E+00,
     &3.4694E-03,6.3990E-01,1.2794E+00,1.9184E+00,2.5559E+00,3.1911E+00,
     &3.8197E+00,4.4273E+00,5.1119E+00/
      DATA ((KA(JS,JT, 4,11),JS=1,9),JT=1,5) /
     &6.8944E-03,4.5524E-01,9.1034E-01,1.3656E+00,1.8210E+00,2.2768E+00,
     &2.7339E+00,3.1966E+00,3.6419E+00,7.0719E-03,4.9844E-01,9.9694E-01,
     &1.4955E+00,1.9943E+00,2.4932E+00,2.9929E+00,3.4921E+00,3.9886E+00,
     &7.2326E-03,5.3850E-01,1.0768E+00,1.6152E+00,2.1534E+00,2.6917E+00,
     &3.2302E+00,3.7700E+00,4.3067E+00,7.3806E-03,5.7980E-01,1.1594E+00,
     &1.7389E+00,2.3180E+00,2.8967E+00,3.4739E+00,4.0439E+00,4.6359E+00,
     &7.4998E-03,6.1978E-01,1.2395E+00,1.8590E+00,2.4785E+00,3.0979E+00,
     &3.7146E+00,4.3244E+00,4.9568E+00/
      DATA ((KA(JS,JT, 5,11),JS=1,9),JT=1,5) /
     &1.3442E-02,4.2037E-01,8.4065E-01,1.2612E+00,1.6819E+00,2.1029E+00,
     &2.5255E+00,2.9520E+00,3.3637E+00,1.3797E-02,4.6626E-01,9.3234E-01,
     &1.3987E+00,1.8650E+00,2.3319E+00,2.7996E+00,3.2699E+00,3.7300E+00,
     &1.4112E-02,5.0925E-01,1.0185E+00,1.5280E+00,2.0375E+00,2.5478E+00,
     &3.0591E+00,3.5748E+00,4.0749E+00,1.4385E-02,5.5077E-01,1.1015E+00,
     &1.6526E+00,2.2034E+00,2.7548E+00,3.3072E+00,3.8625E+00,4.4066E+00,
     &1.4645E-02,5.9271E-01,1.1855E+00,1.7781E+00,2.3710E+00,2.9641E+00,
     &3.5574E+00,4.1512E+00,4.7419E+00/
      DATA ((KA(JS,JT, 6,11),JS=1,9),JT=1,5) /
     &2.4122E-02,3.8084E-01,7.6147E-01,1.1422E+00,1.5231E+00,1.9045E+00,
     &2.2870E+00,2.6730E+00,3.0460E+00,2.4797E-02,4.2571E-01,8.5136E-01,
     &1.2771E+00,1.7031E+00,2.1298E+00,2.5578E+00,2.9908E+00,3.4060E+00,
     &2.5418E-02,4.6778E-01,9.3545E-01,1.4036E+00,1.8720E+00,2.3409E+00,
     &2.8115E+00,3.2888E+00,3.7438E+00,2.5988E-02,5.1023E-01,1.0205E+00,
     &1.5308E+00,2.0415E+00,2.5527E+00,3.0658E+00,3.5842E+00,4.0828E+00,
     &2.6439E-02,5.5329E-01,1.1066E+00,1.6600E+00,2.2137E+00,2.7680E+00,
     &3.3240E+00,3.8852E+00,4.4272E+00/
      DATA ((KA(JS,JT, 7,11),JS=1,9),JT=1,5) /
     &4.4902E-02,3.4110E-01,6.7879E-01,1.0183E+00,1.3577E+00,1.6974E+00,
     &2.0380E+00,2.3811E+00,2.7150E+00,4.6257E-02,3.7900E-01,7.5783E-01,
     &1.1366E+00,1.5157E+00,1.8951E+00,2.2756E+00,2.6593E+00,3.0311E+00,
     &4.7417E-02,4.1838E-01,8.3644E-01,1.2549E+00,1.6732E+00,2.0920E+00,
     &2.5119E+00,2.9363E+00,3.3461E+00,4.8439E-02,4.5979E-01,9.1922E-01,
     &1.3788E+00,1.8387E+00,2.2989E+00,2.7602E+00,3.2261E+00,3.6771E+00,
     &4.9115E-02,5.0257E-01,1.0048E+00,1.5073E+00,2.0099E+00,2.5129E+00,
     &3.0174E+00,3.5268E+00,4.0195E+00/
      DATA ((KA(JS,JT, 8,11),JS=1,9),JT=1,5) /
     &9.9346E-02,4.0741E-01,6.1474E-01,8.8954E-01,1.1859E+00,1.4823E+00,
     &1.7793E+00,2.0775E+00,2.3709E+00,1.0236E-01,4.4079E-01,6.7253E-01,
     &9.9766E-01,1.3301E+00,1.6626E+00,1.9955E+00,2.3301E+00,2.6593E+00,
     &1.0516E-01,4.6951E-01,7.3794E-01,1.1060E+00,1.4745E+00,1.8432E+00,
     &2.2125E+00,2.5835E+00,2.9480E+00,1.0772E-01,4.9500E-01,8.1532E-01,
     &1.2227E+00,1.6302E+00,2.0375E+00,2.4456E+00,2.8562E+00,3.2595E+00,
     &1.0947E-01,5.2130E-01,8.9659E-01,1.3445E+00,1.7925E+00,2.2406E+00,
     &2.6897E+00,3.1404E+00,3.5840E+00/
      DATA ((KA(JS,JT, 9,11),JS=1,9),JT=1,5) /
     &4.1823E-01,7.9567E-01,1.0382E+00,1.1972E+00,1.2989E+00,1.3526E+00,
     &1.5261E+00,1.7800E+00,2.0331E+00,4.3170E-01,8.4637E-01,1.1195E+00,
     &1.3007E+00,1.4025E+00,1.4821E+00,1.7319E+00,2.0202E+00,2.3074E+00,
     &4.4387E-01,8.9320E-01,1.1954E+00,1.3918E+00,1.4965E+00,1.6263E+00,
     &1.9385E+00,2.2615E+00,2.5830E+00,4.5501E-01,9.4246E-01,1.2607E+00,
     &1.4727E+00,1.5878E+00,1.7989E+00,2.1575E+00,2.5169E+00,2.8754E+00,
     &4.6515E-01,9.9000E-01,1.3196E+00,1.5528E+00,1.6906E+00,1.9810E+00,
     &2.3767E+00,2.7728E+00,3.1676E+00/
      DATA ((KA(JS,JT,10,11),JS=1,9),JT=1,5) /
     &1.9805E+00,2.2049E+00,2.3763E+00,2.4479E+00,2.4732E+00,2.4264E+00,
     &2.2604E+00,1.8802E+00,1.7493E+00,2.0472E+00,2.3153E+00,2.5048E+00,
     &2.6141E+00,2.6517E+00,2.6235E+00,2.4547E+00,2.0470E+00,2.0043E+00,
     &2.1094E+00,2.4143E+00,2.6357E+00,2.7700E+00,2.8309E+00,2.7965E+00,
     &2.6317E+00,2.2035E+00,2.2660E+00,2.1647E+00,2.5051E+00,2.7487E+00,
     &2.9276E+00,2.9982E+00,2.9552E+00,2.7953E+00,2.3731E+00,2.5329E+00,
     &2.2155E+00,2.5942E+00,2.8618E+00,3.0775E+00,3.1500E+00,3.1109E+00,
     &2.9560E+00,2.5540E+00,2.7905E+00/
      DATA ((KA(JS,JT,11,11),JS=1,9),JT=1,5) /
     &3.3272E+00,3.3391E+00,3.4265E+00,3.3299E+00,3.1864E+00,3.0000E+00,
     &2.7382E+00,2.2548E+00,1.5937E+00,3.4245E+00,3.4923E+00,3.5888E+00,
     &3.5207E+00,3.3952E+00,3.2270E+00,2.9458E+00,2.4552E+00,1.8248E+00,
     &3.5147E+00,3.6350E+00,3.7493E+00,3.6979E+00,3.6003E+00,3.4366E+00,
     &3.1408E+00,2.6446E+00,2.0543E+00,3.5973E+00,3.7611E+00,3.8955E+00,
     &3.8697E+00,3.7999E+00,3.6320E+00,3.3291E+00,2.8219E+00,2.2769E+00,
     &3.6658E+00,3.8812E+00,4.0226E+00,4.0479E+00,3.9815E+00,3.8145E+00,
     &3.5185E+00,2.9782E+00,2.4861E+00/
      DATA ((KA(JS,JT,12,11),JS=1,9),JT=1,5) /
     &4.1187E+00,4.0374E+00,4.0352E+00,3.8356E+00,3.5772E+00,3.2668E+00,
     &2.8837E+00,2.3539E+00,1.4349E+00,4.2212E+00,4.1986E+00,4.2178E+00,
     &4.0426E+00,3.8006E+00,3.4932E+00,3.0942E+00,2.5554E+00,1.6369E+00,
     &4.3153E+00,4.3421E+00,4.3917E+00,4.2429E+00,4.0161E+00,3.6975E+00,
     &3.3039E+00,2.7454E+00,1.8396E+00,4.3996E+00,4.4753E+00,4.5481E+00,
     &4.4345E+00,4.2153E+00,3.8944E+00,3.5079E+00,2.9264E+00,2.0403E+00,
     &4.4754E+00,4.5978E+00,4.6899E+00,4.6220E+00,4.4006E+00,4.0838E+00,
     &3.7036E+00,3.0926E+00,2.2349E+00/
      DATA ((KA(JS,JT,13,11),JS=1,9),JT=1,5) /
     &4.0592E+00,4.0332E+00,3.9681E+00,3.7590E+00,3.4963E+00,3.1626E+00,
     &2.7397E+00,2.2238E+00,1.2732E+00,4.1472E+00,4.1742E+00,4.1368E+00,
     &3.9606E+00,3.7120E+00,3.3731E+00,2.9427E+00,2.4115E+00,1.4537E+00,
     &4.2292E+00,4.3011E+00,4.2979E+00,4.1507E+00,3.9119E+00,3.5700E+00,
     &3.1423E+00,2.5914E+00,1.6282E+00,4.3001E+00,4.4170E+00,4.4457E+00,
     &4.3341E+00,4.0986E+00,3.7637E+00,3.3341E+00,2.7592E+00,1.8128E+00,
     &4.3627E+00,4.5278E+00,4.5856E+00,4.5011E+00,4.2740E+00,3.9472E+00,
     &3.5112E+00,2.9185E+00,1.9901E+00/
      DATA ((KA(JS,JT, 1,12),JS=1,9),JT=1,5) /
     &1.2832E-03,7.6911E-01,1.5308E+00,2.2815E+00,3.0131E+00,3.7102E+00,
     &4.3339E+00,4.8156E+00,6.0262E+00,1.3165E-03,8.3137E-01,1.6545E+00,
     &2.4655E+00,3.2561E+00,4.0092E+00,4.6800E+00,5.1382E+00,6.5123E+00,
     &1.3465E-03,8.9467E-01,1.7805E+00,2.6534E+00,3.5040E+00,4.3130E+00,
     &5.0270E+00,5.5081E+00,7.0080E+00,1.3733E-03,9.5420E-01,1.9011E+00,
     &2.8343E+00,3.7449E+00,4.6125E+00,5.3804E+00,5.8655E+00,7.4899E+00,
     &1.3973E-03,1.0065E+00,2.0056E+00,2.9931E+00,3.9616E+00,4.8908E+00,
     &5.7173E+00,6.2206E+00,7.9232E+00/
      DATA ((KA(JS,JT, 2,12),JS=1,9),JT=1,5) /
     &2.1567E-03,7.9503E-01,1.5851E+00,2.3675E+00,3.1367E+00,3.8805E+00,
     &4.5651E+00,5.0566E+00,6.2733E+00,2.2096E-03,8.5765E-01,1.7102E+00,
     &2.5549E+00,3.3862E+00,4.1922E+00,4.9361E+00,5.4818E+00,6.7723E+00,
     &2.2593E-03,9.2132E-01,1.8371E+00,2.7441E+00,3.6360E+00,4.5001E+00,
     &5.3023E+00,5.9092E+00,7.2719E+00,2.3029E-03,9.7961E-01,1.9547E+00,
     &2.9227E+00,3.8771E+00,4.8047E+00,5.6684E+00,6.3211E+00,7.7542E+00,
     &2.3432E-03,1.0294E+00,2.0551E+00,3.0745E+00,4.0831E+00,5.0720E+00,
     &6.0082E+00,6.7230E+00,8.1662E+00/
      DATA ((KA(JS,JT, 3,12),JS=1,9),JT=1,5) /
     &4.8280E-03,7.9900E-01,1.5962E+00,2.3906E+00,3.1803E+00,3.9604E+00,
     &4.7157E+00,5.3732E+00,6.3605E+00,4.9522E-03,8.6159E-01,1.7217E+00,
     &2.5790E+00,3.4316E+00,4.2766E+00,5.0979E+00,5.8264E+00,6.8633E+00,
     &5.0521E-03,9.2450E-01,1.8472E+00,2.7674E+00,3.6829E+00,4.5888E+00,
     &5.4724E+00,6.2581E+00,7.3659E+00,5.1417E-03,9.8492E-01,1.9684E+00,
     &2.9494E+00,3.9267E+00,4.8950E+00,5.8398E+00,6.6855E+00,7.8533E+00,
     &5.2128E-03,1.0351E+00,2.0685E+00,3.1013E+00,4.1304E+00,5.1536E+00,
     &6.1563E+00,7.0696E+00,8.2608E+00/
      DATA ((KA(JS,JT, 4,12),JS=1,9),JT=1,5) /
     &1.0891E-02,7.7727E-01,1.5543E+00,2.3309E+00,3.1067E+00,3.8812E+00,
     &4.6512E+00,5.4004E+00,6.2133E+00,1.1146E-02,8.4013E-01,1.6801E+00,
     &2.5195E+00,3.3588E+00,4.1965E+00,5.0315E+00,5.8522E+00,6.7175E+00,
     &1.1369E-02,9.0347E-01,1.8066E+00,2.7094E+00,3.6116E+00,4.5128E+00,
     &5.4097E+00,6.2868E+00,7.2231E+00,1.1543E-02,9.6345E-01,1.9267E+00,
     &2.8898E+00,3.8526E+00,4.8146E+00,5.7741E+00,6.7146E+00,7.7051E+00,
     &1.1696E-02,1.0158E+00,2.0314E+00,3.0468E+00,4.0618E+00,5.0772E+00,
     &6.0909E+00,7.0982E+00,8.1235E+00/
      DATA ((KA(JS,JT, 5,12),JS=1,9),JT=1,5) /
     &2.2302E-02,7.3490E-01,1.4696E+00,2.2046E+00,2.9394E+00,3.6745E+00,
     &4.4097E+00,5.1450E+00,5.8787E+00,2.2823E-02,7.9768E-01,1.5952E+00,
     &2.3932E+00,3.1913E+00,3.9900E+00,4.7899E+00,5.5934E+00,6.3823E+00,
     &2.3280E-02,8.5775E-01,1.7153E+00,2.5734E+00,3.4313E+00,4.2902E+00,
     &5.1502E+00,6.0153E+00,6.8623E+00,2.3683E-02,9.1895E-01,1.8383E+00,
     &2.7574E+00,3.6772E+00,4.5980E+00,5.5202E+00,6.4486E+00,7.3542E+00,
     &2.3999E-02,9.7537E-01,1.9505E+00,2.9260E+00,3.9018E+00,4.8784E+00,
     &5.8576E+00,6.8447E+00,7.8034E+00/
      DATA ((KA(JS,JT, 6,12),JS=1,9),JT=1,5) /
     &4.2265E-02,6.7923E-01,1.3583E+00,2.0372E+00,2.7164E+00,3.3965E+00,
     &4.0771E+00,4.7611E+00,5.4325E+00,4.3312E-02,7.4027E-01,1.4802E+00,
     &2.2203E+00,2.9606E+00,3.7016E+00,4.4440E+00,5.1934E+00,5.9209E+00,
     &4.4154E-02,8.0193E-01,1.6036E+00,2.4053E+00,3.2071E+00,4.0091E+00,
     &4.8130E+00,5.6200E+00,6.4137E+00,4.4818E-02,8.6447E-01,1.7287E+00,
     &2.5931E+00,3.4580E+00,4.3234E+00,5.1892E+00,6.0606E+00,6.9157E+00,
     &4.5427E-02,9.2353E-01,1.8468E+00,2.7701E+00,3.6940E+00,4.6182E+00,
     &5.5436E+00,6.4744E+00,7.3877E+00/
      DATA ((KA(JS,JT, 7,12),JS=1,9),JT=1,5) /
     &8.2851E-02,6.1813E-01,1.2353E+00,1.8525E+00,2.4701E+00,3.0880E+00,
     &3.7064E+00,4.3285E+00,4.9392E+00,8.4778E-02,6.8174E-01,1.3624E+00,
     &2.0434E+00,2.7245E+00,3.4060E+00,4.0883E+00,4.7735E+00,5.4481E+00,
     &8.6620E-02,7.4569E-01,1.4908E+00,2.2359E+00,2.9814E+00,3.7272E+00,
     &4.4733E+00,5.2220E+00,5.9623E+00,8.8221E-02,8.0972E-01,1.6191E+00,
     &2.4284E+00,3.2380E+00,4.0476E+00,4.8581E+00,5.6715E+00,6.4756E+00,
     &8.9388E-02,8.6929E-01,1.7383E+00,2.6072E+00,3.4769E+00,4.3464E+00,
     &5.2172E+00,6.0912E+00,6.9533E+00/
      DATA ((KA(JS,JT, 8,12),JS=1,9),JT=1,5) /
     &1.9209E-01,6.2527E-01,1.1133E+00,1.6689E+00,2.2244E+00,2.7803E+00,
     &3.3362E+00,3.8938E+00,4.4464E+00,1.9727E-01,6.6108E-01,1.2430E+00,
     &1.8635E+00,2.4844E+00,3.1054E+00,3.7267E+00,4.3504E+00,4.9671E+00,
     &2.0144E-01,7.0485E-01,1.3718E+00,2.0572E+00,2.7423E+00,3.4280E+00,
     &4.1141E+00,4.8012E+00,5.4833E+00,2.0484E-01,7.5576E-01,1.4986E+00,
     &2.2473E+00,2.9964E+00,3.7450E+00,4.4951E+00,5.2469E+00,5.9915E+00,
     &2.0777E-01,8.0793E-01,1.6132E+00,2.4193E+00,3.2252E+00,4.0323E+00,
     &4.8391E+00,5.6481E+00,6.4494E+00/
      DATA ((KA(JS,JT, 9,12),JS=1,9),JT=1,5) /
     &8.2620E-01,1.3515E+00,1.6396E+00,1.8633E+00,2.0617E+00,2.4827E+00,
     &2.9771E+00,3.4729E+00,3.9666E+00,8.4850E-01,1.4155E+00,1.7443E+00,
     &1.9664E+00,2.2558E+00,2.7862E+00,3.3424E+00,3.8990E+00,4.4541E+00,
     &8.6743E-01,1.4840E+00,1.8355E+00,2.0729E+00,2.4805E+00,3.0958E+00,
     &3.7138E+00,4.3325E+00,4.9497E+00,8.8373E-01,1.5402E+00,1.9288E+00,
     &2.1892E+00,2.7106E+00,3.3871E+00,4.0635E+00,4.7407E+00,5.4157E+00,
     &8.9622E-01,1.5897E+00,2.0124E+00,2.3107E+00,2.9348E+00,3.6673E+00,
     &4.4005E+00,5.1335E+00,5.8643E+00/
      DATA ((KA(JS,JT,10,12),JS=1,9),JT=1,5) /
     &3.9173E+00,3.9928E+00,4.3366E+00,4.4280E+00,4.2663E+00,3.9998E+00,
     &3.6166E+00,3.1308E+00,3.5126E+00,4.0212E+00,4.1687E+00,4.5593E+00,
     &4.6368E+00,4.5220E+00,4.2834E+00,3.8634E+00,3.4894E+00,3.9713E+00,
     &4.1147E+00,4.3230E+00,4.7454E+00,4.8522E+00,4.7749E+00,4.5433E+00,
     &4.0957E+00,3.8708E+00,4.4196E+00,4.1890E+00,4.4586E+00,4.9236E+00,
     &5.0494E+00,4.9988E+00,4.8016E+00,4.3028E+00,4.2486E+00,4.8508E+00,
     &4.2486E+00,4.5669E+00,5.0902E+00,5.2222E+00,5.2265E+00,5.0216E+00,
     &4.5057E+00,4.6204E+00,5.2753E+00/
      DATA ((KA(JS,JT,11,12),JS=1,9),JT=1,5) /
     &6.5008E+00,6.1849E+00,6.2789E+00,6.2685E+00,5.9393E+00,5.4109E+00,
     &4.7099E+00,3.7046E+00,3.2687E+00,6.6711E+00,6.4071E+00,6.5745E+00,
     &6.5690E+00,6.2447E+00,5.7486E+00,5.0466E+00,3.9652E+00,3.6849E+00,
     &6.8141E+00,6.5961E+00,6.8266E+00,6.8425E+00,6.5425E+00,6.0645E+00,
     &5.3679E+00,4.1951E+00,4.0848E+00,6.9309E+00,6.7641E+00,7.0497E+00,
     &7.0951E+00,6.8173E+00,6.3688E+00,5.6628E+00,4.4427E+00,4.4838E+00,
     &7.0334E+00,6.9031E+00,7.2676E+00,7.3125E+00,7.0679E+00,6.6762E+00,
     &5.9144E+00,4.7231E+00,4.9084E+00/
      DATA ((KA(JS,JT,12,12),JS=1,9),JT=1,5) /
     &8.0356E+00,7.5209E+00,7.4229E+00,7.2434E+00,6.7979E+00,6.1202E+00,
     &5.2895E+00,4.1070E+00,2.9936E+00,8.2347E+00,7.7748E+00,7.7310E+00,
     &7.5713E+00,7.1351E+00,6.4951E+00,5.6590E+00,4.4043E+00,3.3743E+00,
     &8.4084E+00,7.9908E+00,8.0012E+00,7.8714E+00,7.4600E+00,6.8499E+00,
     &6.0055E+00,4.6706E+00,3.7574E+00,8.5546E+00,8.1702E+00,8.2474E+00,
     &8.1496E+00,7.7631E+00,7.1869E+00,6.3250E+00,4.9362E+00,4.1426E+00,
     &8.6676E+00,8.3299E+00,8.4723E+00,8.3950E+00,8.0405E+00,7.5149E+00,
     &6.6159E+00,5.2129E+00,4.5254E+00/
      DATA ((KA(JS,JT,13,12),JS=1,9),JT=1,5) /
     &7.9759E+00,7.5343E+00,7.4503E+00,7.1563E+00,6.6524E+00,6.0033E+00,
     &5.2080E+00,4.0643E+00,2.7278E+00,8.1794E+00,7.7874E+00,7.7473E+00,
     &7.4642E+00,6.9912E+00,6.3834E+00,5.5711E+00,4.3572E+00,3.0821E+00,
     &8.3457E+00,8.0091E+00,8.0057E+00,7.7578E+00,7.3258E+00,6.7364E+00,
     &5.9096E+00,4.6439E+00,3.4477E+00,8.4812E+00,8.2074E+00,8.2395E+00,
     &8.0326E+00,7.6295E+00,7.0667E+00,6.2213E+00,4.9334E+00,3.7948E+00,
     &8.5914E+00,8.3651E+00,8.4655E+00,8.2768E+00,7.9296E+00,7.3785E+00,
     &6.5133E+00,5.2165E+00,4.1485E+00/
      DATA ((KA(JS,JT, 1,13),JS=1,9),JT=1,5) /
     &1.8376E-03,1.2493E+00,2.4869E+00,3.7066E+00,4.8962E+00,6.0283E+00,
     &7.0325E+00,7.5732E+00,9.7924E+00,1.8435E-03,1.3137E+00,2.6151E+00,
     &3.8978E+00,5.1474E+00,6.3345E+00,7.3693E+00,7.9436E+00,1.0295E+01,
     &1.8457E-03,1.3823E+00,2.7512E+00,4.0980E+00,5.4060E+00,6.6439E+00,
     &7.7282E+00,8.2817E+00,1.0812E+01,1.8458E-03,1.4480E+00,2.8814E+00,
     &4.2920E+00,5.6663E+00,6.9707E+00,8.1084E+00,8.6593E+00,1.1333E+01,
     &1.8581E-03,1.5191E+00,3.0214E+00,4.4961E+00,5.9276E+00,7.2804E+00,
     &8.4721E+00,9.0750E+00,1.1855E+01/
      DATA ((KA(JS,JT, 2,13),JS=1,9),JT=1,5) /
     &3.0081E-03,1.2887E+00,2.5721E+00,3.8463E+00,5.1064E+00,6.3378E+00,
     &7.4987E+00,8.3933E+00,1.0213E+01,3.0389E-03,1.3599E+00,2.7131E+00,
     &4.0552E+00,5.3783E+00,6.6678E+00,7.8772E+00,8.7981E+00,1.0756E+01,
     &3.0623E-03,1.4308E+00,2.8555E+00,4.2711E+00,5.6674E+00,7.0255E+00,
     &8.2810E+00,9.2099E+00,1.1335E+01,3.1073E-03,1.4998E+00,2.9927E+00,
     &4.4738E+00,5.9361E+00,7.3612E+00,8.6975E+00,9.6506E+00,1.1872E+01,
     &3.1371E-03,1.5763E+00,3.1432E+00,4.6958E+00,6.2242E+00,7.7091E+00,
     &9.0917E+00,1.0108E+01,1.2448E+01/
      DATA ((KA(JS,JT, 3,13),JS=1,9),JT=1,5) /
     &6.7566E-03,1.3010E+00,2.6001E+00,3.8967E+00,5.1878E+00,6.4676E+00,
     &7.7183E+00,8.8575E+00,1.0376E+01,6.8655E-03,1.3725E+00,2.7424E+00,
     &4.1083E+00,5.4679E+00,6.8133E+00,8.1286E+00,9.3210E+00,1.0936E+01,
     &7.0162E-03,1.4463E+00,2.8900E+00,4.3294E+00,5.7613E+00,7.1793E+00,
     &8.5582E+00,9.7979E+00,1.1523E+01,7.1355E-03,1.5186E+00,3.0341E+00,
     &4.5447E+00,6.0464E+00,7.5309E+00,8.9783E+00,1.0290E+01,1.2093E+01,
     &7.2326E-03,1.6009E+00,3.1979E+00,4.7883E+00,6.3681E+00,7.9274E+00,
     &9.4396E+00,1.0789E+01,1.2736E+01/
      DATA ((KA(JS,JT, 4,13),JS=1,9),JT=1,5) /
     &1.5770E-02,1.2974E+00,2.5940E+00,3.8891E+00,5.1823E+00,6.4711E+00,
     &7.7497E+00,8.9872E+00,1.0364E+01,1.6102E-02,1.3725E+00,2.7438E+00,
     &4.1133E+00,5.4792E+00,6.8384E+00,8.1824E+00,9.4681E+00,1.0958E+01,
     &1.6461E-02,1.4529E+00,2.9044E+00,4.3540E+00,5.7994E+00,7.2375E+00,
     &8.6575E+00,1.0008E+01,1.1599E+01,1.6764E-02,1.5336E+00,3.0659E+00,
     &4.5952E+00,6.1201E+00,7.6366E+00,9.1307E+00,1.0552E+01,1.2240E+01,
     &1.6983E-02,1.6203E+00,3.2389E+00,4.8548E+00,6.4661E+00,8.0668E+00,
     &9.6455E+00,1.1132E+01,1.2932E+01/
      DATA ((KA(JS,JT, 5,13),JS=1,9),JT=1,5) /
     &3.3958E-02,1.2926E+00,2.5850E+00,3.8765E+00,5.1671E+00,6.4548E+00,
     &7.7382E+00,9.0001E+00,1.0334E+01,3.4722E-02,1.3756E+00,2.7505E+00,
     &4.1243E+00,5.4969E+00,6.8654E+00,8.2252E+00,9.5545E+00,1.0994E+01,
     &3.5363E-02,1.4648E+00,2.9290E+00,4.3919E+00,5.8529E+00,7.3099E+00,
     &8.7568E+00,1.0164E+01,1.1706E+01,3.6012E-02,1.5505E+00,3.1003E+00,
     &4.6491E+00,6.1954E+00,7.7382E+00,9.2690E+00,1.0761E+01,1.2391E+01,
     &3.6453E-02,1.6361E+00,3.2714E+00,4.9053E+00,6.5374E+00,8.1645E+00,
     &9.7803E+00,1.1352E+01,1.3075E+01/
      DATA ((KA(JS,JT, 6,13),JS=1,9),JT=1,5) /
     &6.7837E-02,1.2756E+00,2.5511E+00,3.8262E+00,5.1016E+00,6.3755E+00,
     &7.6486E+00,8.9147E+00,1.0203E+01,6.9368E-02,1.3655E+00,2.7307E+00,
     &4.0953E+00,5.4595E+00,6.8218E+00,8.1822E+00,9.5288E+00,1.0919E+01,
     &7.0610E-02,1.4598E+00,2.9193E+00,4.3789E+00,5.8375E+00,7.2946E+00,
     &8.7480E+00,1.0185E+01,1.1675E+01,7.1895E-02,1.5499E+00,3.0992E+00,
     &4.6481E+00,6.1963E+00,7.7431E+00,9.2863E+00,1.0814E+01,1.2392E+01,
     &7.2713E-02,1.6401E+00,3.2796E+00,4.9184E+00,6.5572E+00,8.1927E+00,
     &9.8252E+00,1.1440E+01,1.3114E+01/
      DATA ((KA(JS,JT, 7,13),JS=1,9),JT=1,5) /
     &1.4148E-01,1.2306E+00,2.4611E+00,3.6917E+00,4.9218E+00,6.1530E+00,
     &7.3843E+00,8.6153E+00,9.8436E+00,1.4468E-01,1.3267E+00,2.6534E+00,
     &3.9799E+00,5.3067E+00,6.6328E+00,7.9589E+00,9.2835E+00,1.0613E+01,
     &1.4723E-01,1.4271E+00,2.8538E+00,4.2801E+00,5.7062E+00,7.1323E+00,
     &8.5577E+00,9.9797E+00,1.1412E+01,1.4959E-01,1.5234E+00,3.0460E+00,
     &4.5687E+00,6.0905E+00,7.6133E+00,9.1342E+00,1.0653E+01,1.2180E+01,
     &1.5109E-01,1.6156E+00,3.2301E+00,4.8444E+00,6.4594E+00,8.0732E+00,
     &9.6859E+00,1.1294E+01,1.2918E+01/
      DATA ((KA(JS,JT, 8,13),JS=1,9),JT=1,5) /
     &3.4983E-01,1.1544E+00,2.3087E+00,3.4632E+00,4.6176E+00,5.7728E+00,
     &6.9283E+00,8.0852E+00,9.2350E+00,3.5757E-01,1.2554E+00,2.5092E+00,
     &3.7633E+00,5.0176E+00,6.2716E+00,7.5265E+00,8.7822E+00,1.0034E+01,
     &3.6359E-01,1.3606E+00,2.7192E+00,4.0780E+00,5.4366E+00,6.7958E+00,
     &8.1543E+00,9.5151E+00,1.0871E+01,3.6947E-01,1.4619E+00,2.9219E+00,
     &4.3820E+00,5.8417E+00,7.3019E+00,8.7622E+00,1.0223E+01,1.1681E+01,
     &3.7269E-01,1.5629E+00,3.1234E+00,4.6839E+00,6.2445E+00,7.8052E+00,
     &9.3661E+00,1.0928E+01,1.2487E+01/
      DATA ((KA(JS,JT, 9,13),JS=1,9),JT=1,5) /
     &1.6120E+00,2.1579E+00,2.5856E+00,3.2058E+00,4.2226E+00,5.2767E+00,
     &6.3317E+00,7.3871E+00,8.4404E+00,1.6481E+00,2.2537E+00,2.6687E+00,
     &3.4901E+00,4.6465E+00,5.8062E+00,6.9659E+00,8.1266E+00,9.2849E+00,
     &1.6791E+00,2.3216E+00,2.7898E+00,3.8113E+00,5.0781E+00,6.3453E+00,
     &7.6127E+00,8.8803E+00,1.0146E+01,1.7002E+00,2.3849E+00,2.9226E+00,
     &4.1389E+00,5.5144E+00,6.8902E+00,8.2665E+00,9.6440E+00,1.1018E+01,
     &1.7139E+00,2.4356E+00,3.0744E+00,4.4589E+00,5.9418E+00,7.4246E+00,
     &8.9078E+00,1.0391E+01,1.1873E+01/
      DATA ((KA(JS,JT,10,13),JS=1,9),JT=1,5) /
     &8.1900E+00,7.5735E+00,7.5164E+00,7.4868E+00,7.2490E+00,6.5441E+00,
     &6.0001E+00,6.6902E+00,7.6402E+00,8.3686E+00,7.7990E+00,7.8449E+00,
     &7.8651E+00,7.5310E+00,6.7442E+00,6.5109E+00,7.4533E+00,8.5097E+00,
     &8.5094E+00,8.0068E+00,8.1129E+00,8.1601E+00,7.7387E+00,7.0241E+00,
     &7.1098E+00,8.2483E+00,9.4190E+00,8.6083E+00,8.1729E+00,8.3302E+00,
     &8.3900E+00,7.9589E+00,7.3305E+00,7.7681E+00,9.0471E+00,1.0331E+01,
     &8.6642E+00,8.2947E+00,8.5084E+00,8.6017E+00,8.1354E+00,7.7044E+00,
     &8.4486E+00,9.8464E+00,1.1244E+01/
      DATA ((KA(JS,JT,11,13),JS=1,9),JT=1,5) /
     &1.4422E+01,1.2923E+01,1.2146E+01,1.1467E+01,1.0797E+01,9.7043E+00,
     &7.9341E+00,6.4523E+00,7.2283E+00,1.4693E+01,1.3224E+01,1.2546E+01,
     &1.1961E+01,1.1284E+01,1.0051E+01,8.2717E+00,7.1710E+00,8.1411E+00,
     &1.4865E+01,1.3437E+01,1.2872E+01,1.2352E+01,1.1673E+01,1.0373E+01,
     &8.6477E+00,7.9776E+00,9.0911E+00,1.4985E+01,1.3594E+01,1.3136E+01,
     &1.2689E+01,1.2000E+01,1.0700E+01,9.0501E+00,8.7877E+00,1.0028E+01,
     &1.5049E+01,1.3704E+01,1.3344E+01,1.2975E+01,1.2311E+01,1.0977E+01,
     &9.5392E+00,9.6092E+00,1.0970E+01/
      DATA ((KA(JS,JT,12,13),JS=1,9),JT=1,5) /
     &1.8498E+01,1.6493E+01,1.5330E+01,1.4296E+01,1.3227E+01,1.1776E+01,
     &9.6093E+00,6.9105E+00,6.8698E+00,1.8757E+01,1.6799E+01,1.5767E+01,
     &1.4839E+01,1.3780E+01,1.2237E+01,1.0031E+01,7.5179E+00,7.8121E+00,
     &1.8947E+01,1.7036E+01,1.6095E+01,1.5249E+01,1.4223E+01,1.2650E+01,
     &1.0480E+01,8.1785E+00,8.7273E+00,1.9063E+01,1.7202E+01,1.6365E+01,
     &1.5574E+01,1.4614E+01,1.3047E+01,1.0927E+01,8.8781E+00,9.6514E+00,
     &1.9121E+01,1.7309E+01,1.6592E+01,1.5868E+01,1.4993E+01,1.3399E+01,
     &1.1411E+01,9.6204E+00,1.0609E+01/
      DATA ((KA(JS,JT,13,13),JS=1,9),JT=1,5) /
     &1.8681E+01,1.6791E+01,1.5759E+01,1.4851E+01,1.3770E+01,1.2167E+01,
     &1.0009E+01,7.2580E+00,6.5238E+00,1.8892E+01,1.7070E+01,1.6163E+01,
     &1.5373E+01,1.4290E+01,1.2645E+01,1.0505E+01,7.8149E+00,7.3987E+00,
     &1.9028E+01,1.7273E+01,1.6517E+01,1.5784E+01,1.4702E+01,1.3114E+01,
     &1.1026E+01,8.4153E+00,8.2894E+00,1.9122E+01,1.7418E+01,1.6814E+01,
     &1.6131E+01,1.5108E+01,1.3570E+01,1.1549E+01,9.0457E+00,9.1940E+00,
     &1.9151E+01,1.7520E+01,1.7041E+01,1.6440E+01,1.5494E+01,1.4010E+01,
     &1.2106E+01,9.7104E+00,1.0102E+01/
      DATA ((KA(JS,JT, 1,14),JS=1,9),JT=1,5) /
     &3.3087E-03,1.8715E+00,3.7152E+00,5.5155E+00,7.2487E+00,8.8573E+00,
     &1.0201E+01,1.0807E+01,1.4497E+01,3.2220E-03,1.9525E+00,3.8750E+00,
     &5.7533E+00,7.5552E+00,9.2212E+00,1.0608E+01,1.1197E+01,1.5110E+01,
     &3.1339E-03,2.0260E+00,4.0195E+00,5.9653E+00,7.8344E+00,9.5608E+00,
     &1.0981E+01,1.1562E+01,1.5669E+01,3.0455E-03,2.1060E+00,4.1769E+00,
     &6.1939E+00,8.1222E+00,9.8877E+00,1.1323E+01,1.1897E+01,1.6244E+01,
     &2.9339E-03,2.1869E+00,4.3369E+00,6.4318E+00,8.4325E+00,1.0262E+01,
     &1.1718E+01,1.2199E+01,1.6865E+01/
      DATA ((KA(JS,JT, 2,14),JS=1,9),JT=1,5) /
     &5.2878E-03,2.0475E+00,4.0760E+00,6.0751E+00,8.0240E+00,9.8767E+00,
     &1.1510E+01,1.2463E+01,1.6048E+01,5.1473E-03,2.1393E+00,4.2595E+00,
     &6.3491E+00,8.3874E+00,1.0326E+01,1.2039E+01,1.3009E+01,1.6775E+01,
     &5.0049E-03,2.2262E+00,4.4297E+00,6.5989E+00,8.7109E+00,1.0721E+01,
     &1.2503E+01,1.3517E+01,1.7422E+01,4.8227E-03,2.3172E+00,4.6099E+00,
     &6.8638E+00,9.0568E+00,1.1128E+01,1.2937E+01,1.3964E+01,1.8113E+01,
     &4.6542E-03,2.4084E+00,4.7911E+00,7.1333E+00,9.4086E+00,1.1557E+01,
     &1.3418E+01,1.4407E+01,1.8817E+01/
      DATA ((KA(JS,JT, 3,14),JS=1,9),JT=1,5) /
     &1.1438E-02,2.1889E+00,4.3692E+00,6.5353E+00,8.6778E+00,1.0773E+01,
     &1.2758E+01,1.4346E+01,1.7356E+01,1.1139E-02,2.3041E+00,4.5995E+00,
     &6.8793E+00,9.1316E+00,1.1334E+01,1.3411E+01,1.5052E+01,1.8263E+01,
     &1.0770E-02,2.4104E+00,4.8103E+00,7.1935E+00,9.5485E+00,1.1847E+01,
     &1.4017E+01,1.5716E+01,1.9097E+01,1.0423E-02,2.5146E+00,5.0181E+00,
     &7.5021E+00,9.9570E+00,1.2351E+01,1.4597E+01,1.6319E+01,1.9914E+01,
     &1.0104E-02,2.6169E+00,5.2203E+00,7.8059E+00,1.0356E+01,1.2839E+01,
     &1.5169E+01,1.6937E+01,2.0712E+01/
      DATA ((KA(JS,JT, 4,14),JS=1,9),JT=1,5) /
     &2.5365E-02,2.3050E+00,4.6063E+00,6.9017E+00,9.1853E+00,1.1448E+01,
     &1.3656E+01,1.5659E+01,1.8370E+01,2.4778E-02,2.4401E+00,4.8764E+00,
     &7.3060E+00,9.7240E+00,1.2119E+01,1.4458E+01,1.6580E+01,1.9448E+01,
     &2.4097E-02,2.5614E+00,5.1183E+00,7.6688E+00,1.0206E+01,1.2719E+01,
     &1.5172E+01,1.7403E+01,2.0411E+01,2.3478E-02,2.6774E+00,5.3500E+00,
     &8.0159E+00,1.0665E+01,1.3289E+01,1.5848E+01,1.8161E+01,2.1330E+01,
     &2.2944E-02,2.7978E+00,5.5896E+00,8.3727E+00,1.1139E+01,1.3876E+01,
     &1.6535E+01,1.8911E+01,2.2278E+01/
      DATA ((KA(JS,JT, 5,14),JS=1,9),JT=1,5) /
     &5.2400E-02,2.3882E+00,4.7744E+00,7.1579E+00,9.5370E+00,1.1906E+01,
     &1.4251E+01,1.6502E+01,1.9074E+01,5.1529E-02,2.5417E+00,5.0820E+00,
     &7.6184E+00,1.0150E+01,1.2670E+01,1.5165E+01,1.7564E+01,2.0300E+01,
     &5.0713E-02,2.6834E+00,5.3644E+00,8.0415E+00,1.0713E+01,1.3375E+01,
     &1.6005E+01,1.8525E+01,2.1426E+01,4.9736E-02,2.8194E+00,5.6359E+00,
     &8.4488E+00,1.1255E+01,1.4048E+01,1.6805E+01,1.9440E+01,2.2511E+01,
     &4.8999E-02,2.9595E+00,5.9157E+00,8.8682E+00,1.1813E+01,1.4742E+01,
     &1.7634E+01,2.0380E+01,2.3625E+01/
      DATA ((KA(JS,JT, 6,14),JS=1,9),JT=1,5) /
     &1.0351E-01,2.4306E+00,4.8601E+00,7.2890E+00,9.7147E+00,1.2135E+01,
     &1.4543E+01,1.6905E+01,1.9429E+01,1.0255E-01,2.6140E+00,5.2274E+00,
     &7.8383E+00,1.0448E+01,1.3051E+01,1.5640E+01,1.8174E+01,2.0896E+01,
     &1.0183E-01,2.7755E+00,5.5503E+00,8.3234E+00,1.1093E+01,1.3857E+01,
     &1.6607E+01,1.9300E+01,2.2186E+01,1.0081E-01,2.9307E+00,5.8597E+00,
     &8.7876E+00,1.1711E+01,1.4627E+01,1.7527E+01,2.0360E+01,2.3422E+01,
     &1.0025E-01,3.0883E+00,6.1762E+00,9.2605E+00,1.2342E+01,1.5414E+01,
     &1.8466E+01,2.1444E+01,2.4683E+01/
      DATA ((KA(JS,JT, 7,14),JS=1,9),JT=1,5) /
     &2.1803E-01,2.4631E+00,4.9259E+00,7.3877E+00,9.8477E+00,1.2306E+01,
     &1.4757E+01,1.7182E+01,1.9695E+01,2.1806E-01,2.6703E+00,5.3400E+00,
     &8.0091E+00,1.0677E+01,1.3341E+01,1.6000E+01,1.8630E+01,2.1354E+01,
     &2.1815E-01,2.8507E+00,5.7004E+00,8.5504E+00,1.1399E+01,1.4242E+01,
     &1.7080E+01,1.9888E+01,2.2798E+01,2.1765E-01,3.0257E+00,6.0505E+00,
     &9.0745E+00,1.2096E+01,1.5115E+01,1.8125E+01,2.1099E+01,2.4193E+01,
     &2.1725E-01,3.2088E+00,6.4163E+00,9.6232E+00,1.2829E+01,1.6028E+01,
     &1.9219E+01,2.2369E+01,2.5657E+01/
      DATA ((KA(JS,JT, 8,14),JS=1,9),JT=1,5) /
     &5.5719E-01,2.4793E+00,4.9583E+00,7.4367E+00,9.9152E+00,1.2393E+01,
     &1.4868E+01,1.7332E+01,1.9830E+01,5.6059E-01,2.7128E+00,5.4248E+00,
     &8.1366E+00,1.0849E+01,1.3560E+01,1.6268E+01,1.8965E+01,2.1697E+01,
     &5.6435E-01,2.9177E+00,5.8349E+00,8.7514E+00,1.1668E+01,1.4583E+01,
     &1.7497E+01,2.0397E+01,2.3335E+01,5.6354E-01,3.1161E+00,6.2315E+00,
     &9.3470E+00,1.2462E+01,1.5576E+01,1.8684E+01,2.1779E+01,2.4923E+01,
     &5.6160E-01,3.3171E+00,6.6335E+00,9.9496E+00,1.3266E+01,1.6580E+01,
     &1.9888E+01,2.3183E+01,2.6532E+01/
      DATA ((KA(JS,JT, 9,14),JS=1,9),JT=1,5) /
     &2.7023E+00,3.1133E+00,4.9392E+00,7.4089E+00,9.8776E+00,1.2348E+01,
     &1.4816E+01,1.7282E+01,1.9755E+01,2.7329E+00,3.1899E+00,5.4498E+00,
     &8.1745E+00,1.0899E+01,1.3624E+01,1.6348E+01,1.9070E+01,2.1798E+01,
     &2.7414E+00,3.2928E+00,5.9087E+00,8.8629E+00,1.1816E+01,1.4770E+01,
     &1.7722E+01,2.0675E+01,2.3632E+01,2.7386E+00,3.4095E+00,6.3408E+00,
     &9.5112E+00,1.2680E+01,1.5850E+01,1.9019E+01,2.2186E+01,2.5359E+01,
     &2.7253E+00,3.5556E+00,6.7742E+00,1.0160E+01,1.3547E+01,1.6934E+01,
     &2.0319E+01,2.3701E+01,2.7094E+01/
      DATA ((KA(JS,JT,10,14),JS=1,9),JT=1,5) /
     &1.4620E+01,1.3012E+01,1.2093E+01,1.1252E+01,1.0888E+01,1.2263E+01,
     &1.4693E+01,1.7142E+01,1.9590E+01,1.4753E+01,1.3186E+01,1.2290E+01,
     &1.1490E+01,1.1589E+01,1.3604E+01,1.6324E+01,1.9044E+01,2.1765E+01,
     &1.4775E+01,1.3219E+01,1.2416E+01,1.1687E+01,1.2328E+01,1.4817E+01,
     &1.7779E+01,2.0743E+01,2.3705E+01,1.4749E+01,1.3203E+01,1.2546E+01,
     &1.1974E+01,1.3088E+01,1.5981E+01,1.9178E+01,2.2373E+01,2.5570E+01,
     &1.4700E+01,1.3186E+01,1.2659E+01,1.2331E+01,1.3931E+01,1.7138E+01,
     &2.0565E+01,2.3991E+01,2.7418E+01/
      DATA ((KA(JS,JT,11,14),JS=1,9),JT=1,5) /
     &2.7410E+01,2.3992E+01,2.1335E+01,1.9158E+01,1.6847E+01,1.4928E+01,
     &1.5265E+01,1.7677E+01,2.0202E+01,2.7494E+01,2.4097E+01,2.1553E+01,
     &1.9434E+01,1.7307E+01,1.5809E+01,1.6793E+01,1.9551E+01,2.2343E+01,
     &2.7540E+01,2.4181E+01,2.1730E+01,1.9742E+01,1.7701E+01,1.6732E+01,
     &1.8269E+01,2.1306E+01,2.4350E+01,2.7514E+01,2.4204E+01,2.1897E+01,
     &2.0034E+01,1.8171E+01,1.7696E+01,1.9766E+01,2.3053E+01,2.6341E+01,
     &2.7458E+01,2.4204E+01,2.2040E+01,2.0324E+01,1.8730E+01,1.8750E+01,
     &2.1236E+01,2.4764E+01,2.8296E+01/
      DATA ((KA(JS,JT,12,14),JS=1,9),JT=1,5) /
     &3.7739E+01,3.3022E+01,2.9081E+01,2.5731E+01,2.2384E+01,1.9192E+01,
     &1.6882E+01,1.7924E+01,2.0483E+01,3.7888E+01,3.3157E+01,2.9316E+01,
     &2.6118E+01,2.2987E+01,1.9918E+01,1.8210E+01,1.9805E+01,2.2631E+01,
     &3.7945E+01,3.3236E+01,2.9563E+01,2.6509E+01,2.3567E+01,2.0714E+01,
     &1.9521E+01,2.1672E+01,2.4760E+01,3.7956E+01,3.3289E+01,2.9765E+01,
     &2.6932E+01,2.4108E+01,2.1541E+01,2.0877E+01,2.3478E+01,2.6821E+01,
     &3.7967E+01,3.3331E+01,2.9953E+01,2.7347E+01,2.4651E+01,2.2457E+01,
     &2.2265E+01,2.5248E+01,2.8840E+01/
      DATA ((KA(JS,JT,13,14),JS=1,9),JT=1,5) /
     &4.1396E+01,3.6239E+01,3.2059E+01,2.8493E+01,2.4944E+01,2.1585E+01,
     &1.8204E+01,1.7791E+01,2.0316E+01,4.1543E+01,3.6421E+01,3.2427E+01,
     &2.9033E+01,2.5736E+01,2.2468E+01,1.9493E+01,1.9781E+01,2.2598E+01,
     &4.1678E+01,3.6592E+01,3.2739E+01,2.9584E+01,2.6500E+01,2.3336E+01,
     &2.0749E+01,2.1701E+01,2.4790E+01,4.1767E+01,3.6719E+01,3.3041E+01,
     &3.0106E+01,2.7204E+01,2.4205E+01,2.2086E+01,2.3604E+01,2.6962E+01,
     &4.1856E+01,3.6841E+01,3.3340E+01,3.0667E+01,2.7878E+01,2.5159E+01,
     &2.3471E+01,2.5553E+01,2.9188E+01/
      DATA ((KA(JS,JT, 1,15),JS=1,9),JT=1,5) /
     &4.1661E-03,3.0613E+00,6.0764E+00,9.0246E+00,1.1861E+01,1.4480E+01,
     &1.6622E+01,1.7284E+01,2.3722E+01,4.0148E-03,3.1418E+00,6.2320E+00,
     &9.2486E+00,1.2140E+01,1.4819E+01,1.7035E+01,1.7764E+01,2.4279E+01,
     &3.8658E-03,3.2144E+00,6.3745E+00,9.4527E+00,1.2398E+01,1.5111E+01,
     &1.7346E+01,1.8143E+01,2.4796E+01,3.7196E-03,3.2826E+00,6.5071E+00,
     &9.6422E+00,1.2633E+01,1.5374E+01,1.7599E+01,1.8433E+01,2.5267E+01,
     &3.5761E-03,3.3515E+00,6.6395E+00,9.8324E+00,1.2873E+01,1.5639E+01,
     &1.7844E+01,1.8646E+01,2.5747E+01/
      DATA ((KA(JS,JT, 2,15),JS=1,9),JT=1,5) /
     &6.8577E-03,3.3744E+00,6.7125E+00,9.9952E+00,1.3184E+01,1.6201E+01,
     &1.8839E+01,2.0375E+01,2.6368E+01,6.5948E-03,3.4888E+00,6.9393E+00,
     &1.0331E+01,1.3623E+01,1.6730E+01,1.9423E+01,2.0902E+01,2.7246E+01,
     &6.3372E-03,3.5940E+00,7.1483E+00,1.0636E+01,1.4019E+01,1.7199E+01,
     &1.9946E+01,2.1371E+01,2.8038E+01,6.0860E-03,3.6975E+00,7.3505E+00,
     &1.0936E+01,1.4402E+01,1.7655E+01,2.0430E+01,2.1802E+01,2.8803E+01,
     &5.8418E-03,3.7949E+00,7.5419E+00,1.1217E+01,1.4770E+01,1.8090E+01,
     &2.0913E+01,2.2203E+01,2.9539E+01/
      DATA ((KA(JS,JT, 3,15),JS=1,9),JT=1,5) /
     &1.5312E-02,3.7161E+00,7.4117E+00,1.1074E+01,1.4677E+01,1.8180E+01,
     &2.1427E+01,2.3812E+01,2.9355E+01,1.4697E-02,3.8703E+00,7.7181E+00,
     &1.1532E+01,1.5288E+01,1.8926E+01,2.2293E+01,2.4742E+01,3.0575E+01,
     &1.4095E-02,4.0069E+00,7.9901E+00,1.1939E+01,1.5823E+01,1.9587E+01,
     &2.3063E+01,2.5568E+01,3.1646E+01,1.3512E-02,4.1402E+00,8.2563E+00,
     &1.2333E+01,1.6342E+01,2.0226E+01,2.3806E+01,2.6351E+01,3.2684E+01,
     &1.2949E-02,4.2659E+00,8.5058E+00,1.2707E+01,1.6836E+01,2.0833E+01,
     &2.4517E+01,2.7109E+01,3.3673E+01/
      DATA ((KA(JS,JT, 4,15),JS=1,9),JT=1,5) /
     &3.5017E-02,4.0833E+00,8.1553E+00,1.2211E+01,1.6236E+01,2.0204E+01,
     &2.4024E+01,2.7316E+01,3.2472E+01,3.3537E-02,4.2828E+00,8.5541E+00,
     &1.2808E+01,1.7029E+01,2.1189E+01,2.5196E+01,2.8637E+01,3.4057E+01,
     &3.2113E-02,4.4600E+00,8.9081E+00,1.3336E+01,1.7733E+01,2.2059E+01,
     &2.6228E+01,2.9796E+01,3.5465E+01,3.0746E-02,4.6307E+00,9.2473E+00,
     &1.3839E+01,1.8403E+01,2.2892E+01,2.7214E+01,3.0894E+01,3.6805E+01,
     &2.9433E-02,4.7874E+00,9.5611E+00,1.4314E+01,1.9029E+01,2.3669E+01,
     &2.8132E+01,3.1929E+01,3.8057E+01/
      DATA ((KA(JS,JT, 5,15),JS=1,9),JT=1,5) /
     &7.3896E-02,4.4639E+00,8.9220E+00,1.3370E+01,1.7804E+01,2.2204E+01,
     &2.6523E+01,3.0537E+01,3.5608E+01,7.0692E-02,4.7138E+00,9.4187E+00,
     &1.4116E+01,1.8797E+01,2.3443E+01,2.8005E+01,3.2244E+01,3.7595E+01,
     &6.7622E-02,4.9383E+00,9.8707E+00,1.4791E+01,1.9696E+01,2.4560E+01,
     &2.9335E+01,3.3760E+01,3.9391E+01,6.4677E-02,5.1515E+00,1.0296E+01,
     &1.5428E+01,2.0542E+01,2.5616E+01,3.0597E+01,3.5203E+01,4.1084E+01,
     &6.1858E-02,5.3461E+00,1.0685E+01,1.6012E+01,2.1318E+01,2.6583E+01,
     &3.1750E+01,3.6527E+01,4.2635E+01/
      DATA ((KA(JS,JT, 6,15),JS=1,9),JT=1,5) /
     &1.4684E-01,4.8264E+00,9.6500E+00,1.4468E+01,1.9279E+01,2.4068E+01,
     &2.8816E+01,3.3389E+01,3.8558E+01,1.4028E-01,5.1303E+00,1.0258E+01,
     &1.5380E+01,2.0490E+01,2.5585E+01,3.0631E+01,3.5492E+01,4.0980E+01,
     &1.3401E-01,5.4150E+00,1.0825E+01,1.6231E+01,2.1624E+01,2.7001E+01,
     &3.2322E+01,3.7445E+01,4.3249E+01,1.2806E-01,5.6771E+00,1.1351E+01,
     &1.7018E+01,2.2674E+01,2.8310E+01,3.3887E+01,3.9255E+01,4.5348E+01,
     &1.2235E-01,5.9138E+00,1.1824E+01,1.7725E+01,2.3617E+01,2.9485E+01,
     &3.5301E+01,4.0890E+01,4.7234E+01/
      DATA ((KA(JS,JT, 7,15),JS=1,9),JT=1,5) /
     &3.0725E-01,5.1535E+00,1.0306E+01,1.5454E+01,2.0602E+01,2.5736E+01,
     &3.0848E+01,3.5878E+01,4.1204E+01,2.9321E-01,5.5259E+00,1.1050E+01,
     &1.6570E+01,2.2088E+01,2.7592E+01,3.3073E+01,3.8464E+01,4.4176E+01,
     &2.7993E-01,5.8735E+00,1.1744E+01,1.7612E+01,2.3476E+01,2.9329E+01,
     &3.5155E+01,4.0875E+01,4.6953E+01,2.6791E-01,6.1876E+00,1.2373E+01,
     &1.8557E+01,2.4734E+01,3.0898E+01,3.7039E+01,4.3070E+01,4.9468E+01,
     &2.5886E-01,6.4685E+00,1.2934E+01,1.9398E+01,2.5854E+01,3.2302E+01,
     &3.8716E+01,4.5022E+01,5.1708E+01/
      DATA ((KA(JS,JT, 8,15),JS=1,9),JT=1,5) /
     &7.7279E-01,5.4596E+00,1.0918E+01,1.6376E+01,2.1832E+01,2.7286E+01,
     &3.2729E+01,3.8130E+01,4.3663E+01,7.3823E-01,5.9033E+00,1.1807E+01,
     &1.7707E+01,2.3607E+01,2.9503E+01,3.5387E+01,4.1229E+01,4.7214E+01,
     &7.0825E-01,6.3158E+00,1.2632E+01,1.8945E+01,2.5259E+01,3.1562E+01,
     &3.7862E+01,4.4105E+01,5.0517E+01,6.8827E-01,6.6883E+00,1.3376E+01,
     &2.0062E+01,2.6743E+01,3.3422E+01,4.0088E+01,4.6704E+01,5.3485E+01,
     &6.7674E-01,7.0269E+00,1.4054E+01,2.1077E+01,2.8099E+01,3.5115E+01,
     &4.2117E+01,4.9067E+01,5.6197E+01/
      DATA ((KA(JS,JT, 9,15),JS=1,9),JT=1,5) /
     &3.6929E+00,5.7245E+00,1.1448E+01,1.7170E+01,2.2894E+01,2.8616E+01,
     &3.4335E+01,4.0048E+01,4.5789E+01,3.5483E+00,6.2547E+00,1.2509E+01,
     &1.8761E+01,2.5016E+01,3.1268E+01,3.7517E+01,4.3757E+01,5.0032E+01,
     &3.4652E+00,6.7430E+00,1.3484E+01,2.0224E+01,2.6965E+01,3.3705E+01,
     &4.0443E+01,4.7167E+01,5.3930E+01,3.4260E+00,7.1974E+00,1.4393E+01,
     &2.1588E+01,2.8784E+01,3.5977E+01,4.3167E+01,5.0348E+01,5.7567E+01,
     &3.4123E+00,7.6134E+00,1.5225E+01,2.2838E+01,3.0451E+01,3.8059E+01,
     &4.5665E+01,5.3256E+01,6.0901E+01/
      DATA ((KA(JS,JT,10,15),JS=1,9),JT=1,5) /
     &1.9879E+01,1.7395E+01,1.5929E+01,1.8251E+01,2.3917E+01,2.9895E+01,
     &3.5873E+01,4.1851E+01,4.7831E+01,1.9461E+01,1.7089E+01,1.6077E+01,
     &1.9823E+01,2.6409E+01,3.3015E+01,3.9616E+01,4.6210E+01,5.2815E+01,
     &1.9336E+01,1.7101E+01,1.6570E+01,2.1574E+01,2.8765E+01,3.5957E+01,
     &4.3144E+01,5.0330E+01,5.7526E+01,1.9333E+01,1.7178E+01,1.7183E+01,
     &2.3203E+01,3.0928E+01,3.8662E+01,4.6389E+01,5.4117E+01,6.1850E+01,
     &1.9454E+01,1.7376E+01,1.7879E+01,2.4671E+01,3.2892E+01,4.1116E+01,
     &4.9334E+01,5.7555E+01,6.5778E+01/
      DATA ((KA(JS,JT,11,15),JS=1,9),JT=1,5) /
     &3.7918E+01,3.3177E+01,2.9050E+01,2.5728E+01,2.6964E+01,3.2638E+01,
     &3.9160E+01,4.5686E+01,5.2215E+01,3.7982E+01,3.3235E+01,2.9190E+01,
     &2.6661E+01,2.9222E+01,3.6220E+01,4.3460E+01,5.0704E+01,5.7949E+01,
     &3.8191E+01,3.3419E+01,2.9491E+01,2.7784E+01,3.1731E+01,3.9527E+01,
     &4.7423E+01,5.5330E+01,6.3238E+01,3.8572E+01,3.3751E+01,2.9960E+01,
     &2.8966E+01,3.4093E+01,4.2514E+01,5.1014E+01,5.9516E+01,6.8017E+01,
     &3.9093E+01,3.4206E+01,3.0547E+01,3.0263E+01,3.6228E+01,4.5245E+01,
     &5.4290E+01,6.3320E+01,7.2371E+01/
      DATA ((KA(JS,JT,12,15),JS=1,9),JT=1,5) /
     &5.5475E+01,4.8541E+01,4.2038E+01,3.6129E+01,3.3332E+01,3.5714E+01,
     &4.2669E+01,4.9771E+01,5.6891E+01,5.6059E+01,4.9052E+01,4.2754E+01,
     &3.7078E+01,3.5375E+01,3.9558E+01,4.7442E+01,5.5347E+01,6.3258E+01,
     &5.6760E+01,4.9664E+01,4.3494E+01,3.8346E+01,3.7575E+01,4.3186E+01,
     &5.1821E+01,6.0453E+01,6.9095E+01,5.7648E+01,5.0443E+01,4.4349E+01,
     &3.9649E+01,3.9898E+01,4.6561E+01,5.5869E+01,6.5177E+01,7.4491E+01,
     &5.8564E+01,5.1244E+01,4.5202E+01,4.0926E+01,4.2120E+01,4.9601E+01,
     &5.9519E+01,6.9433E+01,7.9355E+01/
      DATA ((KA(JS,JT,13,15),JS=1,9),JT=1,5) /
     &6.5843E+01,5.7608E+01,4.9977E+01,4.3124E+01,3.8891E+01,3.9628E+01,
     &4.6579E+01,5.4339E+01,6.2102E+01,6.6934E+01,5.8564E+01,5.1105E+01,
     &4.4471E+01,4.1117E+01,4.3582E+01,5.1721E+01,6.0334E+01,6.8958E+01,
     &6.8030E+01,5.9532E+01,5.2179E+01,4.5978E+01,4.3480E+01,4.7374E+01,
     &5.6498E+01,6.5896E+01,7.5328E+01,6.9202E+01,6.0551E+01,5.3246E+01,
     &4.7483E+01,4.5884E+01,5.0923E+01,6.0842E+01,7.0980E+01,8.1125E+01,
     &7.0366E+01,6.1567E+01,5.4251E+01,4.8884E+01,4.8138E+01,5.4098E+01,
     &6.4681E+01,7.5454E+01,8.6236E+01/
      DATA ((KA(JS,JT, 1,16),JS=1,9),JT=1,5) /
     &4.2680E-03,4.0094E+00,7.9109E+00,1.1649E+01,1.5123E+01,1.8131E+01,
     &2.0185E+01,1.9759E+01,3.0246E+01,4.1096E-03,4.1769E+00,8.2411E+00,
     &1.2134E+01,1.5754E+01,1.8883E+01,2.1013E+01,2.0555E+01,3.1509E+01,
     &3.9552E-03,4.3246E+00,8.5324E+00,1.2562E+01,1.6307E+01,1.9544E+01,
     &2.1743E+01,2.1252E+01,3.2613E+01,3.8024E-03,4.4537E+00,8.7866E+00,
     &1.2936E+01,1.6790E+01,2.0122E+01,2.2380E+01,2.1858E+01,3.3579E+01,
     &3.6530E-03,4.5661E+00,9.0077E+00,1.3262E+01,1.7211E+01,2.0624E+01,
     &2.2936E+01,2.2383E+01,3.4420E+01/
      DATA ((KA(JS,JT, 2,16),JS=1,9),JT=1,5) /
     &7.0518E-03,4.7486E+00,9.4112E+00,1.3945E+01,1.8257E+01,2.2167E+01,
     &2.5197E+01,2.5646E+01,3.6513E+01,6.7731E-03,4.9653E+00,9.8411E+00,
     &1.4578E+01,1.9087E+01,2.3173E+01,2.6338E+01,2.6795E+01,3.8174E+01,
     &6.4989E-03,5.1561E+00,1.0219E+01,1.5138E+01,1.9822E+01,2.4059E+01,
     &2.7344E+01,2.7802E+01,3.9644E+01,6.2358E-03,5.3229E+00,1.0548E+01,
     &1.5628E+01,2.0461E+01,2.4836E+01,2.8225E+01,2.8690E+01,4.0921E+01,
     &5.9777E-03,5.4686E+00,1.0838E+01,1.6055E+01,2.1017E+01,2.5512E+01,
     &2.8989E+01,2.9460E+01,4.2034E+01/
      DATA ((KA(JS,JT, 3,16),JS=1,9),JT=1,5) /
     &1.5841E-02,5.5685E+00,1.1089E+01,1.6529E+01,2.1842E+01,2.6900E+01,
     &3.1365E+01,3.3823E+01,4.3684E+01,1.5180E-02,5.8535E+00,1.1654E+01,
     &1.7376E+01,2.2954E+01,2.8269E+01,3.2966E+01,3.5548E+01,4.5909E+01,
     &1.4542E-02,6.1037E+00,1.2154E+01,1.8119E+01,2.3939E+01,2.9482E+01,
     &3.4375E+01,3.7061E+01,4.7877E+01,1.3926E-02,6.3236E+00,1.2592E+01,
     &1.8771E+01,2.4803E+01,3.0545E+01,3.5612E+01,3.8393E+01,4.9606E+01,
     &1.3332E-02,6.5149E+00,1.2971E+01,1.9341E+01,2.5553E+01,3.1470E+01,
     &3.6691E+01,3.9549E+01,5.1106E+01/
      DATA ((KA(JS,JT, 4,16),JS=1,9),JT=1,5) /
     &3.6504E-02,6.4847E+00,1.2941E+01,1.9357E+01,2.5697E+01,3.1893E+01,
     &3.7735E+01,4.2276E+01,5.1393E+01,3.4931E-02,6.8562E+00,1.3684E+01,
     &2.0466E+01,2.7170E+01,3.3719E+01,3.9896E+01,4.4696E+01,5.4340E+01,
     &3.3404E-02,7.1832E+00,1.4337E+01,2.1441E+01,2.8465E+01,3.5334E+01,
     &4.1803E+01,4.6838E+01,5.6929E+01,3.1940E-02,7.4729E+00,1.4911E+01,
     &2.2302E+01,2.9607E+01,3.6753E+01,4.3482E+01,4.8710E+01,5.9213E+01,
     &3.0537E-02,7.7225E+00,1.5413E+01,2.3052E+01,3.0605E+01,3.7982E+01,
     &4.4943E+01,5.0367E+01,6.1209E+01/
      DATA ((KA(JS,JT, 5,16),JS=1,9),JT=1,5) /
     &7.7459E-02,7.5153E+00,1.5015E+01,2.2490E+01,2.9920E+01,3.7263E+01,
     &4.4388E+01,5.0697E+01,5.9839E+01,7.3973E-02,7.9956E+00,1.5974E+01,
     &2.3926E+01,3.1831E+01,3.9653E+01,4.7235E+01,5.3936E+01,6.3661E+01,
     &7.0652E-02,8.4194E+00,1.6824E+01,2.5198E+01,3.3521E+01,4.1754E+01,
     &4.9742E+01,5.6808E+01,6.7041E+01,6.7486E-02,8.7920E+00,1.7565E+01,
     &2.6310E+01,3.5003E+01,4.3595E+01,5.1933E+01,5.9317E+01,7.0006E+01,
     &6.4478E-02,9.1159E+00,1.8215E+01,2.7284E+01,3.6299E+01,4.5208E+01,
     &5.3851E+01,6.1525E+01,7.2598E+01/
      DATA ((KA(JS,JT, 6,16),JS=1,9),JT=1,5) /
     &1.5475E-01,8.6422E+00,1.7275E+01,2.5892E+01,3.4482E+01,4.3028E+01,
     &5.1423E+01,5.9299E+01,6.8964E+01,1.4760E-01,9.2603E+00,1.8510E+01,
     &2.7740E+01,3.6952E+01,4.6093E+01,5.5105E+01,6.3549E+01,7.3905E+01,
     &1.4090E-01,9.8052E+00,1.9599E+01,2.9376E+01,3.9123E+01,4.8807E+01,
     &5.8340E+01,6.7288E+01,7.8246E+01,1.3455E-01,1.0284E+01,2.0553E+01,
     &3.0809E+01,4.1029E+01,5.1188E+01,6.1191E+01,7.0573E+01,8.2057E+01,
     &1.2855E-01,1.0696E+01,2.1381E+01,3.2059E+01,4.2695E+01,5.3257E+01,
     &6.3651E+01,7.3440E+01,8.5390E+01/
      DATA ((KA(JS,JT, 7,16),JS=1,9),JT=1,5) /
     &3.2765E-01,9.8708E+00,1.9738E+01,2.9598E+01,3.9436E+01,4.9244E+01,
     &5.8981E+01,6.8395E+01,7.8872E+01,3.1237E-01,1.0655E+01,2.1308E+01,
     &3.1948E+01,4.2573E+01,5.3154E+01,6.3663E+01,7.3848E+01,8.5146E+01,
     &2.9817E-01,1.1348E+01,2.2690E+01,3.4027E+01,4.5330E+01,5.6613E+01,
     &6.7816E+01,7.8654E+01,9.0660E+01,2.8488E-01,1.1956E+01,2.3907E+01,
     &3.5845E+01,4.7755E+01,5.9649E+01,7.1415E+01,8.2866E+01,9.5510E+01,
     &2.7283E-01,1.2480E+01,2.4950E+01,3.7415E+01,4.9097E+01,6.2266E+01,
     &7.4578E+01,8.6491E+01,9.9702E+01/
      DATA ((KA(JS,JT, 8,16),JS=1,9),JT=1,5) /
     &8.3606E-01,1.1195E+01,2.2388E+01,3.3574E+01,4.4755E+01,5.5920E+01,
     &6.7048E+01,7.8029E+01,8.9508E+01,7.9798E-01,1.2177E+01,2.4351E+01,
     &3.6522E+01,4.8685E+01,6.0830E+01,7.2963E+01,8.4892E+01,9.7369E+01,
     &7.6304E-01,1.3047E+01,2.6090E+01,3.9130E+01,5.2156E+01,6.5163E+01,
     &7.8140E+01,9.0945E+01,1.0431E+02,7.3296E-01,1.3800E+01,2.7601E+01,
     &4.1393E+01,5.5174E+01,6.8947E+01,8.2670E+01,9.6216E+01,1.1035E+02,
     &7.2250E-01,1.4453E+01,2.8899E+01,4.3348E+01,5.7784E+01,7.2193E+01,
     &8.6582E+01,1.0076E+02,1.1557E+02/
      DATA ((KA(JS,JT, 9,16),JS=1,9),JT=1,5) /
     &4.0611E+00,1.2573E+01,2.5149E+01,3.7721E+01,5.0293E+01,6.2854E+01,
     &7.5422E+01,8.7942E+01,1.0059E+02,3.8919E+00,1.3793E+01,2.7583E+01,
     &4.1373E+01,5.5157E+01,6.8943E+01,8.2722E+01,9.6458E+01,1.1031E+02,
     &3.7505E+00,1.4863E+01,2.9722E+01,4.4587E+01,5.9447E+01,7.4303E+01,
     &8.9145E+01,1.0395E+02,1.1889E+02,3.6915E+00,1.5793E+01,3.1587E+01,
     &4.7379E+01,6.3167E+01,7.8955E+01,9.4727E+01,1.1046E+02,1.2634E+02,
     &3.8118E+00,1.6590E+01,3.3180E+01,4.9767E+01,6.6364E+01,8.2935E+01,
     &9.9506E+01,1.1603E+02,1.3273E+02/
      DATA ((KA(JS,JT,10,16),JS=1,9),JT=1,5) /
     &2.2252E+01,1.9469E+01,2.8181E+01,4.2271E+01,5.6359E+01,7.0451E+01,
     &8.4538E+01,9.8612E+01,1.1272E+02,2.1525E+01,1.8834E+01,3.1126E+01,
     &4.6690E+01,6.2252E+01,7.7813E+01,9.3373E+01,1.0893E+02,1.2450E+02,
     &2.1146E+01,1.8632E+01,3.3699E+01,5.0550E+01,6.7413E+01,8.4265E+01,
     &1.0112E+02,1.1795E+02,1.3483E+02,2.1709E+01,1.9529E+01,3.5926E+01,
     &5.3893E+01,7.1851E+01,8.9812E+01,1.0777E+02,1.2572E+02,1.4370E+02,
     &2.2565E+01,2.0486E+01,3.7826E+01,5.6738E+01,7.5652E+01,9.4560E+01,
     &1.1347E+02,1.3237E+02,1.5131E+02/
      DATA ((KA(JS,JT,11,16),JS=1,9),JT=1,5) /
     &4.2772E+01,3.7423E+01,3.4479E+01,4.9359E+01,6.5807E+01,8.2260E+01,
     &9.8714E+01,1.1516E+02,1.3161E+02,4.2480E+01,3.7168E+01,3.6886E+01,
     &5.4309E+01,7.2413E+01,9.0516E+01,1.0859E+02,1.2671E+02,1.4483E+02,
     &4.3695E+01,3.8234E+01,3.9646E+01,5.8582E+01,7.8105E+01,9.7632E+01,
     &1.1715E+02,1.3667E+02,1.5621E+02,4.5497E+01,3.9810E+01,4.2112E+01,
     &6.2236E+01,8.2974E+01,1.0371E+02,1.2447E+02,1.4520E+02,1.6595E+02,
     &4.7319E+01,4.1402E+01,4.4245E+01,6.5288E+01,8.7037E+01,1.0880E+02,
     &1.3053E+02,1.5228E+02,1.7407E+02/
      DATA ((KA(JS,JT,12,16),JS=1,9),JT=1,5) /
     &6.3760E+01,5.5793E+01,4.7823E+01,5.6928E+01,7.5904E+01,9.4850E+01,
     &1.1385E+02,1.3279E+02,1.5181E+02,6.5427E+01,5.7247E+01,4.9649E+01,
     &6.2349E+01,8.3126E+01,1.0392E+02,1.2469E+02,1.4546E+02,1.6625E+02,
     &6.8202E+01,5.9674E+01,5.2535E+01,6.6975E+01,8.9301E+01,1.1163E+02,
     &1.3393E+02,1.5627E+02,1.7860E+02,7.0922E+01,6.2055E+01,5.5321E+01,
     &7.0905E+01,9.4539E+01,1.1818E+02,1.4181E+02,1.6544E+02,1.8908E+02,
     &7.3649E+01,6.4442E+01,5.7813E+01,7.4307E+01,9.9092E+01,1.2384E+02,
     &1.4863E+02,1.7339E+02,1.9818E+02/
      DATA ((KA(JS,JT,13,16),JS=1,9),JT=1,5) /
     &7.8782E+01,6.8941E+01,5.9088E+01,6.5861E+01,8.6369E+01,1.0796E+02,
     &1.2954E+02,1.5113E+02,1.7274E+02,8.1731E+01,7.1509E+01,6.1634E+01,
     &7.1635E+01,9.4482E+01,1.1810E+02,1.4170E+02,1.6534E+02,1.8896E+02,
     &8.5240E+01,7.4588E+01,6.4915E+01,7.6648E+01,1.0154E+02,1.2693E+02,
     &1.5232E+02,1.7766E+02,2.0308E+02,8.8622E+01,7.7543E+01,6.7967E+01,
     &8.0867E+01,1.0759E+02,1.3449E+02,1.6139E+02,1.8828E+02,2.1519E+02,
     &9.1737E+01,8.0288E+01,7.0891E+01,8.4742E+01,1.1298E+02,1.4117E+02,
     &1.6939E+02,1.9762E+02,2.2595E+02/

C     The array FORREF contains the coefficient of the water vapor
C     foreign-continuum (including the energy term).  The first 
C     index refers to reference temperature (296,260,224,260) and 
C     pressure (970,475,219,3 mbar) levels.  The second index 
C     runs over the g-channel (1 to 16).

      DATA (FORREF(1,IG),IG=1,16) /
     &1.4739e-04,3.1686e-04,8.5973e-04,1.9039e-03,3.1820e-03,3.6596e-03,
     &3.8724e-03,3.6785e-03,3.7141e-03,3.7646e-03,4.2955e-03,4.6343e-03,
     &5.0612e-03,4.0227e-03,4.2966e-03,4.6622e-03/
      DATA (FORREF(2,IG),IG=1,16) /
     &1.9397e-04,3.6322e-04,8.9797e-04,2.1001e-03,3.0307e-03,3.5563e-03,
     &3.8498e-03,3.5741e-03,3.5914e-03,3.7658e-03,3.8895e-03,4.4072e-03,
     &4.7112e-03,4.2230e-03,4.2666e-03,4.6634e-03/
      DATA (FORREF(3,IG),IG=1,16) /
     &3.1506e-04,7.3687e-04,1.9678e-03,2.5531e-03,2.8345e-03,2.7809e-03,
     &2.9124e-03,2.7125e-03,2.6644e-03,2.4907e-03,2.7032e-03,4.0967e-03,
     &4.1971e-03,4.4507e-03,4.2293e-03,4.6633e-03/
      DATA (FORREF(4,IG),IG=1,16) /
     &8.8196e-04,2.1125e-03,2.8042e-03,2.8891e-03,2.4362e-03,1.8733e-03,
     &1.4078e-03,1.1987e-03,1.2808e-03,8.9050e-04,9.4375e-04,7.8351e-04,
     &1.0756e-03,1.6586e-03,1.7511e-03,4.7803e-03/

C     The array SELFREF contains the coefficient of the water vapor
C     self-continuum (including the energy term).  The first index
C     refers to temperature in 7.2 degree increments.  For instance,
C     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
C     etc.  The second index runs over the g-channel (1 to 16).

      DATA (SELFREF(JT, 1),JT=1,10)  /
     & 2.37879e-02, 2.10719e-02, 1.86660e-02, 1.65348e-02, 1.46469e-02,
     & 1.29746e-02, 1.14932e-02, 1.01810e-02, 9.01858e-03, 7.98888e-03/
      DATA (SELFREF(JT, 2),JT=1,10)  /
     & 3.10625e-02, 2.82664e-02, 2.57220e-02, 2.34066e-02, 2.12997e-02,
     & 1.93824e-02, 1.76377e-02, 1.60500e-02, 1.46053e-02, 1.32906e-02/
      DATA (SELFREF(JT, 3),JT=1,10)  /
     & 5.19103e-02, 4.80004e-02, 4.43850e-02, 4.10419e-02, 3.79506e-02,
     & 3.50922e-02, 3.24491e-02, 3.00050e-02, 2.77450e-02, 2.56553e-02/
      DATA (SELFREF(JT, 4),JT=1,10)  /
     & 9.12444e-02, 8.38675e-02, 7.70870e-02, 7.08547e-02, 6.51263e-02,
     & 5.98610e-02, 5.50214e-02, 5.05730e-02, 4.64843e-02, 4.27262e-02/
      DATA (SELFREF(JT, 5),JT=1,10)  /
     & 1.11323e-01, 1.04217e-01, 9.75650e-02, 9.13376e-02, 8.55076e-02,
     & 8.00498e-02, 7.49403e-02, 7.01570e-02, 6.56790e-02, 6.14868e-02/
      DATA (SELFREF(JT, 6),JT=1,10)  /
     & 1.25301e-01, 1.16877e-01, 1.09020e-01, 1.01691e-01, 9.48543e-02,
     & 8.84774e-02, 8.25293e-02, 7.69810e-02, 7.18057e-02, 6.69784e-02/
      DATA (SELFREF(JT, 7),JT=1,10)  /
     & 1.34063e-01, 1.24662e-01, 1.15920e-01, 1.07791e-01, 1.00232e-01,
     & 9.32035e-02, 8.66676e-02, 8.05900e-02, 7.49386e-02, 6.96836e-02/
      DATA (SELFREF(JT, 8),JT=1,10)  /
     & 1.26997e-01, 1.18306e-01, 1.10210e-01, 1.02668e-01, 9.56417e-02,
     & 8.90964e-02, 8.29991e-02, 7.73190e-02, 7.20276e-02, 6.70984e-02/
      DATA (SELFREF(JT, 9),JT=1,10)  /
     & 1.28823e-01, 1.20235e-01, 1.12220e-01, 1.04739e-01, 9.77569e-02,
     & 9.12402e-02, 8.51579e-02, 7.94810e-02, 7.41826e-02, 6.92374e-02/
      DATA (SELFREF(JT,10),JT=1,10)  /
     & 1.35802e-01, 1.25981e-01, 1.16870e-01, 1.08418e-01, 1.00577e-01,
     & 9.33034e-02, 8.65557e-02, 8.02960e-02, 7.44890e-02, 6.91020e-02/
      DATA (SELFREF(JT,11),JT=1,10)  /
     & 1.35475e-01, 1.27572e-01, 1.20130e-01, 1.13122e-01, 1.06523e-01,
     & 1.00309e-01, 9.44573e-02, 8.89470e-02, 8.37582e-02, 7.88721e-02/
      DATA (SELFREF(JT,12),JT=1,10)  /
     & 1.51195e-01, 1.41159e-01, 1.31790e-01, 1.23043e-01, 1.14876e-01,
     & 1.07251e-01, 1.00132e-01, 9.34860e-02, 8.72809e-02, 8.14877e-02/
      DATA (SELFREF(JT,13),JT=1,10)  /
     & 1.57538e-01, 1.47974e-01, 1.38990e-01, 1.30552e-01, 1.22626e-01,
     & 1.15181e-01, 1.08188e-01, 1.01620e-01, 9.54505e-02, 8.96556e-02/
      DATA (SELFREF(JT,14),JT=1,10)  /
     & 1.53567e-01, 1.41564e-01, 1.30500e-01, 1.20300e-01, 1.10898e-01,
     & 1.02231e-01, 9.42406e-02, 8.68750e-02, 8.00851e-02, 7.38259e-02/
      DATA (SELFREF(JT,15),JT=1,10)  /
     & 1.53687e-01, 1.42981e-01, 1.33020e-01, 1.23753e-01, 1.15132e-01,
     & 1.07112e-01, 9.96500e-02, 9.27080e-02, 8.62496e-02, 8.02412e-02/
      DATA (SELFREF(JT,16),JT=1,10)  /
     & 1.65129e-01, 1.53285e-01, 1.42290e-01, 1.32084e-01, 1.22610e-01,
     & 1.13815e-01, 1.05651e-01, 9.80730e-02, 9.10384e-02, 8.45083e-02/
