C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB13.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.0 $
C     created:   $Date: 2002/06/03 20:42:03 $
       PARAMETER (MG=16)
       DIMENSION SELFREF(10,MG), FORREF(4,MG)
       REAL KA(9,5,13,MG)
       REAL KA_MCO2(9,19,MG),KA_MCO(9,19,MG),KB_MO3(19,MG)

       COMMON /HVRSN13/ HVRKG13

       COMMON /K13/ KA, FORREF, SELFREF, KA_MCO2, KA_MCO, KB_MO3

       CHARACTER*15 HVRKG13
       DATA HVRKG13 /'$Revision: 3.0 $'/

C     The array KA contains absorption coefs for each of the 16 g-intervals
C     for a range of pressure levels > ~100mb, temperatures, and ratios
C     of water vapor to CO2.  The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.
C     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
C     to different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this  pressure 
C     level, JT = 2 refers to the temperature
C     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
C     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
C     to the reference pressure level (e.g. JP = 1 is for a
C     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.
      DATA ((KA(JS,JT, 1, 1),JS=1,9),JT=1,5) /
     &6.4065E-07,1.0419E-05,1.7041E-05,2.3341E-05,2.9288E-05,3.6860E-05,
     &5.2289E-05,7.6369E-05,2.2034E-05,7.4425E-07,1.2994E-05,2.1634E-05,
     &2.9437E-05,3.6128E-05,4.4577E-05,5.5507E-05,7.3010E-05,3.0368E-05,
     &9.1477E-07,1.6195E-05,2.7037E-05,3.6851E-05,4.4956E-05,5.3696E-05,
     &6.5423E-05,7.7959E-05,3.9940E-05,1.0920E-06,2.0021E-05,3.3475E-05,
     &4.5528E-05,5.5351E-05,6.4790E-05,7.8460E-05,9.0393E-05,5.1295E-05,
     &1.3489E-06,2.4363E-05,4.1025E-05,5.5638E-05,6.7646E-05,7.8828E-05,
     &9.2175E-05,1.0262E-04,6.4740E-05/
      DATA ((KA(JS,JT, 2, 1),JS=1,9),JT=1,5) /
     &9.4474E-07,9.5739E-06,1.4537E-05,1.9319E-05,2.3955E-05,2.8125E-05,
     &3.4867E-05,5.4010E-05,1.9403E-05,1.1323E-06,1.1739E-05,1.8325E-05,
     &2.4542E-05,3.0201E-05,3.5031E-05,4.2528E-05,5.9167E-05,2.5395E-05,
     &1.3451E-06,1.4450E-05,2.3075E-05,3.0847E-05,3.7507E-05,4.3224E-05,
     &5.0526E-05,6.6079E-05,3.2769E-05,1.6171E-06,1.7819E-05,2.8678E-05,
     &3.8333E-05,4.6715E-05,5.3613E-05,6.0668E-05,7.1518E-05,4.1642E-05,
     &1.9441E-06,2.1692E-05,3.5243E-05,4.7173E-05,5.7398E-05,6.5939E-05,
     &7.3567E-05,8.2891E-05,5.2140E-05/
      DATA ((KA(JS,JT, 3, 1),JS=1,9),JT=1,5) /
     &1.9997E-06,1.0333E-05,1.4351E-05,1.7071E-05,1.9818E-05,2.2671E-05,
     &2.5587E-05,3.3080E-05,2.1440E-05,2.2813E-06,1.2534E-05,1.7541E-05,
     &2.1448E-05,2.5145E-05,2.8879E-05,3.1889E-05,3.7831E-05,2.6738E-05,
     &2.7401E-06,1.5206E-05,2.1444E-05,2.7039E-05,3.1929E-05,3.6455E-05,
     &3.9620E-05,4.6057E-05,3.1366E-05,3.2871E-06,1.8031E-05,2.6416E-05,
     &3.3815E-05,3.9999E-05,4.5410E-05,4.9342E-05,5.4203E-05,3.7064E-05,
     &3.8869E-06,2.1455E-05,3.2368E-05,4.1756E-05,4.9581E-05,5.6093E-05,
     &6.1027E-05,6.5117E-05,4.4920E-05/
      DATA ((KA(JS,JT, 4, 1),JS=1,9),JT=1,5) /
     &4.3610E-06,1.3316E-05,1.6242E-05,1.8257E-05,1.9350E-05,2.0037E-05,
     &2.0833E-05,2.3040E-05,2.2366E-05,5.0348E-06,1.5693E-05,1.9649E-05,
     &2.2560E-05,2.3970E-05,2.5222E-05,2.6081E-05,2.7399E-05,2.7623E-05,
     &5.7893E-06,1.8717E-05,2.3542E-05,2.7248E-05,2.9677E-05,3.1779E-05,
     &3.2973E-05,3.3876E-05,3.4347E-05,6.7700E-06,2.2355E-05,2.8015E-05,
     &3.2751E-05,3.6706E-05,3.9566E-05,4.1488E-05,4.1986E-05,4.0984E-05,
     &8.0207E-06,2.6505E-05,3.3421E-05,3.9357E-05,4.5121E-05,4.9003E-05,
     &5.1776E-05,5.2148E-05,4.7085E-05/
      DATA ((KA(JS,JT, 5, 1),JS=1,9),JT=1,5) /
     &8.6602E-06,1.8553E-05,2.0839E-05,2.1788E-05,2.1544E-05,2.1077E-05,
     &1.9473E-05,1.8495E-05,2.3671E-05,9.9810E-06,2.2031E-05,2.4930E-05,
     &2.6247E-05,2.6462E-05,2.6137E-05,2.4415E-05,2.2553E-05,2.8177E-05,
     &1.1619E-05,2.6356E-05,2.9247E-05,3.1562E-05,3.1911E-05,3.1801E-05,
     &3.0166E-05,2.7978E-05,3.2481E-05,1.3216E-05,3.1104E-05,3.4868E-05,
     &3.7332E-05,3.8497E-05,3.8279E-05,3.7615E-05,3.4834E-05,3.8514E-05,
     &1.5414E-05,3.5706E-05,4.1155E-05,4.4051E-05,4.6023E-05,4.6762E-05,
     &4.6430E-05,4.3490E-05,4.6117E-05/
      DATA ((KA(JS,JT, 6, 1),JS=1,9),JT=1,5) /
     &1.6458E-05,2.5684E-05,2.8012E-05,2.7844E-05,2.6244E-05,2.4237E-05,
     &2.0656E-05,1.6798E-05,2.3796E-05,1.8595E-05,3.0385E-05,3.3443E-05,
     &3.3768E-05,3.2056E-05,2.9483E-05,2.5851E-05,2.0866E-05,2.8662E-05,
     &2.1348E-05,3.6540E-05,3.9601E-05,3.9640E-05,3.8210E-05,3.5898E-05,
     &3.1968E-05,2.5765E-05,3.3968E-05,2.4741E-05,4.2510E-05,4.6979E-05,
     &4.6425E-05,4.6165E-05,4.2824E-05,3.8814E-05,3.1863E-05,3.8072E-05,
     &2.8527E-05,5.0183E-05,5.5064E-05,5.5234E-05,5.4182E-05,5.0966E-05,
     &4.6758E-05,3.9447E-05,4.4935E-05/
      DATA ((KA(JS,JT, 7, 1),JS=1,9),JT=1,5) /
     &3.2476E-05,3.8679E-05,3.9032E-05,3.7741E-05,3.4552E-05,2.9807E-05,
     &2.4164E-05,1.7294E-05,2.4102E-05,3.6570E-05,4.6320E-05,4.7537E-05,
     &4.6067E-05,4.2268E-05,3.6503E-05,3.0476E-05,2.2134E-05,2.9448E-05,
     &4.1124E-05,5.4270E-05,5.7210E-05,5.5312E-05,5.2106E-05,4.5231E-05,
     &3.7737E-05,2.7811E-05,3.4668E-05,4.8133E-05,6.4794E-05,6.7628E-05,
     &6.6254E-05,6.2299E-05,5.4379E-05,4.5931E-05,3.4327E-05,4.1743E-05,
     &5.5532E-05,7.7694E-05,8.0423E-05,7.9418E-05,7.2354E-05,6.4221E-05,
     &5.4806E-05,4.1684E-05,4.8759E-05/
      DATA ((KA(JS,JT, 8, 1),JS=1,9),JT=1,5) /
     &7.4902E-05,7.7106E-05,7.0826E-05,6.4010E-05,5.5968E-05,4.6986E-05,
     &3.6409E-05,2.2524E-05,2.8079E-05,8.5067E-05,8.8842E-05,8.3769E-05,
     &7.6787E-05,6.8134E-05,5.7821E-05,4.4557E-05,2.8824E-05,3.6133E-05,
     &9.7879E-05,1.0460E-04,9.9884E-05,9.2458E-05,8.3229E-05,7.0097E-05,
     &5.5355E-05,3.6496E-05,4.1979E-05,1.1321E-04,1.2375E-04,1.2003E-04,
     &1.1241E-04,1.0088E-04,8.6080E-05,6.8531E-05,4.5034E-05,5.0526E-05,
     &1.3142E-04,1.5020E-04,1.4626E-04,1.3653E-04,1.2235E-04,1.0518E-04,
     &8.2469E-05,5.5412E-05,6.0484E-05/
      DATA ((KA(JS,JT, 9, 1),JS=1,9),JT=1,5) /
     &3.0190E-04,2.8195E-04,2.5208E-04,2.1662E-04,1.7929E-04,1.4025E-04,
     &1.0049E-04,5.8291E-05,3.9381E-05,3.5007E-04,3.2966E-04,2.9418E-04,
     &2.5482E-04,2.1206E-04,1.6775E-04,1.2208E-04,7.2618E-05,5.1006E-05,
     &4.1355E-04,3.9069E-04,3.5043E-04,3.0530E-04,2.5611E-04,2.0488E-04,
     &1.4964E-04,8.8870E-05,6.5960E-05,4.9093E-04,4.6398E-04,4.1726E-04,
     &3.6373E-04,3.0710E-04,2.4775E-04,1.8258E-04,1.0881E-04,8.2307E-05,
     &5.8022E-04,5.5027E-04,5.0137E-04,4.3986E-04,3.7225E-04,2.9865E-04,
     &2.2079E-04,1.3406E-04,9.5285E-05/
      DATA ((KA(JS,JT,10, 1),JS=1,9),JT=1,5) /
     &1.2883E-03,1.1451E-03,9.9720E-04,8.4603E-04,6.8855E-04,5.2856E-04,
     &3.6226E-04,1.9198E-04,7.4637E-05,1.5104E-03,1.3471E-03,1.1771E-03,
     &9.9916E-04,8.1528E-04,6.2425E-04,4.3021E-04,2.3018E-04,8.8724E-05,
     &1.8167E-03,1.6260E-03,1.4233E-03,1.2086E-03,9.8644E-04,7.6173E-04,
     &5.2737E-04,2.8610E-04,1.0717E-04,2.2177E-03,1.9922E-03,1.7424E-03,
     &1.4817E-03,1.2127E-03,9.3691E-04,6.5292E-04,3.5708E-04,1.2411E-04,
     &2.7210E-03,2.4399E-03,2.1395E-03,1.8137E-03,1.4859E-03,1.1551E-03,
     &8.0975E-04,4.4504E-04,1.4851E-04/
      DATA ((KA(JS,JT,11, 1),JS=1,9),JT=1,5) /
     &1.9516E-03,1.7255E-03,1.4956E-03,1.2644E-03,1.0251E-03,7.8257E-04,
     &5.3359E-04,2.7877E-04,7.8095E-05,2.3604E-03,2.0924E-03,1.8171E-03,
     &1.5363E-03,1.2459E-03,9.5100E-04,6.5089E-04,3.4345E-04,9.5842E-05,
     &2.8804E-03,2.5577E-03,2.2239E-03,1.8797E-03,1.5233E-03,1.1642E-03,
     &8.0020E-04,4.2543E-04,1.1860E-04,3.5705E-03,3.1731E-03,2.7557E-03,
     &2.3268E-03,1.8893E-03,1.4468E-03,9.9612E-04,5.3416E-04,1.4487E-04,
     &4.4488E-03,3.9532E-03,3.4428E-03,2.9093E-03,2.3658E-03,1.8156E-03,
     &1.2567E-03,6.7979E-04,1.7247E-04/
      DATA ((KA(JS,JT,12, 1),JS=1,9),JT=1,5) /
     &2.1650E-03,1.9116E-03,1.6550E-03,1.3963E-03,1.1297E-03,8.5899E-04,
     &5.8509E-04,3.0490E-04,7.1706E-05,2.6267E-03,2.3248E-03,2.0167E-03,
     &1.7021E-03,1.3758E-03,1.0485E-03,7.1504E-04,3.7456E-04,8.9235E-05,
     &3.2534E-03,2.8836E-03,2.5027E-03,2.1051E-03,1.7048E-03,1.2988E-03,
     &8.8817E-04,4.6846E-04,1.1111E-04,4.0663E-03,3.6075E-03,3.1250E-03,
     &2.6309E-03,2.1307E-03,1.6269E-03,1.1159E-03,5.9423E-04,1.3807E-04,
     &5.1489E-03,4.5663E-03,3.9639E-03,3.3363E-03,2.7011E-03,2.0639E-03,
     &1.4193E-03,7.5878E-04,1.6511E-04/
      DATA ((KA(JS,JT,13, 1),JS=1,9),JT=1,5) /
     &1.8892E-03,1.6706E-03,1.4468E-03,1.2178E-03,9.8369E-04,7.4837E-04,
     &5.0829E-04,2.6445E-04,6.0347E-05,2.3493E-03,2.0800E-03,1.8039E-03,
     &1.5176E-03,1.2269E-03,9.3478E-04,6.3614E-04,3.3311E-04,7.4952E-05,
     &2.9367E-03,2.6050E-03,2.2571E-03,1.8958E-03,1.5337E-03,1.1694E-03,
     &7.9916E-04,4.2184E-04,9.2442E-05,3.6657E-03,3.2513E-03,2.8158E-03,
     &2.3704E-03,1.9186E-03,1.4653E-03,1.0024E-03,5.3341E-04,1.1484E-04,
     &4.6760E-03,4.1516E-03,3.5983E-03,3.0289E-03,2.4503E-03,1.8734E-03,
     &1.2888E-03,6.8680E-04,1.3777E-04/
      DATA ((KA(JS,JT, 1, 2),JS=1,9),JT=1,5) /
     &1.8748E-06,2.5986E-05,3.9140E-05,5.0515E-05,6.0453E-05,7.0222E-05,
     &9.2153E-05,1.1527E-04,4.9863E-05,2.2195E-06,3.2877E-05,5.0201E-05,
     &6.4757E-05,7.7459E-05,8.9731E-05,1.0523E-04,1.3275E-04,6.4946E-05,
     &2.6699E-06,4.0948E-05,6.3539E-05,8.1241E-05,9.7151E-05,1.1092E-04,
     &1.1761E-04,1.3825E-04,8.4658E-05,3.1333E-06,5.0568E-05,7.8106E-05,
     &9.9691E-05,1.1981E-04,1.3549E-04,1.3924E-04,1.5344E-04,1.0884E-04,
     &3.7302E-06,6.1696E-05,9.4521E-05,1.2091E-04,1.4534E-04,1.6166E-04,
     &1.6745E-04,1.7689E-04,1.3808E-04/
      DATA ((KA(JS,JT, 2, 2),JS=1,9),JT=1,5) /
     &2.7303E-06,2.4541E-05,3.5763E-05,4.4104E-05,5.1595E-05,5.8966E-05,
     &6.8130E-05,1.0200E-04,3.9223E-05,3.2091E-06,3.1379E-05,4.5745E-05,
     &5.7229E-05,6.6576E-05,7.4659E-05,8.1615E-05,9.9977E-05,5.3367E-05,
     &3.8233E-06,3.9294E-05,5.7741E-05,7.2569E-05,8.4616E-05,9.4873E-05,
     &1.0240E-04,1.1173E-04,6.9904E-05,4.4247E-06,4.8330E-05,7.1550E-05,
     &9.0142E-05,1.0471E-04,1.1736E-04,1.2542E-04,1.2602E-04,8.9761E-05,
     &5.2245E-06,5.9597E-05,8.7482E-05,1.0983E-04,1.2772E-04,1.4263E-04,
     &1.4957E-04,1.4619E-04,1.1276E-04/
      DATA ((KA(JS,JT, 3, 2),JS=1,9),JT=1,5) /
     &5.2515E-06,2.5764E-05,3.5421E-05,4.2053E-05,4.7449E-05,5.0608E-05,
     &5.3790E-05,6.3623E-05,3.2707E-05,6.1812E-06,3.3267E-05,4.5617E-05,
     &5.4363E-05,6.1462E-05,6.5644E-05,6.8603E-05,7.2538E-05,4.2974E-05,
     &7.0789E-06,4.1750E-05,5.7967E-05,6.9149E-05,7.8026E-05,8.4324E-05,
     &8.7723E-05,8.7036E-05,5.7402E-05,8.1019E-06,5.2243E-05,7.2254E-05,
     &8.6560E-05,9.8380E-05,1.0586E-04,1.1006E-04,1.0834E-04,7.4594E-05,
     &9.5928E-06,6.4752E-05,8.9095E-05,1.0726E-04,1.2114E-04,1.3016E-04,
     &1.3551E-04,1.3048E-04,9.3901E-05/
      DATA ((KA(JS,JT, 4, 2),JS=1,9),JT=1,5) /
     &1.1020E-05,2.8494E-05,3.6932E-05,4.2975E-05,4.6074E-05,4.6953E-05,
     &4.6313E-05,4.4542E-05,3.2970E-05,1.2562E-05,3.7065E-05,4.7812E-05,
     &5.4915E-05,5.9599E-05,6.1605E-05,6.1355E-05,5.8223E-05,3.9379E-05,
     &1.4576E-05,4.7351E-05,6.1614E-05,7.0211E-05,7.6184E-05,7.9246E-05,
     &7.8840E-05,7.4646E-05,4.5622E-05,1.6280E-05,5.8550E-05,7.7244E-05,
     &8.9750E-05,9.5812E-05,1.0028E-04,1.0042E-04,9.4563E-05,5.6157E-05,
     &1.8452E-05,7.1720E-05,9.6110E-05,1.1183E-04,1.1944E-04,1.2546E-04,
     &1.2521E-04,1.1758E-04,7.2313E-05/
      DATA ((KA(JS,JT, 5, 2),JS=1,9),JT=1,5) /
     &2.1312E-05,3.6806E-05,4.2862E-05,4.6599E-05,4.7270E-05,4.6274E-05,
     &4.2916E-05,3.6817E-05,3.2593E-05,2.5202E-05,4.5358E-05,5.3413E-05,
     &5.8866E-05,6.0628E-05,5.9617E-05,5.6530E-05,4.9579E-05,3.9610E-05,
     &2.8699E-05,5.5778E-05,6.8120E-05,7.4417E-05,7.7573E-05,7.6799E-05,
     &7.3323E-05,6.4915E-05,4.8072E-05,3.2753E-05,6.7844E-05,8.5625E-05,
     &9.3879E-05,9.7934E-05,9.8316E-05,9.3375E-05,8.3569E-05,5.7445E-05,
     &3.6908E-05,8.3612E-05,1.0490E-04,1.1632E-04,1.2275E-04,1.2328E-04,
     &1.1667E-04,1.0539E-04,6.6570E-05/
      DATA ((KA(JS,JT, 6, 2),JS=1,9),JT=1,5) /
     &4.3241E-05,5.7363E-05,5.9383E-05,5.9083E-05,5.6687E-05,5.1929E-05,
     &4.4854E-05,3.4134E-05,3.3554E-05,4.8160E-05,6.6362E-05,7.1460E-05,
     &7.1908E-05,6.9540E-05,6.3380E-05,5.6957E-05,4.4490E-05,3.9435E-05,
     &5.5150E-05,7.8279E-05,8.5897E-05,8.6929E-05,8.6216E-05,7.9912E-05,
     &7.1634E-05,5.7727E-05,4.6871E-05,6.2702E-05,9.3878E-05,1.0189E-04,
     &1.0755E-04,1.0575E-04,1.0053E-04,8.9365E-05,7.5152E-05,5.7874E-05,
     &7.1646E-05,1.0994E-04,1.2283E-04,1.3142E-04,1.3048E-04,1.2339E-04,
     &1.1339E-04,9.4667E-05,6.9560E-05/
      DATA ((KA(JS,JT, 7, 2),JS=1,9),JT=1,5) /
     &9.4217E-05,1.0625E-04,1.0297E-04,9.4341E-05,8.4820E-05,7.4540E-05,
     &5.9573E-05,4.0162E-05,3.4032E-05,1.0328E-04,1.1698E-04,1.1273E-04,
     &1.0730E-04,9.8854E-05,8.8068E-05,7.1680E-05,5.0363E-05,4.1780E-05,
     &1.1436E-04,1.3466E-04,1.3293E-04,1.2807E-04,1.1742E-04,1.0440E-04,
     &8.7142E-05,6.2911E-05,5.1346E-05,1.2805E-04,1.5498E-04,1.5579E-04,
     &1.5032E-04,1.3953E-04,1.2638E-04,1.0638E-04,7.6925E-05,6.1784E-05,
     &1.4510E-04,1.7937E-04,1.8186E-04,1.7514E-04,1.6579E-04,1.5232E-04,
     &1.2822E-04,9.5671E-05,7.0048E-05/
      DATA ((KA(JS,JT, 8, 2),JS=1,9),JT=1,5) /
     &2.4926E-04,2.4392E-04,2.2297E-04,1.9521E-04,1.6651E-04,1.3349E-04,
     &9.8669E-05,6.3201E-05,3.1807E-05,2.7454E-04,2.7755E-04,2.5558E-04,
     &2.2780E-04,1.9618E-04,1.5908E-04,1.2121E-04,7.6667E-05,4.0012E-05,
     &2.9508E-04,3.0091E-04,2.7929E-04,2.5223E-04,2.1930E-04,1.8562E-04,
     &1.4312E-04,9.2529E-05,5.6355E-05,3.2350E-04,3.3697E-04,3.1656E-04,
     &2.8676E-04,2.5417E-04,2.1233E-04,1.6702E-04,1.1113E-04,6.5692E-05,
     &3.5413E-04,3.7149E-04,3.5724E-04,3.2794E-04,2.8883E-04,2.4521E-04,
     &1.9502E-04,1.3265E-04,7.4636E-05/
      DATA ((KA(JS,JT, 9, 2),JS=1,9),JT=1,5) /
     &1.1370E-03,1.0245E-03,9.0233E-04,7.7373E-04,6.3596E-04,4.9782E-04,
     &3.4706E-04,1.8813E-04,5.4967E-05,1.2549E-03,1.1327E-03,1.0081E-03,
     &8.6174E-04,7.1233E-04,5.5663E-04,3.9054E-04,2.1740E-04,6.5863E-05,
     &1.4193E-03,1.2929E-03,1.1501E-03,9.8954E-04,8.1834E-04,6.4034E-04,
     &4.5590E-04,2.5841E-04,7.6782E-05,1.5730E-03,1.4525E-03,1.2939E-03,
     &1.1191E-03,9.2869E-04,7.2912E-04,5.2003E-04,2.9928E-04,9.3109E-05,
     &1.7020E-03,1.5888E-03,1.4187E-03,1.2315E-03,1.0334E-03,8.2293E-04,
     &5.9761E-04,3.4411E-04,1.1836E-04/
      DATA ((KA(JS,JT,10, 2),JS=1,9),JT=1,5) /
     &6.1528E-03,5.4056E-03,4.6635E-03,3.9185E-03,3.1663E-03,2.4050E-03,
     &1.6372E-03,8.5009E-04,8.0054E-05,6.8550E-03,6.0391E-03,5.2246E-03,
     &4.3821E-03,3.5514E-03,2.7172E-03,1.8529E-03,9.7224E-04,1.0130E-04,
     &7.6163E-03,6.7254E-03,5.8028E-03,4.8844E-03,3.9710E-03,3.0268E-03,
     &2.0640E-03,1.0804E-03,1.3327E-04,8.4017E-03,7.4385E-03,6.4324E-03,
     &5.4278E-03,4.4132E-03,3.3677E-03,2.3075E-03,1.2226E-03,1.6598E-04,
     &9.3911E-03,8.3333E-03,7.2272E-03,6.1232E-03,4.9837E-03,3.8167E-03,
     &2.6213E-03,1.4063E-03,2.0638E-04/
      DATA ((KA(JS,JT,11, 2),JS=1,9),JT=1,5) /
     &1.1762E-02,1.0306E-02,8.8593E-03,7.4127E-03,5.9627E-03,4.5045E-03,
     &3.0511E-03,1.5666E-03,8.2025E-05,1.3012E-02,1.1426E-02,9.8347E-03,
     &8.2336E-03,6.6323E-03,5.0275E-03,3.4043E-03,1.7550E-03,1.0611E-04,
     &1.4612E-02,1.2845E-02,1.1070E-02,9.2725E-03,7.4822E-03,5.6847E-03,
     &3.8534E-03,1.9989E-03,1.3346E-04,1.6251E-02,1.4313E-02,1.2347E-02,
     &1.0360E-02,8.3777E-03,6.3716E-03,4.3250E-03,2.2445E-03,1.6083E-04,
     &1.8150E-02,1.6016E-02,1.3813E-02,1.1608E-02,9.3833E-03,7.1360E-03,
     &4.8421E-03,2.5233E-03,2.0030E-04/
      DATA ((KA(JS,JT,12, 2),JS=1,9),JT=1,5) /
     &1.5059E-02,1.3197E-02,1.1332E-02,9.4687E-03,7.6107E-03,5.7434E-03,
     &3.8799E-03,1.9799E-03,8.0330E-05,1.6512E-02,1.4476E-02,1.2442E-02,
     &1.0410E-02,8.3743E-03,6.3355E-03,4.2771E-03,2.1952E-03,9.9323E-05,
     &1.8685E-02,1.6400E-02,1.4116E-02,1.1818E-02,9.5219E-03,7.2188E-03,
     &4.8730E-03,2.5083E-03,1.2343E-04,2.1153E-02,1.8588E-02,1.6002E-02,
     &1.3413E-02,1.0821E-02,8.2029E-03,5.5391E-03,2.8500E-03,1.4931E-04,
     &2.3737E-02,2.0901E-02,1.7991E-02,1.5090E-02,1.2172E-02,9.2290E-03,
     &6.2485E-03,3.2234E-03,1.9022E-04/
      DATA ((KA(JS,JT,13, 2),JS=1,9),JT=1,5) /
     &1.4847E-02,1.3010E-02,1.1175E-02,9.3417E-03,7.5039E-03,5.6608E-03,
     &3.8195E-03,1.9483E-03,7.0259E-05,1.6739E-02,1.4679E-02,1.2619E-02,
     &1.0555E-02,8.4903E-03,6.4217E-03,4.3269E-03,2.2129E-03,8.5490E-05,
     &1.8825E-02,1.6518E-02,1.4211E-02,1.1898E-02,9.5859E-03,7.2507E-03,
     &4.8896E-03,2.5047E-03,1.1226E-04,2.1292E-02,1.8712E-02,1.6107E-02,
     &1.3496E-02,1.0877E-02,8.2331E-03,5.5639E-03,2.8510E-03,1.4031E-04,
     &2.4158E-02,2.1241E-02,1.8299E-02,1.5344E-02,1.2375E-02,9.3646E-03,
     &6.3197E-03,3.2533E-03,1.7265E-04/
      DATA ((KA(JS,JT, 1, 3),JS=1,9),JT=1,5) /
     &1.0410E-05,6.1962E-05,8.9498E-05,1.0661E-04,1.2164E-04,1.3377E-04,
     &1.2941E-04,1.4521E-04,8.1226E-05,1.1876E-05,7.8368E-05,1.1198E-04,
     &1.3409E-04,1.5187E-04,1.6090E-04,1.6481E-04,1.6441E-04,1.1141E-04,
     &1.3686E-05,9.7536E-05,1.3724E-04,1.6641E-04,1.8557E-04,1.9386E-04,
     &1.9539E-04,1.8991E-04,1.4967E-04,1.5807E-05,1.1754E-04,1.6722E-04,
     &2.0238E-04,2.2277E-04,2.3084E-04,2.3103E-04,2.1679E-04,1.9490E-04,
     &1.8430E-05,1.4041E-04,2.0063E-04,2.4077E-04,2.6088E-04,2.7081E-04,
     &2.7088E-04,2.6451E-04,2.4633E-04/
      DATA ((KA(JS,JT, 2, 3),JS=1,9),JT=1,5) /
     &1.4574E-05,6.1181E-05,8.5219E-05,1.0233E-04,1.1097E-04,1.1864E-04,
     &1.2443E-04,1.2339E-04,6.7714E-05,1.6727E-05,7.7358E-05,1.0881E-04,
     &1.2844E-04,1.4104E-04,1.5016E-04,1.5142E-04,1.4164E-04,9.0996E-05,
     &1.9092E-05,9.6319E-05,1.3467E-04,1.5937E-04,1.7543E-04,1.8362E-04,
     &1.8038E-04,1.5924E-04,1.2122E-04,2.2128E-05,1.1862E-04,1.6445E-04,
     &1.9397E-04,2.1438E-04,2.2054E-04,2.1448E-04,2.0102E-04,1.5787E-04,
     &2.5953E-05,1.4141E-04,1.9710E-04,2.3342E-04,2.5581E-04,2.5978E-04,
     &2.5390E-04,2.3627E-04,2.0062E-04/
      DATA ((KA(JS,JT, 3, 3),JS=1,9),JT=1,5) /
     &2.6011E-05,6.9300E-05,8.8885E-05,1.0316E-04,1.1255E-04,1.1444E-04,
     &1.1119E-04,1.0838E-04,5.7064E-05,2.9960E-05,8.6707E-05,1.1415E-04,
     &1.3351E-04,1.4420E-04,1.4685E-04,1.4419E-04,1.3258E-04,7.5649E-05,
     &3.4740E-05,1.0851E-04,1.4450E-04,1.6834E-04,1.8054E-04,1.8416E-04,
     &1.8038E-04,1.5855E-04,9.9657E-05,4.0367E-05,1.3338E-04,1.7889E-04,
     &2.0752E-04,2.2266E-04,2.2792E-04,2.1975E-04,1.8879E-04,1.2950E-04,
     &4.7325E-05,1.6087E-04,2.1635E-04,2.5031E-04,2.7116E-04,2.7639E-04,
     &2.6032E-04,2.2480E-04,1.6585E-04/
      DATA ((KA(JS,JT, 4, 3),JS=1,9),JT=1,5) /
     &4.6629E-05,8.8856E-05,1.0307E-04,1.1034E-04,1.1324E-04,1.1518E-04,
     &1.0941E-04,9.2447E-05,4.9807E-05,5.3813E-05,1.0914E-04,1.2953E-04,
     &1.4280E-04,1.4973E-04,1.5074E-04,1.4150E-04,1.2111E-04,6.6358E-05,
     &6.3364E-05,1.3307E-04,1.6255E-04,1.8292E-04,1.9276E-04,1.9285E-04,
     &1.8002E-04,1.5407E-04,8.8052E-05,7.4529E-05,1.6123E-04,2.0145E-04,
     &2.2832E-04,2.4093E-04,2.3982E-04,2.2562E-04,1.8990E-04,1.1560E-04,
     &8.8134E-05,1.9717E-04,2.4798E-04,2.7909E-04,2.9532E-04,2.9441E-04,
     &2.7564E-04,2.2733E-04,1.4686E-04/
      DATA ((KA(JS,JT, 5, 3),JS=1,9),JT=1,5) /
     &7.7279E-05,1.1122E-04,1.2109E-04,1.2443E-04,1.2189E-04,1.1617E-04,
     &1.0613E-04,8.7521E-05,4.7012E-05,8.9473E-05,1.3546E-04,1.5195E-04,
     &1.5794E-04,1.5786E-04,1.5329E-04,1.4127E-04,1.1487E-04,6.0204E-05,
     &1.0328E-04,1.6610E-04,1.8961E-04,1.9990E-04,2.0229E-04,2.0006E-04,
     &1.8432E-04,1.4896E-04,7.6087E-05,1.2119E-04,2.0367E-04,2.3155E-04,
     &2.4851E-04,2.5658E-04,2.5211E-04,2.3296E-04,1.8864E-04,9.8744E-05,
     &1.4337E-04,2.4554E-04,2.8278E-04,3.0781E-04,3.1834E-04,3.1139E-04,
     &2.8860E-04,2.3262E-04,1.2920E-04/
      DATA ((KA(JS,JT, 6, 3),JS=1,9),JT=1,5) /
     &1.1761E-04,1.4538E-04,1.4284E-04,1.3740E-04,1.2980E-04,1.1847E-04,
     &1.0232E-04,8.1254E-05,4.1748E-05,1.3703E-04,1.7162E-04,1.7382E-04,
     &1.7289E-04,1.6644E-04,1.5514E-04,1.3666E-04,1.0938E-04,5.6033E-05,
     &1.5744E-04,2.0479E-04,2.1458E-04,2.1922E-04,2.1487E-04,2.0072E-04,
     &1.7976E-04,1.4480E-04,7.3663E-05,1.7947E-04,2.4802E-04,2.6658E-04,
     &2.7311E-04,2.6613E-04,2.5639E-04,2.3337E-04,1.8491E-04,9.1670E-05,
     &2.1213E-04,2.9698E-04,3.2800E-04,3.3255E-04,3.3379E-04,3.2227E-04,
     &2.9213E-04,2.3295E-04,1.1053E-04/
      DATA ((KA(JS,JT, 7, 3),JS=1,9),JT=1,5) /
     &2.1717E-04,2.2955E-04,2.1661E-04,1.9608E-04,1.6989E-04,1.4299E-04,
     &1.1566E-04,8.2895E-05,3.7387E-05,2.4414E-04,2.6643E-04,2.5638E-04,
     &2.3114E-04,2.0334E-04,1.7738E-04,1.4895E-04,1.0764E-04,5.2222E-05,
     &2.7286E-04,3.0487E-04,2.9526E-04,2.7261E-04,2.5126E-04,2.2507E-04,
     &1.8734E-04,1.4022E-04,6.8628E-05,3.1153E-04,3.5338E-04,3.4554E-04,
     &3.2591E-04,3.0719E-04,2.7679E-04,2.3565E-04,1.8522E-04,8.6360E-05,
     &3.5307E-04,4.0595E-04,4.0654E-04,3.9853E-04,3.7853E-04,3.4348E-04,
     &3.0049E-04,2.3594E-04,1.1315E-04/
      DATA ((KA(JS,JT, 8, 3),JS=1,9),JT=1,5) /
     &5.5525E-04,5.3290E-04,4.9219E-04,4.3834E-04,3.7060E-04,2.9620E-04,
     &2.1670E-04,1.3044E-04,4.3913E-05,6.1273E-04,5.9169E-04,5.4415E-04,
     &4.8432E-04,4.1256E-04,3.3431E-04,2.4554E-04,1.5735E-04,5.6222E-05,
     &6.6697E-04,6.5930E-04,6.1229E-04,5.4542E-04,4.6824E-04,3.7897E-04,
     &2.8714E-04,1.8945E-04,7.2182E-05,7.3789E-04,7.3274E-04,6.8030E-04,
     &6.0993E-04,5.2803E-04,4.3826E-04,3.4177E-04,2.2879E-04,9.7984E-05,
     &8.2418E-04,8.2930E-04,7.7540E-04,7.0471E-04,6.2407E-04,5.2518E-04,
     &4.1114E-04,2.7739E-04,1.2917E-04/
      DATA ((KA(JS,JT, 9, 3),JS=1,9),JT=1,5) /
     &2.9866E-03,2.6446E-03,2.3122E-03,1.9743E-03,1.6235E-03,1.2497E-03,
     &8.7401E-04,4.7254E-04,6.5815E-05,3.1867E-03,2.8548E-03,2.5070E-03,
     &2.1512E-03,1.7728E-03,1.3804E-03,9.6416E-04,5.2342E-04,8.4426E-05,
     &3.3577E-03,3.0331E-03,2.6681E-03,2.2844E-03,1.8894E-03,1.4824E-03,
     &1.0437E-03,5.7926E-04,1.1456E-04,3.5955E-03,3.2669E-03,2.8865E-03,
     &2.4786E-03,2.0664E-03,1.6261E-03,1.1591E-03,6.6253E-04,1.4708E-04,
     &3.9554E-03,3.6156E-03,3.2186E-03,2.7765E-03,2.3055E-03,1.8177E-03,
     &1.3061E-03,7.6692E-04,1.9062E-04/
      DATA ((KA(JS,JT,10, 3),JS=1,9),JT=1,5) /
     &1.6695E-02,1.4628E-02,1.2561E-02,1.0499E-02,8.4474E-03,6.4042E-03,
     &4.3459E-03,2.2571E-03,5.1038E-05,1.8223E-02,1.5977E-02,1.3728E-02,
     &1.1517E-02,9.2932E-03,7.0542E-03,4.8075E-03,2.4890E-03,1.1555E-04,
     &2.0043E-02,1.7593E-02,1.5175E-02,1.2748E-02,1.0288E-02,7.8318E-03,
     &5.3279E-03,2.7782E-03,1.4398E-04,2.1904E-02,1.9249E-02,1.6643E-02,
     &1.3989E-02,1.1315E-02,8.6138E-03,5.8652E-03,3.0632E-03,1.9715E-04,
     &2.3159E-02,2.0410E-02,1.7664E-02,1.4873E-02,1.2019E-02,9.1728E-03,
     &6.2874E-03,3.3158E-03,2.7195E-04/
      DATA ((KA(JS,JT,11, 3),JS=1,9),JT=1,5) /
     &3.2603E-02,2.8559E-02,2.4510E-02,2.0449E-02,1.6397E-02,1.2361E-02,
     &8.3115E-03,4.2614E-03,4.3561E-05,3.5490E-02,3.1085E-02,2.6692E-02,
     &2.2303E-02,1.7919E-02,1.3525E-02,9.1241E-03,4.6814E-03,1.0680E-04,
     &3.8854E-02,3.4035E-02,2.9244E-02,2.4483E-02,1.9700E-02,1.4916E-02,
     &1.0095E-02,5.1808E-03,1.8562E-04,4.2305E-02,3.7086E-02,3.1904E-02,
     &2.6732E-02,2.1504E-02,1.6276E-02,1.1000E-02,5.6671E-03,2.4195E-04,
     &4.6003E-02,4.0358E-02,3.4797E-02,2.9165E-02,2.3531E-02,1.7850E-02,
     &1.2113E-02,6.2729E-03,3.2815E-04/
      DATA ((KA(JS,JT,12, 3),JS=1,9),JT=1,5) /
     &4.2717E-02,3.7390E-02,3.2076E-02,2.6766E-02,2.1453E-02,1.6148E-02,
     &1.0833E-02,5.5285E-03,5.3162E-05,4.7716E-02,4.1793E-02,3.5854E-02,
     &2.9930E-02,2.4020E-02,1.8099E-02,1.2166E-02,6.2010E-03,1.2199E-04,
     &5.2485E-02,4.5967E-02,3.9456E-02,3.2983E-02,2.6496E-02,1.9981E-02,
     &1.3462E-02,6.8646E-03,1.9551E-04,5.6971E-02,4.9905E-02,4.2910E-02,
     &3.5876E-02,2.8829E-02,2.1772E-02,1.4678E-02,7.4885E-03,2.4038E-04,
     &6.1845E-02,5.4216E-02,4.6694E-02,3.9065E-02,3.1428E-02,2.3760E-02,
     &1.6034E-02,8.2201E-03,3.2330E-04/
      DATA ((KA(JS,JT,13, 3),JS=1,9),JT=1,5) /
     &4.4159E-02,3.8661E-02,3.3159E-02,2.7655E-02,2.2159E-02,1.6679E-02,
     &1.1182E-02,5.6866E-03,7.0844E-05,4.9543E-02,4.3376E-02,3.7217E-02,
     &3.1073E-02,2.4939E-02,1.8777E-02,1.2622E-02,6.4095E-03,1.2350E-04,
     &5.4720E-02,4.7942E-02,4.1156E-02,3.4403E-02,2.7607E-02,2.0806E-02,
     &1.3984E-02,7.1021E-03,1.5128E-04,5.9716E-02,5.2321E-02,4.4977E-02,
     &3.7585E-02,3.0190E-02,2.2781E-02,1.5325E-02,7.8087E-03,2.1269E-04,
     &6.4624E-02,5.6664E-02,4.8723E-02,4.0765E-02,3.2763E-02,2.4744E-02,
     &1.6652E-02,8.4913E-03,3.0727E-04/
      DATA ((KA(JS,JT, 1, 4),JS=1,9),JT=1,5) /
     &5.7873E-05,1.6488E-04,2.0580E-04,2.2960E-04,2.3556E-04,2.2261E-04,
     &2.0972E-04,1.9322E-04,1.3088E-04,6.6249E-05,1.9462E-04,2.4549E-04,
     &2.7463E-04,2.7934E-04,2.6538E-04,2.3743E-04,2.0925E-04,1.7715E-04,
     &7.5658E-05,2.2561E-04,2.8843E-04,3.1940E-04,3.2388E-04,3.1216E-04,
     &2.9036E-04,2.7653E-04,2.3143E-04,8.5832E-05,2.6205E-04,3.3188E-04,
     &3.6495E-04,3.7173E-04,3.6401E-04,3.4696E-04,3.4171E-04,2.9590E-04,
     &9.6691E-05,2.9985E-04,3.7678E-04,4.1538E-04,4.2689E-04,4.2505E-04,
     &4.1168E-04,4.0784E-04,3.7540E-04/
      DATA ((KA(JS,JT, 2, 4),JS=1,9),JT=1,5) /
     &8.0001E-05,1.7863E-04,2.1664E-04,2.3517E-04,2.4432E-04,2.3529E-04,
     &2.0358E-04,1.5402E-04,1.1156E-04,9.2299E-05,2.0953E-04,2.5648E-04,
     &2.8347E-04,2.9289E-04,2.8063E-04,2.4649E-04,1.9992E-04,1.5181E-04,
     &1.0437E-04,2.4399E-04,3.0364E-04,3.3466E-04,3.4277E-04,3.2781E-04,
     &2.9451E-04,2.4303E-04,2.0131E-04,1.1814E-04,2.8134E-04,3.5342E-04,
     &3.8732E-04,3.9443E-04,3.8031E-04,3.4829E-04,2.8801E-04,2.6066E-04,
     &1.3198E-04,3.2404E-04,4.0415E-04,4.4181E-04,4.5121E-04,4.4037E-04,
     &4.0877E-04,3.5353E-04,3.3227E-04/
      DATA ((KA(JS,JT, 3, 4),JS=1,9),JT=1,5) /
     &1.4443E-04,2.3826E-04,2.7329E-04,2.8523E-04,2.8239E-04,2.6871E-04,
     &2.4140E-04,1.7625E-04,9.1057E-05,1.6500E-04,2.7899E-04,3.2197E-04,
     &3.3661E-04,3.4010E-04,3.2744E-04,2.9069E-04,2.1583E-04,1.2870E-04,
     &1.8759E-04,3.2667E-04,3.7258E-04,3.9759E-04,4.0496E-04,3.8750E-04,
     &3.4189E-04,2.6207E-04,1.7564E-04,2.1411E-04,3.7810E-04,4.3373E-04,
     &4.6557E-04,4.7150E-04,4.5014E-04,3.9858E-04,3.1356E-04,2.3208E-04,
     &2.3870E-04,4.2957E-04,5.0123E-04,5.3924E-04,5.3944E-04,5.1553E-04,
     &4.6343E-04,3.7106E-04,2.9980E-04/
      DATA ((KA(JS,JT, 4, 4),JS=1,9),JT=1,5) /
     &2.6076E-04,3.4439E-04,3.6366E-04,3.6515E-04,3.5256E-04,3.2080E-04,
     &2.7636E-04,2.0889E-04,8.2321E-05,2.9760E-04,4.0373E-04,4.3154E-04,
     &4.3412E-04,4.1663E-04,3.8448E-04,3.3798E-04,2.5481E-04,1.1139E-04,
     &3.4031E-04,4.7084E-04,5.0815E-04,5.1064E-04,4.9099E-04,4.5954E-04,
     &4.0644E-04,3.0187E-04,1.5330E-04,3.8682E-04,5.4745E-04,5.9070E-04,
     &5.9370E-04,5.7774E-04,5.4347E-04,4.7190E-04,3.5452E-04,2.0604E-04,
     &4.3959E-04,6.2729E-04,6.7728E-04,6.8652E-04,6.7377E-04,6.2625E-04,
     &5.4307E-04,4.1535E-04,2.7101E-04/
      DATA ((KA(JS,JT, 5, 4),JS=1,9),JT=1,5) /
     &4.3137E-04,4.9354E-04,4.9901E-04,4.7432E-04,4.3778E-04,3.8485E-04,
     &3.1938E-04,2.2709E-04,7.3559E-05,4.9217E-04,5.7735E-04,5.8525E-04,
     &5.6095E-04,5.2221E-04,4.6398E-04,3.8313E-04,2.8160E-04,1.0296E-04,
     &5.6924E-04,6.7555E-04,6.8298E-04,6.6362E-04,6.1781E-04,5.4692E-04,
     &4.5981E-04,3.4088E-04,1.4005E-04,6.5162E-04,7.8635E-04,7.9830E-04,
     &7.7682E-04,7.2322E-04,6.4526E-04,5.4580E-04,4.0061E-04,1.8482E-04,
     &7.5040E-04,9.0883E-04,9.2599E-04,8.9925E-04,8.3896E-04,7.5567E-04,
     &6.3867E-04,4.6416E-04,2.4367E-04/
      DATA ((KA(JS,JT, 6, 4),JS=1,9),JT=1,5) /
     &6.5259E-04,6.7358E-04,6.6023E-04,6.1431E-04,5.5026E-04,4.6572E-04,
     &3.6933E-04,2.4724E-04,6.3454E-05,7.5346E-04,7.9866E-04,7.7727E-04,
     &7.2579E-04,6.4756E-04,5.5655E-04,4.4395E-04,3.0264E-04,8.7333E-05,
     &8.8029E-04,9.4301E-04,9.1678E-04,8.5383E-04,7.6672E-04,6.6157E-04,
     &5.3248E-04,3.6645E-04,1.2006E-04,1.0324E-03,1.1112E-03,1.0784E-03,
     &1.0064E-03,9.0982E-04,7.8126E-04,6.2832E-04,4.4008E-04,1.6674E-04,
     &1.1873E-03,1.2942E-03,1.2623E-03,1.1793E-03,1.0646E-03,9.2296E-04,
     &7.3952E-04,5.1891E-04,2.2335E-04/
      DATA ((KA(JS,JT, 7, 4),JS=1,9),JT=1,5) /
     &1.0039E-03,9.6265E-04,8.9986E-04,8.1533E-04,7.1416E-04,5.9439E-04,
     &4.5276E-04,2.8651E-04,6.5221E-05,1.1698E-03,1.1414E-03,1.0686E-03,
     &9.8012E-04,8.6148E-04,7.1658E-04,5.4576E-04,3.5076E-04,8.8064E-05,
     &1.3785E-03,1.3654E-03,1.2898E-03,1.1834E-03,1.0346E-03,8.5792E-04,
     &6.6115E-04,4.2986E-04,1.2055E-04,1.6296E-03,1.6337E-03,1.5460E-03,
     &1.4118E-03,1.2372E-03,1.0278E-03,7.9671E-04,5.1331E-04,1.5903E-04,
     &1.9001E-03,1.9217E-03,1.8220E-03,1.6571E-03,1.4527E-03,1.2164E-03,
     &9.4433E-04,6.1289E-04,2.0363E-04/
      DATA ((KA(JS,JT, 8, 4),JS=1,9),JT=1,5) /
     &1.8226E-03,1.6514E-03,1.4839E-03,1.2932E-03,1.0982E-03,8.8723E-04,
     &6.5582E-04,3.8869E-04,7.0418E-05,2.1183E-03,1.9484E-03,1.7717E-03,
     &1.5557E-03,1.3178E-03,1.0649E-03,7.9415E-04,4.7222E-04,9.8173E-05,
     &2.5295E-03,2.3395E-03,2.1347E-03,1.8817E-03,1.6058E-03,1.3046E-03,
     &9.6185E-04,5.7415E-04,1.2861E-04,3.0151E-03,2.8208E-03,2.5722E-03,
     &2.2683E-03,1.9222E-03,1.5620E-03,1.1535E-03,7.0406E-04,1.7432E-04,
     &3.5096E-03,3.3177E-03,3.0150E-03,2.6542E-03,2.2606E-03,1.8422E-03,
     &1.3738E-03,8.5046E-04,2.3260E-04/
      DATA ((KA(JS,JT, 9, 4),JS=1,9),JT=1,5) /
     &7.9941E-03,7.0328E-03,6.0711E-03,5.1105E-03,4.1565E-03,3.2070E-03,
     &2.2152E-03,1.1971E-03,7.9032E-05,8.9783E-03,7.9063E-03,6.8488E-03,
     &5.7943E-03,4.7410E-03,3.6528E-03,2.5467E-03,1.3852E-03,1.1999E-04,
     &1.0198E-02,9.0183E-03,7.8510E-03,6.6811E-03,5.4839E-03,4.2200E-03,
     &2.9428E-03,1.6034E-03,1.6821E-04,1.1749E-02,1.0423E-02,9.0948E-03,
     &7.7411E-03,6.3357E-03,4.8731E-03,3.3881E-03,1.8608E-03,2.4632E-04,
     &1.3350E-02,1.1910E-02,1.0410E-02,8.8879E-03,7.2904E-03,5.6383E-03,
     &3.9275E-03,2.1612E-03,3.3903E-04/
      DATA ((KA(JS,JT,10, 4),JS=1,9),JT=1,5) /
     &4.5801E-02,4.0109E-02,3.4395E-02,2.8682E-02,2.2984E-02,1.7267E-02,
     &1.1579E-02,5.9235E-03,6.3484E-05,4.9659E-02,4.3500E-02,3.7321E-02,
     &3.1127E-02,2.4948E-02,1.8778E-02,1.2636E-02,6.5101E-03,9.5466E-05,
     &5.4357E-02,4.7634E-02,4.0874E-02,3.4140E-02,2.7418E-02,2.0676E-02,
     &1.3967E-02,7.2134E-03,2.1246E-04,6.0291E-02,5.2843E-02,4.5373E-02,
     &3.7958E-02,3.0510E-02,2.3082E-02,1.5672E-02,8.0960E-03,3.5404E-04,
     &6.7661E-02,5.9365E-02,5.1042E-02,4.2745E-02,3.4451E-02,2.6105E-02,
     &1.7693E-02,9.1211E-03,4.7192E-04/
      DATA ((KA(JS,JT,11, 4),JS=1,9),JT=1,5) /
     &9.0702E-02,7.9394E-02,6.8068E-02,5.6747E-02,4.5417E-02,3.4107E-02,
     &2.2797E-02,1.1511E-02,7.5853E-05,9.9244E-02,8.6879E-02,7.4483E-02,
     &6.2100E-02,4.9720E-02,3.7362E-02,2.5008E-02,1.2672E-02,1.0256E-04,
     &1.0852E-01,9.5023E-02,8.1487E-02,6.7960E-02,5.4445E-02,4.0919E-02,
     &2.7423E-02,1.3982E-02,1.6509E-04,1.1956E-01,1.0470E-01,8.9828E-02,
     &7.4940E-02,6.0117E-02,4.5252E-02,3.0437E-02,1.5543E-02,3.1661E-04,
     &1.3039E-01,1.1429E-01,9.8079E-02,8.1967E-02,6.5782E-02,4.9565E-02,
     &3.3397E-02,1.7070E-02,5.0645E-04/
      DATA ((KA(JS,JT,12, 4),JS=1,9),JT=1,5) /
     &1.2021E-01,1.0519E-01,9.0195E-02,7.5171E-02,6.0154E-02,4.5148E-02,
     &3.0151E-02,1.5167E-02,6.7632E-05,1.3016E-01,1.1394E-01,9.7701E-02,
     &8.1469E-02,6.5222E-02,4.8981E-02,3.2777E-02,1.6564E-02,9.6691E-05,
     &1.4257E-01,1.2479E-01,1.0706E-01,8.9271E-02,7.1459E-02,5.3715E-02,
     &3.5967E-02,1.8266E-02,1.8650E-04,1.5648E-01,1.3701E-01,1.1748E-01,
     &9.8018E-02,7.8554E-02,5.9075E-02,3.9673E-02,2.0186E-02,3.5387E-04,
     &1.6740E-01,1.4658E-01,1.2570E-01,1.0496E-01,8.4156E-02,6.3336E-02,
     &4.2553E-02,2.1604E-02,5.3320E-04/
      DATA ((KA(JS,JT,13, 4),JS=1,9),JT=1,5) /
     &1.2573E-01,1.1000E-01,9.4314E-02,7.8615E-02,6.2929E-02,4.7219E-02,
     &3.1536E-02,1.5865E-02,5.0474E-05,1.3569E-01,1.1873E-01,1.0180E-01,
     &8.4863E-02,6.7917E-02,5.1000E-02,3.4100E-02,1.7211E-02,1.0366E-04,
     &1.4578E-01,1.2755E-01,1.0936E-01,9.1174E-02,7.3030E-02,5.4868E-02,
     &3.6725E-02,1.8584E-02,2.4417E-04,1.5300E-01,1.3393E-01,1.1485E-01,
     &9.5797E-02,7.6755E-02,5.7691E-02,3.8700E-02,1.9588E-02,3.9463E-04,
     &1.5948E-01,1.3959E-01,1.1975E-01,9.9939E-02,8.0103E-02,6.0267E-02,
     &4.0442E-02,2.0476E-02,5.2489E-04/
      DATA ((KA(JS,JT, 1, 5),JS=1,9),JT=1,5) /
     &3.0730E-04,4.0869E-04,4.2558E-04,4.1836E-04,3.9519E-04,3.6372E-04,
     &2.8694E-04,2.6584E-04,2.1801E-04,3.2538E-04,4.3862E-04,4.6062E-04,
     &4.5800E-04,4.4348E-04,4.2125E-04,3.6505E-04,3.2613E-04,2.9396E-04,
     &3.3965E-04,4.6778E-04,5.0124E-04,5.0588E-04,5.0627E-04,4.8837E-04,
     &4.4591E-04,3.9091E-04,3.8601E-04,3.5305E-04,5.0005E-04,5.4810E-04,
     &5.6545E-04,5.7634E-04,5.6350E-04,5.3398E-04,4.9322E-04,4.9703E-04,
     &3.6843E-04,5.3559E-04,6.0074E-04,6.3388E-04,6.5476E-04,6.5121E-04,
     &6.3615E-04,6.1596E-04,6.2900E-04/
      DATA ((KA(JS,JT, 2, 5),JS=1,9),JT=1,5) /
     &4.2086E-04,5.1417E-04,5.1972E-04,4.9790E-04,4.6126E-04,4.1005E-04,
     &3.3841E-04,2.3086E-04,1.8396E-04,4.4142E-04,5.4838E-04,5.5918E-04,
     &5.4271E-04,5.1015E-04,4.6371E-04,3.9686E-04,2.8420E-04,2.4486E-04,
     &4.6438E-04,5.8432E-04,6.0102E-04,5.9651E-04,5.6920E-04,5.3041E-04,
     &4.5976E-04,3.7342E-04,3.2265E-04,4.8279E-04,6.2418E-04,6.4960E-04,
     &6.5695E-04,6.3988E-04,6.0274E-04,5.3017E-04,4.6801E-04,4.1702E-04,
     &4.9938E-04,6.6314E-04,7.0911E-04,7.2552E-04,7.1847E-04,6.8356E-04,
     &6.1801E-04,5.7242E-04,5.3937E-04/
      DATA ((KA(JS,JT, 3, 5),JS=1,9),JT=1,5) /
     &7.5073E-04,8.1743E-04,7.9414E-04,7.4039E-04,6.6425E-04,5.6902E-04,
     &4.5211E-04,2.9071E-04,1.7629E-04,7.9242E-04,8.7156E-04,8.5005E-04,
     &8.0165E-04,7.1947E-04,6.2467E-04,5.0816E-04,3.5038E-04,2.3642E-04,
     &8.3043E-04,9.2555E-04,9.1453E-04,8.6093E-04,7.8464E-04,6.9275E-04,
     &5.7807E-04,4.1288E-04,3.0691E-04,8.6053E-04,9.7674E-04,9.7765E-04,
     &9.2813E-04,8.5853E-04,7.7377E-04,6.5702E-04,4.8317E-04,3.9911E-04,
     &8.9084E-04,1.0351E-03,1.0435E-03,1.0049E-03,9.4814E-04,8.6574E-04,
     &7.4637E-04,5.6491E-04,5.0649E-04/
      DATA ((KA(JS,JT, 4, 5),JS=1,9),JT=1,5) /
     &1.3691E-03,1.3420E-03,1.2789E-03,1.1571E-03,1.0054E-03,8.3457E-04,
     &6.3859E-04,4.0761E-04,1.5090E-04,1.4497E-03,1.4458E-03,1.3693E-03,
     &1.2399E-03,1.0886E-03,9.0944E-04,6.9922E-04,4.5891E-04,2.1864E-04,
     &1.5092E-03,1.5288E-03,1.4492E-03,1.3231E-03,1.1702E-03,9.8222E-04,
     &7.7013E-04,5.2474E-04,3.0407E-04,1.5602E-03,1.6068E-03,1.5312E-03,
     &1.4087E-03,1.2594E-03,1.0655E-03,8.5735E-04,5.9578E-04,3.9268E-04,
     &1.6108E-03,1.6853E-03,1.6164E-03,1.5057E-03,1.3492E-03,1.1682E-03,
     &9.6058E-04,6.7959E-04,4.9525E-04/
      DATA ((KA(JS,JT, 5, 5),JS=1,9),JT=1,5) /
     &2.3434E-03,2.1631E-03,1.9859E-03,1.7683E-03,1.5141E-03,1.2226E-03,
     &8.9923E-04,5.4477E-04,1.2575E-04,2.4752E-03,2.3171E-03,2.1360E-03,
     &1.9016E-03,1.6214E-03,1.3108E-03,9.7831E-04,5.9705E-04,1.8419E-04,
     &2.5685E-03,2.4387E-03,2.2507E-03,2.0028E-03,1.7171E-03,1.4030E-03,
     &1.0542E-03,6.5942E-04,2.6114E-04,2.6469E-03,2.5385E-03,2.3599E-03,
     &2.1047E-03,1.8139E-03,1.4974E-03,1.1404E-03,7.3650E-04,3.6173E-04,
     &2.7111E-03,2.6448E-03,2.4645E-03,2.2107E-03,1.9222E-03,1.6048E-03,
     &1.2367E-03,8.2822E-04,4.7124E-04/
      DATA ((KA(JS,JT, 6, 5),JS=1,9),JT=1,5) /
     &3.6870E-03,3.3081E-03,2.9535E-03,2.5781E-03,2.1710E-03,1.7353E-03,
     &1.2527E-03,7.1995E-04,1.0649E-04,3.8867E-03,3.5260E-03,3.1721E-03,
     &2.7718E-03,2.3392E-03,1.8682E-03,1.3468E-03,7.8719E-04,1.5668E-04,
     &4.0284E-03,3.6872E-03,3.3334E-03,2.9169E-03,2.4661E-03,1.9733E-03,
     &1.4372E-03,8.5750E-04,2.1580E-04,4.1355E-03,3.8269E-03,3.4723E-03,
     &3.0564E-03,2.5962E-03,2.0858E-03,1.5388E-03,9.2919E-04,2.8921E-04,
     &4.2530E-03,3.9771E-03,3.6076E-03,3.1973E-03,2.7175E-03,2.1980E-03,
     &1.6503E-03,1.0123E-03,3.9933E-04/
      DATA ((KA(JS,JT, 7, 5),JS=1,9),JT=1,5) /
     &5.9303E-03,5.2537E-03,4.6038E-03,3.9568E-03,3.2763E-03,2.5699E-03,
     &1.8266E-03,1.0238E-03,9.0759E-05,6.2719E-03,5.5854E-03,4.9264E-03,
     &4.2403E-03,3.5196E-03,2.7643E-03,1.9714E-03,1.1058E-03,1.3173E-04,
     &6.5193E-03,5.8407E-03,5.1576E-03,4.4431E-03,3.6909E-03,2.9114E-03,
     &2.0825E-03,1.1806E-03,1.8536E-04,6.6989E-03,6.0314E-03,5.3552E-03,
     &4.6281E-03,3.8605E-03,3.0624E-03,2.1992E-03,1.2697E-03,2.6787E-04,
     &6.9450E-03,6.3008E-03,5.6152E-03,4.8622E-03,4.0675E-03,3.2291E-03,
     &2.3204E-03,1.3675E-03,3.5672E-04/
      DATA ((KA(JS,JT, 8, 5),JS=1,9),JT=1,5) /
     &1.1078E-02,9.7294E-03,8.3981E-03,7.0957E-03,5.7917E-03,4.4718E-03,
     &3.1091E-03,1.6886E-03,1.1294E-04,1.1717E-02,1.0310E-02,8.9257E-03,
     &7.5752E-03,6.2113E-03,4.8050E-03,3.3497E-03,1.8274E-03,1.4724E-04,
     &1.2207E-02,1.0778E-02,9.3683E-03,7.9668E-03,6.5278E-03,5.0484E-03,
     &3.5310E-03,1.9391E-03,2.0653E-04,1.2674E-02,1.1230E-02,9.8021E-03,
     &8.3609E-03,6.8807E-03,5.3359E-03,3.7364E-03,2.0615E-03,2.8343E-04,
     &1.3265E-02,1.1790E-02,1.0322E-02,8.8148E-03,7.2381E-03,5.6108E-03,
     &3.9433E-03,2.1912E-03,3.7254E-04/
      DATA ((KA(JS,JT, 9, 5),JS=1,9),JT=1,5) /
     &3.7052E-02,3.2437E-02,2.7835E-02,2.3250E-02,1.8658E-02,1.4080E-02,
     &9.5558E-03,4.9966E-03,1.9423E-04,3.9539E-02,3.4640E-02,2.9744E-02,
     &2.4857E-02,1.9981E-02,1.5146E-02,1.0322E-02,5.4117E-03,2.4661E-04,
     &4.1918E-02,3.6737E-02,3.1561E-02,2.6402E-02,2.1269E-02,1.6195E-02,
     &1.1056E-02,5.7963E-03,3.2011E-04,4.4100E-02,3.8673E-02,3.3273E-02,
     &2.7895E-02,2.2554E-02,1.7214E-02,1.1779E-02,6.1756E-03,4.1260E-04,
     &4.6405E-02,4.0709E-02,3.5073E-02,2.9453E-02,2.3852E-02,1.8195E-02,
     &1.2445E-02,6.5667E-03,5.2938E-04/
      DATA ((KA(JS,JT,10, 5),JS=1,9),JT=1,5) /
     &1.5260E-01,1.3356E-01,1.1452E-01,9.5486E-02,7.6440E-02,5.7459E-02,
     &3.8411E-02,1.9334E-02,1.8781E-04,1.6192E-01,1.4171E-01,1.2154E-01,
     &1.0139E-01,8.1225E-02,6.1032E-02,4.0817E-02,2.0639E-02,3.0020E-04,
     &1.6952E-01,1.4839E-01,1.2731E-01,1.0623E-01,8.5090E-02,6.3990E-02,
     &4.2882E-02,2.1810E-02,3.7223E-04,1.7675E-01,1.5478E-01,1.3285E-01,
     &1.1085E-01,8.8843E-02,6.6852E-02,4.4829E-02,2.2833E-02,4.6711E-04,
     &1.8239E-01,1.5968E-01,1.3704E-01,1.1434E-01,9.1701E-02,6.9058E-02,
     &4.6429E-02,2.3733E-02,6.6086E-04/
      DATA ((KA(JS,JT,11, 5),JS=1,9),JT=1,5) /
     &2.7058E-01,2.3683E-01,2.0302E-01,1.6928E-01,1.3552E-01,1.0170E-01,
     &6.7859E-02,3.4017E-02,1.5001E-04,2.7834E-01,2.4359E-01,2.0889E-01,
     &1.7416E-01,1.3942E-01,1.0462E-01,6.9857E-02,3.5072E-02,2.9190E-04,
     &2.8582E-01,2.5022E-01,2.1462E-01,1.7895E-01,1.4327E-01,1.0754E-01,
     &7.1838E-02,3.6157E-02,3.9721E-04,2.8898E-01,2.5301E-01,2.1700E-01,
     &1.8097E-01,1.4487E-01,1.0884E-01,7.2766E-02,3.6699E-02,5.3597E-04,
     &2.9536E-01,2.5857E-01,2.2177E-01,1.8491E-01,1.4809E-01,1.1136E-01,
     &7.4481E-02,3.7679E-02,7.1552E-04/
      DATA ((KA(JS,JT,12, 5),JS=1,9),JT=1,5) /
     &3.2683E-01,2.8605E-01,2.4525E-01,2.0441E-01,1.6361E-01,1.2282E-01,
     &8.1893E-02,4.1016E-02,1.4076E-04,3.3106E-01,2.8971E-01,2.4839E-01,
     &2.0704E-01,1.6570E-01,1.2434E-01,8.2938E-02,4.1600E-02,2.8033E-04,
     &3.3746E-01,2.9539E-01,2.5326E-01,2.1111E-01,1.6904E-01,1.2682E-01,
     &8.4697E-02,4.2481E-02,3.8254E-04,3.4047E-01,2.9813E-01,2.5560E-01,
     &2.1310E-01,1.7062E-01,1.2812E-01,8.5526E-02,4.3047E-02,5.1612E-04,
     &3.4523E-01,3.0226E-01,2.5919E-01,2.1613E-01,1.7310E-01,1.3003E-01,
     &8.6933E-02,4.3928E-02,7.3625E-04/
      DATA ((KA(JS,JT,13, 5),JS=1,9),JT=1,5) /
     &2.9792E-01,2.6068E-01,2.2349E-01,1.8628E-01,1.4905E-01,1.1181E-01,
     &7.4561E-02,3.7329E-02,1.5388E-04,3.0081E-01,2.6326E-01,2.2566E-01,
     &1.8811E-01,1.5050E-01,1.1291E-01,7.5310E-02,3.7768E-02,2.8934E-04,
     &3.0121E-01,2.6362E-01,2.2602E-01,1.8840E-01,1.5077E-01,1.1318E-01,
     &7.5585E-02,3.7991E-02,3.3166E-04,3.0495E-01,2.6698E-01,2.2888E-01,
     &1.9082E-01,1.5277E-01,1.1476E-01,7.6636E-02,3.8673E-02,4.6400E-04,
     &3.1093E-01,2.7226E-01,2.3342E-01,1.9467E-01,1.5596E-01,1.1716E-01,
     &7.8384E-02,3.9602E-02,6.9078E-04/
      DATA ((KA(JS,JT, 1, 6),JS=1,9),JT=1,5) /
     &6.7719E-04,7.1472E-04,7.1797E-04,6.8628E-04,6.3509E-04,5.7059E-04,
     &5.0987E-04,3.4938E-04,4.0895E-04,6.7482E-04,7.4520E-04,7.5758E-04,
     &7.4570E-04,7.0620E-04,6.5805E-04,6.1645E-04,4.7281E-04,5.4801E-04,
     &6.7924E-04,7.8313E-04,8.0713E-04,8.1739E-04,7.9231E-04,7.6723E-04,
     &7.3523E-04,6.1861E-04,7.0683E-04,6.8649E-04,8.2657E-04,8.7129E-04,
     &9.0685E-04,8.9681E-04,8.9801E-04,8.6860E-04,7.7360E-04,8.9309E-04,
     &6.9142E-04,8.7359E-04,9.5301E-04,1.0075E-03,1.0203E-03,1.0461E-03,
     &1.0218E-03,9.5114E-04,1.0965E-03/
      DATA ((KA(JS,JT, 2, 6),JS=1,9),JT=1,5) /
     &9.6029E-04,9.5330E-04,9.1502E-04,8.4442E-04,7.4240E-04,6.3131E-04,
     &5.2007E-04,3.7829E-04,3.5691E-04,9.5985E-04,9.8942E-04,9.6445E-04,
     &8.9433E-04,8.0300E-04,7.0134E-04,6.1315E-04,5.0159E-04,4.8663E-04,
     &9.6320E-04,1.0310E-03,1.0191E-03,9.5205E-04,8.7761E-04,7.9453E-04,
     &7.3253E-04,6.2365E-04,6.4547E-04,9.7399E-04,1.0755E-03,1.0817E-03,
     &1.0333E-03,9.7218E-04,9.1068E-04,8.7686E-04,7.5862E-04,8.3212E-04,
     &9.8138E-04,1.1324E-03,1.1507E-03,1.1333E-03,1.0937E-03,1.0509E-03,
     &1.0310E-03,9.0559E-04,1.0246E-03/
      DATA ((KA(JS,JT, 3, 6),JS=1,9),JT=1,5) /
     &1.8119E-03,1.6817E-03,1.5499E-03,1.3740E-03,1.1743E-03,9.5554E-04,
     &7.1656E-04,4.7034E-04,2.9777E-04,1.8107E-03,1.7310E-03,1.6189E-03,
     &1.4391E-03,1.2510E-03,1.0204E-03,7.8709E-04,5.5271E-04,4.0666E-04,
     &1.8217E-03,1.7823E-03,1.6795E-03,1.5235E-03,1.3331E-03,1.1033E-03,
     &8.7727E-04,6.6343E-04,5.5347E-04,1.8325E-03,1.8451E-03,1.7507E-03,
     &1.6178E-03,1.4289E-03,1.2102E-03,9.9121E-04,7.9875E-04,7.2923E-04,
     &1.8499E-03,1.9065E-03,1.8500E-03,1.7218E-03,1.5483E-03,1.3411E-03,
     &1.1326E-03,9.4539E-04,9.3725E-04/
      DATA ((KA(JS,JT, 4, 6),JS=1,9),JT=1,5) /
     &3.4114E-03,3.0491E-03,2.7140E-03,2.3662E-03,1.9783E-03,1.5658E-03,
     &1.1300E-03,6.5946E-04,2.6201E-04,3.4376E-03,3.0989E-03,2.7962E-03,
     &2.4537E-03,2.0666E-03,1.6491E-03,1.2098E-03,7.2995E-04,3.5441E-04,
     &3.4485E-03,3.1733E-03,2.8848E-03,2.5421E-03,2.1715E-03,1.7580E-03,
     &1.3056E-03,8.1745E-04,4.7057E-04,3.4770E-03,3.2632E-03,3.0027E-03,
     &2.6508E-03,2.2906E-03,1.8839E-03,1.4242E-03,9.3156E-04,6.1906E-04,
     &3.5195E-03,3.3661E-03,3.1261E-03,2.7792E-03,2.4277E-03,2.0261E-03,
     &1.5634E-03,1.0703E-03,8.1465E-04/
      DATA ((KA(JS,JT, 5, 6),JS=1,9),JT=1,5) /
     &5.7502E-03,5.0807E-03,4.4217E-03,3.7897E-03,3.1287E-03,2.4547E-03,
     &1.7341E-03,9.6239E-04,2.4204E-04,5.7894E-03,5.1466E-03,4.5231E-03,
     &3.9026E-03,3.2431E-03,2.5561E-03,1.8209E-03,1.0387E-03,3.3073E-04,
     &5.8510E-03,5.2408E-03,4.6666E-03,4.0479E-03,3.3863E-03,2.6690E-03,
     &1.9231E-03,1.1318E-03,4.4023E-04,5.9488E-03,5.3756E-03,4.8127E-03,
     &4.2175E-03,3.5437E-03,2.8108E-03,2.0541E-03,1.2413E-03,5.7017E-04,
     &6.0632E-03,5.5286E-03,4.9850E-03,4.3894E-03,3.7125E-03,2.9737E-03,
     &2.2202E-03,1.3784E-03,7.3804E-04/
      DATA ((KA(JS,JT, 6, 6),JS=1,9),JT=1,5) /
     &9.0144E-03,7.9241E-03,6.8389E-03,5.7807E-03,4.7224E-03,3.6386E-03,
     &2.5487E-03,1.3755E-03,2.0268E-04,9.0405E-03,7.9650E-03,6.9105E-03,
     &5.8762E-03,4.8286E-03,3.7488E-03,2.6372E-03,1.4443E-03,2.8152E-04,
     &9.2000E-03,8.1570E-03,7.1089E-03,6.0851E-03,5.0081E-03,3.9064E-03,
     &2.7603E-03,1.5330E-03,3.9833E-04,9.3676E-03,8.3397E-03,7.3293E-03,
     &6.2884E-03,5.2172E-03,4.0838E-03,2.8967E-03,1.6576E-03,5.5504E-04,
     &9.5404E-03,8.5459E-03,7.5717E-03,6.5076E-03,5.4312E-03,4.2828E-03,
     &3.0616E-03,1.8170E-03,7.2861E-04/
      DATA ((KA(JS,JT, 7, 6),JS=1,9),JT=1,5) /
     &1.4907E-02,1.3059E-02,1.1219E-02,9.3912E-03,7.6074E-03,5.8006E-03,
     &3.9637E-03,2.0976E-03,1.8870E-04,1.4960E-02,1.3123E-02,1.1304E-02,
     &9.5034E-03,7.7189E-03,5.9029E-03,4.0714E-03,2.1752E-03,2.5278E-04,
     &1.5077E-02,1.3255E-02,1.1479E-02,9.6943E-03,7.9204E-03,6.0871E-03,
     &4.2229E-03,2.2784E-03,3.4866E-04,1.5413E-02,1.3606E-02,1.1805E-02,
     &1.0016E-02,8.1764E-03,6.3063E-03,4.3884E-03,2.3906E-03,4.7884E-04,
     &1.5640E-02,1.3874E-02,1.2089E-02,1.0323E-02,8.4660E-03,6.5392E-03,
     &4.5932E-03,2.5421E-03,6.8588E-04/
      DATA ((KA(JS,JT, 8, 6),JS=1,9),JT=1,5) /
     &2.8559E-02,2.4997E-02,2.1448E-02,1.7898E-02,1.4352E-02,1.0840E-02,
     &7.3538E-03,3.7976E-03,1.9487E-04,2.8738E-02,2.5172E-02,2.1609E-02,
     &1.8050E-02,1.4521E-02,1.1028E-02,7.4791E-03,3.8937E-03,2.5597E-04,
     &2.9088E-02,2.5505E-02,2.1920E-02,1.8369E-02,1.4844E-02,1.1305E-02,
     &7.7085E-03,4.0334E-03,3.3647E-04,2.9471E-02,2.5866E-02,2.2282E-02,
     &1.8723E-02,1.5191E-02,1.1604E-02,7.9478E-03,4.2092E-03,4.5107E-04,
     &2.9965E-02,2.6334E-02,2.2760E-02,1.9185E-02,1.5605E-02,1.1940E-02,
     &8.2260E-03,4.4031E-03,6.3668E-04/
      DATA ((KA(JS,JT, 9, 6),JS=1,9),JT=1,5) /
     &1.0333E-01,9.0409E-02,7.7506E-02,6.4597E-02,5.1717E-02,3.8817E-02,
     &2.5905E-02,1.3064E-02,2.4712E-04,1.0373E-01,9.0771E-02,7.7825E-02,
     &6.4896E-02,5.1961E-02,3.9016E-02,2.6085E-02,1.3262E-02,3.3832E-04,
     &1.0493E-01,9.1818E-02,7.8786E-02,6.5718E-02,5.2648E-02,3.9574E-02,
     &2.6569E-02,1.3576E-02,4.4601E-04,1.0587E-01,9.2691E-02,7.9566E-02,
     &6.6407E-02,5.3246E-02,4.0117E-02,2.7043E-02,1.3891E-02,5.4826E-04,
     &1.0759E-01,9.4255E-02,8.0925E-02,6.7610E-02,5.4300E-02,4.1036E-02,
     &2.7792E-02,1.4265E-02,6.4886E-04/
      DATA ((KA(JS,JT,10, 6),JS=1,9),JT=1,5) /
     &3.9062E-01,3.4177E-01,2.9293E-01,2.4412E-01,1.9530E-01,1.4643E-01,
     &9.7639E-02,4.8848E-02,1.4547E-04,3.9313E-01,3.4397E-01,2.9486E-01,
     &2.4569E-01,1.9653E-01,1.4745E-01,9.8352E-02,4.9236E-02,2.6944E-04,
     &3.9636E-01,3.4679E-01,2.9726E-01,2.4770E-01,1.9822E-01,1.4872E-01,
     &9.9231E-02,4.9728E-02,4.9543E-04,4.0190E-01,3.5169E-01,3.0137E-01,
     &2.5124E-01,2.0112E-01,1.5095E-01,1.0079E-01,5.0721E-02,7.4715E-04,
     &4.1118E-01,3.5981E-01,3.0844E-01,2.5722E-01,2.0591E-01,1.5462E-01,
     &1.0334E-01,5.2226E-02,1.0737E-03/
      DATA ((KA(JS,JT,11, 6),JS=1,9),JT=1,5) /
     &5.2843E-01,4.6229E-01,3.9627E-01,3.3017E-01,2.6411E-01,1.9813E-01,
     &1.3214E-01,6.6158E-02,1.5345E-04,5.2350E-01,4.5807E-01,3.9260E-01,
     &3.2718E-01,2.6177E-01,1.9641E-01,1.3106E-01,6.5668E-02,2.3814E-04,
     &5.2048E-01,4.5536E-01,3.9029E-01,3.2525E-01,2.6032E-01,1.9539E-01,
     &1.3041E-01,6.5403E-02,4.8642E-04,5.2442E-01,4.5878E-01,3.9329E-01,
     &3.2791E-01,2.6245E-01,1.9699E-01,1.3158E-01,6.6140E-02,7.7713E-04,
     &5.3645E-01,4.6936E-01,4.0243E-01,3.3557E-01,2.6862E-01,2.0159E-01,
     &1.3470E-01,6.7828E-02,1.0827E-03/
      DATA ((KA(JS,JT,12, 6),JS=1,9),JT=1,5) /
     &5.9047E-01,5.1664E-01,4.4278E-01,3.6903E-01,2.9521E-01,2.2135E-01,
     &1.4776E-01,7.3993E-02,1.4236E-04,5.8585E-01,5.1270E-01,4.3944E-01,
     &3.6623E-01,2.9300E-01,2.1996E-01,1.4676E-01,7.3476E-02,2.2023E-04,
     &5.7367E-01,5.0194E-01,4.3031E-01,3.5876E-01,2.8718E-01,2.1559E-01,
     &1.4380E-01,7.2153E-02,4.4743E-04,5.7511E-01,5.0312E-01,4.3146E-01,
     &3.5985E-01,2.8795E-01,2.1609E-01,1.4436E-01,7.2515E-02,8.0036E-04,
     &5.8792E-01,5.1441E-01,4.4120E-01,3.6789E-01,2.9440E-01,2.2104E-01,
     &1.4769E-01,7.4288E-02,1.0818E-03/
      DATA ((KA(JS,JT,13, 6),JS=1,9),JT=1,5) /
     &5.2587E-01,4.6012E-01,3.9434E-01,3.2864E-01,2.6295E-01,1.9729E-01,
     &1.3161E-01,6.5880E-02,1.1855E-04,5.1655E-01,4.5203E-01,3.8739E-01,
     &3.2291E-01,2.5848E-01,1.9395E-01,1.2940E-01,6.4811E-02,1.8738E-04,
     &5.1454E-01,4.5033E-01,3.8607E-01,3.2190E-01,2.5767E-01,1.9330E-01,
     &1.2903E-01,6.4719E-02,4.6442E-04,5.2306E-01,4.5763E-01,3.9250E-01,
     &3.2722E-01,2.6190E-01,1.9661E-01,1.3127E-01,6.5873E-02,7.3146E-04,
     &5.3732E-01,4.7035E-01,4.0337E-01,3.3620E-01,2.6904E-01,2.0206E-01,
     &1.3501E-01,6.8074E-02,1.0136E-03/
      DATA ((KA(JS,JT, 1, 7),JS=1,9),JT=1,5) /
     &1.2103E-03,1.2175E-03,1.1935E-03,1.1549E-03,1.0791E-03,9.5598E-04,
     &8.1255E-04,6.1193E-04,6.2180E-04,1.2178E-03,1.2781E-03,1.2880E-03,
     &1.2578E-03,1.2013E-03,1.0898E-03,9.4696E-04,8.3333E-04,8.1545E-04,
     &1.2282E-03,1.3405E-03,1.3881E-03,1.3716E-03,1.3394E-03,1.2381E-03,
     &1.1125E-03,1.0711E-03,1.0876E-03,1.2403E-03,1.4084E-03,1.4922E-03,
     &1.5029E-03,1.4913E-03,1.4226E-03,1.3116E-03,1.3637E-03,1.4095E-03,
     &1.2587E-03,1.4782E-03,1.5894E-03,1.6533E-03,1.6739E-03,1.6196E-03,
     &1.5433E-03,1.7053E-03,1.8020E-03/
      DATA ((KA(JS,JT, 2, 7),JS=1,9),JT=1,5) /
     &1.5958E-03,1.5396E-03,1.4781E-03,1.3976E-03,1.2942E-03,1.1273E-03,
     &9.3307E-04,7.0021E-04,6.0904E-04,1.6176E-03,1.6176E-03,1.5750E-03,
     &1.5193E-03,1.4296E-03,1.2725E-03,1.0674E-03,8.4851E-04,7.7411E-04,
     &1.6471E-03,1.6851E-03,1.6807E-03,1.6583E-03,1.5791E-03,1.4314E-03,
     &1.2293E-03,1.0317E-03,9.9584E-04,1.6650E-03,1.7627E-03,1.7970E-03,
     &1.8046E-03,1.7334E-03,1.6113E-03,1.4228E-03,1.2451E-03,1.2394E-03,
     &1.7122E-03,1.8558E-03,1.9287E-03,1.9533E-03,1.9037E-03,1.8293E-03,
     &1.6473E-03,1.5087E-03,1.5795E-03/
      DATA ((KA(JS,JT, 3, 7),JS=1,9),JT=1,5) /
     &2.9351E-03,2.6534E-03,2.4324E-03,2.1954E-03,1.9158E-03,1.6076E-03,
     &1.2520E-03,8.5789E-04,6.1375E-04,2.9633E-03,2.7281E-03,2.5348E-03,
     &2.3132E-03,2.0567E-03,1.7614E-03,1.4143E-03,9.9890E-04,7.9742E-04,
     &3.0018E-03,2.8266E-03,2.6658E-03,2.4521E-03,2.2182E-03,1.9505E-03,
     &1.5883E-03,1.1664E-03,9.9661E-04,3.0730E-03,2.9520E-03,2.8043E-03,
     &2.6204E-03,2.4182E-03,2.1521E-03,1.7967E-03,1.3650E-03,1.2315E-03,
     &3.1816E-03,3.1107E-03,2.9552E-03,2.8080E-03,2.6346E-03,2.3544E-03,
     &2.0373E-03,1.6039E-03,1.5090E-03/
      DATA ((KA(JS,JT, 4, 7),JS=1,9),JT=1,5) /
     &5.7269E-03,5.0918E-03,4.4466E-03,3.8641E-03,3.2580E-03,2.6083E-03,
     &1.8965E-03,1.1416E-03,5.7204E-04,5.7492E-03,5.1587E-03,4.5741E-03,
     &4.0239E-03,3.4230E-03,2.7638E-03,2.0485E-03,1.2804E-03,7.6092E-04,
     &5.8525E-03,5.2748E-03,4.7562E-03,4.2073E-03,3.6092E-03,2.9384E-03,
     &2.2265E-03,1.4580E-03,9.9771E-04,5.9797E-03,5.4326E-03,4.9495E-03,
     &4.4248E-03,3.8014E-03,3.1433E-03,2.4307E-03,1.6612E-03,1.3149E-03,
     &6.1647E-03,5.6540E-03,5.1948E-03,4.6848E-03,4.0444E-03,3.3860E-03,
     &2.6695E-03,1.9106E-03,1.6620E-03/
      DATA ((KA(JS,JT, 5, 7),JS=1,9),JT=1,5) /
     &1.0220E-02,9.0008E-03,7.7868E-03,6.5817E-03,5.4248E-03,4.2290E-03,
     &3.0009E-03,1.6787E-03,5.3957E-04,1.0367E-02,9.1668E-03,7.9693E-03,
     &6.7850E-03,5.6408E-03,4.4280E-03,3.1863E-03,1.8183E-03,7.0339E-04,
     &1.0581E-02,9.4102E-03,8.2049E-03,7.0786E-03,5.9001E-03,4.6839E-03,
     &3.3914E-03,1.9878E-03,9.2591E-04,1.0809E-02,9.6775E-03,8.5132E-03,
     &7.3701E-03,6.2042E-03,4.9938E-03,3.6238E-03,2.1871E-03,1.1943E-03,
     &1.1112E-02,1.0026E-02,8.9250E-03,7.7808E-03,6.5932E-03,5.3151E-03,
     &3.9019E-03,2.4156E-03,1.5529E-03/
      DATA ((KA(JS,JT, 6, 7),JS=1,9),JT=1,5) /
     &1.6720E-02,1.4665E-02,1.2615E-02,1.0575E-02,8.5627E-03,6.5744E-03,
     &4.5286E-03,2.4830E-03,5.6458E-04,1.7104E-02,1.5034E-02,1.2975E-02,
     &1.0925E-02,8.9009E-03,6.8822E-03,4.7999E-03,2.6619E-03,7.2679E-04,
     &1.7534E-02,1.5438E-02,1.3395E-02,1.1323E-02,9.3166E-03,7.2349E-03,
     &5.0972E-03,2.8734E-03,9.0147E-04,1.8091E-02,1.6011E-02,1.3940E-02,
     &1.1869E-02,9.7728E-03,7.6440E-03,5.4515E-03,3.0818E-03,1.1288E-03,
     &1.8583E-02,1.6530E-02,1.4432E-02,1.2438E-02,1.0309E-02,8.1409E-03,
     &5.8462E-03,3.3346E-03,1.4293E-03/
      DATA ((KA(JS,JT, 7, 7),JS=1,9),JT=1,5) /
     &2.7982E-02,2.4501E-02,2.1043E-02,1.7577E-02,1.4110E-02,1.0697E-02,
     &7.3114E-03,3.8393E-03,5.1721E-04,2.8730E-02,2.5189E-02,2.1653E-02,
     &1.8120E-02,1.4619E-02,1.1160E-02,7.6475E-03,4.0900E-03,6.8268E-04,
     &2.9602E-02,2.5984E-02,2.2367E-02,1.8790E-02,1.5226E-02,1.1688E-02,
     &8.0684E-03,4.3672E-03,8.7865E-04,3.0383E-02,2.6722E-02,2.3100E-02,
     &1.9474E-02,1.5890E-02,1.2270E-02,8.5486E-03,4.6828E-03,1.1058E-03,
     &3.1027E-02,2.7319E-02,2.3722E-02,2.0052E-02,1.6464E-02,1.2803E-02,
     &9.0257E-03,5.0413E-03,1.3701E-03/
      DATA ((KA(JS,JT, 8, 7),JS=1,9),JT=1,5) /
     &5.4825E-02,4.7970E-02,4.1147E-02,3.4322E-02,2.7487E-02,2.0656E-02,
     &1.3854E-02,7.1281E-03,4.3340E-04,5.6231E-02,4.9217E-02,4.2253E-02,
     &3.5263E-02,2.8269E-02,2.1292E-02,1.4434E-02,7.4660E-03,6.0870E-04,
     &5.7926E-02,5.0738E-02,4.3579E-02,3.6411E-02,2.9254E-02,2.2161E-02,
     &1.5102E-02,7.9134E-03,8.5563E-04,5.9329E-02,5.2017E-02,4.4709E-02,
     &3.7445E-02,3.0174E-02,2.2939E-02,1.5732E-02,8.3409E-03,1.1069E-03,
     &6.0706E-02,5.3284E-02,4.5885E-02,3.8526E-02,3.1172E-02,2.3870E-02,
     &1.6429E-02,8.7694E-03,1.3835E-03/
      DATA ((KA(JS,JT, 9, 7),JS=1,9),JT=1,5) /
     &2.0429E-01,1.7875E-01,1.5322E-01,1.2768E-01,1.0216E-01,7.6684E-02,
     &5.1143E-02,2.5629E-02,2.9263E-04,2.0990E-01,1.8367E-01,1.5743E-01,
     &1.3122E-01,1.0506E-01,7.8849E-02,5.2652E-02,2.6459E-02,5.6921E-04,
     &2.1338E-01,1.8672E-01,1.6006E-01,1.3349E-01,1.0689E-01,8.0285E-02,
     &5.3664E-02,2.7200E-02,9.3758E-04,2.2002E-01,1.9252E-01,1.6512E-01,
     &1.3776E-01,1.1035E-01,8.2930E-02,5.5562E-02,2.8342E-02,1.3055E-03,
     &2.2506E-01,1.9692E-01,1.6901E-01,1.4099E-01,1.1303E-01,8.5078E-02,
     &5.7190E-02,2.9461E-02,1.8874E-03/
      DATA ((KA(JS,JT,10, 7),JS=1,9),JT=1,5) /
     &8.3776E-01,7.3310E-01,6.2841E-01,5.2361E-01,4.1890E-01,3.1415E-01,
     &2.0945E-01,1.0479E-01,1.9258E-04,8.5667E-01,7.4964E-01,6.4250E-01,
     &5.3547E-01,4.2837E-01,3.2129E-01,2.1421E-01,1.0723E-01,3.0052E-04,
     &8.7378E-01,7.6452E-01,6.5535E-01,5.4608E-01,4.3691E-01,3.2776E-01,
     &2.1870E-01,1.0952E-01,5.4766E-04,8.9911E-01,7.8666E-01,6.7423E-01,
     &5.6186E-01,4.4961E-01,3.3744E-01,2.2515E-01,1.1291E-01,1.0571E-03,
     &9.2543E-01,8.0983E-01,6.9418E-01,5.7864E-01,4.6314E-01,3.4767E-01,
     &2.3212E-01,1.1658E-01,1.4779E-03/
      DATA ((KA(JS,JT,11, 7),JS=1,9),JT=1,5) /
     &1.1170E+00,9.7735E-01,8.3780E-01,6.9827E-01,5.5860E-01,4.1894E-01,
     &2.7927E-01,1.3969E-01,1.8784E-04,1.1469E+00,1.0035E+00,8.6021E-01,
     &7.1681E-01,5.7347E-01,4.3009E-01,2.8675E-01,1.4352E-01,2.9142E-04,
     &1.1926E+00,1.0436E+00,8.9439E-01,7.4544E-01,5.9622E-01,4.4725E-01,
     &2.9836E-01,1.4934E-01,4.5203E-04,1.2362E+00,1.0816E+00,9.2703E-01,
     &7.7246E-01,6.1814E-01,4.6378E-01,3.0936E-01,1.5503E-01,7.8924E-04,
     &1.2847E+00,1.1241E+00,9.6352E-01,8.0300E-01,6.4259E-01,4.8242E-01,
     &3.2196E-01,1.6156E-01,1.3839E-03/
      DATA ((KA(JS,JT,12, 7),JS=1,9),JT=1,5) /
     &1.0784E+00,9.4374E-01,8.0896E-01,6.7399E-01,5.3931E-01,4.0450E-01,
     &2.6958E-01,1.3485E-01,1.8250E-04,1.1016E+00,9.6383E-01,8.2624E-01,
     &6.8848E-01,5.5081E-01,4.1305E-01,2.7543E-01,1.3793E-01,2.7118E-04,
     &1.1494E+00,1.0057E+00,8.6213E-01,7.1839E-01,5.7458E-01,4.3099E-01,
     &2.8756E-01,1.4395E-01,4.0903E-04,1.1966E+00,1.0468E+00,8.9727E-01,
     &7.4760E-01,5.9830E-01,4.4892E-01,2.9949E-01,1.5008E-01,6.0710E-04,
     &1.2391E+00,1.0842E+00,9.2930E-01,7.7450E-01,6.1988E-01,4.6531E-01,
     &3.1051E-01,1.5585E-01,1.1075E-03/
      DATA ((KA(JS,JT,13, 7),JS=1,9),JT=1,5) /
     &9.1609E-01,8.0170E-01,6.8730E-01,5.7285E-01,4.5825E-01,3.4365E-01,
     &2.2921E-01,1.1478E-01,1.8534E-04,9.2338E-01,8.0782E-01,6.9263E-01,
     &5.7718E-01,4.6175E-01,3.4635E-01,2.3110E-01,1.1575E-01,2.6985E-04,
     &9.4678E-01,8.2823E-01,7.0984E-01,5.9160E-01,4.7336E-01,3.5526E-01,
     &2.3691E-01,1.1874E-01,3.9189E-04,9.5798E-01,8.3839E-01,7.1856E-01,
     &5.9888E-01,4.7933E-01,3.5969E-01,2.4009E-01,1.2046E-01,6.8070E-04,
     &9.7420E-01,8.5221E-01,7.3072E-01,6.0920E-01,4.8778E-01,3.6616E-01,
     &2.4455E-01,1.2274E-01,1.2004E-03/
      DATA ((KA(JS,JT, 1, 8),JS=1,9),JT=1,5) /
     &2.2086E-03,2.0999E-03,2.0159E-03,1.8719E-03,1.7233E-03,1.5637E-03,
     &1.3735E-03,1.3147E-03,1.3769E-03,2.2485E-03,2.2158E-03,2.1547E-03,
     &2.0369E-03,1.8898E-03,1.7374E-03,1.6006E-03,1.7014E-03,1.7807E-03,
     &2.2803E-03,2.3414E-03,2.2949E-03,2.2265E-03,2.0601E-03,1.9356E-03,
     &1.8992E-03,2.1518E-03,2.2509E-03,2.3178E-03,2.4462E-03,2.4702E-03,
     &2.4013E-03,2.2630E-03,2.1680E-03,2.2995E-03,2.6824E-03,2.8243E-03,
     &2.3355E-03,2.5902E-03,2.6514E-03,2.5825E-03,2.4802E-03,2.5028E-03,
     &2.7971E-03,3.2930E-03,3.4957E-03/
      DATA ((KA(JS,JT, 2, 8),JS=1,9),JT=1,5) /
     &3.2554E-03,3.0029E-03,2.8238E-03,2.5475E-03,2.2552E-03,1.9853E-03,
     &1.6584E-03,1.2784E-03,1.0936E-03,3.3021E-03,3.1146E-03,2.9858E-03,
     &2.7302E-03,2.4455E-03,2.1856E-03,1.8782E-03,1.5376E-03,1.5050E-03,
     &3.3434E-03,3.2633E-03,3.1581E-03,2.9235E-03,2.6724E-03,2.4236E-03,
     &2.1164E-03,1.8700E-03,1.9615E-03,3.3924E-03,3.4464E-03,3.3467E-03,
     &3.1420E-03,2.9417E-03,2.6854E-03,2.3908E-03,2.2943E-03,2.5456E-03,
     &3.4124E-03,3.5941E-03,3.5577E-03,3.4139E-03,3.2366E-03,2.9618E-03,
     &2.7452E-03,2.8336E-03,3.1731E-03/
      DATA ((KA(JS,JT, 3, 8),JS=1,9),JT=1,5) /
     &6.2310E-03,5.6159E-03,4.9769E-03,4.4245E-03,3.8289E-03,3.1465E-03,
     &2.4651E-03,1.6762E-03,1.0171E-03,6.3558E-03,5.7885E-03,5.2143E-03,
     &4.7067E-03,4.0833E-03,3.4041E-03,2.6899E-03,1.9219E-03,1.2943E-03,
     &6.4584E-03,5.9604E-03,5.4819E-03,4.9958E-03,4.3577E-03,3.6662E-03,
     &2.9872E-03,2.1872E-03,1.6861E-03,6.6103E-03,6.1684E-03,5.8142E-03,
     &5.2903E-03,4.6437E-03,3.9929E-03,3.3051E-03,2.4974E-03,2.2070E-03,
     &6.6588E-03,6.3708E-03,6.1123E-03,5.6154E-03,4.9949E-03,4.3617E-03,
     &3.6895E-03,2.8582E-03,2.8798E-03/
      DATA ((KA(JS,JT, 4, 8),JS=1,9),JT=1,5) /
     &1.1807E-02,1.0450E-02,9.1344E-03,7.7844E-03,6.5100E-03,5.2593E-03,
     &3.9218E-03,2.4635E-03,1.1324E-03,1.2088E-02,1.0775E-02,9.4615E-03,
     &8.1147E-03,6.9001E-03,5.6187E-03,4.2536E-03,2.7131E-03,1.3848E-03,
     &1.2276E-02,1.1057E-02,9.7542E-03,8.5429E-03,7.3199E-03,6.0294E-03,
     &4.5931E-03,3.0093E-03,1.7357E-03,1.2505E-02,1.1360E-02,1.0130E-02,
     &9.0368E-03,7.7990E-03,6.4476E-03,5.0000E-03,3.3597E-03,2.0753E-03,
     &1.2694E-02,1.1662E-02,1.0517E-02,9.4548E-03,8.2827E-03,6.9233E-03,
     &5.4172E-03,3.7628E-03,2.5678E-03/
      DATA ((KA(JS,JT, 5, 8),JS=1,9),JT=1,5) /
     &2.0656E-02,1.8160E-02,1.5700E-02,1.3242E-02,1.0772E-02,8.3779E-03,
     &6.0246E-03,3.5524E-03,1.1630E-03,2.0910E-02,1.8437E-02,1.6005E-02,
     &1.3585E-02,1.1145E-02,8.8221E-03,6.4062E-03,3.8753E-03,1.4990E-03,
     &2.1222E-02,1.8787E-02,1.6416E-02,1.3970E-02,1.1606E-02,9.3057E-03,
     &6.8725E-03,4.2169E-03,1.9100E-03,2.1675E-02,1.9271E-02,1.6942E-02,
     &1.4504E-02,1.2206E-02,9.8161E-03,7.3695E-03,4.6216E-03,2.4296E-03,
     &2.2102E-02,1.9781E-02,1.7441E-02,1.5076E-02,1.2804E-02,1.0400E-02,
     &7.9027E-03,5.0748E-03,2.9846E-03/
      DATA ((KA(JS,JT, 6, 8),JS=1,9),JT=1,5) /
     &3.4516E-02,3.0236E-02,2.6032E-02,2.1800E-02,1.7574E-02,1.3389E-02,
     &9.2847E-03,5.1122E-03,1.0508E-03,3.4800E-02,3.0544E-02,2.6323E-02,
     &2.2117E-02,1.7921E-02,1.3756E-02,9.6631E-03,5.4342E-03,1.4451E-03,
     &3.5127E-02,3.0902E-02,2.6702E-02,2.2553E-02,1.8369E-02,1.4212E-02,
     &1.0118E-02,5.8263E-03,1.8818E-03,3.5628E-02,3.1400E-02,2.7233E-02,
     &2.3087E-02,1.8895E-02,1.4840E-02,1.0658E-02,6.2966E-03,2.4028E-03,
     &3.6414E-02,3.2167E-02,2.8039E-02,2.3770E-02,1.9619E-02,1.5526E-02,
     &1.1248E-02,6.8040E-03,2.9828E-03/
      DATA ((KA(JS,JT, 7, 8),JS=1,9),JT=1,5) /
     &6.0465E-02,5.2915E-02,4.5423E-02,3.7947E-02,3.0446E-02,2.2948E-02,
     &1.5515E-02,8.2239E-03,1.0379E-03,6.0755E-02,5.3175E-02,4.5748E-02,
     &3.8231E-02,3.0723E-02,2.3271E-02,1.5903E-02,8.5285E-03,1.3797E-03,
     &6.1398E-02,5.3805E-02,4.6318E-02,3.8793E-02,3.1274E-02,2.3804E-02,
     &1.6410E-02,8.9355E-03,1.8226E-03,6.2566E-02,5.4915E-02,4.7291E-02,
     &3.9712E-02,3.2135E-02,2.4531E-02,1.7075E-02,9.4211E-03,2.3895E-03,
     &6.4353E-02,5.6526E-02,4.8732E-02,4.1035E-02,3.3303E-02,2.5613E-02,
     &1.7950E-02,9.9840E-03,2.9275E-03/
      DATA ((KA(JS,JT, 8, 8),JS=1,9),JT=1,5) /
     &1.2368E-01,1.0822E-01,9.2766E-02,7.7347E-02,6.2005E-02,4.6603E-02,
     &3.1194E-02,1.5883E-02,8.5274E-04,1.2468E-01,1.0911E-01,9.3546E-02,
     &7.8108E-02,6.2629E-02,4.7130E-02,3.1595E-02,1.6348E-02,1.3444E-03,
     &1.2638E-01,1.1058E-01,9.4937E-02,7.9293E-02,6.3607E-02,4.7918E-02,
     &3.2304E-02,1.6902E-02,1.7616E-03,1.2969E-01,1.1353E-01,9.7623E-02,
     &8.1508E-02,6.5432E-02,4.9461E-02,3.3527E-02,1.7620E-02,2.4617E-03,
     &1.3392E-01,1.1729E-01,1.0082E-01,8.4317E-02,6.7894E-02,5.1430E-02,
     &3.4991E-02,1.8580E-02,3.1642E-03/
      DATA ((KA(JS,JT, 9, 8),JS=1,9),JT=1,5) /
     &4.6846E-01,4.0990E-01,3.5136E-01,2.9284E-01,2.3423E-01,1.7564E-01,
     &1.1723E-01,5.8786E-02,4.0030E-04,4.7406E-01,4.1475E-01,3.5556E-01,
     &2.9624E-01,2.3703E-01,1.7789E-01,1.1882E-01,5.9622E-02,6.8004E-04,
     &4.8684E-01,4.2603E-01,3.6514E-01,3.0430E-01,2.4358E-01,1.8292E-01,
     &1.2220E-01,6.1402E-02,1.0402E-03,5.0043E-01,4.3778E-01,3.7520E-01,
     &3.1290E-01,2.5060E-01,1.8834E-01,1.2594E-01,6.3564E-02,1.7944E-03,
     &5.2090E-01,4.5588E-01,3.9070E-01,3.2594E-01,2.6129E-01,1.9629E-01,
     &1.3136E-01,6.6645E-02,2.5620E-03/
      DATA ((KA(JS,JT,10, 8),JS=1,9),JT=1,5) /
     &1.9599E+00,1.7147E+00,1.4700E+00,1.2249E+00,9.7999E-01,7.3502E-01,
     &4.8995E-01,2.4496E-01,4.5019E-04,2.0004E+00,1.7503E+00,1.5003E+00,
     &1.2502E+00,1.0002E+00,7.5004E-01,5.0013E-01,2.5017E-01,7.7160E-04,
     &2.0706E+00,1.8118E+00,1.5527E+00,1.2941E+00,1.0353E+00,7.7648E-01,
     &5.1774E-01,2.5926E-01,1.2278E-03,2.1488E+00,1.8803E+00,1.6119E+00,
     &1.3430E+00,1.0744E+00,8.0582E-01,5.3747E-01,2.6934E-01,1.1252E-03,
     &2.2415E+00,1.9614E+00,1.6811E+00,1.4008E+00,1.1207E+00,8.4068E-01,
     &5.6107E-01,2.8130E-01,1.6850E-03/
      DATA ((KA(JS,JT,11, 8),JS=1,9),JT=1,5) /
     &2.8911E+00,2.5300E+00,2.1683E+00,1.8069E+00,1.4455E+00,1.0841E+00,
     &7.2274E-01,3.6133E-01,4.4874E-04,2.9950E+00,2.6205E+00,2.2462E+00,
     &1.8718E+00,1.4974E+00,1.1232E+00,7.4873E-01,3.7448E-01,7.8243E-04,
     &3.1150E+00,2.7257E+00,2.3363E+00,1.9467E+00,1.5577E+00,1.1681E+00,
     &7.7884E-01,3.8967E-01,1.2703E-03,3.2669E+00,2.8585E+00,2.4505E+00,
     &2.0417E+00,1.6337E+00,1.2254E+00,8.1715E-01,4.0914E-01,1.7634E-03,
     &3.4234E+00,2.9957E+00,2.5672E+00,2.1393E+00,1.7114E+00,1.2836E+00,
     &8.5639E-01,4.2894E-01,1.6787E-03/
      DATA ((KA(JS,JT,12, 8),JS=1,9),JT=1,5) /
     &3.0768E+00,2.6917E+00,2.3070E+00,1.9231E+00,1.5383E+00,1.1537E+00,
     &7.6915E-01,3.8462E-01,4.7094E-04,3.2435E+00,2.8382E+00,2.4330E+00,
     &2.0274E+00,1.6219E+00,1.2164E+00,8.1089E-01,4.0548E-01,8.2872E-04,
     &3.4231E+00,2.9954E+00,2.5672E+00,2.1393E+00,1.7115E+00,1.2835E+00,
     &8.5578E-01,4.2826E-01,1.3467E-03,3.5915E+00,3.1425E+00,2.6940E+00,
     &2.2448E+00,1.7959E+00,1.3469E+00,8.9804E-01,4.4980E-01,2.0869E-03,
     &3.8078E+00,3.3318E+00,2.8557E+00,2.3795E+00,1.9039E+00,1.4280E+00,
     &9.5252E-01,4.7712E-01,1.8673E-03/
      DATA ((KA(JS,JT,13, 8),JS=1,9),JT=1,5) /
     &2.3608E+00,2.0656E+00,1.7703E+00,1.4752E+00,1.1801E+00,8.8512E-01,
     &5.9005E-01,2.9502E-01,4.6667E-04,2.5500E+00,2.2311E+00,1.9119E+00,
     &1.5932E+00,1.2746E+00,9.5617E-01,6.3722E-01,3.1884E-01,8.1387E-04,
     &2.7068E+00,2.3688E+00,2.0306E+00,1.6919E+00,1.3534E+00,1.0151E+00,
     &6.7709E-01,3.3887E-01,1.3055E-03,2.8840E+00,2.5234E+00,2.1627E+00,
     &1.8025E+00,1.4417E+00,1.0815E+00,7.2137E-01,3.6139E-01,1.9116E-03,
     &3.0939E+00,2.7071E+00,2.3203E+00,1.9334E+00,1.5471E+00,1.1606E+00,
     &7.7438E-01,3.8815E-01,1.4651E-03/
      DATA ((KA(JS,JT, 1, 9),JS=1,9),JT=1,5) /
     &3.8342E-03,3.6037E-03,3.3390E-03,3.1415E-03,3.0062E-03,3.0639E-03,
     &3.3790E-03,3.9710E-03,4.6693E-03,3.8099E-03,3.5245E-03,3.4236E-03,
     &3.3696E-03,3.4435E-03,3.7521E-03,4.3079E-03,5.1949E-03,5.9521E-03,
     &3.6846E-03,3.4976E-03,3.5740E-03,3.6729E-03,4.0680E-03,4.6302E-03,
     &5.4360E-03,6.6553E-03,7.4735E-03,3.5274E-03,3.5376E-03,3.7030E-03,
     &4.1336E-03,4.8513E-03,5.7165E-03,6.7340E-03,8.3554E-03,9.2181E-03,
     &3.3692E-03,3.5348E-03,3.9656E-03,4.7179E-03,5.7827E-03,6.9797E-03,
     &8.2404E-03,1.0337E-02,1.1151E-02/
      DATA ((KA(JS,JT, 2, 9),JS=1,9),JT=1,5) /
     &6.4244E-03,5.9003E-03,5.2917E-03,4.8738E-03,4.2886E-03,3.6979E-03,
     &3.3432E-03,3.4356E-03,4.2740E-03,6.4294E-03,5.9365E-03,5.4378E-03,
     &5.0910E-03,4.5359E-03,4.1466E-03,4.0476E-03,4.4354E-03,5.4215E-03,
     &6.3847E-03,6.0135E-03,5.5846E-03,5.2573E-03,4.8954E-03,4.7657E-03,
     &4.9765E-03,5.6368E-03,6.8419E-03,6.3412E-03,5.9177E-03,5.7222E-03,
     &5.4979E-03,5.4021E-03,5.5794E-03,6.1113E-03,7.0879E-03,8.4995E-03,
     &6.1488E-03,5.8853E-03,5.8235E-03,5.8427E-03,6.0130E-03,6.6088E-03,
     &7.4819E-03,8.8092E-03,1.0289E-02/
      DATA ((KA(JS,JT, 3, 9),JS=1,9),JT=1,5) /
     &1.4195E-02,1.2643E-02,1.1125E-02,9.5338E-03,8.0743E-03,6.7413E-03,
     &5.1394E-03,3.4808E-03,3.6417E-03,1.4156E-02,1.2714E-02,1.1322E-02,
     &9.8573E-03,8.5639E-03,7.1930E-03,5.4628E-03,4.1430E-03,4.8796E-03,
     &1.4281E-02,1.3014E-02,1.1636E-02,1.0282E-02,9.0638E-03,7.5306E-03,
     &5.9490E-03,5.0136E-03,6.2613E-03,1.4318E-02,1.3194E-02,1.1832E-02,
     &1.0698E-02,9.4111E-03,7.9426E-03,6.6489E-03,6.1359E-03,7.8675E-03,
     &1.4241E-02,1.3300E-02,1.2028E-02,1.0934E-02,9.7284E-03,8.5621E-03,
     &7.5356E-03,7.5232E-03,9.7190E-03/
      DATA ((KA(JS,JT, 4, 9),JS=1,9),JT=1,5) /
     &3.1371E-02,2.7594E-02,2.3918E-02,2.0236E-02,1.6538E-02,1.2862E-02,
     &9.3415E-03,5.6206E-03,3.0136E-03,3.1367E-02,2.7706E-02,2.4150E-02,
     &2.0624E-02,1.6974E-02,1.3427E-02,9.9709E-03,6.1282E-03,4.2995E-03,
     &3.1583E-02,2.8007E-02,2.4625E-02,2.1088E-02,1.7481E-02,1.4076E-02,
     &1.0648E-02,6.6037E-03,5.6873E-03,3.1875E-02,2.8446E-02,2.5140E-02,
     &2.1570E-02,1.8204E-02,1.5013E-02,1.1353E-02,7.2455E-03,7.5289E-03,
     &3.2159E-02,2.8870E-02,2.5760E-02,2.2306E-02,1.9019E-02,1.5749E-02,
     &1.1959E-02,8.0455E-03,9.2604E-03/
      DATA ((KA(JS,JT, 5, 9),JS=1,9),JT=1,5) /
     &6.1996E-02,5.4276E-02,4.6766E-02,3.9233E-02,3.1722E-02,2.4192E-02,
     &1.6676E-02,9.3526E-03,2.3723E-03,6.2786E-02,5.5036E-02,4.7544E-02,
     &4.0014E-02,3.2500E-02,2.4919E-02,1.7414E-02,9.9958E-03,3.1775E-03,
     &6.3408E-02,5.5719E-02,4.8263E-02,4.0805E-02,3.3340E-02,2.5705E-02,
     &1.8217E-02,1.0807E-02,4.4457E-03,6.3958E-02,5.6455E-02,4.8967E-02,
     &4.1701E-02,3.4289E-02,2.6801E-02,1.9500E-02,1.1614E-02,6.0592E-03,
     &6.4544E-02,5.7091E-02,4.9896E-02,4.2837E-02,3.5365E-02,2.7903E-02,
     &2.0589E-02,1.2558E-02,7.7840E-03/
      DATA ((KA(JS,JT, 6, 9),JS=1,9),JT=1,5) /
     &1.1420E-01,9.9928E-02,8.5730E-02,7.1669E-02,5.7641E-02,4.3533E-02,
     &2.9463E-02,1.5596E-02,1.8870E-03,1.1463E-01,1.0031E-01,8.6249E-02,
     &7.2249E-02,5.8195E-02,4.4132E-02,3.0125E-02,1.6255E-02,2.7185E-03,
     &1.1505E-01,1.0074E-01,8.6836E-02,7.2850E-02,5.8886E-02,4.5056E-02,
     &3.1103E-02,1.7221E-02,3.7627E-03,1.1693E-01,1.0252E-01,8.8568E-02,
     &7.4567E-02,6.0606E-02,4.6540E-02,3.2424E-02,1.8275E-02,5.0267E-03,
     &1.1806E-01,1.0371E-01,8.9817E-02,7.5865E-02,6.1963E-02,4.7866E-02,
     &3.3695E-02,1.9500E-02,6.8317E-03/
      DATA ((KA(JS,JT, 7, 9),JS=1,9),JT=1,5) /
     &2.1427E-01,1.8749E-01,1.6070E-01,1.3399E-01,1.0738E-01,8.0867E-02,
     &5.4264E-02,2.7682E-02,1.2395E-03,2.1459E-01,1.8775E-01,1.6094E-01,
     &1.3438E-01,1.0794E-01,8.1406E-02,5.4844E-02,2.8427E-02,2.0965E-03,
     &2.1615E-01,1.8914E-01,1.6231E-01,1.3573E-01,1.0921E-01,8.2571E-02,
     &5.5952E-02,2.9582E-02,3.1925E-03,2.1891E-01,1.9155E-01,1.6470E-01,
     &1.3802E-01,1.1113E-01,8.4390E-02,5.7587E-02,3.0908E-02,4.5715E-03,
     &2.2155E-01,1.9400E-01,1.6713E-01,1.4027E-01,1.1333E-01,8.6454E-02,
     &5.9526E-02,3.2445E-02,6.5617E-03/
      DATA ((KA(JS,JT, 8, 9),JS=1,9),JT=1,5) /
     &4.6547E-01,4.0732E-01,3.4911E-01,2.9100E-01,2.3277E-01,1.7470E-01,
     &1.1672E-01,5.8764E-02,8.5250E-04,4.6469E-01,4.0659E-01,3.4854E-01,
     &2.9045E-01,2.3244E-01,1.7466E-01,1.1705E-01,5.9152E-02,1.3360E-03,
     &4.6927E-01,4.1062E-01,3.5196E-01,2.9346E-01,2.3515E-01,1.7702E-01,
     &1.1874E-01,6.0462E-02,2.4435E-03,4.7393E-01,4.1463E-01,3.5541E-01,
     &2.9668E-01,2.3809E-01,1.7953E-01,1.2082E-01,6.2242E-02,3.3995E-03,
     &4.8023E-01,4.2020E-01,3.6048E-01,3.0117E-01,2.4212E-01,1.8271E-01,
     &1.2350E-01,6.4451E-02,5.1655E-03/
      DATA ((KA(JS,JT, 9, 9),JS=1,9),JT=1,5) /
     &1.9039E+00,1.6660E+00,1.4281E+00,1.1899E+00,9.5193E-01,7.1405E-01,
     &4.7606E-01,2.3807E-01,5.1784E-04,1.8960E+00,1.6589E+00,1.4220E+00,
     &1.1850E+00,9.4792E-01,7.1098E-01,4.7399E-01,2.3745E-01,1.0379E-03,
     &1.8985E+00,1.6610E+00,1.4239E+00,1.1866E+00,9.4922E-01,7.1187E-01,
     &4.7501E-01,2.3850E-01,1.9956E-03,1.9331E+00,1.6922E+00,1.4503E+00,
     &1.2084E+00,9.6666E-01,7.2514E-01,4.8432E-01,2.4379E-01,3.3200E-03,
     &1.9563E+00,1.7116E+00,1.4675E+00,1.2227E+00,9.7814E-01,7.3426E-01,
     &4.9112E-01,2.4753E-01,5.3379E-03/
      DATA ((KA(JS,JT,10, 9),JS=1,9),JT=1,5) /
     &8.5901E+00,7.5167E+00,6.4427E+00,5.3701E+00,4.2955E+00,3.2213E+00,
     &2.1478E+00,1.0738E+00,2.8232E-05,8.5325E+00,7.4671E+00,6.4018E+00,
     &5.3343E+00,4.2664E+00,3.2001E+00,2.1333E+00,1.0667E+00,3.4266E-05,
     &8.5180E+00,7.4539E+00,6.3892E+00,5.3241E+00,4.2587E+00,3.1944E+00,
     &2.1293E+00,1.0648E+00,4.9015E-05,8.6373E+00,7.5561E+00,6.4798E+00,
     &5.3988E+00,4.3190E+00,3.2393E+00,2.1596E+00,1.0801E+00,1.1052E-03,
     &8.7651E+00,7.6691E+00,6.5729E+00,5.4773E+00,4.3830E+00,3.2869E+00,
     &2.1915E+00,1.0965E+00,2.0612E-03/
      DATA ((KA(JS,JT,11, 9),JS=1,9),JT=1,5) /
     &1.3293E+01,1.1631E+01,9.9694E+00,8.3080E+00,6.6463E+00,4.9848E+00,
     &3.3235E+00,1.6616E+00,8.6041E-05,1.3175E+01,1.1527E+01,9.8819E+00,
     &8.2359E+00,6.5871E+00,4.9407E+00,3.2935E+00,1.6469E+00,8.8405E-05,
     &1.3260E+01,1.1601E+01,9.9453E+00,8.2878E+00,6.6300E+00,4.9725E+00,
     &3.3155E+00,1.6576E+00,7.6661E-05,1.3414E+01,1.1737E+01,1.0061E+01,
     &8.3841E+00,6.7068E+00,5.0294E+00,3.3528E+00,1.6766E+00,3.1506E-04,
     &1.3624E+01,1.1922E+01,1.0219E+01,8.5160E+00,6.8128E+00,5.1095E+00,
     &3.4058E+00,1.7038E+00,1.6944E-03/
      DATA ((KA(JS,JT,12, 9),JS=1,9),JT=1,5) /
     &1.4782E+01,1.2935E+01,1.1089E+01,9.2388E+00,7.3920E+00,5.5445E+00,
     &3.6962E+00,1.8480E+00,1.3867E-04,1.4730E+01,1.2889E+01,1.1047E+01,
     &9.2076E+00,7.3659E+00,5.5246E+00,3.6830E+00,1.8415E+00,1.5061E-04,
     &1.4865E+01,1.3005E+01,1.1148E+01,9.2913E+00,7.4319E+00,5.5733E+00,
     &3.7153E+00,1.8580E+00,1.4666E-04,1.5163E+01,1.3269E+01,1.1374E+01,
     &9.4785E+00,7.5816E+00,5.6866E+00,3.7915E+00,1.8957E+00,1.4926E-04,
     &1.5423E+01,1.3495E+01,1.1567E+01,9.6394E+00,7.7115E+00,5.7838E+00,
     &3.8558E+00,1.9287E+00,1.8983E-03/
      DATA ((KA(JS,JT,13, 9),JS=1,9),JT=1,5) /
     &1.2526E+01,1.0960E+01,9.3953E+00,7.8295E+00,6.2636E+00,4.6971E+00,
     &3.1319E+00,1.5656E+00,2.2960E-04,1.2594E+01,1.1020E+01,9.4466E+00,
     &7.8734E+00,6.2977E+00,4.7229E+00,3.1489E+00,1.5743E+00,3.0250E-04,
     &1.2808E+01,1.1205E+01,9.6060E+00,8.0068E+00,6.4043E+00,4.8030E+00,
     &3.2030E+00,1.6008E+00,4.1712E-04,1.3107E+01,1.1466E+01,9.8274E+00,
     &8.1873E+00,6.5536E+00,4.9140E+00,3.2751E+00,1.6381E+00,6.5679E-04,
     &1.3444E+01,1.1761E+01,1.0081E+01,8.4011E+00,6.7204E+00,5.0404E+00,
     &3.3592E+00,1.6815E+00,2.8416E-03/
      DATA ((KA(JS,JT, 1,10),JS=1,9),JT=1,5) /
     &4.6973E-03,3.3679E-03,3.0810E-03,4.4179E-03,5.3922E-03,6.8127E-03,
     &7.5300E-03,9.6520E-03,1.0742E-02,3.3940E-03,3.6347E-03,3.8181E-03,
     &5.7069E-03,7.1993E-03,9.1516E-03,1.0242E-02,1.2914E-02,1.4284E-02,
     &2.9328E-03,3.5249E-03,5.0061E-03,7.3569E-03,8.9474E-03,1.1546E-02,
     &1.2963E-02,1.7115E-02,1.7551E-02,2.4964E-03,3.6551E-03,6.6228E-03,
     &8.9461E-03,1.0774E-02,1.3965E-02,1.7435E-02,2.2332E-02,2.1398E-02,
     &2.1304E-03,4.5161E-03,8.4664E-03,1.0811E-02,1.3640E-02,1.7099E-02,
     &2.2735E-02,2.8461E-02,2.7259E-02/
      DATA ((KA(JS,JT, 2,10),JS=1,9),JT=1,5) /
     &9.4205E-03,8.2881E-03,6.8055E-03,5.1998E-03,6.0003E-03,6.4194E-03,
     &7.3653E-03,8.1269E-03,1.1868E-02,8.5761E-03,7.3303E-03,5.6742E-03,
     &5.4200E-03,7.5061E-03,8.7164E-03,9.8614E-03,1.1132E-02,1.4929E-02,
     &7.2342E-03,5.9377E-03,5.5335E-03,7.0973E-03,9.3181E-03,1.1104E-02,
     &1.2752E-02,1.5333E-02,1.8200E-02,5.3015E-03,5.6105E-03,6.0212E-03,
     &9.3735E-03,1.1344E-02,1.3845E-02,1.6350E-02,2.0205E-02,2.2040E-02,
     &4.6868E-03,5.1363E-03,7.4969E-03,1.0079E-02,1.4155E-02,1.6850E-02,
     &1.9756E-02,2.5412E-02,2.7831E-02/
      DATA ((KA(JS,JT, 3,10),JS=1,9),JT=1,5) /
     &2.2659E-02,2.0083E-02,1.7749E-02,1.5132E-02,1.2304E-02,9.8131E-03,
     &6.5475E-03,7.6061E-03,9.2024E-03,2.3012E-02,2.0379E-02,1.7548E-02,
     &1.4904E-02,1.1694E-02,9.3796E-03,9.2412E-03,1.0030E-02,1.2744E-02,
     &2.1396E-02,1.8727E-02,1.6107E-02,1.2456E-02,1.0255E-02,1.0536E-02,
     &1.1966E-02,1.3095E-02,1.7259E-02,1.9331E-02,1.6488E-02,1.2963E-02,
     &1.0270E-02,1.1515E-02,1.2315E-02,1.5198E-02,1.6672E-02,2.2500E-02,
     &1.6551E-02,1.3344E-02,1.1001E-02,1.0385E-02,1.2450E-02,1.4894E-02,
     &1.8912E-02,2.0849E-02,2.4782E-02/
      DATA ((KA(JS,JT, 4,10),JS=1,9),JT=1,5) /
     &5.3443E-02,4.6752E-02,4.0212E-02,3.3727E-02,2.6764E-02,2.0366E-02,
     &1.4100E-02,8.5626E-03,5.0179E-03,5.5520E-02,4.8788E-02,4.2227E-02,
     &3.5776E-02,2.9164E-02,2.2326E-02,1.5452E-02,9.1701E-03,6.6031E-03,
     &5.3841E-02,4.7471E-02,4.1338E-02,3.5633E-02,2.9297E-02,2.2785E-02,
     &1.5793E-02,1.1481E-02,9.9885E-03,5.4923E-02,4.8665E-02,4.2046E-02,
     &3.5458E-02,2.8786E-02,2.1135E-02,1.3946E-02,1.4729E-02,1.3190E-02,
     &5.1650E-02,4.6045E-02,4.0319E-02,3.3252E-02,2.5245E-02,1.9132E-02,
     &1.5667E-02,1.8634E-02,1.9277E-02/
      DATA ((KA(JS,JT, 5,10),JS=1,9),JT=1,5) /
     &1.1780E-01,1.0308E-01,8.8391E-02,7.4152E-02,5.9704E-02,4.5204E-02,
     &3.0807E-02,1.6385E-02,4.0089E-03,1.1261E-01,9.8543E-02,8.5059E-02,
     &7.1216E-02,5.7505E-02,4.3649E-02,3.0528E-02,1.7529E-02,9.3093E-03,
     &1.1400E-01,9.9742E-02,8.6449E-02,7.3042E-02,5.9615E-02,4.6638E-02,
     &3.2532E-02,1.8567E-02,1.1184E-02,1.1613E-01,1.0163E-01,8.9121E-02,
     &7.4876E-02,6.0453E-02,4.6196E-02,3.1216E-02,1.9048E-02,1.2339E-02,
     &1.2016E-01,1.0608E-01,9.2375E-02,7.6465E-02,6.2248E-02,4.8476E-02,
     &3.3522E-02,1.7446E-02,1.7040E-02/
      DATA ((KA(JS,JT, 6,10),JS=1,9),JT=1,5) /
     &2.3387E-01,2.0464E-01,1.7541E-01,1.4624E-01,1.1769E-01,8.8692E-02,
     &5.9747E-02,3.0756E-02,2.5605E-03,2.3730E-01,2.0756E-01,1.7772E-01,
     &1.4892E-01,1.1985E-01,9.0758E-02,6.1778E-02,3.2933E-02,4.6893E-03,
     &2.4203E-01,2.1158E-01,1.8155E-01,1.5250E-01,1.2284E-01,9.2705E-02,
     &6.3067E-02,3.2776E-02,9.7345E-03,2.3049E-01,2.0160E-01,1.7416E-01,
     &1.4569E-01,1.1768E-01,8.9784E-02,6.1642E-02,3.4682E-02,1.6936E-02,
     &2.3636E-01,2.0679E-01,1.7932E-01,1.5154E-01,1.2337E-01,9.4475E-02,
     &6.5584E-02,3.6305E-02,2.2069E-02/
      DATA ((KA(JS,JT, 7,10),JS=1,9),JT=1,5) /
     &4.9443E-01,4.3211E-01,3.7050E-01,3.0887E-01,2.4699E-01,1.8540E-01,
     &1.2438E-01,6.2986E-02,2.0096E-03,4.9639E-01,4.3473E-01,3.7266E-01,
     &3.1039E-01,2.4852E-01,1.8749E-01,1.2568E-01,6.4131E-02,3.0764E-03,
     &4.9265E-01,4.3128E-01,3.6987E-01,3.0823E-01,2.4792E-01,1.8671E-01,
     &1.2562E-01,6.4213E-02,5.4655E-03,4.7703E-01,4.1742E-01,3.5749E-01,
     &2.9850E-01,2.4081E-01,1.8239E-01,1.2380E-01,6.5802E-02,1.0925E-02,
     &4.8180E-01,4.2216E-01,3.6195E-01,3.0277E-01,2.4364E-01,1.8402E-01,
     &1.2523E-01,6.7909E-02,1.4296E-02/
      DATA ((KA(JS,JT, 8,10),JS=1,9),JT=1,5) /
     &1.1962E+00,1.0464E+00,8.9717E-01,7.4708E-01,5.9764E-01,4.4825E-01,
     &2.9884E-01,1.5061E-01,3.8986E-03,1.2041E+00,1.0536E+00,9.0306E-01,
     &7.5220E-01,6.0244E-01,4.5171E-01,3.0103E-01,1.5197E-01,3.3573E-03,
     &1.1525E+00,1.0084E+00,8.6433E-01,7.2027E-01,5.7631E-01,4.3217E-01,
     &2.8996E-01,1.4673E-01,3.4045E-03,1.1627E+00,1.0178E+00,8.7243E-01,
     &7.2665E-01,5.8167E-01,4.3823E-01,2.9244E-01,1.4815E-01,8.5595E-03,
     &1.1683E+00,1.0228E+00,8.7612E-01,7.3014E-01,5.8445E-01,4.4237E-01,
     &2.9748E-01,1.5239E-01,1.0748E-02/
      DATA ((KA(JS,JT, 9,10),JS=1,9),JT=1,5) /
     &5.3473E+00,4.6810E+00,4.0088E+00,3.3420E+00,2.6745E+00,2.0052E+00,
     &1.3357E+00,6.6899E-01,9.0646E-06,5.3849E+00,4.7131E+00,4.0386E+00,
     &3.3668E+00,2.6936E+00,2.0203E+00,1.3467E+00,6.7337E-01,1.6160E-05,
     &5.2604E+00,4.6046E+00,3.9456E+00,3.2881E+00,2.6303E+00,1.9734E+00,
     &1.3151E+00,6.5758E-01,2.7795E-05,4.9950E+00,4.3651E+00,3.7432E+00,
     &3.1211E+00,2.4979E+00,1.8723E+00,1.2477E+00,6.2561E-01,4.1978E-05,
     &5.1108E+00,4.4671E+00,3.8297E+00,3.1913E+00,2.5537E+00,1.9170E+00,
     &1.2756E+00,6.4540E-01,6.6209E-05/
      DATA ((KA(JS,JT,10,10),JS=1,9),JT=1,5) /
     &2.6042E+01,2.2785E+01,1.9540E+01,1.6264E+01,1.3016E+01,9.7654E+00,
     &6.5078E+00,3.2552E+00,5.7707E-06,2.6479E+01,2.3167E+01,1.9837E+01,
     &1.6530E+01,1.3239E+01,9.9265E+00,6.6195E+00,3.3086E+00,1.0081E-05,
     &2.6009E+01,2.2746E+01,1.9506E+01,1.6255E+01,1.3009E+01,9.7479E+00,
     &6.5045E+00,3.2511E+00,1.6976E-05,2.4905E+01,2.1818E+01,1.8660E+01,
     &1.5572E+01,1.2451E+01,9.3433E+00,6.2220E+00,3.1125E+00,2.8117E-05,
     &2.5169E+01,2.2024E+01,1.8885E+01,1.5746E+01,1.2587E+01,9.4388E+00,
     &6.2934E+00,3.1427E+00,4.4861E-05/
      DATA ((KA(JS,JT,11,10),JS=1,9),JT=1,5) /
     &4.3366E+01,3.7949E+01,3.2540E+01,2.7105E+01,2.1683E+01,1.6263E+01,
     &1.0837E+01,5.4210E+00,4.9323E-06,4.4481E+01,3.8935E+01,3.3362E+01,
     &2.7791E+01,2.2247E+01,1.6680E+01,1.1125E+01,5.5599E+00,8.9387E-06,
     &4.2759E+01,3.7428E+01,3.2070E+01,2.6725E+01,2.1369E+01,1.6026E+01,
     &1.0686E+01,5.3424E+00,1.3904E-05,4.2776E+01,3.7387E+01,3.2051E+01,
     &2.6735E+01,2.1399E+01,1.6039E+01,1.0699E+01,5.3492E+00,2.3732E-05,
     &4.2881E+01,3.7499E+01,3.2160E+01,2.6814E+01,2.1427E+01,1.6080E+01,
     &1.0724E+01,5.3602E+00,3.9053E-05/
      DATA ((KA(JS,JT,12,10),JS=1,9),JT=1,5) /
     &5.2035E+01,4.5530E+01,3.8991E+01,3.2521E+01,2.6007E+01,1.9502E+01,
     &1.3003E+01,6.5017E+00,4.1086E-06,5.2620E+01,4.6040E+01,3.9465E+01,
     &3.2876E+01,2.6300E+01,1.9726E+01,1.3150E+01,6.5751E+00,7.6006E-06,
     &5.1699E+01,4.5233E+01,3.8772E+01,3.2297E+01,2.5847E+01,1.9404E+01,
     &1.2928E+01,6.4618E+00,1.3155E-05,5.1530E+01,4.5092E+01,3.8615E+01,
     &3.2196E+01,2.5751E+01,1.9320E+01,1.2877E+01,6.4388E+00,2.2125E-05,
     &5.2358E+01,4.5788E+01,3.9246E+01,3.2725E+01,2.6162E+01,1.9634E+01,
     &1.3083E+01,6.5448E+00,3.4034E-05/
      DATA ((KA(JS,JT,13,10),JS=1,9),JT=1,5) /
     &4.8070E+01,4.2058E+01,3.6028E+01,3.0041E+01,2.4032E+01,1.8020E+01,
     &1.2016E+01,6.0067E+00,1.1683E-05,4.7586E+01,4.1613E+01,3.5689E+01,
     &2.9748E+01,2.3780E+01,1.7835E+01,1.1890E+01,5.9450E+00,6.6906E-06,
     &4.7760E+01,4.1804E+01,3.5818E+01,2.9821E+01,2.3863E+01,1.7898E+01,
     &1.1923E+01,5.9715E+00,1.1688E-05,4.7976E+01,4.1998E+01,3.6011E+01,
     &3.0021E+01,2.3989E+01,1.7987E+01,1.2008E+01,6.0018E+00,2.0801E-05,
     &4.8185E+01,4.2179E+01,3.6131E+01,3.0110E+01,2.4087E+01,1.8066E+01,
     &1.2054E+01,6.0193E+00,3.3629E-05/
      DATA ((KA(JS,JT, 1,11),JS=1,9),JT=1,5) /
     &2.3144E-03,3.0235E-03,4.2030E-03,4.5486E-03,6.9673E-03,8.5656E-03,
     &1.0150E-02,1.3548E-02,1.3475E-02,2.0416E-03,3.1999E-03,4.6569E-03,
     &6.4031E-03,9.8267E-03,1.1395E-02,1.5022E-02,1.8877E-02,1.8904E-02,
     &1.8509E-03,4.2185E-03,5.5775E-03,9.1095E-03,1.2979E-02,1.4639E-02,
     &2.1829E-02,2.5577E-02,2.5272E-02,1.7995E-03,5.2396E-03,7.4739E-03,
     &1.1646E-02,1.7153E-02,1.9747E-02,2.8712E-02,3.3739E-02,3.3147E-02,
     &1.8412E-03,6.1417E-03,9.5119E-03,1.5457E-02,2.1034E-02,2.5800E-02,
     &3.6795E-02,4.3339E-02,4.2100E-02/
      DATA ((KA(JS,JT, 2,11),JS=1,9),JT=1,5) /
     &7.4427E-03,5.5490E-03,4.6664E-03,4.6380E-03,5.2610E-03,8.4068E-03,
     &1.0505E-02,1.1967E-02,1.0119E-02,5.3180E-03,5.4523E-03,5.6480E-03,
     &5.7960E-03,8.0504E-03,1.1015E-02,1.3308E-02,1.6901E-02,1.5834E-02,
     &4.1509E-03,5.0420E-03,5.9494E-03,7.8778E-03,1.1077E-02,1.4709E-02,
     &1.7403E-02,2.2592E-02,2.1710E-02,3.7251E-03,5.8604E-03,7.1881E-03,
     &1.0249E-02,1.4831E-02,1.9015E-02,2.1299E-02,2.9770E-02,2.9198E-02,
     &3.3170E-03,7.3759E-03,9.2312E-03,1.4285E-02,1.9035E-02,2.3096E-02,
     &2.6856E-02,3.8325E-02,3.7190E-02/
      DATA ((KA(JS,JT, 3,11),JS=1,9),JT=1,5) /
     &2.3930E-02,2.1175E-02,1.8068E-02,1.3752E-02,9.3232E-03,6.3033E-03,
     &9.0890E-03,1.0309E-02,9.2920E-03,2.1364E-02,1.8346E-02,1.4408E-02,
     &1.0567E-02,7.3487E-03,8.3255E-03,1.2320E-02,1.3559E-02,1.1942E-02,
     &1.6897E-02,1.4069E-02,1.1090E-02,9.4072E-03,9.0158E-03,1.2182E-02,
     &1.6529E-02,1.8032E-02,1.6702E-02,1.1735E-02,1.1062E-02,1.1919E-02,
     &1.0177E-02,1.1885E-02,1.6740E-02,2.0422E-02,2.2761E-02,2.2381E-02,
     &9.3268E-03,1.0886E-02,1.2245E-02,1.2355E-02,1.5695E-02,2.1667E-02,
     &2.4460E-02,2.7729E-02,3.0274E-02/
      DATA ((KA(JS,JT, 4,11),JS=1,9),JT=1,5) /
     &5.8030E-02,5.0790E-02,4.4332E-02,3.7503E-02,3.1337E-02,2.3862E-02,
     &1.5919E-02,8.9924E-03,1.0517E-02,5.8203E-02,5.1238E-02,4.3852E-02,
     &3.6687E-02,2.8842E-02,2.1050E-02,1.3525E-02,1.1884E-02,1.5506E-02,
     &6.0219E-02,5.3113E-02,4.5845E-02,3.6288E-02,2.6852E-02,1.6648E-02,
     &1.3537E-02,1.6277E-02,1.8129E-02,4.9871E-02,4.2283E-02,3.5849E-02,
     &2.8922E-02,1.9343E-02,1.4341E-02,1.8188E-02,2.0990E-02,2.0822E-02,
     &3.8385E-02,3.4058E-02,2.7365E-02,2.1994E-02,1.7140E-02,1.6164E-02,
     &2.3472E-02,2.6305E-02,2.6373E-02/
      DATA ((KA(JS,JT, 5,11),JS=1,9),JT=1,5) /
     &1.3556E-01,1.1844E-01,1.0158E-01,8.5252E-02,6.8440E-02,5.1875E-02,
     &3.5448E-02,1.8978E-02,8.8762E-03,1.3807E-01,1.2082E-01,1.0421E-01,
     &8.7432E-02,7.0858E-02,5.4903E-02,3.7824E-02,2.0068E-02,1.1692E-02,
     &1.3721E-01,1.2013E-01,1.0360E-01,8.7259E-02,7.0575E-02,5.3560E-02,
     &3.5670E-02,1.8870E-02,1.8216E-02,1.2962E-01,1.1333E-01,9.6679E-02,
     &8.1723E-02,6.6334E-02,5.1939E-02,3.3737E-02,2.0192E-02,2.7154E-02,
     &1.2340E-01,1.0852E-01,9.2540E-02,7.8313E-02,6.2622E-02,4.1413E-02,
     &2.5923E-02,2.4326E-02,3.4052E-02/
      DATA ((KA(JS,JT, 6,11),JS=1,9),JT=1,5) /
     &2.8825E-01,2.5222E-01,2.1620E-01,1.8017E-01,1.4417E-01,1.0893E-01,
     &7.3359E-02,3.7509E-02,5.6670E-03,2.8768E-01,2.5188E-01,2.1600E-01,
     &1.7993E-01,1.4497E-01,1.0976E-01,7.3838E-02,3.8599E-02,8.8428E-03,
     &2.8241E-01,2.4722E-01,2.1181E-01,1.7724E-01,1.4248E-01,1.0766E-01,
     &7.3624E-02,3.9950E-02,1.3973E-02,2.8627E-01,2.5067E-01,2.1487E-01,
     &1.8056E-01,1.4619E-01,1.1172E-01,7.8306E-02,4.0986E-02,2.0403E-02,
     &2.7874E-01,2.4399E-01,2.0989E-01,1.7645E-01,1.4231E-01,1.0969E-01,
     &7.6704E-02,4.0995E-02,2.4450E-02/
      DATA ((KA(JS,JT, 7,11),JS=1,9),JT=1,5) /
     &6.1169E-01,5.3575E-01,4.5923E-01,3.8252E-01,3.0616E-01,2.2929E-01,
     &1.5383E-01,7.7531E-02,2.8956E-03,6.1159E-01,5.3511E-01,4.5848E-01,
     &3.8242E-01,3.0567E-01,2.3004E-01,1.5345E-01,7.7731E-02,6.2629E-03,
     &6.0642E-01,5.3036E-01,4.5410E-01,3.7880E-01,3.0308E-01,2.2893E-01,
     &1.5450E-01,7.9546E-02,1.1879E-02,6.2322E-01,5.4531E-01,4.6718E-01,
     &3.8974E-01,3.1356E-01,2.3563E-01,1.5873E-01,8.1521E-02,1.3030E-02,
     &6.1773E-01,5.4019E-01,4.6283E-01,3.8859E-01,3.1161E-01,2.3601E-01,
     &1.5998E-01,8.3125E-02,1.9458E-02/
      DATA ((KA(JS,JT, 8,11),JS=1,9),JT=1,5) /
     &1.4932E+00,1.3065E+00,1.1199E+00,9.3315E-01,7.4665E-01,5.5991E-01,
     &3.7327E-01,1.8697E-01,1.1999E-05,1.5196E+00,1.3312E+00,1.1397E+00,
     &9.5010E-01,7.6026E-01,5.7020E-01,3.8013E-01,1.9174E-01,7.7042E-03,
     &1.5505E+00,1.3567E+00,1.1629E+00,9.6902E-01,7.7525E-01,5.8146E-01,
     &3.8981E-01,1.9691E-01,1.2006E-02,1.4878E+00,1.3018E+00,1.1160E+00,
     &9.2984E-01,7.4341E-01,5.5771E-01,3.7622E-01,1.9146E-01,1.2696E-02,
     &1.4729E+00,1.2883E+00,1.1049E+00,9.2129E-01,7.3618E-01,5.5599E-01,
     &3.7163E-01,1.8805E-01,1.8722E-02/
      DATA ((KA(JS,JT, 9,11),JS=1,9),JT=1,5) /
     &6.8904E+00,6.0266E+00,5.1680E+00,4.3068E+00,3.4452E+00,2.5839E+00,
     &1.7234E+00,8.6092E-01,6.7224E-06,7.0980E+00,6.2107E+00,5.3294E+00,
     &4.4415E+00,3.5510E+00,2.6633E+00,1.7755E+00,8.8723E-01,1.2025E-05,
     &7.2688E+00,6.3564E+00,5.4482E+00,4.5401E+00,3.6343E+00,2.7243E+00,
     &1.8161E+00,9.0754E-01,1.9985E-05,7.1740E+00,6.2782E+00,5.3807E+00,
     &4.4818E+00,3.5855E+00,2.6901E+00,1.7938E+00,8.9646E-01,3.0947E-05,
     &6.7468E+00,5.9097E+00,5.0601E+00,4.2188E+00,3.3754E+00,2.5313E+00,
     &1.6873E+00,8.4597E-01,4.6476E-05/
      DATA ((KA(JS,JT,10,11),JS=1,9),JT=1,5) /
     &3.5457E+01,3.1027E+01,2.6582E+01,2.2175E+01,1.7740E+01,1.3297E+01,
     &8.8648E+00,4.4349E+00,3.8551E-06,3.5857E+01,3.1366E+01,2.6891E+01,
     &2.2421E+01,1.7929E+01,1.3446E+01,8.9645E+00,4.4822E+00,7.1785E-06,
     &3.7065E+01,3.2447E+01,2.7799E+01,2.3166E+01,1.8532E+01,1.3906E+01,
     &9.2664E+00,4.6331E+00,1.2630E-05,3.6718E+01,3.2113E+01,2.7539E+01,
     &2.2938E+01,1.8366E+01,1.3764E+01,9.1841E+00,4.5916E+00,2.1179E-05,
     &3.5010E+01,3.0613E+01,2.6257E+01,2.1870E+01,1.7497E+01,1.3129E+01,
     &8.7481E+00,4.3808E+00,3.3504E-05/
      DATA ((KA(JS,JT,11,11),JS=1,9),JT=1,5) /
     &6.2218E+01,5.4427E+01,4.6646E+01,3.8874E+01,3.1110E+01,2.3334E+01,
     &1.5561E+01,7.7776E+00,3.5875E-06,6.2105E+01,5.4407E+01,4.6579E+01,
     &3.8839E+01,3.1033E+01,2.3318E+01,1.5536E+01,7.7679E+00,5.9066E-06,
     &6.4816E+01,5.6715E+01,4.8615E+01,4.0513E+01,3.2442E+01,2.4317E+01,
     &1.6205E+01,8.1056E+00,1.0776E-05,6.2787E+01,5.4987E+01,4.7112E+01,
     &3.9241E+01,3.1378E+01,2.3555E+01,1.5697E+01,7.8485E+00,1.7304E-05,
     &6.1876E+01,5.4130E+01,4.6407E+01,3.8627E+01,3.0933E+01,2.3204E+01,
     &1.5469E+01,7.7346E+00,2.7512E-05/
      DATA ((KA(JS,JT,12,11),JS=1,9),JT=1,5) /
     &8.0103E+01,7.0095E+01,6.0103E+01,5.0066E+01,4.0052E+01,3.0040E+01,
     &2.0026E+01,1.0013E+01,3.2505E-06,7.9090E+01,6.9204E+01,5.9318E+01,
     &4.9432E+01,3.9544E+01,2.9659E+01,1.9773E+01,9.8860E+00,5.5034E-06,
     &7.9848E+01,6.9859E+01,5.9882E+01,4.9902E+01,3.9894E+01,2.9946E+01,
     &1.9960E+01,9.9805E+00,8.6063E-06,7.8661E+01,6.8779E+01,5.8977E+01,
     &4.9159E+01,3.9293E+01,2.9497E+01,1.9663E+01,9.8183E+00,1.4131E-05,
     &7.8792E+01,6.8975E+01,5.9124E+01,4.9246E+01,3.9445E+01,2.9569E+01,
     &1.9707E+01,9.8563E+00,2.3305E-05/
      DATA ((KA(JS,JT,13,11),JS=1,9),JT=1,5) /
     &7.5314E+01,6.5898E+01,5.6507E+01,4.7072E+01,3.7657E+01,2.8254E+01,
     &1.8828E+01,9.4159E+00,2.7819E-06,7.4029E+01,6.4852E+01,5.5523E+01,
     &4.6247E+01,3.7031E+01,2.7774E+01,1.8528E+01,9.2576E+00,5.0908E-06,
     &7.3797E+01,6.4573E+01,5.5347E+01,4.6143E+01,3.6917E+01,2.7689E+01,
     &1.8458E+01,9.2250E+00,8.2936E-06,7.5507E+01,6.6112E+01,5.6628E+01,
     &4.7225E+01,3.7779E+01,2.8348E+01,1.8877E+01,9.4449E+00,1.2487E-05,
     &7.6962E+01,6.7290E+01,5.7729E+01,4.8107E+01,3.8486E+01,2.8863E+01,
     &1.9221E+01,9.6284E+00,1.8751E-05/
      DATA ((KA(JS,JT, 1,12),JS=1,9),JT=1,5) /
     &1.1046E-03,3.3707E-03,5.0558E-03,8.2647E-03,9.1015E-03,1.0694E-02,
     &1.8807E-02,2.2647E-02,1.8110E-02,1.0969E-03,4.7708E-03,7.6740E-03,
     &1.0546E-02,1.0900E-02,1.6801E-02,2.5799E-02,3.1294E-02,2.2312E-02,
     &1.0873E-03,6.1594E-03,1.0535E-02,1.2275E-02,1.5399E-02,2.5780E-02,
     &3.4278E-02,4.1551E-02,3.1702E-02,1.0681E-03,6.7407E-03,1.3124E-02,
     &1.6579E-02,1.9835E-02,3.5596E-02,4.4369E-02,5.3472E-02,4.1109E-02,
     &1.0270E-03,8.1418E-03,1.5112E-02,2.0848E-02,2.8658E-02,4.6490E-02,
     &5.6118E-02,6.7233E-02,5.7448E-02/
      DATA ((KA(JS,JT, 2,12),JS=1,9),JT=1,5) /
     &1.5646E-03,3.6954E-03,5.8279E-03,7.1796E-03,9.8217E-03,9.7524E-03,
     &1.1081E-02,1.8489E-02,1.8167E-02,1.5547E-03,3.8903E-03,7.0691E-03,
     &1.0316E-02,1.1952E-02,1.3642E-02,1.6631E-02,2.5775E-02,2.2105E-02,
     &1.5005E-03,5.8120E-03,1.0164E-02,1.2828E-02,1.5616E-02,1.8084E-02,
     &2.4815E-02,3.4836E-02,2.8922E-02,1.4224E-03,7.6958E-03,1.3586E-02,
     &1.5505E-02,1.9916E-02,2.3661E-02,3.6496E-02,4.5732E-02,3.8152E-02,
     &1.3736E-03,9.1086E-03,1.6016E-02,2.0127E-02,2.5470E-02,3.1020E-02,
     &5.0141E-02,5.8654E-02,5.1074E-02/
      DATA ((KA(JS,JT, 3,12),JS=1,9),JT=1,5) /
     &1.0482E-02,8.9646E-03,6.8350E-03,8.2815E-03,8.8992E-03,1.0605E-02,
     &1.0328E-02,1.1583E-02,1.6044E-02,5.7078E-03,6.1160E-03,7.6830E-03,
     &9.7377E-03,1.2964E-02,1.2587E-02,1.4124E-02,1.6978E-02,2.4120E-02,
     &3.9502E-03,6.0459E-03,1.0569E-02,1.4120E-02,1.6811E-02,1.6440E-02,
     &1.9141E-02,2.2713E-02,3.1566E-02,3.2701E-03,7.5815E-03,1.2592E-02,
     &1.9220E-02,1.9128E-02,2.1966E-02,2.6084E-02,3.3096E-02,3.6118E-02,
     &2.7401E-03,7.8080E-03,1.5492E-02,2.3290E-02,2.4892E-02,2.8848E-02,
     &3.4321E-02,4.6873E-02,4.7340E-02/
      DATA ((KA(JS,JT, 4,12),JS=1,9),JT=1,5) /
     &6.0672E-02,5.3090E-02,4.4556E-02,3.6202E-02,2.6483E-02,1.8181E-02,
     &1.2199E-02,1.0993E-02,1.4969E-02,4.3589E-02,3.8144E-02,3.0755E-02,
     &2.3593E-02,1.9730E-02,1.5624E-02,1.3490E-02,1.5542E-02,2.0057E-02,
     &2.4695E-02,2.2865E-02,1.7074E-02,1.5816E-02,1.6661E-02,2.0463E-02,
     &1.7348E-02,2.1210E-02,2.8829E-02,1.4306E-02,1.8283E-02,1.4453E-02,
     &1.9081E-02,2.2731E-02,2.4085E-02,2.3223E-02,2.7809E-02,4.1362E-02,
     &1.0713E-02,1.1979E-02,1.4158E-02,2.2119E-02,2.9428E-02,2.9426E-02,
     &3.0795E-02,3.5958E-02,5.4444E-02/
      DATA ((KA(JS,JT, 5,12),JS=1,9),JT=1,5) /
     &1.5652E-01,1.3723E-01,1.1755E-01,9.8247E-02,7.8467E-02,5.9349E-02,
     &3.9820E-02,1.8398E-02,1.1394E-02,1.5350E-01,1.3431E-01,1.1514E-01,
     &9.6381E-02,7.7667E-02,5.6368E-02,3.3743E-02,1.4780E-02,1.5913E-02,
     &1.3349E-01,1.1672E-01,9.9565E-02,8.1852E-02,6.1169E-02,4.3464E-02,
     &2.9522E-02,1.7569E-02,2.3571E-02,1.0423E-01,9.1271E-02,7.7253E-02,
     &6.0811E-02,4.8046E-02,3.4464E-02,2.5349E-02,2.3626E-02,3.4271E-02,
     &6.1168E-02,5.3666E-02,4.5385E-02,3.6131E-02,3.2187E-02,3.6873E-02,
     &3.0883E-02,3.2443E-02,4.3030E-02/
      DATA ((KA(JS,JT, 6,12),JS=1,9),JT=1,5) /
     &3.3296E-01,2.9114E-01,2.4975E-01,2.0812E-01,1.6650E-01,1.2577E-01,
     &8.4465E-02,4.3210E-02,7.5744E-03,3.2661E-01,2.8604E-01,2.4502E-01,
     &2.0429E-01,1.6474E-01,1.2400E-01,8.4046E-02,4.3324E-02,1.2737E-02,
     &3.3274E-01,2.9155E-01,2.4958E-01,2.1022E-01,1.6841E-01,1.2817E-01,
     &8.5832E-02,4.1156E-02,1.9272E-02,3.2428E-01,2.8378E-01,2.4307E-01,
     &2.0420E-01,1.6451E-01,1.2138E-01,7.6212E-02,3.3602E-02,2.1893E-02,
     &2.8830E-01,2.5208E-01,2.1788E-01,1.7562E-01,1.3634E-01,9.6797E-02,
     &6.1659E-02,2.8996E-02,3.3943E-02/
      DATA ((KA(JS,JT, 7,12),JS=1,9),JT=1,5) /
     &7.1633E-01,6.2687E-01,5.3652E-01,4.4712E-01,3.5797E-01,2.6845E-01,
     &1.7938E-01,9.0924E-02,9.7506E-03,7.4602E-01,6.5233E-01,5.5949E-01,
     &4.6595E-01,3.7278E-01,2.7940E-01,1.8898E-01,9.6146E-02,1.9089E-02,
     &7.5756E-01,6.6287E-01,5.6888E-01,4.7384E-01,3.7881E-01,2.8626E-01,
     &1.9222E-01,9.8080E-02,1.5850E-02,7.2210E-01,6.3187E-01,5.4195E-01,
     &4.5134E-01,3.6428E-01,2.7503E-01,1.8532E-01,9.5998E-02,2.2744E-02,
     &7.1833E-01,6.2908E-01,5.3886E-01,4.4907E-01,3.6079E-01,2.7147E-01,
     &1.8148E-01,9.1961E-02,3.2788E-02/
      DATA ((KA(JS,JT, 8,12),JS=1,9),JT=1,5) /
     &1.8651E+00,1.6319E+00,1.3988E+00,1.1656E+00,9.3248E-01,6.9936E-01,
     &4.6627E-01,2.3315E-01,7.1174E-06,1.9142E+00,1.6730E+00,1.4347E+00,
     &1.1964E+00,9.5588E-01,7.1697E-01,4.7797E-01,2.4089E-01,1.3089E-05,
     &1.9338E+00,1.6922E+00,1.4504E+00,1.2080E+00,9.6694E-01,7.2522E-01,
     &4.8350E-01,2.4403E-01,6.4382E-03,1.9257E+00,1.6851E+00,1.4444E+00,
     &1.2027E+00,9.6352E-01,7.2222E-01,4.8580E-01,2.4642E-01,2.0202E-02,
     &1.8578E+00,1.6228E+00,1.3921E+00,1.1585E+00,9.2745E-01,6.9620E-01,
     &4.7147E-01,2.4294E-01,3.5578E-02/
      DATA ((KA(JS,JT, 9,12),JS=1,9),JT=1,5) /
     &8.9732E+00,7.8574E+00,6.7348E+00,5.6085E+00,4.4901E+00,3.3675E+00,
     &2.2449E+00,1.1217E+00,5.5128E-06,9.0176E+00,7.8899E+00,6.7555E+00,
     &5.6293E+00,4.5061E+00,3.3798E+00,2.2531E+00,1.1272E+00,1.0749E-05,
     &9.1462E+00,8.0080E+00,6.8640E+00,5.7226E+00,4.5733E+00,3.4343E+00,
     &2.2880E+00,1.1452E+00,1.7030E-05,9.3997E+00,8.2308E+00,7.0500E+00,
     &5.8749E+00,4.7035E+00,3.5295E+00,2.3500E+00,1.1750E+00,2.7289E-05,
     &9.4496E+00,8.2622E+00,7.0818E+00,5.9018E+00,4.7215E+00,3.5410E+00,
     &2.3622E+00,1.1804E+00,4.0208E-05/
      DATA ((KA(JS,JT,10,12),JS=1,9),JT=1,5) /
     &4.7340E+01,4.1390E+01,3.5503E+01,2.9570E+01,2.3638E+01,1.7753E+01,
     &1.1835E+01,5.9140E+00,4.0857E-06,4.7468E+01,4.1532E+01,3.5600E+01,
     &2.9666E+01,2.3733E+01,1.7801E+01,1.1867E+01,5.9335E+00,7.3318E-06,
     &4.7779E+01,4.1808E+01,3.5836E+01,2.9862E+01,2.3890E+01,1.7931E+01,
     &1.1954E+01,5.9724E+00,1.2287E-05,5.0181E+01,4.3911E+01,3.7609E+01,
     &3.1364E+01,2.5077E+01,1.8819E+01,1.2546E+01,6.2708E+00,2.0136E-05,
     &5.0358E+01,4.4054E+01,3.7768E+01,3.1474E+01,2.5199E+01,1.8885E+01,
     &1.2590E+01,6.2949E+00,3.0786E-05/
      DATA ((KA(JS,JT,11,12),JS=1,9),JT=1,5) /
     &8.8012E+01,7.7091E+01,6.6061E+01,5.5064E+01,4.4041E+01,3.3007E+01,
     &2.2019E+01,1.1017E+01,3.6494E-06,8.9290E+01,7.8045E+01,6.6917E+01,
     &5.5778E+01,4.4669E+01,3.3448E+01,2.2295E+01,1.1156E+01,6.7273E-06,
     &8.6982E+01,7.6115E+01,6.5187E+01,5.4368E+01,4.3469E+01,3.2619E+01,
     &2.1748E+01,1.0873E+01,1.1236E-05,8.9808E+01,7.8580E+01,6.7351E+01,
     &5.6127E+01,4.4937E+01,3.3677E+01,2.2469E+01,1.1226E+01,1.9240E-05,
     &9.0868E+01,7.9552E+01,6.8146E+01,5.6871E+01,4.5498E+01,3.4074E+01,
     &2.2716E+01,1.1367E+01,2.9192E-05/
      DATA ((KA(JS,JT,12,12),JS=1,9),JT=1,5) /
     &1.1586E+02,1.0129E+02,8.6824E+01,7.2354E+01,5.7931E+01,4.3416E+01,
     &2.8943E+01,1.4471E+01,2.9778E-06,1.1852E+02,1.0370E+02,8.8887E+01,
     &7.4073E+01,5.9259E+01,4.4444E+01,2.9629E+01,1.4815E+01,6.0415E-06,
     &1.1782E+02,1.0310E+02,8.8376E+01,7.3644E+01,5.8951E+01,4.4160E+01,
     &2.9459E+01,1.4728E+01,1.0435E-05,1.1710E+02,1.0244E+02,8.7885E+01,
     &7.3194E+01,5.8621E+01,4.3876E+01,2.9251E+01,1.4654E+01,1.8188E-05,
     &1.1577E+02,1.0131E+02,8.6825E+01,7.2359E+01,5.7901E+01,4.3424E+01,
     &2.8943E+01,1.4462E+01,2.8178E-05/
      DATA ((KA(JS,JT,13,12),JS=1,9),JT=1,5) /
     &1.1625E+02,1.0180E+02,8.7251E+01,7.2708E+01,5.8118E+01,4.3593E+01,
     &2.9061E+01,1.4533E+01,2.6097E-06,1.1986E+02,1.0483E+02,8.9927E+01,
     &7.4912E+01,5.9931E+01,4.4948E+01,2.9950E+01,1.4982E+01,4.5705E-06,
     &1.1859E+02,1.0377E+02,8.8940E+01,7.4121E+01,5.9293E+01,4.4471E+01,
     &2.9646E+01,1.4823E+01,9.6333E-06,1.1553E+02,1.0103E+02,8.6643E+01,
     &7.2158E+01,5.7729E+01,4.3335E+01,2.8881E+01,1.4445E+01,1.6615E-05,
     &1.1521E+02,1.0087E+02,8.6350E+01,7.1959E+01,5.7620E+01,4.3214E+01,
     &2.8812E+01,1.4383E+01,2.5689E-05/
      DATA ((KA(JS,JT, 1,13),JS=1,9),JT=1,5) /
     &1.2352E-03,5.0775E-03,9.0568E-03,9.6608E-03,1.7051E-02,2.9171E-02,
     &3.4997E-02,4.0847E-02,3.4367E-02,1.2435E-03,6.8803E-03,1.1829E-02,
     &1.3668E-02,2.8015E-02,4.0318E-02,4.8254E-02,5.5929E-02,5.6166E-02,
     &1.2378E-03,7.6901E-03,1.3370E-02,2.0872E-02,4.0011E-02,5.3853E-02,
     &6.4341E-02,7.4163E-02,8.0135E-02,1.2280E-03,1.0734E-02,1.6343E-02,
     &3.0629E-02,5.6049E-02,6.9850E-02,8.3340E-02,9.5619E-02,1.1209E-01,
     &1.2088E-03,1.3761E-02,2.1254E-02,4.2402E-02,7.0900E-02,8.8313E-02,
     &1.0523E-01,1.2032E-01,1.4179E-01/
      DATA ((KA(JS,JT, 2,13),JS=1,9),JT=1,5) /
     &1.7062E-03,5.0744E-03,8.6767E-03,1.3080E-02,1.1607E-02,1.7056E-02,
     &2.8742E-02,3.5357E-02,2.3747E-02,1.7222E-03,6.7515E-03,1.2374E-02,
     &1.5331E-02,1.8393E-02,2.7370E-02,4.2648E-02,4.9678E-02,3.7912E-02,
     &1.7299E-03,8.6001E-03,1.6797E-02,2.0526E-02,2.6294E-02,4.1034E-02,
     &5.7948E-02,6.7295E-02,5.4721E-02,1.7668E-03,1.0879E-02,2.0064E-02,
     &2.7385E-02,3.4476E-02,5.8386E-02,7.6246E-02,8.8358E-02,7.0573E-02,
     &1.7596E-03,1.1860E-02,2.3664E-02,3.3939E-02,4.8492E-02,7.9884E-02,
     &9.7519E-02,1.1290E-01,9.7083E-02/
      DATA ((KA(JS,JT, 3,13),JS=1,9),JT=1,5) /
     &3.1651E-03,5.2961E-03,8.5469E-03,1.1513E-02,1.5558E-02,1.4881E-02,
     &1.6424E-02,2.5024E-02,2.8147E-02,3.3189E-03,8.3809E-03,1.1489E-02,
     &1.6299E-02,2.2221E-02,2.2841E-02,2.5024E-02,3.8200E-02,3.8233E-02,
     &3.3701E-03,1.1923E-02,1.5036E-02,2.2373E-02,2.6383E-02,3.1900E-02,
     &3.2997E-02,5.6522E-02,4.6578E-02,3.3871E-03,1.2781E-02,1.7799E-02,
     &2.9758E-02,3.5615E-02,4.1357E-02,4.8578E-02,7.5987E-02,6.6261E-02,
     &3.3797E-03,1.4220E-02,2.3964E-02,3.5644E-02,4.5626E-02,4.9180E-02,
     &6.9386E-02,9.9109E-02,8.8310E-02/
      DATA ((KA(JS,JT, 4,13),JS=1,9),JT=1,5) /
     &1.0343E-02,9.0620E-03,1.2015E-02,1.1324E-02,1.3382E-02,1.5654E-02,
     &1.8625E-02,1.7070E-02,2.1331E-02,6.4226E-03,5.6266E-03,1.6045E-02,
     &1.6336E-02,1.7909E-02,2.2857E-02,2.5406E-02,2.4740E-02,3.1419E-02,
     &6.5549E-03,5.7385E-03,1.8741E-02,2.0901E-02,2.5444E-02,3.1318E-02,
     &3.5488E-02,3.2476E-02,4.5848E-02,6.6407E-03,5.8164E-03,2.0962E-02,
     &2.6844E-02,3.4892E-02,4.1403E-02,4.7653E-02,4.2426E-02,6.5116E-02,
     &6.8300E-03,1.2571E-02,2.5118E-02,3.2793E-02,4.7122E-02,5.5638E-02,
     &5.7712E-02,6.2270E-02,8.9700E-02/
      DATA ((KA(JS,JT, 5,13),JS=1,9),JT=1,5) /
     &9.0149E-02,7.8756E-02,6.7503E-02,5.7299E-02,4.6607E-02,3.2042E-02,
     &2.0392E-02,1.6128E-02,1.9894E-02,4.8191E-02,4.2297E-02,3.6135E-02,
     &3.5890E-02,2.5466E-02,2.2998E-02,2.3063E-02,2.5066E-02,2.8493E-02,
     &2.0878E-02,1.8444E-02,2.0162E-02,2.6175E-02,2.5330E-02,2.8034E-02,
     &3.3888E-02,3.5693E-02,3.9583E-02,1.2467E-02,1.0910E-02,2.2261E-02,
     &3.0489E-02,3.2389E-02,3.6918E-02,4.6126E-02,4.7452E-02,5.4222E-02,
     &1.2730E-02,1.1204E-02,2.9691E-02,3.6357E-02,4.1593E-02,4.9722E-02,
     &6.1593E-02,5.8372E-02,7.2216E-02/
      DATA ((KA(JS,JT, 6,13),JS=1,9),JT=1,5) /
     &3.3772E-01,2.9577E-01,2.5329E-01,2.1108E-01,1.6887E-01,1.2604E-01,
     &7.8045E-02,3.5455E-02,1.6952E-02,2.6913E-01,2.3492E-01,2.0161E-01,
     &1.6802E-01,1.3597E-01,9.6507E-02,6.1842E-02,3.0282E-02,3.2161E-02,
     &1.8198E-01,1.5897E-01,1.3649E-01,1.1355E-01,1.0014E-01,6.6575E-02,
     &4.2969E-02,3.1778E-02,5.1438E-02,9.5916E-02,8.3628E-02,7.1947E-02,
     &6.5931E-02,5.4714E-02,4.3955E-02,3.9042E-02,4.5021E-02,5.3865E-02,
     &3.8338E-02,3.3822E-02,2.8989E-02,4.7523E-02,4.4391E-02,4.9375E-02,
     &5.3458E-02,6.4090E-02,6.5458E-02/
      DATA ((KA(JS,JT, 7,13),JS=1,9),JT=1,5) /
     &8.4065E-01,7.3491E-01,6.3155E-01,5.2581E-01,4.2110E-01,3.1579E-01,
     &2.1053E-01,1.0597E-01,2.9312E-06,8.3906E-01,7.3475E-01,6.2926E-01,
     &5.2485E-01,4.1990E-01,3.1520E-01,2.1013E-01,9.8180E-02,5.1556E-06,
     &7.1003E-01,6.2128E-01,5.3203E-01,4.4338E-01,3.5504E-01,2.6905E-01,
     &1.6926E-01,7.8231E-02,2.0966E-02,5.6430E-01,4.9377E-01,4.2325E-01,
     &3.5272E-01,2.8217E-01,2.1549E-01,1.3644E-01,6.7355E-02,4.1095E-02,
     &3.6362E-01,3.1751E-01,2.7269E-01,2.2725E-01,1.9431E-01,1.4468E-01,
     &9.9409E-02,6.2076E-02,6.3795E-02/
      DATA ((KA(JS,JT, 8,13),JS=1,9),JT=1,5) /
     &2.2236E+00,1.9437E+00,1.6676E+00,1.3884E+00,1.1107E+00,8.3381E-01,
     &5.5588E-01,2.7795E-01,1.5745E-06,2.2078E+00,1.9318E+00,1.6572E+00,
     &1.3798E+00,1.1048E+00,8.2853E-01,5.5239E-01,2.7779E-01,2.9445E-06,
     &2.2271E+00,1.9469E+00,1.6686E+00,1.3901E+00,1.1125E+00,8.3518E-01,
     &5.5623E-01,2.8153E-01,5.1096E-06,2.1637E+00,1.8932E+00,1.6227E+00,
     &1.3534E+00,1.0818E+00,8.1139E-01,5.4287E-01,2.5697E-01,9.9333E-06,
     &1.8021E+00,1.5805E+00,1.3532E+00,1.1288E+00,9.0270E-01,6.7733E-01,
     &4.5729E-01,2.1399E-01,3.0555E-05/
      DATA ((KA(JS,JT, 9,13),JS=1,9),JT=1,5) /
     &1.0795E+01,9.4461E+00,8.0967E+00,6.7526E+00,5.3928E+00,4.0485E+00,
     &2.6990E+00,1.3503E+00,8.4365E-07,1.1064E+01,9.6811E+00,8.2980E+00,
     &6.9149E+00,5.5320E+00,4.1492E+00,2.7660E+00,1.3844E+00,1.6130E-06,
     &1.1399E+01,9.9733E+00,8.5488E+00,7.1204E+00,5.6991E+00,4.2710E+00,
     &2.8497E+00,1.4241E+00,6.0805E-06,1.1508E+01,1.0061E+01,8.6395E+00,
     &7.1995E+00,5.7491E+00,4.3120E+00,2.8800E+00,1.4386E+00,1.4128E-05,
     &1.1400E+01,9.9831E+00,8.5576E+00,7.1312E+00,5.7049E+00,4.2787E+00,
     &2.8526E+00,1.4263E+00,2.6902E-05/
      DATA ((KA(JS,JT,10,13),JS=1,9),JT=1,5) /
     &6.0229E+01,5.2742E+01,4.5172E+01,3.7644E+01,3.0138E+01,2.2585E+01,
     &1.5057E+01,7.5286E+00,7.1488E-07,6.2236E+01,5.4452E+01,4.6675E+01,
     &3.8896E+01,3.1118E+01,2.3338E+01,1.5559E+01,7.7794E+00,2.2353E-06,
     &6.3127E+01,5.5205E+01,4.7321E+01,3.9431E+01,3.1516E+01,2.3656E+01,
     &1.5745E+01,7.8865E+00,5.3891E-06,6.1110E+01,5.3475E+01,4.5823E+01,
     &3.8155E+01,3.0566E+01,2.2893E+01,1.5262E+01,7.6312E+00,1.1169E-05,
     &6.4796E+01,5.6740E+01,4.8597E+01,4.0457E+01,3.2404E+01,2.4299E+01,
     &1.6199E+01,8.1078E+00,2.0550E-05/
      DATA ((KA(JS,JT,11,13),JS=1,9),JT=1,5) /
     &1.1504E+02,1.0058E+02,8.6129E+01,7.1842E+01,5.7476E+01,4.3140E+01,
     &2.8738E+01,1.4357E+01,9.3132E-07,1.1792E+02,1.0317E+02,8.8507E+01,
     &7.3697E+01,5.8960E+01,4.4221E+01,2.9502E+01,1.4740E+01,2.4724E-06,
     &1.2218E+02,1.0691E+02,9.1705E+01,7.6362E+01,6.1091E+01,4.5817E+01,
     &3.0544E+01,1.5272E+01,5.4659E-06,1.2095E+02,1.0583E+02,9.0715E+01,
     &7.5596E+01,6.0430E+01,4.5404E+01,3.0213E+01,1.5120E+01,1.0930E-05,
     &1.1751E+02,1.0271E+02,8.8136E+01,7.3302E+01,5.8706E+01,4.4021E+01,
     &2.9378E+01,1.4677E+01,1.9680E-05/
      DATA ((KA(JS,JT,12,13),JS=1,9),JT=1,5) /
     &1.6045E+02,1.4037E+02,1.2031E+02,1.0025E+02,8.0142E+01,6.0153E+01,
     &4.0104E+01,2.0052E+01,1.7476E-06,1.6342E+02,1.4301E+02,1.2246E+02,
     &1.0215E+02,8.1640E+01,6.1227E+01,4.0821E+01,2.0431E+01,2.4757E-06,
     &1.6723E+02,1.4633E+02,1.2542E+02,1.0452E+02,8.3616E+01,6.2709E+01,
     &4.1810E+01,2.0904E+01,5.2593E-06,1.7014E+02,1.4884E+02,1.2747E+02,
     &1.0623E+02,8.4980E+01,6.3783E+01,4.2524E+01,2.1245E+01,9.8363E-06,
     &1.6634E+02,1.4563E+02,1.2476E+02,1.0397E+02,8.3150E+01,6.2327E+01,
     &4.1610E+01,2.0792E+01,1.5825E-05/
      DATA ((KA(JS,JT,13,13),JS=1,9),JT=1,5) /
     &1.7420E+02,1.5232E+02,1.3056E+02,1.0880E+02,8.7095E+01,6.5324E+01,
     &4.3550E+01,2.1773E+01,2.0359E-06,1.7505E+02,1.5318E+02,1.3125E+02,
     &1.0942E+02,8.7528E+01,6.5649E+01,4.3765E+01,2.1882E+01,3.6885E-06,
     &1.7705E+02,1.5491E+02,1.3279E+02,1.1065E+02,8.8524E+01,6.6391E+01,
     &4.4262E+01,2.2130E+01,4.3611E-06,1.7817E+02,1.5590E+02,1.3363E+02,
     &1.1135E+02,8.9083E+01,6.6758E+01,4.4540E+01,2.2253E+01,7.0150E-06,
     &1.7584E+02,1.5385E+02,1.3199E+02,1.0999E+02,8.7917E+01,6.5939E+01,
     &4.3996E+01,2.1972E+01,1.1356E-05/
      DATA ((KA(JS,JT, 1,14),JS=1,9),JT=1,5) /
     &1.3576E-03,5.9355E-03,1.2070E-02,3.4616E-02,5.3142E-02,6.5578E-02,
     &7.6852E-02,8.4718E-02,1.0628E-01,1.4884E-03,6.6850E-03,2.0385E-02,
     &5.2397E-02,7.2846E-02,8.9954E-02,1.0527E-01,1.1545E-01,1.4569E-01,
     &1.6038E-03,1.0153E-02,3.3679E-02,7.2611E-02,9.6223E-02,1.1901E-01,
     &1.3945E-01,1.5228E-01,1.9245E-01,1.7044E-03,1.3918E-02,4.9229E-02,
     &9.2925E-02,1.2323E-01,1.5253E-01,1.7914E-01,1.9539E-01,2.4647E-01,
     &1.8000E-03,1.6377E-02,6.7350E-02,1.1593E-01,1.5369E-01,1.9039E-01,
     &2.2401E-01,2.4471E-01,3.0739E-01/
      DATA ((KA(JS,JT, 2,14),JS=1,9),JT=1,5) /
     &2.3036E-03,8.1410E-03,1.1112E-02,1.5744E-02,3.9389E-02,5.9885E-02,
     &7.1149E-02,8.0027E-02,7.8847E-02,2.5134E-03,1.3270E-02,1.6290E-02,
     &2.9767E-02,5.8863E-02,8.3096E-02,9.8866E-02,1.1160E-01,1.1776E-01,
     &2.6930E-03,1.4292E-02,1.9903E-02,4.6191E-02,8.3472E-02,1.1096E-01,
     &1.3216E-01,1.4974E-01,1.6719E-01,2.7875E-03,1.4114E-02,2.4277E-02,
     &6.6428E-02,1.1553E-01,1.4377E-01,1.7103E-01,1.9428E-01,2.3106E-01,
     &2.8719E-03,1.9476E-02,3.5900E-02,9.2156E-02,1.4592E-01,1.8154E-01,
     &2.1576E-01,2.4502E-01,2.9183E-01/
      DATA ((KA(JS,JT, 3,14),JS=1,9),JT=1,5) /
     &5.1130E-03,4.4754E-03,1.7095E-02,1.4542E-02,2.0610E-02,2.6947E-02,
     &5.0520E-02,6.8277E-02,4.1188E-02,5.4209E-03,4.7463E-03,2.5747E-02,
     &2.2058E-02,2.5589E-02,4.5664E-02,7.6140E-02,9.7102E-02,5.5959E-02,
     &5.7296E-03,5.0218E-03,2.3801E-02,3.0343E-02,3.8012E-02,6.9885E-02,
     &1.1346E-01,1.3263E-01,8.0840E-02,5.9993E-03,9.9078E-03,3.1169E-02,
     &3.4849E-02,5.4434E-02,1.0180E-01,1.5168E-01,1.7523E-01,1.1385E-01,
     &6.2420E-03,1.8221E-02,3.8314E-02,4.8056E-02,8.0195E-02,1.4525E-01,
     &1.9539E-01,2.2499E-01,1.6255E-01/
      DATA ((KA(JS,JT, 4,14),JS=1,9),JT=1,5) /
     &1.0992E-02,9.6146E-03,8.2555E-03,1.9598E-02,2.6210E-02,2.3069E-02,
     &2.4334E-02,4.0918E-02,4.3847E-02,1.1861E-02,1.0380E-02,8.8997E-03,
     &3.1372E-02,3.1071E-02,3.3427E-02,3.7533E-02,6.6384E-02,5.4303E-02,
     &1.2630E-02,1.1058E-02,1.5158E-02,4.6362E-02,4.1015E-02,4.0980E-02,
     &5.2909E-02,1.0322E-01,7.5185E-02,1.3324E-02,1.1665E-02,2.8664E-02,
     &4.2673E-02,5.2993E-02,5.8606E-02,7.8441E-02,1.5172E-01,9.8036E-02,
     &1.3148E-02,1.1477E-02,4.1837E-02,5.5479E-02,6.7238E-02,7.8671E-02,
     &1.1999E-01,1.9993E-01,1.2716E-01/
      DATA ((KA(JS,JT, 5,14),JS=1,9),JT=1,5) /
     &2.2062E-02,1.9303E-02,1.6547E-02,1.3790E-02,1.9210E-02,3.4370E-02,
     &2.6360E-02,2.4628E-02,2.1281E-02,2.4016E-02,2.1018E-02,1.8036E-02,
     &1.5017E-02,3.4207E-02,3.8549E-02,3.6828E-02,3.7924E-02,4.8887E-02,
     &2.4307E-02,2.1199E-02,1.8170E-02,2.0814E-02,5.1440E-02,4.8654E-02,
     &5.0226E-02,5.5730E-02,8.3554E-02,2.3589E-02,2.0645E-02,1.7700E-02,
     &3.6957E-02,7.2673E-02,6.2587E-02,6.6284E-02,7.5553E-02,1.2501E-01,
     &2.3359E-02,2.0344E-02,1.7524E-02,5.3828E-02,7.8003E-02,7.9260E-02,
     &8.5892E-02,1.2047E-01,1.2633E-01/
      DATA ((KA(JS,JT, 6,14),JS=1,9),JT=1,5) /
     &4.0073E-02,3.4956E-02,2.9962E-02,2.4964E-02,1.9975E-02,1.9358E-02,
     &3.3916E-02,2.3741E-02,4.4372E-06,4.0377E-02,3.5184E-02,3.0162E-02,
     &2.5240E-02,2.0191E-02,3.6273E-02,4.6417E-02,3.4541E-02,7.2649E-06,
     &4.0665E-02,3.5540E-02,3.0502E-02,2.5425E-02,2.0338E-02,5.3239E-02,
     &5.4545E-02,5.0382E-02,1.1617E-05,4.0830E-02,3.5726E-02,3.0620E-02,
     &2.5522E-02,4.1685E-02,7.6060E-02,6.8633E-02,6.7501E-02,4.8322E-02,
     &4.0974E-02,3.5852E-02,3.0742E-02,2.5614E-02,6.3799E-02,1.0670E-01,
     &8.5712E-02,8.9786E-02,9.4019E-02/
      DATA ((KA(JS,JT, 7,14),JS=1,9),JT=1,5) /
     &3.5883E-01,3.1506E-01,2.6911E-01,2.2518E-01,1.7880E-01,1.3456E-01,
     &8.9710E-02,5.4606E-02,2.4375E-06,1.1133E-01,9.7402E-02,8.3516E-02,
     &6.9576E-02,5.5665E-02,4.1750E-02,3.4893E-02,3.9977E-02,4.2861E-06,
     &7.4556E-02,6.5240E-02,5.5921E-02,4.6603E-02,3.7275E-02,2.7967E-02,
     &5.4564E-02,5.0979E-02,7.1669E-06,7.6453E-02,6.6897E-02,5.7506E-02,
     &4.7791E-02,3.8237E-02,4.2981E-02,7.9842E-02,6.6791E-02,1.1410E-05,
     &7.6151E-02,6.6633E-02,5.7121E-02,4.7606E-02,3.8095E-02,6.8563E-02,
     &1.1205E-01,9.1020E-02,1.8778E-05/
      DATA ((KA(JS,JT, 8,14),JS=1,9),JT=1,5) /
     &1.6212E+00,1.4215E+00,1.2160E+00,1.0153E+00,8.1222E-01,6.0796E-01,
     &4.0531E-01,2.0267E-01,1.3659E-06,1.0949E+00,9.5809E-01,8.2118E-01,
     &6.8434E-01,5.4744E-01,4.1058E-01,2.7374E-01,1.3687E-01,2.5240E-06,
     &5.4276E-01,4.7782E-01,4.0969E-01,3.4354E-01,2.7305E-01,2.0349E-01,
     &1.3658E-01,8.0855E-02,4.4900E-06,1.6665E-01,1.4583E-01,1.2498E-01,
     &1.0416E-01,8.3314E-02,6.2486E-02,4.1670E-02,8.3057E-02,7.7801E-06,
     &1.6956E-01,1.4835E-01,1.2718E-01,1.0598E-01,8.5407E-02,6.3592E-02,
     &5.5348E-02,1.2090E-01,1.2725E-05/
      DATA ((KA(JS,JT, 9,14),JS=1,9),JT=1,5) /
     &1.1544E+01,1.0088E+01,8.6483E+00,7.2069E+00,5.7730E+00,4.3233E+00,
     &2.8823E+00,1.4419E+00,7.6692E-07,9.0308E+00,7.9019E+00,6.7729E+00,
     &5.6441E+00,4.5156E+00,3.3865E+00,2.2577E+00,1.1268E+00,1.4786E-06,
     &6.2830E+00,5.4975E+00,4.7120E+00,3.9269E+00,3.1414E+00,2.3561E+00,
     &1.5707E+00,7.8536E-01,2.7689E-06,3.6304E+00,3.1764E+00,2.7089E+00,
     &2.2550E+00,1.8152E+00,1.3614E+00,9.0300E-01,4.5381E-01,4.9167E-06,
     &1.4890E+00,1.3035E+00,1.1168E+00,9.3072E-01,7.4457E-01,5.5869E-01,
     &3.7227E-01,1.8616E-01,8.2396E-06/
      DATA ((KA(JS,JT,10,14),JS=1,9),JT=1,5) /
     &7.2198E+01,6.3175E+01,5.4150E+01,4.5125E+01,3.6100E+01,2.7075E+01,
     &1.8050E+01,9.0251E+00,4.5184E-07,6.4999E+01,5.6876E+01,4.8750E+01,
     &4.0625E+01,3.2499E+01,2.4375E+01,1.6250E+01,8.1250E+00,9.0060E-07,
     &5.3041E+01,4.6463E+01,3.9827E+01,3.3188E+01,2.6599E+01,1.9891E+01,
     &1.3300E+01,6.6377E+00,1.7393E-06,4.2448E+01,3.7144E+01,3.1913E+01,
     &2.6594E+01,2.1225E+01,1.5957E+01,1.0638E+01,5.3187E+00,3.1449E-06,
     &2.5727E+01,2.2511E+01,1.9295E+01,1.6144E+01,1.2810E+01,9.6477E+00,
     &6.4321E+00,3.2028E+00,5.3500E-06/
      DATA ((KA(JS,JT,11,14),JS=1,9),JT=1,5) /
     &1.4503E+02,1.2691E+02,1.0890E+02,9.0641E+01,7.2517E+01,5.4390E+01,
     &3.6259E+01,1.8129E+01,3.6866E-07,1.4340E+02,1.2547E+02,1.0755E+02,
     &8.9629E+01,7.1700E+01,5.3764E+01,3.5851E+01,1.7926E+01,7.4257E-07,
     &1.2279E+02,1.0744E+02,9.2097E+01,7.6747E+01,6.1397E+01,4.6046E+01,
     &3.0699E+01,1.5350E+01,1.4132E-06,1.0332E+02,9.0407E+01,7.7495E+01,
     &6.4577E+01,5.1661E+01,3.8673E+01,2.5832E+01,1.2916E+01,2.5660E-06,
     &8.4752E+01,7.4338E+01,6.3562E+01,5.3097E+01,4.2377E+01,3.1859E+01,
     &2.1189E+01,1.0594E+01,4.3954E-06/
      DATA ((KA(JS,JT,12,14),JS=1,9),JT=1,5) /
     &2.1206E+02,1.8578E+02,1.5923E+02,1.3269E+02,1.0615E+02,7.9613E+01,
     &5.3076E+01,2.6538E+01,2.9519E-07,2.1371E+02,1.8696E+02,1.6019E+02,
     &1.3354E+02,1.0696E+02,8.0220E+01,5.3478E+01,2.6706E+01,5.9412E-07,
     &1.9963E+02,1.7467E+02,1.4971E+02,1.2476E+02,9.9809E+01,7.4861E+01,
     &4.9906E+01,2.4953E+01,1.1512E-06,1.7291E+02,1.5155E+02,1.2989E+02,
     &1.0824E+02,8.6596E+01,6.4945E+01,4.3297E+01,2.1649E+01,2.0935E-06,
     &1.4993E+02,1.3106E+02,1.1245E+02,9.3704E+01,7.4891E+01,5.6224E+01,
     &3.7445E+01,1.8742E+01,5.3426E-06/
      DATA ((KA(JS,JT,13,14),JS=1,9),JT=1,5) /
     &2.3337E+02,2.0357E+02,1.7476E+02,1.4563E+02,1.1651E+02,8.7377E+01,
     &5.8250E+01,2.9126E+01,2.3044E-07,2.3770E+02,2.0799E+02,1.7827E+02,
     &1.4856E+02,1.1885E+02,8.9136E+01,5.9426E+01,2.9711E+01,4.7533E-07,
     &2.3937E+02,2.0945E+02,1.7953E+02,1.4961E+02,1.1968E+02,8.9763E+01,
     &5.9841E+01,2.9920E+01,1.2740E-06,2.1343E+02,1.8675E+02,1.6007E+02,
     &1.3339E+02,1.0671E+02,8.0033E+01,5.3356E+01,2.6677E+01,3.7441E-06,
     &1.8434E+02,1.6130E+02,1.3825E+02,1.1521E+02,9.2167E+01,6.9126E+01,
     &4.6084E+01,2.3083E+01,8.0408E-06/
      DATA ((KA(JS,JT, 1,15),JS=1,9),JT=1,5) /
     &4.3757E-04,1.7661E-02,6.5219E-02,9.6736E-02,1.2696E-01,1.5472E-01,
     &1.7677E-01,1.8124E-01,2.5391E-01,4.7244E-04,2.2315E-02,8.7744E-02,
     &1.3008E-01,1.7055E-01,2.0764E-01,2.3757E-01,2.4446E-01,3.4110E-01,
     &4.9936E-04,3.5467E-02,1.1452E-01,1.6964E-01,2.2220E-01,2.7019E-01,
     &3.0873E-01,3.1867E-01,4.4441E-01,5.2088E-04,5.0547E-02,1.4538E-01,
     &2.1535E-01,2.8212E-01,3.4264E-01,3.9053E-01,4.0360E-01,5.6424E-01,
     &5.3484E-04,7.2405E-02,1.8030E-01,2.6712E-01,3.4967E-01,4.2472E-01,
     &4.8331E-01,4.9868E-01,6.9933E-01/
      DATA ((KA(JS,JT, 2,15),JS=1,9),JT=1,5) /
     &5.8930E-04,5.2056E-04,3.8823E-02,9.4547E-02,1.2473E-01,1.5329E-01,
     &1.7814E-01,1.9186E-01,2.4946E-01,6.3170E-04,5.6011E-04,6.0488E-02,
     &1.2953E-01,1.7093E-01,2.0982E-01,2.4359E-01,2.6142E-01,3.4185E-01,
     &6.6396E-04,1.3947E-02,9.3321E-02,1.7148E-01,2.2617E-01,2.7768E-01,
     &3.2205E-01,3.4444E-01,4.5233E-01,6.8779E-04,3.2900E-02,1.4029E-01,
     &2.2027E-01,2.9047E-01,3.5662E-01,4.1356E-01,4.4128E-01,5.8094E-01,
     &7.0403E-04,3.1909E-02,1.8526E-01,2.7582E-01,3.6375E-01,4.4666E-01,
     &5.1781E-01,5.5205E-01,7.2748E-01/
      DATA ((KA(JS,JT, 3,15),JS=1,9),JT=1,5) /
     &1.0314E-03,9.3537E-04,7.8009E-04,3.5190E-02,7.8660E-02,1.3993E-01,
     &1.6539E-01,1.8481E-01,1.5700E-01,1.1044E-03,9.7099E-04,3.0472E-03,
     &6.2470E-02,1.3066E-01,1.9656E-01,2.3229E-01,2.5938E-01,2.6190E-01,
     &1.1610E-03,1.0227E-03,3.8685E-02,9.5707E-02,2.0189E-01,2.6560E-01,
     &3.1379E-01,3.5039E-01,4.0559E-01,1.1999E-03,1.0620E-03,6.9192E-02,
     &1.4962E-01,2.7976E-01,3.4701E-01,4.1016E-01,4.5806E-01,5.5953E-01,
     &1.2331E-03,1.0899E-03,6.4034E-02,2.1379E-01,3.5531E-01,4.4075E-01,
     &5.2094E-01,5.8205E-01,7.1061E-01/
      DATA ((KA(JS,JT, 4,15),JS=1,9),JT=1,5) /
     &1.8101E-03,1.5857E-03,1.3614E-03,1.1362E-03,2.5114E-02,5.7242E-02,
     &1.1151E-01,1.6445E-01,5.0940E-02,1.9417E-03,1.7009E-03,1.4618E-03,
     &1.2222E-03,6.6639E-02,9.6622E-02,1.8463E-01,2.3787E-01,1.3472E-01,
     &2.0504E-03,1.7934E-03,1.5465E-03,1.2907E-03,6.6457E-02,1.6526E-01,
     &2.8062E-01,3.2903E-01,1.3147E-01,2.1280E-03,1.8660E-03,1.6076E-03,
     &5.7880E-02,1.0798E-01,2.4822E-01,3.8266E-01,4.3856E-01,2.1657E-01,
     &3.4223E-03,3.1028E-03,2.6690E-03,1.0905E-01,1.5760E-01,3.4585E-01,
     &4.9399E-01,5.6645E-01,3.1389E-01/
      DATA ((KA(JS,JT, 5,15),JS=1,9),JT=1,5) /
     &2.8907E-03,2.5398E-03,2.1780E-03,1.8164E-03,1.4541E-03,1.0940E-03,
     &7.0483E-02,1.0515E-01,9.1867E-06,3.1254E-03,2.7393E-03,2.3477E-03,
     &1.9606E-03,1.5698E-03,3.9518E-02,7.4031E-02,1.7523E-01,1.5406E-05,
     &6.7235E-03,5.8882E-03,5.0497E-03,4.2126E-03,3.3747E-03,9.4974E-02,
     &1.2240E-01,2.6835E-01,2.4302E-05,1.0699E-02,9.3645E-03,8.0383E-03,
     &6.6993E-03,5.3674E-03,1.6163E-01,2.1236E-01,3.9941E-01,3.6217E-05,
     &1.3717E-02,1.2003E-02,1.0303E-02,8.5901E-03,7.6360E-02,1.2908E-01,
     &3.1926E-01,5.2644E-01,1.7649E-01/
      DATA ((KA(JS,JT, 6,15),JS=1,9),JT=1,5) /
     &8.1592E-03,7.4369E-03,6.3758E-03,5.3146E-03,4.2520E-03,3.1909E-03,
     &2.1298E-03,5.0122E-02,5.2510E-06,1.6119E-02,1.4482E-02,1.2421E-02,
     &1.0082E-02,8.0668E-03,6.0513E-03,2.1472E-02,7.5343E-02,9.3553E-06,
     &2.2594E-02,1.9767E-02,1.6948E-02,1.4132E-02,1.1307E-02,8.4832E-03,
     &8.7408E-02,1.3678E-01,1.5081E-05,2.8287E-02,2.4765E-02,2.1227E-02,
     &1.7693E-02,1.4154E-02,1.0619E-02,1.5774E-01,2.2631E-01,2.2824E-05,
     &3.3007E-02,2.8867E-02,2.4778E-02,2.0634E-02,1.6523E-02,1.2392E-02,
     &2.0991E-01,3.3594E-01,3.3161E-05/
      DATA ((KA(JS,JT, 7,15),JS=1,9),JT=1,5) /
     &3.2923E-02,2.8801E-02,2.4671E-02,2.0232E-02,1.6462E-02,1.2339E-02,
     &8.2302E-03,4.1175E-03,2.9069E-06,4.4354E-02,3.8819E-02,3.3267E-02,
     &2.7723E-02,2.2187E-02,1.6641E-02,1.1094E-02,4.4470E-02,5.3667E-06,
     &5.4986E-02,4.8115E-02,4.1243E-02,3.4364E-02,2.7498E-02,2.0642E-02,
     &1.3901E-02,1.0510E-01,9.1519E-06,6.4798E-02,5.6696E-02,4.8186E-02,
     &4.0508E-02,3.2405E-02,2.4095E-02,1.6208E-02,1.7836E-01,1.4620E-05,
     &7.2855E-02,6.3755E-02,5.4641E-02,4.5546E-02,3.6442E-02,2.7544E-02,
     &1.8370E-02,1.8524E-01,2.2125E-05/
      DATA ((KA(JS,JT, 8,15),JS=1,9),JT=1,5) /
     &9.4104E-02,8.2337E-02,7.0574E-02,5.8796E-02,4.7043E-02,3.5284E-02,
     &2.3531E-02,1.1762E-02,1.5730E-06,1.1684E-01,1.0226E-01,8.7581E-02,
     &7.3021E-02,5.8384E-02,4.3796E-02,2.9205E-02,1.4602E-02,3.1057E-06,
     &1.3899E-01,1.2165E-01,1.0424E-01,8.6874E-02,6.9512E-02,5.2129E-02,
     &3.4755E-02,1.7377E-02,5.5778E-06,1.6026E-01,1.4023E-01,1.2021E-01,
     &1.0019E-01,8.0158E-02,6.0094E-02,4.0057E-02,2.0043E-02,9.3711E-06,
     &1.7464E-01,1.5283E-01,1.3102E-01,1.0918E-01,8.7353E-02,6.5505E-02,
     &4.3670E-02,2.1848E-02,1.4780E-05/
      DATA ((KA(JS,JT, 9,15),JS=1,9),JT=1,5) /
     &4.3914E-01,3.8426E-01,3.2523E-01,2.7101E-01,2.1679E-01,1.6466E-01,
     &1.0980E-01,5.4190E-02,8.3394E-07,5.3157E-01,4.6496E-01,3.9866E-01,
     &3.3222E-01,2.6580E-01,1.9932E-01,1.3289E-01,6.6437E-02,1.7793E-06,
     &6.2792E-01,5.4930E-01,4.7092E-01,3.9242E-01,3.1384E-01,2.3543E-01,
     &1.5698E-01,7.8487E-02,3.4095E-06,6.9612E-01,6.0916E-01,5.2207E-01,
     &4.4160E-01,3.4808E-01,2.6107E-01,1.7405E-01,8.7030E-02,6.0449E-06,
     &7.1518E-01,6.2568E-01,5.3633E-01,4.4688E-01,3.5754E-01,2.6806E-01,
     &1.7876E-01,8.9378E-02,9.9175E-06/
      DATA ((KA(JS,JT,10,15),JS=1,9),JT=1,5) /
     &1.3796E+01,1.2071E+01,1.0346E+01,8.6223E+00,6.8983E+00,5.1733E+00,
     &3.4490E+00,1.7245E+00,4.7027E-07,2.6233E+00,2.2954E+00,1.9673E+00,
     &1.6395E+00,1.3116E+00,9.8356E-01,6.5573E-01,3.2783E-01,1.0735E-06,
     &2.9028E+00,2.5398E+00,2.1774E+00,1.8145E+00,1.4515E+00,1.0885E+00,
     &7.2570E-01,3.6294E-01,2.1946E-06,2.9628E+00,2.5919E+00,2.2220E+00,
     &1.8518E+00,1.4813E+00,1.1109E+00,7.4065E-01,3.7038E-01,4.0439E-06,
     &3.0421E+00,2.6615E+00,2.2818E+00,1.9012E+00,1.5210E+00,1.1408E+00,
     &7.6043E-01,3.8023E-01,6.8742E-06/
      DATA ((KA(JS,JT,11,15),JS=1,9),JT=1,5) /
     &5.1563E+01,4.5117E+01,3.8674E+01,3.2227E+01,2.5782E+01,1.9336E+01,
     &1.2891E+01,6.4453E+00,4.0707E-07,4.0297E+00,3.5262E+00,3.0227E+00,
     &2.5187E+00,2.0150E+00,1.5474E+00,1.0073E+00,5.0377E-01,9.5505E-07,
     &4.2638E+00,3.7317E+00,3.1981E+00,2.6654E+00,2.1321E+00,1.5993E+00,
     &1.0662E+00,5.3312E-01,1.9370E-06,4.5225E+00,3.9566E+00,3.3892E+00,
     &2.8266E+00,2.2603E+00,1.6955E+00,1.1303E+00,5.6504E-01,3.5823E-06,
     &4.7336E+00,4.1418E+00,3.5502E+00,2.9582E+00,2.3669E+00,1.7755E+00,
     &1.1834E+00,5.9176E-01,6.1298E-06/
      DATA ((KA(JS,JT,12,15),JS=1,9),JT=1,5) /
     &1.0350E+02,9.0564E+01,7.7625E+01,6.4688E+01,5.1750E+01,3.8814E+01,
     &2.5874E+01,1.2937E+01,3.8485E-07,3.5400E+01,3.0974E+01,2.7218E+01,
     &2.2126E+01,1.7700E+01,1.3275E+01,8.8500E+00,4.4247E+00,8.6295E-07,
     &4.7917E+00,4.1902E+00,3.5927E+00,2.9945E+00,2.3939E+00,1.7963E+00,
     &1.1970E+00,5.9908E-01,1.7414E-06,4.7749E+00,4.1779E+00,3.5811E+00,
     &2.9844E+00,2.3876E+00,1.7905E+00,1.1938E+00,5.9689E-01,3.1576E-06,
     &4.7755E+00,4.1774E+00,3.5815E+00,2.9845E+00,2.3876E+00,1.7910E+00,
     &1.1938E+00,5.9711E-01,5.4455E-06/
      DATA ((KA(JS,JT,13,15),JS=1,9),JT=1,5) /
     &1.3564E+02,1.2035E+02,1.0244E+02,8.5373E+01,6.8293E+01,5.1221E+01,
     &3.4147E+01,1.7074E+01,3.5301E-07,6.6923E+01,5.8556E+01,5.0190E+01,
     &4.1824E+01,3.3458E+01,2.5094E+01,1.6730E+01,8.3652E+00,7.8175E-07,
     &3.7003E+00,3.2381E+00,2.7755E+00,2.3126E+00,1.8500E+00,1.3876E+00,
     &9.2513E-01,4.6258E-01,1.5659E-06,3.7328E+00,3.2655E+00,2.7985E+00,
     &2.3334E+00,1.8661E+00,1.3995E+00,9.3310E-01,4.6647E-01,2.9454E-06,
     &3.7209E+00,3.2581E+00,2.7929E+00,2.3278E+00,1.8618E+00,1.3966E+00,
     &9.3071E-01,4.6580E-01,5.0591E-06/
      DATA ((KA(JS,JT, 1,16),JS=1,9),JT=1,5) /
     &3.4803E-04,3.1375E-04,9.0029E-02,1.3230E-01,1.7123E-01,2.0432E-01,
     &2.2540E-01,2.1561E-01,3.4246E-01,3.6711E-04,6.2185E-02,1.2251E-01,
     &1.8007E-01,2.3310E-01,2.7812E-01,3.0698E-01,2.9374E-01,4.6619E-01,
     &3.8231E-04,8.1789E-02,1.6116E-01,2.3685E-01,3.0661E-01,3.6587E-01,
     &4.0384E-01,3.8690E-01,6.1322E-01,3.9398E-04,1.0451E-01,2.0587E-01,
     &3.0259E-01,3.9179E-01,4.6767E-01,5.1634E-01,4.9462E-01,7.8358E-01,
     &4.0251E-04,1.3022E-01,2.5663E-01,3.7711E-01,4.8832E-01,5.8296E-01,
     &6.4377E-01,6.1717E-01,9.7664E-01/
      DATA ((KA(JS,JT, 2,16),JS=1,9),JT=1,5) /
     &4.4386E-04,3.9528E-04,9.5606E-02,1.4144E-01,1.8490E-01,2.2388E-01,
     &2.5317E-01,2.5424E-01,3.6979E-01,4.6963E-04,4.2143E-04,1.3208E-01,
     &1.9543E-01,2.5549E-01,3.0939E-01,3.5000E-01,3.5157E-01,5.1097E-01,
     &4.9052E-04,4.4450E-04,1.7597E-01,2.6040E-01,3.4044E-01,4.1226E-01,
     &4.6651E-01,4.6873E-01,6.8087E-01,5.0548E-04,4.6448E-04,2.2723E-01,
     &3.3632E-01,4.3972E-01,5.3255E-01,6.0266E-01,6.0594E-01,8.7943E-01,
     &5.1704E-04,1.4434E-01,2.8579E-01,4.2309E-01,5.5324E-01,6.7011E-01,
     &7.5842E-01,7.6291E-01,1.1065E+00/
      DATA ((KA(JS,JT, 3,16),JS=1,9),JT=1,5) /
     &7.4514E-04,6.5703E-04,5.6805E-04,1.3986E-01,1.8472E-01,2.2721E-01,
     &2.6439E-01,2.8334E-01,3.6943E-01,7.9344E-04,7.0163E-04,6.1002E-04,
     &1.9810E-01,2.6159E-01,3.2183E-01,3.7436E-01,4.0145E-01,5.2319E-01,
     &8.3288E-04,7.4056E-04,6.4608E-04,2.6931E-01,3.5570E-01,4.3753E-01,
     &5.0928E-01,5.4624E-01,7.1140E-01,8.6418E-04,7.7079E-04,1.2130E-02,
     &3.5401E-01,4.6743E-01,5.7518E-01,6.6923E-01,7.1819E-01,9.3487E-01,
     &8.8628E-04,7.9797E-04,3.0313E-01,4.5187E-01,5.9661E-01,7.3417E-01,
     &8.5463E-01,9.1729E-01,1.1932E+00/
      DATA ((KA(JS,JT, 4,16),JS=1,9),JT=1,5) /
     &1.2636E-03,1.1057E-03,9.5136E-04,7.9620E-04,6.4188E-04,2.1791E-01,
     &2.5758E-01,2.8791E-01,2.3364E-05,1.3610E-03,1.1957E-03,1.0270E-03,
     &8.6413E-04,7.0025E-04,3.1776E-01,3.7570E-01,4.1991E-01,3.8771E-05,
     &1.4417E-03,1.2662E-03,1.0946E-03,9.2411E-04,3.5694E-01,4.4267E-01,
     &5.2346E-01,5.8520E-01,7.1388E-01,1.5012E-03,1.3268E-03,1.1484E-03,
     &9.7089E-04,4.7866E-01,5.9391E-01,7.0229E-01,7.8545E-01,9.5731E-01,
     &1.5493E-03,1.3712E-03,1.1941E-03,1.0165E-03,6.2163E-01,7.7110E-01,
     &9.1212E-01,1.0202E+00,1.2432E+00/
      DATA ((KA(JS,JT, 5,16),JS=1,9),JT=1,5) /
     &1.9563E-03,1.7130E-03,1.4716E-03,1.2286E-03,9.8449E-04,7.4210E-04,
     &5.0011E-04,2.7578E-01,1.4521E-05,2.1251E-03,1.8616E-03,1.5991E-03,
     &1.3382E-03,1.0747E-03,8.1191E-04,3.6392E-01,4.1523E-01,2.5317E-05,
     &2.2685E-03,1.9902E-03,1.7118E-03,1.4319E-03,1.1550E-03,8.7607E-04,
     &5.2057E-01,5.9412E-01,4.1189E-05,2.3834E-03,2.0939E-03,1.8039E-03,
     &1.5145E-03,1.2237E-03,9.3428E-04,7.1378E-01,8.1462E-01,6.3394E-05,
     &2.4764E-03,2.1786E-03,1.8819E-03,1.5832E-03,1.2860E-03,7.9256E-01,
     &9.4410E-01,1.0778E+00,9.2980E-05/
      DATA ((KA(JS,JT, 6,16),JS=1,9),JT=1,5) /
     &2.8061E-03,2.4583E-03,2.1085E-03,1.7622E-03,1.4067E-03,1.0576E-03,
     &7.0829E-04,1.6992E-01,8.6758E-06,3.0921E-03,2.7056E-03,2.3212E-03,
     &1.9356E-03,1.5529E-03,1.1677E-03,7.8418E-04,3.9086E-01,1.5977E-05,
     &3.3322E-03,2.9180E-03,2.5057E-03,2.0938E-03,1.6795E-03,1.2657E-03,
     &8.5374E-04,5.7620E-01,2.7234E-05,3.5394E-03,3.0979E-03,2.6608E-03,
     &2.2263E-03,1.7897E-03,1.3517E-03,9.1571E-04,8.0997E-01,4.3592E-05,
     &3.6973E-03,3.2450E-03,2.7879E-03,2.3342E-03,1.8813E-03,1.4280E-03,
     &2.3591E-01,1.0936E+00,6.6108E-05/
      DATA ((KA(JS,JT, 7,16),JS=1,9),JT=1,5) /
     &4.1566E-03,3.6382E-03,3.1187E-03,2.5984E-03,2.0809E-03,1.5620E-03,
     &1.0430E-03,5.2415E-04,5.0515E-06,4.6397E-03,4.0602E-03,3.4821E-03,
     &2.9026E-03,2.3244E-03,1.7452E-03,1.1674E-03,5.8830E-04,9.8982E-06,
     &5.0641E-03,4.4282E-03,3.8004E-03,3.1687E-03,2.5412E-03,1.9080E-03,
     &1.2777E-03,6.4842E-04,1.7758E-05,5.4224E-03,4.7462E-03,4.0771E-03,
     &3.3992E-03,2.7272E-03,2.0505E-03,1.3779E-03,7.0354E-04,2.9670E-05,
     &5.7229E-03,5.0101E-03,4.3011E-03,3.5983E-03,2.8833E-03,2.1757E-03,
     &1.4658E-03,6.1847E-01,4.6639E-05/
      DATA ((KA(JS,JT, 8,16),JS=1,9),JT=1,5) /
     &7.1654E-03,6.2688E-03,5.3745E-03,4.4778E-03,3.5800E-03,2.6883E-03,
     &1.7931E-03,8.9706E-04,2.8888E-06,8.1399E-03,7.1118E-03,6.0997E-03,
     &5.0831E-03,4.0665E-03,3.0517E-03,2.0386E-03,1.0214E-03,6.0412E-06,
     &8.9800E-03,7.8609E-03,6.7393E-03,5.6216E-03,4.4978E-03,3.3745E-03,
     &2.2551E-03,1.1328E-03,1.1454E-05,9.7139E-03,8.5067E-03,7.2942E-03,
     &6.0777E-03,4.8682E-03,3.6593E-03,2.4437E-03,1.2326E-03,2.0029E-05,
     &1.0337E-02,9.0473E-03,7.7560E-03,6.4703E-03,5.1860E-03,3.8948E-03,
     &2.6072E-03,1.3207E-03,3.2759E-05/
      DATA ((KA(JS,JT, 9,16),JS=1,9),JT=1,5) /
     &2.3247E-02,2.0336E-02,1.7429E-02,1.4524E-02,1.1625E-02,8.7188E-03,
     &5.8147E-03,2.9059E-03,1.6015E-06,2.6840E-02,2.3482E-02,2.0132E-02,
     &1.6770E-02,1.3422E-02,1.0063E-02,6.7117E-03,3.3577E-03,3.6050E-06,
     &3.0078E-02,2.6329E-02,2.2553E-02,1.8793E-02,1.5044E-02,1.1280E-02,
     &7.5240E-03,3.7656E-03,7.2546E-06,3.2925E-02,2.8810E-02,2.4697E-02,
     &2.0586E-02,3.0583E-02,1.2361E-02,8.2421E-03,4.1354E-03,1.3329E-05,
     &3.5342E-02,3.0934E-02,2.6503E-02,2.2104E-02,1.7684E-02,1.3262E-02,
     &8.8536E-03,4.4397E-03,2.2693E-05/
      DATA ((KA(JS,JT,10,16),JS=1,9),JT=1,5) /
     &8.4703E-02,7.4117E-02,6.3535E-02,5.2927E-02,4.2343E-02,3.1773E-02,
     &2.1175E-02,1.0588E-02,9.2688E-07,9.9410E-02,8.7009E-02,7.4556E-02,
     &6.2160E-02,4.9698E-02,3.7265E-02,2.4850E-02,1.2429E-02,2.2335E-06,
     &1.1291E-01,9.8729E-02,8.4692E-02,7.0598E-02,5.6422E-02,4.2355E-02,
     &2.8232E-02,1.4106E-02,4.7476E-06,1.2498E-01,1.0930E-01,9.3695E-02,
     &7.8057E-02,6.2479E-02,4.6859E-02,3.1244E-02,1.5627E-02,9.1259E-06,
     &1.3523E-01,1.1838E-01,1.0149E-01,8.4512E-02,6.7619E-02,5.0737E-02,
     &3.3842E-02,1.6917E-02,1.6155E-05/
      DATA ((KA(JS,JT,11,16),JS=1,9),JT=1,5) /
     &1.1702E-01,1.0242E-01,8.7781E-02,7.3100E-02,5.8528E-02,4.3847E-02,
     &2.9250E-02,1.4631E-02,8.3202E-07,1.3733E-01,1.2017E-01,1.0300E-01,
     &8.5853E-02,6.8653E-02,5.1492E-02,3.4322E-02,1.7153E-02,2.0128E-06,
     &1.5584E-01,1.3638E-01,1.1685E-01,9.7461E-02,7.7843E-02,5.8372E-02,
     &3.8976E-02,1.9510E-02,4.3129E-06,1.7239E-01,1.5086E-01,1.2928E-01,
     &1.0779E-01,8.6176E-02,6.4725E-02,4.3097E-02,2.1516E-02,8.3117E-06,
     &1.8654E-01,1.6325E-01,1.3989E-01,1.1667E-01,9.3408E-02,7.0060E-02,
     &4.6775E-02,2.3342E-02,1.4729E-05/
      DATA ((KA(JS,JT,12,16),JS=1,9),JT=1,5) /
     &1.1854E-01,1.0376E-01,8.8946E-02,7.4074E-02,5.9255E-02,4.4504E-02,
     &2.9679E-02,1.4800E-02,7.4749E-07,1.3943E-01,1.2204E-01,1.0463E-01,
     &8.7342E-02,6.9856E-02,5.2356E-02,3.4894E-02,1.7410E-02,1.8161E-06,
     &1.5836E-01,1.3868E-01,1.1885E-01,9.9001E-02,7.9338E-02,5.9413E-02,
     &3.9707E-02,1.9806E-02,3.8901E-06,1.7966E-01,1.5728E-01,1.3478E-01,
     &1.1217E-01,8.9784E-02,6.7270E-02,4.4900E-02,2.2432E-02,7.2752E-06,
     &2.0635E-01,1.8060E-01,1.5479E-01,1.2891E-01,1.0321E-01,7.7324E-02,
     &5.1591E-02,2.5791E-02,1.2040E-05/
      DATA ((KA(JS,JT,13,16),JS=1,9),JT=1,5) /
     &2.1930E-01,8.1271E-02,6.9650E-02,5.7973E-02,4.6358E-02,3.4782E-02,
     &2.3204E-02,1.1588E-02,6.6806E-07,1.1205E-01,9.8083E-02,8.4056E-02,
     &7.0107E-02,5.6050E-02,4.2050E-02,2.7998E-02,1.4011E-02,1.5755E-06,
     &1.3646E-01,1.1932E-01,1.0236E-01,8.5263E-02,6.8236E-02,5.1131E-02,
     &3.4091E-02,1.7065E-02,3.1454E-06,1.5976E-01,1.3979E-01,1.1981E-01,
     &9.9935E-02,7.9931E-02,5.9857E-02,3.9898E-02,1.9961E-02,5.5256E-06,
     &1.7769E-01,1.5548E-01,1.3326E-01,1.1109E-01,8.8840E-02,6.6629E-02,
     &4.4447E-02,2.2232E-02,9.1943E-06/

C     The array KA_Mxx contains the absorption coefficient for 
C     a minor species at the 16 chosen g-values for a reference pressure
C     level below 100~ mb.   The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.  The second index refers to temperature 
C     in 7.2 degree increments.  For instance, JT = 1 refers to a 
C     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
C     runs over the g-channel (1 to 16).

      DATA (KA_MCO2( 1,JT, 1),JT=1,19)  /
     & 1.09539e-04, 1.17067e-04, 1.25113e-04, 1.33712e-04, 1.42902e-04,
     & 1.52724e-04, 1.63221e-04, 1.74439e-04, 1.86428e-04, 1.99241e-04,
     & 2.12934e-04, 2.27569e-04, 2.43210e-04, 2.59926e-04, 2.77790e-04,
     & 2.96883e-04, 3.17287e-04, 3.39094e-04, 3.62400e-04/
      DATA (KA_MCO2( 2,JT, 1),JT=1,19)  /
     & 1.25202e-04, 1.34718e-04, 1.44957e-04, 1.55974e-04, 1.67829e-04,
     & 1.80585e-04, 1.94311e-04, 2.09079e-04, 2.24971e-04, 2.42069e-04,
     & 2.60468e-04, 2.80265e-04, 3.01567e-04, 3.24488e-04, 3.49150e-04,
     & 3.75688e-04, 4.04242e-04, 4.34966e-04, 4.68026e-04/
      DATA (KA_MCO2( 3,JT, 1),JT=1,19)  /
     & 1.12112e-04, 1.21090e-04, 1.30786e-04, 1.41259e-04, 1.52571e-04,
     & 1.64788e-04, 1.77984e-04, 1.92237e-04, 2.07631e-04, 2.24257e-04,
     & 2.42215e-04, 2.61611e-04, 2.82560e-04, 3.05187e-04, 3.29625e-04,
     & 3.56021e-04, 3.84530e-04, 4.15322e-04, 4.48580e-04/
      DATA (KA_MCO2( 4,JT, 1),JT=1,19)  /
     & 9.74130e-05, 1.05372e-04, 1.13982e-04, 1.23295e-04, 1.33369e-04,
     & 1.44265e-04, 1.56053e-04, 1.68803e-04, 1.82595e-04, 1.97514e-04,
     & 2.13652e-04, 2.31109e-04, 2.49992e-04, 2.70418e-04, 2.92512e-04,
     & 3.16412e-04, 3.42265e-04, 3.70230e-04, 4.00479e-04/
      DATA (KA_MCO2( 5,JT, 1),JT=1,19)  /
     & 8.71018e-05, 9.40759e-05, 1.01608e-04, 1.09744e-04, 1.18531e-04,
     & 1.28022e-04, 1.38272e-04, 1.49343e-04, 1.61301e-04, 1.74216e-04,
     & 1.88166e-04, 2.03232e-04, 2.19504e-04, 2.37079e-04, 2.56062e-04,
     & 2.76565e-04, 2.98709e-04, 3.22626e-04, 3.48458e-04/
      DATA (KA_MCO2( 6,JT, 1),JT=1,19)  /
     & 7.55256e-05, 8.17414e-05, 8.84688e-05, 9.57500e-05, 1.03630e-04,
     & 1.12159e-04, 1.21390e-04, 1.31381e-04, 1.42193e-04, 1.53896e-04,
     & 1.66562e-04, 1.80270e-04, 1.95107e-04, 2.11164e-04, 2.28543e-04,
     & 2.47353e-04, 2.67710e-04, 2.89743e-04, 3.13589e-04/
      DATA (KA_MCO2( 7,JT, 1),JT=1,19)  /
     & 5.31515e-05, 6.06869e-05, 6.92907e-05, 7.91143e-05, 9.03306e-05,
     & 1.03137e-04, 1.17759e-04, 1.34454e-04, 1.53516e-04, 1.75281e-04,
     & 2.00131e-04, 2.28504e-04, 2.60900e-04, 2.97888e-04, 3.40121e-04,
     & 3.88341e-04, 4.43397e-04, 5.06259e-04, 5.78033e-04/
      DATA (KA_MCO2( 8,JT, 1),JT=1,19)  /
     & 2.52471e-04, 2.96005e-04, 3.47045e-04, 4.06886e-04, 4.77045e-04,
     & 5.59302e-04, 6.55742e-04, 7.68811e-04, 9.01377e-04, 1.05680e-03,
     & 1.23902e-03, 1.45267e-03, 1.70315e-03, 1.99683e-03, 2.34114e-03,
     & 2.74482e-03, 3.21811e-03, 3.77300e-03, 4.42358e-03/
      DATA (KA_MCO2( 9,JT, 1),JT=1,19)  /
     & 4.06711e-05, 4.53161e-05, 5.04917e-05, 5.62583e-05, 6.26836e-05,
     & 6.98427e-05, 7.78194e-05, 8.67071e-05, 9.66100e-05, 1.07644e-04,
     & 1.19938e-04, 1.33636e-04, 1.48898e-04, 1.65904e-04, 1.84852e-04,
     & 2.05964e-04, 2.29487e-04, 2.55697e-04, 2.84900e-04/
      DATA (KA_MCO2( 1,JT, 2),JT=1,19)  /
     & 2.01759e-04, 2.15641e-04, 2.30478e-04, 2.46336e-04, 2.63285e-04,
     & 2.81400e-04, 3.00761e-04, 3.21455e-04, 3.43573e-04, 3.67212e-04,
     & 3.92477e-04, 4.19482e-04, 4.48344e-04, 4.79192e-04, 5.12162e-04,
     & 5.47401e-04, 5.85064e-04, 6.25319e-04, 6.68343e-04/
      DATA (KA_MCO2( 2,JT, 2),JT=1,19)  /
     & 2.53461e-04, 2.70916e-04, 2.89574e-04, 3.09516e-04, 3.30832e-04,
     & 3.53616e-04, 3.77969e-04, 4.03999e-04, 4.31822e-04, 4.61561e-04,
     & 4.93348e-04, 5.27324e-04, 5.63640e-04, 6.02457e-04, 6.43948e-04,
     & 6.88295e-04, 7.35697e-04, 7.86364e-04, 8.40519e-04/
      DATA (KA_MCO2( 3,JT, 2),JT=1,19)  /
     & 2.58821e-04, 2.76943e-04, 2.96334e-04, 3.17082e-04, 3.39283e-04,
     & 3.63038e-04, 3.88457e-04, 4.15655e-04, 4.44758e-04, 4.75899e-04,
     & 5.09220e-04, 5.44874e-04, 5.83024e-04, 6.23845e-04, 6.67525e-04,
     & 7.14263e-04, 7.64273e-04, 8.17785e-04, 8.75043e-04/
      DATA (KA_MCO2( 4,JT, 2),JT=1,19)  /
     & 2.46588e-04, 2.64630e-04, 2.83993e-04, 3.04771e-04, 3.27071e-04,
     & 3.51001e-04, 3.76683e-04, 4.04244e-04, 4.33821e-04, 4.65563e-04,
     & 4.99627e-04, 5.36183e-04, 5.75414e-04, 6.17515e-04, 6.62697e-04,
     & 7.11185e-04, 7.63220e-04, 8.19063e-04, 8.78991e-04/
      DATA (KA_MCO2( 5,JT, 2),JT=1,19)  /
     & 2.19140e-04, 2.36464e-04, 2.55158e-04, 2.75330e-04, 2.97097e-04,
     & 3.20585e-04, 3.45929e-04, 3.73277e-04, 4.02787e-04, 4.34630e-04,
     & 4.68991e-04, 5.06068e-04, 5.46076e-04, 5.89247e-04, 6.35831e-04,
     & 6.86097e-04, 7.40338e-04, 7.98867e-04, 8.62022e-04/
      DATA (KA_MCO2( 6,JT, 2),JT=1,19)  /
     & 1.74073e-04, 1.92221e-04, 2.12260e-04, 2.34388e-04, 2.58824e-04,
     & 2.85807e-04, 3.15603e-04, 3.48505e-04, 3.84837e-04, 4.24957e-04,
     & 4.69260e-04, 5.18181e-04, 5.72202e-04, 6.31855e-04, 6.97727e-04,
     & 7.70466e-04, 8.50789e-04, 9.39485e-04, 1.03743e-03/
      DATA (KA_MCO2( 7,JT, 2),JT=1,19)  /
     & 1.74359e-04, 1.99276e-04, 2.27753e-04, 2.60299e-04, 2.97497e-04,
     & 3.40010e-04, 3.88599e-04, 4.44130e-04, 5.07598e-04, 5.80135e-04,
     & 6.63039e-04, 7.57789e-04, 8.66079e-04, 9.89845e-04, 1.13130e-03,
     & 1.29296e-03, 1.47773e-03, 1.68890e-03, 1.93025e-03/
      DATA (KA_MCO2( 8,JT, 2),JT=1,19)  /
     & 1.08215e-03, 1.20760e-03, 1.34759e-03, 1.50382e-03, 1.67815e-03,
     & 1.87270e-03, 2.08980e-03, 2.33206e-03, 2.60242e-03, 2.90411e-03,
     & 3.24078e-03, 3.61648e-03, 4.03573e-03, 4.50359e-03, 5.02568e-03,
     & 5.60830e-03, 6.25846e-03, 6.98399e-03, 7.79363e-03/
      DATA (KA_MCO2( 9,JT, 2),JT=1,19)  /
     & 1.04969e-04, 1.20766e-04, 1.38939e-04, 1.59848e-04, 1.83903e-04,
     & 2.11578e-04, 2.43418e-04, 2.80049e-04, 3.22193e-04, 3.70678e-04,
     & 4.26461e-04, 4.90638e-04, 5.64472e-04, 6.49418e-04, 7.47147e-04,
     & 8.59583e-04, 9.88940e-04, 1.13776e-03, 1.30898e-03/
      DATA (KA_MCO2( 1,JT, 3),JT=1,19)  /
     & 3.72106e-04, 3.96252e-04, 4.21966e-04, 4.49347e-04, 4.78506e-04,
     & 5.09557e-04, 5.42623e-04, 5.77834e-04, 6.15330e-04, 6.55260e-04,
     & 6.97781e-04, 7.43060e-04, 7.91278e-04, 8.42626e-04, 8.97304e-04,
     & 9.55532e-04, 1.01754e-03, 1.08357e-03, 1.15388e-03/
      DATA (KA_MCO2( 2,JT, 3),JT=1,19)  /
     & 4.20563e-04, 4.46162e-04, 4.73319e-04, 5.02130e-04, 5.32693e-04,
     & 5.65118e-04, 5.99516e-04, 6.36007e-04, 6.74720e-04, 7.15789e-04,
     & 7.59358e-04, 8.05579e-04, 8.54613e-04, 9.06632e-04, 9.61817e-04,
     & 1.02036e-03, 1.08247e-03, 1.14836e-03, 1.21826e-03/
      DATA (KA_MCO2( 3,JT, 3),JT=1,19)  /
     & 4.89664e-04, 5.18321e-04, 5.48654e-04, 5.80764e-04, 6.14752e-04,
     & 6.50729e-04, 6.88812e-04, 7.29124e-04, 7.71795e-04, 8.16963e-04,
     & 8.64774e-04, 9.15384e-04, 9.68955e-04, 1.02566e-03, 1.08569e-03,
     & 1.14922e-03, 1.21648e-03, 1.28767e-03, 1.36303e-03/
      DATA (KA_MCO2( 4,JT, 3),JT=1,19)  /
     & 4.61143e-04, 4.92198e-04, 5.25343e-04, 5.60720e-04, 5.98480e-04,
     & 6.38783e-04, 6.81799e-04, 7.27713e-04, 7.76718e-04, 8.29023e-04,
     & 8.84851e-04, 9.44438e-04, 1.00804e-03, 1.07592e-03, 1.14837e-03,
     & 1.22571e-03, 1.30825e-03, 1.39635e-03, 1.49038e-03/
      DATA (KA_MCO2( 5,JT, 3),JT=1,19)  /
     & 4.01988e-04, 4.36672e-04, 4.74349e-04, 5.15278e-04, 5.59737e-04,
     & 6.08032e-04, 6.60495e-04, 7.17484e-04, 7.79390e-04, 8.46638e-04,
     & 9.19688e-04, 9.99041e-04, 1.08524e-03, 1.17888e-03, 1.28059e-03,
     & 1.39109e-03, 1.51111e-03, 1.64149e-03, 1.78313e-03/
      DATA (KA_MCO2( 6,JT, 3),JT=1,19)  /
     & 3.35536e-04, 3.74371e-04, 4.17700e-04, 4.66045e-04, 5.19985e-04,
     & 5.80169e-04, 6.47318e-04, 7.22238e-04, 8.05831e-04, 8.99098e-04,
     & 1.00316e-03, 1.11927e-03, 1.24881e-03, 1.39335e-03, 1.55461e-03,
     & 1.73455e-03, 1.93530e-03, 2.15930e-03, 2.40921e-03/
      DATA (KA_MCO2( 7,JT, 3),JT=1,19)  /
     & 3.24677e-04, 3.75160e-04, 4.33491e-04, 5.00893e-04, 5.78774e-04,
     & 6.68765e-04, 7.72749e-04, 8.92900e-04, 1.03173e-03, 1.19215e-03,
     & 1.37751e-03, 1.59170e-03, 1.83918e-03, 2.12515e-03, 2.45558e-03,
     & 2.83738e-03, 3.27856e-03, 3.78832e-03, 4.37735e-03/
      DATA (KA_MCO2( 8,JT, 3),JT=1,19)  /
     & 2.24656e-03, 2.45550e-03, 2.68386e-03, 2.93347e-03, 3.20629e-03,
     & 3.50448e-03, 3.83041e-03, 4.18665e-03, 4.57602e-03, 5.00160e-03,
     & 5.46677e-03, 5.97519e-03, 6.53090e-03, 7.13829e-03, 7.80217e-03,
     & 8.52780e-03, 9.32091e-03, 1.01878e-02, 1.11353e-02/
      DATA (KA_MCO2( 9,JT, 3),JT=1,19)  /
     & 2.07746e-04, 2.38909e-04, 2.74746e-04, 3.15959e-04, 3.63355e-04,
     & 4.17860e-04, 4.80541e-04, 5.52625e-04, 6.35521e-04, 7.30852e-04,
     & 8.40484e-04, 9.66561e-04, 1.11155e-03, 1.27829e-03, 1.47004e-03,
     & 1.69055e-03, 1.94414e-03, 2.23577e-03, 2.57115e-03/
      DATA (KA_MCO2( 1,JT, 4),JT=1,19)  /
     & 7.26052e-04, 7.62476e-04, 8.00726e-04, 8.40896e-04, 8.83081e-04,
     & 9.27382e-04, 9.73905e-04, 1.02276e-03, 1.07407e-03, 1.12795e-03,
     & 1.18454e-03, 1.24396e-03, 1.30637e-03, 1.37190e-03, 1.44073e-03,
     & 1.51300e-03, 1.58890e-03, 1.66861e-03, 1.75232e-03/
      DATA (KA_MCO2( 2,JT, 4),JT=1,19)  /
     & 4.65815e-04, 5.01167e-04, 5.39203e-04, 5.80126e-04, 6.24154e-04,
     & 6.71524e-04, 7.22489e-04, 7.77322e-04, 8.36316e-04, 8.99788e-04,
     & 9.68077e-04, 1.04155e-03, 1.12060e-03, 1.20564e-03, 1.29714e-03,
     & 1.39559e-03, 1.50151e-03, 1.61546e-03, 1.73807e-03/
      DATA (KA_MCO2( 3,JT, 4),JT=1,19)  /
     & 3.56225e-04, 3.93073e-04, 4.33732e-04, 4.78598e-04, 5.28105e-04,
     & 5.82732e-04, 6.43010e-04, 7.09524e-04, 7.82918e-04, 8.63903e-04,
     & 9.53266e-04, 1.05187e-03, 1.16068e-03, 1.28074e-03, 1.41322e-03,
     & 1.55941e-03, 1.72071e-03, 1.89870e-03, 2.09511e-03/
      DATA (KA_MCO2( 4,JT, 4),JT=1,19)  /
     & 3.37845e-04, 3.79675e-04, 4.26684e-04, 4.79514e-04, 5.38884e-04,
     & 6.05606e-04, 6.80589e-04, 7.64855e-04, 8.59555e-04, 9.65980e-04,
     & 1.08558e-03, 1.21999e-03, 1.37105e-03, 1.54080e-03, 1.73157e-03,
     & 1.94597e-03, 2.18691e-03, 2.45767e-03, 2.76197e-03/
      DATA (KA_MCO2( 5,JT, 4),JT=1,19)  /
     & 3.52456e-04, 4.02782e-04, 4.60294e-04, 5.26017e-04, 6.01126e-04,
     & 6.86958e-04, 7.85046e-04, 8.97140e-04, 1.02524e-03, 1.17163e-03,
     & 1.33892e-03, 1.53010e-03, 1.74858e-03, 1.99825e-03, 2.28358e-03,
     & 2.60964e-03, 2.98226e-03, 3.40809e-03, 3.89471e-03/
      DATA (KA_MCO2( 6,JT, 4),JT=1,19)  /
     & 4.42884e-04, 5.08187e-04, 5.83119e-04, 6.69100e-04, 7.67758e-04,
     & 8.80963e-04, 1.01086e-03, 1.15991e-03, 1.33094e-03, 1.52718e-03,
     & 1.75237e-03, 2.01075e-03, 2.30724e-03, 2.64744e-03, 3.03780e-03,
     & 3.48572e-03, 3.99969e-03, 4.58944e-03, 5.26614e-03/
      DATA (KA_MCO2( 7,JT, 4),JT=1,19)  /
     & 8.09850e-04, 9.09940e-04, 1.02240e-03, 1.14876e-03, 1.29074e-03,
     & 1.45026e-03, 1.62950e-03, 1.83089e-03, 2.05718e-03, 2.31143e-03,
     & 2.59710e-03, 2.91808e-03, 3.27873e-03, 3.68395e-03, 4.13926e-03,
     & 4.65083e-03, 5.22564e-03, 5.87148e-03, 6.59715e-03/
      DATA (KA_MCO2( 8,JT, 4),JT=1,19)  /
     & 3.13265e-03, 3.42454e-03, 3.74362e-03, 4.09243e-03, 4.47375e-03,
     & 4.89059e-03, 5.34627e-03, 5.84441e-03, 6.38897e-03, 6.98426e-03,
     & 7.63502e-03, 8.34642e-03, 9.12409e-03, 9.97423e-03, 1.09036e-02,
     & 1.19195e-02, 1.30301e-02, 1.42442e-02, 1.55714e-02/
      DATA (KA_MCO2( 9,JT, 4),JT=1,19)  /
     & 5.71287e-04, 6.51252e-04, 7.42411e-04, 8.46330e-04, 9.64794e-04,
     & 1.09984e-03, 1.25379e-03, 1.42929e-03, 1.62935e-03, 1.85742e-03,
     & 2.11741e-03, 2.41380e-03, 2.75167e-03, 3.13683e-03, 3.57591e-03,
     & 4.07645e-03, 4.64705e-03, 5.29751e-03, 6.03903e-03/
      DATA (KA_MCO2( 1,JT, 5),JT=1,19)  /
     & 2.92395e-04, 3.32719e-04, 3.78604e-04, 4.30818e-04, 4.90232e-04,
     & 5.57839e-04, 6.34771e-04, 7.22312e-04, 8.21927e-04, 9.35278e-04,
     & 1.06426e-03, 1.21104e-03, 1.37805e-03, 1.56810e-03, 1.78435e-03,
     & 2.03043e-03, 2.31045e-03, 2.62908e-03, 2.99166e-03/
      DATA (KA_MCO2( 2,JT, 5),JT=1,19)  /
     & 3.13069e-04, 3.61343e-04, 4.17061e-04, 4.81371e-04, 5.55597e-04,
     & 6.41269e-04, 7.40151e-04, 8.54280e-04, 9.86008e-04, 1.13805e-03,
     & 1.31353e-03, 1.51608e-03, 1.74985e-03, 2.01967e-03, 2.33110e-03,
     & 2.69055e-03, 3.10543e-03, 3.58427e-03, 4.13696e-03/
      DATA (KA_MCO2( 3,JT, 5),JT=1,19)  /
     & 3.06937e-04, 3.57841e-04, 4.17187e-04, 4.86375e-04, 5.67038e-04,
     & 6.61078e-04, 7.70714e-04, 8.98532e-04, 1.04755e-03, 1.22128e-03,
     & 1.42382e-03, 1.65996e-03, 1.93525e-03, 2.25620e-03, 2.63038e-03,
     & 3.06661e-03, 3.57519e-03, 4.16812e-03, 4.85937e-03/
      DATA (KA_MCO2( 4,JT, 5),JT=1,19)  /
     & 4.06428e-04, 4.72379e-04, 5.49033e-04, 6.38125e-04, 7.41674e-04,
     & 8.62026e-04, 1.00191e-03, 1.16449e-03, 1.35345e-03, 1.57308e-03,
     & 1.82834e-03, 2.12503e-03, 2.46986e-03, 2.87064e-03, 3.33647e-03,
     & 3.87788e-03, 4.50715e-03, 5.23852e-03, 6.08858e-03/
      DATA (KA_MCO2( 5,JT, 5),JT=1,19)  /
     & 6.01967e-04, 6.90414e-04, 7.91856e-04, 9.08204e-04, 1.04165e-03,
     & 1.19470e-03, 1.37023e-03, 1.57156e-03, 1.80247e-03, 2.06731e-03,
     & 2.37106e-03, 2.71944e-03, 3.11901e-03, 3.57729e-03, 4.10290e-03,
     & 4.70574e-03, 5.39716e-03, 6.19017e-03, 7.09969e-03/
      DATA (KA_MCO2( 6,JT, 5),JT=1,19)  /
     & 1.11622e-03, 1.25799e-03, 1.41776e-03, 1.59783e-03, 1.80077e-03,
     & 2.02947e-03, 2.28723e-03, 2.57773e-03, 2.90512e-03, 3.27408e-03,
     & 3.68992e-03, 4.15856e-03, 4.68673e-03, 5.28197e-03, 5.95282e-03,
     & 6.70887e-03, 7.56094e-03, 8.52123e-03, 9.60348e-03/
      DATA (KA_MCO2( 7,JT, 5),JT=1,19)  /
     & 3.63860e-03, 3.96164e-03, 4.31337e-03, 4.69632e-03, 5.11327e-03,
     & 5.56724e-03, 6.06151e-03, 6.59967e-03, 7.18561e-03, 7.82356e-03,
     & 8.51816e-03, 9.27443e-03, 1.00978e-02, 1.09943e-02, 1.19705e-02,
     & 1.30332e-02, 1.41904e-02, 1.54502e-02, 1.68219e-02/
      DATA (KA_MCO2( 8,JT, 5),JT=1,19)  /
     & 5.96957e-03, 6.53049e-03, 7.14412e-03, 7.81541e-03, 8.54977e-03,
     & 9.35314e-03, 1.02320e-02, 1.11934e-02, 1.22452e-02, 1.33958e-02,
     & 1.46545e-02, 1.60315e-02, 1.75379e-02, 1.91858e-02, 2.09886e-02,
     & 2.29608e-02, 2.51182e-02, 2.74784e-02, 3.00604e-02/
      DATA (KA_MCO2( 9,JT, 5),JT=1,19)  /
     & 1.19381e-03, 1.33882e-03, 1.50143e-03, 1.68379e-03, 1.88831e-03,
     & 2.11767e-03, 2.37488e-03, 2.66333e-03, 2.98683e-03, 3.34961e-03,
     & 3.75646e-03, 4.21272e-03, 4.72440e-03, 5.29823e-03, 5.94176e-03,
     & 6.66345e-03, 7.47280e-03, 8.38045e-03, 9.39835e-03/
      DATA (KA_MCO2( 1,JT, 6),JT=1,19)  /
     & 4.12429e-04, 4.84830e-04, 5.69942e-04, 6.69995e-04, 7.87613e-04,
     & 9.25878e-04, 1.08842e-03, 1.27949e-03, 1.50410e-03, 1.76814e-03,
     & 2.07854e-03, 2.44343e-03, 2.87237e-03, 3.37662e-03, 3.96938e-03,
     & 4.66621e-03, 5.48536e-03, 6.44831e-03, 7.58031e-03/
      DATA (KA_MCO2( 2,JT, 6),JT=1,19)  /
     & 6.43498e-04, 7.46132e-04, 8.65134e-04, 1.00312e-03, 1.16311e-03,
     & 1.34861e-03, 1.56371e-03, 1.81310e-03, 2.10228e-03, 2.43758e-03,
     & 2.82635e-03, 3.27714e-03, 3.79981e-03, 4.40586e-03, 5.10855e-03,
     & 5.92333e-03, 6.86806e-03, 7.96346e-03, 9.23357e-03/
      DATA (KA_MCO2( 3,JT, 6),JT=1,19)  /
     & 1.11336e-03, 1.26910e-03, 1.44662e-03, 1.64897e-03, 1.87962e-03,
     & 2.14254e-03, 2.44224e-03, 2.78385e-03, 3.17325e-03, 3.61712e-03,
     & 4.12308e-03, 4.69981e-03, 5.35720e-03, 6.10656e-03, 6.96073e-03,
     & 7.93439e-03, 9.04424e-03, 1.03093e-02, 1.17514e-02/
      DATA (KA_MCO2( 4,JT, 6),JT=1,19)  /
     & 1.87991e-03, 2.10276e-03, 2.35202e-03, 2.63082e-03, 2.94268e-03,
     & 3.29150e-03, 3.68168e-03, 4.11810e-03, 4.60626e-03, 5.15228e-03,
     & 5.76303e-03, 6.44617e-03, 7.21030e-03, 8.06500e-03, 9.02102e-03,
     & 1.00904e-02, 1.12865e-02, 1.26244e-02, 1.41208e-02/
      DATA (KA_MCO2( 5,JT, 6),JT=1,19)  /
     & 3.65848e-03, 4.01372e-03, 4.40346e-03, 4.83104e-03, 5.30015e-03,
     & 5.81480e-03, 6.37943e-03, 6.99888e-03, 7.67849e-03, 8.42408e-03,
     & 9.24208e-03, 1.01395e-02, 1.11241e-02, 1.22042e-02, 1.33893e-02,
     & 1.46894e-02, 1.61158e-02, 1.76806e-02, 1.93975e-02/
      DATA (KA_MCO2( 6,JT, 6),JT=1,19)  /
     & 5.38476e-03, 5.85088e-03, 6.35735e-03, 6.90765e-03, 7.50560e-03,
     & 8.15530e-03, 8.86124e-03, 9.62829e-03, 1.04617e-02, 1.13673e-02,
     & 1.23513e-02, 1.34205e-02, 1.45822e-02, 1.58445e-02, 1.72160e-02,
     & 1.87062e-02, 2.03255e-02, 2.20849e-02, 2.39966e-02/
      DATA (KA_MCO2( 7,JT, 6),JT=1,19)  /
     & 6.27017e-03, 6.84772e-03, 7.47846e-03, 8.16731e-03, 8.91960e-03,
     & 9.74118e-03, 1.06384e-02, 1.16183e-02, 1.26885e-02, 1.38573e-02,
     & 1.51336e-02, 1.65276e-02, 1.80500e-02, 1.97125e-02, 2.15283e-02,
     & 2.35112e-02, 2.56769e-02, 2.80420e-02, 3.06249e-02/
      DATA (KA_MCO2( 8,JT, 6),JT=1,19)  /
     & 9.61932e-03, 1.04802e-02, 1.14182e-02, 1.24401e-02, 1.35534e-02,
     & 1.47664e-02, 1.60880e-02, 1.75278e-02, 1.90965e-02, 2.08056e-02,
     & 2.26677e-02, 2.46964e-02, 2.69066e-02, 2.93147e-02, 3.19383e-02,
     & 3.47967e-02, 3.79110e-02, 4.13039e-02, 4.50005e-02/
      DATA (KA_MCO2( 9,JT, 6),JT=1,19)  /
     & 2.37921e-03, 2.64556e-03, 2.94173e-03, 3.27105e-03, 3.63724e-03,
     & 4.04442e-03, 4.49718e-03, 5.00064e-03, 5.56045e-03, 6.18293e-03,
     & 6.87510e-03, 7.64475e-03, 8.50057e-03, 9.45219e-03, 1.05103e-02,
     & 1.16870e-02, 1.29953e-02, 1.44501e-02, 1.60677e-02/
      DATA (KA_MCO2( 1,JT, 7),JT=1,19)  /
     & 4.64970e-03, 5.13188e-03, 5.66406e-03, 6.25144e-03, 6.89972e-03,
     & 7.61523e-03, 8.40493e-03, 9.27654e-03, 1.02385e-02, 1.13003e-02,
     & 1.24721e-02, 1.37655e-02, 1.51930e-02, 1.67685e-02, 1.85075e-02,
     & 2.04267e-02, 2.25450e-02, 2.48829e-02, 2.74633e-02/
      DATA (KA_MCO2( 2,JT, 7),JT=1,19)  /
     & 6.37148e-03, 6.96805e-03, 7.62046e-03, 8.33397e-03, 9.11428e-03,
     & 9.96765e-03, 1.09009e-02, 1.19216e-02, 1.30378e-02, 1.42585e-02,
     & 1.55935e-02, 1.70536e-02, 1.86503e-02, 2.03965e-02, 2.23062e-02,
     & 2.43948e-02, 2.66789e-02, 2.91768e-02, 3.19086e-02/
      DATA (KA_MCO2( 3,JT, 7),JT=1,19)  /
     & 7.79364e-03, 8.48097e-03, 9.22892e-03, 1.00428e-02, 1.09285e-02,
     & 1.18923e-02, 1.29411e-02, 1.40825e-02, 1.53244e-02, 1.66759e-02,
     & 1.81466e-02, 1.97470e-02, 2.14885e-02, 2.33836e-02, 2.54458e-02,
     & 2.76899e-02, 3.01320e-02, 3.27893e-02, 3.56811e-02/
      DATA (KA_MCO2( 4,JT, 7),JT=1,19)  /
     & 8.70586e-03, 9.48737e-03, 1.03390e-02, 1.12672e-02, 1.22786e-02,
     & 1.33808e-02, 1.45820e-02, 1.58910e-02, 1.73175e-02, 1.88721e-02,
     & 2.05662e-02, 2.24124e-02, 2.44243e-02, 2.66169e-02, 2.90062e-02,
     & 3.16101e-02, 3.44477e-02, 3.75400e-02, 4.09099e-02/
      DATA (KA_MCO2( 5,JT, 7),JT=1,19)  /
     & 9.24510e-03, 1.00865e-02, 1.10045e-02, 1.20061e-02, 1.30988e-02,
     & 1.42910e-02, 1.55916e-02, 1.70106e-02, 1.85588e-02, 2.02479e-02,
     & 2.20908e-02, 2.41013e-02, 2.62948e-02, 2.86880e-02, 3.12990e-02,
     & 3.41476e-02, 3.72555e-02, 4.06462e-02, 4.43455e-02/
      DATA (KA_MCO2( 6,JT, 7),JT=1,19)  /
     & 1.09559e-02, 1.19933e-02, 1.31290e-02, 1.43722e-02, 1.57331e-02,
     & 1.72229e-02, 1.88537e-02, 2.06390e-02, 2.25933e-02, 2.47327e-02,
     & 2.70747e-02, 2.96384e-02, 3.24449e-02, 3.55171e-02, 3.88802e-02,
     & 4.25619e-02, 4.65921e-02, 5.10039e-02, 5.58335e-02/
      DATA (KA_MCO2( 7,JT, 7),JT=1,19)  /
     & 1.36116e-02, 1.48659e-02, 1.62357e-02, 1.77318e-02, 1.93657e-02,
     & 2.11502e-02, 2.30991e-02, 2.52276e-02, 2.75522e-02, 3.00910e-02,
     & 3.28638e-02, 3.58921e-02, 3.91995e-02, 4.28116e-02, 4.67565e-02,
     & 5.10650e-02, 5.57704e-02, 6.09095e-02, 6.65221e-02/
      DATA (KA_MCO2( 8,JT, 7),JT=1,19)  /
     & 1.51783e-02, 1.64551e-02, 1.78392e-02, 1.93399e-02, 2.09667e-02,
     & 2.27304e-02, 2.46424e-02, 2.67153e-02, 2.89626e-02, 3.13988e-02,
     & 3.40401e-02, 3.69035e-02, 4.00077e-02, 4.33731e-02, 4.70216e-02,
     & 5.09770e-02, 5.52651e-02, 5.99139e-02, 6.49538e-02/
      DATA (KA_MCO2( 9,JT, 7),JT=1,19)  /
     & 1.00072e-02, 1.08638e-02, 1.17937e-02, 1.28032e-02, 1.38991e-02,
     & 1.50888e-02, 1.63803e-02, 1.77824e-02, 1.93045e-02, 2.09568e-02,
     & 2.27507e-02, 2.46980e-02, 2.68120e-02, 2.91070e-02, 3.15984e-02,
     & 3.43031e-02, 3.72393e-02, 4.04268e-02, 4.38872e-02/
      DATA (KA_MCO2( 1,JT, 8),JT=1,19)  /
     & 1.59610e-02, 1.74387e-02, 1.90532e-02, 2.08171e-02, 2.27444e-02,
     & 2.48501e-02, 2.71508e-02, 2.96645e-02, 3.24109e-02, 3.54115e-02,
     & 3.86900e-02, 4.22720e-02, 4.61856e-02, 5.04616e-02, 5.51334e-02,
     & 6.02378e-02, 6.58147e-02, 7.19079e-02, 7.85653e-02/
      DATA (KA_MCO2( 2,JT, 8),JT=1,19)  /
     & 1.61961e-02, 1.76986e-02, 1.93405e-02, 2.11348e-02, 2.30955e-02,
     & 2.52381e-02, 2.75794e-02, 3.01380e-02, 3.29340e-02, 3.59893e-02,
     & 3.93280e-02, 4.29766e-02, 4.69636e-02, 5.13204e-02, 5.60815e-02,
     & 6.12843e-02, 6.69697e-02, 7.31826e-02, 7.99718e-02/
      DATA (KA_MCO2( 3,JT, 8),JT=1,19)  /
     & 1.72034e-02, 1.88241e-02, 2.05974e-02, 2.25377e-02, 2.46609e-02,
     & 2.69841e-02, 2.95261e-02, 3.23076e-02, 3.53511e-02, 3.86813e-02,
     & 4.23253e-02, 4.63126e-02, 5.06754e-02, 5.54493e-02, 6.06728e-02,
     & 6.63885e-02, 7.26426e-02, 7.94859e-02, 8.69738e-02/
      DATA (KA_MCO2( 4,JT, 8),JT=1,19)  /
     & 1.79777e-02, 1.96517e-02, 2.14815e-02, 2.34817e-02, 2.56682e-02,
     & 2.80583e-02, 3.06709e-02, 3.35268e-02, 3.66486e-02, 4.00611e-02,
     & 4.37914e-02, 4.78690e-02, 5.23262e-02, 5.71985e-02, 6.25245e-02,
     & 6.83464e-02, 7.47104e-02, 8.16670e-02, 8.92713e-02/
      DATA (KA_MCO2( 5,JT, 8),JT=1,19)  /
     & 2.02540e-02, 2.21214e-02, 2.41610e-02, 2.63887e-02, 2.88218e-02,
     & 3.14792e-02, 3.43816e-02, 3.75516e-02, 4.10139e-02, 4.47954e-02,
     & 4.89256e-02, 5.34366e-02, 5.83635e-02, 6.37447e-02, 6.96220e-02,
     & 7.60413e-02, 8.30523e-02, 9.07098e-02, 9.90734e-02/
      DATA (KA_MCO2( 6,JT, 8),JT=1,19)  /
     & 2.19009e-02, 2.38517e-02, 2.59762e-02, 2.82899e-02, 3.08097e-02,
     & 3.35540e-02, 3.65427e-02, 3.97976e-02, 4.33424e-02, 4.72030e-02,
     & 5.14074e-02, 5.59863e-02, 6.09731e-02, 6.64040e-02, 7.23187e-02,
     & 7.87603e-02, 8.57755e-02, 9.34157e-02, 1.01736e-01/
      DATA (KA_MCO2( 7,JT, 8),JT=1,19)  /
     & 2.52383e-02, 2.73978e-02, 2.97421e-02, 3.22869e-02, 3.50496e-02,
     & 3.80486e-02, 4.13042e-02, 4.48383e-02, 4.86749e-02, 5.28397e-02,
     & 5.73610e-02, 6.22690e-02, 6.75970e-02, 7.33810e-02, 7.96598e-02,
     & 8.64758e-02, 9.38751e-02, 1.01907e-01, 1.10627e-01/
      DATA (KA_MCO2( 8,JT, 8),JT=1,19)  /
     & 3.36506e-02, 3.59288e-02, 3.83613e-02, 4.09584e-02, 4.37313e-02,
     & 4.66920e-02, 4.98531e-02, 5.32283e-02, 5.68319e-02, 6.06795e-02,
     & 6.47876e-02, 6.91739e-02, 7.38570e-02, 7.88573e-02, 8.41960e-02,
     & 8.98962e-02, 9.59824e-02, 1.02481e-01, 1.09419e-01/
      DATA (KA_MCO2( 9,JT, 8),JT=1,19)  /
     & 2.15151e-02, 2.34420e-02, 2.55415e-02, 2.78291e-02, 3.03215e-02,
     & 3.30372e-02, 3.59961e-02, 3.92200e-02, 4.27326e-02, 4.65598e-02,
     & 5.07299e-02, 5.52734e-02, 6.02238e-02, 6.56176e-02, 7.14944e-02,
     & 7.78977e-02, 8.48744e-02, 9.24759e-02, 1.00758e-01/
      DATA (KA_MCO2( 1,JT, 9),JT=1,19)  /
     & 3.34296e-02, 3.64437e-02, 3.97294e-02, 4.33114e-02, 4.72164e-02,
     & 5.14734e-02, 5.61143e-02, 6.11735e-02, 6.66890e-02, 7.27016e-02,
     & 7.92564e-02, 8.64022e-02, 9.41922e-02, 1.02685e-01, 1.11943e-01,
     & 1.22035e-01, 1.33038e-01, 1.45033e-01, 1.58109e-01/
      DATA (KA_MCO2( 2,JT, 9),JT=1,19)  /
     & 3.73946e-02, 4.07543e-02, 4.44160e-02, 4.84066e-02, 5.27558e-02,
     & 5.74958e-02, 6.26616e-02, 6.82915e-02, 7.44273e-02, 8.11144e-02,
     & 8.84023e-02, 9.63449e-02, 1.05001e-01, 1.14435e-01, 1.24717e-01,
     & 1.35922e-01, 1.48135e-01, 1.61444e-01, 1.75949e-01/
      DATA (KA_MCO2( 3,JT, 9),JT=1,19)  /
     & 4.24539e-02, 4.61192e-02, 5.01010e-02, 5.44265e-02, 5.91255e-02,
     & 6.42302e-02, 6.97756e-02, 7.57998e-02, 8.23442e-02, 8.94535e-02,
     & 9.71766e-02, 1.05566e-01, 1.14681e-01, 1.24582e-01, 1.35338e-01,
     & 1.47022e-01, 1.59716e-01, 1.73505e-01, 1.88485e-01/
      DATA (KA_MCO2( 4,JT, 9),JT=1,19)  /
     & 5.30296e-02, 5.73416e-02, 6.20043e-02, 6.70462e-02, 7.24980e-02,
     & 7.83931e-02, 8.47676e-02, 9.16604e-02, 9.91137e-02, 1.07173e-01,
     & 1.15888e-01, 1.25311e-01, 1.35501e-01, 1.46519e-01, 1.58433e-01,
     & 1.71316e-01, 1.85246e-01, 2.00309e-01, 2.16597e-01/
      DATA (KA_MCO2( 5,JT, 9),JT=1,19)  /
     & 6.26111e-02, 6.74018e-02, 7.25591e-02, 7.81111e-02, 8.40878e-02,
     & 9.05218e-02, 9.74482e-02, 1.04904e-01, 1.12931e-01, 1.21572e-01,
     & 1.30875e-01, 1.40889e-01, 1.51669e-01, 1.63274e-01, 1.75767e-01,
     & 1.89216e-01, 2.03694e-01, 2.19279e-01, 2.36058e-01/
      DATA (KA_MCO2( 6,JT, 9),JT=1,19)  /
     & 7.59080e-02, 8.13446e-02, 8.71706e-02, 9.34139e-02, 1.00104e-01,
     & 1.07274e-01, 1.14957e-01, 1.23190e-01, 1.32013e-01, 1.41468e-01,
     & 1.51600e-01, 1.62458e-01, 1.74094e-01, 1.86562e-01, 1.99924e-01,
     & 2.14243e-01, 2.29587e-01, 2.46031e-01, 2.63652e-01/
      DATA (KA_MCO2( 7,JT, 9),JT=1,19)  /
     & 8.81942e-02, 9.39942e-02, 1.00176e-01, 1.06763e-01, 1.13784e-01,
     & 1.21267e-01, 1.29242e-01, 1.37742e-01, 1.46800e-01, 1.56454e-01,
     & 1.66743e-01, 1.77708e-01, 1.89395e-01, 2.01850e-01, 2.15124e-01,
     & 2.29272e-01, 2.44349e-01, 2.60418e-01, 2.77544e-01/
      DATA (KA_MCO2( 8,JT, 9),JT=1,19)  /
     & 6.28535e-02, 6.69314e-02, 7.12740e-02, 7.58982e-02, 8.08225e-02,
     & 8.60662e-02, 9.16502e-02, 9.75965e-02, 1.03929e-01, 1.10671e-01,
     & 1.17852e-01, 1.25498e-01, 1.33640e-01, 1.42311e-01, 1.51544e-01,
     & 1.61376e-01, 1.71846e-01, 1.82996e-01, 1.94868e-01/
      DATA (KA_MCO2( 9,JT, 9),JT=1,19)  /
     & 6.39196e-02, 6.86702e-02, 7.37738e-02, 7.92568e-02, 8.51473e-02,
     & 9.14756e-02, 9.82742e-02, 1.05578e-01, 1.13425e-01, 1.21855e-01,
     & 1.30911e-01, 1.40641e-01, 1.51093e-01, 1.62323e-01, 1.74387e-01,
     & 1.87348e-01, 2.01272e-01, 2.16231e-01, 2.32301e-01/
      DATA (KA_MCO2( 1,JT,10),JT=1,19)  /
     & 9.44086e-02, 1.02788e-01, 1.11911e-01, 1.21844e-01, 1.32659e-01,
     & 1.44434e-01, 1.57253e-01, 1.71211e-01, 1.86407e-01, 2.02952e-01,
     & 2.20966e-01, 2.40578e-01, 2.61932e-01, 2.85180e-01, 3.10492e-01,
     & 3.38051e-01, 3.68056e-01, 4.00723e-01, 4.36291e-01/
      DATA (KA_MCO2( 2,JT,10),JT=1,19)  /
     & 1.29528e-01, 1.39646e-01, 1.50554e-01, 1.62315e-01, 1.74994e-01,
     & 1.88664e-01, 2.03401e-01, 2.19290e-01, 2.36419e-01, 2.54887e-01,
     & 2.74798e-01, 2.96263e-01, 3.19406e-01, 3.44356e-01, 3.71255e-01,
     & 4.00256e-01, 4.31522e-01, 4.65230e-01, 5.01571e-01/
      DATA (KA_MCO2( 3,JT,10),JT=1,19)  /
     & 1.52325e-01, 1.62991e-01, 1.74404e-01, 1.86616e-01, 1.99684e-01,
     & 2.13666e-01, 2.28628e-01, 2.44637e-01, 2.61767e-01, 2.80096e-01,
     & 2.99710e-01, 3.20696e-01, 3.43152e-01, 3.67181e-01, 3.92892e-01,
     & 4.20403e-01, 4.49841e-01, 4.81340e-01, 5.15045e-01/
      DATA (KA_MCO2( 4,JT,10),JT=1,19)  /
     & 1.59763e-01, 1.70378e-01, 1.81698e-01, 1.93770e-01, 2.06644e-01,
     & 2.20373e-01, 2.35015e-01, 2.50629e-01, 2.67281e-01, 2.85039e-01,
     & 3.03977e-01, 3.24174e-01, 3.45712e-01, 3.68681e-01, 3.93176e-01,
     & 4.19299e-01, 4.47157e-01, 4.76866e-01, 5.08549e-01/
      DATA (KA_MCO2( 5,JT,10),JT=1,19)  /
     & 1.79202e-01, 1.91125e-01, 2.03840e-01, 2.17402e-01, 2.31866e-01,
     & 2.47292e-01, 2.63744e-01, 2.81291e-01, 3.00005e-01, 3.19964e-01,
     & 3.41251e-01, 3.63955e-01, 3.88169e-01, 4.13994e-01, 4.41537e-01,
     & 4.70912e-01, 5.02242e-01, 5.35656e-01, 5.71293e-01/
      DATA (KA_MCO2( 6,JT,10),JT=1,19)  /
     & 1.66628e-01, 1.76984e-01, 1.87984e-01, 1.99668e-01, 2.12078e-01,
     & 2.25259e-01, 2.39259e-01, 2.54129e-01, 2.69924e-01, 2.86700e-01,
     & 3.04519e-01, 3.23446e-01, 3.43549e-01, 3.64901e-01, 3.87580e-01,
     & 4.11669e-01, 4.37255e-01, 4.64431e-01, 4.93297e-01/
      DATA (KA_MCO2( 7,JT,10),JT=1,19)  /
     & 2.03980e-01, 2.17141e-01, 2.31152e-01, 2.46067e-01, 2.61945e-01,
     & 2.78847e-01, 2.96839e-01, 3.15993e-01, 3.36382e-01, 3.58087e-01,
     & 3.81193e-01, 4.05789e-01, 4.31972e-01, 4.59845e-01, 4.89517e-01,
     & 5.21103e-01, 5.54727e-01, 5.90520e-01, 6.28623e-01/
      DATA (KA_MCO2( 8,JT,10),JT=1,19)  /
     & 1.96161e-04, 2.07177e-04, 2.18812e-04, 2.31101e-04, 2.44079e-04,
     & 2.57787e-04, 2.72264e-04, 2.87554e-04, 3.03703e-04, 3.20758e-04,
     & 3.38772e-04, 3.57797e-04, 3.77891e-04, 3.99113e-04, 4.21527e-04,
     & 4.45200e-04, 4.70202e-04, 4.96608e-04, 5.24498e-04/
      DATA (KA_MCO2( 9,JT,10),JT=1,19)  /
     & 1.76275e-01, 1.88091e-01, 2.00699e-01, 2.14152e-01, 2.28507e-01,
     & 2.43824e-01, 2.60168e-01, 2.77607e-01, 2.96216e-01, 3.16071e-01,
     & 3.37258e-01, 3.59865e-01, 3.83987e-01, 4.09726e-01, 4.37190e-01,
     & 4.66495e-01, 4.97765e-01, 5.31131e-01, 5.66733e-01/
      DATA (KA_MCO2( 1,JT,11),JT=1,19)  /
     & 1.99797e-01, 2.14154e-01, 2.29543e-01, 2.46038e-01, 2.63718e-01,
     & 2.82669e-01, 3.02981e-01, 3.24753e-01, 3.48090e-01, 3.73104e-01,
     & 3.99915e-01, 4.28652e-01, 4.59455e-01, 4.92471e-01, 5.27859e-01,
     & 5.65791e-01, 6.06448e-01, 6.50027e-01, 6.96738e-01/
      DATA (KA_MCO2( 2,JT,11),JT=1,19)  /
     & 2.20638e-01, 2.35685e-01, 2.51759e-01, 2.68929e-01, 2.87271e-01,
     & 3.06863e-01, 3.27791e-01, 3.50146e-01, 3.74026e-01, 3.99535e-01,
     & 4.26784e-01, 4.55891e-01, 4.86983e-01, 5.20195e-01, 5.55673e-01,
     & 5.93570e-01, 6.34052e-01, 6.77294e-01, 7.23486e-01/
      DATA (KA_MCO2( 3,JT,11),JT=1,19)  /
     & 2.62988e-01, 2.80924e-01, 3.00085e-01, 3.20552e-01, 3.42414e-01,
     & 3.65768e-01, 3.90715e-01, 4.17363e-01, 4.45829e-01, 4.76237e-01,
     & 5.08718e-01, 5.43414e-01, 5.80477e-01, 6.20068e-01, 6.62359e-01,
     & 7.07535e-01, 7.55791e-01, 8.07339e-01, 8.62403e-01/
      DATA (KA_MCO2( 4,JT,11),JT=1,19)  /
     & 2.43674e-01, 2.59946e-01, 2.77304e-01, 2.95821e-01, 3.15575e-01,
     & 3.36647e-01, 3.59127e-01, 3.83108e-01, 4.08691e-01, 4.35981e-01,
     & 4.65094e-01, 4.96152e-01, 5.29282e-01, 5.64626e-01, 6.02329e-01,
     & 6.42550e-01, 6.85457e-01, 7.31229e-01, 7.80057e-01/
      DATA (KA_MCO2( 5,JT,11),JT=1,19)  /
     & 2.23323e-01, 2.37553e-01, 2.52689e-01, 2.68791e-01, 2.85918e-01,
     & 3.04136e-01, 3.23515e-01, 3.44129e-01, 3.66057e-01, 3.89381e-01,
     & 4.14192e-01, 4.40584e-01, 4.68657e-01, 4.98520e-01, 5.30285e-01,
     & 5.64074e-01, 6.00016e-01, 6.38248e-01, 6.78917e-01/
      DATA (KA_MCO2( 6,JT,11),JT=1,19)  /
     & 2.83716e-01, 3.02622e-01, 3.22788e-01, 3.44298e-01, 3.67241e-01,
     & 3.91713e-01, 4.17816e-01, 4.45658e-01, 4.75356e-01, 5.07033e-01,
     & 5.40820e-01, 5.76859e-01, 6.15300e-01, 6.56302e-01, 7.00037e-01,
     & 7.46686e-01, 7.96443e-01, 8.49516e-01, 9.06126e-01/
      DATA (KA_MCO2( 7,JT,11),JT=1,19)  /
     & 1.00497e-03, 1.06500e-03, 1.12863e-03, 1.19606e-03, 1.26751e-03,
     & 1.34323e-03, 1.42348e-03, 1.50852e-03, 1.59864e-03, 1.69414e-03,
     & 1.79535e-03, 1.90261e-03, 2.01628e-03, 2.13673e-03, 2.26438e-03,
     & 2.39966e-03, 2.54302e-03, 2.69494e-03, 2.85594e-03/
      DATA (KA_MCO2( 8,JT,11),JT=1,19)  /
     & 3.22623e-04, 3.39937e-04, 3.58181e-04, 3.77404e-04, 3.97658e-04,
     & 4.19000e-04, 4.41487e-04, 4.65180e-04, 4.90146e-04, 5.16451e-04,
     & 5.44167e-04, 5.73372e-04, 6.04143e-04, 6.36567e-04, 6.70730e-04,
     & 7.06726e-04, 7.44655e-04, 7.84619e-04, 8.26727e-04/
      DATA (KA_MCO2( 9,JT,11),JT=1,19)  /
     & 2.23872e-01, 2.38360e-01, 2.53786e-01, 2.70210e-01, 2.87697e-01,
     & 3.06316e-01, 3.26140e-01, 3.47247e-01, 3.69720e-01, 3.93647e-01,
     & 4.19122e-01, 4.46246e-01, 4.75126e-01, 5.05874e-01, 5.38613e-01,
     & 5.73470e-01, 6.10583e-01, 6.50098e-01, 6.92170e-01/
      DATA (KA_MCO2( 1,JT,12),JT=1,19)  /
     & 3.52418e-01, 3.76085e-01, 4.01341e-01, 4.28293e-01, 4.57055e-01,
     & 4.87749e-01, 5.20504e-01, 5.55458e-01, 5.92760e-01, 6.32567e-01,
     & 6.75047e-01, 7.20380e-01, 7.68757e-01, 8.20383e-01, 8.75476e-01,
     & 9.34268e-01, 9.97009e-01, 1.06396e+00, 1.13541e+00/
      DATA (KA_MCO2( 2,JT,12),JT=1,19)  /
     & 3.38812e-01, 3.61001e-01, 3.84645e-01, 4.09836e-01, 4.36678e-01,
     & 4.65278e-01, 4.95750e-01, 5.28219e-01, 5.62814e-01, 5.99674e-01,
     & 6.38949e-01, 6.80796e-01, 7.25384e-01, 7.72892e-01, 8.23511e-01,
     & 8.77446e-01, 9.34913e-01, 9.96144e-01, 1.06138e+00/
      DATA (KA_MCO2( 3,JT,12),JT=1,19)  /
     & 3.44644e-01, 3.66671e-01, 3.90105e-01, 4.15038e-01, 4.41564e-01,
     & 4.69785e-01, 4.99810e-01, 5.31754e-01, 5.65740e-01, 6.01897e-01,
     & 6.40366e-01, 6.81293e-01, 7.24836e-01, 7.71162e-01, 8.20448e-01,
     & 8.72885e-01, 9.28673e-01, 9.88027e-01, 1.05117e+00/
      DATA (KA_MCO2( 4,JT,12),JT=1,19)  /
     & 4.20358e-01, 4.47809e-01, 4.77053e-01, 5.08207e-01, 5.41395e-01,
     & 5.76750e-01, 6.14414e-01, 6.54538e-01, 6.97282e-01, 7.42818e-01,
     & 7.91327e-01, 8.43004e-01, 8.98056e-01, 9.56703e-01, 1.01918e+00,
     & 1.08574e+00, 1.15664e+00, 1.23217e+00, 1.31264e+00/
      DATA (KA_MCO2( 5,JT,12),JT=1,19)  /
     & 4.42756e-01, 4.72000e-01, 5.03174e-01, 5.36408e-01, 5.71837e-01,
     & 6.09606e-01, 6.49870e-01, 6.92793e-01, 7.38551e-01, 7.87331e-01,
     & 8.39333e-01, 8.94770e-01, 9.53868e-01, 1.01687e+00, 1.08403e+00,
     & 1.15563e+00, 1.23196e+00, 1.31333e+00, 1.40007e+00/
      DATA (KA_MCO2( 6,JT,12),JT=1,19)  /
     & 1.53662e-01, 1.63104e-01, 1.73126e-01, 1.83764e-01, 1.95055e-01,
     & 2.07040e-01, 2.19762e-01, 2.33265e-01, 2.47598e-01, 2.62811e-01,
     & 2.78960e-01, 2.96100e-01, 3.14294e-01, 3.33606e-01, 3.54104e-01,
     & 3.75862e-01, 3.98956e-01, 4.23470e-01, 4.49490e-01/
      DATA (KA_MCO2( 7,JT,12),JT=1,19)  /
     & 5.41472e-04, 5.65116e-04, 5.89793e-04, 6.15547e-04, 6.42426e-04,
     & 6.70479e-04, 6.99757e-04, 7.30313e-04, 7.62203e-04, 7.95486e-04,
     & 8.30223e-04, 8.66476e-04, 9.04312e-04, 9.43801e-04, 9.85013e-04,
     & 1.02803e-03, 1.07292e-03, 1.11977e-03, 1.16866e-03/
      DATA (KA_MCO2( 8,JT,12),JT=1,19)  /
     & 5.94251e-04, 6.17650e-04, 6.41969e-04, 6.67246e-04, 6.93518e-04,
     & 7.20824e-04, 7.49206e-04, 7.78705e-04, 8.09366e-04, 8.41234e-04,
     & 8.74356e-04, 9.08783e-04, 9.44566e-04, 9.81757e-04, 1.02041e-03,
     & 1.06059e-03, 1.10235e-03, 1.14575e-03, 1.19087e-03/
      DATA (KA_MCO2( 9,JT,12),JT=1,19)  /
     & 4.21683e-01, 4.49025e-01, 4.78140e-01, 5.09142e-01, 5.42155e-01,
     & 5.77309e-01, 6.14741e-01, 6.54601e-01, 6.97046e-01, 7.42242e-01,
     & 7.90369e-01, 8.41617e-01, 8.96188e-01, 9.54297e-01, 1.01617e+00,
     & 1.08206e+00, 1.15222e+00, 1.22693e+00, 1.30649e+00/
      DATA (KA_MCO2( 1,JT,13),JT=1,19)  /
     & 5.61805e-01, 5.98988e-01, 6.38631e-01, 6.80898e-01, 7.25962e-01,
     & 7.74009e-01, 8.25236e-01, 8.79853e-01, 9.38085e-01, 1.00017e+00,
     & 1.06637e+00, 1.13694e+00, 1.21219e+00, 1.29242e+00, 1.37795e+00,
     & 1.46915e+00, 1.56638e+00, 1.67005e+00, 1.78058e+00/
      DATA (KA_MCO2( 2,JT,13),JT=1,19)  /
     & 5.55938e-01, 5.91800e-01, 6.29976e-01, 6.70615e-01, 7.13876e-01,
     & 7.59927e-01, 8.08949e-01, 8.61133e-01, 9.16683e-01, 9.75817e-01,
     & 1.03877e+00, 1.10577e+00, 1.17711e+00, 1.25304e+00, 1.33387e+00,
     & 1.41992e+00, 1.51152e+00, 1.60902e+00, 1.71282e+00/
      DATA (KA_MCO2( 3,JT,13),JT=1,19)  /
     & 5.94615e-01, 6.33277e-01, 6.74453e-01, 7.18307e-01, 7.65012e-01,
     & 8.14753e-01, 8.67729e-01, 9.24149e-01, 9.84238e-01, 1.04823e+00,
     & 1.11639e+00, 1.18898e+00, 1.26629e+00, 1.34862e+00, 1.43631e+00,
     & 1.52970e+00, 1.62916e+00, 1.73509e+00, 1.84791e+00/
      DATA (KA_MCO2( 4,JT,13),JT=1,19)  /
     & 5.48973e-01, 5.84145e-01, 6.21570e-01, 6.61394e-01, 7.03768e-01,
     & 7.48858e-01, 7.96836e-01, 8.47889e-01, 9.02212e-01, 9.60015e-01,
     & 1.02152e+00, 1.08697e+00, 1.15661e+00, 1.23071e+00, 1.30956e+00,
     & 1.39347e+00, 1.48274e+00, 1.57774e+00, 1.67883e+00/
      DATA (KA_MCO2( 5,JT,13),JT=1,19)  /
     & 1.49742e-01, 1.59049e-01, 1.68934e-01, 1.79434e-01, 1.90586e-01,
     & 2.02432e-01, 2.15013e-01, 2.28377e-01, 2.42571e-01, 2.57648e-01,
     & 2.73661e-01, 2.90670e-01, 3.08736e-01, 3.27925e-01, 3.48307e-01,
     & 3.69955e-01, 3.92949e-01, 4.17372e-01, 4.43312e-01/
      DATA (KA_MCO2( 6,JT,13),JT=1,19)  /
     & 8.81777e-04, 9.16690e-04, 9.52985e-04, 9.90718e-04, 1.02994e-03,
     & 1.07072e-03, 1.11312e-03, 1.15719e-03, 1.20301e-03, 1.25064e-03,
     & 1.30016e-03, 1.35163e-03, 1.40515e-03, 1.46079e-03, 1.51862e-03,
     & 1.57875e-03, 1.64126e-03, 1.70624e-03, 1.77380e-03/
      DATA (KA_MCO2( 7,JT,13),JT=1,19)  /
     & 8.84366e-04, 9.20446e-04, 9.57999e-04, 9.97083e-04, 1.03776e-03,
     & 1.08010e-03, 1.12417e-03, 1.17003e-03, 1.21777e-03, 1.26745e-03,
     & 1.31916e-03, 1.37298e-03, 1.42899e-03, 1.48729e-03, 1.54797e-03,
     & 1.61113e-03, 1.67686e-03, 1.74527e-03, 1.81647e-03/
      DATA (KA_MCO2( 8,JT,13),JT=1,19)  /
     & 8.92597e-04, 9.33069e-04, 9.75377e-04, 1.01960e-03, 1.06583e-03,
     & 1.11416e-03, 1.16468e-03, 1.21749e-03, 1.27269e-03, 1.33040e-03,
     & 1.39073e-03, 1.45378e-03, 1.51970e-03, 1.58861e-03, 1.66064e-03,
     & 1.73594e-03, 1.81465e-03, 1.89693e-03, 1.98294e-03/
      DATA (KA_MCO2( 9,JT,13),JT=1,19)  /
     & 1.46280e-01, 1.55378e-01, 1.65043e-01, 1.75308e-01, 1.86212e-01,
     & 1.97794e-01, 2.10097e-01, 2.23164e-01, 2.37045e-01, 2.51788e-01,
     & 2.67449e-01, 2.84084e-01, 3.01754e-01, 3.20522e-01, 3.40458e-01,
     & 3.61634e-01, 3.84127e-01, 4.08020e-01, 4.33398e-01/
      DATA (KA_MCO2( 1,JT,14),JT=1,19)  /
     & 9.20236e-01, 9.80010e-01, 1.04367e+00, 1.11146e+00, 1.18366e+00,
     & 1.26054e+00, 1.34242e+00, 1.42962e+00, 1.52248e+00, 1.62137e+00,
     & 1.72669e+00, 1.83885e+00, 1.95829e+00, 2.08549e+00, 2.22096e+00,
     & 2.36522e+00, 2.51886e+00, 2.68247e+00, 2.85671e+00/
      DATA (KA_MCO2( 2,JT,14),JT=1,19)  /
     & 8.39823e-01, 8.95471e-01, 9.54806e-01, 1.01807e+00, 1.08553e+00,
     & 1.15746e+00, 1.23416e+00, 1.31593e+00, 1.40313e+00, 1.49610e+00,
     & 1.59523e+00, 1.70094e+00, 1.81364e+00, 1.93382e+00, 2.06195e+00,
     & 2.19858e+00, 2.34426e+00, 2.49960e+00, 2.66522e+00/
      DATA (KA_MCO2( 3,JT,14),JT=1,19)  /
     & 5.39252e-01, 5.73971e-01, 6.10925e-01, 6.50259e-01, 6.92125e-01,
     & 7.36686e-01, 7.84117e-01, 8.34601e-01, 8.88336e-01, 9.45530e-01,
     & 1.00641e+00, 1.07120e+00, 1.14017e+00, 1.21358e+00, 1.29171e+00,
     & 1.37488e+00, 1.46340e+00, 1.55762e+00, 1.65790e+00/
      DATA (KA_MCO2( 4,JT,14),JT=1,19)  /
     & 1.14837e-03, 1.19701e-03, 1.24770e-03, 1.30055e-03, 1.35563e-03,
     & 1.41305e-03, 1.47289e-03, 1.53528e-03, 1.60030e-03, 1.66808e-03,
     & 1.73873e-03, 1.81237e-03, 1.88913e-03, 1.96914e-03, 2.05254e-03,
     & 2.13947e-03, 2.23009e-03, 2.32454e-03, 2.42299e-03/
      DATA (KA_MCO2( 5,JT,14),JT=1,19)  /
     & 1.14611e-03, 1.19424e-03, 1.24440e-03, 1.29666e-03, 1.35111e-03,
     & 1.40786e-03, 1.46698e-03, 1.52859e-03, 1.59279e-03, 1.65968e-03,
     & 1.72938e-03, 1.80201e-03, 1.87769e-03, 1.95655e-03, 2.03872e-03,
     & 2.12434e-03, 2.21355e-03, 2.30651e-03, 2.40338e-03/
      DATA (KA_MCO2( 6,JT,14),JT=1,19)  /
     & 1.14203e-03, 1.18930e-03, 1.23852e-03, 1.28979e-03, 1.34317e-03,
     & 1.39877e-03, 1.45666e-03, 1.51695e-03, 1.57974e-03, 1.64513e-03,
     & 1.71322e-03, 1.78413e-03, 1.85798e-03, 1.93488e-03, 2.01497e-03,
     & 2.09837e-03, 2.18522e-03, 2.27567e-03, 2.36986e-03/
      DATA (KA_MCO2( 7,JT,14),JT=1,19)  /
     & 1.11217e-03, 1.15727e-03, 1.20421e-03, 1.25305e-03, 1.30386e-03,
     & 1.35674e-03, 1.41177e-03, 1.46902e-03, 1.52860e-03, 1.59059e-03,
     & 1.65510e-03, 1.72222e-03, 1.79207e-03, 1.86475e-03, 1.94037e-03,
     & 2.01907e-03, 2.10095e-03, 2.18616e-03, 2.27482e-03/
      DATA (KA_MCO2( 8,JT,14),JT=1,19)  /
     & 1.21596e-03, 1.25817e-03, 1.30183e-03, 1.34702e-03, 1.39377e-03,
     & 1.44214e-03, 1.49219e-03, 1.54398e-03, 1.59757e-03, 1.65302e-03,
     & 1.71039e-03, 1.76975e-03, 1.83117e-03, 1.89473e-03, 1.96049e-03,
     & 2.02853e-03, 2.09893e-03, 2.17178e-03, 2.24716e-03/
      DATA (KA_MCO2( 9,JT,14),JT=1,19)  /
     & 1.14611e-03, 1.19424e-03, 1.24440e-03, 1.29666e-03, 1.35111e-03,
     & 1.40786e-03, 1.46698e-03, 1.52859e-03, 1.59279e-03, 1.65968e-03,
     & 1.72938e-03, 1.80201e-03, 1.87769e-03, 1.95655e-03, 2.03872e-03,
     & 2.12434e-03, 2.21355e-03, 2.30651e-03, 2.40338e-03/
      DATA (KA_MCO2( 1,JT,15),JT=1,19)  /
     & 1.29470e+00, 1.37848e+00, 1.46768e+00, 1.56266e+00, 1.66378e+00,
     & 1.77145e+00, 1.88609e+00, 2.00814e+00, 2.13809e+00, 2.27645e+00,
     & 2.42376e+00, 2.58061e+00, 2.74761e+00, 2.92541e+00, 3.11472e+00,
     & 3.31628e+00, 3.53088e+00, 3.75938e+00, 4.00265e+00/
      DATA (KA_MCO2( 2,JT,15),JT=1,19)  /
     & 7.23701e-01, 7.68508e-01, 8.16089e-01, 8.66616e-01, 9.20272e-01,
     & 9.77250e-01, 1.03775e+00, 1.10201e+00, 1.17024e+00, 1.24269e+00,
     & 1.31963e+00, 1.40133e+00, 1.48809e+00, 1.58023e+00, 1.67807e+00,
     & 1.78196e+00, 1.89229e+00, 2.00945e+00, 2.13386e+00/
      DATA (KA_MCO2( 3,JT,15),JT=1,19)  /
     & 1.81684e-03, 1.85424e-03, 1.89241e-03, 1.93137e-03, 1.97114e-03,
     & 2.01172e-03, 2.05313e-03, 2.09540e-03, 2.13854e-03, 2.18257e-03,
     & 2.22750e-03, 2.27336e-03, 2.32016e-03, 2.36793e-03, 2.41668e-03,
     & 2.46643e-03, 2.51721e-03, 2.56903e-03, 2.62192e-03/
      DATA (KA_MCO2( 4,JT,15),JT=1,19)  /
     & 1.84644e-03, 1.88437e-03, 1.92309e-03, 1.96260e-03, 2.00293e-03,
     & 2.04408e-03, 2.08608e-03, 2.12894e-03, 2.17268e-03, 2.21732e-03,
     & 2.26288e-03, 2.30938e-03, 2.35683e-03, 2.40525e-03, 2.45467e-03,
     & 2.50510e-03, 2.55658e-03, 2.60910e-03, 2.66271e-03/
      DATA (KA_MCO2( 5,JT,15),JT=1,19)  /
     & 1.88579e-03, 1.92454e-03, 1.96408e-03, 2.00443e-03, 2.04561e-03,
     & 2.08764e-03, 2.13054e-03, 2.17431e-03, 2.21898e-03, 2.26457e-03,
     & 2.31110e-03, 2.35858e-03, 2.40704e-03, 2.45650e-03, 2.50697e-03,
     & 2.55848e-03, 2.61104e-03, 2.66469e-03, 2.71943e-03/
      DATA (KA_MCO2( 6,JT,15),JT=1,19)  /
     & 1.95322e-03, 1.99316e-03, 2.03391e-03, 2.07549e-03, 2.11793e-03,
     & 2.16123e-03, 2.20542e-03, 2.25051e-03, 2.29652e-03, 2.34347e-03,
     & 2.39139e-03, 2.44028e-03, 2.49017e-03, 2.54109e-03, 2.59304e-03,
     & 2.64605e-03, 2.70015e-03, 2.75536e-03, 2.81169e-03/
      DATA (KA_MCO2( 7,JT,15),JT=1,19)  /
     & 2.13640e-03, 2.17976e-03, 2.22400e-03, 2.26914e-03, 2.31520e-03,
     & 2.36219e-03, 2.41013e-03, 2.45905e-03, 2.50896e-03, 2.55988e-03,
     & 2.61184e-03, 2.66485e-03, 2.71893e-03, 2.77412e-03, 2.83042e-03,
     & 2.88787e-03, 2.94648e-03, 3.00629e-03, 3.06730e-03/
      DATA (KA_MCO2( 8,JT,15),JT=1,19)  /
     & 2.17014e-03, 2.21411e-03, 2.25897e-03, 2.30474e-03, 2.35143e-03,
     & 2.39908e-03, 2.44769e-03, 2.49728e-03, 2.54788e-03, 2.59950e-03,
     & 2.65217e-03, 2.70591e-03, 2.76073e-03, 2.81667e-03, 2.87374e-03,
     & 2.93197e-03, 2.99137e-03, 3.05198e-03, 3.11382e-03/
      DATA (KA_MCO2( 9,JT,15),JT=1,19)  /
     & 1.88579e-03, 1.92454e-03, 1.96408e-03, 2.00443e-03, 2.04561e-03,
     & 2.08764e-03, 2.13054e-03, 2.17431e-03, 2.21898e-03, 2.26457e-03,
     & 2.31110e-03, 2.35858e-03, 2.40704e-03, 2.45650e-03, 2.50697e-03,
     & 2.55848e-03, 2.61104e-03, 2.66469e-03, 2.71943e-03/
      DATA (KA_MCO2( 1,JT,16),JT=1,19)  /
     & 1.48989e+00, 1.58377e+00, 1.68356e+00, 1.78964e+00, 1.90241e+00,
     & 2.02228e+00, 2.14971e+00, 2.28516e+00, 2.42915e+00, 2.58221e+00,
     & 2.74492e+00, 2.91788e+00, 3.10174e+00, 3.29718e+00, 3.50494e+00,
     & 3.72578e+00, 3.96055e+00, 4.21010e+00, 4.47538e+00/
      DATA (KA_MCO2( 2,JT,16),JT=1,19)  /
     & 2.10609e-03, 2.14759e-03, 2.18992e-03, 2.23307e-03, 2.27708e-03,
     & 2.32196e-03, 2.36771e-03, 2.41438e-03, 2.46196e-03, 2.51047e-03,
     & 2.55995e-03, 2.61040e-03, 2.66184e-03, 2.71430e-03, 2.76779e-03,
     & 2.82234e-03, 2.87796e-03, 2.93467e-03, 2.99251e-03/
      DATA (KA_MCO2( 3,JT,16),JT=1,19)  /
     & 2.10609e-03, 2.14759e-03, 2.18992e-03, 2.23307e-03, 2.27708e-03,
     & 2.32196e-03, 2.36771e-03, 2.41438e-03, 2.46196e-03, 2.51047e-03,
     & 2.55995e-03, 2.61040e-03, 2.66184e-03, 2.71430e-03, 2.76779e-03,
     & 2.82234e-03, 2.87796e-03, 2.93467e-03, 2.99251e-03/
      DATA (KA_MCO2( 4,JT,16),JT=1,19)  /
     & 2.10609e-03, 2.14759e-03, 2.18992e-03, 2.23307e-03, 2.27708e-03,
     & 2.32196e-03, 2.36771e-03, 2.41438e-03, 2.46196e-03, 2.51047e-03,
     & 2.55995e-03, 2.61040e-03, 2.66184e-03, 2.71430e-03, 2.76779e-03,
     & 2.82234e-03, 2.87796e-03, 2.93467e-03, 2.99251e-03/
      DATA (KA_MCO2( 5,JT,16),JT=1,19)  /
     & 2.10609e-03, 2.14759e-03, 2.18992e-03, 2.23307e-03, 2.27708e-03,
     & 2.32196e-03, 2.36771e-03, 2.41438e-03, 2.46196e-03, 2.51047e-03,
     & 2.55995e-03, 2.61040e-03, 2.66184e-03, 2.71430e-03, 2.76779e-03,
     & 2.82234e-03, 2.87796e-03, 2.93467e-03, 2.99251e-03/
      DATA (KA_MCO2( 6,JT,16),JT=1,19)  /
     & 2.10609e-03, 2.14759e-03, 2.18992e-03, 2.23307e-03, 2.27708e-03,
     & 2.32196e-03, 2.36771e-03, 2.41438e-03, 2.46196e-03, 2.51047e-03,
     & 2.55995e-03, 2.61040e-03, 2.66184e-03, 2.71430e-03, 2.76779e-03,
     & 2.82234e-03, 2.87796e-03, 2.93467e-03, 2.99251e-03/
      DATA (KA_MCO2( 7,JT,16),JT=1,19)  /
     & 2.09970e-03, 2.14101e-03, 2.18312e-03, 2.22606e-03, 2.26985e-03,
     & 2.31450e-03, 2.36003e-03, 2.40645e-03, 2.45379e-03, 2.50205e-03,
     & 2.55127e-03, 2.60146e-03, 2.65263e-03, 2.70481e-03, 2.75801e-03,
     & 2.81226e-03, 2.86758e-03, 2.92399e-03, 2.98150e-03/
      DATA (KA_MCO2( 8,JT,16),JT=1,19)  /
     & 2.09970e-03, 2.14101e-03, 2.18312e-03, 2.22606e-03, 2.26985e-03,
     & 2.31450e-03, 2.36003e-03, 2.40645e-03, 2.45379e-03, 2.50205e-03,
     & 2.55127e-03, 2.60146e-03, 2.65263e-03, 2.70481e-03, 2.75801e-03,
     & 2.81226e-03, 2.86758e-03, 2.92399e-03, 2.98150e-03/
      DATA (KA_MCO2( 9,JT,16),JT=1,19)  /
     & 2.10609e-03, 2.14759e-03, 2.18992e-03, 2.23307e-03, 2.27708e-03,
     & 2.32196e-03, 2.36771e-03, 2.41438e-03, 2.46196e-03, 2.51047e-03,
     & 2.55995e-03, 2.61040e-03, 2.66184e-03, 2.71430e-03, 2.76779e-03,
     & 2.82234e-03, 2.87796e-03, 2.93467e-03, 2.99251e-03/
       DATA (KA_MCO( 1,JT, 1),JT=1,19)  /
     & 4.58355e-01, 4.47074e-01, 4.36070e-01, 4.25337e-01, 4.14868e-01,
     & 4.04657e-01, 3.94697e-01, 3.84982e-01, 3.75506e-01, 3.66264e-01,
     & 3.57249e-01, 3.48456e-01, 3.39879e-01, 3.31514e-01, 3.23354e-01,
     & 3.15395e-01, 3.07632e-01, 3.00061e-01, 2.92675e-01/
       DATA (KA_MCO( 2,JT, 1),JT=1,19)  /
     & 7.03080e-01, 6.84132e-01, 6.65696e-01, 6.47756e-01, 6.30300e-01,
     & 6.13314e-01, 5.96786e-01, 5.80703e-01, 5.65053e-01, 5.49826e-01,
     & 5.35009e-01, 5.20591e-01, 5.06561e-01, 4.92910e-01, 4.79627e-01,
     & 4.66701e-01, 4.54124e-01, 4.41886e-01, 4.29978e-01/
       DATA (KA_MCO( 3,JT, 1),JT=1,19)  /
     & 8.53018e-01, 8.29537e-01, 8.06703e-01, 7.84497e-01, 7.62903e-01,
     & 7.41903e-01, 7.21481e-01, 7.01621e-01, 6.82307e-01, 6.63526e-01,
     & 6.45261e-01, 6.27499e-01, 6.10226e-01, 5.93429e-01, 5.77094e-01,
     & 5.61208e-01, 5.45760e-01, 5.30737e-01, 5.16128e-01/
       DATA (KA_MCO( 4,JT, 1),JT=1,19)  /
     & 9.58866e-01, 9.31881e-01, 9.05654e-01, 8.80166e-01, 8.55395e-01,
     & 8.31321e-01, 8.07925e-01, 7.85187e-01, 7.63089e-01, 7.41613e-01,
     & 7.20742e-01, 7.00457e-01, 6.80744e-01, 6.61586e-01, 6.42966e-01,
     & 6.24871e-01, 6.07285e-01, 5.90194e-01, 5.73584e-01/
       DATA (KA_MCO( 5,JT, 1),JT=1,19)  /
     & 1.07140e+00, 1.04056e+00, 1.01061e+00, 9.81521e-01, 9.53269e-01,
     & 9.25829e-01, 8.99180e-01, 8.73297e-01, 8.48160e-01, 8.23746e-01,
     & 8.00035e-01, 7.77006e-01, 7.54641e-01, 7.32919e-01, 7.11822e-01,
     & 6.91333e-01, 6.71433e-01, 6.52106e-01, 6.33336e-01/
       DATA (KA_MCO( 6,JT, 1),JT=1,19)  /
     & 1.21046e+00, 1.17478e+00, 1.14015e+00, 1.10655e+00, 1.07393e+00,
     & 1.04228e+00, 1.01156e+00, 9.81740e-01, 9.52803e-01, 9.24720e-01,
     & 8.97463e-01, 8.71011e-01, 8.45338e-01, 8.20422e-01, 7.96240e-01,
     & 7.72771e-01, 7.49993e-01, 7.27887e-01, 7.06433e-01/
       DATA (KA_MCO( 7,JT, 1),JT=1,19)  /
     & 1.57730e+00, 1.52919e+00, 1.48255e+00, 1.43733e+00, 1.39349e+00,
     & 1.35099e+00, 1.30978e+00, 1.26983e+00, 1.23110e+00, 1.19355e+00,
     & 1.15715e+00, 1.12186e+00, 1.08764e+00, 1.05446e+00, 1.02230e+00,
     & 9.91121e-01, 9.60890e-01, 9.31583e-01, 9.03169e-01/
       DATA (KA_MCO( 8,JT, 1),JT=1,19)  /
     & 2.43678e+00, 2.36595e+00, 2.29719e+00, 2.23042e+00, 2.16560e+00,
     & 2.10266e+00, 2.04154e+00, 1.98221e+00, 1.92460e+00, 1.86866e+00,
     & 1.81435e+00, 1.76162e+00, 1.71042e+00, 1.66070e+00, 1.61244e+00,
     & 1.56557e+00, 1.52007e+00, 1.47589e+00, 1.43300e+00/
       DATA (KA_MCO( 9,JT, 1),JT=1,19)  /
     & 9.66296e-01, 9.39903e-01, 9.14232e-01, 8.89262e-01, 8.64973e-01,
     & 8.41348e-01, 8.18369e-01, 7.96017e-01, 7.74275e-01, 7.53128e-01,
     & 7.32558e-01, 7.12549e-01, 6.93088e-01, 6.74157e-01, 6.55744e-01,
     & 6.37834e-01, 6.20413e-01, 6.03468e-01, 5.86985e-01/
       DATA (KA_MCO( 1,JT, 2),JT=1,19)  /
     & 1.15047e+00, 1.12127e+00, 1.09281e+00, 1.06507e+00, 1.03804e+00,
     & 1.01169e+00, 9.86010e-01, 9.60983e-01, 9.36591e-01, 9.12818e-01,
     & 8.89649e-01, 8.67067e-01, 8.45059e-01, 8.23610e-01, 8.02705e-01,
     & 7.82330e-01, 7.62473e-01, 7.43119e-01, 7.24257e-01/
       DATA (KA_MCO( 2,JT, 2),JT=1,19)  /
     & 1.43243e+00, 1.39430e+00, 1.35719e+00, 1.32106e+00, 1.28590e+00,
     & 1.25167e+00, 1.21836e+00, 1.18593e+00, 1.15436e+00, 1.12364e+00,
     & 1.09373e+00, 1.06462e+00, 1.03628e+00, 1.00870e+00, 9.81848e-01,
     & 9.55714e-01, 9.30275e-01, 9.05514e-01, 8.81412e-01/
       DATA (KA_MCO( 3,JT, 2),JT=1,19)  /
     & 1.61389e+00, 1.56911e+00, 1.52556e+00, 1.48323e+00, 1.44207e+00,
     & 1.40205e+00, 1.36314e+00, 1.32531e+00, 1.28854e+00, 1.25278e+00,
     & 1.21801e+00, 1.18421e+00, 1.15135e+00, 1.11940e+00, 1.08834e+00,
     & 1.05814e+00, 1.02877e+00, 1.00022e+00, 9.72466e-01/
       DATA (KA_MCO( 4,JT, 2),JT=1,19)  /
     & 1.78458e+00, 1.73440e+00, 1.68564e+00, 1.63825e+00, 1.59219e+00,
     & 1.54742e+00, 1.50391e+00, 1.46163e+00, 1.42053e+00, 1.38059e+00,
     & 1.34178e+00, 1.30405e+00, 1.26739e+00, 1.23175e+00, 1.19712e+00,
     & 1.16346e+00, 1.13075e+00, 1.09896e+00, 1.06806e+00/
       DATA (KA_MCO( 5,JT, 2),JT=1,19)  /
     & 1.92622e+00, 1.87172e+00, 1.81876e+00, 1.76730e+00, 1.71730e+00,
     & 1.66871e+00, 1.62150e+00, 1.57562e+00, 1.53104e+00, 1.48772e+00,
     & 1.44563e+00, 1.40473e+00, 1.36498e+00, 1.32636e+00, 1.28883e+00,
     & 1.25237e+00, 1.21693e+00, 1.18250e+00, 1.14905e+00/
       DATA (KA_MCO( 6,JT, 2),JT=1,19)  /
     & 2.23194e+00, 2.16782e+00, 2.10554e+00, 2.04505e+00, 1.98630e+00,
     & 1.92924e+00, 1.87381e+00, 1.81998e+00, 1.76770e+00, 1.71691e+00,
     & 1.66759e+00, 1.61968e+00, 1.57315e+00, 1.52796e+00, 1.48406e+00,
     & 1.44143e+00, 1.40002e+00, 1.35980e+00, 1.32073e+00/
       DATA (KA_MCO( 7,JT, 2),JT=1,19)  /
     & 2.64692e+00, 2.57290e+00, 2.50096e+00, 2.43103e+00, 2.36305e+00,
     & 2.29697e+00, 2.23275e+00, 2.17031e+00, 2.10963e+00, 2.05064e+00,
     & 1.99330e+00, 1.93756e+00, 1.88338e+00, 1.83072e+00, 1.77953e+00,
     & 1.72977e+00, 1.68140e+00, 1.63438e+00, 1.58868e+00/
       DATA (KA_MCO( 8,JT, 2),JT=1,19)  /
     & 2.86812e+00, 2.80121e+00, 2.73586e+00, 2.67204e+00, 2.60970e+00,
     & 2.54882e+00, 2.48936e+00, 2.43129e+00, 2.37457e+00, 2.31917e+00,
     & 2.26507e+00, 2.21223e+00, 2.16062e+00, 2.11022e+00, 2.06099e+00,
     & 2.01291e+00, 1.96595e+00, 1.92009e+00, 1.87529e+00/
       DATA (KA_MCO( 9,JT, 2),JT=1,19)  /
     & 1.25243e+00, 1.22790e+00, 1.20385e+00, 1.18027e+00, 1.15716e+00,
     & 1.13449e+00, 1.11227e+00, 1.09049e+00, 1.06913e+00, 1.04819e+00,
     & 1.02766e+00, 1.00754e+00, 9.87804e-01, 9.68457e-01, 9.49490e-01,
     & 9.30894e-01, 9.12662e-01, 8.94787e-01, 8.77263e-01/
       DATA (KA_MCO( 1,JT, 3),JT=1,19)  /
     & 2.55598e+00, 2.48729e+00, 2.42045e+00, 2.35541e+00, 2.29211e+00,
     & 2.23052e+00, 2.17058e+00, 2.11225e+00, 2.05549e+00, 2.00025e+00,
     & 1.94650e+00, 1.89419e+00, 1.84329e+00, 1.79376e+00, 1.74555e+00,
     & 1.69865e+00, 1.65300e+00, 1.60858e+00, 1.56535e+00/
       DATA (KA_MCO( 2,JT, 3),JT=1,19)  /
     & 2.93113e+00, 2.85257e+00, 2.77612e+00, 2.70172e+00, 2.62932e+00,
     & 2.55885e+00, 2.49028e+00, 2.42354e+00, 2.35859e+00, 2.29538e+00,
     & 2.23386e+00, 2.17400e+00, 2.11573e+00, 2.05903e+00, 2.00385e+00,
     & 1.95015e+00, 1.89788e+00, 1.84702e+00, 1.79752e+00/
       DATA (KA_MCO( 3,JT, 3),JT=1,19)  /
     & 3.26626e+00, 3.18025e+00, 3.09651e+00, 3.01497e+00, 2.93558e+00,
     & 2.85828e+00, 2.78302e+00, 2.70973e+00, 2.63838e+00, 2.56891e+00,
     & 2.50126e+00, 2.43540e+00, 2.37127e+00, 2.30883e+00, 2.24803e+00,
     & 2.18883e+00, 2.13120e+00, 2.07508e+00, 2.02044e+00/
       DATA (KA_MCO( 4,JT, 3),JT=1,19)  /
     & 3.65895e+00, 3.56418e+00, 3.47187e+00, 3.38194e+00, 3.29435e+00,
     & 3.20903e+00, 3.12591e+00, 3.04495e+00, 2.96608e+00, 2.88926e+00,
     & 2.81443e+00, 2.74153e+00, 2.67053e+00, 2.60136e+00, 2.53398e+00,
     & 2.46835e+00, 2.40442e+00, 2.34214e+00, 2.28148e+00/
       DATA (KA_MCO( 5,JT, 3),JT=1,19)  /
     & 4.13692e+00, 4.03459e+00, 3.93479e+00, 3.83746e+00, 3.74254e+00,
     & 3.64997e+00, 3.55968e+00, 3.47163e+00, 3.38576e+00, 3.30201e+00,
     & 3.22034e+00, 3.14068e+00, 3.06299e+00, 2.98723e+00, 2.91334e+00,
     & 2.84128e+00, 2.77100e+00, 2.70246e+00, 2.63561e+00/
       DATA (KA_MCO( 6,JT, 3),JT=1,19)  /
     & 4.42856e+00, 4.32480e+00, 4.22348e+00, 4.12453e+00, 4.02790e+00,
     & 3.93353e+00, 3.84137e+00, 3.75137e+00, 3.66348e+00, 3.57765e+00,
     & 3.49383e+00, 3.41198e+00, 3.33204e+00, 3.25397e+00, 3.17774e+00,
     & 3.10329e+00, 3.03058e+00, 2.95958e+00, 2.89024e+00/
       DATA (KA_MCO( 7,JT, 3),JT=1,19)  /
     & 4.31306e+00, 4.21750e+00, 4.12406e+00, 4.03268e+00, 3.94333e+00,
     & 3.85596e+00, 3.77053e+00, 3.68699e+00, 3.60530e+00, 3.52542e+00,
     & 3.44731e+00, 3.37093e+00, 3.29624e+00, 3.22321e+00, 3.15179e+00,
     & 3.08196e+00, 3.01368e+00, 2.94691e+00, 2.88161e+00/
       DATA (KA_MCO( 8,JT, 3),JT=1,19)  /
     & 4.38922e+00, 4.32180e+00, 4.25543e+00, 4.19007e+00, 4.12571e+00,
     & 4.06234e+00, 3.99995e+00, 3.93851e+00, 3.87802e+00, 3.81846e+00,
     & 3.75981e+00, 3.70206e+00, 3.64520e+00, 3.58922e+00, 3.53409e+00,
     & 3.47981e+00, 3.42636e+00, 3.37374e+00, 3.32192e+00/
       DATA (KA_MCO( 9,JT, 3),JT=1,19)  /
     & 1.56810e+00, 1.54211e+00, 1.51654e+00, 1.49139e+00, 1.46667e+00,
     & 1.44235e+00, 1.41844e+00, 1.39492e+00, 1.37179e+00, 1.34905e+00,
     & 1.32668e+00, 1.30469e+00, 1.28306e+00, 1.26178e+00, 1.24086e+00,
     & 1.22029e+00, 1.20006e+00, 1.18016e+00, 1.16059e+00/
       DATA (KA_MCO( 1,JT, 4),JT=1,19)  /
     & 6.58275e+00, 6.43026e+00, 6.28130e+00, 6.13579e+00, 5.99365e+00,
     & 5.85481e+00, 5.71918e+00, 5.58669e+00, 5.45727e+00, 5.33085e+00,
     & 5.20736e+00, 5.08673e+00, 4.96889e+00, 4.85379e+00, 4.74135e+00,
     & 4.63151e+00, 4.52422e+00, 4.41942e+00, 4.31704e+00/
       DATA (KA_MCO( 2,JT, 4),JT=1,19)  /
     & 6.59883e+00, 6.45139e+00, 6.30725e+00, 6.16633e+00, 6.02855e+00,
     & 5.89386e+00, 5.76217e+00, 5.63342e+00, 5.50756e+00, 5.38450e+00,
     & 5.26419e+00, 5.14657e+00, 5.03158e+00, 4.91916e+00, 4.80925e+00,
     & 4.70180e+00, 4.59675e+00, 4.49404e+00, 4.39363e+00/
       DATA (KA_MCO( 3,JT, 4),JT=1,19)  /
     & 6.58521e+00, 6.44452e+00, 6.30683e+00, 6.17209e+00, 6.04023e+00,
     & 5.91118e+00, 5.78489e+00, 5.66130e+00, 5.54034e+00, 5.42198e+00,
     & 5.30614e+00, 5.19277e+00, 5.08183e+00, 4.97326e+00, 4.86701e+00,
     & 4.76303e+00, 4.66127e+00, 4.56168e+00, 4.46422e+00/
       DATA (KA_MCO( 4,JT, 4),JT=1,19)  /
     & 6.33742e+00, 6.20870e+00, 6.08260e+00, 5.95905e+00, 5.83802e+00,
     & 5.71945e+00, 5.60328e+00, 5.48947e+00, 5.37798e+00, 5.26875e+00,
     & 5.16174e+00, 5.05690e+00, 4.95419e+00, 4.85357e+00, 4.75499e+00,
     & 4.65841e+00, 4.56379e+00, 4.47110e+00, 4.38029e+00/
       DATA (KA_MCO( 5,JT, 4),JT=1,19)  /
     & 5.99732e+00, 5.88459e+00, 5.77398e+00, 5.66545e+00, 5.55896e+00,
     & 5.45447e+00, 5.35194e+00, 5.25134e+00, 5.15263e+00, 5.05578e+00,
     & 4.96075e+00, 4.86750e+00, 4.77601e+00, 4.68623e+00, 4.59815e+00,
     & 4.51171e+00, 4.42691e+00, 4.34370e+00, 4.26205e+00/
       DATA (KA_MCO( 6,JT, 4),JT=1,19)  /
     & 5.74529e+00, 5.65249e+00, 5.56119e+00, 5.47136e+00, 5.38299e+00,
     & 5.29604e+00, 5.21049e+00, 5.12633e+00, 5.04353e+00, 4.96206e+00,
     & 4.88191e+00, 4.80306e+00, 4.72547e+00, 4.64915e+00, 4.57405e+00,
     & 4.50017e+00, 4.42748e+00, 4.35596e+00, 4.28560e+00/
       DATA (KA_MCO( 7,JT, 4),JT=1,19)  /
     & 5.87251e+00, 5.79956e+00, 5.72753e+00, 5.65638e+00, 5.58613e+00,
     & 5.51674e+00, 5.44822e+00, 5.38054e+00, 5.31371e+00, 5.24771e+00,
     & 5.18253e+00, 5.11815e+00, 5.05458e+00, 4.99180e+00, 4.92979e+00,
     & 4.86856e+00, 4.80809e+00, 4.74837e+00, 4.68939e+00/
       DATA (KA_MCO( 8,JT, 4),JT=1,19)  /
     & 5.68503e+00, 5.62827e+00, 5.57207e+00, 5.51644e+00, 5.46136e+00,
     & 5.40684e+00, 5.35285e+00, 5.29941e+00, 5.24650e+00, 5.19412e+00,
     & 5.14226e+00, 5.09092e+00, 5.04009e+00, 4.98977e+00, 4.93995e+00,
     & 4.89063e+00, 4.84180e+00, 4.79346e+00, 4.74560e+00/
       DATA (KA_MCO( 9,JT, 4),JT=1,19)  /
     & 2.69278e+00, 2.65058e+00, 2.60903e+00, 2.56814e+00, 2.52789e+00,
     & 2.48827e+00, 2.44927e+00, 2.41088e+00, 2.37310e+00, 2.33590e+00,
     & 2.29929e+00, 2.26325e+00, 2.22778e+00, 2.19286e+00, 2.15849e+00,
     & 2.12466e+00, 2.09136e+00, 2.05859e+00, 2.02632e+00/
       DATA (KA_MCO( 1,JT, 5),JT=1,19)  /
     & 9.12231e+00, 9.00052e+00, 8.88036e+00, 8.76180e+00, 8.64482e+00,
     & 8.52941e+00, 8.41553e+00, 8.30318e+00, 8.19233e+00, 8.08295e+00,
     & 7.97504e+00, 7.86857e+00, 7.76352e+00, 7.65987e+00, 7.55760e+00,
     & 7.45671e+00, 7.35715e+00, 7.25893e+00, 7.16202e+00/
       DATA (KA_MCO( 2,JT, 5),JT=1,19)  /
     & 8.37315e+00, 8.27808e+00, 8.18410e+00, 8.09118e+00, 7.99931e+00,
     & 7.90849e+00, 7.81871e+00, 7.72994e+00, 7.64217e+00, 7.55541e+00,
     & 7.46963e+00, 7.38482e+00, 7.30098e+00, 7.21809e+00, 7.13614e+00,
     & 7.05512e+00, 6.97502e+00, 6.89582e+00, 6.81753e+00/
       DATA (KA_MCO( 3,JT, 5),JT=1,19)  /
     & 8.14557e+00, 8.06533e+00, 7.98587e+00, 7.90720e+00, 7.82930e+00,
     & 7.75217e+00, 7.67580e+00, 7.60018e+00, 7.52530e+00, 7.45117e+00,
     & 7.37776e+00, 7.30508e+00, 7.23311e+00, 7.16186e+00, 7.09130e+00,
     & 7.02144e+00, 6.95227e+00, 6.88378e+00, 6.81596e+00/
       DATA (KA_MCO( 4,JT, 5),JT=1,19)  /
     & 8.18046e+00, 8.11056e+00, 8.04126e+00, 7.97256e+00, 7.90444e+00,
     & 7.83690e+00, 7.76994e+00, 7.70355e+00, 7.63773e+00, 7.57247e+00,
     & 7.50777e+00, 7.44362e+00, 7.38002e+00, 7.31697e+00, 7.25445e+00,
     & 7.19247e+00, 7.13101e+00, 7.07008e+00, 7.00968e+00/
       DATA (KA_MCO( 5,JT, 5),JT=1,19)  /
     & 8.30092e+00, 8.23529e+00, 8.17019e+00, 8.10559e+00, 8.04151e+00,
     & 7.97794e+00, 7.91487e+00, 7.85230e+00, 7.79022e+00, 7.72863e+00,
     & 7.66753e+00, 7.60691e+00, 7.54678e+00, 7.48711e+00, 7.42792e+00,
     & 7.36920e+00, 7.31094e+00, 7.25314e+00, 7.19580e+00/
       DATA (KA_MCO( 6,JT, 5),JT=1,19)  /
     & 8.30014e+00, 8.24466e+00, 8.18955e+00, 8.13481e+00, 8.08044e+00,
     & 8.02642e+00, 7.97277e+00, 7.91948e+00, 7.86655e+00, 7.81396e+00,
     & 7.76173e+00, 7.70985e+00, 7.65832e+00, 7.60713e+00, 7.55628e+00,
     & 7.50577e+00, 7.45560e+00, 7.40577e+00, 7.35627e+00/
       DATA (KA_MCO( 7,JT, 5),JT=1,19)  /
     & 7.95931e+00, 7.93958e+00, 7.91989e+00, 7.90025e+00, 7.88066e+00,
     & 7.86112e+00, 7.84163e+00, 7.82219e+00, 7.80279e+00, 7.78344e+00,
     & 7.76414e+00, 7.74489e+00, 7.72568e+00, 7.70653e+00, 7.68742e+00,
     & 7.66836e+00, 7.64934e+00, 7.63038e+00, 7.61146e+00/
       DATA (KA_MCO( 8,JT, 5),JT=1,19)  /
     & 9.32576e+00, 9.31747e+00, 9.30919e+00, 9.30092e+00, 9.29265e+00,
     & 9.28439e+00, 9.27613e+00, 9.26789e+00, 9.25965e+00, 9.25142e+00,
     & 9.24320e+00, 9.23498e+00, 9.22677e+00, 9.21857e+00, 9.21038e+00,
     & 9.20219e+00, 9.19401e+00, 9.18584e+00, 9.17767e+00/
       DATA (KA_MCO( 9,JT, 5),JT=1,19)  /
     & 4.13116e+00, 4.08426e+00, 4.03788e+00, 3.99204e+00, 3.94671e+00,
     & 3.90190e+00, 3.85760e+00, 3.81380e+00, 3.77049e+00, 3.72768e+00,
     & 3.68536e+00, 3.64351e+00, 3.60214e+00, 3.56124e+00, 3.52081e+00,
     & 3.48083e+00, 3.44131e+00, 3.40224e+00, 3.36361e+00/
       DATA (KA_MCO( 1,JT, 6),JT=1,19)  /
     & 1.21200e+01, 1.21580e+01, 1.21961e+01, 1.22344e+01, 1.22728e+01,
     & 1.23113e+01, 1.23499e+01, 1.23886e+01, 1.24275e+01, 1.24664e+01,
     & 1.25056e+01, 1.25448e+01, 1.25841e+01, 1.26236e+01, 1.26632e+01,
     & 1.27029e+01, 1.27428e+01, 1.27827e+01, 1.28228e+01/
       DATA (KA_MCO( 2,JT, 6),JT=1,19)  /
     & 1.25231e+01, 1.25625e+01, 1.26020e+01, 1.26417e+01, 1.26815e+01,
     & 1.27214e+01, 1.27614e+01, 1.28015e+01, 1.28418e+01, 1.28822e+01,
     & 1.29228e+01, 1.29634e+01, 1.30042e+01, 1.30451e+01, 1.30862e+01,
     & 1.31274e+01, 1.31687e+01, 1.32101e+01, 1.32517e+01/
       DATA (KA_MCO( 3,JT, 6),JT=1,19)  /
     & 1.27566e+01, 1.27983e+01, 1.28401e+01, 1.28820e+01, 1.29241e+01,
     & 1.29663e+01, 1.30087e+01, 1.30512e+01, 1.30938e+01, 1.31366e+01,
     & 1.31795e+01, 1.32225e+01, 1.32657e+01, 1.33090e+01, 1.33525e+01,
     & 1.33961e+01, 1.34399e+01, 1.34838e+01, 1.35278e+01/
       DATA (KA_MCO( 4,JT, 6),JT=1,19)  /
     & 1.27132e+01, 1.27454e+01, 1.27777e+01, 1.28101e+01, 1.28425e+01,
     & 1.28750e+01, 1.29077e+01, 1.29403e+01, 1.29731e+01, 1.30060e+01,
     & 1.30389e+01, 1.30720e+01, 1.31051e+01, 1.31383e+01, 1.31716e+01,
     & 1.32049e+01, 1.32384e+01, 1.32719e+01, 1.33055e+01/
       DATA (KA_MCO( 5,JT, 6),JT=1,19)  /
     & 1.33151e+01, 1.33523e+01, 1.33896e+01, 1.34271e+01, 1.34646e+01,
     & 1.35022e+01, 1.35400e+01, 1.35779e+01, 1.36158e+01, 1.36539e+01,
     & 1.36921e+01, 1.37303e+01, 1.37687e+01, 1.38072e+01, 1.38458e+01,
     & 1.38846e+01, 1.39234e+01, 1.39623e+01, 1.40013e+01/
       DATA (KA_MCO( 6,JT, 6),JT=1,19)  /
     & 1.41448e+01, 1.41902e+01, 1.42357e+01, 1.42814e+01, 1.43272e+01,
     & 1.43732e+01, 1.44194e+01, 1.44656e+01, 1.45121e+01, 1.45586e+01,
     & 1.46054e+01, 1.46522e+01, 1.46993e+01, 1.47464e+01, 1.47938e+01,
     & 1.48413e+01, 1.48889e+01, 1.49367e+01, 1.49846e+01/
       DATA (KA_MCO( 7,JT, 6),JT=1,19)  /
     & 1.56578e+01, 1.56938e+01, 1.57299e+01, 1.57661e+01, 1.58024e+01,
     & 1.58388e+01, 1.58752e+01, 1.59117e+01, 1.59484e+01, 1.59851e+01,
     & 1.60218e+01, 1.60587e+01, 1.60957e+01, 1.61327e+01, 1.61698e+01,
     & 1.62070e+01, 1.62443e+01, 1.62817e+01, 1.63192e+01/
       DATA (KA_MCO( 8,JT, 6),JT=1,19)  /
     & 1.73627e+01, 1.74761e+01, 1.75903e+01, 1.77052e+01, 1.78208e+01,
     & 1.79373e+01, 1.80544e+01, 1.81724e+01, 1.82911e+01, 1.84106e+01,
     & 1.85309e+01, 1.86519e+01, 1.87738e+01, 1.88964e+01, 1.90198e+01,
     & 1.91441e+01, 1.92692e+01, 1.93950e+01, 1.95217e+01/
       DATA (KA_MCO( 9,JT, 6),JT=1,19)  /
     & 7.16326e+00, 7.12921e+00, 7.09531e+00, 7.06158e+00, 7.02800e+00,
     & 6.99459e+00, 6.96133e+00, 6.92824e+00, 6.89530e+00, 6.86252e+00,
     & 6.82989e+00, 6.79742e+00, 6.76510e+00, 6.73293e+00, 6.70092e+00,
     & 6.66906e+00, 6.63736e+00, 6.60580e+00, 6.57439e+00/
       DATA (KA_MCO( 1,JT, 7),JT=1,19)  /
     & 2.09288e+01, 2.10487e+01, 2.11692e+01, 2.12904e+01, 2.14124e+01,
     & 2.15350e+01, 2.16583e+01, 2.17823e+01, 2.19070e+01, 2.20325e+01,
     & 2.21587e+01, 2.22855e+01, 2.24132e+01, 2.25415e+01, 2.26706e+01,
     & 2.28004e+01, 2.29310e+01, 2.30623e+01, 2.31943e+01/
       DATA (KA_MCO( 2,JT, 7),JT=1,19)  /
     & 2.08159e+01, 2.09509e+01, 2.10867e+01, 2.12234e+01, 2.13610e+01,
     & 2.14994e+01, 2.16388e+01, 2.17791e+01, 2.19202e+01, 2.20623e+01,
     & 2.22053e+01, 2.23493e+01, 2.24942e+01, 2.26400e+01, 2.27867e+01,
     & 2.29345e+01, 2.30831e+01, 2.32328e+01, 2.33834e+01/
       DATA (KA_MCO( 3,JT, 7),JT=1,19)  /
     & 2.10827e+01, 2.12409e+01, 2.14002e+01, 2.15608e+01, 2.17225e+01,
     & 2.18855e+01, 2.20497e+01, 2.22151e+01, 2.23818e+01, 2.25497e+01,
     & 2.27189e+01, 2.28893e+01, 2.30611e+01, 2.32341e+01, 2.34084e+01,
     & 2.35840e+01, 2.37609e+01, 2.39392e+01, 2.41188e+01/
       DATA (KA_MCO( 4,JT, 7),JT=1,19)  /
     & 2.13866e+01, 2.15772e+01, 2.17694e+01, 2.19634e+01, 2.21590e+01,
     & 2.23565e+01, 2.25556e+01, 2.27566e+01, 2.29594e+01, 2.31639e+01,
     & 2.33703e+01, 2.35785e+01, 2.37886e+01, 2.40005e+01, 2.42144e+01,
     & 2.44301e+01, 2.46477e+01, 2.48673e+01, 2.50889e+01/
       DATA (KA_MCO( 5,JT, 7),JT=1,19)  /
     & 1.93714e+01, 1.95595e+01, 1.97493e+01, 1.99410e+01, 2.01345e+01,
     & 2.03300e+01, 2.05273e+01, 2.07265e+01, 2.09277e+01, 2.11308e+01,
     & 2.13359e+01, 2.15430e+01, 2.17521e+01, 2.19632e+01, 2.21764e+01,
     & 2.23917e+01, 2.26090e+01, 2.28284e+01, 2.30500e+01/
       DATA (KA_MCO( 6,JT, 7),JT=1,19)  /
     & 1.70418e+01, 1.72109e+01, 1.73817e+01, 1.75541e+01, 1.77283e+01,
     & 1.79041e+01, 1.80818e+01, 1.82612e+01, 1.84423e+01, 1.86253e+01,
     & 1.88101e+01, 1.89967e+01, 1.91852e+01, 1.93755e+01, 1.95678e+01,
     & 1.97619e+01, 1.99580e+01, 2.01560e+01, 2.03560e+01/
       DATA (KA_MCO( 7,JT, 7),JT=1,19)  /
     & 1.31735e+01, 1.32921e+01, 1.34118e+01, 1.35326e+01, 1.36545e+01,
     & 1.37775e+01, 1.39015e+01, 1.40267e+01, 1.41531e+01, 1.42805e+01,
     & 1.44091e+01, 1.45389e+01, 1.46698e+01, 1.48019e+01, 1.49353e+01,
     & 1.50698e+01, 1.52055e+01, 1.53424e+01, 1.54806e+01/
       DATA (KA_MCO( 8,JT, 7),JT=1,19)  /
     & 4.97361e+00, 4.96550e+00, 4.95740e+00, 4.94931e+00, 4.94124e+00,
     & 4.93318e+00, 4.92513e+00, 4.91709e+00, 4.90907e+00, 4.90106e+00,
     & 4.89307e+00, 4.88509e+00, 4.87712e+00, 4.86916e+00, 4.86122e+00,
     & 4.85329e+00, 4.84537e+00, 4.83747e+00, 4.82958e+00/
       DATA (KA_MCO( 9,JT, 7),JT=1,19)  /
     & 1.76121e+01, 1.75887e+01, 1.75653e+01, 1.75420e+01, 1.75187e+01,
     & 1.74955e+01, 1.74722e+01, 1.74490e+01, 1.74259e+01, 1.74027e+01,
     & 1.73796e+01, 1.73566e+01, 1.73335e+01, 1.73105e+01, 1.72875e+01,
     & 1.72646e+01, 1.72416e+01, 1.72188e+01, 1.71959e+01/
       DATA (KA_MCO( 1,JT, 8),JT=1,19)  /
     & 5.99126e+00, 6.08386e+00, 6.17790e+00, 6.27339e+00, 6.37035e+00,
     & 6.46881e+00, 6.56880e+00, 6.67033e+00, 6.77343e+00, 6.87812e+00,
     & 6.98443e+00, 7.09238e+00, 7.20201e+00, 7.31332e+00, 7.42636e+00,
     & 7.54115e+00, 7.65771e+00, 7.77607e+00, 7.89626e+00/
       DATA (KA_MCO( 2,JT, 8),JT=1,19)  /
     & 4.71621e+00, 4.78830e+00, 4.86149e+00, 4.93580e+00, 5.01124e+00,
     & 5.08784e+00, 5.16561e+00, 5.24456e+00, 5.32473e+00, 5.40612e+00,
     & 5.48875e+00, 5.57264e+00, 5.65782e+00, 5.74430e+00, 5.83211e+00,
     & 5.92125e+00, 6.01176e+00, 6.10365e+00, 6.19694e+00/
       DATA (KA_MCO( 3,JT, 8),JT=1,19)  /
     & 2.77067e+00, 2.81437e+00, 2.85876e+00, 2.90385e+00, 2.94965e+00,
     & 2.99617e+00, 3.04343e+00, 3.09143e+00, 3.14019e+00, 3.18972e+00,
     & 3.24003e+00, 3.29114e+00, 3.34305e+00, 3.39578e+00, 3.44934e+00,
     & 3.50374e+00, 3.55901e+00, 3.61514e+00, 3.67216e+00/
       DATA (KA_MCO( 4,JT, 8),JT=1,19)  /
     & 1.22388e+00, 1.24248e+00, 1.26136e+00, 1.28053e+00, 1.29999e+00,
     & 1.31974e+00, 1.33979e+00, 1.36015e+00, 1.38082e+00, 1.40181e+00,
     & 1.42311e+00, 1.44473e+00, 1.46669e+00, 1.48897e+00, 1.51160e+00,
     & 1.53457e+00, 1.55789e+00, 1.58156e+00, 1.60559e+00/
       DATA (KA_MCO( 5,JT, 8),JT=1,19)  /
     & 1.41479e+00, 1.43540e+00, 1.45631e+00, 1.47752e+00, 1.49904e+00,
     & 1.52088e+00, 1.54303e+00, 1.56550e+00, 1.58831e+00, 1.61144e+00,
     & 1.63491e+00, 1.65872e+00, 1.68288e+00, 1.70740e+00, 1.73227e+00,
     & 1.75750e+00, 1.78310e+00, 1.80907e+00, 1.83542e+00/
       DATA (KA_MCO( 6,JT, 8),JT=1,19)  /
     & 1.43154e+00, 1.46074e+00, 1.49053e+00, 1.52093e+00, 1.55196e+00,
     & 1.58361e+00, 1.61591e+00, 1.64887e+00, 1.68250e+00, 1.71682e+00,
     & 1.75184e+00, 1.78757e+00, 1.82403e+00, 1.86123e+00, 1.89920e+00,
     & 1.93793e+00, 1.97746e+00, 2.01779e+00, 2.05895e+00/
       DATA (KA_MCO( 7,JT, 8),JT=1,19)  /
     & 2.49358e+00, 2.56028e+00, 2.62875e+00, 2.69906e+00, 2.77124e+00,
     & 2.84536e+00, 2.92146e+00, 2.99960e+00, 3.07982e+00, 3.16219e+00,
     & 3.24677e+00, 3.33360e+00, 3.42276e+00, 3.51430e+00, 3.60829e+00,
     & 3.70480e+00, 3.80388e+00, 3.90562e+00, 4.01007e+00/
       DATA (KA_MCO( 8,JT, 8),JT=1,19)  /
     & 4.32513e+00, 4.39903e+00, 4.47420e+00, 4.55065e+00, 4.62841e+00,
     & 4.70750e+00, 4.78794e+00, 4.86975e+00, 4.95296e+00, 5.03759e+00,
     & 5.12367e+00, 5.21122e+00, 5.30027e+00, 5.39084e+00, 5.48295e+00,
     & 5.57664e+00, 5.67193e+00, 5.76885e+00, 5.86743e+00/
       DATA (KA_MCO( 9,JT, 8),JT=1,19)  /
     & 3.35160e+01, 3.36789e+01, 3.38425e+01, 3.40069e+01, 3.41722e+01,
     & 3.43382e+01, 3.45050e+01, 3.46727e+01, 3.48412e+01, 3.50105e+01,
     & 3.51806e+01, 3.53515e+01, 3.55233e+01, 3.56959e+01, 3.58693e+01,
     & 3.60436e+01, 3.62187e+01, 3.63947e+01, 3.65715e+01/
       DATA (KA_MCO( 1,JT, 9),JT=1,19)  /
     & 8.68159e-01, 9.13680e-01, 9.61587e-01, 1.01201e+00, 1.06507e+00,
     & 1.12091e+00, 1.17969e+00, 1.24154e+00, 1.30664e+00, 1.37515e+00,
     & 1.44726e+00, 1.52314e+00, 1.60300e+00, 1.68705e+00, 1.77551e+00,
     & 1.86861e+00, 1.96658e+00, 2.06970e+00, 2.17822e+00/
       DATA (KA_MCO( 2,JT, 9),JT=1,19)  /
     & 9.04391e-01, 9.49669e-01, 9.97214e-01, 1.04714e+00, 1.09956e+00,
     & 1.15461e+00, 1.21242e+00, 1.27312e+00, 1.33685e+00, 1.40378e+00,
     & 1.47406e+00, 1.54786e+00, 1.62535e+00, 1.70673e+00, 1.79217e+00,
     & 1.88190e+00, 1.97611e+00, 2.07505e+00, 2.17893e+00/
       DATA (KA_MCO( 3,JT, 9),JT=1,19)  /
     & 9.67479e-01, 1.01312e+00, 1.06092e+00, 1.11098e+00, 1.16339e+00,
     & 1.21828e+00, 1.27576e+00, 1.33595e+00, 1.39898e+00, 1.46499e+00,
     & 1.53411e+00, 1.60649e+00, 1.68228e+00, 1.76165e+00, 1.84476e+00,
     & 1.93180e+00, 2.02294e+00, 2.11839e+00, 2.21833e+00/
       DATA (KA_MCO( 4,JT, 9),JT=1,19)  /
     & 1.05240e+00, 1.09817e+00, 1.14592e+00, 1.19576e+00, 1.24776e+00,
     & 1.30202e+00, 1.35864e+00, 1.41772e+00, 1.47937e+00, 1.54371e+00,
     & 1.61084e+00, 1.68089e+00, 1.75398e+00, 1.83026e+00, 1.90985e+00,
     & 1.99290e+00, 2.07957e+00, 2.17000e+00, 2.26437e+00/
       DATA (KA_MCO( 5,JT, 9),JT=1,19)  /
     & 1.25800e+00, 1.30557e+00, 1.35494e+00, 1.40618e+00, 1.45935e+00,
     & 1.51454e+00, 1.57181e+00, 1.63125e+00, 1.69293e+00, 1.75695e+00,
     & 1.82339e+00, 1.89234e+00, 1.96389e+00, 2.03816e+00, 2.11523e+00,
     & 2.19522e+00, 2.27823e+00, 2.36438e+00, 2.45378e+00/
       DATA (KA_MCO( 6,JT, 9),JT=1,19)  /
     & 1.76509e+00, 1.80550e+00, 1.84683e+00, 1.88911e+00, 1.93235e+00,
     & 1.97658e+00, 2.02183e+00, 2.06811e+00, 2.11546e+00, 2.16388e+00,
     & 2.21342e+00, 2.26408e+00, 2.31591e+00, 2.36893e+00, 2.42315e+00,
     & 2.47862e+00, 2.53536e+00, 2.59340e+00, 2.65277e+00/
       DATA (KA_MCO( 7,JT, 9),JT=1,19)  /
     & 2.03543e+00, 2.05285e+00, 2.07042e+00, 2.08815e+00, 2.10602e+00,
     & 2.12405e+00, 2.14223e+00, 2.16057e+00, 2.17907e+00, 2.19772e+00,
     & 2.21654e+00, 2.23551e+00, 2.25465e+00, 2.27395e+00, 2.29342e+00,
     & 2.31305e+00, 2.33285e+00, 2.35282e+00, 2.37296e+00/
       DATA (KA_MCO( 8,JT, 9),JT=1,19)  /
     & 3.18883e+00, 3.20538e+00, 3.22200e+00, 3.23872e+00, 3.25552e+00,
     & 3.27241e+00, 3.28939e+00, 3.30645e+00, 3.32360e+00, 3.34085e+00,
     & 3.35818e+00, 3.37560e+00, 3.39311e+00, 3.41071e+00, 3.42841e+00,
     & 3.44619e+00, 3.46407e+00, 3.48204e+00, 3.50011e+00/
       DATA (KA_MCO( 9,JT, 9),JT=1,19)  /
     & 3.97585e+00, 3.96333e+00, 3.95084e+00, 3.93839e+00, 3.92598e+00,
     & 3.91361e+00, 3.90128e+00, 3.88899e+00, 3.87674e+00, 3.86452e+00,
     & 3.85235e+00, 3.84021e+00, 3.82811e+00, 3.81605e+00, 3.80402e+00,
     & 3.79204e+00, 3.78009e+00, 3.76818e+00, 3.75631e+00/
       DATA (KA_MCO( 1,JT,10),JT=1,19)  /
     & 8.62646e-01, 9.35164e-01, 1.01378e+00, 1.09900e+00, 1.19139e+00,
     & 1.29154e+00, 1.40011e+00, 1.51781e+00, 1.64541e+00, 1.78373e+00,
     & 1.93367e+00, 2.09623e+00, 2.27245e+00, 2.46348e+00, 2.67057e+00,
     & 2.89507e+00, 3.13844e+00, 3.40227e+00, 3.68828e+00/
       DATA (KA_MCO( 2,JT,10),JT=1,19)  /
     & 8.04693e-01, 8.72167e-01, 9.45298e-01, 1.02456e+00, 1.11047e+00,
     & 1.20358e+00, 1.30450e+00, 1.41389e+00, 1.53244e+00, 1.66094e+00,
     & 1.80021e+00, 1.95115e+00, 2.11476e+00, 2.29208e+00, 2.48427e+00,
     & 2.69258e+00, 2.91835e+00, 3.16305e+00, 3.42827e+00/
       DATA (KA_MCO( 3,JT,10),JT=1,19)  /
     & 7.66566e-01, 8.24651e-01, 8.87137e-01, 9.54358e-01, 1.02667e+00,
     & 1.10447e+00, 1.18815e+00, 1.27818e+00, 1.37503e+00, 1.47922e+00,
     & 1.59131e+00, 1.71189e+00, 1.84160e+00, 1.98114e+00, 2.13126e+00,
     & 2.29275e+00, 2.46648e+00, 2.65337e+00, 2.85442e+00/
       DATA (KA_MCO( 4,JT,10),JT=1,19)  /
     & 5.40305e-01, 5.77106e-01, 6.16414e-01, 6.58400e-01, 7.03245e-01,
     & 7.51145e-01, 8.02307e-01, 8.56954e-01, 9.15323e-01, 9.77668e-01,
     & 1.04426e+00, 1.11539e+00, 1.19136e+00, 1.27250e+00, 1.35918e+00,
     & 1.45175e+00, 1.55064e+00, 1.65625e+00, 1.76906e+00/
       DATA (KA_MCO( 5,JT,10),JT=1,19)  /
     & 8.22474e-01, 8.02911e-01, 7.83814e-01, 7.65171e-01, 7.46971e-01,
     & 7.29204e-01, 7.11860e-01, 6.94928e-01, 6.78399e-01, 6.62263e-01,
     & 6.46511e-01, 6.31133e-01, 6.16122e-01, 6.01467e-01, 5.87161e-01,
     & 5.73195e-01, 5.59562e-01, 5.46252e-01, 5.33260e-01/
       DATA (KA_MCO( 6,JT,10),JT=1,19)  /
     & 1.28162e+00, 1.25110e+00, 1.22131e+00, 1.19223e+00, 1.16384e+00,
     & 1.13613e+00, 1.10908e+00, 1.08267e+00, 1.05689e+00, 1.03173e+00,
     & 1.00716e+00, 9.83184e-01, 9.59774e-01, 9.36921e-01, 9.14613e-01,
     & 8.92836e-01, 8.71577e-01, 8.50825e-01, 8.30567e-01/
       DATA (KA_MCO( 7,JT,10),JT=1,19)  /
     & 1.92679e+00, 1.90551e+00, 1.88446e+00, 1.86365e+00, 1.84307e+00,
     & 1.82271e+00, 1.80258e+00, 1.78267e+00, 1.76298e+00, 1.74351e+00,
     & 1.72425e+00, 1.70520e+00, 1.68637e+00, 1.66774e+00, 1.64932e+00,
     & 1.63111e+00, 1.61309e+00, 1.59527e+00, 1.57765e+00/
       DATA (KA_MCO( 8,JT,10),JT=1,19)  /
     & 4.66485e+00, 4.60869e+00, 4.55320e+00, 4.49838e+00, 4.44423e+00,
     & 4.39072e+00, 4.33786e+00, 4.28563e+00, 4.23404e+00, 4.18306e+00,
     & 4.13270e+00, 4.08295e+00, 4.03379e+00, 3.98523e+00, 3.93725e+00,
     & 3.88985e+00, 3.84301e+00, 3.79675e+00, 3.75104e+00/
       DATA (KA_MCO( 9,JT,10),JT=1,19)  /
     & 1.41505e+00, 1.37820e+00, 1.34232e+00, 1.30736e+00, 1.27332e+00,
     & 1.24016e+00, 1.20786e+00, 1.17641e+00, 1.14578e+00, 1.11594e+00,
     & 1.08688e+00, 1.05858e+00, 1.03101e+00, 1.00416e+00, 9.78015e-01,
     & 9.52547e-01, 9.27742e-01, 9.03583e-01, 8.80053e-01/
       DATA (KA_MCO( 1,JT,11),JT=1,19)  /
     & 3.40468e-03, 4.05994e-03, 4.84130e-03, 5.77305e-03, 6.88412e-03,
     & 8.20902e-03, 9.78890e-03, 1.16728e-02, 1.39194e-02, 1.65983e-02,
     & 1.97927e-02, 2.36020e-02, 2.81444e-02, 3.35610e-02, 4.00200e-02,
     & 4.77222e-02, 5.69067e-02, 6.78588e-02, 8.09187e-02/
       DATA (KA_MCO( 2,JT,11),JT=1,19)  /
     & 3.85021e-02, 4.02208e-02, 4.20162e-02, 4.38918e-02, 4.58512e-02,
     & 4.78980e-02, 5.00361e-02, 5.22697e-02, 5.46031e-02, 5.70405e-02,
     & 5.95868e-02, 6.22468e-02, 6.50254e-02, 6.79282e-02, 7.09605e-02,
     & 7.41282e-02, 7.74372e-02, 8.08940e-02, 8.45051e-02/
       DATA (KA_MCO( 3,JT,11),JT=1,19)  /
     & 5.24852e-01, 5.10480e-01, 4.96501e-01, 4.82905e-01, 4.69681e-01,
     & 4.56820e-01, 4.44310e-01, 4.32143e-01, 4.20310e-01, 4.08800e-01,
     & 3.97606e-01, 3.86718e-01, 3.76128e-01, 3.65828e-01, 3.55810e-01,
     & 3.46067e-01, 3.36590e-01, 3.27373e-01, 3.18409e-01/
       DATA (KA_MCO( 4,JT,11),JT=1,19)  /
     & 5.86290e-01, 5.70241e-01, 5.54632e-01, 5.39450e-01, 5.24683e-01,
     & 5.10321e-01, 4.96352e-01, 4.82765e-01, 4.69550e-01, 4.56697e-01,
     & 4.44196e-01, 4.32036e-01, 4.20210e-01, 4.08708e-01, 3.97520e-01,
     & 3.86638e-01, 3.76055e-01, 3.65761e-01, 3.55749e-01/
       DATA (KA_MCO( 5,JT,11),JT=1,19)  /
     & 1.66977e+00, 1.61807e+00, 1.56798e+00, 1.51943e+00, 1.47239e+00,
     & 1.42681e+00, 1.38264e+00, 1.33983e+00, 1.29835e+00, 1.25815e+00,
     & 1.21920e+00, 1.18146e+00, 1.14488e+00, 1.10943e+00, 1.07509e+00,
     & 1.04180e+00, 1.00955e+00, 9.78295e-01, 9.48008e-01/
       DATA (KA_MCO( 6,JT,11),JT=1,19)  /
     & 1.96627e+00, 1.90948e+00, 1.85432e+00, 1.80076e+00, 1.74875e+00,
     & 1.69823e+00, 1.64918e+00, 1.60155e+00, 1.55529e+00, 1.51036e+00,
     & 1.46674e+00, 1.42437e+00, 1.38323e+00, 1.34328e+00, 1.30448e+00,
     & 1.26680e+00, 1.23021e+00, 1.19467e+00, 1.16016e+00/
       DATA (KA_MCO( 7,JT,11),JT=1,19)  /
     & 1.67574e+00, 1.63510e+00, 1.59544e+00, 1.55674e+00, 1.51898e+00,
     & 1.48213e+00, 1.44618e+00, 1.41111e+00, 1.37688e+00, 1.34348e+00,
     & 1.31090e+00, 1.27910e+00, 1.24808e+00, 1.21780e+00, 1.18826e+00,
     & 1.15944e+00, 1.13132e+00, 1.10388e+00, 1.07710e+00/
       DATA (KA_MCO( 8,JT,11),JT=1,19)  /
     & 2.00764e+00, 1.96233e+00, 1.91803e+00, 1.87474e+00, 1.83242e+00,
     & 1.79106e+00, 1.75063e+00, 1.71111e+00, 1.67249e+00, 1.63474e+00,
     & 1.59784e+00, 1.56177e+00, 1.52652e+00, 1.49206e+00, 1.45838e+00,
     & 1.42546e+00, 1.39329e+00, 1.36184e+00, 1.33110e+00/
       DATA (KA_MCO( 9,JT,11),JT=1,19)  /
     & 1.83026e+00, 1.77349e+00, 1.71849e+00, 1.66519e+00, 1.61355e+00,
     & 1.56350e+00, 1.51501e+00, 1.46803e+00, 1.42250e+00, 1.37838e+00,
     & 1.33563e+00, 1.29421e+00, 1.25407e+00, 1.21517e+00, 1.17749e+00,
     & 1.14097e+00, 1.10558e+00, 1.07129e+00, 1.03807e+00/
       DATA (KA_MCO( 1,JT,12),JT=1,19)  /
     & 3.90309e-04, 4.81310e-04, 5.93528e-04, 7.31909e-04, 9.02554e-04,
     & 1.11299e-03, 1.37248e-03, 1.69247e-03, 2.08708e-03, 2.57368e-03,
     & 3.17374e-03, 3.91370e-03, 4.82617e-03, 5.95140e-03, 7.33897e-03,
     & 9.05007e-03, 1.11601e-02, 1.37621e-02, 1.69707e-02/
       DATA (KA_MCO( 2,JT,12),JT=1,19)  /
     & 9.80585e-02, 9.77457e-02, 9.74339e-02, 9.71231e-02, 9.68132e-02,
     & 9.65044e-02, 9.61965e-02, 9.58897e-02, 9.55838e-02, 9.52789e-02,
     & 9.49749e-02, 9.46719e-02, 9.43699e-02, 9.40689e-02, 9.37688e-02,
     & 9.34697e-02, 9.31715e-02, 9.28743e-02, 9.25780e-02/
       DATA (KA_MCO( 3,JT,12),JT=1,19)  /
     & 3.15258e-01, 3.09936e-01, 3.04704e-01, 2.99560e-01, 2.94503e-01,
     & 2.89532e-01, 2.84645e-01, 2.79840e-01, 2.75116e-01, 2.70472e-01,
     & 2.65906e-01, 2.61417e-01, 2.57004e-01, 2.52666e-01, 2.48401e-01,
     & 2.44207e-01, 2.40085e-01, 2.36032e-01, 2.32048e-01/
       DATA (KA_MCO( 4,JT,12),JT=1,19)  /
     & 9.74407e-01, 9.46900e-01, 9.20170e-01, 8.94195e-01, 8.68952e-01,
     & 8.44422e-01, 8.20585e-01, 7.97421e-01, 7.74910e-01, 7.53035e-01,
     & 7.31777e-01, 7.11120e-01, 6.91046e-01, 6.71538e-01, 6.52581e-01,
     & 6.34159e-01, 6.16257e-01, 5.98861e-01, 5.81956e-01/
       DATA (KA_MCO( 5,JT,12),JT=1,19)  /
     & 1.04234e+00, 1.01364e+00, 9.85726e-01, 9.58581e-01, 9.32184e-01,
     & 9.06514e-01, 8.81551e-01, 8.57275e-01, 8.33668e-01, 8.10710e-01,
     & 7.88385e-01, 7.66675e-01, 7.45563e-01, 7.25032e-01, 7.05066e-01,
     & 6.85650e-01, 6.66769e-01, 6.48408e-01, 6.30552e-01/
       DATA (KA_MCO( 6,JT,12),JT=1,19)  /
     & 1.79052e+00, 1.73725e+00, 1.68557e+00, 1.63543e+00, 1.58678e+00,
     & 1.53957e+00, 1.49377e+00, 1.44933e+00, 1.40622e+00, 1.36439e+00,
     & 1.32380e+00, 1.28442e+00, 1.24621e+00, 1.20913e+00, 1.17316e+00,
     & 1.13826e+00, 1.10440e+00, 1.07155e+00, 1.03967e+00/
       DATA (KA_MCO( 7,JT,12),JT=1,19)  /
     & 2.99551e+00, 2.90366e+00, 2.81462e+00, 2.72831e+00, 2.64464e+00,
     & 2.56355e+00, 2.48494e+00, 2.40874e+00, 2.33487e+00, 2.26328e+00,
     & 2.19387e+00, 2.12660e+00, 2.06139e+00, 1.99818e+00, 1.93690e+00,
     & 1.87751e+00, 1.81993e+00, 1.76413e+00, 1.71003e+00/
       DATA (KA_MCO( 8,JT,12),JT=1,19)  /
     & 2.89665e+00, 2.81184e+00, 2.72951e+00, 2.64960e+00, 2.57202e+00,
     & 2.49672e+00, 2.42362e+00, 2.35266e+00, 2.28378e+00, 2.21692e+00,
     & 2.15201e+00, 2.08900e+00, 2.02784e+00, 1.96847e+00, 1.91084e+00,
     & 1.85489e+00, 1.80059e+00, 1.74787e+00, 1.69669e+00/
       DATA (KA_MCO( 9,JT,12),JT=1,19)  /
     & 1.03145e+00, 1.00335e+00, 9.76014e-01, 9.49426e-01, 9.23561e-01,
     & 8.98402e-01, 8.73927e-01, 8.50120e-01, 8.26961e-01, 8.04433e-01,
     & 7.82518e-01, 7.61201e-01, 7.40464e-01, 7.20293e-01, 7.00670e-01,
     & 6.81583e-01, 6.63015e-01, 6.44953e-01, 6.27383e-01/
       DATA (KA_MCO( 1,JT,13),JT=1,19)  /
     & 5.27769e-04, 6.65449e-04, 8.39047e-04, 1.05793e-03, 1.33392e-03,
     & 1.68190e-03, 2.12066e-03, 2.67388e-03, 3.37143e-03, 4.25094e-03,
     & 5.35990e-03, 6.75816e-03, 8.52117e-03, 1.07441e-02, 1.35470e-02,
     & 1.70810e-02, 2.15370e-02, 2.71554e-02, 3.42395e-02/
       DATA (KA_MCO( 2,JT,13),JT=1,19)  /
     & 1.08329e-01, 1.10179e-01, 1.12060e-01, 1.13974e-01, 1.15920e-01,
     & 1.17899e-01, 1.19913e-01, 1.21960e-01, 1.24043e-01, 1.26161e-01,
     & 1.28316e-01, 1.30507e-01, 1.32735e-01, 1.35002e-01, 1.37307e-01,
     & 1.39652e-01, 1.42037e-01, 1.44462e-01, 1.46929e-01/
       DATA (KA_MCO( 3,JT,13),JT=1,19)  /
     & 1.95992e-01, 1.94515e-01, 1.93049e-01, 1.91594e-01, 1.90150e-01,
     & 1.88717e-01, 1.87294e-01, 1.85882e-01, 1.84481e-01, 1.83091e-01,
     & 1.81711e-01, 1.80341e-01, 1.78982e-01, 1.77633e-01, 1.76294e-01,
     & 1.74965e-01, 1.73646e-01, 1.72337e-01, 1.71038e-01/
       DATA (KA_MCO( 4,JT,13),JT=1,19)  /
     & 4.49766e-01, 4.42749e-01, 4.35841e-01, 4.29042e-01, 4.22348e-01,
     & 4.15759e-01, 4.09272e-01, 4.02887e-01, 3.96601e-01, 3.90414e-01,
     & 3.84323e-01, 3.78327e-01, 3.72424e-01, 3.66614e-01, 3.60894e-01,
     & 3.55264e-01, 3.49721e-01, 3.44265e-01, 3.38894e-01/
       DATA (KA_MCO( 5,JT,13),JT=1,19)  /
     & 1.07498e+00, 1.04736e+00, 1.02045e+00, 9.94232e-01, 9.68686e-01,
     & 9.43797e-01, 9.19547e-01, 8.95920e-01, 8.72900e-01, 8.50471e-01,
     & 8.28619e-01, 8.07329e-01, 7.86585e-01, 7.66374e-01, 7.46683e-01,
     & 7.27498e-01, 7.08805e-01, 6.90593e-01, 6.72849e-01/
       DATA (KA_MCO( 6,JT,13),JT=1,19)  /
     & 1.66569e+00, 1.61740e+00, 1.57052e+00, 1.52500e+00, 1.48080e+00,
     & 1.43787e+00, 1.39620e+00, 1.35573e+00, 1.31643e+00, 1.27827e+00,
     & 1.24122e+00, 1.20524e+00, 1.17031e+00, 1.13638e+00, 1.10344e+00,
     & 1.07146e+00, 1.04040e+00, 1.01025e+00, 9.80963e-01/
       DATA (KA_MCO( 7,JT,13),JT=1,19)  /
     & 1.52948e+00, 1.48763e+00, 1.44693e+00, 1.40735e+00, 1.36884e+00,
     & 1.33139e+00, 1.29497e+00, 1.25954e+00, 1.22508e+00, 1.19156e+00,
     & 1.15896e+00, 1.12725e+00, 1.09641e+00, 1.06641e+00, 1.03724e+00,
     & 1.00886e+00, 9.81259e-01, 9.54412e-01, 9.28301e-01/
       DATA (KA_MCO( 8,JT,13),JT=1,19)  /
     & 3.81027e+00, 3.69422e+00, 3.58170e+00, 3.47261e+00, 3.36684e+00,
     & 3.26429e+00, 3.16486e+00, 3.06847e+00, 2.97501e+00, 2.88439e+00,
     & 2.79654e+00, 2.71136e+00, 2.62878e+00, 2.54871e+00, 2.47108e+00,
     & 2.39581e+00, 2.32284e+00, 2.25209e+00, 2.18350e+00/
       DATA (KA_MCO( 9,JT,13),JT=1,19)  /
     & 1.12516e+00, 1.09531e+00, 1.06625e+00, 1.03796e+00, 1.01042e+00,
     & 9.83616e-01, 9.57520e-01, 9.32117e-01, 9.07387e-01, 8.83314e-01,
     & 8.59880e-01, 8.37067e-01, 8.14859e-01, 7.93241e-01, 7.72196e-01,
     & 7.51709e-01, 7.31766e-01, 7.12352e-01, 6.93454e-01/
       DATA (KA_MCO( 1,JT,14),JT=1,19)  /
     & 4.79165e-04, 6.26966e-04, 8.20356e-04, 1.07340e-03, 1.40450e-03,
     & 1.83772e-03, 2.40457e-03, 3.14628e-03, 4.11676e-03, 5.38660e-03,
     & 7.04813e-03, 9.22216e-03, 1.20668e-02, 1.57889e-02, 2.06590e-02,
     & 2.70314e-02, 3.53694e-02, 4.62792e-02, 6.05542e-02/
       DATA (KA_MCO( 2,JT,14),JT=1,19)  /
     & 4.75367e-04, 6.21987e-04, 8.13830e-04, 1.06484e-03, 1.39328e-03,
     & 1.82302e-03, 2.38530e-03, 3.12101e-03, 4.08365e-03, 5.34318e-03,
     & 6.99121e-03, 9.14756e-03, 1.19690e-02, 1.56607e-02, 2.04909e-02,
     & 2.68111e-02, 3.50806e-02, 4.59007e-02, 6.00580e-02/
       DATA (KA_MCO( 3,JT,14),JT=1,19)  /
     & 1.39594e-01, 1.42407e-01, 1.45276e-01, 1.48202e-01, 1.51188e-01,
     & 1.54234e-01, 1.57342e-01, 1.60512e-01, 1.63745e-01, 1.67044e-01,
     & 1.70410e-01, 1.73843e-01, 1.77345e-01, 1.80918e-01, 1.84563e-01,
     & 1.88282e-01, 1.92075e-01, 1.95945e-01, 1.99892e-01/
       DATA (KA_MCO( 4,JT,14),JT=1,19)  /
     & 2.73418e-01, 2.71322e-01, 2.69242e-01, 2.67177e-01, 2.65129e-01,
     & 2.63096e-01, 2.61079e-01, 2.59077e-01, 2.57091e-01, 2.55120e-01,
     & 2.53164e-01, 2.51223e-01, 2.49297e-01, 2.47386e-01, 2.45489e-01,
     & 2.43607e-01, 2.41739e-01, 2.39886e-01, 2.38047e-01/
       DATA (KA_MCO( 5,JT,14),JT=1,19)  /
     & 5.01880e-01, 4.95066e-01, 4.88344e-01, 4.81713e-01, 4.75173e-01,
     & 4.68721e-01, 4.62357e-01, 4.56079e-01, 4.49887e-01, 4.43778e-01,
     & 4.37753e-01, 4.31809e-01, 4.25946e-01, 4.20163e-01, 4.14458e-01,
     & 4.08830e-01, 4.03279e-01, 3.97804e-01, 3.92403e-01/
       DATA (KA_MCO( 6,JT,14),JT=1,19)  /
     & 9.46125e-01, 9.29642e-01, 9.13447e-01, 8.97533e-01, 8.81897e-01,
     & 8.66533e-01, 8.51437e-01, 8.36603e-01, 8.22029e-01, 8.07708e-01,
     & 7.93636e-01, 7.79810e-01, 7.66225e-01, 7.52876e-01, 7.39760e-01,
     & 7.26872e-01, 7.14209e-01, 7.01766e-01, 6.89540e-01/
       DATA (KA_MCO( 7,JT,14),JT=1,19)  /
     & 2.47697e+00, 2.41183e+00, 2.34840e+00, 2.28664e+00, 2.22650e+00,
     & 2.16795e+00, 2.11093e+00, 2.05541e+00, 2.00136e+00, 1.94872e+00,
     & 1.89747e+00, 1.84757e+00, 1.79898e+00, 1.75167e+00, 1.70560e+00,
     & 1.66074e+00, 1.61707e+00, 1.57454e+00, 1.53313e+00/
       DATA (KA_MCO( 8,JT,14),JT=1,19)  /
     & 2.19323e+00, 2.13926e+00, 2.08662e+00, 2.03528e+00, 1.98519e+00,
     & 1.93635e+00, 1.88870e+00, 1.84222e+00, 1.79689e+00, 1.75268e+00,
     & 1.70955e+00, 1.66748e+00, 1.62645e+00, 1.58643e+00, 1.54739e+00,
     & 1.50932e+00, 1.47218e+00, 1.43595e+00, 1.40062e+00/
       DATA (KA_MCO( 9,JT,14),JT=1,19)  /
     & 5.68351e-01, 5.60360e-01, 5.52481e-01, 5.44712e-01, 5.37053e-01,
     & 5.29502e-01, 5.22057e-01, 5.14716e-01, 5.07479e-01, 5.00343e-01,
     & 4.93308e-01, 4.86372e-01, 4.79533e-01, 4.72790e-01, 4.66142e-01,
     & 4.59588e-01, 4.53126e-01, 4.46754e-01, 4.40473e-01/
       DATA (KA_MCO( 1,JT,15),JT=1,19)  /
     & 7.87937e-04, 1.01733e-03, 1.31351e-03, 1.69591e-03, 2.18964e-03,
     & 2.82712e-03, 3.65018e-03, 4.71286e-03, 6.08493e-03, 7.85644e-03,
     & 1.01437e-02, 1.30969e-02, 1.69098e-02, 2.18327e-02, 2.81889e-02,
     & 3.63956e-02, 4.69915e-02, 6.06722e-02, 7.83357e-02/
       DATA (KA_MCO( 2,JT,15),JT=1,19)  /
     & 7.87937e-04, 1.01733e-03, 1.31351e-03, 1.69591e-03, 2.18964e-03,
     & 2.82712e-03, 3.65018e-03, 4.71286e-03, 6.08493e-03, 7.85644e-03,
     & 1.01437e-02, 1.30969e-02, 1.69098e-02, 2.18327e-02, 2.81889e-02,
     & 3.63956e-02, 4.69915e-02, 6.06722e-02, 7.83357e-02/
       DATA (KA_MCO( 3,JT,15),JT=1,19)  /
     & 1.97281e-01, 2.00714e-01, 2.04206e-01, 2.07760e-01, 2.11375e-01,
     & 2.15053e-01, 2.18795e-01, 2.22603e-01, 2.26476e-01, 2.30417e-01,
     & 2.34426e-01, 2.38506e-01, 2.42656e-01, 2.46878e-01, 2.51174e-01,
     & 2.55545e-01, 2.59992e-01, 2.64516e-01, 2.69119e-01/
       DATA (KA_MCO( 4,JT,15),JT=1,19)  /
     & 4.47509e-01, 4.52222e-01, 4.56985e-01, 4.61799e-01, 4.66663e-01,
     & 4.71578e-01, 4.76545e-01, 4.81565e-01, 4.86637e-01, 4.91763e-01,
     & 4.96942e-01, 5.02177e-01, 5.07466e-01, 5.12811e-01, 5.18213e-01,
     & 5.23671e-01, 5.29187e-01, 5.34761e-01, 5.40393e-01/
       DATA (KA_MCO( 5,JT,15),JT=1,19)  /
     & 1.02732e+00, 1.02091e+00, 1.01453e+00, 1.00820e+00, 1.00191e+00,
     & 9.95660e-01, 9.89447e-01, 9.83273e-01, 9.77137e-01, 9.71039e-01,
     & 9.64980e-01, 9.58958e-01, 9.52974e-01, 9.47027e-01, 9.41118e-01,
     & 9.35245e-01, 9.29409e-01, 9.23609e-01, 9.17846e-01/
       DATA (KA_MCO( 6,JT,15),JT=1,19)  /
     & 1.13766e+00, 1.12944e+00, 1.12128e+00, 1.11318e+00, 1.10514e+00,
     & 1.09715e+00, 1.08923e+00, 1.08136e+00, 1.07355e+00, 1.06579e+00,
     & 1.05809e+00, 1.05045e+00, 1.04286e+00, 1.03532e+00, 1.02784e+00,
     & 1.02042e+00, 1.01305e+00, 1.00573e+00, 9.98462e-01/
       DATA (KA_MCO( 7,JT,15),JT=1,19)  /
     & 1.13268e+00, 1.12496e+00, 1.11730e+00, 1.10969e+00, 1.10213e+00,
     & 1.09462e+00, 1.08717e+00, 1.07976e+00, 1.07241e+00, 1.06510e+00,
     & 1.05785e+00, 1.05064e+00, 1.04349e+00, 1.03638e+00, 1.02932e+00,
     & 1.02231e+00, 1.01535e+00, 1.00843e+00, 1.00156e+00/
       DATA (KA_MCO( 8,JT,15),JT=1,19)  /
     & 1.11982e+00, 1.11343e+00, 1.10707e+00, 1.10075e+00, 1.09447e+00,
     & 1.08822e+00, 1.08201e+00, 1.07583e+00, 1.06969e+00, 1.06358e+00,
     & 1.05751e+00, 1.05147e+00, 1.04547e+00, 1.03950e+00, 1.03356e+00,
     & 1.02766e+00, 1.02180e+00, 1.01596e+00, 1.01016e+00/
       DATA (KA_MCO( 9,JT,15),JT=1,19)  /
     & 1.03561e+00, 1.02902e+00, 1.02246e+00, 1.01595e+00, 1.00948e+00,
     & 1.00305e+00, 9.96667e-01, 9.90320e-01, 9.84013e-01, 9.77747e-01,
     & 9.71520e-01, 9.65334e-01, 9.59186e-01, 9.53078e-01, 9.47008e-01,
     & 9.40978e-01, 9.34985e-01, 9.29031e-01, 9.23115e-01/
       DATA (KA_MCO( 1,JT,16),JT=1,19)  /
     & 1.22217e-03, 1.56836e-03, 2.01261e-03, 2.58271e-03, 3.31429e-03,
     & 4.25310e-03, 5.45784e-03, 7.00383e-03, 8.98775e-03, 1.15336e-02,
     & 1.48007e-02, 1.89931e-02, 2.43731e-02, 3.12771e-02, 4.01367e-02,
     & 5.15059e-02, 6.60956e-02, 8.48179e-02, 1.08843e-01/
       DATA (KA_MCO( 2,JT,16),JT=1,19)  /
     & 1.22217e-03, 1.56836e-03, 2.01261e-03, 2.58271e-03, 3.31429e-03,
     & 4.25310e-03, 5.45784e-03, 7.00383e-03, 8.98775e-03, 1.15336e-02,
     & 1.48007e-02, 1.89931e-02, 2.43731e-02, 3.12771e-02, 4.01367e-02,
     & 5.15059e-02, 6.60956e-02, 8.48179e-02, 1.08843e-01/
       DATA (KA_MCO( 3,JT,16),JT=1,19)  /
     & 1.22217e-03, 1.56836e-03, 2.01261e-03, 2.58271e-03, 3.31429e-03,
     & 4.25310e-03, 5.45784e-03, 7.00383e-03, 8.98775e-03, 1.15336e-02,
     & 1.48007e-02, 1.89931e-02, 2.43731e-02, 3.12771e-02, 4.01367e-02,
     & 5.15059e-02, 6.60956e-02, 8.48179e-02, 1.08843e-01/
       DATA (KA_MCO( 4,JT,16),JT=1,19)  /
     & 1.01221e+00, 1.01660e+00, 1.02101e+00, 1.02544e+00, 1.02989e+00,
     & 1.03436e+00, 1.03884e+00, 1.04335e+00, 1.04788e+00, 1.05243e+00,
     & 1.05699e+00, 1.06158e+00, 1.06619e+00, 1.07081e+00, 1.07546e+00,
     & 1.08012e+00, 1.08481e+00, 1.08952e+00, 1.09425e+00/
       DATA (KA_MCO( 5,JT,16),JT=1,19)  /
     & 1.01221e+00, 1.01660e+00, 1.02101e+00, 1.02544e+00, 1.02989e+00,
     & 1.03436e+00, 1.03884e+00, 1.04335e+00, 1.04788e+00, 1.05243e+00,
     & 1.05699e+00, 1.06158e+00, 1.06619e+00, 1.07081e+00, 1.07546e+00,
     & 1.08012e+00, 1.08481e+00, 1.08952e+00, 1.09425e+00/
       DATA (KA_MCO( 6,JT,16),JT=1,19)  /
     & 1.01221e+00, 1.01660e+00, 1.02101e+00, 1.02544e+00, 1.02989e+00,
     & 1.03436e+00, 1.03884e+00, 1.04335e+00, 1.04788e+00, 1.05243e+00,
     & 1.05699e+00, 1.06158e+00, 1.06619e+00, 1.07081e+00, 1.07546e+00,
     & 1.08012e+00, 1.08481e+00, 1.08952e+00, 1.09425e+00/
       DATA (KA_MCO( 7,JT,16),JT=1,19)  /
     & 1.01221e+00, 1.01660e+00, 1.02101e+00, 1.02544e+00, 1.02989e+00,
     & 1.03436e+00, 1.03884e+00, 1.04335e+00, 1.04788e+00, 1.05243e+00,
     & 1.05699e+00, 1.06158e+00, 1.06619e+00, 1.07081e+00, 1.07546e+00,
     & 1.08012e+00, 1.08481e+00, 1.08952e+00, 1.09425e+00/
       DATA (KA_MCO( 8,JT,16),JT=1,19)  /
     & 1.01221e+00, 1.01660e+00, 1.02101e+00, 1.02544e+00, 1.02989e+00,
     & 1.03436e+00, 1.03884e+00, 1.04335e+00, 1.04788e+00, 1.05243e+00,
     & 1.05699e+00, 1.06158e+00, 1.06619e+00, 1.07081e+00, 1.07546e+00,
     & 1.08012e+00, 1.08481e+00, 1.08952e+00, 1.09425e+00/
       DATA (KA_MCO( 9,JT,16),JT=1,19)  /
     & 1.01221e+00, 1.01660e+00, 1.02101e+00, 1.02544e+00, 1.02989e+00,
     & 1.03436e+00, 1.03884e+00, 1.04335e+00, 1.04788e+00, 1.05243e+00,
     & 1.05699e+00, 1.06158e+00, 1.06619e+00, 1.07081e+00, 1.07546e+00,
     & 1.08012e+00, 1.08481e+00, 1.08952e+00, 1.09425e+00/

C     The array KB_Mxx contains the absorption coefficient for 
C     a minor species at the 16 chosen g-values for a reference pressure
C     level above 100~ mb.   The first index refers to temperature 
C     in 7.2 degree increments.  For instance, JT = 1 refers to a 
C     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
C     runs over the g-channel (1 to 16).

       DATA (KB_MO3(JT, 1),JT=1,19)  /
     & 1.07596e-02, 1.12146e-02, 1.16887e-02, 1.21830e-02, 1.26981e-02,
     & 1.32350e-02, 1.37946e-02, 1.43779e-02, 1.49858e-02, 1.56194e-02,
     & 1.62799e-02, 1.69682e-02, 1.76857e-02, 1.84334e-02, 1.92129e-02,
     & 2.00252e-02, 2.08719e-02, 2.17544e-02, 2.26743e-02/
       DATA (KB_MO3(JT, 2),JT=1,19)  /
     & 9.48276e-02, 9.66591e-02, 9.85260e-02, 1.00429e-01, 1.02369e-01,
     & 1.04346e-01, 1.06361e-01, 1.08416e-01, 1.10510e-01, 1.12644e-01,
     & 1.14820e-01, 1.17037e-01, 1.19298e-01, 1.21602e-01, 1.23951e-01,
     & 1.26345e-01, 1.28785e-01, 1.31273e-01, 1.33808e-01/
       DATA (KB_MO3(JT, 3),JT=1,19)  /
     & 3.54721e-01, 3.55779e-01, 3.56841e-01, 3.57906e-01, 3.58973e-01,
     & 3.60044e-01, 3.61119e-01, 3.62196e-01, 3.63277e-01, 3.64360e-01,
     & 3.65448e-01, 3.66538e-01, 3.67631e-01, 3.68728e-01, 3.69828e-01,
     & 3.70932e-01, 3.72038e-01, 3.73148e-01, 3.74262e-01/
       DATA (KB_MO3(JT, 4),JT=1,19)  /
     & 6.46454e-01, 6.43823e-01, 6.41202e-01, 6.38593e-01, 6.35994e-01,
     & 6.33405e-01, 6.30827e-01, 6.28260e-01, 6.25703e-01, 6.23156e-01,
     & 6.20620e-01, 6.18094e-01, 6.15578e-01, 6.13073e-01, 6.10578e-01,
     & 6.08093e-01, 6.05618e-01, 6.03153e-01, 6.00698e-01/
       DATA (KB_MO3(JT, 5),JT=1,19)  /
     & 9.29832e-01, 9.22877e-01, 9.15975e-01, 9.09124e-01, 9.02324e-01,
     & 8.95576e-01, 8.88877e-01, 8.82229e-01, 8.75631e-01, 8.69082e-01,
     & 8.62582e-01, 8.56130e-01, 8.49727e-01, 8.43372e-01, 8.37064e-01,
     & 8.30803e-01, 8.24589e-01, 8.18422e-01, 8.12301e-01/
       DATA (KB_MO3(JT, 6),JT=1,19)  /
     & 1.43531e+00, 1.42616e+00, 1.41706e+00, 1.40802e+00, 1.39903e+00,
     & 1.39010e+00, 1.38124e+00, 1.37242e+00, 1.36367e+00, 1.35496e+00,
     & 1.34632e+00, 1.33773e+00, 1.32919e+00, 1.32071e+00, 1.31229e+00,
     & 1.30391e+00, 1.29559e+00, 1.28733e+00, 1.27911e+00/
       DATA (KB_MO3(JT, 7),JT=1,19)  /
     & 2.68664e+00, 2.67196e+00, 2.65736e+00, 2.64284e+00, 2.62840e+00,
     & 2.61404e+00, 2.59975e+00, 2.58555e+00, 2.57142e+00, 2.55737e+00,
     & 2.54340e+00, 2.52950e+00, 2.51568e+00, 2.50193e+00, 2.48826e+00,
     & 2.47466e+00, 2.46114e+00, 2.44769e+00, 2.43432e+00/
       DATA (KB_MO3(JT, 8),JT=1,19)  /
     & 2.45343e+00, 2.43442e+00, 2.41556e+00, 2.39684e+00, 2.37827e+00,
     & 2.35984e+00, 2.34156e+00, 2.32342e+00, 2.30541e+00, 2.28755e+00,
     & 2.26983e+00, 2.25224e+00, 2.23479e+00, 2.21747e+00, 2.20029e+00,
     & 2.18324e+00, 2.16633e+00, 2.14954e+00, 2.13289e+00/
       DATA (KB_MO3(JT, 9),JT=1,19)  /
     & 1.55879e-01, 1.55998e-01, 1.56118e-01, 1.56238e-01, 1.56358e-01,
     & 1.56478e-01, 1.56599e-01, 1.56719e-01, 1.56840e-01, 1.56960e-01,
     & 1.57081e-01, 1.57201e-01, 1.57322e-01, 1.57443e-01, 1.57564e-01,
     & 1.57685e-01, 1.57806e-01, 1.57928e-01, 1.58049e-01/
       DATA (KB_MO3(JT,10),JT=1,19)  /
     & 8.75149e-03, 8.88794e-03, 9.02651e-03, 9.16725e-03, 9.31018e-03,
     & 9.45534e-03, 9.60276e-03, 9.75248e-03, 9.90454e-03, 1.00590e-02,
     & 1.02158e-02, 1.03751e-02, 1.05368e-02, 1.07011e-02, 1.08680e-02,
     & 1.10374e-02, 1.12095e-02, 1.13843e-02, 1.15618e-02/
       DATA (KB_MO3(JT,11),JT=1,19)  /
     & 8.83874e-03, 8.97926e-03, 9.12201e-03, 9.26703e-03, 9.41436e-03,
     & 9.56403e-03, 9.71608e-03, 9.87055e-03, 1.00275e-02, 1.01869e-02,
     & 1.03488e-02, 1.05134e-02, 1.06805e-02, 1.08503e-02, 1.10228e-02,
     & 1.11980e-02, 1.13761e-02, 1.15569e-02, 1.17407e-02/
       DATA (KB_MO3(JT,12),JT=1,19)  /
     & 9.59461e-03, 9.70417e-03, 9.81498e-03, 9.92705e-03, 1.00404e-02,
     & 1.01550e-02, 1.02710e-02, 1.03883e-02, 1.05069e-02, 1.06269e-02,
     & 1.07482e-02, 1.08709e-02, 1.09951e-02, 1.11206e-02, 1.12476e-02,
     & 1.13760e-02, 1.15059e-02, 1.16373e-02, 1.17702e-02/
       DATA (KB_MO3(JT,13),JT=1,19)  /
     & 1.13077e-02, 1.14079e-02, 1.15089e-02, 1.16109e-02, 1.17138e-02,
     & 1.18176e-02, 1.19223e-02, 1.20279e-02, 1.21344e-02, 1.22419e-02,
     & 1.23504e-02, 1.24598e-02, 1.25702e-02, 1.26816e-02, 1.27939e-02,
     & 1.29073e-02, 1.30216e-02, 1.31370e-02, 1.32534e-02/
       DATA (KB_MO3(JT,14),JT=1,19)  /
     & 6.74844e-03, 6.82637e-03, 6.90519e-03, 6.98493e-03, 7.06558e-03,
     & 7.14717e-03, 7.22970e-03, 7.31318e-03, 7.39762e-03, 7.48304e-03,
     & 7.56945e-03, 7.65686e-03, 7.74527e-03, 7.83470e-03, 7.92517e-03,
     & 8.01668e-03, 8.10925e-03, 8.20289e-03, 8.29761e-03/
       DATA (KB_MO3(JT,15),JT=1,19)  /
     & 7.94595e-03, 8.00015e-03, 8.05472e-03, 8.10966e-03, 8.16497e-03,
     & 8.22067e-03, 8.27674e-03, 8.33320e-03, 8.39004e-03, 8.44727e-03,
     & 8.50489e-03, 8.56290e-03, 8.62130e-03, 8.68011e-03, 8.73932e-03,
     & 8.79893e-03, 8.85895e-03, 8.91937e-03, 8.98021e-03/
       DATA (KB_MO3(JT,16),JT=1,19)  /
     & 1.85967e-03, 1.86082e-03, 1.86197e-03, 1.86312e-03, 1.86428e-03,
     & 1.86543e-03, 1.86658e-03, 1.86774e-03, 1.86889e-03, 1.87005e-03,
     & 1.87121e-03, 1.87236e-03, 1.87352e-03, 1.87468e-03, 1.87584e-03,
     & 1.87700e-03, 1.87816e-03, 1.87932e-03, 1.88049e-03/

C     The array FORREF contains the coefficient of the water vapor
C     foreign-continuum (including the energy term).  The first 
C     index refers to reference temperature (296,260,224,260) and 
C     pressure (970,475,219,3 mbar) levels.  The second index 
C     runs over the g-channel (1 to 16).

      DATA (FORREF(1,IG),IG=1,16) /
     &1.6586e-05,1.9995e-05,1.8582e-05,1.3988e-05,1.3650e-05,1.1079e-05,
     &9.5855e-06,8.4062e-06,1.3558e-05,1.8620e-05,2.2652e-05,1.7883e-05,
     &2.6241e-05,3.1171e-05,3.9386e-05,4.4415e-05/
      DATA (FORREF(2,IG),IG=1,16) /
     &2.0730e-05,2.3258e-05,2.1543e-05,1.5660e-05,9.7872e-06,8.1078e-06,
     &7.0246e-06,6.0428e-06,4.8793e-06,4.4937e-06,4.7078e-06,4.6898e-06,
     &6.9481e-06,8.6269e-06,3.1761e-06,3.1440e-06/
      DATA (FORREF(3,IG),IG=1,16) /
     &1.5737e-05,2.2501e-05,2.3520e-05,2.0288e-05,1.2083e-05,6.8256e-06,
     &6.0637e-06,5.5434e-06,4.3888e-06,3.8435e-06,3.8477e-06,3.8314e-06,
     &3.8251e-06,3.3637e-06,3.1950e-06,3.1440e-06/
      DATA (FORREF(4,IG),IG=1,16) /
     &1.1400e-05,7.9751e-06,8.8659e-06,1.5884e-05,1.9118e-05,1.9429e-05,
     &2.0532e-05,2.2155e-05,2.3894e-05,2.2984e-05,2.3731e-05,2.4538e-05,
     &2.6697e-05,1.9329e-05,3.3306e-06,3.2018e-06/

C     The array SELFREF contains the coefficient of the water vapor
C     self-continuum (including the energy term).  The first index
C     refers to temperature in 7.2 degree increments.  For instance,
C     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
C     etc.  The second index runs over the g-channel (1 to 16).

      DATA (SELFREF(JT, 1),JT=1,10)  /
     & 9.62275e-03, 8.29909e-03, 7.15750e-03, 6.17294e-03, 5.32382e-03,
     & 4.59150e-03, 3.95991e-03, 3.41520e-03, 2.94542e-03, 2.54026e-03/
      DATA (SELFREF(JT, 2),JT=1,10)  /
     & 9.76664e-03, 8.47783e-03, 7.35910e-03, 6.38799e-03, 5.54504e-03,
     & 4.81331e-03, 4.17815e-03, 3.62680e-03, 3.14821e-03, 2.73277e-03/
      DATA (SELFREF(JT, 3),JT=1,10)  /
     & 9.53856e-03, 8.23750e-03, 7.11390e-03, 6.14356e-03, 5.30558e-03,
     & 4.58190e-03, 3.95693e-03, 3.41720e-03, 2.95109e-03, 2.54856e-03/
      DATA (SELFREF(JT, 4),JT=1,10)  /
     & 8.47621e-03, 7.29518e-03, 6.27870e-03, 5.40385e-03, 4.65091e-03,
     & 4.00287e-03, 3.44513e-03, 2.96510e-03, 2.55196e-03, 2.19638e-03/
      DATA (SELFREF(JT, 5),JT=1,10)  /
     & 6.71258e-03, 5.95346e-03, 5.28020e-03, 4.68307e-03, 4.15348e-03,
     & 3.68377e-03, 3.26718e-03, 2.89770e-03, 2.57000e-03, 2.27937e-03/
      DATA (SELFREF(JT, 6),JT=1,10)  /
     & 6.29140e-03, 5.55557e-03, 4.90580e-03, 4.33203e-03, 3.82536e-03,
     & 3.37795e-03, 2.98287e-03, 2.63400e-03, 2.32593e-03, 2.05389e-03/
      DATA (SELFREF(JT, 7),JT=1,10)  /
     & 6.00229e-03, 5.28180e-03, 4.64780e-03, 4.08990e-03, 3.59897e-03,
     & 3.16696e-03, 2.78682e-03, 2.45230e-03, 2.15794e-03, 1.89891e-03/
      DATA (SELFREF(JT, 8),JT=1,10)  /
     & 5.78892e-03, 5.07191e-03, 4.44370e-03, 3.89330e-03, 3.41108e-03,
     & 2.98858e-03, 2.61842e-03, 2.29410e-03, 2.00995e-03, 1.76100e-03/
      DATA (SELFREF(JT, 9),JT=1,10)  /
     & 4.96186e-03, 4.56767e-03, 4.20480e-03, 3.87076e-03, 3.56325e-03,
     & 3.28017e-03, 3.01959e-03, 2.77970e-03, 2.55887e-03, 2.35559e-03/
      DATA (SELFREF(JT,10),JT=1,10)  /
     & 4.56849e-03, 4.35527e-03, 4.15200e-03, 3.95822e-03, 3.77348e-03,
     & 3.59736e-03, 3.42946e-03, 3.26940e-03, 3.11681e-03, 2.97134e-03/
      DATA (SELFREF(JT,11),JT=1,10)  /
     & 4.47310e-03, 4.32453e-03, 4.18090e-03, 4.04204e-03, 3.90779e-03,
     & 3.77799e-03, 3.65251e-03, 3.53120e-03, 3.41392e-03, 3.30053e-03/
      DATA (SELFREF(JT,12),JT=1,10)  /
     & 4.46459e-03, 4.24031e-03, 4.02730e-03, 3.82499e-03, 3.63284e-03,
     & 3.45035e-03, 3.27702e-03, 3.11240e-03, 2.95605e-03, 2.80755e-03/
      DATA (SELFREF(JT,13),JT=1,10)  /
     & 4.43961e-03, 4.35658e-03, 4.27510e-03, 4.19514e-03, 4.11669e-03,
     & 4.03969e-03, 3.96414e-03, 3.89000e-03, 3.81725e-03, 3.74585e-03/
      DATA (SELFREF(JT,14),JT=1,10)  /
     & 4.40512e-03, 4.41515e-03, 4.42520e-03, 4.43527e-03, 4.44537e-03,
     & 4.45549e-03, 4.46563e-03, 4.47580e-03, 4.48599e-03, 4.49620e-03/
      DATA (SELFREF(JT,15),JT=1,10)  /
     & 3.21965e-03, 3.42479e-03, 3.64300e-03, 3.87512e-03, 4.12202e-03,
     & 4.38466e-03, 4.66403e-03, 4.96120e-03, 5.27731e-03, 5.61355e-03/
      DATA (SELFREF(JT,16),JT=1,10)  /
     & 3.11402e-03, 3.35870e-03, 3.62260e-03, 3.90724e-03, 4.21424e-03,
     & 4.54536e-03, 4.90250e-03, 5.28770e-03, 5.70317e-03, 6.15128e-03/
