C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB14.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.0 $
C     created:   $Date: 2002/06/03 20:42:33 $
       PARAMETER (MG=16)
       REAL KA(5,13,MG),KB(5,13:59,MG)
       DIMENSION SELFREF(10,MG), FORREF(4,MG)

       COMMON /HVRSN14/ HVRKG14
       COMMON /K14/ KA ,KB, FORREF, SELFREF

       CHARACTER*15 HVRKG14

      DATA HVRKG14  / '$Revision: 3.0 $' /

C     The array KA contains absorption coefs for each of the 16 g-intervals
C     for a range of pressure levels > ~100mb, temperatures, and ratios
C     of water vapor to CO2.  The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.
C     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
C     to different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this  pressure 
C     level, JT = 2 refers to the temperature
C     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
C     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
C     to the reference pressure level (e.g. JP = 1 is for a
C     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA (KA(JT, 1, 1),JT=1,5) /
     &3.5183E-01,3.7165E-01,3.9536E-01,4.2364E-01,4.5645E-01/
      DATA (KA(JT, 2, 1),JT=1,5) /
     &2.9958E-01,3.1568E-01,3.3580E-01,3.6030E-01,3.8890E-01/
      DATA (KA(JT, 3, 1),JT=1,5) /
     &2.5105E-01,2.6327E-01,2.7913E-01,2.9918E-01,3.2278E-01/
      DATA (KA(JT, 4, 1),JT=1,5) /
     &2.0894E-01,2.1786E-01,2.3000E-01,2.4588E-01,2.6517E-01/
      DATA (KA(JT, 5, 1),JT=1,5) /
     &1.7343E-01,1.7993E-01,1.8907E-01,2.0143E-01,2.1685E-01/
      DATA (KA(JT, 6, 1),JT=1,5) /
     &1.4374E-01,1.4829E-01,1.5503E-01,1.6436E-01,1.7642E-01/
      DATA (KA(JT, 7, 1),JT=1,5) /
     &1.1916E-01,1.2232E-01,1.2721E-01,1.3426E-01,1.4361E-01/
      DATA (KA(JT, 8, 1),JT=1,5) /
     &9.8898E-02,1.0120E-01,1.0467E-01,1.0982E-01,1.1705E-01/
      DATA (KA(JT, 9, 1),JT=1,5) /
     &8.2212E-02,8.3740E-02,8.6244E-02,9.0121E-02,9.5602E-02/
      DATA (KA(JT,10, 1),JT=1,5) /
     &6.8330E-02,6.9351E-02,7.1210E-02,7.4137E-02,7.8349E-02/
      DATA (KA(JT,11, 1),JT=1,5) /
     &5.6910E-02,5.7856E-02,5.9557E-02,6.2211E-02,6.6055E-02/
      DATA (KA(JT,12, 1),JT=1,5) /
     &4.7279E-02,4.8187E-02,4.9716E-02,5.2169E-02,5.5693E-02/
      DATA (KA(JT,13, 1),JT=1,5) /
     &3.9228E-02,4.0055E-02,4.1480E-02,4.3734E-02,4.6826E-02/
      DATA (KA(JT, 1, 2),JT=1,5) /
     &1.2827E+00,1.3853E+00,1.5108E+00,1.6643E+00,1.8505E+00/
      DATA (KA(JT, 2, 2),JT=1,5) /
     &1.1042E+00,1.1988E+00,1.3140E+00,1.4542E+00,1.6229E+00/
      DATA (KA(JT, 3, 2),JT=1,5) /
     &9.2790E-01,1.0121E+00,1.1133E+00,1.2349E+00,1.3807E+00/
      DATA (KA(JT, 4, 2),JT=1,5) /
     &7.7001E-01,8.4339E-01,9.3172E-01,1.0366E+00,1.1604E+00/
      DATA (KA(JT, 5, 2),JT=1,5) /
     &6.3550E-01,6.9915E-01,7.7552E-01,8.6518E-01,9.7050E-01/
      DATA (KA(JT, 6, 2),JT=1,5) /
     &5.2058E-01,5.7460E-01,6.3982E-01,7.1578E-01,8.0435E-01/
      DATA (KA(JT, 7, 2),JT=1,5) /
     &4.2451E-01,4.7028E-01,5.2464E-01,5.8830E-01,6.6179E-01/
      DATA (KA(JT, 8, 2),JT=1,5) /
     &3.4539E-01,3.8222E-01,4.2607E-01,4.7789E-01,5.3786E-01/
      DATA (KA(JT, 9, 2),JT=1,5) /
     &2.7941E-01,3.0849E-01,3.4320E-01,3.8420E-01,4.3240E-01/
      DATA (KA(JT,10, 2),JT=1,5) /
     &2.2666E-01,2.5024E-01,2.7777E-01,3.1051E-01,3.4934E-01/
      DATA (KA(JT,11, 2),JT=1,5) /
     &1.9193E-01,2.1218E-01,2.3589E-01,2.6422E-01,2.9804E-01/
      DATA (KA(JT,12, 2),JT=1,5) /
     &1.6216E-01,1.7954E-01,2.0015E-01,2.2464E-01,2.5376E-01/
      DATA (KA(JT,13, 2),JT=1,5) /
     &1.3654E-01,1.5163E-01,1.6956E-01,1.9071E-01,2.1617E-01/
      DATA (KA(JT, 1, 3),JT=1,5) /
     &5.3312E+00,5.9534E+00,6.6227E+00,7.3398E+00,8.1099E+00/
      DATA (KA(JT, 2, 3),JT=1,5) /
     &4.6807E+00,5.2433E+00,5.8458E+00,6.4988E+00,7.1971E+00/
      DATA (KA(JT, 3, 3),JT=1,5) /
     &3.9284E+00,4.4200E+00,4.9505E+00,5.5235E+00,6.1336E+00/
      DATA (KA(JT, 4, 3),JT=1,5) /
     &3.2160E+00,3.6333E+00,4.0896E+00,4.5842E+00,5.1138E+00/
      DATA (KA(JT, 5, 3),JT=1,5) /
     &2.5935E+00,2.9443E+00,3.3309E+00,3.7529E+00,4.2079E+00/
      DATA (KA(JT, 6, 3),JT=1,5) /
     &2.0555E+00,2.3468E+00,2.6695E+00,3.0246E+00,3.4114E+00/
      DATA (KA(JT, 7, 3),JT=1,5) /
     &1.6122E+00,1.8522E+00,2.1211E+00,2.4178E+00,2.7436E+00/
      DATA (KA(JT, 8, 3),JT=1,5) /
     &1.2572E+00,1.4549E+00,1.6787E+00,1.9278E+00,2.2011E+00/
      DATA (KA(JT, 9, 3),JT=1,5) /
     &9.7554E-01,1.1374E+00,1.3224E+00,1.5307E+00,1.7599E+00/
      DATA (KA(JT,10, 3),JT=1,5) /
     &7.6412E-01,8.9744E-01,1.0509E+00,1.2253E+00,1.4183E+00/
      DATA (KA(JT,11, 3),JT=1,5) /
     &6.4606E-01,7.6360E-01,8.9925E-01,1.0524E+00,1.2194E+00/
      DATA (KA(JT,12, 3),JT=1,5) /
     &5.4819E-01,6.5159E-01,7.6939E-01,8.9987E-01,1.0405E+00/
      DATA (KA(JT,13, 3),JT=1,5) /
     &4.6584E-01,5.5439E-01,6.5378E-01,7.6270E-01,8.8077E-01/
      DATA (KA(JT, 1, 4),JT=1,5) /
     &1.6140E+01,1.7514E+01,1.8771E+01,1.9886E+01,2.0829E+01/
      DATA (KA(JT, 2, 4),JT=1,5) /
     &1.4035E+01,1.5167E+01,1.6185E+01,1.7079E+01,1.7864E+01/
      DATA (KA(JT, 3, 4),JT=1,5) /
     &1.2090E+01,1.3039E+01,1.3889E+01,1.4653E+01,1.5339E+01/
      DATA (KA(JT, 4, 4),JT=1,5) /
     &1.0243E+01,1.1063E+01,1.1803E+01,1.2472E+01,1.3075E+01/
      DATA (KA(JT, 5, 4),JT=1,5) /
     &8.5658E+00,9.2747E+00,9.9250E+00,1.0511E+01,1.1040E+01/
      DATA (KA(JT, 6, 4),JT=1,5) /
     &7.0689E+00,7.6839E+00,8.2525E+00,8.7702E+00,9.2411E+00/
      DATA (KA(JT, 7, 4),JT=1,5) /
     &5.7728E+00,6.3036E+00,6.7993E+00,7.2580E+00,7.6760E+00/
      DATA (KA(JT, 8, 4),JT=1,5) /
     &4.6719E+00,5.1262E+00,5.5542E+00,5.9566E+00,6.3304E+00/
      DATA (KA(JT, 9, 4),JT=1,5) /
     &3.7449E+00,4.1314E+00,4.4992E+00,4.8512E+00,5.1834E+00/
      DATA (KA(JT,10, 4),JT=1,5) /
     &2.9983E+00,3.3274E+00,3.6424E+00,3.9480E+00,4.2418E+00/
      DATA (KA(JT,11, 4),JT=1,5) /
     &2.5136E+00,2.7891E+00,3.0545E+00,3.3182E+00,3.5747E+00/
      DATA (KA(JT,12, 4),JT=1,5) /
     &2.1004E+00,2.3314E+00,2.5605E+00,2.7929E+00,3.0174E+00/
      DATA (KA(JT,13, 4),JT=1,5) /
     &1.7524E+00,1.9492E+00,2.1512E+00,2.3564E+00,2.5478E+00/
      DATA (KA(JT, 1, 5),JT=1,5) /
     &3.4724E+01,3.5203E+01,3.5615E+01,3.5967E+01,3.6300E+01/
      DATA (KA(JT, 2, 5),JT=1,5) /
     &2.9704E+01,3.0154E+01,3.0541E+01,3.0880E+01,3.1155E+01/
      DATA (KA(JT, 3, 5),JT=1,5) /
     &2.5203E+01,2.5623E+01,2.5990E+01,2.6275E+01,2.6504E+01/
      DATA (KA(JT, 4, 5),JT=1,5) /
     &2.1552E+01,2.1924E+01,2.2232E+01,2.2450E+01,2.2639E+01/
      DATA (KA(JT, 5, 5),JT=1,5) /
     &1.8513E+01,1.8836E+01,1.9081E+01,1.9246E+01,1.9410E+01/
      DATA (KA(JT, 6, 5),JT=1,5) /
     &1.5765E+01,1.6046E+01,1.6242E+01,1.6370E+01,1.6509E+01/
      DATA (KA(JT, 7, 5),JT=1,5) /
     &1.3333E+01,1.3583E+01,1.3745E+01,1.3853E+01,1.3971E+01/
      DATA (KA(JT, 8, 5),JT=1,5) /
     &1.1230E+01,1.1452E+01,1.1589E+01,1.1683E+01,1.1782E+01/
      DATA (KA(JT, 9, 5),JT=1,5) /
     &9.4196E+00,9.6109E+00,9.7356E+00,9.8175E+00,9.8960E+00/
      DATA (KA(JT,10, 5),JT=1,5) /
     &7.8743E+00,8.0366E+00,8.1439E+00,8.2124E+00,8.2768E+00/
      DATA (KA(JT,11, 5),JT=1,5) /
     &6.6265E+00,6.7386E+00,6.8161E+00,6.8681E+00,6.9329E+00/
      DATA (KA(JT,12, 5),JT=1,5) /
     &5.5390E+00,5.6241E+00,5.6817E+00,5.7305E+00,5.8031E+00/
      DATA (KA(JT,13, 5),JT=1,5) /
     &4.6094E+00,4.6772E+00,4.7246E+00,4.7737E+00,4.8549E+00/
      DATA (KA(JT, 1, 6),JT=1,5) /
     &5.5082E+01,5.5287E+01,5.5714E+01,5.6227E+01,5.6768E+01/
      DATA (KA(JT, 2, 6),JT=1,5) /
     &4.8272E+01,4.8698E+01,4.9143E+01,4.9607E+01,5.0132E+01/
      DATA (KA(JT, 3, 6),JT=1,5) /
     &4.2021E+01,4.2370E+01,4.2729E+01,4.3163E+01,4.3674E+01/
      DATA (KA(JT, 4, 6),JT=1,5) /
     &3.6214E+01,3.6443E+01,3.6742E+01,3.7158E+01,3.7640E+01/
      DATA (KA(JT, 5, 6),JT=1,5) /
     &3.1082E+01,3.1249E+01,3.1507E+01,3.1893E+01,3.2320E+01/
      DATA (KA(JT, 6, 6),JT=1,5) /
     &2.6864E+01,2.6986E+01,2.7204E+01,2.7526E+01,2.7858E+01/
      DATA (KA(JT, 7, 6),JT=1,5) /
     &2.3146E+01,2.3231E+01,2.3407E+01,2.3654E+01,2.3926E+01/
      DATA (KA(JT, 8, 6),JT=1,5) /
     &1.9819E+01,1.9868E+01,1.9994E+01,2.0178E+01,2.0400E+01/
      DATA (KA(JT, 9, 6),JT=1,5) /
     &1.6892E+01,1.6913E+01,1.7001E+01,1.7132E+01,1.7310E+01/
      DATA (KA(JT,10, 6),JT=1,5) /
     &1.4365E+01,1.4367E+01,1.4429E+01,1.4521E+01,1.4660E+01/
      DATA (KA(JT,11, 6),JT=1,5) /
     &1.2162E+01,1.2177E+01,1.2223E+01,1.2309E+01,1.2439E+01/
      DATA (KA(JT,12, 6),JT=1,5) /
     &1.0257E+01,1.0260E+01,1.0295E+01,1.0375E+01,1.0502E+01/
      DATA (KA(JT,13, 6),JT=1,5) /
     &8.6109E+00,8.6045E+00,8.6391E+00,8.7159E+00,8.8472E+00/
      DATA (KA(JT, 1, 7),JT=1,5) /
     &9.6537E+01,9.5488E+01,9.4812E+01,9.4687E+01,9.5057E+01/
      DATA (KA(JT, 2, 7),JT=1,5) /
     &8.5306E+01,8.4772E+01,8.4928E+01,8.5670E+01,8.6805E+01/
      DATA (KA(JT, 3, 7),JT=1,5) /
     &7.4847E+01,7.4994E+01,7.5806E+01,7.7131E+01,7.8782E+01/
      DATA (KA(JT, 4, 7),JT=1,5) /
     &6.5341E+01,6.6016E+01,6.7305E+01,6.9026E+01,7.0761E+01/
      DATA (KA(JT, 5, 7),JT=1,5) /
     &5.6784E+01,5.7825E+01,5.9429E+01,6.1058E+01,6.2599E+01/
      DATA (KA(JT, 6, 7),JT=1,5) /
     &4.9097E+01,5.0352E+01,5.1865E+01,5.3258E+01,5.4642E+01/
      DATA (KA(JT, 7, 7),JT=1,5) /
     &4.2608E+01,4.3857E+01,4.5074E+01,4.6282E+01,4.7459E+01/
      DATA (KA(JT, 8, 7),JT=1,5) /
     &3.7209E+01,3.8259E+01,3.9241E+01,4.0246E+01,4.1244E+01/
      DATA (KA(JT, 9, 7),JT=1,5) /
     &3.2353E+01,3.3212E+01,3.4023E+01,3.4877E+01,3.5739E+01/
      DATA (KA(JT,10, 7),JT=1,5) /
     &2.7960E+01,2.8627E+01,2.9290E+01,3.0022E+01,3.0747E+01/
      DATA (KA(JT,11, 7),JT=1,5) /
     &2.4264E+01,2.4777E+01,2.5355E+01,2.5965E+01,2.6544E+01/
      DATA (KA(JT,12, 7),JT=1,5) /
     &2.0930E+01,2.1372E+01,2.1863E+01,2.2353E+01,2.2822E+01/
      DATA (KA(JT,13, 7),JT=1,5) /
     &1.7993E+01,1.8373E+01,1.8772E+01,1.9157E+01,1.9544E+01/
      DATA (KA(JT, 1, 8),JT=1,5) /
     &2.1856E+02,2.1566E+02,2.1284E+02,2.0997E+02,2.0718E+02/
      DATA (KA(JT, 2, 8),JT=1,5) /
     &2.0300E+02,2.0022E+02,1.9750E+02,1.9481E+02,1.9235E+02/
      DATA (KA(JT, 3, 8),JT=1,5) /
     &1.8584E+02,1.8317E+02,1.8063E+02,1.7831E+02,1.7621E+02/
      DATA (KA(JT, 4, 8),JT=1,5) /
     &1.6761E+02,1.6519E+02,1.6298E+02,1.6101E+02,1.5981E+02/
      DATA (KA(JT, 5, 8),JT=1,5) /
     &1.4928E+02,1.4711E+02,1.4522E+02,1.4425E+02,1.4420E+02/
      DATA (KA(JT, 6, 8),JT=1,5) /
     &1.3122E+02,1.2933E+02,1.2822E+02,1.2825E+02,1.2918E+02/
      DATA (KA(JT, 7, 8),JT=1,5) /
     &1.1410E+02,1.1264E+02,1.1239E+02,1.1324E+02,1.1505E+02/
      DATA (KA(JT, 8, 8),JT=1,5) /
     &9.8348E+01,9.7493E+01,9.7940E+01,9.9442E+01,1.0191E+02/
      DATA (KA(JT, 9, 8),JT=1,5) /
     &8.4647E+01,8.4268E+01,8.5204E+01,8.7179E+01,9.0023E+01/
      DATA (KA(JT,10, 8),JT=1,5) /
     &7.3021E+01,7.3118E+01,7.4447E+01,7.6754E+01,7.9414E+01/
      DATA (KA(JT,11, 8),JT=1,5) /
     &6.3300E+01,6.4312E+01,6.6319E+01,6.8546E+01,7.0686E+01/
      DATA (KA(JT,12, 8),JT=1,5) /
     &5.5501E+01,5.7093E+01,5.8983E+01,6.0787E+01,6.2564E+01/
      DATA (KA(JT,13, 8),JT=1,5) /
     &4.8706E+01,5.0287E+01,5.1813E+01,5.3328E+01,5.4791E+01/
      DATA (KA(JT, 1, 9),JT=1,5) /
     &5.5934E+02,5.5574E+02,5.5144E+02,5.4673E+02,5.4155E+02/
      DATA (KA(JT, 2, 9),JT=1,5) /
     &5.7946E+02,5.7510E+02,5.7015E+02,5.6485E+02,5.5885E+02/
      DATA (KA(JT, 3, 9),JT=1,5) /
     &5.9076E+02,5.8577E+02,5.8036E+02,5.7428E+02,5.6790E+02/
      DATA (KA(JT, 4, 9),JT=1,5) /
     &5.9122E+02,5.8578E+02,5.7964E+02,5.7332E+02,5.6635E+02/
      DATA (KA(JT, 5, 9),JT=1,5) /
     &5.8028E+02,5.7411E+02,5.6769E+02,5.6068E+02,5.5353E+02/
      DATA (KA(JT, 6, 9),JT=1,5) /
     &5.5962E+02,5.5294E+02,5.4600E+02,5.3888E+02,5.3142E+02/
      DATA (KA(JT, 7, 9),JT=1,5) /
     &5.2985E+02,5.2302E+02,5.1578E+02,5.0845E+02,5.0105E+02/
      DATA (KA(JT, 8, 9),JT=1,5) /
     &4.9277E+02,4.8554E+02,4.7838E+02,4.7112E+02,4.6381E+02/
      DATA (KA(JT, 9, 9),JT=1,5) /
     &4.5092E+02,4.4373E+02,4.3650E+02,4.2952E+02,4.2278E+02/
      DATA (KA(JT,10, 9),JT=1,5) /
     &4.0542E+02,3.9841E+02,3.9162E+02,3.8505E+02,3.7968E+02/
      DATA (KA(JT,11, 9),JT=1,5) /
     &3.5669E+02,3.5010E+02,3.4395E+02,3.3923E+02,3.3643E+02/
      DATA (KA(JT,12, 9),JT=1,5) /
     &3.0992E+02,3.0411E+02,2.9975E+02,2.9742E+02,2.9692E+02/
      DATA (KA(JT,13, 9),JT=1,5) /
     &2.6703E+02,2.6279E+02,2.6062E+02,2.6039E+02,2.6194E+02/
      DATA (KA(JT, 1,10),JT=1,5) /
     &9.5667E+02,9.5651E+02,9.5375E+02,9.4993E+02,9.4458E+02/
      DATA (KA(JT, 2,10),JT=1,5) /
     &1.0737E+03,1.0712E+03,1.0675E+03,1.0621E+03,1.0554E+03/
      DATA (KA(JT, 3,10),JT=1,5) /
     &1.1862E+03,1.1837E+03,1.1793E+03,1.1732E+03,1.1657E+03/
      DATA (KA(JT, 4,10),JT=1,5) /
     &1.2923E+03,1.2885E+03,1.2837E+03,1.2762E+03,1.2683E+03/
      DATA (KA(JT, 5,10),JT=1,5) /
     &1.3860E+03,1.3831E+03,1.3760E+03,1.3692E+03,1.3583E+03/
      DATA (KA(JT, 6,10),JT=1,5) /
     &1.4574E+03,1.4515E+03,1.4451E+03,1.4344E+03,1.4246E+03/
      DATA (KA(JT, 7,10),JT=1,5) /
     &1.5032E+03,1.4948E+03,1.4847E+03,1.4737E+03,1.4593E+03/
      DATA (KA(JT, 8,10),JT=1,5) /
     &1.5178E+03,1.5093E+03,1.4967E+03,1.4828E+03,1.4689E+03/
      DATA (KA(JT, 9,10),JT=1,5) /
     &1.5009E+03,1.4874E+03,1.4751E+03,1.4596E+03,1.4422E+03/
      DATA (KA(JT,10,10),JT=1,5) /
     &1.4526E+03,1.4382E+03,1.4207E+03,1.4042E+03,1.3871E+03/
      DATA (KA(JT,11,10),JT=1,5) /
     &1.3669E+03,1.3492E+03,1.3313E+03,1.3144E+03,1.2952E+03/
      DATA (KA(JT,12,10),JT=1,5) /
     &1.2561E+03,1.2377E+03,1.2201E+03,1.2021E+03,1.1826E+03/
      DATA (KA(JT,13,10),JT=1,5) /
     &1.1367E+03,1.1187E+03,1.1007E+03,1.0822E+03,1.0635E+03/
      DATA (KA(JT, 1,11),JT=1,5) /
     &1.0788E+03,1.0784E+03,1.0786E+03,1.0769E+03,1.0720E+03/
      DATA (KA(JT, 2,11),JT=1,5) /
     &1.2360E+03,1.2387E+03,1.2382E+03,1.2346E+03,1.2287E+03/
      DATA (KA(JT, 3,11),JT=1,5) /
     &1.4028E+03,1.4050E+03,1.4041E+03,1.4005E+03,1.3939E+03/
      DATA (KA(JT, 4,11),JT=1,5) /
     &1.5761E+03,1.5770E+03,1.5755E+03,1.5691E+03,1.5622E+03/
      DATA (KA(JT, 5,11),JT=1,5) /
     &1.7429E+03,1.7443E+03,1.7409E+03,1.7348E+03,1.7262E+03/
      DATA (KA(JT, 6,11),JT=1,5) /
     &1.9004E+03,1.9007E+03,1.8945E+03,1.8893E+03,1.8776E+03/
      DATA (KA(JT, 7,11),JT=1,5) /
     &2.0382E+03,2.0344E+03,2.0314E+03,2.0213E+03,2.0121E+03/
      DATA (KA(JT, 8,11),JT=1,5) /
     &2.1442E+03,2.1390E+03,2.1319E+03,2.1222E+03,2.1076E+03/
      DATA (KA(JT, 9,11),JT=1,5) /
     &2.2113E+03,2.2063E+03,2.1931E+03,2.1796E+03,2.1631E+03/
      DATA (KA(JT,10,11),JT=1,5) /
     &2.2360E+03,2.2231E+03,2.2114E+03,2.1930E+03,2.1737E+03/
      DATA (KA(JT,11,11),JT=1,5) /
     &2.2031E+03,2.1887E+03,2.1696E+03,2.1476E+03,2.1259E+03/
      DATA (KA(JT,12,11),JT=1,5) /
     &2.1236E+03,2.1030E+03,2.0791E+03,2.0554E+03,2.0303E+03/
      DATA (KA(JT,13,11),JT=1,5) /
     &1.9976E+03,1.9732E+03,1.9489E+03,1.9244E+03,1.8976E+03/
      DATA (KA(JT, 1,12),JT=1,5) /
     &1.1934E+03,1.1955E+03,1.1958E+03,1.1936E+03,1.1920E+03/
      DATA (KA(JT, 2,12),JT=1,5) /
     &1.3945E+03,1.3970E+03,1.3984E+03,1.3987E+03,1.3979E+03/
      DATA (KA(JT, 3,12),JT=1,5) /
     &1.6215E+03,1.6249E+03,1.6252E+03,1.6264E+03,1.6242E+03/
      DATA (KA(JT, 4,12),JT=1,5) /
     &1.8681E+03,1.8729E+03,1.8755E+03,1.8766E+03,1.8729E+03/
      DATA (KA(JT, 5,12),JT=1,5) /
     &2.1302E+03,2.1346E+03,2.1412E+03,2.1410E+03,2.1383E+03/
      DATA (KA(JT, 6,12),JT=1,5) /
     &2.4029E+03,2.4115E+03,2.4156E+03,2.4143E+03,2.4101E+03/
      DATA (KA(JT, 7,12),JT=1,5) /
     &2.6748E+03,2.6869E+03,2.6879E+03,2.6884E+03,2.6793E+03/
      DATA (KA(JT, 8,12),JT=1,5) /
     &2.9380E+03,2.9477E+03,2.9496E+03,2.9469E+03,2.9380E+03/
      DATA (KA(JT, 9,12),JT=1,5) /
     &3.1781E+03,3.1822E+03,3.1866E+03,3.1790E+03,3.1694E+03/
      DATA (KA(JT,10,12),JT=1,5) /
     &3.3770E+03,3.3808E+03,3.3765E+03,3.3686E+03,3.3530E+03/
      DATA (KA(JT,11,12),JT=1,5) /
     &3.5189E+03,3.5130E+03,3.5038E+03,3.4874E+03,3.4673E+03/
      DATA (KA(JT,12,12),JT=1,5) /
     &3.5908E+03,3.5789E+03,3.5609E+03,3.5388E+03,3.5103E+03/
      DATA (KA(JT,13,12),JT=1,5) /
     &3.5806E+03,3.5582E+03,3.5338E+03,3.5034E+03,3.4725E+03/
      DATA (KA(JT, 1,13),JT=1,5) /
     &1.2919E+03,1.2953E+03,1.2979E+03,1.2980E+03,1.2956E+03/
      DATA (KA(JT, 2,13),JT=1,5) /
     &1.5383E+03,1.5420E+03,1.5447E+03,1.5440E+03,1.5420E+03/
      DATA (KA(JT, 3,13),JT=1,5) /
     &1.8220E+03,1.8287E+03,1.8322E+03,1.8325E+03,1.8308E+03/
      DATA (KA(JT, 4,13),JT=1,5) /
     &2.1443E+03,2.1550E+03,2.1609E+03,2.1623E+03,2.1617E+03/
      DATA (KA(JT, 5,13),JT=1,5) /
     &2.5123E+03,2.5251E+03,2.5330E+03,2.5368E+03,2.5365E+03/
      DATA (KA(JT, 6,13),JT=1,5) /
     &2.9214E+03,2.9360E+03,2.9475E+03,2.9537E+03,2.9558E+03/
      DATA (KA(JT, 7,13),JT=1,5) /
     &3.3684E+03,3.3871E+03,3.4024E+03,3.4082E+03,3.4125E+03/
      DATA (KA(JT, 8,13),JT=1,5) /
     &3.8472E+03,3.8701E+03,3.8882E+03,3.8980E+03,3.9031E+03/
      DATA (KA(JT, 9,13),JT=1,5) /
     &4.3463E+03,4.3744E+03,4.3907E+03,4.4045E+03,4.4088E+03/
      DATA (KA(JT,10,13),JT=1,5) /
     &4.8548E+03,4.8861E+03,4.9050E+03,4.9166E+03,4.9195E+03/
      DATA (KA(JT,11,13),JT=1,5) /
     &5.3685E+03,5.3944E+03,5.4093E+03,5.4165E+03,5.4085E+03/
      DATA (KA(JT,12,13),JT=1,5) /
     &5.8390E+03,5.8545E+03,5.8642E+03,5.8596E+03,5.8502E+03/
      DATA (KA(JT,13,13),JT=1,5) /
     &6.2371E+03,6.2518E+03,6.2489E+03,6.2389E+03,6.2163E+03/
      DATA (KA(JT, 1,14),JT=1,5) /
     &1.3744E+03,1.3784E+03,1.3801E+03,1.3822E+03,1.3833E+03/
      DATA (KA(JT, 2,14),JT=1,5) /
     &1.6525E+03,1.6579E+03,1.6603E+03,1.6628E+03,1.6635E+03/
      DATA (KA(JT, 3,14),JT=1,5) /
     &1.9810E+03,1.9908E+03,1.9968E+03,2.0006E+03,2.0007E+03/
      DATA (KA(JT, 4,14),JT=1,5) /
     &2.3728E+03,2.3844E+03,2.3938E+03,2.4019E+03,2.4042E+03/
      DATA (KA(JT, 5,14),JT=1,5) /
     &2.8373E+03,2.8532E+03,2.8650E+03,2.8745E+03,2.8783E+03/
      DATA (KA(JT, 6,14),JT=1,5) /
     &3.3748E+03,3.3991E+03,3.4179E+03,3.4320E+03,3.4378E+03/
      DATA (KA(JT, 7,14),JT=1,5) /
     &3.9998E+03,4.0298E+03,4.0539E+03,4.0746E+03,4.0866E+03/
      DATA (KA(JT, 8,14),JT=1,5) /
     &4.7196E+03,4.7615E+03,4.7914E+03,4.8146E+03,4.8273E+03/
      DATA (KA(JT, 9,14),JT=1,5) /
     &5.5304E+03,5.5847E+03,5.6275E+03,5.6623E+03,5.6782E+03/
      DATA (KA(JT,10,14),JT=1,5) /
     &6.4513E+03,6.5110E+03,6.5637E+03,6.6030E+03,6.6279E+03/
      DATA (KA(JT,11,14),JT=1,5) /
     &7.5126E+03,7.5759E+03,7.6236E+03,7.6577E+03,7.6817E+03/
      DATA (KA(JT,12,14),JT=1,5) /
     &8.6584E+03,8.7304E+03,8.7796E+03,8.8102E+03,8.8235E+03/
      DATA (KA(JT,13,14),JT=1,5) /
     &9.8812E+03,9.9499E+03,9.9974E+03,1.0022E+04,1.0029E+04/
      DATA (KA(JT, 1,15),JT=1,5) /
     &1.4528E+03,1.4581E+03,1.4601E+03,1.4582E+03,1.4558E+03/
      DATA (KA(JT, 2,15),JT=1,5) /
     &1.7546E+03,1.7631E+03,1.7666E+03,1.7671E+03,1.7653E+03/
      DATA (KA(JT, 3,15),JT=1,5) /
     &2.1167E+03,2.1275E+03,2.1344E+03,2.1393E+03,2.1396E+03/
      DATA (KA(JT, 4,15),JT=1,5) /
     &2.5536E+03,2.5679E+03,2.5752E+03,2.5829E+03,2.5878E+03/
      DATA (KA(JT, 5,15),JT=1,5) /
     &3.0751E+03,3.0964E+03,3.1097E+03,3.1178E+03,3.1252E+03/
      DATA (KA(JT, 6,15),JT=1,5) /
     &3.6981E+03,3.7293E+03,3.7501E+03,3.7620E+03,3.7738E+03/
      DATA (KA(JT, 7,15),JT=1,5) /
     &4.4451E+03,4.4852E+03,4.5165E+03,4.5355E+03,4.5519E+03/
      DATA (KA(JT, 8,15),JT=1,5) /
     &5.3398E+03,5.3890E+03,5.4280E+03,5.4575E+03,5.4832E+03/
      DATA (KA(JT, 9,15),JT=1,5) /
     &6.4016E+03,6.4666E+03,6.5191E+03,6.5509E+03,6.5855E+03/
      DATA (KA(JT,10,15),JT=1,5) /
     &7.6539E+03,7.7451E+03,7.8138E+03,7.8602E+03,7.8961E+03/
      DATA (KA(JT,11,15),JT=1,5) /
     &9.1780E+03,9.2834E+03,9.3652E+03,9.4242E+03,9.4602E+03/
      DATA (KA(JT,12,15),JT=1,5) /
     &1.0986E+04,1.1091E+04,1.1175E+04,1.1241E+04,1.1280E+04/
      DATA (KA(JT,13,15),JT=1,5) /
     &1.3095E+04,1.3203E+04,1.3280E+04,1.3335E+04,1.3364E+04/
      DATA (KA(JT, 1,16),JT=1,5) /
     &1.4758E+03,1.4811E+03,1.4822E+03,1.4873E+03,1.4919E+03/
      DATA (KA(JT, 2,16),JT=1,5) /
     &1.7931E+03,1.7988E+03,1.8023E+03,1.8054E+03,1.8115E+03/
      DATA (KA(JT, 3,16),JT=1,5) /
     &2.1801E+03,2.1858E+03,2.1915E+03,2.1950E+03,2.1996E+03/
      DATA (KA(JT, 4,16),JT=1,5) /
     &2.6497E+03,2.6575E+03,2.6648E+03,2.6696E+03,2.6752E+03/
      DATA (KA(JT, 5,16),JT=1,5) /
     &3.2162E+03,3.2298E+03,3.2415E+03,3.2482E+03,3.2542E+03/
      DATA (KA(JT, 6,16),JT=1,5) /
     &3.8965E+03,3.9207E+03,3.9398E+03,3.9520E+03,3.9556E+03/
      DATA (KA(JT, 7,16),JT=1,5) /
     &4.7145E+03,4.7502E+03,4.7821E+03,4.8036E+03,4.8122E+03/
      DATA (KA(JT, 8,16),JT=1,5) /
     &5.7091E+03,5.7519E+03,5.7946E+03,5.8300E+03,5.8477E+03/
      DATA (KA(JT, 9,16),JT=1,5) /
     &6.9081E+03,6.9691E+03,7.0079E+03,7.0618E+03,7.0936E+03/
      DATA (KA(JT,10,16),JT=1,5) /
     &8.3531E+03,8.4377E+03,8.4862E+03,8.5388E+03,8.5857E+03/
      DATA (KA(JT,11,16),JT=1,5) /
     &1.0140E+04,1.0233E+04,1.0291E+04,1.0344E+04,1.0381E+04/
      DATA (KA(JT,12,16),JT=1,5) /
     &1.2278E+04,1.2376E+04,1.2452E+04,1.2503E+04,1.2519E+04/
      DATA (KA(JT,13,16),JT=1,5) /
     &1.4816E+04,1.4930E+04,1.5014E+04,1.5052E+04,1.5044E+04/

C     The array KB contains absorption coefs at the 16 chosen g-values 
C     for a range of pressure levels < ~100mb and temperatures. The first 
C     index in the array, JT, which runs from 1 to 5, corresponds to 
C     different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this pressure 
C     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
C     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
C     The second index, JP, runs from 13 to 59 and refers to the JPth
C     reference pressure level (see taumol.f for the value of these
C     pressure levels in mb).  The third index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.
      DATA (KB(JT,13, 1),JT=1,5) /
     &3.9228E-02,4.0055E-02,4.1480E-02,4.3734E-02,4.6826E-02/
      DATA (KB(JT,14, 1),JT=1,5) /
     &3.2541E-02,3.3340E-02,3.4715E-02,3.6769E-02,3.9564E-02/
      DATA (KB(JT,15, 1),JT=1,5) /
     &2.6969E-02,2.7753E-02,2.9038E-02,3.0896E-02,3.3356E-02/
      DATA (KB(JT,16, 1),JT=1,5) /
     &2.2342E-02,2.3099E-02,2.4270E-02,2.5925E-02,2.8078E-02/
      DATA (KB(JT,17, 1),JT=1,5) /
     &1.8513E-02,1.9222E-02,2.0267E-02,2.1721E-02,2.3597E-02/
      DATA (KB(JT,18, 1),JT=1,5) /
     &1.5353E-02,1.5989E-02,1.6916E-02,1.8172E-02,1.9812E-02/
      DATA (KB(JT,19, 1),JT=1,5) /
     &1.2730E-02,1.3292E-02,1.4104E-02,1.5198E-02,1.6633E-02/
      DATA (KB(JT,20, 1),JT=1,5) /
     &1.0558E-02,1.1059E-02,1.1764E-02,1.2725E-02,1.3995E-02/
      DATA (KB(JT,21, 1),JT=1,5) /
     &8.7555E-03,9.1943E-03,9.8141E-03,1.0663E-02,1.1783E-02/
      DATA (KB(JT,22, 1),JT=1,5) /
     &7.2788E-03,7.6721E-03,8.2312E-03,8.9953E-03,1.0002E-02/
      DATA (KB(JT,23, 1),JT=1,5) /
     &6.0534E-03,6.4084E-03,6.9154E-03,7.6052E-03,8.5112E-03/
      DATA (KB(JT,24, 1),JT=1,5) /
     &5.0381E-03,5.3630E-03,5.8249E-03,6.4486E-03,7.2625E-03/
      DATA (KB(JT,25, 1),JT=1,5) /
     &4.2012E-03,4.4994E-03,4.9231E-03,5.4862E-03,6.2185E-03/
      DATA (KB(JT,26, 1),JT=1,5) /
     &3.5140E-03,3.7917E-03,4.1803E-03,4.6907E-03,5.3531E-03/
      DATA (KB(JT,27, 1),JT=1,5) /
     &2.9461E-03,3.2058E-03,3.5595E-03,4.0238E-03,4.6243E-03/
      DATA (KB(JT,28, 1),JT=1,5) /
     &2.4782E-03,2.7200E-03,3.0408E-03,3.4639E-03,4.0087E-03/
      DATA (KB(JT,29, 1),JT=1,5) /
     &2.0935E-03,2.3161E-03,2.6092E-03,2.9949E-03,3.4943E-03/
      DATA (KB(JT,30, 1),JT=1,5) /
     &1.7747E-03,1.9777E-03,2.2475E-03,2.5999E-03,3.0591E-03/
      DATA (KB(JT,31, 1),JT=1,5) /
     &1.5106E-03,1.6973E-03,1.9445E-03,2.2691E-03,2.6924E-03/
      DATA (KB(JT,32, 1),JT=1,5) /
     &1.2905E-03,1.4629E-03,1.6903E-03,1.9914E-03,2.3817E-03/
      DATA (KB(JT,33, 1),JT=1,5) /
     &1.1070E-03,1.2664E-03,1.4773E-03,1.7562E-03,2.1183E-03/
      DATA (KB(JT,34, 1),JT=1,5) /
     &9.4969E-04,1.0951E-03,1.2897E-03,1.5465E-03,1.8794E-03/
      DATA (KB(JT,35, 1),JT=1,5) /
     &8.0650E-04,9.3657E-04,1.1113E-03,1.3423E-03,1.6411E-03/
      DATA (KB(JT,36, 1),JT=1,5) /
     &6.7527E-04,7.8828E-04,9.4082E-04,1.1424E-03,1.4040E-03/
      DATA (KB(JT,37, 1),JT=1,5) /
     &5.5374E-04,6.4781E-04,7.7522E-04,9.4463E-04,1.1654E-03/
      DATA (KB(JT,38, 1),JT=1,5) /
     &4.5356E-04,5.3144E-04,6.3765E-04,7.7978E-04,9.6558E-04/
      DATA (KB(JT,39, 1),JT=1,5) /
     &3.7155E-04,4.3614E-04,5.2472E-04,6.4387E-04,8.0047E-04/
      DATA (KB(JT,40, 1),JT=1,5) /
     &2.9980E-04,3.5165E-04,4.2320E-04,5.2024E-04,6.4874E-04/
      DATA (KB(JT,41, 1),JT=1,5) /
     &2.4145E-04,2.8281E-04,3.4028E-04,4.1898E-04,5.2376E-04/
      DATA (KB(JT,42, 1),JT=1,5) /
     &1.9444E-04,2.2740E-04,2.7348E-04,3.3721E-04,4.2264E-04/
      DATA (KB(JT,43, 1),JT=1,5) /
     &1.5533E-04,1.8108E-04,2.1726E-04,2.6787E-04,3.3649E-04/
      DATA (KB(JT,44, 1),JT=1,5) /
     &1.2372E-04,1.4362E-04,1.7176E-04,2.1151E-04,2.6597E-04/
      DATA (KB(JT,45, 1),JT=1,5) /
     &9.8615E-05,1.1395E-04,1.3575E-04,1.6686E-04,2.0989E-04/
      DATA (KB(JT,46, 1),JT=1,5) /
     &7.8410E-05,9.0146E-05,1.0684E-04,1.3092E-04,1.6455E-04/
      DATA (KB(JT,47, 1),JT=1,5) /
     &6.2111E-05,7.0925E-05,8.3491E-05,1.0171E-04,1.2752E-04/
      DATA (KB(JT,48, 1),JT=1,5) /
     &4.9292E-05,5.5878E-05,6.5308E-05,7.9022E-05,9.8758E-05/
      DATA (KB(JT,49, 1),JT=1,5) /
     &3.9189E-05,4.4083E-05,5.1134E-05,6.1433E-05,7.6433E-05/
      DATA (KB(JT,50, 1),JT=1,5) /
     &3.1297E-05,3.4944E-05,4.0262E-05,4.8024E-05,5.9468E-05/
      DATA (KB(JT,51, 1),JT=1,5) /
     &2.5040E-05,2.7793E-05,3.1794E-05,3.7665E-05,4.6363E-05/
      DATA (KB(JT,52, 1),JT=1,5) /
     &2.0024E-05,2.2137E-05,2.5151E-05,2.9572E-05,3.6157E-05/
      DATA (KB(JT,53, 1),JT=1,5) /
     &1.5989E-05,1.7662E-05,1.9908E-05,2.3247E-05,2.8202E-05/
      DATA (KB(JT,54, 1),JT=1,5) /
     &1.2802E-05,1.4140E-05,1.5857E-05,1.8384E-05,2.2160E-05/
      DATA (KB(JT,55, 1),JT=1,5) /
     &1.0251E-05,1.1335E-05,1.2664E-05,1.4589E-05,1.7471E-05/
      DATA (KB(JT,56, 1),JT=1,5) /
     &8.1863E-06,9.0810E-06,1.0125E-05,1.1592E-05,1.3791E-05/
      DATA (KB(JT,57, 1),JT=1,5) /
     &6.5183E-06,7.2717E-06,8.0938E-06,9.2169E-06,1.0895E-05/
      DATA (KB(JT,58, 1),JT=1,5) /
     &5.1879E-06,5.8228E-06,6.4835E-06,7.3485E-06,8.6418E-06/
      DATA (KB(JT,59, 1),JT=1,5) /
     &4.2168E-06,4.7498E-06,5.3015E-06,6.0144E-06,7.0853E-06/
      DATA (KB(JT,13, 2),JT=1,5) /
     &1.3654E-01,1.5163E-01,1.6956E-01,1.9071E-01,2.1617E-01/
      DATA (KB(JT,14, 2),JT=1,5) /
     &1.1559E-01,1.2885E-01,1.4454E-01,1.6328E-01,1.8606E-01/
      DATA (KB(JT,15, 2),JT=1,5) /
     &9.7693E-02,1.0924E-01,1.2296E-01,1.3968E-01,1.6004E-01/
      DATA (KB(JT,16, 2),JT=1,5) /
     &8.2470E-02,9.2497E-02,1.0461E-01,1.1951E-01,1.3759E-01/
      DATA (KB(JT,17, 2),JT=1,5) /
     &6.9485E-02,7.8236E-02,8.9019E-02,1.0217E-01,1.1819E-01/
      DATA (KB(JT,18, 2),JT=1,5) /
     &5.8434E-02,6.6177E-02,7.5740E-02,8.7380E-02,1.0143E-01/
      DATA (KB(JT,19, 2),JT=1,5) /
     &4.9105E-02,5.5950E-02,6.4367E-02,7.4577E-02,8.6834E-02/
      DATA (KB(JT,20, 2),JT=1,5) /
     &4.1358E-02,4.7392E-02,5.4755E-02,6.3671E-02,7.4385E-02/
      DATA (KB(JT,21, 2),JT=1,5) /
     &3.4862E-02,4.0138E-02,4.6538E-02,5.4275E-02,6.3577E-02/
      DATA (KB(JT,22, 2),JT=1,5) /
     &2.9678E-02,3.4317E-02,3.9913E-02,4.6700E-02,5.4863E-02/
      DATA (KB(JT,23, 2),JT=1,5) /
     &2.5302E-02,2.9357E-02,3.4270E-02,4.0209E-02,4.7364E-02/
      DATA (KB(JT,24, 2),JT=1,5) /
     &2.1615E-02,2.5159E-02,2.9473E-02,3.4693E-02,4.0992E-02/
      DATA (KB(JT,25, 2),JT=1,5) /
     &1.8506E-02,2.1620E-02,2.5407E-02,3.0032E-02,3.5645E-02/
      DATA (KB(JT,26, 2),JT=1,5) /
     &1.5911E-02,1.8663E-02,2.2016E-02,2.6153E-02,3.1176E-02/
      DATA (KB(JT,27, 2),JT=1,5) /
     &1.3710E-02,1.6139E-02,1.9144E-02,2.2842E-02,2.7378E-02/
      DATA (KB(JT,28, 2),JT=1,5) /
     &1.1834E-02,1.3997E-02,1.6695E-02,2.0027E-02,2.4111E-02/
      DATA (KB(JT,29, 2),JT=1,5) /
     &1.0249E-02,1.2190E-02,1.4630E-02,1.7647E-02,2.1313E-02/
      DATA (KB(JT,30, 2),JT=1,5) /
     &8.9036E-03,1.0661E-02,1.2868E-02,1.5600E-02,1.8888E-02/
      DATA (KB(JT,31, 2),JT=1,5) /
     &7.7687E-03,9.3699E-03,1.1378E-02,1.3839E-02,1.6787E-02/
      DATA (KB(JT,32, 2),JT=1,5) /
     &6.8140E-03,8.2759E-03,1.0101E-02,1.2319E-02,1.4958E-02/
      DATA (KB(JT,33, 2),JT=1,5) /
     &6.0058E-03,7.3417E-03,8.9915E-03,1.0990E-02,1.3357E-02/
      DATA (KB(JT,34, 2),JT=1,5) /
     &5.2812E-03,6.4864E-03,7.9715E-03,9.7608E-03,1.1880E-02/
      DATA (KB(JT,35, 2),JT=1,5) /
     &4.5664E-03,5.6316E-03,6.9402E-03,8.5171E-03,1.0395E-02/
      DATA (KB(JT,36, 2),JT=1,5) /
     &3.8650E-03,4.7853E-03,5.9182E-03,7.2844E-03,8.9146E-03/
      DATA (KB(JT,37, 2),JT=1,5) /
     &3.1698E-03,3.9391E-03,4.8941E-03,6.0480E-03,7.4275E-03/
      DATA (KB(JT,38, 2),JT=1,5) /
     &2.5939E-03,3.2378E-03,4.0393E-03,5.0137E-03,6.1786E-03/
      DATA (KB(JT,39, 2),JT=1,5) /
     &2.1228E-03,2.6601E-03,3.3343E-03,4.1558E-03,5.1416E-03/
      DATA (KB(JT,40, 2),JT=1,5) /
     &1.6967E-03,2.1355E-03,2.6888E-03,3.3677E-03,4.1883E-03/
      DATA (KB(JT,41, 2),JT=1,5) /
     &1.3505E-03,1.7067E-03,2.1592E-03,2.7184E-03,3.3988E-03/
      DATA (KB(JT,42, 2),JT=1,5) /
     &1.0736E-03,1.3626E-03,1.7319E-03,2.1915E-03,2.7553E-03/
      DATA (KB(JT,43, 2),JT=1,5) /
     &8.4090E-04,1.0714E-03,1.3684E-03,1.7414E-03,2.2023E-03/
      DATA (KB(JT,44, 2),JT=1,5) /
     &6.5390E-04,8.3586E-04,1.0728E-03,1.3727E-03,1.7466E-03/
      DATA (KB(JT,45, 2),JT=1,5) /
     &5.0782E-04,6.5105E-04,8.3889E-04,1.0793E-03,1.3823E-03/
      DATA (KB(JT,46, 2),JT=1,5) /
     &3.9179E-04,5.0302E-04,6.5132E-04,8.4212E-04,1.0854E-03/
      DATA (KB(JT,47, 2),JT=1,5) /
     &2.9882E-04,3.8363E-04,4.9873E-04,6.4829E-04,8.4103E-04/
      DATA (KB(JT,48, 2),JT=1,5) /
     &2.2778E-04,2.9209E-04,3.8081E-04,4.9759E-04,6.4942E-04/
      DATA (KB(JT,49, 2),JT=1,5) /
     &1.7348E-04,2.2201E-04,2.8994E-04,3.8059E-04,4.9968E-04/
      DATA (KB(JT,50, 2),JT=1,5) /
     &1.3291E-04,1.6970E-04,2.2169E-04,2.9250E-04,3.8590E-04/
      DATA (KB(JT,51, 2),JT=1,5) /
     &1.0207E-04,1.2991E-04,1.6972E-04,2.2476E-04,2.9809E-04/
      DATA (KB(JT,52, 2),JT=1,5) /
     &7.8428E-05,9.9370E-05,1.2969E-04,1.7236E-04,2.2955E-04/
      DATA (KB(JT,53, 2),JT=1,5) /
     &6.0320E-05,7.5906E-05,9.8948E-05,1.3170E-04,1.7631E-04/
      DATA (KB(JT,54, 2),JT=1,5) /
     &4.6701E-05,5.8457E-05,7.5987E-05,1.0130E-04,1.3626E-04/
      DATA (KB(JT,55, 2),JT=1,5) /
     &3.6311E-05,4.5177E-05,5.8536E-05,7.8091E-05,1.0548E-04/
      DATA (KB(JT,56, 2),JT=1,5) /
     &2.8265E-05,3.4933E-05,4.5042E-05,6.0092E-05,8.1465E-05/
      DATA (KB(JT,57, 2),JT=1,5) /
     &2.2041E-05,2.7013E-05,3.4636E-05,4.6160E-05,6.2788E-05/
      DATA (KB(JT,58, 2),JT=1,5) /
     &1.7267E-05,2.0998E-05,2.6754E-05,3.5587E-05,4.8495E-05/
      DATA (KB(JT,59, 2),JT=1,5) /
     &1.3975E-05,1.7004E-05,2.1693E-05,2.8956E-05,3.9630E-05/
      DATA (KB(JT,13, 3),JT=1,5) /
     &4.6584E-01,5.5439E-01,6.5378E-01,7.6270E-01,8.8077E-01/
      DATA (KB(JT,14, 3),JT=1,5) /
     &4.0124E-01,4.7657E-01,5.6034E-01,6.5177E-01,7.5174E-01/
      DATA (KB(JT,15, 3),JT=1,5) /
     &3.4513E-01,4.0912E-01,4.7944E-01,5.5671E-01,6.4124E-01/
      DATA (KB(JT,16, 3),JT=1,5) /
     &2.9666E-01,3.5062E-01,4.0982E-01,4.7509E-01,5.4644E-01/
      DATA (KB(JT,17, 3),JT=1,5) /
     &2.5400E-01,2.9955E-01,3.4952E-01,4.0464E-01,4.6504E-01/
      DATA (KB(JT,18, 3),JT=1,5) /
     &2.1648E-01,2.5489E-01,2.9720E-01,3.4406E-01,3.9550E-01/
      DATA (KB(JT,19, 3),JT=1,5) /
     &1.8385E-01,2.1623E-01,2.5204E-01,2.9205E-01,3.3599E-01/
      DATA (KB(JT,20, 3),JT=1,5) /
     &1.5627E-01,1.8359E-01,2.1416E-01,2.4849E-01,2.8606E-01/
      DATA (KB(JT,21, 3),JT=1,5) /
     &1.3276E-01,1.5592E-01,1.8216E-01,2.1168E-01,2.4388E-01/
      DATA (KB(JT,22, 3),JT=1,5) /
     &1.1395E-01,1.3395E-01,1.5675E-01,1.8217E-01,2.0967E-01/
      DATA (KB(JT,23, 3),JT=1,5) /
     &9.7815E-02,1.1526E-01,1.3514E-01,1.5691E-01,1.8033E-01/
      DATA (KB(JT,24, 3),JT=1,5) /
     &8.4102E-02,9.9408E-02,1.1660E-01,1.3523E-01,1.5511E-01/
      DATA (KB(JT,25, 3),JT=1,5) /
     &7.2584E-02,8.5921E-02,1.0065E-01,1.1653E-01,1.3347E-01/
      DATA (KB(JT,26, 3),JT=1,5) /
     &6.2935E-02,7.4476E-02,8.7054E-02,1.0059E-01,1.1498E-01/
      DATA (KB(JT,27, 3),JT=1,5) /
     &5.4628E-02,6.4547E-02,7.5255E-02,8.6846E-02,9.9043E-02/
      DATA (KB(JT,28, 3),JT=1,5) /
     &4.7438E-02,5.5913E-02,6.5081E-02,7.4969E-02,8.5391E-02/
      DATA (KB(JT,29, 3),JT=1,5) /
     &4.1247E-02,4.8483E-02,5.6377E-02,6.4788E-02,7.3775E-02/
      DATA (KB(JT,30, 3),JT=1,5) /
     &3.5874E-02,4.2080E-02,4.8862E-02,5.6085E-02,6.3787E-02/
      DATA (KB(JT,31, 3),JT=1,5) /
     &3.1224E-02,3.6582E-02,4.2396E-02,4.8680E-02,5.5240E-02/
      DATA (KB(JT,32, 3),JT=1,5) /
     &2.7211E-02,3.1854E-02,3.6880E-02,4.2315E-02,4.7892E-02/
      DATA (KB(JT,33, 3),JT=1,5) /
     &2.3744E-02,2.7755E-02,3.2147E-02,3.6823E-02,4.1518E-02/
      DATA (KB(JT,34, 3),JT=1,5) /
     &2.0626E-02,2.4111E-02,2.7927E-02,3.1884E-02,3.5825E-02/
      DATA (KB(JT,35, 3),JT=1,5) /
     &1.7661E-02,2.0671E-02,2.3952E-02,2.7283E-02,3.0580E-02/
      DATA (KB(JT,36, 3),JT=1,5) /
     &1.4872E-02,1.7453E-02,2.0237E-02,2.3045E-02,2.5826E-02/
      DATA (KB(JT,37, 3),JT=1,5) /
     &1.2231E-02,1.4407E-02,1.6754E-02,1.9119E-02,2.1470E-02/
      DATA (KB(JT,38, 3),JT=1,5) /
     &1.0046E-02,1.1883E-02,1.3859E-02,1.5852E-02,1.7844E-02/
      DATA (KB(JT,39, 3),JT=1,5) /
     &8.2562E-03,9.8067E-03,1.1470E-02,1.3152E-02,1.4841E-02/
      DATA (KB(JT,40, 3),JT=1,5) /
     &6.6596E-03,7.9555E-03,9.3542E-03,1.0774E-02,1.2201E-02/
      DATA (KB(JT,41, 3),JT=1,5) /
     &5.3569E-03,6.4354E-03,7.6095E-03,8.8054E-03,1.0012E-02/
      DATA (KB(JT,42, 3),JT=1,5) /
     &4.3009E-03,5.1973E-03,6.1851E-03,7.1918E-03,8.2134E-03/
      DATA (KB(JT,43, 3),JT=1,5) /
     &3.4093E-03,4.1490E-03,4.9732E-03,5.8239E-03,6.6848E-03/
      DATA (KB(JT,44, 3),JT=1,5) /
     &2.6823E-03,3.2897E-03,3.9739E-03,4.6907E-03,5.4167E-03/
      DATA (KB(JT,45, 3),JT=1,5) /
     &2.1046E-03,2.6003E-03,3.1662E-03,3.7704E-03,4.3820E-03/
      DATA (KB(JT,46, 3),JT=1,5) /
     &1.6388E-03,2.0403E-03,2.5048E-03,3.0127E-03,3.5286E-03/
      DATA (KB(JT,47, 3),JT=1,5) /
     &1.2595E-03,1.5807E-03,1.9580E-03,2.3819E-03,2.8168E-03/
      DATA (KB(JT,48, 3),JT=1,5) /
     &9.6423E-04,1.2197E-03,1.5249E-03,1.8746E-03,2.2418E-03/
      DATA (KB(JT,49, 3),JT=1,5) /
     &7.3527E-04,9.3718E-04,1.1821E-03,1.4684E-03,1.7777E-03/
      DATA (KB(JT,50, 3),JT=1,5) /
     &5.6217E-04,7.2217E-04,9.1835E-04,1.1512E-03,1.4112E-03/
      DATA (KB(JT,51, 3),JT=1,5) /
     &4.2967E-04,5.5583E-04,7.1300E-04,9.0190E-04,1.1184E-03/
      DATA (KB(JT,52, 3),JT=1,5) /
     &3.2742E-04,4.2631E-04,5.5137E-04,7.0406E-04,8.8313E-04/
      DATA (KB(JT,53, 3),JT=1,5) /
     &2.4868E-04,3.2582E-04,4.2465E-04,5.4760E-04,6.9409E-04/
      DATA (KB(JT,54, 3),JT=1,5) /
     &1.8974E-04,2.5027E-04,3.2861E-04,4.2756E-04,5.4716E-04/
      DATA (KB(JT,55, 3),JT=1,5) /
     &1.4494E-04,1.9239E-04,2.5442E-04,3.3395E-04,4.3136E-04/
      DATA (KB(JT,56, 3),JT=1,5) /
     &1.1043E-04,1.4756E-04,1.9639E-04,2.5993E-04,3.3900E-04/
      DATA (KB(JT,57, 3),JT=1,5) /
     &8.3928E-05,1.1287E-04,1.5113E-04,2.0155E-04,2.6555E-04/
      DATA (KB(JT,58, 3),JT=1,5) /
     &6.4018E-05,8.6477E-05,1.1648E-04,1.5666E-04,2.0830E-04/
      DATA (KB(JT,59, 3),JT=1,5) /
     &5.1497E-05,6.9896E-05,9.4663E-05,1.2810E-04,1.7150E-04/
      DATA (KB(JT,13, 4),JT=1,5) /
     &1.7524E+00,1.9492E+00,2.1512E+00,2.3564E+00,2.5478E+00/
      DATA (KB(JT,14, 4),JT=1,5) /
     &1.4772E+00,1.6494E+00,1.8280E+00,2.0044E+00,2.1600E+00/
      DATA (KB(JT,15, 4),JT=1,5) /
     &1.2495E+00,1.4008E+00,1.5559E+00,1.6974E+00,1.8203E+00/
      DATA (KB(JT,16, 4),JT=1,5) /
     &1.0605E+00,1.1902E+00,1.3172E+00,1.4293E+00,1.5280E+00/
      DATA (KB(JT,17, 4),JT=1,5) /
     &8.9958E-01,1.0068E+00,1.1092E+00,1.1993E+00,1.2798E+00/
      DATA (KB(JT,18, 4),JT=1,5) /
     &7.6135E-01,8.4970E-01,9.3198E-01,1.0052E+00,1.0709E+00/
      DATA (KB(JT,19, 4),JT=1,5) /
     &6.4340E-01,7.1592E-01,7.8258E-01,8.4177E-01,8.9530E-01/
      DATA (KB(JT,20, 4),JT=1,5) /
     &5.4418E-01,6.0357E-01,6.5718E-01,7.0498E-01,7.4918E-01/
      DATA (KB(JT,21, 4),JT=1,5) /
     &4.5911E-01,5.0742E-01,5.5063E-01,5.8988E-01,6.2662E-01/
      DATA (KB(JT,22, 4),JT=1,5) /
     &3.8906E-01,4.2787E-01,4.6285E-01,4.9521E-01,5.2615E-01/
      DATA (KB(JT,23, 4),JT=1,5) /
     &3.2912E-01,3.6040E-01,3.8895E-01,4.1593E-01,4.4229E-01/
      DATA (KB(JT,24, 4),JT=1,5) /
     &2.7830E-01,3.0371E-01,3.2729E-01,3.5001E-01,3.7213E-01/
      DATA (KB(JT,25, 4),JT=1,5) /
     &2.3534E-01,2.5620E-01,2.7595E-01,2.9506E-01,3.1323E-01/
      DATA (KB(JT,26, 4),JT=1,5) /
     &1.9937E-01,2.1667E-01,2.3330E-01,2.4915E-01,2.6395E-01/
      DATA (KB(JT,27, 4),JT=1,5) /
     &1.6896E-01,1.8346E-01,1.9732E-01,2.1038E-01,2.2245E-01/
      DATA (KB(JT,28, 4),JT=1,5) /
     &1.4324E-01,1.5539E-01,1.6686E-01,1.7760E-01,1.8754E-01/
      DATA (KB(JT,29, 4),JT=1,5) /
     &1.2158E-01,1.3162E-01,1.4109E-01,1.4990E-01,1.5824E-01/
      DATA (KB(JT,30, 4),JT=1,5) /
     &1.0319E-01,1.1149E-01,1.1927E-01,1.2651E-01,1.3374E-01/
      DATA (KB(JT,31, 4),JT=1,5) /
     &8.7596E-02,9.4445E-02,1.0083E-01,1.0683E-01,1.1324E-01/
      DATA (KB(JT,32, 4),JT=1,5) /
     &7.4371E-02,7.9986E-02,8.5218E-02,9.0404E-02,9.6151E-02/
      DATA (KB(JT,33, 4),JT=1,5) /
     &6.3127E-02,6.7754E-02,7.2100E-02,7.6670E-02,8.1947E-02/
      DATA (KB(JT,34, 4),JT=1,5) /
     &5.3448E-02,5.7257E-02,6.0976E-02,6.5117E-02,6.9920E-02/
      DATA (KB(JT,35, 4),JT=1,5) /
     &4.4958E-02,4.8132E-02,5.1386E-02,5.5110E-02,5.9396E-02/
      DATA (KB(JT,36, 4),JT=1,5) /
     &3.7535E-02,4.0225E-02,4.3084E-02,4.6370E-02,5.0142E-02/
      DATA (KB(JT,37, 4),JT=1,5) /
     &3.1000E-02,3.3296E-02,3.5751E-02,3.8593E-02,4.1835E-02/
      DATA (KB(JT,38, 4),JT=1,5) /
     &2.5584E-02,2.7542E-02,2.9661E-02,3.2102E-02,3.4896E-02/
      DATA (KB(JT,39, 4),JT=1,5) /
     &2.1117E-02,2.2790E-02,2.4613E-02,2.6708E-02,2.9115E-02/
      DATA (KB(JT,40, 4),JT=1,5) /
     &1.7285E-02,1.8708E-02,2.0253E-02,2.2025E-02,2.4072E-02/
      DATA (KB(JT,41, 4),JT=1,5) /
     &1.4124E-02,1.5332E-02,1.6640E-02,1.8138E-02,1.9869E-02/
      DATA (KB(JT,42, 4),JT=1,5) /
     &1.1535E-02,1.2562E-02,1.3665E-02,1.4929E-02,1.6393E-02/
      DATA (KB(JT,43, 4),JT=1,5) /
     &9.3628E-03,1.0238E-02,1.1164E-02,1.2221E-02,1.3452E-02/
      DATA (KB(JT,44, 4),JT=1,5) /
     &7.5734E-03,8.3195E-03,9.0965E-03,9.9764E-03,1.1001E-02/
      DATA (KB(JT,45, 4),JT=1,5) /
     &6.1205E-03,6.7536E-03,7.4083E-03,8.1381E-03,8.9936E-03/
      DATA (KB(JT,46, 4),JT=1,5) /
     &4.9262E-03,5.4662E-03,6.0165E-03,6.6206E-03,7.3272E-03/
      DATA (KB(JT,47, 4),JT=1,5) /
     &3.9391E-03,4.3970E-03,4.8610E-03,5.3580E-03,5.9369E-03/
      DATA (KB(JT,48, 4),JT=1,5) /
     &3.1403E-03,3.5287E-03,3.9210E-03,4.3323E-03,4.8039E-03/
      DATA (KB(JT,49, 4),JT=1,5) /
     &2.4956E-03,2.8254E-03,3.1568E-03,3.4981E-03,3.8839E-03/
      DATA (KB(JT,50, 4),JT=1,5) /
     &1.9828E-03,2.2636E-03,2.5424E-03,2.8288E-03,3.1441E-03/
      DATA (KB(JT,51, 4),JT=1,5) /
     &1.5714E-03,1.8113E-03,2.0459E-03,2.2868E-03,2.5462E-03/
      DATA (KB(JT,52, 4),JT=1,5) /
     &1.2395E-03,1.4453E-03,1.6428E-03,1.8457E-03,2.0598E-03/
      DATA (KB(JT,53, 4),JT=1,5) /
     &9.7290E-04,1.1497E-03,1.3161E-03,1.4871E-03,1.6649E-03/
      DATA (KB(JT,54, 4),JT=1,5) /
     &7.6445E-04,9.1516E-04,1.0560E-03,1.2000E-03,1.3484E-03/
      DATA (KB(JT,55, 4),JT=1,5) /
     &5.9991E-04,7.2766E-04,8.4765E-04,9.6806E-04,1.0927E-03/
      DATA (KB(JT,56, 4),JT=1,5) /
     &4.6862E-04,5.7638E-04,6.7857E-04,7.7940E-04,8.8453E-04/
      DATA (KB(JT,57, 4),JT=1,5) /
     &3.6453E-04,4.5447E-04,5.4199E-04,6.2645E-04,7.1474E-04/
      DATA (KB(JT,58, 4),JT=1,5) /
     &2.8389E-04,3.5818E-04,4.3272E-04,5.0377E-04,5.7789E-04/
      DATA (KB(JT,59, 4),JT=1,5) /
     &2.3060E-04,2.9282E-04,3.5542E-04,4.1534E-04,4.7810E-04/
      DATA (KB(JT,13, 5),JT=1,5) /
     &4.6094E+00,4.6772E+00,4.7246E+00,4.7737E+00,4.8549E+00/
      DATA (KB(JT,14, 5),JT=1,5) /
     &3.8278E+00,3.8806E+00,3.9251E+00,3.9810E+00,4.0718E+00/
      DATA (KB(JT,15, 5),JT=1,5) /
     &3.1722E+00,3.2168E+00,3.2634E+00,3.3308E+00,3.4210E+00/
      DATA (KB(JT,16, 5),JT=1,5) /
     &2.6249E+00,2.6705E+00,2.7237E+00,2.7913E+00,2.8656E+00/
      DATA (KB(JT,17, 5),JT=1,5) /
     &2.1764E+00,2.2249E+00,2.2741E+00,2.3304E+00,2.3919E+00/
      DATA (KB(JT,18, 5),JT=1,5) /
     &1.8098E+00,1.8520E+00,1.8935E+00,1.9392E+00,1.9922E+00/
      DATA (KB(JT,19, 5),JT=1,5) /
     &1.5044E+00,1.5380E+00,1.5723E+00,1.6122E+00,1.6588E+00/
      DATA (KB(JT,20, 5),JT=1,5) /
     &1.2493E+00,1.2764E+00,1.3059E+00,1.3405E+00,1.3817E+00/
      DATA (KB(JT,21, 5),JT=1,5) /
     &1.0373E+00,1.0597E+00,1.0855E+00,1.1148E+00,1.1513E+00/
      DATA (KB(JT,22, 5),JT=1,5) /
     &8.6282E-01,8.8188E-01,9.0343E-01,9.2979E-01,9.6231E-01/
      DATA (KB(JT,23, 5),JT=1,5) /
     &7.1704E-01,7.3333E-01,7.5232E-01,7.7633E-01,8.0551E-01/
      DATA (KB(JT,24, 5),JT=1,5) /
     &5.9518E-01,6.0940E-01,6.2643E-01,6.4862E-01,6.7508E-01/
      DATA (KB(JT,25, 5),JT=1,5) /
     &4.9422E-01,5.0656E-01,5.2248E-01,5.4283E-01,5.6739E-01/
      DATA (KB(JT,26, 5),JT=1,5) /
     &4.1037E-01,4.2180E-01,4.3687E-01,4.5588E-01,4.7822E-01/
      DATA (KB(JT,27, 5),JT=1,5) /
     &3.4124E-01,3.5223E-01,3.6648E-01,3.8368E-01,4.0379E-01/
      DATA (KB(JT,28, 5),JT=1,5) /
     &2.8464E-01,2.9501E-01,3.0821E-01,3.2362E-01,3.4157E-01/
      DATA (KB(JT,29, 5),JT=1,5) /
     &2.3808E-01,2.4801E-01,2.5984E-01,2.7366E-01,2.8965E-01/
      DATA (KB(JT,30, 5),JT=1,5) /
     &1.9967E-01,2.0890E-01,2.1955E-01,2.3198E-01,2.4657E-01/
      DATA (KB(JT,31, 5),JT=1,5) /
     &1.6792E-01,1.7624E-01,1.8593E-01,1.9729E-01,2.1071E-01/
      DATA (KB(JT,32, 5),JT=1,5) /
     &1.4147E-01,1.4902E-01,1.5786E-01,1.6833E-01,1.8092E-01/
      DATA (KB(JT,33, 5),JT=1,5) /
     &1.1942E-01,1.2630E-01,1.3442E-01,1.4414E-01,1.5600E-01/
      DATA (KB(JT,34, 5),JT=1,5) /
     &1.0087E-01,1.0707E-01,1.1451E-01,1.2366E-01,1.3474E-01/
      DATA (KB(JT,35, 5),JT=1,5) /
     &8.4860E-02,9.0419E-02,9.7193E-02,1.0562E-01,1.1587E-01/
      DATA (KB(JT,36, 5),JT=1,5) /
     &7.0999E-02,7.5907E-02,8.1988E-02,8.9567E-02,9.8842E-02/
      DATA (KB(JT,37, 5),JT=1,5) /
     &5.8886E-02,6.3102E-02,6.8391E-02,7.5008E-02,8.3160E-02/
      DATA (KB(JT,38, 5),JT=1,5) /
     &4.8832E-02,5.2452E-02,5.7040E-02,6.2826E-02,7.0009E-02/
      DATA (KB(JT,39, 5),JT=1,5) /
     &4.0501E-02,4.3616E-02,4.7608E-02,5.2697E-02,5.9016E-02/
      DATA (KB(JT,40, 5),JT=1,5) /
     &3.3361E-02,3.5983E-02,3.9374E-02,4.3750E-02,4.9196E-02/
      DATA (KB(JT,41, 5),JT=1,5) /
     &2.7445E-02,2.9649E-02,3.2516E-02,3.6256E-02,4.0930E-02/
      DATA (KB(JT,42, 5),JT=1,5) /
     &2.2572E-02,2.4412E-02,2.6829E-02,3.0022E-02,3.4040E-02/
      DATA (KB(JT,43, 5),JT=1,5) /
     &1.8476E-02,1.9991E-02,2.1997E-02,2.4673E-02,2.8080E-02/
      DATA (KB(JT,44, 5),JT=1,5) /
     &1.5092E-02,1.6330E-02,1.7973E-02,2.0194E-02,2.3058E-02/
      DATA (KB(JT,45, 5),JT=1,5) /
     &1.2321E-02,1.3334E-02,1.4674E-02,1.6507E-02,1.8911E-02/
      DATA (KB(JT,46, 5),JT=1,5) /
     &1.0036E-02,1.0861E-02,1.1940E-02,1.3440E-02,1.5434E-02/
      DATA (KB(JT,47, 5),JT=1,5) /
     &8.1439E-03,8.8117E-03,9.6681E-03,1.0871E-02,1.2500E-02/
      DATA (KB(JT,48, 5),JT=1,5) /
     &6.6059E-03,7.1462E-03,7.8259E-03,8.7835E-03,1.0106E-02/
      DATA (KB(JT,49, 5),JT=1,5) /
     &5.3548E-03,5.7913E-03,6.3343E-03,7.0935E-03,8.1581E-03/
      DATA (KB(JT,50, 5),JT=1,5) /
     &4.3482E-03,4.7014E-03,5.1411E-03,5.7429E-03,6.6034E-03/
      DATA (KB(JT,51, 5),JT=1,5) /
     &3.5331E-03,3.8185E-03,4.1765E-03,4.6543E-03,5.3466E-03/
      DATA (KB(JT,52, 5),JT=1,5) /
     &2.8695E-03,3.1007E-03,3.3920E-03,3.7708E-03,4.3257E-03/
      DATA (KB(JT,53, 5),JT=1,5) /
     &2.3291E-03,2.5165E-03,2.7524E-03,3.0532E-03,3.4935E-03/
      DATA (KB(JT,54, 5),JT=1,5) /
     &1.8925E-03,2.0468E-03,2.2382E-03,2.4801E-03,2.8323E-03/
      DATA (KB(JT,55, 5),JT=1,5) /
     &1.5385E-03,1.6657E-03,1.8210E-03,2.0171E-03,2.2988E-03/
      DATA (KB(JT,56, 5),JT=1,5) /
     &1.2499E-03,1.3548E-03,1.4808E-03,1.6398E-03,1.8634E-03/
      DATA (KB(JT,57, 5),JT=1,5) /
     &1.0138E-03,1.1010E-03,1.2032E-03,1.3320E-03,1.5093E-03/
      DATA (KB(JT,58, 5),JT=1,5) /
     &8.2159E-04,8.9516E-04,9.7844E-04,1.0832E-03,1.2245E-03/
      DATA (KB(JT,59, 5),JT=1,5) /
     &6.7629E-04,7.3875E-04,8.0921E-04,8.9812E-04,1.0190E-03/
      DATA (KB(JT,13, 6),JT=1,5) /
     &8.6109E+00,8.6045E+00,8.6391E+00,8.7159E+00,8.8472E+00/
      DATA (KB(JT,14, 6),JT=1,5) /
     &7.2012E+00,7.1992E+00,7.2347E+00,7.3193E+00,7.4652E+00/
      DATA (KB(JT,15, 6),JT=1,5) /
     &6.0036E+00,6.0084E+00,6.0525E+00,6.1531E+00,6.3134E+00/
      DATA (KB(JT,16, 6),JT=1,5) /
     &4.9860E+00,4.9990E+00,5.0571E+00,5.1776E+00,5.3476E+00/
      DATA (KB(JT,17, 6),JT=1,5) /
     &4.1286E+00,4.1532E+00,4.2350E+00,4.3671E+00,4.5277E+00/
      DATA (KB(JT,18, 6),JT=1,5) /
     &3.4143E+00,3.4596E+00,3.5560E+00,3.6799E+00,3.8169E+00/
      DATA (KB(JT,19, 6),JT=1,5) /
     &2.8306E+00,2.8919E+00,2.9820E+00,3.0877E+00,3.2050E+00/
      DATA (KB(JT,20, 6),JT=1,5) /
     &2.3552E+00,2.4158E+00,2.4951E+00,2.5846E+00,2.6876E+00/
      DATA (KB(JT,21, 6),JT=1,5) /
     &1.9600E+00,2.0149E+00,2.0826E+00,2.1623E+00,2.2526E+00/
      DATA (KB(JT,22, 6),JT=1,5) /
     &1.6326E+00,1.6825E+00,1.7432E+00,1.8140E+00,1.8956E+00/
      DATA (KB(JT,23, 6),JT=1,5) /
     &1.3616E+00,1.4065E+00,1.4611E+00,1.5245E+00,1.5974E+00/
      DATA (KB(JT,24, 6),JT=1,5) /
     &1.1379E+00,1.1784E+00,1.2266E+00,1.2828E+00,1.3489E+00/
      DATA (KB(JT,25, 6),JT=1,5) /
     &9.5263E-01,9.8858E-01,1.0309E+00,1.0818E+00,1.1428E+00/
      DATA (KB(JT,26, 6),JT=1,5) /
     &7.9793E-01,8.2975E-01,8.6871E-01,9.1620E-01,9.7213E-01/
      DATA (KB(JT,27, 6),JT=1,5) /
     &6.6853E-01,6.9732E-01,7.3341E-01,7.7799E-01,8.3032E-01/
      DATA (KB(JT,28, 6),JT=1,5) /
     &5.6032E-01,5.8734E-01,6.2174E-01,6.6339E-01,7.1179E-01/
      DATA (KB(JT,29, 6),JT=1,5) /
     &4.7080E-01,4.9684E-01,5.2958E-01,5.6837E-01,6.1280E-01/
      DATA (KB(JT,30, 6),JT=1,5) /
     &3.9732E-01,4.2229E-01,4.5298E-01,4.8884E-01,5.2914E-01/
      DATA (KB(JT,31, 6),JT=1,5) /
     &3.3719E-01,3.6099E-01,3.8930E-01,4.2211E-01,4.5851E-01/
      DATA (KB(JT,32, 6),JT=1,5) /
     &2.8780E-01,3.1000E-01,3.3607E-01,3.6581E-01,3.9865E-01/
      DATA (KB(JT,33, 6),JT=1,5) /
     &2.4698E-01,2.6737E-01,2.9124E-01,3.1811E-01,3.4839E-01/
      DATA (KB(JT,34, 6),JT=1,5) /
     &2.1208E-01,2.3079E-01,2.5250E-01,2.7695E-01,3.0517E-01/
      DATA (KB(JT,35, 6),JT=1,5) /
     &1.8116E-01,1.9828E-01,2.1775E-01,2.3997E-01,2.6607E-01/
      DATA (KB(JT,36, 6),JT=1,5) /
     &1.5361E-01,1.6893E-01,1.8633E-01,2.0647E-01,2.3023E-01/
      DATA (KB(JT,37, 6),JT=1,5) /
     &1.2853E-01,1.4194E-01,1.5730E-01,1.7520E-01,1.9644E-01/
      DATA (KB(JT,38, 6),JT=1,5) /
     &1.0750E-01,1.1924E-01,1.3275E-01,1.4862E-01,1.6766E-01/
      DATA (KB(JT,39, 6),JT=1,5) /
     &8.9946E-02,1.0018E-01,1.1208E-01,1.2616E-01,1.4325E-01/
      DATA (KB(JT,40, 6),JT=1,5) /
     &7.4468E-02,8.3253E-02,9.3534E-02,1.0578E-01,1.2083E-01/
      DATA (KB(JT,41, 6),JT=1,5) /
     &6.1560E-02,6.9060E-02,7.7885E-02,8.8512E-02,1.0168E-01/
      DATA (KB(JT,42, 6),JT=1,5) /
     &5.0884E-02,5.7270E-02,6.4836E-02,7.4017E-02,8.5530E-02/
      DATA (KB(JT,43, 6),JT=1,5) /
     &4.1741E-02,4.7136E-02,5.3555E-02,6.1413E-02,7.1280E-02/
      DATA (KB(JT,44, 6),JT=1,5) /
     &3.4114E-02,3.8637E-02,4.4075E-02,5.0720E-02,5.9134E-02/
      DATA (KB(JT,45, 6),JT=1,5) /
     &2.7843E-02,3.1631E-02,3.6225E-02,4.1848E-02,4.9013E-02/
      DATA (KB(JT,46, 6),JT=1,5) /
     &2.2624E-02,2.5773E-02,2.9633E-02,3.4369E-02,4.0405E-02/
      DATA (KB(JT,47, 6),JT=1,5) /
     &1.8260E-02,2.0843E-02,2.4043E-02,2.7985E-02,3.3023E-02/
      DATA (KB(JT,48, 6),JT=1,5) /
     &1.4711E-02,1.6820E-02,1.9466E-02,2.2727E-02,2.6914E-02/
      DATA (KB(JT,49, 6),JT=1,5) /
     &1.1827E-02,1.3542E-02,1.5709E-02,1.8410E-02,2.1875E-02/
      DATA (KB(JT,50, 6),JT=1,5) /
     &9.5219E-03,1.0923E-02,1.2699E-02,1.4938E-02,1.7808E-02/
      DATA (KB(JT,51, 6),JT=1,5) /
     &7.6687E-03,8.8049E-03,1.0259E-02,1.2113E-02,1.4495E-02/
      DATA (KB(JT,52, 6),JT=1,5) /
     &6.1732E-03,7.0853E-03,8.2719E-03,9.7966E-03,1.1770E-02/
      DATA (KB(JT,53, 6),JT=1,5) /
     &4.9698E-03,5.6903E-03,6.6530E-03,7.9081E-03,9.5294E-03/
      DATA (KB(JT,54, 6),JT=1,5) /
     &4.0149E-03,4.5833E-03,5.3685E-03,6.4021E-03,7.7450E-03/
      DATA (KB(JT,55, 6),JT=1,5) /
     &3.2497E-03,3.6951E-03,4.3359E-03,5.1870E-03,6.3011E-03/
      DATA (KB(JT,56, 6),JT=1,5) /
     &2.6325E-03,2.9773E-03,3.4964E-03,4.1937E-03,5.1170E-03/
      DATA (KB(JT,57, 6),JT=1,5) /
     &2.1354E-03,2.3977E-03,2.8151E-03,3.3845E-03,4.1468E-03/
      DATA (KB(JT,58, 6),JT=1,5) /
     &1.7364E-03,1.9358E-03,2.2698E-03,2.7348E-03,3.3639E-03/
      DATA (KB(JT,59, 6),JT=1,5) /
     &1.4324E-03,1.6023E-03,1.8879E-03,2.2888E-03,2.8370E-03/
      DATA (KB(JT,13, 7),JT=1,5) /
     &1.7993E+01,1.8373E+01,1.8772E+01,1.9157E+01,1.9544E+01/
      DATA (KB(JT,14, 7),JT=1,5) /
     &1.5395E+01,1.5713E+01,1.6031E+01,1.6348E+01,1.6675E+01/
      DATA (KB(JT,15, 7),JT=1,5) /
     &1.3087E+01,1.3328E+01,1.3586E+01,1.3851E+01,1.4166E+01/
      DATA (KB(JT,16, 7),JT=1,5) /
     &1.1053E+01,1.1254E+01,1.1469E+01,1.1711E+01,1.2037E+01/
      DATA (KB(JT,17, 7),JT=1,5) /
     &9.3076E+00,9.4744E+00,9.6627E+00,9.9088E+00,1.0257E+01/
      DATA (KB(JT,18, 7),JT=1,5) /
     &7.8193E+00,7.9665E+00,8.1534E+00,8.4211E+00,8.7715E+00/
      DATA (KB(JT,19, 7),JT=1,5) /
     &6.5448E+00,6.6861E+00,6.8916E+00,7.1741E+00,7.4962E+00/
      DATA (KB(JT,20, 7),JT=1,5) /
     &5.4651E+00,5.6202E+00,5.8422E+00,6.1124E+00,6.3952E+00/
      DATA (KB(JT,21, 7),JT=1,5) /
     &4.5716E+00,4.7392E+00,4.9589E+00,5.1951E+00,5.4343E+00/
      DATA (KB(JT,22, 7),JT=1,5) /
     &3.8421E+00,4.0181E+00,4.2111E+00,4.4111E+00,4.6135E+00/
      DATA (KB(JT,23, 7),JT=1,5) /
     &3.2420E+00,3.4014E+00,3.5676E+00,3.7366E+00,3.9163E+00/
      DATA (KB(JT,24, 7),JT=1,5) /
     &2.7372E+00,2.8745E+00,3.0185E+00,3.1680E+00,3.3279E+00/
      DATA (KB(JT,25, 7),JT=1,5) /
     &2.3109E+00,2.4310E+00,2.5564E+00,2.6909E+00,2.8371E+00/
      DATA (KB(JT,26, 7),JT=1,5) /
     &1.9553E+00,2.0603E+00,2.1726E+00,2.2928E+00,2.4305E+00/
      DATA (KB(JT,27, 7),JT=1,5) /
     &1.6578E+00,1.7514E+00,1.8510E+00,1.9617E+00,2.0943E+00/
      DATA (KB(JT,28, 7),JT=1,5) /
     &1.4096E+00,1.4926E+00,1.5811E+00,1.6863E+00,1.8139E+00/
      DATA (KB(JT,29, 7),JT=1,5) /
     &1.2014E+00,1.2743E+00,1.3570E+00,1.4576E+00,1.5798E+00/
      DATA (KB(JT,30, 7),JT=1,5) /
     &1.0255E+00,1.0913E+00,1.1701E+00,1.2677E+00,1.3837E+00/
      DATA (KB(JT,31, 7),JT=1,5) /
     &8.7693E-01,9.3909E-01,1.0166E+00,1.1099E+00,1.2195E+00/
      DATA (KB(JT,32, 7),JT=1,5) /
     &7.5259E-01,8.1353E-01,8.8887E-01,9.7843E-01,1.0818E+00/
      DATA (KB(JT,33, 7),JT=1,5) /
     &6.4947E-01,7.0941E-01,7.8262E-01,8.6809E-01,9.6577E-01/
      DATA (KB(JT,34, 7),JT=1,5) /
     &5.6287E-01,6.2118E-01,6.9115E-01,7.7236E-01,8.6471E-01/
      DATA (KB(JT,35, 7),JT=1,5) /
     &4.8662E-01,5.4191E-01,6.0756E-01,6.8389E-01,7.7035E-01/
      DATA (KB(JT,36, 7),JT=1,5) /
     &4.1799E-01,4.6899E-01,5.2971E-01,6.0005E-01,6.8040E-01/
      DATA (KB(JT,37, 7),JT=1,5) /
     &3.5425E-01,3.9998E-01,4.5446E-01,5.1797E-01,5.9123E-01/
      DATA (KB(JT,38, 7),JT=1,5) /
     &3.0041E-01,3.4120E-01,3.9013E-01,4.4734E-01,5.1414E-01/
      DATA (KB(JT,39, 7),JT=1,5) /
     &2.5510E-01,2.9152E-01,3.3528E-01,3.8698E-01,4.4801E-01/
      DATA (KB(JT,40, 7),JT=1,5) /
     &2.1385E-01,2.4566E-01,2.8431E-01,3.3018E-01,3.8482E-01/
      DATA (KB(JT,41, 7),JT=1,5) /
     &1.7890E-01,2.0671E-01,2.4058E-01,2.8118E-01,3.2987E-01/
      DATA (KB(JT,42, 7),JT=1,5) /
     &1.4939E-01,1.7381E-01,2.0357E-01,2.3938E-01,2.8282E-01/
      DATA (KB(JT,43, 7),JT=1,5) /
     &1.2354E-01,1.4458E-01,1.7057E-01,2.0193E-01,2.4014E-01/
      DATA (KB(JT,44, 7),JT=1,5) /
     &1.0153E-01,1.1950E-01,1.4202E-01,1.6945E-01,2.0287E-01/
      DATA (KB(JT,45, 7),JT=1,5) /
     &8.3299E-02,9.8554E-02,1.1794E-01,1.4189E-01,1.7119E-01/
      DATA (KB(JT,46, 7),JT=1,5) /
     &6.7950E-02,8.0732E-02,9.7254E-02,1.1796E-01,1.4359E-01/
      DATA (KB(JT,47, 7),JT=1,5) /
     &5.4969E-02,6.5444E-02,7.9285E-02,9.6924E-02,1.1901E-01/
      DATA (KB(JT,48, 7),JT=1,5) /
     &4.4384E-02,5.2919E-02,6.4422E-02,7.9306E-02,9.8242E-02/
      DATA (KB(JT,49, 7),JT=1,5) /
     &3.5781E-02,4.2676E-02,5.2185E-02,6.4673E-02,8.0797E-02/
      DATA (KB(JT,50, 7),JT=1,5) /
     &2.8901E-02,3.4506E-02,4.2382E-02,5.2852E-02,6.6579E-02/
      DATA (KB(JT,51, 7),JT=1,5) /
     &2.3369E-02,2.7878E-02,3.4389E-02,4.3175E-02,5.4833E-02/
      DATA (KB(JT,52, 7),JT=1,5) /
     &1.8862E-02,2.2473E-02,2.7804E-02,3.5169E-02,4.5009E-02/
      DATA (KB(JT,53, 7),JT=1,5) /
     &1.5202E-02,1.8063E-02,2.2412E-02,2.8532E-02,3.6823E-02/
      DATA (KB(JT,54, 7),JT=1,5) /
     &1.2294E-02,1.4584E-02,1.8116E-02,2.3236E-02,3.0266E-02/
      DATA (KB(JT,55, 7),JT=1,5) /
     &9.9456E-03,1.1792E-02,1.4659E-02,1.8922E-02,2.4874E-02/
      DATA (KB(JT,56, 7),JT=1,5) /
     &8.0324E-03,9.5190E-03,1.1834E-02,1.5356E-02,2.0377E-02/
      DATA (KB(JT,57, 7),JT=1,5) /
     &6.4764E-03,7.6756E-03,9.5255E-03,1.2420E-02,1.6628E-02/
      DATA (KB(JT,58, 7),JT=1,5) /
     &5.2278E-03,6.1981E-03,7.6844E-03,1.0060E-02,1.3591E-02/
      DATA (KB(JT,59, 7),JT=1,5) /
     &4.3384E-03,5.1762E-03,6.4759E-03,8.5723E-03,1.1730E-02/
      DATA (KB(JT,13, 8),JT=1,5) /
     &4.8706E+01,5.0287E+01,5.1813E+01,5.3328E+01,5.4791E+01/
      DATA (KB(JT,14, 8),JT=1,5) /
     &4.2745E+01,4.3995E+01,4.5243E+01,4.6475E+01,4.7668E+01/
      DATA (KB(JT,15, 8),JT=1,5) /
     &3.7251E+01,3.8260E+01,3.9278E+01,4.0277E+01,4.1241E+01/
      DATA (KB(JT,16, 8),JT=1,5) /
     &3.2307E+01,3.3121E+01,3.3949E+01,3.4768E+01,3.5567E+01/
      DATA (KB(JT,17, 8),JT=1,5) /
     &2.7892E+01,2.8569E+01,2.9248E+01,2.9919E+01,3.0586E+01/
      DATA (KB(JT,18, 8),JT=1,5) /
     &2.3896E+01,2.4456E+01,2.5013E+01,2.5581E+01,2.6214E+01/
      DATA (KB(JT,19, 8),JT=1,5) /
     &2.0345E+01,2.0796E+01,2.1262E+01,2.1777E+01,2.2440E+01/
      DATA (KB(JT,20, 8),JT=1,5) /
     &1.7240E+01,1.7611E+01,1.8026E+01,1.8548E+01,1.9267E+01/
      DATA (KB(JT,21, 8),JT=1,5) /
     &1.4559E+01,1.4881E+01,1.5281E+01,1.5850E+01,1.6627E+01/
      DATA (KB(JT,22, 8),JT=1,5) /
     &1.2297E+01,1.2604E+01,1.3048E+01,1.3680E+01,1.4474E+01/
      DATA (KB(JT,23, 8),JT=1,5) /
     &1.0392E+01,1.0731E+01,1.1231E+01,1.1887E+01,1.2635E+01/
      DATA (KB(JT,24, 8),JT=1,5) /
     &8.8024E+00,9.1906E+00,9.7265E+00,1.0368E+01,1.1047E+01/
      DATA (KB(JT,25, 8),JT=1,5) /
     &7.4985E+00,7.9218E+00,8.4606E+00,9.0520E+00,9.6698E+00/
      DATA (KB(JT,26, 8),JT=1,5) /
     &6.4322E+00,6.8736E+00,7.3794E+00,7.9154E+00,8.4712E+00/
      DATA (KB(JT,27, 8),JT=1,5) /
     &5.5575E+00,5.9810E+00,6.4388E+00,6.9229E+00,7.4216E+00/
      DATA (KB(JT,28, 8),JT=1,5) /
     &4.8206E+00,5.2066E+00,5.6224E+00,6.0597E+00,6.5182E+00/
      DATA (KB(JT,29, 8),JT=1,5) /
     &4.1909E+00,4.5439E+00,4.9224E+00,5.3216E+00,5.7541E+00/
      DATA (KB(JT,30, 8),JT=1,5) /
     &3.6537E+00,3.9765E+00,4.3215E+00,4.6952E+00,5.1087E+00/
      DATA (KB(JT,31, 8),JT=1,5) /
     &3.1984E+00,3.4930E+00,3.8129E+00,4.1678E+00,4.5716E+00/
      DATA (KB(JT,32, 8),JT=1,5) /
     &2.8116E+00,3.0829E+00,3.3853E+00,3.7289E+00,4.1280E+00/
      DATA (KB(JT,33, 8),JT=1,5) /
     &2.4834E+00,2.7385E+00,3.0281E+00,3.3657E+00,3.7662E+00/
      DATA (KB(JT,34, 8),JT=1,5) /
     &2.1985E+00,2.4407E+00,2.7219E+00,3.0561E+00,3.4576E+00/
      DATA (KB(JT,35, 8),JT=1,5) /
     &1.9383E+00,2.1683E+00,2.4400E+00,2.7681E+00,3.1668E+00/
      DATA (KB(JT,36, 8),JT=1,5) /
     &1.6974E+00,1.9136E+00,2.1729E+00,2.4903E+00,2.8775E+00/
      DATA (KB(JT,37, 8),JT=1,5) /
     &1.4652E+00,1.6633E+00,1.9048E+00,2.2035E+00,2.5698E+00/
      DATA (KB(JT,38, 8),JT=1,5) /
     &1.2656E+00,1.4474E+00,1.6717E+00,1.9523E+00,2.2987E+00/
      DATA (KB(JT,39, 8),JT=1,5) /
     &1.0950E+00,1.2617E+00,1.4708E+00,1.7354E+00,2.0626E+00/
      DATA (KB(JT,40, 8),JT=1,5) /
     &9.3521E-01,1.0851E+00,1.2754E+00,1.5183E+00,1.8212E+00/
      DATA (KB(JT,41, 8),JT=1,5) /
     &7.9768E-01,9.3182E-01,1.1039E+00,1.3257E+00,1.6049E+00/
      DATA (KB(JT,42, 8),JT=1,5) /
     &6.8000E-01,8.0060E-01,9.5561E-01,1.1575E+00,1.4146E+00/
      DATA (KB(JT,43, 8),JT=1,5) /
     &5.7402E-01,6.8098E-01,8.1874E-01,9.9948E-01,1.2325E+00/
      DATA (KB(JT,44, 8),JT=1,5) /
     &4.8186E-01,5.7592E-01,6.9798E-01,8.5786E-01,1.0670E+00/
      DATA (KB(JT,45, 8),JT=1,5) /
     &4.0392E-01,4.8633E-01,5.9393E-01,7.3592E-01,9.2240E-01/
      DATA (KB(JT,46, 8),JT=1,5) /
     &3.3669E-01,4.0818E-01,5.0211E-01,6.2723E-01,7.9252E-01/
      DATA (KB(JT,47, 8),JT=1,5) /
     &2.7781E-01,3.3888E-01,4.1961E-01,5.2781E-01,6.7290E-01/
      DATA (KB(JT,48, 8),JT=1,5) /
     &2.2877E-01,2.8059E-01,3.4952E-01,4.4268E-01,5.6946E-01/
      DATA (KB(JT,49, 8),JT=1,5) /
     &1.8802E-01,2.3180E-01,2.9026E-01,3.7003E-01,4.7989E-01/
      DATA (KB(JT,50, 8),JT=1,5) /
     &1.5486E-01,1.9224E-01,2.4194E-01,3.1045E-01,4.0570E-01/
      DATA (KB(JT,51, 8),JT=1,5) /
     &1.2726E-01,1.5950E-01,2.0189E-01,2.6070E-01,3.4311E-01/
      DATA (KB(JT,52, 8),JT=1,5) /
     &1.0409E-01,1.3185E-01,1.6823E-01,2.1834E-01,2.8934E-01/
      DATA (KB(JT,53, 8),JT=1,5) /
     &8.4711E-02,1.0844E-01,1.3980E-01,1.8253E-01,2.4332E-01/
      DATA (KB(JT,54, 8),JT=1,5) /
     &6.9167E-02,8.9444E-02,1.1665E-01,1.5372E-01,2.0609E-01/
      DATA (KB(JT,55, 8),JT=1,5) /
     &5.6448E-02,7.3743E-02,9.7299E-02,1.2965E-01,1.7511E-01/
      DATA (KB(JT,56, 8),JT=1,5) /
     &4.5936E-02,6.0554E-02,8.0824E-02,1.0896E-01,1.4860E-01/
      DATA (KB(JT,57, 8),JT=1,5) /
     &3.7232E-02,4.9532E-02,6.6834E-02,9.1174E-02,1.2579E-01/
      DATA (KB(JT,58, 8),JT=1,5) /
     &3.0170E-02,4.0563E-02,5.5307E-02,7.6347E-02,1.0664E-01/
      DATA (KB(JT,59, 8),JT=1,5) /
     &2.5677E-02,3.5025E-02,4.8385E-02,6.7734E-02,9.6011E-02/
      DATA (KB(JT,13, 9),JT=1,5) /
     &2.6703E+02,2.6279E+02,2.6062E+02,2.6039E+02,2.6194E+02/
      DATA (KB(JT,14, 9),JT=1,5) /
     &2.2898E+02,2.2692E+02,2.2683E+02,2.2864E+02,2.3216E+02/
      DATA (KB(JT,15, 9),JT=1,5) /
     &1.9675E+02,1.9661E+02,1.9840E+02,2.0200E+02,2.0726E+02/
      DATA (KB(JT,16, 9),JT=1,5) /
     &1.6984E+02,1.7136E+02,1.7476E+02,1.7992E+02,1.8656E+02/
      DATA (KB(JT,17, 9),JT=1,5) /
     &1.4758E+02,1.5050E+02,1.5527E+02,1.6140E+02,1.6749E+02/
      DATA (KB(JT,18, 9),JT=1,5) /
     &1.2946E+02,1.3358E+02,1.3896E+02,1.4424E+02,1.4936E+02/
      DATA (KB(JT,19, 9),JT=1,5) /
     &1.1448E+02,1.1916E+02,1.2382E+02,1.2832E+02,1.3257E+02/
      DATA (KB(JT,20, 9),JT=1,5) /
     &1.0147E+02,1.0559E+02,1.0961E+02,1.1348E+02,1.1720E+02/
      DATA (KB(JT,21, 9),JT=1,5) /
     &8.9412E+01,9.2958E+01,9.6430E+01,9.9808E+01,1.0309E+02/
      DATA (KB(JT,22, 9),JT=1,5) /
     &7.8582E+01,8.1638E+01,8.4651E+01,8.7620E+01,9.0634E+01/
      DATA (KB(JT,23, 9),JT=1,5) /
     &6.8855E+01,7.1486E+01,7.4134E+01,7.6820E+01,7.9730E+01/
      DATA (KB(JT,24, 9),JT=1,5) /
     &6.0268E+01,6.2580E+01,6.4940E+01,6.7498E+01,7.0383E+01/
      DATA (KB(JT,25, 9),JT=1,5) /
     &5.2817E+01,5.4857E+01,5.7070E+01,5.9583E+01,6.2456E+01/
      DATA (KB(JT,26, 9),JT=1,5) /
     &4.6400E+01,4.8304E+01,5.0443E+01,5.2928E+01,5.5843E+01/
      DATA (KB(JT,27, 9),JT=1,5) /
     &4.0882E+01,4.2740E+01,4.4869E+01,4.7387E+01,5.0354E+01/
      DATA (KB(JT,28, 9),JT=1,5) /
     &3.6127E+01,3.8035E+01,4.0229E+01,4.2798E+01,4.5828E+01/
      DATA (KB(JT,29, 9),JT=1,5) /
     &3.2099E+01,3.4067E+01,3.6357E+01,3.9031E+01,4.2139E+01/
      DATA (KB(JT,30, 9),JT=1,5) /
     &2.8701E+01,3.0741E+01,3.3127E+01,3.5914E+01,3.9160E+01/
      DATA (KB(JT,31, 9),JT=1,5) /
     &2.5860E+01,2.7970E+01,3.0458E+01,3.3377E+01,3.6776E+01/
      DATA (KB(JT,32, 9),JT=1,5) /
     &2.3508E+01,2.5694E+01,2.8287E+01,3.1347E+01,3.4892E+01/
      DATA (KB(JT,33, 9),JT=1,5) /
     &2.1570E+01,2.3849E+01,2.6553E+01,2.9752E+01,3.3419E+01/
      DATA (KB(JT,34, 9),JT=1,5) /
     &1.9918E+01,2.2276E+01,2.5098E+01,2.8399E+01,3.2162E+01/
      DATA (KB(JT,35, 9),JT=1,5) /
     &1.8364E+01,2.0767E+01,2.3651E+01,2.7001E+01,3.0813E+01/
      DATA (KB(JT,36, 9),JT=1,5) /
     &1.6826E+01,1.9227E+01,2.2113E+01,2.5466E+01,2.9284E+01/
      DATA (KB(JT,37, 9),JT=1,5) /
     &1.5183E+01,1.7515E+01,2.0322E+01,2.3610E+01,2.7381E+01/
      DATA (KB(JT,38, 9),JT=1,5) /
     &1.3727E+01,1.5985E+01,1.8713E+01,2.1934E+01,2.5649E+01/
      DATA (KB(JT,39, 9),JT=1,5) /
     &1.2450E+01,1.4635E+01,1.7282E+01,2.0444E+01,2.4108E+01/
      DATA (KB(JT,40, 9),JT=1,5) /
     &1.1136E+01,1.3200E+01,1.5726E+01,1.8770E+01,2.2337E+01/
      DATA (KB(JT,41, 9),JT=1,5) /
     &9.9523E+00,1.1888E+01,1.4289E+01,1.7214E+01,2.0673E+01/
      DATA (KB(JT,42, 9),JT=1,5) /
     &8.8997E+00,1.0713E+01,1.2995E+01,1.5799E+01,1.9151E+01/
      DATA (KB(JT,43, 9),JT=1,5) /
     &7.8779E+00,9.5542E+00,1.1690E+01,1.4348E+01,1.7554E+01/
      DATA (KB(JT,44, 9),JT=1,5) /
     &6.9290E+00,8.4792E+00,1.0459E+01,1.2952E+01,1.5997E+01/
      DATA (KB(JT,45, 9),JT=1,5) /
     &6.0796E+00,7.5168E+00,9.3520E+00,1.1681E+01,1.4566E+01/
      DATA (KB(JT,46, 9),JT=1,5) /
     &5.2960E+00,6.6184E+00,8.3160E+00,1.0473E+01,1.3177E+01/
      DATA (KB(JT,47, 9),JT=1,5) /
     &4.5500E+00,5.7498E+00,7.3069E+00,9.2819E+00,1.1781E+01/
      DATA (KB(JT,48, 9),JT=1,5) /
     &3.8931E+00,4.9768E+00,6.3975E+00,8.2101E+00,1.0505E+01/
      DATA (KB(JT,49, 9),JT=1,5) /
     &3.3134E+00,4.2874E+00,5.5792E+00,7.2463E+00,9.3480E+00/
      DATA (KB(JT,50, 9),JT=1,5) /
     &2.8246E+00,3.7000E+00,4.8781E+00,6.4148E+00,8.3545E+00/
      DATA (KB(JT,51, 9),JT=1,5) /
     &2.4042E+00,3.1908E+00,4.2622E+00,5.6755E+00,7.4755E+00/
      DATA (KB(JT,52, 9),JT=1,5) /
     &2.0363E+00,2.7388E+00,3.7098E+00,5.0044E+00,6.6735E+00/
      DATA (KB(JT,53, 9),JT=1,5) /
     &1.7163E+00,2.3398E+00,3.2134E+00,4.3950E+00,5.9331E+00/
      DATA (KB(JT,54, 9),JT=1,5) /
     &1.4526E+00,2.0075E+00,2.7999E+00,3.8816E+00,5.3040E+00/
      DATA (KB(JT,55, 9),JT=1,5) /
     &1.2300E+00,1.7228E+00,2.4419E+00,3.4323E+00,4.7483E+00/
      DATA (KB(JT,56, 9),JT=1,5) /
     &1.0375E+00,1.4731E+00,2.1205E+00,3.0254E+00,4.2381E+00/
      DATA (KB(JT,57, 9),JT=1,5) /
     &8.7139E-01,1.2530E+00,1.8332E+00,2.6576E+00,3.7724E+00/
      DATA (KB(JT,58, 9),JT=1,5) /
     &7.3413E-01,1.0690E+00,1.5879E+00,2.3382E+00,3.3642E+00/
      DATA (KB(JT,59, 9),JT=1,5) /
     &6.5989E-01,9.7719E-01,1.4752E+00,2.2003E+00,3.1955E+00/
      DATA (KB(JT,13,10),JT=1,5) /
     &1.1367E+03,1.1187E+03,1.1007E+03,1.0822E+03,1.0635E+03/
      DATA (KB(JT,14,10),JT=1,5) /
     &1.0074E+03,9.9018E+02,9.7308E+02,9.5574E+02,9.3889E+02/
      DATA (KB(JT,15,10),JT=1,5) /
     &8.7706E+02,8.6124E+02,8.4557E+02,8.3018E+02,8.1545E+02/
      DATA (KB(JT,16,10),JT=1,5) /
     &7.5406E+02,7.4004E+02,7.2614E+02,7.1298E+02,7.0106E+02/
      DATA (KB(JT,17,10),JT=1,5) /
     &6.4217E+02,6.3016E+02,6.1851E+02,6.1057E+02,6.1770E+02/
      DATA (KB(JT,18,10),JT=1,5) /
     &5.4317E+02,5.3308E+02,5.2858E+02,5.4063E+02,5.6728E+02/
      DATA (KB(JT,19,10),JT=1,5) /
     &4.6024E+02,4.5629E+02,4.6936E+02,4.9569E+02,5.2404E+02/
      DATA (KB(JT,20,10),JT=1,5) /
     &3.9833E+02,4.0962E+02,4.3282E+02,4.5686E+02,4.8096E+02/
      DATA (KB(JT,21,10),JT=1,5) /
     &3.5836E+02,3.7926E+02,4.0031E+02,4.2094E+02,4.4134E+02/
      DATA (KB(JT,22,10),JT=1,5) /
     &3.2968E+02,3.4978E+02,3.6939E+02,3.8833E+02,4.0603E+02/
      DATA (KB(JT,23,10),JT=1,5) /
     &3.0114E+02,3.1980E+02,3.3812E+02,3.5559E+02,3.7182E+02/
      DATA (KB(JT,24,10),JT=1,5) /
     &2.7330E+02,2.9068E+02,3.0752E+02,3.2347E+02,3.3875E+02/
      DATA (KB(JT,25,10),JT=1,5) /
     &2.4688E+02,2.6295E+02,2.7833E+02,2.9325E+02,3.0804E+02/
      DATA (KB(JT,26,10),JT=1,5) /
     &2.2243E+02,2.3718E+02,2.5149E+02,2.6591E+02,2.8021E+02/
      DATA (KB(JT,27,10),JT=1,5) /
     &2.0056E+02,2.1372E+02,2.2739E+02,2.4128E+02,2.5540E+02/
      DATA (KB(JT,28,10),JT=1,5) /
     &1.8160E+02,1.9338E+02,2.0609E+02,2.1959E+02,2.3363E+02/
      DATA (KB(JT,29,10),JT=1,5) /
     &1.6537E+02,1.7620E+02,1.8800E+02,2.0075E+02,2.1484E+02/
      DATA (KB(JT,30,10),JT=1,5) /
     &1.5182E+02,1.6163E+02,1.7256E+02,1.8487E+02,1.9853E+02/
      DATA (KB(JT,31,10),JT=1,5) /
     &1.4022E+02,1.4937E+02,1.5973E+02,1.7160E+02,1.8530E+02/
      DATA (KB(JT,32,10),JT=1,5) /
     &1.3043E+02,1.3908E+02,1.4919E+02,1.6089E+02,1.7519E+02/
      DATA (KB(JT,33,10),JT=1,5) /
     &1.2206E+02,1.3058E+02,1.4055E+02,1.5267E+02,1.6777E+02/
      DATA (KB(JT,34,10),JT=1,5) /
     &1.1470E+02,1.2330E+02,1.3342E+02,1.4627E+02,1.6240E+02/
      DATA (KB(JT,35,10),JT=1,5) /
     &1.0771E+02,1.1657E+02,1.2696E+02,1.4044E+02,1.5769E+02/
      DATA (KB(JT,36,10),JT=1,5) /
     &1.0083E+02,1.1016E+02,1.2074E+02,1.3465E+02,1.5261E+02/
      DATA (KB(JT,37,10),JT=1,5) /
     &9.3496E+01,1.0322E+02,1.1406E+02,1.2781E+02,1.4573E+02/
      DATA (KB(JT,38,10),JT=1,5) /
     &8.6889E+01,9.7016E+01,1.0824E+02,1.2185E+02,1.3969E+02/
      DATA (KB(JT,39,10),JT=1,5) /
     &8.1021E+01,9.1487E+01,1.0329E+02,1.1682E+02,1.3445E+02/
      DATA (KB(JT,40,10),JT=1,5) /
     &7.4776E+01,8.5570E+01,9.7630E+01,1.1098E+02,1.2786E+02/
      DATA (KB(JT,41,10),JT=1,5) /
     &6.8905E+01,7.9963E+01,9.2277E+01,1.0563E+02,1.2163E+02/
      DATA (KB(JT,42,10),JT=1,5) /
     &6.3556E+01,7.4784E+01,8.7205E+01,1.0072E+02,1.1596E+02/
      DATA (KB(JT,43,10),JT=1,5) /
     &5.8129E+01,6.9316E+01,8.1730E+01,9.5263E+01,1.0987E+02/
      DATA (KB(JT,44,10),JT=1,5) /
     &5.2913E+01,6.3890E+01,7.6248E+01,8.9686E+01,1.0397E+02/
      DATA (KB(JT,45,10),JT=1,5) /
     &4.8208E+01,5.8780E+01,7.0988E+01,8.4262E+01,9.8407E+01/
      DATA (KB(JT,46,10),JT=1,5) /
     &4.3761E+01,5.3798E+01,6.5649E+01,7.8725E+01,9.2702E+01/
      DATA (KB(JT,47,10),JT=1,5) /
     &3.9326E+01,4.8763E+01,6.0030E+01,7.2829E+01,8.6540E+01/
      DATA (KB(JT,48,10),JT=1,5) /
     &3.5364E+01,4.4166E+01,5.4802E+01,6.7118E+01,8.0555E+01/
      DATA (KB(JT,49,10),JT=1,5) /
     &3.1766E+01,3.9895E+01,4.9874E+01,6.1599E+01,7.4720E+01/
      DATA (KB(JT,50,10),JT=1,5) /
     &2.8694E+01,3.6225E+01,4.5586E+01,5.6696E+01,6.9417E+01/
      DATA (KB(JT,51,10),JT=1,5) /
     &2.5920E+01,3.2954E+01,4.1705E+01,5.2192E+01,6.4368E+01/
      DATA (KB(JT,52,10),JT=1,5) /
     &2.3265E+01,2.9945E+01,3.8066E+01,4.7953E+01,5.9548E+01/
      DATA (KB(JT,53,10),JT=1,5) /
     &2.0700E+01,2.7205E+01,3.4731E+01,4.4004E+01,5.4983E+01/
      DATA (KB(JT,54,10),JT=1,5) /
     &1.8407E+01,2.4804E+01,3.1883E+01,4.0571E+01,5.0997E+01/
      DATA (KB(JT,55,10),JT=1,5) /
     &1.6304E+01,2.2551E+01,2.9350E+01,3.7469E+01,4.7350E+01/
      DATA (KB(JT,56,10),JT=1,5) /
     &1.4323E+01,2.0360E+01,2.7019E+01,3.4608E+01,4.3950E+01/
      DATA (KB(JT,57,10),JT=1,5) /
     &1.2463E+01,1.8241E+01,2.4765E+01,3.1934E+01,4.0687E+01/
      DATA (KB(JT,58,10),JT=1,5) /
     &1.0795E+01,1.6294E+01,2.2666E+01,2.9555E+01,3.7776E+01/
      DATA (KB(JT,59,10),JT=1,5) /
     &1.0106E+01,1.5507E+01,2.1812E+01,2.8629E+01,3.6645E+01/
      DATA (KB(JT,13,11),JT=1,5) /
     &1.9976E+03,1.9732E+03,1.9489E+03,1.9244E+03,1.8976E+03/
      DATA (KB(JT,14,11),JT=1,5) /
     &1.8361E+03,1.8109E+03,1.7859E+03,1.7607E+03,1.7342E+03/
      DATA (KB(JT,15,11),JT=1,5) /
     &1.6588E+03,1.6335E+03,1.6090E+03,1.5838E+03,1.5592E+03/
      DATA (KB(JT,16,11),JT=1,5) /
     &1.4709E+03,1.4475E+03,1.4246E+03,1.4016E+03,1.3798E+03/
      DATA (KB(JT,17,11),JT=1,5) /
     &1.2816E+03,1.2604E+03,1.2396E+03,1.2204E+03,1.2023E+03/
      DATA (KB(JT,18,11),JT=1,5) /
     &1.1028E+03,1.0839E+03,1.0668E+03,1.0513E+03,1.0382E+03/
      DATA (KB(JT,19,11),JT=1,5) /
     &9.4023E+02,9.2525E+02,9.1156E+02,9.0352E+02,9.1240E+02/
      DATA (KB(JT,20,11),JT=1,5) /
     &7.9708E+02,7.8540E+02,7.8133E+02,7.9678E+02,8.2988E+02/
      DATA (KB(JT,21,11),JT=1,5) /
     &6.7587E+02,6.7233E+02,6.8973E+02,7.2606E+02,7.7277E+02/
      DATA (KB(JT,22,11),JT=1,5) /
     &5.8284E+02,5.9841E+02,6.3319E+02,6.7525E+02,7.1925E+02/
      DATA (KB(JT,23,11),JT=1,5) /
     &5.2309E+02,5.5425E+02,5.9038E+02,6.2826E+02,6.6879E+02/
      DATA (KB(JT,24,11),JT=1,5) /
     &4.8568E+02,5.1820E+02,5.5078E+02,5.8566E+02,6.2252E+02/
      DATA (KB(JT,25,11),JT=1,5) /
     &4.5215E+02,4.8337E+02,5.1498E+02,5.4697E+02,5.8166E+02/
      DATA (KB(JT,26,11),JT=1,5) /
     &4.2013E+02,4.5049E+02,4.8168E+02,5.1282E+02,5.4620E+02/
      DATA (KB(JT,27,11),JT=1,5) /
     &3.8959E+02,4.1991E+02,4.5056E+02,4.8229E+02,5.1534E+02/
      DATA (KB(JT,28,11),JT=1,5) /
     &3.6165E+02,3.9145E+02,4.2248E+02,4.5510E+02,4.8890E+02/
      DATA (KB(JT,29,11),JT=1,5) /
     &3.3655E+02,3.6613E+02,3.9802E+02,4.3186E+02,4.6748E+02/
      DATA (KB(JT,30,11),JT=1,5) /
     &3.1395E+02,3.4455E+02,3.7776E+02,4.1303E+02,4.5043E+02/
      DATA (KB(JT,31,11),JT=1,5) /
     &2.9496E+02,3.2692E+02,3.6155E+02,3.9895E+02,4.3848E+02/
      DATA (KB(JT,32,11),JT=1,5) /
     &2.7981E+02,3.1316E+02,3.4973E+02,3.8935E+02,4.3105E+02/
      DATA (KB(JT,33,11),JT=1,5) /
     &2.6816E+02,3.0318E+02,3.4211E+02,3.8404E+02,4.2836E+02/
      DATA (KB(JT,34,11),JT=1,5) /
     &2.5884E+02,2.9576E+02,3.3707E+02,3.8116E+02,4.2770E+02/
      DATA (KB(JT,35,11),JT=1,5) /
     &2.4952E+02,2.8807E+02,3.3125E+02,3.7732E+02,4.2524E+02/
      DATA (KB(JT,36,11),JT=1,5) /
     &2.3943E+02,2.7867E+02,3.2325E+02,3.7058E+02,4.1944E+02/
      DATA (KB(JT,37,11),JT=1,5) /
     &2.2613E+02,2.6501E+02,3.0984E+02,3.5803E+02,4.0758E+02/
      DATA (KB(JT,38,11),JT=1,5) /
     &2.1436E+02,2.5281E+02,2.9747E+02,3.4610E+02,3.9628E+02/
      DATA (KB(JT,39,11),JT=1,5) /
     &2.0421E+02,2.4224E+02,2.8638E+02,3.3523E+02,3.8565E+02/
      DATA (KB(JT,40,11),JT=1,5) /
     &1.9196E+02,2.2865E+02,2.7155E+02,3.1991E+02,3.7045E+02/
      DATA (KB(JT,41,11),JT=1,5) /
     &1.8048E+02,2.1574E+02,2.5717E+02,3.0447E+02,3.5504E+02/
      DATA (KB(JT,42,11),JT=1,5) /
     &1.7002E+02,2.0375E+02,2.4381E+02,2.8960E+02,3.3999E+02/
      DATA (KB(JT,43,11),JT=1,5) /
     &1.5882E+02,1.9068E+02,2.2888E+02,2.7297E+02,3.2243E+02/
      DATA (KB(JT,44,11),JT=1,5) /
     &1.4807E+02,1.7774E+02,2.1381E+02,2.5595E+02,3.0384E+02/
      DATA (KB(JT,45,11),JT=1,5) /
     &1.3832E+02,1.6584E+02,1.9975E+02,2.3997E+02,2.8600E+02/
      DATA (KB(JT,46,11),JT=1,5) /
     &1.2854E+02,1.5423E+02,1.8595E+02,2.2400E+02,2.6785E+02/
      DATA (KB(JT,47,11),JT=1,5) /
     &1.1798E+02,1.4267E+02,1.7172E+02,2.0717E+02,2.4874E+02/
      DATA (KB(JT,48,11),JT=1,5) /
     &1.0754E+02,1.3197E+02,1.5865E+02,1.9157E+02,2.3076E+02/
      DATA (KB(JT,49,11),JT=1,5) /
     &9.7426E+01,1.2165E+02,1.4680E+02,1.7709E+02,2.1383E+02/
      DATA (KB(JT,50,11),JT=1,5) /
     &8.8058E+01,1.1199E+02,1.3670E+02,1.6456E+02,1.9880E+02/
      DATA (KB(JT,51,11),JT=1,5) /
     &7.9382E+01,1.0270E+02,1.2731E+02,1.5331E+02,1.8527E+02/
      DATA (KB(JT,52,11),JT=1,5) /
     &7.1270E+01,9.3720E+01,1.1802E+02,1.4309E+02,1.7263E+02/
      DATA (KB(JT,53,11),JT=1,5) /
     &6.3724E+01,8.4883E+01,1.0881E+02,1.3358E+02,1.6088E+02/
      DATA (KB(JT,54,11),JT=1,5) /
     &5.7330E+01,7.7159E+01,1.0045E+02,1.2510E+02,1.5088E+02/
      DATA (KB(JT,55,11),JT=1,5) /
     &5.1611E+01,7.0208E+01,9.2617E+01,1.1701E+02,1.4209E+02/
      DATA (KB(JT,56,11),JT=1,5) /
     &4.6383E+01,6.3679E+01,8.4927E+01,1.0898E+02,1.3380E+02/
      DATA (KB(JT,57,11),JT=1,5) /
     &4.1604E+01,5.7613E+01,7.7613E+01,1.0100E+02,1.2575E+02/
      DATA (KB(JT,58,11),JT=1,5) /
     &3.7495E+01,5.2208E+01,7.1056E+01,9.3655E+01,1.1815E+02/
      DATA (KB(JT,59,11),JT=1,5) /
     &3.5885E+01,5.0106E+01,6.8487E+01,9.0651E+01,1.1506E+02/
      DATA (KB(JT,13,12),JT=1,5) /
     &3.5806E+03,3.5582E+03,3.5338E+03,3.5034E+03,3.4725E+03/
      DATA (KB(JT,14,12),JT=1,5) /
     &3.4862E+03,3.4597E+03,3.4292E+03,3.3949E+03,3.3614E+03/
      DATA (KB(JT,15,12),JT=1,5) /
     &3.3163E+03,3.2855E+03,3.2498E+03,3.2159E+03,3.1795E+03/
      DATA (KB(JT,16,12),JT=1,5) /
     &3.0905E+03,3.0565E+03,3.0217E+03,2.9883E+03,2.9514E+03/
      DATA (KB(JT,17,12),JT=1,5) /
     &2.8252E+03,2.7909E+03,2.7597E+03,2.7275E+03,2.6935E+03/
      DATA (KB(JT,18,12),JT=1,5) /
     &2.5391E+03,2.5095E+03,2.4810E+03,2.4508E+03,2.4233E+03/
      DATA (KB(JT,19,12),JT=1,5) /
     &2.2475E+03,2.2231E+03,2.1980E+03,2.1744E+03,2.1532E+03/
      DATA (KB(JT,20,12),JT=1,5) /
     &1.9592E+03,1.9385E+03,1.9191E+03,1.9031E+03,1.8880E+03/
      DATA (KB(JT,21,12),JT=1,5) /
     &1.6882E+03,1.6730E+03,1.6603E+03,1.6503E+03,1.6513E+03/
      DATA (KB(JT,22,12),JT=1,5) /
     &1.4424E+03,1.4327E+03,1.4274E+03,1.4386E+03,1.4720E+03/
      DATA (KB(JT,23,12),JT=1,5) /
     &1.2274E+03,1.2245E+03,1.2417E+03,1.2835E+03,1.3444E+03/
      DATA (KB(JT,24,12),JT=1,5) /
     &1.0462E+03,1.0639E+03,1.1088E+03,1.1752E+03,1.2597E+03/
      DATA (KB(JT,25,12),JT=1,5) /
     &9.1114E+02,9.5200E+02,1.0177E+03,1.1057E+03,1.2094E+03/
      DATA (KB(JT,26,12),JT=1,5) /
     &8.2003E+02,8.7985E+02,9.6324E+02,1.0645E+03,1.1739E+03/
      DATA (KB(JT,27,12),JT=1,5) /
     &7.6267E+02,8.3792E+02,9.2956E+02,1.0323E+03,1.1455E+03/
      DATA (KB(JT,28,12),JT=1,5) /
     &7.2963E+02,8.0994E+02,9.0250E+02,1.0075E+03,1.1258E+03/
      DATA (KB(JT,29,12),JT=1,5) /
     &7.0594E+02,7.8863E+02,8.8342E+02,9.9282E+02,1.1166E+03/
      DATA (KB(JT,30,12),JT=1,5) /
     &6.8865E+02,7.7319E+02,8.7237E+02,9.8744E+02,1.1171E+03/
      DATA (KB(JT,31,12),JT=1,5) /
     &6.7685E+02,7.6521E+02,8.7052E+02,9.9144E+02,1.1267E+03/
      DATA (KB(JT,32,12),JT=1,5) /
     &6.7111E+02,7.6562E+02,8.7695E+02,1.0037E+03,1.1434E+03/
      DATA (KB(JT,33,12),JT=1,5) /
     &6.7259E+02,7.7346E+02,8.9020E+02,1.0220E+03,1.1658E+03/
      DATA (KB(JT,34,12),JT=1,5) /
     &6.7713E+02,7.8296E+02,9.0470E+02,1.0405E+03,1.1875E+03/
      DATA (KB(JT,35,12),JT=1,5) /
     &6.7665E+02,7.8599E+02,9.1053E+02,1.0483E+03,1.1976E+03/
      DATA (KB(JT,36,12),JT=1,5) /
     &6.6854E+02,7.7898E+02,9.0439E+02,1.0428E+03,1.1928E+03/
      DATA (KB(JT,37,12),JT=1,5) /
     &6.4709E+02,7.5625E+02,8.8001E+02,1.0171E+03,1.1660E+03/
      DATA (KB(JT,38,12),JT=1,5) /
     &6.2682E+02,7.3409E+02,8.5611E+02,9.9182E+02,1.1392E+03/
      DATA (KB(JT,39,12),JT=1,5) /
     &6.0784E+02,7.1328E+02,8.3356E+02,9.6784E+02,1.1136E+03/
      DATA (KB(JT,40,12),JT=1,5) /
     &5.7971E+02,6.8247E+02,7.9953E+02,9.3053E+02,1.0739E+03/
      DATA (KB(JT,41,12),JT=1,5) /
     &5.5088E+02,6.5173E+02,7.6511E+02,8.9294E+02,1.0334E+03/
      DATA (KB(JT,42,12),JT=1,5) /
     &5.2250E+02,6.2258E+02,7.3222E+02,8.5651E+02,9.9385E+02/
      DATA (KB(JT,43,12),JT=1,5) /
     &4.8933E+02,5.8876E+02,6.9433E+02,8.1420E+02,9.4769E+02/
      DATA (KB(JT,44,12),JT=1,5) /
     &4.5428E+02,5.5295E+02,6.5546E+02,7.7054E+02,8.9971E+02/
      DATA (KB(JT,45,12),JT=1,5) /
     &4.2007E+02,5.1771E+02,6.1870E+02,7.2869E+02,8.5325E+02/
      DATA (KB(JT,46,12),JT=1,5) /
     &3.8522E+02,4.8086E+02,5.8089E+02,6.8626E+02,8.0577E+02/
      DATA (KB(JT,47,12),JT=1,5) /
     &3.4877E+02,4.4033E+02,5.3933E+02,6.4157E+02,7.5519E+02/
      DATA (KB(JT,48,12),JT=1,5) /
     &3.1493E+02,4.0108E+02,4.9823E+02,5.9910E+02,7.0691E+02/
      DATA (KB(JT,49,12),JT=1,5) /
     &2.8364E+02,3.6388E+02,4.5779E+02,5.5756E+02,6.6121E+02/
      DATA (KB(JT,50,12),JT=1,5) /
     &2.5678E+02,3.3121E+02,4.2060E+02,5.1905E+02,6.2075E+02/
      DATA (KB(JT,51,12),JT=1,5) /
     &2.3307E+02,3.0175E+02,3.8585E+02,4.8220E+02,5.8283E+02/
      DATA (KB(JT,52,12),JT=1,5) /
     &2.1162E+02,2.7441E+02,3.5299E+02,4.4577E+02,5.4547E+02/
      DATA (KB(JT,53,12),JT=1,5) /
     &1.9234E+02,2.4923E+02,3.2216E+02,4.1019E+02,5.0837E+02/
      DATA (KB(JT,54,12),JT=1,5) /
     &1.7628E+02,2.2813E+02,2.9582E+02,3.7887E+02,4.7480E+02/
      DATA (KB(JT,55,12),JT=1,5) /
     &1.6140E+02,2.0966E+02,2.7210E+02,3.5029E+02,4.4296E+02/
      DATA (KB(JT,56,12),JT=1,5) /
     &1.4678E+02,1.9288E+02,2.5016E+02,3.2346E+02,4.1177E+02/
      DATA (KB(JT,57,12),JT=1,5) /
     &1.3255E+02,1.7758E+02,2.2997E+02,2.9828E+02,3.8188E+02/
      DATA (KB(JT,58,12),JT=1,5) /
     &1.1943E+02,1.6353E+02,2.1228E+02,2.7566E+02,3.5477E+02/
      DATA (KB(JT,59,12),JT=1,5) /
     &1.1423E+02,1.5792E+02,2.0564E+02,2.6702E+02,3.4426E+02/
      DATA (KB(JT,13,13),JT=1,5) /
     &6.2371E+03,6.2518E+03,6.2489E+03,6.2389E+03,6.2163E+03/
      DATA (KB(JT,14,13),JT=1,5) /
     &6.5479E+03,6.5460E+03,6.5322E+03,6.5131E+03,6.4799E+03/
      DATA (KB(JT,15,13),JT=1,5) /
     &6.7275E+03,6.7134E+03,6.6981E+03,6.6679E+03,6.6340E+03/
      DATA (KB(JT,16,13),JT=1,5) /
     &6.7706E+03,6.7549E+03,6.7279E+03,6.6968E+03,6.6585E+03/
      DATA (KB(JT,17,13),JT=1,5) /
     &6.6836E+03,6.6601E+03,6.6362E+03,6.6043E+03,6.5760E+03/
      DATA (KB(JT,18,13),JT=1,5) /
     &6.4651E+03,6.4504E+03,6.4295E+03,6.4100E+03,6.3855E+03/
      DATA (KB(JT,19,13),JT=1,5) /
     &6.1476E+03,6.1374E+03,6.1314E+03,6.1247E+03,6.1206E+03/
      DATA (KB(JT,20,13),JT=1,5) /
     &5.7657E+03,5.7701E+03,5.7793E+03,5.7885E+03,5.8038E+03/
      DATA (KB(JT,21,13),JT=1,5) /
     &5.3372E+03,5.3657E+03,5.3946E+03,5.4291E+03,5.4659E+03/
      DATA (KB(JT,22,13),JT=1,5) /
     &4.8964E+03,4.9428E+03,4.9998E+03,5.0621E+03,5.1258E+03/
      DATA (KB(JT,23,13),JT=1,5) /
     &4.4608E+03,4.5344E+03,4.6177E+03,4.7044E+03,4.8008E+03/
      DATA (KB(JT,24,13),JT=1,5) /
     &4.0572E+03,4.1535E+03,4.2613E+03,4.3798E+03,4.5026E+03/
      DATA (KB(JT,25,13),JT=1,5) /
     &3.6891E+03,3.8125E+03,3.9482E+03,4.0905E+03,4.2411E+03/
      DATA (KB(JT,26,13),JT=1,5) /
     &3.3690E+03,3.5206E+03,3.6781E+03,3.8529E+03,4.0416E+03/
      DATA (KB(JT,27,13),JT=1,5) /
     &3.0960E+03,3.2709E+03,3.4667E+03,3.6805E+03,3.9027E+03/
      DATA (KB(JT,28,13),JT=1,5) /
     &2.8685E+03,3.0838E+03,3.3203E+03,3.5644E+03,3.8131E+03/
      DATA (KB(JT,29,13),JT=1,5) /
     &2.7079E+03,2.9620E+03,3.2275E+03,3.4951E+03,3.7635E+03/
      DATA (KB(JT,30,13),JT=1,5) /
     &2.6061E+03,2.8858E+03,3.1752E+03,3.4611E+03,3.7451E+03/
      DATA (KB(JT,31,13),JT=1,5) /
     &2.5477E+03,2.8507E+03,3.1575E+03,3.4577E+03,3.7506E+03/
      DATA (KB(JT,32,13),JT=1,5) /
     &2.5270E+03,2.8474E+03,3.1664E+03,3.4757E+03,3.7742E+03/
      DATA (KB(JT,33,13),JT=1,5) /
     &2.5348E+03,2.8669E+03,3.1934E+03,3.5095E+03,3.8093E+03/
      DATA (KB(JT,34,13),JT=1,5) /
     &2.5519E+03,2.8931E+03,3.2251E+03,3.5432E+03,3.8451E+03/
      DATA (KB(JT,35,13),JT=1,5) /
     &2.5512E+03,2.8985E+03,3.2338E+03,3.5558E+03,3.8584E+03/
      DATA (KB(JT,36,13),JT=1,5) /
     &2.5221E+03,2.8745E+03,3.2143E+03,3.5395E+03,3.8450E+03/
      DATA (KB(JT,37,13),JT=1,5) /
     &2.4460E+03,2.8025E+03,3.1490E+03,3.4791E+03,3.7899E+03/
      DATA (KB(JT,38,13),JT=1,5) /
     &2.3708E+03,2.7313E+03,3.0831E+03,3.4179E+03,3.7342E+03/
      DATA (KB(JT,39,13),JT=1,5) /
     &2.3003E+03,2.6642E+03,3.0201E+03,3.3586E+03,3.6803E+03/
      DATA (KB(JT,40,13),JT=1,5) /
     &2.1969E+03,2.5616E+03,2.9219E+03,3.2671E+03,3.5954E+03/
      DATA (KB(JT,41,13),JT=1,5) /
     &2.0924E+03,2.4560E+03,2.8204E+03,3.1716E+03,3.5055E+03/
      DATA (KB(JT,42,13),JT=1,5) /
     &1.9915E+03,2.3511E+03,2.7188E+03,3.0759E+03,3.4151E+03/
      DATA (KB(JT,43,13),JT=1,5) /
     &1.8747E+03,2.2279E+03,2.5969E+03,2.9589E+03,3.3053E+03/
      DATA (KB(JT,44,13),JT=1,5) /
     &1.7544E+03,2.0986E+03,2.4653E+03,2.8326E+03,3.1860E+03/
      DATA (KB(JT,45,13),JT=1,5) /
     &1.6386E+03,1.9731E+03,2.3348E+03,2.7048E+03,3.0644E+03/
      DATA (KB(JT,46,13),JT=1,5) /
     &1.5205E+03,1.8444E+03,2.1974E+03,2.5688E+03,2.9332E+03/
      DATA (KB(JT,47,13),JT=1,5) /
     &1.3958E+03,1.7058E+03,2.0486E+03,2.4160E+03,2.7851E+03/
      DATA (KB(JT,48,13),JT=1,5) /
     &1.2783E+03,1.5734E+03,1.9036E+03,2.2627E+03,2.6347E+03/
      DATA (KB(JT,49,13),JT=1,5) /
     &1.1678E+03,1.4470E+03,1.7643E+03,2.1130E+03,2.4832E+03/
      DATA (KB(JT,50,13),JT=1,5) /
     &1.0712E+03,1.3344E+03,1.6384E+03,1.9762E+03,2.3408E+03/
      DATA (KB(JT,51,13),JT=1,5) /
     &9.8353E+02,1.2311E+03,1.5209E+03,1.8472E+03,2.2032E+03/
      DATA (KB(JT,52,13),JT=1,5) /
     &9.0254E+02,1.1339E+03,1.4093E+03,1.7232E+03,2.0693E+03/
      DATA (KB(JT,53,13),JT=1,5) /
     &8.2760E+02,1.0429E+03,1.3025E+03,1.6032E+03,1.9381E+03/
      DATA (KB(JT,54,13),JT=1,5) /
     &7.6424E+02,9.6451E+02,1.2096E+03,1.4971E+03,1.8216E+03/
      DATA (KB(JT,55,13),JT=1,5) /
     &7.1080E+02,8.9446E+02,1.1253E+03,1.4000E+03,1.7133E+03/
      DATA (KB(JT,56,13),JT=1,5) /
     &6.6381E+02,8.2901E+02,1.0458E+03,1.3069E+03,1.6083E+03/
      DATA (KB(JT,57,13),JT=1,5) /
     &6.2290E+02,7.6867E+02,9.7122E+02,1.2178E+03,1.5070E+03/
      DATA (KB(JT,58,13),JT=1,5) /
     &5.8709E+02,7.1760E+02,9.0453E+02,1.1378E+03,1.4149E+03/
      DATA (KB(JT,59,13),JT=1,5) /
     &5.7268E+02,6.9849E+02,8.7854E+02,1.1067E+03,1.3783E+03/
      DATA (KB(JT,13,14),JT=1,5) /
     &9.8812E+03,9.9499E+03,9.9974E+03,1.0022E+04,1.0029E+04/
      DATA (KB(JT,14,14),JT=1,5) /
     &1.1156E+04,1.1216E+04,1.1254E+04,1.1270E+04,1.1265E+04/
      DATA (KB(JT,15,14),JT=1,5) /
     &1.2449E+04,1.2496E+04,1.2517E+04,1.2519E+04,1.2490E+04/
      DATA (KB(JT,16,14),JT=1,5) /
     &1.3700E+04,1.3729E+04,1.3741E+04,1.3718E+04,1.3680E+04/
      DATA (KB(JT,17,14),JT=1,5) /
     &1.4861E+04,1.4895E+04,1.4882E+04,1.4853E+04,1.4786E+04/
      DATA (KB(JT,18,14),JT=1,5) /
     &1.5910E+04,1.5917E+04,1.5910E+04,1.5867E+04,1.5794E+04/
      DATA (KB(JT,19,14),JT=1,5) /
     &1.6801E+04,1.6817E+04,1.6802E+04,1.6758E+04,1.6676E+04/
      DATA (KB(JT,20,14),JT=1,5) /
     &1.7524E+04,1.7556E+04,1.7546E+04,1.7509E+04,1.7437E+04/
      DATA (KB(JT,21,14),JT=1,5) /
     &1.8096E+04,1.8141E+04,1.8145E+04,1.8122E+04,1.8064E+04/
      DATA (KB(JT,22,14),JT=1,5) /
     &1.8520E+04,1.8595E+04,1.8633E+04,1.8624E+04,1.8566E+04/
      DATA (KB(JT,23,14),JT=1,5) /
     &1.8825E+04,1.8946E+04,1.9018E+04,1.9030E+04,1.8984E+04/
      DATA (KB(JT,24,14),JT=1,5) /
     &1.9042E+04,1.9220E+04,1.9316E+04,1.9349E+04,1.9324E+04/
      DATA (KB(JT,25,14),JT=1,5) /
     &1.9210E+04,1.9418E+04,1.9542E+04,1.9606E+04,1.9602E+04/
      DATA (KB(JT,26,14),JT=1,5) /
     &1.9338E+04,1.9577E+04,1.9740E+04,1.9821E+04,1.9828E+04/
      DATA (KB(JT,27,14),JT=1,5) /
     &1.9451E+04,1.9723E+04,1.9903E+04,2.0002E+04,2.0015E+04/
      DATA (KB(JT,28,14),JT=1,5) /
     &1.9563E+04,1.9853E+04,2.0047E+04,2.0156E+04,2.0162E+04/
      DATA (KB(JT,29,14),JT=1,5) /
     &1.9675E+04,1.9975E+04,2.0176E+04,2.0280E+04,2.0284E+04/
      DATA (KB(JT,30,14),JT=1,5) /
     &1.9781E+04,2.0092E+04,2.0291E+04,2.0384E+04,2.0380E+04/
      DATA (KB(JT,31,14),JT=1,5) /
     &1.9898E+04,2.0205E+04,2.0389E+04,2.0467E+04,2.0456E+04/
      DATA (KB(JT,32,14),JT=1,5) /
     &2.0014E+04,2.0306E+04,2.0476E+04,2.0543E+04,2.0514E+04/
      DATA (KB(JT,33,14),JT=1,5) /
     &2.0125E+04,2.0400E+04,2.0544E+04,2.0600E+04,2.0558E+04/
      DATA (KB(JT,34,14),JT=1,5) /
     &2.0217E+04,2.0476E+04,2.0611E+04,2.0645E+04,2.0591E+04/
      DATA (KB(JT,35,14),JT=1,5) /
     &2.0276E+04,2.0526E+04,2.0654E+04,2.0682E+04,2.0620E+04/
      DATA (KB(JT,36,14),JT=1,5) /
     &2.0294E+04,2.0553E+04,2.0682E+04,2.0712E+04,2.0656E+04/
      DATA (KB(JT,37,14),JT=1,5) /
     &2.0260E+04,2.0540E+04,2.0692E+04,2.0741E+04,2.0704E+04/
      DATA (KB(JT,38,14),JT=1,5) /
     &2.0217E+04,2.0522E+04,2.0695E+04,2.0763E+04,2.0734E+04/
      DATA (KB(JT,39,14),JT=1,5) /
     &2.0167E+04,2.0500E+04,2.0691E+04,2.0777E+04,2.0762E+04/
      DATA (KB(JT,40,14),JT=1,5) /
     &2.0068E+04,2.0438E+04,2.0666E+04,2.0778E+04,2.0786E+04/
      DATA (KB(JT,41,14),JT=1,5) /
     &1.9949E+04,2.0361E+04,2.0631E+04,2.0768E+04,2.0804E+04/
      DATA (KB(JT,42,14),JT=1,5) /
     &1.9819E+04,2.0274E+04,2.0579E+04,2.0750E+04,2.0814E+04/
      DATA (KB(JT,43,14),JT=1,5) /
     &1.9645E+04,2.0149E+04,2.0503E+04,2.0721E+04,2.0814E+04/
      DATA (KB(JT,44,14),JT=1,5) /
     &1.9429E+04,1.9994E+04,2.0396E+04,2.0663E+04,2.0798E+04/
      DATA (KB(JT,45,14),JT=1,5) /
     &1.9189E+04,1.9824E+04,2.0285E+04,2.0595E+04,2.0770E+04/
      DATA (KB(JT,46,14),JT=1,5) /
     &1.8912E+04,1.9621E+04,2.0139E+04,2.0501E+04,2.0722E+04/
      DATA (KB(JT,47,14),JT=1,5) /
     &1.8574E+04,1.9355E+04,1.9947E+04,2.0373E+04,2.0652E+04/
      DATA (KB(JT,48,14),JT=1,5) /
     &1.8199E+04,1.9060E+04,1.9733E+04,2.0223E+04,2.0560E+04/
      DATA (KB(JT,49,14),JT=1,5) /
     &1.7788E+04,1.8737E+04,1.9487E+04,2.0042E+04,2.0440E+04/
      DATA (KB(JT,50,14),JT=1,5) /
     &1.7372E+04,1.8402E+04,1.9222E+04,1.9853E+04,2.0312E+04/
      DATA (KB(JT,51,14),JT=1,5) /
     &1.6932E+04,1.8048E+04,1.8944E+04,1.9653E+04,2.0163E+04/
      DATA (KB(JT,52,14),JT=1,5) /
     &1.6460E+04,1.7668E+04,1.8640E+04,1.9416E+04,1.9992E+04/
      DATA (KB(JT,53,14),JT=1,5) /
     &1.5959E+04,1.7252E+04,1.8310E+04,1.9147E+04,1.9806E+04/
      DATA (KB(JT,54,14),JT=1,5) /
     &1.5461E+04,1.6846E+04,1.7980E+04,1.8888E+04,1.9606E+04/
      DATA (KB(JT,55,14),JT=1,5) /
     &1.4966E+04,1.6424E+04,1.7640E+04,1.8623E+04,1.9399E+04/
      DATA (KB(JT,56,14),JT=1,5) /
     &1.4452E+04,1.5984E+04,1.7276E+04,1.8327E+04,1.9166E+04/
      DATA (KB(JT,57,14),JT=1,5) /
     &1.3910E+04,1.5518E+04,1.6891E+04,1.8015E+04,1.8917E+04/
      DATA (KB(JT,58,14),JT=1,5) /
     &1.3384E+04,1.5053E+04,1.6496E+04,1.7699E+04,1.8667E+04/
      DATA (KB(JT,59,14),JT=1,5) /
     &1.3166E+04,1.4859E+04,1.6332E+04,1.7567E+04,1.8563E+04/
      DATA (KB(JT,13,15),JT=1,5) /
     &1.3095E+04,1.3203E+04,1.3280E+04,1.3335E+04,1.3364E+04/
      DATA (KB(JT,14,15),JT=1,5) /
     &1.5533E+04,1.5637E+04,1.5702E+04,1.5732E+04,1.5730E+04/
      DATA (KB(JT,15,15),JT=1,5) /
     &1.8283E+04,1.8379E+04,1.8421E+04,1.8416E+04,1.8371E+04/
      DATA (KB(JT,16,15),JT=1,5) /
     &2.1357E+04,2.1409E+04,2.1406E+04,2.1356E+04,2.1240E+04/
      DATA (KB(JT,17,15),JT=1,5) /
     &2.4722E+04,2.4699E+04,2.4632E+04,2.4482E+04,2.4282E+04/
      DATA (KB(JT,18,15),JT=1,5) /
     &2.8315E+04,2.8214E+04,2.8019E+04,2.7755E+04,2.7441E+04/
      DATA (KB(JT,19,15),JT=1,5) /
     &3.2071E+04,3.1837E+04,3.1501E+04,3.1092E+04,3.0622E+04/
      DATA (KB(JT,20,15),JT=1,5) /
     &3.5875E+04,3.5466E+04,3.4981E+04,3.4394E+04,3.3745E+04/
      DATA (KB(JT,21,15),JT=1,5) /
     &3.9627E+04,3.9030E+04,3.8357E+04,3.7580E+04,3.6746E+04/
      DATA (KB(JT,22,15),JT=1,5) /
     &4.3205E+04,4.2400E+04,4.1478E+04,4.0494E+04,3.9468E+04/
      DATA (KB(JT,23,15),JT=1,5) /
     &4.6532E+04,4.5460E+04,4.4309E+04,4.3126E+04,4.1899E+04/
      DATA (KB(JT,24,15),JT=1,5) /
     &4.9513E+04,4.8176E+04,4.6831E+04,4.5435E+04,4.4005E+04/
      DATA (KB(JT,25,15),JT=1,5) /
     &5.2106E+04,5.0560E+04,4.9001E+04,4.7400E+04,4.5767E+04/
      DATA (KB(JT,26,15),JT=1,5) /
     &5.4289E+04,5.2537E+04,5.0767E+04,4.8979E+04,4.7180E+04/
      DATA (KB(JT,27,15),JT=1,5) /
     &5.6074E+04,5.4129E+04,5.2176E+04,5.0219E+04,4.8292E+04/
      DATA (KB(JT,28,15),JT=1,5) /
     &5.7491E+04,5.5358E+04,5.3246E+04,5.1171E+04,4.9128E+04/
      DATA (KB(JT,29,15),JT=1,5) /
     &5.8538E+04,5.6261E+04,5.4015E+04,5.1836E+04,4.9710E+04/
      DATA (KB(JT,30,15),JT=1,5) /
     &5.9277E+04,5.6882E+04,5.4538E+04,5.2280E+04,5.0075E+04/
      DATA (KB(JT,31,15),JT=1,5) /
     &5.9738E+04,5.7244E+04,5.4845E+04,5.2509E+04,5.0252E+04/
      DATA (KB(JT,32,15),JT=1,5) /
     &5.9975E+04,5.7405E+04,5.4958E+04,5.2573E+04,5.0275E+04/
      DATA (KB(JT,33,15),JT=1,5) /
     &6.0007E+04,5.7410E+04,5.4914E+04,5.2499E+04,5.0167E+04/
      DATA (KB(JT,34,15),JT=1,5) /
     &5.9998E+04,5.7359E+04,5.4840E+04,5.2398E+04,5.0041E+04/
      DATA (KB(JT,35,15),JT=1,5) /
     &6.0132E+04,5.7462E+04,5.4907E+04,5.2438E+04,5.0062E+04/
      DATA (KB(JT,36,15),JT=1,5) /
     &6.0467E+04,5.7764E+04,5.5174E+04,5.2679E+04,5.0279E+04/
      DATA (KB(JT,37,15),JT=1,5) /
     &6.1171E+04,5.8407E+04,5.5781E+04,5.3245E+04,5.0803E+04/
      DATA (KB(JT,38,15),JT=1,5) /
     &6.1845E+04,5.9045E+04,5.6369E+04,5.3796E+04,5.1321E+04/
      DATA (KB(JT,39,15),JT=1,5) /
     &6.2474E+04,5.9622E+04,5.6925E+04,5.4319E+04,5.1811E+04/
      DATA (KB(JT,40,15),JT=1,5) /
     &6.3380E+04,6.0485E+04,5.7724E+04,5.5082E+04,5.2540E+04/
      DATA (KB(JT,41,15),JT=1,5) /
     &6.4308E+04,6.1360E+04,5.8546E+04,5.5868E+04,5.3286E+04/
      DATA (KB(JT,42,15),JT=1,5) /
     &6.5214E+04,6.2221E+04,5.9366E+04,5.6643E+04,5.4029E+04/
      DATA (KB(JT,43,15),JT=1,5) /
     &6.6280E+04,6.3259E+04,6.0335E+04,5.7567E+04,5.4915E+04/
      DATA (KB(JT,44,15),JT=1,5) /
     &6.7443E+04,6.4360E+04,6.1383E+04,5.8557E+04,5.5857E+04/
      DATA (KB(JT,45,15),JT=1,5) /
     &6.8616E+04,6.5461E+04,6.2445E+04,5.9557E+04,5.6818E+04/
      DATA (KB(JT,46,15),JT=1,5) /
     &6.9855E+04,6.6628E+04,6.3578E+04,6.0631E+04,5.7835E+04/
      DATA (KB(JT,47,15),JT=1,5) /
     &7.1240E+04,6.7969E+04,6.4839E+04,6.1843E+04,5.8987E+04/
      DATA (KB(JT,48,15),JT=1,5) /
     &7.2637E+04,6.9326E+04,6.6121E+04,6.3073E+04,6.0145E+04/
      DATA (KB(JT,49,15),JT=1,5) /
     &7.4017E+04,7.0688E+04,6.7429E+04,6.4324E+04,6.1340E+04/
      DATA (KB(JT,50,15),JT=1,5) /
     &7.5349E+04,7.1972E+04,6.8674E+04,6.5502E+04,6.2467E+04/
      DATA (KB(JT,51,15),JT=1,5) /
     &7.6637E+04,7.3219E+04,6.9913E+04,6.6663E+04,6.3587E+04/
      DATA (KB(JT,52,15),JT=1,5) /
     &7.7955E+04,7.4483E+04,7.1122E+04,6.7846E+04,6.4721E+04/
      DATA (KB(JT,53,15),JT=1,5) /
     &7.9280E+04,7.5753E+04,7.2364E+04,6.9053E+04,6.5858E+04/
      DATA (KB(JT,54,15),JT=1,5) /
     &8.0495E+04,7.6933E+04,7.3504E+04,7.0171E+04,6.6914E+04/
      DATA (KB(JT,55,15),JT=1,5) /
     &8.1662E+04,7.8089E+04,7.4612E+04,7.1233E+04,6.7959E+04/
      DATA (KB(JT,56,15),JT=1,5) /
     &8.2843E+04,7.9230E+04,7.5715E+04,7.2316E+04,6.9008E+04/
      DATA (KB(JT,57,15),JT=1,5) /
     &8.4005E+04,8.0398E+04,7.6842E+04,7.3404E+04,7.0077E+04/
      DATA (KB(JT,58,15),JT=1,5) /
     &8.5078E+04,8.1502E+04,7.7919E+04,7.4439E+04,7.1083E+04/
      DATA (KB(JT,59,15),JT=1,5) /
     &8.5505E+04,8.1958E+04,7.8361E+04,7.4870E+04,7.1482E+04/
      DATA (KB(JT,13,16),JT=1,5) /
     &1.4816E+04,1.4930E+04,1.5014E+04,1.5052E+04,1.5044E+04/
      DATA (KB(JT,14,16),JT=1,5) /
     &1.7836E+04,1.7951E+04,1.8019E+04,1.8017E+04,1.7984E+04/
      DATA (KB(JT,15,16),JT=1,5) /
     &2.1381E+04,2.1462E+04,2.1481E+04,2.1430E+04,2.1342E+04/
      DATA (KB(JT,16,16),JT=1,5) /
     &2.5477E+04,2.5475E+04,2.5403E+04,2.5275E+04,2.5089E+04/
      DATA (KB(JT,17,16),JT=1,5) /
     &3.0124E+04,3.0002E+04,2.9773E+04,2.9519E+04,2.9186E+04/
      DATA (KB(JT,18,16),JT=1,5) /
     &3.5286E+04,3.4965E+04,3.4530E+04,3.4092E+04,3.3540E+04/
      DATA (KB(JT,19,16),JT=1,5) /
     &4.0852E+04,4.0241E+04,3.9575E+04,3.8871E+04,3.8057E+04/
      DATA (KB(JT,20,16),JT=1,5) /
     &4.6699E+04,4.5739E+04,4.4741E+04,4.3700E+04,4.2576E+04/
      DATA (KB(JT,21,16),JT=1,5) /
     &5.2654E+04,5.1275E+04,4.9864E+04,4.8428E+04,4.6961E+04/
      DATA (KB(JT,22,16),JT=1,5) /
     &5.8403E+04,5.6551E+04,5.4684E+04,5.2822E+04,5.0976E+04/
      DATA (KB(JT,23,16),JT=1,5) /
     &6.3816E+04,6.1463E+04,5.9121E+04,5.6821E+04,5.4590E+04/
      DATA (KB(JT,24,16),JT=1,5) /
     &6.8713E+04,6.5863E+04,6.3058E+04,6.0345E+04,5.7751E+04/
      DATA (KB(JT,25,16),JT=1,5) /
     &7.2989E+04,6.9656E+04,6.6424E+04,6.3329E+04,6.0404E+04/
      DATA (KB(JT,26,16),JT=1,5) /
     &7.6570E+04,7.2775E+04,6.9149E+04,6.5716E+04,6.2522E+04/
      DATA (KB(JT,27,16),JT=1,5) /
     &7.9459E+04,7.5274E+04,7.1313E+04,6.7589E+04,6.4169E+04/
      DATA (KB(JT,28,16),JT=1,5) /
     &8.1683E+04,7.7174E+04,7.2947E+04,6.8995E+04,6.5376E+04/
      DATA (KB(JT,29,16),JT=1,5) /
     &8.3285E+04,7.8510E+04,7.4071E+04,6.9957E+04,6.6188E+04/
      DATA (KB(JT,30,16),JT=1,5) /
     &8.4346E+04,7.9371E+04,7.4777E+04,7.0557E+04,6.6673E+04/
      DATA (KB(JT,31,16),JT=1,5) /
     &8.4928E+04,7.9835E+04,7.5096E+04,7.0806E+04,6.6861E+04/
      DATA (KB(JT,32,16),JT=1,5) /
     &8.5101E+04,7.9916E+04,7.5117E+04,7.0792E+04,6.6791E+04/
      DATA (KB(JT,33,16),JT=1,5) /
     &8.4949E+04,7.9717E+04,7.4898E+04,7.0557E+04,6.6529E+04/
      DATA (KB(JT,34,16),JT=1,5) /
     &8.4743E+04,7.9470E+04,7.4656E+04,7.0309E+04,6.6256E+04/
      DATA (KB(JT,35,16),JT=1,5) /
     &8.4858E+04,7.9542E+04,7.4709E+04,7.0325E+04,6.6240E+04/
      DATA (KB(JT,36,16),JT=1,5) /
     &8.5440E+04,8.0039E+04,7.5130E+04,7.0697E+04,6.6564E+04/
      DATA (KB(JT,37,16),JT=1,5) /
     &8.6760E+04,8.1217E+04,7.6179E+04,7.1644E+04,6.7431E+04/
      DATA (KB(JT,38,16),JT=1,5) /
     &8.8049E+04,8.2388E+04,7.7214E+04,7.2579E+04,6.8294E+04/
      DATA (KB(JT,39,16),JT=1,5) /
     &8.9280E+04,8.3525E+04,7.8218E+04,7.3474E+04,6.9111E+04/
      DATA (KB(JT,40,16),JT=1,5) /
     &9.1121E+04,8.5172E+04,7.9710E+04,7.4807E+04,7.0344E+04/
      DATA (KB(JT,41,16),JT=1,5) /
     &9.3033E+04,8.6893E+04,8.1281E+04,7.6203E+04,7.1626E+04/
      DATA (KB(JT,42,16),JT=1,5) /
     &9.4965E+04,8.8622E+04,8.0415E+04,7.7606E+04,7.2910E+04/
      DATA (KB(JT,43,16),JT=1,5) /
     &9.7303E+04,9.0720E+04,8.4775E+04,7.9330E+04,7.4454E+04/
      DATA (KB(JT,44,16),JT=1,5) /
     &9.9859E+04,9.3029E+04,8.6867E+04,8.1230E+04,7.6153E+04/
      DATA (KB(JT,45,16),JT=1,5) /
     &1.0249E+05,9.5410E+04,8.8999E+04,8.3177E+04,7.7890E+04/
      DATA (KB(JT,46,16),JT=1,5) /
     &1.0536E+05,9.7993E+04,9.1330E+04,8.5316E+04,7.9796E+04/
      DATA (KB(JT,47,16),JT=1,5) /
     &1.0871E+05,1.0095E+05,9.4014E+04,8.7743E+04,8.2024E+04/
      DATA (KB(JT,48,16),JT=1,5) /
     &1.1228E+05,1.0405E+05,9.6823E+04,9.0264E+04,8.4322E+04/
      DATA (KB(JT,49,16),JT=1,5) /
     &1.1602E+05,1.0727E+05,9.9709E+04,9.2873E+04,8.6711E+04/
      DATA (KB(JT,50,16),JT=1,5) /
     &1.1975E+05,1.1051E+05,1.0253E+05,9.5425E+04,8.8999E+04/
      DATA (KB(JT,51,16),JT=1,5) /
     &1.2354E+05,1.1380E+05,1.0536E+05,9.7987E+04,9.1299E+04/
      DATA (KB(JT,52,16),JT=1,5) /
     &1.2745E+05,1.1723E+05,1.0833E+05,1.0062E+05,9.3694E+04/
      DATA (KB(JT,53,16),JT=1,5) /
     &1.3160E+05,1.2088E+05,1.1148E+05,1.0337E+05,9.6183E+04/
      DATA (KB(JT,54,16),JT=1,5) /
     &1.3555E+05,1.2436E+05,1.1452E+05,1.0598E+05,9.8537E+04/
      DATA (KB(JT,55,16),JT=1,5) /
     &1.3946E+05,1.2781E+05,1.1754E+05,1.0859E+05,1.0085E+05/
      DATA (KB(JT,56,16),JT=1,5) /
     &1.4362E+05,1.3143E+05,1.2072E+05,1.1136E+05,1.0326E+05/
      DATA (KB(JT,57,16),JT=1,5) /
     &1.4797E+05,1.3519E+05,1.2403E+05,1.1423E+05,1.0573E+05/
      DATA (KB(JT,58,16),JT=1,5) /
     &1.5241E+05,1.3886E+05,1.2729E+05,1.1707E+05,1.0818E+05/
      DATA (KB(JT,59,16),JT=1,5) /
     &1.5431E+05,1.4041E+05,1.2862E+05,1.1825E+05,1.0919E+05/

C     The array FORREF contains the coefficient of the water vapor
C     foreign-continuum (including the energy term).  The first 
C     index refers to reference temperature (296,260,224,260) and 
C     pressure (970,475,219,3 mbar) levels.  The second index 
C     runs over the g-channel (1 to 16).

      DATA (FORREF(1,IG),IG=1,16) /
     &2.7075e-06,2.2609e-06,1.5633e-06,8.7484e-07,5.5470e-07,4.8456e-07,
     &4.7463e-07,4.6154e-07,4.4425e-07,4.2960e-07,4.2626e-07,4.1715e-07,
     &4.2607e-07,3.6616e-07,2.6366e-07,2.6029e-07/
      DATA (FORREF(2,IG),IG=1,16) /
     &2.6759e-06,2.2237e-06,1.4466e-06,9.3032e-07,6.4927e-07,5.4809e-07,
     &4.9504e-07,4.6305e-07,4.4873e-07,4.2146e-07,4.2176e-07,4.2812e-07,
     &4.0529e-07,4.0969e-07,2.9442e-07,2.6821e-07/
      DATA (FORREF(3,IG),IG=1,16) /
     &2.6608e-06,2.1140e-06,1.4838e-06,9.2083e-07,6.3350e-07,5.7195e-07,
     &6.2253e-07,5.1783e-07,4.4749e-07,4.3261e-07,4.2553e-07,4.2175e-07,
     &4.1085e-07,4.0358e-07,3.5340e-07,2.7191e-07/
      DATA (FORREF(4,IG),IG=1,16) /
     &2.6412e-06,1.9814e-06,1.2672e-06,8.1129e-07,7.1447e-07,7.5026e-07,
     &7.4386e-07,7.2759e-07,7.3583e-07,7.6493e-07,8.8959e-07,7.5534e-07,
     &5.3734e-07,4.5572e-07,4.1676e-07,3.6198e-07/

C     The array SELFREF contains the coefficient of the water vapor
C     self-continuum (including the energy term).  The first index
C     refers to temperature in 7.2 degree increments.  For instance,
C     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
C     etc.  The second index runs over the g-channel (1 to 16).

      DATA (SELFREF(JT, 1),JT=1,10)  /
     & 4.67262e-03, 3.95211e-03, 3.34270e-03, 2.82726e-03, 2.39130e-03,
     & 2.02256e-03, 1.71069e-03, 1.44690e-03, 1.22379e-03, 1.03508e-03/
      DATA (SELFREF(JT, 2),JT=1,10)  /
     & 4.42593e-03, 3.73338e-03, 3.14920e-03, 2.65643e-03, 2.24076e-03,
     & 1.89014e-03, 1.59438e-03, 1.34490e-03, 1.13446e-03, 9.56943e-04/
      DATA (SELFREF(JT, 3),JT=1,10)  /
     & 3.96072e-03, 3.33789e-03, 2.81300e-03, 2.37065e-03, 1.99786e-03,
     & 1.68369e-03, 1.41893e-03, 1.19580e-03, 1.00776e-03, 8.49286e-04/
      DATA (SELFREF(JT, 4),JT=1,10)  /
     & 3.71833e-03, 3.10030e-03, 2.58500e-03, 2.15535e-03, 1.79711e-03,
     & 1.49841e-03, 1.24936e-03, 1.04170e-03, 8.68558e-04, 7.24195e-04/
      DATA (SELFREF(JT, 5),JT=1,10)  /
     & 3.55755e-03, 2.95355e-03, 2.45210e-03, 2.03578e-03, 1.69015e-03,
     & 1.40320e-03, 1.16497e-03, 9.67180e-04, 8.02973e-04, 6.66646e-04/
      DATA (SELFREF(JT, 6),JT=1,10)  /
     & 3.47601e-03, 2.88628e-03, 2.39660e-03, 1.99000e-03, 1.65238e-03,
     & 1.37204e-03, 1.13927e-03, 9.45980e-04, 7.85487e-04, 6.52224e-04/
      DATA (SELFREF(JT, 7),JT=1,10)  /
     & 3.44479e-03, 2.86224e-03, 2.37820e-03, 1.97602e-03, 1.64185e-03,
     & 1.36420e-03, 1.13350e-03, 9.41810e-04, 7.82539e-04, 6.50204e-04/
      DATA (SELFREF(JT, 8),JT=1,10)  /
     & 3.40154e-03, 2.82953e-03, 2.35370e-03, 1.95789e-03, 1.62864e-03,
     & 1.35476e-03, 1.12694e-03, 9.37430e-04, 7.79788e-04, 6.48655e-04/
      DATA (SELFREF(JT, 9),JT=1,10)  /
     & 3.39380e-03, 2.82288e-03, 2.34800e-03, 1.95301e-03, 1.62446e-03,
     & 1.35119e-03, 1.12389e-03, 9.34820e-04, 7.77560e-04, 6.46755e-04/
      DATA (SELFREF(JT,10),JT=1,10)  /
     & 3.37185e-03, 2.80654e-03, 2.33600e-03, 1.94435e-03, 1.61837e-03,
     & 1.34704e-03, 1.12120e-03, 9.33220e-04, 7.76759e-04, 6.46530e-04/
      DATA (SELFREF(JT,11),JT=1,10)  /
     & 3.37924e-03, 2.81172e-03, 2.33950e-03, 1.94659e-03, 1.61967e-03,
     & 1.34765e-03, 1.12132e-03, 9.33000e-04, 7.76306e-04, 6.45930e-04/
      DATA (SELFREF(JT,12),JT=1,10)  /
     & 3.39658e-03, 2.82289e-03, 2.34610e-03, 1.94984e-03, 1.62051e-03,
     & 1.34680e-03, 1.11933e-03, 9.30270e-04, 7.73146e-04, 6.42561e-04/
      DATA (SELFREF(JT,13),JT=1,10)  /
     & 3.36070e-03, 2.79913e-03, 2.33140e-03, 1.94183e-03, 1.61735e-03,
     & 1.34709e-03, 1.12199e-03, 9.34510e-04, 7.78354e-04, 6.48292e-04/
      DATA (SELFREF(JT,14),JT=1,10)  /
     & 3.40428e-03, 2.81994e-03, 2.33590e-03, 1.93495e-03, 1.60282e-03,
     & 1.32770e-03, 1.09980e-03, 9.11020e-04, 7.54645e-04, 6.25111e-04/
      DATA (SELFREF(JT,15),JT=1,10)  /
     & 3.27075e-03, 2.70783e-03, 2.24180e-03, 1.85597e-03, 1.53655e-03,
     & 1.27210e-03, 1.05317e-03, 8.71910e-04, 7.21849e-04, 5.97615e-04/
      DATA (SELFREF(JT,16),JT=1,10)  /
     & 3.23123e-03, 2.67891e-03, 2.22100e-03, 1.84136e-03, 1.52661e-03,
     & 1.26567e-03, 1.04932e-03, 8.69960e-04, 7.21256e-04, 5.97970e-04/
