C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB15.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.0 $
C     created:   $Date: 2002/06/03 20:42:58 $
       PARAMETER (MG=16)
       REAL KA(9,5,13,MG)
       DIMENSION SELFREF(10,MG), FORREF(4, MG)
       REAL KA_MN2(9,19,MG)

       COMMON /HVRSN15/ HVRKG15
       COMMON /K15/ KA, FORREF, SELFREF, KA_MN2

       CHARACTER*15 HVRKG15
       DATA HVRKG15 /'$Revision: 3.0 $'/


C     The array KA contains absorption coefs for each of the 16 g-intervals
C     for a range of pressure levels > ~100mb, temperatures, and ratios
C     of water vapor to CO2.  The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.
C     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
C     to different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this  pressure 
C     level, JT = 2 refers to the temperature
C     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
C     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
C     to the reference pressure level (e.g. JP = 1 is for a
C     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA ((KA(JS,JT, 1, 1),JS=1,9),JT=1,5) /
     &3.4242E-02,1.7071E-01,2.6138E-01,3.1721E-01,3.2432E-01,2.6831E-01,
     &2.0528E-01,1.1088E-01,5.8968E-01,3.3652E-02,1.6779E-01,2.5725E-01,
     &3.0829E-01,3.1520E-01,2.6815E-01,2.0103E-01,1.1213E-01,5.6496E-01,
     &3.2936E-02,1.6580E-01,2.5340E-01,3.0468E-01,3.0583E-01,2.6658E-01,
     &1.9781E-01,1.1388E-01,5.5053E-01,3.2004E-02,1.6475E-01,2.5029E-01,
     &3.0171E-01,3.0308E-01,2.6842E-01,1.9857E-01,1.1861E-01,5.4961E-01,
     &3.0990E-02,1.6410E-01,2.4670E-01,2.9476E-01,3.0044E-01,2.7387E-01,
     &1.9493E-01,1.2451E-01,5.3996E-01/
      DATA ((KA(JS,JT, 2, 1),JS=1,9),JT=1,5) /
     &3.0564E-02,1.4940E-01,2.2694E-01,2.6721E-01,2.6456E-01,2.1891E-01,
     &1.6459E-01,9.1113E-02,4.6587E-01,2.9826E-02,1.4880E-01,2.2345E-01,
     &2.6474E-01,2.5889E-01,2.2136E-01,1.6243E-01,9.1934E-02,4.6056E-01,
     &2.9292E-02,1.4800E-01,2.2058E-01,2.6235E-01,2.5684E-01,2.2295E-01,
     &1.6276E-01,9.5842E-02,4.5687E-01,2.8631E-02,1.4795E-01,2.1809E-01,
     &2.5690E-01,2.5387E-01,2.2588E-01,1.6201E-01,9.9403E-02,4.5029E-01,
     &2.7916E-02,1.4649E-01,2.1539E-01,2.5025E-01,2.5060E-01,2.2852E-01,
     &1.6118E-01,1.0330E-01,4.4510E-01/
      DATA ((KA(JS,JT, 3, 1),JS=1,9),JT=1,5) /
     &2.7060E-02,1.3249E-01,1.9563E-01,2.2645E-01,2.1616E-01,1.7969E-01,
     &1.3284E-01,7.4965E-02,3.7244E-01,2.6723E-02,1.3208E-01,1.9386E-01,
     &2.2490E-01,2.1534E-01,1.8332E-01,1.3372E-01,7.6721E-02,3.7364E-01,
     &2.6384E-02,1.3168E-01,1.9203E-01,2.2240E-01,2.1507E-01,1.8752E-01,
     &1.3386E-01,7.9482E-02,3.7891E-01,2.5689E-02,1.3020E-01,1.8980E-01,
     &2.1868E-01,2.1152E-01,1.8912E-01,1.3349E-01,8.2411E-02,3.7480E-01,
     &2.4939E-02,1.2901E-01,1.8570E-01,2.1295E-01,2.0942E-01,1.8777E-01,
     &1.3349E-01,8.5566E-02,3.6973E-01/
      DATA ((KA(JS,JT, 4, 1),JS=1,9),JT=1,5) /
     &2.4242E-02,1.1699E-01,1.6835E-01,1.9257E-01,1.7909E-01,1.4906E-01,
     &1.0978E-01,6.3298E-02,3.0317E-01,2.3651E-02,1.1679E-01,1.6721E-01,
     &1.9147E-01,1.7987E-01,1.5405E-01,1.1069E-01,6.4435E-02,3.0873E-01,
     &2.2665E-02,1.1583E-01,1.6543E-01,1.8831E-01,1.8066E-01,1.5730E-01,
     &1.1107E-01,6.6643E-02,3.1154E-01,2.1814E-02,1.1462E-01,1.6249E-01,
     &1.8491E-01,1.7772E-01,1.5750E-01,1.1124E-01,6.9078E-02,3.1214E-01,
     &2.1129E-02,1.1306E-01,1.5907E-01,1.7919E-01,1.7465E-01,1.5650E-01,
     &1.1133E-01,7.1551E-02,3.0812E-01/
      DATA ((KA(JS,JT, 5, 1),JS=1,9),JT=1,5) /
     &2.0560E-02,1.0249E-01,1.4447E-01,1.6390E-01,1.4827E-01,1.2487E-01,
     &9.0642E-02,5.3488E-02,2.4754E-01,1.9799E-02,1.0201E-01,1.4357E-01,
     &1.6295E-01,1.5070E-01,1.2910E-01,9.1763E-02,5.4394E-02,2.5641E-01,
     &1.9183E-02,1.0090E-01,1.4151E-01,1.5954E-01,1.5069E-01,1.3095E-01,
     &9.2718E-02,5.6321E-02,2.5912E-01,1.8512E-02,9.9552E-02,1.3834E-01,
     &1.5497E-01,1.4881E-01,1.3077E-01,9.3091E-02,5.8675E-02,2.5974E-01,
     &1.7786E-02,9.7242E-02,1.3532E-01,1.5076E-01,1.4713E-01,1.3062E-01,
     &9.3284E-02,6.0479E-02,2.5760E-01/
      DATA ((KA(JS,JT, 6, 1),JS=1,9),JT=1,5) /
     &1.7311E-02,8.8922E-02,1.2346E-01,1.3907E-01,1.2282E-01,1.0362E-01,
     &7.4353E-02,4.4575E-02,2.0465E-01,1.6759E-02,8.7881E-02,1.2272E-01,
     &1.3747E-01,1.2636E-01,1.0747E-01,7.5966E-02,4.6065E-02,2.1117E-01,
     &1.6118E-02,8.6674E-02,1.1960E-01,1.3378E-01,1.2578E-01,1.0890E-01,
     &7.7032E-02,4.7370E-02,2.1535E-01,1.5604E-02,8.5004E-02,1.1715E-01,
     &1.3060E-01,1.2464E-01,1.0936E-01,7.8068E-02,4.9979E-02,2.1513E-01,
     &1.5010E-02,8.2612E-02,1.1457E-01,1.2694E-01,1.2379E-01,1.0886E-01,
     &7.8577E-02,5.1634E-02,2.1475E-01/
      DATA ((KA(JS,JT, 7, 1),JS=1,9),JT=1,5) /
     &1.4769E-02,7.6038E-02,1.0565E-01,1.1761E-01,1.0346E-01,8.6214E-02,
     &6.1132E-02,3.6999E-02,1.7055E-01,1.4212E-02,7.5191E-02,1.0412E-01,
     &1.1565E-01,1.0591E-01,8.9750E-02,6.2857E-02,3.8703E-02,1.7619E-01,
     &1.3756E-02,7.4145E-02,1.0177E-01,1.1260E-01,1.0586E-01,9.1675E-02,
     &6.4846E-02,4.0069E-02,1.8020E-01,1.3258E-02,7.2484E-02,9.9439E-02,
     &1.0966E-01,1.0522E-01,9.2290E-02,6.5394E-02,4.2345E-02,1.8038E-01,
     &1.2766E-02,7.0689E-02,9.6896E-02,1.0710E-01,1.0411E-01,9.1721E-02,
     &6.6375E-02,4.4166E-02,1.8031E-01/
      DATA ((KA(JS,JT, 8, 1),JS=1,9),JT=1,5) /
     &1.2774E-02,6.5331E-02,9.0505E-02,1.0027E-01,8.8579E-02,7.2873E-02,
     &5.1439E-02,3.0866E-02,1.4484E-01,1.2386E-02,6.4820E-02,8.9216E-02,
     &9.8573E-02,9.0271E-02,7.6134E-02,5.3003E-02,3.2488E-02,1.4948E-01,
     &1.1934E-02,6.3787E-02,8.6950E-02,9.5946E-02,9.0138E-02,7.8085E-02,
     &5.5347E-02,3.4134E-02,1.5219E-01,1.1544E-02,6.2588E-02,8.5063E-02,
     &9.3318E-02,8.9759E-02,7.8769E-02,5.5958E-02,3.6086E-02,1.5324E-01,
     &1.1084E-02,6.0720E-02,8.2631E-02,9.1723E-02,8.9027E-02,7.8819E-02,
     &5.6823E-02,3.7768E-02,1.5367E-01/
      DATA ((KA(JS,JT, 9, 1),JS=1,9),JT=1,5) /
     &1.1061E-02,5.5946E-02,7.7372E-02,8.4825E-02,7.4671E-02,6.0881E-02,
     &4.3320E-02,2.5693E-02,1.2149E-01,1.0663E-02,5.5517E-02,7.6169E-02,
     &8.3555E-02,7.6380E-02,6.3832E-02,4.4653E-02,2.7044E-02,1.2592E-01,
     &1.0298E-02,5.4609E-02,7.4061E-02,8.1380E-02,7.6283E-02,6.5805E-02,
     &4.6544E-02,2.8652E-02,1.2784E-01,9.9642E-03,5.3590E-02,7.2457E-02,
     &7.9291E-02,7.6297E-02,6.6701E-02,4.7215E-02,3.0429E-02,1.2985E-01,
     &9.5838E-03,5.1774E-02,7.0525E-02,7.7952E-02,7.5761E-02,6.7035E-02,
     &4.8099E-02,3.1771E-02,1.2981E-01/
      DATA ((KA(JS,JT,10, 1),JS=1,9),JT=1,5) /
     &9.5065E-03,4.7743E-02,6.5906E-02,7.1569E-02,6.3088E-02,5.1008E-02,
     &3.6270E-02,2.1647E-02,1.0151E-01,9.1696E-03,4.7417E-02,6.4599E-02,
     &7.0371E-02,6.4348E-02,5.3431E-02,3.7744E-02,2.2620E-02,1.0603E-01,
     &8.8668E-03,4.6740E-02,6.2818E-02,6.8749E-02,6.4307E-02,5.5442E-02,
     &3.9323E-02,2.3889E-02,1.0716E-01,8.5593E-03,4.5273E-02,6.1475E-02,
     &6.7236E-02,6.4539E-02,5.6295E-02,4.0023E-02,2.5561E-02,1.0908E-01,
     &8.2765E-03,4.3918E-02,5.9902E-02,6.5936E-02,6.4146E-02,5.6753E-02,
     &4.0609E-02,2.6739E-02,1.0938E-01/
      DATA ((KA(JS,JT,11, 1),JS=1,9),JT=1,5) /
     &8.0135E-03,4.0574E-02,5.5523E-02,5.9842E-02,5.3590E-02,4.3205E-02,
     &3.0578E-02,1.8553E-02,8.6419E-02,7.7438E-03,4.0051E-02,5.3954E-02,
     &5.8561E-02,5.4366E-02,4.5533E-02,3.1980E-02,1.9368E-02,8.9461E-02,
     &7.4839E-03,3.9067E-02,5.2580E-02,5.7160E-02,5.4156E-02,4.6927E-02,
     &3.3356E-02,2.0535E-02,9.0297E-02,7.2468E-03,3.7809E-02,5.1257E-02,
     &5.6080E-02,5.4294E-02,4.7574E-02,3.3980E-02,2.1720E-02,9.1828E-02,
     &6.9859E-03,3.6737E-02,5.0287E-02,5.5092E-02,5.3946E-02,4.8082E-02,
     &3.4738E-02,2.2682E-02,9.1913E-02/
      DATA ((KA(JS,JT,12, 1),JS=1,9),JT=1,5) /
     &6.8723E-03,3.4461E-02,4.6618E-02,5.0325E-02,4.5843E-02,3.7154E-02,
     &2.6350E-02,1.5945E-02,7.4796E-02,6.6342E-03,3.3814E-02,4.5285E-02,
     &4.9258E-02,4.6140E-02,3.8916E-02,2.7614E-02,1.6684E-02,7.6431E-02,
     &6.4256E-03,3.2718E-02,4.4302E-02,4.8163E-02,4.5963E-02,4.0038E-02,
     &2.8672E-02,1.7798E-02,7.6864E-02,6.1980E-03,3.1806E-02,4.3232E-02,
     &4.7321E-02,4.6023E-02,4.0771E-02,2.9167E-02,1.8567E-02,7.7874E-02,
     &5.9663E-03,3.0964E-02,4.2379E-02,4.6375E-02,4.5692E-02,4.1306E-02,
     &2.9920E-02,1.9375E-02,7.7903E-02/
      DATA ((KA(JS,JT,13, 1),JS=1,9),JT=1,5) /
     &6.1312E-03,2.9682E-02,3.9975E-02,4.3642E-02,4.0252E-02,3.3035E-02,
     &2.3558E-02,1.4050E-02,6.6647E-02,5.9440E-03,2.8920E-02,3.8788E-02,
     &4.2829E-02,4.0420E-02,3.4105E-02,2.4570E-02,1.4699E-02,6.7206E-02,
     &5.7437E-03,2.7994E-02,3.7951E-02,4.1862E-02,4.0303E-02,3.5364E-02,
     &2.5449E-02,1.5507E-02,6.7644E-02,5.5406E-03,2.7263E-02,3.7056E-02,
     &4.0900E-02,3.9818E-02,3.6193E-02,2.6077E-02,1.6255E-02,6.7402E-02,
     &5.3457E-03,2.6652E-02,3.6336E-02,3.9995E-02,3.9467E-02,3.6352E-02,
     &2.6575E-02,1.6998E-02,6.7304E-02/
      DATA ((KA(JS,JT, 1, 2),JS=1,9),JT=1,5) /
     &4.1184E-02,2.7179E-01,3.3427E-01,3.7214E-01,4.0092E-01,3.9640E-01,
     &3.3752E-01,3.1662E-01,7.0395E-01,3.9613E-02,2.5448E-01,3.1529E-01,
     &3.6420E-01,3.9285E-01,3.8292E-01,3.4622E-01,3.3570E-01,7.0351E-01,
     &3.8482E-02,2.4018E-01,3.0435E-01,3.6080E-01,3.8815E-01,3.7286E-01,
     &3.5535E-01,3.5400E-01,6.9477E-01,3.7848E-02,2.2963E-01,2.9537E-01,
     &3.6193E-01,3.8220E-01,3.7308E-01,3.6939E-01,3.6570E-01,6.8368E-01,
     &3.7774E-02,2.2394E-01,2.9359E-01,3.5744E-01,3.7874E-01,3.6962E-01,
     &3.8607E-01,3.7579E-01,6.9280E-01/
      DATA ((KA(JS,JT, 2, 2),JS=1,9),JT=1,5) /
     &3.5631E-02,2.2069E-01,2.7258E-01,3.1550E-01,3.3342E-01,3.2657E-01,
     &2.8024E-01,2.7588E-01,5.9197E-01,3.4562E-02,2.0891E-01,2.6384E-01,
     &3.1412E-01,3.2954E-01,3.2211E-01,2.9490E-01,2.9533E-01,5.8323E-01,
     &3.3571E-02,1.9802E-01,2.5784E-01,3.1122E-01,3.2677E-01,3.1912E-01,
     &3.0590E-01,3.0715E-01,5.7853E-01,3.2736E-02,1.9123E-01,2.5333E-01,
     &3.0890E-01,3.2624E-01,3.1676E-01,3.1863E-01,3.1850E-01,5.8754E-01,
     &3.2264E-02,1.8835E-01,2.5452E-01,3.0891E-01,3.2749E-01,3.1271E-01,
     &3.2651E-01,3.2839E-01,5.9068E-01/
      DATA ((KA(JS,JT, 3, 2),JS=1,9),JT=1,5) /
     &3.1584E-02,1.8152E-01,2.2653E-01,2.6984E-01,2.8266E-01,2.7419E-01,
     &2.3718E-01,2.3355E-01,4.9551E-01,3.0265E-02,1.7457E-01,2.2109E-01,
     &2.6703E-01,2.7958E-01,2.7087E-01,2.4754E-01,2.5014E-01,4.9470E-01,
     &2.9150E-02,1.6735E-01,2.1902E-01,2.6391E-01,2.7849E-01,2.6534E-01,
     &2.5781E-01,2.6293E-01,4.9430E-01,2.8592E-02,1.6364E-01,2.1995E-01,
     &2.6189E-01,2.7866E-01,2.6352E-01,2.7044E-01,2.7363E-01,4.9527E-01,
     &2.8231E-02,1.6046E-01,2.1887E-01,2.6443E-01,2.7635E-01,2.6884E-01,
     &2.7778E-01,2.8066E-01,4.9153E-01/
      DATA ((KA(JS,JT, 4, 2),JS=1,9),JT=1,5) /
     &2.7586E-02,1.5275E-01,1.9293E-01,2.2899E-01,2.4107E-01,2.3244E-01,
     &2.0047E-01,1.9534E-01,4.2244E-01,2.6887E-02,1.4829E-01,1.9195E-01,
     &2.2560E-01,2.3907E-01,2.2550E-01,2.1032E-01,2.1041E-01,4.2198E-01,
     &2.6805E-02,1.4416E-01,1.9016E-01,2.2531E-01,2.3789E-01,2.2485E-01,
     &2.1879E-01,2.2259E-01,4.1901E-01,2.6734E-02,1.4087E-01,1.9109E-01,
     &2.2675E-01,2.3622E-01,2.2628E-01,2.2901E-01,2.3158E-01,4.1030E-01,
     &2.6617E-02,1.3796E-01,1.9377E-01,2.2557E-01,2.3342E-01,2.2649E-01,
     &2.3523E-01,2.3617E-01,4.1160E-01/
      DATA ((KA(JS,JT, 5, 2),JS=1,9),JT=1,5) /
     &2.5332E-02,1.2963E-01,1.6655E-01,1.9042E-01,2.0895E-01,1.9510E-01,
     &1.6916E-01,1.6222E-01,3.6316E-01,2.5181E-02,1.2537E-01,1.6592E-01,
     &1.8998E-01,2.0621E-01,1.9136E-01,1.7764E-01,1.7625E-01,3.5695E-01,
     &2.4972E-02,1.2219E-01,1.6618E-01,1.9129E-01,2.0217E-01,1.9130E-01,
     &1.8535E-01,1.8719E-01,3.4788E-01,2.4749E-02,1.2096E-01,1.6848E-01,
     &1.9087E-01,1.9911E-01,1.9130E-01,1.9341E-01,1.9372E-01,3.4412E-01,
     &2.4660E-02,1.2126E-01,1.7164E-01,1.8946E-01,1.9462E-01,1.9216E-01,
     &1.9926E-01,1.9935E-01,3.3902E-01/
      DATA ((KA(JS,JT, 6, 2),JS=1,9),JT=1,5) /
     &2.3422E-02,1.0907E-01,1.4314E-01,1.6055E-01,1.7919E-01,1.6497E-01,
     &1.4423E-01,1.3518E-01,3.0537E-01,2.3193E-02,1.0714E-01,1.4280E-01,
     &1.6151E-01,1.7408E-01,1.6236E-01,1.4991E-01,1.4676E-01,2.9795E-01,
     &2.2992E-02,1.0582E-01,1.4541E-01,1.6228E-01,1.7059E-01,1.6204E-01,
     &1.5617E-01,1.5704E-01,2.9013E-01,2.2904E-02,1.0595E-01,1.4661E-01,
     &1.6015E-01,1.6718E-01,1.6268E-01,1.6254E-01,1.6133E-01,2.8558E-01,
     &2.3037E-02,1.0659E-01,1.4720E-01,1.5884E-01,1.6394E-01,1.6537E-01,
     &1.6790E-01,1.6640E-01,2.8291E-01/
      DATA ((KA(JS,JT, 7, 2),JS=1,9),JT=1,5) /
     &2.1778E-02,9.4871E-02,1.2415E-01,1.3737E-01,1.5258E-01,1.4160E-01,
     &1.2347E-01,1.1302E-01,2.5408E-01,2.1522E-02,9.3423E-02,1.2417E-01,
     &1.3839E-01,1.4741E-01,1.4006E-01,1.2799E-01,1.2268E-01,2.4943E-01,
     &2.1257E-02,9.3282E-02,1.2533E-01,1.3843E-01,1.4474E-01,1.3911E-01,
     &1.3239E-01,1.3095E-01,2.4208E-01,2.0841E-02,9.3161E-02,1.2672E-01,
     &1.3698E-01,1.4106E-01,1.4019E-01,1.3855E-01,1.3550E-01,2.3874E-01,
     &2.0486E-02,9.4079E-02,1.2713E-01,1.3508E-01,1.3852E-01,1.4171E-01,
     &1.4291E-01,1.3980E-01,2.3641E-01/
      DATA ((KA(JS,JT, 8, 2),JS=1,9),JT=1,5) /
     &2.0219E-02,8.3245E-02,1.0821E-01,1.1854E-01,1.3123E-01,1.2323E-01,
     &1.0617E-01,9.4794E-02,2.1425E-01,1.9540E-02,8.2217E-02,1.0811E-01,
     &1.1985E-01,1.2621E-01,1.2208E-01,1.0997E-01,1.0316E-01,2.0956E-01,
     &1.9115E-02,8.1811E-02,1.0961E-01,1.1959E-01,1.2388E-01,1.2129E-01,
     &1.1337E-01,1.1053E-01,2.0624E-01,1.8733E-02,8.1851E-02,1.1044E-01,
     &1.1828E-01,1.2090E-01,1.2160E-01,1.1850E-01,1.1463E-01,2.0160E-01,
     &1.8489E-02,8.3310E-02,1.0940E-01,1.1607E-01,1.1923E-01,1.2205E-01,
     &1.2223E-01,1.1845E-01,2.0014E-01/
      DATA ((KA(JS,JT, 9, 2),JS=1,9),JT=1,5) /
     &1.7934E-02,7.2499E-02,9.3347E-02,1.0259E-01,1.1263E-01,1.0693E-01,
     &9.0284E-02,7.9546E-02,1.8180E-01,1.7445E-02,7.1879E-02,9.3312E-02,
     &1.0334E-01,1.0867E-01,1.0654E-01,9.3871E-02,8.7011E-02,1.7650E-01,
     &1.7054E-02,7.1164E-02,9.4558E-02,1.0223E-01,1.0632E-01,1.0559E-01,
     &9.7124E-02,9.3354E-02,1.7444E-01,1.6642E-02,7.2006E-02,9.4764E-02,
     &1.0087E-01,1.0340E-01,1.0507E-01,1.0155E-01,9.7191E-02,1.7012E-01,
     &1.6243E-02,7.2866E-02,9.2285E-02,9.9097E-02,1.0185E-01,1.0516E-01,
     &1.0490E-01,1.0097E-01,1.7041E-01/
      DATA ((KA(JS,JT,10, 2),JS=1,9),JT=1,5) /
     &1.5979E-02,6.3035E-02,8.0318E-02,8.8320E-02,9.6214E-02,9.2269E-02,
     &7.7109E-02,6.7263E-02,1.5451E-01,1.5470E-02,6.2313E-02,8.0559E-02,
     &8.8699E-02,9.3120E-02,9.2382E-02,7.9788E-02,7.3810E-02,1.5001E-01,
     &1.4968E-02,6.2321E-02,8.1515E-02,8.7265E-02,9.0898E-02,9.1273E-02,
     &8.3098E-02,7.9462E-02,1.4837E-01,1.4648E-02,6.3201E-02,8.0459E-02,
     &8.6353E-02,8.8769E-02,9.0582E-02,8.6861E-02,8.2886E-02,1.4494E-01,
     &1.4327E-02,6.4058E-02,7.8092E-02,8.4556E-02,8.7537E-02,9.0662E-02,
     &8.9892E-02,8.5887E-02,1.4505E-01/
      DATA ((KA(JS,JT,11, 2),JS=1,9),JT=1,5) /
     &1.3861E-02,5.4196E-02,6.8747E-02,7.5984E-02,8.0767E-02,7.9801E-02,
     &6.6830E-02,5.9302E-02,1.2963E-01,1.3347E-02,5.4113E-02,6.9722E-02,
     &7.5263E-02,7.8466E-02,7.8575E-02,6.9140E-02,6.4556E-02,1.2675E-01,
     &1.3016E-02,5.4555E-02,6.9179E-02,7.4613E-02,7.7291E-02,7.7531E-02,
     &7.2200E-02,6.9022E-02,1.2482E-01,1.2671E-02,5.5408E-02,6.7230E-02,
     &7.3198E-02,7.5526E-02,7.7122E-02,7.5177E-02,7.1296E-02,1.2336E-01,
     &1.2351E-02,5.6031E-02,6.5093E-02,7.1581E-02,7.4883E-02,7.6822E-02,
     &7.7284E-02,7.3771E-02,1.2246E-01/
      DATA ((KA(JS,JT,12, 2),JS=1,9),JT=1,5) /
     &1.2126E-02,4.7285E-02,5.9933E-02,6.5129E-02,6.8290E-02,6.7884E-02,
     &5.7878E-02,5.1782E-02,1.0839E-01,1.1745E-02,4.7398E-02,5.9988E-02,
     &6.4477E-02,6.6821E-02,6.6892E-02,6.0270E-02,5.6137E-02,1.0621E-01,
     &1.1385E-02,4.8238E-02,5.8218E-02,6.3614E-02,6.5819E-02,6.5904E-02,
     &6.2567E-02,5.9036E-02,1.0557E-01,1.1087E-02,4.8582E-02,5.6782E-02,
     &6.2244E-02,6.4582E-02,6.5133E-02,6.4669E-02,6.1446E-02,1.0435E-01,
     &1.0909E-02,4.7898E-02,5.5031E-02,6.0882E-02,6.4057E-02,6.5202E-02,
     &6.6350E-02,6.3114E-02,1.0415E-01/
      DATA ((KA(JS,JT,13, 2),JS=1,9),JT=1,5) /
     &1.1050E-02,4.2216E-02,5.3216E-02,5.6607E-02,5.8614E-02,5.8762E-02,
     &5.1111E-02,4.5278E-02,9.1112E-02,1.0650E-02,4.2640E-02,5.2374E-02,
     &5.5676E-02,5.7428E-02,5.7903E-02,5.3022E-02,4.8756E-02,9.0299E-02,
     &1.0375E-02,4.2997E-02,5.0849E-02,5.4963E-02,5.6516E-02,5.6613E-02,
     &5.4398E-02,5.1351E-02,8.9757E-02,1.0186E-02,4.2550E-02,4.9650E-02,
     &5.4126E-02,5.6087E-02,5.6100E-02,5.5740E-02,5.3111E-02,8.9898E-02,
     &9.9803E-03,4.1596E-02,4.8435E-02,5.3214E-02,5.5733E-02,5.6166E-02,
     &5.6820E-02,5.4773E-02,8.9718E-02/
      DATA ((KA(JS,JT, 1, 3),JS=1,9),JT=1,5) /
     &1.0349E-01,2.2333E-01,4.3448E-01,4.7188E-01,4.9049E-01,5.6379E-01,
     &6.8188E-01,5.5213E-01,8.7331E-01,9.8776E-02,2.3587E-01,4.2090E-01,
     &4.7099E-01,4.8532E-01,5.6756E-01,6.8304E-01,5.3972E-01,8.6585E-01,
     &9.4379E-02,2.4459E-01,4.0703E-01,4.4771E-01,4.8054E-01,5.8051E-01,
     &6.8126E-01,5.2715E-01,8.6189E-01,8.9966E-02,2.4911E-01,4.0891E-01,
     &4.3132E-01,4.8073E-01,5.8214E-01,6.7058E-01,5.2176E-01,8.6463E-01,
     &8.6080E-02,2.4561E-01,4.0823E-01,4.3495E-01,4.8341E-01,5.8583E-01,
     &6.6494E-01,5.1295E-01,8.6781E-01/
      DATA ((KA(JS,JT, 2, 3),JS=1,9),JT=1,5) /
     &9.1121E-02,2.7597E-01,3.6090E-01,3.8864E-01,4.2468E-01,5.0778E-01,
     &6.0614E-01,4.7263E-01,7.5147E-01,8.6968E-02,2.8112E-01,3.5384E-01,
     &3.7604E-01,4.2522E-01,5.1397E-01,5.9893E-01,4.6387E-01,7.5402E-01,
     &8.3177E-02,2.8458E-01,3.4657E-01,3.6832E-01,4.2349E-01,5.1886E-01,
     &5.9537E-01,4.5576E-01,7.6481E-01,7.9593E-02,2.8362E-01,3.4405E-01,
     &3.6602E-01,4.2737E-01,5.2263E-01,5.9169E-01,4.4715E-01,7.7154E-01,
     &7.6305E-02,2.7901E-01,3.3923E-01,3.6563E-01,4.2905E-01,5.2631E-01,
     &5.9188E-01,4.4184E-01,7.8075E-01/
      DATA ((KA(JS,JT, 3, 3),JS=1,9),JT=1,5) /
     &8.1532E-02,2.6557E-01,3.0691E-01,3.2639E-01,3.6998E-01,4.4624E-01,
     &5.2995E-01,4.1015E-01,6.5448E-01,7.8061E-02,2.5705E-01,3.0144E-01,
     &3.1922E-01,3.7157E-01,4.5007E-01,5.2671E-01,4.0238E-01,6.6049E-01,
     &7.4871E-02,2.4964E-01,2.9703E-01,3.1658E-01,3.7272E-01,4.5628E-01,
     &5.2424E-01,3.9540E-01,6.6589E-01,7.1934E-02,2.4252E-01,2.8855E-01,
     &3.1667E-01,3.7723E-01,4.6275E-01,5.1485E-01,3.8931E-01,6.7492E-01,
     &6.9067E-02,2.3451E-01,2.8461E-01,3.1625E-01,3.8425E-01,4.6414E-01,
     &5.0872E-01,3.8671E-01,6.9966E-01/
      DATA ((KA(JS,JT, 4, 3),JS=1,9),JT=1,5) /
     &7.4166E-02,2.1898E-01,2.6310E-01,2.7673E-01,3.2117E-01,3.8906E-01,
     &4.5677E-01,3.5535E-01,5.6605E-01,7.1027E-02,2.1158E-01,2.5634E-01,
     &2.7577E-01,3.2463E-01,3.9708E-01,4.5460E-01,3.5060E-01,5.7431E-01,
     &6.8100E-02,2.0832E-01,2.5127E-01,2.7640E-01,3.2722E-01,4.0091E-01,
     &4.5112E-01,3.4506E-01,5.8564E-01,6.5366E-02,2.0407E-01,2.4599E-01,
     &2.7530E-01,3.3554E-01,4.0555E-01,4.3614E-01,3.4106E-01,6.0722E-01,
     &6.2828E-02,2.0183E-01,2.4016E-01,2.8032E-01,3.4415E-01,4.1256E-01,
     &4.2811E-01,3.3888E-01,6.2274E-01/
      DATA ((KA(JS,JT, 5, 3),JS=1,9),JT=1,5) /
     &6.8085E-02,1.8443E-01,2.2193E-01,2.4125E-01,2.7858E-01,3.3878E-01,
     &3.9224E-01,3.0775E-01,4.8825E-01,6.5024E-02,1.8062E-01,2.1594E-01,
     &2.3959E-01,2.8255E-01,3.4709E-01,3.8693E-01,3.0387E-01,4.9773E-01,
     &6.2309E-02,1.7709E-01,2.1233E-01,2.4099E-01,2.9052E-01,3.5084E-01,
     &3.7550E-01,2.9937E-01,5.1983E-01,6.0049E-02,1.7340E-01,2.0891E-01,
     &2.4567E-01,2.9963E-01,3.5573E-01,3.6423E-01,2.9642E-01,5.3792E-01,
     &5.7860E-02,1.7101E-01,2.0517E-01,2.5155E-01,3.0986E-01,3.5542E-01,
     &3.5482E-01,2.9214E-01,5.5424E-01/
      DATA ((KA(JS,JT, 6, 3),JS=1,9),JT=1,5) /
     &6.1553E-02,1.6486E-01,1.8851E-01,2.1013E-01,2.4069E-01,2.9423E-01,
     &3.2998E-01,2.6499E-01,4.1520E-01,5.8962E-02,1.6161E-01,1.8469E-01,
     &2.1043E-01,2.4572E-01,3.0023E-01,3.2384E-01,2.6279E-01,4.2954E-01,
     &5.6865E-02,1.5845E-01,1.8137E-01,2.1320E-01,2.5567E-01,3.0422E-01,
     &3.1399E-01,2.5823E-01,4.4811E-01,5.4727E-02,1.5470E-01,1.8033E-01,
     &2.2018E-01,2.6466E-01,3.0350E-01,3.0450E-01,2.5479E-01,4.6359E-01,
     &5.2654E-02,1.5114E-01,1.8009E-01,2.2727E-01,2.7074E-01,3.0288E-01,
     &2.9697E-01,2.5146E-01,4.7630E-01/
      DATA ((KA(JS,JT, 7, 3),JS=1,9),JT=1,5) /
     &5.4386E-02,1.4374E-01,1.6223E-01,1.8219E-01,2.0984E-01,2.5288E-01,
     &2.7777E-01,2.2929E-01,3.5662E-01,5.2357E-02,1.4042E-01,1.5995E-01,
     &1.8335E-01,2.1810E-01,2.5710E-01,2.7180E-01,2.2723E-01,3.7033E-01,
     &5.0433E-02,1.3664E-01,1.5916E-01,1.8872E-01,2.2495E-01,2.5913E-01,
     &2.6518E-01,2.2296E-01,3.8796E-01,4.8970E-02,1.3435E-01,1.5882E-01,
     &1.9514E-01,2.3146E-01,2.5861E-01,2.5643E-01,2.1963E-01,4.0045E-01,
     &4.7677E-02,1.3141E-01,1.5996E-01,2.0198E-01,2.3377E-01,2.5698E-01,
     &2.5063E-01,2.1548E-01,4.0471E-01/
      DATA ((KA(JS,JT, 8, 3),JS=1,9),JT=1,5) /
     &4.9561E-02,1.2585E-01,1.4205E-01,1.6041E-01,1.8455E-01,2.1813E-01,
     &2.3719E-01,1.9955E-01,3.0456E-01,4.7879E-02,1.2232E-01,1.4089E-01,
     &1.6222E-01,1.9194E-01,2.2092E-01,2.3163E-01,1.9730E-01,3.1885E-01,
     &4.6426E-02,1.1957E-01,1.4043E-01,1.6717E-01,1.9752E-01,2.2121E-01,
     &2.2638E-01,1.9261E-01,3.3187E-01,4.5268E-02,1.1738E-01,1.4149E-01,
     &1.7294E-01,2.0208E-01,2.2061E-01,2.1864E-01,1.8926E-01,3.4074E-01,
     &4.3956E-02,1.1566E-01,1.4446E-01,1.7951E-01,2.0361E-01,2.1938E-01,
     &2.1462E-01,1.8542E-01,3.4583E-01/
      DATA ((KA(JS,JT, 9, 3),JS=1,9),JT=1,5) /
     &4.5250E-02,1.0911E-01,1.2308E-01,1.4028E-01,1.6172E-01,1.8816E-01,
     &2.0368E-01,1.7299E-01,2.5859E-01,4.3924E-02,1.0618E-01,1.2262E-01,
     &1.4258E-01,1.6714E-01,1.8918E-01,1.9807E-01,1.7073E-01,2.7235E-01,
     &4.2608E-02,1.0467E-01,1.2300E-01,1.4745E-01,1.7253E-01,1.8886E-01,
     &1.9316E-01,1.6589E-01,2.8262E-01,4.1423E-02,1.0229E-01,1.2419E-01,
     &1.5295E-01,1.7546E-01,1.8853E-01,1.8673E-01,1.6267E-01,2.8816E-01,
     &4.0021E-02,1.0144E-01,1.2853E-01,1.5736E-01,1.7632E-01,1.8748E-01,
     &1.8330E-01,1.5887E-01,2.9011E-01/
      DATA ((KA(JS,JT,10, 3),JS=1,9),JT=1,5) /
     &4.1171E-02,9.3658E-02,1.0622E-01,1.2188E-01,1.4076E-01,1.6261E-01,
     &1.7423E-01,1.4922E-01,2.1862E-01,3.9662E-02,9.1742E-02,1.0641E-01,
     &1.2434E-01,1.4583E-01,1.6228E-01,1.6976E-01,1.4678E-01,2.3073E-01,
     &3.8151E-02,8.9581E-02,1.0765E-01,1.2937E-01,1.4971E-01,1.6177E-01,
     &1.6479E-01,1.4256E-01,2.3771E-01,3.6829E-02,8.8190E-02,1.0980E-01,
     &1.3385E-01,1.5088E-01,1.6121E-01,1.5970E-01,1.3919E-01,2.4389E-01,
     &3.5799E-02,8.7081E-02,1.1397E-01,1.3613E-01,1.5068E-01,1.6032E-01,
     &1.5668E-01,1.3612E-01,2.4347E-01/
      DATA ((KA(JS,JT,11, 3),JS=1,9),JT=1,5) /
     &3.5950E-02,7.9375E-02,9.2025E-02,1.0686E-01,1.2416E-01,1.3928E-01,
     &1.4761E-01,1.2730E-01,1.9139E-01,3.4807E-02,7.7447E-02,9.2655E-02,
     &1.1006E-01,1.2736E-01,1.3892E-01,1.4381E-01,1.2426E-01,1.9723E-01,
     &3.3668E-02,7.6215E-02,9.4748E-02,1.1430E-01,1.2842E-01,1.3852E-01,
     &1.3892E-01,1.2007E-01,2.0316E-01,3.2675E-02,7.5405E-02,9.7335E-02,
     &1.1502E-01,1.2820E-01,1.3796E-01,1.3569E-01,1.1793E-01,2.0391E-01,
     &3.1803E-02,7.5385E-02,1.0078E-01,1.1505E-01,1.2792E-01,1.3782E-01,
     &1.3291E-01,1.1573E-01,2.0592E-01/
      DATA ((KA(JS,JT,12, 3),JS=1,9),JT=1,5) /
     &3.2107E-02,6.7817E-02,8.0190E-02,9.4418E-02,1.0883E-01,1.2016E-01,
     &1.2478E-01,1.0916E-01,1.6437E-01,3.0865E-02,6.6495E-02,8.1339E-02,
     &9.7570E-02,1.0958E-01,1.1971E-01,1.2159E-01,1.0575E-01,1.6979E-01,
     &2.9814E-02,6.5982E-02,8.4322E-02,9.8160E-02,1.0983E-01,1.1899E-01,
     &1.1775E-01,1.0260E-01,1.7251E-01,2.8719E-02,6.6210E-02,8.5962E-02,
     &9.8372E-02,1.0963E-01,1.1883E-01,1.1590E-01,1.0037E-01,1.7377E-01,
     &2.7641E-02,6.7001E-02,8.6676E-02,9.9268E-02,1.1059E-01,1.1880E-01,
     &1.1301E-01,9.8900E-02,1.7602E-01/
      DATA ((KA(JS,JT,13, 3),JS=1,9),JT=1,5) /
     &2.9283E-02,6.0178E-02,7.1238E-02,8.4877E-02,9.5368E-02,1.0416E-01,
     &1.0619E-01,9.4038E-02,1.4273E-01,2.8137E-02,5.9367E-02,7.3469E-02,
     &8.5617E-02,9.5728E-02,1.0364E-01,1.0343E-01,9.0972E-02,1.4741E-01,
     &2.7056E-02,5.9346E-02,7.4992E-02,8.5630E-02,9.5820E-02,1.0325E-01,
     &1.0105E-01,8.7823E-02,1.4877E-01,2.6017E-02,6.0117E-02,7.5313E-02,
     &8.5867E-02,9.6184E-02,1.0321E-01,9.9567E-02,8.6122E-02,1.5028E-01,
     &2.5188E-02,6.1586E-02,7.5405E-02,8.7449E-02,9.7275E-02,1.0347E-01,
     &9.7619E-02,8.4749E-02,1.5271E-01/
      DATA ((KA(JS,JT, 1, 4),JS=1,9),JT=1,5) /
     &2.0140E-01,2.2296E-01,3.8441E-01,7.9237E-01,8.6626E-01,8.2263E-01,
     &7.4305E-01,7.5768E-01,1.5145E+00,1.9181E-01,2.1723E-01,4.1174E-01,
     &7.7988E-01,8.4188E-01,7.8979E-01,7.0362E-01,7.1757E-01,1.4753E+00,
     &1.8358E-01,2.1296E-01,4.3167E-01,7.6375E-01,8.2127E-01,7.5942E-01,
     &6.7535E-01,6.8460E-01,1.4372E+00,1.7731E-01,2.0956E-01,4.3260E-01,
     &7.5378E-01,8.0524E-01,7.2961E-01,6.5477E-01,6.4648E-01,1.3999E+00,
     &1.7164E-01,2.1055E-01,4.2755E-01,7.3334E-01,7.8436E-01,7.1000E-01,
     &6.4297E-01,6.0884E-01,1.3521E+00/
      DATA ((KA(JS,JT, 2, 4),JS=1,9),JT=1,5) /
     &1.7302E-01,2.0244E-01,5.3076E-01,6.9942E-01,7.3274E-01,6.9098E-01,
     &6.5285E-01,6.3638E-01,1.2559E+00,1.6489E-01,1.9797E-01,5.4053E-01,
     &6.8204E-01,7.0789E-01,6.6109E-01,6.3152E-01,6.0382E-01,1.2010E+00,
     &1.5760E-01,1.9570E-01,5.4478E-01,6.6415E-01,6.8272E-01,6.3617E-01,
     &6.0950E-01,5.7193E-01,1.1640E+00,1.5184E-01,1.9435E-01,5.4381E-01,
     &6.4780E-01,6.6147E-01,6.1692E-01,5.8732E-01,5.4197E-01,1.1223E+00,
     &1.4698E-01,1.9520E-01,5.4107E-01,6.3896E-01,6.4395E-01,6.0782E-01,
     &5.7401E-01,5.1623E-01,1.0839E+00/
      DATA ((KA(JS,JT, 3, 4),JS=1,9),JT=1,5) /
     &1.5095E-01,2.3961E-01,5.3891E-01,5.9274E-01,6.0360E-01,5.9975E-01,
     &5.7583E-01,5.3639E-01,1.0254E+00,1.4378E-01,2.4579E-01,5.2840E-01,
     &5.8072E-01,5.8574E-01,5.7325E-01,5.5457E-01,5.1150E-01,9.9368E-01,
     &1.3744E-01,2.5218E-01,5.1071E-01,5.6679E-01,5.6782E-01,5.5647E-01,
     &5.3781E-01,4.7984E-01,9.5622E-01,1.3182E-01,2.5642E-01,4.9891E-01,
     &5.5373E-01,5.5212E-01,5.4201E-01,5.2720E-01,4.5497E-01,9.3692E-01,
     &1.2736E-01,2.6156E-01,4.9042E-01,5.4609E-01,5.4094E-01,5.2788E-01,
     &5.2063E-01,4.2896E-01,9.1393E-01/
      DATA ((KA(JS,JT, 4, 4),JS=1,9),JT=1,5) /
     &1.3296E-01,3.0808E-01,4.5560E-01,5.0161E-01,5.1973E-01,5.1660E-01,
     &5.1162E-01,4.5889E-01,8.7778E-01,1.2659E-01,3.1156E-01,4.4164E-01,
     &4.8779E-01,5.0041E-01,4.9812E-01,4.9015E-01,4.3243E-01,8.4542E-01,
     &1.2094E-01,3.1188E-01,4.3105E-01,4.7578E-01,4.8617E-01,4.8333E-01,
     &4.7842E-01,4.0299E-01,8.1678E-01,1.1593E-01,3.1351E-01,4.2237E-01,
     &4.6451E-01,4.7350E-01,4.7079E-01,4.7610E-01,3.7858E-01,7.9667E-01,
     &1.1150E-01,3.1306E-01,4.1390E-01,4.5362E-01,4.6429E-01,4.6167E-01,
     &4.7081E-01,3.5772E-01,7.7552E-01/
      DATA ((KA(JS,JT, 5, 4),JS=1,9),JT=1,5) /
     &1.1755E-01,3.2807E-01,3.8548E-01,4.2521E-01,4.4554E-01,4.5203E-01,
     &4.4500E-01,3.9225E-01,7.4478E-01,1.1209E-01,3.1909E-01,3.7705E-01,
     &4.1235E-01,4.2996E-01,4.3302E-01,4.3279E-01,3.6494E-01,7.1780E-01,
     &1.0716E-01,3.1181E-01,3.6570E-01,3.9834E-01,4.1575E-01,4.2162E-01,
     &4.2981E-01,3.4051E-01,6.9974E-01,1.0275E-01,3.0301E-01,3.5750E-01,
     &3.8990E-01,4.0553E-01,4.1539E-01,4.2536E-01,3.1843E-01,6.8036E-01,
     &9.8998E-02,2.9446E-01,3.5111E-01,3.8417E-01,3.9923E-01,4.1474E-01,
     &4.2083E-01,3.0243E-01,6.6644E-01/
      DATA ((KA(JS,JT, 6, 4),JS=1,9),JT=1,5) /
     &1.0705E-01,2.7318E-01,3.3208E-01,3.6143E-01,3.8591E-01,3.9313E-01,
     &3.9284E-01,3.3741E-01,6.4786E-01,1.0199E-01,2.6545E-01,3.2251E-01,
     &3.5040E-01,3.7450E-01,3.7890E-01,3.8585E-01,3.0993E-01,6.2347E-01,
     &9.7437E-02,2.5576E-01,3.1499E-01,3.4107E-01,3.6300E-01,3.7247E-01,
     &3.8009E-01,2.8815E-01,6.0580E-01,9.3482E-02,2.4922E-01,3.0800E-01,
     &3.3313E-01,3.5414E-01,3.7096E-01,3.7706E-01,2.7157E-01,5.9892E-01,
     &9.0031E-02,2.4481E-01,3.0199E-01,3.2745E-01,3.5204E-01,3.7018E-01,
     &3.6552E-01,2.5507E-01,5.9364E-01/
      DATA ((KA(JS,JT, 7, 4),JS=1,9),JT=1,5) /
     &1.0201E-01,2.3487E-01,2.8528E-01,3.1378E-01,3.3635E-01,3.4598E-01,
     &3.4770E-01,2.9069E-01,5.6026E-01,9.7333E-02,2.2730E-01,2.7830E-01,
     &3.0507E-01,3.2187E-01,3.3481E-01,3.4172E-01,2.6797E-01,5.4227E-01,
     &9.3243E-02,2.2136E-01,2.6944E-01,2.9618E-01,3.1454E-01,3.2973E-01,
     &3.3451E-01,2.4821E-01,5.2884E-01,8.9660E-02,2.1638E-01,2.6334E-01,
     &2.9056E-01,3.1245E-01,3.2791E-01,3.2519E-01,2.3192E-01,5.2407E-01,
     &8.6492E-02,2.1156E-01,2.5984E-01,2.8528E-01,3.1573E-01,3.2789E-01,
     &3.1681E-01,2.1806E-01,5.2688E-01/
      DATA ((KA(JS,JT, 8, 4),JS=1,9),JT=1,5) /
     &1.0039E-01,2.1049E-01,2.5117E-01,2.7733E-01,2.9294E-01,3.0451E-01,
     &3.0671E-01,2.5418E-01,4.9108E-01,9.6148E-02,2.0539E-01,2.4350E-01,
     &2.6931E-01,2.8451E-01,2.9582E-01,3.0170E-01,2.3605E-01,4.7511E-01,
     &9.2145E-02,2.0009E-01,2.3646E-01,2.6177E-01,2.7896E-01,2.9276E-01,
     &2.9264E-01,2.1892E-01,4.6537E-01,8.8569E-02,1.9568E-01,2.3097E-01,
     &2.5688E-01,2.7814E-01,2.9214E-01,2.8481E-01,2.0263E-01,4.6603E-01,
     &8.5629E-02,1.9094E-01,2.2714E-01,2.5259E-01,2.7953E-01,2.8904E-01,
     &2.7433E-01,1.9066E-01,4.6777E-01/
      DATA ((KA(JS,JT, 9, 4),JS=1,9),JT=1,5) /
     &9.8021E-02,1.9151E-01,2.2309E-01,2.4564E-01,2.5865E-01,2.6783E-01,
     &2.6894E-01,2.2292E-01,4.2854E-01,9.3022E-02,1.8527E-01,2.1592E-01,
     &2.3651E-01,2.5064E-01,2.6055E-01,2.6499E-01,2.0617E-01,4.1580E-01,
     &8.8595E-02,1.8097E-01,2.1073E-01,2.3156E-01,2.4703E-01,2.5851E-01,
     &2.5441E-01,1.9146E-01,4.1005E-01,8.4486E-02,1.7670E-01,2.0686E-01,
     &2.2734E-01,2.4622E-01,2.5730E-01,2.4711E-01,1.7700E-01,4.1054E-01,
     &8.1546E-02,1.7284E-01,2.0523E-01,2.2674E-01,2.4921E-01,2.5266E-01,
     &2.3614E-01,1.6619E-01,4.1551E-01/
      DATA ((KA(JS,JT,10, 4),JS=1,9),JT=1,5) /
     &9.1049E-02,1.7362E-01,1.9833E-01,2.1764E-01,2.2798E-01,2.3471E-01,
     &2.3646E-01,1.9422E-01,3.7343E-01,8.6996E-02,1.6791E-01,1.9240E-01,
     &2.1075E-01,2.2237E-01,2.2936E-01,2.3178E-01,1.7985E-01,3.6356E-01,
     &8.2800E-02,1.6395E-01,1.8777E-01,2.0552E-01,2.1940E-01,2.2862E-01,
     &2.2169E-01,1.6614E-01,3.6046E-01,7.8811E-02,1.5975E-01,1.8561E-01,
     &2.0375E-01,2.1988E-01,2.2450E-01,2.1345E-01,1.5492E-01,3.6096E-01,
     &7.5529E-02,1.5650E-01,1.8353E-01,2.0505E-01,2.1950E-01,2.1739E-01,
     &2.0454E-01,1.4507E-01,3.6055E-01/
      DATA ((KA(JS,JT,11, 4),JS=1,9),JT=1,5) /
     &7.7672E-02,1.5145E-01,1.7382E-01,1.8990E-01,1.9990E-01,2.0432E-01,
     &2.0547E-01,1.6386E-01,3.1843E-01,7.3723E-02,1.4611E-01,1.6807E-01,
     &1.8489E-01,1.9610E-01,2.0254E-01,1.9720E-01,1.5217E-01,3.1488E-01,
     &7.0457E-02,1.4249E-01,1.6412E-01,1.8266E-01,1.9585E-01,1.9778E-01,
     &1.8906E-01,1.4085E-01,3.1421E-01,6.7094E-02,1.3863E-01,1.6386E-01,
     &1.8321E-01,1.9415E-01,1.9186E-01,1.8023E-01,1.3105E-01,3.1088E-01,
     &6.4100E-02,1.3524E-01,1.6357E-01,1.8497E-01,1.9137E-01,1.8498E-01,
     &1.7319E-01,1.2321E-01,3.0324E-01/
      DATA ((KA(JS,JT,12, 4),JS=1,9),JT=1,5) /
     &6.6765E-02,1.2994E-01,1.4944E-01,1.6445E-01,1.7587E-01,1.8101E-01,
     &1.7769E-01,1.3984E-01,2.7673E-01,6.3023E-02,1.2593E-01,1.4588E-01,
     &1.6162E-01,1.7387E-01,1.7653E-01,1.6990E-01,1.2980E-01,2.7397E-01,
     &6.0078E-02,1.2173E-01,1.4433E-01,1.6136E-01,1.7141E-01,1.7100E-01,
     &1.6190E-01,1.2017E-01,2.6912E-01,5.7591E-02,1.1797E-01,1.4432E-01,
     &1.6200E-01,1.6903E-01,1.6549E-01,1.5510E-01,1.1177E-01,2.6329E-01,
     &5.5506E-02,1.1583E-01,1.4556E-01,1.5779E-01,1.6302E-01,1.5857E-01,
     &1.4926E-01,1.0509E-01,2.5258E-01/
      DATA ((KA(JS,JT,13, 4),JS=1,9),JT=1,5) /
     &5.9522E-02,1.1440E-01,1.3268E-01,1.4518E-01,1.5668E-01,1.6016E-01,
     &1.5672E-01,1.2200E-01,2.4269E-01,5.6603E-02,1.1049E-01,1.3023E-01,
     &1.4451E-01,1.5437E-01,1.5452E-01,1.4924E-01,1.1346E-01,2.3750E-01,
     &5.4101E-02,1.0639E-01,1.2967E-01,1.4482E-01,1.5052E-01,1.4869E-01,
     &1.4191E-01,1.0569E-01,2.3366E-01,5.1959E-02,1.0421E-01,1.3053E-01,
     &1.4062E-01,1.4577E-01,1.4358E-01,1.3605E-01,9.8273E-02,2.2442E-01,
     &4.9821E-02,1.0307E-01,1.3162E-01,1.3605E-01,1.4048E-01,1.3772E-01,
     &1.3142E-01,9.2354E-02,2.1552E-01/
      DATA ((KA(JS,JT, 1, 5),JS=1,9),JT=1,5) /
     &4.4662E-01,4.5491E-01,4.6518E-01,4.8073E-01,9.6301E-01,1.0662E+00,
     &9.6837E-01,6.1516E-01,1.5492E+00,4.3070E-01,4.3901E-01,4.4894E-01,
     &4.8843E-01,9.7366E-01,1.0185E+00,9.1919E-01,5.9289E-01,1.4372E+00,
     &4.1920E-01,4.2623E-01,4.3584E-01,5.1853E-01,9.4077E-01,9.6967E-01,
     &8.7962E-01,5.7716E-01,1.3511E+00,4.1320E-01,4.1951E-01,4.2768E-01,
     &5.3113E-01,8.9548E-01,9.3086E-01,8.2656E-01,5.7871E-01,1.2540E+00,
     &4.1049E-01,4.1583E-01,4.2551E-01,5.4820E-01,8.6249E-01,8.9543E-01,
     &7.7827E-01,5.9312E-01,1.1774E+00/
      DATA ((KA(JS,JT, 2, 5),JS=1,9),JT=1,5) /
     &3.7419E-01,3.9315E-01,4.1387E-01,7.3684E-01,9.3729E-01,9.5798E-01,
     &8.1977E-01,5.4534E-01,1.3830E+00,3.6046E-01,3.7870E-01,3.9949E-01,
     &7.5022E-01,8.9119E-01,9.0575E-01,7.6682E-01,5.2408E-01,1.3014E+00,
     &3.5058E-01,3.6732E-01,3.9129E-01,7.6077E-01,8.5537E-01,8.6853E-01,
     &7.2131E-01,5.2368E-01,1.1992E+00,3.4363E-01,3.5974E-01,3.8593E-01,
     &7.6592E-01,8.1963E-01,8.3241E-01,6.8939E-01,5.2630E-01,1.1280E+00,
     &3.4117E-01,3.5633E-01,3.8040E-01,7.4257E-01,7.9365E-01,7.8846E-01,
     &6.5921E-01,5.2675E-01,1.0716E+00/
      DATA ((KA(JS,JT, 3, 5),JS=1,9),JT=1,5) /
     &3.1617E-01,3.4533E-01,4.9004E-01,8.0662E-01,8.6490E-01,8.2831E-01,
     &6.9369E-01,4.9053E-01,1.2685E+00,3.0386E-01,3.3185E-01,4.9271E-01,
     &7.6499E-01,8.1967E-01,7.8960E-01,6.4565E-01,4.7244E-01,1.1699E+00,
     &2.9464E-01,3.2055E-01,5.0043E-01,7.2785E-01,7.8235E-01,7.5123E-01,
     &6.1372E-01,4.7097E-01,1.0909E+00,2.8765E-01,3.1339E-01,5.0754E-01,
     &6.9697E-01,7.5208E-01,7.1843E-01,5.8571E-01,4.6400E-01,1.0036E+00,
     &2.8344E-01,3.0751E-01,5.1242E-01,6.6855E-01,7.1995E-01,6.9218E-01,
     &5.7184E-01,4.7451E-01,9.2127E-01/
      DATA ((KA(JS,JT, 4, 5),JS=1,9),JT=1,5) /
     &2.6775E-01,3.0604E-01,6.4660E-01,7.3076E-01,7.6521E-01,7.2923E-01,
     &5.8618E-01,4.3353E-01,1.1015E+00,2.5632E-01,2.9306E-01,6.2522E-01,
     &6.9215E-01,7.2674E-01,6.8433E-01,5.5230E-01,4.1918E-01,1.0081E+00,
     &2.4780E-01,2.8292E-01,5.9390E-01,6.5413E-01,6.8773E-01,6.5028E-01,
     &5.2160E-01,4.1724E-01,9.3062E-01,2.4100E-01,2.7551E-01,5.7041E-01,
     &6.2793E-01,6.5534E-01,6.2452E-01,5.0866E-01,4.1719E-01,8.4917E-01,
     &2.3658E-01,2.6967E-01,5.4813E-01,6.0747E-01,6.2636E-01,5.9897E-01,
     &4.9899E-01,4.2737E-01,7.8635E-01/
      DATA ((KA(JS,JT, 5, 5),JS=1,9),JT=1,5) /
     &2.2714E-01,3.0892E-01,5.8868E-01,6.5760E-01,6.7083E-01,6.2555E-01,
     &5.1259E-01,3.8131E-01,9.5049E-01,2.1666E-01,3.0798E-01,5.5062E-01,
     &6.2165E-01,6.2939E-01,5.9031E-01,4.8040E-01,3.7074E-01,8.6898E-01,
     &2.0871E-01,3.0702E-01,5.2691E-01,5.8794E-01,5.9599E-01,5.6236E-01,
     &4.6150E-01,3.6395E-01,7.8288E-01,2.0276E-01,3.0943E-01,5.0433E-01,
     &5.5988E-01,5.6518E-01,5.3494E-01,4.4833E-01,3.6773E-01,7.2419E-01,
     &1.9892E-01,3.1215E-01,4.8278E-01,5.3676E-01,5.4170E-01,5.0924E-01,
     &4.4109E-01,3.7855E-01,6.8358E-01/
      DATA ((KA(JS,JT, 6, 5),JS=1,9),JT=1,5) /
     &1.9298E-01,3.8310E-01,5.2601E-01,5.8117E-01,5.8505E-01,5.4459E-01,
     &4.4513E-01,3.3639E-01,8.1804E-01,1.8380E-01,3.7978E-01,4.9784E-01,
     &5.4325E-01,5.4503E-01,5.1006E-01,4.1750E-01,3.2606E-01,7.4136E-01,
     &1.7694E-01,3.8180E-01,4.7027E-01,5.1699E-01,5.1079E-01,4.8235E-01,
     &4.0208E-01,3.2052E-01,6.7777E-01,1.7133E-01,3.7179E-01,4.4558E-01,
     &4.8630E-01,4.9002E-01,4.5737E-01,3.9155E-01,3.2262E-01,6.2593E-01,
     &1.6754E-01,3.5443E-01,4.2444E-01,4.6383E-01,4.6954E-01,4.4064E-01,
     &3.8904E-01,3.3286E-01,5.7664E-01/
      DATA ((KA(JS,JT, 7, 5),JS=1,9),JT=1,5) /
     &1.6680E-01,3.8673E-01,4.6977E-01,5.0982E-01,5.0645E-01,4.7419E-01,
     &3.9067E-01,2.9795E-01,7.1500E-01,1.5848E-01,3.6483E-01,4.3657E-01,
     &4.7719E-01,4.7339E-01,4.4276E-01,3.6591E-01,2.8456E-01,6.4266E-01,
     &1.5206E-01,3.4607E-01,4.1294E-01,4.4755E-01,4.4747E-01,4.1880E-01,
     &3.5274E-01,2.8027E-01,5.8922E-01,1.4707E-01,3.2827E-01,3.9251E-01,
     &4.2303E-01,4.2524E-01,3.9890E-01,3.4920E-01,2.8325E-01,5.4340E-01,
     &1.4361E-01,3.1545E-01,3.7348E-01,4.0710E-01,4.0646E-01,3.8591E-01,
     &3.3880E-01,2.9285E-01,5.0986E-01/
      DATA ((KA(JS,JT, 8, 5),JS=1,9),JT=1,5) /
     &1.4820E-01,3.5091E-01,4.2013E-01,4.5147E-01,4.5056E-01,4.1729E-01,
     &3.4786E-01,2.6599E-01,6.3121E-01,1.4070E-01,3.2895E-01,3.9148E-01,
     &4.1739E-01,4.1786E-01,3.8937E-01,3.2642E-01,2.5048E-01,5.6833E-01,
     &1.3491E-01,3.1064E-01,3.6928E-01,3.9231E-01,3.9615E-01,3.7023E-01,
     &3.1619E-01,2.4413E-01,5.2283E-01,1.3040E-01,2.9486E-01,3.4865E-01,
     &3.7267E-01,3.7585E-01,3.5308E-01,3.1289E-01,2.4763E-01,4.8158E-01,
     &1.2713E-01,2.8372E-01,3.3299E-01,3.5768E-01,3.6293E-01,3.4468E-01,
     &2.9924E-01,2.5414E-01,4.5058E-01/
      DATA ((KA(JS,JT, 9, 5),JS=1,9),JT=1,5) /
     &1.3333E-01,3.1732E-01,3.7806E-01,3.9822E-01,3.9576E-01,3.6830E-01,
     &3.0959E-01,2.3751E-01,5.5734E-01,1.2728E-01,2.9745E-01,3.4973E-01,
     &3.7018E-01,3.6774E-01,3.4366E-01,2.8994E-01,2.2165E-01,5.0172E-01,
     &1.2260E-01,2.7734E-01,3.2656E-01,3.4735E-01,3.4508E-01,3.2798E-01,
     &2.8353E-01,2.1398E-01,4.5989E-01,1.1943E-01,2.6308E-01,3.0660E-01,
     &3.2980E-01,3.3173E-01,3.1278E-01,2.7390E-01,2.1485E-01,4.2942E-01,
     &1.1701E-01,2.4928E-01,2.9183E-01,3.1474E-01,3.2039E-01,3.0863E-01,
     &2.6433E-01,2.1871E-01,3.9836E-01/
      DATA ((KA(JS,JT,10, 5),JS=1,9),JT=1,5) /
     &1.2488E-01,2.8649E-01,3.3436E-01,3.5060E-01,3.4715E-01,3.2381E-01,
     &2.7352E-01,2.0897E-01,4.9029E-01,1.1908E-01,2.6494E-01,3.0883E-01,
     &3.2464E-01,3.2171E-01,3.0303E-01,2.5647E-01,1.9520E-01,4.4008E-01,
     &1.1556E-01,2.4763E-01,2.8674E-01,3.0514E-01,3.0302E-01,2.8868E-01,
     &2.5222E-01,1.8782E-01,4.0842E-01,1.1322E-01,2.3334E-01,2.7126E-01,
     &2.8846E-01,2.9340E-01,2.7863E-01,2.4033E-01,1.8521E-01,3.8163E-01,
     &1.1126E-01,2.2285E-01,2.5915E-01,2.7811E-01,2.8680E-01,2.7376E-01,
     &2.3030E-01,1.8823E-01,3.5861E-01/
      DATA ((KA(JS,JT,11, 5),JS=1,9),JT=1,5) /
     &1.2133E-01,2.4900E-01,2.8640E-01,2.9703E-01,2.9301E-01,2.7475E-01,
     &2.3250E-01,1.7899E-01,4.0785E-01,1.1707E-01,2.3382E-01,2.6584E-01,
     &2.7776E-01,2.7455E-01,2.6096E-01,2.2631E-01,1.6847E-01,3.7573E-01,
     &1.1375E-01,2.1845E-01,2.5115E-01,2.6117E-01,2.6335E-01,2.5113E-01,
     &2.1653E-01,1.6132E-01,3.4922E-01,1.1166E-01,2.0864E-01,2.3761E-01,
     &2.5163E-01,2.5840E-01,2.4419E-01,2.0592E-01,1.6130E-01,3.3156E-01,
     &1.1026E-01,2.0025E-01,2.2827E-01,2.4711E-01,2.5459E-01,2.3449E-01,
     &1.9737E-01,1.6301E-01,3.1155E-01/
      DATA ((KA(JS,JT,12, 5),JS=1,9),JT=1,5) /
     &1.2068E-01,2.2498E-01,2.5241E-01,2.6093E-01,2.5316E-01,2.3830E-01,
     &2.0580E-01,1.5434E-01,3.4650E-01,1.1732E-01,2.1063E-01,2.3754E-01,
     &2.4422E-01,2.4130E-01,2.2913E-01,1.9581E-01,1.4538E-01,3.2419E-01,
     &1.1291E-01,2.0050E-01,2.2356E-01,2.3528E-01,2.3734E-01,2.2099E-01,
     &1.8732E-01,1.4169E-01,3.0809E-01,1.0801E-01,1.9213E-01,2.1514E-01,
     &2.2964E-01,2.3229E-01,2.1151E-01,1.7615E-01,1.4140E-01,2.8807E-01,
     &1.0409E-01,1.8478E-01,2.0856E-01,2.2937E-01,2.2388E-01,2.0038E-01,
     &1.7052E-01,1.4327E-01,2.6150E-01/
      DATA ((KA(JS,JT,13, 5),JS=1,9),JT=1,5) /
     &1.1514E-01,2.0822E-01,2.3178E-01,2.3757E-01,2.2988E-01,2.1559E-01,
     &1.8505E-01,1.3755E-01,3.0255E-01,1.0856E-01,1.9378E-01,2.1572E-01,
     &2.2466E-01,2.2140E-01,2.1071E-01,1.7476E-01,1.2903E-01,2.8912E-01,
     &1.0257E-01,1.8315E-01,2.0306E-01,2.1501E-01,2.1837E-01,1.9973E-01,
     &1.6546E-01,1.2594E-01,2.7440E-01,9.7502E-02,1.7382E-01,1.9450E-01,
     &2.1448E-01,2.0917E-01,1.8735E-01,1.5671E-01,1.2605E-01,2.4875E-01,
     &9.4048E-02,1.6507E-01,1.8951E-01,2.1087E-01,1.9884E-01,1.7732E-01,
     &1.5188E-01,1.2757E-01,2.1998E-01/
      DATA ((KA(JS,JT, 1, 6),JS=1,9),JT=1,5) /
     &1.2242E+00,1.1159E+00,1.0120E+00,9.1389E-01,8.1856E-01,1.1483E+00,
     &9.8709E-01,9.2159E-01,4.7502E-01,1.1928E+00,1.0903E+00,9.9311E-01,
     &9.0065E-01,8.3223E-01,1.1145E+00,9.5738E-01,9.2153E-01,6.9449E-01,
     &1.1808E+00,1.0824E+00,9.8824E-01,8.9828E-01,8.9586E-01,1.0864E+00,
     &9.3281E-01,9.2795E-01,8.4213E-01,1.1721E+00,1.0760E+00,9.8481E-01,
     &8.9679E-01,9.5583E-01,1.0646E+00,9.4941E-01,9.2047E-01,8.5863E-01,
     &1.1790E+00,1.0814E+00,9.8996E-01,8.9927E-01,1.0035E+00,1.0346E+00,
     &9.5167E-01,9.2657E-01,7.2509E-01/
      DATA ((KA(JS,JT, 2, 6),JS=1,9),JT=1,5) /
     &1.0264E+00,9.4284E-01,8.6709E-01,7.9559E-01,1.1080E+00,1.0254E+00,
     &9.2224E-01,8.7122E-01,1.0512E+00,1.0018E+00,9.2359E-01,8.5299E-01,
     &7.8672E-01,1.0674E+00,9.8417E-01,8.9700E-01,8.6779E-01,9.4293E-01,
     &9.8988E-01,9.1596E-01,8.4833E-01,7.8816E-01,1.0499E+00,9.5536E-01,
     &8.7579E-01,8.5648E-01,8.1445E-01,9.8822E-01,9.1536E-01,8.4663E-01,
     &7.9377E-01,1.0292E+00,9.3843E-01,8.7227E-01,8.6174E-01,7.0730E-01,
     &9.8800E-01,9.1393E-01,8.4855E-01,8.2484E-01,1.0072E+00,9.4807E-01,
     &8.8827E-01,8.7216E-01,5.9331E-01/
      DATA ((KA(JS,JT, 3, 6),JS=1,9),JT=1,5) /
     &8.6794E-01,8.0430E-01,7.5031E-01,8.9541E-01,1.0214E+00,9.4865E-01,
     &8.5821E-01,7.9700E-01,8.7719E-01,8.4313E-01,7.8532E-01,7.3608E-01,
     &9.3906E-01,9.7060E-01,9.0816E-01,8.3425E-01,7.9621E-01,7.6329E-01,
     &8.3157E-01,7.7858E-01,7.3266E-01,9.5972E-01,9.4116E-01,8.8096E-01,
     &8.0848E-01,7.9477E-01,6.5966E-01,8.2987E-01,7.7678E-01,7.3040E-01,
     &9.3971E-01,9.0923E-01,8.7002E-01,8.0556E-01,8.1217E-01,6.0022E-01,
     &8.2093E-01,7.6968E-01,7.2610E-01,9.2404E-01,8.9670E-01,8.5391E-01,
     &7.9373E-01,8.1610E-01,5.3117E-01/
      DATA ((KA(JS,JT, 4, 6),JS=1,9),JT=1,5) /
     &7.3504E-01,6.8896E-01,6.5474E-01,9.5125E-01,9.3510E-01,8.8191E-01,
     &7.8339E-01,7.2709E-01,7.9136E-01,7.1205E-01,6.7167E-01,6.7088E-01,
     &9.0689E-01,8.7886E-01,8.4133E-01,7.6196E-01,7.2232E-01,6.9067E-01,
     &7.0055E-01,6.6424E-01,7.0492E-01,8.8094E-01,8.5026E-01,8.0832E-01,
     &7.4494E-01,7.3074E-01,6.1263E-01,6.9588E-01,6.6015E-01,7.3043E-01,
     &8.5040E-01,8.2745E-01,7.8458E-01,7.3728E-01,7.3901E-01,5.3700E-01,
     &6.8558E-01,6.5206E-01,7.5371E-01,8.2365E-01,8.2063E-01,7.6670E-01,
     &7.3328E-01,7.4717E-01,4.4797E-01/
      DATA ((KA(JS,JT, 5, 6),JS=1,9),JT=1,5) /
     &6.2240E-01,5.9202E-01,7.9818E-01,8.6221E-01,8.4556E-01,7.9840E-01,
     &7.0353E-01,6.4834E-01,7.3196E-01,6.0152E-01,5.7633E-01,8.0789E-01,
     &8.1513E-01,8.0789E-01,7.5099E-01,6.7710E-01,6.4945E-01,6.3067E-01,
     &5.8999E-01,5.6942E-01,7.6969E-01,7.8647E-01,7.7674E-01,7.1468E-01,
     &6.6534E-01,6.5860E-01,5.4173E-01,5.8241E-01,5.6326E-01,7.5015E-01,
     &7.6096E-01,7.5392E-01,6.9429E-01,6.6094E-01,6.6621E-01,4.4433E-01,
     &5.7098E-01,5.5310E-01,7.2743E-01,7.3939E-01,7.3730E-01,6.8982E-01,
     &6.6680E-01,6.6632E-01,3.5896E-01/
      DATA ((KA(JS,JT, 6, 6),JS=1,9),JT=1,5) /
     &5.2885E-01,5.1244E-01,7.5494E-01,7.8724E-01,7.7080E-01,7.0256E-01,
     &6.2568E-01,5.6883E-01,6.4732E-01,5.0860E-01,4.9747E-01,7.1101E-01,
     &7.4294E-01,7.2488E-01,6.6139E-01,6.0894E-01,5.7630E-01,5.5132E-01,
     &4.9680E-01,4.8858E-01,6.8601E-01,7.0262E-01,6.9083E-01,6.2832E-01,
     &5.9581E-01,5.8177E-01,4.5843E-01,4.8828E-01,4.9338E-01,6.6185E-01,
     &6.8834E-01,6.6433E-01,6.1518E-01,5.9405E-01,5.8713E-01,3.7286E-01,
     &4.7758E-01,5.0393E-01,6.4306E-01,6.6695E-01,6.4365E-01,6.0629E-01,
     &5.9623E-01,5.8994E-01,3.0878E-01/
      DATA ((KA(JS,JT, 7, 6),JS=1,9),JT=1,5) /
     &4.5544E-01,5.1675E-01,6.9040E-01,7.2442E-01,6.9583E-01,6.2374E-01,
     &5.5330E-01,4.9819E-01,5.7066E-01,4.3526E-01,5.2433E-01,6.5887E-01,
     &6.7132E-01,6.4888E-01,5.8229E-01,5.3592E-01,5.0387E-01,4.7263E-01,
     &4.2386E-01,5.3503E-01,6.2067E-01,6.3646E-01,6.0983E-01,5.5722E-01,
     &5.2827E-01,5.1003E-01,3.8891E-01,4.1478E-01,5.3714E-01,5.9921E-01,
     &6.0957E-01,5.8334E-01,5.4159E-01,5.2418E-01,5.1278E-01,3.1885E-01,
     &4.0467E-01,5.2009E-01,5.7701E-01,5.8575E-01,5.6859E-01,5.4155E-01,
     &5.3930E-01,5.1710E-01,2.6235E-01/
      DATA ((KA(JS,JT, 8, 6),JS=1,9),JT=1,5) /
     &4.0091E-01,5.6115E-01,6.4335E-01,6.5229E-01,6.2013E-01,5.5832E-01,
     &4.9333E-01,4.3362E-01,5.1143E-01,3.8169E-01,5.2953E-01,5.9829E-01,
     &6.0811E-01,5.7734E-01,5.1950E-01,4.7393E-01,4.3986E-01,4.2322E-01,
     &3.7078E-01,5.0436E-01,5.6958E-01,5.7197E-01,5.3831E-01,4.9299E-01,
     &4.6737E-01,4.4557E-01,3.4628E-01,3.6161E-01,4.8989E-01,5.4426E-01,
     &5.4657E-01,5.1938E-01,4.8189E-01,4.6346E-01,4.4852E-01,2.8491E-01,
     &3.5235E-01,4.6785E-01,5.2499E-01,5.2434E-01,5.0210E-01,4.7954E-01,
     &4.8680E-01,4.5258E-01,2.3809E-01/
      DATA ((KA(JS,JT, 9, 6),JS=1,9),JT=1,5) /
     &3.5188E-01,5.0784E-01,5.8680E-01,5.8599E-01,5.5453E-01,4.9355E-01,
     &4.3434E-01,3.7345E-01,4.5760E-01,3.3384E-01,4.7725E-01,5.4527E-01,
     &5.4039E-01,5.1277E-01,4.6053E-01,4.1752E-01,3.8054E-01,3.7664E-01,
     &3.2337E-01,4.6079E-01,5.0889E-01,5.0540E-01,4.8167E-01,4.3259E-01,
     &4.1005E-01,3.8447E-01,3.0502E-01,3.1489E-01,4.4224E-01,4.8906E-01,
     &4.8098E-01,4.5962E-01,4.2889E-01,4.1407E-01,3.8891E-01,2.4901E-01,
     &3.0731E-01,4.2604E-01,4.6542E-01,4.6457E-01,4.4425E-01,4.2325E-01,
     &4.3000E-01,3.9500E-01,2.1365E-01/
      DATA ((KA(JS,JT,10, 6),JS=1,9),JT=1,5) /
     &3.0872E-01,4.6438E-01,5.2605E-01,5.1940E-01,4.8758E-01,4.3435E-01,
     &3.8048E-01,3.2415E-01,4.0329E-01,2.9295E-01,4.4115E-01,4.8348E-01,
     &4.7740E-01,4.4909E-01,4.0221E-01,3.6624E-01,3.2721E-01,3.3011E-01,
     &2.8328E-01,4.1772E-01,4.5515E-01,4.4741E-01,4.2330E-01,3.8012E-01,
     &3.5851E-01,3.3085E-01,2.6425E-01,2.7562E-01,4.0009E-01,4.2827E-01,
     &4.2695E-01,4.0250E-01,3.7844E-01,3.6844E-01,3.3695E-01,2.1886E-01,
     &2.6849E-01,3.8403E-01,4.1066E-01,4.0861E-01,3.9231E-01,3.7926E-01,
     &3.7696E-01,3.4332E-01,1.9262E-01/
      DATA ((KA(JS,JT,11, 6),JS=1,9),JT=1,5) /
     &2.6466E-01,4.1355E-01,4.4454E-01,4.4042E-01,4.1233E-01,3.6752E-01,
     &3.2678E-01,2.7894E-01,3.2749E-01,2.5291E-01,3.8781E-01,4.1430E-01,
     &4.0659E-01,3.8277E-01,3.4153E-01,3.1495E-01,2.7988E-01,2.6257E-01,
     &2.4541E-01,3.7100E-01,3.8849E-01,3.8315E-01,3.6055E-01,3.3569E-01,
     &3.1896E-01,2.8851E-01,2.1720E-01,2.3761E-01,3.4992E-01,3.7138E-01,
     &3.6645E-01,3.4895E-01,3.3415E-01,3.2576E-01,2.9375E-01,1.9101E-01,
     &2.3136E-01,3.3422E-01,3.5550E-01,3.5462E-01,3.4596E-01,3.4410E-01,
     &3.3336E-01,3.0010E-01,1.7683E-01/
      DATA ((KA(JS,JT,12, 6),JS=1,9),JT=1,5) /
     &2.3099E-01,3.6467E-01,3.8654E-01,3.7740E-01,3.5454E-01,3.1341E-01,
     &2.8207E-01,2.4141E-01,2.7098E-01,2.2244E-01,3.4190E-01,3.5753E-01,
     &3.5048E-01,3.3109E-01,2.9786E-01,2.7909E-01,2.4469E-01,2.1730E-01,
     &2.1694E-01,3.2183E-01,3.3982E-01,3.3193E-01,3.1521E-01,2.9823E-01,
     &2.8101E-01,2.4988E-01,1.8539E-01,2.1365E-01,3.0582E-01,3.2214E-01,
     &3.1915E-01,3.0963E-01,3.0101E-01,2.9010E-01,2.5511E-01,1.7246E-01,
     &2.1126E-01,2.9440E-01,3.1065E-01,3.1395E-01,3.1604E-01,3.0993E-01,
     &2.9537E-01,2.6162E-01,1.5291E-01/
      DATA ((KA(JS,JT,13, 6),JS=1,9),JT=1,5) /
     &2.2386E-01,3.3097E-01,3.4162E-01,3.3327E-01,3.1314E-01,2.7728E-01,
     &2.5014E-01,2.1154E-01,2.3428E-01,2.2040E-01,3.1261E-01,3.2237E-01,
     &3.1373E-01,2.9682E-01,2.6651E-01,2.5032E-01,2.1702E-01,1.9039E-01,
     &2.1610E-01,2.9730E-01,3.0955E-01,3.0133E-01,2.8651E-01,2.7201E-01,
     &2.5430E-01,2.2027E-01,1.6665E-01,2.1312E-01,2.8629E-01,2.9748E-01,
     &2.9400E-01,2.8967E-01,2.7599E-01,2.5853E-01,2.2523E-01,1.5373E-01,
     &2.0806E-01,2.7757E-01,2.8967E-01,2.9354E-01,2.9376E-01,2.8253E-01,
     &2.6218E-01,2.3101E-01,1.3574E-01/
      DATA ((KA(JS,JT, 1, 7),JS=1,9),JT=1,5) /
     &3.5613E+00,3.1188E+00,2.6764E+00,2.2340E+00,1.7917E+00,1.6352E+00,
     &1.8092E+00,1.6379E+00,2.7539E-02,3.4002E+00,2.9785E+00,2.5569E+00,
     &2.1349E+00,1.7133E+00,1.7200E+00,1.7738E+00,1.6325E+00,3.6313E-02,
     &3.2557E+00,2.8529E+00,2.4503E+00,2.0478E+00,1.6479E+00,1.7947E+00,
     &1.7613E+00,1.6123E+00,7.9598E-02,3.1418E+00,2.7541E+00,2.3673E+00,
     &1.9817E+00,1.6011E+00,1.8327E+00,1.7198E+00,1.6148E+00,2.1944E-01,
     &3.1204E+00,2.7380E+00,2.3562E+00,1.9785E+00,1.6099E+00,1.8773E+00,
     &1.7180E+00,1.6127E+00,2.9776E-01/
      DATA ((KA(JS,JT, 2, 7),JS=1,9),JT=1,5) /
     &2.9874E+00,2.6163E+00,2.2453E+00,1.8746E+00,1.5312E+00,1.8525E+00,
     &1.7071E+00,1.5893E+00,5.1776E-01,2.8505E+00,2.4972E+00,2.1440E+00,
     &1.7909E+00,1.5966E+00,1.8306E+00,1.6863E+00,1.5842E+00,4.3879E-01,
     &2.7350E+00,2.3969E+00,2.0589E+00,1.7214E+00,1.6370E+00,1.7877E+00,
     &1.6805E+00,1.5918E+00,4.1523E-01,2.6409E+00,2.3156E+00,1.9935E+00,
     &1.6727E+00,1.6830E+00,1.7575E+00,1.6634E+00,1.5980E+00,2.9373E-01,
     &2.5886E+00,2.2740E+00,1.9607E+00,1.6497E+00,1.7391E+00,1.7232E+00,
     &1.6344E+00,1.6105E+00,1.8509E-01/
      DATA ((KA(JS,JT, 3, 7),JS=1,9),JT=1,5) /
     &2.5285E+00,2.2147E+00,1.9010E+00,1.5874E+00,1.8079E+00,1.7347E+00,
     &1.6267E+00,1.5173E+00,4.9543E-01,2.4109E+00,2.1124E+00,1.8139E+00,
     &1.5156E+00,1.7831E+00,1.7011E+00,1.6143E+00,1.5141E+00,4.4268E-01,
     &2.3122E+00,2.0266E+00,1.7413E+00,1.4891E+00,1.7442E+00,1.6741E+00,
     &1.6075E+00,1.5297E+00,3.4522E-01,2.2338E+00,1.9602E+00,1.6889E+00,
     &1.5208E+00,1.7228E+00,1.6317E+00,1.5933E+00,1.5434E+00,2.1394E-01,
     &2.1901E+00,1.9250E+00,1.6600E+00,1.5510E+00,1.6972E+00,1.6258E+00,
     &1.5808E+00,1.5686E+00,1.5097E-01/
      DATA ((KA(JS,JT, 4, 7),JS=1,9),JT=1,5) /
     &2.1490E+00,1.8824E+00,1.6159E+00,1.5783E+00,1.6916E+00,1.6097E+00,
     &1.5676E+00,1.4069E+00,5.0896E-01,2.0429E+00,1.7900E+00,1.5373E+00,
     &1.6130E+00,1.6613E+00,1.5828E+00,1.5388E+00,1.4176E+00,3.7374E-01,
     &1.9560E+00,1.7146E+00,1.4748E+00,1.6326E+00,1.6129E+00,1.5608E+00,
     &1.5146E+00,1.4336E+00,2.6187E-01,1.8914E+00,1.6603E+00,1.4322E+00,
     &1.6118E+00,1.5843E+00,1.5418E+00,1.4880E+00,1.4608E+00,1.8007E-01,
     &1.8569E+00,1.6328E+00,1.4097E+00,1.6022E+00,1.5587E+00,1.5446E+00,
     &1.4805E+00,1.4912E+00,1.1749E-01/
      DATA ((KA(JS,JT, 5, 7),JS=1,9),JT=1,5) /
     &1.8276E+00,1.6010E+00,1.3745E+00,1.6030E+00,1.5630E+00,1.5166E+00,
     &1.4457E+00,1.2855E+00,4.3144E-01,1.7325E+00,1.5182E+00,1.3289E+00,
     &1.5483E+00,1.5172E+00,1.4962E+00,1.4204E+00,1.2974E+00,3.2532E-01,
     &1.6556E+00,1.4514E+00,1.3491E+00,1.5022E+00,1.4839E+00,1.4801E+00,
     &1.3899E+00,1.3214E+00,2.2874E-01,1.6008E+00,1.4058E+00,1.3614E+00,
     &1.4817E+00,1.4667E+00,1.4542E+00,1.3728E+00,1.3543E+00,1.4774E-01,
     &1.5722E+00,1.3835E+00,1.3910E+00,1.4609E+00,1.4510E+00,1.4341E+00,
     &1.3580E+00,1.3940E+00,9.9947E-02/
      DATA ((KA(JS,JT, 6, 7),JS=1,9),JT=1,5) /
     &1.5600E+00,1.3665E+00,1.3891E+00,1.4520E+00,1.4361E+00,1.4207E+00,
     &1.3105E+00,1.1513E+00,3.8692E-01,1.4739E+00,1.2917E+00,1.3972E+00,
     &1.4114E+00,1.4085E+00,1.3840E+00,1.2763E+00,1.1653E+00,2.7607E-01,
     &1.4042E+00,1.2317E+00,1.3535E+00,1.3731E+00,1.3834E+00,1.3540E+00,
     &1.2537E+00,1.1954E+00,1.8549E-01,1.3553E+00,1.1909E+00,1.3235E+00,
     &1.3411E+00,1.3606E+00,1.3282E+00,1.2356E+00,1.2339E+00,1.3113E-01,
     &1.3290E+00,1.1708E+00,1.3052E+00,1.3291E+00,1.3435E+00,1.3084E+00,
     &1.2394E+00,1.2789E+00,8.5104E-02/
      DATA ((KA(JS,JT, 7, 7),JS=1,9),JT=1,5) /
     &1.3486E+00,1.1821E+00,1.3320E+00,1.3296E+00,1.3530E+00,1.2921E+00,
     &1.1792E+00,1.0146E+00,3.3967E-01,1.2698E+00,1.1140E+00,1.2658E+00,
     &1.2934E+00,1.3084E+00,1.2591E+00,1.1496E+00,1.0323E+00,2.4089E-01,
     &1.2066E+00,1.0597E+00,1.2265E+00,1.2606E+00,1.2717E+00,1.2202E+00,
     &1.1236E+00,1.0630E+00,1.6653E-01,1.1624E+00,1.0337E+00,1.1938E+00,
     &1.2388E+00,1.2436E+00,1.1958E+00,1.1143E+00,1.1071E+00,1.1640E-01,
     &1.1373E+00,1.0419E+00,1.1824E+00,1.2289E+00,1.2206E+00,1.1715E+00,
     &1.1114E+00,1.1517E+00,7.1520E-02/
      DATA ((KA(JS,JT, 8, 7),JS=1,9),JT=1,5) /
     &1.1959E+00,1.0587E+00,1.2168E+00,1.2562E+00,1.2533E+00,1.1755E+00,
     &1.0535E+00,8.9257E-01,2.9562E-01,1.1212E+00,1.0393E+00,1.1676E+00,
     &1.2170E+00,1.2001E+00,1.1361E+00,1.0253E+00,9.0430E-01,2.1449E-01,
     &1.0601E+00,1.0297E+00,1.1266E+00,1.1809E+00,1.1623E+00,1.1020E+00,
     &1.0023E+00,9.3591E-01,1.5382E-01,1.0187E+00,1.0227E+00,1.0991E+00,
     &1.1460E+00,1.1243E+00,1.0751E+00,9.9421E-01,9.7855E-01,1.0944E-01,
     &9.9531E-01,1.0219E+00,1.0832E+00,1.1243E+00,1.1050E+00,1.0609E+00,
     &9.9136E-01,1.0252E+00,7.0614E-02/
      DATA ((KA(JS,JT, 9, 7),JS=1,9),JT=1,5) /
     &1.0539E+00,1.0559E+00,1.1142E+00,1.1729E+00,1.1295E+00,1.0580E+00,
     &9.3382E-01,7.7194E-01,2.7489E-01,9.8392E-01,1.0263E+00,1.0713E+00,
     &1.1148E+00,1.0796E+00,1.0137E+00,9.0260E-01,7.8234E-01,1.9796E-01,
     &9.2807E-01,9.7104E-01,1.0401E+00,1.0698E+00,1.0381E+00,9.8279E-01,
     &8.8087E-01,8.1424E-01,1.4396E-01,8.9022E-01,9.3422E-01,1.0109E+00,
     &1.0366E+00,1.0048E+00,9.5511E-01,8.7539E-01,8.5432E-01,1.0430E-01,
     &8.6877E-01,9.2050E-01,1.0000E+00,1.0116E+00,9.8826E-01,9.4009E-01,
     &8.7922E-01,9.0156E-01,6.8077E-02/
      DATA ((KA(JS,JT,10, 7),JS=1,9),JT=1,5) /
     &9.2527E-01,9.7705E-01,1.0325E+00,1.0578E+00,1.0149E+00,9.3478E-01,
     &8.1724E-01,6.6415E-01,2.3891E-01,8.6097E-01,9.1106E-01,9.9506E-01,
     &1.0007E+00,9.6610E-01,8.9639E-01,7.8861E-01,6.7596E-01,1.7815E-01,
     &8.1181E-01,8.7070E-01,9.5033E-01,9.5476E-01,9.2168E-01,8.6431E-01,
     &7.7032E-01,7.0318E-01,1.3199E-01,7.7887E-01,8.4520E-01,9.2163E-01,
     &9.1956E-01,8.9130E-01,8.3659E-01,7.6501E-01,7.4145E-01,9.1831E-02,
     &7.5933E-01,8.3227E-01,9.0273E-01,9.0188E-01,8.7623E-01,8.2773E-01,
     &7.7824E-01,7.8260E-01,6.3171E-02/
      DATA ((KA(JS,JT,11, 7),JS=1,9),JT=1,5) /
     &7.8226E-01,8.4719E-01,9.2612E-01,9.1570E-01,8.7421E-01,8.0479E-01,
     &6.9799E-01,5.7039E-01,1.8643E-01,7.3229E-01,8.0376E-01,8.7472E-01,
     &8.6879E-01,8.2958E-01,7.6891E-01,6.7602E-01,5.8714E-01,1.4000E-01,
     &6.9599E-01,7.7478E-01,8.4133E-01,8.3314E-01,7.9919E-01,7.4119E-01,
     &6.6696E-01,6.1671E-01,1.0181E-01,6.7489E-01,7.6185E-01,8.1367E-01,
     &8.1128E-01,7.7952E-01,7.3228E-01,6.7358E-01,6.5125E-01,7.0225E-02,
     &6.5905E-01,7.5391E-01,7.9725E-01,7.9623E-01,7.7236E-01,7.3477E-01,
     &6.9321E-01,6.9245E-01,4.7555E-02/
      DATA ((KA(JS,JT,12, 7),JS=1,9),JT=1,5) /
     &6.7862E-01,7.6075E-01,8.1212E-01,7.9974E-01,7.5616E-01,6.9320E-01,
     &5.9851E-01,4.9309E-01,1.4949E-01,6.3807E-01,7.3022E-01,7.7190E-01,
     &7.6245E-01,7.2390E-01,6.6782E-01,5.8563E-01,5.1153E-01,1.1607E-01,
     &6.1294E-01,7.1220E-01,7.4125E-01,7.3342E-01,6.9810E-01,6.4969E-01,
     &5.8866E-01,5.3877E-01,8.5989E-02,5.9734E-01,7.0046E-01,7.2548E-01,
     &7.1635E-01,6.8868E-01,6.5109E-01,5.9747E-01,5.7263E-01,5.7849E-02,
     &5.8148E-01,6.8644E-01,7.1487E-01,7.0660E-01,6.8790E-01,6.6368E-01,
     &6.1903E-01,6.0994E-01,3.8734E-02/
      DATA ((KA(JS,JT,13, 7),JS=1,9),JT=1,5) /
     &6.1552E-01,7.1356E-01,7.3721E-01,7.1646E-01,6.7473E-01,6.1507E-01,
     &5.2767E-01,4.3311E-01,1.2482E-01,5.8292E-01,6.8409E-01,7.0235E-01,
     &6.8503E-01,6.4503E-01,5.9514E-01,5.2204E-01,4.4742E-01,9.8236E-02,
     &5.6436E-01,6.6497E-01,6.8075E-01,6.6573E-01,6.3039E-01,5.8718E-01,
     &5.2651E-01,4.7434E-01,7.2297E-02,5.4811E-01,6.4832E-01,6.6742E-01,
     &6.5348E-01,6.2977E-01,5.9747E-01,5.3863E-01,5.0502E-01,5.7494E-02,
     &5.3739E-01,6.3448E-01,6.5434E-01,6.4659E-01,6.3825E-01,6.0640E-01,
     &5.6100E-01,5.4046E-01,3.2048E-02/
      DATA ((KA(JS,JT, 1, 8),JS=1,9),JT=1,5) /
     &1.1660E+01,1.0203E+01,8.7459E+00,7.2889E+00,5.8318E+00,4.3748E+00,
     &3.7766E+00,3.7739E+00,2.3608E-03,1.1346E+01,9.9282E+00,8.5104E+00,
     &7.0926E+00,5.6748E+00,4.2570E+00,3.8721E+00,3.9057E+00,3.1824E-03,
     &1.1194E+01,9.7951E+00,8.3963E+00,6.9976E+00,5.5988E+00,4.2000E+00,
     &3.9469E+00,4.0712E+00,4.2520E-03,1.1228E+01,9.8250E+00,8.4220E+00,
     &7.0189E+00,5.6159E+00,4.2457E+00,4.0615E+00,4.2140E+00,1.1766E-02,
     &1.1405E+01,9.9798E+00,8.5545E+00,7.1289E+00,5.7036E+00,4.3747E+00,
     &4.1857E+00,4.3557E+00,1.5766E-01/
      DATA ((KA(JS,JT, 2, 8),JS=1,9),JT=1,5) /
     &9.6985E+00,8.4867E+00,7.2748E+00,6.0630E+00,4.8511E+00,3.9524E+00,
     &3.9347E+00,3.7679E+00,7.6708E-02,9.4032E+00,8.2283E+00,7.0533E+00,
     &5.8784E+00,4.7035E+00,3.9843E+00,4.0089E+00,3.9489E+00,9.1596E-02,
     &9.2359E+00,8.0819E+00,6.9278E+00,5.7738E+00,4.6198E+00,4.0563E+00,
     &4.1174E+00,4.1185E+00,7.3144E-02,9.2178E+00,8.0660E+00,6.9143E+00,
     &5.7625E+00,4.6107E+00,4.1515E+00,4.2394E+00,4.2904E+00,1.1674E-01,
     &9.3781E+00,8.2055E+00,7.0329E+00,5.8605E+00,4.6883E+00,4.2988E+00,
     &4.3503E+00,4.4505E+00,1.2134E-01/
      DATA ((KA(JS,JT, 3, 8),JS=1,9),JT=1,5) /
     &8.1381E+00,7.1213E+00,6.1045E+00,5.0877E+00,4.0880E+00,4.0519E+00,
     &3.8139E+00,3.6880E+00,8.7204E-02,7.8478E+00,6.8673E+00,5.8868E+00,
     &4.9063E+00,4.0625E+00,4.0788E+00,3.9290E+00,3.8689E+00,6.5887E-02,
     &7.6555E+00,6.6990E+00,5.7426E+00,4.7861E+00,4.0779E+00,4.1101E+00,
     &4.0765E+00,4.0574E+00,7.1216E-02,7.5783E+00,6.6314E+00,5.6846E+00,
     &4.7378E+00,4.1353E+00,4.1781E+00,4.2207E+00,4.2405E+00,8.4339E-02,
     &7.6543E+00,6.6980E+00,5.7416E+00,4.7853E+00,4.2544E+00,4.2669E+00,
     &4.4018E+00,4.4237E+00,7.8612E-02/
      DATA ((KA(JS,JT, 4, 8),JS=1,9),JT=1,5) /
     &6.8589E+00,6.0020E+00,5.1451E+00,4.2882E+00,3.9706E+00,3.8613E+00,
     &3.5947E+00,3.5300E+00,6.1710E-02,6.5794E+00,5.7574E+00,4.9355E+00,
     &4.1135E+00,3.9575E+00,3.8878E+00,3.7477E+00,3.7212E+00,6.0817E-02,
     &6.3760E+00,5.5795E+00,4.7829E+00,3.9985E+00,3.9783E+00,3.9606E+00,
     &3.9214E+00,3.9164E+00,6.3574E-02,6.2600E+00,5.4779E+00,4.6959E+00,
     &4.0045E+00,4.0114E+00,4.0769E+00,4.1164E+00,4.1060E+00,7.8132E-02,
     &6.2608E+00,5.4787E+00,4.6966E+00,4.0716E+00,4.0797E+00,4.1992E+00,
     &4.3140E+00,4.3043E+00,7.5353E-02/
      DATA ((KA(JS,JT, 5, 8),JS=1,9),JT=1,5) /
     &5.7927E+00,5.0691E+00,4.3455E+00,3.8105E+00,3.8237E+00,3.5526E+00,
     &3.3728E+00,3.3373E+00,4.9756E-02,5.5277E+00,4.8372E+00,4.1467E+00,
     &3.7691E+00,3.7793E+00,3.6108E+00,3.5410E+00,3.5220E+00,4.2289E-02,
     &5.3258E+00,4.6606E+00,3.9953E+00,3.7485E+00,3.7814E+00,3.7044E+00,
     &3.7302E+00,3.7158E+00,4.7217E-02,5.1933E+00,4.5445E+00,3.8958E+00,
     &3.7349E+00,3.8276E+00,3.8482E+00,3.9315E+00,3.9070E+00,5.2805E-02,
     &5.1489E+00,4.5057E+00,3.8627E+00,3.7753E+00,3.9160E+00,4.0236E+00,
     &4.1558E+00,4.1173E+00,7.3119E-02/
      DATA ((KA(JS,JT, 6, 8),JS=1,9),JT=1,5) /
     &4.9153E+00,4.3014E+00,3.6874E+00,3.6742E+00,3.4664E+00,3.2352E+00,
     &3.1382E+00,3.1290E+00,5.3656E-02,4.6666E+00,4.0837E+00,3.5075E+00,
     &3.5947E+00,3.4390E+00,3.3186E+00,3.2995E+00,3.2957E+00,3.0716E-02,
     &4.4714E+00,3.9130E+00,3.4299E+00,3.5379E+00,3.4620E+00,3.4453E+00,
     &3.4927E+00,3.4789E+00,2.2748E-02,4.3327E+00,3.7916E+00,3.3931E+00,
     &3.5287E+00,3.5342E+00,3.5995E+00,3.6934E+00,3.6650E+00,4.0419E-02,
     &4.2621E+00,3.7298E+00,3.3976E+00,3.5656E+00,3.6513E+00,3.7826E+00,
     &3.9184E+00,3.8666E+00,1.0762E-01/
      DATA ((KA(JS,JT, 7, 8),JS=1,9),JT=1,5) /
     &4.2315E+00,3.7030E+00,3.3451E+00,3.3493E+00,3.1177E+00,2.9742E+00,
     &2.9072E+00,2.9068E+00,5.8460E-02,3.9985E+00,3.4984E+00,3.2669E+00,
     &3.2554E+00,3.1149E+00,3.0526E+00,3.0595E+00,3.0700E+00,2.7402E-02,
     &3.8099E+00,3.3338E+00,3.2097E+00,3.2104E+00,3.1587E+00,3.1808E+00,
     &3.2348E+00,3.2401E+00,1.9004E-02,3.6700E+00,3.2116E+00,3.1648E+00,
     &3.2052E+00,3.2433E+00,3.3349E+00,3.4286E+00,3.4160E+00,4.2481E-02,
     &3.5860E+00,3.1383E+00,3.1473E+00,3.2492E+00,3.3786E+00,3.5157E+00,
     &3.6429E+00,3.6020E+00,1.5676E-01/
      DATA ((KA(JS,JT, 8, 8),JS=1,9),JT=1,5) /
     &3.7309E+00,3.2652E+00,3.2085E+00,3.0458E+00,2.8667E+00,2.7650E+00,
     &2.6802E+00,2.6374E+00,6.7482E-02,3.5088E+00,3.0710E+00,3.0883E+00,
     &2.9531E+00,2.8706E+00,2.8363E+00,2.8330E+00,2.8092E+00,3.1671E-02,
     &3.3283E+00,2.9131E+00,2.9801E+00,2.9151E+00,2.9077E+00,2.9395E+00,
     &2.9913E+00,2.9792E+00,1.9457E-02,3.1890E+00,2.7912E+00,2.9223E+00,
     &2.9235E+00,2.9935E+00,3.0761E+00,3.1767E+00,3.1591E+00,4.5502E-02,
     &3.0966E+00,2.7276E+00,2.9000E+00,2.9842E+00,3.1139E+00,3.2433E+00,
     &3.3703E+00,3.3444E+00,1.7959E-01/
      DATA ((KA(JS,JT, 9, 8),JS=1,9),JT=1,5) /
     &3.2795E+00,2.8728E+00,2.9171E+00,2.7516E+00,2.6513E+00,2.5188E+00,
     &2.4080E+00,2.3392E+00,6.9869E-02,3.0734E+00,2.7076E+00,2.7821E+00,
     &2.6844E+00,2.6368E+00,2.5852E+00,2.5517E+00,2.5045E+00,4.1359E-02,
     &2.9006E+00,2.6099E+00,2.6833E+00,2.6568E+00,2.6662E+00,2.6837E+00,
     &2.7125E+00,2.6712E+00,2.1538E-02,2.7639E+00,2.5377E+00,2.6242E+00,
     &2.6595E+00,2.7323E+00,2.8096E+00,2.8901E+00,2.8466E+00,5.4396E-02,
     &2.6669E+00,2.4856E+00,2.6031E+00,2.7098E+00,2.8344E+00,2.9696E+00,
     &3.0834E+00,3.0331E+00,2.0077E-01/
      DATA ((KA(JS,JT,10, 8),JS=1,9),JT=1,5) /
     &2.8722E+00,2.6105E+00,2.6085E+00,2.5091E+00,2.4056E+00,2.2547E+00,
     &2.1348E+00,2.0413E+00,7.1950E-02,2.6764E+00,2.5038E+00,2.4795E+00,
     &2.4482E+00,2.3806E+00,2.3128E+00,2.2556E+00,2.1912E+00,3.7979E-02,
     &2.5139E+00,2.4083E+00,2.3949E+00,2.4105E+00,2.4135E+00,2.4077E+00,
     &2.4119E+00,2.3558E+00,2.2438E-02,2.3840E+00,2.3185E+00,2.3481E+00,
     &2.4127E+00,2.4770E+00,2.5357E+00,2.5771E+00,2.5231E+00,7.0033E-02,
     &2.2922E+00,2.2525E+00,2.3358E+00,2.4514E+00,2.5719E+00,2.6836E+00,
     &2.7691E+00,2.7055E+00,2.1431E-01/
      DATA ((KA(JS,JT,11, 8),JS=1,9),JT=1,5) /
     &2.4203E+00,2.3366E+00,2.2726E+00,2.2388E+00,2.1243E+00,2.0012E+00,
     &1.8959E+00,1.8076E+00,5.5769E-02,2.2551E+00,2.2021E+00,2.1879E+00,
     &2.1841E+00,2.1218E+00,2.0691E+00,2.0223E+00,1.9543E+00,2.8668E-02,
     &2.1166E+00,2.0926E+00,2.1229E+00,2.1590E+00,2.1592E+00,2.1682E+00,
     &2.1642E+00,2.1075E+00,3.1850E-02,2.0122E+00,2.0159E+00,2.0901E+00,
     &2.1693E+00,2.2337E+00,2.2891E+00,2.3331E+00,2.2748E+00,1.4071E-01,
     &1.9514E+00,1.9763E+00,2.0989E+00,2.2225E+00,2.3388E+00,2.4447E+00,
     &2.5215E+00,2.4588E+00,2.8723E-01/
      DATA ((KA(JS,JT,12, 8),JS=1,9),JT=1,5) /
     &2.0683E+00,2.0370E+00,2.0375E+00,1.9798E+00,1.8792E+00,1.7675E+00,
     &1.6700E+00,1.5868E+00,4.4568E-02,1.9287E+00,1.9214E+00,1.9599E+00,
     &1.9353E+00,1.8869E+00,1.8278E+00,1.7894E+00,1.7244E+00,2.3573E-02,
     &1.8200E+00,1.8347E+00,1.9076E+00,1.9217E+00,1.9295E+00,1.9250E+00,
     &1.9263E+00,1.8738E+00,5.2475E-02,1.7432E+00,1.7845E+00,1.8845E+00,
     &1.9488E+00,2.0009E+00,2.0498E+00,2.0942E+00,2.0382E+00,1.8765E-01,
     &1.7053E+00,1.7760E+00,1.9065E+00,2.0215E+00,2.1153E+00,2.2054E+00,
     &2.2781E+00,2.2210E+00,3.6587E-01/
      DATA ((KA(JS,JT,13, 8),JS=1,9),JT=1,5) /
     &1.8562E+00,1.8459E+00,1.8637E+00,1.7957E+00,1.6878E+00,1.5797E+00,
     &1.4757E+00,1.3906E+00,3.6132E-02,1.7399E+00,1.7611E+00,1.7971E+00,
     &1.7529E+00,1.6955E+00,1.6354E+00,1.5829E+00,1.5250E+00,2.1418E-02,
     &1.6467E+00,1.6945E+00,1.7550E+00,1.7487E+00,1.7380E+00,1.7251E+00,
     &1.7178E+00,1.6689E+00,6.4309E-02,1.5930E+00,1.6654E+00,1.7520E+00,
     &1.7797E+00,1.8113E+00,1.8460E+00,1.8831E+00,1.8288E+00,2.0946E-01,
     &1.5695E+00,1.6755E+00,1.7906E+00,1.8612E+00,1.9314E+00,2.0101E+00,
     &2.0671E+00,2.0074E+00,3.8278E-01/
      DATA ((KA(JS,JT, 1, 9),JS=1,9),JT=1,5) /
     &4.3448E+02,3.8017E+02,3.2586E+02,2.7155E+02,2.1724E+02,1.6293E+02,
     &1.0862E+02,5.5107E+01,2.7465E-03,5.8321E+02,5.1031E+02,4.3741E+02,
     &3.6451E+02,2.9161E+02,2.1870E+02,1.4580E+02,7.3550E+01,3.5822E-03,
     &7.6101E+02,6.6588E+02,5.7076E+02,4.7563E+02,3.8051E+02,2.8538E+02,
     &1.9025E+02,9.5593E+01,5.6366E-03,9.6683E+02,8.4598E+02,7.2512E+02,
     &6.0427E+02,4.8342E+02,3.6256E+02,2.4171E+02,1.2116E+02,6.3697E-02,
     &1.1977E+03,1.0480E+03,8.9827E+02,7.4856E+02,5.9885E+02,4.4914E+02,
     &2.9942E+02,1.4986E+02,2.8050E-01/
      DATA ((KA(JS,JT, 2, 9),JS=1,9),JT=1,5) /
     &3.3233E+02,2.9079E+02,2.4925E+02,2.0770E+02,1.6616E+02,1.2462E+02,
     &8.3297E+01,4.3020E+01,1.2769E-02,4.5139E+02,3.9497E+02,3.3854E+02,
     &2.8212E+02,2.2570E+02,1.6927E+02,1.1303E+02,5.7664E+01,6.8183E-02,
     &5.9515E+02,5.2076E+02,4.4637E+02,3.7197E+02,2.9758E+02,2.2318E+02,
     &1.4890E+02,7.5394E+01,1.7070E-01,7.6179E+02,6.6657E+02,5.7134E+02,
     &4.7612E+02,3.8090E+02,2.8567E+02,1.9048E+02,9.5968E+01,4.9948E-01,
     &9.5206E+02,8.3305E+02,7.1404E+02,5.9504E+02,4.7603E+02,3.5702E+02,
     &2.3802E+02,1.1952E+02,1.1527E+00/
      DATA ((KA(JS,JT, 3, 9),JS=1,9),JT=1,5) /
     &2.3507E+02,2.0568E+02,1.7630E+02,1.4692E+02,1.1753E+02,8.8151E+01,
     &5.9624E+01,3.1706E+01,5.0754E-02,3.2531E+02,2.8465E+02,2.4398E+02,
     &2.0332E+02,1.6266E+02,1.2199E+02,8.2067E+01,4.2715E+01,9.9945E-02,
     &4.3545E+02,3.8102E+02,3.2659E+02,2.7216E+02,2.1773E+02,1.6330E+02,
     &1.0943E+02,5.6175E+01,4.3033E-01,5.6623E+02,4.9545E+02,4.2468E+02,
     &3.5390E+02,2.8312E+02,2.1234E+02,1.4196E+02,7.2208E+01,1.0055E+00,
     &7.1637E+02,6.2682E+02,5.3728E+02,4.4773E+02,3.5819E+02,2.6864E+02,
     &1.7932E+02,9.0659E+01,1.5764E+00/
      DATA ((KA(JS,JT, 4, 9),JS=1,9),JT=1,5) /
     &1.6080E+02,1.4070E+02,1.2060E+02,1.0050E+02,8.0399E+01,6.0779E+01,
     &4.1842E+01,2.3410E+01,9.5747E-02,2.2661E+02,1.9829E+02,1.6996E+02,
     &1.4163E+02,1.1331E+02,8.5452E+01,5.8120E+01,3.1330E+01,8.2203E-01,
     &3.0940E+02,2.7072E+02,2.3205E+02,1.9338E+02,1.5470E+02,1.1642E+02,
     &7.8610E+01,4.1331E+01,1.4967E+00,4.0889E+02,3.5778E+02,3.0667E+02,
     &2.5556E+02,2.0445E+02,1.5361E+02,1.0323E+02,5.3416E+01,2.0722E+00,
     &5.2581E+02,4.6008E+02,3.9436E+02,3.2863E+02,2.6291E+02,1.9734E+02,
     &1.3221E+02,6.7657E+01,2.6260E+00/
      DATA ((KA(JS,JT, 5, 9),JS=1,9),JT=1,5) /
     &1.0850E+02,9.4934E+01,8.1372E+01,6.7810E+01,5.4459E+01,4.1884E+01,
     &2.9671E+01,1.7923E+01,1.1913E+00,1.5572E+02,1.3625E+02,1.1679E+02,
     &9.7324E+01,7.8121E+01,5.9526E+01,4.1277E+01,2.3510E+01,1.9137E+00,
     &2.1676E+02,1.8967E+02,1.6257E+02,1.3548E+02,1.0864E+02,8.2293E+01,
     &5.6282E+01,3.0781E+01,2.5565E+00,2.9183E+02,2.5535E+02,2.1887E+02,
     &1.8239E+02,1.4612E+02,1.1027E+02,7.4761E+01,3.9788E+01,3.1260E+00,
     &3.8115E+02,3.3351E+02,2.8587E+02,2.3822E+02,1.9070E+02,1.4356E+02,
     &9.6772E+01,5.0545E+01,3.5402E+00/
      DATA ((KA(JS,JT, 6, 9),JS=1,9),JT=1,5) /
     &7.1661E+01,6.2704E+01,5.3746E+01,4.4797E+01,3.6644E+01,2.8875E+01,
     &2.1420E+01,1.4378E+01,2.0773E+00,1.0465E+02,9.1565E+01,7.8484E+01,
     &6.5455E+01,5.3153E+01,4.1163E+01,2.9464E+01,1.8199E+01,2.7911E+00,
     &1.4858E+02,1.3001E+02,1.1144E+02,9.2961E+01,7.5079E+01,5.7480E+01,
     &4.0178E+01,2.3340E+01,3.3860E+00,2.0400E+02,1.7850E+02,1.5300E+02,
     &1.2759E+02,1.0268E+02,7.8054E+01,5.3729E+01,2.9889E+01,3.8146E+00,
     &2.7127E+02,2.3736E+02,2.0345E+02,1.6959E+02,1.3617E+02,1.0303E+02,
     &7.0191E+01,3.7883E+01,4.1027E+00/
      DATA ((KA(JS,JT, 7, 9),JS=1,9),JT=1,5) /
     &4.7664E+01,4.1706E+01,3.5748E+01,3.0192E+01,2.5283E+01,2.0687E+01,
     &1.6356E+01,1.2414E+01,2.7141E+00,7.0406E+01,6.1605E+01,5.2805E+01,
     &4.4485E+01,3.6675E+01,2.9135E+01,2.1846E+01,1.4960E+01,3.3740E+00,
     &1.0189E+02,8.9150E+01,7.6414E+01,6.4182E+01,5.2360E+01,4.0780E+01,
     &2.9464E+01,1.8559E+01,3.8705E+00,1.4268E+02,1.2484E+02,1.0701E+02,
     &8.9652E+01,7.2635E+01,5.5858E+01,3.9357E+01,2.3287E+01,4.2268E+00,
     &1.9337E+02,1.6920E+02,1.4503E+02,1.2126E+02,9.7796E+01,7.4601E+01,
     &5.1680E+01,2.9228E+01,4.3853E+00/
      DATA ((KA(JS,JT, 8, 9),JS=1,9),JT=1,5) /
     &3.2619E+01,2.8542E+01,2.4489E+01,2.1251E+01,1.8391E+01,1.5792E+01,
     &1.3493E+01,1.1316E+01,3.0747E+00,4.8375E+01,4.2328E+01,3.6375E+01,
     &3.1177E+01,2.6286E+01,2.1635E+01,1.7234E+01,1.3233E+01,3.6551E+00,
     &7.1088E+01,6.2202E+01,5.3468E+01,4.5389E+01,3.7595E+01,3.0015E+01,
     &2.2675E+01,1.5741E+01,4.0898E+00,1.0151E+02,8.8821E+01,7.6303E+01,
     &6.4370E+01,5.2682E+01,4.1218E+01,2.9982E+01,1.9170E+01,4.3948E+00,
     &1.4013E+02,1.2261E+02,1.0526E+02,8.8413E+01,7.1810E+01,5.5432E+01,
     &3.9307E+01,2.3602E+01,4.4795E+00/
      DATA ((KA(JS,JT, 9, 9),JS=1,9),JT=1,5) /
     &2.2374E+01,1.9574E+01,1.7087E+01,1.5322E+01,1.3873E+01,1.2730E+01,
     &1.1784E+01,1.0057E+01,3.2920E+00,3.3006E+01,2.8880E+01,2.5155E+01,
     &2.2057E+01,1.9232E+01,1.6658E+01,1.4329E+01,1.1850E+01,3.8043E+00,
     &4.8965E+01,4.2845E+01,3.7181E+01,3.2051E+01,2.7172E+01,2.2508E+01,
     &1.8078E+01,1.3961E+01,4.2059E+00,7.1218E+01,6.2316E+01,5.3886E+01,
     &4.5928E+01,3.8193E+01,3.0649E+01,2.3347E+01,1.6446E+01,4.4539E+00,
     &1.0013E+02,8.7618E+01,7.5558E+01,6.3912E+01,5.2481E+01,4.1239E+01,
     &3.0241E+01,1.9662E+01,4.4837E+00/
      DATA ((KA(JS,JT,10, 9),JS=1,9),JT=1,5) /
     &1.6016E+01,1.4014E+01,1.2654E+01,1.1832E+01,1.1333E+01,1.1079E+01,
     &1.0430E+01,8.9198E+00,3.4165E+00,2.3316E+01,2.0402E+01,1.8216E+01,
     &1.6474E+01,1.5033E+01,1.3817E+01,1.2667E+01,1.0521E+01,3.8593E+00,
     &3.4676E+01,3.0345E+01,2.6796E+01,2.3607E+01,2.0669E+01,1.7940E+01,
     &1.5414E+01,1.2426E+01,4.1980E+00,5.1075E+01,4.4715E+01,3.9109E+01,
     &3.3826E+01,2.8757E+01,2.3883E+01,1.9235E+01,1.4676E+01,4.3830E+00,
     &7.2971E+01,6.3894E+01,5.5508E+01,4.7426E+01,3.9536E+01,3.1844E+01,
     &2.4374E+01,1.7279E+01,4.3810E+00/
      DATA ((KA(JS,JT,11, 9),JS=1,9),JT=1,5) /
     &1.3577E+01,1.1946E+01,1.1209E+01,1.0837E+01,1.0794E+01,1.0607E+01,
     &9.9046E+00,8.4158E+00,3.5771E+00,1.9792E+01,1.7445E+01,1.5940E+01,
     &1.4785E+01,1.3920E+01,1.3199E+01,1.2097E+01,9.9522E+00,3.9185E+00,
     &2.9476E+01,2.5957E+01,2.3237E+01,2.0843E+01,1.8688E+01,1.6684E+01,
     &1.4791E+01,1.1766E+01,4.1553E+00,4.3413E+01,3.8176E+01,3.3695E+01,
     &2.9502E+01,2.5515E+01,2.1698E+01,1.8077E+01,1.3908E+01,4.1942E+00,
     &6.2007E+01,5.4458E+01,4.7606E+01,4.1020E+01,3.4622E+01,2.8398E+01,
     &2.2392E+01,1.6392E+01,4.1692E+00/
      DATA ((KA(JS,JT,12, 9),JS=1,9),JT=1,5) /
     &1.1680E+01,1.0479E+01,1.0122E+01,1.0167E+01,1.0289E+01,1.0072E+01,
     &9.3417E+00,7.9079E+00,3.5200E+00,1.7053E+01,1.5231E+01,1.4215E+01,
     &1.3566E+01,1.3123E+01,1.2618E+01,1.1431E+01,9.3416E+00,3.7828E+00,
     &2.5404E+01,2.2573E+01,2.0511E+01,1.8777E+01,1.7216E+01,1.5812E+01,
     &1.4031E+01,1.1064E+01,3.9374E+00,3.7431E+01,3.3112E+01,2.9529E+01,
     &2.6224E+01,2.3088E+01,2.0100E+01,1.7184E+01,1.3093E+01,3.9253E+00,
     &5.3474E+01,4.7145E+01,4.1510E+01,3.6119E+01,3.0908E+01,2.5843E+01,
     &2.0970E+01,1.5444E+01,3.9004E+00/
      DATA ((KA(JS,JT,13, 9),JS=1,9),JT=1,5) /
     &1.0438E+01,9.5597E+00,9.5087E+00,9.7911E+00,9.8820E+00,9.5875E+00,
     &8.8692E+00,7.4811E+00,3.3069E+00,1.5260E+01,1.3818E+01,1.3178E+01,
     &1.2874E+01,1.2679E+01,1.2091E+01,1.0875E+01,8.8312E+00,3.5228E+00,
     &2.2789E+01,2.0434E+01,1.8837E+01,1.7547E+01,1.6403E+01,1.5263E+01,
     &1.3389E+01,1.0463E+01,3.6351E+00,3.3586E+01,2.9891E+01,2.6912E+01,
     &2.4218E+01,2.1653E+01,1.9218E+01,1.6457E+01,1.2402E+01,3.6180E+00,
     &4.7989E+01,4.2477E+01,3.7650E+01,3.3082E+01,2.8647E+01,2.4351E+01,
     &2.0129E+01,1.4659E+01,3.6174E+00/
      DATA ((KA(JS,JT, 1,10),JS=1,9),JT=1,5) /
     &2.6405E+03,2.3104E+03,1.9803E+03,1.6503E+03,1.3202E+03,9.9017E+02,
     &6.6011E+02,3.3006E+02,2.0071E-03,3.3430E+03,2.9251E+03,2.5072E+03,
     &2.0894E+03,1.6715E+03,1.2536E+03,8.3575E+02,4.1787E+02,3.1756E-03,
     &4.1007E+03,3.5881E+03,3.0756E+03,2.5630E+03,2.0504E+03,1.5378E+03,
     &1.0252E+03,5.1259E+02,1.5257E-02,4.9110E+03,4.2972E+03,3.6833E+03,
     &3.0694E+03,2.4555E+03,1.8416E+03,1.2278E+03,6.1388E+02,1.9623E-01,
     &5.7642E+03,5.0437E+03,4.3232E+03,3.6026E+03,2.8821E+03,2.1616E+03,
     &1.4411E+03,7.2053E+02,3.1630E-01/
      DATA ((KA(JS,JT, 2,10),JS=1,9),JT=1,5) /
     &2.0643E+03,1.8062E+03,1.5482E+03,1.2902E+03,1.0321E+03,7.7410E+02,
     &5.1607E+02,2.5804E+02,7.9610E-02,2.6419E+03,2.3117E+03,1.9815E+03,
     &1.6512E+03,1.3210E+03,9.9073E+02,6.6049E+02,3.3024E+02,3.1756E-01,
     &3.2679E+03,2.8594E+03,2.4509E+03,2.0424E+03,1.6340E+03,1.2255E+03,
     &8.1698E+02,4.0849E+02,1.6019E+00,3.9535E+03,3.4593E+03,2.9652E+03,
     &2.4710E+03,1.9768E+03,1.4826E+03,9.8838E+02,4.9419E+02,2.9545E+00,
     &4.6801E+03,4.0951E+03,3.5101E+03,2.9251E+03,2.3401E+03,1.7551E+03,
     &1.1700E+03,5.8502E+02,4.1449E+00/
      DATA ((KA(JS,JT, 3,10),JS=1,9),JT=1,5) /
     &1.5076E+03,1.3191E+03,1.1307E+03,9.4224E+02,7.5379E+02,5.6534E+02,
     &3.7689E+02,1.8845E+02,5.0945E-01,1.9623E+03,1.7170E+03,1.4718E+03,
     &1.2265E+03,9.8117E+02,7.3588E+02,4.9059E+02,2.4529E+02,2.4679E+00,
     &2.4731E+03,2.1640E+03,1.8549E+03,1.5457E+03,1.2366E+03,9.2743E+02,
     &6.1829E+02,3.0914E+02,5.8082E+00,3.0330E+03,2.6538E+03,2.2747E+03,
     &1.8956E+03,1.5165E+03,1.1374E+03,7.5824E+02,3.7912E+02,6.6677E+00,
     &3.6345E+03,3.1802E+03,2.7259E+03,2.2715E+03,1.8172E+03,1.3629E+03,
     &9.0862E+02,4.5431E+02,6.6949E+00/
      DATA ((KA(JS,JT, 4,10),JS=1,9),JT=1,5) /
     &1.0627E+03,9.2986E+02,7.9702E+02,6.6419E+02,5.3135E+02,3.9851E+02,
     &2.6568E+02,1.3284E+02,8.6599E+00,1.4166E+03,1.2395E+03,1.0624E+03,
     &8.8537E+02,7.0829E+02,5.3122E+02,3.5415E+02,1.7707E+02,9.4746E+00,
     &1.8198E+03,1.5923E+03,1.3648E+03,1.1374E+03,9.0989E+02,6.8241E+02,
     &4.5494E+02,2.2747E+02,9.4272E+00,2.2704E+03,1.9866E+03,1.7028E+03,
     &1.4190E+03,1.1352E+03,8.5140E+02,5.6760E+02,2.8380E+02,9.3833E+00,
     &2.7615E+03,2.4164E+03,2.0712E+03,1.7260E+03,1.3808E+03,1.0356E+03,
     &6.9039E+02,3.4519E+02,9.3214E+00/
      DATA ((KA(JS,JT, 5,10),JS=1,9),JT=1,5) /
     &7.3556E+02,6.4362E+02,5.5167E+02,4.5973E+02,3.6778E+02,2.7584E+02,
     &1.8389E+02,9.1946E+01,1.0345E+01,1.0082E+03,8.8219E+02,7.5616E+02,
     &6.3013E+02,5.0411E+02,3.7808E+02,2.5205E+02,1.2603E+02,1.0318E+01,
     &1.3203E+03,1.1552E+03,9.9020E+02,8.2516E+02,6.6013E+02,4.9510E+02,
     &3.3007E+02,1.6503E+02,1.0269E+01,1.6790E+03,1.4691E+03,1.2593E+03,
     &1.0494E+03,8.3951E+02,6.2963E+02,4.1976E+02,2.0988E+02,1.0211E+01,
     &2.0720E+03,1.8130E+03,1.5540E+03,1.2950E+03,1.0360E+03,7.7699E+02,
     &5.1799E+02,2.5900E+02,1.0128E+01/
      DATA ((KA(JS,JT, 6,10),JS=1,9),JT=1,5) /
     &4.9443E+02,4.3263E+02,3.7082E+02,3.0902E+02,2.4721E+02,1.8541E+02,
     &1.2361E+02,6.1804E+01,1.1088E+01,6.9842E+02,6.1111E+02,5.2381E+02,
     &4.3651E+02,3.4921E+02,2.6191E+02,1.7460E+02,8.7302E+01,1.1041E+01,
     &9.3821E+02,8.2094E+02,7.0366E+02,5.8638E+02,4.6911E+02,3.5183E+02,
     &2.3455E+02,1.1728E+02,1.0988E+01,1.2155E+03,1.0636E+03,9.1165E+02,
     &7.5971E+02,6.0777E+02,4.5582E+02,3.0388E+02,1.5194E+02,1.0913E+01,
     &1.5286E+03,1.3375E+03,1.1464E+03,9.5536E+02,7.6429E+02,5.7321E+02,
     &3.8214E+02,1.9107E+02,1.0808E+01/
      DATA ((KA(JS,JT, 7,10),JS=1,9),JT=1,5) /
     &3.2977E+02,2.8854E+02,2.4732E+02,2.0610E+02,1.6488E+02,1.2366E+02,
     &8.2441E+01,4.1221E+01,1.1566E+01,4.8209E+02,4.2183E+02,3.6157E+02,
     &3.0131E+02,2.4104E+02,1.8078E+02,1.2052E+02,6.0261E+01,1.1564E+01,
     &6.6530E+02,5.8214E+02,4.9898E+02,4.1581E+02,3.3265E+02,2.4949E+02,
     &1.6632E+02,8.3163E+01,1.1535E+01,8.8049E+02,7.7043E+02,6.6036E+02,
     &5.5030E+02,4.4024E+02,3.3018E+02,2.2012E+02,1.1006E+02,1.1437E+01,
     &1.1278E+03,9.8684E+02,8.4586E+02,7.0488E+02,5.6391E+02,4.2293E+02,
     &2.8195E+02,1.4098E+02,1.1316E+01/
      DATA ((KA(JS,JT, 8,10),JS=1,9),JT=1,5) /
     &2.2204E+02,1.9428E+02,1.6653E+02,1.3877E+02,1.1102E+02,8.3264E+01,
     &5.5510E+01,3.0059E+01,1.1861E+01,3.3638E+02,2.9433E+02,2.5228E+02,
     &2.1024E+02,1.6819E+02,1.2614E+02,8.4095E+01,4.2076E+01,1.1785E+01,
     &4.7771E+02,4.1800E+02,3.5828E+02,2.9857E+02,2.3886E+02,1.7914E+02,
     &1.1943E+02,5.9714E+01,1.1693E+01,6.4744E+02,5.6651E+02,4.8558E+02,
     &4.0465E+02,3.2372E+02,2.4279E+02,1.6186E+02,8.0931E+01,1.1572E+01,
     &8.4463E+02,7.3905E+02,6.3347E+02,5.2789E+02,4.2232E+02,3.1674E+02,
     &2.1116E+02,1.0558E+02,1.1447E+01/
      DATA ((KA(JS,JT, 9,10),JS=1,9),JT=1,5) /
     &1.4633E+02,1.2804E+02,1.0975E+02,9.1455E+01,7.3164E+01,5.4873E+01,
     &3.7228E+01,2.6999E+01,1.1829E+01,2.2961E+02,2.0091E+02,1.7220E+02,
     &1.4350E+02,1.1480E+02,8.6102E+01,5.7402E+01,3.3291E+01,1.1753E+01,
     &3.3705E+02,2.9492E+02,2.5279E+02,2.1066E+02,1.6852E+02,1.2639E+02,
     &8.4263E+01,4.2726E+01,1.1656E+01,4.6791E+02,4.0942E+02,3.5094E+02,
     &2.9245E+02,2.3396E+02,1.7547E+02,1.1698E+02,5.8490E+01,1.1546E+01,
     &6.2380E+02,5.4582E+02,4.6785E+02,3.8987E+02,3.1190E+02,2.3392E+02,
     &1.5595E+02,7.7975E+01,1.1440E+01/
      DATA ((KA(JS,JT,10,10),JS=1,9),JT=1,5) /
     &9.9121E+01,8.6731E+01,7.4340E+01,6.1950E+01,4.9560E+01,3.7719E+01,
     &3.0913E+01,2.3571E+01,1.2025E+01,1.5969E+02,1.3973E+02,1.1977E+02,
     &9.9804E+01,7.9844E+01,5.9883E+01,4.1267E+01,2.9611E+01,1.1959E+01,
     &2.4182E+02,2.1160E+02,1.8137E+02,1.5114E+02,1.2091E+02,9.0684E+01,
     &6.0456E+01,3.6780E+01,1.1864E+01,3.4325E+02,3.0034E+02,2.5744E+02,
     &2.1453E+02,1.7163E+02,1.2872E+02,8.5813E+01,4.5301E+01,1.1768E+01,
     &4.6649E+02,4.0818E+02,3.4987E+02,2.9156E+02,2.3325E+02,1.7493E+02,
     &1.1662E+02,5.8448E+01,1.1666E+01/
      DATA ((KA(JS,JT,11,10),JS=1,9),JT=1,5) /
     &8.4453E+01,7.3896E+01,6.3339E+01,5.2783E+01,4.2282E+01,3.5008E+01,
     &3.0468E+01,2.2795E+01,1.2480E+01,1.3606E+02,1.1905E+02,1.0204E+02,
     &8.5035E+01,6.8028E+01,5.1171E+01,3.9405E+01,2.8346E+01,1.2418E+01,
     &2.0562E+02,1.7991E+02,1.5421E+02,1.2851E+02,1.0281E+02,7.7106E+01,
     &5.2236E+01,3.5283E+01,1.2333E+01,2.9197E+02,2.5547E+02,2.1898E+02,
     &1.8248E+02,1.4598E+02,1.0949E+02,7.2992E+01,4.3383E+01,1.2243E+01,
     &3.9645E+02,3.4690E+02,2.9734E+02,2.4778E+02,1.9823E+02,1.4867E+02,
     &9.9113E+01,5.2639E+01,1.2132E+01/
      DATA ((KA(JS,JT,12,10),JS=1,9),JT=1,5) /
     &7.3008E+01,6.3882E+01,5.4756E+01,4.5630E+01,3.8097E+01,3.4292E+01,
     &2.9157E+01,2.1820E+01,1.2784E+01,1.1777E+02,1.0304E+02,8.8324E+01,
     &7.3604E+01,5.8883E+01,4.6283E+01,3.8218E+01,2.7110E+01,1.2693E+01,
     &1.7754E+02,1.5535E+02,1.3316E+02,1.1096E+02,8.8771E+01,6.6578E+01,
     &4.9180E+01,3.3603E+01,1.2566E+01,2.5172E+02,2.2026E+02,1.8879E+02,
     &1.5733E+02,1.2586E+02,9.4396E+01,6.3855E+01,4.1285E+01,1.2431E+01,
     &3.4203E+02,2.9928E+02,2.5652E+02,2.1377E+02,1.7102E+02,1.2826E+02,
     &8.5508E+01,5.0087E+01,1.2252E+01/
      DATA ((KA(JS,JT,13,10),JS=1,9),JT=1,5) /
     &6.5744E+01,5.7526E+01,4.9308E+01,4.1412E+01,3.7107E+01,3.3686E+01,
     &2.7959E+01,2.0954E+01,1.2543E+01,1.0592E+02,9.2679E+01,7.9440E+01,
     &6.6200E+01,5.3492E+01,4.5296E+01,3.7012E+01,2.6073E+01,1.2385E+01,
     &1.5952E+02,1.3958E+02,1.1964E+02,9.9699E+01,7.9759E+01,6.0961E+01,
     &4.7985E+01,3.2430E+01,1.2250E+01,2.2626E+02,1.9798E+02,1.6969E+02,
     &1.4141E+02,1.1313E+02,8.4848E+01,6.0965E+01,3.9929E+01,1.2100E+01,
     &3.0736E+02,2.6894E+02,2.3052E+02,1.9210E+02,1.5368E+02,1.1526E+02,
     &7.7678E+01,4.8494E+01,1.1980E+01/
      DATA ((KA(JS,JT, 1,11),JS=1,9),JT=1,5) /
     &3.9010E+03,3.4134E+03,2.9257E+03,2.4381E+03,1.9505E+03,1.4629E+03,
     &9.7525E+02,4.8762E+02,2.5641E-03,4.8941E+03,4.2823E+03,3.6706E+03,
     &3.0588E+03,2.4471E+03,1.8353E+03,1.2235E+03,6.1176E+02,4.7147E-03,
     &6.0244E+03,5.2713E+03,4.5183E+03,3.7652E+03,3.0122E+03,2.2591E+03,
     &1.5061E+03,7.5305E+02,1.8229E-02,7.2726E+03,6.3635E+03,5.4544E+03,
     &4.5454E+03,3.6363E+03,2.7272E+03,1.8181E+03,9.0907E+02,4.1403E-02,
     &8.6200E+03,7.5425E+03,6.4650E+03,5.3875E+03,4.3100E+03,3.2325E+03,
     &2.1550E+03,1.0775E+03,7.0391E-01/
      DATA ((KA(JS,JT, 2,11),JS=1,9),JT=1,5) /
     &3.0926E+03,2.7060E+03,2.3194E+03,1.9329E+03,1.5463E+03,1.1597E+03,
     &7.7315E+02,3.8657E+02,1.4758E-01,3.9512E+03,3.4573E+03,2.9634E+03,
     &2.4695E+03,1.9756E+03,1.4817E+03,9.8779E+02,4.9390E+02,7.5464E-01,
     &4.9225E+03,4.3072E+03,3.6919E+03,3.0766E+03,2.4613E+03,1.8460E+03,
     &1.2306E+03,6.1532E+02,2.2469E+00,6.0042E+03,5.2537E+03,4.5032E+03,
     &3.7526E+03,3.0021E+03,2.2516E+03,1.5011E+03,7.5053E+02,4.5134E+00,
     &7.1983E+03,6.2985E+03,5.3987E+03,4.4989E+03,3.5991E+03,2.6994E+03,
     &1.7996E+03,8.9979E+02,5.4294E+00/
      DATA ((KA(JS,JT, 3,11),JS=1,9),JT=1,5) /
     &2.3009E+03,2.0133E+03,1.7257E+03,1.4381E+03,1.1505E+03,8.6285E+02,
     &5.7523E+02,2.8762E+02,4.0343E+00,2.9916E+03,2.6177E+03,2.2437E+03,
     &1.8698E+03,1.4958E+03,1.1219E+03,7.4790E+02,3.7395E+02,9.4960E+00,
     &3.7957E+03,3.3213E+03,2.8468E+03,2.3723E+03,1.8979E+03,1.4234E+03,
     &9.4893E+02,4.7447E+02,9.8961E+00,4.7090E+03,4.1204E+03,3.5318E+03,
     &2.9432E+03,2.3545E+03,1.7659E+03,1.1773E+03,5.8863E+02,9.8448E+00,
     &5.7119E+03,4.9979E+03,4.2839E+03,3.5699E+03,2.8560E+03,2.1420E+03,
     &1.4280E+03,7.1399E+02,9.5434E+00/
      DATA ((KA(JS,JT, 4,11),JS=1,9),JT=1,5) /
     &1.6459E+03,1.4402E+03,1.2345E+03,1.0287E+03,8.2297E+02,6.1723E+02,
     &4.1148E+02,2.0574E+02,1.1261E+01,2.1944E+03,1.9201E+03,1.6458E+03,
     &1.3715E+03,1.0972E+03,8.2292E+02,5.4861E+02,2.7431E+02,1.1246E+01,
     &2.8415E+03,2.4863E+03,2.1311E+03,1.7759E+03,1.4207E+03,1.0656E+03,
     &7.1037E+02,3.5519E+02,1.1203E+01,3.5819E+03,3.1342E+03,2.6865E+03,
     &2.2387E+03,1.7910E+03,1.3432E+03,8.9549E+02,4.4774E+02,1.1137E+01,
     &4.4164E+03,3.8643E+03,3.3123E+03,2.7602E+03,2.2082E+03,1.6561E+03,
     &1.1041E+03,5.5205E+02,1.1062E+01/
      DATA ((KA(JS,JT, 5,11),JS=1,9),JT=1,5) /
     &1.1573E+03,1.0126E+03,8.6797E+02,7.2331E+02,5.7865E+02,4.3399E+02,
     &2.8932E+02,1.4466E+02,1.2627E+01,1.5804E+03,1.3829E+03,1.1853E+03,
     &9.8775E+02,7.9020E+02,5.9265E+02,3.9510E+02,1.9755E+02,1.2599E+01,
     &2.0873E+03,1.8264E+03,1.5655E+03,1.3046E+03,1.0437E+03,7.8274E+02,
     &5.2183E+02,2.6092E+02,1.2536E+01,2.6827E+03,2.3473E+03,2.0120E+03,
     &1.6767E+03,1.3413E+03,1.0060E+03,6.7067E+02,3.3534E+02,1.2467E+01,
     &3.3592E+03,2.9393E+03,2.5194E+03,2.0995E+03,1.6796E+03,1.2597E+03,
     &8.3980E+02,4.1990E+02,1.2393E+01/
      DATA ((KA(JS,JT, 6,11),JS=1,9),JT=1,5) /
     &7.9180E+02,6.9282E+02,5.9385E+02,4.9487E+02,3.9590E+02,2.9692E+02,
     &1.9795E+02,9.8975E+01,1.3948E+01,1.1067E+03,9.6838E+02,8.3004E+02,
     &6.9170E+02,5.5336E+02,4.1502E+02,2.7668E+02,1.3834E+02,1.3917E+01,
     &1.4976E+03,1.3104E+03,1.1232E+03,9.3600E+02,7.4880E+02,5.6160E+02,
     &3.7440E+02,1.8720E+02,1.3860E+01,1.9619E+03,1.7167E+03,1.4715E+03,
     &1.2262E+03,9.8097E+02,7.3573E+02,4.9049E+02,2.4524E+02,1.3785E+01,
     &2.4991E+03,2.1867E+03,1.8743E+03,1.5619E+03,1.2496E+03,9.3716E+02,
     &6.2477E+02,3.1239E+02,1.3707E+01/
      DATA ((KA(JS,JT, 7,11),JS=1,9),JT=1,5) /
     &5.3794E+02,4.7070E+02,4.0346E+02,3.3621E+02,2.6897E+02,2.0173E+02,
     &1.3449E+02,6.7243E+01,1.5200E+01,7.7168E+02,6.7522E+02,5.7876E+02,
     &4.8230E+02,3.8584E+02,2.8938E+02,1.9292E+02,9.6460E+01,1.5161E+01,
     &1.0690E+03,9.3537E+02,8.0174E+02,6.6812E+02,5.3449E+02,4.0087E+02,
     &2.6725E+02,1.3362E+02,1.5097E+01,1.4303E+03,1.2515E+03,1.0727E+03,
     &8.9396E+02,7.1516E+02,5.3637E+02,3.5758E+02,1.7879E+02,1.5017E+01,
     &1.8576E+03,1.6254E+03,1.3932E+03,1.1610E+03,9.2880E+02,6.9660E+02,
     &4.6440E+02,2.3220E+02,1.4920E+01/
      DATA ((KA(JS,JT, 8,11),JS=1,9),JT=1,5) /
     &3.6857E+02,3.2250E+02,2.7643E+02,2.3036E+02,1.8428E+02,1.3821E+02,
     &9.2143E+01,4.6072E+01,1.6297E+01,5.4427E+02,4.7624E+02,4.0820E+02,
     &3.4017E+02,2.7214E+02,2.0410E+02,1.3607E+02,6.8035E+01,1.6238E+01,
     &7.7191E+02,6.7542E+02,5.7893E+02,4.8244E+02,3.8595E+02,2.8947E+02,
     &1.9298E+02,9.6489E+01,1.6155E+01,1.0564E+03,9.2435E+02,7.9230E+02,
     &6.6025E+02,5.2820E+02,3.9615E+02,2.6410E+02,1.3205E+02,1.6062E+01,
     &1.3972E+03,1.2225E+03,1.0479E+03,8.7322E+02,6.9858E+02,5.2393E+02,
     &3.4929E+02,1.7465E+02,1.5943E+01/
      DATA ((KA(JS,JT, 9,11),JS=1,9),JT=1,5) /
     &2.4734E+02,2.1642E+02,1.8550E+02,1.5459E+02,1.2367E+02,9.2751E+01,
     &6.1834E+01,3.4329E+01,1.7139E+01,3.7646E+02,3.2941E+02,2.8235E+02,
     &2.3529E+02,1.8823E+02,1.4117E+02,9.4116E+01,4.7119E+01,1.7064E+01,
     &5.4702E+02,4.7864E+02,4.1027E+02,3.4189E+02,2.7351E+02,2.0513E+02,
     &1.3676E+02,6.8378E+01,1.6972E+01,7.6564E+02,6.6994E+02,5.7423E+02,
     &4.7853E+02,3.8282E+02,2.8712E+02,1.9141E+02,9.5706E+01,1.6856E+01,
     &1.0333E+03,9.0412E+02,7.7496E+02,6.4580E+02,5.1664E+02,3.8748E+02,
     &2.5832E+02,1.2916E+02,1.6713E+01/
      DATA ((KA(JS,JT,10,11),JS=1,9),JT=1,5) /
     &1.6975E+02,1.4853E+02,1.2731E+02,1.0609E+02,8.4874E+01,6.3656E+01,
     &4.3000E+01,3.1831E+01,1.7572E+01,2.6544E+02,2.3226E+02,1.9908E+02,
     &1.6590E+02,1.3272E+02,9.9541E+01,6.6361E+01,3.9122E+01,1.7485E+01,
     &3.9471E+02,3.4537E+02,2.9603E+02,2.4669E+02,1.9735E+02,1.4801E+02,
     &9.8676E+01,5.0382E+01,1.7381E+01,5.6315E+02,4.9275E+02,4.2236E+02,
     &3.5197E+02,2.8157E+02,2.1118E+02,1.4079E+02,7.0394E+01,1.7247E+01,
     &7.7410E+02,6.7734E+02,5.8057E+02,4.8381E+02,3.8705E+02,2.9029E+02,
     &1.9352E+02,9.6763E+01,1.7092E+01/
      DATA ((KA(JS,JT,11,11),JS=1,9),JT=1,5) /
     &1.4476E+02,1.2667E+02,1.0857E+02,9.0475E+01,7.2380E+01,5.4285E+01,
     &4.0590E+01,3.2171E+01,1.7597E+01,2.2628E+02,1.9800E+02,1.6971E+02,
     &1.4143E+02,1.1314E+02,8.4856E+01,5.6719E+01,3.9479E+01,1.7480E+01,
     &3.3682E+02,2.9472E+02,2.5262E+02,2.1051E+02,1.6841E+02,1.2631E+02,
     &8.4204E+01,4.8355E+01,1.7349E+01,4.8164E+02,4.2144E+02,3.6123E+02,
     &3.0103E+02,2.4082E+02,1.8062E+02,1.2041E+02,6.1572E+01,1.7186E+01,
     &6.6267E+02,5.7984E+02,4.9701E+02,4.1417E+02,3.3134E+02,2.4850E+02,
     &1.6567E+02,8.2835E+01,1.7015E+01/
      DATA ((KA(JS,JT,12,11),JS=1,9),JT=1,5) /
     &1.2510E+02,1.0946E+02,9.3823E+01,7.8186E+01,6.2549E+01,4.8100E+01,
     &4.0318E+01,3.2221E+01,1.7708E+01,1.9563E+02,1.7117E+02,1.4672E+02,
     &1.2227E+02,9.7813E+01,7.3360E+01,5.2529E+01,3.9562E+01,1.7612E+01,
     &2.9201E+02,2.5551E+02,2.1901E+02,1.8251E+02,1.4600E+02,1.0950E+02,
     &7.3154E+01,4.8447E+01,1.7481E+01,4.1774E+02,3.6552E+02,3.1331E+02,
     &2.6109E+02,2.0887E+02,1.5665E+02,1.0444E+02,5.8915E+01,1.7339E+01,
     &5.7504E+02,5.0316E+02,4.3128E+02,3.5940E+02,2.8752E+02,2.1564E+02,
     &1.4376E+02,7.3682E+01,1.7186E+01/
      DATA ((KA(JS,JT,13,11),JS=1,9),JT=1,5) /
     &1.1264E+02,9.8561E+01,8.4481E+01,7.0401E+01,5.6432E+01,4.7061E+01,
     &4.0409E+01,3.2253E+01,1.8302E+01,1.7621E+02,1.5419E+02,1.3216E+02,
     &1.1013E+02,8.8108E+01,6.6456E+01,5.2592E+01,3.9667E+01,1.8194E+01,
     &2.6303E+02,2.3015E+02,1.9727E+02,1.6440E+02,1.3152E+02,9.8638E+01,
     &6.8547E+01,4.8772E+01,1.8071E+01,3.7673E+02,3.2964E+02,2.8255E+02,
     &2.3546E+02,1.8837E+02,1.4128E+02,9.4251E+01,5.9423E+01,1.7926E+01,
     &5.1904E+02,4.5416E+02,3.8928E+02,3.2440E+02,2.5952E+02,1.9464E+02,
     &1.2976E+02,7.1698E+01,1.7708E+01/
      DATA ((KA(JS,JT, 1,12),JS=1,9),JT=1,5) /
     &6.1566E+03,5.3871E+03,4.6175E+03,3.8479E+03,3.0783E+03,2.3087E+03,
     &1.5392E+03,7.6958E+02,3.6622E-03,7.8640E+03,6.8810E+03,5.8980E+03,
     &4.9150E+03,3.9320E+03,2.9490E+03,1.9660E+03,9.8301E+02,3.6025E-03,
     &9.7949E+03,8.5705E+03,7.3462E+03,6.1218E+03,4.8974E+03,3.6731E+03,
     &2.4487E+03,1.2244E+03,3.3010E-02,1.1959E+04,1.0464E+04,8.9695E+03,
     &7.4746E+03,5.9797E+03,4.4847E+03,2.9898E+03,1.4949E+03,6.0612E-02,
     &1.4386E+04,1.2588E+04,1.0790E+04,8.9913E+03,7.1931E+03,5.3948E+03,
     &3.5965E+03,1.7983E+03,7.6915E-02/
      DATA ((KA(JS,JT, 2,12),JS=1,9),JT=1,5) /
     &5.0811E+03,4.4460E+03,3.8109E+03,3.1757E+03,2.5406E+03,1.9054E+03,
     &1.2703E+03,6.3514E+02,2.7963E-01,6.5891E+03,5.7655E+03,4.9418E+03,
     &4.1182E+03,3.2946E+03,2.4709E+03,1.6473E+03,8.2364E+02,2.3002E+00,
     &8.3666E+03,7.3208E+03,6.2750E+03,5.2291E+03,4.1833E+03,3.1375E+03,
     &2.0917E+03,1.0458E+03,4.9790E+00,1.0356E+04,9.0616E+03,7.7671E+03,
     &6.4726E+03,5.1781E+03,3.8836E+03,2.5890E+03,1.2945E+03,6.0169E+00,
     &1.2531E+04,1.0965E+04,9.3984E+03,7.8320E+03,6.2656E+03,4.6992E+03,
     &3.1328E+03,1.5664E+03,6.8160E+00/
      DATA ((KA(JS,JT, 3,12),JS=1,9),JT=1,5) /
     &3.8913E+03,3.4049E+03,2.9185E+03,2.4321E+03,1.9457E+03,1.4593E+03,
     &9.7284E+02,4.8642E+02,1.1253E+01,5.1870E+03,4.5386E+03,3.8902E+03,
     &3.2418E+03,2.5935E+03,1.9451E+03,1.2967E+03,6.4837E+02,1.1246E+01,
     &6.6906E+03,5.8543E+03,5.0180E+03,4.1816E+03,3.3453E+03,2.5090E+03,
     &1.6727E+03,8.3633E+02,1.1235E+01,8.4124E+03,7.3608E+03,6.3093E+03,
     &5.2577E+03,4.2062E+03,3.1546E+03,2.1031E+03,1.0515E+03,1.1206E+01,
     &1.0381E+04,9.0837E+03,7.7860E+03,6.4883E+03,5.1907E+03,3.8930E+03,
     &2.5953E+03,1.2977E+03,1.1154E+01/
      DATA ((KA(JS,JT, 4,12),JS=1,9),JT=1,5) /
     &2.8697E+03,2.5110E+03,2.1523E+03,1.7936E+03,1.4349E+03,1.0761E+03,
     &7.1743E+02,3.5872E+02,1.3022E+01,3.9101E+03,3.4213E+03,2.9326E+03,
     &2.4438E+03,1.9551E+03,1.4663E+03,9.7753E+02,4.8877E+02,1.3025E+01,
     &5.1573E+03,4.5126E+03,3.8680E+03,3.2233E+03,2.5786E+03,1.9340E+03,
     &1.2893E+03,6.4466E+02,1.3008E+01,6.6403E+03,5.8103E+03,4.9802E+03,
     &4.1502E+03,3.3201E+03,2.4901E+03,1.6601E+03,8.3004E+02,1.2981E+01,
     &8.3023E+03,7.2645E+03,6.2267E+03,5.1889E+03,4.1511E+03,3.1134E+03,
     &2.0756E+03,1.0378E+03,1.2927E+01/
      DATA ((KA(JS,JT, 5,12),JS=1,9),JT=1,5) /
     &2.0574E+03,1.8002E+03,1.5431E+03,1.2859E+03,1.0287E+03,7.7153E+02,
     &5.1435E+02,2.5718E+02,1.4941E+01,2.8796E+03,2.5197E+03,2.1597E+03,
     &1.7998E+03,1.4398E+03,1.0799E+03,7.1991E+02,3.5996E+02,1.4958E+01,
     &3.9044E+03,3.4163E+03,2.9283E+03,2.4402E+03,1.9522E+03,1.4641E+03,
     &9.7610E+02,4.8805E+02,1.4965E+01,5.1045E+03,4.4665E+03,3.8284E+03,
     &3.1903E+03,2.5523E+03,1.9142E+03,1.2761E+03,6.3807E+02,1.4927E+01,
     &6.5127E+03,5.6986E+03,4.8846E+03,4.0705E+03,3.2564E+03,2.4423E+03,
     &1.6282E+03,8.1409E+02,1.4857E+01/
      DATA ((KA(JS,JT, 6,12),JS=1,9),JT=1,5) /
     &1.4218E+03,1.2441E+03,1.0663E+03,8.8861E+02,7.1089E+02,5.3316E+02,
     &3.5544E+02,1.7772E+02,1.7034E+01,2.0585E+03,1.8012E+03,1.5439E+03,
     &1.2865E+03,1.0292E+03,7.7193E+02,5.1462E+02,2.5731E+02,1.7052E+01,
     &2.8529E+03,2.4963E+03,2.1397E+03,1.7831E+03,1.4265E+03,1.0699E+03,
     &7.1324E+02,3.5662E+02,1.7043E+01,3.8237E+03,3.3458E+03,2.8678E+03,
     &2.3898E+03,1.9119E+03,1.4339E+03,9.5593E+02,4.7797E+02,1.6999E+01,
     &4.9757E+03,4.3537E+03,3.7318E+03,3.1098E+03,2.4878E+03,1.8659E+03,
     &1.2439E+03,6.2196E+02,1.6923E+01/
      DATA ((KA(JS,JT, 7,12),JS=1,9),JT=1,5) /
     &9.7219E+02,8.5066E+02,7.2914E+02,6.0761E+02,4.8609E+02,3.6457E+02,
     &2.4305E+02,1.2152E+02,1.9204E+01,1.4501E+03,1.2688E+03,1.0876E+03,
     &9.0631E+02,7.2505E+02,5.4378E+02,3.6252E+02,1.8126E+02,1.9225E+01,
     &2.0671E+03,1.8087E+03,1.5503E+03,1.2919E+03,1.0335E+03,7.7515E+02,
     &5.1676E+02,2.5838E+02,1.9209E+01,2.8414E+03,2.4862E+03,2.1311E+03,
     &1.7759E+03,1.4207E+03,1.0655E+03,7.1035E+02,3.5518E+02,1.9156E+01,
     &3.7638E+03,3.2933E+03,2.8228E+03,2.3524E+03,1.8819E+03,1.4114E+03,
     &9.4094E+02,4.7047E+02,1.9066E+01/
      DATA ((KA(JS,JT, 8,12),JS=1,9),JT=1,5) /
     &6.6611E+02,5.8284E+02,4.9958E+02,4.1632E+02,3.3305E+02,2.4979E+02,
     &1.6653E+02,8.3265E+01,2.1374E+01,1.0262E+03,8.9794E+02,7.6966E+02,
     &6.4139E+02,5.1311E+02,3.8483E+02,2.5656E+02,1.2828E+02,2.1403E+01,
     &1.5100E+03,1.3213E+03,1.1325E+03,9.4376E+02,7.5501E+02,5.6626E+02,
     &3.7751E+02,1.8875E+02,2.1385E+01,2.1206E+03,1.8555E+03,1.5904E+03,
     &1.3254E+03,1.0603E+03,7.9522E+02,5.3015E+02,2.6507E+02,2.1320E+01,
     &2.8794E+03,2.5195E+03,2.1596E+03,1.7996E+03,1.4397E+03,1.0798E+03,
     &7.1985E+02,3.5993E+02,2.1216E+01/
      DATA ((KA(JS,JT, 9,12),JS=1,9),JT=1,5) /
     &4.4380E+02,3.8832E+02,3.3285E+02,2.7737E+02,2.2190E+02,1.6642E+02,
     &1.1095E+02,5.5475E+01,2.3490E+01,7.0869E+02,6.2011E+02,5.3152E+02,
     &4.4293E+02,3.5435E+02,2.6576E+02,1.7717E+02,8.8587E+01,2.3505E+01,
     &1.0731E+03,9.3894E+02,8.0481E+02,6.7067E+02,5.3654E+02,4.0240E+02,
     &2.6827E+02,1.3414E+02,2.3465E+01,1.5496E+03,1.3559E+03,1.1622E+03,
     &9.6851E+02,7.7481E+02,5.8111E+02,3.8741E+02,1.9370E+02,2.3379E+01,
     &2.1497E+03,1.8810E+03,1.6123E+03,1.3436E+03,1.0749E+03,8.0615E+02,
     &5.3743E+02,2.6872E+02,2.3258E+01/
      DATA ((KA(JS,JT,10,12),JS=1,9),JT=1,5) /
     &3.0213E+02,2.6436E+02,2.2659E+02,1.8883E+02,1.5106E+02,1.1330E+02,
     &7.5532E+01,4.3106E+01,2.5395E+01,4.9804E+02,4.3578E+02,3.7353E+02,
     &3.1127E+02,2.4902E+02,1.8676E+02,1.2451E+02,6.2505E+01,2.5385E+01,
     &7.7418E+02,6.7741E+02,5.8063E+02,4.8386E+02,3.8709E+02,2.9032E+02,
     &1.9354E+02,9.6773E+01,2.5325E+01,1.1469E+03,1.0035E+03,8.6015E+02,
     &7.1679E+02,5.7343E+02,4.3007E+02,2.8671E+02,1.4336E+02,2.5217E+01,
     &1.6217E+03,1.4190E+03,1.2162E+03,1.0135E+03,8.1083E+02,6.0812E+02,
     &4.0541E+02,2.0271E+02,2.5082E+01/
      DATA ((KA(JS,JT,11,12),JS=1,9),JT=1,5) /
     &2.6097E+02,2.2835E+02,1.9573E+02,1.6311E+02,1.3048E+02,9.7863E+01,
     &6.5361E+01,4.5364E+01,2.6989E+01,4.3087E+02,3.7701E+02,3.2315E+02,
     &2.6929E+02,2.1543E+02,1.6158E+02,1.0772E+02,5.7754E+01,2.6926E+01,
     &6.7272E+02,5.8863E+02,5.0454E+02,4.2045E+02,3.3636E+02,2.5227E+02,
     &1.6818E+02,8.4156E+01,2.6813E+01,9.9607E+02,8.7156E+02,7.4705E+02,
     &6.2254E+02,4.9803E+02,3.7353E+02,2.4902E+02,1.2451E+02,2.6666E+01,
     &1.4127E+03,1.2361E+03,1.0595E+03,8.8291E+02,7.0633E+02,5.2975E+02,
     &3.5316E+02,1.7658E+02,2.6473E+01/
      DATA ((KA(JS,JT,12,12),JS=1,9),JT=1,5) /
     &2.2830E+02,1.9976E+02,1.7123E+02,1.4269E+02,1.1415E+02,8.5613E+01,
     &6.0099E+01,4.8249E+01,2.8107E+01,3.7815E+02,3.3089E+02,2.8362E+02,
     &2.3635E+02,1.8908E+02,1.4181E+02,9.4540E+01,5.8332E+01,2.7966E+01,
     &5.9040E+02,5.1660E+02,4.4280E+02,3.6900E+02,2.9520E+02,2.2140E+02,
     &1.4760E+02,7.6746E+01,2.7793E+01,8.7660E+02,7.6702E+02,6.5745E+02,
     &5.4787E+02,4.3830E+02,3.2873E+02,2.1915E+02,1.0959E+02,2.7580E+01,
     &1.2432E+03,1.0878E+03,9.3242E+02,7.7702E+02,6.2161E+02,4.6621E+02,
     &3.1081E+02,1.5540E+02,2.7330E+01/
      DATA ((KA(JS,JT,13,12),JS=1,9),JT=1,5) /
     &2.0770E+02,1.8173E+02,1.5577E+02,1.2981E+02,1.0385E+02,7.8129E+01,
     &6.0586E+01,5.1072E+01,2.8383E+01,3.4420E+02,3.0118E+02,2.5815E+02,
     &2.1513E+02,1.7210E+02,1.2908E+02,8.7185E+01,6.1802E+01,2.8222E+01,
     &5.3871E+02,4.7137E+02,4.0403E+02,3.3670E+02,2.6936E+02,2.0202E+02,
     &1.3468E+02,7.6219E+01,2.8010E+01,7.9982E+02,6.9985E+02,5.9987E+02,
     &4.9989E+02,3.9991E+02,2.9994E+02,1.9996E+02,1.0196E+02,2.7782E+01,
     &1.1353E+03,9.9341E+02,8.5150E+02,7.0958E+02,5.6767E+02,4.2575E+02,
     &2.8384E+02,1.4192E+02,2.7521E+01/
      DATA ((KA(JS,JT, 1,13),JS=1,9),JT=1,5) /
     &1.0877E+04,9.5175E+03,8.1579E+03,6.7982E+03,5.4386E+03,4.0789E+03,
     &2.7193E+03,1.3596E+03,2.7375E-03,1.4140E+04,1.2372E+04,1.0605E+04,
     &8.8373E+03,7.0699E+03,5.3024E+03,3.5349E+03,1.7675E+03,2.6515E-03,
     &1.7904E+04,1.5666E+04,1.3428E+04,1.1190E+04,8.9519E+03,6.7139E+03,
     &4.4759E+03,2.2380E+03,3.8993E-02,2.2059E+04,1.9302E+04,1.6544E+04,
     &1.3787E+04,1.1029E+04,8.2721E+03,5.5147E+03,2.7574E+03,9.2576E-02,
     &2.6544E+04,2.3226E+04,1.9908E+04,1.6590E+04,1.3272E+04,9.9541E+03,
     &6.6361E+03,3.3180E+03,1.0695E-01/
      DATA ((KA(JS,JT, 2,13),JS=1,9),JT=1,5) /
     &9.6500E+03,8.4437E+03,7.2375E+03,6.0312E+03,4.8250E+03,3.6187E+03,
     &2.4125E+03,1.2062E+03,3.2200E-01,1.2735E+04,1.1143E+04,9.5512E+03,
     &7.9593E+03,6.3674E+03,4.7756E+03,3.1837E+03,1.5919E+03,5.1280E+00,
     &1.6244E+04,1.4213E+04,1.2183E+04,1.0152E+04,8.1218E+03,6.0913E+03,
     &4.0609E+03,2.0304E+03,7.4252E+00,2.0224E+04,1.7696E+04,1.5168E+04,
     &1.2640E+04,1.0112E+04,7.5839E+03,5.0559E+03,2.5280E+03,7.7282E+00,
     &2.4645E+04,2.1565E+04,1.8484E+04,1.5403E+04,1.2323E+04,9.2420E+03,
     &6.1614E+03,3.0807E+03,7.1576E+00/
      DATA ((KA(JS,JT, 3,13),JS=1,9),JT=1,5) /
     &7.8601E+03,6.8776E+03,5.8951E+03,4.9126E+03,3.9300E+03,2.9475E+03,
     &1.9650E+03,9.8251E+02,1.2409E+01,1.0573E+04,9.2512E+03,7.9296E+03,
     &6.6080E+03,5.2864E+03,3.9648E+03,2.6432E+03,1.3216E+03,1.2422E+01,
     &1.3794E+04,1.2070E+04,1.0346E+04,8.6214E+03,6.8971E+03,5.1729E+03,
     &3.4486E+03,1.7243E+03,1.2413E+01,1.7502E+04,1.5315E+04,1.3127E+04,
     &1.0939E+04,8.7512E+03,6.5634E+03,4.3756E+03,2.1878E+03,1.2394E+01,
     &2.1662E+04,1.8954E+04,1.6247E+04,1.3539E+04,1.0831E+04,8.1233E+03,
     &5.4155E+03,2.7078E+03,1.2358E+01/
      DATA ((KA(JS,JT, 4,13),JS=1,9),JT=1,5) /
     &6.0906E+03,5.3293E+03,4.5680E+03,3.8067E+03,3.0453E+03,2.2840E+03,
     &1.5227E+03,7.6133E+02,1.4627E+01,8.4475E+03,7.3915E+03,6.3356E+03,
     &5.2797E+03,4.2237E+03,3.1678E+03,2.1119E+03,1.0559E+03,1.4656E+01,
     &1.1299E+04,9.8868E+03,8.4744E+03,7.0620E+03,5.6496E+03,4.2372E+03,
     &2.8248E+03,1.4124E+03,1.4666E+01,1.4605E+04,1.2779E+04,1.0954E+04,
     &9.1282E+03,7.3025E+03,5.4769E+03,3.6513E+03,1.8256E+03,1.4645E+01,
     &1.8360E+04,1.6065E+04,1.3770E+04,1.1475E+04,9.1801E+03,6.8851E+03,
     &4.5900E+03,2.2950E+03,1.4604E+01/
      DATA ((KA(JS,JT, 5,13),JS=1,9),JT=1,5) /
     &4.6024E+03,4.0271E+03,3.4518E+03,2.8765E+03,2.3012E+03,1.7259E+03,
     &1.1506E+03,5.7529E+02,1.7191E+01,6.5855E+03,5.7623E+03,4.9391E+03,
     &4.1159E+03,3.2927E+03,2.4695E+03,1.6464E+03,8.2318E+02,1.7235E+01,
     &8.9962E+03,7.8717E+03,6.7471E+03,5.6226E+03,4.4981E+03,3.3736E+03,
     &2.2490E+03,1.1245E+03,1.7249E+01,1.1873E+04,1.0388E+04,8.9044E+03,
     &7.4203E+03,5.9363E+03,4.4522E+03,2.9681E+03,1.4841E+03,1.7236E+01,
     &1.5203E+04,1.3303E+04,1.1402E+04,9.5020E+03,7.6016E+03,5.7012E+03,
     &3.8008E+03,1.9004E+03,1.7202E+01/
      DATA ((KA(JS,JT, 6,13),JS=1,9),JT=1,5) /
     &3.3402E+03,2.9227E+03,2.5052E+03,2.0876E+03,1.6701E+03,1.2526E+03,
     &8.3506E+02,4.1753E+02,2.0086E+01,4.9170E+03,4.3024E+03,3.6877E+03,
     &3.0731E+03,2.4585E+03,1.8439E+03,1.2292E+03,6.1462E+02,2.0160E+01,
     &6.9136E+03,6.0494E+03,5.1852E+03,4.3210E+03,3.4568E+03,2.5926E+03,
     &1.7284E+03,8.6420E+02,2.0194E+01,9.3499E+03,8.1811E+03,7.0124E+03,
     &5.8437E+03,4.6749E+03,3.5062E+03,2.3375E+03,1.1687E+03,2.0186E+01,
     &1.2234E+04,1.0705E+04,9.1755E+03,7.6462E+03,6.1170E+03,4.5877E+03,
     &3.0585E+03,1.5292E+03,2.0149E+01/
      DATA ((KA(JS,JT, 7,13),JS=1,9),JT=1,5) /
     &2.3634E+03,2.0680E+03,1.7726E+03,1.4771E+03,1.1817E+03,8.8628E+02,
     &5.9086E+02,2.9543E+02,2.3318E+01,3.6109E+03,3.1596E+03,2.7082E+03,
     &2.2568E+03,1.8055E+03,1.3541E+03,9.0273E+02,4.5136E+02,2.3426E+01,
     &5.2430E+03,4.5876E+03,3.9322E+03,3.2769E+03,2.6215E+03,1.9661E+03,
     &1.3107E+03,6.5537E+02,2.3476E+01,7.2754E+03,6.3660E+03,5.4565E+03,
     &4.5471E+03,3.6377E+03,2.7283E+03,1.8188E+03,9.0942E+02,2.3476E+01,
     &9.7107E+03,8.4968E+03,7.2830E+03,6.0691E+03,4.8553E+03,3.6415E+03,
     &2.4276E+03,1.2138E+03,2.3445E+01/
      DATA ((KA(JS,JT, 8,13),JS=1,9),JT=1,5) /
     &1.6675E+03,1.4591E+03,1.2506E+03,1.0422E+03,8.3375E+02,6.2531E+02,
     &4.1687E+02,2.0844E+02,2.6870E+01,2.6544E+03,2.3226E+03,1.9908E+03,
     &1.6590E+03,1.3272E+03,9.9538E+02,6.6359E+02,3.3179E+02,2.6998E+01,
     &3.9767E+03,3.4797E+03,2.9826E+03,2.4855E+03,1.9884E+03,1.4913E+03,
     &9.9419E+02,4.9709E+02,2.7066E+01,5.6620E+03,4.9542E+03,4.2465E+03,
     &3.5387E+03,2.8310E+03,2.1232E+03,1.4155E+03,7.0775E+02,2.7083E+01,
     &7.7334E+03,6.7667E+03,5.8000E+03,4.8334E+03,3.8667E+03,2.9000E+03,
     &1.9333E+03,9.6667E+02,2.7049E+01/
      DATA ((KA(JS,JT, 9,13),JS=1,9),JT=1,5) /
     &1.1358E+03,9.9378E+02,8.5181E+02,7.0984E+02,5.6787E+02,4.2591E+02,
     &2.8394E+02,1.4197E+02,3.0678E+01,1.8861E+03,1.6503E+03,1.4146E+03,
     &1.1788E+03,9.4305E+02,7.0729E+02,4.7153E+02,2.3576E+02,3.0840E+01,
     &2.9209E+03,2.5558E+03,2.1907E+03,1.8256E+03,1.4605E+03,1.0953E+03,
     &7.3023E+02,3.6511E+02,3.0929E+01,4.2847E+03,3.7491E+03,3.2135E+03,
     &2.6779E+03,2.1424E+03,1.6068E+03,1.0712E+03,5.3559E+02,3.0953E+01,
     &6.0053E+03,5.2546E+03,4.5040E+03,3.7533E+03,3.0026E+03,2.2520E+03,
     &1.5013E+03,7.5066E+02,3.0913E+01/
      DATA ((KA(JS,JT,10,13),JS=1,9),JT=1,5) /
     &7.8733E+02,6.8892E+02,5.9050E+02,4.9208E+02,3.9366E+02,2.9525E+02,
     &1.9683E+02,9.8416E+01,3.4699E+01,1.3543E+03,1.1850E+03,1.0157E+03,
     &8.4641E+02,6.7713E+02,5.0785E+02,3.3856E+02,1.6928E+02,3.4872E+01,
     &2.1695E+03,1.8983E+03,1.6271E+03,1.3559E+03,1.0848E+03,8.1356E+02,
     &5.4238E+02,2.7119E+02,3.4962E+01,3.2703E+03,2.8615E+03,2.4527E+03,
     &2.0439E+03,1.6351E+03,1.2263E+03,8.1756E+02,4.0878E+02,3.4974E+01,
     &4.6791E+03,4.0942E+03,3.5093E+03,2.9244E+03,2.3395E+03,1.7546E+03,
     &1.1698E+03,5.8488E+02,3.4915E+01/
      DATA ((KA(JS,JT,11,13),JS=1,9),JT=1,5) /
     &7.0254E+02,6.1472E+02,5.2690E+02,4.3908E+02,3.5127E+02,2.6345E+02,
     &1.7563E+02,8.8441E+01,3.8867E+01,1.2148E+03,1.0630E+03,9.1111E+02,
     &7.5926E+02,6.0740E+02,4.5555E+02,3.0370E+02,1.5185E+02,3.8999E+01,
     &1.9474E+03,1.7040E+03,1.4606E+03,1.2171E+03,9.7371E+02,7.3028E+02,
     &4.8685E+02,2.4343E+02,3.9046E+01,2.9354E+03,2.5684E+03,2.2015E+03,
     &1.8346E+03,1.4677E+03,1.1008E+03,7.3384E+02,3.6692E+02,3.9009E+01,
     &4.2118E+03,3.6853E+03,3.1589E+03,2.6324E+03,2.1059E+03,1.5794E+03,
     &1.0529E+03,5.2647E+02,3.8898E+01/
      DATA ((KA(JS,JT,12,13),JS=1,9),JT=1,5) /
     &6.3490E+02,5.5553E+02,4.7617E+02,3.9681E+02,3.1745E+02,2.3809E+02,
     &1.5872E+02,8.3817E+01,4.2920E+01,1.0964E+03,9.5936E+02,8.2231E+02,
     &6.8526E+02,5.4821E+02,4.1116E+02,2.7410E+02,1.3705E+02,4.3006E+01,
     &1.7602E+03,1.5402E+03,1.3202E+03,1.1001E+03,8.8010E+02,6.6008E+02,
     &4.4005E+02,2.2003E+02,4.2996E+01,2.6586E+03,2.3263E+03,1.9940E+03,
     &1.6616E+03,1.3293E+03,9.9698E+02,6.6465E+02,3.3233E+02,4.2901E+01,
     &3.8091E+03,3.3329E+03,2.8568E+03,2.3807E+03,1.9045E+03,1.4284E+03,
     &9.5227E+02,4.7613E+02,4.2723E+01/
      DATA ((KA(JS,JT,13,13),JS=1,9),JT=1,5) /
     &5.9158E+02,5.1763E+02,4.4368E+02,3.6974E+02,2.9579E+02,2.2184E+02,
     &1.4790E+02,8.4889E+01,4.6678E+01,1.0244E+03,8.9631E+02,7.6827E+02,
     &6.4022E+02,5.1218E+02,3.8414E+02,2.5609E+02,1.2940E+02,4.6683E+01,
     &1.6452E+03,1.4395E+03,1.2339E+03,1.0282E+03,8.2259E+02,6.1694E+02,
     &4.1130E+02,2.0565E+02,4.6592E+01,2.4841E+03,2.1736E+03,1.8631E+03,
     &1.5526E+03,1.2421E+03,9.3154E+02,6.2103E+02,3.1052E+02,4.6412E+01,
     &3.5669E+03,3.1210E+03,2.6752E+03,2.2293E+03,1.7834E+03,1.3376E+03,
     &8.9172E+02,4.4586E+02,4.6169E+01/
      DATA ((KA(JS,JT, 1,14),JS=1,9),JT=1,5) /
     &2.0814E+04,1.8212E+04,1.5610E+04,1.3008E+04,1.0407E+04,7.8051E+03,
     &5.2034E+03,2.6017E+03,4.7014E-03,2.6951E+04,2.3582E+04,2.0213E+04,
     &1.6844E+04,1.3475E+04,1.0107E+04,6.7377E+03,3.3688E+03,6.0711E-03,
     &3.3875E+04,2.9641E+04,2.5406E+04,2.1172E+04,1.6938E+04,1.2703E+04,
     &8.4688E+03,4.2344E+03,2.5176E-02,4.1606E+04,3.6405E+04,3.1205E+04,
     &2.6004E+04,2.0803E+04,1.5602E+04,1.0402E+04,5.2008E+03,1.0468E-01,
     &5.0069E+04,4.3810E+04,3.7551E+04,3.1293E+04,2.5034E+04,1.8776E+04,
     &1.2517E+04,6.2586E+03,1.0717E-01/
      DATA ((KA(JS,JT, 2,14),JS=1,9),JT=1,5) /
     &1.9736E+04,1.7269E+04,1.4802E+04,1.2335E+04,9.8681E+03,7.4011E+03,
     &4.9341E+03,2.4670E+03,1.4424E-01,2.5938E+04,2.2696E+04,1.9454E+04,
     &1.6211E+04,1.2969E+04,9.7268E+03,6.4845E+03,3.2423E+03,5.4893E+00,
     &3.3117E+04,2.8978E+04,2.4838E+04,2.0698E+04,1.6559E+04,1.2419E+04,
     &8.2793E+03,4.1397E+03,6.5583E+00,4.1192E+04,3.6043E+04,3.0894E+04,
     &2.5745E+04,2.0596E+04,1.5447E+04,1.0298E+04,5.1490E+03,7.2955E+00,
     &5.0084E+04,4.3824E+04,3.7563E+04,3.1303E+04,2.5042E+04,1.8782E+04,
     &1.2521E+04,6.2605E+03,4.5976E+00/
      DATA ((KA(JS,JT, 3,14),JS=1,9),JT=1,5) /
     &1.7352E+04,1.5183E+04,1.3014E+04,1.0845E+04,8.6759E+03,6.5069E+03,
     &4.3379E+03,2.1690E+03,1.3353E+01,2.3378E+04,2.0456E+04,1.7533E+04,
     &1.4611E+04,1.1689E+04,8.7667E+03,5.8445E+03,2.9222E+03,1.3389E+01,
     &3.0448E+04,2.6642E+04,2.2836E+04,1.9030E+04,1.5224E+04,1.1418E+04,
     &7.6119E+03,3.8060E+03,1.3397E+01,3.8507E+04,3.3693E+04,2.8880E+04,
     &2.4067E+04,1.9253E+04,1.4440E+04,9.6266E+03,4.8133E+03,1.3385E+01,
     &4.7469E+04,4.1535E+04,3.5602E+04,2.9668E+04,2.3734E+04,1.7801E+04,
     &1.1867E+04,5.9336E+03,1.3346E+01/
      DATA ((KA(JS,JT, 4,14),JS=1,9),JT=1,5) /
     &1.4631E+04,1.2802E+04,1.0973E+04,9.1445E+03,7.3156E+03,5.4867E+03,
     &3.6578E+03,1.8289E+03,1.5943E+01,2.0262E+04,1.7729E+04,1.5197E+04,
     &1.2664E+04,1.0131E+04,7.5983E+03,5.0655E+03,2.5328E+03,1.6007E+01,
     &2.6988E+04,2.3615E+04,2.0241E+04,1.6868E+04,1.3494E+04,1.0121E+04,
     &6.7470E+03,3.3735E+03,1.6031E+01,3.4853E+04,3.0497E+04,2.6140E+04,
     &2.1783E+04,1.7427E+04,1.3070E+04,8.7133E+03,4.3567E+03,1.6028E+01,
     &4.3821E+04,3.8343E+04,3.2866E+04,2.7388E+04,2.1910E+04,1.6433E+04,
     &1.0955E+04,5.4776E+03,1.6009E+01/
      DATA ((KA(JS,JT, 5,14),JS=1,9),JT=1,5) /
     &1.2010E+04,1.0509E+04,9.0077E+03,7.5064E+03,6.0051E+03,4.5038E+03,
     &3.0026E+03,1.5013E+03,1.9009E+01,1.7127E+04,1.4986E+04,1.2846E+04,
     &1.0705E+04,8.5637E+03,6.4228E+03,4.2818E+03,2.1409E+03,1.9111E+01,
     &2.3449E+04,2.0517E+04,1.7586E+04,1.4655E+04,1.1724E+04,8.7932E+03,
     &5.8621E+03,2.9311E+03,1.9171E+01,3.0924E+04,2.7059E+04,2.3193E+04,
     &1.9328E+04,1.5462E+04,1.1597E+04,7.7310E+03,3.8655E+03,1.9184E+01,
     &3.9495E+04,3.4558E+04,2.9621E+04,2.4684E+04,1.9748E+04,1.4811E+04,
     &9.8738E+03,4.9369E+03,1.9172E+01/
      DATA ((KA(JS,JT, 6,14),JS=1,9),JT=1,5) /
     &9.4628E+03,8.2800E+03,7.0971E+03,5.9142E+03,4.7314E+03,3.5485E+03,
     &2.3657E+03,1.1828E+03,2.2644E+01,1.3981E+04,1.2233E+04,1.0486E+04,
     &8.7381E+03,6.9905E+03,5.2429E+03,3.4952E+03,1.7476E+03,2.2781E+01,
     &1.9648E+04,1.7192E+04,1.4736E+04,1.2280E+04,9.8239E+03,7.3679E+03,
     &4.9119E+03,2.4560E+03,2.2869E+01,2.6483E+04,2.3173E+04,1.9862E+04,
     &1.6552E+04,1.3242E+04,9.9312E+03,6.6208E+03,3.3104E+03,2.2915E+01,
     &3.4470E+04,3.0161E+04,2.5853E+04,2.1544E+04,1.7235E+04,1.2926E+04,
     &8.6175E+03,4.3088E+03,2.2923E+01/
      DATA ((KA(JS,JT, 7,14),JS=1,9),JT=1,5) /
     &7.3078E+03,6.3943E+03,5.4808E+03,4.5673E+03,3.6539E+03,2.7404E+03,
     &1.8269E+03,9.1346E+02,2.6896E+01,1.1178E+04,9.7811E+03,8.3838E+03,
     &6.9865E+03,5.5892E+03,4.1919E+03,2.7946E+03,1.3973E+03,2.7090E+01,
     &1.6168E+04,1.4147E+04,1.2126E+04,1.0105E+04,8.0839E+03,6.0629E+03,
     &4.0420E+03,2.0210E+03,2.7221E+01,2.2360E+04,1.9565E+04,1.6770E+04,
     &1.3975E+04,1.1180E+04,8.3848E+03,5.5899E+03,2.7949E+03,2.7298E+01,
     &2.9827E+04,2.6099E+04,2.2370E+04,1.8642E+04,1.4913E+04,1.1185E+04,
     &7.4567E+03,3.7283E+03,2.7315E+01/
      DATA ((KA(JS,JT, 8,14),JS=1,9),JT=1,5) /
     &5.5945E+03,4.8952E+03,4.1959E+03,3.4966E+03,2.7972E+03,2.0979E+03,
     &1.3986E+03,6.9931E+02,3.1842E+01,8.8907E+03,7.7794E+03,6.6680E+03,
     &5.5567E+03,4.4454E+03,3.3340E+03,2.2227E+03,1.1113E+03,3.2101E+01,
     &1.3296E+04,1.1634E+04,9.9724E+03,8.3103E+03,6.6483E+03,4.9862E+03,
     &3.3241E+03,1.6621E+03,3.2282E+01,1.8955E+04,1.6586E+04,1.4216E+04,
     &1.1847E+04,9.4776E+03,7.1082E+03,4.7388E+03,2.3694E+03,3.2388E+01,
     &2.5906E+04,2.2668E+04,1.9430E+04,1.6191E+04,1.2953E+04,9.7149E+03,
     &6.4766E+03,3.2383E+03,3.2425E+01/
      DATA ((KA(JS,JT, 9,14),JS=1,9),JT=1,5) /
     &4.1067E+03,3.5934E+03,3.0800E+03,2.5667E+03,2.0533E+03,1.5400E+03,
     &1.0267E+03,5.1334E+02,3.7521E+01,6.8230E+03,5.9701E+03,5.1172E+03,
     &4.2644E+03,3.4115E+03,2.5586E+03,1.7057E+03,8.5287E+02,3.7865E+01,
     &1.0614E+04,9.2875E+03,7.9607E+03,6.6339E+03,5.3071E+03,3.9804E+03,
     &2.6536E+03,1.3268E+03,3.8104E+01,1.5585E+04,1.3637E+04,1.1689E+04,
     &9.7408E+03,7.7926E+03,5.8445E+03,3.8963E+03,1.9481E+03,3.8251E+01,
     &2.1772E+04,1.9051E+04,1.6329E+04,1.3608E+04,1.0886E+04,8.1646E+03,
     &5.4430E+03,2.7215E+03,3.8308E+01/
      DATA ((KA(JS,JT,10,14),JS=1,9),JT=1,5) /
     &3.0498E+03,2.6686E+03,2.2874E+03,1.9061E+03,1.5249E+03,1.1437E+03,
     &7.6245E+02,3.8122E+02,4.4006E+01,5.3046E+03,4.6415E+03,3.9785E+03,
     &3.3154E+03,2.6523E+03,1.9892E+03,1.3261E+03,6.6307E+02,4.4440E+01,
     &8.5201E+03,7.4551E+03,6.3901E+03,5.3250E+03,4.2600E+03,3.1950E+03,
     &2.1300E+03,1.0650E+03,4.4746E+01,1.2818E+04,1.1216E+04,9.6138E+03,
     &8.0115E+03,6.4092E+03,4.8069E+03,3.2046E+03,1.6023E+03,4.4928E+01,
     &1.8340E+04,1.6048E+04,1.3755E+04,1.1463E+04,9.1701E+03,6.8776E+03,
     &4.5851E+03,2.2925E+03,4.5005E+01/
      DATA ((KA(JS,JT,11,14),JS=1,9),JT=1,5) /
     &2.9434E+03,2.5755E+03,2.2076E+03,1.8396E+03,1.4717E+03,1.1038E+03,
     &7.3585E+02,3.6793E+02,5.1570E+01,5.1056E+03,4.4674E+03,3.8292E+03,
     &3.1910E+03,2.5528E+03,1.9146E+03,1.2764E+03,6.3819E+02,5.2012E+01,
     &8.1976E+03,7.1728E+03,6.1481E+03,5.1234E+03,4.0987E+03,3.0741E+03,
     &2.0494E+03,1.0247E+03,5.2312E+01,1.2377E+04,1.0830E+04,9.2826E+03,
     &7.7355E+03,6.1884E+03,4.6413E+03,3.0942E+03,1.5471E+03,5.2478E+01,
     &1.7764E+04,1.5544E+04,1.3323E+04,1.1103E+04,8.8820E+03,6.6616E+03,
     &4.4410E+03,2.2205E+03,5.2507E+01/
      DATA ((KA(JS,JT,12,14),JS=1,9),JT=1,5) /
     &2.8315E+03,2.4776E+03,2.1237E+03,1.7697E+03,1.4158E+03,1.0618E+03,
     &7.0789E+02,3.5394E+02,5.9960E+01,4.9224E+03,4.3071E+03,3.6918E+03,
     &3.0765E+03,2.4612E+03,1.8459E+03,1.2306E+03,6.1530E+02,6.0405E+01,
     &7.9376E+03,6.9454E+03,5.9532E+03,4.9610E+03,3.9688E+03,2.9766E+03,
     &1.9844E+03,9.9220E+02,6.0667E+01,1.2004E+04,1.0504E+04,9.0032E+03,
     &7.5027E+03,6.0021E+03,4.5016E+03,3.0011E+03,1.5005E+03,6.0769E+01,
     &1.7211E+04,1.5059E+04,1.2908E+04,1.0757E+04,8.6054E+03,6.4541E+03,
     &4.3027E+03,2.1514E+03,6.0741E+01/
      DATA ((KA(JS,JT,13,14),JS=1,9),JT=1,5) /
     &2.8060E+03,2.4552E+03,2.1045E+03,1.7537E+03,1.4030E+03,1.0522E+03,
     &7.0149E+02,3.5075E+02,6.9076E+01,4.9007E+03,4.2881E+03,3.6756E+03,
     &3.0630E+03,2.4504E+03,1.8378E+03,1.2252E+03,6.1260E+02,6.9478E+01,
     &7.8921E+03,6.9056E+03,5.9191E+03,4.9326E+03,3.9460E+03,2.9595E+03,
     &1.9730E+03,9.8652E+02,6.9694E+01,1.1933E+04,1.0441E+04,8.9495E+03,
     &7.4579E+03,5.9663E+03,4.4748E+03,2.9832E+03,1.4916E+03,6.9728E+01,
     &1.7152E+04,1.5008E+04,1.2864E+04,1.0720E+04,8.5759E+03,6.4320E+03,
     &4.2880E+03,2.1440E+03,6.9601E+01/
      DATA ((KA(JS,JT, 1,15),JS=1,9),JT=1,5) /
     &3.5423E+04,3.0995E+04,2.6567E+04,2.2139E+04,1.7712E+04,1.3284E+04,
     &8.8558E+03,4.4279E+03,7.1610E-03,4.5820E+04,4.0093E+04,3.4365E+04,
     &2.8638E+04,2.2910E+04,1.7183E+04,1.1455E+04,5.7276E+03,7.1091E-03,
     &5.7623E+04,5.0421E+04,4.3218E+04,3.6015E+04,2.8812E+04,2.1609E+04,
     &1.4406E+04,7.2029E+03,7.8150E-03,7.0726E+04,6.1885E+04,5.3044E+04,
     &4.4204E+04,3.5363E+04,2.6522E+04,1.7681E+04,8.8407E+03,4.0966E-02,
     &8.4947E+04,7.4329E+04,6.3711E+04,5.3092E+04,4.2474E+04,3.1855E+04,
     &2.1237E+04,1.0618E+04,1.7079E-01/
      DATA ((KA(JS,JT, 2,15),JS=1,9),JT=1,5) /
     &3.6296E+04,3.1759E+04,2.7222E+04,2.2685E+04,1.8148E+04,1.3611E+04,
     &9.0740E+03,4.5370E+03,7.6264E-03,4.7676E+04,4.1717E+04,3.5757E+04,
     &2.9798E+04,2.3838E+04,1.7879E+04,1.1919E+04,5.9595E+03,7.8530E+00,
     &6.0722E+04,5.3132E+04,4.5542E+04,3.7951E+04,3.0361E+04,2.2771E+04,
     &1.5181E+04,7.5903E+03,1.1682E+01,7.5305E+04,6.5892E+04,5.6479E+04,
     &4.7065E+04,3.7652E+04,2.8239E+04,1.8826E+04,9.4131E+03,7.5532E+00,
     &9.1241E+04,7.9835E+04,6.8430E+04,5.7025E+04,4.5620E+04,3.4215E+04,
     &2.2810E+04,1.1405E+04,1.0957E+00/
      DATA ((KA(JS,JT, 3,15),JS=1,9),JT=1,5) /
     &3.4715E+04,3.0376E+04,2.6036E+04,2.1697E+04,1.7358E+04,1.3018E+04,
     &8.6788E+03,4.3394E+03,1.4232E+01,4.6613E+04,4.0787E+04,3.4960E+04,
     &2.9133E+04,2.3307E+04,1.7480E+04,1.1653E+04,5.8267E+03,1.4235E+01,
     &6.0451E+04,5.2894E+04,4.5338E+04,3.7782E+04,3.0225E+04,2.2669E+04,
     &1.5113E+04,7.5563E+03,1.4209E+01,7.6104E+04,6.6591E+04,5.7078E+04,
     &4.7565E+04,3.8052E+04,2.8539E+04,1.9026E+04,9.5130E+03,1.4121E+01,
     &9.3385E+04,8.1712E+04,7.0039E+04,5.8365E+04,4.6692E+04,3.5019E+04,
     &2.3346E+04,1.1673E+04,1.4063E+01/
      DATA ((KA(JS,JT, 4,15),JS=1,9),JT=1,5) /
     &3.1974E+04,2.7977E+04,2.3981E+04,1.9984E+04,1.5987E+04,1.1990E+04,
     &7.9936E+03,3.9968E+03,1.7130E+01,4.4033E+04,3.8529E+04,3.3025E+04,
     &2.7521E+04,2.2017E+04,1.6512E+04,1.1008E+04,5.5042E+03,1.7154E+01,
     &5.8299E+04,5.1012E+04,4.3725E+04,3.6437E+04,2.9150E+04,2.1862E+04,
     &1.4575E+04,7.2874E+03,1.7147E+01,7.4658E+04,6.5325E+04,5.5993E+04,
     &4.6661E+04,3.7329E+04,2.7997E+04,1.8664E+04,9.3322E+03,1.7125E+01,
     &9.3061E+04,8.1428E+04,6.9796E+04,5.8163E+04,4.6530E+04,3.4898E+04,
     &2.3265E+04,1.1633E+04,1.7053E+01/
      DATA ((KA(JS,JT, 5,15),JS=1,9),JT=1,5) /
     &2.8780E+04,2.5183E+04,2.1585E+04,1.7988E+04,1.4390E+04,1.0793E+04,
     &7.1950E+03,3.5975E+03,2.0610E+01,4.0696E+04,3.5609E+04,3.0522E+04,
     &2.5435E+04,2.0348E+04,1.5261E+04,1.0174E+04,5.0871E+03,2.0673E+01,
     &5.5132E+04,4.8240E+04,4.1349E+04,3.4457E+04,2.7566E+04,2.0674E+04,
     &1.3783E+04,6.8915E+03,2.0688E+01,7.2202E+04,6.3177E+04,5.4152E+04,
     &4.5126E+04,3.6101E+04,2.7076E+04,1.8051E+04,9.0253E+03,2.0678E+01,
     &9.1794E+04,8.0320E+04,6.8846E+04,5.7371E+04,4.5897E+04,3.4423E+04,
     &2.2949E+04,1.1474E+04,2.0627E+01/
      DATA ((KA(JS,JT, 6,15),JS=1,9),JT=1,5) /
     &2.4928E+04,2.1812E+04,1.8696E+04,1.5580E+04,1.2464E+04,9.3479E+03,
     &6.2319E+03,3.1160E+03,2.4743E+01,3.6459E+04,3.1902E+04,2.7344E+04,
     &2.2787E+04,1.8230E+04,1.3672E+04,9.1148E+03,4.5574E+03,2.4868E+01,
     &5.0921E+04,4.4556E+04,3.8191E+04,3.1826E+04,2.5461E+04,1.9095E+04,
     &1.2730E+04,6.3651E+03,2.4935E+01,6.8337E+04,5.9795E+04,5.1253E+04,
     &4.2711E+04,3.4168E+04,2.5626E+04,1.7084E+04,8.5421E+03,2.4952E+01,
     &8.8665E+04,7.7582E+04,6.6499E+04,5.5416E+04,4.4333E+04,3.3249E+04,
     &2.2166E+04,1.1083E+04,2.4917E+01/
      DATA ((KA(JS,JT, 7,15),JS=1,9),JT=1,5) /
     &2.1322E+04,1.8657E+04,1.5992E+04,1.3326E+04,1.0661E+04,7.9957E+03,
     &5.3305E+03,2.6652E+03,2.9665E+01,3.2413E+04,2.8361E+04,2.4310E+04,
     &2.0258E+04,1.6206E+04,1.2155E+04,8.1031E+03,4.0516E+03,2.9861E+01,
     &4.6696E+04,4.0859E+04,3.5022E+04,2.9185E+04,2.3348E+04,1.7511E+04,
     &1.1674E+04,5.8369E+03,3.0001E+01,6.4261E+04,5.6228E+04,4.8195E+04,
     &4.0163E+04,3.2130E+04,2.4098E+04,1.6065E+04,8.0325E+03,3.0074E+01,
     &8.5103E+04,7.4465E+04,6.3827E+04,5.3189E+04,4.2551E+04,3.1914E+04,
     &2.1276E+04,1.0638E+04,3.0077E+01/
      DATA ((KA(JS,JT, 8,15),JS=1,9),JT=1,5) /
     &1.8276E+04,1.5991E+04,1.3707E+04,1.1422E+04,9.1380E+03,6.8535E+03,
     &4.5690E+03,2.2845E+03,3.5525E+01,2.8919E+04,2.5304E+04,2.1689E+04,
     &1.8074E+04,1.4459E+04,1.0845E+04,7.2298E+03,3.6149E+03,3.5844E+01,
     &4.2999E+04,3.7624E+04,3.2249E+04,2.6874E+04,2.1500E+04,1.6125E+04,
     &1.0750E+04,5.3749E+03,3.6058E+01,6.0712E+04,5.3123E+04,4.5534E+04,
     &3.7945E+04,3.0356E+04,2.2767E+04,1.5178E+04,7.5890E+03,3.6184E+01,
     &8.2146E+04,7.1878E+04,6.1610E+04,5.1341E+04,4.1073E+04,3.0805E+04,
     &2.0537E+04,1.0268E+04,3.6243E+01/
      DATA ((KA(JS,JT, 9,15),JS=1,9),JT=1,5) /
     &1.5122E+04,1.3232E+04,1.1341E+04,9.4512E+03,7.5610E+03,5.6707E+03,
     &3.7805E+03,1.8902E+03,4.2513E+01,2.4972E+04,2.1851E+04,1.8729E+04,
     &1.5608E+04,1.2486E+04,9.3646E+03,6.2431E+03,3.1215E+03,4.2950E+01,
     &3.8412E+04,3.3611E+04,2.8809E+04,2.4007E+04,1.9206E+04,1.4404E+04,
     &9.6030E+03,4.8015E+03,4.3278E+01,5.5843E+04,4.8863E+04,4.1882E+04,
     &3.4902E+04,2.7921E+04,2.0941E+04,1.3961E+04,6.9804E+03,4.3480E+01,
     &7.7611E+04,6.7910E+04,5.8208E+04,4.8507E+04,3.8805E+04,2.9104E+04,
     &1.9403E+04,9.7013E+03,4.3587E+01/
      DATA ((KA(JS,JT,10,15),JS=1,9),JT=1,5) /
     &1.2684E+04,1.1099E+04,9.5132E+03,7.9276E+03,6.3421E+03,4.7566E+03,
     &3.1710E+03,1.5855E+03,5.0840E+01,2.1787E+04,1.9064E+04,1.6340E+04,
     &1.3617E+04,1.0893E+04,8.1700E+03,5.4467E+03,2.7233E+03,5.1430E+01,
     &3.4684E+04,3.0349E+04,2.6013E+04,2.1678E+04,1.7342E+04,1.3007E+04,
     &8.6710E+03,4.3355E+03,5.1863E+01,5.1947E+04,4.5454E+04,3.8960E+04,
     &3.2467E+04,2.5974E+04,1.9480E+04,1.2987E+04,6.4934E+03,5.2160E+01,
     &7.3912E+04,6.4673E+04,5.5434E+04,4.6195E+04,3.6956E+04,2.7717E+04,
     &1.8478E+04,9.2389E+03,5.2321E+01/
      DATA ((KA(JS,JT,11,15),JS=1,9),JT=1,5) /
     &1.3711E+04,1.1997E+04,1.0283E+04,8.5694E+03,6.8555E+03,5.1416E+03,
     &3.4277E+03,1.7139E+03,6.1054E+01,2.3669E+04,2.0711E+04,1.7752E+04,
     &1.4793E+04,1.1835E+04,8.8760E+03,5.9173E+03,2.9586E+03,6.1742E+01,
     &3.7832E+04,3.3103E+04,2.8374E+04,2.3645E+04,1.8916E+04,1.4187E+04,
     &9.4579E+03,4.7289E+03,6.2215E+01,5.6757E+04,4.9662E+04,4.2568E+04,
     &3.5473E+04,2.8378E+04,2.1284E+04,1.4189E+04,7.0945E+03,6.2524E+01,
     &8.0798E+04,7.0698E+04,6.0598E+04,5.0499E+04,4.0399E+04,3.0299E+04,
     &2.0199E+04,1.0100E+04,6.2689E+01/
      DATA ((KA(JS,JT,12,15),JS=1,9),JT=1,5) /
     &1.4989E+04,1.3115E+04,1.1241E+04,9.3679E+03,7.4943E+03,5.6207E+03,
     &3.7471E+03,1.8736E+03,7.3162E+01,2.5949E+04,2.2705E+04,1.9461E+04,
     &1.6218E+04,1.2974E+04,9.7307E+03,6.4871E+03,3.2436E+03,7.3885E+01,
     &4.1513E+04,3.6324E+04,3.1134E+04,2.5945E+04,2.0756E+04,1.5567E+04,
     &1.0378E+04,5.1891E+03,7.4405E+01,6.2315E+04,5.4526E+04,4.6737E+04,
     &3.8947E+04,3.1158E+04,2.3368E+04,1.5579E+04,7.7894E+03,7.4701E+01,
     &8.8861E+04,7.7754E+04,6.6646E+04,5.5538E+04,4.4431E+04,3.3323E+04,
     &2.2215E+04,1.1108E+04,7.4795E+01/
      DATA ((KA(JS,JT,13,15),JS=1,9),JT=1,5) /
     &1.6915E+04,1.4801E+04,1.2687E+04,1.0572E+04,8.4577E+03,6.3433E+03,
     &4.2289E+03,2.1144E+03,8.7334E+01,2.9284E+04,2.5624E+04,2.1963E+04,
     &1.8303E+04,1.4642E+04,1.0982E+04,7.3211E+03,3.6605E+03,8.8104E+01,
     &4.6892E+04,4.1031E+04,3.5169E+04,2.9308E+04,2.3446E+04,1.7585E+04,
     &1.1723E+04,5.8616E+03,8.8585E+01,7.0448E+04,6.1642E+04,5.2836E+04,
     &4.4030E+04,3.5224E+04,2.6418E+04,1.7612E+04,8.8061E+03,8.8802E+01,
     &1.0039E+05,8.7843E+04,7.5294E+04,6.2745E+04,5.0196E+04,3.7647E+04,
     &2.5098E+04,1.2549E+04,8.8791E+01/
      DATA ((KA(JS,JT, 1,16),JS=1,9),JT=1,5) /
     &4.3683E+04,3.8223E+04,3.2762E+04,2.7302E+04,2.1842E+04,1.6381E+04,
     &1.0921E+04,5.4604E+03,7.6073E-03,5.6813E+04,4.9712E+04,4.2610E+04,
     &3.5508E+04,2.8407E+04,2.1305E+04,1.4203E+04,7.1017E+03,7.6403E-03,
     &7.1746E+04,6.2777E+04,5.3809E+04,4.4841E+04,3.5873E+04,2.6905E+04,
     &1.7936E+04,8.9682E+03,3.7278E-03,8.8334E+04,7.7292E+04,6.6250E+04,
     &5.5209E+04,4.4167E+04,3.3125E+04,2.2083E+04,1.1042E+04,3.7292E-03,
     &1.0639E+05,9.3091E+04,7.9793E+04,6.6494E+04,5.3195E+04,3.9896E+04,
     &2.6598E+04,1.3299E+04,7.8826E-01/
      DATA ((KA(JS,JT, 2,16),JS=1,9),JT=1,5) /
     &4.6897E+04,4.1035E+04,3.5173E+04,2.9311E+04,2.3449E+04,1.7586E+04,
     &1.1724E+04,5.8622E+03,8.2408E-03,6.1887E+04,5.4151E+04,4.6415E+04,
     &3.8679E+04,3.0943E+04,2.3208E+04,1.5472E+04,7.7359E+03,1.2063E+01,
     &7.9108E+04,6.9219E+04,5.9331E+04,4.9442E+04,3.9554E+04,2.9666E+04,
     &1.9777E+04,9.8885E+03,1.1743E+01,9.8415E+04,8.6113E+04,7.3811E+04,
     &6.1509E+04,4.9207E+04,3.6906E+04,2.4604E+04,1.2302E+04,3.5693E-03,
     &1.1961E+05,1.0466E+05,8.9707E+04,7.4755E+04,5.9804E+04,4.4853E+04,
     &2.9902E+04,1.4951E+04,5.8824E-01/
      DATA ((KA(JS,JT, 3,16),JS=1,9),JT=1,5) /
     &4.7187E+04,4.1289E+04,3.5390E+04,2.9492E+04,2.3594E+04,1.7695E+04,
     &1.1797E+04,5.8984E+03,1.4554E+01,6.3662E+04,5.5704E+04,4.7746E+04,
     &3.9789E+04,3.1831E+04,2.3873E+04,1.5915E+04,7.9577E+03,1.4573E+01,
     &8.2931E+04,7.2565E+04,6.2198E+04,5.1832E+04,4.1465E+04,3.1099E+04,
     &2.0733E+04,1.0366E+04,1.4578E+01,1.0484E+05,9.1735E+04,7.8630E+04,
     &6.5525E+04,5.2420E+04,3.9315E+04,2.6210E+04,1.3105E+04,1.4538E+01,
     &1.2920E+05,1.1305E+05,9.6898E+04,8.0748E+04,6.4599E+04,4.8449E+04,
     &3.2299E+04,1.6150E+04,1.4475E+01/
      DATA ((KA(JS,JT, 4,16),JS=1,9),JT=1,5) /
     &4.6077E+04,4.0317E+04,3.4558E+04,2.8798E+04,2.3038E+04,1.7279E+04,
     &1.1519E+04,5.7596E+03,1.7584E+01,6.3824E+04,5.5846E+04,4.7868E+04,
     &3.9890E+04,3.1912E+04,2.3934E+04,1.5956E+04,7.9779E+03,1.7639E+01,
     &8.4999E+04,7.4374E+04,6.3749E+04,5.3124E+04,4.2499E+04,3.1874E+04,
     &2.1250E+04,1.0625E+04,1.7665E+01,1.0949E+05,9.5804E+04,8.2118E+04,
     &6.8432E+04,5.4745E+04,4.1059E+04,2.7373E+04,1.3686E+04,1.7655E+01,
     &1.3706E+05,1.1993E+05,1.0280E+05,8.5665E+04,6.8532E+04,5.1399E+04,
     &3.4266E+04,1.7133E+04,1.7601E+01/
      DATA ((KA(JS,JT, 5,16),JS=1,9),JT=1,5) /
     &4.4408E+04,3.8857E+04,3.3306E+04,2.7755E+04,2.2204E+04,1.6653E+04,
     &1.1102E+04,5.5509E+03,2.1257E+01,6.3274E+04,5.5364E+04,4.7455E+04,
     &3.9546E+04,3.1637E+04,2.3728E+04,1.5818E+04,7.9092E+03,2.1367E+01,
     &8.6266E+04,7.5483E+04,6.4700E+04,5.3916E+04,4.3133E+04,3.2350E+04,
     &2.1567E+04,1.0783E+04,2.1428E+01,1.1336E+05,9.9194E+04,8.5023E+04,
     &7.0853E+04,5.6682E+04,4.2512E+04,2.8341E+04,1.4171E+04,2.1442E+01,
     &1.4437E+05,1.2632E+05,1.0827E+05,9.0229E+04,7.2183E+04,5.4137E+04,
     &3.6091E+04,1.8046E+04,2.1411E+01/
      DATA ((KA(JS,JT, 6,16),JS=1,9),JT=1,5) /
     &4.1622E+04,3.6419E+04,3.1217E+04,2.6014E+04,2.0811E+04,1.5608E+04,
     &1.0406E+04,5.2028E+03,2.5704E+01,6.1272E+04,5.3613E+04,4.5954E+04,
     &3.8295E+04,3.0636E+04,2.2977E+04,1.5318E+04,7.6590E+03,2.5880E+01,
     &8.5823E+04,7.5095E+04,6.4367E+04,5.3639E+04,4.2911E+04,3.2183E+04,
     &2.1456E+04,1.0728E+04,2.5988E+01,1.1534E+05,1.0092E+05,8.6501E+04,
     &7.2084E+04,5.7667E+04,4.3251E+04,2.8834E+04,1.4417E+04,2.6050E+01,
     &1.4970E+05,1.3098E+05,1.1227E+05,9.3560E+04,7.4848E+04,5.6136E+04,
     &3.7424E+04,1.8712E+04,2.6033E+01/
      DATA ((KA(JS,JT, 7,16),JS=1,9),JT=1,5) /
     &3.8762E+04,3.3917E+04,2.9071E+04,2.4226E+04,1.9381E+04,1.4536E+04,
     &9.6904E+03,4.8452E+03,3.1098E+01,5.9114E+04,5.1725E+04,4.4335E+04,
     &3.6946E+04,2.9557E+04,2.2168E+04,1.4778E+04,7.3892E+03,3.1343E+01,
     &8.5273E+04,7.4614E+04,6.3955E+04,5.3296E+04,4.2636E+04,3.1977E+04,
     &2.1318E+04,1.0659E+04,3.1509E+01,1.1738E+05,1.0271E+05,8.8034E+04,
     &7.3362E+04,5.8689E+04,4.4017E+04,2.9345E+04,1.4672E+04,3.1622E+01,
     &1.5542E+05,1.3599E+05,1.1657E+05,9.7138E+04,7.7710E+04,5.8283E+04,
     &3.8855E+04,1.9427E+04,3.1655E+01/
      DATA ((KA(JS,JT, 8,16),JS=1,9),JT=1,5) /
     &3.6377E+04,3.1830E+04,2.7279E+04,2.2736E+04,1.8189E+04,1.3641E+04,
     &9.0943E+03,4.5472E+03,3.7610E+01,5.7649E+04,5.0443E+04,4.3237E+04,
     &3.6031E+04,2.8825E+04,2.1619E+04,1.4412E+04,7.2062E+03,3.7934E+01,
     &8.5747E+04,7.5029E+04,6.4311E+04,5.3592E+04,4.2874E+04,3.2155E+04,
     &2.1437E+04,1.0718E+04,3.8193E+01,1.2106E+05,1.0593E+05,9.0796E+04,
     &7.5663E+04,6.0531E+04,4.5398E+04,3.0265E+04,1.5133E+04,3.8356E+01,
     &1.6369E+05,1.4323E+05,1.2277E+05,1.0231E+05,8.1844E+04,6.1383E+04,
     &4.0922E+04,2.0461E+04,3.8437E+01/
      DATA ((KA(JS,JT, 9,16),JS=1,9),JT=1,5) /
     &3.3210E+04,2.9058E+04,2.4907E+04,2.0756E+04,1.6605E+04,1.2454E+04,
     &8.3024E+03,4.1512E+03,4.5425E+01,5.4859E+04,4.8001E+04,4.1144E+04,
     &3.4287E+04,2.7429E+04,2.0572E+04,1.3715E+04,6.8573E+03,4.5889E+01,
     &8.4365E+04,7.3820E+04,6.3274E+04,5.2728E+04,4.2183E+04,3.1637E+04,
     &2.1091E+04,1.0546E+04,4.6246E+01,1.2241E+05,1.0711E+05,9.1805E+04,
     &7.6504E+04,6.1203E+04,4.5902E+04,3.0602E+04,1.5301E+04,4.6486E+01,
     &1.6922E+05,1.4806E+05,1.2691E+05,1.0576E+05,8.4608E+04,6.3456E+04,
     &4.2304E+04,2.1152E+04,4.6625E+01/
      DATA ((KA(JS,JT,10,16),JS=1,9),JT=1,5) /
     &3.0979E+04,2.7106E+04,2.3234E+04,1.9362E+04,1.5489E+04,1.1617E+04,
     &7.7447E+03,3.8723E+03,5.4886E+01,5.3196E+04,4.6547E+04,3.9897E+04,
     &3.3248E+04,2.6598E+04,1.9948E+04,1.3299E+04,6.6495E+03,5.5476E+01,
     &8.4341E+04,7.3798E+04,6.3256E+04,5.2713E+04,4.2170E+04,3.1628E+04,
     &2.1085E+04,1.0332E+04,5.5974E+01,1.2535E+05,1.0968E+05,9.4014E+04,
     &7.8345E+04,6.2676E+04,4.7007E+04,3.1338E+04,1.5669E+04,5.6279E+01,
     &1.7674E+05,1.5464E+05,1.3255E+05,1.1046E+05,8.8368E+04,6.6276E+04,
     &4.4184E+04,2.2092E+04,5.6482E+01/
      DATA ((KA(JS,JT,11,16),JS=1,9),JT=1,5) /
     &3.7488E+04,3.2802E+04,2.8116E+04,2.3430E+04,1.8744E+04,1.4058E+04,
     &9.3718E+03,4.6859E+03,6.6623E+01,6.4180E+04,5.6158E+04,4.8135E+04,
     &4.0112E+04,3.2090E+04,2.4067E+04,1.6045E+04,8.0224E+03,6.7308E+01,
     &1.0143E+05,8.8753E+04,7.6074E+04,6.3395E+04,5.0716E+04,3.8037E+04,
     &2.5358E+04,1.2679E+04,6.7849E+01,1.5034E+05,1.3155E+05,1.1275E+05,
     &9.3961E+04,7.5169E+04,5.6376E+04,3.7584E+04,1.8792E+04,6.8179E+01,
     &2.1140E+05,1.8498E+05,1.5855E+05,1.3213E+05,1.0570E+05,7.9275E+04,
     &5.2850E+04,2.6425E+04,6.8333E+01/
      DATA ((KA(JS,JT,12,16),JS=1,9),JT=1,5) /
     &4.5641E+04,3.9936E+04,3.4231E+04,2.8526E+04,2.2821E+04,1.7116E+04,
     &1.1410E+04,5.7052E+03,8.0729E+01,7.7843E+04,6.8113E+04,5.8382E+04,
     &4.8652E+04,3.8922E+04,2.9191E+04,1.9461E+04,9.7304E+03,8.1511E+01,
     &1.2264E+05,1.0731E+05,9.1979E+04,7.6649E+04,6.1320E+04,4.5990E+04,
     &3.0660E+04,1.5330E+04,8.2042E+01,1.8173E+05,1.5901E+05,1.3629E+05,
     &1.1358E+05,9.0863E+04,6.8147E+04,4.5431E+04,2.2716E+04,8.2374E+01,
     &2.5615E+05,2.2413E+05,1.9211E+05,1.6009E+05,1.2807E+05,9.6056E+04,
     &6.4037E+04,3.2019E+04,8.2428E+01/
      DATA ((KA(JS,JT,13,16),JS=1,9),JT=1,5) /
     &5.7163E+04,5.0018E+04,4.2872E+04,3.5727E+04,2.8582E+04,2.1436E+04,
     &1.4291E+04,7.1455E+03,9.7539E+01,9.7458E+04,8.5276E+04,7.3094E+04,
     &6.0911E+04,4.8729E+04,3.6547E+04,2.4365E+04,1.2182E+04,9.8425E+01,
     &1.5404E+05,1.3479E+05,1.1553E+05,9.6277E+04,7.7021E+04,5.7766E+04,
     &3.8511E+04,1.9255E+04,9.8903E+01,2.2887E+05,2.0026E+05,1.7165E+05,
     &1.4304E+05,1.1444E+05,8.5827E+04,5.7218E+04,2.8609E+04,9.9135E+01,
     &3.2310E+05,2.8271E+05,2.4232E+05,2.0194E+05,1.6155E+05,1.2116E+05,
     &8.0775E+04,4.0387E+04,9.9042E+01/

C     The array KA_Mxx contains the absorption coefficient for 
C     a minor species at the 16 chosen g-values for a reference pressure
C     level below 100~ mb.   The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.  The second index refers to temperature 
C     in 7.2 degree increments.  For instance, JT = 1 refers to a 
C     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
C     runs over the g-channel (1 to 16).

       DATA (KA_MN2( 1,JT, 1),JT=1,19)  /
     & 3.24352e-08, 3.39625e-08, 3.55618e-08, 3.72364e-08, 3.89899e-08,
     & 4.08259e-08, 4.27484e-08, 4.47614e-08, 4.68692e-08, 4.90763e-08,
     & 5.13873e-08, 5.38071e-08, 5.63409e-08, 5.89940e-08, 6.17720e-08,
     & 6.46808e-08, 6.77266e-08, 7.09158e-08, 7.42553e-08/
       DATA (KA_MN2( 2,JT, 1),JT=1,19)  /
     & 3.44203e-08, 3.60254e-08, 3.77053e-08, 3.94636e-08, 4.13038e-08,
     & 4.32299e-08, 4.52458e-08, 4.73557e-08, 4.95640e-08, 5.18753e-08,
     & 5.42943e-08, 5.68262e-08, 5.94761e-08, 6.22496e-08, 6.51524e-08,
     & 6.81906e-08, 7.13704e-08, 7.46986e-08, 7.81819e-08/
       DATA (KA_MN2( 3,JT, 1),JT=1,19)  /
     & 3.44344e-08, 3.61485e-08, 3.79480e-08, 3.98370e-08, 4.18201e-08,
     & 4.39019e-08, 4.60873e-08, 4.83815e-08, 5.07899e-08, 5.33182e-08,
     & 5.59723e-08, 5.87586e-08, 6.16836e-08, 6.47541e-08, 6.79776e-08,
     & 7.13614e-08, 7.49138e-08, 7.86429e-08, 8.25577e-08/
       DATA (KA_MN2( 4,JT, 1),JT=1,19)  /
     & 4.21102e-08, 4.38921e-08, 4.57493e-08, 4.76852e-08, 4.97029e-08,
     & 5.18061e-08, 5.39982e-08, 5.62831e-08, 5.86647e-08, 6.11470e-08,
     & 6.37344e-08, 6.64313e-08, 6.92422e-08, 7.21722e-08, 7.52261e-08,
     & 7.84092e-08, 8.17270e-08, 8.51852e-08, 8.87897e-08/
       DATA (KA_MN2( 5,JT, 1),JT=1,19)  /
     & 4.78813e-08, 5.01015e-08, 5.24246e-08, 5.48554e-08, 5.73989e-08,
     & 6.00603e-08, 6.28452e-08, 6.57592e-08, 6.88083e-08, 7.19987e-08,
     & 7.53371e-08, 7.88304e-08, 8.24855e-08, 8.63102e-08, 9.03122e-08,
     & 9.44997e-08, 9.88815e-08, 1.03466e-07, 1.08264e-07/
       DATA (KA_MN2( 6,JT, 1),JT=1,19)  /
     & 7.03115e-08, 7.27877e-08, 7.53511e-08, 7.80048e-08, 8.07519e-08,
     & 8.35958e-08, 8.65398e-08, 8.95875e-08, 9.27426e-08, 9.60087e-08,
     & 9.93899e-08, 1.02890e-07, 1.06514e-07, 1.10265e-07, 1.14148e-07,
     & 1.18168e-07, 1.22330e-07, 1.26638e-07, 1.31098e-07/
       DATA (KA_MN2( 7,JT, 1),JT=1,19)  /
     & 8.86454e-08, 9.20065e-08, 9.54951e-08, 9.91159e-08, 1.02874e-07,
     & 1.06775e-07, 1.10823e-07, 1.15025e-07, 1.19387e-07, 1.23913e-07,
     & 1.28612e-07, 1.33488e-07, 1.38550e-07, 1.43803e-07, 1.49255e-07,
     & 1.54915e-07, 1.60788e-07, 1.66885e-07, 1.73213e-07/
       DATA (KA_MN2( 8,JT, 1),JT=1,19)  /
     & 1.34118e-07, 1.38267e-07, 1.42545e-07, 1.46955e-07, 1.51502e-07,
     & 1.56189e-07, 1.61022e-07, 1.66004e-07, 1.71140e-07, 1.76435e-07,
     & 1.81893e-07, 1.87521e-07, 1.93323e-07, 1.99304e-07, 2.05470e-07,
     & 2.11827e-07, 2.18381e-07, 2.25138e-07, 2.32103e-07/
       DATA (KA_MN2( 9,JT, 1),JT=1,19)  /
     & 5.08256e-08, 5.30384e-08, 5.53476e-08, 5.77573e-08, 6.02718e-08,
     & 6.28959e-08, 6.56342e-08, 6.84917e-08, 7.14737e-08, 7.45854e-08,
     & 7.78327e-08, 8.12213e-08, 8.47574e-08, 8.84475e-08, 9.22983e-08,
     & 9.63167e-08, 1.00510e-07, 1.04886e-07, 1.09452e-07/
       DATA (KA_MN2( 1,JT, 2),JT=1,19)  /
     & 8.23958e-08, 8.39092e-08, 8.54504e-08, 8.70200e-08, 8.86183e-08,
     & 9.02460e-08, 9.19036e-08, 9.35917e-08, 9.53107e-08, 9.70614e-08,
     & 9.88442e-08, 1.00660e-07, 1.02509e-07, 1.04391e-07, 1.06309e-07,
     & 1.08261e-07, 1.10250e-07, 1.12275e-07, 1.14337e-07/
       DATA (KA_MN2( 2,JT, 2),JT=1,19)  /
     & 8.52335e-08, 8.69254e-08, 8.86509e-08, 9.04107e-08, 9.22054e-08,
     & 9.40357e-08, 9.59024e-08, 9.78061e-08, 9.97476e-08, 1.01728e-07,
     & 1.03747e-07, 1.05806e-07, 1.07907e-07, 1.10049e-07, 1.12233e-07,
     & 1.14461e-07, 1.16733e-07, 1.19050e-07, 1.21414e-07/
       DATA (KA_MN2( 3,JT, 2),JT=1,19)  /
     & 1.04608e-07, 1.06067e-07, 1.07546e-07, 1.09046e-07, 1.10567e-07,
     & 1.12110e-07, 1.13673e-07, 1.15259e-07, 1.16866e-07, 1.18496e-07,
     & 1.20149e-07, 1.21825e-07, 1.23524e-07, 1.25247e-07, 1.26994e-07,
     & 1.28765e-07, 1.30561e-07, 1.32382e-07, 1.34229e-07/
       DATA (KA_MN2( 4,JT, 2),JT=1,19)  /
     & 1.17504e-07, 1.18763e-07, 1.20036e-07, 1.21322e-07, 1.22622e-07,
     & 1.23936e-07, 1.25265e-07, 1.26607e-07, 1.27964e-07, 1.29335e-07,
     & 1.30721e-07, 1.32122e-07, 1.33538e-07, 1.34969e-07, 1.36415e-07,
     & 1.37877e-07, 1.39354e-07, 1.40848e-07, 1.42357e-07/
       DATA (KA_MN2( 5,JT, 2),JT=1,19)  /
     & 1.23552e-07, 1.25200e-07, 1.26870e-07, 1.28562e-07, 1.30277e-07,
     & 1.32015e-07, 1.33776e-07, 1.35560e-07, 1.37368e-07, 1.39200e-07,
     & 1.41057e-07, 1.42938e-07, 1.44845e-07, 1.46777e-07, 1.48735e-07,
     & 1.50718e-07, 1.52729e-07, 1.54766e-07, 1.56830e-07/
       DATA (KA_MN2( 6,JT, 2),JT=1,19)  /
     & 1.29682e-07, 1.32226e-07, 1.34820e-07, 1.37464e-07, 1.40161e-07,
     & 1.42910e-07, 1.45713e-07, 1.48571e-07, 1.51486e-07, 1.54457e-07,
     & 1.57487e-07, 1.60576e-07, 1.63726e-07, 1.66937e-07, 1.70212e-07,
     & 1.73551e-07, 1.76955e-07, 1.80426e-07, 1.83965e-07/
       DATA (KA_MN2( 7,JT, 2),JT=1,19)  /
     & 1.77416e-07, 1.78627e-07, 1.79846e-07, 1.81073e-07, 1.82309e-07,
     & 1.83554e-07, 1.84806e-07, 1.86068e-07, 1.87338e-07, 1.88616e-07,
     & 1.89904e-07, 1.91200e-07, 1.92505e-07, 1.93819e-07, 1.95142e-07,
     & 1.96474e-07, 1.97815e-07, 1.99165e-07, 2.00524e-07/
       DATA (KA_MN2( 8,JT, 2),JT=1,19)  /
     & 2.20695e-07, 2.20451e-07, 2.20208e-07, 2.19965e-07, 2.19722e-07,
     & 2.19480e-07, 2.19238e-07, 2.18996e-07, 2.18754e-07, 2.18513e-07,
     & 2.18272e-07, 2.18031e-07, 2.17790e-07, 2.17550e-07, 2.17310e-07,
     & 2.17070e-07, 2.16831e-07, 2.16591e-07, 2.16352e-07/
       DATA (KA_MN2( 9,JT, 2),JT=1,19)  /
     & 1.23015e-07, 1.24808e-07, 1.26626e-07, 1.28471e-07, 1.30343e-07,
     & 1.32242e-07, 1.34168e-07, 1.36123e-07, 1.38106e-07, 1.40118e-07,
     & 1.42160e-07, 1.44231e-07, 1.46332e-07, 1.48464e-07, 1.50627e-07,
     & 1.52822e-07, 1.55048e-07, 1.57307e-07, 1.59599e-07/
       DATA (KA_MN2( 1,JT, 3),JT=1,19)  /
     & 1.87585e-07, 1.89503e-07, 1.91440e-07, 1.93398e-07, 1.95375e-07,
     & 1.97372e-07, 1.99390e-07, 2.01429e-07, 2.03488e-07, 2.05568e-07,
     & 2.07670e-07, 2.09793e-07, 2.11938e-07, 2.14105e-07, 2.16294e-07,
     & 2.18505e-07, 2.20739e-07, 2.22996e-07, 2.25275e-07/
       DATA (KA_MN2( 2,JT, 3),JT=1,19)  /
     & 1.82585e-07, 1.84249e-07, 1.85929e-07, 1.87624e-07, 1.89335e-07,
     & 1.91061e-07, 1.92803e-07, 1.94561e-07, 1.96335e-07, 1.98125e-07,
     & 1.99932e-07, 2.01755e-07, 2.03594e-07, 2.05451e-07, 2.07324e-07,
     & 2.09214e-07, 2.11122e-07, 2.13047e-07, 2.14989e-07/
       DATA (KA_MN2( 3,JT, 3),JT=1,19)  /
     & 1.64711e-07, 1.67539e-07, 1.70417e-07, 1.73343e-07, 1.76321e-07,
     & 1.79349e-07, 1.82429e-07, 1.85562e-07, 1.88749e-07, 1.91990e-07,
     & 1.95288e-07, 1.98642e-07, 2.02053e-07, 2.05523e-07, 2.09053e-07,
     & 2.12643e-07, 2.16295e-07, 2.20010e-07, 2.23788e-07/
       DATA (KA_MN2( 4,JT, 3),JT=1,19)  /
     & 1.67494e-07, 1.71011e-07, 1.74601e-07, 1.78267e-07, 1.82009e-07,
     & 1.85831e-07, 1.89732e-07, 1.93715e-07, 1.97782e-07, 2.01935e-07,
     & 2.06174e-07, 2.10503e-07, 2.14922e-07, 2.19434e-07, 2.24041e-07,
     & 2.28745e-07, 2.33548e-07, 2.38451e-07, 2.43457e-07/
       DATA (KA_MN2( 5,JT, 3),JT=1,19)  /
     & 1.97399e-07, 2.00092e-07, 2.02821e-07, 2.05588e-07, 2.08393e-07,
     & 2.11236e-07, 2.14118e-07, 2.17039e-07, 2.20000e-07, 2.23001e-07,
     & 2.26043e-07, 2.29127e-07, 2.32252e-07, 2.35421e-07, 2.38633e-07,
     & 2.41888e-07, 2.45188e-07, 2.48533e-07, 2.51923e-07/
       DATA (KA_MN2( 6,JT, 3),JT=1,19)  /
     & 2.24021e-07, 2.24970e-07, 2.25923e-07, 2.26880e-07, 2.27840e-07,
     & 2.28805e-07, 2.29774e-07, 2.30747e-07, 2.31725e-07, 2.32706e-07,
     & 2.33692e-07, 2.34681e-07, 2.35675e-07, 2.36673e-07, 2.37675e-07,
     & 2.38682e-07, 2.39693e-07, 2.40708e-07, 2.41727e-07/
       DATA (KA_MN2( 7,JT, 3),JT=1,19)  /
     & 1.98178e-07, 2.00676e-07, 2.03205e-07, 2.05766e-07, 2.08359e-07,
     & 2.10986e-07, 2.13645e-07, 2.16337e-07, 2.19064e-07, 2.21825e-07,
     & 2.24621e-07, 2.27452e-07, 2.30319e-07, 2.33222e-07, 2.36161e-07,
     & 2.39138e-07, 2.42152e-07, 2.45204e-07, 2.48294e-07/
       DATA (KA_MN2( 8,JT, 3),JT=1,19)  /
     & 2.83042e-07, 2.89941e-07, 2.97009e-07, 3.04250e-07, 3.11666e-07,
     & 3.19264e-07, 3.27047e-07, 3.35019e-07, 3.43186e-07, 3.51552e-07,
     & 3.60122e-07, 3.68901e-07, 3.77893e-07, 3.87105e-07, 3.96542e-07,
     & 4.06208e-07, 4.16111e-07, 4.26254e-07, 4.36645e-07/
       DATA (KA_MN2( 9,JT, 3),JT=1,19)  /
     & 1.98963e-07, 2.01576e-07, 2.04224e-07, 2.06907e-07, 2.09626e-07,
     & 2.12379e-07, 2.15169e-07, 2.17996e-07, 2.20860e-07, 2.23761e-07,
     & 2.26701e-07, 2.29679e-07, 2.32696e-07, 2.35753e-07, 2.38851e-07,
     & 2.41988e-07, 2.45167e-07, 2.48388e-07, 2.51651e-07/
       DATA (KA_MN2( 1,JT, 4),JT=1,19)  /
     & 3.75434e-07, 3.79581e-07, 3.83775e-07, 3.88014e-07, 3.92301e-07,
     & 3.96634e-07, 4.01016e-07, 4.05446e-07, 4.09925e-07, 4.14453e-07,
     & 4.19032e-07, 4.23661e-07, 4.28341e-07, 4.33073e-07, 4.37857e-07,
     & 4.42694e-07, 4.47585e-07, 4.52529e-07, 4.57528e-07/
       DATA (KA_MN2( 2,JT, 4),JT=1,19)  /
     & 3.76756e-07, 3.80760e-07, 3.84805e-07, 3.88894e-07, 3.93027e-07,
     & 3.97203e-07, 4.01423e-07, 4.05689e-07, 4.10000e-07, 4.14356e-07,
     & 4.18759e-07, 4.23209e-07, 4.27706e-07, 4.32250e-07, 4.36843e-07,
     & 4.41485e-07, 4.46176e-07, 4.50917e-07, 4.55708e-07/
       DATA (KA_MN2( 3,JT, 4),JT=1,19)  /
     & 3.76258e-07, 3.78929e-07, 3.81619e-07, 3.84329e-07, 3.87057e-07,
     & 3.89805e-07, 3.92572e-07, 3.95359e-07, 3.98166e-07, 4.00993e-07,
     & 4.03839e-07, 4.06706e-07, 4.09594e-07, 4.12502e-07, 4.15430e-07,
     & 4.18379e-07, 4.21349e-07, 4.24341e-07, 4.27353e-07/
       DATA (KA_MN2( 4,JT, 4),JT=1,19)  /
     & 3.17796e-07, 3.22447e-07, 3.27166e-07, 3.31954e-07, 3.36812e-07,
     & 3.41742e-07, 3.46743e-07, 3.51818e-07, 3.56967e-07, 3.62191e-07,
     & 3.67492e-07, 3.72870e-07, 3.78328e-07, 3.83865e-07, 3.89483e-07,
     & 3.95183e-07, 4.00967e-07, 4.06835e-07, 4.12789e-07/
       DATA (KA_MN2( 5,JT, 4),JT=1,19)  /
     & 3.33793e-07, 3.38941e-07, 3.44169e-07, 3.49478e-07, 3.54868e-07,
     & 3.60342e-07, 3.65900e-07, 3.71544e-07, 3.77275e-07, 3.83094e-07,
     & 3.89003e-07, 3.95003e-07, 4.01096e-07, 4.07283e-07, 4.13565e-07,
     & 4.19944e-07, 4.26421e-07, 4.32999e-07, 4.39677e-07/
       DATA (KA_MN2( 6,JT, 4),JT=1,19)  /
     & 3.60052e-07, 3.66686e-07, 3.73442e-07, 3.80323e-07, 3.87330e-07,
     & 3.94466e-07, 4.01734e-07, 4.09136e-07, 4.16674e-07, 4.24351e-07,
     & 4.32169e-07, 4.40132e-07, 4.48241e-07, 4.56500e-07, 4.64910e-07,
     & 4.73476e-07, 4.82200e-07, 4.91084e-07, 5.00132e-07/
       DATA (KA_MN2( 7,JT, 4),JT=1,19)  /
     & 4.14713e-07, 4.21885e-07, 4.29181e-07, 4.36603e-07, 4.44153e-07,
     & 4.51834e-07, 4.59648e-07, 4.67598e-07, 4.75684e-07, 4.83910e-07,
     & 4.92279e-07, 5.00793e-07, 5.09453e-07, 5.18264e-07, 5.27226e-07,
     & 5.36344e-07, 5.45620e-07, 5.55055e-07, 5.64654e-07/
       DATA (KA_MN2( 8,JT, 4),JT=1,19)  /
     & 4.15352e-07, 4.24386e-07, 4.33617e-07, 4.43049e-07, 4.52685e-07,
     & 4.62532e-07, 4.72592e-07, 4.82872e-07, 4.93374e-07, 5.04106e-07,
     & 5.15071e-07, 5.26274e-07, 5.37721e-07, 5.49417e-07, 5.61367e-07,
     & 5.73577e-07, 5.86053e-07, 5.98800e-07, 6.11825e-07/
       DATA (KA_MN2( 9,JT, 4),JT=1,19)  /
     & 3.33820e-07, 3.39144e-07, 3.44553e-07, 3.50048e-07, 3.55631e-07,
     & 3.61302e-07, 3.67065e-07, 3.72919e-07, 3.78866e-07, 3.84908e-07,
     & 3.91047e-07, 3.97284e-07, 4.03620e-07, 4.10057e-07, 4.16597e-07,
     & 4.23241e-07, 4.29991e-07, 4.36849e-07, 4.43816e-07/
       DATA (KA_MN2( 1,JT, 5),JT=1,19)  /
     & 6.99819e-07, 7.04629e-07, 7.09472e-07, 7.14349e-07, 7.19258e-07,
     & 7.24202e-07, 7.29180e-07, 7.34192e-07, 7.39238e-07, 7.44319e-07,
     & 7.49435e-07, 7.54586e-07, 7.59773e-07, 7.64995e-07, 7.70253e-07,
     & 7.75547e-07, 7.80877e-07, 7.86245e-07, 7.91649e-07/
       DATA (KA_MN2( 2,JT, 5),JT=1,19)  /
     & 6.98257e-07, 7.03182e-07, 7.08143e-07, 7.13138e-07, 7.18169e-07,
     & 7.23235e-07, 7.28336e-07, 7.33474e-07, 7.38648e-07, 7.43858e-07,
     & 7.49106e-07, 7.54390e-07, 7.59711e-07, 7.65071e-07, 7.70467e-07,
     & 7.75902e-07, 7.81376e-07, 7.86887e-07, 7.92438e-07/
       DATA (KA_MN2( 3,JT, 5),JT=1,19)  /
     & 6.98531e-07, 7.03429e-07, 7.08361e-07, 7.13328e-07, 7.18329e-07,
     & 7.23365e-07, 7.28437e-07, 7.33545e-07, 7.38688e-07, 7.43867e-07,
     & 7.49082e-07, 7.54335e-07, 7.59623e-07, 7.64950e-07, 7.70313e-07,
     & 7.75714e-07, 7.81153e-07, 7.86630e-07, 7.92145e-07/
       DATA (KA_MN2( 4,JT, 5),JT=1,19)  /
     & 7.37210e-07, 7.38869e-07, 7.40532e-07, 7.42198e-07, 7.43868e-07,
     & 7.45542e-07, 7.47219e-07, 7.48901e-07, 7.50586e-07, 7.52275e-07,
     & 7.53967e-07, 7.55664e-07, 7.57364e-07, 7.59068e-07, 7.60777e-07,
     & 7.62488e-07, 7.64204e-07, 7.65924e-07, 7.67647e-07/
       DATA (KA_MN2( 5,JT, 5),JT=1,19)  /
     & 6.07063e-07, 6.12893e-07, 6.18779e-07, 6.24722e-07, 6.30721e-07,
     & 6.36778e-07, 6.42893e-07, 6.49067e-07, 6.55301e-07, 6.61594e-07,
     & 6.67947e-07, 6.74362e-07, 6.80838e-07, 6.87376e-07, 6.93978e-07,
     & 7.00642e-07, 7.07371e-07, 7.14164e-07, 7.21022e-07/
       DATA (KA_MN2( 6,JT, 5),JT=1,19)  /
     & 6.13354e-07, 6.20147e-07, 6.27016e-07, 6.33961e-07, 6.40983e-07,
     & 6.48082e-07, 6.55260e-07, 6.62518e-07, 6.69856e-07, 6.77276e-07,
     & 6.84777e-07, 6.92362e-07, 7.00030e-07, 7.07784e-07, 7.15624e-07,
     & 7.23550e-07, 7.31564e-07, 7.39667e-07, 7.47859e-07/
       DATA (KA_MN2( 7,JT, 5),JT=1,19)  /
     & 6.86666e-07, 6.92902e-07, 6.99195e-07, 7.05545e-07, 7.11952e-07,
     & 7.18418e-07, 7.24943e-07, 7.31526e-07, 7.38170e-07, 7.44874e-07,
     & 7.51639e-07, 7.58465e-07, 7.65353e-07, 7.72304e-07, 7.79318e-07,
     & 7.86395e-07, 7.93537e-07, 8.00744e-07, 8.08016e-07/
       DATA (KA_MN2( 8,JT, 5),JT=1,19)  /
     & 9.39664e-07, 9.39765e-07, 9.39866e-07, 9.39966e-07, 9.40067e-07,
     & 9.40168e-07, 9.40268e-07, 9.40369e-07, 9.40470e-07, 9.40571e-07,
     & 9.40671e-07, 9.40772e-07, 9.40873e-07, 9.40974e-07, 9.41074e-07,
     & 9.41175e-07, 9.41276e-07, 9.41377e-07, 9.41478e-07/
       DATA (KA_MN2( 9,JT, 5),JT=1,19)  /
     & 6.02847e-07, 6.09726e-07, 6.16684e-07, 6.23722e-07, 6.30839e-07,
     & 6.38038e-07, 6.45320e-07, 6.52684e-07, 6.60132e-07, 6.67665e-07,
     & 6.75284e-07, 6.82991e-07, 6.90785e-07, 6.98668e-07, 7.06641e-07,
     & 7.14705e-07, 7.22861e-07, 7.31110e-07, 7.39453e-07/
       DATA (KA_MN2( 1,JT, 6),JT=1,19)  /
     & 1.13692e-06, 1.13231e-06, 1.12772e-06, 1.12315e-06, 1.11859e-06,
     & 1.11406e-06, 1.10954e-06, 1.10505e-06, 1.10057e-06, 1.09610e-06,
     & 1.09166e-06, 1.08724e-06, 1.08283e-06, 1.07844e-06, 1.07407e-06,
     & 1.06971e-06, 1.06538e-06, 1.06106e-06, 1.05676e-06/
       DATA (KA_MN2( 2,JT, 6),JT=1,19)  /
     & 1.13682e-06, 1.13221e-06, 1.12762e-06, 1.12305e-06, 1.11849e-06,
     & 1.11396e-06, 1.10944e-06, 1.10495e-06, 1.10047e-06, 1.09600e-06,
     & 1.09156e-06, 1.08714e-06, 1.08273e-06, 1.07834e-06, 1.07397e-06,
     & 1.06961e-06, 1.06528e-06, 1.06096e-06, 1.05666e-06/
       DATA (KA_MN2( 3,JT, 6),JT=1,19)  /
     & 1.13642e-06, 1.13181e-06, 1.12722e-06, 1.12265e-06, 1.11809e-06,
     & 1.11356e-06, 1.10904e-06, 1.10455e-06, 1.10007e-06, 1.09560e-06,
     & 1.09116e-06, 1.08674e-06, 1.08233e-06, 1.07794e-06, 1.07357e-06,
     & 1.06921e-06, 1.06488e-06, 1.06056e-06, 1.05626e-06/
       DATA (KA_MN2( 4,JT, 6),JT=1,19)  /
     & 1.13626e-06, 1.13160e-06, 1.12696e-06, 1.12233e-06, 1.11773e-06,
     & 1.11314e-06, 1.10858e-06, 1.10403e-06, 1.09950e-06, 1.09498e-06,
     & 1.09049e-06, 1.08602e-06, 1.08156e-06, 1.07712e-06, 1.07270e-06,
     & 1.06830e-06, 1.06392e-06, 1.05955e-06, 1.05520e-06/
       DATA (KA_MN2( 5,JT, 6),JT=1,19)  /
     & 1.22429e-06, 1.21163e-06, 1.19909e-06, 1.18669e-06, 1.17441e-06,
     & 1.16226e-06, 1.15024e-06, 1.13834e-06, 1.12656e-06, 1.11491e-06,
     & 1.10338e-06, 1.09196e-06, 1.08067e-06, 1.06949e-06, 1.05842e-06,
     & 1.04747e-06, 1.03664e-06, 1.02591e-06, 1.01530e-06/
       DATA (KA_MN2( 6,JT, 6),JT=1,19)  /
     & 1.02400e-06, 1.02238e-06, 1.02077e-06, 1.01916e-06, 1.01755e-06,
     & 1.01594e-06, 1.01433e-06, 1.01273e-06, 1.01113e-06, 1.00953e-06,
     & 1.00794e-06, 1.00635e-06, 1.00476e-06, 1.00317e-06, 1.00159e-06,
     & 1.00000e-06, 9.98425e-07, 9.96848e-07, 9.95273e-07/
       DATA (KA_MN2( 7,JT, 6),JT=1,19)  /
     & 1.08594e-06, 1.08185e-06, 1.07778e-06, 1.07373e-06, 1.06969e-06,
     & 1.06566e-06, 1.06165e-06, 1.05766e-06, 1.05368e-06, 1.04971e-06,
     & 1.04576e-06, 1.04183e-06, 1.03791e-06, 1.03400e-06, 1.03011e-06,
     & 1.02623e-06, 1.02237e-06, 1.01852e-06, 1.01469e-06/
       DATA (KA_MN2( 8,JT, 6),JT=1,19)  /
     & 1.25029e-06, 1.22508e-06, 1.20038e-06, 1.17618e-06, 1.15247e-06,
     & 1.12924e-06, 1.10647e-06, 1.08416e-06, 1.06231e-06, 1.04089e-06,
     & 1.01990e-06, 9.99343e-07, 9.79196e-07, 9.59454e-07, 9.40111e-07,
     & 9.21158e-07, 9.02587e-07, 8.84390e-07, 8.66560e-07/
       DATA (KA_MN2( 9,JT, 6),JT=1,19)  /
     & 1.21299e-06, 1.19953e-06, 1.18622e-06, 1.17305e-06, 1.16003e-06,
     & 1.14716e-06, 1.13443e-06, 1.12184e-06, 1.10939e-06, 1.09708e-06,
     & 1.08491e-06, 1.07287e-06, 1.06096e-06, 1.04919e-06, 1.03755e-06,
     & 1.02603e-06, 1.01465e-06, 1.00339e-06, 9.92253e-07/
       DATA (KA_MN2( 1,JT, 7),JT=1,19)  /
     & 1.53893e-06, 1.51743e-06, 1.49623e-06, 1.47532e-06, 1.45471e-06,
     & 1.43438e-06, 1.41434e-06, 1.39458e-06, 1.37509e-06, 1.35588e-06,
     & 1.33694e-06, 1.31826e-06, 1.29984e-06, 1.28167e-06, 1.26377e-06,
     & 1.24611e-06, 1.22870e-06, 1.21153e-06, 1.19460e-06/
       DATA (KA_MN2( 2,JT, 7),JT=1,19)  /
     & 1.53809e-06, 1.51665e-06, 1.49552e-06, 1.47467e-06, 1.45412e-06,
     & 1.43386e-06, 1.41388e-06, 1.39418e-06, 1.37475e-06, 1.35559e-06,
     & 1.33670e-06, 1.31807e-06, 1.29970e-06, 1.28159e-06, 1.26373e-06,
     & 1.24612e-06, 1.22875e-06, 1.21163e-06, 1.19475e-06/
       DATA (KA_MN2( 3,JT, 7),JT=1,19)  /
     & 1.53883e-06, 1.51733e-06, 1.49613e-06, 1.47522e-06, 1.45461e-06,
     & 1.43428e-06, 1.41424e-06, 1.39448e-06, 1.37499e-06, 1.35578e-06,
     & 1.33684e-06, 1.31816e-06, 1.29974e-06, 1.28157e-06, 1.26367e-06,
     & 1.24601e-06, 1.22860e-06, 1.21143e-06, 1.19450e-06/
       DATA (KA_MN2( 4,JT, 7),JT=1,19)  /
     & 1.53789e-06, 1.51645e-06, 1.49532e-06, 1.47448e-06, 1.45393e-06,
     & 1.43366e-06, 1.41368e-06, 1.39398e-06, 1.37455e-06, 1.35539e-06,
     & 1.33650e-06, 1.31787e-06, 1.29950e-06, 1.28139e-06, 1.26353e-06,
     & 1.24592e-06, 1.22856e-06, 1.21143e-06, 1.19455e-06/
       DATA (KA_MN2( 5,JT, 7),JT=1,19)  /
     & 1.54059e-06, 1.51888e-06, 1.49747e-06, 1.47637e-06, 1.45557e-06,
     & 1.43505e-06, 1.41483e-06, 1.39489e-06, 1.37523e-06, 1.35585e-06,
     & 1.33675e-06, 1.31791e-06, 1.29934e-06, 1.28103e-06, 1.26297e-06,
     & 1.24517e-06, 1.22763e-06, 1.21033e-06, 1.19327e-06/
       DATA (KA_MN2( 6,JT, 7),JT=1,19)  /
     & 1.70605e-06, 1.65759e-06, 1.61052e-06, 1.56478e-06, 1.52034e-06,
     & 1.47716e-06, 1.43521e-06, 1.39445e-06, 1.35485e-06, 1.31637e-06,
     & 1.27898e-06, 1.24266e-06, 1.20737e-06, 1.17308e-06, 1.13976e-06,
     & 1.10739e-06, 1.07594e-06, 1.04539e-06, 1.01570e-06/
       DATA (KA_MN2( 7,JT, 7),JT=1,19)  /
     & 1.39128e-06, 1.36388e-06, 1.33702e-06, 1.31068e-06, 1.28487e-06,
     & 1.25956e-06, 1.23475e-06, 1.21044e-06, 1.18659e-06, 1.16322e-06,
     & 1.14031e-06, 1.11785e-06, 1.09584e-06, 1.07425e-06, 1.05309e-06,
     & 1.03235e-06, 1.01202e-06, 9.92088e-07, 9.72548e-07/
       DATA (KA_MN2( 8,JT, 7),JT=1,19)  /
     & 1.15676e-06, 1.13709e-06, 1.11775e-06, 1.09874e-06, 1.08005e-06,
     & 1.06168e-06, 1.04362e-06, 1.02587e-06, 1.00842e-06, 9.91271e-07,
     & 9.74411e-07, 9.57838e-07, 9.41547e-07, 9.25532e-07, 9.09791e-07,
     & 8.94316e-07, 8.79105e-07, 8.64153e-07, 8.49455e-07/
       DATA (KA_MN2( 9,JT, 7),JT=1,19)  /
     & 1.53483e-06, 1.51352e-06, 1.49252e-06, 1.47180e-06, 1.45138e-06,
     & 1.43123e-06, 1.41137e-06, 1.39178e-06, 1.37246e-06, 1.35341e-06,
     & 1.33463e-06, 1.31610e-06, 1.29784e-06, 1.27982e-06, 1.26206e-06,
     & 1.24454e-06, 1.22727e-06, 1.21024e-06, 1.19344e-06/
       DATA (KA_MN2( 1,JT, 8),JT=1,19)  /
     & 1.70380e-06, 1.67470e-06, 1.64609e-06, 1.61796e-06, 1.59032e-06,
     & 1.56315e-06, 1.53645e-06, 1.51020e-06, 1.48440e-06, 1.45904e-06,
     & 1.43411e-06, 1.40961e-06, 1.38553e-06, 1.36186e-06, 1.33859e-06,
     & 1.31572e-06, 1.29324e-06, 1.27115e-06, 1.24943e-06/
       DATA (KA_MN2( 2,JT, 8),JT=1,19)  /
     & 1.70380e-06, 1.67470e-06, 1.64609e-06, 1.61796e-06, 1.59032e-06,
     & 1.56315e-06, 1.53645e-06, 1.51020e-06, 1.48440e-06, 1.45904e-06,
     & 1.43411e-06, 1.40961e-06, 1.38553e-06, 1.36186e-06, 1.33859e-06,
     & 1.31572e-06, 1.29324e-06, 1.27115e-06, 1.24943e-06/
       DATA (KA_MN2( 3,JT, 8),JT=1,19)  /
     & 1.70380e-06, 1.67470e-06, 1.64609e-06, 1.61796e-06, 1.59032e-06,
     & 1.56315e-06, 1.53645e-06, 1.51020e-06, 1.48440e-06, 1.45904e-06,
     & 1.43411e-06, 1.40961e-06, 1.38553e-06, 1.36186e-06, 1.33859e-06,
     & 1.31572e-06, 1.29324e-06, 1.27115e-06, 1.24943e-06/
       DATA (KA_MN2( 4,JT, 8),JT=1,19)  /
     & 1.70380e-06, 1.67470e-06, 1.64609e-06, 1.61796e-06, 1.59032e-06,
     & 1.56315e-06, 1.53645e-06, 1.51020e-06, 1.48440e-06, 1.45904e-06,
     & 1.43411e-06, 1.40961e-06, 1.38553e-06, 1.36186e-06, 1.33859e-06,
     & 1.31572e-06, 1.29324e-06, 1.27115e-06, 1.24943e-06/
       DATA (KA_MN2( 5,JT, 8),JT=1,19)  /
     & 1.70380e-06, 1.67470e-06, 1.64609e-06, 1.61796e-06, 1.59032e-06,
     & 1.56315e-06, 1.53645e-06, 1.51020e-06, 1.48440e-06, 1.45904e-06,
     & 1.43411e-06, 1.40961e-06, 1.38553e-06, 1.36186e-06, 1.33859e-06,
     & 1.31572e-06, 1.29324e-06, 1.27115e-06, 1.24943e-06/
       DATA (KA_MN2( 6,JT, 8),JT=1,19)  /
     & 1.70380e-06, 1.67470e-06, 1.64609e-06, 1.61796e-06, 1.59032e-06,
     & 1.56315e-06, 1.53645e-06, 1.51020e-06, 1.48440e-06, 1.45904e-06,
     & 1.43411e-06, 1.40961e-06, 1.38553e-06, 1.36186e-06, 1.33859e-06,
     & 1.31572e-06, 1.29324e-06, 1.27115e-06, 1.24943e-06/
       DATA (KA_MN2( 7,JT, 8),JT=1,19)  /
     & 1.71827e-06, 1.65481e-06, 1.59370e-06, 1.53484e-06, 1.47816e-06,
     & 1.42357e-06, 1.37099e-06, 1.32036e-06, 1.27160e-06, 1.22464e-06,
     & 1.17941e-06, 1.13585e-06, 1.09390e-06, 1.05350e-06, 1.01459e-06,
     & 9.77124e-07, 9.41037e-07, 9.06284e-07, 8.72813e-07/
       DATA (KA_MN2( 8,JT, 8),JT=1,19)  /
     & 1.77169e-06, 1.62858e-06, 1.49703e-06, 1.37610e-06, 1.26494e-06,
     & 1.16276e-06, 1.06883e-06, 9.82495e-07, 9.03131e-07, 8.30177e-07,
     & 7.63117e-07, 7.01473e-07, 6.44810e-07, 5.92723e-07, 5.44844e-07,
     & 5.00832e-07, 4.60376e-07, 4.23187e-07, 3.89003e-07/
       DATA (KA_MN2( 9,JT, 8),JT=1,19)  /
     & 1.70025e-06, 1.67042e-06, 1.64110e-06, 1.61231e-06, 1.58401e-06,
     & 1.55622e-06, 1.52891e-06, 1.50208e-06, 1.47572e-06, 1.44982e-06,
     & 1.42438e-06, 1.39939e-06, 1.37483e-06, 1.35071e-06, 1.32700e-06,
     & 1.30372e-06, 1.28084e-06, 1.25836e-06, 1.23628e-06/
       DATA (KA_MN2( 1,JT, 9),JT=1,19)  /
     & 1.74004e-06, 1.70661e-06, 1.67383e-06, 1.64167e-06, 1.61014e-06,
     & 1.57921e-06, 1.54887e-06, 1.51912e-06, 1.48994e-06, 1.46132e-06,
     & 1.43325e-06, 1.40572e-06, 1.37871e-06, 1.35223e-06, 1.32625e-06,
     & 1.30078e-06, 1.27579e-06, 1.25128e-06, 1.22725e-06/
       DATA (KA_MN2( 2,JT, 9),JT=1,19)  /
     & 1.74004e-06, 1.70661e-06, 1.67383e-06, 1.64167e-06, 1.61014e-06,
     & 1.57921e-06, 1.54887e-06, 1.51912e-06, 1.48994e-06, 1.46132e-06,
     & 1.43325e-06, 1.40572e-06, 1.37871e-06, 1.35223e-06, 1.32625e-06,
     & 1.30078e-06, 1.27579e-06, 1.25128e-06, 1.22725e-06/
       DATA (KA_MN2( 3,JT, 9),JT=1,19)  /
     & 1.74004e-06, 1.70661e-06, 1.67383e-06, 1.64167e-06, 1.61014e-06,
     & 1.57921e-06, 1.54887e-06, 1.51912e-06, 1.48994e-06, 1.46132e-06,
     & 1.43325e-06, 1.40572e-06, 1.37871e-06, 1.35223e-06, 1.32625e-06,
     & 1.30078e-06, 1.27579e-06, 1.25128e-06, 1.22725e-06/
       DATA (KA_MN2( 4,JT, 9),JT=1,19)  /
     & 1.74004e-06, 1.70661e-06, 1.67383e-06, 1.64167e-06, 1.61014e-06,
     & 1.57921e-06, 1.54887e-06, 1.51912e-06, 1.48994e-06, 1.46132e-06,
     & 1.43325e-06, 1.40572e-06, 1.37871e-06, 1.35223e-06, 1.32625e-06,
     & 1.30078e-06, 1.27579e-06, 1.25128e-06, 1.22725e-06/
       DATA (KA_MN2( 5,JT, 9),JT=1,19)  /
     & 1.74004e-06, 1.70661e-06, 1.67383e-06, 1.64167e-06, 1.61014e-06,
     & 1.57921e-06, 1.54887e-06, 1.51912e-06, 1.48994e-06, 1.46132e-06,
     & 1.43325e-06, 1.40572e-06, 1.37871e-06, 1.35223e-06, 1.32625e-06,
     & 1.30078e-06, 1.27579e-06, 1.25128e-06, 1.22725e-06/
       DATA (KA_MN2( 6,JT, 9),JT=1,19)  /
     & 1.74004e-06, 1.70661e-06, 1.67383e-06, 1.64167e-06, 1.61014e-06,
     & 1.57921e-06, 1.54887e-06, 1.51912e-06, 1.48994e-06, 1.46132e-06,
     & 1.43325e-06, 1.40572e-06, 1.37871e-06, 1.35223e-06, 1.32625e-06,
     & 1.30078e-06, 1.27579e-06, 1.25128e-06, 1.22725e-06/
       DATA (KA_MN2( 7,JT, 9),JT=1,19)  /
     & 1.74004e-06, 1.70661e-06, 1.67383e-06, 1.64167e-06, 1.61014e-06,
     & 1.57921e-06, 1.54887e-06, 1.51912e-06, 1.48994e-06, 1.46132e-06,
     & 1.43325e-06, 1.40572e-06, 1.37871e-06, 1.35223e-06, 1.32625e-06,
     & 1.30078e-06, 1.27579e-06, 1.25128e-06, 1.22725e-06/
       DATA (KA_MN2( 8,JT, 9),JT=1,19)  /
     & 1.08654e-06, 1.09039e-06, 1.09425e-06, 1.09812e-06, 1.10201e-06,
     & 1.10592e-06, 1.10983e-06, 1.11376e-06, 1.11771e-06, 1.12167e-06,
     & 1.12564e-06, 1.12962e-06, 1.13363e-06, 1.13764e-06, 1.14167e-06,
     & 1.14571e-06, 1.14977e-06, 1.15384e-06, 1.15793e-06/
       DATA (KA_MN2( 9,JT, 9),JT=1,19)  /
     & 1.74382e-06, 1.71092e-06, 1.67864e-06, 1.64697e-06, 1.61589e-06,
     & 1.58541e-06, 1.55549e-06, 1.52615e-06, 1.49735e-06, 1.46910e-06,
     & 1.44138e-06, 1.41419e-06, 1.38751e-06, 1.36133e-06, 1.33564e-06,
     & 1.31045e-06, 1.28572e-06, 1.26146e-06, 1.23766e-06/
       DATA (KA_MN2( 1,JT,10),JT=1,19)  /
     & 1.73703e-06, 1.70249e-06, 1.66863e-06, 1.63544e-06, 1.60292e-06,
     & 1.57104e-06, 1.53980e-06, 1.50917e-06, 1.47916e-06, 1.44974e-06,
     & 1.42091e-06, 1.39265e-06, 1.36496e-06, 1.33781e-06, 1.31121e-06,
     & 1.28513e-06, 1.25957e-06, 1.23452e-06, 1.20997e-06/
       DATA (KA_MN2( 2,JT,10),JT=1,19)  /
     & 1.73703e-06, 1.70249e-06, 1.66863e-06, 1.63544e-06, 1.60292e-06,
     & 1.57104e-06, 1.53980e-06, 1.50917e-06, 1.47916e-06, 1.44974e-06,
     & 1.42091e-06, 1.39265e-06, 1.36496e-06, 1.33781e-06, 1.31121e-06,
     & 1.28513e-06, 1.25957e-06, 1.23452e-06, 1.20997e-06/
       DATA (KA_MN2( 3,JT,10),JT=1,19)  /
     & 1.73703e-06, 1.70249e-06, 1.66863e-06, 1.63544e-06, 1.60292e-06,
     & 1.57104e-06, 1.53980e-06, 1.50917e-06, 1.47916e-06, 1.44974e-06,
     & 1.42091e-06, 1.39265e-06, 1.36496e-06, 1.33781e-06, 1.31121e-06,
     & 1.28513e-06, 1.25957e-06, 1.23452e-06, 1.20997e-06/
       DATA (KA_MN2( 4,JT,10),JT=1,19)  /
     & 1.73703e-06, 1.70249e-06, 1.66863e-06, 1.63544e-06, 1.60292e-06,
     & 1.57104e-06, 1.53980e-06, 1.50917e-06, 1.47916e-06, 1.44974e-06,
     & 1.42091e-06, 1.39265e-06, 1.36496e-06, 1.33781e-06, 1.31121e-06,
     & 1.28513e-06, 1.25957e-06, 1.23452e-06, 1.20997e-06/
       DATA (KA_MN2( 5,JT,10),JT=1,19)  /
     & 1.73703e-06, 1.70249e-06, 1.66863e-06, 1.63544e-06, 1.60292e-06,
     & 1.57104e-06, 1.53980e-06, 1.50917e-06, 1.47916e-06, 1.44974e-06,
     & 1.42091e-06, 1.39265e-06, 1.36496e-06, 1.33781e-06, 1.31121e-06,
     & 1.28513e-06, 1.25957e-06, 1.23452e-06, 1.20997e-06/
       DATA (KA_MN2( 6,JT,10),JT=1,19)  /
     & 1.73703e-06, 1.70249e-06, 1.66863e-06, 1.63544e-06, 1.60292e-06,
     & 1.57104e-06, 1.53980e-06, 1.50917e-06, 1.47916e-06, 1.44974e-06,
     & 1.42091e-06, 1.39265e-06, 1.36496e-06, 1.33781e-06, 1.31121e-06,
     & 1.28513e-06, 1.25957e-06, 1.23452e-06, 1.20997e-06/
       DATA (KA_MN2( 7,JT,10),JT=1,19)  /
     & 1.73703e-06, 1.70249e-06, 1.66863e-06, 1.63544e-06, 1.60292e-06,
     & 1.57104e-06, 1.53980e-06, 1.50917e-06, 1.47916e-06, 1.44974e-06,
     & 1.42091e-06, 1.39265e-06, 1.36496e-06, 1.33781e-06, 1.31121e-06,
     & 1.28513e-06, 1.25957e-06, 1.23452e-06, 1.20997e-06/
       DATA (KA_MN2( 8,JT,10),JT=1,19)  /
     & 1.73703e-06, 1.70249e-06, 1.66863e-06, 1.63544e-06, 1.60292e-06,
     & 1.57104e-06, 1.53980e-06, 1.50917e-06, 1.47916e-06, 1.44974e-06,
     & 1.42091e-06, 1.39265e-06, 1.36496e-06, 1.33781e-06, 1.31121e-06,
     & 1.28513e-06, 1.25957e-06, 1.23452e-06, 1.20997e-06/
       DATA (KA_MN2( 9,JT,10),JT=1,19)  /
     & 1.82903e-06, 1.78673e-06, 1.74541e-06, 1.70505e-06, 1.66562e-06,
     & 1.62710e-06, 1.58947e-06, 1.55271e-06, 1.51680e-06, 1.48172e-06,
     & 1.44745e-06, 1.41398e-06, 1.38128e-06, 1.34933e-06, 1.31813e-06,
     & 1.28765e-06, 1.25787e-06, 1.22878e-06, 1.20036e-06/
       DATA (KA_MN2( 1,JT,11),JT=1,19)  /
     & 1.73118e-06, 1.69710e-06, 1.66370e-06, 1.63095e-06, 1.59885e-06,
     & 1.56737e-06, 1.53652e-06, 1.50628e-06, 1.47663e-06, 1.44756e-06,
     & 1.41907e-06, 1.39114e-06, 1.36376e-06, 1.33691e-06, 1.31060e-06,
     & 1.28480e-06, 1.25951e-06, 1.23472e-06, 1.21041e-06/
       DATA (KA_MN2( 2,JT,11),JT=1,19)  /
     & 1.73118e-06, 1.69710e-06, 1.66370e-06, 1.63095e-06, 1.59885e-06,
     & 1.56737e-06, 1.53652e-06, 1.50628e-06, 1.47663e-06, 1.44756e-06,
     & 1.41907e-06, 1.39114e-06, 1.36376e-06, 1.33691e-06, 1.31060e-06,
     & 1.28480e-06, 1.25951e-06, 1.23472e-06, 1.21041e-06/
       DATA (KA_MN2( 3,JT,11),JT=1,19)  /
     & 1.73118e-06, 1.69710e-06, 1.66370e-06, 1.63095e-06, 1.59885e-06,
     & 1.56737e-06, 1.53652e-06, 1.50628e-06, 1.47663e-06, 1.44756e-06,
     & 1.41907e-06, 1.39114e-06, 1.36376e-06, 1.33691e-06, 1.31060e-06,
     & 1.28480e-06, 1.25951e-06, 1.23472e-06, 1.21041e-06/
       DATA (KA_MN2( 4,JT,11),JT=1,19)  /
     & 1.73118e-06, 1.69710e-06, 1.66370e-06, 1.63095e-06, 1.59885e-06,
     & 1.56737e-06, 1.53652e-06, 1.50628e-06, 1.47663e-06, 1.44756e-06,
     & 1.41907e-06, 1.39114e-06, 1.36376e-06, 1.33691e-06, 1.31060e-06,
     & 1.28480e-06, 1.25951e-06, 1.23472e-06, 1.21041e-06/
       DATA (KA_MN2( 5,JT,11),JT=1,19)  /
     & 1.73118e-06, 1.69710e-06, 1.66370e-06, 1.63095e-06, 1.59885e-06,
     & 1.56737e-06, 1.53652e-06, 1.50628e-06, 1.47663e-06, 1.44756e-06,
     & 1.41907e-06, 1.39114e-06, 1.36376e-06, 1.33691e-06, 1.31060e-06,
     & 1.28480e-06, 1.25951e-06, 1.23472e-06, 1.21041e-06/
       DATA (KA_MN2( 6,JT,11),JT=1,19)  /
     & 1.73118e-06, 1.69710e-06, 1.66370e-06, 1.63095e-06, 1.59885e-06,
     & 1.56737e-06, 1.53652e-06, 1.50628e-06, 1.47663e-06, 1.44756e-06,
     & 1.41907e-06, 1.39114e-06, 1.36376e-06, 1.33691e-06, 1.31060e-06,
     & 1.28480e-06, 1.25951e-06, 1.23472e-06, 1.21041e-06/
       DATA (KA_MN2( 7,JT,11),JT=1,19)  /
     & 1.73118e-06, 1.69710e-06, 1.66370e-06, 1.63095e-06, 1.59885e-06,
     & 1.56737e-06, 1.53652e-06, 1.50628e-06, 1.47663e-06, 1.44756e-06,
     & 1.41907e-06, 1.39114e-06, 1.36376e-06, 1.33691e-06, 1.31060e-06,
     & 1.28480e-06, 1.25951e-06, 1.23472e-06, 1.21041e-06/
       DATA (KA_MN2( 8,JT,11),JT=1,19)  /
     & 1.73118e-06, 1.69710e-06, 1.66370e-06, 1.63095e-06, 1.59885e-06,
     & 1.56737e-06, 1.53652e-06, 1.50628e-06, 1.47663e-06, 1.44756e-06,
     & 1.41907e-06, 1.39114e-06, 1.36376e-06, 1.33691e-06, 1.31060e-06,
     & 1.28480e-06, 1.25951e-06, 1.23472e-06, 1.21041e-06/
       DATA (KA_MN2( 9,JT,11),JT=1,19)  /
     & 1.81037e-06, 1.76948e-06, 1.72952e-06, 1.69045e-06, 1.65228e-06,
     & 1.61496e-06, 1.57848e-06, 1.54283e-06, 1.50799e-06, 1.47393e-06,
     & 1.44064e-06, 1.40810e-06, 1.37630e-06, 1.34522e-06, 1.31484e-06,
     & 1.28514e-06, 1.25611e-06, 1.22774e-06, 1.20002e-06/
       DATA (KA_MN2( 1,JT,12),JT=1,19)  /
     & 1.73338e-06, 1.69915e-06, 1.66560e-06, 1.63271e-06, 1.60046e-06,
     & 1.56886e-06, 1.53788e-06, 1.50751e-06, 1.47774e-06, 1.44856e-06,
     & 1.41995e-06, 1.39191e-06, 1.36442e-06, 1.33748e-06, 1.31107e-06,
     & 1.28518e-06, 1.25980e-06, 1.23492e-06, 1.21053e-06/
       DATA (KA_MN2( 2,JT,12),JT=1,19)  /
     & 1.73338e-06, 1.69915e-06, 1.66560e-06, 1.63271e-06, 1.60046e-06,
     & 1.56886e-06, 1.53788e-06, 1.50751e-06, 1.47774e-06, 1.44856e-06,
     & 1.41995e-06, 1.39191e-06, 1.36442e-06, 1.33748e-06, 1.31107e-06,
     & 1.28518e-06, 1.25980e-06, 1.23492e-06, 1.21053e-06/
       DATA (KA_MN2( 3,JT,12),JT=1,19)  /
     & 1.73338e-06, 1.69915e-06, 1.66560e-06, 1.63271e-06, 1.60046e-06,
     & 1.56886e-06, 1.53788e-06, 1.50751e-06, 1.47774e-06, 1.44856e-06,
     & 1.41995e-06, 1.39191e-06, 1.36442e-06, 1.33748e-06, 1.31107e-06,
     & 1.28518e-06, 1.25980e-06, 1.23492e-06, 1.21053e-06/
       DATA (KA_MN2( 4,JT,12),JT=1,19)  /
     & 1.73338e-06, 1.69915e-06, 1.66560e-06, 1.63271e-06, 1.60046e-06,
     & 1.56886e-06, 1.53788e-06, 1.50751e-06, 1.47774e-06, 1.44856e-06,
     & 1.41995e-06, 1.39191e-06, 1.36442e-06, 1.33748e-06, 1.31107e-06,
     & 1.28518e-06, 1.25980e-06, 1.23492e-06, 1.21053e-06/
       DATA (KA_MN2( 5,JT,12),JT=1,19)  /
     & 1.73338e-06, 1.69915e-06, 1.66560e-06, 1.63271e-06, 1.60046e-06,
     & 1.56886e-06, 1.53788e-06, 1.50751e-06, 1.47774e-06, 1.44856e-06,
     & 1.41995e-06, 1.39191e-06, 1.36442e-06, 1.33748e-06, 1.31107e-06,
     & 1.28518e-06, 1.25980e-06, 1.23492e-06, 1.21053e-06/
       DATA (KA_MN2( 6,JT,12),JT=1,19)  /
     & 1.73338e-06, 1.69915e-06, 1.66560e-06, 1.63271e-06, 1.60046e-06,
     & 1.56886e-06, 1.53788e-06, 1.50751e-06, 1.47774e-06, 1.44856e-06,
     & 1.41995e-06, 1.39191e-06, 1.36442e-06, 1.33748e-06, 1.31107e-06,
     & 1.28518e-06, 1.25980e-06, 1.23492e-06, 1.21053e-06/
       DATA (KA_MN2( 7,JT,12),JT=1,19)  /
     & 1.73338e-06, 1.69915e-06, 1.66560e-06, 1.63271e-06, 1.60046e-06,
     & 1.56886e-06, 1.53788e-06, 1.50751e-06, 1.47774e-06, 1.44856e-06,
     & 1.41995e-06, 1.39191e-06, 1.36442e-06, 1.33748e-06, 1.31107e-06,
     & 1.28518e-06, 1.25980e-06, 1.23492e-06, 1.21053e-06/
       DATA (KA_MN2( 8,JT,12),JT=1,19)  /
     & 1.73338e-06, 1.69915e-06, 1.66560e-06, 1.63271e-06, 1.60046e-06,
     & 1.56886e-06, 1.53788e-06, 1.50751e-06, 1.47774e-06, 1.44856e-06,
     & 1.41995e-06, 1.39191e-06, 1.36442e-06, 1.33748e-06, 1.31107e-06,
     & 1.28518e-06, 1.25980e-06, 1.23492e-06, 1.21053e-06/
       DATA (KA_MN2( 9,JT,12),JT=1,19)  /
     & 2.04857e-06, 1.98353e-06, 1.92055e-06, 1.85957e-06, 1.80053e-06,
     & 1.74336e-06, 1.68800e-06, 1.63441e-06, 1.58251e-06, 1.53227e-06,
     & 1.48362e-06, 1.43651e-06, 1.39090e-06, 1.34674e-06, 1.30398e-06,
     & 1.26257e-06, 1.22249e-06, 1.18367e-06, 1.14609e-06/
       DATA (KA_MN2( 1,JT,13),JT=1,19)  /
     & 1.73511e-06, 1.70072e-06, 1.66702e-06, 1.63398e-06, 1.60159e-06,
     & 1.56985e-06, 1.53874e-06, 1.50824e-06, 1.47835e-06, 1.44905e-06,
     & 1.42033e-06, 1.39218e-06, 1.36459e-06, 1.33755e-06, 1.31104e-06,
     & 1.28505e-06, 1.25958e-06, 1.23462e-06, 1.21015e-06/
       DATA (KA_MN2( 2,JT,13),JT=1,19)  /
     & 1.73511e-06, 1.70072e-06, 1.66702e-06, 1.63398e-06, 1.60159e-06,
     & 1.56985e-06, 1.53874e-06, 1.50824e-06, 1.47835e-06, 1.44905e-06,
     & 1.42033e-06, 1.39218e-06, 1.36459e-06, 1.33755e-06, 1.31104e-06,
     & 1.28505e-06, 1.25958e-06, 1.23462e-06, 1.21015e-06/
       DATA (KA_MN2( 3,JT,13),JT=1,19)  /
     & 1.73511e-06, 1.70072e-06, 1.66702e-06, 1.63398e-06, 1.60159e-06,
     & 1.56985e-06, 1.53874e-06, 1.50824e-06, 1.47835e-06, 1.44905e-06,
     & 1.42033e-06, 1.39218e-06, 1.36459e-06, 1.33755e-06, 1.31104e-06,
     & 1.28505e-06, 1.25958e-06, 1.23462e-06, 1.21015e-06/
       DATA (KA_MN2( 4,JT,13),JT=1,19)  /
     & 1.73511e-06, 1.70072e-06, 1.66702e-06, 1.63398e-06, 1.60159e-06,
     & 1.56985e-06, 1.53874e-06, 1.50824e-06, 1.47835e-06, 1.44905e-06,
     & 1.42033e-06, 1.39218e-06, 1.36459e-06, 1.33755e-06, 1.31104e-06,
     & 1.28505e-06, 1.25958e-06, 1.23462e-06, 1.21015e-06/
       DATA (KA_MN2( 5,JT,13),JT=1,19)  /
     & 1.73511e-06, 1.70072e-06, 1.66702e-06, 1.63398e-06, 1.60159e-06,
     & 1.56985e-06, 1.53874e-06, 1.50824e-06, 1.47835e-06, 1.44905e-06,
     & 1.42033e-06, 1.39218e-06, 1.36459e-06, 1.33755e-06, 1.31104e-06,
     & 1.28505e-06, 1.25958e-06, 1.23462e-06, 1.21015e-06/
       DATA (KA_MN2( 6,JT,13),JT=1,19)  /
     & 1.73511e-06, 1.70072e-06, 1.66702e-06, 1.63398e-06, 1.60159e-06,
     & 1.56985e-06, 1.53874e-06, 1.50824e-06, 1.47835e-06, 1.44905e-06,
     & 1.42033e-06, 1.39218e-06, 1.36459e-06, 1.33755e-06, 1.31104e-06,
     & 1.28505e-06, 1.25958e-06, 1.23462e-06, 1.21015e-06/
       DATA (KA_MN2( 7,JT,13),JT=1,19)  /
     & 1.73511e-06, 1.70072e-06, 1.66702e-06, 1.63398e-06, 1.60159e-06,
     & 1.56985e-06, 1.53874e-06, 1.50824e-06, 1.47835e-06, 1.44905e-06,
     & 1.42033e-06, 1.39218e-06, 1.36459e-06, 1.33755e-06, 1.31104e-06,
     & 1.28505e-06, 1.25958e-06, 1.23462e-06, 1.21015e-06/
       DATA (KA_MN2( 8,JT,13),JT=1,19)  /
     & 1.73511e-06, 1.70072e-06, 1.66702e-06, 1.63398e-06, 1.60159e-06,
     & 1.56985e-06, 1.53874e-06, 1.50824e-06, 1.47835e-06, 1.44905e-06,
     & 1.42033e-06, 1.39218e-06, 1.36459e-06, 1.33755e-06, 1.31104e-06,
     & 1.28505e-06, 1.25958e-06, 1.23462e-06, 1.21015e-06/
       DATA (KA_MN2( 9,JT,13),JT=1,19)  /
     & 2.13403e-06, 2.05906e-06, 1.98673e-06, 1.91694e-06, 1.84961e-06,
     & 1.78463e-06, 1.72194e-06, 1.66145e-06, 1.60309e-06, 1.54678e-06,
     & 1.49244e-06, 1.44002e-06, 1.38943e-06, 1.34062e-06, 1.29353e-06,
     & 1.24809e-06, 1.20425e-06, 1.16195e-06, 1.12113e-06/
       DATA (KA_MN2( 1,JT,14),JT=1,19)  /
     & 1.73398e-06, 1.69941e-06, 1.66553e-06, 1.63233e-06, 1.59979e-06,
     & 1.56790e-06, 1.53664e-06, 1.50601e-06, 1.47598e-06, 1.44656e-06,
     & 1.41772e-06, 1.38946e-06, 1.36176e-06, 1.33461e-06, 1.30801e-06,
     & 1.28193e-06, 1.25637e-06, 1.23133e-06, 1.20678e-06/
       DATA (KA_MN2( 2,JT,14),JT=1,19)  /
     & 1.73398e-06, 1.69941e-06, 1.66553e-06, 1.63233e-06, 1.59979e-06,
     & 1.56790e-06, 1.53664e-06, 1.50601e-06, 1.47598e-06, 1.44656e-06,
     & 1.41772e-06, 1.38946e-06, 1.36176e-06, 1.33461e-06, 1.30801e-06,
     & 1.28193e-06, 1.25637e-06, 1.23133e-06, 1.20678e-06/
       DATA (KA_MN2( 3,JT,14),JT=1,19)  /
     & 1.73398e-06, 1.69941e-06, 1.66553e-06, 1.63233e-06, 1.59979e-06,
     & 1.56790e-06, 1.53664e-06, 1.50601e-06, 1.47598e-06, 1.44656e-06,
     & 1.41772e-06, 1.38946e-06, 1.36176e-06, 1.33461e-06, 1.30801e-06,
     & 1.28193e-06, 1.25637e-06, 1.23133e-06, 1.20678e-06/
       DATA (KA_MN2( 4,JT,14),JT=1,19)  /
     & 1.73398e-06, 1.69941e-06, 1.66553e-06, 1.63233e-06, 1.59979e-06,
     & 1.56790e-06, 1.53664e-06, 1.50601e-06, 1.47598e-06, 1.44656e-06,
     & 1.41772e-06, 1.38946e-06, 1.36176e-06, 1.33461e-06, 1.30801e-06,
     & 1.28193e-06, 1.25637e-06, 1.23133e-06, 1.20678e-06/
       DATA (KA_MN2( 5,JT,14),JT=1,19)  /
     & 1.73398e-06, 1.69941e-06, 1.66553e-06, 1.63233e-06, 1.59979e-06,
     & 1.56790e-06, 1.53664e-06, 1.50601e-06, 1.47598e-06, 1.44656e-06,
     & 1.41772e-06, 1.38946e-06, 1.36176e-06, 1.33461e-06, 1.30801e-06,
     & 1.28193e-06, 1.25637e-06, 1.23133e-06, 1.20678e-06/
       DATA (KA_MN2( 6,JT,14),JT=1,19)  /
     & 1.73398e-06, 1.69941e-06, 1.66553e-06, 1.63233e-06, 1.59979e-06,
     & 1.56790e-06, 1.53664e-06, 1.50601e-06, 1.47598e-06, 1.44656e-06,
     & 1.41772e-06, 1.38946e-06, 1.36176e-06, 1.33461e-06, 1.30801e-06,
     & 1.28193e-06, 1.25637e-06, 1.23133e-06, 1.20678e-06/
       DATA (KA_MN2( 7,JT,14),JT=1,19)  /
     & 1.73398e-06, 1.69941e-06, 1.66553e-06, 1.63233e-06, 1.59979e-06,
     & 1.56790e-06, 1.53664e-06, 1.50601e-06, 1.47598e-06, 1.44656e-06,
     & 1.41772e-06, 1.38946e-06, 1.36176e-06, 1.33461e-06, 1.30801e-06,
     & 1.28193e-06, 1.25637e-06, 1.23133e-06, 1.20678e-06/
       DATA (KA_MN2( 8,JT,14),JT=1,19)  /
     & 1.73398e-06, 1.69941e-06, 1.66553e-06, 1.63233e-06, 1.59979e-06,
     & 1.56790e-06, 1.53664e-06, 1.50601e-06, 1.47598e-06, 1.44656e-06,
     & 1.41772e-06, 1.38946e-06, 1.36176e-06, 1.33461e-06, 1.30801e-06,
     & 1.28193e-06, 1.25637e-06, 1.23133e-06, 1.20678e-06/
       DATA (KA_MN2( 9,JT,14),JT=1,19)  /
     & 1.83423e-06, 1.79123e-06, 1.74923e-06, 1.70821e-06, 1.66816e-06,
     & 1.62904e-06, 1.59085e-06, 1.55354e-06, 1.51712e-06, 1.48154e-06,
     & 1.44681e-06, 1.41288e-06, 1.37975e-06, 1.34740e-06, 1.31581e-06,
     & 1.28496e-06, 1.25483e-06, 1.22540e-06, 1.19667e-06/
       DATA (KA_MN2( 1,JT,15),JT=1,19)  /
     & 1.73231e-06, 1.69765e-06, 1.66368e-06, 1.63039e-06, 1.59776e-06,
     & 1.56579e-06, 1.53445e-06, 1.50375e-06, 1.47366e-06, 1.44417e-06,
     & 1.41527e-06, 1.38695e-06, 1.35919e-06, 1.33199e-06, 1.30534e-06,
     & 1.27922e-06, 1.25362e-06, 1.22853e-06, 1.20395e-06/
       DATA (KA_MN2( 2,JT,15),JT=1,19)  /
     & 1.73231e-06, 1.69765e-06, 1.66368e-06, 1.63039e-06, 1.59776e-06,
     & 1.56579e-06, 1.53445e-06, 1.50375e-06, 1.47366e-06, 1.44417e-06,
     & 1.41527e-06, 1.38695e-06, 1.35919e-06, 1.33199e-06, 1.30534e-06,
     & 1.27922e-06, 1.25362e-06, 1.22853e-06, 1.20395e-06/
       DATA (KA_MN2( 3,JT,15),JT=1,19)  /
     & 1.73231e-06, 1.69765e-06, 1.66368e-06, 1.63039e-06, 1.59776e-06,
     & 1.56579e-06, 1.53445e-06, 1.50375e-06, 1.47366e-06, 1.44417e-06,
     & 1.41527e-06, 1.38695e-06, 1.35919e-06, 1.33199e-06, 1.30534e-06,
     & 1.27922e-06, 1.25362e-06, 1.22853e-06, 1.20395e-06/
       DATA (KA_MN2( 4,JT,15),JT=1,19)  /
     & 1.73231e-06, 1.69765e-06, 1.66368e-06, 1.63039e-06, 1.59776e-06,
     & 1.56579e-06, 1.53445e-06, 1.50375e-06, 1.47366e-06, 1.44417e-06,
     & 1.41527e-06, 1.38695e-06, 1.35919e-06, 1.33199e-06, 1.30534e-06,
     & 1.27922e-06, 1.25362e-06, 1.22853e-06, 1.20395e-06/
       DATA (KA_MN2( 5,JT,15),JT=1,19)  /
     & 1.73231e-06, 1.69765e-06, 1.66368e-06, 1.63039e-06, 1.59776e-06,
     & 1.56579e-06, 1.53445e-06, 1.50375e-06, 1.47366e-06, 1.44417e-06,
     & 1.41527e-06, 1.38695e-06, 1.35919e-06, 1.33199e-06, 1.30534e-06,
     & 1.27922e-06, 1.25362e-06, 1.22853e-06, 1.20395e-06/
       DATA (KA_MN2( 6,JT,15),JT=1,19)  /
     & 1.73231e-06, 1.69765e-06, 1.66368e-06, 1.63039e-06, 1.59776e-06,
     & 1.56579e-06, 1.53445e-06, 1.50375e-06, 1.47366e-06, 1.44417e-06,
     & 1.41527e-06, 1.38695e-06, 1.35919e-06, 1.33199e-06, 1.30534e-06,
     & 1.27922e-06, 1.25362e-06, 1.22853e-06, 1.20395e-06/
       DATA (KA_MN2( 7,JT,15),JT=1,19)  /
     & 1.73231e-06, 1.69765e-06, 1.66368e-06, 1.63039e-06, 1.59776e-06,
     & 1.56579e-06, 1.53445e-06, 1.50375e-06, 1.47366e-06, 1.44417e-06,
     & 1.41527e-06, 1.38695e-06, 1.35919e-06, 1.33199e-06, 1.30534e-06,
     & 1.27922e-06, 1.25362e-06, 1.22853e-06, 1.20395e-06/
       DATA (KA_MN2( 8,JT,15),JT=1,19)  /
     & 1.73231e-06, 1.69765e-06, 1.66368e-06, 1.63039e-06, 1.59776e-06,
     & 1.56579e-06, 1.53445e-06, 1.50375e-06, 1.47366e-06, 1.44417e-06,
     & 1.41527e-06, 1.38695e-06, 1.35919e-06, 1.33199e-06, 1.30534e-06,
     & 1.27922e-06, 1.25362e-06, 1.22853e-06, 1.20395e-06/
       DATA (KA_MN2( 9,JT,15),JT=1,19)  /
     & 1.71602e-06, 1.68499e-06, 1.65452e-06, 1.62461e-06, 1.59523e-06,
     & 1.56639e-06, 1.53807e-06, 1.51026e-06, 1.48295e-06, 1.45614e-06,
     & 1.42981e-06, 1.40395e-06, 1.37857e-06, 1.35364e-06, 1.32917e-06,
     & 1.30513e-06, 1.28153e-06, 1.25836e-06, 1.23561e-06/
       DATA (KA_MN2( 1,JT,16),JT=1,19)  /
     & 1.73310e-06, 1.69826e-06, 1.66413e-06, 1.63069e-06, 1.59791e-06,
     & 1.56580e-06, 1.53433e-06, 1.50349e-06, 1.47328e-06, 1.44367e-06,
     & 1.41465e-06, 1.38622e-06, 1.35836e-06, 1.33106e-06, 1.30431e-06,
     & 1.27810e-06, 1.25241e-06, 1.22724e-06, 1.20257e-06/
       DATA (KA_MN2( 2,JT,16),JT=1,19)  /
     & 1.73310e-06, 1.69826e-06, 1.66413e-06, 1.63069e-06, 1.59791e-06,
     & 1.56580e-06, 1.53433e-06, 1.50349e-06, 1.47328e-06, 1.44367e-06,
     & 1.41465e-06, 1.38622e-06, 1.35836e-06, 1.33106e-06, 1.30431e-06,
     & 1.27810e-06, 1.25241e-06, 1.22724e-06, 1.20257e-06/
       DATA (KA_MN2( 3,JT,16),JT=1,19)  /
     & 1.73310e-06, 1.69826e-06, 1.66413e-06, 1.63069e-06, 1.59791e-06,
     & 1.56580e-06, 1.53433e-06, 1.50349e-06, 1.47328e-06, 1.44367e-06,
     & 1.41465e-06, 1.38622e-06, 1.35836e-06, 1.33106e-06, 1.30431e-06,
     & 1.27810e-06, 1.25241e-06, 1.22724e-06, 1.20257e-06/
       DATA (KA_MN2( 4,JT,16),JT=1,19)  /
     & 1.73310e-06, 1.69826e-06, 1.66413e-06, 1.63069e-06, 1.59791e-06,
     & 1.56580e-06, 1.53433e-06, 1.50349e-06, 1.47328e-06, 1.44367e-06,
     & 1.41465e-06, 1.38622e-06, 1.35836e-06, 1.33106e-06, 1.30431e-06,
     & 1.27810e-06, 1.25241e-06, 1.22724e-06, 1.20257e-06/
       DATA (KA_MN2( 5,JT,16),JT=1,19)  /
     & 1.73310e-06, 1.69826e-06, 1.66413e-06, 1.63069e-06, 1.59791e-06,
     & 1.56580e-06, 1.53433e-06, 1.50349e-06, 1.47328e-06, 1.44367e-06,
     & 1.41465e-06, 1.38622e-06, 1.35836e-06, 1.33106e-06, 1.30431e-06,
     & 1.27810e-06, 1.25241e-06, 1.22724e-06, 1.20257e-06/
       DATA (KA_MN2( 6,JT,16),JT=1,19)  /
     & 1.73310e-06, 1.69826e-06, 1.66413e-06, 1.63069e-06, 1.59791e-06,
     & 1.56580e-06, 1.53433e-06, 1.50349e-06, 1.47328e-06, 1.44367e-06,
     & 1.41465e-06, 1.38622e-06, 1.35836e-06, 1.33106e-06, 1.30431e-06,
     & 1.27810e-06, 1.25241e-06, 1.22724e-06, 1.20257e-06/
       DATA (KA_MN2( 7,JT,16),JT=1,19)  /
     & 1.73310e-06, 1.69826e-06, 1.66413e-06, 1.63069e-06, 1.59791e-06,
     & 1.56580e-06, 1.53433e-06, 1.50349e-06, 1.47328e-06, 1.44367e-06,
     & 1.41465e-06, 1.38622e-06, 1.35836e-06, 1.33106e-06, 1.30431e-06,
     & 1.27810e-06, 1.25241e-06, 1.22724e-06, 1.20257e-06/
       DATA (KA_MN2( 8,JT,16),JT=1,19)  /
     & 1.73310e-06, 1.69826e-06, 1.66413e-06, 1.63069e-06, 1.59791e-06,
     & 1.56580e-06, 1.53433e-06, 1.50349e-06, 1.47328e-06, 1.44367e-06,
     & 1.41465e-06, 1.38622e-06, 1.35836e-06, 1.33106e-06, 1.30431e-06,
     & 1.27810e-06, 1.25241e-06, 1.22724e-06, 1.20257e-06/
       DATA (KA_MN2( 9,JT,16),JT=1,19)  /
     & 1.79375e-06, 1.75599e-06, 1.71903e-06, 1.68284e-06, 1.64741e-06,
     & 1.61273e-06, 1.57878e-06, 1.54554e-06, 1.51301e-06, 1.48116e-06,
     & 1.44998e-06, 1.41945e-06, 1.38957e-06, 1.36032e-06, 1.33168e-06,
     & 1.30365e-06, 1.27620e-06, 1.24934e-06, 1.22304e-06/

