C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/k_gB16.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.1 $
C     created:   $Date: 2002/08/11 19:39:32 $
       PARAMETER (MG=16)
       DIMENSION SELFREF(10,MG), FORREF(4,MG)
       REAL KA(9,5,13,MG),KB(5,13:59,MG) 
       COMMON /HVRSN16/ HVRKG16
       COMMON /K16/ KA, KB, FORREF, SELFREF

       CHARACTER*15 HVRKG16
       DATA HVRKG16 /'$Revision: 3.1 $'/

C     The array KA contains absorption coefs for each of the 16 g-intervals
C     for a range of pressure levels > ~100mb, temperatures, and ratios
C     of water vapor to CO2.  The first index in the array, JS, runs
C     from 1 to 10, and corresponds to different gas column amount ratios,
C     as expressed through the binary species parameter eta, defined as
C     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
C     ratio of the reference MLS column amount value of gas 1 
C     to that of gas2.
C     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
C     to different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this  pressure 
C     level, JT = 2 refers to the temperature
C     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
C     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
C     to the reference pressure level (e.g. JP = 1 is for a
C     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA ((KA(JS,JT, 1, 1),JS=1,9),JT=1,5) /
     &2.6621E-07,6.0791E-06,9.3282E-06,1.2208E-05,1.4897E-05,1.7596E-05,
     &2.0729E-05,2.6390E-05,2.1078E-05,2.8927E-07,6.1043E-06,9.4020E-06,
     &1.2345E-05,1.5126E-05,1.7938E-05,2.1210E-05,2.6769E-05,2.1943E-05,
     &3.1534E-07,6.1325E-06,9.4674E-06,1.2459E-05,1.5335E-05,1.8250E-05,
     &2.1635E-05,2.7290E-05,2.2718E-05,3.3330E-07,6.1474E-06,9.4677E-06,
     &1.2509E-05,1.5444E-05,1.8455E-05,2.1960E-05,2.7695E-05,2.3390E-05,
     &3.5345E-07,6.1735E-06,9.4652E-06,1.2538E-05,1.5529E-05,1.8608E-05,
     &2.2197E-05,2.8038E-05,2.3906E-05/
      DATA ((KA(JS,JT, 2, 1),JS=1,9),JT=1,5) /
     &3.4774E-07,6.3116E-06,9.2039E-06,1.1662E-05,1.3842E-05,1.5878E-05,
     &1.7925E-05,2.1213E-05,1.7372E-05,3.7649E-07,6.3618E-06,9.2771E-06,
     &1.1777E-05,1.4038E-05,1.6170E-05,1.8345E-05,2.1716E-05,1.8135E-05,
     &4.1206E-07,6.4231E-06,9.3322E-06,1.1891E-05,1.4202E-05,1.6428E-05,
     &1.8750E-05,2.2212E-05,1.8847E-05,4.4004E-07,6.4581E-06,9.3579E-06,
     &1.1962E-05,1.4316E-05,1.6601E-05,1.9025E-05,2.2633E-05,1.9458E-05,
     &4.6078E-07,6.4755E-06,9.3704E-06,1.1973E-05,1.4371E-05,1.6702E-05,
     &1.9215E-05,2.2953E-05,1.9948E-05/
      DATA ((KA(JS,JT, 3, 1),JS=1,9),JT=1,5) /
     &5.9817E-07,7.8428E-06,1.0496E-05,1.2549E-05,1.4230E-05,1.5565E-05,
     &1.6588E-05,1.7671E-05,1.4245E-05,6.5182E-07,7.9343E-06,1.0585E-05,
     &1.2668E-05,1.4392E-05,1.5789E-05,1.6949E-05,1.8125E-05,1.4996E-05,
     &7.0221E-07,8.0226E-06,1.0677E-05,1.2755E-05,1.4518E-05,1.5973E-05,
     &1.7236E-05,1.8551E-05,1.5656E-05,7.6366E-07,8.1339E-06,1.0778E-05,
     &1.2848E-05,1.4645E-05,1.6156E-05,1.7457E-05,1.8931E-05,1.6271E-05,
     &7.9889E-07,8.1643E-06,1.0808E-05,1.2886E-05,1.4686E-05,1.6241E-05,
     &1.7601E-05,1.9193E-05,1.6837E-05/
      DATA ((KA(JS,JT, 4, 1),JS=1,9),JT=1,5) /
     &1.0320E-06,1.0378E-05,1.2935E-05,1.4632E-05,1.5802E-05,1.6452E-05,
     &1.6586E-05,1.6155E-05,1.2287E-05,1.1305E-06,1.0573E-05,1.3130E-05,
     &1.4798E-05,1.5980E-05,1.6653E-05,1.6853E-05,1.6526E-05,1.3070E-05,
     &1.2198E-06,1.0772E-05,1.3274E-05,1.4971E-05,1.6111E-05,1.6834E-05,
     &1.7084E-05,1.6873E-05,1.3795E-05,1.3096E-06,1.0937E-05,1.3422E-05,
     &1.5096E-05,1.6233E-05,1.6971E-05,1.7284E-05,1.7149E-05,1.4420E-05,
     &1.4155E-06,1.1094E-05,1.3596E-05,1.5273E-05,1.6388E-05,1.7112E-05,
     &1.7471E-05,1.7381E-05,1.4960E-05/
      DATA ((KA(JS,JT, 5, 1),JS=1,9),JT=1,5) /
     &1.6279E-06,1.3142E-05,1.6056E-05,1.7394E-05,1.8017E-05,1.8011E-05,
     &1.7308E-05,1.5625E-05,1.1008E-05,1.7835E-06,1.3457E-05,1.6348E-05,
     &1.7668E-05,1.8277E-05,1.8261E-05,1.7567E-05,1.5970E-05,1.1698E-05,
     &1.9402E-06,1.3791E-05,1.6620E-05,1.7922E-05,1.8515E-05,1.8474E-05,
     &1.7802E-05,1.6252E-05,1.2372E-05,2.0835E-06,1.4086E-05,1.6875E-05,
     &1.8160E-05,1.8703E-05,1.8665E-05,1.7992E-05,1.6486E-05,1.3071E-05,
     &2.2582E-06,1.4511E-05,1.7205E-05,1.8422E-05,1.8984E-05,1.8898E-05,
     &1.8217E-05,1.6724E-05,1.3787E-05/
      DATA ((KA(JS,JT, 6, 1),JS=1,9),JT=1,5) /
     &2.4034E-06,1.6823E-05,1.9391E-05,2.0723E-05,2.0772E-05,2.0043E-05,
     &1.8498E-05,1.5704E-05,9.8836E-06,2.6386E-06,1.7226E-05,1.9692E-05,
     &2.1124E-05,2.1126E-05,2.0392E-05,1.8810E-05,1.6034E-05,1.0751E-05,
     &2.8660E-06,1.7674E-05,2.0029E-05,2.1524E-05,2.1484E-05,2.0719E-05,
     &1.9071E-05,1.6298E-05,1.1450E-05,3.0844E-06,1.8072E-05,2.0407E-05,
     &2.1899E-05,2.1788E-05,2.0987E-05,1.9304E-05,1.6540E-05,1.2182E-05,
     &3.2920E-06,1.8533E-05,2.0800E-05,2.2106E-05,2.2044E-05,2.1223E-05,
     &1.9506E-05,1.6741E-05,1.2836E-05/
      DATA ((KA(JS,JT, 7, 1),JS=1,9),JT=1,5) /
     &3.8221E-06,2.2204E-05,2.4808E-05,2.5531E-05,2.5616E-05,2.3917E-05,
     &2.1120E-05,1.6870E-05,8.7171E-06,4.1828E-06,2.2870E-05,2.5558E-05,
     &2.5953E-05,2.6151E-05,2.4347E-05,2.1524E-05,1.7202E-05,9.2028E-06,
     &4.5497E-06,2.3564E-05,2.6164E-05,2.6493E-05,2.6591E-05,2.4767E-05,
     &2.1899E-05,1.7498E-05,9.7937E-06,4.8742E-06,2.4270E-05,2.6708E-05,
     &2.7099E-05,2.6759E-05,2.5177E-05,2.2242E-05,1.7759E-05,1.0449E-05,
     &5.1866E-06,2.4962E-05,2.7348E-05,2.7664E-05,2.7129E-05,2.5537E-05,
     &2.2515E-05,1.7998E-05,1.1128E-05/
      DATA ((KA(JS,JT, 8, 1),JS=1,9),JT=1,5) /
     &7.4211E-06,3.2998E-05,3.6610E-05,3.7073E-05,3.4983E-05,3.2511E-05,
     &2.7821E-05,2.0603E-05,7.1809E-06,8.1099E-06,3.4342E-05,3.7801E-05,
     &3.7976E-05,3.5797E-05,3.2823E-05,2.8347E-05,2.1030E-05,7.7735E-06,
     &8.7992E-06,3.5880E-05,3.8837E-05,3.8975E-05,3.6756E-05,3.3300E-05,
     &2.8882E-05,2.1428E-05,8.4180E-06,9.4486E-06,3.7431E-05,3.9883E-05,
     &3.9775E-05,3.7762E-05,3.3901E-05,2.9403E-05,2.1792E-05,9.1057E-06,
     &1.0041E-05,3.9014E-05,4.1019E-05,4.0539E-05,3.8447E-05,3.4543E-05,
     &2.9823E-05,2.2110E-05,9.8280E-06/
      DATA ((KA(JS,JT, 9, 1),JS=1,9),JT=1,5) /
     &2.6945E-05,8.1804E-05,8.6984E-05,8.4462E-05,7.8660E-05,6.9398E-05,
     &5.6216E-05,3.9134E-05,6.0831E-06,2.9562E-05,8.5456E-05,9.1284E-05,
     &8.7620E-05,8.1311E-05,7.1570E-05,5.7999E-05,3.9483E-05,6.6855E-06,
     &3.2110E-05,8.8183E-05,9.6256E-05,9.1033E-05,8.3882E-05,7.3603E-05,
     &5.9334E-05,4.0067E-05,7.3573E-06,3.4494E-05,9.0981E-05,1.0082E-04,
     &9.4837E-05,8.6631E-05,7.5471E-05,6.0778E-05,4.0870E-05,8.0874E-06,
     &3.6729E-05,9.3406E-05,1.0411E-04,9.8963E-05,8.9287E-05,7.7185E-05,
     &6.1987E-05,4.1723E-05,8.8598E-06/
      DATA ((KA(JS,JT,10, 1),JS=1,9),JT=1,5) /
     &1.1063E-04,2.0470E-04,2.2594E-04,2.2784E-04,2.0878E-04,1.7781E-04,
     &1.3876E-04,9.0190E-05,6.6238E-06,1.2128E-04,2.1612E-04,2.3657E-04,
     &2.3782E-04,2.2024E-04,1.8545E-04,1.4406E-04,9.3147E-05,7.2888E-06,
     &1.3155E-04,2.2685E-04,2.4613E-04,2.4648E-04,2.3100E-04,1.9523E-04,
     &1.4909E-04,9.5827E-05,7.7784E-06,1.4108E-04,2.3656E-04,2.5475E-04,
     &2.5395E-04,2.3879E-04,2.0427E-04,1.5511E-04,9.8368E-05,8.3069E-06,
     &1.4988E-04,2.4526E-04,2.6296E-04,2.6141E-04,2.4593E-04,2.1313E-04,
     &1.6065E-04,1.0083E-04,8.9709E-06/
      DATA ((KA(JS,JT,11, 1),JS=1,9),JT=1,5) /
     &1.6397E-04,2.6056E-04,2.8031E-04,2.7866E-04,2.6081E-04,2.2383E-04,
     &1.7351E-04,1.0962E-04,6.8264E-06,1.7933E-04,2.7580E-04,2.9343E-04,
     &2.9042E-04,2.7290E-04,2.3596E-04,1.8069E-04,1.1353E-04,7.5502E-06,
     &1.9324E-04,2.9031E-04,3.0629E-04,3.0108E-04,2.8182E-04,2.4730E-04,
     &1.8878E-04,1.1713E-04,7.9027E-06,2.0654E-04,3.0384E-04,3.1739E-04,
     &3.1103E-04,2.9049E-04,2.5555E-04,1.9705E-04,1.2084E-04,8.5383E-06,
     &2.1856E-04,3.1574E-04,3.2801E-04,3.2141E-04,2.9895E-04,2.6285E-04,
     &2.0518E-04,1.2441E-04,9.1615E-06/
      DATA ((KA(JS,JT,12, 1),JS=1,9),JT=1,5) /
     &1.7554E-04,2.6383E-04,2.7930E-04,2.7562E-04,2.5860E-04,2.2333E-04,
     &1.7363E-04,1.0883E-04,5.7385E-06,1.9241E-04,2.8007E-04,2.9311E-04,
     &2.8776E-04,2.6852E-04,2.3492E-04,1.8150E-04,1.1266E-04,6.8723E-06,
     &2.0743E-04,2.9497E-04,3.0602E-04,2.9878E-04,2.7794E-04,2.4424E-04,
     &1.8850E-04,1.1619E-04,7.4728E-06,2.2033E-04,3.0884E-04,3.1746E-04,
     &3.0874E-04,2.8629E-04,2.5127E-04,1.9681E-04,1.2004E-04,7.8331E-06,
     &2.3385E-04,3.2096E-04,3.2817E-04,3.1852E-04,2.9492E-04,2.5838E-04,
     &2.0541E-04,1.2394E-04,8.4107E-06/
      DATA ((KA(JS,JT,13, 1),JS=1,9),JT=1,5) /
     &1.4984E-04,2.2462E-04,2.3735E-04,2.3350E-04,2.1852E-04,1.8858E-04,
     &1.4655E-04,9.1919E-05,4.7944E-06,1.6431E-04,2.3822E-04,2.4852E-04,
     &2.4374E-04,2.2685E-04,1.9798E-04,1.5298E-04,9.5139E-05,5.7512E-06,
     &1.7714E-04,2.5149E-04,2.5950E-04,2.5249E-04,2.3438E-04,2.0591E-04,
     &1.5891E-04,9.8151E-05,6.2816E-06,1.8918E-04,2.6227E-04,2.6867E-04,
     &2.6081E-04,2.4142E-04,2.1149E-04,1.6602E-04,1.0121E-04,6.5742E-06,
     &1.9984E-04,2.7202E-04,2.7776E-04,2.6884E-04,2.4875E-04,2.1766E-04,
     &1.7300E-04,1.0449E-04,7.0482E-06/
      DATA ((KA(JS,JT, 1, 2),JS=1,9),JT=1,5) /
     &1.6519E-06,1.6500E-05,2.5026E-05,3.2759E-05,4.0208E-05,4.7995E-05,
     &5.7218E-05,7.0450E-05,6.2071E-05,1.7427E-06,1.6766E-05,2.5514E-05,
     &3.3509E-05,4.1226E-05,4.9256E-05,5.8782E-05,7.2775E-05,6.4227E-05,
     &1.8342E-06,1.7039E-05,2.6012E-05,3.4217E-05,4.2214E-05,5.0504E-05,
     &6.0325E-05,7.4727E-05,6.6376E-05,1.9060E-06,1.7243E-05,2.6493E-05,
     &3.4981E-05,4.3216E-05,5.1749E-05,6.1747E-05,7.6716E-05,6.8482E-05,
     &1.9873E-06,1.7462E-05,2.6980E-05,3.5686E-05,4.4149E-05,5.2919E-05,
     &6.3181E-05,7.8643E-05,7.0600E-05/
      DATA ((KA(JS,JT, 2, 2),JS=1,9),JT=1,5) /
     &2.1537E-06,1.7686E-05,2.5477E-05,3.2084E-05,3.8037E-05,4.3791E-05,
     &5.0118E-05,5.9749E-05,5.2659E-05,2.2967E-06,1.7950E-05,2.5979E-05,
     &3.2808E-05,3.8966E-05,4.4991E-05,5.1587E-05,6.1578E-05,5.4559E-05,
     &2.4223E-06,1.8241E-05,2.6472E-05,3.3476E-05,3.9818E-05,4.6056E-05,
     &5.2876E-05,6.3201E-05,5.6392E-05,2.5452E-06,1.8478E-05,2.6920E-05,
     &3.4112E-05,4.0714E-05,4.7174E-05,5.4253E-05,6.4831E-05,5.8337E-05,
     &2.6442E-06,1.8696E-05,2.7330E-05,3.4790E-05,4.1641E-05,4.8326E-05,
     &5.5567E-05,6.6400E-05,6.0213E-05/
      DATA ((KA(JS,JT, 3, 2),JS=1,9),JT=1,5) /
     &3.6781E-06,2.1946E-05,2.9916E-05,3.5559E-05,4.0089E-05,4.3735E-05,
     &4.6884E-05,5.0541E-05,4.3984E-05,3.9348E-06,2.2135E-05,3.0461E-05,
     &3.6306E-05,4.1005E-05,4.4863E-05,4.8174E-05,5.2207E-05,4.5557E-05,
     &4.1798E-06,2.2403E-05,3.0963E-05,3.7011E-05,4.1865E-05,4.5861E-05,
     &4.9330E-05,5.3612E-05,4.7151E-05,4.4176E-06,2.2879E-05,3.1514E-05,
     &3.7717E-05,4.2706E-05,4.6836E-05,5.0501E-05,5.4941E-05,4.8733E-05,
     &4.5930E-06,2.3205E-05,3.1822E-05,3.8274E-05,4.3472E-05,4.7803E-05,
     &5.1670E-05,5.6326E-05,5.0305E-05/
      DATA ((KA(JS,JT, 4, 2),JS=1,9),JT=1,5) /
     &6.4358E-06,2.9282E-05,3.6943E-05,4.2596E-05,4.5632E-05,4.7319E-05,
     &4.7633E-05,4.6727E-05,3.6481E-05,6.8669E-06,2.9817E-05,3.7275E-05,
     &4.3436E-05,4.6592E-05,4.8428E-05,4.8930E-05,4.8153E-05,3.7877E-05,
     &7.3364E-06,3.0199E-05,3.7809E-05,4.3827E-05,4.7553E-05,4.9496E-05,
     &5.0112E-05,4.9423E-05,3.9242E-05,7.7623E-06,3.0806E-05,3.8513E-05,
     &4.4137E-05,4.8467E-05,5.0544E-05,5.1178E-05,5.0627E-05,4.0689E-05,
     &8.2042E-06,3.1502E-05,3.9409E-05,4.4849E-05,4.9430E-05,5.1580E-05,
     &5.2292E-05,5.1835E-05,4.2152E-05/
      DATA ((KA(JS,JT, 5, 2),JS=1,9),JT=1,5) /
     &1.0402E-05,3.8540E-05,4.6318E-05,5.0020E-05,5.3672E-05,5.3150E-05,
     &5.0796E-05,4.5989E-05,3.1155E-05,1.1085E-05,3.9241E-05,4.7238E-05,
     &5.0920E-05,5.3596E-05,5.4294E-05,5.2010E-05,4.7261E-05,3.2691E-05,
     &1.1793E-05,3.9912E-05,4.8110E-05,5.1979E-05,5.4361E-05,5.5470E-05,
     &5.3221E-05,4.8498E-05,3.4229E-05,1.2505E-05,4.0706E-05,4.8865E-05,
     &5.3127E-05,5.5321E-05,5.6646E-05,5.4402E-05,4.9696E-05,3.5620E-05,
     &1.3238E-05,4.1575E-05,5.0157E-05,5.4552E-05,5.6339E-05,5.7036E-05,
     &5.5608E-05,5.0863E-05,3.6859E-05/
      DATA ((KA(JS,JT, 6, 2),JS=1,9),JT=1,5) /
     &1.5685E-05,4.8160E-05,5.7576E-05,6.0816E-05,6.0795E-05,5.9888E-05,
     &5.5641E-05,4.7076E-05,2.7125E-05,1.6746E-05,4.9438E-05,5.8728E-05,
     &6.2091E-05,6.2171E-05,6.0759E-05,5.6976E-05,4.8239E-05,2.8411E-05,
     &1.7756E-05,5.0622E-05,5.9836E-05,6.3203E-05,6.3569E-05,6.1458E-05,
     &5.8288E-05,4.9429E-05,2.9823E-05,1.8829E-05,5.1859E-05,6.0806E-05,
     &6.4509E-05,6.5119E-05,6.2540E-05,5.8809E-05,5.0652E-05,3.1085E-05,
     &1.9856E-05,5.2975E-05,6.2034E-05,6.5989E-05,6.6522E-05,6.3894E-05,
     &5.9538E-05,5.1853E-05,3.2453E-05/
      DATA ((KA(JS,JT, 7, 2),JS=1,9),JT=1,5) /
     &2.4856E-05,6.4218E-05,7.4055E-05,7.7980E-05,7.5911E-05,7.1057E-05,
     &6.3849E-05,5.1579E-05,2.5153E-05,2.6608E-05,6.6305E-05,7.5730E-05,
     &7.9533E-05,7.7616E-05,7.2887E-05,6.4610E-05,5.2907E-05,2.6881E-05,
     &2.8288E-05,6.8291E-05,7.7618E-05,8.1185E-05,7.9322E-05,7.4738E-05,
     &6.5685E-05,5.4242E-05,2.8455E-05,3.0045E-05,7.0265E-05,7.9536E-05,
     &8.2799E-05,8.1209E-05,7.6305E-05,6.7186E-05,5.5601E-05,2.9886E-05,
     &3.1755E-05,7.2003E-05,8.1183E-05,8.4367E-05,8.2925E-05,7.7935E-05,
     &6.8892E-05,5.5914E-05,3.1298E-05/
      DATA ((KA(JS,JT, 8, 2),JS=1,9),JT=1,5) /
     &4.6308E-05,9.7055E-05,1.0843E-04,1.0990E-04,1.0798E-04,9.8279E-05,
     &8.2910E-05,6.2908E-05,2.6615E-05,4.9990E-05,1.0048E-04,1.1189E-04,
     &1.1329E-04,1.1038E-04,1.0108E-04,8.5246E-05,6.3800E-05,2.8720E-05,
     &5.3406E-05,1.0353E-04,1.1536E-04,1.1646E-04,1.1270E-04,1.0316E-04,
     &8.7419E-05,6.5105E-05,3.1055E-05,5.6634E-05,1.0658E-04,1.1884E-04,
     &1.1968E-04,1.1489E-04,1.0536E-04,8.9223E-05,6.6739E-05,3.2877E-05,
     &5.9979E-05,1.0942E-04,1.2217E-04,1.2302E-04,1.1760E-04,1.0763E-04,
     &9.1750E-05,6.8524E-05,3.4517E-05/
      DATA ((KA(JS,JT, 9, 2),JS=1,9),JT=1,5) /
     &1.6574E-04,2.3675E-04,2.5425E-04,2.5367E-04,2.3792E-04,2.1003E-04,
     &1.7177E-04,1.1936E-04,3.2512E-05,1.7873E-04,2.4657E-04,2.6302E-04,
     &2.6299E-04,2.4679E-04,2.1704E-04,1.7629E-04,1.2297E-04,3.4956E-05,
     &1.9203E-04,2.5827E-04,2.7104E-04,2.7133E-04,2.5463E-04,2.2408E-04,
     &1.8102E-04,1.2579E-04,3.6986E-05,2.0457E-04,2.7047E-04,2.8009E-04,
     &2.7979E-04,2.6236E-04,2.3082E-04,1.8610E-04,1.2867E-04,3.9201E-05,
     &2.1654E-04,2.8311E-04,2.9060E-04,2.8789E-04,2.7019E-04,2.3757E-04,
     &1.9128E-04,1.3157E-04,4.1162E-05/
      DATA ((KA(JS,JT,10, 2),JS=1,9),JT=1,5) /
     &6.9835E-04,7.7425E-04,7.4212E-04,6.8606E-04,6.1917E-04,5.3712E-04,
     &4.2860E-04,2.7889E-04,3.4936E-05,7.4976E-04,8.1587E-04,7.7895E-04,
     &7.1764E-04,6.4311E-04,5.5763E-04,4.4404E-04,2.8872E-04,3.8434E-05,
     &8.0421E-04,8.6133E-04,8.1873E-04,7.5123E-04,6.6805E-04,5.7460E-04,
     &4.5895E-04,2.9845E-04,4.2197E-05,8.5541E-04,9.0651E-04,8.6169E-04,
     &7.8842E-04,6.9649E-04,5.9375E-04,4.7283E-04,3.0790E-04,4.6109E-05,
     &9.0554E-04,9.5112E-04,9.0374E-04,8.2600E-04,7.2587E-04,6.1366E-04,
     &4.8709E-04,3.1697E-04,4.9839E-05/
      DATA ((KA(JS,JT,11, 2),JS=1,9),JT=1,5) /
     &1.0573E-03,1.1046E-03,1.0331E-03,9.3641E-04,8.2149E-04,6.9220E-04,
     &5.4269E-04,3.5137E-04,3.2311E-05,1.1354E-03,1.1699E-03,1.0957E-03,
     &9.8791E-04,8.6081E-04,7.2123E-04,5.6428E-04,3.6441E-04,3.5797E-05,
     &1.2157E-03,1.2370E-03,1.1565E-03,1.0415E-03,9.0546E-04,7.4993E-04,
     &5.8345E-04,3.7768E-04,3.9564E-05,1.2894E-03,1.3041E-03,1.2183E-03,
     &1.0951E-03,9.4833E-04,7.8292E-04,6.0424E-04,3.8988E-04,4.3105E-05,
     &1.3602E-03,1.3714E-03,1.2775E-03,1.1464E-03,9.9122E-04,8.1361E-04,
     &6.2375E-04,4.0138E-04,4.6502E-05/
      DATA ((KA(JS,JT,12, 2),JS=1,9),JT=1,5) /
     &1.1559E-03,1.1821E-03,1.1002E-03,9.8760E-04,8.5869E-04,7.1597E-04,
     &5.5368E-04,3.5629E-04,2.8926E-05,1.2387E-03,1.2530E-03,1.1642E-03,
     &1.0435E-03,9.0422E-04,7.4802E-04,5.7617E-04,3.7052E-04,3.1589E-05,
     &1.3216E-03,1.3229E-03,1.2283E-03,1.1015E-03,9.5193E-04,7.8187E-04,
     &5.9954E-04,3.8460E-04,3.4577E-05,1.3983E-03,1.3942E-03,1.2931E-03,
     &1.1587E-03,9.9709E-04,8.1633E-04,6.2085E-04,3.9719E-04,3.7982E-05,
     &1.4751E-03,1.4634E-03,1.3557E-03,1.2116E-03,1.0389E-03,8.4961E-04,
     &6.4030E-04,4.0878E-04,4.0969E-05/
      DATA ((KA(JS,JT,13, 2),JS=1,9),JT=1,5) /
     &1.0038E-03,1.0239E-03,9.5244E-04,8.5524E-04,7.4348E-04,6.2001E-04,
     &4.7929E-04,3.0767E-04,2.4695E-05,1.0734E-03,1.0865E-03,1.0094E-03,
     &9.0484E-04,7.8346E-04,6.4723E-04,4.9815E-04,3.1985E-04,2.6858E-05,
     &1.1391E-03,1.1434E-03,1.0621E-03,9.5239E-04,8.2130E-04,6.7579E-04,
     &5.1796E-04,3.3140E-04,2.9385E-05,1.2032E-03,1.2025E-03,1.1163E-03,
     &9.9786E-04,8.5960E-04,7.0590E-04,5.3619E-04,3.4228E-04,3.2189E-05,
     &1.2690E-03,1.2617E-03,1.1676E-03,1.0418E-03,8.9504E-04,7.3293E-04,
     &5.5106E-04,3.5176E-04,3.4791E-05/
      DATA ((KA(JS,JT, 1, 3),JS=1,9),JT=1,5) /
     &3.4054E-06,3.6169E-05,5.7781E-05,7.9702E-05,9.9450E-05,1.1908E-04,
     &1.4021E-04,1.6904E-04,1.5965E-04,3.5406E-06,3.7213E-05,5.9148E-05,
     &7.9930E-05,1.0281E-04,1.2326E-04,1.4516E-04,1.7473E-04,1.6518E-04,
     &3.6962E-06,3.8392E-05,6.0628E-05,8.1614E-05,1.0332E-04,1.2805E-04,
     &1.5083E-04,1.8127E-04,1.7179E-04,3.8150E-06,3.9649E-05,6.2587E-05,
     &8.4276E-05,1.0580E-04,1.2950E-04,1.5730E-04,1.8884E-04,1.7648E-04,
     &3.9425E-06,4.0895E-05,6.4628E-05,8.7067E-05,1.0971E-04,1.3287E-04,
     &1.5979E-04,1.9707E-04,1.8056E-04/
      DATA ((KA(JS,JT, 2, 3),JS=1,9),JT=1,5) /
     &4.7659E-06,3.7672E-05,5.6772E-05,7.4964E-05,9.3354E-05,1.1163E-04,
     &1.2805E-04,1.4897E-04,1.4118E-04,4.9285E-06,3.8459E-05,5.8331E-05,
     &7.6310E-05,9.3490E-05,1.1292E-04,1.3218E-04,1.5402E-04,1.4609E-04,
     &5.1241E-06,3.9569E-05,6.0060E-05,7.8269E-05,9.6361E-05,1.1403E-04,
     &1.3730E-04,1.5986E-04,1.4966E-04,5.2863E-06,4.0536E-05,6.2133E-05,
     &8.0760E-05,9.8821E-05,1.1724E-04,1.3737E-04,1.6656E-04,1.5208E-04,
     &5.4310E-06,4.1540E-05,6.3967E-05,8.3433E-05,1.0178E-04,1.2080E-04,
     &1.4142E-04,1.7063E-04,1.5631E-04/
      DATA ((KA(JS,JT, 3, 3),JS=1,9),JT=1,5) /
     &8.9186E-06,4.5407E-05,6.3526E-05,7.8550E-05,9.1618E-05,1.0496E-04,
     &1.2158E-04,1.3284E-04,1.2340E-04,9.2443E-06,4.6508E-05,6.4784E-05,
     &8.0506E-05,9.3613E-05,1.0642E-04,1.2005E-04,1.3711E-04,1.2632E-04,
     &9.5550E-06,4.7677E-05,6.6548E-05,8.2736E-05,9.6188E-05,1.0877E-04,
     &1.2156E-04,1.4196E-04,1.2696E-04,9.9051E-06,4.8778E-05,6.8112E-05,
     &8.4988E-05,9.9246E-05,1.1223E-04,1.2463E-04,1.4159E-04,1.2947E-04,
     &1.0162E-05,4.9942E-05,6.9999E-05,8.7421E-05,1.0238E-04,1.1576E-04,
     &1.2839E-04,1.4461E-04,1.3351E-04/
      DATA ((KA(JS,JT, 4, 3),JS=1,9),JT=1,5) /
     &1.6753E-05,5.8237E-05,7.6272E-05,8.8204E-05,9.8762E-05,1.0698E-04,
     &1.1349E-04,1.2379E-04,1.0697E-04,1.7441E-05,5.9610E-05,7.7972E-05,
     &9.0358E-05,1.0097E-04,1.0919E-04,1.1491E-04,1.2294E-04,1.0628E-04,
     &1.8082E-05,6.1175E-05,7.9988E-05,9.2267E-05,1.0332E-04,1.1211E-04,
     &1.1776E-04,1.2346E-04,1.0729E-04,1.8658E-05,6.2685E-05,8.1816E-05,
     &9.5481E-05,1.0615E-04,1.1496E-04,1.2097E-04,1.2608E-04,1.1024E-04,
     &1.9340E-05,6.4673E-05,8.3970E-05,9.8481E-05,1.0873E-04,1.1832E-04,
     &1.2499E-04,1.2979E-04,1.1362E-04/
      DATA ((KA(JS,JT, 5, 3),JS=1,9),JT=1,5) /
     &2.8523E-05,7.5471E-05,9.2112E-05,1.0383E-04,1.0948E-04,1.1290E-04,
     &1.1403E-04,1.1277E-04,8.7972E-05,2.9775E-05,7.7638E-05,9.4306E-05,
     &1.0580E-04,1.1226E-04,1.1540E-04,1.1664E-04,1.1378E-04,8.7781E-05,
     &3.1032E-05,7.9995E-05,9.6878E-05,1.0807E-04,1.1530E-04,1.1833E-04,
     &1.1968E-04,1.1643E-04,8.9738E-05,3.2122E-05,8.2389E-05,9.9387E-05,
     &1.1070E-04,1.1849E-04,1.2073E-04,1.2266E-04,1.1931E-04,9.1761E-05,
     &3.3412E-05,8.5294E-05,1.0214E-04,1.1395E-04,1.2220E-04,1.2513E-04,
     &1.2589E-04,1.2317E-04,9.4332E-05/
      DATA ((KA(JS,JT, 6, 3),JS=1,9),JT=1,5) /
     &4.4933E-05,9.9737E-05,1.1255E-04,1.2118E-04,1.2554E-04,1.2364E-04,
     &1.1791E-04,1.0852E-04,7.4135E-05,4.7071E-05,1.0236E-04,1.1567E-04,
     &1.2397E-04,1.2766E-04,1.2658E-04,1.2060E-04,1.1056E-04,7.5435E-05,
     &4.9151E-05,1.0514E-04,1.1921E-04,1.2711E-04,1.3040E-04,1.2992E-04,
     &1.2331E-04,1.1371E-04,7.6849E-05,5.1024E-05,1.0807E-04,1.2306E-04,
     &1.3034E-04,1.3370E-04,1.3344E-04,1.2682E-04,1.1612E-04,7.8630E-05,
     &5.2854E-05,1.1144E-04,1.2670E-04,1.3361E-04,1.3751E-04,1.3677E-04,
     &1.3113E-04,1.1903E-04,8.1063E-05/
      DATA ((KA(JS,JT, 7, 3),JS=1,9),JT=1,5) /
     &7.4131E-05,1.3771E-04,1.5135E-04,1.5339E-04,1.5199E-04,1.4542E-04,
     &1.3212E-04,1.1157E-04,6.3305E-05,7.8122E-05,1.4080E-04,1.5542E-04,
     &1.5789E-04,1.5525E-04,1.4808E-04,1.3571E-04,1.1400E-04,6.4305E-05,
     &8.1792E-05,1.4429E-04,1.5980E-04,1.6259E-04,1.5930E-04,1.5173E-04,
     &1.3906E-04,1.1682E-04,6.5778E-05,8.5102E-05,1.4854E-04,1.6447E-04,
     &1.6719E-04,1.6365E-04,1.5623E-04,1.4249E-04,1.1910E-04,6.8216E-05,
     &8.8343E-05,1.5302E-04,1.6961E-04,1.7246E-04,1.6859E-04,1.6045E-04,
     &1.4567E-04,1.2333E-04,7.0812E-05/
      DATA ((KA(JS,JT, 8, 3),JS=1,9),JT=1,5) /
     &1.4407E-04,2.1929E-04,2.3408E-04,2.3175E-04,2.1747E-04,1.9684E-04,
     &1.7181E-04,1.3227E-04,5.5189E-05,1.5218E-04,2.2535E-04,2.3947E-04,
     &2.3742E-04,2.2354E-04,2.0175E-04,1.7481E-04,1.3567E-04,5.7508E-05,
     &1.5981E-04,2.3168E-04,2.4529E-04,2.4373E-04,2.2990E-04,2.0756E-04,
     &1.7860E-04,1.3869E-04,5.9914E-05,1.6710E-04,2.3880E-04,2.5211E-04,
     &2.5020E-04,2.3684E-04,2.1373E-04,1.8326E-04,1.4183E-04,6.3164E-05,
     &1.7380E-04,2.4599E-04,2.5929E-04,2.5766E-04,2.4400E-04,2.1994E-04,
     &1.8763E-04,1.4519E-04,6.6105E-05/
      DATA ((KA(JS,JT, 9, 3),JS=1,9),JT=1,5) /
     &5.2627E-04,6.1534E-04,6.0941E-04,5.7646E-04,5.2415E-04,4.5407E-04,
     &3.6135E-04,2.4279E-04,6.7993E-05,5.5864E-04,6.4193E-04,6.3124E-04,
     &5.9396E-04,5.3793E-04,4.6535E-04,3.7115E-04,2.4862E-04,7.5217E-05,
     &5.8842E-04,6.6676E-04,6.5277E-04,6.1271E-04,5.5239E-04,4.7636E-04,
     &3.8150E-04,2.5543E-04,8.1799E-05,6.1785E-04,6.9166E-04,6.7437E-04,
     &6.3091E-04,5.6815E-04,4.8941E-04,3.9213E-04,2.6284E-04,8.7598E-05,
     &6.4520E-04,7.1602E-04,6.9663E-04,6.4913E-04,5.8418E-04,5.0317E-04,
     &4.0334E-04,2.7060E-04,9.2801E-05/
      DATA ((KA(JS,JT,10, 3),JS=1,9),JT=1,5) /
     &2.1645E-03,2.1618E-03,2.0014E-03,1.7923E-03,1.5495E-03,1.2769E-03,
     &9.6609E-04,6.0453E-04,1.0410E-04,2.3095E-03,2.2836E-03,2.1017E-03,
     &1.8749E-03,1.6151E-03,1.3240E-03,9.9711E-04,6.2160E-04,1.1408E-04,
     &2.4464E-03,2.3906E-03,2.1944E-03,1.9559E-03,1.6773E-03,1.3715E-03,
     &1.0290E-03,6.3832E-04,1.2224E-04,2.5757E-03,2.5009E-03,2.2880E-03,
     &2.0317E-03,1.7417E-03,1.4189E-03,1.0630E-03,6.5627E-04,1.3004E-04,
     &2.6938E-03,2.6117E-03,2.3825E-03,2.1099E-03,1.8067E-03,1.4685E-03,
     &1.0955E-03,6.7426E-04,1.3892E-04/
      DATA ((KA(JS,JT,11, 3),JS=1,9),JT=1,5) /
     &3.2925E-03,3.1585E-03,2.8624E-03,2.5152E-03,2.1339E-03,1.7245E-03,
     &1.2749E-03,7.7353E-04,1.1570E-04,3.4939E-03,3.3275E-03,2.9995E-03,
     &2.6330E-03,2.2285E-03,1.7928E-03,1.3221E-03,7.9717E-04,1.2609E-04,
     &3.6814E-03,3.4852E-03,3.1333E-03,2.7438E-03,2.3219E-03,1.8667E-03,
     &1.3711E-03,8.2069E-04,1.3849E-04,3.8717E-03,3.6472E-03,3.2720E-03,
     &2.8608E-03,2.4167E-03,1.9357E-03,1.4194E-03,8.4717E-04,1.4796E-04,
     &4.0507E-03,3.8076E-03,3.4109E-03,2.9754E-03,2.5103E-03,2.0111E-03,
     &1.4691E-03,8.7324E-04,1.5498E-04/
      DATA ((KA(JS,JT,12, 3),JS=1,9),JT=1,5) /
     &3.6937E-03,3.5033E-03,3.1460E-03,2.7421E-03,2.3088E-03,1.8436E-03,
     &1.3493E-03,8.0094E-04,1.1298E-04,3.9154E-03,3.6887E-03,3.2999E-03,
     &2.8717E-03,2.4149E-03,1.9245E-03,1.4017E-03,8.2771E-04,1.2419E-04,
     &4.1285E-03,3.8698E-03,3.4585E-03,3.0012E-03,2.5199E-03,2.0022E-03,
     &1.4553E-03,8.5423E-04,1.3225E-04,4.3384E-03,4.0509E-03,3.6103E-03,
     &3.1297E-03,2.6243E-03,2.0861E-03,1.5110E-03,8.8306E-04,1.4212E-04,
     &4.5406E-03,4.2341E-03,3.7730E-03,3.2693E-03,2.7384E-03,2.1705E-03,
     &1.5683E-03,9.1255E-04,1.5213E-04/
      DATA ((KA(JS,JT,13, 3),JS=1,9),JT=1,5) /
     &3.2602E-03,3.0914E-03,2.7797E-03,2.4220E-03,2.0389E-03,1.6288E-03,
     &1.1889E-03,7.0223E-04,9.9450E-05,3.4542E-03,3.2567E-03,2.9218E-03,
     &2.5424E-03,2.1356E-03,1.7009E-03,1.2356E-03,7.2786E-04,1.0781E-04,
     &3.6454E-03,3.4269E-03,3.0649E-03,2.6592E-03,2.2314E-03,1.7744E-03,
     &1.2855E-03,7.5225E-04,1.1667E-04,3.8341E-03,3.5875E-03,3.2022E-03,
     &2.7784E-03,2.3283E-03,1.8470E-03,1.3345E-03,7.7860E-04,1.2556E-04,
     &4.0097E-03,3.7448E-03,3.3397E-03,2.8965E-03,2.4238E-03,1.9205E-03,
     &1.3873E-03,8.0728E-04,1.3156E-04/
      DATA ((KA(JS,JT, 1, 4),JS=1,9),JT=1,5) /
     &7.6190E-06,7.2707E-05,1.2159E-04,1.6797E-04,2.1749E-04,2.7232E-04,
     &3.3756E-04,4.5000E-04,3.7863E-04,7.7938E-06,7.4481E-05,1.2500E-04,
     &1.7416E-04,2.2412E-04,2.7984E-04,3.4630E-04,4.4903E-04,3.8823E-04,
     &8.0028E-06,7.6115E-05,1.2829E-04,1.8057E-04,2.3237E-04,2.8607E-04,
     &3.5506E-04,4.5741E-04,3.9983E-04,8.1270E-06,7.7997E-05,1.3160E-04,
     &1.8544E-04,2.4027E-04,2.9656E-04,3.6016E-04,4.6576E-04,4.1176E-04,
     &8.2916E-06,8.0436E-05,1.3585E-04,1.9127E-04,2.4691E-04,3.0708E-04,
     &3.7489E-04,4.7422E-04,4.3091E-04/
      DATA ((KA(JS,JT, 2, 4),JS=1,9),JT=1,5) /
     &1.0434E-05,7.3238E-05,1.1625E-04,1.5526E-04,1.9383E-04,2.3419E-04,
     &2.8405E-04,3.6155E-04,3.1532E-04,1.0681E-05,7.5036E-05,1.1854E-04,
     &1.5997E-04,2.0074E-04,2.4144E-04,2.9129E-04,3.7038E-04,3.2501E-04,
     &1.0988E-05,7.7182E-05,1.2126E-04,1.6374E-04,2.0655E-04,2.5052E-04,
     &2.9566E-04,3.7520E-04,3.3554E-04,1.1243E-05,7.9396E-05,1.2452E-04,
     &1.6827E-04,2.1213E-04,2.5807E-04,3.0951E-04,3.7973E-04,3.4985E-04,
     &1.1433E-05,8.1733E-05,1.2847E-04,1.7400E-04,2.1976E-04,2.6675E-04,
     &3.1873E-04,3.9060E-04,3.6531E-04/
      DATA ((KA(JS,JT, 3, 4),JS=1,9),JT=1,5) /
     &1.9121E-05,8.5930E-05,1.2401E-04,1.5771E-04,1.8803E-04,2.1587E-04,
     &2.4191E-04,2.8659E-04,2.6000E-04,1.9555E-05,8.7968E-05,1.2724E-04,
     &1.6033E-04,1.9279E-04,2.2305E-04,2.5217E-04,2.9281E-04,2.6982E-04,
     &2.0014E-05,9.0319E-05,1.3030E-04,1.6432E-04,1.9658E-04,2.2814E-04,
     &2.6130E-04,2.9767E-04,2.8111E-04,2.0629E-05,9.3145E-05,1.3414E-04,
     &1.6939E-04,2.0212E-04,2.3402E-04,2.6796E-04,3.0992E-04,2.9328E-04,
     &2.0980E-05,9.5719E-05,1.3796E-04,1.7464E-04,2.0857E-04,2.4205E-04,
     &2.7670E-04,3.1994E-04,3.0523E-04/
      DATA ((KA(JS,JT, 4, 4),JS=1,9),JT=1,5) /
     &3.5480E-05,1.1130E-04,1.4459E-04,1.7323E-04,1.9468E-04,2.1444E-04,
     &2.2966E-04,2.4128E-04,2.1617E-04,3.6323E-05,1.1358E-04,1.4824E-04,
     &1.7664E-04,1.9952E-04,2.1840E-04,2.3716E-04,2.5075E-04,2.2864E-04,
     &3.7216E-05,1.1624E-04,1.5219E-04,1.8108E-04,2.0484E-04,2.2378E-04,
     &2.4107E-04,2.5972E-04,2.3687E-04,3.8132E-05,1.1926E-04,1.5631E-04,
     &1.8514E-04,2.0992E-04,2.3030E-04,2.4787E-04,2.6623E-04,2.4575E-04,
     &3.9332E-05,1.2292E-04,1.6148E-04,1.9104E-04,2.1696E-04,2.3764E-04,
     &2.5623E-04,2.7468E-04,2.5520E-04/
      DATA ((KA(JS,JT, 5, 4),JS=1,9),JT=1,5) /
     &6.0558E-05,1.4537E-04,1.7679E-04,1.9677E-04,2.1242E-04,2.2290E-04,
     &2.2712E-04,2.2468E-04,1.8402E-04,6.2024E-05,1.4763E-04,1.8049E-04,
     &2.0169E-04,2.1740E-04,2.2816E-04,2.3141E-04,2.3210E-04,1.9363E-04,
     &6.3560E-05,1.5048E-04,1.8446E-04,2.0674E-04,2.2245E-04,2.3297E-04,
     &2.3732E-04,2.3625E-04,1.9953E-04,6.5197E-05,1.5389E-04,1.8956E-04,
     &2.1242E-04,2.2805E-04,2.3893E-04,2.4394E-04,2.4242E-04,2.0731E-04,
     &6.7408E-05,1.5860E-04,1.9588E-04,2.1916E-04,2.3481E-04,2.4604E-04,
     &2.5157E-04,2.5058E-04,2.1479E-04/
      DATA ((KA(JS,JT, 6, 4),JS=1,9),JT=1,5) /
     &9.6086E-05,1.8511E-04,2.1787E-04,2.3286E-04,2.3898E-04,2.3907E-04,
     &2.3360E-04,2.1667E-04,1.5583E-04,9.8537E-05,1.8825E-04,2.2157E-04,
     &2.3776E-04,2.4456E-04,2.4422E-04,2.3850E-04,2.2088E-04,1.6156E-04,
     &1.0106E-04,1.9192E-04,2.2599E-04,2.4309E-04,2.5072E-04,2.5018E-04,
     &2.4346E-04,2.2608E-04,1.6736E-04,1.0368E-04,1.9610E-04,2.3144E-04,
     &2.4948E-04,2.5710E-04,2.5653E-04,2.4933E-04,2.3314E-04,1.7404E-04,
     &1.0646E-04,2.0089E-04,2.3770E-04,2.5701E-04,2.6421E-04,2.6433E-04,
     &2.5582E-04,2.4028E-04,1.7876E-04/
      DATA ((KA(JS,JT, 7, 4),JS=1,9),JT=1,5) /
     &1.6042E-04,2.5585E-04,2.8519E-04,2.9642E-04,2.9350E-04,2.7913E-04,
     &2.5601E-04,2.2211E-04,1.3626E-04,1.6465E-04,2.6056E-04,2.8988E-04,
     &3.0133E-04,2.9907E-04,2.8588E-04,2.6187E-04,2.2729E-04,1.4135E-04,
     &1.6901E-04,2.6578E-04,2.9572E-04,3.0741E-04,3.0551E-04,2.9184E-04,
     &2.6817E-04,2.3205E-04,1.4656E-04,1.7367E-04,2.7110E-04,3.0239E-04,
     &3.1497E-04,3.1315E-04,2.9895E-04,2.7506E-04,2.3781E-04,1.5059E-04,
     &1.7865E-04,2.7756E-04,3.1008E-04,3.2315E-04,3.2186E-04,3.0753E-04,
     &2.8375E-04,2.4404E-04,1.5550E-04/
      DATA ((KA(JS,JT, 8, 4),JS=1,9),JT=1,5) /
     &3.1654E-04,4.1629E-04,4.3839E-04,4.3773E-04,4.1826E-04,3.8213E-04,
     &3.2793E-04,2.5576E-04,1.2647E-04,3.2537E-04,4.2537E-04,4.4661E-04,
     &4.4494E-04,4.2500E-04,3.8879E-04,3.3490E-04,2.6206E-04,1.2938E-04,
     &3.3408E-04,4.3504E-04,4.5626E-04,4.5382E-04,4.3360E-04,3.9751E-04,
     &3.4272E-04,2.6854E-04,1.3239E-04,3.4318E-04,4.4480E-04,4.6645E-04,
     &4.6411E-04,4.4358E-04,4.0695E-04,3.5185E-04,2.7598E-04,1.3521E-04,
     &3.5364E-04,4.5591E-04,4.7748E-04,4.7551E-04,4.5523E-04,4.1803E-04,
     &3.6238E-04,2.8454E-04,1.3901E-04/
      DATA ((KA(JS,JT, 9, 4),JS=1,9),JT=1,5) /
     &1.1778E-03,1.2542E-03,1.1993E-03,1.1088E-03,9.9621E-04,8.5814E-04,
     &6.9027E-04,4.7338E-04,1.4222E-04,1.2148E-03,1.2865E-03,1.2285E-03,
     &1.1318E-03,1.0140E-03,8.7230E-04,7.0194E-04,4.8264E-04,1.4691E-04,
     &1.2493E-03,1.3197E-03,1.2603E-03,1.1590E-03,1.0363E-03,8.9016E-04,
     &7.1481E-04,4.9330E-04,1.5194E-04,1.2842E-03,1.3516E-03,1.2898E-03,
     &1.1881E-03,1.0607E-03,9.1030E-04,7.3056E-04,5.0488E-04,1.5874E-04,
     &1.3233E-03,1.3878E-03,1.3225E-03,1.2203E-03,1.0882E-03,9.3354E-04,
     &7.4949E-04,5.1819E-04,1.6715E-04/
      DATA ((KA(JS,JT,10, 4),JS=1,9),JT=1,5) /
     &4.9223E-03,4.6924E-03,4.2372E-03,3.7210E-03,3.1598E-03,2.5466E-03,
     &1.8894E-03,1.1610E-03,2.5902E-04,5.1019E-03,4.8420E-03,4.3700E-03,
     &3.8242E-03,3.2382E-03,2.6075E-03,1.9274E-03,1.1773E-03,2.7993E-04,
     &5.2624E-03,4.9912E-03,4.4976E-03,3.9326E-03,3.3295E-03,2.6789E-03,
     &1.9739E-03,1.2013E-03,2.9275E-04,5.4202E-03,5.1325E-03,4.6211E-03,
     &4.0415E-03,3.4179E-03,2.7474E-03,2.0231E-03,1.2303E-03,3.0514E-04,
     &5.5922E-03,5.2716E-03,4.7430E-03,4.1489E-03,3.5047E-03,2.8180E-03,
     &2.0794E-03,1.2643E-03,3.1858E-04/
      DATA ((KA(JS,JT,11, 4),JS=1,9),JT=1,5) /
     &7.2623E-03,6.7979E-03,6.0744E-03,5.2843E-03,4.4298E-03,3.5303E-03,
     &2.5670E-03,1.5127E-03,3.1480E-04,7.5607E-03,7.0506E-03,6.2894E-03,
     &5.4629E-03,4.5682E-03,3.6306E-03,2.6328E-03,1.5436E-03,3.2537E-04,
     &7.8471E-03,7.2956E-03,6.4988E-03,5.6385E-03,4.7125E-03,3.7379E-03,
     &2.7029E-03,1.5776E-03,3.3231E-04,8.1128E-03,7.5290E-03,6.7020E-03,
     &5.8093E-03,4.8535E-03,3.8422E-03,2.7753E-03,1.6189E-03,3.4203E-04,
     &8.3759E-03,7.7545E-03,6.8899E-03,5.9710E-03,4.9875E-03,3.9509E-03,
     &2.8575E-03,1.6684E-03,3.5725E-04/
      DATA ((KA(JS,JT,12, 4),JS=1,9),JT=1,5) /
     &8.0096E-03,7.4190E-03,6.5933E-03,5.7152E-03,4.7757E-03,3.7806E-03,
     &2.7237E-03,1.5850E-03,3.0906E-04,8.3245E-03,7.6924E-03,6.8377E-03,
     &5.9147E-03,4.9319E-03,3.8997E-03,2.8053E-03,1.6213E-03,3.1505E-04,
     &8.6504E-03,7.9748E-03,7.0681E-03,6.1123E-03,5.0902E-03,4.0202E-03,
     &2.8850E-03,1.6649E-03,3.2236E-04,8.9354E-03,8.2303E-03,7.2913E-03,
     &6.2946E-03,5.2436E-03,4.1358E-03,2.9697E-03,1.7144E-03,3.2906E-04,
     &9.2169E-03,8.4842E-03,7.5093E-03,6.4790E-03,5.3967E-03,4.2618E-03,
     &3.0601E-03,1.7687E-03,3.3757E-04/
      DATA ((KA(JS,JT,13, 4),JS=1,9),JT=1,5) /
     &7.1631E-03,6.6319E-03,5.8920E-03,5.0960E-03,4.2500E-03,3.3594E-03,
     &2.4169E-03,1.3985E-03,2.7237E-04,7.4650E-03,6.8721E-03,6.1020E-03,
     &5.2700E-03,4.3954E-03,3.4698E-03,2.4897E-03,1.4341E-03,2.7736E-04,
     &7.7609E-03,7.1282E-03,6.3106E-03,5.4462E-03,4.5330E-03,3.5736E-03,
     &2.5636E-03,1.4770E-03,2.8124E-04,8.0101E-03,7.3618E-03,6.5123E-03,
     &5.6158E-03,4.6733E-03,3.6861E-03,2.6445E-03,1.5233E-03,2.8716E-04,
     &8.2606E-03,7.6008E-03,6.7314E-03,5.7990E-03,4.8288E-03,3.8083E-03,
     &2.7261E-03,1.5712E-03,2.9686E-04/
      DATA ((KA(JS,JT, 1, 5),JS=1,9),JT=1,5) /
     &1.3739E-05,1.5137E-04,2.5878E-04,3.6225E-04,4.6522E-04,5.7109E-04,
     &6.9199E-04,8.4168E-04,8.0480E-04,1.3888E-05,1.5627E-04,2.6885E-04,
     &3.7698E-04,4.8125E-04,5.9114E-04,7.1164E-04,8.7936E-04,8.3421E-04,
     &1.4142E-05,1.6264E-04,2.8096E-04,3.9281E-04,5.0319E-04,6.1580E-04,
     &7.3800E-04,9.1340E-04,8.6788E-04,1.4278E-05,1.6909E-04,2.9347E-04,
     &4.1125E-04,5.2641E-04,6.4515E-04,7.7492E-04,9.4989E-04,9.0996E-04,
     &1.4494E-05,1.7605E-04,3.0657E-04,4.3067E-04,5.5274E-04,6.7670E-04,
     &8.1211E-04,9.9682E-04,9.5292E-04/
      DATA ((KA(JS,JT, 2, 5),JS=1,9),JT=1,5) /
     &1.8692E-05,1.5213E-04,2.4704E-04,3.3748E-04,4.2434E-04,5.1189E-04,
     &6.0610E-04,7.3668E-04,6.9411E-04,1.8918E-05,1.5679E-04,2.5663E-04,
     &3.5044E-04,4.4175E-04,5.3243E-04,6.2710E-04,7.5567E-04,7.2022E-04,
     &1.9322E-05,1.6205E-04,2.6764E-04,3.6642E-04,4.6108E-04,5.5570E-04,
     &6.5662E-04,7.8535E-04,7.5176E-04,1.9585E-05,1.6765E-04,2.7850E-04,
     &3.8286E-04,4.8359E-04,5.8272E-04,6.8652E-04,8.2260E-04,7.8717E-04,
     &1.9818E-05,1.7339E-04,2.8992E-04,3.9889E-04,5.0485E-04,6.1010E-04,
     &7.2141E-04,8.6363E-04,8.2436E-04/
      DATA ((KA(JS,JT, 3, 5),JS=1,9),JT=1,5) /
     &3.4262E-05,1.7533E-04,2.6113E-04,3.3571E-04,4.0540E-04,4.7229E-04,
     &5.3818E-04,6.1661E-04,5.8845E-04,3.4716E-05,1.7923E-04,2.6899E-04,
     &3.4836E-04,4.2096E-04,4.9023E-04,5.6025E-04,6.3703E-04,6.0869E-04,
     &3.5292E-05,1.8347E-04,2.7811E-04,3.6147E-04,4.3915E-04,5.1242E-04,
     &5.8378E-04,6.6557E-04,6.3564E-04,3.6120E-05,1.8884E-04,2.8797E-04,
     &3.7545E-04,4.5740E-04,5.3560E-04,6.1221E-04,6.9822E-04,6.6452E-04,
     &3.6636E-05,1.9428E-04,2.9738E-04,3.9013E-04,4.7606E-04,5.5790E-04,
     &6.3990E-04,7.3219E-04,6.9591E-04/
      DATA ((KA(JS,JT, 4, 5),JS=1,9),JT=1,5) /
     &6.3937E-05,2.1416E-04,2.9895E-04,3.6305E-04,4.1697E-04,4.6136E-04,
     &4.9950E-04,5.3752E-04,4.9755E-04,6.4891E-05,2.1788E-04,3.0564E-04,
     &3.7373E-04,4.2957E-04,4.7819E-04,5.1730E-04,5.5769E-04,5.1340E-04,
     &6.5931E-05,2.2256E-04,3.1273E-04,3.8551E-04,4.4411E-04,4.9569E-04,
     &5.4027E-04,5.8134E-04,5.3558E-04,6.7204E-05,2.2716E-04,3.2137E-04,
     &3.9776E-04,4.6059E-04,5.1431E-04,5.6246E-04,6.0834E-04,5.5897E-04,
     &6.9088E-05,2.3323E-04,3.3076E-04,4.1010E-04,4.7742E-04,5.3504E-04,
     &5.8525E-04,6.3600E-04,5.8418E-04/
      DATA ((KA(JS,JT, 5, 5),JS=1,9),JT=1,5) /
     &1.0861E-04,2.6518E-04,3.4675E-04,4.0531E-04,4.4642E-04,4.7448E-04,
     &4.8963E-04,4.9041E-04,4.2330E-04,1.1058E-04,2.6952E-04,3.5268E-04,
     &4.1375E-04,4.5888E-04,4.8791E-04,5.0614E-04,5.0767E-04,4.3569E-04,
     &1.1255E-04,2.7465E-04,3.6022E-04,4.2322E-04,4.7137E-04,5.0379E-04,
     &5.2287E-04,5.2860E-04,4.5259E-04,1.1490E-04,2.8064E-04,3.6839E-04,
     &4.3377E-04,4.8454E-04,5.2116E-04,5.4180E-04,5.5017E-04,4.7054E-04,
     &1.1845E-04,2.8778E-04,3.7745E-04,4.4611E-04,4.9985E-04,5.3937E-04,
     &5.6277E-04,5.7154E-04,4.9105E-04/
      DATA ((KA(JS,JT, 6, 5),JS=1,9),JT=1,5) /
     &1.7235E-04,3.3181E-04,4.0736E-04,4.5766E-04,4.8926E-04,5.0113E-04,
     &4.9597E-04,4.6976E-04,3.5862E-04,1.7547E-04,3.3667E-04,4.1414E-04,
     &4.6509E-04,4.9861E-04,5.1384E-04,5.0976E-04,4.8537E-04,3.6976E-04,
     &1.7903E-04,3.4304E-04,4.2198E-04,4.7494E-04,5.0792E-04,5.2713E-04,
     &5.2630E-04,5.0120E-04,3.8272E-04,1.8326E-04,3.5076E-04,4.3097E-04,
     &4.8545E-04,5.2030E-04,5.4158E-04,5.4362E-04,5.1767E-04,3.9660E-04,
     &1.8798E-04,3.5938E-04,4.4150E-04,4.9742E-04,5.3429E-04,5.5639E-04,
     &5.6101E-04,5.3674E-04,4.1415E-04/
      DATA ((KA(JS,JT, 7, 5),JS=1,9),JT=1,5) /
     &2.9155E-04,4.4941E-04,5.1334E-04,5.5160E-04,5.6796E-04,5.6534E-04,
     &5.3624E-04,4.7508E-04,3.0367E-04,2.9728E-04,4.5662E-04,5.2104E-04,
     &5.6062E-04,5.7827E-04,5.7448E-04,5.4737E-04,4.8748E-04,3.1275E-04,
     &3.0362E-04,4.6646E-04,5.3089E-04,5.7148E-04,5.9016E-04,5.8669E-04,
     &5.6081E-04,5.0270E-04,3.2221E-04,3.1074E-04,4.7852E-04,5.4299E-04,
     &5.8375E-04,6.0313E-04,6.0067E-04,5.7534E-04,5.1934E-04,3.3373E-04,
     &3.1895E-04,4.9180E-04,5.5670E-04,5.9847E-04,6.1763E-04,6.1617E-04,
     &5.9045E-04,5.3590E-04,3.4594E-04/
      DATA ((KA(JS,JT, 8, 5),JS=1,9),JT=1,5) /
     &5.8477E-04,7.4431E-04,7.7278E-04,7.7426E-04,7.5736E-04,7.1816E-04,
     &6.5106E-04,5.3737E-04,2.7725E-04,5.9470E-04,7.5491E-04,7.8490E-04,
     &7.8595E-04,7.6803E-04,7.3022E-04,6.6291E-04,5.4897E-04,2.8497E-04,
     &6.0851E-04,7.7097E-04,8.0204E-04,8.0136E-04,7.8218E-04,7.4418E-04,
     &6.7668E-04,5.6182E-04,2.9265E-04,6.2426E-04,7.9122E-04,8.2299E-04,
     &8.2167E-04,7.9967E-04,7.6040E-04,6.9192E-04,5.7414E-04,3.0175E-04,
     &6.4049E-04,8.1349E-04,8.4675E-04,8.4414E-04,8.2107E-04,7.7949E-04,
     &7.0895E-04,5.8878E-04,3.1239E-04/
      DATA ((KA(JS,JT, 9, 5),JS=1,9),JT=1,5) /
     &2.2196E-03,2.3078E-03,2.1925E-03,2.0227E-03,1.7963E-03,1.5336E-03,
     &1.2354E-03,8.8457E-04,3.2582E-04,2.2570E-03,2.3473E-03,2.2277E-03,
     &2.0540E-03,1.8274E-03,1.5588E-03,1.2524E-03,8.9724E-04,3.2676E-04,
     &2.3089E-03,2.3978E-03,2.2707E-03,2.0928E-03,1.8651E-03,1.5919E-03,
     &1.2779E-03,9.1370E-04,3.3500E-04,2.3733E-03,2.4602E-03,2.3315E-03,
     &2.1419E-03,1.9119E-03,1.6319E-03,1.3090E-03,9.3384E-04,3.3899E-04,
     &2.4406E-03,2.5271E-03,2.3986E-03,2.2033E-03,1.9655E-03,1.6770E-03,
     &1.3445E-03,9.5837E-04,3.4762E-04/
      DATA ((KA(JS,JT,10, 5),JS=1,9),JT=1,5) /
     &9.4839E-03,8.9137E-03,7.9871E-03,6.9719E-03,5.8780E-03,4.7134E-03,
     &3.4759E-03,2.1070E-03,4.8830E-04,9.6557E-03,9.0801E-03,8.1340E-03,
     &7.0972E-03,5.9780E-03,4.7945E-03,3.5398E-03,2.1454E-03,4.8857E-04,
     &9.8746E-03,9.2754E-03,8.2985E-03,7.2339E-03,6.1011E-03,4.8911E-03,
     &3.6103E-03,2.1918E-03,5.0136E-04,1.0155E-02,9.5179E-03,8.5070E-03,
     &7.4122E-03,6.2501E-03,5.0174E-03,3.7003E-03,2.2452E-03,5.1609E-04,
     &1.0472E-02,9.8032E-03,8.7668E-03,7.6331E-03,6.4389E-03,5.1659E-03,
     &3.8012E-03,2.3067E-03,5.2606E-04/
      DATA ((KA(JS,JT,11, 5),JS=1,9),JT=1,5) /
     &1.4268E-02,1.3170E-02,1.1684E-02,1.0078E-02,8.4022E-03,6.6241E-03,
     &4.7723E-03,2.7954E-03,5.2361E-04,1.4540E-02,1.3417E-02,1.1900E-02,
     &1.0250E-02,8.5500E-03,6.7539E-03,4.8654E-03,2.8533E-03,5.3348E-04,
     &1.4880E-02,1.3732E-02,1.2163E-02,1.0481E-02,8.7324E-03,6.9009E-03,
     &4.9833E-03,2.9218E-03,5.5883E-04,1.5319E-02,1.4123E-02,1.2507E-02,
     &1.0772E-02,8.9669E-03,7.0955E-03,5.1189E-03,2.9943E-03,5.8850E-04,
     &1.5835E-02,1.4577E-02,1.2919E-02,1.1125E-02,9.2533E-03,7.3128E-03,
     &5.2667E-03,3.0792E-03,6.1073E-04/
      DATA ((KA(JS,JT,12, 5),JS=1,9),JT=1,5) /
     &1.5802E-02,1.4518E-02,1.2819E-02,1.1003E-02,9.1252E-03,7.1742E-03,
     &5.1262E-03,2.9592E-03,5.0816E-04,1.6146E-02,1.4810E-02,1.3074E-02,
     &1.1225E-02,9.3090E-03,7.3135E-03,5.2412E-03,3.0249E-03,5.3398E-04,
     &1.6565E-02,1.5205E-02,1.3415E-02,1.1514E-02,9.5432E-03,7.5058E-03,
     &5.3826E-03,3.1020E-03,5.6164E-04,1.7128E-02,1.5682E-02,1.3836E-02,
     &1.1883E-02,9.8516E-03,7.7437E-03,5.5313E-03,3.1868E-03,5.8823E-04,
     &1.7790E-02,1.6267E-02,1.4348E-02,1.2311E-02,1.0183E-02,7.9904E-03,
     &5.7100E-03,3.2821E-03,6.0779E-04/
      DATA ((KA(JS,JT,13, 5),JS=1,9),JT=1,5) /
     &1.4021E-02,1.2885E-02,1.1370E-02,9.7666E-03,8.0956E-03,6.3531E-03,
     &4.5485E-03,2.6326E-03,4.6002E-04,1.4373E-02,1.3207E-02,1.1632E-02,
     &9.9865E-03,8.2754E-03,6.5087E-03,4.6669E-03,2.6967E-03,4.8163E-04,
     &1.4774E-02,1.3588E-02,1.1994E-02,1.0306E-02,8.5450E-03,6.7168E-03,
     &4.8089E-03,2.7710E-03,4.9996E-04,1.5343E-02,1.4084E-02,1.2424E-02,
     &1.0664E-02,8.8287E-03,6.9355E-03,4.9590E-03,2.8556E-03,5.2093E-04,
     &1.5979E-02,1.4619E-02,1.2888E-02,1.1066E-02,9.1632E-03,7.1872E-03,
     &5.1400E-03,2.9489E-03,5.4238E-04/
      DATA ((KA(JS,JT, 1, 6),JS=1,9),JT=1,5) /
     &2.4381E-05,3.5965E-04,6.3963E-04,9.0999E-04,1.1781E-03,1.4492E-03,
     &1.7469E-03,2.1949E-03,2.0167E-03,2.4551E-05,3.6820E-04,6.5359E-04,
     &9.2911E-04,1.2030E-03,1.4796E-03,1.7884E-03,2.2546E-03,2.0633E-03,
     &2.4844E-05,3.7777E-04,6.7015E-04,9.5166E-04,1.2316E-03,1.5153E-03,
     &1.8326E-03,2.3125E-03,2.1171E-03,2.5013E-05,3.8840E-04,6.8929E-04,
     &9.7743E-04,1.2638E-03,1.5559E-03,1.8833E-03,2.3873E-03,2.1814E-03,
     &2.5349E-05,4.0094E-04,7.1137E-04,1.0079E-03,1.3021E-03,1.6023E-03,
     &1.9431E-03,2.4704E-03,2.2554E-03/
      DATA ((KA(JS,JT, 2, 6),JS=1,9),JT=1,5) /
     &3.3532E-05,3.4195E-04,5.9227E-04,8.3115E-04,1.0659E-03,1.2984E-03,
     &1.5375E-03,1.8307E-03,1.7555E-03,3.3884E-05,3.4950E-04,6.0496E-04,
     &8.4827E-04,1.0865E-03,1.3240E-03,1.5683E-03,1.8747E-03,1.7936E-03,
     &3.4432E-05,3.5837E-04,6.1975E-04,8.6913E-04,1.1113E-03,1.3536E-03,
     &1.6021E-03,1.9222E-03,1.8373E-03,3.4886E-05,3.6829E-04,6.3662E-04,
     &8.9220E-04,1.1391E-03,1.3857E-03,1.6406E-03,1.9755E-03,1.8873E-03,
     &3.5279E-05,3.7968E-04,6.5599E-04,9.1909E-04,1.1730E-03,1.4257E-03,
     &1.6862E-03,2.0365E-03,1.9484E-03/
      DATA ((KA(JS,JT, 3, 6),JS=1,9),JT=1,5) /
     &6.2269E-05,3.6578E-04,5.8707E-04,7.9355E-04,9.9285E-04,1.1848E-03,
     &1.3757E-03,1.5822E-03,1.5104E-03,6.2987E-05,3.7248E-04,5.9883E-04,
     &8.1016E-04,1.0136E-03,1.2090E-03,1.4023E-03,1.6140E-03,1.5440E-03,
     &6.3830E-05,3.8077E-04,6.1238E-04,8.2947E-04,1.0380E-03,1.2373E-03,
     &1.4338E-03,1.6476E-03,1.5800E-03,6.5057E-05,3.9038E-04,6.2908E-04,
     &8.5186E-04,1.0655E-03,1.2690E-03,1.4686E-03,1.6847E-03,1.6204E-03,
     &6.5891E-05,4.0010E-04,6.4778E-04,8.7680E-04,1.0962E-03,1.3060E-03,
     &1.5104E-03,1.7307E-03,1.6697E-03/
      DATA ((KA(JS,JT, 4, 6),JS=1,9),JT=1,5) /
     &1.1763E-04,4.2852E-04,6.2857E-04,8.0251E-04,9.6160E-04,1.1103E-03,
     &1.2549E-03,1.3952E-03,1.2948E-03,1.1903E-04,4.3548E-04,6.3935E-04,
     &8.1698E-04,9.8074E-04,1.1338E-03,1.2810E-03,1.4231E-03,1.3227E-03,
     &1.2084E-04,4.4304E-04,6.5330E-04,8.3469E-04,1.0028E-03,1.1604E-03,
     &1.3104E-03,1.4544E-03,1.3535E-03,1.2295E-04,4.5274E-04,6.6888E-04,
     &8.5565E-04,1.0277E-03,1.1905E-03,1.3437E-03,1.4894E-03,1.3881E-03,
     &1.2576E-04,4.6369E-04,6.8705E-04,8.8171E-04,1.0587E-03,1.2251E-03,
     &1.3822E-03,1.5303E-03,1.4309E-03/
      DATA ((KA(JS,JT, 5, 6),JS=1,9),JT=1,5) /
     &2.0248E-04,5.1976E-04,7.0294E-04,8.5252E-04,9.7761E-04,1.0816E-03,
     &1.1680E-03,1.2476E-03,1.1044E-03,2.0493E-04,5.2640E-04,7.1432E-04,
     &8.6690E-04,9.9395E-04,1.1019E-03,1.1914E-03,1.2719E-03,1.1285E-03,
     &2.0806E-04,5.3477E-04,7.2739E-04,8.8542E-04,1.0148E-03,1.1250E-03,
     &1.2182E-03,1.3005E-03,1.1542E-03,2.1205E-04,5.4496E-04,7.4280E-04,
     &9.0607E-04,1.0399E-03,1.1525E-03,1.2484E-03,1.3331E-03,1.1843E-03,
     &2.1768E-04,5.5787E-04,7.6255E-04,9.3016E-04,1.0697E-03,1.1863E-03,
     &1.2845E-03,1.3711E-03,1.2208E-03/
      DATA ((KA(JS,JT, 6, 6),JS=1,9),JT=1,5) /
     &3.2402E-04,6.5065E-04,8.1276E-04,9.3175E-04,1.0254E-03,1.0960E-03,
     &1.1336E-03,1.1359E-03,9.3926E-04,3.2839E-04,6.5803E-04,8.2121E-04,
     &9.4691E-04,1.0426E-03,1.1132E-03,1.1537E-03,1.1594E-03,9.5631E-04,
     &3.3397E-04,6.6749E-04,8.3425E-04,9.6403E-04,1.0654E-03,1.1356E-03,
     &1.1768E-03,1.1847E-03,9.7614E-04,3.4074E-04,6.7873E-04,8.5077E-04,
     &9.8417E-04,1.0893E-03,1.1622E-03,1.2041E-03,1.2139E-03,1.0001E-03,
     &3.4865E-04,6.9287E-04,8.6902E-04,1.0071E-03,1.1162E-03,1.1933E-03,
     &1.2370E-03,1.2465E-03,1.0295E-03/
      DATA ((KA(JS,JT, 7, 6),JS=1,9),JT=1,5) /
     &5.4679E-04,8.8419E-04,1.0272E-03,1.1131E-03,1.1586E-03,1.1796E-03,
     &1.1677E-03,1.1006E-03,7.9375E-04,5.5453E-04,8.9535E-04,1.0406E-03,
     &1.1278E-03,1.1758E-03,1.1986E-03,1.1860E-03,1.1193E-03,8.0863E-04,
     &5.6482E-04,9.0803E-04,1.0560E-03,1.1451E-03,1.1955E-03,1.2220E-03,
     &1.2089E-03,1.1408E-03,8.2565E-04,5.7672E-04,9.2334E-04,1.0748E-03,
     &1.1654E-03,1.2195E-03,1.2479E-03,1.2361E-03,1.1655E-03,8.4564E-04,
     &5.9187E-04,9.4280E-04,1.0968E-03,1.1862E-03,1.2479E-03,1.2773E-03,
     &1.2677E-03,1.1958E-03,8.6975E-04/
      DATA ((KA(JS,JT, 8, 6),JS=1,9),JT=1,5) /
     &1.0890E-03,1.4212E-03,1.5274E-03,1.5635E-03,1.5408E-03,1.4729E-03,
     &1.3514E-03,1.1730E-03,6.7724E-04,1.1074E-03,1.4404E-03,1.5493E-03,
     &1.5864E-03,1.5647E-03,1.4941E-03,1.3720E-03,1.1894E-03,6.8838E-04,
     &1.1299E-03,1.4626E-03,1.5727E-03,1.6115E-03,1.5892E-03,1.5170E-03,
     &1.3954E-03,1.2114E-03,7.0024E-04,1.1562E-03,1.4908E-03,1.6005E-03,
     &1.6404E-03,1.6196E-03,1.5467E-03,1.4229E-03,1.2388E-03,7.1485E-04,
     &1.1885E-03,1.5267E-03,1.6357E-03,1.6752E-03,1.6528E-03,1.5764E-03,
     &1.4553E-03,1.2696E-03,7.3183E-04/
      DATA ((KA(JS,JT, 9, 6),JS=1,9),JT=1,5) /
     &4.1665E-03,4.3468E-03,4.1293E-03,3.8165E-03,3.4449E-03,3.0107E-03,
     &2.4884E-03,1.8186E-03,7.0770E-04,4.2379E-03,4.4019E-03,4.1804E-03,
     &3.8702E-03,3.4962E-03,3.0618E-03,2.5301E-03,1.8480E-03,7.1084E-04,
     &4.3206E-03,4.4730E-03,4.2494E-03,3.9358E-03,3.5562E-03,3.1108E-03,
     &2.5726E-03,1.8787E-03,7.1447E-04,4.4148E-03,4.5672E-03,4.3360E-03,
     &4.0233E-03,3.6279E-03,3.1667E-03,2.6211E-03,1.9152E-03,7.2547E-04,
     &4.5366E-03,4.6880E-03,4.4475E-03,4.1247E-03,3.7148E-03,3.2357E-03,
     &2.6777E-03,1.9564E-03,7.3351E-04/
      DATA ((KA(JS,JT,10, 6),JS=1,9),JT=1,5) /
     &1.8255E-02,1.7198E-02,1.5391E-02,1.3391E-02,1.1273E-02,9.0394E-03,
     &6.6601E-03,4.0944E-03,9.8389E-04,1.8579E-02,1.7439E-02,1.5601E-02,
     &1.3577E-02,1.1427E-02,9.1759E-03,6.7580E-03,4.1605E-03,9.8485E-04,
     &1.8934E-02,1.7772E-02,1.5898E-02,1.3821E-02,1.1616E-02,9.3279E-03,
     &6.8809E-03,4.2287E-03,9.8296E-04,1.9364E-02,1.8152E-02,1.6246E-02,
     &1.4125E-02,1.1868E-02,9.5176E-03,7.0263E-03,4.3137E-03,9.8595E-04,
     &1.9876E-02,1.8605E-02,1.6643E-02,1.4478E-02,1.2165E-02,9.7573E-03,
     &7.2015E-03,4.4138E-03,9.9549E-04/
      DATA ((KA(JS,JT,11, 6),JS=1,9),JT=1,5) /
     &2.7906E-02,2.5779E-02,2.2845E-02,1.9689E-02,1.6356E-02,1.2926E-02,
     &9.3112E-03,5.4266E-03,1.1493E-03,2.8474E-02,2.6276E-02,2.3282E-02,
     &2.0063E-02,1.6649E-02,1.3118E-02,9.4591E-03,5.5176E-03,1.1605E-03,
     &2.9161E-02,2.6826E-02,2.3755E-02,2.0435E-02,1.6944E-02,1.3356E-02,
     &9.6281E-03,5.6370E-03,1.1658E-03,2.9864E-02,2.7446E-02,2.4305E-02,
     &2.0907E-02,1.7344E-02,1.3665E-02,9.8501E-03,5.7787E-03,1.1679E-03,
     &3.0716E-02,2.8218E-02,2.4989E-02,2.1484E-02,1.7837E-02,1.4047E-02,
     &1.0137E-02,5.9391E-03,1.1749E-03/
      DATA ((KA(JS,JT,12, 6),JS=1,9),JT=1,5) /
     &3.1456E-02,2.8840E-02,2.5490E-02,2.1901E-02,1.8104E-02,1.4184E-02,
     &1.0144E-02,5.8131E-03,1.1656E-03,3.2212E-02,2.9507E-02,2.6048E-02,
     &2.2347E-02,1.8450E-02,1.4457E-02,1.0325E-02,5.9330E-03,1.1607E-03,
     &3.2965E-02,3.0133E-02,2.6613E-02,2.2834E-02,1.8888E-02,1.4793E-02,
     &1.0553E-02,6.0675E-03,1.1612E-03,3.3903E-02,3.0999E-02,2.7365E-02,
     &2.3453E-02,1.9368E-02,1.5160E-02,1.0832E-02,6.2310E-03,1.1792E-03,
     &3.4986E-02,3.1940E-02,2.8176E-02,2.4131E-02,1.9947E-02,1.5618E-02,
     &1.1156E-02,6.4247E-03,1.2061E-03/
      DATA ((KA(JS,JT,13, 6),JS=1,9),JT=1,5) /
     &2.8494E-02,2.6140E-02,2.3086E-02,1.9829E-02,1.6410E-02,1.2869E-02,
     &9.1750E-03,5.2477E-03,1.0839E-03,2.9204E-02,2.6786E-02,2.3660E-02,
     &2.0312E-02,1.6791E-02,1.3151E-02,9.3741E-03,5.3670E-03,1.0879E-03,
     &3.0028E-02,2.7500E-02,2.4267E-02,2.0802E-02,1.7182E-02,1.3458E-02,
     &9.5924E-03,5.5018E-03,1.1043E-03,3.0958E-02,2.8295E-02,2.4961E-02,
     &2.1395E-02,1.7690E-02,1.3840E-02,9.8578E-03,5.6588E-03,1.1197E-03,
     &3.2042E-02,2.9250E-02,2.5779E-02,2.2082E-02,1.8250E-02,1.4290E-02,
     &1.0177E-02,5.8420E-03,1.1367E-03/
      DATA ((KA(JS,JT, 1, 7),JS=1,9),JT=1,5) /
     &4.8330E-05,9.1748E-04,1.6343E-03,2.3037E-03,2.9566E-03,3.6315E-03,
     &4.4475E-03,5.8406E-03,5.3151E-03,4.8596E-05,9.3271E-04,1.6606E-03,
     &2.3393E-03,3.0027E-03,3.6916E-03,4.5243E-03,5.9244E-03,5.4196E-03,
     &4.9220E-05,9.5049E-04,1.6928E-03,2.3820E-03,3.0582E-03,3.7632E-03,
     &4.6161E-03,6.0368E-03,5.5387E-03,4.9714E-05,9.7063E-04,1.7276E-03,
     &2.4311E-03,3.1220E-03,3.8430E-03,4.7205E-03,6.1613E-03,5.6708E-03,
     &5.0550E-05,9.9274E-04,1.7651E-03,2.4850E-03,3.1923E-03,3.9328E-03,
     &4.8316E-03,6.3027E-03,5.8156E-03/
      DATA ((KA(JS,JT, 2, 7),JS=1,9),JT=1,5) /
     &6.7697E-05,8.5995E-04,1.5004E-03,2.0933E-03,2.6519E-03,3.1963E-03,
     &3.7792E-03,4.6863E-03,4.4711E-03,6.8123E-05,8.7528E-04,1.5266E-03,
     &2.1301E-03,2.6961E-03,3.2484E-03,3.8450E-03,4.7682E-03,4.5579E-03,
     &6.9098E-05,8.9351E-04,1.5568E-03,2.1723E-03,2.7472E-03,3.3096E-03,
     &3.9205E-03,4.8697E-03,4.6570E-03,7.0075E-05,9.1426E-04,1.5908E-03,
     &2.2183E-03,2.8071E-03,3.3815E-03,4.0084E-03,4.9811E-03,4.7715E-03,
     &7.1192E-05,9.3706E-04,1.6283E-03,2.2693E-03,2.8718E-03,3.4625E-03,
     &4.1070E-03,5.1037E-03,4.8979E-03/
      DATA ((KA(JS,JT, 3, 7),JS=1,9),JT=1,5) /
     &1.2733E-04,8.7624E-04,1.4506E-03,1.9805E-03,2.4757E-03,2.9317E-03,
     &3.3558E-03,3.8170E-03,3.7686E-03,1.2826E-04,8.9276E-04,1.4769E-03,
     &2.0153E-03,2.5174E-03,2.9784E-03,3.4075E-03,3.8801E-03,3.8344E-03,
     &1.2973E-04,9.1170E-04,1.5076E-03,2.0539E-03,2.5651E-03,3.0352E-03,
     &3.4680E-03,3.9525E-03,3.9125E-03,1.3225E-04,9.3418E-04,1.5436E-03,
     &2.1000E-03,2.6202E-03,3.1002E-03,3.5421E-03,4.0383E-03,4.0057E-03,
     &1.3440E-04,9.5794E-04,1.5825E-03,2.1509E-03,2.6822E-03,3.1720E-03,
     &3.6252E-03,4.1370E-03,4.1108E-03/
      DATA ((KA(JS,JT, 4, 7),JS=1,9),JT=1,5) /
     &2.4414E-04,9.8791E-04,1.4797E-03,1.9337E-03,2.3609E-03,2.7541E-03,
     &3.0988E-03,3.3862E-03,3.2303E-03,2.4513E-04,1.0039E-03,1.5070E-03,
     &1.9692E-03,2.4021E-03,2.7995E-03,3.1468E-03,3.4333E-03,3.2790E-03,
     &2.4808E-04,1.0229E-03,1.5373E-03,2.0098E-03,2.4481E-03,2.8491E-03,
     &3.2030E-03,3.4903E-03,3.3384E-03,2.5202E-04,1.0447E-03,1.5721E-03,
     &2.0572E-03,2.5035E-03,2.9093E-03,3.2672E-03,3.5611E-03,3.4115E-03,
     &2.5833E-04,1.0719E-03,1.6144E-03,2.1102E-03,2.5658E-03,2.9793E-03,
     &3.3418E-03,3.6423E-03,3.4938E-03/
      DATA ((KA(JS,JT, 5, 7),JS=1,9),JT=1,5) /
     &4.2770E-04,1.1830E-03,1.6220E-03,1.9840E-03,2.3123E-03,2.6214E-03,
     &2.8956E-03,3.0934E-03,2.7805E-03,4.3162E-04,1.2016E-03,1.6476E-03,
     &2.0183E-03,2.3523E-03,2.6652E-03,2.9419E-03,3.1389E-03,2.8192E-03,
     &4.3693E-04,1.2232E-03,1.6764E-03,2.0550E-03,2.3985E-03,2.7158E-03,
     &2.9926E-03,3.1918E-03,2.8694E-03,4.4235E-04,1.2462E-03,1.7099E-03,
     &2.0981E-03,2.4518E-03,2.7746E-03,3.0533E-03,3.2519E-03,2.9306E-03,
     &4.5257E-04,1.2739E-03,1.7526E-03,2.1524E-03,2.5133E-03,2.8432E-03,
     &3.1246E-03,3.3219E-03,2.9994E-03/
      DATA ((KA(JS,JT, 6, 7),JS=1,9),JT=1,5) /
     &6.9917E-04,1.4510E-03,1.8508E-03,2.1612E-03,2.3969E-03,2.5820E-03,
     &2.7369E-03,2.8411E-03,2.3809E-03,7.0685E-04,1.4737E-03,1.8819E-03,
     &2.1948E-03,2.4365E-03,2.6262E-03,2.7822E-03,2.8845E-03,2.4163E-03,
     &7.1685E-04,1.4992E-03,1.9139E-03,2.2300E-03,2.4777E-03,2.6750E-03,
     &2.8324E-03,2.9331E-03,2.4594E-03,7.2831E-04,1.5276E-03,1.9491E-03,
     &2.2715E-03,2.5262E-03,2.7293E-03,2.8927E-03,2.9913E-03,2.5109E-03,
     &7.4174E-04,1.5586E-03,1.9900E-03,2.3214E-03,2.5825E-03,2.7929E-03,
     &2.9629E-03,3.0587E-03,2.5688E-03/
      DATA ((KA(JS,JT, 7, 7),JS=1,9),JT=1,5) /
     &1.2039E-03,1.9587E-03,2.2962E-03,2.5331E-03,2.6974E-03,2.7733E-03,
     &2.7634E-03,2.6777E-03,2.0245E-03,1.2204E-03,1.9874E-03,2.3314E-03,
     &2.5722E-03,2.7404E-03,2.8207E-03,2.8122E-03,2.7221E-03,2.0503E-03,
     &1.2400E-03,2.0184E-03,2.3716E-03,2.6156E-03,2.7851E-03,2.8685E-03,
     &2.8623E-03,2.7709E-03,2.0844E-03,1.2633E-03,2.0537E-03,2.4164E-03,
     &2.6645E-03,2.8368E-03,2.9213E-03,2.9184E-03,2.8302E-03,2.1246E-03,
     &1.2880E-03,2.0946E-03,2.4660E-03,2.7241E-03,2.8956E-03,2.9852E-03,
     &2.9850E-03,2.8977E-03,2.1717E-03/
      DATA ((KA(JS,JT, 8, 7),JS=1,9),JT=1,5) /
     &2.4360E-03,3.2317E-03,3.4336E-03,3.4928E-03,3.4872E-03,3.3872E-03,
     &3.1811E-03,2.7989E-03,1.6994E-03,2.4784E-03,3.2772E-03,3.4707E-03,
     &3.5477E-03,3.5429E-03,3.4442E-03,3.2393E-03,2.8503E-03,1.7216E-03,
     &2.5215E-03,3.3205E-03,3.5181E-03,3.6097E-03,3.6079E-03,3.5043E-03,
     &3.2957E-03,2.9015E-03,1.7516E-03,2.5734E-03,3.3690E-03,3.5815E-03,
     &3.6774E-03,3.6742E-03,3.5696E-03,3.3583E-03,2.9597E-03,1.7852E-03,
     &2.6287E-03,3.4209E-03,3.6564E-03,3.7526E-03,3.7488E-03,3.6496E-03,
     &3.4322E-03,3.0257E-03,1.8234E-03/
      DATA ((KA(JS,JT, 9, 7),JS=1,9),JT=1,5) /
     &9.2016E-03,9.7823E-03,9.4145E-03,8.7411E-03,7.8879E-03,6.8736E-03,
     &5.6569E-03,4.2025E-03,1.5538E-03,9.3962E-03,9.9769E-03,9.5905E-03,
     &8.8876E-03,8.0147E-03,6.9737E-03,5.7408E-03,4.2797E-03,1.5748E-03,
     &9.5905E-03,1.0169E-02,9.7567E-03,9.0284E-03,8.1348E-03,7.0770E-03,
     &5.8473E-03,4.3619E-03,1.5893E-03,9.8163E-03,1.0370E-02,9.9309E-03,
     &9.1820E-03,8.2703E-03,7.1825E-03,5.9588E-03,4.4477E-03,1.6087E-03,
     &1.0054E-02,1.0584E-02,1.0131E-02,9.3626E-03,8.4298E-03,7.3350E-03,
     &6.0835E-03,4.5437E-03,1.6313E-03/
      DATA ((KA(JS,JT,10, 7),JS=1,9),JT=1,5) /
     &3.9276E-02,3.6749E-02,3.3301E-02,2.9241E-02,2.4794E-02,2.0028E-02,
     &1.4912E-02,9.3013E-03,2.0443E-03,4.0105E-02,3.7556E-02,3.4005E-02,
     &2.9863E-02,2.5353E-02,2.0438E-02,1.5180E-02,9.4819E-03,2.0242E-03,
     &4.0916E-02,3.8307E-02,3.4681E-02,3.0487E-02,2.5876E-02,2.0814E-02,
     &1.5451E-02,9.6638E-03,2.0047E-03,4.1894E-02,3.9199E-02,3.5443E-02,
     &3.1118E-02,2.6390E-02,2.1233E-02,1.5746E-02,9.8447E-03,2.0155E-03,
     &4.2954E-02,4.0161E-02,3.6290E-02,3.1839E-02,2.6971E-02,2.1693E-02,
     &1.6115E-02,1.0055E-02,2.0394E-03/
      DATA ((KA(JS,JT,11, 7),JS=1,9),JT=1,5) /
     &6.0955E-02,5.5737E-02,4.9723E-02,4.3019E-02,3.5876E-02,2.8379E-02,
     &2.0432E-02,1.2085E-02,2.3716E-03,6.2198E-02,5.6869E-02,5.0662E-02,
     &4.3787E-02,3.6565E-02,2.8915E-02,2.0814E-02,1.2323E-02,2.3542E-03,
     &6.3419E-02,5.8024E-02,5.1697E-02,4.4702E-02,3.7324E-02,2.9465E-02,
     &2.1204E-02,1.2555E-02,2.3313E-03,6.4926E-02,5.9386E-02,5.2869E-02,
     &4.5680E-02,3.8119E-02,3.0075E-02,2.1667E-02,1.2812E-02,2.3155E-03,
     &6.6635E-02,6.0864E-02,5.4124E-02,4.6774E-02,3.9011E-02,3.0829E-02,
     &2.2206E-02,1.3119E-02,2.3251E-03/
      DATA ((KA(JS,JT,12, 7),JS=1,9),JT=1,5) /
     &6.9869E-02,6.3637E-02,5.6420E-02,4.8546E-02,4.0307E-02,3.1740E-02,
     &2.2682E-02,1.3139E-02,2.4428E-03,7.1577E-02,6.5133E-02,5.7685E-02,
     &4.9634E-02,4.1244E-02,3.2466E-02,2.3165E-02,1.3402E-02,2.4417E-03,
     &7.3435E-02,6.6765E-02,5.9111E-02,5.0782E-02,4.2090E-02,3.3070E-02,
     &2.3631E-02,1.3663E-02,2.4312E-03,7.5274E-02,6.8406E-02,6.0539E-02,
     &5.2024E-02,4.3158E-02,3.3897E-02,2.4213E-02,1.3961E-02,2.4213E-03,
     &7.7518E-02,7.0447E-02,6.2339E-02,5.3608E-02,4.4457E-02,3.4884E-02,
     &2.4882E-02,1.4302E-02,2.4144E-03/
      DATA ((KA(JS,JT,13, 7),JS=1,9),JT=1,5) /
     &6.3971E-02,5.8270E-02,5.1535E-02,4.4263E-02,3.6709E-02,2.8872E-02,
     &2.0629E-02,1.1917E-02,2.3953E-03,6.5643E-02,5.9813E-02,5.2890E-02,
     &4.5419E-02,3.7684E-02,2.9600E-02,2.1119E-02,1.2188E-02,2.4046E-03,
     &6.7472E-02,6.1457E-02,5.4341E-02,4.6654E-02,3.8721E-02,3.0402E-02,
     &2.1696E-02,1.2486E-02,2.3922E-03,6.9579E-02,6.3365E-02,5.6023E-02,
     &4.8132E-02,3.9923E-02,3.1337E-02,2.2348E-02,1.2806E-02,2.3768E-03,
     &7.1993E-02,6.5596E-02,5.7974E-02,4.9776E-02,4.1204E-02,3.2317E-02,
     &2.3035E-02,1.3183E-02,2.3765E-03/
      DATA ((KA(JS,JT, 1, 8),JS=1,9),JT=1,5) /
     &1.3552E-04,2.4322E-03,4.1951E-03,5.8754E-03,7.6297E-03,9.6149E-03,
     &1.1994E-02,1.5380E-02,1.4856E-02,1.3805E-04,2.4459E-03,4.2175E-03,
     &5.9121E-03,7.6823E-03,9.6825E-03,1.2072E-02,1.5469E-02,1.4971E-02,
     &1.4131E-04,2.4661E-03,4.2478E-03,5.9602E-03,7.7525E-03,9.7747E-03,
     &1.2179E-02,1.5577E-02,1.5128E-02,1.4377E-04,2.4912E-03,4.2859E-03,
     &6.0170E-03,7.8373E-03,9.8887E-03,1.2314E-02,1.5728E-02,1.5316E-02,
     &1.4692E-04,2.5205E-03,4.3310E-03,6.0836E-03,7.9343E-03,1.0019E-02,
     &1.2473E-02,1.5904E-02,1.5528E-02/
      DATA ((KA(JS,JT, 2, 8),JS=1,9),JT=1,5) /
     &1.8928E-04,2.4121E-03,4.0623E-03,5.5541E-03,6.9898E-03,8.5008E-03,
     &1.0323E-02,1.3028E-02,1.2924E-02,1.9267E-04,2.4360E-03,4.0898E-03,
     &5.5901E-03,7.0384E-03,8.5652E-03,1.0405E-02,1.3116E-02,1.3041E-02,
     &1.9724E-04,2.4656E-03,4.1277E-03,5.6355E-03,7.0999E-03,8.6497E-03,
     &1.0515E-02,1.3234E-02,1.3193E-02,2.0128E-04,2.4981E-03,4.1715E-03,
     &5.6919E-03,7.1715E-03,8.7477E-03,1.0645E-02,1.3388E-02,1.3368E-02,
     &2.0477E-04,2.5328E-03,4.2216E-03,5.7557E-03,7.2538E-03,8.8556E-03,
     &1.0788E-02,1.3565E-02,1.3563E-02/
      DATA ((KA(JS,JT, 3, 8),JS=1,9),JT=1,5) /
     &3.5927E-04,2.5910E-03,4.2037E-03,5.6032E-03,6.8389E-03,7.9673E-03,
     &9.0787E-03,1.0659E-02,1.1075E-02,3.6570E-04,2.6231E-03,4.2518E-03,
     &5.6510E-03,6.8860E-03,8.0235E-03,9.1475E-03,1.0746E-02,1.1185E-02,
     &3.7255E-04,2.6596E-03,4.3088E-03,5.7121E-03,6.9479E-03,8.0889E-03,
     &9.2308E-03,1.0860E-02,1.1321E-02,3.8155E-04,2.7037E-03,4.3688E-03,
     &5.7837E-03,7.0219E-03,8.1712E-03,9.3303E-03,1.0993E-02,1.1473E-02,
     &3.8777E-04,2.7514E-03,4.4348E-03,5.8612E-03,7.1061E-03,8.2670E-03,
     &9.4452E-03,1.1141E-02,1.1658E-02/
      DATA ((KA(JS,JT, 4, 8),JS=1,9),JT=1,5) /
     &6.9620E-04,2.9029E-03,4.4649E-03,5.7896E-03,6.9152E-03,7.8788E-03,
     &8.6335E-03,9.2668E-03,9.4651E-03,7.1019E-04,2.9517E-03,4.5263E-03,
     &5.8664E-03,6.9912E-03,7.9468E-03,8.6984E-03,9.3401E-03,9.5623E-03,
     &7.2359E-04,3.0044E-03,4.5979E-03,5.9489E-03,7.0830E-03,8.0315E-03,
     &8.7768E-03,9.4291E-03,9.6859E-03,7.3828E-04,3.0619E-03,4.6789E-03,
     &6.0379E-03,7.1842E-03,8.1322E-03,8.8743E-03,9.5317E-03,9.8248E-03,
     &7.5535E-04,3.1266E-03,4.7671E-03,6.1369E-03,7.2972E-03,8.2469E-03,
     &8.9884E-03,9.6595E-03,9.9955E-03/
      DATA ((KA(JS,JT, 5, 8),JS=1,9),JT=1,5) /
     &1.2367E-03,3.3787E-03,4.7869E-03,5.9863E-03,7.0094E-03,7.8065E-03,
     &8.3893E-03,8.6393E-03,8.1050E-03,1.2606E-03,3.4408E-03,4.8727E-03,
     &6.0829E-03,7.1090E-03,7.9083E-03,8.4736E-03,8.7084E-03,8.1896E-03,
     &1.2858E-03,3.5058E-03,4.9695E-03,6.1896E-03,7.2184E-03,8.0235E-03,
     &8.5795E-03,8.7948E-03,8.2945E-03,1.3144E-03,3.5781E-03,5.0734E-03,
     &6.3066E-03,7.3381E-03,8.1502E-03,8.7050E-03,8.8972E-03,8.4098E-03,
     &1.3469E-03,3.6641E-03,5.1833E-03,6.4362E-03,7.4701E-03,8.2878E-03,
     &8.8414E-03,9.0166E-03,8.5483E-03/
      DATA ((KA(JS,JT, 6, 8),JS=1,9),JT=1,5) /
     &2.0401E-03,4.1601E-03,5.3408E-03,6.2948E-03,7.1082E-03,7.7648E-03,
     &8.1607E-03,8.2016E-03,6.9653E-03,2.0844E-03,4.2423E-03,5.4455E-03,
     &6.4160E-03,7.2313E-03,7.8855E-03,8.2759E-03,8.2810E-03,7.0331E-03,
     &2.1282E-03,4.3237E-03,5.5575E-03,6.5512E-03,7.3708E-03,8.0202E-03,
     &8.4033E-03,8.3806E-03,7.1162E-03,2.1756E-03,4.4109E-03,5.6792E-03,
     &6.6960E-03,7.5224E-03,8.1665E-03,8.5397E-03,8.4981E-03,7.2093E-03,
     &2.2255E-03,4.5091E-03,5.8068E-03,6.8485E-03,7.6856E-03,8.3228E-03,
     &8.6864E-03,8.6279E-03,7.3203E-03/
      DATA ((KA(JS,JT, 7, 8),JS=1,9),JT=1,5) /
     &3.5433E-03,5.7288E-03,6.6788E-03,7.3197E-03,7.7679E-03,8.0638E-03,
     &8.2036E-03,7.9558E-03,6.0055E-03,3.6269E-03,5.8458E-03,6.8139E-03,
     &7.4674E-03,7.9220E-03,8.2152E-03,8.3417E-03,8.0664E-03,6.0619E-03,
     &3.7095E-03,5.9702E-03,6.9487E-03,7.6264E-03,8.0952E-03,8.3842E-03,
     &8.4920E-03,8.1889E-03,6.1273E-03,3.7971E-03,6.0972E-03,7.0950E-03,
     &7.7981E-03,8.2789E-03,8.5668E-03,8.6571E-03,8.3173E-03,6.2019E-03,
     &3.8894E-03,6.2311E-03,7.2602E-03,7.9756E-03,8.4749E-03,8.7608E-03,
     &8.8292E-03,8.4586E-03,6.2926E-03/
      DATA ((KA(JS,JT, 8, 8),JS=1,9),JT=1,5) /
     &7.2384E-03,9.3960E-03,1.0099E-02,1.0331E-02,1.0208E-02,9.8199E-03,
     &9.1852E-03,8.2577E-03,5.1301E-03,7.4182E-03,9.6243E-03,1.0349E-02,
     &1.0556E-02,1.0419E-02,1.0021E-02,9.3680E-03,8.3968E-03,5.1752E-03,
     &7.6043E-03,9.8546E-03,1.0598E-02,1.0777E-02,1.0633E-02,1.0249E-02,
     &9.5676E-03,8.5508E-03,5.2269E-03,7.7980E-03,1.0094E-02,1.0836E-02,
     &1.1012E-02,1.0870E-02,1.0482E-02,9.7866E-03,8.7162E-03,5.2872E-03,
     &8.0005E-03,1.0352E-02,1.1093E-02,1.1272E-02,1.1127E-02,1.0726E-02,
     &1.0012E-02,8.8875E-03,5.3638E-03/
      DATA ((KA(JS,JT, 9, 8),JS=1,9),JT=1,5) /
     &2.7897E-02,2.8473E-02,2.7594E-02,2.5806E-02,2.3354E-02,2.0346E-02,
     &1.6782E-02,1.2341E-02,4.1787E-03,2.8638E-02,2.9187E-02,2.8303E-02,
     &2.6475E-02,2.3949E-02,2.0857E-02,1.7181E-02,1.2602E-02,4.2128E-03,
     &2.9413E-02,2.9901E-02,2.8994E-02,2.7143E-02,2.4571E-02,2.1381E-02,
     &1.7560E-02,1.2888E-02,4.2655E-03,3.0228E-02,3.0665E-02,2.9734E-02,
     &2.7828E-02,2.5188E-02,2.1923E-02,1.7970E-02,1.3183E-02,4.3190E-03,
     &3.1084E-02,3.1463E-02,3.0494E-02,2.8550E-02,2.5844E-02,2.2478E-02,
     &1.8412E-02,1.3496E-02,4.3806E-03/
      DATA ((KA(JS,JT,10, 8),JS=1,9),JT=1,5) /
     &1.1962E-01,1.0878E-01,9.8349E-02,8.6745E-02,7.3912E-02,5.9973E-02,
     &4.4839E-02,2.7943E-02,4.7543E-03,1.2315E-01,1.1182E-01,1.0110E-01,
     &8.9175E-02,7.5937E-02,6.1630E-02,4.6110E-02,2.8679E-02,4.8196E-03,
     &1.2693E-01,1.1500E-01,1.0391E-01,9.1586E-02,7.7974E-02,6.3317E-02,
     &4.7374E-02,2.9424E-02,4.8761E-03,1.3084E-01,1.1837E-01,1.0689E-01,
     &9.4192E-02,8.0184E-02,6.5076E-02,4.8672E-02,3.0173E-02,4.8766E-03,
     &1.3499E-01,1.2195E-01,1.1004E-01,9.6906E-02,8.2479E-02,6.6930E-02,
     &4.9998E-02,3.0984E-02,4.9096E-03/
      DATA ((KA(JS,JT,11, 8),JS=1,9),JT=1,5) /
     &1.7854E-01,1.6015E-01,1.4269E-01,1.2418E-01,1.0441E-01,8.3289E-02,
     &6.0955E-02,3.6472E-02,5.4769E-03,1.8442E-01,1.6524E-01,1.4721E-01,
     &1.2815E-01,1.0771E-01,8.5980E-02,6.2870E-02,3.7580E-02,5.4728E-03,
     &1.9077E-01,1.7071E-01,1.5197E-01,1.3224E-01,1.1114E-01,8.8708E-02,
     &6.4824E-02,3.8654E-02,5.4615E-03,1.9746E-01,1.7645E-01,1.5699E-01,
     &1.3658E-01,1.1475E-01,9.1549E-02,6.6833E-02,3.9764E-02,5.4686E-03,
     &2.0452E-01,1.8255E-01,1.6232E-01,1.4114E-01,1.1852E-01,9.4452E-02,
     &6.8909E-02,4.0947E-02,5.4706E-03/
      DATA ((KA(JS,JT,12, 8),JS=1,9),JT=1,5) /
     &2.0120E-01,1.7983E-01,1.5919E-01,1.3760E-01,1.1465E-01,9.0568E-02,
     &6.5383E-02,3.8355E-02,5.7670E-03,2.0757E-01,1.8546E-01,1.6435E-01,
     &1.4209E-01,1.1843E-01,9.3538E-02,6.7515E-02,3.9583E-02,5.7182E-03,
     &2.1449E-01,1.9151E-01,1.6961E-01,1.4673E-01,1.2244E-01,9.6759E-02,
     &6.9782E-02,4.0857E-02,5.7245E-03,2.2222E-01,1.9817E-01,1.7542E-01,
     &1.5173E-01,1.2653E-01,1.0003E-01,7.2145E-02,4.2184E-02,5.7102E-03,
     &2.3023E-01,2.0507E-01,1.8144E-01,1.5689E-01,1.3087E-01,1.0351E-01,
     &7.4642E-02,4.3620E-02,5.7450E-03/
      DATA ((KA(JS,JT,13, 8),JS=1,9),JT=1,5) /
     &1.8448E-01,1.6553E-01,1.4649E-01,1.2620E-01,1.0471E-01,8.2340E-02,
     &5.9042E-02,3.4367E-02,5.6219E-03,1.9034E-01,1.7056E-01,1.5103E-01,
     &1.3022E-01,1.0811E-01,8.5094E-02,6.1006E-02,3.5479E-02,5.5942E-03,
     &1.9658E-01,1.7595E-01,1.5589E-01,1.3452E-01,1.1170E-01,8.7865E-02,
     &6.2984E-02,3.6599E-02,5.6072E-03,2.0338E-01,1.8188E-01,1.6115E-01,
     &1.3898E-01,1.1533E-01,9.0760E-02,6.5090E-02,3.7803E-02,5.6436E-03,
     &2.1087E-01,1.8825E-01,1.6661E-01,1.4369E-01,1.1939E-01,9.3967E-02,
     &6.7400E-02,3.9148E-02,5.6745E-03/
      DATA ((KA(JS,JT, 1, 9),JS=1,9),JT=1,5) /
     &9.4421E-04,7.3440E-03,1.3185E-02,1.9434E-02,2.5910E-02,3.2531E-02,
     &3.9377E-02,4.6620E-02,5.1571E-02,9.6482E-04,7.2909E-03,1.3109E-02,
     &1.9331E-02,2.5776E-02,3.2360E-02,3.9164E-02,4.6323E-02,5.1303E-02,
     &9.8476E-04,7.2409E-03,1.3044E-02,1.9248E-02,2.5665E-02,3.2216E-02,
     &3.8981E-02,4.6102E-02,5.1082E-02,1.0020E-03,7.1999E-03,1.3010E-02,
     &1.9215E-02,2.5618E-02,3.2137E-02,3.8862E-02,4.5932E-02,5.0990E-02,
     &1.0184E-03,7.1770E-03,1.3015E-02,1.9243E-02,2.5654E-02,3.2165E-02,
     &3.8858E-02,4.5863E-02,5.1066E-02/
      DATA ((KA(JS,JT, 2, 9),JS=1,9),JT=1,5) /
     &1.3462E-03,8.0869E-03,1.3393E-02,1.9013E-02,2.4987E-02,3.1278E-02,
     &3.7900E-02,4.5296E-02,4.9469E-02,1.3803E-03,8.0241E-03,1.3304E-02,
     &1.8903E-02,2.4859E-02,3.1123E-02,3.7707E-02,4.5049E-02,4.9230E-02,
     &1.4130E-03,7.9636E-03,1.3235E-02,1.8828E-02,2.4777E-02,3.1019E-02,
     &3.7558E-02,4.4839E-02,4.9085E-02,1.4417E-03,7.9144E-03,1.3198E-02,
     &1.8807E-02,2.4768E-02,3.1006E-02,3.7513E-02,4.4699E-02,4.9090E-02,
     &1.4672E-03,7.8840E-03,1.3197E-02,1.8844E-02,2.4841E-02,3.1094E-02,
     &3.7591E-02,4.4701E-02,4.9253E-02/
      DATA ((KA(JS,JT, 3, 9),JS=1,9),JT=1,5) /
     &2.5556E-03,1.0082E-02,1.5320E-02,1.9920E-02,2.4710E-02,2.9907E-02,
     &3.5684E-02,4.2430E-02,4.6609E-02,2.6284E-03,1.0047E-02,1.5209E-02,
     &1.9796E-02,2.4582E-02,2.9765E-02,3.5524E-02,4.2220E-02,4.6433E-02,
     &2.6960E-03,1.0006E-02,1.5105E-02,1.9696E-02,2.4496E-02,2.9686E-02,
     &3.5446E-02,4.2085E-02,4.6365E-02,2.7589E-03,9.9586E-03,1.5035E-02,
     &1.9644E-02,2.4475E-02,2.9692E-02,3.5469E-02,4.2071E-02,4.6440E-02,
     &2.8129E-03,9.9196E-03,1.4994E-02,1.9639E-02,2.4519E-02,2.9788E-02,
     &3.5597E-02,4.2188E-02,4.6642E-02/
      DATA ((KA(JS,JT, 4, 9),JS=1,9),JT=1,5) /
     &4.8937E-03,1.3203E-02,1.8921E-02,2.3296E-02,2.6924E-02,3.0282E-02,
     &3.4096E-02,3.9071E-02,4.3251E-02,5.0488E-03,1.3226E-02,1.8867E-02,
     &2.3170E-02,2.6777E-02,3.0147E-02,3.3963E-02,3.8948E-02,4.3159E-02,
     &5.1910E-03,1.3248E-02,1.8795E-02,2.3060E-02,2.6655E-02,3.0063E-02,
     &3.3903E-02,3.8899E-02,4.3165E-02,5.3207E-03,1.3268E-02,1.8730E-02,
     &2.2981E-02,2.6589E-02,3.0040E-02,3.3930E-02,3.8970E-02,4.3287E-02,
     &5.4422E-03,1.3287E-02,1.8693E-02,2.2945E-02,2.6576E-02,3.0081E-02,
     &3.4041E-02,3.9135E-02,4.3512E-02/
      DATA ((KA(JS,JT, 5, 9),JS=1,9),JT=1,5) /
     &8.5307E-03,1.7183E-02,2.3465E-02,2.7970E-02,3.1130E-02,3.3358E-02,
     &3.4774E-02,3.6613E-02,3.9589E-02,8.8245E-03,1.7347E-02,2.3508E-02,
     &2.7937E-02,3.1047E-02,3.3237E-02,3.4670E-02,3.6530E-02,3.9570E-02,
     &9.0927E-03,1.7496E-02,2.3535E-02,2.7881E-02,3.0966E-02,3.3147E-02,
     &3.4603E-02,3.6513E-02,3.9628E-02,9.3371E-03,1.7632E-02,2.3559E-02,
     &2.7829E-02,3.0920E-02,3.3100E-02,3.4594E-02,3.6581E-02,3.9792E-02,
     &9.5713E-03,1.7760E-02,2.3602E-02,2.7816E-02,3.0915E-02,3.3109E-02,
     &3.4648E-02,3.6731E-02,4.0039E-02/
      DATA ((KA(JS,JT, 6, 9),JS=1,9),JT=1,5) /
     &1.3837E-02,2.2346E-02,2.8803E-02,3.3403E-02,3.6375E-02,3.7770E-02,
     &3.7769E-02,3.6158E-02,3.5736E-02,1.4345E-02,2.2684E-02,2.9062E-02,
     &3.3523E-02,3.6415E-02,3.7748E-02,3.7698E-02,3.6127E-02,3.5788E-02,
     &1.4814E-02,2.3025E-02,2.9297E-02,3.3616E-02,3.6414E-02,3.7728E-02,
     &3.7657E-02,3.6132E-02,3.5900E-02,1.5241E-02,2.3333E-02,2.9502E-02,
     &3.3707E-02,3.6417E-02,3.7743E-02,3.7671E-02,3.6177E-02,3.6086E-02,
     &1.5643E-02,2.3601E-02,2.9688E-02,3.3808E-02,3.6468E-02,3.7791E-02,
     &3.7729E-02,3.6273E-02,3.6334E-02/
      DATA ((KA(JS,JT, 7, 9),JS=1,9),JT=1,5) /
     &2.3687E-02,3.1230E-02,3.7445E-02,4.1636E-02,4.4049E-02,4.4684E-02,
     &4.3161E-02,3.8835E-02,3.1866E-02,2.4610E-02,3.1967E-02,3.8037E-02,
     &4.2097E-02,4.4354E-02,4.4855E-02,4.3236E-02,3.8850E-02,3.1969E-02,
     &2.5467E-02,3.2639E-02,3.8612E-02,4.2519E-02,4.4609E-02,4.4967E-02,
     &4.3302E-02,3.8885E-02,3.2129E-02,2.6267E-02,3.3238E-02,3.9137E-02,
     &4.2894E-02,4.4845E-02,4.5082E-02,4.3395E-02,3.8965E-02,3.2326E-02,
     &2.6995E-02,3.3786E-02,3.9598E-02,4.3239E-02,4.5071E-02,4.5249E-02,
     &4.3527E-02,3.9067E-02,3.2557E-02/
      DATA ((KA(JS,JT, 8, 9),JS=1,9),JT=1,5) /
     &4.7920E-02,5.2366E-02,5.6749E-02,5.9168E-02,5.9712E-02,5.8092E-02,
     &5.3946E-02,4.5783E-02,2.8113E-02,4.9884E-02,5.3965E-02,5.8166E-02,
     &6.0347E-02,6.0665E-02,5.8786E-02,5.4351E-02,4.5985E-02,2.8254E-02,
     &5.1719E-02,5.5478E-02,5.9448E-02,6.1483E-02,6.1565E-02,5.9384E-02,
     &5.4686E-02,4.6159E-02,2.8435E-02,5.3394E-02,5.6807E-02,6.0645E-02,
     &6.2509E-02,6.2363E-02,5.9916E-02,5.4999E-02,4.6361E-02,2.8611E-02,
     &5.4964E-02,5.7985E-02,6.1688E-02,6.3442E-02,6.3043E-02,6.0445E-02,
     &5.5342E-02,4.6592E-02,2.8833E-02/
      DATA ((KA(JS,JT, 9, 9),JS=1,9),JT=1,5) /
     &1.8387E-01,1.6808E-01,1.5799E-01,1.4671E-01,1.3366E-01,1.1828E-01,
     &9.9590E-02,7.4670E-02,2.3960E-02,1.9171E-01,1.7460E-01,1.6351E-01,
     &1.5144E-01,1.3758E-01,1.2130E-01,1.0166E-01,7.5740E-02,2.4137E-02,
     &1.9894E-01,1.8065E-01,1.6862E-01,1.5587E-01,1.4113E-01,1.2411E-01,
     &1.0364E-01,7.6719E-02,2.4294E-02,2.0563E-01,1.8623E-01,1.7319E-01,
     &1.5976E-01,1.4435E-01,1.2672E-01,1.0542E-01,7.7598E-02,2.4446E-02,
     &2.1200E-01,1.9152E-01,1.7746E-01,1.6330E-01,1.4720E-01,1.2898E-01,
     &1.0699E-01,7.8411E-02,2.4664E-02/
      DATA ((KA(JS,JT,10, 9),JS=1,9),JT=1,5) /
     &7.9805E-01,7.0103E-01,6.0984E-01,5.2274E-01,4.3812E-01,3.5220E-01,
     &2.6270E-01,1.6632E-01,1.8620E-02,8.3214E-01,7.3068E-01,6.3476E-01,
     &5.4295E-01,4.5426E-01,3.6461E-01,2.7128E-01,1.7099E-01,1.8699E-02,
     &8.6405E-01,7.5844E-01,6.5814E-01,5.6198E-01,4.6922E-01,3.7620E-01,
     &2.7918E-01,1.7530E-01,1.8761E-02,8.9399E-01,7.8448E-01,6.8005E-01,
     &5.7978E-01,4.8302E-01,3.8668E-01,2.8631E-01,1.7930E-01,1.8825E-02,
     &9.2229E-01,8.0909E-01,7.0076E-01,5.9657E-01,4.9598E-01,3.9642E-01,
     &2.9286E-01,1.8285E-01,1.8959E-02/
      DATA ((KA(JS,JT,11, 9),JS=1,9),JT=1,5) /
     &1.2376E+00,1.0851E+00,9.3781E-01,7.9479E-01,6.5536E-01,5.1636E-01,
     &3.7350E-01,2.2328E-01,1.9046E-02,1.2888E+00,1.1296E+00,9.7557E-01,
     &8.2566E-01,6.7951E-01,5.3467E-01,3.8601E-01,2.3011E-01,1.9117E-02,
     &1.3372E+00,1.1719E+00,1.0114E+00,8.5500E-01,7.0234E-01,5.5187E-01,
     &3.9765E-01,2.3639E-01,1.9165E-02,1.3819E+00,1.2109E+00,1.0444E+00,
     &8.8194E-01,7.2332E-01,5.6752E-01,4.0827E-01,2.4219E-01,1.9058E-02,
     &1.4259E+00,1.2494E+00,1.0769E+00,9.0854E-01,7.4408E-01,5.8286E-01,
     &4.1859E-01,2.4748E-01,1.9067E-02/
      DATA ((KA(JS,JT,12, 9),JS=1,9),JT=1,5) /
     &1.4243E+00,1.2488E+00,1.0789E+00,9.1317E-01,7.5092E-01,5.8812E-01,
     &4.2112E-01,2.4611E-01,1.9872E-02,1.4836E+00,1.3004E+00,1.1224E+00,
     &9.4876E-01,7.7876E-01,6.0917E-01,4.3528E-01,2.5376E-01,2.0064E-02,
     &1.5386E+00,1.3484E+00,1.1631E+00,9.8199E-01,8.0461E-01,6.2868E-01,
     &4.4843E-01,2.6085E-01,2.0179E-02,1.5909E+00,1.3940E+00,1.2017E+00,
     &1.0136E+00,8.2931E-01,6.4713E-01,4.6088E-01,2.6745E-01,2.0157E-02,
     &1.6423E+00,1.4388E+00,1.2396E+00,1.0446E+00,8.5343E-01,6.6506E-01,
     &4.7297E-01,2.7367E-01,2.0135E-02/
      DATA ((KA(JS,JT,13, 9),JS=1,9),JT=1,5) /
     &1.3090E+00,1.1487E+00,9.9498E-01,8.4529E-01,6.9751E-01,5.4690E-01,
     &3.9201E-01,2.2831E-01,1.9648E-02,1.3642E+00,1.1967E+00,1.0354E+00,
     &8.7822E-01,7.2355E-01,5.6643E-01,4.0528E-01,2.3543E-01,1.9783E-02,
     &1.4156E+00,1.2415E+00,1.0731E+00,9.0892E-01,7.4783E-01,5.8491E-01,
     &4.1788E-01,2.4217E-01,1.9878E-02,1.4652E+00,1.2846E+00,1.1094E+00,
     &9.3863E-01,7.7135E-01,6.0268E-01,4.2988E-01,2.4851E-01,1.9864E-02,
     &1.5126E+00,1.3260E+00,1.1446E+00,9.6741E-01,7.9378E-01,6.1968E-01,
     &4.4123E-01,2.5440E-01,1.9877E-02/
      DATA ((KA(JS,JT, 1,10),JS=1,9),JT=1,5) /
     &3.3844E-03,1.5864E-02,3.0967E-02,4.5960E-02,6.0759E-02,7.5076E-02,
     &8.8299E-02,9.7840E-02,1.2109E-01,3.3774E-03,1.5840E-02,3.0916E-02,
     &4.5912E-02,6.0698E-02,7.5010E-02,8.8211E-02,9.7731E-02,1.2099E-01,
     &3.3575E-03,1.5844E-02,3.0912E-02,4.5937E-02,6.0728E-02,7.5022E-02,
     &8.8124E-02,9.7474E-02,1.2106E-01,3.3333E-03,1.5824E-02,3.0829E-02,
     &4.5838E-02,6.0646E-02,7.4990E-02,8.8084E-02,9.7173E-02,1.2089E-01,
     &3.3084E-03,1.5776E-02,3.0693E-02,4.5649E-02,6.0428E-02,7.4773E-02,
     &8.7909E-02,9.6839E-02,1.2042E-01/
      DATA ((KA(JS,JT, 2,10),JS=1,9),JT=1,5) /
     &5.1392E-03,1.7464E-02,3.2432E-02,4.7915E-02,6.3487E-02,7.8847E-02,
     &9.3621E-02,1.0600E-01,1.2635E-01,5.1325E-03,1.7471E-02,3.2464E-02,
     &4.7934E-02,6.3521E-02,7.8889E-02,9.3606E-02,1.0592E-01,1.2642E-01,
     &5.1157E-03,1.7466E-02,3.2343E-02,4.7787E-02,6.3340E-02,7.8722E-02,
     &9.3575E-02,1.0588E-01,1.2605E-01,5.0987E-03,1.7399E-02,3.2075E-02,
     &4.7428E-02,6.2893E-02,7.8221E-02,9.3145E-02,1.0589E-01,1.2513E-01,
     &5.0781E-03,1.7287E-02,3.1803E-02,4.7068E-02,6.2420E-02,7.7655E-02,
     &9.2528E-02,1.0558E-01,1.2418E-01/
      DATA ((KA(JS,JT, 3,10),JS=1,9),JT=1,5) /
     &1.0449E-02,2.2920E-02,3.5229E-02,4.9841E-02,6.5300E-02,8.0993E-02,
     &9.6715E-02,1.1178E-01,1.2900E-01,1.0475E-02,2.2840E-02,3.5278E-02,
     &4.9881E-02,6.5245E-02,8.1037E-02,9.6863E-02,1.1212E-01,1.2899E-01,
     &1.0487E-02,2.2756E-02,3.5213E-02,4.9645E-02,6.4866E-02,8.0649E-02,
     &9.6451E-02,1.1190E-01,1.2830E-01,1.0493E-02,2.2711E-02,3.4996E-02,
     &4.9204E-02,6.4312E-02,7.9994E-02,9.5693E-02,1.1109E-01,1.2723E-01,
     &1.0487E-02,2.2599E-02,3.4737E-02,4.8786E-02,6.3856E-02,7.9443E-02,
     &9.5024E-02,1.1021E-01,1.2638E-01/
      DATA ((KA(JS,JT, 4,10),JS=1,9),JT=1,5) /
     &2.1474E-02,3.4011E-02,4.5615E-02,5.6742E-02,6.8329E-02,8.2791E-02,
     &9.7759E-02,1.1367E-01,1.2934E-01,2.1593E-02,3.3751E-02,4.5521E-02,
     &5.6645E-02,6.8211E-02,8.2434E-02,9.7517E-02,1.1348E-01,1.2896E-01,
     &2.1694E-02,3.3429E-02,4.5406E-02,5.6399E-02,6.7862E-02,8.1741E-02,
     &9.6866E-02,1.1284E-01,1.2803E-01,2.1761E-02,3.3088E-02,4.5200E-02,
     &5.5990E-02,6.7313E-02,8.0951E-02,9.6103E-02,1.1192E-01,1.2712E-01,
     &2.1871E-02,3.2779E-02,4.4802E-02,5.5607E-02,6.6864E-02,8.0377E-02,
     &9.5554E-02,1.1124E-01,1.2647E-01/
      DATA ((KA(JS,JT, 5,10),JS=1,9),JT=1,5) /
     &3.9770E-02,5.1894E-02,6.3327E-02,7.2180E-02,8.0917E-02,8.8056E-02,
     &9.8598E-02,1.1206E-01,1.2671E-01,4.0140E-02,5.1409E-02,6.3212E-02,
     &7.2060E-02,8.0506E-02,8.7647E-02,9.8026E-02,1.1163E-01,1.2617E-01,
     &4.0492E-02,5.0925E-02,6.2882E-02,7.1952E-02,8.0008E-02,8.6965E-02,
     &9.7225E-02,1.1094E-01,1.2542E-01,4.0826E-02,5.0532E-02,6.2408E-02,
     &7.1612E-02,7.9337E-02,8.6238E-02,9.6327E-02,1.1019E-01,1.2470E-01,
     &4.1162E-02,5.0261E-02,6.1890E-02,7.0980E-02,7.8777E-02,8.5713E-02,
     &9.5778E-02,1.0986E-01,1.2449E-01/
      DATA ((KA(JS,JT, 6,10),JS=1,9),JT=1,5) /
     &6.7916E-02,7.7649E-02,8.9172E-02,9.6900E-02,1.0149E-01,1.0503E-01,
     &1.0523E-01,1.0994E-01,1.2156E-01,6.8757E-02,7.7814E-02,8.8891E-02,
     &9.7030E-02,1.0144E-01,1.0468E-01,1.0479E-01,1.0906E-01,1.2102E-01,
     &6.9572E-02,7.7629E-02,8.8407E-02,9.6716E-02,1.0124E-01,1.0403E-01,
     &1.0408E-01,1.0810E-01,1.2040E-01,7.0420E-02,7.7345E-02,8.8011E-02,
     &9.6134E-02,1.0079E-01,1.0305E-01,1.0321E-01,1.0749E-01,1.2017E-01,
     &7.1176E-02,7.7213E-02,8.7761E-02,9.5353E-02,9.9879E-02,1.0215E-01,
     &1.0265E-01,1.0733E-01,1.2038E-01/
      DATA ((KA(JS,JT, 7,10),JS=1,9),JT=1,5) /
     &1.2127E-01,1.2412E-01,1.3217E-01,1.3765E-01,1.3951E-01,1.3625E-01,
     &1.2814E-01,1.1487E-01,1.1426E-01,1.2309E-01,1.2453E-01,1.3252E-01,
     &1.3798E-01,1.3976E-01,1.3644E-01,1.2796E-01,1.1426E-01,1.1391E-01,
     &1.2489E-01,1.2494E-01,1.3228E-01,1.3764E-01,1.3951E-01,1.3625E-01,
     &1.2756E-01,1.1350E-01,1.1349E-01,1.2680E-01,1.2557E-01,1.3198E-01,
     &1.3739E-01,1.3886E-01,1.3552E-01,1.2649E-01,1.1282E-01,1.1362E-01,
     &1.2852E-01,1.2615E-01,1.3199E-01,1.3726E-01,1.3802E-01,1.3430E-01,
     &1.2550E-01,1.1257E-01,1.1419E-01/
      DATA ((KA(JS,JT, 8,10),JS=1,9),JT=1,5) /
     &2.5214E-01,2.3134E-01,2.3152E-01,2.2506E-01,2.1543E-01,2.0242E-01,
     &1.8079E-01,1.4566E-01,1.0565E-01,2.5695E-01,2.3363E-01,2.3275E-01,
     &2.2604E-01,2.1637E-01,2.0282E-01,1.8105E-01,1.4554E-01,1.0546E-01,
     &2.6176E-01,2.3588E-01,2.3395E-01,2.2621E-01,2.1636E-01,2.0257E-01,
     &1.8076E-01,1.4513E-01,1.0533E-01,2.6651E-01,2.3871E-01,2.3539E-01,
     &2.2647E-01,2.1633E-01,2.0229E-01,1.8002E-01,1.4419E-01,1.0597E-01,
     &2.7042E-01,2.4131E-01,2.3677E-01,2.2700E-01,2.1683E-01,2.0167E-01,
     &1.7891E-01,1.4342E-01,1.0666E-01/
      DATA ((KA(JS,JT, 9,10),JS=1,9),JT=1,5) /
     &9.7736E-01,8.5726E-01,7.4530E-01,6.6330E-01,5.7895E-01,4.8711E-01,
     &3.8944E-01,2.7986E-01,9.6120E-02,1.0005E+00,8.7740E-01,7.5935E-01,
     &6.7173E-01,5.8495E-01,4.9078E-01,3.9206E-01,2.8024E-01,9.6028E-02,
     &1.0238E+00,8.9765E-01,7.7412E-01,6.7963E-01,5.9056E-01,4.9392E-01,
     &3.9381E-01,2.7971E-01,9.6387E-02,1.0459E+00,9.1704E-01,7.8954E-01,
     &6.8917E-01,5.9755E-01,4.9657E-01,3.9497E-01,2.7927E-01,9.7373E-02,
     &1.0630E+00,9.3201E-01,8.0170E-01,6.9634E-01,6.0306E-01,4.9955E-01,
     &3.9651E-01,2.7910E-01,9.7962E-02/
      DATA ((KA(JS,JT,10,10),JS=1,9),JT=1,5) /
     &4.2057E+00,3.6817E+00,3.1579E+00,2.6346E+00,2.1198E+00,1.6450E+00,
     &1.1902E+00,7.0817E-01,7.8303E-02,4.3277E+00,3.7881E+00,3.2491E+00,
     &2.7104E+00,2.1754E+00,1.6774E+00,1.2094E+00,7.1654E-01,7.8798E-02,
     &4.4500E+00,3.8956E+00,3.3411E+00,2.7869E+00,2.2338E+00,1.7120E+00,
     &1.2289E+00,7.2324E-01,7.8857E-02,4.5562E+00,3.9883E+00,3.4205E+00,
     &2.8532E+00,2.2862E+00,1.7446E+00,1.2492E+00,7.3045E-01,7.9497E-02,
     &4.6429E+00,4.0644E+00,3.4858E+00,2.9077E+00,2.3298E+00,1.7714E+00,
     &1.2652E+00,7.3636E-01,7.8315E-02/
      DATA ((KA(JS,JT,11,10),JS=1,9),JT=1,5) /
     &6.3643E+00,5.5702E+00,4.7761E+00,3.9823E+00,3.1901E+00,2.4267E+00,
     &1.7139E+00,9.8175E-01,5.2396E-02,6.5707E+00,5.7511E+00,4.9312E+00,
     &4.1117E+00,3.2928E+00,2.4948E+00,1.7532E+00,9.9614E-01,5.2761E-02,
     &6.7598E+00,5.9160E+00,5.0729E+00,4.2301E+00,3.3876E+00,2.5590E+00,
     &1.7914E+00,1.0123E+00,5.3574E-02,6.9211E+00,6.0577E+00,5.1942E+00,
     &4.3313E+00,3.4687E+00,2.6150E+00,1.8227E+00,1.0262E+00,5.6608E-02,
     &7.0466E+00,6.1673E+00,5.2885E+00,4.4096E+00,3.5315E+00,2.6584E+00,
     &1.8463E+00,1.0382E+00,5.6583E-02/
      DATA ((KA(JS,JT,12,10),JS=1,9),JT=1,5) /
     &7.1591E+00,6.2650E+00,5.3715E+00,4.4783E+00,3.5872E+00,2.7305E+00,
     &1.9173E+00,1.0829E+00,5.4364E-02,7.3899E+00,6.4678E+00,5.5455E+00,
     &4.6234E+00,3.7023E+00,2.8086E+00,1.9670E+00,1.1039E+00,5.3004E-02,
     &7.5932E+00,6.6457E+00,5.6978E+00,4.7509E+00,3.8044E+00,2.8774E+00,
     &2.0093E+00,1.1228E+00,5.1959E-02,7.7612E+00,6.7925E+00,5.8241E+00,
     &4.8562E+00,3.8890E+00,2.9344E+00,2.0429E+00,1.1393E+00,5.3174E-02,
     &7.8969E+00,6.9118E+00,5.9263E+00,4.9415E+00,3.9571E+00,2.9804E+00,
     &2.0685E+00,1.1516E+00,5.1704E-02/
      DATA ((KA(JS,JT,13,10),JS=1,9),JT=1,5) /
     &6.4705E+00,5.6627E+00,4.8551E+00,4.0480E+00,3.2529E+00,2.5042E+00,
     &1.7607E+00,9.9775E-01,5.2819E-02,6.6649E+00,5.8328E+00,5.0012E+00,
     &4.1701E+00,3.3469E+00,2.5698E+00,1.8026E+00,1.0186E+00,5.2318E-02,
     &6.8320E+00,5.9796E+00,5.1272E+00,4.2755E+00,3.4276E+00,2.6233E+00,
     &1.8383E+00,1.0369E+00,5.1248E-02,6.9674E+00,6.0982E+00,5.2289E+00,
     &4.3604E+00,3.4933E+00,2.6647E+00,1.8662E+00,1.0505E+00,5.2356E-02,
     &7.0874E+00,6.2027E+00,5.3188E+00,4.4355E+00,3.5528E+00,2.7014E+00,
     &1.8899E+00,1.0614E+00,5.1111E-02/
      DATA ((KA(JS,JT, 1,11),JS=1,9),JT=1,5) /
     &4.6742E-03,2.0279E-02,3.9426E-02,5.8543E-02,7.7272E-02,9.5241E-02,
     &1.1148E-01,1.2235E-01,1.5408E-01,4.6073E-03,2.0296E-02,3.9412E-02,
     &5.8523E-02,7.7232E-02,9.5132E-02,1.1121E-01,1.2184E-01,1.5399E-01,
     &4.5565E-03,2.0227E-02,3.9298E-02,5.8356E-02,7.7038E-02,9.4961E-02,
     &1.1109E-01,1.2151E-01,1.5359E-01,4.5047E-03,2.0130E-02,3.9180E-02,
     &5.8173E-02,7.6772E-02,9.4618E-02,1.1074E-01,1.2134E-01,1.5306E-01,
     &4.4540E-03,2.0027E-02,3.9084E-02,5.8025E-02,7.6535E-02,9.4251E-02,
     &1.1025E-01,1.2116E-01,1.5260E-01/
      DATA ((KA(JS,JT, 2,11),JS=1,9),JT=1,5) /
     &7.4064E-03,2.2194E-02,4.1767E-02,6.1911E-02,8.1938E-02,1.0155E-01,
     &1.2014E-01,1.3485E-01,1.6319E-01,7.3108E-03,2.2143E-02,4.1684E-02,
     &6.1877E-02,8.1902E-02,1.0152E-01,1.2013E-01,1.3472E-01,1.6312E-01,
     &7.2232E-03,2.2079E-02,4.1677E-02,6.1891E-02,8.1918E-02,1.0151E-01,
     &1.1999E-01,1.3454E-01,1.6316E-01,7.1304E-03,2.2033E-02,4.1736E-02,
     &6.1998E-02,8.2035E-02,1.0158E-01,1.1988E-01,1.3411E-01,1.6341E-01,
     &7.0357E-03,2.1988E-02,4.1742E-02,6.2041E-02,8.2077E-02,1.0158E-01,
     &1.1983E-01,1.3366E-01,1.6350E-01/
      DATA ((KA(JS,JT, 3,11),JS=1,9),JT=1,5) /
     &1.5774E-02,2.9169E-02,4.5962E-02,6.5827E-02,8.6496E-02,1.0742E-01,
     &1.2791E-01,1.4653E-01,1.7156E-01,1.5614E-02,2.8989E-02,4.5846E-02,
     &6.5612E-02,8.6438E-02,1.0734E-01,1.2776E-01,1.4623E-01,1.7149E-01,
     &1.5422E-02,2.8825E-02,4.5777E-02,6.5531E-02,8.6532E-02,1.0747E-01,
     &1.2790E-01,1.4632E-01,1.7170E-01,1.5220E-02,2.8664E-02,4.5718E-02,
     &6.5531E-02,8.6682E-02,1.0768E-01,1.2815E-01,1.4661E-01,1.7201E-01,
     &1.5041E-02,2.8491E-02,4.5554E-02,6.5387E-02,8.6561E-02,1.0758E-01,
     &1.2814E-01,1.4679E-01,1.7174E-01/
      DATA ((KA(JS,JT, 4,11),JS=1,9),JT=1,5) /
     &3.3773E-02,4.4438E-02,5.9281E-02,7.3962E-02,9.2405E-02,1.1202E-01,
     &1.3347E-01,1.5431E-01,1.7769E-01,3.3523E-02,4.4307E-02,5.8961E-02,
     &7.3730E-02,9.2117E-02,1.1213E-01,1.3369E-01,1.5450E-01,1.7797E-01,
     &3.3236E-02,4.4011E-02,5.8687E-02,7.3516E-02,9.1754E-02,1.1213E-01,
     &1.3376E-01,1.5472E-01,1.7805E-01,3.2927E-02,4.3662E-02,5.8418E-02,
     &7.3212E-02,9.1231E-02,1.1190E-01,1.3353E-01,1.5459E-01,1.7761E-01,
     &3.2628E-02,4.3294E-02,5.8201E-02,7.2680E-02,9.0434E-02,1.1128E-01,
     &1.3281E-01,1.5389E-01,1.7655E-01/
      DATA ((KA(JS,JT, 5,11),JS=1,9),JT=1,5) /
     &6.5323E-02,7.2628E-02,8.3508E-02,9.5963E-02,1.0655E-01,1.2020E-01,
     &1.3782E-01,1.5923E-01,1.8200E-01,6.5064E-02,7.2406E-02,8.3203E-02,
     &9.5444E-02,1.0632E-01,1.1979E-01,1.3760E-01,1.5925E-01,1.8207E-01,
     &6.4756E-02,7.1969E-02,8.2862E-02,9.4908E-02,1.0590E-01,1.1930E-01,
     &1.3724E-01,1.5904E-01,1.8162E-01,6.4304E-02,7.1135E-02,8.2400E-02,
     &9.4416E-02,1.0531E-01,1.1853E-01,1.3656E-01,1.5838E-01,1.8061E-01,
     &6.3847E-02,7.0072E-02,8.1806E-02,9.3969E-02,1.0427E-01,1.1735E-01,
     &1.3557E-01,1.5724E-01,1.7920E-01/
      DATA ((KA(JS,JT, 6,11),JS=1,9),JT=1,5) /
     &1.1614E-01,1.1612E-01,1.2461E-01,1.3093E-01,1.3774E-01,1.4186E-01,
     &1.4765E-01,1.6150E-01,1.8364E-01,1.1619E-01,1.1550E-01,1.2387E-01,
     &1.3036E-01,1.3714E-01,1.4135E-01,1.4700E-01,1.6131E-01,1.8335E-01,
     &1.1615E-01,1.1477E-01,1.2280E-01,1.2991E-01,1.3667E-01,1.4072E-01,
     &1.4596E-01,1.6062E-01,1.8242E-01,1.1574E-01,1.1387E-01,1.2156E-01,
     &1.2938E-01,1.3597E-01,1.3977E-01,1.4470E-01,1.5943E-01,1.8095E-01,
     &1.1520E-01,1.1286E-01,1.2034E-01,1.2877E-01,1.3515E-01,1.3854E-01,
     &1.4325E-01,1.5816E-01,1.7948E-01/
      DATA ((KA(JS,JT, 7,11),JS=1,9),JT=1,5) /
     &2.1510E-01,1.9619E-01,2.0174E-01,1.9935E-01,1.9475E-01,1.8847E-01,
     &1.8001E-01,1.6816E-01,1.8086E-01,2.1625E-01,1.9617E-01,2.0091E-01,
     &1.9825E-01,1.9429E-01,1.8801E-01,1.7902E-01,1.6736E-01,1.8038E-01,
     &2.1700E-01,1.9569E-01,1.9979E-01,1.9686E-01,1.9372E-01,1.8767E-01,
     &1.7767E-01,1.6608E-01,1.7932E-01,2.1676E-01,1.9471E-01,1.9847E-01,
     &1.9536E-01,1.9293E-01,1.8720E-01,1.7635E-01,1.6450E-01,1.7799E-01,
     &2.1625E-01,1.9358E-01,1.9672E-01,1.9373E-01,1.9213E-01,1.8631E-01,
     &1.7483E-01,1.6262E-01,1.7662E-01/
      DATA ((KA(JS,JT, 8,11),JS=1,9),JT=1,5) /
     &4.6382E-01,4.0807E-01,3.7899E-01,3.5840E-01,3.2915E-01,2.9613E-01,
     &2.5854E-01,2.1154E-01,1.7388E-01,4.6803E-01,4.1204E-01,3.7966E-01,
     &3.5758E-01,3.2785E-01,2.9605E-01,2.5875E-01,2.1026E-01,1.7332E-01,
     &4.7076E-01,4.1406E-01,3.7922E-01,3.5601E-01,3.2603E-01,2.9561E-01,
     &2.5861E-01,2.0864E-01,1.7242E-01,4.7155E-01,4.1450E-01,3.7727E-01,
     &3.5413E-01,3.2392E-01,2.9447E-01,2.5827E-01,2.0694E-01,1.7120E-01,
     &4.7233E-01,4.1516E-01,3.7581E-01,3.5208E-01,3.2176E-01,2.9332E-01,
     &2.5728E-01,2.0514E-01,1.7042E-01/
      DATA ((KA(JS,JT, 9,11),JS=1,9),JT=1,5) /
     &1.8678E+00,1.6362E+00,1.4048E+00,1.1793E+00,9.9438E-01,8.2136E-01,
     &6.2834E-01,4.2034E-01,1.6334E-01,1.8906E+00,1.6563E+00,1.4224E+00,
     &1.1919E+00,9.9937E-01,8.2259E-01,6.2713E-01,4.2292E-01,1.6311E-01,
     &1.9044E+00,1.6682E+00,1.4321E+00,1.1983E+00,1.0002E+00,8.2124E-01,
     &6.2419E-01,4.2359E-01,1.6249E-01,1.9121E+00,1.6748E+00,1.4376E+00,
     &1.2016E+00,9.9779E-01,8.1901E-01,6.2159E-01,4.2327E-01,1.6166E-01,
     &1.9224E+00,1.6839E+00,1.4454E+00,1.2078E+00,9.9866E-01,8.1827E-01,
     &6.1893E-01,4.2245E-01,1.6163E-01/
      DATA ((KA(JS,JT,10,11),JS=1,9),JT=1,5) /
     &8.3490E+00,7.3068E+00,6.2652E+00,5.2233E+00,4.1816E+00,3.1407E+00,
     &2.1527E+00,1.2369E+00,1.2697E-01,8.4604E+00,7.4045E+00,6.3492E+00,
     &5.2936E+00,4.2378E+00,3.1825E+00,2.1701E+00,1.2392E+00,1.2746E-01,
     &8.5299E+00,7.4655E+00,6.4008E+00,5.3364E+00,4.2721E+00,3.2084E+00,
     &2.1800E+00,1.2385E+00,1.2876E-01,8.6037E+00,7.5302E+00,6.4564E+00,
     &5.3827E+00,4.3093E+00,3.2362E+00,2.1902E+00,1.2373E+00,1.3016E-01,
     &8.6811E+00,7.5976E+00,6.5142E+00,5.4315E+00,4.3481E+00,3.2657E+00,
     &2.2039E+00,1.2408E+00,1.3327E-01/
      DATA ((KA(JS,JT,11,11),JS=1,9),JT=1,5) /
     &1.2908E+01,1.1296E+01,9.6842E+00,8.0726E+00,6.4609E+00,4.8491E+00,
     &3.2606E+00,1.7969E+00,1.0870E-01,1.3081E+01,1.1447E+01,9.8136E+00,
     &8.1796E+00,6.5463E+00,4.9136E+00,3.2978E+00,1.8090E+00,1.0807E-01,
     &1.3247E+01,1.1593E+01,9.9386E+00,8.2843E+00,6.6304E+00,4.9764E+00,
     &3.3344E+00,1.8186E+00,1.0723E-01,1.3412E+01,1.1737E+01,1.0062E+01,
     &8.3876E+00,6.7133E+00,5.0389E+00,3.3728E+00,1.8302E+00,1.0582E-01,
     &1.3565E+01,1.1871E+01,1.0177E+01,8.4837E+00,6.7902E+00,5.0972E+00,
     &3.4088E+00,1.8416E+00,1.0800E-01/
      DATA ((KA(JS,JT,12,11),JS=1,9),JT=1,5) /
     &1.4642E+01,1.2812E+01,1.0983E+01,9.1554E+00,7.3265E+00,5.4974E+00,
     &3.7020E+00,2.0284E+00,8.2662E-02,1.4885E+01,1.3026E+01,1.1167E+01,
     &9.3078E+00,7.4487E+00,5.5898E+00,3.7559E+00,2.0497E+00,8.1390E-02,
     &1.5119E+01,1.3231E+01,1.1343E+01,9.4543E+00,7.5661E+00,5.6785E+00,
     &3.8088E+00,2.0698E+00,8.0357E-02,1.5358E+01,1.3440E+01,1.1522E+01,
     &9.6047E+00,7.6867E+00,5.7694E+00,3.8642E+00,2.0905E+00,7.9812E-02,
     &1.5578E+01,1.3633E+01,1.1688E+01,9.7428E+00,7.7978E+00,5.8532E+00,
     &3.9171E+00,2.1122E+00,8.2952E-02/
      DATA ((KA(JS,JT,13,11),JS=1,9),JT=1,5) /
     &1.3181E+01,1.1536E+01,9.8891E+00,8.2428E+00,6.5963E+00,4.9547E+00,
     &3.3878E+00,1.8779E+00,8.5930E-02,1.3431E+01,1.1753E+01,1.0076E+01,
     &8.3993E+00,6.7218E+00,5.0463E+00,3.4400E+00,1.9003E+00,8.2789E-02,
     &1.3694E+01,1.1985E+01,1.0274E+01,8.5642E+00,6.8544E+00,5.1452E+00,
     &3.4940E+00,1.9250E+00,8.1321E-02,1.3957E+01,1.2214E+01,1.0471E+01,
     &8.7279E+00,6.9861E+00,5.2450E+00,3.5504E+00,1.9524E+00,7.8953E-02,
     &1.4201E+01,1.2428E+01,1.0655E+01,8.8819E+00,7.1097E+00,5.3381E+00,
     &3.6055E+00,1.9785E+00,8.1036E-02/
      DATA ((KA(JS,JT, 1,12),JS=1,9),JT=1,5) /
     &6.5787E-03,2.6236E-02,5.1362E-02,7.6305E-02,1.0073E-01,1.2420E-01,
     &1.4556E-01,1.6001E-01,2.0088E-01,6.5355E-03,2.5963E-02,5.1031E-02,
     &7.5853E-02,1.0014E-01,1.2346E-01,1.4463E-01,1.5894E-01,1.9973E-01,
     &6.4519E-03,2.5842E-02,5.0885E-02,7.5629E-02,9.9804E-02,1.2294E-01,
     &1.4394E-01,1.5802E-01,1.9913E-01,6.3508E-03,2.5827E-02,5.0889E-02,
     &7.5643E-02,9.9816E-02,1.2289E-01,1.4367E-01,1.5727E-01,1.9918E-01,
     &6.2468E-03,2.5824E-02,5.0882E-02,7.5643E-02,9.9840E-02,1.2300E-01,
     &1.4386E-01,1.5674E-01,1.9923E-01/
      DATA ((KA(JS,JT, 2,12),JS=1,9),JT=1,5) /
     &1.0416E-02,2.8932E-02,5.5152E-02,8.2023E-02,1.0846E-01,1.3404E-01,
     &1.5780E-01,1.7629E-01,2.1619E-01,1.0342E-02,2.8637E-02,5.4892E-02,
     &8.1654E-02,1.0796E-01,1.3340E-01,1.5695E-01,1.7507E-01,2.1532E-01,
     &1.0224E-02,2.8457E-02,5.4759E-02,8.1469E-02,1.0772E-01,1.3310E-01,
     &1.5656E-01,1.7435E-01,2.1487E-01,1.0091E-02,2.8318E-02,5.4670E-02,
     &8.1344E-02,1.0759E-01,1.3299E-01,1.5649E-01,1.7414E-01,2.1459E-01,
     &9.9570E-03,2.8146E-02,5.4539E-02,8.1138E-02,1.0736E-01,1.3278E-01,
     &1.5638E-01,1.7422E-01,2.1411E-01/
      DATA ((KA(JS,JT, 3,12),JS=1,9),JT=1,5) /
     &2.2302E-02,3.7417E-02,6.1097E-02,8.8747E-02,1.1756E-01,1.4593E-01,
     &1.7314E-01,1.9636E-01,2.3403E-01,2.2117E-02,3.6950E-02,6.0557E-02,
     &8.8385E-02,1.1711E-01,1.4537E-01,1.7254E-01,1.9566E-01,2.3319E-01,
     &2.1903E-02,3.6596E-02,6.0142E-02,8.8214E-02,1.1684E-01,1.4504E-01,
     &1.7207E-01,1.9507E-01,2.3270E-01,2.1706E-02,3.6379E-02,5.9779E-02,
     &8.7937E-02,1.1644E-01,1.4454E-01,1.7162E-01,1.9475E-01,2.3180E-01,
     &2.1485E-02,3.6152E-02,5.9419E-02,8.7609E-02,1.1597E-01,1.4392E-01,
     &1.7083E-01,1.9407E-01,2.3079E-01/
      DATA ((KA(JS,JT, 4,12),JS=1,9),JT=1,5) /
     &4.8787E-02,6.0363E-02,7.6958E-02,9.9608E-02,1.2651E-01,1.5698E-01,
     &1.8722E-01,2.1554E-01,2.5046E-01,4.8476E-02,5.9621E-02,7.6177E-02,
     &9.8903E-02,1.2601E-01,1.5644E-01,1.8652E-01,2.1472E-01,2.4963E-01,
     &4.8022E-02,5.9054E-02,7.5570E-02,9.8295E-02,1.2578E-01,1.5620E-01,
     &1.8618E-01,2.1420E-01,2.4913E-01,4.7565E-02,5.8399E-02,7.5073E-02,
     &9.7780E-02,1.2559E-01,1.5591E-01,1.8579E-01,2.1367E-01,2.4858E-01,
     &4.7078E-02,5.7702E-02,7.4506E-02,9.7303E-02,1.2546E-01,1.5568E-01,
     &1.8546E-01,2.1318E-01,2.4815E-01/
      DATA ((KA(JS,JT, 5,12),JS=1,9),JT=1,5) /
     &9.7499E-02,9.8718E-02,1.1395E-01,1.2710E-01,1.4448E-01,1.6872E-01,
     &1.9875E-01,2.3006E-01,2.6441E-01,9.6942E-02,9.7852E-02,1.1233E-01,
     &1.2606E-01,1.4347E-01,1.6785E-01,1.9829E-01,2.2956E-01,2.6367E-01,
     &9.6111E-02,9.7066E-02,1.1087E-01,1.2520E-01,1.4264E-01,1.6720E-01,
     &1.9804E-01,2.2914E-01,2.6333E-01,9.5331E-02,9.6285E-02,1.0984E-01,
     &1.2440E-01,1.4205E-01,1.6680E-01,1.9797E-01,2.2895E-01,2.6319E-01,
     &9.4443E-02,9.5498E-02,1.0898E-01,1.2351E-01,1.4175E-01,1.6646E-01,
     &1.9775E-01,2.2870E-01,2.6275E-01/
      DATA ((KA(JS,JT, 6,12),JS=1,9),JT=1,5) /
     &1.8140E-01,1.6408E-01,1.7552E-01,1.8196E-01,1.8674E-01,1.9489E-01,
     &2.1183E-01,2.4078E-01,2.7512E-01,1.8064E-01,1.6323E-01,1.7439E-01,
     &1.7956E-01,1.8547E-01,1.9334E-01,2.1068E-01,2.4042E-01,2.7473E-01,
     &1.7939E-01,1.6216E-01,1.7344E-01,1.7751E-01,1.8404E-01,1.9207E-01,
     &2.1020E-01,2.4067E-01,2.7502E-01,1.7796E-01,1.6097E-01,1.7233E-01,
     &1.7595E-01,1.8277E-01,1.9147E-01,2.0971E-01,2.4067E-01,2.7492E-01,
     &1.7632E-01,1.5943E-01,1.7056E-01,1.7456E-01,1.8167E-01,1.9081E-01,
     &2.0890E-01,2.4019E-01,2.7421E-01/
      DATA ((KA(JS,JT, 7,12),JS=1,9),JT=1,5) /
     &3.5379E-01,3.1064E-01,2.9565E-01,2.8816E-01,2.7694E-01,2.6472E-01,
     &2.4939E-01,2.5136E-01,2.8304E-01,3.5306E-01,3.1059E-01,2.9503E-01,
     &2.8682E-01,2.7447E-01,2.6248E-01,2.4787E-01,2.5077E-01,2.8333E-01,
     &3.5170E-01,3.1024E-01,2.9413E-01,2.8605E-01,2.7226E-01,2.6030E-01,
     &2.4686E-01,2.5055E-01,2.8358E-01,3.4988E-01,3.0935E-01,2.9228E-01,
     &2.8440E-01,2.7034E-01,2.5822E-01,2.4645E-01,2.4996E-01,2.8315E-01,
     &3.4759E-01,3.0773E-01,2.8986E-01,2.8199E-01,2.6823E-01,2.5660E-01,
     &2.4547E-01,2.4917E-01,2.8239E-01/
      DATA ((KA(JS,JT, 8,12),JS=1,9),JT=1,5) /
     &8.0496E-01,7.0527E-01,6.0910E-01,5.5199E-01,5.0022E-01,4.3776E-01,
     &3.7465E-01,3.0063E-01,2.8877E-01,8.0672E-01,7.0707E-01,6.1070E-01,
     &5.5311E-01,5.0061E-01,4.3582E-01,3.7176E-01,2.9952E-01,2.8902E-01,
     &8.0691E-01,7.0823E-01,6.1191E-01,5.5364E-01,5.0004E-01,4.3422E-01,
     &3.6951E-01,2.9892E-01,2.8876E-01,8.0527E-01,7.0753E-01,6.1153E-01,
     &5.5173E-01,4.9853E-01,4.3157E-01,3.6699E-01,2.9815E-01,2.8834E-01,
     &8.0219E-01,7.0523E-01,6.0964E-01,5.4776E-01,4.9536E-01,4.2816E-01,
     &3.6486E-01,2.9693E-01,2.8675E-01/
      DATA ((KA(JS,JT, 9,12),JS=1,9),JT=1,5) /
     &3.4182E+00,2.9916E+00,2.5652E+00,2.1389E+00,1.7153E+00,1.3419E+00,
     &1.0101E+00,6.4726E-01,2.8926E-01,3.4411E+00,3.0119E+00,2.5830E+00,
     &2.1544E+00,1.7278E+00,1.3490E+00,1.0168E+00,6.4570E-01,2.8901E-01,
     &3.4584E+00,3.0278E+00,2.5976E+00,2.1679E+00,1.7392E+00,1.3535E+00,
     &1.0208E+00,6.4462E-01,2.8863E-01,3.4643E+00,3.0337E+00,2.6033E+00,
     &2.1735E+00,1.7445E+00,1.3538E+00,1.0204E+00,6.4174E-01,2.8774E-01,
     &3.4625E+00,3.0324E+00,2.6029E+00,2.1736E+00,1.7453E+00,1.3500E+00,
     &1.0152E+00,6.3782E-01,2.8595E-01/
      DATA ((KA(JS,JT,10,12),JS=1,9),JT=1,5) /
     &1.6048E+01,1.4043E+01,1.2038E+01,1.0032E+01,8.0269E+00,6.0216E+00,
     &4.0164E+00,2.1217E+00,2.8227E-01,1.6256E+01,1.4226E+01,1.2195E+01,
     &1.0164E+01,8.1333E+00,6.1029E+00,4.0729E+00,2.1442E+00,2.8170E-01,
     &1.6399E+01,1.4351E+01,1.2303E+01,1.0255E+01,8.2073E+00,6.1596E+00,
     &4.1123E+00,2.1594E+00,2.8134E-01,1.6465E+01,1.4409E+01,1.2353E+01,
     &1.0297E+01,8.2414E+00,6.1861E+00,4.1319E+00,2.1644E+00,2.8049E-01,
     &1.6472E+01,1.4416E+01,1.2359E+01,1.0303E+01,8.2464E+00,6.1909E+00,
     &4.1366E+00,2.1582E+00,2.7905E-01/
      DATA ((KA(JS,JT,11,12),JS=1,9),JT=1,5) /
     &2.6190E+01,2.2917E+01,1.9644E+01,1.6372E+01,1.3098E+01,9.8258E+00,
     &6.5533E+00,3.3347E+00,2.0130E-01,2.6572E+01,2.3252E+01,1.9932E+01,
     &1.6612E+01,1.3292E+01,9.9715E+00,6.6522E+00,3.3768E+00,2.0375E-01,
     &2.6794E+01,2.3447E+01,2.0099E+01,1.6751E+01,1.3404E+01,1.0057E+01,
     &6.7102E+00,3.4019E+00,2.0648E-01,2.6905E+01,2.3544E+01,2.0183E+01,
     &1.6822E+01,1.3461E+01,1.0100E+01,6.7401E+00,3.4102E+00,2.0903E-01,
     &2.6968E+01,2.3599E+01,2.0230E+01,1.6860E+01,1.3492E+01,1.0123E+01,
     &6.7556E+00,3.4122E+00,2.1045E-01/
      DATA ((KA(JS,JT,12,12),JS=1,9),JT=1,5) /
     &3.1310E+01,2.7398E+01,2.3484E+01,1.9572E+01,1.5659E+01,1.1747E+01,
     &7.8342E+00,3.9879E+00,1.6283E-01,3.1751E+01,2.7784E+01,2.3816E+01,
     &1.9849E+01,1.5882E+01,1.1914E+01,7.9470E+00,4.0341E+00,1.6415E-01,
     &3.2043E+01,2.8038E+01,2.4036E+01,2.0032E+01,1.6028E+01,1.2025E+01,
     &8.0217E+00,4.0620E+00,1.6794E-01,3.2220E+01,2.8195E+01,2.4168E+01,
     &2.0143E+01,1.6116E+01,1.2091E+01,8.0659E+00,4.0753E+00,1.6850E-01,
     &3.2373E+01,2.8329E+01,2.4283E+01,2.0239E+01,1.6193E+01,1.2149E+01,
     &8.1043E+00,4.0871E+00,1.6988E-01/
      DATA ((KA(JS,JT,13,12),JS=1,9),JT=1,5) /
     &2.9544E+01,2.5852E+01,2.2161E+01,1.8469E+01,1.4777E+01,1.1085E+01,
     &7.3931E+00,3.8439E+00,1.2880E-01,2.9974E+01,2.6228E+01,2.2483E+01,
     &1.8737E+01,1.4992E+01,1.1247E+01,7.5021E+00,3.8830E+00,1.3338E-01,
     &3.0254E+01,2.6474E+01,2.2694E+01,1.8912E+01,1.5132E+01,1.1352E+01,
     &7.5719E+00,3.9004E+00,1.3721E-01,3.0504E+01,2.6693E+01,2.2881E+01,
     &1.9069E+01,1.5258E+01,1.1446E+01,7.6348E+00,3.9163E+00,1.3871E-01,
     &3.0781E+01,2.6934E+01,2.3088E+01,1.9241E+01,1.5395E+01,1.1550E+01,
     &7.7042E+00,3.9392E+00,1.4036E-01/
      DATA ((KA(JS,JT, 1,13),JS=1,9),JT=1,5) /
     &9.0088E-03,3.7171E-02,7.3185E-02,1.0841E-01,1.4222E-01,1.7328E-01,
     &1.9823E-01,2.0424E-01,2.8396E-01,8.8070E-03,3.7017E-02,7.2761E-02,
     &1.0769E-01,1.4122E-01,1.7208E-01,1.9703E-01,2.0324E-01,2.8185E-01,
     &8.6641E-03,3.6729E-02,7.2126E-02,1.0675E-01,1.4002E-01,1.7072E-01,
     &1.9555E-01,2.0207E-01,2.7936E-01,8.5351E-03,3.6304E-02,7.1373E-02,
     &1.0562E-01,1.3853E-01,1.6891E-01,1.9361E-01,2.0011E-01,2.7631E-01,
     &8.4180E-03,3.5892E-02,7.0613E-02,1.0456E-01,1.3716E-01,1.6725E-01,
     &1.9159E-01,1.9822E-01,2.7366E-01/
      DATA ((KA(JS,JT, 2,13),JS=1,9),JT=1,5) /
     &1.4629E-02,4.1401E-02,8.1344E-02,1.2092E-01,1.5970E-01,1.9686E-01,
     &2.3007E-01,2.4893E-01,3.1872E-01,1.4347E-02,4.1149E-02,8.0754E-02,
     &1.2000E-01,1.5844E-01,1.9525E-01,2.2811E-01,2.4701E-01,3.1592E-01,
     &1.4116E-02,4.0731E-02,7.9979E-02,1.1881E-01,1.5685E-01,1.9333E-01,
     &2.2600E-01,2.4518E-01,3.1267E-01,1.3916E-02,4.0235E-02,7.9131E-02,
     &1.1757E-01,1.5518E-01,1.9122E-01,2.2354E-01,2.4260E-01,3.0926E-01,
     &1.3712E-02,3.9826E-02,7.8358E-02,1.1644E-01,1.5370E-01,1.8938E-01,
     &2.2131E-01,2.4017E-01,3.0647E-01/
      DATA ((KA(JS,JT, 3,13),JS=1,9),JT=1,5) /
     &3.2046E-02,5.1387E-02,8.9167E-02,1.3251E-01,1.7557E-01,2.1798E-01,
     &2.5867E-01,2.9276E-01,3.4967E-01,3.1484E-02,5.0885E-02,8.8511E-02,
     &1.3146E-01,1.7409E-01,2.1604E-01,2.5621E-01,2.8967E-01,3.4641E-01,
     &3.1011E-02,5.0194E-02,8.7651E-02,1.3011E-01,1.7226E-01,2.1375E-01,
     &2.5357E-01,2.8697E-01,3.4255E-01,3.0595E-02,4.9306E-02,8.6747E-02,
     &1.2888E-01,1.7065E-01,2.1172E-01,2.5094E-01,2.8374E-01,3.3932E-01,
     &3.0114E-02,4.8480E-02,8.6058E-02,1.2788E-01,1.6935E-01,2.1010E-01,
     &2.4901E-01,2.8126E-01,3.3697E-01/
      DATA ((KA(JS,JT, 4,13),JS=1,9),JT=1,5) /
     &7.1437E-02,7.9531E-02,1.0765E-01,1.4496E-01,1.9060E-01,2.3699E-01,
     &2.8255E-01,3.2483E-01,3.7856E-01,7.0222E-02,7.8795E-02,1.0643E-01,
     &1.4338E-01,1.8881E-01,2.3460E-01,2.7960E-01,3.2131E-01,3.7439E-01,
     &6.9262E-02,7.7852E-02,1.0486E-01,1.4165E-01,1.8684E-01,2.3207E-01,
     &2.7650E-01,3.1773E-01,3.7008E-01,6.8383E-02,7.7009E-02,1.0310E-01,
     &1.4004E-01,1.8506E-01,2.2994E-01,2.7397E-01,3.1473E-01,3.6682E-01,
     &6.7482E-02,7.6264E-02,1.0166E-01,1.3889E-01,1.8370E-01,2.2828E-01,
     &2.7201E-01,3.1244E-01,3.6430E-01/
      DATA ((KA(JS,JT, 5,13),JS=1,9),JT=1,5) /
     &1.4624E-01,1.3361E-01,1.5693E-01,1.7752E-01,2.1095E-01,2.5537E-01,
     &3.0486E-01,3.5270E-01,4.0651E-01,1.4398E-01,1.3165E-01,1.5512E-01,
     &1.7519E-01,2.0814E-01,2.5302E-01,3.0184E-01,3.4895E-01,4.0217E-01,
     &1.4207E-01,1.3000E-01,1.5346E-01,1.7248E-01,2.0524E-01,2.5056E-01,
     &2.9880E-01,3.4528E-01,3.9789E-01,1.4038E-01,1.2884E-01,1.5157E-01,
     &1.6985E-01,2.0246E-01,2.4823E-01,2.9613E-01,3.4225E-01,3.9462E-01,
     &1.3874E-01,1.2784E-01,1.4941E-01,1.6780E-01,2.0033E-01,2.4657E-01,
     &2.9417E-01,3.3986E-01,3.9218E-01/
      DATA ((KA(JS,JT, 6,13),JS=1,9),JT=1,5) /
     &2.8046E-01,2.4640E-01,2.4558E-01,2.5477E-01,2.6318E-01,2.8661E-01,
     &3.2769E-01,3.7985E-01,4.3568E-01,2.7643E-01,2.4318E-01,2.4273E-01,
     &2.5156E-01,2.5913E-01,2.8275E-01,3.2478E-01,3.7621E-01,4.3126E-01,
     &2.7290E-01,2.4050E-01,2.4016E-01,2.4894E-01,2.5526E-01,2.7880E-01,
     &3.2177E-01,3.7266E-01,4.2706E-01,2.7013E-01,2.3869E-01,2.3760E-01,
     &2.4573E-01,2.5166E-01,2.7510E-01,3.1929E-01,3.6982E-01,4.2412E-01,
     &2.6724E-01,2.3701E-01,2.3563E-01,2.4210E-01,2.4866E-01,2.7240E-01,
     &3.1774E-01,3.6799E-01,4.2206E-01/
      DATA ((KA(JS,JT, 7,13),JS=1,9),JT=1,5) /
     &5.6688E-01,4.9674E-01,4.3519E-01,4.2029E-01,3.9894E-01,3.7594E-01,
     &3.7424E-01,4.0700E-01,4.6486E-01,5.6062E-01,4.9147E-01,4.2917E-01,
     &4.1552E-01,3.9325E-01,3.7043E-01,3.6935E-01,4.0348E-01,4.6044E-01,
     &5.5419E-01,4.8620E-01,4.2405E-01,4.1052E-01,3.8832E-01,3.6566E-01,
     &3.6433E-01,4.0051E-01,4.5715E-01,5.4908E-01,4.8208E-01,4.2069E-01,
     &4.0630E-01,3.8346E-01,3.6097E-01,3.5952E-01,3.9819E-01,4.5457E-01,
     &5.4429E-01,4.7829E-01,4.1793E-01,4.0260E-01,3.7854E-01,3.5674E-01,
     &3.5560E-01,3.9638E-01,4.5240E-01/
      DATA ((KA(JS,JT, 8,13),JS=1,9),JT=1,5) /
     &1.3466E+00,1.1788E+00,1.0111E+00,8.5366E-01,7.5173E-01,6.5869E-01,
     &5.4376E-01,4.6329E-01,4.8785E-01,1.3340E+00,1.1680E+00,1.0021E+00,
     &8.4354E-01,7.4161E-01,6.4846E-01,5.3530E-01,4.5751E-01,4.8487E-01,
     &1.3215E+00,1.1573E+00,9.9337E-01,8.3476E-01,7.3374E-01,6.3918E-01,
     &5.2901E-01,4.5174E-01,4.8277E-01,1.3130E+00,1.1502E+00,9.8764E-01,
     &8.2958E-01,7.2734E-01,6.3251E-01,5.2258E-01,4.4677E-01,4.8075E-01,
     &1.3037E+00,1.1423E+00,9.8136E-01,8.2511E-01,7.2245E-01,6.2665E-01,
     &5.1636E-01,4.4197E-01,4.7928E-01/
      DATA ((KA(JS,JT, 9,13),JS=1,9),JT=1,5) /
     &6.0221E+00,5.2697E+00,4.5174E+00,3.7653E+00,3.0129E+00,2.2622E+00,
     &1.5952E+00,9.9726E-01,5.0671E-01,5.9755E+00,5.2290E+00,4.4828E+00,
     &3.7364E+00,2.9901E+00,2.2441E+00,1.5732E+00,9.8172E-01,5.0573E-01,
     &5.9358E+00,5.1947E+00,4.4536E+00,3.7125E+00,2.9715E+00,2.2305E+00,
     &1.5561E+00,9.6836E-01,5.0514E-01,5.9085E+00,5.1712E+00,4.4336E+00,
     &3.6962E+00,2.9588E+00,2.2217E+00,1.5446E+00,9.5878E-01,5.0373E-01,
     &5.8741E+00,5.1412E+00,4.4082E+00,3.6753E+00,2.9426E+00,2.2110E+00,
     &1.5366E+00,9.5070E-01,5.0223E-01/
      DATA ((KA(JS,JT,10,13),JS=1,9),JT=1,5) /
     &2.9983E+01,2.6236E+01,2.2488E+01,1.8741E+01,1.4994E+01,1.1246E+01,
     &7.4983E+00,3.7584E+00,5.2065E-01,2.9796E+01,2.6072E+01,2.2348E+01,
     &1.8624E+01,1.4900E+01,1.1176E+01,7.4520E+00,3.7308E+00,5.2186E-01,
     &2.9702E+01,2.5989E+01,2.2278E+01,1.8566E+01,1.4854E+01,1.1142E+01,
     &7.4298E+00,3.7183E+00,5.2236E-01,2.9648E+01,2.5942E+01,2.2238E+01,
     &1.8533E+01,1.4828E+01,1.1123E+01,7.4177E+00,3.7128E+00,5.2097E-01,
     &2.9599E+01,2.5901E+01,2.2202E+01,1.8502E+01,1.4804E+01,1.1105E+01,
     &7.4063E+00,3.7092E+00,5.1987E-01/
      DATA ((KA(JS,JT,11,13),JS=1,9),JT=1,5) /
     &5.1290E+01,4.4882E+01,3.8471E+01,3.2058E+01,2.5646E+01,1.9236E+01,
     &1.2824E+01,6.4141E+00,5.2983E-01,5.1244E+01,4.4838E+01,3.8434E+01,
     &3.2028E+01,2.5623E+01,1.9219E+01,1.2814E+01,6.4089E+00,5.3215E-01,
     &5.1318E+01,4.4905E+01,3.8491E+01,3.2076E+01,2.5662E+01,1.9248E+01,
     &1.2833E+01,6.4196E+00,5.3209E-01,5.1488E+01,4.5053E+01,3.8617E+01,
     &3.2182E+01,2.5747E+01,1.9312E+01,1.2877E+01,6.4422E+00,5.3137E-01,
     &5.1544E+01,4.5101E+01,3.8659E+01,3.2218E+01,2.5776E+01,1.9335E+01,
     &1.2893E+01,6.4519E+00,5.3038E-01/
      DATA ((KA(JS,JT,12,13),JS=1,9),JT=1,5) /
     &6.4625E+01,5.6547E+01,4.8469E+01,4.0391E+01,3.2315E+01,2.4238E+01,
     &1.6158E+01,8.0814E+00,4.6363E-01,6.4981E+01,5.6858E+01,4.8737E+01,
     &4.0614E+01,3.2493E+01,2.4371E+01,1.6249E+01,8.1265E+00,4.7141E-01,
     &6.5489E+01,5.7301E+01,4.9118E+01,4.0933E+01,3.2747E+01,2.4562E+01,
     &1.6376E+01,8.1908E+00,4.7318E-01,6.5927E+01,5.7688E+01,4.9446E+01,
     &4.1208E+01,3.2967E+01,2.4727E+01,1.6488E+01,8.2475E+00,4.7664E-01,
     &6.6087E+01,5.7823E+01,4.9566E+01,4.1306E+01,3.3048E+01,2.4787E+01,
     &1.6528E+01,8.2690E+00,4.7820E-01/
      DATA ((KA(JS,JT,13,13),JS=1,9),JT=1,5) /
     &6.4615E+01,5.6540E+01,4.8462E+01,4.0385E+01,3.2309E+01,2.4232E+01,
     &1.6156E+01,8.0805E+00,4.0088E-01,6.5417E+01,5.7241E+01,4.9064E+01,
     &4.0887E+01,3.2711E+01,2.4534E+01,1.6357E+01,8.1804E+00,3.9953E-01,
     &6.6282E+01,5.7998E+01,4.9715E+01,4.1430E+01,3.3145E+01,2.4860E+01,
     &1.6576E+01,8.2909E+00,4.0385E-01,6.6847E+01,5.8491E+01,5.0137E+01,
     &4.1781E+01,3.3427E+01,2.5072E+01,1.6717E+01,8.3627E+00,4.1064E-01,
     &6.7163E+01,5.8769E+01,5.0375E+01,4.1983E+01,3.3587E+01,2.5193E+01,
     &1.6798E+01,8.4033E+00,4.1414E-01/
      DATA ((KA(JS,JT, 1,14),JS=1,9),JT=1,5) /
     &1.2012E-02,4.7001E-02,9.2646E-02,1.3669E-01,1.7808E-01,2.1465E-01,
     &2.4110E-01,2.4013E-01,3.5593E-01,1.1787E-02,4.6471E-02,9.1548E-02,
     &1.3506E-01,1.7598E-01,2.1215E-01,2.3833E-01,2.3702E-01,3.5168E-01,
     &1.1552E-02,4.6117E-02,9.0846E-02,1.3398E-01,1.7452E-01,2.1037E-01,
     &2.3630E-01,2.3518E-01,3.4867E-01,1.1308E-02,4.5919E-02,9.0260E-02,
     &1.3312E-01,1.7345E-01,2.0914E-01,2.3511E-01,2.3456E-01,3.4647E-01,
     &1.1074E-02,4.5680E-02,8.9686E-02,1.3217E-01,1.7213E-01,2.0750E-01,
     &2.3330E-01,2.3291E-01,3.4372E-01/
      DATA ((KA(JS,JT, 2,14),JS=1,9),JT=1,5) /
     &1.9894E-02,5.5751E-02,1.1015E-01,1.6336E-01,2.1450E-01,2.6180E-01,
     &3.0044E-01,3.1221E-01,4.2855E-01,1.9495E-02,5.5076E-02,1.0879E-01,
     &1.6130E-01,2.1180E-01,2.5853E-01,2.9678E-01,3.0859E-01,4.2309E-01,
     &1.9117E-02,5.4639E-02,1.0781E-01,1.5983E-01,2.0983E-01,2.5605E-01,
     &2.9379E-01,3.0533E-01,4.1905E-01,1.8729E-02,5.4397E-02,1.0705E-01,
     &1.5861E-01,2.0822E-01,2.5408E-01,2.9159E-01,3.0324E-01,4.1584E-01,
     &1.8354E-02,5.4135E-02,1.0645E-01,1.5762E-01,2.0683E-01,2.5235E-01,
     &2.8960E-01,3.0120E-01,4.1280E-01/
      DATA ((KA(JS,JT, 3,14),JS=1,9),JT=1,5) /
     &4.4808E-02,6.8120E-02,1.3030E-01,1.9402E-01,2.5661E-01,3.1701E-01,
     &3.7210E-01,4.0841E-01,5.1219E-01,4.3894E-02,6.7026E-02,1.2859E-01,
     &1.9144E-01,2.5317E-01,3.1271E-01,3.6711E-01,4.0328E-01,5.0524E-01,
     &4.3009E-02,6.6189E-02,1.2745E-01,1.8969E-01,2.5081E-01,3.0975E-01,
     &3.6348E-01,3.9877E-01,5.0039E-01,4.2131E-02,6.5604E-02,1.2666E-01,
     &1.8820E-01,2.4871E-01,3.0709E-01,3.6038E-01,3.9547E-01,4.9608E-01,
     &4.1300E-02,6.4954E-02,1.2597E-01,1.8706E-01,2.4708E-01,3.0499E-01,
     &3.5781E-01,3.9252E-01,4.9231E-01/
      DATA ((KA(JS,JT, 4,14),JS=1,9),JT=1,5) /
     &1.0301E-01,1.0024E-01,1.5513E-01,2.2660E-01,3.0051E-01,3.7330E-01,
     &4.4331E-01,5.0277E-01,5.9886E-01,1.0093E-01,9.7693E-02,1.5244E-01,
     &2.2368E-01,2.9661E-01,3.6838E-01,4.3740E-01,4.9600E-01,5.9091E-01,
     &9.8888E-02,9.5814E-02,1.5056E-01,2.2160E-01,2.9368E-01,3.6475E-01,
     &4.3305E-01,4.9087E-01,5.8504E-01,9.6900E-02,9.4385E-02,1.4923E-01,
     &2.1998E-01,2.9118E-01,3.6134E-01,4.2884E-01,4.8615E-01,5.7910E-01,
     &9.5071E-02,9.3054E-02,1.4811E-01,2.1854E-01,2.8905E-01,3.5852E-01,
     &4.2539E-01,4.8206E-01,5.7407E-01/
      DATA ((KA(JS,JT, 5,14),JS=1,9),JT=1,5) /
     &2.1660E-01,1.9045E-01,2.0807E-01,2.6919E-01,3.4511E-01,4.2945E-01,
     &5.1231E-01,5.8951E-01,6.8618E-01,2.1241E-01,1.8672E-01,2.0475E-01,
     &2.6424E-01,3.4065E-01,4.2384E-01,5.0554E-01,5.8155E-01,6.7701E-01,
     &2.0837E-01,1.8314E-01,2.0195E-01,2.6053E-01,3.3744E-01,4.1942E-01,
     &5.0021E-01,5.7551E-01,6.6986E-01,2.0430E-01,1.7971E-01,1.9948E-01,
     &2.5756E-01,3.3465E-01,4.1558E-01,4.9517E-01,5.6937E-01,6.6243E-01,
     &2.0042E-01,1.7656E-01,1.9774E-01,2.5482E-01,3.3186E-01,4.1183E-01,
     &4.9052E-01,5.6389E-01,6.5569E-01/
      DATA ((KA(JS,JT, 6,14),JS=1,9),JT=1,5) /
     &4.2427E-01,3.7203E-01,3.3320E-01,3.5686E-01,4.1154E-01,4.8492E-01,
     &5.7932E-01,6.7077E-01,7.7255E-01,4.1690E-01,3.6557E-01,3.2503E-01,
     &3.5212E-01,4.0345E-01,4.7827E-01,5.7140E-01,6.6143E-01,7.6181E-01,
     &4.0958E-01,3.5909E-01,3.1787E-01,3.4706E-01,3.9704E-01,4.7318E-01,
     &5.6463E-01,6.5338E-01,7.5243E-01,4.0201E-01,3.5239E-01,3.1191E-01,
     &3.4259E-01,3.9161E-01,4.6839E-01,5.5839E-01,6.4570E-01,7.4289E-01,
     &3.9475E-01,3.4591E-01,3.0639E-01,3.3917E-01,3.8642E-01,4.6363E-01,
     &5.5236E-01,6.3841E-01,7.3426E-01/
      DATA ((KA(JS,JT, 7,14),JS=1,9),JT=1,5) /
     &8.8029E-01,7.7094E-01,6.6160E-01,5.8339E-01,5.7398E-01,5.9529E-01,
     &6.4618E-01,7.4819E-01,8.5701E-01,8.6525E-01,7.5771E-01,6.5024E-01,
     &5.6937E-01,5.6534E-01,5.8297E-01,6.3577E-01,7.3677E-01,8.4377E-01,
     &8.5121E-01,7.4536E-01,6.3948E-01,5.5760E-01,5.5733E-01,5.7172E-01,
     &6.2728E-01,7.2631E-01,8.3134E-01,8.3673E-01,7.3261E-01,6.2850E-01,
     &5.4720E-01,5.4987E-01,5.6219E-01,6.1953E-01,7.1698E-01,8.1995E-01,
     &8.2233E-01,7.1991E-01,6.1754E-01,5.3796E-01,5.4354E-01,5.5330E-01,
     &6.1303E-01,7.0902E-01,8.1040E-01/
      DATA ((KA(JS,JT, 8,14),JS=1,9),JT=1,5) /
     &2.1633E+00,1.8933E+00,1.6233E+00,1.3534E+00,1.1037E+00,9.5036E-01,
     &8.5982E-01,8.2829E-01,9.4205E-01,2.1282E+00,1.8626E+00,1.5970E+00,
     &1.3314E+00,1.0818E+00,9.3527E-01,8.4498E-01,8.1322E-01,9.2537E-01,
     &2.0953E+00,1.8337E+00,1.5723E+00,1.3107E+00,1.0621E+00,9.2114E-01,
     &8.2743E-01,8.0051E-01,9.1039E-01,2.0607E+00,1.8035E+00,1.5462E+00,
     &1.2890E+00,1.0433E+00,9.0766E-01,8.1242E-01,7.8938E-01,8.9703E-01,
     &2.0272E+00,1.7741E+00,1.5210E+00,1.2680E+00,1.0246E+00,8.9475E-01,
     &7.9856E-01,7.8051E-01,8.8639E-01/
      DATA ((KA(JS,JT, 9,14),JS=1,9),JT=1,5) /
     &1.0073E+01,8.8141E+00,7.5553E+00,6.2968E+00,5.0379E+00,3.7790E+00,
     &2.5252E+00,1.5121E+00,1.0239E+00,9.9292E+00,8.6881E+00,7.4471E+00,
     &6.2062E+00,4.9656E+00,3.7249E+00,2.4866E+00,1.4902E+00,1.0036E+00,
     &9.7859E+00,8.5628E+00,7.3398E+00,6.1169E+00,4.8940E+00,3.6711E+00,
     &2.4492E+00,1.4699E+00,9.8554E-01,9.6386E+00,8.4340E+00,7.2293E+00,
     &6.0249E+00,4.8203E+00,3.6156E+00,2.4114E+00,1.4506E+00,9.7113E-01,
     &9.4939E+00,8.3072E+00,7.1206E+00,5.9343E+00,4.7478E+00,3.5614E+00,
     &2.3752E+00,1.4305E+00,9.6050E-01/
      DATA ((KA(JS,JT,10,14),JS=1,9),JT=1,5) /
     &5.2612E+01,4.6036E+01,3.9459E+01,3.2882E+01,2.6307E+01,1.9730E+01,
     &1.3154E+01,6.5782E+00,1.1007E+00,5.2045E+01,4.5541E+01,3.9035E+01,
     &3.2530E+01,2.6024E+01,1.9518E+01,1.3013E+01,6.5076E+00,1.0772E+00,
     &5.1396E+01,4.4972E+01,3.8548E+01,3.2123E+01,2.5700E+01,1.9274E+01,
     &1.2851E+01,6.4259E+00,1.0576E+00,5.0681E+01,4.4348E+01,3.8014E+01,
     &3.1677E+01,2.5342E+01,1.9007E+01,1.2671E+01,6.3366E+00,1.0433E+00,
     &4.9909E+01,4.3671E+01,3.7433E+01,3.1194E+01,2.4957E+01,1.8717E+01,
     &1.2479E+01,6.2406E+00,1.0315E+00/
      DATA ((KA(JS,JT,11,14),JS=1,9),JT=1,5) /
     &9.5447E+01,8.3519E+01,7.1586E+01,5.9654E+01,4.7724E+01,3.5792E+01,
     &2.3862E+01,1.1932E+01,1.1580E+00,9.4633E+01,8.2803E+01,7.0974E+01,
     &5.9145E+01,4.7317E+01,3.5487E+01,2.3658E+01,1.1830E+01,1.1359E+00,
     &9.3512E+01,8.1822E+01,7.0137E+01,5.8447E+01,4.6756E+01,3.5068E+01,
     &2.3379E+01,1.1690E+01,1.1191E+00,9.1943E+01,8.0451E+01,6.8957E+01,
     &5.7463E+01,4.5972E+01,3.4478E+01,2.2985E+01,1.1494E+01,1.1048E+00,
     &9.0366E+01,7.9072E+01,6.7775E+01,5.6480E+01,4.5183E+01,3.3888E+01,
     &2.2593E+01,1.1297E+01,1.0941E+00/
      DATA ((KA(JS,JT,12,14),JS=1,9),JT=1,5) /
     &1.2829E+02,1.1225E+02,9.6218E+01,8.0178E+01,6.4148E+01,4.8109E+01,
     &3.2071E+01,1.6037E+01,1.2082E+00,1.2686E+02,1.1100E+02,9.5144E+01,
     &7.9288E+01,6.3431E+01,4.7572E+01,3.1716E+01,1.5858E+01,1.1882E+00,
     &1.2492E+02,1.0930E+02,9.3686E+01,7.8073E+01,6.2461E+01,4.6846E+01,
     &3.1229E+01,1.5615E+01,1.1735E+00,1.2277E+02,1.0742E+02,9.2079E+01,
     &7.6735E+01,6.1388E+01,4.6041E+01,3.0695E+01,1.5349E+01,1.1628E+00,
     &1.2083E+02,1.0573E+02,9.0624E+01,7.5519E+01,6.0418E+01,4.5314E+01,
     &3.0211E+01,1.5107E+01,1.1538E+00/
      DATA ((KA(JS,JT,13,14),JS=1,9),JT=1,5) /
     &1.3638E+02,1.1933E+02,1.0229E+02,8.5232E+01,6.8189E+01,5.1142E+01,
     &3.4096E+01,1.7048E+01,1.2383E+00,1.3472E+02,1.1788E+02,1.0104E+02,
     &8.4200E+01,6.7359E+01,5.0520E+01,3.3681E+01,1.6841E+01,1.2326E+00,
     &1.3259E+02,1.1602E+02,9.9447E+01,8.2873E+01,6.6300E+01,4.9725E+01,
     &3.3151E+01,1.6576E+01,1.2214E+00,1.3062E+02,1.1429E+02,9.7966E+01,
     &8.1640E+01,6.5311E+01,4.8985E+01,3.2658E+01,1.6329E+01,1.2124E+00,
     &1.2869E+02,1.1261E+02,9.6524E+01,8.0437E+01,6.4351E+01,4.8263E+01,
     &3.2178E+01,1.6090E+01,1.2063E+00/
      DATA ((KA(JS,JT, 1,15),JS=1,9),JT=1,5) /
     &1.6224E-02,5.5981E-02,1.1058E-01,1.6311E-01,2.1224E-01,2.5534E-01,
     &2.8563E-01,2.8102E-01,4.2449E-01,1.5819E-02,5.4235E-02,1.0708E-01,
     &1.5789E-01,2.0538E-01,2.4690E-01,2.7600E-01,2.7172E-01,4.1075E-01,
     &1.5437E-02,5.3030E-02,1.0453E-01,1.5410E-01,2.0034E-01,2.4064E-01,
     &2.6869E-01,2.6394E-01,4.0067E-01,1.5047E-02,5.2309E-02,1.0294E-01,
     &1.5163E-01,1.9708E-01,2.3671E-01,2.6420E-01,2.5937E-01,3.9409E-01,
     &1.4670E-02,5.2264E-02,1.0263E-01,1.5109E-01,1.9635E-01,2.3592E-01,
     &2.6369E-01,2.6037E-01,3.9232E-01/
      DATA ((KA(JS,JT, 2,15),JS=1,9),JT=1,5) /
     &2.7874E-02,6.8016E-02,1.3490E-01,2.0013E-01,2.6255E-01,3.1976E-01,
     &3.6546E-01,3.7626E-01,5.2506E-01,2.7188E-02,6.5949E-02,1.3068E-01,
     &1.9379E-01,2.5414E-01,3.0936E-01,3.5322E-01,3.6307E-01,5.0826E-01,
     &2.6530E-02,6.4457E-02,1.2748E-01,1.8895E-01,2.4773E-01,3.0143E-01,
     &3.4397E-01,3.5278E-01,4.9544E-01,2.5866E-02,6.3478E-02,1.2538E-01,
     &1.8573E-01,2.4341E-01,2.9608E-01,3.3770E-01,3.4604E-01,4.8658E-01,
     &2.5184E-02,6.3069E-02,1.2422E-01,1.8387E-01,2.4089E-01,2.9292E-01,
     &3.3402E-01,3.4222E-01,4.8125E-01/
      DATA ((KA(JS,JT, 3,15),JS=1,9),JT=1,5) /
     &6.4680E-02,8.3094E-02,1.6505E-01,2.4624E-01,3.2572E-01,4.0189E-01,
     &4.7033E-01,5.1238E-01,6.5139E-01,6.3121E-02,8.0680E-02,1.6005E-01,
     &2.3872E-01,3.1571E-01,3.8944E-01,4.5551E-01,4.9522E-01,6.3135E-01,
     &6.1563E-02,7.8867E-02,1.5612E-01,2.3258E-01,3.0746E-01,3.7914E-01,
     &4.4323E-01,4.8117E-01,6.1483E-01,6.0025E-02,7.7639E-02,1.5328E-01,
     &2.2820E-01,3.0153E-01,3.7164E-01,4.3426E-01,4.7103E-01,6.0254E-01,
     &5.8411E-02,7.7256E-02,1.5120E-01,2.2490E-01,2.9704E-01,3.6599E-01,
     &4.2759E-01,4.6376E-01,5.9316E-01/
      DATA ((KA(JS,JT, 4,15),JS=1,9),JT=1,5) /
     &1.5257E-01,1.3544E-01,2.0077E-01,3.0036E-01,3.9895E-01,4.9562E-01,
     &5.8758E-01,6.6215E-01,7.9779E-01,1.4896E-01,1.3204E-01,1.9507E-01,
     &2.9140E-01,3.8695E-01,4.8067E-01,5.6978E-01,6.4163E-01,7.7379E-01,
     &1.4526E-01,1.2874E-01,1.9046E-01,2.8415E-01,3.7702E-01,4.6809E-01,
     &5.5459E-01,6.2416E-01,7.5329E-01,1.4150E-01,1.2551E-01,1.8699E-01,
     &2.7869E-01,3.6960E-01,4.5869E-01,5.4325E-01,6.1092E-01,7.3794E-01,
     &1.3788E-01,1.2292E-01,1.8424E-01,2.7423E-01,3.6354E-01,4.5105E-01,
     &5.3408E-01,6.0044E-01,7.2537E-01/
      DATA ((KA(JS,JT, 5,15),JS=1,9),JT=1,5) /
     &3.2844E-01,2.8856E-01,2.7979E-01,3.6340E-01,4.8359E-01,6.0259E-01,
     &7.1867E-01,8.2355E-01,9.6702E-01,3.2063E-01,2.8155E-01,2.6962E-01,
     &3.5320E-01,4.6960E-01,5.8494E-01,6.9755E-01,7.9908E-01,9.3875E-01,
     &3.1261E-01,2.7434E-01,2.6034E-01,3.4461E-01,4.5775E-01,5.6986E-01,
     &6.7919E-01,7.7764E-01,9.1375E-01,3.0440E-01,2.6704E-01,2.5252E-01,
     &3.3787E-01,4.4841E-01,5.5807E-01,6.6481E-01,7.6089E-01,8.9431E-01,
     &2.9686E-01,2.6035E-01,2.4591E-01,3.3225E-01,4.4072E-01,5.4821E-01,
     &6.5299E-01,7.4709E-01,8.7822E-01/
      DATA ((KA(JS,JT, 6,15),JS=1,9),JT=1,5) /
     &6.6195E-01,5.8013E-01,4.9831E-01,4.9605E-01,5.8178E-01,7.2595E-01,
     &8.6836E-01,1.0033E+00,1.1633E+00,6.4501E-01,5.6519E-01,4.8535E-01,
     &4.7586E-01,5.6606E-01,7.0584E-01,8.4395E-01,9.7492E-01,1.1306E+00,
     &6.2808E-01,5.5020E-01,4.7240E-01,4.5801E-01,5.5243E-01,6.8837E-01,
     &8.2269E-01,9.4987E-01,1.1015E+00,6.1101E-01,5.3520E-01,4.5941E-01,
     &4.4278E-01,5.4121E-01,6.7408E-01,8.0538E-01,9.2955E-01,1.0781E+00,
     &5.9524E-01,5.2132E-01,4.4745E-01,4.2965E-01,5.3187E-01,6.6218E-01,
     &7.9084E-01,9.1257E-01,1.0584E+00/
      DATA ((KA(JS,JT, 7,15),JS=1,9),JT=1,5) /
     &1.4144E+00,1.2384E+00,1.0623E+00,8.8626E-01,8.1737E-01,8.6950E-01,
     &1.0395E+00,1.2069E+00,1.3892E+00,1.3748E+00,1.2036E+00,1.0323E+00,
     &8.6117E-01,7.8383E-01,8.4592E-01,1.0122E+00,1.1745E+00,1.3519E+00,
     &1.3356E+00,1.1692E+00,1.0028E+00,8.3643E-01,7.5357E-01,8.2575E-01,
     &9.8798E-01,1.1461E+00,1.3189E+00,1.2972E+00,1.1356E+00,9.7391E-01,
     &8.1222E-01,7.2715E-01,8.0916E-01,9.6777E-01,1.1223E+00,1.2914E+00,
     &1.2621E+00,1.1049E+00,9.4752E-01,7.9014E-01,7.0399E-01,7.9481E-01,
     &9.5022E-01,1.1017E+00,1.2675E+00/
      DATA ((KA(JS,JT, 8,15),JS=1,9),JT=1,5) /
     &3.5678E+00,3.1226E+00,2.6774E+00,2.2323E+00,1.7871E+00,1.4068E+00,
     &1.2751E+00,1.4347E+00,1.6442E+00,3.4620E+00,3.0298E+00,2.5977E+00,
     &2.1657E+00,1.7337E+00,1.3525E+00,1.2330E+00,1.4002E+00,1.6038E+00,
     &3.3581E+00,2.9387E+00,2.5197E+00,2.1005E+00,1.6813E+00,1.3030E+00,
     &1.1987E+00,1.3683E+00,1.5668E+00,3.2581E+00,2.8514E+00,2.4446E+00,
     &2.0378E+00,1.6310E+00,1.2580E+00,1.1700E+00,1.3407E+00,1.5349E+00,
     &3.1664E+00,2.7709E+00,2.3756E+00,1.9802E+00,1.5848E+00,1.2171E+00,
     &1.1461E+00,1.3159E+00,1.5061E+00/
      DATA ((KA(JS,JT, 9,15),JS=1,9),JT=1,5) /
     &1.6997E+01,1.4874E+01,1.2750E+01,1.0625E+01,8.5017E+00,6.3777E+00,
     &4.2536E+00,2.2902E+00,1.9313E+00,1.6471E+01,1.4414E+01,1.2355E+01,
     &1.0296E+01,8.2389E+00,6.1803E+00,4.1219E+00,2.1942E+00,1.8874E+00,
     &1.5959E+01,1.3964E+01,1.1970E+01,9.9759E+00,7.9817E+00,5.9872E+00,
     &3.9932E+00,2.1070E+00,1.8460E+00,1.5470E+01,1.3538E+01,1.1604E+01,
     &9.6708E+00,7.7374E+00,5.8040E+00,3.8707E+00,2.0267E+00,1.8089E+00,
     &1.5020E+01,1.3143E+01,1.1265E+01,9.3885E+00,7.5114E+00,5.6345E+00,
     &3.7577E+00,1.9548E+00,1.7742E+00/
      DATA ((KA(JS,JT,10,15),JS=1,9),JT=1,5) /
     &9.0636E+01,7.9307E+01,6.7977E+01,5.6649E+01,4.5320E+01,3.3991E+01,
     &2.2662E+01,1.1334E+01,2.2438E+00,8.7565E+01,7.6621E+01,6.5675E+01,
     &5.4728E+01,4.3786E+01,3.2842E+01,2.1895E+01,1.0950E+01,2.1955E+00,
     &8.4686E+01,7.4100E+01,6.3516E+01,5.2929E+01,4.2345E+01,3.1759E+01,
     &2.1174E+01,1.0590E+01,2.1489E+00,8.2038E+01,7.1783E+01,6.1529E+01,
     &5.1276E+01,4.1020E+01,3.0766E+01,2.0512E+01,1.0258E+01,2.1057E+00,
     &7.9656E+01,6.9701E+01,5.9744E+01,4.9787E+01,3.9829E+01,2.9874E+01,
     &1.9917E+01,9.9593E+00,2.0648E+00/
      DATA ((KA(JS,JT,11,15),JS=1,9),JT=1,5) /
     &1.6605E+02,1.4529E+02,1.2455E+02,1.0378E+02,8.3029E+01,6.2280E+01,
     &4.1517E+01,2.0760E+01,2.5530E+00,1.6006E+02,1.4006E+02,1.2005E+02,
     &1.0004E+02,8.0031E+01,6.0027E+01,4.0019E+01,2.0011E+01,2.4994E+00,
     &1.5475E+02,1.3539E+02,1.1606E+02,9.6709E+01,7.7371E+01,5.8029E+01,
     &3.8687E+01,1.9345E+01,2.4484E+00,1.5058E+02,1.3176E+02,1.1294E+02,
     &9.4118E+01,7.5292E+01,5.6471E+01,3.7649E+01,1.8825E+01,2.4006E+00,
     &1.4680E+02,1.2845E+02,1.1009E+02,9.1748E+01,7.3399E+01,5.5050E+01,
     &3.6700E+01,1.8351E+01,2.3540E+00/
      DATA ((KA(JS,JT,12,15),JS=1,9),JT=1,5) /
     &2.2602E+02,1.9778E+02,1.6953E+02,1.4127E+02,1.1301E+02,8.4757E+01,
     &5.6507E+01,2.8257E+01,2.8716E+00,2.1869E+02,1.9135E+02,1.6402E+02,
     &1.3669E+02,1.0935E+02,8.2013E+01,5.4674E+01,2.7339E+01,2.8132E+00,
     &2.1253E+02,1.8597E+02,1.5940E+02,1.3282E+02,1.0626E+02,7.9692E+01,
     &5.3134E+01,2.6567E+01,2.7573E+00,2.0725E+02,1.8134E+02,1.5543E+02,
     &1.2952E+02,1.0362E+02,7.7720E+01,5.1811E+01,2.5907E+01,2.7022E+00,
     &2.0216E+02,1.7690E+02,1.5162E+02,1.2635E+02,1.0108E+02,7.5810E+01,
     &5.0540E+01,2.5271E+01,2.6508E+00/
      DATA ((KA(JS,JT,13,15),JS=1,9),JT=1,5) /
     &2.4880E+02,2.1770E+02,1.8661E+02,1.5550E+02,1.2440E+02,9.3305E+01,
     &6.2205E+01,3.1105E+01,3.1971E+00,2.4131E+02,2.1114E+02,1.8097E+02,
     &1.5081E+02,1.2065E+02,9.0483E+01,6.0327E+01,3.0165E+01,3.1338E+00,
     &2.3499E+02,2.0562E+02,1.7624E+02,1.4687E+02,1.1750E+02,8.8123E+01,
     &5.8749E+01,2.9377E+01,3.0697E+00,2.2900E+02,2.0038E+02,1.7175E+02,
     &1.4313E+02,1.1451E+02,8.5878E+01,5.7253E+01,2.8627E+01,3.0070E+00,
     &2.2306E+02,1.9518E+02,1.6729E+02,1.3941E+02,1.1152E+02,8.3649E+01,
     &5.5766E+01,2.7883E+01,2.9481E+00/
      DATA ((KA(JS,JT, 1,16),JS=1,9),JT=1,5) /
     &1.9445E-02,6.3230E-02,1.2479E-01,1.8384E-01,2.3882E-01,2.8643E-01,
     &3.1893E-01,3.1112E-01,4.7763E-01,1.8835E-02,6.2634E-02,1.2363E-01,
     &1.8213E-01,2.3659E-01,2.8379E-01,3.1600E-01,3.0828E-01,4.7319E-01,
     &1.8228E-02,6.1941E-02,1.2224E-01,1.8013E-01,2.3399E-01,2.8070E-01,
     &3.1257E-01,3.0493E-01,4.6798E-01,1.7647E-02,6.1170E-02,1.2073E-01,
     &1.7790E-01,2.3107E-01,2.7723E-01,3.0877E-01,3.0124E-01,4.6215E-01,
     &1.7079E-02,6.0350E-02,1.1912E-01,1.7548E-01,2.2801E-01,2.7357E-01,
     &3.0466E-01,2.9733E-01,4.5602E-01/
      DATA ((KA(JS,JT, 2,16),JS=1,9),JT=1,5) /
     &3.4634E-02,7.7044E-02,1.5273E-01,2.2632E-01,2.9575E-01,3.6021E-01,
     &4.0997E-01,4.1812E-01,5.9296E-01,3.3420E-02,7.6207E-02,1.5110E-01,
     &2.2402E-01,2.9356E-01,3.5685E-01,4.0638E-01,4.1457E-01,5.8711E-01,
     &3.2246E-02,7.5373E-02,1.4946E-01,2.2157E-01,2.9037E-01,3.5299E-01,
     &4.0204E-01,4.1028E-01,5.8073E-01,3.1106E-02,7.4437E-02,1.4762E-01,
     &2.1883E-01,2.8679E-01,3.4868E-01,3.9718E-01,4.0541E-01,5.7357E-01,
     &3.0021E-02,7.3426E-02,1.4561E-01,2.1587E-01,2.8293E-01,3.4400E-01,
     &3.9193E-01,4.0015E-01,5.6584E-01/
      DATA ((KA(JS,JT, 3,16),JS=1,9),JT=1,5) /
     &8.3051E-02,9.4793E-02,1.8876E-01,2.8144E-01,3.7196E-01,4.5816E-01,
     &5.3450E-01,5.7690E-01,7.4391E-01,7.9830E-02,9.3082E-02,1.8538E-01,
     &2.7644E-01,3.6534E-01,4.5017E-01,5.2550E-01,5.6808E-01,7.3067E-01,
     &7.6737E-02,9.1705E-02,1.8269E-01,2.7246E-01,3.6014E-01,4.4395E-01,
     &5.1857E-01,5.6175E-01,7.2028E-01,7.3809E-02,9.0497E-02,1.8026E-01,
     &2.6888E-01,3.5554E-01,4.3839E-01,5.1223E-01,5.5508E-01,7.1107E-01,
     &7.1033E-02,8.9276E-02,1.7779E-01,2.6523E-01,3.5066E-01,4.3243E-01,
     &5.0536E-01,5.4783E-01,7.0132E-01/
      DATA ((KA(JS,JT, 4,16),JS=1,9),JT=1,5) /
     &2.0125E-01,1.7779E-01,2.3399E-01,3.4997E-01,4.6464E-01,5.7674E-01,
     &6.8253E-01,7.6508E-01,9.2928E-01,1.9265E-01,1.7048E-01,2.2831E-01,
     &3.4146E-01,4.5338E-01,5.6281E-01,6.6618E-01,7.4718E-01,9.0679E-01,
     &1.8456E-01,1.6365E-01,2.2378E-01,3.3476E-01,4.4451E-01,5.5182E-01,
     &6.5330E-01,7.3313E-01,8.8901E-01,1.7702E-01,1.5723E-01,2.1978E-01,
     &3.2875E-01,4.3660E-01,5.4199E-01,6.4188E-01,7.2098E-01,8.7320E-01,
     &1.6997E-01,1.5116E-01,2.1600E-01,3.2314E-01,4.2913E-01,5.3288E-01,
     &6.3120E-01,7.0945E-01,8.5826E-01/
      DATA ((KA(JS,JT, 5,16),JS=1,9),JT=1,5) /
     &4.4228E-01,3.8795E-01,3.3395E-01,4.3605E-01,5.8013E-01,7.2255E-01,
     &8.6084E-01,9.8346E-01,1.1603E+00,4.2199E-01,3.7056E-01,3.1956E-01,
     &4.2215E-01,5.6164E-01,6.9945E-01,8.3347E-01,9.5217E-01,1.1233E+00,
     &4.0375E-01,3.5492E-01,3.0638E-01,4.1150E-01,5.4754E-01,6.8200E-01,
     &8.1260E-01,9.2875E-01,1.0951E+00,3.8716E-01,3.4051E-01,2.9411E-01,
     &4.0247E-01,5.3546E-01,6.6706E-01,7.9494E-01,9.0883E-01,1.0709E+00,
     &3.7160E-01,3.2689E-01,2.8321E-01,3.9414E-01,5.2444E-01,6.5338E-01,
     &7.7865E-01,8.9056E-01,1.0489E+00/
      DATA ((KA(JS,JT, 6,16),JS=1,9),JT=1,5) /
     &9.0506E-01,7.9284E-01,6.8068E-01,5.6916E-01,7.2503E-01,9.0468E-01,
     &1.0813E+00,1.2473E+00,1.4500E+00,8.6465E-01,7.5773E-01,6.5086E-01,
     &5.4531E-01,6.9722E-01,8.6983E-01,1.0397E+00,1.1992E+00,1.3944E+00,
     &8.2825E-01,7.2598E-01,6.2379E-01,5.2549E-01,6.7605E-01,8.4340E-01,
     &1.0082E+00,1.1629E+00,1.3521E+00,7.9420E-01,6.9632E-01,5.9834E-01,
     &5.1029E-01,6.5811E-01,8.2106E-01,9.8160E-01,1.1324E+00,1.3162E+00,
     &7.6215E-01,6.6829E-01,5.7431E-01,4.9359E-01,6.4194E-01,8.0089E-01,
     &9.5749E-01,1.1049E+00,1.2839E+00/
      DATA ((KA(JS,JT, 7,16),JS=1,9),JT=1,5) /
     &1.9676E+00,1.7224E+00,1.4775E+00,1.2325E+00,9.8756E-01,1.1304E+00,
     &1.3539E+00,1.5704E+00,1.8105E+00,1.8838E+00,1.6493E+00,1.4147E+00,
     &1.1804E+00,9.4604E-01,1.0806E+00,1.2942E+00,1.5011E+00,1.7307E+00,
     &1.8058E+00,1.5808E+00,1.3563E+00,1.1318E+00,9.0772E-01,1.0432E+00,
     &1.2494E+00,1.4491E+00,1.6707E+00,1.7320E+00,1.5166E+00,1.3008E+00,
     &1.0854E+00,8.7621E-01,1.0114E+00,1.2114E+00,1.4051E+00,1.6197E+00,
     &1.6617E+00,1.4551E+00,1.2484E+00,1.0417E+00,8.4899E-01,9.8293E-01,
     &1.1773E+00,1.3657E+00,1.5743E+00/
      DATA ((KA(JS,JT, 8,16),JS=1,9),JT=1,5) /
     &5.0769E+00,4.4432E+00,3.8096E+00,3.1755E+00,2.5417E+00,1.9082E+00,
     &1.6892E+00,1.9659E+00,2.2550E+00,4.8681E+00,4.2603E+00,3.6527E+00,
     &3.0450E+00,2.4373E+00,1.8300E+00,1.6072E+00,1.8705E+00,2.1455E+00,
     &4.6692E+00,4.0861E+00,3.5032E+00,2.9205E+00,2.3378E+00,1.7550E+00,
     &1.5446E+00,1.7976E+00,2.0621E+00,4.4792E+00,3.9199E+00,3.3609E+00,
     &2.8016E+00,2.2429E+00,1.6836E+00,1.4923E+00,1.7367E+00,1.9921E+00,
     &4.2972E+00,3.7609E+00,3.2243E+00,2.6879E+00,2.1517E+00,1.6153E+00,
     &1.4455E+00,1.6824E+00,1.9297E+00/
      DATA ((KA(JS,JT, 9,16),JS=1,9),JT=1,5) /
     &2.4893E+01,2.1786E+01,1.8675E+01,1.5563E+01,1.2450E+01,9.3398E+00,
     &6.2286E+00,3.1170E+00,2.8014E+00,2.3897E+01,2.0912E+01,1.7925E+01,
     &1.4937E+01,1.1951E+01,8.9651E+00,5.9788E+00,2.9923E+00,2.6581E+00,
     &2.2932E+01,2.0066E+01,1.7201E+01,1.4334E+01,1.1468E+01,8.6027E+00,
     &5.7371E+00,2.8711E+00,2.5442E+00,2.1999E+01,1.9250E+01,1.6501E+01,
     &1.3753E+01,1.1001E+01,8.2533E+00,5.5038E+00,2.7545E+00,2.4493E+00,
     &2.1105E+01,1.8469E+01,1.5831E+01,1.3195E+01,1.0556E+01,7.9178E+00,
     &5.2806E+00,2.6423E+00,2.3650E+00/
      DATA ((KA(JS,JT,10,16),JS=1,9),JT=1,5) /
     &1.3702E+02,1.1990E+02,1.0277E+02,8.5642E+01,6.8515E+01,5.1385E+01,
     &3.4262E+01,1.7133E+01,3.4526E+00,1.3162E+02,1.1516E+02,9.8725E+01,
     &8.2273E+01,6.5802E+01,4.9353E+01,3.2909E+01,1.6459E+01,3.2683E+00,
     &1.2631E+02,1.1053E+02,9.4741E+01,7.8943E+01,6.3147E+01,4.7375E+01,
     &3.1582E+01,1.5793E+01,3.1197E+00,1.2113E+02,1.0599E+02,9.0842E+01,
     &7.5703E+01,6.0562E+01,4.5424E+01,3.0282E+01,1.5145E+01,2.9946E+00,
     &1.1642E+02,1.0187E+02,8.7320E+01,7.2762E+01,5.8215E+01,4.3658E+01,
     &2.9108E+01,1.4557E+01,2.8829E+00/
      DATA ((KA(JS,JT,11,16),JS=1,9),JT=1,5) /
     &2.5880E+02,2.2644E+02,1.9413E+02,1.6174E+02,1.2941E+02,9.7065E+01,
     &6.4700E+01,3.2352E+01,4.1212E+00,2.4838E+02,2.1734E+02,1.8628E+02,
     &1.5524E+02,1.2419E+02,9.3146E+01,6.2097E+01,3.1052E+01,3.9061E+00,
     &2.3869E+02,2.0886E+02,1.7902E+02,1.4918E+02,1.1935E+02,8.9511E+01,
     &5.9677E+01,2.9841E+01,3.7301E+00,2.2943E+02,2.0074E+02,1.7207E+02,
     &1.4339E+02,1.1472E+02,8.6039E+01,5.7356E+01,2.8682E+01,3.5754E+00,
     &2.2131E+02,1.9367E+02,1.6600E+02,1.3834E+02,1.1067E+02,8.3001E+01,
     &5.5340E+01,2.7668E+01,3.4351E+00/
      DATA ((KA(JS,JT,12,16),JS=1,9),JT=1,5) /
     &3.6519E+02,3.1953E+02,2.7390E+02,2.2827E+02,1.8260E+02,1.3695E+02,
     &9.1294E+01,4.5654E+01,4.8878E+00,3.5163E+02,3.0767E+02,2.6371E+02,
     &2.1977E+02,1.7580E+02,1.3186E+02,8.7903E+01,4.3953E+01,4.5957E+00,
     &3.3818E+02,2.9589E+02,2.5364E+02,2.1136E+02,1.6910E+02,1.2682E+02,
     &8.4547E+01,4.2272E+01,4.4276E+00,3.2523E+02,2.8457E+02,2.4393E+02,
     &2.0329E+02,1.6262E+02,1.2197E+02,8.1319E+01,4.0657E+01,4.2352E+00,
     &3.1377E+02,2.7452E+02,2.3534E+02,1.9609E+02,1.5688E+02,1.1765E+02,
     &7.8446E+01,3.9220E+01,4.0574E+00/
      DATA ((KA(JS,JT,13,16),JS=1,9),JT=1,5) /
     &4.1560E+02,3.6364E+02,3.1170E+02,2.5976E+02,2.0781E+02,1.5585E+02,
     &1.0390E+02,5.1953E+01,5.7636E+00,3.9970E+02,3.4978E+02,2.9980E+02,
     &2.4983E+02,1.9986E+02,1.4990E+02,9.9932E+01,4.9970E+01,5.4706E+00,
     &3.8378E+02,3.3582E+02,2.8782E+02,2.3987E+02,1.9190E+02,1.4391E+02,
     &9.5948E+01,4.7978E+01,5.2080E+00,3.6900E+02,3.2290E+02,2.7675E+02,
     &2.3063E+02,1.8451E+02,1.3838E+02,9.2254E+01,4.6129E+01,4.9718E+00,
     &3.5587E+02,3.1138E+02,2.6690E+02,2.2242E+02,1.7795E+02,1.3345E+02,
     &8.8970E+01,4.4486E+01,4.7553E+00/

C     The array KB contains absorption coefs at the 16 chosen g-values 
C     for a range of pressure levels < ~100mb and temperatures. The first 
C     index in the array, JT, which runs from 1 to 5, corresponds to 
C     different temperatures.  More specifically, JT = 3 means that the 
C     data are for the reference temperature TREF for this pressure 
C     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
C     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
C     The second index, JP, runs from 13 to 59 and refers to the JPth
C     reference pressure level (see taumol.f for the value of these
C     pressure levels in mb).  The third index, IG, goes from 1 to 16,
C     and tells us which g-interval the absorption coefficients are for.

      DATA (KB(JT,13, 1),JT=1,5) /
     &6.6242E-04,6.9229E-04,7.2125E-04,7.5111E-04,7.7882E-04/
      DATA (KB(JT,14, 1),JT=1,5) /
     &5.7148E-04,6.0011E-04,6.2434E-04,6.4765E-04,6.6822E-04/
      DATA (KB(JT,15, 1),JT=1,5) /
     &5.0245E-04,5.2495E-04,5.4519E-04,5.6261E-04,5.8004E-04/
      DATA (KB(JT,16, 1),JT=1,5) /
     &4.4219E-04,4.6335E-04,4.7782E-04,4.9293E-04,5.0687E-04/
      DATA (KB(JT,17, 1),JT=1,5) /
     &3.9452E-04,4.1172E-04,4.2558E-04,4.3834E-04,4.5031E-04/
      DATA (KB(JT,18, 1),JT=1,5) /
     &3.5502E-04,3.7021E-04,3.8062E-04,3.9326E-04,4.0413E-04/
      DATA (KB(JT,19, 1),JT=1,5) /
     &3.1835E-04,3.3204E-04,3.4438E-04,3.5308E-04,3.6251E-04/
      DATA (KB(JT,20, 1),JT=1,5) /
     &2.7685E-04,2.8739E-04,2.9799E-04,3.0565E-04,3.1346E-04/
      DATA (KB(JT,21, 1),JT=1,5) /
     &2.3803E-04,2.4613E-04,2.5507E-04,2.6118E-04,2.6805E-04/
      DATA (KB(JT,22, 1),JT=1,5) /
     &2.0518E-04,2.1064E-04,2.1799E-04,2.2345E-04,2.2945E-04/
      DATA (KB(JT,23, 1),JT=1,5) /
     &1.7609E-04,1.8136E-04,1.8691E-04,1.9179E-04,1.9680E-04/
      DATA (KB(JT,24, 1),JT=1,5) /
     &1.5133E-04,1.5582E-04,1.6020E-04,1.6517E-04,1.6912E-04/
      DATA (KB(JT,25, 1),JT=1,5) /
     &1.3023E-04,1.3355E-04,1.3826E-04,1.4195E-04,1.4464E-04/
      DATA (KB(JT,26, 1),JT=1,5) /
     &1.1153E-04,1.1437E-04,1.1820E-04,1.2126E-04,1.2331E-04/
      DATA (KB(JT,27, 1),JT=1,5) /
     &9.5262E-05,9.8055E-05,1.0080E-04,1.0342E-04,1.0508E-04/
      DATA (KB(JT,28, 1),JT=1,5) /
     &8.1680E-05,8.3691E-05,8.6133E-05,8.8128E-05,8.9712E-05/
      DATA (KB(JT,29, 1),JT=1,5) /
     &7.0309E-05,7.1883E-05,7.3686E-05,7.5287E-05,7.6689E-05/
      DATA (KB(JT,30, 1),JT=1,5) /
     &6.0539E-05,6.1910E-05,6.3188E-05,6.4488E-05,6.6886E-05/
      DATA (KB(JT,31, 1),JT=1,5) /
     &5.2744E-05,5.3514E-05,5.4453E-05,5.5692E-05,5.7687E-05/
      DATA (KB(JT,32, 1),JT=1,5) /
     &4.5908E-05,4.6319E-05,4.7373E-05,4.8133E-05,4.9705E-05/
      DATA (KB(JT,33, 1),JT=1,5) /
     &3.9867E-05,4.0547E-05,4.1159E-05,4.1892E-05,4.3045E-05/
      DATA (KB(JT,34, 1),JT=1,5) /
     &3.4676E-05,3.5573E-05,3.6016E-05,3.7022E-05,3.7402E-05/
      DATA (KB(JT,35, 1),JT=1,5) /
     &3.0380E-05,3.1177E-05,3.1680E-05,3.2397E-05,3.2578E-05/
      DATA (KB(JT,36, 1),JT=1,5) /
     &2.6710E-05,2.7409E-05,2.7919E-05,2.8397E-05,2.8592E-05/
      DATA (KB(JT,37, 1),JT=1,5) /
     &2.2468E-05,2.3018E-05,2.3378E-05,2.3912E-05,2.4011E-05/
      DATA (KB(JT,38, 1),JT=1,5) /
     &1.8961E-05,1.9311E-05,1.9590E-05,2.0060E-05,2.0183E-05/
      DATA (KB(JT,39, 1),JT=1,5) /
     &1.6038E-05,1.6240E-05,1.6497E-05,1.6653E-05,1.7067E-05/
      DATA (KB(JT,40, 1),JT=1,5) /
     &1.3126E-05,1.3247E-05,1.3457E-05,1.3586E-05,1.3950E-05/
      DATA (KB(JT,41, 1),JT=1,5) /
     &1.0642E-05,1.0779E-05,1.0904E-05,1.1060E-05,1.1348E-05/
      DATA (KB(JT,42, 1),JT=1,5) /
     &8.5931E-06,8.7256E-06,8.8249E-06,8.9763E-06,9.1997E-06/
      DATA (KB(JT,43, 1),JT=1,5) /
     &6.8315E-06,7.0003E-06,7.0825E-06,7.1921E-06,7.3080E-06/
      DATA (KB(JT,44, 1),JT=1,5) /
     &5.4113E-06,5.5622E-06,5.6277E-06,5.7357E-06,5.8407E-06/
      DATA (KB(JT,45, 1),JT=1,5) /
     &4.2868E-06,4.4145E-06,4.4700E-06,4.5509E-06,4.6597E-06/
      DATA (KB(JT,46, 1),JT=1,5) /
     &3.3813E-06,3.5001E-06,3.5350E-06,3.6083E-06,3.6919E-06/
      DATA (KB(JT,47, 1),JT=1,5) /
     &2.6664E-06,2.7723E-06,2.7972E-06,2.8533E-06,2.9267E-06/
      DATA (KB(JT,48, 1),JT=1,5) /
     &2.0946E-06,2.1711E-06,2.2048E-06,2.2465E-06,2.3102E-06/
      DATA (KB(JT,49, 1),JT=1,5) /
     &1.6333E-06,1.6996E-06,1.7388E-06,1.7611E-06,1.8115E-06/
      DATA (KB(JT,50, 1),JT=1,5) /
     &1.2781E-06,1.3328E-06,1.3698E-06,1.3938E-06,1.4265E-06/
      DATA (KB(JT,51, 1),JT=1,5) /
     &1.0076E-06,1.0460E-06,1.0807E-06,1.1011E-06,1.1257E-06/
      DATA (KB(JT,52, 1),JT=1,5) /
     &7.9394E-07,8.1840E-07,8.4881E-07,8.6654E-07,8.8734E-07/
      DATA (KB(JT,53, 1),JT=1,5) /
     &6.1785E-07,6.3992E-07,6.6144E-07,6.7843E-07,6.9618E-07/
      DATA (KB(JT,54, 1),JT=1,5) /
     &4.8490E-07,5.0506E-07,5.1952E-07,5.3413E-07,5.4905E-07/
      DATA (KB(JT,55, 1),JT=1,5) /
     &3.8198E-07,3.9926E-07,4.1207E-07,4.2268E-07,4.3489E-07/
      DATA (KB(JT,56, 1),JT=1,5) /
     &3.0062E-07,3.1357E-07,3.2461E-07,3.3313E-07,3.4390E-07/
      DATA (KB(JT,57, 1),JT=1,5) /
     &2.3579E-07,2.4608E-07,2.5500E-07,2.6288E-07,2.7145E-07/
      DATA (KB(JT,58, 1),JT=1,5) /
     &1.8530E-07,1.9293E-07,2.0021E-07,2.0804E-07,2.1510E-07/
      DATA (KB(JT,59, 1),JT=1,5) /
     &1.4951E-07,1.5512E-07,1.6259E-07,1.6844E-07,1.7451E-07/
      DATA (KB(JT,13, 2),JT=1,5) /
     &2.8194E-03,3.0121E-03,3.1846E-03,3.3490E-03,3.5100E-03/
      DATA (KB(JT,14, 2),JT=1,5) /
     &2.4827E-03,2.6492E-03,2.7938E-03,2.9346E-03,3.0538E-03/
      DATA (KB(JT,15, 2),JT=1,5) /
     &2.2064E-03,2.3375E-03,2.4556E-03,2.5697E-03,2.6626E-03/
      DATA (KB(JT,16, 2),JT=1,5) /
     &1.9378E-03,2.0444E-03,2.1458E-03,2.2321E-03,2.3069E-03/
      DATA (KB(JT,17, 2),JT=1,5) /
     &1.7072E-03,1.7953E-03,1.8810E-03,1.9513E-03,2.0122E-03/
      DATA (KB(JT,18, 2),JT=1,5) /
     &1.5182E-03,1.5881E-03,1.6604E-03,1.7175E-03,1.7691E-03/
      DATA (KB(JT,19, 2),JT=1,5) /
     &1.3604E-03,1.4237E-03,1.4711E-03,1.5216E-03,1.5631E-03/
      DATA (KB(JT,20, 2),JT=1,5) /
     &1.1858E-03,1.2290E-03,1.2712E-03,1.3090E-03,1.3421E-03/
      DATA (KB(JT,21, 2),JT=1,5) /
     &1.0189E-03,1.0547E-03,1.0885E-03,1.1186E-03,1.1432E-03/
      DATA (KB(JT,22, 2),JT=1,5) /
     &8.7055E-04,9.0481E-04,9.2821E-04,9.5252E-04,9.7075E-04/
      DATA (KB(JT,23, 2),JT=1,5) /
     &7.4675E-04,7.7099E-04,7.9133E-04,8.0933E-04,8.2551E-04/
      DATA (KB(JT,24, 2),JT=1,5) /
     &6.4034E-04,6.5905E-04,6.7517E-04,6.8951E-04,7.0349E-04/
      DATA (KB(JT,25, 2),JT=1,5) /
     &5.4635E-04,5.6117E-04,5.7460E-04,5.8668E-04,5.9880E-04/
      DATA (KB(JT,26, 2),JT=1,5) /
     &4.6328E-04,4.7565E-04,4.8724E-04,4.9802E-04,5.0785E-04/
      DATA (KB(JT,27, 2),JT=1,5) /
     &3.9145E-04,4.0138E-04,4.1206E-04,4.2067E-04,4.2970E-04/
      DATA (KB(JT,28, 2),JT=1,5) /
     &3.2965E-04,3.3905E-04,3.4755E-04,3.5536E-04,3.6345E-04/
      DATA (KB(JT,29, 2),JT=1,5) /
     &2.7722E-04,2.8535E-04,2.9237E-04,2.9947E-04,3.0668E-04/
      DATA (KB(JT,30, 2),JT=1,5) /
     &2.3378E-04,2.4040E-04,2.4667E-04,2.5278E-04,2.6270E-04/
      DATA (KB(JT,31, 2),JT=1,5) /
     &1.9661E-04,2.0207E-04,2.0803E-04,2.1348E-04,2.2186E-04/
      DATA (KB(JT,32, 2),JT=1,5) /
     &1.6562E-04,1.7146E-04,1.7695E-04,1.8193E-04,1.8929E-04/
      DATA (KB(JT,33, 2),JT=1,5) /
     &1.4107E-04,1.4666E-04,1.5183E-04,1.5594E-04,1.6243E-04/
      DATA (KB(JT,34, 2),JT=1,5) /
     &1.2158E-04,1.2598E-04,1.3011E-04,1.3588E-04,1.4023E-04/
      DATA (KB(JT,35, 2),JT=1,5) /
     &1.0453E-04,1.0824E-04,1.1246E-04,1.1806E-04,1.2280E-04/
      DATA (KB(JT,36, 2),JT=1,5) /
     &9.0281E-05,9.3775E-05,9.7901E-05,1.0364E-04,1.0744E-04/
      DATA (KB(JT,37, 2),JT=1,5) /
     &7.5786E-05,7.8742E-05,8.2503E-05,8.7040E-05,8.9489E-05/
      DATA (KB(JT,38, 2),JT=1,5) /
     &6.3149E-05,6.6113E-05,6.8833E-05,7.2371E-05,7.4496E-05/
      DATA (KB(JT,39, 2),JT=1,5) /
     &5.2982E-05,5.5381E-05,5.7239E-05,5.9241E-05,6.1954E-05/
      DATA (KB(JT,40, 2),JT=1,5) /
     &4.3111E-05,4.5156E-05,4.6617E-05,4.8324E-05,5.0544E-05/
      DATA (KB(JT,41, 2),JT=1,5) /
     &3.4957E-05,3.6661E-05,3.7913E-05,3.9243E-05,4.1170E-05/
      DATA (KB(JT,42, 2),JT=1,5) /
     &2.8335E-05,2.9735E-05,3.0788E-05,3.1864E-05,3.3563E-05/
      DATA (KB(JT,43, 2),JT=1,5) /
     &2.2801E-05,2.3962E-05,2.4808E-05,2.5685E-05,2.6685E-05/
      DATA (KB(JT,44, 2),JT=1,5) /
     &1.8216E-05,1.9207E-05,1.9940E-05,2.0623E-05,2.1468E-05/
      DATA (KB(JT,45, 2),JT=1,5) /
     &1.4497E-05,1.5369E-05,1.6010E-05,1.6560E-05,1.7214E-05/
      DATA (KB(JT,46, 2),JT=1,5) /
     &1.1546E-05,1.2283E-05,1.2829E-05,1.3281E-05,1.3789E-05/
      DATA (KB(JT,47, 2),JT=1,5) /
     &9.1407E-06,9.7102E-06,1.0256E-05,1.0642E-05,1.1044E-05/
      DATA (KB(JT,48, 2),JT=1,5) /
     &7.2582E-06,7.7178E-06,8.1771E-06,8.5159E-06,8.8287E-06/
      DATA (KB(JT,49, 2),JT=1,5) /
     &5.7413E-06,6.0895E-06,6.4724E-06,6.7948E-06,7.0423E-06/
      DATA (KB(JT,50, 2),JT=1,5) /
     &4.5645E-06,4.8219E-06,5.1398E-06,5.4019E-06,5.6251E-06/
      DATA (KB(JT,51, 2),JT=1,5) /
     &3.6347E-06,3.8345E-06,4.0925E-06,4.2999E-06,4.4976E-06/
      DATA (KB(JT,52, 2),JT=1,5) /
     &2.8914E-06,3.0394E-06,3.2506E-06,3.4210E-06,3.5835E-06/
      DATA (KB(JT,53, 2),JT=1,5) /
     &2.2827E-06,2.4183E-06,2.5753E-06,2.7165E-06,2.8435E-06/
      DATA (KB(JT,54, 2),JT=1,5) /
     &1.8109E-06,1.9319E-06,2.0517E-06,2.1771E-06,2.2825E-06/
      DATA (KB(JT,55, 2),JT=1,5) /
     &1.4459E-06,1.5442E-06,1.6423E-06,1.7466E-06,1.8412E-06/
      DATA (KB(JT,56, 2),JT=1,5) /
     &1.1487E-06,1.2318E-06,1.3168E-06,1.4029E-06,1.4853E-06/
      DATA (KB(JT,57, 2),JT=1,5) /
     &9.1432E-07,9.8206E-07,1.0551E-06,1.1262E-06,1.1922E-06/
      DATA (KB(JT,58, 2),JT=1,5) /
     &7.2392E-07,7.8435E-07,8.4467E-07,9.0516E-07,9.5596E-07/
      DATA (KB(JT,59, 2),JT=1,5) /
     &5.9300E-07,6.4245E-07,6.9378E-07,7.4259E-07,7.8676E-07/
      DATA (KB(JT,13, 3),JT=1,5) /
     &8.5247E-03,8.9273E-03,9.3494E-03,9.7833E-03,1.0198E-02/
      DATA (KB(JT,14, 3),JT=1,5) /
     &7.6220E-03,7.9465E-03,8.3037E-03,8.6680E-03,9.0184E-03/
      DATA (KB(JT,15, 3),JT=1,5) /
     &6.7313E-03,7.0250E-03,7.3390E-03,7.6496E-03,7.9523E-03/
      DATA (KB(JT,16, 3),JT=1,5) /
     &5.8626E-03,6.1324E-03,6.4081E-03,6.6680E-03,6.9239E-03/
      DATA (KB(JT,17, 3),JT=1,5) /
     &5.1190E-03,5.3847E-03,5.6114E-03,5.8394E-03,6.0319E-03/
      DATA (KB(JT,18, 3),JT=1,5) /
     &4.4937E-03,4.7329E-03,4.9304E-03,5.1178E-03,5.2582E-03/
      DATA (KB(JT,19, 3),JT=1,5) /
     &3.9714E-03,4.1523E-03,4.3393E-03,4.4847E-03,4.6081E-03/
      DATA (KB(JT,20, 3),JT=1,5) /
     &3.4227E-03,3.5888E-03,3.7323E-03,3.8457E-03,3.9571E-03/
      DATA (KB(JT,21, 3),JT=1,5) /
     &2.9355E-03,3.0688E-03,3.1813E-03,3.2800E-03,3.3665E-03/
      DATA (KB(JT,22, 3),JT=1,5) /
     &2.5131E-03,2.6136E-03,2.7075E-03,2.7888E-03,2.8576E-03/
      DATA (KB(JT,23, 3),JT=1,5) /
     &2.1439E-03,2.2229E-03,2.3069E-03,2.3691E-03,2.4314E-03/
      DATA (KB(JT,24, 3),JT=1,5) /
     &1.8279E-03,1.8995E-03,1.9649E-03,2.0190E-03,2.0668E-03/
      DATA (KB(JT,25, 3),JT=1,5) /
     &1.5582E-03,1.6177E-03,1.6674E-03,1.7146E-03,1.7550E-03/
      DATA (KB(JT,26, 3),JT=1,5) /
     &1.3272E-03,1.3717E-03,1.4140E-03,1.4536E-03,1.4858E-03/
      DATA (KB(JT,27, 3),JT=1,5) /
     &1.1230E-03,1.1594E-03,1.1953E-03,1.2264E-03,1.2540E-03/
      DATA (KB(JT,28, 3),JT=1,5) /
     &9.4753E-04,9.7763E-04,1.0074E-03,1.0308E-03,1.0536E-03/
      DATA (KB(JT,29, 3),JT=1,5) /
     &7.9502E-04,8.1974E-04,8.4372E-04,8.6478E-04,8.8308E-04/
      DATA (KB(JT,30, 3),JT=1,5) /
     &6.6596E-04,6.8697E-04,7.0803E-04,7.2439E-04,7.5784E-04/
      DATA (KB(JT,31, 3),JT=1,5) /
     &5.5745E-04,5.7516E-04,5.9220E-04,6.0512E-04,6.3289E-04/
      DATA (KB(JT,32, 3),JT=1,5) /
     &4.6662E-04,4.8150E-04,4.9505E-04,5.0361E-04,5.2756E-04/
      DATA (KB(JT,33, 3),JT=1,5) /
     &3.9094E-04,4.0255E-04,4.1211E-04,4.1938E-04,4.4050E-04/
      DATA (KB(JT,34, 3),JT=1,5) /
     &3.2769E-04,3.3699E-04,3.4471E-04,3.6275E-04,3.6949E-04/
      DATA (KB(JT,35, 3),JT=1,5) /
     &2.7475E-04,2.8204E-04,2.8828E-04,3.0332E-04,3.0836E-04/
      DATA (KB(JT,36, 3),JT=1,5) /
     &2.2983E-04,2.3568E-04,2.4113E-04,2.5319E-04,2.5736E-04/
      DATA (KB(JT,37, 3),JT=1,5) /
     &1.8895E-04,1.9397E-04,1.9807E-04,2.0882E-04,2.1275E-04/
      DATA (KB(JT,38, 3),JT=1,5) /
     &1.5549E-04,1.5951E-04,1.6323E-04,1.7252E-04,1.7561E-04/
      DATA (KB(JT,39, 3),JT=1,5) /
     &1.2765E-04,1.3102E-04,1.3443E-04,1.3776E-04,1.4478E-04/
      DATA (KB(JT,40, 3),JT=1,5) /
     &1.0414E-04,1.0697E-04,1.0972E-04,1.1251E-04,1.1839E-04/
      DATA (KB(JT,41, 3),JT=1,5) /
     &8.4861E-05,8.7037E-05,8.9345E-05,9.1552E-05,9.6450E-05/
      DATA (KB(JT,42, 3),JT=1,5) /
     &6.9029E-05,7.0620E-05,7.2608E-05,7.4362E-05,7.8451E-05/
      DATA (KB(JT,43, 3),JT=1,5) /
     &5.5731E-05,5.6934E-05,5.8627E-05,6.0036E-05,6.1419E-05/
      DATA (KB(JT,44, 3),JT=1,5) /
     &4.4750E-05,4.5795E-05,4.7066E-05,4.8320E-05,4.9340E-05/
      DATA (KB(JT,45, 3),JT=1,5) /
     &3.5902E-05,3.6793E-05,3.7710E-05,3.8772E-05,3.9634E-05/
      DATA (KB(JT,46, 3),JT=1,5) /
     &2.8669E-05,2.9406E-05,3.0158E-05,3.1055E-05,3.1783E-05/
      DATA (KB(JT,47, 3),JT=1,5) /
     &2.2957E-05,2.3586E-05,2.4179E-05,2.4875E-05,2.5463E-05/
      DATA (KB(JT,48, 3),JT=1,5) /
     &1.8322E-05,1.8764E-05,1.9281E-05,1.9846E-05,2.0330E-05/
      DATA (KB(JT,49, 3),JT=1,5) /
     &1.4581E-05,1.4948E-05,1.5326E-05,1.5796E-05,1.6188E-05/
      DATA (KB(JT,50, 3),JT=1,5) /
     &1.1658E-05,1.1996E-05,1.2253E-05,1.2626E-05,1.2988E-05/
      DATA (KB(JT,51, 3),JT=1,5) /
     &9.3098E-06,9.6196E-06,9.8320E-06,1.0134E-05,1.0431E-05/
      DATA (KB(JT,52, 3),JT=1,5) /
     &7.3883E-06,7.7108E-06,7.8752E-06,8.1035E-06,8.3459E-06/
      DATA (KB(JT,53, 3),JT=1,5) /
     &5.8592E-06,6.1249E-06,6.2920E-06,6.4688E-06,6.6480E-06/
      DATA (KB(JT,54, 3),JT=1,5) /
     &4.7059E-06,4.9088E-06,5.0922E-06,5.2219E-06,5.3713E-06/
      DATA (KB(JT,55, 3),JT=1,5) /
     &3.7899E-06,3.9660E-06,4.1365E-06,4.2472E-06,4.3644E-06/
      DATA (KB(JT,56, 3),JT=1,5) /
     &3.0554E-06,3.2100E-06,3.3483E-06,3.4494E-06,3.5457E-06/
      DATA (KB(JT,57, 3),JT=1,5) /
     &2.4489E-06,2.5923E-06,2.7014E-06,2.7985E-06,2.8823E-06/
      DATA (KB(JT,58, 3),JT=1,5) /
     &1.9694E-06,2.0948E-06,2.1872E-06,2.2740E-06,2.3512E-06/
      DATA (KB(JT,59, 3),JT=1,5) /
     &1.6303E-06,1.7449E-06,1.8268E-06,1.9070E-06,1.9708E-06/
      DATA (KB(JT,13, 4),JT=1,5) /
     &1.8047E-02,1.8718E-02,1.9333E-02,1.9945E-02,2.0619E-02/
      DATA (KB(JT,14, 4),JT=1,5) /
     &1.6432E-02,1.7100E-02,1.7741E-02,1.8401E-02,1.9089E-02/
      DATA (KB(JT,15, 4),JT=1,5) /
     &1.4807E-02,1.5451E-02,1.6100E-02,1.6750E-02,1.7413E-02/
      DATA (KB(JT,16, 4),JT=1,5) /
     &1.3139E-02,1.3704E-02,1.4262E-02,1.4904E-02,1.5552E-02/
      DATA (KB(JT,17, 4),JT=1,5) /
     &1.1663E-02,1.2130E-02,1.2669E-02,1.3218E-02,1.3830E-02/
      DATA (KB(JT,18, 4),JT=1,5) /
     &1.0329E-02,1.0751E-02,1.1271E-02,1.1798E-02,1.2374E-02/
      DATA (KB(JT,19, 4),JT=1,5) /
     &9.2112E-03,9.6353E-03,1.0130E-02,1.0649E-02,1.1157E-02/
      DATA (KB(JT,20, 4),JT=1,5) /
     &8.0574E-03,8.4807E-03,8.9054E-03,9.3587E-03,9.7992E-03/
      DATA (KB(JT,21, 4),JT=1,5) /
     &7.0019E-03,7.3853E-03,7.7827E-03,8.1758E-03,8.5421E-03/
      DATA (KB(JT,22, 4),JT=1,5) /
     &6.0893E-03,6.4266E-03,6.7752E-03,7.1040E-03,7.4095E-03/
      DATA (KB(JT,23, 4),JT=1,5) /
     &5.2966E-03,5.5992E-03,5.8988E-03,6.1748E-03,6.4166E-03/
      DATA (KB(JT,24, 4),JT=1,5) /
     &4.6174E-03,4.8835E-03,5.1353E-03,5.3661E-03,5.5632E-03/
      DATA (KB(JT,25, 4),JT=1,5) /
     &4.0173E-03,4.2433E-03,4.4670E-03,4.6521E-03,4.8258E-03/
      DATA (KB(JT,26, 4),JT=1,5) /
     &3.4865E-03,3.6826E-03,3.8670E-03,4.0200E-03,4.1614E-03/
      DATA (KB(JT,27, 4),JT=1,5) /
     &3.0102E-03,3.1785E-03,3.3303E-03,3.4548E-03,3.5736E-03/
      DATA (KB(JT,28, 4),JT=1,5) /
     &2.5902E-03,2.7336E-03,2.8553E-03,2.9588E-03,3.0603E-03/
      DATA (KB(JT,29, 4),JT=1,5) /
     &2.2148E-03,2.3314E-03,2.4216E-03,2.5098E-03,2.5968E-03/
      DATA (KB(JT,30, 4),JT=1,5) /
     &1.8884E-03,1.9733E-03,2.0479E-03,2.1223E-03,2.2826E-03/
      DATA (KB(JT,31, 4),JT=1,5) /
     &1.5995E-03,1.6617E-03,1.7230E-03,1.7883E-03,1.9307E-03/
      DATA (KB(JT,32, 4),JT=1,5) /
     &1.3496E-03,1.3999E-03,1.4538E-03,1.5096E-03,1.6319E-03/
      DATA (KB(JT,33, 4),JT=1,5) /
     &1.1363E-03,1.1813E-03,1.2287E-03,1.2753E-03,1.3874E-03/
      DATA (KB(JT,34, 4),JT=1,5) /
     &9.6663E-04,1.0050E-03,1.0440E-03,1.1401E-03,1.1914E-03/
      DATA (KB(JT,35, 4),JT=1,5) /
     &8.2252E-04,8.5291E-04,8.9255E-04,9.7906E-04,1.0213E-03/
      DATA (KB(JT,36, 4),JT=1,5) /
     &6.9843E-04,7.2671E-04,7.6052E-04,8.3992E-04,8.7893E-04/
      DATA (KB(JT,37, 4),JT=1,5) /
     &5.7973E-04,6.0624E-04,6.3703E-04,7.0532E-04,7.4046E-04/
      DATA (KB(JT,38, 4),JT=1,5) /
     &4.8124E-04,5.0463E-04,5.3059E-04,5.8984E-04,6.2161E-04/
      DATA (KB(JT,39, 4),JT=1,5) /
     &3.9797E-04,4.2007E-04,4.4141E-04,4.6508E-04,5.2126E-04/
      DATA (KB(JT,40, 4),JT=1,5) /
     &3.2587E-04,3.4475E-04,3.6264E-04,3.8270E-04,4.3106E-04/
      DATA (KB(JT,41, 4),JT=1,5) /
     &2.6592E-04,2.8134E-04,2.9669E-04,3.1406E-04,3.5481E-04/
      DATA (KB(JT,42, 4),JT=1,5) /
     &2.1654E-04,2.2933E-04,2.4233E-04,2.5702E-04,2.9186E-04/
      DATA (KB(JT,43, 4),JT=1,5) /
     &1.7468E-04,1.8487E-04,1.9562E-04,2.0857E-04,2.2203E-04/
      DATA (KB(JT,44, 4),JT=1,5) /
     &1.3990E-04,1.4813E-04,1.5725E-04,1.6786E-04,1.7935E-04/
      DATA (KB(JT,45, 4),JT=1,5) /
     &1.1147E-04,1.1816E-04,1.2590E-04,1.3456E-04,1.4433E-04/
      DATA (KB(JT,46, 4),JT=1,5) /
     &8.8593E-05,9.4029E-05,1.0037E-04,1.0744E-04,1.1598E-04/
      DATA (KB(JT,47, 4),JT=1,5) /
     &7.0072E-05,7.4712E-05,7.9919E-05,8.5900E-05,9.3033E-05/
      DATA (KB(JT,48, 4),JT=1,5) /
     &5.5180E-05,5.9132E-05,6.3502E-05,6.8198E-05,7.4266E-05/
      DATA (KB(JT,49, 4),JT=1,5) /
     &4.3109E-05,4.6388E-05,5.0075E-05,5.3912E-05,5.8896E-05/
      DATA (KB(JT,50, 4),JT=1,5) /
     &3.4049E-05,3.6756E-05,3.9830E-05,4.3128E-05,4.7184E-05/
      DATA (KB(JT,51, 4),JT=1,5) /
     &2.7005E-05,2.9148E-05,3.1674E-05,3.4539E-05,3.7748E-05/
      DATA (KB(JT,52, 4),JT=1,5) /
     &2.1299E-05,2.3058E-05,2.5114E-05,2.7488E-05,3.0113E-05/
      DATA (KB(JT,53, 4),JT=1,5) /
     &1.6705E-05,1.8140E-05,1.9875E-05,2.1784E-05,2.3982E-05/
      DATA (KB(JT,54, 4),JT=1,5) /
     &1.3350E-05,1.4560E-05,1.5930E-05,1.7502E-05,1.9341E-05/
      DATA (KB(JT,55, 4),JT=1,5) /
     &1.0773E-05,1.1749E-05,1.2886E-05,1.4153E-05,1.5702E-05/
      DATA (KB(JT,56, 4),JT=1,5) /
     &8.6460E-06,9.4510E-06,1.0398E-05,1.1452E-05,1.2706E-05/
      DATA (KB(JT,57, 4),JT=1,5) /
     &6.9096E-06,7.6015E-06,8.3864E-06,9.2473E-06,1.0265E-05/
      DATA (KB(JT,58, 4),JT=1,5) /
     &5.5254E-06,6.1387E-06,6.7789E-06,7.4818E-06,8.3075E-06/
      DATA (KB(JT,59, 4),JT=1,5) /
     &4.6551E-06,5.1865E-06,5.7401E-06,6.3194E-06,7.0521E-06/
      DATA (KB(JT,13, 5),JT=1,5) /
     &3.4718E-02,3.5594E-02,3.6803E-02,3.8083E-02,3.9520E-02/
      DATA (KB(JT,14, 5),JT=1,5) /
     &3.2238E-02,3.3220E-02,3.4363E-02,3.5532E-02,3.6904E-02/
      DATA (KB(JT,15, 5),JT=1,5) /
     &3.0600E-02,3.1610E-02,3.2771E-02,3.3966E-02,3.5285E-02/
      DATA (KB(JT,16, 5),JT=1,5) /
     &2.8159E-02,2.9168E-02,3.0264E-02,3.1396E-02,3.2647E-02/
      DATA (KB(JT,17, 5),JT=1,5) /
     &2.5788E-02,2.6724E-02,2.7768E-02,2.8866E-02,3.0013E-02/
      DATA (KB(JT,18, 5),JT=1,5) /
     &2.3487E-02,2.4520E-02,2.5499E-02,2.6557E-02,2.7740E-02/
      DATA (KB(JT,19, 5),JT=1,5) /
     &2.1508E-02,2.2551E-02,2.3562E-02,2.4611E-02,2.5770E-02/
      DATA (KB(JT,20, 5),JT=1,5) /
     &1.9153E-02,2.0099E-02,2.1123E-02,2.2234E-02,2.3370E-02/
      DATA (KB(JT,21, 5),JT=1,5) /
     &1.6910E-02,1.7820E-02,1.8821E-02,1.9939E-02,2.1019E-02/
      DATA (KB(JT,22, 5),JT=1,5) /
     &1.4892E-02,1.5824E-02,1.6836E-02,1.7897E-02,1.8973E-02/
      DATA (KB(JT,23, 5),JT=1,5) /
     &1.3201E-02,1.4110E-02,1.5066E-02,1.6122E-02,1.7163E-02/
      DATA (KB(JT,24, 5),JT=1,5) /
     &1.1786E-02,1.2643E-02,1.3592E-02,1.4574E-02,1.5604E-02/
      DATA (KB(JT,25, 5),JT=1,5) /
     &1.0551E-02,1.1376E-02,1.2278E-02,1.3228E-02,1.4135E-02/
      DATA (KB(JT,26, 5),JT=1,5) /
     &9.4341E-03,1.0259E-02,1.1075E-02,1.1949E-02,1.2760E-02/
      DATA (KB(JT,27, 5),JT=1,5) /
     &8.4286E-03,9.1773E-03,9.9233E-03,1.0676E-02,1.1418E-02/
      DATA (KB(JT,28, 5),JT=1,5) /
     &7.5098E-03,8.1852E-03,8.8662E-03,9.5190E-03,1.0161E-02/
      DATA (KB(JT,29, 5),JT=1,5) /
     &6.6339E-03,7.2146E-03,7.8111E-03,8.3875E-03,8.9339E-03/
      DATA (KB(JT,30, 5),JT=1,5) /
     &5.8318E-03,6.3504E-03,6.8644E-03,7.3656E-03,8.2854E-03/
      DATA (KB(JT,31, 5),JT=1,5) /
     &5.0938E-03,5.5450E-03,5.9883E-03,6.4048E-03,7.2251E-03/
      DATA (KB(JT,32, 5),JT=1,5) /
     &4.4534E-03,4.8436E-03,5.2343E-03,5.5836E-03,6.3649E-03/
      DATA (KB(JT,33, 5),JT=1,5) /
     &3.8952E-03,4.2551E-03,4.5701E-03,4.9101E-03,5.6667E-03/
      DATA (KB(JT,34, 5),JT=1,5) /
     &3.4434E-03,3.7546E-03,4.0585E-03,4.7206E-03,5.1136E-03/
      DATA (KB(JT,35, 5),JT=1,5) /
     &3.0323E-03,3.3194E-03,3.6005E-03,4.2419E-03,4.6276E-03/
      DATA (KB(JT,36, 5),JT=1,5) /
     &2.6713E-03,2.9283E-03,3.2072E-03,3.8119E-03,4.2091E-03/
      DATA (KB(JT,37, 5),JT=1,5) /
     &2.2748E-03,2.5138E-03,2.7697E-03,3.3361E-03,3.7192E-03/
      DATA (KB(JT,38, 5),JT=1,5) /
     &1.9294E-03,2.1456E-03,2.3858E-03,2.9205E-03,3.2883E-03/
      DATA (KB(JT,39, 5),JT=1,5) /
     &1.6394E-03,1.8308E-03,2.0616E-03,2.3311E-03,2.9179E-03/
      DATA (KB(JT,40, 5),JT=1,5) /
     &1.3611E-03,1.5347E-03,1.7447E-03,1.9909E-03,2.5336E-03/
      DATA (KB(JT,41, 5),JT=1,5) /
     &1.1258E-03,1.2811E-03,1.4710E-03,1.6948E-03,2.1957E-03/
      DATA (KB(JT,42, 5),JT=1,5) /
     &9.3054E-04,1.0685E-03,1.2380E-03,1.4417E-03,1.8992E-03/
      DATA (KB(JT,43, 5),JT=1,5) /
     &7.5595E-04,8.7758E-04,1.0267E-03,1.2093E-03,1.4383E-03/
      DATA (KB(JT,44, 5),JT=1,5) /
     &6.0708E-04,7.1329E-04,8.4285E-04,1.0050E-03,1.2098E-03/
      DATA (KB(JT,45, 5),JT=1,5) /
     &4.8565E-04,5.7704E-04,6.8980E-04,8.3254E-04,1.0112E-03/
      DATA (KB(JT,46, 5),JT=1,5) /
     &3.8568E-04,4.6292E-04,5.6071E-04,6.8523E-04,8.4055E-04/
      DATA (KB(JT,47, 5),JT=1,5) /
     &3.0303E-04,3.6775E-04,4.5081E-04,5.5621E-04,6.9040E-04/
      DATA (KB(JT,48, 5),JT=1,5) /
     &2.3629E-04,2.9047E-04,3.6009E-04,4.4971E-04,5.6449E-04/
      DATA (KB(JT,49, 5),JT=1,5) /
     &1.8277E-04,2.2768E-04,2.8500E-04,3.5988E-04,4.5780E-04/
      DATA (KB(JT,50, 5),JT=1,5) /
     &1.4236E-04,1.7948E-04,2.2683E-04,2.8959E-04,3.7278E-04/
      DATA (KB(JT,51, 5),JT=1,5) /
     &1.1105E-04,1.4188E-04,1.8087E-04,2.3323E-04,3.0421E-04/
      DATA (KB(JT,52, 5),JT=1,5) /
     &8.5949E-05,1.1090E-04,1.4310E-04,1.8669E-04,2.4668E-04/
      DATA (KB(JT,53, 5),JT=1,5) /
     &6.6010E-05,8.6189E-05,1.1254E-04,1.4823E-04,1.9832E-04/
      DATA (KB(JT,54, 5),JT=1,5) /
     &5.1508E-05,6.7802E-05,8.9425E-05,1.1908E-04,1.6117E-04/
      DATA (KB(JT,55, 5),JT=1,5) /
     &4.0450E-05,5.3662E-05,7.1436E-05,9.6039E-05,1.3135E-04/
      DATA (KB(JT,56, 5),JT=1,5) /
     &3.1739E-05,4.2180E-05,5.6735E-05,7.6991E-05,1.0631E-04/
      DATA (KB(JT,57, 5),JT=1,5) /
     &2.4823E-05,3.2939E-05,4.4784E-05,6.1322E-05,8.5682E-05/
      DATA (KB(JT,58, 5),JT=1,5) /
     &1.9514E-05,2.5849E-05,3.5397E-05,4.8867E-05,6.9076E-05/
      DATA (KB(JT,59, 5),JT=1,5) /
     &1.6536E-05,2.1873E-05,3.0188E-05,4.2152E-05,6.0090E-05/
      DATA (KB(JT,13, 6),JT=1,5) /
     &7.0936E-02,7.2599E-02,7.4412E-02,7.6631E-02,7.9197E-02/
      DATA (KB(JT,14, 6),JT=1,5) /
     &6.5108E-02,6.6883E-02,6.8861E-02,7.1194E-02,7.3890E-02/
      DATA (KB(JT,15, 6),JT=1,5) /
     &6.1844E-02,6.3875E-02,6.5914E-02,6.8440E-02,7.1135E-02/
      DATA (KB(JT,16, 6),JT=1,5) /
     &5.8757E-02,6.1061E-02,6.3588E-02,6.6243E-02,6.9218E-02/
      DATA (KB(JT,17, 6),JT=1,5) /
     &5.6075E-02,5.8373E-02,6.0818E-02,6.3696E-02,6.6956E-02/
      DATA (KB(JT,18, 6),JT=1,5) /
     &5.3195E-02,5.5446E-02,5.8088E-02,6.0906E-02,6.3907E-02/
      DATA (KB(JT,19, 6),JT=1,5) /
     &5.0738E-02,5.2979E-02,5.5433E-02,5.8280E-02,6.1280E-02/
      DATA (KB(JT,20, 6),JT=1,5) /
     &4.6694E-02,4.8984E-02,5.1371E-02,5.4034E-02,5.7035E-02/
      DATA (KB(JT,21, 6),JT=1,5) /
     &4.2499E-02,4.4760E-02,4.7087E-02,4.9709E-02,5.2664E-02/
      DATA (KB(JT,22, 6),JT=1,5) /
     &3.8535E-02,4.0776E-02,4.3118E-02,4.5805E-02,4.8711E-02/
      DATA (KB(JT,23, 6),JT=1,5) /
     &3.4990E-02,3.7200E-02,3.9611E-02,4.2290E-02,4.5266E-02/
      DATA (KB(JT,24, 6),JT=1,5) /
     &3.1926E-02,3.4161E-02,3.6618E-02,3.9305E-02,4.2288E-02/
      DATA (KB(JT,25, 6),JT=1,5) /
     &2.9165E-02,3.1418E-02,3.3868E-02,3.6528E-02,3.9610E-02/
      DATA (KB(JT,26, 6),JT=1,5) /
     &2.6632E-02,2.8869E-02,3.1334E-02,3.4138E-02,3.7332E-02/
      DATA (KB(JT,27, 6),JT=1,5) /
     &2.4229E-02,2.6481E-02,2.9027E-02,3.1970E-02,3.5096E-02/
      DATA (KB(JT,28, 6),JT=1,5) /
     &2.2118E-02,2.4355E-02,2.6986E-02,2.9969E-02,3.3170E-02/
      DATA (KB(JT,29, 6),JT=1,5) /
     &2.0075E-02,2.2435E-02,2.5083E-02,2.8074E-02,3.1267E-02/
      DATA (KB(JT,30, 6),JT=1,5) /
     &1.8356E-02,2.0732E-02,2.3448E-02,2.6423E-02,3.0839E-02/
      DATA (KB(JT,31, 6),JT=1,5) /
     &1.6821E-02,1.9252E-02,2.1963E-02,2.5007E-02,2.9517E-02/
      DATA (KB(JT,32, 6),JT=1,5) /
     &1.5646E-02,1.8065E-02,2.0807E-02,2.3917E-02,2.8359E-02/
      DATA (KB(JT,33, 6),JT=1,5) /
     &1.4697E-02,1.7147E-02,1.9949E-02,2.3040E-02,2.7566E-02/
      DATA (KB(JT,34, 6),JT=1,5) /
     &1.3988E-02,1.6488E-02,1.9318E-02,2.3681E-02,2.7159E-02/
      DATA (KB(JT,35, 6),JT=1,5) /
     &1.3271E-02,1.5781E-02,1.8680E-02,2.3148E-02,2.6620E-02/
      DATA (KB(JT,36, 6),JT=1,5) /
     &1.2443E-02,1.5030E-02,1.7973E-02,2.2405E-02,2.5873E-02/
      DATA (KB(JT,37, 6),JT=1,5) /
     &1.1274E-02,1.3767E-02,1.6642E-02,2.1024E-02,2.4462E-02/
      DATA (KB(JT,38, 6),JT=1,5) /
     &1.0206E-02,1.2636E-02,1.5395E-02,1.9741E-02,2.3148E-02/
      DATA (KB(JT,39, 6),JT=1,5) /
     &9.2481E-03,1.1600E-02,1.4300E-02,1.7327E-02,2.1951E-02/
      DATA (KB(JT,40, 6),JT=1,5) /
     &8.1267E-03,1.0335E-02,1.2898E-02,1.5836E-02,2.0384E-02/
      DATA (KB(JT,41, 6),JT=1,5) /
     &7.0946E-03,9.1506E-03,1.1587E-02,1.4430E-02,1.8862E-02/
      DATA (KB(JT,42, 6),JT=1,5) /
     &6.1743E-03,8.0792E-03,1.0417E-02,1.3119E-02,1.7424E-02/
      DATA (KB(JT,43, 6),JT=1,5) /
     &5.2531E-03,6.9901E-03,9.1605E-03,1.1697E-02,1.4583E-02/
      DATA (KB(JT,44, 6),JT=1,5) /
     &4.3985E-03,5.9665E-03,7.9494E-03,1.0327E-02,1.3038E-02/
      DATA (KB(JT,45, 6),JT=1,5) /
     &3.6636E-03,5.0581E-03,6.8612E-03,9.0504E-03,1.1599E-02/
      DATA (KB(JT,46, 6),JT=1,5) /
     &3.0066E-03,4.2365E-03,5.8498E-03,7.8432E-03,1.0214E-02/
      DATA (KB(JT,47, 6),JT=1,5) /
     &2.4125E-03,3.4783E-03,4.8978E-03,6.6863E-03,8.8516E-03/
      DATA (KB(JT,48, 6),JT=1,5) /
     &1.9141E-03,2.8190E-03,4.0533E-03,5.6391E-03,7.5940E-03/
      DATA (KB(JT,49, 6),JT=1,5) /
     &1.4995E-03,2.2582E-03,3.3183E-03,4.7078E-03,6.4551E-03/
      DATA (KB(JT,50, 6),JT=1,5) /
     &1.1787E-03,1.8162E-03,2.7290E-03,3.9486E-03,5.5105E-03/
      DATA (KB(JT,51, 6),JT=1,5) /
     &9.2536E-04,1.4546E-03,2.2372E-03,3.3051E-03,4.6909E-03/
      DATA (KB(JT,52, 6),JT=1,5) /
     &7.1718E-04,1.1533E-03,1.8133E-03,2.7360E-03,3.9584E-03/
      DATA (KB(JT,53, 6),JT=1,5) /
     &5.4913E-04,9.0136E-04,1.4515E-03,2.2390E-03,3.3052E-03/
      DATA (KB(JT,54, 6),JT=1,5) /
     &4.2639E-04,7.1524E-04,1.1781E-03,1.8604E-03,2.8043E-03/
      DATA (KB(JT,55, 6),JT=1,5) /
     &3.3211E-04,5.6986E-04,9.6021E-04,1.5541E-03,2.3898E-03/
      DATA (KB(JT,56, 6),JT=1,5) /
     &2.5572E-04,4.4925E-04,7.7580E-04,1.2883E-03,2.0250E-03/
      DATA (KB(JT,57, 6),JT=1,5) /
     &1.9517E-04,3.4994E-04,6.2105E-04,1.0576E-03,1.7032E-03/
      DATA (KB(JT,58, 6),JT=1,5) /
     &1.4935E-04,2.7300E-04,4.9776E-04,8.6979E-04,1.4384E-03/
      DATA (KB(JT,59, 6),JT=1,5) /
     &1.2881E-04,2.4100E-04,4.4942E-04,8.0211E-04,1.3455E-03/
      DATA (KB(JT,13, 7),JT=1,5) /
     &1.5834E-01,1.6249E-01,1.6718E-01,1.7299E-01,1.7881E-01/
      DATA (KB(JT,14, 7),JT=1,5) /
     &1.4697E-01,1.5136E-01,1.5631E-01,1.6088E-01,1.6631E-01/
      DATA (KB(JT,15, 7),JT=1,5) /
     &1.4037E-01,1.4484E-01,1.4966E-01,1.5465E-01,1.6040E-01/
      DATA (KB(JT,16, 7),JT=1,5) /
     &1.3335E-01,1.3799E-01,1.4282E-01,1.4817E-01,1.5433E-01/
      DATA (KB(JT,17, 7),JT=1,5) /
     &1.2994E-01,1.3481E-01,1.4043E-01,1.4652E-01,1.5312E-01/
      DATA (KB(JT,18, 7),JT=1,5) /
     &1.2814E-01,1.3395E-01,1.4042E-01,1.4789E-01,1.5627E-01/
      DATA (KB(JT,19, 7),JT=1,5) /
     &1.2710E-01,1.3361E-01,1.4139E-01,1.4985E-01,1.5917E-01/
      DATA (KB(JT,20, 7),JT=1,5) /
     &1.2151E-01,1.2844E-01,1.3635E-01,1.4526E-01,1.5485E-01/
      DATA (KB(JT,21, 7),JT=1,5) /
     &1.1463E-01,1.2176E-01,1.2980E-01,1.3882E-01,1.4834E-01/
      DATA (KB(JT,22, 7),JT=1,5) /
     &1.0733E-01,1.1471E-01,1.2303E-01,1.3189E-01,1.4224E-01/
      DATA (KB(JT,23, 7),JT=1,5) /
     &1.0056E-01,1.0811E-01,1.1675E-01,1.2597E-01,1.3621E-01/
      DATA (KB(JT,24, 7),JT=1,5) /
     &9.4505E-02,1.0259E-01,1.1127E-01,1.2075E-01,1.3101E-01/
      DATA (KB(JT,25, 7),JT=1,5) /
     &8.9426E-02,9.7409E-02,1.0620E-01,1.1605E-01,1.2683E-01/
      DATA (KB(JT,26, 7),JT=1,5) /
     &8.4533E-02,9.2442E-02,1.0164E-01,1.1173E-01,1.2271E-01/
      DATA (KB(JT,27, 7),JT=1,5) /
     &7.9749E-02,8.8003E-02,9.7311E-02,1.0746E-01,1.1871E-01/
      DATA (KB(JT,28, 7),JT=1,5) /
     &7.5483E-02,8.3936E-02,9.3313E-02,1.0378E-01,1.1507E-01/
      DATA (KB(JT,29, 7),JT=1,5) /
     &7.1103E-02,7.9904E-02,8.9739E-02,1.0032E-01,1.1148E-01/
      DATA (KB(JT,30, 7),JT=1,5) /
     &6.7483E-02,7.6590E-02,8.6589E-02,9.7210E-02,1.1098E-01/
      DATA (KB(JT,31, 7),JT=1,5) /
     &6.4404E-02,7.3695E-02,8.3853E-02,9.4939E-02,1.0916E-01/
      DATA (KB(JT,32, 7),JT=1,5) /
     &6.2132E-02,7.1593E-02,8.2197E-02,9.3726E-02,1.0838E-01/
      DATA (KB(JT,33, 7),JT=1,5) /
     &6.0812E-02,7.0660E-02,8.1722E-02,9.3787E-02,1.0875E-01/
      DATA (KB(JT,34, 7),JT=1,5) /
     &6.0340E-02,7.0788E-02,8.2210E-02,9.6618E-02,1.0965E-01/
      DATA (KB(JT,35, 7),JT=1,5) /
     &5.9655E-02,7.0346E-02,8.1926E-02,9.6670E-02,1.0999E-01/
      DATA (KB(JT,36, 7),JT=1,5) /
     &5.8475E-02,6.9222E-02,8.1005E-02,9.6061E-02,1.0964E-01/
      DATA (KB(JT,37, 7),JT=1,5) /
     &5.5330E-02,6.5969E-02,7.7716E-02,9.2736E-02,1.0626E-01/
      DATA (KB(JT,38, 7),JT=1,5) /
     &5.2353E-02,6.2872E-02,7.4519E-02,8.9400E-02,1.0278E-01/
      DATA (KB(JT,39, 7),JT=1,5) /
     &4.9669E-02,5.9933E-02,7.1439E-02,8.4019E-02,9.9553E-02/
      DATA (KB(JT,40, 7),JT=1,5) /
     &4.5810E-02,5.5845E-02,6.7001E-02,7.9231E-02,9.4558E-02/
      DATA (KB(JT,41, 7),JT=1,5) /
     &4.2118E-02,5.1782E-02,6.2542E-02,7.4429E-02,8.9527E-02/
      DATA (KB(JT,42, 7),JT=1,5) /
     &3.8602E-02,4.7947E-02,5.8290E-02,6.9790E-02,8.4691E-02/
      DATA (KB(JT,43, 7),JT=1,5) /
     &3.4683E-02,4.3605E-02,5.3513E-02,6.4549E-02,7.6612E-02/
      DATA (KB(JT,44, 7),JT=1,5) /
     &3.0820E-02,3.9228E-02,4.8707E-02,5.9113E-02,7.0667E-02/
      DATA (KB(JT,45, 7),JT=1,5) /
     &2.7206E-02,3.5088E-02,4.4017E-02,5.3958E-02,6.4971E-02/
      DATA (KB(JT,46, 7),JT=1,5) /
     &2.3728E-02,3.1004E-02,3.9410E-02,4.8844E-02,5.9195E-02/
      DATA (KB(JT,47, 7),JT=1,5) /
     &2.0318E-02,2.6968E-02,3.4803E-02,4.3672E-02,5.3514E-02/
      DATA (KB(JT,48, 7),JT=1,5) /
     &1.7221E-02,2.3270E-02,3.0475E-02,3.8751E-02,4.8067E-02/
      DATA (KB(JT,49, 7),JT=1,5) /
     &1.4371E-02,1.9831E-02,2.6371E-02,3.4011E-02,4.2706E-02/
      DATA (KB(JT,50, 7),JT=1,5) /
     &1.2067E-02,1.6953E-02,2.2948E-02,3.0025E-02,3.8163E-02/
      DATA (KB(JT,51, 7),JT=1,5) /
     &1.0081E-02,1.4494E-02,1.9976E-02,2.6511E-02,3.4117E-02/
      DATA (KB(JT,52, 7),JT=1,5) /
     &8.3102E-03,1.2227E-02,1.7157E-02,2.3198E-02,3.0263E-02/
      DATA (KB(JT,53, 7),JT=1,5) /
     &6.7300E-03,1.0157E-02,1.4580E-02,2.0030E-02,2.6549E-02/
      DATA (KB(JT,54, 7),JT=1,5) /
     &5.5699E-03,8.6183E-03,1.2632E-02,1.7641E-02,2.3782E-02/
      DATA (KB(JT,55, 7),JT=1,5) /
     &4.6424E-03,7.3686E-03,1.1048E-02,1.5705E-02,2.1480E-02/
      DATA (KB(JT,56, 7),JT=1,5) /
     &3.8360E-03,6.2508E-03,9.5901E-03,1.3914E-02,1.9327E-02/
      DATA (KB(JT,57, 7),JT=1,5) /
     &3.1377E-03,5.2589E-03,8.2647E-03,1.2235E-02,1.7290E-02/
      DATA (KB(JT,58, 7),JT=1,5) /
     &2.5678E-03,4.4320E-03,7.1403E-03,1.0793E-02,1.5530E-02/
      DATA (KB(JT,59, 7),JT=1,5) /
     &2.3969E-03,4.2221E-03,6.8990E-03,1.0531E-02,1.5294E-02/
      DATA (KB(JT,13, 8),JT=1,5) /
     &4.5374E-01,4.6892E-01,4.8468E-01,5.0059E-01,5.1827E-01/
      DATA (KB(JT,14, 8),JT=1,5) /
     &4.3219E-01,4.4586E-01,4.6019E-01,4.7608E-01,4.9298E-01/
      DATA (KB(JT,15, 8),JT=1,5) /
     &4.0920E-01,4.2277E-01,4.3751E-01,4.5370E-01,4.7139E-01/
      DATA (KB(JT,16, 8),JT=1,5) /
     &3.8774E-01,3.9959E-01,4.1438E-01,4.3100E-01,4.4920E-01/
      DATA (KB(JT,17, 8),JT=1,5) /
     &3.7675E-01,3.9034E-01,4.0535E-01,4.2142E-01,4.3931E-01/
      DATA (KB(JT,18, 8),JT=1,5) /
     &3.7210E-01,3.8690E-01,4.0196E-01,4.1888E-01,4.3633E-01/
      DATA (KB(JT,19, 8),JT=1,5) /
     &3.8004E-01,3.9604E-01,4.1156E-01,4.2942E-01,4.4872E-01/
      DATA (KB(JT,20, 8),JT=1,5) /
     &3.8032E-01,3.9826E-01,4.1629E-01,4.3599E-01,4.5653E-01/
      DATA (KB(JT,21, 8),JT=1,5) /
     &3.7841E-01,3.9929E-01,4.1819E-01,4.3972E-01,4.6162E-01/
      DATA (KB(JT,22, 8),JT=1,5) /
     &3.7504E-01,3.9852E-01,4.2087E-01,4.4494E-01,4.6985E-01/
      DATA (KB(JT,23, 8),JT=1,5) /
     &3.7298E-01,3.9721E-01,4.2335E-01,4.5127E-01,4.7949E-01/
      DATA (KB(JT,24, 8),JT=1,5) /
     &3.7096E-01,3.9820E-01,4.2817E-01,4.5927E-01,4.9128E-01/
      DATA (KB(JT,25, 8),JT=1,5) /
     &3.6772E-01,3.9818E-01,4.3145E-01,4.6548E-01,5.0188E-01/
      DATA (KB(JT,26, 8),JT=1,5) /
     &3.6515E-01,3.9789E-01,4.3248E-01,4.6959E-01,5.0716E-01/
      DATA (KB(JT,27, 8),JT=1,5) /
     &3.5912E-01,3.9421E-01,4.3089E-01,4.6934E-01,5.0871E-01/
      DATA (KB(JT,28, 8),JT=1,5) /
     &3.5260E-01,3.8990E-01,4.2842E-01,4.6770E-01,5.0872E-01/
      DATA (KB(JT,29, 8),JT=1,5) /
     &3.4566E-01,3.8302E-01,4.2135E-01,4.6236E-01,5.0539E-01/
      DATA (KB(JT,30, 8),JT=1,5) /
     &3.3909E-01,3.7648E-01,4.1601E-01,4.5869E-01,5.0690E-01/
      DATA (KB(JT,31, 8),JT=1,5) /
     &3.3097E-01,3.6927E-01,4.1020E-01,4.5248E-01,5.0201E-01/
      DATA (KB(JT,32, 8),JT=1,5) /
     &3.2677E-01,3.6552E-01,4.0712E-01,4.4947E-01,4.9828E-01/
      DATA (KB(JT,33, 8),JT=1,5) /
     &3.2437E-01,3.6324E-01,4.0445E-01,4.4744E-01,4.9526E-01/
      DATA (KB(JT,34, 8),JT=1,5) /
     &3.2478E-01,3.6385E-01,4.0433E-01,4.5266E-01,4.9618E-01/
      DATA (KB(JT,35, 8),JT=1,5) /
     &3.2335E-01,3.6225E-01,4.0283E-01,4.5093E-01,4.9595E-01/
      DATA (KB(JT,36, 8),JT=1,5) /
     &3.1952E-01,3.5913E-01,4.0020E-01,4.4926E-01,4.9354E-01/
      DATA (KB(JT,37, 8),JT=1,5) /
     &3.0545E-01,3.4531E-01,3.8604E-01,4.3520E-01,4.7874E-01/
      DATA (KB(JT,38, 8),JT=1,5) /
     &2.9161E-01,3.3033E-01,3.7111E-01,4.1959E-01,4.6334E-01/
      DATA (KB(JT,39, 8),JT=1,5) /
     &2.7728E-01,3.1579E-01,3.5591E-01,3.9884E-01,4.4658E-01/
      DATA (KB(JT,40, 8),JT=1,5) /
     &2.6059E-01,2.9767E-01,3.3670E-01,3.7917E-01,4.2621E-01/
      DATA (KB(JT,41, 8),JT=1,5) /
     &2.4427E-01,2.7974E-01,3.1821E-01,3.5868E-01,4.0499E-01/
      DATA (KB(JT,42, 8),JT=1,5) /
     &2.2818E-01,2.6203E-01,2.9920E-01,3.3811E-01,3.8330E-01/
      DATA (KB(JT,43, 8),JT=1,5) /
     &2.1001E-01,2.4274E-01,2.7765E-01,3.1477E-01,3.5346E-01/
      DATA (KB(JT,44, 8),JT=1,5) /
     &1.9124E-01,2.2202E-01,2.5515E-01,2.8981E-01,3.2699E-01/
      DATA (KB(JT,45, 8),JT=1,5) /
     &1.7260E-01,2.0229E-01,2.3352E-01,2.6561E-01,2.9973E-01/
      DATA (KB(JT,46, 8),JT=1,5) /
     &1.5463E-01,1.8250E-01,2.1175E-01,2.4206E-01,2.7362E-01/
      DATA (KB(JT,47, 8),JT=1,5) /
     &1.3753E-01,1.6353E-01,1.9105E-01,2.1973E-01,2.4911E-01/
      DATA (KB(JT,48, 8),JT=1,5) /
     &1.2102E-01,1.4531E-01,1.7086E-01,1.9744E-01,2.2473E-01/
      DATA (KB(JT,49, 8),JT=1,5) /
     &1.0521E-01,1.2719E-01,1.5065E-01,1.7507E-01,1.9976E-01/
      DATA (KB(JT,50, 8),JT=1,5) /
     &9.2290E-02,1.1288E-01,1.3468E-01,1.5758E-01,1.8102E-01/
      DATA (KB(JT,51, 8),JT=1,5) /
     &8.1396E-02,1.0065E-01,1.2103E-01,1.4278E-01,1.6472E-01/
      DATA (KB(JT,52, 8),JT=1,5) /
     &7.1108E-02,8.8827E-02,1.0785E-01,1.2780E-01,1.4857E-01/
      DATA (KB(JT,53, 8),JT=1,5) /
     &6.0985E-02,7.7296E-02,9.4909E-02,1.1304E-01,1.3292E-01/
      DATA (KB(JT,54, 8),JT=1,5) /
     &5.4165E-02,6.9879E-02,8.6686E-02,1.0438E-01,1.2336E-01/
      DATA (KB(JT,55, 8),JT=1,5) /
     &4.9072E-02,6.4377E-02,8.0975E-02,9.8517E-02,1.1715E-01/
      DATA (KB(JT,56, 8),JT=1,5) /
     &4.4131E-02,5.9064E-02,7.5254E-02,9.2618E-02,1.1083E-01/
      DATA (KB(JT,57, 8),JT=1,5) /
     &3.9404E-02,5.3744E-02,6.9648E-02,8.6728E-02,1.0474E-01/
      DATA (KB(JT,58, 8),JT=1,5) /
     &3.5245E-02,4.9278E-02,6.4917E-02,8.1857E-02,9.9966E-02/
      DATA (KB(JT,59, 8),JT=1,5) /
     &3.5641E-02,5.0530E-02,6.7256E-02,8.5600E-02,1.0518E-01/
      DATA (KB(JT,13, 9),JT=1,5) /
     &3.0582E+00,3.1802E+00,3.2924E+00,3.3999E+00,3.5039E+00/
      DATA (KB(JT,14, 9),JT=1,5) /
     &2.7741E+00,2.8902E+00,2.9983E+00,3.1018E+00,3.1995E+00/
      DATA (KB(JT,15, 9),JT=1,5) /
     &2.5019E+00,2.6118E+00,2.7174E+00,2.8165E+00,2.9092E+00/
      DATA (KB(JT,16, 9),JT=1,5) /
     &2.2794E+00,2.3785E+00,2.4700E+00,2.5601E+00,2.6476E+00/
      DATA (KB(JT,17, 9),JT=1,5) /
     &2.1431E+00,2.2237E+00,2.2973E+00,2.3689E+00,2.4470E+00/
      DATA (KB(JT,18, 9),JT=1,5) /
     &2.1112E+00,2.1931E+00,2.2642E+00,2.3350E+00,2.3995E+00/
      DATA (KB(JT,19, 9),JT=1,5) /
     &2.1192E+00,2.1960E+00,2.2679E+00,2.3312E+00,2.3985E+00/
      DATA (KB(JT,20, 9),JT=1,5) /
     &2.0719E+00,2.1504E+00,2.2204E+00,2.2883E+00,2.3541E+00/
      DATA (KB(JT,21, 9),JT=1,5) /
     &2.0023E+00,2.0787E+00,2.1566E+00,2.2279E+00,2.2981E+00/
      DATA (KB(JT,22, 9),JT=1,5) /
     &1.9677E+00,2.0354E+00,2.1023E+00,2.1820E+00,2.2522E+00/
      DATA (KB(JT,23, 9),JT=1,5) /
     &1.9509E+00,2.0289E+00,2.0929E+00,2.1547E+00,2.2177E+00/
      DATA (KB(JT,24, 9),JT=1,5) /
     &1.9605E+00,2.0316E+00,2.0945E+00,2.1537E+00,2.2147E+00/
      DATA (KB(JT,25, 9),JT=1,5) /
     &1.9774E+00,2.0460E+00,2.1037E+00,2.1656E+00,2.2237E+00/
      DATA (KB(JT,26, 9),JT=1,5) /
     &1.9746E+00,2.0494E+00,2.1183E+00,2.1793E+00,2.2462E+00/
      DATA (KB(JT,27, 9),JT=1,5) /
     &1.9769E+00,2.0480E+00,2.1184E+00,2.1915E+00,2.2594E+00/
      DATA (KB(JT,28, 9),JT=1,5) /
     &1.9705E+00,2.0478E+00,2.1273E+00,2.2021E+00,2.2684E+00/
      DATA (KB(JT,29, 9),JT=1,5) /
     &1.9428E+00,2.0233E+00,2.1092E+00,2.1834E+00,2.2523E+00/
      DATA (KB(JT,30, 9),JT=1,5) /
     &1.9054E+00,1.9928E+00,2.0804E+00,2.1559E+00,2.2456E+00/
      DATA (KB(JT,31, 9),JT=1,5) /
     &1.8578E+00,1.9522E+00,2.0363E+00,2.1176E+00,2.2067E+00/
      DATA (KB(JT,32, 9),JT=1,5) /
     &1.8167E+00,1.9163E+00,1.9986E+00,2.0826E+00,2.1707E+00/
      DATA (KB(JT,33, 9),JT=1,5) /
     &1.7835E+00,1.8773E+00,1.9713E+00,2.0531E+00,2.1415E+00/
      DATA (KB(JT,34, 9),JT=1,5) /
     &1.7699E+00,1.8654E+00,1.9579E+00,2.0589E+00,2.1344E+00/
      DATA (KB(JT,35, 9),JT=1,5) /
     &1.7588E+00,1.8543E+00,1.9464E+00,2.0494E+00,2.1255E+00/
      DATA (KB(JT,36, 9),JT=1,5) /
     &1.7548E+00,1.8549E+00,1.9407E+00,2.0440E+00,2.1280E+00/
      DATA (KB(JT,37, 9),JT=1,5) /
     &1.7109E+00,1.8072E+00,1.9003E+00,1.9969E+00,2.0787E+00/
      DATA (KB(JT,38, 9),JT=1,5) /
     &1.6587E+00,1.7570E+00,1.8515E+00,1.9517E+00,2.0362E+00/
      DATA (KB(JT,39, 9),JT=1,5) /
     &1.5996E+00,1.6993E+00,1.7940E+00,1.8844E+00,1.9872E+00/
      DATA (KB(JT,40, 9),JT=1,5) /
     &1.5318E+00,1.6341E+00,1.7309E+00,1.8212E+00,1.9247E+00/
      DATA (KB(JT,41, 9),JT=1,5) /
     &1.4675E+00,1.5693E+00,1.6630E+00,1.7538E+00,1.8608E+00/
      DATA (KB(JT,42, 9),JT=1,5) /
     &1.4053E+00,1.5014E+00,1.5957E+00,1.6862E+00,1.7957E+00/
      DATA (KB(JT,43, 9),JT=1,5) /
     &1.3266E+00,1.4241E+00,1.5193E+00,1.6083E+00,1.7037E+00/
      DATA (KB(JT,44, 9),JT=1,5) /
     &1.2422E+00,1.3405E+00,1.4375E+00,1.5296E+00,1.6219E+00/
      DATA (KB(JT,45, 9),JT=1,5) /
     &1.1571E+00,1.2540E+00,1.3469E+00,1.4395E+00,1.5427E+00/
      DATA (KB(JT,46, 9),JT=1,5) /
     &1.0762E+00,1.1688E+00,1.2622E+00,1.3587E+00,1.4621E+00/
      DATA (KB(JT,47, 9),JT=1,5) /
     &9.9321E-01,1.0861E+00,1.1791E+00,1.2774E+00,1.3779E+00/
      DATA (KB(JT,48, 9),JT=1,5) /
     &9.0640E-01,1.0035E+00,1.0964E+00,1.1955E+00,1.2984E+00/
      DATA (KB(JT,49, 9),JT=1,5) /
     &8.2476E-01,9.1593E-01,1.0111E+00,1.1148E+00,1.2202E+00/
      DATA (KB(JT,50, 9),JT=1,5) /
     &7.5762E-01,8.4984E-01,9.4454E-01,1.0468E+00,1.1530E+00/
      DATA (KB(JT,51, 9),JT=1,5) /
     &6.9972E-01,7.8939E-01,8.8551E-01,9.8599E-01,1.0894E+00/
      DATA (KB(JT,52, 9),JT=1,5) /
     &6.4292E-01,7.3062E-01,8.2745E-01,9.2620E-01,1.0265E+00/
      DATA (KB(JT,53, 9),JT=1,5) /
     &5.8631E-01,6.7367E-01,7.6794E-01,8.6557E-01,9.6191E-01/
      DATA (KB(JT,54, 9),JT=1,5) /
     &5.4766E-01,6.3312E-01,7.2658E-01,8.2340E-01,9.1820E-01/
      DATA (KB(JT,55, 9),JT=1,5) /
     &5.1893E-01,6.0477E-01,6.9346E-01,7.9003E-01,8.8552E-01/
      DATA (KB(JT,56, 9),JT=1,5) /
     &4.9077E-01,5.7504E-01,6.6139E-01,7.5822E-01,8.5232E-01/
      DATA (KB(JT,57, 9),JT=1,5) /
     &4.6294E-01,5.4644E-01,6.3217E-01,7.2497E-01,8.2095E-01/
      DATA (KB(JT,58, 9),JT=1,5) /
     &4.3872E-01,5.2209E-01,6.0717E-01,6.9576E-01,7.9255E-01/
      DATA (KB(JT,59, 9),JT=1,5) /
     &4.5355E-01,5.4099E-01,6.2851E-01,7.1405E-01,8.0552E-01/
      DATA (KB(JT,13,10),JT=1,5) /
     &1.4982E+01,1.5495E+01,1.5954E+01,1.6348E+01,1.6704E+01/
      DATA (KB(JT,14,10),JT=1,5) /
     &1.3335E+01,1.3739E+01,1.4075E+01,1.4394E+01,1.4701E+01/
      DATA (KB(JT,15,10),JT=1,5) /
     &1.2249E+01,1.2466E+01,1.2680E+01,1.2851E+01,1.2999E+01/
      DATA (KB(JT,16,10),JT=1,5) /
     &1.1258E+01,1.1509E+01,1.1735E+01,1.1863E+01,1.1992E+01/
      DATA (KB(JT,17,10),JT=1,5) /
     &9.6399E+00,9.9316E+00,1.0198E+01,1.0495E+01,1.0685E+01/
      DATA (KB(JT,18,10),JT=1,5) /
     &8.3200E+00,8.3604E+00,8.4791E+00,8.5483E+00,8.6485E+00/
      DATA (KB(JT,19,10),JT=1,5) /
     &8.1074E+00,8.1199E+00,8.1734E+00,8.2725E+00,8.2532E+00/
      DATA (KB(JT,20,10),JT=1,5) /
     &8.0251E+00,8.0270E+00,8.1639E+00,8.2375E+00,8.2230E+00/
      DATA (KB(JT,21,10),JT=1,5) /
     &7.9993E+00,8.0934E+00,8.2060E+00,8.1449E+00,8.1878E+00/
      DATA (KB(JT,22,10),JT=1,5) /
     &7.7052E+00,7.8023E+00,8.0192E+00,8.0278E+00,8.0411E+00/
      DATA (KB(JT,23,10),JT=1,5) /
     &7.2443E+00,7.3880E+00,7.6036E+00,7.7289E+00,7.8141E+00/
      DATA (KB(JT,24,10),JT=1,5) /
     &6.8599E+00,6.9432E+00,7.2334E+00,7.4508E+00,7.5685E+00/
      DATA (KB(JT,25,10),JT=1,5) /
     &6.7077E+00,6.7570E+00,7.0253E+00,7.1690E+00,7.3506E+00/
      DATA (KB(JT,26,10),JT=1,5) /
     &6.7805E+00,6.7972E+00,6.9739E+00,6.9966E+00,7.1457E+00/
      DATA (KB(JT,27,10),JT=1,5) /
     &6.6456E+00,6.8298E+00,6.9537E+00,6.8703E+00,6.9847E+00/
      DATA (KB(JT,28,10),JT=1,5) /
     &6.6227E+00,6.7740E+00,6.7717E+00,6.7969E+00,6.8834E+00/
      DATA (KB(JT,29,10),JT=1,5) /
     &6.5026E+00,6.7130E+00,6.6983E+00,6.7888E+00,6.9842E+00/
      DATA (KB(JT,30,10),JT=1,5) /
     &6.4613E+00,6.7438E+00,6.7406E+00,6.8001E+00,7.0628E+00/
      DATA (KB(JT,31,10),JT=1,5) /
     &6.4453E+00,6.5818E+00,6.6914E+00,6.8343E+00,7.1118E+00/
      DATA (KB(JT,32,10),JT=1,5) /
     &6.4750E+00,6.5165E+00,6.6931E+00,6.9311E+00,7.2907E+00/
      DATA (KB(JT,33,10),JT=1,5) /
     &6.3852E+00,6.5174E+00,6.6687E+00,7.0429E+00,7.4921E+00/
      DATA (KB(JT,34,10),JT=1,5) /
     &6.2937E+00,6.5395E+00,6.7522E+00,7.1615E+00,7.5856E+00/
      DATA (KB(JT,35,10),JT=1,5) /
     &6.2760E+00,6.5561E+00,6.8772E+00,7.3182E+00,7.7508E+00/
      DATA (KB(JT,36,10),JT=1,5) /
     &6.2498E+00,6.5146E+00,6.9721E+00,7.4134E+00,7.7777E+00/
      DATA (KB(JT,37,10),JT=1,5) /
     &6.0875E+00,6.4490E+00,6.8813E+00,7.4029E+00,7.7937E+00/
      DATA (KB(JT,38,10),JT=1,5) /
     &5.9776E+00,6.3534E+00,6.8337E+00,7.2840E+00,7.6800E+00/
      DATA (KB(JT,39,10),JT=1,5) /
     &5.9369E+00,6.2769E+00,6.7228E+00,7.1879E+00,7.5772E+00/
      DATA (KB(JT,40,10),JT=1,5) /
     &5.8199E+00,6.1346E+00,6.5569E+00,7.0308E+00,7.5139E+00/
      DATA (KB(JT,41,10),JT=1,5) /
     &5.6637E+00,5.9953E+00,6.3928E+00,6.8959E+00,7.3899E+00/
      DATA (KB(JT,42,10),JT=1,5) /
     &5.4578E+00,5.8740E+00,6.2837E+00,6.7615E+00,7.2182E+00/
      DATA (KB(JT,43,10),JT=1,5) /
     &5.2432E+00,5.6884E+00,6.0915E+00,6.5892E+00,7.0176E+00/
      DATA (KB(JT,44,10),JT=1,5) /
     &5.0352E+00,5.5134E+00,5.9765E+00,6.3927E+00,6.8192E+00/
      DATA (KB(JT,45,10),JT=1,5) /
     &4.8185E+00,5.3066E+00,5.8216E+00,6.2708E+00,6.5394E+00/
      DATA (KB(JT,46,10),JT=1,5) /
     &4.5458E+00,5.0700E+00,5.5601E+00,5.9708E+00,6.3061E+00/
      DATA (KB(JT,47,10),JT=1,5) /
     &4.3290E+00,4.8090E+00,5.3177E+00,5.7187E+00,6.0493E+00/
      DATA (KB(JT,48,10),JT=1,5) /
     &4.1252E+00,4.6210E+00,5.0031E+00,5.3950E+00,5.6779E+00/
      DATA (KB(JT,49,10),JT=1,5) /
     &3.8776E+00,4.3638E+00,4.7491E+00,5.0119E+00,5.3209E+00/
      DATA (KB(JT,50,10),JT=1,5) /
     &3.6432E+00,4.1171E+00,4.5036E+00,4.8339E+00,5.0310E+00/
      DATA (KB(JT,51,10),JT=1,5) /
     &3.4528E+00,3.8987E+00,4.2685E+00,4.6158E+00,4.8586E+00/
      DATA (KB(JT,52,10),JT=1,5) /
     &3.2373E+00,3.6786E+00,4.0057E+00,4.3579E+00,4.6615E+00/
      DATA (KB(JT,53,10),JT=1,5) /
     &3.0066E+00,3.4261E+00,3.7660E+00,4.0904E+00,4.4162E+00/
      DATA (KB(JT,54,10),JT=1,5) /
     &2.8305E+00,3.2571E+00,3.6215E+00,3.9208E+00,4.2651E+00/
      DATA (KB(JT,55,10),JT=1,5) /
     &2.6852E+00,3.0952E+00,3.4961E+00,3.7995E+00,4.1315E+00/
      DATA (KB(JT,56,10),JT=1,5) /
     &2.5024E+00,2.9749E+00,3.3840E+00,3.6764E+00,4.0215E+00/
      DATA (KB(JT,57,10),JT=1,5) /
     &2.3413E+00,2.8251E+00,3.2333E+00,3.5901E+00,3.8695E+00/
      DATA (KB(JT,58,10),JT=1,5) /
     &2.2399E+00,2.6684E+00,3.1055E+00,3.4841E+00,3.7568E+00/
      DATA (KB(JT,59,10),JT=1,5) /
     &2.3106E+00,2.6842E+00,3.0911E+00,3.5243E+00,3.8718E+00/
      DATA (KB(JT,13,11),JT=1,5) /
     &3.1114E+01,3.1701E+01,3.2323E+01,3.2943E+01,3.3516E+01/
      DATA (KB(JT,14,11),JT=1,5) /
     &2.7715E+01,2.8303E+01,2.8933E+01,2.9548E+01,3.0169E+01/
      DATA (KB(JT,15,11),JT=1,5) /
     &2.4338E+01,2.4986E+01,2.5617E+01,2.6312E+01,2.7005E+01/
      DATA (KB(JT,16,11),JT=1,5) /
     &2.1212E+01,2.1803E+01,2.2432E+01,2.3085E+01,2.3696E+01/
      DATA (KB(JT,17,11),JT=1,5) /
     &1.8965E+01,1.9451E+01,1.9925E+01,2.0308E+01,2.0718E+01/
      DATA (KB(JT,18,11),JT=1,5) /
     &1.6301E+01,1.6846E+01,1.7358E+01,1.7884E+01,1.8436E+01/
      DATA (KB(JT,19,11),JT=1,5) /
     &1.3305E+01,1.3592E+01,1.3869E+01,1.4251E+01,1.4704E+01/
      DATA (KB(JT,20,11),JT=1,5) /
     &1.2734E+01,1.2816E+01,1.2643E+01,1.2573E+01,1.2686E+01/
      DATA (KB(JT,21,11),JT=1,5) /
     &1.2657E+01,1.2589E+01,1.2354E+01,1.2271E+01,1.2114E+01/
      DATA (KB(JT,22,11),JT=1,5) /
     &1.2492E+01,1.2455E+01,1.2170E+01,1.1916E+01,1.1871E+01/
      DATA (KB(JT,23,11),JT=1,5) /
     &1.2437E+01,1.2266E+01,1.2152E+01,1.1923E+01,1.2016E+01/
      DATA (KB(JT,24,11),JT=1,5) /
     &1.2312E+01,1.2409E+01,1.2179E+01,1.1958E+01,1.2034E+01/
      DATA (KB(JT,25,11),JT=1,5) /
     &1.1905E+01,1.2160E+01,1.2010E+01,1.2119E+01,1.2127E+01/
      DATA (KB(JT,26,11),JT=1,5) /
     &1.1398E+01,1.1792E+01,1.1851E+01,1.2073E+01,1.2295E+01/
      DATA (KB(JT,27,11),JT=1,5) /
     &1.1115E+01,1.1534E+01,1.1738E+01,1.2206E+01,1.2469E+01/
      DATA (KB(JT,28,11),JT=1,5) /
     &1.0833E+01,1.1382E+01,1.1757E+01,1.2168E+01,1.2751E+01/
      DATA (KB(JT,29,11),JT=1,5) /
     &1.0849E+01,1.1242E+01,1.1765E+01,1.2112E+01,1.2581E+01/
      DATA (KB(JT,30,11),JT=1,5) /
     &1.0908E+01,1.1219E+01,1.1698E+01,1.2283E+01,1.2675E+01/
      DATA (KB(JT,31,11),JT=1,5) /
     &1.1065E+01,1.1480E+01,1.1755E+01,1.2188E+01,1.2848E+01/
      DATA (KB(JT,32,11),JT=1,5) /
     &1.1087E+01,1.1591E+01,1.1912E+01,1.2336E+01,1.2746E+01/
      DATA (KB(JT,33,11),JT=1,5) /
     &1.1325E+01,1.1662E+01,1.2022E+01,1.2470E+01,1.2619E+01/
      DATA (KB(JT,34,11),JT=1,5) /
     &1.1533E+01,1.1754E+01,1.2155E+01,1.2455E+01,1.2615E+01/
      DATA (KB(JT,35,11),JT=1,5) /
     &1.1659E+01,1.1966E+01,1.2184E+01,1.2500E+01,1.2545E+01/
      DATA (KB(JT,36,11),JT=1,5) /
     &1.1755E+01,1.2074E+01,1.2225E+01,1.2599E+01,1.2813E+01/
      DATA (KB(JT,37,11),JT=1,5) /
     &1.1716E+01,1.1980E+01,1.2067E+01,1.2383E+01,1.2671E+01/
      DATA (KB(JT,38,11),JT=1,5) /
     &1.1652E+01,1.1821E+01,1.1815E+01,1.2298E+01,1.2561E+01/
      DATA (KB(JT,39,11),JT=1,5) /
     &1.1437E+01,1.1591E+01,1.1776E+01,1.2140E+01,1.2306E+01/
      DATA (KB(JT,40,11),JT=1,5) /
     &1.1267E+01,1.1380E+01,1.1567E+01,1.1899E+01,1.1967E+01/
      DATA (KB(JT,41,11),JT=1,5) /
     &1.0928E+01,1.1128E+01,1.1355E+01,1.1698E+01,1.1735E+01/
      DATA (KB(JT,42,11),JT=1,5) /
     &1.0609E+01,1.0842E+01,1.1168E+01,1.1452E+01,1.1524E+01/
      DATA (KB(JT,43,11),JT=1,5) /
     &1.0251E+01,1.0481E+01,1.0835E+01,1.1143E+01,1.1300E+01/
      DATA (KB(JT,44,11),JT=1,5) /
     &9.7650E+00,1.0106E+01,1.0340E+01,1.0725E+01,1.0899E+01/
      DATA (KB(JT,45,11),JT=1,5) /
     &9.2584E+00,9.6204E+00,9.9580E+00,1.0325E+01,1.0626E+01/
      DATA (KB(JT,46,11),JT=1,5) /
     &8.9377E+00,9.1742E+00,9.5458E+00,9.9839E+00,1.0197E+01/
      DATA (KB(JT,47,11),JT=1,5) /
     &8.5371E+00,8.7965E+00,9.0763E+00,9.5717E+00,9.9938E+00/
      DATA (KB(JT,48,11),JT=1,5) /
     &7.9850E+00,8.3229E+00,8.7471E+00,9.1748E+00,9.6663E+00/
      DATA (KB(JT,49,11),JT=1,5) /
     &7.4325E+00,7.8561E+00,8.3257E+00,8.9344E+00,9.3488E+00/
      DATA (KB(JT,50,11),JT=1,5) /
     &6.9934E+00,7.5330E+00,7.9938E+00,8.5231E+00,9.1226E+00/
      DATA (KB(JT,51,11),JT=1,5) /
     &6.6292E+00,7.1581E+00,7.7030E+00,8.1971E+00,8.9077E+00/
      DATA (KB(JT,52,11),JT=1,5) /
     &6.2107E+00,6.7791E+00,7.3981E+00,7.9369E+00,8.8177E+00/
      DATA (KB(JT,53,11),JT=1,5) /
     &5.7771E+00,6.3836E+00,7.0431E+00,7.8871E+00,8.9292E+00/
      DATA (KB(JT,54,11),JT=1,5) /
     &5.5085E+00,6.1058E+00,6.7091E+00,7.6421E+00,8.6682E+00/
      DATA (KB(JT,55,11),JT=1,5) /
     &5.3542E+00,5.9311E+00,6.5099E+00,7.2327E+00,8.2463E+00/
      DATA (KB(JT,56,11),JT=1,5) /
     &5.2013E+00,5.6998E+00,6.2622E+00,6.8978E+00,7.7861E+00/
      DATA (KB(JT,57,11),JT=1,5) /
     &4.9844E+00,5.4898E+00,6.0972E+00,6.6262E+00,7.3665E+00/
      DATA (KB(JT,58,11),JT=1,5) /
     &4.7470E+00,5.3695E+00,5.9047E+00,6.4509E+00,7.0483E+00/
      DATA (KB(JT,59,11),JT=1,5) /
     &4.7734E+00,5.4744E+00,6.0332E+00,6.5609E+00,7.0505E+00/
      DATA (KB(JT,13,12),JT=1,5) /
     &6.9738E+01,7.0752E+01,7.1414E+01,7.2004E+01,7.2657E+01/
      DATA (KB(JT,14,12),JT=1,5) /
     &6.4422E+01,6.5346E+01,6.6191E+01,6.7103E+01,6.7985E+01/
      DATA (KB(JT,15,12),JT=1,5) /
     &5.8702E+01,5.9763E+01,6.0895E+01,6.1978E+01,6.3157E+01/
      DATA (KB(JT,16,12),JT=1,5) /
     &5.3091E+01,5.4316E+01,5.5558E+01,5.6938E+01,5.8399E+01/
      DATA (KB(JT,17,12),JT=1,5) /
     &4.7175E+01,4.8634E+01,5.0234E+01,5.1992E+01,5.3803E+01/
      DATA (KB(JT,18,12),JT=1,5) /
     &4.1145E+01,4.2755E+01,4.4548E+01,4.6436E+01,4.8468E+01/
      DATA (KB(JT,19,12),JT=1,5) /
     &3.4889E+01,3.6512E+01,3.8406E+01,4.0570E+01,4.2997E+01/
      DATA (KB(JT,20,12),JT=1,5) /
     &2.8470E+01,3.0112E+01,3.2281E+01,3.4662E+01,3.7243E+01/
      DATA (KB(JT,21,12),JT=1,5) /
     &2.3947E+01,2.5322E+01,2.7206E+01,2.9369E+01,3.2034E+01/
      DATA (KB(JT,22,12),JT=1,5) /
     &2.2071E+01,2.2771E+01,2.4136E+01,2.6151E+01,2.8304E+01/
      DATA (KB(JT,23,12),JT=1,5) /
     &2.1437E+01,2.2028E+01,2.2789E+01,2.3769E+01,2.5664E+01/
      DATA (KB(JT,24,12),JT=1,5) /
     &2.1104E+01,2.1623E+01,2.2496E+01,2.3486E+01,2.4592E+01/
      DATA (KB(JT,25,12),JT=1,5) /
     &2.1238E+01,2.1868E+01,2.2645E+01,2.3461E+01,2.4762E+01/
      DATA (KB(JT,26,12),JT=1,5) /
     &2.1604E+01,2.2258E+01,2.3294E+01,2.4121E+01,2.5265E+01/
      DATA (KB(JT,27,12),JT=1,5) /
     &2.2115E+01,2.2777E+01,2.3909E+01,2.4766E+01,2.5867E+01/
      DATA (KB(JT,28,12),JT=1,5) /
     &2.2448E+01,2.3238E+01,2.4298E+01,2.5624E+01,2.6343E+01/
      DATA (KB(JT,29,12),JT=1,5) /
     &2.2577E+01,2.3289E+01,2.4323E+01,2.5634E+01,2.6765E+01/
      DATA (KB(JT,30,12),JT=1,5) /
     &2.2578E+01,2.3315E+01,2.4386E+01,2.5500E+01,2.6908E+01/
      DATA (KB(JT,31,12),JT=1,5) /
     &2.2201E+01,2.3259E+01,2.4131E+01,2.5149E+01,2.6545E+01/
      DATA (KB(JT,32,12),JT=1,5) /
     &2.2079E+01,2.2922E+01,2.4111E+01,2.5430E+01,2.6527E+01/
      DATA (KB(JT,33,12),JT=1,5) /
     &2.2095E+01,2.2961E+01,2.4279E+01,2.5414E+01,2.7005E+01/
      DATA (KB(JT,34,12),JT=1,5) /
     &2.2319E+01,2.3341E+01,2.4447E+01,2.6277E+01,2.7940E+01/
      DATA (KB(JT,35,12),JT=1,5) /
     &2.2552E+01,2.3701E+01,2.5211E+01,2.6844E+01,2.9224E+01/
      DATA (KB(JT,36,12),JT=1,5) /
     &2.3085E+01,2.4181E+01,2.5665E+01,2.7600E+01,3.0387E+01/
      DATA (KB(JT,37,12),JT=1,5) /
     &2.2925E+01,2.4128E+01,2.5553E+01,2.7616E+01,3.1077E+01/
      DATA (KB(JT,38,12),JT=1,5) /
     &2.2707E+01,2.3887E+01,2.5581E+01,2.8109E+01,3.1584E+01/
      DATA (KB(JT,39,12),JT=1,5) /
     &2.2511E+01,2.3842E+01,2.5754E+01,2.8880E+01,3.2658E+01/
      DATA (KB(JT,40,12),JT=1,5) /
     &2.1948E+01,2.3291E+01,2.5416E+01,2.8638E+01,3.2604E+01/
      DATA (KB(JT,41,12),JT=1,5) /
     &2.1476E+01,2.2682E+01,2.5024E+01,2.8295E+01,3.2225E+01/
      DATA (KB(JT,42,12),JT=1,5) /
     &2.0874E+01,2.2077E+01,2.4841E+01,2.8049E+01,3.2070E+01/
      DATA (KB(JT,43,12),JT=1,5) /
     &2.0317E+01,2.1501E+01,2.4302E+01,2.7503E+01,3.1532E+01/
      DATA (KB(JT,44,12),JT=1,5) /
     &1.9539E+01,2.0870E+01,2.3855E+01,2.7092E+01,3.1110E+01/
      DATA (KB(JT,45,12),JT=1,5) /
     &1.8830E+01,2.0599E+01,2.3570E+01,2.6837E+01,3.0566E+01/
      DATA (KB(JT,46,12),JT=1,5) /
     &1.8029E+01,2.0375E+01,2.3363E+01,2.6419E+01,3.0085E+01/
      DATA (KB(JT,47,12),JT=1,5) /
     &1.7365E+01,1.9999E+01,2.2921E+01,2.5901E+01,2.9166E+01/
      DATA (KB(JT,48,12),JT=1,5) /
     &1.7043E+01,1.9606E+01,2.2433E+01,2.5542E+01,2.8495E+01/
      DATA (KB(JT,49,12),JT=1,5) /
     &1.6912E+01,1.9487E+01,2.2139E+01,2.5022E+01,2.8110E+01/
      DATA (KB(JT,50,12),JT=1,5) /
     &1.6517E+01,1.8987E+01,2.1585E+01,2.4422E+01,2.7428E+01/
      DATA (KB(JT,51,12),JT=1,5) /
     &1.5891E+01,1.8550E+01,2.1056E+01,2.3767E+01,2.6461E+01/
      DATA (KB(JT,52,12),JT=1,5) /
     &1.5362E+01,1.8085E+01,2.0538E+01,2.3135E+01,2.5477E+01/
      DATA (KB(JT,53,12),JT=1,5) /
     &1.4979E+01,1.7596E+01,2.0169E+01,2.2304E+01,2.4351E+01/
      DATA (KB(JT,54,12),JT=1,5) /
     &1.4292E+01,1.6762E+01,1.9386E+01,2.1407E+01,2.3360E+01/
      DATA (KB(JT,55,12),JT=1,5) /
     &1.3424E+01,1.5675E+01,1.8295E+01,2.0550E+01,2.2398E+01/
      DATA (KB(JT,56,12),JT=1,5) /
     &1.2558E+01,1.4702E+01,1.7198E+01,1.9642E+01,2.1560E+01/
      DATA (KB(JT,57,12),JT=1,5) /
     &1.1789E+01,1.3891E+01,1.6101E+01,1.8574E+01,2.0696E+01/
      DATA (KB(JT,58,12),JT=1,5) /
     &1.0944E+01,1.2980E+01,1.5007E+01,1.7361E+01,1.9688E+01/
      DATA (KB(JT,59,12),JT=1,5) /
     &1.0805E+01,1.1957E+01,1.3692E+01,1.5846E+01,1.8110E+01/
      DATA (KB(JT,13,13),JT=1,5) /
     &1.5252E+02,1.5442E+02,1.5646E+02,1.5779E+02,1.5854E+02/
      DATA (KB(JT,14,13),JT=1,5) /
     &1.5029E+02,1.5315E+02,1.5552E+02,1.5711E+02,1.5813E+02/
      DATA (KB(JT,15,13),JT=1,5) /
     &1.4712E+02,1.5063E+02,1.5294E+02,1.5483E+02,1.5630E+02/
      DATA (KB(JT,16,13),JT=1,5) /
     &1.4282E+02,1.4612E+02,1.4898E+02,1.5141E+02,1.5352E+02/
      DATA (KB(JT,17,13),JT=1,5) /
     &1.3686E+02,1.4066E+02,1.4417E+02,1.4736E+02,1.5020E+02/
      DATA (KB(JT,18,13),JT=1,5) /
     &1.3031E+02,1.3486E+02,1.3910E+02,1.4308E+02,1.4669E+02/
      DATA (KB(JT,19,13),JT=1,5) /
     &1.2305E+02,1.2878E+02,1.3410E+02,1.3882E+02,1.4318E+02/
      DATA (KB(JT,20,13),JT=1,5) /
     &1.1539E+02,1.2206E+02,1.2838E+02,1.3444E+02,1.4010E+02/
      DATA (KB(JT,21,13),JT=1,5) /
     &1.0694E+02,1.1477E+02,1.2233E+02,1.2972E+02,1.3638E+02/
      DATA (KB(JT,22,13),JT=1,5) /
     &9.8072E+01,1.0767E+02,1.1673E+02,1.2508E+02,1.3303E+02/
      DATA (KB(JT,23,13),JT=1,5) /
     &8.9638E+01,1.0003E+02,1.1035E+02,1.2081E+02,1.2954E+02/
      DATA (KB(JT,24,13),JT=1,5) /
     &8.2450E+01,9.3359E+01,1.0421E+02,1.1509E+02,1.2544E+02/
      DATA (KB(JT,25,13),JT=1,5) /
     &7.6879E+01,8.7792E+01,9.9290E+01,1.1048E+02,1.2100E+02/
      DATA (KB(JT,26,13),JT=1,5) /
     &7.3470E+01,8.4233E+01,9.5225E+01,1.0688E+02,1.1752E+02/
      DATA (KB(JT,27,13),JT=1,5) /
     &7.1984E+01,8.2203E+01,9.3044E+01,1.0438E+02,1.1537E+02/
      DATA (KB(JT,28,13),JT=1,5) /
     &7.1683E+01,8.1066E+01,9.2180E+01,1.0291E+02,1.1419E+02/
      DATA (KB(JT,29,13),JT=1,5) /
     &7.3240E+01,8.2713E+01,9.3261E+01,1.0420E+02,1.1497E+02/
      DATA (KB(JT,30,13),JT=1,5) /
     &7.5656E+01,8.5740E+01,9.5155E+01,1.0607E+02,1.1653E+02/
      DATA (KB(JT,31,13),JT=1,5) /
     &7.9639E+01,8.9485E+01,9.9623E+01,1.0965E+02,1.1967E+02/
      DATA (KB(JT,32,13),JT=1,5) /
     &8.5052E+01,9.4635E+01,1.0433E+02,1.1321E+02,1.2287E+02/
      DATA (KB(JT,33,13),JT=1,5) /
     &9.0468E+01,1.0058E+02,1.0969E+02,1.1864E+02,1.2671E+02/
      DATA (KB(JT,34,13),JT=1,5) /
     &9.5615E+01,1.0581E+02,1.1476E+02,1.2258E+02,1.3070E+02/
      DATA (KB(JT,35,13),JT=1,5) /
     &9.9168E+01,1.0972E+02,1.1933E+02,1.2712E+02,1.3373E+02/
      DATA (KB(JT,36,13),JT=1,5) /
     &1.0086E+02,1.1164E+02,1.2168E+02,1.3014E+02,1.3667E+02/
      DATA (KB(JT,37,13),JT=1,5) /
     &1.0047E+02,1.1211E+02,1.2253E+02,1.3099E+02,1.3706E+02/
      DATA (KB(JT,38,13),JT=1,5) /
     &1.0049E+02,1.1250E+02,1.2313E+02,1.3108E+02,1.3732E+02/
      DATA (KB(JT,39,13),JT=1,5) /
     &1.0115E+02,1.1295E+02,1.2350E+02,1.3105E+02,1.3768E+02/
      DATA (KB(JT,40,13),JT=1,5) /
     &9.9765E+01,1.1141E+02,1.2196E+02,1.2992E+02,1.3631E+02/
      DATA (KB(JT,41,13),JT=1,5) /
     &9.8221E+01,1.1003E+02,1.2037E+02,1.2825E+02,1.3487E+02/
      DATA (KB(JT,42,13),JT=1,5) /
     &9.7048E+01,1.0845E+02,1.1823E+02,1.2668E+02,1.3349E+02/
      DATA (KB(JT,43,13),JT=1,5) /
     &9.4582E+01,1.0608E+02,1.1575E+02,1.2424E+02,1.3118E+02/
      DATA (KB(JT,44,13),JT=1,5) /
     &9.2428E+01,1.0325E+02,1.1298E+02,1.2159E+02,1.2888E+02/
      DATA (KB(JT,45,13),JT=1,5) /
     &9.0012E+01,1.0014E+02,1.0975E+02,1.1855E+02,1.2634E+02/
      DATA (KB(JT,46,13),JT=1,5) /
     &8.6912E+01,9.6825E+01,1.0618E+02,1.1559E+02,1.2362E+02/
      DATA (KB(JT,47,13),JT=1,5) /
     &8.3243E+01,9.2791E+01,1.0216E+02,1.1173E+02,1.2014E+02/
      DATA (KB(JT,48,13),JT=1,5) /
     &7.9277E+01,8.8596E+01,9.7998E+01,1.0757E+02,1.1661E+02/
      DATA (KB(JT,49,13),JT=1,5) /
     &7.5292E+01,8.4192E+01,9.3715E+01,1.0350E+02,1.1301E+02/
      DATA (KB(JT,50,13),JT=1,5) /
     &7.1230E+01,8.0247E+01,8.9698E+01,9.9552E+01,1.0903E+02/
      DATA (KB(JT,51,13),JT=1,5) /
     &6.7476E+01,7.6410E+01,8.5492E+01,9.5376E+01,1.0529E+02/
      DATA (KB(JT,52,13),JT=1,5) /
     &6.3984E+01,7.2323E+01,8.1379E+01,9.1669E+01,1.0161E+02/
      DATA (KB(JT,53,13),JT=1,5) /
     &6.0507E+01,6.8710E+01,7.7291E+01,8.7376E+01,9.7642E+01/
      DATA (KB(JT,54,13),JT=1,5) /
     &5.7140E+01,6.5369E+01,7.3636E+01,8.3548E+01,9.3708E+01/
      DATA (KB(JT,55,13),JT=1,5) /
     &5.3812E+01,6.2020E+01,7.0040E+01,7.9975E+01,8.9949E+01/
      DATA (KB(JT,56,13),JT=1,5) /
     &5.0680E+01,5.8469E+01,6.6837E+01,7.6130E+01,8.6168E+01/
      DATA (KB(JT,57,13),JT=1,5) /
     &4.7704E+01,5.5283E+01,6.3212E+01,7.2482E+01,8.2593E+01/
      DATA (KB(JT,58,13),JT=1,5) /
     &4.4831E+01,5.2037E+01,6.0082E+01,6.9516E+01,7.9098E+01/
      DATA (KB(JT,59,13),JT=1,5) /
     &4.1993E+01,5.0276E+01,5.8426E+01,6.7849E+01,7.7045E+01/
      DATA (KB(JT,13,14),JT=1,5) /
     &3.2192E+02,3.1800E+02,3.1299E+02,3.0833E+02,3.0378E+02/
      DATA (KB(JT,14,14),JT=1,5) /
     &3.3616E+02,3.3204E+02,3.2756E+02,3.2328E+02,3.1928E+02/
      DATA (KB(JT,15,14),JT=1,5) /
     &3.4851E+02,3.4454E+02,3.4128E+02,3.3796E+02,3.3453E+02/
      DATA (KB(JT,16,14),JT=1,5) /
     &3.5910E+02,3.5703E+02,3.5472E+02,3.5212E+02,3.4919E+02/
      DATA (KB(JT,17,14),JT=1,5) /
     &3.6944E+02,3.6874E+02,3.6739E+02,3.6541E+02,3.6285E+02/
      DATA (KB(JT,18,14),JT=1,5) /
     &3.7860E+02,3.7918E+02,3.7877E+02,3.7733E+02,3.7491E+02/
      DATA (KB(JT,19,14),JT=1,5) /
     &3.8633E+02,3.8813E+02,3.8858E+02,3.8768E+02,3.8541E+02/
      DATA (KB(JT,20,14),JT=1,5) /
     &3.9291E+02,3.9591E+02,3.9708E+02,3.9648E+02,3.9435E+02/
      DATA (KB(JT,21,14),JT=1,5) /
     &3.9871E+02,4.0263E+02,4.0428E+02,4.0401E+02,4.0199E+02/
      DATA (KB(JT,22,14),JT=1,5) /
     &4.0411E+02,4.0861E+02,4.1054E+02,4.1035E+02,4.0818E+02/
      DATA (KB(JT,23,14),JT=1,5) /
     &4.0907E+02,4.1390E+02,4.1591E+02,4.1564E+02,4.1319E+02/
      DATA (KB(JT,24,14),JT=1,5) /
     &4.1361E+02,4.1846E+02,4.2039E+02,4.1994E+02,4.1722E+02/
      DATA (KB(JT,25,14),JT=1,5) /
     &4.1735E+02,4.2250E+02,4.2427E+02,4.2345E+02,4.2038E+02/
      DATA (KB(JT,26,14),JT=1,5) /
     &4.2023E+02,4.2561E+02,4.2741E+02,4.2618E+02,4.2275E+02/
      DATA (KB(JT,27,14),JT=1,5) /
     &4.2191E+02,4.2794E+02,4.2966E+02,4.2833E+02,4.2447E+02/
      DATA (KB(JT,28,14),JT=1,5) /
     &4.2376E+02,4.3047E+02,4.3157E+02,4.2984E+02,4.2560E+02/
      DATA (KB(JT,29,14),JT=1,5) /
     &4.2494E+02,4.3173E+02,4.3312E+02,4.3087E+02,4.2623E+02/
      DATA (KB(JT,30,14),JT=1,5) /
     &4.2606E+02,4.3133E+02,4.3417E+02,4.3157E+02,4.2642E+02/
      DATA (KB(JT,31,14),JT=1,5) /
     &4.2650E+02,4.3107E+02,4.3305E+02,4.3172E+02,4.2612E+02/
      DATA (KB(JT,32,14),JT=1,5) /
     &4.2471E+02,4.2957E+02,4.3084E+02,4.2984E+02,4.2547E+02/
      DATA (KB(JT,33,14),JT=1,5) /
     &4.2258E+02,4.2628E+02,4.2740E+02,4.2572E+02,4.2270E+02/
      DATA (KB(JT,34,14),JT=1,5) /
     &4.1904E+02,4.2166E+02,4.2281E+02,4.2119E+02,4.1745E+02/
      DATA (KB(JT,35,14),JT=1,5) /
     &4.1547E+02,4.1665E+02,4.1587E+02,4.1430E+02,4.1140E+02/
      DATA (KB(JT,36,14),JT=1,5) /
     &4.1132E+02,4.1218E+02,4.1072E+02,4.0729E+02,4.0326E+02/
      DATA (KB(JT,37,14),JT=1,5) /
     &4.1025E+02,4.1006E+02,4.0857E+02,4.0548E+02,4.0090E+02/
      DATA (KB(JT,38,14),JT=1,5) /
     &4.0864E+02,4.0868E+02,4.0686E+02,4.0372E+02,3.9921E+02/
      DATA (KB(JT,39,14),JT=1,5) /
     &4.0644E+02,4.0717E+02,4.0510E+02,4.0183E+02,3.9677E+02/
      DATA (KB(JT,40,14),JT=1,5) /
     &4.0674E+02,4.0768E+02,4.0593E+02,4.0263E+02,3.9822E+02/
      DATA (KB(JT,41,14),JT=1,5) /
     &4.0619E+02,4.0758E+02,4.0668E+02,4.0411E+02,4.0014E+02/
      DATA (KB(JT,42,14),JT=1,5) /
     &4.0516E+02,4.0769E+02,4.0744E+02,4.0512E+02,4.0147E+02/
      DATA (KB(JT,43,14),JT=1,5) /
     &4.0427E+02,4.0784E+02,4.0882E+02,4.0743E+02,4.0425E+02/
      DATA (KB(JT,44,14),JT=1,5) /
     &4.0222E+02,4.0791E+02,4.0985E+02,4.0932E+02,4.0671E+02/
      DATA (KB(JT,45,14),JT=1,5) /
     &4.0049E+02,4.0766E+02,4.1090E+02,4.1120E+02,4.0941E+02/
      DATA (KB(JT,46,14),JT=1,5) /
     &3.9818E+02,4.0642E+02,4.1148E+02,4.1248E+02,4.1163E+02/
      DATA (KB(JT,47,14),JT=1,5) /
     &3.9380E+02,4.0435E+02,4.1138E+02,4.1374E+02,4.1407E+02/
      DATA (KB(JT,48,14),JT=1,5) /
     &3.8928E+02,4.0188E+02,4.1084E+02,4.1473E+02,4.1611E+02/
      DATA (KB(JT,49,14),JT=1,5) /
     &3.8359E+02,3.9878E+02,4.0957E+02,4.1507E+02,4.1710E+02/
      DATA (KB(JT,50,14),JT=1,5) /
     &3.7809E+02,3.9485E+02,4.0769E+02,4.1481E+02,4.1835E+02/
      DATA (KB(JT,51,14),JT=1,5) /
     &3.7168E+02,3.9024E+02,4.0538E+02,4.1442E+02,4.1907E+02/
      DATA (KB(JT,52,14),JT=1,5) /
     &3.6416E+02,3.8544E+02,4.0242E+02,4.1266E+02,4.1894E+02/
      DATA (KB(JT,53,14),JT=1,5) /
     &3.5526E+02,3.7935E+02,3.9858E+02,4.1114E+02,4.1870E+02/
      DATA (KB(JT,54,14),JT=1,5) /
     &3.4652E+02,3.7311E+02,3.9451E+02,4.0902E+02,4.1841E+02/
      DATA (KB(JT,55,14),JT=1,5) /
     &3.3749E+02,3.6678E+02,3.9033E+02,4.0637E+02,4.1776E+02/
      DATA (KB(JT,56,14),JT=1,5) /
     &3.2816E+02,3.6010E+02,3.8512E+02,4.0357E+02,4.1651E+02/
      DATA (KB(JT,57,14),JT=1,5) /
     &3.1792E+02,3.5199E+02,3.7987E+02,4.0009E+02,4.1450E+02/
      DATA (KB(JT,58,14),JT=1,5) /
     &3.0792E+02,3.4419E+02,3.7396E+02,3.9574E+02,4.1235E+02/
      DATA (KB(JT,59,14),JT=1,5) /
     &3.0450E+02,3.4137E+02,3.7215E+02,3.9490E+02,4.1294E+02/
      DATA (KB(JT,13,15),JT=1,5) /
     &5.8728E+02,5.6960E+02,5.5469E+02,5.4056E+02,5.2654E+02/
      DATA (KB(JT,14,15),JT=1,5) /
     &6.4066E+02,6.2243E+02,6.0593E+02,5.8946E+02,5.7294E+02/
      DATA (KB(JT,15,15),JT=1,5) /
     &6.9682E+02,6.7763E+02,6.5849E+02,6.3897E+02,6.1931E+02/
      DATA (KB(JT,16,15),JT=1,5) /
     &7.5471E+02,7.3292E+02,7.1026E+02,6.8716E+02,6.6402E+02/
      DATA (KB(JT,17,15),JT=1,5) /
     &8.1231E+02,7.8651E+02,7.5977E+02,7.3284E+02,7.0637E+02/
      DATA (KB(JT,18,15),JT=1,5) /
     &8.6774E+02,8.3725E+02,8.0641E+02,7.7597E+02,7.4653E+02/
      DATA (KB(JT,19,15),JT=1,5) /
     &9.1989E+02,8.8492E+02,8.5007E+02,8.1594E+02,7.8315E+02/
      DATA (KB(JT,20,15),JT=1,5) /
     &9.6712E+02,9.2752E+02,8.8885E+02,8.5117E+02,8.1509E+02/
      DATA (KB(JT,21,15),JT=1,5) /
     &1.0088E+03,9.6497E+02,9.2264E+02,8.8175E+02,8.4261E+02/
      DATA (KB(JT,22,15),JT=1,5) /
     &1.0418E+03,9.9399E+02,9.4844E+02,9.0461E+02,8.6306E+02/
      DATA (KB(JT,23,15),JT=1,5) /
     &1.0679E+03,1.0170E+03,9.6858E+02,9.2246E+02,8.7882E+02/
      DATA (KB(JT,24,15),JT=1,5) /
     &1.0878E+03,1.0343E+03,9.8346E+02,9.3530E+02,8.9008E+02/
      DATA (KB(JT,25,15),JT=1,5) /
     &1.1017E+03,1.0460E+03,9.9332E+02,9.4368E+02,8.9722E+02/
      DATA (KB(JT,26,15),JT=1,5) /
     &1.1097E+03,1.0523E+03,9.9837E+02,9.4761E+02,9.0024E+02/
      DATA (KB(JT,27,15),JT=1,5) /
     &1.1134E+03,1.0547E+03,9.9983E+02,9.4851E+02,9.0041E+02/
      DATA (KB(JT,28,15),JT=1,5) /
     &1.1133E+03,1.0539E+03,9.9848E+02,9.4685E+02,8.9828E+02/
      DATA (KB(JT,29,15),JT=1,5) /
     &1.1100E+03,1.0502E+03,9.9454E+02,9.4272E+02,8.9398E+02/
      DATA (KB(JT,30,15),JT=1,5) /
     &1.1040E+03,1.0443E+03,9.8865E+02,9.3687E+02,8.8821E+02/
      DATA (KB(JT,31,15),JT=1,5) /
     &1.0960E+03,1.0364E+03,9.8114E+02,9.2948E+02,8.8105E+02/
      DATA (KB(JT,32,15),JT=1,5) /
     &1.0862E+03,1.0270E+03,9.7213E+02,9.2091E+02,8.7298E+02/
      DATA (KB(JT,33,15),JT=1,5) /
     &1.0752E+03,1.0167E+03,9.6230E+02,9.1136E+02,8.6427E+02/
      DATA (KB(JT,34,15),JT=1,5) /
     &1.0653E+03,1.0075E+03,9.5353E+02,9.0314E+02,8.5654E+02/
      DATA (KB(JT,35,15),JT=1,5) /
     &1.0607E+03,1.0031E+03,9.4921E+02,8.9900E+02,8.5273E+02/
      DATA (KB(JT,36,15),JT=1,5) /
     &1.0620E+03,1.0042E+03,9.5018E+02,8.9983E+02,8.5343E+02/
      DATA (KB(JT,37,15),JT=1,5) /
     &1.0721E+03,1.0134E+03,9.5885E+02,9.0773E+02,8.6067E+02/
      DATA (KB(JT,38,15),JT=1,5) /
     &1.0824E+03,1.0229E+03,9.6769E+02,9.1592E+02,8.6811E+02/
      DATA (KB(JT,39,15),JT=1,5) /
     &1.0926E+03,1.0322E+03,9.7633E+02,9.2388E+02,8.7544E+02/
      DATA (KB(JT,40,15),JT=1,5) /
     &1.1061E+03,1.0474E+03,9.9047E+02,9.3721E+02,8.8756E+02/
      DATA (KB(JT,41,15),JT=1,5) /
     &1.1226E+03,1.0637E+03,1.0055E+03,9.5118E+02,9.0046E+02/
      DATA (KB(JT,42,15),JT=1,5) /
     &1.1394E+03,1.0801E+03,1.0206E+03,9.6537E+02,9.1362E+02/
      DATA (KB(JT,43,15),JT=1,5) /
     &1.1611E+03,1.1003E+03,1.0393E+03,9.8274E+02,9.2982E+02/
      DATA (KB(JT,44,15),JT=1,5) /
     &1.1862E+03,1.1226E+03,1.0598E+03,1.0018E+03,9.4776E+02/
      DATA (KB(JT,45,15),JT=1,5) /
     &1.2106E+03,1.1455E+03,1.0808E+03,1.0212E+03,9.6597E+02/
      DATA (KB(JT,46,15),JT=1,5) /
     &1.2373E+03,1.1703E+03,1.1039E+03,1.0424E+03,9.8575E+02/
      DATA (KB(JT,47,15),JT=1,5) /
     &1.2689E+03,1.1988E+03,1.1303E+03,1.0668E+03,1.0082E+03/
      DATA (KB(JT,48,15),JT=1,5) /
     &1.2999E+03,1.2281E+03,1.1575E+03,1.0920E+03,1.0314E+03/
      DATA (KB(JT,49,15),JT=1,5) /
     &1.3314E+03,1.2580E+03,1.1855E+03,1.1179E+03,1.0553E+03/
      DATA (KB(JT,50,15),JT=1,5) /
     &1.3612E+03,1.2867E+03,1.2124E+03,1.1430E+03,1.0785E+03/
      DATA (KB(JT,51,15),JT=1,5) /
     &1.3905E+03,1.3151E+03,1.2392E+03,1.1679E+03,1.1016E+03/
      DATA (KB(JT,52,15),JT=1,5) /
     &1.4202E+03,1.3438E+03,1.2667E+03,1.1935E+03,1.1254E+03/
      DATA (KB(JT,53,15),JT=1,5) /
     &1.4513E+03,1.3727E+03,1.2946E+03,1.2198E+03,1.1498E+03/
      DATA (KB(JT,54,15),JT=1,5) /
     &1.4800E+03,1.3995E+03,1.3206E+03,1.2445E+03,1.1728E+03/
      DATA (KB(JT,55,15),JT=1,5) /
     &1.5077E+03,1.4256E+03,1.3457E+03,1.2685E+03,1.1953E+03/
      DATA (KB(JT,56,15),JT=1,5) /
     &1.5346E+03,1.4518E+03,1.3711E+03,1.2930E+03,1.2182E+03/
      DATA (KB(JT,57,15),JT=1,5) /
     &1.5614E+03,1.4781E+03,1.3967E+03,1.3177E+03,1.2417E+03/
      DATA (KB(JT,58,15),JT=1,5) /
     &1.5868E+03,1.5034E+03,1.4212E+03,1.3415E+03,1.2645E+03/
      DATA (KB(JT,59,15),JT=1,5) /
     &1.5970E+03,1.5135E+03,1.4312E+03,1.3511E+03,1.2737E+03/
      DATA (KB(JT,13,16),JT=1,5) /
     &9.8102E+02,9.4348E+02,9.0592E+02,8.7102E+02,8.4003E+02/
      DATA (KB(JT,14,16),JT=1,5) /
     &1.1017E+03,1.0558E+03,1.0119E+03,9.7251E+02,9.3606E+02/
      DATA (KB(JT,15,16),JT=1,5) /
     &1.2294E+03,1.1733E+03,1.1221E+03,1.0765E+03,1.0331E+03/
      DATA (KB(JT,16,16),JT=1,5) /
     &1.3605E+03,1.2927E+03,1.2335E+03,1.1795E+03,1.1282E+03/
      DATA (KB(JT,17,16),JT=1,5) /
     &1.4907E+03,1.4118E+03,1.3426E+03,1.2786E+03,1.2181E+03/
      DATA (KB(JT,18,16),JT=1,5) /
     &1.6164E+03,1.5261E+03,1.4460E+03,1.3720E+03,1.3020E+03/
      DATA (KB(JT,19,16),JT=1,5) /
     &1.7353E+03,1.6329E+03,1.5412E+03,1.4568E+03,1.3777E+03/
      DATA (KB(JT,20,16),JT=1,5) /
     &1.8432E+03,1.7287E+03,1.6256E+03,1.5311E+03,1.4432E+03/
      DATA (KB(JT,21,16),JT=1,5) /
     &1.9386E+03,1.8123E+03,1.6986E+03,1.5948E+03,1.4993E+03/
      DATA (KB(JT,22,16),JT=1,5) /
     &2.0105E+03,1.8749E+03,1.7520E+03,1.6411E+03,1.5395E+03/
      DATA (KB(JT,23,16),JT=1,5) /
     &2.0682E+03,1.9239E+03,1.7938E+03,1.6758E+03,1.5698E+03/
      DATA (KB(JT,24,16),JT=1,5) /
     &2.1097E+03,1.9590E+03,1.8231E+03,1.7013E+03,1.5912E+03/
      DATA (KB(JT,25,16),JT=1,5) /
     &2.1366E+03,1.9806E+03,1.8412E+03,1.7160E+03,1.6035E+03/
      DATA (KB(JT,26,16),JT=1,5) /
     &2.1483E+03,1.9894E+03,1.8477E+03,1.7210E+03,1.6077E+03/
      DATA (KB(JT,27,16),JT=1,5) /
     &2.1499E+03,1.9893E+03,1.8466E+03,1.7191E+03,1.6062E+03/
      DATA (KB(JT,28,16),JT=1,5) /
     &2.1427E+03,1.9818E+03,1.8393E+03,1.7119E+03,1.6006E+03/
      DATA (KB(JT,29,16),JT=1,5) /
     &2.1277E+03,1.9675E+03,1.8260E+03,1.6998E+03,1.5909E+03/
      DATA (KB(JT,30,16),JT=1,5) /
     &2.1075E+03,1.9489E+03,1.8089E+03,1.6842E+03,1.5788E+03/
      DATA (KB(JT,31,16),JT=1,5) /
     &2.0822E+03,1.9262E+03,1.7881E+03,1.6663E+03,1.5639E+03/
      DATA (KB(JT,32,16),JT=1,5) /
     &2.0533E+03,1.9005E+03,1.7649E+03,1.6467E+03,1.5469E+03/
      DATA (KB(JT,33,16),JT=1,5) /
     &2.0222E+03,1.8726E+03,1.7400E+03,1.6262E+03,1.5282E+03/
      DATA (KB(JT,34,16),JT=1,5) /
     &1.9951E+03,1.8486E+03,1.7187E+03,1.6087E+03,1.5123E+03/
      DATA (KB(JT,35,16),JT=1,5) /
     &1.9819E+03,1.8366E+03,1.7081E+03,1.6001E+03,1.5043E+03/
      DATA (KB(JT,36,16),JT=1,5) /
     &1.9843E+03,1.8387E+03,1.7099E+03,1.6017E+03,1.5056E+03/
      DATA (KB(JT,37,16),JT=1,5) /
     &2.0096E+03,1.8607E+03,1.7293E+03,1.6180E+03,1.5204E+03/
      DATA (KB(JT,38,16),JT=1,5) /
     &2.0360E+03,1.8842E+03,1.7495E+03,1.6347E+03,1.5358E+03/
      DATA (KB(JT,39,16),JT=1,5) /
     &2.0619E+03,1.9070E+03,1.7697E+03,1.6516E+03,1.5509E+03/
      DATA (KB(JT,40,16),JT=1,5) /
     &2.1060E+03,1.9450E+03,1.8033E+03,1.6798E+03,1.5761E+03/
      DATA (KB(JT,41,16),JT=1,5) /
     &2.1534E+03,1.9860E+03,1.8395E+03,1.7107E+03,1.6027E+03/
      DATA (KB(JT,42,16),JT=1,5) /
     &2.2020E+03,2.0285E+03,1.8771E+03,1.7432E+03,1.6297E+03/
      DATA (KB(JT,43,16),JT=1,5) /
     &2.2623E+03,2.0820E+03,1.9234E+03,1.7841E+03,1.6639E+03/
      DATA (KB(JT,44,16),JT=1,5) /
     &2.3303E+03,2.1416E+03,1.9758E+03,1.8302E+03,1.7027E+03/
      DATA (KB(JT,45,16),JT=1,5) /
     &2.4015E+03,2.2036E+03,2.0305E+03,1.8787E+03,1.7442E+03/
      DATA (KB(JT,46,16),JT=1,5) /
     &2.4806E+03,2.2729E+03,2.0910E+03,1.9319E+03,1.7910E+03/
      DATA (KB(JT,47,16),JT=1,5) /
     &2.5738E+03,2.3537E+03,2.1621E+03,1.9939E+03,1.8463E+03/
      DATA (KB(JT,48,16),JT=1,5) /
     &2.6744E+03,2.4391E+03,2.2368E+03,2.0594E+03,1.9042E+03/
      DATA (KB(JT,49,16),JT=1,5) /
     &2.7827E+03,2.5294E+03,2.3154E+03,2.1283E+03,1.9646E+03/
      DATA (KB(JT,50,16),JT=1,5) /
     &2.8923E+03,2.6199E+03,2.3931E+03,2.1963E+03,2.0240E+03/
      DATA (KB(JT,51,16),JT=1,5) /
     &3.0068E+03,2.7139E+03,2.4725E+03,2.2657E+03,2.0848E+03/
      DATA (KB(JT,52,16),JT=1,5) /
     &3.1290E+03,2.8143E+03,2.5557E+03,2.3381E+03,2.1483E+03/
      DATA (KB(JT,53,16),JT=1,5) /
     &3.2592E+03,2.9226E+03,2.6451E+03,2.4144E+03,2.2150E+03/
      DATA (KB(JT,54,16),JT=1,5) /
     &3.3865E+03,3.0292E+03,2.7322E+03,2.4877E+03,2.2788E+03/
      DATA (KB(JT,55,16),JT=1,5) /
     &3.5154E+03,3.1374E+03,2.8210E+03,2.5614E+03,2.3429E+03/
      DATA (KB(JT,56,16),JT=1,5) /
     &3.6521E+03,3.2511E+03,2.9159E+03,2.6395E+03,2.4095E+03/
      DATA (KB(JT,57,16),JT=1,5) /
     &3.7974E+03,3.3719E+03,3.0171E+03,2.7223E+03,2.4795E+03/
      DATA (KB(JT,58,16),JT=1,5) /
     &3.9425E+03,3.4927E+03,3.1186E+03,2.8056E+03,2.5484E+03/
      DATA (KB(JT,59,16),JT=1,5) /
     &4.0032E+03,3.5431E+03,3.1604E+03,2.8404E+03,2.5772E+03/

C     The array FORREF contains the coefficient of the water vapor
C     foreign-continuum (including the energy term).  The first 
C     index refers to reference temperature (296,260,224,260) and 
C     pressure (970,475,219,3 mbar) levels.  The second index 
C     runs over the g-channel (1 to 16).

      DATA (FORREF(1,IG),IG=1,16) /
     &5.1629e-06,7.7578e-06,1.9043e-05,1.4802e-04,2.2980e-04,2.8057e-04,
     &3.2824e-04,3.4913e-04,3.6515e-04,3.8271e-04,3.7499e-04,3.6966e-04,
     &3.7424e-04,3.8884e-04,3.7117e-04,4.3710e-04/
      DATA (FORREF(2,IG),IG=1,16) /
     &5.0804e-06,1.3466e-05,7.2606e-05,1.6940e-04,2.1022e-04,2.5900e-04,
     &2.9106e-04,3.2261e-04,3.2066e-04,3.5421e-04,3.7128e-04,3.8144e-04,
     &3.7854e-04,3.8347e-04,3.8921e-04,3.7339e-04/
      DATA (FORREF(3,IG),IG=1,16) /
     &5.4797e-05,1.0026e-04,1.2422e-04,1.6386e-04,1.8378e-04,1.9616e-04,
     &2.0711e-04,2.2492e-04,2.5240e-04,2.6187e-04,2.6058e-04,2.4892e-04,
     &2.6526e-04,3.2105e-04,3.6903e-04,3.7213e-04/
      DATA (FORREF(4,IG),IG=1,16) /
     &4.2782e-05,1.4775e-04,1.4588e-04,1.6964e-04,1.6667e-04,1.7192e-04,
     &1.9057e-04,2.0180e-04,2.1177e-04,2.2326e-04,2.3801e-04,2.9308e-04,
     &3.1130e-04,3.1829e-04,3.5035e-04,3.7782e-04/

C     The array SELFREF contains the coefficient of the water vapor
C     self-continuum (including the energy term).  The first index
C     refers to temperature in 7.2 degree increments.  For instance,
C     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
C     etc.  The second index runs over the g-channel (1 to 16).

      DATA (SELFREF(JT, 1),JT=1,10)  /
     & 1.27793e-03, 1.05944e-03, 8.78300e-04, 7.28133e-04, 6.03641e-04,
     & 5.00434e-04, 4.14873e-04, 3.43940e-04, 2.85135e-04, 2.36384e-04/
      DATA (SELFREF(JT, 2),JT=1,10)  /
     & 1.42785e-03, 1.17602e-03, 9.68600e-04, 7.97765e-04, 6.57060e-04,
     & 5.41172e-04, 4.45724e-04, 3.67110e-04, 3.02361e-04, 2.49033e-04/
      DATA (SELFREF(JT, 3),JT=1,10)  /
     & 2.94095e-03, 2.27102e-03, 1.75370e-03, 1.35422e-03, 1.04574e-03,
     & 8.07525e-04, 6.23577e-04, 4.81530e-04, 3.71841e-04, 2.87138e-04/
      DATA (SELFREF(JT, 4),JT=1,10)  /
     & 3.94894e-03, 3.48184e-03, 3.07000e-03, 2.70687e-03, 2.38669e-03,
     & 2.10439e-03, 1.85547e-03, 1.63600e-03, 1.44249e-03, 1.27187e-03/
      DATA (SELFREF(JT, 5),JT=1,10)  /
     & 4.19971e-03, 3.86333e-03, 3.55390e-03, 3.26925e-03, 3.00740e-03,
     & 2.76652e-03, 2.54494e-03, 2.34110e-03, 2.15359e-03, 1.98110e-03/
      DATA (SELFREF(JT, 6),JT=1,10)  /
     & 4.95922e-03, 4.57134e-03, 4.21380e-03, 3.88422e-03, 3.58042e-03,
     & 3.30038e-03, 3.04225e-03, 2.80430e-03, 2.58496e-03, 2.38278e-03/
      DATA (SELFREF(JT, 7),JT=1,10)  /
     & 5.27379e-03, 4.91005e-03, 4.57140e-03, 4.25611e-03, 3.96256e-03,
     & 3.68925e-03, 3.43480e-03, 3.19790e-03, 2.97734e-03, 2.77199e-03/
      DATA (SELFREF(JT, 8),JT=1,10)  /
     & 5.75341e-03, 5.31533e-03, 4.91060e-03, 4.53669e-03, 4.19126e-03,
     & 3.87212e-03, 3.57729e-03, 3.30490e-03, 3.05325e-03, 2.82077e-03/
      DATA (SELFREF(JT, 9),JT=1,10)  /
     & 5.49849e-03, 5.14295e-03, 4.81040e-03, 4.49935e-03, 4.20842e-03,
     & 3.93629e-03, 3.68177e-03, 3.44370e-03, 3.22102e-03, 3.01275e-03/
      DATA (SELFREF(JT,10),JT=1,10)  /
     & 6.04962e-03, 5.60945e-03, 5.20130e-03, 4.82285e-03, 4.47194e-03,
     & 4.14656e-03, 3.84485e-03, 3.56510e-03, 3.30570e-03, 3.06518e-03/
      DATA (SELFREF(JT,11),JT=1,10)  /
     & 6.40108e-03, 5.87551e-03, 5.39310e-03, 4.95029e-03, 4.54385e-03,
     & 4.17077e-03, 3.82833e-03, 3.51400e-03, 3.22548e-03, 2.96065e-03/
      DATA (SELFREF(JT,12),JT=1,10)  /
     & 6.77938e-03, 6.15713e-03, 5.59200e-03, 5.07874e-03, 4.61259e-03,
     & 4.18922e-03, 3.80472e-03, 3.45550e-03, 3.13834e-03, 2.85029e-03/
      DATA (SELFREF(JT,13),JT=1,10)  /
     & 6.90020e-03, 6.26766e-03, 5.69310e-03, 5.17121e-03, 4.69717e-03,
     & 4.26658e-03, 3.87546e-03, 3.52020e-03, 3.19750e-03, 2.90439e-03/
      DATA (SELFREF(JT,14),JT=1,10)  /
     & 6.92759e-03, 6.32882e-03, 5.78180e-03, 5.28206e-03, 4.82552e-03,
     & 4.40843e-03, 4.02740e-03, 3.67930e-03, 3.36129e-03, 3.07076e-03/
      DATA (SELFREF(JT,15),JT=1,10)  /
     & 7.54539e-03, 6.81161e-03, 6.14920e-03, 5.55120e-03, 5.01136e-03,
     & 4.52402e-03, 4.08407e-03, 3.68690e-03, 3.32836e-03, 3.00468e-03/
      DATA (SELFREF(JT,16),JT=1,10)  /
     & 7.62039e-03, 7.10834e-03, 6.63070e-03, 6.18515e-03, 5.76955e-03,
     & 5.38186e-03, 5.02023e-03, 4.68290e-03, 4.36823e-03, 4.07471e-03/

