C     path:      $Source: /storm/rc1/cvsroot/rc/rrtm_lw/src/setcoef.f,v $
C     author:    $Author: jdelamer $
C     revision:  $Revision: 3.1 $
C     created:   $Date: 2002/08/15 18:33:27 $
      SUBROUTINE SETCOEF

C     Purpose:  For a given atmosphere, calculate the indices and
C     fractions related to the pressure and temperature interpolations.
C     Also calculate the values of the integrated Planck functions 
C     for each band at the level and layer temperatures.

      PARAMETER (MXLAY = 203)
      PARAMETER (NBANDS = 16)
      PARAMETER (NBANDSLG = 16)
      PARAMETER (MG =16)

C  Input      
      COMMON /CONTROL/  NUMANGS, IOUT, ISTART, IEND
      COMMON /PROFILE/  NLAYERS,PAVEL(MXLAY),TAVEL(MXLAY),
     &                  PZ(0:MXLAY),TZ(0:MXLAY)
      COMMON /SURFACE/  TBOUND,IREFLECT,SEMISS(NBANDS)
      COMMON /SPECIES/  COLDRY(MXLAY),WKL(35,MXLAY),WBROAD(MXLAY),
     &                  COLMOL(MXLAY),NMOL

C  Output
      COMMON /PROFDATA/ LAYTROP,                                   
     &                  COLH2O(MXLAY),COLCO2(MXLAY),COLO3(MXLAY),  
     &                  COLN2O(MXLAY),COLCO(MXLAY),COLCH4(MXLAY),  
     &                  COLO2(MXLAY),COLBRD(MXLAY)
      COMMON /INTFAC/   FAC00(MXLAY),FAC01(MXLAY),
     &                  FAC10(MXLAY),FAC11(MXLAY)
      COMMON /INTIND/   JP(MXLAY),JT(MXLAY),JT1(MXLAY)
      COMMON /REFRAT_ETA/ RAT_H2OCO2(MXLAY),RAT_H2OCO2_1(MXLAY),
     &                  RAT_H2OO3(MXLAY),RAT_H2OO3_1(MXLAY),
     &                  RAT_H2ON2O(MXLAY),RAT_H2ON2O_1(MXLAY),
     &                  RAT_H2OCH4(MXLAY),RAT_H2OCH4_1(MXLAY),
     &                  RAT_N2OCO2(MXLAY),RAT_N2OCO2_1(MXLAY),
     &                  RAT_O3CO2(MXLAY),RAT_O3CO2_1(MXLAY)

      COMMON /SELF/     SELFFAC, SELFFRAC, INDSELF
      COMMON /FOREIGN/  FORFAC(MXLAY), FORFRAC(MXLAY), INDFOR(MXLAY)
      COMMON /MINOR/    MINORFRAC(MXLAY), INDMINOR(MXLAY), 
     &                  SCALEMINOR(MXLAY),SCALEMINORN2(MXLAY)
      COMMON /PLNKDAT/  PLANKLAY(MXLAY,NBANDS),
     &                  PLANKLEV(0:MXLAY,NBANDS),PLANKBND(NBANDS)
      COMMON /MLS_REF/  PREF,PREFLOG,TREF,CHI_MLS

C  Internal
      COMMON /AVGPLNK/  TOTPLNK(181,NBANDSLG), TOTPLK16(181)
C  --------

      COMMON /CVRSET/    HVRSET

      CHARACTER*15       HVRSET

      DIMENSION SELFFAC(MXLAY),SELFFRAC(MXLAY),INDSELF(MXLAY)
      DIMENSION PREF(59),PREFLOG(59),TREF(59),CHI_MLS(7,59)

      REAL MINORFRAC


C ****************** START OF EXECUTABLE CODE ***************************


      HVRSET = '$Revision: 3.1 $'

      STPFAC = 296./1013.

      INDBOUND = TBOUND - 159.
      IF (INDBOUND .LT. 1) THEN
         INDBOUND = 1
      ELSEIF (INDBOUND .GT. 180) THEN
         INDBOUND = 180
      ENDIF
      TBNDFRAC = TBOUND - 159. - FLOAT(INDBOUND)
      INDLEV0 = TZ(0) - 159.
      IF (INDLEV0 .LT. 1) THEN
         INDLEV0 = 1
      ELSEIF (INDLEV0 .GT. 180) THEN
         INDLEV0 = 180
      ENDIF
      T0FRAC = TZ(0) - 159. - FLOAT(INDLEV0)
      LAYTROP = 0
      DO 7000 LAY = 1, NLAYERS
C        Calculate the integrated Planck functions for each band at the
C        surface, level, and layer temperatures.
         INDLAY = TAVEL(LAY) - 159.
         IF (INDLAY .LT. 1) THEN
            INDLAY = 1
         ELSEIF (INDLAY .GT. 180) THEN
            INDLAY = 180
         ENDIF
         TLAYFRAC = TAVEL(LAY) - 159. - FLOAT(INDLAY)
         INDLEV = TZ(LAY) - 159.
         IF (INDLEV .LT. 1) THEN
            INDLEV = 1
         ELSEIF (INDLEV .GT. 180) THEN
            INDLEV = 180
         ENDIF
         TLEVFRAC = TZ(LAY) - 159. - FLOAT(INDLEV)
         DO 3500 IBAND = 1, 15
            IF (LAY.EQ.1) THEN
               DBDTLEV = TOTPLNK(INDBOUND+1,IBAND)
     &              - TOTPLNK(INDBOUND,IBAND)
               PLANKBND(IBAND) = SEMISS(IBAND) * 
     &              (TOTPLNK(INDBOUND,IBAND) + TBNDFRAC * DBDTLEV)
               DBDTLEV = TOTPLNK(INDLEV0+1,IBAND)-TOTPLNK(INDLEV0,IBAND)
               PLANKLEV(0,IBAND) = TOTPLNK(INDLEV0,IBAND) + 
     &              T0FRAC * DBDTLEV
            ENDIF
            DBDTLEV = TOTPLNK(INDLEV+1,IBAND) - TOTPLNK(INDLEV,IBAND)
            DBDTLAY = TOTPLNK(INDLAY+1,IBAND) - TOTPLNK(INDLAY,IBAND)
            PLANKLAY(LAY,IBAND) = TOTPLNK(INDLAY,IBAND) + 
     &           TLAYFRAC * DBDTLAY
            PLANKLEV(LAY,IBAND) = TOTPLNK(INDLEV,IBAND) + 
     &           TLEVFRAC * DBDTLEV
 3500    CONTINUE

C        For band 16, if radiative transfer will be performed on just
C        this band, use integrated Planck values up to 3250 cm-1.  
C        If radiative transfer will be performed across all 16 bands,
C        then include in the integrated Planck values for this band
C        contributions from 2600 cm-1 to infinity.
         IF (ISTART .EQ. 16) THEN
            IF (LAY.EQ.1) THEN
               DBDTLEV = TOTPLK16(INDBOUND+1) - TOTPLK16(INDBOUND)
               PLANKBND(IBAND) = SEMISS(IBAND) * 
     &              (TOTPLK16(INDBOUND) + TBNDFRAC * DBDTLEV)
               DBDTLEV = TOTPLNK(INDLEV0+1,IBAND)-TOTPLNK(INDLEV0,IBAND)
               PLANKLEV(0,IBAND) = TOTPLK16(INDLEV0) + 
     &              T0FRAC * DBDTLEV
            ENDIF
            DBDTLEV = TOTPLK16(INDLEV+1) - TOTPLK16(INDLEV)
            DBDTLAY = TOTPLK16(INDLAY+1) - TOTPLK16(INDLAY)
            PLANKLAY(LAY,IBAND) = TOTPLK16(INDLAY) + 
     &           TLAYFRAC * DBDTLAY
            PLANKLEV(LAY,IBAND) = TOTPLK16(INDLEV) + 
     &           TLEVFRAC * DBDTLEV
         ELSE
            IF (LAY.EQ.1) THEN
               DBDTLEV = TOTPLNK(INDBOUND+1,IBAND)
     &              - TOTPLNK(INDBOUND,IBAND)
               PLANKBND(IBAND) = SEMISS(IBAND) * 
     &              (TOTPLNK(INDBOUND,IBAND) + TBNDFRAC * DBDTLEV)
               DBDTLEV = TOTPLNK(INDLEV0+1,IBAND)-TOTPLNK(INDLEV0,IBAND)
               PLANKLEV(0,IBAND) = TOTPLNK(INDLEV0,IBAND) + 
     &              T0FRAC * DBDTLEV
            ENDIF
            DBDTLEV = TOTPLNK(INDLEV+1,IBAND) - TOTPLNK(INDLEV,IBAND)
            DBDTLAY = TOTPLNK(INDLAY+1,IBAND) - TOTPLNK(INDLAY,IBAND)
            PLANKLAY(LAY,IBAND) = TOTPLNK(INDLAY,IBAND) + 
     &           TLAYFRAC * DBDTLAY
            PLANKLEV(LAY,IBAND) = TOTPLNK(INDLEV,IBAND) + 
     &           TLEVFRAC * DBDTLEV
         ENDIF

C        Find the two reference pressures on either side of the
C        layer pressure.  Store them in JP and JP1.  Store in FP the
C        fraction of the difference (in ln(pressure)) between these
C        two values that the layer pressure lies.
         PLOG = ALOG(PAVEL(LAY))
         JP(LAY) = INT(36. - 5*(PLOG+0.04))
         IF (JP(LAY) .LT. 1) THEN
            JP(LAY) = 1
         ELSEIF (JP(LAY) .GT. 58) THEN
            JP(LAY) = 58
         ENDIF
         JP1 = JP(LAY) + 1
         FP = 5. *(PREFLOG(JP(LAY)) - PLOG)

C        Determine, for each reference pressure (JP and JP1), which
C        reference temperature (these are different for each  
C        reference pressure) is nearest the layer temperature but does
C        not exceed it.  Store these indices in JT and JT1, resp.
C        Store in FT (resp. FT1) the fraction of the way between JT
C        (JT1) and the next highest reference temperature that the 
C        layer temperature falls.
         JT(LAY) = INT(3. + (TAVEL(LAY)-TREF(JP(LAY)))/15.)
         IF (JT(LAY) .LT. 1) THEN
            JT(LAY) = 1
         ELSEIF (JT(LAY) .GT. 4) THEN
            JT(LAY) = 4
         ENDIF
         FT = ((TAVEL(LAY)-TREF(JP(LAY)))/15.) - FLOAT(JT(LAY)-3)
         JT1(LAY) = INT(3. + (TAVEL(LAY)-TREF(JP1))/15.)
         IF (JT1(LAY) .LT. 1) THEN
            JT1(LAY) = 1
         ELSEIF (JT1(LAY) .GT. 4) THEN
            JT1(LAY) = 4
         ENDIF
         FT1 = ((TAVEL(LAY)-TREF(JP1))/15.) - FLOAT(JT1(LAY)-3)
         WATER = WKL(1,LAY)/COLDRY(LAY)
         SCALEFAC = PAVEL(LAY) * STPFAC / TAVEL(LAY)

C        If the pressure is less than ~100mb, perform a different
C        set of species interpolations.
         IF (PLOG .LE. 4.56) GO TO 5300
         LAYTROP =  LAYTROP + 1
C
         FORFAC(LAY) = SCALEFAC / (1.+WATER)
         FACTOR = (332.0-TAVEL(LAY))/36.0
         INDFOR(LAY) = MIN(2, MAX(1, INT(FACTOR)))
         FORFRAC(LAY) = FACTOR - FLOAT(INDFOR(LAY))
C        Set up factors needed to separately include the water vapor
C        self-continuum in the calculation of absorption coefficient.

         SELFFAC(LAY) = WATER * FORFAC(LAY)
         FACTOR = (TAVEL(LAY)-188.0)/7.2
         INDSELF(LAY) = MIN(9, MAX(1, INT(FACTOR)-7))
         SELFFRAC(LAY) = FACTOR - FLOAT(INDSELF(LAY) + 7)

C        Set up factors needed to separately include the minor gases
C        in the calculation of absorption coefficient
         SCALEMINOR(LAY) = PAVEL(LAY)/TAVEL(LAY)
         SCALEMINORN2(LAY) = (PAVEL(LAY)/TAVEL(LAY))
     &      *(WBROAD(LAY)/(COLDRY(LAY)+WKL(1,LAY)))
         FACTOR = (TAVEL(LAY)-180.8)/7.2
         INDMINOR(LAY) = MIN(18, MAX(1, INT(FACTOR)))
         MINORFRAC(LAY) = FACTOR - FLOAT(INDMINOR(LAY))

C        Setup reference ratio to be used in calculation of binary
C        species parameter in lower atmosphere.
         
         RAT_H2OCO2(LAY)=CHI_MLS(1,JP(LAY))/CHI_MLS(2,JP(LAY))
         RAT_H2OCO2_1(LAY)=CHI_MLS(1,JP(LAY)+1)/CHI_MLS(2,JP(LAY)+1)

         RAT_H2OO3(LAY)=CHI_MLS(1,JP(LAY))/CHI_MLS(3,JP(LAY))
         RAT_H2OO3_1(LAY)=CHI_MLS(1,JP(LAY)+1)/CHI_MLS(3,JP(LAY)+1)

         RAT_H2ON2O(LAY)=CHI_MLS(1,JP(LAY))/CHI_MLS(4,JP(LAY))
         RAT_H2ON2O_1(LAY)=CHI_MLS(1,JP(LAY)+1)/CHI_MLS(4,JP(LAY)+1)

         RAT_H2OCH4(LAY)=CHI_MLS(1,JP(LAY))/CHI_MLS(6,JP(LAY))
         RAT_H2OCH4_1(LAY)=CHI_MLS(1,JP(LAY)+1)/CHI_MLS(6,JP(LAY)+1)

         RAT_N2OCO2(LAY)=CHI_MLS(4,JP(LAY))/CHI_MLS(2,JP(LAY))
         RAT_N2OCO2_1(LAY)=CHI_MLS(4,JP(LAY)+1)/CHI_MLS(2,JP(LAY)+1)

C        Calculate needed column amounts.
         COLH2O(LAY) = 1.E-20 * WKL(1,LAY)
         COLCO2(LAY) = 1.E-20 * WKL(2,LAY)
         COLO3(LAY) = 1.E-20 * WKL(3,LAY)
         COLN2O(LAY) = 1.E-20 * WKL(4,LAY)
         COLCO(LAY) = 1.E-20 * WKL(5,LAY)
         COLCH4(LAY) = 1.E-20 * WKL(6,LAY)
         COLO2(LAY) = 1.E-20 * WKL(7,LAY)
         IF (COLCO2(LAY) .EQ. 0.) COLCO2(LAY) = 1.E-32 * COLDRY(LAY)
         IF (COLO3(LAY) .EQ. 0.) COLO3(LAY) = 1.E-32 * COLDRY(LAY)
         IF (COLN2O(LAY) .EQ. 0.) COLN2O(LAY) = 1.E-32 * COLDRY(LAY)
         IF (COLCO(LAY) .EQ. 0.) COLCO(LAY) = 1.E-32 * COLDRY(LAY)
         IF (COLCH4(LAY) .EQ. 0.) COLCH4(LAY) = 1.E-32 * COLDRY(LAY)
         COLBRD(LAY) = 1.E-20 * WBROAD(LAY)
         GO TO 5400

C        Above LAYTROP.
 5300    CONTINUE

         FORFAC(LAY) = SCALEFAC / (1.+WATER)
         FACTOR = (TAVEL(LAY)-188.0)/36.0
         INDFOR(LAY) = 3
         FORFRAC(LAY) = FACTOR - 1.0

C        Set up factors needed to separately include the minor gases
C        in the calculation of absorption coefficient
         SCALEMINOR(LAY) = PAVEL(LAY)/TAVEL(LAY)         
         SCALEMINORN2(LAY) = (PAVEL(LAY)/TAVEL(LAY))
     &        * (WBROAD(LAY)/(COLDRY(LAY)+WKL(1,LAY)))
         FACTOR = (TAVEL(LAY)-180.8)/7.2
         INDMINOR(LAY) = MIN(18, MAX(1, INT(FACTOR)))
         MINORFRAC(LAY) = FACTOR - FLOAT(INDMINOR(LAY))

C        Setup reference ratio to be used in calculation of binary
C        species parameter in upper atmosphere.

         RAT_H2OCO2(LAY)=CHI_MLS(1,JP(LAY))/CHI_MLS(2,JP(LAY))
         RAT_H2OCO2_1(LAY)=CHI_MLS(1,JP(LAY)+1)/CHI_MLS(2,JP(LAY)+1)         

         RAT_O3CO2(LAY)=CHI_MLS(3,JP(LAY))/CHI_MLS(2,JP(LAY))
         RAT_O3CO2_1(LAY)=CHI_MLS(3,JP(LAY)+1)/CHI_MLS(2,JP(LAY)+1)         

C        Calculate needed column amounts.
         COLH2O(LAY) = 1.E-20 * WKL(1,LAY)
         COLCO2(LAY) = 1.E-20 * WKL(2,LAY)
         COLO3(LAY) = 1.E-20 * WKL(3,LAY)
         COLN2O(LAY) = 1.E-20 * WKL(4,LAY)
         COLCO(LAY) = 1.E-20 * WKL(5,LAY)
         COLCH4(LAY) = 1.E-20 * WKL(6,LAY)
         COLO2(LAY) = 1.E-20 * WKL(7,LAY)
         IF (COLCO2(LAY) .EQ. 0.) COLCO2(LAY) = 1.E-32 * COLDRY(LAY)
         IF (COLO3(LAY) .EQ. 0.) COLO3(LAY) = 1.E-32 * COLDRY(LAY)
         IF (COLN2O(LAY) .EQ. 0.) COLN2O(LAY) = 1.E-32 * COLDRY(LAY)
         IF (COLCO(LAY)  .EQ. 0.) COLCO(LAY) = 1.E-32 * COLDRY(LAY)
         IF (COLCH4(LAY) .EQ. 0.) COLCH4(LAY) = 1.E-32 * COLDRY(LAY)
         COLBRD(LAY) = 1.E-20 * WBROAD(LAY)
 5400    CONTINUE

C        We have now isolated the layer ln pressure and temperature,
C        between two reference pressures and two reference temperatures 
C        (for each reference pressure).  We multiply the pressure 
C        fraction FP with the appropriate temperature fractions to get 
C        the factors that will be needed for the interpolation that yields
C        the optical depths (performed in routines TAUGBn for band n).`

         COMPFP = 1. - FP
         FAC10(LAY) = COMPFP * FT
         FAC00(LAY) = COMPFP * (1. - FT)
         FAC11(LAY) = FP * FT1
         FAC01(LAY) = FP * (1. - FT1)

C        Rescale selffac and forfac for use in taumol
         SELFFAC(LAY) = COLH2O(LAY)*SELFFAC(LAY)
         FORFAC(LAY) = COLH2O(LAY)*FORFAC(LAY)
 7000 CONTINUE

      RETURN
      END


      BLOCK DATA BLOCK_ATMREF
      DIMENSION PREF(59),PREFLOG(59),TREF(59),CHI_MLS(7,59)
      COMMON /MLS_REF/  PREF,PREFLOG,TREF,CHI_MLS
C     These pressures are chosen such that the ln of the first pressure
C     has only a few non-zero digits (i.e. ln(PREF(1)) = 6.96000) and
C     each subsequent ln(pressure) differs from the previous one by 0.2.
      DATA PREF /
     &    1.05363E+03,8.62642E+02,7.06272E+02,5.78246E+02,4.73428E+02,
     &    3.87610E+02,3.17348E+02,2.59823E+02,2.12725E+02,1.74164E+02,
     &    1.42594E+02,1.16746E+02,9.55835E+01,7.82571E+01,6.40715E+01,
     &    5.24573E+01,4.29484E+01,3.51632E+01,2.87892E+01,2.35706E+01,
     &    1.92980E+01,1.57998E+01,1.29358E+01,1.05910E+01,8.67114E+00,
     &    7.09933E+00,5.81244E+00,4.75882E+00,3.89619E+00,3.18993E+00,
     &    2.61170E+00,2.13828E+00,1.75067E+00,1.43333E+00,1.17351E+00,
     &    9.60789E-01,7.86628E-01,6.44036E-01,5.27292E-01,4.31710E-01,
     &    3.53455E-01,2.89384E-01,2.36928E-01,1.93980E-01,1.58817E-01,
     &    1.30029E-01,1.06458E-01,8.71608E-02,7.13612E-02,5.84256E-02,
     &    4.78349E-02,3.91639E-02,3.20647E-02,2.62523E-02,2.14936E-02,
     &    1.75975E-02,1.44076E-02,1.17959E-02,9.65769E-03/
      DATA PREFLOG /
     &     6.9600E+00, 6.7600E+00, 6.5600E+00, 6.3600E+00, 6.1600E+00,
     &     5.9600E+00, 5.7600E+00, 5.5600E+00, 5.3600E+00, 5.1600E+00,
     &     4.9600E+00, 4.7600E+00, 4.5600E+00, 4.3600E+00, 4.1600E+00,
     &     3.9600E+00, 3.7600E+00, 3.5600E+00, 3.3600E+00, 3.1600E+00,
     &     2.9600E+00, 2.7600E+00, 2.5600E+00, 2.3600E+00, 2.1600E+00,
     &     1.9600E+00, 1.7600E+00, 1.5600E+00, 1.3600E+00, 1.1600E+00,
     &     9.6000E-01, 7.6000E-01, 5.6000E-01, 3.6000E-01, 1.6000E-01,
     &    -4.0000E-02,-2.4000E-01,-4.4000E-01,-6.4000E-01,-8.4000E-01,
     &    -1.0400E+00,-1.2400E+00,-1.4400E+00,-1.6400E+00,-1.8400E+00,
     &    -2.0400E+00,-2.2400E+00,-2.4400E+00,-2.6400E+00,-2.8400E+00,
     &    -3.0400E+00,-3.2400E+00,-3.4400E+00,-3.6400E+00,-3.8400E+00,
     &    -4.0400E+00,-4.2400E+00,-4.4400E+00,-4.6400E+00/
C     These are the temperatures associated with the respective 
C     pressures for the MLS standard atmosphere. 
      DATA TREF /
     &     2.9420E+02, 2.8799E+02, 2.7894E+02, 2.6925E+02, 2.5983E+02,
     &     2.5017E+02, 2.4077E+02, 2.3179E+02, 2.2306E+02, 2.1578E+02,
     &     2.1570E+02, 2.1570E+02, 2.1570E+02, 2.1706E+02, 2.1858E+02,
     &     2.2018E+02, 2.2174E+02, 2.2328E+02, 2.2479E+02, 2.2655E+02,
     &     2.2834E+02, 2.3113E+02, 2.3401E+02, 2.3703E+02, 2.4022E+02,
     &     2.4371E+02, 2.4726E+02, 2.5085E+02, 2.5457E+02, 2.5832E+02,
     &     2.6216E+02, 2.6606E+02, 2.6999E+02, 2.7340E+02, 2.7536E+02,
     &     2.7568E+02, 2.7372E+02, 2.7163E+02, 2.6955E+02, 2.6593E+02,
     &     2.6211E+02, 2.5828E+02, 2.5360E+02, 2.4854E+02, 2.4348E+02,
     &     2.3809E+02, 2.3206E+02, 2.2603E+02, 2.2000E+02, 2.1435E+02,
     &     2.0887E+02, 2.0340E+02, 1.9792E+02, 1.9290E+02, 1.8809E+02,
     &     1.8329E+02, 1.7849E+02, 1.7394E+02, 1.7212E+02/
       DATA (CHI_MLS(1,IP),IP=1,12) /
     &  1.8760E-02, 1.2223E-02, 5.8909E-03, 2.7675E-03, 1.4065E-03,
     &  7.5970E-04, 3.8876E-04, 1.6542E-04, 3.7190E-05, 7.4765E-06,
     &  4.3082E-06, 3.3319E-06/
       DATA (CHI_MLS(1,IP),IP=13,59)/
     &  3.2039E-06,  3.1619E-06,  3.2524E-06,  3.4226E-06,  3.6288E-06,
     &  3.9148E-06,  4.1488E-06,  4.3081E-06,  4.4420E-06,  4.5778E-06,
     &  4.7087E-06,  4.7943E-06,  4.8697E-06,  4.9260E-06,  4.9669E-06,
     &  4.9963E-06,  5.0527E-06,  5.1266E-06,  5.2503E-06,  5.3571E-06,
     &  5.4509E-06,  5.4830E-06,  5.5000E-06,  5.5000E-06,  5.4536E-06,
     &  5.4047E-06,  5.3558E-06,  5.2533E-06,  5.1436E-06,  5.0340E-06,
     &  4.8766E-06,  4.6979E-06,  4.5191E-06,  4.3360E-06,  4.1442E-06,
     &  3.9523E-06,  3.7605E-06,  3.5722E-06,  3.3855E-06,  3.1988E-06,
     &  3.0121E-06,  2.8262E-06,  2.6407E-06,  2.4552E-06,  2.2696E-06,
     &  4.3360E-06,  4.1442E-06/
       DATA (CHI_MLS(2,IP),IP=1,12)/
     &  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,
     &  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,
     &  3.5500E-04,  3.5500E-04/
       DATA (CHI_MLS(2,IP),IP=13,59)/
     &  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,
     &  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,
     &  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,
     &  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,
     &  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,
     &  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,
     &  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,
     &  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,  3.5500E-04,
     &  3.5500E-04,  3.5471E-04,  3.5427E-04,  3.5384E-04,  3.5340E-04,
     &  3.5500E-04,  3.5500E-04/
       DATA (CHI_MLS(3,IP),IP=1,12)/
     &  3.0170E-08,  3.4725E-08,  4.2477E-08,  5.2759E-08,  6.6944E-08,
     &  8.7130E-08,  1.1391E-07,  1.5677E-07,  2.1788E-07,  3.2443E-07,
     &  4.6594E-07,  5.6806E-07/
       DATA (CHI_MLS(3,IP),IP=13,59)/
     &  6.9607E-07,  1.1186E-06,  1.7618E-06,  2.3269E-06,  2.9577E-06,
     &  3.6593E-06,  4.5950E-06,  5.3189E-06,  5.9618E-06,  6.5113E-06,
     &  7.0635E-06,  7.6917E-06,  8.2577E-06,  8.7082E-06,  8.8325E-06,
     &  8.7149E-06,  8.0943E-06,  7.3307E-06,  6.3101E-06,  5.3672E-06,
     &  4.4829E-06,  3.8391E-06,  3.2827E-06,  2.8235E-06,  2.4906E-06,
     &  2.1645E-06,  1.8385E-06,  1.6618E-06,  1.5052E-06,  1.3485E-06,
     &  1.1972E-06,  1.0482E-06,  8.9926E-07,  7.6343E-07,  6.5381E-07,
     &  5.4419E-07,  4.3456E-07,  3.6421E-07,  3.1194E-07,  2.5967E-07,
     &  2.0740E-07,  1.9146E-07,  1.9364E-07,  1.9582E-07,  1.9800E-07,
     &  7.6343E-07,  6.5381E-07/
       DATA (CHI_MLS(4,IP),IP=1,12)/
     &  3.2000E-07,  3.2000E-07,  3.2000E-07,  3.2000E-07,  3.2000E-07,
     &  3.1965E-07,  3.1532E-07,  3.0383E-07,  2.9422E-07,  2.8495E-07,
     &  2.7671E-07,  2.6471E-07/
       DATA (CHI_MLS(4,IP),IP=13,59)/
     &  2.4285E-07,  2.0955E-07,  1.7195E-07,  1.3749E-07,  1.1332E-07,
     &  1.0035E-07,  9.1281E-08,  8.5463E-08,  8.0363E-08,  7.3372E-08,
     &  6.5975E-08,  5.6039E-08,  4.7090E-08,  3.9977E-08,  3.2979E-08,
     &  2.6064E-08,  2.1066E-08,  1.6592E-08,  1.3017E-08,  1.0090E-08,
     &  7.6249E-09,  6.1159E-09,  4.6672E-09,  3.2857E-09,  2.8484E-09,
     &  2.4620E-09,  2.0756E-09,  1.8551E-09,  1.6568E-09,  1.4584E-09,
     &  1.3195E-09,  1.2072E-09,  1.0948E-09,  9.9780E-10,  9.3126E-10,
     &  8.6472E-10,  7.9818E-10,  7.5138E-10,  7.1367E-10,  6.7596E-10,
     &  6.3825E-10,  6.0981E-10,  5.8600E-10,  5.6218E-10,  5.3837E-10,
     &  9.9780E-10,  9.3126E-10/
       DATA (CHI_MLS(5,IP),IP=1,12)/
     &  1.5000E-07,  1.4306E-07,  1.3474E-07,  1.3061E-07,  1.2793E-07,
     &  1.2038E-07,  1.0798E-07,  9.4238E-08,  7.9488E-08,  6.1386E-08,
     &  4.5563E-08,  3.3475E-08/
       DATA (CHI_MLS(5,IP),IP=13,59)/
     &  2.5118E-08,  1.8671E-08,  1.4349E-08,  1.2501E-08,  1.2407E-08,
     &  1.3472E-08,  1.4900E-08,  1.6079E-08,  1.7156E-08,  1.8616E-08,
     &  2.0106E-08,  2.1654E-08,  2.3096E-08,  2.4340E-08,  2.5643E-08,
     &  2.6990E-08,  2.8456E-08,  2.9854E-08,  3.0943E-08,  3.2023E-08,
     &  3.3101E-08,  3.4260E-08,  3.5360E-08,  3.6397E-08,  3.7310E-08,
     &  3.8217E-08,  3.9123E-08,  4.1303E-08,  4.3652E-08,  4.6002E-08,
     &  5.0289E-08,  5.5446E-08,  6.0603E-08,  6.8946E-08,  8.3652E-08,
     &  9.8357E-08,  1.1306E-07,  1.4766E-07,  1.9142E-07,  2.3518E-07,
     &  2.7894E-07,  3.5001E-07,  4.3469E-07,  5.1938E-07,  6.0407E-07,
     &  6.8946E-08,  8.3652E-08/
       DATA (CHI_MLS(6,IP),IP=1,12) /
     &  1.7000E-06,  1.7000E-06,  1.6999E-06,  1.6904E-06,  1.6671E-06,
     &  1.6351E-06,  1.6098E-06,  1.5590E-06,  1.5120E-06,  1.4741E-06,
     &  1.4385E-06,  1.4002E-06/
       DATA (CHI_MLS(6,IP),IP=13,59)/
     &  1.3573E-06,  1.3130E-06,  1.2512E-06,  1.1668E-06,  1.0553E-06,
     &  9.3281E-07,  8.1217E-07,  7.5239E-07,  7.0728E-07,  6.6722E-07,
     &  6.2733E-07,  5.8604E-07,  5.4769E-07,  5.1480E-07,  4.8206E-07,
     &  4.4943E-07,  4.1702E-07,  3.8460E-07,  3.5200E-07,  3.1926E-07,
     &  2.8646E-07,  2.5498E-07,  2.2474E-07,  1.9588E-07,  1.8295E-07,
     &  1.7089E-07,  1.5882E-07,  1.5536E-07,  1.5304E-07,  1.5072E-07,
     &  1.5000E-07,  1.5000E-07,  1.5000E-07,  1.5000E-07,  1.5000E-07,
     &  1.5000E-07,  1.5000E-07,  1.5000E-07,  1.5000E-07,  1.5000E-07,
     &  1.5000E-07,  1.5000E-07,  1.5000E-07,  1.5000E-07,  1.5000E-07,
     &  1.5000E-07,  1.5000E-07/
       DATA (CHI_MLS(7,IP),IP=1,12)/
     &  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,
     &  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,
     &  0.2090    ,  0.2090    /
       DATA (CHI_MLS(7,IP),IP=13,59)/
     &  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,
     &  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,
     &  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,
     &  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,
     &  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,
     &  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,
     &  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,
     &  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,
     &  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,  0.2090    ,
     &  0.2090    ,  0.2090    /


       END

      BLOCK DATA AVPLANK

      PARAMETER (NBANDSLG = 16)

      COMMON /AVGPLNK/  TOTPLNK(181,NBANDSLG), TOTPLK16(181)

      DATA (TOTPLNK(I,  1),I=1,50)/
     &0.14783E-05,0.15006E-05,0.15230E-05,0.15455E-05,0.15681E-05,
     &0.15908E-05,0.16136E-05,0.16365E-05,0.16595E-05,0.16826E-05,
     &0.17059E-05,0.17292E-05,0.17526E-05,0.17762E-05,0.17998E-05,
     &0.18235E-05,0.18473E-05,0.18712E-05,0.18953E-05,0.19194E-05,
     &0.19435E-05,0.19678E-05,0.19922E-05,0.20166E-05,0.20412E-05,
     &0.20658E-05,0.20905E-05,0.21153E-05,0.21402E-05,0.21652E-05,
     &0.21902E-05,0.22154E-05,0.22406E-05,0.22659E-05,0.22912E-05,
     &0.23167E-05,0.23422E-05,0.23678E-05,0.23934E-05,0.24192E-05,
     &0.24450E-05,0.24709E-05,0.24968E-05,0.25229E-05,0.25490E-05,
     &0.25751E-05,0.26014E-05,0.26277E-05,0.26540E-05,0.26805E-05/
      DATA (TOTPLNK(I,  1),I=51,100)/
     &0.27070E-05,0.27335E-05,0.27602E-05,0.27869E-05,0.28136E-05,
     &0.28404E-05,0.28673E-05,0.28943E-05,0.29213E-05,0.29483E-05,
     &0.29754E-05,0.30026E-05,0.30298E-05,0.30571E-05,0.30845E-05,
     &0.31119E-05,0.31393E-05,0.31669E-05,0.31944E-05,0.32220E-05,
     &0.32497E-05,0.32774E-05,0.33052E-05,0.33330E-05,0.33609E-05,
     &0.33888E-05,0.34168E-05,0.34448E-05,0.34729E-05,0.35010E-05,
     &0.35292E-05,0.35574E-05,0.35857E-05,0.36140E-05,0.36424E-05,
     &0.36708E-05,0.36992E-05,0.37277E-05,0.37563E-05,0.37848E-05,
     &0.38135E-05,0.38421E-05,0.38708E-05,0.38996E-05,0.39284E-05,
     &0.39572E-05,0.39861E-05,0.40150E-05,0.40440E-05,0.40730E-05/
      DATA (TOTPLNK(I,  1),I=101,150)/
     &0.41020E-05,0.41311E-05,0.41602E-05,0.41893E-05,0.42185E-05,
     &0.42477E-05,0.42770E-05,0.43063E-05,0.43356E-05,0.43650E-05,
     &0.43944E-05,0.44238E-05,0.44533E-05,0.44828E-05,0.45124E-05,
     &0.45419E-05,0.45715E-05,0.46012E-05,0.46309E-05,0.46606E-05,
     &0.46903E-05,0.47201E-05,0.47499E-05,0.47797E-05,0.48096E-05,
     &0.48395E-05,0.48695E-05,0.48994E-05,0.49294E-05,0.49594E-05,
     &0.49895E-05,0.50196E-05,0.50497E-05,0.50798E-05,0.51100E-05,
     &0.51402E-05,0.51704E-05,0.52007E-05,0.52309E-05,0.52612E-05,
     &0.52916E-05,0.53219E-05,0.53523E-05,0.53827E-05,0.54132E-05,
     &0.54436E-05,0.54741E-05,0.55047E-05,0.55352E-05,0.55658E-05/
      DATA (TOTPLNK(I,  1),I=151,181)/
     &0.55964E-05,0.56270E-05,0.56576E-05,0.56883E-05,0.57190E-05,
     &0.57497E-05,0.57804E-05,0.58112E-05,0.58420E-05,0.58728E-05,
     &0.59036E-05,0.59345E-05,0.59653E-05,0.59962E-05,0.60272E-05,
     &0.60581E-05,0.60891E-05,0.61201E-05,0.61511E-05,0.61821E-05,
     &0.62131E-05,0.62442E-05,0.62753E-05,0.63064E-05,0.63376E-05,
     &0.63687E-05,0.63998E-05,0.64310E-05,0.64622E-05,0.64935E-05,
     &0.65247E-05/
      DATA (TOTPLNK(I,  2),I=1,50)/
     &0.20262E-05,0.20757E-05,0.21257E-05,0.21763E-05,0.22276E-05,
     &0.22794E-05,0.23319E-05,0.23849E-05,0.24386E-05,0.24928E-05,
     &0.25477E-05,0.26031E-05,0.26591E-05,0.27157E-05,0.27728E-05,
     &0.28306E-05,0.28889E-05,0.29478E-05,0.30073E-05,0.30673E-05,
     &0.31279E-05,0.31890E-05,0.32507E-05,0.33129E-05,0.33757E-05,
     &0.34391E-05,0.35029E-05,0.35674E-05,0.36323E-05,0.36978E-05,
     &0.37638E-05,0.38304E-05,0.38974E-05,0.39650E-05,0.40331E-05,
     &0.41017E-05,0.41708E-05,0.42405E-05,0.43106E-05,0.43812E-05,
     &0.44524E-05,0.45240E-05,0.45961E-05,0.46687E-05,0.47418E-05,
     &0.48153E-05,0.48894E-05,0.49639E-05,0.50389E-05,0.51143E-05/
      DATA (TOTPLNK(I,  2),I=51,100)/
     &0.51902E-05,0.52666E-05,0.53434E-05,0.54207E-05,0.54985E-05,
     &0.55767E-05,0.56553E-05,0.57343E-05,0.58139E-05,0.58938E-05,
     &0.59742E-05,0.60550E-05,0.61362E-05,0.62179E-05,0.63000E-05,
     &0.63825E-05,0.64654E-05,0.65487E-05,0.66324E-05,0.67166E-05,
     &0.68011E-05,0.68860E-05,0.69714E-05,0.70571E-05,0.71432E-05,
     &0.72297E-05,0.73166E-05,0.74039E-05,0.74915E-05,0.75796E-05,
     &0.76680E-05,0.77567E-05,0.78459E-05,0.79354E-05,0.80252E-05,
     &0.81155E-05,0.82061E-05,0.82970E-05,0.83883E-05,0.84799E-05,
     &0.85719E-05,0.86643E-05,0.87569E-05,0.88499E-05,0.89433E-05,
     &0.90370E-05,0.91310E-05,0.92254E-05,0.93200E-05,0.94150E-05/
      DATA (TOTPLNK(I,  2),I=101,150)/
     &0.95104E-05,0.96060E-05,0.97020E-05,0.97982E-05,0.98948E-05,
     &0.99917E-05,0.10089E-04,0.10186E-04,0.10284E-04,0.10382E-04,
     &0.10481E-04,0.10580E-04,0.10679E-04,0.10778E-04,0.10877E-04,
     &0.10977E-04,0.11077E-04,0.11178E-04,0.11279E-04,0.11380E-04,
     &0.11481E-04,0.11583E-04,0.11684E-04,0.11786E-04,0.11889E-04,
     &0.11992E-04,0.12094E-04,0.12198E-04,0.12301E-04,0.12405E-04,
     &0.12509E-04,0.12613E-04,0.12717E-04,0.12822E-04,0.12927E-04,
     &0.13032E-04,0.13138E-04,0.13244E-04,0.13349E-04,0.13456E-04,
     &0.13562E-04,0.13669E-04,0.13776E-04,0.13883E-04,0.13990E-04,
     &0.14098E-04,0.14206E-04,0.14314E-04,0.14422E-04,0.14531E-04/
      DATA (TOTPLNK(I,  2),I=151,181)/
     &0.14639E-04,0.14748E-04,0.14857E-04,0.14967E-04,0.15076E-04,
     &0.15186E-04,0.15296E-04,0.15407E-04,0.15517E-04,0.15628E-04,
     &0.15739E-04,0.15850E-04,0.15961E-04,0.16072E-04,0.16184E-04,
     &0.16296E-04,0.16408E-04,0.16521E-04,0.16633E-04,0.16746E-04,
     &0.16859E-04,0.16972E-04,0.17085E-04,0.17198E-04,0.17312E-04,
     &0.17426E-04,0.17540E-04,0.17654E-04,0.17769E-04,0.17883E-04,
     &0.17998E-04/
      DATA (TOTPLNK(I, 3),I=1,50)/
     &1.34822E-06,1.39134E-06,1.43530E-06,1.48010E-06,1.52574E-06,
     &1.57222E-06,1.61956E-06,1.66774E-06,1.71678E-06,1.76666E-06,
     &1.81741E-06,1.86901E-06,1.92147E-06,1.97479E-06,2.02898E-06,
     &2.08402E-06,2.13993E-06,2.19671E-06,2.25435E-06,2.31285E-06,
     &2.37222E-06,2.43246E-06,2.49356E-06,2.55553E-06,2.61837E-06,
     &2.68207E-06,2.74664E-06,2.81207E-06,2.87837E-06,2.94554E-06,
     &3.01356E-06,3.08245E-06,3.15221E-06,3.22282E-06,3.29429E-06,
     &3.36662E-06,3.43982E-06,3.51386E-06,3.58876E-06,3.66451E-06,
     &3.74112E-06,3.81857E-06,3.89688E-06,3.97602E-06,4.05601E-06,
     &4.13685E-06,4.21852E-06,4.30104E-06,4.38438E-06,4.46857E-06/
      DATA (TOTPLNK(I, 3),I=51,100)/
     &4.55358E-06,4.63943E-06,4.72610E-06,4.81359E-06,4.90191E-06,
     &4.99105E-06,5.08100E-06,5.17176E-06,5.26335E-06,5.35573E-06,
     &5.44892E-06,5.54292E-06,5.63772E-06,5.73331E-06,5.82970E-06,
     &5.92688E-06,6.02485E-06,6.12360E-06,6.22314E-06,6.32346E-06,
     &6.42455E-06,6.52641E-06,6.62906E-06,6.73247E-06,6.83664E-06,
     &6.94156E-06,7.04725E-06,7.15370E-06,7.26089E-06,7.36883E-06,
     &7.47752E-06,7.58695E-06,7.69712E-06,7.80801E-06,7.91965E-06,
     &8.03201E-06,8.14510E-06,8.25891E-06,8.37343E-06,8.48867E-06,
     &8.60463E-06,8.72128E-06,8.83865E-06,8.95672E-06,9.07548E-06,
     &9.19495E-06,9.31510E-06,9.43594E-06,9.55745E-06,9.67966E-06/
      DATA (TOTPLNK(I, 3),I=101,150)/
     &9.80254E-06,9.92609E-06,1.00503E-05,1.01752E-05,1.03008E-05,
     &1.04270E-05,1.05539E-05,1.06814E-05,1.08096E-05,1.09384E-05,
     &1.10679E-05,1.11980E-05,1.13288E-05,1.14601E-05,1.15922E-05,
     &1.17248E-05,1.18581E-05,1.19920E-05,1.21265E-05,1.22616E-05,
     &1.23973E-05,1.25337E-05,1.26706E-05,1.28081E-05,1.29463E-05,
     &1.30850E-05,1.32243E-05,1.33642E-05,1.35047E-05,1.36458E-05,
     &1.37875E-05,1.39297E-05,1.40725E-05,1.42159E-05,1.43598E-05,
     &1.45044E-05,1.46494E-05,1.47950E-05,1.49412E-05,1.50879E-05,
     &1.52352E-05,1.53830E-05,1.55314E-05,1.56803E-05,1.58297E-05,
     &1.59797E-05,1.61302E-05,1.62812E-05,1.64327E-05,1.65848E-05/
      DATA (TOTPLNK(I, 3),I=151,181)/
     &1.67374E-05,1.68904E-05,1.70441E-05,1.71982E-05,1.73528E-05,
     &1.75079E-05,1.76635E-05,1.78197E-05,1.79763E-05,1.81334E-05,
     &1.82910E-05,1.84491E-05,1.86076E-05,1.87667E-05,1.89262E-05,
     &1.90862E-05,1.92467E-05,1.94076E-05,1.95690E-05,1.97309E-05,
     &1.98932E-05,2.00560E-05,2.02193E-05,2.03830E-05,2.05472E-05,
     &2.07118E-05,2.08768E-05,2.10423E-05,2.12083E-05,2.13747E-05,
     &2.15414E-05/
      DATA (TOTPLNK(I, 4),I=1,50)/
     &8.90528E-07,9.24222E-07,9.58757E-07,9.94141E-07,1.03038E-06,
     &1.06748E-06,1.10545E-06,1.14430E-06,1.18403E-06,1.22465E-06,
     &1.26618E-06,1.30860E-06,1.35193E-06,1.39619E-06,1.44136E-06,
     &1.48746E-06,1.53449E-06,1.58246E-06,1.63138E-06,1.68124E-06,
     &1.73206E-06,1.78383E-06,1.83657E-06,1.89028E-06,1.94495E-06,
     &2.00060E-06,2.05724E-06,2.11485E-06,2.17344E-06,2.23303E-06,
     &2.29361E-06,2.35519E-06,2.41777E-06,2.48134E-06,2.54592E-06,
     &2.61151E-06,2.67810E-06,2.74571E-06,2.81433E-06,2.88396E-06,
     &2.95461E-06,3.02628E-06,3.09896E-06,3.17267E-06,3.24741E-06,
     &3.32316E-06,3.39994E-06,3.47774E-06,3.55657E-06,3.63642E-06/
      DATA (TOTPLNK(I, 4),I=51,100)/
     &3.71731E-06,3.79922E-06,3.88216E-06,3.96612E-06,4.05112E-06,
     &4.13714E-06,4.22419E-06,4.31227E-06,4.40137E-06,4.49151E-06,
     &4.58266E-06,4.67485E-06,4.76806E-06,4.86229E-06,4.95754E-06,
     &5.05383E-06,5.15113E-06,5.24946E-06,5.34879E-06,5.44916E-06,
     &5.55053E-06,5.65292E-06,5.75632E-06,5.86073E-06,5.96616E-06,
     &6.07260E-06,6.18003E-06,6.28848E-06,6.39794E-06,6.50838E-06,
     &6.61983E-06,6.73229E-06,6.84573E-06,6.96016E-06,7.07559E-06,
     &7.19200E-06,7.30940E-06,7.42779E-06,7.54715E-06,7.66749E-06,
     &7.78882E-06,7.91110E-06,8.03436E-06,8.15859E-06,8.28379E-06,
     &8.40994E-06,8.53706E-06,8.66515E-06,8.79418E-06,8.92416E-06/
      DATA (TOTPLNK(I, 4),I=101,150)/
     &9.05510E-06,9.18697E-06,9.31979E-06,9.45356E-06,9.58826E-06,
     &9.72389E-06,9.86046E-06,9.99793E-06,1.01364E-05,1.02757E-05,
     &1.04159E-05,1.05571E-05,1.06992E-05,1.08422E-05,1.09861E-05,
     &1.11309E-05,1.12766E-05,1.14232E-05,1.15707E-05,1.17190E-05,
     &1.18683E-05,1.20184E-05,1.21695E-05,1.23214E-05,1.24741E-05,
     &1.26277E-05,1.27822E-05,1.29376E-05,1.30939E-05,1.32509E-05,
     &1.34088E-05,1.35676E-05,1.37273E-05,1.38877E-05,1.40490E-05,
     &1.42112E-05,1.43742E-05,1.45380E-05,1.47026E-05,1.48680E-05,
     &1.50343E-05,1.52014E-05,1.53692E-05,1.55379E-05,1.57074E-05,
     &1.58778E-05,1.60488E-05,1.62207E-05,1.63934E-05,1.65669E-05/
      DATA (TOTPLNK(I, 4),I=151,181)/
     &1.67411E-05,1.69162E-05,1.70920E-05,1.72685E-05,1.74459E-05,
     &1.76240E-05,1.78029E-05,1.79825E-05,1.81629E-05,1.83440E-05,
     &1.85259E-05,1.87086E-05,1.88919E-05,1.90760E-05,1.92609E-05,
     &1.94465E-05,1.96327E-05,1.98199E-05,2.00076E-05,2.01961E-05,
     &2.03853E-05,2.05752E-05,2.07658E-05,2.09571E-05,2.11491E-05,
     &2.13418E-05,2.15352E-05,2.17294E-05,2.19241E-05,2.21196E-05,
     &2.23158E-05/
      DATA (TOTPLNK(I, 5),I=1,50)/
     &5.70230E-07,5.94788E-07,6.20085E-07,6.46130E-07,6.72936E-07,
     &7.00512E-07,7.28869E-07,7.58019E-07,7.87971E-07,8.18734E-07,
     &8.50320E-07,8.82738E-07,9.15999E-07,9.50110E-07,9.85084E-07,
     &1.02093E-06,1.05765E-06,1.09527E-06,1.13378E-06,1.17320E-06,
     &1.21353E-06,1.25479E-06,1.29698E-06,1.34011E-06,1.38419E-06,
     &1.42923E-06,1.47523E-06,1.52221E-06,1.57016E-06,1.61910E-06,
     &1.66904E-06,1.71997E-06,1.77192E-06,1.82488E-06,1.87886E-06,
     &1.93387E-06,1.98991E-06,2.04699E-06,2.10512E-06,2.16430E-06,
     &2.22454E-06,2.28584E-06,2.34821E-06,2.41166E-06,2.47618E-06,
     &2.54178E-06,2.60847E-06,2.67626E-06,2.74514E-06,2.81512E-06/
      DATA (TOTPLNK(I, 5),I=51,100)/
     &2.88621E-06,2.95841E-06,3.03172E-06,3.10615E-06,3.18170E-06,
     &3.25838E-06,3.33618E-06,3.41511E-06,3.49518E-06,3.57639E-06,
     &3.65873E-06,3.74221E-06,3.82684E-06,3.91262E-06,3.99955E-06,
     &4.08763E-06,4.17686E-06,4.26725E-06,4.35880E-06,4.45150E-06,
     &4.54537E-06,4.64039E-06,4.73659E-06,4.83394E-06,4.93246E-06,
     &5.03215E-06,5.13301E-06,5.23504E-06,5.33823E-06,5.44260E-06,
     &5.54814E-06,5.65484E-06,5.76272E-06,5.87177E-06,5.98199E-06,
     &6.09339E-06,6.20596E-06,6.31969E-06,6.43460E-06,6.55068E-06,
     &6.66793E-06,6.78636E-06,6.90595E-06,7.02670E-06,7.14863E-06,
     &7.27173E-06,7.39599E-06,7.52142E-06,7.64802E-06,7.77577E-06/
      DATA (TOTPLNK(I, 5),I=101,150)/
     &7.90469E-06,8.03477E-06,8.16601E-06,8.29841E-06,8.43198E-06,
     &8.56669E-06,8.70256E-06,8.83957E-06,8.97775E-06,9.11706E-06,
     &9.25753E-06,9.39915E-06,9.54190E-06,9.68580E-06,9.83085E-06,
     &9.97704E-06,1.01243E-05,1.02728E-05,1.04224E-05,1.05731E-05,
     &1.07249E-05,1.08779E-05,1.10320E-05,1.11872E-05,1.13435E-05,
     &1.15009E-05,1.16595E-05,1.18191E-05,1.19799E-05,1.21418E-05,
     &1.23048E-05,1.24688E-05,1.26340E-05,1.28003E-05,1.29676E-05,
     &1.31361E-05,1.33056E-05,1.34762E-05,1.36479E-05,1.38207E-05,
     &1.39945E-05,1.41694E-05,1.43454E-05,1.45225E-05,1.47006E-05,
     &1.48797E-05,1.50600E-05,1.52413E-05,1.54236E-05,1.56070E-05/
      DATA (TOTPLNK(I, 5),I=151,181)/
     &1.57914E-05,1.59768E-05,1.61633E-05,1.63509E-05,1.65394E-05,
     &1.67290E-05,1.69197E-05,1.71113E-05,1.73040E-05,1.74976E-05,
     &1.76923E-05,1.78880E-05,1.80847E-05,1.82824E-05,1.84811E-05,
     &1.86808E-05,1.88814E-05,1.90831E-05,1.92857E-05,1.94894E-05,
     &1.96940E-05,1.98996E-05,2.01061E-05,2.03136E-05,2.05221E-05,
     &2.07316E-05,2.09420E-05,2.11533E-05,2.13657E-05,2.15789E-05,
     &2.17931E-05/
      DATA (TOTPLNK(I, 6),I=1,50)/
     &2.73493E-07,2.87408E-07,3.01848E-07,3.16825E-07,3.32352E-07,
     &3.48439E-07,3.65100E-07,3.82346E-07,4.00189E-07,4.18641E-07,
     &4.37715E-07,4.57422E-07,4.77774E-07,4.98784E-07,5.20464E-07,
     &5.42824E-07,5.65879E-07,5.89638E-07,6.14115E-07,6.39320E-07,
     &6.65266E-07,6.91965E-07,7.19427E-07,7.47666E-07,7.76691E-07,
     &8.06516E-07,8.37151E-07,8.68607E-07,9.00896E-07,9.34029E-07,
     &9.68018E-07,1.00287E-06,1.03860E-06,1.07522E-06,1.11274E-06,
     &1.15117E-06,1.19052E-06,1.23079E-06,1.27201E-06,1.31418E-06,
     &1.35731E-06,1.40141E-06,1.44650E-06,1.49257E-06,1.53965E-06,
     &1.58773E-06,1.63684E-06,1.68697E-06,1.73815E-06,1.79037E-06/
      DATA (TOTPLNK(I, 6),I=51,100)/
     &1.84365E-06,1.89799E-06,1.95341E-06,2.00991E-06,2.06750E-06,
     &2.12619E-06,2.18599E-06,2.24691E-06,2.30895E-06,2.37212E-06,
     &2.43643E-06,2.50189E-06,2.56851E-06,2.63628E-06,2.70523E-06,
     &2.77536E-06,2.84666E-06,2.91916E-06,2.99286E-06,3.06776E-06,
     &3.14387E-06,3.22120E-06,3.29975E-06,3.37953E-06,3.46054E-06,
     &3.54280E-06,3.62630E-06,3.71105E-06,3.79707E-06,3.88434E-06,
     &3.97288E-06,4.06270E-06,4.15380E-06,4.24617E-06,4.33984E-06,
     &4.43479E-06,4.53104E-06,4.62860E-06,4.72746E-06,4.82763E-06,
     &4.92911E-06,5.03191E-06,5.13603E-06,5.24147E-06,5.34824E-06,
     &5.45634E-06,5.56578E-06,5.67656E-06,5.78867E-06,5.90213E-06/
      DATA (TOTPLNK(I, 6),I=101,150)/
     &6.01694E-06,6.13309E-06,6.25060E-06,6.36947E-06,6.48968E-06,
     &6.61126E-06,6.73420E-06,6.85850E-06,6.98417E-06,7.11120E-06,
     &7.23961E-06,7.36938E-06,7.50053E-06,7.63305E-06,7.76694E-06,
     &7.90221E-06,8.03887E-06,8.17690E-06,8.31632E-06,8.45710E-06,
     &8.59928E-06,8.74282E-06,8.88776E-06,9.03409E-06,9.18179E-06,
     &9.33088E-06,9.48136E-06,9.63323E-06,9.78648E-06,9.94111E-06,
     &1.00971E-05,1.02545E-05,1.04133E-05,1.05735E-05,1.07351E-05,
     &1.08980E-05,1.10624E-05,1.12281E-05,1.13952E-05,1.15637E-05,
     &1.17335E-05,1.19048E-05,1.20774E-05,1.22514E-05,1.24268E-05,
     &1.26036E-05,1.27817E-05,1.29612E-05,1.31421E-05,1.33244E-05/
      DATA (TOTPLNK(I, 6),I=151,181)/
     &1.35080E-05,1.36930E-05,1.38794E-05,1.40672E-05,1.42563E-05,
     &1.44468E-05,1.46386E-05,1.48318E-05,1.50264E-05,1.52223E-05,
     &1.54196E-05,1.56182E-05,1.58182E-05,1.60196E-05,1.62223E-05,
     &1.64263E-05,1.66317E-05,1.68384E-05,1.70465E-05,1.72559E-05,
     &1.74666E-05,1.76787E-05,1.78921E-05,1.81069E-05,1.83230E-05,
     &1.85404E-05,1.87591E-05,1.89791E-05,1.92005E-05,1.94232E-05,
     &1.96471E-05/
      DATA (TOTPLNK(I, 7),I=1,50)/
     &1.25349E-07,1.32735E-07,1.40458E-07,1.48527E-07,1.56954E-07,
     &1.65748E-07,1.74920E-07,1.84481E-07,1.94443E-07,2.04814E-07,
     &2.15608E-07,2.26835E-07,2.38507E-07,2.50634E-07,2.63229E-07,
     &2.76301E-07,2.89864E-07,3.03930E-07,3.18508E-07,3.33612E-07,
     &3.49253E-07,3.65443E-07,3.82195E-07,3.99519E-07,4.17428E-07,
     &4.35934E-07,4.55050E-07,4.74785E-07,4.95155E-07,5.16170E-07,
     &5.37844E-07,5.60186E-07,5.83211E-07,6.06929E-07,6.31355E-07,
     &6.56498E-07,6.82373E-07,7.08990E-07,7.36362E-07,7.64501E-07,
     &7.93420E-07,8.23130E-07,8.53643E-07,8.84971E-07,9.17128E-07,
     &9.50123E-07,9.83969E-07,1.01868E-06,1.05426E-06,1.09073E-06/
      DATA (TOTPLNK(I, 7),I=51,100)/
     &1.12810E-06,1.16638E-06,1.20558E-06,1.24572E-06,1.28680E-06,
     &1.32883E-06,1.37183E-06,1.41581E-06,1.46078E-06,1.50675E-06,
     &1.55374E-06,1.60174E-06,1.65078E-06,1.70087E-06,1.75200E-06,
     &1.80421E-06,1.85749E-06,1.91186E-06,1.96732E-06,2.02389E-06,
     &2.08159E-06,2.14040E-06,2.20035E-06,2.26146E-06,2.32372E-06,
     &2.38714E-06,2.45174E-06,2.51753E-06,2.58451E-06,2.65270E-06,
     &2.72210E-06,2.79272E-06,2.86457E-06,2.93767E-06,3.01201E-06,
     &3.08761E-06,3.16448E-06,3.24261E-06,3.32204E-06,3.40275E-06,
     &3.48476E-06,3.56808E-06,3.65271E-06,3.73866E-06,3.82595E-06,
     &3.91456E-06,4.00453E-06,4.09584E-06,4.18851E-06,4.28254E-06/
      DATA (TOTPLNK(I, 7),I=101,150)/
     &4.37796E-06,4.47475E-06,4.57293E-06,4.67249E-06,4.77346E-06,
     &4.87583E-06,4.97961E-06,5.08481E-06,5.19143E-06,5.29948E-06,
     &5.40896E-06,5.51989E-06,5.63226E-06,5.74608E-06,5.86136E-06,
     &5.97810E-06,6.09631E-06,6.21597E-06,6.33713E-06,6.45976E-06,
     &6.58388E-06,6.70950E-06,6.83661E-06,6.96521E-06,7.09531E-06,
     &7.22692E-06,7.36005E-06,7.49468E-06,7.63084E-06,7.76851E-06,
     &7.90773E-06,8.04846E-06,8.19072E-06,8.33452E-06,8.47985E-06,
     &8.62674E-06,8.77517E-06,8.92514E-06,9.07666E-06,9.22975E-06,
     &9.38437E-06,9.54057E-06,9.69832E-06,9.85762E-06,1.00185E-05,
     &1.01810E-05,1.03450E-05,1.05106E-05,1.06777E-05,1.08465E-05/
      DATA (TOTPLNK(I, 7),I=151,181)/
     &1.10168E-05,1.11887E-05,1.13621E-05,1.15372E-05,1.17138E-05,
     &1.18920E-05,1.20718E-05,1.22532E-05,1.24362E-05,1.26207E-05,
     &1.28069E-05,1.29946E-05,1.31839E-05,1.33749E-05,1.35674E-05,
     &1.37615E-05,1.39572E-05,1.41544E-05,1.43533E-05,1.45538E-05,
     &1.47558E-05,1.49595E-05,1.51647E-05,1.53716E-05,1.55800E-05,
     &1.57900E-05,1.60017E-05,1.62149E-05,1.64296E-05,1.66460E-05,
     &1.68640E-05/
      DATA (TOTPLNK(I, 8),I=1,50)/
     &6.74445E-08,7.18176E-08,7.64153E-08,8.12456E-08,8.63170E-08,
     &9.16378E-08,9.72168E-08,1.03063E-07,1.09184E-07,1.15591E-07,
     &1.22292E-07,1.29296E-07,1.36613E-07,1.44253E-07,1.52226E-07,
     &1.60540E-07,1.69207E-07,1.78236E-07,1.87637E-07,1.97421E-07,
     &2.07599E-07,2.18181E-07,2.29177E-07,2.40598E-07,2.52456E-07,
     &2.64761E-07,2.77523E-07,2.90755E-07,3.04468E-07,3.18673E-07,
     &3.33381E-07,3.48603E-07,3.64352E-07,3.80638E-07,3.97474E-07,
     &4.14871E-07,4.32841E-07,4.51395E-07,4.70547E-07,4.90306E-07,
     &5.10687E-07,5.31699E-07,5.53357E-07,5.75670E-07,5.98652E-07,
     &6.22315E-07,6.46672E-07,6.71731E-07,6.97511E-07,7.24018E-07/
      DATA (TOTPLNK(I, 8),I=51,100)/
     &7.51266E-07,7.79269E-07,8.08038E-07,8.37584E-07,8.67922E-07,
     &8.99061E-07,9.31016E-07,9.63797E-07,9.97417E-07,1.03189E-06,
     &1.06722E-06,1.10343E-06,1.14053E-06,1.17853E-06,1.21743E-06,
     &1.25726E-06,1.29803E-06,1.33974E-06,1.38241E-06,1.42606E-06,
     &1.47068E-06,1.51630E-06,1.56293E-06,1.61056E-06,1.65924E-06,
     &1.70894E-06,1.75971E-06,1.81153E-06,1.86443E-06,1.91841E-06,
     &1.97350E-06,2.02968E-06,2.08699E-06,2.14543E-06,2.20500E-06,
     &2.26573E-06,2.32762E-06,2.39068E-06,2.45492E-06,2.52036E-06,
     &2.58700E-06,2.65485E-06,2.72393E-06,2.79424E-06,2.86580E-06,
     &2.93861E-06,3.01269E-06,3.08803E-06,3.16467E-06,3.24259E-06/
      DATA (TOTPLNK(I, 8),I=101,150)/
     &3.32181E-06,3.40235E-06,3.48420E-06,3.56739E-06,3.65192E-06,
     &3.73779E-06,3.82502E-06,3.91362E-06,4.00359E-06,4.09494E-06,
     &4.18768E-06,4.28182E-06,4.37737E-06,4.47434E-06,4.57273E-06,
     &4.67254E-06,4.77380E-06,4.87651E-06,4.98067E-06,5.08630E-06,
     &5.19339E-06,5.30196E-06,5.41201E-06,5.52356E-06,5.63660E-06,
     &5.75116E-06,5.86722E-06,5.98479E-06,6.10390E-06,6.22453E-06,
     &6.34669E-06,6.47042E-06,6.59569E-06,6.72252E-06,6.85090E-06,
     &6.98085E-06,7.11238E-06,7.24549E-06,7.38019E-06,7.51646E-06,
     &7.65434E-06,7.79382E-06,7.93490E-06,8.07760E-06,8.22192E-06,
     &8.36784E-06,8.51540E-06,8.66459E-06,8.81542E-06,8.96786E-06/
      DATA (TOTPLNK(I, 8),I=151,181)/
     &9.12197E-06,9.27772E-06,9.43513E-06,9.59419E-06,9.75490E-06,
     &9.91728E-06,1.00813E-05,1.02471E-05,1.04144E-05,1.05835E-05,
     &1.07543E-05,1.09267E-05,1.11008E-05,1.12766E-05,1.14541E-05,
     &1.16333E-05,1.18142E-05,1.19969E-05,1.21812E-05,1.23672E-05,
     &1.25549E-05,1.27443E-05,1.29355E-05,1.31284E-05,1.33229E-05,
     &1.35193E-05,1.37173E-05,1.39170E-05,1.41185E-05,1.43217E-05,
     &1.45267E-05/
      DATA (TOTPLNK(I, 9),I=1,50)/
     &2.61522E-08,2.80613E-08,3.00838E-08,3.22250E-08,3.44899E-08,
     &3.68841E-08,3.94129E-08,4.20820E-08,4.48973E-08,4.78646E-08,
     &5.09901E-08,5.42799E-08,5.77405E-08,6.13784E-08,6.52001E-08,
     &6.92126E-08,7.34227E-08,7.78375E-08,8.24643E-08,8.73103E-08,
     &9.23832E-08,9.76905E-08,1.03240E-07,1.09039E-07,1.15097E-07,
     &1.21421E-07,1.28020E-07,1.34902E-07,1.42075E-07,1.49548E-07,
     &1.57331E-07,1.65432E-07,1.73860E-07,1.82624E-07,1.91734E-07,
     &2.01198E-07,2.11028E-07,2.21231E-07,2.31818E-07,2.42799E-07,
     &2.54184E-07,2.65983E-07,2.78205E-07,2.90862E-07,3.03963E-07,
     &3.17519E-07,3.31541E-07,3.46039E-07,3.61024E-07,3.76507E-07/
      DATA (TOTPLNK(I, 9),I=51,100)/
     &3.92498E-07,4.09008E-07,4.26050E-07,4.43633E-07,4.61769E-07,
     &4.80469E-07,4.99744E-07,5.19606E-07,5.40067E-07,5.61136E-07,
     &5.82828E-07,6.05152E-07,6.28120E-07,6.51745E-07,6.76038E-07,
     &7.01010E-07,7.26674E-07,7.53041E-07,7.80124E-07,8.07933E-07,
     &8.36482E-07,8.65781E-07,8.95845E-07,9.26683E-07,9.58308E-07,
     &9.90732E-07,1.02397E-06,1.05803E-06,1.09292E-06,1.12866E-06,
     &1.16526E-06,1.20274E-06,1.24109E-06,1.28034E-06,1.32050E-06,
     &1.36158E-06,1.40359E-06,1.44655E-06,1.49046E-06,1.53534E-06,
     &1.58120E-06,1.62805E-06,1.67591E-06,1.72478E-06,1.77468E-06,
     &1.82561E-06,1.87760E-06,1.93066E-06,1.98479E-06,2.04000E-06/
      DATA (TOTPLNK(I, 9),I=101,150)/
     &2.09631E-06,2.15373E-06,2.21228E-06,2.27196E-06,2.33278E-06,
     &2.39475E-06,2.45790E-06,2.52222E-06,2.58773E-06,2.65445E-06,
     &2.72238E-06,2.79152E-06,2.86191E-06,2.93354E-06,3.00643E-06,
     &3.08058E-06,3.15601E-06,3.23273E-06,3.31075E-06,3.39009E-06,
     &3.47074E-06,3.55272E-06,3.63605E-06,3.72072E-06,3.80676E-06,
     &3.89417E-06,3.98297E-06,4.07315E-06,4.16474E-06,4.25774E-06,
     &4.35217E-06,4.44802E-06,4.54532E-06,4.64406E-06,4.74428E-06,
     &4.84595E-06,4.94911E-06,5.05376E-06,5.15990E-06,5.26755E-06,
     &5.37671E-06,5.48741E-06,5.59963E-06,5.71340E-06,5.82871E-06,
     &5.94559E-06,6.06403E-06,6.18404E-06,6.30565E-06,6.42885E-06/
      DATA (TOTPLNK(I, 9),I=151,181)/
     &6.55364E-06,6.68004E-06,6.80806E-06,6.93771E-06,7.06898E-06,
     &7.20190E-06,7.33646E-06,7.47267E-06,7.61056E-06,7.75010E-06,
     &7.89133E-06,8.03423E-06,8.17884E-06,8.32514E-06,8.47314E-06,
     &8.62284E-06,8.77427E-06,8.92743E-06,9.08231E-06,9.23893E-06,
     &9.39729E-06,9.55741E-06,9.71927E-06,9.88291E-06,1.00483E-05,
     &1.02155E-05,1.03844E-05,1.05552E-05,1.07277E-05,1.09020E-05,
     &1.10781E-05/
      DATA (TOTPLNK(I,10),I=1,50)/
     &8.89300E-09,9.63263E-09,1.04235E-08,1.12685E-08,1.21703E-08,
     &1.31321E-08,1.41570E-08,1.52482E-08,1.64090E-08,1.76428E-08,
     &1.89533E-08,2.03441E-08,2.18190E-08,2.33820E-08,2.50370E-08,
     &2.67884E-08,2.86402E-08,3.05969E-08,3.26632E-08,3.48436E-08,
     &3.71429E-08,3.95660E-08,4.21179E-08,4.48040E-08,4.76294E-08,
     &5.05996E-08,5.37201E-08,5.69966E-08,6.04349E-08,6.40411E-08,
     &6.78211E-08,7.17812E-08,7.59276E-08,8.02670E-08,8.48059E-08,
     &8.95508E-08,9.45090E-08,9.96873E-08,1.05093E-07,1.10733E-07,
     &1.16614E-07,1.22745E-07,1.29133E-07,1.35786E-07,1.42711E-07,
     &1.49916E-07,1.57410E-07,1.65202E-07,1.73298E-07,1.81709E-07/
      DATA (TOTPLNK(I,10),I=51,100)/
     &1.90441E-07,1.99505E-07,2.08908E-07,2.18660E-07,2.28770E-07,
     &2.39247E-07,2.50101E-07,2.61340E-07,2.72974E-07,2.85013E-07,
     &2.97467E-07,3.10345E-07,3.23657E-07,3.37413E-07,3.51623E-07,
     &3.66298E-07,3.81448E-07,3.97082E-07,4.13212E-07,4.29848E-07,
     &4.47000E-07,4.64680E-07,4.82898E-07,5.01664E-07,5.20991E-07,
     &5.40888E-07,5.61369E-07,5.82440E-07,6.04118E-07,6.26410E-07,
     &6.49329E-07,6.72887E-07,6.97095E-07,7.21964E-07,7.47506E-07,
     &7.73732E-07,8.00655E-07,8.28287E-07,8.56635E-07,8.85717E-07,
     &9.15542E-07,9.46122E-07,9.77469E-07,1.00960E-06,1.04251E-06,
     &1.07623E-06,1.11077E-06,1.14613E-06,1.18233E-06,1.21939E-06/
      DATA (TOTPLNK(I,10),I=101,150)/
     &1.25730E-06,1.29610E-06,1.33578E-06,1.37636E-06,1.41785E-06,
     &1.46027E-06,1.50362E-06,1.54792E-06,1.59319E-06,1.63942E-06,
     &1.68665E-06,1.73487E-06,1.78410E-06,1.83435E-06,1.88564E-06,
     &1.93797E-06,1.99136E-06,2.04582E-06,2.10137E-06,2.15801E-06,
     &2.21576E-06,2.27463E-06,2.33462E-06,2.39577E-06,2.45806E-06,
     &2.52153E-06,2.58617E-06,2.65201E-06,2.71905E-06,2.78730E-06,
     &2.85678E-06,2.92749E-06,2.99946E-06,3.07269E-06,3.14720E-06,
     &3.22299E-06,3.30007E-06,3.37847E-06,3.45818E-06,3.53923E-06,
     &3.62161E-06,3.70535E-06,3.79046E-06,3.87695E-06,3.96481E-06,
     &4.05409E-06,4.14477E-06,4.23687E-06,4.33040E-06,4.42538E-06/
      DATA (TOTPLNK(I,10),I=151,181)/
     &4.52180E-06,4.61969E-06,4.71905E-06,4.81991E-06,4.92226E-06,
     &5.02611E-06,5.13148E-06,5.23839E-06,5.34681E-06,5.45681E-06,
     &5.56835E-06,5.68146E-06,5.79614E-06,5.91242E-06,6.03030E-06,
     &6.14978E-06,6.27088E-06,6.39360E-06,6.51798E-06,6.64398E-06,
     &6.77165E-06,6.90099E-06,7.03198E-06,7.16468E-06,7.29906E-06,
     &7.43514E-06,7.57294E-06,7.71244E-06,7.85369E-06,7.99666E-06,
     &8.14138E-06/
      DATA (TOTPLNK(I,11),I=1,50)/
     &2.53767E-09,2.77242E-09,3.02564E-09,3.29851E-09,3.59228E-09,
     &3.90825E-09,4.24777E-09,4.61227E-09,5.00322E-09,5.42219E-09,
     &5.87080E-09,6.35072E-09,6.86370E-09,7.41159E-09,7.99628E-09,
     &8.61974E-09,9.28404E-09,9.99130E-09,1.07437E-08,1.15436E-08,
     &1.23933E-08,1.32953E-08,1.42522E-08,1.52665E-08,1.63410E-08,
     &1.74786E-08,1.86820E-08,1.99542E-08,2.12985E-08,2.27179E-08,
     &2.42158E-08,2.57954E-08,2.74604E-08,2.92141E-08,3.10604E-08,
     &3.30029E-08,3.50457E-08,3.71925E-08,3.94476E-08,4.18149E-08,
     &4.42991E-08,4.69043E-08,4.96352E-08,5.24961E-08,5.54921E-08,
     &5.86277E-08,6.19081E-08,6.53381E-08,6.89231E-08,7.26681E-08/
      DATA (TOTPLNK(I,11),I=51,100)/
     &7.65788E-08,8.06604E-08,8.49187E-08,8.93591E-08,9.39879E-08,
     &9.88106E-08,1.03834E-07,1.09063E-07,1.14504E-07,1.20165E-07,
     &1.26051E-07,1.32169E-07,1.38525E-07,1.45128E-07,1.51982E-07,
     &1.59096E-07,1.66477E-07,1.74132E-07,1.82068E-07,1.90292E-07,
     &1.98813E-07,2.07638E-07,2.16775E-07,2.26231E-07,2.36015E-07,
     &2.46135E-07,2.56599E-07,2.67415E-07,2.78592E-07,2.90137E-07,
     &3.02061E-07,3.14371E-07,3.27077E-07,3.40186E-07,3.53710E-07,
     &3.67655E-07,3.82031E-07,3.96848E-07,4.12116E-07,4.27842E-07,
     &4.44039E-07,4.60713E-07,4.77876E-07,4.95537E-07,5.13706E-07,
     &5.32392E-07,5.51608E-07,5.71360E-07,5.91662E-07,6.12521E-07/
      DATA (TOTPLNK(I,11),I=101,150)/
     &6.33950E-07,6.55958E-07,6.78556E-07,7.01753E-07,7.25562E-07,
     &7.49992E-07,7.75055E-07,8.00760E-07,8.27120E-07,8.54145E-07,
     &8.81845E-07,9.10233E-07,9.39318E-07,9.69113E-07,9.99627E-07,
     &1.03087E-06,1.06286E-06,1.09561E-06,1.12912E-06,1.16340E-06,
     &1.19848E-06,1.23435E-06,1.27104E-06,1.30855E-06,1.34690E-06,
     &1.38609E-06,1.42614E-06,1.46706E-06,1.50886E-06,1.55155E-06,
     &1.59515E-06,1.63967E-06,1.68512E-06,1.73150E-06,1.77884E-06,
     &1.82715E-06,1.87643E-06,1.92670E-06,1.97797E-06,2.03026E-06,
     &2.08356E-06,2.13791E-06,2.19330E-06,2.24975E-06,2.30728E-06,
     &2.36589E-06,2.42560E-06,2.48641E-06,2.54835E-06,2.61142E-06/
      DATA (TOTPLNK(I,11),I=151,181)/
     &2.67563E-06,2.74100E-06,2.80754E-06,2.87526E-06,2.94417E-06,
     &3.01429E-06,3.08562E-06,3.15819E-06,3.23199E-06,3.30704E-06,
     &3.38336E-06,3.46096E-06,3.53984E-06,3.62002E-06,3.70151E-06,
     &3.78433E-06,3.86848E-06,3.95399E-06,4.04084E-06,4.12907E-06,
     &4.21868E-06,4.30968E-06,4.40209E-06,4.49592E-06,4.59117E-06,
     &4.68786E-06,4.78600E-06,4.88561E-06,4.98669E-06,5.08926E-06,
     &5.19332E-06/
      DATA (TOTPLNK(I,12),I=1,50)/
     &2.73921E-10,3.04500E-10,3.38056E-10,3.74835E-10,4.15099E-10,
     &4.59126E-10,5.07214E-10,5.59679E-10,6.16857E-10,6.79103E-10,
     &7.46796E-10,8.20335E-10,9.00144E-10,9.86671E-10,1.08039E-09,
     &1.18180E-09,1.29142E-09,1.40982E-09,1.53757E-09,1.67529E-09,
     &1.82363E-09,1.98327E-09,2.15492E-09,2.33932E-09,2.53726E-09,
     &2.74957E-09,2.97710E-09,3.22075E-09,3.48145E-09,3.76020E-09,
     &4.05801E-09,4.37595E-09,4.71513E-09,5.07672E-09,5.46193E-09,
     &5.87201E-09,6.30827E-09,6.77205E-09,7.26480E-09,7.78794E-09,
     &8.34304E-09,8.93163E-09,9.55537E-09,1.02159E-08,1.09151E-08,
     &1.16547E-08,1.24365E-08,1.32625E-08,1.41348E-08,1.50554E-08/
      DATA (TOTPLNK(I,12),I=51,100)/
     &1.60264E-08,1.70500E-08,1.81285E-08,1.92642E-08,2.04596E-08,
     &2.17171E-08,2.30394E-08,2.44289E-08,2.58885E-08,2.74209E-08,
     &2.90290E-08,3.07157E-08,3.24841E-08,3.43371E-08,3.62782E-08,
     &3.83103E-08,4.04371E-08,4.26617E-08,4.49878E-08,4.74190E-08,
     &4.99589E-08,5.26113E-08,5.53801E-08,5.82692E-08,6.12826E-08,
     &6.44245E-08,6.76991E-08,7.11105E-08,7.46634E-08,7.83621E-08,
     &8.22112E-08,8.62154E-08,9.03795E-08,9.47081E-08,9.92066E-08,
     &1.03879E-07,1.08732E-07,1.13770E-07,1.18998E-07,1.24422E-07,
     &1.30048E-07,1.35880E-07,1.41924E-07,1.48187E-07,1.54675E-07,
     &1.61392E-07,1.68346E-07,1.75543E-07,1.82988E-07,1.90688E-07/
      DATA (TOTPLNK(I,12),I=101,150)/
     &1.98650E-07,2.06880E-07,2.15385E-07,2.24172E-07,2.33247E-07,
     &2.42617E-07,2.52289E-07,2.62272E-07,2.72571E-07,2.83193E-07,
     &2.94147E-07,3.05440E-07,3.17080E-07,3.29074E-07,3.41430E-07,
     &3.54155E-07,3.67259E-07,3.80747E-07,3.94631E-07,4.08916E-07,
     &4.23611E-07,4.38725E-07,4.54267E-07,4.70245E-07,4.86666E-07,
     &5.03541E-07,5.20879E-07,5.38687E-07,5.56975E-07,5.75751E-07,
     &5.95026E-07,6.14808E-07,6.35107E-07,6.55932E-07,6.77293E-07,
     &6.99197E-07,7.21656E-07,7.44681E-07,7.68278E-07,7.92460E-07,
     &8.17235E-07,8.42614E-07,8.68606E-07,8.95223E-07,9.22473E-07,
     &9.50366E-07,9.78915E-07,1.00813E-06,1.03802E-06,1.06859E-06/
      DATA (TOTPLNK(I,12),I=151,181)/
     &1.09986E-06,1.13184E-06,1.16453E-06,1.19796E-06,1.23212E-06,
     &1.26703E-06,1.30270E-06,1.33915E-06,1.37637E-06,1.41440E-06,
     &1.45322E-06,1.49286E-06,1.53333E-06,1.57464E-06,1.61679E-06,
     &1.65981E-06,1.70370E-06,1.74847E-06,1.79414E-06,1.84071E-06,
     &1.88821E-06,1.93663E-06,1.98599E-06,2.03631E-06,2.08759E-06,
     &2.13985E-06,2.19310E-06,2.24734E-06,2.30260E-06,2.35888E-06,
     &2.41619E-06/
      DATA (TOTPLNK(I,13),I=1,50)/
     &4.53634E-11,5.11435E-11,5.75754E-11,6.47222E-11,7.26531E-11,
     &8.14420E-11,9.11690E-11,1.01921E-10,1.13790E-10,1.26877E-10,
     &1.41288E-10,1.57140E-10,1.74555E-10,1.93665E-10,2.14613E-10,
     &2.37548E-10,2.62633E-10,2.90039E-10,3.19948E-10,3.52558E-10,
     &3.88073E-10,4.26716E-10,4.68719E-10,5.14331E-10,5.63815E-10,
     &6.17448E-10,6.75526E-10,7.38358E-10,8.06277E-10,8.79625E-10,
     &9.58770E-10,1.04410E-09,1.13602E-09,1.23495E-09,1.34135E-09,
     &1.45568E-09,1.57845E-09,1.71017E-09,1.85139E-09,2.00268E-09,
     &2.16464E-09,2.33789E-09,2.52309E-09,2.72093E-09,2.93212E-09,
     &3.15740E-09,3.39757E-09,3.65341E-09,3.92579E-09,4.21559E-09/
      DATA (TOTPLNK(I,13),I=51,100)/
     &4.52372E-09,4.85115E-09,5.19886E-09,5.56788E-09,5.95928E-09,
     &6.37419E-09,6.81375E-09,7.27917E-09,7.77168E-09,8.29256E-09,
     &8.84317E-09,9.42487E-09,1.00391E-08,1.06873E-08,1.13710E-08,
     &1.20919E-08,1.28515E-08,1.36514E-08,1.44935E-08,1.53796E-08,
     &1.63114E-08,1.72909E-08,1.83201E-08,1.94008E-08,2.05354E-08,
     &2.17258E-08,2.29742E-08,2.42830E-08,2.56545E-08,2.70910E-08,
     &2.85950E-08,3.01689E-08,3.18155E-08,3.35373E-08,3.53372E-08,
     &3.72177E-08,3.91818E-08,4.12325E-08,4.33727E-08,4.56056E-08,
     &4.79342E-08,5.03617E-08,5.28915E-08,5.55270E-08,5.82715E-08,
     &6.11286E-08,6.41019E-08,6.71951E-08,7.04119E-08,7.37560E-08/
      DATA (TOTPLNK(I,13),I=101,150)/
     &7.72315E-08,8.08424E-08,8.45927E-08,8.84866E-08,9.25281E-08,
     &9.67218E-08,1.01072E-07,1.05583E-07,1.10260E-07,1.15107E-07,
     &1.20128E-07,1.25330E-07,1.30716E-07,1.36291E-07,1.42061E-07,
     &1.48031E-07,1.54206E-07,1.60592E-07,1.67192E-07,1.74015E-07,
     &1.81064E-07,1.88345E-07,1.95865E-07,2.03628E-07,2.11643E-07,
     &2.19912E-07,2.28443E-07,2.37244E-07,2.46318E-07,2.55673E-07,
     &2.65316E-07,2.75252E-07,2.85489E-07,2.96033E-07,3.06891E-07,
     &3.18070E-07,3.29576E-07,3.41417E-07,3.53600E-07,3.66133E-07,
     &3.79021E-07,3.92274E-07,4.05897E-07,4.19899E-07,4.34288E-07,
     &4.49071E-07,4.64255E-07,4.79850E-07,4.95863E-07,5.12300E-07/
      DATA (TOTPLNK(I,13),I=151,181)/
     &5.29172E-07,5.46486E-07,5.64250E-07,5.82473E-07,6.01164E-07,
     &6.20329E-07,6.39979E-07,6.60122E-07,6.80767E-07,7.01922E-07,
     &7.23596E-07,7.45800E-07,7.68539E-07,7.91826E-07,8.15669E-07,
     &8.40076E-07,8.65058E-07,8.90623E-07,9.16783E-07,9.43544E-07,
     &9.70917E-07,9.98912E-07,1.02754E-06,1.05681E-06,1.08673E-06,
     &1.11731E-06,1.14856E-06,1.18050E-06,1.21312E-06,1.24645E-06,
     &1.28049E-06/
      DATA (TOTPLNK(I,14),I=1,50)/
     &1.40113E-11,1.59358E-11,1.80960E-11,2.05171E-11,2.32266E-11,
     &2.62546E-11,2.96335E-11,3.33990E-11,3.75896E-11,4.22469E-11,
     &4.74164E-11,5.31466E-11,5.94905E-11,6.65054E-11,7.42522E-11,
     &8.27975E-11,9.22122E-11,1.02573E-10,1.13961E-10,1.26466E-10,
     &1.40181E-10,1.55206E-10,1.71651E-10,1.89630E-10,2.09265E-10,
     &2.30689E-10,2.54040E-10,2.79467E-10,3.07128E-10,3.37190E-10,
     &3.69833E-10,4.05243E-10,4.43623E-10,4.85183E-10,5.30149E-10,
     &5.78755E-10,6.31255E-10,6.87910E-10,7.49002E-10,8.14824E-10,
     &8.85687E-10,9.61914E-10,1.04385E-09,1.13186E-09,1.22631E-09,
     &1.32761E-09,1.43617E-09,1.55243E-09,1.67686E-09,1.80992E-09/
      DATA (TOTPLNK(I,14),I=51,100)/
     &1.95212E-09,2.10399E-09,2.26607E-09,2.43895E-09,2.62321E-09,
     &2.81949E-09,3.02844E-09,3.25073E-09,3.48707E-09,3.73820E-09,
     &4.00490E-09,4.28794E-09,4.58819E-09,4.90647E-09,5.24371E-09,
     &5.60081E-09,5.97875E-09,6.37854E-09,6.80120E-09,7.24782E-09,
     &7.71950E-09,8.21740E-09,8.74271E-09,9.29666E-09,9.88054E-09,
     &1.04956E-08,1.11434E-08,1.18251E-08,1.25422E-08,1.32964E-08,
     &1.40890E-08,1.49217E-08,1.57961E-08,1.67140E-08,1.76771E-08,
     &1.86870E-08,1.97458E-08,2.08553E-08,2.20175E-08,2.32342E-08,
     &2.45077E-08,2.58401E-08,2.72334E-08,2.86900E-08,3.02122E-08,
     &3.18021E-08,3.34624E-08,3.51954E-08,3.70037E-08,3.88899E-08/
      DATA (TOTPLNK(I,14),I=101,150)/
     &4.08568E-08,4.29068E-08,4.50429E-08,4.72678E-08,4.95847E-08,
     &5.19963E-08,5.45058E-08,5.71161E-08,5.98309E-08,6.26529E-08,
     &6.55857E-08,6.86327E-08,7.17971E-08,7.50829E-08,7.84933E-08,
     &8.20323E-08,8.57035E-08,8.95105E-08,9.34579E-08,9.75488E-08,
     &1.01788E-07,1.06179E-07,1.10727E-07,1.15434E-07,1.20307E-07,
     &1.25350E-07,1.30566E-07,1.35961E-07,1.41539E-07,1.47304E-07,
     &1.53263E-07,1.59419E-07,1.65778E-07,1.72345E-07,1.79124E-07,
     &1.86122E-07,1.93343E-07,2.00792E-07,2.08476E-07,2.16400E-07,
     &2.24568E-07,2.32988E-07,2.41666E-07,2.50605E-07,2.59813E-07,
     &2.69297E-07,2.79060E-07,2.89111E-07,2.99455E-07,3.10099E-07/
      DATA (TOTPLNK(I,14),I=151,181)/
     &3.21049E-07,3.32311E-07,3.43893E-07,3.55801E-07,3.68041E-07,
     &3.80621E-07,3.93547E-07,4.06826E-07,4.20465E-07,4.34473E-07,
     &4.48856E-07,4.63620E-07,4.78774E-07,4.94325E-07,5.10280E-07,
     &5.26648E-07,5.43436E-07,5.60652E-07,5.78302E-07,5.96397E-07,
     &6.14943E-07,6.33949E-07,6.53421E-07,6.73370E-07,6.93803E-07,
     &7.14731E-07,7.36157E-07,7.58095E-07,7.80549E-07,8.03533E-07,
     &8.27050E-07/
      DATA (TOTPLNK(I,15),I=1,50)/
     &3.90483E-12,4.47999E-12,5.13122E-12,5.86739E-12,6.69829E-12,
     &7.63467E-12,8.68833E-12,9.87221E-12,1.12005E-11,1.26885E-11,
     &1.43534E-11,1.62134E-11,1.82888E-11,2.06012E-11,2.31745E-11,
     &2.60343E-11,2.92087E-11,3.27277E-11,3.66242E-11,4.09334E-11,
     &4.56935E-11,5.09455E-11,5.67338E-11,6.31057E-11,7.01127E-11,
     &7.78096E-11,8.62554E-11,9.55130E-11,1.05651E-10,1.16740E-10,
     &1.28858E-10,1.42089E-10,1.56519E-10,1.72243E-10,1.89361E-10,
     &2.07978E-10,2.28209E-10,2.50173E-10,2.73999E-10,2.99820E-10,
     &3.27782E-10,3.58034E-10,3.90739E-10,4.26067E-10,4.64196E-10,
     &5.05317E-10,5.49631E-10,5.97347E-10,6.48689E-10,7.03891E-10/
      DATA (TOTPLNK(I,15),I=51,100)/
     &7.63201E-10,8.26876E-10,8.95192E-10,9.68430E-10,1.04690E-09,
     &1.13091E-09,1.22079E-09,1.31689E-09,1.41957E-09,1.52922E-09,
     &1.64623E-09,1.77101E-09,1.90401E-09,2.04567E-09,2.19647E-09,
     &2.35690E-09,2.52749E-09,2.70875E-09,2.90127E-09,3.10560E-09,
     &3.32238E-09,3.55222E-09,3.79578E-09,4.05375E-09,4.32682E-09,
     &4.61574E-09,4.92128E-09,5.24420E-09,5.58536E-09,5.94558E-09,
     &6.32575E-09,6.72678E-09,7.14964E-09,7.59526E-09,8.06470E-09,
     &8.55897E-09,9.07916E-09,9.62638E-09,1.02018E-08,1.08066E-08,
     &1.14420E-08,1.21092E-08,1.28097E-08,1.35446E-08,1.43155E-08,
     &1.51237E-08,1.59708E-08,1.68581E-08,1.77873E-08,1.87599E-08/
      DATA (TOTPLNK(I,15),I=101,150)/
     &1.97777E-08,2.08423E-08,2.19555E-08,2.31190E-08,2.43348E-08,
     &2.56045E-08,2.69302E-08,2.83140E-08,2.97578E-08,3.12636E-08,
     &3.28337E-08,3.44702E-08,3.61755E-08,3.79516E-08,3.98012E-08,
     &4.17265E-08,4.37300E-08,4.58143E-08,4.79819E-08,5.02355E-08,
     &5.25777E-08,5.50114E-08,5.75393E-08,6.01644E-08,6.28896E-08,
     &6.57177E-08,6.86521E-08,7.16959E-08,7.48520E-08,7.81239E-08,
     &8.15148E-08,8.50282E-08,8.86675E-08,9.24362E-08,9.63380E-08,
     &1.00376E-07,1.04555E-07,1.08878E-07,1.13349E-07,1.17972E-07,
     &1.22751E-07,1.27690E-07,1.32793E-07,1.38064E-07,1.43508E-07,
     &1.49129E-07,1.54931E-07,1.60920E-07,1.67099E-07,1.73473E-07/
      DATA (TOTPLNK(I,15),I=151,181)/
     &1.80046E-07,1.86825E-07,1.93812E-07,2.01014E-07,2.08436E-07,
     &2.16082E-07,2.23957E-07,2.32067E-07,2.40418E-07,2.49013E-07,
     &2.57860E-07,2.66963E-07,2.76328E-07,2.85961E-07,2.95868E-07,
     &3.06053E-07,3.16524E-07,3.27286E-07,3.38345E-07,3.49707E-07,
     &3.61379E-07,3.73367E-07,3.85676E-07,3.98315E-07,4.11287E-07,
     &4.24602E-07,4.38265E-07,4.52283E-07,4.66662E-07,4.81410E-07,
     &4.96535E-07/
      DATA (TOTPLNK(I,16),I=1,50)/
     &0.28639E-12,0.33349E-12,0.38764E-12,0.44977E-12,0.52093E-12,
     &0.60231E-12,0.69522E-12,0.80111E-12,0.92163E-12,0.10586E-11,
     &0.12139E-11,0.13899E-11,0.15890E-11,0.18138E-11,0.20674E-11,
     &0.23531E-11,0.26744E-11,0.30352E-11,0.34401E-11,0.38936E-11,
     &0.44011E-11,0.49681E-11,0.56010E-11,0.63065E-11,0.70919E-11,
     &0.79654E-11,0.89357E-11,0.10012E-10,0.11205E-10,0.12526E-10,
     &0.13986E-10,0.15600E-10,0.17380E-10,0.19342E-10,0.21503E-10,
     &0.23881E-10,0.26494E-10,0.29362E-10,0.32509E-10,0.35958E-10,
     &0.39733E-10,0.43863E-10,0.48376E-10,0.53303E-10,0.58679E-10,
     &0.64539E-10,0.70920E-10,0.77864E-10,0.85413E-10,0.93615E-10/
      DATA (TOTPLNK(I,16),I=51,100)/
     &0.10252E-09,0.11217E-09,0.12264E-09,0.13397E-09,0.14624E-09,
     &0.15950E-09,0.17383E-09,0.18930E-09,0.20599E-09,0.22399E-09,
     &0.24339E-09,0.26427E-09,0.28674E-09,0.31090E-09,0.33686E-09,
     &0.36474E-09,0.39466E-09,0.42676E-09,0.46115E-09,0.49800E-09,
     &0.53744E-09,0.57964E-09,0.62476E-09,0.67298E-09,0.72448E-09,
     &0.77945E-09,0.83809E-09,0.90062E-09,0.96725E-09,0.10382E-08,
     &0.11138E-08,0.11941E-08,0.12796E-08,0.13704E-08,0.14669E-08,
     &0.15694E-08,0.16781E-08,0.17934E-08,0.19157E-08,0.20453E-08,
     &0.21825E-08,0.23278E-08,0.24815E-08,0.26442E-08,0.28161E-08,
     &0.29978E-08,0.31898E-08,0.33925E-08,0.36064E-08,0.38321E-08/
      DATA (TOTPLNK(I,16),I=101,150)/
     &0.40700E-08,0.43209E-08,0.45852E-08,0.48636E-08,0.51567E-08,
     &0.54652E-08,0.57897E-08,0.61310E-08,0.64897E-08,0.68667E-08,
     &0.72626E-08,0.76784E-08,0.81148E-08,0.85727E-08,0.90530E-08,
     &0.95566E-08,0.10084E-07,0.10638E-07,0.11217E-07,0.11824E-07,
     &0.12458E-07,0.13123E-07,0.13818E-07,0.14545E-07,0.15305E-07,
     &0.16099E-07,0.16928E-07,0.17795E-07,0.18699E-07,0.19643E-07,
     &0.20629E-07,0.21656E-07,0.22728E-07,0.23845E-07,0.25010E-07,
     &0.26223E-07,0.27487E-07,0.28804E-07,0.30174E-07,0.31600E-07,
     &0.33084E-07,0.34628E-07,0.36233E-07,0.37902E-07,0.39637E-07,
     &0.41440E-07,0.43313E-07,0.45259E-07,0.47279E-07,0.49376E-07/
      DATA (TOTPLNK(I,16),I=151,181)/
     &0.51552E-07,0.53810E-07,0.56153E-07,0.58583E-07,0.61102E-07,
     &0.63713E-07,0.66420E-07,0.69224E-07,0.72129E-07,0.75138E-07,
     &0.78254E-07,0.81479E-07,0.84818E-07,0.88272E-07,0.91846E-07,
     &0.95543E-07,0.99366E-07,0.10332E-06,0.10740E-06,0.11163E-06,
     &0.11599E-06,0.12050E-06,0.12515E-06,0.12996E-06,0.13493E-06,
     &0.14005E-06,0.14534E-06,0.15080E-06,0.15643E-06,0.16224E-06,
     &0.16823E-06/
      DATA (TOTPLK16(I),I=1,50)/
     &0.28481E-12,0.33159E-12,0.38535E-12,0.44701E-12,0.51763E-12,
     &0.59836E-12,0.69049E-12,0.79549E-12,0.91493E-12,0.10506E-11,
     &0.12045E-11,0.13788E-11,0.15758E-11,0.17984E-11,0.20493E-11,
     &0.23317E-11,0.26494E-11,0.30060E-11,0.34060E-11,0.38539E-11,
     &0.43548E-11,0.49144E-11,0.55387E-11,0.62344E-11,0.70086E-11,
     &0.78692E-11,0.88248E-11,0.98846E-11,0.11059E-10,0.12358E-10,
     &0.13794E-10,0.15379E-10,0.17128E-10,0.19055E-10,0.21176E-10,
     &0.23508E-10,0.26070E-10,0.28881E-10,0.31963E-10,0.35339E-10,
     &0.39034E-10,0.43073E-10,0.47484E-10,0.52299E-10,0.57548E-10,
     &0.63267E-10,0.69491E-10,0.76261E-10,0.83616E-10,0.91603E-10/
      DATA (TOTPLK16(I),I=51,100)/
     &0.10027E-09,0.10966E-09,0.11983E-09,0.13084E-09,0.14275E-09,
     &0.15562E-09,0.16951E-09,0.18451E-09,0.20068E-09,0.21810E-09,
     &0.23686E-09,0.25704E-09,0.27875E-09,0.30207E-09,0.32712E-09,
     &0.35400E-09,0.38282E-09,0.41372E-09,0.44681E-09,0.48223E-09,
     &0.52013E-09,0.56064E-09,0.60392E-09,0.65015E-09,0.69948E-09,
     &0.75209E-09,0.80818E-09,0.86794E-09,0.93157E-09,0.99929E-09,
     &0.10713E-08,0.11479E-08,0.12293E-08,0.13157E-08,0.14074E-08,
     &0.15047E-08,0.16079E-08,0.17172E-08,0.18330E-08,0.19557E-08,
     &0.20855E-08,0.22228E-08,0.23680E-08,0.25214E-08,0.26835E-08,
     &0.28546E-08,0.30352E-08,0.32257E-08,0.34266E-08,0.36384E-08/
      DATA (TOTPLK16(I),I=101,150)/
     &0.38615E-08,0.40965E-08,0.43438E-08,0.46041E-08,0.48779E-08,
     &0.51658E-08,0.54683E-08,0.57862E-08,0.61200E-08,0.64705E-08,
     &0.68382E-08,0.72240E-08,0.76285E-08,0.80526E-08,0.84969E-08,
     &0.89624E-08,0.94498E-08,0.99599E-08,0.10494E-07,0.11052E-07,
     &0.11636E-07,0.12246E-07,0.12884E-07,0.13551E-07,0.14246E-07,
     &0.14973E-07,0.15731E-07,0.16522E-07,0.17347E-07,0.18207E-07,
     &0.19103E-07,0.20037E-07,0.21011E-07,0.22024E-07,0.23079E-07,
     &0.24177E-07,0.25320E-07,0.26508E-07,0.27744E-07,0.29029E-07,
     &0.30365E-07,0.31753E-07,0.33194E-07,0.34691E-07,0.36246E-07,
     &0.37859E-07,0.39533E-07,0.41270E-07,0.43071E-07,0.44939E-07/
      DATA (TOTPLK16(I),I=151,181)/
     &0.46875E-07,0.48882E-07,0.50961E-07,0.53115E-07,0.55345E-07,
     &0.57655E-07,0.60046E-07,0.62520E-07,0.65080E-07,0.67728E-07,
     &0.70466E-07,0.73298E-07,0.76225E-07,0.79251E-07,0.82377E-07,
     &0.85606E-07,0.88942E-07,0.92386E-07,0.95942E-07,0.99612E-07,
     &0.10340E-06,0.10731E-06,0.11134E-06,0.11550E-06,0.11979E-06,
     &0.12421E-06,0.12876E-06,0.13346E-06,0.13830E-06,0.14328E-06,
     &0.14841E-06/
      END
