
*  Created by Antigona Segura. April 4, 2005.
       
       program couple

*  This program runs the climate and photochemical model in a coupled mode
*  and generates an output file for diagnostics
       INCLUDE 'CLIMA/INCLUDECLIM/parND.inc'
       INCLUDE 'CLIMA/INCLUDECLIM/parNSOL_NSOLUV.inc'
       INCLUDE 'ATMCHEM/INCLUDECHEM/parNZ.inc'
       INCLUDE 'ATMCHEM/INCLUDECHEM/parNQ_NQT.inc'
       INCLUDE 'ATMCHEM/INCLUDECHEM/parNSP_NSP1_NSP2.inc'

       CHARACTER :: STARR*3,dirIO*2

c Common blocks with CLIMATE model
      INCLUDE 'INCLUDECOUP/comCLIM.inc'
      INCLUDE 'INCLUDECOUP/comFLUXCLIMA.inc'

c Common blocks with PHOTOCHEMICAL model
      INCLUDE 'INCLUDECOUP/comPHOT.inc'
      INCLUDE 'INCLUDECOUP/comO3SAV.inc'
      INCLUDE 'ATMCHEM/INCLUDECHEM/comFLUXPHOTO.inc'

      INCLUDE 'INCLUDECOUP/comDIAG.inc'
      INCLUDE 'INCLUDECOUP/comSTR.inc'
      dirIO = 'IO'

c OUTPUT FILES
      open(unit=1, file= dirIO//'/output_couple.dat')
      OPEN(UNIT=51,FILE= dirIO//'/clima_allout.tab')
      OPEN(unit=90,file= dirIO//'/outchem.dat') 
  
      IMODEL = 3
      niter = 1
c Choose a star
      write(*,*)'Choose a star: Sun, F2V, K2V, or dMV'

      write(*,*)'Write it exactely as is shown'
      read(*,'(A3)') STARR
c Choose programs
      write(*,*)'Do you want to run the coupled mode?'
      write(*,*)'0- no, 1-yes'
      read(*,*)ICOUPLE
      
      if(ICOUPLE.eq.0) then
       write(*,*)'What model do you want to use?'
       write(*,*)'0-climate, 1-photochemical'
       read(*,*) IMODEL
      else
       write(*,*)'How many iterations between both models?'
       read(*,*) niter
      endif
      
c  Choose ir scheme in clima.f
      if(IMODEL.ne.1) then
c Parameters to run the climate model
       write(*,*)'For the climate model:'
       write(*,*)'Number of steps (200 recommended for coupled mode)'
       read(*,*)NSTEPSC
      endif
c Photochemical model 
      if(IMODEL.eq.1.or.ICOUPLE.eq.1) then
       write(*,*)'For the photochemical model:'
       write(*,*)'Number of steps (400 recommended for coupled mode)'
       read(*,*)NSTEPSP
      endif
 
c Read star flux for the photochemical model
      if(IMODEL.eq.1.or.ICOUPLE.eq.1) call readstar
c Read star flux for the climate model
      if(IMODEL.eq.0.or.ICOUPLe.eq.1)call choose_star(FLUXC,FLUXUV)
      IRCHOICE = 0 
c Starting loop for steady-state equilibrium
      do 1 ncouple=1,niter   !START steady-state loop
c Running the climate code
       if(IMODEL.eq.0.or.ICOUPLE.eq.1) then
       DTC = 1.e4       !initial time step (s)
       dtmax = 1.e5      !maximum time step (s)
       TSTOP = 1.e7
       TIMEC = 1.e10
       CALL CLIMA(IRCHOICE,ICOUPLE,DTC,NSTEPSC,dtmax,TSTOP,TIMEC)
       endif
c Running the photochemical code
       if(IMODEL.eq.1.or.ICOUPLE.eq.1)then
       DTP = 1.e-4      !initial time step
       TSTOP = 5.e17
       CALL ATM_CHEM(ICOUPLE,TSTOP,DTP,NSTEPSP,TIME)
       endif
c Calculating diagnostic parameters for stady-state convergence
       if (ICOUPLE.eq.0) go to 3
        call diagnostic(nconvdif)
        if(nconvdif.ne.0) then
        close(51)
        close(90)
        OPEN(UNIT=51,FILE= dirIO//'/clima_allout.tab')
        OPEN(unit=90,file= dirIO//'/outchem.dat')
       endif
       if(ncouple.eq.niter.and.nconvdif.ne.0) then
       write(1,*)'** WARNING: STEADY STATE SOLUTION NOT REACHED **'
       call outdiag(ncouple)
       print*,'*** WARNING: STEADY STATE SOLUTION NOT REACHED ***'
       STOP
       endif
       if(nconvdif.eq.0) go to 2     
  1   enddo                  !END steady-state loop 
  
c Printing diagnostic parameters for the steady solution
  2   call outdiag(ncouple)
      call outatmos
      stop

  3   close(51)
      close(90)
      stop
      end          


*******************
      subroutine diagnostic(nconvdif)
c This subroutine indicates when the photochemical and
c climate model have reached convergence
       INCLUDE 'CLIMA/INCLUDECLIM/parND.inc'
       INCLUDE 'ATMCHEM/INCLUDECHEM/parNZ.inc'
       INCLUDE 'ATMCHEM/INCLUDECHEM/parNQ_NQT.inc'
       INCLUDE 'ATMCHEM/INCLUDECHEM/parNSP_NSP1_NSP2.inc'

c Common blocks with CLIMATE model
      INCLUDE 'INCLUDECOUP/comCLIM.inc'

c Common blocks with PHOTOCHEMICAL model
      INCLUDE 'INCLUDECOUP/comPHOT.inc'
      INCLUDE 'INCLUDECOUP/comO3SAV.inc'

      INCLUDE 'INCLUDECOUP/comDIAG.inc'

      nconver = 0
      nconv1 = 0
      nconv2 = 0
      nconv3= 0

c equilibrium conditions for the photochemical model
c   *** for species with fixed surface flux
      numlb2tot = 0
      numlb2 =0
      do i=1,NQT
       if(LLBOUND(i).eq.2)then
        nconv1 = 1
        numlb2tot = numlb2tot + 1
        dflux(i) = XFLOW(i)/XSGFLUX(i)
        if(dflux(i).ge.0.99.and.dflux(i).le.1.01) 
     &   numlb2 = numlb2 + 1
       endif 
      enddo
      if(numlb2.gt.0) then
        perlb2= numlb2/numlb2tot
        if(perlb2.eq.1.)nconver=nconver+1
      endif 
c   *** for species with fixed mixing ratio
      numlb1tot = 0
      numlb1 =0
      do i=4,NQT
       if(LLBOUND(i).eq.1) then
        nconv2 = 1
        numlb1tot = numlb1tot + 1
        dlflux(i) = XFLOW(i)/XTL(i)
        if(i.eq.9) then
          dmixh2 = XUSOL(i,1)/FH2
          if(dmixh2.ge.0.99.and.dmixh2.le.1.01) 
     &    numlb1 = numlb1 + 1
        endif
        if(i.eq.10)then
          dmixch4 = XUSOL(i,1)/FCH4
          if(dmixch4.ge.0.99.and.dmixch4.le.1.01) 
     &    numlb1 = numlb1 + 1
        endif
        if(i.eq.11)then
          dmixco = XUSOL(i,1)/FCO
          if(dmixco.ge.0.99.and.dmixco.le.1.01) 
     &    numlb1 = numlb1 + 1
        endif
        if(i.eq.14)then
          dmixn2o = XUSOL(i,1)/FN2O
          if(dmixn2o.ge.0.99.and.dmixn2o.le.1.01) 
     &    numlb1 = numlb1 + 1
        endif
        if(i.eq.23)then
          dmixch3cl = XUSOL(i,1)/FCH3CL
          if(dmixch3cl.ge.0.99.and.dmixch3cl.le.1.01) 
     &    numlb1 = numlb1 + 1
        endif
       endif
      enddo
      if(numlb1.gt.0)then
       perlb1= numlb1/numlb1tot
       if(perlb1.eq.1.)nconver=nconver+1
      endif
c   *** for species with fixed surface flux
      numlb0tot = 0
      numlb0 =0
      do i=1,NQT
       if(LLBOUND(i).eq.0) then
        nconv3 = 1
        numlb0tot = numlb0tot + 1 
        dlospro(i) = XTL(i)/XTP(i)
         if(dlospro(i).ge.0.9.and.dlospro(i).le.1.1) 
     &   numlb0 = numlb0 + 1
       endif
      enddo      
      if(numlb0.gt.0) then 
       perlb0= (numlb0*1.)/(numlb0tot*1.)
       if(perlb0.ge.0.9)nconver=nconver+1
      endif

c For the ozone column depth
      dO3= XO3COL/O3OLD
      if(dO3.gt.0.98.and.dO3.lt.1.02) nconver =nconver +1
C Equilibrium conditions for the climate code
c  *** Temperature at the surface, the top, the last convective
c   layer and the tropopause
c Ratio of fluxes at the top of the atmosphere (DIVF)
      do i=ND,1,-1
        dtn(i) = abs(Tstart(i)-T(i))
      enddo
      If(dtn(ND).le.1.) nconver = nconver + 1
      if(dtn(1).le.2.) nconver = nconver + 1
      if(dtn(JCOLD).le.1.5)nconver = nconver + 1
      if(dtn(JCONV).le.1.5)nconver = nconver + 1
      if(divf(1).le.1e-3)nconver = nconver + 1
C Summing up the equilibrium conditions
C When all the conditions are reached nconvdif = 0   
      nconvtot = nconv1 + nconv2 + nconv3 + 6
      nconvdif = nconvtot - nconver
      write(*,110)nconver, nconvtot,nconvdif
 110  format(I2,' convergence criteria of ',I2,' have been reached. ',
     & I2,' more need to be reached')
      return
      end
*******************

      subroutine outdiag(ncouple)
       INCLUDE 'CLIMA/INCLUDECLIM/parND.inc'
       INCLUDE 'ATMCHEM/INCLUDECHEM/parNZ.inc'
       INCLUDE 'ATMCHEM/INCLUDECHEM/parNQ_NQT.inc'
       INCLUDE 'ATMCHEM/INCLUDECHEM/parNSP_NSP1_NSP2.inc'

      INCLUDE 'INCLUDECOUP/comCLIM.inc'

      INCLUDE 'INCLUDECOUP/comPHOT.inc'
      INCLUDE 'INCLUDECOUP/comDIAG.inc'


c Printing diagnostic parameters from the steady state solution 
      write(1,100)ncouple
 100  format(/'*** Output file for diagnostics after ',I2,
     &' coupled iterations ***')
      write(1,120)
 120  format(/'*** PHOTOCHEMICAL MODEL output')
      write(1,122)XO3COL
 122  format(/' Ozone column depth = ',1PE11.4,' cm^-2')
      write(1,121)
 121  format(/' Results sorted by Lower Boundary Condition'/) 
      
      ifix = 0
      do i=1,NQT
       if(LLBOUND(i).eq.2) then
         ifix=1
         goto 210
       endif
      enddo
 210  if(ifix.eq.1) then
      write(1,*)' Species with fixed surface FLUX'
      write(1,123)
 123  format(6x,'Specified flux',3x,'Calculated flux',4x,'calc/spec'
     & ,6x, 'TL') 
      do i=1,NQT
       if(LLBOUND(i).eq.2) write(1,130)IISPEC(i),XSGFLUX(i),
     & XFLOW(i),dflux(i),XTL(i)
      enddo
 130  format(1x,A8,2x,1PE9.2,4x,1PE9.2,9x,1PE9.2,3x,1PE9.2)
      endif
      imix = 0
      do i=4,NQT
       if(LLBOUND(i).eq.1) then
         imix=1
         goto 220
       endif
      enddo
 220  if(imix.eq.1) then
      write(1,*)
      write(1,*)' Species with fixed surface MIXING RATIO'
      write(1,124)
 124  format(7x,'Specified M R',3x,'Calculated M R',3x,'calc/spec',
     & 6x,'TL',9x,'TP',9x,'TP/TL') 
      do i=4,NQT
       if(LLBOUND(i).eq.1) then
        if(i.eq.9)write(1,131)IISPEC(i),FH2,XUSOL(i,1),dmixh2,
     & XFLOW(i),XTL(i), dlflux(i)
        if(i.eq.10)write(1,131)IISPEC(i),FCH4,XUSOL(i,1),dmixch4,
     & XFLOW(i),XTL(i), dlflux(i)
        if(i.eq.11)write(1,131)IISPEC(i),FCO,XUSOL(i,1), dmixco,
     & XFLOW(i),XTL(i), dlflux(i)
        if(i.eq.14)write(1,131)IISPEC(i),FN2O,XUSOL(i,1),dmixn2o,
     & XFLOW(i),XTL(i), dlflux(i)
        if(i.eq.23)write(1,131)IISPEC(i),FCH3CL,XUSOL(i,1),dmixch3cl,
     & XFLOW(i),XTL(i), dlflux(i)
       endif
      enddo
 131  format(1x,A8,2x,1PE9.2,4x,1PE9.2,6x,1PE9.2,3x,1PE9.2,
     & 3x,1PE9.2,3x,1PE9.2) 
      endif

      write(1,*)
      write(1,*)' Species with fixed VELOCITY DEPOSITION'
      write(1,125)
 125  format(15x,'TL',9x,'TP',9x,'TL/TP')
      do i=1,NQT
       if(LLBOUND(i).eq.0)write(1,132)IISPEC(i),XTL(i),XTP(i),dlospro(i)
      enddo      
 132  format(1x,A8,2x,1PE9.2,3x,1PE9.2,3x,1PE9.2) 

      write(1,150)
 150  format(/'*** CLIMATE MODEL output'/)
      write(1,*)'  Selected temperatures for diagnostic'
      write(1,151)
 151  format(1x,'Layer',4x,'T_Ncoup-1',7x,'T_Ncoup',7x,'(T_n-1)-(T_n)'
     & ,5x,'DIVF_Nstep')
      do i=ND,1,-1
       if(i.eq.ND.or.i.eq.ND-1)write(1,152)i,Tstart(i),T(i),dtn(i),
     & DIVF(i)
       if(i.eq.JCOLD)then
        write(1,*)' At the cold trap '
        write(1,152)i,Tstart(i),T(i),dtn(i),DIVF(i)
 152  format(1x,I3,4(4x,1PE12.4))
       endif
       if(i.eq.JCONV)then
        write(1,*)' Last convective layer '
        write(1,152)i,Tstart(i),T(i),dtn(i),DIVF(i)
       endif
       if(i.eq.1.or.i.eq.2)write(1,152)i,Tstart(i),T(i),dtn(i),
     & DIVF(i)
      enddo
 
      return
      end
**************************
      subroutine outatmos
c  This subroutine writes the final numbers after the atmosphere
c  has recovered from the flare
       INCLUDE 'CLIMA/INCLUDECLIM/parND.inc'
       INCLUDE 'ATMCHEM/INCLUDECHEM/parNZ.inc'
       INCLUDE 'ATMCHEM/INCLUDECHEM/parNQ_NQT.inc'
       INCLUDE 'ATMCHEM/INCLUDECHEM/parNSP_NSP1_NSP2.inc'

      dimension z(nz),WAV(108),WAVEUV(10)
      INCLUDE 'INCLUDECOUP/comCLIM.inc'

      INCLUDE 'INCLUDECOUP/comPHOT.inc'
      INCLUDE 'ATMCHEM/INCLUDECHEM/comFLUXPHOTO.inc'


      DATA WAV/1762.,1778.,1794.,1810.,1827.,1844.,1861.,1878.,
     & 1896.,1914.,1933.,1952.,1971.,1990.,2010.,2031.,2052.,2073.,
     & 2094.,2117.,2140.,2163.,2187.,2211.,2235.,2260.,2286.,2313.,
     & 2340.,2367.,2396.,2425.,2454.,2485.,2516.,2548.,2581.,2615.,
     & 2650.,2685.,2722.,2759.,2798.,2837.,2878.,2920.,2963.,3008.,
     & 3054.,3101.,3150.,3200.,3250.,3300.,3350.,3400.,3438.,3500.,
     & 3600.,3700.,3800.,3900.,4000.,4100.,4200.,4300.,4400.,4500.,
     & 4600.,4700.,4800.,4900.,5000.,5100.,5200.,5300.,5400.,5500.,
     & 5600.,5700.,5800.,5900.,6000.,6100.,6200.,6300.,6400.,6500.,
     & 6600.,6700.,6800.,6900.,7000.,7100.,7200.,7300.,7400.,7500.,
     & 7600.,7700.,7800.,7900.,8000.,8100.,8200.,8300.,8400.,8500/
c 10 Far UV wavelengths at the lower limit of the interval. 
c The last wavelegth is for Lyman alpha
      data WAVEUV/1725.,1675.,1625.,1575.,1525.,1475.,1425.,
     &            1375.,1325.,1216./

      ifile = 1
      
      write(1,169) 
 169  format(/2x,'** PARAMETERS OF THE ATMOSPHERE AT STEADY STATE **')
      write(ifile,171)XO3COL
 171  format(//1x,'Ozone column depth = ', 1pe11.4,' cm^-2')
      write(ifile,172)

 172  format(/3X,'*** Surface fluxes (cm^-2 s^-1) ***'/)
      write(ifile,173)IISPEC(9),IISPEC(10),IISPEC(11),
     & IISPEC(14),IISPEC(23)
      write(ifile,174)XFLOW(9),XFLOW(10),XFLOW(11),
     & XFLOW(14),XFLOW(23)
 173  FORMAT(5X,6(A6,5X))
 174  FORMAT(6(1X,1PE10.3))
 
      write(ifile,175)
 175  FORMAT(/3X,'*** Mixing ratios ***'/)
c printing mixing ratios of: H2O,H2,CH4,CO,N2O,H3Cl
      write(ifile,176)IISPEC(3),IISPEC(9),IISPEC(10),IISPEC(11),
     & IISPEC(14),IISPEC(23)
 176  FORMAT(1X,'Z (km)',4X,6(A8,2X))
      do i=1,NZ
        z(i) = i - 1. + 0.5
        write(ifile,177) Z(I),XUSOL(3,i),XUSOL(9,i),XUSOL(10,i),
     &  XUSOL(11,i),XUSOL(14,i),XUSOL(23,i)
      enddo
 177  FORMAT(1x,f5.2,2X,1P6E10.3)
      

      write(ifile,178)
 178  format(/3X,'*** Number densities (cm^-3) ***'/)
      write(ifile,179) IISPEC(4),IISPEC(7)
 179  format(2x,'Z(km)',4x,'Total',4x,2(A8,4X))
      do i=1,NZ
        write(ifile,177) Z(I),XDEN(i),XSL(4,i),XSL(7,i)
      enddo
      
      write(ifile,180)
 180  FORMAT(/4X,'ENERGY FLUXES IN W/m^2/nm and photons/m^2/s/nm
     & (NOT DIURNALLY AVERAGED)')       
      write(ifile,181)
 181  FORMAT(/8X,'WAV',8X,'EFLUX',8X,'GFLUX',8x,'PhEFLUX',
     & 6x,'PhGFLUX')
      do jj=10,1,-1
        feflux = ESFX(jj)
        fgflux = GSFX(jj)
        fpheflux = PhESFX(jj)
        fphgflux = PhGSFX(jj)
        write(ifile,182)WAVEUV(jj),feflux,fgflux,fpheflux,fphgflux
      enddo
      do jj=1,108
        feflux = EFLUX(jj)
        fgflux = GFLUX(jj)
        fpheflux = PhEFLUX(jj)
        fphgflux = PhGFLUX(jj)
        write(ifile,182)WAV(jj),feflux,fgflux,fpheflux,fphgflux
      enddo
 182  FORMAT(2X,1P7E13.5)
      
      write(ifile,190)
 190  format(//3x,'**** From the climate model ****'/)
      write(ifile,191)
 191  format(5x,'P (atm)',5x,'Alt (km)',9x,'T',9x,'DIVF')
      do i=1,ND
       write(ifile,192) XP(i),XALT(i),T(i),DIVF(i)
      enddo
 192  format(4(2x,1pe11.4))
      
      return
      end


**************************
