      PROGRAM ARC_CH4 
C-AP In this version of the code real indexies of refraction
C-AP from the Bohren's mie code will be used
C-PK The hydrogen budget calculations have been revised.
C 100km grid, molecular diffusion,
C Escape of H2 and H
C Two HC aerosol pathways, via C2H2 and CH2CCH2
C Particle absorption included in PHOTO and TWOSTR
C
C         THIS PROGRAM IS DESIGNED FOR EXTREMELY LOW (PRE-PHOTOSYNTHETIC
C     O2 LEVELS.  THE PHOTOLYSIS OF O2 IN THE SCHUMANN-RUNGE BANDS CAN
C     BE CALCULATED EITHER BY THE METHOD OF ALLEN AND FREDERICK OR BY
C     EXPONENTIAL SUMS.  THE LATTER METHOD SHOULD BE USED FOR LOW-O2
C     ATMOSPHERES (I.E. USE IO2 = 1).  LIKEWISE, NO PHOTOLYSIS SHOULD
C     BE CALCULATED USING THE CIESLIK AND NICOLET METHOD (INO = 1), 
C     WHICH HAS BEEN MODIFIED TO AGREE WITH THE BAND INTENSITIES OF 
C     FREDERICK AND HUDSON (1979). 
C          THIS VERSION OF THE PROGRAM HAS A NEW OPTION FOR INCLUDING
C     TRANSPORT OF SPECIES THAT ONE DOES NOT WISH TO INCLUDE IN THE BIG
C     REVERSE EULER MATRIX.  THEY CAN BE SOLVED SEPARATELY USING A TRI-
C     DIAGONAL INVERSION METHOD.  S8 PARTICLES ARE TREATED THIS WAY IN
C     THIS PROGRAM BECAUSE THEY ARE VIRTUALLY NON-EXISTENT UP HIGH.  
C     THE TOP OF THE TRIDIAGONAL MATRIX IS AT GRID POINT MZ, WHICH CAN
C     BE SET EQUAL TO OR LESS THAN NZ.
C
C       THIS PROGRAM IS A ONE-DIMENSIONAL MODEL OF THE PRIMORDIAL
C     ATMOSPHERE.  THE MIXING RATIOS OF THE LONG-LIVED SPECIES  
C     ARE CALCULATED FROM THE EQUATION
C
C         DF/DT  =  (1/N)*D/DZ(KN*DF/DZ + WNF) + P/N - LF 
C
C     WHERE
C     F = MIXING RATIO (USOL)
C     K = EDDY DIFFUSION COEFFICIENT (EDD)
C     N = TOTAL NUMBER DENSITY (DEN)
C     L = CHEMICAL LOSS FREQUENCY (XL)
C     P = CHEMICAL PRODUCTION RATE (XP)
C     W = FALL VELOCITY (WFALL) FOR PARTICLES, POSITIVE DOWNWARD (ALL
C         FLUXES, BY CONTRAST, ARE POSITIVE UPWARD)
C
C         THREE TYPES OF PARTICLES ARE INCLUDED: SULFATE (SO4AER),
C     ELEMENTAL SULFUR (S8AER) AND HYDROCARBON AEROSOLS (HCAER).  
C     TRANSPORT IS INCLUDED FOR ALL THREE SPECIES, BUT THEY ARE NOT
C     INCLUDED IN THE BIG REVERSE EULER MATRIX; THEY ARE SOLVED
C     SEPERATELY USING A TRIDIAGONAL INVERSION METHOD.
C     THE SULFUR PARTICLES ARE ASSUMED TO BE 0.1 UM IN RADIUS UP HIGH;
C     HYDROCARBON PARTICLES START WITH A SMALLER RADIUS OF 0.0013 UM.
C     THE PARTICLES GET BIGGER AT LOW ALTITUDES BECAUSE OF COAGULATION.
C     THIS IS DONE CRUDELY, BASED ON A COMPARISON OF THE RELATIVE
C     lifeTIMES AGAINST DIFFUSION, SEDIMENTATION, AND RAINOUT.
C
C          THIS PROGRAM HAS TWO SWITCHES FOR ALLOWING VARIABLE BOUNDARY
C     CONDITIONS.  ISULF ALLOWS THE SULFUR (SO2 AND/OR H2S) INFLUX TO 
C     VARY, AND IH2 ALLOWS THE H2 MIXING RATIO TO FLOAT IN SUCH A MAN-
C     NER AS TO BALANCE THE HYDROGEN BUDGET.  THESE FLAGS SHOULD BE  
C     TURNED OFF (SET = 0) FOR MOST CALCULATIONS; THEY ARE NOT GUARAN-
C     TEED TO WORK VERY WELL.
C
C          THE SYSTEM OF PDES IS SOLVED USING THE REVERSE EULER      
C     METHOD.  LETTING THE TIME STEP GO TO INFINITY GIVES YOU NEWTONS
C     METHOD, E.G. IT REVERTS TO AN EFFICIENT STEADY-STATE SOLVER.  
C
C          THE LIST OF SUBROUTINES IS AS FOLLOWS:
C     (1) GRID   -  SETS UP THE ALTITUDE GRID
C     (2) RATES  -  DEFINES CHEMICAL REACTION RATES AND RAINOUT RATE
C     (3)   RAINOUT - COMPUTES RAINOUT RATES USING THE METHOD OF GIORGI
C                     AND CHAMEIDES (1985)
C     (3.1) AQUEOUS - DOES RAINWATER CHEMISTRY (CALLED BY RAINOUT)    
C     (3.2) PHOTO   - COMPUTES PHOTOLYSIS RATES (CALLS MSCAT)        
C     (3.3) O3PHOT  - COMPUTES COEFFICIENTS USED TO FIND O(1D) QUANTUM
C                     YIELDS IN O3 PHOTOLYSIS
C     (4)   DENSTY  - COMPUTES ATMOSPHERIC NUMBER DENSITIES FROM HYDRO-
C                     STATIC EQUILIBRIUM
C     (5)   DIFCO   - COMPUTES DK = K*N BETWEEN GRID POINTS; ALSO FINDS
C                     DIFFUSION LIFETIMES H*H/K
C     (5.1) SEDMNT  - CALCULATES FALL VELOCITIES AND ESTIMATES PARTICLE
C                     SIZES
C     (5.2) SATRAT  - COMPUTES SATURATION H2O MIXING RATIOS AT ALL HEIGH
C                     FINDS MANABE/WETHERALD RH DISTRIBUTION IN TROPOSPH  
C     (5.3) AERTAB  - READS PAT HAMILL'S H2SO4 TABLE AND CALCULATES VAPO
C                     PRESSURES OF H2O AND H2SO4 AT EACH HEIGHT AS A FUN  
C                     TION OF SULFATE CONTENT OF THE PARTICLES            
C     (5.4) AERCON  - FINDS WEIGHT PERCENT OF H2SO4 IN SULFATE PARTICLES  
C                     ALONG WITH H2SO4 VAPOR PRESSURE, GIVEN T AND H2O A  
C                     EACH HEIGHT
C     (6) OUTPUT -  PRINTS OUT RESULTS
C     (7) DOCHEM - DOES CHEMISTRY FOR ALL SPECIES AT ALL GRID
C                  POINTS BY CALLING CHEMPL
C     (8) CHEMPL - COMPUTES CHEMICAL PRODUCTION AND LOSS RATES
C                  FOR ONE SPECIES AT ALL GRID POINTS
C     (9) LTNING -  COMPUTES LIGHTNING PRODUCTION RATES FOR O2 AND
C                   N2 BASED ON CHAMEIDES' RESULTS
C    (11) MSCAT  -  DOES RAYLEIGH SCATTERING USING YUK YUNG'S TECHNIQUE
C    (12) TWOSTR -  DELTA EDDINGTON 2-STREAM BASED ON TOON ET AL. (1989)
C
C          OTHER DEFINED FUNCTIONS INCLUDE:
C     (1) TBDY   -  COMPUTES 3-BODY REACTION RATES
C     (2) E1     - EXPONENTIAL INTEGRAL OF ORDER ONE
C
C ***** REACTION LIST *****
C     1)  H2O + O(1D) = 2OH
C     2)  H2 + O(1D) = OH + H
C     3)  H2 + O = OH + H
C     4)  H2 + OH = H2O + H
C     5)  H + O3 = OH + O2
C     6)  H + O2 + M = HO2 + M
C     7)  H + HO2 = H2 + O2
C     8)  H + HO2 = H2O + O
C     9)  H + HO2 = OH + OH
C    10)  OH + O = H + O2
C    11)  OH + HO2 = H2O + O2
C    12)  OH + O3 = HO2 + O2
C    13)  HO2 + O = OH + O2
C    14)  HO2 + O3 = OH + 2O2
C    15)  HO2 + HO2 = H2O2 + O2
C    16)  H2O2 + OH = HO2 + H2O
C    17)  O + O + M = O2 + M
C    18)  O + O2 + M = O3 + M
C    19)  O + O3 = 2O2
C    20)  OH + OH = H2O + O
C    21)  O(1D) + M = O(3P) + M
C    22)  O(1D) + O2 = O(3P) + O2
C    23)  O2 + HV = O(3P) + O(1D)
C    24)  O2 + HV = O(3P) + O(3P)
C    25)  H2O + HV = H + OH
C    26)  O3 + HV = O2 + O(1D)
C    27)  O3 + HV = O2 + O(3P)
C    28)  H2O2 + HV = 2OH
C    29)  CO2 + HV = CO + O(3P)
C    30)  CO + OH = CO2 + H
C    31)  CO + O + M = CO2 + M
C    32)  H + CO + M = HCO + M
C    33)  H + HCO = H2 + CO
C    34)  HCO + HCO = H2CO + CO
C    35)  OH + HCO = H2O + CO
C    36)  O + HCO = H + CO2
C    37)  O + HCO = OH + CO
C    38)  H2CO + HV = H2 + CO
C    39)  H2CO + HV = HCO + H
C    40)  HCO + HV = H + CO
C    41)  H2CO + H = H2 + HCO
C    42)  CO2 + HV = CO + O(1D)
C    43)  H + H + M = H2 + M
C    44)  HCO + O2 = HO2 + CO
C    45)  H2CO + OH = H2O + HCO
C    46)  H + OH + M = H2O + M
C    47)  OH + OH + M = H2O2 + M
C    48)  H2CO + O = HCO + OH
C    49)  H2O2 + O = OH + HO2
C    50)  HO2 + HV = OH + O
C    51)  CH4 + HV  =  1CH2 + H2
C    52)  C2H6 + HV  =  2 3CH2 + H2   (IN PLACE OF C2H2 AND C2H4)
C    53)  C2H6 + HV  =  CH4 + 1CH2
C    54)  HNO2 + HV  = NO + OH
C    55)  HNO3 + HV  = NO2 + OH
C    56)  NO + HV  =  N + O
C    57)  NO2 + HV  =  NO + O
C    58)  CH4 + OH  =  CH3 + H2O
C    59)  CH4 + O(1D)  =  CH3 + OH
C    60)  CH4 + O(1D)  =  H2CO + H2
C    61)  1CH2 + CH4  =  2 CH3
C    62)  1CH2 + O2  =  HCO + OH
C    63)  1CH2 + M  =  3CH2 + M
C    64)  3CH2 + H2  =  CH3 + H
C    65)  3CH2 + CH4  =  2 CH3
C    66)  3CH2 + O2  =  HCO + OH
C    67)  CH3 + O2 + M  =  H2CO + OH
C    68)  CH3 + OH  =  H2CO + H2
C    69)  CH3 + O  =  H2CO + H
C    70)  CH3 + O3  =  H2CO + HO2
C    71)  CH3 + CH3 + M  =  C2H6 + M
C    72)  CH3 + HV  =  1CH2 + H
C    73)  CH3 + H + M  =  CH4 + M
C    74)  CH3 + HCO  =  CH4 + CO
C    75)  CH3 + HNO  =  CH4 + NO
C    76)  CH3 + H2CO  =  CH4 + HCO
C    77)  H + NO + M  =  HNO + M
C    78)  N + N + M  =  N2 + M
C    79)  N + O2  =  NO + O
C    80)  N + O3  =  NO + O2
C    81)  N + OH  =  NO + H
C    82)  N + NO  =  N2 + O
C    83)  NO + O3  =  NO2 + O2
C    84)  NO + O + M  =  NO2 + M
C    85)  NO + HO2  =  NO2 + OH
C    86)  NO + OH + M  =  HNO2 + M
C    87)  NO2 + O  =  NO + O2
C    88)  NO2 + OH + M  =  HNO3 + M
C    89)  NO2 + H  =  NO + OH
C    90)  HNO3 + OH  =  H2O + NO2 + O
C    91)  HCO + NO  =  HNO + CO
C    92)  HNO + HV  =  NO + H
C    93)  H + HNO  =  H2 + NO
C    94)  O + HNO  =  OH + NO
C    95)  OH + HNO  =  H2O + NO
C    96)  HNO2 + OH  =  H2O + NO2
C    97)  CH4 + O  =  CH3 + OH
C    98)  1CH2 + H2  =  CH3 + H
C    99)  1CH2 + CO2  =  H2CO + CO
C    100)  3CH2 + O  =  HCO + H
C    101)  3CH2 + CO2  =  H2CO + CO
C    102)  C2H6 + OH  =  C2H5 + H2O
C    103)  C2H6 + O  =  C2H5 + OH
C    104)  C2H6 + O(1D)  =  C2H5 + OH
C    105)  C2H5 + H  =  CH3 + CH3
C    106)  C2H5 + O  =  CH3 + HCO + H
C    107)  C2H5 + OH  =  CH3 + HCO + H2
C    108)  C2H5 + HCO  =  C2H6 + CO
C    109)  C2H5 + HNO  =  C2H6 + NO
C    110)  C2H5 + O2 + M  =  CH3 + HCO + OH
C    111)  SO + HV = S + O
C    112)  SO2 + HV = SO + O
C    113)  H2S + HV = HS + H
C    114)  SO + O2 = O + SO2
C    115)  SO + HO2 = SO2 + OH
C    116)  SO + O + M = SO2 + M
C    117)  SO + OH = SO2 + H
C    118)  SO2 + OH + M = HSO3 + M
C    119)  SO2 + O + M = M + SO3
C    120)  SO3 + H2O = H2SO4
C    121)  HSO3 + O2 = HO2 + SO3
C    122)  HSO3 + OH = H2O + SO3
C    123)  HSO3 + H = H2 + SO3
C    124)  HSO3 + O = OH + SO3
C    125)  H2S + OH = H2O + HS
C    126)  H2S + H = H2 + HS
C    127)  H2S + O = OH + HS
C    128)  HS + O = H + SO
C    129)  HS + O2 = OH + SO
C    130)  HS + HO2 = H2S + O2
C    131)  HS + HS = H2S + S
C    132)  HS + HCO = H2S + CO
C    133)  HS + H = H2 + S
C    134)  HS + S = H + S2
C    135)  S + O2 = SO + O
C    136)  S + OH = SO + H
C    137)  S + HCO = HS + CO
C    138)  S + HO2 = HS + O2
C    139)  S + HO2 = SO + OH
C    140)  S + S = S2
C    141)  S2 + OH = HSO + S
C    142)  S2 + O = S + SO
C    143)  SH + H2CO = H2S + HCO
C    144)  SO2 + HV = SO21
C    145)  SO2 + HV = SO23
C    146)  S2 + HV = S + S
C    147)  S2 + HV = S2*
C    148)  H2SO4 + HV = SO2 + 2 OH
C    149)  SO3 + HV = SO2 + O
C    150)  SO2(1B) + M = SO2(3B) + M
C    151)  SO2(1B) + M = SO2 + M
C    152)  SO2(1B) = SO2(3B) + HV
C    153)  SO2(1B) = SO2 + HV
C    154)  SO2(1B) + O2 = SO3 + O
C    155)  SO2(1B) + SO2 = SO3 + SO
C    156)  SO2(3B) + M = SO2 + M
C    157)  SO2(3B) = SO2 + HV
C    158)  SO2(3B) + SO2 = SO3 + SO
C    159)  SO + NO2 = SO2 + NO
C    160)  SO + O3 = SO2 + O2
C    161)  SO2 + HO2 = SO3 + OH
C    162)  HS + O3 = HSO + O2
C    163)  HS + NO2 = HSO + NO
C    164)  S + O3 = SO + O2
C    165)  SO + SO = SO2 + S
C    166)  SO3 + SO = SO2 + SO2
C    167)  S + CO2 = SO + CO
C    168)  SO + HO2 = HSO + O2
C    169)  SO + HCO = HSO + CO
C    170)  H + SO + M = HSO + M
C    171)  HSO + HV = HS + O
C    172)  HSO + NO = HNO + SO
C    173)  HSO + OH = H2O + SO
C    174)  HSO + H = HS + OH
C    175)  HSO + H = H2 + SO
C    176)  HSO + HS = H2S + SO
C    177)  HSO + O = OH + SO
C    178)  HSO + S = HS + SO
C    179)  S + S2 + M = S3 + M
C    180)  S2 + S2 + M = S4 + M
C    181)  S + S3 + M = S4 + M
C    182)  S4 + S4 + M = S8(AER) + M
C    183)  S4 + HV = S2 + S2
C    184)  S3 + HV = S2 + S
C    185)  NH3 + HV = NH2 + H
C    186)  NH3 + OH = NH2 + H2O
C    187)  NH3 + O(1D) = NH2 + OH
C    188)  NH2 + H + M = NH3 + M
C    189)  NH2 + NO = N2 + H2O
C    190)  NH2 + NH2 + M = N2H4 + M
C    191)  NH2 + O = NH + OH
C    192)  NH2 + O = HNO + H
C    193)  NH + NO = N2 + O + H
C    194)  NH + O = N + OH
C    195)  N2H4 + HV = N2H3 + H
C    196)  N2H4 + H = N2H3 + H2
C    197)  N2H3 + H = 2NH2
C    198)  N2H3 + N2H3 = N2H4 + N2 + H2
C    199)  NH + H + M = NH2 + M
C    200)  NH + HV = N + H
C    201)  NH2 + HV = NH + H
C    202)  NH2 + HV = NH2*
C    203)  NH2* = NH2 + HV
C    204)  NH2* + M = NH2 + M
C    205)  NH2* + H2 = NH3 + H
C    206)  NH2 + HCO = NH3 + CO
C    207)  NH + HCO = NH2 + CO
C    208)  1CH2 + O2 = H2CO + O
C    209)  3CH2 + O2 = H2CO + O
C    210)  C2H2 + HV = C2H + H
C    211)  C2H2 + HV = C2 + H2
C    212)  C2H4 + HV = C2H2 + H2
C    213)  3CH2 + CH3 = C2H4 + H
C    214)  C2H5 + CH3 + M = C3H8 + M
C    215)  C3H8 + OH = C3H7 + H2O
C    216)  C3H8 + O = C3H7 + OH
C    217)  C3H8 + O(1D) = C3H7 + OH
C    218)  C3H7 + H = CH3 + C2H5
C    219)  3CH2 + 3CH2 = C2H2 + H + H
C    220)  C2H2 + OH = CO + CH3
C    221)  C2H2 + H + M = C2H3 + M
C    222)  C2H3 + H = C2H2 + H2
C    223)  C2H3 + H2 = C2H4 + H
C    224)  C2H3 + CH4 = C2H4 + CH3
C    225)  C2H3 + C2H6 = C2H4 + C2H5
C    226)  C2H4 + OH = H2CO + CH3
C    227)  C2H4 + O = HCO + CH3
C    228)  C2H4 + H + M = C2H5 + M
C    229)  C2H + O2 = CO + HCO
C    230)  C2H + H2 = C2H2 + H
C    231)  C2H + CH4 = C2H2 + CH3
C    232)  C2H + C2H6 = C2H2 + C2H5
C    233)  C2H + H + M = C2H2 + M
C    234)  C3H8 + HV = C3H6 + H2
C    235)  C3H8 + HV = C2H6 + 1CH2
C    236)  C3H8 + HV = C2H4 + CH4
C    237)  C3H8 + HV = C2H5 + CH3
C    238)  C2H6 + HV = C2H2 + H2 + H2
C    239)  C2H6 + HV = C2H4 + H + H
C    240)  C2H6 + HV = C2H4 + H2
C    241)  C2H6 + HV = 2CH3
C    242)  C2H4 + HV = C2H2 + H + H
C    243)  C3H6 + HV = C2H2 + CH3 + H
C    244)  CH4 + HV = 3CH2 + 2H
C    245)  CH4 + HV = CH3 + H
C    246)  CH + HV = C + H
C    247)  CH2CO + HV = 3CH2 + CO
C    248)  CH3CHO + HV = CH3 + HCO
C    249)  CH3CHO + HV = CH4 + CO
C    250)  C2H5CHO + HV = C2H5 + HCO
C    251)  C3H3 + HV = C3H2 + H
C    252)  CH3C2H + HV = C3H3 + H
C    253)  CH3C2H + HV = C3H2 + H2
C    254)  CH3C2H + HV = CH3 + C2H
C    255)  CH2CCH2 + HV = C3H3 + H
C    256)  CH2CCH2 + HV = C3H2 + H2
C    257)  CH2CCH2 + HV = C2H2 + 3CH2
C    258)  C3H6 + HV = CH2CCH2 + H2
C    259)  C3H6 + HV = C2H4 + 3CH2
C    260)  C3H6 + HV = C2H + CH4 + H
C    261)  C + OH = CO + H
C    262)  C + H2 + M = 3CH2 + M
C    263)  C + O2 = CO + O
C    264)  CH + H = C + H2
C    265)  CH + O = CO + H
C    266)  CH + H2 = 3CH2 + H
C    267)  CH + H2 + M = CH3 + M
C    268)  CH + O2 = CO + OH
C    269)  CH + CO2 = HCO + CO
C    270)  CH + CH4 = C2H4 + H
C    271)  CH + C2H2 = C3H2 + H
C    272)  CH + C2H4 = CH3C2H + H
C    273)  CH + C2H4 = CH2CCH2 + H
C    274)  3CH2 + O = CH + OH
C    275)  3CH2 + O = CO + H + H
C    276)  3CH2 + H + M = CH3 + M
C    277)  3CH2 + H = CH + H2
C    278)  3CH2 + CO + M = CH2CO + M
C    279)  3CH2 + 3CH2 = C2H2 + H2
C    280)  3CH2 + C2H2 + M = CH3C2H + M
C    281)  3CH2 + C2H3 = CH3 + C2H2
C    282)  3CH2 + C2H5 = CH3 + C2H4
C    283)  CH2CO + H = CH3 + CO
C    284)  CH2CO + O = H2CO + CO
C    285)  CH2CCH2 + H + M = CH3 + C2H2 + M
C    286)  CH2CCH2 + H + M = C3H5 + M
C    287)  CH3 + O2 + M = CH3O2 + M
C    288)  CH3 + CO + M = CH3CO + M
C    289)  CH3 + H2CO = CH4 + HCO
C    290)  CH3 + OH = CO + H2 + H2
C    291)  CH3 + C2H3 = C3H5 + H
C    292)  CH3O2 + H = CH4 + O2
C    293)  CH3O2 + H = H2O + H2CO
C    294)  CH3O2 + O = H2CO + HO2
C    295)  CH3CO + H = CH4 + CO
C    296)  CH3CO + O = H2CO + HCO
C    297)  CH3CO + CH3 = C2H6 + CO
C    298)  CH3CO + CH3 = CH4 + CH2CO
C    299)  CH3CHO + H = CH3CO + H2
C    300)  CH3CHO + O = CH3CO + OH
C    301)  CH3CHO + OH  = CH3CO + H2O
C    302)  CH3CHO + CH3 = CH3CO + CH4
C    303)  CH3C2H + H + M = CH3 + C2H2 + M
C    304)  CH3C2H + H + M = C3H5 + M
C    305)  C2 + O = C + CO
C    306)  C2 + O2 = CO + CO
C    307)  C2 + H2 = C2H + H
C    308)  C2 + CH4 = C2H + CH3
C    309)  C2H + O = CO + CH
C    310)  C2H + C3H8 = C2H2 + C3H7
C    311)  C2H2 + O = 3CH2 + CO
C    312)  C2H2 + OH = C2H2OH
C    313)  C2H2 + OH + M = CH2CO + H + M
C    314)  C2H2OH + H = H2O + C2H2
C    315)  C2H2OH + H = H2 + CH2CO
C    316)  C2H2OH + O = OH + CH2CO
C    317)  C2H2OH + OH = H2O + CH2CO
C    318)  C2H3 + O = CH2CO + H
C    319)  C2H3 + OH = C2H2 + H2O
C    320)  C2H3 + CH3 = C2H2 + CH4
C    321)  C2H3 + CH3 + M = C3H6 + M
C    322)  C2H3 + C2H3 = C2H4 + C2H2
C    323)  C2H3 + C2H5 = C2H4 + C2H4
C    324)  C2H3 + C2H5 = CH3 + C3H5
C    325)  C2H4 + OH + M = C2H4OH + M
C    326)  C2H4OH + H = H2O + C2H4
C    327)  C2H4OH + H = H2 + CH3CHO
C    328)  C2H4OH + O = OH + CH3CHO
C    329)  C2H4OH + OH = H2O + CH3CHO
C    330)  C2H5 + OH = CH3CHO + H2
C    331)  C2H5 + O = CH3CHO + H
C    332)  C2H5 + CH3 = C2H4 + CH4
C    333)  C2H5 + C2H3 = C2H6 + C2H2
C    334)  C2H5 + C2H5 = C2H6 + C2H4
C    335)  C2H5 + H + M = C2H6 + M
C    336)  C2H5 + H = C2H4 + H2
C    337)  C3H2 + H + M = C3H3 + M
C    338)  C3H3 + H + M = CH3C2H + M
C    339)  C3H3 + H + M = CH2CCH2 + M
C    340)  C3H5 + H = CH3C2H + H2
C    341)  C3H5 + H + M = C3H6 + M
C    342)  C3H5 + H = CH4 + C2H2
C    343)  C3H5 + CH3 = CH3C2H + CH4
C    344)  C3H5 + CH3 = CH2CCH2 + CH4
C    345)  C3H6 + OH = CH3CHO + CH3
C    346)  C3H6 + O = CH3 + CH3 + CO
C    347)  C3H6 + H + M = C3H7 + M
C    348)  C3H7 + CH3 = C3H6 + CH4
C    349)  C3H7 + OH = C2H5CHO + H2
C    350)  C3H7 + O = C2H5CHO + H
C    351)  H + CH2CCH2 = CH3C2H + H
C    352)  O + H2CO = OH + HCO
C    353)  3CH2 + C2H2 + M = CH2CCH2 + M
C    354)  C2H + C2H2 = HCAER + H
C    355)  1CH2 + H2 = 3CH2 + H2
C    356)  C3H5 + H = CH2CCH2 + H2
C    357)  HCO + H2CO = CH3O + CO
C    358)  CH3O + CO = CH3 + CO2
C    359)  C2H + CH2CCH2 = HCAER + H
C
C        THIS PROGRAM DOES THE CHEMISTRY AUTOMATICALLY.  THE CHEMICAL
C     REACTIONS ARE ENTERED ON DATA CARDS IN FIVE 10-DIGIT COLUMNS
C     STARTING IN COLUMN 11, I.E.                         
C
C         REAC1     REAC2     PROD1     PROD2     PROD3
C
C     THE IMPORTANT PARAMETERS DESCRIBING THE CHEMISTRY ARE
C        NR   = NUMBER OF REACTIONS
C        NSP  = NUMBER OF CHEMICAL SPECIES
C        NSP1 = NSP + 1 (INCLUDES HV)
C        NSP2 = NSP + 2 (INCLUDES "M")
C        NQ   = NUMBER OF SPECIES FOR WHICH A DIFFUSION EQUATION
C               IS SOLVED AND WHICH ARE IN THE BIG, REVERSE EULER MATR
C        NQT = TOTAL NUMBER OF SPECIES FOR WHICH TRANSPORT IS INCLUDED
C              (THOSE NOT IN THE BIG MATRIX ARE SOLVED WITH A STEADY-STA
C              TRIDIAGONAL INVERSION METHOD)
C        NMAX = MAXIMUM NUMBER OF REACTIONS IN WHICH AN INDIVIDUAL
C               SPECIES PARTICIPATES
C
C        PHOTOLYSIS REACTIONS ARE IDENTIFIED BY THE SYMBOL HV (NOT
C     COUNTED IN EVALUATING NSP).  THREE-BODY REACTIONS ARE WRITTEN
C     IN TWO-BODY FORM, SO THE DENSITY FACTOR MUST BE INCLUDED IN
C     THE RATE CONSTANT.
C        THE CHEMICAL REACTION SCHEME IS STORED IN THE FOLLOWING MATRICE
C
C     ISPEC(NSP2) = VECTOR CONTAINING THE HOLLERITH NAMES OF THE
C                  CHEMICAL SPECIES.  THE LAST TWO ENTRIES ARE HV AND M.
C     JCHEM(5,NR) = MATRIX OF CHEMICAL REACTIONS.  THE FIRST TWO ARE
C                   REACTANTS, THE LAST THREE ARE PRODUCTS.
C     ILOSS(2,NSP,NMAX) = MATRIX OF LOSS PROCESSES.  ILOSS(1,I,L)
C                         HOLDS REACTION NUMBER J, ILOSS(2,I,L) HOLDS
C                         REACTANT NUMBER.
C     IPROD(NSP,NMAX) = MATRIX OF PRODUCTION PROCESSES.  IPROD(I,L)
C                       HOLDS REACTION NUMBER J.
C     NUML(NSP) = NUMBER OF NON-ZERO ELEMENTS FOR EACH ROW OF ILOSS
C     NUMP(NSP) = NUMBER OF NON-ZERO ELEMENTS FOR EACH ROW OF IPROD
C
      PARAMETER(NZ=100, NQ=39, NQT=NQ+3)
      PARAMETER(NEQ=NQ*NZ,LDA=3*NQ+1)
      PARAMETER(NR=359, NSP=73, NSP1=NSP+1, NSP2=NSP+2, NMAX=70)
      PARAMETER(NF=34)
      DIMENSION FVAL(NQ,NZ),FV(NQ,NZ),DJAC(LDA,NEQ),RHS(NEQ),IPVT(NEQ)
     2  ,SMFLUX(NQ),SGFLUX(NQ),VDEP(NQ),
     3  USAVE(NQ,NZ),R(NZ),U(NQ),VDEP0(NQ),VEFF0(NQ),ZKM(NZ)
     4  ,UNEW(39,NZ)
      DIMENSION PRES_MKS(NZ)
      DIMENSION DPU(NZ,3),DPL(NZ,3)
      DIMENSION TA(NZ),TB(NZ),TC(NZ),TY(NZ)
      CHARACTER*30 CHEM(5,NR),PRODRX(NSP,NR),LOSSRX(NSP,NR)
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),T(NZ),G,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
      COMMON/BBLOK/USOL(NQ,NZ),AMIXCO2,AMIXN2
      COMMON/CBLOK/O3(NZ),H2O(NZ),O2(NZ),CO2(NZ),DZ,ZTROP,NZ1,NPHOT
     2  ,S2(NZ),FSO2(NZ),H2S(NZ),FNH3(NZ),CH4(NZ),C2H6(NZ),JTROP
      COMMON/DBLOK/SL(NSP,NZ),TP(NSP),TL(NSP),O3COL,ISPEC(NSP2)
     2  ,XLG(NQT),SR(NQT),ERR(NQ,NZ),TOUT,SO2COL,H2SCOL,S2COL,
     3  S8(NZ),SO4AER(NZ),HCAER(NZ)
      COMMON/EBLOK/AI(6),BI(4),CI(4)
      COMMON/FBLOK/REL(NQ,NZ),MBOUND(NQT),LBOUND(NQT),PHIDEP(NQT),
     2  TLOSS(NQT),HBUG(NQT),HBUG2(NQT),HBUG3(NQT),HCOEFF(NQT),
     3  H2CHEM,H2SURF,H2VOLC,PHIESC,VEFF(NQ)
      COMMON/GBLOK/RAIN(NZ),FSAT(NZ),RAINGC(NQ,NZ)
      COMMON/NBLOK/LO,LO2,LH2O,LH,LOH,LHO2,LH2O2,LH2,LCO,LHCO,LH2CO,
     2  LCH4,LCH3,LC2H6,LNO,LNO2,LHNO,LH2S,LHS,LS,LSO,LSO2,LH2SO4,
     3  LHSO,LS2,LNH3,LNH2,LN2H3,LN2H4,LCH23,LC2H5,LC2H2,LC2H4,
     4  LC3H8,LC2H3,LC3H6,LC3H2,LCH2CCH2,LCH3C2H,LSO4AER,LS8AER,
     5  LHCAER,LHNO2,LHNO3,LNH,LN,LO3,LO1D,LSO21,LSO23,LHSO3,LSO3,
     6  LS3,LNH2X,LC2,LC2H,LC3H7,LC3H3,LCH,LC,LC3H5,LC2H4OH,
     7  LCH3CHO,LCH3CO,LC2H2OH,LCH2CO,LCH21,LCH3O2,LC2H5CHO,LCH3O,
     8  LS4,LCO2,LN2
      COMMON/QBLOK/PLOG(NZ),BIGX(NZ),SRO2(NZ,17),SIG0(NZ,17),A(17,9),
     2  B(17,5),SIGNO(NZ,2),SIGNO0(NZ,2),ANO(9,2),BNO(5,2),LLNO(35),
     3  SO2HZ(35),SH2O(35),SCO2(35),SHO2(35),SN2O(35),SHCL(35),
     4  SCCL2F2(35),SCHCLF2(35),SC2H2(35),SO31(108),SO32(108),
     5  SMCHO(108),SMCOM(108),SH2O2(68),SHNO3(68),SHNO4(68),SPAN(68),
     6  SPPN(68),SMOOH(68),SNO2(68),SH2CO(68),RHCO(68),RH2(68),
     7  SCL2(68),SHOCL(68),SCLNO(68),SCLONO(68),SCLONO2(68),SCCL4(68),
     8  SCLO2(68),SCLO3(68),SCCL3F(68),RNO2(68),KA(17),KB(17),
     9  WAVU(108),WAVL(108),FLUX(108),SIGMA(3,10),SFX(10),SCH4(10),
     1  TO2L(NZ),SC2H4(35),SC2H6(10),NK(17),ALPHA(17,4),BETA(17,4)
     2  ,SSO2(68),SSO21(68),SSO23(68),SS2(68),SSO(68),SH2S(68),
     3  SCH2CO(68),SSO2A(10),SSOA(10),SNH3(35),SN2H4(35),SC2H2A(10),
     4  SC2H4A(10),SC3H8(10),SCH2COA(10),SCH2CCH2(10),SCH3C2H(10),
     5  WAVUV(10)
      COMMON/RBLOK/AR(NR,NZ),ILOSS(2,NSP,NMAX),IPROD(NSP,NMAX),
     2  JCHEM(5,NR),NUML(NSP),NUMP(NSP)
      COMMON/SBLOK/PO2(NZ),PO2D(NZ),PO3(NZ),PO3D(NZ),PH2O(NZ),PH2O2(NZ),
     2  PCO2(NZ),PCO2D(NZ),PHCO(NZ),PH2(NZ),PHO2(NZ),PCH4A(NZ),
     3  PCH4B(NZ),PCH4C(NZ),PHNO3(NZ),PNO(NZ),PNO2(NZ),PC2H6A(NZ),
     4  PC2H6B(NZ),PC2H6C(NZ),PC2H6D(NZ),PC2H6E(NZ),PSO2(NZ),PSO21(NZ),
     5  PSO23(NZ),PSO(NZ),PC3H8A(NZ),PC3H8B(NZ),PC3H8C(NZ),PC3H8D(NZ),
     6  PH2S(NZ),PS2(NZ),PH2SO4(NZ),PNH3(NZ),PN2H4(NZ),PC2H2A(NZ),
     7  PC2H2B(NZ),PC2H4(NZ),PCH2CCH2(NZ),PCH3C2H(NZ),PMCHO(NZ),
     8  PCH3(NZ),PCH2CO(NZ)
      COMMON/ZBLOK/YP(NQT,NZ),YL(NQT,NZ)
      COMMON/LTBLOK/ZAPNO,ZAPO2,PRONO,PRONOP
      COMMON/AERBLK/WFALL(NZ,3),AERSOL(NZ,3),RPAR(NZ,3),HSCALE(NZ),
     2  CONVER(NZ,3),TAUEDD(NZ),TAUSED(NZ,3),TAUC(NZ,3),
     3  dtauHC(108,NZ),NBEER
      COMMON/SULBLK/VH2O(NF,NZ),VH2SO4(NF,NZ),FTAB(NF),H2SO4S(NZ),
     2  FSULF(NZ),CONSO4(NZ)
      COMMON/RRATS/RAT(NR),RXTOT(NR,NZ)
      COMMON/TOTALMIE/QEXTT(108,NZ), W0T(108,NZ), GFT(108,NZ)
      COMMON/LifeTime/TAUO2,TAUCH4
      COMMON/VBLOK/VDEPCO,U(NQ)
C-AP *************************************************************
      DIMENSION RSTAND(34), QEXTSTAND(108,34), W0STAND(108,34),
     2  GSTAND(108,34),
     3 WAVLS(108), WAVUS(108)
C
C FAR UV SOLAR FLUX
C
      DATA SFX/1.1E10, 6.4E9, 3.5E9, 2.4E9, 1.9E9, 1.1E9, 7.7E8,
     2  6.3E8, 9.5E8, 1.0E10/
      DATA WAVUV/1725., 1675., 1625., 1575., 1525., 1475., 1425.,
     2  1375., 1325., 1216./
C
C   NO PREDISSOCIATION COEFFICIENTS (ALLEN AND FREDERICK, 1982)
C
      DATA ANO/-1.790868E+1, -1.924701E-1, -7.217717E-2, 5.648282E-2,
     2  4.569175E-2, 8.353572E-3, 3*0.,
     3  -1.654245E+1, 5.836899E-1, 3.449436E-1, 1.700653E-1,
     4  -3.324717E-2, -4.952424E-2, 1.579306E-2, 1.835462E-2,
     5  3.368125E-3/
C
      DATA BNO/7.836832E+3, -1.549880E+3, 1.148342E+2, -3.777754E+0,
     2  4.655696E-2, 1.297581E+4, -2.582981E+3, 1.927709E+2,
     3  -6.393008E+0, 7.949835E-2/
C
      DATA LLNO/3*0, 2*2, 3*0, 2*1, 25*0/
      DATA RNO2/60*0., .79, .83, .66, .15, 4*0./
C
      DATA SS2/38*1.E-20, 1.5E-20, 2.E-20, 3.E-20, 4.E-20, 5.E-20,
     2  6.E-20, 8.E-20, 1.E-19, 8.E-20, 6.E-20, 4.E-20, 3.E-20, 2.E-20,
     3  1.E-20, 3.E-21, 1.E-21, 3.E-22, 1.E-22, 12*0./
C   (S2 CROSS SECTION SHAPE BASED ON MEYER ET AL., 1971.  SCALED UP BY
C    FACTOR OF 6.5 DOWN LOWER TO GET LIFETIME OF 1000 S UP HIGH.)
C
C   CONSTANTS FOR 1ST EXPONENTIAL INTEGRAL
C-PK      DATA AI/.99999193, -.24991055, .05519968, -.00976004,
C-PK     2  .00107857, -.57721566/
C-PK      DATA BI/8.5733287401, 18.0590169730, 8.6347608925,
C-PK     2  .2677737343/
C-PK      DATA CI/9.5733223454, 25.6329561486, 21.0996530827,
C-PK     2  3.9584969228/
      DATA NUML,NUMP/NSP*0,NSP*0/
C
      DATA HBUG/NQT*0./
      DATA HBUG2/NQT*0./
      DATA HBUG3/NQT*0./
      DATA HCOEFF/-1.,-2.,0.,0.5,-0.5,-1.5,-1.,1.,1.,1.5,2.,4.,3.5,7.,
     2  -1.,-2.,-0.5,3.,2.5,2.,1.,0.,-1.,1.5,4.,1.5,1.,1.5,2.,3.,6.5,
     3  5.,6.,10.,5.5,9.,7.,8.,8.,-1.,16.,9./
C-PK      DATA HCOEFF/7*0., 1., 1., 2*0., 4.0, 13*0., 1.5, 16*0./
C Outgassing:           H2, CO,       CH4,        NH3
C HCOEFF(NQT=42)

C-PK  **BALANCE REDOX REACTIONS TO DETERMINE HCOEFF VALUES**
C-PK  SPECIES	REACTION		   	HCOEFF VALUE
C-PK	O	O + H2 = H2O			-1
C-PK	O2	O2 + 2H2 = 2H2O			-2
C-PK	H20	--				0
C-PK	H	H + H2O = H20 + 0.5H2		0.5
C-PK 	OH	OH + 0.5H2 = H20		-0.5

C
C ***** UPPER BOUNDARY FLUXES *****
C NOTE: SMFLUX SET BELOW FOR CO AND O TO BALANCE CO2 PHOTOLYSIS UP HIGH
      DATA SMFLUX/NQ*0./
C
C ***** EFFUSION VELOCITIES ***** VEFF0(NQ=39)
C NOTE: VEFF(LH2) AND VEFF(LH) SET BELOW FOR HYDROGEN ESCAPE
      DATA VEFF0/NQ*0./
C
C ***** UPPER BOUNDARY CONDITIONS ***** MBOUND(NQT=42)
      DATA MBOUND/1, 7*0, 1, 33*0/
C                 O,     CO
C
C   0 = CONSTANT EFFUSION VELOCITY (VEFF)
C   1 = CONSTANT FLUX (SMFLUX)
C
C ***** LOWER BOUNDARY FLUXES ***** SGFLUX(NQ=39)
C NOTE: SO2 and H2 OUTGASSING SET IN DOCHEM
C-AP Added upward flux for oxygen
      DATA SGFLUX/0., 1.E9, 5*0., 2.5E10, 0.0 , 2*0., 1.96E11, 9*0., 0., 
     2  17*0./
C                                   H2,    CO          CH4          SO2
C
C ***** DEPOSITION VELOCITIES ***** VDEP0(NQ=39)
C-PK For H2: vpis = 0.013 cm/s (based on Kdif of H2@25C); alpha = 7.8E-4;
C-PK scale = 6.02E20; then vdep(H2) = vpis(H2)*alpha*pH2*scale/n(H2)...
C-PK ...this reduces to vdep(H2) = vpis(H2)*alpha*scale/n(air) = 2.4e-4
C-PK Note that this is the MAXIMUM possible value for vdep(H2), since it 
C-PK assumes that there is no dissolved H2 (see subroutine H2AQ).
C-PK Similarly, for CO: vpis = 0.005 cm/s (based on Kdif of N2@25C)
C-PK and vmax(CO) = 1.2e-4 
      DATA VDEP0/1., 2*0.,   3*1.,  0.2, 2.4E-4, 1.2E-4, 1., 0.2, 0.,
C                O,       H,OH,HO2, H2O2,  H2,  CO, HCO,H2CO,   CH4,
     2  1., 0., 3.E-4, 3.E-3, 1., .02, 1., 1., 3.E-4,  3*1.,
C        NO,    NO2, HNO, H2S, HS, S,   SO,  SO2,H2SO4,HSO,
     3  2*0.,    2*1.,  0.2, 10*0./
C             NH2,N2H3, N2H4
C
C ***** LOWER BOUNDARY CONDITIONS ***** LBOUND(NQT=42)
C-AP Added upward flux for oxygen
C-AP and remove it for now
C-PK f(CH4) fixed; vdep(H2), vdep(CO) fixed; anoxygenic phototrophy simulated
      DATA LBOUND/0, 0, 5*0, 0, 0, 2*0, 1, 9*0, 0, 3*0, 1, 16*0/
C                           H2,CO,     CH4,    SO2     NH3
C
C   0 = CONSTANT DEPOSITION VELOCITY (VDEP)
C   1 = CONSTANT MIXING RATIO
C   2 = CONSTANT UPWARD FLUX (SGFLUX)
C
C-AP RADIUS of particles for which Mie calculations were run
C-AP **********************************************************
      DATA RSTAND/0.001, 0.002, 0.003, 0.004, 0.005, 0.006, 0.007,
     2  0.008, 0.009, 0.01, 0.03, 0.05, 0.07, 0.1, 0.13, 0.15,
     3  0.17, 0.2, 0.23, 0.27, 0.3, 0.33, 0.37, 0.4, 0.43, 0.47,
     4  0.5, 0.55, 0.6, 0.7, 0.8, 0.9, 1., 2./
C-AP ***********************************************************
C-AP TEMPERATURE PROFILE FROM THE CLIMATE MODEL
      DIMENSION ALTCLIM(18), TEMPCLIM(18)
      DATA ALTCLIM/0., 1.1, 3.3, 5.5, 7.6, 9.8, 11.9,
     2  14.1, 16.4, 18.7, 21.1, 23.5, 25.8, 28.3, 30.9,
     3  33.5, 36.2, 39.1/
      DATA TEMPCLIM/286.4, 280.8, 268.5, 256.1, 245.6,
     2  237.8, 232.2, 228.8, 226.9, 224.6, 221.1, 217.1,
     3  213.5, 213.3, 216.7, 219, 219.4, 220.3/
C-AP
      DATA LO,LO2,LH2O,LH,LOH,LHO2,LH2O2,LH2,LCO,LHCO,LH2CO,
     2  LCH4,LCH3,LC2H6,LNO,LNO2,LHNO,LH2S,LHS,LS,LSO,LSO2,LH2SO4,
     3  LHSO,LS2,LNH3,LNH2,LN2H3,LN2H4,LCH23,LC2H5,LC2H2,LC2H4,
     4  LC3H8,LC2H3,LC3H6,LC3H2,LCH2CCH2,LCH3C2H,LSO4AER,LS8AER,
     5  LHCAER,LHNO2,LHNO3,LNH,LN,LO3,LO1D,LSO21,LSO23,LHSO3,LSO3,
     6  LS3,LNH2X,LC2,LC2H,LC3H7,LC3H3,LCH,LC,LC3H5,LC2H4OH,
     7  LCH3CHO,LCH3CO,LC2H2OH,LCH2CO,LCH21,LCH3O2,LC2H5CHO,LCH3O,
     8  LS4,LCO2,LN2/
     9  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
     1  24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,
     2  44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
     3  64,65,66,67,68,69,70,71,72,73/
C
C ***** SPECIES DEFINITIONS *****
C   LONG-LIVED
      ISPEC(1) = 1HO
      ISPEC(2) = 2HO2
      ISPEC(3) = 3HH2O
      ISPEC(4) = 1HH
      ISPEC(5) = 2HOH
      ISPEC(6) = 3HHO2
      ISPEC(7) = 4HH2O2
      ISPEC(8) = 2HH2
      ISPEC(9) = 2HCO
      ISPEC(10) = 3HHCO
      ISPEC(11) = 4HH2CO
      ISPEC(12) = 3HCH4
      ISPEC(13) = 3HCH3
      ISPEC(14) = 4HC2H6
      ISPEC(15) = 2HNO
      ISPEC(16) = 3HNO2
      ISPEC(17) = 3HHNO
      ISPEC(18) = 3HH2S
      ISPEC(19) = 2HHS
      ISPEC(20) = 1HS
      ISPEC(21) = 2HSO
      ISPEC(22) = 3HSO2
      ISPEC(23) = 5HH2SO4
      ISPEC(24) = 3HHSO
      ISPEC(25) = 2HS2
      ISPEC(26) = 3HNH3
      ISPEC(27) = 3HNH2
      ISPEC(28) = 4HN2H3
      ISPEC(29) = 4HN2H4
      ISPEC(30) = 4HCH23
      ISPEC(31) = 4HC2H5
      ISPEC(32) = 4HC2H2
      ISPEC(33) = 4HC2H4
      ISPEC(34) = 4HC3H8
      ISPEC(35) = 4HC2H3
      ISPEC(36) = 4HC3H6
      ISPEC(37) = 4HC3H2
      ISPEC(38) = 7HCH2CCH2
      ISPEC(39) = 6HCH3C2H
C   TRIDIAGONAL SOLVER
      ISPEC(40) = 6HSO4AER
      ISPEC(41) = 5HS8AER
      ISPEC(42) = 5HHCAER
C   SHORT-LIVED SPECIES
      ISPEC(43) = 4HHNO2
      ISPEC(44) = 4HHNO3
      ISPEC(45) = 2HNH
      ISPEC(46) = 1HN
      ISPEC(47) = 2HO3
      ISPEC(48) = 3HO1D
      ISPEC(49) = 4HSO21
      ISPEC(50) = 4HSO23
      ISPEC(51) = 4HHSO3
      ISPEC(52) = 3HSO3
      ISPEC(53) = 2HS3
      ISPEC(54) = 4HNH2X
      ISPEC(55) = 2HC2
      ISPEC(56) = 3HC2H
      ISPEC(57) = 4HC3H7
      ISPEC(58) = 4HC3H3
      ISPEC(59) = 2HCH
      ISPEC(60) = 1HC
      ISPEC(61) = 4HC3H5
      ISPEC(62) = 6HC2H4OH
      ISPEC(63) = 6HCH3CHO
      ISPEC(64) = 6HCH3CO
      ISPEC(65) = 6HC2H2OH
      ISPEC(66) = 5HCH2CO
      ISPEC(67) = 4HCH21
      ISPEC(68) = 5HCH3O2
      ISPEC(69) = 7HC2H5CHO
      ISPEC(70) = 4HCH3O
      ISPEC(71) = 2HS4
C   INERT SPECIES
      ISPEC(72) = 3HCO2
      ISPEC(73) = 2HN2
      ISPEC(74) = 2HHV
      ISPEC(75) = 1HM
C ****************************************************************
C Input files
      OPEN(UNIT=2,FILE='H2SO4.DAT')
      OPEN(UNIT=3,FILE='PHOTO_DATA.CH4')
      OPEN(UNIT=4,FILE='PLANET.EARTH')
      OPEN(UNIT=7,FILE='species+T_in.DAT')
      OPEN(UNIT=9,FILE='CHEM.DAT.CH4')
      OPEN(UNIT=11,FILE='FARUV.DAT')
C Output files
      OPEN(UNIT=8,FILE='species+T_out.dat')
      OPEN(UNIT=12,FILE='species_alt_profiles.out.dat')
      OPEN(UNIT=13,FILE='ERROR.OUT')
      OPEN(UNIT=14,FILE='rxtot.out.dat')
      OPEN(UNIT=15,FILE='int.rates.out.dat')
      OPEN(UNIT=16,FILE='temp.out.dat')
      OPEN(UNIT=17,FILE='eddy.out.dat')
      OPEN(UNIT=18,FILE='tautrn.out.dat')
      OPEN(UNIT=19,FILE='tauhc.beers.out.dat')
      OPEN(UNIT=20,FILE='twostr.tauc.out.dat')
      OPEN(UNIT=21,FILE='twostr.solar.out.dat')
      OPEN(UNIT=22,FILE='tautot_v_wav.out.dat')
      OPEN(UNIT=23,FILE='hcaer.out.dat')
      OPEN(UNIT=24,FILE='freq.out.dat')
      OPEN(UNIT=59,FILE='tpf_absor_spect.out.dat')
C-AP  Scattering data files for particles
C-AP ******************************************
      OPEN(UNIT=25,FILE='DATA/fitmythol0001.DAT')
      OPEN(UNIT=26,FILE='DATA/fitmythol0002.DAT')
      OPEN(UNIT=27,FILE='DATA/fitmythol0003.DAT')
      OPEN(UNIT=28,FILE='DATA/fitmythol0004.DAT')
      OPEN(UNIT=29,FILE='DATA/fitmythol0005.DAT')
      OPEN(UNIT=30,FILE='DATA/fitmythol0006.DAT')
      OPEN(UNIT=31,FILE='DATA/fitmythol0007.DAT')
      OPEN(UNIT=32,FILE='DATA/fitmythol0008.DAT')
      OPEN(UNIT=33,FILE='DATA/fitmythol0009.DAT')
      OPEN(UNIT=34,FILE='DATA/fitmythol001.DAT')
      OPEN(UNIT=35,FILE='DATA/fitmythol003.DAT')
      OPEN(UNIT=36,FILE='DATA/fitmythol005.DAT')
      OPEN(UNIT=37,FILE='DATA/fitmythol007.DAT')
      OPEN(UNIT=38,FILE='DATA/fitmythol01.DAT')
      OPEN(UNIT=39,FILE='DATA/fitmythol013.DAT')
      OPEN(UNIT=40,FILE='DATA/fitmythol015.DAT')
      OPEN(UNIT=41,FILE='DATA/fitmythol017.DAT')
      OPEN(UNIT=42,FILE='DATA/fitmythol02.DAT')
      OPEN(UNIT=43,FILE='DATA/fitmythol023.DAT')
      OPEN(UNIT=44,FILE='DATA/fitmythol027.DAT')
      OPEN(UNIT=45,FILE='DATA/fitmythol03.DAT')
      OPEN(UNIT=46,FILE='DATA/fitmythol033.DAT')
      OPEN(UNIT=47,FILE='DATA/fitmythol037.DAT')
      OPEN(UNIT=48,FILE='DATA/fitmythol04.DAT')
      OPEN(UNIT=49,FILE='DATA/fitmythol043.DAT')
      OPEN(UNIT=50,FILE='DATA/fitmythol047.DAT')
      OPEN(UNIT=51,FILE='DATA/fitmythol05.DAT')
      OPEN(UNIT=52,FILE='DATA/fitmythol055.DAT')
      OPEN(UNIT=53,FILE='DATA/fitmythol06.DAT')
      OPEN(UNIT=54,FILE='DATA/fitmythol07.DAT')
      OPEN(UNIT=55,FILE='DATA/fitmythol08.DAT')
      OPEN(UNIT=56,FILE='DATA/fitmythol09.DAT')
      OPEN(UNIT=57,FILE='DATA/fitmythol1.DAT')
      OPEN(UNIT=58,FILE='DATA/fitmythol2.DAT')
C-AP *****************************************
C-AP READ the DATA from mie calculations
      DO I=1,108
      READ(25,998) WAVLS(I),WAVUS(I),W0STAND(I,1),QEXTSTAND(I,1),
     2 GSTAND(I,1)
      READ(26,998) WAVLS(I),WAVUS(I),W0STAND(I,2),QEXTSTAND(I,2),
     2 GSTAND(I,2)
      READ(27,998) WAVLS(I),WAVUS(I),W0STAND(I,3),QEXTSTAND(I,3),
     2 GSTAND(I,3)
      READ(28,998) WAVLS(I),WAVUS(I),W0STAND(I,4),QEXTSTAND(I,4),
     2 GSTAND(I,4)
      READ(29,998) WAVLS(I),WAVUS(I),W0STAND(I,5),QEXTSTAND(I,5),
     2 GSTAND(I,5)
      READ(30,998) WAVLS(I),WAVUS(I),W0STAND(I,6),QEXTSTAND(I,6),
     2 GSTAND(I,6)
      READ(31,998) WAVLS(I),WAVUS(I),W0STAND(I,7),QEXTSTAND(I,7),
     2 GSTAND(I,7)
      READ(32,998) WAVLS(I),WAVUS(I),W0STAND(I,8),QEXTSTAND(I,8),
     2 GSTAND(I,8)
      READ(33,998) WAVLS(I),WAVUS(I),W0STAND(I,9),QEXTSTAND(I,9),
     2 GSTAND(I,9)
      READ(34,998) WAVLS(I),WAVUS(I),W0STAND(I,10),QEXTSTAND(I,10),
     2 GSTAND(I,10)
      READ(35,998) WAVLS(I),WAVUS(I),W0STAND(I,11),QEXTSTAND(I,11),
     2 GSTAND(I,11)
      READ(36,998) WAVLS(I),WAVUS(I),W0STAND(I,12),QEXTSTAND(I,12),
     2 GSTAND(I,12)
      READ(37,998) WAVLS(I),WAVUS(I),W0STAND(I,13),QEXTSTAND(I,13),
     2 GSTAND(I,13)
      READ(38,998) WAVLS(I),WAVUS(I),W0STAND(I,14),QEXTSTAND(I,14),
     2 GSTAND(I,14)
      READ(39,998) WAVLS(I),WAVUS(I),W0STAND(I,15),QEXTSTAND(I,15),
     2 GSTAND(I,15)
      READ(40,998) WAVLS(I),WAVUS(I),W0STAND(I,16),QEXTSTAND(I,16),
     2 GSTAND(I,16)
      READ(41,998) WAVLS(I),WAVUS(I),W0STAND(I,17),QEXTSTAND(I,17),
     2 GSTAND(I,17)
      READ(42,998) WAVLS(I),WAVUS(I),W0STAND(I,18),QEXTSTAND(I,18),
     2 GSTAND(I,18)
      READ(43,998) WAVLS(I),WAVUS(I),W0STAND(I,19),QEXTSTAND(I,19),
     2 GSTAND(I,19)
      READ(44,998) WAVLS(I),WAVUS(I),W0STAND(I,20),QEXTSTAND(I,20),
     2 GSTAND(I,20)
      READ(45,998) WAVLS(I),WAVUS(I),W0STAND(I,21),QEXTSTAND(I,21),
     2 GSTAND(I,21)
      READ(46,998) WAVLS(I),WAVUS(I),W0STAND(I,22),QEXTSTAND(I,22),
     2 GSTAND(I,22)
      READ(47,998) WAVLS(I),WAVUS(I),W0STAND(I,23),QEXTSTAND(I,23),
     2 GSTAND(I,23)
      READ(48,998) WAVLS(I),WAVUS(I),W0STAND(I,24),QEXTSTAND(I,24),
     2 GSTAND(I,24)
      READ(49,998) WAVLS(I),WAVUS(I),W0STAND(I,25),QEXTSTAND(I,25),
     2 GSTAND(I,25)
      READ(50,998) WAVLS(I),WAVUS(I),W0STAND(I,26),QEXTSTAND(I,26),
     2 GSTAND(I,26)
      READ(51,998) WAVLS(I),WAVUS(I),W0STAND(I,27),QEXTSTAND(I,27),
     2 GSTAND(I,27)
      READ(52,998) WAVLS(I),WAVUS(I),W0STAND(I,28),QEXTSTAND(I,28),
     2 GSTAND(I,28)
      READ(53,998) WAVLS(I),WAVUS(I),W0STAND(I,29),QEXTSTAND(I,29),
     2 GSTAND(I,29)
      READ(54,998) WAVLS(I),WAVUS(I),W0STAND(I,30),QEXTSTAND(I,30),
     2 GSTAND(I,30)
      READ(55,998) WAVLS(I),WAVUS(I),W0STAND(I,31),QEXTSTAND(I,31),
     2 GSTAND(I,31)
      READ(56,998) WAVLS(I),WAVUS(I),W0STAND(I,32),QEXTSTAND(I,32),
     2 GSTAND(I,32)
      READ(57,998) WAVLS(I),WAVUS(I),W0STAND(I,33),QEXTSTAND(I,33),
     2 GSTAND(I,33)
      READ(58,998) WAVLS(I),WAVUS(I),W0STAND(I,34),QEXTSTAND(I,34),
     2 GSTAND(I,34)
      ENDDO
 998  FORMAT(1x,F6.1,1x,F6.1,2x,F6.4,2x,F6.4,2x,F6.4)
C ****************************************************************
C
C ***** READ THE CHEMISTRY DATA CARDS *****
      READ(9,200)JCHEM
 200  FORMAT(10X,A8,2X,A8,2X,A8,2X,A8,2X,A8)
C-PK      PRINT 201,(J,(JCHEM(M,J),M=1,5),J=1,NR)
C-PK 201  FORMAT(1X,I3,1H),5X,A8,4H +  ,A8,7H  =    ,A8,4H +  ,A8,4X,A8)
      KJAC = LDA*NEQ
      PRINT 202,NQ,NZ,KJAC
 202  FORMAT(//1X,*NQ=*,I2,5X,*NZ=*,I3,5X,*KJAC=*,I7)
C ***** REPLACE HOLLERITH LABELS WITH SPECIES NUMBERS IN JCHEM *****
      DO 5 J=1,NR
      DO 5 M=1,5
      IF(JCHEM(M,J).EQ.1H ) GO TO 5
      DO 6 I=1,NSP2
      IF(JCHEM(M,J).NE.ISPEC(I)) GO TO 6
      JCHEM(M,J) = I
      GO TO 5
   6  CONTINUE
      IERR = J
      GO TO 25
   5  CONTINUE
C
C Read character array for P&L tables, "int.rates.out.dat"
      REWIND 9
      READ(9,200)CHEM
c     WRITE(15,201)(J,(CHEM(M,J),M=1,5),J=1,NR)
C
C ***** FILL UP CHEMICAL PRODUCTION AND LOSS MATRICES *****
      DO 7 M=1,2
      N = 3-M
      DO 7 J=1,NR
      I = JCHEM(M,J)
      IF(I.LT.1.OR.I.GT.NSP) GO TO 7
      NUML(I) = NUML(I) + 1
      IF(NUML(I).GT.NMAX) GO TO 20
      K = NUML(I)
      ILOSS(1,I,K) = J
      ILOSS(2,I,K) = JCHEM(N,J)
   7  CONTINUE
C
      DO 8 M=3,5
      DO 8 J=1,NR
      I = JCHEM(M,J)
      IF(I.LT.1.OR.I.GT.NSP) GO TO 8
      NUMP(I) = NUMP(I) + 1
      IF(NUMP(I).GT.NMAX) GO TO 20
      K = NUMP(I)
      IPROD(I,K) = J
   8  CONTINUE
C
C   SCALE UP S2 CROSS SECTIONS TO OBTAIN CORRECT S2 LIFETIME UP HIGH
      DO 50 L=1,68
  50  SS2(L) = 6.53 * SS2(L)
C
C ***** READ THE INPUT DATAFILE *****
      READ(7,500) USOL,T,EDD,DEN,O3,SO4AER,S8,HCAER,AERSOL,
     2   WFALL,RPAR
 500  FORMAT(1P6E12.5)
      DO 40 K=1,NQ
      VDEP(K) = VDEP0(K)
      VEFF(K) = VEFF0(K)
      DO 40 I=1,NZ
      O3(I) = ABS(O3(I))
  40  USOL(K,I) = ABS(USOL(K,I))
C ***** READ THE PLANET PARAMETER DATAFILE *****
      READ(4,502) G,FSCALE,ALB,DELZ,ZTROP,JTROP
 502  FORMAT(F5.1/,F4.2/,F5.3/,E5.1/,E5.1/,I2)
C
C(CHANGE INITIAL CONDITIONS HERE)
C  SET CH4 MIXING RATIO AT THE GROUND, GFCH4.  GFCH4IN IS THE
C  GROUND-LEVEL MIXING RATIO FROM THE INPUT DATA FILE.
C-AP      GFCH4IN = 5.E-5
C-AP      GFCH4 = 1.E-5
C-AP      GFH2 = 4.E-5
C-AP      GFH2IN = USOL(LH2,1) 
C-AP      DO 51 I=1,NZ
C-AP  51     USOL(LH2,I) = USOL(LH2,I)*(GFH2/GFH2IN)
C-AP  51  USOL(LCH4,I) = USOL(LCH4,I)*(GFCH4/GFCH4IN)
C-AP CHANGE INITIAL CONDITIONS ON METHANE
C-AP       DO 51 I=1,NZ
C-AP   51  USOL(LCH4,I) = 1.E-3
C-AP  
C-AP        DO I=1,NZ
C-AP         USOL(LNH3,I) = 1.E-9
C-AP        ENDDO
C-AP
C  Same scaling for NH3 mixing ratio
C-AP      GFNH3IN = 9.E-9
C-AP      GFNH3 = 3.E-8
C-AP      DO 51 I=1,NZ
C-AP  51  USOL(LNH3,I) = USOL(LNH3,I)*(GFNH3/GFNH3IN)
C-AP
C  Same scaling for CO mixing ratio
C-AP       GFCOIN = 1.E-5 
C-AP       GFCO = 1.E-4
C-AP      DO 51 I=1,NZ
C-AP  51  USOL(LCO,I) = USOL(LCO,I)*(GFCO/GFCOIN)
C
C ***** SET MODEL PARAMETERS *****
C     ZY = SOLAR ZENITH ANGLE (IN DEGREES)
C     AGL = DIURNAL AVERAGING FACTOR FOR PHOTORATES
C     LTIMES = COUNTER FOR PHOTORATE SUBROUTINE
C     ISEASON = TELLS WHETHER P AND T VARY WITH TIME (THEY DON'T FOR
C               ISEASON < 3)
C     IZYO2 = TELLS WHETHER SOLAR ZENITH ANGLE VARIES WITH TIME (0 SAYS
C             IT DOESN'T; 1 SAYS IT DOES)
C     IO2 = 0 FOR ALLEN AND FREDERICK O2 SCHUMANN-RUNGE COEFFICIENTS
C         = 1 FOR EXPONENTIAL SUM FITS (FOR LOW-O2 ATMOSPHERES)
C     INO = 0 FOR ALLEN AND FREDERICK NO PREDISSOCIATION COEFFICIENTS
C         = 1 FOR MODIFIED CIESLIK AND NICOLET FORMULATION
C     EPSJ = AMOUNT BY WHICH TO PERTURB THINGS FOR JACOBIAN CALCULATION
C     ZTROP = TROPOPAUSE HEIGHT (ABOVE WHICH H2O BEHAVES AS A NONCONDENS
C             ABLE GAS)
C     FCO2 = AMIXCO2 = CO2 MIXING RATIO
C     FO2 = O2 MIXING RATIO
C     PRONO  = COLUMN-INTEGRATED NO PRODUCTION RATE FROM LIGHTNING IN
C              PRESENT ATMOSPHERE
C     VOLFLX = ESTIMATED VOLCANIC OUTGASSING RATE OF SO2 PLUS H2S
C     H2VOLC = ESTIMATED VOLCANIC OUTGASSING RATE OF H2
C     ISULF  = 0 FOR CONSTANT MIXING RATIOS OR CONSTANT FLUXES OF
C              SO2 AND H2S, 1 FOR VARIABLE FLUXES (OPTION 1 MAKES
C              THE TOTAL SULFUR LOSS EQUAL TO VOLFLX, INCLUDING
C              SURFACE DEPOSITION OF SO2 AND H2S)
C     IH2    = 0 FOR CONSTANT H2 MIXING RATIO, 1 FOR MIXING RATIO
C              THAT VARIES SO AS TO BALANCE THE H2 BUDGET
C     DT = INITIAL TIME STEP
C     TSTOP = TIME AT WHICH CALCULATION IS TO STOP
C     NSTEPS = NUMBER OF TIME STEPS TO RUN (IF TSTOP IS NOT REACHED)
C
      ZY = 50.
      AGL = 0.5
      LTIMES = 0
      ISEASON = 1
      IZYO2 = 0
      IO2 = 1
      INO = 1
      EPSJ = 1.E-7
      FCO2 = 0.025 
      AMIXCO2 = FCO2
      FO2 = USOL(LO2,1)
      PRONO = 1.E9
      VOLFLX = 3.E9
      H2VOLC = 2.e10
      ISULF = 0
      IH2 = 0
      CALL GRID
      DZ = Z(2) - Z(1)
      PRINT 503, ZTROP,JTROP,Z(JTROP)
 503  FORMAT(*ZTROP = *,1PE9.2,*  JTROP = *,I3,*  Z(JTROP) = *,E9.2)
      DO J=1,NZ
       ZKM(J) = Z(J)/1.E5
      ENDDO
C-AP      T(1) = 286.4
C-AP*********************************************
C-AP      DO I=2,NZ
C-AP       DO J=2,17
C-AP       IF ((ZKM(I).GE.ALTCLIM(J)).AND.(ZKM(I).LE.ALTCLIM(J+1)))
C-AP     2 THEN
C-AP       DALT = ALTCLIM(J+1) - ALTCLIM(J)
C-AP       T(I)=TEMPCLIM(J)+(TEMPCLIM(J+1)-TEMPCLIM(J))/DALT*
C-AP     2 (ZKM(I) - ALTCLIM(J))
C-AP       ENDIF
C-AP       ENDDO
C-AP       IF (ZKM(I).GE.ALTCLIM(18)) THEN
C-AP       T(I) = TEMPCLIM(18)
C-AP       ENDIF
C-AP      ENDDO
C-AP ****************************************
      DO 800, J=1,NZ
      WRITE(17,801) EDD(J),ZKM(J)
 800  WRITE(16,801) T(J),ZKM(J)
 801  format(1PE10.3,1X,E10.3)
      FCO = USOL(LCO,1)
      FH2O = USOL(LH2O,1)/0.77
      CALL DENSTY(FO2,FCO2,FCO,FH2O,P0)
      CALL RATES
      CALL DIFCO(FO2,FCO2)
      CALL SATRAT(JTROP,H2O)
      DO 23 J=1,JTROP
  23  USOL(LH2O,J) = H2O(J)
      CALL LTNING(FO2,FCO2,P0)
      CALL AERTAB
      NZ1 = NZ - 1
      HA = HSCALE(NZ)
      NRAIN = 0
      DT = 1.E-8
      DTINV = 1./DT
      TIME = 0.
      TSTOP = 1.E17
      NSTEPS = 2000
      PRINT 506, FCO2
 506  FORMAT(/*FCO2 = *,1PE9.2)
C
C ***** PRINT OUT INITIAL DATA *****
      CALL OUTPUT(0,NSTEPS,0.)
C
C   SET JACOBIAN PARAMETERS
      KD = 2*NQ + 1
      KU = KD - NQ
      KL = KD + NQ
C
C   PRINT OUT RESULTS EVERY NPR TIME STEPS
      NPR = NSTEPS
      PRN = NPR
C
C   DO PHOTORATES EVERY MP TIME STEPS
      NPHOT = 0
      MP = 3
      PM = MP
      NN = 0
C
C-PK For printing H2VOLC
      H2DEP = 0.
      PHICH4 = 0.
      PRINT 510, N, H2DEP, PHICH4
 510  FORMAT('N=',I4,2X,'PHIDEP(H2)=',1PE10.3,2X,'PHI(CH4)=',1PE10.3)
      PRINT 515, H2VOLC
 515  FORMAT(6X,'H2VOLC = ',1PE10.3)

C ***** START THE TIME-STEPPING LOOP *****
      DO 1 N=1,NSTEPS
      TIME = TIME + DT
c Reset H2S mixing ratio which goes negative up high
      DO 104 J=1,NZ
  104 USOL(LH2S,J) = ABS(USOL(LH2S,J))
c
C-PK Adjust volc H2 outgassing to equal H2 escape rate for f_tot +
C-PK 2*PHI_burial(CH20), where  PHI_burial(CH20) = (2%)*1/2*PHI_dep(H2) +
C-PK (2%)*1/10*PHI(CH4) [from CO-consuming acetogens; 10:1 metab:assim]
C-PK thus H2VOLC = H2ESC + (4%)[1/2*PHI_dep(H2) + 1/10*PHI(CH4)]
      PHICH4 = - DK(LCH4,1)*(USOL(LCH4,2) - USOL(LCH4,1))/DZ
     2  - 0.5*(HI(LCH4,1)*DEN(1)*USOL(LCH4,1) + HI(LCH4,2)*DEN(2)
     3         *USOL(LCH4,2)) - (YP(LCH4,1) - YL(LCH4,1)*SL(LCH4,1))*DZ
      H2DEP = VDEP(LH2)*SL(LH2,1)
      H2VOLC = 2.E10 + 0.04*(0.5*ABS(H2DEP) + 0.1*PHICH4)
C-PK Print out H2VOLC to make sure it's changing
C-PK Use this to print out every 5 steps...
      DO N1 = 1,400
      IF (N.EQ.5*N1) THEN
      PRINT 510, N, H2DEP, PHICH4
      PRINT 515, H2VOLC
      END IF
      END DO

      NN = NN + 1
      MS = (N-1)/MP
      SM = (N-1)/PM
      IF(NN.EQ.NSTEPS) SM = MS
      IF(SM-MS.GT.0.01) GO TO 18
      IF(N.GT.1 .AND. TIME.LT.1.E4) GO TO 18
C
C   STORE ABSORBERS USED TO BLOCK OUT SOLAR UV RADIATION
      DO 35 I=1,NZ
      H2O(I) = ABS(USOL(LH2O,I))
      O2(I) = ABS(USOL(LO2,I))
      CO2(I) = FCO2
      FSO2(I) = ABS(USOL(LSO2,I))
      H2S(I) = ABS(USOL(LH2S,I))
      S2(I) = ABS(USOL(LS2,I))
      FNH3(I) = ABS(USOL(LNH3,I))
      CH4(I) = ABS(USOL(LCH4,I))
      C2H6(I) = ABS(USOL(LC2H6,I))
  35  CONTINUE
      IDO = 0
      IF (NN.EQ.NSTEPS) IDO = 1
      CALL PHOTO(ZY,AGL,LTIMES,ISEASON,IZYO2,IO2,INO,IDO)
      CALL RAINOUT(DZ,ZTROP,JTROP,FCO2,NRAIN)
      CALL AERCON(H2O)
C
C   TIME-DEPENDENT BOUNDARY CONDITIONS
C  Escape of hydrogen: VEFF(H) = (Bi/Ha)/Nt, Nt=total number density
C
      BOVERH = DI(LH,NZ)*DEN(NZ)/HA
      VEFF(LH) = BOVERH/DEN(NZ)
      BOVERH2 = DI(LH2,NZ)*DEN(NZ)/HA
      VEFF(LH2) = BOVERH2/DEN(NZ)
      IF(NN.EQ.NSTEPS)PRINT 63, BOVERH,VEFF(LH),BOVERH2,VEFF(LH2)
  63  FORMAT(/*BOVERH =*,1PE10.3,*  VEFF(LH) = *,E10.3,*  BOVERH2 =*,
     2   E10.3,*  VEFF(LH2) = *,E10.3/)
      VCO2 = (PCO2(NZ) + PCO2D(NZ)) * HA
      SMFLUX(LO) = - VCO2*CO2(NZ)*DEN(NZ)
      SMFLUX(LCO) = SMFLUX(LO)
      NMP = NSTEPS - MP
      IF (NN.LT.NSTEPS) GO TO 18
C
      PRINT 97
  97  FORMAT(//1X,*PHOTOLYSIS RATES*)
      PRINT 98
  98  FORMAT(/5X,*Z*,7X,*PO2*,6X,*PO2D*,5X,*PCO2*,5X,*PCO2D*,4X,
     2  *PH2O*,5X,*PO3*,6X,*PO3D*,5X,*PH2O2*,4X,*PHCO*,5X,*PH2*,
     3  6X,*PHO2*,5X,*PHNO3*)
      PRINT 99,(Z(I),PO2(I),PO2D(I),PCO2(I),PCO2D(I),PH2O(I),
     2  PO3(I),PO3D(I),PH2O2(I),PHCO(I),PH2(I),PHO2(I),PHNO3(I),
     3  I=1,NZ,3)
  99  FORMAT(1X,1P13E9.2)
      PRINT 198
 198  FORMAT(/5X,*Z*,7X,*PNO*,6X,*PNO2*,5X,*PSO2*,5X,*PSO21*,4X,
     2  *PSO23*,4X,*PH2S*,5X,*PS2*,5X,*PH2SO4*,5X,
     3  *PNH3*,4X,*PN2H4*,4X,*PCH3*,4X,*PC2H4*)
      PRINT 199, (Z(I),PNO(I),PNO2(I),PSO2(I),PSO21(I),PSO23(I),
     2  PH2S(I),PS2(I),PH2SO4(I),PNH3(I),PN2H4(I),PCH3(I),PC2H4(I),
     3  I=1,NZ,3)
 199  FORMAT(1X,1P13E9.2)
      PRINT 298
 298  FORMAT(/5X,*Z*,7X,*PCH4A*,4X,*PCH4B*,4X,*PCH4C*,4X,*PC2H2A*,
     2  3X,*PC2H2B*,2X,*PCH3CHO*,2X,*PCH2CCH2*,2X,
     3  *PCH3C2H*,2X,*PCH2CO*)
      PRINT 299,(Z(I),PCH4A(I),PCH4B(I),PCH4C(I),PC2H2A(I),PC2H2B(I),
     2  PMCHO(I),PCH2CCH2(I),PCH3C2H(I),PCH2CO(I),I=1,NZ,3)
 299  FORMAT(1X,1P10E9.2)
      PRINT 398
 398  FORMAT(/5X,*Z*,6X,*PC2H6A*,3X,*PC2H6B*,3X,*PC2H6C*,3X,*PC2H6D*,
     2  3X,*PC2H6E*,3X,*PC3H8A*,4X,*PC3H8B*,3X,*PC3H8C*,3X,*PC3H8D*)
      PRINT 399, (Z(I),PC2H6A(I),PC2H6B(I),PC2H6C(I),PC2H6D(I),
     2  PC2H6E(I),PC3H8A(I),PC3H8B(I),PC3H8C(I),PC3H8D(I),
     3  I=1,NZ,3)
 399  FORMAT(1X,1P10E9.2)
  18  CONTINUE
C
      IDO = 0
      IF (NN.EQ.NSTEPS) IDO = 1
      CALL SEDMNT(FSULF,IDO)
C-AP      STOP
C-AP Since all model is in cm we should convert RSTAND
      DO k=1,34
       RSTAND(k) = RSTAND(k)/10000.
      ENDDO
C-AP Calculate Qext , W0, G, for the current aerosol distribution
      DO I=1,108
      DO J=1,NZ
      DO k=1,34
      IF ((RPAR(J,3).GE.RSTAND(k)).and.(RPAR(J,3).LT.RSTAND(k+1)))
     2 THEN
      drs = RSTAND(k+1) - RSTAND(k)
      dr  = RPAR(J,3) - RSTAND(k)
      QEXTT(I,J) = QEXTSTAND(I,k) + ((QEXTSTAND(I,k+1) - 
     2 QEXTSTAND(I,k))/drs)*dr
      GFT(I,J) = GSTAND(I,k) + ((GSTAND(I,k+1) - 
     2 GSTAND(I,k))/drs)*dr
      W0T(I,J) = W0STAND(I,k) + ((W0STAND(I,k+1) - 
     2 W0STAND(I,k))/drs)*dr
      ENDIF
      ENDDO
      ENDDO
      ENDDO
      DO 41 J=1,NZ
C-AP I added abs because 
      AERSOL(J,1) = SO4AER(J)*DEN(J)/CONVER(J,1)
      AERSOL(J,2) = S8(J)*DEN(J)/CONVER(J,2)
C-AP Should check this ABS later.
  41  AERSOL(J,3) = ABS(HCAER(J)*DEN(J)/CONVER(J,3))
C (moved this section to tridiagonal matrix setup)
C   COMPUTE ADVECTION TERMS FOR PARTICLES
c     DO 38 J=1,3
c     DPU(1,J) = WFALL(2,J)*DEN(2)/DEN(1)/(2.*DZ)
c     DPL(NZ,J) = WFALL(NZ1,J)*DEN(NZ1)/DEN(NZ)/(2.*DZ)
c     DO 38 I=2,NZ1
c     DPU(I,J) = WFALL(I+1,J)*DEN(I+1)/DEN(I)/(2.*DZ)
c 38  DPL(I,J) = WFALL(I-1,J)*DEN(I-1)/DEN(I)/(2.*DZ)
C
C ***** SET UP THE JACOBIAN MATRIX AND RIGHT-HAND SIDE *****
      DO 17 J=1,LDA
      DO 17 K=1,NEQ
  17  DJAC(J,K) = 0.
      DO 19 K=1,NEQ
  19  RHS(K) = 0.
C
C     (DJAC IS EQUAL TO (1/DT)*I - J, WHERE J IS THE JACOBIAN MATRIX)
C
C   COMPUTE CHEMISTRY TERMS AT ALL GRID POINTS
      IDO = 0
      IF (NN.EQ.NSTEPS) IDO = 1
      CALL DOCHEM(FVAL,IDO)
C-AP
C-AP      STOP
      DO 9 I=1,NQ
      DO 9 J=1,NZ
      K = I + (J-1)*NQ
      RHS(K) = FVAL(I,J)
   9  USAVE(I,J) = USOL(I,J)
C
      DO 3 I=1,NQ
      DO 11 J=1,NZ
      R(J) = EPSJ * ABS(USOL(I,J))
  11  USOL(I,J) = USAVE(I,J) + R(J)
      CALL DOCHEM(FV,0)
C
      DO 12 M=1,NQ
      MM = M - I + KD
      DO 12 J=1,NZ
      K = I + (J-1)*NQ
  12  DJAC(MM,K) = (FVAL(M,J) - FV(M,J))/R(J)
C
      DO 10 J=1,NZ
  10  USOL(I,J) = USAVE(I,J)
   3  CONTINUE
C
C   COMPUTE TRANSPORT TERMS AT INTERIOR GRID POINTS
      DO 13 I = 1,NQ
      DO 14 J=2,NZ1
      K = I + (J-1)*NQ
      RHS(K) = RHS(K) - DD(I,J)*USOL(I,J) 
     2  + (DU(I,J) + DHU(I,J))*USOL(I,J+1) 
     3  + (DL(I,J) - DHL(I,J))*USOL(I,J-1)
      DJAC(KD,K) = DJAC(KD,K) + DTINV + DD(I,J)
      DJAC(KU,K+NQ) = - DU(I,J) - DHU(I,J)
  14  DJAC(KL,K-NQ) = - DL(I,J) + DHL(I,J)
  13  CONTINUE
C
c (moved all particles to tridiagonal matrix)
C   ADD ADVECTION TERMS FOR PARTICLES
c     DO 53 M=1,2
c     IF(M.EQ.1)THEN
c      L = 1
c      I = LSO4AER
c     ELSE
c      L = 3
c      I = LHCAER
c     ENDIF
C
c     DO 24 J=2,NZ1
c     K = I + (J-1)*NQ
c     RHS(K) = RHS(K) + DPU(J,L)*USOL(I,J+1) - DPL(J,L)*USOL(I,J-1)
c     DJAC(KU,K+NQ) = DJAC(KU,K+NQ) - DPU(J,L)
c 24  DJAC(KL,K-NQ) = DJAC(KL,K-NQ) + DPL(J,L)
c 53  CONTINUE
C
C ***** LOWER BOUNDARY CONDITIONS *****
      DO 15 K=1,NQ
      U(K) = USOL(K,1)
      LB = LBOUND(K)
C
C   CONSTANT DEPOSITION VELOCITY
      IF(LB.NE.0) GO TO 16
C-PK  IF(K.EQ.9) THEN
C-PK   CALL VDEP_CO
C-PK   VDEP(K) = VDEPCO
C-PK   PRINT*,'VDEPCO=',VDEP(K),'cm/s'
C-PK  END IF
      RHS(K) = RHS(K) + (DU(K,1) + DHU(K,1))*USOL(K,2) - DU(K,1)*U(K)
     2  - (VDEP(K)/DZ - HI(K,1)/(2.*DZ))*U(K)
      DJAC(KD,K) = DJAC(KD,K) + DTINV + DU(K,1) + VDEP(K)/DZ
     2  - HI(K,1)/(2.*DZ)
      DJAC(KU,K+NQ) = - DU(K,1) - DHU(K,1)
c (moved SO4AER and HCAER to tridiagonal matrix)
c     IF (K.NE.LSO4AER .AND. K.NE.LHCAER) GO TO 15
c     IF(K.EQ.LHCAER) GO TO 52
c     RHS(K) = RHS(K) + DPU(1,1)*USOL(K,2) + 0.5*WFALL(1,1)/DZ * U(1)
c     DJAC(KD,K) = DJAC(KD,K) - 0.5*WFALL(1,1)/DZ
c     DJAC(KU,K+NQ) = DJAC(KU,K+NQ) - DPU(1,1)
c     GO TO 15
c 52  RHS(K) = RHS(K) + DPU(1,3)*USOL(K,2) + 0.5*WFALL(1,3)/DZ * U(1)
c     DJAC(KD,K) = DJAC(KD,K) - 0.5*WFALL(1,3)/DZ
c     DJAC(KU,K+NQ) = DJAC(KU,K+NQ) - DPU(1,3)
      GO TO 15
C
C   CONSTANT MIXING RATIO
  16  IF(LB.NE.1) GO TO 31
      RHS(K) = 0.
      DO 36 M=1,NQ
      MM = KD + K - M
  36  DJAC(MM,M) = 0.
      DJAC(KU,K+NQ) = 0.
      DJAC(KD,K) = DTINV + DU(K,1)
      GO TO 15
C
C   CONSTANT UPWARD FLUX
  31  CONTINUE
      RHS(K) = RHS(K) + (DU(K,1) + DHU(K,1))*USOL(K,2) - DU(K,1)*U(K)
     2   + HI(K,1)*U(K)/(2.*DZ) + SGFLUX(K)/DEN(1)/DZ
      DJAC(KD,K) = DJAC(KD,K) + DTINV + DU(K,1) + HI(K,1)/(2.*DZ)
      DJAC(KU,K+NQ) = - DU(K,1) - DHU(K,1)
  15  CONTINUE
C
C ***** UPPER BOUNDARY CONDITIONS *****
      DO 30 I=1,NQ
      U(I) = USOL(I,NZ)
      K = I + NZ1*NQ
      MB = MBOUND(I)
C
C   CONSTANT EFFUSION VELOCITY
      IF(MB.NE.0) GO TO 29
      RHS(K) = RHS(K) + (DL(I,NZ) - DHL(I,NZ))*USOL(I,NZ1) 
     2  - DL(I,NZ)*U(I) - (VEFF(I)/DZ + HI(I,NZ)/(2.*DZ))*U(I)
      DJAC(KD,K) = DJAC(KD,K) + DTINV + DL(I,NZ) + VEFF(I)/DZ
     2  + HI(I,NZ)/(2.*DZ)
      DJAC(KL,K-NQ) = - DL(I,NZ) + DHL(I,NZ)
c (moved SO4AER and HCAER to tridiagonal matrix)
c     IF (I.NE.LSO4AER .AND. I.NE.LHCAER) GO TO 30
c     IF (I.EQ.LHCAER) GO TO 54
c     RHS(K) = RHS(K) - 0.5*WFALL(NZ,1)/DZ * U(I) - DPL(NZ,1)*
c    2  USOL(I,NZ1)
c     DJAC(KD,K) = DJAC(KD,K) + 0.5*WFALL(NZ,1)/DZ
c     DJAC(KL,K-NQ) = DJAC(KL,K-NQ) + DPL(NZ,1)
c     GO TO 30
c 54  RHS(K) = RHS(K) - 0.5*WFALL(NZ,3)/DZ * U(I) - DPL(NZ,3)*
c    2  USOL(I,NZ1)
c     DJAC(KD,K) = DJAC(KD,K) + 0.5*WFALL(NZ,3)/DZ
c     DJAC(KL,K-NQ) = DJAC(KL,K-NQ) + DPL(NZ,3)
      GO TO 30
C
C   CONSTANT DOWNWARD FLUX
  29  CONTINUE
      RHS(K) = RHS(K) + (DL(I,NZ) - DHL(I,NZ))*USOL(I,NZ1)
     2  - DL(I,NZ)*U(I) - HI(I,NZ)*U(I)/(2.*DZ) 
     3  - SMFLUX(I)/DEN(NZ)/DZ
      DJAC(KD,K) = DJAC(KD,K) + DTINV + DL(I,NZ) + HI(I,NZ)/(2.*DZ) 
      DJAC(KL,K-NQ) = - DL(I,NZ) + DHL(I,NZ)
  30  CONTINUE
C
C   HOLD H2O CONSTANT BELOW ZTROP
      DO 33 J=1,NZ
      IF(Z(J).GT.ZTROP) GO TO 34
      K = 3 + (J-1)*NQ
      RHS(K) = 0.
      DO 32 M=1,NQ
      MM = M - 3 + KD
  32  DJAC(MM,K) = 0.
      DJAC(KD,K) = DTINV
      DJAC(KU,K+NQ) = 0.
      IF(J.EQ.1) GO TO 33
      DJAC(KL,K-NQ) = 0.
  33  CONTINUE
  34  CONTINUE
C
C ***** FACTOR THE JACOBIAN AND SOLVE THE LINEAR SYSTEM *****
      CALL SGBFA(DJAC,LDA,NEQ,NQ,NQ,IPVT,INDEX)
      IF(INDEX.NE.0) PRINT 103,N,INDEX
 103  FORMAT(/1X,*N =*,I3,5X,*INDEX =*,I9)
      CALL SGBSL(DJAC,LDA,NEQ,NQ,NQ,IPVT,RHS,0)
C
C   COMPUTE NEW CONCENTRATIONS (IGNORE ERRORS IN SEVERAL SPECIES
C     THAT VIRTUALLY DISAPPEAR UP HIGH)
      EMAX = 0.
      DO 26 I=1,NQ
      DO 26 J=1,NZ
      K = I + (J-1)*NQ
C   CALCULATE NUMBER DENSITIES
      SL(I,J) = USOL(I,J)*DEN(J)
C
C-AP switched boundary condition for S2 from 17 to 1
      IF(I.EQ.LS2) GO TO 26
      IF(I.EQ.LS) GO TO 26
      IF(I.EQ.LHS .AND. J.GT.57) GO TO 26
C-AP
C-AP      IF(I.EQ.LS .AND. J.LT.10) GO TO 26
C-AP1
C-AP2      IF(I.EQ.LS .AND. J.GT.60) GO TO 26
C-AP
      IF(I.EQ.LH2S .AND. J.GT.30) GO TO 26
C-AP Shift from 53 to 58
      IF(I.EQ.LC3H2 .AND. J.LT.65) GO TO 26
      IF(I.EQ.LN2H4 .AND. J.GT.16) GO TO 26
C-AP for methane      IF(I.EQ.LN2H3 .AND. J.GT.14) GO TO 26
      IF(I.EQ.LN2H3 .AND. J.GT.10) GO TO 26
C-AP for methane      IF(I.EQ.LNH2 .AND. J.GT.14) GO TO 26
      IF(I.EQ.LNH2 .AND. J.GT.16) GO TO 26
      IF(I.EQ.LNH3 .AND. J.GT.16) GO TO 26
C-AP for methane      IF(I.EQ.LNH3 .AND. J.GT.14) GO TO 26
C-AP      IF(I.EQ.LC2H3) GO TO 26
C-AP For low CH4 abundance
C-AP      IF(I.EQ.LCH23) GO TO 26
C-AP Changing condition on No2 80 instead of 83
      IF(I.EQ.LNO2 .AND. J.GT.83) GO TO 26
C-AP Adding O2 condition 
C      IF(I.EQ.LO2 .AND. J.GT.83) GO TO 26
C-AP     IF(I.EQ.LCH3C2H .AND. J.LT.20) GO TO 26
      IF(I.EQ.LCH3C2H .AND. J.LT.45) GO TO 26
C-AP2      IF(I.EQ.LCH3C2H) GO TO 26
C-AP      IF(I.EQ.LCH2CCH2 .AND. J.LT.45) GO TO 26
      IF(I.EQ.LCH2CCH2) GO TO 26
C-AP      IF(I.EQ.LCH2CCH2 .AND. J.LT.24) GO TO 26
C-AP Shift from 10 to 50
C-AP      IF(I.EQ.LC3H6 .AND. J.LT.50) GO TO 26
      IF(I.EQ.LC3H6) GO TO 26
C-AP2      IF(I.EQ.LC3H8 .AND. J.GT.40) GO TO 26
C-APc     IF(I.EQ.LC3H8 .AND. J.GT.65) GO TO 26
C-AP
C-AP2      IF(I.EQ.LC2H2 .AND. J.LT.41) GO TO 26
C-AP
C-AP      IF(I.EQ.LH2O2 .AND. J.LT.12) GO TO 26
C-AP      IF(I.EQ.LH2O2 .AND. J.LT.16) GO TO 26
c     IF(I.EQ.LH2O2 .AND. J.GT.90) GO TO 26
C
C-AP
C-AP      IF(I.EQ.LH2SO4) GO TO 26
C-AP
      REL(I,J) = RHS(K)/USOL(I,J)
      EREL = ABS(REL(I,J))
      EMAX = AMAX1(EMAX,EREL)
      IF(EREL.LT.EMAX) GO TO 26
      IS = I
      JS = J
      UMAX = USOL(I,J)
      RMAX = RHS(K)
  26  USOL(I,J) = USOL(I,J) + RHS(K)
C
C   RESET TROPOSPHERIC H2O TO ITS ORIGINAL VALUES, IN CASE IT CHANGED.
C     (IT SHOULDN'T HAVE, BUT IT MIGHT.)  ALSO, SULFATE AEROSOL HAS A
C     TENDENCY TO GO NEGATIVE NEAR THE UPPER BOUNDARY, SO MAKE SURE
C     IT DOESN'T STAY THAT WAY.)
      DO 4 J=1,NZ
      IF (Z(J).LT.ZTROP) USOL(LH2O,J) = H2O(J)
   4  CONTINUE
c (moved sulfate to tridiagonal matrix)
c     DO 49 J=1,NZ
c 49  USOL(LSO4AER,J) = ABS(USOL(LSO4AER,J))
C
C ***** SOLVE FOR S8 (AND POSSIBLY OTHER SPECIES AS WELL) USING A
C       TRIDIAGONAL INVERSION *****
      DO 58 L=1,3
      I = NQ + L
      IF(I.EQ.LSO4AER) MZ = 50
      IF(I.EQ.LS8AER) MZ = 40
      IF(I.EQ.LHCAER) MZ = NZ
      MZ1 = MZ - 1
      MZP1 = MZ + 1
C
C   COMPUTE ADVECTION TERMS FOR PARTICLES
      DPU(1,L) = WFALL(2,L)*DEN(2)/DEN(1)/(2.*DZ)
      DPL(NZ,L) = WFALL(NZ1,L)*DEN(NZ1)/DEN(NZ)/(2.*DZ)
      DO 38 J=2,NZ1
      DPU(J,L) = WFALL(J+1,L)*DEN(J+1)/DEN(J)/(2.*DZ)
  38  DPL(J,L) = WFALL(J-1,L)*DEN(J-1)/DEN(J)/(2.*DZ)
C
C   TA = LOWER DIAGONAL, TB = DIAGONAL, TC = UPPER DIAGONAL, TY =
C   RIGHT-HAND SIDE
      DO 70 J=1,NZ
      TA(J) = 0.
      TB(J) = 0.
      TC(J) = 0.
  70  TY(J) = 0.
C
      DO 44 J=1,MZ
      TB(J) = YL(I,J)
  44  TY(J) = YP(I,J)/DEN(J)
C
      DO 45 J=2,MZ1
      TA(J) = - DL(I,J) + DPL(J,L)
      TB(J) = TB(J) + DD(I,J)
  45  TC(J) = - DU(I,J) - DPU(J,L)
C
C   BOUNDARY CONDITIONS
      TA(MZ) = - DL(I,MZ) + DPL(MZ,L)
      TB(MZ) = TB(MZ) + DL(I,MZ) + 0.5*WFALL(MZ,L)/DZ
      TB(1) = TB(1) + DU(I,1) + (.01 - 0.5*WFALL(1,L))/DZ
      TC(1) = - DU(I,1) - DPU(1,L)
C
      CALL SGTSL(MZ,TA,TB,TC,TY,NFLAG)
      IF (NFLAG.NE.0) PRINT 400, N,NFLAG,I
 400  FORMAT(//1X,*TRIDIAGONAL SOLVER FAILED AT N =*,I3,2X,
     2  *NFLAG =*,I2,2X,*SPECIES #*,I2)
C
      IF(I.EQ.LSO4AER) THEN
        DO 59 J=1,MZ
   59     SO4AER(J) = TY(J)
      ELSEIF(I.EQ.LS8AER) THEN
        DO 46 J=1,MZ
   46     S8(J) = TY(J)
      ELSEIF(I.EQ.LHCAER) THEN
        DO 60 J=1,MZ
          HCAER(J) = TY(J)
   60   CONTINUE
      ENDIF
C
C   FILL UP UPPER PORTION WITH APPROXIMATE ANALYTIC SOLUTION
      IF(I.EQ.LSO4AER .AND. MZ.NE.NZ) THEN
        DO 61 J=MZP1,NZ
          SO4AER(J) = SO4AER(J-1) * EXP(-WFALL(J,L)*DZ/EDD(J))
   61     SO4AER(J) = AMAX1(SO4AER(J),1E-100)
      ELSEIF(I.EQ.LS8AER .AND. MZ.NE.NZ) THEN
        DO 47 J=MZP1,NZ
          S8(J) = S8(J-1) * EXP(-WFALL(J,L)*DZ/EDD(J))
  47      S8(J) = AMAX1(S8(J),1E-100)
      ELSEIF(I.EQ.LHCAER .AND. MZ.NE.NZ) THEN
        DO 62 J=MZP1,NZ
          HCAER(J) = HCAER(J-1) * EXP(-WFALL(J,L)*DZ/EDD(J))
          HCAER(J) = AMAX1(HCAER(J),1E-100)
   62   CONTINUE
      ENDIF
   58 CONTINUE
C
C   AUTOMATIC TIME STEP CONTROL
      DTSAVE = DT
      IF(EMAX.GT.0.15)  DT = 0.9*DTSAVE
      IF(EMAX.GT.0.20)  DT = 0.7*DTSAVE
      IF(EMAX.LT.0.10)  DT = 1.1*DTSAVE
      IF(EMAX.LT.0.05)  DT = 1.3*DTSAVE
      IF(EMAX.LT.0.03)  DT = 1.5*DTSAVE
      IF(EMAX.LT.0.01)  DT = 2.0*DTSAVE
      IF(EMAX.LT.0.003) DT = 5.0*DTSAVE
      IF(EMAX.LT.0.001) DT = 10.*DTSAVE
      DTINV = 1./DT
C
      ISP = ISPEC(IS)
      ZMAX = Z(JS)
      IF(SM-MS.GT.0.01) GO TO 317
      PRINT 100, N,EMAX,ISP,ZMAX,UMAX,RMAX,DT,TIME
 100  FORMAT(1X,*N =*,I4,2X,*EMAX =*,1PE9.2,* FOR *,A8,
     2  *AT Z =*,E9.2,1X,*U =*,E9.2,1X,*RHS =*,E9.2,
     3  2X,*DT =*,E9.2,2X,*TIME =*,E9.2)
C-PK      PRINT 504, DEN(JS),SL(IS,JS)
C-PK 504  FORMAT(9X, *,1PE9.2,* DEN(I) = *,1PE9.2)
C
C   COMPUTE ATMOSPHERIC OXIDATION STATE
      DO 42 I=1,NQ
      SR(I) = 0.
      DO 43 J=1,JTROP
  43  SR(I) = SR(I) + RAINGC(I,J)*USOL(I,J)*DEN(J)*DZ
      PHIDEP(I) = VDEP(I)*USOL(I,1)*DEN(1)
  42  TLOSS(I) = SR(I) + PHIDEP(I)
C
      SR(LSO4AER) = 0.
      SR(LS8AER) = 0.
      SR(LHCAER) = 0.
      DO 48 J=1,JTROP
      SR(LSO4AER) = SR(LSO4AER) + RAINGC(LH2SO4,J)*SO4AER(J)*DEN(J)*DZ
      SR(LS8AER) = SR(LS8AER) + RAINGC(LH2SO4,J)*S8(J)*DEN(J)*DZ
      SR(LHCAER) = SR(LHCAER) + RAINGC(LH2SO4,J)*HCAER(J)
     2   *DEN(J)*DZ
  48  CONTINUE
      PHIDEP(LSO4AER) = (WFALL(1,1) + .01) * SO4AER(1) * DEN(1)
      PHIDEP(LS8AER) = (WFALL(1,2) + .01) * S8(1) * DEN(1)
      PHIDEP(LHCAER) = (WFALL(1,3) + .01) * HCAER(1) * DEN(1)
      TLOSS(LSO4AER) = SR(LSO4AER) + PHIDEP(LSO4AER)
      TLOSS(LS8AER) = SR(LS8AER) + PHIDEP(LS8AER)
      TLOSS(LHCAER) = SR(LHCAER) + PHIDEP(LHCAER)
C
C  PHIESC = (Bi/Ha)*fT, where fT = total H2 mixing ratio.
C
      PHIESC = BOVERH * (USOL(LH2O,NZ) + 0.5*USOL(LH,NZ) + USOL(LH2,NZ)
     2  + 2.*USOL(LCH4,NZ) + 3.*USOL(LC2H6,NZ) + 1.5*USOL(LNH3,NZ)
     3  + 2.*USOL(LN2H4,NZ))
C
C   CHEMICAL PRODUCTION TERMS FOR H2: REMOVAL OF OXIDIZED SPECIES
C-PK      HBUG(LO2) = -2.*TLOSS(LO2)
C-PK      HBUG(LOH) = - 0.5*TLOSS(LOH)
C-PK      HBUG(LHO2) = -1.5*TLOSS(LHO2)
C-PK      HBUG(LH2O2) = - TLOSS(LH2O2)
C-PK      HBUG(LHNO) = - 0.5*TLOSS(LHNO)
C-PK      HBUG(LSO4AER) = - TLOSS(LSO4AER)
C-PK      HBUG(LH2SO4) = - TLOSS(LH2SO4)
C
C   CHEMICAL LOSS TERMS FOR H2: REMOVAL OF REDUCED SPECIES
C-PK      HBUG(LH2CO) = 2.*TLOSS(LH2CO)
C-PK      HBUG(LHCO) = 1.5*TLOSS(LHCO)
C-PK      HBUG(LH2S) = 3.*TLOSS(LH2S)
C-PK      HBUG(LHS) = 2.5*TLOSS(LHS)
C-PK      HBUG(LHSO) = 1.5*TLOSS(LHSO)
C-PK      HBUG(LS8AER) = 16.*TLOSS(LS8AER)
C-PK      HBUG(LNH3) = 1.5*TLOSS(LNH3)
C-PK      HBUG(LN2H4) = 2.*TLOSS(LN2H4)
C-PK      HBUG(LHCAER) = 9.*TLOSS(LHCAER)
C
C   COMPUTE NET LOSS OF H2 FROM RAINOUT AND SURFACE DEPOSITION
C-PK      H2CHEM = 0.
C-PK      DO 39 I=1,NQT
C-PK  39  H2CHEM = H2CHEM + HBUG(I)
C
C   COMPUTE SULFUR BUDGET AND READJUST SO2 (H2S) OUTGASSING RATE IF SO
C   DESIRED (PROGRAM IS SET UP FOR PURE SO2 OUTGASSING)
      SLOSS = TLOSS(LH2S) + TLOSS(LHS) + TLOSS(LS) + TLOSS(LSO) +
     2  TLOSS(LSO2) + TLOSS(LH2SO4) + TLOSS(LHSO) + 2.*TLOSS(LS2) +
     3  TLOSS(LSO4AER) + 8.*TLOSS(LS8AER)
      SLOSSP = SLOSS - TLOSS(LSO2)
      IF (ISULF.EQ.0 .OR. TIME.LT.1.E6) GO TO 316
      IF (LBOUND(LSO2).EQ.2) SGFLUX(LSO2) = SGFLUX(LSO2) * VOLFLX/SLOSS
      IF (LBOUND(LH2S).EQ.2) SGFLUX(LH2S) = SGFLUX(LH2S) * VOLFLX/SLOSS
 316  CONTINUE
C
      IF (IH2.EQ.0 .OR. TIME.LT.1.E6) GO TO 315
c     HFAC = (H2PROD/H2LOSS)**0.05
C-AP      DO 314 I=1,NZ
C-AP 314  USOL(LH2,I) = HFAC * USOL(LH2,I)
 315  CONTINUE
C
      SFLUX = SGFLUX(LH2S) + SGFLUX(LSO2)
C-PK      PRINT 101, H2CHEM,PHIESC,SLOSS,SLOSSP
C-PK 101  FORMAT(10X,*H2CHEM =*,1PE10.3,2X,*PHIESC =*,
C-PK     2  E10.3,2X,*SLOSS =*,E10.3,2X,*SLOSSP =*,E10.3/)
 317  CONTINUE
C
C   RETRY TIME STEP IF EMAX EXCEEDS 30 PERCENT
      IF(EMAX.LT.0.3) GO TO 28
      DT = 0.5*DTSAVE
      TIME = TIME - DTSAVE
      DO 27 I=1,NQ
      DO 27 J=1,NZ
  27  USOL(I,J) = USAVE(I,J)
  28  CONTINUE
C
      NS = N/NPR
      SN = N/PRN
      IF(NN.EQ.NSTEPS) SN = NS
      IF(SN-NS.GT.1.E-3) GO TO 37
C
      CALL OUTPUT(NN,NSTEPS,TIME)
  37  CONTINUE
      IF(INDEX.NE.0) STOP
      IF(NN.EQ.NSTEPS) GO TO 22
      IF(TIME.GT.TSTOP) NN = NSTEPS - 1
   1  CONTINUE
C ***** END THE TIME-STEPPING LOOP *****
  22  CONTINUE
C-PK Write to file used for TPF spectra
      WRITE(59,230)
 230    FORMAT(/1X,*Alt [km]*,3X,*Pres [Pa]*,3X,*Temp [K]*,4X,*f(O3)*,
     2    5X,*f(CO2)*,5X,*f(H2O)*,5X,*f(CH4)*/)
      DO J=NZ,1,-1
        BOLTZ = 1.38E-16
        PRES_MKS(J) = DEN(J)*BOLTZ*T(J)*0.1
        WRITE(59,231) J,PRES_MKS(J),T(J),O3(J),CO2(J),
     2    USOL(LH2O,J),USOL(LCH4,J)
      END DO
 231    FORMAT(3X,I3,4X,6(1PE11.3))
      WRITE(59,230)

      WRITE(8,501) USOL,T,EDD,DEN,O3,SO4AER,S8,HCAER,AERSOL,
     2   WFALL,RPAR
 501  FORMAT(1P6E12.5)
C print out P&L tables with integrated rxn rates, "int.rates.out.dat"
      DO 702 I=1,NSP
         ISP = ISPEC(I)
         WRITE(15,703) ISP,TP(I)
 703     FORMAT(/A8,12X,*PRODUCTION RXS*,14X,*INT RX RATE*,4X,
     2      *TP = *,1PE9.2)
       DO 704 N=1,NR 
          IF(JCHEM(3,N).EQ.I .OR. JCHEM(4,N).EQ.I .OR. 
     2       JCHEM(5,N).EQ.I)THEN
           IF(RAT(N).NE.0.) WRITE(15,705) N,(CHEM(J,N),J=1,5),RAT(N)
 705       FORMAT(1X,I3,1H),1X,A7,3H + ,A7,3H = ,A7,3H + ,A6,2X,A4,
     2      1PE10.3)
          ENDIF
 704   CONTINUE
C
         WRITE(15,706) ISP,TL(I)
 706     FORMAT(/A8,15X,*LOSS RXS*,16X,*INT RX RATE*,4X,*TL = *,1PE9.2)
       DO 707 N=1,NR 
          IF(JCHEM(1,N).EQ.I .OR. JCHEM(2,N).EQ.I)THEN
             IF(RAT(N).NE.0.) WRITE(15,705) N,(CHEM(J,N),J=1,5),RAT(N)
          ENDIF
 707   CONTINUE
 702  CONTINUE
C
      GO TO 21
  20  PRINT 300,I
 300  FORMAT(//1X,*NMAX EXCEEDED FOR SPECIES *,I3)
      GO TO 21
  25  PRINT 301,IERR
 301  FORMAT(//1X,*ERROR IN REACTION *,I3)
C
  21  CONTINUE
      PRINT *, 'TAUO2 = ', TAUO2
      PRINT *, 'TAUCH4 = ', TAUCH4
      STOP
      END PROGRAM ARC_CH4

C-PK *******************************
      SUBROUTINE GRID
      PARAMETER(NZ=100, NQ=39, NQT=NQ+3)
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),T(NZ),G,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
C
C ***** SET UP THE VERTICAL GRID ZS *****
      DO 1 I=1,NZ
      Z(I) = (I - 0.5)*DELZ
   1  CONTINUE
      RETURN
      END
C-PK ********************************
      SUBROUTINE RATES
      PARAMETER(NZ=100, NQ=39, NQT=NQ+3)
      PARAMETER(NR=359, NSP=73, NSP1=NSP+1, NSP2=NSP+2, NMAX=70)
      DIMENSION A3(NZ),A4(NZ),A5(NZ),A6(NZ),A10(NZ),A11(NZ),A12(NZ),
     2  A13(NZ),A14(NZ),A15(NZ),A16(NZ),A17(NZ),A18(NZ),A19(NZ),
     3  A20(NZ),A21(NZ),A22(NZ),A30(NZ),A31(NZ),A32(NZ),A41(NZ),
     4  A43(NZ),A46(NZ),A47(NZ),A48(NZ)
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),T(NZ),G,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
      COMMON/RBLOK/A(NR,NZ),ILOSS(2,NSP,NMAX),IPROD(NSP,NMAX),
     2  JCHEM(5,NR),NUML(NSP),NUMP(NSP)
C
C ***** TEMPERATURE-DEPENDENT RATE COEFFICIENTS *****
      DO 1 I=1,NZ
      PATM = DEN(I)*1.38E-16*T(I)/1.013E6
      A3(I) = 3.E-14*T(I)*EXP(-4480./T(I))
      A4(I) = 5.5E-12*EXP(-2000./T(I))
      A5(I) = 1.4E-10*EXP(-470./T(I))
      A10(I) = 2.2E-11*EXP(120./T(I))
      A12(I) = 1.6E-12*EXP(-940./T(I))
      A13(I) = 3.0E-11*EXP(200./T(I))
      A14(I) = 1.1E-14*EXP(-500./T(I))
      A15(I) = 2.3E-13*EXP(600./T(I)) + 1.7E-33*EXP(1000./T(I))
     2  *DEN(I)
      a16(i) = 2.9E-12*EXP(-160./T(I))
      A17(I) = 2.76E-34*EXP(710./T(I))*DEN(I)
      A19(I) = 8.0E-12 * EXP(-2060./T(I))
      A20(I) = 4.2E-12*EXP(-240./T(I))
      A21(I) = 1.8E-11*EXP(110./T(I))
      A22(I) = 3.2E-11*EXP(70./T(I))
      A30(I) = 1.5E-13 * (1. + 0.6*PATM)
      A31(I) = 6.5E-33*EXP(-2180./T(I))*DEN(I)
      A32(I) = 2.0E-33*EXP(-850./T(I))*DEN(I)
      A41(I) = 2.8E-11*EXP(-1540./T(I))
      A46(I) = 6.1E-26/T(I)/T(I) *DEN(I)
      A48(I) = 3.4E-11*EXP(-1600./T(I))
   1  CONTINUE
C
C ***** THREE-BODY COEFFICIENTS *****
      DO 3 I=1,NZ
      TT = T(I)
      DN = DEN(I)
C     A(J,I) = TBDY(K0,KI,N,M,T,DEN)
C
C  HO2
      A(6,I) = TBDY(5.7E-32,7.5E-11,1.6,0.,TT,DN)
C
C  O3
      A(18,I) = TBDY(6.E-34,1.E-10,2.3,0.,TT,DN)
C
C  H2O2
      A(47,I) = TBDY(6.9E-31,1.5E-11,0.8,0.,TT,DN)
C
C   CH3O2
      A(67,I) = TBDY(4.5E-31,1.8E-12,3.0,1.7,TT,DN)
C
C   NO2
      A(84,I) = TBDY(9.E-32,3.E-11,1.5,0.,TT,DN)
C
C   HNO2
      A(86,I) = TBDY(7.E-31,1.5E-11,2.6,0.5,TT,DN)
C
C   HNO3
      A(88,I) = TBDY(2.6E-30,2.4E-11,3.2,1.3,TT,DN)
C
C   C2H5O2
      A(110,I) = TBDY(1.5E-28,8.E-12,3.0,0.,TT,DN)
C
C   HSO3
      A(118,I) = TBDY(3.E-31,1.5E-12,3.3,0.,TT,DN)
   3  CONTINUE
C
C ***** FILL UP RATE MATRIX *****
      DO 4 I=1,NZ
      A(1,I) = 2.2E-10
      A(2,I) = 1.0E-10
      A(3,I) = A3(I)
      A(4,I) = A4(I)
      A(5,I) = A5(I)
      A(7,I) = 8.1E-11 * 0.08
      A(8,I) = 8.1E-11 * 0.02
      A(9,I) = 8.1E-11 * 0.90
      A(10,I) = A10(I)
      A(11,I) = 4.8E-11*EXP(250./T(I))
      A(12,I) = A12(I)
      A(13,I) = A13(I)
      A(14,I) = A14(I)
      A(15,I) = A15(I)
      A(16,I) = A16(I)
      A(17,I) = A17(I)
      A(19,I) = A19(I)
      A(20,I) = A20(I)
      A(21,I) = A21(I)
      A(22,I) = A22(I)
      A(30,I) = A30(I)
      A(31,I) = A31(I)
      A(32,I) = A32(I)
      A(33,I) = 1.2E-10
      A(34,I) = 2.3E-11
      A(35,I) = 5.0E-11
      A(36,I) = 1.0E-10
      A(37,I) = 1.0E-10
      A(40,I) = 1.0E-2
      A(41,I) = A41(I)
      A(43,I) = 1.5E-29/T(I)**1.3
      A(44,I) = 5.5E-11/T(I)**0.4
      A(45,I) = 1.E-11
      A(46,I) = A46(I)
      A(48,I) = A48(I)
      A(49,I) = 1.4E-12 * EXP(-2000./T(I))
      A(58,I) = 2.9E-12 * EXP(-1820./T(I))
      A(59,I) = 1.4E-10
      A(60,I) = 1.4E-11
      A(61,I) = 6.E-11
      A(62,I) = 3.E-11
      A(63,I) = 8.8E-12
      A(64,I) = 0.
      A(65,I) = 0.
      A(66,I) = 1.5E-12
      A(68,I) = 9.3E-11
      A(69,I) = 1.1E-10
      A(70,I) = 5.4E-12 * EXP(-220./T(I))
      FC = 0.381 * EXP(-T(I)/73.2) + 0.619 * EXP(-T(I)/1180)
      B0 = 8.76E-7/T(I)**7.03 * EXP(-1390/T(I)) * DEN(I)
      BI = 1.5E-7/T(I)**1.18 * EXP(-329/T(I))
      A(71,I) = TBDY3(FC,B0,BI)
      FC = 0.902 - (1.03E-3*T(I))
      B0 = 4.E-29*DEN(I)
      BI = 4.7E-10
      A(73,I) = TBDY3(FC,B0,BI)
      A(74,I) = 8.2E-11
      A(75,I) = 3.E-14
   4  CONTINUE
C
      DO 5 I=1,NZ
      A(76,I) = 2.8E-11*EXP(-1540./T(I))
      A(77,I) = 2.1E-32*EXP(300./T(I)) * DEN(I)
C      A(78,I) = 8.3E-34*EXP(500./T(I)) * DEN(I)
      A(78,I) = 0.
      A(79,I) = 1.5E-11*EXP(-3600./T(I))
      A(80,I) = 0.
      A(81,I) = 5.3E-11
      A(82,I) = 3.4E-11
      A(83,I) = 2.0E-12 * EXP(-1400./T(I))
      A(85,I) = 3.7E-12 * EXP(250./T(I))
      A(87,I) = 6.5E-12 * EXP(120./T(I))
      A(89,I) = 4.E-10 * EXP(-340./T(I))
      AK0 = 7.2E-15*EXP(785./T(I))
      AK2 = 4.1E-16*EXP(1440./T(I))
      AK3M = 1.9E-33*EXP(725./T(I))*DEN(I)
      A(90,I) = AK0 + AK3M/(1. + AK3M/AK2)
      A(91,I) = 1.2E-10/T(I)**0.4
      A(92,I) = 1.7E-3
      A(93,I) = 5.E-13*SQRT(T(I))*EXP(-1200./T(I))
      A(94,I) = A(93,I)
      A(95,I) = 6.E-11
      A(96,I) = 1.8E-11 * EXP(-390./T(I))
      A(97,I) = 5.8E-11*EXP(-4450./T(I))
      A(98,I) = 9.24E-11
      A(99,I) = 1.E-12
      A(100,I) = 1.E-11
      A(101,I) = 3.9E-14
      A(102,I) = 8.7E-12*EXP(-1070./T(I))
      A(103,I) = 4.1E-11*EXP(-3200./T(I))
      A(104,I) = 1.4E-10
      A(105,I) = 7.95E-11*EXP(-127./T(I))
      A(106,I) = 1.1E-10
      A(107,I) = 1.1E-10
      A(108,I) = 5.E-11
      A(109,I) = 3.E-14
   5  CONTINUE
C
      DO 7 I=1,NZ
      A(114,I) = 2.4E-13 * EXP(-2370./T(I))
      A(115,I) = 2.8E-11
      A(116,I) = 6.0E-31 * DEN(I)
      A(117,I) = 8.6E-11
      A(119,I) = 3.4E-32 * EXP(-1130./T(I)) * DEN(I)
      A(120,I) = 6.0E-15
      A(121,I) = 1.3E-12 *EXP(-330./T(I))
      A(122,I) = 1.0E-11
      A(123,I) = 1.0E-11
      A(124,I) = 1.0E-11
      A(125,I) = 6.0E-12 * EXP(-75./T(I))
      A(126,I) = 1.3E-11 * EXP(-860./T(I))
      A(127,I) = 9.2E-12 * EXP(-1800./T(I))
      A(128,I) = 1.6E-10
      A(129,I) = 4.0E-19
      A(130,I) = 3.0E-11
      A(131,I) = 1.2E-11
      A(132,I) = 5.0E-11
      A(133,I) = 1.0E-11
      A(134,I) = 2.2E-11 * EXP(120./T(I))
      A(135,I) = 2.3E-12
      A(136,I) = 6.6E-11
      A(137,I) = 5.0E-11
      A(138,I) = 1.5E-11
      A(139,I) = 1.5E-11
      A(140,I) = A(17,I)
      A(141,I) = 0.
      A(142,I) = 1.1E-11
      A(143,I) = 1.7E-11 * EXP(-800./T(I))
   7  CONTINUE
C
      DO 8 I=1,NZ
      A(150,I) = 1.0E-12
      A(151,I) = 1.0E-11
      A(152,I) = 1.5E+3
      A(153,I) = 2.2E+4
      A(154,I) = 1.0E-16
      A(155,I) = 4.0E-12
      A(156,I) = 1.5E-13
      A(157,I) = 1.13E+3
      A(158,I) = 7.0E-14
      A(159,I) = 1.4E-11
      A(160,I) = 3.6E-12 * EXP(-1100./T(I))
      A(161,I) = 0.
      A(162,I) = 9.0E-12 * EXP(-280./T(I))
      A(163,I) = 2.9E-11 * EXP(240./T(I))
      A(164,I) = 1.2E-11
      A(165,I) = 8.3E-15
      A(166,I) = 2.0E-15
      A(167,I) = 1.0E-20
      A(168,I) = 0.
      A(169,I) = A(44,I)
      A(170,I) = A(6,I)
      A(172,I) = A(85,I)
      A(173,I) = A(11,I)
      A(174,I) = A(9,I)
      A(175,I) = A(7,I)
      A(176,I) = 1.E-12
      A(177,I) = A(13,I)
      A(178,I) = 1.E-11
      A(179,I) = 2.8E-32*DEN(I)
      A180 = 2.8E-31*DEN(I)
      A(180,I) = A180
      A(181,I) = A180
      A(182,I) = A180
   8  CONTINUE
C
      DO 9 I=1,NZ
      A(186,I) = 1.7E-12 * EXP(-710./T(I))
      A(187,I) = 2.5E-10
      A(188,I) = (6.E-30 * DEN(I))/(1. + 3.E-20 * DEN(I))
      A(189,I) = 3.8E-12 * EXP(450./T(I))
      A(190,I) = 1.E-10
      A(191,I) = 5.E-12
      A(192,I) = 5.E-12
      A(193,I) = 4.9E-11
      A(194,I) = 1.E-11
      A(196,I) = 9.9E-12 * EXP(-1200./T(I))
      A(197,I) = 2.7E-12
      A(198,I) = 6.E-11
      A(199,I) = A(188,I)
      A(202,I) = 3.8E-3
      A(203,I) = 1.2E5
      A(204,I) = 3.E-11
      A(205,I) = 3.E-11
      A(206,I) = 1.E-11
      A(207,I) = 1.E-11
      A(208,I) = 0.
      A(209,I) = 0.
      A(213,I) = 7.E-11
      B0 = 2.519E-16 / T(I)**2.458
      BI = 8.12E-10 / T(I)**0.5
      A(214,I) = TBDY2(B0,BI,DEN(I))
      A(215,I) = 1.1E-11 * EXP(-700./T(I))
      A(216,I) = 1.6E-11 * EXP(-2900./T(I)) 
     2           + 2.2E-11 * EXP(-2250./T(I))
      A(217,I) = A(59,I)
      A(218,I) = A(105,I)
      A(219,I) = 0.
      A(220,I) = 2.E-12 * EXP(-250./T(I))
      B0 = 2.6E-31
      BI = 3.8E-11 * EXP(-1374./T(I))
      A(221,I) = TBDY2(B0,BI,DEN(I))
      A(222,I) = 3.3E-11
      A(223,I) = 2.6E-13 * EXP(-2646./T(I))
      A(224,I) = 2.4E-24 * T(I)**4.02 * EXP(-2754./T(I))
      A(225,I) = 3.E-13 * EXP(-5170./T(I))
      A(226,I) = 2.2E-12 * EXP(385./T(I))
      A(227,I) = 5.5E-12 * EXP(-565./T(I))
      B0 = 2.15E-29 * EXP(-349./T(I))
      BI = 4.95E-11 * EXP(-1051./T(I))
      A(228,I) = TBDY2(B0,BI,DEN(I))
      A(229,I) = 2.E-11
      A(230,I) = 5.58E-11 * EXP(-1443./T(I))
      A(231,I) = 6.94E-12 * EXP(-250./T(I))
      A(232,I) = 3.6E-11
      B0 = 1.26E-18 * EXP(-721./T(I)) / T(I)**3.1
      BI = 3.E-10
      A(233,I) = TBDY2(B0,BI,DEN(I))
   9  CONTINUE
C
      DO 10 I=1,NZ
      A(261,I) = 4.E-11
      B0 = 8.75E-31 * EXP(524./T(I))
      BI = 8.3E-11
      A(262,I) = TBDY2(B0,BI,DEN(I))
      A(263,I) = 3.3E-11
      A(264,I) = 1.4E-11
      A(265,I) = 9.5E-11
      A(266,I) = 2.38E-10 * EXP(-1760./T(I))
      B0 = 8.75E-31 * EXP(524./T(I))
      BI = 8.3E-11
      A(267,I) = TBDY2(B0,BI,DEN(I))
      A(268,I) = 5.9E-11
      A(269,I) = 5.9E-12 * EXP(-350./T(I))
      A270A = 2.5E-11 * EXP(200./T(I))
      A270B = 1.7E-10
      A(270,I) = AMIN1(A270A,A270B)
      A271A = 1.75E-10 * EXP(61./T(I))
      A271B = 5.3E-10
      A(271,I) = AMIN1(A271A,A271B)
      A272A = 5.5E-11 * EXP(173./T(I))
      A272B = 3.55E-10
      A(272,I) = AMIN1(A272A,A272B)
      A(273,I) = A(272,I)
      A(274,I) = 8.E-12
      A(275,I) = 8.3E-11
      B0 = 3.1E-30 * EXP(457./T(I))
      BI = 1.5E-10
      A(276,I) = TBDY2(B0,BI,DEN(I))
      A(277,I) = 4.7E-10 * EXP(-370./T(I))
      B0 = 1.E-28
      BI = 1.E-15
      A(278,I) = TBDY2(B0,BI,DEN(I))
      A(279,I) = 5.3E-11
      B0 = 3.8E-25
      BI = 2.2E-12
      A(280,I) = TBDY2(B0,BI,DEN(I))
      A(281,I) = 3.E-11
      A(282,I) = 3.E-11
      A(283,I) = 1.9E-11 * EXP(-1725./T(I))
      A(284,I) = 3.3E-11
      B0 = 8.E-24/T(I)**2 * EXP(-1225./T(I))
      BI = 9.7E-13 * EXP(-1550./T(I))
      A(285,I) = TBDY2(B0,BI,DEN(I))
      B0 = 8.E-24/T(I)**2 * EXP(-1225./T(I))
      BI = 1.4E-11 * EXP(-1000./T(I))
      A(286,I) = TBDY2(B0,BI,DEN(I))
      A(287,I) = 0.
      A(288,I) = 1.4E-32 * EXP(-3000./T(I))*DEN(I)
      A(289,I) = 0.
      A(290,I) = 6.7E-12
      A(291,I) = 2.4E-13
      A(292,I) = 1.4E-11
      A(293,I) = 1.E-11
      A(294,I) = 1.E-11
      A(295,I) = 1.E-10
      A(296,I) = 5.E-11
      A(297,I) = 5.4E-11
  10  CONTINUE
C
      DO 11 I=1,NZ
      A(298,I) = 8.6E-11
      A(299,I) = 2.8E-11 * EXP(-1540./T(I))
      A(300,I) = 5.8E-13
      A(301,I) = 1.6E-11
      A(302,I) = 2.8E-11 * EXP(-1540./T(I))
      B0 = 8.E-24/T(I)**2 * EXP(-1225./T(I))
      BI = 9.7E-12 * EXP(-1550./T(I))
      A(303,I) = TBDY2(B0,BI,DEN(I))
      A(304,I) = A(303,I)
      A(305,I) = 5.E-11
      A(306,I) = 1.5E-11 * EXP(-550./T(I))
      A(307,I) = 1.77E-10 * EXP(-1469./T(I))
      A(308,I) = 5.05E-11 * EXP(-297./T(I))
      A(309,I) = 1.E-10 * EXP(-250./T(I))
      A(310,I) = 1.4E-11
      A(311,I) = 2.9E-11 * EXP(-1600./T(I))
      A(312,I) = TBDY(5.5E-30,8.3E-13,0.,2.,T(I),DEN(I))
      B0 = 5.8E-31 * EXP(1258./T(I))
      BI = 1.4E-12 * EXP(388./T(I))
      A(313,I) = TBDY2(B0,BI,DEN(I))
      A(314,I) = 5.E-11
      A(315,I) = 3.3E-11 * EXP(-2000./T(I))
      A(316,I) = 3.3E-11 * EXP(-2000./T(I))
      A(317,I) = 1.7E-11 * EXP(-1000./T(I))
      A(318,I) = 5.5E-11
      A(319,I) = 8.3E-12
      A(320,I) = 3.4E-11
      B0 = 1.3E-22
      BI = 1.2E-10
      A(321,I) = TBDY2(B0,BI,DEN(I))
      A(322,I) = 2.4E-11
      A(323,I) = 3.E-12
      B0 = 1.9E-27
      BI = 2.5E-11
      A(324,I) = BI - TBDY2(B0,BI,DEN(I))
      A(325,I) = TBDY(1.0E-28,8.8E-12,0.8,0.,T(I),DEN(I))
      A(326,I) = 5.E-11
      A(327,I) = 3.3E-11 * EXP(-2000./T(I))
      A(328,I) = 3.3E-11 * EXP(-2000./T(I))
      A(329,I) = 1.7E-11 * EXP(-1000./T(I))
      A(330,I) = 1.E-10
      A(331,I) = 1.E-10
      A(332,I) = 3.25E-11/T(I)**0.5
      A(333,I) = 6.E-12
  11  CONTINUE
C
      DO 12 I=1,NZ
      A(334,I) = 2.3E-12
      B0 = 5.5E-23/T(I)**2 * EXP(-1040./T(I))
      BI = 1.5E-13 * EXP(-440./T(I))
      A(335,I) = TBDY2(B0,BI,DEN(I))
      A(336,I) = 3.E-12
      B0 = 1.7E-26
      BI = 1.5E-10
      A(337,I) = TBDY2(B0,BI,DEN(I))
      A(338,I) = A(337,I)
      A(339,I) = A(337,I)
      A(340,I) = 1.5E-11
      B0 = 1.E-28
      BI = 1.E-11
      A(341,I) = TBDY2(B0,BI,DEN(I))
      A(342,I) = 1.5E-11
      A(343,I) = 4.5E-12
      A(344,I) = 4.5E-12
      A(345,I) = 4.1E-12 * EXP(540./T(I))
      A(346,I) = 4.1E-12 * EXP(-38./T(I))
      A(347,I) = A(228,I)
      A(348,I) = 2.5E-12 * EXP(-200./T(I))
      A(349,I) = A(69,I)
      A(350,I) = A(69,I)
      A(351,I) = 1.E-11 * EXP(-1000./T(I))
      A(352,I) = 3.4E-11 * EXP(-1600./T(I))
      B0 = 3.8E-25
      BI = 3.7E-12
      A(353,I) = TBDY2(B0,BI,DEN(I))
      A(354,I) = 1.5E-10
c     A(354,I) = 1.E-99
      A(355,I) = 1.26E-11
      A(356,I) = 1.5E-11
      A(357,I) = 3.8E-17
      A(358,I) = 2.6E-11 * EXP(-5940./T(I))
      A(359,I) = 1.5E-10
c     A(359,I) = 1.E-99
  12  CONTINUE
C
      RETURN
      END
C-PK *****************************
      SUBROUTINE RAINOUT(DZ,ZTROP,JTROP,FCO2,NRAIN)
      PARAMETER(NZ=100, NQ=39, NQT=NQ+3)
      PARAMETER(NR=359, NSP=73, NSP1=NSP+1, NSP2=NSP+2, NMAX=70)
      PARAMETER(NAQ=14)
      DIMENSION HEFF(NQ),IPVT(NAQ),DJAC(NAQ,NAQ),
     2  F(NAQ),FP(NAQ),T(NZ)
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),TD(NZ),G,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
      COMMON/BBLOK/USOL(NQ,NZ),AMIXCO2,AMIXN2
      COMMON/DBLOK/SL(NSP,NZ),TP(NSP),TL(NSP),O3COL,ISPEC(NSP2)
     2  ,XLG(NQT),SR(NQT),ERR(NQ,NZ),TOUT,SO2COL,H2SCOL,S2COL,
     3  S8(NZ),SO4AER(NZ),HCAER(NZ)
      COMMON/GBLOK/RAIN(NZ),FSAT(NZ),RAINGC(NQ,NZ)
      COMMON/NBLOK/LO,LO2,LH2O,LH,LOH,LHO2,LH2O2,LH2,LCO,LHCO,LH2CO,
     2  LCH4,LCH3,LC2H6,LNO,LNO2,LHNO,LH2S,LHS,LS,LSO,LSO2,LH2SO4,
     3  LHSO,LS2,LNH3,LNH2,LN2H3,LN2H4,LCH23,LC2H5,LC2H2,LC2H4,
     4  LC3H8,LC2H3,LC3H6,LC3H2,LCH2CCH2,LCH3C2H,LSO4AER,LS8AER,
     5  LHCAER,LHNO2,LHNO3,LNH,LN,LO3,LO1D,LSO21,LSO23,LHSO3,LSO3,
     6  LS3,LNH2X,LC2,LC2H,LC3H7,LC3H3,LCH,LC,LC3H5,LC2H4OH,
     7  LCH3CHO,LCH3CO,LC2H2OH,LCH2CO,LCH21,LCH3O2,LC2H5CHO,LCH3O,
     8  LS4,LCO2,LN2
      COMMON/WBLOK/SO2G0,H2COG0,FNH3G0,ALPHA,HSO2,HH2CO,CO2AQ,
     2  SO4MM,R4(NZ),R5(NZ),R6(NZ),R7(NZ),R8(NZ),R9(NZ),R12(NZ),
     3  HCO2(NZ),H(NQ,NZ),PH(NZ),ENHAN(NQ,NZ),X(NAQ),XSAVE(NAQ,NZ),
     4  SO4SAV(NZ),NH,HNH3
C
C      THIS SUBROUTINE CALCULATES RAINOUT RATES USING GIORGI AND
C   CHAMEIDES (1985) MODEL.  FIRST, IT CALCULATES THE NORMAL HENRY'S
C   LAW COEFFICIENTS.  THEN IT SOLVES A SYSTEM OF NAQ AQUEOUS PHASE
C   REACTIONS TO FIND EFFECTIVE HENRY'S LAW COEFFICIENTS.  THE
C   REACTIONS ARE:
C
C     1)  (SO2)G + ALPHA*[(SO2)AQ  +  HSO3-  +  SO3=  +  CH2OHSO3-]
C                  =  (SO2)GO
C     2)  (SO2)G   =  (SO2)AQ
C     3)  (H2CO)G  =  CH2(OH)2
C     4)  (CO2)AQ  =  HCO3-  +  H+
C     5)  (SO2)AQ  =  HSO3-  +  H+
C     6)   HCO3-   =  CO3=   +  H+
C     7)   HSO3-   =  SO3=   +  H+
C     8)  CH2(OH)2  +  HSO3-  =  H2O  +  CH2OHSO3-
C     9)   H2O     =  H+  +  OH-
C    10)  (H2CO)G + ALPHA*[CH2(OH)2  +  CH2OHSO3-]  =  (H2CO)GO
C    11)  (NH3)G   =  (NH3)AQ
C    12)  (NH3)AQ  =  NH4+ + OH-
C    13)  (NH3)G + ALPHA*[(NH3)AQ  +  NH4+]  =  (NH3)GO
C   PLUS CHARGE BALANCE:
C    14)  H+ + NH4+  =  OH-  +  HCO3-  +  HSO3-  +  CH2OHSO3-  +
C                       2*[CO3=  +  SO3=]
C
C   ALONG WITH
C         (CO2)G   =  (CO2)AQ
C         (H2SO4)G =  2H+  +  SO4=
C
C     THE VARIABLES IN THE NEWTON STEP ARE:
C     1)  X(1)  =  (SO2)G
C     2)  X(2)  =  (H2CO)G
C     3)  X(3)  =  (SO2)AQ
C     4)  X(4)  =  CH2(OH)2
C     5)  X(5)  =  HCO3-
C     6)  X(6)  =  CO3=
C     7)  X(7)  =  HSO3-
C     8)  X(8)  =  SO3=
C     9)  X(9)  =  CH2OHSO3-
C    10)  X(10) =  OH-
C    11)  X(11) =  (NH3)AQ
C    12)  X(12) =  (NH3)G
C    13)  X(13) =  NH4+
C    14)  X(14) =  H+
C
C   FIRST DEFINE RELEVANT CONSTANTS
      EPS = 1.E-7
      INEWT = 20
      GAM15 = 8.64E+05/2.0
      GAM8 = 7.0E+06/2.0
      AV = 6.02E+23
      WL = 1.0
      R = 1.36E-22
      NH = JTROP
C
C   MODIFY TEMPERATURE PROFILE TO DO AQUEOUS CHEMISTRY
      DO 7 I=1,NH
   7  T(I) = AMAX1(TD(I),273.15)
C
C   CALCULATE NORMAL HENRY'S LAW COEFFICIENTS (PHYSICAL DISSOLUTION
C     ONLY)
      IF (NRAIN.GT.0) GO TO 4
      DO 1 I=1,NH
      H(1,I) = 0.
      H(2,I) = 3.2E-4
      H(3,I) = 0.
      H(4,I) = 0.
      H(5,I) = 1.E5
      H(6,I) = 9.E3
      H(7,I) = 9.7E4 * EXP(6600.*(1./T(I) - 1./298.))
      H(8,I) = 0.
      H(9,I) = 0.
      H(10,I) = 0.
      H(11,I) = 7.E3 * EXP(6425.*(1./T(I) - 1./298.))
      H(12,I) = 0.
      H(13,I) = 0.
      H(14,I) = 0.
      H(15,I) = 1.9E-3
      H(16,I) = 1.2E-2 * EXP(2500.*(1./T(I) - 1./298.))
      H(17,I) = 7.E11
      H(18,I) = 0.14
      H(19,I) = 1.E5
      H(20,I) = 0.
      H(21,I) = 1.9E-3
      H(22,I) = 1.23 * EXP(3120.*(1./T(I) - 1./298.))
      H(23,I) = 7.E11
      H(24,I) = 9.E3
      H(25,I) = 0.
      H(26,I) = 5.8E1 * EXP(4085.*(1./T(I) - 1./298.))
      H(27,I) = 0.
      H(28,I) = 0.
      H(29,I) = 5.8E1 * EXP(4085.*(1./T(I) - 1./298.))
      H(30,I) = 0.
      H(31,I) = 0.
      H(32,I) = 0.
      H(33,I) = 0.
      H(34,I) = 0.
      H(35,I) = 0.
      H(36,I) = 0.
      H(37,I) = 0.
      H(38,I) = 0.
      H(39,I) = 0.
   1  HCO2(I) = 3.11E-2 * EXP(2423.*(1./T(I) - 1./298.))
C
C   CALCULATE EQUILIBRIUM CONSTANTS FOR AQUEOUS PHASE REACTIONS
      DO 3 I=1,NH
      R4(I) = 4.3E-7 * EXP(-913.*(1./T(I) - 1./298.))
      R5(I) = 1.7E-2 * EXP(2090.*(1./T(I) - 1./298.))
      R6(I) = 5.6E-11
      R7(I) = 6.E-8 * EXP(1120.*(1./T(I) - 1./298.))
      R8(I) = 1.E5
      R9(I) = 1.E-14 * EXP(-6716.*(1./T(I) - 1./298.))
      R12(I) = 1.7E-5 * EXP(-4325.*(1./T(I) - 1./298.))
   3  CONTINUE
C
      DO 21 J=1,NQ
      DO 21 I=1,NZ
  21  ENHAN(J,I) = 1.
   4  CONTINUE
C
C   NOW ESTIMATE INITIAL CONCENTRATIONS AT GRID STEP 1 ON THE
C     FIRST CALL
      IF (NRAIN.GT.0) GO TO 5
      ALPHA = WL * 1.E-9 * 6.02E23/DEN(1)
      CO2AQ = FCO2*DEN(1)*HCO2(1)*R*T(1)
      X(14) = SQRT(R4(1)*CO2AQ)
      X(5) = R4(1)*CO2AQ/X(14)
      X(6) = R6(1)*X(5)/X(14)
      X(10) = R9(1)/X(14)
C
      SO2G = USOL(LSO2,1)
      SO2AQ = H(LSO2,1)*SO2G
      HSO3M = R5(1)*SO2AQ/X(14)
      SO3MM = R7(1)*HSO3M/X(14)
      FAC = SO2G/(SO2G + ALPHA*(SO2AQ + HSO3M + SO3MM))
      X(1) = SO2G*FAC
      X(3) = SO2AQ*FAC
      X(7) = HSO3M*FAC
      X(8) = SO3MM*FAC
C
      H2COG = USOL(LH2CO,1)
      CH2OH2 = H(LH2CO,1)*H2COG
      FHSO3M = R8(1)*CH2OH2*X(7)
      FAC = H2COG/(H2COG + ALPHA*(CH2OH2 + FHSO3M))
      X(2) = H2COG*FAC
      X(4) = CH2OH2*FAC
      X(9) = FHSO3M*FAC
C
      FNH3G = USOL(LNH3,1)
      FNH3AQ = H(LNH3,1)*FNH3G
      FNH4P = R12(1)*FNH3AQ/X(10)
      FAC = FNH3G/(FNH3G + ALPHA*(FNH3AQ + FNH4P))
      X(11) = FNH3AQ*FAC
      X(12) = FNH3G*FAC
      X(13) = FNH4P*FAC
   5  CONTINUE
C
C ***** LOOP OVER ALTITUDE *****
      DO 10 I=1,NH
      IF (NRAIN.EQ.0) GO TO 8
      DO 9 K=1,NAQ
   9  X(K) = XSAVE(K,I)
C
   8  CONTINUE
      ALPHA = WL * 1.E-9 * 6.02E23/DEN(I)
      SO4MM = (USOL(LH2SO4,I) + SO4AER(I))/ALPHA
      SO4SAV(I) = SO4MM
      CO2AQ = FCO2*DEN(I)*HCO2(I)*R*T(I)
      SO2G0 = USOL(LSO2,I)
      H2COG0 = USOL(LH2CO,I)
      FNH3G0 = USOL(LNH3,I)
      HH2CO = H(LH2CO,I)
      HSO2 = H(LSO2,I)
      HNH3 = H(LNH3,I)
C
C   START NEWTON ITERATION
      DO 12 IN=1,INEWT
      CALL AQUEOUS(X,F,I)
C
      DO 13 J=1,NAQ
      XS = X(J)
      DX = EPS*X(J)
      X(J) = X(J) + DX
      CALL AQUEOUS(X,FP,I)
C
      DO 14 K=1,NAQ
  14  DJAC(K,J) = (FP(K) - F(K))/DX
  13  X(J) = XS
C
      CALL SGEFA(DJAC,NAQ,NAQ,IPVT,INFO)
      IF (INFO.EQ.0) GO TO 20
      PRINT 100, INFO,I,NRAIN
 100  FORMAT(//1X,*NEWTON SOLVER FAILED IN AQUEOUS*/,5X,*INFO =*,I3,
     2  *GRID STEP =*,I3,2X,*NRAIN =*,I3)
      STOP
  20  CALL SGESL(DJAC,NAQ,NAQ,IPVT,F,0)
C
      LTEST = 0
      DO 22 J=1,NAQ
      X(J) = X(J) - F(J)
      TEST = ABS(F(J)/X(J))
      IF (TEST.GT.1.E-2) LTEST = 1
  22  CONTINUE
      IF (LTEST.EQ.0) GO TO 15
  12  CONTINUE
C
      PRINT 200,I,NRAIN
 200  FORMAT(//1X,*NEWTON SOLVER FAILED TO CONVERGE IN AQUEOUS*/,5X,
     2  *GRID STEP =*,I3,2X,*NRAIN =*,I3)
      STOP
  15  CONTINUE
C
C   CALCULATE EFFECTIVE HENRY'S LAW COEFFICIENTS (INCLUDING AQUEOUS
C      PHASE REACTIONS)
      DO 18 J=1,NQ
  18  HEFF(J) = H(J,I) + 1.E-99
C
      HEFF(LH2CO) = (X(4) + X(9))/X(2)
      HEFF(LSO2) = (X(3) + X(7) + X(8) + X(9))/X(1)
      HEFF(LH2S) = H(LH2S,I)*(1. + 1.1E-7/X(14))
      HEFF(LNH3) = (X(11) + X(13))/X(12)
      PH(I) = - ALOG10(X(14))
C
C   SAVE DENSITIES AND CALCULATE ENHANCEMENTS
      DO 16 J=1,NAQ
  16  XSAVE(J,I) = X(J)
      ENHAN(LH2CO,I) = HEFF(LH2CO)/H(LH2CO,I)
      ENHAN(LSO2,I) = HEFF(LSO2)/H(LSO2,I)
      ENHAN(LH2S,I) = HEFF(LH2S)/H(LH2S,I)
      ENHAN(LNH3,I) = HEFF(LNH3)/H(LNH3,I)
  17  CONTINUE
C
C   NOW BEGIN GIORGI AND CHAMEIDES FORMULATION FOR RAINOUT RATES
      ZKM = Z(I)/1.E5
      TEMP = TD(I)
C
C  FIND APPROPRIATE GAMMA
      IF (ZKM.LE.1.51) THEN
         GAMMA = GAM15
      ELSE IF (ZKM.LT.8.) THEN
         GAMMA = GAM15 + (GAM8-GAM15)*((ZKM-1.5)/6.5)
      ELSE
         GAMMA = GAM8
      END IF
C
C  FIND WH2O
      IF (ZKM.LE.1.) THEN
      Y = 11.35 + 0.1*ZKM
      ELSE
      Y = 11.5444 - 0.085333*ZKM - 9.1111E-03*ZKM*ZKM
      END IF
      WH2O = 10.**Y
C
C  FIND F(Z)
      IF (ZKM.LE.1.51) THEN
      FZ = 0.1
      ELSE
      FZ = 0.16615 - 0.04916*ZKM + 3.37451E-3*ZKM*ZKM
      END IF
C
C  LOOP OVER SPECIES
      DO 10 J=1,NQ
      RKJ = WH2O/55. /(AV*WL*1.E-9 + 1./(HEFF(J)*R*TEMP))
      QJ = 1. - FZ + FZ/(GAMMA*RKJ) * (1.0 - EXP(-RKJ*GAMMA))
  10  RAINGC(J,I) = (1. - EXP(-RKJ*GAMMA))/(GAMMA*QJ)
C ***** END ALTITUDE LOOP *****
C
      NH1 = NH + 1
      DO 11 I=NH1,NZ
      DO 11 J=1,NQ
  11  RAINGC(J,I) = 0.
C
C ***** OLD (FISHMAN AND CRUTZEN) RAINOUT RATE *****
C   (USED FOR SCALING THE VERTICAL DISTRIBUTION OF LIGHTNING)
      DO 2 I=1,NH
      ZKM = Z(I)/1.E5
      RAIN(I) = 2.4E-6*EXP((6.-ZKM)/2.42)
      IF(ZKM.LT.6.) RAIN(I) = 2.4E-6
   2  CONTINUE
      DO 6 I=NH1,NZ
   6  RAIN(I) = 0.
C
      NRAIN = NRAIN + 1                                   
      RETURN                                              
      END                                                 
C-PK **********************************
      SUBROUTINE AQUEOUS(X,F,I)                           
      PARAMETER(NZ=100, NQ=39)                             
      PARAMETER(NAQ=14)                                   
      DIMENSION X(NAQ),F(NAQ)                             
      COMMON/WBLOK/SO2G0,H2COG0,FNH3G0,ALPHA,HSO2,HH2CO,CO2AQ,
     2  SO4MM,R4(NZ),R5(NZ),R6(NZ),R7(NZ),R8(NZ),R9(NZ),R12(NZ),
     3  HCO2(NZ),H(NQ,NZ),PH(NZ),ENHAN(NQ,NZ),XD(NAQ),XSAVE(NAQ,NZ),
     4  SO4SAV(NZ),NH,HNH3
C                                                         
C     THIS SUBROUTINE DOES THE AQUEOUS PHASE CHEMISTRY DESCRIBED IN       
C     SUBROUTINE RAINOUT                                  
C                                                         
      F(1) = X(1) - SO2G0 + ALPHA*(X(3) + X(7) + X(8) + X(9))             
      F(2) = X(3) - HSO2*X(1)                             
      F(3) = X(4) - HH2CO*X(2)                            
      F(4) = X(5)*X(14) - R4(I)*CO2AQ                     
      F(5) = X(7)*X(14) - R5(I)*X(3)                      
      F(6) = X(6)*X(14) - R6(I)*X(5)                      
      F(7) = X(8)*X(14) - R7(I)*X(7)                      
      F(8) = X(9) - R8(I)*X(4)*X(7)                       
      F(9) = X(10)*X(14) - R9(I)                          
      F(10) = X(2) - H2COG0 + ALPHA*(X(4) + X(9))         
      F(11) = X(11) - HNH3*X(12)
      F(12) = X(13)*X(10) - R12(I)*X(11)
      F(13) = X(12) - FNH3G0 + ALPHA*(X(11) + X(13))
      F(14) = X(5) + X(7) + X(9) + X(10) + 2.*(X(6) + X(8) + SO4MM)
     2        - X(13) - X(14)
C                                                         
      RETURN                                              
      END                                                 
      FUNCTION TBDY(A0,AI,CN,CM,T,D)                      
      B0 = A0*(300./T)**CN                                
      BI = AI*(300./T)**CM                                
      Y = ALOG10(B0*D/BI)                                 
      X = 1./(1. + Y**2)                                  
      TBDY = B0*D/(1. + B0*D/BI) * 0.6**X                 
      RETURN                                              
      END                                                 
      FUNCTION TBDY2(B0,BI,D)
      TBDY2 = B0*BI*D/(B0*D + BI)
      RETURN                                              
      END                                                 
      FUNCTION TBDY3(FC,B0,BI)
      X = B0/(1. + B0/BI)
      Y = ALOG10(B0/BI)
      Z = ALOG10(X) + ALOG10(FC)/(1. + Y**2)
      TBDY3 = 10.**Z
      RETURN
      END
C-PK ****************************
      SUBROUTINE PHOTO(ZY,AGL,LTIMES,ISEASON,IZYO2,IO2,INO,N)             
      PARAMETER(NZ=100, NQ=39, NQT=NQ+3, NP=3)                             
      PARAMETER(NR=359, NSP=73, NSP1=NSP+1, NSP2=NSP+2, NMAX=70)       
      DIMENSION SO2(NZ),SO3(NZ),SIGL(NZ),SIGNOL(NZ),CL(NZ),
     2  CNO(NZ),D0(2), FSCALE1(108), WAVC(108), FSCALE2(10) 
      DIMENSION W0P(NP),QEXT(NP)
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),T(NZ),G,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
      COMMON/CBLOK/O3(NZ),H2O(NZ),O2(NZ),CO2(NZ),DZ,ZTROP,NZ1,NPHOT
     2  ,S2(NZ),FSO2(NZ),H2S(NZ),FNH3(NZ),CH4(NZ),C2H6(NZ),JTROP
      COMMON/QBLOK/PLOG(NZ),BIGX(NZ),SRO2(NZ,17),SIG0(NZ,17),A(17,9),
     2  B(17,5),SIGNO(NZ,2),SIGNO0(NZ,2),ANO(9,2),BNO(5,2),LLNO(35),
     3  SO2HZ(35),SH2O(35),SCO2(35),SHO2(35),SN2O(35),SHCL(35),
     4  SCCL2F2(35),SCHCLF2(35),SC2H2(35),SO31(108),SO32(108),
     5  SMCHO(108),SMCOM(108),SH2O2(68),SHNO3(68),SHNO4(68),SPAN(68),
     6  SPPN(68),SMOOH(68),SNO2(68),SH2CO(68),RHCO(68),RH2(68),
     7  SCL2(68),SHOCL(68),SCLNO(68),SCLONO(68),SCLONO2(68),SCCL4(68),
     8  SCLO2(68),SCLO3(68),SCCL3F(68),RNO2(68),KA(17),KB(17),
     9  WAVU(108),WAVL(108),FLUX(108),SIGMA(3,10),SFX(10),SCH4(10),
     1  TO2L(NZ),SC2H4(35),SC2H6(10),NK(17),ALPHA(17,4),BETA(17,4)
     2  ,SSO2(68),SSO21(68),SSO23(68),SS2(68),SSO(68),SH2S(68),
     3  SCH2CO(68),SSO2A(10),SSOA(10),SNH3(35),SN2H4(35),SC2H2A(10),
     4  SC2H4A(10),SC3H8(10),SCH2COA(10),SCH2CCH2(10),SCH3C2H(10),
     5  WAVUV(10)
      COMMON/RBLOK/AR(NR,NZ),ILOSS(2,NSP,NMAX),IPROD(NSP,NMAX),
     2  JCHEM(5,NR),NUML(NSP),NUMP(NSP)
      COMMON/SBLOK/PO2(NZ),PO2D(NZ),PO3(NZ),PO3D(NZ),PH2O(NZ),PH2O2(NZ),  
     2  PCO2(NZ),PCO2D(NZ),PHCO(NZ),PH2(NZ),PHO2(NZ),PCH4A(NZ),
     3  PCH4B(NZ),PCH4C(NZ),PHNO3(NZ),PNO(NZ),PNO2(NZ),PC2H6A(NZ),
     4  PC2H6B(NZ),PC2H6C(NZ),PC2H6D(NZ),PC2H6E(NZ),PSO2(NZ),PSO21(NZ),
     5  PSO23(NZ),PSO(NZ),PC3H8A(NZ),PC3H8B(NZ),PC3H8C(NZ),PC3H8D(NZ),
     6  PH2S(NZ),PS2(NZ),PH2SO4(NZ),PNH3(NZ),PN2H4(NZ),PC2H2A(NZ),
     7  PC2H2B(NZ),PC2H4(NZ),PCH2CCH2(NZ),PCH3C2H(NZ),PMCHO(NZ),
     8  PCH3(NZ),PCH2CO(NZ)
      COMMON/TBLOK/TTOT(NZ),TCO2(NZ),TO2(NZ),TH2O(NZ),TO3(NZ),S(NZ)
     2  ,TSO2(NZ),TS2(NZ),TH2S(NZ),TNH3(NZ),TCH4(NZ),TC2H6(NZ)
      COMMON/O3BLOK/AT(NZ),BT(NZ),CT(NZ),ALM0(NZ)
      COMMON/AERBLK/WFALL(NZ,3),AERSOL(NZ,3),RPAR(NZ,3),HSCALE(NZ),
     2  CONVER(NZ,3),TAUEDD(NZ),TAUSED(NZ,3),TAUC(NZ,3),
     3  DTAUHC(108,NZ),NBEER
      COMMON/TOTALMIE/QEXTT(108,NZ), W0T(108,NZ), GFT(108,NZ)
C
      COMMON/MIE/QEXTC(NZ), W0TC(NZ), GFC(NZ)
      PM = 1.67E-24
      BK = 1.38E-16
      RGAS = 8.3143E7
      WT = O2(1)*32. + CO2(1)*44. + (1.-O2(1)-CO2(1))*28. + 0.4
      RMG = RGAS/(WT*G)
      PI = 3.14159
      ZYR = ZY*PI/180.
      U0 = COS(ZYR)
      AM = 1./U0                                          
      NZ1 = NZ - 1                                        
      RO3 = 0.9                                           
      D0(1) = 1.2E-6                                      
      D0(2) = 2.6E-6                                      
      ALNO = 5.1E7                                        
      QKNO = 1.5E-9                                       
      DIJ = 1.65E9                                        
      NPHOT = NPHOT + 1                                   
      HC = 6.625E-27 * 3.00E10                            
      IF (N.EQ.1) PRINT 119                               
 119  FORMAT(/1X,*ENERGY FLUXES IN W/M/M (NOT DIURNALLY AVERAGED)*,//     
     2  2X,*L*,6X,*WAV*,6X,*TAUR*,6X,*EFLUX*,5X,*GFLUX*,5X,*S(1)*)        
C                                                         
C ***** SET PHOTOLYSIS RATES TO ZERO *****                
      DO 1 I=1,NZ                                         
      PO2(I) = 0.                                         
      PO3(I) = 0.                                         
      PO3D(I) = 0.                                        
      PH2O(I) = 0.                                        
      PH2O2(I) = 0.                                       
      PCO2(I) = 0.                                        
      PCO2D(I) = 0.                                       
      PHCO(I) = 0.                                        
      PH2(I) = 0.                                         
      PO2D(I) = 0.                                        
      PHO2(I) = 0.                                        
      PCH4A(I) = 0.                                        
      PCH4B(I) = 0.                                        
      PCH4C(I) = 0.                                        
      PHNO3(I) = 0.                                       
      PNO(I) = 0.                                         
      PNO2(I) = 0.                                        
      PC2H6A(I) = 0.                                       
      PC2H6B(I) = 0.                                       
      PC2H6C(I) = 0.                                       
      PC2H6D(I) = 0.                                       
      PC2H6E(I) = 0.                                       
      PSO2(I) = 0.                                        
      PSO21(I) = 0.                                       
      PSO23(I) = 0.                                       
      PSO(I) = 0.                                         
      PS2(I) = 0.                                         
      PH2S(I) = 0.                                        
      PH2SO4(I) = 0.                                      
      PNH3(I) = 0.
      PN2H4(I) = 0.
      PC2H2A(I) = 0.                                       
      PC2H2B(I) = 0.                                       
      PC2H4(I) = 0.                                       
      PC3H8A(I) = 0.                                       
      PC3H8B(I) = 0.                                       
      PC3H8C(I) = 0.                                       
      PC3H8D(I) = 0.                                       
      PCH2CCH2(I) = 0.
      PCH3C2H(I) = 0.
      PMCHO(I) = 0.
      PCH3(I) = 0.
      PCH2CO(I) = 0.
   1  CONTINUE                                            
C                                                         
C ***** CALCULATE COLUMN DEPTHS ABOVE EACH ALTITUDE GRID POINT FOR O2       
C       (TOO) AND O3 (TO3).  ADD OTHER SPECIES HERE IF YOU WANT           
C       ADDITIONAL MAJOR ABSORBERS. *****                 
      HA = RMG*T(NZ)                                      
      HAD = HA*DEN(NZ)                                    
      TTOT(NZ) = DEN(NZ)*HA                               
      TO2(NZ) = O2(NZ)*HAD                                
      TO3(NZ) = O3(NZ)*HAD                                
      TCO2(NZ) = CO2(NZ)*HAD                              
      TH2O(NZ) = H2O(NZ)*HAD                              
      TSO2(NZ) = FSO2(NZ) * HAD                           
      TS2(NZ) = S2(NZ) * HAD                              
      TH2S(NZ) = H2S(NZ) * HAD                            
      TNH3(NZ) = FNH3(NZ) * HAD
      TCH4(NZ) = CH4(NZ) * HAD
      TC2H6(NZ) = C2H6(NZ) * HAD
      DO 2 M=1,NZ1                                        
      I = NZ - M                                          
      DZ = Z(I+1) - Z(I)                                  
      HA = RMG*0.5*(T(I) + T(I+1))                        
      EFAC = (1. - EXP(-DZ/HA))*DEN(I)*HA                 
      TTOT(I) = TTOT(I+1) + EFAC                          
      TO2(I) = TO2(I+1) + EFAC*SQRT(O2(I)*O2(I+1))        
      TO3(I) = TO3(I+1) + EFAC*SQRT(O3(I)*O3(I+1))        
      TCO2(I) = TCO2(I+1) + EFAC*SQRT(CO2(I)*CO2(I+1))    
      TH2O(I) = TH2O(I+1) + EFAC*SQRT(H2O(I)*H2O(I+1))    
      TSO2(I) = TSO2(I+1) + EFAC*SQRT(FSO2(I)*FSO2(I+1))  
      TS2(I) = TS2(I+1) + EFAC*SQRT(S2(I)*S2(I+1))        
      TH2S(I) = TH2S(I+1) + EFAC*SQRT(H2S(I)*H2S(I+1))    
      TNH3(I) = TNH3(I+1) + EFAC*SQRT(FNH3(I)*FNH3(I+1))
      TCH4(I) = TCH4(I+1) + EFAC*SQRT(CH4(I)*CH4(I+1))
      TC2H6(I) = TC2H6(I+1) + EFAC*SQRT(C2H6(I)*C2H6(I+1))
   2  CONTINUE                                            
      IF(LTIMES.GT.0) GO TO 3                             
C                                                         
C ***** READ THE PHOTOLYSIS DATAFILE *****                
      READ(3,100)                                         
 100  FORMAT(/)                                           
      DO 41 L=1,108                                       
  41  READ(3,101) WAVL(L),WAVU(L),FLUX(L),SO31(L),SO32(L),SMCHO(L),       
     2  SMCOM(L)
C-AP
      DO L=1,108
      WRITE(24,*) WAVL(L),WAVU(L)
      WAVC(L) = (WAVL(L) + WAVU(L))/2
      ENDDO
C-AP
      DO L=1,108
      FSCALE1(L) = 1.
      ENDDO
C-AP      DO L=1,14
C-AP      FSCALE1(L) = 10.**((2000 - WAVC(L))/2000)
C-AP      ENDDO
C-AP                                          
 101  FORMAT(8X,F6.1,1X,F6.1,2X,E9.2,4(3X,E8.1))          
C
C  SCALE FLUX(L) VALUES FOR SOLAR FLUX AT EARTH (FSCALE=1) OR 
C  MARS (FSCALE=0.43)
      DO 800 L=1,108
  800 FLUX(L)=FLUX(L)*FSCALE*FSCALE1(L)
C
      READ(3,102)                                         
 102  FORMAT(////)                                        
      DO 42 L=1,17                                        
  42  READ(3,103) KA(L),(A(L,K),K=1,9)                    
 103  FORMAT(4X,I1,1X,9(1X,E13.6))                        
C                                                         
      READ(3,102)                                         
      DO 43 L=1,17                                        
  43  READ(3,104) KB(L),(B(L,K),K=1,5)                    
 104  FORMAT(4X,I1,1X,5(1X,E13.6))                        
C                                                         
      READ(3,102)                                         
      DO 44 L=1,35                                        
  44  READ(3,105) SO2HZ(L),SH2O(L),SCO2(L),SHO2(L),SN2O(L),SHCL(L),       
     2  SCCL2F2(L),SCHCLF2(L),SC2H2(L),SC2H4(L),SNH3(L),SN2H4(L)
 105  FORMAT(5X,11(E8.1,1X),E9.2)
C                                                         
      READ(3,106)                                         
 106  FORMAT(//)                                          
      DO 45 L=1,68                                        
  45  READ(3,107) SH2O2(L),SHNO3(L),SCH2CO(L),SPAN(L),SPPN(L),             
     2  SMOOH(L),SNO2(L),SH2CO(L),RHCO(L),RH2(L)          
 107  FORMAT(6X,8E8.1,2(1X,F4.2))                         
C                                                         
      READ(3,106)                                         
      DO 46 L=1,68                                        
  46  READ(3,108) SCL2(L),SHOCL(L),SCLNO(L),SCLONO(L),SCLONO2(L),         
     2  SCCL4(L),SCLO2(L),SCLO3(L),SCCL3F(L)              
 108  FORMAT(6X,9E8.1)                                    
C                                                         
      READ(3,109)                                         
 109  FORMAT(//////)                                      
      DO 58 L=1,17                                        
      READ(3,110) NK(L),(ALPHA(L,K),K=1,4)                
 110  FORMAT(6X,I1,1X,4F13.5)                             
  58  READ(3,111) (BETA(L,K),K=1,4)                       
 111  FORMAT(8X,4E13.4/)                                  
C                                                         
      READ(3,106)                                         
      DO 67 L=1,68                                        
  67  READ(3,113) SSO2(L),SSO21(L),SSO23(L),SSO(L),SH2S(L)
 113  FORMAT(15X,5(E9.3,4X))                              
C                                                         
C   CALCULATE NO2 QUANTUM YIELDS                          
      DO 47 L=47,60                                       
      WAVN = 0.5*(WAVL(L) + WAVU(L))/10.                  
  47  RNO2(L) = 1. - 8.E-4*(WAVN - 275.)                  
C                                                         
C ***** CALCULATE ALLEN AND FREDERICK SCHUMANN-RUNGE BAND COEFS *****     
   3  CONTINUE                                            
      IF (LTIMES.GT.0 .AND. ISEASON.LT.3) GO TO 13        
C                                                         
C   REPEAT THIS SECTION ONLY IF PRESSURE AND TEMPERATURE VARY WITH TIME   
      DO 4 I=1,NZ                                         
   4  PLOG(I) = ALOG10(DEN(I)*BK*T(I)/1.E3)               
      CALL O3PHOT                                         
C                                                         
      DO 5 L=1,17                                         
      DO 6 I=1,NZ                                         
   6  SIGL(I) = 0.                                        
C                                                         
      IF (L.GE.15) GO TO 7                                
      DO 8 I=1,NZ                                         
   8  BIGX(I) = PLOG(I)                                   
      GO TO 9                                             
   7  CONTINUE                                            
      DO 10 I=1,NZ                                        
  10  BIGX(I) = T(I)                                      
C                                                         
   9  KMAX = KA(L)                                        
      DO 11 K=1,KMAX                                      
      DO 11 I=1,NZ                                        
  11  SIGL(I) = SIGL(I) + A(L,K)*BIGX(I)**(K-1)           
      DO 12 I=1,NZ                                        
  12  SIG0(I,L) = 10.**SIGL(I)                            
   5  CONTINUE                                            
C                                                         
C   COEFFICIENTS FOR NITROUS OXIDE (NO)                   
      DO 30 L=1,2                                         
      DO 31 I=1,NZ                                        
  31  SIGNOL(I) = 0.                                      
                                                          
      DO 32 K=1,9                                         
      DO 32 I=1,NZ                                        
  32  SIGNOL(I) = SIGNOL(I) + ANO(K,L)*PLOG(I)**(K-1)     
      DO 33 I=1,NZ                                        
  33  SIGNO0(I,L) = 10.**SIGNOL(I)                        
  30  CONTINUE                                            
  13  CONTINUE                                            
      IF(LTIMES.GT.0 .AND. IZYO2.LT.1) GO TO 14           
C                                                         
C   REPEAT THIS SECTION ONLY IF SOLAR ZENITH ANGLE OR O2 VARIES           
C   WITH TIME                                             
      DO 39 I=1,NZ                                        
  39  TO2L(I) = ALOG10(TO2(I))                            
      DO 15 L=1,17                                        
      DO 16 I=1,NZ                                        
  16  CL(I) = 0.                                          
C                                                         
      KMAX = KB(L)                                        
      DO 17 K=1,KMAX                                      
      DO 17 I=1,NZ                                        
  17  CL(I) = CL(I) + B(L,K)*TO2L(I)**(K-1)               
C                                                         
      DO 18 I=1,NZ                                        
      C = 10.**CL(I)                                      
      SD = SIG0(I,L) * AM**(-C)                           
  18  SRO2(I,L) = AMIN1(SD,2.E-19)                        
  15  CONTINUE                                            
C                                                         
C   COEFFICIENTS FOR NO                                   
      DO 35 L=1,2                                         
      DO 36 I=1,NZ                                        
  36  CNO(I) = 0.                                         
C                                                         
      DO 37 K=1,5                                         
      DO 37 I=1,NZ                                        
  37  CNO(I) = CNO(I) + BNO(K,L)*TO2L(I)**(K-1)           
      DO 38 I=1,NZ                                        
      SD = SIGNO0(I,L) * AM**CNO(I)                       
  38  SIGNO(I,L) = AMIN1(SD,1.E-15)                       
  35  CONTINUE                                            
  14  CONTINUE                                            
C                                                         
C ***** START SHORTWAVE LOOP (1754 - 2532 A) *****        
C
c     print 901
c901  format(/'Shortwave Loop:')
      NBEER = 0
      DO 19 L=1,35
C-AP Evaluating Qext, W0, G at particular wavelength
      DO J=1,NZ
       QEXTC(J) = QEXTT(L,J)
       W0TC(J) = W0T(L,J)
       GFC(J) = GFT(L,J)
      ENDDO
      IF (L.LE.17) GO TO 27                               
      DO 25 I=1,NZ                                        
      SO3(I) = SO31(L)                                    
  25  SO2(I) = SO2HZ(L)                                   
      GO TO 28                                            
C                                                         
  27  CONTINUE                                            
      DO 26 I=1,NZ                                        
      SO3(I) = SO31(L)                                    
  26  SO2(I) = SO2HZ(L) + SRO2(I,L)                       
  28  CONTINUE                                            
      SSO2T = SSO2(L) + SSO21(L)                          
      KN = 1                                              
      ALP = 1.                                            
      IF (IO2.EQ.1 .AND. L.LE.17) KN = NK(L)              
C                                                         
C   LOOP OVER K'S AT LOW O2 LEVELS                        
      DO 19 K=1,KN                                        
      IF (IO2.EQ.0) GO TO 20                              
      IF (L.GT.17) GO TO 66                               
      ALP = ALPHA(L,K)                                    
      DO 65 I=1,NZ                                        
  65  SO2(I) = SO2HZ(L) + BETA(L,K)                       
  66  CONTINUE                                            
C                                                         
C   SKIP MULTIPLE SCATTERING ROUTINE IF THE PURE ABSORPTION OPTICAL       
C   DEPTH AT 20 KM IS MUCH GREATER THAN THE SCATTERING OPTICAL DEPTH      
      WAV = 0.5 * (WAVU(L) + WAVL(L))                     
      SIGR = SIGRAY(WAV) * (1. + 1.5*CO2(1))              
      TAURAY = SIGR * TTOT(20)                            
      TAUABS = SO2(20)*TO2(20) + SO3(20)*TO3(20) + SCO2(L)*TCO2(20)       
     2  + SH2O(L)*TH2O(20) + SSO2T*TSO2(20) + SH2S(L)*TH2S(20)            
     3  + SS2(L)*TS2(20) + SNH3(L)*TNH3(20)
      RATIO = TAUABS/TAURAY                               
C-AP      IF (RATIO.GT.5.) GO TO 20
C-AP  From now we are using TWO STREAM procedure only                           
      IKN = 1
      IF(K.NE.KN) IKN=0
      CALL TWOSTR(SIGR,U0,SO3,SO2,SCO2(L),SH2O(L),SSO2T,SS2(L),
     2  SH2S(L),SNH3(L),WAV,N,IKN)
      GO TO 21
C
  20  CONTINUE
      PRINT *, 'Beers'
      IF (K.EQ.KN) NBEER = NBEER + 1
C   Beer's Law, absorption of particles and gases
C   Particle 1 is sulfate, 2 is S8, 3 is HCAER
      W0P(1) = 1.
      W0P(2) = 0.5
      W0P(3) = 0.5
      TAUAP = 0.
      DO 820 J=1,NP
c Use following statement only when ignoring absorption by HCAER
C      DO 820 J=1,2
      QEXT(J) = 2.
      TAUEP = QEXT(J)*PI*RPAR(NZ,J)*RPAR(NZ,J)*AERSOL(NZ,J)*DZ
      IF (J.EQ.3) DTAUHC(L,NZ) = TAUEP
 820  TAUAP = TAUAP + (1.-W0P(J))*TAUEP
      TAU = SO2(NZ)*TO2(NZ) + SO3(NZ)*TO3(NZ) + SH2O(L)*TH2O(NZ)
     2  + SCO2(L)*TCO2(NZ) + SSO2T*TSO2(NZ) + SS2(L)*TS2(NZ)
     3  + SH2S(L)*TH2S(NZ) + SNH3(L)*TNH3(NZ)
      TAU = TAU + TAUAP
      TAUTOT = TAU
      S(NZ) = EXP(-AM*TAU)
C
      DO 22 J=1,NZ1
      I = NZ - J
      DTAUAP = 0.
      DO 822 IP=1,NP
c Use following statement only when ignoring absorption by HCAER
C      DO 822 IP=1,2
      DTAUEP = QEXT(IP)*PI*RPAR(I,IP)*RPAR(I,IP)*AERSOL(I,IP)*DZ
      IF (IP.EQ.3) DTAUHC(L,I) = DTAUEP
 822  DTAUAP = DTAUAP + (1.-W0P(IP))*DTAUEP
      SIGO2 = 0.5 * (SO2(I) + SO2(I+1))
      DTAU = SIGO2*(TO2(I) - TO2(I+1)) + SO3(I)*(TO3(I) - TO3(I+1))
     2  + SH2O(L)*(TH2O(I) - TH2O(I+1)) + SCO2(L)*(TCO2(I)
     3  - TCO2(I+1)) + SSO2T*(TSO2(I) -TSO2(I+1)) + SS2(L)*(TS2(I) -
     4  TS2(I+1)) + SH2S(L)*(TH2S(I) - TH2S(I+1)) +
     5  SNH3(L)*(TNH3(I) - TNH3(I+1))
      DTAU = DTAU + DTAUAP
      TAUTOT = TAUTOT + DTAU
  22  S(I) = S(I+1) * EXP(-AM*DTAU)
C
C Print out total optical depth at the ground for all wavelengths.
      IF(K.EQ.KN .AND. L.EQ.1) WRITE(22,901)
 901  format('# WAV',5X,'TAU')
      IF(K.EQ.KN) WRITE(22,902) WAV,TAUTOT
 902  FORMAT(1X,F6.1,2X,1PE10.3)
C
  21  FLX = FLUX(L)*AGL*ALP
      DO 23 I=1,NZ
      PO2(I) = PO2(I) + FLX*SO2(I)*S(I)
      PO3D(I) = PO3D(I) + FLX*SO3(I)*RO3*S(I)
      PO3(I) = PO3(I) + FLX*SO3(I)*(1.-RO3)*S(I)
      PH2O(I) = PH2O(I) + FLX*SH2O(L)*S(I)
      PH2O2(I) = PH2O2(I) + FLX*SH2O2(L)*S(I)
      PCO2(I) = PCO2(I) + FLX*SCO2(L)*S(I)
      PHO2(I) = PHO2(I) + FLX*SHO2(L)*S(I)
      PHNO3(I) = PHNO3(I) + FLX*SHNO3(L)*S(I)
      PNO2(I) = PNO2(I) + FLX*SNO2(L)*RNO2(L)*S(I)
      PSO2(I) = PSO2(I) + FLX*SSO2(L)*S(I)
      PSO21(I) = PSO21(I) + FLX*SSO21(L)*S(I)
c     PSO(I) = PSO(I) + FLX*SSO(L)*S(I)
      PH2S(I) = PH2S(I) + FLX*SH2S(L)*S(I)
      PH2SO4(I) = PH2SO4(I) + FLX*SHCL(L)*S(I)
      PS2(I) = PS2(I) + FLX*SS2(L)*S(I)
      PNH3(I) = PNH3(I) + FLX*SNH3(L)*S(I)
      PN2H4(I) = PN2H4(I) + FLX*SN2H4(L)*S(I)
      PC2H2A(I) = PC2H2A(I) + FLX*SC2H2(L)*0.06*S(I)
      PC2H2B(I) = PC2H2B(I) + FLX*SC2H2(L)*0.10*S(I)
      PC2H4(I) = PC2H4(I) + FLX*SC2H4(L)*S(I)
      PMCHO(I) = PMCHO(I) + FLX*SMCHO(L)*S(I)
      PCH2CO(I) = PCH2CO(I) + FLX*SCH2CO(L)*S(I)
      IF (L.EQ.22) PCH3(I) = 1.E-4*S(I)
  23  CONTINUE
C
      IF (N.EQ.0) GO TO 72
      IF(L.LE.17 .AND. K.LT.KN) GO TO 72
      TAUR = SIGR*TTOT(1)
      DELWAV = WAVU(L) - WAVL(L)
      EFLUX = 1.E6*HC*FLX/(WAV*DELWAV*AGL)
      GFLUX = EFLUX*S(1)
      PRINT 120, L,WAV,TAUR,EFLUX,GFLUX,S(1)
 120  FORMAT(1X,I2,2X,1P5E10.3)
  72  CONTINUE
C
C   NO PREDISSOCIATION IN THE D00 (1910 A) AND D10 (1830 A) BANDS
      NOL = LLNO(L)
      IF (NOL.EQ.0) GO TO 19
      IF (INO.EQ.1) GO TO 48
C
C   FREDERICK AND ALLEN METHOD (EFFECTIVE CROSS SECTIONS)
      DO 40 I=1,NZ
  40  PNO(I) = PNO(I) + FLX*SIGNO(I,NOL)*S(I)
      GO TO 19
C
C   OLD (CIESLIK AND NICOLET) METHOD WITH INTENSITIES UPDATED TO
C   FREDERICK AND HUDSON (1979)
  48  CONTINUE
      DO 49 I=1,NZ
      RN2 = DIJ/(ALNO + DIJ + QKNO*DEN(I))                
  49  PNO(I) = PNO(I) + 0.5*D0(NOL)*S(I)*RN2*AGL*ALP      
  19  CONTINUE                                            
C ***** END SHORTWAVE LOOP *****                          
C                                                         
      DO 60 I=1,NZ                                        
  60  SO2(I) = 0.                                         
C                                                         
C ***** START LONGWAVE LOOP (2532 - 8550 A) *****         
c     print 902
c902  format(/'Longwave Loop:')
      DO 57 L=36,108                                      
C-AP Evaluating Qext, W0, G at particular wavelength
      DO J=1,NZ
       QEXTC(J) = QEXTT(L,J)
       W0TC(J) = W0T(L,J)
       GFC(J) = GFT(L,J)
      ENDDO
      IF (L.LT.39 .OR. L.GT.59) GO TO 61                  
C                                                         
      DO 29 I=1,NZ                                        
      TI = AMAX1(T(I),203.)                               
      TI = AMIN1(T(I),273.)                               
      FR = (TI - 203.)/70.                                
  29  SO3(I) = FR*SO32(L) + (1.-FR)*SO31(L)               
      GO TO 64                                            
C                                                         
  61  CONTINUE                                            
      DO 63 I=1,NZ                                        
  63  SO3(I) = SO31(L)                                    
  64  SSO2T = 0.
      SS2L = 0.
      SH2SL = 0.
      IF (L.GT.68) GO TO 165
      SSO2T = SSO21(L) + SSO23(L)                         
      SS2L = SS2(L)
      SH2SL = SH2S(L)
 165  CONTINUE
C                                                         
C   SKIP MULTIPLE SCATTERING ROUTINE IF THE PURE ABSORPTION OPTICAL       
C   DEPTH AT 20 KM IS MUCH GREATER THAN THE SCATTERING OPTICAL DEPTH
C-AP  Identify Qext and W0P for hydrocarbon aerosols for a current frequency
      WAV = 0.5 * (WAVU(L) + WAVL(L))                     
      SIGR = SIGRAY(WAV) * (1. + 1.5*CO2(1))              
      TAURAY = SIGR*TTOT(20)                              
      TAUABS = SO3(20)*TO3(20) + SSO2T*TSO2(20) + SH2SL*TH2S(20)        
     2  + SS2L*TS2(20) 
      RATIO = TAUABS/TAURAY
C-AP Always doing TWOSTR                               
C-AP      IF (RATIO.GT.5.) GO TO 51                           
      IKN = 1
      CALL TWOSTR(SIGR,U0,SO3,SO2,0.,0.,SSO2T,SS2L,SH2SL,
     2  0.,WAV,N,IKN)
      GO TO 52
C
  51  CONTINUE
C   Beer's Law, absorption of particles and gases
C   Particle 1 is sulfate, 2 is S8, 3 is HCAER
      IF(K.EQ.KN) print 903, L
 903  format('Beer''s Law calc: L=',I2)
      W0P(1) = 1.
      W0P(2) = 0.5
      IF (WAV .GT. 3500.) W0P(2) = 1.
      W0P(3) = 0.5
      IF (WAV .GT. 4000.) W0P(3) = 1.
      TAUAP = 0.
       DO 821 J=1,NP
c Use following statement only when ignoring absorption by HCAER
C      DO 821 J=1,2
      QEXT(J) = 2.
      TAUEP = QEXT(J)*PI*RPAR(NZ,J)*RPAR(NZ,J)*AERSOL(NZ,J)*DZ
      IF (J.EQ.3) DTAUHC(L,NZ) = TAUEP
 821  TAUAP = TAUAP + (1.-W0P(J))*TAUEP
      TAU = SO3(NZ)*TO3(NZ) + SSO2T*TSO2(NZ) + SS2L*TS2(NZ)
     2  + SH2SL*TH2S(NZ)
      TAU = TAU + TAUAP
      S(NZ) = EXP(-AM*TAU)
C
      DO 53 J=1,NZ1                                       
      I = NZ - J                                          
      DTAUAP = 0.
      DO 853 IP=1,NP
c Use following statement only when ignoring absorption by HCAER
C      DO 853 IP=1,2
      DTAUEP = QEXT(IP)*PI*RPAR(I,IP)*RPAR(I,IP)*AERSOL(I,IP)*DZ
      IF (IP.EQ.3) DTAUHC(L,I) = DTAUEP
 853  DTAUAP = DTAUAP + (1.-W0P(IP))*DTAUEP
      SIGO3 = 0.5 * (SO3(I) + SO3(I+1))                   
      DTAU = SIGO3*(TO3(I) - TO3(I+1)) + SSO2T*(TSO2(I) - TSO2(I+1))      
     2  + SS2L*(TS2(I) - TS2(I+1)) + SH2SL*(TH2S(I) - TH2S(I+1))      
      DTAU = DTAU + DTAUAP
  53  S(I) = S(I+1) * EXP(-AM*DTAU)                       
C
  52  FLX = FLUX(L)*AGL
      DO 54 I=1,NZ
      BL = BT(I)*(0.1*WAV - ALM0(I))
      RO3 = AT(I)*ATAN(BL) + CT(I)
      RO3 = AMAX1(RO3,0.)
      RO3 = AMIN1(RO3,0.9)
      PO3D(I) = PO3D(I) + FLX*SO3(I)*RO3*S(I)
  54  PO3(I) = PO3(I) + FLX*SO3(I)*(1.-RO3)*S(I)
C
      IF (L.GT.68) GO TO 57
      DO 55 I=1,NZ
      PH2O2(I) = PH2O2(I) + FLX*SH2O2(L)*S(I)
      PHCO(I) = PHCO(I) + FLX*SH2CO(L)*RHCO(L)*S(I)
      PH2(I) = PH2(I) + FLX*SH2CO(L)*RH2(L)*S(I)
      PHNO3(I) = PHNO3(I) + FLX*SHNO3(L)*S(I)
      PNO2(I) = PNO2(I) + FLX*SNO2(L)*RNO2(L)*S(I)
      PSO21(I) = PSO21(I) + FLX*SSO21(L)*S(I)
      PSO23(I) = PSO23(I) + FLX*SSO23(L)*S(I)
      PH2S(I) = PH2S(I) + FLX*SH2S(L)*S(I)
      PS2(I) = PS2(I) + FLX*SS2(L)*S(I)
      PMCHO(I) = PMCHO(I) + FLX*SMCHO(L)*S(I)
      PCH2CO(I) = PCH2CO(I) + FLX*SCH2CO(L)*S(I)
  55  CONTINUE
C
      IF (N.EQ.0) GO TO 57
      TAUR = SIGR*TTOT(1)
      DELWAV = WAVU(L) - WAVL(L)
      EFLUX = 1.E6*HC*FLX/(WAV*DELWAV*AGL)
      GFLUX = EFLUX*S(1)
      PRINT 120, L,WAV,TAUR,EFLUX,GFLUX,S(1)
  57  CONTINUE
C
C ***** FAR UV (1216 - 1750 A) *****
      IF (LTIMES.GT.0) GO TO 62
      READ(11,100)
      READ(11,300) (X,(SIGMA(J,L),J=1,3),SSO2A(L),SSOA(L),SCH4(L),
     2     SC2H6(L),SC2H2A(L),L=1,10)
 300  FORMAT(9E8.1)
      READ(11,106)
      READ(11,400) (SC2H4A(L),SC3H8(L),SCH2COA(L),SCH2CCH2(L),
     2     SCH3C2H(L),L=1,10)
 400  FORMAT(5E8.1)
C  CALCULATE CH4 OPTICAL DEPTH AT LYMAN ALPHA FOR UPPER LAYER
      TAUCH4 = TCH4(NZ)*SCH4(10)
      PRINT 121, TAUCH4
 121  FORMAT(/*CH4 OPTICAL DEPTH OF UPPER LAYER (Lya):*,1PE10.3/)
C  SCALE SFX(L) VALUES FOR SOLAR FLUX AT EARTH (FSCALE=1) OR
C  MARS (FSCALE=0.43)
      DO 900 L=1,10
C-AP      FSCALE2(L) = 10.**((2000 - WAVUV(L))/2000)
      FSCALE2(L) = 1.
  900 SFX(L)=SFX(L)*FSCALE*FSCALE2(L)
  62  CONTINUE
      DO 50 L=1,10
      DO 50 I=1,NZ
      QQ = SFX(L)*50.*EXP(-(SIGMA(1,L)*TO2(I) + SIGMA(2,L)*TCO2(I)
     2  + SIGMA(3,L)*TH2O(I) + SSO2A(L)*TSO2(I) + SCH4(L)*TCH4(I)
     3  + SC2H6(L)*TC2H6(I))*AM)
      PO2D(I) = PO2D(I) + QQ*SIGMA(1,L)*AGL
      PCO2D(I) = PCO2D(I) + QQ*SIGMA(2,L)*AGL
      PH2O(I) = PH2O(I) + QQ*SIGMA(3,L)*AGL
      PSO2(I) = PSO2(I) + QQ*SSO2A(L)*AGL
c     PSO(I) = PSO(I) + QQ*SSOA(L)*AGL
      PC2H2A(I) = PC2H2A(I) + QQ*SC2H2A(L)*0.3*AGL
      PC2H2B(I) = PC2H2B(I) + QQ*SC2H2A(L)*0.1*AGL
      PC2H4(I) = PC2H4(I) + QQ*SC2H4A(L)*AGL
      PCH2CO(I) = PCH2CO(I) + QQ*SCH2COA(L)*AGL
      PCH2CCH2(I) = PCH2CCH2(I) + QQ*SCH2CCH2(L)*AGL
      PCH3C2H(I) = PCH3C2H(I) + QQ*SCH3C2H(L)*AGL
      IF(L.EQ.10)THEN
       PCH4A(I) = PCH4A(I) + QQ*SCH4(L)*0.24*AGL
       PCH4B(I) = PCH4B(I) + QQ*SCH4(L)*0.25*AGL
       PCH4C(I) = PCH4C(I) + QQ*SCH4(L)*0.51*AGL
       PC2H6A(I) = PC2H6A(I) + QQ*SC2H6(L)*0.25*AGL
       PC2H6B(I) = PC2H6B(I) + QQ*SC2H6(L)*0.25*AGL
       PC2H6C(I) = PC2H6C(I) + QQ*SC2H6(L)*0.30*AGL
       PC2H6D(I) = PC2H6D(I) + QQ*SC2H6(L)*0.13*AGL
       PC2H6E(I) = PC2H6E(I) + QQ*SC2H6(L)*0.08*AGL
       PC3H8A(I) = PC3H8A(I) + QQ*SC3H8(L)*0.33*AGL
       PC3H8B(I) = PC3H8B(I) + QQ*SC3H8(L)*0.09*AGL
       PC3H8C(I) = PC3H8C(I) + QQ*SC3H8(L)*0.39*AGL
       PC3H8D(I) = PC3H8D(I) + QQ*SC3H8(L)*0.20*AGL
      ELSE
       PCH4A(I) = PCH4A(I) + QQ*SCH4(L)*AGL                  
       PC2H6A(I) = PC2H6A(I) + QQ*SC2H6(L)*0.02*AGL               
       PC2H6B(I) = PC2H6B(I) + QQ*SC2H6(L)*0.27*AGL               
       PC2H6C(I) = PC2H6C(I) + QQ*SC2H6(L)*0.14*AGL               
       PC2H6D(I) = PC2H6D(I) + QQ*SC2H6(L)*0.56*AGL               
       PC2H6E(I) = PC2H6E(I) + QQ*SC2H6(L)*0.01*AGL               
       PC3H8A(I) = PC3H8A(I) + QQ*SC3H8(L)*0.94*AGL
       PC3H8D(I) = PC3H8D(I) + QQ*SC3H8(L)*0.06*AGL
      ENDIF
  50  CONTINUE                                            
C                                                         
C ***** FILL UP RATE MATRIX *****                         
      DO 56 I=1,NZ                                        
      AR(23,I) = PO2D(I)                                  
      AR(24,I) = PO2(I)                                   
      AR(25,I) = PH2O(I)                                  
      AR(26,I) = PO3D(I)                                  
      AR(27,I) = PO3(I)                                   
      AR(28,I) = PH2O2(I)                                 
      AR(29,I) = PCO2(I)                                  
      AR(38,I) = PH2(I)                                   
      AR(39,I) = PHCO(I)                                  
      AR(42,I) = PCO2D(I)                                 
      AR(50,I) = PHO2(I)                                  
      AR(51,I) = PCH4A(I)                                  
      AR(52,I) = 0.
      AR(53,I) = PC2H6A(I)                           
      AR(54,I) = 1.7E-3                                   
      AR(55,I) = PHNO3(I)                                 
      AR(56,I) = PNO(I)                                   
      AR(57,I) = PNO2(I)                                  
      AR(72,I) = PCH3(I)
      AR(111,I) = 0.
      AR(112,I) = PSO2(I)                                 
      AR(113,I) = PH2S(I)                                 
      AR(144,I) = PSO21(I)                                
      AR(145,I) = PSO23(I)                                
      AR(146,I) = PS2(I)                                  
      AR(147,I) = 0.                                      
      AR(148,I) = PH2SO4(I)                               
      AR(149,I) = 0.                                      
      AR(171,I) = PHO2(I)                                 
      AR(183,I) = PS2(I)                                  
      AR(184,I) = PS2(I)                                  
      AR(185,I) = PNH3(I)
      AR(195,I) = PN2H4(I)
      AR(200,I) = PNH3(I)
      AR(201,I) = PNH3(I)
      AR(210,I) = PC2H2A(I)
      AR(211,I) = PC2H2B(I)
      AR(212,I) = PC2H4(I)*0.51
  56  CONTINUE                                            
C
      DO 610 I=1,NZ                                        
      AR(234,I) = PC3H8A(I)
      AR(235,I) = PC3H8B(I)
      AR(236,I) = PC3H8C(I)
      AR(237,I) = PC3H8D(I)
      AR(238,I) = PC2H6B(I)
      AR(239,I) = PC2H6C(I)
      AR(240,I) = PC2H6D(I)
      AR(241,I) = PC2H6E(I)
      AR(242,I) = PC2H4(I)*0.49
      AR(243,I) = PC2H4(I)*0.34
      AR(244,I) = PCH4B(I)
      AR(245,I) = PCH4C(I)
      AR(246,I) = PC2H4(I)
      AR(247,I) = PCH2CO(I)
      AR(248,I) = PMCHO(I)*0.50
      AR(249,I) = PMCHO(I)*0.50
      AR(250,I) = PMCHO(I)
      AR(251,I) = PC2H4(I)
      AR(252,I) = PCH3C2H(I)*0.40
      AR(253,I) = PCH3C2H(I)*0.15
      AR(254,I) = PCH3C2H(I)*0.02
      AR(255,I) = PCH2CCH2(I)*0.40
      AR(256,I) = PCH2CCH2(I)*0.15
      AR(257,I) = PCH2CCH2(I)*0.06
      AR(258,I) = PC2H4(I)*0.57
      AR(259,I) = PC2H4(I)*0.02
      AR(260,I) = PC2H4(I)*0.05
  610 CONTINUE                                            
C                                                         
      LTIMES = LTIMES + 1                                 
      RETURN                                              
      END                                                 
C-PK *******************************
      SUBROUTINE O3PHOT                                   
      PARAMETER(NZ=100, NQ=39, NQT=NQ+3)                                    
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),T(NZ),G,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
      COMMON/O3BLOK/AT(NZ),BT(NZ),CT(NZ),ALM0(NZ)         
C                                                         
C   THIS SUBROUTINE CALCULATES TEMPERATURE COEFFICIENTS USED TO FIND      
C   THE O(1D) QUANTUM YIELD IN O3 PHOTOLYSIS.  (SEE JPL, 1983.)           
C                                                         
      DO 1 I=1,NZ                                         
      TAU = T(I) - 230.                                   
      TAU2 = TAU * TAU                                    
      TAU3 = TAU2 * TAU                                   
      AT(I) =   0.332 + 2.565E-4*TAU + 1.152E-5*TAU2 + 2.313E-8*TAU3      
      BT(I) = - 0.575 + 5.590E-3*TAU - 1.439E-5*TAU2 - 3.270E-8*TAU3      
      CT(I) =   0.466 + 8.883E-4*TAU - 3.546E-5*TAU2 + 3.519E-7*TAU3      
   1  ALM0(I) = 308.2 + 4.4871E-2*TAU + 6.938E-5*TAU2 - 2.5452E-6*TAU3    
C                                                         
      RETURN                                              
      END                                                 
C-PK ********************************
      SUBROUTINE DENSTY(FO2,FCO2,FCO,FH2O,P0)                      
      PARAMETER(NZ=100, NQ=39, NQT=NQ+3)                                    
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),T(NZ),G,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
C                                                         
C   THIS SUBROUTINE CALCULATES ATMOSPHERIC NUMBER DENSITIES, ASSUM-       
C   ING HYDROSTATIC EQUILIBRIUM                           
      G0 = G
      RGAS = 8.3143E7                                     
      BK = 1.38054E-16                                    
      R0 = 6.371E8                                        
      WT = FCO2*44. + FH2O*18. + (1. - FCO2 - FH2O)*28.
      ROVERM = RGAS/WT                                    
      PG = 1.E6                                        
      P0 = PG                                             
C     P0 = PG GIVES YOU A ONE BAR ATMOSPHERE              
      DZ = Z(2) - Z(1)                                    
      T0 = T(1) + (T(1)-T(2))/2.                          
      HA = ROVERM*0.5*(T0 + T(1))/G0                      
      P1 = P0 * EXP(-0.5*DZ/HA)                           
      DEN(1) = P1/(BK*T(1))                               
C                                                         
C ***** FIND DENSITY FROM HYDROSTATIC EQUILIBRIUM *****   
      DO 1 I=2,NZ                                         
      DZ = Z(I) - Z(I-1)                                  
      R = R0 + Z(I)                                       
      GZ = G0 * (R0/R)*(R0/R)                              
      TAV = 0.5*(T(I) + T(I-1))                           
      HA = ROVERM*TAV/GZ
   1  DEN(I) = DEN(I-1)*EXP(-DZ/HA)*T(I-1)/T(I)           
C                                                         
      RETURN                                              
      END                                                 
C-PK ********************************
      SUBROUTINE DIFCO(FO2,FCO2)
      PARAMETER(NZ=100, NQ=39, NQT=NQ+3)
      DIMENSION WGT(NQT),HISCALE(NQT),BKMIG(NQT),HD(NQT,NZ)
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),T(NZ),G,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
      COMMON/NBLOK/LO,LO2,LH2O,LH,LOH,LHO2,LH2O2,LH2,LCO,LHCO,LH2CO,
     2  LCH4,LCH3,LC2H6,LNO,LNO2,LHNO,LH2S,LHS,LS,LSO,LSO2,LH2SO4,
     3  LHSO,LS2,LNH3,LNH2,LN2H3,LN2H4,LCH23,LC2H5,LC2H2,LC2H4,
     4  LC3H8,LC2H3,LC3H6,LC3H2,LCH2CCH2,LCH3C2H,LSO4AER,LS8AER,
     5  LHCAER,LHNO2,LHNO3,LNH,LN,LO3,LO1D,LSO21,LSO23,LHSO3,LSO3,
     6  LS3,LNH2X,LC2,LC2H,LC3H7,LC3H3,LCH,LC,LC3H5,LC2H4OH,
     7  LCH3CHO,LCH3CO,LC2H2OH,LCH2CO,LCH21,LCH3O2,LC2H5CHO,LCH3O,
     8  LS4,LCO2,LN2
      COMMON/AERBLK/WFALL(NZ,3),AERSOL(NZ,3),RPAR(NZ,3),HSCALE(NZ),
     2  CONVER(NZ,3),TAUEDD(NZ),TAUSED(NZ,3),TAUC(NZ,3),
     3  DTAUHC(108,NZ),NBEER
      DATA WGT/16.,32.,18.,1.,17.,33.,34.,2.,28.,29.,30.,16.,15.,
     2  30.,30.,46.,31.,34.,33.,32.,48.,64.,98.,49.,64.,17.,
     3  16.,31.,32.,14.,29.,26.,28.,44.,27.,42.,38.,40.,40.,3*1.E9/
C
      DZ = DELZ
      NZ1 = NZ - 1
      WT = FO2*32. + FCO2*44. + (1.-FO2-FCO2)*28.
      BKMG = 1.38E-16/(1.67E-24*WT*G)
C
C   COMPUTE DIFFUSION LIFETIME AT EACH HEIGHT (H*H/K)
c     print 900
c900  format(/'Atmospheric scale height')
      DO 1 J=1,NZ
       H = BKMG * T(J)
       HSCALE(J) = H
c      print 901, J,HSCALE(J)
c901   format('J=',I2,' HSCALE(J)=',1PE10.3)
   1   TAUEDD(J) = H*H/EDD(J)
C
C   CALCULATE MOLECULAR DIFFUSION COEFFICIENTS
      DO 2 I=1,NQT
       DO 3 J=1,NZ
   3    DI(I,J) = 1.52E18*(1./WGT(I) + 1./WT)**0.5 * (T(J)**0.5/DEN(J))
   2  CONTINUE
C
c     print 900
c900  format(/'CH4 Molecular diffusion coeff.')
c     DO 100 J=1,NZ
c100    print 901, DI(LCH4,J),J
c901  format(1PE10.3,I4)
C
C ***** HD(I,J) = Hi*N at grid step J *****
      DO 4 I=1,NQT
       DO 5 J=1,NZ
        BKMIG(I) = 1.38E-16/(1.67E-24*WGT(I)*G)
        HISCALE(I) = BKMIG(I)*T(J)
        HI(I,J) = DI(I,J)*(1./HISCALE(I) - 1./HSCALE(J))
c       print 802, I,J,HI(I,J)
c 802   format(/'HI(',I2,',',I2,')=',1PE10.3)
   5    HD(I,J) = HI(I,J)*DEN(J)
   4  CONTINUE
C
C   SET DIFFUSION COEFFICIENT OF SO4AER, S8AER AND HCAER TO ZERO
      DO 10 J=1,NZ
       HI(LSO4AER,J) = 0.
       DI(LSO4AER,J) = 0.
       HD(LSO4AER,J) = 0.
       HI(LS8AER,J) = 0.
       DI(LS8AER,J) = 0.
       HD(LS8AER,J) = 0.
       HI(LHCAER,J) = 0.
       DI(LHCAER,J) = 0.
       HD(LHCAER,J) = 0.
  10  CONTINUE
C ***** DK(I,J) = (K+D)*N AT GRID STEP J+1/2 *****
      DO 6 J=1,NZ1
       EDDAV = SQRT(EDD(J)*EDD(J+1))
       DENAV = SQRT(DEN(J)*DEN(J+1))
       DO 7 I=1,NQT
        DK(I,J) = (EDDAV+DI(I,J))*DENAV
c       print 801, I,J,DK(I,J)
c 801   format(/'DK(',I2,',',I2,')=',1PE10.3)
   7  CONTINUE
   6  CONTINUE
C
C  STORE CONSTANT JACOBIAN COEFFICIENTS
C
      DO 11 I=1,NQT
      DHU(I,1) = HD(I,2)/DEN(1)/(2.*DZ)
      DHL(I,NZ) = HD(I,NZ1)/DEN(NZ)/(2.*DZ)
      DO 11 J=2,NZ1
      DHU(I,J) = HD(I,J+1)/DEN(J)/(2.*DZ)
  11  DHL(I,J) = HD(I,J-1)/DEN(J)/(2.*DZ)
C
C
      DZ2 = DZ*DZ
      DO 8 I=1,NQT
       DU(I,1) = DK(I,1)/DEN(1)/DZ2
       DL(I,NZ) = DK(I,NZ1)/DEN(NZ)/DZ2
      DO 8 J=2,NZ1
       DU(I,J) = DK(I,J)/DEN(J)/DZ2
       DL(I,J) = DK(I,J-1)/DEN(J)/DZ2
   8   DD(I,J) = DU(I,J) + DL(I,J)
C
      RETURN
      END
C-PK *****************************
      SUBROUTINE SEDMNT(FSULF,N)
      PARAMETER(NZ=100, NQ=39, NQT=NQ+3)
      DIMENSION FSULF(NZ),TAUTRN(NZ),RHOP(NZ)
      DIMENSION TAURAN(NZ,3),ALAM(NZ),TAUCPK(NZ,3),ETA(NZ)
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),T(NZ),G,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
      COMMON/GBLOK/RAIN(NZ),FSAT(NZ),RAINGC(NQ,NZ)
      COMMON/NBLOK/LO,LO2,LH2O,LH,LOH,LHO2,LH2O2,LH2,LCO,LHCO,LH2CO,
     2  LCH4,LCH3,LC2H6,LNO,LNO2,LHNO,LH2S,LHS,LS,LSO,LSO2,LH2SO4,
     3  LHSO,LS2,LNH3,LNH2,LN2H3,LN2H4,LCH23,LC2H5,LC2H2,LC2H4,
     4  LC3H8,LC2H3,LC3H6,LC3H2,LCH2CCH2,LCH3C2H,LSO4AER,LS8AER,
     5  LHCAER,LHNO2,LHNO3,LNH,LN,LO3,LO1D,LSO21,LSO23,LHSO3,LSO3,
     6  LS3,LNH2X,LC2,LC2H,LC3H7,LC3H3,LCH,LC,LC3H5,LC2H4OH,
     7  LCH3CHO,LCH3CO,LC2H2OH,LCH2CO,LCH21,LCH3O2,LC2H5CHO,LCH3O,
     8  LS4,LCO2,LN2
      COMMON/AERBLK/WFALL(NZ,3),AERSOL(NZ,3),RPAR(NZ,3),HSCALE(NZ),       
     2  CONVER(NZ,3),TAUEDD(NZ),TAUSED(NZ,3),TAUC(NZ,3),
     3  DTAUHC(108,NZ),NBEER
      DIMENSION CUNING(NZ,3),amass(NZ,3),THERMSP(NZ,3),
     2  TAURELAXC(NZ,3),TAURELAX(NZ,3),AFPL(NZ,3),delta(NZ,3),
     3  BETAF(NZ,3),TAUCPKF(NZ,3)   
C
C   THIS SUBROUTINE CALCULATES FALL VELOCITIES AND ESTIMATES PARTICLE
C   SIZE BASED ON THEIR COAGULATION LIFETIMES
C
C   CONSTANTS FOR STOKES-CUNNINGHAM EQUATION (KASTEN, 1968)
C-AP      A = 1.249
C-AP      B = 0.42
C-AP      C = 0.87
C   CONSTANTS from Pruppacher and Klett page 450
          A = 1.257
          B = 0.4
          C = 1.1
C-AP
C-AP       A = 0.866
C-AP       B = 0.29
C-AP       C = 1.25
C-AP
      BK = 1.38*1.E-16
      PI = 3.14159
      NZ1 = NZ - 1
C
      DO J=1,NZ
      ALAM(J) = 1.63E14/DEN(J)
      ETA(J)=ABS((1.718 + 0.0049*(T(J)-273.) - 1.2
     & *(1.E-5)*(T(J)-273.)*(T(J)-273.))*1.E-4)
      ENDDO
      DO 10 K=1,3
C   (1 = SULFATE, 2 = S8, 3 = HYDROCARBON)
C
C-AP ESTIMATION OF THE AEROSOL FREE PATH LENGTH
      DO J = 1,NZ
       ALPH = A + B*EXP(-C*RPAR(J,K)/ALAM(J))
       CUNING(J,K) = 1 + ALPH*ALAM(J)/RPAR(J,K)
C-AP Here we assume that the density of aerosol is 1 g/cm3
C-AP Notation is similar Fusch 1964
       amass(J,K) = (4./3.)*PI*RPAR(J,K)**3
       THERMSP(J,K) = SQRT((8*BK*T(J))/(pi*amass(J,K))) 
       TAURELAXC(J,K)=2*RPAR(J,K)*RPAR(J,K)/(9*ETA(J))
       TAURELAX(J,K) = TAURELAXC(J,K)*CUNING(J,K) 
       AFPL(J,K) = THERMSP(J,K)*TAURELAX(J,K)
       delta(J,K) = (((2*RPAR(J,K)+AFPL(J,K))**3 - (4*
     & RPAR(J,K)*RPAR(J,K)+AFPL(J,K)*AFPL(J,K))**1.5)/
     & (6*RPAR(J,K)*AFPL(J,K)) - 2*RPAR(J,K))*SQRT(2.) 
      ENDDO
C-AP Calculation of the correction to the coagulation kernel 
      DO J = 1,NZ
       BETAF(J,K) = 1/(RPAR(J,K)/(RPAR(J,K)+delta(J,K)/2)
     & +PI*AFPL(J,K)/(2*SQRT(2.)*RPAR(J,K)))
      ENDDO
C-AP ******************************************************  
C ESTIMATE COAGULATION AND SEDIMENTATION LIFETIMES (TOON AND FARLOW, 1981)
      DO 1 J=1,NZ
      TAUC(J,K) = 1.E6/(AERSOL(J,K)*SQRT(RPAR(J,K)))
      TAUCPK(J,K) = 3*ETA(J)/(4*AERSOL(J,K)*BK*
     & T(J)*CUNING(J,K))
      TAUCPKF(J,K) = TAUCPK(J,K)/BETAF(J,K)
      TAUC(J,K) = TAUCPKF(J,K)
      TAURAN(J,K) = 1./(RAINGC(LH2SO4,J) + 1.E-20)
   1  TAUSED(J,K) = HSCALE(J)/WFALL(J,K)
C-AP
C-AP      IF (K.EQ.3) THEN
C-AP      PRINT*, 'Z     TAUC      CUNING       AEROSoL       BETAF'
C-AP      DO J=1,NZ
C-AP      PRINT*, Z(J),TAUC(J,K),CUNING(J,K),AERSOL(J,K),BETAF(J,K)
C-AP      ENDDO
C-AP      ENDIF
C
C   FIND MINIMUM OF DIFFUSION AND SEDIMENTATION LIFETIMES, THEN SCALE
C   PARTICLE SIZES
      DO 2 J=1,NZ
      TAUTRN(J) = AMIN1(TAUSED(J,K),TAUEDD(J))
      TAUTRN(J) = AMIN1(TAUTRN(J),TAURAN(J,K))
      RPAR(J,K) = RPAR(J,K) * (TAUTRN(J)/TAUC(J,K))**0.25
      IF(K.EQ.3) THEN
        RPAR(J,K) = AMAX1(RPAR(J,K),1.3E-7)
      ELSE
        RPAR(J,K) = AMAX1(RPAR(J,K),1.E-5)
      ENDIF
   2  CONTINUE
C
C Write TAUTRN on last iteration
C-PK ****Suspend for now since file is large****
C-PK      IF ( K.EQ.3) THEN
C-PK      WRITE(18,900)
C-AP 900  FORMAT(/'# HC(aerosol)',/'#  Z',3X,'TAUC',6X,'TAUCPK',
C-AP     2   4X,'TAUSED',4X,'TAUTRN',4X,'TAUEDD')
C-PK 900  FORMAT(/'# HC(aerosol)',/'#  Z',3X,'TAUC',6X,'TAURAN',
C-PK     2   4X,'TAUSED',4X,'TAUTRN',4X,'TAUEDD')
C-PK      DO 22 J=1,NZ
C-AP      WRITE(18,901) Z(J),TAUC(J,3),TAUCPK(J,3),TAUSED(J,3),
C-AP     2 TAUTRN(J), TAUEDD(J)
C-PK      WRITE(18,901) Z(J),TAUC(J,3),TAURAN(J,3),TAUSED(J,3),
C-PK     2 TAUTRN(J),
C-PK     3  TAUEDD(J)
C-PK 901  FORMAT(1P6E10.3)
C-PK  22  CONTINUE
C-PK
C
C   DON'T ALLOW PARTICLES TO DECREASE IN SIZE AT LOW ALTITUDES
      DO 3 I=1,NZ1
      J = NZ - I
   3  RPAR(J,K) = AMAX1(RPAR(J,K),RPAR(J+1,K))
C
C   COMPUTE PARTICLE-TO-GAS CONVERSION FACTORS AND DENSITIES
      IF (K.NE.1) GO TO 5
      DO 4 J=1,NZ
      R = RPAR(J,K)
      CONVER(J,K) = 4.6E7*FSULF(J) * (R/1.E-5)**3
   4  RHOP(J) = 1. + 0.8*FSULF(J)
      GO TO 7
C
   5  CONTINUE
      IF (K.NE.2) GO TO 9
      DO 6 J=1,NZ
      R = RPAR(J,K)
      CONVER(J,K) = 2.03E7 * (R/1.E-5)**3
   6  RHOP(J) = 2.07
      GO TO 7
C
   9  CONTINUE
      DO 11 J=1,NZ
      R = RPAR(J,K)
      CONVER(J,K) = 7.06E7 * (R/1.E-5)**3
  11  RHOP(J) = 1.4
   7  CONTINUE
C
C     NOW COMPUTE FALL VELOCITIES
      DO 8 J=1,NZ
       R = RPAR(J,K) 
C-AP      ETA = 1.77E-4 * SQRT(T(J)/288.)
C-AP  From Prupacher & Klett
      F1 = 2./9. * RHOP(J)*R*R*G/ETA(J)
      ALPH = A + B*EXP(-C*R/ALAM(J))
   8  WFALL(J,K) = F1*(1. + ALAM(J)*ALPH/R)
  10  CONTINUE
C
      RETURN
      END
C-PK ********************************
      SUBROUTINE SATRAT(JTROP,H2O)
      PARAMETER(NZ=100, NQ=39, NQT=NQ+3)
      DIMENSION HL(NZ),H2O(NZ),A(NZ)
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),T(NZ),G,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
      COMMON/SATBLK/P(NZ),H2OSAT(NZ),CONDEN(NZ),RELH(NZ)
C
C   THIS SUBROUTINE CALCULATES THE SATURATION VAPOR PRESSURE OF WATER 
C   FROM MAGNUS' EQUATION (SEE RUNAWAY GREENHOUSE PAPER IN ICARUS -
C   APPENDIX A).  IT THEN FIXES TROPOSPHERIC H2O USING A MANABE/
C   WETHERALD RELATIVE HUMIDITY DISTRIBUTION.
C
      T0 = 273.15
      P0 = 6.103E-3
      AMV = 18.
      VAPL = 597.3
      SUBL = 677.
      R = 1.9872
      A0 = 0.553
      BK = 1.38E-16
      PS = 1.E-6 * DEN(1)*BK*T(1)
C
      DO 1 J=1,NZ
      HL(J) = SUBL
      A(J) = 0.
      IF (T(J).LT.T0) GO TO 1
      HL(J) = VAPL + A0*T0
      A(J) = A0
   1  CONTINUE
C
C   FIND SATURATION VAPOR PRESSURE
      DO 2 J=1,NZ
      P1 = P0 * (T0/T(J))**(AMV*A(J)/R)
      P2 = EXP(AMV*HL(J)/R * (1./T0 - 1./T(J)))
      PV = P1 * P2
      P(J) = 1.E-6 * DEN(J)*BK*T(J)
   2  H2OSAT(J) = PV/P(J)
C
C   CALCULATE TROPOSPHERIC H2O CONCENTRATIONS
      DO 3 J=1,JTROP
      REL = 0.77 * (P(J)/PS - 0.02)/0.98
      RELH(J) = REL
   3  H2O(J) = REL * H2OSAT(J)
C
      RETURN
      END
C-PK ******************************
      SUBROUTINE AERTAB
      PARAMETER(NZ=100, NQ=39, NQT=NQ+3)
      PARAMETER(NT=51, NF=34)
      DIMENSION TTAB(NT),PH2O(NT,NF),PH2SO4(NT,NF)
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),T(NZ),G,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
      COMMON/SULBLK/VH2O(NF,NZ),VH2SO4(NF,NZ),FTAB(NF),H2SO4S(NZ),
     2  FSULF(NZ),CONSO4(NZ)
      COMMON/AERBLK/WFALL(NZ,3),AERSOL(NZ,3),RPAR(NZ,3),HSCALE(NZ),       
     2  CONVER(NZ,3),TAUEDD(NZ),TAUSED(NZ,3),TAUC(NZ,3),
     3  DTAUHC(108,NZ),NBEER
C
C   THIS SUBROUTINE READS A TABLE OF SULFURIC ACID AND H2O VAPOR
C   PRESSURES AS FUNCTIONS OF TEMPERATURE AND CONCENTRATION OF
C   H2SO4 IN THE PARTICLES.  THEN IT PRODUCES A NEW TABLE IN WHICH
C   THE LOG OF THE VAPOR PRESSURES IS STORED AT EACH VERTICAL GRID
C   POINT OF THE MODEL.
C
C ***********************************************************
C   READ DATAFILE (VAPOR PRESSURES IN MM HG)
      READ(2,8003) PH2O,PH2SO4,TTAB,FTAB
 8003 FORMAT(1P6E12.5)
C ***********************************************************
C
C   CONVERT VAPOR PRESSURES TO BARS
      DO 5 K=1,NF
      DO 5 J=1,NT
      PH2O(J,K) = PH2O(J,K)*1.013/760.
   5  PH2SO4(J,K) = PH2SO4(J,K)*1.013/760.
C
C   INTERPOLATE TABLE TO TEMPERATURE AT EACH VERTICAL GRID POINT
      DO 1 J=1,NZ
      DO 2 I=1,NT
      IS = I
      IF(TTAB(I) .GT. T(J)) GO TO 3
   2  CONTINUE
   3  IS1 = MAX0(IS-1,1)
C   T(J) LIES BETWEEN TTAB(IS) AND TTAB(IS1)
      FR = 1.
      IF(IS .GT. IS1) FR = (T(J) - TTAB(IS1))/(TTAB(IS) - TTAB(IS1))
C
C   INTERPOLATE PH2O AND PH2SO4 LOGARITHMICALLY
      DO 4 K=1,NF
      H2OL = ALOG(PH2O(IS,K))
      H2OL1 = ALOG(PH2O(IS1,K))
      H2SO4L = ALOG(PH2SO4(IS,K))
      H2SOL1 = ALOG(PH2SO4(IS1,K))
      VH2O(K,J) = FR*H2OL + (1.-FR)*H2OL1
   4  VH2SO4(K,J) = FR*H2SO4L + (1.-FR)*H2SOL1
   1  CONTINUE
C
      RETURN
      END
C-PK *****************************
      SUBROUTINE AERCON(H2O)
      PARAMETER(NZ=100)
      PARAMETER(NF=34)
      DIMENSION H2O(NZ),PH2OL(NZ)
      COMMON/SATBLK/P(NZ),H2OSAT(NZ),CONDEN(NZ),RELH(NZ)
      COMMON/SULBLK/VH2O(NF,NZ),VH2SO4(NF,NZ),FTAB(NF),H2SO4S(NZ),
     2  FSULF(NZ),CONSO4(NZ)
C
C   THIS SUBROUTINE FINDS THE WEIGHT PERCENT OF H2SO4 IN THE
C   PARTICLES AND THE H2SO4 VAPOR PRESSURE, GIVEN THE TEMPERATURE
C   AND H2O CONCENTRATION AT EACH ALTITUDE.
C
      DO 1 J=1,NZ
   1  PH2OL(J) = ALOG(H2O(J)*P(J))
C
      DO 2 J=1,NZ
      DO 3 K=1,NF
      KS = K
      IF(VH2O(K,J) .LT. PH2OL(J)) GO TO 4
   3  CONTINUE
   4  KS1 = MAX0(KS-1,1)
C
C   PH2OL(J) LIES BETWEEN VH2O(KS,J) AND VH2O(KS1,J)
      FR = 1.
      IF(KS .GT. KS1) FR = (PH2OL(J) - VH2O(KS1,J))/(VH2O(KS,J) -
     2  VH2O(KS1,J))
      FR = AMAX1(FR, 0.)
      FR = AMIN1(FR, 1.)
      FSULF(J) = (FR*FTAB(KS) + (1.-FR)*FTAB(KS1)) * 0.01
      H2SO4L = FR*VH2SO4(KS,J) + (1.-FR)*VH2SO4(KS1,J)
      H2SO4S(J) = EXP(H2SO4L)/P(J)
   2  CONTINUE
C
      RETURN
      END
C-PK **************************
      SUBROUTINE OUTPUT(N,NSTEPS,TIME)
      PARAMETER(NZ=100, NQ=39, NQT=NQ+3, NZP1=NZ+1)
      PARAMETER(NAQ=14)
      PARAMETER(NR=359, NSP=73, NSP1=NSP+1, NSP2=NSP+2, NMAX=70)
      PARAMETER(NF=34)
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),T(NZ),G,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
      COMMON/BBLOK/USOL(NQ,NZ),AMIXCO2,AMIXN2
      COMMON/CBLOK/O3(NZ),H2O(NZ),O2(NZ),CO2(NZ),DZ,ZTROP,NZ1,NPHOT
     2  ,S2(NZ),FSO2(NZ),H2S(NZ),FNH3(NZ),CH4(NZ),C2H6(NZ),JTROP
      COMMON/DBLOK/SL(NSP,NZ),TP(NSP),TL(NSP),O3COL,ISPEC(NSP2)
     2  ,XLG(NQT),SR(NQT),ERR(NQ,NZ),TOUT,SO2COL,H2SCOL,S2COL,
     3  S8(NZ),SO4AER(NZ),HCAER(NZ)
      COMMON/FBLOK/REL(NQ,NZ),MBOUND(NQT),LBOUND(NQT),PHIDEP(NQT),
     2  TLOSS(NQT),HBUG(NQT),HBUG2(NQT),HBUG3(NQT),HCOEFF(NQT),
     3  H2CHEM,H2SURF,H2VOLC,PHIESC,VEFF(NQ)
      COMMON/GBLOK/RAIN(NZ),FSAT(NZ),RAINGC(NQ,NZ)
      COMMON/NBLOK/LO,LO2,LH2O,LH,LOH,LHO2,LH2O2,LH2,LCO,LHCO,LH2CO,
     2  LCH4,LCH3,LC2H6,LNO,LNO2,LHNO,LH2S,LHS,LS,LSO,LSO2,LH2SO4,
     3  LHSO,LS2,LNH3,LNH2,LN2H3,LN2H4,LCH23,LC2H5,LC2H2,LC2H4,
     4  LC3H8,LC2H3,LC3H6,LC3H2,LCH2CCH2,LCH3C2H,LSO4AER,LS8AER,
     5  LHCAER,LHNO2,LHNO3,LNH,LN,LO3,LO1D,LSO21,LSO23,LHSO3,LSO3,
     6  LS3,LNH2X,LC2,LC2H,LC3H7,LC3H3,LCH,LC,LC3H5,LC2H4OH,
     7  LCH3CHO,LCH3CO,LC2H2OH,LCH2CO,LCH21,LCH3O2,LC2H5CHO,LCH3O,
     8  LS4,LCO2,LN2
      COMMON/WBLOK/SO2G0,H2COG0,FNH3G0,ALPHA,HSO2,HH2CO,CO2AQ,
     2  SO4MM,R4(NZ),R5(NZ),R6(NZ),R7(NZ),R8(NZ),R9(NZ),R12(NZ),
     3  HCO2(NZ),H(NQ,NZ),PH(NZ),ENHAN(NQ,NZ),X(NAQ),XSAVE(NAQ,NZ),
     4  SO4SAV(NZ),NH,HNH3
      COMMON/ZBLOK/YP(NQT,NZ),YL(NQT,NZ)
      COMMON/SATBLK/P(NZ),H2OSAT(NZ),CONDEN(NZ),RELH(NZ)
      COMMON/SULBLK/VH2O(NF,NZ),VH2SO4(NF,NZ),FTAB(NF),H2SO4S(NZ),
     2  FSULF(NZ),CONSO4(NZ)
      COMMON/AERBLK/WFALL(NZ,3),AERSOL(NZ,3),RPAR(NZ,3),HSCALE(NZ),       
     2  CONVER(NZ,3),TAUEDD(NZ),TAUSED(NZ,3),TAUC(NZ,3),
     3  DTAUHC(108,NZ),NBEER
      COMMON/RRATS/RAT(NR),RXTOT(NR,NZ)
      COMMON/TOTALMIE/QEXTT(108,NZ), W0T(108,NZ), GFT(108,NZ)
      DIMENSION FUP(NQT),FLOW(NQT),CON(NQT),FLUX(NQT,NZ)
     2  ,ZF(NZ),TAUAER(5),ZKM(NZ),UN2(NZ),UCO2(NZ)
      COMMON/H2COBLOK/FLOW(NQT),VPHOTO_H2,VPHOTO_CO
C
C   THIS SUBROUTINE PRINTS OUT ALL THE DATA.  THE VARIABLE ISKIP SAYS
C   HOW MANY GRID POINTS YOU WANT TO LOOK AT.
C
c  Set ISKIP=1 for mixing ratio profile at every altitude
      ISKIP = 4
      JSKIP = ISKIP
      IF(ISKIP.GT.1 .AND. N.EQ.NSTEPS) ISKIP = 2
      TIMEY = TIME/3600./24./365.
      PRINT 100, TIME,TIMEY
 100  FORMAT(/1X,*TIME =*,1PE9.2,5X,*TIMEY =*,E9.2,1X,*YEARS*)
      PRINT 101,NPHOT
 101  FORMAT(/1X,*NPHOT =*,I3)
C
      PRINT 105
 105  FORMAT(/1X,*MIXING RATIOS OF LONG-LIVED SPECIES*/)
      IROW = 12
      LR = NQ/IROW + 1
      RL = FLOAT(NQ)/IROW + 1
      DIF = RL - LR
      IF (DIF.LT.0.001) LR = LR - 1
C
      DO 8 L=1,LR
      K1 = 1 + (L-1)*IROW
      K2 = K1 + IROW - 1
      IF (L.EQ.LR) K2 = NQ
      PRINT 110, (ISPEC(K),K=K1,K2)
 110  FORMAT(/5X,*Z*,7X,13(A8,1X))
      DO 20 I=1,3
  20  PRINT 120, Z(I),(USOL(K,I),K=K1,K2)
      DO 21 I=4,NZ,ISKIP
  21  PRINT 120, Z(I),(USOL(K,I),K=K1,K2)
 120  FORMAT(1X,1P13E9.2)
      IF (N.EQ.0) GO TO 8
      PRINT 140
 140  FORMAT(/1X,*TP, TL*)
      PRINT 145, (TP(K),K=K1,K2)
      PRINT 145, (TL(K),K=K1,K2)
 145  FORMAT(10X,1P12E9.2)
   8  CONTINUE
C
      PRINT 106
 106  FORMAT(//1X,*MIXING RATIOS OF AEROSOLS*/)
      PRINT 185
 185  FORMAT(5X,*Z*,6X,*SO4AER*,4X,*S8AER*,3X,*HCAER*)
      DO 18 J=1,3
  18  PRINT 182, Z(J),SO4AER(J),S8(J),HCAER(J)
      DO 19 J=4,NZ,ISKIP
  19  PRINT 182, Z(J),SO4AER(J),S8(J),HCAER(J)
 182  FORMAT(1X,1P4E9.2)
      IF (N.EQ.0) GOTO 404 
C
      PRINT 183, TP(LSO4AER),TP(LS8AER),TP(LHCAER)
      PRINT 184, TL(LSO4AER),TL(LS8AER),TL(LHCAER)
 183  FORMAT(/2X,*TP*,6X,1P3E9.2)
 184  FORMAT(2X,*TL*,6X,1P3E9.2)

C-PK 
 404  PRINT 405 
 405  FORMAT(//1X,*MIXING RATIOS OF INERT SPECIES*/)
      PRINT 410
 410  FORMAT(5X,*Z*,7X,*CO2*,9X,*N2*)
      DO 420 K=1,3
 420  PRINT 440, Z(K),AMIXCO2,AMIXN2
      DO 430 K=4,NZ,ISKIP
 430  PRINT 440, Z(K),AMIXCO2,AMIXN2
 440  FORMAT(1X,1P3E9.2)
      IF (N.EQ.0) RETURN
C-PK *EXPERIMENT ONLY (printing out TP, TL for CO2, N2)*
      PRINT 450, TP(LCO2),TP(LN2)
      PRINT 451, TL(LCO2),TL(LN2)
 450  FORMAT(/2X,*TP*,6X,1P2E9.2)
 451  FORMAT(2X,*TL*,6X,1P2E9.2)
C-PK 

C  Print full altitude profiles for plotting
      WRITE(12,34) ISPEC(LH2),ISPEC(LCO),ISPEC(LCH4),ISPEC(LC2H2),
     2  ISPEC(LC2H4),ISPEC(LC2H6),ISPEC(LC3H8),ISPEC(LH),
     3  ISPEC(LO),ISPEC(LOH),ISPEC(LCO2),ISPEC(LN2),ISPEC(LNH3)
  34  FORMAT(*#*,4X,*Z*,7X,13(A8,1X))
      DO 33 I=1,NZ
      ZKM(I) = Z(I)/1.E+5
      UN2(I)=SL(LN2,I)/DEN(I)
      UCO2(I)=SL(LCO2,I)/DEN(I)
  33  WRITE(12,32) ZKM(I),USOL(LH2,I),USOL(LCO,I),USOL(LCH4,I),
     2  USOL(LC2H2,I),USOL(LC2H4,I),USOL(LC2H6,I),USOL(LC3H8,I),
     3  USOL(LH,I),USOL(LO,I),USOL(LOH,I),UCO2(I),UN2(I)
     4  ,USOL(LNH3,I)
  32  FORMAT(1X,1P14E9.2)
C
      PRINT 151,O3COL
 151  FORMAT(//1X,*OZONE COLUMN DEPTH = *,1PE11.4)
      PRINT 152, H2SCOL,SO2COL,S2COL
 152  FORMAT(/1X,*SULFUR COLUMN DEPTHS:  H2S =*,1PE10.3,2X,*SO2 =*,
     2  E10.3,2X,*S2 =*,E10.3)
C-AP      DO 11 J=1,3
C-AP      TAUAER(J) = 0.
C-AP      DO 11 I=1,NZ
C-AP      R = RPAR(I,J)
C-AP  11  TAUAER(J) = TAUAER(J) + 0.6*3.14159*R*R*AERSOL(I,J)*DZ
C
      TAUAER(1) = 0.
      TAUAER(2) = 0.
      TAUAER(3) = 0.
      TAUAER(4) = 0.
C-AP      DO 14 I=1,NZ
C-AP      R = RPAR(I,2)
C-AP  14  TAUAER(4) = TAUAER(4) + 1.2*3.14159*R*R*AERSOL(I,2)*DZ
      TAUAER(5) = 0.
C-AP      PRINT *, 'R   QEXT(37)   W0T(37)   QEXT(79)   W0T(79) '
      DO 914 I=1,NZ
      R = RPAR(I,3)
C-AP      PRINT *, R, QEXTT(37,I), W0T(37,I), QEXTT(79,I), W0T(79,I)
      TAUAER(1) = TAUAER(1) + QEXTT(37,I)*(1-W0T(37,I))*
     & 3.14159*R*R*AERSOL(I,3)*DZ
      TAUAER(2) = TAUAER(2) + QEXTT(79,I)*(1-W0T(79,I))*
     & 3.14159*R*R*AERSOL(I,3)*DZ
      TAUAER(3) = TAUAER(3) + QEXTT(10,I)*3.14159*R*R*
     & AERSOL(I,3)*DZ
      TAUAER(4) = TAUAER(4) + QEXTT(37,I)*3.14159*R*R*
     & AERSOL(I,3)*DZ
 914  TAUAER(5) = TAUAER(5) + QEXTT(79,I)*3.14159*R*R*
     & AERSOL(I,3)*DZ
      PRINT 153, TAUAER
 153  FORMAT(/1X,*SCALED AEROSOL EXTINCTION OPTICAL DEPTHS*,/5X,
     2  *ABS37 =*,1PE10.3,5X,*ABS79 =*,E10.3,5X,*EXT10 =*,
     3  E10.3,5X,*EXT37 =*,E10.3,5X,*EXT79 =*,E10.3)
      PRINT *, 'QEXTUV      OMG0A       ALT'
      DO I=1,NZ,ISKIP
       PRINT *, QEXTT(37,I), W0T(37,I), Z(I)
      ENDDO
      PRINT *, 'QEXTVIS      OMG0A       ALT'
      DO I=1,NZ,ISKIP
       PRINT *, QEXTT(79,I), W0T(79,I), Z(I)
      ENDDO
      PRINT 1151, USOL(LH2O,NH)
 1151  FORMAT(/1X,*FH2O AT COLD TRAP =*,1PE10.3)
      IF(N.LT.NSTEPS) RETURN
C
C ***** PRINT ON LAST ITERATION ONLY *****
      DO 1 I=1,NZ
   1  ZF(I) = Z(I) + 0.5*DZ
C
      DO 3 K=1,NQ
      DO 2 I=1,NZ
   2  SL(K,I) = USOL(K,I)*DEN(I)
      DO 4 I=1,NZ1
      FLUX(K,I) = - DK(K,I)*(USOL(K,I+1) - USOL(K,I))/DZ
     2  - 0.5*(HI(K,I)*DEN(I)*USOL(K,I) + HI(K,I+1)*DEN(I+1)
     3         *USOL(K,I+1))
   4  CONTINUE
   3  CONTINUE
C
      K = LSO4AER
      J = 1
      DO 5 I=1,NZ1
      FLUX(K,I) = -DK(K,I)*(SO4AER(I+1) - SO4AER(I))/DZ
     2  - 0.5*(WFALL(I,J)*DEN(I)*SO4AER(I) + WFALL(I+1,J)*DEN(I+1)
     3         *SO4AER(I+1))
   5  CONTINUE
C
      K = LS8AER
      J = 2
      DO 7 I=1,NZ1
      FLUX(K,I) = - DK(K,I)*(S8(I+1) - S8(I))/DZ
     2  - 0.5*(WFALL(I,J)*
     3         *S8(I+1))
   7  CONTINUE
C
      K = LHCAER
      J = 3
      DO 16 I=1,NZ1
      FLUX(K,I) = -DK(K,I)*(HCAER(I+1) - HCAER(I))/DZ
     2  - 0.5*(WFALL(I,J)*DEN(I)*HCAER(I) + WFALL(I+1,J)*DEN(I+1)
     3         *HCAER(I+1))
  16  CONTINUE
C
      DO 115 K=1,NQT
      FLOW(K) = FLUX(K,1) - (YP(K,1) - YL(K,1)*SL(K,1))*DZ
      FUP(K) = FLUX(K,NZ1) + (YP(K,NZ) - YL(K,NZ)*SL(K,NZ))*DZ            
      CON(K) = TP(K) - TL(K) + FLOW(K) - FUP(K)           
 502  format('K=',I2,' FLOW(K)=',1PE10.3,' FUP(K)=',E10.3)
 115  CONTINUE                                            
      FLUXH2 = FLUX(LH2,NZ1)
      CHEMH2 = (YP(LH2,NZ) - YL(LH2,NZ)*SL(LH2,NZ))*DZ
      print 503, FUP(LH2),FLUXH2,CHEMH2
 503  format(/'FUP(H2)=',1PE10.3,'  FLUXH2=',E10.3,'  CHEMH2=',E10.3)
C                                                         
      FLOW(3) = FLUX(3,11)                                
      CON(3) = TP(3) - TL(3) + FLOW(3) - FUP(3)           
      DO 6 I=1,10                                         
   6  FLUX(3,I) = 0.                                      
C                                                         
      PRINT 125                                           
 125  FORMAT(/1X,*NUMBER DENSITIES OF LONG-LIVED SPECIES*/)               
      DO 9 L=1,LR                                         
      K1 = 1 + (L-1)*IROW                                 
      K2 = K1 + IROW - 1                                  
      IF (L.EQ.LR) K2 = NQT                               
      PRINT 110, (ISPEC(K),K=K1,K2)                       
      DO 22 I=1,NZ,ISKIP                                  
  22  PRINT 120, Z(I),(SL(K,I),K=K1,K2)                   
      PRINT 120, Z(NZ),(SL(K,NZ),K=K1,K2)
   9  CONTINUE
C
      ISKIP = 4
      PRINT 155                                           
 155  FORMAT(/1X,*FLUXES OF LONG-LIVED SPECIES*/)         
      ZFL = 0.                                            
      ZFT = ZF(NZ)                                        
      DO 10 L=1,LR                                        
      K1 = 1 + (L-1)*IROW                                 
      K2 = K1 + IROW - 1                                  
      IF (L.EQ.LR) K2 = NQT                               
      PRINT 110, (ISPEC(K),K=K1,K2)                       
      PRINT 120, ZFL,(FLOW(K),K=K1,K2)                    
      DO 23 I=1,NZ,ISKIP                                  
  23  PRINT 120, ZF(I),(FLUX(K,I),K=K1,K2)                
      PRINT 120, ZFT,(FUP(K),K=K1,K2)                     
  10  CONTINUE                                            
C                                                         
      PRINT 205                                           
 205  FORMAT(/1X,*AQUEOUS PHASE SPECIES*/)                
      PRINT 206                                           
 206  FORMAT(5X,*Z*,6X,*(SO2)G*,3X,*(H2CO)G*,2X,*(SO2)AQ*,1X,             
     2  *CH2(OH)2*,3X,*HCO3-*,4X,*CO3=*,5X,*HSO3-*,4X,*SO3=*,3X,          
     3  *CH2OHSO3-*,3X,*OH-*,5X,*SO4=*,6X,*PH*)
      DO 31 I=1,NH,ISKIP                                  
  31  PRINT 120, Z(I),(XSAVE(K,I),K=1,10),SO4SAV(I),PH(I) 
      PRINT 400
 400  FORMAT(/5X,*Z*,6X,*(NH3)AQ*,2X,*(NH3)G*,3X,*NH4+*,7X,*H+*)
      DO 300 I=1,NH,ISKIP
 300  PRINT 401, Z(I),(XSAVE(K,I),K=11,14)
 401  FORMAT(1X,1P5E9.2)
C                                                         
      PRINT 210                                           
 210  FORMAT(/1X,*NORMAL HENRY'S LAW COEFFICIENTS*/)      
      DO 25 L=1,LR                                        
      K1 = 1 + (L-1)*IROW                                 
      K2 = K1 + IROW - 1                                  
      IF (L.EQ.LR) K2 = NQ                                
      PRINT 110, (ISPEC(K),K=K1,K2)                       
      DO 26 I=1,NH,ISKIP                                  
  26  PRINT 120, Z(I),(H(K,I),K=K1,K2)                    
  25  CONTINUE                                            
C                                                         
      PRINT 215                                           
 215  FORMAT(/1X,*ENHANCEMENTS OF HENRY'S LAW COEFFICIENTS*/)             
      DO 27 L=1,LR                                        
      K1 = 1 + (L-1)*IROW                                 
      K2 = K1 + IROW - 1                                  
      IF (L.EQ.LR) K2 = NQ                                
      PRINT 110, (ISPEC(K),K=K1,K2)                       
      DO 28 I=1,NH,ISKIP                                  
  28  PRINT 120, Z(I),(ENHAN(K,I),K=K1,K2)                
  27  CONTINUE                                            
C                                                         
      PRINT 220                                           
 220  FORMAT(/1X,*GIORGI AND CHAMEIDES RAINOUT RATES*/)   
      DO 29 L=1,LR                                        
      K1 = 1 + (L-1)*IROW                                 
      K2 = K1 + IROW - 1                                  
      IF (L.EQ.LR) K2 = NQ                                
      PRINT 110, (ISPEC(K),K=K1,K2)                       
      DO 30 I=1,NH,ISKIP                                  
  30  PRINT 120, Z(I),(RAINGC(K,I),K=K1,K2)               
  29  CONTINUE                                            
C                                                         
C-PK
      PRINT 175                                           
 175  FORMAT(/1X,*SR, PHIDEP, TLOSS, HCOEFF, SR x HCOEFF,
     2 PHIDEP x HCOEFF, FLOW x HCOEFF, AND LOWER B.C.*/)    
      PRINT 176                                           
 176  FORMAT(1X,*FOLLOWED BY TP, TL, FUP, FLOW, CON*/)    
      DO 13 L=1,LR                                        
      K1 = 1 + (L-1)*IROW                                 
      K2 = K1 + IROW - 1                                  
      IF (L.EQ.LR) K2 = NQT                               
      PRINT 110, (ISPEC(K),K=K1,K2)                       
      PRINT 145, (SR(K),K=K1,K2)                          
      PRINT 145, (PHIDEP(K),K=K1,K2)                       
      PRINT 145, (TLOSS(K),K=K1,K2)                        
      PRINT 145, (HCOEFF(K),K=K1,K2)
      PRINT 145, (SR(K)*HCOEFF(K),K=K1,K2)
      PRINT 145, (PHIDEP(K)*HCOEFF(K),K=K1,K2) 
      PRINT 145, (FLOW(K)*HCOEFF(K),K=K1,K2)
      PRINT 146, (LBOUND(K),K=K1,K2)                      
 146  FORMAT(14X,12(I1,8X))                               
      PRINT 145                                           
      PRINT 145, (TP(K),K=K1,K2)                          
      PRINT 145, (TL(K),K=K1,K2)                          
      PRINT 145, (FUP(K),K=K1,K2)                         
      PRINT 145, (FLOW(K),K=K1,K2)                        
      PRINT 145, (CON(K),K=K1,K2)                         
  13  CONTINUE                                            
C
C   CHECK THAT H2 BUDGET IS BALANCED (H2 PRODUCTION = H2 LOSS)
C-PK      H2PROD = 0.
C-PK      DO 70 I=1,NQT
C-PK  70  H2PROD = H2PROD + FLOW(I)*HCOEFF(I)
C-PK      H2ESC = FUP(LH2)
C-PK      HESC = FUP(LH)
C-PK      H2LOSS = 0.5*HESC + H2ESC + H2CHEM
C-PK      H2BAL = H2PROD - H2LOSS
      H2CHEM = 0.
      H2SURF = 0.
      DO 80 I=1,NQT
      HBUG(I) = SR(I)*HCOEFF(I)
      H2CHEM = H2CHEM + HBUG(I)
      HBUG2(I) = FLOW(I)*HCOEFF(I)
      H2SURF = H2SURF + HBUG2(I) 
      HBUG3(I) = PHIDEP(I)*HCOEFF(I)
  80  CONTINUE
      H2ESC = FUP(LH2) + 0.5*FUP(LH)
      H2BAL = H2SURF + H2VOLC - H2CHEM - H2ESC
C-PK Revised hydrogen budget
      PRINT 310
 310  FORMAT(/1X,'H2 BUDGET BALANCE (PHOTO MODEL)'/)
      PRINT 311, H2SURF,H2VOLC,H2CHEM,H2ESC,H2BAL
 311  FORMAT(5X,'H2SURF =',1PE10.3,3X,'H2VOLC =',E10.3,3X,'H2CHEM =',
     2  E10.3,4X,'H2 ESCAPE =',E10.3,4X,'H2BAL = ',E10.3/)
C-PK H2 vs. CH4 numbers
      VPHOTO_H2 = ABS(FLOW(LH2)/(USOL(LH2,1)*DEN(1)))
      RATIO = ABS(FLOW(LH2)/FLOW(LCH4))
      PRINT 312, FLOW(LH2),FLOW(LCH4),VPHOTO_H2,RATIO
 312  FORMAT(5X,'PHI(H2) = ',1PE11.4,3X,'PHI(CH4) =',1PE11.4,3X,
     2  'VPHOTO(H2) = ',1PE10.3,3X,'|PHI(H2):PHI(CH4)| = ',1PE10.3/)
C-PK CO numbers
      VPHOTO_CO = ABS(FLOW(LCO)/(USOL(LCO,1)*DEN(1)))
C-PK  RATIO = ABS(FLOW(LCO)/FLOW(LCH4))
      PRINT 320, FLOW(LCO),VPHOTO_CO
 320  FORMAT(5X,'PHI(CO) = ',1PE11.4,3X,'VPHOTO(CO) = ',1PE10.3/)
      CALL H2AQ
      CALL COaq

C   COMPUTE CONSERVATION OF SULFUR
      SULDEP = - (FLOW(LHS) + FLOW(LS) + FLOW(LSO) + FLOW(LH2SO4)
     2  + FLOW(LHSO) + 2.*FLOW(LS2) + FLOW(LSO4AER) + 8.*FLOW(LS8AER))
      IF (LBOUND(LSO2).EQ.0) SULDEP = SULDEP - FLOW(LSO2)
      IF (LBOUND(LH2S).EQ.0) SULDEP = SULDEP - FLOW(LH2S)
      SULRAN = SR(LH2S) + SR(LHS) + SR(LS) + SR(LSO) + SR(LSO2) +
     2  SR(LH2SO4) + SR(LHSO) + 2.*SR(LS2) + SR(LSO4AER) +
     3  8.*SR(LS8AER)
      SULLOS = SULDEP + SULRAN
      SULPRO = 0.
      IF (LBOUND(LSO2).NE.0) SULPRO = SULPRO + FLOW(LSO2)
      IF (LBOUND(LH2S).NE.0) SULPRO = SULPRO + FLOW(LH2S)
      SO4LOS = TLOSS(LH2SO4) + TLOSS(LSO4AER)
      S8LOS = 8. * TLOSS(LS8AER)
      PRINT 177, SULLOS,SULPRO,SO4LOS,S8LOS
 177  FORMAT(/1X,*CONSERVATION OF SULFUR:*,/5X,*SULLOS =*,1PE10.3,
     2  2X,*SULPRO =*,E10.3,2X,*SO4LOS =*,E10.3,2X,*S8LOSS =*,
     3  E10.3)
C
      PRINT 179
  179 FORMAT(/1X,*INTEGRATED REACTION RATES*/)
      PRINT 181
      IROW = 10
      LR = NR/IROW + 1
      RL = FLOAT(NR)/IROW + 1
      DIF = RL - LR
      IF (DIF.LT.0.001) LR = LR - 1
C
      DO 17 L=1,LR
      K1 = 1 + (L-1)*IROW
      K2 = K1 + IROW - 1
      IF (L.EQ.LR) THEN
        K2 = NR
        PRINT 186, K1,(RAT(K),K=K1,K2),K2
  186   FORMAT(I3,2X,1P9E10.3,12X,I3)
        GO TO 17
      ENDIF
      PRINT 180, K1,(RAT(K),K=K1,K2),K2
  180 FORMAT(I3,2X,1P10E10.3,2X,I3)
   17 CONTINUE
      PRINT 181
  181 FORMAT(9X,*1*,9X,*2*,9X,*3*,9X,*4*,9X,*5*,9X,*6*,9X,*7*,9X,
     2    *8*,9X,*9*,8X,*10*)
C
      WRITE(14,900)
 900  FORMAT(1X,*Reaction rate profiles*/)
      DO 90 L=1,LR
      K1 = 1 + (L-1)*IROW
      K2 = K1 + IROW - 1
      IF (L.EQ.LR) K2 = NR
      WRITE(14,901) (K,K=K1,K2)
 901  FORMAT(/5X,*Z  Rx#*,4X,10(I4,7X))
      DO 91 J=1,NZ
      ZKM(J) = Z(J)/1.E+5
  91  WRITE(14,902) ZKM(J),(RXTOT(K,J),K=K1,K2)
 902  FORMAT(1P11E11.3)
  90  CONTINUE
C
      PRINT 160
 160  FORMAT(/1X,*PHOTOCHEMICAL EQUILIBRIUM AND INERT SPECIES*)
      NPE = NSP - NQT
      LR = NPE/IROW + 1
      RL = FLOAT(NPE)/IROW + 1
      DIF = RL - LR
      IF (DIF.LT.0.001) LR = LR - 1
C
      NQT1 = NQT + 1
      DO 12 L=1,LR
      K1 = NQT1 + (L-1)*IROW
      K2 = K1 + IROW - 1
      IF (L.EQ.LR) K2 = NSP
      PRINT 110, (ISPEC(K),K=K1,K2)
      DO 24 I=1,NZ,ISKIP
  24  PRINT 120, Z(I),(SL(K,I),K=K1,K2)
  12  CONTINUE
C
      PRINT 190
 190  FORMAT(/1X,*ATMOSPHERIC PARAMETERS*)
      PRINT 195
 195  FORMAT(/4X,*Z*,9X,*T*,9X,*EDD*,7X,*DEN*,8X,*P*,8X,*H2OSAT*,
     2  5X,*H2O*,7X,*RELH*,5X,*CONDEN*)
      PRINT 200, (Z(I),T(I),EDD(I),DEN(I),P(I),H2OSAT(I),H2O(I),
     2  RELH(I),CONDEN(I),I=1,NZ,ISKIP)
      PRINT 200, (Z(NZ),T(NZ),EDD(NZ),DEN(NZ),P(NZ),H2OSAT(NZ),H2O(NZ),
     2  RELH(NZ),CONDEN(NZ))
 200  FORMAT(1X,1P9E10.3)
C
      PRINT 230
 230  FORMAT(/1X,*SULFATE AEROSOL PARAMETERS*)
      PRINT 235
 235  FORMAT(/4X,*Z*,8X,*AERSOL*,5X,*RPAR*,6X,*WFALL*,5X,*FSULF*,4X,
     2  *TAUSED*,4X,*TAUEDD*,4X,*TAUC*,6X,*H2SO4S*,4X,*H2SO4*,5X,
     3  *CONSO4*,4X,*CONVER*)
      PRINT 240, (Z(I),AERSOL(I,1),RPAR(I,1),WFALL(I,1),FSULF(I),
     2  TAUSED(I,1),TAUEDD(I),TAUC(I,1),H2SO4S(I),USOL(LH2SO4,I),
     3  CONSO4(I),CONVER(I,1),I=1,NZ,ISKIP)
 240  FORMAT(1X,1P12E10.3)
C
      PRINT 250
 250  FORMAT(/1X,*S8 AEROSOL PARAMETERS*)
      PRINT 255
 255  FORMAT(/4X,*Z*,8X,*AERSOL*,5X,*RPAR*,6X,*WFALL*,5X,*TAUSED*,4X,
     2  *TAUEDD*,4X,*TAUC*,6X,*CONVER*)
      PRINT 260, (Z(I),AERSOL(I,2),RPAR(I,2),WFALL(I,2),TAUSED(I,2),
     2  TAUEDD(I),TAUC(I,2),CONVER(I,2),I=1,NZ,ISKIP)
 260  FORMAT(1X,1P8E10.3)
C
      PRINT 301
 301  FORMAT(/1X,*HC AEROSOL PARAMETERS*)
      PRINT 255
      PRINT 260, (Z(I),AERSOL(I,3),RPAR(I,3),WFALL(I,3),TAUSED(I,3),
     2  TAUEDD(I),TAUC(I,3),CONVER(I,3),I=1,NZ,ISKIP)
      WRITE(23,601)
 601  FORMAT(1X,*HC AEROSOL PARAMETERS*)
      WRITE(23,255)
      WRITE(23,260) (Z(I),AERSOL(I,3),RPAR(I,3),WFALL(I,3),TAUSED(I,3),
     2  TAUEDD(I),TAUC(I,3),CONVER(I,3),I=1,NZ)
C
      DO 915 L=1,NBEER
      WRITE(19,910) L
 910  FORMAT(/'# BEER''S LAW: HC AEROSOL OPTICAL DEPTH OF LAYER Z',
     2    /'# L = ',I3,
     3    /'#  Z',2X,'TAUEP')
      TAUHC = 0.
      DO 911 I=1,NZ
      J = NZP1 - I
      WRITE(19,912) J,DTAUHC(L,J)
 912  format(I4,1PE10.3)
 911  TAUHC = TAUHC + DTAUHC(L,J)
      WRITE(19,913) TAUHC
 913  FORMAT('# COLUMN INTEGRATED TAUHC =',1PE10.3)
 915  CONTINUE
C
      RETURN
      END
C-PK **********************************
      SUBROUTINE DOCHEM(FVAL,N)                           
      PARAMETER(NZ=100, NQ=39, NQT=NQ+3, NQ1=NQ+1)                   
      PARAMETER(NR=359, NSP=73, NSP1=NSP+1, NSP2=NSP+2, NMAX=70)       
      PARAMETER(NF=34)                                    
      DIMENSION FVAL(NQ,NZ),XP(NZ),XL(NZ),D(NSP2,NZ)
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),T(NZ),G,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
      COMMON/BBLOK/USOL(NQ,NZ),AMIXCO2,AMIXN2
      COMMON/CBLOK/O3(NZ),H2O(NZ),O2(NZ),CO2(NZ),DZ,ZTROP,NZ1,NPHOT       
     2  ,S2(NZ),FSO2(NZ),H2S(NZ),FNH3(NZ),CH4(NZ),C2H6(NZ),JTROP
      COMMON/DBLOK/SL(NSP,NZ),TP(NSP),TL(NSP),O3COL,ISPEC(NSP2)
     2  ,XLG(NQT),SR(NQT),ERR(NQ,NZ),TOUT,SO2COL,H2SCOL,S2COL,
     3  S8(NZ),SO4AER(NZ),HCAER(NZ)
      COMMON/FBLOK/REL(NQ,NZ),MBOUND(NQT),LBOUND(NQT),PHIDEP(NQT),
     2  TLOSS(NQT),HBUG(NQT),HBUG2(NQT),HBUG3(NQT),HCOEFF(NQT),
     3  H2CHEM,H2SURF,H2VOLC,PHIESC,VEFF(NQ)
      COMMON/GBLOK/RAIN(NZ),FSAT(NZ),RAINGC(NQ,NZ)        
      COMMON/LTBLOK/ZAPNO,ZAPO2,PRONO,PRONOP              
      COMMON/NBLOK/LO,LO2,LH2O,LH,LOH,LHO2,LH2O2,LH2,LCO,LHCO,LH2CO,
     2  LCH4,LCH3,LC2H6,LNO,LNO2,LHNO,LH2S,LHS,LS,LSO,LSO2,LH2SO4,
     3  LHSO,LS2,LNH3,LNH2,LN2H3,LN2H4,LCH23,LC2H5,LC2H2,LC2H4,
     4  LC3H8,LC2H3,LC3H6,LC3H2,LCH2CCH2,LCH3C2H,LSO4AER,LS8AER,
     5  LHCAER,LHNO2,LHNO3,LNH,LN,LO3,LO1D,LSO21,LSO23,LHSO3,LSO3,
     6  LS3,LNH2X,LC2,LC2H,LC3H7,LC3H3,LCH,LC,LC3H5,LC2H4OH,
     7  LCH3CHO,LCH3CO,LC2H2OH,LCH2CO,LCH21,LCH3O2,LC2H5CHO,LCH3O,
     8  LS4,LCO2,LN2
      COMMON/ZBLOK/YP(NQT,NZ),YL(NQT,NZ)                  
      COMMON/RBLOK/A(NR,NZ),ILOSS(2,NSP,NMAX),IPROD(NSP,NMAX),
     2  JCHEM(5,NR),NUML(NSP),NUMP(NSP)
      COMMON/SATBLK/P(NZ),H2OSAT(NZ),CONDEN(NZ),RELH(NZ)  
      COMMON/SULBLK/VH2O(NF,NZ),VH2SO4(NF,NZ),FTAB(NF),H2SO4S(NZ),        
     2  FSULF(NZ),CONSO4(NZ)                              
      COMMON/RRATS/RAT(NR),RXTOT(NR,NZ)
      COMMON/LifeTime/TAUO2,TAUCH4
C                                                         
C   THIS SUBROUTINE DOES THE CHEMISTRY BY CALLING CHEMPL.  PHOTO-         
C   CHEMICAL EQUILIBRIUM SPECIES ARE DONE FIRST.  THESE MUST CON-         
C   TAIN NO NONLINEARITIES (SUCH AS S4 REACTING WITH ITSELF TO FORM       
C   S8) AND MUST BE DONE IN THE PROPER ORDER (I.E. IF SPECIES A           
C   REACTS TO FORM B, THEN A MUST BE FOUND FIRST).  LONG-LIVED            
C   SPECIES CAN BE DONE IN ANY ORDER.                     
C                                                         
      SRAIN = 1.E-4                                       
      DO 1 I=1,NQ                                         
      DO 1 J=1,NZ                                         
   1  D(I,J) = USOL(I,J) * DEN(J)                         
C                                                         
      DO 2 J=1,NZ                                         
      D(LSO4AER,J) = SO4AER(J) * DEN(J)                           
      D(LS8AER,J) = S8(J) * DEN(J)                           
      D(LHCAER,J) = HCAER(J) * DEN(J)                           
      D(NSP-1,J) = CO2(J) * DEN(J)                        
      D(NSP,J) = (1. - O2(J) - CO2(J) - USOL(LCO,J)) * DEN(J)           
      AMIXN2 = D(NSP,J)/DEN(J) 
      D(NSP,J) = AMAX1(D(NSP,J),1.E-60)
      D(NSP1,J) = 1.                                      
   2  D(NSP2,J) = DEN(J)
C                                                         
C ***** SOLVE FOR THE PHOTOCHEMICAL EQUILIBRIUM SPECIES *****             
C                                                         
      NQT1 = NQT + 1                                       
      NSP3 = NSP - 3                                      
      DO 3 I=NQT1,NSP3                                     
      CALL CHEMPL(D,XP,XL,I)                              
      DO 3 J=1,NZ                                         
   3  D(I,J) = XP(J)/XL(J)
C
C   SOLVE QUADRATIC FOR S4
      DO 15 J=1,NZ
      AQ = 2.*A(182,J)
      BQ = A(183,J)
      CQ = A(180,J)*D(LS2,J)*D(LS2,J) + A(181,J)*D(LS,J)*D(LS3,J)
      DLS4 = (SQRT(BQ*BQ + 4.*AQ*CQ) - BQ)/(2.*AQ)
  15  D(LS4,J) = AMAX1(DLS4,0.)
C
C ***** LONG-LIVED SPECIES CHEMISTRY *****
      DO 4 I=1,NQ
      CALL CHEMPL(D,XP,XL,I)
C-AP
      IF (I.EQ.2) THEN
      TAUO2 = 1/XL(1)
      ENDIF
      IF (I.EQ.12) THEN
      TAUCH4 = 1/XL(1)
      ENDIF
C-AP
      DO 4 J=1,NZ
      XLJ = XL(J) + RAINGC(I,J)
      FVAL(I,J) = XP(J)/DEN(J) - XLJ*USOL(I,J)
      YP(I,J) = XP(J)
   4  YL(I,J) = XLJ
c
c     IF(N.EQ.1)THEN
c     print 901
c 901 format(/'YP/YL',/4X,'H2',8X,'CO',8X,'CH4',8X,'NH3')
c     print 900, YP(LH2,1),YP(LCO,1),YP(LCH4,1),YP(LNH3,1)
c     print 900, YL(LH2,1),YL(LCO,1),YL(LCH4,1),YL(LNH3,1)
c 900 format(1P4E10.3)
c     ENDIF
C
C ***** TRIDIAGONAL SPECIES (s8 + ANY OTHERS) *****
      DO 16 I = NQ1,NQT
      CALL CHEMPL(D,XP,XL,I)
      DO 16 J=1,NZ
      YL(I,J) = XL(J) + RAINGC(LH2SO4,J)
  16  YP(I,J) = XP(J)
C
C   ZERO OUT H2O TERMS IN THE TROPOSPHERE AND INCLUDE LIGHTNING
C   PRODUCTION OF NO, O2, AND CO.  (MUST INCLUDE CO IN ORDER TO
C   BALANCE THE HYDROGEN BUDGET)
      JT1 = JTROP + 1
      CONFAC = 1.6E-5                                     
      DO 5 J=1,JTROP                                      
      FVAL(LH2O,J) = 0.                                   
      SCALE = RAIN(J)/RAIN(1)                             
      ZAP = ZAPNO * SCALE                                 
      FVAL(LNO,J) = FVAL(LNO,J) + ZAP/DEN(J)              
      YP(LNO,J) = YP(LNO,J) + ZAP                         
      ZAP = ZAPO2 * SCALE                                 
      FVAL(LO2,J) = FVAL(LO2,J) + ZAP/DEN(J)              
      YP(LO2,J) = YP(LO2,J) + ZAP                         
      ZAP = (ZAPNO + 2.*ZAPO2)*SCALE                      
      FVAL(LCO,J) = FVAL(LCO,J) + ZAP/DEN(J)              
      YP(LCO,J) = YP(LCO,J) + ZAP                         
   5  CONTINUE                                            
C                                                         
C *** VOLCANIC OUTGASSING OF SO2 AND H2 ***
C-PK  PRSO2 = 3.5E8, PRH2 = 2.e10, distributed over lower 10 km.
C-PK  Set PRSO2 = 3.5e8 to match EPSL sulfur paper calculations;
C-PK  Set PRH2 (=H2VOLC) = 2.e10 = Phi_esc(H2), where 
C-PK  Phi_esc(H2) = 2.5e13*f_tot(H2) after Walker(1977) 
C-PK  (Note: H2VOLC = 2.e10 in Holland's 2002 GCA paper)
C        (JTEN=5 covers five 2-km levels on Mars)
      PRSO2 = 3.5E8/1.E6
      PRH2 = H2VOLC/1.E6
      JTEN = 1.E6/DELZ + 0.01
      DO 351 J=1,JTEN
      FVAL(LSO2,J) = FVAL(LSO2,J) + PRSO2/DEN(J)
      FVAL(LH2,J) = FVAL(LH2,J) + PRH2/DEN(J)
      YP(LSO2,J) = YP(LSO2,J) + PRSO2
      YP(LH2,J) = YP(LH2,J) + PRH2
 351  CONTINUE
C
C   H2O CONDENSATION IN THE STRATOSPHERE
C   (RHCOLD IS THE ASSUMED RELATIVE HUMIDITY AT THE COLD TRAP)
      RHCOLD = 0.1
      DO 13 J=JT1,NZ
      H2OCRT = RHCOLD * H2OSAT(J)
      IF (USOL(LH2O,J) .LT. H2OCRT) GO TO 13
      CONDEN(J) = CONFAC * (USOL(LH2O,J) - H2OCRT)
      FVAL(LH2O,J) = FVAL(LH2O,J) - CONDEN(J)
  13  CONTINUE
C
C   H2SO4 CONDENSATION
      DO 14 J=1,NZ
      CONSO4(J) = CONFAC * (USOL(LH2SO4,J) - H2SO4S(J))
C-AP
      CONSO4(J) = AMAX1(CONSO4(J),0.)
C-AP
      FVAL(LH2SO4,J) = FVAL(LH2SO4,J) - CONSO4(J)
      YL(LH2SO4,J) = YL(LH2SO4,J) + CONFAC
      YP(LH2SO4,J) = YP(LH2SO4,J) + CONFAC*H2SO4S(J)*DEN(J)
      YP(LSO4AER,J) = YP(LSO4AER,J) + CONSO4(J)*DEN(J)
  14  CONTINUE
C
      DO 7 J=1,NZ
   7  O3(J) = D(LO3,J)/DEN(J)
      IF(N.LT.1) RETURN
C
C ***** CALCULATE COLUMN-INTEGRATED PRODUCTION AND LOSS *****
      O3COL = 0.
      H2SCOL = 0.
      SO2COL = 0.
      S2COL = 0.
      DO 10 L=1,NR
  10  RAT(L) = 0.
      DO 11 K=1,NQT
      TP(K) = 0.
      TL(K) = 0.
  11  CONTINUE
C
      DO 6 J=1,NZ
      RELH(J) = USOL(LH2O,J)/H2OSAT(J)
      H2SCOL = H2SCOL + D(LH2S,J)*DZ
      SO2COL = SO2COL + D(LSO2,J)*DZ
      S2COL = S2COL + D(LS2,J)*DZ
   6  O3COL = O3COL + D(LO3,J)*DZ
C
      DO 12 L=1,NR
      M = JCHEM(1,L)
      K = JCHEM(2,L)
      DO 12 J=1,NZ
      RXTOT(L,J) = A(L,J)*D(M,J)*D(K,J)
  12  RAT(L) = RAT(L) + A(L,J)*D(M,J)*D(K,J)*DZ
C
      DO 8 I=1,NQT
      XLG(I) = YL(I,1)
      DO 8 J=1,NZ
      TP(I) = TP(I) + YP(I,J)*DZ
      TL(I) = TL(I) + YL(I,J)*D(I,J)*DZ
   8  CONTINUE
C
C ***** SAVE THESE DENSITIES FOR PRINTOUT *****
      DO 9 I=NQ1,NSP
      DO 9 J=1,NZ
   9  SL(I,J) = D(I,J)
      RETURN
      END
C-PK *******************************
      SUBROUTINE CHEMPL(D,XP,XL,K)
      PARAMETER(NZ=100, NQ=39)
      PARAMETER(NR=359, NSP=73, NSP1=NSP+1, NSP2=NSP+2,NMAX=70)
      DIMENSION XP(NZ),XL(NZ),D(NSP2,NZ)
      COMMON/RBLOK/A(NR,NZ),ILOSS(2,NSP,NMAX),IPROD(NSP,NMAX),
     2  JCHEM(5,NR),NUML(NSP),NUMP(NSP)
C
C   THIS SUBROUTINE CALCULATES CHEMICAL PRODUCTION AND LOSS RATES
C   USING THE INFORMATION IN THE MATRICES JCHEM, ILOSS, AND IPROD.
C   CALLED BY SUBROUTINE DOCHEM.
C
      DO 1 I=1,NZ
      XP(I) = 0.
   1  XL(I) = 0.
C
C   LOSS FREQUENCY XL
      NL = NUML(K)
      DO 2 L=1,NL
      J = ILOSS(1,K,L)
      M = ILOSS(2,K,L)
      DO 2 I=1,NZ
C-AP
C-AP      IF ((K.EQ.2).AND.(I.EQ.1)) THEN 
C-AP      TERM = A(J,I)*D(M,I)
C-AP      PRINT *, 'J= ', J, 'TERM= ', TERM, 'L= ', L
C-AP      ENDIF
   2  XL(I) = XL(I) + A(J,I)*D(M,I)
C
C   PRODUCTION RATE XP
      NP = NUMP(K)
      DO 3 L=1,NP
      J = IPROD(K,L)
      M = JCHEM(1,J)
      N = JCHEM(2,J)
      DO 3 I=1,NZ
   3  XP(I) = XP(I) + A(J,I)*D(M,I)*D(N,I)
C
      RETURN
      END
C-PK *********************************
      SUBROUTINE LTNING(FO2,FCO2,P0CGS)
      PARAMETER(NZ=100, NQ=39)
      COMMON/BBLOK/USOL(NQ,NZ),AMIXCO2,AMIXN2
      COMMON/LTBLOK/ZAPNO,ZAPO2,PRONO,PRONOP
      COMMON/NBLOK/LO,LO2,LH2O,LH,LOH,LHO2,LH2O2,LH2,LCO,LHCO,LH2CO,
     2  LCH4,LCH3,LC2H6,LNO,LNO2,LHNO,LH2S,LHS,LS,LSO,LSO2,LH2SO4,
     3  LHSO,LS2,LNH3,LNH2,LN2H3,LN2H4,LCH23,LC2H5,LC2H2,LC2H4,
     4  LC3H8,LC2H3,LC3H6,LC3H2,LCH2CCH2,LCH3C2H,LSO4AER,LS8AER,
     5  LHCAER,LHNO2,LHNO3,LNH,LN,LO3,LO1D,LSO21,LSO23,LHSO3,LSO3,
     6  LS3,LNH2X,LC2,LC2H,LC3H7,LC3H3,LCH,LC,LC3H5,LC2H4OH,
     7  LCH3CHO,LCH3CO,LC2H2OH,LCH2CO,LCH21,LCH3O2,LC2H5CHO,LCH3O,
     8  LS4,LCO2,LN2
C
C     THIS SUBROUTINE CALCULATES LIGHTNING PRODUCTION RATES FOR O2
C     AND NO IN AN N2-O2-CO2-H2O ATMOSPHERE USING THE EQUATIONS IN
C     THESIS APPENDIX C.
C
C     EQUILIBRIUM CONSTANTS AT 3500 K
      AK1 = .103
      AK2 = .619
      AK3 = 5.3
      AK4 = .22
C
      P0 = P0CGS/1.013E6
      FCO = USOL(LCO,1)
      FN2 = 1. - FO2 - FCO2 - FCO
      AMIXN2 = FN2 
      PN2 = FN2*P0
      PO2 = FO2*P0
      PCO2 = FCO2*P0
      PH2O = USOL(LH2O,1) * P0
      PH2 = USOL(LH2,1) * P0
      PCO = USOL(LCO,1) * P0
C
      O2T = PO2 + PCO2 + 0.5*(PH2O + PCO)
      H2T = PH2 + PH2O
      CT = PCO2 + PCO
      ALPHA = AK2*SQRT(O2T)
      BETA = AK3*SQRT(O2T)
      A = (AK1*SQRT(PN2) + AK4)/(2.*SQRT(O2T))
      B = 0.5*CT/O2T
      C = 0.5*H2T/O2T
C
C     INITIAL GUESS FOR XO2 AT 3500 K
      X = 0.1 + 0.9*PO2/O2T + 0.2*PCO2/O2T
c For very low fCO2, use previous value of X
c     X = 4.375E-2
C
      PRINT 103, P0,FN2,PCO2
 103  FORMAT(/'LTNING: P0=',1PE10.3,' FN2=',E10.3,' PCO2=',E10.3)
      PRINT 104, O2T,X
 104  FORMAT('         O2T=',1PE10.3,' Initial X=',E10.3)
      PRINT 106
 106  FORMAT('Newton Step:')
C
C     NEWTON STEP
      DO 1 N=1,20
      NS = N
      XS = X
      X2 = SQRT(X)
      FX = X + A*X2 - B/(1.+ALPHA*X2) - C/(1.+BETA*X2) + 2.*B + C - 1.
      FPX = 1. + (A + ALPHA*B/(1.+ALPHA*X2)**2 + BETA*C/(1.+BETA*X2)
     2  **2)/(2.*X2)
      X = X - FX/FPX
c If X goes negative, just use previous value
      IF (X.LT.0.) X = 4.375E-2
      ERR = ABS((X-XS)/X)
      PRINT 105, X
 105  FORMAT('    X=',1PE10.3)
      IF(ERR.LT.1.E-5) GO TO 2
   1  CONTINUE
   2  PO2 = X*O2T
      PNO = AK1*SQRT(PN2*PO2)
C
C     SCALE AGAINST ESTIMATED COLUMN PRODUCTION OF NO IN THE PRESENT-
C     DAY TROPOSPHERE.  DISTRIBUTE PRODUCTION OVER LOWEST 6 KM.
C
C   COLUMN-INTEGRATED NO PRODUCTION RATE IN PRESENT ATMOSPHERE IS
C   EQUAL TO PRONO
      PRNOX = PRONO/7.942E5
      PNONOW = 3.574E-2
      PRONOP = PRONO * PNO/PNONOW
      ZAPNO = PRNOX*PNO/PNONOW
      ZAPO2 = ZAPNO*PO2/PNO
      PRINT 100, PO2,PNO,ZAPO2,ZAPNO,PRONO,PRONOP
 100  FORMAT(/1X,*PO2=*,1PE10.3,2X,*PNO=*,1PE10.3,2X,*ZAPO2=*,
     2  E10.3,2X,*ZAPNO =*,E10.3,2X,*PRONO =*,E10.3,2X,*PRONOP =*,
     3  E10.3)
      PRINT 101,NS,X,ERR
 101  FORMAT(1X,*N=*,I2,5X,*X=*,1PE12.5,2X,*ERR=*,1PE12.5)
      RETURN
      END
C-PK ********************************
      SUBROUTINE MSCAT(SIGR,U0,SO3,SO2,SCO2,SH2O,SSO2,SS2,
     2  SH2S,SNH3,WAV)
C
C          THIS SUBROUTINE COMPUTES NORMALIZED SOURCE FUNCTIONS DUE
C     TO RAYLEIGH SCATTERING USING YUK YUNGS METHOD.
C
      PARAMETER(NZ=100, NQ=39, NQT=NQ+3)
      PARAMETER(ML=48,ML1=ML+1,ML2=2*ML)
      DIMENSION B(ML2,ML2),IPVT(ML2),F(ML2),TAU(ML1),W0(ML1),
     2  D3(ML1),D5(ML1),D7(ML1),TA(NZ),TAB(NZ),W(NZ)
     2  ,SO3(NZ),SO2(NZ),W0P(2),W0PS(2),QEXT(2),SIGS(NZ,2),SIGA(NZ,2),
     3  SIGAT(NZ),SIGST(NZ),TMS(NZ)
      DIMENSION XI(ML1,2),EX1(ML1,2),E2(ML1,2),E3(ML1,2),E4(ML1,2),
     2  E5(ML1,2),E1S(ML1),XIS(ML1)
      REAL L2(ML),L4(ML),G1(ML),G2(ML),G3(ML),G4(ML),M1(ML,ML),
     2  M3(ML,ML),M5(ML,ML)
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),TEMP(NZ),G,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
      COMMON/CBLOK/O3(NZ),H2O(NZ),O2(NZ),CO2(NZ),DZ,ZTROP,NZ1,NPHOT
     2  ,S2(NZ),FSO2(NZ),H2S(NZ),FNH3(NZ),CH4(NZ),C2H6(NZ),JTROP
      COMMON/TBLOK/TTOT(NZ),TCO2(NZ),TO2(NZ),TH2O(NZ),TO3(NZ),S(NZ)
     2  ,TSO2(NZ),TS2(NZ),TH2S(NZ),TNH3(NZ),TCH4(NZ),TC2H6(NZ)
      COMMON/AERBLK/WFALL(NZ,3),AERSOL(NZ,3),RPAR(NZ,3),HSCALE(NZ),
     2  CONVER(NZ,3),TAUEDD(NZ),TAUSED(NZ,3),TAUC(NZ,3),
     3  DTAUHC(108,NZ),NBEER
C
C   THIS SUBROUTINE DOES RAYLEIGH SCATTERING USING YUK YUNG'S
C   METHOD.  MIE SCATTERING BY PARTICLES IS COMPUTED BY USING VAN
C   DE HULST'S SIMILARITY RELATIONS TO SCALE FROM ANISOTROPIC TO
C   ISOTROPIC SCATTERING.  EQUATIONS ARE SOLVED ON A GRID THAT IS
C   EVENLY SPACED IN EXTINCTION OPTICAL DEPTH (TAU).
C
      NZ1 = NZ - 1
      PI = 3.14159
C
C   COMPUTE FACTORS FOR SCALING FORWARD TO ISOTROPIC SCATTERING
      G0 = 0.8
      W0P(1) = 1.
      W0P(2) = 0.5
      IF (WAV.GT.3500.) W0P(2) = 1.
      DO 25 J=1,2
      W0PS(J) = (1.-G0)*W0P(J)/(1.-G0*W0P(J))
  25  QEXT(J) = 2.*(1.-G0*W0P(J))
C
C   COMPUTE EXTINCTION, ABSORPTION, AND SCATTERING CROSS SECTIONS FOR
C   PARTICLES (NOTE THAT THEY ARE SCALED TO COMPARE WITH MOLECULAR
C   ABSORPTION AND SCATTERING)
      DO 26 J=1,2
      DO 26 I=1,NZ
      SIGE = QEXT(J)*PI*RPAR(I,J)*RPAR(I,J)*AERSOL(I,J)/DEN(I)
      SIGS(I,J) = W0PS(J)*SIGE
  26  SIGA(I,J) = (1.-W0PS(J))*SIGE
C
C   COMPUTE SINGLE SCATTERING ALBEDO W(I) FOR GASES PLUS PARTICLES
      DO 1 I=1,NZ
      SIGAT(I) = SIGA(I,1) + SIGA(I,2)
      SIGST(I) = SIGS(I,1) + SIGS(I,2)
      SIGABS = SO3(I)*O3(I) + SO2(I)*O2(I) + SCO2*CO2(I)
     2  + SH2O*H2O(I) + SSO2*FSO2(I) + SS2*S2(I)
     3  + SH2S*H2S(I) + SNH3*FNH3(I) + SIGAT(I)
   1  W(I) = (SIGR + SIGST(I))/(SIGR + SIGST(I) + SIGABS) 
C
C   COMPUTE ABSORPTION (TAB) AND EXTINCTION (TA) OPTICAL DEPTHS 
      TAB(NZ) = SO3(NZ)*TO3(NZ) + SO2(NZ)*TO2(NZ) + SCO2*TCO2(NZ)
     2  + SH2O*TH2O(NZ) + SSO2*TSO2(NZ) + SS2*TS2(NZ)
     3  + SH2S*TH2S(NZ) + SNH3*TNH3(NZ) + SIGAT(NZ)*DEN(NZ)*HSCALE(NZ)
      TMS(NZ) = SIGST(NZ)*DEN(NZ)*HSCALE(NZ)
      TA(NZ) = TAB(NZ) + SIGR*TTOT(NZ) + TMS(NZ)
C
      DO 19 J=1,NZ1
      I = NZ - J
      SIGO2 = 0.5*(SO2(I) + SO2(I+1))
      SIGO3 = 0.5*(SO3(I) + SO3(I+1))
      TAB(I) = TAB(I+1) + SIGO3*(TO3(I) - TO3(I+1)) + SIGO2*
     2  (TO2(I) - TO2(I+1)) + SCO2*(TCO2(I) - TCO2(I+1)) +
     3  SH2O*(TH2O(I) - TH2O(I+1)) + SSO2*(TSO2(I) - TSO2(I+1))
     4  + SS2*(TS2(I) - TS2(I+1)) + SH2S*(TH2S(I) - TH2S(I+1))
     5  + SNH3*(TNH3(I) - TNH3(I+1)) + SIGAT(I)*DEN(I)*DZ
      TMS(I) = TMS(I+1) + SIGST(I)*DEN(I)*DZ
  19  TA(I) = TAB(I) + SIGR*TTOT(I) + TMS(I)
C
C ***** DEFINE BOTTOM OF SCATTERING ATMOSPHERE WHERE THE PURE
C       ABSORPTION OPTICAL DEPTH IS EQUAL TO 5 *****
      DO 21 L=1,NZ
      I = NZ - L + 1
      IF(TAB(I).GT.5.) GO TO 22
  21  CONTINUE
      MZ = 1
      GO TO 23
  22  MZ = I + 1
  23  LZ = NZ - MZ + 1
C
      SDEPTH = TA(MZ)
      NL = SDEPTH/0.5
      NL = MIN0(NL,ML)
      NL = MAX0(NL,3)
      NL1 = NL + 1
      NLM1 = NL - 1
      NL2 = 2*NL
C
      TAU(1) = 0.
      TAU(NL1) = TA(MZ)
      DT = TAU(NL1)/FLOAT(NL)
      DO 2 J=2,NL
   2  TAU(J) = (J-1)*DT
C
C ***** FIND SINGLE SCATTERING ALBEDOS AT THE CENTERS OF THE EQUALLY-
C       SPACED TAU LEVELS *****
      W0(1) = W(NZ)
      W0(NL1) = W(MZ)
      IS = 1
      DO 3 J=2,NL
      DO 4 I=IS,LZ
      IN = NZ - I + 1
      IF(TA(IN).GT.TAU(J)) GO TO 5
   4  CONTINUE
   5  IS = NZ - IN - 1
C
C     TAU(J) LIES BETWEEN TA(IN) AND TA(IN+1)
C
      FR = (TAU(J) - TA(IN+1))/(TA(IN) - TA(IN+1))
      W0(J) = FR*W(IN) + (1.-FR)*W(IN+1)
   3  CONTINUE
C
C     CONVERT TO CENTERED VALUES
      DO 6 J=1,NL
   6  W0(J) = SQRT(W0(J)*W0(J+1))
C
C ***** COMPUTE THE VALUES OF LI AND MIJ *****
      DO 7 I=1,NL1
      DTAU = (I-1)*DT
      XIS(I) = DTAU
      E1S(I) = E1(DTAU)
   7  CONTINUE
C
      DO 30 I=1,NL1
      X = XIS(I)
      X2 = X*X
      X3 = X*X2
      X4 = X*X3
      X5 = X*X4
      X6 = X*X5                                           
      E1X = E1S(I)
      PEX = EXP(-X)
      D3(I) = (X2*E1X + PEX*(1. - X))/2.
      D5(I) = (X4*E1X + PEX*(6. - 2.*X + X2 - X3))/24.
  30  D7(I) = (X6*E1X + PEX*(120. - 24.*X + 6.*X2 - 2.*X3 + X4
     2  - X5))/720.
C
      SM1 = 2.*(DT - 0.5 + D3(2))
      SM3 = 2.*(DT/3. - 0.25 + D5(2))
      SM5 = 2.*(DT/5. - 1./6. + D7(2))
      DO 8 I=1,NL
      L2(I) = D3(NL-I+1) - D3(NL-I+2)
      L4(I) = D5(NL-I+1) - D5(NL-I+2)
      M1(I,I) = SM1
      M3(I,I) = SM3
      M5(I,I) = SM5
   8  CONTINUE
C
      DO 16 I=2,NL
      M1(I,1) = D3(I-1) + D3(I+1) - 2.*D3(I)
      M3(I,1) = D5(I-1) + D5(I+1) - 2.*D5(I)
      M5(I,1) = D7(I-1) + D7(I+1) - 2.*D7(I)
  16  CONTINUE
C
      DO 17 I=2,NLM1
      I1 = I + 1
      DO 17 J=I1,NL
      K = J - I + 1
      M1(J,K) = M1(I,1)
      M3(J,K) = M3(I,1)
      M5(J,K) = M5(I,1)
  17  CONTINUE
C
      DO 18 I=2,NL
      I1 = I - 1
      DO 18 J=1,I1
      M1(J,I) = M1(I,J)
      M3(J,I) = M3(I,J)
      M5(J,I) = M5(I,J)
  18  CONTINUE
C
C ***** COMPUTE THE ELEMENTS OF THE MATRIX EQUATION *****
      U2 = U0*U0
      TG = TAU(NL1)
      C1 = 3.*U0/(32.*DT)
      C2 = 2.*ALB*EXP(-TG/U0)
C
      DO 9 I=1,NL
      D1 = EXP(-TAU(I)/U0)
      D2 = EXP(-TAU(I+1)/U0)
      F(I) = C1*W0(I)*((1.-U2)*(D1 - D2) + C2*(L2(I) - L4(I)))
      F(I+NL) = C1*W0(I)*((1.+U2)*(D1 - D2) + C2*(L2(I) + L4(I)))
   9  CONTINUE
C
      C1 = 0.75/DT
      C2 = 0.5*C1
      DO 10 I=1,NL
      DO 10 J=1,NL
      B(I,J) = -C1*W0(I)*(M1(I,J) - 2.*M3(I,J) + M5(I,J)
     2  + ALB*(L2(I) - L4(I))*(L2(J) - L4(J)))
      B(I,J+NL) = -C2*W0(I)*(M3(I,J) - M5(I,J)
     2  + ALB*(L2(I) - L4(I))*(L2(J) + L4(J)))
      B(I+NL,J) = - C1*W0(I)*(M3(I,J) - M5(I,J)
     2  + ALB*(L2(I) + L4(I))*(L2(J) - L4(J)))
      B(I+NL,J+NL) = - C2*W0(I)*(M1(I,J) + M5(I,J)
     2  + ALB*(L2(I) + L4(I))*(L2(J) + L4(J)))
  10  CONTINUE
C
      DO 11 I=1,NL2
  11  B(I,I) = B(I,I) + 1.
C
C ***** SOLVE THE MATRIX EQUATION *****
      CALL SGEFA(B,ML2,NL2,IPVT,INFO)
      IF(INFO.NE.0) PRINT 100,INFO,WAV
 100  FORMAT(1X,*INFO=*,I3,5X,*WAV=*,1PE11.4)
      CALL SGESL(B,ML2,NL2,IPVT,F,0)
C
C ***** COMPUTE THE NORMALIZED SOURCE FUNCTIONS AT THE ORIGINAL
C       GRID LEVELS *****
      C1 = 2.*ALB*U0*EXP(-TG/U0)
C
      DO 20 L=1,LZ
      K = NZ - L + 1
      T = TA(K)
      TU = T/U0
      IF(K.EQ.NZ.OR.TU.GT.0.02) GO TO 12
      S(K) = S(NZ)
      GO TO 20
  12  CONTINUE
C
      DO 13 I=1,NL
      IF(T.LT.TAU(I+1).AND.T.GT.TAU(I)) GO TO 14
      T1 = ABS(TAU(I) - T)
      T2 = ABS(TAU(I+1) - T)
      GO TO 31
  14  CONTINUE
      T1 = T - TAU(I)
      T2 = TAU(I+1) - T
  31  XI(I,1) = T1
      XI(I,2) = T2
      EX1(I,1) = E1(T1)
      EX1(I,2) = E1(T2)
  13  CONTINUE
C
      DO 32 J=1,2
      DO 32 I=1,NL
      X = XI(I,J)
      X2 = X*X
      X3 = X*X2
      X4 = X*X3
      PEX = EXP(-X)
      E1X = EX1(I,J)
      E2(I,J) = PEX - X*E1X
      E3(I,J) = (X2*E1X + PEX*(1. - X))/2.
      E4(I,J) = (-X3*E1X + PEX*(2. - X + X2))/6.
      E5(I,J) = (X4*E1X + PEX*(6. - 2.*X + X2 - X3))/24.
  32  CONTINUE
C
      DO 33 I=1,NL
      IF(T.LT.TAU(I+1) .AND. T.GT.TAU(I)) GO TO 34
      G1(I) = ABS(E2(I,1) - E2(I,2))
      G2(I) = ABS(E3(I,1) - E3(I,2))
      G3(I) = ABS(E4(I,1) - E4(I,2))
      G4(I) = ABS(E5(I,1) - E5(I,2))
      GO TO 33
  34  CONTINUE
      G1(I) = 2. - E2(I,1) - E2(I,2)
      G2(I) = 1. - E3(I,1) - E3(I,2)
      G3(I) = 2./3. - E4(I,1) - E4(I,2)
      G4(I) = 0.5 - E5(I,1) - E5(I,2)
  33  CONTINUE
C
      SUM1 = 0.
      SUM2 = 0.
      SUM3 = 0.
      SUM4 = 0.
      DO 15 I=1,NL
      J = I + NL
      SUM1 = SUM1 + (2.*F(I) + F(J))*G1(I)
      SUM2 = SUM2 + (2.*F(I) + F(J))*G2(I)
      SUM3 = SUM3 + (2.*F(I) - F(J))*G3(I)
      SUM4 = SUM4 + (2.*F(I) - F(J))*G4(I)
  15  CONTINUE
C
      DTG = TG - T
      D2 = EXP(-DTG) - DTG*E1(DTG)
      S(K) = EXP(-T/U0) + C1*D2 + 2.*(SUM1 - SUM3)
     2  + 4.*ALB*D2*(SUM2 - SUM4)
  20  CONTINUE
C
C ***** COMPUTE APPROXIMATE INTENSITIES AT LARGE OPTICAL DEPTHS *****
      IF(LZ.EQ.NZ) RETURN                                 
      LZ1 = LZ + 1
      DO 24 L=LZ1,NZ
      K = NZ - L + 1
      DTAB = TAB(K) - TAB(MZ)
      S(K) = S(MZ)*EXP(-DTAB/U0)
  24  CONTINUE
C
      RETURN
      END
      FUNCTION SIGRAY(W)
      W1 = 1.E-4 * W
      W2 = W1 * W1
      W4 = W2 * W2
      SIGRAY = 4.006E-28*(1. + .0113/W2 + .00013/W4)/W4
      RETURN
      END
      FUNCTION E1(X)
      COMMON/EBLOK/A(6),B(4),C(4)
      E1 = 0.
      IF(X.EQ.0.) RETURN
C
      X2 = X*X
      X3 = X2*X
      X4 = X3*X
      IF(X.GT.1) GO TO 1
      X5 = X4*X
      E1 = -ALOG(X) + A(1)*X + A(2)*X2 + A(3)*X3 + A(4)*X4 + A(5)*X5
     2  + A(6)
      RETURN
C
   1  SUM1 = X4 + B(1)*X3 + B(2)*X2 + B(3)*X + B(4)
      SUM2 = X4 + C(1)*X3 + C(2)*X2 + C(3)*X + C(4)
      E1 = EXP(-X)*SUM1/SUM2/X
      RETURN
      END
C-PK ****************************
      SUBROUTINE TWOSTR(SIGR,U0,SO3,SO2,SCO2,SH2O,SSO2,SS2,SH2S,
     2  SNH3,WAV,NN,IKN)
C
C   This is my version of the Toon et al. 2-stream code.  (Ref.: JGR
C   94, 16287, 1989).  It vectorizes over height, rather than wavelength,
C   and is designed to work with PRIMS3 and its companion photochemical 
C   models.
C
C   For now, at least, it is hardwired as the quadrature approximation.
C     NP is the number of different types of particles
C
      PARAMETER(NZ=100, NZ1=NZ+1, NZ2=2*NZ, NP=3, NQ=39, NQT=NQ+3)
      DIMENSION SO2(NZ),SO3(NZ)
      DIMENSION TAU(NZ),TAUC(NZ1),G(NZ),GAM1(NZ),GAM2(NZ),GAM3(NZ),
     1  GAM4(NZ),ALAM(NZ),CGAM(NZ),E1(NZ),E2(NZ),E3(NZ),E4(NZ),
     2  CP0(NZ),CPB(NZ),CM0(NZ),CMB(NZ),Y1(NZ),Y2(NZ),W0(NZ), 
     3  TAUSG(NZ),TAUSP(NZ),DIRECT(NZ1),AMEAN(NZ1),TAUG(NZ),FMT(NZ),
     4  TAUSHP(NZ)
      DIMENSION A(NZ2),B(NZ2),D(NZ2),E(NZ2),Y(NZ2),FUP(NZ1),FDN(NZ1)
      DIMENSION W0P(NP),QEXT(NP)
C
      COMMON/ABLOK/EDD(NZ),DEN(NZ),DK(NQT,NZ),Z(NZ),T(NZ),G0,FSCALE,
     2  ALB,DELZ,BOVERH,DD(NQT,NZ),DL(NQT,NZ),DU(NQT,NZ),DI(NQT,NZ)
     3  ,HI(NQT,NZ),DHU(NQT,NZ),DHL(NQT,NZ)
      COMMON/CBLOK/O3(NZ),H2O(NZ),O2(NZ),CO2(NZ),DZ,ZTROP,MZ1,NPHOT,
     2  S2(NZ),FSO2(NZ),H2S(NZ),FNH3(NZ),CH4(NZ),C2H6(NZ),JTROP
      COMMON/TBLOK/TTOT(NZ),TCO2(NZ),TO2(NZ),TH2O(NZ),TO3(NZ),S(NZ)
     2  ,TSO2(NZ),TS2(NZ),TH2S(NZ),TNH3(NZ),TCH4(NZ),TC2H6(NZ)
      COMMON/AERBLK/WFALL(NZ,3),AERSOL(NZ,3),RPAR(NZ,3),HSCALE(NZ),       
     2  CONVER(NZ,3),TAUEDD(NZ),TAUSED(NZ,3),TAUCS(NZ,3),
     3  DTAUHC(108,NZ),NBEER
      COMMON/MIE/QEXTC(NZ), W0TC(NZ), GFC(NZ)
C
C     U1 = 0.5  (Eddington value)
      SQ3 = SQRT(3.)
      PI = 3.14159
      U1 = 1./SQ3
      U0M = 1./U0
      U0M2 = U0M*U0M
      U1M = 1./U1
      GP = 0.8
      NZM1 = NZ - 1
      MZ2 = NZ2
C
C   Particle 1 is sulfate, 2 is S8, 3 is HCAER
      W0P(1) = 1.
      W0P(2) = 0.5
      IF (WAV .GT. 3500.) W0P(2) = 1.
C make hydrocarbon particles absorbing in UV
C-AP      W0P(3) = 0.5
C-AP      IF (WAV .GT. 4000.) W0P(3) = 1.
C-AP      DO 20 J=1,NP
      DO 20 J=1,2
  20  QEXT(J) = 2.
C   Above value of Qext is valid for large particles
C   Set Qext for hydrocarbon aerosols (smaller initial radius)
c     QEXT(3) = ?
C
C   Calculate the optical depths of the different layers.  TAUA is absorption,
C   TAUSG is scattering by gases, TAUSP is scattering by particles, TAUG is
C   extinction due to gases, TAU is total extinction due to gases and
C   particles.  
C   Note that the grid for this subroutine is numbered from top to bottom,
c   whereas the main program is numbered from bottom to top.
C   First do gases 
      DO 21 I=1,NZ
      N = NZ1 - I
      TAUSP(N) = 0.
      TAUSHP(N) = 0.
      TAUSG(N) = SIGR*DEN(I)*DZ
      TAUA = ( SO3(I)*O3(I) + SO2(I)*O2(I) + SCO2*CO2(I) + SH2O*H2O(I)
     2   + SSO2*FSO2(I) + SS2*S2(I) + SH2S*H2S(I) + SNH3*FNH3(I) ) 
     3   * DEN(I)*DZ
  21  TAUG(N) = TAUA + TAUSG(N)
C
C   Now do particles.  Must combine their scattering optical depths into a
C   single array in order to calculate W0 and G.  (TAUSP(N))
C   Don't need any arrays for pure absorption.
C   Scale optical depth, W0, and G for the particles using the Delta-
C   Eddington approximation of Joseph et al. (Ref: J. Atmos. Sci. 33,
C   2452, 1976)
C
      DO 23 J=1,NP
c Use following statement only when ignoring absorption by HCAER
C      DO 23 J=1,2
      DO 23 I=1,NZ
      N = NZ1 - I
C-AP Now we are including correct value of Qext and W0P for hydrocarbons
      IF (J .EQ. 3) THEN
       QEXT(J) = QEXTC(I)
       W0P(J) = W0TC(I)
      ENDIF
C-AP 
      TAUP = QEXT(J)*PI*RPAR(I,J)*RPAR(I,J)*AERSOL(I,J)*DZ
      TAUSP(N) = TAUSP(N) + W0P(J)*TAUP
      IF (J .EQ. 3) THEN
       TAUSHP(N) = TAUSHP(N) + W0P(J)*TAUP
      ENDIF
  23  TAU(N) = TAUG(N) + TAUP
C
C   Calculate W0 and G by averaging over Rayleigh and Mie scatterers.  
C   (scattering due to gases vs. particles)
C   Avoid letting W0 equal exactly 1.
      DO 22 N=1,NZ
      W0(N) = (TAUSG(N) + TAUSP(N))/TAU(N)
      W0(N) = AMIN1(W0(N), 0.999)
      TSRAT1 = (TAUSP(N)-TAUSHP(N))/(TAUSP(N) + TAUSG(N))
      TSRAT2 = TAUSHP(N)/(TAUSP(N) + TAUSG(N))
C-AP since GFC is still from bottom to top we need a switch
      I = NZ1 - N
  22  G(N) = GP*TSRAT1 + GFC(I)*TSRAT2
C
C   Delta-Eddington scaling
C-AP I used approximation from Joseph et al. 1976
      DO 24 N=1,NZ
      FMT(N) = G(N)*G(N) 
      TAU(N) = TAU(N)*(1. - W0(N)*FMT(N))
      W0(N) = W0(N)*(1. - FMT(N))/(1. - W0(N)*FMT(N))
  24  G(N) = G(N)/(1. + G(N))
C-AP**************************************************
C
C   Calculate the gamma's, lambda's, and e's
      DO 2 N=1,NZ
C     GAM1(N) = (7. - W0(N)*(4.+3.*G(N)))/4.
C     GAM2(N) = - (1. - W0(N)*(4.-3.*G(N)))/4.
C     GAM3(N) = (2. - 3.*G(N)*U0)/4.
C   (Eddington values above; quadrature values below)
C
      GAM1(N) = SQ3*(2. - W0(N)*(1.+G(N)))/2.
      GAM2(N) = SQ3*W0(N)*(1.-G(N))/2.
      GAM3(N) = (1. - SQ3*G(N)*U0)/2.
      GAM4(N) = 1. - GAM3(N)
C
      ALAM(N) = SQRT(GAM1(N)*GAM1(N) - GAM2(N)*GAM2(N))
      CGAM(N) = (GAM1(N) - ALAM(N))/GAM2(N)
      EMLT = EXP(-ALAM(N)*TAU(N))
C
      E1(N) = 1. + CGAM(N)*EMLT
      E2(N) = 1. - CGAM(N)*EMLT
      E3(N) = CGAM(N) + EMLT
   2  E4(N) = CGAM(N) - EMLT
C
C   Calculate A, B, and D, i.e. the coefficients of the tridiagonal
C      matrix
C   Top of atmosphere
      A(1) = 0.
      B(1) = E1(1)
      D(1) = -E2(1)
C
C   Odd coefficients
      DO 3 N=1,NZM1
      L = 2*N + 1
      A(L) = E2(N)*E3(N) - E4(N)*E1(N)
      B(L) = E1(N)*E1(N+1) - E3(N)*E3(N+1)
   3  D(L) = E3(N)*E4(N+1) - E1(N)*E2(N+1)
C
C   Even coefficients
      DO 4 N=1,NZM1
      L = 2*N
      A(L) = E2(N+1)*E1(N) - E3(N)*E4(N+1)
      B(L) = E2(N)*E2(N+1) - E4(N)*E4(N+1)
   4  D(L) = E1(N+1)*E4(N+1) - E2(N+1)*E3(N+1)
C
C   Bottom of atmosphere
      A(NZ2) = E1(NZ) - ALB*E3(NZ)
      B(NZ2) = E2(NZ) - ALB*E4(NZ)
      D(NZ2) = 0.
C
C   Now, set up the RHS of the equation:
C   TAUC(N) is the optical depth above layer N
      TAUC(1) = 0.
      DO 5 N=2,NZ1
   5  TAUC(N) = TAUC(N-1) + TAU(N-1)
C On last call,
C Print out TAUC(N), TAU(N), W0(N), G(N), TAUSG(N), TAUSP(N).
C Also print TAUC at the ground for all wavelengths.
C
      IF(NN.EQ.1 .AND. IKN.EQ.1) THEN
      WRITE(22,114) WAV,TAUC(NZ1)
 114  FORMAT(1X,F6.1,2X,1PE10.3)
      IF (WAV.EQ.1860.5 .OR. WAV.EQ.2010. .OR. WAV.EQ.2116.5 .OR.
     2    WAV.EQ.2211. .OR. WAV.EQ.2312.5 .OR. WAV.EQ.2516. .OR.
     3    WAV.EQ.3007.5 .OR. WAV.EQ.3900. .OR. WAV.EQ.4500.) THEN
      WRITE(20,106)WAV,U0,ALB
 106  FORMAT('# WAV = ',F6.1,2X,'U0 = ',F6.4,2X,'Rsfc = ',F5.3,
     2   /'# TWOSTR: TAUC(N) is the optical depth above layer N',
     3   /'#  Z',4X,'TAUC(N)',4X,'TAU(N)',5X,'W0(N)',6X,'G(N)',6X,
     4   'TAUSG(N)',3X,'TAUSP(N)',3X,'N')
      DO 113 N=1,NZ
      I = NZ1 - N
      WRITE(20,107) I,TAUC(N),TAU(N),W0(N),G(N),TAUSG(N),TAUSP(N),N
 107  FORMAT(1X,I3,1P6E11.3,1X,I3)
 113  CONTINUE
      WRITE(20,105)TAUC(NZ1)
 105  FORMAT('#  0',1PE11.3)
      ENDIF
      ENDIF
C
C   DIRECT(N) is the direct solar flux at the top of layer N.  Values
C   are normalized to unity.  DIRECT(NZ1) is the direct flux at the ground.
      DIRECT(1) = 1.
      DO 6 N=1,NZ
      ET0 = EXP(-TAUC(N)/U0)
      ETB = ET0 * EXP(-TAU(N)/U0)
      DIRECT(N+1) = ETB
      DENOM = ALAM(N)*ALAM(N) - U0M2
      FACP = W0(N) * ((GAM1(N)-U0M)*GAM3(N) + GAM4(N)*GAM2(N))
      FACM = W0(N) * ((GAM1(N)+U0M)*GAM4(N) + GAM2(N)*GAM3(N))
C
      CP0(N) = ET0*FACP/DENOM
      CPB(N) = ETB*FACP/DENOM
      CM0(N) = ET0*FACM/DENOM
   6  CMB(N) = ETB*FACM/DENOM
      SSFC = ALB*U0*DIRECT(NZ1)
C
C   Odd coefficients
      E(1) = - CM0(1)
      DO 7 N=1,NZM1
      L = 2*N + 1
   7  E(L) = (CP0(N+1)-CPB(N))*E3(N) + (CMB(N)-CM0(N+1))*E1(N)
C
C   Even coefficients
      DO 8 N=1,NZM1
      L = 2*N
   8  E(L) = (CP0(N+1)-CPB(N))*E2(N+1) - (CM0(N+1)-CMB(N))*E4(N+1)
      E(NZ2) = SSFC - CPB(NZ) + ALB*CMB(NZ)
C
C   Call the tridiagonal solver (from LINPACK).  E is the RHS of the matrix
C   equation on input and is the solution vector Y on output
      CALL SGTSL(MZ2,A,B,D,E,NFLAG)
      IF (NFLAG .NE. 0) PRINT 100, NFLAG
 100  FORMAT(/1X,'Tridiagonal solver failed in TWOSTR, NFLAG =',I4)
C
      DO 9 N=1,NZ
      L = 2*N
      L1 = L-1
      Y1(N) = E(L1)
   9  Y2(N) = E(L)
C
C   Calculate the mean intensities, AMEAN(N), at the boundaries between
C   the layers.  AMEAN(N) is the intensity at the top of layer N.
      AMEAN(1) = U1M * (Y1(1)*E3(1) - Y2(1)*E4(1) + CP0(1)) + 1.
      DO 10 N=1,NZ
  10  AMEAN(N+1) = U1M * (Y1(N)*(E1(N)+E3(N)) + Y2(N)*(E2(N)+E4(N)) 
     1  + CPB(N) + CMB(N)) + DIRECT(N+1)
C
C   Reset any AMEAN values that may go negative.  Check error file
C   to be sure this only happens near the ground where AMEAN ~ 0.
      DO 12 N=1,NZ1 
      IF(AMEAN(N).LT.0.0)THEN
         WRITE(13,103) WAV,N,AMEAN(N)
 103     FORMAT('WAVE =',F6.1,' AMEAN(',I3,')=',1PE11.3)
         AMEAN(N) = ABS(AMEAN(N))
      ENDIF
  12  CONTINUE
C
C  Calculate upward and downward fluxes.
C 
      FUP(1) = ((Y1(1)*E3(1) - Y2(1)*E4(1)) + CP0(1))
      FDN(1) = DIRECT(1)
      DO 110 N=1,NZ
         FUP(N+1) = (Y1(N)*E1(N) + Y2(N)*E2(N)
     &     + CPB(N))
         FDN(N+1) = (Y1(N)*E3(N) + Y2(N)*E4(N)
     &     + CMB(N)) + DIRECT(N+1)
 110  CONTINUE
C
C   Convert back to main program grid.  S(I) is the mean intensity at the
C   midpoint of layer I.
      DO 11 I=1,NZ
      N = NZ1 - I
  11  S(I) = SQRT(AMEAN(N)*AMEAN(N+1))
C
C  Print out the results at a few wavelengths
C
      IF(NN.EQ.1 .AND. IKN.EQ.1) THEN
      IF (WAV.EQ.1860.5 .OR. WAV.EQ.2010. .OR. WAV.EQ.2116.5 .OR.
     2    WAV.EQ.2211. .OR. WAV.EQ.2312.5 .OR. WAV.EQ.2516. .OR.
     3    WAV.EQ.3007.5 .OR. WAV.EQ.3900. .OR. WAV.EQ.4500.) THEN
      WRITE(21,108)WAV,U0,ALB
 108  FORMAT(/'# WAV = ',F6.1,2X,'U0 = ',F6.4,2X,'Rsfc = ',F5.3,
     2  /'#  Z',4X,'S(Z)',7X,'Y1',9X,'Y2',
     3  9X,'DIRECT',5X,'AMEAN',6X,'FUP',8X,'FDN',7X,'N')
      DO 111 N=1,NZ
      I = NZ1 - N
      WRITE(21,109) I,S(I),Y1(N),Y2(N),DIRECT(N),AMEAN(N),
     2  FUP(N),FDN(N),N
 109  FORMAT(1X,I3,1P7E11.3,1X,I3)
 111  CONTINUE
      WRITE(21,112) DIRECT(NZ1),AMEAN(NZ1),FUP(NZ1),FDN(NZ1)
 112  FORMAT('#',36X,1P4E11.3)
      ENDIF
      ENDIF
C
      RETURN
      END
C-PK ***************************************
      SUBROUTINE VDEP_CO
      PARAMETER (N=4,NP=4,NQ=39)
      DIMENSION A(N,NP), B(N), INDX(N), U(NQ)
      COMMON/VBLOK/VDEPCO,U(NQ)
      REAL KHY,KDECSFC,KREVHYSFC,KACET,KREVHYDP,KB,NCO

C-PK  This subroutine computes the deposition velocity of CO based on
C-PK  a 2-box model of the ocean (surface and deep layers).  It
C-PK  incorporates formate decay in both layers but not temp. and pH
C-PK  gradients between the layers. It represents the abiotic case.

C-PK  Explanations for values used
C-PK  ALPHA = Henry's Law constant for CO (from?...2-box notes)
C-PK  KHYD = hydration constant for CO (from Penfield et al.)
C-PK  pH = 8 --> [OH] = 10^(-8)
C-PK
C-PK
C-PK
C-PK
C-PK
C-PK
C-PK
C-PK

C-PK  Allow user input of temperature
C-PK  PRINT*, 'Enter temperature in K'
C-PK  READ*,T
C-PK  (Try initial T = 298 K)
      T = 298.
C-PK  Need starting value of pCO (for now, use value from code)
C-PK  PCO = 1.E-4
      PCO = U(9)
C-PK  PRINT*,'**** PCO=U(K)=',PCO,'****'
C-PK  Constants
      ALPHA = 8.E-4
      OHCONC = 1.E-8
      DCO = 1.9E-5
      ZBOUND = 4.E-3
      VPIS = DCO/ZBOUND
      KB = 1.38E-16
      NCO = PCO*1.013E6*1000./(KB*T*6.02E23)
C-PK  Values for ocean depths (should we adapt from Tyrrell?)
      ZS = 1.E4
      ZD = 3.9E5
      TOVER = 3.16E10
      VOVER = ZD/TOVER
C-PK ***Rate constants***
C-PK  (From papers by Penfield et al. on CO hydration and formate
C-PK  decomposition)
      KHY = EXP(-10570./T + 25.6)
      KDECSFC = 6.7E-5
      KREVHYSFC = 0.96*KDECSFC
      KACET = 0.04*KDECSFC
      KREVHYDP = 8.04E-14

C-PK  Define matrices and solve for CO and HCOO- in sfc, dp
      A(1,1) = VPIS + KHY*OHCONC*ZS + VOVER
      A(2,1) = -VOVER
      A(3,1) = -KHY*OHCONC*ZS
      A(4,1) = 0.
      A(1,2) = -KREVHYSFC*ZS
      A(2,2) = 0.
      A(3,2) = KREVHYSFC*ZS + KACET*ZS + VOVER
      A(4,2) = -VOVER
      A(1,3) = -VOVER
      A(2,3) = VOVER + KHY*OHCONC*ZD
      A(3,3) = 0.
      A(4,3) = -KHY*OHCONC*ZD
      A(1,4) = 0.
      A(2,4) = -KREVHYDP*ZD
      A(3,4) = -VOVER
      A(4,4) = VOVER + KREVHYDP*ZD
C-PK  PRINT*,'A=',A

      B = (/VPIS*ALPHA*PCO, 0., 0., 0./)

      CALL LUDCMP(A,N,NP,INDX,D)
      CALL LUBKSB(A,N,NP,INDX,B)
C-PK  PRINT*,'B = ',B

C-PK  Calculate CO deposition velocity
      VDEPCO = (VPIS*ALPHA*PCO - VPIS*B(1))/NCO

C-PK  PRINT *, 'VDEPCO =', VDEPCO, 'cm/s'

      END SUBROUTINE VDEP_CO

C-PK ****************************************

      SUBROUTINE LUDCMP(A,N,NP,INDX,D)
      PARAMETER (NMAX=100,TINY=1.0E-20)
      DIMENSION A(NP,NP), INDX(N), VV(NMAX)
      D=1.
      DO 42 I=1,N
        AAMAX=0.
        DO 41 J=1,N
          IF (ABS(A(I,J)).GT.AAMAX) AAMAX=ABS(A(I,J))
41      CONTINUE
        IF (AAMAX.EQ.0.) PAUSE 'Singular matrix.'
        VV(I)=1./AAMAX
42    CONTINUE
      DO 49 J=1,N
        IF (J.GT.1) THEN
          DO 44 I=1,J-1
            SUM=A(I,J)
            IF (I.GT.1)THEN
              DO 43 K=1,I-1
                SUM=SUM-A(I,K)*A(K,J)
43            CONTINUE
              A(I,J)=SUM
            ENDIF
44        CONTINUE
        ENDIF
        AAMAX=0.
        DO 46 I=J,N
          SUM=A(I,J)
          IF (J.GT.1)THEN
            DO 45 K=1,J-1
              SUM=SUM-A(I,K)*A(K,J)
45          CONTINUE
            A(I,J)=SUM
          ENDIF
          DUM=VV(I)*ABS(SUM)
          IF (DUM.GE.AAMAX) THEN
            IMAX=I
            AAMAX=DUM
          ENDIF
46      CONTINUE
        IF (J.NE.IMAX)THEN
          DO 47 K=1,N
            DUM=A(IMAX,K)
            A(IMAX,K)=A(J,K)
            A(J,K)=DUM
47        CONTINUE
          D=-D
          VV(IMAX)=VV(J)
        ENDIF
        INDX(J)=IMAX
        IF(J.NE.N)THEN
          IF(A(J,J).EQ.0.)A(J,J)=TINY
          DUM=1./A(J,J)
          DO 48 I=J+1,N
            A(I,J)=A(I,J)*DUM
48        CONTINUE
        ENDIF
49    CONTINUE
      IF(A(N,N).EQ.0.)A(N,N)=TINY
      RETURN
      END SUBROUTINE LUDCMP

C-PK ****************************************

      SUBROUTINE LUBKSB(A,N,NP,INDX,B)
      DIMENSION A(NP,NP),INDX(N),B(N)

      II=0
      DO 112 I=1,N
        LL=INDX(I)
        SUM=B(LL)
        B(LL)=B(I)
        IF (II.NE.0)THEN
          DO 111 J=II,I-1
            SUM=SUM-A(I,J)*B(J)
111        CONTINUE
        ELSE IF (SUM.NE.0.) THEN
          II=I
        ENDIF
        B(I)=SUM
112    CONTINUE
      DO 114 I=N,1,-1
        SUM=B(I)
        IF(I.LT.N)THEN
          DO 113 J=I+1,N
            SUM=SUM-A(I,J)*B(J)
113        CONTINUE
        ENDIF
        B(I)=SUM/A(I,I)
114    CONTINUE
      RETURN
      END SUBROUTINE LUBKSB

*******************************************
      SUBROUTINE H2AQ
      PARAMETER (NQ=39,NQT=NQ+3,NZ=100)
      COMMON/BBLOK/USOL(NQ,NZ),AMIXCO2,AMIXN2
      COMMON/H2COBLOK/FLOW(NQT),VPHOTO_H2,VPHOTO_CO

C-PK  This subroutine calculates the concentration of dissolved H2 
C-PK  based on free energy considerations applied to the reaction
C-PK      CO2 + 4H2 --> CH4 + 2H2O (H2-based methanogenesis).
C-PK  It follows Kral et al.,OLEB,1998 and Kasting et al.,OLEB,2001.
C-PK  It uses the following Gibbs free energy relation:
C-PK      DG = DG0 + RTlnQ ("precursor" to Nernst equation)
C-PK  Used T = 25C for now, but have incorporated temp dependence in DG0
      T = 298.
C-PK  Use DG = 30 since that is energy needed to make 1 ATP
      DELTA_G = -30.
      DELTA_G0 = -253. + 0.41*T
      R = 0.008314
      Q = EXP((DELTA_G - DELTA_G0)/(R*T))
C-PK      PRINT *,'Q=',Q
  
      ALPHA_CO2 = 3.4E-2
      CO2_aq = ALPHA_CO2*AMIXCO2

      ALPHA_CH4 = 1.4E-3
      SCALE = 6.02E20
      DIFF_CH4 = 1.8E-5
      Z_FILM = 4.E-3
      EQUIL_CH4 = ALPHA_CH4*USOL(12,1)
      VPIS_CH4 = DIFF_CH4/Z_FILM
C-PK  Calculate [CH4]aq assuming piston velocity formulation for CH4 flux:
C-PK     PHI_CH4 = VPIS_CH4 * SCALE * ([CH4]aq - ALPHA_CH4*pCH4)
      CH4_aq = FLOW(12)/(VPIS_CH4*SCALE) + EQUIL_CH4

      ALPHA_H2 = 7.8E-4
      EQUIL_H2 = ALPHA_H2*USOL(8,1)
C-PK  [H2]aq calculated from Q = [CH4]aq*aCO2/([CO2]aq*aCH4 * ([H2]aq*aH2)^4)
      H2_aq = ALPHA_H2*(CH4_aq*ALPHA_CO2/(CO2_aq*ALPHA_CH4*Q))**0.25

      PRINT 100
 100  FORMAT(1X,'DISSOLVED CH4 AND H2 (ECO MODEL)'/)
      CH4_H2_RATIO = USOL(12,1)/USOL(8,1)
C-PK  See main program (deposition velocities section) for derivation of vmax(H2)
      VMAX_H2 = 2.4E-4
      VECO_H2 = VMAX_H2*(EQUIL_H2 - H2_aq)/EQUIL_H2
      VRATIO = VPHOTO_H2/VECO_H2
      PRINT 110, VPIS_CH4,CH4_aq,EQUIL_CH4,H2_aq,EQUIL_H2,CH4_H2_RATIO,
     2           VMAX_H2,VECO_H2,VRATIO
 110  FORMAT(5X,'VPIS(CH4) =',1PE10.3,3X,'[CH4]aq =',1PE11.4,
     2  3X,'alphaCH4*pCH4 =',1PE11.4,3X,'[H2]aq =',1PE11.4,
     3  3X,'alphaH2*pH2 =',1PE11.4,//5X,'f(CH4)/f(H2) =',1PE11.4,
     4  3X,'VMAX(H2) =',1PE11.4,3X,'VECO(H2) =',1PE11.4,
     5  3X,'VPHOTO(H2):VECO(H2) =',1PE11.4/)

      RETURN
      END SUBROUTINE H2AQ

*******************************************
      SUBROUTINE COaq
      PARAMETER (NQ=39,NQT=NQ+3,NZ=100)
      COMMON/BBLOK/USOL(NQ,NZ),AMIXCO2,AMIXN2
      COMMON/H2COBLOK/FLOW(NQT),VPHOTO_H2,VPHOTO_CO

C-PK  This subroutine calculates the concentration of dissolved CO 
C-PK  based on free energy considerations applied to the net reaction
C-PK     4CO + 2H2O --> 3CO2 + CH4 (CO-consuming acetogenesis +
C-PK                                acetotrophic methanogenesis)
C-PK  It follows Kral et al.,OLEB,1998 and Kasting et al.,OLEB,2001.
C-PK  It uses the following Gibbs free energy relation:
C-PK      DG = DG0 + RTlnQ ("precursor" to Nernst equation)
C-PK  Used T = 25C for now, but have incorporated temp dependence in DG0
      T = 298.
C-PK  Use DG = 60 kJ (for rxn) since that is total energy needed 
C-PK  to make ATP from the 2 reactions (acetogenesis + methanogenesis)
      DELTA_G = -60.
      DELTA_G0 = -241.5 + 0.104*T
      R = 0.008314
      Q = EXP((DELTA_G - DELTA_G0)/(R*T))
C-PK      PRINT *,'Q=',Q
  
C-PK  ALPHA_CO2 = 3.4E-2
C-PK  CO2_aq = ALPHA_CO2*AMIXCO2

      ALPHA_CH4 = 1.4E-3
      SCALE = 6.02E20
      DIFF_CH4 = 1.8E-5
      Z_FILM = 4.E-3
      EQUIL_CH4 = ALPHA_CH4*USOL(12,1)
      VPIS_CH4 = DIFF_CH4/Z_FILM
C-PK  Calculate [CH4]aq assuming piston velocity formulation for CH4 flux:
C-PK     PHI_CH4 = VPIS_CH4 * SCALE * ([CH4]aq - ALPHA_CH4*pCH4)
      CH4_aq = FLOW(12)/(VPIS_CH4*SCALE) + EQUIL_CH4

      ALPHA_CO = 1.E-3
      EQUIL_CO = ALPHA_CO*USOL(9,1)
C-PK  [CO]aq calculated from Q = (pCO2)^3*([CH4]aq/aCH4)/([CO]aq/aCO)^4
      CO_aq = ALPHA_CO*((AMIXCO2)**3 * CH4_aq/(ALPHA_CH4*Q))**0.25

      PRINT 100
 100  FORMAT(1X,'DISSOLVED CO (ECO MODEL)'/)
      CH4_CO_RATIO = USOL(12,1)/USOL(9,1)
C-PK  See main program (deposition velocities section) for derivation of vmax'es
      VMAX_CO = 1.2E-4
      VECO_CO = VMAX_CO*(EQUIL_CO - CO_aq)/EQUIL_CO
      VRATIO = VPHOTO_CO/VECO_CO
      PRINT 110, CO_aq,EQUIL_CO,CH4_CO_RATIO,VMAX_CO,VECO_CO,VRATIO
 110  FORMAT(5X,'[CO]aq =',1PE11.4,3X,'alphaCO*pCO =',1PE11.4,
     2  3X,'f(CH4)/f(CO) =',1PE11.4,3X,//5X,'VMAX(CO) =',1PE11.4,
     3  3X,'VECO(CO) =',1PE11.4,3X,'VPHOTO(CO):VECO(CO) =',1PE11.4/)

      RETURN
      END SUBROUTINE COaq


